// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.serde.json');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.log');
fluree.db.serde.json.deserialize_block = (function fluree$db$serde$json$deserialize_block(block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,cljs.core.cst$kw$flakes,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.parts__GT_Flake,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(block)));
});
/**
 * Turns :first and :rhs into flakes
 */
fluree.db.serde.json.deserialize_child_node = (function fluree$db$serde$json$deserialize_child_node(child_node){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(child_node,cljs.core.cst$kw$first,(function (){var G__135171 = cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(child_node);
if((G__135171 == null)){
return null;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(G__135171);
}
})(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$rhs,(function (){var G__135172 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(child_node);
if((G__135172 == null)){
return null;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(G__135172);
}
})()], 0));
});
fluree.db.serde.json.deserialize_db_root = (function fluree$db$serde$json$deserialize_db_root(db_root){
var map__135173 = db_root;
var map__135173__$1 = (((((!((map__135173 == null))))?(((((map__135173.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__135173.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__135173):map__135173);
var spot = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__135173__$1,cljs.core.cst$kw$spot);
var psot = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__135173__$1,cljs.core.cst$kw$psot);
var post = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__135173__$1,cljs.core.cst$kw$post);
var opst = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__135173__$1,cljs.core.cst$kw$opst);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db_root,cljs.core.cst$kw$spot,fluree.db.serde.json.deserialize_child_node(spot),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$psot,fluree.db.serde.json.deserialize_child_node(psot),cljs.core.cst$kw$post,fluree.db.serde.json.deserialize_child_node(post),cljs.core.cst$kw$opst,fluree.db.serde.json.deserialize_child_node(opst)], 0));
});
fluree.db.serde.json.deserialize_branch_node = (function fluree$db$serde$json$deserialize_branch_node(branch){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(branch,cljs.core.cst$kw$children,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.serde.json.deserialize_child_node,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(branch)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$rhs,(function (){var G__135175 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(branch);
if((G__135175 == null)){
return null;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(G__135175);
}
})()], 0));
});
fluree.db.serde.json.deserialize_leaf_node = (function fluree$db$serde$json$deserialize_leaf_node(leaf){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(leaf,cljs.core.cst$kw$flakes,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.parts__GT_Flake,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(leaf)));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.serde.protocol.StorageSerializer}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.serde.json.Serializer = (function (__meta,__extmap,__hash){
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.serde.json.Serializer.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.serde.json.Serializer.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k135177,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__135181 = k135177;
switch (G__135181) {
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k135177,else__4388__auto__);

}
});

fluree.db.serde.json.Serializer.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__135182){
var vec__135183 = p__135182;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__135183,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__135183,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.serde.json.Serializer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.serde.json.Serializer{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,self__.__extmap));
});

fluree.db.serde.json.Serializer.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__135176){
var self__ = this;
var G__135176__$1 = this;
return (new cljs.core.RecordIter((0),G__135176__$1,0,cljs.core.PersistentVector.EMPTY,(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.serde.json.Serializer.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.serde.json.Serializer.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.serde.json.Serializer(self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.serde.json.Serializer.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (0 + cljs.core.count(self__.__extmap));
});

fluree.db.serde.json.Serializer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__135186 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (1505122844 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__135186(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.serde.json.Serializer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this135178,other135179){
var self__ = this;
var this135178__$1 = this;
return (((!((other135179 == null)))) && ((this135178__$1.constructor === other135179.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135178__$1.__extmap,other135179.__extmap)));
});

fluree.db.serde.json.Serializer.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(cljs.core.PersistentHashSet.EMPTY,k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.serde.json.Serializer(self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.serde.json.Serializer.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__135176){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__135187 = cljs.core.keyword_identical_QMARK_;
var expr__135188 = k__4393__auto__;
return (new fluree.db.serde.json.Serializer(self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__135176),null));
});

fluree.db.serde.json.Serializer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,self__.__extmap));
});

fluree.db.serde.json.Serializer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__135176){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.serde.json.Serializer(G__135176,self__.__extmap,self__.__hash));
});

fluree.db.serde.json.Serializer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_block$arity$2 = (function (_,block){
var self__ = this;
var ___$1 = this;
return fluree.db.serde.json.deserialize_block(fluree.db.util.json.parse(block));
});

fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_branch$arity$2 = (function (_,branch){
var self__ = this;
var ___$1 = this;
return fluree.db.serde.json.deserialize_branch_node(fluree.db.util.json.parse(branch));
});

fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_garbage$arity$2 = (function (_,garbage){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-garbage not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_db_pointer$arity$2 = (function (_,pointer){
var self__ = this;
var ___$1 = this;
return fluree.db.util.json.parse(pointer);
});

fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_db_root$arity$2 = (function (_,db_root){
var self__ = this;
var ___$1 = this;
return fluree.db.serde.json.deserialize_db_root(fluree.db.util.json.parse(db_root));
});

fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_branch$arity$2 = (function (_,branch){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-branch not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_garbage$arity$2 = (function (_,garbage){
var self__ = this;
var ___$1 = this;
return fluree.db.util.json.parse(garbage);
});

fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_leaf$arity$2 = (function (_,leaf){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-leaf not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_db_pointer$arity$2 = (function (_,pointer){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-db-pointer not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_leaf$arity$2 = (function (_,leaf){
var self__ = this;
var ___$1 = this;
return fluree.db.serde.json.deserialize_leaf_node(fluree.db.util.json.parse(leaf));
});

fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_db_root$arity$2 = (function (_,db_root){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-db-root not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_block$arity$2 = (function (_,block){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-block not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.serde.json.Serializer.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

fluree.db.serde.json.Serializer.cljs$lang$type = true;

fluree.db.serde.json.Serializer.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.serde.json/Serializer",null,(1),null));
});

fluree.db.serde.json.Serializer.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.serde.json/Serializer");
});

/**
 * Positional factory function for fluree.db.serde.json/Serializer.
 */
fluree.db.serde.json.__GT_Serializer = (function fluree$db$serde$json$__GT_Serializer(){
return (new fluree.db.serde.json.Serializer(null,null,null));
});

/**
 * Factory function for fluree.db.serde.json/Serializer, taking a map of keywords to field values.
 */
fluree.db.serde.json.map__GT_Serializer = (function fluree$db$serde$json$map__GT_Serializer(G__135180){
var extmap__4424__auto__ = (function (){var G__135190 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(G__135180);
if(cljs.core.record_QMARK_(G__135180)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__135190);
} else {
return G__135190;
}
})();
return (new fluree.db.serde.json.Serializer(null,cljs.core.not_empty(extmap__4424__auto__),null));
});

/**
 * Returns a JSON serializer / deserializer
 */
fluree.db.serde.json.json_serde = (function fluree$db$serde$json$json_serde(){
return fluree.db.serde.json.__GT_Serializer();
});
