// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.token_auth');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.crypto');
goog.require('fluree.crypto.hmac');
goog.require('fluree.crypto.scrypt');
goog.require('fluree.crypto.secp256k1');
goog.require('alphabase.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('clojure.string');
fluree.db.token_auth.base64__GT_base64url = (function fluree$db$token_auth$base64__GT_base64url(b64){
return clojure.string.replace(clojure.string.replace(clojure.string.replace(b64,/=+$/,""),/\+/,"-"),/\//,"_");
});
fluree.db.token_auth.jwt_header = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$alg,"HS256",cljs.core.cst$kw$typ,"JWT"], null);
fluree.db.token_auth.jwt_header_enc = fluree.db.token_auth.base64__GT_base64url(alphabase.core.bytes__GT_base64(fluree.db.util.json.stringify_UTF8(fluree.db.token_auth.jwt_header)));
/**
 * Generates jwt signature as base64URL using secret given a string token.
 */
fluree.db.token_auth.generate_jwt_sig = (function fluree$db$token_auth$generate_jwt_sig(secret,token){
return fluree.db.token_auth.base64__GT_base64url(alphabase.core.bytes__GT_base64(fluree.crypto.hmac.hmac_sha256(alphabase.core.string__GT_bytes(token),secret)));
});
/**
 * Generates a HS256 JWT token containing data as a map and secured with secret.
 */
fluree.db.token_auth.generate_jwt = (function fluree$db$token_auth$generate_jwt(secret,payload){
var data_enc = fluree.db.token_auth.base64__GT_base64url(alphabase.core.bytes__GT_base64(fluree.db.util.json.stringify_UTF8(payload)));
var token = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.token_auth.jwt_header_enc),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_enc)].join('');
var hs256 = fluree.db.token_auth.generate_jwt_sig(secret,token);
return [token,".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(hs256)].join('');
});
/**
 * Returns the JWT payload as map if valid, else an exception.
 */
fluree.db.token_auth.verify_jwt = (function fluree$db$token_auth$verify_jwt(secret,jwt){
var vec__137816 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(jwt,/\./);
var header = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__137816,(0),null);
var payload = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__137816,(1),null);
var sig = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__137816,(2),null);
var header_STAR_ = (function (){try{return fluree.db.util.json.parse(alphabase.core.base64__GT_bytes(header));
}catch (e137819){if((e137819 instanceof java.lang.Exception)){
var e = e137819;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid JWT header.",new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(401),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_token,cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$reason,e.getMessage()], null)], null));
} else {
throw e137819;

}
}})();
var token = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(header),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(payload)].join('');
var sig_STAR_ = fluree.db.token_auth.generate_jwt_sig(secret,token);
var _ = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(header_STAR_,fluree.db.token_auth.jwt_header))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid JWT header. Only HS256 algorithm supported.",new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(401),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_token,cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$header,header_STAR_], null)], null))})():null);
var ___$1 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(sig_STAR_,sig))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid JWT signature.",new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(401),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_token,cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$jwt,jwt], null)], null))})():null);
var payload_STAR_ = (function (){try{return fluree.db.util.json.parse(alphabase.core.base64__GT_bytes(payload));
}catch (e137820){if((e137820 instanceof java.lang.Exception)){
var e = e137820;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid JWT payload.",new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(401),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_token,cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$reason,e.getMessage()], null)], null));
} else {
throw e137820;

}
}})();
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core.cst$kw$exp.cljs$core$IFn$_invoke$arity$1(payload_STAR_);
if(cljs.core.truth_(and__4120__auto__)){
return (cljs.core.cst$kw$exp.cljs$core$IFn$_invoke$arity$1(payload_STAR_) < fluree.db.util.core.current_time_millis());
} else {
return and__4120__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("JWT has expired.",new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(401),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_expired_DASH_token,cljs.core.cst$kw$meta,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$jwt,jwt], null)], null));
} else {
}

return payload_STAR_;
});
