// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__118114 = cljs.core._EQ_;
var expr__118115 = e.getLastErrorCode();
if(cljs.core.truth_((pred__118114.cljs$core$IFn$_invoke$arity$2 ? pred__118114.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__118115) : pred__118114.call(null,goog.net.ErrorCode.NO_ERROR,expr__118115)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__118114.cljs$core$IFn$_invoke$arity$2 ? pred__118114.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__118115) : pred__118114.call(null,goog.net.ErrorCode.EXCEPTION,expr__118115)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__118114.cljs$core$IFn$_invoke$arity$2 ? pred__118114.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__118115) : pred__118114.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__118115)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__118114.cljs$core$IFn$_invoke$arity$2 ? pred__118114.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__118115) : pred__118114.call(null,goog.net.ErrorCode.ABORT,expr__118115)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__118114.cljs$core$IFn$_invoke$arity$2 ? pred__118114.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__118115) : pred__118114.call(null,goog.net.ErrorCode.TIMEOUT,expr__118115)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4120__auto__ = status;
if(cljs.core.truth_(and__4120__auto__)){
return (status > (0));
} else {
return and__4120__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__118117 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__118117,cljs.core.cst$kw$status,status);
} else {
return G__118117;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__118118 = opts;
var map__118118__$1 = (((((!((map__118118 == null))))?(((((map__118118.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__118118.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__118118):map__118118);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__118118__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118118__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118118__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__118120 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__118120__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__118120,headers], 0)):G__118120);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__118120__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__118120__$1;
}
})();
try{var G__118122_118128 = url;
var G__118123_118129 = ((function (G__118122_118128,map__118118,map__118118__$1,request_timeout,token,headers,response_chan,headers__$1){
return (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});})(G__118122_118128,map__118118,map__118118__$1,request_timeout,token,headers,response_chan,headers__$1))
;
var G__118124_118130 = "POST";
var G__118125_118131 = fluree.db.util.json.stringify(message);
var G__118126_118132 = cljs.core.clj__GT_js(headers__$1);
var G__118127_118133 = request_timeout;
goog.net.XhrIo.send(G__118122_118128,G__118123_118129,G__118124_118130,G__118125_118131,G__118126_118132,G__118127_118133);
}catch (e118121){var e_118134 = e118121;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_118134);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__118135 = opts;
var map__118135__$1 = (((((!((map__118135 == null))))?(((((map__118135.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__118135.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__118135):map__118135);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__118135__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118135__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118135__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118135__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__118135__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__118137 = cljs.core.PersistentArrayMap.EMPTY;
var G__118137__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__118137,headers], 0)):G__118137);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__118137__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__118137__$1;
}
})();
try{var G__118139_118146 = url;
var G__118140_118147 = ((function (G__118139_118146,map__118135,map__118135__$1,request_timeout,token,headers,body,output_format,response_chan,headers__$1){
return (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__118145 = output_format;
var G__118145__$1 = (((G__118145 instanceof cljs.core.Keyword))?G__118145.fqn:null);
switch (G__118145__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});})(G__118139_118146,map__118135,map__118135__$1,request_timeout,token,headers,body,output_format,response_chan,headers__$1))
;
var G__118141_118148 = "GET";
var G__118142_118149 = body;
var G__118143_118150 = cljs.core.clj__GT_js(headers__$1);
var G__118144_118151 = request_timeout;
goog.net.XhrIo.send(G__118139_118146,G__118140_118147,G__118141_118148,G__118142_118149,G__118143_118150,G__118144_118151);
}catch (e118138){var e_118153 = e118138;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_118153);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__118154 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__118154,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__118154;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_118184){
var state_val_118185 = (state_118184[(1)]);
if((state_val_118185 === (7))){
var inst_118180 = (state_118184[(2)]);
var state_118184__$1 = state_118184;
var statearr_118186_118204 = state_118184__$1;
(statearr_118186_118204[(2)] = inst_118180);

(statearr_118186_118204[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118185 === (1))){
var state_118184__$1 = state_118184;
var statearr_118187_118205 = state_118184__$1;
(statearr_118187_118205[(2)] = null);

(statearr_118187_118205[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118185 === (4))){
var inst_118158 = (state_118184[(7)]);
var inst_118158__$1 = (state_118184[(2)]);
var inst_118159 = (inst_118158__$1 == null);
var state_118184__$1 = (function (){var statearr_118188 = state_118184;
(statearr_118188[(7)] = inst_118158__$1);

return statearr_118188;
})();
if(cljs.core.truth_(inst_118159)){
var statearr_118189_118206 = state_118184__$1;
(statearr_118189_118206[(1)] = (5));

} else {
var statearr_118190_118207 = state_118184__$1;
(statearr_118190_118207[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118185 === (6))){
var inst_118158 = (state_118184[(7)]);
var inst_118166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_118158,(0),null);
var inst_118167 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_118158,(1),null);
var state_118184__$1 = (function (){var statearr_118191 = state_118184;
(statearr_118191[(8)] = inst_118166);

(statearr_118191[(9)] = inst_118167);

return statearr_118191;
})();
var statearr_118192_118208 = state_118184__$1;
(statearr_118192_118208[(2)] = null);

(statearr_118192_118208[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118185 === (3))){
var inst_118182 = (state_118184[(2)]);
var state_118184__$1 = state_118184;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118184__$1,inst_118182);
} else {
if((state_val_118185 === (2))){
var state_118184__$1 = state_118184;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118184__$1,(4),pub_chan);
} else {
if((state_val_118185 === (9))){
var inst_118167 = (state_118184[(9)]);
var inst_118168 = (state_118184[(2)]);
var inst_118169 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_118168,"Websocket send message error:",inst_118168], 0));
var inst_118170 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_118167,false);
var state_118184__$1 = (function (){var statearr_118193 = state_118184;
(statearr_118193[(10)] = inst_118169);

return statearr_118193;
})();
var statearr_118194_118209 = state_118184__$1;
(statearr_118194_118209[(2)] = inst_118170);


cljs.core.async.impl.ioc_helpers.process_exception(state_118184__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118185 === (5))){
var inst_118161 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_118184__$1 = state_118184;
var statearr_118195_118210 = state_118184__$1;
(statearr_118195_118210[(2)] = inst_118161);

(statearr_118195_118210[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118185 === (10))){
var inst_118166 = (state_118184[(8)]);
var inst_118167 = (state_118184[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_118184,(9),Error,null,(8));
var inst_118174 = ws.send(inst_118166);
var inst_118175 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_118167,true);
var state_118184__$1 = (function (){var statearr_118196 = state_118184;
(statearr_118196[(11)] = inst_118174);

return statearr_118196;
})();
var statearr_118197_118211 = state_118184__$1;
(statearr_118197_118211[(2)] = inst_118175);


cljs.core.async.impl.ioc_helpers.process_exception(state_118184__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118185 === (8))){
var inst_118177 = (state_118184[(2)]);
var state_118184__$1 = (function (){var statearr_118198 = state_118184;
(statearr_118198[(12)] = inst_118177);

return statearr_118198;
})();
var statearr_118199_118212 = state_118184__$1;
(statearr_118199_118212[(2)] = null);

(statearr_118199_118212[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__109971__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__109971__auto____0 = (function (){
var statearr_118200 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_118200[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__109971__auto__);

(statearr_118200[(1)] = (1));

return statearr_118200;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__109971__auto____1 = (function (state_118184){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_118184);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e118201){if((e118201 instanceof Object)){
var ex__109974__auto__ = e118201;
var statearr_118202_118213 = state_118184;
(statearr_118202_118213[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118184);

return cljs.core.cst$kw$recur;
} else {
throw e118201;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__118214 = state_118184;
state_118184 = G__118214;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__109971__auto__ = function(state_118184){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__109971__auto____1.call(this,state_118184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__109971__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__109971__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_118203 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_118203[(6)] = c__110077__auto__);

return statearr_118203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
ws.binaryType = "arraybuffer";

ws.onopen = ((function (ws,open_QMARK_,timeout_chan){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
});})(ws,open_QMARK_,timeout_chan))
;

ws.onmessage = ((function (ws,open_QMARK_,timeout_chan){
return (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
});})(ws,open_QMARK_,timeout_chan))
;

ws.onclose = ((function (ws,open_QMARK_,timeout_chan){
return (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
});})(ws,open_QMARK_,timeout_chan))
;

var c__110077__auto___118252 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___118252,ws,open_QMARK_,timeout_chan){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___118252,ws,open_QMARK_,timeout_chan){
return (function (state_118240){
var state_val_118241 = (state_118240[(1)]);
if((state_val_118241 === (1))){
var inst_118219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118220 = [open_QMARK_,timeout_chan];
var inst_118221 = (new cljs.core.PersistentVector(null,2,(5),inst_118219,inst_118220,null));
var state_118240__$1 = state_118240;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_118240__$1,(2),inst_118221,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_118241 === (2))){
var inst_118223 = (state_118240[(2)]);
var inst_118224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_118223,(0),null);
var inst_118225 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_118223,(1),null);
var inst_118226 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_118225,timeout_chan);
var state_118240__$1 = (function (){var statearr_118242 = state_118240;
(statearr_118242[(7)] = inst_118224);

return statearr_118242;
})();
if(inst_118226){
var statearr_118243_118253 = state_118240__$1;
(statearr_118243_118253[(1)] = (3));

} else {
var statearr_118244_118254 = state_118240__$1;
(statearr_118244_118254[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118241 === (3))){
var inst_118228 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_118229 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_118230 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_118231 = cljs.core.PersistentHashMap.fromArrays(inst_118229,inst_118230);
var inst_118232 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_118228,inst_118231);
var inst_118233 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_118232);
var inst_118234 = fluree.db.util.xhttp.close_websocket(ws);
var state_118240__$1 = (function (){var statearr_118245 = state_118240;
(statearr_118245[(8)] = inst_118233);

return statearr_118245;
})();
var statearr_118246_118255 = state_118240__$1;
(statearr_118246_118255[(2)] = inst_118234);

(statearr_118246_118255[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118241 === (4))){
var inst_118236 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_118240__$1 = state_118240;
var statearr_118247_118256 = state_118240__$1;
(statearr_118247_118256[(2)] = inst_118236);

(statearr_118247_118256[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118241 === (5))){
var inst_118238 = (state_118240[(2)]);
var state_118240__$1 = state_118240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118240__$1,inst_118238);
} else {
return null;
}
}
}
}
}
});})(c__110077__auto___118252,ws,open_QMARK_,timeout_chan))
;
return ((function (switch__109970__auto__,c__110077__auto___118252,ws,open_QMARK_,timeout_chan){
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__109971__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__109971__auto____0 = (function (){
var statearr_118248 = [null,null,null,null,null,null,null,null,null];
(statearr_118248[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__109971__auto__);

(statearr_118248[(1)] = (1));

return statearr_118248;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__109971__auto____1 = (function (state_118240){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_118240);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e118249){if((e118249 instanceof Object)){
var ex__109974__auto__ = e118249;
var statearr_118250_118257 = state_118240;
(statearr_118250_118257[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118240);

return cljs.core.cst$kw$recur;
} else {
throw e118249;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__118258 = state_118240;
state_118240 = G__118258;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__109971__auto__ = function(state_118240){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__109971__auto____1.call(this,state_118240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__109971__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__109971__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___118252,ws,open_QMARK_,timeout_chan))
})();
var state__110079__auto__ = (function (){var statearr_118251 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_118251[(6)] = c__110077__auto___118252);

return statearr_118251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___118252,ws,open_QMARK_,timeout_chan))
);


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
