// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ecmascript5,cljs.core.cst$kw$ecmascript5_DASH_strict,cljs.core.cst$kw$ecmascript6,cljs.core.cst$kw$ecmascript6_DASH_strict,cljs.core.cst$kw$ecmascript_DASH_2015,cljs.core.cst$kw$ecmascript6_DASH_typed,cljs.core.cst$kw$ecmascript_DASH_2016,cljs.core.cst$kw$ecmascript_DASH_2017,cljs.core.cst$kw$ecmascript_DASH_next], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__8965 = s;
var map__8965__$1 = cljs.core.__destructure_map(map__8965);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8965__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8965__$1,cljs.core.cst$kw$info);
var d = (0);
var G__8967 = info;
var map__8968 = G__8967;
var map__8968__$1 = cljs.core.__destructure_map(map__8968);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8968__$1,cljs.core.cst$kw$shadow);
var d__$1 = d;
var G__8967__$1 = G__8967;
while(true){
var d__$2 = d__$1;
var map__8970 = G__8967__$1;
var map__8970__$1 = cljs.core.__destructure_map(map__8970);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8970__$1,cljs.core.cst$kw$shadow);
if(cljs.core.truth_(shadow__$1)){
var G__8971 = (d__$2 + (1));
var G__8972 = shadow__$1;
d__$1 = G__8971;
G__8967__$1 = G__8972;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__8973){
var map__8974 = p__8973;
var map__8974__$1 = cljs.core.__destructure_map(map__8974);
var name_var = map__8974__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8974__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8974__$1,cljs.core.cst$kw$info);
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__8975 = info;
var map__8975__$1 = cljs.core.__destructure_map(map__8975);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8975__$1,cljs.core.cst$kw$ns);
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8975__$1,cljs.core.cst$kw$fn_DASH_scope);
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.cst$kw$name),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__8976 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__8976) : cljs.compiler.munge.call(null,G__8976));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__8978 = arguments.length;
switch (G__8978) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(name_var);
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(name_var);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(name_var);
if((!((cljs.core.cst$kw$fn_DASH_self_DASH_name.cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__8979 = new cljs.core.Var(function(){return cljs.core.munge_str;},cljs.core.cst$sym$cljs$core_SLASH_munge_DASH_str,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$munge_DASH_str,"cljs/core.cljs",25,1,11624,11624,cljs.core.cst$sym$string,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__8979.cljs$core$IFn$_invoke$arity$1 ? fexpr__8979.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__8979.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__8981 = cp;
switch (G__8981) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__8983_8987 = cljs.core.seq(s);
var chunk__8984_8988 = null;
var count__8985_8989 = (0);
var i__8986_8990 = (0);
while(true){
if((i__8986_8990 < count__8985_8989)){
var c_8991 = chunk__8984_8988.cljs$core$IIndexed$_nth$arity$2(null,i__8986_8990);
sb.append(cljs.compiler.escape_char(c_8991));


var G__8992 = seq__8983_8987;
var G__8993 = chunk__8984_8988;
var G__8994 = count__8985_8989;
var G__8995 = (i__8986_8990 + (1));
seq__8983_8987 = G__8992;
chunk__8984_8988 = G__8993;
count__8985_8989 = G__8994;
i__8986_8990 = G__8995;
continue;
} else {
var temp__5753__auto___8996 = cljs.core.seq(seq__8983_8987);
if(temp__5753__auto___8996){
var seq__8983_8997__$1 = temp__5753__auto___8996;
if(cljs.core.chunked_seq_QMARK_(seq__8983_8997__$1)){
var c__4591__auto___8998 = cljs.core.chunk_first(seq__8983_8997__$1);
var G__8999 = cljs.core.chunk_rest(seq__8983_8997__$1);
var G__9000 = c__4591__auto___8998;
var G__9001 = cljs.core.count(c__4591__auto___8998);
var G__9002 = (0);
seq__8983_8987 = G__8999;
chunk__8984_8988 = G__9000;
count__8985_8989 = G__9001;
i__8986_8990 = G__9002;
continue;
} else {
var c_9003 = cljs.core.first(seq__8983_8997__$1);
sb.append(cljs.compiler.escape_char(c_9003));


var G__9004 = cljs.core.next(seq__8983_8997__$1);
var G__9005 = null;
var G__9006 = (0);
var G__9007 = (0);
seq__8983_8987 = G__9004;
chunk__8984_8988 = G__9005;
count__8985_8989 = G__9006;
i__8986_8990 = G__9007;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4654__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4655__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4656__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4657__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4658__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__9008 = cljs.core.get_global_hierarchy;
return (fexpr__9008.cljs$core$IFn$_invoke$arity$0 ? fexpr__9008.cljs$core$IFn$_invoke$arity$0() : fexpr__9008.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),cljs.core.cst$kw$op,cljs.core.cst$kw$default,hierarchy__4658__auto__,method_table__4654__auto__,prefer_table__4655__auto__,method_cache__4656__auto__,cached_hierarchy__4657__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__9009_9014 = ast;
var map__9009_9015__$1 = cljs.core.__destructure_map(map__9009_9014);
var env_9016 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9009_9015__$1,cljs.core.cst$kw$env);
if(cljs.core.truth_(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(env_9016))){
var map__9010_9017 = env_9016;
var map__9010_9018__$1 = cljs.core.__destructure_map(map__9010_9017);
var line_9019 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9010_9018__$1,cljs.core.cst$kw$line);
var column_9020 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9010_9018__$1,cljs.core.cst$kw$column);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__9011 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gcol,cljs.core.cst$kw$gen_DASH_col.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$gline,cljs.core.cst$kw$gen_DASH_line.cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__9013 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__9012 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$binding,null,cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__9012.cljs$core$IFn$_invoke$arity$1 ? fexpr__9012.cljs$core$IFn$_invoke$arity$1(G__9013) : fexpr__9012.call(null,G__9013));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__9011,cljs.core.cst$kw$name,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__9011;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$source_DASH_map,(line_9019 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_9020)?(column_9020 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__9029 = arguments.length;
switch (G__9029) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___9036 = arguments.length;
var i__4772__auto___9037 = (0);
while(true){
if((i__4772__auto___9037 < len__4771__auto___9036)){
args_arr__4792__auto__.push((arguments[i__4772__auto___9037]));

var G__9038 = (i__4772__auto___9037 + (1));
i__4772__auto___9037 = G__9038;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4793__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_9039 = (function (){var G__9030 = a;
if((!(typeof a === 'string'))){
return G__9030.toString();
} else {
return G__9030;
}
})();
var temp__5757__auto___9040 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___9040 == null)){
} else {
var sm_data_9041 = temp__5757__auto___9040;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_9041,cljs.core.update,cljs.core.cst$kw$gen_DASH_col,(function (p1__9021_SHARP_){
return (p1__9021_SHARP_ + s_9039.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_9039], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__9031 = cljs.core.seq(xs);
var chunk__9032 = null;
var count__9033 = (0);
var i__9034 = (0);
while(true){
if((i__9034 < count__9033)){
var x = chunk__9032.cljs$core$IIndexed$_nth$arity$2(null,i__9034);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__9042 = seq__9031;
var G__9043 = chunk__9032;
var G__9044 = count__9033;
var G__9045 = (i__9034 + (1));
seq__9031 = G__9042;
chunk__9032 = G__9043;
count__9033 = G__9044;
i__9034 = G__9045;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__9031);
if(temp__5753__auto__){
var seq__9031__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9031__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__9031__$1);
var G__9046 = cljs.core.chunk_rest(seq__9031__$1);
var G__9047 = c__4591__auto__;
var G__9048 = cljs.core.count(c__4591__auto__);
var G__9049 = (0);
seq__9031 = G__9046;
chunk__9032 = G__9047;
count__9033 = G__9048;
i__9034 = G__9049;
continue;
} else {
var x = cljs.core.first(seq__9031__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__9050 = cljs.core.next(seq__9031__$1);
var G__9051 = null;
var G__9052 = (0);
var G__9053 = (0);
seq__9031 = G__9050;
chunk__9032 = G__9051;
count__9033 = G__9052;
i__9034 = G__9053;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq9023){
var G__9024 = cljs.core.first(seq9023);
var seq9023__$1 = cljs.core.next(seq9023);
var G__9025 = cljs.core.first(seq9023__$1);
var seq9023__$2 = cljs.core.next(seq9023__$1);
var G__9026 = cljs.core.first(seq9023__$2);
var seq9023__$3 = cljs.core.next(seq9023__$2);
var G__9027 = cljs.core.first(seq9023__$3);
var seq9023__$4 = cljs.core.next(seq9023__$3);
var G__9028 = cljs.core.first(seq9023__$4);
var seq9023__$5 = cljs.core.next(seq9023__$4);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9024,G__9025,G__9026,G__9027,G__9028,seq9023__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__9054){
var map__9055 = p__9054;
var map__9055__$1 = cljs.core.__destructure_map(map__9055);
var m = map__9055__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9055__$1,cljs.core.cst$kw$gen_DASH_line);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,cljs.core.cst$kw$gen_DASH_line,(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$gen_DASH_col,(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__9063 = arguments.length;
switch (G__9063) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___9069 = arguments.length;
var i__4772__auto___9070 = (0);
while(true){
if((i__4772__auto___9070 < len__4771__auto___9069)){
args_arr__4792__auto__.push((arguments[i__4772__auto___9070]));

var G__9071 = (i__4772__auto___9070 + (1));
i__4772__auto___9070 = G__9071;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4793__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__9064_9072 = cljs.core.seq(xs);
var chunk__9065_9073 = null;
var count__9066_9074 = (0);
var i__9067_9075 = (0);
while(true){
if((i__9067_9075 < count__9066_9074)){
var x_9076 = chunk__9065_9073.cljs$core$IIndexed$_nth$arity$2(null,i__9067_9075);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_9076);


var G__9077 = seq__9064_9072;
var G__9078 = chunk__9065_9073;
var G__9079 = count__9066_9074;
var G__9080 = (i__9067_9075 + (1));
seq__9064_9072 = G__9077;
chunk__9065_9073 = G__9078;
count__9066_9074 = G__9079;
i__9067_9075 = G__9080;
continue;
} else {
var temp__5753__auto___9081 = cljs.core.seq(seq__9064_9072);
if(temp__5753__auto___9081){
var seq__9064_9082__$1 = temp__5753__auto___9081;
if(cljs.core.chunked_seq_QMARK_(seq__9064_9082__$1)){
var c__4591__auto___9083 = cljs.core.chunk_first(seq__9064_9082__$1);
var G__9084 = cljs.core.chunk_rest(seq__9064_9082__$1);
var G__9085 = c__4591__auto___9083;
var G__9086 = cljs.core.count(c__4591__auto___9083);
var G__9087 = (0);
seq__9064_9072 = G__9084;
chunk__9065_9073 = G__9085;
count__9066_9074 = G__9086;
i__9067_9075 = G__9087;
continue;
} else {
var x_9088 = cljs.core.first(seq__9064_9082__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_9088);


var G__9089 = cljs.core.next(seq__9064_9082__$1);
var G__9090 = null;
var G__9091 = (0);
var G__9092 = (0);
seq__9064_9072 = G__9089;
chunk__9065_9073 = G__9090;
count__9066_9074 = G__9091;
i__9067_9075 = G__9092;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq9057){
var G__9058 = cljs.core.first(seq9057);
var seq9057__$1 = cljs.core.next(seq9057);
var G__9059 = cljs.core.first(seq9057__$1);
var seq9057__$2 = cljs.core.next(seq9057__$1);
var G__9060 = cljs.core.first(seq9057__$2);
var seq9057__$3 = cljs.core.next(seq9057__$2);
var G__9061 = cljs.core.first(seq9057__$3);
var seq9057__$4 = cljs.core.next(seq9057__$3);
var G__9062 = cljs.core.first(seq9057__$4);
var seq9057__$5 = cljs.core.next(seq9057__$4);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9058,G__9059,G__9060,G__9061,G__9062,seq9057__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4702__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__9093_9097 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__9094_9098 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__9095_9099 = true;
var _STAR_print_fn_STAR__temp_val__9096_9100 = (function (x__4703__auto__){
return sb__4702__auto__.append(x__4703__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__9095_9099);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__9096_9100);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__9094_9098);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__9093_9097);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4702__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4654__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4655__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4656__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4657__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4658__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__9101 = cljs.core.get_global_hierarchy;
return (fexpr__9101.cljs$core$IFn$_invoke$arity$0 ? fexpr__9101.cljs$core$IFn$_invoke$arity$0() : fexpr__9101.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,cljs.core.cst$kw$default,hierarchy__4658__auto__,method_table__4654__auto__,prefer_table__4655__auto__,method_cache__4656__auto__,cached_hierarchy__4657__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__9102 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9102,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9102,(1),null);
var G__9105 = ns;
var G__9106 = name;
var G__9107 = (function (){
var G__9108 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__9108) : cljs.compiler.emit_constant.call(null,G__9108));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__9105,G__9106,G__9107) : cljs.compiler.emit_record_value.call(null,G__9105,G__9106,G__9107));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__9109 = cljs.core.keys(x);
var G__9110 = cljs.core.vals(x);
var G__9111 = cljs.compiler.emit_constants_comma_sep;
var G__9112 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__9109,G__9110,G__9111,G__9112) : cljs.compiler.emit_map.call(null,G__9109,G__9110,G__9111,G__9112));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__9113 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__9114 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__9113,G__9114) : cljs.compiler.emit_with_meta.call(null,G__9113,G__9114));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$constant,x,cljs.core.cst$kw$type,cljs.core.type(x),cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__9115 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9115,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9115,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9115,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4149__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4149__auto__)){
var G__9118 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__9118) : x.call(null,G__9118));
} else {
return and__4149__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4149__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4149__auto__)){
var G__9119 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__9119) : x.call(null,G__9119));
} else {
return and__4149__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__9121 = items;
var G__9122 = (function (p1__9120_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__9120_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__9121,G__9122) : cljs.compiler.emit_js_object.call(null,G__9121,G__9122));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$no_DASH_op,(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__9124){
var map__9125 = p__9124;
var map__9125__$1 = cljs.core.__destructure_map(map__9125);
var ast = map__9125__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9125__$1,cljs.core.cst$kw$info);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9125__$1,cljs.core.cst$kw$env);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9125__$1,cljs.core.cst$kw$form);
var temp__5751__auto__ = cljs.core.cst$kw$const_DASH_expr.cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,cljs.core.cst$kw$env,env));
} else {
var map__9126 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__9126__$1 = cljs.core.__destructure_map(map__9126);
var cenv = map__9126__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9126__$1,cljs.core.cst$kw$options);
var var_name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_module_DASH_index,cljs.core.name(var_name),cljs.core.cst$kw$name], null));
var or__4160__auto__ = js_module_name;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(cljs.core.cst$kw$binding_DASH_form_QMARK_.cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__9127 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4149__auto__ = (function (){var G__9130 = cljs.core.cst$kw$language_DASH_out.cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__9130) : cljs.compiler.es5_GT__EQ_.call(null,G__9130));
})();
if(cljs.core.truth_(and__4149__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4149__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__9127,cljs.analyzer.es5_allowed);
} else {
return G__9127;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_namespaces,(function (){var or__4160__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__9131 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$sym$js_SLASH__DASH_Infinity)){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__9131,reserved);
} else {
return G__9131;
}
})();
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__9132_9133 = cljs.core.cst$kw$module_DASH_type.cljs$core$IFn$_invoke$arity$1(js_module);
var G__9132_9134__$1 = (((G__9132_9133 instanceof cljs.core.Keyword))?G__9132_9133.fqn:null);
switch (G__9132_9134__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4149__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4149__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$binding,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$the_DASH_var,(function (p__9136){
var map__9137 = p__9136;
var map__9137__$1 = cljs.core.__destructure_map(map__9137);
var arg = map__9137__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9137__$1,cljs.core.cst$kw$env);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9137__$1,cljs.core.cst$kw$var);
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9137__$1,cljs.core.cst$kw$sym);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9137__$1,cljs.core.cst$kw$meta);
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__9138 = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(var$);
var map__9138__$1 = cljs.core.__destructure_map(map__9138);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9138__$1,cljs.core.cst$kw$name);
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$with_DASH_meta,(function (p__9139){
var map__9140 = p__9139;
var map__9140__$1 = cljs.core.__destructure_map(map__9140);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9140__$1,cljs.core.cst$kw$expr);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9140__$1,cljs.core.cst$kw$meta);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9140__$1,cljs.core.cst$kw$env);
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__9141_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__9141_SHARP_),cljs.core.cst$kw$const);
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__9142 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__9142) : comma_sep.call(null,G__9142));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__9143 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__9143) : comma_sep.call(null,G__9143));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$map,(function (p__9144){
var map__9145 = p__9144;
var map__9145__$1 = cljs.core.__destructure_map(map__9145);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9145__$1,cljs.core.cst$kw$env);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9145__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9145__$1,cljs.core.cst$kw$vals);
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$vector,(function (p__9146){
var map__9147 = p__9146;
var map__9147__$1 = cljs.core.__destructure_map(map__9147);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9147__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9147__$1,cljs.core.cst$kw$env);
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__9148_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__9148_SHARP_),cljs.core.cst$kw$const);
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__9149 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__9149) : comma_sep.call(null,G__9149));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set,(function (p__9150){
var map__9151 = p__9150;
var map__9151__$1 = cljs.core.__destructure_map(map__9151);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9151__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9151__$1,cljs.core.cst$kw$env);
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5753__auto___9174 = cljs.core.seq(items);
if(temp__5753__auto___9174){
var items_9175__$1 = temp__5753__auto___9174;
var vec__9152_9176 = items_9175__$1;
var seq__9153_9177 = cljs.core.seq(vec__9152_9176);
var first__9154_9178 = cljs.core.first(seq__9153_9177);
var seq__9153_9179__$1 = cljs.core.next(seq__9153_9177);
var vec__9155_9180 = first__9154_9178;
var k_9181 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9155_9180,(0),null);
var v_9182 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9155_9180,(1),null);
var r_9183 = seq__9153_9179__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_9181),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_9182) : emit_js_object_val.call(null,v_9182)));

var seq__9158_9184 = cljs.core.seq(r_9183);
var chunk__9159_9185 = null;
var count__9160_9186 = (0);
var i__9161_9187 = (0);
while(true){
if((i__9161_9187 < count__9160_9186)){
var vec__9168_9188 = chunk__9159_9185.cljs$core$IIndexed$_nth$arity$2(null,i__9161_9187);
var k_9189__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9168_9188,(0),null);
var v_9190__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9168_9188,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_9189__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_9190__$1) : emit_js_object_val.call(null,v_9190__$1)));


var G__9191 = seq__9158_9184;
var G__9192 = chunk__9159_9185;
var G__9193 = count__9160_9186;
var G__9194 = (i__9161_9187 + (1));
seq__9158_9184 = G__9191;
chunk__9159_9185 = G__9192;
count__9160_9186 = G__9193;
i__9161_9187 = G__9194;
continue;
} else {
var temp__5753__auto___9195__$1 = cljs.core.seq(seq__9158_9184);
if(temp__5753__auto___9195__$1){
var seq__9158_9196__$1 = temp__5753__auto___9195__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9158_9196__$1)){
var c__4591__auto___9197 = cljs.core.chunk_first(seq__9158_9196__$1);
var G__9198 = cljs.core.chunk_rest(seq__9158_9196__$1);
var G__9199 = c__4591__auto___9197;
var G__9200 = cljs.core.count(c__4591__auto___9197);
var G__9201 = (0);
seq__9158_9184 = G__9198;
chunk__9159_9185 = G__9199;
count__9160_9186 = G__9200;
i__9161_9187 = G__9201;
continue;
} else {
var vec__9171_9202 = cljs.core.first(seq__9158_9196__$1);
var k_9203__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9171_9202,(0),null);
var v_9204__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9171_9202,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_9203__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_9204__$1) : emit_js_object_val.call(null,v_9204__$1)));


var G__9205 = cljs.core.next(seq__9158_9196__$1);
var G__9206 = null;
var G__9207 = (0);
var G__9208 = (0);
seq__9158_9184 = G__9205;
chunk__9159_9185 = G__9206;
count__9160_9186 = G__9207;
i__9161_9187 = G__9208;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_object,(function (p__9209){
var map__9210 = p__9209;
var map__9210__$1 = cljs.core.__destructure_map(map__9210);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9210__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9210__$1,cljs.core.cst$kw$vals);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9210__$1,cljs.core.cst$kw$env);
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_array,(function (p__9211){
var map__9212 = p__9211;
var map__9212__$1 = cljs.core.__destructure_map(map__9212);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9212__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9212__$1,cljs.core.cst$kw$env);
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$quote,(function (p__9213){
var map__9214 = p__9213;
var map__9214__$1 = cljs.core.__destructure_map(map__9214);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9214__$1,cljs.core.cst$kw$expr);
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$const,(function (p__9215){
var map__9216 = p__9215;
var map__9216__$1 = cljs.core.__destructure_map(map__9216);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9216__$1,cljs.core.cst$kw$form);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9216__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__9217 = cljs.analyzer.unwrap_quote(expr);
var map__9217__$1 = cljs.core.__destructure_map(map__9217);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9217__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9217__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9217__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4160__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const))?(function (){var and__4149__auto__ = form;
if(cljs.core.truth_(and__4149__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4149__auto__;
}
})():false);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__9218 = cljs.analyzer.unwrap_quote(expr);
var map__9218__$1 = cljs.core.__destructure_map(map__9218);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9218__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9218__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9218__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4160__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const)) && (((form === false) || ((form == null)))));
if(or__4160__auto__){
return or__4160__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4160__auto__ = (function (){var fexpr__9220 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,null,cljs.core.cst$sym$boolean,null], null), null);
return (fexpr__9220.cljs$core$IFn$_invoke$arity$1 ? fexpr__9220.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__9220.call(null,tag));
})();
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$if,(function (p__9221){
var map__9222 = p__9221;
var map__9222__$1 = cljs.core.__destructure_map(map__9222);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9222__$1,cljs.core.cst$kw$test);
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9222__$1,cljs.core.cst$kw$then);
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9222__$1,cljs.core.cst$kw$else);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9222__$1,cljs.core.cst$kw$env);
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9222__$1,cljs.core.cst$kw$unchecked);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4160__auto__ = unchecked;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$case,(function (p__9223){
var map__9224 = p__9223;
var map__9224__$1 = cljs.core.__destructure_map(map__9224);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9224__$1,cljs.core.cst$kw$test);
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9224__$1,cljs.core.cst$kw$nodes);
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9224__$1,cljs.core.cst$kw$default);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9224__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env),cljs.core.cst$kw$expr)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__9225_9253 = cljs.core.seq(nodes);
var chunk__9226_9254 = null;
var count__9227_9255 = (0);
var i__9228_9256 = (0);
while(true){
if((i__9228_9256 < count__9227_9255)){
var map__9241_9257 = chunk__9226_9254.cljs$core$IIndexed$_nth$arity$2(null,i__9228_9256);
var map__9241_9258__$1 = cljs.core.__destructure_map(map__9241_9257);
var ts_9259 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9241_9258__$1,cljs.core.cst$kw$tests);
var map__9242_9260 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9241_9258__$1,cljs.core.cst$kw$then);
var map__9242_9261__$1 = cljs.core.__destructure_map(map__9242_9260);
var then_9262 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9242_9261__$1,cljs.core.cst$kw$then);
var seq__9243_9263 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_9259));
var chunk__9244_9264 = null;
var count__9245_9265 = (0);
var i__9246_9266 = (0);
while(true){
if((i__9246_9266 < count__9245_9265)){
var test_9267 = chunk__9244_9264.cljs$core$IIndexed$_nth$arity$2(null,i__9246_9266);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_9267,":");


var G__9268 = seq__9243_9263;
var G__9269 = chunk__9244_9264;
var G__9270 = count__9245_9265;
var G__9271 = (i__9246_9266 + (1));
seq__9243_9263 = G__9268;
chunk__9244_9264 = G__9269;
count__9245_9265 = G__9270;
i__9246_9266 = G__9271;
continue;
} else {
var temp__5753__auto___9272 = cljs.core.seq(seq__9243_9263);
if(temp__5753__auto___9272){
var seq__9243_9273__$1 = temp__5753__auto___9272;
if(cljs.core.chunked_seq_QMARK_(seq__9243_9273__$1)){
var c__4591__auto___9274 = cljs.core.chunk_first(seq__9243_9273__$1);
var G__9275 = cljs.core.chunk_rest(seq__9243_9273__$1);
var G__9276 = c__4591__auto___9274;
var G__9277 = cljs.core.count(c__4591__auto___9274);
var G__9278 = (0);
seq__9243_9263 = G__9275;
chunk__9244_9264 = G__9276;
count__9245_9265 = G__9277;
i__9246_9266 = G__9278;
continue;
} else {
var test_9279 = cljs.core.first(seq__9243_9273__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_9279,":");


var G__9280 = cljs.core.next(seq__9243_9273__$1);
var G__9281 = null;
var G__9282 = (0);
var G__9283 = (0);
seq__9243_9263 = G__9280;
chunk__9244_9264 = G__9281;
count__9245_9265 = G__9282;
i__9246_9266 = G__9283;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_9262);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_9262);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__9284 = seq__9225_9253;
var G__9285 = chunk__9226_9254;
var G__9286 = count__9227_9255;
var G__9287 = (i__9228_9256 + (1));
seq__9225_9253 = G__9284;
chunk__9226_9254 = G__9285;
count__9227_9255 = G__9286;
i__9228_9256 = G__9287;
continue;
} else {
var temp__5753__auto___9288 = cljs.core.seq(seq__9225_9253);
if(temp__5753__auto___9288){
var seq__9225_9289__$1 = temp__5753__auto___9288;
if(cljs.core.chunked_seq_QMARK_(seq__9225_9289__$1)){
var c__4591__auto___9290 = cljs.core.chunk_first(seq__9225_9289__$1);
var G__9291 = cljs.core.chunk_rest(seq__9225_9289__$1);
var G__9292 = c__4591__auto___9290;
var G__9293 = cljs.core.count(c__4591__auto___9290);
var G__9294 = (0);
seq__9225_9253 = G__9291;
chunk__9226_9254 = G__9292;
count__9227_9255 = G__9293;
i__9228_9256 = G__9294;
continue;
} else {
var map__9247_9295 = cljs.core.first(seq__9225_9289__$1);
var map__9247_9296__$1 = cljs.core.__destructure_map(map__9247_9295);
var ts_9297 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9247_9296__$1,cljs.core.cst$kw$tests);
var map__9248_9298 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9247_9296__$1,cljs.core.cst$kw$then);
var map__9248_9299__$1 = cljs.core.__destructure_map(map__9248_9298);
var then_9300 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9248_9299__$1,cljs.core.cst$kw$then);
var seq__9249_9301 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_9297));
var chunk__9250_9302 = null;
var count__9251_9303 = (0);
var i__9252_9304 = (0);
while(true){
if((i__9252_9304 < count__9251_9303)){
var test_9305 = chunk__9250_9302.cljs$core$IIndexed$_nth$arity$2(null,i__9252_9304);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_9305,":");


var G__9306 = seq__9249_9301;
var G__9307 = chunk__9250_9302;
var G__9308 = count__9251_9303;
var G__9309 = (i__9252_9304 + (1));
seq__9249_9301 = G__9306;
chunk__9250_9302 = G__9307;
count__9251_9303 = G__9308;
i__9252_9304 = G__9309;
continue;
} else {
var temp__5753__auto___9310__$1 = cljs.core.seq(seq__9249_9301);
if(temp__5753__auto___9310__$1){
var seq__9249_9311__$1 = temp__5753__auto___9310__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9249_9311__$1)){
var c__4591__auto___9312 = cljs.core.chunk_first(seq__9249_9311__$1);
var G__9313 = cljs.core.chunk_rest(seq__9249_9311__$1);
var G__9314 = c__4591__auto___9312;
var G__9315 = cljs.core.count(c__4591__auto___9312);
var G__9316 = (0);
seq__9249_9301 = G__9313;
chunk__9250_9302 = G__9314;
count__9251_9303 = G__9315;
i__9252_9304 = G__9316;
continue;
} else {
var test_9317 = cljs.core.first(seq__9249_9311__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_9317,":");


var G__9318 = cljs.core.next(seq__9249_9311__$1);
var G__9319 = null;
var G__9320 = (0);
var G__9321 = (0);
seq__9249_9301 = G__9318;
chunk__9250_9302 = G__9319;
count__9251_9303 = G__9320;
i__9252_9304 = G__9321;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_9300);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_9300);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__9322 = cljs.core.next(seq__9225_9289__$1);
var G__9323 = null;
var G__9324 = (0);
var G__9325 = (0);
seq__9225_9253 = G__9322;
chunk__9226_9254 = G__9323;
count__9227_9255 = G__9324;
i__9228_9256 = G__9325;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$throw,(function (p__9326){
var map__9327 = p__9326;
var map__9327__$1 = cljs.core.__destructure_map(map__9327);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9327__$1,cljs.core.cst$kw$exception);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9327__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__9331 = env;
var G__9332 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__9331,G__9332) : cljs.compiler.resolve_type.call(null,G__9331,G__9332));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__9333 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9333,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9333,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__9328_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__9328_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__9328_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__9336 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__9336,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__9336;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__9339 = env;
var G__9340 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__9339,G__9340) : cljs.compiler.resolve_type.call(null,G__9339,G__9340));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9341_SHARP_){
return cljs.compiler.resolve_type(env,p1__9341_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__9342 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__9343 = cljs.core.seq(vec__9342);
var first__9344 = cljs.core.first(seq__9343);
var seq__9343__$1 = cljs.core.next(seq__9343);
var p = first__9344;
var first__9344__$1 = cljs.core.first(seq__9343__$1);
var seq__9343__$2 = cljs.core.next(seq__9343__$1);
var ts = first__9344__$1;
var first__9344__$2 = cljs.core.first(seq__9343__$2);
var seq__9343__$3 = cljs.core.next(seq__9343__$2);
var n = first__9344__$2;
var xs = seq__9343__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4149__auto__ = ts;
if(cljs.core.truth_(and__4149__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4149__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__9345 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__9346 = cljs.core.seq(vec__9345);
var first__9347 = cljs.core.first(seq__9346);
var seq__9346__$1 = cljs.core.next(seq__9346);
var p = first__9347;
var first__9347__$1 = cljs.core.first(seq__9346__$1);
var seq__9346__$2 = cljs.core.next(seq__9346__$1);
var ts = first__9347__$1;
var xs = seq__9346__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4149__auto__ = ts;
if(cljs.core.truth_(and__4149__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4149__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__9349 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$options,cljs.core.cst$kw$closure_DASH_warnings,cljs.core.cst$kw$check_DASH_types], null));
var fexpr__9348 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$warning,null,cljs.core.cst$kw$error,null], null), null);
return (fexpr__9348.cljs$core$IFn$_invoke$arity$1 ? fexpr__9348.cljs$core$IFn$_invoke$arity$1(G__9349) : fexpr__9348.call(null,G__9349));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__9352 = arguments.length;
switch (G__9352) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__9360 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9350_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__9350_SHARP_);
} else {
return p1__9350_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__9361 = cljs.core.seq(vec__9360);
var first__9362 = cljs.core.first(seq__9361);
var seq__9361__$1 = cljs.core.next(seq__9361);
var x = first__9362;
var ys = seq__9361__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__9363 = cljs.core.seq(ys);
var chunk__9364 = null;
var count__9365 = (0);
var i__9366 = (0);
while(true){
if((i__9366 < count__9365)){
var next_line = chunk__9364.cljs$core$IIndexed$_nth$arity$2(null,i__9366);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__9372 = seq__9363;
var G__9373 = chunk__9364;
var G__9374 = count__9365;
var G__9375 = (i__9366 + (1));
seq__9363 = G__9372;
chunk__9364 = G__9373;
count__9365 = G__9374;
i__9366 = G__9375;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__9363);
if(temp__5753__auto__){
var seq__9363__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9363__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__9363__$1);
var G__9376 = cljs.core.chunk_rest(seq__9363__$1);
var G__9377 = c__4591__auto__;
var G__9378 = cljs.core.count(c__4591__auto__);
var G__9379 = (0);
seq__9363 = G__9376;
chunk__9364 = G__9377;
count__9365 = G__9378;
i__9366 = G__9379;
continue;
} else {
var next_line = cljs.core.first(seq__9363__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__9380 = cljs.core.next(seq__9363__$1);
var G__9381 = null;
var G__9382 = (0);
var G__9383 = (0);
seq__9363 = G__9380;
chunk__9364 = G__9381;
count__9365 = G__9382;
i__9366 = G__9383;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__9367_9384 = cljs.core.seq(docs__$2);
var chunk__9368_9385 = null;
var count__9369_9386 = (0);
var i__9370_9387 = (0);
while(true){
if((i__9370_9387 < count__9369_9386)){
var e_9388 = chunk__9368_9385.cljs$core$IIndexed$_nth$arity$2(null,i__9370_9387);
if(cljs.core.truth_(e_9388)){
print_comment_lines(e_9388);
} else {
}


var G__9389 = seq__9367_9384;
var G__9390 = chunk__9368_9385;
var G__9391 = count__9369_9386;
var G__9392 = (i__9370_9387 + (1));
seq__9367_9384 = G__9389;
chunk__9368_9385 = G__9390;
count__9369_9386 = G__9391;
i__9370_9387 = G__9392;
continue;
} else {
var temp__5753__auto___9393 = cljs.core.seq(seq__9367_9384);
if(temp__5753__auto___9393){
var seq__9367_9394__$1 = temp__5753__auto___9393;
if(cljs.core.chunked_seq_QMARK_(seq__9367_9394__$1)){
var c__4591__auto___9395 = cljs.core.chunk_first(seq__9367_9394__$1);
var G__9396 = cljs.core.chunk_rest(seq__9367_9394__$1);
var G__9397 = c__4591__auto___9395;
var G__9398 = cljs.core.count(c__4591__auto___9395);
var G__9399 = (0);
seq__9367_9384 = G__9396;
chunk__9368_9385 = G__9397;
count__9369_9386 = G__9398;
i__9370_9387 = G__9399;
continue;
} else {
var e_9400 = cljs.core.first(seq__9367_9394__$1);
if(cljs.core.truth_(e_9400)){
print_comment_lines(e_9400);
} else {
}


var G__9401 = cljs.core.next(seq__9367_9394__$1);
var G__9402 = null;
var G__9403 = (0);
var G__9404 = (0);
seq__9367_9384 = G__9401;
chunk__9368_9385 = G__9402;
count__9369_9386 = G__9403;
i__9370_9387 = G__9404;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),cljs.core.cst$kw$options);
var and__4149__auto__ = cljs.core.some((function (p1__9406_SHARP_){
return goog.string.startsWith(p1__9406_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4149__auto__)){
var and__4149__auto____$1 = opts;
if(cljs.core.truth_(and__4149__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optimizations.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$none)){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$closure_DASH_defines,cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4149__auto____$1;
}
} else {
return and__4149__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$def,(function (p__9407){
var map__9408 = p__9407;
var map__9408__$1 = cljs.core.__destructure_map(map__9408);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9408__$1,cljs.core.cst$kw$doc);
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9408__$1,cljs.core.cst$kw$jsdoc);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9408__$1,cljs.core.cst$kw$test);
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9408__$1,cljs.core.cst$kw$goog_DASH_define);
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9408__$1,cljs.core.cst$kw$init);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9408__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9408__$1,cljs.core.cst$kw$env);
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9408__$1,cljs.core.cst$kw$export);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9408__$1,cljs.core.cst$kw$var);
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9408__$1,cljs.core.cst$kw$var_DASH_ast);
if(cljs.core.truth_((function (){var or__4160__auto__ = init;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$jsdoc.cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$the_DASH_var,cljs.core.cst$kw$env,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,cljs.core.cst$kw$context,cljs.core.cst$kw$expr)], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4149__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4149__auto__)){
return test;
} else {
return and__4149__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__9409){
var map__9410 = p__9409;
var map__9410__$1 = cljs.core.__destructure_map(map__9410);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9410__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9410__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9410__$1,cljs.core.cst$kw$env);
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__9411_9435 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__9412_9436 = null;
var count__9413_9437 = (0);
var i__9414_9438 = (0);
while(true){
if((i__9414_9438 < count__9413_9437)){
var vec__9421_9439 = chunk__9412_9436.cljs$core$IIndexed$_nth$arity$2(null,i__9414_9438);
var i_9440 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9421_9439,(0),null);
var param_9441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9421_9439,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_9441);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__9442 = seq__9411_9435;
var G__9443 = chunk__9412_9436;
var G__9444 = count__9413_9437;
var G__9445 = (i__9414_9438 + (1));
seq__9411_9435 = G__9442;
chunk__9412_9436 = G__9443;
count__9413_9437 = G__9444;
i__9414_9438 = G__9445;
continue;
} else {
var temp__5753__auto___9446 = cljs.core.seq(seq__9411_9435);
if(temp__5753__auto___9446){
var seq__9411_9447__$1 = temp__5753__auto___9446;
if(cljs.core.chunked_seq_QMARK_(seq__9411_9447__$1)){
var c__4591__auto___9448 = cljs.core.chunk_first(seq__9411_9447__$1);
var G__9449 = cljs.core.chunk_rest(seq__9411_9447__$1);
var G__9450 = c__4591__auto___9448;
var G__9451 = cljs.core.count(c__4591__auto___9448);
var G__9452 = (0);
seq__9411_9435 = G__9449;
chunk__9412_9436 = G__9450;
count__9413_9437 = G__9451;
i__9414_9438 = G__9452;
continue;
} else {
var vec__9424_9453 = cljs.core.first(seq__9411_9447__$1);
var i_9454 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9424_9453,(0),null);
var param_9455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9424_9453,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_9455);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__9456 = cljs.core.next(seq__9411_9447__$1);
var G__9457 = null;
var G__9458 = (0);
var G__9459 = (0);
seq__9411_9435 = G__9456;
chunk__9412_9436 = G__9457;
count__9413_9437 = G__9458;
i__9414_9438 = G__9459;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__9427_9460 = cljs.core.seq(params);
var chunk__9428_9461 = null;
var count__9429_9462 = (0);
var i__9430_9463 = (0);
while(true){
if((i__9430_9463 < count__9429_9462)){
var param_9464 = chunk__9428_9461.cljs$core$IIndexed$_nth$arity$2(null,i__9430_9463);
cljs.compiler.emit(param_9464);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_9464,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9465 = seq__9427_9460;
var G__9466 = chunk__9428_9461;
var G__9467 = count__9429_9462;
var G__9468 = (i__9430_9463 + (1));
seq__9427_9460 = G__9465;
chunk__9428_9461 = G__9466;
count__9429_9462 = G__9467;
i__9430_9463 = G__9468;
continue;
} else {
var temp__5753__auto___9469 = cljs.core.seq(seq__9427_9460);
if(temp__5753__auto___9469){
var seq__9427_9470__$1 = temp__5753__auto___9469;
if(cljs.core.chunked_seq_QMARK_(seq__9427_9470__$1)){
var c__4591__auto___9471 = cljs.core.chunk_first(seq__9427_9470__$1);
var G__9472 = cljs.core.chunk_rest(seq__9427_9470__$1);
var G__9473 = c__4591__auto___9471;
var G__9474 = cljs.core.count(c__4591__auto___9471);
var G__9475 = (0);
seq__9427_9460 = G__9472;
chunk__9428_9461 = G__9473;
count__9429_9462 = G__9474;
i__9430_9463 = G__9475;
continue;
} else {
var param_9476 = cljs.core.first(seq__9427_9470__$1);
cljs.compiler.emit(param_9476);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_9476,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9477 = cljs.core.next(seq__9427_9470__$1);
var G__9478 = null;
var G__9479 = (0);
var G__9480 = (0);
seq__9427_9460 = G__9477;
chunk__9428_9461 = G__9478;
count__9429_9462 = G__9479;
i__9430_9463 = G__9480;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__9431_9481 = cljs.core.seq(params);
var chunk__9432_9482 = null;
var count__9433_9483 = (0);
var i__9434_9484 = (0);
while(true){
if((i__9434_9484 < count__9433_9483)){
var param_9485 = chunk__9432_9482.cljs$core$IIndexed$_nth$arity$2(null,i__9434_9484);
cljs.compiler.emit(param_9485);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_9485,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9486 = seq__9431_9481;
var G__9487 = chunk__9432_9482;
var G__9488 = count__9433_9483;
var G__9489 = (i__9434_9484 + (1));
seq__9431_9481 = G__9486;
chunk__9432_9482 = G__9487;
count__9433_9483 = G__9488;
i__9434_9484 = G__9489;
continue;
} else {
var temp__5753__auto___9490 = cljs.core.seq(seq__9431_9481);
if(temp__5753__auto___9490){
var seq__9431_9491__$1 = temp__5753__auto___9490;
if(cljs.core.chunked_seq_QMARK_(seq__9431_9491__$1)){
var c__4591__auto___9492 = cljs.core.chunk_first(seq__9431_9491__$1);
var G__9493 = cljs.core.chunk_rest(seq__9431_9491__$1);
var G__9494 = c__4591__auto___9492;
var G__9495 = cljs.core.count(c__4591__auto___9492);
var G__9496 = (0);
seq__9431_9481 = G__9493;
chunk__9432_9482 = G__9494;
count__9433_9483 = G__9495;
i__9434_9484 = G__9496;
continue;
} else {
var param_9497 = cljs.core.first(seq__9431_9491__$1);
cljs.compiler.emit(param_9497);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_9497,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9498 = cljs.core.next(seq__9431_9491__$1);
var G__9499 = null;
var G__9500 = (0);
var G__9501 = (0);
seq__9431_9481 = G__9498;
chunk__9432_9482 = G__9499;
count__9433_9483 = G__9500;
i__9434_9484 = G__9501;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__9502 = cljs.core.seq(params);
var chunk__9503 = null;
var count__9504 = (0);
var i__9505 = (0);
while(true){
if((i__9505 < count__9504)){
var param = chunk__9503.cljs$core$IIndexed$_nth$arity$2(null,i__9505);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9506 = seq__9502;
var G__9507 = chunk__9503;
var G__9508 = count__9504;
var G__9509 = (i__9505 + (1));
seq__9502 = G__9506;
chunk__9503 = G__9507;
count__9504 = G__9508;
i__9505 = G__9509;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__9502);
if(temp__5753__auto__){
var seq__9502__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9502__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__9502__$1);
var G__9510 = cljs.core.chunk_rest(seq__9502__$1);
var G__9511 = c__4591__auto__;
var G__9512 = cljs.core.count(c__4591__auto__);
var G__9513 = (0);
seq__9502 = G__9510;
chunk__9503 = G__9511;
count__9504 = G__9512;
i__9505 = G__9513;
continue;
} else {
var param = cljs.core.first(seq__9502__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9514 = cljs.core.next(seq__9502__$1);
var G__9515 = null;
var G__9516 = (0);
var G__9517 = (0);
seq__9502 = G__9514;
chunk__9503 = G__9515;
count__9504 = G__9516;
i__9505 = G__9517;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__9518){
var map__9519 = p__9518;
var map__9519__$1 = cljs.core.__destructure_map(map__9519);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9519__$1,cljs.core.cst$kw$body);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9519__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9519__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9519__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9519__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9519__$1,cljs.core.cst$kw$recurs);
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__9520){
var map__9521 = p__9520;
var map__9521__$1 = cljs.core.__destructure_map(map__9521);
var f = map__9521__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9521__$1,cljs.core.cst$kw$body);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9521__$1,cljs.core.cst$kw$fixed_DASH_arity);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9521__$1,cljs.core.cst$kw$variadic_QMARK_);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9521__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9521__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9521__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9521__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9521__$1,cljs.core.cst$kw$recurs);
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_9530__$1 = (function (){var or__4160__auto__ = name;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_9531 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_9530__$1);
var delegate_name_9532 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_9531),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_9532," = function (");

var seq__9522_9533 = cljs.core.seq(params);
var chunk__9523_9534 = null;
var count__9524_9535 = (0);
var i__9525_9536 = (0);
while(true){
if((i__9525_9536 < count__9524_9535)){
var param_9537 = chunk__9523_9534.cljs$core$IIndexed$_nth$arity$2(null,i__9525_9536);
cljs.compiler.emit(param_9537);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_9537,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9538 = seq__9522_9533;
var G__9539 = chunk__9523_9534;
var G__9540 = count__9524_9535;
var G__9541 = (i__9525_9536 + (1));
seq__9522_9533 = G__9538;
chunk__9523_9534 = G__9539;
count__9524_9535 = G__9540;
i__9525_9536 = G__9541;
continue;
} else {
var temp__5753__auto___9542 = cljs.core.seq(seq__9522_9533);
if(temp__5753__auto___9542){
var seq__9522_9543__$1 = temp__5753__auto___9542;
if(cljs.core.chunked_seq_QMARK_(seq__9522_9543__$1)){
var c__4591__auto___9544 = cljs.core.chunk_first(seq__9522_9543__$1);
var G__9545 = cljs.core.chunk_rest(seq__9522_9543__$1);
var G__9546 = c__4591__auto___9544;
var G__9547 = cljs.core.count(c__4591__auto___9544);
var G__9548 = (0);
seq__9522_9533 = G__9545;
chunk__9523_9534 = G__9546;
count__9524_9535 = G__9547;
i__9525_9536 = G__9548;
continue;
} else {
var param_9549 = cljs.core.first(seq__9522_9543__$1);
cljs.compiler.emit(param_9549);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_9549,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9550 = cljs.core.next(seq__9522_9543__$1);
var G__9551 = null;
var G__9552 = (0);
var G__9553 = (0);
seq__9522_9533 = G__9550;
chunk__9523_9534 = G__9551;
count__9524_9535 = G__9552;
i__9525_9536 = G__9553;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_9531," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_9554 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_9554,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_9532,".call(this,");

var seq__9526_9555 = cljs.core.seq(params);
var chunk__9527_9556 = null;
var count__9528_9557 = (0);
var i__9529_9558 = (0);
while(true){
if((i__9529_9558 < count__9528_9557)){
var param_9559 = chunk__9527_9556.cljs$core$IIndexed$_nth$arity$2(null,i__9529_9558);
cljs.compiler.emit(param_9559);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_9559,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9560 = seq__9526_9555;
var G__9561 = chunk__9527_9556;
var G__9562 = count__9528_9557;
var G__9563 = (i__9529_9558 + (1));
seq__9526_9555 = G__9560;
chunk__9527_9556 = G__9561;
count__9528_9557 = G__9562;
i__9529_9558 = G__9563;
continue;
} else {
var temp__5753__auto___9564 = cljs.core.seq(seq__9526_9555);
if(temp__5753__auto___9564){
var seq__9526_9565__$1 = temp__5753__auto___9564;
if(cljs.core.chunked_seq_QMARK_(seq__9526_9565__$1)){
var c__4591__auto___9566 = cljs.core.chunk_first(seq__9526_9565__$1);
var G__9567 = cljs.core.chunk_rest(seq__9526_9565__$1);
var G__9568 = c__4591__auto___9566;
var G__9569 = cljs.core.count(c__4591__auto___9566);
var G__9570 = (0);
seq__9526_9555 = G__9567;
chunk__9527_9556 = G__9568;
count__9528_9557 = G__9569;
i__9529_9558 = G__9570;
continue;
} else {
var param_9571 = cljs.core.first(seq__9526_9565__$1);
cljs.compiler.emit(param_9571);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_9571,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__9572 = cljs.core.next(seq__9526_9565__$1);
var G__9573 = null;
var G__9574 = (0);
var G__9575 = (0);
seq__9526_9555 = G__9572;
chunk__9527_9556 = G__9573;
count__9528_9557 = G__9574;
i__9529_9558 = G__9575;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_9531,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_9531,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cst$kw$name,name_9530__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_9531,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_9532,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_9531,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fn,(function (p__9579){
var map__9580 = p__9579;
var map__9580__$1 = cljs.core.__destructure_map(map__9580);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9580__$1,cljs.core.cst$kw$variadic_QMARK_);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9580__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9580__$1,cljs.core.cst$kw$env);
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9580__$1,cljs.core.cst$kw$methods);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9580__$1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity);
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9580__$1,cljs.core.cst$kw$recur_DASH_frames);
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9580__$1,cljs.core.cst$kw$in_DASH_loop);
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9580__$1,cljs.core.cst$kw$loop_DASH_lets);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__9576_SHARP_){
var and__4149__auto__ = p1__9576_SHARP_;
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.deref(cljs.core.cst$kw$flag.cljs$core$IFn$_invoke$arity$1(p1__9576_SHARP_));
} else {
return and__4149__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4160__auto__ = in_loop;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
}
} else {
var name_9632__$1 = (function (){var or__4160__auto__ = name;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_9633 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_9632__$1);
var maxparams_9634 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$params,methods$));
var mmap_9635 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_9633),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_9636 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__9577_SHARP_){
return cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__9577_SHARP_)));
}),cljs.core.seq(mmap_9635));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_9633," = null;");

var seq__9581_9637 = cljs.core.seq(ms_9636);
var chunk__9582_9638 = null;
var count__9583_9639 = (0);
var i__9584_9640 = (0);
while(true){
if((i__9584_9640 < count__9583_9639)){
var vec__9591_9641 = chunk__9582_9638.cljs$core$IIndexed$_nth$arity$2(null,i__9584_9640);
var n_9642 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9591_9641,(0),null);
var meth_9643 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9591_9641,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_9642," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_9643))){
cljs.compiler.emit_variadic_fn_method(meth_9643);
} else {
cljs.compiler.emit_fn_method(meth_9643);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__9644 = seq__9581_9637;
var G__9645 = chunk__9582_9638;
var G__9646 = count__9583_9639;
var G__9647 = (i__9584_9640 + (1));
seq__9581_9637 = G__9644;
chunk__9582_9638 = G__9645;
count__9583_9639 = G__9646;
i__9584_9640 = G__9647;
continue;
} else {
var temp__5753__auto___9648 = cljs.core.seq(seq__9581_9637);
if(temp__5753__auto___9648){
var seq__9581_9649__$1 = temp__5753__auto___9648;
if(cljs.core.chunked_seq_QMARK_(seq__9581_9649__$1)){
var c__4591__auto___9650 = cljs.core.chunk_first(seq__9581_9649__$1);
var G__9651 = cljs.core.chunk_rest(seq__9581_9649__$1);
var G__9652 = c__4591__auto___9650;
var G__9653 = cljs.core.count(c__4591__auto___9650);
var G__9654 = (0);
seq__9581_9637 = G__9651;
chunk__9582_9638 = G__9652;
count__9583_9639 = G__9653;
i__9584_9640 = G__9654;
continue;
} else {
var vec__9594_9655 = cljs.core.first(seq__9581_9649__$1);
var n_9656 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9594_9655,(0),null);
var meth_9657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9594_9655,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_9656," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_9657))){
cljs.compiler.emit_variadic_fn_method(meth_9657);
} else {
cljs.compiler.emit_fn_method(meth_9657);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__9658 = cljs.core.next(seq__9581_9649__$1);
var G__9659 = null;
var G__9660 = (0);
var G__9661 = (0);
seq__9581_9637 = G__9658;
chunk__9582_9638 = G__9659;
count__9583_9639 = G__9660;
i__9584_9640 = G__9661;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_9633," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_9634),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):maxparams_9634)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_9634));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__9597_9662 = cljs.core.seq(ms_9636);
var chunk__9598_9663 = null;
var count__9599_9664 = (0);
var i__9600_9665 = (0);
while(true){
if((i__9600_9665 < count__9599_9664)){
var vec__9607_9666 = chunk__9598_9663.cljs$core$IIndexed$_nth$arity$2(null,i__9600_9665);
var n_9667 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9607_9666,(0),null);
var meth_9668 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9607_9666,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_9668))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_9669 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_9669," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_9670 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_9669," = new cljs.core.IndexedSeq(",a_9670,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_9667,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_9634)),(((cljs.core.count(maxparams_9634) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_9669,");"], 0));
} else {
var pcnt_9671 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_9668));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_9671,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_9667,".call(this",(((pcnt_9671 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_9671,maxparams_9634)),null,(1),null)),(2),null))),");");
}


var G__9672 = seq__9597_9662;
var G__9673 = chunk__9598_9663;
var G__9674 = count__9599_9664;
var G__9675 = (i__9600_9665 + (1));
seq__9597_9662 = G__9672;
chunk__9598_9663 = G__9673;
count__9599_9664 = G__9674;
i__9600_9665 = G__9675;
continue;
} else {
var temp__5753__auto___9676 = cljs.core.seq(seq__9597_9662);
if(temp__5753__auto___9676){
var seq__9597_9677__$1 = temp__5753__auto___9676;
if(cljs.core.chunked_seq_QMARK_(seq__9597_9677__$1)){
var c__4591__auto___9678 = cljs.core.chunk_first(seq__9597_9677__$1);
var G__9679 = cljs.core.chunk_rest(seq__9597_9677__$1);
var G__9680 = c__4591__auto___9678;
var G__9681 = cljs.core.count(c__4591__auto___9678);
var G__9682 = (0);
seq__9597_9662 = G__9679;
chunk__9598_9663 = G__9680;
count__9599_9664 = G__9681;
i__9600_9665 = G__9682;
continue;
} else {
var vec__9610_9683 = cljs.core.first(seq__9597_9677__$1);
var n_9684 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9610_9683,(0),null);
var meth_9685 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9610_9683,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_9685))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_9686 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_9686," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_9687 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_9686," = new cljs.core.IndexedSeq(",a_9687,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_9684,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_9634)),(((cljs.core.count(maxparams_9634) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_9686,");"], 0));
} else {
var pcnt_9688 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_9685));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_9688,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_9684,".call(this",(((pcnt_9688 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_9688,maxparams_9634)),null,(1),null)),(2),null))),");");
}


var G__9689 = cljs.core.next(seq__9597_9677__$1);
var G__9690 = null;
var G__9691 = (0);
var G__9692 = (0);
seq__9597_9662 = G__9689;
chunk__9598_9663 = G__9690;
count__9599_9664 = G__9691;
i__9600_9665 = G__9692;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_9693 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$self__,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_9636)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_9693,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_9633,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_9633,".cljs$lang$applyTo = ",cljs.core.some((function (p1__9578_SHARP_){
var vec__9613 = p1__9578_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9613,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9613,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_9636),".cljs$lang$applyTo;");
} else {
}

var seq__9616_9694 = cljs.core.seq(ms_9636);
var chunk__9617_9695 = null;
var count__9618_9696 = (0);
var i__9619_9697 = (0);
while(true){
if((i__9619_9697 < count__9618_9696)){
var vec__9626_9698 = chunk__9617_9695.cljs$core$IIndexed$_nth$arity$2(null,i__9619_9697);
var n_9699 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9626_9698,(0),null);
var meth_9700 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9626_9698,(1),null);
var c_9701 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_9700));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_9700))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_9633,".cljs$core$IFn$_invoke$arity$variadic = ",n_9699,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_9633,".cljs$core$IFn$_invoke$arity$",c_9701," = ",n_9699,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__9702 = seq__9616_9694;
var G__9703 = chunk__9617_9695;
var G__9704 = count__9618_9696;
var G__9705 = (i__9619_9697 + (1));
seq__9616_9694 = G__9702;
chunk__9617_9695 = G__9703;
count__9618_9696 = G__9704;
i__9619_9697 = G__9705;
continue;
} else {
var temp__5753__auto___9706 = cljs.core.seq(seq__9616_9694);
if(temp__5753__auto___9706){
var seq__9616_9707__$1 = temp__5753__auto___9706;
if(cljs.core.chunked_seq_QMARK_(seq__9616_9707__$1)){
var c__4591__auto___9708 = cljs.core.chunk_first(seq__9616_9707__$1);
var G__9709 = cljs.core.chunk_rest(seq__9616_9707__$1);
var G__9710 = c__4591__auto___9708;
var G__9711 = cljs.core.count(c__4591__auto___9708);
var G__9712 = (0);
seq__9616_9694 = G__9709;
chunk__9617_9695 = G__9710;
count__9618_9696 = G__9711;
i__9619_9697 = G__9712;
continue;
} else {
var vec__9629_9713 = cljs.core.first(seq__9616_9707__$1);
var n_9714 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9629_9713,(0),null);
var meth_9715 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9629_9713,(1),null);
var c_9716 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_9715));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_9715))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_9633,".cljs$core$IFn$_invoke$arity$variadic = ",n_9714,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_9633,".cljs$core$IFn$_invoke$arity$",c_9716," = ",n_9714,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__9717 = cljs.core.next(seq__9616_9707__$1);
var G__9718 = null;
var G__9719 = (0);
var G__9720 = (0);
seq__9616_9694 = G__9717;
chunk__9617_9695 = G__9718;
count__9618_9696 = G__9719;
i__9619_9697 = G__9720;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_9633,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$do,(function (p__9721){
var map__9722 = p__9721;
var map__9722__$1 = cljs.core.__destructure_map(map__9722);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9722__$1,cljs.core.cst$kw$statements);
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9722__$1,cljs.core.cst$kw$ret);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9722__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__9723_9727 = cljs.core.seq(statements);
var chunk__9724_9728 = null;
var count__9725_9729 = (0);
var i__9726_9730 = (0);
while(true){
if((i__9726_9730 < count__9725_9729)){
var s_9731 = chunk__9724_9728.cljs$core$IIndexed$_nth$arity$2(null,i__9726_9730);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_9731);


var G__9732 = seq__9723_9727;
var G__9733 = chunk__9724_9728;
var G__9734 = count__9725_9729;
var G__9735 = (i__9726_9730 + (1));
seq__9723_9727 = G__9732;
chunk__9724_9728 = G__9733;
count__9725_9729 = G__9734;
i__9726_9730 = G__9735;
continue;
} else {
var temp__5753__auto___9736 = cljs.core.seq(seq__9723_9727);
if(temp__5753__auto___9736){
var seq__9723_9737__$1 = temp__5753__auto___9736;
if(cljs.core.chunked_seq_QMARK_(seq__9723_9737__$1)){
var c__4591__auto___9738 = cljs.core.chunk_first(seq__9723_9737__$1);
var G__9739 = cljs.core.chunk_rest(seq__9723_9737__$1);
var G__9740 = c__4591__auto___9738;
var G__9741 = cljs.core.count(c__4591__auto___9738);
var G__9742 = (0);
seq__9723_9727 = G__9739;
chunk__9724_9728 = G__9740;
count__9725_9729 = G__9741;
i__9726_9730 = G__9742;
continue;
} else {
var s_9743 = cljs.core.first(seq__9723_9737__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_9743);


var G__9744 = cljs.core.next(seq__9723_9737__$1);
var G__9745 = null;
var G__9746 = (0);
var G__9747 = (0);
seq__9723_9727 = G__9744;
chunk__9724_9728 = G__9745;
count__9725_9729 = G__9746;
i__9726_9730 = G__9747;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$try,(function (p__9748){
var map__9749 = p__9748;
var map__9749__$1 = cljs.core.__destructure_map(map__9749);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9749__$1,cljs.core.cst$kw$body);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9749__$1,cljs.core.cst$kw$env);
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9749__$1,cljs.core.cst$kw$catch);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9749__$1,cljs.core.cst$kw$name);
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9749__$1,cljs.core.cst$kw$finally);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4160__auto__ = name;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$const,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__9750,is_loop){
var map__9751 = p__9750;
var map__9751__$1 = cljs.core.__destructure_map(map__9751);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9751__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9751__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9751__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__9752_9762 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__9753_9763 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__9753_9763);

try{var seq__9754_9764 = cljs.core.seq(bindings);
var chunk__9755_9765 = null;
var count__9756_9766 = (0);
var i__9757_9767 = (0);
while(true){
if((i__9757_9767 < count__9756_9766)){
var map__9760_9768 = chunk__9755_9765.cljs$core$IIndexed$_nth$arity$2(null,i__9757_9767);
var map__9760_9769__$1 = cljs.core.__destructure_map(map__9760_9768);
var binding_9770 = map__9760_9769__$1;
var init_9771 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9760_9769__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_9770);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_9771,";");


var G__9772 = seq__9754_9764;
var G__9773 = chunk__9755_9765;
var G__9774 = count__9756_9766;
var G__9775 = (i__9757_9767 + (1));
seq__9754_9764 = G__9772;
chunk__9755_9765 = G__9773;
count__9756_9766 = G__9774;
i__9757_9767 = G__9775;
continue;
} else {
var temp__5753__auto___9776 = cljs.core.seq(seq__9754_9764);
if(temp__5753__auto___9776){
var seq__9754_9777__$1 = temp__5753__auto___9776;
if(cljs.core.chunked_seq_QMARK_(seq__9754_9777__$1)){
var c__4591__auto___9778 = cljs.core.chunk_first(seq__9754_9777__$1);
var G__9779 = cljs.core.chunk_rest(seq__9754_9777__$1);
var G__9780 = c__4591__auto___9778;
var G__9781 = cljs.core.count(c__4591__auto___9778);
var G__9782 = (0);
seq__9754_9764 = G__9779;
chunk__9755_9765 = G__9780;
count__9756_9766 = G__9781;
i__9757_9767 = G__9782;
continue;
} else {
var map__9761_9783 = cljs.core.first(seq__9754_9777__$1);
var map__9761_9784__$1 = cljs.core.__destructure_map(map__9761_9783);
var binding_9785 = map__9761_9784__$1;
var init_9786 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9761_9784__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_9785);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_9786,";");


var G__9787 = cljs.core.next(seq__9754_9777__$1);
var G__9788 = null;
var G__9789 = (0);
var G__9790 = (0);
seq__9754_9764 = G__9787;
chunk__9755_9765 = G__9788;
count__9756_9766 = G__9789;
i__9757_9767 = G__9790;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__9752_9762);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$let,(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$loop,(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$recur,(function (p__9791){
var map__9792 = p__9791;
var map__9792__$1 = cljs.core.__destructure_map(map__9792);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9792__$1,cljs.core.cst$kw$frame);
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9792__$1,cljs.core.cst$kw$exprs);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9792__$1,cljs.core.cst$kw$env);
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(frame);
var n__4648__auto___9793 = cljs.core.count(exprs);
var i_9794 = (0);
while(true){
if((i_9794 < n__4648__auto___9793)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_9794) : temps.call(null,i_9794))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_9794) : exprs.call(null,i_9794)),";");

var G__9795 = (i_9794 + (1));
i_9794 = G__9795;
continue;
} else {
}
break;
}

var n__4648__auto___9796 = cljs.core.count(exprs);
var i_9797 = (0);
while(true){
if((i_9797 < n__4648__auto___9796)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_9797) : params.call(null,i_9797)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_9797) : temps.call(null,i_9797)),";");

var G__9798 = (i_9797 + (1));
i_9797 = G__9798;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$letfn,(function (p__9799){
var map__9800 = p__9799;
var map__9800__$1 = cljs.core.__destructure_map(map__9800);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9800__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9800__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9800__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__9801_9809 = cljs.core.seq(bindings);
var chunk__9802_9810 = null;
var count__9803_9811 = (0);
var i__9804_9812 = (0);
while(true){
if((i__9804_9812 < count__9803_9811)){
var map__9807_9813 = chunk__9802_9810.cljs$core$IIndexed$_nth$arity$2(null,i__9804_9812);
var map__9807_9814__$1 = cljs.core.__destructure_map(map__9807_9813);
var binding_9815 = map__9807_9814__$1;
var init_9816 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9807_9814__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_9815)," = ",init_9816,";");


var G__9817 = seq__9801_9809;
var G__9818 = chunk__9802_9810;
var G__9819 = count__9803_9811;
var G__9820 = (i__9804_9812 + (1));
seq__9801_9809 = G__9817;
chunk__9802_9810 = G__9818;
count__9803_9811 = G__9819;
i__9804_9812 = G__9820;
continue;
} else {
var temp__5753__auto___9821 = cljs.core.seq(seq__9801_9809);
if(temp__5753__auto___9821){
var seq__9801_9822__$1 = temp__5753__auto___9821;
if(cljs.core.chunked_seq_QMARK_(seq__9801_9822__$1)){
var c__4591__auto___9823 = cljs.core.chunk_first(seq__9801_9822__$1);
var G__9824 = cljs.core.chunk_rest(seq__9801_9822__$1);
var G__9825 = c__4591__auto___9823;
var G__9826 = cljs.core.count(c__4591__auto___9823);
var G__9827 = (0);
seq__9801_9809 = G__9824;
chunk__9802_9810 = G__9825;
count__9803_9811 = G__9826;
i__9804_9812 = G__9827;
continue;
} else {
var map__9808_9828 = cljs.core.first(seq__9801_9822__$1);
var map__9808_9829__$1 = cljs.core.__destructure_map(map__9808_9828);
var binding_9830 = map__9808_9829__$1;
var init_9831 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9808_9829__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_9830)," = ",init_9831,";");


var G__9832 = cljs.core.next(seq__9801_9822__$1);
var G__9833 = null;
var G__9834 = (0);
var G__9835 = (0);
seq__9801_9809 = G__9832;
chunk__9802_9810 = G__9833;
count__9803_9811 = G__9834;
i__9804_9812 = G__9835;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$invoke,(function (p__9838){
var map__9839 = p__9838;
var map__9839__$1 = cljs.core.__destructure_map(map__9839);
var expr = map__9839__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9839__$1,cljs.core.cst$kw$fn);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9839__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9839__$1,cljs.core.cst$kw$env);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4149__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4149__auto__)){
if(cljs.core.not(cljs.core.cst$kw$dynamic.cljs$core$IFn$_invoke$arity$1(info))){
return cljs.core.cst$kw$fn_DASH_var.cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4149__auto__;
}
})();
var protocol = cljs.core.cst$kw$protocol.cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4149__auto__ = protocol;
if(cljs.core.truth_(and__4149__auto__)){
var and__4149__auto____$1 = tag;
if(cljs.core.truth_(and__4149__auto____$1)){
var or__4160__auto__ = (function (){var and__4149__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4149__auto____$2)){
var and__4149__auto____$3 = protocol;
if(cljs.core.truth_(and__4149__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,cljs.core.cst$sym$not_DASH_native);
} else {
return and__4149__auto____$3;
}
} else {
return and__4149__auto____$2;
}
})();
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var and__4149__auto____$2 = (function (){var or__4160__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return cljs.core.cst$kw$protocol_DASH_inline.cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4149__auto____$2)){
var or__4160__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4160__auto____$1){
return or__4160__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__9850 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$boolean,"null",cljs.core.cst$sym$object,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$js,"null",cljs.core.cst$sym$number,"null",cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null);
return (fexpr__9850.cljs$core$IFn$_invoke$arity$1 ? fexpr__9850.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__9850.call(null,tag));
})())){
var temp__5753__auto__ = cljs.core.cst$kw$protocols.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4149__auto____$2;
}
}
} else {
return and__4149__auto____$1;
}
} else {
return and__4149__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_not)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,cljs.core.cst$sym$boolean)));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_count)) && (cljs.core.boolean$((function (){var fexpr__9852 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null"], null), null);
return (fexpr__9852.cljs$core$IFn$_invoke$arity$1 ? fexpr__9852.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__9852.call(null,first_arg_tag));
})())));
var ns = cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4160__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$js);
if(or__4160__auto__){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$Math);
if(or__4160__auto____$1){
return or__4160__auto____$1;
} else {
return cljs.core.cst$kw$foreign.cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4160__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$goog);
if(or__4160__auto__){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4160__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$cljs$core_SLASH_Keyword,ftag);
if(or__4160__auto__){
return or__4160__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1),cljs.core.cst$kw$const)) && ((cljs.core.cst$kw$form.cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__9840 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(info);
var mps = cljs.core.cst$kw$method_DASH_params.cljs$core$IFn$_invoke$arity$1(info);
var mfa = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4149__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4149__auto__)){
return (arity > mfa);
} else {
return and__4149__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__9836_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__9836_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$max_DASH_fixed_DASH_arity,mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__9837_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__9837_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9840,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9840,(1),null);
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_9855 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_9855,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_9856 = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_9856,args)),(((mfa_9856 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_9856,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4160__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4149__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4149__auto__)){
var G__9854 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__9853 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__9853.cljs$core$IFn$_invoke$arity$1 ? fexpr__9853.cljs$core$IFn$_invoke$arity$1(G__9854) : fexpr__9853.call(null,G__9854));
} else {
return and__4149__auto__;
}
})())){
var fprop_9857 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_9857," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_9857,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_9857," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_9857,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new,(function (p__9858){
var map__9859 = p__9858;
var map__9859__$1 = cljs.core.__destructure_map(map__9859);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9859__$1,cljs.core.cst$kw$class);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9859__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9859__$1,cljs.core.cst$kw$env);
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_BANG_,(function (p__9860){
var map__9861 = p__9860;
var map__9861__$1 = cljs.core.__destructure_map(map__9861);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9861__$1,cljs.core.cst$kw$target);
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9861__$1,cljs.core.cst$kw$val);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9861__$1,cljs.core.cst$kw$env);
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9862_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__9862_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__9863 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9863,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9863,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__9866 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__9866__$1 = cljs.core.__destructure_map(map__9866);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9866__$1,cljs.core.cst$kw$options);
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9866__$1,cljs.core.cst$kw$js_DASH_dependency_DASH_index);
var map__9867 = options;
var map__9867__$1 = cljs.core.__destructure_map(map__9867);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9867__$1,cljs.core.cst$kw$target);
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9867__$1,cljs.core.cst$kw$nodejs_DASH_rt);
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9867__$1,cljs.core.cst$kw$optimizations);
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_);
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_));
var vec__9868 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$nodejs,target)){
var map__9871 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__9871__$1 = cljs.core.__destructure_map(map__9871);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9871__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9871__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9868,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9868,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__9872_9900 = cljs.core.seq(libs_to_load);
var chunk__9873_9901 = null;
var count__9874_9902 = (0);
var i__9875_9903 = (0);
while(true){
if((i__9875_9903 < count__9874_9902)){
var lib_9904 = chunk__9873_9901.cljs$core$IIndexed$_nth$arity$2(null,i__9875_9903);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_9904)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4160__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_9904),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_9904),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4160__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_9904),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_9904),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_9904,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_9904),"');");
}

}
}
}


var G__9905 = seq__9872_9900;
var G__9906 = chunk__9873_9901;
var G__9907 = count__9874_9902;
var G__9908 = (i__9875_9903 + (1));
seq__9872_9900 = G__9905;
chunk__9873_9901 = G__9906;
count__9874_9902 = G__9907;
i__9875_9903 = G__9908;
continue;
} else {
var temp__5753__auto___9909 = cljs.core.seq(seq__9872_9900);
if(temp__5753__auto___9909){
var seq__9872_9910__$1 = temp__5753__auto___9909;
if(cljs.core.chunked_seq_QMARK_(seq__9872_9910__$1)){
var c__4591__auto___9911 = cljs.core.chunk_first(seq__9872_9910__$1);
var G__9912 = cljs.core.chunk_rest(seq__9872_9910__$1);
var G__9913 = c__4591__auto___9911;
var G__9914 = cljs.core.count(c__4591__auto___9911);
var G__9915 = (0);
seq__9872_9900 = G__9912;
chunk__9873_9901 = G__9913;
count__9874_9902 = G__9914;
i__9875_9903 = G__9915;
continue;
} else {
var lib_9916 = cljs.core.first(seq__9872_9910__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_9916)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4160__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_9916),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_9916),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4160__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_9916),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_9916),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_9916,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_9916),"');");
}

}
}
}


var G__9917 = cljs.core.next(seq__9872_9910__$1);
var G__9918 = null;
var G__9919 = (0);
var G__9920 = (0);
seq__9872_9900 = G__9917;
chunk__9873_9901 = G__9918;
count__9874_9902 = G__9919;
i__9875_9903 = G__9920;
continue;
}
} else {
}
}
break;
}

var seq__9876_9921 = cljs.core.seq(node_libs);
var chunk__9877_9922 = null;
var count__9878_9923 = (0);
var i__9879_9924 = (0);
while(true){
if((i__9879_9924 < count__9878_9923)){
var lib_9925 = chunk__9877_9922.cljs$core$IIndexed$_nth$arity$2(null,i__9879_9924);
var vec__9886_9926 = cljs.analyzer.lib_AMPERSAND_sublib(lib_9925);
var lib_SINGLEQUOTE__9927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9886_9926,(0),null);
var sublib_9928 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9886_9926,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_9925)," = require('",lib_SINGLEQUOTE__9927,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_9928),";"], 0));


var G__9929 = seq__9876_9921;
var G__9930 = chunk__9877_9922;
var G__9931 = count__9878_9923;
var G__9932 = (i__9879_9924 + (1));
seq__9876_9921 = G__9929;
chunk__9877_9922 = G__9930;
count__9878_9923 = G__9931;
i__9879_9924 = G__9932;
continue;
} else {
var temp__5753__auto___9933 = cljs.core.seq(seq__9876_9921);
if(temp__5753__auto___9933){
var seq__9876_9934__$1 = temp__5753__auto___9933;
if(cljs.core.chunked_seq_QMARK_(seq__9876_9934__$1)){
var c__4591__auto___9935 = cljs.core.chunk_first(seq__9876_9934__$1);
var G__9936 = cljs.core.chunk_rest(seq__9876_9934__$1);
var G__9937 = c__4591__auto___9935;
var G__9938 = cljs.core.count(c__4591__auto___9935);
var G__9939 = (0);
seq__9876_9921 = G__9936;
chunk__9877_9922 = G__9937;
count__9878_9923 = G__9938;
i__9879_9924 = G__9939;
continue;
} else {
var lib_9940 = cljs.core.first(seq__9876_9934__$1);
var vec__9889_9941 = cljs.analyzer.lib_AMPERSAND_sublib(lib_9940);
var lib_SINGLEQUOTE__9942 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9889_9941,(0),null);
var sublib_9943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9889_9941,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_9940)," = require('",lib_SINGLEQUOTE__9942,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_9943),";"], 0));


var G__9944 = cljs.core.next(seq__9876_9934__$1);
var G__9945 = null;
var G__9946 = (0);
var G__9947 = (0);
seq__9876_9921 = G__9944;
chunk__9877_9922 = G__9945;
count__9878_9923 = G__9946;
i__9879_9924 = G__9947;
continue;
}
} else {
}
}
break;
}

var seq__9892_9948 = cljs.core.seq(global_exports_libs);
var chunk__9893_9949 = null;
var count__9894_9950 = (0);
var i__9895_9951 = (0);
while(true){
if((i__9895_9951 < count__9894_9950)){
var lib_9952 = chunk__9893_9949.cljs$core$IIndexed$_nth$arity$2(null,i__9895_9951);
var map__9898_9953 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_9952))));
var map__9898_9954__$1 = cljs.core.__destructure_map(map__9898_9953);
var global_exports_9955 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9898_9954__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_9955,lib_9952);


var G__9956 = seq__9892_9948;
var G__9957 = chunk__9893_9949;
var G__9958 = count__9894_9950;
var G__9959 = (i__9895_9951 + (1));
seq__9892_9948 = G__9956;
chunk__9893_9949 = G__9957;
count__9894_9950 = G__9958;
i__9895_9951 = G__9959;
continue;
} else {
var temp__5753__auto___9960 = cljs.core.seq(seq__9892_9948);
if(temp__5753__auto___9960){
var seq__9892_9961__$1 = temp__5753__auto___9960;
if(cljs.core.chunked_seq_QMARK_(seq__9892_9961__$1)){
var c__4591__auto___9962 = cljs.core.chunk_first(seq__9892_9961__$1);
var G__9963 = cljs.core.chunk_rest(seq__9892_9961__$1);
var G__9964 = c__4591__auto___9962;
var G__9965 = cljs.core.count(c__4591__auto___9962);
var G__9966 = (0);
seq__9892_9948 = G__9963;
chunk__9893_9949 = G__9964;
count__9894_9950 = G__9965;
i__9895_9951 = G__9966;
continue;
} else {
var lib_9967 = cljs.core.first(seq__9892_9961__$1);
var map__9899_9968 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_9967))));
var map__9899_9969__$1 = cljs.core.__destructure_map(map__9899_9968);
var global_exports_9970 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9899_9969__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_9970,lib_9967);


var G__9971 = cljs.core.next(seq__9892_9961__$1);
var G__9972 = null;
var G__9973 = (0);
var G__9974 = (0);
seq__9892_9948 = G__9971;
chunk__9893_9949 = G__9972;
count__9894_9950 = G__9973;
i__9895_9951 = G__9974;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns_STAR_,(function (p__9975){
var map__9976 = p__9975;
var map__9976__$1 = cljs.core.__destructure_map(map__9976);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9976__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9976__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9976__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9976__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9976__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9976__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9976__$1,cljs.core.cst$kw$deps);
cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(cljs.core.cst$kw$repl_DASH_env.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns,(function (p__9977){
var map__9978 = p__9977;
var map__9978__$1 = cljs.core.__destructure_map(map__9978);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9978__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9978__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9978__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9978__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9978__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9978__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9978__$1,cljs.core.cst$kw$deps);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$sym$cljs$core)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$deftype,(function (p__9979){
var map__9980 = p__9979;
var map__9980__$1 = cljs.core.__destructure_map(map__9980);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9980__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9980__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9980__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9980__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9980__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__9981_10005 = cljs.core.seq(protocols);
var chunk__9982_10006 = null;
var count__9983_10007 = (0);
var i__9984_10008 = (0);
while(true){
if((i__9984_10008 < count__9983_10007)){
var protocol_10009 = chunk__9982_10006.cljs$core$IIndexed$_nth$arity$2(null,i__9984_10008);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10009)),"}");


var G__10010 = seq__9981_10005;
var G__10011 = chunk__9982_10006;
var G__10012 = count__9983_10007;
var G__10013 = (i__9984_10008 + (1));
seq__9981_10005 = G__10010;
chunk__9982_10006 = G__10011;
count__9983_10007 = G__10012;
i__9984_10008 = G__10013;
continue;
} else {
var temp__5753__auto___10014 = cljs.core.seq(seq__9981_10005);
if(temp__5753__auto___10014){
var seq__9981_10015__$1 = temp__5753__auto___10014;
if(cljs.core.chunked_seq_QMARK_(seq__9981_10015__$1)){
var c__4591__auto___10016 = cljs.core.chunk_first(seq__9981_10015__$1);
var G__10017 = cljs.core.chunk_rest(seq__9981_10015__$1);
var G__10018 = c__4591__auto___10016;
var G__10019 = cljs.core.count(c__4591__auto___10016);
var G__10020 = (0);
seq__9981_10005 = G__10017;
chunk__9982_10006 = G__10018;
count__9983_10007 = G__10019;
i__9984_10008 = G__10020;
continue;
} else {
var protocol_10021 = cljs.core.first(seq__9981_10015__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10021)),"}");


var G__10022 = cljs.core.next(seq__9981_10015__$1);
var G__10023 = null;
var G__10024 = (0);
var G__10025 = (0);
seq__9981_10005 = G__10022;
chunk__9982_10006 = G__10023;
count__9983_10007 = G__10024;
i__9984_10008 = G__10025;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__9985_10026 = cljs.core.seq(fields__$1);
var chunk__9986_10027 = null;
var count__9987_10028 = (0);
var i__9988_10029 = (0);
while(true){
if((i__9988_10029 < count__9987_10028)){
var fld_10030 = chunk__9986_10027.cljs$core$IIndexed$_nth$arity$2(null,i__9988_10029);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10030," = ",fld_10030,";");


var G__10031 = seq__9985_10026;
var G__10032 = chunk__9986_10027;
var G__10033 = count__9987_10028;
var G__10034 = (i__9988_10029 + (1));
seq__9985_10026 = G__10031;
chunk__9986_10027 = G__10032;
count__9987_10028 = G__10033;
i__9988_10029 = G__10034;
continue;
} else {
var temp__5753__auto___10035 = cljs.core.seq(seq__9985_10026);
if(temp__5753__auto___10035){
var seq__9985_10036__$1 = temp__5753__auto___10035;
if(cljs.core.chunked_seq_QMARK_(seq__9985_10036__$1)){
var c__4591__auto___10037 = cljs.core.chunk_first(seq__9985_10036__$1);
var G__10038 = cljs.core.chunk_rest(seq__9985_10036__$1);
var G__10039 = c__4591__auto___10037;
var G__10040 = cljs.core.count(c__4591__auto___10037);
var G__10041 = (0);
seq__9985_10026 = G__10038;
chunk__9986_10027 = G__10039;
count__9987_10028 = G__10040;
i__9988_10029 = G__10041;
continue;
} else {
var fld_10042 = cljs.core.first(seq__9985_10036__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10042," = ",fld_10042,";");


var G__10043 = cljs.core.next(seq__9985_10036__$1);
var G__10044 = null;
var G__10045 = (0);
var G__10046 = (0);
seq__9985_10026 = G__10043;
chunk__9986_10027 = G__10044;
count__9987_10028 = G__10045;
i__9988_10029 = G__10046;
continue;
}
} else {
}
}
break;
}

var seq__9989_10047 = cljs.core.seq(pmasks);
var chunk__9990_10048 = null;
var count__9991_10049 = (0);
var i__9992_10050 = (0);
while(true){
if((i__9992_10050 < count__9991_10049)){
var vec__9999_10051 = chunk__9990_10048.cljs$core$IIndexed$_nth$arity$2(null,i__9992_10050);
var pno_10052 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9999_10051,(0),null);
var pmask_10053 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9999_10051,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10052,"$ = ",pmask_10053,";");


var G__10054 = seq__9989_10047;
var G__10055 = chunk__9990_10048;
var G__10056 = count__9991_10049;
var G__10057 = (i__9992_10050 + (1));
seq__9989_10047 = G__10054;
chunk__9990_10048 = G__10055;
count__9991_10049 = G__10056;
i__9992_10050 = G__10057;
continue;
} else {
var temp__5753__auto___10058 = cljs.core.seq(seq__9989_10047);
if(temp__5753__auto___10058){
var seq__9989_10059__$1 = temp__5753__auto___10058;
if(cljs.core.chunked_seq_QMARK_(seq__9989_10059__$1)){
var c__4591__auto___10060 = cljs.core.chunk_first(seq__9989_10059__$1);
var G__10061 = cljs.core.chunk_rest(seq__9989_10059__$1);
var G__10062 = c__4591__auto___10060;
var G__10063 = cljs.core.count(c__4591__auto___10060);
var G__10064 = (0);
seq__9989_10047 = G__10061;
chunk__9990_10048 = G__10062;
count__9991_10049 = G__10063;
i__9992_10050 = G__10064;
continue;
} else {
var vec__10002_10065 = cljs.core.first(seq__9989_10059__$1);
var pno_10066 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10002_10065,(0),null);
var pmask_10067 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10002_10065,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10066,"$ = ",pmask_10067,";");


var G__10068 = cljs.core.next(seq__9989_10059__$1);
var G__10069 = null;
var G__10070 = (0);
var G__10071 = (0);
seq__9989_10047 = G__10068;
chunk__9990_10048 = G__10069;
count__9991_10049 = G__10070;
i__9992_10050 = G__10071;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$defrecord,(function (p__10072){
var map__10073 = p__10072;
var map__10073__$1 = cljs.core.__destructure_map(map__10073);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10073__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10073__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10073__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10073__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10073__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$__meta,cljs.core.cst$sym$__extmap,cljs.core.cst$sym$__hash], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__10074_10098 = cljs.core.seq(protocols);
var chunk__10075_10099 = null;
var count__10076_10100 = (0);
var i__10077_10101 = (0);
while(true){
if((i__10077_10101 < count__10076_10100)){
var protocol_10102 = chunk__10075_10099.cljs$core$IIndexed$_nth$arity$2(null,i__10077_10101);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10102)),"}");


var G__10103 = seq__10074_10098;
var G__10104 = chunk__10075_10099;
var G__10105 = count__10076_10100;
var G__10106 = (i__10077_10101 + (1));
seq__10074_10098 = G__10103;
chunk__10075_10099 = G__10104;
count__10076_10100 = G__10105;
i__10077_10101 = G__10106;
continue;
} else {
var temp__5753__auto___10107 = cljs.core.seq(seq__10074_10098);
if(temp__5753__auto___10107){
var seq__10074_10108__$1 = temp__5753__auto___10107;
if(cljs.core.chunked_seq_QMARK_(seq__10074_10108__$1)){
var c__4591__auto___10109 = cljs.core.chunk_first(seq__10074_10108__$1);
var G__10110 = cljs.core.chunk_rest(seq__10074_10108__$1);
var G__10111 = c__4591__auto___10109;
var G__10112 = cljs.core.count(c__4591__auto___10109);
var G__10113 = (0);
seq__10074_10098 = G__10110;
chunk__10075_10099 = G__10111;
count__10076_10100 = G__10112;
i__10077_10101 = G__10113;
continue;
} else {
var protocol_10114 = cljs.core.first(seq__10074_10108__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10114)),"}");


var G__10115 = cljs.core.next(seq__10074_10108__$1);
var G__10116 = null;
var G__10117 = (0);
var G__10118 = (0);
seq__10074_10098 = G__10115;
chunk__10075_10099 = G__10116;
count__10076_10100 = G__10117;
i__10077_10101 = G__10118;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__10078_10119 = cljs.core.seq(fields__$1);
var chunk__10079_10120 = null;
var count__10080_10121 = (0);
var i__10081_10122 = (0);
while(true){
if((i__10081_10122 < count__10080_10121)){
var fld_10123 = chunk__10079_10120.cljs$core$IIndexed$_nth$arity$2(null,i__10081_10122);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10123," = ",fld_10123,";");


var G__10124 = seq__10078_10119;
var G__10125 = chunk__10079_10120;
var G__10126 = count__10080_10121;
var G__10127 = (i__10081_10122 + (1));
seq__10078_10119 = G__10124;
chunk__10079_10120 = G__10125;
count__10080_10121 = G__10126;
i__10081_10122 = G__10127;
continue;
} else {
var temp__5753__auto___10128 = cljs.core.seq(seq__10078_10119);
if(temp__5753__auto___10128){
var seq__10078_10129__$1 = temp__5753__auto___10128;
if(cljs.core.chunked_seq_QMARK_(seq__10078_10129__$1)){
var c__4591__auto___10130 = cljs.core.chunk_first(seq__10078_10129__$1);
var G__10131 = cljs.core.chunk_rest(seq__10078_10129__$1);
var G__10132 = c__4591__auto___10130;
var G__10133 = cljs.core.count(c__4591__auto___10130);
var G__10134 = (0);
seq__10078_10119 = G__10131;
chunk__10079_10120 = G__10132;
count__10080_10121 = G__10133;
i__10081_10122 = G__10134;
continue;
} else {
var fld_10135 = cljs.core.first(seq__10078_10129__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10135," = ",fld_10135,";");


var G__10136 = cljs.core.next(seq__10078_10129__$1);
var G__10137 = null;
var G__10138 = (0);
var G__10139 = (0);
seq__10078_10119 = G__10136;
chunk__10079_10120 = G__10137;
count__10080_10121 = G__10138;
i__10081_10122 = G__10139;
continue;
}
} else {
}
}
break;
}

var seq__10082_10140 = cljs.core.seq(pmasks);
var chunk__10083_10141 = null;
var count__10084_10142 = (0);
var i__10085_10143 = (0);
while(true){
if((i__10085_10143 < count__10084_10142)){
var vec__10092_10144 = chunk__10083_10141.cljs$core$IIndexed$_nth$arity$2(null,i__10085_10143);
var pno_10145 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10092_10144,(0),null);
var pmask_10146 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10092_10144,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10145,"$ = ",pmask_10146,";");


var G__10147 = seq__10082_10140;
var G__10148 = chunk__10083_10141;
var G__10149 = count__10084_10142;
var G__10150 = (i__10085_10143 + (1));
seq__10082_10140 = G__10147;
chunk__10083_10141 = G__10148;
count__10084_10142 = G__10149;
i__10085_10143 = G__10150;
continue;
} else {
var temp__5753__auto___10151 = cljs.core.seq(seq__10082_10140);
if(temp__5753__auto___10151){
var seq__10082_10152__$1 = temp__5753__auto___10151;
if(cljs.core.chunked_seq_QMARK_(seq__10082_10152__$1)){
var c__4591__auto___10153 = cljs.core.chunk_first(seq__10082_10152__$1);
var G__10154 = cljs.core.chunk_rest(seq__10082_10152__$1);
var G__10155 = c__4591__auto___10153;
var G__10156 = cljs.core.count(c__4591__auto___10153);
var G__10157 = (0);
seq__10082_10140 = G__10154;
chunk__10083_10141 = G__10155;
count__10084_10142 = G__10156;
i__10085_10143 = G__10157;
continue;
} else {
var vec__10095_10158 = cljs.core.first(seq__10082_10152__$1);
var pno_10159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10095_10158,(0),null);
var pmask_10160 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10095_10158,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10159,"$ = ",pmask_10160,";");


var G__10161 = cljs.core.next(seq__10082_10152__$1);
var G__10162 = null;
var G__10163 = (0);
var G__10164 = (0);
seq__10082_10140 = G__10161;
chunk__10083_10141 = G__10162;
count__10084_10142 = G__10163;
i__10085_10143 = G__10164;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__10165){
var map__10166 = p__10165;
var map__10166__$1 = cljs.core.__destructure_map(map__10166);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10166__$1,cljs.core.cst$kw$target);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10166__$1,cljs.core.cst$kw$field);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10166__$1,cljs.core.cst$kw$method);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10166__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10166__$1,cljs.core.cst$kw$env);
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_field,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_call,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js,(function (p__10167){
var map__10168 = p__10167;
var map__10168__$1 = cljs.core.__destructure_map(map__10168);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10168__$1,cljs.core.cst$kw$op);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10168__$1,cljs.core.cst$kw$env);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10168__$1,cljs.core.cst$kw$code);
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10168__$1,cljs.core.cst$kw$segs);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10168__$1,cljs.core.cst$kw$args);
if(cljs.core.truth_((function (){var and__4149__auto__ = code;
if(cljs.core.truth_(and__4149__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4149__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__8957__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__8957__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__10173 = cljs.core.seq(table);
var chunk__10174 = null;
var count__10175 = (0);
var i__10176 = (0);
while(true){
if((i__10176 < count__10175)){
var vec__10183 = chunk__10174.cljs$core$IIndexed$_nth$arity$2(null,i__10176);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10183,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10183,(1),null);
var ns_10189 = cljs.core.namespace(sym);
var name_10190 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__10191 = seq__10173;
var G__10192 = chunk__10174;
var G__10193 = count__10175;
var G__10194 = (i__10176 + (1));
seq__10173 = G__10191;
chunk__10174 = G__10192;
count__10175 = G__10193;
i__10176 = G__10194;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__10173);
if(temp__5753__auto__){
var seq__10173__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10173__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__10173__$1);
var G__10195 = cljs.core.chunk_rest(seq__10173__$1);
var G__10196 = c__4591__auto__;
var G__10197 = cljs.core.count(c__4591__auto__);
var G__10198 = (0);
seq__10173 = G__10195;
chunk__10174 = G__10196;
count__10175 = G__10197;
i__10176 = G__10198;
continue;
} else {
var vec__10186 = cljs.core.first(seq__10173__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10186,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10186,(1),null);
var ns_10199 = cljs.core.namespace(sym);
var name_10200 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__10201 = cljs.core.next(seq__10173__$1);
var G__10202 = null;
var G__10203 = (0);
var G__10204 = (0);
seq__10173 = G__10201;
chunk__10174 = G__10202;
count__10175 = G__10203;
i__10176 = G__10204;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__10206 = arguments.length;
switch (G__10206) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_10211 = cljs.core.first(ks);
var vec__10207_10212 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_10211);
var top_10213 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10207_10212,(0),null);
var prefix_SINGLEQUOTE__10214 = vec__10207_10212;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$prototype,k_10211)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__10214) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_10213)) || (cljs.core.contains_QMARK_(known_externs,top_10213)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__10214)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_10213);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__10214)),";");
}
} else {
}

var m_10215 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_10211);
if(cljs.core.empty_QMARK_(m_10215)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__10214,m_10215,top_level,known_externs);
}

var G__10216 = cljs.core.next(ks);
ks = G__10216;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

