// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(500)], 0)));
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(500)], 0)));
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
if(typeof value === 'string'){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return false;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$cas,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$subs,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,300,null,300,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,714,null,714,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,230,null,230,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,157,null,157,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_cas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$cas,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,812,null,812,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$compare_DASH_val,cljs.core.cst$sym$new_DASH_val], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,521,null,521,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,427,null,427,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,145,null,145,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,388,null,388,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,256,null,256,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,86,null,86,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,726,null,726,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,533,null,533,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,607,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,620,null,620,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,750,null,750,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,98,null,98,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,169,null,169,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,778,null,778,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,696,null,696,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,414,null,414,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,466,null,466,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,788,null,788,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,73,null,73,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,188,null,188,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,568,null,568,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,659,null,659,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,453,null,453,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,109,null,109,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,594,null,594,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,1,506,null,506,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,332,332,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,558,null,558,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,545,null,545,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,800,null,800,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not_EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not_EQ_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,440,null,440,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,270,null,270,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,121,null,121,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,401,null,401,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,581,null,581,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,762,null,762,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,1,347,347,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,361,361,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,684,null,684,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,214,null,214,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,58,null,58,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_subs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$subs,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,133,null,133,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,633,null,633,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,201,null,201,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,646,null,646,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,479,null,479,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,1,288,null,288,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,738,null,738,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,243,null,243,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"/Users/bplatz/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,671,null,671,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__73702 = cljs.core.meta(f);
var map__73702__$1 = cljs.core.__destructure_map(map__73702);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73702__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73702__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4149__auto__ = (function (){var G__73708 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__73707 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__73707.cljs$core$IFn$_invoke$arity$1 ? fexpr__73707.cljs$core$IFn$_invoke$arity$1(G__73708) : fexpr__73707.call(null,G__73708));
})();
if(cljs.core.truth_(and__4149__auto__)){
var G__73710 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__73709 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__73709.cljs$core$IFn$_invoke$arity$1 ? fexpr__73709.cljs$core$IFn$_invoke$arity$1(G__73710) : fexpr__73709.call(null,G__73710));
} else {
return and__4149__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__73701_SHARP_){
return (cljs.core.count(p1__73701_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_fn,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_73804){
var state_val_73805 = (state_73804[(1)]);
if((state_val_73805 === (7))){
var state_73804__$1 = state_73804;
var statearr_73806_73848 = state_73804__$1;
(statearr_73806_73848[(2)] = null);

(statearr_73806_73848[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (20))){
var inst_73786 = (state_73804[(7)]);
var inst_73789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73790 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_73791 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_73792 = [inst_73790,inst_73791,fn_name];
var inst_73793 = (new cljs.core.PersistentVector(null,3,(5),inst_73789,inst_73792,null));
var inst_73794 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_73793,inst_73786);
var state_73804__$1 = state_73804;
var statearr_73807_73849 = state_73804__$1;
(statearr_73807_73849[(2)] = inst_73794);

(statearr_73807_73849[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (1))){
var state_73804__$1 = state_73804;
var statearr_73808_73850 = state_73804__$1;
(statearr_73808_73850[(2)] = null);

(statearr_73808_73850[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (4))){
var inst_73711 = (state_73804[(2)]);
var state_73804__$1 = state_73804;
var statearr_73809_73851 = state_73804__$1;
(statearr_73809_73851[(2)] = inst_73711);

(statearr_73809_73851[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (15))){
var inst_73750 = (state_73804[(8)]);
var inst_73749 = (state_73804[(2)]);
var inst_73750__$1 = fluree.db.util.async.throw_err(inst_73749);
var inst_73751 = cljs.core.empty_QMARK_(inst_73750__$1);
var state_73804__$1 = (function (){var statearr_73810 = state_73804;
(statearr_73810[(8)] = inst_73750__$1);

return statearr_73810;
})();
if(inst_73751){
var statearr_73811_73852 = state_73804__$1;
(statearr_73811_73852[(1)] = (16));

} else {
var statearr_73812_73853 = state_73804__$1;
(statearr_73812_73853[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (21))){
var state_73804__$1 = state_73804;
var statearr_73813_73854 = state_73804__$1;
(statearr_73813_73854[(2)] = null);

(statearr_73813_73854[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (13))){
var inst_73746 = (state_73804[(9)]);
var inst_73737 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_73738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73739 = ["_fn/params","_fn/code","_fn/spec"];
var inst_73740 = (new cljs.core.PersistentVector(null,3,(5),inst_73738,inst_73739,null));
var inst_73741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73742 = cljs.core.name(fn_name);
var inst_73743 = ["_fn/name",inst_73742];
var inst_73744 = (new cljs.core.PersistentVector(null,2,(5),inst_73741,inst_73743,null));
var inst_73745 = [inst_73740,inst_73744];
var inst_73746__$1 = cljs.core.PersistentHashMap.fromArrays(inst_73737,inst_73745);
var inst_73747 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_73746__$1);
var state_73804__$1 = (function (){var statearr_73814 = state_73804;
(statearr_73814[(9)] = inst_73746__$1);

return statearr_73814;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73804__$1,(15),inst_73747);
} else {
if((state_val_73805 === (22))){
var inst_73786 = (state_73804[(7)]);
var inst_73797 = (state_73804[(2)]);
var state_73804__$1 = (function (){var statearr_73815 = state_73804;
(statearr_73815[(10)] = inst_73797);

return statearr_73815;
})();
var statearr_73816_73855 = state_73804__$1;
(statearr_73816_73855[(2)] = inst_73786);

(statearr_73816_73855[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (6))){
var inst_73720 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_73721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73722 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_73723 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_73724 = [inst_73722,inst_73723,fn_name];
var inst_73725 = (new cljs.core.PersistentVector(null,3,(5),inst_73721,inst_73724,null));
var inst_73726 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73720,inst_73725);
var state_73804__$1 = state_73804;
var statearr_73817_73856 = state_73804__$1;
(statearr_73817_73856[(2)] = inst_73726);

(statearr_73817_73856[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (17))){
var state_73804__$1 = state_73804;
var statearr_73818_73857 = state_73804__$1;
(statearr_73818_73857[(2)] = null);

(statearr_73818_73857[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (3))){
var inst_73802 = (state_73804[(2)]);
var state_73804__$1 = state_73804;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73804__$1,inst_73802);
} else {
if((state_val_73805 === (12))){
var inst_73733 = (state_73804[(11)]);
var inst_73735 = fluree.db.dbfunctions.core.resolve_local_fn(inst_73733);
var state_73804__$1 = state_73804;
var statearr_73819_73858 = state_73804__$1;
(statearr_73819_73858[(2)] = inst_73735);

(statearr_73819_73858[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (2))){
var inst_73717 = (state_73804[(12)]);
var _ = (function (){var statearr_73820 = state_73804;
(statearr_73820[(4)] = cljs.core.cons((5),(state_73804[(4)])));

return statearr_73820;
})();
var inst_73717__$1 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_73718 = cljs.core.not(inst_73717__$1);
var state_73804__$1 = (function (){var statearr_73821 = state_73804;
(statearr_73821[(12)] = inst_73717__$1);

return statearr_73821;
})();
if(inst_73718){
var statearr_73822_73859 = state_73804__$1;
(statearr_73822_73859[(1)] = (6));

} else {
var statearr_73823_73860 = state_73804__$1;
(statearr_73823_73860[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (19))){
var inst_73764 = (state_73804[(13)]);
var inst_73750 = (state_73804[(8)]);
var inst_73717 = (state_73804[(12)]);
var inst_73729 = (state_73804[(14)]);
var inst_73762 = (state_73804[(15)]);
var inst_73746 = (state_73804[(9)]);
var inst_73733 = (state_73804[(11)]);
var inst_73769 = (state_73804[(2)]);
var inst_73770 = fluree.db.util.async.throw_err(inst_73769);
var inst_73771 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73750,"_fn/spec");
var inst_73772 = cljs.core.PersistentVector.EMPTY;
var inst_73773 = cljs.core.cst$sym$_QMARK_ctx;
var inst_73774 = (function (){var res = inst_73750;
var query = inst_73746;
var forward_time_travel_db_QMARK_ = inst_73717;
var _ = inst_73762;
var params = inst_73764;
var temp__5751__auto__ = inst_73733;
var or__4160__auto__ = inst_73729;
var spec = inst_73771;
var code = inst_73770;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_73775 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_73774,inst_73764);
var inst_73776 = cljs.core.cons(inst_73773,inst_73775);
var inst_73777 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_73772,inst_73776);
var inst_73778 = fluree.db.dbfunctions.core.build_fn(inst_73777,inst_73770);
var inst_73779 = [cljs.core.cst$kw$f,cljs.core.cst$kw$params,cljs.core.cst$kw$arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,cljs.core.cst$kw$code];
var inst_73780 = cljs.core.count(inst_73764);
var inst_73781 = [inst_73780];
var inst_73782 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_73781);
var inst_73783 = [inst_73778,inst_73764,inst_73782,false,inst_73771,null];
var inst_73784 = cljs.core.PersistentHashMap.fromArrays(inst_73779,inst_73783);
var state_73804__$1 = state_73804;
var statearr_73824_73861 = state_73804__$1;
(statearr_73824_73861[(2)] = inst_73784);

(statearr_73824_73861[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (11))){
var inst_73799 = (state_73804[(2)]);
var _ = (function (){var statearr_73826 = state_73804;
(statearr_73826[(4)] = cljs.core.rest((state_73804[(4)])));

return statearr_73826;
})();
var state_73804__$1 = state_73804;
var statearr_73827_73862 = state_73804__$1;
(statearr_73827_73862[(2)] = inst_73799);

(statearr_73827_73862[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (9))){
var inst_73729 = (state_73804[(14)]);
var state_73804__$1 = state_73804;
var statearr_73828_73863 = state_73804__$1;
(statearr_73828_73863[(2)] = inst_73729);

(statearr_73828_73863[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (5))){
var _ = (function (){var statearr_73829 = state_73804;
(statearr_73829[(4)] = cljs.core.rest((state_73804[(4)])));

return statearr_73829;
})();
var state_73804__$1 = state_73804;
var ex73825 = (state_73804__$1[(2)]);
var statearr_73830_73864 = state_73804__$1;
(statearr_73830_73864[(5)] = ex73825);


if((ex73825 instanceof Error)){
var statearr_73831_73865 = state_73804__$1;
(statearr_73831_73865[(1)] = (4));

(statearr_73831_73865[(5)] = null);

} else {
throw ex73825;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (14))){
var inst_73717 = (state_73804[(12)]);
var inst_73786 = (state_73804[(2)]);
var inst_73787 = cljs.core.not(inst_73717);
var state_73804__$1 = (function (){var statearr_73832 = state_73804;
(statearr_73832[(7)] = inst_73786);

return statearr_73832;
})();
if(inst_73787){
var statearr_73833_73866 = state_73804__$1;
(statearr_73833_73866[(1)] = (20));

} else {
var statearr_73834_73867 = state_73804__$1;
(statearr_73834_73867[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (16))){
var inst_73753 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_73754 = ["Unknown function: ",inst_73753].join('');
var inst_73755 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_73756 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_73757 = cljs.core.PersistentHashMap.fromArrays(inst_73755,inst_73756);
var inst_73758 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73754,inst_73757);
var inst_73759 = (function(){throw inst_73758})();
var state_73804__$1 = state_73804;
var statearr_73835_73868 = state_73804__$1;
(statearr_73835_73868[(2)] = inst_73759);

(statearr_73835_73868[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (10))){
var inst_73733 = (state_73804[(11)]);
var inst_73732 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name);
var inst_73733__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,inst_73732);
var state_73804__$1 = (function (){var statearr_73836 = state_73804;
(statearr_73836[(11)] = inst_73733__$1);

return statearr_73836;
})();
if(cljs.core.truth_(inst_73733__$1)){
var statearr_73837_73869 = state_73804__$1;
(statearr_73837_73869[(1)] = (12));

} else {
var statearr_73838_73870 = state_73804__$1;
(statearr_73838_73870[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73805 === (18))){
var inst_73764 = (state_73804[(13)]);
var inst_73750 = (state_73804[(8)]);
var inst_73762 = (state_73804[(2)]);
var inst_73763 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73750,"_fn/params");
var inst_73764__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_73763);
var inst_73765 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73750,"_fn/code");
var inst_73766 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_73765);
var inst_73767 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_73766,funType,inst_73764__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_73766,funType,inst_73764__$1));
var state_73804__$1 = (function (){var statearr_73839 = state_73804;
(statearr_73839[(13)] = inst_73764__$1);

(statearr_73839[(15)] = inst_73762);

return statearr_73839;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73804__$1,(19),inst_73767);
} else {
if((state_val_73805 === (8))){
var inst_73729 = (state_73804[(14)]);
var inst_73729__$1 = (state_73804[(2)]);
var state_73804__$1 = (function (){var statearr_73840 = state_73804;
(statearr_73840[(14)] = inst_73729__$1);

return statearr_73840;
})();
if(cljs.core.truth_(inst_73729__$1)){
var statearr_73841_73871 = state_73804__$1;
(statearr_73841_73871[(1)] = (9));

} else {
var statearr_73842_73872 = state_73804__$1;
(statearr_73842_73872[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto____0 = (function (){
var statearr_73843 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73843[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto__);

(statearr_73843[(1)] = (1));

return statearr_73843;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto____1 = (function (state_73804){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_73804);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e73844){var ex__13886__auto__ = e73844;
var statearr_73845_73873 = state_73804;
(statearr_73845_73873[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_73804[(4)]))){
var statearr_73846_73874 = state_73804;
(statearr_73846_73874[(1)] = cljs.core.first((state_73804[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__73875 = state_73804;
state_73804 = G__73875;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto__ = function(state_73804){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto____1.call(this,state_73804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_73847 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_73847[(6)] = c__13957__auto__);

return statearr_73847;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__73877 = arguments.length;
switch (G__73877) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__73881 = arguments.length;
switch (G__73881) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_74004){
var state_val_74005 = (state_74004[(1)]);
if((state_val_74005 === (7))){
var inst_73999 = (state_74004[(2)]);
var _ = (function (){var statearr_74006 = state_74004;
(statearr_74006[(4)] = cljs.core.rest((state_74004[(4)])));

return statearr_74006;
})();
var state_74004__$1 = state_74004;
var statearr_74007_74077 = state_74004__$1;
(statearr_74007_74077[(2)] = inst_73999);

(statearr_74007_74077[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (20))){
var inst_73920 = (state_74004[(7)]);
var state_74004__$1 = state_74004;
var statearr_74008_74078 = state_74004__$1;
(statearr_74008_74078[(2)] = inst_73920);

(statearr_74008_74078[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (27))){
var inst_73907 = (state_74004[(8)]);
var inst_73933 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_73934 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73907)," used in function.",inst_73933].join('');
var inst_73935 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_73936 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_73937 = cljs.core.PersistentHashMap.fromArrays(inst_73935,inst_73936);
var inst_73938 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73934,inst_73937);
var inst_73939 = (function(){throw inst_73938})();
var state_74004__$1 = state_74004;
var statearr_74009_74079 = state_74004__$1;
(statearr_74009_74079[(2)] = inst_73939);

(statearr_74009_74079[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (1))){
var state_74004__$1 = state_74004;
var statearr_74010_74080 = state_74004__$1;
(statearr_74010_74080[(2)] = null);

(statearr_74010_74080[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (24))){
var inst_73930 = (state_74004[(9)]);
var inst_73930__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_74004__$1 = (function (){var statearr_74011 = state_74004;
(statearr_74011[(9)] = inst_73930__$1);

return statearr_74011;
})();
if(inst_73930__$1){
var statearr_74012_74081 = state_74004__$1;
(statearr_74012_74081[(1)] = (26));

} else {
var statearr_74013_74082 = state_74004__$1;
(statearr_74013_74082[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (39))){
var inst_73907 = (state_74004[(8)]);
var inst_73965 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_73907,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_73907,funType,params));
var state_74004__$1 = state_74004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74004__$1,(42),inst_73965);
} else {
if((state_val_74005 === (4))){
var inst_73882 = (state_74004[(2)]);
var state_74004__$1 = state_74004;
var statearr_74014_74083 = state_74004__$1;
(statearr_74014_74083[(2)] = inst_73882);

(statearr_74014_74083[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (15))){
var inst_73907 = (state_74004[(8)]);
var inst_73918 = (inst_73907 instanceof cljs.core.Symbol);
var state_74004__$1 = state_74004;
if(cljs.core.truth_(inst_73918)){
var statearr_74015_74084 = state_74004__$1;
(statearr_74015_74084[(1)] = (17));

} else {
var statearr_74016_74085 = state_74004__$1;
(statearr_74016_74085[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (21))){
var inst_73927 = (state_74004[(10)]);
var inst_73895 = (state_74004[(11)]);
var inst_73901 = (state_74004[(12)]);
var inst_73898 = (state_74004[(13)]);
var inst_73920 = (state_74004[(7)]);
var inst_73907 = (state_74004[(8)]);
var inst_73900 = (state_74004[(14)]);
var inst_73897 = (state_74004[(15)]);
var inst_73908 = (state_74004[(16)]);
var inst_73923 = [inst_73907];
var inst_73924 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_73923);
var inst_73925 = (function (){var x = inst_73907;
var G__73891 = inst_73900;
var first__73905 = inst_73907;
var r = inst_73908;
var acc = inst_73901;
var seq__73904 = inst_73908;
var first__73894 = inst_73897;
var seq__73893 = inst_73898;
var vec__73903 = inst_73900;
var or__4160__auto__ = inst_73920;
var vec__73892 = inst_73895;
return (function (p1__73879_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__73879_SHARP_);
});
})();
var inst_73926 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_73925,params);
var inst_73927__$1 = cljs.core.some(inst_73924,inst_73926);
var state_74004__$1 = (function (){var statearr_74017 = state_74004;
(statearr_74017[(10)] = inst_73927__$1);

return statearr_74017;
})();
if(cljs.core.truth_(inst_73927__$1)){
var statearr_74018_74086 = state_74004__$1;
(statearr_74018_74086[(1)] = (23));

} else {
var statearr_74019_74087 = state_74004__$1;
(statearr_74019_74087[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (31))){
var inst_73987 = (state_74004[(2)]);
var state_74004__$1 = state_74004;
var statearr_74020_74088 = state_74004__$1;
(statearr_74020_74088[(2)] = inst_73987);

(statearr_74020_74088[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (32))){
var inst_73907 = (state_74004[(8)]);
var inst_73955 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_73907,funType,params);
var state_74004__$1 = state_74004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74004__$1,(35),inst_73955);
} else {
if((state_val_74005 === (40))){
var state_74004__$1 = state_74004;
var statearr_74021_74089 = state_74004__$1;
(statearr_74021_74089[(1)] = (43));



return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (33))){
var inst_73907 = (state_74004[(8)]);
var inst_73960 = (inst_73907 == null);
var state_74004__$1 = state_74004;
if(cljs.core.truth_(inst_73960)){
var statearr_74023_74090 = state_74004__$1;
(statearr_74023_74090[(1)] = (36));

} else {
var statearr_74024_74091 = state_74004__$1;
(statearr_74024_74091[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (13))){
var inst_73901 = (state_74004[(12)]);
var inst_73908 = (state_74004[(16)]);
var inst_73993 = (state_74004[(2)]);
var inst_73994 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_73901,inst_73993);
var inst_73900 = inst_73908;
var inst_73901__$1 = inst_73994;
var state_74004__$1 = (function (){var statearr_74025 = state_74004;
(statearr_74025[(12)] = inst_73901__$1);

(statearr_74025[(14)] = inst_73900);

return statearr_74025;
})();
var statearr_74026_74092 = state_74004__$1;
(statearr_74026_74092[(2)] = null);

(statearr_74026_74092[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (22))){
var inst_73945 = (state_74004[(2)]);
var state_74004__$1 = state_74004;
var statearr_74027_74093 = state_74004__$1;
(statearr_74027_74093[(2)] = inst_73945);

(statearr_74027_74093[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (36))){
var inst_73907 = (state_74004[(8)]);
var state_74004__$1 = state_74004;
var statearr_74028_74094 = state_74004__$1;
(statearr_74028_74094[(2)] = inst_73907);

(statearr_74028_74094[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (41))){
var inst_73981 = (state_74004[(2)]);
var state_74004__$1 = state_74004;
var statearr_74029_74095 = state_74004__$1;
(statearr_74029_74095[(2)] = inst_73981);

(statearr_74029_74095[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (43))){
var inst_73907 = (state_74004[(8)]);
var inst_73971 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73907], 0));
var inst_73972 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_73973 = ["Illegal element (",inst_73971,") in vector: ",inst_73972,"."].join('');
var inst_73974 = cljs.core.PersistentHashMap.EMPTY;
var inst_73975 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73973,inst_73974);
var inst_73976 = (function(){throw inst_73975})();
var state_74004__$1 = state_74004;
var statearr_74030_74096 = state_74004__$1;
(statearr_74030_74096[(2)] = inst_73976);

(statearr_74030_74096[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (29))){
var inst_73907 = (state_74004[(8)]);
var state_74004__$1 = state_74004;
var statearr_74031_74097 = state_74004__$1;
(statearr_74031_74097[(2)] = inst_73907);

(statearr_74031_74097[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (44))){
var state_74004__$1 = state_74004;
var statearr_74032_74098 = state_74004__$1;
(statearr_74032_74098[(2)] = null);

(statearr_74032_74098[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (6))){
var inst_73907 = (state_74004[(8)]);
var inst_73900 = (state_74004[(14)]);
var inst_73906 = cljs.core.seq(inst_73900);
var inst_73907__$1 = cljs.core.first(inst_73906);
var inst_73908 = cljs.core.next(inst_73906);
var inst_73909 = (inst_73907__$1 == null);
var state_74004__$1 = (function (){var statearr_74033 = state_74004;
(statearr_74033[(8)] = inst_73907__$1);

(statearr_74033[(16)] = inst_73908);

return statearr_74033;
})();
if(cljs.core.truth_(inst_73909)){
var statearr_74034_74099 = state_74004__$1;
(statearr_74034_74099[(1)] = (8));

} else {
var statearr_74035_74100 = state_74004__$1;
(statearr_74035_74100[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (28))){
var inst_73941 = (state_74004[(2)]);
var state_74004__$1 = state_74004;
var statearr_74036_74101 = state_74004__$1;
(statearr_74036_74101[(2)] = inst_73941);

(statearr_74036_74101[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (25))){
var inst_73943 = (state_74004[(2)]);
var state_74004__$1 = state_74004;
var statearr_74037_74102 = state_74004__$1;
(statearr_74037_74102[(2)] = inst_73943);

(statearr_74037_74102[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (34))){
var inst_73985 = (state_74004[(2)]);
var state_74004__$1 = state_74004;
var statearr_74038_74103 = state_74004__$1;
(statearr_74038_74103[(2)] = inst_73985);

(statearr_74038_74103[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (17))){
var inst_73920 = (state_74004[(7)]);
var inst_73907 = (state_74004[(8)]);
var inst_73920__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_73907) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_73907));
var state_74004__$1 = (function (){var statearr_74039 = state_74004;
(statearr_74039[(7)] = inst_73920__$1);

return statearr_74039;
})();
if(cljs.core.truth_(inst_73920__$1)){
var statearr_74040_74104 = state_74004__$1;
(statearr_74040_74104[(1)] = (20));

} else {
var statearr_74041_74105 = state_74004__$1;
(statearr_74041_74105[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (3))){
var inst_74002 = (state_74004[(2)]);
var state_74004__$1 = state_74004;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74004__$1,inst_74002);
} else {
if((state_val_74005 === (12))){
var inst_73907 = (state_74004[(8)]);
var inst_73915 = typeof inst_73907 === 'number';
var state_74004__$1 = state_74004;
if(cljs.core.truth_(inst_73915)){
var statearr_74042_74106 = state_74004__$1;
(statearr_74042_74106[(1)] = (14));

} else {
var statearr_74043_74107 = state_74004__$1;
(statearr_74043_74107[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (2))){
var inst_73895 = (state_74004[(11)]);
var _ = (function (){var statearr_74044 = state_74004;
(statearr_74044[(4)] = cljs.core.cons((5),(state_74004[(4)])));

return statearr_74044;
})();
var inst_73895__$1 = vec;
var inst_73896 = cljs.core.seq(inst_73895__$1);
var inst_73897 = cljs.core.first(inst_73896);
var inst_73898 = cljs.core.next(inst_73896);
var inst_73899 = cljs.core.PersistentVector.EMPTY;
var inst_73900 = inst_73895__$1;
var inst_73901 = inst_73899;
var state_74004__$1 = (function (){var statearr_74045 = state_74004;
(statearr_74045[(11)] = inst_73895__$1);

(statearr_74045[(12)] = inst_73901);

(statearr_74045[(13)] = inst_73898);

(statearr_74045[(14)] = inst_73900);

(statearr_74045[(15)] = inst_73897);

return statearr_74045;
})();
var statearr_74046_74108 = state_74004__$1;
(statearr_74046_74108[(2)] = null);

(statearr_74046_74108[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (23))){
var inst_73927 = (state_74004[(10)]);
var state_74004__$1 = state_74004;
var statearr_74047_74109 = state_74004__$1;
(statearr_74047_74109[(2)] = inst_73927);

(statearr_74047_74109[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (35))){
var inst_73957 = (state_74004[(2)]);
var inst_73958 = fluree.db.util.async.throw_err(inst_73957);
var state_74004__$1 = state_74004;
var statearr_74048_74110 = state_74004__$1;
(statearr_74048_74110[(2)] = inst_73958);

(statearr_74048_74110[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (19))){
var inst_73989 = (state_74004[(2)]);
var state_74004__$1 = state_74004;
var statearr_74049_74111 = state_74004__$1;
(statearr_74049_74111[(2)] = inst_73989);

(statearr_74049_74111[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (11))){
var inst_73907 = (state_74004[(8)]);
var state_74004__$1 = state_74004;
var statearr_74051_74112 = state_74004__$1;
(statearr_74051_74112[(2)] = inst_73907);

(statearr_74051_74112[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (9))){
var inst_73907 = (state_74004[(8)]);
var inst_73912 = typeof inst_73907 === 'string';
var state_74004__$1 = state_74004;
if(cljs.core.truth_(inst_73912)){
var statearr_74052_74113 = state_74004__$1;
(statearr_74052_74113[(1)] = (11));

} else {
var statearr_74053_74114 = state_74004__$1;
(statearr_74053_74114[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (5))){
var _ = (function (){var statearr_74054 = state_74004;
(statearr_74054[(4)] = cljs.core.rest((state_74004[(4)])));

return statearr_74054;
})();
var state_74004__$1 = state_74004;
var ex74050 = (state_74004__$1[(2)]);
var statearr_74055_74115 = state_74004__$1;
(statearr_74055_74115[(5)] = ex74050);


if((ex74050 instanceof Error)){
var statearr_74056_74116 = state_74004__$1;
(statearr_74056_74116[(1)] = (4));

(statearr_74056_74116[(5)] = null);

} else {
throw ex74050;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (14))){
var inst_73907 = (state_74004[(8)]);
var state_74004__$1 = state_74004;
var statearr_74057_74117 = state_74004__$1;
(statearr_74057_74117[(2)] = inst_73907);

(statearr_74057_74117[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (45))){
var inst_73979 = (state_74004[(2)]);
var state_74004__$1 = state_74004;
var statearr_74058_74118 = state_74004__$1;
(statearr_74058_74118[(2)] = inst_73979);

(statearr_74058_74118[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (26))){
var inst_73930 = (state_74004[(9)]);
var state_74004__$1 = state_74004;
var statearr_74059_74119 = state_74004__$1;
(statearr_74059_74119[(2)] = inst_73930);

(statearr_74059_74119[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (16))){
var inst_73991 = (state_74004[(2)]);
var state_74004__$1 = state_74004;
var statearr_74060_74120 = state_74004__$1;
(statearr_74060_74120[(2)] = inst_73991);

(statearr_74060_74120[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (38))){
var inst_73983 = (state_74004[(2)]);
var state_74004__$1 = state_74004;
var statearr_74061_74121 = state_74004__$1;
(statearr_74061_74121[(2)] = inst_73983);

(statearr_74061_74121[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (30))){
var inst_73907 = (state_74004[(8)]);
var inst_73953 = cljs.core.vector_QMARK_(inst_73907);
var state_74004__$1 = state_74004;
if(inst_73953){
var statearr_74062_74122 = state_74004__$1;
(statearr_74062_74122[(1)] = (32));

} else {
var statearr_74063_74123 = state_74004__$1;
(statearr_74063_74123[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (10))){
var inst_73997 = (state_74004[(2)]);
var state_74004__$1 = state_74004;
var statearr_74064_74124 = state_74004__$1;
(statearr_74064_74124[(2)] = inst_73997);

(statearr_74064_74124[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (18))){
var inst_73907 = (state_74004[(8)]);
var inst_73947 = inst_73907 === true;
var inst_73948 = inst_73907 === false;
var inst_73949 = (inst_73907 == null);
var inst_73950 = ((inst_73947) || (inst_73948) || (inst_73949));
var state_74004__$1 = state_74004;
if(cljs.core.truth_(inst_73950)){
var statearr_74065_74125 = state_74004__$1;
(statearr_74065_74125[(1)] = (29));

} else {
var statearr_74066_74126 = state_74004__$1;
(statearr_74066_74126[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (42))){
var inst_73967 = (state_74004[(2)]);
var inst_73968 = fluree.db.util.async.throw_err(inst_73967);
var state_74004__$1 = state_74004;
var statearr_74067_74127 = state_74004__$1;
(statearr_74067_74127[(2)] = inst_73968);

(statearr_74067_74127[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (37))){
var inst_73907 = (state_74004[(8)]);
var inst_73963 = cljs.core.list_QMARK_(inst_73907);
var state_74004__$1 = state_74004;
if(inst_73963){
var statearr_74068_74128 = state_74004__$1;
(statearr_74068_74128[(1)] = (39));

} else {
var statearr_74069_74129 = state_74004__$1;
(statearr_74069_74129[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74005 === (8))){
var inst_73901 = (state_74004[(12)]);
var state_74004__$1 = state_74004;
var statearr_74070_74130 = state_74004__$1;
(statearr_74070_74130[(2)] = inst_73901);

(statearr_74070_74130[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__13883__auto____0 = (function (){
var statearr_74071 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74071[(0)] = fluree$db$dbfunctions$core$state_machine__13883__auto__);

(statearr_74071[(1)] = (1));

return statearr_74071;
});
var fluree$db$dbfunctions$core$state_machine__13883__auto____1 = (function (state_74004){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74004);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74072){var ex__13886__auto__ = e74072;
var statearr_74073_74131 = state_74004;
(statearr_74073_74131[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74004[(4)]))){
var statearr_74074_74132 = state_74004;
(statearr_74074_74132[(1)] = cljs.core.first((state_74004[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74133 = state_74004;
state_74004 = G__74133;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__13883__auto__ = function(state_74004){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__13883__auto____1.call(this,state_74004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__13883__auto____0;
fluree$db$dbfunctions$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__13883__auto____1;
return fluree$db$dbfunctions$core$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_74075 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74075[(6)] = c__13957__auto__);

return statearr_74075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__74136 = arguments.length;
switch (G__74136) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_74293){
var state_val_74294 = (state_74293[(1)]);
if((state_val_74294 === (7))){
var inst_74155 = (state_74293[(7)]);
var state_74293__$1 = state_74293;
var statearr_74295_74380 = state_74293__$1;
(statearr_74295_74380[(2)] = inst_74155);

(statearr_74295_74380[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (20))){
var inst_74283 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
var statearr_74296_74381 = state_74293__$1;
(statearr_74296_74381[(2)] = inst_74283);

(statearr_74296_74381[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (27))){
var inst_74276 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
var statearr_74297_74382 = state_74293__$1;
(statearr_74297_74382[(2)] = inst_74276);

(statearr_74297_74382[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (1))){
var state_74293__$1 = state_74293;
var statearr_74298_74383 = state_74293__$1;
(statearr_74298_74383[(2)] = null);

(statearr_74298_74383[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (24))){
var inst_74200 = (state_74293[(2)]);
var inst_74201 = fluree.db.util.async.throw_err(inst_74200);
var state_74293__$1 = state_74293;
var statearr_74299_74384 = state_74293__$1;
(statearr_74299_74384[(2)] = inst_74201);

(statearr_74299_74384[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (55))){
var inst_74264 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
var statearr_74300_74385 = state_74293__$1;
(statearr_74300_74385[(2)] = inst_74264);

(statearr_74300_74385[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (39))){
var inst_74234 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
var statearr_74301_74386 = state_74293__$1;
(statearr_74301_74386[(2)] = inst_74234);

(statearr_74301_74386[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (46))){
var inst_74188 = (state_74293[(8)]);
var inst_74246 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_74188,type,params);
var state_74293__$1 = state_74293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74293__$1,(49),inst_74246);
} else {
if((state_val_74294 === (4))){
var inst_74137 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
var statearr_74302_74387 = state_74293__$1;
(statearr_74302_74387[(2)] = inst_74137);

(statearr_74302_74387[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (54))){
var state_74293__$1 = state_74293;
var statearr_74303_74388 = state_74293__$1;
(statearr_74303_74388[(2)] = null);

(statearr_74303_74388[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (15))){
var inst_74188 = (state_74293[(8)]);
var state_74293__$1 = state_74293;
var statearr_74304_74389 = state_74293__$1;
(statearr_74304_74389[(2)] = inst_74188);

(statearr_74304_74389[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (48))){
var inst_74268 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
var statearr_74305_74390 = state_74293__$1;
(statearr_74305_74390[(2)] = inst_74268);

(statearr_74305_74390[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (50))){
var inst_74188 = (state_74293[(8)]);
var state_74293__$1 = state_74293;
var statearr_74306_74391 = state_74293__$1;
(statearr_74306_74391[(2)] = inst_74188);

(statearr_74306_74391[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (21))){
var inst_74188 = (state_74293[(8)]);
var inst_74198 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_74188,type,params);
var state_74293__$1 = state_74293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74293__$1,(24),inst_74198);
} else {
if((state_val_74294 === (31))){
var inst_74188 = (state_74293[(8)]);
var inst_74211 = (state_74293[(9)]);
var inst_74211__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_74188) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_74188));
var state_74293__$1 = (function (){var statearr_74307 = state_74293;
(statearr_74307[(9)] = inst_74211__$1);

return statearr_74307;
})();
if(cljs.core.truth_(inst_74211__$1)){
var statearr_74308_74392 = state_74293__$1;
(statearr_74308_74392[(1)] = (34));

} else {
var statearr_74309_74393 = state_74293__$1;
(statearr_74309_74393[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (32))){
var inst_74188 = (state_74293[(8)]);
var inst_74238 = inst_74188 === true;
var inst_74239 = inst_74188 === false;
var inst_74240 = (inst_74188 == null);
var inst_74241 = ((inst_74238) || (inst_74239) || (inst_74240));
var state_74293__$1 = state_74293;
if(cljs.core.truth_(inst_74241)){
var statearr_74310_74394 = state_74293__$1;
(statearr_74310_74394[(1)] = (43));

} else {
var statearr_74311_74395 = state_74293__$1;
(statearr_74311_74395[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (40))){
var inst_74221 = (state_74293[(10)]);
var state_74293__$1 = state_74293;
var statearr_74312_74396 = state_74293__$1;
(statearr_74312_74396[(2)] = inst_74221);

(statearr_74312_74396[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (33))){
var inst_74272 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
var statearr_74313_74397 = state_74293__$1;
(statearr_74313_74397[(2)] = inst_74272);

(statearr_74313_74397[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (13))){
var inst_74188 = (state_74293[(8)]);
var inst_74181 = (state_74293[(11)]);
var inst_74187 = cljs.core.seq(inst_74181);
var inst_74188__$1 = cljs.core.first(inst_74187);
var inst_74189 = cljs.core.next(inst_74187);
var state_74293__$1 = (function (){var statearr_74314 = state_74293;
(statearr_74314[(8)] = inst_74188__$1);

(statearr_74314[(12)] = inst_74189);

return statearr_74314;
})();
if(cljs.core.truth_(inst_74188__$1)){
var statearr_74315_74398 = state_74293__$1;
(statearr_74315_74398[(1)] = (15));

} else {
var statearr_74316_74399 = state_74293__$1;
(statearr_74316_74399[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (22))){
var inst_74188 = (state_74293[(8)]);
var inst_74203 = typeof inst_74188 === 'string';
var state_74293__$1 = state_74293;
if(cljs.core.truth_(inst_74203)){
var statearr_74317_74400 = state_74293__$1;
(statearr_74317_74400[(1)] = (25));

} else {
var statearr_74318_74401 = state_74293__$1;
(statearr_74318_74401[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (36))){
var inst_74236 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
var statearr_74319_74402 = state_74293__$1;
(statearr_74319_74402[(2)] = inst_74236);

(statearr_74319_74402[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (41))){
var inst_74188 = (state_74293[(8)]);
var inst_74224 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_74225 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74188)," used in function argument: ",inst_74224].join('');
var inst_74226 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74227 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_74228 = cljs.core.PersistentHashMap.fromArrays(inst_74226,inst_74227);
var inst_74229 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74225,inst_74228);
var inst_74230 = (function(){throw inst_74229})();
var state_74293__$1 = state_74293;
var statearr_74320_74403 = state_74293__$1;
(statearr_74320_74403[(2)] = inst_74230);

(statearr_74320_74403[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (43))){
var inst_74188 = (state_74293[(8)]);
var state_74293__$1 = state_74293;
var statearr_74321_74404 = state_74293__$1;
(statearr_74321_74404[(2)] = inst_74188);

(statearr_74321_74404[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (29))){
var inst_74188 = (state_74293[(8)]);
var inst_74209 = (inst_74188 instanceof cljs.core.Symbol);
var state_74293__$1 = state_74293;
if(cljs.core.truth_(inst_74209)){
var statearr_74322_74405 = state_74293__$1;
(statearr_74322_74405[(1)] = (31));

} else {
var statearr_74323_74406 = state_74293__$1;
(statearr_74323_74406[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (44))){
var inst_74188 = (state_74293[(8)]);
var inst_74244 = cljs.core.vector_QMARK_(inst_74188);
var state_74293__$1 = state_74293;
if(inst_74244){
var statearr_74324_74407 = state_74293__$1;
(statearr_74324_74407[(1)] = (46));

} else {
var statearr_74325_74408 = state_74293__$1;
(statearr_74325_74408[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (6))){
var inst_74155 = (state_74293[(7)]);
var inst_74151 = (state_74293[(13)]);
var inst_74150 = (state_74293[(14)]);
var inst_74149 = (state_74293[(2)]);
var inst_74150__$1 = fluree.db.util.async.throw_err(inst_74149);
var inst_74151__$1 = cljs.core.__destructure_map(inst_74150__$1);
var inst_74152 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74151__$1,cljs.core.cst$kw$f);
var inst_74153 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74151__$1,cljs.core.cst$kw$arity);
var inst_74154 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74151__$1,cljs.core.cst$kw$arglist);
var inst_74155__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74151__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_74293__$1 = (function (){var statearr_74326 = state_74293;
(statearr_74326[(7)] = inst_74155__$1);

(statearr_74326[(15)] = inst_74154);

(statearr_74326[(13)] = inst_74151__$1);

(statearr_74326[(16)] = inst_74153);

(statearr_74326[(14)] = inst_74150__$1);

(statearr_74326[(17)] = inst_74152);

return statearr_74326;
})();
if(cljs.core.truth_(inst_74155__$1)){
var statearr_74327_74409 = state_74293__$1;
(statearr_74327_74409[(1)] = (7));

} else {
var statearr_74328_74410 = state_74293__$1;
(statearr_74328_74410[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (28))){
var inst_74188 = (state_74293[(8)]);
var state_74293__$1 = state_74293;
var statearr_74329_74411 = state_74293__$1;
(statearr_74329_74411[(2)] = inst_74188);

(statearr_74329_74411[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (51))){
var state_74293__$1 = state_74293;
var statearr_74330_74412 = state_74293__$1;
(statearr_74330_74412[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (25))){
var inst_74188 = (state_74293[(8)]);
var state_74293__$1 = state_74293;
var statearr_74332_74413 = state_74293__$1;
(statearr_74332_74413[(2)] = inst_74188);

(statearr_74332_74413[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (34))){
var inst_74211 = (state_74293[(9)]);
var state_74293__$1 = state_74293;
var statearr_74333_74414 = state_74293__$1;
(statearr_74333_74414[(2)] = inst_74211);

(statearr_74333_74414[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (17))){
var inst_74194 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
if(cljs.core.truth_(inst_74194)){
var statearr_74334_74415 = state_74293__$1;
(statearr_74334_74415[(1)] = (18));

} else {
var statearr_74335_74416 = state_74293__$1;
(statearr_74335_74416[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (3))){
var inst_74291 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74293__$1,inst_74291);
} else {
if((state_val_74294 === (12))){
var inst_74145 = (state_74293[(18)]);
var inst_74169 = (state_74293[(2)]);
var inst_74177 = cljs.core.seq(inst_74145);
var inst_74178 = cljs.core.first(inst_74177);
var inst_74179 = cljs.core.next(inst_74177);
var inst_74180 = cljs.core.PersistentVector.EMPTY;
var inst_74181 = inst_74145;
var inst_74182 = inst_74180;
var state_74293__$1 = (function (){var statearr_74336 = state_74293;
(statearr_74336[(19)] = inst_74169);

(statearr_74336[(20)] = inst_74178);

(statearr_74336[(21)] = inst_74179);

(statearr_74336[(22)] = inst_74182);

(statearr_74336[(11)] = inst_74181);

return statearr_74336;
})();
var statearr_74337_74417 = state_74293__$1;
(statearr_74337_74417[(2)] = null);

(statearr_74337_74417[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (2))){
var inst_74145 = (state_74293[(18)]);
var inst_74144 = (state_74293[(23)]);
var _ = (function (){var statearr_74338 = state_74293;
(statearr_74338[(4)] = cljs.core.cons((5),(state_74293[(4)])));

return statearr_74338;
})();
var inst_74144__$1 = cljs.core.first(form);
var inst_74145__$1 = cljs.core.rest(form);
var inst_74146 = cljs.core.count(inst_74145__$1);
var inst_74147 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_74144__$1,type);
var state_74293__$1 = (function (){var statearr_74339 = state_74293;
(statearr_74339[(18)] = inst_74145__$1);

(statearr_74339[(23)] = inst_74144__$1);

(statearr_74339[(24)] = inst_74146);

return statearr_74339;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74293__$1,(6),inst_74147);
} else {
if((state_val_74294 === (23))){
var inst_74182 = (state_74293[(22)]);
var inst_74189 = (state_74293[(12)]);
var inst_74278 = (state_74293[(2)]);
var inst_74279 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_74182,inst_74278);
var inst_74181 = inst_74189;
var inst_74182__$1 = inst_74279;
var state_74293__$1 = (function (){var statearr_74340 = state_74293;
(statearr_74340[(22)] = inst_74182__$1);

(statearr_74340[(11)] = inst_74181);

return statearr_74340;
})();
var statearr_74341_74418 = state_74293__$1;
(statearr_74341_74418[(2)] = null);

(statearr_74341_74418[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (47))){
var inst_74188 = (state_74293[(8)]);
var inst_74251 = (inst_74188 == null);
var state_74293__$1 = state_74293;
if(cljs.core.truth_(inst_74251)){
var statearr_74342_74419 = state_74293__$1;
(statearr_74342_74419[(1)] = (50));

} else {
var statearr_74343_74420 = state_74293__$1;
(statearr_74343_74420[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (35))){
var inst_74188 = (state_74293[(8)]);
var inst_74155 = (state_74293[(7)]);
var inst_74154 = (state_74293[(15)]);
var inst_74211 = (state_74293[(9)]);
var inst_74145 = (state_74293[(18)]);
var inst_74151 = (state_74293[(13)]);
var inst_74169 = (state_74293[(19)]);
var inst_74153 = (state_74293[(16)]);
var inst_74178 = (state_74293[(20)]);
var inst_74179 = (state_74293[(21)]);
var inst_74182 = (state_74293[(22)]);
var inst_74181 = (state_74293[(11)]);
var inst_74144 = (state_74293[(23)]);
var inst_74189 = (state_74293[(12)]);
var inst_74150 = (state_74293[(14)]);
var inst_74152 = (state_74293[(17)]);
var inst_74146 = (state_74293[(24)]);
var inst_74218 = (state_74293[(25)]);
var inst_74214 = [inst_74188];
var inst_74215 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_74214);
var inst_74216 = (function (){var arity = inst_74153;
var args_n = inst_74146;
var first__74186 = inst_74188;
var fn_map = inst_74150;
var map__74143 = inst_74151;
var vec__74184 = inst_74181;
var args = inst_74145;
var r = inst_74189;
var _ = inst_74169;
var acc = inst_74182;
var seq__74185 = inst_74189;
var seq__74175 = inst_74179;
var first__74176 = inst_74178;
var arglist = inst_74154;
var fn_name = inst_74144;
var vec__74174 = inst_74145;
var G__74173 = inst_74181;
var _AMPERSAND_args_QMARK_ = inst_74155;
var or__4160__auto__ = inst_74211;
var arg = inst_74188;
var f = inst_74152;
return (function (p1__74134_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__74134_SHARP_);
});
})();
var inst_74217 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_74216,params);
var inst_74218__$1 = cljs.core.some(inst_74215,inst_74217);
var state_74293__$1 = (function (){var statearr_74344 = state_74293;
(statearr_74344[(25)] = inst_74218__$1);

return statearr_74344;
})();
if(cljs.core.truth_(inst_74218__$1)){
var statearr_74345_74421 = state_74293__$1;
(statearr_74345_74421[(1)] = (37));

} else {
var statearr_74346_74422 = state_74293__$1;
(statearr_74346_74422[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (19))){
var inst_74182 = (state_74293[(22)]);
var state_74293__$1 = state_74293;
var statearr_74347_74423 = state_74293__$1;
(statearr_74347_74423[(2)] = inst_74182);

(statearr_74347_74423[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (11))){
var state_74293__$1 = state_74293;
var statearr_74349_74424 = state_74293__$1;
(statearr_74349_74424[(2)] = null);

(statearr_74349_74424[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (9))){
var inst_74160 = (state_74293[(2)]);
var inst_74161 = cljs.core.not(inst_74160);
var state_74293__$1 = state_74293;
if(inst_74161){
var statearr_74350_74425 = state_74293__$1;
(statearr_74350_74425[(1)] = (10));

} else {
var statearr_74351_74426 = state_74293__$1;
(statearr_74351_74426[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (5))){
var _ = (function (){var statearr_74352 = state_74293;
(statearr_74352[(4)] = cljs.core.rest((state_74293[(4)])));

return statearr_74352;
})();
var state_74293__$1 = state_74293;
var ex74348 = (state_74293__$1[(2)]);
var statearr_74353_74427 = state_74293__$1;
(statearr_74353_74427[(5)] = ex74348);


if((ex74348 instanceof Error)){
var statearr_74354_74428 = state_74293__$1;
(statearr_74354_74428[(1)] = (4));

(statearr_74354_74428[(5)] = null);

} else {
throw ex74348;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (14))){
var inst_74152 = (state_74293[(17)]);
var inst_74285 = (state_74293[(2)]);
var inst_74286 = cljs.core.cst$sym$_QMARK_ctx;
var inst_74287 = cljs.core.cons(inst_74286,inst_74285);
var inst_74288 = cljs.core.cons(inst_74152,inst_74287);
var _ = (function (){var statearr_74355 = state_74293;
(statearr_74355[(4)] = cljs.core.rest((state_74293[(4)])));

return statearr_74355;
})();
var state_74293__$1 = state_74293;
var statearr_74356_74429 = state_74293__$1;
(statearr_74356_74429[(2)] = inst_74288);

(statearr_74356_74429[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (45))){
var inst_74270 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
var statearr_74357_74430 = state_74293__$1;
(statearr_74357_74430[(2)] = inst_74270);

(statearr_74357_74430[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (53))){
var inst_74188 = (state_74293[(8)]);
var inst_74255 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74188], 0));
var inst_74256 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_74188) : type.call(null,inst_74188));
var inst_74257 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_74258 = ["Illegal element (",inst_74255,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74256),") in function argument: ",inst_74257,"."].join('');
var inst_74259 = cljs.core.PersistentHashMap.EMPTY;
var inst_74260 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74258,inst_74259);
var inst_74261 = (function(){throw inst_74260})();
var state_74293__$1 = state_74293;
var statearr_74358_74431 = state_74293__$1;
(statearr_74358_74431[(2)] = inst_74261);

(statearr_74358_74431[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (26))){
var inst_74188 = (state_74293[(8)]);
var inst_74206 = typeof inst_74188 === 'number';
var state_74293__$1 = state_74293;
if(cljs.core.truth_(inst_74206)){
var statearr_74359_74432 = state_74293__$1;
(statearr_74359_74432[(1)] = (28));

} else {
var statearr_74360_74433 = state_74293__$1;
(statearr_74360_74433[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (16))){
var inst_74188 = (state_74293[(8)]);
var inst_74192 = inst_74188 === false;
var state_74293__$1 = state_74293;
var statearr_74361_74434 = state_74293__$1;
(statearr_74361_74434[(2)] = inst_74192);

(statearr_74361_74434[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (38))){
var inst_74221 = (state_74293[(10)]);
var inst_74221__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_74293__$1 = (function (){var statearr_74362 = state_74293;
(statearr_74362[(10)] = inst_74221__$1);

return statearr_74362;
})();
if(inst_74221__$1){
var statearr_74363_74435 = state_74293__$1;
(statearr_74363_74435[(1)] = (40));

} else {
var statearr_74364_74436 = state_74293__$1;
(statearr_74364_74436[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (30))){
var inst_74274 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
var statearr_74365_74437 = state_74293__$1;
(statearr_74365_74437[(2)] = inst_74274);

(statearr_74365_74437[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (10))){
var inst_74153 = (state_74293[(16)]);
var inst_74144 = (state_74293[(23)]);
var inst_74146 = (state_74293[(24)]);
var inst_74163 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74144),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74153),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74146),"."].join('');
var inst_74164 = cljs.core.PersistentHashMap.EMPTY;
var inst_74165 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74163,inst_74164);
var inst_74166 = (function(){throw inst_74165})();
var state_74293__$1 = state_74293;
var statearr_74366_74438 = state_74293__$1;
(statearr_74366_74438[(2)] = inst_74166);

(statearr_74366_74438[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (18))){
var inst_74188 = (state_74293[(8)]);
var inst_74196 = cljs.core.list_QMARK_(inst_74188);
var state_74293__$1 = state_74293;
if(inst_74196){
var statearr_74367_74439 = state_74293__$1;
(statearr_74367_74439[(1)] = (21));

} else {
var statearr_74368_74440 = state_74293__$1;
(statearr_74368_74440[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (52))){
var inst_74266 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
var statearr_74369_74441 = state_74293__$1;
(statearr_74369_74441[(2)] = inst_74266);

(statearr_74369_74441[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (42))){
var inst_74232 = (state_74293[(2)]);
var state_74293__$1 = state_74293;
var statearr_74370_74442 = state_74293__$1;
(statearr_74370_74442[(2)] = inst_74232);

(statearr_74370_74442[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (37))){
var inst_74218 = (state_74293[(25)]);
var state_74293__$1 = state_74293;
var statearr_74371_74443 = state_74293__$1;
(statearr_74371_74443[(2)] = inst_74218);

(statearr_74371_74443[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (8))){
var inst_74153 = (state_74293[(16)]);
var inst_74146 = (state_74293[(24)]);
var inst_74158 = (inst_74153.cljs$core$IFn$_invoke$arity$1 ? inst_74153.cljs$core$IFn$_invoke$arity$1(inst_74146) : inst_74153.call(null,inst_74146));
var state_74293__$1 = state_74293;
var statearr_74372_74444 = state_74293__$1;
(statearr_74372_74444[(2)] = inst_74158);

(statearr_74372_74444[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74294 === (49))){
var inst_74248 = (state_74293[(2)]);
var inst_74249 = fluree.db.util.async.throw_err(inst_74248);
var state_74293__$1 = state_74293;
var statearr_74373_74445 = state_74293__$1;
(statearr_74373_74445[(2)] = inst_74249);

(statearr_74373_74445[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__13883__auto____0 = (function (){
var statearr_74374 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74374[(0)] = fluree$db$dbfunctions$core$state_machine__13883__auto__);

(statearr_74374[(1)] = (1));

return statearr_74374;
});
var fluree$db$dbfunctions$core$state_machine__13883__auto____1 = (function (state_74293){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74293);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74375){var ex__13886__auto__ = e74375;
var statearr_74376_74446 = state_74293;
(statearr_74376_74446[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74293[(4)]))){
var statearr_74377_74447 = state_74293;
(statearr_74377_74447[(1)] = cljs.core.first((state_74293[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74448 = state_74293;
state_74293 = G__74448;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__13883__auto__ = function(state_74293){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__13883__auto____1.call(this,state_74293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__13883__auto____0;
fluree$db$dbfunctions$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__13883__auto____1;
return fluree$db$dbfunctions$core$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_74378 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74378[(6)] = c__13957__auto__);

return statearr_74378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__74450 = arguments.length;
switch (G__74450) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_74529){
var state_val_74530 = (state_74529[(1)]);
if((state_val_74530 === (7))){
var state_74529__$1 = state_74529;
var statearr_74531_74574 = state_74529__$1;
(statearr_74531_74574[(2)] = null);

(statearr_74531_74574[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (20))){
var inst_74504 = (state_74529[(7)]);
var state_74529__$1 = state_74529;
var statearr_74532_74575 = state_74529__$1;
(statearr_74532_74575[(2)] = inst_74504);

(statearr_74532_74575[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (1))){
var state_74529__$1 = state_74529;
var statearr_74533_74576 = state_74529__$1;
(statearr_74533_74576[(2)] = null);

(statearr_74533_74576[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (4))){
var inst_74451 = (state_74529[(2)]);
var state_74529__$1 = state_74529;
var statearr_74534_74577 = state_74529__$1;
(statearr_74534_74577[(2)] = inst_74451);

(statearr_74534_74577[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (15))){
var inst_74486 = (state_74529[(2)]);
var inst_74487 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_74488 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_74487,type,params);
var state_74529__$1 = (function (){var statearr_74535 = state_74529;
(statearr_74535[(8)] = inst_74486);

return statearr_74535;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74529__$1,(16),inst_74488);
} else {
if((state_val_74530 === (21))){
var inst_74504 = (state_74529[(7)]);
var inst_74513 = cljs.core.eval(inst_74504);
var state_74529__$1 = state_74529;
var statearr_74536_74578 = state_74529__$1;
(statearr_74536_74578[(2)] = inst_74513);

(statearr_74536_74578[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (13))){
var state_74529__$1 = state_74529;
var statearr_74537_74579 = state_74529__$1;
(statearr_74537_74579[(2)] = null);

(statearr_74537_74579[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (22))){
var inst_74515 = (state_74529[(2)]);
var inst_74516 = [cljs.core.cst$kw$fnstr];
var inst_74517 = [fn_str];
var inst_74518 = cljs.core.PersistentHashMap.fromArrays(inst_74516,inst_74517);
var inst_74519 = cljs.core.with_meta(inst_74515,inst_74518);
var _ = (function (){var statearr_74538 = state_74529;
(statearr_74538[(4)] = cljs.core.rest((state_74529[(4)])));

return statearr_74538;
})();
var state_74529__$1 = state_74529;
var statearr_74539_74580 = state_74529__$1;
(statearr_74539_74580[(2)] = inst_74519);

(statearr_74539_74580[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (6))){
var inst_74461 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_74462 = fluree.db.dbfunctions.core.true_or_false = inst_74461;
var state_74529__$1 = state_74529;
var statearr_74540_74581 = state_74529__$1;
(statearr_74540_74581[(2)] = inst_74462);

(statearr_74540_74581[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (17))){
var inst_74507 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_74529__$1 = state_74529;
var statearr_74542_74582 = state_74529__$1;
(statearr_74542_74582[(2)] = inst_74507);

(statearr_74542_74582[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (3))){
var inst_74527 = (state_74529[(2)]);
var state_74529__$1 = state_74529;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74529__$1,inst_74527);
} else {
if((state_val_74530 === (12))){
var _ = (function (){var statearr_74543 = state_74529;
(statearr_74543[(4)] = cljs.core.rest((state_74529[(4)])));

return statearr_74543;
})();
var state_74529__$1 = state_74529;
var ex74541 = (state_74529__$1[(2)]);
var statearr_74544_74583 = state_74529__$1;
(statearr_74544_74583[(5)] = ex74541);


var statearr_74545_74584 = state_74529__$1;
(statearr_74545_74584[(1)] = (11));

(statearr_74545_74584[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (2))){
var _ = (function (){var statearr_74546 = state_74529;
(statearr_74546[(4)] = cljs.core.cons((5),(state_74529[(4)])));

return statearr_74546;
})();
var inst_74457 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var inst_74458 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var inst_74459 = ((inst_74457) || (inst_74458));
var state_74529__$1 = state_74529;
if(cljs.core.truth_(inst_74459)){
var statearr_74547_74585 = state_74529__$1;
(statearr_74547_74585[(1)] = (6));

} else {
var statearr_74548_74586 = state_74529__$1;
(statearr_74548_74586[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (19))){
var inst_74510 = (state_74529[(2)]);
var state_74529__$1 = state_74529;
if(cljs.core.truth_(inst_74510)){
var statearr_74549_74587 = state_74529__$1;
(statearr_74549_74587[(1)] = (20));

} else {
var statearr_74550_74588 = state_74529__$1;
(statearr_74550_74588[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (11))){
var inst_74464 = (state_74529[(2)]);
var inst_74465 = (function(){throw inst_74464})();
var inst_74466 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_74467 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74468 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_74469 = cljs.core.PersistentHashMap.fromArrays(inst_74467,inst_74468);
var inst_74470 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74466,inst_74469);
var inst_74471 = (function(){throw inst_74470})();
var state_74529__$1 = (function (){var statearr_74552 = state_74529;
(statearr_74552[(9)] = inst_74465);

return statearr_74552;
})();
var statearr_74553_74589 = state_74529__$1;
(statearr_74553_74589[(2)] = inst_74471);

(statearr_74553_74589[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (9))){
var _ = (function (){var statearr_74554 = state_74529;
(statearr_74554[(4)] = cljs.core.cons((12),(state_74529[(4)])));

return statearr_74554;
})();
var inst_74477 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_74529__$1 = state_74529;
if(cljs.core.truth_(inst_74477)){
var statearr_74555_74590 = state_74529__$1;
(statearr_74555_74590[(1)] = (13));

} else {
var statearr_74556_74591 = state_74529__$1;
(statearr_74556_74591[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (5))){
var _ = (function (){var statearr_74557 = state_74529;
(statearr_74557[(4)] = cljs.core.rest((state_74529[(4)])));

return statearr_74557;
})();
var state_74529__$1 = state_74529;
var ex74551 = (state_74529__$1[(2)]);
var statearr_74558_74592 = state_74529__$1;
(statearr_74558_74592[(5)] = ex74551);


if((ex74551 instanceof Error)){
var statearr_74559_74593 = state_74529__$1;
(statearr_74559_74593[(1)] = (4));

(statearr_74559_74593[(5)] = null);

} else {
throw ex74551;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (14))){
var inst_74480 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74481 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_74482 = cljs.core.PersistentHashMap.fromArrays(inst_74480,inst_74481);
var inst_74483 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_74482);
var inst_74484 = (function(){throw inst_74483})();
var state_74529__$1 = state_74529;
var statearr_74560_74594 = state_74529__$1;
(statearr_74560_74594[(2)] = inst_74484);

(statearr_74560_74594[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (16))){
var inst_74505 = (state_74529[(10)]);
var inst_74490 = (state_74529[(2)]);
var inst_74491 = fluree.db.util.async.throw_err(inst_74490);
var inst_74492 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_74493 = (new cljs.core.List(null,inst_74492,null,(1),null));
var inst_74494 = cljs.core.cst$sym$_QMARK_ctx;
var inst_74495 = (new cljs.core.List(null,inst_74494,null,(1),null));
var inst_74496 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_74495);
var inst_74497 = cljs.core.seq(inst_74496);
var inst_74498 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_74497);
var inst_74499 = cljs.core.vec(inst_74498);
var inst_74500 = (new cljs.core.List(null,inst_74499,null,(1),null));
var inst_74501 = (new cljs.core.List(null,inst_74491,null,(1),null));
var inst_74502 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_74493,inst_74500,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74501], 0));
var inst_74503 = cljs.core.seq(inst_74502);
var inst_74504 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_74503);
var inst_74505__$1 = params;
var state_74529__$1 = (function (){var statearr_74561 = state_74529;
(statearr_74561[(7)] = inst_74504);

(statearr_74561[(10)] = inst_74505__$1);

return statearr_74561;
})();
if(cljs.core.truth_(inst_74505__$1)){
var statearr_74562_74595 = state_74529__$1;
(statearr_74562_74595[(1)] = (17));

} else {
var statearr_74563_74596 = state_74529__$1;
(statearr_74563_74596[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (10))){
var inst_74522 = (state_74529[(2)]);
var state_74529__$1 = state_74529;
var statearr_74564_74597 = state_74529__$1;
(statearr_74564_74597[(2)] = inst_74522);

(statearr_74564_74597[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (18))){
var inst_74505 = (state_74529[(10)]);
var state_74529__$1 = state_74529;
var statearr_74565_74598 = state_74529__$1;
(statearr_74565_74598[(2)] = inst_74505);

(statearr_74565_74598[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74530 === (8))){
var inst_74524 = (state_74529[(2)]);
var _ = (function (){var statearr_74566 = state_74529;
(statearr_74566[(4)] = cljs.core.rest((state_74529[(4)])));

return statearr_74566;
})();
var state_74529__$1 = state_74529;
var statearr_74567_74599 = state_74529__$1;
(statearr_74567_74599[(2)] = inst_74524);

(statearr_74567_74599[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__13883__auto____0 = (function (){
var statearr_74568 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_74568[(0)] = fluree$db$dbfunctions$core$state_machine__13883__auto__);

(statearr_74568[(1)] = (1));

return statearr_74568;
});
var fluree$db$dbfunctions$core$state_machine__13883__auto____1 = (function (state_74529){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74529);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74569){var ex__13886__auto__ = e74569;
var statearr_74570_74600 = state_74529;
(statearr_74570_74600[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74529[(4)]))){
var statearr_74571_74601 = state_74529;
(statearr_74571_74601[(1)] = cljs.core.first((state_74529[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74602 = state_74529;
state_74529 = G__74602;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__13883__auto__ = function(state_74529){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__13883__auto____1.call(this,state_74529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__13883__auto____0;
fluree$db$dbfunctions$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__13883__auto____1;
return fluree$db$dbfunctions$core$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_74572 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74572[(6)] = c__13957__auto__);

return statearr_74572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_74630){
var state_val_74631 = (state_74630[(1)]);
if((state_val_74631 === (7))){
var inst_74617 = (state_74630[(7)]);
var state_74630__$1 = state_74630;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74630__$1,(10),inst_74617);
} else {
if((state_val_74631 === (1))){
var state_74630__$1 = state_74630;
var statearr_74632_74652 = state_74630__$1;
(statearr_74632_74652[(2)] = null);

(statearr_74632_74652[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74631 === (4))){
var inst_74603 = (state_74630[(2)]);
var state_74630__$1 = state_74630;
var statearr_74633_74653 = state_74630__$1;
(statearr_74633_74653[(2)] = inst_74603);

(statearr_74633_74653[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74631 === (6))){
var inst_74612 = (state_74630[(8)]);
var inst_74617 = (state_74630[(7)]);
var inst_74615 = (state_74630[(2)]);
var inst_74616 = fluree.db.util.async.throw_err(inst_74615);
var inst_74617__$1 = (inst_74616.cljs$core$IFn$_invoke$arity$1 ? inst_74616.cljs$core$IFn$_invoke$arity$1(inst_74612) : inst_74616.call(null,inst_74612));
var inst_74618 = fluree.db.util.async.channel_QMARK_(inst_74617__$1);
var state_74630__$1 = (function (){var statearr_74634 = state_74630;
(statearr_74634[(7)] = inst_74617__$1);

return statearr_74634;
})();
if(inst_74618){
var statearr_74635_74654 = state_74630__$1;
(statearr_74635_74654[(1)] = (7));

} else {
var statearr_74636_74655 = state_74630__$1;
(statearr_74636_74655[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74631 === (3))){
var inst_74628 = (state_74630[(2)]);
var state_74630__$1 = state_74630;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74630__$1,inst_74628);
} else {
if((state_val_74631 === (2))){
var _ = (function (){var statearr_74638 = state_74630;
(statearr_74638[(4)] = cljs.core.cons((5),(state_74630[(4)])));

return statearr_74638;
})();
var inst_74609 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_74610 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_74611 = [db,block_instant,s,p,auth_id,fuel];
var inst_74612 = cljs.core.PersistentHashMap.fromArrays(inst_74610,inst_74611);
var inst_74613 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_74609,"txn",null);
var state_74630__$1 = (function (){var statearr_74639 = state_74630;
(statearr_74639[(8)] = inst_74612);

return statearr_74639;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74630__$1,(6),inst_74613);
} else {
if((state_val_74631 === (9))){
var inst_74625 = (state_74630[(2)]);
var _ = (function (){var statearr_74640 = state_74630;
(statearr_74640[(4)] = cljs.core.rest((state_74630[(4)])));

return statearr_74640;
})();
var state_74630__$1 = state_74630;
var statearr_74641_74656 = state_74630__$1;
(statearr_74641_74656[(2)] = inst_74625);

(statearr_74641_74656[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74631 === (5))){
var _ = (function (){var statearr_74642 = state_74630;
(statearr_74642[(4)] = cljs.core.rest((state_74630[(4)])));

return statearr_74642;
})();
var state_74630__$1 = state_74630;
var ex74637 = (state_74630__$1[(2)]);
var statearr_74643_74657 = state_74630__$1;
(statearr_74643_74657[(5)] = ex74637);


if((ex74637 instanceof Error)){
var statearr_74644_74658 = state_74630__$1;
(statearr_74644_74658[(1)] = (4));

(statearr_74644_74658[(5)] = null);

} else {
throw ex74637;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74631 === (10))){
var inst_74621 = (state_74630[(2)]);
var inst_74622 = fluree.db.util.async.throw_err(inst_74621);
var state_74630__$1 = state_74630;
var statearr_74645_74659 = state_74630__$1;
(statearr_74645_74659[(2)] = inst_74622);

(statearr_74645_74659[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74631 === (8))){
var inst_74617 = (state_74630[(7)]);
var state_74630__$1 = state_74630;
var statearr_74646_74660 = state_74630__$1;
(statearr_74646_74660[(2)] = inst_74617);

(statearr_74646_74660[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto____0 = (function (){
var statearr_74647 = [null,null,null,null,null,null,null,null,null];
(statearr_74647[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto__);

(statearr_74647[(1)] = (1));

return statearr_74647;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto____1 = (function (state_74630){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74630);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74648){var ex__13886__auto__ = e74648;
var statearr_74649_74661 = state_74630;
(statearr_74649_74661[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74630[(4)]))){
var statearr_74650_74662 = state_74630;
(statearr_74650_74662[(1)] = cljs.core.first((state_74630[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74663 = state_74630;
state_74630 = G__74663;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto__ = function(state_74630){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto____1.call(this,state_74630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_74651 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74651[(6)] = c__13957__auto__);

return statearr_74651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
