// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44242 = arguments.length;
var i__4772__auto___44243 = (0);
while(true){
if((i__4772__auto___44243 < len__4771__auto___44242)){
args__4777__auto__.push((arguments[i__4772__auto___44243]));

var G__44244 = (i__4772__auto___44243 + (1));
i__4772__auto___44243 = G__44244;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((2) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq44239){
var G__44240 = cljs.core.first(seq44239);
var seq44239__$1 = cljs.core.next(seq44239);
var G__44241 = cljs.core.first(seq44239__$1);
var seq44239__$2 = cljs.core.next(seq44239__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44240,G__44241,seq44239__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e44245){var e = e44245;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e44246){var e = e44246;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e44247){var e = e44247;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e44248){var e = e44248;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e44249){var e = e44249;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44252 = arguments.length;
var i__4772__auto___44253 = (0);
while(true){
if((i__4772__auto___44253 < len__4771__auto___44252)){
args__4777__auto__.push((arguments[i__4772__auto___44253]));

var G__44254 = (i__4772__auto___44253 + (1));
i__4772__auto___44253 = G__44254;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e44251){var e = e44251;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq44250){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44250));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44257 = arguments.length;
var i__4772__auto___44258 = (0);
while(true){
if((i__4772__auto___44258 < len__4771__auto___44257)){
args__4777__auto__.push((arguments[i__4772__auto___44258]));

var G__44259 = (i__4772__auto___44258 + (1));
i__4772__auto___44258 = G__44259;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e44256){var e = e44256;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq44255){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44255));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e44260){var e = e44260;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44263 = arguments.length;
var i__4772__auto___44264 = (0);
while(true){
if((i__4772__auto___44264 < len__4771__auto___44263)){
args__4777__auto__.push((arguments[i__4772__auto___44264]));

var G__44265 = (i__4772__auto___44264 + (1));
i__4772__auto___44264 = G__44265;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e44262){var e = e44262;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq44261){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44261));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44268 = arguments.length;
var i__4772__auto___44269 = (0);
while(true){
if((i__4772__auto___44269 < len__4771__auto___44268)){
args__4777__auto__.push((arguments[i__4772__auto___44269]));

var G__44270 = (i__4772__auto___44269 + (1));
i__4772__auto___44269 = G__44270;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e44267){var e = e44267;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq44266){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44266));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e44271){var e = e44271;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e44272){var e = e44272;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44275 = arguments.length;
var i__4772__auto___44276 = (0);
while(true){
if((i__4772__auto___44276 < len__4771__auto___44275)){
args__4777__auto__.push((arguments[i__4772__auto___44276]));

var G__44277 = (i__4772__auto___44276 + (1));
i__4772__auto___44276 = G__44277;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e44274){var e = e44274;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq44273){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44273));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44280 = arguments.length;
var i__4772__auto___44281 = (0);
while(true){
if((i__4772__auto___44281 < len__4771__auto___44280)){
args__4777__auto__.push((arguments[i__4772__auto___44281]));

var G__44282 = (i__4772__auto___44281 + (1));
i__4772__auto___44281 = G__44282;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e44279){var e = e44279;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq44278){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44278));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44285 = arguments.length;
var i__4772__auto___44286 = (0);
while(true){
if((i__4772__auto___44286 < len__4771__auto___44285)){
args__4777__auto__.push((arguments[i__4772__auto___44286]));

var G__44287 = (i__4772__auto___44286 + (1));
i__4772__auto___44286 = G__44287;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e44284){var e = e44284;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq44283){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44283));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44290 = arguments.length;
var i__4772__auto___44291 = (0);
while(true){
if((i__4772__auto___44291 < len__4771__auto___44290)){
args__4777__auto__.push((arguments[i__4772__auto___44291]));

var G__44292 = (i__4772__auto___44291 + (1));
i__4772__auto___44291 = G__44292;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e44289){var e = e44289;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq44288){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44288));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44295 = arguments.length;
var i__4772__auto___44296 = (0);
while(true){
if((i__4772__auto___44296 < len__4771__auto___44295)){
args__4777__auto__.push((arguments[i__4772__auto___44296]));

var G__44297 = (i__4772__auto___44296 + (1));
i__4772__auto___44296 = G__44297;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e44294){var e = e44294;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq44293){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44293));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44300 = arguments.length;
var i__4772__auto___44301 = (0);
while(true){
if((i__4772__auto___44301 < len__4771__auto___44300)){
args__4777__auto__.push((arguments[i__4772__auto___44301]));

var G__44302 = (i__4772__auto___44301 + (1));
i__4772__auto___44301 = G__44302;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e44299){var e = e44299;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq44298){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44298));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44305 = arguments.length;
var i__4772__auto___44306 = (0);
while(true){
if((i__4772__auto___44306 < len__4771__auto___44305)){
args__4777__auto__.push((arguments[i__4772__auto___44306]));

var G__44307 = (i__4772__auto___44306 + (1));
i__4772__auto___44306 = G__44307;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e44304){var e = e44304;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq44303){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44303));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__44309 = arguments.length;
switch (G__44309) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44337){
var state_val_44338 = (state_44337[(1)]);
if((state_val_44338 === (7))){
var inst_44322 = (state_44337[(7)]);
var inst_44325 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44322,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_44337__$1 = state_44337;
var statearr_44339_44425 = state_44337__$1;
(statearr_44339_44425[(2)] = inst_44325);

(statearr_44339_44425[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44338 === (1))){
var state_44337__$1 = state_44337;
var statearr_44340_44426 = state_44337__$1;
(statearr_44340_44426[(2)] = null);

(statearr_44340_44426[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44338 === (4))){
var inst_44310 = (state_44337[(2)]);
var state_44337__$1 = state_44337;
var statearr_44341_44427 = state_44337__$1;
(statearr_44341_44427[(2)] = inst_44310);

(statearr_44341_44427[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44338 === (6))){
var inst_44322 = (state_44337[(7)]);
var inst_44322__$1 = (state_44337[(2)]);
var inst_44323 = fluree.db.util.core.exception_QMARK_(inst_44322__$1);
var state_44337__$1 = (function (){var statearr_44342 = state_44337;
(statearr_44342[(7)] = inst_44322__$1);

return statearr_44342;
})();
if(inst_44323){
var statearr_44343_44428 = state_44337__$1;
(statearr_44343_44428[(1)] = (7));

} else {
var statearr_44344_44429 = state_44337__$1;
(statearr_44344_44429[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44338 === (3))){
var inst_44335 = (state_44337[(2)]);
var state_44337__$1 = state_44337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44337__$1,inst_44335);
} else {
if((state_val_44338 === (2))){
var inst_44316 = (state_44337[(8)]);
var _ = (function (){var statearr_44346 = state_44337;
(statearr_44346[(4)] = cljs.core.cons((5),(state_44337[(4)])));

return statearr_44346;
})();
var inst_44316__$1 = cljs.core.volatile_BANG_((0));
var inst_44317 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_44318 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_44317,cljs.core.cst$kw$fuel,inst_44316__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_44319 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_44318);
var inst_44320 = fluree.db.query.fql.query(db,inst_44319);
var state_44337__$1 = (function (){var statearr_44347 = state_44337;
(statearr_44347[(8)] = inst_44316__$1);

return statearr_44347;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44337__$1,(6),inst_44320);
} else {
if((state_val_44338 === (9))){
var inst_44332 = (state_44337[(2)]);
var _ = (function (){var statearr_44348 = state_44337;
(statearr_44348[(4)] = cljs.core.rest((state_44337[(4)])));

return statearr_44348;
})();
var state_44337__$1 = state_44337;
var statearr_44349_44430 = state_44337__$1;
(statearr_44349_44430[(2)] = inst_44332);

(statearr_44349_44430[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44338 === (5))){
var _ = (function (){var statearr_44350 = state_44337;
(statearr_44350[(4)] = cljs.core.rest((state_44337[(4)])));

return statearr_44350;
})();
var state_44337__$1 = state_44337;
var ex44345 = (state_44337__$1[(2)]);
var statearr_44351_44431 = state_44337__$1;
(statearr_44351_44431[(5)] = ex44345);


if((ex44345 instanceof Error)){
var statearr_44352_44432 = state_44337__$1;
(statearr_44352_44432[(1)] = (4));

(statearr_44352_44432[(5)] = null);

} else {
throw ex44345;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44338 === (8))){
var inst_44316 = (state_44337[(8)]);
var inst_44322 = (state_44337[(7)]);
var inst_44327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44328 = cljs.core.deref(inst_44316);
var inst_44329 = [inst_44322,inst_44328];
var inst_44330 = (new cljs.core.PersistentVector(null,2,(5),inst_44327,inst_44329,null));
var state_44337__$1 = state_44337;
var statearr_44353_44433 = state_44337__$1;
(statearr_44353_44433[(2)] = inst_44330);

(statearr_44353_44433[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__13883__auto____0 = (function (){
var statearr_44354 = [null,null,null,null,null,null,null,null,null];
(statearr_44354[(0)] = fluree$db$dbfunctions$internal$state_machine__13883__auto__);

(statearr_44354[(1)] = (1));

return statearr_44354;
});
var fluree$db$dbfunctions$internal$state_machine__13883__auto____1 = (function (state_44337){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44337);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44355){var ex__13886__auto__ = e44355;
var statearr_44356_44434 = state_44337;
(statearr_44356_44434[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44337[(4)]))){
var statearr_44357_44435 = state_44337;
(statearr_44357_44435[(1)] = cljs.core.first((state_44337[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__44436 = state_44337;
state_44337 = G__44436;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__13883__auto__ = function(state_44337){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____1.call(this,state_44337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44358 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44358[(6)] = c__13957__auto__);

return statearr_44358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44403){
var state_val_44404 = (state_44403[(1)]);
if((state_val_44404 === (7))){
var inst_44389 = (state_44403[(2)]);
var inst_44390 = fluree.db.query.fql.query(db,inst_44389);
var state_44403__$1 = state_44403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44403__$1,(8),inst_44390);
} else {
if((state_val_44404 === (1))){
var inst_44359 = typeof select === 'string';
var state_44403__$1 = state_44403;
if(cljs.core.truth_(inst_44359)){
var statearr_44405_44437 = state_44403__$1;
(statearr_44405_44437[(1)] = (2));

} else {
var statearr_44406_44438 = state_44403__$1;
(statearr_44406_44438[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44404 === (4))){
var inst_44365 = (state_44403[(7)]);
var inst_44372 = (state_44403[(8)]);
var inst_44364 = (state_44403[(2)]);
var inst_44365__$1 = cljs.core.volatile_BANG_((0));
var inst_44366 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_44367 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_44368 = [inst_44365__$1,(100000)];
var inst_44369 = cljs.core.PersistentHashMap.fromArrays(inst_44367,inst_44368);
var inst_44370 = [inst_44364,from,where,block,limit,inst_44369];
var inst_44371 = cljs.core.PersistentHashMap.fromArrays(inst_44366,inst_44370);
var inst_44372__$1 = fluree.db.util.core.without_nils(inst_44371);
var inst_44373 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44372__$1);
var inst_44374 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44372__$1);
var inst_44375 = cljs.core.first(inst_44374);
var inst_44376 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44375], 0));
var inst_44377 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_44376);
var inst_44378 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44372__$1);
var inst_44379 = cljs.core.last(inst_44378);
var inst_44380 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44379], 0));
var inst_44381 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_44380);
var inst_44382 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44373,inst_44377,inst_44381], 0));
var state_44403__$1 = (function (){var statearr_44407 = state_44403;
(statearr_44407[(7)] = inst_44365__$1);

(statearr_44407[(8)] = inst_44372__$1);

return statearr_44407;
})();
if(cljs.core.truth_(inst_44382)){
var statearr_44408_44439 = state_44403__$1;
(statearr_44408_44439[(1)] = (5));

} else {
var statearr_44409_44440 = state_44403__$1;
(statearr_44409_44440[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44404 === (6))){
var inst_44372 = (state_44403[(8)]);
var state_44403__$1 = state_44403;
var statearr_44410_44441 = state_44403__$1;
(statearr_44410_44441[(2)] = inst_44372);

(statearr_44410_44441[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44404 === (3))){
var state_44403__$1 = state_44403;
var statearr_44411_44442 = state_44403__$1;
(statearr_44411_44442[(2)] = select);

(statearr_44411_44442[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44404 === (2))){
var inst_44361 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_44403__$1 = state_44403;
var statearr_44412_44443 = state_44403__$1;
(statearr_44412_44443[(2)] = inst_44361);

(statearr_44412_44443[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44404 === (11))){
var inst_44401 = (state_44403[(2)]);
var state_44403__$1 = state_44403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44403__$1,inst_44401);
} else {
if((state_val_44404 === (9))){
var inst_44392 = (state_44403[(9)]);
var state_44403__$1 = state_44403;
var statearr_44413_44444 = state_44403__$1;
(statearr_44413_44444[(2)] = inst_44392);

(statearr_44413_44444[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44404 === (5))){
var inst_44372 = (state_44403[(8)]);
var inst_44384 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44372);
var inst_44385 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_44384);
var inst_44386 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_44372,cljs.core.cst$kw$where,inst_44385);
var state_44403__$1 = state_44403;
var statearr_44414_44445 = state_44403__$1;
(statearr_44414_44445[(2)] = inst_44386);

(statearr_44414_44445[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44404 === (10))){
var inst_44392 = (state_44403[(9)]);
var inst_44365 = (state_44403[(7)]);
var inst_44396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44397 = cljs.core.deref(inst_44365);
var inst_44398 = [inst_44392,inst_44397];
var inst_44399 = (new cljs.core.PersistentVector(null,2,(5),inst_44396,inst_44398,null));
var state_44403__$1 = state_44403;
var statearr_44415_44446 = state_44403__$1;
(statearr_44415_44446[(2)] = inst_44399);

(statearr_44415_44446[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44404 === (8))){
var inst_44392 = (state_44403[(9)]);
var inst_44392__$1 = (state_44403[(2)]);
var inst_44393 = fluree.db.util.core.exception_QMARK_(inst_44392__$1);
var state_44403__$1 = (function (){var statearr_44416 = state_44403;
(statearr_44416[(9)] = inst_44392__$1);

return statearr_44416;
})();
if(inst_44393){
var statearr_44417_44447 = state_44403__$1;
(statearr_44417_44447[(1)] = (9));

} else {
var statearr_44418_44448 = state_44403__$1;
(statearr_44418_44448[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__13883__auto____0 = (function (){
var statearr_44419 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44419[(0)] = fluree$db$dbfunctions$internal$state_machine__13883__auto__);

(statearr_44419[(1)] = (1));

return statearr_44419;
});
var fluree$db$dbfunctions$internal$state_machine__13883__auto____1 = (function (state_44403){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44403);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44420){var ex__13886__auto__ = e44420;
var statearr_44421_44449 = state_44403;
(statearr_44421_44449[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44403[(4)]))){
var statearr_44422_44450 = state_44403;
(statearr_44422_44450[(1)] = cljs.core.first((state_44403[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__44451 = state_44403;
state_44403 = G__44451;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__13883__auto__ = function(state_44403){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____1.call(this,state_44403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44423 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44423[(6)] = c__13957__auto__);

return statearr_44423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__44455 = path;
var vec__44456 = G__44455;
var seq__44457 = cljs.core.seq(vec__44456);
var first__44458 = cljs.core.first(seq__44457);
var seq__44457__$1 = cljs.core.next(seq__44457);
var var$ = first__44458;
var r = seq__44457__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__44455__$1 = G__44455;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__44462 = G__44455__$1;
var seq__44463 = cljs.core.seq(vec__44462);
var first__44464 = cljs.core.first(seq__44463);
var seq__44463__$1 = cljs.core.next(seq__44463);
var var$__$1 = first__44464;
var r__$1 = seq__44463__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__44465 = r__$1;
var G__44466 = n__$2;
var G__44467 = next_clauses;
G__44455__$1 = G__44465;
n__$1 = G__44466;
where_clauses__$1 = G__44467;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__44468 = r__$1;
var G__44469 = next_n;
var G__44470 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__44455__$1 = G__44468;
n__$1 = G__44469;
where_clauses__$1 = G__44470;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44507){
var state_val_44508 = (state_44507[(1)]);
if((state_val_44508 === (7))){
var inst_44480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44481 = [path];
var inst_44482 = (new cljs.core.PersistentVector(null,1,(5),inst_44480,inst_44481,null));
var state_44507__$1 = state_44507;
var statearr_44509_44537 = state_44507__$1;
(statearr_44509_44537[(2)] = inst_44482);

(statearr_44509_44537[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44508 === (1))){
var state_44507__$1 = state_44507;
var statearr_44510_44538 = state_44507__$1;
(statearr_44510_44538[(2)] = null);

(statearr_44510_44538[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44508 === (4))){
var inst_44471 = (state_44507[(2)]);
var state_44507__$1 = state_44507;
var statearr_44511_44539 = state_44507__$1;
(statearr_44511_44539[(2)] = inst_44471);

(statearr_44511_44539[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44508 === (13))){
var inst_44498 = (state_44507[(2)]);
var inst_44499 = fluree.db.util.async.throw_err(inst_44498);
var _ = (function (){var statearr_44512 = state_44507;
(statearr_44512[(4)] = cljs.core.rest((state_44507[(4)])));

return statearr_44512;
})();
var state_44507__$1 = state_44507;
var statearr_44513_44540 = state_44507__$1;
(statearr_44513_44540[(2)] = inst_44499);

(statearr_44513_44540[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44508 === (6))){
var state_44507__$1 = state_44507;
var statearr_44515_44541 = state_44507__$1;
(statearr_44515_44541[(2)] = path);

(statearr_44515_44541[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44508 === (3))){
var inst_44505 = (state_44507[(2)]);
var state_44507__$1 = state_44507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44507__$1,inst_44505);
} else {
if((state_val_44508 === (12))){
var _ = (function (){var statearr_44516 = state_44507;
(statearr_44516[(4)] = cljs.core.rest((state_44507[(4)])));

return statearr_44516;
})();
var state_44507__$1 = state_44507;
var ex44514 = (state_44507__$1[(2)]);
var statearr_44517_44542 = state_44507__$1;
(statearr_44517_44542[(5)] = ex44514);


var statearr_44518_44543 = state_44507__$1;
(statearr_44518_44543[(1)] = (11));

(statearr_44518_44543[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44508 === (2))){
var _ = (function (){var statearr_44519 = state_44507;
(statearr_44519[(4)] = cljs.core.cons((5),(state_44507[(4)])));

return statearr_44519;
})();
var inst_44477 = cljs.core.vector_QMARK_(path);
var state_44507__$1 = state_44507;
if(inst_44477){
var statearr_44520_44544 = state_44507__$1;
(statearr_44520_44544[(1)] = (6));

} else {
var statearr_44521_44545 = state_44507__$1;
(statearr_44521_44545[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44508 === (11))){
var inst_44484 = (state_44507[(7)]);
var inst_44489 = (state_44507[(2)]);
var inst_44490 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44489,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_44484,endSubject], 0));
var state_44507__$1 = state_44507;
var statearr_44523_44546 = state_44507__$1;
(statearr_44523_44546[(2)] = inst_44490);

(statearr_44523_44546[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44508 === (9))){
var inst_44488 = (state_44507[(8)]);
var _ = (function (){var statearr_44524 = state_44507;
(statearr_44524[(4)] = cljs.core.cons((12),(state_44507[(4)])));

return statearr_44524;
})();
var inst_44496 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_44488);
var state_44507__$1 = state_44507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44507__$1,(13),inst_44496);
} else {
if((state_val_44508 === (5))){
var _ = (function (){var statearr_44525 = state_44507;
(statearr_44525[(4)] = cljs.core.rest((state_44507[(4)])));

return statearr_44525;
})();
var state_44507__$1 = state_44507;
var ex44522 = (state_44507__$1[(2)]);
var statearr_44526_44547 = state_44507__$1;
(statearr_44526_44547[(5)] = ex44522);


if((ex44522 instanceof Error)){
var statearr_44527_44548 = state_44507__$1;
(statearr_44527_44548[(1)] = (4));

(statearr_44527_44548[(5)] = null);

} else {
throw ex44522;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44508 === (10))){
var inst_44502 = (state_44507[(2)]);
var _ = (function (){var statearr_44528 = state_44507;
(statearr_44528[(4)] = cljs.core.rest((state_44507[(4)])));

return statearr_44528;
})();
var state_44507__$1 = state_44507;
var statearr_44529_44549 = state_44507__$1;
(statearr_44529_44549[(2)] = inst_44502);

(statearr_44529_44549[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44508 === (8))){
var inst_44484 = (state_44507[(7)]);
var inst_44484__$1 = (state_44507[(2)]);
var inst_44485 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_44484__$1,endSubject);
var inst_44486 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_44487 = ["?var1",inst_44485];
var inst_44488 = cljs.core.PersistentHashMap.fromArrays(inst_44486,inst_44487);
var state_44507__$1 = (function (){var statearr_44530 = state_44507;
(statearr_44530[(7)] = inst_44484__$1);

(statearr_44530[(8)] = inst_44488);

return statearr_44530;
})();
var statearr_44531_44550 = state_44507__$1;
(statearr_44531_44550[(2)] = null);

(statearr_44531_44550[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_44532 = [null,null,null,null,null,null,null,null,null];
(statearr_44532[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto__);

(statearr_44532[(1)] = (1));

return statearr_44532;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto____1 = (function (state_44507){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44507);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44533){var ex__13886__auto__ = e44533;
var statearr_44534_44551 = state_44507;
(statearr_44534_44551[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44507[(4)]))){
var statearr_44535_44552 = state_44507;
(statearr_44535_44552[(1)] = cljs.core.first((state_44507[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__44553 = state_44507;
state_44507 = G__44553;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto__ = function(state_44507){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto____1.call(this,state_44507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44536 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44536[(6)] = c__13957__auto__);

return statearr_44536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e44554){var e = e44554;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e44555){var e = e44555;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e44556){var e = e44556;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e44557){var e = e44557;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44560 = arguments.length;
var i__4772__auto___44561 = (0);
while(true){
if((i__4772__auto___44561 < len__4771__auto___44560)){
args__4777__auto__.push((arguments[i__4772__auto___44561]));

var G__44562 = (i__4772__auto___44561 + (1));
i__4772__auto___44561 = G__44562;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e44559){var e = e44559;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq44558){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44558));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44565 = arguments.length;
var i__4772__auto___44566 = (0);
while(true){
if((i__4772__auto___44566 < len__4771__auto___44565)){
args__4777__auto__.push((arguments[i__4772__auto___44566]));

var G__44567 = (i__4772__auto___44566 + (1));
i__4772__auto___44566 = G__44567;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e44564){var e = e44564;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq44563){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44563));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44570 = arguments.length;
var i__4772__auto___44571 = (0);
while(true){
if((i__4772__auto___44571 < len__4771__auto___44570)){
args__4777__auto__.push((arguments[i__4772__auto___44571]));

var G__44572 = (i__4772__auto___44571 + (1));
i__4772__auto___44571 = G__44572;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4160__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e44569){var e = e44569;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq44568){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44568));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44575 = arguments.length;
var i__4772__auto___44576 = (0);
while(true){
if((i__4772__auto___44576 < len__4771__auto___44575)){
args__4777__auto__.push((arguments[i__4772__auto___44576]));

var G__44577 = (i__4772__auto___44576 + (1));
i__4772__auto___44576 = G__44577;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e44574){var e = e44574;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq44573){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44573));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e44578){var e = e44578;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e44579){var e = e44579;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e44580){var e = e44580;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e44581){var e = e44581;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e44582){var e = e44582;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__44588 = path;
var vec__44589 = G__44588;
var seq__44590 = cljs.core.seq(vec__44589);
var first__44591 = cljs.core.first(seq__44590);
var seq__44590__$1 = cljs.core.next(seq__44590);
var pred = first__44591;
var r = seq__44590__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__44588__$1 = G__44588;
var subjects__$1 = subjects;
while(true){
var vec__44595 = G__44588__$1;
var seq__44596 = cljs.core.seq(vec__44595);
var first__44597 = cljs.core.first(seq__44596);
var seq__44596__$1 = cljs.core.next(seq__44596);
var pred__$1 = first__44597;
var r__$1 = seq__44596__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__44588__$1,subjects__$1,vec__44595,seq__44596,first__44597,seq__44596__$1,pred__$1,r__$1,subjects__$2,G__44588,vec__44589,seq__44590,first__44591,seq__44590__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__44588__$1,subjects__$1,vec__44595,seq__44596,first__44597,seq__44596__$1,pred__$1,r__$1,subjects__$2,G__44588,vec__44589,seq__44590,first__44591,seq__44590__$1,pred,r,subjects){
return (function (p1__44583_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__44583_SHARP_,pred__$1);
});})(G__44588__$1,subjects__$1,vec__44595,seq__44596,first__44597,seq__44596__$1,pred__$1,r__$1,subjects__$2,G__44588,vec__44589,seq__44590,first__44591,seq__44590__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__44588__$1,subjects__$1,vec__44595,seq__44596,first__44597,seq__44596__$1,pred__$1,r__$1,subjects__$2,G__44588,vec__44589,seq__44590,first__44591,seq__44590__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4149__auto__ = r__$1;
if(and__4149__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4149__auto__;
}
})())){
var G__44598 = r__$1;
var G__44599 = next_subjects;
G__44588__$1 = G__44598;
subjects__$1 = G__44599;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e44584){var e = e44584;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e44600){var e = e44600;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e44601){var e = e44601;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44604 = arguments.length;
var i__4772__auto___44605 = (0);
while(true){
if((i__4772__auto___44605 < len__4771__auto___44604)){
args__4777__auto__.push((arguments[i__4772__auto___44605]));

var G__44606 = (i__4772__auto___44605 + (1));
i__4772__auto___44605 = G__44606;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e44603){var e = e44603;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq44602){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44602));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e44607){var e = e44607;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___44610 = arguments.length;
var i__4772__auto___44611 = (0);
while(true){
if((i__4772__auto___44611 < len__4771__auto___44610)){
args__4777__auto__.push((arguments[i__4772__auto___44611]));

var G__44612 = (i__4772__auto___44611 + (1));
i__4772__auto___44611 = G__44612;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e44609){var e = e44609;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq44608){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44608));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e44613){var e = e44613;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44668){
var state_val_44669 = (state_44668[(1)]);
if((state_val_44669 === (7))){
var inst_44615 = (state_44668[(2)]);
var state_44668__$1 = state_44668;
var statearr_44670_44703 = state_44668__$1;
(statearr_44670_44703[(2)] = inst_44615);

(statearr_44670_44703[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44669 === (1))){
var state_44668__$1 = state_44668;
var statearr_44671_44704 = state_44668__$1;
(statearr_44671_44704[(2)] = null);

(statearr_44671_44704[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44669 === (4))){
var inst_44614 = (state_44668[(2)]);
var state_44668__$1 = (function (){var statearr_44672 = state_44668;
(statearr_44672[(7)] = inst_44614);

return statearr_44672;
})();
var statearr_44673_44705 = state_44668__$1;
(statearr_44673_44705[(2)] = null);

(statearr_44673_44705[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44669 === (15))){
var inst_44652 = (state_44668[(8)]);
var inst_44656 = inst_44652.o;
var state_44668__$1 = state_44668;
var statearr_44674_44706 = state_44668__$1;
(statearr_44674_44706[(2)] = inst_44656);

(statearr_44674_44706[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44669 === (13))){
var inst_44652 = (state_44668[(8)]);
var inst_44648 = (state_44668[(2)]);
var inst_44649 = fluree.db.util.async.throw_err(inst_44648);
var inst_44650 = fluree.db.dbfunctions.internal.count(inst_44649);
var inst_44652__$1 = cljs.core.first(inst_44649);
var inst_44653 = (inst_44652__$1 == null);
var state_44668__$1 = (function (){var statearr_44675 = state_44668;
(statearr_44675[(9)] = inst_44650);

(statearr_44675[(8)] = inst_44652__$1);

return statearr_44675;
})();
if(cljs.core.truth_(inst_44653)){
var statearr_44676_44707 = state_44668__$1;
(statearr_44676_44707[(1)] = (14));

} else {
var statearr_44677_44708 = state_44668__$1;
(statearr_44677_44708[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44669 === (6))){
var inst_44624 = (state_44668[(2)]);
var state_44668__$1 = state_44668;
var statearr_44678_44709 = state_44668__$1;
(statearr_44678_44709[(2)] = inst_44624);

(statearr_44678_44709[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44669 === (3))){
var inst_44666 = (state_44668[(2)]);
var state_44668__$1 = state_44668;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44668__$1,inst_44666);
} else {
if((state_val_44669 === (12))){
var inst_44663 = (state_44668[(2)]);
var _ = (function (){var statearr_44679 = state_44668;
(statearr_44679[(4)] = cljs.core.rest((state_44668[(4)])));

return statearr_44679;
})();
var state_44668__$1 = state_44668;
var statearr_44680_44710 = state_44668__$1;
(statearr_44680_44710[(2)] = inst_44663);

(statearr_44680_44710[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44669 === (2))){
var _ = (function (){var statearr_44682 = state_44668;
(statearr_44682[(4)] = cljs.core.cons((9),(state_44668[(4)])));

return statearr_44682;
})();
var inst_44630 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44631 = typeof inst_44630 === 'string';
var state_44668__$1 = state_44668;
if(cljs.core.truth_(inst_44631)){
var statearr_44683_44711 = state_44668__$1;
(statearr_44683_44711[(1)] = (10));

} else {
var statearr_44684_44712 = state_44668__$1;
(statearr_44684_44712[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44669 === (11))){
var inst_44637 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44638 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_44637);
var inst_44639 = fluree.db.dbfunctions.internal.inc(inst_44638);
var inst_44640 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_44637,cljs.core.cst$kw$t,inst_44639);
var inst_44641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44642 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44643 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44644 = [inst_44642,inst_44643];
var inst_44645 = (new cljs.core.PersistentVector(null,2,(5),inst_44641,inst_44644,null));
var inst_44646 = fluree.db.dbproto._search(inst_44640,inst_44645);
var state_44668__$1 = state_44668;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44668__$1,(13),inst_44646);
} else {
if((state_val_44669 === (9))){
var _ = (function (){var statearr_44685 = state_44668;
(statearr_44685[(4)] = cljs.core.rest((state_44668[(4)])));

return statearr_44685;
})();
var state_44668__$1 = state_44668;
var ex44681 = (state_44668__$1[(2)]);
var statearr_44686_44713 = state_44668__$1;
(statearr_44686_44713[(5)] = ex44681);


var statearr_44687_44714 = state_44668__$1;
(statearr_44687_44714[(1)] = (4));

(statearr_44687_44714[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44669 === (5))){
var inst_44614 = (state_44668[(7)]);
var _ = (function (){var statearr_44688 = state_44668;
(statearr_44688[(4)] = cljs.core.cons((8),(state_44668[(4)])));

return statearr_44688;
})();
var inst_44621 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44614,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_44689 = state_44668;
(statearr_44689[(4)] = cljs.core.rest((state_44668[(4)])));

return statearr_44689;
})();
var state_44668__$1 = state_44668;
var statearr_44690_44715 = state_44668__$1;
(statearr_44690_44715[(2)] = inst_44621);

(statearr_44690_44715[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44669 === (14))){
var state_44668__$1 = state_44668;
var statearr_44691_44716 = state_44668__$1;
(statearr_44691_44716[(2)] = null);

(statearr_44691_44716[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44669 === (16))){
var inst_44650 = (state_44668[(9)]);
var inst_44658 = (state_44668[(2)]);
var inst_44659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44660 = [inst_44658,inst_44650];
var inst_44661 = (new cljs.core.PersistentVector(null,2,(5),inst_44659,inst_44660,null));
var state_44668__$1 = state_44668;
var statearr_44693_44717 = state_44668__$1;
(statearr_44693_44717[(2)] = inst_44661);

(statearr_44693_44717[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44669 === (10))){
var inst_44633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44634 = [null,(0)];
var inst_44635 = (new cljs.core.PersistentVector(null,2,(5),inst_44633,inst_44634,null));
var state_44668__$1 = state_44668;
var statearr_44694_44718 = state_44668__$1;
(statearr_44694_44718[(2)] = inst_44635);

(statearr_44694_44718[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44669 === (8))){
var _ = (function (){var statearr_44695 = state_44668;
(statearr_44695[(4)] = cljs.core.rest((state_44668[(4)])));

return statearr_44695;
})();
var state_44668__$1 = state_44668;
var ex44692 = (state_44668__$1[(2)]);
var statearr_44696_44719 = state_44668__$1;
(statearr_44696_44719[(5)] = ex44692);


var statearr_44697_44720 = state_44668__$1;
(statearr_44697_44720[(1)] = (7));

(statearr_44697_44720[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto____0 = (function (){
var statearr_44698 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44698[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto__);

(statearr_44698[(1)] = (1));

return statearr_44698;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto____1 = (function (state_44668){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44668);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44699){var ex__13886__auto__ = e44699;
var statearr_44700_44721 = state_44668;
(statearr_44700_44721[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44668[(4)]))){
var statearr_44701_44722 = state_44668;
(statearr_44701_44722[(1)] = cljs.core.first((state_44668[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__44723 = state_44668;
state_44668 = G__44723;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto__ = function(state_44668){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto____1.call(this,state_44668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44702 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44702[(6)] = c__13957__auto__);

return statearr_44702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44775){
var state_val_44776 = (state_44775[(1)]);
if((state_val_44776 === (7))){
var inst_44725 = (state_44775[(2)]);
var state_44775__$1 = state_44775;
var statearr_44777_44806 = state_44775__$1;
(statearr_44777_44806[(2)] = inst_44725);

(statearr_44777_44806[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44776 === (1))){
var state_44775__$1 = state_44775;
var statearr_44778_44807 = state_44775__$1;
(statearr_44778_44807[(2)] = null);

(statearr_44778_44807[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44776 === (4))){
var inst_44724 = (state_44775[(2)]);
var state_44775__$1 = (function (){var statearr_44779 = state_44775;
(statearr_44779[(7)] = inst_44724);

return statearr_44779;
})();
var statearr_44780_44808 = state_44775__$1;
(statearr_44780_44808[(2)] = null);

(statearr_44780_44808[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44776 === (13))){
var inst_44770 = (state_44775[(2)]);
var _ = (function (){var statearr_44781 = state_44775;
(statearr_44781[(4)] = cljs.core.rest((state_44775[(4)])));

return statearr_44781;
})();
var state_44775__$1 = state_44775;
var statearr_44782_44809 = state_44775__$1;
(statearr_44782_44809[(2)] = inst_44770);

(statearr_44782_44809[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44776 === (6))){
var inst_44734 = (state_44775[(2)]);
var state_44775__$1 = state_44775;
var statearr_44783_44810 = state_44775__$1;
(statearr_44783_44810[(2)] = inst_44734);

(statearr_44783_44810[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44776 === (3))){
var inst_44773 = (state_44775[(2)]);
var state_44775__$1 = state_44775;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44775__$1,inst_44773);
} else {
if((state_val_44776 === (12))){
var inst_44757 = (state_44775[(8)]);
var inst_44766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44767 = [null,inst_44757];
var inst_44768 = (new cljs.core.PersistentVector(null,2,(5),inst_44766,inst_44767,null));
var state_44775__$1 = state_44775;
var statearr_44784_44811 = state_44775__$1;
(statearr_44784_44811[(2)] = inst_44768);

(statearr_44784_44811[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44776 === (2))){
var _ = (function (){var statearr_44786 = state_44775;
(statearr_44786[(4)] = cljs.core.cons((9),(state_44775[(4)])));

return statearr_44786;
})();
var inst_44743 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_44744 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44746 = [null,pred_name,"?o"];
var inst_44747 = (new cljs.core.PersistentVector(null,3,(5),inst_44745,inst_44746,null));
var inst_44748 = [inst_44747];
var inst_44749 = (new cljs.core.PersistentVector(null,1,(5),inst_44744,inst_44748,null));
var inst_44750 = ["?o",inst_44749,opts];
var inst_44751 = cljs.core.PersistentHashMap.fromArrays(inst_44743,inst_44750);
var inst_44752 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_44751);
var state_44775__$1 = state_44775;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44775__$1,(10),inst_44752);
} else {
if((state_val_44776 === (11))){
var inst_44756 = (state_44775[(9)]);
var inst_44757 = (state_44775[(8)]);
var inst_44761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44762 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_44756);
var inst_44763 = [inst_44762,inst_44757];
var inst_44764 = (new cljs.core.PersistentVector(null,2,(5),inst_44761,inst_44763,null));
var state_44775__$1 = state_44775;
var statearr_44787_44812 = state_44775__$1;
(statearr_44787_44812[(2)] = inst_44764);

(statearr_44787_44812[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44776 === (9))){
var _ = (function (){var statearr_44788 = state_44775;
(statearr_44788[(4)] = cljs.core.rest((state_44775[(4)])));

return statearr_44788;
})();
var state_44775__$1 = state_44775;
var ex44785 = (state_44775__$1[(2)]);
var statearr_44789_44813 = state_44775__$1;
(statearr_44789_44813[(5)] = ex44785);


var statearr_44790_44814 = state_44775__$1;
(statearr_44790_44814[(1)] = (4));

(statearr_44790_44814[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44776 === (5))){
var inst_44724 = (state_44775[(7)]);
var _ = (function (){var statearr_44792 = state_44775;
(statearr_44792[(4)] = cljs.core.cons((8),(state_44775[(4)])));

return statearr_44792;
})();
var inst_44731 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44724,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_44793 = state_44775;
(statearr_44793[(4)] = cljs.core.rest((state_44775[(4)])));

return statearr_44793;
})();
var state_44775__$1 = state_44775;
var statearr_44794_44815 = state_44775__$1;
(statearr_44794_44815[(2)] = inst_44731);

(statearr_44794_44815[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44776 === (10))){
var inst_44756 = (state_44775[(9)]);
var inst_44754 = (state_44775[(2)]);
var inst_44755 = fluree.db.util.async.throw_err(inst_44754);
var inst_44756__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44755,(0),null);
var inst_44757 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44755,(1),null);
var inst_44758 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_44756__$1);
var inst_44759 = cljs.core.not(inst_44758);
var state_44775__$1 = (function (){var statearr_44795 = state_44775;
(statearr_44795[(9)] = inst_44756__$1);

(statearr_44795[(8)] = inst_44757);

return statearr_44795;
})();
if(inst_44759){
var statearr_44796_44816 = state_44775__$1;
(statearr_44796_44816[(1)] = (11));

} else {
var statearr_44797_44817 = state_44775__$1;
(statearr_44797_44817[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44776 === (8))){
var _ = (function (){var statearr_44798 = state_44775;
(statearr_44798[(4)] = cljs.core.rest((state_44775[(4)])));

return statearr_44798;
})();
var state_44775__$1 = state_44775;
var ex44791 = (state_44775__$1[(2)]);
var statearr_44799_44818 = state_44775__$1;
(statearr_44799_44818[(5)] = ex44791);


var statearr_44800_44819 = state_44775__$1;
(statearr_44800_44819[(1)] = (7));

(statearr_44800_44819[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto____0 = (function (){
var statearr_44801 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44801[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto__);

(statearr_44801[(1)] = (1));

return statearr_44801;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto____1 = (function (state_44775){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44775);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44802){var ex__13886__auto__ = e44802;
var statearr_44803_44820 = state_44775;
(statearr_44803_44820[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44775[(4)]))){
var statearr_44804_44821 = state_44775;
(statearr_44804_44821[(1)] = cljs.core.first((state_44775[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__44822 = state_44775;
state_44775 = G__44822;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto__ = function(state_44775){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto____1.call(this,state_44775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44805 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44805[(6)] = c__13957__auto__);

return statearr_44805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$(((typeof email === 'string')?cljs.core.re_matches(pattern,email):false));
}catch (e44823){var e = e44823;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__44825 = arguments.length;
switch (G__44825) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_44895){
var state_val_44896 = (state_44895[(1)]);
if((state_val_44896 === (7))){
var inst_44827 = (state_44895[(2)]);
var state_44895__$1 = state_44895;
var statearr_44897_44941 = state_44895__$1;
(statearr_44897_44941[(2)] = inst_44827);

(statearr_44897_44941[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (20))){
var inst_44871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44872 = ["*"];
var inst_44873 = (new cljs.core.PersistentVector(null,1,(5),inst_44871,inst_44872,null));
var state_44895__$1 = state_44895;
var statearr_44898_44942 = state_44895__$1;
(statearr_44898_44942[(2)] = inst_44873);

(statearr_44898_44942[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (1))){
var state_44895__$1 = state_44895;
var statearr_44899_44943 = state_44895__$1;
(statearr_44899_44943[(2)] = null);

(statearr_44899_44943[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (4))){
var inst_44826 = (state_44895[(2)]);
var state_44895__$1 = (function (){var statearr_44900 = state_44895;
(statearr_44900[(7)] = inst_44826);

return statearr_44900;
})();
var statearr_44901_44944 = state_44895__$1;
(statearr_44901_44944[(2)] = null);

(statearr_44901_44944[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (15))){
var inst_44890 = (state_44895[(2)]);
var _ = (function (){var statearr_44902 = state_44895;
(statearr_44902[(4)] = cljs.core.rest((state_44895[(4)])));

return statearr_44902;
})();
var state_44895__$1 = state_44895;
var statearr_44903_44945 = state_44895__$1;
(statearr_44903_44945[(2)] = inst_44890);

(statearr_44903_44945[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (21))){
var inst_44861 = (state_44895[(8)]);
var inst_44854 = (state_44895[(9)]);
var inst_44875 = (state_44895[(2)]);
var inst_44876 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_44877 = cljs.core.PersistentHashMap.EMPTY;
var inst_44878 = [inst_44875,inst_44861,inst_44877];
var inst_44879 = cljs.core.PersistentHashMap.fromArrays(inst_44876,inst_44878);
var inst_44880 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_44854,inst_44879);
var state_44895__$1 = state_44895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44895__$1,(22),inst_44880);
} else {
if((state_val_44896 === (13))){
var inst_44849 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_44895__$1 = state_44895;
var statearr_44904_44946 = state_44895__$1;
(statearr_44904_44946[(2)] = inst_44849);

(statearr_44904_44946[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (22))){
var inst_44882 = (state_44895[(2)]);
var inst_44883 = fluree.db.util.async.throw_err(inst_44882);
var inst_44884 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44883,(0),null);
var inst_44885 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44883,(1),null);
var inst_44886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44887 = [inst_44884,inst_44885];
var inst_44888 = (new cljs.core.PersistentVector(null,2,(5),inst_44886,inst_44887,null));
var state_44895__$1 = state_44895;
var statearr_44905_44947 = state_44895__$1;
(statearr_44905_44947[(2)] = inst_44888);

(statearr_44905_44947[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (6))){
var inst_44836 = (state_44895[(2)]);
var state_44895__$1 = state_44895;
var statearr_44906_44948 = state_44895__$1;
(statearr_44906_44948[(2)] = inst_44836);

(statearr_44906_44948[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (17))){
var inst_44858 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44859 = fluree.db.dbfunctions.internal.get(inst_44858,cljs.core.cst$kw$_id);
var state_44895__$1 = state_44895;
var statearr_44907_44949 = state_44895__$1;
(statearr_44907_44949[(2)] = inst_44859);

(statearr_44907_44949[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (3))){
var inst_44893 = (state_44895[(2)]);
var state_44895__$1 = state_44895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44895__$1,inst_44893);
} else {
if((state_val_44896 === (12))){
var inst_44847 = (state_44895[(2)]);
var state_44895__$1 = state_44895;
if(cljs.core.truth_(inst_44847)){
var statearr_44908_44950 = state_44895__$1;
(statearr_44908_44950[(1)] = (13));

} else {
var statearr_44909_44951 = state_44895__$1;
(statearr_44909_44951[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (2))){
var inst_44842 = (state_44895[(10)]);
var _ = (function (){var statearr_44910 = state_44895;
(statearr_44910[(4)] = cljs.core.cons((9),(state_44895[(4)])));

return statearr_44910;
})();
var inst_44842__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_44895__$1 = (function (){var statearr_44911 = state_44895;
(statearr_44911[(10)] = inst_44842__$1);

return statearr_44911;
})();
if(cljs.core.truth_(inst_44842__$1)){
var statearr_44912_44952 = state_44895__$1;
(statearr_44912_44952[(1)] = (10));

} else {
var statearr_44913_44953 = state_44895__$1;
(statearr_44913_44953[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (19))){
var inst_44863 = cljs.core.PersistentVector.EMPTY;
var inst_44864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44865 = ["*"];
var inst_44866 = (new cljs.core.PersistentVector(null,1,(5),inst_44864,inst_44865,null));
var inst_44867 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_44868 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_44866,inst_44867);
var inst_44869 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_44863,inst_44868);
var state_44895__$1 = state_44895;
var statearr_44915_44954 = state_44895__$1;
(statearr_44915_44954[(2)] = inst_44869);

(statearr_44915_44954[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (11))){
var inst_44842 = (state_44895[(10)]);
var state_44895__$1 = state_44895;
var statearr_44916_44955 = state_44895__$1;
(statearr_44916_44955[(2)] = inst_44842);

(statearr_44916_44955[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (9))){
var _ = (function (){var statearr_44917 = state_44895;
(statearr_44917[(4)] = cljs.core.rest((state_44895[(4)])));

return statearr_44917;
})();
var state_44895__$1 = state_44895;
var ex44914 = (state_44895__$1[(2)]);
var statearr_44918_44956 = state_44895__$1;
(statearr_44918_44956[(5)] = ex44914);


var statearr_44919_44957 = state_44895__$1;
(statearr_44919_44957[(1)] = (4));

(statearr_44919_44957[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (5))){
var inst_44826 = (state_44895[(7)]);
var _ = (function (){var statearr_44920 = state_44895;
(statearr_44920[(4)] = cljs.core.cons((8),(state_44895[(4)])));

return statearr_44920;
})();
var inst_44833 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44826,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_44921 = state_44895;
(statearr_44921[(4)] = cljs.core.rest((state_44895[(4)])));

return statearr_44921;
})();
var state_44895__$1 = state_44895;
var statearr_44922_44958 = state_44895__$1;
(statearr_44922_44958[(2)] = inst_44833);

(statearr_44922_44958[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (14))){
var inst_44855 = (state_44895[(11)]);
var inst_44854 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44855__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_44895__$1 = (function (){var statearr_44923 = state_44895;
(statearr_44923[(11)] = inst_44855__$1);

(statearr_44923[(9)] = inst_44854);

return statearr_44923;
})();
if(cljs.core.truth_(inst_44855__$1)){
var statearr_44924_44959 = state_44895__$1;
(statearr_44924_44959[(1)] = (16));

} else {
var statearr_44925_44960 = state_44895__$1;
(statearr_44925_44960[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (16))){
var inst_44855 = (state_44895[(11)]);
var state_44895__$1 = state_44895;
var statearr_44926_44961 = state_44895__$1;
(statearr_44926_44961[(2)] = inst_44855);

(statearr_44926_44961[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (10))){
var inst_44844 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_44895__$1 = state_44895;
var statearr_44928_44962 = state_44895__$1;
(statearr_44928_44962[(2)] = inst_44844);

(statearr_44928_44962[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (18))){
var inst_44861 = (state_44895[(2)]);
var state_44895__$1 = (function (){var statearr_44929 = state_44895;
(statearr_44929[(8)] = inst_44861);

return statearr_44929;
})();
if(cljs.core.truth_(additional_params)){
var statearr_44930_44963 = state_44895__$1;
(statearr_44930_44963[(1)] = (19));

} else {
var statearr_44931_44964 = state_44895__$1;
(statearr_44931_44964[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44896 === (8))){
var _ = (function (){var statearr_44932 = state_44895;
(statearr_44932[(4)] = cljs.core.rest((state_44895[(4)])));

return statearr_44932;
})();
var state_44895__$1 = state_44895;
var ex44927 = (state_44895__$1[(2)]);
var statearr_44933_44965 = state_44895__$1;
(statearr_44933_44965[(5)] = ex44927);


var statearr_44934_44966 = state_44895__$1;
(statearr_44934_44966[(1)] = (7));

(statearr_44934_44966[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__13883__auto____0 = (function (){
var statearr_44935 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44935[(0)] = fluree$db$dbfunctions$internal$state_machine__13883__auto__);

(statearr_44935[(1)] = (1));

return statearr_44935;
});
var fluree$db$dbfunctions$internal$state_machine__13883__auto____1 = (function (state_44895){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_44895);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e44936){var ex__13886__auto__ = e44936;
var statearr_44937_44967 = state_44895;
(statearr_44937_44967[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_44895[(4)]))){
var statearr_44938_44968 = state_44895;
(statearr_44938_44968[(1)] = cljs.core.first((state_44895[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__44969 = state_44895;
state_44895 = G__44969;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__13883__auto__ = function(state_44895){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____1.call(this,state_44895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_44939 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_44939[(6)] = c__13957__auto__);

return statearr_44939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__44971 = arguments.length;
switch (G__44971) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_45015){
var state_val_45016 = (state_45015[(1)]);
if((state_val_45016 === (7))){
var inst_44993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44994 = ["*"];
var inst_44995 = (new cljs.core.PersistentVector(null,1,(5),inst_44993,inst_44994,null));
var state_45015__$1 = state_45015;
var statearr_45017_45037 = state_45015__$1;
(statearr_45017_45037[(2)] = inst_44995);

(statearr_45017_45037[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45016 === (1))){
var state_45015__$1 = state_45015;
var statearr_45018_45038 = state_45015__$1;
(statearr_45018_45038[(2)] = null);

(statearr_45018_45038[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45016 === (4))){
var inst_44972 = (state_45015[(2)]);
var inst_44973 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44972,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_45015__$1 = state_45015;
var statearr_45019_45039 = state_45015__$1;
(statearr_45019_45039[(2)] = inst_44973);

(statearr_45019_45039[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45016 === (6))){
var inst_44985 = cljs.core.PersistentVector.EMPTY;
var inst_44986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44987 = ["*"];
var inst_44988 = (new cljs.core.PersistentVector(null,1,(5),inst_44986,inst_44987,null));
var inst_44989 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_44990 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_44988,inst_44989);
var inst_44991 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_44985,inst_44990);
var state_45015__$1 = state_45015;
var statearr_45020_45040 = state_45015__$1;
(statearr_45020_45040[(2)] = inst_44991);

(statearr_45020_45040[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45016 === (3))){
var inst_45013 = (state_45015[(2)]);
var state_45015__$1 = state_45015;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45015__$1,inst_45013);
} else {
if((state_val_45016 === (2))){
var _ = (function (){var statearr_45022 = state_45015;
(statearr_45022[(4)] = cljs.core.cons((5),(state_45015[(4)])));

return statearr_45022;
})();
var inst_44982 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_44983 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_45015__$1 = (function (){var statearr_45023 = state_45015;
(statearr_45023[(7)] = inst_44982);

(statearr_45023[(8)] = inst_44983);

return statearr_45023;
})();
if(cljs.core.truth_(additional_params)){
var statearr_45024_45041 = state_45015__$1;
(statearr_45024_45041[(1)] = (6));

} else {
var statearr_45025_45042 = state_45015__$1;
(statearr_45025_45042[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45016 === (9))){
var inst_45004 = (state_45015[(2)]);
var inst_45005 = fluree.db.util.async.throw_err(inst_45004);
var inst_45006 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45005,(0),null);
var inst_45007 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45005,(1),null);
var inst_45008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45009 = [inst_45006,inst_45007];
var inst_45010 = (new cljs.core.PersistentVector(null,2,(5),inst_45008,inst_45009,null));
var _ = (function (){var statearr_45026 = state_45015;
(statearr_45026[(4)] = cljs.core.rest((state_45015[(4)])));

return statearr_45026;
})();
var state_45015__$1 = state_45015;
var statearr_45027_45043 = state_45015__$1;
(statearr_45027_45043[(2)] = inst_45010);

(statearr_45027_45043[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45016 === (5))){
var _ = (function (){var statearr_45028 = state_45015;
(statearr_45028[(4)] = cljs.core.rest((state_45015[(4)])));

return statearr_45028;
})();
var state_45015__$1 = state_45015;
var ex45021 = (state_45015__$1[(2)]);
var statearr_45029_45044 = state_45015__$1;
(statearr_45029_45044[(5)] = ex45021);


var statearr_45030_45045 = state_45015__$1;
(statearr_45030_45045[(1)] = (4));

(statearr_45030_45045[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45016 === (8))){
var inst_44982 = (state_45015[(7)]);
var inst_44983 = (state_45015[(8)]);
var inst_44997 = (state_45015[(2)]);
var inst_44998 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_44999 = cljs.core.PersistentHashMap.EMPTY;
var inst_45000 = [inst_44997,inst_44983,inst_44999];
var inst_45001 = cljs.core.PersistentHashMap.fromArrays(inst_44998,inst_45000);
var inst_45002 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_44982,inst_45001);
var state_45015__$1 = state_45015;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45015__$1,(9),inst_45002);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__13883__auto____0 = (function (){
var statearr_45031 = [null,null,null,null,null,null,null,null,null];
(statearr_45031[(0)] = fluree$db$dbfunctions$internal$state_machine__13883__auto__);

(statearr_45031[(1)] = (1));

return statearr_45031;
});
var fluree$db$dbfunctions$internal$state_machine__13883__auto____1 = (function (state_45015){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_45015);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e45032){var ex__13886__auto__ = e45032;
var statearr_45033_45046 = state_45015;
(statearr_45033_45046[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_45015[(4)]))){
var statearr_45034_45047 = state_45015;
(statearr_45034_45047[(1)] = cljs.core.first((state_45015[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__45048 = state_45015;
state_45015 = G__45048;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__13883__auto__ = function(state_45015){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__13883__auto____1.call(this,state_45015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_45035 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_45035[(6)] = c__13957__auto__);

return statearr_45035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_45092){
var state_val_45093 = (state_45092[(1)]);
if((state_val_45093 === (1))){
var state_45092__$1 = state_45092;
var statearr_45094_45108 = state_45092__$1;
(statearr_45094_45108[(2)] = null);

(statearr_45094_45108[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45093 === (2))){
var _ = (function (){var statearr_45095 = state_45092;
(statearr_45095[(4)] = cljs.core.cons((5),(state_45092[(4)])));

return statearr_45095;
})();
var inst_45059 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_45060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45061 = ["_user/_auth"];
var inst_45062 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45063 = ["*"];
var inst_45064 = (new cljs.core.PersistentVector(null,1,(5),inst_45062,inst_45063,null));
var inst_45065 = [inst_45064];
var inst_45066 = cljs.core.PersistentHashMap.fromArrays(inst_45061,inst_45065);
var inst_45067 = [inst_45066];
var inst_45068 = (new cljs.core.PersistentVector(null,1,(5),inst_45060,inst_45067,null));
var inst_45069 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45070 = cljs.core.PersistentHashMap.EMPTY;
var inst_45071 = [inst_45068,inst_45069,inst_45070];
var inst_45072 = cljs.core.PersistentHashMap.fromArrays(inst_45059,inst_45071);
var inst_45073 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45074 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_45073,inst_45072);
var state_45092__$1 = state_45092;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45092__$1,(6),inst_45074);
} else {
if((state_val_45093 === (3))){
var inst_45090 = (state_45092[(2)]);
var state_45092__$1 = state_45092;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45092__$1,inst_45090);
} else {
if((state_val_45093 === (4))){
var inst_45049 = (state_45092[(2)]);
var inst_45050 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45049,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_45092__$1 = state_45092;
var statearr_45097_45109 = state_45092__$1;
(statearr_45097_45109[(2)] = inst_45050);

(statearr_45097_45109[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45093 === (5))){
var _ = (function (){var statearr_45098 = state_45092;
(statearr_45098[(4)] = cljs.core.rest((state_45092[(4)])));

return statearr_45098;
})();
var state_45092__$1 = state_45092;
var ex45096 = (state_45092__$1[(2)]);
var statearr_45099_45110 = state_45092__$1;
(statearr_45099_45110[(5)] = ex45096);


var statearr_45100_45111 = state_45092__$1;
(statearr_45100_45111[(1)] = (4));

(statearr_45100_45111[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45093 === (6))){
var inst_45076 = (state_45092[(2)]);
var inst_45077 = fluree.db.util.async.throw_err(inst_45076);
var inst_45078 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45077,(0),null);
var inst_45079 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45077,(1),null);
var inst_45080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45081 = ["_user/_auth","_id"];
var inst_45082 = (new cljs.core.PersistentVector(null,2,(5),inst_45080,inst_45081,null));
var inst_45083 = fluree.db.dbfunctions.internal.get_in(inst_45078,inst_45082);
var inst_45084 = cljs.core.first(inst_45083);
var inst_45085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45086 = [inst_45084,inst_45079];
var inst_45087 = (new cljs.core.PersistentVector(null,2,(5),inst_45085,inst_45086,null));
var _ = (function (){var statearr_45101 = state_45092;
(statearr_45101[(4)] = cljs.core.rest((state_45092[(4)])));

return statearr_45101;
})();
var state_45092__$1 = state_45092;
var statearr_45102_45112 = state_45092__$1;
(statearr_45102_45112[(2)] = inst_45087);

(statearr_45102_45112[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto____0 = (function (){
var statearr_45103 = [null,null,null,null,null,null,null];
(statearr_45103[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto__);

(statearr_45103[(1)] = (1));

return statearr_45103;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto____1 = (function (state_45092){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_45092);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e45104){var ex__13886__auto__ = e45104;
var statearr_45105_45113 = state_45092;
(statearr_45105_45113[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_45092[(4)]))){
var statearr_45106_45114 = state_45092;
(statearr_45106_45114[(1)] = cljs.core.first((state_45092[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__45115 = state_45092;
state_45092 = G__45115;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto__ = function(state_45092){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto____1.call(this,state_45092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_45107 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_45107[(6)] = c__13957__auto__);

return statearr_45107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_45132){
var state_val_45133 = (state_45132[(1)]);
if((state_val_45133 === (1))){
var state_45132__$1 = state_45132;
var statearr_45134_45148 = state_45132__$1;
(statearr_45134_45148[(2)] = null);

(statearr_45134_45148[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (2))){
var _ = (function (){var statearr_45135 = state_45132;
(statearr_45135[(4)] = cljs.core.cons((5),(state_45132[(4)])));

return statearr_45135;
})();
var inst_45122 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45123 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45124 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_45123,inst_45122);
var state_45132__$1 = state_45132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45132__$1,(6),inst_45124);
} else {
if((state_val_45133 === (3))){
var inst_45130 = (state_45132[(2)]);
var state_45132__$1 = state_45132;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45132__$1,inst_45130);
} else {
if((state_val_45133 === (4))){
var inst_45116 = (state_45132[(2)]);
var state_45132__$1 = state_45132;
var statearr_45137_45149 = state_45132__$1;
(statearr_45137_45149[(2)] = inst_45116);

(statearr_45137_45149[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (5))){
var _ = (function (){var statearr_45138 = state_45132;
(statearr_45138[(4)] = cljs.core.rest((state_45132[(4)])));

return statearr_45138;
})();
var state_45132__$1 = state_45132;
var ex45136 = (state_45132__$1[(2)]);
var statearr_45139_45150 = state_45132__$1;
(statearr_45139_45150[(5)] = ex45136);


if((ex45136 instanceof Error)){
var statearr_45140_45151 = state_45132__$1;
(statearr_45140_45151[(1)] = (4));

(statearr_45140_45151[(5)] = null);

} else {
throw ex45136;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (6))){
var inst_45126 = (state_45132[(2)]);
var inst_45127 = fluree.db.util.async.throw_err(inst_45126);
var _ = (function (){var statearr_45141 = state_45132;
(statearr_45141[(4)] = cljs.core.rest((state_45132[(4)])));

return statearr_45141;
})();
var state_45132__$1 = state_45132;
var statearr_45142_45152 = state_45132__$1;
(statearr_45142_45152[(2)] = inst_45127);

(statearr_45142_45152[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto____0 = (function (){
var statearr_45143 = [null,null,null,null,null,null,null];
(statearr_45143[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto__);

(statearr_45143[(1)] = (1));

return statearr_45143;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto____1 = (function (state_45132){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_45132);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e45144){var ex__13886__auto__ = e45144;
var statearr_45145_45153 = state_45132;
(statearr_45145_45153[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_45132[(4)]))){
var statearr_45146_45154 = state_45132;
(statearr_45146_45154[(1)] = cljs.core.first((state_45132[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__45155 = state_45132;
state_45132 = G__45155;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto__ = function(state_45132){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto____1.call(this,state_45132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_45147 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_45147[(6)] = c__13957__auto__);

return statearr_45147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__45156_SHARP_){
return p1__45156_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45157_SHARP_){
return p1__45157_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e45158){var e = e45158;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__45159_SHARP_){
return p1__45159_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45160_SHARP_){
return p1__45160_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e45161){var e = e45161;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__45163 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__45163);
})() | (0));
return num;
}catch (e45162){var e = e45162;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_45243){
var state_val_45244 = (state_45243[(1)]);
if((state_val_45244 === (7))){
var inst_45182 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_45183 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45184 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45185 = cljs.core.PersistentHashMap.fromArrays(inst_45183,inst_45184);
var inst_45186 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45182,inst_45185);
var inst_45187 = (function(){throw inst_45186})();
var state_45243__$1 = state_45243;
var statearr_45245_45280 = state_45243__$1;
(statearr_45245_45280[(2)] = inst_45187);

(statearr_45245_45280[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (1))){
var state_45243__$1 = state_45243;
var statearr_45246_45281 = state_45243__$1;
(statearr_45246_45281[(2)] = null);

(statearr_45246_45281[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (4))){
var inst_45164 = (state_45243[(2)]);
var state_45243__$1 = state_45243;
var statearr_45247_45282 = state_45243__$1;
(statearr_45247_45282[(2)] = inst_45164);

(statearr_45247_45282[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (15))){
var inst_45227 = (state_45243[(7)]);
var inst_45223 = (state_45243[(2)]);
var inst_45224 = fluree.db.util.async.throw_err(inst_45223);
var inst_45225 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45224,(0),null);
var inst_45226 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45224,(1),null);
var inst_45227__$1 = cljs.core.first(inst_45225);
var inst_45228 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45227__$1,compare_val);
var state_45243__$1 = (function (){var statearr_45248 = state_45243;
(statearr_45248[(8)] = inst_45226);

(statearr_45248[(7)] = inst_45227__$1);

return statearr_45248;
})();
if(inst_45228){
var statearr_45249_45283 = state_45243__$1;
(statearr_45249_45283[(1)] = (16));

} else {
var statearr_45250_45284 = state_45243__$1;
(statearr_45250_45284[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (13))){
var state_45243__$1 = state_45243;
var statearr_45251_45285 = state_45243__$1;
(statearr_45251_45285[(2)] = null);

(statearr_45251_45285[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (6))){
var state_45243__$1 = state_45243;
var statearr_45252_45286 = state_45243__$1;
(statearr_45252_45286[(2)] = null);

(statearr_45252_45286[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (17))){
var inst_45227 = (state_45243[(7)]);
var inst_45231 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45227)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_45232 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45233 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45234 = cljs.core.PersistentHashMap.fromArrays(inst_45232,inst_45233);
var inst_45235 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45231,inst_45234);
var inst_45236 = (function(){throw inst_45235})();
var state_45243__$1 = state_45243;
var statearr_45253_45287 = state_45243__$1;
(statearr_45253_45287[(2)] = inst_45236);

(statearr_45253_45287[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (3))){
var inst_45241 = (state_45243[(2)]);
var state_45243__$1 = state_45243;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45243__$1,inst_45241);
} else {
if((state_val_45244 === (12))){
var inst_45179 = (state_45243[(9)]);
var inst_45202 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_45179], 0));
var inst_45203 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45204 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45205 = cljs.core.PersistentHashMap.fromArrays(inst_45203,inst_45204);
var inst_45206 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45202,inst_45205);
var inst_45207 = (function(){throw inst_45206})();
var state_45243__$1 = state_45243;
var statearr_45254_45288 = state_45243__$1;
(statearr_45254_45288[(2)] = inst_45207);

(statearr_45254_45288[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (2))){
var inst_45178 = (state_45243[(10)]);
var inst_45177 = (state_45243[(11)]);
var inst_45176 = (state_45243[(12)]);
var _ = (function (){var statearr_45255 = state_45243;
(statearr_45255[(4)] = cljs.core.cons((5),(state_45243[(4)])));

return statearr_45255;
})();
var inst_45174 = _QMARK_ctx;
var inst_45175 = cljs.core.__destructure_map(inst_45174);
var inst_45176__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45175,cljs.core.cst$kw$sid);
var inst_45177__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45175,cljs.core.cst$kw$pid);
var inst_45178__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45175,cljs.core.cst$kw$db);
var inst_45179 = fluree.db.dbproto._p_prop(inst_45178__$1,cljs.core.cst$kw$name,inst_45177__$1);
var state_45243__$1 = (function (){var statearr_45256 = state_45243;
(statearr_45256[(10)] = inst_45178__$1);

(statearr_45256[(11)] = inst_45177__$1);

(statearr_45256[(9)] = inst_45179);

(statearr_45256[(12)] = inst_45176__$1);

return statearr_45256;
})();
if(cljs.core.truth_(inst_45176__$1)){
var statearr_45257_45289 = state_45243__$1;
(statearr_45257_45289[(1)] = (6));

} else {
var statearr_45258_45290 = state_45243__$1;
(statearr_45258_45290[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (11))){
var inst_45178 = (state_45243[(10)]);
var inst_45177 = (state_45243[(11)]);
var inst_45199 = (state_45243[(2)]);
var inst_45200 = fluree.db.dbproto._p_prop(inst_45178,cljs.core.cst$kw$multi,inst_45177);
var state_45243__$1 = (function (){var statearr_45260 = state_45243;
(statearr_45260[(13)] = inst_45199);

return statearr_45260;
})();
if(cljs.core.truth_(inst_45200)){
var statearr_45261_45291 = state_45243__$1;
(statearr_45261_45291[(1)] = (12));

} else {
var statearr_45262_45292 = state_45243__$1;
(statearr_45262_45292[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (9))){
var state_45243__$1 = state_45243;
var statearr_45263_45293 = state_45243__$1;
(statearr_45263_45293[(2)] = null);

(statearr_45263_45293[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (5))){
var _ = (function (){var statearr_45264 = state_45243;
(statearr_45264[(4)] = cljs.core.rest((state_45243[(4)])));

return statearr_45264;
})();
var state_45243__$1 = state_45243;
var ex45259 = (state_45243__$1[(2)]);
var statearr_45265_45294 = state_45243__$1;
(statearr_45265_45294[(5)] = ex45259);


if((ex45259 instanceof Error)){
var statearr_45266_45295 = state_45243__$1;
(statearr_45266_45295[(1)] = (4));

(statearr_45266_45295[(5)] = null);

} else {
throw ex45259;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (14))){
var inst_45178 = (state_45243[(10)]);
var inst_45179 = (state_45243[(9)]);
var inst_45176 = (state_45243[(12)]);
var inst_45210 = (state_45243[(2)]);
var inst_45211 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_45212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45214 = [inst_45176,inst_45179,"?current-val"];
var inst_45215 = (new cljs.core.PersistentVector(null,3,(5),inst_45213,inst_45214,null));
var inst_45216 = [inst_45215];
var inst_45217 = (new cljs.core.PersistentVector(null,1,(5),inst_45212,inst_45216,null));
var inst_45218 = cljs.core.PersistentHashMap.EMPTY;
var inst_45219 = ["?current-val",inst_45217,inst_45218];
var inst_45220 = cljs.core.PersistentHashMap.fromArrays(inst_45211,inst_45219);
var inst_45221 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_45178,inst_45220);
var state_45243__$1 = (function (){var statearr_45267 = state_45243;
(statearr_45267[(14)] = inst_45210);

return statearr_45267;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45243__$1,(15),inst_45221);
} else {
if((state_val_45244 === (16))){
var state_45243__$1 = state_45243;
var statearr_45268_45296 = state_45243__$1;
(statearr_45268_45296[(2)] = new_val);

(statearr_45268_45296[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (10))){
var inst_45192 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_45193 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45194 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45195 = cljs.core.PersistentHashMap.fromArrays(inst_45193,inst_45194);
var inst_45196 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45192,inst_45195);
var inst_45197 = (function(){throw inst_45196})();
var state_45243__$1 = state_45243;
var statearr_45269_45297 = state_45243__$1;
(statearr_45269_45297[(2)] = inst_45197);

(statearr_45269_45297[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (18))){
var inst_45238 = (state_45243[(2)]);
var _ = (function (){var statearr_45270 = state_45243;
(statearr_45270[(4)] = cljs.core.rest((state_45243[(4)])));

return statearr_45270;
})();
var state_45243__$1 = state_45243;
var statearr_45271_45298 = state_45243__$1;
(statearr_45271_45298[(2)] = inst_45238);

(statearr_45271_45298[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45244 === (8))){
var inst_45179 = (state_45243[(9)]);
var inst_45189 = (state_45243[(2)]);
var state_45243__$1 = (function (){var statearr_45272 = state_45243;
(statearr_45272[(15)] = inst_45189);

return statearr_45272;
})();
if(cljs.core.truth_(inst_45179)){
var statearr_45273_45299 = state_45243__$1;
(statearr_45273_45299[(1)] = (9));

} else {
var statearr_45274_45300 = state_45243__$1;
(statearr_45274_45300[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto____0 = (function (){
var statearr_45275 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45275[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto__);

(statearr_45275[(1)] = (1));

return statearr_45275;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto____1 = (function (state_45243){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_45243);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e45276){var ex__13886__auto__ = e45276;
var statearr_45277_45301 = state_45243;
(statearr_45277_45301[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_45243[(4)]))){
var statearr_45278_45302 = state_45243;
(statearr_45278_45302[(1)] = cljs.core.first((state_45243[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__45303 = state_45243;
state_45243 = G__45303;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto__ = function(state_45243){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto____1.call(this,state_45243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_45279 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_45279[(6)] = c__13957__auto__);

return statearr_45279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
