// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__32345 = arguments.length;
switch (G__32345) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__32348 = arguments.length;
switch (G__32348) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___32401 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_32379){
var state_val_32380 = (state_32379[(1)]);
if((state_val_32380 === (1))){
var state_32379__$1 = state_32379;
var statearr_32381_32402 = state_32379__$1;
(statearr_32381_32402[(2)] = null);

(statearr_32381_32402[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32380 === (2))){
var _ = (function (){var statearr_32382 = state_32379;
(statearr_32382[(4)] = cljs.core.cons((5),(state_32379[(4)])));

return statearr_32382;
})();
var inst_32356 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_32379__$1 = state_32379;
if(cljs.core.truth_(inst_32356)){
var statearr_32383_32403 = state_32379__$1;
(statearr_32383_32403[(1)] = (6));

} else {
var statearr_32384_32404 = state_32379__$1;
(statearr_32384_32404[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32380 === (3))){
var inst_32377 = (state_32379[(2)]);
var state_32379__$1 = state_32379;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32379__$1,inst_32377);
} else {
if((state_val_32380 === (4))){
var inst_32349 = (state_32379[(2)]);
var inst_32350 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_32349);
var state_32379__$1 = state_32379;
var statearr_32386_32405 = state_32379__$1;
(statearr_32386_32405[(2)] = inst_32350);

(statearr_32386_32405[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32380 === (5))){
var _ = (function (){var statearr_32387 = state_32379;
(statearr_32387[(4)] = cljs.core.rest((state_32379[(4)])));

return statearr_32387;
})();
var state_32379__$1 = state_32379;
var ex32385 = (state_32379__$1[(2)]);
var statearr_32388_32406 = state_32379__$1;
(statearr_32388_32406[(5)] = ex32385);


var statearr_32389_32407 = state_32379__$1;
(statearr_32389_32407[(1)] = (4));

(statearr_32389_32407[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32380 === (6))){
var inst_32358 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32359 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_32360 = cljs.core.PersistentHashMap.fromArrays(inst_32358,inst_32359);
var inst_32361 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_32360);
var inst_32362 = (function(){throw inst_32361})();
var state_32379__$1 = state_32379;
var statearr_32390_32408 = state_32379__$1;
(statearr_32390_32408[(2)] = inst_32362);

(statearr_32390_32408[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32380 === (7))){
var inst_32364 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_32365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32366 = [operation,data,pc,opts];
var inst_32367 = (new cljs.core.PersistentVector(null,4,(5),inst_32365,inst_32366,null));
var inst_32368 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32364,inst_32367);
var inst_32369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32370 = [operation,data,pc,opts];
var inst_32371 = (new cljs.core.PersistentVector(null,4,(5),inst_32369,inst_32370,null));
var inst_32372 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_32371], 0));
var state_32379__$1 = (function (){var statearr_32391 = state_32379;
(statearr_32391[(7)] = inst_32368);

return statearr_32391;
})();
var statearr_32392_32409 = state_32379__$1;
(statearr_32392_32409[(2)] = inst_32372);

(statearr_32392_32409[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32380 === (8))){
var inst_32374 = (state_32379[(2)]);
var _ = (function (){var statearr_32393 = state_32379;
(statearr_32393[(4)] = cljs.core.rest((state_32379[(4)])));

return statearr_32393;
})();
var state_32379__$1 = state_32379;
var statearr_32394_32410 = state_32379__$1;
(statearr_32394_32410[(2)] = inst_32374);

(statearr_32394_32410[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__13883__auto__ = null;
var fluree$db$operations$state_machine__13883__auto____0 = (function (){
var statearr_32395 = [null,null,null,null,null,null,null,null];
(statearr_32395[(0)] = fluree$db$operations$state_machine__13883__auto__);

(statearr_32395[(1)] = (1));

return statearr_32395;
});
var fluree$db$operations$state_machine__13883__auto____1 = (function (state_32379){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_32379);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e32396){var ex__13886__auto__ = e32396;
var statearr_32397_32411 = state_32379;
(statearr_32397_32411[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_32379[(4)]))){
var statearr_32398_32412 = state_32379;
(statearr_32398_32412[(1)] = cljs.core.first((state_32379[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__32413 = state_32379;
state_32379 = G__32413;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$operations$state_machine__13883__auto__ = function(state_32379){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__13883__auto____1.call(this,state_32379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__13883__auto____0;
fluree$db$operations$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__13883__auto____1;
return fluree$db$operations$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_32399 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_32399[(6)] = c__13957__auto___32401);

return statearr_32399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__32415 = arguments.length;
switch (G__32415) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__32416){
var map__32417 = p__32416;
var map__32417__$1 = cljs.core.__destructure_map(map__32417);
var opts = map__32417__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32417__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__32418 = session;
var map__32418__$1 = cljs.core.__destructure_map(map__32418);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32418__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32418__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32418__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_db,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4777__auto__ = [];
var len__4771__auto___32445 = arguments.length;
var i__4772__auto___32446 = (0);
while(true){
if((i__4772__auto___32446 < len__4771__auto___32445)){
args__4777__auto__.push((arguments[i__4772__auto___32446]));

var G__32447 = (i__4772__auto___32446 + (1));
i__4772__auto___32446 = G__32447;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__32422){
var vec__32423 = p__32422;
var map__32426 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32423,(0),null);
var map__32426__$1 = cljs.core.__destructure_map(map__32426);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32426__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32426__$1,cljs.core.cst$kw$toTime);
var opts = vec__32423;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_32438){
var state_val_32439 = (state_32438[(1)]);
if((state_val_32439 === (1))){
var inst_32428 = session;
var inst_32429 = cljs.core.__destructure_map(inst_32428);
var inst_32430 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32429,cljs.core.cst$kw$network);
var inst_32431 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32429,cljs.core.cst$kw$dbid);
var inst_32432 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32429,cljs.core.cst$kw$conn);
var inst_32433 = [cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_32434 = [inst_32430,inst_32431,toBlock,toTime];
var inst_32435 = cljs.core.PersistentHashMap.fromArrays(inst_32433,inst_32434);
var inst_32436 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_32432,cljs.core.cst$kw$garbage,inst_32435);
var state_32438__$1 = state_32438;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32438__$1,inst_32436);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__13883__auto__ = null;
var fluree$db$operations$state_machine__13883__auto____0 = (function (){
var statearr_32440 = [null,null,null,null,null,null,null];
(statearr_32440[(0)] = fluree$db$operations$state_machine__13883__auto__);

(statearr_32440[(1)] = (1));

return statearr_32440;
});
var fluree$db$operations$state_machine__13883__auto____1 = (function (state_32438){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_32438);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e32441){var ex__13886__auto__ = e32441;
var statearr_32442_32448 = state_32438;
(statearr_32442_32448[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_32438[(4)]))){
var statearr_32443_32449 = state_32438;
(statearr_32443_32449[(1)] = cljs.core.first((state_32438[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__32450 = state_32438;
state_32438 = G__32450;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$operations$state_machine__13883__auto__ = function(state_32438){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__13883__auto____1.call(this,state_32438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__13883__auto____0;
fluree$db$operations$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__13883__auto____1;
return fluree$db$operations$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_32444 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_32444[(6)] = c__13957__auto__);

return statearr_32444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq32420){
var G__32421 = cljs.core.first(seq32420);
var seq32420__$1 = cljs.core.next(seq32420);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32421,seq32420__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__32451 = session;
var map__32451__$1 = cljs.core.__destructure_map(map__32451);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32451__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32451__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32451__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$db_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__32453 = arguments.length;
switch (G__32453) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__32454 = opts;
var map__32454__$1 = cljs.core.__destructure_map(map__32454);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32454__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32454__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4160__auto__ = auth;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});
