// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e33322){var e = e33322;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__33323_SHARP_){
var or__4160__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__33323_SHARP_);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__33323_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__33323_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__33323_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (cljs.core.not(key_as_var)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33324_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33324_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33325_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33325_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4149__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4149__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4160__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__33330 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33330,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33330,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33326_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33326_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1)))?cljs.core.re_find(/\+/,key):false))){
var vec__33333 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33333,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33333,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4160__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33327_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33327_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33328_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33328_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33329_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33329_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33336_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__33336_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4160__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4149__auto__ = max_fuel;
if(cljs.core.truth_(and__4149__auto__)){
return (add_amount > max_fuel);
} else {
return and__4149__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4149__auto__ = fuel;
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4149__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__33337 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__33337) : intersecting_vars.call(null,G__33337));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__33340,optional_QMARK_,fuel,max_fuel){
var map__33341 = p__33340;
var map__33341__$1 = cljs.core.__destructure_map(map__33341);
var res = map__33341__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33341__$1,cljs.core.cst$kw$vars);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_33407){
var state_val_33408 = (state_33407[(1)]);
if((state_val_33408 === (7))){
var inst_33396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33397 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_33398 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33397,clause);
var inst_33399 = [null,inst_33398];
var inst_33400 = (new cljs.core.PersistentVector(null,2,(5),inst_33396,inst_33399,null));
var state_33407__$1 = state_33407;
var statearr_33409_33437 = state_33407__$1;
(statearr_33409_33437[(2)] = inst_33400);

(statearr_33409_33437[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33408 === (1))){
var state_33407__$1 = state_33407;
var statearr_33410_33438 = state_33407__$1;
(statearr_33410_33438[(2)] = null);

(statearr_33410_33438[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33408 === (4))){
var inst_33342 = (state_33407[(2)]);
var state_33407__$1 = state_33407;
var statearr_33411_33439 = state_33407__$1;
(statearr_33411_33439[(2)] = inst_33342);

(statearr_33411_33439[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33408 === (15))){
var inst_33385 = (state_33407[(2)]);
var inst_33386 = fluree.db.util.async.throw_err(inst_33385);
var inst_33387 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_33386);
var inst_33388 = cljs.core.count(inst_33387);
var inst_33389 = fluree.db.query.analytical.add_fuel(inst_33388,fuel,max_fuel);
var inst_33390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33391 = [inst_33386,r];
var inst_33392 = (new cljs.core.PersistentVector(null,2,(5),inst_33390,inst_33391,null));
var state_33407__$1 = (function (){var statearr_33412 = state_33407;
(statearr_33412[(7)] = inst_33389);

return statearr_33412;
})();
var statearr_33413_33440 = state_33407__$1;
(statearr_33413_33440[(2)] = inst_33392);

(statearr_33413_33440[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33408 === (13))){
var inst_33351 = (state_33407[(8)]);
var inst_33364 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_33365 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_33364);
var inst_33366 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_33351);
var inst_33367 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_33366);
var inst_33368 = cljs.core.set(inst_33367);
var inst_33369 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_33365);
var inst_33370 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_33369);
var inst_33371 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33368,inst_33370);
var inst_33372 = (function (){var all_wd = inst_33351;
var optional = inst_33365;
var all_wd_vars = inst_33368;
var all_vars = inst_33371;
return (function (p1__33338_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__33338_SHARP_) : all_vars.call(null,p1__33338_SHARP_));
});
})();
var inst_33373 = cljs.core.keys(vars);
var inst_33374 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33372,inst_33373);
var inst_33375 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_33374);
var inst_33376 = cljs.core.set(inst_33375);
var inst_33377 = (function (){var all_wd = inst_33351;
var optional = inst_33365;
var all_wd_vars = inst_33368;
var all_vars = inst_33371;
var intersecting_vars = inst_33376;
return (function (p1__33339_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__33339_SHARP_);
});
})();
var inst_33378 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33377,inst_33351);
var inst_33379 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_33378);
var inst_33380 = fluree.db.query.analytical.select_from_tuples(inst_33379,res);
var inst_33381 = fluree.db.query.analytical.replace_vars_wikidata(inst_33351,inst_33376,vars);
var inst_33382 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_33376,inst_33371);
var inst_33383 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_33381,inst_33379,inst_33380,inst_33382,inst_33365);
var state_33407__$1 = state_33407;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33407__$1,(15),inst_33383);
} else {
if((state_val_33408 === (6))){
var inst_33352 = (state_33407[(9)]);
var inst_33350 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_33351 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_33350);
var inst_33352__$1 = optional_QMARK_;
var state_33407__$1 = (function (){var statearr_33414 = state_33407;
(statearr_33414[(8)] = inst_33351);

(statearr_33414[(9)] = inst_33352__$1);

return statearr_33414;
})();
if(cljs.core.truth_(inst_33352__$1)){
var statearr_33415_33441 = state_33407__$1;
(statearr_33415_33441[(1)] = (9));

} else {
var statearr_33416_33442 = state_33407__$1;
(statearr_33416_33442[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33408 === (3))){
var inst_33405 = (state_33407[(2)]);
var state_33407__$1 = state_33407;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33407__$1,inst_33405);
} else {
if((state_val_33408 === (12))){
var inst_33360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33361 = [null,r];
var inst_33362 = (new cljs.core.PersistentVector(null,2,(5),inst_33360,inst_33361,null));
var state_33407__$1 = state_33407;
var statearr_33417_33443 = state_33407__$1;
(statearr_33417_33443[(2)] = inst_33362);

(statearr_33417_33443[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33408 === (2))){
var _ = (function (){var statearr_33418 = state_33407;
(statearr_33418[(4)] = cljs.core.cons((5),(state_33407[(4)])));

return statearr_33418;
})();
var inst_33348 = (r == null);
var state_33407__$1 = state_33407;
if(cljs.core.truth_(inst_33348)){
var statearr_33419_33444 = state_33407__$1;
(statearr_33419_33444[(1)] = (6));

} else {
var statearr_33420_33445 = state_33407__$1;
(statearr_33420_33445[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33408 === (11))){
var inst_33358 = (state_33407[(2)]);
var state_33407__$1 = state_33407;
if(cljs.core.truth_(inst_33358)){
var statearr_33422_33446 = state_33407__$1;
(statearr_33422_33446[(1)] = (12));

} else {
var statearr_33423_33447 = state_33407__$1;
(statearr_33423_33447[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33408 === (9))){
var inst_33351 = (state_33407[(8)]);
var inst_33354 = cljs.core.empty_QMARK_(inst_33351);
var inst_33355 = (!(inst_33354));
var state_33407__$1 = state_33407;
var statearr_33424_33448 = state_33407__$1;
(statearr_33424_33448[(2)] = inst_33355);

(statearr_33424_33448[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33408 === (5))){
var _ = (function (){var statearr_33425 = state_33407;
(statearr_33425[(4)] = cljs.core.rest((state_33407[(4)])));

return statearr_33425;
})();
var state_33407__$1 = state_33407;
var ex33421 = (state_33407__$1[(2)]);
var statearr_33426_33449 = state_33407__$1;
(statearr_33426_33449[(5)] = ex33421);


if((ex33421 instanceof Error)){
var statearr_33427_33450 = state_33407__$1;
(statearr_33427_33450[(1)] = (4));

(statearr_33427_33450[(5)] = null);

} else {
throw ex33421;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33408 === (14))){
var inst_33394 = (state_33407[(2)]);
var state_33407__$1 = state_33407;
var statearr_33428_33451 = state_33407__$1;
(statearr_33428_33451[(2)] = inst_33394);

(statearr_33428_33451[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33408 === (10))){
var inst_33352 = (state_33407[(9)]);
var state_33407__$1 = state_33407;
var statearr_33429_33452 = state_33407__$1;
(statearr_33429_33452[(2)] = inst_33352);

(statearr_33429_33452[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33408 === (8))){
var inst_33402 = (state_33407[(2)]);
var _ = (function (){var statearr_33430 = state_33407;
(statearr_33430[(4)] = cljs.core.rest((state_33407[(4)])));

return statearr_33430;
})();
var state_33407__$1 = state_33407;
var statearr_33431_33453 = state_33407__$1;
(statearr_33431_33453[(2)] = inst_33402);

(statearr_33431_33453[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto____0 = (function (){
var statearr_33432 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33432[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto__);

(statearr_33432[(1)] = (1));

return statearr_33432;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto____1 = (function (state_33407){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_33407);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e33433){var ex__13886__auto__ = e33433;
var statearr_33434_33454 = state_33407;
(statearr_33434_33454[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_33407[(4)]))){
var statearr_33435_33455 = state_33407;
(statearr_33435_33455[(1)] = cljs.core.first((state_33407[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__33456 = state_33407;
state_33407 = G__33456;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto__ = function(state_33407){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto____1.call(this,state_33407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_33436 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_33436[(6)] = c__13957__auto__);

return statearr_33436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__33458 = arguments.length;
switch (G__33458) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_33552){
var state_val_33553 = (state_33552[(1)]);
if((state_val_33553 === (7))){
var inst_33465 = (state_33552[(7)]);
var inst_33475 = clojure.string.starts_with_QMARK_(inst_33465,"$fdb");
var state_33552__$1 = state_33552;
if(inst_33475){
var statearr_33554_33603 = state_33552__$1;
(statearr_33554_33603[(1)] = (9));

} else {
var statearr_33555_33604 = state_33552__$1;
(statearr_33555_33604[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (20))){
var state_33552__$1 = state_33552;
var statearr_33556_33605 = state_33552__$1;
(statearr_33556_33605[(2)] = null);

(statearr_33556_33605[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (27))){
var inst_33515 = (state_33552[(8)]);
var state_33552__$1 = state_33552;
var statearr_33557_33606 = state_33552__$1;
(statearr_33557_33606[(2)] = inst_33515);

(statearr_33557_33606[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (1))){
var state_33552__$1 = state_33552;
var statearr_33558_33607 = state_33552__$1;
(statearr_33558_33607[(2)] = null);

(statearr_33558_33607[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (24))){
var inst_33538 = (state_33552[(2)]);
var state_33552__$1 = state_33552;
var statearr_33559_33608 = state_33552__$1;
(statearr_33559_33608[(2)] = inst_33538);

(statearr_33559_33608[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (4))){
var inst_33459 = (state_33552[(2)]);
var state_33552__$1 = state_33552;
var statearr_33560_33609 = state_33552__$1;
(statearr_33560_33609[(2)] = inst_33459);

(statearr_33560_33609[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (15))){
var inst_33482 = (state_33552[(9)]);
var inst_33488 = (state_33552[(2)]);
var inst_33489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33490 = cljs.core.PersistentVector.EMPTY;
var inst_33491 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_33492 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33490,inst_33491);
var inst_33493 = [inst_33482,inst_33492];
var inst_33494 = (new cljs.core.PersistentVector(null,2,(5),inst_33489,inst_33493,null));
var state_33552__$1 = (function (){var statearr_33561 = state_33552;
(statearr_33561[(10)] = inst_33488);

return statearr_33561;
})();
var statearr_33562_33610 = state_33552__$1;
(statearr_33562_33610[(2)] = inst_33494);

(statearr_33562_33610[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (21))){
var inst_33541 = (state_33552[(2)]);
var state_33552__$1 = state_33552;
var statearr_33563_33611 = state_33552__$1;
(statearr_33563_33611[(2)] = inst_33541);

(statearr_33563_33611[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (13))){
var inst_33482 = (state_33552[(9)]);
var inst_33485 = (function(){throw inst_33482})();
var state_33552__$1 = state_33552;
var statearr_33564_33612 = state_33552__$1;
(statearr_33564_33612[(2)] = inst_33485);

(statearr_33564_33612[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (22))){
var inst_33506 = (state_33552[(11)]);
var inst_33504 = (state_33552[(12)]);
var inst_33508 = fluree.db.query.analytical.parse_block_from_source(inst_33504);
var inst_33509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33510 = [cljs.core.cst$kw$sources,inst_33506];
var inst_33511 = (new cljs.core.PersistentVector(null,2,(5),inst_33509,inst_33510,null));
var inst_33512 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_33511);
var state_33552__$1 = (function (){var statearr_33565 = state_33552;
(statearr_33565[(13)] = inst_33508);

return statearr_33565;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33552__$1,(25),inst_33512);
} else {
if((state_val_33553 === (29))){
var inst_33519 = (state_33552[(2)]);
var inst_33520 = fluree.db.util.async.throw_err(inst_33519);
var state_33552__$1 = state_33552;
var statearr_33566_33613 = state_33552__$1;
(statearr_33566_33613[(2)] = inst_33520);

(statearr_33566_33613[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (6))){
var inst_33468 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33469 = cljs.core.PersistentVector.EMPTY;
var inst_33470 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_33471 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33469,inst_33470);
var inst_33472 = [db,inst_33471];
var inst_33473 = (new cljs.core.PersistentVector(null,2,(5),inst_33468,inst_33472,null));
var state_33552__$1 = state_33552;
var statearr_33567_33614 = state_33552__$1;
(statearr_33567_33614[(2)] = inst_33473);

(statearr_33567_33614[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (28))){
var inst_33523 = (state_33552[(2)]);
var inst_33524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33525 = cljs.core.PersistentVector.EMPTY;
var inst_33526 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_33527 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33525,inst_33526);
var inst_33528 = [inst_33523,inst_33527];
var inst_33529 = (new cljs.core.PersistentVector(null,2,(5),inst_33524,inst_33528,null));
var state_33552__$1 = state_33552;
var statearr_33568_33615 = state_33552__$1;
(statearr_33568_33615[(2)] = inst_33529);

(statearr_33568_33615[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (25))){
var inst_33508 = (state_33552[(13)]);
var inst_33514 = (state_33552[(2)]);
var inst_33515 = fluree.db.util.async.throw_err(inst_33514);
var state_33552__$1 = (function (){var statearr_33569 = state_33552;
(statearr_33569[(8)] = inst_33515);

return statearr_33569;
})();
if(cljs.core.truth_(inst_33508)){
var statearr_33570_33616 = state_33552__$1;
(statearr_33570_33616[(1)] = (26));

} else {
var statearr_33571_33617 = state_33552__$1;
(statearr_33571_33617[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (17))){
var state_33552__$1 = state_33552;
var statearr_33572_33618 = state_33552__$1;
(statearr_33572_33618[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (3))){
var inst_33550 = (state_33552[(2)]);
var state_33552__$1 = state_33552;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33552__$1,inst_33550);
} else {
if((state_val_33553 === (12))){
var inst_33482 = (state_33552[(9)]);
var inst_33481 = (state_33552[(2)]);
var inst_33482__$1 = fluree.db.util.async.throw_err(inst_33481);
var inst_33483 = fluree.db.util.core.exception_QMARK_(inst_33482__$1);
var state_33552__$1 = (function (){var statearr_33574 = state_33552;
(statearr_33574[(9)] = inst_33482__$1);

return statearr_33574;
})();
if(inst_33483){
var statearr_33575_33619 = state_33552__$1;
(statearr_33575_33619[(1)] = (13));

} else {
var statearr_33576_33620 = state_33552__$1;
(statearr_33576_33620[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (2))){
var inst_33465 = (state_33552[(7)]);
var _ = (function (){var statearr_33577 = state_33552;
(statearr_33577[(4)] = cljs.core.cons((5),(state_33552[(4)])));

return statearr_33577;
})();
var inst_33465__$1 = cljs.core.first(clause);
var inst_33466 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_33465__$1);
var state_33552__$1 = (function (){var statearr_33578 = state_33552;
(statearr_33578[(7)] = inst_33465__$1);

return statearr_33578;
})();
if(inst_33466){
var statearr_33579_33621 = state_33552__$1;
(statearr_33579_33621[(1)] = (6));

} else {
var statearr_33580_33622 = state_33552__$1;
(statearr_33580_33622[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (23))){
var inst_33465 = (state_33552[(7)]);
var inst_33531 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33465)," is not supported in Fluree"].join('');
var inst_33532 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33533 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_33534 = cljs.core.PersistentHashMap.fromArrays(inst_33532,inst_33533);
var inst_33535 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33531,inst_33534);
var inst_33536 = (function(){throw inst_33535})();
var state_33552__$1 = state_33552;
var statearr_33581_33623 = state_33552__$1;
(statearr_33581_33623[(2)] = inst_33536);

(statearr_33581_33623[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (19))){
var inst_33506 = (state_33552[(11)]);
var inst_33465 = (state_33552[(7)]);
var inst_33503 = fluree.db.query.analytical.isolate_source_name(inst_33465);
var inst_33504 = fluree.db.query.analytical.isolate_source_block(inst_33465);
var inst_33505 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_33503);
var inst_33506__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_33505);
var state_33552__$1 = (function (){var statearr_33582 = state_33552;
(statearr_33582[(11)] = inst_33506__$1);

(statearr_33582[(12)] = inst_33504);

return statearr_33582;
})();
if(cljs.core.truth_(inst_33506__$1)){
var statearr_33583_33624 = state_33552__$1;
(statearr_33583_33624[(1)] = (22));

} else {
var statearr_33584_33625 = state_33552__$1;
(statearr_33584_33625[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (11))){
var inst_33545 = (state_33552[(2)]);
var state_33552__$1 = state_33552;
var statearr_33586_33626 = state_33552__$1;
(statearr_33586_33626[(2)] = inst_33545);

(statearr_33586_33626[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (9))){
var inst_33465 = (state_33552[(7)]);
var inst_33477 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_33465,(4));
var inst_33478 = fluree.db.query.analytical.parse_block_from_source(inst_33477);
var inst_33479 = fluree.db.time_travel.as_of_block(db,inst_33478);
var state_33552__$1 = state_33552;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33552__$1,(12),inst_33479);
} else {
if((state_val_33553 === (5))){
var _ = (function (){var statearr_33587 = state_33552;
(statearr_33587[(4)] = cljs.core.rest((state_33552[(4)])));

return statearr_33587;
})();
var state_33552__$1 = state_33552;
var ex33585 = (state_33552__$1[(2)]);
var statearr_33588_33627 = state_33552__$1;
(statearr_33588_33627[(5)] = ex33585);


if((ex33585 instanceof Error)){
var statearr_33589_33628 = state_33552__$1;
(statearr_33589_33628[(1)] = (4));

(statearr_33589_33628[(5)] = null);

} else {
throw ex33585;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (14))){
var state_33552__$1 = state_33552;
var statearr_33590_33629 = state_33552__$1;
(statearr_33590_33629[(2)] = null);

(statearr_33590_33629[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (26))){
var inst_33508 = (state_33552[(13)]);
var inst_33515 = (state_33552[(8)]);
var inst_33517 = fluree.db.time_travel.as_of_block(inst_33515,inst_33508);
var state_33552__$1 = state_33552;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33552__$1,(29),inst_33517);
} else {
if((state_val_33553 === (16))){
var inst_33498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33499 = ["$wd",clause];
var inst_33500 = (new cljs.core.PersistentVector(null,2,(5),inst_33498,inst_33499,null));
var state_33552__$1 = state_33552;
var statearr_33591_33630 = state_33552__$1;
(statearr_33591_33630[(2)] = inst_33500);

(statearr_33591_33630[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (10))){
var inst_33465 = (state_33552[(7)]);
var inst_33496 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_33465);
var state_33552__$1 = state_33552;
if(inst_33496){
var statearr_33592_33631 = state_33552__$1;
(statearr_33592_33631[(1)] = (16));

} else {
var statearr_33593_33632 = state_33552__$1;
(statearr_33593_33632[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (18))){
var inst_33543 = (state_33552[(2)]);
var state_33552__$1 = state_33552;
var statearr_33594_33633 = state_33552__$1;
(statearr_33594_33633[(2)] = inst_33543);

(statearr_33594_33633[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33553 === (8))){
var inst_33547 = (state_33552[(2)]);
var _ = (function (){var statearr_33595 = state_33552;
(statearr_33595[(4)] = cljs.core.rest((state_33552[(4)])));

return statearr_33595;
})();
var state_33552__$1 = state_33552;
var statearr_33596_33634 = state_33552__$1;
(statearr_33596_33634[(2)] = inst_33547);

(statearr_33596_33634[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__13883__auto__ = null;
var fluree$db$query$analytical$state_machine__13883__auto____0 = (function (){
var statearr_33597 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33597[(0)] = fluree$db$query$analytical$state_machine__13883__auto__);

(statearr_33597[(1)] = (1));

return statearr_33597;
});
var fluree$db$query$analytical$state_machine__13883__auto____1 = (function (state_33552){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_33552);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e33598){var ex__13886__auto__ = e33598;
var statearr_33599_33635 = state_33552;
(statearr_33599_33635[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_33552[(4)]))){
var statearr_33600_33636 = state_33552;
(statearr_33600_33636[(1)] = cljs.core.first((state_33552[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__33637 = state_33552;
state_33552 = G__33637;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__13883__auto__ = function(state_33552){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__13883__auto____1.call(this,state_33552);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__13883__auto____0;
fluree$db$query$analytical$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__13883__auto____1;
return fluree$db$query$analytical$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_33601 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_33601[(6)] = c__13957__auto__);

return statearr_33601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__33638){
var vec__33639 = p__33638;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33639,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33639,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33642_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__33642_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__33646 = subjects;
var vec__33647 = G__33646;
var seq__33648 = cljs.core.seq(vec__33647);
var first__33649 = cljs.core.first(seq__33648);
var seq__33648__$1 = cljs.core.next(seq__33648);
var subject = first__33649;
var r = seq__33648__$1;
var acc = expanded_map;
var G__33646__$1 = G__33646;
var acc__$1 = acc;
while(true){
var vec__33653 = G__33646__$1;
var seq__33654 = cljs.core.seq(vec__33653);
var first__33655 = cljs.core.first(seq__33654);
var seq__33654__$1 = cljs.core.next(seq__33654);
var subject__$1 = first__33655;
var r__$1 = seq__33654__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__33656 = r__$1;
var G__33657 = acc__$2;
G__33646__$1 = G__33656;
acc__$1 = G__33657;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__33646__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__33653,seq__33654,first__33655,seq__33654__$1,subject__$1,r__$1,acc__$2,G__33646,vec__33647,seq__33648,first__33649,seq__33648__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4160__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__33646__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__33653,seq__33654,first__33655,seq__33654__$1,subject__$1,r__$1,acc__$2,G__33646,vec__33647,seq__33648,first__33649,seq__33648__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__33646__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__33653,seq__33654,first__33655,seq__33654__$1,subject__$1,r__$1,acc__$2,G__33646,vec__33647,seq__33648,first__33649,seq__33648__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__33646__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__33653,seq__33654,first__33655,seq__33654__$1,subject__$1,r__$1,acc__$2,G__33646,vec__33647,seq__33648,first__33649,seq__33648__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__33646__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__33653,seq__33654,first__33655,seq__33654__$1,subject__$1,r__$1,acc__$2,G__33646,vec__33647,seq__33648,first__33649,seq__33648__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__33646__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__33653,seq__33654,first__33655,seq__33654__$1,subject__$1,r__$1,acc__$2,G__33646,vec__33647,seq__33648,first__33649,seq__33648__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__33658 = r__$1;
var G__33659 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__33646__$1 = G__33658;
acc__$1 = G__33659;
continue;
} else {
var G__33660 = subjects;
var G__33661 = acc_STAR_;
G__33646__$1 = G__33660;
acc__$1 = G__33661;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33662_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__33662_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_33753){
var state_val_33754 = (state_33753[(1)]);
if((state_val_33754 === (7))){
var state_33753__$1 = state_33753;
var statearr_33755_33801 = state_33753__$1;
(statearr_33755_33801[(2)] = (100));

(statearr_33755_33801[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (20))){
var inst_33702 = (state_33753[(7)]);
var state_33753__$1 = state_33753;
var statearr_33756_33802 = state_33753__$1;
(statearr_33756_33802[(2)] = inst_33702);

(statearr_33756_33802[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (1))){
var state_33753__$1 = state_33753;
var statearr_33757_33803 = state_33753__$1;
(statearr_33757_33803[(2)] = null);

(statearr_33757_33803[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (24))){
var inst_33674 = (state_33753[(8)]);
var inst_33739 = (state_33753[(9)]);
var inst_33741 = (state_33753[(10)]);
var inst_33740 = (state_33753[(11)]);
var inst_33744 = (function (){var max_depth = inst_33674;
var recur_map__$1 = inst_33740;
var subjects = inst_33739;
var tuples = inst_33741;
return (function (p1__33663_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__33663_SHARP_)],null));
});
})();
var inst_33745 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33744,inst_33741);
var inst_33746 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_33745);
var state_33753__$1 = state_33753;
var statearr_33758_33804 = state_33753__$1;
(statearr_33758_33804[(2)] = inst_33746);

(statearr_33758_33804[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (4))){
var inst_33664 = (state_33753[(2)]);
var state_33753__$1 = state_33753;
var statearr_33759_33805 = state_33753__$1;
(statearr_33759_33805[(2)] = inst_33664);

(statearr_33759_33805[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (15))){
var inst_33687 = (state_33753[(12)]);
var inst_33698 = cljs.core.PersistentVector.EMPTY;
var inst_33699 = cljs.core.seq(inst_33687);
var inst_33700 = cljs.core.first(inst_33699);
var inst_33701 = cljs.core.next(inst_33699);
var inst_33702 = inst_33698;
var inst_33703 = inst_33687;
var state_33753__$1 = (function (){var statearr_33760 = state_33753;
(statearr_33760[(13)] = inst_33700);

(statearr_33760[(14)] = inst_33701);

(statearr_33760[(7)] = inst_33702);

(statearr_33760[(15)] = inst_33703);

return statearr_33760;
})();
var statearr_33761_33806 = state_33753__$1;
(statearr_33761_33806[(2)] = null);

(statearr_33761_33806[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (21))){
var inst_33723 = (state_33753[(2)]);
var state_33753__$1 = state_33753;
var statearr_33762_33807 = state_33753__$1;
(statearr_33762_33807[(2)] = inst_33723);

(statearr_33762_33807[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (13))){
var inst_33736 = (state_33753[(2)]);
var state_33753__$1 = state_33753;
var statearr_33763_33808 = state_33753__$1;
(statearr_33763_33808[(2)] = inst_33736);

(statearr_33763_33808[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (22))){
var inst_33710 = (state_33753[(16)]);
var inst_33702 = (state_33753[(7)]);
var inst_33717 = (state_33753[(2)]);
var inst_33718 = fluree.db.util.async.throw_err(inst_33717);
var inst_33719 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_33702,inst_33718);
var inst_33702__$1 = inst_33719;
var inst_33703 = inst_33710;
var state_33753__$1 = (function (){var statearr_33764 = state_33753;
(statearr_33764[(7)] = inst_33702__$1);

(statearr_33764[(15)] = inst_33703);

return statearr_33764;
})();
var statearr_33765_33809 = state_33753__$1;
(statearr_33765_33809[(2)] = null);

(statearr_33765_33809[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (6))){
var inst_33670 = (state_33753[(17)]);
var state_33753__$1 = state_33753;
var statearr_33766_33810 = state_33753__$1;
(statearr_33766_33810[(2)] = inst_33670);

(statearr_33766_33810[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (25))){
var inst_33748 = (state_33753[(2)]);
var _ = (function (){var statearr_33767 = state_33753;
(statearr_33767[(4)] = cljs.core.rest((state_33753[(4)])));

return statearr_33767;
})();
var state_33753__$1 = state_33753;
var statearr_33768_33811 = state_33753__$1;
(statearr_33768_33811[(2)] = inst_33748);

(statearr_33768_33811[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (17))){
var inst_33709 = (state_33753[(18)]);
var inst_33703 = (state_33753[(15)]);
var inst_33708 = cljs.core.seq(inst_33703);
var inst_33709__$1 = cljs.core.first(inst_33708);
var inst_33710 = cljs.core.next(inst_33708);
var state_33753__$1 = (function (){var statearr_33769 = state_33753;
(statearr_33769[(18)] = inst_33709__$1);

(statearr_33769[(16)] = inst_33710);

return statearr_33769;
})();
if(cljs.core.truth_(inst_33709__$1)){
var statearr_33770_33812 = state_33753__$1;
(statearr_33770_33812[(1)] = (19));

} else {
var statearr_33771_33813 = state_33753__$1;
(statearr_33771_33813[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (3))){
var inst_33751 = (state_33753[(2)]);
var state_33753__$1 = state_33753;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33753__$1,inst_33751);
} else {
if((state_val_33754 === (12))){
var inst_33687 = (state_33753[(12)]);
var inst_33676 = (state_33753[(19)]);
var inst_33682 = cljs.core.vals(inst_33676);
var inst_33683 = cljs.core.flatten(inst_33682);
var inst_33684 = cljs.core.set(inst_33683);
var inst_33685 = cljs.core.keys(inst_33676);
var inst_33686 = cljs.core.set(inst_33685);
var inst_33687__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_33684,inst_33686);
var inst_33688 = cljs.core.empty_QMARK_(inst_33687__$1);
var state_33753__$1 = (function (){var statearr_33772 = state_33753;
(statearr_33772[(12)] = inst_33687__$1);

return statearr_33772;
})();
if(inst_33688){
var statearr_33773_33814 = state_33753__$1;
(statearr_33773_33814[(1)] = (14));

} else {
var statearr_33774_33815 = state_33753__$1;
(statearr_33774_33815[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (2))){
var inst_33670 = (state_33753[(17)]);
var _ = (function (){var statearr_33775 = state_33753;
(statearr_33775[(4)] = cljs.core.cons((5),(state_33753[(4)])));

return statearr_33775;
})();
var inst_33670__$1 = depth;
var state_33753__$1 = (function (){var statearr_33776 = state_33753;
(statearr_33776[(17)] = inst_33670__$1);

return statearr_33776;
})();
if(cljs.core.truth_(inst_33670__$1)){
var statearr_33777_33816 = state_33753__$1;
(statearr_33777_33816[(1)] = (6));

} else {
var statearr_33778_33817 = state_33753__$1;
(statearr_33778_33817[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (23))){
var inst_33741 = (state_33753[(10)]);
var state_33753__$1 = state_33753;
var statearr_33779_33818 = state_33753__$1;
(statearr_33779_33818[(2)] = inst_33741);

(statearr_33779_33818[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (19))){
var inst_33709 = (state_33753[(18)]);
var inst_33712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33713 = [inst_33709,predicate];
var inst_33714 = (new cljs.core.PersistentVector(null,2,(5),inst_33712,inst_33713,null));
var inst_33715 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_33714);
var state_33753__$1 = state_33753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33753__$1,(22),inst_33715);
} else {
if((state_val_33754 === (11))){
var inst_33676 = (state_33753[(19)]);
var state_33753__$1 = state_33753;
var statearr_33781_33819 = state_33753__$1;
(statearr_33781_33819[(2)] = inst_33676);

(statearr_33781_33819[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (9))){
var inst_33674 = (state_33753[(8)]);
var inst_33677 = (state_33753[(20)]);
var inst_33679 = (inst_33677 >= inst_33674);
var state_33753__$1 = state_33753;
if(cljs.core.truth_(inst_33679)){
var statearr_33782_33820 = state_33753__$1;
(statearr_33782_33820[(1)] = (11));

} else {
var statearr_33783_33821 = state_33753__$1;
(statearr_33783_33821[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (5))){
var _ = (function (){var statearr_33784 = state_33753;
(statearr_33784[(4)] = cljs.core.rest((state_33753[(4)])));

return statearr_33784;
})();
var state_33753__$1 = state_33753;
var ex33780 = (state_33753__$1[(2)]);
var statearr_33785_33822 = state_33753__$1;
(statearr_33785_33822[(5)] = ex33780);


if((ex33780 instanceof Error)){
var statearr_33786_33823 = state_33753__$1;
(statearr_33786_33823[(1)] = (4));

(statearr_33786_33823[(5)] = null);

} else {
throw ex33780;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (14))){
var inst_33676 = (state_33753[(19)]);
var state_33753__$1 = state_33753;
var statearr_33787_33824 = state_33753__$1;
(statearr_33787_33824[(2)] = inst_33676);

(statearr_33787_33824[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (16))){
var inst_33734 = (state_33753[(2)]);
var state_33753__$1 = state_33753;
var statearr_33788_33825 = state_33753__$1;
(statearr_33788_33825[(2)] = inst_33734);

(statearr_33788_33825[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (10))){
var inst_33739 = (state_33753[(9)]);
var inst_33740 = (state_33753[(11)]);
var inst_33738 = (state_33753[(2)]);
var inst_33739__$1 = cljs.core.keys(inst_33738);
var inst_33740__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_33739__$1,inst_33738);
var inst_33741 = fluree.db.query.analytical.recur_map__GT_tuples(inst_33739__$1,inst_33740__$1);
var state_33753__$1 = (function (){var statearr_33789 = state_33753;
(statearr_33789[(9)] = inst_33739__$1);

(statearr_33789[(10)] = inst_33741);

(statearr_33789[(11)] = inst_33740__$1);

return statearr_33789;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_33790_33826 = state_33753__$1;
(statearr_33790_33826[(1)] = (23));

} else {
var statearr_33791_33827 = state_33753__$1;
(statearr_33791_33827[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (18))){
var inst_33676 = (state_33753[(19)]);
var inst_33677 = (state_33753[(20)]);
var inst_33725 = (state_33753[(2)]);
var inst_33726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33727 = [(0),(2)];
var inst_33728 = (new cljs.core.PersistentVector(null,2,(5),inst_33726,inst_33727,null));
var inst_33729 = fluree.db.query.analytical.get_ns_arrays(inst_33728,inst_33725);
var inst_33730 = fluree.db.query.analytical.tuples__GT_map(inst_33676,inst_33729);
var inst_33731 = (inst_33677 + (1));
var inst_33676__$1 = inst_33730;
var inst_33677__$1 = inst_33731;
var state_33753__$1 = (function (){var statearr_33792 = state_33753;
(statearr_33792[(19)] = inst_33676__$1);

(statearr_33792[(20)] = inst_33677__$1);

return statearr_33792;
})();
var statearr_33793_33828 = state_33753__$1;
(statearr_33793_33828[(2)] = null);

(statearr_33793_33828[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33754 === (8))){
var inst_33674 = (state_33753[(2)]);
var inst_33675 = recur_map;
var inst_33676 = inst_33675;
var inst_33677 = (1);
var state_33753__$1 = (function (){var statearr_33794 = state_33753;
(statearr_33794[(19)] = inst_33676);

(statearr_33794[(8)] = inst_33674);

(statearr_33794[(20)] = inst_33677);

return statearr_33794;
})();
var statearr_33795_33829 = state_33753__$1;
(statearr_33795_33829[(2)] = null);

(statearr_33795_33829[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto____0 = (function (){
var statearr_33796 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33796[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto__);

(statearr_33796[(1)] = (1));

return statearr_33796;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto____1 = (function (state_33753){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_33753);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e33797){var ex__13886__auto__ = e33797;
var statearr_33798_33830 = state_33753;
(statearr_33798_33830[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_33753[(4)]))){
var statearr_33799_33831 = state_33753;
(statearr_33799_33831[(1)] = cljs.core.first((state_33753[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__33832 = state_33753;
state_33753 = G__33832;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto__ = function(state_33753){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto____1.call(this,state_33753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_33800 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_33800[(6)] = c__13957__auto__);

return statearr_33800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__33833,clause,fuel,max_fuel){
var map__33834 = p__33833;
var map__33834__$1 = cljs.core.__destructure_map(map__33834);
var res = map__33834__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33834__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33834__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33834__$1,cljs.core.cst$kw$vars);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_33945){
var state_val_33946 = (state_33945[(1)]);
if((state_val_33946 === (7))){
var inst_33851 = (state_33945[(7)]);
var state_33945__$1 = state_33945;
var statearr_33947_34000 = state_33945__$1;
(statearr_33947_34000[(2)] = inst_33851);

(statearr_33947_34000[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (20))){
var inst_33879 = (state_33945[(8)]);
var inst_33910 = typeof inst_33879 === 'number';
var state_33945__$1 = state_33945;
if(cljs.core.truth_(inst_33910)){
var statearr_33948_34001 = state_33945__$1;
(statearr_33948_34001[(1)] = (22));

} else {
var statearr_33949_34002 = state_33945__$1;
(statearr_33949_34002[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (27))){
var inst_33925 = (state_33945[(2)]);
var state_33945__$1 = state_33945;
var statearr_33950_34003 = state_33945__$1;
(statearr_33950_34003[(2)] = inst_33925);

(statearr_33950_34003[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (1))){
var state_33945__$1 = state_33945;
var statearr_33951_34004 = state_33945__$1;
(statearr_33951_34004[(2)] = null);

(statearr_33951_34004[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (24))){
var inst_33927 = (state_33945[(2)]);
var state_33945__$1 = state_33945;
var statearr_33952_34005 = state_33945__$1;
(statearr_33952_34005[(2)] = inst_33927);

(statearr_33952_34005[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (4))){
var inst_33835 = (state_33945[(2)]);
var state_33945__$1 = state_33945;
var statearr_33953_34006 = state_33945__$1;
(statearr_33953_34006[(2)] = inst_33835);

(statearr_33953_34006[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (15))){
var inst_33893 = (state_33945[(2)]);
var inst_33894 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_33895 = fluree.db.query.analytical.variable_QMARK_(inst_33894);
var state_33945__$1 = (function (){var statearr_33954 = state_33945;
(statearr_33954[(9)] = inst_33893);

return statearr_33954;
})();
if(cljs.core.truth_(inst_33895)){
var statearr_33955_34007 = state_33945__$1;
(statearr_33955_34007[(1)] = (16));

} else {
var statearr_33956_34008 = state_33945__$1;
(statearr_33956_34008[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (21))){
var inst_33881 = (state_33945[(10)]);
var inst_33882 = (state_33945[(11)]);
var inst_33852 = (state_33945[(12)]);
var inst_33929 = (state_33945[(2)]);
var inst_33930 = fluree.db.query.analytical.tuples__GT_recur(db,inst_33882,inst_33929,inst_33852,inst_33881);
var state_33945__$1 = state_33945;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33945__$1,(28),inst_33930);
} else {
if((state_val_33946 === (13))){
var inst_33861 = (state_33945[(13)]);
var inst_33885 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33861)].join('');
var inst_33886 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33887 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_33888 = cljs.core.PersistentHashMap.fromArrays(inst_33886,inst_33887);
var inst_33889 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33885,inst_33888);
var inst_33890 = (function(){throw inst_33889})();
var state_33945__$1 = state_33945;
var statearr_33957_34009 = state_33945__$1;
(statearr_33957_34009[(2)] = inst_33890);

(statearr_33957_34009[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (22))){
var inst_33877 = (state_33945[(14)]);
var inst_33879 = (state_33945[(8)]);
var inst_33912 = cljs.core.PersistentHashMap.EMPTY;
var inst_33913 = cljs.core.flatten(inst_33877);
var inst_33914 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33912,inst_33879,inst_33913);
var state_33945__$1 = state_33945;
var statearr_33958_34010 = state_33945__$1;
(statearr_33958_34010[(2)] = inst_33914);

(statearr_33958_34010[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (6))){
var inst_33863 = (state_33945[(15)]);
var state_33945__$1 = state_33945;
var statearr_33959_34011 = state_33945__$1;
(statearr_33959_34011[(2)] = inst_33863);

(statearr_33959_34011[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (28))){
var inst_33932 = (state_33945[(2)]);
var inst_33933 = fluree.db.util.async.throw_err(inst_33932);
var state_33945__$1 = state_33945;
var statearr_33960_34012 = state_33945__$1;
(statearr_33960_34012[(2)] = inst_33933);

(statearr_33960_34012[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (25))){
var inst_33873 = (state_33945[(16)]);
var inst_33877 = (state_33945[(14)]);
var inst_33918 = cljs.core.PersistentHashMap.EMPTY;
var inst_33919 = cljs.core.first(inst_33873);
var inst_33920 = cljs.core.first(inst_33919);
var inst_33921 = cljs.core.flatten(inst_33877);
var inst_33922 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33918,inst_33920,inst_33921);
var state_33945__$1 = state_33945;
var statearr_33961_34013 = state_33945__$1;
(statearr_33961_34013[(2)] = inst_33922);

(statearr_33961_34013[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (17))){
var inst_33861 = (state_33945[(13)]);
var inst_33898 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33861)].join('');
var inst_33899 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33900 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_33901 = cljs.core.PersistentHashMap.fromArrays(inst_33899,inst_33900);
var inst_33902 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33898,inst_33901);
var inst_33903 = (function(){throw inst_33902})();
var state_33945__$1 = state_33945;
var statearr_33962_34014 = state_33945__$1;
(statearr_33962_34014[(2)] = inst_33903);

(statearr_33962_34014[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (3))){
var inst_33943 = (state_33945[(2)]);
var state_33945__$1 = state_33945;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33945__$1,inst_33943);
} else {
if((state_val_33946 === (12))){
var inst_33848 = (state_33945[(17)]);
var inst_33936 = (state_33945[(2)]);
var inst_33937 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_33938 = cljs.core.keys(inst_33848);
var inst_33939 = [inst_33938,vars,inst_33936];
var inst_33940 = cljs.core.PersistentHashMap.fromArrays(inst_33937,inst_33939);
var _ = (function (){var statearr_33963 = state_33945;
(statearr_33963[(4)] = cljs.core.rest((state_33945[(4)])));

return statearr_33963;
})();
var state_33945__$1 = state_33945;
var statearr_33964_34015 = state_33945__$1;
(statearr_33964_34015[(2)] = inst_33940);

(statearr_33964_34015[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (2))){
var inst_33852 = (state_33945[(12)]);
var inst_33851 = (state_33945[(7)]);
var inst_33848 = (state_33945[(17)]);
var inst_33863 = (state_33945[(15)]);
var _ = (function (){var statearr_33965 = state_33945;
(statearr_33965[(4)] = cljs.core.cons((5),(state_33945[(4)])));

return statearr_33965;
})();
var inst_33845 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_33846 = cljs.core.__destructure_map(inst_33845);
var inst_33847 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33846,cljs.core.cst$kw$search);
var inst_33848__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33846,cljs.core.cst$kw$rel);
var inst_33849 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33846,cljs.core.cst$kw$opts);
var inst_33850 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_33851__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_33849);
var inst_33852__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_33849);
var inst_33854 = (function (){var map__33841 = inst_33846;
var search = inst_33847;
var rel = inst_33848__$1;
var opts = inst_33849;
var common_keys = inst_33850;
var object_fn = inst_33851__$1;
var recur_depth = inst_33852__$1;
return (function (p__33853,common_key){
var vec__33966 = p__33853;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33966,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33966,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__33969 = cljs.core._EQ_;
var expr__33970 = idx_of;
if(cljs.core.truth_((pred__33969.cljs$core$IFn$_invoke$arity$2 ? pred__33969.cljs$core$IFn$_invoke$arity$2((0),expr__33970) : pred__33969.call(null,(0),expr__33970)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__33969.cljs$core$IFn$_invoke$arity$2 ? pred__33969.cljs$core$IFn$_invoke$arity$2((1),expr__33970) : pred__33969.call(null,(1),expr__33970)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__33969.cljs$core$IFn$_invoke$arity$2 ? pred__33969.cljs$core$IFn$_invoke$arity$2((2),expr__33970) : pred__33969.call(null,(2),expr__33970)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__33970)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4149__auto__ = object_fn;
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4149__auto__;
}
})():false))?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_33855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33856 = cljs.core.PersistentHashMap.EMPTY;
var inst_33857 = [inst_33856,inst_33847];
var inst_33858 = (new cljs.core.PersistentVector(null,2,(5),inst_33855,inst_33857,null));
var inst_33859 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_33854,inst_33858,inst_33850);
var inst_33860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33859,(0),null);
var inst_33861 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33859,(1),null);
var inst_33862 = [cljs.core.cst$kw$object_DASH_fn];
var inst_33863__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_33860);
var state_33945__$1 = (function (){var statearr_33972 = state_33945;
(statearr_33972[(13)] = inst_33861);

(statearr_33972[(12)] = inst_33852__$1);

(statearr_33972[(7)] = inst_33851__$1);

(statearr_33972[(18)] = inst_33862);

(statearr_33972[(17)] = inst_33848__$1);

(statearr_33972[(15)] = inst_33863__$1);

return statearr_33972;
})();
if(cljs.core.truth_(inst_33863__$1)){
var statearr_33973_34016 = state_33945__$1;
(statearr_33973_34016[(1)] = (6));

} else {
var statearr_33974_34017 = state_33945__$1;
(statearr_33974_34017[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (23))){
var inst_33879 = (state_33945[(8)]);
var inst_33916 = cljs.core.coll_QMARK_(inst_33879);
var state_33945__$1 = state_33945;
if(inst_33916){
var statearr_33975_34018 = state_33945__$1;
(statearr_33975_34018[(1)] = (25));

} else {
var statearr_33976_34019 = state_33945__$1;
(statearr_33976_34019[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (19))){
var inst_33877 = (state_33945[(14)]);
var inst_33907 = cljs.core.PersistentHashMap.EMPTY;
var inst_33908 = fluree.db.query.analytical.tuples__GT_map(inst_33907,inst_33877);
var state_33945__$1 = state_33945;
var statearr_33977_34020 = state_33945__$1;
(statearr_33977_34020[(2)] = inst_33908);

(statearr_33977_34020[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (11))){
var inst_33877 = (state_33945[(14)]);
var state_33945__$1 = state_33945;
var statearr_33979_34021 = state_33945__$1;
(statearr_33979_34021[(2)] = inst_33877);

(statearr_33979_34021[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (9))){
var inst_33852 = (state_33945[(12)]);
var inst_33873 = (state_33945[(16)]);
var inst_33848 = (state_33945[(17)]);
var inst_33872 = (state_33945[(2)]);
var inst_33873__$1 = fluree.db.util.async.throw_err(inst_33872);
var inst_33874 = cljs.core.count(inst_33873__$1);
var inst_33875 = fluree.db.query.analytical.add_fuel(inst_33874,fuel,max_fuel);
var inst_33876 = cljs.core.vals(inst_33848);
var inst_33877 = fluree.db.query.analytical.get_ns_arrays(inst_33876,inst_33873__$1);
var state_33945__$1 = (function (){var statearr_33980 = state_33945;
(statearr_33980[(16)] = inst_33873__$1);

(statearr_33980[(14)] = inst_33877);

(statearr_33980[(19)] = inst_33875);

return statearr_33980;
})();
if(cljs.core.truth_(inst_33852)){
var statearr_33981_34022 = state_33945__$1;
(statearr_33981_34022[(1)] = (10));

} else {
var statearr_33982_34023 = state_33945__$1;
(statearr_33982_34023[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (5))){
var _ = (function (){var statearr_33983 = state_33945;
(statearr_33983[(4)] = cljs.core.rest((state_33945[(4)])));

return statearr_33983;
})();
var state_33945__$1 = state_33945;
var ex33978 = (state_33945__$1[(2)]);
var statearr_33984_34024 = state_33945__$1;
(statearr_33984_34024[(5)] = ex33978);


if((ex33978 instanceof Error)){
var statearr_33985_34025 = state_33945__$1;
(statearr_33985_34025[(1)] = (4));

(statearr_33985_34025[(5)] = null);

} else {
throw ex33978;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (14))){
var state_33945__$1 = state_33945;
var statearr_33986_34026 = state_33945__$1;
(statearr_33986_34026[(2)] = null);

(statearr_33986_34026[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (26))){
var state_33945__$1 = state_33945;
var statearr_33987_34027 = state_33945__$1;
(statearr_33987_34027[(2)] = null);

(statearr_33987_34027[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (16))){
var state_33945__$1 = state_33945;
var statearr_33988_34028 = state_33945__$1;
(statearr_33988_34028[(2)] = null);

(statearr_33988_34028[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (10))){
var inst_33882 = (state_33945[(11)]);
var inst_33861 = (state_33945[(13)]);
var inst_33879 = cljs.core.first(inst_33861);
var inst_33880 = cljs.core.first(clause);
var inst_33881 = fluree.db.query.analytical.variable_QMARK_(inst_33880);
var inst_33882__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_33861,(1));
var inst_33883 = fluree.db.query.analytical.variable_QMARK_(inst_33882__$1);
var state_33945__$1 = (function (){var statearr_33989 = state_33945;
(statearr_33989[(10)] = inst_33881);

(statearr_33989[(11)] = inst_33882__$1);

(statearr_33989[(8)] = inst_33879);

return statearr_33989;
})();
if(cljs.core.truth_(inst_33883)){
var statearr_33990_34029 = state_33945__$1;
(statearr_33990_34029[(1)] = (13));

} else {
var statearr_33991_34030 = state_33945__$1;
(statearr_33991_34030[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (18))){
var inst_33881 = (state_33945[(10)]);
var inst_33905 = (state_33945[(2)]);
var state_33945__$1 = (function (){var statearr_33992 = state_33945;
(statearr_33992[(20)] = inst_33905);

return statearr_33992;
})();
if(cljs.core.truth_(inst_33881)){
var statearr_33993_34031 = state_33945__$1;
(statearr_33993_34031[(1)] = (19));

} else {
var statearr_33994_34032 = state_33945__$1;
(statearr_33994_34032[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33946 === (8))){
var inst_33861 = (state_33945[(13)]);
var inst_33862 = (state_33945[(18)]);
var inst_33867 = (state_33945[(2)]);
var inst_33868 = [inst_33867];
var inst_33869 = cljs.core.PersistentHashMap.fromArrays(inst_33862,inst_33868);
var inst_33870 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_33861,inst_33869);
var state_33945__$1 = state_33945;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33945__$1,(9),inst_33870);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto____0 = (function (){
var statearr_33995 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33995[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto__);

(statearr_33995[(1)] = (1));

return statearr_33995;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto____1 = (function (state_33945){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_33945);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e33996){var ex__13886__auto__ = e33996;
var statearr_33997_34033 = state_33945;
(statearr_33997_34033[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_33945[(4)]))){
var statearr_33998_34034 = state_33945;
(statearr_33998_34034[(1)] = cljs.core.first((state_33945[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__34035 = state_33945;
state_33945 = G__34035;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto__ = function(state_33945){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto____1.call(this,state_33945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_33999 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_33999[(6)] = c__13957__auto__);

return statearr_33999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__34036,res,clause){
var map__34037 = p__34036;
var map__34037__$1 = cljs.core.__destructure_map(map__34037);
var db = map__34037__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34037__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34037__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34037__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_34136){
var state_val_34137 = (state_34136[(1)]);
if((state_val_34137 === (7))){
var inst_34047 = (state_34136[(7)]);
var state_34136__$1 = state_34136;
var statearr_34138_34178 = state_34136__$1;
(statearr_34138_34178[(2)] = inst_34047);

(statearr_34138_34178[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (20))){
var inst_34127 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
var statearr_34139_34179 = state_34136__$1;
(statearr_34139_34179[(2)] = inst_34127);

(statearr_34139_34179[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (1))){
var state_34136__$1 = state_34136;
var statearr_34140_34180 = state_34136__$1;
(statearr_34140_34180[(2)] = null);

(statearr_34140_34180[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (24))){
var inst_34106 = (state_34136[(2)]);
var inst_34107 = fluree.db.util.async.throw_err(inst_34106);
var state_34136__$1 = state_34136;
var statearr_34141_34181 = state_34136__$1;
(statearr_34141_34181[(2)] = inst_34107);

(statearr_34141_34181[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (4))){
var inst_34040 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
var statearr_34142_34182 = state_34136__$1;
(statearr_34142_34182[(2)] = inst_34040);

(statearr_34142_34182[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (15))){
var inst_34047 = (state_34136[(7)]);
var inst_34049 = (state_34136[(8)]);
var inst_34068 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_34069 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_34070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34071 = [inst_34047];
var inst_34072 = (new cljs.core.PersistentVector(null,1,(5),inst_34070,inst_34071,null));
var inst_34073 = (function (){var subject_var = inst_34047;
var object_var = inst_34049;
var min_sid = inst_34068;
var max_sid = (0);
return (function (p1__34038_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__34038_SHARP_);
});
})();
var inst_34074 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_34068,(0));
var inst_34075 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34073,inst_34074);
var inst_34076 = cljs.core.PersistentHashMap.EMPTY;
var inst_34077 = [inst_34072,inst_34075,inst_34076];
var inst_34078 = cljs.core.PersistentHashMap.fromArrays(inst_34069,inst_34077);
var state_34136__$1 = state_34136;
var statearr_34143_34183 = state_34136__$1;
(statearr_34143_34183[(2)] = inst_34078);

(statearr_34143_34183[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (21))){
var inst_34100 = (state_34136[(9)]);
var state_34136__$1 = state_34136;
var statearr_34144_34184 = state_34136__$1;
(statearr_34144_34184[(2)] = inst_34100);

(statearr_34144_34184[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (13))){
var inst_34049 = (state_34136[(8)]);
var state_34136__$1 = state_34136;
if(cljs.core.truth_(inst_34049)){
var statearr_34145_34185 = state_34136__$1;
(statearr_34145_34185[(1)] = (18));

} else {
var statearr_34146_34186 = state_34136__$1;
(statearr_34146_34186[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (22))){
var inst_34100 = (state_34136[(9)]);
var inst_34104 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_34100);
var state_34136__$1 = state_34136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34136__$1,(24),inst_34104);
} else {
if((state_val_34137 === (6))){
var inst_34049 = (state_34136[(8)]);
var state_34136__$1 = state_34136;
var statearr_34147_34187 = state_34136__$1;
(statearr_34147_34187[(2)] = inst_34049);

(statearr_34147_34187[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (17))){
var inst_34097 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
var statearr_34148_34188 = state_34136__$1;
(statearr_34148_34188[(2)] = inst_34097);

(statearr_34148_34188[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (3))){
var inst_34134 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34136__$1,inst_34134);
} else {
if((state_val_34137 === (12))){
var inst_34062 = ["_tx",null,"_block",null];
var inst_34063 = (new cljs.core.PersistentArrayMap(null,2,inst_34062,null));
var inst_34064 = (new cljs.core.PersistentHashSet(null,inst_34063,null));
var inst_34065 = cljs.core.last(clause);
var inst_34066 = (inst_34064.cljs$core$IFn$_invoke$arity$1 ? inst_34064.cljs$core$IFn$_invoke$arity$1(inst_34065) : inst_34064.call(null,inst_34065));
var state_34136__$1 = state_34136;
if(cljs.core.truth_(inst_34066)){
var statearr_34149_34189 = state_34136__$1;
(statearr_34149_34189[(1)] = (15));

} else {
var statearr_34150_34190 = state_34136__$1;
(statearr_34150_34190[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (2))){
var inst_34047 = (state_34136[(7)]);
var _ = (function (){var statearr_34151 = state_34136;
(statearr_34151[(4)] = cljs.core.cons((5),(state_34136[(4)])));

return statearr_34151;
})();
var inst_34046 = cljs.core.first(clause);
var inst_34047__$1 = fluree.db.query.analytical.variable_QMARK_(inst_34046);
var inst_34048 = cljs.core.last(clause);
var inst_34049 = fluree.db.query.analytical.variable_QMARK_(inst_34048);
var state_34136__$1 = (function (){var statearr_34152 = state_34136;
(statearr_34152[(7)] = inst_34047__$1);

(statearr_34152[(8)] = inst_34049);

return statearr_34152;
})();
if(cljs.core.truth_(inst_34047__$1)){
var statearr_34153_34191 = state_34136__$1;
(statearr_34153_34191[(1)] = (6));

} else {
var statearr_34154_34192 = state_34136__$1;
(statearr_34154_34192[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (23))){
var inst_34049 = (state_34136[(8)]);
var inst_34109 = (state_34136[(2)]);
var inst_34110 = fluree.db.flake.sid__GT_cid(inst_34109);
var inst_34111 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_34110);
var inst_34112 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_34113 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34114 = [inst_34049];
var inst_34115 = (new cljs.core.PersistentVector(null,1,(5),inst_34113,inst_34114,null));
var inst_34116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34118 = [inst_34111];
var inst_34119 = (new cljs.core.PersistentVector(null,1,(5),inst_34117,inst_34118,null));
var inst_34120 = [inst_34119];
var inst_34121 = (new cljs.core.PersistentVector(null,1,(5),inst_34116,inst_34120,null));
var inst_34122 = cljs.core.PersistentHashMap.EMPTY;
var inst_34123 = [inst_34115,inst_34121,inst_34122];
var inst_34124 = cljs.core.PersistentHashMap.fromArrays(inst_34112,inst_34123);
var state_34136__$1 = state_34136;
var statearr_34155_34193 = state_34136__$1;
(statearr_34155_34193[(2)] = inst_34124);

(statearr_34155_34193[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (19))){
var state_34136__$1 = state_34136;
var statearr_34156_34194 = state_34136__$1;
(statearr_34156_34194[(2)] = null);

(statearr_34156_34194[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (11))){
var inst_34131 = (state_34136[(2)]);
var _ = (function (){var statearr_34158 = state_34136;
(statearr_34158[(4)] = cljs.core.rest((state_34136[(4)])));

return statearr_34158;
})();
var state_34136__$1 = state_34136;
var statearr_34159_34195 = state_34136__$1;
(statearr_34159_34195[(2)] = inst_34131);

(statearr_34159_34195[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (9))){
var inst_34055 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34056 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34057 = cljs.core.PersistentHashMap.fromArrays(inst_34055,inst_34056);
var inst_34058 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_34057);
var inst_34059 = (function(){throw inst_34058})();
var state_34136__$1 = state_34136;
var statearr_34160_34196 = state_34136__$1;
(statearr_34160_34196[(2)] = inst_34059);

(statearr_34160_34196[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (5))){
var _ = (function (){var statearr_34161 = state_34136;
(statearr_34161[(4)] = cljs.core.rest((state_34136[(4)])));

return statearr_34161;
})();
var state_34136__$1 = state_34136;
var ex34157 = (state_34136__$1[(2)]);
var statearr_34162_34197 = state_34136__$1;
(statearr_34162_34197[(5)] = ex34157);


if((ex34157 instanceof Error)){
var statearr_34163_34198 = state_34136__$1;
(statearr_34163_34198[(1)] = (4));

(statearr_34163_34198[(5)] = null);

} else {
throw ex34157;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (14))){
var inst_34129 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
var statearr_34164_34199 = state_34136__$1;
(statearr_34164_34199[(2)] = inst_34129);

(statearr_34164_34199[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (16))){
var inst_34047 = (state_34136[(7)]);
var inst_34049 = (state_34136[(8)]);
var inst_34080 = cljs.core.last(clause);
var inst_34081 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,inst_34080);
var inst_34082 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_34083 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34082,inst_34081);
var inst_34084 = fluree.db.flake.min_subject_id(inst_34081);
var inst_34085 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_34086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34087 = [inst_34047];
var inst_34088 = (new cljs.core.PersistentVector(null,1,(5),inst_34086,inst_34087,null));
var inst_34089 = (function (){var subject_var = inst_34047;
var object_var = inst_34049;
var partition = inst_34081;
var max_sid = inst_34083;
var min_sid = inst_34084;
return (function (p1__34039_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__34039_SHARP_);
});
})();
var inst_34090 = (inst_34083 + (1));
var inst_34091 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_34084,inst_34090);
var inst_34092 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34089,inst_34091);
var inst_34093 = cljs.core.PersistentHashMap.EMPTY;
var inst_34094 = [inst_34088,inst_34092,inst_34093];
var inst_34095 = cljs.core.PersistentHashMap.fromArrays(inst_34085,inst_34094);
var state_34136__$1 = state_34136;
var statearr_34165_34200 = state_34136__$1;
(statearr_34165_34200[(2)] = inst_34095);

(statearr_34165_34200[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (10))){
var inst_34047 = (state_34136[(7)]);
var state_34136__$1 = state_34136;
if(cljs.core.truth_(inst_34047)){
var statearr_34166_34201 = state_34136__$1;
(statearr_34166_34201[(1)] = (12));

} else {
var statearr_34167_34202 = state_34136__$1;
(statearr_34167_34202[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (18))){
var inst_34100 = (state_34136[(9)]);
var inst_34100__$1 = cljs.core.first(clause);
var inst_34101 = typeof inst_34100__$1 === 'number';
var state_34136__$1 = (function (){var statearr_34168 = state_34136;
(statearr_34168[(9)] = inst_34100__$1);

return statearr_34168;
})();
if(cljs.core.truth_(inst_34101)){
var statearr_34169_34203 = state_34136__$1;
(statearr_34169_34203[(1)] = (21));

} else {
var statearr_34170_34204 = state_34136__$1;
(statearr_34170_34204[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34137 === (8))){
var inst_34053 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
if(cljs.core.truth_(inst_34053)){
var statearr_34171_34205 = state_34136__$1;
(statearr_34171_34205[(1)] = (9));

} else {
var statearr_34172_34206 = state_34136__$1;
(statearr_34172_34206[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto____0 = (function (){
var statearr_34173 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34173[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto__);

(statearr_34173[(1)] = (1));

return statearr_34173;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto____1 = (function (state_34136){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_34136);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e34174){var ex__13886__auto__ = e34174;
var statearr_34175_34207 = state_34136;
(statearr_34175_34207[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_34136[(4)]))){
var statearr_34176_34208 = state_34136;
(statearr_34176_34208[(1)] = cljs.core.first((state_34136[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__34209 = state_34136;
state_34136 = G__34209;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto__ = function(state_34136){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto____1.call(this,state_34136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_34177 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_34177[(6)] = c__13957__auto__);

return statearr_34177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__34216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__34216 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__34216;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4564__auto__ = (function fluree$db$query$analytical$variance_$_iter__34217(s__34218){
return (new cljs.core.LazySeq(null,(function (){
var s__34218__$1 = s__34218;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__34218__$1);
if(temp__5753__auto__){
var s__34218__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34218__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__34218__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__34220 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__34219 = (0);
while(true){
if((i__34219 < size__4563__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__34219);
var delta = (x - mean);
cljs.core.chunk_append(b__34220,(delta * delta));

var G__34222 = (i__34219 + (1));
i__34219 = G__34222;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34220),fluree$db$query$analytical$variance_$_iter__34217(cljs.core.chunk_rest(s__34218__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34220),null);
}
} else {
var x = cljs.core.first(s__34218__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__34217(cljs.core.rest(s__34218__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__34221 = variance(coll);
return Math.sqrt(G__34221);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4249__auto__ = n;
var y__4250__auto__ = (- n);
return ((x__4249__auto__ > y__4250__auto__) ? x__4249__auto__ : y__4250__auto__);
}),(function() {
var G__34223 = null;
var G__34223__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__34223__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__34223 = function(n,coll){
switch(arguments.length){
case 1:
return G__34223__1.call(this,n);
case 2:
return G__34223__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34223.cljs$core$IFn$_invoke$arity$1 = G__34223__1;
G__34223.cljs$core$IFn$_invoke$arity$2 = G__34223__2;
return G__34223;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__34224 = null;
var G__34224__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__34224__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__34224 = function(n,coll){
switch(arguments.length){
case 1:
return G__34224__1.call(this,n);
case 2:
return G__34224__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34224.cljs$core$IFn$_invoke$arity$1 = G__34224__1;
G__34224.cljs$core$IFn$_invoke$arity$2 = G__34224__2;
return G__34224;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__34225 = null;
var G__34225__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__34225__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__34225 = function(n,coll){
switch(arguments.length){
case 1:
return G__34225__1.call(this,n);
case 2:
return G__34225__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34225.cljs$core$IFn$_invoke$arity$1 = G__34225__1;
G__34225.cljs$core$IFn$_invoke$arity$2 = G__34225__2;
return G__34225;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__34226 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34226,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34226,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34226,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__34229 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__34232 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__34232) : agg_fn.call(null,G__34232));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34229,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34229,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__34233 = agg;
var map__34233__$1 = cljs.core.__destructure_map(map__34233);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34233__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34233__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34233__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__34235 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34235,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34235,(1),null);
var map__34238 = res__$1;
var map__34238__$1 = cljs.core.__destructure_map(map__34238);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34238__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34238__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34234_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__34234_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34239_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__34239_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34240_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__34240_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__34241_SHARP_,p2__34242_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34241_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__34242_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34243_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__34243_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__34246,row,b_tuple){
var vec__34247 = p__34246;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34247,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34247,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34244_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34244_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4160__auto__ = acc;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34245_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34245_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34250_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__34250_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34251_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__34251_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34256 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__34258 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__34257 = (function (p1__34252_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34252_SHARP_);
});
return fexpr__34257(G__34258);
})()),cljs.core.set(b_idxs));
var fexpr__34255 = (function (p1__34253_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34253_SHARP_);
});
return fexpr__34255(G__34256);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34254_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__34254_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34259_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__34259_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34260_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34260_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34265 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__34267 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__34266 = (function (p1__34261_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34261_SHARP_);
});
return fexpr__34266(G__34267);
})()),cljs.core.set(b_idxs));
var fexpr__34264 = (function (p1__34262_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34262_SHARP_);
});
return fexpr__34264(G__34265);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34263_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34263_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34268_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__34268_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34269_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34269_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34278 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__34280 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__34279 = (function (p1__34270_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34270_SHARP_);
});
return fexpr__34279(G__34280);
})()),cljs.core.set(b_idxs));
var fexpr__34277 = (function (p1__34271_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34271_SHARP_);
});
return fexpr__34277(G__34278);
})();
var vec__34274 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__34281,a_tuple){
var vec__34282 = p__34281;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34282,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34282,(1),null);
var vec__34285 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34285,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34285,(1),null);
var matches__$1 = (function (){var or__4160__auto__ = matches;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(c_tuples),matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34274,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34274,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34272_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34272_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34273_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34273_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__34289 = (function (){var or__4160__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34289,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34289,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__34288_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__34288_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__34294 = (function (){var or__4160__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34294,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34294,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34292_SHARP_){
return fluree.db.util.core.index_of(headers,p1__34292_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__34293_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__34293_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__34297,filters,optional_QMARK_){
var map__34298 = p__34297;
var map__34298__$1 = cljs.core.__destructure_map(map__34298);
var tuple_map = map__34298__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34298__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34298__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34298__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__34299 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34299,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34299,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__34302 = res;
var map__34302__$1 = cljs.core.__destructure_map(map__34302);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34302__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34302__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_34358){
var state_val_34359 = (state_34358[(1)]);
if((state_val_34359 === (7))){
var inst_34332 = (state_34358[(7)]);
var inst_34330 = (state_34358[(2)]);
var inst_34331 = fluree.db.util.async.throw_err(inst_34330);
var inst_34332__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34331,(0),null);
var inst_34333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34331,(1),null);
var inst_34334 = (inst_34332__$1 == null);
var state_34358__$1 = (function (){var statearr_34360 = state_34358;
(statearr_34360[(7)] = inst_34332__$1);

(statearr_34360[(8)] = inst_34333);

return statearr_34360;
})();
if(cljs.core.truth_(inst_34334)){
var statearr_34361_34390 = state_34358__$1;
(statearr_34361_34390[(1)] = (8));

} else {
var statearr_34362_34391 = state_34358__$1;
(statearr_34362_34391[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34359 === (1))){
var inst_34310 = optional_clauses;
var inst_34311 = cljs.core.seq(inst_34310);
var inst_34312 = cljs.core.first(inst_34311);
var inst_34313 = cljs.core.next(inst_34311);
var inst_34314 = where_tuples;
var inst_34315 = inst_34310;
var inst_34316 = inst_34314;
var state_34358__$1 = (function (){var statearr_34363 = state_34358;
(statearr_34363[(9)] = inst_34315);

(statearr_34363[(10)] = inst_34313);

(statearr_34363[(11)] = inst_34316);

(statearr_34363[(12)] = inst_34312);

return statearr_34363;
})();
var statearr_34364_34392 = state_34358__$1;
(statearr_34364_34392[(2)] = null);

(statearr_34364_34392[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34359 === (4))){
var inst_34323 = (state_34358[(13)]);
var inst_34316 = (state_34358[(11)]);
var inst_34322 = (state_34358[(14)]);
var inst_34328 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_34316,inst_34322,inst_34323,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_34316,inst_34322,inst_34323,true,fuel,max_fuel,opts));
var state_34358__$1 = state_34358;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34358__$1,(7),inst_34328);
} else {
if((state_val_34359 === (15))){
var state_34358__$1 = state_34358;
var statearr_34365_34393 = state_34358__$1;
(statearr_34365_34393[(2)] = null);

(statearr_34365_34393[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34359 === (13))){
var inst_34349 = (state_34358[(2)]);
var state_34358__$1 = state_34358;
var statearr_34366_34394 = state_34358__$1;
(statearr_34366_34394[(2)] = inst_34349);

(statearr_34366_34394[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34359 === (6))){
var inst_34354 = (state_34358[(2)]);
var state_34358__$1 = state_34358;
var statearr_34367_34395 = state_34358__$1;
(statearr_34367_34395[(2)] = inst_34354);

(statearr_34367_34395[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34359 === (3))){
var inst_34356 = (state_34358[(2)]);
var state_34358__$1 = state_34358;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34358__$1,inst_34356);
} else {
if((state_val_34359 === (12))){
var state_34358__$1 = state_34358;
var statearr_34368_34396 = state_34358__$1;
(statearr_34368_34396[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34359 === (2))){
var inst_34315 = (state_34358[(9)]);
var inst_34322 = (state_34358[(14)]);
var inst_34321 = cljs.core.seq(inst_34315);
var inst_34322__$1 = cljs.core.first(inst_34321);
var inst_34323 = cljs.core.next(inst_34321);
var state_34358__$1 = (function (){var statearr_34370 = state_34358;
(statearr_34370[(13)] = inst_34323);

(statearr_34370[(14)] = inst_34322__$1);

return statearr_34370;
})();
if(cljs.core.truth_(inst_34322__$1)){
var statearr_34371_34397 = state_34358__$1;
(statearr_34371_34397[(1)] = (4));

} else {
var statearr_34372_34398 = state_34358__$1;
(statearr_34372_34398[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34359 === (11))){
var inst_34332 = (state_34358[(7)]);
var inst_34333 = (state_34358[(8)]);
var inst_34315 = inst_34333;
var inst_34316 = inst_34332;
var state_34358__$1 = (function (){var statearr_34373 = state_34358;
(statearr_34373[(9)] = inst_34315);

(statearr_34373[(11)] = inst_34316);

return statearr_34373;
})();
var statearr_34374_34399 = state_34358__$1;
(statearr_34374_34399[(2)] = null);

(statearr_34374_34399[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34359 === (9))){
var inst_34322 = (state_34358[(14)]);
var inst_34338 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_34322);
var state_34358__$1 = state_34358;
if(cljs.core.truth_(inst_34338)){
var statearr_34375_34400 = state_34358__$1;
(statearr_34375_34400[(1)] = (11));

} else {
var statearr_34376_34401 = state_34358__$1;
(statearr_34376_34401[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34359 === (5))){
var inst_34316 = (state_34358[(11)]);
var state_34358__$1 = state_34358;
var statearr_34377_34402 = state_34358__$1;
(statearr_34377_34402[(2)] = inst_34316);

(statearr_34377_34402[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34359 === (14))){
var inst_34332 = (state_34358[(7)]);
var inst_34333 = (state_34358[(8)]);
var inst_34316 = (state_34358[(11)]);
var inst_34343 = fluree.db.query.analytical.left_outer_join(inst_34316,inst_34332);
var inst_34315 = inst_34333;
var inst_34316__$1 = inst_34343;
var state_34358__$1 = (function (){var statearr_34378 = state_34358;
(statearr_34378[(9)] = inst_34315);

(statearr_34378[(11)] = inst_34316__$1);

return statearr_34378;
})();
var statearr_34379_34403 = state_34358__$1;
(statearr_34379_34403[(2)] = null);

(statearr_34379_34403[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34359 === (16))){
var inst_34347 = (state_34358[(2)]);
var state_34358__$1 = state_34358;
var statearr_34381_34404 = state_34358__$1;
(statearr_34381_34404[(2)] = inst_34347);

(statearr_34381_34404[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34359 === (10))){
var inst_34351 = (state_34358[(2)]);
var state_34358__$1 = state_34358;
var statearr_34382_34405 = state_34358__$1;
(statearr_34382_34405[(2)] = inst_34351);

(statearr_34382_34405[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34359 === (8))){
var inst_34333 = (state_34358[(8)]);
var inst_34316 = (state_34358[(11)]);
var tmp34380 = inst_34316;
var inst_34315 = inst_34333;
var inst_34316__$1 = tmp34380;
var state_34358__$1 = (function (){var statearr_34383 = state_34358;
(statearr_34383[(9)] = inst_34315);

(statearr_34383[(11)] = inst_34316__$1);

return statearr_34383;
})();
var statearr_34384_34406 = state_34358__$1;
(statearr_34384_34406[(2)] = null);

(statearr_34384_34406[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto____0 = (function (){
var statearr_34385 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34385[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto__);

(statearr_34385[(1)] = (1));

return statearr_34385;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto____1 = (function (state_34358){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_34358);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e34386){var ex__13886__auto__ = e34386;
var statearr_34387_34407 = state_34358;
(statearr_34387_34407[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_34358[(4)]))){
var statearr_34388_34408 = state_34358;
(statearr_34388_34408[(1)] = cljs.core.first((state_34358[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__34409 = state_34358;
state_34358 = G__34409;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto__ = function(state_34358){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto____1.call(this,state_34358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_34389 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_34389[(6)] = c__13957__auto__);

return statearr_34389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__34411){
var vec__34412 = p__34411;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34412,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34412,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34410_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34410_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__34416,p__34417,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__34418 = p__34416;
var map__34418__$1 = cljs.core.__destructure_map(map__34418);
var q_map = map__34418__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34418__$1,cljs.core.cst$kw$prefixes);
var map__34419 = p__34417;
var map__34419__$1 = cljs.core.__destructure_map(map__34419);
var res = map__34419__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34419__$1,cljs.core.cst$kw$vars);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_34626){
var state_val_34627 = (state_34626[(1)]);
if((state_val_34627 === (7))){
var inst_34524 = cljs.core.count(clause);
var inst_34525 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_34524);
var inst_34526 = cljs.core.second(clause);
var inst_34527 = clojure.string.starts_with_QMARK_(inst_34526,"fullText:");
var inst_34528 = ((inst_34525) && (inst_34527));
var state_34626__$1 = state_34626;
if(cljs.core.truth_(inst_34528)){
var statearr_34628_34723 = state_34626__$1;
(statearr_34628_34723[(1)] = (31));

} else {
var statearr_34629_34724 = state_34626__$1;
(statearr_34629_34724[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (59))){
var inst_34595 = (state_34626[(7)]);
var inst_34598 = (state_34626[(2)]);
var inst_34599 = fluree.db.util.async.throw_err(inst_34598);
var inst_34600 = [inst_34599,r];
var inst_34601 = (new cljs.core.PersistentVector(null,2,(5),inst_34595,inst_34600,null));
var state_34626__$1 = state_34626;
var statearr_34630_34725 = state_34626__$1;
(statearr_34630_34725[(2)] = inst_34601);

(statearr_34630_34725[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (20))){
var inst_34488 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34631_34726 = state_34626__$1;
(statearr_34631_34726[(2)] = inst_34488);

(statearr_34631_34726[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (58))){
var inst_34604 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34632_34727 = state_34626__$1;
(statearr_34632_34727[(2)] = inst_34604);

(statearr_34632_34727[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (27))){
var inst_34518 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34633_34728 = state_34626__$1;
(statearr_34633_34728[(2)] = inst_34518);

(statearr_34633_34728[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (1))){
var state_34626__$1 = state_34626;
var statearr_34634_34729 = state_34626__$1;
(statearr_34634_34729[(2)] = null);

(statearr_34634_34729[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (24))){
var inst_34482 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34635_34730 = state_34626__$1;
(statearr_34635_34730[(2)] = inst_34482);

(statearr_34635_34730[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (55))){
var inst_34606 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34636_34731 = state_34626__$1;
(statearr_34636_34731[(2)] = inst_34606);

(statearr_34636_34731[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (39))){
var inst_34560 = cljs.core.count(clause);
var inst_34561 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_34560);
var state_34626__$1 = state_34626;
if(inst_34561){
var statearr_34637_34732 = state_34626__$1;
(statearr_34637_34732[(1)] = (42));

} else {
var statearr_34638_34733 = state_34626__$1;
(statearr_34638_34733[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (46))){
var state_34626__$1 = state_34626;
var statearr_34639_34734 = state_34626__$1;
(statearr_34639_34734[(2)] = null);

(statearr_34639_34734[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (4))){
var inst_34420 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34640_34735 = state_34626__$1;
(statearr_34640_34735[(2)] = inst_34420);

(statearr_34640_34735[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (54))){
var state_34626__$1 = state_34626;
var statearr_34641_34736 = state_34626__$1;
(statearr_34641_34736[(1)] = (56));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (15))){
var inst_34520 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34643_34737 = state_34626__$1;
(statearr_34643_34737[(2)] = inst_34520);

(statearr_34643_34737[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (48))){
var inst_34577 = (state_34626[(8)]);
var inst_34575 = (state_34626[(2)]);
var inst_34576 = fluree.db.util.async.throw_err(inst_34575);
var inst_34577__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34576,(0),null);
var inst_34578 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34576,(1),null);
var inst_34579 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_34577__$1);
var state_34626__$1 = (function (){var statearr_34644 = state_34626;
(statearr_34644[(8)] = inst_34577__$1);

(statearr_34644[(9)] = inst_34578);

return statearr_34644;
})();
if(inst_34579){
var statearr_34645_34738 = state_34626__$1;
(statearr_34645_34738[(1)] = (49));

} else {
var statearr_34646_34739 = state_34626__$1;
(statearr_34646_34739[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (50))){
var inst_34578 = (state_34626[(9)]);
var inst_34586 = cljs.core.second(inst_34578);
var inst_34587 = clojure.string.starts_with_QMARK_(inst_34586,"fullText:");
var state_34626__$1 = state_34626;
if(inst_34587){
var statearr_34647_34740 = state_34626__$1;
(statearr_34647_34740[(1)] = (53));

} else {
var statearr_34648_34741 = state_34626__$1;
(statearr_34648_34741[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (21))){
var inst_34454 = (state_34626[(10)]);
var inst_34433 = (state_34626[(11)]);
var inst_34457 = (state_34626[(12)]);
var inst_34466 = (state_34626[(13)]);
var inst_34456 = (state_34626[(14)]);
var inst_34459 = (state_34626[(15)]);
var inst_34458 = (state_34626[(16)]);
var inst_34429 = (state_34626[(17)]);
var inst_34465 = (state_34626[(18)]);
var inst_34470 = (state_34626[(2)]);
var inst_34471 = fluree.db.util.async.throw_err(inst_34470);
var inst_34472 = (function (){var pred__34430 = inst_34433;
var new_res = inst_34471;
var rest = inst_34466;
var first__34463 = inst_34465;
var seq__34462 = inst_34466;
var first__34453 = inst_34456;
var tuples = inst_34459;
var expr__34431 = inst_34429;
var G__34450 = inst_34458;
var vec__34451 = inst_34454;
var seq__34452 = inst_34457;
var segment_type = inst_34429;
var vec__34461 = inst_34458;
var clause_group = inst_34465;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_34473 = cljs.core.keys(vars);
var inst_34474 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34472,inst_34471,inst_34473);
var inst_34475 = fluree.db.query.analytical.res_absorb_vars(inst_34474);
var state_34626__$1 = (function (){var statearr_34649 = state_34626;
(statearr_34649[(19)] = inst_34475);

return statearr_34649;
})();
if(cljs.core.truth_(inst_34459)){
var statearr_34650_34742 = state_34626__$1;
(statearr_34650_34742[(1)] = (22));

} else {
var statearr_34651_34743 = state_34626__$1;
(statearr_34651_34743[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (31))){
var inst_34530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34531 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_34532 = [inst_34531,r];
var inst_34533 = (new cljs.core.PersistentVector(null,2,(5),inst_34530,inst_34532,null));
var state_34626__$1 = state_34626;
var statearr_34652_34744 = state_34626__$1;
(statearr_34652_34744[(2)] = inst_34533);

(statearr_34652_34744[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (32))){
var inst_34535 = cljs.core.count(clause);
var inst_34536 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_34535);
var inst_34537 = cljs.core.second(clause);
var inst_34538 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34537,"rdf:type");
var inst_34539 = ((inst_34536) && (inst_34538));
var state_34626__$1 = state_34626;
if(cljs.core.truth_(inst_34539)){
var statearr_34653_34745 = state_34626__$1;
(statearr_34653_34745[(1)] = (34));

} else {
var statearr_34654_34746 = state_34626__$1;
(statearr_34654_34746[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (40))){
var inst_34615 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34655_34747 = state_34626__$1;
(statearr_34655_34747[(2)] = inst_34615);

(statearr_34655_34747[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (56))){
var inst_34577 = (state_34626[(8)]);
var inst_34578 = (state_34626[(9)]);
var inst_34595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34596 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_34577,res,inst_34578,fuel,max_fuel);
var state_34626__$1 = (function (){var statearr_34656 = state_34626;
(statearr_34656[(7)] = inst_34595);

return statearr_34656;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34626__$1,(59),inst_34596);
} else {
if((state_val_34627 === (33))){
var inst_34619 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34657_34748 = state_34626__$1;
(statearr_34657_34748[(2)] = inst_34619);

(statearr_34657_34748[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (13))){
var inst_34454 = (state_34626[(10)]);
var inst_34454__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_34455 = cljs.core.seq(inst_34454__$1);
var inst_34456 = cljs.core.first(inst_34455);
var inst_34457 = cljs.core.next(inst_34455);
var inst_34458 = inst_34454__$1;
var inst_34459 = null;
var state_34626__$1 = (function (){var statearr_34658 = state_34626;
(statearr_34658[(10)] = inst_34454__$1);

(statearr_34658[(12)] = inst_34457);

(statearr_34658[(14)] = inst_34456);

(statearr_34658[(15)] = inst_34459);

(statearr_34658[(16)] = inst_34458);

return statearr_34658;
})();
var statearr_34659_34749 = state_34626__$1;
(statearr_34659_34749[(2)] = null);

(statearr_34659_34749[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (22))){
var inst_34475 = (state_34626[(19)]);
var inst_34466 = (state_34626[(13)]);
var inst_34459 = (state_34626[(15)]);
var inst_34477 = fluree.db.query.analytical.outer_union(inst_34459,inst_34475);
var inst_34458 = inst_34466;
var inst_34459__$1 = inst_34477;
var state_34626__$1 = (function (){var statearr_34660 = state_34626;
(statearr_34660[(15)] = inst_34459__$1);

(statearr_34660[(16)] = inst_34458);

return statearr_34660;
})();
var statearr_34661_34750 = state_34626__$1;
(statearr_34661_34750[(2)] = null);

(statearr_34661_34750[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (36))){
var inst_34617 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34662_34751 = state_34626__$1;
(statearr_34662_34751[(2)] = inst_34617);

(statearr_34662_34751[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (41))){
var inst_34552 = (state_34626[(20)]);
var inst_34555 = (state_34626[(2)]);
var inst_34556 = fluree.db.util.async.throw_err(inst_34555);
var inst_34557 = [inst_34556,r];
var inst_34558 = (new cljs.core.PersistentVector(null,2,(5),inst_34552,inst_34557,null));
var state_34626__$1 = state_34626;
var statearr_34663_34752 = state_34626__$1;
(statearr_34663_34752[(2)] = inst_34558);

(statearr_34663_34752[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (43))){
var state_34626__$1 = state_34626;
var statearr_34664_34753 = state_34626__$1;
(statearr_34664_34753[(1)] = (45));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (29))){
var inst_34429 = (state_34626[(17)]);
var inst_34512 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34429)].join('');
var inst_34513 = (new Error(inst_34512));
var inst_34514 = (function(){throw inst_34513})();
var state_34626__$1 = state_34626;
var statearr_34666_34754 = state_34626__$1;
(statearr_34666_34754[(2)] = inst_34514);

(statearr_34666_34754[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (44))){
var inst_34613 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34667_34755 = state_34626__$1;
(statearr_34667_34755[(2)] = inst_34613);

(statearr_34667_34755[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (6))){
var inst_34433 = (state_34626[(11)]);
var inst_34429 = (state_34626[(17)]);
var inst_34428 = cljs.core.keys(clause);
var inst_34429__$1 = cljs.core.first(inst_34428);
var inst_34433__$1 = cljs.core._EQ_;
var inst_34434 = (function (){var G__34668 = cljs.core.cst$kw$optional;
var G__34669 = inst_34429__$1;
return (inst_34433__$1.cljs$core$IFn$_invoke$arity$2 ? inst_34433__$1.cljs$core$IFn$_invoke$arity$2(G__34668,G__34669) : inst_34433__$1.call(null,G__34668,G__34669));
})();
var state_34626__$1 = (function (){var statearr_34670 = state_34626;
(statearr_34670[(11)] = inst_34433__$1);

(statearr_34670[(17)] = inst_34429__$1);

return statearr_34670;
})();
if(cljs.core.truth_(inst_34434)){
var statearr_34671_34756 = state_34626__$1;
(statearr_34671_34756[(1)] = (9));

} else {
var statearr_34672_34757 = state_34626__$1;
(statearr_34672_34757[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (28))){
var inst_34506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34507 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_34508 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_34507,optional_QMARK_);
var inst_34509 = [inst_34508,r];
var inst_34510 = (new cljs.core.PersistentVector(null,2,(5),inst_34506,inst_34509,null));
var state_34626__$1 = state_34626;
var statearr_34673_34758 = state_34626__$1;
(statearr_34673_34758[(2)] = inst_34510);

(statearr_34673_34758[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (51))){
var inst_34608 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34674_34759 = state_34626__$1;
(statearr_34674_34759[(2)] = inst_34608);

(statearr_34674_34759[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (25))){
var inst_34433 = (state_34626[(11)]);
var inst_34429 = (state_34626[(17)]);
var inst_34494 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_34495 = (function (){var segment_type = inst_34429;
var pred__34430 = inst_34433;
var expr__34431 = inst_34429;
var bindings = inst_34494;
return (function (p1__34415_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__34415_SHARP_);
});
})();
var inst_34496 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34495,inst_34494);
var inst_34497 = cljs.core.PersistentHashMap.EMPTY;
var inst_34498 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34497,inst_34496);
var inst_34499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34500 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_34498);
var inst_34501 = [inst_34500,r];
var inst_34502 = (new cljs.core.PersistentVector(null,2,(5),inst_34499,inst_34501,null));
var state_34626__$1 = state_34626;
var statearr_34675_34760 = state_34626__$1;
(statearr_34675_34760[(2)] = inst_34502);

(statearr_34675_34760[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (34))){
var inst_34541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34542 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_34626__$1 = (function (){var statearr_34676 = state_34626;
(statearr_34676[(21)] = inst_34541);

return statearr_34676;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34626__$1,(37),inst_34542);
} else {
if((state_val_34627 === (17))){
var inst_34490 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34677_34761 = state_34626__$1;
(statearr_34677_34761[(2)] = inst_34490);

(statearr_34677_34761[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (3))){
var inst_34624 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34626__$1,inst_34624);
} else {
if((state_val_34627 === (12))){
var inst_34436 = (state_34626[(22)]);
var inst_34440 = (state_34626[(2)]);
var inst_34441 = fluree.db.util.async.throw_err(inst_34440);
var inst_34442 = [inst_34441,r];
var inst_34443 = (new cljs.core.PersistentVector(null,2,(5),inst_34436,inst_34442,null));
var state_34626__$1 = state_34626;
var statearr_34678_34762 = state_34626__$1;
(statearr_34678_34762[(2)] = inst_34443);

(statearr_34678_34762[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (2))){
var _ = (function (){var statearr_34679 = state_34626;
(statearr_34679[(4)] = cljs.core.cons((5),(state_34626[(4)])));

return statearr_34679;
})();
var inst_34426 = cljs.core.map_QMARK_(clause);
var state_34626__$1 = state_34626;
if(inst_34426){
var statearr_34680_34763 = state_34626__$1;
(statearr_34680_34763[(1)] = (6));

} else {
var statearr_34681_34764 = state_34626__$1;
(statearr_34681_34764[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (23))){
var inst_34475 = (state_34626[(19)]);
var inst_34466 = (state_34626[(13)]);
var inst_34458 = inst_34466;
var inst_34459 = inst_34475;
var state_34626__$1 = (function (){var statearr_34682 = state_34626;
(statearr_34682[(15)] = inst_34459);

(statearr_34682[(16)] = inst_34458);

return statearr_34682;
})();
var statearr_34683_34765 = state_34626__$1;
(statearr_34683_34765[(2)] = null);

(statearr_34683_34765[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (47))){
var inst_34611 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34684_34766 = state_34626__$1;
(statearr_34684_34766[(2)] = inst_34611);

(statearr_34684_34766[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (35))){
var inst_34549 = cljs.core.count(clause);
var inst_34550 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_34549);
var state_34626__$1 = state_34626;
if(inst_34550){
var statearr_34685_34767 = state_34626__$1;
(statearr_34685_34767[(1)] = (38));

} else {
var statearr_34686_34768 = state_34626__$1;
(statearr_34686_34768[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (19))){
var inst_34459 = (state_34626[(15)]);
var inst_34484 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34485 = [inst_34459,r];
var inst_34486 = (new cljs.core.PersistentVector(null,2,(5),inst_34484,inst_34485,null));
var state_34626__$1 = state_34626;
var statearr_34687_34769 = state_34626__$1;
(statearr_34687_34769[(2)] = inst_34486);

(statearr_34687_34769[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (57))){
var state_34626__$1 = state_34626;
var statearr_34688_34770 = state_34626__$1;
(statearr_34688_34770[(2)] = null);

(statearr_34688_34770[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (11))){
var inst_34522 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34690_34771 = state_34626__$1;
(statearr_34690_34771[(2)] = inst_34522);

(statearr_34690_34771[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (9))){
var inst_34436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34437 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_34438 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_34437,res,fuel,max_fuel,opts);
var state_34626__$1 = (function (){var statearr_34691 = state_34626;
(statearr_34691[(22)] = inst_34436);

return statearr_34691;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34626__$1,(12),inst_34438);
} else {
if((state_val_34627 === (5))){
var _ = (function (){var statearr_34692 = state_34626;
(statearr_34692[(4)] = cljs.core.rest((state_34626[(4)])));

return statearr_34692;
})();
var state_34626__$1 = state_34626;
var ex34689 = (state_34626__$1[(2)]);
var statearr_34693_34772 = state_34626__$1;
(statearr_34693_34772[(5)] = ex34689);


if((ex34689 instanceof Error)){
var statearr_34694_34773 = state_34626__$1;
(statearr_34694_34773[(1)] = (4));

(statearr_34694_34773[(5)] = null);

} else {
throw ex34689;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (14))){
var inst_34433 = (state_34626[(11)]);
var inst_34429 = (state_34626[(17)]);
var inst_34492 = (function (){var G__34695 = cljs.core.cst$kw$bind;
var G__34696 = inst_34429;
return (inst_34433.cljs$core$IFn$_invoke$arity$2 ? inst_34433.cljs$core$IFn$_invoke$arity$2(G__34695,G__34696) : inst_34433.call(null,G__34695,G__34696));
})();
var state_34626__$1 = state_34626;
if(cljs.core.truth_(inst_34492)){
var statearr_34697_34774 = state_34626__$1;
(statearr_34697_34774[(1)] = (25));

} else {
var statearr_34698_34775 = state_34626__$1;
(statearr_34698_34775[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (45))){
var inst_34573 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_34626__$1 = state_34626;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34626__$1,(48),inst_34573);
} else {
if((state_val_34627 === (53))){
var inst_34577 = (state_34626[(8)]);
var inst_34578 = (state_34626[(9)]);
var inst_34589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34590 = fluree.db.query.analytical.full_text__GT_tuples(inst_34577,res,inst_34578);
var inst_34591 = [inst_34590,r];
var inst_34592 = (new cljs.core.PersistentVector(null,2,(5),inst_34589,inst_34591,null));
var state_34626__$1 = state_34626;
var statearr_34699_34776 = state_34626__$1;
(statearr_34699_34776[(2)] = inst_34592);

(statearr_34699_34776[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (26))){
var inst_34433 = (state_34626[(11)]);
var inst_34429 = (state_34626[(17)]);
var inst_34504 = (function (){var G__34700 = cljs.core.cst$kw$filter;
var G__34701 = inst_34429;
return (inst_34433.cljs$core$IFn$_invoke$arity$2 ? inst_34433.cljs$core$IFn$_invoke$arity$2(G__34700,G__34701) : inst_34433.call(null,G__34700,G__34701));
})();
var state_34626__$1 = state_34626;
if(cljs.core.truth_(inst_34504)){
var statearr_34702_34777 = state_34626__$1;
(statearr_34702_34777[(1)] = (28));

} else {
var statearr_34703_34778 = state_34626__$1;
(statearr_34703_34778[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (16))){
var inst_34458 = (state_34626[(16)]);
var inst_34465 = (state_34626[(18)]);
var inst_34464 = cljs.core.seq(inst_34458);
var inst_34465__$1 = cljs.core.first(inst_34464);
var inst_34466 = cljs.core.next(inst_34464);
var state_34626__$1 = (function (){var statearr_34704 = state_34626;
(statearr_34704[(13)] = inst_34466);

(statearr_34704[(18)] = inst_34465__$1);

return statearr_34704;
})();
if(cljs.core.truth_(inst_34465__$1)){
var statearr_34705_34779 = state_34626__$1;
(statearr_34705_34779[(1)] = (18));

} else {
var statearr_34706_34780 = state_34626__$1;
(statearr_34706_34780[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (38))){
var inst_34552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34553 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_34626__$1 = (function (){var statearr_34707 = state_34626;
(statearr_34707[(20)] = inst_34552);

return statearr_34707;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34626__$1,(41),inst_34553);
} else {
if((state_val_34627 === (30))){
var inst_34516 = (state_34626[(2)]);
var state_34626__$1 = state_34626;
var statearr_34708_34781 = state_34626__$1;
(statearr_34708_34781[(2)] = inst_34516);

(statearr_34708_34781[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (10))){
var inst_34433 = (state_34626[(11)]);
var inst_34429 = (state_34626[(17)]);
var inst_34445 = (function (){var G__34709 = cljs.core.cst$kw$union;
var G__34710 = inst_34429;
return (inst_34433.cljs$core$IFn$_invoke$arity$2 ? inst_34433.cljs$core$IFn$_invoke$arity$2(G__34709,G__34710) : inst_34433.call(null,G__34709,G__34710));
})();
var state_34626__$1 = state_34626;
if(cljs.core.truth_(inst_34445)){
var statearr_34711_34782 = state_34626__$1;
(statearr_34711_34782[(1)] = (13));

} else {
var statearr_34712_34783 = state_34626__$1;
(statearr_34712_34783[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (18))){
var inst_34465 = (state_34626[(18)]);
var inst_34468 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_34465,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_34465,q_map,vars,fuel,max_fuel,opts));
var state_34626__$1 = state_34626;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34626__$1,(21),inst_34468);
} else {
if((state_val_34627 === (52))){
var inst_34583 = (state_34626[(2)]);
var inst_34584 = fluree.db.util.async.throw_err(inst_34583);
var state_34626__$1 = state_34626;
var statearr_34713_34784 = state_34626__$1;
(statearr_34713_34784[(2)] = inst_34584);

(statearr_34713_34784[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (42))){
var inst_34563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34564 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_34565 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_34564);
var inst_34566 = [inst_34565,r];
var inst_34567 = (new cljs.core.PersistentVector(null,2,(5),inst_34563,inst_34566,null));
var state_34626__$1 = state_34626;
var statearr_34714_34785 = state_34626__$1;
(statearr_34714_34785[(2)] = inst_34567);

(statearr_34714_34785[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (37))){
var inst_34541 = (state_34626[(21)]);
var inst_34544 = (state_34626[(2)]);
var inst_34545 = fluree.db.util.async.throw_err(inst_34544);
var inst_34546 = [inst_34545,r];
var inst_34547 = (new cljs.core.PersistentVector(null,2,(5),inst_34541,inst_34546,null));
var state_34626__$1 = state_34626;
var statearr_34715_34786 = state_34626__$1;
(statearr_34715_34786[(2)] = inst_34547);

(statearr_34715_34786[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (8))){
var inst_34621 = (state_34626[(2)]);
var _ = (function (){var statearr_34716 = state_34626;
(statearr_34716[(4)] = cljs.core.rest((state_34626[(4)])));

return statearr_34716;
})();
var state_34626__$1 = state_34626;
var statearr_34717_34787 = state_34626__$1;
(statearr_34717_34787[(2)] = inst_34621);

(statearr_34717_34787[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34627 === (49))){
var inst_34578 = (state_34626[(9)]);
var inst_34581 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_34578,r,res,optional_QMARK_,fuel,max_fuel);
var state_34626__$1 = state_34626;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34626__$1,(52),inst_34581);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto____0 = (function (){
var statearr_34718 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34718[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto__);

(statearr_34718[(1)] = (1));

return statearr_34718;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto____1 = (function (state_34626){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_34626);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e34719){var ex__13886__auto__ = e34719;
var statearr_34720_34788 = state_34626;
(statearr_34720_34788[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_34626[(4)]))){
var statearr_34721_34789 = state_34626;
(statearr_34721_34789[(1)] = cljs.core.first((state_34626[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__34790 = state_34626;
state_34626 = G__34790;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto__ = function(state_34626){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto____1.call(this,state_34626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_34722 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_34722[(6)] = c__13957__auto__);

return statearr_34722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__34792 = arguments.length;
switch (G__34792) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_34872){
var state_val_34873 = (state_34872[(1)]);
if((state_val_34873 === (7))){
var inst_34867 = (state_34872[(2)]);
var _ = (function (){var statearr_34874 = state_34872;
(statearr_34874[(4)] = cljs.core.rest((state_34872[(4)])));

return statearr_34874;
})();
var state_34872__$1 = state_34872;
var statearr_34875_34923 = state_34872__$1;
(statearr_34875_34923[(2)] = inst_34867);

(statearr_34875_34923[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (20))){
var inst_34832 = (state_34872[(7)]);
var inst_34844 = (state_34872[(2)]);
var inst_34814 = inst_34832;
var inst_34815 = inst_34844;
var state_34872__$1 = (function (){var statearr_34876 = state_34872;
(statearr_34876[(8)] = inst_34814);

(statearr_34876[(9)] = inst_34815);

return statearr_34876;
})();
var statearr_34877_34924 = state_34872__$1;
(statearr_34877_34924[(2)] = null);

(statearr_34877_34924[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (1))){
var state_34872__$1 = state_34872;
var statearr_34878_34925 = state_34872__$1;
(statearr_34878_34925[(2)] = null);

(statearr_34878_34925[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (24))){
var inst_34831 = (state_34872[(10)]);
var inst_34832 = (state_34872[(7)]);
var inst_34815 = (state_34872[(9)]);
var inst_34852 = fluree.db.query.analytical.inner_join(inst_34815,inst_34831);
var inst_34814 = inst_34832;
var inst_34815__$1 = inst_34852;
var state_34872__$1 = (function (){var statearr_34879 = state_34872;
(statearr_34879[(8)] = inst_34814);

(statearr_34879[(9)] = inst_34815__$1);

return statearr_34879;
})();
var statearr_34880_34926 = state_34872__$1;
(statearr_34880_34926[(2)] = null);

(statearr_34880_34926[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (4))){
var inst_34793 = (state_34872[(2)]);
var state_34872__$1 = state_34872;
var statearr_34882_34927 = state_34872__$1;
(statearr_34882_34927[(2)] = inst_34793);

(statearr_34882_34927[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (15))){
var inst_34831 = (state_34872[(10)]);
var state_34872__$1 = state_34872;
if(cljs.core.truth_(inst_34831)){
var statearr_34883_34928 = state_34872__$1;
(statearr_34883_34928[(1)] = (18));

} else {
var statearr_34884_34929 = state_34872__$1;
(statearr_34884_34929[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (21))){
var inst_34832 = (state_34872[(7)]);
var inst_34815 = (state_34872[(9)]);
var tmp34881 = inst_34815;
var inst_34814 = inst_34832;
var inst_34815__$1 = tmp34881;
var state_34872__$1 = (function (){var statearr_34885 = state_34872;
(statearr_34885[(8)] = inst_34814);

(statearr_34885[(9)] = inst_34815__$1);

return statearr_34885;
})();
var statearr_34886_34930 = state_34872__$1;
(statearr_34886_34930[(2)] = null);

(statearr_34886_34930[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (13))){
var inst_34815 = (state_34872[(9)]);
var inst_34838 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_34815,cljs.core.cst$kw$vars);
var inst_34839 = cljs.core.empty_QMARK_(inst_34838);
var state_34872__$1 = state_34872;
if(inst_34839){
var statearr_34887_34931 = state_34872__$1;
(statearr_34887_34931[(1)] = (15));

} else {
var statearr_34888_34932 = state_34872__$1;
(statearr_34888_34932[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (22))){
var state_34872__$1 = state_34872;
var statearr_34889_34933 = state_34872__$1;
(statearr_34889_34933[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (6))){
var inst_34814 = (state_34872[(8)]);
var inst_34821 = (state_34872[(11)]);
var inst_34820 = cljs.core.seq(inst_34814);
var inst_34821__$1 = cljs.core.first(inst_34820);
var inst_34822 = cljs.core.next(inst_34820);
var state_34872__$1 = (function (){var statearr_34891 = state_34872;
(statearr_34891[(12)] = inst_34822);

(statearr_34891[(11)] = inst_34821__$1);

return statearr_34891;
})();
if(cljs.core.truth_(inst_34821__$1)){
var statearr_34892_34934 = state_34872__$1;
(statearr_34892_34934[(1)] = (8));

} else {
var statearr_34893_34935 = state_34872__$1;
(statearr_34893_34935[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (25))){
var state_34872__$1 = state_34872;
var statearr_34894_34936 = state_34872__$1;
(statearr_34894_34936[(2)] = null);

(statearr_34894_34936[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (17))){
var inst_34860 = (state_34872[(2)]);
var state_34872__$1 = state_34872;
var statearr_34895_34937 = state_34872__$1;
(statearr_34895_34937[(2)] = inst_34860);

(statearr_34895_34937[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (3))){
var inst_34870 = (state_34872[(2)]);
var state_34872__$1 = state_34872;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34872__$1,inst_34870);
} else {
if((state_val_34873 === (12))){
var inst_34831 = (state_34872[(10)]);
var inst_34832 = (state_34872[(7)]);
var inst_34814 = inst_34832;
var inst_34815 = inst_34831;
var state_34872__$1 = (function (){var statearr_34896 = state_34872;
(statearr_34896[(8)] = inst_34814);

(statearr_34896[(9)] = inst_34815);

return statearr_34896;
})();
var statearr_34897_34938 = state_34872__$1;
(statearr_34897_34938[(2)] = null);

(statearr_34897_34938[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (2))){
var _ = (function (){var statearr_34898 = state_34872;
(statearr_34898[(4)] = cljs.core.cons((5),(state_34872[(4)])));

return statearr_34898;
})();
var inst_34806 = where;
var inst_34807 = cljs.core.seq(inst_34806);
var inst_34808 = cljs.core.first(inst_34807);
var inst_34809 = cljs.core.next(inst_34807);
var inst_34810 = [cljs.core.cst$kw$vars];
var inst_34811 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_34812 = [inst_34811];
var inst_34813 = cljs.core.PersistentHashMap.fromArrays(inst_34810,inst_34812);
var inst_34814 = inst_34806;
var inst_34815 = inst_34813;
var state_34872__$1 = (function (){var statearr_34899 = state_34872;
(statearr_34899[(13)] = inst_34808);

(statearr_34899[(8)] = inst_34814);

(statearr_34899[(14)] = inst_34809);

(statearr_34899[(9)] = inst_34815);

return statearr_34899;
})();
var statearr_34900_34939 = state_34872__$1;
(statearr_34900_34939[(2)] = null);

(statearr_34900_34939[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (23))){
var inst_34858 = (state_34872[(2)]);
var state_34872__$1 = state_34872;
var statearr_34901_34940 = state_34872__$1;
(statearr_34901_34940[(2)] = inst_34858);

(statearr_34901_34940[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (19))){
var inst_34815 = (state_34872[(9)]);
var state_34872__$1 = state_34872;
var statearr_34902_34941 = state_34872__$1;
(statearr_34902_34941[(2)] = inst_34815);

(statearr_34902_34941[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (11))){
var inst_34821 = (state_34872[(11)]);
var inst_34829 = (state_34872[(2)]);
var inst_34830 = fluree.db.util.async.throw_err(inst_34829);
var inst_34831 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34830,(0),null);
var inst_34832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34830,(1),null);
var inst_34833 = cljs.core.count(inst_34821);
var inst_34834 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_34833);
var state_34872__$1 = (function (){var statearr_34904 = state_34872;
(statearr_34904[(10)] = inst_34831);

(statearr_34904[(7)] = inst_34832);

return statearr_34904;
})();
if(inst_34834){
var statearr_34905_34942 = state_34872__$1;
(statearr_34905_34942[(1)] = (12));

} else {
var statearr_34906_34943 = state_34872__$1;
(statearr_34906_34943[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (9))){
var inst_34815 = (state_34872[(9)]);
var state_34872__$1 = state_34872;
var statearr_34907_34944 = state_34872__$1;
(statearr_34907_34944[(2)] = inst_34815);

(statearr_34907_34944[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (5))){
var _ = (function (){var statearr_34908 = state_34872;
(statearr_34908[(4)] = cljs.core.rest((state_34872[(4)])));

return statearr_34908;
})();
var state_34872__$1 = state_34872;
var ex34903 = (state_34872__$1[(2)]);
var statearr_34909_34945 = state_34872__$1;
(statearr_34909_34945[(5)] = ex34903);


if((ex34903 instanceof Error)){
var statearr_34910_34946 = state_34872__$1;
(statearr_34910_34946[(1)] = (4));

(statearr_34910_34946[(5)] = null);

} else {
throw ex34903;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (14))){
var inst_34862 = (state_34872[(2)]);
var state_34872__$1 = state_34872;
var statearr_34911_34947 = state_34872__$1;
(statearr_34911_34947[(2)] = inst_34862);

(statearr_34911_34947[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (26))){
var inst_34856 = (state_34872[(2)]);
var state_34872__$1 = state_34872;
var statearr_34912_34948 = state_34872__$1;
(statearr_34912_34948[(2)] = inst_34856);

(statearr_34912_34948[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (16))){
var inst_34831 = (state_34872[(10)]);
var inst_34847 = (inst_34831 == null);
var state_34872__$1 = state_34872;
if(cljs.core.truth_(inst_34847)){
var statearr_34913_34949 = state_34872__$1;
(statearr_34913_34949[(1)] = (21));

} else {
var statearr_34914_34950 = state_34872__$1;
(statearr_34914_34950[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (10))){
var inst_34865 = (state_34872[(2)]);
var state_34872__$1 = state_34872;
var statearr_34915_34951 = state_34872__$1;
(statearr_34915_34951[(2)] = inst_34865);

(statearr_34915_34951[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (18))){
var inst_34831 = (state_34872[(10)]);
var state_34872__$1 = state_34872;
var statearr_34916_34952 = state_34872__$1;
(statearr_34916_34952[(2)] = inst_34831);

(statearr_34916_34952[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34873 === (8))){
var inst_34822 = (state_34872[(12)]);
var inst_34821 = (state_34872[(11)]);
var inst_34815 = (state_34872[(9)]);
var inst_34827 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_34815,inst_34821,inst_34822,false,fuel,max_fuel,opts);
var state_34872__$1 = state_34872;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34872__$1,(11),inst_34827);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__13883__auto__ = null;
var fluree$db$query$analytical$state_machine__13883__auto____0 = (function (){
var statearr_34917 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34917[(0)] = fluree$db$query$analytical$state_machine__13883__auto__);

(statearr_34917[(1)] = (1));

return statearr_34917;
});
var fluree$db$query$analytical$state_machine__13883__auto____1 = (function (state_34872){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_34872);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e34918){var ex__13886__auto__ = e34918;
var statearr_34919_34953 = state_34872;
(statearr_34919_34953[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_34872[(4)]))){
var statearr_34920_34954 = state_34872;
(statearr_34920_34954[(1)] = cljs.core.first((state_34872[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__34955 = state_34872;
state_34872 = G__34955;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__13883__auto__ = function(state_34872){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__13883__auto____1.call(this,state_34872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__13883__auto____0;
fluree$db$query$analytical$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__13883__auto____1;
return fluree$db$query$analytical$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_34921 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_34921[(6)] = c__13957__auto__);

return statearr_34921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_34990){
var state_val_34991 = (state_34990[(1)]);
if((state_val_34991 === (7))){
var inst_34972 = (state_34990[(7)]);
var inst_34967 = (state_34990[(8)]);
var inst_34974 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_34967,inst_34972,fuel,max_fuel,opts);
var state_34990__$1 = state_34990;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34990__$1,(10),inst_34974);
} else {
if((state_val_34991 === (1))){
var state_34990__$1 = state_34990;
var statearr_34992_35017 = state_34990__$1;
(statearr_34992_35017[(2)] = null);

(statearr_34992_35017[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34991 === (4))){
var inst_34956 = (state_34990[(2)]);
var state_34990__$1 = state_34990;
var statearr_34993_35018 = state_34990__$1;
(statearr_34993_35018[(2)] = inst_34956);

(statearr_34993_35018[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34991 === (13))){
var inst_34985 = (state_34990[(2)]);
var _ = (function (){var statearr_34994 = state_34990;
(statearr_34994[(4)] = cljs.core.rest((state_34990[(4)])));

return statearr_34994;
})();
var state_34990__$1 = state_34990;
var statearr_34995_35019 = state_34990__$1;
(statearr_34995_35019[(2)] = inst_34985);

(statearr_34995_35019[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34991 === (6))){
var inst_34967 = (state_34990[(8)]);
var inst_34971 = (state_34990[(2)]);
var inst_34972 = fluree.db.util.async.throw_err(inst_34971);
var state_34990__$1 = (function (){var statearr_34996 = state_34990;
(statearr_34996[(7)] = inst_34972);

return statearr_34996;
})();
if(cljs.core.truth_(inst_34967)){
var statearr_34997_35020 = state_34990__$1;
(statearr_34997_35020[(1)] = (7));

} else {
var statearr_34998_35021 = state_34990__$1;
(statearr_34998_35021[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34991 === (3))){
var inst_34988 = (state_34990[(2)]);
var state_34990__$1 = state_34990;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34990__$1,inst_34988);
} else {
if((state_val_34991 === (12))){
var inst_34980 = (state_34990[(9)]);
var state_34990__$1 = state_34990;
var statearr_34999_35022 = state_34990__$1;
(statearr_34999_35022[(2)] = inst_34980);

(statearr_34999_35022[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34991 === (2))){
var _ = (function (){var statearr_35000 = state_34990;
(statearr_35000[(4)] = cljs.core.cons((5),(state_34990[(4)])));

return statearr_35000;
})();
var inst_34963 = q_map;
var inst_34964 = cljs.core.__destructure_map(inst_34963);
var inst_34965 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34964,cljs.core.cst$kw$vars);
var inst_34966 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34964,cljs.core.cst$kw$where);
var inst_34967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34964,cljs.core.cst$kw$optional);
var inst_34968 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34964,cljs.core.cst$kw$filter);
var inst_34969 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_34966,q_map,inst_34965,fuel,max_fuel,opts);
var state_34990__$1 = (function (){var statearr_35001 = state_34990;
(statearr_35001[(10)] = inst_34968);

(statearr_35001[(8)] = inst_34967);

return statearr_35001;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34990__$1,(6),inst_34969);
} else {
if((state_val_34991 === (11))){
var inst_34980 = (state_34990[(9)]);
var inst_34968 = (state_34990[(10)]);
var inst_34982 = fluree.db.query.analytical.tuples__GT_filtered(inst_34980,inst_34968,null);
var state_34990__$1 = state_34990;
var statearr_35003_35023 = state_34990__$1;
(statearr_35003_35023[(2)] = inst_34982);

(statearr_35003_35023[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34991 === (9))){
var inst_34968 = (state_34990[(10)]);
var inst_34980 = (state_34990[(2)]);
var state_34990__$1 = (function (){var statearr_35004 = state_34990;
(statearr_35004[(9)] = inst_34980);

return statearr_35004;
})();
if(cljs.core.truth_(inst_34968)){
var statearr_35005_35024 = state_34990__$1;
(statearr_35005_35024[(1)] = (11));

} else {
var statearr_35006_35025 = state_34990__$1;
(statearr_35006_35025[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34991 === (5))){
var _ = (function (){var statearr_35007 = state_34990;
(statearr_35007[(4)] = cljs.core.rest((state_34990[(4)])));

return statearr_35007;
})();
var state_34990__$1 = state_34990;
var ex35002 = (state_34990__$1[(2)]);
var statearr_35008_35026 = state_34990__$1;
(statearr_35008_35026[(5)] = ex35002);


if((ex35002 instanceof Error)){
var statearr_35009_35027 = state_34990__$1;
(statearr_35009_35027[(1)] = (4));

(statearr_35009_35027[(5)] = null);

} else {
throw ex35002;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34991 === (10))){
var inst_34976 = (state_34990[(2)]);
var inst_34977 = fluree.db.util.async.throw_err(inst_34976);
var state_34990__$1 = state_34990;
var statearr_35010_35028 = state_34990__$1;
(statearr_35010_35028[(2)] = inst_34977);

(statearr_35010_35028[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34991 === (8))){
var inst_34972 = (state_34990[(7)]);
var state_34990__$1 = state_34990;
var statearr_35011_35029 = state_34990__$1;
(statearr_35011_35029[(2)] = inst_34972);

(statearr_35011_35029[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__13883__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__13883__auto____0 = (function (){
var statearr_35012 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35012[(0)] = fluree$db$query$analytical$q_$_state_machine__13883__auto__);

(statearr_35012[(1)] = (1));

return statearr_35012;
});
var fluree$db$query$analytical$q_$_state_machine__13883__auto____1 = (function (state_34990){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_34990);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e35013){var ex__13886__auto__ = e35013;
var statearr_35014_35030 = state_34990;
(statearr_35014_35030[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_34990[(4)]))){
var statearr_35015_35031 = state_34990;
(statearr_35015_35031[(1)] = cljs.core.first((state_34990[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__35032 = state_34990;
state_34990 = G__35032;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__13883__auto__ = function(state_34990){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__13883__auto____1.call(this,state_34990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__13883__auto____0;
fluree$db$query$analytical$q_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__13883__auto____1;
return fluree$db$query$analytical$q_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_35016 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_35016[(6)] = c__13957__auto__);

return statearr_35016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
