// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.serde.json');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.log');
fluree.db.serde.json.deserialize_block = (function fluree$db$serde$json$deserialize_block(block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,cljs.core.cst$kw$flakes,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.parts__GT_Flake,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(block)));
});
/**
 * Turns :first and :rhs into flakes
 */
fluree.db.serde.json.deserialize_child_node = (function fluree$db$serde$json$deserialize_child_node(child_node){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(child_node,cljs.core.cst$kw$first,(function (){var G__74666 = cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(child_node);
if((G__74666 == null)){
return null;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(G__74666);
}
})(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$rhs,(function (){var G__74667 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(child_node);
if((G__74667 == null)){
return null;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(G__74667);
}
})()], 0));
});
fluree.db.serde.json.deserialize_db_root = (function fluree$db$serde$json$deserialize_db_root(db_root){
var map__74668 = db_root;
var map__74668__$1 = cljs.core.__destructure_map(map__74668);
var spot = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74668__$1,cljs.core.cst$kw$spot);
var psot = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74668__$1,cljs.core.cst$kw$psot);
var post = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74668__$1,cljs.core.cst$kw$post);
var opst = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74668__$1,cljs.core.cst$kw$opst);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db_root,cljs.core.cst$kw$spot,fluree.db.serde.json.deserialize_child_node(spot),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$psot,fluree.db.serde.json.deserialize_child_node(psot),cljs.core.cst$kw$post,fluree.db.serde.json.deserialize_child_node(post),cljs.core.cst$kw$opst,fluree.db.serde.json.deserialize_child_node(opst)], 0));
});
fluree.db.serde.json.deserialize_branch_node = (function fluree$db$serde$json$deserialize_branch_node(branch){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(branch,cljs.core.cst$kw$children,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.serde.json.deserialize_child_node,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(branch)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$rhs,(function (){var G__74669 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(branch);
if((G__74669 == null)){
return null;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(G__74669);
}
})()], 0));
});
fluree.db.serde.json.deserialize_leaf_node = (function fluree$db$serde$json$deserialize_leaf_node(leaf){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(leaf,cljs.core.cst$kw$flakes,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.parts__GT_Flake,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(leaf)));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.serde.protocol.StorageSerializer}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.serde.json.Serializer = (function (__meta,__extmap,__hash){
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.serde.json.Serializer.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k74671,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__74675 = k74671;
switch (G__74675) {
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k74671,else__4418__auto__);

}
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__74676){
var vec__74677 = p__74676;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74677,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74677,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.serde.json.Serializer{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,self__.__extmap));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__74670){
var self__ = this;
var G__74670__$1 = this;
return (new cljs.core.RecordIter((0),G__74670__$1,0,cljs.core.PersistentVector.EMPTY,(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.serde.json.Serializer(self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (0 + cljs.core.count(self__.__extmap));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__74680 = (function (coll__4412__auto__){
return (1505122844 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__74680(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this74672,other74673){
var self__ = this;
var this74672__$1 = this;
return (((!((other74673 == null)))) && ((this74672__$1.constructor === other74673.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74672__$1.__extmap,other74673.__extmap)));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(cljs.core.PersistentHashSet.EMPTY,k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.serde.json.Serializer(self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__74670){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__74681 = cljs.core.keyword_identical_QMARK_;
var expr__74682 = k__4423__auto__;
return (new fluree.db.serde.json.Serializer(self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__74670),null));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,self__.__extmap));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__74670){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.serde.json.Serializer(G__74670,self__.__extmap,self__.__hash));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_block$arity$2 = (function (_,block){
var self__ = this;
var ___$1 = this;
return fluree.db.serde.json.deserialize_block(fluree.db.util.json.parse(block));
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_branch$arity$2 = (function (_,branch){
var self__ = this;
var ___$1 = this;
return fluree.db.serde.json.deserialize_branch_node(fluree.db.util.json.parse(branch));
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_garbage$arity$2 = (function (_,garbage){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-garbage not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_db_pointer$arity$2 = (function (_,pointer){
var self__ = this;
var ___$1 = this;
return fluree.db.util.json.parse(pointer);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_db_root$arity$2 = (function (_,db_root){
var self__ = this;
var ___$1 = this;
return fluree.db.serde.json.deserialize_db_root(fluree.db.util.json.parse(db_root));
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_branch$arity$2 = (function (_,branch){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-branch not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_garbage$arity$2 = (function (_,garbage){
var self__ = this;
var ___$1 = this;
return fluree.db.util.json.parse(garbage);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_leaf$arity$2 = (function (_,leaf){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-leaf not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_db_pointer$arity$2 = (function (_,pointer){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-db-pointer not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_leaf$arity$2 = (function (_,leaf){
var self__ = this;
var ___$1 = this;
return fluree.db.serde.json.deserialize_leaf_node(fluree.db.util.json.parse(leaf));
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_db_root$arity$2 = (function (_,db_root){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-db-root not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_block$arity$2 = (function (_,block){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-block not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.serde.json.Serializer.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(fluree.db.serde.json.Serializer.cljs$lang$type = true);

(fluree.db.serde.json.Serializer.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.serde.json/Serializer",null,(1),null));
}));

(fluree.db.serde.json.Serializer.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.serde.json/Serializer");
}));

/**
 * Positional factory function for fluree.db.serde.json/Serializer.
 */
fluree.db.serde.json.__GT_Serializer = (function fluree$db$serde$json$__GT_Serializer(){
return (new fluree.db.serde.json.Serializer(null,null,null));
});

/**
 * Factory function for fluree.db.serde.json/Serializer, taking a map of keywords to field values.
 */
fluree.db.serde.json.map__GT_Serializer = (function fluree$db$serde$json$map__GT_Serializer(G__74674){
var extmap__4454__auto__ = (function (){var G__74684 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(G__74674);
if(cljs.core.record_QMARK_(G__74674)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__74684);
} else {
return G__74684;
}
})();
return (new fluree.db.serde.json.Serializer(null,cljs.core.not_empty(extmap__4454__auto__),null));
});

/**
 * Returns a JSON serializer / deserializer
 */
fluree.db.serde.json.json_serde = (function fluree$db$serde$json$json_serde(){
return fluree.db.serde.json.__GT_Serializer();
});
