// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30842){
var state_val_30843 = (state_30842[(1)]);
if((state_val_30843 === (7))){
var inst_30831 = (state_30842[(7)]);
var inst_30833 = fluree.db.storage.core.serde(conn);
var inst_30834 = fluree.db.serde.protocol._deserialize_block(inst_30833,inst_30831);
var state_30842__$1 = state_30842;
var statearr_30844_30863 = state_30842__$1;
(statearr_30844_30863[(2)] = inst_30834);

(statearr_30844_30863[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30843 === (1))){
var state_30842__$1 = state_30842;
var statearr_30845_30864 = state_30842__$1;
(statearr_30845_30864[(2)] = null);

(statearr_30845_30864[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30843 === (4))){
var inst_30821 = (state_30842[(2)]);
var state_30842__$1 = state_30842;
var statearr_30846_30865 = state_30842__$1;
(statearr_30846_30865[(2)] = inst_30821);

(statearr_30846_30865[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30843 === (6))){
var inst_30831 = (state_30842[(7)]);
var inst_30830 = (state_30842[(2)]);
var inst_30831__$1 = fluree.db.util.async.throw_err(inst_30830);
var state_30842__$1 = (function (){var statearr_30847 = state_30842;
(statearr_30847[(7)] = inst_30831__$1);

return statearr_30847;
})();
if(cljs.core.truth_(inst_30831__$1)){
var statearr_30848_30866 = state_30842__$1;
(statearr_30848_30866[(1)] = (7));

} else {
var statearr_30849_30867 = state_30842__$1;
(statearr_30849_30867[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30843 === (3))){
var inst_30840 = (state_30842[(2)]);
var state_30842__$1 = state_30842;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30842__$1,inst_30840);
} else {
if((state_val_30843 === (2))){
var _ = (function (){var statearr_30851 = state_30842;
(statearr_30851[(4)] = cljs.core.cons((5),(state_30842[(4)])));

return statearr_30851;
})();
var inst_30827 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_30828 = fluree.db.storage.core.storage_read(conn,inst_30827);
var state_30842__$1 = state_30842;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30842__$1,(6),inst_30828);
} else {
if((state_val_30843 === (9))){
var inst_30837 = (state_30842[(2)]);
var _ = (function (){var statearr_30852 = state_30842;
(statearr_30852[(4)] = cljs.core.rest((state_30842[(4)])));

return statearr_30852;
})();
var state_30842__$1 = state_30842;
var statearr_30853_30868 = state_30842__$1;
(statearr_30853_30868[(2)] = inst_30837);

(statearr_30853_30868[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30843 === (5))){
var _ = (function (){var statearr_30854 = state_30842;
(statearr_30854[(4)] = cljs.core.rest((state_30842[(4)])));

return statearr_30854;
})();
var state_30842__$1 = state_30842;
var ex30850 = (state_30842__$1[(2)]);
var statearr_30855_30869 = state_30842__$1;
(statearr_30855_30869[(5)] = ex30850);


if((ex30850 instanceof Error)){
var statearr_30856_30870 = state_30842__$1;
(statearr_30856_30870[(1)] = (4));

(statearr_30856_30870[(5)] = null);

} else {
throw ex30850;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30843 === (8))){
var state_30842__$1 = state_30842;
var statearr_30857_30871 = state_30842__$1;
(statearr_30857_30871[(2)] = null);

(statearr_30857_30871[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__13883__auto____0 = (function (){
var statearr_30858 = [null,null,null,null,null,null,null,null];
(statearr_30858[(0)] = fluree$db$storage$core$read_block_$_state_machine__13883__auto__);

(statearr_30858[(1)] = (1));

return statearr_30858;
});
var fluree$db$storage$core$read_block_$_state_machine__13883__auto____1 = (function (state_30842){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30842);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30859){var ex__13886__auto__ = e30859;
var statearr_30860_30872 = state_30842;
(statearr_30860_30872[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30842[(4)]))){
var statearr_30861_30873 = state_30842;
(statearr_30861_30873[(1)] = cljs.core.first((state_30842[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30874 = state_30842;
state_30842 = G__30874;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__13883__auto__ = function(state_30842){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__13883__auto____1.call(this,state_30842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__13883__auto____0;
fluree$db$storage$core$read_block_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__13883__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30862 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30862[(6)] = c__13957__auto__);

return statearr_30862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30897){
var state_val_30898 = (state_30897[(1)]);
if((state_val_30898 === (7))){
var inst_30886 = (state_30897[(7)]);
var inst_30888 = fluree.db.storage.core.serde(conn);
var inst_30889 = fluree.db.serde.protocol._deserialize_block(inst_30888,inst_30886);
var state_30897__$1 = state_30897;
var statearr_30899_30918 = state_30897__$1;
(statearr_30899_30918[(2)] = inst_30889);

(statearr_30899_30918[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30898 === (1))){
var state_30897__$1 = state_30897;
var statearr_30900_30919 = state_30897__$1;
(statearr_30900_30919[(2)] = null);

(statearr_30900_30919[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30898 === (4))){
var inst_30875 = (state_30897[(2)]);
var state_30897__$1 = state_30897;
var statearr_30901_30920 = state_30897__$1;
(statearr_30901_30920[(2)] = inst_30875);

(statearr_30901_30920[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30898 === (6))){
var inst_30886 = (state_30897[(7)]);
var inst_30885 = (state_30897[(2)]);
var inst_30886__$1 = fluree.db.util.async.throw_err(inst_30885);
var state_30897__$1 = (function (){var statearr_30902 = state_30897;
(statearr_30902[(7)] = inst_30886__$1);

return statearr_30902;
})();
if(cljs.core.truth_(inst_30886__$1)){
var statearr_30903_30921 = state_30897__$1;
(statearr_30903_30921[(1)] = (7));

} else {
var statearr_30904_30922 = state_30897__$1;
(statearr_30904_30922[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30898 === (3))){
var inst_30895 = (state_30897[(2)]);
var state_30897__$1 = state_30897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30897__$1,inst_30895);
} else {
if((state_val_30898 === (2))){
var _ = (function (){var statearr_30906 = state_30897;
(statearr_30906[(4)] = cljs.core.cons((5),(state_30897[(4)])));

return statearr_30906;
})();
var inst_30881 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_30882 = [inst_30881,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_30883 = fluree.db.storage.core.storage_read(conn,inst_30882);
var state_30897__$1 = state_30897;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30897__$1,(6),inst_30883);
} else {
if((state_val_30898 === (9))){
var inst_30892 = (state_30897[(2)]);
var _ = (function (){var statearr_30907 = state_30897;
(statearr_30907[(4)] = cljs.core.rest((state_30897[(4)])));

return statearr_30907;
})();
var state_30897__$1 = state_30897;
var statearr_30908_30923 = state_30897__$1;
(statearr_30908_30923[(2)] = inst_30892);

(statearr_30908_30923[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30898 === (5))){
var _ = (function (){var statearr_30909 = state_30897;
(statearr_30909[(4)] = cljs.core.rest((state_30897[(4)])));

return statearr_30909;
})();
var state_30897__$1 = state_30897;
var ex30905 = (state_30897__$1[(2)]);
var statearr_30910_30924 = state_30897__$1;
(statearr_30910_30924[(5)] = ex30905);


if((ex30905 instanceof Error)){
var statearr_30911_30925 = state_30897__$1;
(statearr_30911_30925[(1)] = (4));

(statearr_30911_30925[(5)] = null);

} else {
throw ex30905;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30898 === (8))){
var state_30897__$1 = state_30897;
var statearr_30912_30926 = state_30897__$1;
(statearr_30912_30926[(2)] = null);

(statearr_30912_30926[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__13883__auto____0 = (function (){
var statearr_30913 = [null,null,null,null,null,null,null,null];
(statearr_30913[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__13883__auto__);

(statearr_30913[(1)] = (1));

return statearr_30913;
});
var fluree$db$storage$core$read_block_version_$_state_machine__13883__auto____1 = (function (state_30897){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30897);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30914){var ex__13886__auto__ = e30914;
var statearr_30915_30927 = state_30897;
(statearr_30915_30927[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30897[(4)]))){
var statearr_30916_30928 = state_30897;
(statearr_30916_30928[(1)] = cljs.core.first((state_30897[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30929 = state_30897;
state_30897 = G__30929;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__13883__auto__ = function(state_30897){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__13883__auto____1.call(this,state_30897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__13883__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__13883__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30917 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30917[(6)] = c__13957__auto__);

return statearr_30917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30953){
var state_val_30954 = (state_30953[(1)]);
if((state_val_30954 === (1))){
var state_30953__$1 = state_30953;
var statearr_30955_30969 = state_30953__$1;
(statearr_30955_30969[(2)] = null);

(statearr_30955_30969[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30954 === (2))){
var _ = (function (){var statearr_30956 = state_30953;
(statearr_30956[(4)] = cljs.core.cons((5),(state_30953[(4)])));

return statearr_30956;
})();
var inst_30936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30937 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_30938 = (new cljs.core.PersistentVector(null,3,(5),inst_30936,inst_30937,null));
var inst_30939 = cljs.core.select_keys(block_data,inst_30938);
var inst_30940 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_30939);
var inst_30941 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_30940);
var inst_30942 = [inst_30941,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_30943 = fluree.db.storage.core.serde(conn);
var inst_30944 = fluree.db.serde.protocol._serialize_block(inst_30943,inst_30939);
var inst_30945 = fluree.db.storage.core.storage_write(conn,inst_30942,inst_30944);
var state_30953__$1 = state_30953;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30953__$1,(6),inst_30945);
} else {
if((state_val_30954 === (3))){
var inst_30951 = (state_30953[(2)]);
var state_30953__$1 = state_30953;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30953__$1,inst_30951);
} else {
if((state_val_30954 === (4))){
var inst_30930 = (state_30953[(2)]);
var state_30953__$1 = state_30953;
var statearr_30958_30970 = state_30953__$1;
(statearr_30958_30970[(2)] = inst_30930);

(statearr_30958_30970[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30954 === (5))){
var _ = (function (){var statearr_30959 = state_30953;
(statearr_30959[(4)] = cljs.core.rest((state_30953[(4)])));

return statearr_30959;
})();
var state_30953__$1 = state_30953;
var ex30957 = (state_30953__$1[(2)]);
var statearr_30960_30971 = state_30953__$1;
(statearr_30960_30971[(5)] = ex30957);


if((ex30957 instanceof Error)){
var statearr_30961_30972 = state_30953__$1;
(statearr_30961_30972[(1)] = (4));

(statearr_30961_30972[(5)] = null);

} else {
throw ex30957;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30954 === (6))){
var inst_30947 = (state_30953[(2)]);
var inst_30948 = fluree.db.util.async.throw_err(inst_30947);
var _ = (function (){var statearr_30962 = state_30953;
(statearr_30962[(4)] = cljs.core.rest((state_30953[(4)])));

return statearr_30962;
})();
var state_30953__$1 = state_30953;
var statearr_30963_30973 = state_30953__$1;
(statearr_30963_30973[(2)] = inst_30948);

(statearr_30963_30973[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__13883__auto____0 = (function (){
var statearr_30964 = [null,null,null,null,null,null,null];
(statearr_30964[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__13883__auto__);

(statearr_30964[(1)] = (1));

return statearr_30964;
});
var fluree$db$storage$core$write_block_version_$_state_machine__13883__auto____1 = (function (state_30953){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30953);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30965){var ex__13886__auto__ = e30965;
var statearr_30966_30974 = state_30953;
(statearr_30966_30974[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30953[(4)]))){
var statearr_30967_30975 = state_30953;
(statearr_30967_30975[(1)] = cljs.core.first((state_30953[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30976 = state_30953;
state_30953 = G__30976;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__13883__auto__ = function(state_30953){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__13883__auto____1.call(this,state_30953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__13883__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__13883__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30968 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30968[(6)] = c__13957__auto__);

return statearr_30968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30999){
var state_val_31000 = (state_30999[(1)]);
if((state_val_31000 === (1))){
var state_30999__$1 = state_30999;
var statearr_31001_31015 = state_30999__$1;
(statearr_31001_31015[(2)] = null);

(statearr_31001_31015[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31000 === (2))){
var _ = (function (){var statearr_31002 = state_30999;
(statearr_31002[(4)] = cljs.core.cons((5),(state_30999[(4)])));

return statearr_31002;
})();
var inst_30983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30984 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_30985 = (new cljs.core.PersistentVector(null,3,(5),inst_30983,inst_30984,null));
var inst_30986 = cljs.core.select_keys(block_data,inst_30985);
var inst_30987 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_30986);
var inst_30988 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_30987);
var inst_30989 = fluree.db.storage.core.serde(conn);
var inst_30990 = fluree.db.serde.protocol._serialize_block(inst_30989,inst_30986);
var inst_30991 = fluree.db.storage.core.storage_write(conn,inst_30988,inst_30990);
var state_30999__$1 = state_30999;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30999__$1,(6),inst_30991);
} else {
if((state_val_31000 === (3))){
var inst_30997 = (state_30999[(2)]);
var state_30999__$1 = state_30999;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30999__$1,inst_30997);
} else {
if((state_val_31000 === (4))){
var inst_30977 = (state_30999[(2)]);
var state_30999__$1 = state_30999;
var statearr_31004_31016 = state_30999__$1;
(statearr_31004_31016[(2)] = inst_30977);

(statearr_31004_31016[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31000 === (5))){
var _ = (function (){var statearr_31005 = state_30999;
(statearr_31005[(4)] = cljs.core.rest((state_30999[(4)])));

return statearr_31005;
})();
var state_30999__$1 = state_30999;
var ex31003 = (state_30999__$1[(2)]);
var statearr_31006_31017 = state_30999__$1;
(statearr_31006_31017[(5)] = ex31003);


if((ex31003 instanceof Error)){
var statearr_31007_31018 = state_30999__$1;
(statearr_31007_31018[(1)] = (4));

(statearr_31007_31018[(5)] = null);

} else {
throw ex31003;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31000 === (6))){
var inst_30993 = (state_30999[(2)]);
var inst_30994 = fluree.db.util.async.throw_err(inst_30993);
var _ = (function (){var statearr_31008 = state_30999;
(statearr_31008[(4)] = cljs.core.rest((state_30999[(4)])));

return statearr_31008;
})();
var state_30999__$1 = state_30999;
var statearr_31009_31019 = state_30999__$1;
(statearr_31009_31019[(2)] = inst_30994);

(statearr_31009_31019[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__13883__auto____0 = (function (){
var statearr_31010 = [null,null,null,null,null,null,null];
(statearr_31010[(0)] = fluree$db$storage$core$write_block_$_state_machine__13883__auto__);

(statearr_31010[(1)] = (1));

return statearr_31010;
});
var fluree$db$storage$core$write_block_$_state_machine__13883__auto____1 = (function (state_30999){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30999);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31011){var ex__13886__auto__ = e31011;
var statearr_31012_31020 = state_30999;
(statearr_31012_31020[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30999[(4)]))){
var statearr_31013_31021 = state_30999;
(statearr_31013_31021[(1)] = cljs.core.first((state_30999[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31022 = state_30999;
state_30999 = G__31022;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__13883__auto__ = function(state_30999){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__13883__auto____1.call(this,state_30999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__13883__auto____0;
fluree$db$storage$core$write_block_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__13883__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31014 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31014[(6)] = c__13957__auto__);

return statearr_31014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31042){
var state_val_31043 = (state_31042[(1)]);
if((state_val_31043 === (1))){
var state_31042__$1 = state_31042;
var statearr_31044_31058 = state_31042__$1;
(statearr_31044_31058[(2)] = null);

(statearr_31044_31058[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31043 === (2))){
var _ = (function (){var statearr_31045 = state_31042;
(statearr_31045[(4)] = cljs.core.cons((5),(state_31042[(4)])));

return statearr_31045;
})();
var inst_31029 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_31030 = [history,next_his_key];
var inst_31031 = cljs.core.PersistentHashMap.fromArrays(inst_31029,inst_31030);
var inst_31032 = fluree.db.storage.core.serde(conn);
var inst_31033 = fluree.db.serde.protocol._serialize_leaf(inst_31032,inst_31031);
var inst_31034 = fluree.db.storage.core.storage_write(conn,his_key,inst_31033);
var state_31042__$1 = state_31042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31042__$1,(6),inst_31034);
} else {
if((state_val_31043 === (3))){
var inst_31040 = (state_31042[(2)]);
var state_31042__$1 = state_31042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31042__$1,inst_31040);
} else {
if((state_val_31043 === (4))){
var inst_31023 = (state_31042[(2)]);
var state_31042__$1 = state_31042;
var statearr_31047_31059 = state_31042__$1;
(statearr_31047_31059[(2)] = inst_31023);

(statearr_31047_31059[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31043 === (5))){
var _ = (function (){var statearr_31048 = state_31042;
(statearr_31048[(4)] = cljs.core.rest((state_31042[(4)])));

return statearr_31048;
})();
var state_31042__$1 = state_31042;
var ex31046 = (state_31042__$1[(2)]);
var statearr_31049_31060 = state_31042__$1;
(statearr_31049_31060[(5)] = ex31046);


if((ex31046 instanceof Error)){
var statearr_31050_31061 = state_31042__$1;
(statearr_31050_31061[(1)] = (4));

(statearr_31050_31061[(5)] = null);

} else {
throw ex31046;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31043 === (6))){
var inst_31036 = (state_31042[(2)]);
var inst_31037 = fluree.db.util.async.throw_err(inst_31036);
var _ = (function (){var statearr_31051 = state_31042;
(statearr_31051[(4)] = cljs.core.rest((state_31042[(4)])));

return statearr_31051;
})();
var state_31042__$1 = state_31042;
var statearr_31052_31062 = state_31042__$1;
(statearr_31052_31062[(2)] = inst_31037);

(statearr_31052_31062[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__13883__auto____0 = (function (){
var statearr_31053 = [null,null,null,null,null,null,null];
(statearr_31053[(0)] = fluree$db$storage$core$write_history_$_state_machine__13883__auto__);

(statearr_31053[(1)] = (1));

return statearr_31053;
});
var fluree$db$storage$core$write_history_$_state_machine__13883__auto____1 = (function (state_31042){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31042);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31054){var ex__13886__auto__ = e31054;
var statearr_31055_31063 = state_31042;
(statearr_31055_31063[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31042[(4)]))){
var statearr_31056_31064 = state_31042;
(statearr_31056_31064[(1)] = cljs.core.first((state_31042[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31065 = state_31042;
state_31042 = G__31065;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__13883__auto__ = function(state_31042){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__13883__auto____1.call(this,state_31042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__13883__auto____0;
fluree$db$storage$core$write_history_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__13883__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31057 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31057[(6)] = c__13957__auto__);

return statearr_31057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31091){
var state_val_31092 = (state_31091[(1)]);
if((state_val_31092 === (1))){
var state_31091__$1 = state_31091;
var statearr_31093_31110 = state_31091__$1;
(statearr_31093_31110[(2)] = null);

(statearr_31093_31110[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31092 === (2))){
var inst_31072 = (state_31091[(7)]);
var _ = (function (){var statearr_31094 = state_31091;
(statearr_31094[(4)] = cljs.core.cons((5),(state_31091[(4)])));

return statearr_31094;
})();
var inst_31072__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_31073 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31072__$1),"-his"].join('');
var inst_31074 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_31075 = [flakes,inst_31073];
var inst_31076 = cljs.core.PersistentHashMap.fromArrays(inst_31074,inst_31075);
var inst_31077 = fluree.db.storage.core.serde(conn);
var inst_31078 = fluree.db.serde.protocol._serialize_leaf(inst_31077,inst_31076);
var inst_31079 = fluree.db.storage.core.write_history(conn,history,inst_31073,null);
var inst_31080 = fluree.db.storage.core.storage_write(conn,inst_31072__$1,inst_31078);
var state_31091__$1 = (function (){var statearr_31095 = state_31091;
(statearr_31095[(7)] = inst_31072__$1);

(statearr_31095[(8)] = inst_31080);

return statearr_31095;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31091__$1,(6),inst_31079);
} else {
if((state_val_31092 === (3))){
var inst_31089 = (state_31091[(2)]);
var state_31091__$1 = state_31091;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31091__$1,inst_31089);
} else {
if((state_val_31092 === (4))){
var inst_31066 = (state_31091[(2)]);
var state_31091__$1 = state_31091;
var statearr_31097_31111 = state_31091__$1;
(statearr_31097_31111[(2)] = inst_31066);

(statearr_31097_31111[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31092 === (5))){
var _ = (function (){var statearr_31098 = state_31091;
(statearr_31098[(4)] = cljs.core.rest((state_31091[(4)])));

return statearr_31098;
})();
var state_31091__$1 = state_31091;
var ex31096 = (state_31091__$1[(2)]);
var statearr_31099_31112 = state_31091__$1;
(statearr_31099_31112[(5)] = ex31096);


if((ex31096 instanceof Error)){
var statearr_31100_31113 = state_31091__$1;
(statearr_31100_31113[(1)] = (4));

(statearr_31100_31113[(5)] = null);

} else {
throw ex31096;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31092 === (6))){
var inst_31080 = (state_31091[(8)]);
var inst_31082 = (state_31091[(2)]);
var inst_31083 = fluree.db.util.async.throw_err(inst_31082);
var state_31091__$1 = (function (){var statearr_31101 = state_31091;
(statearr_31101[(9)] = inst_31083);

return statearr_31101;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31091__$1,(7),inst_31080);
} else {
if((state_val_31092 === (7))){
var inst_31072 = (state_31091[(7)]);
var inst_31085 = (state_31091[(2)]);
var inst_31086 = fluree.db.util.async.throw_err(inst_31085);
var _ = (function (){var statearr_31102 = state_31091;
(statearr_31102[(4)] = cljs.core.rest((state_31091[(4)])));

return statearr_31102;
})();
var state_31091__$1 = (function (){var statearr_31103 = state_31091;
(statearr_31103[(10)] = inst_31086);

return statearr_31103;
})();
var statearr_31104_31114 = state_31091__$1;
(statearr_31104_31114[(2)] = inst_31072);

(statearr_31104_31114[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__13883__auto____0 = (function (){
var statearr_31105 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31105[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__13883__auto__);

(statearr_31105[(1)] = (1));

return statearr_31105;
});
var fluree$db$storage$core$write_leaf_$_state_machine__13883__auto____1 = (function (state_31091){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31091);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31106){var ex__13886__auto__ = e31106;
var statearr_31107_31115 = state_31091;
(statearr_31107_31115[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31091[(4)]))){
var statearr_31108_31116 = state_31091;
(statearr_31108_31116[(1)] = cljs.core.first((state_31091[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31117 = state_31091;
state_31091 = G__31117;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__13883__auto__ = function(state_31091){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__13883__auto____1.call(this,state_31091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__13883__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__13883__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31109 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31109[(6)] = c__13957__auto__);

return statearr_31109;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31134){
var state_val_31135 = (state_31134[(1)]);
if((state_val_31135 === (1))){
var state_31134__$1 = state_31134;
var statearr_31136_31151 = state_31134__$1;
(statearr_31136_31151[(2)] = null);

(statearr_31136_31151[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31135 === (2))){
var _ = (function (){var statearr_31137 = state_31134;
(statearr_31137[(4)] = cljs.core.cons((5),(state_31134[(4)])));

return statearr_31137;
})();
var inst_31124 = fluree.db.storage.core.serde(conn);
var inst_31125 = fluree.db.serde.protocol._serialize_branch(inst_31124,data);
var inst_31126 = fluree.db.storage.core.storage_write(conn,key,inst_31125);
var state_31134__$1 = state_31134;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31134__$1,(6),inst_31126);
} else {
if((state_val_31135 === (3))){
var inst_31132 = (state_31134[(2)]);
var state_31134__$1 = state_31134;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31134__$1,inst_31132);
} else {
if((state_val_31135 === (4))){
var inst_31118 = (state_31134[(2)]);
var state_31134__$1 = state_31134;
var statearr_31139_31152 = state_31134__$1;
(statearr_31139_31152[(2)] = inst_31118);

(statearr_31139_31152[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31135 === (5))){
var _ = (function (){var statearr_31140 = state_31134;
(statearr_31140[(4)] = cljs.core.rest((state_31134[(4)])));

return statearr_31140;
})();
var state_31134__$1 = state_31134;
var ex31138 = (state_31134__$1[(2)]);
var statearr_31141_31153 = state_31134__$1;
(statearr_31141_31153[(5)] = ex31138);


if((ex31138 instanceof Error)){
var statearr_31142_31154 = state_31134__$1;
(statearr_31142_31154[(1)] = (4));

(statearr_31142_31154[(5)] = null);

} else {
throw ex31138;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31135 === (6))){
var inst_31128 = (state_31134[(2)]);
var inst_31129 = fluree.db.util.async.throw_err(inst_31128);
var _ = (function (){var statearr_31143 = state_31134;
(statearr_31143[(4)] = cljs.core.rest((state_31134[(4)])));

return statearr_31143;
})();
var state_31134__$1 = (function (){var statearr_31144 = state_31134;
(statearr_31144[(7)] = inst_31129);

return statearr_31144;
})();
var statearr_31145_31155 = state_31134__$1;
(statearr_31145_31155[(2)] = key);

(statearr_31145_31155[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto____0 = (function (){
var statearr_31146 = [null,null,null,null,null,null,null,null];
(statearr_31146[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto__);

(statearr_31146[(1)] = (1));

return statearr_31146;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto____1 = (function (state_31134){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31134);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31147){var ex__13886__auto__ = e31147;
var statearr_31148_31156 = state_31134;
(statearr_31148_31156[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31134[(4)]))){
var statearr_31149_31157 = state_31134;
(statearr_31149_31157[(1)] = cljs.core.first((state_31134[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31158 = state_31134;
state_31134 = G__31158;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto__ = function(state_31134){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto____1.call(this,state_31134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31150 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31150[(6)] = c__13957__auto__);

return statearr_31150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__31159_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__31159_SHARP_));
}),children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__31160){
var map__31161 = p__31160;
var map__31161__$1 = cljs.core.__destructure_map(map__31161);
var progress = map__31161__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31161__$1,cljs.core.cst$kw$garbage);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31189){
var state_val_31190 = (state_31189[(1)]);
if((state_val_31190 === (1))){
var state_31189__$1 = state_31189;
var statearr_31191_31207 = state_31189__$1;
(statearr_31191_31207[(2)] = null);

(statearr_31191_31207[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31190 === (2))){
var inst_31175 = (state_31189[(7)]);
var _ = (function (){var statearr_31192 = state_31189;
(statearr_31192[(4)] = cljs.core.cons((5),(state_31189[(4)])));

return statearr_31192;
})();
var inst_31169 = db;
var inst_31170 = cljs.core.__destructure_map(inst_31169);
var inst_31171 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31170,cljs.core.cst$kw$conn);
var inst_31172 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31170,cljs.core.cst$kw$network);
var inst_31173 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31170,cljs.core.cst$kw$dbid);
var inst_31174 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31170,cljs.core.cst$kw$block);
var inst_31175__$1 = fluree.db.storage.core.ledger_garbage_key(inst_31172,inst_31173,inst_31174);
var inst_31176 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_31177 = [inst_31173,inst_31174,garbage];
var inst_31178 = cljs.core.PersistentHashMap.fromArrays(inst_31176,inst_31177);
var inst_31179 = fluree.db.storage.core.serde(inst_31171);
var inst_31180 = fluree.db.serde.protocol._serialize_garbage(inst_31179,inst_31178);
var inst_31181 = fluree.db.storage.core.storage_write(inst_31171,inst_31175__$1,inst_31180);
var state_31189__$1 = (function (){var statearr_31193 = state_31189;
(statearr_31193[(7)] = inst_31175__$1);

return statearr_31193;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31189__$1,(6),inst_31181);
} else {
if((state_val_31190 === (3))){
var inst_31187 = (state_31189[(2)]);
var state_31189__$1 = state_31189;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31189__$1,inst_31187);
} else {
if((state_val_31190 === (4))){
var inst_31162 = (state_31189[(2)]);
var state_31189__$1 = state_31189;
var statearr_31195_31208 = state_31189__$1;
(statearr_31195_31208[(2)] = inst_31162);

(statearr_31195_31208[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31190 === (5))){
var _ = (function (){var statearr_31196 = state_31189;
(statearr_31196[(4)] = cljs.core.rest((state_31189[(4)])));

return statearr_31196;
})();
var state_31189__$1 = state_31189;
var ex31194 = (state_31189__$1[(2)]);
var statearr_31197_31209 = state_31189__$1;
(statearr_31197_31209[(5)] = ex31194);


if((ex31194 instanceof Error)){
var statearr_31198_31210 = state_31189__$1;
(statearr_31198_31210[(1)] = (4));

(statearr_31198_31210[(5)] = null);

} else {
throw ex31194;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31190 === (6))){
var inst_31175 = (state_31189[(7)]);
var inst_31183 = (state_31189[(2)]);
var inst_31184 = fluree.db.util.async.throw_err(inst_31183);
var _ = (function (){var statearr_31199 = state_31189;
(statearr_31199[(4)] = cljs.core.rest((state_31189[(4)])));

return statearr_31199;
})();
var state_31189__$1 = (function (){var statearr_31200 = state_31189;
(statearr_31200[(8)] = inst_31184);

return statearr_31200;
})();
var statearr_31201_31211 = state_31189__$1;
(statearr_31201_31211[(2)] = inst_31175);

(statearr_31201_31211[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__13883__auto____0 = (function (){
var statearr_31202 = [null,null,null,null,null,null,null,null,null];
(statearr_31202[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__13883__auto__);

(statearr_31202[(1)] = (1));

return statearr_31202;
});
var fluree$db$storage$core$write_garbage_$_state_machine__13883__auto____1 = (function (state_31189){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31189);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31203){var ex__13886__auto__ = e31203;
var statearr_31204_31212 = state_31189;
(statearr_31204_31212[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31189[(4)]))){
var statearr_31205_31213 = state_31189;
(statearr_31205_31213[(1)] = cljs.core.first((state_31189[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31214 = state_31189;
state_31189 = G__31214;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__13883__auto__ = function(state_31189){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__13883__auto____1.call(this,state_31189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__13883__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__13883__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31206 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31206[(6)] = c__13957__auto__);

return statearr_31206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__31216 = arguments.length;
switch (G__31216) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31272){
var state_val_31273 = (state_31272[(1)]);
if((state_val_31273 === (7))){
var state_31272__$1 = state_31272;
var statearr_31274_31300 = state_31272__$1;
(statearr_31274_31300[(2)] = (0));

(statearr_31274_31300[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31273 === (1))){
var state_31272__$1 = state_31272;
var statearr_31275_31301 = state_31272__$1;
(statearr_31275_31301[(2)] = null);

(statearr_31275_31301[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31273 === (4))){
var inst_31217 = (state_31272[(2)]);
var state_31272__$1 = state_31272;
var statearr_31276_31302 = state_31272__$1;
(statearr_31276_31302[(2)] = inst_31217);

(statearr_31276_31302[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31273 === (6))){
var inst_31242 = (state_31272[(7)]);
var state_31272__$1 = state_31272;
var statearr_31277_31303 = state_31272__$1;
(statearr_31277_31303[(2)] = inst_31242);

(statearr_31277_31303[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31273 === (3))){
var inst_31270 = (state_31272[(2)]);
var state_31272__$1 = state_31272;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31272__$1,inst_31270);
} else {
if((state_val_31273 === (12))){
var inst_31239 = (state_31272[(8)]);
var inst_31266 = (state_31272[(2)]);
var inst_31267 = fluree.db.util.async.throw_err(inst_31266);
var _ = (function (){var statearr_31278 = state_31272;
(statearr_31278[(4)] = cljs.core.rest((state_31272[(4)])));

return statearr_31278;
})();
var state_31272__$1 = (function (){var statearr_31279 = state_31272;
(statearr_31279[(9)] = inst_31267);

return statearr_31279;
})();
var statearr_31280_31304 = state_31272__$1;
(statearr_31280_31304[(2)] = inst_31239);

(statearr_31280_31304[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31273 === (2))){
var inst_31232 = (state_31272[(10)]);
var inst_31230 = (state_31272[(11)]);
var inst_31234 = (state_31272[(12)]);
var inst_31242 = (state_31272[(7)]);
var _ = (function (){var statearr_31281 = state_31272;
(statearr_31281[(4)] = cljs.core.cons((5),(state_31272[(4)])));

return statearr_31281;
})();
var inst_31224 = db;
var inst_31225 = cljs.core.__destructure_map(inst_31224);
var inst_31226 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31225,cljs.core.cst$kw$network);
var inst_31227 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31225,cljs.core.cst$kw$t);
var inst_31228 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31225,cljs.core.cst$kw$fork);
var inst_31229 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31225,cljs.core.cst$kw$spot);
var inst_31230__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31225,cljs.core.cst$kw$stats);
var inst_31231 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31225,cljs.core.cst$kw$conn);
var inst_31232__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31225,cljs.core.cst$kw$block);
var inst_31233 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31225,cljs.core.cst$kw$psot);
var inst_31234__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31225,cljs.core.cst$kw$dbid);
var inst_31235 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31225,cljs.core.cst$kw$ecount);
var inst_31236 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31225,cljs.core.cst$kw$opst);
var inst_31237 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31225,cljs.core.cst$kw$fork_DASH_block);
var inst_31238 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31225,cljs.core.cst$kw$post);
var inst_31239 = fluree.db.storage.core.ledger_root_key(inst_31226,inst_31234__$1,inst_31232__$1);
var inst_31240 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_31241 = fluree.db.storage.core.child_data(inst_31233);
var inst_31242__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_31230__$1);
var state_31272__$1 = (function (){var statearr_31282 = state_31272;
(statearr_31282[(10)] = inst_31232__$1);

(statearr_31282[(13)] = inst_31236);

(statearr_31282[(14)] = inst_31228);

(statearr_31282[(15)] = inst_31231);

(statearr_31282[(11)] = inst_31230__$1);

(statearr_31282[(16)] = inst_31241);

(statearr_31282[(17)] = inst_31240);

(statearr_31282[(12)] = inst_31234__$1);

(statearr_31282[(18)] = inst_31235);

(statearr_31282[(19)] = inst_31238);

(statearr_31282[(20)] = inst_31237);

(statearr_31282[(21)] = inst_31229);

(statearr_31282[(8)] = inst_31239);

(statearr_31282[(7)] = inst_31242__$1);

(statearr_31282[(22)] = inst_31227);

return statearr_31282;
})();
if(cljs.core.truth_(inst_31242__$1)){
var statearr_31283_31305 = state_31272__$1;
(statearr_31283_31305[(1)] = (6));

} else {
var statearr_31284_31306 = state_31272__$1;
(statearr_31284_31306[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31273 === (11))){
var inst_31246 = (state_31272[(23)]);
var inst_31232 = (state_31272[(10)]);
var inst_31236 = (state_31272[(13)]);
var inst_31228 = (state_31272[(14)]);
var inst_31231 = (state_31272[(15)]);
var inst_31230 = (state_31272[(11)]);
var inst_31241 = (state_31272[(16)]);
var inst_31240 = (state_31272[(17)]);
var inst_31234 = (state_31272[(12)]);
var inst_31238 = (state_31272[(19)]);
var inst_31237 = (state_31272[(20)]);
var inst_31229 = (state_31272[(21)]);
var inst_31239 = (state_31272[(8)]);
var inst_31227 = (state_31272[(22)]);
var inst_31251 = (state_31272[(2)]);
var inst_31252 = fluree.db.storage.core.child_data(inst_31236);
var inst_31253 = fluree.db.storage.core.child_data(inst_31238);
var inst_31254 = fluree.db.util.core.current_time_millis();
var inst_31255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31256 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_31257 = (new cljs.core.PersistentVector(null,2,(5),inst_31255,inst_31256,null));
var inst_31258 = cljs.core.select_keys(inst_31230,inst_31257);
var inst_31259 = fluree.db.storage.core.child_data(inst_31229);
var inst_31260 = [inst_31232,inst_31241,inst_31234,inst_31246,inst_31251,inst_31252,inst_31253,inst_31227,inst_31254,inst_31228,inst_31237,inst_31258,inst_31259];
var inst_31261 = cljs.core.PersistentHashMap.fromArrays(inst_31240,inst_31260);
var inst_31262 = fluree.db.storage.core.serde(inst_31231);
var inst_31263 = fluree.db.serde.protocol._serialize_db_root(inst_31262,inst_31261);
var inst_31264 = fluree.db.storage.core.storage_write(inst_31231,inst_31239,inst_31263);
var state_31272__$1 = state_31272;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31272__$1,(12),inst_31264);
} else {
if((state_val_31273 === (9))){
var inst_31247 = (state_31272[(24)]);
var state_31272__$1 = state_31272;
var statearr_31286_31307 = state_31272__$1;
(statearr_31286_31307[(2)] = inst_31247);

(statearr_31286_31307[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31273 === (5))){
var _ = (function (){var statearr_31287 = state_31272;
(statearr_31287[(4)] = cljs.core.rest((state_31272[(4)])));

return statearr_31287;
})();
var state_31272__$1 = state_31272;
var ex31285 = (state_31272__$1[(2)]);
var statearr_31288_31308 = state_31272__$1;
(statearr_31288_31308[(5)] = ex31285);


if((ex31285 instanceof Error)){
var statearr_31289_31309 = state_31272__$1;
(statearr_31289_31309[(1)] = (4));

(statearr_31289_31309[(5)] = null);

} else {
throw ex31285;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31273 === (10))){
var inst_31235 = (state_31272[(18)]);
var state_31272__$1 = state_31272;
var statearr_31290_31310 = state_31272__$1;
(statearr_31290_31310[(2)] = inst_31235);

(statearr_31290_31310[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31273 === (8))){
var inst_31247 = (state_31272[(24)]);
var inst_31246 = (state_31272[(2)]);
var inst_31247__$1 = custom_ecount;
var state_31272__$1 = (function (){var statearr_31291 = state_31272;
(statearr_31291[(23)] = inst_31246);

(statearr_31291[(24)] = inst_31247__$1);

return statearr_31291;
})();
if(cljs.core.truth_(inst_31247__$1)){
var statearr_31292_31311 = state_31272__$1;
(statearr_31292_31311[(1)] = (9));

} else {
var statearr_31293_31312 = state_31272__$1;
(statearr_31293_31312[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__13883__auto__ = null;
var fluree$db$storage$core$state_machine__13883__auto____0 = (function (){
var statearr_31294 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31294[(0)] = fluree$db$storage$core$state_machine__13883__auto__);

(statearr_31294[(1)] = (1));

return statearr_31294;
});
var fluree$db$storage$core$state_machine__13883__auto____1 = (function (state_31272){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31272);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31295){var ex__13886__auto__ = e31295;
var statearr_31296_31313 = state_31272;
(statearr_31296_31313[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31272[(4)]))){
var statearr_31297_31314 = state_31272;
(statearr_31297_31314[(1)] = cljs.core.first((state_31272[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31315 = state_31272;
state_31272 = G__31315;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__13883__auto__ = function(state_31272){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__13883__auto____1.call(this,state_31272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__13883__auto____0;
fluree$db$storage$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__13883__auto____1;
return fluree$db$storage$core$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31298 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31298[(6)] = c__13957__auto__);

return statearr_31298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___31367 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31345){
var state_val_31346 = (state_31345[(1)]);
if((state_val_31346 === (7))){
var inst_31332 = cljs.core.async.close_BANG_(return_ch);
var state_31345__$1 = state_31345;
var statearr_31347_31368 = state_31345__$1;
(statearr_31347_31368[(2)] = inst_31332);

(statearr_31347_31368[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31346 === (1))){
var state_31345__$1 = state_31345;
var statearr_31348_31369 = state_31345__$1;
(statearr_31348_31369[(2)] = null);

(statearr_31348_31369[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31346 === (4))){
var inst_31316 = (state_31345[(2)]);
var inst_31317 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_31318 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_31316);
var inst_31319 = cljs.core.async.close_BANG_(return_ch);
var state_31345__$1 = (function (){var statearr_31349 = state_31345;
(statearr_31349[(7)] = inst_31318);

(statearr_31349[(8)] = inst_31317);

return statearr_31349;
})();
var statearr_31350_31370 = state_31345__$1;
(statearr_31350_31370[(2)] = inst_31319);

(statearr_31350_31370[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31346 === (6))){
var inst_31327 = (state_31345[(9)]);
var inst_31327__$1 = (state_31345[(2)]);
var inst_31328 = (inst_31327__$1 == null);
var inst_31329 = (inst_31327__$1 instanceof Error);
var inst_31330 = ((inst_31328) || (inst_31329));
var state_31345__$1 = (function (){var statearr_31351 = state_31345;
(statearr_31351[(9)] = inst_31327__$1);

return statearr_31351;
})();
if(cljs.core.truth_(inst_31330)){
var statearr_31352_31371 = state_31345__$1;
(statearr_31352_31371[(1)] = (7));

} else {
var statearr_31353_31372 = state_31345__$1;
(statearr_31353_31372[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31346 === (3))){
var inst_31343 = (state_31345[(2)]);
var state_31345__$1 = state_31345;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31345__$1,inst_31343);
} else {
if((state_val_31346 === (2))){
var _ = (function (){var statearr_31355 = state_31345;
(statearr_31355[(4)] = cljs.core.cons((5),(state_31345[(4)])));

return statearr_31355;
})();
var inst_31325 = fluree.db.storage.core.storage_read(conn,key);
var state_31345__$1 = state_31345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31345__$1,(6),inst_31325);
} else {
if((state_val_31346 === (9))){
var inst_31340 = (state_31345[(2)]);
var _ = (function (){var statearr_31356 = state_31345;
(statearr_31356[(4)] = cljs.core.rest((state_31345[(4)])));

return statearr_31356;
})();
var state_31345__$1 = state_31345;
var statearr_31357_31373 = state_31345__$1;
(statearr_31357_31373[(2)] = inst_31340);

(statearr_31357_31373[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31346 === (5))){
var _ = (function (){var statearr_31358 = state_31345;
(statearr_31358[(4)] = cljs.core.rest((state_31345[(4)])));

return statearr_31358;
})();
var state_31345__$1 = state_31345;
var ex31354 = (state_31345__$1[(2)]);
var statearr_31359_31374 = state_31345__$1;
(statearr_31359_31374[(5)] = ex31354);


var statearr_31360_31375 = state_31345__$1;
(statearr_31360_31375[(1)] = (4));

(statearr_31360_31375[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31346 === (8))){
var inst_31327 = (state_31345[(9)]);
var inst_31334 = fluree.db.storage.core.serde(conn);
var inst_31335 = fluree.db.serde.protocol._deserialize_leaf(inst_31334,inst_31327);
var inst_31336 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_31335);
var inst_31337 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_31336);
var inst_31338 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_31337);
var state_31345__$1 = state_31345;
var statearr_31361_31376 = state_31345__$1;
(statearr_31361_31376[(2)] = inst_31338);

(statearr_31361_31376[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__13883__auto____0 = (function (){
var statearr_31362 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31362[(0)] = fluree$db$storage$core$reify_history_$_state_machine__13883__auto__);

(statearr_31362[(1)] = (1));

return statearr_31362;
});
var fluree$db$storage$core$reify_history_$_state_machine__13883__auto____1 = (function (state_31345){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31345);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31363){var ex__13886__auto__ = e31363;
var statearr_31364_31377 = state_31345;
(statearr_31364_31377[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31345[(4)]))){
var statearr_31365_31378 = state_31345;
(statearr_31365_31378[(1)] = cljs.core.first((state_31345[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31379 = state_31345;
state_31345 = G__31379;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__13883__auto__ = function(state_31345){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__13883__auto____1.call(this,state_31345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__13883__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__13883__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31366 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31366[(6)] = c__13957__auto___31367);

return statearr_31366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__31381 = arguments.length;
switch (G__31381) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4149__auto__ = rhs;
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4149__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4149__auto__ = rhs;
if(cljs.core.truth_(and__4149__auto__)){
return leftmost_QMARK_;
} else {
return and__4149__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((((rhs == null))?leftmost_QMARK_:false))?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___31493 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31444){
var state_val_31445 = (state_31444[(1)]);
if((state_val_31445 === (7))){
var state_31444__$1 = state_31444;
var statearr_31446_31494 = state_31444__$1;
(statearr_31446_31494[(2)] = cljs.core.cst$kw$novelty);

(statearr_31446_31494[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (20))){
var inst_31423 = cljs.core.PersistentVector.EMPTY;
var state_31444__$1 = state_31444;
var statearr_31447_31495 = state_31444__$1;
(statearr_31447_31495[(2)] = inst_31423);

(statearr_31447_31495[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (1))){
var state_31444__$1 = state_31444;
var statearr_31448_31496 = state_31444__$1;
(statearr_31448_31496[(2)] = null);

(statearr_31448_31496[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (24))){
var state_31444__$1 = state_31444;
var statearr_31449_31497 = state_31444__$1;
(statearr_31449_31497[(2)] = null);

(statearr_31449_31497[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (4))){
var inst_31384 = (state_31444[(2)]);
var inst_31385 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_31386 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_31384);
var inst_31387 = cljs.core.async.close_BANG_(result_ch);
var state_31444__$1 = (function (){var statearr_31450 = state_31444;
(statearr_31450[(7)] = inst_31386);

(statearr_31450[(8)] = inst_31385);

return statearr_31450;
})();
var statearr_31451_31498 = state_31444__$1;
(statearr_31451_31498[(2)] = inst_31387);

(statearr_31451_31498[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (15))){
var inst_31409 = (state_31444[(2)]);
var state_31444__$1 = state_31444;
var statearr_31452_31499 = state_31444__$1;
(statearr_31452_31499[(2)] = inst_31409);

(statearr_31452_31499[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (21))){
var inst_31397 = (state_31444[(9)]);
var inst_31396 = (state_31444[(10)]);
var inst_31398 = (state_31444[(11)]);
var inst_31413 = (state_31444[(12)]);
var inst_31426 = (state_31444[(13)]);
var inst_31433 = (state_31444[(2)]);
var inst_31434 = (function (){var base_node = inst_31396;
var first_flake = inst_31397;
var node_t = inst_31398;
var source = inst_31413;
var coll = inst_31426;
var conj_QMARK_ = inst_31433;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__31454 = f.p;
var fexpr__31453 = (function (){var or__4160__auto__ = remove_preds;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__31453.cljs$core$IFn$_invoke$arity$1 ? fexpr__31453.cljs$core$IFn$_invoke$arity$1(G__31454) : fexpr__31453.call(null,G__31454));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_31435 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_31396);
var inst_31436 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_31434,inst_31435,inst_31426);
var inst_31437 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_31436);
var inst_31438 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_31396,cljs.core.cst$kw$flakes,inst_31437);
var inst_31439 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_31438);
var _ = (function (){var statearr_31455 = state_31444;
(statearr_31455[(4)] = cljs.core.rest((state_31444[(4)])));

return statearr_31455;
})();
var state_31444__$1 = state_31444;
var statearr_31456_31500 = state_31444__$1;
(statearr_31456_31500[(2)] = inst_31439);

(statearr_31456_31500[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (13))){
var state_31444__$1 = state_31444;
var statearr_31457_31501 = state_31444__$1;
(statearr_31457_31501[(2)] = cljs.core.cst$kw$none);

(statearr_31457_31501[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (22))){
var inst_31397 = (state_31444[(9)]);
var inst_31396 = (state_31444[(10)]);
var inst_31398 = (state_31444[(11)]);
var inst_31413 = (state_31444[(12)]);
var inst_31426 = (state_31444[(13)]);
var inst_31427 = (function (){var base_node = inst_31396;
var first_flake = inst_31397;
var node_t = inst_31398;
var source = inst_31413;
var coll = inst_31426;
return (function (f){
return f.op === true;
});
})();
var state_31444__$1 = state_31444;
var statearr_31458_31502 = state_31444__$1;
(statearr_31458_31502[(2)] = inst_31427);

(statearr_31458_31502[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (6))){
var inst_31396 = (state_31444[(10)]);
var inst_31398 = (state_31444[(11)]);
var inst_31395 = (state_31444[(2)]);
var inst_31396__$1 = fluree.db.util.async.throw_err(inst_31395);
var inst_31397 = fluree.db.dbproto._first_flake(inst_31396__$1);
var inst_31398__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_31396__$1);
var inst_31399 = (inst_31398__$1 > t);
var state_31444__$1 = (function (){var statearr_31459 = state_31444;
(statearr_31459[(9)] = inst_31397);

(statearr_31459[(10)] = inst_31396__$1);

(statearr_31459[(11)] = inst_31398__$1);

return statearr_31459;
})();
if(cljs.core.truth_(inst_31399)){
var statearr_31460_31503 = state_31444__$1;
(statearr_31460_31503[(1)] = (7));

} else {
var statearr_31461_31504 = state_31444__$1;
(statearr_31461_31504[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (17))){
var inst_31397 = (state_31444[(9)]);
var inst_31414 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_31397,rhs,leftmost_QMARK_,t);
var state_31444__$1 = state_31444;
var statearr_31462_31505 = state_31444__$1;
(statearr_31462_31505[(2)] = inst_31414);

(statearr_31462_31505[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (3))){
var inst_31442 = (state_31444[(2)]);
var state_31444__$1 = state_31444;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31444__$1,inst_31442);
} else {
if((state_val_31445 === (12))){
var inst_31411 = (state_31444[(2)]);
var state_31444__$1 = state_31444;
var statearr_31463_31506 = state_31444__$1;
(statearr_31463_31506[(2)] = inst_31411);

(statearr_31463_31506[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (2))){
var _ = (function (){var statearr_31464 = state_31444;
(statearr_31464[(4)] = cljs.core.cons((5),(state_31444[(4)])));

return statearr_31464;
})();
var inst_31393 = fluree.db.dbproto._resolve(node);
var state_31444__$1 = state_31444;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31444__$1,(6),inst_31393);
} else {
if((state_val_31445 === (23))){
var inst_31397 = (state_31444[(9)]);
var inst_31396 = (state_31444[(10)]);
var inst_31398 = (state_31444[(11)]);
var inst_31413 = (state_31444[(12)]);
var inst_31426 = (state_31444[(13)]);
var inst_31429 = (function (){var base_node = inst_31396;
var first_flake = inst_31397;
var node_t = inst_31398;
var source = inst_31413;
var coll = inst_31426;
return (function (f){
return f.op === false;
});
})();
var state_31444__$1 = state_31444;
var statearr_31465_31507 = state_31444__$1;
(statearr_31465_31507[(2)] = inst_31429);

(statearr_31465_31507[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (19))){
var inst_31416 = (state_31444[(14)]);
var inst_31419 = (state_31444[(2)]);
var inst_31420 = fluree.db.util.async.throw_err(inst_31419);
var inst_31421 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_31416,inst_31420);
var state_31444__$1 = state_31444;
var statearr_31466_31508 = state_31444__$1;
(statearr_31466_31508[(2)] = inst_31421);

(statearr_31466_31508[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (11))){
var inst_31398 = (state_31444[(11)]);
var inst_31405 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31398,t);
var state_31444__$1 = state_31444;
if(inst_31405){
var statearr_31468_31509 = state_31444__$1;
(statearr_31468_31509[(1)] = (13));

} else {
var statearr_31469_31510 = state_31444__$1;
(statearr_31469_31510[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (9))){
var inst_31413 = (state_31444[(12)]);
var inst_31413__$1 = (state_31444[(2)]);
var state_31444__$1 = (function (){var statearr_31470 = state_31444;
(statearr_31470[(12)] = inst_31413__$1);

return statearr_31470;
})();
var G__31471_31511 = inst_31413__$1;
var G__31471_31512__$1 = (((G__31471_31511 instanceof cljs.core.Keyword))?G__31471_31511.fqn:null);
switch (G__31471_31512__$1) {
case "novelty":
var statearr_31472_31514 = state_31444__$1;
(statearr_31472_31514[(1)] = (17));


break;
case "history":
var statearr_31473_31515 = state_31444__$1;
(statearr_31473_31515[(1)] = (18));


break;
case "none":
var statearr_31474_31516 = state_31444__$1;
(statearr_31474_31516[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31471_31512__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (5))){
var _ = (function (){var statearr_31475 = state_31444;
(statearr_31475[(4)] = cljs.core.rest((state_31444[(4)])));

return statearr_31475;
})();
var state_31444__$1 = state_31444;
var ex31467 = (state_31444__$1[(2)]);
var statearr_31476_31517 = state_31444__$1;
(statearr_31476_31517[(5)] = ex31467);


var statearr_31477_31518 = state_31444__$1;
(statearr_31477_31518[(1)] = (4));

(statearr_31477_31518[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (14))){
var state_31444__$1 = state_31444;
var statearr_31478_31519 = state_31444__$1;
(statearr_31478_31519[(2)] = null);

(statearr_31478_31519[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (16))){
var inst_31413 = (state_31444[(12)]);
var inst_31426 = (state_31444[(2)]);
var state_31444__$1 = (function (){var statearr_31479 = state_31444;
(statearr_31479[(13)] = inst_31426);

return statearr_31479;
})();
var G__31480_31520 = inst_31413;
var G__31480_31521__$1 = (((G__31480_31520 instanceof cljs.core.Keyword))?G__31480_31520.fqn:null);
switch (G__31480_31521__$1) {
case "novelty":
var statearr_31481_31523 = state_31444__$1;
(statearr_31481_31523[(1)] = (22));


break;
case "history":
var statearr_31482_31524 = state_31444__$1;
(statearr_31482_31524[(1)] = (23));


break;
case "none":
var statearr_31483_31525 = state_31444__$1;
(statearr_31483_31525[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31480_31521__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (10))){
var state_31444__$1 = state_31444;
var statearr_31484_31526 = state_31444__$1;
(statearr_31484_31526[(2)] = cljs.core.cst$kw$history);

(statearr_31484_31526[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31445 === (18))){
var inst_31397 = (state_31444[(9)]);
var inst_31396 = (state_31444[(10)]);
var inst_31398 = (state_31444[(11)]);
var inst_31413 = (state_31444[(12)]);
var inst_31416 = (function (){var base_node = inst_31396;
var first_flake = inst_31397;
var node_t = inst_31398;
var source = inst_31413;
return (function (p1__31383_SHARP_){
return (p1__31383_SHARP_.t <= t);
});
})();
var inst_31417 = fluree.db.dbproto._resolve_history(node);
var state_31444__$1 = (function (){var statearr_31485 = state_31444;
(statearr_31485[(14)] = inst_31416);

return statearr_31485;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31444__$1,(19),inst_31417);
} else {
if((state_val_31445 === (8))){
var inst_31398 = (state_31444[(11)]);
var inst_31402 = (inst_31398 < t);
var state_31444__$1 = state_31444;
if(cljs.core.truth_(inst_31402)){
var statearr_31486_31527 = state_31444__$1;
(statearr_31486_31527[(1)] = (10));

} else {
var statearr_31487_31528 = state_31444__$1;
(statearr_31487_31528[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__13883__auto____0 = (function (){
var statearr_31488 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31488[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__13883__auto__);

(statearr_31488[(1)] = (1));

return statearr_31488;
});
var fluree$db$storage$core$resolve_t_$_state_machine__13883__auto____1 = (function (state_31444){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31444);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31489){var ex__13886__auto__ = e31489;
var statearr_31490_31529 = state_31444;
(statearr_31490_31529[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31444[(4)]))){
var statearr_31491_31530 = state_31444;
(statearr_31491_31530[(1)] = cljs.core.first((state_31444[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31531 = state_31444;
state_31444 = G__31531;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__13883__auto__ = function(state_31444){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__13883__auto____1.call(this,state_31444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__13883__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__13883__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31492 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31492[(6)] = c__13957__auto___31493);

return statearr_31492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31588){
var state_val_31589 = (state_31588[(1)]);
if((state_val_31589 === (7))){
var state_31588__$1 = state_31588;
var statearr_31590_31626 = state_31588__$1;
(statearr_31590_31626[(2)] = null);

(statearr_31590_31626[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (1))){
var state_31588__$1 = state_31588;
var statearr_31591_31627 = state_31588__$1;
(statearr_31591_31627[(2)] = null);

(statearr_31591_31627[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (4))){
var inst_31534 = (state_31588[(2)]);
var inst_31535 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_31534], 0));
var inst_31536 = (function(){throw inst_31534})();
var state_31588__$1 = (function (){var statearr_31592 = state_31588;
(statearr_31592[(7)] = inst_31535);

return statearr_31592;
})();
var statearr_31593_31628 = state_31588__$1;
(statearr_31593_31628[(2)] = inst_31536);

(statearr_31593_31628[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (15))){
var inst_31564 = (state_31588[(2)]);
var state_31588__$1 = state_31588;
var statearr_31594_31629 = state_31588__$1;
(statearr_31594_31629[(2)] = inst_31564);

(statearr_31594_31629[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (13))){
var inst_31558 = (state_31588[(8)]);
var inst_31542 = (state_31588[(9)]);
var inst_31560 = (function (){var node_t = inst_31542;
var G__31547 = inst_31558;
return (function (p1__31533_SHARP_){
return (p1__31533_SHARP_.t <= from_t);
});
})();
var inst_31561 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_31560,inst_31558);
var state_31588__$1 = state_31588;
var statearr_31595_31630 = state_31588__$1;
(statearr_31595_31630[(2)] = inst_31561);

(statearr_31595_31630[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (6))){
var inst_31548 = fluree.db.dbproto._resolve_history(node);
var state_31588__$1 = state_31588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31588__$1,(9),inst_31548);
} else {
if((state_val_31589 === (17))){
var inst_31573 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_31574 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31573)].join('');
var inst_31575 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31576 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_31577 = cljs.core.PersistentHashMap.fromArrays(inst_31575,inst_31576);
var inst_31578 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31574,inst_31577);
var inst_31579 = (function(){throw inst_31578})();
var state_31588__$1 = state_31588;
var statearr_31596_31631 = state_31588__$1;
(statearr_31596_31631[(2)] = inst_31579);

(statearr_31596_31631[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (3))){
var inst_31586 = (state_31588[(2)]);
var state_31588__$1 = state_31588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31588__$1,inst_31586);
} else {
if((state_val_31589 === (12))){
var inst_31558 = (state_31588[(2)]);
var state_31588__$1 = (function (){var statearr_31597 = state_31588;
(statearr_31597[(8)] = inst_31558);

return statearr_31597;
})();
if(cljs.core.truth_(from_t)){
var statearr_31598_31632 = state_31588__$1;
(statearr_31598_31632[(1)] = (13));

} else {
var statearr_31599_31633 = state_31588__$1;
(statearr_31599_31633[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (2))){
var inst_31542 = (state_31588[(9)]);
var _ = (function (){var statearr_31600 = state_31588;
(statearr_31600[(4)] = cljs.core.cons((5),(state_31588[(4)])));

return statearr_31600;
})();
var inst_31542__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_31543 = (from_t == null);
var inst_31544 = (inst_31542__$1 <= from_t);
var inst_31545 = ((inst_31543) || (inst_31544));
var state_31588__$1 = (function (){var statearr_31601 = state_31588;
(statearr_31601[(9)] = inst_31542__$1);

return statearr_31601;
})();
if(cljs.core.truth_(inst_31545)){
var statearr_31602_31634 = state_31588__$1;
(statearr_31602_31634[(1)] = (6));

} else {
var statearr_31603_31635 = state_31588__$1;
(statearr_31603_31635[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (11))){
var inst_31551 = (state_31588[(10)]);
var state_31588__$1 = state_31588;
var statearr_31605_31636 = state_31588__$1;
(statearr_31605_31636[(2)] = inst_31551);

(statearr_31605_31636[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (9))){
var inst_31542 = (state_31588[(9)]);
var inst_31550 = (state_31588[(2)]);
var inst_31551 = fluree.db.util.async.throw_err(inst_31550);
var inst_31552 = (to_t > inst_31542);
var state_31588__$1 = (function (){var statearr_31606 = state_31588;
(statearr_31606[(10)] = inst_31551);

return statearr_31606;
})();
if(cljs.core.truth_(inst_31552)){
var statearr_31607_31637 = state_31588__$1;
(statearr_31607_31637[(1)] = (10));

} else {
var statearr_31608_31638 = state_31588__$1;
(statearr_31608_31638[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (5))){
var _ = (function (){var statearr_31609 = state_31588;
(statearr_31609[(4)] = cljs.core.rest((state_31588[(4)])));

return statearr_31609;
})();
var state_31588__$1 = state_31588;
var ex31604 = (state_31588__$1[(2)]);
var statearr_31610_31639 = state_31588__$1;
(statearr_31610_31639[(5)] = ex31604);


var statearr_31611_31640 = state_31588__$1;
(statearr_31611_31640[(1)] = (4));

(statearr_31611_31640[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (14))){
var inst_31558 = (state_31588[(8)]);
var state_31588__$1 = state_31588;
var statearr_31612_31641 = state_31588__$1;
(statearr_31612_31641[(2)] = inst_31558);

(statearr_31612_31641[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (16))){
var state_31588__$1 = state_31588;
var statearr_31613_31642 = state_31588__$1;
(statearr_31613_31642[(2)] = null);

(statearr_31613_31642[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (10))){
var inst_31551 = (state_31588[(10)]);
var inst_31542 = (state_31588[(9)]);
var inst_31554 = (function (){var node_t = inst_31542;
var G__31547 = inst_31551;
return (function (p1__31532_SHARP_){
return (p1__31532_SHARP_.t < to_t);
});
})();
var inst_31555 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_31554,inst_31551);
var state_31588__$1 = state_31588;
var statearr_31614_31643 = state_31588__$1;
(statearr_31614_31643[(2)] = inst_31555);

(statearr_31614_31643[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (18))){
var inst_31567 = (state_31588[(11)]);
var inst_31569 = (state_31588[(12)]);
var inst_31568 = (state_31588[(13)]);
var inst_31581 = (state_31588[(2)]);
var inst_31582 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_31568,inst_31569,leftmost_QMARK_,to_t);
var inst_31583 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31582,inst_31567);
var _ = (function (){var statearr_31615 = state_31588;
(statearr_31615[(4)] = cljs.core.rest((state_31588[(4)])));

return statearr_31615;
})();
var state_31588__$1 = (function (){var statearr_31616 = state_31588;
(statearr_31616[(14)] = inst_31581);

return statearr_31616;
})();
var statearr_31617_31644 = state_31588__$1;
(statearr_31617_31644[(2)] = inst_31583);

(statearr_31617_31644[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31589 === (8))){
var inst_31567 = (state_31588[(2)]);
var inst_31568 = fluree.db.dbproto._first_flake(node);
var inst_31569 = fluree.db.dbproto._rhs(node);
var inst_31570 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_31588__$1 = (function (){var statearr_31618 = state_31588;
(statearr_31618[(11)] = inst_31567);

(statearr_31618[(12)] = inst_31569);

(statearr_31618[(13)] = inst_31568);

return statearr_31618;
})();
if(cljs.core.truth_(inst_31570)){
var statearr_31619_31645 = state_31588__$1;
(statearr_31619_31645[(1)] = (16));

} else {
var statearr_31620_31646 = state_31588__$1;
(statearr_31620_31646[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto____0 = (function (){
var statearr_31621 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31621[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto__);

(statearr_31621[(1)] = (1));

return statearr_31621;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto____1 = (function (state_31588){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31588);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31622){var ex__13886__auto__ = e31622;
var statearr_31623_31647 = state_31588;
(statearr_31623_31647[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31588[(4)]))){
var statearr_31624_31648 = state_31588;
(statearr_31624_31648[(1)] = cljs.core.first((state_31588[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31649 = state_31588;
state_31588 = G__31649;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto__ = function(state_31588){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto____1.call(this,state_31588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31625 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31625[(6)] = c__13957__auto__);

return statearr_31625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4160__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__31650_31660 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__31651_31661 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__31650_31660,G__31651_31661) : object_cache.call(null,G__31650_31660,G__31651_31661));

var G__31652 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__31653 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__31654 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__31655 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__31654,G__31655) : object_cache.call(null,G__31654,G__31655));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__31652,G__31653) : object_cache.call(null,G__31652,G__31653));
} else {
var G__31656 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__31657 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__31658 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__31659 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__31658,G__31659) : object_cache.call(null,G__31658,G__31659));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__31656,G__31657) : object_cache.call(null,G__31656,G__31657));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31682){
var state_val_31683 = (state_31682[(1)]);
if((state_val_31683 === (7))){
var state_31682__$1 = state_31682;
var statearr_31684_31704 = state_31682__$1;
(statearr_31684_31704[(2)] = null);

(statearr_31684_31704[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31683 === (1))){
var state_31682__$1 = state_31682;
var statearr_31685_31705 = state_31682__$1;
(statearr_31685_31705[(2)] = null);

(statearr_31685_31705[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31683 === (4))){
var inst_31662 = (state_31682[(2)]);
var state_31682__$1 = state_31682;
var statearr_31686_31706 = state_31682__$1;
(statearr_31686_31706[(2)] = inst_31662);

(statearr_31686_31706[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31683 === (6))){
var inst_31668 = (state_31682[(7)]);
var inst_31670 = fluree.db.storage.core.serde(conn);
var state_31682__$1 = (function (){var statearr_31687 = state_31682;
(statearr_31687[(8)] = inst_31670);

return statearr_31687;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31682__$1,(9),inst_31668);
} else {
if((state_val_31683 === (3))){
var inst_31680 = (state_31682[(2)]);
var state_31682__$1 = state_31682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31682__$1,inst_31680);
} else {
if((state_val_31683 === (2))){
var inst_31668 = (state_31682[(7)]);
var _ = (function (){var statearr_31689 = state_31682;
(statearr_31689[(4)] = cljs.core.cons((5),(state_31682[(4)])));

return statearr_31689;
})();
var inst_31668__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_31682__$1 = (function (){var statearr_31690 = state_31682;
(statearr_31690[(7)] = inst_31668__$1);

return statearr_31690;
})();
if(cljs.core.truth_(inst_31668__$1)){
var statearr_31691_31707 = state_31682__$1;
(statearr_31691_31707[(1)] = (6));

} else {
var statearr_31692_31708 = state_31682__$1;
(statearr_31692_31708[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31683 === (9))){
var inst_31670 = (state_31682[(8)]);
var inst_31672 = (state_31682[(2)]);
var inst_31673 = fluree.db.util.async.throw_err(inst_31672);
var inst_31674 = fluree.db.serde.protocol._deserialize_branch(inst_31670,inst_31673);
var state_31682__$1 = state_31682;
var statearr_31693_31709 = state_31682__$1;
(statearr_31693_31709[(2)] = inst_31674);

(statearr_31693_31709[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31683 === (5))){
var _ = (function (){var statearr_31694 = state_31682;
(statearr_31694[(4)] = cljs.core.rest((state_31682[(4)])));

return statearr_31694;
})();
var state_31682__$1 = state_31682;
var ex31688 = (state_31682__$1[(2)]);
var statearr_31695_31710 = state_31682__$1;
(statearr_31695_31710[(5)] = ex31688);


if((ex31688 instanceof Error)){
var statearr_31696_31711 = state_31682__$1;
(statearr_31696_31711[(1)] = (4));

(statearr_31696_31711[(5)] = null);

} else {
throw ex31688;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31683 === (8))){
var inst_31677 = (state_31682[(2)]);
var _ = (function (){var statearr_31697 = state_31682;
(statearr_31697[(4)] = cljs.core.rest((state_31682[(4)])));

return statearr_31697;
})();
var state_31682__$1 = state_31682;
var statearr_31698_31712 = state_31682__$1;
(statearr_31698_31712[(2)] = inst_31677);

(statearr_31698_31712[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__13883__auto____0 = (function (){
var statearr_31699 = [null,null,null,null,null,null,null,null,null];
(statearr_31699[(0)] = fluree$db$storage$core$read_branch_$_state_machine__13883__auto__);

(statearr_31699[(1)] = (1));

return statearr_31699;
});
var fluree$db$storage$core$read_branch_$_state_machine__13883__auto____1 = (function (state_31682){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31682);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31700){var ex__13886__auto__ = e31700;
var statearr_31701_31713 = state_31682;
(statearr_31701_31713[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31682[(4)]))){
var statearr_31702_31714 = state_31682;
(statearr_31702_31714[(1)] = cljs.core.first((state_31682[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31715 = state_31682;
state_31682 = G__31715;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__13883__auto__ = function(state_31682){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__13883__auto____1.call(this,state_31682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__13883__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__13883__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31703 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31703[(6)] = c__13957__auto__);

return statearr_31703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___31794 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31766){
var state_val_31767 = (state_31766[(1)]);
if((state_val_31767 === (7))){
var inst_31733 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_31734 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31735 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_31736 = cljs.core.PersistentHashMap.fromArrays(inst_31734,inst_31735);
var inst_31737 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31733,inst_31736);
var inst_31738 = (function(){throw inst_31737})();
var state_31766__$1 = state_31766;
var statearr_31768_31795 = state_31766__$1;
(statearr_31768_31795[(2)] = inst_31738);

(statearr_31768_31795[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31767 === (1))){
var state_31766__$1 = state_31766;
var statearr_31769_31796 = state_31766__$1;
(statearr_31769_31796[(2)] = null);

(statearr_31769_31796[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31767 === (4))){
var inst_31716 = (state_31766[(2)]);
var inst_31717 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_31718 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_31716);
var inst_31719 = cljs.core.async.close_BANG_(return_ch);
var state_31766__$1 = (function (){var statearr_31770 = state_31766;
(statearr_31770[(7)] = inst_31717);

(statearr_31770[(8)] = inst_31718);

return statearr_31770;
})();
var statearr_31771_31797 = state_31766__$1;
(statearr_31771_31797[(2)] = inst_31719);

(statearr_31771_31797[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31767 === (6))){
var inst_31730 = (state_31766[(9)]);
var inst_31729 = (state_31766[(2)]);
var inst_31730__$1 = fluree.db.util.async.throw_err(inst_31729);
var inst_31731 = (inst_31730__$1 == null);
var state_31766__$1 = (function (){var statearr_31772 = state_31766;
(statearr_31772[(9)] = inst_31730__$1);

return statearr_31772;
})();
if(cljs.core.truth_(inst_31731)){
var statearr_31773_31798 = state_31766__$1;
(statearr_31773_31798[(1)] = (7));

} else {
var statearr_31774_31799 = state_31766__$1;
(statearr_31774_31799[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31767 === (3))){
var inst_31764 = (state_31766[(2)]);
var state_31766__$1 = state_31766;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31766__$1,inst_31764);
} else {
if((state_val_31767 === (12))){
var inst_31730 = (state_31766[(9)]);
var inst_31747 = (state_31766[(2)]);
var inst_31748 = cljs.core.__destructure_map(inst_31730);
var inst_31749 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31748,cljs.core.cst$kw$children);
var inst_31750 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31748,cljs.core.cst$kw$rhs);
var inst_31751 = config;
var inst_31752 = cljs.core.__destructure_map(inst_31751);
var inst_31753 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31752,cljs.core.cst$kw$comparator);
var inst_31755 = (function (){var data = inst_31730;
var _ = inst_31747;
var map__31725 = inst_31748;
var children = inst_31749;
var rhs = inst_31750;
var map__31726 = inst_31752;
var comparator = inst_31753;
return (function (idx,p__31754){
var map__31775 = p__31754;
var map__31775__$1 = cljs.core.__destructure_map(map__31775);
var child = map__31775__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31775__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31775__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31775__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31775__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31775__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__4149__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4149__auto__)){
return (idx === (0));
} else {
return and__4149__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_31756 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_31755,inst_31749);
var inst_31757 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_31756);
var inst_31758 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_31757,inst_31756);
var inst_31759 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_31753,inst_31758);
var inst_31760 = fluree.db.index.__GT_IndexNode(block,t,inst_31750,inst_31759,config,leftmost_QMARK_);
var inst_31761 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_31760);
var _ = (function (){var statearr_31776 = state_31766;
(statearr_31776[(4)] = cljs.core.rest((state_31766[(4)])));

return statearr_31776;
})();
var state_31766__$1 = state_31766;
var statearr_31777_31800 = state_31766__$1;
(statearr_31777_31800[(2)] = inst_31761);

(statearr_31777_31800[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31767 === (2))){
var _ = (function (){var statearr_31778 = state_31766;
(statearr_31778[(4)] = cljs.core.cons((5),(state_31766[(4)])));

return statearr_31778;
})();
var inst_31727 = fluree.db.storage.core.read_branch(conn,key);
var state_31766__$1 = state_31766;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31766__$1,(6),inst_31727);
} else {
if((state_val_31767 === (11))){
var state_31766__$1 = state_31766;
var statearr_31780_31801 = state_31766__$1;
(statearr_31780_31801[(2)] = null);

(statearr_31780_31801[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31767 === (9))){
var inst_31730 = (state_31766[(9)]);
var inst_31741 = (state_31766[(2)]);
var inst_31742 = fluree.db.util.core.exception_QMARK_(inst_31730);
var state_31766__$1 = (function (){var statearr_31781 = state_31766;
(statearr_31781[(10)] = inst_31741);

return statearr_31781;
})();
if(inst_31742){
var statearr_31782_31802 = state_31766__$1;
(statearr_31782_31802[(1)] = (10));

} else {
var statearr_31783_31803 = state_31766__$1;
(statearr_31783_31803[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31767 === (5))){
var _ = (function (){var statearr_31784 = state_31766;
(statearr_31784[(4)] = cljs.core.rest((state_31766[(4)])));

return statearr_31784;
})();
var state_31766__$1 = state_31766;
var ex31779 = (state_31766__$1[(2)]);
var statearr_31785_31804 = state_31766__$1;
(statearr_31785_31804[(5)] = ex31779);


var statearr_31786_31805 = state_31766__$1;
(statearr_31786_31805[(1)] = (4));

(statearr_31786_31805[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31767 === (10))){
var inst_31730 = (state_31766[(9)]);
var inst_31744 = (function(){throw inst_31730})();
var state_31766__$1 = state_31766;
var statearr_31787_31806 = state_31766__$1;
(statearr_31787_31806[(2)] = inst_31744);

(statearr_31787_31806[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31767 === (8))){
var state_31766__$1 = state_31766;
var statearr_31788_31807 = state_31766__$1;
(statearr_31788_31807[(2)] = null);

(statearr_31788_31807[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__13883__auto____0 = (function (){
var statearr_31789 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31789[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__13883__auto__);

(statearr_31789[(1)] = (1));

return statearr_31789;
});
var fluree$db$storage$core$reify_branch_$_state_machine__13883__auto____1 = (function (state_31766){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31766);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31790){var ex__13886__auto__ = e31790;
var statearr_31791_31808 = state_31766;
(statearr_31791_31808[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31766[(4)]))){
var statearr_31792_31809 = state_31766;
(statearr_31792_31809[(1)] = cljs.core.first((state_31766[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31810 = state_31766;
state_31766 = G__31810;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__13883__auto__ = function(state_31766){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__13883__auto____1.call(this,state_31766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__13883__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__13883__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31793 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31793[(6)] = c__13957__auto___31794);

return statearr_31793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31831){
var state_val_31832 = (state_31831[(1)]);
if((state_val_31832 === (7))){
var state_31831__$1 = state_31831;
var statearr_31833_31853 = state_31831__$1;
(statearr_31833_31853[(2)] = null);

(statearr_31833_31853[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31832 === (1))){
var state_31831__$1 = state_31831;
var statearr_31834_31854 = state_31831__$1;
(statearr_31834_31854[(2)] = null);

(statearr_31834_31854[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31832 === (4))){
var inst_31811 = (state_31831[(2)]);
var state_31831__$1 = state_31831;
var statearr_31835_31855 = state_31831__$1;
(statearr_31835_31855[(2)] = inst_31811);

(statearr_31835_31855[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31832 === (6))){
var inst_31817 = (state_31831[(7)]);
var inst_31819 = fluree.db.storage.core.serde(conn);
var state_31831__$1 = (function (){var statearr_31836 = state_31831;
(statearr_31836[(8)] = inst_31819);

return statearr_31836;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31831__$1,(9),inst_31817);
} else {
if((state_val_31832 === (3))){
var inst_31829 = (state_31831[(2)]);
var state_31831__$1 = state_31831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31831__$1,inst_31829);
} else {
if((state_val_31832 === (2))){
var inst_31817 = (state_31831[(7)]);
var _ = (function (){var statearr_31838 = state_31831;
(statearr_31838[(4)] = cljs.core.cons((5),(state_31831[(4)])));

return statearr_31838;
})();
var inst_31817__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_31831__$1 = (function (){var statearr_31839 = state_31831;
(statearr_31839[(7)] = inst_31817__$1);

return statearr_31839;
})();
if(cljs.core.truth_(inst_31817__$1)){
var statearr_31840_31856 = state_31831__$1;
(statearr_31840_31856[(1)] = (6));

} else {
var statearr_31841_31857 = state_31831__$1;
(statearr_31841_31857[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31832 === (9))){
var inst_31819 = (state_31831[(8)]);
var inst_31821 = (state_31831[(2)]);
var inst_31822 = fluree.db.util.async.throw_err(inst_31821);
var inst_31823 = fluree.db.serde.protocol._deserialize_leaf(inst_31819,inst_31822);
var state_31831__$1 = state_31831;
var statearr_31842_31858 = state_31831__$1;
(statearr_31842_31858[(2)] = inst_31823);

(statearr_31842_31858[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31832 === (5))){
var _ = (function (){var statearr_31843 = state_31831;
(statearr_31843[(4)] = cljs.core.rest((state_31831[(4)])));

return statearr_31843;
})();
var state_31831__$1 = state_31831;
var ex31837 = (state_31831__$1[(2)]);
var statearr_31844_31859 = state_31831__$1;
(statearr_31844_31859[(5)] = ex31837);


if((ex31837 instanceof Error)){
var statearr_31845_31860 = state_31831__$1;
(statearr_31845_31860[(1)] = (4));

(statearr_31845_31860[(5)] = null);

} else {
throw ex31837;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31832 === (8))){
var inst_31826 = (state_31831[(2)]);
var _ = (function (){var statearr_31846 = state_31831;
(statearr_31846[(4)] = cljs.core.rest((state_31831[(4)])));

return statearr_31846;
})();
var state_31831__$1 = state_31831;
var statearr_31847_31861 = state_31831__$1;
(statearr_31847_31861[(2)] = inst_31826);

(statearr_31847_31861[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__13883__auto____0 = (function (){
var statearr_31848 = [null,null,null,null,null,null,null,null,null];
(statearr_31848[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__13883__auto__);

(statearr_31848[(1)] = (1));

return statearr_31848;
});
var fluree$db$storage$core$read_leaf_$_state_machine__13883__auto____1 = (function (state_31831){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31831);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31849){var ex__13886__auto__ = e31849;
var statearr_31850_31862 = state_31831;
(statearr_31850_31862[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31831[(4)]))){
var statearr_31851_31863 = state_31831;
(statearr_31851_31863[(1)] = cljs.core.first((state_31831[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31864 = state_31831;
state_31831 = G__31864;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__13883__auto__ = function(state_31831){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__13883__auto____1.call(this,state_31831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__13883__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__13883__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31852 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31852[(6)] = c__13957__auto__);

return statearr_31852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___31937 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_31909){
var state_val_31910 = (state_31909[(1)]);
if((state_val_31910 === (7))){
var inst_31881 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_31882 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31883 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_31884 = cljs.core.PersistentHashMap.fromArrays(inst_31882,inst_31883);
var inst_31885 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31881,inst_31884);
var inst_31886 = (function(){throw inst_31885})();
var state_31909__$1 = state_31909;
var statearr_31911_31938 = state_31909__$1;
(statearr_31911_31938[(2)] = inst_31886);

(statearr_31911_31938[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31910 === (1))){
var state_31909__$1 = state_31909;
var statearr_31912_31939 = state_31909__$1;
(statearr_31912_31939[(2)] = null);

(statearr_31912_31939[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31910 === (4))){
var inst_31865 = (state_31909[(2)]);
var inst_31866 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_31867 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_31865);
var inst_31868 = cljs.core.async.close_BANG_(return_ch);
var state_31909__$1 = (function (){var statearr_31913 = state_31909;
(statearr_31913[(7)] = inst_31866);

(statearr_31913[(8)] = inst_31867);

return statearr_31913;
})();
var statearr_31914_31940 = state_31909__$1;
(statearr_31914_31940[(2)] = inst_31868);

(statearr_31914_31940[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31910 === (6))){
var inst_31878 = (state_31909[(9)]);
var inst_31878__$1 = (state_31909[(2)]);
var inst_31879 = (inst_31878__$1 == null);
var state_31909__$1 = (function (){var statearr_31915 = state_31909;
(statearr_31915[(9)] = inst_31878__$1);

return statearr_31915;
})();
if(cljs.core.truth_(inst_31879)){
var statearr_31916_31941 = state_31909__$1;
(statearr_31916_31941[(1)] = (7));

} else {
var statearr_31917_31942 = state_31909__$1;
(statearr_31917_31942[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31910 === (3))){
var inst_31907 = (state_31909[(2)]);
var state_31909__$1 = state_31909;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31909__$1,inst_31907);
} else {
if((state_val_31910 === (12))){
var inst_31878 = (state_31909[(9)]);
var inst_31895 = (state_31909[(2)]);
var inst_31896 = cljs.core.__destructure_map(inst_31878);
var inst_31897 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31896,cljs.core.cst$kw$flakes);
var inst_31898 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31896,cljs.core.cst$kw$his);
var inst_31899 = config;
var inst_31900 = cljs.core.__destructure_map(inst_31899);
var inst_31901 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31900,cljs.core.cst$kw$comparator);
var inst_31902 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_31901,inst_31897);
var inst_31903 = fluree.db.index.data_node(block,t,inst_31902,rhs,config);
var inst_31904 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_31903);
var _ = (function (){var statearr_31918 = state_31909;
(statearr_31918[(4)] = cljs.core.rest((state_31909[(4)])));

return statearr_31918;
})();
var state_31909__$1 = (function (){var statearr_31919 = state_31909;
(statearr_31919[(10)] = inst_31898);

(statearr_31919[(11)] = inst_31895);

return statearr_31919;
})();
var statearr_31920_31943 = state_31909__$1;
(statearr_31920_31943[(2)] = inst_31904);

(statearr_31920_31943[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31910 === (2))){
var _ = (function (){var statearr_31921 = state_31909;
(statearr_31921[(4)] = cljs.core.cons((5),(state_31909[(4)])));

return statearr_31921;
})();
var inst_31876 = fluree.db.storage.core.read_leaf(conn,key);
var state_31909__$1 = state_31909;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31909__$1,(6),inst_31876);
} else {
if((state_val_31910 === (11))){
var state_31909__$1 = state_31909;
var statearr_31923_31944 = state_31909__$1;
(statearr_31923_31944[(2)] = null);

(statearr_31923_31944[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31910 === (9))){
var inst_31878 = (state_31909[(9)]);
var inst_31889 = (state_31909[(2)]);
var inst_31890 = fluree.db.util.core.exception_QMARK_(inst_31878);
var state_31909__$1 = (function (){var statearr_31924 = state_31909;
(statearr_31924[(12)] = inst_31889);

return statearr_31924;
})();
if(inst_31890){
var statearr_31925_31945 = state_31909__$1;
(statearr_31925_31945[(1)] = (10));

} else {
var statearr_31926_31946 = state_31909__$1;
(statearr_31926_31946[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31910 === (5))){
var _ = (function (){var statearr_31927 = state_31909;
(statearr_31927[(4)] = cljs.core.rest((state_31909[(4)])));

return statearr_31927;
})();
var state_31909__$1 = state_31909;
var ex31922 = (state_31909__$1[(2)]);
var statearr_31928_31947 = state_31909__$1;
(statearr_31928_31947[(5)] = ex31922);


var statearr_31929_31948 = state_31909__$1;
(statearr_31929_31948[(1)] = (4));

(statearr_31929_31948[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31910 === (10))){
var inst_31878 = (state_31909[(9)]);
var inst_31892 = (function(){throw inst_31878})();
var state_31909__$1 = state_31909;
var statearr_31930_31949 = state_31909__$1;
(statearr_31930_31949[(2)] = inst_31892);

(statearr_31930_31949[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31910 === (8))){
var state_31909__$1 = state_31909;
var statearr_31931_31950 = state_31909__$1;
(statearr_31931_31950[(2)] = null);

(statearr_31931_31950[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto____0 = (function (){
var statearr_31932 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31932[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto__);

(statearr_31932[(1)] = (1));

return statearr_31932;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto____1 = (function (state_31909){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_31909);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e31933){var ex__13886__auto__ = e31933;
var statearr_31934_31951 = state_31909;
(statearr_31934_31951[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_31909[(4)]))){
var statearr_31935_31952 = state_31909;
(statearr_31935_31952[(1)] = cljs.core.first((state_31909[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__31953 = state_31909;
state_31909 = G__31953;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto__ = function(state_31909){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto____1.call(this,state_31909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_31936 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_31936[(6)] = c__13957__auto___31937);

return statearr_31936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k31955,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__31959 = k31955;
var G__31959__$1 = (((G__31959 instanceof cljs.core.Keyword))?G__31959.fqn:null);
switch (G__31959__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31955,else__4418__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__31960){
var vec__31961 = p__31960;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31961,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31961,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31954){
var self__ = this;
var G__31954__$1 = this;
return (new cljs.core.RecordIter((0),G__31954__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__31964 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__31965 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__31966 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__31967 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__31966,G__31967) : object_cache.call(null,G__31966,G__31967));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__31968 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__31969 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__31968,G__31969) : object_cache.call(null,G__31968,G__31969));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__31964,G__31965) : object_cache.call(null,G__31964,G__31965));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__31970 = history_id;
var G__31971 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__31970,G__31971) : object_cache.call(null,G__31970,G__31971));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__31972 = (function (coll__4412__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__31972(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31956,other31957){
var self__ = this;
var this31956__$1 = this;
return (((!((other31957 == null)))) && ((this31956__$1.constructor === other31957.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.conn,other31957.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.config,other31957.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.network,other31957.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.dbid,other31957.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.id,other31957.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.leaf,other31957.leaf)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.first,other31957.first)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.rhs,other31957.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.size,other31957.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.block,other31957.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.t,other31957.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.tt_id,other31957.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.leftmost_QMARK_,other31957.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.tempid,other31957.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31956__$1.__extmap,other31957.__extmap)));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__31954){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__31973 = cljs.core.keyword_identical_QMARK_;
var expr__31974 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__31976 = cljs.core.cst$kw$conn;
var G__31977 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__31976,G__31977) : pred__31973.call(null,G__31976,G__31977));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__31954,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31978 = cljs.core.cst$kw$config;
var G__31979 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__31978,G__31979) : pred__31973.call(null,G__31978,G__31979));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__31954,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31980 = cljs.core.cst$kw$network;
var G__31981 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__31980,G__31981) : pred__31973.call(null,G__31980,G__31981));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__31954,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31982 = cljs.core.cst$kw$dbid;
var G__31983 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__31982,G__31983) : pred__31973.call(null,G__31982,G__31983));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__31954,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31984 = cljs.core.cst$kw$id;
var G__31985 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__31984,G__31985) : pred__31973.call(null,G__31984,G__31985));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__31954,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31986 = cljs.core.cst$kw$leaf;
var G__31987 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__31986,G__31987) : pred__31973.call(null,G__31986,G__31987));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__31954,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31988 = cljs.core.cst$kw$first;
var G__31989 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__31988,G__31989) : pred__31973.call(null,G__31988,G__31989));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__31954,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31990 = cljs.core.cst$kw$rhs;
var G__31991 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__31990,G__31991) : pred__31973.call(null,G__31990,G__31991));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__31954,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31992 = cljs.core.cst$kw$size;
var G__31993 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__31992,G__31993) : pred__31973.call(null,G__31992,G__31993));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__31954,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31994 = cljs.core.cst$kw$block;
var G__31995 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__31994,G__31995) : pred__31973.call(null,G__31994,G__31995));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__31954,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31996 = cljs.core.cst$kw$t;
var G__31997 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__31996,G__31997) : pred__31973.call(null,G__31996,G__31997));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__31954,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31998 = cljs.core.cst$kw$tt_DASH_id;
var G__31999 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__31998,G__31999) : pred__31973.call(null,G__31998,G__31999));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__31954,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32000 = cljs.core.cst$kw$leftmost_QMARK_;
var G__32001 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__32000,G__32001) : pred__31973.call(null,G__32000,G__32001));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__31954,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32002 = cljs.core.cst$kw$tempid;
var G__32003 = expr__31974;
return (pred__31973.cljs$core$IFn$_invoke$arity$2 ? pred__31973.cljs$core$IFn$_invoke$arity$2(G__32002,G__32003) : pred__31973.call(null,G__32002,G__32003));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__31954,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__31954),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__31954){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__31954,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__31958){
var extmap__4454__auto__ = (function (){var G__32004 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31958,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__31958)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32004);
} else {
return G__32004;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__31958),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__31958),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__31958),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__31958),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__31958),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__31958),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__31958),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__31958),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__31958),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__31958),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__31958),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__31958),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__31958),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__31958),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__32006 = blank_db;
var map__32006__$1 = cljs.core.__destructure_map(map__32006);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32006__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32006__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32006__$1,cljs.core.cst$kw$index_DASH_configs);
var map__32007 = root_data;
var map__32007__$1 = cljs.core.__destructure_map(map__32007);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32007__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32007__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32007__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32007__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_32029){
var state_val_32030 = (state_32029[(1)]);
if((state_val_32030 === (7))){
var state_32029__$1 = state_32029;
var statearr_32031_32051 = state_32029__$1;
(statearr_32031_32051[(2)] = null);

(statearr_32031_32051[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32030 === (1))){
var state_32029__$1 = state_32029;
var statearr_32032_32052 = state_32029__$1;
(statearr_32032_32052[(2)] = null);

(statearr_32032_32052[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32030 === (4))){
var inst_32008 = (state_32029[(2)]);
var state_32029__$1 = state_32029;
var statearr_32033_32053 = state_32029__$1;
(statearr_32033_32053[(2)] = inst_32008);

(statearr_32033_32053[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32030 === (6))){
var inst_32015 = (state_32029[(7)]);
var inst_32017 = fluree.db.storage.core.serde(conn);
var state_32029__$1 = (function (){var statearr_32034 = state_32029;
(statearr_32034[(8)] = inst_32017);

return statearr_32034;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32029__$1,(9),inst_32015);
} else {
if((state_val_32030 === (3))){
var inst_32027 = (state_32029[(2)]);
var state_32029__$1 = state_32029;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32029__$1,inst_32027);
} else {
if((state_val_32030 === (2))){
var inst_32015 = (state_32029[(7)]);
var _ = (function (){var statearr_32036 = state_32029;
(statearr_32036[(4)] = cljs.core.cons((5),(state_32029[(4)])));

return statearr_32036;
})();
var inst_32014 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_32015__$1 = fluree.db.storage.core.storage_read(conn,inst_32014);
var state_32029__$1 = (function (){var statearr_32037 = state_32029;
(statearr_32037[(7)] = inst_32015__$1);

return statearr_32037;
})();
if(cljs.core.truth_(inst_32015__$1)){
var statearr_32038_32054 = state_32029__$1;
(statearr_32038_32054[(1)] = (6));

} else {
var statearr_32039_32055 = state_32029__$1;
(statearr_32039_32055[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32030 === (9))){
var inst_32017 = (state_32029[(8)]);
var inst_32019 = (state_32029[(2)]);
var inst_32020 = fluree.db.util.async.throw_err(inst_32019);
var inst_32021 = fluree.db.serde.protocol._deserialize_garbage(inst_32017,inst_32020);
var state_32029__$1 = state_32029;
var statearr_32040_32056 = state_32029__$1;
(statearr_32040_32056[(2)] = inst_32021);

(statearr_32040_32056[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32030 === (5))){
var _ = (function (){var statearr_32041 = state_32029;
(statearr_32041[(4)] = cljs.core.rest((state_32029[(4)])));

return statearr_32041;
})();
var state_32029__$1 = state_32029;
var ex32035 = (state_32029__$1[(2)]);
var statearr_32042_32057 = state_32029__$1;
(statearr_32042_32057[(5)] = ex32035);


if((ex32035 instanceof Error)){
var statearr_32043_32058 = state_32029__$1;
(statearr_32043_32058[(1)] = (4));

(statearr_32043_32058[(5)] = null);

} else {
throw ex32035;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32030 === (8))){
var inst_32024 = (state_32029[(2)]);
var _ = (function (){var statearr_32044 = state_32029;
(statearr_32044[(4)] = cljs.core.rest((state_32029[(4)])));

return statearr_32044;
})();
var state_32029__$1 = state_32029;
var statearr_32045_32059 = state_32029__$1;
(statearr_32045_32059[(2)] = inst_32024);

(statearr_32045_32059[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__13883__auto____0 = (function (){
var statearr_32046 = [null,null,null,null,null,null,null,null,null];
(statearr_32046[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__13883__auto__);

(statearr_32046[(1)] = (1));

return statearr_32046;
});
var fluree$db$storage$core$read_garbage_$_state_machine__13883__auto____1 = (function (state_32029){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_32029);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e32047){var ex__13886__auto__ = e32047;
var statearr_32048_32060 = state_32029;
(statearr_32048_32060[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_32029[(4)]))){
var statearr_32049_32061 = state_32029;
(statearr_32049_32061[(1)] = cljs.core.first((state_32029[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__32062 = state_32029;
state_32029 = G__32062;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__13883__auto__ = function(state_32029){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__13883__auto____1.call(this,state_32029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__13883__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__13883__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_32050 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_32050[(6)] = c__13957__auto__);

return statearr_32050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_32084){
var state_val_32085 = (state_32084[(1)]);
if((state_val_32085 === (7))){
var state_32084__$1 = state_32084;
var statearr_32086_32106 = state_32084__$1;
(statearr_32086_32106[(2)] = null);

(statearr_32086_32106[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32085 === (1))){
var state_32084__$1 = state_32084;
var statearr_32087_32107 = state_32084__$1;
(statearr_32087_32107[(2)] = null);

(statearr_32087_32107[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32085 === (4))){
var inst_32063 = (state_32084[(2)]);
var state_32084__$1 = state_32084;
var statearr_32088_32108 = state_32084__$1;
(statearr_32088_32108[(2)] = inst_32063);

(statearr_32088_32108[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32085 === (6))){
var inst_32070 = (state_32084[(7)]);
var inst_32072 = fluree.db.storage.core.serde(conn);
var state_32084__$1 = (function (){var statearr_32089 = state_32084;
(statearr_32089[(8)] = inst_32072);

return statearr_32089;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32084__$1,(9),inst_32070);
} else {
if((state_val_32085 === (3))){
var inst_32082 = (state_32084[(2)]);
var state_32084__$1 = state_32084;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32084__$1,inst_32082);
} else {
if((state_val_32085 === (2))){
var inst_32070 = (state_32084[(7)]);
var _ = (function (){var statearr_32091 = state_32084;
(statearr_32091[(4)] = cljs.core.cons((5),(state_32084[(4)])));

return statearr_32091;
})();
var inst_32069 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_32070__$1 = fluree.db.storage.core.storage_read(conn,inst_32069);
var state_32084__$1 = (function (){var statearr_32092 = state_32084;
(statearr_32092[(7)] = inst_32070__$1);

return statearr_32092;
})();
if(cljs.core.truth_(inst_32070__$1)){
var statearr_32093_32109 = state_32084__$1;
(statearr_32093_32109[(1)] = (6));

} else {
var statearr_32094_32110 = state_32084__$1;
(statearr_32094_32110[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32085 === (9))){
var inst_32072 = (state_32084[(8)]);
var inst_32074 = (state_32084[(2)]);
var inst_32075 = fluree.db.util.async.throw_err(inst_32074);
var inst_32076 = fluree.db.serde.protocol._deserialize_db_root(inst_32072,inst_32075);
var state_32084__$1 = state_32084;
var statearr_32095_32111 = state_32084__$1;
(statearr_32095_32111[(2)] = inst_32076);

(statearr_32095_32111[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32085 === (5))){
var _ = (function (){var statearr_32096 = state_32084;
(statearr_32096[(4)] = cljs.core.rest((state_32084[(4)])));

return statearr_32096;
})();
var state_32084__$1 = state_32084;
var ex32090 = (state_32084__$1[(2)]);
var statearr_32097_32112 = state_32084__$1;
(statearr_32097_32112[(5)] = ex32090);


if((ex32090 instanceof Error)){
var statearr_32098_32113 = state_32084__$1;
(statearr_32098_32113[(1)] = (4));

(statearr_32098_32113[(5)] = null);

} else {
throw ex32090;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32085 === (8))){
var inst_32079 = (state_32084[(2)]);
var _ = (function (){var statearr_32099 = state_32084;
(statearr_32099[(4)] = cljs.core.rest((state_32084[(4)])));

return statearr_32099;
})();
var state_32084__$1 = state_32084;
var statearr_32100_32114 = state_32084__$1;
(statearr_32100_32114[(2)] = inst_32079);

(statearr_32100_32114[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__13883__auto____0 = (function (){
var statearr_32101 = [null,null,null,null,null,null,null,null,null];
(statearr_32101[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__13883__auto__);

(statearr_32101[(1)] = (1));

return statearr_32101;
});
var fluree$db$storage$core$read_db_root_$_state_machine__13883__auto____1 = (function (state_32084){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_32084);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e32102){var ex__13886__auto__ = e32102;
var statearr_32103_32115 = state_32084;
(statearr_32103_32115[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_32084[(4)]))){
var statearr_32104_32116 = state_32084;
(statearr_32104_32116[(1)] = cljs.core.first((state_32084[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__32117 = state_32084;
state_32084 = G__32117;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__13883__auto__ = function(state_32084){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__13883__auto____1.call(this,state_32084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__13883__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__13883__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_32105 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_32105[(6)] = c__13957__auto__);

return statearr_32105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_32153){
var state_val_32154 = (state_32153[(1)]);
if((state_val_32154 === (7))){
var inst_32127 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_32128 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32129 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_32130 = cljs.core.PersistentHashMap.fromArrays(inst_32128,inst_32129);
var inst_32131 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32127,inst_32130);
var inst_32132 = (function(){throw inst_32131})();
var state_32153__$1 = state_32153;
var statearr_32155_32177 = state_32153__$1;
(statearr_32155_32177[(2)] = inst_32132);

(statearr_32155_32177[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32154 === (1))){
var state_32153__$1 = state_32153;
var statearr_32156_32178 = state_32153__$1;
(statearr_32156_32178[(2)] = null);

(statearr_32156_32178[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32154 === (4))){
var inst_32118 = (state_32153[(2)]);
var state_32153__$1 = state_32153;
var statearr_32157_32179 = state_32153__$1;
(statearr_32157_32179[(2)] = inst_32118);

(statearr_32157_32179[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32154 === (6))){
var state_32153__$1 = state_32153;
var statearr_32158_32180 = state_32153__$1;
(statearr_32158_32180[(2)] = null);

(statearr_32158_32180[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32154 === (3))){
var inst_32151 = (state_32153[(2)]);
var state_32153__$1 = state_32153;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32153__$1,inst_32151);
} else {
if((state_val_32154 === (2))){
var inst_32124 = (state_32153[(7)]);
var _ = (function (){var statearr_32159 = state_32153;
(statearr_32159[(4)] = cljs.core.cons((5),(state_32153[(4)])));

return statearr_32159;
})();
var inst_32124__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_32153__$1 = (function (){var statearr_32160 = state_32153;
(statearr_32160[(7)] = inst_32124__$1);

return statearr_32160;
})();
if(cljs.core.truth_(inst_32124__$1)){
var statearr_32161_32181 = state_32153__$1;
(statearr_32161_32181[(1)] = (6));

} else {
var statearr_32162_32182 = state_32153__$1;
(statearr_32162_32182[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32154 === (11))){
var inst_32143 = (state_32153[(8)]);
var inst_32146 = (state_32153[(2)]);
var inst_32147 = fluree.db.util.async.throw_err(inst_32146);
var inst_32148 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_32143,cljs.core.cst$kw$settings,inst_32147);
var _ = (function (){var statearr_32164 = state_32153;
(statearr_32164[(4)] = cljs.core.rest((state_32153[(4)])));

return statearr_32164;
})();
var state_32153__$1 = state_32153;
var statearr_32165_32183 = state_32153__$1;
(statearr_32165_32183[(2)] = inst_32148);

(statearr_32165_32183[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32154 === (9))){
var inst_32138 = (state_32153[(9)]);
var inst_32136 = (state_32153[(2)]);
var inst_32137 = fluree.db.util.async.throw_err(inst_32136);
var inst_32138__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_32137);
var inst_32139 = fluree.db.query.schema.schema_map(inst_32138__$1);
var state_32153__$1 = (function (){var statearr_32166 = state_32153;
(statearr_32166[(9)] = inst_32138__$1);

return statearr_32166;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32153__$1,(10),inst_32139);
} else {
if((state_val_32154 === (5))){
var _ = (function (){var statearr_32167 = state_32153;
(statearr_32167[(4)] = cljs.core.rest((state_32153[(4)])));

return statearr_32167;
})();
var state_32153__$1 = state_32153;
var ex32163 = (state_32153__$1[(2)]);
var statearr_32168_32184 = state_32153__$1;
(statearr_32168_32184[(5)] = ex32163);


if((ex32163 instanceof Error)){
var statearr_32169_32185 = state_32153__$1;
(statearr_32169_32185[(1)] = (4));

(statearr_32169_32185[(5)] = null);

} else {
throw ex32163;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32154 === (10))){
var inst_32143 = (state_32153[(8)]);
var inst_32138 = (state_32153[(9)]);
var inst_32141 = (state_32153[(2)]);
var inst_32142 = fluree.db.util.async.throw_err(inst_32141);
var inst_32143__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_32138,cljs.core.cst$kw$schema,inst_32142);
var inst_32144 = fluree.db.query.schema.setting_map(inst_32143__$1);
var state_32153__$1 = (function (){var statearr_32170 = state_32153;
(statearr_32170[(8)] = inst_32143__$1);

return statearr_32170;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32153__$1,(11),inst_32144);
} else {
if((state_val_32154 === (8))){
var inst_32124 = (state_32153[(7)]);
var inst_32134 = (state_32153[(2)]);
var state_32153__$1 = (function (){var statearr_32171 = state_32153;
(statearr_32171[(10)] = inst_32134);

return statearr_32171;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32153__$1,(9),inst_32124);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__13883__auto____0 = (function (){
var statearr_32172 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32172[(0)] = fluree$db$storage$core$reify_db_$_state_machine__13883__auto__);

(statearr_32172[(1)] = (1));

return statearr_32172;
});
var fluree$db$storage$core$reify_db_$_state_machine__13883__auto____1 = (function (state_32153){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_32153);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e32173){var ex__13886__auto__ = e32173;
var statearr_32174_32186 = state_32153;
(statearr_32174_32186[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_32153[(4)]))){
var statearr_32175_32187 = state_32153;
(statearr_32175_32187[(1)] = cljs.core.first((state_32153[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__32188 = state_32153;
state_32153 = G__32188;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__13883__auto__ = function(state_32153){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__13883__auto____1.call(this,state_32153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__13883__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__13883__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_32176 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_32176[(6)] = c__13957__auto__);

return statearr_32176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__32190 = arguments.length;
switch (G__32190) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_32240){
var state_val_32241 = (state_32240[(1)]);
if((state_val_32241 === (7))){
var inst_32200 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_32201 = (new Error(inst_32200));
var inst_32202 = (function(){throw inst_32201})();
var state_32240__$1 = state_32240;
var statearr_32242_32278 = state_32240__$1;
(statearr_32242_32278[(2)] = inst_32202);

(statearr_32242_32278[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (20))){
var inst_32229 = (state_32240[(2)]);
var state_32240__$1 = state_32240;
var statearr_32243_32279 = state_32240__$1;
(statearr_32243_32279[(2)] = inst_32229);

(statearr_32243_32279[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (1))){
var state_32240__$1 = state_32240;
var statearr_32244_32280 = state_32240__$1;
(statearr_32244_32280[(2)] = null);

(statearr_32244_32280[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (4))){
var inst_32191 = (state_32240[(2)]);
var state_32240__$1 = state_32240;
var statearr_32245_32281 = state_32240__$1;
(statearr_32245_32281[(2)] = inst_32191);

(statearr_32245_32281[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (15))){
var inst_32213 = (state_32240[(7)]);
var inst_32209 = (state_32240[(8)]);
var inst_32221 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32209,inst_32213);
var state_32240__$1 = state_32240;
var statearr_32246_32282 = state_32240__$1;
(statearr_32246_32282[(2)] = inst_32221);

(statearr_32246_32282[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (13))){
var inst_32208 = (state_32240[(9)]);
var inst_32219 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32208,end);
var state_32240__$1 = state_32240;
if(inst_32219){
var statearr_32247_32283 = state_32240__$1;
(statearr_32247_32283[(1)] = (15));

} else {
var statearr_32248_32284 = state_32240__$1;
(statearr_32248_32284[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (6))){
var state_32240__$1 = state_32240;
var statearr_32249_32285 = state_32240__$1;
(statearr_32249_32285[(2)] = null);

(statearr_32249_32285[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (17))){
var inst_32231 = (state_32240[(2)]);
var state_32240__$1 = state_32240;
var statearr_32250_32286 = state_32240__$1;
(statearr_32250_32286[(2)] = inst_32231);

(statearr_32250_32286[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (3))){
var inst_32238 = (state_32240[(2)]);
var state_32240__$1 = state_32240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32240__$1,inst_32238);
} else {
if((state_val_32241 === (12))){
var inst_32209 = (state_32240[(8)]);
var state_32240__$1 = state_32240;
var statearr_32251_32287 = state_32240__$1;
(statearr_32251_32287[(2)] = inst_32209);

(statearr_32251_32287[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (2))){
var _ = (function (){var statearr_32252 = state_32240;
(statearr_32252[(4)] = cljs.core.cons((5),(state_32240[(4)])));

return statearr_32252;
})();
var inst_32197 = (end >= start);
var state_32240__$1 = state_32240;
if(cljs.core.truth_(inst_32197)){
var statearr_32253_32288 = state_32240__$1;
(statearr_32253_32288[(1)] = (6));

} else {
var statearr_32254_32289 = state_32240__$1;
(statearr_32254_32289[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (19))){
var state_32240__$1 = state_32240;
var statearr_32255_32290 = state_32240__$1;
(statearr_32255_32290[(2)] = null);

(statearr_32255_32290[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (11))){
var inst_32213 = (state_32240[(7)]);
var inst_32213__$1 = (state_32240[(2)]);
var inst_32214 = (inst_32213__$1 == null);
var inst_32215 = (inst_32213__$1 instanceof Error);
var inst_32216 = ((inst_32214) || (inst_32215));
var state_32240__$1 = (function (){var statearr_32257 = state_32240;
(statearr_32257[(7)] = inst_32213__$1);

return statearr_32257;
})();
if(cljs.core.truth_(inst_32216)){
var statearr_32258_32291 = state_32240__$1;
(statearr_32258_32291[(1)] = (12));

} else {
var statearr_32259_32292 = state_32240__$1;
(statearr_32259_32292[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (9))){
var inst_32208 = (state_32240[(9)]);
var inst_32211 = fluree.db.storage.core.read_block(conn,network,dbid,inst_32208);
var state_32240__$1 = state_32240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32240__$1,(11),inst_32211);
} else {
if((state_val_32241 === (5))){
var _ = (function (){var statearr_32260 = state_32240;
(statearr_32260[(4)] = cljs.core.rest((state_32240[(4)])));

return statearr_32260;
})();
var state_32240__$1 = state_32240;
var ex32256 = (state_32240__$1[(2)]);
var statearr_32261_32293 = state_32240__$1;
(statearr_32261_32293[(5)] = ex32256);


if((ex32256 instanceof Error)){
var statearr_32262_32294 = state_32240__$1;
(statearr_32262_32294[(1)] = (4));

(statearr_32262_32294[(5)] = null);

} else {
throw ex32256;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (14))){
var inst_32233 = (state_32240[(2)]);
var state_32240__$1 = state_32240;
var statearr_32263_32295 = state_32240__$1;
(statearr_32263_32295[(2)] = inst_32233);

(statearr_32263_32295[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (16))){
var state_32240__$1 = state_32240;
var statearr_32264_32296 = state_32240__$1;
(statearr_32264_32296[(1)] = (18));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (10))){
var inst_32235 = (state_32240[(2)]);
var _ = (function (){var statearr_32266 = state_32240;
(statearr_32266[(4)] = cljs.core.rest((state_32240[(4)])));

return statearr_32266;
})();
var state_32240__$1 = state_32240;
var statearr_32267_32297 = state_32240__$1;
(statearr_32267_32297[(2)] = inst_32235);

(statearr_32267_32297[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (18))){
var inst_32208 = (state_32240[(9)]);
var inst_32213 = (state_32240[(7)]);
var inst_32209 = (state_32240[(8)]);
var inst_32224 = (inst_32208 + (1));
var inst_32225 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32209,inst_32213);
var inst_32208__$1 = inst_32224;
var inst_32209__$1 = inst_32225;
var state_32240__$1 = (function (){var statearr_32268 = state_32240;
(statearr_32268[(9)] = inst_32208__$1);

(statearr_32268[(8)] = inst_32209__$1);

return statearr_32268;
})();
var statearr_32269_32298 = state_32240__$1;
(statearr_32269_32298[(2)] = null);

(statearr_32269_32298[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32241 === (8))){
var inst_32204 = (state_32240[(2)]);
var inst_32205 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_32206 = start;
var inst_32207 = cljs.core.PersistentVector.EMPTY;
var inst_32208 = inst_32206;
var inst_32209 = inst_32207;
var state_32240__$1 = (function (){var statearr_32270 = state_32240;
(statearr_32270[(9)] = inst_32208);

(statearr_32270[(10)] = inst_32204);

(statearr_32270[(8)] = inst_32209);

(statearr_32270[(11)] = inst_32205);

return statearr_32270;
})();
var statearr_32271_32299 = state_32240__$1;
(statearr_32271_32299[(2)] = null);

(statearr_32271_32299[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__13883__auto__ = null;
var fluree$db$storage$core$state_machine__13883__auto____0 = (function (){
var statearr_32272 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32272[(0)] = fluree$db$storage$core$state_machine__13883__auto__);

(statearr_32272[(1)] = (1));

return statearr_32272;
});
var fluree$db$storage$core$state_machine__13883__auto____1 = (function (state_32240){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_32240);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e32273){var ex__13886__auto__ = e32273;
var statearr_32274_32300 = state_32240;
(statearr_32274_32300[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_32240[(4)]))){
var statearr_32275_32301 = state_32240;
(statearr_32275_32301[(1)] = cljs.core.first((state_32240[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__32302 = state_32240;
state_32240 = G__32302;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__13883__auto__ = function(state_32240){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__13883__auto____1.call(this,state_32240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__13883__auto____0;
fluree$db$storage$core$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__13883__auto____1;
return fluree$db$storage$core$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_32276 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_32276[(6)] = c__13957__auto__);

return statearr_32276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_32318){
var state_val_32319 = (state_32318[(1)]);
if((state_val_32319 === (1))){
var state_32318__$1 = state_32318;
var statearr_32320_32334 = state_32318__$1;
(statearr_32320_32334[(2)] = null);

(statearr_32320_32334[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32319 === (2))){
var _ = (function (){var statearr_32321 = state_32318;
(statearr_32321[(4)] = cljs.core.cons((5),(state_32318[(4)])));

return statearr_32321;
})();
var inst_32309 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_32318__$1 = state_32318;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32318__$1,(6),inst_32309);
} else {
if((state_val_32319 === (3))){
var inst_32316 = (state_32318[(2)]);
var state_32318__$1 = state_32318;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32318__$1,inst_32316);
} else {
if((state_val_32319 === (4))){
var inst_32303 = (state_32318[(2)]);
var state_32318__$1 = state_32318;
var statearr_32323_32335 = state_32318__$1;
(statearr_32323_32335[(2)] = inst_32303);

(statearr_32323_32335[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32319 === (5))){
var _ = (function (){var statearr_32324 = state_32318;
(statearr_32324[(4)] = cljs.core.rest((state_32318[(4)])));

return statearr_32324;
})();
var state_32318__$1 = state_32318;
var ex32322 = (state_32318__$1[(2)]);
var statearr_32325_32336 = state_32318__$1;
(statearr_32325_32336[(5)] = ex32322);


if((ex32322 instanceof Error)){
var statearr_32326_32337 = state_32318__$1;
(statearr_32326_32337[(1)] = (4));

(statearr_32326_32337[(5)] = null);

} else {
throw ex32322;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32319 === (6))){
var inst_32311 = (state_32318[(2)]);
var inst_32312 = fluree.db.util.async.throw_err(inst_32311);
var inst_32313 = cljs.core.first(inst_32312);
var _ = (function (){var statearr_32327 = state_32318;
(statearr_32327[(4)] = cljs.core.rest((state_32318[(4)])));

return statearr_32327;
})();
var state_32318__$1 = state_32318;
var statearr_32328_32338 = state_32318__$1;
(statearr_32328_32338[(2)] = inst_32313);

(statearr_32328_32338[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__13883__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__13883__auto____0 = (function (){
var statearr_32329 = [null,null,null,null,null,null,null];
(statearr_32329[(0)] = fluree$db$storage$core$block_$_state_machine__13883__auto__);

(statearr_32329[(1)] = (1));

return statearr_32329;
});
var fluree$db$storage$core$block_$_state_machine__13883__auto____1 = (function (state_32318){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_32318);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e32330){var ex__13886__auto__ = e32330;
var statearr_32331_32339 = state_32318;
(statearr_32331_32339[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_32318[(4)]))){
var statearr_32332_32340 = state_32318;
(statearr_32332_32340[(1)] = cljs.core.first((state_32318[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__32341 = state_32318;
state_32318 = G__32341;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__13883__auto__ = function(state_32318){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__13883__auto____1.call(this,state_32318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__13883__auto____0;
fluree$db$storage$core$block_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__13883__auto____1;
return fluree$db$storage$core$block_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_32333 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_32333[(6)] = c__13957__auto__);

return statearr_32333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
