// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5753__auto__)){
var st = temp__5753__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__24622 = cljs.core._EQ_;
var expr__24623 = e.getLastErrorCode();
if(cljs.core.truth_((pred__24622.cljs$core$IFn$_invoke$arity$2 ? pred__24622.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__24623) : pred__24622.call(null,goog.net.ErrorCode.NO_ERROR,expr__24623)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__24622.cljs$core$IFn$_invoke$arity$2 ? pred__24622.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__24623) : pred__24622.call(null,goog.net.ErrorCode.EXCEPTION,expr__24623)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__24622.cljs$core$IFn$_invoke$arity$2 ? pred__24622.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__24623) : pred__24622.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__24623)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__24622.cljs$core$IFn$_invoke$arity$2 ? pred__24622.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__24623) : pred__24622.call(null,goog.net.ErrorCode.ABORT,expr__24623)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__24622.cljs$core$IFn$_invoke$arity$2 ? pred__24622.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__24623) : pred__24622.call(null,goog.net.ErrorCode.TIMEOUT,expr__24623)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4149__auto__ = status;
if(cljs.core.truth_(and__4149__auto__)){
return (status > (0));
} else {
return and__4149__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__24625 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__24625,cljs.core.cst$kw$status,status);
} else {
return G__24625;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__24626 = opts;
var map__24626__$1 = cljs.core.__destructure_map(map__24626);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__24626__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24626__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24626__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__24627 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__24627__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__24627,headers], 0)):G__24627);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__24627__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__24627__$1;
}
})();
try{var G__24629_24635 = url;
var G__24630_24636 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__24631_24637 = "POST";
var G__24632_24638 = fluree.db.util.json.stringify(message);
var G__24633_24639 = cljs.core.clj__GT_js(headers__$1);
var G__24634_24640 = request_timeout;
goog.net.XhrIo.send(G__24629_24635,G__24630_24636,G__24631_24637,G__24632_24638,G__24633_24639,G__24634_24640);
}catch (e24628){var e_24641 = e24628;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_24641);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__24642 = opts;
var map__24642__$1 = cljs.core.__destructure_map(map__24642);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__24642__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24642__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24642__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24642__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__24642__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__24643 = cljs.core.PersistentArrayMap.EMPTY;
var G__24643__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__24643,headers], 0)):G__24643);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__24643__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__24643__$1;
}
})();
try{var G__24645_24652 = url;
var G__24646_24653 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__24651 = output_format;
var G__24651__$1 = (((G__24651 instanceof cljs.core.Keyword))?G__24651.fqn:null);
switch (G__24651__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__24647_24654 = "GET";
var G__24648_24655 = body;
var G__24649_24656 = cljs.core.clj__GT_js(headers__$1);
var G__24650_24657 = request_timeout;
goog.net.XhrIo.send(G__24645_24652,G__24646_24653,G__24647_24654,G__24648_24655,G__24649_24656,G__24650_24657);
}catch (e24644){var e_24659 = e24644;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_24659);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__24660 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__24660,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__24660;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_24693){
var state_val_24694 = (state_24693[(1)]);
if((state_val_24694 === (7))){
var inst_24689 = (state_24693[(2)]);
var state_24693__$1 = state_24693;
var statearr_24695_24720 = state_24693__$1;
(statearr_24695_24720[(2)] = inst_24689);

(statearr_24695_24720[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24694 === (1))){
var state_24693__$1 = state_24693;
var statearr_24696_24721 = state_24693__$1;
(statearr_24696_24721[(2)] = null);

(statearr_24696_24721[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24694 === (4))){
var inst_24664 = (state_24693[(7)]);
var inst_24664__$1 = (state_24693[(2)]);
var inst_24665 = (inst_24664__$1 == null);
var state_24693__$1 = (function (){var statearr_24697 = state_24693;
(statearr_24697[(7)] = inst_24664__$1);

return statearr_24697;
})();
if(cljs.core.truth_(inst_24665)){
var statearr_24698_24722 = state_24693__$1;
(statearr_24698_24722[(1)] = (5));

} else {
var statearr_24699_24723 = state_24693__$1;
(statearr_24699_24723[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24694 === (6))){
var inst_24664 = (state_24693[(7)]);
var inst_24672 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24664,(0),null);
var inst_24673 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24664,(1),null);
var state_24693__$1 = (function (){var statearr_24700 = state_24693;
(statearr_24700[(8)] = inst_24672);

(statearr_24700[(9)] = inst_24673);

return statearr_24700;
})();
var statearr_24701_24724 = state_24693__$1;
(statearr_24701_24724[(2)] = null);

(statearr_24701_24724[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24694 === (3))){
var inst_24691 = (state_24693[(2)]);
var state_24693__$1 = state_24693;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24693__$1,inst_24691);
} else {
if((state_val_24694 === (2))){
var state_24693__$1 = state_24693;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24693__$1,(4),pub_chan);
} else {
if((state_val_24694 === (11))){
var _ = (function (){var statearr_24703 = state_24693;
(statearr_24703[(4)] = cljs.core.rest((state_24693[(4)])));

return statearr_24703;
})();
var state_24693__$1 = state_24693;
var ex24702 = (state_24693__$1[(2)]);
var statearr_24704_24725 = state_24693__$1;
(statearr_24704_24725[(5)] = ex24702);


if((ex24702 instanceof Error)){
var statearr_24705_24726 = state_24693__$1;
(statearr_24705_24726[(1)] = (10));

(statearr_24705_24726[(5)] = null);

} else {
throw ex24702;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24694 === (9))){
var inst_24686 = (state_24693[(2)]);
var state_24693__$1 = (function (){var statearr_24706 = state_24693;
(statearr_24706[(10)] = inst_24686);

return statearr_24706;
})();
var statearr_24707_24727 = state_24693__$1;
(statearr_24707_24727[(2)] = null);

(statearr_24707_24727[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24694 === (5))){
var inst_24667 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_24693__$1 = state_24693;
var statearr_24708_24728 = state_24693__$1;
(statearr_24708_24728[(2)] = inst_24667);

(statearr_24708_24728[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24694 === (10))){
var inst_24673 = (state_24693[(9)]);
var inst_24674 = (state_24693[(2)]);
var inst_24675 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_24674,"Websocket send message error:",inst_24674], 0));
var inst_24676 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24673,false);
var state_24693__$1 = (function (){var statearr_24709 = state_24693;
(statearr_24709[(11)] = inst_24675);

return statearr_24709;
})();
var statearr_24710_24729 = state_24693__$1;
(statearr_24710_24729[(2)] = inst_24676);

(statearr_24710_24729[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24694 === (8))){
var inst_24672 = (state_24693[(8)]);
var inst_24673 = (state_24693[(9)]);
var _ = (function (){var statearr_24711 = state_24693;
(statearr_24711[(4)] = cljs.core.cons((11),(state_24693[(4)])));

return statearr_24711;
})();
var inst_24682 = ws.send(inst_24672);
var inst_24683 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24673,true);
var ___$1 = (function (){var statearr_24712 = state_24693;
(statearr_24712[(4)] = cljs.core.rest((state_24693[(4)])));

return statearr_24712;
})();
var state_24693__$1 = (function (){var statearr_24713 = state_24693;
(statearr_24713[(12)] = inst_24682);

return statearr_24713;
})();
var statearr_24714_24730 = state_24693__$1;
(statearr_24714_24730[(2)] = inst_24683);

(statearr_24714_24730[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto____0 = (function (){
var statearr_24715 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24715[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto__);

(statearr_24715[(1)] = (1));

return statearr_24715;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto____1 = (function (state_24693){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_24693);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e24716){var ex__13886__auto__ = e24716;
var statearr_24717_24731 = state_24693;
(statearr_24717_24731[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_24693[(4)]))){
var statearr_24718_24732 = state_24693;
(statearr_24718_24732[(1)] = cljs.core.first((state_24693[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__24733 = state_24693;
state_24693 = G__24733;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto__ = function(state_24693){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto____1.call(this,state_24693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_24719 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_24719[(6)] = c__13957__auto__);

return statearr_24719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__13957__auto___24772 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_24759){
var state_val_24760 = (state_24759[(1)]);
if((state_val_24760 === (1))){
var inst_24738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24739 = [open_QMARK_,timeout_chan];
var inst_24740 = (new cljs.core.PersistentVector(null,2,(5),inst_24738,inst_24739,null));
var state_24759__$1 = state_24759;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_24759__$1,(2),inst_24740,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_24760 === (2))){
var inst_24742 = (state_24759[(2)]);
var inst_24743 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24742,(0),null);
var inst_24744 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24742,(1),null);
var inst_24745 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24744,timeout_chan);
var state_24759__$1 = (function (){var statearr_24761 = state_24759;
(statearr_24761[(7)] = inst_24743);

return statearr_24761;
})();
if(inst_24745){
var statearr_24762_24773 = state_24759__$1;
(statearr_24762_24773[(1)] = (3));

} else {
var statearr_24763_24774 = state_24759__$1;
(statearr_24763_24774[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24760 === (3))){
var inst_24747 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_24748 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_24749 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_24750 = cljs.core.PersistentHashMap.fromArrays(inst_24748,inst_24749);
var inst_24751 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24747,inst_24750);
var inst_24752 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_24751);
var inst_24753 = fluree.db.util.xhttp.close_websocket(ws);
var state_24759__$1 = (function (){var statearr_24764 = state_24759;
(statearr_24764[(8)] = inst_24752);

return statearr_24764;
})();
var statearr_24765_24775 = state_24759__$1;
(statearr_24765_24775[(2)] = inst_24753);

(statearr_24765_24775[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24760 === (4))){
var inst_24755 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_24759__$1 = state_24759;
var statearr_24766_24776 = state_24759__$1;
(statearr_24766_24776[(2)] = inst_24755);

(statearr_24766_24776[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24760 === (5))){
var inst_24757 = (state_24759[(2)]);
var state_24759__$1 = state_24759;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24759__$1,inst_24757);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto____0 = (function (){
var statearr_24767 = [null,null,null,null,null,null,null,null,null];
(statearr_24767[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto__);

(statearr_24767[(1)] = (1));

return statearr_24767;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto____1 = (function (state_24759){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_24759);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e24768){var ex__13886__auto__ = e24768;
var statearr_24769_24777 = state_24759;
(statearr_24769_24777[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_24759[(4)]))){
var statearr_24770_24778 = state_24759;
(statearr_24770_24778[(1)] = cljs.core.first((state_24759[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__24779 = state_24759;
state_24759 = G__24779;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto__ = function(state_24759){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto____1.call(this,state_24759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_24771 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_24771[(6)] = c__13957__auto___24772);

return statearr_24771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
