// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__77467 = (line + (1));
var G__77468 = (1);
var G__77469 = (counter + (1));
line = G__77467;
col = G__77468;
counter = G__77469;
continue;
} else {
var G__77470 = line;
var G__77471 = (col + (1));
var G__77472 = (counter + (1));
line = G__77470;
col = G__77471;
counter = G__77472;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__77473 = cljs.core.next(chars);
var G__77474 = (n__$1 - (1));
chars = G__77473;
n__$1 = G__77474;
continue;
} else {
var G__77475 = cljs.core.next(chars);
var G__77476 = n__$1;
chars = G__77475;
n__$1 = G__77476;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__77477){
var map__77478 = p__77477;
var map__77478__$1 = cljs.core.__destructure_map(map__77478);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77478__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77478__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77478__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77478__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__77479_77487 = cljs.core.seq(full_reasons);
var chunk__77480_77488 = null;
var count__77481_77489 = (0);
var i__77482_77490 = (0);
while(true){
if((i__77482_77490 < count__77481_77489)){
var r_77491 = chunk__77480_77488.cljs$core$IIndexed$_nth$arity$2(null,i__77482_77490);
instaparse.failure.print_reason(r_77491);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__77492 = seq__77479_77487;
var G__77493 = chunk__77480_77488;
var G__77494 = count__77481_77489;
var G__77495 = (i__77482_77490 + (1));
seq__77479_77487 = G__77492;
chunk__77480_77488 = G__77493;
count__77481_77489 = G__77494;
i__77482_77490 = G__77495;
continue;
} else {
var temp__5753__auto___77496 = cljs.core.seq(seq__77479_77487);
if(temp__5753__auto___77496){
var seq__77479_77497__$1 = temp__5753__auto___77496;
if(cljs.core.chunked_seq_QMARK_(seq__77479_77497__$1)){
var c__4591__auto___77498 = cljs.core.chunk_first(seq__77479_77497__$1);
var G__77499 = cljs.core.chunk_rest(seq__77479_77497__$1);
var G__77500 = c__4591__auto___77498;
var G__77501 = cljs.core.count(c__4591__auto___77498);
var G__77502 = (0);
seq__77479_77487 = G__77499;
chunk__77480_77488 = G__77500;
count__77481_77489 = G__77501;
i__77482_77490 = G__77502;
continue;
} else {
var r_77503 = cljs.core.first(seq__77479_77497__$1);
instaparse.failure.print_reason(r_77503);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__77504 = cljs.core.next(seq__77479_77497__$1);
var G__77505 = null;
var G__77506 = (0);
var G__77507 = (0);
seq__77479_77487 = G__77504;
chunk__77480_77488 = G__77505;
count__77481_77489 = G__77506;
i__77482_77490 = G__77507;
continue;
}
} else {
}
}
break;
}

var seq__77483 = cljs.core.seq(partial_reasons);
var chunk__77484 = null;
var count__77485 = (0);
var i__77486 = (0);
while(true){
if((i__77486 < count__77485)){
var r = chunk__77484.cljs$core$IIndexed$_nth$arity$2(null,i__77486);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__77508 = seq__77483;
var G__77509 = chunk__77484;
var G__77510 = count__77485;
var G__77511 = (i__77486 + (1));
seq__77483 = G__77508;
chunk__77484 = G__77509;
count__77485 = G__77510;
i__77486 = G__77511;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__77483);
if(temp__5753__auto__){
var seq__77483__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__77483__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__77483__$1);
var G__77512 = cljs.core.chunk_rest(seq__77483__$1);
var G__77513 = c__4591__auto__;
var G__77514 = cljs.core.count(c__4591__auto__);
var G__77515 = (0);
seq__77483 = G__77512;
chunk__77484 = G__77513;
count__77485 = G__77514;
i__77486 = G__77515;
continue;
} else {
var r = cljs.core.first(seq__77483__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__77516 = cljs.core.next(seq__77483__$1);
var G__77517 = null;
var G__77518 = (0);
var G__77519 = (0);
seq__77483 = G__77516;
chunk__77484 = G__77517;
count__77485 = G__77518;
i__77486 = G__77519;
continue;
}
} else {
return null;
}
}
break;
}
});
