// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4564__auto__ = (function tailrecursion$priority_map$iter__40402(s__40403){
return (new cljs.core.LazySeq(null,(function (){
var s__40403__$1 = s__40403;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__40403__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__40408 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40408,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40408,(1),null);
var iterys__4560__auto__ = ((function (s__40403__$1,vec__40408,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__40402_$_iter__40404(s__40405){
return (new cljs.core.LazySeq(null,((function (s__40403__$1,vec__40408,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__40405__$1 = s__40405;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__40405__$1);
if(temp__5753__auto____$1){
var s__40405__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40405__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__40405__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__40407 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__40406 = (0);
while(true){
if((i__40406 < size__4563__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__40406);
cljs.core.chunk_append(b__40407,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__40460 = (i__40406 + (1));
i__40406 = G__40460;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40407),tailrecursion$priority_map$iter__40402_$_iter__40404(cljs.core.chunk_rest(s__40405__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40407),null);
}
} else {
var item = cljs.core.first(s__40405__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__40402_$_iter__40404(cljs.core.rest(s__40405__$2)));
}
} else {
return null;
}
break;
}
});})(s__40403__$1,vec__40408,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__40403__$1,vec__40408,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4561__auto__ = cljs.core.seq(iterys__4560__auto__(item_set));
if(fs__4561__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4561__auto__,tailrecursion$priority_map$iter__40402(cljs.core.rest(s__40403__$1)));
} else {
var G__40461 = cljs.core.rest(s__40403__$1);
s__40403__$1 = G__40461;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4564__auto__ = (function tailrecursion$priority_map$iter__40411(s__40412){
return (new cljs.core.LazySeq(null,(function (){
var s__40412__$1 = s__40412;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__40412__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__40417 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40417,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40417,(1),null);
var iterys__4560__auto__ = ((function (s__40412__$1,vec__40417,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__40411_$_iter__40413(s__40414){
return (new cljs.core.LazySeq(null,((function (s__40412__$1,vec__40417,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__40414__$1 = s__40414;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__40414__$1);
if(temp__5753__auto____$1){
var s__40414__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40414__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__40414__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__40416 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__40415 = (0);
while(true){
if((i__40415 < size__4563__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__40415);
cljs.core.chunk_append(b__40416,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__40462 = (i__40415 + (1));
i__40415 = G__40462;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40416),tailrecursion$priority_map$iter__40411_$_iter__40413(cljs.core.chunk_rest(s__40414__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40416),null);
}
} else {
var item = cljs.core.first(s__40414__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__40411_$_iter__40413(cljs.core.rest(s__40414__$2)));
}
} else {
return null;
}
break;
}
});})(s__40412__$1,vec__40417,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__40412__$1,vec__40417,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4561__auto__ = cljs.core.seq(iterys__4560__auto__(item_set));
if(fs__4561__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4561__auto__,tailrecursion$priority_map$iter__40411(cljs.core.rest(s__40412__$1)));
} else {
var G__40463 = cljs.core.rest(s__40412__$1);
s__40412__$1 = G__40463;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__40420 = item;
var G__40421 = cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found;
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__40420,G__40421) : self__.item__GT_priority.call(null,G__40420,G__40421));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4564__auto__ = (function tailrecursion$priority_map$iter__40422(s__40423){
return (new cljs.core.LazySeq(null,(function (){
var s__40423__$1 = s__40423;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__40423__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__40428 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40428,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40428,(1),null);
var iterys__4560__auto__ = ((function (s__40423__$1,vec__40428,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__40422_$_iter__40424(s__40425){
return (new cljs.core.LazySeq(null,((function (s__40423__$1,vec__40428,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__40425__$1 = s__40425;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__40425__$1);
if(temp__5753__auto____$1){
var s__40425__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40425__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__40425__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__40427 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__40426 = (0);
while(true){
if((i__40426 < size__4563__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__40426);
cljs.core.chunk_append(b__40427,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__40464 = (i__40426 + (1));
i__40426 = G__40464;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40427),tailrecursion$priority_map$iter__40422_$_iter__40424(cljs.core.chunk_rest(s__40425__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40427),null);
}
} else {
var item = cljs.core.first(s__40425__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__40422_$_iter__40424(cljs.core.rest(s__40425__$2)));
}
} else {
return null;
}
break;
}
});})(s__40423__$1,vec__40428,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__40423__$1,vec__40428,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4561__auto__ = cljs.core.seq(iterys__4560__auto__(item_set));
if(fs__4561__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4561__auto__,tailrecursion$priority_map$iter__40422(cljs.core.rest(s__40423__$1)));
} else {
var G__40465 = cljs.core.rest(s__40423__$1);
s__40423__$1 = G__40465;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4564__auto__ = (function tailrecursion$priority_map$iter__40431(s__40432){
return (new cljs.core.LazySeq(null,(function (){
var s__40432__$1 = s__40432;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__40432__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__40437 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40437,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40437,(1),null);
var iterys__4560__auto__ = ((function (s__40432__$1,vec__40437,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__40431_$_iter__40433(s__40434){
return (new cljs.core.LazySeq(null,((function (s__40432__$1,vec__40437,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__40434__$1 = s__40434;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__40434__$1);
if(temp__5753__auto____$1){
var s__40434__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40434__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__40434__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__40436 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__40435 = (0);
while(true){
if((i__40435 < size__4563__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__40435);
cljs.core.chunk_append(b__40436,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__40466 = (i__40435 + (1));
i__40435 = G__40466;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40436),tailrecursion$priority_map$iter__40431_$_iter__40433(cljs.core.chunk_rest(s__40434__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40436),null);
}
} else {
var item = cljs.core.first(s__40434__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__40431_$_iter__40433(cljs.core.rest(s__40434__$2)));
}
} else {
return null;
}
break;
}
});})(s__40432__$1,vec__40437,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__40432__$1,vec__40437,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4561__auto__ = cljs.core.seq(iterys__4560__auto__(item_set));
if(fs__4561__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4561__auto__,tailrecursion$priority_map$iter__40431(cljs.core.rest(s__40432__$1)));
} else {
var G__40467 = cljs.core.rest(s__40432__$1);
s__40432__$1 = G__40467;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__40468 = null;
var G__40468__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__40468__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__40468 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__40468__2.call(this,self__,item);
case 3:
return G__40468__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__40468.cljs$core$IFn$_invoke$arity$2 = G__40468__2;
G__40468.cljs$core$IFn$_invoke$arity$3 = G__40468__3;
return G__40468;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args40401){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args40401)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__40440 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__40440.cljs$core$IFn$_invoke$arity$1 ? fexpr__40440.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__40440.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4564__auto__ = (function tailrecursion$priority_map$iter__40441(s__40442){
return (new cljs.core.LazySeq(null,(function (){
var s__40442__$1 = s__40442;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__40442__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__40447 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40447,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40447,(1),null);
var iterys__4560__auto__ = ((function (s__40442__$1,vec__40447,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__40441_$_iter__40443(s__40444){
return (new cljs.core.LazySeq(null,((function (s__40442__$1,vec__40447,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__40444__$1 = s__40444;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__40444__$1);
if(temp__5753__auto____$1){
var s__40444__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40444__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__40444__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__40446 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__40445 = (0);
while(true){
if((i__40445 < size__4563__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__40445);
cljs.core.chunk_append(b__40446,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__40469 = (i__40445 + (1));
i__40445 = G__40469;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40446),tailrecursion$priority_map$iter__40441_$_iter__40443(cljs.core.chunk_rest(s__40444__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40446),null);
}
} else {
var item = cljs.core.first(s__40444__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__40441_$_iter__40443(cljs.core.rest(s__40444__$2)));
}
} else {
return null;
}
break;
}
});})(s__40442__$1,vec__40447,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__40442__$1,vec__40447,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4561__auto__ = cljs.core.seq(iterys__4560__auto__(item_set));
if(fs__4561__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4561__auto__,tailrecursion$priority_map$iter__40441(cljs.core.rest(s__40442__$1)));
} else {
var G__40470 = cljs.core.rest(s__40442__$1);
s__40442__$1 = G__40470;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4564__auto__ = (function tailrecursion$priority_map$iter__40450(s__40451){
return (new cljs.core.LazySeq(null,(function (){
var s__40451__$1 = s__40451;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__40451__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__40456 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40456,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40456,(1),null);
var iterys__4560__auto__ = ((function (s__40451__$1,vec__40456,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__40450_$_iter__40452(s__40453){
return (new cljs.core.LazySeq(null,((function (s__40451__$1,vec__40456,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__40453__$1 = s__40453;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__40453__$1);
if(temp__5753__auto____$1){
var s__40453__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40453__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__40453__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__40455 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__40454 = (0);
while(true){
if((i__40454 < size__4563__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__40454);
cljs.core.chunk_append(b__40455,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__40471 = (i__40454 + (1));
i__40454 = G__40471;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40455),tailrecursion$priority_map$iter__40450_$_iter__40452(cljs.core.chunk_rest(s__40453__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40455),null);
}
} else {
var item = cljs.core.first(s__40453__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__40450_$_iter__40452(cljs.core.rest(s__40453__$2)));
}
} else {
return null;
}
break;
}
});})(s__40451__$1,vec__40456,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__40451__$1,vec__40456,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4561__auto__ = cljs.core.seq(iterys__4560__auto__(item_set));
if(fs__4561__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4561__auto__,tailrecursion$priority_map$iter__40450(cljs.core.rest(s__40451__$1)));
} else {
var G__40472 = cljs.core.rest(s__40451__$1);
s__40451__$1 = G__40472;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__40459 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__40459) : self__.keyfn.call(null,G__40459));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$priority_DASH__GT_set_DASH_of_DASH_items,cljs.core.cst$sym$item_DASH__GT_priority,cljs.core.cst$sym$meta,cljs.core.cst$sym$keyfn,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__40474 = arguments.length;
switch (G__40474) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4777__auto__ = [];
var len__4771__auto___40477 = arguments.length;
var i__4772__auto___40478 = (0);
while(true){
if((i__4772__auto___40478 < len__4771__auto___40477)){
args__4777__auto__.push((arguments[i__4772__auto___40478]));

var G__40479 = (i__4772__auto___40478 + (1));
i__4772__auto___40478 = G__40479;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__40480 = cljs.core.nnext(in$);
var G__40481 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__40480;
out = G__40481;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq40476){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40476));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4777__auto__ = [];
var len__4771__auto___40484 = arguments.length;
var i__4772__auto___40485 = (0);
while(true){
if((i__4772__auto___40485 < len__4771__auto___40484)){
args__4777__auto__.push((arguments[i__4772__auto___40485]));

var G__40486 = (i__4772__auto___40485 + (1));
i__4772__auto___40485 = G__40486;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__40487 = cljs.core.nnext(in$);
var G__40488 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__40487;
out = G__40488;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq40482){
var G__40483 = cljs.core.first(seq40482);
var seq40482__$1 = cljs.core.next(seq40482);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40483,seq40482__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4777__auto__ = [];
var len__4771__auto___40491 = arguments.length;
var i__4772__auto___40492 = (0);
while(true){
if((i__4772__auto___40492 < len__4771__auto___40491)){
args__4777__auto__.push((arguments[i__4772__auto___40492]));

var G__40493 = (i__4772__auto___40492 + (1));
i__4772__auto___40492 = G__40493;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__40494 = cljs.core.nnext(in$);
var G__40495 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__40494;
out = G__40495;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq40489){
var G__40490 = cljs.core.first(seq40489);
var seq40489__$1 = cljs.core.next(seq40489);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40490,seq40489__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4777__auto__ = [];
var len__4771__auto___40499 = arguments.length;
var i__4772__auto___40500 = (0);
while(true){
if((i__4772__auto___40500 < len__4771__auto___40499)){
args__4777__auto__.push((arguments[i__4772__auto___40500]));

var G__40501 = (i__4772__auto___40500 + (1));
i__4772__auto___40500 = G__40501;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((2) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4778__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__40502 = cljs.core.nnext(in$);
var G__40503 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__40502;
out = G__40503;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq40496){
var G__40497 = cljs.core.first(seq40496);
var seq40496__$1 = cljs.core.next(seq40496);
var G__40498 = cljs.core.first(seq40496__$1);
var seq40496__$2 = cljs.core.next(seq40496__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40497,G__40498,seq40496__$2);
}));

