// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('alphabase.bytes');
goog.require('cljs.core');
goog.require('cljs.core.constants');
/**
 * Coerces a number to a byte value.
 */
alphabase.bytes.to_byte = (function alphabase$bytes$to_byte(x){
return x;
});
/**
 * Coerces a byte value to a number.
 */
alphabase.bytes.from_byte = (function alphabase$bytes$from_byte(x){
return x;
});
/**
 * Reads a byte value out of an array and coerces it to a number.
 */
alphabase.bytes.get_byte = (function alphabase$bytes$get_byte(array,i){
return alphabase.bytes.from_byte((array[i]));
});
/**
 * Sets a byte value in an array after coercing it from a number.
 */
alphabase.bytes.set_byte = (function alphabase$bytes$set_byte(array,i,x){
return (array[i] = alphabase.bytes.to_byte(x));
});
/**
 * Return a sequence of the bytes in an array, after coercion.
 */
alphabase.bytes.byte_seq = (function alphabase$bytes$byte_seq(array){
if(cljs.core.truth_(array)){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40950_SHARP_){
return (array[p1__40950_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(array.length));
} else {
return null;
}
});
/**
 * True if the argument is a byte array compatible with this library.
 */
alphabase.bytes.bytes_QMARK_ = (function alphabase$bytes$bytes_QMARK_(x){
return (((x instanceof Uint8Array)) || ((((x instanceof Array)) && (((cljs.core.empty_QMARK_(x)) || (cljs.core.integer_QMARK_(cljs.core.first(x))))))));
});
/**
 * Returns true if two byte sequences are the same length and have the same
 *   byte content.
 */
alphabase.bytes.bytes_EQ_ = (function alphabase$bytes$bytes_EQ_(a,b){
var and__4221__auto__ = alphabase.bytes.bytes_QMARK_(a);
if(and__4221__auto__){
var and__4221__auto____$1 = alphabase.bytes.bytes_QMARK_(b);
if(and__4221__auto____$1){
var a__$1 = a;
var b__$1 = b;
var and__4221__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a__$1.length,b__$1.length);
if(and__4221__auto____$2){
var i = (0);
while(true){
if((i < a__$1.length)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(alphabase.bytes.get_byte(a__$1,i),alphabase.bytes.get_byte(b__$1,i))){
var G__40951 = (i + (1));
i = G__40951;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return and__4221__auto____$2;
}
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
});
/**
 * Creates a new array to hold byte data.
 */
alphabase.bytes.byte_array = (function alphabase$bytes$byte_array(length){
return (new Uint8Array((new ArrayBuffer(length))));
});
/**
 * Copies bytes from one array to another.
 * 
 *   - If only a source is given, returns a full copy of the byte array.
 *   - If a source and a destination with offset are given, copies all of the
 *  bytes from the source into the destination at that offset. Returns the
 *  number of bytes copied.
 *   - If all arguments are given, copies `length` bytes from the source at the
 *  given offset to the destination at its offset. Returns the number of bytes
 *  copied.
 */
alphabase.bytes.copy = (function alphabase$bytes$copy(var_args){
var G__40953 = arguments.length;
switch (G__40953) {
case 1:
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$1 = (function (src){
var dst = alphabase.bytes.byte_array(src.length);
alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$3(src,dst,(0));

return dst;
}));

(alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$3 = (function (src,dst,dst_offset){
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5(src,(0),dst,dst_offset,src.length);
}));

(alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5 = (function (src,src_offset,dst,dst_offset,length){
var n__4706__auto___40955 = length;
var i_40956 = (0);
while(true){
if((i_40956 < n__4706__auto___40955)){
alphabase.bytes.set_byte(dst,(i_40956 + dst_offset),alphabase.bytes.get_byte(src,(i_40956 + src_offset)));

var G__40957 = (i_40956 + (1));
i_40956 = G__40957;
continue;
} else {
}
break;
}

return length;
}));

(alphabase.bytes.copy.cljs$lang$maxFixedArity = 5);

/**
 * Initialize a new array with the given sequence of byte values.
 */
alphabase.bytes.init_bytes = (function alphabase$bytes$init_bytes(values){
var length = cljs.core.count(values);
var data = alphabase.bytes.byte_array(length);
var n__4706__auto___40958 = length;
var i_40959 = (0);
while(true){
if((i_40959 < n__4706__auto___40958)){
alphabase.bytes.set_byte(data,i_40959,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(values,i_40959));

var G__40960 = (i_40959 + (1));
i_40959 = G__40960;
continue;
} else {
}
break;
}

return data;
});
/**
 * Returns a byte array `length` bytes long with random content.
 */
alphabase.bytes.random_bytes = (function alphabase$bytes$random_bytes(length){
var data = alphabase.bytes.byte_array(length);
var n__4706__auto___40961 = length;
var i_40962 = (0);
while(true){
if((i_40962 < n__4706__auto___40961)){
alphabase.bytes.set_byte(data,i_40962,cljs.core.rand_int((256)));

var G__40963 = (i_40962 + (1));
i_40962 = G__40963;
continue;
} else {
}
break;
}

return data;
});
/**
 * Lexicographically compares two byte-arrays for order. Returns a negative
 *   number, zero, or a positive number if `a` is less than, equal to, or greater
 *   than `b`, respectively.
 * 
 *   This ranking compares each byte in the keys in order; the first byte which
 *   differs determines the ordering; if the byte in `a` is less than the byte in
 *   `b`, `a` ranks before `b`, and vice versa.
 * 
 *   If the keys differ in length, and all the bytes in the shorter key match the
 *   longer key, the shorter key ranks first.
 */
alphabase.bytes.compare = (function alphabase$bytes$compare(a,b){
var prefix_len = (function (){var x__4309__auto__ = a.length;
var y__4310__auto__ = b.length;
return ((x__4309__auto__ < y__4310__auto__) ? x__4309__auto__ : y__4310__auto__);
})();
var i = (0);
while(true){
if((i < prefix_len)){
var ai = alphabase.bytes.get_byte(a,i);
var bi = alphabase.bytes.get_byte(b,i);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ai,bi)){
var G__40964 = (i + (1));
i = G__40964;
continue;
} else {
return (ai - bi);
}
} else {
return (a.length - b.length);
}
break;
}
});
/**
 * Copy a slice (defined by offset, length) from a byte array.
 * 
 *   Omitting the slice `len` argument will copy remainder of
 *   `src` array from offset (e.g, `(- (alength src) offset)` bytes).
 */
alphabase.bytes.copy_slice = (function alphabase$bytes$copy_slice(var_args){
var G__40966 = arguments.length;
switch (G__40966) {
case 3:
return alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$3 = (function (src,offset,len){
var dst = alphabase.bytes.byte_array(len);
alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5(src,offset,dst,(0),len);

return dst;
}));

(alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$2 = (function (src,offset){
return alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$3(src,offset,(src.length - offset));
}));

(alphabase.bytes.copy_slice.cljs$lang$maxFixedArity = 3);

/**
 * Concatenate bytes arrays into a single new byte array.
 */
alphabase.bytes.concat = (function alphabase$bytes$concat(var_args){
var args__4835__auto__ = [];
var len__4829__auto___40970 = arguments.length;
var i__4830__auto___40971 = (0);
while(true){
if((i__4830__auto___40971 < len__4829__auto___40970)){
args__4835__auto__.push((arguments[i__4830__auto___40971]));

var G__40972 = (i__4830__auto___40971 + (1));
i__4830__auto___40971 = G__40972;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return alphabase.bytes.concat.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(alphabase.bytes.concat.cljs$core$IFn$_invoke$arity$variadic = (function (arrs){
var arrs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,arrs);
var total_len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40968_SHARP_){
return p1__40968_SHARP_.length;
}),arrs__$1));
var dst = alphabase.bytes.byte_array(total_len);
var arrs_40973__$2 = arrs__$1;
var offset_40974 = (0);
while(true){
var temp__5753__auto___40975 = cljs.core.first(arrs_40973__$2);
if(cljs.core.truth_(temp__5753__auto___40975)){
var src_40976 = temp__5753__auto___40975;
alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5(src_40976,(0),dst,offset_40974,src_40976.length);

var G__40977 = cljs.core.rest(arrs_40973__$2);
var G__40978 = (offset_40974 + src_40976.length);
arrs_40973__$2 = G__40977;
offset_40974 = G__40978;
continue;
} else {
}
break;
}

return dst;
}));

(alphabase.bytes.concat.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(alphabase.bytes.concat.cljs$lang$applyTo = (function (seq40969){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40969));
}));

