// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__11721){
var vec__11722 = p__11721;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11722,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11722,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__11725 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11725,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11725,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11725,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11725,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11725,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$gcol,gcol,cljs.core.cst$kw$source,(goog.object.get(source_map,"sources")[source]),cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$name,(function (){var temp__5753__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__11728 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11728,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11728,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11728,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11728,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11728,(4),null);
var vec__11731 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11731,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11731,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11731,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11731,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11731,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4223__auto__ = source;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4223__auto__ = line;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4223__auto__ = col;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__11734 = segmap;
var map__11734__$1 = cljs.core.__destructure_map(map__11734);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11734__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11734__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11734__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11734__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11734__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gline,gline,cljs.core.cst$kw$gcol,gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__11736 = arguments.length;
switch (G__11736) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__11740 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__11744 = cljs.core.next(segs__$1);
var G__11745 = nrelseg;
var G__11746 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__11744;
relseg__$1 = G__11745;
result__$1 = G__11746;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11740,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11740,(1),null);
var G__11747 = (gline + (1));
var G__11748 = cljs.core.next(lines__$1);
var G__11749 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__11750 = result__$1;
gline = G__11747;
lines__$1 = G__11748;
relseg = G__11749;
result = G__11750;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__11752 = segmap;
var map__11752__$1 = cljs.core.__destructure_map(map__11752);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11752__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11752__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11752__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11752__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11752__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$source,source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__11751_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__11751_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__11754 = arguments.length;
switch (G__11754) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__11758 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__11762 = cljs.core.next(segs__$1);
var G__11763 = nrelseg;
var G__11764 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__11762;
relseg__$1 = G__11763;
result__$1 = G__11764;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11758,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11758,(1),null);
var G__11765 = (gline + (1));
var G__11766 = cljs.core.next(lines__$1);
var G__11767 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__11768 = result__$1;
gline = G__11765;
lines__$1 = G__11766;
relseg = G__11767;
result = G__11768;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__11769){
var vec__11770 = p__11769;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11770,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11770,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11770,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11770,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11770,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__11773){
var vec__11774 = p__11773;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11774,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11774,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11774,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11774,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11774,(4),null);
var seg = vec__11774;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__11777){
var vec__11778 = p__11777;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11778,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11778,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11778,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11778,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11778,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = cljs.core.cst$kw$preamble_DASH_line_DASH_count.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$gcol.cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__11784 = cljs.core.seq(infos);
var chunk__11785 = null;
var count__11786 = (0);
var i__11787 = (0);
while(true){
if((i__11787 < count__11786)){
var info = chunk__11785.cljs$core$IIndexed$_nth$arity$2(null,i__11787);
var segv_12138 = info__GT_segv(info,source_idx,line,col);
var gline_12139 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_12140 = cljs.core.count(cljs.core.deref(lines));
if((gline_12139 > (lc_12140 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__11784,chunk__11785,count__11786,i__11787,segv_12138,gline_12139,lc_12140,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_12139 - (lc_12140 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_12138], null));
});})(seq__11784,chunk__11785,count__11786,i__11787,segv_12138,gline_12139,lc_12140,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__11784,chunk__11785,count__11786,i__11787,segv_12138,gline_12139,lc_12140,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12139], null),cljs.core.conj,segv_12138);
});})(seq__11784,chunk__11785,count__11786,i__11787,segv_12138,gline_12139,lc_12140,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__12141 = seq__11784;
var G__12142 = chunk__11785;
var G__12143 = count__11786;
var G__12144 = (i__11787 + (1));
seq__11784 = G__12141;
chunk__11785 = G__12142;
count__11786 = G__12143;
i__11787 = G__12144;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__11784);
if(temp__5753__auto__){
var seq__11784__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11784__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__11784__$1);
var G__12145 = cljs.core.chunk_rest(seq__11784__$1);
var G__12146 = c__4649__auto__;
var G__12147 = cljs.core.count(c__4649__auto__);
var G__12148 = (0);
seq__11784 = G__12145;
chunk__11785 = G__12146;
count__11786 = G__12147;
i__11787 = G__12148;
continue;
} else {
var info = cljs.core.first(seq__11784__$1);
var segv_12149 = info__GT_segv(info,source_idx,line,col);
var gline_12150 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_12151 = cljs.core.count(cljs.core.deref(lines));
if((gline_12150 > (lc_12151 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__11784,chunk__11785,count__11786,i__11787,segv_12149,gline_12150,lc_12151,info,seq__11784__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_12150 - (lc_12151 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_12149], null));
});})(seq__11784,chunk__11785,count__11786,i__11787,segv_12149,gline_12150,lc_12151,info,seq__11784__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__11784,chunk__11785,count__11786,i__11787,segv_12149,gline_12150,lc_12151,info,seq__11784__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12150], null),cljs.core.conj,segv_12149);
});})(seq__11784,chunk__11785,count__11786,i__11787,segv_12149,gline_12150,lc_12151,info,seq__11784__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__12152 = cljs.core.next(seq__11784__$1);
var G__12153 = null;
var G__12154 = (0);
var G__12155 = (0);
seq__11784 = G__12152;
chunk__11785 = G__12153;
count__11786 = G__12154;
i__11787 = G__12155;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__11788_12156 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__11789_12157 = null;
var count__11790_12158 = (0);
var i__11791_12159 = (0);
while(true){
if((i__11791_12159 < count__11790_12158)){
var vec__11964_12160 = chunk__11789_12157.cljs$core$IIndexed$_nth$arity$2(null,i__11791_12159);
var source_idx_12161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11964_12160,(0),null);
var vec__11967_12162 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11964_12160,(1),null);
var __12163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11967_12162,(0),null);
var lines_12164__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11967_12162,(1),null);
var seq__11970_12165 = cljs.core.seq(lines_12164__$1);
var chunk__11971_12166 = null;
var count__11972_12167 = (0);
var i__11973_12168 = (0);
while(true){
if((i__11973_12168 < count__11972_12167)){
var vec__12012_12169 = chunk__11971_12166.cljs$core$IIndexed$_nth$arity$2(null,i__11973_12168);
var line_12170 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12012_12169,(0),null);
var cols_12171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12012_12169,(1),null);
var seq__12015_12172 = cljs.core.seq(cols_12171);
var chunk__12016_12173 = null;
var count__12017_12174 = (0);
var i__12018_12175 = (0);
while(true){
if((i__12018_12175 < count__12017_12174)){
var vec__12025_12176 = chunk__12016_12173.cljs$core$IIndexed$_nth$arity$2(null,i__12018_12175);
var col_12177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12025_12176,(0),null);
var infos_12178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12025_12176,(1),null);
encode_cols(infos_12178,source_idx_12161,line_12170,col_12177);


var G__12179 = seq__12015_12172;
var G__12180 = chunk__12016_12173;
var G__12181 = count__12017_12174;
var G__12182 = (i__12018_12175 + (1));
seq__12015_12172 = G__12179;
chunk__12016_12173 = G__12180;
count__12017_12174 = G__12181;
i__12018_12175 = G__12182;
continue;
} else {
var temp__5753__auto___12183 = cljs.core.seq(seq__12015_12172);
if(temp__5753__auto___12183){
var seq__12015_12184__$1 = temp__5753__auto___12183;
if(cljs.core.chunked_seq_QMARK_(seq__12015_12184__$1)){
var c__4649__auto___12185 = cljs.core.chunk_first(seq__12015_12184__$1);
var G__12186 = cljs.core.chunk_rest(seq__12015_12184__$1);
var G__12187 = c__4649__auto___12185;
var G__12188 = cljs.core.count(c__4649__auto___12185);
var G__12189 = (0);
seq__12015_12172 = G__12186;
chunk__12016_12173 = G__12187;
count__12017_12174 = G__12188;
i__12018_12175 = G__12189;
continue;
} else {
var vec__12028_12190 = cljs.core.first(seq__12015_12184__$1);
var col_12191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12028_12190,(0),null);
var infos_12192 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12028_12190,(1),null);
encode_cols(infos_12192,source_idx_12161,line_12170,col_12191);


var G__12193 = cljs.core.next(seq__12015_12184__$1);
var G__12194 = null;
var G__12195 = (0);
var G__12196 = (0);
seq__12015_12172 = G__12193;
chunk__12016_12173 = G__12194;
count__12017_12174 = G__12195;
i__12018_12175 = G__12196;
continue;
}
} else {
}
}
break;
}


var G__12197 = seq__11970_12165;
var G__12198 = chunk__11971_12166;
var G__12199 = count__11972_12167;
var G__12200 = (i__11973_12168 + (1));
seq__11970_12165 = G__12197;
chunk__11971_12166 = G__12198;
count__11972_12167 = G__12199;
i__11973_12168 = G__12200;
continue;
} else {
var temp__5753__auto___12201 = cljs.core.seq(seq__11970_12165);
if(temp__5753__auto___12201){
var seq__11970_12202__$1 = temp__5753__auto___12201;
if(cljs.core.chunked_seq_QMARK_(seq__11970_12202__$1)){
var c__4649__auto___12203 = cljs.core.chunk_first(seq__11970_12202__$1);
var G__12204 = cljs.core.chunk_rest(seq__11970_12202__$1);
var G__12205 = c__4649__auto___12203;
var G__12206 = cljs.core.count(c__4649__auto___12203);
var G__12207 = (0);
seq__11970_12165 = G__12204;
chunk__11971_12166 = G__12205;
count__11972_12167 = G__12206;
i__11973_12168 = G__12207;
continue;
} else {
var vec__12031_12208 = cljs.core.first(seq__11970_12202__$1);
var line_12209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12031_12208,(0),null);
var cols_12210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12031_12208,(1),null);
var seq__12034_12211 = cljs.core.seq(cols_12210);
var chunk__12035_12212 = null;
var count__12036_12213 = (0);
var i__12037_12214 = (0);
while(true){
if((i__12037_12214 < count__12036_12213)){
var vec__12044_12215 = chunk__12035_12212.cljs$core$IIndexed$_nth$arity$2(null,i__12037_12214);
var col_12216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12044_12215,(0),null);
var infos_12217 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12044_12215,(1),null);
encode_cols(infos_12217,source_idx_12161,line_12209,col_12216);


var G__12218 = seq__12034_12211;
var G__12219 = chunk__12035_12212;
var G__12220 = count__12036_12213;
var G__12221 = (i__12037_12214 + (1));
seq__12034_12211 = G__12218;
chunk__12035_12212 = G__12219;
count__12036_12213 = G__12220;
i__12037_12214 = G__12221;
continue;
} else {
var temp__5753__auto___12222__$1 = cljs.core.seq(seq__12034_12211);
if(temp__5753__auto___12222__$1){
var seq__12034_12223__$1 = temp__5753__auto___12222__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12034_12223__$1)){
var c__4649__auto___12224 = cljs.core.chunk_first(seq__12034_12223__$1);
var G__12225 = cljs.core.chunk_rest(seq__12034_12223__$1);
var G__12226 = c__4649__auto___12224;
var G__12227 = cljs.core.count(c__4649__auto___12224);
var G__12228 = (0);
seq__12034_12211 = G__12225;
chunk__12035_12212 = G__12226;
count__12036_12213 = G__12227;
i__12037_12214 = G__12228;
continue;
} else {
var vec__12047_12229 = cljs.core.first(seq__12034_12223__$1);
var col_12230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12047_12229,(0),null);
var infos_12231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12047_12229,(1),null);
encode_cols(infos_12231,source_idx_12161,line_12209,col_12230);


var G__12232 = cljs.core.next(seq__12034_12223__$1);
var G__12233 = null;
var G__12234 = (0);
var G__12235 = (0);
seq__12034_12211 = G__12232;
chunk__12035_12212 = G__12233;
count__12036_12213 = G__12234;
i__12037_12214 = G__12235;
continue;
}
} else {
}
}
break;
}


var G__12236 = cljs.core.next(seq__11970_12202__$1);
var G__12237 = null;
var G__12238 = (0);
var G__12239 = (0);
seq__11970_12165 = G__12236;
chunk__11971_12166 = G__12237;
count__11972_12167 = G__12238;
i__11973_12168 = G__12239;
continue;
}
} else {
}
}
break;
}


var G__12240 = seq__11788_12156;
var G__12241 = chunk__11789_12157;
var G__12242 = count__11790_12158;
var G__12243 = (i__11791_12159 + (1));
seq__11788_12156 = G__12240;
chunk__11789_12157 = G__12241;
count__11790_12158 = G__12242;
i__11791_12159 = G__12243;
continue;
} else {
var temp__5753__auto___12244 = cljs.core.seq(seq__11788_12156);
if(temp__5753__auto___12244){
var seq__11788_12245__$1 = temp__5753__auto___12244;
if(cljs.core.chunked_seq_QMARK_(seq__11788_12245__$1)){
var c__4649__auto___12246 = cljs.core.chunk_first(seq__11788_12245__$1);
var G__12247 = cljs.core.chunk_rest(seq__11788_12245__$1);
var G__12248 = c__4649__auto___12246;
var G__12249 = cljs.core.count(c__4649__auto___12246);
var G__12250 = (0);
seq__11788_12156 = G__12247;
chunk__11789_12157 = G__12248;
count__11790_12158 = G__12249;
i__11791_12159 = G__12250;
continue;
} else {
var vec__12050_12251 = cljs.core.first(seq__11788_12245__$1);
var source_idx_12252 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12050_12251,(0),null);
var vec__12053_12253 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12050_12251,(1),null);
var __12254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12053_12253,(0),null);
var lines_12255__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12053_12253,(1),null);
var seq__12056_12256 = cljs.core.seq(lines_12255__$1);
var chunk__12057_12257 = null;
var count__12058_12258 = (0);
var i__12059_12259 = (0);
while(true){
if((i__12059_12259 < count__12058_12258)){
var vec__12098_12260 = chunk__12057_12257.cljs$core$IIndexed$_nth$arity$2(null,i__12059_12259);
var line_12261 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12098_12260,(0),null);
var cols_12262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12098_12260,(1),null);
var seq__12101_12263 = cljs.core.seq(cols_12262);
var chunk__12102_12264 = null;
var count__12103_12265 = (0);
var i__12104_12266 = (0);
while(true){
if((i__12104_12266 < count__12103_12265)){
var vec__12111_12267 = chunk__12102_12264.cljs$core$IIndexed$_nth$arity$2(null,i__12104_12266);
var col_12268 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12111_12267,(0),null);
var infos_12269 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12111_12267,(1),null);
encode_cols(infos_12269,source_idx_12252,line_12261,col_12268);


var G__12270 = seq__12101_12263;
var G__12271 = chunk__12102_12264;
var G__12272 = count__12103_12265;
var G__12273 = (i__12104_12266 + (1));
seq__12101_12263 = G__12270;
chunk__12102_12264 = G__12271;
count__12103_12265 = G__12272;
i__12104_12266 = G__12273;
continue;
} else {
var temp__5753__auto___12274__$1 = cljs.core.seq(seq__12101_12263);
if(temp__5753__auto___12274__$1){
var seq__12101_12275__$1 = temp__5753__auto___12274__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12101_12275__$1)){
var c__4649__auto___12276 = cljs.core.chunk_first(seq__12101_12275__$1);
var G__12277 = cljs.core.chunk_rest(seq__12101_12275__$1);
var G__12278 = c__4649__auto___12276;
var G__12279 = cljs.core.count(c__4649__auto___12276);
var G__12280 = (0);
seq__12101_12263 = G__12277;
chunk__12102_12264 = G__12278;
count__12103_12265 = G__12279;
i__12104_12266 = G__12280;
continue;
} else {
var vec__12114_12281 = cljs.core.first(seq__12101_12275__$1);
var col_12282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12114_12281,(0),null);
var infos_12283 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12114_12281,(1),null);
encode_cols(infos_12283,source_idx_12252,line_12261,col_12282);


var G__12284 = cljs.core.next(seq__12101_12275__$1);
var G__12285 = null;
var G__12286 = (0);
var G__12287 = (0);
seq__12101_12263 = G__12284;
chunk__12102_12264 = G__12285;
count__12103_12265 = G__12286;
i__12104_12266 = G__12287;
continue;
}
} else {
}
}
break;
}


var G__12288 = seq__12056_12256;
var G__12289 = chunk__12057_12257;
var G__12290 = count__12058_12258;
var G__12291 = (i__12059_12259 + (1));
seq__12056_12256 = G__12288;
chunk__12057_12257 = G__12289;
count__12058_12258 = G__12290;
i__12059_12259 = G__12291;
continue;
} else {
var temp__5753__auto___12292__$1 = cljs.core.seq(seq__12056_12256);
if(temp__5753__auto___12292__$1){
var seq__12056_12293__$1 = temp__5753__auto___12292__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12056_12293__$1)){
var c__4649__auto___12294 = cljs.core.chunk_first(seq__12056_12293__$1);
var G__12295 = cljs.core.chunk_rest(seq__12056_12293__$1);
var G__12296 = c__4649__auto___12294;
var G__12297 = cljs.core.count(c__4649__auto___12294);
var G__12298 = (0);
seq__12056_12256 = G__12295;
chunk__12057_12257 = G__12296;
count__12058_12258 = G__12297;
i__12059_12259 = G__12298;
continue;
} else {
var vec__12117_12299 = cljs.core.first(seq__12056_12293__$1);
var line_12300 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12117_12299,(0),null);
var cols_12301 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12117_12299,(1),null);
var seq__12120_12302 = cljs.core.seq(cols_12301);
var chunk__12121_12303 = null;
var count__12122_12304 = (0);
var i__12123_12305 = (0);
while(true){
if((i__12123_12305 < count__12122_12304)){
var vec__12130_12306 = chunk__12121_12303.cljs$core$IIndexed$_nth$arity$2(null,i__12123_12305);
var col_12307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12130_12306,(0),null);
var infos_12308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12130_12306,(1),null);
encode_cols(infos_12308,source_idx_12252,line_12300,col_12307);


var G__12309 = seq__12120_12302;
var G__12310 = chunk__12121_12303;
var G__12311 = count__12122_12304;
var G__12312 = (i__12123_12305 + (1));
seq__12120_12302 = G__12309;
chunk__12121_12303 = G__12310;
count__12122_12304 = G__12311;
i__12123_12305 = G__12312;
continue;
} else {
var temp__5753__auto___12313__$2 = cljs.core.seq(seq__12120_12302);
if(temp__5753__auto___12313__$2){
var seq__12120_12314__$1 = temp__5753__auto___12313__$2;
if(cljs.core.chunked_seq_QMARK_(seq__12120_12314__$1)){
var c__4649__auto___12315 = cljs.core.chunk_first(seq__12120_12314__$1);
var G__12316 = cljs.core.chunk_rest(seq__12120_12314__$1);
var G__12317 = c__4649__auto___12315;
var G__12318 = cljs.core.count(c__4649__auto___12315);
var G__12319 = (0);
seq__12120_12302 = G__12316;
chunk__12121_12303 = G__12317;
count__12122_12304 = G__12318;
i__12123_12305 = G__12319;
continue;
} else {
var vec__12133_12320 = cljs.core.first(seq__12120_12314__$1);
var col_12321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12133_12320,(0),null);
var infos_12322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12133_12320,(1),null);
encode_cols(infos_12322,source_idx_12252,line_12300,col_12321);


var G__12323 = cljs.core.next(seq__12120_12314__$1);
var G__12324 = null;
var G__12325 = (0);
var G__12326 = (0);
seq__12120_12302 = G__12323;
chunk__12121_12303 = G__12324;
count__12122_12304 = G__12325;
i__12123_12305 = G__12326;
continue;
}
} else {
}
}
break;
}


var G__12327 = cljs.core.next(seq__12056_12293__$1);
var G__12328 = null;
var G__12329 = (0);
var G__12330 = (0);
seq__12056_12256 = G__12327;
chunk__12057_12257 = G__12328;
count__12058_12258 = G__12329;
i__12059_12259 = G__12330;
continue;
}
} else {
}
}
break;
}


var G__12331 = cljs.core.next(seq__11788_12245__$1);
var G__12332 = null;
var G__12333 = (0);
var G__12334 = (0);
seq__11788_12156 = G__12331;
chunk__11789_12157 = G__12332;
count__11790_12158 = G__12333;
i__11791_12159 = G__12334;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__12136 = ({"version": (3), "file": cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$source_DASH_map_DASH_timestamp.cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__11781_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__11781_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__11782_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__11782_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": cljs.core.cst$kw$lines.cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11783_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__11783_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts))){
var G__12137 = G__12136;
goog.object.set(G__12137,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts)));

return G__12137;
} else {
return G__12136;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__12335 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12335,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12335,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__12338 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12338,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12338,(1),null);
var G__12343 = cljs.core.next(col_map_seq);
var G__12344 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__12338,col,infos,vec__12335,line,col_map){
return (function (v,p__12341){
var map__12342 = p__12341;
var map__12342__$1 = cljs.core.__destructure_map(map__12342);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12342__$1,cljs.core.cst$kw$gline);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12342__$1,cljs.core.cst$kw$gcol);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__12338,col,infos,vec__12335,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__12343;
new_cols = G__12344;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__12345 = cljs.core.next(line_map_seq);
var G__12346 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__12345;
new_lines = G__12346;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__12347_12555 = cljs.core.seq(reverse_map);
var chunk__12348_12556 = null;
var count__12349_12557 = (0);
var i__12350_12558 = (0);
while(true){
if((i__12350_12558 < count__12349_12557)){
var vec__12453_12559 = chunk__12348_12556.cljs$core$IIndexed$_nth$arity$2(null,i__12350_12558);
var line_12560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12453_12559,(0),null);
var columns_12561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12453_12559,(1),null);
var seq__12456_12562 = cljs.core.seq(columns_12561);
var chunk__12457_12563 = null;
var count__12458_12564 = (0);
var i__12459_12565 = (0);
while(true){
if((i__12459_12565 < count__12458_12564)){
var vec__12482_12566 = chunk__12457_12563.cljs$core$IIndexed$_nth$arity$2(null,i__12459_12565);
var column_12567 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12482_12566,(0),null);
var column_info_12568 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12482_12566,(1),null);
var seq__12485_12569 = cljs.core.seq(column_info_12568);
var chunk__12486_12570 = null;
var count__12487_12571 = (0);
var i__12488_12572 = (0);
while(true){
if((i__12488_12572 < count__12487_12571)){
var map__12491_12573 = chunk__12486_12570.cljs$core$IIndexed$_nth$arity$2(null,i__12488_12572);
var map__12491_12574__$1 = cljs.core.__destructure_map(map__12491_12573);
var gline_12575 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12491_12574__$1,cljs.core.cst$kw$gline);
var gcol_12576 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12491_12574__$1,cljs.core.cst$kw$gcol);
var name_12577 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12491_12574__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12575], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12485_12569,chunk__12486_12570,count__12487_12571,i__12488_12572,seq__12456_12562,chunk__12457_12563,count__12458_12564,i__12459_12565,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12491_12573,map__12491_12574__$1,gline_12575,gcol_12576,name_12577,vec__12482_12566,column_12567,column_info_12568,vec__12453_12559,line_12560,columns_12561,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12576], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_12560,cljs.core.cst$kw$col,column_12567,cljs.core.cst$kw$name,name_12577], null));
});})(seq__12485_12569,chunk__12486_12570,count__12487_12571,i__12488_12572,seq__12456_12562,chunk__12457_12563,count__12458_12564,i__12459_12565,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12491_12573,map__12491_12574__$1,gline_12575,gcol_12576,name_12577,vec__12482_12566,column_12567,column_info_12568,vec__12453_12559,line_12560,columns_12561,inverted))
,cljs.core.sorted_map()));


var G__12578 = seq__12485_12569;
var G__12579 = chunk__12486_12570;
var G__12580 = count__12487_12571;
var G__12581 = (i__12488_12572 + (1));
seq__12485_12569 = G__12578;
chunk__12486_12570 = G__12579;
count__12487_12571 = G__12580;
i__12488_12572 = G__12581;
continue;
} else {
var temp__5753__auto___12582 = cljs.core.seq(seq__12485_12569);
if(temp__5753__auto___12582){
var seq__12485_12583__$1 = temp__5753__auto___12582;
if(cljs.core.chunked_seq_QMARK_(seq__12485_12583__$1)){
var c__4649__auto___12584 = cljs.core.chunk_first(seq__12485_12583__$1);
var G__12585 = cljs.core.chunk_rest(seq__12485_12583__$1);
var G__12586 = c__4649__auto___12584;
var G__12587 = cljs.core.count(c__4649__auto___12584);
var G__12588 = (0);
seq__12485_12569 = G__12585;
chunk__12486_12570 = G__12586;
count__12487_12571 = G__12587;
i__12488_12572 = G__12588;
continue;
} else {
var map__12492_12589 = cljs.core.first(seq__12485_12583__$1);
var map__12492_12590__$1 = cljs.core.__destructure_map(map__12492_12589);
var gline_12591 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12492_12590__$1,cljs.core.cst$kw$gline);
var gcol_12592 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12492_12590__$1,cljs.core.cst$kw$gcol);
var name_12593 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12492_12590__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12591], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12485_12569,chunk__12486_12570,count__12487_12571,i__12488_12572,seq__12456_12562,chunk__12457_12563,count__12458_12564,i__12459_12565,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12492_12589,map__12492_12590__$1,gline_12591,gcol_12592,name_12593,seq__12485_12583__$1,temp__5753__auto___12582,vec__12482_12566,column_12567,column_info_12568,vec__12453_12559,line_12560,columns_12561,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12592], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_12560,cljs.core.cst$kw$col,column_12567,cljs.core.cst$kw$name,name_12593], null));
});})(seq__12485_12569,chunk__12486_12570,count__12487_12571,i__12488_12572,seq__12456_12562,chunk__12457_12563,count__12458_12564,i__12459_12565,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12492_12589,map__12492_12590__$1,gline_12591,gcol_12592,name_12593,seq__12485_12583__$1,temp__5753__auto___12582,vec__12482_12566,column_12567,column_info_12568,vec__12453_12559,line_12560,columns_12561,inverted))
,cljs.core.sorted_map()));


var G__12594 = cljs.core.next(seq__12485_12583__$1);
var G__12595 = null;
var G__12596 = (0);
var G__12597 = (0);
seq__12485_12569 = G__12594;
chunk__12486_12570 = G__12595;
count__12487_12571 = G__12596;
i__12488_12572 = G__12597;
continue;
}
} else {
}
}
break;
}


var G__12598 = seq__12456_12562;
var G__12599 = chunk__12457_12563;
var G__12600 = count__12458_12564;
var G__12601 = (i__12459_12565 + (1));
seq__12456_12562 = G__12598;
chunk__12457_12563 = G__12599;
count__12458_12564 = G__12600;
i__12459_12565 = G__12601;
continue;
} else {
var temp__5753__auto___12602 = cljs.core.seq(seq__12456_12562);
if(temp__5753__auto___12602){
var seq__12456_12603__$1 = temp__5753__auto___12602;
if(cljs.core.chunked_seq_QMARK_(seq__12456_12603__$1)){
var c__4649__auto___12604 = cljs.core.chunk_first(seq__12456_12603__$1);
var G__12605 = cljs.core.chunk_rest(seq__12456_12603__$1);
var G__12606 = c__4649__auto___12604;
var G__12607 = cljs.core.count(c__4649__auto___12604);
var G__12608 = (0);
seq__12456_12562 = G__12605;
chunk__12457_12563 = G__12606;
count__12458_12564 = G__12607;
i__12459_12565 = G__12608;
continue;
} else {
var vec__12493_12609 = cljs.core.first(seq__12456_12603__$1);
var column_12610 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12493_12609,(0),null);
var column_info_12611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12493_12609,(1),null);
var seq__12496_12612 = cljs.core.seq(column_info_12611);
var chunk__12497_12613 = null;
var count__12498_12614 = (0);
var i__12499_12615 = (0);
while(true){
if((i__12499_12615 < count__12498_12614)){
var map__12502_12616 = chunk__12497_12613.cljs$core$IIndexed$_nth$arity$2(null,i__12499_12615);
var map__12502_12617__$1 = cljs.core.__destructure_map(map__12502_12616);
var gline_12618 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12502_12617__$1,cljs.core.cst$kw$gline);
var gcol_12619 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12502_12617__$1,cljs.core.cst$kw$gcol);
var name_12620 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12502_12617__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12618], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12496_12612,chunk__12497_12613,count__12498_12614,i__12499_12615,seq__12456_12562,chunk__12457_12563,count__12458_12564,i__12459_12565,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12502_12616,map__12502_12617__$1,gline_12618,gcol_12619,name_12620,vec__12493_12609,column_12610,column_info_12611,seq__12456_12603__$1,temp__5753__auto___12602,vec__12453_12559,line_12560,columns_12561,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12619], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_12560,cljs.core.cst$kw$col,column_12610,cljs.core.cst$kw$name,name_12620], null));
});})(seq__12496_12612,chunk__12497_12613,count__12498_12614,i__12499_12615,seq__12456_12562,chunk__12457_12563,count__12458_12564,i__12459_12565,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12502_12616,map__12502_12617__$1,gline_12618,gcol_12619,name_12620,vec__12493_12609,column_12610,column_info_12611,seq__12456_12603__$1,temp__5753__auto___12602,vec__12453_12559,line_12560,columns_12561,inverted))
,cljs.core.sorted_map()));


var G__12621 = seq__12496_12612;
var G__12622 = chunk__12497_12613;
var G__12623 = count__12498_12614;
var G__12624 = (i__12499_12615 + (1));
seq__12496_12612 = G__12621;
chunk__12497_12613 = G__12622;
count__12498_12614 = G__12623;
i__12499_12615 = G__12624;
continue;
} else {
var temp__5753__auto___12625__$1 = cljs.core.seq(seq__12496_12612);
if(temp__5753__auto___12625__$1){
var seq__12496_12626__$1 = temp__5753__auto___12625__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12496_12626__$1)){
var c__4649__auto___12627 = cljs.core.chunk_first(seq__12496_12626__$1);
var G__12628 = cljs.core.chunk_rest(seq__12496_12626__$1);
var G__12629 = c__4649__auto___12627;
var G__12630 = cljs.core.count(c__4649__auto___12627);
var G__12631 = (0);
seq__12496_12612 = G__12628;
chunk__12497_12613 = G__12629;
count__12498_12614 = G__12630;
i__12499_12615 = G__12631;
continue;
} else {
var map__12503_12632 = cljs.core.first(seq__12496_12626__$1);
var map__12503_12633__$1 = cljs.core.__destructure_map(map__12503_12632);
var gline_12634 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12503_12633__$1,cljs.core.cst$kw$gline);
var gcol_12635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12503_12633__$1,cljs.core.cst$kw$gcol);
var name_12636 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12503_12633__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12634], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12496_12612,chunk__12497_12613,count__12498_12614,i__12499_12615,seq__12456_12562,chunk__12457_12563,count__12458_12564,i__12459_12565,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12503_12632,map__12503_12633__$1,gline_12634,gcol_12635,name_12636,seq__12496_12626__$1,temp__5753__auto___12625__$1,vec__12493_12609,column_12610,column_info_12611,seq__12456_12603__$1,temp__5753__auto___12602,vec__12453_12559,line_12560,columns_12561,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12635], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_12560,cljs.core.cst$kw$col,column_12610,cljs.core.cst$kw$name,name_12636], null));
});})(seq__12496_12612,chunk__12497_12613,count__12498_12614,i__12499_12615,seq__12456_12562,chunk__12457_12563,count__12458_12564,i__12459_12565,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12503_12632,map__12503_12633__$1,gline_12634,gcol_12635,name_12636,seq__12496_12626__$1,temp__5753__auto___12625__$1,vec__12493_12609,column_12610,column_info_12611,seq__12456_12603__$1,temp__5753__auto___12602,vec__12453_12559,line_12560,columns_12561,inverted))
,cljs.core.sorted_map()));


var G__12637 = cljs.core.next(seq__12496_12626__$1);
var G__12638 = null;
var G__12639 = (0);
var G__12640 = (0);
seq__12496_12612 = G__12637;
chunk__12497_12613 = G__12638;
count__12498_12614 = G__12639;
i__12499_12615 = G__12640;
continue;
}
} else {
}
}
break;
}


var G__12641 = cljs.core.next(seq__12456_12603__$1);
var G__12642 = null;
var G__12643 = (0);
var G__12644 = (0);
seq__12456_12562 = G__12641;
chunk__12457_12563 = G__12642;
count__12458_12564 = G__12643;
i__12459_12565 = G__12644;
continue;
}
} else {
}
}
break;
}


var G__12645 = seq__12347_12555;
var G__12646 = chunk__12348_12556;
var G__12647 = count__12349_12557;
var G__12648 = (i__12350_12558 + (1));
seq__12347_12555 = G__12645;
chunk__12348_12556 = G__12646;
count__12349_12557 = G__12647;
i__12350_12558 = G__12648;
continue;
} else {
var temp__5753__auto___12649 = cljs.core.seq(seq__12347_12555);
if(temp__5753__auto___12649){
var seq__12347_12650__$1 = temp__5753__auto___12649;
if(cljs.core.chunked_seq_QMARK_(seq__12347_12650__$1)){
var c__4649__auto___12651 = cljs.core.chunk_first(seq__12347_12650__$1);
var G__12652 = cljs.core.chunk_rest(seq__12347_12650__$1);
var G__12653 = c__4649__auto___12651;
var G__12654 = cljs.core.count(c__4649__auto___12651);
var G__12655 = (0);
seq__12347_12555 = G__12652;
chunk__12348_12556 = G__12653;
count__12349_12557 = G__12654;
i__12350_12558 = G__12655;
continue;
} else {
var vec__12504_12656 = cljs.core.first(seq__12347_12650__$1);
var line_12657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12504_12656,(0),null);
var columns_12658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12504_12656,(1),null);
var seq__12507_12659 = cljs.core.seq(columns_12658);
var chunk__12508_12660 = null;
var count__12509_12661 = (0);
var i__12510_12662 = (0);
while(true){
if((i__12510_12662 < count__12509_12661)){
var vec__12533_12663 = chunk__12508_12660.cljs$core$IIndexed$_nth$arity$2(null,i__12510_12662);
var column_12664 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12533_12663,(0),null);
var column_info_12665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12533_12663,(1),null);
var seq__12536_12666 = cljs.core.seq(column_info_12665);
var chunk__12537_12667 = null;
var count__12538_12668 = (0);
var i__12539_12669 = (0);
while(true){
if((i__12539_12669 < count__12538_12668)){
var map__12542_12670 = chunk__12537_12667.cljs$core$IIndexed$_nth$arity$2(null,i__12539_12669);
var map__12542_12671__$1 = cljs.core.__destructure_map(map__12542_12670);
var gline_12672 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12542_12671__$1,cljs.core.cst$kw$gline);
var gcol_12673 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12542_12671__$1,cljs.core.cst$kw$gcol);
var name_12674 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12542_12671__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12672], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12536_12666,chunk__12537_12667,count__12538_12668,i__12539_12669,seq__12507_12659,chunk__12508_12660,count__12509_12661,i__12510_12662,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12542_12670,map__12542_12671__$1,gline_12672,gcol_12673,name_12674,vec__12533_12663,column_12664,column_info_12665,vec__12504_12656,line_12657,columns_12658,seq__12347_12650__$1,temp__5753__auto___12649,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12673], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_12657,cljs.core.cst$kw$col,column_12664,cljs.core.cst$kw$name,name_12674], null));
});})(seq__12536_12666,chunk__12537_12667,count__12538_12668,i__12539_12669,seq__12507_12659,chunk__12508_12660,count__12509_12661,i__12510_12662,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12542_12670,map__12542_12671__$1,gline_12672,gcol_12673,name_12674,vec__12533_12663,column_12664,column_info_12665,vec__12504_12656,line_12657,columns_12658,seq__12347_12650__$1,temp__5753__auto___12649,inverted))
,cljs.core.sorted_map()));


var G__12675 = seq__12536_12666;
var G__12676 = chunk__12537_12667;
var G__12677 = count__12538_12668;
var G__12678 = (i__12539_12669 + (1));
seq__12536_12666 = G__12675;
chunk__12537_12667 = G__12676;
count__12538_12668 = G__12677;
i__12539_12669 = G__12678;
continue;
} else {
var temp__5753__auto___12679__$1 = cljs.core.seq(seq__12536_12666);
if(temp__5753__auto___12679__$1){
var seq__12536_12680__$1 = temp__5753__auto___12679__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12536_12680__$1)){
var c__4649__auto___12681 = cljs.core.chunk_first(seq__12536_12680__$1);
var G__12682 = cljs.core.chunk_rest(seq__12536_12680__$1);
var G__12683 = c__4649__auto___12681;
var G__12684 = cljs.core.count(c__4649__auto___12681);
var G__12685 = (0);
seq__12536_12666 = G__12682;
chunk__12537_12667 = G__12683;
count__12538_12668 = G__12684;
i__12539_12669 = G__12685;
continue;
} else {
var map__12543_12686 = cljs.core.first(seq__12536_12680__$1);
var map__12543_12687__$1 = cljs.core.__destructure_map(map__12543_12686);
var gline_12688 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12543_12687__$1,cljs.core.cst$kw$gline);
var gcol_12689 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12543_12687__$1,cljs.core.cst$kw$gcol);
var name_12690 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12543_12687__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12688], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12536_12666,chunk__12537_12667,count__12538_12668,i__12539_12669,seq__12507_12659,chunk__12508_12660,count__12509_12661,i__12510_12662,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12543_12686,map__12543_12687__$1,gline_12688,gcol_12689,name_12690,seq__12536_12680__$1,temp__5753__auto___12679__$1,vec__12533_12663,column_12664,column_info_12665,vec__12504_12656,line_12657,columns_12658,seq__12347_12650__$1,temp__5753__auto___12649,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12689], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_12657,cljs.core.cst$kw$col,column_12664,cljs.core.cst$kw$name,name_12690], null));
});})(seq__12536_12666,chunk__12537_12667,count__12538_12668,i__12539_12669,seq__12507_12659,chunk__12508_12660,count__12509_12661,i__12510_12662,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12543_12686,map__12543_12687__$1,gline_12688,gcol_12689,name_12690,seq__12536_12680__$1,temp__5753__auto___12679__$1,vec__12533_12663,column_12664,column_info_12665,vec__12504_12656,line_12657,columns_12658,seq__12347_12650__$1,temp__5753__auto___12649,inverted))
,cljs.core.sorted_map()));


var G__12691 = cljs.core.next(seq__12536_12680__$1);
var G__12692 = null;
var G__12693 = (0);
var G__12694 = (0);
seq__12536_12666 = G__12691;
chunk__12537_12667 = G__12692;
count__12538_12668 = G__12693;
i__12539_12669 = G__12694;
continue;
}
} else {
}
}
break;
}


var G__12695 = seq__12507_12659;
var G__12696 = chunk__12508_12660;
var G__12697 = count__12509_12661;
var G__12698 = (i__12510_12662 + (1));
seq__12507_12659 = G__12695;
chunk__12508_12660 = G__12696;
count__12509_12661 = G__12697;
i__12510_12662 = G__12698;
continue;
} else {
var temp__5753__auto___12699__$1 = cljs.core.seq(seq__12507_12659);
if(temp__5753__auto___12699__$1){
var seq__12507_12700__$1 = temp__5753__auto___12699__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12507_12700__$1)){
var c__4649__auto___12701 = cljs.core.chunk_first(seq__12507_12700__$1);
var G__12702 = cljs.core.chunk_rest(seq__12507_12700__$1);
var G__12703 = c__4649__auto___12701;
var G__12704 = cljs.core.count(c__4649__auto___12701);
var G__12705 = (0);
seq__12507_12659 = G__12702;
chunk__12508_12660 = G__12703;
count__12509_12661 = G__12704;
i__12510_12662 = G__12705;
continue;
} else {
var vec__12544_12706 = cljs.core.first(seq__12507_12700__$1);
var column_12707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12544_12706,(0),null);
var column_info_12708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12544_12706,(1),null);
var seq__12547_12709 = cljs.core.seq(column_info_12708);
var chunk__12548_12710 = null;
var count__12549_12711 = (0);
var i__12550_12712 = (0);
while(true){
if((i__12550_12712 < count__12549_12711)){
var map__12553_12713 = chunk__12548_12710.cljs$core$IIndexed$_nth$arity$2(null,i__12550_12712);
var map__12553_12714__$1 = cljs.core.__destructure_map(map__12553_12713);
var gline_12715 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12553_12714__$1,cljs.core.cst$kw$gline);
var gcol_12716 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12553_12714__$1,cljs.core.cst$kw$gcol);
var name_12717 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12553_12714__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12715], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12547_12709,chunk__12548_12710,count__12549_12711,i__12550_12712,seq__12507_12659,chunk__12508_12660,count__12509_12661,i__12510_12662,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12553_12713,map__12553_12714__$1,gline_12715,gcol_12716,name_12717,vec__12544_12706,column_12707,column_info_12708,seq__12507_12700__$1,temp__5753__auto___12699__$1,vec__12504_12656,line_12657,columns_12658,seq__12347_12650__$1,temp__5753__auto___12649,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12716], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_12657,cljs.core.cst$kw$col,column_12707,cljs.core.cst$kw$name,name_12717], null));
});})(seq__12547_12709,chunk__12548_12710,count__12549_12711,i__12550_12712,seq__12507_12659,chunk__12508_12660,count__12509_12661,i__12510_12662,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12553_12713,map__12553_12714__$1,gline_12715,gcol_12716,name_12717,vec__12544_12706,column_12707,column_info_12708,seq__12507_12700__$1,temp__5753__auto___12699__$1,vec__12504_12656,line_12657,columns_12658,seq__12347_12650__$1,temp__5753__auto___12649,inverted))
,cljs.core.sorted_map()));


var G__12718 = seq__12547_12709;
var G__12719 = chunk__12548_12710;
var G__12720 = count__12549_12711;
var G__12721 = (i__12550_12712 + (1));
seq__12547_12709 = G__12718;
chunk__12548_12710 = G__12719;
count__12549_12711 = G__12720;
i__12550_12712 = G__12721;
continue;
} else {
var temp__5753__auto___12722__$2 = cljs.core.seq(seq__12547_12709);
if(temp__5753__auto___12722__$2){
var seq__12547_12723__$1 = temp__5753__auto___12722__$2;
if(cljs.core.chunked_seq_QMARK_(seq__12547_12723__$1)){
var c__4649__auto___12724 = cljs.core.chunk_first(seq__12547_12723__$1);
var G__12725 = cljs.core.chunk_rest(seq__12547_12723__$1);
var G__12726 = c__4649__auto___12724;
var G__12727 = cljs.core.count(c__4649__auto___12724);
var G__12728 = (0);
seq__12547_12709 = G__12725;
chunk__12548_12710 = G__12726;
count__12549_12711 = G__12727;
i__12550_12712 = G__12728;
continue;
} else {
var map__12554_12729 = cljs.core.first(seq__12547_12723__$1);
var map__12554_12730__$1 = cljs.core.__destructure_map(map__12554_12729);
var gline_12731 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12554_12730__$1,cljs.core.cst$kw$gline);
var gcol_12732 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12554_12730__$1,cljs.core.cst$kw$gcol);
var name_12733 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12554_12730__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12731], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12547_12709,chunk__12548_12710,count__12549_12711,i__12550_12712,seq__12507_12659,chunk__12508_12660,count__12509_12661,i__12510_12662,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12554_12729,map__12554_12730__$1,gline_12731,gcol_12732,name_12733,seq__12547_12723__$1,temp__5753__auto___12722__$2,vec__12544_12706,column_12707,column_info_12708,seq__12507_12700__$1,temp__5753__auto___12699__$1,vec__12504_12656,line_12657,columns_12658,seq__12347_12650__$1,temp__5753__auto___12649,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12732], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_12657,cljs.core.cst$kw$col,column_12707,cljs.core.cst$kw$name,name_12733], null));
});})(seq__12547_12709,chunk__12548_12710,count__12549_12711,i__12550_12712,seq__12507_12659,chunk__12508_12660,count__12509_12661,i__12510_12662,seq__12347_12555,chunk__12348_12556,count__12349_12557,i__12350_12558,map__12554_12729,map__12554_12730__$1,gline_12731,gcol_12732,name_12733,seq__12547_12723__$1,temp__5753__auto___12722__$2,vec__12544_12706,column_12707,column_info_12708,seq__12507_12700__$1,temp__5753__auto___12699__$1,vec__12504_12656,line_12657,columns_12658,seq__12347_12650__$1,temp__5753__auto___12649,inverted))
,cljs.core.sorted_map()));


var G__12734 = cljs.core.next(seq__12547_12723__$1);
var G__12735 = null;
var G__12736 = (0);
var G__12737 = (0);
seq__12547_12709 = G__12734;
chunk__12548_12710 = G__12735;
count__12549_12711 = G__12736;
i__12550_12712 = G__12737;
continue;
}
} else {
}
}
break;
}


var G__12738 = cljs.core.next(seq__12507_12700__$1);
var G__12739 = null;
var G__12740 = (0);
var G__12741 = (0);
seq__12507_12659 = G__12738;
chunk__12508_12660 = G__12739;
count__12509_12661 = G__12740;
i__12510_12662 = G__12741;
continue;
}
} else {
}
}
break;
}


var G__12742 = cljs.core.next(seq__12347_12650__$1);
var G__12743 = null;
var G__12744 = (0);
var G__12745 = (0);
seq__12347_12555 = G__12742;
chunk__12348_12556 = G__12743;
count__12349_12557 = G__12744;
i__12350_12558 = G__12745;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
