// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(500)], 0)));
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(500)], 0)));
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__4221__auto__ = typeof value === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__4221__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$cas,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$subs,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,300,null,300,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,714,null,714,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,230,null,230,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,157,null,157,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_cas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$cas,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,812,null,812,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$compare_DASH_val,cljs.core.cst$sym$new_DASH_val], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,521,null,521,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,427,null,427,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,145,null,145,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,388,null,388,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,256,null,256,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,86,null,86,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,726,null,726,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,533,null,533,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,607,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,620,null,620,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,750,null,750,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,98,null,98,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,169,null,169,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,778,null,778,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,696,null,696,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,414,null,414,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,466,null,466,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,788,null,788,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,73,null,73,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,188,null,188,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,568,null,568,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,659,null,659,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,453,null,453,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,109,null,109,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,594,null,594,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,1,506,null,506,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,332,332,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,558,null,558,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,545,null,545,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,800,null,800,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not_EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not_EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,440,null,440,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,270,null,270,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,121,null,121,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,401,null,401,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,581,null,581,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,762,null,762,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,1,347,347,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,361,361,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,684,null,684,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,214,null,214,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,58,null,58,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_subs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$subs,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,133,null,133,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,633,null,633,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,201,null,201,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,646,null,646,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,479,null,479,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,1,288,null,288,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,738,null,738,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,243,null,243,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,671,null,671,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__85481 = cljs.core.meta(f);
var map__85481__$1 = cljs.core.__destructure_map(map__85481);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85481__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85481__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4221__auto__ = (function (){var G__85483 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__85482 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__85482.cljs$core$IFn$_invoke$arity$1 ? fexpr__85482.cljs$core$IFn$_invoke$arity$1(G__85483) : fexpr__85482.call(null,G__85483));
})();
if(cljs.core.truth_(and__4221__auto__)){
var G__85485 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__85484 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__85484.cljs$core$IFn$_invoke$arity$1 ? fexpr__85484.cljs$core$IFn$_invoke$arity$1(G__85485) : fexpr__85484.call(null,G__85485));
} else {
return and__4221__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__85480_SHARP_){
return (cljs.core.count(p1__85480_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_fn,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_85579){
var state_val_85580 = (state_85579[(1)]);
if((state_val_85580 === (7))){
var state_85579__$1 = state_85579;
var statearr_85581_85623 = state_85579__$1;
(statearr_85581_85623[(2)] = null);

(statearr_85581_85623[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (20))){
var inst_85561 = (state_85579[(7)]);
var inst_85564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85565 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_85566 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_85567 = [inst_85565,inst_85566,fn_name];
var inst_85568 = (new cljs.core.PersistentVector(null,3,(5),inst_85564,inst_85567,null));
var inst_85569 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_85568,inst_85561);
var state_85579__$1 = state_85579;
var statearr_85582_85624 = state_85579__$1;
(statearr_85582_85624[(2)] = inst_85569);

(statearr_85582_85624[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (1))){
var state_85579__$1 = state_85579;
var statearr_85583_85625 = state_85579__$1;
(statearr_85583_85625[(2)] = null);

(statearr_85583_85625[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (4))){
var inst_85486 = (state_85579[(2)]);
var state_85579__$1 = state_85579;
var statearr_85584_85626 = state_85579__$1;
(statearr_85584_85626[(2)] = inst_85486);

(statearr_85584_85626[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (15))){
var inst_85525 = (state_85579[(8)]);
var inst_85524 = (state_85579[(2)]);
var inst_85525__$1 = fluree.db.util.async.throw_err(inst_85524);
var inst_85526 = cljs.core.empty_QMARK_(inst_85525__$1);
var state_85579__$1 = (function (){var statearr_85585 = state_85579;
(statearr_85585[(8)] = inst_85525__$1);

return statearr_85585;
})();
if(inst_85526){
var statearr_85586_85627 = state_85579__$1;
(statearr_85586_85627[(1)] = (16));

} else {
var statearr_85587_85628 = state_85579__$1;
(statearr_85587_85628[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (21))){
var state_85579__$1 = state_85579;
var statearr_85588_85629 = state_85579__$1;
(statearr_85588_85629[(2)] = null);

(statearr_85588_85629[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (13))){
var inst_85521 = (state_85579[(9)]);
var inst_85512 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_85513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85514 = ["_fn/params","_fn/code","_fn/spec"];
var inst_85515 = (new cljs.core.PersistentVector(null,3,(5),inst_85513,inst_85514,null));
var inst_85516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85517 = cljs.core.name(fn_name);
var inst_85518 = ["_fn/name",inst_85517];
var inst_85519 = (new cljs.core.PersistentVector(null,2,(5),inst_85516,inst_85518,null));
var inst_85520 = [inst_85515,inst_85519];
var inst_85521__$1 = cljs.core.PersistentHashMap.fromArrays(inst_85512,inst_85520);
var inst_85522 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_85521__$1);
var state_85579__$1 = (function (){var statearr_85589 = state_85579;
(statearr_85589[(9)] = inst_85521__$1);

return statearr_85589;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85579__$1,(15),inst_85522);
} else {
if((state_val_85580 === (22))){
var inst_85561 = (state_85579[(7)]);
var inst_85572 = (state_85579[(2)]);
var state_85579__$1 = (function (){var statearr_85590 = state_85579;
(statearr_85590[(10)] = inst_85572);

return statearr_85590;
})();
var statearr_85591_85630 = state_85579__$1;
(statearr_85591_85630[(2)] = inst_85561);

(statearr_85591_85630[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (6))){
var inst_85495 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_85496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85497 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_85498 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_85499 = [inst_85497,inst_85498,fn_name];
var inst_85500 = (new cljs.core.PersistentVector(null,3,(5),inst_85496,inst_85499,null));
var inst_85501 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_85495,inst_85500);
var state_85579__$1 = state_85579;
var statearr_85592_85631 = state_85579__$1;
(statearr_85592_85631[(2)] = inst_85501);

(statearr_85592_85631[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (17))){
var state_85579__$1 = state_85579;
var statearr_85593_85632 = state_85579__$1;
(statearr_85593_85632[(2)] = null);

(statearr_85593_85632[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (3))){
var inst_85577 = (state_85579[(2)]);
var state_85579__$1 = state_85579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_85579__$1,inst_85577);
} else {
if((state_val_85580 === (12))){
var inst_85508 = (state_85579[(11)]);
var inst_85510 = fluree.db.dbfunctions.core.resolve_local_fn(inst_85508);
var state_85579__$1 = state_85579;
var statearr_85594_85633 = state_85579__$1;
(statearr_85594_85633[(2)] = inst_85510);

(statearr_85594_85633[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (2))){
var inst_85492 = (state_85579[(12)]);
var _ = (function (){var statearr_85595 = state_85579;
(statearr_85595[(4)] = cljs.core.cons((5),(state_85579[(4)])));

return statearr_85595;
})();
var inst_85492__$1 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_85493 = cljs.core.not(inst_85492__$1);
var state_85579__$1 = (function (){var statearr_85596 = state_85579;
(statearr_85596[(12)] = inst_85492__$1);

return statearr_85596;
})();
if(inst_85493){
var statearr_85597_85634 = state_85579__$1;
(statearr_85597_85634[(1)] = (6));

} else {
var statearr_85598_85635 = state_85579__$1;
(statearr_85598_85635[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (19))){
var inst_85504 = (state_85579[(13)]);
var inst_85539 = (state_85579[(14)]);
var inst_85492 = (state_85579[(12)]);
var inst_85537 = (state_85579[(15)]);
var inst_85525 = (state_85579[(8)]);
var inst_85521 = (state_85579[(9)]);
var inst_85508 = (state_85579[(11)]);
var inst_85544 = (state_85579[(2)]);
var inst_85545 = fluree.db.util.async.throw_err(inst_85544);
var inst_85546 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_85525,"_fn/spec");
var inst_85547 = cljs.core.PersistentVector.EMPTY;
var inst_85548 = cljs.core.cst$sym$_QMARK_ctx;
var inst_85549 = (function (){var res = inst_85525;
var query = inst_85521;
var forward_time_travel_db_QMARK_ = inst_85492;
var _ = inst_85537;
var params = inst_85539;
var temp__5751__auto__ = inst_85508;
var or__4223__auto__ = inst_85504;
var spec = inst_85546;
var code = inst_85545;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_85550 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_85549,inst_85539);
var inst_85551 = cljs.core.cons(inst_85548,inst_85550);
var inst_85552 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_85547,inst_85551);
var inst_85553 = fluree.db.dbfunctions.core.build_fn(inst_85552,inst_85545);
var inst_85554 = [cljs.core.cst$kw$f,cljs.core.cst$kw$params,cljs.core.cst$kw$arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,cljs.core.cst$kw$code];
var inst_85555 = cljs.core.count(inst_85539);
var inst_85556 = [inst_85555];
var inst_85557 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_85556);
var inst_85558 = [inst_85553,inst_85539,inst_85557,false,inst_85546,null];
var inst_85559 = cljs.core.PersistentHashMap.fromArrays(inst_85554,inst_85558);
var state_85579__$1 = state_85579;
var statearr_85599_85636 = state_85579__$1;
(statearr_85599_85636[(2)] = inst_85559);

(statearr_85599_85636[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (11))){
var inst_85574 = (state_85579[(2)]);
var _ = (function (){var statearr_85601 = state_85579;
(statearr_85601[(4)] = cljs.core.rest((state_85579[(4)])));

return statearr_85601;
})();
var state_85579__$1 = state_85579;
var statearr_85602_85637 = state_85579__$1;
(statearr_85602_85637[(2)] = inst_85574);

(statearr_85602_85637[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (9))){
var inst_85504 = (state_85579[(13)]);
var state_85579__$1 = state_85579;
var statearr_85603_85638 = state_85579__$1;
(statearr_85603_85638[(2)] = inst_85504);

(statearr_85603_85638[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (5))){
var _ = (function (){var statearr_85604 = state_85579;
(statearr_85604[(4)] = cljs.core.rest((state_85579[(4)])));

return statearr_85604;
})();
var state_85579__$1 = state_85579;
var ex85600 = (state_85579__$1[(2)]);
var statearr_85605_85639 = state_85579__$1;
(statearr_85605_85639[(5)] = ex85600);


if((ex85600 instanceof Error)){
var statearr_85606_85640 = state_85579__$1;
(statearr_85606_85640[(1)] = (4));

(statearr_85606_85640[(5)] = null);

} else {
throw ex85600;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (14))){
var inst_85492 = (state_85579[(12)]);
var inst_85561 = (state_85579[(2)]);
var inst_85562 = cljs.core.not(inst_85492);
var state_85579__$1 = (function (){var statearr_85607 = state_85579;
(statearr_85607[(7)] = inst_85561);

return statearr_85607;
})();
if(inst_85562){
var statearr_85608_85641 = state_85579__$1;
(statearr_85608_85641[(1)] = (20));

} else {
var statearr_85609_85642 = state_85579__$1;
(statearr_85609_85642[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (16))){
var inst_85528 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_85529 = ["Unknown function: ",inst_85528].join('');
var inst_85530 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_85531 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_85532 = cljs.core.PersistentHashMap.fromArrays(inst_85530,inst_85531);
var inst_85533 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_85529,inst_85532);
var inst_85534 = (function(){throw inst_85533})();
var state_85579__$1 = state_85579;
var statearr_85610_85643 = state_85579__$1;
(statearr_85610_85643[(2)] = inst_85534);

(statearr_85610_85643[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (10))){
var inst_85508 = (state_85579[(11)]);
var inst_85507 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name);
var inst_85508__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,inst_85507);
var state_85579__$1 = (function (){var statearr_85611 = state_85579;
(statearr_85611[(11)] = inst_85508__$1);

return statearr_85611;
})();
if(cljs.core.truth_(inst_85508__$1)){
var statearr_85612_85644 = state_85579__$1;
(statearr_85612_85644[(1)] = (12));

} else {
var statearr_85613_85645 = state_85579__$1;
(statearr_85613_85645[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85580 === (18))){
var inst_85539 = (state_85579[(14)]);
var inst_85525 = (state_85579[(8)]);
var inst_85537 = (state_85579[(2)]);
var inst_85538 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_85525,"_fn/params");
var inst_85539__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_85538);
var inst_85540 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_85525,"_fn/code");
var inst_85541 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_85540);
var inst_85542 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_85541,funType,inst_85539__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_85541,funType,inst_85539__$1));
var state_85579__$1 = (function (){var statearr_85614 = state_85579;
(statearr_85614[(14)] = inst_85539__$1);

(statearr_85614[(15)] = inst_85537);

return statearr_85614;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85579__$1,(19),inst_85542);
} else {
if((state_val_85580 === (8))){
var inst_85504 = (state_85579[(13)]);
var inst_85504__$1 = (state_85579[(2)]);
var state_85579__$1 = (function (){var statearr_85615 = state_85579;
(statearr_85615[(13)] = inst_85504__$1);

return statearr_85615;
})();
if(cljs.core.truth_(inst_85504__$1)){
var statearr_85616_85646 = state_85579__$1;
(statearr_85616_85646[(1)] = (9));

} else {
var statearr_85617_85647 = state_85579__$1;
(statearr_85617_85647[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__20477__auto____0 = (function (){
var statearr_85618 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_85618[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__20477__auto__);

(statearr_85618[(1)] = (1));

return statearr_85618;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__20477__auto____1 = (function (state_85579){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_85579);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e85619){var ex__20480__auto__ = e85619;
var statearr_85620_85648 = state_85579;
(statearr_85620_85648[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_85579[(4)]))){
var statearr_85621_85649 = state_85579;
(statearr_85621_85649[(1)] = cljs.core.first((state_85579[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__85650 = state_85579;
state_85579 = G__85650;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__20477__auto__ = function(state_85579){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__20477__auto____1.call(this,state_85579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__20477__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_85622 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_85622[(6)] = c__20603__auto__);

return statearr_85622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__85652 = arguments.length;
switch (G__85652) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__85656 = arguments.length;
switch (G__85656) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_85786){
var state_val_85787 = (state_85786[(1)]);
if((state_val_85787 === (7))){
var inst_85781 = (state_85786[(2)]);
var _ = (function (){var statearr_85788 = state_85786;
(statearr_85788[(4)] = cljs.core.rest((state_85786[(4)])));

return statearr_85788;
})();
var state_85786__$1 = state_85786;
var statearr_85789_85869 = state_85786__$1;
(statearr_85789_85869[(2)] = inst_85781);

(statearr_85789_85869[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (20))){
var inst_85695 = (state_85786[(7)]);
var state_85786__$1 = state_85786;
var statearr_85790_85870 = state_85786__$1;
(statearr_85790_85870[(2)] = inst_85695);

(statearr_85790_85870[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (27))){
var inst_85682 = (state_85786[(8)]);
var inst_85708 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_85709 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_85682)," used in function.",inst_85708].join('');
var inst_85710 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_85711 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_85712 = cljs.core.PersistentHashMap.fromArrays(inst_85710,inst_85711);
var inst_85713 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_85709,inst_85712);
var inst_85714 = (function(){throw inst_85713})();
var state_85786__$1 = state_85786;
var statearr_85791_85871 = state_85786__$1;
(statearr_85791_85871[(2)] = inst_85714);

(statearr_85791_85871[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (1))){
var state_85786__$1 = state_85786;
var statearr_85792_85872 = state_85786__$1;
(statearr_85792_85872[(2)] = null);

(statearr_85792_85872[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (24))){
var inst_85705 = (state_85786[(9)]);
var inst_85705__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_85786__$1 = (function (){var statearr_85793 = state_85786;
(statearr_85793[(9)] = inst_85705__$1);

return statearr_85793;
})();
if(inst_85705__$1){
var statearr_85794_85873 = state_85786__$1;
(statearr_85794_85873[(1)] = (26));

} else {
var statearr_85795_85874 = state_85786__$1;
(statearr_85795_85874[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (39))){
var inst_85682 = (state_85786[(8)]);
var inst_85742 = (inst_85682 == null);
var state_85786__$1 = state_85786;
if(cljs.core.truth_(inst_85742)){
var statearr_85796_85875 = state_85786__$1;
(statearr_85796_85875[(1)] = (42));

} else {
var statearr_85797_85876 = state_85786__$1;
(statearr_85797_85876[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (46))){
var state_85786__$1 = state_85786;
var statearr_85798_85877 = state_85786__$1;
(statearr_85798_85877[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (4))){
var inst_85657 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
var statearr_85800_85878 = state_85786__$1;
(statearr_85800_85878[(2)] = inst_85657);

(statearr_85800_85878[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (15))){
var inst_85682 = (state_85786[(8)]);
var inst_85693 = (inst_85682 instanceof cljs.core.Symbol);
var state_85786__$1 = state_85786;
if(cljs.core.truth_(inst_85693)){
var statearr_85801_85879 = state_85786__$1;
(statearr_85801_85879[(1)] = (17));

} else {
var statearr_85802_85880 = state_85786__$1;
(statearr_85802_85880[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (48))){
var inst_85749 = (state_85786[(2)]);
var inst_85750 = fluree.db.util.async.throw_err(inst_85749);
var state_85786__$1 = state_85786;
var statearr_85803_85881 = state_85786__$1;
(statearr_85803_85881[(2)] = inst_85750);

(statearr_85803_85881[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (50))){
var state_85786__$1 = state_85786;
var statearr_85804_85882 = state_85786__$1;
(statearr_85804_85882[(2)] = null);

(statearr_85804_85882[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (21))){
var inst_85695 = (state_85786[(7)]);
var inst_85683 = (state_85786[(10)]);
var inst_85675 = (state_85786[(11)]);
var inst_85672 = (state_85786[(12)]);
var inst_85702 = (state_85786[(13)]);
var inst_85673 = (state_85786[(14)]);
var inst_85676 = (state_85786[(15)]);
var inst_85682 = (state_85786[(8)]);
var inst_85670 = (state_85786[(16)]);
var inst_85698 = [inst_85682];
var inst_85699 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_85698);
var inst_85700 = (function (){var x = inst_85682;
var first__85669 = inst_85672;
var seq__85668 = inst_85673;
var first__85680 = inst_85682;
var G__85666 = inst_85675;
var r = inst_85683;
var vec__85667 = inst_85670;
var acc = inst_85676;
var or__4223__auto__ = inst_85695;
var seq__85679 = inst_85683;
var vec__85678 = inst_85675;
return (function (p1__85654_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__85654_SHARP_);
});
})();
var inst_85701 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_85700,params);
var inst_85702__$1 = cljs.core.some(inst_85699,inst_85701);
var state_85786__$1 = (function (){var statearr_85805 = state_85786;
(statearr_85805[(13)] = inst_85702__$1);

return statearr_85805;
})();
if(cljs.core.truth_(inst_85702__$1)){
var statearr_85806_85883 = state_85786__$1;
(statearr_85806_85883[(1)] = (23));

} else {
var statearr_85807_85884 = state_85786__$1;
(statearr_85807_85884[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (31))){
var inst_85732 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
if(cljs.core.truth_(inst_85732)){
var statearr_85808_85885 = state_85786__$1;
(statearr_85808_85885[(1)] = (35));

} else {
var statearr_85809_85886 = state_85786__$1;
(statearr_85809_85886[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (32))){
var inst_85725 = (state_85786[(17)]);
var state_85786__$1 = state_85786;
var statearr_85810_85887 = state_85786__$1;
(statearr_85810_85887[(2)] = inst_85725);

(statearr_85810_85887[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (40))){
var inst_85767 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
var statearr_85811_85888 = state_85786__$1;
(statearr_85811_85888[(2)] = inst_85767);

(statearr_85811_85888[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (33))){
var inst_85682 = (state_85786[(8)]);
var inst_85728 = (inst_85682 == null);
var state_85786__$1 = state_85786;
var statearr_85812_85889 = state_85786__$1;
(statearr_85812_85889[(2)] = inst_85728);

(statearr_85812_85889[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (13))){
var inst_85683 = (state_85786[(10)]);
var inst_85676 = (state_85786[(15)]);
var inst_85775 = (state_85786[(2)]);
var inst_85776 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_85676,inst_85775);
var inst_85675 = inst_85683;
var inst_85676__$1 = inst_85776;
var state_85786__$1 = (function (){var statearr_85813 = state_85786;
(statearr_85813[(11)] = inst_85675);

(statearr_85813[(15)] = inst_85676__$1);

return statearr_85813;
})();
var statearr_85814_85890 = state_85786__$1;
(statearr_85814_85890[(2)] = null);

(statearr_85814_85890[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (22))){
var inst_85720 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
var statearr_85815_85891 = state_85786__$1;
(statearr_85815_85891[(2)] = inst_85720);

(statearr_85815_85891[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (36))){
var inst_85682 = (state_85786[(8)]);
var inst_85735 = cljs.core.vector_QMARK_(inst_85682);
var state_85786__$1 = state_85786;
if(inst_85735){
var statearr_85816_85892 = state_85786__$1;
(statearr_85816_85892[(1)] = (38));

} else {
var statearr_85817_85893 = state_85786__$1;
(statearr_85817_85893[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (41))){
var inst_85739 = (state_85786[(2)]);
var inst_85740 = fluree.db.util.async.throw_err(inst_85739);
var state_85786__$1 = state_85786;
var statearr_85818_85894 = state_85786__$1;
(statearr_85818_85894[(2)] = inst_85740);

(statearr_85818_85894[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (43))){
var inst_85682 = (state_85786[(8)]);
var inst_85745 = cljs.core.list_QMARK_(inst_85682);
var state_85786__$1 = state_85786;
if(inst_85745){
var statearr_85819_85895 = state_85786__$1;
(statearr_85819_85895[(1)] = (45));

} else {
var statearr_85820_85896 = state_85786__$1;
(statearr_85820_85896[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (29))){
var inst_85722 = (state_85786[(18)]);
var state_85786__$1 = state_85786;
var statearr_85821_85897 = state_85786__$1;
(statearr_85821_85897[(2)] = inst_85722);

(statearr_85821_85897[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (44))){
var inst_85765 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
var statearr_85822_85898 = state_85786__$1;
(statearr_85822_85898[(2)] = inst_85765);

(statearr_85822_85898[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (6))){
var inst_85675 = (state_85786[(11)]);
var inst_85682 = (state_85786[(8)]);
var inst_85681 = cljs.core.seq(inst_85675);
var inst_85682__$1 = cljs.core.first(inst_85681);
var inst_85683 = cljs.core.next(inst_85681);
var inst_85684 = (inst_85682__$1 == null);
var state_85786__$1 = (function (){var statearr_85823 = state_85786;
(statearr_85823[(10)] = inst_85683);

(statearr_85823[(8)] = inst_85682__$1);

return statearr_85823;
})();
if(cljs.core.truth_(inst_85684)){
var statearr_85824_85899 = state_85786__$1;
(statearr_85824_85899[(1)] = (8));

} else {
var statearr_85825_85900 = state_85786__$1;
(statearr_85825_85900[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (28))){
var inst_85716 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
var statearr_85826_85901 = state_85786__$1;
(statearr_85826_85901[(2)] = inst_85716);

(statearr_85826_85901[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (51))){
var inst_85761 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
var statearr_85827_85902 = state_85786__$1;
(statearr_85827_85902[(2)] = inst_85761);

(statearr_85827_85902[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (25))){
var inst_85718 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
var statearr_85828_85903 = state_85786__$1;
(statearr_85828_85903[(2)] = inst_85718);

(statearr_85828_85903[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (34))){
var inst_85730 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
var statearr_85829_85904 = state_85786__$1;
(statearr_85829_85904[(2)] = inst_85730);

(statearr_85829_85904[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (17))){
var inst_85695 = (state_85786[(7)]);
var inst_85682 = (state_85786[(8)]);
var inst_85695__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_85682) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_85682));
var state_85786__$1 = (function (){var statearr_85830 = state_85786;
(statearr_85830[(7)] = inst_85695__$1);

return statearr_85830;
})();
if(cljs.core.truth_(inst_85695__$1)){
var statearr_85831_85905 = state_85786__$1;
(statearr_85831_85905[(1)] = (20));

} else {
var statearr_85832_85906 = state_85786__$1;
(statearr_85832_85906[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (3))){
var inst_85784 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
return cljs.core.async.impl.ioc_helpers.return_chan(state_85786__$1,inst_85784);
} else {
if((state_val_85787 === (12))){
var inst_85682 = (state_85786[(8)]);
var inst_85690 = typeof inst_85682 === 'number';
var state_85786__$1 = state_85786;
if(cljs.core.truth_(inst_85690)){
var statearr_85833_85907 = state_85786__$1;
(statearr_85833_85907[(1)] = (14));

} else {
var statearr_85834_85908 = state_85786__$1;
(statearr_85834_85908[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (2))){
var inst_85670 = (state_85786[(16)]);
var _ = (function (){var statearr_85835 = state_85786;
(statearr_85835[(4)] = cljs.core.cons((5),(state_85786[(4)])));

return statearr_85835;
})();
var inst_85670__$1 = vec;
var inst_85671 = cljs.core.seq(inst_85670__$1);
var inst_85672 = cljs.core.first(inst_85671);
var inst_85673 = cljs.core.next(inst_85671);
var inst_85674 = cljs.core.PersistentVector.EMPTY;
var inst_85675 = inst_85670__$1;
var inst_85676 = inst_85674;
var state_85786__$1 = (function (){var statearr_85836 = state_85786;
(statearr_85836[(11)] = inst_85675);

(statearr_85836[(12)] = inst_85672);

(statearr_85836[(14)] = inst_85673);

(statearr_85836[(15)] = inst_85676);

(statearr_85836[(16)] = inst_85670__$1);

return statearr_85836;
})();
var statearr_85837_85909 = state_85786__$1;
(statearr_85837_85909[(2)] = null);

(statearr_85837_85909[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (23))){
var inst_85702 = (state_85786[(13)]);
var state_85786__$1 = state_85786;
var statearr_85838_85910 = state_85786__$1;
(statearr_85838_85910[(2)] = inst_85702);

(statearr_85838_85910[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (47))){
var inst_85763 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
var statearr_85839_85911 = state_85786__$1;
(statearr_85839_85911[(2)] = inst_85763);

(statearr_85839_85911[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (35))){
var inst_85682 = (state_85786[(8)]);
var state_85786__$1 = state_85786;
var statearr_85840_85912 = state_85786__$1;
(statearr_85840_85912[(2)] = inst_85682);

(statearr_85840_85912[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (19))){
var inst_85771 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
var statearr_85841_85913 = state_85786__$1;
(statearr_85841_85913[(2)] = inst_85771);

(statearr_85841_85913[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (11))){
var inst_85682 = (state_85786[(8)]);
var state_85786__$1 = state_85786;
var statearr_85843_85914 = state_85786__$1;
(statearr_85843_85914[(2)] = inst_85682);

(statearr_85843_85914[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (9))){
var inst_85682 = (state_85786[(8)]);
var inst_85687 = typeof inst_85682 === 'string';
var state_85786__$1 = state_85786;
if(cljs.core.truth_(inst_85687)){
var statearr_85844_85915 = state_85786__$1;
(statearr_85844_85915[(1)] = (11));

} else {
var statearr_85845_85916 = state_85786__$1;
(statearr_85845_85916[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (5))){
var _ = (function (){var statearr_85846 = state_85786;
(statearr_85846[(4)] = cljs.core.rest((state_85786[(4)])));

return statearr_85846;
})();
var state_85786__$1 = state_85786;
var ex85842 = (state_85786__$1[(2)]);
var statearr_85847_85917 = state_85786__$1;
(statearr_85847_85917[(5)] = ex85842);


if((ex85842 instanceof Error)){
var statearr_85848_85918 = state_85786__$1;
(statearr_85848_85918[(1)] = (4));

(statearr_85848_85918[(5)] = null);

} else {
throw ex85842;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (14))){
var inst_85682 = (state_85786[(8)]);
var state_85786__$1 = state_85786;
var statearr_85849_85919 = state_85786__$1;
(statearr_85849_85919[(2)] = inst_85682);

(statearr_85849_85919[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (45))){
var inst_85682 = (state_85786[(8)]);
var inst_85747 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_85682,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_85682,funType,params));
var state_85786__$1 = state_85786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85786__$1,(48),inst_85747);
} else {
if((state_val_85787 === (26))){
var inst_85705 = (state_85786[(9)]);
var state_85786__$1 = state_85786;
var statearr_85850_85920 = state_85786__$1;
(statearr_85850_85920[(2)] = inst_85705);

(statearr_85850_85920[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (16))){
var inst_85773 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
var statearr_85851_85921 = state_85786__$1;
(statearr_85851_85921[(2)] = inst_85773);

(statearr_85851_85921[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (38))){
var inst_85682 = (state_85786[(8)]);
var inst_85737 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_85682,funType,params);
var state_85786__$1 = state_85786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85786__$1,(41),inst_85737);
} else {
if((state_val_85787 === (30))){
var inst_85725 = (state_85786[(17)]);
var inst_85682 = (state_85786[(8)]);
var inst_85725__$1 = inst_85682 === false;
var state_85786__$1 = (function (){var statearr_85852 = state_85786;
(statearr_85852[(17)] = inst_85725__$1);

return statearr_85852;
})();
if(cljs.core.truth_(inst_85725__$1)){
var statearr_85853_85922 = state_85786__$1;
(statearr_85853_85922[(1)] = (32));

} else {
var statearr_85854_85923 = state_85786__$1;
(statearr_85854_85923[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (10))){
var inst_85779 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
var statearr_85855_85924 = state_85786__$1;
(statearr_85855_85924[(2)] = inst_85779);

(statearr_85855_85924[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (18))){
var inst_85682 = (state_85786[(8)]);
var inst_85722 = (state_85786[(18)]);
var inst_85722__$1 = inst_85682 === true;
var state_85786__$1 = (function (){var statearr_85856 = state_85786;
(statearr_85856[(18)] = inst_85722__$1);

return statearr_85856;
})();
if(cljs.core.truth_(inst_85722__$1)){
var statearr_85857_85925 = state_85786__$1;
(statearr_85857_85925[(1)] = (29));

} else {
var statearr_85858_85926 = state_85786__$1;
(statearr_85858_85926[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (42))){
var inst_85682 = (state_85786[(8)]);
var state_85786__$1 = state_85786;
var statearr_85859_85927 = state_85786__$1;
(statearr_85859_85927[(2)] = inst_85682);

(statearr_85859_85927[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (37))){
var inst_85769 = (state_85786[(2)]);
var state_85786__$1 = state_85786;
var statearr_85860_85928 = state_85786__$1;
(statearr_85860_85928[(2)] = inst_85769);

(statearr_85860_85928[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (8))){
var inst_85676 = (state_85786[(15)]);
var state_85786__$1 = state_85786;
var statearr_85861_85929 = state_85786__$1;
(statearr_85861_85929[(2)] = inst_85676);

(statearr_85861_85929[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85787 === (49))){
var inst_85682 = (state_85786[(8)]);
var inst_85753 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_85682], 0));
var inst_85754 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_85755 = ["Illegal element (",inst_85753,") in vector: ",inst_85754,"."].join('');
var inst_85756 = cljs.core.PersistentHashMap.EMPTY;
var inst_85757 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_85755,inst_85756);
var inst_85758 = (function(){throw inst_85757})();
var state_85786__$1 = state_85786;
var statearr_85862_85930 = state_85786__$1;
(statearr_85862_85930[(2)] = inst_85758);

(statearr_85862_85930[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__20477__auto____0 = (function (){
var statearr_85863 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_85863[(0)] = fluree$db$dbfunctions$core$state_machine__20477__auto__);

(statearr_85863[(1)] = (1));

return statearr_85863;
});
var fluree$db$dbfunctions$core$state_machine__20477__auto____1 = (function (state_85786){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_85786);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e85864){var ex__20480__auto__ = e85864;
var statearr_85865_85931 = state_85786;
(statearr_85865_85931[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_85786[(4)]))){
var statearr_85866_85932 = state_85786;
(statearr_85866_85932[(1)] = cljs.core.first((state_85786[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__85933 = state_85786;
state_85786 = G__85933;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__20477__auto__ = function(state_85786){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__20477__auto____1.call(this,state_85786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__20477__auto____0;
fluree$db$dbfunctions$core$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__20477__auto____1;
return fluree$db$dbfunctions$core$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_85867 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_85867[(6)] = c__20603__auto__);

return statearr_85867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__85936 = arguments.length;
switch (G__85936) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_86100){
var state_val_86101 = (state_86100[(1)]);
if((state_val_86101 === (7))){
var inst_85955 = (state_86100[(7)]);
var state_86100__$1 = state_86100;
var statearr_86102_86197 = state_86100__$1;
(statearr_86102_86197[(2)] = inst_85955);

(statearr_86102_86197[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (59))){
var inst_85988 = (state_86100[(8)]);
var inst_86062 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_85988], 0));
var inst_86063 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_85988) : type.call(null,inst_85988));
var inst_86064 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_86065 = ["Illegal element (",inst_86062,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_86063),") in function argument: ",inst_86064,"."].join('');
var inst_86066 = cljs.core.PersistentHashMap.EMPTY;
var inst_86067 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_86065,inst_86066);
var inst_86068 = (function(){throw inst_86067})();
var state_86100__$1 = state_86100;
var statearr_86103_86198 = state_86100__$1;
(statearr_86103_86198[(2)] = inst_86068);

(statearr_86103_86198[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (20))){
var inst_86090 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
var statearr_86104_86199 = state_86100__$1;
(statearr_86104_86199[(2)] = inst_86090);

(statearr_86104_86199[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (58))){
var inst_86073 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
var statearr_86105_86200 = state_86100__$1;
(statearr_86105_86200[(2)] = inst_86073);

(statearr_86105_86200[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (60))){
var state_86100__$1 = state_86100;
var statearr_86106_86201 = state_86100__$1;
(statearr_86106_86201[(2)] = null);

(statearr_86106_86201[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (27))){
var inst_86083 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
var statearr_86107_86202 = state_86100__$1;
(statearr_86107_86202[(2)] = inst_86083);

(statearr_86107_86202[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (1))){
var state_86100__$1 = state_86100;
var statearr_86108_86203 = state_86100__$1;
(statearr_86108_86203[(2)] = null);

(statearr_86108_86203[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (24))){
var inst_86000 = (state_86100[(2)]);
var inst_86001 = fluree.db.util.async.throw_err(inst_86000);
var state_86100__$1 = state_86100;
var statearr_86109_86204 = state_86100__$1;
(statearr_86109_86204[(2)] = inst_86001);

(statearr_86109_86204[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (55))){
var inst_86055 = (state_86100[(2)]);
var inst_86056 = fluree.db.util.async.throw_err(inst_86055);
var state_86100__$1 = state_86100;
var statearr_86110_86205 = state_86100__$1;
(statearr_86110_86205[(2)] = inst_86056);

(statearr_86110_86205[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (39))){
var inst_86034 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
var statearr_86111_86206 = state_86100__$1;
(statearr_86111_86206[(2)] = inst_86034);

(statearr_86111_86206[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (46))){
var inst_86041 = (state_86100[(9)]);
var state_86100__$1 = state_86100;
var statearr_86112_86207 = state_86100__$1;
(statearr_86112_86207[(2)] = inst_86041);

(statearr_86112_86207[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (4))){
var inst_85937 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
var statearr_86113_86208 = state_86100__$1;
(statearr_86113_86208[(2)] = inst_85937);

(statearr_86113_86208[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (54))){
var inst_86075 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
var statearr_86114_86209 = state_86100__$1;
(statearr_86114_86209[(2)] = inst_86075);

(statearr_86114_86209[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (15))){
var inst_85988 = (state_86100[(8)]);
var state_86100__$1 = state_86100;
var statearr_86115_86210 = state_86100__$1;
(statearr_86115_86210[(2)] = inst_85988);

(statearr_86115_86210[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (48))){
var inst_86046 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
var statearr_86116_86211 = state_86100__$1;
(statearr_86116_86211[(2)] = inst_86046);

(statearr_86116_86211[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (50))){
var inst_85988 = (state_86100[(8)]);
var inst_86051 = cljs.core.vector_QMARK_(inst_85988);
var state_86100__$1 = state_86100;
if(inst_86051){
var statearr_86117_86212 = state_86100__$1;
(statearr_86117_86212[(1)] = (52));

} else {
var statearr_86118_86213 = state_86100__$1;
(statearr_86118_86213[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (21))){
var inst_85988 = (state_86100[(8)]);
var inst_85998 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_85988,type,params);
var state_86100__$1 = state_86100;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86100__$1,(24),inst_85998);
} else {
if((state_val_86101 === (31))){
var inst_85988 = (state_86100[(8)]);
var inst_86011 = (state_86100[(10)]);
var inst_86011__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_85988) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_85988));
var state_86100__$1 = (function (){var statearr_86119 = state_86100;
(statearr_86119[(10)] = inst_86011__$1);

return statearr_86119;
})();
if(cljs.core.truth_(inst_86011__$1)){
var statearr_86120_86214 = state_86100__$1;
(statearr_86120_86214[(1)] = (34));

} else {
var statearr_86121_86215 = state_86100__$1;
(statearr_86121_86215[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (32))){
var inst_85988 = (state_86100[(8)]);
var inst_86038 = (state_86100[(11)]);
var inst_86038__$1 = inst_85988 === true;
var state_86100__$1 = (function (){var statearr_86122 = state_86100;
(statearr_86122[(11)] = inst_86038__$1);

return statearr_86122;
})();
if(cljs.core.truth_(inst_86038__$1)){
var statearr_86123_86216 = state_86100__$1;
(statearr_86123_86216[(1)] = (43));

} else {
var statearr_86124_86217 = state_86100__$1;
(statearr_86124_86217[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (40))){
var inst_86021 = (state_86100[(12)]);
var state_86100__$1 = state_86100;
var statearr_86125_86218 = state_86100__$1;
(statearr_86125_86218[(2)] = inst_86021);

(statearr_86125_86218[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (56))){
var inst_85988 = (state_86100[(8)]);
var state_86100__$1 = state_86100;
var statearr_86126_86219 = state_86100__$1;
(statearr_86126_86219[(2)] = inst_85988);

(statearr_86126_86219[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (33))){
var inst_86079 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
var statearr_86127_86220 = state_86100__$1;
(statearr_86127_86220[(2)] = inst_86079);

(statearr_86127_86220[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (13))){
var inst_85988 = (state_86100[(8)]);
var inst_85981 = (state_86100[(13)]);
var inst_85987 = cljs.core.seq(inst_85981);
var inst_85988__$1 = cljs.core.first(inst_85987);
var inst_85989 = cljs.core.next(inst_85987);
var state_86100__$1 = (function (){var statearr_86128 = state_86100;
(statearr_86128[(8)] = inst_85988__$1);

(statearr_86128[(14)] = inst_85989);

return statearr_86128;
})();
if(cljs.core.truth_(inst_85988__$1)){
var statearr_86129_86221 = state_86100__$1;
(statearr_86129_86221[(1)] = (15));

} else {
var statearr_86130_86222 = state_86100__$1;
(statearr_86130_86222[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (22))){
var inst_85988 = (state_86100[(8)]);
var inst_86003 = typeof inst_85988 === 'string';
var state_86100__$1 = state_86100;
if(cljs.core.truth_(inst_86003)){
var statearr_86131_86223 = state_86100__$1;
(statearr_86131_86223[(1)] = (25));

} else {
var statearr_86132_86224 = state_86100__$1;
(statearr_86132_86224[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (36))){
var inst_86036 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
var statearr_86133_86225 = state_86100__$1;
(statearr_86133_86225[(2)] = inst_86036);

(statearr_86133_86225[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (41))){
var inst_85988 = (state_86100[(8)]);
var inst_86024 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_86025 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_85988)," used in function argument: ",inst_86024].join('');
var inst_86026 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_86027 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_86028 = cljs.core.PersistentHashMap.fromArrays(inst_86026,inst_86027);
var inst_86029 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_86025,inst_86028);
var inst_86030 = (function(){throw inst_86029})();
var state_86100__$1 = state_86100;
var statearr_86134_86226 = state_86100__$1;
(statearr_86134_86226[(2)] = inst_86030);

(statearr_86134_86226[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (43))){
var inst_86038 = (state_86100[(11)]);
var state_86100__$1 = state_86100;
var statearr_86135_86227 = state_86100__$1;
(statearr_86135_86227[(2)] = inst_86038);

(statearr_86135_86227[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (61))){
var inst_86071 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
var statearr_86136_86228 = state_86100__$1;
(statearr_86136_86228[(2)] = inst_86071);

(statearr_86136_86228[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (29))){
var inst_85988 = (state_86100[(8)]);
var inst_86009 = (inst_85988 instanceof cljs.core.Symbol);
var state_86100__$1 = state_86100;
if(cljs.core.truth_(inst_86009)){
var statearr_86137_86229 = state_86100__$1;
(statearr_86137_86229[(1)] = (31));

} else {
var statearr_86138_86230 = state_86100__$1;
(statearr_86138_86230[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (44))){
var inst_85988 = (state_86100[(8)]);
var inst_86041 = (state_86100[(9)]);
var inst_86041__$1 = inst_85988 === false;
var state_86100__$1 = (function (){var statearr_86139 = state_86100;
(statearr_86139[(9)] = inst_86041__$1);

return statearr_86139;
})();
if(cljs.core.truth_(inst_86041__$1)){
var statearr_86140_86231 = state_86100__$1;
(statearr_86140_86231[(1)] = (46));

} else {
var statearr_86141_86232 = state_86100__$1;
(statearr_86141_86232[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (6))){
var inst_85950 = (state_86100[(15)]);
var inst_85955 = (state_86100[(7)]);
var inst_85951 = (state_86100[(16)]);
var inst_85949 = (state_86100[(2)]);
var inst_85950__$1 = fluree.db.util.async.throw_err(inst_85949);
var inst_85951__$1 = cljs.core.__destructure_map(inst_85950__$1);
var inst_85952 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_85951__$1,cljs.core.cst$kw$f);
var inst_85953 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_85951__$1,cljs.core.cst$kw$arity);
var inst_85954 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_85951__$1,cljs.core.cst$kw$arglist);
var inst_85955__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_85951__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_86100__$1 = (function (){var statearr_86142 = state_86100;
(statearr_86142[(17)] = inst_85954);

(statearr_86142[(18)] = inst_85953);

(statearr_86142[(15)] = inst_85950__$1);

(statearr_86142[(7)] = inst_85955__$1);

(statearr_86142[(16)] = inst_85951__$1);

(statearr_86142[(19)] = inst_85952);

return statearr_86142;
})();
if(cljs.core.truth_(inst_85955__$1)){
var statearr_86143_86233 = state_86100__$1;
(statearr_86143_86233[(1)] = (7));

} else {
var statearr_86144_86234 = state_86100__$1;
(statearr_86144_86234[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (28))){
var inst_85988 = (state_86100[(8)]);
var state_86100__$1 = state_86100;
var statearr_86145_86235 = state_86100__$1;
(statearr_86145_86235[(2)] = inst_85988);

(statearr_86145_86235[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (51))){
var inst_86077 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
var statearr_86146_86236 = state_86100__$1;
(statearr_86146_86236[(2)] = inst_86077);

(statearr_86146_86236[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (25))){
var inst_85988 = (state_86100[(8)]);
var state_86100__$1 = state_86100;
var statearr_86147_86237 = state_86100__$1;
(statearr_86147_86237[(2)] = inst_85988);

(statearr_86147_86237[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (34))){
var inst_86011 = (state_86100[(10)]);
var state_86100__$1 = state_86100;
var statearr_86148_86238 = state_86100__$1;
(statearr_86148_86238[(2)] = inst_86011);

(statearr_86148_86238[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (17))){
var inst_85994 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
if(cljs.core.truth_(inst_85994)){
var statearr_86149_86239 = state_86100__$1;
(statearr_86149_86239[(1)] = (18));

} else {
var statearr_86150_86240 = state_86100__$1;
(statearr_86150_86240[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (3))){
var inst_86098 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
return cljs.core.async.impl.ioc_helpers.return_chan(state_86100__$1,inst_86098);
} else {
if((state_val_86101 === (12))){
var inst_85945 = (state_86100[(20)]);
var inst_85969 = (state_86100[(2)]);
var inst_85977 = cljs.core.seq(inst_85945);
var inst_85978 = cljs.core.first(inst_85977);
var inst_85979 = cljs.core.next(inst_85977);
var inst_85980 = cljs.core.PersistentVector.EMPTY;
var inst_85981 = inst_85945;
var inst_85982 = inst_85980;
var state_86100__$1 = (function (){var statearr_86151 = state_86100;
(statearr_86151[(21)] = inst_85979);

(statearr_86151[(22)] = inst_85969);

(statearr_86151[(23)] = inst_85982);

(statearr_86151[(24)] = inst_85978);

(statearr_86151[(13)] = inst_85981);

return statearr_86151;
})();
var statearr_86152_86241 = state_86100__$1;
(statearr_86152_86241[(2)] = null);

(statearr_86152_86241[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (2))){
var inst_85944 = (state_86100[(25)]);
var inst_85945 = (state_86100[(20)]);
var _ = (function (){var statearr_86153 = state_86100;
(statearr_86153[(4)] = cljs.core.cons((5),(state_86100[(4)])));

return statearr_86153;
})();
var inst_85944__$1 = cljs.core.first(form);
var inst_85945__$1 = cljs.core.rest(form);
var inst_85946 = cljs.core.count(inst_85945__$1);
var inst_85947 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_85944__$1,type);
var state_86100__$1 = (function (){var statearr_86154 = state_86100;
(statearr_86154[(25)] = inst_85944__$1);

(statearr_86154[(26)] = inst_85946);

(statearr_86154[(20)] = inst_85945__$1);

return statearr_86154;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86100__$1,(6),inst_85947);
} else {
if((state_val_86101 === (23))){
var inst_85989 = (state_86100[(14)]);
var inst_85982 = (state_86100[(23)]);
var inst_86085 = (state_86100[(2)]);
var inst_86086 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_85982,inst_86085);
var inst_85981 = inst_85989;
var inst_85982__$1 = inst_86086;
var state_86100__$1 = (function (){var statearr_86155 = state_86100;
(statearr_86155[(23)] = inst_85982__$1);

(statearr_86155[(13)] = inst_85981);

return statearr_86155;
})();
var statearr_86156_86242 = state_86100__$1;
(statearr_86156_86242[(2)] = null);

(statearr_86156_86242[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (47))){
var inst_85988 = (state_86100[(8)]);
var inst_86044 = (inst_85988 == null);
var state_86100__$1 = state_86100;
var statearr_86157_86243 = state_86100__$1;
(statearr_86157_86243[(2)] = inst_86044);

(statearr_86157_86243[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (35))){
var inst_85988 = (state_86100[(8)]);
var inst_85944 = (state_86100[(25)]);
var inst_86018 = (state_86100[(27)]);
var inst_85954 = (state_86100[(17)]);
var inst_85979 = (state_86100[(21)]);
var inst_85953 = (state_86100[(18)]);
var inst_85969 = (state_86100[(22)]);
var inst_85950 = (state_86100[(15)]);
var inst_85946 = (state_86100[(26)]);
var inst_85989 = (state_86100[(14)]);
var inst_85955 = (state_86100[(7)]);
var inst_85951 = (state_86100[(16)]);
var inst_85982 = (state_86100[(23)]);
var inst_85945 = (state_86100[(20)]);
var inst_85952 = (state_86100[(19)]);
var inst_86011 = (state_86100[(10)]);
var inst_85978 = (state_86100[(24)]);
var inst_85981 = (state_86100[(13)]);
var inst_86014 = [inst_85988];
var inst_86015 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_86014);
var inst_86016 = (function (){var arity = inst_85953;
var args_n = inst_85946;
var fn_map = inst_85950;
var vec__85984 = inst_85981;
var args = inst_85945;
var r = inst_85989;
var _ = inst_85969;
var first__85976 = inst_85978;
var acc = inst_85982;
var arglist = inst_85954;
var fn_name = inst_85944;
var first__85986 = inst_85988;
var map__85943 = inst_85951;
var _AMPERSAND_args_QMARK_ = inst_85955;
var or__4223__auto__ = inst_86011;
var seq__85975 = inst_85979;
var arg = inst_85988;
var seq__85985 = inst_85989;
var vec__85974 = inst_85945;
var G__85973 = inst_85981;
var f = inst_85952;
return (function (p1__85934_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__85934_SHARP_);
});
})();
var inst_86017 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_86016,params);
var inst_86018__$1 = cljs.core.some(inst_86015,inst_86017);
var state_86100__$1 = (function (){var statearr_86158 = state_86100;
(statearr_86158[(27)] = inst_86018__$1);

return statearr_86158;
})();
if(cljs.core.truth_(inst_86018__$1)){
var statearr_86159_86244 = state_86100__$1;
(statearr_86159_86244[(1)] = (37));

} else {
var statearr_86160_86245 = state_86100__$1;
(statearr_86160_86245[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (19))){
var inst_85982 = (state_86100[(23)]);
var state_86100__$1 = state_86100;
var statearr_86161_86246 = state_86100__$1;
(statearr_86161_86246[(2)] = inst_85982);

(statearr_86161_86246[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (57))){
var state_86100__$1 = state_86100;
var statearr_86162_86247 = state_86100__$1;
(statearr_86162_86247[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (11))){
var state_86100__$1 = state_86100;
var statearr_86165_86248 = state_86100__$1;
(statearr_86165_86248[(2)] = null);

(statearr_86165_86248[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (9))){
var inst_85960 = (state_86100[(2)]);
var inst_85961 = cljs.core.not(inst_85960);
var state_86100__$1 = state_86100;
if(inst_85961){
var statearr_86166_86249 = state_86100__$1;
(statearr_86166_86249[(1)] = (10));

} else {
var statearr_86167_86250 = state_86100__$1;
(statearr_86167_86250[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (5))){
var _ = (function (){var statearr_86168 = state_86100;
(statearr_86168[(4)] = cljs.core.rest((state_86100[(4)])));

return statearr_86168;
})();
var state_86100__$1 = state_86100;
var ex86164 = (state_86100__$1[(2)]);
var statearr_86169_86251 = state_86100__$1;
(statearr_86169_86251[(5)] = ex86164);


if((ex86164 instanceof Error)){
var statearr_86170_86252 = state_86100__$1;
(statearr_86170_86252[(1)] = (4));

(statearr_86170_86252[(5)] = null);

} else {
throw ex86164;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (14))){
var inst_85952 = (state_86100[(19)]);
var inst_86092 = (state_86100[(2)]);
var inst_86093 = cljs.core.cst$sym$_QMARK_ctx;
var inst_86094 = cljs.core.cons(inst_86093,inst_86092);
var inst_86095 = cljs.core.cons(inst_85952,inst_86094);
var _ = (function (){var statearr_86171 = state_86100;
(statearr_86171[(4)] = cljs.core.rest((state_86100[(4)])));

return statearr_86171;
})();
var state_86100__$1 = state_86100;
var statearr_86172_86253 = state_86100__$1;
(statearr_86172_86253[(2)] = inst_86095);

(statearr_86172_86253[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (45))){
var inst_86048 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
if(cljs.core.truth_(inst_86048)){
var statearr_86173_86254 = state_86100__$1;
(statearr_86173_86254[(1)] = (49));

} else {
var statearr_86174_86255 = state_86100__$1;
(statearr_86174_86255[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (53))){
var inst_85988 = (state_86100[(8)]);
var inst_86058 = (inst_85988 == null);
var state_86100__$1 = state_86100;
if(cljs.core.truth_(inst_86058)){
var statearr_86175_86256 = state_86100__$1;
(statearr_86175_86256[(1)] = (56));

} else {
var statearr_86176_86257 = state_86100__$1;
(statearr_86176_86257[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (26))){
var inst_85988 = (state_86100[(8)]);
var inst_86006 = typeof inst_85988 === 'number';
var state_86100__$1 = state_86100;
if(cljs.core.truth_(inst_86006)){
var statearr_86177_86258 = state_86100__$1;
(statearr_86177_86258[(1)] = (28));

} else {
var statearr_86178_86259 = state_86100__$1;
(statearr_86178_86259[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (16))){
var inst_85988 = (state_86100[(8)]);
var inst_85992 = inst_85988 === false;
var state_86100__$1 = state_86100;
var statearr_86179_86260 = state_86100__$1;
(statearr_86179_86260[(2)] = inst_85992);

(statearr_86179_86260[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (38))){
var inst_86021 = (state_86100[(12)]);
var inst_86021__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_86100__$1 = (function (){var statearr_86180 = state_86100;
(statearr_86180[(12)] = inst_86021__$1);

return statearr_86180;
})();
if(inst_86021__$1){
var statearr_86181_86261 = state_86100__$1;
(statearr_86181_86261[(1)] = (40));

} else {
var statearr_86182_86262 = state_86100__$1;
(statearr_86182_86262[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (30))){
var inst_86081 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
var statearr_86183_86263 = state_86100__$1;
(statearr_86183_86263[(2)] = inst_86081);

(statearr_86183_86263[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (10))){
var inst_85944 = (state_86100[(25)]);
var inst_85953 = (state_86100[(18)]);
var inst_85946 = (state_86100[(26)]);
var inst_85963 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_85944),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_85953),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_85946),"."].join('');
var inst_85964 = cljs.core.PersistentHashMap.EMPTY;
var inst_85965 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_85963,inst_85964);
var inst_85966 = (function(){throw inst_85965})();
var state_86100__$1 = state_86100;
var statearr_86184_86264 = state_86100__$1;
(statearr_86184_86264[(2)] = inst_85966);

(statearr_86184_86264[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (18))){
var inst_85988 = (state_86100[(8)]);
var inst_85996 = cljs.core.list_QMARK_(inst_85988);
var state_86100__$1 = state_86100;
if(inst_85996){
var statearr_86185_86265 = state_86100__$1;
(statearr_86185_86265[(1)] = (21));

} else {
var statearr_86186_86266 = state_86100__$1;
(statearr_86186_86266[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (52))){
var inst_85988 = (state_86100[(8)]);
var inst_86053 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_85988,type,params);
var state_86100__$1 = state_86100;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86100__$1,(55),inst_86053);
} else {
if((state_val_86101 === (42))){
var inst_86032 = (state_86100[(2)]);
var state_86100__$1 = state_86100;
var statearr_86187_86267 = state_86100__$1;
(statearr_86187_86267[(2)] = inst_86032);

(statearr_86187_86267[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (37))){
var inst_86018 = (state_86100[(27)]);
var state_86100__$1 = state_86100;
var statearr_86188_86268 = state_86100__$1;
(statearr_86188_86268[(2)] = inst_86018);

(statearr_86188_86268[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (8))){
var inst_85953 = (state_86100[(18)]);
var inst_85946 = (state_86100[(26)]);
var inst_85958 = (inst_85953.cljs$core$IFn$_invoke$arity$1 ? inst_85953.cljs$core$IFn$_invoke$arity$1(inst_85946) : inst_85953.call(null,inst_85946));
var state_86100__$1 = state_86100;
var statearr_86189_86269 = state_86100__$1;
(statearr_86189_86269[(2)] = inst_85958);

(statearr_86189_86269[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86101 === (49))){
var inst_85988 = (state_86100[(8)]);
var state_86100__$1 = state_86100;
var statearr_86190_86270 = state_86100__$1;
(statearr_86190_86270[(2)] = inst_85988);

(statearr_86190_86270[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__20477__auto____0 = (function (){
var statearr_86191 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_86191[(0)] = fluree$db$dbfunctions$core$state_machine__20477__auto__);

(statearr_86191[(1)] = (1));

return statearr_86191;
});
var fluree$db$dbfunctions$core$state_machine__20477__auto____1 = (function (state_86100){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_86100);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e86192){var ex__20480__auto__ = e86192;
var statearr_86193_86271 = state_86100;
(statearr_86193_86271[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_86100[(4)]))){
var statearr_86194_86272 = state_86100;
(statearr_86194_86272[(1)] = cljs.core.first((state_86100[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__86273 = state_86100;
state_86100 = G__86273;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__20477__auto__ = function(state_86100){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__20477__auto____1.call(this,state_86100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__20477__auto____0;
fluree$db$dbfunctions$core$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__20477__auto____1;
return fluree$db$dbfunctions$core$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_86195 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_86195[(6)] = c__20603__auto__);

return statearr_86195;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__86275 = arguments.length;
switch (G__86275) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_86357){
var state_val_86358 = (state_86357[(1)]);
if((state_val_86358 === (7))){
var inst_86285 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var state_86357__$1 = state_86357;
var statearr_86359_86407 = state_86357__$1;
(statearr_86359_86407[(2)] = inst_86285);

(statearr_86359_86407[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (20))){
var inst_86335 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_86357__$1 = state_86357;
var statearr_86360_86408 = state_86357__$1;
(statearr_86360_86408[(2)] = inst_86335);

(statearr_86360_86408[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (1))){
var state_86357__$1 = state_86357;
var statearr_86361_86409 = state_86357__$1;
(statearr_86361_86409[(2)] = null);

(statearr_86361_86409[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (24))){
var inst_86332 = (state_86357[(7)]);
var inst_86341 = cljs.core.eval(inst_86332);
var state_86357__$1 = state_86357;
var statearr_86363_86410 = state_86357__$1;
(statearr_86363_86410[(2)] = inst_86341);

(statearr_86363_86410[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (4))){
var inst_86276 = (state_86357[(2)]);
var state_86357__$1 = state_86357;
var statearr_86364_86411 = state_86357__$1;
(statearr_86364_86411[(2)] = inst_86276);

(statearr_86364_86411[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (15))){
var _ = (function (){var statearr_86365 = state_86357;
(statearr_86365[(4)] = cljs.core.rest((state_86357[(4)])));

return statearr_86365;
})();
var state_86357__$1 = state_86357;
var ex86362 = (state_86357__$1[(2)]);
var statearr_86366_86412 = state_86357__$1;
(statearr_86366_86412[(5)] = ex86362);


var statearr_86367_86413 = state_86357__$1;
(statearr_86367_86413[(1)] = (14));

(statearr_86367_86413[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (21))){
var inst_86333 = (state_86357[(8)]);
var state_86357__$1 = state_86357;
var statearr_86368_86414 = state_86357__$1;
(statearr_86368_86414[(2)] = inst_86333);

(statearr_86368_86414[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (13))){
var inst_86350 = (state_86357[(2)]);
var state_86357__$1 = state_86357;
var statearr_86369_86415 = state_86357__$1;
(statearr_86369_86415[(2)] = inst_86350);

(statearr_86369_86415[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (22))){
var inst_86338 = (state_86357[(2)]);
var state_86357__$1 = state_86357;
if(cljs.core.truth_(inst_86338)){
var statearr_86370_86416 = state_86357__$1;
(statearr_86370_86416[(1)] = (23));

} else {
var statearr_86371_86417 = state_86357__$1;
(statearr_86371_86417[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (6))){
var inst_86282 = (state_86357[(9)]);
var state_86357__$1 = state_86357;
var statearr_86372_86418 = state_86357__$1;
(statearr_86372_86418[(2)] = inst_86282);

(statearr_86372_86418[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (25))){
var inst_86343 = (state_86357[(2)]);
var inst_86344 = [cljs.core.cst$kw$fnstr];
var inst_86345 = [fn_str];
var inst_86346 = cljs.core.PersistentHashMap.fromArrays(inst_86344,inst_86345);
var inst_86347 = cljs.core.with_meta(inst_86343,inst_86346);
var _ = (function (){var statearr_86373 = state_86357;
(statearr_86373[(4)] = cljs.core.rest((state_86357[(4)])));

return statearr_86373;
})();
var state_86357__$1 = state_86357;
var statearr_86374_86419 = state_86357__$1;
(statearr_86374_86419[(2)] = inst_86347);

(statearr_86374_86419[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (17))){
var inst_86308 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_86309 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_86310 = cljs.core.PersistentHashMap.fromArrays(inst_86308,inst_86309);
var inst_86311 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_86310);
var inst_86312 = (function(){throw inst_86311})();
var state_86357__$1 = state_86357;
var statearr_86375_86420 = state_86357__$1;
(statearr_86375_86420[(2)] = inst_86312);

(statearr_86375_86420[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (3))){
var inst_86355 = (state_86357[(2)]);
var state_86357__$1 = state_86357;
return cljs.core.async.impl.ioc_helpers.return_chan(state_86357__$1,inst_86355);
} else {
if((state_val_86358 === (12))){
var _ = (function (){var statearr_86376 = state_86357;
(statearr_86376[(4)] = cljs.core.cons((15),(state_86357[(4)])));

return statearr_86376;
})();
var inst_86305 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_86357__$1 = state_86357;
if(cljs.core.truth_(inst_86305)){
var statearr_86377_86421 = state_86357__$1;
(statearr_86377_86421[(1)] = (16));

} else {
var statearr_86378_86422 = state_86357__$1;
(statearr_86378_86422[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (2))){
var inst_86282 = (state_86357[(9)]);
var _ = (function (){var statearr_86379 = state_86357;
(statearr_86379[(4)] = cljs.core.cons((5),(state_86357[(4)])));

return statearr_86379;
})();
var inst_86282__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var state_86357__$1 = (function (){var statearr_86380 = state_86357;
(statearr_86380[(9)] = inst_86282__$1);

return statearr_86380;
})();
if(inst_86282__$1){
var statearr_86381_86423 = state_86357__$1;
(statearr_86381_86423[(1)] = (6));

} else {
var statearr_86382_86424 = state_86357__$1;
(statearr_86382_86424[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (23))){
var inst_86332 = (state_86357[(7)]);
var state_86357__$1 = state_86357;
var statearr_86383_86425 = state_86357__$1;
(statearr_86383_86425[(2)] = inst_86332);

(statearr_86383_86425[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (19))){
var inst_86333 = (state_86357[(8)]);
var inst_86318 = (state_86357[(2)]);
var inst_86319 = fluree.db.util.async.throw_err(inst_86318);
var inst_86320 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_86321 = (new cljs.core.List(null,inst_86320,null,(1),null));
var inst_86322 = cljs.core.cst$sym$_QMARK_ctx;
var inst_86323 = (new cljs.core.List(null,inst_86322,null,(1),null));
var inst_86324 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_86323);
var inst_86325 = cljs.core.seq(inst_86324);
var inst_86326 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_86325);
var inst_86327 = cljs.core.vec(inst_86326);
var inst_86328 = (new cljs.core.List(null,inst_86327,null,(1),null));
var inst_86329 = (new cljs.core.List(null,inst_86319,null,(1),null));
var inst_86330 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_86321,inst_86328,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_86329], 0));
var inst_86331 = cljs.core.seq(inst_86330);
var inst_86332 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_86331);
var inst_86333__$1 = params;
var state_86357__$1 = (function (){var statearr_86384 = state_86357;
(statearr_86384[(7)] = inst_86332);

(statearr_86384[(8)] = inst_86333__$1);

return statearr_86384;
})();
if(cljs.core.truth_(inst_86333__$1)){
var statearr_86385_86426 = state_86357__$1;
(statearr_86385_86426[(1)] = (20));

} else {
var statearr_86386_86427 = state_86357__$1;
(statearr_86386_86427[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (11))){
var inst_86352 = (state_86357[(2)]);
var _ = (function (){var statearr_86388 = state_86357;
(statearr_86388[(4)] = cljs.core.rest((state_86357[(4)])));

return statearr_86388;
})();
var state_86357__$1 = state_86357;
var statearr_86389_86428 = state_86357__$1;
(statearr_86389_86428[(2)] = inst_86352);

(statearr_86389_86428[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (9))){
var inst_86289 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_86290 = fluree.db.dbfunctions.core.true_or_false = inst_86289;
var state_86357__$1 = state_86357;
var statearr_86390_86429 = state_86357__$1;
(statearr_86390_86429[(2)] = inst_86290);

(statearr_86390_86429[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (5))){
var _ = (function (){var statearr_86391 = state_86357;
(statearr_86391[(4)] = cljs.core.rest((state_86357[(4)])));

return statearr_86391;
})();
var state_86357__$1 = state_86357;
var ex86387 = (state_86357__$1[(2)]);
var statearr_86392_86430 = state_86357__$1;
(statearr_86392_86430[(5)] = ex86387);


if((ex86387 instanceof Error)){
var statearr_86393_86431 = state_86357__$1;
(statearr_86393_86431[(1)] = (4));

(statearr_86393_86431[(5)] = null);

} else {
throw ex86387;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (14))){
var inst_86292 = (state_86357[(2)]);
var inst_86293 = (function(){throw inst_86292})();
var inst_86294 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_86295 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_86296 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_86297 = cljs.core.PersistentHashMap.fromArrays(inst_86295,inst_86296);
var inst_86298 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_86294,inst_86297);
var inst_86299 = (function(){throw inst_86298})();
var state_86357__$1 = (function (){var statearr_86394 = state_86357;
(statearr_86394[(10)] = inst_86293);

return statearr_86394;
})();
var statearr_86395_86432 = state_86357__$1;
(statearr_86395_86432[(2)] = inst_86299);

(statearr_86395_86432[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (16))){
var state_86357__$1 = state_86357;
var statearr_86396_86433 = state_86357__$1;
(statearr_86396_86433[(2)] = null);

(statearr_86396_86433[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (10))){
var state_86357__$1 = state_86357;
var statearr_86397_86434 = state_86357__$1;
(statearr_86397_86434[(2)] = null);

(statearr_86397_86434[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86358 === (18))){
var inst_86314 = (state_86357[(2)]);
var inst_86315 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_86316 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_86315,type,params);
var state_86357__$1 = (function (){var statearr_86398 = state_86357;
(statearr_86398[(11)] = inst_86314);

return statearr_86398;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86357__$1,(19),inst_86316);
} else {
if((state_val_86358 === (8))){
var inst_86287 = (state_86357[(2)]);
var state_86357__$1 = state_86357;
if(cljs.core.truth_(inst_86287)){
var statearr_86399_86435 = state_86357__$1;
(statearr_86399_86435[(1)] = (9));

} else {
var statearr_86400_86436 = state_86357__$1;
(statearr_86400_86436[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__20477__auto____0 = (function (){
var statearr_86401 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_86401[(0)] = fluree$db$dbfunctions$core$state_machine__20477__auto__);

(statearr_86401[(1)] = (1));

return statearr_86401;
});
var fluree$db$dbfunctions$core$state_machine__20477__auto____1 = (function (state_86357){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_86357);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e86402){var ex__20480__auto__ = e86402;
var statearr_86403_86437 = state_86357;
(statearr_86403_86437[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_86357[(4)]))){
var statearr_86404_86438 = state_86357;
(statearr_86404_86438[(1)] = cljs.core.first((state_86357[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__86439 = state_86357;
state_86357 = G__86439;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__20477__auto__ = function(state_86357){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__20477__auto____1.call(this,state_86357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__20477__auto____0;
fluree$db$dbfunctions$core$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__20477__auto____1;
return fluree$db$dbfunctions$core$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_86405 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_86405[(6)] = c__20603__auto__);

return statearr_86405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_86467){
var state_val_86468 = (state_86467[(1)]);
if((state_val_86468 === (7))){
var inst_86454 = (state_86467[(7)]);
var state_86467__$1 = state_86467;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86467__$1,(10),inst_86454);
} else {
if((state_val_86468 === (1))){
var state_86467__$1 = state_86467;
var statearr_86469_86489 = state_86467__$1;
(statearr_86469_86489[(2)] = null);

(statearr_86469_86489[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86468 === (4))){
var inst_86440 = (state_86467[(2)]);
var state_86467__$1 = state_86467;
var statearr_86470_86490 = state_86467__$1;
(statearr_86470_86490[(2)] = inst_86440);

(statearr_86470_86490[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86468 === (6))){
var inst_86454 = (state_86467[(7)]);
var inst_86449 = (state_86467[(8)]);
var inst_86452 = (state_86467[(2)]);
var inst_86453 = fluree.db.util.async.throw_err(inst_86452);
var inst_86454__$1 = (inst_86453.cljs$core$IFn$_invoke$arity$1 ? inst_86453.cljs$core$IFn$_invoke$arity$1(inst_86449) : inst_86453.call(null,inst_86449));
var inst_86455 = fluree.db.util.async.channel_QMARK_(inst_86454__$1);
var state_86467__$1 = (function (){var statearr_86471 = state_86467;
(statearr_86471[(7)] = inst_86454__$1);

return statearr_86471;
})();
if(inst_86455){
var statearr_86472_86491 = state_86467__$1;
(statearr_86472_86491[(1)] = (7));

} else {
var statearr_86473_86492 = state_86467__$1;
(statearr_86473_86492[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86468 === (3))){
var inst_86465 = (state_86467[(2)]);
var state_86467__$1 = state_86467;
return cljs.core.async.impl.ioc_helpers.return_chan(state_86467__$1,inst_86465);
} else {
if((state_val_86468 === (2))){
var _ = (function (){var statearr_86475 = state_86467;
(statearr_86475[(4)] = cljs.core.cons((5),(state_86467[(4)])));

return statearr_86475;
})();
var inst_86446 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_86447 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_86448 = [db,block_instant,s,p,auth_id,fuel];
var inst_86449 = cljs.core.PersistentHashMap.fromArrays(inst_86447,inst_86448);
var inst_86450 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_86446,"txn",null);
var state_86467__$1 = (function (){var statearr_86476 = state_86467;
(statearr_86476[(8)] = inst_86449);

return statearr_86476;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86467__$1,(6),inst_86450);
} else {
if((state_val_86468 === (9))){
var inst_86462 = (state_86467[(2)]);
var _ = (function (){var statearr_86477 = state_86467;
(statearr_86477[(4)] = cljs.core.rest((state_86467[(4)])));

return statearr_86477;
})();
var state_86467__$1 = state_86467;
var statearr_86478_86493 = state_86467__$1;
(statearr_86478_86493[(2)] = inst_86462);

(statearr_86478_86493[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86468 === (5))){
var _ = (function (){var statearr_86479 = state_86467;
(statearr_86479[(4)] = cljs.core.rest((state_86467[(4)])));

return statearr_86479;
})();
var state_86467__$1 = state_86467;
var ex86474 = (state_86467__$1[(2)]);
var statearr_86480_86494 = state_86467__$1;
(statearr_86480_86494[(5)] = ex86474);


if((ex86474 instanceof Error)){
var statearr_86481_86495 = state_86467__$1;
(statearr_86481_86495[(1)] = (4));

(statearr_86481_86495[(5)] = null);

} else {
throw ex86474;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86468 === (10))){
var inst_86458 = (state_86467[(2)]);
var inst_86459 = fluree.db.util.async.throw_err(inst_86458);
var state_86467__$1 = state_86467;
var statearr_86482_86496 = state_86467__$1;
(statearr_86482_86496[(2)] = inst_86459);

(statearr_86482_86496[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86468 === (8))){
var inst_86454 = (state_86467[(7)]);
var state_86467__$1 = state_86467;
var statearr_86483_86497 = state_86467__$1;
(statearr_86483_86497[(2)] = inst_86454);

(statearr_86483_86497[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__20477__auto____0 = (function (){
var statearr_86484 = [null,null,null,null,null,null,null,null,null];
(statearr_86484[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__20477__auto__);

(statearr_86484[(1)] = (1));

return statearr_86484;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__20477__auto____1 = (function (state_86467){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_86467);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e86485){var ex__20480__auto__ = e86485;
var statearr_86486_86498 = state_86467;
(statearr_86486_86498[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_86467[(4)]))){
var statearr_86487_86499 = state_86467;
(statearr_86487_86499[(1)] = cljs.core.first((state_86467[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__86500 = state_86467;
state_86467 = G__86500;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__20477__auto__ = function(state_86467){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__20477__auto____1.call(this,state_86467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_86488 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_86488[(6)] = c__20603__auto__);

return statearr_86488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
