// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k46308,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__46312 = k46308;
var G__46312__$1 = (((G__46312 instanceof cljs.core.Keyword))?G__46312.fqn:null);
switch (G__46312__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46308,else__4475__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__46313){
var vec__46314 = p__46313;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46314,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46314,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46307){
var self__ = this;
var G__46307__$1 = this;
return (new cljs.core.RecordIter((0),G__46307__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__46317 = (function (coll__4469__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__46317(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46309,other46310){
var self__ = this;
var this46309__$1 = this;
return (((!((other46310 == null)))) && ((((this46309__$1.constructor === other46310.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46309__$1.index_type,other46310.index_type)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46309__$1.comparator,other46310.comparator)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46309__$1.historyComparator,other46310.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46309__$1.__extmap,other46310.__extmap)))))))))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k46308){
var self__ = this;
var this__4479__auto____$1 = this;
var G__46318 = k46308;
var G__46318__$1 = (((G__46318 instanceof cljs.core.Keyword))?G__46318.fqn:null);
switch (G__46318__$1) {
case "index-type":
case "comparator":
case "historyComparator":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k46308);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__46307){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__46319 = cljs.core.keyword_identical_QMARK_;
var expr__46320 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__46322 = cljs.core.cst$kw$index_DASH_type;
var G__46323 = expr__46320;
return (pred__46319.cljs$core$IFn$_invoke$arity$2 ? pred__46319.cljs$core$IFn$_invoke$arity$2(G__46322,G__46323) : pred__46319.call(null,G__46322,G__46323));
})())){
return (new fluree.db.index.IndexConfig(G__46307,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46324 = cljs.core.cst$kw$comparator;
var G__46325 = expr__46320;
return (pred__46319.cljs$core$IFn$_invoke$arity$2 ? pred__46319.cljs$core$IFn$_invoke$arity$2(G__46324,G__46325) : pred__46319.call(null,G__46324,G__46325));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__46307,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46326 = cljs.core.cst$kw$historyComparator;
var G__46327 = expr__46320;
return (pred__46319.cljs$core$IFn$_invoke$arity$2 ? pred__46319.cljs$core$IFn$_invoke$arity$2(G__46326,G__46327) : pred__46319.call(null,G__46326,G__46327));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__46307,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__46307),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__46307){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__46307,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__46311){
var extmap__4512__auto__ = (function (){var G__46328 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46311,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__46311)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46328);
} else {
return G__46328;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__46311),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__46311),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__46311),null,cljs.core.not_empty(extmap__4512__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k46332,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__46336 = k46332;
var G__46336__$1 = (((G__46336 instanceof cljs.core.Keyword))?G__46336.fqn:null);
switch (G__46336__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46332,else__4475__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__46337){
var vec__46338 = p__46337;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46338,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46338,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46331){
var self__ = this;
var G__46331__$1 = this;
return (new cljs.core.RecordIter((0),G__46331__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46342){
var state_val_46343 = (state_46342[(1)]);
if((state_val_46343 === (1))){
var state_46342__$1 = state_46342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46342__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__20477__auto__ = null;
var fluree$db$index$state_machine__20477__auto____0 = (function (){
var statearr_46344 = [null,null,null,null,null,null,null];
(statearr_46344[(0)] = fluree$db$index$state_machine__20477__auto__);

(statearr_46344[(1)] = (1));

return statearr_46344;
});
var fluree$db$index$state_machine__20477__auto____1 = (function (state_46342){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46342);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46345){var ex__20480__auto__ = e46345;
var statearr_46346_46458 = state_46342;
(statearr_46346_46458[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46342[(4)]))){
var statearr_46347_46459 = state_46342;
(statearr_46347_46459[(1)] = cljs.core.first((state_46342[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46460 = state_46342;
state_46342 = G__46460;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$index$state_machine__20477__auto__ = function(state_46342){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__20477__auto____1.call(this,state_46342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__20477__auto____0;
fluree$db$index$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__20477__auto____1;
return fluree$db$index$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46348 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46348[(6)] = c__20603__auto__);

return statearr_46348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__4223__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__4223__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46373){
var state_val_46374 = (state_46373[(1)]);
if((state_val_46374 === (7))){
var inst_46355 = (state_46373[(7)]);
var inst_46359 = fluree.db.dbproto._resolve(inst_46355);
var state_46373__$1 = state_46373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46373__$1,(10),inst_46359);
} else {
if((state_val_46374 === (1))){
var state_46373__$1 = state_46373;
var statearr_46375_46461 = state_46373__$1;
(statearr_46375_46461[(2)] = null);

(statearr_46375_46461[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46374 === (4))){
var inst_46349 = (state_46373[(2)]);
var state_46373__$1 = state_46373;
var statearr_46376_46462 = state_46373__$1;
(statearr_46376_46462[(2)] = inst_46349);

(statearr_46376_46462[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46374 === (6))){
var inst_46355 = (state_46373[(7)]);
var state_46373__$1 = state_46373;
var statearr_46377_46463 = state_46373__$1;
(statearr_46377_46463[(2)] = inst_46355);

(statearr_46377_46463[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46374 === (3))){
var inst_46371 = (state_46373[(2)]);
var state_46373__$1 = state_46373;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46373__$1,inst_46371);
} else {
if((state_val_46374 === (2))){
var inst_46355 = (state_46373[(7)]);
var _ = (function (){var statearr_46379 = state_46373;
(statearr_46379[(4)] = cljs.core.cons((5),(state_46373[(4)])));

return statearr_46379;
})();
var inst_46355__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_46356 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_46355__$1);
var state_46373__$1 = (function (){var statearr_46380 = state_46373;
(statearr_46380[(7)] = inst_46355__$1);

return statearr_46380;
})();
if(cljs.core.truth_(inst_46356)){
var statearr_46381_46464 = state_46373__$1;
(statearr_46381_46464[(1)] = (6));

} else {
var statearr_46382_46465 = state_46373__$1;
(statearr_46382_46465[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46374 === (9))){
var inst_46365 = (state_46373[(2)]);
var inst_46366 = fluree.db.util.async.throw_err(inst_46365);
var state_46373__$1 = state_46373;
var statearr_46383_46466 = state_46373__$1;
(statearr_46383_46466[(2)] = inst_46366);

(statearr_46383_46466[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46374 === (5))){
var _ = (function (){var statearr_46384 = state_46373;
(statearr_46384[(4)] = cljs.core.rest((state_46373[(4)])));

return statearr_46384;
})();
var state_46373__$1 = state_46373;
var ex46378 = (state_46373__$1[(2)]);
var statearr_46385_46467 = state_46373__$1;
(statearr_46385_46467[(5)] = ex46378);


if((ex46378 instanceof Error)){
var statearr_46386_46468 = state_46373__$1;
(statearr_46386_46468[(1)] = (4));

(statearr_46386_46468[(5)] = null);

} else {
throw ex46378;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46374 === (10))){
var inst_46361 = (state_46373[(2)]);
var inst_46362 = fluree.db.util.async.throw_err(inst_46361);
var inst_46363 = fluree.db.dbproto._lookup_leaf(inst_46362,flake);
var state_46373__$1 = state_46373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46373__$1,(9),inst_46363);
} else {
if((state_val_46374 === (8))){
var inst_46368 = (state_46373[(2)]);
var _ = (function (){var statearr_46387 = state_46373;
(statearr_46387[(4)] = cljs.core.rest((state_46373[(4)])));

return statearr_46387;
})();
var state_46373__$1 = state_46373;
var statearr_46388_46469 = state_46373__$1;
(statearr_46388_46469[(2)] = inst_46368);

(statearr_46388_46469[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__20477__auto__ = null;
var fluree$db$index$state_machine__20477__auto____0 = (function (){
var statearr_46389 = [null,null,null,null,null,null,null,null];
(statearr_46389[(0)] = fluree$db$index$state_machine__20477__auto__);

(statearr_46389[(1)] = (1));

return statearr_46389;
});
var fluree$db$index$state_machine__20477__auto____1 = (function (state_46373){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46373);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46390){var ex__20480__auto__ = e46390;
var statearr_46391_46470 = state_46373;
(statearr_46391_46470[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46373[(4)]))){
var statearr_46392_46471 = state_46373;
(statearr_46392_46471[(1)] = cljs.core.first((state_46373[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46472 = state_46373;
state_46373 = G__46472;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$index$state_machine__20477__auto__ = function(state_46373){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__20477__auto____1.call(this,state_46373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__20477__auto____0;
fluree$db$index$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__20477__auto____1;
return fluree$db$index$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46393 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46393[(6)] = c__20603__auto__);

return statearr_46393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46418){
var state_val_46419 = (state_46418[(1)]);
if((state_val_46419 === (7))){
var inst_46400 = (state_46418[(7)]);
var inst_46404 = fluree.db.dbproto._resolve(inst_46400);
var state_46418__$1 = state_46418;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46418__$1,(10),inst_46404);
} else {
if((state_val_46419 === (1))){
var state_46418__$1 = state_46418;
var statearr_46420_46473 = state_46418__$1;
(statearr_46420_46473[(2)] = null);

(statearr_46420_46473[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46419 === (4))){
var inst_46394 = (state_46418[(2)]);
var state_46418__$1 = state_46418;
var statearr_46421_46474 = state_46418__$1;
(statearr_46421_46474[(2)] = inst_46394);

(statearr_46421_46474[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46419 === (6))){
var inst_46400 = (state_46418[(7)]);
var state_46418__$1 = state_46418;
var statearr_46422_46475 = state_46418__$1;
(statearr_46422_46475[(2)] = inst_46400);

(statearr_46422_46475[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46419 === (3))){
var inst_46416 = (state_46418[(2)]);
var state_46418__$1 = state_46418;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46418__$1,inst_46416);
} else {
if((state_val_46419 === (2))){
var inst_46400 = (state_46418[(7)]);
var _ = (function (){var statearr_46424 = state_46418;
(statearr_46424[(4)] = cljs.core.cons((5),(state_46418[(4)])));

return statearr_46424;
})();
var inst_46400__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_46401 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_46400__$1);
var state_46418__$1 = (function (){var statearr_46425 = state_46418;
(statearr_46425[(7)] = inst_46400__$1);

return statearr_46425;
})();
if(cljs.core.truth_(inst_46401)){
var statearr_46426_46476 = state_46418__$1;
(statearr_46426_46476[(1)] = (6));

} else {
var statearr_46427_46477 = state_46418__$1;
(statearr_46427_46477[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46419 === (9))){
var inst_46410 = (state_46418[(2)]);
var inst_46411 = fluree.db.util.async.throw_err(inst_46410);
var state_46418__$1 = state_46418;
var statearr_46428_46478 = state_46418__$1;
(statearr_46428_46478[(2)] = inst_46411);

(statearr_46428_46478[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46419 === (5))){
var _ = (function (){var statearr_46429 = state_46418;
(statearr_46429[(4)] = cljs.core.rest((state_46418[(4)])));

return statearr_46429;
})();
var state_46418__$1 = state_46418;
var ex46423 = (state_46418__$1[(2)]);
var statearr_46430_46479 = state_46418__$1;
(statearr_46430_46479[(5)] = ex46423);


if((ex46423 instanceof Error)){
var statearr_46431_46480 = state_46418__$1;
(statearr_46431_46480[(1)] = (4));

(statearr_46431_46480[(5)] = null);

} else {
throw ex46423;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46419 === (10))){
var inst_46406 = (state_46418[(2)]);
var inst_46407 = fluree.db.util.async.throw_err(inst_46406);
var inst_46408 = fluree.db.dbproto._lookup_leaf_after(inst_46407,flake);
var state_46418__$1 = state_46418;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46418__$1,(9),inst_46408);
} else {
if((state_val_46419 === (8))){
var inst_46413 = (state_46418[(2)]);
var _ = (function (){var statearr_46432 = state_46418;
(statearr_46432[(4)] = cljs.core.rest((state_46418[(4)])));

return statearr_46432;
})();
var state_46418__$1 = state_46418;
var statearr_46433_46481 = state_46418__$1;
(statearr_46433_46481[(2)] = inst_46413);

(statearr_46433_46481[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__20477__auto__ = null;
var fluree$db$index$state_machine__20477__auto____0 = (function (){
var statearr_46434 = [null,null,null,null,null,null,null,null];
(statearr_46434[(0)] = fluree$db$index$state_machine__20477__auto__);

(statearr_46434[(1)] = (1));

return statearr_46434;
});
var fluree$db$index$state_machine__20477__auto____1 = (function (state_46418){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46418);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46435){var ex__20480__auto__ = e46435;
var statearr_46436_46482 = state_46418;
(statearr_46436_46482[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46418[(4)]))){
var statearr_46437_46483 = state_46418;
(statearr_46437_46483[(1)] = cljs.core.first((state_46418[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46484 = state_46418;
state_46418 = G__46484;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$index$state_machine__20477__auto__ = function(state_46418){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__20477__auto____1.call(this,state_46418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__20477__auto____0;
fluree$db$index$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__20477__auto____1;
return fluree$db$index$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46438 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46438[(6)] = c__20603__auto__);

return statearr_46438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__46439 = (function (coll__4469__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__46439(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46333,other46334){
var self__ = this;
var this46333__$1 = this;
return (((!((other46334 == null)))) && ((((this46333__$1.constructor === other46334.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46333__$1.block,other46334.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46333__$1.t,other46334.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46333__$1.rhs,other46334.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46333__$1.children,other46334.children)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46333__$1.config,other46334.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46333__$1.leftmost_QMARK_,other46334.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46333__$1.__extmap,other46334.__extmap)))))))))))))))));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k46332){
var self__ = this;
var this__4479__auto____$1 = this;
var G__46440 = k46332;
var G__46440__$1 = (((G__46440 instanceof cljs.core.Keyword))?G__46440.fqn:null);
switch (G__46440__$1) {
case "block":
case "t":
case "rhs":
case "children":
case "config":
case "leftmost?":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k46332);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__46331){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__46441 = cljs.core.keyword_identical_QMARK_;
var expr__46442 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__46444 = cljs.core.cst$kw$block;
var G__46445 = expr__46442;
return (pred__46441.cljs$core$IFn$_invoke$arity$2 ? pred__46441.cljs$core$IFn$_invoke$arity$2(G__46444,G__46445) : pred__46441.call(null,G__46444,G__46445));
})())){
return (new fluree.db.index.IndexNode(G__46331,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46446 = cljs.core.cst$kw$t;
var G__46447 = expr__46442;
return (pred__46441.cljs$core$IFn$_invoke$arity$2 ? pred__46441.cljs$core$IFn$_invoke$arity$2(G__46446,G__46447) : pred__46441.call(null,G__46446,G__46447));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__46331,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46448 = cljs.core.cst$kw$rhs;
var G__46449 = expr__46442;
return (pred__46441.cljs$core$IFn$_invoke$arity$2 ? pred__46441.cljs$core$IFn$_invoke$arity$2(G__46448,G__46449) : pred__46441.call(null,G__46448,G__46449));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__46331,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46450 = cljs.core.cst$kw$children;
var G__46451 = expr__46442;
return (pred__46441.cljs$core$IFn$_invoke$arity$2 ? pred__46441.cljs$core$IFn$_invoke$arity$2(G__46450,G__46451) : pred__46441.call(null,G__46450,G__46451));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__46331,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46452 = cljs.core.cst$kw$config;
var G__46453 = expr__46442;
return (pred__46441.cljs$core$IFn$_invoke$arity$2 ? pred__46441.cljs$core$IFn$_invoke$arity$2(G__46452,G__46453) : pred__46441.call(null,G__46452,G__46453));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__46331,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46454 = cljs.core.cst$kw$leftmost_QMARK_;
var G__46455 = expr__46442;
return (pred__46441.cljs$core$IFn$_invoke$arity$2 ? pred__46441.cljs$core$IFn$_invoke$arity$2(G__46454,G__46455) : pred__46441.call(null,G__46454,G__46455));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__46331,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__46331),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__46331){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__46331,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__46335){
var extmap__4512__auto__ = (function (){var G__46456 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46335,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__46335)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46456);
} else {
return G__46456;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__46335),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__46335),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__46335),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__46335),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__46335),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__46335),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k46487,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__46491 = k46487;
var G__46491__$1 = (((G__46491 instanceof cljs.core.Keyword))?G__46491.fqn:null);
switch (G__46491__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46487,else__4475__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__46492){
var vec__46493 = p__46492;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46493,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46493,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46486){
var self__ = this;
var G__46486__$1 = this;
return (new cljs.core.RecordIter((0),G__46486__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46497){
var state_val_46498 = (state_46497[(1)]);
if((state_val_46498 === (1))){
var state_46497__$1 = state_46497;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46497__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__20477__auto__ = null;
var fluree$db$index$state_machine__20477__auto____0 = (function (){
var statearr_46499 = [null,null,null,null,null,null,null];
(statearr_46499[(0)] = fluree$db$index$state_machine__20477__auto__);

(statearr_46499[(1)] = (1));

return statearr_46499;
});
var fluree$db$index$state_machine__20477__auto____1 = (function (state_46497){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46497);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46500){var ex__20480__auto__ = e46500;
var statearr_46501_46533 = state_46497;
(statearr_46501_46533[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46497[(4)]))){
var statearr_46502_46534 = state_46497;
(statearr_46502_46534[(1)] = cljs.core.first((state_46497[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46535 = state_46497;
state_46497 = G__46535;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$index$state_machine__20477__auto__ = function(state_46497){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__20477__auto____1.call(this,state_46497);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__20477__auto____0;
fluree$db$index$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__20477__auto____1;
return fluree$db$index$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46503 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46503[(6)] = c__20603__auto__);

return statearr_46503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46509){
var state_val_46510 = (state_46509[(1)]);
if((state_val_46510 === (1))){
var inst_46504 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_46505 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_46506 = cljs.core.PersistentHashMap.fromArrays(inst_46504,inst_46505);
var inst_46507 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_46506);
var state_46509__$1 = state_46509;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46509__$1,inst_46507);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__20477__auto__ = null;
var fluree$db$index$state_machine__20477__auto____0 = (function (){
var statearr_46511 = [null,null,null,null,null,null,null];
(statearr_46511[(0)] = fluree$db$index$state_machine__20477__auto__);

(statearr_46511[(1)] = (1));

return statearr_46511;
});
var fluree$db$index$state_machine__20477__auto____1 = (function (state_46509){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46509);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46512){var ex__20480__auto__ = e46512;
var statearr_46513_46536 = state_46509;
(statearr_46513_46536[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46509[(4)]))){
var statearr_46514_46537 = state_46509;
(statearr_46514_46537[(1)] = cljs.core.first((state_46509[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46538 = state_46509;
state_46509 = G__46538;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$index$state_machine__20477__auto__ = function(state_46509){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__20477__auto____1.call(this,state_46509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__20477__auto____0;
fluree$db$index$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__20477__auto____1;
return fluree$db$index$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46515 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46515[(6)] = c__20603__auto__);

return statearr_46515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__46516 = (function (coll__4469__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__46516(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46488,other46489){
var self__ = this;
var this46488__$1 = this;
return (((!((other46489 == null)))) && ((((this46488__$1.constructor === other46489.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46488__$1.block,other46489.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46488__$1.t,other46489.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46488__$1.flakes,other46489.flakes)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46488__$1.rhs,other46489.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46488__$1.config,other46489.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46488__$1.__extmap,other46489.__extmap)))))))))))))));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k46487){
var self__ = this;
var this__4479__auto____$1 = this;
var G__46517 = k46487;
var G__46517__$1 = (((G__46517 instanceof cljs.core.Keyword))?G__46517.fqn:null);
switch (G__46517__$1) {
case "block":
case "t":
case "flakes":
case "rhs":
case "config":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k46487);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__46486){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__46518 = cljs.core.keyword_identical_QMARK_;
var expr__46519 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__46521 = cljs.core.cst$kw$block;
var G__46522 = expr__46519;
return (pred__46518.cljs$core$IFn$_invoke$arity$2 ? pred__46518.cljs$core$IFn$_invoke$arity$2(G__46521,G__46522) : pred__46518.call(null,G__46521,G__46522));
})())){
return (new fluree.db.index.DataNode(G__46486,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46523 = cljs.core.cst$kw$t;
var G__46524 = expr__46519;
return (pred__46518.cljs$core$IFn$_invoke$arity$2 ? pred__46518.cljs$core$IFn$_invoke$arity$2(G__46523,G__46524) : pred__46518.call(null,G__46523,G__46524));
})())){
return (new fluree.db.index.DataNode(self__.block,G__46486,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46525 = cljs.core.cst$kw$flakes;
var G__46526 = expr__46519;
return (pred__46518.cljs$core$IFn$_invoke$arity$2 ? pred__46518.cljs$core$IFn$_invoke$arity$2(G__46525,G__46526) : pred__46518.call(null,G__46525,G__46526));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__46486,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46527 = cljs.core.cst$kw$rhs;
var G__46528 = expr__46519;
return (pred__46518.cljs$core$IFn$_invoke$arity$2 ? pred__46518.cljs$core$IFn$_invoke$arity$2(G__46527,G__46528) : pred__46518.call(null,G__46527,G__46528));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__46486,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46529 = cljs.core.cst$kw$config;
var G__46530 = expr__46519;
return (pred__46518.cljs$core$IFn$_invoke$arity$2 ? pred__46518.cljs$core$IFn$_invoke$arity$2(G__46529,G__46530) : pred__46518.call(null,G__46529,G__46530));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__46486,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__46486),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__46486){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__46486,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__46490){
var extmap__4512__auto__ = (function (){var G__46531 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46490,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__46490)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46531);
} else {
return G__46531;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__46490),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__46490),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__46490),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__46490),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__46490),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
