// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e39182){var e = e39182;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__39183_SHARP_){
var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__39183_SHARP_);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__39183_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__39183_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__39183_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__39184_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__39184_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__39185_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__39185_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4221__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4223__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__39190 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39190,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39190,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__39186_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__39186_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4221__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4221__auto__;
}
})())){
var vec__39193 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39193,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39193,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4223__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__39187_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__39187_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__39188_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__39188_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__39189_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__39189_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39196_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__39196_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (add_amount > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fuel;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4221__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__39197 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__39197) : intersecting_vars.call(null,G__39197));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__39200,optional_QMARK_,fuel,max_fuel){
var map__39201 = p__39200;
var map__39201__$1 = cljs.core.__destructure_map(map__39201);
var res = map__39201__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39201__$1,cljs.core.cst$kw$vars);
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_39267){
var state_val_39268 = (state_39267[(1)]);
if((state_val_39268 === (7))){
var inst_39256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39257 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_39258 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39257,clause);
var inst_39259 = [null,inst_39258];
var inst_39260 = (new cljs.core.PersistentVector(null,2,(5),inst_39256,inst_39259,null));
var state_39267__$1 = state_39267;
var statearr_39269_39297 = state_39267__$1;
(statearr_39269_39297[(2)] = inst_39260);

(statearr_39269_39297[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39268 === (1))){
var state_39267__$1 = state_39267;
var statearr_39270_39298 = state_39267__$1;
(statearr_39270_39298[(2)] = null);

(statearr_39270_39298[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39268 === (4))){
var inst_39202 = (state_39267[(2)]);
var state_39267__$1 = state_39267;
var statearr_39271_39299 = state_39267__$1;
(statearr_39271_39299[(2)] = inst_39202);

(statearr_39271_39299[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39268 === (15))){
var inst_39245 = (state_39267[(2)]);
var inst_39246 = fluree.db.util.async.throw_err(inst_39245);
var inst_39247 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_39246);
var inst_39248 = cljs.core.count(inst_39247);
var inst_39249 = fluree.db.query.analytical.add_fuel(inst_39248,fuel,max_fuel);
var inst_39250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39251 = [inst_39246,r];
var inst_39252 = (new cljs.core.PersistentVector(null,2,(5),inst_39250,inst_39251,null));
var state_39267__$1 = (function (){var statearr_39272 = state_39267;
(statearr_39272[(7)] = inst_39249);

return statearr_39272;
})();
var statearr_39273_39300 = state_39267__$1;
(statearr_39273_39300[(2)] = inst_39252);

(statearr_39273_39300[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39268 === (13))){
var inst_39211 = (state_39267[(8)]);
var inst_39224 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_39225 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_39224);
var inst_39226 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_39211);
var inst_39227 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_39226);
var inst_39228 = cljs.core.set(inst_39227);
var inst_39229 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_39225);
var inst_39230 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_39229);
var inst_39231 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39228,inst_39230);
var inst_39232 = (function (){var all_wd = inst_39211;
var optional = inst_39225;
var all_wd_vars = inst_39228;
var all_vars = inst_39231;
return (function (p1__39198_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__39198_SHARP_) : all_vars.call(null,p1__39198_SHARP_));
});
})();
var inst_39233 = cljs.core.keys(vars);
var inst_39234 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39232,inst_39233);
var inst_39235 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_39234);
var inst_39236 = cljs.core.set(inst_39235);
var inst_39237 = (function (){var all_wd = inst_39211;
var optional = inst_39225;
var all_wd_vars = inst_39228;
var all_vars = inst_39231;
var intersecting_vars = inst_39236;
return (function (p1__39199_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__39199_SHARP_);
});
})();
var inst_39238 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39237,inst_39211);
var inst_39239 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_39238);
var inst_39240 = fluree.db.query.analytical.select_from_tuples(inst_39239,res);
var inst_39241 = fluree.db.query.analytical.replace_vars_wikidata(inst_39211,inst_39236,vars);
var inst_39242 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_39236,inst_39231);
var inst_39243 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_39241,inst_39239,inst_39240,inst_39242,inst_39225);
var state_39267__$1 = state_39267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39267__$1,(15),inst_39243);
} else {
if((state_val_39268 === (6))){
var inst_39212 = (state_39267[(9)]);
var inst_39210 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_39211 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_39210);
var inst_39212__$1 = optional_QMARK_;
var state_39267__$1 = (function (){var statearr_39274 = state_39267;
(statearr_39274[(9)] = inst_39212__$1);

(statearr_39274[(8)] = inst_39211);

return statearr_39274;
})();
if(cljs.core.truth_(inst_39212__$1)){
var statearr_39275_39301 = state_39267__$1;
(statearr_39275_39301[(1)] = (9));

} else {
var statearr_39276_39302 = state_39267__$1;
(statearr_39276_39302[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39268 === (3))){
var inst_39265 = (state_39267[(2)]);
var state_39267__$1 = state_39267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39267__$1,inst_39265);
} else {
if((state_val_39268 === (12))){
var inst_39220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39221 = [null,r];
var inst_39222 = (new cljs.core.PersistentVector(null,2,(5),inst_39220,inst_39221,null));
var state_39267__$1 = state_39267;
var statearr_39277_39303 = state_39267__$1;
(statearr_39277_39303[(2)] = inst_39222);

(statearr_39277_39303[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39268 === (2))){
var _ = (function (){var statearr_39278 = state_39267;
(statearr_39278[(4)] = cljs.core.cons((5),(state_39267[(4)])));

return statearr_39278;
})();
var inst_39208 = (r == null);
var state_39267__$1 = state_39267;
if(cljs.core.truth_(inst_39208)){
var statearr_39279_39304 = state_39267__$1;
(statearr_39279_39304[(1)] = (6));

} else {
var statearr_39280_39305 = state_39267__$1;
(statearr_39280_39305[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39268 === (11))){
var inst_39218 = (state_39267[(2)]);
var state_39267__$1 = state_39267;
if(cljs.core.truth_(inst_39218)){
var statearr_39282_39306 = state_39267__$1;
(statearr_39282_39306[(1)] = (12));

} else {
var statearr_39283_39307 = state_39267__$1;
(statearr_39283_39307[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39268 === (9))){
var inst_39211 = (state_39267[(8)]);
var inst_39214 = cljs.core.empty_QMARK_(inst_39211);
var inst_39215 = (!(inst_39214));
var state_39267__$1 = state_39267;
var statearr_39284_39308 = state_39267__$1;
(statearr_39284_39308[(2)] = inst_39215);

(statearr_39284_39308[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39268 === (5))){
var _ = (function (){var statearr_39285 = state_39267;
(statearr_39285[(4)] = cljs.core.rest((state_39267[(4)])));

return statearr_39285;
})();
var state_39267__$1 = state_39267;
var ex39281 = (state_39267__$1[(2)]);
var statearr_39286_39309 = state_39267__$1;
(statearr_39286_39309[(5)] = ex39281);


if((ex39281 instanceof Error)){
var statearr_39287_39310 = state_39267__$1;
(statearr_39287_39310[(1)] = (4));

(statearr_39287_39310[(5)] = null);

} else {
throw ex39281;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39268 === (14))){
var inst_39254 = (state_39267[(2)]);
var state_39267__$1 = state_39267;
var statearr_39288_39311 = state_39267__$1;
(statearr_39288_39311[(2)] = inst_39254);

(statearr_39288_39311[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39268 === (10))){
var inst_39212 = (state_39267[(9)]);
var state_39267__$1 = state_39267;
var statearr_39289_39312 = state_39267__$1;
(statearr_39289_39312[(2)] = inst_39212);

(statearr_39289_39312[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39268 === (8))){
var inst_39262 = (state_39267[(2)]);
var _ = (function (){var statearr_39290 = state_39267;
(statearr_39290[(4)] = cljs.core.rest((state_39267[(4)])));

return statearr_39290;
})();
var state_39267__$1 = state_39267;
var statearr_39291_39313 = state_39267__$1;
(statearr_39291_39313[(2)] = inst_39262);

(statearr_39291_39313[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__20477__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__20477__auto____0 = (function (){
var statearr_39292 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39292[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__20477__auto__);

(statearr_39292[(1)] = (1));

return statearr_39292;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__20477__auto____1 = (function (state_39267){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_39267);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e39293){var ex__20480__auto__ = e39293;
var statearr_39294_39314 = state_39267;
(statearr_39294_39314[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_39267[(4)]))){
var statearr_39295_39315 = state_39267;
(statearr_39295_39315[(1)] = cljs.core.first((state_39267[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__39316 = state_39267;
state_39267 = G__39316;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__20477__auto__ = function(state_39267){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__20477__auto____1.call(this,state_39267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__20477__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__20477__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_39296 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_39296[(6)] = c__20603__auto__);

return statearr_39296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__39318 = arguments.length;
switch (G__39318) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_39412){
var state_val_39413 = (state_39412[(1)]);
if((state_val_39413 === (7))){
var inst_39325 = (state_39412[(7)]);
var inst_39335 = clojure.string.starts_with_QMARK_(inst_39325,"$fdb");
var state_39412__$1 = state_39412;
if(inst_39335){
var statearr_39414_39463 = state_39412__$1;
(statearr_39414_39463[(1)] = (9));

} else {
var statearr_39415_39464 = state_39412__$1;
(statearr_39415_39464[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (20))){
var state_39412__$1 = state_39412;
var statearr_39416_39465 = state_39412__$1;
(statearr_39416_39465[(2)] = null);

(statearr_39416_39465[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (27))){
var inst_39375 = (state_39412[(8)]);
var state_39412__$1 = state_39412;
var statearr_39417_39466 = state_39412__$1;
(statearr_39417_39466[(2)] = inst_39375);

(statearr_39417_39466[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (1))){
var state_39412__$1 = state_39412;
var statearr_39418_39467 = state_39412__$1;
(statearr_39418_39467[(2)] = null);

(statearr_39418_39467[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (24))){
var inst_39398 = (state_39412[(2)]);
var state_39412__$1 = state_39412;
var statearr_39419_39468 = state_39412__$1;
(statearr_39419_39468[(2)] = inst_39398);

(statearr_39419_39468[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (4))){
var inst_39319 = (state_39412[(2)]);
var state_39412__$1 = state_39412;
var statearr_39420_39469 = state_39412__$1;
(statearr_39420_39469[(2)] = inst_39319);

(statearr_39420_39469[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (15))){
var inst_39342 = (state_39412[(9)]);
var inst_39348 = (state_39412[(2)]);
var inst_39349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39350 = cljs.core.PersistentVector.EMPTY;
var inst_39351 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_39352 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39350,inst_39351);
var inst_39353 = [inst_39342,inst_39352];
var inst_39354 = (new cljs.core.PersistentVector(null,2,(5),inst_39349,inst_39353,null));
var state_39412__$1 = (function (){var statearr_39421 = state_39412;
(statearr_39421[(10)] = inst_39348);

return statearr_39421;
})();
var statearr_39422_39470 = state_39412__$1;
(statearr_39422_39470[(2)] = inst_39354);

(statearr_39422_39470[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (21))){
var inst_39401 = (state_39412[(2)]);
var state_39412__$1 = state_39412;
var statearr_39423_39471 = state_39412__$1;
(statearr_39423_39471[(2)] = inst_39401);

(statearr_39423_39471[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (13))){
var inst_39342 = (state_39412[(9)]);
var inst_39345 = (function(){throw inst_39342})();
var state_39412__$1 = state_39412;
var statearr_39424_39472 = state_39412__$1;
(statearr_39424_39472[(2)] = inst_39345);

(statearr_39424_39472[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (22))){
var inst_39364 = (state_39412[(11)]);
var inst_39366 = (state_39412[(12)]);
var inst_39368 = fluree.db.query.analytical.parse_block_from_source(inst_39364);
var inst_39369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39370 = [cljs.core.cst$kw$sources,inst_39366];
var inst_39371 = (new cljs.core.PersistentVector(null,2,(5),inst_39369,inst_39370,null));
var inst_39372 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_39371);
var state_39412__$1 = (function (){var statearr_39425 = state_39412;
(statearr_39425[(13)] = inst_39368);

return statearr_39425;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39412__$1,(25),inst_39372);
} else {
if((state_val_39413 === (29))){
var inst_39379 = (state_39412[(2)]);
var inst_39380 = fluree.db.util.async.throw_err(inst_39379);
var state_39412__$1 = state_39412;
var statearr_39426_39473 = state_39412__$1;
(statearr_39426_39473[(2)] = inst_39380);

(statearr_39426_39473[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (6))){
var inst_39328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39329 = cljs.core.PersistentVector.EMPTY;
var inst_39330 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_39331 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39329,inst_39330);
var inst_39332 = [db,inst_39331];
var inst_39333 = (new cljs.core.PersistentVector(null,2,(5),inst_39328,inst_39332,null));
var state_39412__$1 = state_39412;
var statearr_39427_39474 = state_39412__$1;
(statearr_39427_39474[(2)] = inst_39333);

(statearr_39427_39474[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (28))){
var inst_39383 = (state_39412[(2)]);
var inst_39384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39385 = cljs.core.PersistentVector.EMPTY;
var inst_39386 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_39387 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39385,inst_39386);
var inst_39388 = [inst_39383,inst_39387];
var inst_39389 = (new cljs.core.PersistentVector(null,2,(5),inst_39384,inst_39388,null));
var state_39412__$1 = state_39412;
var statearr_39428_39475 = state_39412__$1;
(statearr_39428_39475[(2)] = inst_39389);

(statearr_39428_39475[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (25))){
var inst_39368 = (state_39412[(13)]);
var inst_39374 = (state_39412[(2)]);
var inst_39375 = fluree.db.util.async.throw_err(inst_39374);
var state_39412__$1 = (function (){var statearr_39429 = state_39412;
(statearr_39429[(8)] = inst_39375);

return statearr_39429;
})();
if(cljs.core.truth_(inst_39368)){
var statearr_39430_39476 = state_39412__$1;
(statearr_39430_39476[(1)] = (26));

} else {
var statearr_39431_39477 = state_39412__$1;
(statearr_39431_39477[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (17))){
var state_39412__$1 = state_39412;
var statearr_39432_39478 = state_39412__$1;
(statearr_39432_39478[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (3))){
var inst_39410 = (state_39412[(2)]);
var state_39412__$1 = state_39412;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39412__$1,inst_39410);
} else {
if((state_val_39413 === (12))){
var inst_39342 = (state_39412[(9)]);
var inst_39341 = (state_39412[(2)]);
var inst_39342__$1 = fluree.db.util.async.throw_err(inst_39341);
var inst_39343 = fluree.db.util.core.exception_QMARK_(inst_39342__$1);
var state_39412__$1 = (function (){var statearr_39434 = state_39412;
(statearr_39434[(9)] = inst_39342__$1);

return statearr_39434;
})();
if(inst_39343){
var statearr_39435_39479 = state_39412__$1;
(statearr_39435_39479[(1)] = (13));

} else {
var statearr_39436_39480 = state_39412__$1;
(statearr_39436_39480[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (2))){
var inst_39325 = (state_39412[(7)]);
var _ = (function (){var statearr_39437 = state_39412;
(statearr_39437[(4)] = cljs.core.cons((5),(state_39412[(4)])));

return statearr_39437;
})();
var inst_39325__$1 = cljs.core.first(clause);
var inst_39326 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_39325__$1);
var state_39412__$1 = (function (){var statearr_39438 = state_39412;
(statearr_39438[(7)] = inst_39325__$1);

return statearr_39438;
})();
if(inst_39326){
var statearr_39439_39481 = state_39412__$1;
(statearr_39439_39481[(1)] = (6));

} else {
var statearr_39440_39482 = state_39412__$1;
(statearr_39440_39482[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (23))){
var inst_39325 = (state_39412[(7)]);
var inst_39391 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39325)," is not supported in Fluree"].join('');
var inst_39392 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39393 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_39394 = cljs.core.PersistentHashMap.fromArrays(inst_39392,inst_39393);
var inst_39395 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39391,inst_39394);
var inst_39396 = (function(){throw inst_39395})();
var state_39412__$1 = state_39412;
var statearr_39441_39483 = state_39412__$1;
(statearr_39441_39483[(2)] = inst_39396);

(statearr_39441_39483[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (19))){
var inst_39366 = (state_39412[(12)]);
var inst_39325 = (state_39412[(7)]);
var inst_39363 = fluree.db.query.analytical.isolate_source_name(inst_39325);
var inst_39364 = fluree.db.query.analytical.isolate_source_block(inst_39325);
var inst_39365 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_39363);
var inst_39366__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_39365);
var state_39412__$1 = (function (){var statearr_39442 = state_39412;
(statearr_39442[(11)] = inst_39364);

(statearr_39442[(12)] = inst_39366__$1);

return statearr_39442;
})();
if(cljs.core.truth_(inst_39366__$1)){
var statearr_39443_39484 = state_39412__$1;
(statearr_39443_39484[(1)] = (22));

} else {
var statearr_39444_39485 = state_39412__$1;
(statearr_39444_39485[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (11))){
var inst_39405 = (state_39412[(2)]);
var state_39412__$1 = state_39412;
var statearr_39446_39486 = state_39412__$1;
(statearr_39446_39486[(2)] = inst_39405);

(statearr_39446_39486[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (9))){
var inst_39325 = (state_39412[(7)]);
var inst_39337 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_39325,(4));
var inst_39338 = fluree.db.query.analytical.parse_block_from_source(inst_39337);
var inst_39339 = fluree.db.time_travel.as_of_block(db,inst_39338);
var state_39412__$1 = state_39412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39412__$1,(12),inst_39339);
} else {
if((state_val_39413 === (5))){
var _ = (function (){var statearr_39447 = state_39412;
(statearr_39447[(4)] = cljs.core.rest((state_39412[(4)])));

return statearr_39447;
})();
var state_39412__$1 = state_39412;
var ex39445 = (state_39412__$1[(2)]);
var statearr_39448_39487 = state_39412__$1;
(statearr_39448_39487[(5)] = ex39445);


if((ex39445 instanceof Error)){
var statearr_39449_39488 = state_39412__$1;
(statearr_39449_39488[(1)] = (4));

(statearr_39449_39488[(5)] = null);

} else {
throw ex39445;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (14))){
var state_39412__$1 = state_39412;
var statearr_39450_39489 = state_39412__$1;
(statearr_39450_39489[(2)] = null);

(statearr_39450_39489[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (26))){
var inst_39368 = (state_39412[(13)]);
var inst_39375 = (state_39412[(8)]);
var inst_39377 = fluree.db.time_travel.as_of_block(inst_39375,inst_39368);
var state_39412__$1 = state_39412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39412__$1,(29),inst_39377);
} else {
if((state_val_39413 === (16))){
var inst_39358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39359 = ["$wd",clause];
var inst_39360 = (new cljs.core.PersistentVector(null,2,(5),inst_39358,inst_39359,null));
var state_39412__$1 = state_39412;
var statearr_39451_39490 = state_39412__$1;
(statearr_39451_39490[(2)] = inst_39360);

(statearr_39451_39490[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (10))){
var inst_39325 = (state_39412[(7)]);
var inst_39356 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_39325);
var state_39412__$1 = state_39412;
if(inst_39356){
var statearr_39452_39491 = state_39412__$1;
(statearr_39452_39491[(1)] = (16));

} else {
var statearr_39453_39492 = state_39412__$1;
(statearr_39453_39492[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (18))){
var inst_39403 = (state_39412[(2)]);
var state_39412__$1 = state_39412;
var statearr_39454_39493 = state_39412__$1;
(statearr_39454_39493[(2)] = inst_39403);

(statearr_39454_39493[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39413 === (8))){
var inst_39407 = (state_39412[(2)]);
var _ = (function (){var statearr_39455 = state_39412;
(statearr_39455[(4)] = cljs.core.rest((state_39412[(4)])));

return statearr_39455;
})();
var state_39412__$1 = state_39412;
var statearr_39456_39494 = state_39412__$1;
(statearr_39456_39494[(2)] = inst_39407);

(statearr_39456_39494[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__20477__auto__ = null;
var fluree$db$query$analytical$state_machine__20477__auto____0 = (function (){
var statearr_39457 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39457[(0)] = fluree$db$query$analytical$state_machine__20477__auto__);

(statearr_39457[(1)] = (1));

return statearr_39457;
});
var fluree$db$query$analytical$state_machine__20477__auto____1 = (function (state_39412){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_39412);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e39458){var ex__20480__auto__ = e39458;
var statearr_39459_39495 = state_39412;
(statearr_39459_39495[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_39412[(4)]))){
var statearr_39460_39496 = state_39412;
(statearr_39460_39496[(1)] = cljs.core.first((state_39412[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__39497 = state_39412;
state_39412 = G__39497;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__20477__auto__ = function(state_39412){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__20477__auto____1.call(this,state_39412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__20477__auto____0;
fluree$db$query$analytical$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__20477__auto____1;
return fluree$db$query$analytical$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_39461 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_39461[(6)] = c__20603__auto__);

return statearr_39461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__39498){
var vec__39499 = p__39498;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39499,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39499,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39502_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__39502_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__39506 = subjects;
var vec__39507 = G__39506;
var seq__39508 = cljs.core.seq(vec__39507);
var first__39509 = cljs.core.first(seq__39508);
var seq__39508__$1 = cljs.core.next(seq__39508);
var subject = first__39509;
var r = seq__39508__$1;
var acc = expanded_map;
var G__39506__$1 = G__39506;
var acc__$1 = acc;
while(true){
var vec__39513 = G__39506__$1;
var seq__39514 = cljs.core.seq(vec__39513);
var first__39515 = cljs.core.first(seq__39514);
var seq__39514__$1 = cljs.core.next(seq__39514);
var subject__$1 = first__39515;
var r__$1 = seq__39514__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__39516 = r__$1;
var G__39517 = acc__$2;
G__39506__$1 = G__39516;
acc__$1 = G__39517;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__39506__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__39513,seq__39514,first__39515,seq__39514__$1,subject__$1,r__$1,acc__$2,G__39506,vec__39507,seq__39508,first__39509,seq__39508__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4223__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__39506__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__39513,seq__39514,first__39515,seq__39514__$1,subject__$1,r__$1,acc__$2,G__39506,vec__39507,seq__39508,first__39509,seq__39508__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__39506__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__39513,seq__39514,first__39515,seq__39514__$1,subject__$1,r__$1,acc__$2,G__39506,vec__39507,seq__39508,first__39509,seq__39508__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__39506__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__39513,seq__39514,first__39515,seq__39514__$1,subject__$1,r__$1,acc__$2,G__39506,vec__39507,seq__39508,first__39509,seq__39508__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__39506__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__39513,seq__39514,first__39515,seq__39514__$1,subject__$1,r__$1,acc__$2,G__39506,vec__39507,seq__39508,first__39509,seq__39508__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__39506__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__39513,seq__39514,first__39515,seq__39514__$1,subject__$1,r__$1,acc__$2,G__39506,vec__39507,seq__39508,first__39509,seq__39508__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__39518 = r__$1;
var G__39519 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__39506__$1 = G__39518;
acc__$1 = G__39519;
continue;
} else {
var G__39520 = subjects;
var G__39521 = acc_STAR_;
G__39506__$1 = G__39520;
acc__$1 = G__39521;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39522_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__39522_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_39613){
var state_val_39614 = (state_39613[(1)]);
if((state_val_39614 === (7))){
var state_39613__$1 = state_39613;
var statearr_39615_39661 = state_39613__$1;
(statearr_39615_39661[(2)] = (100));

(statearr_39615_39661[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (20))){
var inst_39562 = (state_39613[(7)]);
var state_39613__$1 = state_39613;
var statearr_39616_39662 = state_39613__$1;
(statearr_39616_39662[(2)] = inst_39562);

(statearr_39616_39662[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (1))){
var state_39613__$1 = state_39613;
var statearr_39617_39663 = state_39613__$1;
(statearr_39617_39663[(2)] = null);

(statearr_39617_39663[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (24))){
var inst_39534 = (state_39613[(8)]);
var inst_39600 = (state_39613[(9)]);
var inst_39599 = (state_39613[(10)]);
var inst_39601 = (state_39613[(11)]);
var inst_39604 = (function (){var max_depth = inst_39534;
var recur_map__$1 = inst_39600;
var subjects = inst_39599;
var tuples = inst_39601;
return (function (p1__39523_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__39523_SHARP_)],null));
});
})();
var inst_39605 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39604,inst_39601);
var inst_39606 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_39605);
var state_39613__$1 = state_39613;
var statearr_39618_39664 = state_39613__$1;
(statearr_39618_39664[(2)] = inst_39606);

(statearr_39618_39664[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (4))){
var inst_39524 = (state_39613[(2)]);
var state_39613__$1 = state_39613;
var statearr_39619_39665 = state_39613__$1;
(statearr_39619_39665[(2)] = inst_39524);

(statearr_39619_39665[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (15))){
var inst_39547 = (state_39613[(12)]);
var inst_39558 = cljs.core.PersistentVector.EMPTY;
var inst_39559 = cljs.core.seq(inst_39547);
var inst_39560 = cljs.core.first(inst_39559);
var inst_39561 = cljs.core.next(inst_39559);
var inst_39562 = inst_39558;
var inst_39563 = inst_39547;
var state_39613__$1 = (function (){var statearr_39620 = state_39613;
(statearr_39620[(13)] = inst_39563);

(statearr_39620[(14)] = inst_39560);

(statearr_39620[(15)] = inst_39561);

(statearr_39620[(7)] = inst_39562);

return statearr_39620;
})();
var statearr_39621_39666 = state_39613__$1;
(statearr_39621_39666[(2)] = null);

(statearr_39621_39666[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (21))){
var inst_39583 = (state_39613[(2)]);
var state_39613__$1 = state_39613;
var statearr_39622_39667 = state_39613__$1;
(statearr_39622_39667[(2)] = inst_39583);

(statearr_39622_39667[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (13))){
var inst_39596 = (state_39613[(2)]);
var state_39613__$1 = state_39613;
var statearr_39623_39668 = state_39613__$1;
(statearr_39623_39668[(2)] = inst_39596);

(statearr_39623_39668[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (22))){
var inst_39570 = (state_39613[(16)]);
var inst_39562 = (state_39613[(7)]);
var inst_39577 = (state_39613[(2)]);
var inst_39578 = fluree.db.util.async.throw_err(inst_39577);
var inst_39579 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39562,inst_39578);
var inst_39562__$1 = inst_39579;
var inst_39563 = inst_39570;
var state_39613__$1 = (function (){var statearr_39624 = state_39613;
(statearr_39624[(13)] = inst_39563);

(statearr_39624[(7)] = inst_39562__$1);

return statearr_39624;
})();
var statearr_39625_39669 = state_39613__$1;
(statearr_39625_39669[(2)] = null);

(statearr_39625_39669[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (6))){
var inst_39530 = (state_39613[(17)]);
var state_39613__$1 = state_39613;
var statearr_39626_39670 = state_39613__$1;
(statearr_39626_39670[(2)] = inst_39530);

(statearr_39626_39670[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (25))){
var inst_39608 = (state_39613[(2)]);
var _ = (function (){var statearr_39627 = state_39613;
(statearr_39627[(4)] = cljs.core.rest((state_39613[(4)])));

return statearr_39627;
})();
var state_39613__$1 = state_39613;
var statearr_39628_39671 = state_39613__$1;
(statearr_39628_39671[(2)] = inst_39608);

(statearr_39628_39671[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (17))){
var inst_39563 = (state_39613[(13)]);
var inst_39569 = (state_39613[(18)]);
var inst_39568 = cljs.core.seq(inst_39563);
var inst_39569__$1 = cljs.core.first(inst_39568);
var inst_39570 = cljs.core.next(inst_39568);
var state_39613__$1 = (function (){var statearr_39629 = state_39613;
(statearr_39629[(16)] = inst_39570);

(statearr_39629[(18)] = inst_39569__$1);

return statearr_39629;
})();
if(cljs.core.truth_(inst_39569__$1)){
var statearr_39630_39672 = state_39613__$1;
(statearr_39630_39672[(1)] = (19));

} else {
var statearr_39631_39673 = state_39613__$1;
(statearr_39631_39673[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (3))){
var inst_39611 = (state_39613[(2)]);
var state_39613__$1 = state_39613;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39613__$1,inst_39611);
} else {
if((state_val_39614 === (12))){
var inst_39547 = (state_39613[(12)]);
var inst_39536 = (state_39613[(19)]);
var inst_39542 = cljs.core.vals(inst_39536);
var inst_39543 = cljs.core.flatten(inst_39542);
var inst_39544 = cljs.core.set(inst_39543);
var inst_39545 = cljs.core.keys(inst_39536);
var inst_39546 = cljs.core.set(inst_39545);
var inst_39547__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_39544,inst_39546);
var inst_39548 = cljs.core.empty_QMARK_(inst_39547__$1);
var state_39613__$1 = (function (){var statearr_39632 = state_39613;
(statearr_39632[(12)] = inst_39547__$1);

return statearr_39632;
})();
if(inst_39548){
var statearr_39633_39674 = state_39613__$1;
(statearr_39633_39674[(1)] = (14));

} else {
var statearr_39634_39675 = state_39613__$1;
(statearr_39634_39675[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (2))){
var inst_39530 = (state_39613[(17)]);
var _ = (function (){var statearr_39635 = state_39613;
(statearr_39635[(4)] = cljs.core.cons((5),(state_39613[(4)])));

return statearr_39635;
})();
var inst_39530__$1 = depth;
var state_39613__$1 = (function (){var statearr_39636 = state_39613;
(statearr_39636[(17)] = inst_39530__$1);

return statearr_39636;
})();
if(cljs.core.truth_(inst_39530__$1)){
var statearr_39637_39676 = state_39613__$1;
(statearr_39637_39676[(1)] = (6));

} else {
var statearr_39638_39677 = state_39613__$1;
(statearr_39638_39677[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (23))){
var inst_39601 = (state_39613[(11)]);
var state_39613__$1 = state_39613;
var statearr_39639_39678 = state_39613__$1;
(statearr_39639_39678[(2)] = inst_39601);

(statearr_39639_39678[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (19))){
var inst_39569 = (state_39613[(18)]);
var inst_39572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39573 = [inst_39569,predicate];
var inst_39574 = (new cljs.core.PersistentVector(null,2,(5),inst_39572,inst_39573,null));
var inst_39575 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_39574);
var state_39613__$1 = state_39613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39613__$1,(22),inst_39575);
} else {
if((state_val_39614 === (11))){
var inst_39536 = (state_39613[(19)]);
var state_39613__$1 = state_39613;
var statearr_39641_39679 = state_39613__$1;
(statearr_39641_39679[(2)] = inst_39536);

(statearr_39641_39679[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (9))){
var inst_39534 = (state_39613[(8)]);
var inst_39537 = (state_39613[(20)]);
var inst_39539 = (inst_39537 >= inst_39534);
var state_39613__$1 = state_39613;
if(cljs.core.truth_(inst_39539)){
var statearr_39642_39680 = state_39613__$1;
(statearr_39642_39680[(1)] = (11));

} else {
var statearr_39643_39681 = state_39613__$1;
(statearr_39643_39681[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (5))){
var _ = (function (){var statearr_39644 = state_39613;
(statearr_39644[(4)] = cljs.core.rest((state_39613[(4)])));

return statearr_39644;
})();
var state_39613__$1 = state_39613;
var ex39640 = (state_39613__$1[(2)]);
var statearr_39645_39682 = state_39613__$1;
(statearr_39645_39682[(5)] = ex39640);


if((ex39640 instanceof Error)){
var statearr_39646_39683 = state_39613__$1;
(statearr_39646_39683[(1)] = (4));

(statearr_39646_39683[(5)] = null);

} else {
throw ex39640;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (14))){
var inst_39536 = (state_39613[(19)]);
var state_39613__$1 = state_39613;
var statearr_39647_39684 = state_39613__$1;
(statearr_39647_39684[(2)] = inst_39536);

(statearr_39647_39684[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (16))){
var inst_39594 = (state_39613[(2)]);
var state_39613__$1 = state_39613;
var statearr_39648_39685 = state_39613__$1;
(statearr_39648_39685[(2)] = inst_39594);

(statearr_39648_39685[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (10))){
var inst_39600 = (state_39613[(9)]);
var inst_39599 = (state_39613[(10)]);
var inst_39598 = (state_39613[(2)]);
var inst_39599__$1 = cljs.core.keys(inst_39598);
var inst_39600__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_39599__$1,inst_39598);
var inst_39601 = fluree.db.query.analytical.recur_map__GT_tuples(inst_39599__$1,inst_39600__$1);
var state_39613__$1 = (function (){var statearr_39649 = state_39613;
(statearr_39649[(9)] = inst_39600__$1);

(statearr_39649[(10)] = inst_39599__$1);

(statearr_39649[(11)] = inst_39601);

return statearr_39649;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_39650_39686 = state_39613__$1;
(statearr_39650_39686[(1)] = (23));

} else {
var statearr_39651_39687 = state_39613__$1;
(statearr_39651_39687[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (18))){
var inst_39537 = (state_39613[(20)]);
var inst_39536 = (state_39613[(19)]);
var inst_39585 = (state_39613[(2)]);
var inst_39586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39587 = [(0),(2)];
var inst_39588 = (new cljs.core.PersistentVector(null,2,(5),inst_39586,inst_39587,null));
var inst_39589 = fluree.db.query.analytical.get_ns_arrays(inst_39588,inst_39585);
var inst_39590 = fluree.db.query.analytical.tuples__GT_map(inst_39536,inst_39589);
var inst_39591 = (inst_39537 + (1));
var inst_39536__$1 = inst_39590;
var inst_39537__$1 = inst_39591;
var state_39613__$1 = (function (){var statearr_39652 = state_39613;
(statearr_39652[(20)] = inst_39537__$1);

(statearr_39652[(19)] = inst_39536__$1);

return statearr_39652;
})();
var statearr_39653_39688 = state_39613__$1;
(statearr_39653_39688[(2)] = null);

(statearr_39653_39688[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39614 === (8))){
var inst_39534 = (state_39613[(2)]);
var inst_39535 = recur_map;
var inst_39536 = inst_39535;
var inst_39537 = (1);
var state_39613__$1 = (function (){var statearr_39654 = state_39613;
(statearr_39654[(8)] = inst_39534);

(statearr_39654[(20)] = inst_39537);

(statearr_39654[(19)] = inst_39536);

return statearr_39654;
})();
var statearr_39655_39689 = state_39613__$1;
(statearr_39655_39689[(2)] = null);

(statearr_39655_39689[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__20477__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__20477__auto____0 = (function (){
var statearr_39656 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39656[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__20477__auto__);

(statearr_39656[(1)] = (1));

return statearr_39656;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__20477__auto____1 = (function (state_39613){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_39613);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e39657){var ex__20480__auto__ = e39657;
var statearr_39658_39690 = state_39613;
(statearr_39658_39690[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_39613[(4)]))){
var statearr_39659_39691 = state_39613;
(statearr_39659_39691[(1)] = cljs.core.first((state_39613[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__39692 = state_39613;
state_39613 = G__39692;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__20477__auto__ = function(state_39613){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__20477__auto____1.call(this,state_39613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__20477__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__20477__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_39660 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_39660[(6)] = c__20603__auto__);

return statearr_39660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__39693,clause,fuel,max_fuel){
var map__39694 = p__39693;
var map__39694__$1 = cljs.core.__destructure_map(map__39694);
var res = map__39694__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39694__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39694__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39694__$1,cljs.core.cst$kw$vars);
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_39805){
var state_val_39806 = (state_39805[(1)]);
if((state_val_39806 === (7))){
var inst_39711 = (state_39805[(7)]);
var state_39805__$1 = state_39805;
var statearr_39807_39860 = state_39805__$1;
(statearr_39807_39860[(2)] = inst_39711);

(statearr_39807_39860[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (20))){
var inst_39739 = (state_39805[(8)]);
var inst_39770 = typeof inst_39739 === 'number';
var state_39805__$1 = state_39805;
if(cljs.core.truth_(inst_39770)){
var statearr_39808_39861 = state_39805__$1;
(statearr_39808_39861[(1)] = (22));

} else {
var statearr_39809_39862 = state_39805__$1;
(statearr_39809_39862[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (27))){
var inst_39785 = (state_39805[(2)]);
var state_39805__$1 = state_39805;
var statearr_39810_39863 = state_39805__$1;
(statearr_39810_39863[(2)] = inst_39785);

(statearr_39810_39863[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (1))){
var state_39805__$1 = state_39805;
var statearr_39811_39864 = state_39805__$1;
(statearr_39811_39864[(2)] = null);

(statearr_39811_39864[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (24))){
var inst_39787 = (state_39805[(2)]);
var state_39805__$1 = state_39805;
var statearr_39812_39865 = state_39805__$1;
(statearr_39812_39865[(2)] = inst_39787);

(statearr_39812_39865[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (4))){
var inst_39695 = (state_39805[(2)]);
var state_39805__$1 = state_39805;
var statearr_39813_39866 = state_39805__$1;
(statearr_39813_39866[(2)] = inst_39695);

(statearr_39813_39866[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (15))){
var inst_39753 = (state_39805[(2)]);
var inst_39754 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_39755 = fluree.db.query.analytical.variable_QMARK_(inst_39754);
var state_39805__$1 = (function (){var statearr_39814 = state_39805;
(statearr_39814[(9)] = inst_39753);

return statearr_39814;
})();
if(cljs.core.truth_(inst_39755)){
var statearr_39815_39867 = state_39805__$1;
(statearr_39815_39867[(1)] = (16));

} else {
var statearr_39816_39868 = state_39805__$1;
(statearr_39816_39868[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (21))){
var inst_39741 = (state_39805[(10)]);
var inst_39712 = (state_39805[(11)]);
var inst_39742 = (state_39805[(12)]);
var inst_39789 = (state_39805[(2)]);
var inst_39790 = fluree.db.query.analytical.tuples__GT_recur(db,inst_39742,inst_39789,inst_39712,inst_39741);
var state_39805__$1 = state_39805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39805__$1,(28),inst_39790);
} else {
if((state_val_39806 === (13))){
var inst_39721 = (state_39805[(13)]);
var inst_39745 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39721)].join('');
var inst_39746 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39747 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_39748 = cljs.core.PersistentHashMap.fromArrays(inst_39746,inst_39747);
var inst_39749 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39745,inst_39748);
var inst_39750 = (function(){throw inst_39749})();
var state_39805__$1 = state_39805;
var statearr_39817_39869 = state_39805__$1;
(statearr_39817_39869[(2)] = inst_39750);

(statearr_39817_39869[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (22))){
var inst_39737 = (state_39805[(14)]);
var inst_39739 = (state_39805[(8)]);
var inst_39772 = cljs.core.PersistentHashMap.EMPTY;
var inst_39773 = cljs.core.flatten(inst_39737);
var inst_39774 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39772,inst_39739,inst_39773);
var state_39805__$1 = state_39805;
var statearr_39818_39870 = state_39805__$1;
(statearr_39818_39870[(2)] = inst_39774);

(statearr_39818_39870[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (6))){
var inst_39723 = (state_39805[(15)]);
var state_39805__$1 = state_39805;
var statearr_39819_39871 = state_39805__$1;
(statearr_39819_39871[(2)] = inst_39723);

(statearr_39819_39871[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (28))){
var inst_39792 = (state_39805[(2)]);
var inst_39793 = fluree.db.util.async.throw_err(inst_39792);
var state_39805__$1 = state_39805;
var statearr_39820_39872 = state_39805__$1;
(statearr_39820_39872[(2)] = inst_39793);

(statearr_39820_39872[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (25))){
var inst_39737 = (state_39805[(14)]);
var inst_39733 = (state_39805[(16)]);
var inst_39778 = cljs.core.PersistentHashMap.EMPTY;
var inst_39779 = cljs.core.first(inst_39733);
var inst_39780 = cljs.core.first(inst_39779);
var inst_39781 = cljs.core.flatten(inst_39737);
var inst_39782 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39778,inst_39780,inst_39781);
var state_39805__$1 = state_39805;
var statearr_39821_39873 = state_39805__$1;
(statearr_39821_39873[(2)] = inst_39782);

(statearr_39821_39873[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (17))){
var inst_39721 = (state_39805[(13)]);
var inst_39758 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39721)].join('');
var inst_39759 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39760 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_39761 = cljs.core.PersistentHashMap.fromArrays(inst_39759,inst_39760);
var inst_39762 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39758,inst_39761);
var inst_39763 = (function(){throw inst_39762})();
var state_39805__$1 = state_39805;
var statearr_39822_39874 = state_39805__$1;
(statearr_39822_39874[(2)] = inst_39763);

(statearr_39822_39874[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (3))){
var inst_39803 = (state_39805[(2)]);
var state_39805__$1 = state_39805;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39805__$1,inst_39803);
} else {
if((state_val_39806 === (12))){
var inst_39708 = (state_39805[(17)]);
var inst_39796 = (state_39805[(2)]);
var inst_39797 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_39798 = cljs.core.keys(inst_39708);
var inst_39799 = [inst_39798,vars,inst_39796];
var inst_39800 = cljs.core.PersistentHashMap.fromArrays(inst_39797,inst_39799);
var _ = (function (){var statearr_39823 = state_39805;
(statearr_39823[(4)] = cljs.core.rest((state_39805[(4)])));

return statearr_39823;
})();
var state_39805__$1 = state_39805;
var statearr_39824_39875 = state_39805__$1;
(statearr_39824_39875[(2)] = inst_39800);

(statearr_39824_39875[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (2))){
var inst_39708 = (state_39805[(17)]);
var inst_39711 = (state_39805[(7)]);
var inst_39712 = (state_39805[(11)]);
var inst_39723 = (state_39805[(15)]);
var _ = (function (){var statearr_39825 = state_39805;
(statearr_39825[(4)] = cljs.core.cons((5),(state_39805[(4)])));

return statearr_39825;
})();
var inst_39705 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_39706 = cljs.core.__destructure_map(inst_39705);
var inst_39707 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39706,cljs.core.cst$kw$search);
var inst_39708__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39706,cljs.core.cst$kw$rel);
var inst_39709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39706,cljs.core.cst$kw$opts);
var inst_39710 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_39711__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_39709);
var inst_39712__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_39709);
var inst_39714 = (function (){var map__39701 = inst_39706;
var search = inst_39707;
var rel = inst_39708__$1;
var opts = inst_39709;
var common_keys = inst_39710;
var object_fn = inst_39711__$1;
var recur_depth = inst_39712__$1;
return (function (p__39713,common_key){
var vec__39826 = p__39713;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39826,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39826,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__39829 = cljs.core._EQ_;
var expr__39830 = idx_of;
if(cljs.core.truth_((pred__39829.cljs$core$IFn$_invoke$arity$2 ? pred__39829.cljs$core$IFn$_invoke$arity$2((0),expr__39830) : pred__39829.call(null,(0),expr__39830)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__39829.cljs$core$IFn$_invoke$arity$2 ? pred__39829.cljs$core$IFn$_invoke$arity$2((1),expr__39830) : pred__39829.call(null,(1),expr__39830)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__39829.cljs$core$IFn$_invoke$arity$2 ? pred__39829.cljs$core$IFn$_invoke$arity$2((2),expr__39830) : pred__39829.call(null,(2),expr__39830)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__39830)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4221__auto__ = (!(single_v_QMARK_));
if(and__4221__auto__){
var and__4221__auto____$1 = object_fn;
if(cljs.core.truth_(and__4221__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_39715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39716 = cljs.core.PersistentHashMap.EMPTY;
var inst_39717 = [inst_39716,inst_39707];
var inst_39718 = (new cljs.core.PersistentVector(null,2,(5),inst_39715,inst_39717,null));
var inst_39719 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39714,inst_39718,inst_39710);
var inst_39720 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39719,(0),null);
var inst_39721 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39719,(1),null);
var inst_39722 = [cljs.core.cst$kw$object_DASH_fn];
var inst_39723__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_39720);
var state_39805__$1 = (function (){var statearr_39832 = state_39805;
(statearr_39832[(18)] = inst_39722);

(statearr_39832[(17)] = inst_39708__$1);

(statearr_39832[(7)] = inst_39711__$1);

(statearr_39832[(11)] = inst_39712__$1);

(statearr_39832[(13)] = inst_39721);

(statearr_39832[(15)] = inst_39723__$1);

return statearr_39832;
})();
if(cljs.core.truth_(inst_39723__$1)){
var statearr_39833_39876 = state_39805__$1;
(statearr_39833_39876[(1)] = (6));

} else {
var statearr_39834_39877 = state_39805__$1;
(statearr_39834_39877[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (23))){
var inst_39739 = (state_39805[(8)]);
var inst_39776 = cljs.core.coll_QMARK_(inst_39739);
var state_39805__$1 = state_39805;
if(inst_39776){
var statearr_39835_39878 = state_39805__$1;
(statearr_39835_39878[(1)] = (25));

} else {
var statearr_39836_39879 = state_39805__$1;
(statearr_39836_39879[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (19))){
var inst_39737 = (state_39805[(14)]);
var inst_39767 = cljs.core.PersistentHashMap.EMPTY;
var inst_39768 = fluree.db.query.analytical.tuples__GT_map(inst_39767,inst_39737);
var state_39805__$1 = state_39805;
var statearr_39837_39880 = state_39805__$1;
(statearr_39837_39880[(2)] = inst_39768);

(statearr_39837_39880[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (11))){
var inst_39737 = (state_39805[(14)]);
var state_39805__$1 = state_39805;
var statearr_39839_39881 = state_39805__$1;
(statearr_39839_39881[(2)] = inst_39737);

(statearr_39839_39881[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (9))){
var inst_39708 = (state_39805[(17)]);
var inst_39712 = (state_39805[(11)]);
var inst_39733 = (state_39805[(16)]);
var inst_39732 = (state_39805[(2)]);
var inst_39733__$1 = fluree.db.util.async.throw_err(inst_39732);
var inst_39734 = cljs.core.count(inst_39733__$1);
var inst_39735 = fluree.db.query.analytical.add_fuel(inst_39734,fuel,max_fuel);
var inst_39736 = cljs.core.vals(inst_39708);
var inst_39737 = fluree.db.query.analytical.get_ns_arrays(inst_39736,inst_39733__$1);
var state_39805__$1 = (function (){var statearr_39840 = state_39805;
(statearr_39840[(14)] = inst_39737);

(statearr_39840[(19)] = inst_39735);

(statearr_39840[(16)] = inst_39733__$1);

return statearr_39840;
})();
if(cljs.core.truth_(inst_39712)){
var statearr_39841_39882 = state_39805__$1;
(statearr_39841_39882[(1)] = (10));

} else {
var statearr_39842_39883 = state_39805__$1;
(statearr_39842_39883[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (5))){
var _ = (function (){var statearr_39843 = state_39805;
(statearr_39843[(4)] = cljs.core.rest((state_39805[(4)])));

return statearr_39843;
})();
var state_39805__$1 = state_39805;
var ex39838 = (state_39805__$1[(2)]);
var statearr_39844_39884 = state_39805__$1;
(statearr_39844_39884[(5)] = ex39838);


if((ex39838 instanceof Error)){
var statearr_39845_39885 = state_39805__$1;
(statearr_39845_39885[(1)] = (4));

(statearr_39845_39885[(5)] = null);

} else {
throw ex39838;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (14))){
var state_39805__$1 = state_39805;
var statearr_39846_39886 = state_39805__$1;
(statearr_39846_39886[(2)] = null);

(statearr_39846_39886[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (26))){
var state_39805__$1 = state_39805;
var statearr_39847_39887 = state_39805__$1;
(statearr_39847_39887[(2)] = null);

(statearr_39847_39887[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (16))){
var state_39805__$1 = state_39805;
var statearr_39848_39888 = state_39805__$1;
(statearr_39848_39888[(2)] = null);

(statearr_39848_39888[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (10))){
var inst_39721 = (state_39805[(13)]);
var inst_39742 = (state_39805[(12)]);
var inst_39739 = cljs.core.first(inst_39721);
var inst_39740 = cljs.core.first(clause);
var inst_39741 = fluree.db.query.analytical.variable_QMARK_(inst_39740);
var inst_39742__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_39721,(1));
var inst_39743 = fluree.db.query.analytical.variable_QMARK_(inst_39742__$1);
var state_39805__$1 = (function (){var statearr_39849 = state_39805;
(statearr_39849[(10)] = inst_39741);

(statearr_39849[(8)] = inst_39739);

(statearr_39849[(12)] = inst_39742__$1);

return statearr_39849;
})();
if(cljs.core.truth_(inst_39743)){
var statearr_39850_39889 = state_39805__$1;
(statearr_39850_39889[(1)] = (13));

} else {
var statearr_39851_39890 = state_39805__$1;
(statearr_39851_39890[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (18))){
var inst_39741 = (state_39805[(10)]);
var inst_39765 = (state_39805[(2)]);
var state_39805__$1 = (function (){var statearr_39852 = state_39805;
(statearr_39852[(20)] = inst_39765);

return statearr_39852;
})();
if(cljs.core.truth_(inst_39741)){
var statearr_39853_39891 = state_39805__$1;
(statearr_39853_39891[(1)] = (19));

} else {
var statearr_39854_39892 = state_39805__$1;
(statearr_39854_39892[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39806 === (8))){
var inst_39722 = (state_39805[(18)]);
var inst_39721 = (state_39805[(13)]);
var inst_39727 = (state_39805[(2)]);
var inst_39728 = [inst_39727];
var inst_39729 = cljs.core.PersistentHashMap.fromArrays(inst_39722,inst_39728);
var inst_39730 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_39721,inst_39729);
var state_39805__$1 = state_39805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39805__$1,(9),inst_39730);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__20477__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__20477__auto____0 = (function (){
var statearr_39855 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39855[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__20477__auto__);

(statearr_39855[(1)] = (1));

return statearr_39855;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__20477__auto____1 = (function (state_39805){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_39805);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e39856){var ex__20480__auto__ = e39856;
var statearr_39857_39893 = state_39805;
(statearr_39857_39893[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_39805[(4)]))){
var statearr_39858_39894 = state_39805;
(statearr_39858_39894[(1)] = cljs.core.first((state_39805[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__39895 = state_39805;
state_39805 = G__39895;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__20477__auto__ = function(state_39805){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__20477__auto____1.call(this,state_39805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__20477__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__20477__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_39859 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_39859[(6)] = c__20603__auto__);

return statearr_39859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__39896,res,clause){
var map__39897 = p__39896;
var map__39897__$1 = cljs.core.__destructure_map(map__39897);
var db = map__39897__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39897__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39897__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39897__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_39996){
var state_val_39997 = (state_39996[(1)]);
if((state_val_39997 === (7))){
var inst_39907 = (state_39996[(7)]);
var state_39996__$1 = state_39996;
var statearr_39998_40038 = state_39996__$1;
(statearr_39998_40038[(2)] = inst_39907);

(statearr_39998_40038[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (20))){
var inst_39987 = (state_39996[(2)]);
var state_39996__$1 = state_39996;
var statearr_39999_40039 = state_39996__$1;
(statearr_39999_40039[(2)] = inst_39987);

(statearr_39999_40039[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (1))){
var state_39996__$1 = state_39996;
var statearr_40000_40040 = state_39996__$1;
(statearr_40000_40040[(2)] = null);

(statearr_40000_40040[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (24))){
var inst_39966 = (state_39996[(2)]);
var inst_39967 = fluree.db.util.async.throw_err(inst_39966);
var state_39996__$1 = state_39996;
var statearr_40001_40041 = state_39996__$1;
(statearr_40001_40041[(2)] = inst_39967);

(statearr_40001_40041[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (4))){
var inst_39900 = (state_39996[(2)]);
var state_39996__$1 = state_39996;
var statearr_40002_40042 = state_39996__$1;
(statearr_40002_40042[(2)] = inst_39900);

(statearr_40002_40042[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (15))){
var inst_39909 = (state_39996[(8)]);
var inst_39907 = (state_39996[(7)]);
var inst_39928 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_39929 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_39930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39931 = [inst_39907];
var inst_39932 = (new cljs.core.PersistentVector(null,1,(5),inst_39930,inst_39931,null));
var inst_39933 = (function (){var subject_var = inst_39907;
var object_var = inst_39909;
var min_sid = inst_39928;
var max_sid = (0);
return (function (p1__39898_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__39898_SHARP_);
});
})();
var inst_39934 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_39928,(0));
var inst_39935 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39933,inst_39934);
var inst_39936 = cljs.core.PersistentHashMap.EMPTY;
var inst_39937 = [inst_39932,inst_39935,inst_39936];
var inst_39938 = cljs.core.PersistentHashMap.fromArrays(inst_39929,inst_39937);
var state_39996__$1 = state_39996;
var statearr_40003_40043 = state_39996__$1;
(statearr_40003_40043[(2)] = inst_39938);

(statearr_40003_40043[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (21))){
var inst_39960 = (state_39996[(9)]);
var state_39996__$1 = state_39996;
var statearr_40004_40044 = state_39996__$1;
(statearr_40004_40044[(2)] = inst_39960);

(statearr_40004_40044[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (13))){
var inst_39909 = (state_39996[(8)]);
var state_39996__$1 = state_39996;
if(cljs.core.truth_(inst_39909)){
var statearr_40005_40045 = state_39996__$1;
(statearr_40005_40045[(1)] = (18));

} else {
var statearr_40006_40046 = state_39996__$1;
(statearr_40006_40046[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (22))){
var inst_39960 = (state_39996[(9)]);
var inst_39964 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_39960);
var state_39996__$1 = state_39996;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39996__$1,(24),inst_39964);
} else {
if((state_val_39997 === (6))){
var inst_39909 = (state_39996[(8)]);
var state_39996__$1 = state_39996;
var statearr_40007_40047 = state_39996__$1;
(statearr_40007_40047[(2)] = inst_39909);

(statearr_40007_40047[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (17))){
var inst_39957 = (state_39996[(2)]);
var state_39996__$1 = state_39996;
var statearr_40008_40048 = state_39996__$1;
(statearr_40008_40048[(2)] = inst_39957);

(statearr_40008_40048[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (3))){
var inst_39994 = (state_39996[(2)]);
var state_39996__$1 = state_39996;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39996__$1,inst_39994);
} else {
if((state_val_39997 === (12))){
var inst_39922 = ["_tx",null,"_block",null];
var inst_39923 = (new cljs.core.PersistentArrayMap(null,2,inst_39922,null));
var inst_39924 = (new cljs.core.PersistentHashSet(null,inst_39923,null));
var inst_39925 = cljs.core.last(clause);
var inst_39926 = (inst_39924.cljs$core$IFn$_invoke$arity$1 ? inst_39924.cljs$core$IFn$_invoke$arity$1(inst_39925) : inst_39924.call(null,inst_39925));
var state_39996__$1 = state_39996;
if(cljs.core.truth_(inst_39926)){
var statearr_40009_40049 = state_39996__$1;
(statearr_40009_40049[(1)] = (15));

} else {
var statearr_40010_40050 = state_39996__$1;
(statearr_40010_40050[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (2))){
var inst_39907 = (state_39996[(7)]);
var _ = (function (){var statearr_40011 = state_39996;
(statearr_40011[(4)] = cljs.core.cons((5),(state_39996[(4)])));

return statearr_40011;
})();
var inst_39906 = cljs.core.first(clause);
var inst_39907__$1 = fluree.db.query.analytical.variable_QMARK_(inst_39906);
var inst_39908 = cljs.core.last(clause);
var inst_39909 = fluree.db.query.analytical.variable_QMARK_(inst_39908);
var state_39996__$1 = (function (){var statearr_40012 = state_39996;
(statearr_40012[(8)] = inst_39909);

(statearr_40012[(7)] = inst_39907__$1);

return statearr_40012;
})();
if(cljs.core.truth_(inst_39907__$1)){
var statearr_40013_40051 = state_39996__$1;
(statearr_40013_40051[(1)] = (6));

} else {
var statearr_40014_40052 = state_39996__$1;
(statearr_40014_40052[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (23))){
var inst_39909 = (state_39996[(8)]);
var inst_39969 = (state_39996[(2)]);
var inst_39970 = fluree.db.flake.sid__GT_cid(inst_39969);
var inst_39971 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_39970);
var inst_39972 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_39973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39974 = [inst_39909];
var inst_39975 = (new cljs.core.PersistentVector(null,1,(5),inst_39973,inst_39974,null));
var inst_39976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39978 = [inst_39971];
var inst_39979 = (new cljs.core.PersistentVector(null,1,(5),inst_39977,inst_39978,null));
var inst_39980 = [inst_39979];
var inst_39981 = (new cljs.core.PersistentVector(null,1,(5),inst_39976,inst_39980,null));
var inst_39982 = cljs.core.PersistentHashMap.EMPTY;
var inst_39983 = [inst_39975,inst_39981,inst_39982];
var inst_39984 = cljs.core.PersistentHashMap.fromArrays(inst_39972,inst_39983);
var state_39996__$1 = state_39996;
var statearr_40015_40053 = state_39996__$1;
(statearr_40015_40053[(2)] = inst_39984);

(statearr_40015_40053[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (19))){
var state_39996__$1 = state_39996;
var statearr_40016_40054 = state_39996__$1;
(statearr_40016_40054[(2)] = null);

(statearr_40016_40054[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (11))){
var inst_39991 = (state_39996[(2)]);
var _ = (function (){var statearr_40018 = state_39996;
(statearr_40018[(4)] = cljs.core.rest((state_39996[(4)])));

return statearr_40018;
})();
var state_39996__$1 = state_39996;
var statearr_40019_40055 = state_39996__$1;
(statearr_40019_40055[(2)] = inst_39991);

(statearr_40019_40055[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (9))){
var inst_39915 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39916 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_39917 = cljs.core.PersistentHashMap.fromArrays(inst_39915,inst_39916);
var inst_39918 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_39917);
var inst_39919 = (function(){throw inst_39918})();
var state_39996__$1 = state_39996;
var statearr_40020_40056 = state_39996__$1;
(statearr_40020_40056[(2)] = inst_39919);

(statearr_40020_40056[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (5))){
var _ = (function (){var statearr_40021 = state_39996;
(statearr_40021[(4)] = cljs.core.rest((state_39996[(4)])));

return statearr_40021;
})();
var state_39996__$1 = state_39996;
var ex40017 = (state_39996__$1[(2)]);
var statearr_40022_40057 = state_39996__$1;
(statearr_40022_40057[(5)] = ex40017);


if((ex40017 instanceof Error)){
var statearr_40023_40058 = state_39996__$1;
(statearr_40023_40058[(1)] = (4));

(statearr_40023_40058[(5)] = null);

} else {
throw ex40017;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (14))){
var inst_39989 = (state_39996[(2)]);
var state_39996__$1 = state_39996;
var statearr_40024_40059 = state_39996__$1;
(statearr_40024_40059[(2)] = inst_39989);

(statearr_40024_40059[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (16))){
var inst_39909 = (state_39996[(8)]);
var inst_39907 = (state_39996[(7)]);
var inst_39940 = cljs.core.last(clause);
var inst_39941 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,inst_39940);
var inst_39942 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_39943 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39942,inst_39941);
var inst_39944 = fluree.db.flake.min_subject_id(inst_39941);
var inst_39945 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_39946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39947 = [inst_39907];
var inst_39948 = (new cljs.core.PersistentVector(null,1,(5),inst_39946,inst_39947,null));
var inst_39949 = (function (){var subject_var = inst_39907;
var object_var = inst_39909;
var partition = inst_39941;
var max_sid = inst_39943;
var min_sid = inst_39944;
return (function (p1__39899_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__39899_SHARP_);
});
})();
var inst_39950 = (inst_39943 + (1));
var inst_39951 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_39944,inst_39950);
var inst_39952 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39949,inst_39951);
var inst_39953 = cljs.core.PersistentHashMap.EMPTY;
var inst_39954 = [inst_39948,inst_39952,inst_39953];
var inst_39955 = cljs.core.PersistentHashMap.fromArrays(inst_39945,inst_39954);
var state_39996__$1 = state_39996;
var statearr_40025_40060 = state_39996__$1;
(statearr_40025_40060[(2)] = inst_39955);

(statearr_40025_40060[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (10))){
var inst_39907 = (state_39996[(7)]);
var state_39996__$1 = state_39996;
if(cljs.core.truth_(inst_39907)){
var statearr_40026_40061 = state_39996__$1;
(statearr_40026_40061[(1)] = (12));

} else {
var statearr_40027_40062 = state_39996__$1;
(statearr_40027_40062[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (18))){
var inst_39960 = (state_39996[(9)]);
var inst_39960__$1 = cljs.core.first(clause);
var inst_39961 = typeof inst_39960__$1 === 'number';
var state_39996__$1 = (function (){var statearr_40028 = state_39996;
(statearr_40028[(9)] = inst_39960__$1);

return statearr_40028;
})();
if(cljs.core.truth_(inst_39961)){
var statearr_40029_40063 = state_39996__$1;
(statearr_40029_40063[(1)] = (21));

} else {
var statearr_40030_40064 = state_39996__$1;
(statearr_40030_40064[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39997 === (8))){
var inst_39913 = (state_39996[(2)]);
var state_39996__$1 = state_39996;
if(cljs.core.truth_(inst_39913)){
var statearr_40031_40065 = state_39996__$1;
(statearr_40031_40065[(1)] = (9));

} else {
var statearr_40032_40066 = state_39996__$1;
(statearr_40032_40066[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__20477__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__20477__auto____0 = (function (){
var statearr_40033 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40033[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__20477__auto__);

(statearr_40033[(1)] = (1));

return statearr_40033;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__20477__auto____1 = (function (state_39996){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_39996);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e40034){var ex__20480__auto__ = e40034;
var statearr_40035_40067 = state_39996;
(statearr_40035_40067[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_39996[(4)]))){
var statearr_40036_40068 = state_39996;
(statearr_40036_40068[(1)] = cljs.core.first((state_39996[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__40069 = state_39996;
state_39996 = G__40069;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__20477__auto__ = function(state_39996){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__20477__auto____1.call(this,state_39996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__20477__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__20477__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_40037 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_40037[(6)] = c__20603__auto__);

return statearr_40037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__40076 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__40076 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__40076;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4622__auto__ = (function fluree$db$query$analytical$variance_$_iter__40077(s__40078){
return (new cljs.core.LazySeq(null,(function (){
var s__40078__$1 = s__40078;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__40078__$1);
if(temp__5753__auto__){
var s__40078__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__40078__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__40078__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__40080 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__40079 = (0);
while(true){
if((i__40079 < size__4621__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__40079);
var delta = (x - mean);
cljs.core.chunk_append(b__40080,(delta * delta));

var G__40082 = (i__40079 + (1));
i__40079 = G__40082;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40080),fluree$db$query$analytical$variance_$_iter__40077(cljs.core.chunk_rest(s__40078__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40080),null);
}
} else {
var x = cljs.core.first(s__40078__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__40077(cljs.core.rest(s__40078__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__40081 = variance(coll);
return Math.sqrt(G__40081);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4306__auto__ = n;
var y__4307__auto__ = (- n);
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
}),(function() {
var G__40083 = null;
var G__40083__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__40083__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__40083 = function(n,coll){
switch(arguments.length){
case 1:
return G__40083__1.call(this,n);
case 2:
return G__40083__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__40083.cljs$core$IFn$_invoke$arity$1 = G__40083__1;
G__40083.cljs$core$IFn$_invoke$arity$2 = G__40083__2;
return G__40083;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__40084 = null;
var G__40084__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__40084__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__40084 = function(n,coll){
switch(arguments.length){
case 1:
return G__40084__1.call(this,n);
case 2:
return G__40084__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__40084.cljs$core$IFn$_invoke$arity$1 = G__40084__1;
G__40084.cljs$core$IFn$_invoke$arity$2 = G__40084__2;
return G__40084;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__40085 = null;
var G__40085__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__40085__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__40085 = function(n,coll){
switch(arguments.length){
case 1:
return G__40085__1.call(this,n);
case 2:
return G__40085__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__40085.cljs$core$IFn$_invoke$arity$1 = G__40085__1;
G__40085.cljs$core$IFn$_invoke$arity$2 = G__40085__2;
return G__40085;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__40086 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40086,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40086,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40086,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__40089 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__40092 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__40092) : agg_fn.call(null,G__40092));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40089,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40089,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__40093 = agg;
var map__40093__$1 = cljs.core.__destructure_map(map__40093);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40093__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40093__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40093__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__40095 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40095,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40095,(1),null);
var map__40098 = res__$1;
var map__40098__$1 = cljs.core.__destructure_map(map__40098);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40098__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40098__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40094_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__40094_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40099_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__40099_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40100_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__40100_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__40101_SHARP_,p2__40102_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__40101_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__40102_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40103_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__40103_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__40106,row,b_tuple){
var vec__40107 = p__40106;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40107,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40107,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40104_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__40104_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = acc;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40105_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__40105_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40110_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__40110_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40111_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__40111_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__40116 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__40118 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__40117 = (function (p1__40112_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__40112_SHARP_);
});
return fexpr__40117(G__40118);
})()),cljs.core.set(b_idxs));
var fexpr__40115 = (function (p1__40113_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__40113_SHARP_);
});
return fexpr__40115(G__40116);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40114_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__40114_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40119_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__40119_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40120_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__40120_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__40125 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__40127 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__40126 = (function (p1__40121_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__40121_SHARP_);
});
return fexpr__40126(G__40127);
})()),cljs.core.set(b_idxs));
var fexpr__40124 = (function (p1__40122_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__40122_SHARP_);
});
return fexpr__40124(G__40125);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40123_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__40123_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40128_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__40128_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40129_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__40129_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__40138 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__40140 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__40139 = (function (p1__40130_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__40130_SHARP_);
});
return fexpr__40139(G__40140);
})()),cljs.core.set(b_idxs));
var fexpr__40137 = (function (p1__40131_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__40131_SHARP_);
});
return fexpr__40137(G__40138);
})();
var vec__40134 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__40141,a_tuple){
var vec__40142 = p__40141;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40142,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40142,(1),null);
var vec__40145 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40145,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40145,(1),null);
var matches__$1 = (function (){var or__4223__auto__ = matches;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(c_tuples),matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40134,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40134,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40132_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__40132_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40133_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__40133_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__40149 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40149,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40149,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__40148_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__40148_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__40154 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40154,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40154,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40152_SHARP_){
return fluree.db.util.core.index_of(headers,p1__40152_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__40153_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__40153_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__40157,filters,optional_QMARK_){
var map__40158 = p__40157;
var map__40158__$1 = cljs.core.__destructure_map(map__40158);
var tuple_map = map__40158__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40158__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40158__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40158__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__40159 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40159,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40159,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__40162 = res;
var map__40162__$1 = cljs.core.__destructure_map(map__40162);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40162__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40162__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_40218){
var state_val_40219 = (state_40218[(1)]);
if((state_val_40219 === (7))){
var inst_40192 = (state_40218[(7)]);
var inst_40190 = (state_40218[(2)]);
var inst_40191 = fluree.db.util.async.throw_err(inst_40190);
var inst_40192__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40191,(0),null);
var inst_40193 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40191,(1),null);
var inst_40194 = (inst_40192__$1 == null);
var state_40218__$1 = (function (){var statearr_40220 = state_40218;
(statearr_40220[(7)] = inst_40192__$1);

(statearr_40220[(8)] = inst_40193);

return statearr_40220;
})();
if(cljs.core.truth_(inst_40194)){
var statearr_40221_40250 = state_40218__$1;
(statearr_40221_40250[(1)] = (8));

} else {
var statearr_40222_40251 = state_40218__$1;
(statearr_40222_40251[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40219 === (1))){
var inst_40170 = optional_clauses;
var inst_40171 = cljs.core.seq(inst_40170);
var inst_40172 = cljs.core.first(inst_40171);
var inst_40173 = cljs.core.next(inst_40171);
var inst_40174 = where_tuples;
var inst_40175 = inst_40170;
var inst_40176 = inst_40174;
var state_40218__$1 = (function (){var statearr_40223 = state_40218;
(statearr_40223[(9)] = inst_40173);

(statearr_40223[(10)] = inst_40175);

(statearr_40223[(11)] = inst_40176);

(statearr_40223[(12)] = inst_40172);

return statearr_40223;
})();
var statearr_40224_40252 = state_40218__$1;
(statearr_40224_40252[(2)] = null);

(statearr_40224_40252[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40219 === (4))){
var inst_40183 = (state_40218[(13)]);
var inst_40176 = (state_40218[(11)]);
var inst_40182 = (state_40218[(14)]);
var inst_40188 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_40176,inst_40182,inst_40183,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_40176,inst_40182,inst_40183,true,fuel,max_fuel,opts));
var state_40218__$1 = state_40218;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40218__$1,(7),inst_40188);
} else {
if((state_val_40219 === (15))){
var state_40218__$1 = state_40218;
var statearr_40225_40253 = state_40218__$1;
(statearr_40225_40253[(2)] = null);

(statearr_40225_40253[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40219 === (13))){
var inst_40209 = (state_40218[(2)]);
var state_40218__$1 = state_40218;
var statearr_40226_40254 = state_40218__$1;
(statearr_40226_40254[(2)] = inst_40209);

(statearr_40226_40254[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40219 === (6))){
var inst_40214 = (state_40218[(2)]);
var state_40218__$1 = state_40218;
var statearr_40227_40255 = state_40218__$1;
(statearr_40227_40255[(2)] = inst_40214);

(statearr_40227_40255[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40219 === (3))){
var inst_40216 = (state_40218[(2)]);
var state_40218__$1 = state_40218;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40218__$1,inst_40216);
} else {
if((state_val_40219 === (12))){
var state_40218__$1 = state_40218;
var statearr_40228_40256 = state_40218__$1;
(statearr_40228_40256[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40219 === (2))){
var inst_40175 = (state_40218[(10)]);
var inst_40182 = (state_40218[(14)]);
var inst_40181 = cljs.core.seq(inst_40175);
var inst_40182__$1 = cljs.core.first(inst_40181);
var inst_40183 = cljs.core.next(inst_40181);
var state_40218__$1 = (function (){var statearr_40230 = state_40218;
(statearr_40230[(13)] = inst_40183);

(statearr_40230[(14)] = inst_40182__$1);

return statearr_40230;
})();
if(cljs.core.truth_(inst_40182__$1)){
var statearr_40231_40257 = state_40218__$1;
(statearr_40231_40257[(1)] = (4));

} else {
var statearr_40232_40258 = state_40218__$1;
(statearr_40232_40258[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40219 === (11))){
var inst_40192 = (state_40218[(7)]);
var inst_40193 = (state_40218[(8)]);
var inst_40175 = inst_40193;
var inst_40176 = inst_40192;
var state_40218__$1 = (function (){var statearr_40233 = state_40218;
(statearr_40233[(10)] = inst_40175);

(statearr_40233[(11)] = inst_40176);

return statearr_40233;
})();
var statearr_40234_40259 = state_40218__$1;
(statearr_40234_40259[(2)] = null);

(statearr_40234_40259[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40219 === (9))){
var inst_40182 = (state_40218[(14)]);
var inst_40198 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_40182);
var state_40218__$1 = state_40218;
if(cljs.core.truth_(inst_40198)){
var statearr_40235_40260 = state_40218__$1;
(statearr_40235_40260[(1)] = (11));

} else {
var statearr_40236_40261 = state_40218__$1;
(statearr_40236_40261[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40219 === (5))){
var inst_40176 = (state_40218[(11)]);
var state_40218__$1 = state_40218;
var statearr_40237_40262 = state_40218__$1;
(statearr_40237_40262[(2)] = inst_40176);

(statearr_40237_40262[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40219 === (14))){
var inst_40192 = (state_40218[(7)]);
var inst_40193 = (state_40218[(8)]);
var inst_40176 = (state_40218[(11)]);
var inst_40203 = fluree.db.query.analytical.left_outer_join(inst_40176,inst_40192);
var inst_40175 = inst_40193;
var inst_40176__$1 = inst_40203;
var state_40218__$1 = (function (){var statearr_40238 = state_40218;
(statearr_40238[(10)] = inst_40175);

(statearr_40238[(11)] = inst_40176__$1);

return statearr_40238;
})();
var statearr_40239_40263 = state_40218__$1;
(statearr_40239_40263[(2)] = null);

(statearr_40239_40263[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40219 === (16))){
var inst_40207 = (state_40218[(2)]);
var state_40218__$1 = state_40218;
var statearr_40241_40264 = state_40218__$1;
(statearr_40241_40264[(2)] = inst_40207);

(statearr_40241_40264[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40219 === (10))){
var inst_40211 = (state_40218[(2)]);
var state_40218__$1 = state_40218;
var statearr_40242_40265 = state_40218__$1;
(statearr_40242_40265[(2)] = inst_40211);

(statearr_40242_40265[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40219 === (8))){
var inst_40193 = (state_40218[(8)]);
var inst_40176 = (state_40218[(11)]);
var tmp40240 = inst_40176;
var inst_40175 = inst_40193;
var inst_40176__$1 = tmp40240;
var state_40218__$1 = (function (){var statearr_40243 = state_40218;
(statearr_40243[(10)] = inst_40175);

(statearr_40243[(11)] = inst_40176__$1);

return statearr_40243;
})();
var statearr_40244_40266 = state_40218__$1;
(statearr_40244_40266[(2)] = null);

(statearr_40244_40266[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__20477__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__20477__auto____0 = (function (){
var statearr_40245 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40245[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__20477__auto__);

(statearr_40245[(1)] = (1));

return statearr_40245;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__20477__auto____1 = (function (state_40218){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_40218);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e40246){var ex__20480__auto__ = e40246;
var statearr_40247_40267 = state_40218;
(statearr_40247_40267[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_40218[(4)]))){
var statearr_40248_40268 = state_40218;
(statearr_40248_40268[(1)] = cljs.core.first((state_40218[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__40269 = state_40218;
state_40218 = G__40269;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__20477__auto__ = function(state_40218){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__20477__auto____1.call(this,state_40218);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__20477__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__20477__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_40249 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_40249[(6)] = c__20603__auto__);

return statearr_40249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__40271){
var vec__40272 = p__40271;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40272,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40272,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40270_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__40270_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__40276,p__40277,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__40278 = p__40276;
var map__40278__$1 = cljs.core.__destructure_map(map__40278);
var q_map = map__40278__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40278__$1,cljs.core.cst$kw$prefixes);
var map__40279 = p__40277;
var map__40279__$1 = cljs.core.__destructure_map(map__40279);
var res = map__40279__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40279__$1,cljs.core.cst$kw$vars);
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_40492){
var state_val_40493 = (state_40492[(1)]);
if((state_val_40493 === (65))){
var inst_40461 = (state_40492[(7)]);
var inst_40464 = (state_40492[(2)]);
var inst_40465 = fluree.db.util.async.throw_err(inst_40464);
var inst_40466 = [inst_40465,r];
var inst_40467 = (new cljs.core.PersistentVector(null,2,(5),inst_40461,inst_40466,null));
var state_40492__$1 = state_40492;
var statearr_40494_40599 = state_40492__$1;
(statearr_40494_40599[(2)] = inst_40467);

(statearr_40494_40599[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (62))){
var inst_40443 = (state_40492[(8)]);
var inst_40444 = (state_40492[(9)]);
var inst_40461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40462 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_40443,res,inst_40444,fuel,max_fuel);
var state_40492__$1 = (function (){var statearr_40495 = state_40492;
(statearr_40495[(7)] = inst_40461);

return statearr_40495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40492__$1,(65),inst_40462);
} else {
if((state_val_40493 === (7))){
var inst_40385 = (state_40492[(10)]);
var inst_40384 = cljs.core.count(clause);
var inst_40385__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_40384);
var state_40492__$1 = (function (){var statearr_40496 = state_40492;
(statearr_40496[(10)] = inst_40385__$1);

return statearr_40496;
})();
if(inst_40385__$1){
var statearr_40497_40600 = state_40492__$1;
(statearr_40497_40600[(1)] = (31));

} else {
var statearr_40498_40601 = state_40492__$1;
(statearr_40498_40601[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (59))){
var inst_40443 = (state_40492[(8)]);
var inst_40444 = (state_40492[(9)]);
var inst_40455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40456 = fluree.db.query.analytical.full_text__GT_tuples(inst_40443,res,inst_40444);
var inst_40457 = [inst_40456,r];
var inst_40458 = (new cljs.core.PersistentVector(null,2,(5),inst_40455,inst_40457,null));
var state_40492__$1 = state_40492;
var statearr_40499_40602 = state_40492__$1;
(statearr_40499_40602[(2)] = inst_40458);

(statearr_40499_40602[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (20))){
var inst_40348 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40500_40603 = state_40492__$1;
(statearr_40500_40603[(2)] = inst_40348);

(statearr_40500_40603[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (58))){
var inst_40449 = (state_40492[(2)]);
var inst_40450 = fluree.db.util.async.throw_err(inst_40449);
var state_40492__$1 = state_40492;
var statearr_40501_40604 = state_40492__$1;
(statearr_40501_40604[(2)] = inst_40450);

(statearr_40501_40604[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (60))){
var state_40492__$1 = state_40492;
var statearr_40502_40605 = state_40492__$1;
(statearr_40502_40605[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (27))){
var inst_40378 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40504_40606 = state_40492__$1;
(statearr_40504_40606[(2)] = inst_40378);

(statearr_40504_40606[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (1))){
var state_40492__$1 = state_40492;
var statearr_40505_40607 = state_40492__$1;
(statearr_40505_40607[(2)] = null);

(statearr_40505_40607[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (24))){
var inst_40342 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40506_40608 = state_40492__$1;
(statearr_40506_40608[(2)] = inst_40342);

(statearr_40506_40608[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (55))){
var inst_40444 = (state_40492[(9)]);
var inst_40447 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_40444,r,res,optional_QMARK_,fuel,max_fuel);
var state_40492__$1 = state_40492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40492__$1,(58),inst_40447);
} else {
if((state_val_40493 === (39))){
var inst_40405 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
if(cljs.core.truth_(inst_40405)){
var statearr_40507_40609 = state_40492__$1;
(statearr_40507_40609[(1)] = (40));

} else {
var statearr_40508_40610 = state_40492__$1;
(statearr_40508_40610[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (46))){
var inst_40481 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40509_40611 = state_40492__$1;
(statearr_40509_40611[(2)] = inst_40481);

(statearr_40509_40611[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (4))){
var inst_40280 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40510_40612 = state_40492__$1;
(statearr_40510_40612[(2)] = inst_40280);

(statearr_40510_40612[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (54))){
var inst_40443 = (state_40492[(8)]);
var inst_40441 = (state_40492[(2)]);
var inst_40442 = fluree.db.util.async.throw_err(inst_40441);
var inst_40443__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40442,(0),null);
var inst_40444 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40442,(1),null);
var inst_40445 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_40443__$1);
var state_40492__$1 = (function (){var statearr_40511 = state_40492;
(statearr_40511[(8)] = inst_40443__$1);

(statearr_40511[(9)] = inst_40444);

return statearr_40511;
})();
if(inst_40445){
var statearr_40512_40613 = state_40492__$1;
(statearr_40512_40613[(1)] = (55));

} else {
var statearr_40513_40614 = state_40492__$1;
(statearr_40513_40614[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (15))){
var inst_40380 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40514_40615 = state_40492__$1;
(statearr_40514_40615[(2)] = inst_40380);

(statearr_40514_40615[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (48))){
var inst_40429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40430 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_40431 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_40430);
var inst_40432 = [inst_40431,r];
var inst_40433 = (new cljs.core.PersistentVector(null,2,(5),inst_40429,inst_40432,null));
var state_40492__$1 = state_40492;
var statearr_40515_40616 = state_40492__$1;
(statearr_40515_40616[(2)] = inst_40433);

(statearr_40515_40616[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (50))){
var inst_40479 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40516_40617 = state_40492__$1;
(statearr_40516_40617[(2)] = inst_40479);

(statearr_40516_40617[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (21))){
var inst_40289 = (state_40492[(11)]);
var inst_40316 = (state_40492[(12)]);
var inst_40318 = (state_40492[(13)]);
var inst_40326 = (state_40492[(14)]);
var inst_40319 = (state_40492[(15)]);
var inst_40325 = (state_40492[(16)]);
var inst_40314 = (state_40492[(17)]);
var inst_40317 = (state_40492[(18)]);
var inst_40293 = (state_40492[(19)]);
var inst_40330 = (state_40492[(2)]);
var inst_40331 = fluree.db.util.async.throw_err(inst_40330);
var inst_40332 = (function (){var new_res = inst_40331;
var rest = inst_40326;
var tuples = inst_40319;
var first__40323 = inst_40325;
var expr__40291 = inst_40289;
var vec__40311 = inst_40314;
var pred__40290 = inst_40293;
var vec__40321 = inst_40318;
var seq__40312 = inst_40317;
var G__40310 = inst_40318;
var seq__40322 = inst_40326;
var first__40313 = inst_40316;
var segment_type = inst_40289;
var clause_group = inst_40325;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_40333 = cljs.core.keys(vars);
var inst_40334 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_40332,inst_40331,inst_40333);
var inst_40335 = fluree.db.query.analytical.res_absorb_vars(inst_40334);
var state_40492__$1 = (function (){var statearr_40517 = state_40492;
(statearr_40517[(20)] = inst_40335);

return statearr_40517;
})();
if(cljs.core.truth_(inst_40319)){
var statearr_40518_40618 = state_40492__$1;
(statearr_40518_40618[(1)] = (22));

} else {
var statearr_40519_40619 = state_40492__$1;
(statearr_40519_40619[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (31))){
var inst_40387 = cljs.core.second(clause);
var inst_40388 = clojure.string.starts_with_QMARK_(inst_40387,"fullText:");
var state_40492__$1 = state_40492;
var statearr_40520_40620 = state_40492__$1;
(statearr_40520_40620[(2)] = inst_40388);

(statearr_40520_40620[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (32))){
var inst_40385 = (state_40492[(10)]);
var state_40492__$1 = state_40492;
var statearr_40521_40621 = state_40492__$1;
(statearr_40521_40621[(2)] = inst_40385);

(statearr_40521_40621[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (40))){
var inst_40407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40408 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_40492__$1 = (function (){var statearr_40522 = state_40492;
(statearr_40522[(21)] = inst_40407);

return statearr_40522;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40492__$1,(43),inst_40408);
} else {
if((state_val_40493 === (56))){
var inst_40444 = (state_40492[(9)]);
var inst_40452 = cljs.core.second(inst_40444);
var inst_40453 = clojure.string.starts_with_QMARK_(inst_40452,"fullText:");
var state_40492__$1 = state_40492;
if(inst_40453){
var statearr_40523_40622 = state_40492__$1;
(statearr_40523_40622[(1)] = (59));

} else {
var statearr_40524_40623 = state_40492__$1;
(statearr_40524_40623[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (33))){
var inst_40391 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
if(cljs.core.truth_(inst_40391)){
var statearr_40525_40624 = state_40492__$1;
(statearr_40525_40624[(1)] = (34));

} else {
var statearr_40526_40625 = state_40492__$1;
(statearr_40526_40625[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (13))){
var inst_40314 = (state_40492[(17)]);
var inst_40314__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_40315 = cljs.core.seq(inst_40314__$1);
var inst_40316 = cljs.core.first(inst_40315);
var inst_40317 = cljs.core.next(inst_40315);
var inst_40318 = inst_40314__$1;
var inst_40319 = null;
var state_40492__$1 = (function (){var statearr_40527 = state_40492;
(statearr_40527[(12)] = inst_40316);

(statearr_40527[(13)] = inst_40318);

(statearr_40527[(15)] = inst_40319);

(statearr_40527[(17)] = inst_40314__$1);

(statearr_40527[(18)] = inst_40317);

return statearr_40527;
})();
var statearr_40528_40626 = state_40492__$1;
(statearr_40528_40626[(2)] = null);

(statearr_40528_40626[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (22))){
var inst_40335 = (state_40492[(20)]);
var inst_40326 = (state_40492[(14)]);
var inst_40319 = (state_40492[(15)]);
var inst_40337 = fluree.db.query.analytical.outer_union(inst_40319,inst_40335);
var inst_40318 = inst_40326;
var inst_40319__$1 = inst_40337;
var state_40492__$1 = (function (){var statearr_40529 = state_40492;
(statearr_40529[(13)] = inst_40318);

(statearr_40529[(15)] = inst_40319__$1);

return statearr_40529;
})();
var statearr_40530_40627 = state_40492__$1;
(statearr_40530_40627[(2)] = null);

(statearr_40530_40627[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (36))){
var inst_40485 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40531_40628 = state_40492__$1;
(statearr_40531_40628[(2)] = inst_40485);

(statearr_40531_40628[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (41))){
var inst_40415 = cljs.core.count(clause);
var inst_40416 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_40415);
var state_40492__$1 = state_40492;
if(inst_40416){
var statearr_40532_40629 = state_40492__$1;
(statearr_40532_40629[(1)] = (44));

} else {
var statearr_40533_40630 = state_40492__$1;
(statearr_40533_40630[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (43))){
var inst_40407 = (state_40492[(21)]);
var inst_40410 = (state_40492[(2)]);
var inst_40411 = fluree.db.util.async.throw_err(inst_40410);
var inst_40412 = [inst_40411,r];
var inst_40413 = (new cljs.core.PersistentVector(null,2,(5),inst_40407,inst_40412,null));
var state_40492__$1 = state_40492;
var statearr_40534_40631 = state_40492__$1;
(statearr_40534_40631[(2)] = inst_40413);

(statearr_40534_40631[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (61))){
var inst_40472 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40535_40632 = state_40492__$1;
(statearr_40535_40632[(2)] = inst_40472);

(statearr_40535_40632[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (29))){
var inst_40289 = (state_40492[(11)]);
var inst_40372 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40289)].join('');
var inst_40373 = (new Error(inst_40372));
var inst_40374 = (function(){throw inst_40373})();
var state_40492__$1 = state_40492;
var statearr_40536_40633 = state_40492__$1;
(statearr_40536_40633[(2)] = inst_40374);

(statearr_40536_40633[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (44))){
var inst_40418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40419 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_40492__$1 = (function (){var statearr_40537 = state_40492;
(statearr_40537[(22)] = inst_40418);

return statearr_40537;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40492__$1,(47),inst_40419);
} else {
if((state_val_40493 === (6))){
var inst_40289 = (state_40492[(11)]);
var inst_40293 = (state_40492[(19)]);
var inst_40288 = cljs.core.keys(clause);
var inst_40289__$1 = cljs.core.first(inst_40288);
var inst_40293__$1 = cljs.core._EQ_;
var inst_40294 = (function (){var G__40538 = cljs.core.cst$kw$optional;
var G__40539 = inst_40289__$1;
return (inst_40293__$1.cljs$core$IFn$_invoke$arity$2 ? inst_40293__$1.cljs$core$IFn$_invoke$arity$2(G__40538,G__40539) : inst_40293__$1.call(null,G__40538,G__40539));
})();
var state_40492__$1 = (function (){var statearr_40540 = state_40492;
(statearr_40540[(11)] = inst_40289__$1);

(statearr_40540[(19)] = inst_40293__$1);

return statearr_40540;
})();
if(cljs.core.truth_(inst_40294)){
var statearr_40541_40634 = state_40492__$1;
(statearr_40541_40634[(1)] = (9));

} else {
var statearr_40542_40635 = state_40492__$1;
(statearr_40542_40635[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (28))){
var inst_40366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40367 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_40368 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_40367,optional_QMARK_);
var inst_40369 = [inst_40368,r];
var inst_40370 = (new cljs.core.PersistentVector(null,2,(5),inst_40366,inst_40369,null));
var state_40492__$1 = state_40492;
var statearr_40543_40636 = state_40492__$1;
(statearr_40543_40636[(2)] = inst_40370);

(statearr_40543_40636[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (64))){
var inst_40470 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40544_40637 = state_40492__$1;
(statearr_40544_40637[(2)] = inst_40470);

(statearr_40544_40637[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (51))){
var inst_40439 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_40492__$1 = state_40492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40492__$1,(54),inst_40439);
} else {
if((state_val_40493 === (25))){
var inst_40289 = (state_40492[(11)]);
var inst_40293 = (state_40492[(19)]);
var inst_40354 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_40355 = (function (){var segment_type = inst_40289;
var pred__40290 = inst_40293;
var expr__40291 = inst_40289;
var bindings = inst_40354;
return (function (p1__40275_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__40275_SHARP_);
});
})();
var inst_40356 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_40355,inst_40354);
var inst_40357 = cljs.core.PersistentHashMap.EMPTY;
var inst_40358 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40357,inst_40356);
var inst_40359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40360 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_40358);
var inst_40361 = [inst_40360,r];
var inst_40362 = (new cljs.core.PersistentVector(null,2,(5),inst_40359,inst_40361,null));
var state_40492__$1 = state_40492;
var statearr_40545_40638 = state_40492__$1;
(statearr_40545_40638[(2)] = inst_40362);

(statearr_40545_40638[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (34))){
var inst_40393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40394 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_40395 = [inst_40394,r];
var inst_40396 = (new cljs.core.PersistentVector(null,2,(5),inst_40393,inst_40395,null));
var state_40492__$1 = state_40492;
var statearr_40546_40639 = state_40492__$1;
(statearr_40546_40639[(2)] = inst_40396);

(statearr_40546_40639[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (17))){
var inst_40350 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40547_40640 = state_40492__$1;
(statearr_40547_40640[(2)] = inst_40350);

(statearr_40547_40640[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (3))){
var inst_40490 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40492__$1,inst_40490);
} else {
if((state_val_40493 === (12))){
var inst_40296 = (state_40492[(23)]);
var inst_40300 = (state_40492[(2)]);
var inst_40301 = fluree.db.util.async.throw_err(inst_40300);
var inst_40302 = [inst_40301,r];
var inst_40303 = (new cljs.core.PersistentVector(null,2,(5),inst_40296,inst_40302,null));
var state_40492__$1 = state_40492;
var statearr_40548_40641 = state_40492__$1;
(statearr_40548_40641[(2)] = inst_40303);

(statearr_40548_40641[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (2))){
var _ = (function (){var statearr_40549 = state_40492;
(statearr_40549[(4)] = cljs.core.cons((5),(state_40492[(4)])));

return statearr_40549;
})();
var inst_40286 = cljs.core.map_QMARK_(clause);
var state_40492__$1 = state_40492;
if(inst_40286){
var statearr_40550_40642 = state_40492__$1;
(statearr_40550_40642[(1)] = (6));

} else {
var statearr_40551_40643 = state_40492__$1;
(statearr_40551_40643[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (23))){
var inst_40335 = (state_40492[(20)]);
var inst_40326 = (state_40492[(14)]);
var inst_40318 = inst_40326;
var inst_40319 = inst_40335;
var state_40492__$1 = (function (){var statearr_40552 = state_40492;
(statearr_40552[(13)] = inst_40318);

(statearr_40552[(15)] = inst_40319);

return statearr_40552;
})();
var statearr_40553_40644 = state_40492__$1;
(statearr_40553_40644[(2)] = null);

(statearr_40553_40644[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (47))){
var inst_40418 = (state_40492[(22)]);
var inst_40421 = (state_40492[(2)]);
var inst_40422 = fluree.db.util.async.throw_err(inst_40421);
var inst_40423 = [inst_40422,r];
var inst_40424 = (new cljs.core.PersistentVector(null,2,(5),inst_40418,inst_40423,null));
var state_40492__$1 = state_40492;
var statearr_40554_40645 = state_40492__$1;
(statearr_40554_40645[(2)] = inst_40424);

(statearr_40554_40645[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (35))){
var inst_40399 = (state_40492[(24)]);
var inst_40398 = cljs.core.count(clause);
var inst_40399__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_40398);
var state_40492__$1 = (function (){var statearr_40555 = state_40492;
(statearr_40555[(24)] = inst_40399__$1);

return statearr_40555;
})();
if(inst_40399__$1){
var statearr_40556_40646 = state_40492__$1;
(statearr_40556_40646[(1)] = (37));

} else {
var statearr_40557_40647 = state_40492__$1;
(statearr_40557_40647[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (19))){
var inst_40319 = (state_40492[(15)]);
var inst_40344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40345 = [inst_40319,r];
var inst_40346 = (new cljs.core.PersistentVector(null,2,(5),inst_40344,inst_40345,null));
var state_40492__$1 = state_40492;
var statearr_40558_40648 = state_40492__$1;
(statearr_40558_40648[(2)] = inst_40346);

(statearr_40558_40648[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (57))){
var inst_40474 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40559_40649 = state_40492__$1;
(statearr_40559_40649[(2)] = inst_40474);

(statearr_40559_40649[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (11))){
var inst_40382 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40561_40650 = state_40492__$1;
(statearr_40561_40650[(2)] = inst_40382);

(statearr_40561_40650[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (9))){
var inst_40296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40297 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_40298 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_40297,res,fuel,max_fuel,opts);
var state_40492__$1 = (function (){var statearr_40562 = state_40492;
(statearr_40562[(23)] = inst_40296);

return statearr_40562;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40492__$1,(12),inst_40298);
} else {
if((state_val_40493 === (5))){
var _ = (function (){var statearr_40563 = state_40492;
(statearr_40563[(4)] = cljs.core.rest((state_40492[(4)])));

return statearr_40563;
})();
var state_40492__$1 = state_40492;
var ex40560 = (state_40492__$1[(2)]);
var statearr_40564_40651 = state_40492__$1;
(statearr_40564_40651[(5)] = ex40560);


if((ex40560 instanceof Error)){
var statearr_40565_40652 = state_40492__$1;
(statearr_40565_40652[(1)] = (4));

(statearr_40565_40652[(5)] = null);

} else {
throw ex40560;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (14))){
var inst_40289 = (state_40492[(11)]);
var inst_40293 = (state_40492[(19)]);
var inst_40352 = (function (){var G__40566 = cljs.core.cst$kw$bind;
var G__40567 = inst_40289;
return (inst_40293.cljs$core$IFn$_invoke$arity$2 ? inst_40293.cljs$core$IFn$_invoke$arity$2(G__40566,G__40567) : inst_40293.call(null,G__40566,G__40567));
})();
var state_40492__$1 = state_40492;
if(cljs.core.truth_(inst_40352)){
var statearr_40568_40653 = state_40492__$1;
(statearr_40568_40653[(1)] = (25));

} else {
var statearr_40569_40654 = state_40492__$1;
(statearr_40569_40654[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (45))){
var inst_40426 = cljs.core.count(clause);
var inst_40427 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_40426);
var state_40492__$1 = state_40492;
if(inst_40427){
var statearr_40570_40655 = state_40492__$1;
(statearr_40570_40655[(1)] = (48));

} else {
var statearr_40571_40656 = state_40492__$1;
(statearr_40571_40656[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (53))){
var inst_40477 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40572_40657 = state_40492__$1;
(statearr_40572_40657[(2)] = inst_40477);

(statearr_40572_40657[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (26))){
var inst_40289 = (state_40492[(11)]);
var inst_40293 = (state_40492[(19)]);
var inst_40364 = (function (){var G__40573 = cljs.core.cst$kw$filter;
var G__40574 = inst_40289;
return (inst_40293.cljs$core$IFn$_invoke$arity$2 ? inst_40293.cljs$core$IFn$_invoke$arity$2(G__40573,G__40574) : inst_40293.call(null,G__40573,G__40574));
})();
var state_40492__$1 = state_40492;
if(cljs.core.truth_(inst_40364)){
var statearr_40575_40658 = state_40492__$1;
(statearr_40575_40658[(1)] = (28));

} else {
var statearr_40576_40659 = state_40492__$1;
(statearr_40576_40659[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (16))){
var inst_40318 = (state_40492[(13)]);
var inst_40325 = (state_40492[(16)]);
var inst_40324 = cljs.core.seq(inst_40318);
var inst_40325__$1 = cljs.core.first(inst_40324);
var inst_40326 = cljs.core.next(inst_40324);
var state_40492__$1 = (function (){var statearr_40577 = state_40492;
(statearr_40577[(14)] = inst_40326);

(statearr_40577[(16)] = inst_40325__$1);

return statearr_40577;
})();
if(cljs.core.truth_(inst_40325__$1)){
var statearr_40578_40660 = state_40492__$1;
(statearr_40578_40660[(1)] = (18));

} else {
var statearr_40579_40661 = state_40492__$1;
(statearr_40579_40661[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (38))){
var inst_40399 = (state_40492[(24)]);
var state_40492__$1 = state_40492;
var statearr_40580_40662 = state_40492__$1;
(statearr_40580_40662[(2)] = inst_40399);

(statearr_40580_40662[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (30))){
var inst_40376 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40581_40663 = state_40492__$1;
(statearr_40581_40663[(2)] = inst_40376);

(statearr_40581_40663[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (10))){
var inst_40289 = (state_40492[(11)]);
var inst_40293 = (state_40492[(19)]);
var inst_40305 = (function (){var G__40582 = cljs.core.cst$kw$union;
var G__40583 = inst_40289;
return (inst_40293.cljs$core$IFn$_invoke$arity$2 ? inst_40293.cljs$core$IFn$_invoke$arity$2(G__40582,G__40583) : inst_40293.call(null,G__40582,G__40583));
})();
var state_40492__$1 = state_40492;
if(cljs.core.truth_(inst_40305)){
var statearr_40584_40664 = state_40492__$1;
(statearr_40584_40664[(1)] = (13));

} else {
var statearr_40585_40665 = state_40492__$1;
(statearr_40585_40665[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (18))){
var inst_40325 = (state_40492[(16)]);
var inst_40328 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_40325,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_40325,q_map,vars,fuel,max_fuel,opts));
var state_40492__$1 = state_40492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40492__$1,(21),inst_40328);
} else {
if((state_val_40493 === (52))){
var state_40492__$1 = state_40492;
var statearr_40586_40666 = state_40492__$1;
(statearr_40586_40666[(2)] = null);

(statearr_40586_40666[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (42))){
var inst_40483 = (state_40492[(2)]);
var state_40492__$1 = state_40492;
var statearr_40587_40667 = state_40492__$1;
(statearr_40587_40667[(2)] = inst_40483);

(statearr_40587_40667[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (37))){
var inst_40401 = cljs.core.second(clause);
var inst_40402 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_40401,"rdf:type");
var state_40492__$1 = state_40492;
var statearr_40588_40668 = state_40492__$1;
(statearr_40588_40668[(2)] = inst_40402);

(statearr_40588_40668[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (63))){
var state_40492__$1 = state_40492;
var statearr_40589_40669 = state_40492__$1;
(statearr_40589_40669[(2)] = null);

(statearr_40589_40669[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (8))){
var inst_40487 = (state_40492[(2)]);
var _ = (function (){var statearr_40590 = state_40492;
(statearr_40590[(4)] = cljs.core.rest((state_40492[(4)])));

return statearr_40590;
})();
var state_40492__$1 = state_40492;
var statearr_40591_40670 = state_40492__$1;
(statearr_40591_40670[(2)] = inst_40487);

(statearr_40591_40670[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40493 === (49))){
var state_40492__$1 = state_40492;
var statearr_40592_40671 = state_40492__$1;
(statearr_40592_40671[(1)] = (51));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__20477__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__20477__auto____0 = (function (){
var statearr_40594 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40594[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__20477__auto__);

(statearr_40594[(1)] = (1));

return statearr_40594;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__20477__auto____1 = (function (state_40492){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_40492);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e40595){var ex__20480__auto__ = e40595;
var statearr_40596_40672 = state_40492;
(statearr_40596_40672[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_40492[(4)]))){
var statearr_40597_40673 = state_40492;
(statearr_40597_40673[(1)] = cljs.core.first((state_40492[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__40674 = state_40492;
state_40492 = G__40674;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__20477__auto__ = function(state_40492){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__20477__auto____1.call(this,state_40492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__20477__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__20477__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_40598 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_40598[(6)] = c__20603__auto__);

return statearr_40598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__40676 = arguments.length;
switch (G__40676) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_40756){
var state_val_40757 = (state_40756[(1)]);
if((state_val_40757 === (7))){
var inst_40751 = (state_40756[(2)]);
var _ = (function (){var statearr_40758 = state_40756;
(statearr_40758[(4)] = cljs.core.rest((state_40756[(4)])));

return statearr_40758;
})();
var state_40756__$1 = state_40756;
var statearr_40759_40807 = state_40756__$1;
(statearr_40759_40807[(2)] = inst_40751);

(statearr_40759_40807[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (20))){
var inst_40716 = (state_40756[(7)]);
var inst_40728 = (state_40756[(2)]);
var inst_40698 = inst_40716;
var inst_40699 = inst_40728;
var state_40756__$1 = (function (){var statearr_40760 = state_40756;
(statearr_40760[(8)] = inst_40699);

(statearr_40760[(9)] = inst_40698);

return statearr_40760;
})();
var statearr_40761_40808 = state_40756__$1;
(statearr_40761_40808[(2)] = null);

(statearr_40761_40808[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (1))){
var state_40756__$1 = state_40756;
var statearr_40762_40809 = state_40756__$1;
(statearr_40762_40809[(2)] = null);

(statearr_40762_40809[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (24))){
var inst_40716 = (state_40756[(7)]);
var inst_40699 = (state_40756[(8)]);
var inst_40715 = (state_40756[(10)]);
var inst_40736 = fluree.db.query.analytical.inner_join(inst_40699,inst_40715);
var inst_40698 = inst_40716;
var inst_40699__$1 = inst_40736;
var state_40756__$1 = (function (){var statearr_40763 = state_40756;
(statearr_40763[(8)] = inst_40699__$1);

(statearr_40763[(9)] = inst_40698);

return statearr_40763;
})();
var statearr_40764_40810 = state_40756__$1;
(statearr_40764_40810[(2)] = null);

(statearr_40764_40810[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (4))){
var inst_40677 = (state_40756[(2)]);
var state_40756__$1 = state_40756;
var statearr_40766_40811 = state_40756__$1;
(statearr_40766_40811[(2)] = inst_40677);

(statearr_40766_40811[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (15))){
var inst_40715 = (state_40756[(10)]);
var state_40756__$1 = state_40756;
if(cljs.core.truth_(inst_40715)){
var statearr_40767_40812 = state_40756__$1;
(statearr_40767_40812[(1)] = (18));

} else {
var statearr_40768_40813 = state_40756__$1;
(statearr_40768_40813[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (21))){
var inst_40716 = (state_40756[(7)]);
var inst_40699 = (state_40756[(8)]);
var tmp40765 = inst_40699;
var inst_40698 = inst_40716;
var inst_40699__$1 = tmp40765;
var state_40756__$1 = (function (){var statearr_40769 = state_40756;
(statearr_40769[(8)] = inst_40699__$1);

(statearr_40769[(9)] = inst_40698);

return statearr_40769;
})();
var statearr_40770_40814 = state_40756__$1;
(statearr_40770_40814[(2)] = null);

(statearr_40770_40814[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (13))){
var inst_40699 = (state_40756[(8)]);
var inst_40722 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_40699,cljs.core.cst$kw$vars);
var inst_40723 = cljs.core.empty_QMARK_(inst_40722);
var state_40756__$1 = state_40756;
if(inst_40723){
var statearr_40771_40815 = state_40756__$1;
(statearr_40771_40815[(1)] = (15));

} else {
var statearr_40772_40816 = state_40756__$1;
(statearr_40772_40816[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (22))){
var state_40756__$1 = state_40756;
var statearr_40773_40817 = state_40756__$1;
(statearr_40773_40817[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (6))){
var inst_40698 = (state_40756[(9)]);
var inst_40705 = (state_40756[(11)]);
var inst_40704 = cljs.core.seq(inst_40698);
var inst_40705__$1 = cljs.core.first(inst_40704);
var inst_40706 = cljs.core.next(inst_40704);
var state_40756__$1 = (function (){var statearr_40775 = state_40756;
(statearr_40775[(12)] = inst_40706);

(statearr_40775[(11)] = inst_40705__$1);

return statearr_40775;
})();
if(cljs.core.truth_(inst_40705__$1)){
var statearr_40776_40818 = state_40756__$1;
(statearr_40776_40818[(1)] = (8));

} else {
var statearr_40777_40819 = state_40756__$1;
(statearr_40777_40819[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (25))){
var state_40756__$1 = state_40756;
var statearr_40778_40820 = state_40756__$1;
(statearr_40778_40820[(2)] = null);

(statearr_40778_40820[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (17))){
var inst_40744 = (state_40756[(2)]);
var state_40756__$1 = state_40756;
var statearr_40779_40821 = state_40756__$1;
(statearr_40779_40821[(2)] = inst_40744);

(statearr_40779_40821[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (3))){
var inst_40754 = (state_40756[(2)]);
var state_40756__$1 = state_40756;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40756__$1,inst_40754);
} else {
if((state_val_40757 === (12))){
var inst_40716 = (state_40756[(7)]);
var inst_40715 = (state_40756[(10)]);
var inst_40698 = inst_40716;
var inst_40699 = inst_40715;
var state_40756__$1 = (function (){var statearr_40780 = state_40756;
(statearr_40780[(8)] = inst_40699);

(statearr_40780[(9)] = inst_40698);

return statearr_40780;
})();
var statearr_40781_40822 = state_40756__$1;
(statearr_40781_40822[(2)] = null);

(statearr_40781_40822[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (2))){
var _ = (function (){var statearr_40782 = state_40756;
(statearr_40782[(4)] = cljs.core.cons((5),(state_40756[(4)])));

return statearr_40782;
})();
var inst_40690 = where;
var inst_40691 = cljs.core.seq(inst_40690);
var inst_40692 = cljs.core.first(inst_40691);
var inst_40693 = cljs.core.next(inst_40691);
var inst_40694 = [cljs.core.cst$kw$vars];
var inst_40695 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_40696 = [inst_40695];
var inst_40697 = cljs.core.PersistentHashMap.fromArrays(inst_40694,inst_40696);
var inst_40698 = inst_40690;
var inst_40699 = inst_40697;
var state_40756__$1 = (function (){var statearr_40783 = state_40756;
(statearr_40783[(8)] = inst_40699);

(statearr_40783[(13)] = inst_40693);

(statearr_40783[(14)] = inst_40692);

(statearr_40783[(9)] = inst_40698);

return statearr_40783;
})();
var statearr_40784_40823 = state_40756__$1;
(statearr_40784_40823[(2)] = null);

(statearr_40784_40823[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (23))){
var inst_40742 = (state_40756[(2)]);
var state_40756__$1 = state_40756;
var statearr_40785_40824 = state_40756__$1;
(statearr_40785_40824[(2)] = inst_40742);

(statearr_40785_40824[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (19))){
var inst_40699 = (state_40756[(8)]);
var state_40756__$1 = state_40756;
var statearr_40786_40825 = state_40756__$1;
(statearr_40786_40825[(2)] = inst_40699);

(statearr_40786_40825[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (11))){
var inst_40705 = (state_40756[(11)]);
var inst_40713 = (state_40756[(2)]);
var inst_40714 = fluree.db.util.async.throw_err(inst_40713);
var inst_40715 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40714,(0),null);
var inst_40716 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40714,(1),null);
var inst_40717 = cljs.core.count(inst_40705);
var inst_40718 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_40717);
var state_40756__$1 = (function (){var statearr_40788 = state_40756;
(statearr_40788[(7)] = inst_40716);

(statearr_40788[(10)] = inst_40715);

return statearr_40788;
})();
if(inst_40718){
var statearr_40789_40826 = state_40756__$1;
(statearr_40789_40826[(1)] = (12));

} else {
var statearr_40790_40827 = state_40756__$1;
(statearr_40790_40827[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (9))){
var inst_40699 = (state_40756[(8)]);
var state_40756__$1 = state_40756;
var statearr_40791_40828 = state_40756__$1;
(statearr_40791_40828[(2)] = inst_40699);

(statearr_40791_40828[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (5))){
var _ = (function (){var statearr_40792 = state_40756;
(statearr_40792[(4)] = cljs.core.rest((state_40756[(4)])));

return statearr_40792;
})();
var state_40756__$1 = state_40756;
var ex40787 = (state_40756__$1[(2)]);
var statearr_40793_40829 = state_40756__$1;
(statearr_40793_40829[(5)] = ex40787);


if((ex40787 instanceof Error)){
var statearr_40794_40830 = state_40756__$1;
(statearr_40794_40830[(1)] = (4));

(statearr_40794_40830[(5)] = null);

} else {
throw ex40787;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (14))){
var inst_40746 = (state_40756[(2)]);
var state_40756__$1 = state_40756;
var statearr_40795_40831 = state_40756__$1;
(statearr_40795_40831[(2)] = inst_40746);

(statearr_40795_40831[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (26))){
var inst_40740 = (state_40756[(2)]);
var state_40756__$1 = state_40756;
var statearr_40796_40832 = state_40756__$1;
(statearr_40796_40832[(2)] = inst_40740);

(statearr_40796_40832[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (16))){
var inst_40715 = (state_40756[(10)]);
var inst_40731 = (inst_40715 == null);
var state_40756__$1 = state_40756;
if(cljs.core.truth_(inst_40731)){
var statearr_40797_40833 = state_40756__$1;
(statearr_40797_40833[(1)] = (21));

} else {
var statearr_40798_40834 = state_40756__$1;
(statearr_40798_40834[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (10))){
var inst_40749 = (state_40756[(2)]);
var state_40756__$1 = state_40756;
var statearr_40799_40835 = state_40756__$1;
(statearr_40799_40835[(2)] = inst_40749);

(statearr_40799_40835[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (18))){
var inst_40715 = (state_40756[(10)]);
var state_40756__$1 = state_40756;
var statearr_40800_40836 = state_40756__$1;
(statearr_40800_40836[(2)] = inst_40715);

(statearr_40800_40836[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40757 === (8))){
var inst_40699 = (state_40756[(8)]);
var inst_40706 = (state_40756[(12)]);
var inst_40705 = (state_40756[(11)]);
var inst_40711 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_40699,inst_40705,inst_40706,false,fuel,max_fuel,opts);
var state_40756__$1 = state_40756;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40756__$1,(11),inst_40711);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__20477__auto__ = null;
var fluree$db$query$analytical$state_machine__20477__auto____0 = (function (){
var statearr_40801 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40801[(0)] = fluree$db$query$analytical$state_machine__20477__auto__);

(statearr_40801[(1)] = (1));

return statearr_40801;
});
var fluree$db$query$analytical$state_machine__20477__auto____1 = (function (state_40756){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_40756);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e40802){var ex__20480__auto__ = e40802;
var statearr_40803_40837 = state_40756;
(statearr_40803_40837[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_40756[(4)]))){
var statearr_40804_40838 = state_40756;
(statearr_40804_40838[(1)] = cljs.core.first((state_40756[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__40839 = state_40756;
state_40756 = G__40839;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__20477__auto__ = function(state_40756){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__20477__auto____1.call(this,state_40756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__20477__auto____0;
fluree$db$query$analytical$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__20477__auto____1;
return fluree$db$query$analytical$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_40805 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_40805[(6)] = c__20603__auto__);

return statearr_40805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_40874){
var state_val_40875 = (state_40874[(1)]);
if((state_val_40875 === (7))){
var inst_40851 = (state_40874[(7)]);
var inst_40856 = (state_40874[(8)]);
var inst_40858 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_40851,inst_40856,fuel,max_fuel,opts);
var state_40874__$1 = state_40874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40874__$1,(10),inst_40858);
} else {
if((state_val_40875 === (1))){
var state_40874__$1 = state_40874;
var statearr_40876_40901 = state_40874__$1;
(statearr_40876_40901[(2)] = null);

(statearr_40876_40901[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40875 === (4))){
var inst_40840 = (state_40874[(2)]);
var state_40874__$1 = state_40874;
var statearr_40877_40902 = state_40874__$1;
(statearr_40877_40902[(2)] = inst_40840);

(statearr_40877_40902[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40875 === (13))){
var inst_40869 = (state_40874[(2)]);
var _ = (function (){var statearr_40878 = state_40874;
(statearr_40878[(4)] = cljs.core.rest((state_40874[(4)])));

return statearr_40878;
})();
var state_40874__$1 = state_40874;
var statearr_40879_40903 = state_40874__$1;
(statearr_40879_40903[(2)] = inst_40869);

(statearr_40879_40903[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40875 === (6))){
var inst_40851 = (state_40874[(7)]);
var inst_40855 = (state_40874[(2)]);
var inst_40856 = fluree.db.util.async.throw_err(inst_40855);
var state_40874__$1 = (function (){var statearr_40880 = state_40874;
(statearr_40880[(8)] = inst_40856);

return statearr_40880;
})();
if(cljs.core.truth_(inst_40851)){
var statearr_40881_40904 = state_40874__$1;
(statearr_40881_40904[(1)] = (7));

} else {
var statearr_40882_40905 = state_40874__$1;
(statearr_40882_40905[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40875 === (3))){
var inst_40872 = (state_40874[(2)]);
var state_40874__$1 = state_40874;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40874__$1,inst_40872);
} else {
if((state_val_40875 === (12))){
var inst_40864 = (state_40874[(9)]);
var state_40874__$1 = state_40874;
var statearr_40883_40906 = state_40874__$1;
(statearr_40883_40906[(2)] = inst_40864);

(statearr_40883_40906[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40875 === (2))){
var _ = (function (){var statearr_40884 = state_40874;
(statearr_40884[(4)] = cljs.core.cons((5),(state_40874[(4)])));

return statearr_40884;
})();
var inst_40847 = q_map;
var inst_40848 = cljs.core.__destructure_map(inst_40847);
var inst_40849 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40848,cljs.core.cst$kw$vars);
var inst_40850 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40848,cljs.core.cst$kw$where);
var inst_40851 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40848,cljs.core.cst$kw$optional);
var inst_40852 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40848,cljs.core.cst$kw$filter);
var inst_40853 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_40850,q_map,inst_40849,fuel,max_fuel,opts);
var state_40874__$1 = (function (){var statearr_40885 = state_40874;
(statearr_40885[(10)] = inst_40852);

(statearr_40885[(7)] = inst_40851);

return statearr_40885;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40874__$1,(6),inst_40853);
} else {
if((state_val_40875 === (11))){
var inst_40864 = (state_40874[(9)]);
var inst_40852 = (state_40874[(10)]);
var inst_40866 = fluree.db.query.analytical.tuples__GT_filtered(inst_40864,inst_40852,null);
var state_40874__$1 = state_40874;
var statearr_40887_40907 = state_40874__$1;
(statearr_40887_40907[(2)] = inst_40866);

(statearr_40887_40907[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40875 === (9))){
var inst_40852 = (state_40874[(10)]);
var inst_40864 = (state_40874[(2)]);
var state_40874__$1 = (function (){var statearr_40888 = state_40874;
(statearr_40888[(9)] = inst_40864);

return statearr_40888;
})();
if(cljs.core.truth_(inst_40852)){
var statearr_40889_40908 = state_40874__$1;
(statearr_40889_40908[(1)] = (11));

} else {
var statearr_40890_40909 = state_40874__$1;
(statearr_40890_40909[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40875 === (5))){
var _ = (function (){var statearr_40891 = state_40874;
(statearr_40891[(4)] = cljs.core.rest((state_40874[(4)])));

return statearr_40891;
})();
var state_40874__$1 = state_40874;
var ex40886 = (state_40874__$1[(2)]);
var statearr_40892_40910 = state_40874__$1;
(statearr_40892_40910[(5)] = ex40886);


if((ex40886 instanceof Error)){
var statearr_40893_40911 = state_40874__$1;
(statearr_40893_40911[(1)] = (4));

(statearr_40893_40911[(5)] = null);

} else {
throw ex40886;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40875 === (10))){
var inst_40860 = (state_40874[(2)]);
var inst_40861 = fluree.db.util.async.throw_err(inst_40860);
var state_40874__$1 = state_40874;
var statearr_40894_40912 = state_40874__$1;
(statearr_40894_40912[(2)] = inst_40861);

(statearr_40894_40912[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40875 === (8))){
var inst_40856 = (state_40874[(8)]);
var state_40874__$1 = state_40874;
var statearr_40895_40913 = state_40874__$1;
(statearr_40895_40913[(2)] = inst_40856);

(statearr_40895_40913[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__20477__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__20477__auto____0 = (function (){
var statearr_40896 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40896[(0)] = fluree$db$query$analytical$q_$_state_machine__20477__auto__);

(statearr_40896[(1)] = (1));

return statearr_40896;
});
var fluree$db$query$analytical$q_$_state_machine__20477__auto____1 = (function (state_40874){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_40874);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e40897){var ex__20480__auto__ = e40897;
var statearr_40898_40914 = state_40874;
(statearr_40898_40914[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_40874[(4)]))){
var statearr_40899_40915 = state_40874;
(statearr_40899_40915[(1)] = cljs.core.first((state_40874[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__40916 = state_40874;
state_40874 = G__40916;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__20477__auto__ = function(state_40874){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__20477__auto____1.call(this,state_40874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__20477__auto____0;
fluree$db$query$analytical$q_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__20477__auto____1;
return fluree$db$query$analytical$q_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_40900 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_40900[(6)] = c__20603__auto__);

return statearr_40900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
