// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__42418 = arguments.length;
switch (G__42418) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__42420 = null;
var G__42420__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__42420__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__42420__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + fuel_per));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__42420 = function(result,flake){
switch(arguments.length){
case 0:
return G__42420__0.call(this);
case 1:
return G__42420__1.call(this,result);
case 2:
return G__42420__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42420.cljs$core$IFn$_invoke$arity$0 = G__42420__0;
G__42420.cljs$core$IFn$_invoke$arity$1 = G__42420__1;
G__42420.cljs$core$IFn$_invoke$arity$2 = G__42420__2;
return G__42420;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__42421 = null;
var G__42421__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__42421__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__42421__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__42421 = function(result,flakes){
switch(arguments.length){
case 0:
return G__42421__0.call(this);
case 1:
return G__42421__1.call(this,result);
case 2:
return G__42421__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42421.cljs$core$IFn$_invoke$arity$0 = G__42421__0;
G__42421.cljs$core$IFn$_invoke$arity$1 = G__42421__1;
G__42421.cljs$core$IFn$_invoke$arity$2 = G__42421__2;
return G__42421;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__42423 = res;
var G__42423__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__42422_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__42422_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__42423):G__42423);
var G__42423__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__42423__$1):G__42423__$1);
var G__42423__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__42423__$2):G__42423__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__42423__$3);
} else {
return G__42423__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__42425 = arguments.length;
switch (G__42425) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_42724){
var state_val_42725 = (state_42724[(1)]);
if((state_val_42725 === (65))){
var inst_42465 = (state_42724[(7)]);
var inst_42582 = (state_42724[(8)]);
var inst_42575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42576 = cljs.core.deref(cache);
var inst_42577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42578 = flake.o;
var inst_42579 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_42465);
var inst_42580 = [inst_42578,inst_42579];
var inst_42581 = (new cljs.core.PersistentVector(null,2,(5),inst_42577,inst_42580,null));
var inst_42582__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42576,inst_42581);
var state_42724__$1 = (function (){var statearr_42726 = state_42724;
(statearr_42726[(9)] = inst_42575);

(statearr_42726[(8)] = inst_42582__$1);

return statearr_42726;
})();
if(cljs.core.truth_(inst_42582__$1)){
var statearr_42727_42896 = state_42724__$1;
(statearr_42727_42896[(1)] = (68));

} else {
var statearr_42728_42897 = state_42724__$1;
(statearr_42728_42897[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (70))){
var inst_42575 = (state_42724[(9)]);
var inst_42600 = (state_42724[(2)]);
var inst_42601 = [inst_42600,offset_map];
var inst_42602 = (new cljs.core.PersistentVector(null,2,(5),inst_42575,inst_42601,null));
var state_42724__$1 = state_42724;
var statearr_42729_42898 = state_42724__$1;
(statearr_42729_42898[(2)] = inst_42602);

(statearr_42729_42898[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (62))){
var inst_42482 = (state_42724[(10)]);
var inst_42476 = (state_42724[(11)]);
var inst_42450 = (state_42724[(12)]);
var inst_42481 = (state_42724[(13)]);
var inst_42465 = (state_42724[(7)]);
var inst_42480 = (state_42724[(14)]);
var inst_42544 = (state_42724[(15)]);
var inst_42560 = (state_42724[(16)]);
var inst_42478 = (state_42724[(17)]);
var inst_42479 = (state_42724[(18)]);
var inst_42477 = (state_42724[(19)]);
var inst_42436 = (state_42724[(20)]);
var inst_42483 = (state_42724[(21)]);
var inst_42562 = (function (){var map__42432 = inst_42477;
var p = inst_42483;
var G__42546 = inst_42560;
var pred_spec__$1 = inst_42450;
var orderBy = inst_42481;
var nested_select_spec = inst_42544;
var multi_QMARK_ = inst_42478;
var limit = inst_42480;
var offset = inst_42482;
var k = inst_42476;
var compact_QMARK_ = inst_42436;
var pred_spec_SINGLEQUOTE_ = inst_42465;
var ref_QMARK_ = inst_42479;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_42563 = (inst_42562.cljs$core$IFn$_invoke$arity$1 ? inst_42562.cljs$core$IFn$_invoke$arity$1(inst_42560) : inst_42562.call(null,inst_42560));
var state_42724__$1 = state_42724;
var statearr_42730_42899 = state_42724__$1;
(statearr_42730_42899[(2)] = inst_42563);

(statearr_42730_42899[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (74))){
var inst_42609 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
if(cljs.core.truth_(inst_42609)){
var statearr_42731_42900 = state_42724__$1;
(statearr_42731_42900[(1)] = (75));

} else {
var statearr_42732_42901 = state_42724__$1;
(statearr_42732_42901[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (7))){
var inst_42437 = (state_42724[(22)]);
var state_42724__$1 = state_42724;
var statearr_42733_42902 = state_42724__$1;
(statearr_42733_42902[(2)] = inst_42437);

(statearr_42733_42902[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (59))){
var inst_42554 = (state_42724[(23)]);
var inst_42556 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_42557 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_42556,inst_42554);
var state_42724__$1 = state_42724;
var statearr_42734_42903 = state_42724__$1;
(statearr_42734_42903[(2)] = inst_42557);

(statearr_42734_42903[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (86))){
var inst_42482 = (state_42724[(10)]);
var inst_42476 = (state_42724[(11)]);
var inst_42450 = (state_42724[(12)]);
var inst_42622 = (state_42724[(24)]);
var inst_42481 = (state_42724[(13)]);
var inst_42465 = (state_42724[(7)]);
var inst_42480 = (state_42724[(14)]);
var inst_42640 = (state_42724[(25)]);
var inst_42478 = (state_42724[(17)]);
var inst_42479 = (state_42724[(18)]);
var inst_42477 = (state_42724[(19)]);
var inst_42436 = (state_42724[(20)]);
var inst_42483 = (state_42724[(21)]);
var inst_42642 = (function (){var map__42432 = inst_42477;
var p = inst_42483;
var pred_spec__$1 = inst_42450;
var orderBy = inst_42481;
var children = inst_42622;
var multi_QMARK_ = inst_42478;
var limit = inst_42480;
var offset = inst_42482;
var k = inst_42476;
var G__42634 = inst_42640;
var compact_QMARK_ = inst_42436;
var pred_spec_SINGLEQUOTE_ = inst_42465;
var ref_QMARK_ = inst_42479;
return (function (n){
var G__42735 = db;
var G__42736 = cache;
var G__42737 = fuel;
var G__42738 = max_fuel;
var G__42739 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$wildcard_QMARK_,true,cljs.core.cst$kw$compact_QMARK_,compact_QMARK_], null);
var G__42740 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__42735,G__42736,G__42737,G__42738,G__42739,G__42740) : fluree.db.query.fql.flakes__GT_res.call(null,G__42735,G__42736,G__42737,G__42738,G__42739,G__42740));
});
})();
var inst_42643 = (inst_42642.cljs$core$IFn$_invoke$arity$1 ? inst_42642.cljs$core$IFn$_invoke$arity$1(inst_42640) : inst_42642.call(null,inst_42640));
var state_42724__$1 = state_42724;
var statearr_42741_42904 = state_42724__$1;
(statearr_42741_42904[(2)] = inst_42643);

(statearr_42741_42904[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (20))){
var inst_42465 = (state_42724[(7)]);
var inst_42478 = (state_42724[(17)]);
var inst_42477 = (state_42724[(19)]);
var inst_42476 = (state_42724[(2)]);
var inst_42477__$1 = cljs.core.__destructure_map(inst_42465);
var inst_42478__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42477__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_42479 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42477__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_42480 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42477__$1,cljs.core.cst$kw$limit);
var inst_42481 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42477__$1,cljs.core.cst$kw$orderBy);
var inst_42482 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42477__$1,cljs.core.cst$kw$offset);
var inst_42483 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42477__$1,cljs.core.cst$kw$p);
var state_42724__$1 = (function (){var statearr_42742 = state_42724;
(statearr_42742[(10)] = inst_42482);

(statearr_42742[(11)] = inst_42476);

(statearr_42742[(13)] = inst_42481);

(statearr_42742[(14)] = inst_42480);

(statearr_42742[(17)] = inst_42478__$1);

(statearr_42742[(18)] = inst_42479);

(statearr_42742[(19)] = inst_42477__$1);

(statearr_42742[(21)] = inst_42483);

return statearr_42742;
})();
if(cljs.core.truth_(inst_42478__$1)){
var statearr_42743_42905 = state_42724__$1;
(statearr_42743_42905[(1)] = (24));

} else {
var statearr_42744_42906 = state_42724__$1;
(statearr_42744_42906[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (72))){
var inst_42465 = (state_42724[(7)]);
var inst_42606 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_42465);
var state_42724__$1 = state_42724;
var statearr_42745_42907 = state_42724__$1;
(statearr_42745_42907[(2)] = inst_42606);

(statearr_42745_42907[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (58))){
var inst_42553 = (state_42724[(2)]);
var inst_42554 = fluree.db.util.async.throw_err(inst_42553);
var state_42724__$1 = (function (){var statearr_42746 = state_42724;
(statearr_42746[(23)] = inst_42554);

return statearr_42746;
})();
if(cljs.core.truth_(fuel)){
var statearr_42747_42908 = state_42724__$1;
(statearr_42747_42908[(1)] = (59));

} else {
var statearr_42748_42909 = state_42724__$1;
(statearr_42748_42909[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (60))){
var inst_42554 = (state_42724[(23)]);
var state_42724__$1 = state_42724;
var statearr_42749_42910 = state_42724__$1;
(statearr_42749_42910[(2)] = inst_42554);

(statearr_42749_42910[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (27))){
var inst_42482 = (state_42724[(10)]);
var inst_42486 = (state_42724[(26)]);
var inst_42486__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_42482);
var state_42724__$1 = (function (){var statearr_42750 = state_42724;
(statearr_42750[(26)] = inst_42486__$1);

return statearr_42750;
})();
if(inst_42486__$1){
var statearr_42751_42911 = state_42724__$1;
(statearr_42751_42911[(1)] = (30));

} else {
var statearr_42752_42912 = state_42724__$1;
(statearr_42752_42912[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (1))){
var state_42724__$1 = state_42724;
var statearr_42753_42913 = state_42724__$1;
(statearr_42753_42913[(2)] = null);

(statearr_42753_42913[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (69))){
var inst_42465 = (state_42724[(7)]);
var inst_42585 = flake.o;
var inst_42586 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_42465);
var inst_42587 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_42585,inst_42586);
var state_42724__$1 = state_42724;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42724__$1,(71),inst_42587);
} else {
if((state_val_42725 === (101))){
var inst_42476 = (state_42724[(11)]);
var inst_42684 = (state_42724[(27)]);
var inst_42685 = (state_42724[(28)]);
var inst_42704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42705 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_42476,inst_42684);
var inst_42706 = [inst_42705,inst_42685];
var inst_42707 = (new cljs.core.PersistentVector(null,2,(5),inst_42704,inst_42706,null));
var state_42724__$1 = state_42724;
var statearr_42754_42914 = state_42724__$1;
(statearr_42754_42914[(2)] = inst_42707);

(statearr_42754_42914[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (24))){
var inst_42482 = (state_42724[(10)]);
var state_42724__$1 = state_42724;
if(cljs.core.truth_(inst_42482)){
var statearr_42755_42915 = state_42724__$1;
(statearr_42755_42915[(1)] = (27));

} else {
var statearr_42756_42916 = state_42724__$1;
(statearr_42756_42916[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (102))){
var state_42724__$1 = state_42724;
var statearr_42757_42917 = state_42724__$1;
(statearr_42757_42917[(1)] = (104));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (55))){
var inst_42465 = (state_42724[(7)]);
var inst_42573 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_42465);
var state_42724__$1 = state_42724;
if(cljs.core.truth_(inst_42573)){
var statearr_42759_42918 = state_42724__$1;
(statearr_42759_42918[(1)] = (65));

} else {
var statearr_42760_42919 = state_42724__$1;
(statearr_42760_42919[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (85))){
var inst_42640 = (state_42724[(2)]);
var state_42724__$1 = (function (){var statearr_42761 = state_42724;
(statearr_42761[(25)] = inst_42640);

return statearr_42761;
})();
var statearr_42762_42920 = state_42724__$1;
(statearr_42762_42920[(1)] = (86));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (39))){
var inst_42481 = (state_42724[(13)]);
var inst_42513 = (state_42724[(29)]);
var inst_42513__$1 = cljs.core.not(inst_42481);
var state_42724__$1 = (function (){var statearr_42764 = state_42724;
(statearr_42764[(29)] = inst_42513__$1);

return statearr_42764;
})();
if(inst_42513__$1){
var statearr_42765_42921 = state_42724__$1;
(statearr_42765_42921[(1)] = (42));

} else {
var statearr_42766_42922 = state_42724__$1;
(statearr_42766_42922[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (88))){
var inst_42646 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42724__$1,(82),inst_42646);
} else {
if((state_val_42725 === (46))){
var inst_42529 = (state_42724[(30)]);
var inst_42529__$1 = cljs.core.not(recur_QMARK_);
var state_42724__$1 = (function (){var statearr_42767 = state_42724;
(statearr_42767[(30)] = inst_42529__$1);

return statearr_42767;
})();
if(inst_42529__$1){
var statearr_42768_42923 = state_42724__$1;
(statearr_42768_42923[(1)] = (48));

} else {
var statearr_42769_42924 = state_42724__$1;
(statearr_42769_42924[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (4))){
var inst_42426 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42770_42925 = state_42724__$1;
(statearr_42770_42925[(2)] = inst_42426);

(statearr_42770_42925[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (77))){
var inst_42675 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42771_42926 = state_42724__$1;
(statearr_42771_42926[(2)] = inst_42675);

(statearr_42771_42926[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (106))){
var inst_42715 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42772_42927 = state_42724__$1;
(statearr_42772_42927[(2)] = inst_42715);

(statearr_42772_42927[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (95))){
var inst_42478 = (state_42724[(17)]);
var state_42724__$1 = state_42724;
var statearr_42773_42928 = state_42724__$1;
(statearr_42773_42928[(2)] = inst_42478);

(statearr_42773_42928[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (54))){
var inst_42465 = (state_42724[(7)]);
var inst_42541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42542 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_42543 = (new cljs.core.PersistentVector(null,3,(5),inst_42541,inst_42542,null));
var inst_42544 = cljs.core.select_keys(inst_42465,inst_42543);
var inst_42545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42547 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42548 = flake.o;
var inst_42549 = [inst_42548];
var inst_42550 = (new cljs.core.PersistentVector(null,1,(5),inst_42547,inst_42549,null));
var inst_42551 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_42550);
var state_42724__$1 = (function (){var statearr_42774 = state_42724;
(statearr_42774[(31)] = inst_42545);

(statearr_42774[(15)] = inst_42544);

return statearr_42774;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42724__$1,(58),inst_42551);
} else {
if((state_val_42725 === (92))){
var inst_42665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42666 = flake.o;
var inst_42667 = [inst_42666,offset_map];
var inst_42668 = (new cljs.core.PersistentVector(null,2,(5),inst_42665,inst_42667,null));
var state_42724__$1 = state_42724;
var statearr_42775_42929 = state_42724__$1;
(statearr_42775_42929[(2)] = inst_42668);

(statearr_42775_42929[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (104))){
var inst_42685 = (state_42724[(28)]);
var inst_42710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42711 = [acc,inst_42685];
var inst_42712 = (new cljs.core.PersistentVector(null,2,(5),inst_42710,inst_42711,null));
var state_42724__$1 = state_42724;
var statearr_42776_42930 = state_42724__$1;
(statearr_42776_42930[(2)] = inst_42712);

(statearr_42776_42930[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (15))){
var inst_42458 = (state_42724[(32)]);
var inst_42436 = (state_42724[(20)]);
var inst_42462 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42458,cljs.core.cst$kw$compact_QMARK_,inst_42436);
var state_42724__$1 = state_42724;
var statearr_42777_42931 = state_42724__$1;
(statearr_42777_42931[(2)] = inst_42462);

(statearr_42777_42931[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (48))){
var inst_42531 = (state_42724[(33)]);
var inst_42465 = (state_42724[(7)]);
var inst_42531__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_42465);
var state_42724__$1 = (function (){var statearr_42778 = state_42724;
(statearr_42778[(33)] = inst_42531__$1);

return statearr_42778;
})();
if(cljs.core.truth_(inst_42531__$1)){
var statearr_42779_42932 = state_42724__$1;
(statearr_42779_42932[(1)] = (51));

} else {
var statearr_42780_42933 = state_42724__$1;
(statearr_42780_42933[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (50))){
var inst_42539 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
if(cljs.core.truth_(inst_42539)){
var statearr_42781_42934 = state_42724__$1;
(statearr_42781_42934[(1)] = (54));

} else {
var statearr_42782_42935 = state_42724__$1;
(statearr_42782_42935[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (75))){
var inst_42465 = (state_42724[(7)]);
var inst_42611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42612 = flake.o;
var inst_42613 = [inst_42612];
var inst_42614 = (new cljs.core.PersistentVector(null,1,(5),inst_42611,inst_42613,null));
var inst_42615 = [cljs.core.cst$kw$limit];
var inst_42616 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_42465);
var inst_42617 = [inst_42616];
var inst_42618 = cljs.core.PersistentHashMap.fromArrays(inst_42615,inst_42617);
var inst_42619 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_42614,inst_42618);
var state_42724__$1 = state_42724;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42724__$1,(78),inst_42619);
} else {
if((state_val_42725 === (99))){
var inst_42684 = (state_42724[(27)]);
var inst_42701 = (inst_42684 == null);
var inst_42702 = cljs.core.not(inst_42701);
var state_42724__$1 = state_42724;
if(inst_42702){
var statearr_42783_42936 = state_42724__$1;
(statearr_42783_42936[(1)] = (101));

} else {
var statearr_42784_42937 = state_42724__$1;
(statearr_42784_42937[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (21))){
var inst_42469 = (state_42724[(34)]);
var state_42724__$1 = state_42724;
var statearr_42785_42938 = state_42724__$1;
(statearr_42785_42938[(2)] = inst_42469);

(statearr_42785_42938[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (31))){
var inst_42486 = (state_42724[(26)]);
var state_42724__$1 = state_42724;
var statearr_42786_42939 = state_42724__$1;
(statearr_42786_42939[(2)] = inst_42486);

(statearr_42786_42939[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (32))){
var inst_42492 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42787_42940 = state_42724__$1;
(statearr_42787_42940[(2)] = inst_42492);

(statearr_42787_42940[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (40))){
var inst_42478 = (state_42724[(17)]);
var state_42724__$1 = state_42724;
var statearr_42788_42941 = state_42724__$1;
(statearr_42788_42941[(2)] = inst_42478);

(statearr_42788_42941[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (91))){
var inst_42673 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42789_42942 = state_42724__$1;
(statearr_42789_42942[(2)] = inst_42673);

(statearr_42789_42942[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (56))){
var inst_42679 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42790_42943 = state_42724__$1;
(statearr_42790_42943[(2)] = inst_42679);

(statearr_42790_42943[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (33))){
var inst_42483 = (state_42724[(21)]);
var inst_42500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42501 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_42483);
var state_42724__$1 = (function (){var statearr_42791 = state_42724;
(statearr_42791[(35)] = inst_42500);

return statearr_42791;
})();
if(cljs.core.truth_(inst_42501)){
var statearr_42792_42944 = state_42724__$1;
(statearr_42792_42944[(1)] = (36));

} else {
var statearr_42793_42945 = state_42724__$1;
(statearr_42793_42945[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (13))){
var inst_42450 = (state_42724[(12)]);
var state_42724__$1 = state_42724;
var statearr_42794_42946 = state_42724__$1;
(statearr_42794_42946[(2)] = inst_42450);

(statearr_42794_42946[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (22))){
var inst_42465 = (state_42724[(7)]);
var inst_42472 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_42465);
var state_42724__$1 = state_42724;
var statearr_42795_42947 = state_42724__$1;
(statearr_42795_42947[(2)] = inst_42472);

(statearr_42795_42947[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (90))){
var state_42724__$1 = state_42724;
var statearr_42796_42948 = state_42724__$1;
(statearr_42796_42948[(1)] = (92));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (36))){
var inst_42483 = (state_42724[(21)]);
var inst_42503 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_42483,cljs.core.dec);
var state_42724__$1 = state_42724;
var statearr_42798_42949 = state_42724__$1;
(statearr_42798_42949[(2)] = inst_42503);

(statearr_42798_42949[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (41))){
var inst_42523 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
if(cljs.core.truth_(inst_42523)){
var statearr_42799_42950 = state_42724__$1;
(statearr_42799_42950[(1)] = (45));

} else {
var statearr_42800_42951 = state_42724__$1;
(statearr_42800_42951[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (89))){
var inst_42656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42657 = [cljs.core.cst$kw$_id];
var inst_42658 = flake.o;
var inst_42659 = [inst_42658];
var inst_42660 = cljs.core.PersistentHashMap.fromArrays(inst_42657,inst_42659);
var inst_42661 = [inst_42660,offset_map];
var inst_42662 = (new cljs.core.PersistentVector(null,2,(5),inst_42656,inst_42661,null));
var state_42724__$1 = state_42724;
var statearr_42801_42952 = state_42724__$1;
(statearr_42801_42952[(2)] = inst_42662);

(statearr_42801_42952[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (100))){
var inst_42719 = (state_42724[(2)]);
var _ = (function (){var statearr_42802 = state_42724;
(statearr_42802[(4)] = cljs.core.rest((state_42724[(4)])));

return statearr_42802;
})();
var state_42724__$1 = state_42724;
var statearr_42803_42953 = state_42724__$1;
(statearr_42803_42953[(2)] = inst_42719);

(statearr_42803_42953[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (43))){
var inst_42513 = (state_42724[(29)]);
var state_42724__$1 = state_42724;
var statearr_42804_42954 = state_42724__$1;
(statearr_42804_42954[(2)] = inst_42513);

(statearr_42804_42954[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (61))){
var inst_42560 = (state_42724[(2)]);
var state_42724__$1 = (function (){var statearr_42805 = state_42724;
(statearr_42805[(16)] = inst_42560);

return statearr_42805;
})();
var statearr_42806_42955 = state_42724__$1;
(statearr_42806_42955[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (29))){
var inst_42495 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42808_42956 = state_42724__$1;
(statearr_42808_42956[(2)] = inst_42495);

(statearr_42808_42956[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (44))){
var inst_42520 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42809_42957 = state_42724__$1;
(statearr_42809_42957[(2)] = inst_42520);

(statearr_42809_42957[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (93))){
var state_42724__$1 = state_42724;
var statearr_42810_42958 = state_42724__$1;
(statearr_42810_42958[(2)] = null);

(statearr_42810_42958[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (6))){
var inst_42439 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_42440 = (inst_42439 == null);
var state_42724__$1 = state_42724;
var statearr_42811_42959 = state_42724__$1;
(statearr_42811_42959[(2)] = inst_42440);

(statearr_42811_42959[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (28))){
var inst_42482 = (state_42724[(10)]);
var state_42724__$1 = state_42724;
var statearr_42812_42960 = state_42724__$1;
(statearr_42812_42960[(2)] = inst_42482);

(statearr_42812_42960[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (64))){
var inst_42566 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42724__$1,(57),inst_42566);
} else {
if((state_val_42725 === (103))){
var inst_42717 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42813_42961 = state_42724__$1;
(statearr_42813_42961[(2)] = inst_42717);

(statearr_42813_42961[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (51))){
var inst_42531 = (state_42724[(33)]);
var state_42724__$1 = state_42724;
var statearr_42814_42962 = state_42724__$1;
(statearr_42814_42962[(2)] = inst_42531);

(statearr_42814_42962[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (25))){
var inst_42478 = (state_42724[(17)]);
var state_42724__$1 = state_42724;
var statearr_42815_42963 = state_42724__$1;
(statearr_42815_42963[(2)] = inst_42478);

(statearr_42815_42963[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (34))){
var inst_42478 = (state_42724[(17)]);
var state_42724__$1 = state_42724;
if(cljs.core.truth_(inst_42478)){
var statearr_42816_42964 = state_42724__$1;
(statearr_42816_42964[(1)] = (39));

} else {
var statearr_42817_42965 = state_42724__$1;
(statearr_42817_42965[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (17))){
var inst_42466 = (state_42724[(36)]);
var inst_42465 = (state_42724[(7)]);
var inst_42465__$1 = (state_42724[(2)]);
var inst_42466__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_42465__$1);
var state_42724__$1 = (function (){var statearr_42818 = state_42724;
(statearr_42818[(36)] = inst_42466__$1);

(statearr_42818[(7)] = inst_42465__$1);

return statearr_42818;
})();
if(cljs.core.truth_(inst_42466__$1)){
var statearr_42819_42966 = state_42724__$1;
(statearr_42819_42966[(1)] = (18));

} else {
var statearr_42820_42967 = state_42724__$1;
(statearr_42820_42967[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (3))){
var inst_42722 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42724__$1,inst_42722);
} else {
if((state_val_42725 === (12))){
var inst_42450 = (state_42724[(12)]);
var inst_42455 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42450,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_42724__$1 = state_42724;
var statearr_42821_42968 = state_42724__$1;
(statearr_42821_42968[(2)] = inst_42455);

(statearr_42821_42968[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (2))){
var inst_42437 = (state_42724[(22)]);
var _ = (function (){var statearr_42822 = state_42724;
(statearr_42822[(4)] = cljs.core.cons((5),(state_42724[(4)])));

return statearr_42822;
})();
var inst_42436 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_42437__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_42724__$1 = (function (){var statearr_42823 = state_42724;
(statearr_42823[(20)] = inst_42436);

(statearr_42823[(22)] = inst_42437__$1);

return statearr_42823;
})();
if(cljs.core.truth_(inst_42437__$1)){
var statearr_42824_42969 = state_42724__$1;
(statearr_42824_42969[(1)] = (6));

} else {
var statearr_42825_42970 = state_42724__$1;
(statearr_42825_42970[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (66))){
var inst_42604 = (state_42724[(37)]);
var inst_42604__$1 = componentFollow_QMARK_;
var state_42724__$1 = (function (){var statearr_42826 = state_42724;
(statearr_42826[(37)] = inst_42604__$1);

return statearr_42826;
})();
if(cljs.core.truth_(inst_42604__$1)){
var statearr_42827_42971 = state_42724__$1;
(statearr_42827_42971[(1)] = (72));

} else {
var statearr_42828_42972 = state_42724__$1;
(statearr_42828_42972[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (23))){
var inst_42474 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42829_42973 = state_42724__$1;
(statearr_42829_42973[(2)] = inst_42474);

(statearr_42829_42973[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (47))){
var inst_42681 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42830_42974 = state_42724__$1;
(statearr_42830_42974[(2)] = inst_42681);

(statearr_42830_42974[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (35))){
var inst_42687 = (state_42724[(38)]);
var inst_42684 = (state_42724[(27)]);
var inst_42683 = (state_42724[(2)]);
var inst_42684__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42683,(0),null);
var inst_42685 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42683,(1),null);
var inst_42686 = (inst_42684__$1 == null);
var inst_42687__$1 = cljs.core.not(inst_42686);
var state_42724__$1 = (function (){var statearr_42831 = state_42724;
(statearr_42831[(38)] = inst_42687__$1);

(statearr_42831[(27)] = inst_42684__$1);

(statearr_42831[(28)] = inst_42685);

return statearr_42831;
})();
if(inst_42687__$1){
var statearr_42832_42975 = state_42724__$1;
(statearr_42832_42975[(1)] = (95));

} else {
var statearr_42833_42976 = state_42724__$1;
(statearr_42833_42976[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (82))){
var inst_42633 = (state_42724[(39)]);
var inst_42648 = (state_42724[(2)]);
var inst_42649 = fluree.db.util.async.throw_err(inst_42648);
var inst_42650 = [inst_42649,offset_map];
var inst_42651 = (new cljs.core.PersistentVector(null,2,(5),inst_42633,inst_42650,null));
var state_42724__$1 = state_42724;
var statearr_42834_42977 = state_42724__$1;
(statearr_42834_42977[(2)] = inst_42651);

(statearr_42834_42977[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (76))){
var inst_42479 = (state_42724[(18)]);
var state_42724__$1 = state_42724;
if(cljs.core.truth_(inst_42479)){
var statearr_42835_42978 = state_42724__$1;
(statearr_42835_42978[(1)] = (89));

} else {
var statearr_42836_42979 = state_42724__$1;
(statearr_42836_42979[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (97))){
var inst_42691 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
if(cljs.core.truth_(inst_42691)){
var statearr_42837_42980 = state_42724__$1;
(statearr_42837_42980[(1)] = (98));

} else {
var statearr_42838_42981 = state_42724__$1;
(statearr_42838_42981[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (19))){
var inst_42465 = (state_42724[(7)]);
var inst_42469 = (state_42724[(34)]);
var inst_42469__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_42465);
var state_42724__$1 = (function (){var statearr_42839 = state_42724;
(statearr_42839[(34)] = inst_42469__$1);

return statearr_42839;
})();
if(cljs.core.truth_(inst_42469__$1)){
var statearr_42840_42982 = state_42724__$1;
(statearr_42840_42982[(1)] = (21));

} else {
var statearr_42841_42983 = state_42724__$1;
(statearr_42841_42983[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (57))){
var inst_42545 = (state_42724[(31)]);
var inst_42568 = (state_42724[(2)]);
var inst_42569 = fluree.db.util.async.throw_err(inst_42568);
var inst_42570 = [inst_42569,offset_map];
var inst_42571 = (new cljs.core.PersistentVector(null,2,(5),inst_42545,inst_42570,null));
var state_42724__$1 = state_42724;
var statearr_42842_42984 = state_42724__$1;
(statearr_42842_42984[(2)] = inst_42571);

(statearr_42842_42984[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (68))){
var inst_42582 = (state_42724[(8)]);
var state_42724__$1 = state_42724;
var statearr_42843_42985 = state_42724__$1;
(statearr_42843_42985[(2)] = inst_42582);

(statearr_42843_42985[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (11))){
var inst_42450 = (state_42724[(12)]);
var inst_42450__$1 = (state_42724[(2)]);
var inst_42452 = cljs.core.contains_QMARK_(inst_42450__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var inst_42453 = (!(inst_42452));
var state_42724__$1 = (function (){var statearr_42845 = state_42724;
(statearr_42845[(12)] = inst_42450__$1);

return statearr_42845;
})();
if(inst_42453){
var statearr_42846_42986 = state_42724__$1;
(statearr_42846_42986[(1)] = (12));

} else {
var statearr_42847_42987 = state_42724__$1;
(statearr_42847_42987[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (9))){
var inst_42445 = flake.p;
var inst_42446 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_42447 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_42445,inst_42446);
var state_42724__$1 = state_42724;
var statearr_42848_42988 = state_42724__$1;
(statearr_42848_42988[(2)] = inst_42447);

(statearr_42848_42988[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (5))){
var _ = (function (){var statearr_42849 = state_42724;
(statearr_42849[(4)] = cljs.core.rest((state_42724[(4)])));

return statearr_42849;
})();
var state_42724__$1 = state_42724;
var ex42844 = (state_42724__$1[(2)]);
var statearr_42850_42989 = state_42724__$1;
(statearr_42850_42989[(5)] = ex42844);


if((ex42844 instanceof Error)){
var statearr_42851_42990 = state_42724__$1;
(statearr_42851_42990[(1)] = (4));

(statearr_42851_42990[(5)] = null);

} else {
throw ex42844;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (83))){
var inst_42622 = (state_42724[(24)]);
var inst_42636 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_42637 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_42636,inst_42622);
var state_42724__$1 = state_42724;
var statearr_42852_42991 = state_42724__$1;
(statearr_42852_42991[(2)] = inst_42637);

(statearr_42852_42991[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (14))){
var inst_42450 = (state_42724[(12)]);
var inst_42458 = (state_42724[(2)]);
var inst_42459 = cljs.core.contains_QMARK_(inst_42450,cljs.core.cst$kw$compact_QMARK_);
var inst_42460 = (!(inst_42459));
var state_42724__$1 = (function (){var statearr_42853 = state_42724;
(statearr_42853[(32)] = inst_42458);

return statearr_42853;
})();
if(inst_42460){
var statearr_42854_42992 = state_42724__$1;
(statearr_42854_42992[(1)] = (15));

} else {
var statearr_42855_42993 = state_42724__$1;
(statearr_42855_42993[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (45))){
var inst_42525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42526 = [null,offset_map];
var inst_42527 = (new cljs.core.PersistentVector(null,2,(5),inst_42525,inst_42526,null));
var state_42724__$1 = state_42724;
var statearr_42856_42994 = state_42724__$1;
(statearr_42856_42994[(2)] = inst_42527);

(statearr_42856_42994[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (53))){
var inst_42536 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42857_42995 = state_42724__$1;
(statearr_42857_42995[(2)] = inst_42536);

(statearr_42857_42995[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (78))){
var inst_42622 = (state_42724[(24)]);
var inst_42621 = (state_42724[(2)]);
var inst_42622__$1 = fluree.db.util.async.throw_err(inst_42621);
var inst_42623 = cljs.core.empty_QMARK_(inst_42622__$1);
var state_42724__$1 = (function (){var statearr_42858 = state_42724;
(statearr_42858[(24)] = inst_42622__$1);

return statearr_42858;
})();
if(inst_42623){
var statearr_42859_42996 = state_42724__$1;
(statearr_42859_42996[(1)] = (79));

} else {
var statearr_42860_42997 = state_42724__$1;
(statearr_42860_42997[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (26))){
var inst_42498 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
if(cljs.core.truth_(inst_42498)){
var statearr_42861_42998 = state_42724__$1;
(statearr_42861_42998[(1)] = (33));

} else {
var statearr_42862_42999 = state_42724__$1;
(statearr_42862_42999[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (16))){
var inst_42458 = (state_42724[(32)]);
var state_42724__$1 = state_42724;
var statearr_42863_43000 = state_42724__$1;
(statearr_42863_43000[(2)] = inst_42458);

(statearr_42863_43000[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (81))){
var inst_42653 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42864_43001 = state_42724__$1;
(statearr_42864_43001[(2)] = inst_42653);

(statearr_42864_43001[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (79))){
var inst_42625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42626 = [cljs.core.cst$kw$_id];
var inst_42627 = flake.o;
var inst_42628 = [inst_42627];
var inst_42629 = cljs.core.PersistentHashMap.fromArrays(inst_42626,inst_42628);
var inst_42630 = [inst_42629,offset_map];
var inst_42631 = (new cljs.core.PersistentVector(null,2,(5),inst_42625,inst_42630,null));
var state_42724__$1 = state_42724;
var statearr_42865_43002 = state_42724__$1;
(statearr_42865_43002[(2)] = inst_42631);

(statearr_42865_43002[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (38))){
var inst_42500 = (state_42724[(35)]);
var inst_42508 = (state_42724[(2)]);
var inst_42509 = [null,inst_42508];
var inst_42510 = (new cljs.core.PersistentVector(null,2,(5),inst_42500,inst_42509,null));
var state_42724__$1 = state_42724;
var statearr_42866_43003 = state_42724__$1;
(statearr_42866_43003[(2)] = inst_42510);

(statearr_42866_43003[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (98))){
var inst_42476 = (state_42724[(11)]);
var inst_42684 = (state_42724[(27)]);
var inst_42685 = (state_42724[(28)]);
var inst_42693 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42694 = cljs.core.PersistentVector.EMPTY;
var inst_42695 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_42476,inst_42694);
var inst_42696 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42695,inst_42684);
var inst_42697 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_42476,inst_42696);
var inst_42698 = [inst_42697,inst_42685];
var inst_42699 = (new cljs.core.PersistentVector(null,2,(5),inst_42693,inst_42698,null));
var state_42724__$1 = state_42724;
var statearr_42867_43004 = state_42724__$1;
(statearr_42867_43004[(2)] = inst_42699);

(statearr_42867_43004[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (87))){
var inst_42640 = (state_42724[(25)]);
var state_42724__$1 = state_42724;
var statearr_42868_43005 = state_42724__$1;
(statearr_42868_43005[(2)] = inst_42640);

(statearr_42868_43005[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (30))){
var inst_42483 = (state_42724[(21)]);
var inst_42488 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_42483);
var inst_42489 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_42488);
var state_42724__$1 = state_42724;
var statearr_42869_43006 = state_42724__$1;
(statearr_42869_43006[(2)] = inst_42489);

(statearr_42869_43006[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (73))){
var inst_42604 = (state_42724[(37)]);
var state_42724__$1 = state_42724;
var statearr_42870_43007 = state_42724__$1;
(statearr_42870_43007[(2)] = inst_42604);

(statearr_42870_43007[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (96))){
var inst_42687 = (state_42724[(38)]);
var state_42724__$1 = state_42724;
var statearr_42871_43008 = state_42724__$1;
(statearr_42871_43008[(2)] = inst_42687);

(statearr_42871_43008[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (10))){
var state_42724__$1 = state_42724;
var statearr_42872_43009 = state_42724__$1;
(statearr_42872_43009[(2)] = pred_spec);

(statearr_42872_43009[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (18))){
var inst_42466 = (state_42724[(36)]);
var state_42724__$1 = state_42724;
var statearr_42873_43010 = state_42724__$1;
(statearr_42873_43010[(2)] = inst_42466);

(statearr_42873_43010[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (105))){
var state_42724__$1 = state_42724;
var statearr_42874_43011 = state_42724__$1;
(statearr_42874_43011[(2)] = null);

(statearr_42874_43011[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (52))){
var inst_42465 = (state_42724[(7)]);
var inst_42534 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_42465);
var state_42724__$1 = state_42724;
var statearr_42875_43012 = state_42724__$1;
(statearr_42875_43012[(2)] = inst_42534);

(statearr_42875_43012[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (67))){
var inst_42677 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42876_43013 = state_42724__$1;
(statearr_42876_43013[(2)] = inst_42677);

(statearr_42876_43013[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (71))){
var inst_42465 = (state_42724[(7)]);
var inst_42589 = (state_42724[(2)]);
var inst_42590 = fluree.db.util.async.throw_err(inst_42589);
var inst_42591 = cljs.core._deref(cache);
var inst_42592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42593 = flake.o;
var inst_42594 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_42465);
var inst_42595 = [inst_42593,inst_42594];
var inst_42596 = (new cljs.core.PersistentVector(null,2,(5),inst_42592,inst_42595,null));
var inst_42597 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42591,inst_42596,inst_42590);
var inst_42598 = cljs.core._vreset_BANG_(cache,inst_42597);
var state_42724__$1 = (function (){var statearr_42877 = state_42724;
(statearr_42877[(40)] = inst_42598);

return statearr_42877;
})();
var statearr_42878_43014 = state_42724__$1;
(statearr_42878_43014[(2)] = inst_42590);

(statearr_42878_43014[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (42))){
var inst_42476 = (state_42724[(11)]);
var inst_42480 = (state_42724[(14)]);
var inst_42515 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_42476);
var inst_42516 = cljs.core.count(inst_42515);
var inst_42517 = (inst_42516 >= inst_42480);
var state_42724__$1 = state_42724;
var statearr_42879_43015 = state_42724__$1;
(statearr_42879_43015[(2)] = inst_42517);

(statearr_42879_43015[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (80))){
var inst_42633 = cljs.core.PersistentVector.EMPTY_NODE;
var state_42724__$1 = (function (){var statearr_42880 = state_42724;
(statearr_42880[(39)] = inst_42633);

return statearr_42880;
})();
if(cljs.core.truth_(fuel)){
var statearr_42881_43016 = state_42724__$1;
(statearr_42881_43016[(1)] = (83));

} else {
var statearr_42882_43017 = state_42724__$1;
(statearr_42882_43017[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (37))){
var inst_42482 = (state_42724[(10)]);
var inst_42483 = (state_42724[(21)]);
var inst_42505 = (inst_42482 - (1));
var inst_42506 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_42483,inst_42505);
var state_42724__$1 = state_42724;
var statearr_42883_43018 = state_42724__$1;
(statearr_42883_43018[(2)] = inst_42506);

(statearr_42883_43018[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (63))){
var inst_42560 = (state_42724[(16)]);
var state_42724__$1 = state_42724;
var statearr_42884_43019 = state_42724__$1;
(statearr_42884_43019[(2)] = inst_42560);

(statearr_42884_43019[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (94))){
var inst_42671 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
var statearr_42885_43020 = state_42724__$1;
(statearr_42885_43020[(2)] = inst_42671);

(statearr_42885_43020[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (8))){
var inst_42443 = (state_42724[(2)]);
var state_42724__$1 = state_42724;
if(cljs.core.truth_(inst_42443)){
var statearr_42886_43021 = state_42724__$1;
(statearr_42886_43021[(1)] = (9));

} else {
var statearr_42887_43022 = state_42724__$1;
(statearr_42887_43022[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (49))){
var inst_42529 = (state_42724[(30)]);
var state_42724__$1 = state_42724;
var statearr_42888_43023 = state_42724__$1;
(statearr_42888_43023[(2)] = inst_42529);

(statearr_42888_43023[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42725 === (84))){
var inst_42622 = (state_42724[(24)]);
var state_42724__$1 = state_42724;
var statearr_42889_43024 = state_42724__$1;
(statearr_42889_43024[(2)] = inst_42622);

(statearr_42889_43024[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__20477__auto__ = null;
var fluree$db$query$fql$state_machine__20477__auto____0 = (function (){
var statearr_42890 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42890[(0)] = fluree$db$query$fql$state_machine__20477__auto__);

(statearr_42890[(1)] = (1));

return statearr_42890;
});
var fluree$db$query$fql$state_machine__20477__auto____1 = (function (state_42724){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_42724);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e42891){var ex__20480__auto__ = e42891;
var statearr_42892_43025 = state_42724;
(statearr_42892_43025[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_42724[(4)]))){
var statearr_42893_43026 = state_42724;
(statearr_42893_43026[(1)] = cljs.core.first((state_42724[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__43027 = state_42724;
state_42724 = G__43027;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__20477__auto__ = function(state_42724){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__20477__auto____1.call(this,state_42724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__20477__auto____0;
fluree$db$query$fql$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__20477__auto____1;
return fluree$db$query$fql$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_42894 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_42894[(6)] = c__20603__auto__);

return statearr_42894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_43187){
var state_val_43188 = (state_43187[(1)]);
if((state_val_43188 === (7))){
var inst_43182 = (state_43187[(2)]);
var _ = (function (){var statearr_43189 = state_43187;
(statearr_43189[(4)] = cljs.core.rest((state_43187[(4)])));

return statearr_43189;
})();
var state_43187__$1 = state_43187;
var statearr_43190_43272 = state_43187__$1;
(statearr_43190_43272[(2)] = inst_43182);

(statearr_43190_43272[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (20))){
var inst_43109 = (state_43187[(7)]);
var state_43187__$1 = state_43187;
var statearr_43191_43273 = state_43187__$1;
(statearr_43191_43273[(2)] = inst_43109);

(statearr_43191_43273[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (27))){
var inst_43064 = (state_43187[(8)]);
var state_43187__$1 = state_43187;
if(cljs.core.truth_(inst_43064)){
var statearr_43192_43274 = state_43187__$1;
(statearr_43192_43274[(1)] = (29));

} else {
var statearr_43193_43275 = state_43187__$1;
(statearr_43193_43275[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (1))){
var state_43187__$1 = state_43187;
var statearr_43194_43276 = state_43187__$1;
(statearr_43194_43276[(2)] = null);

(statearr_43194_43276[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (24))){
var inst_43065 = (state_43187[(9)]);
var state_43187__$1 = state_43187;
var statearr_43195_43277 = state_43187__$1;
(statearr_43195_43277[(2)] = inst_43065);

(statearr_43195_43277[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (39))){
var inst_43101 = (state_43187[(10)]);
var state_43187__$1 = state_43187;
var statearr_43196_43278 = state_43187__$1;
(statearr_43196_43278[(2)] = inst_43101);

(statearr_43196_43278[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (46))){
var inst_43066 = (state_43187[(11)]);
var state_43187__$1 = state_43187;
var statearr_43197_43279 = state_43187__$1;
(statearr_43197_43279[(2)] = inst_43066);

(statearr_43197_43279[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (4))){
var inst_43028 = (state_43187[(2)]);
var state_43187__$1 = state_43187;
var statearr_43198_43280 = state_43187__$1;
(statearr_43198_43280[(2)] = inst_43028);

(statearr_43198_43280[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (15))){
var inst_43077 = (state_43187[(12)]);
var inst_43083 = cljs.core.count(inst_43077);
var inst_43084 = fluree.db.query.fql.add_fuel(fuel,inst_43083,max_fuel);
var state_43187__$1 = state_43187;
var statearr_43199_43281 = state_43187__$1;
(statearr_43199_43281[(2)] = inst_43084);

(statearr_43199_43281[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (48))){
var inst_43168 = (state_43187[(13)]);
var inst_43046 = (state_43187[(14)]);
var inst_43053 = (state_43187[(15)]);
var inst_43176 = (state_43187[(2)]);
var inst_43177 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43046,inst_43176,inst_43168);
var inst_43045 = inst_43053;
var inst_43046__$1 = inst_43177;
var state_43187__$1 = (function (){var statearr_43200 = state_43187;
(statearr_43200[(14)] = inst_43046__$1);

(statearr_43200[(16)] = inst_43045);

return statearr_43200;
})();
var statearr_43201_43282 = state_43187__$1;
(statearr_43201_43282[(2)] = null);

(statearr_43201_43282[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (50))){
var inst_43068 = (state_43187[(17)]);
var state_43187__$1 = state_43187;
var statearr_43202_43283 = state_43187__$1;
(statearr_43202_43283[(2)] = inst_43068);

(statearr_43202_43283[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (21))){
var inst_43065 = (state_43187[(9)]);
var state_43187__$1 = state_43187;
if(cljs.core.truth_(inst_43065)){
var statearr_43204_43284 = state_43187__$1;
(statearr_43204_43284[(1)] = (23));

} else {
var statearr_43205_43285 = state_43187__$1;
(statearr_43205_43285[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (31))){
var inst_43125 = (state_43187[(2)]);
var state_43187__$1 = state_43187;
if(cljs.core.truth_(inst_43125)){
var statearr_43206_43286 = state_43187__$1;
(statearr_43206_43286[(1)] = (32));

} else {
var statearr_43207_43287 = state_43187__$1;
(statearr_43207_43287[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (32))){
var inst_43108 = (state_43187[(18)]);
var inst_43101 = (state_43187[(10)]);
var inst_43100 = (state_43187[(19)]);
var inst_43127 = (inst_43100 + (1));
var tmp43203 = inst_43101;
var inst_43099 = inst_43108;
var inst_43100__$1 = inst_43127;
var inst_43101__$1 = tmp43203;
var state_43187__$1 = (function (){var statearr_43208 = state_43187;
(statearr_43208[(20)] = inst_43099);

(statearr_43208[(10)] = inst_43101__$1);

(statearr_43208[(19)] = inst_43100__$1);

return statearr_43208;
})();
var statearr_43209_43288 = state_43187__$1;
(statearr_43209_43288[(2)] = null);

(statearr_43209_43288[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (40))){
var state_43187__$1 = state_43187;
if(cljs.core.truth_(fuel)){
var statearr_43210_43289 = state_43187__$1;
(statearr_43210_43289[(1)] = (42));

} else {
var statearr_43211_43290 = state_43187__$1;
(statearr_43211_43290[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (33))){
var state_43187__$1 = state_43187;
var statearr_43212_43291 = state_43187__$1;
(statearr_43212_43291[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (13))){
var inst_43077 = (state_43187[(12)]);
var state_43187__$1 = state_43187;
var statearr_43214_43292 = state_43187__$1;
(statearr_43214_43292[(2)] = inst_43077);

(statearr_43214_43292[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (22))){
var inst_43118 = (state_43187[(2)]);
var state_43187__$1 = state_43187;
if(cljs.core.truth_(inst_43118)){
var statearr_43215_43293 = state_43187__$1;
(statearr_43215_43293[(1)] = (26));

} else {
var statearr_43216_43294 = state_43187__$1;
(statearr_43216_43294[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (36))){
var state_43187__$1 = state_43187;
var statearr_43217_43295 = state_43187__$1;
(statearr_43217_43295[(2)] = null);

(statearr_43217_43295[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (41))){
var inst_43108 = (state_43187[(18)]);
var inst_43100 = (state_43187[(19)]);
var inst_43157 = (state_43187[(2)]);
var inst_43158 = (inst_43100 + (1));
var inst_43099 = inst_43108;
var inst_43100__$1 = inst_43158;
var inst_43101 = inst_43157;
var state_43187__$1 = (function (){var statearr_43218 = state_43187;
(statearr_43218[(20)] = inst_43099);

(statearr_43218[(10)] = inst_43101);

(statearr_43218[(19)] = inst_43100__$1);

return statearr_43218;
})();
var statearr_43219_43296 = state_43187__$1;
(statearr_43219_43296[(2)] = null);

(statearr_43219_43296[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (43))){
var state_43187__$1 = state_43187;
var statearr_43220_43297 = state_43187__$1;
(statearr_43220_43297[(2)] = null);

(statearr_43220_43297[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (29))){
var inst_43064 = (state_43187[(8)]);
var inst_43100 = (state_43187[(19)]);
var inst_43122 = (inst_43100 < inst_43064);
var state_43187__$1 = state_43187;
var statearr_43221_43298 = state_43187__$1;
(statearr_43221_43298[(2)] = inst_43122);

(statearr_43221_43298[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (44))){
var inst_43137 = (state_43187[(21)]);
var inst_43141 = (state_43187[(22)]);
var inst_43150 = (state_43187[(2)]);
var inst_43151 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_43141,inst_43137) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_43141,inst_43137));
var state_43187__$1 = (function (){var statearr_43222 = state_43187;
(statearr_43222[(23)] = inst_43150);

return statearr_43222;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43187__$1,(45),inst_43151);
} else {
if((state_val_43188 === (6))){
var inst_43052 = (state_43187[(24)]);
var inst_43045 = (state_43187[(16)]);
var inst_43051 = cljs.core.seq(inst_43045);
var inst_43052__$1 = cljs.core.first(inst_43051);
var inst_43053 = cljs.core.next(inst_43051);
var inst_43054 = cljs.core.not(inst_43052__$1);
var state_43187__$1 = (function (){var statearr_43223 = state_43187;
(statearr_43223[(24)] = inst_43052__$1);

(statearr_43223[(15)] = inst_43053);

return statearr_43223;
})();
if(inst_43054){
var statearr_43224_43299 = state_43187__$1;
(statearr_43224_43299[(1)] = (8));

} else {
var statearr_43225_43300 = state_43187__$1;
(statearr_43225_43300[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (28))){
var inst_43166 = (state_43187[(2)]);
var state_43187__$1 = state_43187;
var statearr_43226_43301 = state_43187__$1;
(statearr_43226_43301[(2)] = inst_43166);

(statearr_43226_43301[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (51))){
var inst_43174 = (state_43187[(2)]);
var state_43187__$1 = state_43187;
var statearr_43227_43302 = state_43187__$1;
(statearr_43227_43302[(2)] = inst_43174);

(statearr_43227_43302[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (25))){
var inst_43116 = (state_43187[(2)]);
var state_43187__$1 = state_43187;
var statearr_43228_43303 = state_43187__$1;
(statearr_43228_43303[(2)] = inst_43116);

(statearr_43228_43303[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (34))){
var inst_43164 = (state_43187[(2)]);
var state_43187__$1 = state_43187;
var statearr_43229_43304 = state_43187__$1;
(statearr_43229_43304[(2)] = inst_43164);

(statearr_43229_43304[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (17))){
var inst_43077 = (state_43187[(12)]);
var inst_43087 = (state_43187[(2)]);
var inst_43095 = cljs.core.seq(inst_43077);
var inst_43096 = cljs.core.first(inst_43095);
var inst_43097 = cljs.core.next(inst_43095);
var inst_43098 = cljs.core.PersistentVector.EMPTY;
var inst_43099 = inst_43077;
var inst_43100 = (0);
var inst_43101 = inst_43098;
var state_43187__$1 = (function (){var statearr_43230 = state_43187;
(statearr_43230[(20)] = inst_43099);

(statearr_43230[(25)] = inst_43096);

(statearr_43230[(10)] = inst_43101);

(statearr_43230[(19)] = inst_43100);

(statearr_43230[(26)] = inst_43087);

(statearr_43230[(27)] = inst_43097);

return statearr_43230;
})();
var statearr_43231_43305 = state_43187__$1;
(statearr_43231_43305[(2)] = null);

(statearr_43231_43305[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (3))){
var inst_43185 = (state_43187[(2)]);
var state_43187__$1 = state_43187;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43187__$1,inst_43185);
} else {
if((state_val_43188 === (12))){
var state_43187__$1 = state_43187;
var statearr_43232_43306 = state_43187__$1;
(statearr_43232_43306[(2)] = fuel);

(statearr_43232_43306[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (2))){
var _ = (function (){var statearr_43233 = state_43187;
(statearr_43233[(4)] = cljs.core.cons((5),(state_43187[(4)])));

return statearr_43233;
})();
var inst_43041 = reverse_refs_specs;
var inst_43042 = cljs.core.seq(inst_43041);
var inst_43043 = cljs.core.first(inst_43042);
var inst_43044 = cljs.core.next(inst_43042);
var inst_43045 = inst_43041;
var inst_43046 = null;
var state_43187__$1 = (function (){var statearr_43234 = state_43187;
(statearr_43234[(28)] = inst_43044);

(statearr_43234[(14)] = inst_43046);

(statearr_43234[(29)] = inst_43043);

(statearr_43234[(16)] = inst_43045);

return statearr_43234;
})();
var statearr_43235_43307 = state_43187__$1;
(statearr_43235_43307[(2)] = null);

(statearr_43235_43307[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (23))){
var inst_43065 = (state_43187[(9)]);
var inst_43100 = (state_43187[(19)]);
var inst_43113 = (inst_43100 >= inst_43065);
var state_43187__$1 = state_43187;
var statearr_43236_43308 = state_43187__$1;
(statearr_43236_43308[(2)] = inst_43113);

(statearr_43236_43308[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (47))){
var inst_43067 = (state_43187[(30)]);
var state_43187__$1 = state_43187;
if(cljs.core.truth_(inst_43067)){
var statearr_43237_43309 = state_43187__$1;
(statearr_43237_43309[(1)] = (49));

} else {
var statearr_43238_43310 = state_43187__$1;
(statearr_43238_43310[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (35))){
var inst_43107 = (state_43187[(31)]);
var inst_43131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43132 = [inst_43107];
var inst_43133 = (new cljs.core.PersistentVector(null,1,(5),inst_43131,inst_43132,null));
var inst_43134 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_43133);
var state_43187__$1 = state_43187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43187__$1,(38),inst_43134);
} else {
if((state_val_43188 === (19))){
var inst_43066 = (state_43187[(11)]);
var inst_43168 = (state_43187[(2)]);
var state_43187__$1 = (function (){var statearr_43239 = state_43187;
(statearr_43239[(13)] = inst_43168);

return statearr_43239;
})();
if(cljs.core.truth_(inst_43066)){
var statearr_43240_43311 = state_43187__$1;
(statearr_43240_43311[(1)] = (46));

} else {
var statearr_43241_43312 = state_43187__$1;
(statearr_43241_43312[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (11))){
var inst_43077 = (state_43187[(12)]);
var inst_43074 = (state_43187[(2)]);
var inst_43075 = fluree.db.util.async.throw_err(inst_43074);
var inst_43076 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_43075);
var inst_43077__$1 = cljs.core.not_empty(inst_43076);
var state_43187__$1 = (function (){var statearr_43243 = state_43187;
(statearr_43243[(12)] = inst_43077__$1);

return statearr_43243;
})();
if(cljs.core.truth_(inst_43077__$1)){
var statearr_43244_43313 = state_43187__$1;
(statearr_43244_43313[(1)] = (12));

} else {
var statearr_43245_43314 = state_43187__$1;
(statearr_43245_43314[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (9))){
var inst_43052 = (state_43187[(24)]);
var inst_43062 = (state_43187[(32)]);
var inst_43061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43052,(0),null);
var inst_43062__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43052,(1),null);
var inst_43063 = cljs.core.__destructure_map(inst_43062__$1);
var inst_43064 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43063,cljs.core.cst$kw$offset);
var inst_43065 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43063,cljs.core.cst$kw$limit);
var inst_43066 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43063,cljs.core.cst$kw$as);
var inst_43067 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43063,cljs.core.cst$kw$name);
var inst_43068 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43063,cljs.core.cst$kw$p);
var inst_43069 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43070 = [subject_id,inst_43061];
var inst_43071 = (new cljs.core.PersistentVector(null,2,(5),inst_43069,inst_43070,null));
var inst_43072 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_43071);
var state_43187__$1 = (function (){var statearr_43246 = state_43187;
(statearr_43246[(32)] = inst_43062__$1);

(statearr_43246[(8)] = inst_43064);

(statearr_43246[(9)] = inst_43065);

(statearr_43246[(11)] = inst_43066);

(statearr_43246[(17)] = inst_43068);

(statearr_43246[(30)] = inst_43067);

return statearr_43246;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43187__$1,(11),inst_43072);
} else {
if((state_val_43188 === (5))){
var _ = (function (){var statearr_43247 = state_43187;
(statearr_43247[(4)] = cljs.core.rest((state_43187[(4)])));

return statearr_43247;
})();
var state_43187__$1 = state_43187;
var ex43242 = (state_43187__$1[(2)]);
var statearr_43248_43315 = state_43187__$1;
(statearr_43248_43315[(5)] = ex43242);


if((ex43242 instanceof Error)){
var statearr_43249_43316 = state_43187__$1;
(statearr_43249_43316[(1)] = (4));

(statearr_43249_43316[(5)] = null);

} else {
throw ex43242;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (14))){
var inst_43081 = (state_43187[(2)]);
var state_43187__$1 = state_43187;
if(cljs.core.truth_(inst_43081)){
var statearr_43250_43317 = state_43187__$1;
(statearr_43250_43317[(1)] = (15));

} else {
var statearr_43251_43318 = state_43187__$1;
(statearr_43251_43318[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (45))){
var inst_43101 = (state_43187[(10)]);
var inst_43153 = (state_43187[(2)]);
var inst_43154 = fluree.db.util.async.throw_err(inst_43153);
var inst_43155 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_43101,inst_43154);
var state_43187__$1 = state_43187;
var statearr_43252_43319 = state_43187__$1;
(statearr_43252_43319[(2)] = inst_43155);

(statearr_43252_43319[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (26))){
var inst_43101 = (state_43187[(10)]);
var state_43187__$1 = state_43187;
var statearr_43253_43320 = state_43187__$1;
(statearr_43253_43320[(2)] = inst_43101);

(statearr_43253_43320[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (16))){
var state_43187__$1 = state_43187;
var statearr_43254_43321 = state_43187__$1;
(statearr_43254_43321[(2)] = null);

(statearr_43254_43321[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (38))){
var inst_43062 = (state_43187[(32)]);
var inst_43137 = (state_43187[(21)]);
var inst_43136 = (state_43187[(2)]);
var inst_43137__$1 = fluree.db.util.async.throw_err(inst_43136);
var inst_43138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43139 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_43140 = (new cljs.core.PersistentVector(null,4,(5),inst_43138,inst_43139,null));
var inst_43141 = cljs.core.select_keys(inst_43062,inst_43140);
var inst_43142 = cljs.core.empty_QMARK_(inst_43137__$1);
var state_43187__$1 = (function (){var statearr_43255 = state_43187;
(statearr_43255[(21)] = inst_43137__$1);

(statearr_43255[(22)] = inst_43141);

return statearr_43255;
})();
if(inst_43142){
var statearr_43256_43322 = state_43187__$1;
(statearr_43256_43322[(1)] = (39));

} else {
var statearr_43257_43323 = state_43187__$1;
(statearr_43257_43323[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (30))){
var inst_43064 = (state_43187[(8)]);
var state_43187__$1 = state_43187;
var statearr_43258_43324 = state_43187__$1;
(statearr_43258_43324[(2)] = inst_43064);

(statearr_43258_43324[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (10))){
var inst_43180 = (state_43187[(2)]);
var state_43187__$1 = state_43187;
var statearr_43259_43325 = state_43187__$1;
(statearr_43259_43325[(2)] = inst_43180);

(statearr_43259_43325[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (18))){
var inst_43099 = (state_43187[(20)]);
var inst_43109 = (state_43187[(7)]);
var inst_43107 = (state_43187[(31)]);
var inst_43106 = cljs.core.seq(inst_43099);
var inst_43107__$1 = cljs.core.first(inst_43106);
var inst_43108 = cljs.core.next(inst_43106);
var inst_43109__$1 = cljs.core.not(inst_43107__$1);
var state_43187__$1 = (function (){var statearr_43260 = state_43187;
(statearr_43260[(7)] = inst_43109__$1);

(statearr_43260[(18)] = inst_43108);

(statearr_43260[(31)] = inst_43107__$1);

return statearr_43260;
})();
if(inst_43109__$1){
var statearr_43261_43326 = state_43187__$1;
(statearr_43261_43326[(1)] = (20));

} else {
var statearr_43262_43327 = state_43187__$1;
(statearr_43262_43327[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (42))){
var inst_43137 = (state_43187[(21)]);
var inst_43146 = cljs.core.count(inst_43137);
var inst_43147 = fluree.db.query.fql.add_fuel(fuel,inst_43146,max_fuel);
var state_43187__$1 = state_43187;
var statearr_43263_43328 = state_43187__$1;
(statearr_43263_43328[(2)] = inst_43147);

(statearr_43263_43328[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (37))){
var inst_43162 = (state_43187[(2)]);
var state_43187__$1 = state_43187;
var statearr_43264_43329 = state_43187__$1;
(statearr_43264_43329[(2)] = inst_43162);

(statearr_43264_43329[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (8))){
var inst_43046 = (state_43187[(14)]);
var state_43187__$1 = state_43187;
var statearr_43265_43330 = state_43187__$1;
(statearr_43265_43330[(2)] = inst_43046);

(statearr_43265_43330[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43188 === (49))){
var inst_43067 = (state_43187[(30)]);
var state_43187__$1 = state_43187;
var statearr_43266_43331 = state_43187__$1;
(statearr_43266_43331[(2)] = inst_43067);

(statearr_43266_43331[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__20477__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__20477__auto____0 = (function (){
var statearr_43267 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43267[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__20477__auto__);

(statearr_43267[(1)] = (1));

return statearr_43267;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__20477__auto____1 = (function (state_43187){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_43187);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e43268){var ex__20480__auto__ = e43268;
var statearr_43269_43332 = state_43187;
(statearr_43269_43332[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_43187[(4)]))){
var statearr_43270_43333 = state_43187;
(statearr_43270_43333[(1)] = cljs.core.first((state_43187[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__43334 = state_43187;
state_43187 = G__43334;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__20477__auto__ = function(state_43187){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__20477__auto____1.call(this,state_43187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__20477__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__20477__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_43271 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_43271[(6)] = c__20603__auto__);

return statearr_43271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__43335 = select_spec;
var map__43335__$1 = cljs.core.__destructure_map(map__43335);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43335__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43335__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_43397){
var state_val_43398 = (state_43397[(1)]);
if((state_val_43398 === (7))){
var inst_43361 = (state_43397[(7)]);
var inst_43363 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_43364 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_43363,inst_43361);
var state_43397__$1 = state_43397;
var statearr_43399_43438 = state_43397__$1;
(statearr_43399_43438[(2)] = inst_43364);

(statearr_43399_43438[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (20))){
var inst_43367 = (state_43397[(8)]);
var inst_43385 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_43386 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_43385,inst_43367) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_43385,inst_43367));
var state_43397__$1 = state_43397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43397__$1,(22),inst_43386);
} else {
if((state_val_43398 === (1))){
var state_43397__$1 = state_43397;
var statearr_43400_43439 = state_43397__$1;
(statearr_43400_43439[(2)] = null);

(statearr_43400_43439[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (4))){
var inst_43336 = (state_43397[(2)]);
var state_43397__$1 = state_43397;
var statearr_43401_43440 = state_43397__$1;
(statearr_43401_43440[(2)] = inst_43336);

(statearr_43401_43440[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (15))){
var inst_43374 = (state_43397[(2)]);
var state_43397__$1 = state_43397;
var statearr_43402_43441 = state_43397__$1;
(statearr_43402_43441[(2)] = inst_43374);

(statearr_43402_43441[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (21))){
var inst_43392 = (state_43397[(2)]);
var _ = (function (){var statearr_43403 = state_43397;
(statearr_43403[(4)] = cljs.core.rest((state_43397[(4)])));

return statearr_43403;
})();
var state_43397__$1 = state_43397;
var statearr_43404_43442 = state_43397__$1;
(statearr_43404_43442[(2)] = inst_43392);

(statearr_43404_43442[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (13))){
var inst_43353 = (state_43397[(9)]);
var state_43397__$1 = state_43397;
var statearr_43405_43443 = state_43397__$1;
(statearr_43405_43443[(2)] = inst_43353);

(statearr_43405_43443[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (22))){
var inst_43347 = (state_43397[(10)]);
var inst_43382 = (state_43397[(11)]);
var inst_43388 = (state_43397[(2)]);
var inst_43389 = fluree.db.util.async.throw_err(inst_43388);
var inst_43390 = (inst_43382.cljs$core$IFn$_invoke$arity$3 ? inst_43382.cljs$core$IFn$_invoke$arity$3(acc,inst_43347,inst_43389) : inst_43382.call(null,acc,inst_43347,inst_43389));
var state_43397__$1 = state_43397;
var statearr_43406_43444 = state_43397__$1;
(statearr_43406_43444[(2)] = inst_43390);

(statearr_43406_43444[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (6))){
var inst_43360 = (state_43397[(2)]);
var inst_43361 = fluree.db.util.async.throw_err(inst_43360);
var state_43397__$1 = (function (){var statearr_43407 = state_43397;
(statearr_43407[(7)] = inst_43361);

return statearr_43407;
})();
if(cljs.core.truth_(fuel)){
var statearr_43408_43445 = state_43397__$1;
(statearr_43408_43445[(1)] = (7));

} else {
var statearr_43409_43446 = state_43397__$1;
(statearr_43409_43446[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (17))){
var inst_43376 = (state_43397[(12)]);
var inst_43343 = (state_43397[(13)]);
var inst_43346 = (state_43397[(14)]);
var inst_43352 = (state_43397[(15)]);
var inst_43347 = (state_43397[(10)]);
var inst_43350 = (state_43397[(16)]);
var inst_43349 = (state_43397[(17)]);
var inst_43345 = (state_43397[(18)]);
var inst_43367 = (state_43397[(8)]);
var inst_43348 = (state_43397[(19)]);
var inst_43353 = (state_43397[(9)]);
var inst_43351 = (state_43397[(20)]);
var inst_43380 = (function (){var recur_seen = inst_43349;
var recur_subject = inst_43343;
var sub_flakes = inst_43367;
var seen_QMARK_ = inst_43352;
var multi_QMARK_ = inst_43346;
var map__43342 = inst_43345;
var limit = inst_43351;
var recur_depth = inst_43350;
var as = inst_43347;
var max_depth_QMARK_ = inst_43353;
var recur = inst_43348;
var stop_QMARK_ = inst_43376;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_43397__$1 = state_43397;
var statearr_43410_43447 = state_43397__$1;
(statearr_43410_43447[(2)] = inst_43380);

(statearr_43410_43447[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (3))){
var inst_43395 = (state_43397[(2)]);
var state_43397__$1 = state_43397;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43397__$1,inst_43395);
} else {
if((state_val_43398 === (12))){
var inst_43346 = (state_43397[(14)]);
var inst_43376 = (state_43397[(2)]);
var state_43397__$1 = (function (){var statearr_43411 = state_43397;
(statearr_43411[(12)] = inst_43376);

return statearr_43411;
})();
if(cljs.core.truth_(inst_43346)){
var statearr_43412_43448 = state_43397__$1;
(statearr_43412_43448[(1)] = (16));

} else {
var statearr_43413_43449 = state_43397__$1;
(statearr_43413_43449[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (2))){
var inst_43343 = (state_43397[(13)]);
var inst_43350 = (state_43397[(16)]);
var inst_43349 = (state_43397[(17)]);
var inst_43345 = (state_43397[(18)]);
var inst_43348 = (state_43397[(19)]);
var _ = (function (){var statearr_43414 = state_43397;
(statearr_43414[(4)] = cljs.core.cons((5),(state_43397[(4)])));

return statearr_43414;
})();
var inst_43343__$1 = flake.o;
var inst_43344 = select_spec;
var inst_43345__$1 = cljs.core.__destructure_map(inst_43344);
var inst_43346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43345__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_43347 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43345__$1,cljs.core.cst$kw$as);
var inst_43348__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43345__$1,cljs.core.cst$kw$recur);
var inst_43349__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43345__$1,cljs.core.cst$kw$recur_DASH_seen);
var inst_43350__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43345__$1,cljs.core.cst$kw$recur_DASH_depth);
var inst_43351 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43345__$1,cljs.core.cst$kw$limit);
var inst_43352 = cljs.core.contains_QMARK_(inst_43349__$1,inst_43343__$1);
var inst_43353 = (inst_43350__$1 > inst_43348__$1);
var inst_43355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43356 = [inst_43343__$1];
var inst_43357 = (new cljs.core.PersistentVector(null,1,(5),inst_43355,inst_43356,null));
var inst_43358 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_43357);
var state_43397__$1 = (function (){var statearr_43415 = state_43397;
(statearr_43415[(13)] = inst_43343__$1);

(statearr_43415[(14)] = inst_43346);

(statearr_43415[(15)] = inst_43352);

(statearr_43415[(10)] = inst_43347);

(statearr_43415[(16)] = inst_43350__$1);

(statearr_43415[(17)] = inst_43349__$1);

(statearr_43415[(18)] = inst_43345__$1);

(statearr_43415[(19)] = inst_43348__$1);

(statearr_43415[(9)] = inst_43353);

(statearr_43415[(20)] = inst_43351);

return statearr_43415;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43397__$1,(6),inst_43358);
} else {
if((state_val_43398 === (19))){
var state_43397__$1 = state_43397;
var statearr_43416_43450 = state_43397__$1;
(statearr_43416_43450[(2)] = acc);

(statearr_43416_43450[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (11))){
var inst_43353 = (state_43397[(9)]);
var state_43397__$1 = state_43397;
if(cljs.core.truth_(inst_43353)){
var statearr_43418_43451 = state_43397__$1;
(statearr_43418_43451[(1)] = (13));

} else {
var statearr_43419_43452 = state_43397__$1;
(statearr_43419_43452[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (9))){
var inst_43352 = (state_43397[(15)]);
var inst_43367 = (state_43397[(2)]);
var state_43397__$1 = (function (){var statearr_43420 = state_43397;
(statearr_43420[(8)] = inst_43367);

return statearr_43420;
})();
if(cljs.core.truth_(inst_43352)){
var statearr_43421_43453 = state_43397__$1;
(statearr_43421_43453[(1)] = (10));

} else {
var statearr_43422_43454 = state_43397__$1;
(statearr_43422_43454[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (5))){
var _ = (function (){var statearr_43423 = state_43397;
(statearr_43423[(4)] = cljs.core.rest((state_43397[(4)])));

return statearr_43423;
})();
var state_43397__$1 = state_43397;
var ex43417 = (state_43397__$1[(2)]);
var statearr_43424_43455 = state_43397__$1;
(statearr_43424_43455[(5)] = ex43417);


if((ex43417 instanceof Error)){
var statearr_43425_43456 = state_43397__$1;
(statearr_43425_43456[(1)] = (4));

(statearr_43425_43456[(5)] = null);

} else {
throw ex43417;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (14))){
var inst_43367 = (state_43397[(8)]);
var inst_43372 = cljs.core.empty_QMARK_(inst_43367);
var state_43397__$1 = state_43397;
var statearr_43426_43457 = state_43397__$1;
(statearr_43426_43457[(2)] = inst_43372);

(statearr_43426_43457[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (16))){
var inst_43376 = (state_43397[(12)]);
var inst_43343 = (state_43397[(13)]);
var inst_43346 = (state_43397[(14)]);
var inst_43352 = (state_43397[(15)]);
var inst_43347 = (state_43397[(10)]);
var inst_43350 = (state_43397[(16)]);
var inst_43349 = (state_43397[(17)]);
var inst_43345 = (state_43397[(18)]);
var inst_43367 = (state_43397[(8)]);
var inst_43348 = (state_43397[(19)]);
var inst_43353 = (state_43397[(9)]);
var inst_43351 = (state_43397[(20)]);
var inst_43378 = (function (){var recur_seen = inst_43349;
var recur_subject = inst_43343;
var sub_flakes = inst_43367;
var seen_QMARK_ = inst_43352;
var multi_QMARK_ = inst_43346;
var map__43342 = inst_43345;
var limit = inst_43351;
var recur_depth = inst_43350;
var as = inst_43347;
var max_depth_QMARK_ = inst_43353;
var recur = inst_43348;
var stop_QMARK_ = inst_43376;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_43397__$1 = state_43397;
var statearr_43427_43458 = state_43397__$1;
(statearr_43427_43458[(2)] = inst_43378);

(statearr_43427_43458[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (10))){
var inst_43352 = (state_43397[(15)]);
var state_43397__$1 = state_43397;
var statearr_43428_43459 = state_43397__$1;
(statearr_43428_43459[(2)] = inst_43352);

(statearr_43428_43459[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (18))){
var inst_43376 = (state_43397[(12)]);
var inst_43382 = (state_43397[(2)]);
var state_43397__$1 = (function (){var statearr_43429 = state_43397;
(statearr_43429[(11)] = inst_43382);

return statearr_43429;
})();
if(cljs.core.truth_(inst_43376)){
var statearr_43430_43460 = state_43397__$1;
(statearr_43430_43460[(1)] = (19));

} else {
var statearr_43431_43461 = state_43397__$1;
(statearr_43431_43461[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43398 === (8))){
var inst_43361 = (state_43397[(7)]);
var state_43397__$1 = state_43397;
var statearr_43432_43462 = state_43397__$1;
(statearr_43432_43462[(2)] = inst_43361);

(statearr_43432_43462[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__20477__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__20477__auto____0 = (function (){
var statearr_43433 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43433[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__20477__auto__);

(statearr_43433[(1)] = (1));

return statearr_43433;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__20477__auto____1 = (function (state_43397){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_43397);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e43434){var ex__20480__auto__ = e43434;
var statearr_43435_43463 = state_43397;
(statearr_43435_43463[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_43397[(4)]))){
var statearr_43436_43464 = state_43397;
(statearr_43436_43464[(1)] = cljs.core.first((state_43397[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__43465 = state_43397;
state_43397 = G__43465;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__20477__auto__ = function(state_43397){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__20477__auto____1.call(this,state_43397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__20477__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__20477__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_43437 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_43437[(6)] = c__20603__auto__);

return statearr_43437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_43643){
var state_val_43644 = (state_43643[(1)]);
if((state_val_43644 === (7))){
var state_43643__$1 = state_43643;
var statearr_43645_43731 = state_43643__$1;
(statearr_43645_43731[(2)] = null);

(statearr_43645_43731[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (20))){
var inst_43504 = cljs.core.PersistentHashMap.EMPTY;
var state_43643__$1 = state_43643;
var statearr_43646_43732 = state_43643__$1;
(statearr_43646_43732[(2)] = inst_43504);

(statearr_43646_43732[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (27))){
var inst_43522 = (state_43643[(7)]);
var inst_43492 = (state_43643[(8)]);
var inst_43486 = (state_43643[(9)]);
var inst_43506 = (state_43643[(10)]);
var inst_43622 = (state_43643[(2)]);
var inst_43623 = (function (){var top_level_subject = inst_43486;
var select_spec = inst_43492;
var base_acc = inst_43506;
var acc_PLUS_refs = inst_43522;
var result = inst_43622;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4223__auto__ = (function (){var and__4221__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_43624 = cljs.core.PersistentVector.EMPTY;
var inst_43625 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_43492);
var inst_43626 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_43625);
var inst_43627 = cljs.core.vals(inst_43626);
var inst_43628 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_43492);
var inst_43629 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_43628);
var inst_43630 = cljs.core.vals(inst_43629);
var inst_43631 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_43627,inst_43630);
var inst_43632 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_43623,inst_43624,inst_43631);
var inst_43634 = (function (){var top_level_subject = inst_43486;
var select_spec = inst_43492;
var base_acc = inst_43506;
var acc_PLUS_refs = inst_43522;
var result = inst_43622;
var sort_preds = inst_43632;
return (function (acc,p__43633){
var vec__43647 = p__43633;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43647,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43647,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43647,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43647,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_43635 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_43634,inst_43622,inst_43632);
var state_43643__$1 = state_43643;
var statearr_43650_43733 = state_43643__$1;
(statearr_43650_43733[(2)] = inst_43635);

(statearr_43650_43733[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (1))){
var state_43643__$1 = state_43643;
var statearr_43651_43734 = state_43643__$1;
(statearr_43651_43734[(2)] = null);

(statearr_43651_43734[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (24))){
var inst_43522 = (state_43643[(7)]);
var inst_43522__$1 = (state_43643[(2)]);
var inst_43523 = flakes;
var inst_43524 = cljs.core.PersistentHashMap.EMPTY;
var inst_43525 = inst_43523;
var inst_43526 = inst_43522__$1;
var inst_43527 = inst_43524;
var state_43643__$1 = (function (){var statearr_43652 = state_43643;
(statearr_43652[(11)] = inst_43526);

(statearr_43652[(7)] = inst_43522__$1);

(statearr_43652[(12)] = inst_43527);

(statearr_43652[(13)] = inst_43525);

return statearr_43652;
})();
var statearr_43653_43735 = state_43643__$1;
(statearr_43653_43735[(2)] = null);

(statearr_43653_43735[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (39))){
var inst_43526 = (state_43643[(11)]);
var inst_43535 = (state_43643[(14)]);
var inst_43492 = (state_43643[(8)]);
var inst_43541 = (state_43643[(15)]);
var inst_43570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43571 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_43526,inst_43492,inst_43535,inst_43541,false);
var state_43643__$1 = (function (){var statearr_43654 = state_43643;
(statearr_43654[(16)] = inst_43570);

return statearr_43654;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43643__$1,(42),inst_43571);
} else {
if((state_val_43644 === (46))){
var inst_43527 = (state_43643[(12)]);
var inst_43525 = (state_43643[(13)]);
var inst_43535 = (state_43643[(14)]);
var inst_43588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43589 = [cljs.core.cst$kw$_id];
var inst_43590 = inst_43535.s;
var inst_43591 = [inst_43590];
var inst_43592 = cljs.core.PersistentHashMap.fromArrays(inst_43589,inst_43591);
var inst_43593 = cljs.core.rest(inst_43525);
var inst_43594 = [inst_43592,inst_43593,inst_43527];
var inst_43595 = (new cljs.core.PersistentVector(null,3,(5),inst_43588,inst_43594,null));
var state_43643__$1 = state_43643;
var statearr_43655_43736 = state_43643__$1;
(statearr_43655_43736[(2)] = inst_43595);

(statearr_43655_43736[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (4))){
var inst_43466 = (state_43643[(2)]);
var state_43643__$1 = state_43643;
var statearr_43656_43737 = state_43643__$1;
(statearr_43656_43737[(2)] = inst_43466);

(statearr_43656_43737[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (15))){
var inst_43492 = (state_43643[(8)]);
var inst_43493 = (state_43643[(17)]);
var inst_43492__$1 = (state_43643[(2)]);
var inst_43493__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_43492__$1);
var state_43643__$1 = (function (){var statearr_43657 = state_43643;
(statearr_43657[(8)] = inst_43492__$1);

(statearr_43657[(17)] = inst_43493__$1);

return statearr_43657;
})();
if(cljs.core.truth_(inst_43493__$1)){
var statearr_43658_43738 = state_43643__$1;
(statearr_43658_43738[(1)] = (16));

} else {
var statearr_43659_43739 = state_43643__$1;
(statearr_43659_43739[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (48))){
var inst_43606 = (state_43643[(2)]);
var state_43643__$1 = state_43643;
var statearr_43660_43740 = state_43643__$1;
(statearr_43660_43740[(2)] = inst_43606);

(statearr_43660_43740[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (50))){
var state_43643__$1 = state_43643;
var statearr_43661_43741 = state_43643__$1;
(statearr_43661_43741[(2)] = null);

(statearr_43661_43741[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (21))){
var inst_43492 = (state_43643[(8)]);
var inst_43506 = (state_43643[(2)]);
var inst_43507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43508 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_43509 = (new cljs.core.PersistentVector(null,2,(5),inst_43507,inst_43508,null));
var inst_43510 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_43492,inst_43509);
var state_43643__$1 = (function (){var statearr_43662 = state_43643;
(statearr_43662[(10)] = inst_43506);

return statearr_43662;
})();
if(cljs.core.truth_(inst_43510)){
var statearr_43663_43742 = state_43643__$1;
(statearr_43663_43742[(1)] = (22));

} else {
var statearr_43664_43743 = state_43643__$1;
(statearr_43664_43743[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (31))){
var inst_43526 = (state_43643[(11)]);
var inst_43540 = (state_43643[(18)]);
var inst_43535 = (state_43643[(14)]);
var inst_43544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43545 = fluree.db.query.fql.flake__GT_recur(db,inst_43535,inst_43540,inst_43526,fuel,max_fuel,cache);
var state_43643__$1 = (function (){var statearr_43665 = state_43643;
(statearr_43665[(19)] = inst_43544);

return statearr_43665;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43643__$1,(34),inst_43545);
} else {
if((state_val_43644 === (32))){
var inst_43540 = (state_43643[(18)]);
var state_43643__$1 = state_43643;
if(cljs.core.truth_(inst_43540)){
var statearr_43666_43744 = state_43643__$1;
(statearr_43666_43744[(1)] = (35));

} else {
var statearr_43667_43745 = state_43643__$1;
(statearr_43667_43745[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (40))){
var inst_43492 = (state_43643[(8)]);
var inst_43581 = (state_43643[(20)]);
var inst_43580 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_43492);
var inst_43581__$1 = cljs.core.empty_QMARK_(inst_43580);
var state_43643__$1 = (function (){var statearr_43668 = state_43643;
(statearr_43668[(20)] = inst_43581__$1);

return statearr_43668;
})();
if(inst_43581__$1){
var statearr_43669_43746 = state_43643__$1;
(statearr_43669_43746[(1)] = (43));

} else {
var statearr_43670_43747 = state_43643__$1;
(statearr_43670_43747[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (33))){
var inst_43535 = (state_43643[(14)]);
var inst_43612 = (state_43643[(2)]);
var inst_43613 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43612,(0),null);
var inst_43614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43612,(1),null);
var inst_43615 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43612,(2),null);
var inst_43616 = inst_43535.s;
var inst_43617 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43613,cljs.core.cst$kw$_id,inst_43616);
var inst_43525 = inst_43614;
var inst_43526 = inst_43617;
var inst_43527 = inst_43615;
var state_43643__$1 = (function (){var statearr_43671 = state_43643;
(statearr_43671[(11)] = inst_43526);

(statearr_43671[(12)] = inst_43527);

(statearr_43671[(13)] = inst_43525);

return statearr_43671;
})();
var statearr_43672_43748 = state_43643__$1;
(statearr_43672_43748[(2)] = null);

(statearr_43672_43748[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (13))){
var inst_43486 = (state_43643[(9)]);
var inst_43489 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_43486);
var state_43643__$1 = state_43643;
var statearr_43673_43749 = state_43643__$1;
(statearr_43673_43749[(2)] = inst_43489);

(statearr_43673_43749[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (22))){
var inst_43492 = (state_43643[(8)]);
var inst_43512 = cljs.core.first(flakes);
var inst_43513 = fluree.db.query.fql.s(inst_43512);
var inst_43514 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_43492);
var inst_43515 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_43513,inst_43514);
var state_43643__$1 = state_43643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43643__$1,(25),inst_43515);
} else {
if((state_val_43644 === (36))){
var inst_43492 = (state_43643[(8)]);
var inst_43568 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_43492);
var state_43643__$1 = state_43643;
if(cljs.core.truth_(inst_43568)){
var statearr_43674_43750 = state_43643__$1;
(statearr_43674_43750[(1)] = (39));

} else {
var statearr_43675_43751 = state_43643__$1;
(statearr_43675_43751[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (41))){
var inst_43608 = (state_43643[(2)]);
var state_43643__$1 = state_43643;
var statearr_43676_43752 = state_43643__$1;
(statearr_43676_43752[(2)] = inst_43608);

(statearr_43676_43752[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (43))){
var inst_43492 = (state_43643[(8)]);
var inst_43583 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_43492);
var state_43643__$1 = state_43643;
var statearr_43677_43753 = state_43643__$1;
(statearr_43677_43753[(2)] = inst_43583);

(statearr_43677_43753[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (29))){
var inst_43525 = (state_43643[(13)]);
var inst_43540 = (state_43643[(18)]);
var inst_43535 = (state_43643[(14)]);
var inst_43492 = (state_43643[(8)]);
var inst_43535__$1 = cljs.core.first(inst_43525);
var inst_43536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43537 = inst_43535__$1.p;
var inst_43538 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_43537];
var inst_43539 = (new cljs.core.PersistentVector(null,3,(5),inst_43536,inst_43538,null));
var inst_43540__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_43492,inst_43539);
var inst_43541 = fluree.db.query.fql.component_follow_QMARK_(inst_43540__$1,inst_43492);
var inst_43542 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_43540__$1);
var state_43643__$1 = (function (){var statearr_43678 = state_43643;
(statearr_43678[(18)] = inst_43540__$1);

(statearr_43678[(14)] = inst_43535__$1);

(statearr_43678[(15)] = inst_43541);

return statearr_43678;
})();
if(cljs.core.truth_(inst_43542)){
var statearr_43679_43754 = state_43643__$1;
(statearr_43679_43754[(1)] = (31));

} else {
var statearr_43680_43755 = state_43643__$1;
(statearr_43680_43755[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (44))){
var inst_43581 = (state_43643[(20)]);
var state_43643__$1 = state_43643;
var statearr_43681_43756 = state_43643__$1;
(statearr_43681_43756[(2)] = inst_43581);

(statearr_43681_43756[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (6))){
var state_43643__$1 = state_43643;
var statearr_43682_43757 = state_43643__$1;
(statearr_43682_43757[(2)] = null);

(statearr_43682_43757[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (28))){
var inst_43526 = (state_43643[(11)]);
var state_43643__$1 = state_43643;
var statearr_43683_43758 = state_43643__$1;
(statearr_43683_43758[(2)] = inst_43526);

(statearr_43683_43758[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (51))){
var inst_43604 = (state_43643[(2)]);
var state_43643__$1 = state_43643;
var statearr_43684_43759 = state_43643__$1;
(statearr_43684_43759[(2)] = inst_43604);

(statearr_43684_43759[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (25))){
var inst_43506 = (state_43643[(10)]);
var inst_43517 = (state_43643[(2)]);
var inst_43518 = fluree.db.util.async.throw_err(inst_43517);
var inst_43519 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43506,inst_43518], 0));
var state_43643__$1 = state_43643;
var statearr_43685_43760 = state_43643__$1;
(statearr_43685_43760[(2)] = inst_43519);

(statearr_43685_43760[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (34))){
var inst_43527 = (state_43643[(12)]);
var inst_43525 = (state_43643[(13)]);
var inst_43544 = (state_43643[(19)]);
var inst_43547 = (state_43643[(2)]);
var inst_43548 = fluree.db.util.async.throw_err(inst_43547);
var inst_43549 = cljs.core.rest(inst_43525);
var inst_43550 = [inst_43548,inst_43549,inst_43527];
var inst_43551 = (new cljs.core.PersistentVector(null,3,(5),inst_43544,inst_43550,null));
var state_43643__$1 = state_43643;
var statearr_43686_43761 = state_43643__$1;
(statearr_43686_43761[(2)] = inst_43551);

(statearr_43686_43761[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (17))){
var inst_43492 = (state_43643[(8)]);
var inst_43496 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_43492);
var state_43643__$1 = state_43643;
var statearr_43688_43762 = state_43643__$1;
(statearr_43688_43762[(2)] = inst_43496);

(statearr_43688_43762[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (3))){
var inst_43641 = (state_43643[(2)]);
var state_43643__$1 = state_43643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43643__$1,inst_43641);
} else {
if((state_val_43644 === (12))){
var _ = (function (){var statearr_43689 = state_43643;
(statearr_43689[(4)] = cljs.core.rest((state_43643[(4)])));

return statearr_43689;
})();
var state_43643__$1 = state_43643;
var ex43687 = (state_43643__$1[(2)]);
var statearr_43690_43763 = state_43643__$1;
(statearr_43690_43763[(5)] = ex43687);


var statearr_43691_43764 = state_43643__$1;
(statearr_43691_43764[(1)] = (11));

(statearr_43691_43764[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (2))){
var _ = (function (){var statearr_43692 = state_43643;
(statearr_43692[(4)] = cljs.core.cons((5),(state_43643[(4)])));

return statearr_43692;
})();
var inst_43472 = cljs.core.not_empty(flakes);
var state_43643__$1 = state_43643;
if(cljs.core.truth_(inst_43472)){
var statearr_43693_43765 = state_43643__$1;
(statearr_43693_43765[(1)] = (6));

} else {
var statearr_43694_43766 = state_43643__$1;
(statearr_43694_43766[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (23))){
var inst_43506 = (state_43643[(10)]);
var state_43643__$1 = state_43643;
var statearr_43695_43767 = state_43643__$1;
(statearr_43695_43767[(2)] = inst_43506);

(statearr_43695_43767[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (47))){
var state_43643__$1 = state_43643;
var statearr_43696_43768 = state_43643__$1;
(statearr_43696_43768[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (35))){
var inst_43526 = (state_43643[(11)]);
var inst_43527 = (state_43643[(12)]);
var inst_43540 = (state_43643[(18)]);
var inst_43535 = (state_43643[(14)]);
var inst_43541 = (state_43643[(15)]);
var inst_43557 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_43526,inst_43540,inst_43535,inst_43541,false,inst_43527);
var state_43643__$1 = state_43643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43643__$1,(38),inst_43557);
} else {
if((state_val_43644 === (19))){
var inst_43486 = (state_43643[(9)]);
var inst_43500 = [cljs.core.cst$kw$_id];
var inst_43501 = [inst_43486];
var inst_43502 = cljs.core.PersistentHashMap.fromArrays(inst_43500,inst_43501);
var state_43643__$1 = state_43643;
var statearr_43698_43769 = state_43643__$1;
(statearr_43698_43769[(2)] = inst_43502);

(statearr_43698_43769[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (11))){
var inst_43474 = (state_43643[(2)]);
var inst_43475 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43474], 0));
var inst_43476 = (function(){throw inst_43474})();
var state_43643__$1 = (function (){var statearr_43700 = state_43643;
(statearr_43700[(21)] = inst_43475);

return statearr_43700;
})();
var statearr_43701_43770 = state_43643__$1;
(statearr_43701_43770[(2)] = inst_43476);

(statearr_43701_43770[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (9))){
var _ = (function (){var statearr_43702 = state_43643;
(statearr_43702[(4)] = cljs.core.cons((12),(state_43643[(4)])));

return statearr_43702;
})();
var inst_43482 = cljs.core.first(flakes);
var inst_43483 = fluree.db.query.fql.s(inst_43482);
var ___$1 = (function (){var statearr_43703 = state_43643;
(statearr_43703[(4)] = cljs.core.rest((state_43643[(4)])));

return statearr_43703;
})();
var state_43643__$1 = state_43643;
var statearr_43704_43771 = state_43643__$1;
(statearr_43704_43771[(2)] = inst_43483);

(statearr_43704_43771[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (5))){
var _ = (function (){var statearr_43705 = state_43643;
(statearr_43705[(4)] = cljs.core.rest((state_43643[(4)])));

return statearr_43705;
})();
var state_43643__$1 = state_43643;
var ex43699 = (state_43643__$1[(2)]);
var statearr_43706_43772 = state_43643__$1;
(statearr_43706_43772[(5)] = ex43699);


if((ex43699 instanceof Error)){
var statearr_43707_43773 = state_43643__$1;
(statearr_43707_43773[(1)] = (4));

(statearr_43707_43773[(5)] = null);

} else {
throw ex43699;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (14))){
var state_43643__$1 = state_43643;
var statearr_43708_43774 = state_43643__$1;
(statearr_43708_43774[(2)] = base_select_spec);

(statearr_43708_43774[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (45))){
var inst_43586 = (state_43643[(2)]);
var state_43643__$1 = state_43643;
if(cljs.core.truth_(inst_43586)){
var statearr_43709_43775 = state_43643__$1;
(statearr_43709_43775[(1)] = (46));

} else {
var statearr_43710_43776 = state_43643__$1;
(statearr_43710_43776[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (26))){
var inst_43525 = (state_43643[(13)]);
var inst_43529 = cljs.core.empty_QMARK_(inst_43525);
var state_43643__$1 = state_43643;
if(inst_43529){
var statearr_43711_43777 = state_43643__$1;
(statearr_43711_43777[(1)] = (28));

} else {
var statearr_43712_43778 = state_43643__$1;
(statearr_43712_43778[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (16))){
var inst_43493 = (state_43643[(17)]);
var state_43643__$1 = state_43643;
var statearr_43713_43779 = state_43643__$1;
(statearr_43713_43779[(2)] = inst_43493);

(statearr_43713_43779[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (38))){
var inst_43525 = (state_43643[(13)]);
var inst_43559 = (state_43643[(2)]);
var inst_43560 = fluree.db.util.async.throw_err(inst_43559);
var inst_43561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43560,(0),null);
var inst_43562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43560,(1),null);
var inst_43563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43564 = cljs.core.rest(inst_43525);
var inst_43565 = [inst_43561,inst_43564,inst_43562];
var inst_43566 = (new cljs.core.PersistentVector(null,3,(5),inst_43563,inst_43565,null));
var state_43643__$1 = state_43643;
var statearr_43714_43780 = state_43643__$1;
(statearr_43714_43780[(2)] = inst_43566);

(statearr_43714_43780[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (30))){
var inst_43620 = (state_43643[(2)]);
var state_43643__$1 = state_43643;
var statearr_43715_43781 = state_43643__$1;
(statearr_43715_43781[(2)] = inst_43620);

(statearr_43715_43781[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (10))){
var inst_43486 = (state_43643[(2)]);
var inst_43487 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_43643__$1 = (function (){var statearr_43716 = state_43643;
(statearr_43716[(9)] = inst_43486);

return statearr_43716;
})();
if(cljs.core.truth_(inst_43487)){
var statearr_43717_43782 = state_43643__$1;
(statearr_43717_43782[(1)] = (13));

} else {
var statearr_43718_43783 = state_43643__$1;
(statearr_43718_43783[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (18))){
var inst_43498 = (state_43643[(2)]);
var state_43643__$1 = state_43643;
if(cljs.core.truth_(inst_43498)){
var statearr_43719_43784 = state_43643__$1;
(statearr_43719_43784[(1)] = (19));

} else {
var statearr_43720_43785 = state_43643__$1;
(statearr_43720_43785[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (42))){
var inst_43527 = (state_43643[(12)]);
var inst_43525 = (state_43643[(13)]);
var inst_43570 = (state_43643[(16)]);
var inst_43573 = (state_43643[(2)]);
var inst_43574 = fluree.db.util.async.throw_err(inst_43573);
var inst_43575 = cljs.core.first(inst_43574);
var inst_43576 = cljs.core.rest(inst_43525);
var inst_43577 = [inst_43575,inst_43576,inst_43527];
var inst_43578 = (new cljs.core.PersistentVector(null,3,(5),inst_43570,inst_43577,null));
var state_43643__$1 = state_43643;
var statearr_43721_43786 = state_43643__$1;
(statearr_43721_43786[(2)] = inst_43578);

(statearr_43721_43786[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (37))){
var inst_43610 = (state_43643[(2)]);
var state_43643__$1 = state_43643;
var statearr_43722_43787 = state_43643__$1;
(statearr_43722_43787[(2)] = inst_43610);

(statearr_43722_43787[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (8))){
var inst_43638 = (state_43643[(2)]);
var _ = (function (){var statearr_43723 = state_43643;
(statearr_43723[(4)] = cljs.core.rest((state_43643[(4)])));

return statearr_43723;
})();
var state_43643__$1 = state_43643;
var statearr_43724_43788 = state_43643__$1;
(statearr_43724_43788[(2)] = inst_43638);

(statearr_43724_43788[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43644 === (49))){
var inst_43526 = (state_43643[(11)]);
var inst_43527 = (state_43643[(12)]);
var inst_43525 = (state_43643[(13)]);
var inst_43598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43599 = cljs.core.rest(inst_43525);
var inst_43600 = [inst_43526,inst_43599,inst_43527];
var inst_43601 = (new cljs.core.PersistentVector(null,3,(5),inst_43598,inst_43600,null));
var state_43643__$1 = state_43643;
var statearr_43725_43789 = state_43643__$1;
(statearr_43725_43789[(2)] = inst_43601);

(statearr_43725_43789[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__20477__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__20477__auto____0 = (function (){
var statearr_43726 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43726[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__20477__auto__);

(statearr_43726[(1)] = (1));

return statearr_43726;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__20477__auto____1 = (function (state_43643){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_43643);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e43727){var ex__20480__auto__ = e43727;
var statearr_43728_43790 = state_43643;
(statearr_43728_43790[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_43643[(4)]))){
var statearr_43729_43791 = state_43643;
(statearr_43729_43791[(1)] = cljs.core.first((state_43643[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__43792 = state_43643;
state_43643 = G__43792;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__20477__auto__ = function(state_43643){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__20477__auto____1.call(this,state_43643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__20477__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__20477__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_43730 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_43730[(6)] = c__20603__auto__);

return statearr_43730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__43795 = arguments.length;
switch (G__43795) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_43837){
var state_val_43838 = (state_43837[(1)]);
if((state_val_43838 === (7))){
var inst_43803 = (state_43837[(7)]);
var state_43837__$1 = state_43837;
var statearr_43839_43869 = state_43837__$1;
(statearr_43839_43869[(2)] = inst_43803);

(statearr_43839_43869[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43838 === (1))){
var state_43837__$1 = state_43837;
var statearr_43840_43870 = state_43837__$1;
(statearr_43840_43870[(2)] = null);

(statearr_43840_43870[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43838 === (4))){
var inst_43796 = (state_43837[(2)]);
var state_43837__$1 = state_43837;
var statearr_43841_43871 = state_43837__$1;
(statearr_43841_43871[(2)] = inst_43796);

(statearr_43841_43871[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43838 === (15))){
var inst_43831 = (state_43837[(2)]);
var inst_43832 = fluree.db.util.async.throw_err(inst_43831);
var _ = (function (){var statearr_43842 = state_43837;
(statearr_43842[(4)] = cljs.core.rest((state_43837[(4)])));

return statearr_43842;
})();
var state_43837__$1 = state_43837;
var statearr_43843_43872 = state_43837__$1;
(statearr_43843_43872[(2)] = inst_43832);

(statearr_43843_43872[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43838 === (13))){
var inst_43815 = (state_43837[(8)]);
var state_43837__$1 = state_43837;
var statearr_43844_43873 = state_43837__$1;
(statearr_43844_43873[(2)] = inst_43815);

(statearr_43844_43873[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43838 === (6))){
var inst_43803 = (state_43837[(7)]);
var inst_43805 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_43806 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_43803,inst_43805);
var state_43837__$1 = state_43837;
var statearr_43845_43874 = state_43837__$1;
(statearr_43845_43874[(2)] = inst_43806);

(statearr_43845_43874[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43838 === (3))){
var inst_43835 = (state_43837[(2)]);
var state_43837__$1 = state_43837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43837__$1,inst_43835);
} else {
if((state_val_43838 === (12))){
var inst_43815 = (state_43837[(8)]);
var inst_43817 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_43818 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_43815,inst_43817);
var state_43837__$1 = state_43837;
var statearr_43846_43875 = state_43837__$1;
(statearr_43846_43875[(2)] = inst_43818);

(statearr_43846_43875[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43838 === (2))){
var _ = (function (){var statearr_43847 = state_43837;
(statearr_43847[(4)] = cljs.core.cons((5),(state_43837[(4)])));

return statearr_43847;
})();
var inst_43803 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_43837__$1 = (function (){var statearr_43848 = state_43837;
(statearr_43848[(7)] = inst_43803);

return statearr_43848;
})();
if(cljs.core.truth_(fuel)){
var statearr_43849_43876 = state_43837__$1;
(statearr_43849_43876[(1)] = (6));

} else {
var statearr_43850_43877 = state_43837__$1;
(statearr_43850_43877[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43838 === (11))){
var inst_43815 = (state_43837[(2)]);
var state_43837__$1 = (function (){var statearr_43852 = state_43837;
(statearr_43852[(8)] = inst_43815);

return statearr_43852;
})();
if(cljs.core.truth_(limit)){
var statearr_43853_43878 = state_43837__$1;
(statearr_43853_43878[(1)] = (12));

} else {
var statearr_43854_43879 = state_43837__$1;
(statearr_43854_43879[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43838 === (9))){
var inst_43809 = (state_43837[(9)]);
var inst_43811 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_43812 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_43809,inst_43811);
var state_43837__$1 = state_43837;
var statearr_43855_43880 = state_43837__$1;
(statearr_43855_43880[(2)] = inst_43812);

(statearr_43855_43880[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43838 === (5))){
var _ = (function (){var statearr_43856 = state_43837;
(statearr_43856[(4)] = cljs.core.rest((state_43837[(4)])));

return statearr_43856;
})();
var state_43837__$1 = state_43837;
var ex43851 = (state_43837__$1[(2)]);
var statearr_43857_43881 = state_43837__$1;
(statearr_43857_43881[(5)] = ex43851);


if((ex43851 instanceof Error)){
var statearr_43858_43882 = state_43837__$1;
(statearr_43858_43882[(1)] = (4));

(statearr_43858_43882[(5)] = null);

} else {
throw ex43851;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43838 === (14))){
var inst_43821 = (state_43837[(2)]);
var inst_43822 = (function (){return (function (x){
var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4221__auto__;
}
});
})();
var inst_43823 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_43822);
var inst_43824 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_43821,inst_43823);
var inst_43825 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_43824,flakes);
var inst_43826 = cljs.core.PersistentVector.EMPTY;
var inst_43827 = (function (){var xf = inst_43824;
var flakes_by_sub = inst_43825;
return (function (p1__43793_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__43793_SHARP_);
});
})();
var inst_43828 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_43827,inst_43825);
var inst_43829 = fluree.db.util.async.merge_into_QMARK_(inst_43826,inst_43828);
var state_43837__$1 = state_43837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43837__$1,(15),inst_43829);
} else {
if((state_val_43838 === (10))){
var inst_43809 = (state_43837[(9)]);
var state_43837__$1 = state_43837;
var statearr_43859_43883 = state_43837__$1;
(statearr_43859_43883[(2)] = inst_43809);

(statearr_43859_43883[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43838 === (8))){
var inst_43809 = (state_43837[(2)]);
var state_43837__$1 = (function (){var statearr_43860 = state_43837;
(statearr_43860[(9)] = inst_43809);

return statearr_43860;
})();
if(cljs.core.truth_(offset)){
var statearr_43861_43884 = state_43837__$1;
(statearr_43861_43884[(1)] = (9));

} else {
var statearr_43862_43885 = state_43837__$1;
(statearr_43862_43885[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__20477__auto__ = null;
var fluree$db$query$fql$state_machine__20477__auto____0 = (function (){
var statearr_43863 = [null,null,null,null,null,null,null,null,null,null];
(statearr_43863[(0)] = fluree$db$query$fql$state_machine__20477__auto__);

(statearr_43863[(1)] = (1));

return statearr_43863;
});
var fluree$db$query$fql$state_machine__20477__auto____1 = (function (state_43837){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_43837);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e43864){var ex__20480__auto__ = e43864;
var statearr_43865_43886 = state_43837;
(statearr_43865_43886[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_43837[(4)]))){
var statearr_43866_43887 = state_43837;
(statearr_43866_43887[(1)] = cljs.core.first((state_43837[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__43888 = state_43837;
state_43837 = G__43888;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__20477__auto__ = function(state_43837){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__20477__auto____1.call(this,state_43837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__20477__auto____0;
fluree$db$query$fql$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__20477__auto____1;
return fluree$db$query$fql$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_43867 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_43867[(6)] = c__20603__auto__);

return statearr_43867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__43890 = arguments.length;
switch (G__43890) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_43971){
var state_val_43972 = (state_43971[(1)]);
if((state_val_43972 === (7))){
var inst_43966 = (state_43971[(2)]);
var _ = (function (){var statearr_43974 = state_43971;
(statearr_43974[(4)] = cljs.core.rest((state_43971[(4)])));

return statearr_43974;
})();
var state_43971__$1 = state_43971;
var statearr_43975_44022 = state_43971__$1;
(statearr_43975_44022[(2)] = inst_43966);

(statearr_43975_44022[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (20))){
var inst_43918 = (state_43971[(7)]);
var inst_43910 = (state_43971[(8)]);
var inst_43911 = (state_43971[(9)]);
var inst_43939 = (inst_43910 + (1));
var tmp43973 = inst_43911;
var inst_43909 = inst_43918;
var inst_43910__$1 = inst_43939;
var inst_43911__$1 = tmp43973;
var state_43971__$1 = (function (){var statearr_43976 = state_43971;
(statearr_43976[(8)] = inst_43910__$1);

(statearr_43976[(9)] = inst_43911__$1);

(statearr_43976[(10)] = inst_43909);

return statearr_43976;
})();
var statearr_43977_44023 = state_43971__$1;
(statearr_43977_44023[(2)] = null);

(statearr_43977_44023[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (27))){
var inst_43944 = (state_43971[(11)]);
var inst_43950 = (state_43971[(2)]);
var inst_43951 = fluree.db.util.async.throw_err(inst_43950);
var inst_43952 = (inst_43944.cljs$core$IFn$_invoke$arity$1 ? inst_43944.cljs$core$IFn$_invoke$arity$1(inst_43951) : inst_43944.call(null,inst_43951));
var state_43971__$1 = state_43971;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43971__$1,(26),inst_43952);
} else {
if((state_val_43972 === (1))){
var state_43971__$1 = state_43971;
var statearr_43978_44024 = state_43971__$1;
(statearr_43978_44024[(2)] = null);

(statearr_43978_44024[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (24))){
var state_43971__$1 = state_43971;
var statearr_43979_44025 = state_43971__$1;
(statearr_43979_44025[(2)] = null);

(statearr_43979_44025[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (4))){
var inst_43891 = (state_43971[(2)]);
var state_43971__$1 = state_43971;
var statearr_43980_44026 = state_43971__$1;
(statearr_43980_44026[(2)] = inst_43891);

(statearr_43980_44026[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (15))){
var inst_43932 = (state_43971[(12)]);
var inst_43932__$1 = offset;
var state_43971__$1 = (function (){var statearr_43981 = state_43971;
(statearr_43981[(12)] = inst_43932__$1);

return statearr_43981;
})();
if(cljs.core.truth_(inst_43932__$1)){
var statearr_43982_44027 = state_43971__$1;
(statearr_43982_44027[(1)] = (17));

} else {
var statearr_43983_44028 = state_43971__$1;
(statearr_43983_44028[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (21))){
var state_43971__$1 = state_43971;
var statearr_43984_44029 = state_43971__$1;
(statearr_43984_44029[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (13))){
var inst_43927 = (state_43971[(2)]);
var state_43971__$1 = state_43971;
var statearr_43986_44030 = state_43971__$1;
(statearr_43986_44030[(2)] = inst_43927);

(statearr_43986_44030[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (22))){
var inst_43962 = (state_43971[(2)]);
var state_43971__$1 = state_43971;
var statearr_43987_44031 = state_43971__$1;
(statearr_43987_44031[(2)] = inst_43962);

(statearr_43987_44031[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (6))){
var inst_43919 = (state_43971[(13)]);
var inst_43917 = (state_43971[(14)]);
var inst_43909 = (state_43971[(10)]);
var inst_43916 = cljs.core.seq(inst_43909);
var inst_43917__$1 = cljs.core.first(inst_43916);
var inst_43918 = cljs.core.next(inst_43916);
var inst_43919__$1 = (inst_43917__$1 == null);
var state_43971__$1 = (function (){var statearr_43988 = state_43971;
(statearr_43988[(13)] = inst_43919__$1);

(statearr_43988[(7)] = inst_43918);

(statearr_43988[(14)] = inst_43917__$1);

return statearr_43988;
})();
if(cljs.core.truth_(inst_43919__$1)){
var statearr_43989_44032 = state_43971__$1;
(statearr_43989_44032[(1)] = (8));

} else {
var statearr_43990_44033 = state_43971__$1;
(statearr_43990_44033[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (25))){
var inst_43960 = (state_43971[(2)]);
var state_43971__$1 = state_43971;
var statearr_43991_44034 = state_43971__$1;
(statearr_43991_44034[(2)] = inst_43960);

(statearr_43991_44034[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (17))){
var inst_43910 = (state_43971[(8)]);
var inst_43934 = (inst_43910 < offset);
var state_43971__$1 = state_43971;
var statearr_43992_44035 = state_43971__$1;
(statearr_43992_44035[(2)] = inst_43934);

(statearr_43992_44035[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (3))){
var inst_43969 = (state_43971[(2)]);
var state_43971__$1 = state_43971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43971__$1,inst_43969);
} else {
if((state_val_43972 === (12))){
var inst_43922 = (state_43971[(15)]);
var state_43971__$1 = state_43971;
var statearr_43993_44036 = state_43971__$1;
(statearr_43993_44036[(2)] = inst_43922);

(statearr_43993_44036[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (2))){
var inst_43904 = (state_43971[(16)]);
var _ = (function (){var statearr_43994 = state_43971;
(statearr_43994[(4)] = cljs.core.cons((5),(state_43971[(4)])));

return statearr_43994;
})();
var inst_43904__$1 = subjects;
var inst_43905 = cljs.core.seq(inst_43904__$1);
var inst_43906 = cljs.core.first(inst_43905);
var inst_43907 = cljs.core.next(inst_43905);
var inst_43908 = cljs.core.PersistentVector.EMPTY;
var inst_43909 = inst_43904__$1;
var inst_43910 = (0);
var inst_43911 = inst_43908;
var state_43971__$1 = (function (){var statearr_43995 = state_43971;
(statearr_43995[(8)] = inst_43910);

(statearr_43995[(9)] = inst_43911);

(statearr_43995[(16)] = inst_43904__$1);

(statearr_43995[(17)] = inst_43907);

(statearr_43995[(10)] = inst_43909);

(statearr_43995[(18)] = inst_43906);

return statearr_43995;
})();
var statearr_43996_44037 = state_43971__$1;
(statearr_43996_44037[(2)] = null);

(statearr_43996_44037[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (23))){
var inst_43918 = (state_43971[(7)]);
var inst_43910 = (state_43971[(8)]);
var inst_43917 = (state_43971[(14)]);
var inst_43911 = (state_43971[(9)]);
var inst_43904 = (state_43971[(16)]);
var inst_43907 = (state_43971[(17)]);
var inst_43909 = (state_43971[(10)]);
var inst_43906 = (state_43971[(18)]);
var inst_43943 = (inst_43910 + (1));
var inst_43944 = (function (){var first__43915 = inst_43917;
var G__43900 = inst_43909;
var r = inst_43918;
var seq__43902 = inst_43907;
var acc = inst_43911;
var seq__43914 = inst_43918;
var n = inst_43910;
var s = inst_43917;
var first__43903 = inst_43906;
var vec__43901 = inst_43904;
var vec__43913 = inst_43909;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_43945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43946 = [inst_43917];
var inst_43947 = (new cljs.core.PersistentVector(null,1,(5),inst_43945,inst_43946,null));
var inst_43948 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_43947);
var state_43971__$1 = (function (){var statearr_43997 = state_43971;
(statearr_43997[(19)] = inst_43943);

(statearr_43997[(11)] = inst_43944);

return statearr_43997;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43971__$1,(27),inst_43948);
} else {
if((state_val_43972 === (19))){
var inst_43937 = (state_43971[(2)]);
var state_43971__$1 = state_43971;
if(cljs.core.truth_(inst_43937)){
var statearr_43998_44038 = state_43971__$1;
(statearr_43998_44038[(1)] = (20));

} else {
var statearr_43999_44039 = state_43971__$1;
(statearr_43999_44039[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (11))){
var inst_43910 = (state_43971[(8)]);
var inst_43924 = (inst_43910 > limit);
var state_43971__$1 = state_43971;
var statearr_44001_44040 = state_43971__$1;
(statearr_44001_44040[(2)] = inst_43924);

(statearr_44001_44040[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (9))){
var inst_43922 = (state_43971[(15)]);
var inst_43922__$1 = limit;
var state_43971__$1 = (function (){var statearr_44002 = state_43971;
(statearr_44002[(15)] = inst_43922__$1);

return statearr_44002;
})();
if(cljs.core.truth_(inst_43922__$1)){
var statearr_44003_44041 = state_43971__$1;
(statearr_44003_44041[(1)] = (11));

} else {
var statearr_44004_44042 = state_43971__$1;
(statearr_44004_44042[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (5))){
var _ = (function (){var statearr_44005 = state_43971;
(statearr_44005[(4)] = cljs.core.rest((state_43971[(4)])));

return statearr_44005;
})();
var state_43971__$1 = state_43971;
var ex44000 = (state_43971__$1[(2)]);
var statearr_44006_44043 = state_43971__$1;
(statearr_44006_44043[(5)] = ex44000);


if((ex44000 instanceof Error)){
var statearr_44007_44044 = state_43971__$1;
(statearr_44007_44044[(1)] = (4));

(statearr_44007_44044[(5)] = null);

} else {
throw ex44000;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (14))){
var inst_43911 = (state_43971[(9)]);
var state_43971__$1 = state_43971;
var statearr_44008_44045 = state_43971__$1;
(statearr_44008_44045[(2)] = inst_43911);

(statearr_44008_44045[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (26))){
var inst_43918 = (state_43971[(7)]);
var inst_43911 = (state_43971[(9)]);
var inst_43943 = (state_43971[(19)]);
var inst_43954 = (state_43971[(2)]);
var inst_43955 = fluree.db.util.async.throw_err(inst_43954);
var inst_43956 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_43911,inst_43955);
var inst_43909 = inst_43918;
var inst_43910 = inst_43943;
var inst_43911__$1 = inst_43956;
var state_43971__$1 = (function (){var statearr_44009 = state_43971;
(statearr_44009[(8)] = inst_43910);

(statearr_44009[(9)] = inst_43911__$1);

(statearr_44009[(10)] = inst_43909);

return statearr_44009;
})();
var statearr_44010_44046 = state_43971__$1;
(statearr_44010_44046[(2)] = null);

(statearr_44010_44046[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (16))){
var inst_43964 = (state_43971[(2)]);
var state_43971__$1 = state_43971;
var statearr_44011_44047 = state_43971__$1;
(statearr_44011_44047[(2)] = inst_43964);

(statearr_44011_44047[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (10))){
var inst_43929 = (state_43971[(2)]);
var state_43971__$1 = state_43971;
if(cljs.core.truth_(inst_43929)){
var statearr_44012_44048 = state_43971__$1;
(statearr_44012_44048[(1)] = (14));

} else {
var statearr_44013_44049 = state_43971__$1;
(statearr_44013_44049[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (18))){
var inst_43932 = (state_43971[(12)]);
var state_43971__$1 = state_43971;
var statearr_44014_44050 = state_43971__$1;
(statearr_44014_44050[(2)] = inst_43932);

(statearr_44014_44050[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43972 === (8))){
var inst_43919 = (state_43971[(13)]);
var state_43971__$1 = state_43971;
var statearr_44015_44051 = state_43971__$1;
(statearr_44015_44051[(2)] = inst_43919);

(statearr_44015_44051[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__20477__auto__ = null;
var fluree$db$query$fql$state_machine__20477__auto____0 = (function (){
var statearr_44016 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44016[(0)] = fluree$db$query$fql$state_machine__20477__auto__);

(statearr_44016[(1)] = (1));

return statearr_44016;
});
var fluree$db$query$fql$state_machine__20477__auto____1 = (function (state_43971){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_43971);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e44017){var ex__20480__auto__ = e44017;
var statearr_44018_44052 = state_43971;
(statearr_44018_44052[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_43971[(4)]))){
var statearr_44019_44053 = state_43971;
(statearr_44019_44053[(1)] = cljs.core.first((state_43971[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__44054 = state_43971;
state_43971 = G__44054;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__20477__auto__ = function(state_43971){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__20477__auto____1.call(this,state_43971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__20477__auto____0;
fluree$db$query$fql$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__20477__auto____1;
return fluree$db$query$fql$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_44020 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_44020[(6)] = c__20603__auto__);

return statearr_44020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4223__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__44056 = arguments.length;
switch (G__44056) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_44247){
var state_val_44248 = (state_44247[(1)]);
if((state_val_44248 === (7))){
var state_44247__$1 = state_44247;
var statearr_44249_44324 = state_44247__$1;
(statearr_44249_44324[(2)] = null);

(statearr_44249_44324[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (20))){
var inst_44097 = (state_44247[(7)]);
var inst_44099 = (state_44247[(8)]);
var inst_44127 = (state_44247[(2)]);
var inst_44128 = fluree.db.util.async.throw_err(inst_44127);
var inst_44129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44130 = [inst_44097];
var inst_44131 = (new cljs.core.PersistentVector(null,1,(5),inst_44129,inst_44130,null));
var inst_44132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44133 = [inst_44097,inst_44099];
var inst_44134 = (new cljs.core.PersistentVector(null,2,(5),inst_44132,inst_44133,null));
var inst_44135 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_44131,cljs.core._LT_,inst_44134);
var state_44247__$1 = (function (){var statearr_44250 = state_44247;
(statearr_44250[(9)] = inst_44128);

return statearr_44250;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44247__$1,(21),inst_44135);
} else {
if((state_val_44248 === (27))){
var inst_44098 = (state_44247[(10)]);
var inst_44116 = (state_44247[(11)]);
var inst_44164 = (inst_44116.cljs$core$IFn$_invoke$arity$2 ? inst_44116.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_44098) : inst_44116.call(null,cljs.core._GT__EQ_,inst_44098));
var state_44247__$1 = state_44247;
if(cljs.core.truth_(inst_44164)){
var statearr_44251_44325 = state_44247__$1;
(statearr_44251_44325[(1)] = (30));

} else {
var statearr_44252_44326 = state_44247__$1;
(statearr_44252_44326[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (1))){
var state_44247__$1 = state_44247;
var statearr_44253_44327 = state_44247__$1;
(statearr_44253_44327[(2)] = null);

(statearr_44253_44327[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (24))){
var inst_44213 = (state_44247[(2)]);
var state_44247__$1 = state_44247;
var statearr_44254_44328 = state_44247__$1;
(statearr_44254_44328[(2)] = inst_44213);

(statearr_44254_44328[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (39))){
var inst_44203 = null;
var state_44247__$1 = state_44247;
var statearr_44255_44329 = state_44247__$1;
(statearr_44255_44329[(2)] = inst_44203);

(statearr_44255_44329[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (46))){
var inst_44225 = (state_44247[(12)]);
var state_44247__$1 = state_44247;
var statearr_44256_44330 = state_44247__$1;
(statearr_44256_44330[(2)] = inst_44225);

(statearr_44256_44330[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (4))){
var inst_44057 = (state_44247[(2)]);
var state_44247__$1 = state_44247;
var statearr_44257_44331 = state_44247__$1;
(statearr_44257_44331[(2)] = inst_44057);

(statearr_44257_44331[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (15))){
var state_44247__$1 = state_44247;
var statearr_44258_44332 = state_44247__$1;
(statearr_44258_44332[(2)] = null);

(statearr_44258_44332[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (48))){
var inst_44224 = (state_44247[(13)]);
var state_44247__$1 = state_44247;
var statearr_44259_44333 = state_44247__$1;
(statearr_44259_44333[(2)] = inst_44224);

(statearr_44259_44333[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (50))){
var inst_44235 = (state_44247[(2)]);
var state_44247__$1 = state_44247;
var statearr_44260_44334 = state_44247__$1;
(statearr_44260_44334[(2)] = inst_44235);

(statearr_44260_44334[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (21))){
var inst_44128 = (state_44247[(9)]);
var inst_44137 = (state_44247[(2)]);
var inst_44138 = fluree.db.util.async.throw_err(inst_44137);
var inst_44139 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_44128,inst_44138);
var state_44247__$1 = state_44247;
var statearr_44261_44335 = state_44247__$1;
(statearr_44261_44335[(2)] = inst_44139);

(statearr_44261_44335[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (31))){
var inst_44098 = (state_44247[(10)]);
var inst_44116 = (state_44247[(11)]);
var inst_44177 = (inst_44116.cljs$core$IFn$_invoke$arity$2 ? inst_44116.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_44098) : inst_44116.call(null,cljs.core._LT_,inst_44098));
var state_44247__$1 = state_44247;
if(cljs.core.truth_(inst_44177)){
var statearr_44262_44336 = state_44247__$1;
(statearr_44262_44336[(1)] = (34));

} else {
var statearr_44263_44337 = state_44247__$1;
(statearr_44263_44337[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (32))){
var inst_44209 = (state_44247[(2)]);
var state_44247__$1 = state_44247;
var statearr_44264_44338 = state_44247__$1;
(statearr_44264_44338[(2)] = inst_44209);

(statearr_44264_44338[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (40))){
var inst_44205 = (state_44247[(2)]);
var state_44247__$1 = state_44247;
var statearr_44265_44339 = state_44247__$1;
(statearr_44265_44339[(2)] = inst_44205);

(statearr_44265_44339[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (33))){
var inst_44174 = (state_44247[(2)]);
var inst_44175 = fluree.db.util.async.throw_err(inst_44174);
var state_44247__$1 = state_44247;
var statearr_44266_44340 = state_44247__$1;
(statearr_44266_44340[(2)] = inst_44175);

(statearr_44266_44340[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (13))){
var inst_44237 = (state_44247[(2)]);
var state_44247__$1 = state_44247;
var statearr_44267_44341 = state_44247__$1;
(statearr_44267_44341[(2)] = inst_44237);

(statearr_44267_44341[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (22))){
var inst_44097 = (state_44247[(7)]);
var inst_44099 = (state_44247[(8)]);
var inst_44143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44144 = [inst_44097,inst_44099];
var inst_44145 = (new cljs.core.PersistentVector(null,2,(5),inst_44143,inst_44144,null));
var inst_44146 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_44145);
var state_44247__$1 = state_44247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44247__$1,(25),inst_44146);
} else {
if((state_val_44248 === (36))){
var inst_44207 = (state_44247[(2)]);
var state_44247__$1 = state_44247;
var statearr_44268_44342 = state_44247__$1;
(statearr_44268_44342[(2)] = inst_44207);

(statearr_44268_44342[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (41))){
var inst_44200 = (state_44247[(2)]);
var inst_44201 = fluree.db.util.async.throw_err(inst_44200);
var state_44247__$1 = state_44247;
var statearr_44269_44343 = state_44247__$1;
(statearr_44269_44343[(2)] = inst_44201);

(statearr_44269_44343[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (43))){
var inst_44083 = (state_44247[(14)]);
var inst_44216 = (state_44247[(15)]);
var inst_44217 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_44083,inst_44216);
var state_44247__$1 = state_44247;
var statearr_44270_44344 = state_44247__$1;
(statearr_44270_44344[(2)] = inst_44217);

(statearr_44270_44344[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (29))){
var inst_44161 = (state_44247[(2)]);
var inst_44162 = fluree.db.util.async.throw_err(inst_44161);
var state_44247__$1 = state_44247;
var statearr_44271_44345 = state_44247__$1;
(statearr_44271_44345[(2)] = inst_44162);

(statearr_44271_44345[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (44))){
var inst_44083 = (state_44247[(14)]);
var inst_44216 = (state_44247[(15)]);
var inst_44219 = cljs.core.PersistentHashSet.EMPTY;
var inst_44220 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_44219,inst_44216);
var inst_44221 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_44083,inst_44220);
var state_44247__$1 = state_44247;
var statearr_44272_44346 = state_44247__$1;
(statearr_44272_44346[(2)] = inst_44221);

(statearr_44272_44346[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (6))){
var inst_44068 = (state_44247[(16)]);
var inst_44078 = cljs.core.seq(inst_44068);
var inst_44079 = cljs.core.first(inst_44078);
var inst_44080 = cljs.core.next(inst_44078);
var inst_44081 = cljs.core.PersistentHashSet.EMPTY;
var inst_44082 = inst_44068;
var inst_44083 = inst_44081;
var state_44247__$1 = (function (){var statearr_44273 = state_44247;
(statearr_44273[(17)] = inst_44082);

(statearr_44273[(18)] = inst_44079);

(statearr_44273[(14)] = inst_44083);

(statearr_44273[(19)] = inst_44080);

return statearr_44273;
})();
var statearr_44274_44347 = state_44247__$1;
(statearr_44274_44347[(2)] = null);

(statearr_44274_44347[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (28))){
var inst_44211 = (state_44247[(2)]);
var state_44247__$1 = state_44247;
var statearr_44275_44348 = state_44247__$1;
(statearr_44275_44348[(2)] = inst_44211);

(statearr_44275_44348[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (25))){
var inst_44148 = (state_44247[(2)]);
var inst_44149 = fluree.db.util.async.throw_err(inst_44148);
var state_44247__$1 = state_44247;
var statearr_44276_44349 = state_44247__$1;
(statearr_44276_44349[(2)] = inst_44149);

(statearr_44276_44349[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (34))){
var inst_44097 = (state_44247[(7)]);
var inst_44099 = (state_44247[(8)]);
var inst_44179 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44180 = [inst_44097];
var inst_44181 = (new cljs.core.PersistentVector(null,1,(5),inst_44179,inst_44180,null));
var inst_44182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44183 = [inst_44097,inst_44099];
var inst_44184 = (new cljs.core.PersistentVector(null,2,(5),inst_44182,inst_44183,null));
var inst_44185 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_44181,cljs.core._LT_,inst_44184);
var state_44247__$1 = state_44247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44247__$1,(37),inst_44185);
} else {
if((state_val_44248 === (17))){
var inst_44097 = (state_44247[(7)]);
var inst_44099 = (state_44247[(8)]);
var inst_44119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44120 = [inst_44097,inst_44099];
var inst_44121 = (new cljs.core.PersistentVector(null,2,(5),inst_44119,inst_44120,null));
var inst_44122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44123 = [inst_44097];
var inst_44124 = (new cljs.core.PersistentVector(null,1,(5),inst_44122,inst_44123,null));
var inst_44125 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_44121,cljs.core._LT__EQ_,inst_44124);
var state_44247__$1 = state_44247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44247__$1,(20),inst_44125);
} else {
if((state_val_44248 === (3))){
var inst_44245 = (state_44247[(2)]);
var state_44247__$1 = state_44247;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44247__$1,inst_44245);
} else {
if((state_val_44248 === (12))){
var inst_44097 = (state_44247[(7)]);
var inst_44089 = (state_44247[(20)]);
var inst_44097__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44089,(0),null);
var inst_44098 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44089,(1),null);
var inst_44099 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44089,(2),null);
var inst_44100 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_44097__$1);
var inst_44101 = cljs.core.not(inst_44100);
var state_44247__$1 = (function (){var statearr_44277 = state_44247;
(statearr_44277[(7)] = inst_44097__$1);

(statearr_44277[(10)] = inst_44098);

(statearr_44277[(8)] = inst_44099);

return statearr_44277;
})();
if(inst_44101){
var statearr_44278_44350 = state_44247__$1;
(statearr_44278_44350[(1)] = (14));

} else {
var statearr_44279_44351 = state_44247__$1;
(statearr_44279_44351[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (2))){
var inst_44068 = (state_44247[(16)]);
var _ = (function (){var statearr_44280 = state_44247;
(statearr_44280[(4)] = cljs.core.cons((5),(state_44247[(4)])));

return statearr_44280;
})();
var inst_44066 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_44067 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44066,(0),null);
var inst_44068__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44066,(1),null);
var inst_44069 = cljs.core.not_empty(inst_44068__$1);
var state_44247__$1 = (function (){var statearr_44281 = state_44247;
(statearr_44281[(21)] = inst_44067);

(statearr_44281[(16)] = inst_44068__$1);

return statearr_44281;
})();
if(cljs.core.truth_(inst_44069)){
var statearr_44282_44352 = state_44247__$1;
(statearr_44282_44352[(1)] = (6));

} else {
var statearr_44283_44353 = state_44247__$1;
(statearr_44283_44353[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (23))){
var inst_44098 = (state_44247[(10)]);
var inst_44116 = (state_44247[(11)]);
var inst_44151 = (inst_44116.cljs$core$IFn$_invoke$arity$2 ? inst_44116.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_44098) : inst_44116.call(null,cljs.core._GT_,inst_44098));
var state_44247__$1 = state_44247;
if(cljs.core.truth_(inst_44151)){
var statearr_44284_44354 = state_44247__$1;
(statearr_44284_44354[(1)] = (26));

} else {
var statearr_44285_44355 = state_44247__$1;
(statearr_44285_44355[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (47))){
var inst_44230 = (state_44247[(2)]);
var state_44247__$1 = state_44247;
if(cljs.core.truth_(inst_44230)){
var statearr_44286_44356 = state_44247__$1;
(statearr_44286_44356[(1)] = (48));

} else {
var statearr_44287_44357 = state_44247__$1;
(statearr_44287_44357[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (35))){
var inst_44098 = (state_44247[(10)]);
var inst_44116 = (state_44247[(11)]);
var inst_44190 = (inst_44116.cljs$core$IFn$_invoke$arity$2 ? inst_44116.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_44098) : inst_44116.call(null,cljs.core._LT__EQ_,inst_44098));
var state_44247__$1 = state_44247;
if(cljs.core.truth_(inst_44190)){
var statearr_44288_44358 = state_44247__$1;
(statearr_44288_44358[(1)] = (38));

} else {
var statearr_44289_44359 = state_44247__$1;
(statearr_44289_44359[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (19))){
var inst_44067 = (state_44247[(21)]);
var inst_44215 = (state_44247[(2)]);
var inst_44216 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_44215);
var state_44247__$1 = (function (){var statearr_44290 = state_44247;
(statearr_44290[(15)] = inst_44216);

return statearr_44290;
})();
var G__44291_44360 = inst_44067;
var G__44291_44361__$1 = (((G__44291_44360 instanceof cljs.core.Keyword))?G__44291_44360.fqn:null);
switch (G__44291_44361__$1) {
case "or":
var statearr_44292_44363 = state_44247__$1;
(statearr_44292_44363[(1)] = (43));


break;
case "and":
var statearr_44293_44364 = state_44247__$1;
(statearr_44293_44364[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44291_44361__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (11))){
var inst_44083 = (state_44247[(14)]);
var state_44247__$1 = state_44247;
var statearr_44295_44365 = state_44247__$1;
(statearr_44295_44365[(2)] = inst_44083);

(statearr_44295_44365[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (9))){
var inst_44082 = (state_44247[(17)]);
var inst_44089 = (state_44247[(20)]);
var inst_44088 = cljs.core.seq(inst_44082);
var inst_44089__$1 = cljs.core.first(inst_44088);
var inst_44090 = cljs.core.next(inst_44088);
var inst_44091 = cljs.core.not(inst_44089__$1);
var state_44247__$1 = (function (){var statearr_44296 = state_44247;
(statearr_44296[(22)] = inst_44090);

(statearr_44296[(20)] = inst_44089__$1);

return statearr_44296;
})();
if(inst_44091){
var statearr_44297_44366 = state_44247__$1;
(statearr_44297_44366[(1)] = (11));

} else {
var statearr_44298_44367 = state_44247__$1;
(statearr_44298_44367[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (5))){
var _ = (function (){var statearr_44299 = state_44247;
(statearr_44299[(4)] = cljs.core.rest((state_44247[(4)])));

return statearr_44299;
})();
var state_44247__$1 = state_44247;
var ex44294 = (state_44247__$1[(2)]);
var statearr_44300_44368 = state_44247__$1;
(statearr_44300_44368[(5)] = ex44294);


if((ex44294 instanceof Error)){
var statearr_44301_44369 = state_44247__$1;
(statearr_44301_44369[(1)] = (4));

(statearr_44301_44369[(5)] = null);

} else {
throw ex44294;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (14))){
var inst_44097 = (state_44247[(7)]);
var inst_44103 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_44097);
var inst_44104 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44103)].join('');
var inst_44105 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_44106 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_44107 = cljs.core.PersistentHashMap.fromArrays(inst_44105,inst_44106);
var inst_44108 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_44104,inst_44107);
var inst_44109 = (function(){throw inst_44108})();
var state_44247__$1 = state_44247;
var statearr_44302_44370 = state_44247__$1;
(statearr_44302_44370[(2)] = inst_44109);

(statearr_44302_44370[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (45))){
var inst_44224 = (state_44247[(13)]);
var inst_44227 = cljs.core.empty_QMARK_(inst_44224);
var state_44247__$1 = state_44247;
var statearr_44303_44371 = state_44247__$1;
(statearr_44303_44371[(2)] = inst_44227);

(statearr_44303_44371[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (26))){
var inst_44097 = (state_44247[(7)]);
var inst_44099 = (state_44247[(8)]);
var inst_44153 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44154 = [inst_44097,inst_44099];
var inst_44155 = (new cljs.core.PersistentVector(null,2,(5),inst_44153,inst_44154,null));
var inst_44156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44157 = [inst_44097];
var inst_44158 = (new cljs.core.PersistentVector(null,1,(5),inst_44156,inst_44157,null));
var inst_44159 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_44155,cljs.core._LT__EQ_,inst_44158);
var state_44247__$1 = state_44247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44247__$1,(29),inst_44159);
} else {
if((state_val_44248 === (16))){
var inst_44098 = (state_44247[(10)]);
var inst_44116 = (state_44247[(11)]);
var inst_44112 = (state_44247[(2)]);
var inst_44116__$1 = cljs.core.identical_QMARK_;
var inst_44117 = (inst_44116__$1.cljs$core$IFn$_invoke$arity$2 ? inst_44116__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_44098) : inst_44116__$1.call(null,cljs.core.not_EQ_,inst_44098));
var state_44247__$1 = (function (){var statearr_44304 = state_44247;
(statearr_44304[(23)] = inst_44112);

(statearr_44304[(11)] = inst_44116__$1);

return statearr_44304;
})();
if(cljs.core.truth_(inst_44117)){
var statearr_44305_44372 = state_44247__$1;
(statearr_44305_44372[(1)] = (17));

} else {
var statearr_44306_44373 = state_44247__$1;
(statearr_44306_44373[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (38))){
var inst_44097 = (state_44247[(7)]);
var inst_44099 = (state_44247[(8)]);
var inst_44192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44193 = [inst_44097];
var inst_44194 = (new cljs.core.PersistentVector(null,1,(5),inst_44192,inst_44193,null));
var inst_44195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44196 = [inst_44097,inst_44099];
var inst_44197 = (new cljs.core.PersistentVector(null,2,(5),inst_44195,inst_44196,null));
var inst_44198 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_44194,cljs.core._LT__EQ_,inst_44197);
var state_44247__$1 = state_44247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44247__$1,(41),inst_44198);
} else {
if((state_val_44248 === (30))){
var inst_44097 = (state_44247[(7)]);
var inst_44099 = (state_44247[(8)]);
var inst_44166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44167 = [inst_44097,inst_44099];
var inst_44168 = (new cljs.core.PersistentVector(null,2,(5),inst_44166,inst_44167,null));
var inst_44169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44170 = [inst_44097];
var inst_44171 = (new cljs.core.PersistentVector(null,1,(5),inst_44169,inst_44170,null));
var inst_44172 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_44168,cljs.core._LT__EQ_,inst_44171);
var state_44247__$1 = state_44247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44247__$1,(33),inst_44172);
} else {
if((state_val_44248 === (10))){
var inst_44239 = (state_44247[(2)]);
var state_44247__$1 = state_44247;
var statearr_44307_44374 = state_44247__$1;
(statearr_44307_44374[(2)] = inst_44239);

(statearr_44307_44374[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (18))){
var inst_44098 = (state_44247[(10)]);
var inst_44116 = (state_44247[(11)]);
var inst_44141 = (inst_44116.cljs$core$IFn$_invoke$arity$2 ? inst_44116.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_44098) : inst_44116.call(null,cljs.core._EQ_,inst_44098));
var state_44247__$1 = state_44247;
if(cljs.core.truth_(inst_44141)){
var statearr_44308_44375 = state_44247__$1;
(statearr_44308_44375[(1)] = (22));

} else {
var statearr_44309_44376 = state_44247__$1;
(statearr_44309_44376[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (42))){
var inst_44225 = (state_44247[(12)]);
var inst_44067 = (state_44247[(21)]);
var inst_44224 = (state_44247[(2)]);
var inst_44225__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_44067);
var state_44247__$1 = (function (){var statearr_44310 = state_44247;
(statearr_44310[(12)] = inst_44225__$1);

(statearr_44310[(13)] = inst_44224);

return statearr_44310;
})();
if(inst_44225__$1){
var statearr_44311_44377 = state_44247__$1;
(statearr_44311_44377[(1)] = (45));

} else {
var statearr_44312_44378 = state_44247__$1;
(statearr_44312_44378[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (37))){
var inst_44187 = (state_44247[(2)]);
var inst_44188 = fluree.db.util.async.throw_err(inst_44187);
var state_44247__$1 = state_44247;
var statearr_44313_44379 = state_44247__$1;
(statearr_44313_44379[(2)] = inst_44188);

(statearr_44313_44379[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (8))){
var inst_44242 = (state_44247[(2)]);
var _ = (function (){var statearr_44314 = state_44247;
(statearr_44314[(4)] = cljs.core.rest((state_44247[(4)])));

return statearr_44314;
})();
var state_44247__$1 = state_44247;
var statearr_44315_44380 = state_44247__$1;
(statearr_44315_44380[(2)] = inst_44242);

(statearr_44315_44380[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44248 === (49))){
var inst_44090 = (state_44247[(22)]);
var inst_44224 = (state_44247[(13)]);
var inst_44082 = inst_44090;
var inst_44083 = inst_44224;
var state_44247__$1 = (function (){var statearr_44316 = state_44247;
(statearr_44316[(17)] = inst_44082);

(statearr_44316[(14)] = inst_44083);

return statearr_44316;
})();
var statearr_44317_44381 = state_44247__$1;
(statearr_44317_44381[(2)] = null);

(statearr_44317_44381[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__20477__auto__ = null;
var fluree$db$query$fql$state_machine__20477__auto____0 = (function (){
var statearr_44318 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44318[(0)] = fluree$db$query$fql$state_machine__20477__auto__);

(statearr_44318[(1)] = (1));

return statearr_44318;
});
var fluree$db$query$fql$state_machine__20477__auto____1 = (function (state_44247){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_44247);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e44319){var ex__20480__auto__ = e44319;
var statearr_44320_44382 = state_44247;
(statearr_44320_44382[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_44247[(4)]))){
var statearr_44321_44383 = state_44247;
(statearr_44321_44383[(1)] = cljs.core.first((state_44247[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__44384 = state_44247;
state_44247 = G__44384;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__20477__auto__ = function(state_44247){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__20477__auto____1.call(this,state_44247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__20477__auto____0;
fluree$db$query$fql$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__20477__auto____1;
return fluree$db$query$fql$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_44322 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_44322[(6)] = c__20603__auto__);

return statearr_44322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4223__auto__ = cljs.core.every_QMARK_((function (p1__44385_SHARP_){
return ((typeof p1__44385_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__44385_SHARP_)));
}),select_smt);
if(or__4223__auto__){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__44386_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__44386_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__44390 = vars;
var vec__44391 = G__44390;
var seq__44392 = cljs.core.seq(vec__44391);
var first__44393 = cljs.core.first(seq__44392);
var seq__44392__$1 = cljs.core.next(seq__44392);
var var$ = first__44393;
var r = seq__44392__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__44390__$1 = G__44390;
var all_vars__$1 = all_vars;
while(true){
var vec__44398 = G__44390__$1;
var seq__44399 = cljs.core.seq(vec__44398);
var first__44400 = cljs.core.first(seq__44399);
var seq__44399__$1 = cljs.core.next(seq__44399);
var var$__$1 = first__44400;
var r__$1 = seq__44399__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__44401 = cljs.core.set(all_vars__$2);
return (fexpr__44401.cljs$core$IFn$_invoke$arity$1 ? fexpr__44401.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__44401.call(null,var$__$1));
})())){
var G__44402 = r__$1;
var G__44403 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__44390__$1 = G__44402;
all_vars__$1 = G__44403;
continue;
} else {
var G__44404 = r__$1;
var G__44405 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__44390__$1 = G__44404;
all_vars__$1 = G__44405;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_44440){
var state_val_44441 = (state_44440[(1)]);
if((state_val_44441 === (1))){
var inst_44413 = functionArray;
var inst_44414 = cljs.core.seq(inst_44413);
var inst_44415 = cljs.core.first(inst_44414);
var inst_44416 = cljs.core.next(inst_44414);
var inst_44417 = cljs.core.PersistentVector.EMPTY;
var inst_44418 = inst_44413;
var inst_44419 = inst_44417;
var state_44440__$1 = (function (){var statearr_44442 = state_44440;
(statearr_44442[(7)] = inst_44416);

(statearr_44442[(8)] = inst_44419);

(statearr_44442[(9)] = inst_44418);

(statearr_44442[(10)] = inst_44415);

return statearr_44442;
})();
var statearr_44443_44456 = state_44440__$1;
(statearr_44443_44456[(2)] = null);

(statearr_44443_44456[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44441 === (2))){
var inst_44418 = (state_44440[(9)]);
var inst_44425 = (state_44440[(11)]);
var inst_44424 = cljs.core.seq(inst_44418);
var inst_44425__$1 = cljs.core.first(inst_44424);
var inst_44426 = cljs.core.next(inst_44424);
var state_44440__$1 = (function (){var statearr_44444 = state_44440;
(statearr_44444[(12)] = inst_44426);

(statearr_44444[(11)] = inst_44425__$1);

return statearr_44444;
})();
if(cljs.core.truth_(inst_44425__$1)){
var statearr_44445_44457 = state_44440__$1;
(statearr_44445_44457[(1)] = (4));

} else {
var statearr_44446_44458 = state_44440__$1;
(statearr_44446_44458[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44441 === (3))){
var inst_44438 = (state_44440[(2)]);
var state_44440__$1 = state_44440;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44440__$1,inst_44438);
} else {
if((state_val_44441 === (4))){
var inst_44425 = (state_44440[(11)]);
var inst_44428 = (inst_44425.cljs$core$IFn$_invoke$arity$1 ? inst_44425.cljs$core$IFn$_invoke$arity$1(tuple) : inst_44425.call(null,tuple));
var state_44440__$1 = state_44440;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44440__$1,(7),inst_44428);
} else {
if((state_val_44441 === (5))){
var inst_44419 = (state_44440[(8)]);
var state_44440__$1 = state_44440;
var statearr_44447_44459 = state_44440__$1;
(statearr_44447_44459[(2)] = inst_44419);

(statearr_44447_44459[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44441 === (6))){
var inst_44436 = (state_44440[(2)]);
var state_44440__$1 = state_44440;
var statearr_44448_44460 = state_44440__$1;
(statearr_44448_44460[(2)] = inst_44436);

(statearr_44448_44460[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44441 === (7))){
var inst_44426 = (state_44440[(12)]);
var inst_44419 = (state_44440[(8)]);
var inst_44430 = (state_44440[(2)]);
var inst_44431 = fluree.db.util.async.throw_err(inst_44430);
var inst_44432 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_44419,inst_44431);
var inst_44418 = inst_44426;
var inst_44419__$1 = inst_44432;
var state_44440__$1 = (function (){var statearr_44449 = state_44440;
(statearr_44449[(8)] = inst_44419__$1);

(statearr_44449[(9)] = inst_44418);

return statearr_44449;
})();
var statearr_44450_44461 = state_44440__$1;
(statearr_44450_44461[(2)] = null);

(statearr_44450_44461[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__20477__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__20477__auto____0 = (function (){
var statearr_44451 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44451[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__20477__auto__);

(statearr_44451[(1)] = (1));

return statearr_44451;
});
var fluree$db$query$fql$format_tuple_$_state_machine__20477__auto____1 = (function (state_44440){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_44440);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e44452){var ex__20480__auto__ = e44452;
var statearr_44453_44462 = state_44440;
(statearr_44453_44462[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_44440[(4)]))){
var statearr_44454_44463 = state_44440;
(statearr_44454_44463[(1)] = cljs.core.first((state_44440[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__44464 = state_44440;
state_44440 = G__44464;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__20477__auto__ = function(state_44440){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__20477__auto____1.call(this,state_44440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__20477__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__20477__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_44455 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_44455[(6)] = c__20603__auto__);

return statearr_44455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__44465){
var vec__44466 = p__44465;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44466,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44466,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_44480){
var state_val_44481 = (state_44480[(1)]);
if((state_val_44481 === (1))){
var inst_44469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44470 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_44471 = [query_map,_id,query_opts];
var inst_44472 = cljs.core.PersistentHashMap.fromArrays(inst_44470,inst_44471);
var inst_44473 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_44472) : fluree.db.query.fql.query.call(null,db,inst_44472));
var state_44480__$1 = (function (){var statearr_44482 = state_44480;
(statearr_44482[(7)] = inst_44469);

return statearr_44482;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44480__$1,(2),inst_44473);
} else {
if((state_val_44481 === (2))){
var inst_44469 = (state_44480[(7)]);
var inst_44475 = (state_44480[(2)]);
var inst_44476 = fluree.db.util.async.throw_err(inst_44475);
var inst_44477 = [tuple_index,inst_44476];
var inst_44478 = (new cljs.core.PersistentVector(null,2,(5),inst_44469,inst_44477,null));
var state_44480__$1 = state_44480;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44480__$1,inst_44478);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__20477__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__20477__auto____0 = (function (){
var statearr_44483 = [null,null,null,null,null,null,null,null];
(statearr_44483[(0)] = fluree$db$query$fql$expand_map_$_state_machine__20477__auto__);

(statearr_44483[(1)] = (1));

return statearr_44483;
});
var fluree$db$query$fql$expand_map_$_state_machine__20477__auto____1 = (function (state_44480){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_44480);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e44484){var ex__20480__auto__ = e44484;
var statearr_44485_44488 = state_44480;
(statearr_44485_44488[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_44480[(4)]))){
var statearr_44486_44489 = state_44480;
(statearr_44486_44489[(1)] = cljs.core.first((state_44480[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__44490 = state_44480;
state_44480 = G__44490;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__20477__auto__ = function(state_44480){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__20477__auto____1.call(this,state_44480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__20477__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__20477__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_44487 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_44487[(6)] = c__20603__auto__);

return statearr_44487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__44491 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44491,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44491,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_44556){
var state_val_44557 = (state_44556[(1)]);
if((state_val_44557 === (7))){
var inst_44551 = (state_44556[(2)]);
var _ = (function (){var statearr_44558 = state_44556;
(statearr_44558[(4)] = cljs.core.rest((state_44556[(4)])));

return statearr_44558;
})();
var state_44556__$1 = state_44556;
var statearr_44559_44650 = state_44556__$1;
(statearr_44559_44650[(2)] = inst_44551);

(statearr_44559_44650[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (20))){
var inst_44542 = (state_44556[(2)]);
var state_44556__$1 = state_44556;
var statearr_44560_44651 = state_44556__$1;
(statearr_44560_44651[(2)] = inst_44542);

(statearr_44560_44651[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (1))){
var state_44556__$1 = state_44556;
var statearr_44561_44652 = state_44556__$1;
(statearr_44561_44652[(2)] = null);

(statearr_44561_44652[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (4))){
var inst_44496 = (state_44556[(2)]);
var state_44556__$1 = state_44556;
var statearr_44562_44653 = state_44556__$1;
(statearr_44562_44653[(2)] = inst_44496);

(statearr_44562_44653[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (15))){
var inst_44516 = (state_44556[(7)]);
var inst_44525 = cljs.core._deref(fuel);
var inst_44526 = cljs.core.second(inst_44516);
var inst_44527 = (inst_44525 + inst_44526);
var inst_44528 = cljs.core._vreset_BANG_(fuel,inst_44527);
var inst_44529 = (inst_44528 > max_fuel);
var state_44556__$1 = state_44556;
if(cljs.core.truth_(inst_44529)){
var statearr_44563_44654 = state_44556__$1;
(statearr_44563_44654[(1)] = (18));

} else {
var statearr_44564_44655 = state_44556__$1;
(statearr_44564_44655[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (13))){
var state_44556__$1 = state_44556;
var statearr_44565_44656 = state_44556__$1;
(statearr_44565_44656[(1)] = (15));



return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (6))){
var inst_44504 = (state_44556[(8)]);
var state_44556__$1 = state_44556;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44556__$1,(8),inst_44504);
} else {
if((state_val_44557 === (17))){
var inst_44545 = (state_44556[(2)]);
var state_44556__$1 = state_44556;
var statearr_44567_44657 = state_44556__$1;
(statearr_44567_44657[(2)] = inst_44545);

(statearr_44567_44657[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (3))){
var inst_44554 = (state_44556[(2)]);
var state_44556__$1 = state_44556;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44556__$1,inst_44554);
} else {
if((state_val_44557 === (12))){
var inst_44516 = (state_44556[(7)]);
var inst_44505 = (state_44556[(9)]);
var inst_44522 = (inst_44505.cljs$core$IFn$_invoke$arity$0 ? inst_44505.cljs$core$IFn$_invoke$arity$0() : inst_44505.call(null));
var state_44556__$1 = (function (){var statearr_44568 = state_44556;
(statearr_44568[(10)] = inst_44522);

return statearr_44568;
})();
var statearr_44569_44658 = state_44556__$1;
(statearr_44569_44658[(2)] = inst_44516);

(statearr_44569_44658[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (2))){
var inst_44504 = (state_44556[(8)]);
var inst_44505 = (state_44556[(9)]);
var _ = (function (){var statearr_44570 = state_44556;
(statearr_44570[(4)] = cljs.core.cons((5),(state_44556[(4)])));

return statearr_44570;
})();
var inst_44502 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_44503 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_44504__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_44505__$1 = (function (){var expandMaps = inst_44502;
var queue_ch = inst_44503;
var res_ch = inst_44504__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_44506 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_44507 = cljs.core.volatile_BANG_((0));
var inst_44508 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_44506,cljs.core.cst$kw$fuel,inst_44507);
var inst_44509 = (function (){var expandMaps = inst_44502;
var queue_ch = inst_44503;
var res_ch = inst_44504__$1;
var stop_BANG_ = inst_44505__$1;
var opts_STAR_ = inst_44508;
return (function (tuple_res,port){
var c__20603__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_44603){
var state_val_44604 = (state_44603[(1)]);
if((state_val_44604 === (7))){
var state_44603__$1 = state_44603;
var statearr_44605_44659 = state_44603__$1;
(statearr_44605_44659[(2)] = tuple_res);

(statearr_44605_44659[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44604 === (1))){
var state_44603__$1 = state_44603;
var statearr_44606_44660 = state_44603__$1;
(statearr_44606_44660[(2)] = null);

(statearr_44606_44660[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44604 === (4))){
var inst_44571 = (state_44603[(2)]);
var inst_44572 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_44571);
var inst_44573 = cljs.core.async.close_BANG_(port);
var state_44603__$1 = (function (){var statearr_44607 = state_44603;
(statearr_44607[(7)] = inst_44572);

return statearr_44607;
})();
var statearr_44608_44661 = state_44603__$1;
(statearr_44608_44661[(2)] = inst_44573);

(statearr_44608_44661[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44604 === (6))){
var inst_44580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44581 = [tuple_res];
var inst_44582 = (new cljs.core.PersistentVector(null,1,(5),inst_44580,inst_44581,null));
var state_44603__$1 = state_44603;
var statearr_44609_44662 = state_44603__$1;
(statearr_44609_44662[(2)] = inst_44582);

(statearr_44609_44662[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44604 === (3))){
var inst_44601 = (state_44603[(2)]);
var state_44603__$1 = state_44603;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44603__$1,inst_44601);
} else {
if((state_val_44604 === (2))){
var ___$1 = (function (){var statearr_44611 = state_44603;
(statearr_44611[(4)] = cljs.core.cons((5),(state_44603[(4)])));

return statearr_44611;
})();
var state_44603__$1 = state_44603;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_44612_44663 = state_44603__$1;
(statearr_44612_44663[(1)] = (6));

} else {
var statearr_44613_44664 = state_44603__$1;
(statearr_44613_44664[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44604 === (9))){
var inst_44587 = (state_44603[(8)]);
var inst_44585 = (state_44603[(9)]);
var inst_44594 = (state_44603[(2)]);
var inst_44595 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_44585,inst_44594);
var inst_44596 = (inst_44587.cljs$core$IFn$_invoke$arity$1 ? inst_44587.cljs$core$IFn$_invoke$arity$1(inst_44595) : inst_44587.call(null,inst_44595));
var inst_44597 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_44596);
var inst_44598 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_44614 = state_44603;
(statearr_44614[(4)] = cljs.core.rest((state_44603[(4)])));

return statearr_44614;
})();
var state_44603__$1 = (function (){var statearr_44615 = state_44603;
(statearr_44615[(10)] = inst_44597);

return statearr_44615;
})();
var statearr_44616_44665 = state_44603__$1;
(statearr_44616_44665[(2)] = inst_44598);

(statearr_44616_44665[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44604 === (5))){
var ___$1 = (function (){var statearr_44617 = state_44603;
(statearr_44617[(4)] = cljs.core.rest((state_44603[(4)])));

return statearr_44617;
})();
var state_44603__$1 = state_44603;
var ex44610 = (state_44603__$1[(2)]);
var statearr_44618_44666 = state_44603__$1;
(statearr_44618_44666[(5)] = ex44610);


var statearr_44619_44667 = state_44603__$1;
(statearr_44619_44667[(1)] = (4));

(statearr_44619_44667[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44604 === (8))){
var inst_44585 = (state_44603[(9)]);
var inst_44585__$1 = (state_44603[(2)]);
var inst_44586 = cljs.core.volatile_BANG_((0));
var inst_44587 = (function (){var tuple_res_SINGLEQUOTE_ = inst_44585__$1;
var query_fuel = inst_44586;
return (function (p1__44495_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__44495_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44495_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_44588 = cljs.core.PersistentVector.EMPTY;
var inst_44589 = (function (){var tuple_res_SINGLEQUOTE_ = inst_44585__$1;
var query_fuel = inst_44586;
return (function (p1__44494_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,cljs.core.cst$kw$fuel,fuel),tuple_res_SINGLEQUOTE_,p1__44494_SHARP_);
});
})();
var inst_44590 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_44589,expandMaps);
var inst_44591 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_44590);
var inst_44592 = cljs.core.async.into(inst_44588,inst_44591);
var state_44603__$1 = (function (){var statearr_44620 = state_44603;
(statearr_44620[(8)] = inst_44587);

(statearr_44620[(9)] = inst_44585__$1);

return statearr_44620;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44603__$1,(9),inst_44592);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto____0 = (function (){
var statearr_44621 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44621[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto__);

(statearr_44621[(1)] = (1));

return statearr_44621;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto____1 = (function (state_44603){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_44603);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e44622){var ex__20480__auto__ = e44622;
var statearr_44623_44668 = state_44603;
(statearr_44623_44668[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_44603[(4)]))){
var statearr_44624_44669 = state_44603;
(statearr_44624_44669[(1)] = cljs.core.first((state_44603[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__44670 = state_44603;
state_44603 = G__44670;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto__ = function(state_44603){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto____1.call(this,state_44603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_44625 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_44625[(6)] = c__20603__auto____$1);

return statearr_44625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto____$1;
});
})();
var inst_44510 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_44503,tuples_res);
var inst_44511 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_44504__$1,inst_44509,inst_44503);
var inst_44512 = cljs.core.PersistentVector.EMPTY;
var inst_44513 = inst_44512;
var state_44556__$1 = (function (){var statearr_44626 = state_44556;
(statearr_44626[(11)] = inst_44513);

(statearr_44626[(12)] = inst_44511);

(statearr_44626[(8)] = inst_44504__$1);

(statearr_44626[(9)] = inst_44505__$1);

(statearr_44626[(13)] = inst_44510);

return statearr_44626;
})();
var statearr_44627_44671 = state_44556__$1;
(statearr_44627_44671[(2)] = null);

(statearr_44627_44671[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (19))){
var inst_44513 = (state_44556[(11)]);
var inst_44516 = (state_44556[(7)]);
var inst_44538 = cljs.core.first(inst_44516);
var inst_44539 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_44513,inst_44538);
var inst_44513__$1 = inst_44539;
var state_44556__$1 = (function (){var statearr_44628 = state_44556;
(statearr_44628[(11)] = inst_44513__$1);

return statearr_44628;
})();
var statearr_44629_44672 = state_44556__$1;
(statearr_44629_44672[(2)] = null);

(statearr_44629_44672[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (11))){
var inst_44549 = (state_44556[(2)]);
var state_44556__$1 = state_44556;
var statearr_44631_44673 = state_44556__$1;
(statearr_44631_44673[(2)] = inst_44549);

(statearr_44631_44673[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (9))){
var inst_44513 = (state_44556[(11)]);
var state_44556__$1 = state_44556;
var statearr_44632_44674 = state_44556__$1;
(statearr_44632_44674[(2)] = inst_44513);

(statearr_44632_44674[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (5))){
var _ = (function (){var statearr_44633 = state_44556;
(statearr_44633[(4)] = cljs.core.rest((state_44556[(4)])));

return statearr_44633;
})();
var state_44556__$1 = state_44556;
var ex44630 = (state_44556__$1[(2)]);
var statearr_44634_44675 = state_44556__$1;
(statearr_44634_44675[(5)] = ex44630);


if((ex44630 instanceof Error)){
var statearr_44635_44676 = state_44556__$1;
(statearr_44635_44676[(1)] = (4));

(statearr_44635_44676[(5)] = null);

} else {
throw ex44630;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (14))){
var inst_44547 = (state_44556[(2)]);
var state_44556__$1 = state_44556;
var statearr_44636_44677 = state_44556__$1;
(statearr_44636_44677[(2)] = inst_44547);

(statearr_44636_44677[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (16))){
var state_44556__$1 = state_44556;
var statearr_44637_44678 = state_44556__$1;
(statearr_44637_44678[(2)] = null);

(statearr_44637_44678[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (10))){
var inst_44516 = (state_44556[(7)]);
var inst_44520 = fluree.db.util.core.exception_QMARK_(inst_44516);
var state_44556__$1 = state_44556;
if(inst_44520){
var statearr_44638_44679 = state_44556__$1;
(statearr_44638_44679[(1)] = (12));

} else {
var statearr_44639_44680 = state_44556__$1;
(statearr_44639_44680[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (18))){
var inst_44505 = (state_44556[(9)]);
var inst_44531 = (inst_44505.cljs$core$IFn$_invoke$arity$0 ? inst_44505.cljs$core$IFn$_invoke$arity$0() : inst_44505.call(null));
var inst_44532 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_44533 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_44534 = [cljs.core.cst$kw$db_SLASH_insufficient_DASH_fuel,(400)];
var inst_44535 = cljs.core.PersistentHashMap.fromArrays(inst_44533,inst_44534);
var inst_44536 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_44532,inst_44535);
var state_44556__$1 = (function (){var statearr_44640 = state_44556;
(statearr_44640[(14)] = inst_44531);

return statearr_44640;
})();
var statearr_44641_44681 = state_44556__$1;
(statearr_44641_44681[(2)] = inst_44536);

(statearr_44641_44681[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44557 === (8))){
var inst_44516 = (state_44556[(7)]);
var inst_44516__$1 = (state_44556[(2)]);
var inst_44517 = (inst_44516__$1 == null);
var state_44556__$1 = (function (){var statearr_44642 = state_44556;
(statearr_44642[(7)] = inst_44516__$1);

return statearr_44642;
})();
if(cljs.core.truth_(inst_44517)){
var statearr_44643_44682 = state_44556__$1;
(statearr_44643_44682[(1)] = (9));

} else {
var statearr_44644_44683 = state_44556__$1;
(statearr_44644_44683[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto____0 = (function (){
var statearr_44645 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44645[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto__);

(statearr_44645[(1)] = (1));

return statearr_44645;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto____1 = (function (state_44556){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_44556);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e44646){var ex__20480__auto__ = e44646;
var statearr_44647_44684 = state_44556;
(statearr_44647_44684[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_44556[(4)]))){
var statearr_44648_44685 = state_44556;
(statearr_44648_44685[(1)] = cljs.core.first((state_44556[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__44686 = state_44556;
state_44556 = G__44686;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto__ = function(state_44556){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto____1.call(this,state_44556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_44649 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_44649[(6)] = c__20603__auto__);

return statearr_44649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__44687 = select;
var map__44687__$1 = cljs.core.__destructure_map(map__44687);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44687__$1,cljs.core.cst$kw$as);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44687__$1,cljs.core.cst$kw$variable);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44687__$1,cljs.core.cst$kw$value);
var select_val = (function (){var or__4223__auto__ = as;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__44690 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44690,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44690,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44690,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__44688_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__44688_SHARP_,compare_idx));
}):(function (p1__44689_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__44689_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples))));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__44695 = arguments.length;
switch (G__44695) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__44696,p__44697,group_limit,opts){
var map__44698 = p__44696;
var map__44698__$1 = cljs.core.__destructure_map(map__44698);
var res = map__44698__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44698__$1,cljs.core.cst$kw$vars);
var map__44699 = p__44697;
var map__44699__$1 = cljs.core.__destructure_map(map__44699);
var select_spec = map__44699__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44699__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44699__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44699__$1,cljs.core.cst$kw$orderBy);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44699__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44699__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44699__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44699__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44699__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44699__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44699__$1,cljs.core.cst$kw$groupBy);
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_44836){
var state_val_44837 = (state_44836[(1)]);
if((state_val_44837 === (7))){
var inst_44706 = (state_44836[(7)]);
var state_44836__$1 = state_44836;
var statearr_44838_44940 = state_44836__$1;
(statearr_44838_44940[(2)] = inst_44706);

(statearr_44838_44940[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (59))){
var inst_44829 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44839_44941 = state_44836__$1;
(statearr_44839_44941[(2)] = inst_44829);

(statearr_44839_44941[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (20))){
var inst_44742 = (state_44836[(8)]);
var inst_44745 = (state_44836[(9)]);
var inst_44741 = (state_44836[(2)]);
var inst_44742__$1 = cljs.core.__destructure_map(inst_44741);
var inst_44743 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44742__$1,cljs.core.cst$kw$headers);
var inst_44744 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44742__$1,cljs.core.cst$kw$tuples);
var inst_44745__$1 = offset;
var state_44836__$1 = (function (){var statearr_44840 = state_44836;
(statearr_44840[(10)] = inst_44743);

(statearr_44840[(11)] = inst_44744);

(statearr_44840[(8)] = inst_44742__$1);

(statearr_44840[(9)] = inst_44745__$1);

return statearr_44840;
})();
if(cljs.core.truth_(inst_44745__$1)){
var statearr_44841_44942 = state_44836__$1;
(statearr_44841_44942[(1)] = (21));

} else {
var statearr_44842_44943 = state_44836__$1;
(statearr_44842_44943[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (58))){
var inst_44821 = (state_44836[(12)]);
var state_44836__$1 = state_44836;
var statearr_44843_44944 = state_44836__$1;
(statearr_44843_44944[(2)] = inst_44821);

(statearr_44843_44944[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (60))){
var inst_44825 = (state_44836[(2)]);
var inst_44826 = fluree.db.util.async.throw_err(inst_44825);
var state_44836__$1 = state_44836;
var statearr_44844_44945 = state_44836__$1;
(statearr_44844_44945[(2)] = inst_44826);

(statearr_44844_44945[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (27))){
var inst_44757 = cljs.core.not(inVector_QMARK_);
var state_44836__$1 = state_44836;
var statearr_44845_44946 = state_44836__$1;
(statearr_44845_44946[(2)] = inst_44757);

(statearr_44845_44946[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (1))){
var state_44836__$1 = state_44836;
var statearr_44846_44947 = state_44836__$1;
(statearr_44846_44947[(2)] = null);

(statearr_44846_44947[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (24))){
var state_44836__$1 = state_44836;
var statearr_44847_44948 = state_44836__$1;
(statearr_44847_44948[(2)] = offset);

(statearr_44847_44948[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (55))){
var inst_44815 = (state_44836[(13)]);
var state_44836__$1 = state_44836;
var statearr_44848_44949 = state_44836__$1;
(statearr_44848_44949[(2)] = inst_44815);

(statearr_44848_44949[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (39))){
var inst_44783 = (state_44836[(14)]);
var inst_44785 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_44786 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_44783,inst_44785);
var state_44836__$1 = state_44836;
var statearr_44849_44950 = state_44836__$1;
(statearr_44849_44950[(2)] = inst_44786);

(statearr_44849_44950[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (46))){
var inst_44795 = (state_44836[(15)]);
var state_44836__$1 = state_44836;
var statearr_44850_44951 = state_44836__$1;
(statearr_44850_44951[(2)] = inst_44795);

(statearr_44850_44951[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (4))){
var inst_44700 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44851_44952 = state_44836__$1;
(statearr_44851_44952[(2)] = inst_44700);

(statearr_44851_44952[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (54))){
var inst_44809 = (state_44836[(16)]);
var inst_44815 = (state_44836[(13)]);
var inst_44817 = cljs.core.PersistentVector.EMPTY;
var inst_44818 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_44817,inst_44809,inst_44815);
var state_44836__$1 = state_44836;
var statearr_44852_44953 = state_44836__$1;
(statearr_44852_44953[(2)] = inst_44818);

(statearr_44852_44953[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (15))){
var inst_44727 = (state_44836[(17)]);
var inst_44729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44730 = [inst_44727];
var inst_44731 = (new cljs.core.PersistentVector(null,1,(5),inst_44729,inst_44730,null));
var state_44836__$1 = state_44836;
var statearr_44853_44954 = state_44836__$1;
(statearr_44853_44954[(2)] = inst_44731);

(statearr_44853_44954[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (48))){
var inst_44743 = (state_44836[(10)]);
var inst_44744 = (state_44836[(11)]);
var inst_44754 = (state_44836[(18)]);
var inst_44765 = (state_44836[(19)]);
var inst_44760 = (state_44836[(20)]);
var inst_44801 = (state_44836[(21)]);
var inst_44742 = (state_44836[(8)]);
var inst_44803 = (function (){var map__44736 = inst_44742;
var headers = inst_44743;
var tuples = inst_44744;
var offset_SINGLEQUOTE_ = inst_44754;
var single_result_QMARK_ = inst_44760;
var pp_keys = inst_44765;
var G__44766 = inst_44801;
return (function (p1__44693_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__44693_SHARP_);
});
})();
var inst_44804 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_44803);
var inst_44805 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_44801,inst_44804);
var state_44836__$1 = state_44836;
var statearr_44854_44955 = state_44836__$1;
(statearr_44854_44955[(2)] = inst_44805);

(statearr_44854_44955[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (50))){
var inst_44808 = (state_44836[(2)]);
var inst_44809 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_44808);
var state_44836__$1 = (function (){var statearr_44855 = state_44836;
(statearr_44855[(16)] = inst_44809);

return statearr_44855;
})();
if(cljs.core.truth_(orderBy)){
var statearr_44856_44956 = state_44836__$1;
(statearr_44856_44956[(1)] = (51));

} else {
var statearr_44857_44957 = state_44836__$1;
(statearr_44857_44957[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (21))){
var inst_44747 = cljs.core.not(groupBy);
var state_44836__$1 = state_44836;
var statearr_44858_44958 = state_44836__$1;
(statearr_44858_44958[(2)] = inst_44747);

(statearr_44858_44958[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (31))){
var state_44836__$1 = state_44836;
var statearr_44859_44959 = state_44836__$1;
(statearr_44859_44959[(2)] = null);

(statearr_44859_44959[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (32))){
var inst_44743 = (state_44836[(10)]);
var inst_44760 = (state_44836[(20)]);
var inst_44765 = (state_44836[(2)]);
var inst_44767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44768 = fluree.db.query.fql.select_tuples_fn(inst_44743,vars,select);
var inst_44769 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_44768);
var inst_44770 = [inst_44769];
var inst_44771 = (new cljs.core.PersistentVector(null,1,(5),inst_44767,inst_44770,null));
var state_44836__$1 = (function (){var statearr_44860 = state_44836;
(statearr_44860[(22)] = inst_44771);

(statearr_44860[(19)] = inst_44765);

return statearr_44860;
})();
if(cljs.core.truth_(inst_44760)){
var statearr_44861_44960 = state_44836__$1;
(statearr_44861_44960[(1)] = (33));

} else {
var statearr_44862_44961 = state_44836__$1;
(statearr_44862_44961[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (40))){
var inst_44783 = (state_44836[(14)]);
var state_44836__$1 = state_44836;
var statearr_44863_44962 = state_44836__$1;
(statearr_44863_44962[(2)] = inst_44783);

(statearr_44863_44962[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (56))){
var inst_44821 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44864 = state_44836;
(statearr_44864[(12)] = inst_44821);

return statearr_44864;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_44865_44963 = state_44836__$1;
(statearr_44865_44963[(1)] = (57));

} else {
var statearr_44866_44964 = state_44836__$1;
(statearr_44866_44964[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (33))){
var inst_44771 = (state_44836[(22)]);
var inst_44773 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_44774 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_44771,inst_44773);
var state_44836__$1 = state_44836;
var statearr_44867_44965 = state_44836__$1;
(statearr_44867_44965[(2)] = inst_44774);

(statearr_44867_44965[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (13))){
var inst_44716 = (state_44836[(23)]);
var state_44836__$1 = state_44836;
var statearr_44868_44966 = state_44836__$1;
(statearr_44868_44966[(2)] = inst_44716);

(statearr_44868_44966[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (22))){
var inst_44745 = (state_44836[(9)]);
var state_44836__$1 = state_44836;
var statearr_44869_44967 = state_44836__$1;
(statearr_44869_44967[(2)] = inst_44745);

(statearr_44869_44967[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (36))){
var inst_44777 = (state_44836[(24)]);
var inst_44779 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_44780 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_44777,inst_44779);
var state_44836__$1 = state_44836;
var statearr_44870_44968 = state_44836__$1;
(statearr_44870_44968[(2)] = inst_44780);

(statearr_44870_44968[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (41))){
var inst_44754 = (state_44836[(18)]);
var inst_44789 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44871 = state_44836;
(statearr_44871[(25)] = inst_44789);

return statearr_44871;
})();
if(cljs.core.truth_(inst_44754)){
var statearr_44872_44969 = state_44836__$1;
(statearr_44872_44969[(1)] = (42));

} else {
var statearr_44873_44970 = state_44836__$1;
(statearr_44873_44970[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (43))){
var inst_44789 = (state_44836[(25)]);
var state_44836__$1 = state_44836;
var statearr_44874_44971 = state_44836__$1;
(statearr_44874_44971[(2)] = inst_44789);

(statearr_44874_44971[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (29))){
var inst_44760 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44875 = state_44836;
(statearr_44875[(20)] = inst_44760);

return statearr_44875;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_44876_44972 = state_44836__$1;
(statearr_44876_44972[(1)] = (30));

} else {
var statearr_44877_44973 = state_44836__$1;
(statearr_44877_44973[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (44))){
var inst_44795 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44878 = state_44836;
(statearr_44878[(15)] = inst_44795);

return statearr_44878;
})();
if(cljs.core.truth_(group_limit)){
var statearr_44879_44974 = state_44836__$1;
(statearr_44879_44974[(1)] = (45));

} else {
var statearr_44880_44975 = state_44836__$1;
(statearr_44880_44975[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (6))){
var inst_44708 = cljs.core.count(select);
var inst_44709 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_44708);
var state_44836__$1 = state_44836;
var statearr_44881_44976 = state_44836__$1;
(statearr_44881_44976[(2)] = inst_44709);

(statearr_44881_44976[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (28))){
var inst_44755 = (state_44836[(26)]);
var state_44836__$1 = state_44836;
var statearr_44882_44977 = state_44836__$1;
(statearr_44882_44977[(2)] = inst_44755);

(statearr_44882_44977[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (51))){
var inst_44743 = (state_44836[(10)]);
var inst_44744 = (state_44836[(11)]);
var inst_44812 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_44743,orderBy,inst_44744);
var state_44836__$1 = state_44836;
var statearr_44883_44978 = state_44836__$1;
(statearr_44883_44978[(2)] = inst_44812);

(statearr_44883_44978[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (25))){
var state_44836__$1 = state_44836;
var statearr_44884_44979 = state_44836__$1;
(statearr_44884_44979[(2)] = null);

(statearr_44884_44979[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (34))){
var inst_44771 = (state_44836[(22)]);
var state_44836__$1 = state_44836;
var statearr_44885_44980 = state_44836__$1;
(statearr_44885_44980[(2)] = inst_44771);

(statearr_44885_44980[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (17))){
var inst_44734 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44886_44981 = state_44836__$1;
(statearr_44886_44981[(2)] = inst_44734);

(statearr_44886_44981[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (3))){
var inst_44834 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44836__$1,inst_44834);
} else {
if((state_val_44837 === (12))){
var inst_44716 = (state_44836[(23)]);
var inst_44718 = cljs.core.first(select);
var inst_44719 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_44718);
var inst_44720 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44719);
var inst_44721 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_44720,(1));
var inst_44722 = [inst_44721];
var inst_44723 = [inst_44716];
var inst_44724 = cljs.core.PersistentHashMap.fromArrays(inst_44722,inst_44723);
var state_44836__$1 = state_44836;
var statearr_44887_44982 = state_44836__$1;
(statearr_44887_44982[(2)] = inst_44724);

(statearr_44887_44982[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (2))){
var inst_44706 = (state_44836[(7)]);
var _ = (function (){var statearr_44888 = state_44836;
(statearr_44888[(4)] = cljs.core.cons((5),(state_44836[(4)])));

return statearr_44888;
})();
var inst_44706__$1 = aggregates;
var state_44836__$1 = (function (){var statearr_44889 = state_44836;
(statearr_44889[(7)] = inst_44706__$1);

return statearr_44889;
})();
if(cljs.core.truth_(inst_44706__$1)){
var statearr_44890_44983 = state_44836__$1;
(statearr_44890_44983[(1)] = (6));

} else {
var statearr_44891_44984 = state_44836__$1;
(statearr_44891_44984[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (23))){
var inst_44750 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
if(cljs.core.truth_(inst_44750)){
var statearr_44892_44985 = state_44836__$1;
(statearr_44892_44985[(1)] = (24));

} else {
var statearr_44893_44986 = state_44836__$1;
(statearr_44893_44986[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (47))){
var inst_44801 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44894 = state_44836;
(statearr_44894[(21)] = inst_44801);

return statearr_44894;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_44895_44987 = state_44836__$1;
(statearr_44895_44987[(1)] = (48));

} else {
var statearr_44896_44988 = state_44836__$1;
(statearr_44896_44988[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (35))){
var inst_44777 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44897 = state_44836;
(statearr_44897[(24)] = inst_44777);

return statearr_44897;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_44898_44989 = state_44836__$1;
(statearr_44898_44989[(1)] = (36));

} else {
var statearr_44899_44990 = state_44836__$1;
(statearr_44899_44990[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (19))){
var state_44836__$1 = state_44836;
var statearr_44900_44991 = state_44836__$1;
(statearr_44900_44991[(2)] = res);

(statearr_44900_44991[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (57))){
var inst_44765 = (state_44836[(19)]);
var inst_44760 = (state_44836[(20)]);
var inst_44821 = (state_44836[(12)]);
var inst_44823 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_44765,inst_44760,db,fuel,max_fuel,opts,(8),inst_44821);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44836__$1,(60),inst_44823);
} else {
if((state_val_44837 === (11))){
var inst_44831 = (state_44836[(2)]);
var _ = (function (){var statearr_44902 = state_44836;
(statearr_44902[(4)] = cljs.core.rest((state_44836[(4)])));

return statearr_44902;
})();
var state_44836__$1 = state_44836;
var statearr_44903_44992 = state_44836__$1;
(statearr_44903_44992[(2)] = inst_44831);

(statearr_44903_44992[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (9))){
var inst_44714 = cljs.core.first(aggregates);
var inst_44715 = fluree.db.query.analytical.calculate_aggregate(res,inst_44714);
var inst_44716 = cljs.core.second(inst_44715);
var state_44836__$1 = (function (){var statearr_44904 = state_44836;
(statearr_44904[(23)] = inst_44716);

return statearr_44904;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_44905_44993 = state_44836__$1;
(statearr_44905_44993[(1)] = (12));

} else {
var statearr_44906_44994 = state_44836__$1;
(statearr_44906_44994[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (5))){
var _ = (function (){var statearr_44907 = state_44836;
(statearr_44907[(4)] = cljs.core.rest((state_44836[(4)])));

return statearr_44907;
})();
var state_44836__$1 = state_44836;
var ex44901 = (state_44836__$1[(2)]);
var statearr_44908_44995 = state_44836__$1;
(statearr_44908_44995[(5)] = ex44901);


if((ex44901 instanceof Error)){
var statearr_44909_44996 = state_44836__$1;
(statearr_44909_44996[(1)] = (4));

(statearr_44909_44996[(5)] = null);

} else {
throw ex44901;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (14))){
var inst_44727 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44910 = state_44836;
(statearr_44910[(17)] = inst_44727);

return statearr_44910;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_44911_44997 = state_44836__$1;
(statearr_44911_44997[(1)] = (15));

} else {
var statearr_44912_44998 = state_44836__$1;
(statearr_44912_44998[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (45))){
var inst_44795 = (state_44836[(15)]);
var inst_44797 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_44798 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_44795,inst_44797);
var state_44836__$1 = state_44836;
var statearr_44913_44999 = state_44836__$1;
(statearr_44913_44999[(2)] = inst_44798);

(statearr_44913_44999[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (53))){
var inst_44815 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44914 = state_44836;
(statearr_44914[(13)] = inst_44815);

return statearr_44914;
})();
var statearr_44915_45000 = state_44836__$1;
(statearr_44915_45000[(1)] = (54));



return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (26))){
var inst_44755 = (state_44836[(26)]);
var inst_44754 = (state_44836[(2)]);
var inst_44755__$1 = cljs.core.not(prettyPrint);
var state_44836__$1 = (function (){var statearr_44917 = state_44836;
(statearr_44917[(26)] = inst_44755__$1);

(statearr_44917[(18)] = inst_44754);

return statearr_44917;
})();
if(inst_44755__$1){
var statearr_44918_45001 = state_44836__$1;
(statearr_44918_45001[(1)] = (27));

} else {
var statearr_44919_45002 = state_44836__$1;
(statearr_44919_45002[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (16))){
var inst_44727 = (state_44836[(17)]);
var state_44836__$1 = state_44836;
var statearr_44920_45003 = state_44836__$1;
(statearr_44920_45003[(2)] = inst_44727);

(statearr_44920_45003[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (38))){
var inst_44783 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44921 = state_44836;
(statearr_44921[(14)] = inst_44783);

return statearr_44921;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_44922_45004 = state_44836__$1;
(statearr_44922_45004[(1)] = (39));

} else {
var statearr_44923_45005 = state_44836__$1;
(statearr_44923_45005[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (30))){
var inst_44762 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_44836__$1 = state_44836;
var statearr_44924_45006 = state_44836__$1;
(statearr_44924_45006[(2)] = inst_44762);

(statearr_44924_45006[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (10))){
var state_44836__$1 = state_44836;
if(cljs.core.truth_(aggregates)){
var statearr_44925_45007 = state_44836__$1;
(statearr_44925_45007[(1)] = (18));

} else {
var statearr_44926_45008 = state_44836__$1;
(statearr_44926_45008[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (18))){
var inst_44738 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_44836__$1 = state_44836;
var statearr_44927_45009 = state_44836__$1;
(statearr_44927_45009[(2)] = inst_44738);

(statearr_44927_45009[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (52))){
var inst_44744 = (state_44836[(11)]);
var state_44836__$1 = state_44836;
var statearr_44928_45010 = state_44836__$1;
(statearr_44928_45010[(2)] = inst_44744);

(statearr_44928_45010[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (42))){
var inst_44754 = (state_44836[(18)]);
var inst_44789 = (state_44836[(25)]);
var inst_44791 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_44754);
var inst_44792 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_44789,inst_44791);
var state_44836__$1 = state_44836;
var statearr_44929_45011 = state_44836__$1;
(statearr_44929_45011[(2)] = inst_44792);

(statearr_44929_45011[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (37))){
var inst_44777 = (state_44836[(24)]);
var state_44836__$1 = state_44836;
var statearr_44930_45012 = state_44836__$1;
(statearr_44930_45012[(2)] = inst_44777);

(statearr_44930_45012[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (8))){
var inst_44712 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
if(cljs.core.truth_(inst_44712)){
var statearr_44931_45013 = state_44836__$1;
(statearr_44931_45013[(1)] = (9));

} else {
var statearr_44932_45014 = state_44836__$1;
(statearr_44932_45014[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44837 === (49))){
var inst_44801 = (state_44836[(21)]);
var state_44836__$1 = state_44836;
var statearr_44933_45015 = state_44836__$1;
(statearr_44933_45015[(2)] = inst_44801);

(statearr_44933_45015[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__20477__auto__ = null;
var fluree$db$query$fql$state_machine__20477__auto____0 = (function (){
var statearr_44934 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44934[(0)] = fluree$db$query$fql$state_machine__20477__auto__);

(statearr_44934[(1)] = (1));

return statearr_44934;
});
var fluree$db$query$fql$state_machine__20477__auto____1 = (function (state_44836){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_44836);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e44935){var ex__20480__auto__ = e44935;
var statearr_44936_45016 = state_44836;
(statearr_44936_45016[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_44836[(4)]))){
var statearr_44937_45017 = state_44836;
(statearr_44937_45017[(1)] = cljs.core.first((state_44836[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__45018 = state_44836;
state_44836 = G__45018;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__20477__auto__ = function(state_44836){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__20477__auto____1.call(this,state_44836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__20477__auto____0;
fluree$db$query$fql$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__20477__auto____1;
return fluree$db$query$fql$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_44938 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_44938[(6)] = c__20603__auto__);

return statearr_44938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__45021,groupBy){
var map__45022 = p__45021;
var map__45022__$1 = cljs.core.__destructure_map(map__45022);
var res = map__45022__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45022__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45022__$1,cljs.core.cst$kw$tuples);
var vec__45023 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45023,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45023,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45019_SHARP_){
return fluree.db.util.core.index_of(headers,p1__45019_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45020_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__45020_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__45026 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45026,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45026,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__45029,p__45030,opts){
var map__45031 = p__45029;
var map__45031__$1 = cljs.core.__destructure_map(map__45031);
var res = map__45031__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45031__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45031__$1,cljs.core.cst$kw$vars);
var map__45032 = p__45030;
var map__45032__$1 = cljs.core.__destructure_map(map__45032);
var select_spec = map__45032__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45032__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45032__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45032__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45032__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45032__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45032__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45032__$1,cljs.core.cst$kw$offset);
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_45250){
var state_val_45251 = (state_45250[(1)]);
if((state_val_45251 === (65))){
var inst_45163 = (state_45250[(7)]);
var inst_45191 = cljs.core.empty_QMARK_(inst_45163);
var state_45250__$1 = state_45250;
var statearr_45252_45385 = state_45250__$1;
(statearr_45252_45385[(2)] = inst_45191);

(statearr_45252_45385[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (70))){
var state_45250__$1 = state_45250;
var statearr_45253_45386 = state_45250__$1;
(statearr_45253_45386[(2)] = (1));

(statearr_45253_45386[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (62))){
var state_45250__$1 = state_45250;
var statearr_45254_45387 = state_45250__$1;
(statearr_45254_45387[(2)] = null);

(statearr_45254_45387[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (74))){
var state_45250__$1 = state_45250;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_45255_45388 = state_45250__$1;
(statearr_45255_45388[(1)] = (77));

} else {
var statearr_45256_45389 = state_45250__$1;
(statearr_45256_45389[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (7))){
var state_45250__$1 = state_45250;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_45257_45390 = state_45250__$1;
(statearr_45257_45390[(1)] = (70));

} else {
var statearr_45258_45391 = state_45250__$1;
(statearr_45258_45391[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (59))){
var state_45250__$1 = state_45250;
var statearr_45259_45392 = state_45250__$1;
(statearr_45259_45392[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (20))){
var state_45250__$1 = state_45250;
var statearr_45261_45393 = state_45250__$1;
(statearr_45261_45393[(2)] = (0));

(statearr_45261_45393[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (72))){
var inst_45217 = (state_45250[(2)]);
var inst_45218 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_45217,opts);
var state_45250__$1 = state_45250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45250__$1,(73),inst_45218);
} else {
if((state_val_45251 === (58))){
var inst_45101 = (state_45250[(8)]);
var inst_45175 = (inst_45101 - (1));
var state_45250__$1 = state_45250;
var statearr_45262_45394 = state_45250__$1;
(statearr_45262_45394[(2)] = inst_45175);

(statearr_45262_45394[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (60))){
var inst_45185 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
var statearr_45263_45395 = state_45250__$1;
(statearr_45263_45395[(2)] = inst_45185);

(statearr_45263_45395[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (27))){
var inst_45100 = (state_45250[(9)]);
var inst_45124 = (inst_45100 < (1));
var state_45250__$1 = state_45250;
var statearr_45264_45396 = state_45250__$1;
(statearr_45264_45396[(2)] = inst_45124);

(statearr_45264_45396[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (1))){
var state_45250__$1 = state_45250;
var statearr_45265_45397 = state_45250__$1;
(statearr_45265_45397[(2)] = null);

(statearr_45265_45397[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (69))){
var inst_45115 = (state_45250[(10)]);
var inst_45170 = (state_45250[(11)]);
var inst_45112 = (state_45250[(12)]);
var inst_45187 = (state_45250[(13)]);
var inst_45198 = (state_45250[(2)]);
var inst_45098 = inst_45112;
var inst_45099 = inst_45115;
var inst_45100 = inst_45170;
var inst_45101 = inst_45187;
var inst_45102 = inst_45198;
var state_45250__$1 = (function (){var statearr_45266 = state_45250;
(statearr_45266[(8)] = inst_45101);

(statearr_45266[(9)] = inst_45100);

(statearr_45266[(14)] = inst_45099);

(statearr_45266[(15)] = inst_45098);

(statearr_45266[(16)] = inst_45102);

return statearr_45266;
})();
var statearr_45267_45398 = state_45250__$1;
(statearr_45267_45398[(2)] = null);

(statearr_45267_45398[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (24))){
var inst_45102 = (state_45250[(16)]);
var state_45250__$1 = state_45250;
var statearr_45268_45399 = state_45250__$1;
(statearr_45268_45399[(2)] = inst_45102);

(statearr_45268_45399[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (55))){
var state_45250__$1 = state_45250;
var statearr_45269_45400 = state_45250__$1;
(statearr_45269_45400[(2)] = (0));

(statearr_45269_45400[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (85))){
var inst_45239 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
var statearr_45270_45401 = state_45250__$1;
(statearr_45270_45401[(2)] = inst_45239);

(statearr_45270_45401[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (39))){
var inst_45119 = (state_45250[(17)]);
var inst_45142 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,null], 0));
var inst_45143 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,null], 0));
var inst_45144 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_45119,inst_45142,inst_45143);
var state_45250__$1 = state_45250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45250__$1,(42),inst_45144);
} else {
if((state_val_45251 === (46))){
var inst_45100 = (state_45250[(9)]);
var inst_45155 = ((0) < inst_45100);
var state_45250__$1 = state_45250;
var statearr_45271_45402 = state_45250__$1;
(statearr_45271_45402[(2)] = inst_45155);

(statearr_45271_45402[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (4))){
var inst_45033 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
var statearr_45272_45403 = state_45250__$1;
(statearr_45272_45403[(2)] = inst_45033);

(statearr_45272_45403[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (77))){
var inst_45221 = (state_45250[(18)]);
var inst_45226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45227 = [inst_45221];
var inst_45228 = (new cljs.core.PersistentVector(null,1,(5),inst_45226,inst_45227,null));
var state_45250__$1 = state_45250;
var statearr_45273_45404 = state_45250__$1;
(statearr_45273_45404[(2)] = inst_45228);

(statearr_45273_45404[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (54))){
var inst_45101 = (state_45250[(8)]);
var inst_45170 = (state_45250[(2)]);
var inst_45171 = (inst_45101 <= (0));
var state_45250__$1 = (function (){var statearr_45274 = state_45250;
(statearr_45274[(11)] = inst_45170);

return statearr_45274;
})();
if(cljs.core.truth_(inst_45171)){
var statearr_45275_45405 = state_45250__$1;
(statearr_45275_45405[(1)] = (55));

} else {
var statearr_45276_45406 = state_45250__$1;
(statearr_45276_45406[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (15))){
var inst_45051 = (state_45250[(19)]);
var inst_45059 = (state_45250[(2)]);
var inst_45060 = fluree.db.util.async.throw_err(inst_45059);
var inst_45061 = [inst_45051];
var inst_45062 = [inst_45060];
var inst_45063 = cljs.core.PersistentHashMap.fromArrays(inst_45061,inst_45062);
var state_45250__$1 = state_45250;
var statearr_45277_45407 = state_45250__$1;
(statearr_45277_45407[(2)] = inst_45063);

(statearr_45277_45407[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (48))){
var inst_45158 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
if(cljs.core.truth_(inst_45158)){
var statearr_45278_45408 = state_45250__$1;
(statearr_45278_45408[(1)] = (49));

} else {
var statearr_45279_45409 = state_45250__$1;
(statearr_45279_45409[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (50))){
var inst_45153 = (state_45250[(20)]);
var state_45250__$1 = state_45250;
var statearr_45280_45410 = state_45250__$1;
(statearr_45280_45410[(2)] = inst_45153);

(statearr_45280_45410[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (75))){
var state_45250__$1 = state_45250;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_45281_45411 = state_45250__$1;
(statearr_45281_45411[(1)] = (80));

} else {
var statearr_45282_45412 = state_45250__$1;
(statearr_45282_45412[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (21))){
var inst_45079 = (state_45250[(21)]);
var inst_45083 = (state_45250[(22)]);
var inst_45091 = (state_45250[(23)]);
var inst_45096 = (state_45250[(2)]);
var inst_45097 = cljs.core.PersistentHashMap.EMPTY;
var inst_45098 = inst_45079;
var inst_45099 = inst_45083;
var inst_45100 = inst_45091;
var inst_45101 = inst_45096;
var inst_45102 = inst_45097;
var state_45250__$1 = (function (){var statearr_45283 = state_45250;
(statearr_45283[(8)] = inst_45101);

(statearr_45283[(9)] = inst_45100);

(statearr_45283[(14)] = inst_45099);

(statearr_45283[(15)] = inst_45098);

(statearr_45283[(16)] = inst_45102);

return statearr_45283;
})();
var statearr_45284_45413 = state_45250__$1;
(statearr_45284_45413[(2)] = null);

(statearr_45284_45413[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (31))){
var inst_45101 = (state_45250[(8)]);
var inst_45116 = (state_45250[(24)]);
var inst_45130 = (inst_45101 >= inst_45116);
var state_45250__$1 = state_45250;
if(cljs.core.truth_(inst_45130)){
var statearr_45285_45414 = state_45250__$1;
(statearr_45285_45414[(1)] = (33));

} else {
var statearr_45286_45415 = state_45250__$1;
(statearr_45286_45415[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (32))){
var inst_45206 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
var statearr_45287_45416 = state_45250__$1;
(statearr_45287_45416[(2)] = inst_45206);

(statearr_45287_45416[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (40))){
var state_45250__$1 = state_45250;
var statearr_45288_45417 = state_45250__$1;
(statearr_45288_45417[(2)] = null);

(statearr_45288_45417[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (56))){
var state_45250__$1 = state_45250;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_45289_45418 = state_45250__$1;
(statearr_45289_45418[(1)] = (58));

} else {
var statearr_45290_45419 = state_45250__$1;
(statearr_45290_45419[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (33))){
var state_45250__$1 = state_45250;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_45291_45420 = state_45250__$1;
(statearr_45291_45420[(1)] = (36));

} else {
var statearr_45292_45421 = state_45250__$1;
(statearr_45292_45421[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (13))){
var inst_45079 = (state_45250[(21)]);
var inst_45048 = (state_45250[(25)]);
var inst_45083 = (state_45250[(22)]);
var inst_45079__$1 = cljs.core.keys(inst_45048);
var inst_45080 = cljs.core.seq(inst_45079__$1);
var inst_45081 = cljs.core.first(inst_45080);
var inst_45082 = cljs.core.next(inst_45080);
var inst_45083__$1 = cljs.core.vals(inst_45048);
var inst_45084 = cljs.core.seq(inst_45083__$1);
var inst_45085 = cljs.core.first(inst_45084);
var inst_45086 = cljs.core.next(inst_45084);
var inst_45087 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_45250__$1 = (function (){var statearr_45293 = state_45250;
(statearr_45293[(21)] = inst_45079__$1);

(statearr_45293[(26)] = inst_45081);

(statearr_45293[(22)] = inst_45083__$1);

(statearr_45293[(27)] = inst_45086);

(statearr_45293[(28)] = inst_45082);

(statearr_45293[(29)] = inst_45085);

return statearr_45293;
})();
if(inst_45087){
var statearr_45294_45422 = state_45250__$1;
(statearr_45294_45422[(1)] = (16));

} else {
var statearr_45295_45423 = state_45250__$1;
(statearr_45295_45423[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (22))){
var inst_45099 = (state_45250[(14)]);
var inst_45098 = (state_45250[(15)]);
var inst_45110 = cljs.core.seq(inst_45098);
var inst_45111 = cljs.core.first(inst_45110);
var inst_45112 = cljs.core.next(inst_45110);
var inst_45113 = cljs.core.seq(inst_45099);
var inst_45114 = cljs.core.first(inst_45113);
var inst_45115 = cljs.core.next(inst_45113);
var inst_45116 = cljs.core.count(inst_45114);
var inst_45117 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_45118 = [headers,vars,inst_45114];
var inst_45119 = cljs.core.PersistentHashMap.fromArrays(inst_45117,inst_45118);
var inst_45120 = (inst_45114 == null);
var state_45250__$1 = (function (){var statearr_45296 = state_45250;
(statearr_45296[(10)] = inst_45115);

(statearr_45296[(24)] = inst_45116);

(statearr_45296[(12)] = inst_45112);

(statearr_45296[(30)] = inst_45111);

(statearr_45296[(17)] = inst_45119);

return statearr_45296;
})();
if(cljs.core.truth_(inst_45120)){
var statearr_45297_45424 = state_45250__$1;
(statearr_45297_45424[(1)] = (24));

} else {
var statearr_45298_45425 = state_45250__$1;
(statearr_45298_45425[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (36))){
var inst_45101 = (state_45250[(8)]);
var inst_45133 = (inst_45101 - (1));
var state_45250__$1 = state_45250;
var statearr_45299_45426 = state_45250__$1;
(statearr_45299_45426[(2)] = inst_45133);

(statearr_45299_45426[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (41))){
var inst_45202 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
var statearr_45300_45427 = state_45250__$1;
(statearr_45300_45427[(2)] = inst_45202);

(statearr_45300_45427[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (43))){
var inst_45101 = (state_45250[(8)]);
var inst_45147 = (state_45250[(31)]);
var inst_45150 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_45101,inst_45147);
var state_45250__$1 = state_45250;
var statearr_45301_45428 = state_45250__$1;
(statearr_45301_45428[(2)] = inst_45150);

(statearr_45301_45428[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (61))){
var inst_45101 = (state_45250[(8)]);
var inst_45163 = (state_45250[(7)]);
var inst_45116 = (state_45250[(24)]);
var inst_45178 = cljs.core.count(inst_45163);
var inst_45179 = (inst_45116 - inst_45178);
var inst_45180 = (inst_45101 - inst_45179);
var state_45250__$1 = state_45250;
var statearr_45302_45429 = state_45250__$1;
(statearr_45302_45429[(2)] = inst_45180);

(statearr_45302_45429[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (29))){
var inst_45127 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
if(cljs.core.truth_(inst_45127)){
var statearr_45303_45430 = state_45250__$1;
(statearr_45303_45430[(1)] = (30));

} else {
var statearr_45304_45431 = state_45250__$1;
(statearr_45304_45431[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (44))){
var inst_45147 = (state_45250[(31)]);
var state_45250__$1 = state_45250;
var statearr_45305_45432 = state_45250__$1;
(statearr_45305_45432[(2)] = inst_45147);

(statearr_45305_45432[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (6))){
var inst_45040 = (state_45250[(32)]);
var inst_45040__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_45042 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_45250__$1 = (function (){var statearr_45306 = state_45250;
(statearr_45306[(32)] = inst_45040__$1);

(statearr_45306[(33)] = inst_45042);

return statearr_45306;
})();
if(cljs.core.truth_(inst_45040__$1)){
var statearr_45307_45433 = state_45250__$1;
(statearr_45307_45433[(1)] = (9));

} else {
var statearr_45308_45434 = state_45250__$1;
(statearr_45308_45434[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (28))){
var inst_45100 = (state_45250[(9)]);
var state_45250__$1 = state_45250;
var statearr_45309_45435 = state_45250__$1;
(statearr_45309_45435[(2)] = inst_45100);

(statearr_45309_45435[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (64))){
var inst_45188 = (state_45250[(34)]);
var state_45250__$1 = state_45250;
var statearr_45310_45436 = state_45250__$1;
(statearr_45310_45436[(2)] = inst_45188);

(statearr_45310_45436[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (51))){
var inst_45100 = (state_45250[(9)]);
var inst_45163 = (state_45250[(2)]);
var inst_45164 = (inst_45100 == null);
var state_45250__$1 = (function (){var statearr_45311 = state_45250;
(statearr_45311[(7)] = inst_45163);

return statearr_45311;
})();
if(cljs.core.truth_(inst_45164)){
var statearr_45312_45437 = state_45250__$1;
(statearr_45312_45437[(1)] = (52));

} else {
var statearr_45313_45438 = state_45250__$1;
(statearr_45313_45438[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (25))){
var inst_45100 = (state_45250[(9)]);
var state_45250__$1 = state_45250;
if(cljs.core.truth_(inst_45100)){
var statearr_45314_45439 = state_45250__$1;
(statearr_45314_45439[(1)] = (27));

} else {
var statearr_45315_45440 = state_45250__$1;
(statearr_45315_45440[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (34))){
var state_45250__$1 = state_45250;
var statearr_45316_45441 = state_45250__$1;
(statearr_45316_45441[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (17))){
var state_45250__$1 = state_45250;
var statearr_45318_45442 = state_45250__$1;
(statearr_45318_45442[(2)] = limit);

(statearr_45318_45442[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (3))){
var inst_45248 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45250__$1,inst_45248);
} else {
if((state_val_45251 === (12))){
var inst_45048 = (state_45250[(25)]);
var inst_45050 = cljs.core.keys(inst_45048);
var inst_45051 = cljs.core.first(inst_45050);
var inst_45052 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_45053 = cljs.core.vals(inst_45048);
var inst_45054 = cljs.core.first(inst_45053);
var inst_45055 = [headers,vars,inst_45054];
var inst_45056 = cljs.core.PersistentHashMap.fromArrays(inst_45052,inst_45055);
var inst_45057 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_45056,select_spec,limit,opts);
var state_45250__$1 = (function (){var statearr_45319 = state_45250;
(statearr_45319[(19)] = inst_45051);

return statearr_45319;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45250__$1,(15),inst_45057);
} else {
if((state_val_45251 === (2))){
var _ = (function (){var statearr_45320 = state_45250;
(statearr_45320[(4)] = cljs.core.cons((5),(state_45250[(4)])));

return statearr_45320;
})();
var state_45250__$1 = state_45250;
if(cljs.core.truth_(groupBy)){
var statearr_45321_45443 = state_45250__$1;
(statearr_45321_45443[(1)] = (6));

} else {
var statearr_45322_45444 = state_45250__$1;
(statearr_45322_45444[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (66))){
var inst_45193 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
if(cljs.core.truth_(inst_45193)){
var statearr_45323_45445 = state_45250__$1;
(statearr_45323_45445[(1)] = (67));

} else {
var statearr_45324_45446 = state_45250__$1;
(statearr_45324_45446[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (23))){
var inst_45210 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
var statearr_45325_45447 = state_45250__$1;
(statearr_45325_45447[(2)] = inst_45210);

(statearr_45325_45447[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (47))){
var inst_45100 = (state_45250[(9)]);
var state_45250__$1 = state_45250;
var statearr_45326_45448 = state_45250__$1;
(statearr_45326_45448[(2)] = inst_45100);

(statearr_45326_45448[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (35))){
var inst_45204 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
var statearr_45327_45449 = state_45250__$1;
(statearr_45327_45449[(2)] = inst_45204);

(statearr_45327_45449[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (82))){
var inst_45241 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
var statearr_45328_45450 = state_45250__$1;
(statearr_45328_45450[(2)] = inst_45241);

(statearr_45328_45450[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (76))){
var inst_45243 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
var statearr_45329_45451 = state_45250__$1;
(statearr_45329_45451[(2)] = inst_45243);

(statearr_45329_45451[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (19))){
var inst_45092 = (state_45250[(35)]);
var state_45250__$1 = state_45250;
var statearr_45330_45452 = state_45250__$1;
(statearr_45330_45452[(2)] = inst_45092);

(statearr_45330_45452[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (57))){
var inst_45163 = (state_45250[(7)]);
var inst_45188 = (state_45250[(34)]);
var inst_45187 = (state_45250[(2)]);
var inst_45188__$1 = (inst_45163 == null);
var state_45250__$1 = (function (){var statearr_45331 = state_45250;
(statearr_45331[(34)] = inst_45188__$1);

(statearr_45331[(13)] = inst_45187);

return statearr_45331;
})();
if(cljs.core.truth_(inst_45188__$1)){
var statearr_45332_45453 = state_45250__$1;
(statearr_45332_45453[(1)] = (64));

} else {
var statearr_45333_45454 = state_45250__$1;
(statearr_45333_45454[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (68))){
var inst_45163 = (state_45250[(7)]);
var inst_45111 = (state_45250[(30)]);
var inst_45102 = (state_45250[(16)]);
var inst_45196 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_45102,inst_45111,inst_45163);
var state_45250__$1 = state_45250;
var statearr_45334_45455 = state_45250__$1;
(statearr_45334_45455[(2)] = inst_45196);

(statearr_45334_45455[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (11))){
var inst_45048 = (state_45250[(2)]);
var state_45250__$1 = (function (){var statearr_45336 = state_45250;
(statearr_45336[(25)] = inst_45048);

return statearr_45336;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_45337_45456 = state_45250__$1;
(statearr_45337_45456[(1)] = (12));

} else {
var statearr_45338_45457 = state_45250__$1;
(statearr_45338_45457[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (9))){
var inst_45040 = (state_45250[(32)]);
var inst_45042 = (state_45250[(33)]);
var inst_45044 = cljs.core.sorted_map_by(inst_45040);
var inst_45045 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_45044,inst_45042);
var state_45250__$1 = state_45250;
var statearr_45339_45458 = state_45250__$1;
(statearr_45339_45458[(2)] = inst_45045);

(statearr_45339_45458[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (5))){
var _ = (function (){var statearr_45340 = state_45250;
(statearr_45340[(4)] = cljs.core.rest((state_45250[(4)])));

return statearr_45340;
})();
var state_45250__$1 = state_45250;
var ex45335 = (state_45250__$1[(2)]);
var statearr_45341_45459 = state_45250__$1;
(statearr_45341_45459[(5)] = ex45335);


if((ex45335 instanceof Error)){
var statearr_45342_45460 = state_45250__$1;
(statearr_45342_45460[(1)] = (4));

(statearr_45342_45460[(5)] = null);

} else {
throw ex45335;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (83))){
var inst_45221 = (state_45250[(18)]);
var state_45250__$1 = state_45250;
var statearr_45343_45461 = state_45250__$1;
(statearr_45343_45461[(2)] = inst_45221);

(statearr_45343_45461[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (14))){
var inst_45212 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
var statearr_45344_45462 = state_45250__$1;
(statearr_45344_45462[(2)] = inst_45212);

(statearr_45344_45462[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (45))){
var inst_45100 = (state_45250[(9)]);
var inst_45153 = (state_45250[(2)]);
var state_45250__$1 = (function (){var statearr_45345 = state_45250;
(statearr_45345[(20)] = inst_45153);

return statearr_45345;
})();
if(cljs.core.truth_(inst_45100)){
var statearr_45346_45463 = state_45250__$1;
(statearr_45346_45463[(1)] = (46));

} else {
var statearr_45347_45464 = state_45250__$1;
(statearr_45347_45464[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (53))){
var inst_45163 = (state_45250[(7)]);
var inst_45100 = (state_45250[(9)]);
var inst_45167 = cljs.core.count(inst_45163);
var inst_45168 = (inst_45100 - inst_45167);
var state_45250__$1 = state_45250;
var statearr_45348_45465 = state_45250__$1;
(statearr_45348_45465[(2)] = inst_45168);

(statearr_45348_45465[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (78))){
var inst_45221 = (state_45250[(18)]);
var state_45250__$1 = state_45250;
var statearr_45349_45466 = state_45250__$1;
(statearr_45349_45466[(2)] = inst_45221);

(statearr_45349_45466[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (26))){
var inst_45208 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
var statearr_45350_45467 = state_45250__$1;
(statearr_45350_45467[(2)] = inst_45208);

(statearr_45350_45467[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (16))){
var state_45250__$1 = state_45250;
var statearr_45351_45468 = state_45250__$1;
(statearr_45351_45468[(2)] = null);

(statearr_45351_45468[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (81))){
var state_45250__$1 = state_45250;
var statearr_45354_45469 = state_45250__$1;
(statearr_45354_45469[(1)] = (83));



return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (79))){
var inst_45231 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
var statearr_45356_45470 = state_45250__$1;
(statearr_45356_45470[(2)] = inst_45231);

(statearr_45356_45470[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (38))){
var inst_45115 = (state_45250[(10)]);
var inst_45100 = (state_45250[(9)]);
var inst_45112 = (state_45250[(12)]);
var inst_45102 = (state_45250[(16)]);
var inst_45137 = (state_45250[(2)]);
var tmp45352 = inst_45100;
var tmp45353 = inst_45102;
var inst_45098 = inst_45112;
var inst_45099 = inst_45115;
var inst_45100__$1 = tmp45352;
var inst_45101 = inst_45137;
var inst_45102__$1 = tmp45353;
var state_45250__$1 = (function (){var statearr_45357 = state_45250;
(statearr_45357[(8)] = inst_45101);

(statearr_45357[(9)] = inst_45100__$1);

(statearr_45357[(14)] = inst_45099);

(statearr_45357[(15)] = inst_45098);

(statearr_45357[(16)] = inst_45102__$1);

return statearr_45357;
})();
var statearr_45358_45471 = state_45250__$1;
(statearr_45358_45471[(2)] = null);

(statearr_45358_45471[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (30))){
var inst_45102 = (state_45250[(16)]);
var state_45250__$1 = state_45250;
var statearr_45359_45472 = state_45250__$1;
(statearr_45359_45472[(2)] = inst_45102);

(statearr_45359_45472[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (73))){
var inst_45221 = (state_45250[(18)]);
var inst_45220 = (state_45250[(2)]);
var inst_45221__$1 = fluree.db.util.async.throw_err(inst_45220);
var inst_45222 = cljs.core.coll_QMARK_(inst_45221__$1);
var inst_45223 = (!(inst_45222));
var state_45250__$1 = (function (){var statearr_45360 = state_45250;
(statearr_45360[(18)] = inst_45221__$1);

return statearr_45360;
})();
if(inst_45223){
var statearr_45361_45473 = state_45250__$1;
(statearr_45361_45473[(1)] = (74));

} else {
var statearr_45362_45474 = state_45250__$1;
(statearr_45362_45474[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (10))){
var inst_45042 = (state_45250[(33)]);
var state_45250__$1 = state_45250;
var statearr_45363_45475 = state_45250__$1;
(statearr_45363_45475[(2)] = inst_45042);

(statearr_45363_45475[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (18))){
var inst_45092 = (state_45250[(35)]);
var inst_45091 = (state_45250[(2)]);
var inst_45092__$1 = offset;
var state_45250__$1 = (function (){var statearr_45364 = state_45250;
(statearr_45364[(35)] = inst_45092__$1);

(statearr_45364[(23)] = inst_45091);

return statearr_45364;
})();
if(cljs.core.truth_(inst_45092__$1)){
var statearr_45365_45476 = state_45250__$1;
(statearr_45365_45476[(1)] = (19));

} else {
var statearr_45366_45477 = state_45250__$1;
(statearr_45366_45477[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (52))){
var state_45250__$1 = state_45250;
var statearr_45367_45478 = state_45250__$1;
(statearr_45367_45478[(2)] = null);

(statearr_45367_45478[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (67))){
var inst_45102 = (state_45250[(16)]);
var state_45250__$1 = state_45250;
var statearr_45368_45479 = state_45250__$1;
(statearr_45368_45479[(2)] = inst_45102);

(statearr_45368_45479[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (71))){
var state_45250__$1 = state_45250;
var statearr_45369_45480 = state_45250__$1;
(statearr_45369_45480[(2)] = limit);

(statearr_45369_45480[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (42))){
var inst_45101 = (state_45250[(8)]);
var inst_45146 = (state_45250[(2)]);
var inst_45147 = fluree.db.util.async.throw_err(inst_45146);
var inst_45148 = ((0) < inst_45101);
var state_45250__$1 = (function (){var statearr_45370 = state_45250;
(statearr_45370[(31)] = inst_45147);

return statearr_45370;
})();
if(cljs.core.truth_(inst_45148)){
var statearr_45371_45481 = state_45250__$1;
(statearr_45371_45481[(1)] = (43));

} else {
var statearr_45372_45482 = state_45250__$1;
(statearr_45372_45482[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (80))){
var inst_45221 = (state_45250[(18)]);
var inst_45234 = cljs.core.first(inst_45221);
var state_45250__$1 = state_45250;
var statearr_45373_45483 = state_45250__$1;
(statearr_45373_45483[(2)] = inst_45234);

(statearr_45373_45483[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (37))){
var inst_45101 = (state_45250[(8)]);
var inst_45116 = (state_45250[(24)]);
var inst_45135 = (inst_45101 - inst_45116);
var state_45250__$1 = state_45250;
var statearr_45374_45484 = state_45250__$1;
(statearr_45374_45484[(2)] = inst_45135);

(statearr_45374_45484[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (63))){
var inst_45183 = (state_45250[(2)]);
var state_45250__$1 = state_45250;
var statearr_45375_45485 = state_45250__$1;
(statearr_45375_45485[(2)] = inst_45183);

(statearr_45375_45485[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (8))){
var inst_45245 = (state_45250[(2)]);
var _ = (function (){var statearr_45376 = state_45250;
(statearr_45376[(4)] = cljs.core.rest((state_45250[(4)])));

return statearr_45376;
})();
var state_45250__$1 = state_45250;
var statearr_45377_45486 = state_45250__$1;
(statearr_45377_45486[(2)] = inst_45245);

(statearr_45377_45486[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (49))){
var inst_45100 = (state_45250[(9)]);
var inst_45153 = (state_45250[(20)]);
var inst_45160 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_45100,inst_45153);
var state_45250__$1 = state_45250;
var statearr_45378_45487 = state_45250__$1;
(statearr_45378_45487[(2)] = inst_45160);

(statearr_45378_45487[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45251 === (84))){
var state_45250__$1 = state_45250;
var statearr_45379_45488 = state_45250__$1;
(statearr_45379_45488[(2)] = null);

(statearr_45379_45488[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__20477__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__20477__auto____0 = (function (){
var statearr_45380 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45380[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__20477__auto__);

(statearr_45380[(1)] = (1));

return statearr_45380;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__20477__auto____1 = (function (state_45250){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_45250);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e45381){var ex__20480__auto__ = e45381;
var statearr_45382_45489 = state_45250;
(statearr_45382_45489[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_45250[(4)]))){
var statearr_45383_45490 = state_45250;
(statearr_45383_45490[(1)] = cljs.core.first((state_45250[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__45491 = state_45250;
state_45250 = G__45491;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__20477__auto__ = function(state_45250){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__20477__auto____1.call(this,state_45250);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__20477__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__20477__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_45384 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_45384[(6)] = c__20603__auto__);

return statearr_45384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__45494,opts){
var map__45495 = p__45494;
var map__45495__$1 = cljs.core.__destructure_map(map__45495);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45495__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45495__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45495__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45495__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4223__auto__ = selectOne;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = select;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
var or__4223__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4223__auto____$2)){
return or__4223__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__45492_SHARP_){
return cljs.core.contains_QMARK_(p1__45492_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__45493_SHARP_){
return cljs.core.contains_QMARK_(p1__45493_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4223__auto__ = typeof orderBy === 'string';
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4221__auto__){
var G__45497 = cljs.core.first(orderBy);
var fexpr__45496 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__45496.cljs$core$IFn$_invoke$arity$1 ? fexpr__45496.cljs$core$IFn$_invoke$arity$1(G__45497) : fexpr__45496.call(null,G__45497));
} else {
return and__4221__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4223__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})(),(function (){var or__4223__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4223__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4223__auto__ = selectDistinct;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__45498,p__45499){
var map__45500 = p__45498;
var map__45500__$1 = cljs.core.__destructure_map(map__45500);
var query_map = map__45500__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45500__$1,cljs.core.cst$kw$construct);
var map__45501 = p__45499;
var map__45501__$1 = cljs.core.__destructure_map(map__45501);
var where_result = map__45501__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45501__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45501__$1,cljs.core.cst$kw$tuples);
var vec__45502 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45502,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45502,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45502,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_45535){
var state_val_45536 = (state_45535[(1)]);
if((state_val_45536 === (7))){
var inst_45514 = (state_45535[(7)]);
var state_45535__$1 = state_45535;
var statearr_45537_45560 = state_45535__$1;
(statearr_45537_45560[(2)] = inst_45514);

(statearr_45537_45560[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45536 === (1))){
var state_45535__$1 = state_45535;
var statearr_45538_45561 = state_45535__$1;
(statearr_45538_45561[(2)] = null);

(statearr_45538_45561[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45536 === (4))){
var inst_45505 = (state_45535[(2)]);
var state_45535__$1 = state_45535;
var statearr_45539_45562 = state_45535__$1;
(statearr_45539_45562[(2)] = inst_45505);

(statearr_45539_45562[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45536 === (13))){
var inst_45524 = (state_45535[(2)]);
var inst_45525 = fluree.db.util.async.throw_err(inst_45524);
var state_45535__$1 = state_45535;
var statearr_45540_45563 = state_45535__$1;
(statearr_45540_45563[(2)] = inst_45525);

(statearr_45540_45563[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45536 === (6))){
var inst_45514 = (state_45535[(7)]);
var inst_45513 = (state_45535[(2)]);
var inst_45514__$1 = fluree.db.util.async.throw_err(inst_45513);
var inst_45515 = fluree.db.util.core.exception_QMARK_(inst_45514__$1);
var state_45535__$1 = (function (){var statearr_45541 = state_45535;
(statearr_45541[(7)] = inst_45514__$1);

return statearr_45541;
})();
if(inst_45515){
var statearr_45542_45564 = state_45535__$1;
(statearr_45542_45564[(1)] = (7));

} else {
var statearr_45543_45565 = state_45535__$1;
(statearr_45543_45565[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45536 === (3))){
var inst_45533 = (state_45535[(2)]);
var state_45535__$1 = state_45535;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45535__$1,inst_45533);
} else {
if((state_val_45536 === (12))){
var inst_45528 = (state_45535[(2)]);
var state_45535__$1 = state_45535;
var statearr_45544_45566 = state_45535__$1;
(statearr_45544_45566[(2)] = inst_45528);

(statearr_45544_45566[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45536 === (2))){
var _ = (function (){var statearr_45545 = state_45535;
(statearr_45545[(4)] = cljs.core.cons((5),(state_45535[(4)])));

return statearr_45545;
})();
var inst_45511 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_45535__$1 = state_45535;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45535__$1,(6),inst_45511);
} else {
if((state_val_45536 === (11))){
var state_45535__$1 = state_45535;
var statearr_45547_45567 = state_45535__$1;
(statearr_45547_45567[(2)] = null);

(statearr_45547_45567[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45536 === (9))){
var inst_45530 = (state_45535[(2)]);
var _ = (function (){var statearr_45548 = state_45535;
(statearr_45548[(4)] = cljs.core.rest((state_45535[(4)])));

return statearr_45548;
})();
var state_45535__$1 = state_45535;
var statearr_45549_45568 = state_45535__$1;
(statearr_45549_45568[(2)] = inst_45530);

(statearr_45549_45568[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45536 === (5))){
var _ = (function (){var statearr_45550 = state_45535;
(statearr_45550[(4)] = cljs.core.rest((state_45535[(4)])));

return statearr_45550;
})();
var state_45535__$1 = state_45535;
var ex45546 = (state_45535__$1[(2)]);
var statearr_45551_45569 = state_45535__$1;
(statearr_45551_45569[(5)] = ex45546);


if((ex45546 instanceof Error)){
var statearr_45552_45570 = state_45535__$1;
(statearr_45552_45570[(1)] = (4));

(statearr_45552_45570[(5)] = null);

} else {
throw ex45546;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45536 === (10))){
var inst_45514 = (state_45535[(7)]);
var inst_45519 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_45514);
var inst_45520 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_45514);
var inst_45521 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_45519,inst_45520,query_map,opts);
var inst_45522 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_45514,inst_45521,opts);
var state_45535__$1 = state_45535;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45535__$1,(13),inst_45522);
} else {
if((state_val_45536 === (8))){
var state_45535__$1 = state_45535;
var statearr_45553_45571 = state_45535__$1;
(statearr_45553_45571[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__20477__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__20477__auto____0 = (function (){
var statearr_45555 = [null,null,null,null,null,null,null,null];
(statearr_45555[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__20477__auto__);

(statearr_45555[(1)] = (1));

return statearr_45555;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__20477__auto____1 = (function (state_45535){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_45535);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e45556){var ex__20480__auto__ = e45556;
var statearr_45557_45572 = state_45535;
(statearr_45557_45572[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_45535[(4)]))){
var statearr_45558_45573 = state_45535;
(statearr_45558_45573[(1)] = cljs.core.first((state_45535[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__45574 = state_45535;
state_45535 = G__45574;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__20477__auto__ = function(state_45535){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__20477__auto____1.call(this,state_45535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__20477__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__20477__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_45559 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_45559[(6)] = c__20603__auto__);

return statearr_45559;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__45575 = query_map;
var map__45575__$1 = cljs.core.__destructure_map(map__45575);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45575__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45575__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45575__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45575__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45575__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45575__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45575__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45575__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45575__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45575__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45575__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45575__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__45576 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4223__auto__ = offset;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45576,cljs.core.cst$kw$limit,(1));
} else {
return G__45576;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4223__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.truth_((function (){var or__4223__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_45935){
var state_val_45936 = (state_45935[(1)]);
if((state_val_45936 === (121))){
var inst_45896 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_45937_46132 = state_45935__$1;
(statearr_45937_46132[(2)] = inst_45896);

(statearr_45937_46132[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (65))){
var inst_45769 = typeof from === 'string';
var state_45935__$1 = state_45935;
if(cljs.core.truth_(inst_45769)){
var statearr_45938_46133 = state_45935__$1;
(statearr_45938_46133[(1)] = (72));

} else {
var statearr_45939_46134 = state_45935__$1;
(statearr_45939_46134[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (70))){
var inst_45638 = (state_45935[(7)]);
var inst_45640 = (state_45935[(8)]);
var inst_45762 = (state_45935[(2)]);
var inst_45763 = fluree.db.util.async.throw_err(inst_45762);
var inst_45764 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_45640,fuel,max_fuel,inst_45638,inst_45763);
var state_45935__$1 = state_45935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45935__$1,(71),inst_45764);
} else {
if((state_val_45936 === (62))){
var inst_45742 = (state_45935[(9)]);
var state_45935__$1 = state_45935;
var statearr_45940_46135 = state_45935__$1;
(statearr_45940_46135[(2)] = inst_45742);

(statearr_45940_46135[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (74))){
var inst_45902 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_45941_46136 = state_45935__$1;
(statearr_45941_46136[(2)] = inst_45902);

(statearr_45941_46136[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (110))){
var inst_45835 = (state_45935[(10)]);
var state_45935__$1 = state_45935;
var statearr_45942_46137 = state_45935__$1;
(statearr_45942_46137[(2)] = inst_45835);

(statearr_45942_46137[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (130))){
var inst_45922 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_45943_46138 = state_45935__$1;
(statearr_45943_46138[(2)] = inst_45922);

(statearr_45943_46138[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (128))){
var inst_45913 = (state_45935[(11)]);
var inst_45918 = fluree.db.util.core.exception_QMARK_(inst_45913);
var inst_45919 = (!(inst_45918));
var state_45935__$1 = state_45935;
var statearr_45944_46139 = state_45935__$1;
(statearr_45944_46139[(2)] = inst_45919);

(statearr_45944_46139[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (7))){
var inst_45608 = (state_45935[(12)]);
var inst_45608__$1 = selectOne;
var state_45935__$1 = (function (){var statearr_45945 = state_45935;
(statearr_45945[(12)] = inst_45608__$1);

return statearr_45945;
})();
if(cljs.core.truth_(inst_45608__$1)){
var statearr_45946_46140 = state_45935__$1;
(statearr_45946_46140[(1)] = (9));

} else {
var statearr_45947_46141 = state_45935__$1;
(statearr_45947_46141[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (59))){
var inst_45638 = (state_45935[(7)]);
var inst_45640 = (state_45935[(8)]);
var inst_45720 = (state_45935[(13)]);
var inst_45628 = (state_45935[(14)]);
var inst_45734 = (state_45935[(2)]);
var inst_45735 = fluree.db.util.async.throw_err(inst_45734);
var inst_45736 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_45720,inst_45735);
var inst_45737 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_45640,fuel,max_fuel,inst_45638,inst_45736,inst_45628);
var state_45935__$1 = state_45935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45935__$1,(60),inst_45737);
} else {
if((state_val_45936 === (86))){
var inst_45630 = (state_45935[(15)]);
var inst_45638 = (state_45935[(7)]);
var inst_45640 = (state_45935[(8)]);
var inst_45628 = (state_45935[(14)]);
var inst_45802 = (state_45935[(2)]);
var inst_45803 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_45640,fuel,max_fuel,inst_45638,inst_45802,inst_45628,inst_45630);
var state_45935__$1 = state_45935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45935__$1,(87),inst_45803);
} else {
if((state_val_45936 === (20))){
var inst_45672 = (state_45935[(2)]);
var inst_45673 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45672,(0),null);
var inst_45674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45672,(1),null);
var inst_45675 = typeof where === 'string';
var state_45935__$1 = (function (){var statearr_45948 = state_45935;
(statearr_45948[(16)] = inst_45673);

(statearr_45948[(17)] = inst_45674);

return statearr_45948;
})();
if(cljs.core.truth_(inst_45675)){
var statearr_45949_46142 = state_45935__$1;
(statearr_45949_46142[(1)] = (30));

} else {
var statearr_45950_46143 = state_45935__$1;
(statearr_45950_46143[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (72))){
var inst_45627 = (state_45935[(18)]);
var state_45935__$1 = state_45935;
if(cljs.core.truth_(inst_45627)){
var statearr_45951_46144 = state_45935__$1;
(statearr_45951_46144[(1)] = (75));

} else {
var statearr_45952_46145 = state_45935__$1;
(statearr_45952_46145[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (58))){
var inst_45728 = (state_45935[(2)]);
var inst_45729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45730 = [from];
var inst_45731 = (new cljs.core.PersistentVector(null,1,(5),inst_45729,inst_45730,null));
var inst_45732 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_45731,inst_45728);
var state_45935__$1 = state_45935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45935__$1,(59),inst_45732);
} else {
if((state_val_45936 === (60))){
var inst_45739 = (state_45935[(2)]);
var inst_45740 = fluree.db.util.async.throw_err(inst_45739);
var state_45935__$1 = state_45935;
var statearr_45953_46146 = state_45935__$1;
(statearr_45953_46146[(2)] = inst_45740);

(statearr_45953_46146[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (27))){
var inst_45657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45658 = [null,null];
var inst_45659 = (new cljs.core.PersistentVector(null,2,(5),inst_45657,inst_45658,null));
var state_45935__$1 = state_45935;
var statearr_45954_46147 = state_45935__$1;
(statearr_45954_46147[(2)] = inst_45659);

(statearr_45954_46147[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (1))){
var state_45935__$1 = state_45935;
var statearr_45955_46148 = state_45935__$1;
(statearr_45955_46148[(2)] = null);

(statearr_45955_46148[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (69))){
var inst_45759 = (state_45935[(2)]);
var inst_45760 = fluree.db.query.range._block_or_tx_collection(db,inst_45759);
var state_45935__$1 = state_45935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45935__$1,(70),inst_45760);
} else {
if((state_val_45936 === (101))){
var inst_45869 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_45956_46149 = state_45935__$1;
(statearr_45956_46149[(2)] = inst_45869);

(statearr_45956_46149[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (24))){
var inst_45627 = (state_45935[(18)]);
var inst_45652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45653 = [inst_45627,"ASC"];
var inst_45654 = (new cljs.core.PersistentVector(null,2,(5),inst_45652,inst_45653,null));
var state_45935__$1 = state_45935;
var statearr_45957_46150 = state_45935__$1;
(statearr_45957_46150[(2)] = inst_45654);

(statearr_45957_46150[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (102))){
var inst_45841 = (state_45935[(19)]);
var state_45935__$1 = state_45935;
var statearr_45958_46151 = state_45935__$1;
(statearr_45958_46151[(2)] = inst_45841);

(statearr_45958_46151[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (55))){
var inst_45627 = (state_45935[(18)]);
var inst_45720 = (state_45935[(2)]);
var state_45935__$1 = (function (){var statearr_45959 = state_45935;
(statearr_45959[(13)] = inst_45720);

return statearr_45959;
})();
if(cljs.core.truth_(inst_45627)){
var statearr_45960_46152 = state_45935__$1;
(statearr_45960_46152[(1)] = (56));

} else {
var statearr_45961_46153 = state_45935__$1;
(statearr_45961_46153[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (85))){
var inst_45794 = (state_45935[(20)]);
var inst_45798 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45799 = [inst_45794];
var inst_45800 = (new cljs.core.PersistentVector(null,1,(5),inst_45798,inst_45799,null));
var state_45935__$1 = state_45935;
var statearr_45962_46154 = state_45935__$1;
(statearr_45962_46154[(2)] = inst_45800);

(statearr_45962_46154[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (39))){
var inst_45628 = (state_45935[(14)]);
var state_45935__$1 = state_45935;
var statearr_45963_46155 = state_45935__$1;
(statearr_45963_46155[(2)] = inst_45628);

(statearr_45963_46155[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (88))){
var inst_45808 = cljs.core._deref(fuel);
var inst_45809 = (inst_45808 + (1));
var inst_45810 = cljs.core._vreset_BANG_(fuel,inst_45809);
var state_45935__$1 = state_45935;
var statearr_45964_46156 = state_45935__$1;
(statearr_45964_46156[(2)] = inst_45810);

(statearr_45964_46156[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (46))){
var inst_45705 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
if(cljs.core.truth_(inst_45705)){
var statearr_45965_46157 = state_45935__$1;
(statearr_45965_46157[(1)] = (47));

} else {
var statearr_45966_46158 = state_45935__$1;
(statearr_45966_46158[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (4))){
var inst_45595 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_45967_46159 = state_45935__$1;
(statearr_45967_46159[(2)] = inst_45595);

(statearr_45967_46159[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (77))){
var inst_45778 = (state_45935[(2)]);
var inst_45779 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_45778);
var state_45935__$1 = state_45935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45935__$1,(78),inst_45779);
} else {
if((state_val_45936 === (106))){
var state_45935__$1 = state_45935;
var statearr_45968_46160 = state_45935__$1;
(statearr_45968_46160[(2)] = null);

(statearr_45968_46160[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (119))){
var inst_45888 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_45889 = ["Invalid 'from' in query:",inst_45888].join('');
var inst_45890 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45891 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_45892 = cljs.core.PersistentHashMap.fromArrays(inst_45890,inst_45891);
var inst_45893 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45889,inst_45892);
var state_45935__$1 = state_45935;
var statearr_45969_46161 = state_45935__$1;
(statearr_45969_46161[(2)] = inst_45893);

(statearr_45969_46161[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (95))){
var state_45935__$1 = state_45935;
var statearr_45970_46162 = state_45935__$1;
(statearr_45970_46162[(1)] = (119));



return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (54))){
var inst_45714 = (state_45935[(21)]);
var state_45935__$1 = state_45935;
var statearr_45972_46163 = state_45935__$1;
(statearr_45972_46163[(2)] = inst_45714);

(statearr_45972_46163[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (92))){
var inst_45815 = (state_45935[(22)]);
var state_45935__$1 = state_45935;
var statearr_45973_46164 = state_45935__$1;
(statearr_45973_46164[(2)] = inst_45815);

(statearr_45973_46164[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (104))){
var inst_45861 = (state_45935[(23)]);
var inst_45861__$1 = (state_45935[(2)]);
var state_45935__$1 = (function (){var statearr_45974 = state_45935;
(statearr_45974[(23)] = inst_45861__$1);

return statearr_45974;
})();
if(cljs.core.truth_(inst_45861__$1)){
var statearr_45975_46165 = state_45935__$1;
(statearr_45975_46165[(1)] = (109));

} else {
var statearr_45976_46166 = state_45935__$1;
(statearr_45976_46166[(1)] = (110));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (15))){
var inst_45631 = (state_45935[(24)]);
var inst_45629 = (state_45935[(25)]);
var inst_45635 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_45631,cljs.core.cst$kw$componentFollow_QMARK_,inst_45629);
var state_45935__$1 = state_45935;
var statearr_45977_46167 = state_45935__$1;
(statearr_45977_46167[(2)] = inst_45635);

(statearr_45977_46167[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (48))){
var inst_45742 = (state_45935[(9)]);
var inst_45742__$1 = typeof from === 'string';
var state_45935__$1 = (function (){var statearr_45978 = state_45935;
(statearr_45978[(9)] = inst_45742__$1);

return statearr_45978;
})();
if(cljs.core.truth_(inst_45742__$1)){
var statearr_45979_46168 = state_45935__$1;
(statearr_45979_46168[(1)] = (61));

} else {
var statearr_45980_46169 = state_45935__$1;
(statearr_45980_46169[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (50))){
var inst_45708 = (state_45935[(26)]);
var inst_45710 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_45711 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_45708,inst_45710);
var state_45935__$1 = state_45935;
var statearr_45981_46170 = state_45935__$1;
(statearr_45981_46170[(2)] = inst_45711);

(statearr_45981_46170[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (116))){
var state_45935__$1 = state_45935;
var statearr_45982_46171 = state_45935__$1;
(statearr_45982_46171[(2)] = null);

(statearr_45982_46171[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (75))){
var inst_45772 = cljs.core.PersistentHashMap.EMPTY;
var state_45935__$1 = state_45935;
var statearr_45983_46172 = state_45935__$1;
(statearr_45983_46172[(2)] = inst_45772);

(statearr_45983_46172[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (99))){
var inst_45835 = (state_45935[(10)]);
var state_45935__$1 = state_45935;
var statearr_45984_46173 = state_45935__$1;
(statearr_45984_46173[(2)] = inst_45835);

(statearr_45984_46173[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (21))){
var inst_45627 = (state_45935[(18)]);
var inst_45644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45645 = cljs.core.second(inst_45627);
var inst_45646 = cljs.core.first(inst_45627);
var inst_45647 = [inst_45645,inst_45646];
var inst_45648 = (new cljs.core.PersistentVector(null,2,(5),inst_45644,inst_45647,null));
var state_45935__$1 = state_45935;
var statearr_45985_46174 = state_45935__$1;
(statearr_45985_46174[(2)] = inst_45648);

(statearr_45985_46174[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (31))){
var inst_45699 = (state_45935[(27)]);
var inst_45699__$1 = typeof from === 'string';
var state_45935__$1 = (function (){var statearr_45986 = state_45935;
(statearr_45986[(27)] = inst_45699__$1);

return statearr_45986;
})();
if(cljs.core.truth_(inst_45699__$1)){
var statearr_45987_46175 = state_45935__$1;
(statearr_45987_46175[(1)] = (44));

} else {
var statearr_45988_46176 = state_45935__$1;
(statearr_45988_46176[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (113))){
var state_45935__$1 = state_45935;
var statearr_45989_46177 = state_45935__$1;
(statearr_45989_46177[(2)] = null);

(statearr_45989_46177[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (32))){
var inst_45673 = (state_45935[(16)]);
var inst_45908 = (state_45935[(2)]);
var state_45935__$1 = (function (){var statearr_45990 = state_45935;
(statearr_45990[(28)] = inst_45908);

return statearr_45990;
})();
if(cljs.core.truth_(inst_45673)){
var statearr_45991_46178 = state_45935__$1;
(statearr_45991_46178[(1)] = (122));

} else {
var statearr_45992_46179 = state_45935__$1;
(statearr_45992_46179[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (40))){
var inst_45627 = (state_45935[(18)]);
var inst_45689 = (state_45935[(2)]);
var state_45935__$1 = (function (){var statearr_45993 = state_45935;
(statearr_45993[(29)] = inst_45689);

return statearr_45993;
})();
if(cljs.core.truth_(inst_45627)){
var statearr_45994_46180 = state_45935__$1;
(statearr_45994_46180[(1)] = (41));

} else {
var statearr_45995_46181 = state_45935__$1;
(statearr_45995_46181[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (129))){
var inst_45916 = (state_45935[(30)]);
var state_45935__$1 = state_45935;
var statearr_45996_46182 = state_45935__$1;
(statearr_45996_46182[(2)] = inst_45916);

(statearr_45996_46182[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (91))){
var inst_45817 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_45935__$1 = state_45935;
var statearr_45997_46183 = state_45935__$1;
(statearr_45997_46183[(2)] = inst_45817);

(statearr_45997_46183[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (117))){
var inst_45630 = (state_45935[(15)]);
var state_45935__$1 = state_45935;
var statearr_45998_46184 = state_45935__$1;
(statearr_45998_46184[(2)] = inst_45630);

(statearr_45998_46184[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (108))){
var inst_45858 = (state_45935[(2)]);
var inst_45859 = fluree.db.util.async.throw_err(inst_45858);
var state_45935__$1 = state_45935;
var statearr_45999_46185 = state_45935__$1;
(statearr_45999_46185[(2)] = inst_45859);

(statearr_45999_46185[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (56))){
var inst_45722 = cljs.core.PersistentHashMap.EMPTY;
var state_45935__$1 = state_45935;
var statearr_46000_46186 = state_45935__$1;
(statearr_46000_46186[(2)] = inst_45722);

(statearr_46000_46186[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (33))){
var state_45935__$1 = state_45935;
var statearr_46001_46187 = state_45935__$1;
(statearr_46001_46187[(2)] = from);

(statearr_46001_46187[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (13))){
var inst_45614 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45615 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_45616 = cljs.core.PersistentHashMap.fromArrays(inst_45614,inst_45615);
var inst_45617 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_45616);
var inst_45618 = (function(){throw inst_45617})();
var state_45935__$1 = state_45935;
var statearr_46002_46188 = state_45935__$1;
(statearr_46002_46188[(2)] = inst_45618);

(statearr_46002_46188[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (22))){
var inst_45627 = (state_45935[(18)]);
var inst_45650 = typeof inst_45627 === 'string';
var state_45935__$1 = state_45935;
if(cljs.core.truth_(inst_45650)){
var statearr_46003_46189 = state_45935__$1;
(statearr_46003_46189[(1)] = (24));

} else {
var statearr_46004_46190 = state_45935__$1;
(statearr_46004_46190[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (90))){
var inst_45806 = (state_45935[(31)]);
var inst_45813 = (state_45935[(2)]);
var state_45935__$1 = (function (){var statearr_46005 = state_45935;
(statearr_46005[(32)] = inst_45813);

return statearr_46005;
})();
var statearr_46006_46191 = state_45935__$1;
(statearr_46006_46191[(2)] = inst_45806);

(statearr_46006_46191[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (109))){
var inst_45861 = (state_45935[(23)]);
var inst_45835 = (state_45935[(10)]);
var inst_45863 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_45835,inst_45861);
var state_45935__$1 = state_45935;
var statearr_46007_46192 = state_45935__$1;
(statearr_46007_46192[(2)] = inst_45863);

(statearr_46007_46192[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (36))){
var inst_45627 = (state_45935[(18)]);
var inst_45684 = (state_45935[(2)]);
var inst_45685 = fluree.db.util.async.throw_err(inst_45684);
var state_45935__$1 = (function (){var statearr_46008 = state_45935;
(statearr_46008[(33)] = inst_45685);

return statearr_46008;
})();
if(cljs.core.truth_(inst_45627)){
var statearr_46009_46193 = state_45935__$1;
(statearr_46009_46193[(1)] = (38));

} else {
var statearr_46010_46194 = state_45935__$1;
(statearr_46010_46194[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (41))){
var state_45935__$1 = state_45935;
var statearr_46011_46195 = state_45935__$1;
(statearr_46011_46195[(2)] = null);

(statearr_46011_46195[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (118))){
var inst_45877 = (state_45935[(34)]);
var inst_45638 = (state_45935[(7)]);
var inst_45873 = (state_45935[(35)]);
var inst_45640 = (state_45935[(8)]);
var inst_45881 = (state_45935[(2)]);
var inst_45882 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_45640,fuel,max_fuel,inst_45638,inst_45873,inst_45877,inst_45881);
var state_45935__$1 = state_45935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45935__$1,(112),inst_45882);
} else {
if((state_val_45936 === (89))){
var state_45935__$1 = state_45935;
var statearr_46012_46196 = state_45935__$1;
(statearr_46012_46196[(2)] = null);

(statearr_46012_46196[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (100))){
var inst_45841 = (state_45935[(19)]);
var inst_45846 = cljs.core.int_QMARK_(inst_45841);
var state_45935__$1 = state_45935;
if(inst_45846){
var statearr_46013_46197 = state_45935__$1;
(statearr_46013_46197[(1)] = (102));

} else {
var statearr_46014_46198 = state_45935__$1;
(statearr_46014_46198[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (131))){
var inst_45913 = (state_45935[(11)]);
var inst_45927 = cljs.core.first(inst_45913);
var state_45935__$1 = state_45935;
var statearr_46015_46199 = state_45935__$1;
(statearr_46015_46199[(2)] = inst_45927);

(statearr_46015_46199[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (122))){
var inst_45630 = (state_45935[(15)]);
var inst_45908 = (state_45935[(28)]);
var inst_45673 = (state_45935[(16)]);
var inst_45628 = (state_45935[(14)]);
var inst_45674 = (state_45935[(17)]);
var inst_45910 = fluree.db.query.fql.sort_offset_and_limit_res(inst_45673,inst_45674,inst_45630,inst_45628,inst_45908);
var state_45935__$1 = state_45935;
var statearr_46016_46200 = state_45935__$1;
(statearr_46016_46200[(2)] = inst_45910);

(statearr_46016_46200[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (43))){
var inst_45638 = (state_45935[(7)]);
var inst_45685 = (state_45935[(33)]);
var inst_45640 = (state_45935[(8)]);
var inst_45689 = (state_45935[(29)]);
var inst_45693 = (state_45935[(2)]);
var inst_45694 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_45640,fuel,max_fuel,inst_45638,inst_45685,inst_45689,inst_45693);
var state_45935__$1 = state_45935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45935__$1,(37),inst_45694);
} else {
if((state_val_45936 === (61))){
var inst_45744 = ["_tx",null,"_block",null];
var inst_45745 = (new cljs.core.PersistentArrayMap(null,2,inst_45744,null));
var inst_45746 = (new cljs.core.PersistentHashSet(null,inst_45745,null));
var inst_45747 = (inst_45746.cljs$core$IFn$_invoke$arity$1 ? inst_45746.cljs$core$IFn$_invoke$arity$1(from) : inst_45746.call(null,from));
var state_45935__$1 = state_45935;
var statearr_46017_46201 = state_45935__$1;
(statearr_46017_46201[(2)] = inst_45747);

(statearr_46017_46201[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (29))){
var inst_45662 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_46018_46202 = state_45935__$1;
(statearr_46018_46202[(2)] = inst_45662);

(statearr_46018_46202[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (44))){
var inst_45701 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_45702 = clojure.string.includes_QMARK_(inst_45701,"/");
var state_45935__$1 = state_45935;
var statearr_46019_46203 = state_45935__$1;
(statearr_46019_46203[(2)] = inst_45702);

(statearr_46019_46203[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (93))){
var inst_45820 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
if(cljs.core.truth_(inst_45820)){
var statearr_46020_46204 = state_45935__$1;
(statearr_46020_46204[(1)] = (94));

} else {
var statearr_46021_46205 = state_45935__$1;
(statearr_46021_46205[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (6))){
var inst_45605 = (state_45935[(36)]);
var state_45935__$1 = state_45935;
var statearr_46022_46206 = state_45935__$1;
(statearr_46022_46206[(2)] = inst_45605);

(statearr_46022_46206[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (111))){
var inst_45842 = (state_45935[(37)]);
var inst_45866 = (state_45935[(2)]);
var inst_45834 = inst_45842;
var inst_45835 = inst_45866;
var state_45935__$1 = (function (){var statearr_46023 = state_45935;
(statearr_46023[(10)] = inst_45835);

(statearr_46023[(38)] = inst_45834);

return statearr_46023;
})();
var statearr_46024_46207 = state_45935__$1;
(statearr_46024_46207[(2)] = null);

(statearr_46024_46207[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (28))){
var state_45935__$1 = state_45935;
var statearr_46025_46208 = state_45935__$1;
(statearr_46025_46208[(2)] = null);

(statearr_46025_46208[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (64))){
var inst_45627 = (state_45935[(18)]);
var state_45935__$1 = state_45935;
if(cljs.core.truth_(inst_45627)){
var statearr_46026_46209 = state_45935__$1;
(statearr_46026_46209[(1)] = (67));

} else {
var statearr_46027_46210 = state_45935__$1;
(statearr_46027_46210[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (103))){
var state_45935__$1 = state_45935;
if(cljs.core.truth_(fuel)){
var statearr_46028_46211 = state_45935__$1;
(statearr_46028_46211[(1)] = (105));

} else {
var statearr_46029_46212 = state_45935__$1;
(statearr_46029_46212[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (51))){
var inst_45708 = (state_45935[(26)]);
var state_45935__$1 = state_45935;
var statearr_46030_46213 = state_45935__$1;
(statearr_46030_46213[(2)] = inst_45708);

(statearr_46030_46213[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (25))){
var state_45935__$1 = state_45935;
var statearr_46031_46214 = state_45935__$1;
(statearr_46031_46214[(1)] = (27));



return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (34))){
var state_45935__$1 = state_45935;
var statearr_46033_46215 = state_45935__$1;
(statearr_46033_46215[(2)] = null);

(statearr_46033_46215[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (125))){
var inst_45913 = (state_45935[(11)]);
var inst_45916 = (state_45935[(30)]);
var inst_45916__$1 = cljs.core.coll_QMARK_(inst_45913);
var state_45935__$1 = (function (){var statearr_46034 = state_45935;
(statearr_46034[(30)] = inst_45916__$1);

return statearr_46034;
})();
if(inst_45916__$1){
var statearr_46035_46216 = state_45935__$1;
(statearr_46035_46216[(1)] = (128));

} else {
var statearr_46036_46217 = state_45935__$1;
(statearr_46036_46217[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (17))){
var inst_45627 = (state_45935[(18)]);
var inst_45638 = (state_45935[(2)]);
var inst_45639 = cljs.core.PersistentHashMap.EMPTY;
var inst_45640 = cljs.core.volatile_BANG_(inst_45639);
var state_45935__$1 = (function (){var statearr_46037 = state_45935;
(statearr_46037[(7)] = inst_45638);

(statearr_46037[(8)] = inst_45640);

return statearr_46037;
})();
if(cljs.core.truth_(inst_45627)){
var statearr_46038_46218 = state_45935__$1;
(statearr_46038_46218[(1)] = (18));

} else {
var statearr_46039_46219 = state_45935__$1;
(statearr_46039_46219[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (3))){
var inst_45933 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45935__$1,inst_45933);
} else {
if((state_val_45936 === (12))){
var inst_45611 = (state_45935[(39)]);
var state_45935__$1 = state_45935;
var statearr_46040_46220 = state_45935__$1;
(statearr_46040_46220[(2)] = inst_45611);

(statearr_46040_46220[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (2))){
var inst_45605 = (state_45935[(36)]);
var _ = (function (){var statearr_46041 = state_45935;
(statearr_46041[(4)] = cljs.core.cons((5),(state_45935[(4)])));

return statearr_46041;
})();
var inst_45605__$1 = select;
var state_45935__$1 = (function (){var statearr_46042 = state_45935;
(statearr_46042[(36)] = inst_45605__$1);

return statearr_46042;
})();
if(cljs.core.truth_(inst_45605__$1)){
var statearr_46043_46221 = state_45935__$1;
(statearr_46043_46221[(1)] = (6));

} else {
var statearr_46044_46222 = state_45935__$1;
(statearr_46044_46222[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (66))){
var inst_45904 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_46045_46223 = state_45935__$1;
(statearr_46045_46223[(2)] = inst_45904);

(statearr_46045_46223[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (107))){
var inst_45841 = (state_45935[(19)]);
var inst_45855 = (state_45935[(2)]);
var inst_45856 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_45841,false);
var state_45935__$1 = (function (){var statearr_46046 = state_45935;
(statearr_46046[(40)] = inst_45855);

return statearr_46046;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45935__$1,(108),inst_45856);
} else {
if((state_val_45936 === (23))){
var inst_45666 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_46047_46224 = state_45935__$1;
(statearr_46047_46224[(2)] = inst_45666);

(statearr_46047_46224[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (47))){
var inst_45708 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_45935__$1 = (function (){var statearr_46048 = state_45935;
(statearr_46048[(26)] = inst_45708);

return statearr_46048;
})();
if(cljs.core.truth_(fuel)){
var statearr_46049_46225 = state_45935__$1;
(statearr_46049_46225[(1)] = (50));

} else {
var statearr_46050_46226 = state_45935__$1;
(statearr_46050_46226[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (35))){
var inst_45681 = (state_45935[(2)]);
var inst_45682 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_45681);
var state_45935__$1 = state_45935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45935__$1,(36),inst_45682);
} else {
if((state_val_45936 === (127))){
var inst_45925 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
if(cljs.core.truth_(inst_45925)){
var statearr_46051_46227 = state_45935__$1;
(statearr_46051_46227[(1)] = (131));

} else {
var statearr_46052_46228 = state_45935__$1;
(statearr_46052_46228[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (82))){
var inst_45900 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_46053_46229 = state_45935__$1;
(statearr_46053_46229[(2)] = inst_45900);

(statearr_46053_46229[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (76))){
var inst_45630 = (state_45935[(15)]);
var inst_45628 = (state_45935[(14)]);
var inst_45774 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_45775 = [inst_45628,inst_45630];
var inst_45776 = cljs.core.PersistentHashMap.fromArrays(inst_45774,inst_45775);
var state_45935__$1 = state_45935;
var statearr_46054_46230 = state_45935__$1;
(statearr_46054_46230[(2)] = inst_45776);

(statearr_46054_46230[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (97))){
var inst_45834 = (state_45935[(38)]);
var inst_45841 = (state_45935[(19)]);
var inst_45840 = cljs.core.seq(inst_45834);
var inst_45841__$1 = cljs.core.first(inst_45840);
var inst_45842 = cljs.core.next(inst_45840);
var inst_45843 = cljs.core.not(inst_45841__$1);
var state_45935__$1 = (function (){var statearr_46055 = state_45935;
(statearr_46055[(37)] = inst_45842);

(statearr_46055[(19)] = inst_45841__$1);

return statearr_46055;
})();
if(inst_45843){
var statearr_46056_46231 = state_45935__$1;
(statearr_46056_46231[(1)] = (99));

} else {
var statearr_46057_46232 = state_45935__$1;
(statearr_46057_46232[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (19))){
var inst_45668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45669 = [null,null];
var inst_45670 = (new cljs.core.PersistentVector(null,2,(5),inst_45668,inst_45669,null));
var state_45935__$1 = state_45935;
var statearr_46058_46233 = state_45935__$1;
(statearr_46058_46233[(2)] = inst_45670);

(statearr_46058_46233[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (57))){
var inst_45630 = (state_45935[(15)]);
var inst_45628 = (state_45935[(14)]);
var inst_45724 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_45725 = [inst_45628,inst_45630];
var inst_45726 = cljs.core.PersistentHashMap.fromArrays(inst_45724,inst_45725);
var state_45935__$1 = state_45935;
var statearr_46059_46234 = state_45935__$1;
(statearr_46059_46234[(2)] = inst_45726);

(statearr_46059_46234[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (68))){
var inst_45630 = (state_45935[(15)]);
var inst_45628 = (state_45935[(14)]);
var inst_45755 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_45756 = [inst_45628,inst_45630];
var inst_45757 = cljs.core.PersistentHashMap.fromArrays(inst_45755,inst_45756);
var state_45935__$1 = state_45935;
var statearr_46060_46235 = state_45935__$1;
(statearr_46060_46235[(2)] = inst_45757);

(statearr_46060_46235[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (11))){
var inst_45622 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_46061_46236 = state_45935__$1;
(statearr_46061_46236[(2)] = inst_45622);

(statearr_46061_46236[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (115))){
var inst_45627 = (state_45935[(18)]);
var inst_45877 = (state_45935[(2)]);
var state_45935__$1 = (function (){var statearr_46063 = state_45935;
(statearr_46063[(34)] = inst_45877);

return statearr_46063;
})();
if(cljs.core.truth_(inst_45627)){
var statearr_46064_46237 = state_45935__$1;
(statearr_46064_46237[(1)] = (116));

} else {
var statearr_46065_46238 = state_45935__$1;
(statearr_46065_46238[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (9))){
var inst_45608 = (state_45935[(12)]);
var state_45935__$1 = state_45935;
var statearr_46066_46239 = state_45935__$1;
(statearr_46066_46239[(2)] = inst_45608);

(statearr_46066_46239[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (5))){
var _ = (function (){var statearr_46067 = state_45935;
(statearr_46067[(4)] = cljs.core.rest((state_45935[(4)])));

return statearr_46067;
})();
var state_45935__$1 = state_45935;
var ex46062 = (state_45935__$1[(2)]);
var statearr_46068_46240 = state_45935__$1;
(statearr_46068_46240[(5)] = ex46062);


if((ex46062 instanceof Error)){
var statearr_46069_46241 = state_45935__$1;
(statearr_46069_46241[(1)] = (4));

(statearr_46069_46241[(5)] = null);

} else {
throw ex46062;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (112))){
var inst_45884 = (state_45935[(2)]);
var inst_45885 = fluree.db.util.async.throw_err(inst_45884);
var state_45935__$1 = state_45935;
var statearr_46070_46242 = state_45935__$1;
(statearr_46070_46242[(2)] = inst_45885);

(statearr_46070_46242[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (83))){
var inst_45794 = (state_45935[(20)]);
var inst_45793 = (state_45935[(2)]);
var inst_45794__$1 = fluree.db.util.async.throw_err(inst_45793);
var inst_45795 = (inst_45794__$1 == null);
var state_45935__$1 = (function (){var statearr_46071 = state_45935;
(statearr_46071[(20)] = inst_45794__$1);

return statearr_46071;
})();
if(cljs.core.truth_(inst_45795)){
var statearr_46072_46243 = state_45935__$1;
(statearr_46072_46243[(1)] = (84));

} else {
var statearr_46073_46244 = state_45935__$1;
(statearr_46073_46244[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (14))){
var inst_45620 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_46074_46245 = state_45935__$1;
(statearr_46074_46245[(2)] = inst_45620);

(statearr_46074_46245[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (45))){
var inst_45699 = (state_45935[(27)]);
var state_45935__$1 = state_45935;
var statearr_46075_46246 = state_45935__$1;
(statearr_46075_46246[(2)] = inst_45699);

(statearr_46075_46246[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (53))){
var inst_45714 = (state_45935[(21)]);
var inst_45716 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_45717 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_45714,inst_45716);
var state_45935__$1 = state_45935;
var statearr_46076_46247 = state_45935__$1;
(statearr_46076_46247[(2)] = inst_45717);

(statearr_46076_46247[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (78))){
var inst_45638 = (state_45935[(7)]);
var inst_45640 = (state_45935[(8)]);
var inst_45781 = (state_45935[(2)]);
var inst_45782 = fluree.db.util.async.throw_err(inst_45781);
var inst_45783 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_45640,fuel,max_fuel,inst_45638,inst_45782);
var state_45935__$1 = state_45935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45935__$1,(79),inst_45783);
} else {
if((state_val_45936 === (132))){
var inst_45913 = (state_45935[(11)]);
var state_45935__$1 = state_45935;
var statearr_46077_46248 = state_45935__$1;
(statearr_46077_46248[(2)] = inst_45913);

(statearr_46077_46248[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (26))){
var inst_45664 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_46078_46249 = state_45935__$1;
(statearr_46078_46249[(2)] = inst_45664);

(statearr_46078_46249[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (123))){
var inst_45908 = (state_45935[(28)]);
var state_45935__$1 = state_45935;
var statearr_46079_46250 = state_45935__$1;
(statearr_46079_46250[(2)] = inst_45908);

(statearr_46079_46250[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (16))){
var inst_45631 = (state_45935[(24)]);
var state_45935__$1 = state_45935;
var statearr_46080_46251 = state_45935__$1;
(statearr_46080_46251[(2)] = inst_45631);

(statearr_46080_46251[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (133))){
var inst_45930 = (state_45935[(2)]);
var _ = (function (){var statearr_46081 = state_45935;
(statearr_46081[(4)] = cljs.core.rest((state_45935[(4)])));

return statearr_46081;
})();
var state_45935__$1 = state_45935;
var statearr_46082_46252 = state_45935__$1;
(statearr_46082_46252[(2)] = inst_45930);

(statearr_46082_46252[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (81))){
var inst_45815 = (state_45935[(22)]);
var inst_45815__$1 = cljs.core.sequential_QMARK_(from);
var state_45935__$1 = (function (){var statearr_46083 = state_45935;
(statearr_46083[(22)] = inst_45815__$1);

return statearr_46083;
})();
if(inst_45815__$1){
var statearr_46084_46253 = state_45935__$1;
(statearr_46084_46253[(1)] = (91));

} else {
var statearr_46085_46254 = state_45935__$1;
(statearr_46085_46254[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (120))){
var state_45935__$1 = state_45935;
var statearr_46086_46255 = state_45935__$1;
(statearr_46086_46255[(2)] = null);

(statearr_46086_46255[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (79))){
var inst_45785 = (state_45935[(2)]);
var inst_45786 = fluree.db.util.async.throw_err(inst_45785);
var state_45935__$1 = state_45935;
var statearr_46087_46256 = state_45935__$1;
(statearr_46087_46256[(2)] = inst_45786);

(statearr_46087_46256[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (38))){
var state_45935__$1 = state_45935;
var statearr_46088_46257 = state_45935__$1;
(statearr_46088_46257[(2)] = null);

(statearr_46088_46257[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (126))){
var inst_45914 = (state_45935[(41)]);
var state_45935__$1 = state_45935;
var statearr_46089_46258 = state_45935__$1;
(statearr_46089_46258[(2)] = inst_45914);

(statearr_46089_46258[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (98))){
var inst_45627 = (state_45935[(18)]);
var inst_45871 = (state_45935[(2)]);
var inst_45872 = cljs.core.PersistentVector.EMPTY;
var inst_45873 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_45872,inst_45871);
var state_45935__$1 = (function (){var statearr_46090 = state_45935;
(statearr_46090[(35)] = inst_45873);

return statearr_46090;
})();
if(cljs.core.truth_(inst_45627)){
var statearr_46091_46259 = state_45935__$1;
(statearr_46091_46259[(1)] = (113));

} else {
var statearr_46092_46260 = state_45935__$1;
(statearr_46092_46260[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (124))){
var inst_45914 = (state_45935[(41)]);
var inst_45913 = (state_45935[(2)]);
var inst_45914__$1 = selectOne;
var state_45935__$1 = (function (){var statearr_46093 = state_45935;
(statearr_46093[(11)] = inst_45913);

(statearr_46093[(41)] = inst_45914__$1);

return statearr_46093;
})();
if(cljs.core.truth_(inst_45914__$1)){
var statearr_46094_46261 = state_45935__$1;
(statearr_46094_46261[(1)] = (125));

} else {
var statearr_46095_46262 = state_45935__$1;
(statearr_46095_46262[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (87))){
var inst_45805 = (state_45935[(2)]);
var inst_45806 = fluree.db.util.async.throw_err(inst_45805);
var state_45935__$1 = (function (){var statearr_46096 = state_45935;
(statearr_46096[(31)] = inst_45806);

return statearr_46096;
})();
if(cljs.core.truth_(fuel)){
var statearr_46097_46263 = state_45935__$1;
(statearr_46097_46263[(1)] = (88));

} else {
var statearr_46098_46264 = state_45935__$1;
(statearr_46098_46264[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (30))){
var inst_45677 = typeof from === 'string';
var state_45935__$1 = state_45935;
if(cljs.core.truth_(inst_45677)){
var statearr_46099_46265 = state_45935__$1;
(statearr_46099_46265[(1)] = (33));

} else {
var statearr_46100_46266 = state_45935__$1;
(statearr_46100_46266[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (73))){
var inst_45788 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_45935__$1 = state_45935;
if(inst_45788){
var statearr_46101_46267 = state_45935__$1;
(statearr_46101_46267[(1)] = (80));

} else {
var statearr_46102_46268 = state_45935__$1;
(statearr_46102_46268[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (96))){
var inst_45898 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_46103_46269 = state_45935__$1;
(statearr_46103_46269[(2)] = inst_45898);

(statearr_46103_46269[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (10))){
var inst_45611 = (state_45935[(39)]);
var inst_45611__$1 = selectDistinct;
var state_45935__$1 = (function (){var statearr_46104 = state_45935;
(statearr_46104[(39)] = inst_45611__$1);

return statearr_46104;
})();
if(cljs.core.truth_(inst_45611__$1)){
var statearr_46105_46270 = state_45935__$1;
(statearr_46105_46270[(1)] = (12));

} else {
var statearr_46106_46271 = state_45935__$1;
(statearr_46106_46271[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (18))){
var inst_45627 = (state_45935[(18)]);
var inst_45642 = cljs.core.vector_QMARK_(inst_45627);
var state_45935__$1 = state_45935;
if(inst_45642){
var statearr_46107_46272 = state_45935__$1;
(statearr_46107_46272[(1)] = (21));

} else {
var statearr_46108_46273 = state_45935__$1;
(statearr_46108_46273[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (105))){
var inst_45850 = cljs.core._deref(fuel);
var inst_45851 = (inst_45850 + (1));
var inst_45852 = cljs.core._vreset_BANG_(fuel,inst_45851);
var state_45935__$1 = state_45935;
var statearr_46109_46274 = state_45935__$1;
(statearr_46109_46274[(2)] = inst_45852);

(statearr_46109_46274[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (52))){
var inst_45714 = (state_45935[(2)]);
var state_45935__$1 = (function (){var statearr_46110 = state_45935;
(statearr_46110[(21)] = inst_45714);

return statearr_46110;
})();
var statearr_46111_46275 = state_45935__$1;
(statearr_46111_46275[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (114))){
var inst_45628 = (state_45935[(14)]);
var state_45935__$1 = state_45935;
var statearr_46113_46276 = state_45935__$1;
(statearr_46113_46276[(2)] = inst_45628);

(statearr_46113_46276[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (67))){
var inst_45753 = cljs.core.PersistentHashMap.EMPTY;
var state_45935__$1 = state_45935;
var statearr_46114_46277 = state_45935__$1;
(statearr_46114_46277[(2)] = inst_45753);

(statearr_46114_46277[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (71))){
var inst_45766 = (state_45935[(2)]);
var inst_45767 = fluree.db.util.async.throw_err(inst_45766);
var state_45935__$1 = state_45935;
var statearr_46115_46278 = state_45935__$1;
(statearr_46115_46278[(2)] = inst_45767);

(statearr_46115_46278[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (42))){
var inst_45630 = (state_45935[(15)]);
var state_45935__$1 = state_45935;
var statearr_46116_46279 = state_45935__$1;
(statearr_46116_46279[(2)] = inst_45630);

(statearr_46116_46279[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (80))){
var inst_45791 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_45935__$1 = state_45935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45935__$1,(83),inst_45791);
} else {
if((state_val_45936 === (37))){
var inst_45696 = (state_45935[(2)]);
var inst_45697 = fluree.db.util.async.throw_err(inst_45696);
var state_45935__$1 = state_45935;
var statearr_46117_46280 = state_45935__$1;
(statearr_46117_46280[(2)] = inst_45697);

(statearr_46117_46280[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (63))){
var inst_45750 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
if(cljs.core.truth_(inst_45750)){
var statearr_46118_46281 = state_45935__$1;
(statearr_46118_46281[(1)] = (64));

} else {
var statearr_46119_46282 = state_45935__$1;
(statearr_46119_46282[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (94))){
var inst_45829 = from;
var inst_45830 = cljs.core.seq(inst_45829);
var inst_45831 = cljs.core.first(inst_45830);
var inst_45832 = cljs.core.next(inst_45830);
var inst_45833 = cljs.core.PersistentVector.EMPTY;
var inst_45834 = inst_45829;
var inst_45835 = inst_45833;
var state_45935__$1 = (function (){var statearr_46120 = state_45935;
(statearr_46120[(10)] = inst_45835);

(statearr_46120[(38)] = inst_45834);

(statearr_46120[(42)] = inst_45831);

(statearr_46120[(43)] = inst_45832);

return statearr_46120;
})();
var statearr_46121_46283 = state_45935__$1;
(statearr_46121_46283[(2)] = null);

(statearr_46121_46283[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (8))){
var inst_45629 = (state_45935[(25)]);
var inst_45624 = (state_45935[(2)]);
var inst_45625 = opts_SINGLEQUOTE_;
var inst_45626 = cljs.core.__destructure_map(inst_45625);
var inst_45627 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45626,cljs.core.cst$kw$orderBy);
var inst_45628 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45626,cljs.core.cst$kw$limit);
var inst_45629__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45626,cljs.core.cst$kw$component);
var inst_45630 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45626,cljs.core.cst$kw$offset);
var inst_45631 = fluree.db.query.fql_parser.parse_db(db,inst_45624,opts_SINGLEQUOTE_);
var inst_45632 = (inst_45629__$1 == null);
var inst_45633 = cljs.core.not(inst_45632);
var state_45935__$1 = (function (){var statearr_46122 = state_45935;
(statearr_46122[(15)] = inst_45630);

(statearr_46122[(24)] = inst_45631);

(statearr_46122[(18)] = inst_45627);

(statearr_46122[(14)] = inst_45628);

(statearr_46122[(25)] = inst_45629__$1);

return statearr_46122;
})();
if(inst_45633){
var statearr_46123_46284 = state_45935__$1;
(statearr_46123_46284[(1)] = (15));

} else {
var statearr_46124_46285 = state_45935__$1;
(statearr_46124_46285[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (49))){
var inst_45906 = (state_45935[(2)]);
var state_45935__$1 = state_45935;
var statearr_46125_46286 = state_45935__$1;
(statearr_46125_46286[(2)] = inst_45906);

(statearr_46125_46286[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45936 === (84))){
var state_45935__$1 = state_45935;
var statearr_46126_46287 = state_45935__$1;
(statearr_46126_46287[(2)] = null);

(statearr_46126_46287[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__20477__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__20477__auto____0 = (function (){
var statearr_46127 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46127[(0)] = fluree$db$query$fql$query_$_state_machine__20477__auto__);

(statearr_46127[(1)] = (1));

return statearr_46127;
});
var fluree$db$query$fql$query_$_state_machine__20477__auto____1 = (function (state_45935){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_45935);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46128){var ex__20480__auto__ = e46128;
var statearr_46129_46288 = state_45935;
(statearr_46129_46288[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_45935[(4)]))){
var statearr_46130_46289 = state_45935;
(statearr_46130_46289[(1)] = cljs.core.first((state_45935[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46290 = state_45935;
state_45935 = G__46290;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__20477__auto__ = function(state_45935){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__20477__auto____1.call(this,state_45935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__20477__auto____0;
fluree$db$query$fql$query_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__20477__auto____1;
return fluree$db$query$fql$query_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46131 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46131[(6)] = c__20603__auto__);

return statearr_46131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}

});
