// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4223__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__35928 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35928,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35928,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35928,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35928,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35928,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35928,(5),null);
var G__35931 = idx;
var G__35931__$1 = (((G__35931 instanceof cljs.core.Keyword))?G__35931.fqn:null);
switch (G__35931__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35931__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__35933 = idx;
var G__35933__$1 = (((G__35933 instanceof cljs.core.Keyword))?G__35933.fqn:null);
switch (G__35933__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35933__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__35935 = idx;
var G__35935__$1 = (((G__35935 instanceof cljs.core.Keyword))?G__35935.fqn:null);
switch (G__35935__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35935__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__35938 = arguments.length;
switch (G__35938) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__35939 = (function (){var pred__35942 = cljs.core.identical_QMARK_;
var expr__35943 = test;
if(cljs.core.truth_((pred__35942.cljs$core$IFn$_invoke$arity$2 ? pred__35942.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__35943) : pred__35942.call(null,cljs.core._EQ_,expr__35943)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__35942.cljs$core$IFn$_invoke$arity$2 ? pred__35942.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__35943) : pred__35942.call(null,cljs.core._LT_,expr__35943)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__35942.cljs$core$IFn$_invoke$arity$2 ? pred__35942.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__35943) : pred__35942.call(null,cljs.core._LT__EQ_,expr__35943)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__35942.cljs$core$IFn$_invoke$arity$2 ? pred__35942.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__35943) : pred__35942.call(null,cljs.core._GT_,expr__35943)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__35942.cljs$core$IFn$_invoke$arity$2 ? pred__35942.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__35943) : pred__35942.call(null,cljs.core._GT__EQ_,expr__35943)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__35943)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35939,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35939,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35939,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35939,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_36182){
var state_val_36183 = (state_36182[(1)]);
if((state_val_36183 === (65))){
var inst_36097 = (state_36182[(7)]);
var inst_36153 = (state_36182[(8)]);
var inst_36153__$1 = (state_36182[(2)]);
var inst_36154 = cljs.core.count(inst_36153__$1);
var state_36182__$1 = (function (){var statearr_36184 = state_36182;
(statearr_36184[(8)] = inst_36153__$1);

(statearr_36184[(9)] = inst_36154);

return statearr_36184;
})();
if(cljs.core.truth_(inst_36097)){
var statearr_36185_36322 = state_36182__$1;
(statearr_36185_36322[(1)] = (81));

} else {
var statearr_36186_36323 = state_36182__$1;
(statearr_36186_36323[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (70))){
var inst_36128 = (state_36182[(2)]);
var state_36182__$1 = state_36182;
if(cljs.core.truth_(inst_36128)){
var statearr_36187_36324 = state_36182__$1;
(statearr_36187_36324[(1)] = (71));

} else {
var statearr_36188_36325 = state_36182__$1;
(statearr_36188_36325[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (62))){
var inst_36067 = (state_36182[(10)]);
var inst_36081 = (state_36182[(11)]);
var inst_36096 = (state_36182[(2)]);
var inst_36097 = fluree.db.dbproto._rhs(inst_36081);
var state_36182__$1 = (function (){var statearr_36189 = state_36182;
(statearr_36189[(7)] = inst_36097);

(statearr_36189[(12)] = inst_36096);

return statearr_36189;
})();
if(cljs.core.truth_(inst_36067)){
var statearr_36190_36326 = state_36182__$1;
(statearr_36190_36326[(1)] = (63));

} else {
var statearr_36191_36327 = state_36182__$1;
(statearr_36191_36327[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (74))){
var inst_36121 = (state_36182[(13)]);
var inst_36135 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_36121);
var state_36182__$1 = state_36182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36182__$1,(77),inst_36135);
} else {
if((state_val_36183 === (7))){
var inst_35958 = (state_36182[(14)]);
var state_36182__$1 = state_36182;
var statearr_36192_36328 = state_36182__$1;
(statearr_36192_36328[(2)] = inst_35958);

(statearr_36192_36328[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (59))){
var inst_36044 = (state_36182[(15)]);
var inst_36043 = (state_36182[(16)]);
var inst_36088 = (state_36182[(17)]);
var inst_36087 = (state_36182[(2)]);
var inst_36088__$1 = fluree.db.util.async.throw_err(inst_36087);
var inst_36089 = fluree.db.flake.subrange(inst_36088__$1,start_test,inst_36043,end_test,inst_36044);
var inst_36090 = fluree.db.query.range.value_with_nil_pred(idx,inst_36043,inst_36044);
var state_36182__$1 = (function (){var statearr_36193 = state_36182;
(statearr_36193[(18)] = inst_36089);

(statearr_36193[(17)] = inst_36088__$1);

return statearr_36193;
})();
if(inst_36090){
var statearr_36194_36329 = state_36182__$1;
(statearr_36194_36329[(1)] = (60));

} else {
var statearr_36195_36330 = state_36182__$1;
(statearr_36195_36330[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (86))){
var inst_36162 = (state_36182[(2)]);
var state_36182__$1 = state_36182;
var statearr_36196_36331 = state_36182__$1;
(statearr_36196_36331[(2)] = inst_36162);

(statearr_36196_36331[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (20))){
var inst_36007 = (state_36182[(19)]);
var inst_35959 = (state_36182[(20)]);
var inst_36006 = (state_36182[(2)]);
var inst_36007__$1 = (inst_35959 == null);
var state_36182__$1 = (function (){var statearr_36197 = state_36182;
(statearr_36197[(19)] = inst_36007__$1);

(statearr_36197[(21)] = inst_36006);

return statearr_36197;
})();
if(cljs.core.truth_(inst_36007__$1)){
var statearr_36198_36332 = state_36182__$1;
(statearr_36198_36332[(1)] = (22));

} else {
var statearr_36199_36333 = state_36182__$1;
(statearr_36199_36333[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (72))){
var inst_36114 = (state_36182[(22)]);
var inst_36132 = (inst_36114 + (1));
var inst_36133 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_36182__$1 = (function (){var statearr_36200 = state_36182;
(statearr_36200[(23)] = inst_36132);

return statearr_36200;
})();
if(cljs.core.truth_(inst_36133)){
var statearr_36201_36334 = state_36182__$1;
(statearr_36201_36334[(1)] = (74));

} else {
var statearr_36202_36335 = state_36182__$1;
(statearr_36202_36335[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (58))){
var inst_36177 = (state_36182[(2)]);
var _ = (function (){var statearr_36203 = state_36182;
(statearr_36203[(4)] = cljs.core.rest((state_36182[(4)])));

return statearr_36203;
})();
var state_36182__$1 = state_36182;
var statearr_36204_36336 = state_36182__$1;
(statearr_36204_36336[(2)] = inst_36177);

(statearr_36204_36336[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (60))){
var inst_36044 = (state_36182[(15)]);
var inst_36083 = (state_36182[(24)]);
var inst_35961 = (state_36182[(25)]);
var inst_35964 = (state_36182[(26)]);
var inst_36042 = (state_36182[(27)]);
var inst_36049 = (state_36182[(28)]);
var inst_36061 = (state_36182[(29)]);
var inst_36082 = (state_36182[(30)]);
var inst_36050 = (state_36182[(31)]);
var inst_36071 = (state_36182[(32)]);
var inst_35969 = (state_36182[(33)]);
var inst_35979 = (state_36182[(34)]);
var inst_36015 = (state_36182[(35)]);
var inst_35997 = (state_36182[(36)]);
var inst_36067 = (state_36182[(10)]);
var inst_35957 = (state_36182[(37)]);
var inst_36024 = (state_36182[(38)]);
var inst_36043 = (state_36182[(16)]);
var inst_36054 = (state_36182[(39)]);
var inst_36081 = (state_36182[(11)]);
var inst_35988 = (state_36182[(40)]);
var inst_36076 = (state_36182[(41)]);
var inst_36033 = (state_36182[(42)]);
var inst_35968 = (state_36182[(43)]);
var inst_36006 = (state_36182[(21)]);
var inst_36089 = (state_36182[(18)]);
var inst_36088 = (state_36182[(17)]);
var inst_35962 = (state_36182[(44)]);
var inst_36060 = (state_36182[(45)]);
var inst_36092 = (function (){var no_filter_QMARK_ = inst_36067;
var next_node = inst_36081;
var flakes = inst_36088;
var vec__35951 = inst_35957;
var s1 = inst_35979;
var o2 = inst_36006;
var t1 = inst_35961;
var i = inst_36082;
var m1 = inst_36033;
var root_node = inst_36076;
var to_t = inst_36061;
var vec__35954 = inst_35964;
var s2 = inst_35988;
var p2 = inst_36024;
var permissions = inst_36050;
var limit = inst_36049;
var start_flake = inst_36043;
var acc = inst_36083;
var t2 = inst_35968;
var op1 = inst_35962;
var o1 = inst_35997;
var end_flake = inst_36044;
var base_result = inst_36089;
var p1 = inst_36015;
var idx_compare = inst_36054;
var op2 = inst_35969;
var from_t = inst_36060;
var m2 = inst_36042;
var novelty = inst_36071;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_36093 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36092,inst_36089,inst_36089);
var state_36182__$1 = state_36182;
var statearr_36205_36337 = state_36182__$1;
(statearr_36205_36337[(2)] = inst_36093);

(statearr_36205_36337[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (27))){
var inst_36016 = (state_36182[(46)]);
var inst_35966 = (state_36182[(47)]);
var inst_36015 = (state_36182[(2)]);
var inst_36016__$1 = (inst_35966 == null);
var state_36182__$1 = (function (){var statearr_36206 = state_36182;
(statearr_36206[(46)] = inst_36016__$1);

(statearr_36206[(35)] = inst_36015);

return statearr_36206;
})();
if(cljs.core.truth_(inst_36016__$1)){
var statearr_36207_36338 = state_36182__$1;
(statearr_36207_36338[(1)] = (28));

} else {
var statearr_36208_36339 = state_36182__$1;
(statearr_36208_36339[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (1))){
var state_36182__$1 = state_36182;
var statearr_36209_36340 = state_36182__$1;
(statearr_36209_36340[(2)] = null);

(statearr_36209_36340[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (69))){
var inst_36049 = (state_36182[(28)]);
var inst_36114 = (state_36182[(22)]);
var inst_36126 = (inst_36114 > inst_36049);
var state_36182__$1 = state_36182;
var statearr_36210_36341 = state_36182__$1;
(statearr_36210_36341[(2)] = inst_36126);

(statearr_36210_36341[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (24))){
var inst_36011 = (state_36182[(2)]);
var state_36182__$1 = state_36182;
if(cljs.core.truth_(inst_36011)){
var statearr_36211_36342 = state_36182__$1;
(statearr_36211_36342[(1)] = (25));

} else {
var statearr_36212_36343 = state_36182__$1;
(statearr_36212_36343[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (55))){
var inst_36043 = (state_36182[(16)]);
var inst_36076 = (state_36182[(41)]);
var inst_36075 = (state_36182[(2)]);
var inst_36076__$1 = fluree.db.util.async.throw_err(inst_36075);
var inst_36077 = fluree.db.dbproto._lookup_leaf(inst_36076__$1,inst_36043);
var state_36182__$1 = (function (){var statearr_36213 = state_36182;
(statearr_36213[(41)] = inst_36076__$1);

return statearr_36213;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36182__$1,(56),inst_36077);
} else {
if((state_val_36183 === (85))){
var inst_36157 = (state_36182[(48)]);
var state_36182__$1 = state_36182;
var statearr_36214_36344 = state_36182__$1;
(statearr_36214_36344[(2)] = inst_36157);

(statearr_36214_36344[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (39))){
var inst_36031 = (state_36182[(2)]);
var state_36182__$1 = state_36182;
var statearr_36215_36345 = state_36182__$1;
(statearr_36215_36345[(2)] = inst_36031);

(statearr_36215_36345[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (88))){
var inst_36097 = (state_36182[(7)]);
var inst_36076 = (state_36182[(41)]);
var inst_36169 = fluree.db.dbproto._lookup_leaf(inst_36076,inst_36097);
var state_36182__$1 = state_36182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36182__$1,(90),inst_36169);
} else {
if((state_val_36183 === (46))){
var inst_36045 = (state_36182[(49)]);
var state_36182__$1 = state_36182;
var statearr_36216_36346 = state_36182__$1;
(statearr_36216_36346[(2)] = inst_36045);

(statearr_36216_36346[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (4))){
var inst_35945 = (state_36182[(2)]);
var state_36182__$1 = state_36182;
var statearr_36217_36347 = state_36182__$1;
(statearr_36217_36347[(2)] = inst_35945);

(statearr_36217_36347[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (77))){
var inst_36137 = (state_36182[(2)]);
var inst_36138 = fluree.db.util.async.throw_err(inst_36137);
var state_36182__$1 = state_36182;
if(cljs.core.truth_(inst_36138)){
var statearr_36218_36348 = state_36182__$1;
(statearr_36218_36348[(1)] = (78));

} else {
var statearr_36219_36349 = state_36182__$1;
(statearr_36219_36349[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (54))){
var inst_36067 = (state_36182[(2)]);
var inst_36068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36069 = [cljs.core.cst$kw$novelty,idx];
var inst_36070 = (new cljs.core.PersistentVector(null,2,(5),inst_36068,inst_36069,null));
var inst_36071 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_36070);
var inst_36072 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_36073 = fluree.db.dbproto._resolve(inst_36072);
var state_36182__$1 = (function (){var statearr_36220 = state_36182;
(statearr_36220[(32)] = inst_36071);

(statearr_36220[(10)] = inst_36067);

return statearr_36220;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36182__$1,(55),inst_36073);
} else {
if((state_val_36183 === (15))){
var inst_35960 = (state_36182[(50)]);
var state_36182__$1 = state_36182;
var statearr_36221_36350 = state_36182__$1;
(statearr_36221_36350[(2)] = inst_35960);

(statearr_36221_36350[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (48))){
var inst_36055 = (state_36182[(51)]);
var inst_36049 = (state_36182[(2)]);
var inst_36050 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_36051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36052 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_36053 = (new cljs.core.PersistentVector(null,3,(5),inst_36051,inst_36052,null));
var inst_36054 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_36053);
var inst_36055__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_36182__$1 = (function (){var statearr_36222 = state_36182;
(statearr_36222[(28)] = inst_36049);

(statearr_36222[(51)] = inst_36055__$1);

(statearr_36222[(31)] = inst_36050);

(statearr_36222[(39)] = inst_36054);

return statearr_36222;
})();
if(cljs.core.truth_(inst_36055__$1)){
var statearr_36223_36351 = state_36182__$1;
(statearr_36223_36351[(1)] = (49));

} else {
var statearr_36224_36352 = state_36182__$1;
(statearr_36224_36352[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (50))){
var inst_36058 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_36182__$1 = state_36182;
var statearr_36225_36353 = state_36182__$1;
(statearr_36225_36353[(2)] = inst_36058);

(statearr_36225_36353[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (75))){
var inst_36115 = (state_36182[(52)]);
var state_36182__$1 = state_36182;
var statearr_36226_36354 = state_36182__$1;
(statearr_36226_36354[(2)] = inst_36115);

(statearr_36226_36354[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (21))){
var inst_36002 = (state_36182[(2)]);
var inst_36003 = fluree.db.util.async.throw_err(inst_36002);
var state_36182__$1 = state_36182;
var statearr_36227_36355 = state_36182__$1;
(statearr_36227_36355[(2)] = inst_36003);

(statearr_36227_36355[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (31))){
var state_36182__$1 = state_36182;
var statearr_36228_36356 = state_36182__$1;
(statearr_36228_36356[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_36228_36356[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (32))){
var inst_35966 = (state_36182[(47)]);
var state_36182__$1 = state_36182;
var statearr_36229_36357 = state_36182__$1;
(statearr_36229_36357[(2)] = inst_35966);

(statearr_36229_36357[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (40))){
var inst_35970 = (state_36182[(53)]);
var state_36182__$1 = state_36182;
var statearr_36230_36358 = state_36182__$1;
(statearr_36230_36358[(2)] = inst_35970);

(statearr_36230_36358[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (56))){
var inst_36079 = (state_36182[(2)]);
var inst_36080 = fluree.db.util.async.throw_err(inst_36079);
var inst_36081 = inst_36080;
var inst_36082 = (0);
var inst_36083 = null;
var state_36182__$1 = (function (){var statearr_36231 = state_36182;
(statearr_36231[(24)] = inst_36083);

(statearr_36231[(30)] = inst_36082);

(statearr_36231[(11)] = inst_36081);

return statearr_36231;
})();
var statearr_36232_36359 = state_36182__$1;
(statearr_36232_36359[(2)] = null);

(statearr_36232_36359[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (33))){
var inst_35963 = (state_36182[(54)]);
var inst_36024 = (state_36182[(2)]);
var state_36182__$1 = (function (){var statearr_36233 = state_36182;
(statearr_36233[(38)] = inst_36024);

return statearr_36233;
})();
if(cljs.core.truth_(inst_35963)){
var statearr_36234_36360 = state_36182__$1;
(statearr_36234_36360[(1)] = (34));

} else {
var statearr_36235_36361 = state_36182__$1;
(statearr_36235_36361[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (13))){
var inst_35984 = (state_36182[(2)]);
var inst_35985 = fluree.db.util.async.throw_err(inst_35984);
var state_36182__$1 = state_36182;
var statearr_36236_36362 = state_36182__$1;
(statearr_36236_36362[(2)] = inst_35985);

(statearr_36236_36362[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (22))){
var inst_35997 = (state_36182[(36)]);
var state_36182__$1 = state_36182;
var statearr_36237_36363 = state_36182__$1;
(statearr_36237_36363[(2)] = inst_35997);

(statearr_36237_36363[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (90))){
var inst_36153 = (state_36182[(8)]);
var inst_36154 = (state_36182[(9)]);
var inst_36171 = (state_36182[(2)]);
var inst_36172 = fluree.db.util.async.throw_err(inst_36171);
var inst_36081 = inst_36172;
var inst_36082 = inst_36154;
var inst_36083 = inst_36153;
var state_36182__$1 = (function (){var statearr_36238 = state_36182;
(statearr_36238[(24)] = inst_36083);

(statearr_36238[(30)] = inst_36082);

(statearr_36238[(11)] = inst_36081);

return statearr_36238;
})();
var statearr_36239_36364 = state_36182__$1;
(statearr_36239_36364[(2)] = null);

(statearr_36239_36364[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (36))){
var inst_35970 = (state_36182[(53)]);
var inst_36033 = (state_36182[(2)]);
var state_36182__$1 = (function (){var statearr_36240 = state_36182;
(statearr_36240[(42)] = inst_36033);

return statearr_36240;
})();
if(cljs.core.truth_(inst_35970)){
var statearr_36241_36365 = state_36182__$1;
(statearr_36241_36365[(1)] = (40));

} else {
var statearr_36242_36366 = state_36182__$1;
(statearr_36242_36366[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (41))){
var inst_36036 = (cljs.core._LT__EQ_ === end_test);
var state_36182__$1 = state_36182;
if(cljs.core.truth_(inst_36036)){
var statearr_36243_36367 = state_36182__$1;
(statearr_36243_36367[(1)] = (43));

} else {
var statearr_36244_36368 = state_36182__$1;
(statearr_36244_36368[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (89))){
var inst_36175 = (state_36182[(2)]);
var state_36182__$1 = state_36182;
var statearr_36245_36369 = state_36182__$1;
(statearr_36245_36369[(2)] = inst_36175);

(statearr_36245_36369[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (43))){
var state_36182__$1 = state_36182;
var statearr_36246_36370 = state_36182__$1;
(statearr_36246_36370[(2)] = (2147483647));

(statearr_36246_36370[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (61))){
var inst_36089 = (state_36182[(18)]);
var state_36182__$1 = state_36182;
var statearr_36247_36371 = state_36182__$1;
(statearr_36247_36371[(2)] = inst_36089);

(statearr_36247_36371[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (29))){
var inst_36016 = (state_36182[(46)]);
var state_36182__$1 = state_36182;
var statearr_36248_36372 = state_36182__$1;
(statearr_36248_36372[(2)] = inst_36016);

(statearr_36248_36372[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (44))){
var state_36182__$1 = state_36182;
var statearr_36249_36373 = state_36182__$1;
(statearr_36249_36373[(2)] = fluree.db.util.core.min_integer);

(statearr_36249_36373[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (6))){
var inst_35958 = (state_36182[(14)]);
var inst_35973 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_35958);
var state_36182__$1 = state_36182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36182__$1,(9),inst_35973);
} else {
if((state_val_36183 === (28))){
var inst_36006 = (state_36182[(21)]);
var state_36182__$1 = state_36182;
var statearr_36250_36374 = state_36182__$1;
(statearr_36250_36374[(2)] = inst_36006);

(statearr_36250_36374[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (64))){
var inst_36082 = (state_36182[(30)]);
var inst_36096 = (state_36182[(12)]);
var inst_36110 = cljs.core.seq(inst_36096);
var inst_36111 = cljs.core.first(inst_36110);
var inst_36112 = cljs.core.next(inst_36110);
var inst_36113 = inst_36096;
var inst_36114 = inst_36082;
var inst_36115 = inst_36096;
var state_36182__$1 = (function (){var statearr_36251 = state_36182;
(statearr_36251[(55)] = inst_36112);

(statearr_36251[(56)] = inst_36113);

(statearr_36251[(22)] = inst_36114);

(statearr_36251[(52)] = inst_36115);

(statearr_36251[(57)] = inst_36111);

return statearr_36251;
})();
var statearr_36252_36375 = state_36182__$1;
(statearr_36252_36375[(2)] = null);

(statearr_36252_36375[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (51))){
var inst_36060 = (state_36182[(2)]);
var inst_36061 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_36062 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_36182__$1 = (function (){var statearr_36253 = state_36182;
(statearr_36253[(29)] = inst_36061);

(statearr_36253[(45)] = inst_36060);

return statearr_36253;
})();
if(cljs.core.truth_(inst_36062)){
var statearr_36254_36376 = state_36182__$1;
(statearr_36254_36376[(1)] = (52));

} else {
var statearr_36255_36377 = state_36182__$1;
(statearr_36255_36377[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (25))){
var state_36182__$1 = state_36182;
var statearr_36256_36378 = state_36182__$1;
(statearr_36256_36378[(2)] = (-1));

(statearr_36256_36378[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (34))){
var inst_35963 = (state_36182[(54)]);
var state_36182__$1 = state_36182;
var statearr_36257_36379 = state_36182__$1;
(statearr_36257_36379[(2)] = inst_35963);

(statearr_36257_36379[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (17))){
var inst_35993 = (state_36182[(2)]);
var inst_35994 = fluree.db.util.async.throw_err(inst_35993);
var state_36182__$1 = state_36182;
var statearr_36258_36380 = state_36182__$1;
(statearr_36258_36380[(2)] = inst_35994);

(statearr_36258_36380[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (3))){
var inst_36180 = (state_36182[(2)]);
var state_36182__$1 = state_36182;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36182__$1,inst_36180);
} else {
if((state_val_36183 === (12))){
var inst_35960 = (state_36182[(50)]);
var inst_35988 = (state_36182[(2)]);
var inst_35989 = fluree.db.util.core.pred_ident_QMARK_(inst_35960);
var state_36182__$1 = (function (){var statearr_36259 = state_36182;
(statearr_36259[(40)] = inst_35988);

return statearr_36259;
})();
if(inst_35989){
var statearr_36260_36381 = state_36182__$1;
(statearr_36260_36381[(1)] = (14));

} else {
var statearr_36261_36382 = state_36182__$1;
(statearr_36261_36382[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (2))){
var inst_35964 = (state_36182[(26)]);
var inst_35958 = (state_36182[(14)]);
var inst_35957 = (state_36182[(37)]);
var _ = (function (){var statearr_36262 = state_36182;
(statearr_36262[(4)] = cljs.core.cons((5),(state_36182[(4)])));

return statearr_36262;
})();
var inst_35957__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_35958__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35957__$1,(0),null);
var inst_35959 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35957__$1,(1),null);
var inst_35960 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35957__$1,(2),null);
var inst_35961 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35957__$1,(3),null);
var inst_35962 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35957__$1,(4),null);
var inst_35963 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35957__$1,(5),null);
var inst_35964__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_35965 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35964__$1,(0),null);
var inst_35966 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35964__$1,(1),null);
var inst_35967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35964__$1,(2),null);
var inst_35968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35964__$1,(3),null);
var inst_35969 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35964__$1,(4),null);
var inst_35970 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35964__$1,(5),null);
var inst_35971 = fluree.db.util.core.pred_ident_QMARK_(inst_35958__$1);
var state_36182__$1 = (function (){var statearr_36263 = state_36182;
(statearr_36263[(25)] = inst_35961);

(statearr_36263[(26)] = inst_35964__$1);

(statearr_36263[(54)] = inst_35963);

(statearr_36263[(14)] = inst_35958__$1);

(statearr_36263[(58)] = inst_35965);

(statearr_36263[(33)] = inst_35969);

(statearr_36263[(50)] = inst_35960);

(statearr_36263[(20)] = inst_35959);

(statearr_36263[(59)] = inst_35967);

(statearr_36263[(37)] = inst_35957__$1);

(statearr_36263[(47)] = inst_35966);

(statearr_36263[(43)] = inst_35968);

(statearr_36263[(53)] = inst_35970);

(statearr_36263[(44)] = inst_35962);

return statearr_36263;
})();
if(inst_35971){
var statearr_36264_36383 = state_36182__$1;
(statearr_36264_36383[(1)] = (6));

} else {
var statearr_36265_36384 = state_36182__$1;
(statearr_36265_36384[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (66))){
var inst_36113 = (state_36182[(56)]);
var inst_36121 = (state_36182[(13)]);
var inst_36123 = (state_36182[(60)]);
var inst_36120 = cljs.core.seq(inst_36113);
var inst_36121__$1 = cljs.core.first(inst_36120);
var inst_36122 = cljs.core.next(inst_36120);
var inst_36123__$1 = (inst_36121__$1 == null);
var state_36182__$1 = (function (){var statearr_36266 = state_36182;
(statearr_36266[(61)] = inst_36122);

(statearr_36266[(13)] = inst_36121__$1);

(statearr_36266[(60)] = inst_36123__$1);

return statearr_36266;
})();
if(cljs.core.truth_(inst_36123__$1)){
var statearr_36267_36385 = state_36182__$1;
(statearr_36267_36385[(1)] = (68));

} else {
var statearr_36268_36386 = state_36182__$1;
(statearr_36268_36386[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (23))){
var inst_36007 = (state_36182[(19)]);
var state_36182__$1 = state_36182;
var statearr_36269_36387 = state_36182__$1;
(statearr_36269_36387[(2)] = inst_36007);

(statearr_36269_36387[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (47))){
var state_36182__$1 = state_36182;
var statearr_36270_36388 = state_36182__$1;
(statearr_36270_36388[(2)] = fluree.db.util.core.max_long);

(statearr_36270_36388[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (35))){
var inst_36027 = (cljs.core._GT__EQ_ === start_test);
var state_36182__$1 = state_36182;
if(cljs.core.truth_(inst_36027)){
var statearr_36271_36389 = state_36182__$1;
(statearr_36271_36389[(1)] = (37));

} else {
var statearr_36272_36390 = state_36182__$1;
(statearr_36272_36390[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (82))){
var inst_36097 = (state_36182[(7)]);
var state_36182__$1 = state_36182;
var statearr_36273_36391 = state_36182__$1;
(statearr_36273_36391[(2)] = inst_36097);

(statearr_36273_36391[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (76))){
var inst_36122 = (state_36182[(61)]);
var inst_36132 = (state_36182[(23)]);
var inst_36146 = (state_36182[(2)]);
var inst_36113 = inst_36122;
var inst_36114 = inst_36132;
var inst_36115 = inst_36146;
var state_36182__$1 = (function (){var statearr_36274 = state_36182;
(statearr_36274[(56)] = inst_36113);

(statearr_36274[(22)] = inst_36114);

(statearr_36274[(52)] = inst_36115);

return statearr_36274;
})();
var statearr_36275_36392 = state_36182__$1;
(statearr_36275_36392[(2)] = null);

(statearr_36275_36392[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (19))){
var inst_35967 = (state_36182[(59)]);
var state_36182__$1 = state_36182;
var statearr_36276_36393 = state_36182__$1;
(statearr_36276_36393[(2)] = inst_35967);

(statearr_36276_36393[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (57))){
var inst_36061 = (state_36182[(29)]);
var inst_36071 = (state_36182[(32)]);
var inst_36081 = (state_36182[(11)]);
var inst_36060 = (state_36182[(45)]);
var inst_36085 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_36081,inst_36060,inst_36061,inst_36071);
var state_36182__$1 = state_36182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36182__$1,(59),inst_36085);
} else {
if((state_val_36183 === (68))){
var inst_36123 = (state_36182[(60)]);
var state_36182__$1 = state_36182;
var statearr_36277_36394 = state_36182__$1;
(statearr_36277_36394[(2)] = inst_36123);

(statearr_36277_36394[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (11))){
var inst_35965 = (state_36182[(58)]);
var state_36182__$1 = state_36182;
var statearr_36279_36395 = state_36182__$1;
(statearr_36279_36395[(2)] = inst_35965);

(statearr_36279_36395[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (9))){
var inst_35975 = (state_36182[(2)]);
var inst_35976 = fluree.db.util.async.throw_err(inst_35975);
var state_36182__$1 = state_36182;
var statearr_36280_36396 = state_36182__$1;
(statearr_36280_36396[(2)] = inst_35976);

(statearr_36280_36396[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (5))){
var _ = (function (){var statearr_36281 = state_36182;
(statearr_36281[(4)] = cljs.core.rest((state_36182[(4)])));

return statearr_36281;
})();
var state_36182__$1 = state_36182;
var ex36278 = (state_36182__$1[(2)]);
var statearr_36282_36397 = state_36182__$1;
(statearr_36282_36397[(5)] = ex36278);


if((ex36278 instanceof Error)){
var statearr_36283_36398 = state_36182__$1;
(statearr_36283_36398[(1)] = (4));

(statearr_36283_36398[(5)] = null);

} else {
throw ex36278;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (83))){
var inst_36165 = (state_36182[(2)]);
var inst_36166 = cljs.core.not(inst_36165);
var state_36182__$1 = state_36182;
if(inst_36166){
var statearr_36284_36399 = state_36182__$1;
(statearr_36284_36399[(1)] = (87));

} else {
var statearr_36285_36400 = state_36182__$1;
(statearr_36285_36400[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (14))){
var inst_35960 = (state_36182[(50)]);
var inst_35991 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_35960);
var state_36182__$1 = state_36182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36182__$1,(17),inst_35991);
} else {
if((state_val_36183 === (45))){
var inst_36040 = (state_36182[(2)]);
var state_36182__$1 = state_36182;
var statearr_36286_36401 = state_36182__$1;
(statearr_36286_36401[(2)] = inst_36040);

(statearr_36286_36401[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (53))){
var state_36182__$1 = state_36182;
var statearr_36287_36402 = state_36182__$1;
(statearr_36287_36402[(2)] = true);

(statearr_36287_36402[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (78))){
var inst_36115 = (state_36182[(52)]);
var state_36182__$1 = state_36182;
var statearr_36288_36403 = state_36182__$1;
(statearr_36288_36403[(2)] = inst_36115);

(statearr_36288_36403[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (26))){
var inst_35959 = (state_36182[(20)]);
var state_36182__$1 = state_36182;
var statearr_36289_36404 = state_36182__$1;
(statearr_36289_36404[(2)] = inst_35959);

(statearr_36289_36404[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (16))){
var inst_35967 = (state_36182[(59)]);
var inst_35997 = (state_36182[(2)]);
var inst_35998 = fluree.db.util.core.pred_ident_QMARK_(inst_35967);
var state_36182__$1 = (function (){var statearr_36290 = state_36182;
(statearr_36290[(36)] = inst_35997);

return statearr_36290;
})();
if(inst_35998){
var statearr_36291_36405 = state_36182__$1;
(statearr_36291_36405[(1)] = (18));

} else {
var statearr_36292_36406 = state_36182__$1;
(statearr_36292_36406[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (81))){
var inst_36044 = (state_36182[(15)]);
var inst_36097 = (state_36182[(7)]);
var inst_36054 = (state_36182[(39)]);
var inst_36157 = (state_36182[(48)]);
var inst_36156 = (inst_36054.cljs$core$IFn$_invoke$arity$2 ? inst_36054.cljs$core$IFn$_invoke$arity$2(inst_36097,inst_36044) : inst_36054.call(null,inst_36097,inst_36044));
var inst_36157__$1 = (inst_36156 < (0));
var state_36182__$1 = (function (){var statearr_36293 = state_36182;
(statearr_36293[(48)] = inst_36157__$1);

return statearr_36293;
})();
if(cljs.core.truth_(inst_36157__$1)){
var statearr_36294_36407 = state_36182__$1;
(statearr_36294_36407[(1)] = (84));

} else {
var statearr_36295_36408 = state_36182__$1;
(statearr_36295_36408[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (79))){
var inst_36115 = (state_36182[(52)]);
var inst_36121 = (state_36182[(13)]);
var inst_36141 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_36115,inst_36121);
var state_36182__$1 = state_36182;
var statearr_36296_36409 = state_36182__$1;
(statearr_36296_36409[(2)] = inst_36141);

(statearr_36296_36409[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (38))){
var state_36182__$1 = state_36182;
var statearr_36297_36410 = state_36182__$1;
(statearr_36297_36410[(2)] = (2147483647));

(statearr_36297_36410[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (87))){
var inst_36153 = (state_36182[(8)]);
var state_36182__$1 = state_36182;
var statearr_36298_36411 = state_36182__$1;
(statearr_36298_36411[(2)] = inst_36153);

(statearr_36298_36411[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (30))){
var inst_36020 = (state_36182[(2)]);
var state_36182__$1 = state_36182;
if(cljs.core.truth_(inst_36020)){
var statearr_36299_36412 = state_36182__$1;
(statearr_36299_36412[(1)] = (31));

} else {
var statearr_36300_36413 = state_36182__$1;
(statearr_36300_36413[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (73))){
var inst_36149 = (state_36182[(2)]);
var state_36182__$1 = state_36182;
var statearr_36301_36414 = state_36182__$1;
(statearr_36301_36414[(2)] = inst_36149);

(statearr_36301_36414[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (10))){
var inst_35965 = (state_36182[(58)]);
var inst_35982 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_35965);
var state_36182__$1 = state_36182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36182__$1,(13),inst_35982);
} else {
if((state_val_36183 === (18))){
var inst_35967 = (state_36182[(59)]);
var inst_36000 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_35967);
var state_36182__$1 = state_36182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36182__$1,(21),inst_36000);
} else {
if((state_val_36183 === (52))){
var inst_36050 = (state_36182[(31)]);
var inst_35979 = (state_36182[(34)]);
var inst_36015 = (state_36182[(35)]);
var inst_36024 = (state_36182[(38)]);
var inst_35988 = (state_36182[(40)]);
var inst_36064 = fluree.db.permissions_validate.no_filter_QMARK_(inst_36050,inst_35979,inst_35988,inst_36015,inst_36024);
var state_36182__$1 = state_36182;
var statearr_36302_36415 = state_36182__$1;
(statearr_36302_36415[(2)] = inst_36064);

(statearr_36302_36415[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (67))){
var inst_36151 = (state_36182[(2)]);
var state_36182__$1 = state_36182;
var statearr_36303_36416 = state_36182__$1;
(statearr_36303_36416[(2)] = inst_36151);

(statearr_36303_36416[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (71))){
var inst_36083 = (state_36182[(24)]);
var inst_36115 = (state_36182[(52)]);
var inst_36130 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36115,inst_36083);
var state_36182__$1 = state_36182;
var statearr_36304_36417 = state_36182__$1;
(statearr_36304_36417[(2)] = inst_36130);

(statearr_36304_36417[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (42))){
var inst_35961 = (state_36182[(25)]);
var inst_36042 = (state_36182[(27)]);
var inst_35969 = (state_36182[(33)]);
var inst_35979 = (state_36182[(34)]);
var inst_36015 = (state_36182[(35)]);
var inst_35997 = (state_36182[(36)]);
var inst_36024 = (state_36182[(38)]);
var inst_35988 = (state_36182[(40)]);
var inst_36033 = (state_36182[(42)]);
var inst_35968 = (state_36182[(43)]);
var inst_36006 = (state_36182[(21)]);
var inst_35962 = (state_36182[(44)]);
var inst_36045 = (state_36182[(49)]);
var inst_36042__$1 = (state_36182[(2)]);
var inst_36043 = fluree.db.flake.__GT_Flake(inst_35979,inst_36015,inst_35997,inst_35961,inst_35962,inst_36033);
var inst_36044 = fluree.db.flake.__GT_Flake(inst_35988,inst_36024,inst_36006,inst_35968,inst_35969,inst_36042__$1);
var inst_36045__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_36182__$1 = (function (){var statearr_36305 = state_36182;
(statearr_36305[(15)] = inst_36044);

(statearr_36305[(27)] = inst_36042__$1);

(statearr_36305[(16)] = inst_36043);

(statearr_36305[(49)] = inst_36045__$1);

return statearr_36305;
})();
if(cljs.core.truth_(inst_36045__$1)){
var statearr_36306_36418 = state_36182__$1;
(statearr_36306_36418[(1)] = (46));

} else {
var statearr_36307_36419 = state_36182__$1;
(statearr_36307_36419[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (80))){
var inst_36143 = (state_36182[(2)]);
var state_36182__$1 = state_36182;
var statearr_36308_36420 = state_36182__$1;
(statearr_36308_36420[(2)] = inst_36143);

(statearr_36308_36420[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (37))){
var state_36182__$1 = state_36182;
var statearr_36309_36421 = state_36182__$1;
(statearr_36309_36421[(2)] = fluree.db.util.core.min_integer);

(statearr_36309_36421[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (63))){
var inst_36083 = (state_36182[(24)]);
var inst_36049 = (state_36182[(28)]);
var inst_36082 = (state_36182[(30)]);
var inst_36096 = (state_36182[(12)]);
var inst_36099 = (inst_36049 - inst_36082);
var inst_36100 = fluree.db.flake.take(inst_36099,inst_36096);
var inst_36101 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36100,inst_36083);
var state_36182__$1 = state_36182;
var statearr_36310_36422 = state_36182__$1;
(statearr_36310_36422[(2)] = inst_36101);

(statearr_36310_36422[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (8))){
var inst_35965 = (state_36182[(58)]);
var inst_35979 = (state_36182[(2)]);
var inst_35980 = fluree.db.util.core.pred_ident_QMARK_(inst_35965);
var state_36182__$1 = (function (){var statearr_36311 = state_36182;
(statearr_36311[(34)] = inst_35979);

return statearr_36311;
})();
if(inst_35980){
var statearr_36312_36423 = state_36182__$1;
(statearr_36312_36423[(1)] = (10));

} else {
var statearr_36313_36424 = state_36182__$1;
(statearr_36313_36424[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (49))){
var inst_36055 = (state_36182[(51)]);
var state_36182__$1 = state_36182;
var statearr_36314_36425 = state_36182__$1;
(statearr_36314_36425[(2)] = inst_36055);

(statearr_36314_36425[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36183 === (84))){
var inst_36049 = (state_36182[(28)]);
var inst_36154 = (state_36182[(9)]);
var inst_36159 = (inst_36154 < inst_36049);
var state_36182__$1 = state_36182;
var statearr_36315_36426 = state_36182__$1;
(statearr_36315_36426[(2)] = inst_36159);

(statearr_36315_36426[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__20477__auto__ = null;
var fluree$db$query$range$state_machine__20477__auto____0 = (function (){
var statearr_36316 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36316[(0)] = fluree$db$query$range$state_machine__20477__auto__);

(statearr_36316[(1)] = (1));

return statearr_36316;
});
var fluree$db$query$range$state_machine__20477__auto____1 = (function (state_36182){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_36182);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e36317){var ex__20480__auto__ = e36317;
var statearr_36318_36427 = state_36182;
(statearr_36318_36427[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_36182[(4)]))){
var statearr_36319_36428 = state_36182;
(statearr_36319_36428[(1)] = cljs.core.first((state_36182[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__36429 = state_36182;
state_36182 = G__36429;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__20477__auto__ = function(state_36182){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__20477__auto____1.call(this,state_36182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__20477__auto____0;
fluree$db$query$range$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__20477__auto____1;
return fluree$db$query$range$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_36320 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_36320[(6)] = c__20603__auto__);

return statearr_36320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_36504){
var state_val_36505 = (state_36504[(1)]);
if((state_val_36505 === (7))){
var inst_36499 = (state_36504[(2)]);
var _ = (function (){var statearr_36506 = state_36504;
(statearr_36506[(4)] = cljs.core.rest((state_36504[(4)])));

return statearr_36506;
})();
var state_36504__$1 = state_36504;
var statearr_36507_36547 = state_36504__$1;
(statearr_36507_36547[(2)] = inst_36499);

(statearr_36507_36547[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (20))){
var inst_36481 = (state_36504[(2)]);
var inst_36482 = fluree.db.util.async.throw_err(inst_36481);
var state_36504__$1 = state_36504;
var statearr_36508_36548 = state_36504__$1;
(statearr_36508_36548[(2)] = inst_36482);

(statearr_36508_36548[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (1))){
var state_36504__$1 = state_36504;
var statearr_36509_36549 = state_36504__$1;
(statearr_36509_36549[(2)] = null);

(statearr_36509_36549[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (4))){
var inst_36430 = (state_36504[(2)]);
var state_36504__$1 = state_36504;
var statearr_36510_36550 = state_36504__$1;
(statearr_36510_36550[(2)] = inst_36430);

(statearr_36510_36550[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (15))){
var inst_36477 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_36504__$1 = state_36504;
if(cljs.core.truth_(inst_36477)){
var statearr_36511_36551 = state_36504__$1;
(statearr_36511_36551[(1)] = (17));

} else {
var statearr_36512_36552 = state_36504__$1;
(statearr_36512_36552[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (21))){
var state_36504__$1 = state_36504;
var statearr_36513_36553 = state_36504__$1;
(statearr_36513_36553[(2)] = (0));

(statearr_36513_36553[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (13))){
var inst_36469 = (state_36504[(2)]);
var state_36504__$1 = state_36504;
var statearr_36514_36554 = state_36504__$1;
(statearr_36514_36554[(2)] = inst_36469);

(statearr_36514_36554[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (22))){
var state_36504__$1 = state_36504;
var statearr_36515_36555 = state_36504__$1;
(statearr_36515_36555[(2)] = (1));

(statearr_36515_36555[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (6))){
var inst_36461 = (state_36504[(7)]);
var inst_36450 = (state_36504[(8)]);
var inst_36459 = (state_36504[(9)]);
var inst_36458 = cljs.core.seq(inst_36450);
var inst_36459__$1 = cljs.core.first(inst_36458);
var inst_36460 = cljs.core.next(inst_36458);
var inst_36461__$1 = (inst_36459__$1 == null);
var state_36504__$1 = (function (){var statearr_36516 = state_36504;
(statearr_36516[(7)] = inst_36461__$1);

(statearr_36516[(10)] = inst_36460);

(statearr_36516[(9)] = inst_36459__$1);

return statearr_36516;
})();
if(cljs.core.truth_(inst_36461__$1)){
var statearr_36517_36556 = state_36504__$1;
(statearr_36517_36556[(1)] = (8));

} else {
var statearr_36518_36557 = state_36504__$1;
(statearr_36518_36557[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (17))){
var inst_36459 = (state_36504[(9)]);
var inst_36479 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_36459);
var state_36504__$1 = state_36504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36504__$1,(20),inst_36479);
} else {
if((state_val_36505 === (3))){
var inst_36502 = (state_36504[(2)]);
var state_36504__$1 = state_36504;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36504__$1,inst_36502);
} else {
if((state_val_36505 === (12))){
var inst_36452 = (state_36504[(11)]);
var inst_36467 = (inst_36452 >= subject_limit);
var state_36504__$1 = state_36504;
var statearr_36519_36558 = state_36504__$1;
(statearr_36519_36558[(2)] = inst_36467);

(statearr_36519_36558[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (2))){
var _ = (function (){var statearr_36520 = state_36504;
(statearr_36520[(4)] = cljs.core.cons((5),(state_36504[(4)])));

return statearr_36520;
})();
var inst_36443 = subject_groups;
var inst_36444 = cljs.core.seq(inst_36443);
var inst_36445 = cljs.core.first(inst_36444);
var inst_36446 = cljs.core.next(inst_36444);
var inst_36447 = flake_start;
var inst_36448 = subject_start;
var inst_36449 = cljs.core.PersistentVector.EMPTY;
var inst_36450 = inst_36443;
var inst_36451 = inst_36447;
var inst_36452 = inst_36448;
var inst_36453 = inst_36449;
var state_36504__$1 = (function (){var statearr_36521 = state_36504;
(statearr_36521[(12)] = inst_36445);

(statearr_36521[(13)] = inst_36451);

(statearr_36521[(14)] = inst_36446);

(statearr_36521[(11)] = inst_36452);

(statearr_36521[(15)] = inst_36453);

(statearr_36521[(8)] = inst_36450);

return statearr_36521;
})();
var statearr_36522_36559 = state_36504__$1;
(statearr_36522_36559[(2)] = null);

(statearr_36522_36559[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (23))){
var inst_36486 = (state_36504[(16)]);
var inst_36485 = (state_36504[(17)]);
var inst_36451 = (state_36504[(13)]);
var inst_36452 = (state_36504[(11)]);
var inst_36453 = (state_36504[(15)]);
var inst_36460 = (state_36504[(10)]);
var inst_36491 = (state_36504[(2)]);
var inst_36492 = (inst_36451 + inst_36486);
var inst_36493 = (inst_36452 + inst_36491);
var inst_36494 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36453,inst_36485);
var inst_36450 = inst_36460;
var inst_36451__$1 = inst_36492;
var inst_36452__$1 = inst_36493;
var inst_36453__$1 = inst_36494;
var state_36504__$1 = (function (){var statearr_36523 = state_36504;
(statearr_36523[(13)] = inst_36451__$1);

(statearr_36523[(11)] = inst_36452__$1);

(statearr_36523[(15)] = inst_36453__$1);

(statearr_36523[(8)] = inst_36450);

return statearr_36523;
})();
var statearr_36524_36560 = state_36504__$1;
(statearr_36524_36560[(2)] = null);

(statearr_36524_36560[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (19))){
var inst_36486 = (state_36504[(16)]);
var inst_36485 = (state_36504[(17)]);
var inst_36485__$1 = (state_36504[(2)]);
var inst_36486__$1 = cljs.core.count(inst_36485__$1);
var inst_36487 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_36486__$1);
var state_36504__$1 = (function (){var statearr_36525 = state_36504;
(statearr_36525[(16)] = inst_36486__$1);

(statearr_36525[(17)] = inst_36485__$1);

return statearr_36525;
})();
if(inst_36487){
var statearr_36526_36561 = state_36504__$1;
(statearr_36526_36561[(1)] = (21));

} else {
var statearr_36527_36562 = state_36504__$1;
(statearr_36527_36562[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (11))){
var inst_36464 = (state_36504[(18)]);
var state_36504__$1 = state_36504;
var statearr_36529_36563 = state_36504__$1;
(statearr_36529_36563[(2)] = inst_36464);

(statearr_36529_36563[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (9))){
var inst_36451 = (state_36504[(13)]);
var inst_36464 = (state_36504[(18)]);
var inst_36464__$1 = (inst_36451 >= flake_limit);
var state_36504__$1 = (function (){var statearr_36530 = state_36504;
(statearr_36530[(18)] = inst_36464__$1);

return statearr_36530;
})();
if(cljs.core.truth_(inst_36464__$1)){
var statearr_36531_36564 = state_36504__$1;
(statearr_36531_36564[(1)] = (11));

} else {
var statearr_36532_36565 = state_36504__$1;
(statearr_36532_36565[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (5))){
var _ = (function (){var statearr_36533 = state_36504;
(statearr_36533[(4)] = cljs.core.rest((state_36504[(4)])));

return statearr_36533;
})();
var state_36504__$1 = state_36504;
var ex36528 = (state_36504__$1[(2)]);
var statearr_36534_36566 = state_36504__$1;
(statearr_36534_36566[(5)] = ex36528);


if((ex36528 instanceof Error)){
var statearr_36535_36567 = state_36504__$1;
(statearr_36535_36567[(1)] = (4));

(statearr_36535_36567[(5)] = null);

} else {
throw ex36528;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (14))){
var inst_36451 = (state_36504[(13)]);
var inst_36452 = (state_36504[(11)]);
var inst_36453 = (state_36504[(15)]);
var inst_36473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36474 = [inst_36451,inst_36452,inst_36453];
var inst_36475 = (new cljs.core.PersistentVector(null,3,(5),inst_36473,inst_36474,null));
var state_36504__$1 = state_36504;
var statearr_36536_36568 = state_36504__$1;
(statearr_36536_36568[(2)] = inst_36475);

(statearr_36536_36568[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (16))){
var inst_36497 = (state_36504[(2)]);
var state_36504__$1 = state_36504;
var statearr_36537_36569 = state_36504__$1;
(statearr_36537_36569[(2)] = inst_36497);

(statearr_36537_36569[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (10))){
var inst_36471 = (state_36504[(2)]);
var state_36504__$1 = state_36504;
if(cljs.core.truth_(inst_36471)){
var statearr_36538_36570 = state_36504__$1;
(statearr_36538_36570[(1)] = (14));

} else {
var statearr_36539_36571 = state_36504__$1;
(statearr_36539_36571[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (18))){
var inst_36459 = (state_36504[(9)]);
var state_36504__$1 = state_36504;
var statearr_36540_36572 = state_36504__$1;
(statearr_36540_36572[(2)] = inst_36459);

(statearr_36540_36572[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36505 === (8))){
var inst_36461 = (state_36504[(7)]);
var state_36504__$1 = state_36504;
var statearr_36541_36573 = state_36504__$1;
(statearr_36541_36573[(2)] = inst_36461);

(statearr_36541_36573[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__20477__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__20477__auto____0 = (function (){
var statearr_36542 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36542[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__20477__auto__);

(statearr_36542[(1)] = (1));

return statearr_36542;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__20477__auto____1 = (function (state_36504){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_36504);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e36543){var ex__20480__auto__ = e36543;
var statearr_36544_36574 = state_36504;
(statearr_36544_36574[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_36504[(4)]))){
var statearr_36545_36575 = state_36504;
(statearr_36545_36575[(1)] = cljs.core.first((state_36504[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__36576 = state_36504;
state_36504 = G__36576;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__20477__auto__ = function(state_36504){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__20477__auto____1.call(this,state_36504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__20477__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__20477__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_36546 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_36546[(6)] = c__20603__auto__);

return statearr_36546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_36622){
var state_val_36623 = (state_36622[(1)]);
if((state_val_36623 === (7))){
var state_36622__$1 = state_36622;
var statearr_36624_36662 = state_36622__$1;
(statearr_36624_36662[(2)] = null);

(statearr_36624_36662[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (20))){
var inst_36608 = (state_36622[(2)]);
var inst_36609 = fluree.db.util.async.throw_err(inst_36608);
var inst_36587 = inst_36609;
var state_36622__$1 = (function (){var statearr_36625 = state_36622;
(statearr_36625[(7)] = inst_36587);

return statearr_36625;
})();
var statearr_36626_36663 = state_36622__$1;
(statearr_36626_36663[(2)] = null);

(statearr_36626_36663[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (1))){
var state_36622__$1 = state_36622;
var statearr_36627_36664 = state_36622__$1;
(statearr_36627_36664[(2)] = null);

(statearr_36627_36664[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (4))){
var inst_36577 = (state_36622[(2)]);
var state_36622__$1 = state_36622;
var statearr_36628_36665 = state_36622__$1;
(statearr_36628_36665[(2)] = inst_36577);

(statearr_36628_36665[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (15))){
var inst_36604 = (state_36622[(8)]);
var inst_36587 = (state_36622[(7)]);
var inst_36604__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_36587);
var state_36622__$1 = (function (){var statearr_36629 = state_36622;
(statearr_36629[(8)] = inst_36604__$1);

return statearr_36629;
})();
if(cljs.core.truth_(inst_36604__$1)){
var statearr_36630_36666 = state_36622__$1;
(statearr_36630_36666[(1)] = (17));

} else {
var statearr_36631_36667 = state_36622__$1;
(statearr_36631_36667[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (13))){
var inst_36597 = (state_36622[(2)]);
var inst_36598 = fluree.db.util.async.throw_err(inst_36597);
var _ = (function (){var statearr_36632 = state_36622;
(statearr_36632[(4)] = cljs.core.rest((state_36622[(4)])));

return statearr_36632;
})();
var state_36622__$1 = state_36622;
var statearr_36633_36668 = state_36622__$1;
(statearr_36633_36668[(2)] = inst_36598);

(statearr_36633_36668[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (6))){
var inst_36585 = (state_36622[(2)]);
var inst_36586 = fluree.db.util.async.throw_err(inst_36585);
var inst_36587 = inst_36586;
var state_36622__$1 = (function (){var statearr_36634 = state_36622;
(statearr_36634[(7)] = inst_36587);

return statearr_36634;
})();
var statearr_36635_36669 = state_36622__$1;
(statearr_36635_36669[(2)] = null);

(statearr_36635_36669[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (17))){
var inst_36604 = (state_36622[(8)]);
var inst_36606 = fluree.db.dbproto._lookup_leaf(root_node,inst_36604);
var state_36622__$1 = state_36622;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36622__$1,(20),inst_36606);
} else {
if((state_val_36623 === (3))){
var inst_36620 = (state_36622[(2)]);
var state_36622__$1 = state_36622;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36622__$1,inst_36620);
} else {
if((state_val_36623 === (12))){
var _ = (function (){var statearr_36637 = state_36622;
(statearr_36637[(4)] = cljs.core.rest((state_36622[(4)])));

return statearr_36637;
})();
var state_36622__$1 = state_36622;
var ex36636 = (state_36622__$1[(2)]);
var statearr_36638_36670 = state_36622__$1;
(statearr_36638_36670[(5)] = ex36636);


var statearr_36639_36671 = state_36622__$1;
(statearr_36639_36671[(1)] = (11));

(statearr_36639_36671[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (2))){
var _ = (function (){var statearr_36640 = state_36622;
(statearr_36640[(4)] = cljs.core.cons((5),(state_36622[(4)])));

return statearr_36640;
})();
var inst_36583 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_36622__$1 = state_36622;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36622__$1,(6),inst_36583);
} else {
if((state_val_36623 === (19))){
var inst_36613 = (state_36622[(2)]);
var state_36622__$1 = state_36622;
var statearr_36641_36672 = state_36622__$1;
(statearr_36641_36672[(2)] = inst_36613);

(statearr_36641_36672[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (11))){
var inst_36589 = (state_36622[(2)]);
var state_36622__$1 = (function (){var statearr_36643 = state_36622;
(statearr_36643[(9)] = inst_36589);

return statearr_36643;
})();
var statearr_36644_36673 = state_36622__$1;
(statearr_36644_36673[(2)] = null);

(statearr_36644_36673[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (9))){
var inst_36587 = (state_36622[(7)]);
var _ = (function (){var statearr_36645 = state_36622;
(statearr_36645[(4)] = cljs.core.cons((12),(state_36622[(4)])));

return statearr_36645;
})();
var inst_36595 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_36587,t,novelty,fast_forward_db_QMARK_);
var state_36622__$1 = state_36622;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36622__$1,(13),inst_36595);
} else {
if((state_val_36623 === (5))){
var _ = (function (){var statearr_36646 = state_36622;
(statearr_36646[(4)] = cljs.core.rest((state_36622[(4)])));

return statearr_36646;
})();
var state_36622__$1 = state_36622;
var ex36642 = (state_36622__$1[(2)]);
var statearr_36647_36674 = state_36622__$1;
(statearr_36647_36674[(5)] = ex36642);


if((ex36642 instanceof Error)){
var statearr_36648_36675 = state_36622__$1;
(statearr_36648_36675[(1)] = (4));

(statearr_36648_36675[(5)] = null);

} else {
throw ex36642;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (14))){
var inst_36601 = (state_36622[(10)]);
var state_36622__$1 = state_36622;
var statearr_36649_36676 = state_36622__$1;
(statearr_36649_36676[(2)] = inst_36601);

(statearr_36649_36676[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (16))){
var inst_36615 = (state_36622[(2)]);
var state_36622__$1 = state_36622;
var statearr_36650_36677 = state_36622__$1;
(statearr_36650_36677[(2)] = inst_36615);

(statearr_36650_36677[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (10))){
var inst_36601 = (state_36622[(10)]);
var inst_36601__$1 = (state_36622[(2)]);
var state_36622__$1 = (function (){var statearr_36651 = state_36622;
(statearr_36651[(10)] = inst_36601__$1);

return statearr_36651;
})();
if(cljs.core.truth_(inst_36601__$1)){
var statearr_36652_36678 = state_36622__$1;
(statearr_36652_36678[(1)] = (14));

} else {
var statearr_36653_36679 = state_36622__$1;
(statearr_36653_36679[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (18))){
var state_36622__$1 = state_36622;
var statearr_36654_36680 = state_36622__$1;
(statearr_36654_36680[(2)] = null);

(statearr_36654_36680[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36623 === (8))){
var inst_36617 = (state_36622[(2)]);
var _ = (function (){var statearr_36655 = state_36622;
(statearr_36655[(4)] = cljs.core.rest((state_36622[(4)])));

return statearr_36655;
})();
var state_36622__$1 = state_36622;
var statearr_36656_36681 = state_36622__$1;
(statearr_36656_36681[(2)] = inst_36617);

(statearr_36656_36681[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__20477__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__20477__auto____0 = (function (){
var statearr_36657 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36657[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__20477__auto__);

(statearr_36657[(1)] = (1));

return statearr_36657;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__20477__auto____1 = (function (state_36622){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_36622);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e36658){var ex__20480__auto__ = e36658;
var statearr_36659_36682 = state_36622;
(statearr_36659_36682[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_36622[(4)]))){
var statearr_36660_36683 = state_36622;
(statearr_36660_36683[(1)] = cljs.core.first((state_36622[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__36684 = state_36622;
state_36622 = G__36684;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__20477__auto__ = function(state_36622){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__20477__auto____1.call(this,state_36622);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__20477__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__20477__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_36661 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_36661[(6)] = c__20603__auto__);

return statearr_36661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__36691 = arguments.length;
switch (G__36691) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__36692 = (function (){var pred__36695 = cljs.core.identical_QMARK_;
var expr__36696 = test;
if(cljs.core.truth_((pred__36695.cljs$core$IFn$_invoke$arity$2 ? pred__36695.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__36696) : pred__36695.call(null,cljs.core._EQ_,expr__36696)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__36695.cljs$core$IFn$_invoke$arity$2 ? pred__36695.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__36696) : pred__36695.call(null,cljs.core._LT_,expr__36696)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__36695.cljs$core$IFn$_invoke$arity$2 ? pred__36695.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__36696) : pred__36695.call(null,cljs.core._LT__EQ_,expr__36696)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__36695.cljs$core$IFn$_invoke$arity$2 ? pred__36695.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__36696) : pred__36695.call(null,cljs.core._GT_,expr__36696)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__36695.cljs$core$IFn$_invoke$arity$2 ? pred__36695.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__36696) : pred__36695.call(null,cljs.core._GT__EQ_,expr__36696)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__36696)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36692,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36692,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36692,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36692,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_37068){
var state_val_37069 = (state_37068[(1)]);
if((state_val_37069 === (121))){
var inst_37024 = (state_37068[(7)]);
var state_37068__$1 = state_37068;
var statearr_37070_37266 = state_37068__$1;
(statearr_37070_37266[(2)] = inst_37024);

(statearr_37070_37266[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (65))){
var inst_36876 = (state_37068[(8)]);
var inst_36882 = (state_37068[(2)]);
var state_37068__$1 = (function (){var statearr_37071 = state_37068;
(statearr_37071[(9)] = inst_36882);

return statearr_37071;
})();
if(cljs.core.truth_(inst_36876)){
var statearr_37072_37267 = state_37068__$1;
(statearr_37072_37267[(1)] = (66));

} else {
var statearr_37073_37268 = state_37068__$1;
(statearr_37073_37268[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (70))){
var inst_37060 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37074_37269 = state_37068__$1;
(statearr_37074_37269[(2)] = inst_37060);

(statearr_37074_37269[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (62))){
var inst_36875 = (state_37068[(2)]);
var inst_36876 = fluree.db.util.async.throw_err(inst_36875);
var inst_36877 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_37068__$1 = (function (){var statearr_37075 = state_37068;
(statearr_37075[(8)] = inst_36876);

return statearr_37075;
})();
if(cljs.core.truth_(inst_36877)){
var statearr_37076_37270 = state_37068__$1;
(statearr_37076_37270[(1)] = (63));

} else {
var statearr_37077_37271 = state_37068__$1;
(statearr_37077_37271[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (74))){
var inst_36745 = (state_37068[(10)]);
var inst_36730 = (state_37068[(11)]);
var inst_36867 = (state_37068[(12)]);
var inst_36786 = (state_37068[(13)]);
var inst_36855 = (state_37068[(14)]);
var inst_36866 = (state_37068[(15)]);
var inst_36895 = (state_37068[(16)]);
var inst_36754 = (state_37068[(17)]);
var inst_36725 = (state_37068[(18)]);
var inst_36722 = (state_37068[(19)]);
var inst_36729 = (state_37068[(20)]);
var inst_36849 = (state_37068[(21)]);
var inst_36872 = (state_37068[(22)]);
var inst_36886 = (state_37068[(23)]);
var inst_36889 = (state_37068[(24)]);
var inst_36885 = (state_37068[(25)]);
var inst_36799 = (state_37068[(26)]);
var inst_36861 = (state_37068[(27)]);
var inst_36876 = (state_37068[(8)]);
var inst_36835 = (state_37068[(28)]);
var inst_36856 = (state_37068[(29)]);
var inst_36845 = (state_37068[(30)]);
var inst_36848 = (state_37068[(31)]);
var inst_36846 = (state_37068[(32)]);
var inst_36734 = (state_37068[(33)]);
var inst_36790 = (state_37068[(34)]);
var inst_36888 = (state_37068[(35)]);
var inst_36718 = (state_37068[(36)]);
var inst_36826 = (state_37068[(37)]);
var inst_36723 = (state_37068[(38)]);
var inst_36808 = (state_37068[(39)]);
var inst_36735 = (state_37068[(40)]);
var inst_36844 = (state_37068[(41)]);
var inst_36862 = (state_37068[(42)]);
var inst_36882 = (state_37068[(9)]);
var inst_36857 = (state_37068[(43)]);
var inst_36903 = (state_37068[(44)]);
var inst_36817 = (state_37068[(45)]);
var inst_36787 = (state_37068[(46)]);
var inst_36887 = (state_37068[(47)]);
var inst_36733 = (state_37068[(48)]);
var inst_36905 = (function (){var no_filter_QMARK_ = inst_36882;
var t = inst_36862;
var max_limit_QMARK_ = inst_36856;
var next_node = inst_36885;
var fast_forward_db_QMARK_ = inst_36867;
var s1 = inst_36745;
var o2 = inst_36808;
var t1 = inst_36722;
var predicate_fn = inst_36735;
var i = inst_36887;
var map__36710 = inst_36733;
var m1 = inst_36835;
var root_node = inst_36872;
var s2 = inst_36754;
var vec__36704 = inst_36718;
var G__36896 = inst_36903;
var p2 = inst_36826;
var permissions = inst_36857;
var vec__36714 = inst_36787;
var limit = inst_36855;
var start_flake = inst_36845;
var vec__36711 = inst_36786;
var map__36717 = inst_36848;
var flake_limit = inst_36849;
var offset = inst_36886;
var acc = inst_36889;
var vec__36707 = inst_36725;
var t2 = inst_36729;
var op1 = inst_36723;
var o1 = inst_36799;
var end_flake = inst_36846;
var base_result = inst_36895;
var s = inst_36888;
var node_start = inst_36876;
var p1 = inst_36817;
var subject_fn = inst_36734;
var object_fn = inst_36790;
var idx_compare = inst_36861;
var op2 = inst_36730;
var m2 = inst_36844;
var novelty = inst_36866;
return (function (p1__36686_SHARP_){
var G__37078 = p1__36686_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__37078) : subject_fn.call(null,G__37078));
});
})();
var inst_36906 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_36905,inst_36903);
var state_37068__$1 = state_37068;
var statearr_37079_37272 = state_37068__$1;
(statearr_37079_37272[(2)] = inst_36906);

(statearr_37079_37272[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (110))){
var inst_37037 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37080_37273 = state_37068__$1;
(statearr_37080_37273[(2)] = inst_37037);

(statearr_37080_37273[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (7))){
var inst_36719 = (state_37068[(49)]);
var state_37068__$1 = state_37068;
var statearr_37081_37274 = state_37068__$1;
(statearr_37081_37274[(2)] = inst_36719);

(statearr_37081_37274[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (59))){
var state_37068__$1 = state_37068;
var statearr_37082_37275 = state_37068__$1;
(statearr_37082_37275[(2)] = fluree.db.util.core.max_long);

(statearr_37082_37275[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (86))){
var inst_36882 = (state_37068[(9)]);
var state_37068__$1 = state_37068;
var statearr_37083_37276 = state_37068__$1;
(statearr_37083_37276[(2)] = inst_36882);

(statearr_37083_37276[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (20))){
var state_37068__$1 = state_37068;
var statearr_37084_37277 = state_37068__$1;
(statearr_37084_37277[(2)] = null);

(statearr_37084_37277[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (72))){
var inst_36895 = (state_37068[(16)]);
var state_37068__$1 = state_37068;
var statearr_37085_37278 = state_37068__$1;
(statearr_37085_37278[(2)] = inst_36895);

(statearr_37085_37278[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (58))){
var inst_36850 = (state_37068[(50)]);
var state_37068__$1 = state_37068;
var statearr_37086_37279 = state_37068__$1;
(statearr_37086_37279[(2)] = inst_36850);

(statearr_37086_37279[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (60))){
var inst_36855 = (state_37068[(14)]);
var inst_36855__$1 = (state_37068[(2)]);
var inst_36856 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_36855__$1,fluree.db.util.core.max_long);
var inst_36857 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_36858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36859 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_36860 = (new cljs.core.PersistentVector(null,3,(5),inst_36858,inst_36859,null));
var inst_36861 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_36860);
var inst_36862 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_36863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36864 = [cljs.core.cst$kw$novelty,idx];
var inst_36865 = (new cljs.core.PersistentVector(null,2,(5),inst_36863,inst_36864,null));
var inst_36866 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_36865);
var inst_36867 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_36868 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_36869 = fluree.db.dbproto._resolve(inst_36868);
var state_37068__$1 = (function (){var statearr_37087 = state_37068;
(statearr_37087[(12)] = inst_36867);

(statearr_37087[(14)] = inst_36855__$1);

(statearr_37087[(15)] = inst_36866);

(statearr_37087[(27)] = inst_36861);

(statearr_37087[(29)] = inst_36856);

(statearr_37087[(42)] = inst_36862);

(statearr_37087[(43)] = inst_36857);

return statearr_37087;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(61),inst_36869);
} else {
if((state_val_37069 === (27))){
var inst_36788 = (state_37068[(51)]);
var state_37068__$1 = state_37068;
var statearr_37088_37280 = state_37068__$1;
(statearr_37088_37280[(2)] = inst_36788);

(statearr_37088_37280[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (1))){
var state_37068__$1 = state_37068;
var statearr_37089_37281 = state_37068__$1;
(statearr_37089_37281[(2)] = null);

(statearr_37089_37281[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (69))){
var inst_36885 = (state_37068[(25)]);
var inst_36845 = (state_37068[(30)]);
var inst_36846 = (state_37068[(32)]);
var inst_36894 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_36885);
var inst_36895 = fluree.db.flake.subrange(inst_36894,start_test,inst_36845,end_test,inst_36846);
var inst_36897 = fluree.db.query.range.value_with_nil_pred(idx,inst_36845,inst_36846);
var state_37068__$1 = (function (){var statearr_37090 = state_37068;
(statearr_37090[(16)] = inst_36895);

return statearr_37090;
})();
if(inst_36897){
var statearr_37091_37282 = state_37068__$1;
(statearr_37091_37282[(1)] = (71));

} else {
var statearr_37092_37283 = state_37068__$1;
(statearr_37092_37283[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (101))){
var inst_36849 = (state_37068[(21)]);
var inst_36982 = (state_37068[(52)]);
var inst_36981 = (state_37068[(53)]);
var inst_36983 = (state_37068[(54)]);
var inst_36986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36987 = (inst_36983 - inst_36849);
var inst_36988 = (inst_36982 - inst_36987);
var inst_36989 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_36988,inst_36981);
var inst_36990 = [inst_36849,inst_36989];
var inst_36991 = (new cljs.core.PersistentVector(null,2,(5),inst_36986,inst_36990,null));
var state_37068__$1 = state_37068;
var statearr_37093_37284 = state_37068__$1;
(statearr_37093_37284[(2)] = inst_36991);

(statearr_37093_37284[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (24))){
var inst_36745 = (state_37068[(10)]);
var inst_36730 = (state_37068[(11)]);
var inst_36720 = (state_37068[(55)]);
var inst_36727 = (state_37068[(56)]);
var inst_36736 = (state_37068[(57)]);
var inst_36754 = (state_37068[(17)]);
var inst_36725 = (state_37068[(18)]);
var inst_36722 = (state_37068[(19)]);
var inst_36729 = (state_37068[(20)]);
var inst_36721 = (state_37068[(58)]);
var inst_36768 = (state_37068[(59)]);
var inst_36731 = (state_37068[(60)]);
var inst_36734 = (state_37068[(33)]);
var inst_36718 = (state_37068[(36)]);
var inst_36723 = (state_37068[(38)]);
var inst_36735 = (state_37068[(40)]);
var inst_36728 = (state_37068[(61)]);
var inst_36724 = (state_37068[(62)]);
var inst_36733 = (state_37068[(48)]);
var inst_36778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36780 = [null,null];
var inst_36781 = (new cljs.core.PersistentVector(null,2,(5),inst_36779,inst_36780,null));
var inst_36782 = (function (){var bool = inst_36768;
var s1 = inst_36745;
var o2 = inst_36728;
var t1 = inst_36722;
var predicate_fn = inst_36735;
var map__36710 = inst_36733;
var m1 = inst_36724;
var s2 = inst_36754;
var vec__36704 = inst_36718;
var p2 = inst_36727;
var vec__36707 = inst_36725;
var t2 = inst_36729;
var op1 = inst_36723;
var o1 = inst_36721;
var p1 = inst_36720;
var subject_fn = inst_36734;
var object_fn = inst_36736;
var op2 = inst_36730;
var m2 = inst_36731;
var temp__5755__auto__ = inst_36768;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_36783 = [inst_36781,inst_36782];
var inst_36784 = (new cljs.core.PersistentVector(null,2,(5),inst_36778,inst_36783,null));
var state_37068__$1 = state_37068;
var statearr_37094_37285 = state_37068__$1;
(statearr_37094_37285[(2)] = inst_36784);

(statearr_37094_37285[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (102))){
var inst_36981 = (state_37068[(53)]);
var inst_36983 = (state_37068[(54)]);
var inst_36993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36994 = [inst_36983,inst_36981];
var inst_36995 = (new cljs.core.PersistentVector(null,2,(5),inst_36993,inst_36994,null));
var state_37068__$1 = state_37068;
var statearr_37095_37286 = state_37068__$1;
(statearr_37095_37286[(2)] = inst_36995);

(statearr_37095_37286[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (55))){
var state_37068__$1 = state_37068;
var statearr_37096_37287 = state_37068__$1;
(statearr_37096_37287[(2)] = (2147483647));

(statearr_37096_37287[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (85))){
var inst_36931 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
if(cljs.core.truth_(inst_36931)){
var statearr_37097_37288 = state_37068__$1;
(statearr_37097_37288[(1)] = (89));

} else {
var statearr_37098_37289 = state_37068__$1;
(statearr_37098_37289[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (39))){
var inst_36727 = (state_37068[(56)]);
var inst_36818 = (state_37068[(63)]);
var inst_36817 = (state_37068[(2)]);
var inst_36818__$1 = (inst_36727 == null);
var state_37068__$1 = (function (){var statearr_37099 = state_37068;
(statearr_37099[(63)] = inst_36818__$1);

(statearr_37099[(45)] = inst_36817);

return statearr_37099;
})();
if(cljs.core.truth_(inst_36818__$1)){
var statearr_37100_37290 = state_37068__$1;
(statearr_37100_37290[(1)] = (40));

} else {
var statearr_37101_37291 = state_37068__$1;
(statearr_37101_37291[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (88))){
var inst_36928 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37102_37292 = state_37068__$1;
(statearr_37102_37292[(2)] = inst_36928);

(statearr_37102_37292[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (46))){
var inst_36724 = (state_37068[(62)]);
var state_37068__$1 = state_37068;
var statearr_37103_37293 = state_37068__$1;
(statearr_37103_37293[(2)] = inst_36724);

(statearr_37103_37293[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (4))){
var inst_36698 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37104_37294 = state_37068__$1;
(statearr_37104_37294[(2)] = inst_36698);

(statearr_37104_37294[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (77))){
var inst_36745 = (state_37068[(10)]);
var inst_36730 = (state_37068[(11)]);
var inst_36867 = (state_37068[(12)]);
var inst_36786 = (state_37068[(13)]);
var inst_36909 = (state_37068[(64)]);
var inst_36855 = (state_37068[(14)]);
var inst_36866 = (state_37068[(15)]);
var inst_36895 = (state_37068[(16)]);
var inst_36754 = (state_37068[(17)]);
var inst_36725 = (state_37068[(18)]);
var inst_36722 = (state_37068[(19)]);
var inst_36729 = (state_37068[(20)]);
var inst_36849 = (state_37068[(21)]);
var inst_36872 = (state_37068[(22)]);
var inst_36886 = (state_37068[(23)]);
var inst_36889 = (state_37068[(24)]);
var inst_36885 = (state_37068[(25)]);
var inst_36799 = (state_37068[(26)]);
var inst_36861 = (state_37068[(27)]);
var inst_36876 = (state_37068[(8)]);
var inst_36835 = (state_37068[(28)]);
var inst_36856 = (state_37068[(29)]);
var inst_36845 = (state_37068[(30)]);
var inst_36848 = (state_37068[(31)]);
var inst_36846 = (state_37068[(32)]);
var inst_36734 = (state_37068[(33)]);
var inst_36790 = (state_37068[(34)]);
var inst_36888 = (state_37068[(35)]);
var inst_36718 = (state_37068[(36)]);
var inst_36826 = (state_37068[(37)]);
var inst_36723 = (state_37068[(38)]);
var inst_36808 = (state_37068[(39)]);
var inst_36735 = (state_37068[(40)]);
var inst_36844 = (state_37068[(41)]);
var inst_36862 = (state_37068[(42)]);
var inst_36882 = (state_37068[(9)]);
var inst_36857 = (state_37068[(43)]);
var inst_36817 = (state_37068[(45)]);
var inst_36787 = (state_37068[(46)]);
var inst_36887 = (state_37068[(47)]);
var inst_36733 = (state_37068[(48)]);
var inst_36911 = (function (){var no_filter_QMARK_ = inst_36882;
var t = inst_36862;
var max_limit_QMARK_ = inst_36856;
var next_node = inst_36885;
var fast_forward_db_QMARK_ = inst_36867;
var s1 = inst_36745;
var o2 = inst_36808;
var t1 = inst_36722;
var predicate_fn = inst_36735;
var i = inst_36887;
var map__36710 = inst_36733;
var m1 = inst_36835;
var root_node = inst_36872;
var s2 = inst_36754;
var vec__36704 = inst_36718;
var G__36896 = inst_36909;
var p2 = inst_36826;
var permissions = inst_36857;
var vec__36714 = inst_36787;
var limit = inst_36855;
var start_flake = inst_36845;
var vec__36711 = inst_36786;
var map__36717 = inst_36848;
var flake_limit = inst_36849;
var offset = inst_36886;
var acc = inst_36889;
var vec__36707 = inst_36725;
var t2 = inst_36729;
var op1 = inst_36723;
var o1 = inst_36799;
var end_flake = inst_36846;
var base_result = inst_36895;
var s = inst_36888;
var node_start = inst_36876;
var p1 = inst_36817;
var subject_fn = inst_36734;
var object_fn = inst_36790;
var idx_compare = inst_36861;
var op2 = inst_36730;
var m2 = inst_36844;
var novelty = inst_36866;
return (function (p1__36687_SHARP_){
var G__37105 = p1__36687_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__37105) : predicate_fn.call(null,G__37105));
});
})();
var inst_36912 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_36911,inst_36909);
var state_37068__$1 = state_37068;
var statearr_37106_37295 = state_37068__$1;
(statearr_37106_37295[(2)] = inst_36912);

(statearr_37106_37295[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (106))){
var inst_36922 = (state_37068[(65)]);
var state_37068__$1 = state_37068;
var statearr_37107_37296 = state_37068__$1;
(statearr_37107_37296[(2)] = inst_36922);

(statearr_37107_37296[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (119))){
var inst_37040 = (state_37068[(66)]);
var state_37068__$1 = state_37068;
var statearr_37108_37297 = state_37068__$1;
(statearr_37108_37297[(2)] = inst_37040);

(statearr_37108_37297[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (95))){
var inst_36855 = (state_37068[(14)]);
var inst_36888 = (state_37068[(35)]);
var inst_36964 = (state_37068[(67)]);
var inst_36965 = (state_37068[(68)]);
var inst_36963 = (state_37068[(69)]);
var inst_36955 = (state_37068[(70)]);
var inst_36963__$1 = cljs.core.count(inst_36955);
var inst_36964__$1 = (inst_36888 + inst_36963__$1);
var inst_36965__$1 = (inst_36964__$1 - inst_36855);
var inst_36966 = cljs.core.pos_int_QMARK_(inst_36965__$1);
var state_37068__$1 = (function (){var statearr_37109 = state_37068;
(statearr_37109[(67)] = inst_36964__$1);

(statearr_37109[(68)] = inst_36965__$1);

(statearr_37109[(69)] = inst_36963__$1);

return statearr_37109;
})();
if(inst_36966){
var statearr_37110_37298 = state_37068__$1;
(statearr_37110_37298[(1)] = (98));

} else {
var statearr_37111_37299 = state_37068__$1;
(statearr_37111_37299[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (54))){
var inst_36745 = (state_37068[(10)]);
var inst_36730 = (state_37068[(11)]);
var inst_36754 = (state_37068[(17)]);
var inst_36722 = (state_37068[(19)]);
var inst_36729 = (state_37068[(20)]);
var inst_36799 = (state_37068[(26)]);
var inst_36835 = (state_37068[(28)]);
var inst_36848 = (state_37068[(31)]);
var inst_36850 = (state_37068[(50)]);
var inst_36826 = (state_37068[(37)]);
var inst_36723 = (state_37068[(38)]);
var inst_36808 = (state_37068[(39)]);
var inst_36844 = (state_37068[(41)]);
var inst_36817 = (state_37068[(45)]);
var inst_36844__$1 = (state_37068[(2)]);
var inst_36845 = fluree.db.flake.__GT_Flake(inst_36745,inst_36817,inst_36799,inst_36722,inst_36723,inst_36835);
var inst_36846 = fluree.db.flake.__GT_Flake(inst_36754,inst_36826,inst_36808,inst_36729,inst_36730,inst_36844__$1);
var inst_36847 = opts;
var inst_36848__$1 = cljs.core.__destructure_map(inst_36847);
var inst_36849 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_36848__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_36850__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36848__$1,cljs.core.cst$kw$limit);
var inst_36851 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_36848__$1,cljs.core.cst$kw$offset,(0));
var state_37068__$1 = (function (){var statearr_37112 = state_37068;
(statearr_37112[(21)] = inst_36849);

(statearr_37112[(30)] = inst_36845);

(statearr_37112[(71)] = inst_36851);

(statearr_37112[(31)] = inst_36848__$1);

(statearr_37112[(32)] = inst_36846);

(statearr_37112[(50)] = inst_36850__$1);

(statearr_37112[(41)] = inst_36844__$1);

return statearr_37112;
})();
if(cljs.core.truth_(inst_36850__$1)){
var statearr_37113_37300 = state_37068__$1;
(statearr_37113_37300[(1)] = (58));

} else {
var statearr_37114_37301 = state_37068__$1;
(statearr_37114_37301[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (92))){
var inst_36886 = (state_37068[(23)]);
var inst_36889 = (state_37068[(24)]);
var inst_36944 = (state_37068[(72)]);
var inst_36888 = (state_37068[(35)]);
var inst_36887 = (state_37068[(47)]);
var inst_36947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36948 = (inst_36886 - inst_36944);
var inst_36949 = [inst_36948,inst_36887,inst_36888,inst_36889];
var inst_36950 = (new cljs.core.PersistentVector(null,4,(5),inst_36947,inst_36949,null));
var state_37068__$1 = state_37068;
var statearr_37115_37302 = state_37068__$1;
(statearr_37115_37302[(2)] = inst_36950);

(statearr_37115_37302[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (104))){
var inst_37006 = (state_37068[(2)]);
var inst_37007 = fluree.db.util.async.throw_err(inst_37006);
var state_37068__$1 = state_37068;
var statearr_37116_37303 = state_37068__$1;
(statearr_37116_37303[(2)] = inst_37007);

(statearr_37116_37303[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (15))){
var inst_36728 = (state_37068[(61)]);
var inst_36758 = cljs.core.boolean_QMARK_(inst_36728);
var state_37068__$1 = state_37068;
if(inst_36758){
var statearr_37117_37304 = state_37068__$1;
(statearr_37117_37304[(1)] = (17));

} else {
var statearr_37118_37305 = state_37068__$1;
(statearr_37118_37305[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (48))){
var inst_36731 = (state_37068[(60)]);
var inst_36835 = (state_37068[(2)]);
var state_37068__$1 = (function (){var statearr_37119 = state_37068;
(statearr_37119[(28)] = inst_36835);

return statearr_37119;
})();
if(cljs.core.truth_(inst_36731)){
var statearr_37120_37306 = state_37068__$1;
(statearr_37120_37306[(1)] = (52));

} else {
var statearr_37121_37307 = state_37068__$1;
(statearr_37121_37307[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (50))){
var state_37068__$1 = state_37068;
var statearr_37122_37308 = state_37068__$1;
(statearr_37122_37308[(2)] = (2147483647));

(statearr_37122_37308[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (116))){
var inst_37040 = (state_37068[(66)]);
var inst_37048 = (state_37068[(2)]);
var state_37068__$1 = (function (){var statearr_37123 = state_37068;
(statearr_37123[(73)] = inst_37048);

return statearr_37123;
})();
if(cljs.core.truth_(inst_37040)){
var statearr_37124_37309 = state_37068__$1;
(statearr_37124_37309[(1)] = (118));

} else {
var statearr_37125_37310 = state_37068__$1;
(statearr_37125_37310[(1)] = (119));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (75))){
var inst_36903 = (state_37068[(44)]);
var state_37068__$1 = state_37068;
var statearr_37126_37311 = state_37068__$1;
(statearr_37126_37311[(2)] = inst_36903);

(statearr_37126_37311[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (99))){
var inst_36964 = (state_37068[(67)]);
var inst_36973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36974 = [inst_36964,inst_36964];
var inst_36975 = (new cljs.core.PersistentVector(null,2,(5),inst_36973,inst_36974,null));
var state_37068__$1 = state_37068;
var statearr_37127_37312 = state_37068__$1;
(statearr_37127_37312[(2)] = inst_36975);

(statearr_37127_37312[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (21))){
var state_37068__$1 = state_37068;
var statearr_37128_37313 = state_37068__$1;
(statearr_37128_37313[(2)] = null);

(statearr_37128_37313[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (31))){
var inst_36789 = (state_37068[(74)]);
var state_37068__$1 = state_37068;
var statearr_37129_37314 = state_37068__$1;
(statearr_37129_37314[(2)] = inst_36789);

(statearr_37129_37314[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (113))){
var inst_37034 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37130_37315 = state_37068__$1;
(statearr_37130_37315[(2)] = inst_37034);

(statearr_37130_37315[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (32))){
var inst_36720 = (state_37068[(55)]);
var inst_36809 = (state_37068[(75)]);
var inst_36808 = (state_37068[(2)]);
var inst_36809__$1 = (inst_36720 == null);
var state_37068__$1 = (function (){var statearr_37131 = state_37068;
(statearr_37131[(39)] = inst_36808);

(statearr_37131[(75)] = inst_36809__$1);

return statearr_37131;
})();
if(cljs.core.truth_(inst_36809__$1)){
var statearr_37132_37316 = state_37068__$1;
(statearr_37132_37316[(1)] = (34));

} else {
var statearr_37133_37317 = state_37068__$1;
(statearr_37133_37317[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (40))){
var inst_36808 = (state_37068[(39)]);
var state_37068__$1 = state_37068;
var statearr_37134_37318 = state_37068__$1;
(statearr_37134_37318[(2)] = inst_36808);

(statearr_37134_37318[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (91))){
var inst_36922 = (state_37068[(65)]);
var inst_37020 = (state_37068[(2)]);
var inst_37021 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37020,(0),null);
var inst_37022 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37020,(1),null);
var inst_37023 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37020,(2),null);
var inst_37024 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37020,(3),null);
var state_37068__$1 = (function (){var statearr_37135 = state_37068;
(statearr_37135[(76)] = inst_37023);

(statearr_37135[(77)] = inst_37021);

(statearr_37135[(78)] = inst_37022);

(statearr_37135[(7)] = inst_37024);

return statearr_37135;
})();
if(cljs.core.truth_(inst_36922)){
var statearr_37136_37319 = state_37068__$1;
(statearr_37136_37319[(1)] = (105));

} else {
var statearr_37137_37320 = state_37068__$1;
(statearr_37137_37320[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (117))){
var inst_37044 = (state_37068[(2)]);
var inst_37045 = fluree.db.util.async.throw_err(inst_37044);
var state_37068__$1 = state_37068;
var statearr_37138_37321 = state_37068__$1;
(statearr_37138_37321[(2)] = inst_37045);

(statearr_37138_37321[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (108))){
var inst_36849 = (state_37068[(21)]);
var inst_37029 = (state_37068[(79)]);
var inst_37022 = (state_37068[(78)]);
var inst_37029__$1 = (inst_37022 < inst_36849);
var state_37068__$1 = (function (){var statearr_37139 = state_37068;
(statearr_37139[(79)] = inst_37029__$1);

return statearr_37139;
})();
if(cljs.core.truth_(inst_37029__$1)){
var statearr_37140_37322 = state_37068__$1;
(statearr_37140_37322[(1)] = (111));

} else {
var statearr_37141_37323 = state_37068__$1;
(statearr_37141_37323[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (56))){
var state_37068__$1 = state_37068;
var statearr_37142_37324 = state_37068__$1;
(statearr_37142_37324[(2)] = fluree.db.util.core.min_integer);

(statearr_37142_37324[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (33))){
var inst_36804 = (state_37068[(2)]);
var inst_36805 = fluree.db.util.async.throw_err(inst_36804);
var state_37068__$1 = state_37068;
var statearr_37143_37325 = state_37068__$1;
(statearr_37143_37325[(2)] = inst_36805);

(statearr_37143_37325[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (13))){
var inst_36750 = (state_37068[(2)]);
var inst_36751 = fluree.db.util.async.throw_err(inst_36750);
var state_37068__$1 = state_37068;
var statearr_37144_37326 = state_37068__$1;
(statearr_37144_37326[(2)] = inst_36751);

(statearr_37144_37326[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (22))){
var inst_36764 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37145_37327 = state_37068__$1;
(statearr_37145_37327[(2)] = inst_36764);

(statearr_37145_37327[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (90))){
var inst_36745 = (state_37068[(10)]);
var inst_36730 = (state_37068[(11)]);
var inst_36867 = (state_37068[(12)]);
var inst_36786 = (state_37068[(13)]);
var inst_36855 = (state_37068[(14)]);
var inst_36866 = (state_37068[(15)]);
var inst_36895 = (state_37068[(16)]);
var inst_36754 = (state_37068[(17)]);
var inst_36725 = (state_37068[(18)]);
var inst_36722 = (state_37068[(19)]);
var inst_36729 = (state_37068[(20)]);
var inst_36943 = (state_37068[(80)]);
var inst_36849 = (state_37068[(21)]);
var inst_36872 = (state_37068[(22)]);
var inst_36886 = (state_37068[(23)]);
var inst_36889 = (state_37068[(24)]);
var inst_36944 = (state_37068[(72)]);
var inst_36885 = (state_37068[(25)]);
var inst_36799 = (state_37068[(26)]);
var inst_36861 = (state_37068[(27)]);
var inst_36876 = (state_37068[(8)]);
var inst_36835 = (state_37068[(28)]);
var inst_36856 = (state_37068[(29)]);
var inst_36845 = (state_37068[(30)]);
var inst_36848 = (state_37068[(31)]);
var inst_36846 = (state_37068[(32)]);
var inst_36922 = (state_37068[(65)]);
var inst_36734 = (state_37068[(33)]);
var inst_36790 = (state_37068[(34)]);
var inst_36888 = (state_37068[(35)]);
var inst_36718 = (state_37068[(36)]);
var inst_36826 = (state_37068[(37)]);
var inst_36723 = (state_37068[(38)]);
var inst_36808 = (state_37068[(39)]);
var inst_36735 = (state_37068[(40)]);
var inst_36844 = (state_37068[(41)]);
var inst_36862 = (state_37068[(42)]);
var inst_36921 = (state_37068[(81)]);
var inst_36882 = (state_37068[(9)]);
var inst_36857 = (state_37068[(43)]);
var inst_36817 = (state_37068[(45)]);
var inst_36787 = (state_37068[(46)]);
var inst_36887 = (state_37068[(47)]);
var inst_36733 = (state_37068[(48)]);
var inst_36942 = (function (){var no_filter_QMARK_ = inst_36882;
var base_result_SINGLEQUOTE_ = inst_36921;
var t = inst_36862;
var max_limit_QMARK_ = inst_36856;
var next_node = inst_36885;
var fast_forward_db_QMARK_ = inst_36867;
var s1 = inst_36745;
var o2 = inst_36808;
var t1 = inst_36722;
var predicate_fn = inst_36735;
var i = inst_36887;
var rhs = inst_36922;
var map__36710 = inst_36733;
var m1 = inst_36835;
var root_node = inst_36872;
var s2 = inst_36754;
var vec__36704 = inst_36718;
var p2 = inst_36826;
var permissions = inst_36857;
var vec__36714 = inst_36787;
var limit = inst_36855;
var start_flake = inst_36845;
var vec__36711 = inst_36786;
var map__36717 = inst_36848;
var flake_limit = inst_36849;
var offset = inst_36886;
var acc = inst_36889;
var vec__36707 = inst_36725;
var t2 = inst_36729;
var op1 = inst_36723;
var o1 = inst_36799;
var end_flake = inst_36846;
var base_result = inst_36895;
var s = inst_36888;
var node_start = inst_36876;
var p1 = inst_36817;
var subject_fn = inst_36734;
var object_fn = inst_36790;
var idx_compare = inst_36861;
var op2 = inst_36730;
var m2 = inst_36844;
var novelty = inst_36866;
return (function (p1__36689_SHARP_){
return p1__36689_SHARP_.s;
});
})();
var inst_36943__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_36942,inst_36921);
var inst_36944__$1 = cljs.core.count(inst_36943__$1);
var inst_36945 = (inst_36886 > inst_36944__$1);
var state_37068__$1 = (function (){var statearr_37146 = state_37068;
(statearr_37146[(80)] = inst_36943__$1);

(statearr_37146[(72)] = inst_36944__$1);

return statearr_37146;
})();
if(cljs.core.truth_(inst_36945)){
var statearr_37147_37328 = state_37068__$1;
(statearr_37147_37328[(1)] = (92));

} else {
var statearr_37148_37329 = state_37068__$1;
(statearr_37148_37329[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (109))){
var inst_37027 = (state_37068[(82)]);
var state_37068__$1 = state_37068;
var statearr_37149_37330 = state_37068__$1;
(statearr_37149_37330[(2)] = inst_37027);

(statearr_37149_37330[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (36))){
var inst_36813 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
if(cljs.core.truth_(inst_36813)){
var statearr_37150_37331 = state_37068__$1;
(statearr_37150_37331[(1)] = (37));

} else {
var statearr_37151_37332 = state_37068__$1;
(statearr_37151_37332[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (41))){
var inst_36818 = (state_37068[(63)]);
var state_37068__$1 = state_37068;
var statearr_37152_37333 = state_37068__$1;
(statearr_37152_37333[(2)] = inst_36818);

(statearr_37152_37333[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (118))){
var inst_37048 = (state_37068[(73)]);
var state_37068__$1 = state_37068;
var statearr_37153_37334 = state_37068__$1;
(statearr_37153_37334[(2)] = inst_37048);

(statearr_37153_37334[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (89))){
var inst_36849 = (state_37068[(21)]);
var inst_36889 = (state_37068[(24)]);
var inst_36888 = (state_37068[(35)]);
var inst_36921 = (state_37068[(81)]);
var inst_36887 = (state_37068[(47)]);
var inst_36933 = cljs.core.count(inst_36921);
var inst_36934 = (inst_36849 - inst_36887);
var inst_36935 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_36934,inst_36921);
var inst_36936 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36889,inst_36935);
var inst_36937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36938 = (inst_36887 + inst_36933);
var inst_36939 = [(0),inst_36938,inst_36888,inst_36936];
var inst_36940 = (new cljs.core.PersistentVector(null,4,(5),inst_36937,inst_36939,null));
var state_37068__$1 = state_37068;
var statearr_37154_37335 = state_37068__$1;
(statearr_37154_37335[(2)] = inst_36940);

(statearr_37154_37335[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (100))){
var inst_36849 = (state_37068[(21)]);
var inst_36982 = (state_37068[(52)]);
var inst_36981 = (state_37068[(53)]);
var inst_36887 = (state_37068[(47)]);
var inst_36983 = (state_37068[(54)]);
var inst_36955 = (state_37068[(70)]);
var inst_36977 = (state_37068[(2)]);
var inst_36978 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36977,(0),null);
var inst_36979 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36977,(1),null);
var inst_36980 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_36979,inst_36955);
var inst_36981__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_36980);
var inst_36982__$1 = cljs.core.count(inst_36981__$1);
var inst_36983__$1 = (inst_36887 + inst_36982__$1);
var inst_36984 = (inst_36983__$1 > inst_36849);
var state_37068__$1 = (function (){var statearr_37155 = state_37068;
(statearr_37155[(83)] = inst_36978);

(statearr_37155[(52)] = inst_36982__$1);

(statearr_37155[(53)] = inst_36981__$1);

(statearr_37155[(54)] = inst_36983__$1);

return statearr_37155;
})();
if(cljs.core.truth_(inst_36984)){
var statearr_37156_37336 = state_37068__$1;
(statearr_37156_37336[(1)] = (101));

} else {
var statearr_37157_37337 = state_37068__$1;
(statearr_37157_37337[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (122))){
var inst_37023 = (state_37068[(76)]);
var inst_37021 = (state_37068[(77)]);
var inst_37022 = (state_37068[(78)]);
var inst_37024 = (state_37068[(7)]);
var inst_37048 = (state_37068[(73)]);
var inst_36885 = inst_37048;
var inst_36886 = inst_37021;
var inst_36887 = inst_37022;
var inst_36888 = inst_37023;
var inst_36889 = inst_37024;
var state_37068__$1 = (function (){var statearr_37158 = state_37068;
(statearr_37158[(23)] = inst_36886);

(statearr_37158[(24)] = inst_36889);

(statearr_37158[(25)] = inst_36885);

(statearr_37158[(35)] = inst_36888);

(statearr_37158[(47)] = inst_36887);

return statearr_37158;
})();
var statearr_37159_37338 = state_37068__$1;
(statearr_37159_37338[(2)] = null);

(statearr_37159_37338[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (43))){
var state_37068__$1 = state_37068;
var statearr_37160_37339 = state_37068__$1;
(statearr_37160_37339[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_37160_37339[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (61))){
var inst_36867 = (state_37068[(12)]);
var inst_36866 = (state_37068[(15)]);
var inst_36872 = (state_37068[(22)]);
var inst_36845 = (state_37068[(30)]);
var inst_36862 = (state_37068[(42)]);
var inst_36871 = (state_37068[(2)]);
var inst_36872__$1 = fluree.db.util.async.throw_err(inst_36871);
var inst_36873 = fluree.db.query.range.find_next_valid_node(inst_36872__$1,inst_36845,inst_36862,inst_36866,inst_36867);
var state_37068__$1 = (function (){var statearr_37161 = state_37068;
(statearr_37161[(22)] = inst_36872__$1);

return statearr_37161;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(62),inst_36873);
} else {
if((state_val_37069 === (29))){
var inst_36795 = (state_37068[(2)]);
var inst_36796 = fluree.db.util.async.throw_err(inst_36795);
var state_37068__$1 = state_37068;
var statearr_37162_37340 = state_37068__$1;
(statearr_37162_37340[(2)] = inst_36796);

(statearr_37162_37340[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (44))){
var inst_36727 = (state_37068[(56)]);
var state_37068__$1 = state_37068;
var statearr_37163_37341 = state_37068__$1;
(statearr_37163_37341[(2)] = inst_36727);

(statearr_37163_37341[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (93))){
var inst_36943 = (state_37068[(80)]);
var inst_36886 = (state_37068[(23)]);
var inst_36882 = (state_37068[(9)]);
var inst_36955 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_36886,inst_36943);
var state_37068__$1 = (function (){var statearr_37164 = state_37068;
(statearr_37164[(70)] = inst_36955);

return statearr_37164;
})();
if(cljs.core.truth_(inst_36882)){
var statearr_37165_37342 = state_37068__$1;
(statearr_37165_37342[(1)] = (95));

} else {
var statearr_37166_37343 = state_37068__$1;
(statearr_37166_37343[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (6))){
var inst_36719 = (state_37068[(49)]);
var inst_36739 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_36719);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(9),inst_36739);
} else {
if((state_val_37069 === (111))){
var inst_37023 = (state_37068[(76)]);
var inst_36855 = (state_37068[(14)]);
var inst_37031 = (inst_37023 < inst_36855);
var state_37068__$1 = state_37068;
var statearr_37167_37344 = state_37068__$1;
(statearr_37167_37344[(2)] = inst_37031);

(statearr_37167_37344[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (28))){
var inst_36789 = (state_37068[(74)]);
var inst_36799 = (state_37068[(2)]);
var inst_36800 = fluree.db.util.core.pred_ident_QMARK_(inst_36789);
var state_37068__$1 = (function (){var statearr_37168 = state_37068;
(statearr_37168[(26)] = inst_36799);

return statearr_37168;
})();
if(inst_36800){
var statearr_37169_37345 = state_37068__$1;
(statearr_37169_37345[(1)] = (30));

} else {
var statearr_37170_37346 = state_37068__$1;
(statearr_37170_37346[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (64))){
var state_37068__$1 = state_37068;
var statearr_37171_37347 = state_37068__$1;
(statearr_37171_37347[(2)] = true);

(statearr_37171_37347[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (103))){
var inst_36978 = (state_37068[(83)]);
var inst_36997 = (state_37068[(2)]);
var inst_36998 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36997,(0),null);
var inst_36999 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36997,(1),null);
var inst_37000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37001 = [inst_36998,inst_36978,inst_36999];
var inst_37002 = (new cljs.core.PersistentVector(null,3,(5),inst_37000,inst_37001,null));
var state_37068__$1 = state_37068;
var statearr_37172_37348 = state_37068__$1;
(statearr_37172_37348[(2)] = inst_37002);

(statearr_37172_37348[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (51))){
var inst_36833 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37173_37349 = state_37068__$1;
(statearr_37173_37349[(2)] = inst_36833);

(statearr_37173_37349[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (25))){
var inst_36786 = (state_37068[(13)]);
var inst_36788 = (state_37068[(51)]);
var inst_36787 = (state_37068[(46)]);
var inst_36786__$1 = (state_37068[(2)]);
var inst_36787__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36786__$1,(0),null);
var inst_36788__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36787__$1,(0),null);
var inst_36789 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36787__$1,(1),null);
var inst_36790 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36786__$1,(1),null);
var inst_36791 = fluree.db.util.core.pred_ident_QMARK_(inst_36788__$1);
var state_37068__$1 = (function (){var statearr_37174 = state_37068;
(statearr_37174[(74)] = inst_36789);

(statearr_37174[(13)] = inst_36786__$1);

(statearr_37174[(34)] = inst_36790);

(statearr_37174[(51)] = inst_36788__$1);

(statearr_37174[(46)] = inst_36787__$1);

return statearr_37174;
})();
if(inst_36791){
var statearr_37175_37350 = state_37068__$1;
(statearr_37175_37350[(1)] = (26));

} else {
var statearr_37176_37351 = state_37068__$1;
(statearr_37176_37351[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (34))){
var inst_36799 = (state_37068[(26)]);
var state_37068__$1 = state_37068;
var statearr_37177_37352 = state_37068__$1;
(statearr_37177_37352[(2)] = inst_36799);

(statearr_37177_37352[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (17))){
var inst_36728 = (state_37068[(61)]);
var state_37068__$1 = state_37068;
var statearr_37178_37353 = state_37068__$1;
(statearr_37178_37353[(2)] = inst_36728);

(statearr_37178_37353[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (3))){
var inst_37066 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37068__$1,inst_37066);
} else {
if((state_val_37069 === (12))){
var inst_36721 = (state_37068[(58)]);
var inst_36754 = (state_37068[(2)]);
var inst_36755 = cljs.core.boolean_QMARK_(inst_36721);
var state_37068__$1 = (function (){var statearr_37179 = state_37068;
(statearr_37179[(17)] = inst_36754);

return statearr_37179;
})();
if(inst_36755){
var statearr_37180_37354 = state_37068__$1;
(statearr_37180_37354[(1)] = (14));

} else {
var statearr_37181_37355 = state_37068__$1;
(statearr_37181_37355[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (2))){
var inst_36725 = (state_37068[(18)]);
var inst_36718 = (state_37068[(36)]);
var inst_36719 = (state_37068[(49)]);
var inst_36733 = (state_37068[(48)]);
var _ = (function (){var statearr_37182 = state_37068;
(statearr_37182[(4)] = cljs.core.cons((5),(state_37068[(4)])));

return statearr_37182;
})();
var inst_36718__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_36719__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36718__$1,(0),null);
var inst_36720 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36718__$1,(1),null);
var inst_36721 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36718__$1,(2),null);
var inst_36722 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36718__$1,(3),null);
var inst_36723 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36718__$1,(4),null);
var inst_36724 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36718__$1,(5),null);
var inst_36725__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_36726 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36725__$1,(0),null);
var inst_36727 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36725__$1,(1),null);
var inst_36728 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36725__$1,(2),null);
var inst_36729 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36725__$1,(3),null);
var inst_36730 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36725__$1,(4),null);
var inst_36731 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36725__$1,(5),null);
var inst_36732 = opts;
var inst_36733__$1 = cljs.core.__destructure_map(inst_36732);
var inst_36734 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36733__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_36735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36733__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_36736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36733__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_36737 = fluree.db.util.core.pred_ident_QMARK_(inst_36719__$1);
var state_37068__$1 = (function (){var statearr_37183 = state_37068;
(statearr_37183[(11)] = inst_36730);

(statearr_37183[(55)] = inst_36720);

(statearr_37183[(56)] = inst_36727);

(statearr_37183[(57)] = inst_36736);

(statearr_37183[(18)] = inst_36725__$1);

(statearr_37183[(19)] = inst_36722);

(statearr_37183[(20)] = inst_36729);

(statearr_37183[(58)] = inst_36721);

(statearr_37183[(84)] = inst_36726);

(statearr_37183[(60)] = inst_36731);

(statearr_37183[(33)] = inst_36734);

(statearr_37183[(36)] = inst_36718__$1);

(statearr_37183[(38)] = inst_36723);

(statearr_37183[(40)] = inst_36735);

(statearr_37183[(61)] = inst_36728);

(statearr_37183[(49)] = inst_36719__$1);

(statearr_37183[(62)] = inst_36724);

(statearr_37183[(48)] = inst_36733__$1);

return statearr_37183;
})();
if(inst_36737){
var statearr_37184_37356 = state_37068__$1;
(statearr_37184_37356[(1)] = (6));

} else {
var statearr_37185_37357 = state_37068__$1;
(statearr_37185_37357[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (66))){
var inst_36876 = (state_37068[(8)]);
var inst_36851 = (state_37068[(71)]);
var inst_36884 = cljs.core.PersistentVector.EMPTY;
var inst_36885 = inst_36876;
var inst_36886 = inst_36851;
var inst_36887 = (0);
var inst_36888 = (0);
var inst_36889 = inst_36884;
var state_37068__$1 = (function (){var statearr_37186 = state_37068;
(statearr_37186[(23)] = inst_36886);

(statearr_37186[(24)] = inst_36889);

(statearr_37186[(25)] = inst_36885);

(statearr_37186[(35)] = inst_36888);

(statearr_37186[(47)] = inst_36887);

return statearr_37186;
})();
var statearr_37187_37358 = state_37068__$1;
(statearr_37187_37358[(2)] = null);

(statearr_37187_37358[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (107))){
var inst_37040 = (state_37068[(66)]);
var inst_37040__$1 = (state_37068[(2)]);
var state_37068__$1 = (function (){var statearr_37188 = state_37068;
(statearr_37188[(66)] = inst_37040__$1);

return statearr_37188;
})();
if(cljs.core.truth_(inst_37040__$1)){
var statearr_37189_37359 = state_37068__$1;
(statearr_37189_37359[(1)] = (114));

} else {
var statearr_37190_37360 = state_37068__$1;
(statearr_37190_37360[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (23))){
var inst_36736 = (state_37068[(57)]);
var inst_36721 = (state_37068[(58)]);
var inst_36728 = (state_37068[(61)]);
var inst_36771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36773 = [inst_36721,inst_36728];
var inst_36774 = (new cljs.core.PersistentVector(null,2,(5),inst_36772,inst_36773,null));
var inst_36775 = [inst_36774,inst_36736];
var inst_36776 = (new cljs.core.PersistentVector(null,2,(5),inst_36771,inst_36775,null));
var state_37068__$1 = state_37068;
var statearr_37191_37361 = state_37068__$1;
(statearr_37191_37361[(2)] = inst_36776);

(statearr_37191_37361[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (47))){
var inst_36829 = (cljs.core._GT__EQ_ === start_test);
var state_37068__$1 = state_37068;
if(cljs.core.truth_(inst_36829)){
var statearr_37192_37362 = state_37068__$1;
(statearr_37192_37362[(1)] = (49));

} else {
var statearr_37193_37363 = state_37068__$1;
(statearr_37193_37363[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (35))){
var inst_36809 = (state_37068[(75)]);
var state_37068__$1 = state_37068;
var statearr_37194_37364 = state_37068__$1;
(statearr_37194_37364[(2)] = inst_36809);

(statearr_37194_37364[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (82))){
var inst_36885 = (state_37068[(25)]);
var inst_36856 = (state_37068[(29)]);
var inst_36921 = (state_37068[(2)]);
var inst_36922 = fluree.db.dbproto._rhs(inst_36885);
var state_37068__$1 = (function (){var statearr_37195 = state_37068;
(statearr_37195[(65)] = inst_36922);

(statearr_37195[(81)] = inst_36921);

return statearr_37195;
})();
if(cljs.core.truth_(inst_36856)){
var statearr_37196_37365 = state_37068__$1;
(statearr_37196_37365[(1)] = (83));

} else {
var statearr_37197_37366 = state_37068__$1;
(statearr_37197_37366[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (76))){
var inst_36735 = (state_37068[(40)]);
var inst_36909 = (state_37068[(2)]);
var state_37068__$1 = (function (){var statearr_37198 = state_37068;
(statearr_37198[(64)] = inst_36909);

return statearr_37198;
})();
if(cljs.core.truth_(inst_36735)){
var statearr_37199_37367 = state_37068__$1;
(statearr_37199_37367[(1)] = (77));

} else {
var statearr_37200_37368 = state_37068__$1;
(statearr_37200_37368[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (97))){
var inst_36889 = (state_37068[(24)]);
var inst_37009 = (state_37068[(2)]);
var inst_37010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37009,(0),null);
var inst_37011 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37009,(1),null);
var inst_37012 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37009,(2),null);
var inst_37013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37014 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36889,inst_37012);
var inst_37015 = [(0),inst_37010,inst_37011,inst_37014];
var inst_37016 = (new cljs.core.PersistentVector(null,4,(5),inst_37013,inst_37015,null));
var state_37068__$1 = state_37068;
var statearr_37201_37369 = state_37068__$1;
(statearr_37201_37369[(2)] = inst_37016);

(statearr_37201_37369[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (19))){
var inst_36766 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37202_37370 = state_37068__$1;
(statearr_37202_37370[(2)] = inst_36766);

(statearr_37202_37370[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (57))){
var inst_36842 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37203_37371 = state_37068__$1;
(statearr_37203_37371[(2)] = inst_36842);

(statearr_37203_37371[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (68))){
var inst_37063 = (state_37068[(2)]);
var _ = (function (){var statearr_37204 = state_37068;
(statearr_37204[(4)] = cljs.core.rest((state_37068[(4)])));

return statearr_37204;
})();
var state_37068__$1 = state_37068;
var statearr_37205_37372 = state_37068__$1;
(statearr_37205_37372[(2)] = inst_37063);

(statearr_37205_37372[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (11))){
var inst_36726 = (state_37068[(84)]);
var state_37068__$1 = state_37068;
var statearr_37206_37373 = state_37068__$1;
(statearr_37206_37373[(2)] = inst_36726);

(statearr_37206_37373[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (115))){
var state_37068__$1 = state_37068;
var statearr_37208_37374 = state_37068__$1;
(statearr_37208_37374[(2)] = null);

(statearr_37208_37374[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (9))){
var inst_36741 = (state_37068[(2)]);
var inst_36742 = fluree.db.util.async.throw_err(inst_36741);
var state_37068__$1 = state_37068;
var statearr_37209_37375 = state_37068__$1;
(statearr_37209_37375[(2)] = inst_36742);

(statearr_37209_37375[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (5))){
var _ = (function (){var statearr_37210 = state_37068;
(statearr_37210[(4)] = cljs.core.rest((state_37068[(4)])));

return statearr_37210;
})();
var state_37068__$1 = state_37068;
var ex37207 = (state_37068__$1[(2)]);
var statearr_37211_37376 = state_37068__$1;
(statearr_37211_37376[(5)] = ex37207);


if((ex37207 instanceof Error)){
var statearr_37212_37377 = state_37068__$1;
(statearr_37212_37377[(1)] = (4));

(statearr_37212_37377[(5)] = null);

} else {
throw ex37207;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (112))){
var inst_37029 = (state_37068[(79)]);
var state_37068__$1 = state_37068;
var statearr_37213_37378 = state_37068__$1;
(statearr_37213_37378[(2)] = inst_37029);

(statearr_37213_37378[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (83))){
var inst_36886 = (state_37068[(23)]);
var inst_36924 = (state_37068[(85)]);
var inst_36924__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_36886);
var state_37068__$1 = (function (){var statearr_37214 = state_37068;
(statearr_37214[(85)] = inst_36924__$1);

return statearr_37214;
})();
if(inst_36924__$1){
var statearr_37215_37379 = state_37068__$1;
(statearr_37215_37379[(1)] = (86));

} else {
var statearr_37216_37380 = state_37068__$1;
(statearr_37216_37380[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (14))){
var inst_36721 = (state_37068[(58)]);
var state_37068__$1 = state_37068;
var statearr_37217_37381 = state_37068__$1;
(statearr_37217_37381[(2)] = inst_36721);

(statearr_37217_37381[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (45))){
var inst_36724 = (state_37068[(62)]);
var inst_36826 = (state_37068[(2)]);
var state_37068__$1 = (function (){var statearr_37218 = state_37068;
(statearr_37218[(37)] = inst_36826);

return statearr_37218;
})();
if(cljs.core.truth_(inst_36724)){
var statearr_37219_37382 = state_37068__$1;
(statearr_37219_37382[(1)] = (46));

} else {
var statearr_37220_37383 = state_37068__$1;
(statearr_37220_37383[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (53))){
var inst_36838 = (cljs.core._LT__EQ_ === end_test);
var state_37068__$1 = state_37068;
if(cljs.core.truth_(inst_36838)){
var statearr_37221_37384 = state_37068__$1;
(statearr_37221_37384[(1)] = (55));

} else {
var statearr_37222_37385 = state_37068__$1;
(statearr_37222_37385[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (78))){
var inst_36909 = (state_37068[(64)]);
var state_37068__$1 = state_37068;
var statearr_37223_37386 = state_37068__$1;
(statearr_37223_37386[(2)] = inst_36909);

(statearr_37223_37386[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (26))){
var inst_36788 = (state_37068[(51)]);
var inst_36793 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_36788);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(29),inst_36793);
} else {
if((state_val_37069 === (123))){
var inst_37058 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37224_37387 = state_37068__$1;
(statearr_37224_37387[(2)] = inst_37058);

(statearr_37224_37387[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (16))){
var inst_36768 = (state_37068[(59)]);
var inst_36768__$1 = (state_37068[(2)]);
var inst_36769 = (inst_36768__$1 == null);
var state_37068__$1 = (function (){var statearr_37225 = state_37068;
(statearr_37225[(59)] = inst_36768__$1);

return statearr_37225;
})();
if(cljs.core.truth_(inst_36769)){
var statearr_37226_37388 = state_37068__$1;
(statearr_37226_37388[(1)] = (23));

} else {
var statearr_37227_37389 = state_37068__$1;
(statearr_37227_37389[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (81))){
var inst_36915 = (state_37068[(86)]);
var state_37068__$1 = state_37068;
var statearr_37228_37390 = state_37068__$1;
(statearr_37228_37390[(2)] = inst_36915);

(statearr_37228_37390[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (120))){
var inst_37052 = (state_37068[(2)]);
var inst_37053 = cljs.core.not(inst_37052);
var state_37068__$1 = state_37068;
if(inst_37053){
var statearr_37229_37391 = state_37068__$1;
(statearr_37229_37391[(1)] = (121));

} else {
var statearr_37230_37392 = state_37068__$1;
(statearr_37230_37392[(1)] = (122));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (79))){
var inst_36790 = (state_37068[(34)]);
var inst_36915 = (state_37068[(2)]);
var state_37068__$1 = (function (){var statearr_37231 = state_37068;
(statearr_37231[(86)] = inst_36915);

return statearr_37231;
})();
if(cljs.core.truth_(inst_36790)){
var statearr_37232_37393 = state_37068__$1;
(statearr_37232_37393[(1)] = (80));

} else {
var statearr_37233_37394 = state_37068__$1;
(statearr_37233_37394[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (38))){
var inst_36720 = (state_37068[(55)]);
var state_37068__$1 = state_37068;
var statearr_37234_37395 = state_37068__$1;
(statearr_37234_37395[(2)] = inst_36720);

(statearr_37234_37395[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (98))){
var inst_36855 = (state_37068[(14)]);
var inst_36965 = (state_37068[(68)]);
var inst_36963 = (state_37068[(69)]);
var inst_36968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36969 = (inst_36963 - inst_36965);
var inst_36970 = [inst_36855,inst_36969];
var inst_36971 = (new cljs.core.PersistentVector(null,2,(5),inst_36968,inst_36970,null));
var state_37068__$1 = state_37068;
var statearr_37235_37396 = state_37068__$1;
(statearr_37235_37396[(2)] = inst_36971);

(statearr_37235_37396[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (87))){
var inst_36924 = (state_37068[(85)]);
var state_37068__$1 = state_37068;
var statearr_37236_37397 = state_37068__$1;
(statearr_37236_37397[(2)] = inst_36924);

(statearr_37236_37397[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (30))){
var inst_36789 = (state_37068[(74)]);
var inst_36802 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_36789);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(33),inst_36802);
} else {
if((state_val_37069 === (73))){
var inst_36734 = (state_37068[(33)]);
var inst_36903 = (state_37068[(2)]);
var state_37068__$1 = (function (){var statearr_37237 = state_37068;
(statearr_37237[(44)] = inst_36903);

return statearr_37237;
})();
if(cljs.core.truth_(inst_36734)){
var statearr_37238_37398 = state_37068__$1;
(statearr_37238_37398[(1)] = (74));

} else {
var statearr_37239_37399 = state_37068__$1;
(statearr_37239_37399[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (96))){
var inst_36855 = (state_37068[(14)]);
var inst_36849 = (state_37068[(21)]);
var inst_36888 = (state_37068[(35)]);
var inst_36887 = (state_37068[(47)]);
var inst_36955 = (state_37068[(70)]);
var inst_37004 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_36955,inst_36887,inst_36888,inst_36849,inst_36855);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(104),inst_37004);
} else {
if((state_val_37069 === (10))){
var inst_36726 = (state_37068[(84)]);
var inst_36748 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_36726);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(13),inst_36748);
} else {
if((state_val_37069 === (18))){
var state_37068__$1 = state_37068;
var statearr_37240_37400 = state_37068__$1;
(statearr_37240_37400[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (105))){
var inst_36861 = (state_37068[(27)]);
var inst_37027 = (state_37068[(82)]);
var inst_36846 = (state_37068[(32)]);
var inst_36922 = (state_37068[(65)]);
var inst_37026 = (inst_36861.cljs$core$IFn$_invoke$arity$2 ? inst_36861.cljs$core$IFn$_invoke$arity$2(inst_36922,inst_36846) : inst_36861.call(null,inst_36922,inst_36846));
var inst_37027__$1 = (inst_37026 < (0));
var state_37068__$1 = (function (){var statearr_37242 = state_37068;
(statearr_37242[(82)] = inst_37027__$1);

return statearr_37242;
})();
if(cljs.core.truth_(inst_37027__$1)){
var statearr_37243_37401 = state_37068__$1;
(statearr_37243_37401[(1)] = (108));

} else {
var statearr_37244_37402 = state_37068__$1;
(statearr_37244_37402[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (52))){
var inst_36731 = (state_37068[(60)]);
var state_37068__$1 = state_37068;
var statearr_37245_37403 = state_37068__$1;
(statearr_37245_37403[(2)] = inst_36731);

(statearr_37245_37403[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (114))){
var inst_36867 = (state_37068[(12)]);
var inst_36866 = (state_37068[(15)]);
var inst_36872 = (state_37068[(22)]);
var inst_36922 = (state_37068[(65)]);
var inst_36862 = (state_37068[(42)]);
var inst_37042 = fluree.db.query.range.find_next_valid_node(inst_36872,inst_36922,inst_36862,inst_36866,inst_36867);
var state_37068__$1 = state_37068;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37068__$1,(117),inst_37042);
} else {
if((state_val_37069 === (67))){
var state_37068__$1 = state_37068;
var statearr_37246_37404 = state_37068__$1;
(statearr_37246_37404[(2)] = null);

(statearr_37246_37404[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (71))){
var inst_36745 = (state_37068[(10)]);
var inst_36730 = (state_37068[(11)]);
var inst_36867 = (state_37068[(12)]);
var inst_36786 = (state_37068[(13)]);
var inst_36855 = (state_37068[(14)]);
var inst_36866 = (state_37068[(15)]);
var inst_36895 = (state_37068[(16)]);
var inst_36754 = (state_37068[(17)]);
var inst_36725 = (state_37068[(18)]);
var inst_36722 = (state_37068[(19)]);
var inst_36729 = (state_37068[(20)]);
var inst_36849 = (state_37068[(21)]);
var inst_36872 = (state_37068[(22)]);
var inst_36886 = (state_37068[(23)]);
var inst_36889 = (state_37068[(24)]);
var inst_36885 = (state_37068[(25)]);
var inst_36799 = (state_37068[(26)]);
var inst_36861 = (state_37068[(27)]);
var inst_36876 = (state_37068[(8)]);
var inst_36835 = (state_37068[(28)]);
var inst_36856 = (state_37068[(29)]);
var inst_36845 = (state_37068[(30)]);
var inst_36848 = (state_37068[(31)]);
var inst_36846 = (state_37068[(32)]);
var inst_36734 = (state_37068[(33)]);
var inst_36790 = (state_37068[(34)]);
var inst_36888 = (state_37068[(35)]);
var inst_36718 = (state_37068[(36)]);
var inst_36826 = (state_37068[(37)]);
var inst_36723 = (state_37068[(38)]);
var inst_36808 = (state_37068[(39)]);
var inst_36735 = (state_37068[(40)]);
var inst_36844 = (state_37068[(41)]);
var inst_36862 = (state_37068[(42)]);
var inst_36882 = (state_37068[(9)]);
var inst_36857 = (state_37068[(43)]);
var inst_36817 = (state_37068[(45)]);
var inst_36787 = (state_37068[(46)]);
var inst_36887 = (state_37068[(47)]);
var inst_36733 = (state_37068[(48)]);
var inst_36899 = (function (){var no_filter_QMARK_ = inst_36882;
var t = inst_36862;
var max_limit_QMARK_ = inst_36856;
var next_node = inst_36885;
var fast_forward_db_QMARK_ = inst_36867;
var s1 = inst_36745;
var o2 = inst_36808;
var t1 = inst_36722;
var predicate_fn = inst_36735;
var i = inst_36887;
var map__36710 = inst_36733;
var m1 = inst_36835;
var root_node = inst_36872;
var s2 = inst_36754;
var vec__36704 = inst_36718;
var G__36896 = inst_36895;
var p2 = inst_36826;
var permissions = inst_36857;
var vec__36714 = inst_36787;
var limit = inst_36855;
var start_flake = inst_36845;
var vec__36711 = inst_36786;
var map__36717 = inst_36848;
var flake_limit = inst_36849;
var offset = inst_36886;
var acc = inst_36889;
var vec__36707 = inst_36725;
var t2 = inst_36729;
var op1 = inst_36723;
var o1 = inst_36799;
var end_flake = inst_36846;
var base_result = inst_36895;
var s = inst_36888;
var node_start = inst_36876;
var p1 = inst_36817;
var subject_fn = inst_36734;
var object_fn = inst_36790;
var idx_compare = inst_36861;
var op2 = inst_36730;
var m2 = inst_36844;
var novelty = inst_36866;
return (function (p1__36685_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__36685_SHARP_.o,start_flake.o);
});
})();
var inst_36900 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_36899,inst_36895);
var state_37068__$1 = state_37068;
var statearr_37247_37405 = state_37068__$1;
(statearr_37247_37405[(2)] = inst_36900);

(statearr_37247_37405[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (42))){
var inst_36822 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
if(cljs.core.truth_(inst_36822)){
var statearr_37248_37406 = state_37068__$1;
(statearr_37248_37406[(1)] = (43));

} else {
var statearr_37249_37407 = state_37068__$1;
(statearr_37249_37407[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (80))){
var inst_36745 = (state_37068[(10)]);
var inst_36730 = (state_37068[(11)]);
var inst_36867 = (state_37068[(12)]);
var inst_36786 = (state_37068[(13)]);
var inst_36855 = (state_37068[(14)]);
var inst_36866 = (state_37068[(15)]);
var inst_36895 = (state_37068[(16)]);
var inst_36754 = (state_37068[(17)]);
var inst_36725 = (state_37068[(18)]);
var inst_36722 = (state_37068[(19)]);
var inst_36729 = (state_37068[(20)]);
var inst_36849 = (state_37068[(21)]);
var inst_36872 = (state_37068[(22)]);
var inst_36886 = (state_37068[(23)]);
var inst_36889 = (state_37068[(24)]);
var inst_36885 = (state_37068[(25)]);
var inst_36799 = (state_37068[(26)]);
var inst_36861 = (state_37068[(27)]);
var inst_36876 = (state_37068[(8)]);
var inst_36835 = (state_37068[(28)]);
var inst_36856 = (state_37068[(29)]);
var inst_36845 = (state_37068[(30)]);
var inst_36848 = (state_37068[(31)]);
var inst_36846 = (state_37068[(32)]);
var inst_36915 = (state_37068[(86)]);
var inst_36734 = (state_37068[(33)]);
var inst_36790 = (state_37068[(34)]);
var inst_36888 = (state_37068[(35)]);
var inst_36718 = (state_37068[(36)]);
var inst_36826 = (state_37068[(37)]);
var inst_36723 = (state_37068[(38)]);
var inst_36808 = (state_37068[(39)]);
var inst_36735 = (state_37068[(40)]);
var inst_36844 = (state_37068[(41)]);
var inst_36862 = (state_37068[(42)]);
var inst_36882 = (state_37068[(9)]);
var inst_36857 = (state_37068[(43)]);
var inst_36817 = (state_37068[(45)]);
var inst_36787 = (state_37068[(46)]);
var inst_36887 = (state_37068[(47)]);
var inst_36733 = (state_37068[(48)]);
var inst_36917 = (function (){var no_filter_QMARK_ = inst_36882;
var t = inst_36862;
var max_limit_QMARK_ = inst_36856;
var next_node = inst_36885;
var fast_forward_db_QMARK_ = inst_36867;
var s1 = inst_36745;
var o2 = inst_36808;
var t1 = inst_36722;
var predicate_fn = inst_36735;
var i = inst_36887;
var map__36710 = inst_36733;
var m1 = inst_36835;
var root_node = inst_36872;
var s2 = inst_36754;
var vec__36704 = inst_36718;
var G__36896 = inst_36915;
var p2 = inst_36826;
var permissions = inst_36857;
var vec__36714 = inst_36787;
var limit = inst_36855;
var start_flake = inst_36845;
var vec__36711 = inst_36786;
var map__36717 = inst_36848;
var flake_limit = inst_36849;
var offset = inst_36886;
var acc = inst_36889;
var vec__36707 = inst_36725;
var t2 = inst_36729;
var op1 = inst_36723;
var o1 = inst_36799;
var end_flake = inst_36846;
var base_result = inst_36895;
var s = inst_36888;
var node_start = inst_36876;
var p1 = inst_36817;
var subject_fn = inst_36734;
var object_fn = inst_36790;
var idx_compare = inst_36861;
var op2 = inst_36730;
var m2 = inst_36844;
var novelty = inst_36866;
return (function (p1__36688_SHARP_){
var G__37250 = p1__36688_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__37250) : object_fn.call(null,G__37250));
});
})();
var inst_36918 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_36917,inst_36915);
var state_37068__$1 = state_37068;
var statearr_37251_37408 = state_37068__$1;
(statearr_37251_37408[(2)] = inst_36918);

(statearr_37251_37408[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (37))){
var state_37068__$1 = state_37068;
var statearr_37252_37409 = state_37068__$1;
(statearr_37252_37409[(2)] = (-1));

(statearr_37252_37409[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (63))){
var inst_36745 = (state_37068[(10)]);
var inst_36754 = (state_37068[(17)]);
var inst_36826 = (state_37068[(37)]);
var inst_36857 = (state_37068[(43)]);
var inst_36817 = (state_37068[(45)]);
var inst_36879 = fluree.db.permissions_validate.no_filter_QMARK_(inst_36857,inst_36745,inst_36754,inst_36817,inst_36826);
var state_37068__$1 = state_37068;
var statearr_37253_37410 = state_37068__$1;
(statearr_37253_37410[(2)] = inst_36879);

(statearr_37253_37410[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (94))){
var inst_37018 = (state_37068[(2)]);
var state_37068__$1 = state_37068;
var statearr_37254_37411 = state_37068__$1;
(statearr_37254_37411[(2)] = inst_37018);

(statearr_37254_37411[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (8))){
var inst_36726 = (state_37068[(84)]);
var inst_36745 = (state_37068[(2)]);
var inst_36746 = fluree.db.util.core.pred_ident_QMARK_(inst_36726);
var state_37068__$1 = (function (){var statearr_37255 = state_37068;
(statearr_37255[(10)] = inst_36745);

return statearr_37255;
})();
if(inst_36746){
var statearr_37256_37412 = state_37068__$1;
(statearr_37256_37412[(1)] = (10));

} else {
var statearr_37257_37413 = state_37068__$1;
(statearr_37257_37413[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (49))){
var state_37068__$1 = state_37068;
var statearr_37258_37414 = state_37068__$1;
(statearr_37258_37414[(2)] = fluree.db.util.core.min_integer);

(statearr_37258_37414[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37069 === (84))){
var inst_36856 = (state_37068[(29)]);
var state_37068__$1 = state_37068;
var statearr_37259_37415 = state_37068__$1;
(statearr_37259_37415[(2)] = inst_36856);

(statearr_37259_37415[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__20477__auto__ = null;
var fluree$db$query$range$state_machine__20477__auto____0 = (function (){
var statearr_37260 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37260[(0)] = fluree$db$query$range$state_machine__20477__auto__);

(statearr_37260[(1)] = (1));

return statearr_37260;
});
var fluree$db$query$range$state_machine__20477__auto____1 = (function (state_37068){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_37068);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e37261){var ex__20480__auto__ = e37261;
var statearr_37262_37416 = state_37068;
(statearr_37262_37416[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_37068[(4)]))){
var statearr_37263_37417 = state_37068;
(statearr_37263_37417[(1)] = cljs.core.first((state_37068[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__37418 = state_37068;
state_37068 = G__37418;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__20477__auto__ = function(state_37068){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__20477__auto____1.call(this,state_37068);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__20477__auto____0;
fluree$db$query$range$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__20477__auto____1;
return fluree$db$query$range$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_37264 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_37264[(6)] = c__20603__auto__);

return statearr_37264;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_37474){
var state_val_37475 = (state_37474[(1)]);
if((state_val_37475 === (7))){
var inst_37448 = (state_37474[(7)]);
var inst_37438 = (state_37474[(8)]);
var inst_37446 = fluree.db.flake.Flake__GT_parts(inst_37438);
var inst_37447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37446,(0),null);
var inst_37448__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37446,(1),null);
var inst_37449 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37446,(2),null);
var inst_37450 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37446,(3),null);
var inst_37451 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37446,(4),null);
var inst_37452 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37446,(5),null);
var inst_37453 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_37449,inst_37448__$1);
var state_37474__$1 = (function (){var statearr_37476 = state_37474;
(statearr_37476[(9)] = inst_37450);

(statearr_37476[(10)] = inst_37447);

(statearr_37476[(11)] = inst_37451);

(statearr_37476[(12)] = inst_37452);

(statearr_37476[(7)] = inst_37448__$1);

return statearr_37476;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37474__$1,(10),inst_37453);
} else {
if((state_val_37475 === (1))){
var inst_37426 = flakes;
var inst_37427 = cljs.core.seq(inst_37426);
var inst_37428 = cljs.core.first(inst_37427);
var inst_37429 = cljs.core.next(inst_37427);
var inst_37430 = cljs.core.PersistentVector.EMPTY;
var inst_37431 = inst_37426;
var inst_37432 = inst_37430;
var state_37474__$1 = (function (){var statearr_37477 = state_37474;
(statearr_37477[(13)] = inst_37431);

(statearr_37477[(14)] = inst_37428);

(statearr_37477[(15)] = inst_37429);

(statearr_37477[(16)] = inst_37432);

return statearr_37477;
})();
var statearr_37478_37496 = state_37474__$1;
(statearr_37478_37496[(2)] = null);

(statearr_37478_37496[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37475 === (4))){
var inst_37438 = (state_37474[(8)]);
var inst_37441 = fluree.db.query.range.is_tag_flake_QMARK_(inst_37438);
var state_37474__$1 = state_37474;
if(inst_37441){
var statearr_37479_37497 = state_37474__$1;
(statearr_37479_37497[(1)] = (7));

} else {
var statearr_37480_37498 = state_37474__$1;
(statearr_37480_37498[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37475 === (6))){
var inst_37470 = (state_37474[(2)]);
var state_37474__$1 = state_37474;
var statearr_37481_37499 = state_37474__$1;
(statearr_37481_37499[(2)] = inst_37470);

(statearr_37481_37499[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37475 === (3))){
var inst_37472 = (state_37474[(2)]);
var state_37474__$1 = state_37474;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37474__$1,inst_37472);
} else {
if((state_val_37475 === (2))){
var inst_37431 = (state_37474[(13)]);
var inst_37438 = (state_37474[(8)]);
var inst_37437 = cljs.core.seq(inst_37431);
var inst_37438__$1 = cljs.core.first(inst_37437);
var inst_37439 = cljs.core.next(inst_37437);
var state_37474__$1 = (function (){var statearr_37482 = state_37474;
(statearr_37482[(17)] = inst_37439);

(statearr_37482[(8)] = inst_37438__$1);

return statearr_37482;
})();
if(cljs.core.truth_(inst_37438__$1)){
var statearr_37483_37500 = state_37474__$1;
(statearr_37483_37500[(1)] = (4));

} else {
var statearr_37484_37501 = state_37474__$1;
(statearr_37484_37501[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37475 === (9))){
var inst_37467 = (state_37474[(2)]);
var state_37474__$1 = state_37474;
var statearr_37485_37502 = state_37474__$1;
(statearr_37485_37502[(2)] = inst_37467);

(statearr_37485_37502[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37475 === (5))){
var inst_37432 = (state_37474[(16)]);
var state_37474__$1 = state_37474;
var statearr_37486_37503 = state_37474__$1;
(statearr_37486_37503[(2)] = inst_37432);

(statearr_37486_37503[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37475 === (10))){
var inst_37450 = (state_37474[(9)]);
var inst_37447 = (state_37474[(10)]);
var inst_37439 = (state_37474[(17)]);
var inst_37451 = (state_37474[(11)]);
var inst_37452 = (state_37474[(12)]);
var inst_37448 = (state_37474[(7)]);
var inst_37432 = (state_37474[(16)]);
var inst_37455 = (state_37474[(2)]);
var inst_37456 = fluree.db.util.async.throw_err(inst_37455);
var inst_37457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37458 = [inst_37447,inst_37448,inst_37456,inst_37450,inst_37451,inst_37452];
var inst_37459 = (new cljs.core.PersistentVector(null,6,(5),inst_37457,inst_37458,null));
var inst_37460 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_37459);
var inst_37461 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37432,inst_37460);
var inst_37431 = inst_37439;
var inst_37432__$1 = inst_37461;
var state_37474__$1 = (function (){var statearr_37487 = state_37474;
(statearr_37487[(13)] = inst_37431);

(statearr_37487[(16)] = inst_37432__$1);

return statearr_37487;
})();
var statearr_37488_37504 = state_37474__$1;
(statearr_37488_37504[(2)] = null);

(statearr_37488_37504[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37475 === (8))){
var inst_37439 = (state_37474[(17)]);
var inst_37438 = (state_37474[(8)]);
var inst_37432 = (state_37474[(16)]);
var inst_37464 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37432,inst_37438);
var inst_37431 = inst_37439;
var inst_37432__$1 = inst_37464;
var state_37474__$1 = (function (){var statearr_37489 = state_37474;
(statearr_37489[(13)] = inst_37431);

(statearr_37489[(16)] = inst_37432__$1);

return statearr_37489;
})();
var statearr_37490_37505 = state_37474__$1;
(statearr_37490_37505[(2)] = null);

(statearr_37490_37505[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__20477__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__20477__auto____0 = (function (){
var statearr_37491 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37491[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__20477__auto__);

(statearr_37491[(1)] = (1));

return statearr_37491;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__20477__auto____1 = (function (state_37474){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_37474);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e37492){var ex__20480__auto__ = e37492;
var statearr_37493_37506 = state_37474;
(statearr_37493_37506[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_37474[(4)]))){
var statearr_37494_37507 = state_37474;
(statearr_37494_37507[(1)] = cljs.core.first((state_37474[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__37508 = state_37474;
state_37474 = G__37508;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__20477__auto__ = function(state_37474){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__20477__auto____1.call(this,state_37474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__20477__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__20477__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_37495 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_37495[(6)] = c__20603__auto__);

return statearr_37495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__37510 = arguments.length;
switch (G__37510) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_37680){
var state_val_37681 = (state_37680[(1)]);
if((state_val_37681 === (65))){
var state_37680__$1 = state_37680;
var statearr_37682_37782 = state_37680__$1;
(statearr_37682_37782[(2)] = null);

(statearr_37682_37782[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (70))){
var inst_37675 = (state_37680[(2)]);
var _ = (function (){var statearr_37683 = state_37680;
(statearr_37683[(4)] = cljs.core.rest((state_37680[(4)])));

return statearr_37683;
})();
var state_37680__$1 = state_37680;
var statearr_37684_37783 = state_37680__$1;
(statearr_37684_37783[(2)] = inst_37675);

(statearr_37684_37783[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (62))){
var inst_37661 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
var statearr_37685_37784 = state_37680__$1;
(statearr_37685_37784[(2)] = inst_37661);

(statearr_37685_37784[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (7))){
var state_37680__$1 = state_37680;
var statearr_37686_37785 = state_37680__$1;
(statearr_37686_37785[(2)] = false);

(statearr_37686_37785[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (59))){
var inst_37635 = (state_37680[(2)]);
var inst_37636 = fluree.db.util.async.throw_err(inst_37635);
var state_37680__$1 = state_37680;
var statearr_37687_37786 = state_37680__$1;
(statearr_37687_37786[(2)] = inst_37636);

(statearr_37687_37786[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (20))){
var state_37680__$1 = state_37680;
var statearr_37688_37787 = state_37680__$1;
(statearr_37688_37787[(2)] = null);

(statearr_37688_37787[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (58))){
var inst_37625 = (state_37680[(2)]);
var inst_37626 = fluree.db.util.async.throw_err(inst_37625);
var inst_37627 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_37626);
var state_37680__$1 = state_37680;
var statearr_37689_37788 = state_37680__$1;
(statearr_37689_37788[(2)] = inst_37627);

(statearr_37689_37788[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (60))){
var inst_37522 = (state_37680[(7)]);
var inst_37524 = (state_37680[(8)]);
var inst_37561 = (state_37680[(9)]);
var inst_37521 = (state_37680[(10)]);
var inst_37641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37642 = [inst_37522,inst_37521,inst_37561,inst_37524];
var inst_37643 = (new cljs.core.PersistentVector(null,4,(5),inst_37641,inst_37642,null));
var inst_37644 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_37643,opts);
var state_37680__$1 = state_37680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37680__$1,(63),inst_37644);
} else {
if((state_val_37681 === (27))){
var inst_37561 = (state_37680[(9)]);
var inst_37572 = (state_37680[(11)]);
var inst_37572__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_37561);
var state_37680__$1 = (function (){var statearr_37690 = state_37680;
(statearr_37690[(11)] = inst_37572__$1);

return statearr_37690;
})();
if(inst_37572__$1){
var statearr_37691_37789 = state_37680__$1;
(statearr_37691_37789[(1)] = (30));

} else {
var statearr_37692_37790 = state_37680__$1;
(statearr_37692_37790[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (1))){
var state_37680__$1 = state_37680;
var statearr_37693_37791 = state_37680__$1;
(statearr_37693_37791[(2)] = null);

(statearr_37693_37791[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (69))){
var inst_37667 = (state_37680[(12)]);
var state_37680__$1 = state_37680;
var statearr_37694_37792 = state_37680__$1;
(statearr_37694_37792[(2)] = inst_37667);

(statearr_37694_37792[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (24))){
var inst_37522 = (state_37680[(7)]);
var state_37680__$1 = state_37680;
if(cljs.core.truth_(inst_37522)){
var statearr_37695_37793 = state_37680__$1;
(statearr_37695_37793[(1)] = (27));

} else {
var statearr_37696_37794 = state_37680__$1;
(statearr_37696_37794[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (55))){
var inst_37561 = (state_37680[(9)]);
var inst_37619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37620 = [inst_37561];
var inst_37621 = (new cljs.core.PersistentVector(null,1,(5),inst_37619,inst_37620,null));
var inst_37622 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$limit,(1));
var inst_37623 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37621,inst_37622);
var state_37680__$1 = state_37680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37680__$1,(58),inst_37623);
} else {
if((state_val_37681 === (39))){
var inst_37592 = (state_37680[(2)]);
var inst_37593 = fluree.db.util.async.throw_err(inst_37592);
var state_37680__$1 = state_37680;
var statearr_37697_37795 = state_37680__$1;
(statearr_37697_37795[(2)] = inst_37593);

(statearr_37697_37795[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (46))){
var inst_37605 = (state_37680[(13)]);
var inst_37605__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_37680__$1 = (function (){var statearr_37698 = state_37680;
(statearr_37698[(13)] = inst_37605__$1);

return statearr_37698;
})();
if(cljs.core.truth_(inst_37605__$1)){
var statearr_37699_37796 = state_37680__$1;
(statearr_37699_37796[(1)] = (49));

} else {
var statearr_37700_37797 = state_37680__$1;
(statearr_37700_37797[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (4))){
var inst_37511 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
var statearr_37701_37798 = state_37680__$1;
(statearr_37701_37798[(2)] = inst_37511);

(statearr_37701_37798[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (54))){
var inst_37617 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
if(cljs.core.truth_(inst_37617)){
var statearr_37702_37799 = state_37680__$1;
(statearr_37702_37799[(1)] = (55));

} else {
var statearr_37703_37800 = state_37680__$1;
(statearr_37703_37800[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (15))){
var inst_37523 = (state_37680[(14)]);
var inst_37542 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_37523);
var state_37680__$1 = state_37680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37680__$1,(18),inst_37542);
} else {
if((state_val_37681 === (48))){
var inst_37663 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
var statearr_37704_37801 = state_37680__$1;
(statearr_37704_37801[(2)] = inst_37663);

(statearr_37704_37801[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (50))){
var inst_37522 = (state_37680[(7)]);
var inst_37524 = (state_37680[(8)]);
var inst_37520 = (state_37680[(15)]);
var inst_37605 = (state_37680[(13)]);
var inst_37561 = (state_37680[(9)]);
var inst_37531 = (state_37680[(16)]);
var inst_37536 = (state_37680[(17)]);
var inst_37525 = (state_37680[(18)]);
var inst_37521 = (state_37680[(10)]);
var inst_37609 = (function (){var t = inst_37524;
var p = inst_37522;
var idx_predicate_QMARK_ = inst_37525;
var o = inst_37561;
var tag_predicate_QMARK_ = inst_37531;
var temp__5751__auto__ = inst_37605;
var s = inst_37521;
var o_coerce_QMARK_ = inst_37536;
var vec__37517 = inst_37520;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_37680__$1 = state_37680;
var statearr_37705_37802 = state_37680__$1;
(statearr_37705_37802[(2)] = inst_37609);

(statearr_37705_37802[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (21))){
var inst_37557 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
var statearr_37706_37803 = state_37680__$1;
(statearr_37706_37803[(2)] = inst_37557);

(statearr_37706_37803[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (31))){
var inst_37572 = (state_37680[(11)]);
var state_37680__$1 = state_37680;
var statearr_37707_37804 = state_37680__$1;
(statearr_37707_37804[(2)] = inst_37572);

(statearr_37707_37804[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (32))){
var inst_37582 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
var statearr_37708_37805 = state_37680__$1;
(statearr_37708_37805[(2)] = inst_37582);

(statearr_37708_37805[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (40))){
var inst_37596 = (state_37680[(19)]);
var inst_37525 = (state_37680[(18)]);
var inst_37596__$1 = cljs.core.not(inst_37525);
var state_37680__$1 = (function (){var statearr_37709 = state_37680;
(statearr_37709[(19)] = inst_37596__$1);

return statearr_37709;
})();
if(inst_37596__$1){
var statearr_37710_37806 = state_37680__$1;
(statearr_37710_37806[(1)] = (43));

} else {
var statearr_37711_37807 = state_37680__$1;
(statearr_37711_37807[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (56))){
var inst_37522 = (state_37680[(7)]);
var inst_37524 = (state_37680[(8)]);
var inst_37521 = (state_37680[(10)]);
var inst_37611 = (state_37680[(20)]);
var inst_37629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37630 = [inst_37522,inst_37521,null,inst_37524];
var inst_37631 = (new cljs.core.PersistentVector(null,4,(5),inst_37629,inst_37630,null));
var inst_37632 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_37611);
var inst_37633 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_37631,inst_37632);
var state_37680__$1 = state_37680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37680__$1,(59),inst_37633);
} else {
if((state_val_37681 === (33))){
var inst_37561 = (state_37680[(9)]);
var inst_37575 = cljs.core.fn_QMARK_(inst_37561);
var inst_37576 = (!(inst_37575));
var state_37680__$1 = state_37680;
var statearr_37712_37808 = state_37680__$1;
(statearr_37712_37808[(2)] = inst_37576);

(statearr_37712_37808[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (13))){
var inst_37523 = (state_37680[(14)]);
var inst_37540 = fluree.db.query.range.tag_string_QMARK_(inst_37523);
var state_37680__$1 = state_37680;
if(cljs.core.truth_(inst_37540)){
var statearr_37713_37809 = state_37680__$1;
(statearr_37713_37809[(1)] = (15));

} else {
var statearr_37714_37810 = state_37680__$1;
(statearr_37714_37810[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (22))){
var inst_37553 = (state_37680[(2)]);
var inst_37554 = fluree.db.util.async.throw_err(inst_37553);
var state_37680__$1 = state_37680;
var statearr_37715_37811 = state_37680__$1;
(statearr_37715_37811[(2)] = inst_37554);

(statearr_37715_37811[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (36))){
var inst_37522 = (state_37680[(7)]);
var inst_37524 = (state_37680[(8)]);
var inst_37561 = (state_37680[(9)]);
var inst_37521 = (state_37680[(10)]);
var inst_37587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37588 = [inst_37522,inst_37561,inst_37521,inst_37524];
var inst_37589 = (new cljs.core.PersistentVector(null,4,(5),inst_37587,inst_37588,null));
var inst_37590 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_37589,opts);
var state_37680__$1 = state_37680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37680__$1,(39),inst_37590);
} else {
if((state_val_37681 === (41))){
var inst_37522 = (state_37680[(7)]);
var state_37680__$1 = state_37680;
var statearr_37716_37812 = state_37680__$1;
(statearr_37716_37812[(2)] = inst_37522);

(statearr_37716_37812[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (43))){
var inst_37561 = (state_37680[(9)]);
var state_37680__$1 = state_37680;
var statearr_37717_37813 = state_37680__$1;
(statearr_37717_37813[(2)] = inst_37561);

(statearr_37717_37813[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (61))){
var inst_37561 = (state_37680[(9)]);
var state_37680__$1 = state_37680;
if(cljs.core.truth_(inst_37561)){
var statearr_37718_37814 = state_37680__$1;
(statearr_37718_37814[(1)] = (64));

} else {
var statearr_37719_37815 = state_37680__$1;
(statearr_37719_37815[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (29))){
var inst_37585 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
if(cljs.core.truth_(inst_37585)){
var statearr_37720_37816 = state_37680__$1;
(statearr_37720_37816[(1)] = (36));

} else {
var statearr_37721_37817 = state_37680__$1;
(statearr_37721_37817[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (44))){
var inst_37596 = (state_37680[(19)]);
var state_37680__$1 = state_37680;
var statearr_37722_37818 = state_37680__$1;
(statearr_37722_37818[(2)] = inst_37596);

(statearr_37722_37818[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (6))){
var inst_37522 = (state_37680[(7)]);
var inst_37527 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_37522);
var inst_37528 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_37527);
var state_37680__$1 = state_37680;
var statearr_37723_37819 = state_37680__$1;
(statearr_37723_37819[(2)] = inst_37528);

(statearr_37723_37819[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (28))){
var inst_37522 = (state_37680[(7)]);
var state_37680__$1 = state_37680;
var statearr_37724_37820 = state_37680__$1;
(statearr_37724_37820[(2)] = inst_37522);

(statearr_37724_37820[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (64))){
var inst_37522 = (state_37680[(7)]);
var inst_37524 = (state_37680[(8)]);
var inst_37561 = (state_37680[(9)]);
var inst_37521 = (state_37680[(10)]);
var inst_37650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37651 = [inst_37561,inst_37522,inst_37521,inst_37524];
var inst_37652 = (new cljs.core.PersistentVector(null,4,(5),inst_37650,inst_37651,null));
var inst_37653 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_37652,opts);
var state_37680__$1 = state_37680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37680__$1,(67),inst_37653);
} else {
if((state_val_37681 === (51))){
var inst_37522 = (state_37680[(7)]);
var inst_37612 = (state_37680[(21)]);
var inst_37611 = (state_37680[(2)]);
var inst_37612__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_37522);
var state_37680__$1 = (function (){var statearr_37725 = state_37680;
(statearr_37725[(21)] = inst_37612__$1);

(statearr_37725[(20)] = inst_37611);

return statearr_37725;
})();
if(inst_37612__$1){
var statearr_37726_37821 = state_37680__$1;
(statearr_37726_37821[(1)] = (52));

} else {
var statearr_37727_37822 = state_37680__$1;
(statearr_37727_37822[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (25))){
var inst_37531 = (state_37680[(16)]);
var inst_37667 = (state_37680[(2)]);
var state_37680__$1 = (function (){var statearr_37728 = state_37680;
(statearr_37728[(12)] = inst_37667);

return statearr_37728;
})();
if(cljs.core.truth_(inst_37531)){
var statearr_37729_37823 = state_37680__$1;
(statearr_37729_37823[(1)] = (68));

} else {
var statearr_37730_37824 = state_37680__$1;
(statearr_37730_37824[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (34))){
var inst_37525 = (state_37680[(18)]);
var state_37680__$1 = state_37680;
var statearr_37731_37825 = state_37680__$1;
(statearr_37731_37825[(2)] = inst_37525);

(statearr_37731_37825[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (17))){
var inst_37559 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
var statearr_37732_37826 = state_37680__$1;
(statearr_37732_37826[(2)] = inst_37559);

(statearr_37732_37826[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (3))){
var inst_37678 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37680__$1,inst_37678);
} else {
if((state_val_37681 === (12))){
var inst_37523 = (state_37680[(14)]);
var state_37680__$1 = state_37680;
var statearr_37733_37827 = state_37680__$1;
(statearr_37733_37827[(2)] = inst_37523);

(statearr_37733_37827[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (2))){
var inst_37522 = (state_37680[(7)]);
var inst_37520 = (state_37680[(15)]);
var _ = (function (){var statearr_37734 = state_37680;
(statearr_37734[(4)] = cljs.core.cons((5),(state_37680[(4)])));

return statearr_37734;
})();
var inst_37520__$1 = fparts;
var inst_37521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37520__$1,(0),null);
var inst_37522__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37520__$1,(1),null);
var inst_37523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37520__$1,(2),null);
var inst_37524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37520__$1,(3),null);
var inst_37525 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_37522__$1);
var state_37680__$1 = (function (){var statearr_37735 = state_37680;
(statearr_37735[(7)] = inst_37522__$1);

(statearr_37735[(8)] = inst_37524);

(statearr_37735[(15)] = inst_37520__$1);

(statearr_37735[(14)] = inst_37523);

(statearr_37735[(18)] = inst_37525);

(statearr_37735[(10)] = inst_37521);

return statearr_37735;
})();
if(cljs.core.truth_(inst_37522__$1)){
var statearr_37736_37828 = state_37680__$1;
(statearr_37736_37828[(1)] = (6));

} else {
var statearr_37737_37829 = state_37680__$1;
(statearr_37737_37829[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (66))){
var inst_37659 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
var statearr_37738_37830 = state_37680__$1;
(statearr_37738_37830[(2)] = inst_37659);

(statearr_37738_37830[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (23))){
var inst_37522 = (state_37680[(7)]);
var inst_37524 = (state_37680[(8)]);
var inst_37561 = (state_37680[(9)]);
var inst_37521 = (state_37680[(10)]);
var inst_37563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37564 = [inst_37521,inst_37522,inst_37561,inst_37524];
var inst_37565 = (new cljs.core.PersistentVector(null,4,(5),inst_37563,inst_37564,null));
var inst_37566 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37565,opts);
var state_37680__$1 = state_37680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37680__$1,(26),inst_37566);
} else {
if((state_val_37681 === (47))){
var inst_37522 = (state_37680[(7)]);
var state_37680__$1 = state_37680;
if(cljs.core.truth_(inst_37522)){
var statearr_37739_37831 = state_37680__$1;
(statearr_37739_37831[(1)] = (60));

} else {
var statearr_37740_37832 = state_37680__$1;
(statearr_37740_37832[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (35))){
var inst_37579 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
var statearr_37741_37833 = state_37680__$1;
(statearr_37741_37833[(2)] = inst_37579);

(statearr_37741_37833[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (19))){
var inst_37522 = (state_37680[(7)]);
var inst_37523 = (state_37680[(14)]);
var inst_37549 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_37522);
var inst_37550 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37549),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37523)].join('');
var inst_37551 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_37550);
var state_37680__$1 = state_37680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37680__$1,(22),inst_37551);
} else {
if((state_val_37681 === (57))){
var inst_37638 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
var statearr_37742_37834 = state_37680__$1;
(statearr_37742_37834[(2)] = inst_37638);

(statearr_37742_37834[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (68))){
var inst_37667 = (state_37680[(12)]);
var inst_37669 = fluree.db.query.range.coerce_tag_flakes(db,inst_37667);
var state_37680__$1 = state_37680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37680__$1,(71),inst_37669);
} else {
if((state_val_37681 === (11))){
var inst_37536 = (state_37680[(17)]);
var inst_37536__$1 = (state_37680[(2)]);
var inst_37537 = cljs.core.not(inst_37536__$1);
var state_37680__$1 = (function (){var statearr_37744 = state_37680;
(statearr_37744[(17)] = inst_37536__$1);

return statearr_37744;
})();
if(inst_37537){
var statearr_37745_37835 = state_37680__$1;
(statearr_37745_37835[(1)] = (12));

} else {
var statearr_37746_37836 = state_37680__$1;
(statearr_37746_37836[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (9))){
var inst_37523 = (state_37680[(14)]);
var inst_37533 = typeof inst_37523 === 'string';
var state_37680__$1 = state_37680;
var statearr_37747_37837 = state_37680__$1;
(statearr_37747_37837[(2)] = inst_37533);

(statearr_37747_37837[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (5))){
var _ = (function (){var statearr_37748 = state_37680;
(statearr_37748[(4)] = cljs.core.rest((state_37680[(4)])));

return statearr_37748;
})();
var state_37680__$1 = state_37680;
var ex37743 = (state_37680__$1[(2)]);
var statearr_37749_37838 = state_37680__$1;
(statearr_37749_37838[(5)] = ex37743);


if((ex37743 instanceof Error)){
var statearr_37750_37839 = state_37680__$1;
(statearr_37750_37839[(1)] = (4));

(statearr_37750_37839[(5)] = null);

} else {
throw ex37743;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (14))){
var inst_37521 = (state_37680[(10)]);
var inst_37561 = (state_37680[(2)]);
var state_37680__$1 = (function (){var statearr_37751 = state_37680;
(statearr_37751[(9)] = inst_37561);

return statearr_37751;
})();
if(cljs.core.truth_(inst_37521)){
var statearr_37752_37840 = state_37680__$1;
(statearr_37752_37840[(1)] = (23));

} else {
var statearr_37753_37841 = state_37680__$1;
(statearr_37753_37841[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (45))){
var inst_37600 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
var statearr_37754_37842 = state_37680__$1;
(statearr_37754_37842[(2)] = inst_37600);

(statearr_37754_37842[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (53))){
var inst_37612 = (state_37680[(21)]);
var state_37680__$1 = state_37680;
var statearr_37755_37843 = state_37680__$1;
(statearr_37755_37843[(2)] = inst_37612);

(statearr_37755_37843[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (26))){
var inst_37568 = (state_37680[(2)]);
var inst_37569 = fluree.db.util.async.throw_err(inst_37568);
var state_37680__$1 = state_37680;
var statearr_37756_37844 = state_37680__$1;
(statearr_37756_37844[(2)] = inst_37569);

(statearr_37756_37844[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (16))){
var inst_37523 = (state_37680[(14)]);
var inst_37547 = typeof inst_37523 === 'string';
var state_37680__$1 = state_37680;
if(cljs.core.truth_(inst_37547)){
var statearr_37757_37845 = state_37680__$1;
(statearr_37757_37845[(1)] = (19));

} else {
var statearr_37758_37846 = state_37680__$1;
(statearr_37758_37846[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (38))){
var inst_37665 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
var statearr_37759_37847 = state_37680__$1;
(statearr_37759_37847[(2)] = inst_37665);

(statearr_37759_37847[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (30))){
var inst_37525 = (state_37680[(18)]);
var state_37680__$1 = state_37680;
if(cljs.core.truth_(inst_37525)){
var statearr_37760_37848 = state_37680__$1;
(statearr_37760_37848[(1)] = (33));

} else {
var statearr_37761_37849 = state_37680__$1;
(statearr_37761_37849[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (10))){
var inst_37531 = (state_37680[(16)]);
var state_37680__$1 = state_37680;
var statearr_37762_37850 = state_37680__$1;
(statearr_37762_37850[(2)] = inst_37531);

(statearr_37762_37850[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (18))){
var inst_37544 = (state_37680[(2)]);
var inst_37545 = fluree.db.util.async.throw_err(inst_37544);
var state_37680__$1 = state_37680;
var statearr_37763_37851 = state_37680__$1;
(statearr_37763_37851[(2)] = inst_37545);

(statearr_37763_37851[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (52))){
var inst_37561 = (state_37680[(9)]);
var inst_37614 = cljs.core.int_QMARK_(inst_37561);
var state_37680__$1 = state_37680;
var statearr_37764_37852 = state_37680__$1;
(statearr_37764_37852[(2)] = inst_37614);

(statearr_37764_37852[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (67))){
var inst_37655 = (state_37680[(2)]);
var inst_37656 = fluree.db.util.async.throw_err(inst_37655);
var state_37680__$1 = state_37680;
var statearr_37765_37853 = state_37680__$1;
(statearr_37765_37853[(2)] = inst_37656);

(statearr_37765_37853[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (71))){
var inst_37671 = (state_37680[(2)]);
var inst_37672 = fluree.db.util.async.throw_err(inst_37671);
var state_37680__$1 = state_37680;
var statearr_37766_37854 = state_37680__$1;
(statearr_37766_37854[(2)] = inst_37672);

(statearr_37766_37854[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (42))){
var inst_37603 = (state_37680[(2)]);
var state_37680__$1 = state_37680;
if(cljs.core.truth_(inst_37603)){
var statearr_37767_37855 = state_37680__$1;
(statearr_37767_37855[(1)] = (46));

} else {
var statearr_37768_37856 = state_37680__$1;
(statearr_37768_37856[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (37))){
var inst_37522 = (state_37680[(7)]);
var state_37680__$1 = state_37680;
if(cljs.core.truth_(inst_37522)){
var statearr_37769_37857 = state_37680__$1;
(statearr_37769_37857[(1)] = (40));

} else {
var statearr_37770_37858 = state_37680__$1;
(statearr_37770_37858[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (63))){
var inst_37646 = (state_37680[(2)]);
var inst_37647 = fluree.db.util.async.throw_err(inst_37646);
var state_37680__$1 = state_37680;
var statearr_37771_37859 = state_37680__$1;
(statearr_37771_37859[(2)] = inst_37647);

(statearr_37771_37859[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (8))){
var inst_37531 = (state_37680[(16)]);
var inst_37531__$1 = (state_37680[(2)]);
var state_37680__$1 = (function (){var statearr_37772 = state_37680;
(statearr_37772[(16)] = inst_37531__$1);

return statearr_37772;
})();
if(cljs.core.truth_(inst_37531__$1)){
var statearr_37773_37860 = state_37680__$1;
(statearr_37773_37860[(1)] = (9));

} else {
var statearr_37774_37861 = state_37680__$1;
(statearr_37774_37861[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37681 === (49))){
var inst_37522 = (state_37680[(7)]);
var inst_37524 = (state_37680[(8)]);
var inst_37520 = (state_37680[(15)]);
var inst_37605 = (state_37680[(13)]);
var inst_37561 = (state_37680[(9)]);
var inst_37531 = (state_37680[(16)]);
var inst_37536 = (state_37680[(17)]);
var inst_37525 = (state_37680[(18)]);
var inst_37521 = (state_37680[(10)]);
var inst_37607 = (function (){var obj_fn = inst_37605;
var t = inst_37524;
var p = inst_37522;
var idx_predicate_QMARK_ = inst_37525;
var o = inst_37561;
var tag_predicate_QMARK_ = inst_37531;
var temp__5751__auto__ = inst_37605;
var s = inst_37521;
var o_coerce_QMARK_ = inst_37536;
var vec__37517 = inst_37520;
return (function (x){
var and__4221__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4221__auto__;
}
});
})();
var state_37680__$1 = state_37680;
var statearr_37775_37862 = state_37680__$1;
(statearr_37775_37862[(2)] = inst_37607);

(statearr_37775_37862[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__20477__auto__ = null;
var fluree$db$query$range$state_machine__20477__auto____0 = (function (){
var statearr_37776 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37776[(0)] = fluree$db$query$range$state_machine__20477__auto__);

(statearr_37776[(1)] = (1));

return statearr_37776;
});
var fluree$db$query$range$state_machine__20477__auto____1 = (function (state_37680){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_37680);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e37777){var ex__20480__auto__ = e37777;
var statearr_37778_37863 = state_37680;
(statearr_37778_37863[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_37680[(4)]))){
var statearr_37779_37864 = state_37680;
(statearr_37779_37864[(1)] = cljs.core.first((state_37680[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__37865 = state_37680;
state_37680 = G__37865;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__20477__auto__ = function(state_37680){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__20477__auto____1.call(this,state_37680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__20477__auto____0;
fluree$db$query$range$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__20477__auto____1;
return fluree$db$query$range$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_37780 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_37780[(6)] = c__20603__auto__);

return statearr_37780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__37867 = arguments.length;
switch (G__37867) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_37902){
var state_val_37903 = (state_37902[(1)]);
if((state_val_37903 === (7))){
var inst_37889 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_37890 = ["Invalid collection name: ",inst_37889].join('');
var inst_37891 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_37892 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_37893 = cljs.core.PersistentHashMap.fromArrays(inst_37891,inst_37892);
var inst_37894 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37890,inst_37893);
var inst_37895 = (function(){throw inst_37894})();
var state_37902__$1 = state_37902;
var statearr_37904_37924 = state_37902__$1;
(statearr_37904_37924[(2)] = inst_37895);

(statearr_37904_37924[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37903 === (1))){
var state_37902__$1 = state_37902;
var statearr_37905_37925 = state_37902__$1;
(statearr_37905_37925[(2)] = null);

(statearr_37905_37925[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37903 === (4))){
var inst_37868 = (state_37902[(2)]);
var state_37902__$1 = state_37902;
var statearr_37906_37926 = state_37902__$1;
(statearr_37906_37926[(2)] = inst_37868);

(statearr_37906_37926[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37903 === (6))){
var inst_37874 = (state_37902[(7)]);
var inst_37876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37877 = fluree.db.flake.max_subject_id(inst_37874);
var inst_37878 = [inst_37877];
var inst_37879 = (new cljs.core.PersistentVector(null,1,(5),inst_37876,inst_37878,null));
var inst_37880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37881 = fluree.db.flake.min_subject_id(inst_37874);
var inst_37882 = [inst_37881];
var inst_37883 = (new cljs.core.PersistentVector(null,1,(5),inst_37880,inst_37882,null));
var inst_37884 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_37879,cljs.core._LT__EQ_,inst_37883,opts);
var state_37902__$1 = state_37902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37902__$1,(9),inst_37884);
} else {
if((state_val_37903 === (3))){
var inst_37900 = (state_37902[(2)]);
var state_37902__$1 = state_37902;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37902__$1,inst_37900);
} else {
if((state_val_37903 === (2))){
var inst_37874 = (state_37902[(7)]);
var _ = (function (){var statearr_37908 = state_37902;
(statearr_37908[(4)] = cljs.core.cons((5),(state_37902[(4)])));

return statearr_37908;
})();
var inst_37874__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,name);
var state_37902__$1 = (function (){var statearr_37909 = state_37902;
(statearr_37909[(7)] = inst_37874__$1);

return statearr_37909;
})();
if(cljs.core.truth_(inst_37874__$1)){
var statearr_37910_37927 = state_37902__$1;
(statearr_37910_37927[(1)] = (6));

} else {
var statearr_37911_37928 = state_37902__$1;
(statearr_37911_37928[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37903 === (9))){
var inst_37886 = (state_37902[(2)]);
var inst_37887 = fluree.db.util.async.throw_err(inst_37886);
var state_37902__$1 = state_37902;
var statearr_37912_37929 = state_37902__$1;
(statearr_37912_37929[(2)] = inst_37887);

(statearr_37912_37929[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37903 === (5))){
var _ = (function (){var statearr_37913 = state_37902;
(statearr_37913[(4)] = cljs.core.rest((state_37902[(4)])));

return statearr_37913;
})();
var state_37902__$1 = state_37902;
var ex37907 = (state_37902__$1[(2)]);
var statearr_37914_37930 = state_37902__$1;
(statearr_37914_37930[(5)] = ex37907);


var statearr_37915_37931 = state_37902__$1;
(statearr_37915_37931[(1)] = (4));

(statearr_37915_37931[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_37903 === (8))){
var inst_37897 = (state_37902[(2)]);
var _ = (function (){var statearr_37916 = state_37902;
(statearr_37916[(4)] = cljs.core.rest((state_37902[(4)])));

return statearr_37916;
})();
var state_37902__$1 = state_37902;
var statearr_37917_37932 = state_37902__$1;
(statearr_37917_37932[(2)] = inst_37897);

(statearr_37917_37932[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__20477__auto__ = null;
var fluree$db$query$range$state_machine__20477__auto____0 = (function (){
var statearr_37918 = [null,null,null,null,null,null,null,null];
(statearr_37918[(0)] = fluree$db$query$range$state_machine__20477__auto__);

(statearr_37918[(1)] = (1));

return statearr_37918;
});
var fluree$db$query$range$state_machine__20477__auto____1 = (function (state_37902){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_37902);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e37919){var ex__20480__auto__ = e37919;
var statearr_37920_37933 = state_37902;
(statearr_37920_37933[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_37902[(4)]))){
var statearr_37921_37934 = state_37902;
(statearr_37921_37934[(1)] = cljs.core.first((state_37902[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__37935 = state_37902;
state_37902 = G__37935;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__20477__auto__ = function(state_37902){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__20477__auto____1.call(this,state_37902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__20477__auto____0;
fluree$db$query$range$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__20477__auto____1;
return fluree$db$query$range$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_37922 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_37922[(6)] = c__20603__auto__);

return statearr_37922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__37939 = flakes;
var vec__37940 = G__37939;
var seq__37941 = cljs.core.seq(vec__37940);
var first__37942 = cljs.core.first(seq__37941);
var seq__37941__$1 = cljs.core.next(seq__37941);
var flake_SINGLEQUOTE_ = first__37942;
var r = seq__37941__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__37939__$1 = G__37939;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__37948 = G__37939__$1;
var seq__37949 = cljs.core.seq(vec__37948);
var first__37950 = cljs.core.first(seq__37949);
var seq__37949__$1 = cljs.core.next(seq__37949);
var flake_SINGLEQUOTE___$1 = first__37950;
var r__$1 = seq__37949__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e37952){var e = e37952;
return null;
}})();
var map__37951 = cmd_map;
var map__37951__$1 = cljs.core.__destructure_map(map__37951);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37951__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37951__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37951__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37951__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37951__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37951__$1,cljs.core.cst$kw$expire);
var G__37953 = r__$1;
var G__37954 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__37939__$1 = G__37953;
result_STAR___$1 = G__37954;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__37963 = blocks;
var vec__37964 = G__37963;
var seq__37965 = cljs.core.seq(vec__37964);
var first__37966 = cljs.core.first(seq__37965);
var seq__37965__$1 = cljs.core.next(seq__37965);
var block_SINGLEQUOTE_ = first__37966;
var r = seq__37965__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__37963__$1 = G__37963;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__37971 = G__37963__$1;
var seq__37972 = cljs.core.seq(vec__37971);
var first__37973 = cljs.core.first(seq__37972);
var seq__37972__$1 = cljs.core.next(seq__37972);
var block_SINGLEQUOTE___$1 = first__37973;
var r__$1 = seq__37972__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__37974 = block_SINGLEQUOTE___$1;
var map__37974__$1 = cljs.core.__destructure_map(map__37974);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37974__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37974__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37974__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__37963__$1,result_STAR___$1,map__37974,map__37974__$1,block,t,flakes,vec__37971,seq__37972,first__37973,seq__37972__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__37963,vec__37964,seq__37965,first__37966,seq__37965__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__37955_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__37955_SHARP_.p,(2))){
return p1__37955_SHARP_.o;
} else {
return null;
}
});})(G__37963__$1,result_STAR___$1,map__37974,map__37974__$1,block,t,flakes,vec__37971,seq__37972,first__37973,seq__37972__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__37963,vec__37964,seq__37965,first__37966,seq__37965__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__37963__$1,result_STAR___$1,map__37974,map__37974__$1,block,t,flakes,prev_hash,vec__37971,seq__37972,first__37973,seq__37972__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__37963,vec__37964,seq__37965,first__37966,seq__37965__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__37956_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__37956_SHARP_.p,(1))){
return p1__37956_SHARP_.o;
} else {
return null;
}
});})(G__37963__$1,result_STAR___$1,map__37974,map__37974__$1,block,t,flakes,prev_hash,vec__37971,seq__37972,first__37973,seq__37972__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__37963,vec__37964,seq__37965,first__37966,seq__37965__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__37963__$1,result_STAR___$1,map__37974,map__37974__$1,block,t,flakes,prev_hash,hash,vec__37971,seq__37972,first__37973,seq__37972__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__37963,vec__37964,seq__37965,first__37966,seq__37965__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__37957_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__37957_SHARP_.p,(5))){
return p1__37957_SHARP_.o;
} else {
return null;
}
});})(G__37963__$1,result_STAR___$1,map__37974,map__37974__$1,block,t,flakes,prev_hash,hash,vec__37971,seq__37972,first__37973,seq__37972__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__37963,vec__37964,seq__37965,first__37966,seq__37965__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__37963__$1,result_STAR___$1,map__37974,map__37974__$1,block,t,flakes,prev_hash,hash,instant,vec__37971,seq__37972,first__37973,seq__37972__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__37963,vec__37964,seq__37965,first__37966,seq__37965__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__37958_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__37958_SHARP_.p,(7))){
return p1__37958_SHARP_.o;
} else {
return null;
}
});})(G__37963__$1,result_STAR___$1,map__37974,map__37974__$1,block,t,flakes,prev_hash,hash,instant,vec__37971,seq__37972,first__37973,seq__37972__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__37963,vec__37964,seq__37965,first__37966,seq__37965__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__37963__$1,result_STAR___$1,map__37974,map__37974__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__37971,seq__37972,first__37973,seq__37972__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__37963,vec__37964,seq__37965,first__37966,seq__37965__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__37959_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__37959_SHARP_.p,(106));
});})(G__37963__$1,result_STAR___$1,map__37974,map__37974__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__37971,seq__37972,first__37973,seq__37972__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__37963,vec__37964,seq__37965,first__37966,seq__37965__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__37975 = r__$1;
var G__37976 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__37963__$1 = G__37975;
result_STAR___$1 = G__37976;
continue;
}
break;
}
});
