// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5753__auto__)){
var st = temp__5753__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__38806 = cljs.core._EQ_;
var expr__38807 = e.getLastErrorCode();
if(cljs.core.truth_((pred__38806.cljs$core$IFn$_invoke$arity$2 ? pred__38806.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__38807) : pred__38806.call(null,goog.net.ErrorCode.NO_ERROR,expr__38807)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__38806.cljs$core$IFn$_invoke$arity$2 ? pred__38806.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__38807) : pred__38806.call(null,goog.net.ErrorCode.EXCEPTION,expr__38807)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__38806.cljs$core$IFn$_invoke$arity$2 ? pred__38806.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__38807) : pred__38806.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__38807)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__38806.cljs$core$IFn$_invoke$arity$2 ? pred__38806.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__38807) : pred__38806.call(null,goog.net.ErrorCode.ABORT,expr__38807)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__38806.cljs$core$IFn$_invoke$arity$2 ? pred__38806.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__38807) : pred__38806.call(null,goog.net.ErrorCode.TIMEOUT,expr__38807)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4221__auto__ = status;
if(cljs.core.truth_(and__4221__auto__)){
return (status > (0));
} else {
return and__4221__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__38809 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38809,cljs.core.cst$kw$status,status);
} else {
return G__38809;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__38810 = opts;
var map__38810__$1 = cljs.core.__destructure_map(map__38810);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38810__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38810__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38810__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__38811 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__38811__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__38811,headers], 0)):G__38811);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38811__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__38811__$1;
}
})();
try{var G__38813_38819 = url;
var G__38814_38820 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__38815_38821 = "POST";
var G__38816_38822 = fluree.db.util.json.stringify(message);
var G__38817_38823 = cljs.core.clj__GT_js(headers__$1);
var G__38818_38824 = request_timeout;
goog.net.XhrIo.send(G__38813_38819,G__38814_38820,G__38815_38821,G__38816_38822,G__38817_38823,G__38818_38824);
}catch (e38812){var e_38825 = e38812;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_38825);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__38826 = opts;
var map__38826__$1 = cljs.core.__destructure_map(map__38826);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38826__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38826__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38826__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38826__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38826__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__38827 = cljs.core.PersistentArrayMap.EMPTY;
var G__38827__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__38827,headers], 0)):G__38827);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38827__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__38827__$1;
}
})();
try{var G__38829_38836 = url;
var G__38830_38837 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__38835 = output_format;
var G__38835__$1 = (((G__38835 instanceof cljs.core.Keyword))?G__38835.fqn:null);
switch (G__38835__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__38831_38838 = "GET";
var G__38832_38839 = body;
var G__38833_38840 = cljs.core.clj__GT_js(headers__$1);
var G__38834_38841 = request_timeout;
goog.net.XhrIo.send(G__38829_38836,G__38830_38837,G__38831_38838,G__38832_38839,G__38833_38840,G__38834_38841);
}catch (e38828){var e_38843 = e38828;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_38843);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__38844 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38844,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__38844;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_38877){
var state_val_38878 = (state_38877[(1)]);
if((state_val_38878 === (7))){
var inst_38873 = (state_38877[(2)]);
var state_38877__$1 = state_38877;
var statearr_38879_38904 = state_38877__$1;
(statearr_38879_38904[(2)] = inst_38873);

(statearr_38879_38904[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38878 === (1))){
var state_38877__$1 = state_38877;
var statearr_38880_38905 = state_38877__$1;
(statearr_38880_38905[(2)] = null);

(statearr_38880_38905[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38878 === (4))){
var inst_38848 = (state_38877[(7)]);
var inst_38848__$1 = (state_38877[(2)]);
var inst_38849 = (inst_38848__$1 == null);
var state_38877__$1 = (function (){var statearr_38881 = state_38877;
(statearr_38881[(7)] = inst_38848__$1);

return statearr_38881;
})();
if(cljs.core.truth_(inst_38849)){
var statearr_38882_38906 = state_38877__$1;
(statearr_38882_38906[(1)] = (5));

} else {
var statearr_38883_38907 = state_38877__$1;
(statearr_38883_38907[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38878 === (6))){
var inst_38848 = (state_38877[(7)]);
var inst_38856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38848,(0),null);
var inst_38857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38848,(1),null);
var state_38877__$1 = (function (){var statearr_38884 = state_38877;
(statearr_38884[(8)] = inst_38856);

(statearr_38884[(9)] = inst_38857);

return statearr_38884;
})();
var statearr_38885_38908 = state_38877__$1;
(statearr_38885_38908[(2)] = null);

(statearr_38885_38908[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38878 === (3))){
var inst_38875 = (state_38877[(2)]);
var state_38877__$1 = state_38877;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38877__$1,inst_38875);
} else {
if((state_val_38878 === (2))){
var state_38877__$1 = state_38877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38877__$1,(4),pub_chan);
} else {
if((state_val_38878 === (11))){
var _ = (function (){var statearr_38887 = state_38877;
(statearr_38887[(4)] = cljs.core.rest((state_38877[(4)])));

return statearr_38887;
})();
var state_38877__$1 = state_38877;
var ex38886 = (state_38877__$1[(2)]);
var statearr_38888_38909 = state_38877__$1;
(statearr_38888_38909[(5)] = ex38886);


if((ex38886 instanceof Error)){
var statearr_38889_38910 = state_38877__$1;
(statearr_38889_38910[(1)] = (10));

(statearr_38889_38910[(5)] = null);

} else {
throw ex38886;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38878 === (9))){
var inst_38870 = (state_38877[(2)]);
var state_38877__$1 = (function (){var statearr_38890 = state_38877;
(statearr_38890[(10)] = inst_38870);

return statearr_38890;
})();
var statearr_38891_38911 = state_38877__$1;
(statearr_38891_38911[(2)] = null);

(statearr_38891_38911[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38878 === (5))){
var inst_38851 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_38877__$1 = state_38877;
var statearr_38892_38912 = state_38877__$1;
(statearr_38892_38912[(2)] = inst_38851);

(statearr_38892_38912[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38878 === (10))){
var inst_38857 = (state_38877[(9)]);
var inst_38858 = (state_38877[(2)]);
var inst_38859 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38858,"Websocket send message error:",inst_38858], 0));
var inst_38860 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38857,false);
var state_38877__$1 = (function (){var statearr_38893 = state_38877;
(statearr_38893[(11)] = inst_38859);

return statearr_38893;
})();
var statearr_38894_38913 = state_38877__$1;
(statearr_38894_38913[(2)] = inst_38860);

(statearr_38894_38913[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38878 === (8))){
var inst_38856 = (state_38877[(8)]);
var inst_38857 = (state_38877[(9)]);
var _ = (function (){var statearr_38895 = state_38877;
(statearr_38895[(4)] = cljs.core.cons((11),(state_38877[(4)])));

return statearr_38895;
})();
var inst_38866 = ws.send(inst_38856);
var inst_38867 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38857,true);
var ___$1 = (function (){var statearr_38896 = state_38877;
(statearr_38896[(4)] = cljs.core.rest((state_38877[(4)])));

return statearr_38896;
})();
var state_38877__$1 = (function (){var statearr_38897 = state_38877;
(statearr_38897[(12)] = inst_38866);

return statearr_38897;
})();
var statearr_38898_38914 = state_38877__$1;
(statearr_38898_38914[(2)] = inst_38867);

(statearr_38898_38914[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__20477__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__20477__auto____0 = (function (){
var statearr_38899 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38899[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__20477__auto__);

(statearr_38899[(1)] = (1));

return statearr_38899;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__20477__auto____1 = (function (state_38877){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_38877);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e38900){var ex__20480__auto__ = e38900;
var statearr_38901_38915 = state_38877;
(statearr_38901_38915[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_38877[(4)]))){
var statearr_38902_38916 = state_38877;
(statearr_38902_38916[(1)] = cljs.core.first((state_38877[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__38917 = state_38877;
state_38877 = G__38917;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__20477__auto__ = function(state_38877){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__20477__auto____1.call(this,state_38877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__20477__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__20477__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_38903 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_38903[(6)] = c__20603__auto__);

return statearr_38903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__20603__auto___38956 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_38943){
var state_val_38944 = (state_38943[(1)]);
if((state_val_38944 === (1))){
var inst_38922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38923 = [open_QMARK_,timeout_chan];
var inst_38924 = (new cljs.core.PersistentVector(null,2,(5),inst_38922,inst_38923,null));
var state_38943__$1 = state_38943;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_38943__$1,(2),inst_38924,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_38944 === (2))){
var inst_38926 = (state_38943[(2)]);
var inst_38927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38926,(0),null);
var inst_38928 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38926,(1),null);
var inst_38929 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38928,timeout_chan);
var state_38943__$1 = (function (){var statearr_38945 = state_38943;
(statearr_38945[(7)] = inst_38927);

return statearr_38945;
})();
if(inst_38929){
var statearr_38946_38957 = state_38943__$1;
(statearr_38946_38957[(1)] = (3));

} else {
var statearr_38947_38958 = state_38943__$1;
(statearr_38947_38958[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38944 === (3))){
var inst_38931 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_38932 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38933 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_38934 = cljs.core.PersistentHashMap.fromArrays(inst_38932,inst_38933);
var inst_38935 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38931,inst_38934);
var inst_38936 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_38935);
var inst_38937 = fluree.db.util.xhttp.close_websocket(ws);
var state_38943__$1 = (function (){var statearr_38948 = state_38943;
(statearr_38948[(8)] = inst_38936);

return statearr_38948;
})();
var statearr_38949_38959 = state_38943__$1;
(statearr_38949_38959[(2)] = inst_38937);

(statearr_38949_38959[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38944 === (4))){
var inst_38939 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_38943__$1 = state_38943;
var statearr_38950_38960 = state_38943__$1;
(statearr_38950_38960[(2)] = inst_38939);

(statearr_38950_38960[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38944 === (5))){
var inst_38941 = (state_38943[(2)]);
var state_38943__$1 = state_38943;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38943__$1,inst_38941);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__20477__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__20477__auto____0 = (function (){
var statearr_38951 = [null,null,null,null,null,null,null,null,null];
(statearr_38951[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__20477__auto__);

(statearr_38951[(1)] = (1));

return statearr_38951;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__20477__auto____1 = (function (state_38943){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_38943);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e38952){var ex__20480__auto__ = e38952;
var statearr_38953_38961 = state_38943;
(statearr_38953_38961[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_38943[(4)]))){
var statearr_38954_38962 = state_38943;
(statearr_38954_38962[(1)] = cljs.core.first((state_38943[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__38963 = state_38943;
state_38943 = G__38963;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__20477__auto__ = function(state_38943){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__20477__auto____1.call(this,state_38943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__20477__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__20477__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_38955 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_38955[(6)] = c__20603__auto___38956);

return statearr_38955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
