// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__16287 = arguments.length;
switch (G__16287) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16288 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16288 = (function (f,blockable,meta16289){
this.f = f;
this.blockable = blockable;
this.meta16289 = meta16289;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16288.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16290,meta16289__$1){
var self__ = this;
var _16290__$1 = this;
return (new cljs.core.async.t_cljs$core$async16288(self__.f,self__.blockable,meta16289__$1));
}));

(cljs.core.async.t_cljs$core$async16288.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16290){
var self__ = this;
var _16290__$1 = this;
return self__.meta16289;
}));

(cljs.core.async.t_cljs$core$async16288.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16288.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16288.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async16288.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async16288.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta16289], null);
}));

(cljs.core.async.t_cljs$core$async16288.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16288.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16288");

(cljs.core.async.t_cljs$core$async16288.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async16288");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16288.
 */
cljs.core.async.__GT_t_cljs$core$async16288 = (function cljs$core$async$__GT_t_cljs$core$async16288(f__$1,blockable__$1,meta16289){
return (new cljs.core.async.t_cljs$core$async16288(f__$1,blockable__$1,meta16289));
});

}

return (new cljs.core.async.t_cljs$core$async16288(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__16294 = arguments.length;
switch (G__16294) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__16297 = arguments.length;
switch (G__16297) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__16300 = arguments.length;
switch (G__16300) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_16302 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16302) : fn1.call(null,val_16302));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16302) : fn1.call(null,val_16302));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__16304 = arguments.length;
switch (G__16304) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4706__auto___16306 = n;
var x_16307 = (0);
while(true){
if((x_16307 < n__4706__auto___16306)){
(a[x_16307] = x_16307);

var G__16308 = (x_16307 + (1));
x_16307 = G__16308;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16309 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16309 = (function (flag,meta16310){
this.flag = flag;
this.meta16310 = meta16310;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16309.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16311,meta16310__$1){
var self__ = this;
var _16311__$1 = this;
return (new cljs.core.async.t_cljs$core$async16309(self__.flag,meta16310__$1));
}));

(cljs.core.async.t_cljs$core$async16309.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16311){
var self__ = this;
var _16311__$1 = this;
return self__.meta16310;
}));

(cljs.core.async.t_cljs$core$async16309.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16309.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async16309.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16309.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async16309.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta16310], null);
}));

(cljs.core.async.t_cljs$core$async16309.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16309.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16309");

(cljs.core.async.t_cljs$core$async16309.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async16309");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16309.
 */
cljs.core.async.__GT_t_cljs$core$async16309 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async16309(flag__$1,meta16310){
return (new cljs.core.async.t_cljs$core$async16309(flag__$1,meta16310));
});

}

return (new cljs.core.async.t_cljs$core$async16309(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16312 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16312 = (function (flag,cb,meta16313){
this.flag = flag;
this.cb = cb;
this.meta16313 = meta16313;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16312.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16314,meta16313__$1){
var self__ = this;
var _16314__$1 = this;
return (new cljs.core.async.t_cljs$core$async16312(self__.flag,self__.cb,meta16313__$1));
}));

(cljs.core.async.t_cljs$core$async16312.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16314){
var self__ = this;
var _16314__$1 = this;
return self__.meta16313;
}));

(cljs.core.async.t_cljs$core$async16312.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16312.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async16312.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16312.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async16312.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta16313], null);
}));

(cljs.core.async.t_cljs$core$async16312.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16312.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16312");

(cljs.core.async.t_cljs$core$async16312.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async16312");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16312.
 */
cljs.core.async.__GT_t_cljs$core$async16312 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async16312(flag__$1,cb__$1,meta16313){
return (new cljs.core.async.t_cljs$core$async16312(flag__$1,cb__$1,meta16313));
});

}

return (new cljs.core.async.t_cljs$core$async16312(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16315_SHARP_){
var G__16317 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16315_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16317) : fret.call(null,G__16317));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16316_SHARP_){
var G__16318 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16316_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16318) : fret.call(null,G__16318));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4223__auto__ = wport;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return port;
}
})()], null));
} else {
var G__16319 = (i + (1));
i = G__16319;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4223__auto__ = ret;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5753__auto__ = (function (){var and__4221__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4221__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___16324 = arguments.length;
var i__4830__auto___16325 = (0);
while(true){
if((i__4830__auto___16325 < len__4829__auto___16324)){
args__4835__auto__.push((arguments[i__4830__auto___16325]));

var G__16326 = (i__4830__auto___16325 + (1));
i__4830__auto___16325 = G__16326;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__16322){
var map__16323 = p__16322;
var map__16323__$1 = cljs.core.__destructure_map(map__16323);
var opts = map__16323__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq16320){
var G__16321 = cljs.core.first(seq16320);
var seq16320__$1 = cljs.core.next(seq16320);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16321,seq16320__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__16328 = arguments.length;
switch (G__16328) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16227__auto___16375 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_16352){
var state_val_16353 = (state_16352[(1)]);
if((state_val_16353 === (7))){
var inst_16348 = (state_16352[(2)]);
var state_16352__$1 = state_16352;
var statearr_16354_16376 = state_16352__$1;
(statearr_16354_16376[(2)] = inst_16348);

(statearr_16354_16376[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16353 === (1))){
var state_16352__$1 = state_16352;
var statearr_16355_16377 = state_16352__$1;
(statearr_16355_16377[(2)] = null);

(statearr_16355_16377[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16353 === (4))){
var inst_16331 = (state_16352[(7)]);
var inst_16331__$1 = (state_16352[(2)]);
var inst_16332 = (inst_16331__$1 == null);
var state_16352__$1 = (function (){var statearr_16356 = state_16352;
(statearr_16356[(7)] = inst_16331__$1);

return statearr_16356;
})();
if(cljs.core.truth_(inst_16332)){
var statearr_16357_16378 = state_16352__$1;
(statearr_16357_16378[(1)] = (5));

} else {
var statearr_16358_16379 = state_16352__$1;
(statearr_16358_16379[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16353 === (13))){
var state_16352__$1 = state_16352;
var statearr_16359_16380 = state_16352__$1;
(statearr_16359_16380[(2)] = null);

(statearr_16359_16380[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16353 === (6))){
var inst_16331 = (state_16352[(7)]);
var state_16352__$1 = state_16352;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16352__$1,(11),to,inst_16331);
} else {
if((state_val_16353 === (3))){
var inst_16350 = (state_16352[(2)]);
var state_16352__$1 = state_16352;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16352__$1,inst_16350);
} else {
if((state_val_16353 === (12))){
var state_16352__$1 = state_16352;
var statearr_16360_16381 = state_16352__$1;
(statearr_16360_16381[(2)] = null);

(statearr_16360_16381[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16353 === (2))){
var state_16352__$1 = state_16352;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16352__$1,(4),from);
} else {
if((state_val_16353 === (11))){
var inst_16341 = (state_16352[(2)]);
var state_16352__$1 = state_16352;
if(cljs.core.truth_(inst_16341)){
var statearr_16361_16382 = state_16352__$1;
(statearr_16361_16382[(1)] = (12));

} else {
var statearr_16362_16383 = state_16352__$1;
(statearr_16362_16383[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16353 === (9))){
var state_16352__$1 = state_16352;
var statearr_16363_16384 = state_16352__$1;
(statearr_16363_16384[(2)] = null);

(statearr_16363_16384[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16353 === (5))){
var state_16352__$1 = state_16352;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16364_16385 = state_16352__$1;
(statearr_16364_16385[(1)] = (8));

} else {
var statearr_16365_16386 = state_16352__$1;
(statearr_16365_16386[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16353 === (14))){
var inst_16346 = (state_16352[(2)]);
var state_16352__$1 = state_16352;
var statearr_16366_16387 = state_16352__$1;
(statearr_16366_16387[(2)] = inst_16346);

(statearr_16366_16387[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16353 === (10))){
var inst_16338 = (state_16352[(2)]);
var state_16352__$1 = state_16352;
var statearr_16367_16388 = state_16352__$1;
(statearr_16367_16388[(2)] = inst_16338);

(statearr_16367_16388[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16353 === (8))){
var inst_16335 = cljs.core.async.close_BANG_(to);
var state_16352__$1 = state_16352;
var statearr_16368_16389 = state_16352__$1;
(statearr_16368_16389[(2)] = inst_16335);

(statearr_16368_16389[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16153__auto__ = null;
var cljs$core$async$state_machine__16153__auto____0 = (function (){
var statearr_16369 = [null,null,null,null,null,null,null,null];
(statearr_16369[(0)] = cljs$core$async$state_machine__16153__auto__);

(statearr_16369[(1)] = (1));

return statearr_16369;
});
var cljs$core$async$state_machine__16153__auto____1 = (function (state_16352){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_16352);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e16370){var ex__16156__auto__ = e16370;
var statearr_16371_16390 = state_16352;
(statearr_16371_16390[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_16352[(4)]))){
var statearr_16372_16391 = state_16352;
(statearr_16372_16391[(1)] = cljs.core.first((state_16352[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__16392 = state_16352;
state_16352 = G__16392;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$state_machine__16153__auto__ = function(state_16352){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16153__auto____1.call(this,state_16352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16153__auto____0;
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16153__auto____1;
return cljs$core$async$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_16373 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_16373[(6)] = c__16227__auto___16375);

return statearr_16373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__16393){
var vec__16394 = p__16393;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16394,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16394,(1),null);
var job = vec__16394;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__16227__auto___16570 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_16401){
var state_val_16402 = (state_16401[(1)]);
if((state_val_16402 === (1))){
var state_16401__$1 = state_16401;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16401__$1,(2),res,v);
} else {
if((state_val_16402 === (2))){
var inst_16398 = (state_16401[(2)]);
var inst_16399 = cljs.core.async.close_BANG_(res);
var state_16401__$1 = (function (){var statearr_16403 = state_16401;
(statearr_16403[(7)] = inst_16398);

return statearr_16403;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16401__$1,inst_16399);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0 = (function (){
var statearr_16404 = [null,null,null,null,null,null,null,null];
(statearr_16404[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__);

(statearr_16404[(1)] = (1));

return statearr_16404;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1 = (function (state_16401){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_16401);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e16405){var ex__16156__auto__ = e16405;
var statearr_16406_16571 = state_16401;
(statearr_16406_16571[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_16401[(4)]))){
var statearr_16407_16572 = state_16401;
(statearr_16407_16572[(1)] = cljs.core.first((state_16401[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__16573 = state_16401;
state_16401 = G__16573;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__ = function(state_16401){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1.call(this,state_16401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_16408 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_16408[(6)] = c__16227__auto___16570);

return statearr_16408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__16409){
var vec__16410 = p__16409;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16410,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16410,(1),null);
var job = vec__16410;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4706__auto___16574 = n;
var __16575 = (0);
while(true){
if((__16575 < n__4706__auto___16574)){
var G__16413_16576 = type;
var G__16413_16577__$1 = (((G__16413_16576 instanceof cljs.core.Keyword))?G__16413_16576.fqn:null);
switch (G__16413_16577__$1) {
case "compute":
var c__16227__auto___16579 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__16575,c__16227__auto___16579,G__16413_16576,G__16413_16577__$1,n__4706__auto___16574,jobs,results,process,async){
return (function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = ((function (__16575,c__16227__auto___16579,G__16413_16576,G__16413_16577__$1,n__4706__auto___16574,jobs,results,process,async){
return (function (state_16426){
var state_val_16427 = (state_16426[(1)]);
if((state_val_16427 === (1))){
var state_16426__$1 = state_16426;
var statearr_16428_16580 = state_16426__$1;
(statearr_16428_16580[(2)] = null);

(statearr_16428_16580[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16427 === (2))){
var state_16426__$1 = state_16426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16426__$1,(4),jobs);
} else {
if((state_val_16427 === (3))){
var inst_16424 = (state_16426[(2)]);
var state_16426__$1 = state_16426;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16426__$1,inst_16424);
} else {
if((state_val_16427 === (4))){
var inst_16416 = (state_16426[(2)]);
var inst_16417 = process(inst_16416);
var state_16426__$1 = state_16426;
if(cljs.core.truth_(inst_16417)){
var statearr_16429_16581 = state_16426__$1;
(statearr_16429_16581[(1)] = (5));

} else {
var statearr_16430_16582 = state_16426__$1;
(statearr_16430_16582[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16427 === (5))){
var state_16426__$1 = state_16426;
var statearr_16431_16583 = state_16426__$1;
(statearr_16431_16583[(2)] = null);

(statearr_16431_16583[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16427 === (6))){
var state_16426__$1 = state_16426;
var statearr_16432_16584 = state_16426__$1;
(statearr_16432_16584[(2)] = null);

(statearr_16432_16584[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16427 === (7))){
var inst_16422 = (state_16426[(2)]);
var state_16426__$1 = state_16426;
var statearr_16433_16585 = state_16426__$1;
(statearr_16433_16585[(2)] = inst_16422);

(statearr_16433_16585[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__16575,c__16227__auto___16579,G__16413_16576,G__16413_16577__$1,n__4706__auto___16574,jobs,results,process,async))
;
return ((function (__16575,switch__16152__auto__,c__16227__auto___16579,G__16413_16576,G__16413_16577__$1,n__4706__auto___16574,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0 = (function (){
var statearr_16434 = [null,null,null,null,null,null,null];
(statearr_16434[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__);

(statearr_16434[(1)] = (1));

return statearr_16434;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1 = (function (state_16426){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_16426);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e16435){var ex__16156__auto__ = e16435;
var statearr_16436_16586 = state_16426;
(statearr_16436_16586[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_16426[(4)]))){
var statearr_16437_16587 = state_16426;
(statearr_16437_16587[(1)] = cljs.core.first((state_16426[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__16588 = state_16426;
state_16426 = G__16588;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__ = function(state_16426){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1.call(this,state_16426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__;
})()
;})(__16575,switch__16152__auto__,c__16227__auto___16579,G__16413_16576,G__16413_16577__$1,n__4706__auto___16574,jobs,results,process,async))
})();
var state__16229__auto__ = (function (){var statearr_16438 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_16438[(6)] = c__16227__auto___16579);

return statearr_16438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
});})(__16575,c__16227__auto___16579,G__16413_16576,G__16413_16577__$1,n__4706__auto___16574,jobs,results,process,async))
);


break;
case "async":
var c__16227__auto___16589 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__16575,c__16227__auto___16589,G__16413_16576,G__16413_16577__$1,n__4706__auto___16574,jobs,results,process,async){
return (function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = ((function (__16575,c__16227__auto___16589,G__16413_16576,G__16413_16577__$1,n__4706__auto___16574,jobs,results,process,async){
return (function (state_16451){
var state_val_16452 = (state_16451[(1)]);
if((state_val_16452 === (1))){
var state_16451__$1 = state_16451;
var statearr_16453_16590 = state_16451__$1;
(statearr_16453_16590[(2)] = null);

(statearr_16453_16590[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16452 === (2))){
var state_16451__$1 = state_16451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16451__$1,(4),jobs);
} else {
if((state_val_16452 === (3))){
var inst_16449 = (state_16451[(2)]);
var state_16451__$1 = state_16451;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16451__$1,inst_16449);
} else {
if((state_val_16452 === (4))){
var inst_16441 = (state_16451[(2)]);
var inst_16442 = async(inst_16441);
var state_16451__$1 = state_16451;
if(cljs.core.truth_(inst_16442)){
var statearr_16454_16591 = state_16451__$1;
(statearr_16454_16591[(1)] = (5));

} else {
var statearr_16455_16592 = state_16451__$1;
(statearr_16455_16592[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16452 === (5))){
var state_16451__$1 = state_16451;
var statearr_16456_16593 = state_16451__$1;
(statearr_16456_16593[(2)] = null);

(statearr_16456_16593[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16452 === (6))){
var state_16451__$1 = state_16451;
var statearr_16457_16594 = state_16451__$1;
(statearr_16457_16594[(2)] = null);

(statearr_16457_16594[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16452 === (7))){
var inst_16447 = (state_16451[(2)]);
var state_16451__$1 = state_16451;
var statearr_16458_16595 = state_16451__$1;
(statearr_16458_16595[(2)] = inst_16447);

(statearr_16458_16595[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__16575,c__16227__auto___16589,G__16413_16576,G__16413_16577__$1,n__4706__auto___16574,jobs,results,process,async))
;
return ((function (__16575,switch__16152__auto__,c__16227__auto___16589,G__16413_16576,G__16413_16577__$1,n__4706__auto___16574,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0 = (function (){
var statearr_16459 = [null,null,null,null,null,null,null];
(statearr_16459[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__);

(statearr_16459[(1)] = (1));

return statearr_16459;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1 = (function (state_16451){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_16451);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e16460){var ex__16156__auto__ = e16460;
var statearr_16461_16596 = state_16451;
(statearr_16461_16596[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_16451[(4)]))){
var statearr_16462_16597 = state_16451;
(statearr_16462_16597[(1)] = cljs.core.first((state_16451[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__16598 = state_16451;
state_16451 = G__16598;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__ = function(state_16451){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1.call(this,state_16451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__;
})()
;})(__16575,switch__16152__auto__,c__16227__auto___16589,G__16413_16576,G__16413_16577__$1,n__4706__auto___16574,jobs,results,process,async))
})();
var state__16229__auto__ = (function (){var statearr_16463 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_16463[(6)] = c__16227__auto___16589);

return statearr_16463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
});})(__16575,c__16227__auto___16589,G__16413_16576,G__16413_16577__$1,n__4706__auto___16574,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__16413_16577__$1)].join('')));

}

var G__16599 = (__16575 + (1));
__16575 = G__16599;
continue;
} else {
}
break;
}

var c__16227__auto___16600 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_16485){
var state_val_16486 = (state_16485[(1)]);
if((state_val_16486 === (7))){
var inst_16481 = (state_16485[(2)]);
var state_16485__$1 = state_16485;
var statearr_16487_16601 = state_16485__$1;
(statearr_16487_16601[(2)] = inst_16481);

(statearr_16487_16601[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16486 === (1))){
var state_16485__$1 = state_16485;
var statearr_16488_16602 = state_16485__$1;
(statearr_16488_16602[(2)] = null);

(statearr_16488_16602[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16486 === (4))){
var inst_16466 = (state_16485[(7)]);
var inst_16466__$1 = (state_16485[(2)]);
var inst_16467 = (inst_16466__$1 == null);
var state_16485__$1 = (function (){var statearr_16489 = state_16485;
(statearr_16489[(7)] = inst_16466__$1);

return statearr_16489;
})();
if(cljs.core.truth_(inst_16467)){
var statearr_16490_16603 = state_16485__$1;
(statearr_16490_16603[(1)] = (5));

} else {
var statearr_16491_16604 = state_16485__$1;
(statearr_16491_16604[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16486 === (6))){
var inst_16471 = (state_16485[(8)]);
var inst_16466 = (state_16485[(7)]);
var inst_16471__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_16472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16473 = [inst_16466,inst_16471__$1];
var inst_16474 = (new cljs.core.PersistentVector(null,2,(5),inst_16472,inst_16473,null));
var state_16485__$1 = (function (){var statearr_16492 = state_16485;
(statearr_16492[(8)] = inst_16471__$1);

return statearr_16492;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16485__$1,(8),jobs,inst_16474);
} else {
if((state_val_16486 === (3))){
var inst_16483 = (state_16485[(2)]);
var state_16485__$1 = state_16485;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16485__$1,inst_16483);
} else {
if((state_val_16486 === (2))){
var state_16485__$1 = state_16485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16485__$1,(4),from);
} else {
if((state_val_16486 === (9))){
var inst_16478 = (state_16485[(2)]);
var state_16485__$1 = (function (){var statearr_16493 = state_16485;
(statearr_16493[(9)] = inst_16478);

return statearr_16493;
})();
var statearr_16494_16605 = state_16485__$1;
(statearr_16494_16605[(2)] = null);

(statearr_16494_16605[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16486 === (5))){
var inst_16469 = cljs.core.async.close_BANG_(jobs);
var state_16485__$1 = state_16485;
var statearr_16495_16606 = state_16485__$1;
(statearr_16495_16606[(2)] = inst_16469);

(statearr_16495_16606[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16486 === (8))){
var inst_16471 = (state_16485[(8)]);
var inst_16476 = (state_16485[(2)]);
var state_16485__$1 = (function (){var statearr_16496 = state_16485;
(statearr_16496[(10)] = inst_16476);

return statearr_16496;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16485__$1,(9),results,inst_16471);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0 = (function (){
var statearr_16497 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16497[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__);

(statearr_16497[(1)] = (1));

return statearr_16497;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1 = (function (state_16485){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_16485);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e16498){var ex__16156__auto__ = e16498;
var statearr_16499_16607 = state_16485;
(statearr_16499_16607[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_16485[(4)]))){
var statearr_16500_16608 = state_16485;
(statearr_16500_16608[(1)] = cljs.core.first((state_16485[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__16609 = state_16485;
state_16485 = G__16609;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__ = function(state_16485){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1.call(this,state_16485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_16501 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_16501[(6)] = c__16227__auto___16600);

return statearr_16501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_16539){
var state_val_16540 = (state_16539[(1)]);
if((state_val_16540 === (7))){
var inst_16535 = (state_16539[(2)]);
var state_16539__$1 = state_16539;
var statearr_16541_16610 = state_16539__$1;
(statearr_16541_16610[(2)] = inst_16535);

(statearr_16541_16610[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (20))){
var state_16539__$1 = state_16539;
var statearr_16542_16611 = state_16539__$1;
(statearr_16542_16611[(2)] = null);

(statearr_16542_16611[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (1))){
var state_16539__$1 = state_16539;
var statearr_16543_16612 = state_16539__$1;
(statearr_16543_16612[(2)] = null);

(statearr_16543_16612[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (4))){
var inst_16504 = (state_16539[(7)]);
var inst_16504__$1 = (state_16539[(2)]);
var inst_16505 = (inst_16504__$1 == null);
var state_16539__$1 = (function (){var statearr_16544 = state_16539;
(statearr_16544[(7)] = inst_16504__$1);

return statearr_16544;
})();
if(cljs.core.truth_(inst_16505)){
var statearr_16545_16613 = state_16539__$1;
(statearr_16545_16613[(1)] = (5));

} else {
var statearr_16546_16614 = state_16539__$1;
(statearr_16546_16614[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (15))){
var inst_16517 = (state_16539[(8)]);
var state_16539__$1 = state_16539;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16539__$1,(18),to,inst_16517);
} else {
if((state_val_16540 === (21))){
var inst_16530 = (state_16539[(2)]);
var state_16539__$1 = state_16539;
var statearr_16547_16615 = state_16539__$1;
(statearr_16547_16615[(2)] = inst_16530);

(statearr_16547_16615[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (13))){
var inst_16532 = (state_16539[(2)]);
var state_16539__$1 = (function (){var statearr_16548 = state_16539;
(statearr_16548[(9)] = inst_16532);

return statearr_16548;
})();
var statearr_16549_16616 = state_16539__$1;
(statearr_16549_16616[(2)] = null);

(statearr_16549_16616[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (6))){
var inst_16504 = (state_16539[(7)]);
var state_16539__$1 = state_16539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16539__$1,(11),inst_16504);
} else {
if((state_val_16540 === (17))){
var inst_16525 = (state_16539[(2)]);
var state_16539__$1 = state_16539;
if(cljs.core.truth_(inst_16525)){
var statearr_16550_16617 = state_16539__$1;
(statearr_16550_16617[(1)] = (19));

} else {
var statearr_16551_16618 = state_16539__$1;
(statearr_16551_16618[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (3))){
var inst_16537 = (state_16539[(2)]);
var state_16539__$1 = state_16539;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16539__$1,inst_16537);
} else {
if((state_val_16540 === (12))){
var inst_16514 = (state_16539[(10)]);
var state_16539__$1 = state_16539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16539__$1,(14),inst_16514);
} else {
if((state_val_16540 === (2))){
var state_16539__$1 = state_16539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16539__$1,(4),results);
} else {
if((state_val_16540 === (19))){
var state_16539__$1 = state_16539;
var statearr_16552_16619 = state_16539__$1;
(statearr_16552_16619[(2)] = null);

(statearr_16552_16619[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (11))){
var inst_16514 = (state_16539[(2)]);
var state_16539__$1 = (function (){var statearr_16553 = state_16539;
(statearr_16553[(10)] = inst_16514);

return statearr_16553;
})();
var statearr_16554_16620 = state_16539__$1;
(statearr_16554_16620[(2)] = null);

(statearr_16554_16620[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (9))){
var state_16539__$1 = state_16539;
var statearr_16555_16621 = state_16539__$1;
(statearr_16555_16621[(2)] = null);

(statearr_16555_16621[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (5))){
var state_16539__$1 = state_16539;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16556_16622 = state_16539__$1;
(statearr_16556_16622[(1)] = (8));

} else {
var statearr_16557_16623 = state_16539__$1;
(statearr_16557_16623[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (14))){
var inst_16519 = (state_16539[(11)]);
var inst_16517 = (state_16539[(8)]);
var inst_16517__$1 = (state_16539[(2)]);
var inst_16518 = (inst_16517__$1 == null);
var inst_16519__$1 = cljs.core.not(inst_16518);
var state_16539__$1 = (function (){var statearr_16558 = state_16539;
(statearr_16558[(11)] = inst_16519__$1);

(statearr_16558[(8)] = inst_16517__$1);

return statearr_16558;
})();
if(inst_16519__$1){
var statearr_16559_16624 = state_16539__$1;
(statearr_16559_16624[(1)] = (15));

} else {
var statearr_16560_16625 = state_16539__$1;
(statearr_16560_16625[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (16))){
var inst_16519 = (state_16539[(11)]);
var state_16539__$1 = state_16539;
var statearr_16561_16626 = state_16539__$1;
(statearr_16561_16626[(2)] = inst_16519);

(statearr_16561_16626[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (10))){
var inst_16511 = (state_16539[(2)]);
var state_16539__$1 = state_16539;
var statearr_16562_16627 = state_16539__$1;
(statearr_16562_16627[(2)] = inst_16511);

(statearr_16562_16627[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (18))){
var inst_16522 = (state_16539[(2)]);
var state_16539__$1 = state_16539;
var statearr_16563_16628 = state_16539__$1;
(statearr_16563_16628[(2)] = inst_16522);

(statearr_16563_16628[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16540 === (8))){
var inst_16508 = cljs.core.async.close_BANG_(to);
var state_16539__$1 = state_16539;
var statearr_16564_16629 = state_16539__$1;
(statearr_16564_16629[(2)] = inst_16508);

(statearr_16564_16629[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0 = (function (){
var statearr_16565 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16565[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__);

(statearr_16565[(1)] = (1));

return statearr_16565;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1 = (function (state_16539){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_16539);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e16566){var ex__16156__auto__ = e16566;
var statearr_16567_16630 = state_16539;
(statearr_16567_16630[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_16539[(4)]))){
var statearr_16568_16631 = state_16539;
(statearr_16568_16631[(1)] = cljs.core.first((state_16539[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__16632 = state_16539;
state_16539 = G__16632;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__ = function(state_16539){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1.call(this,state_16539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16153__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_16569 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_16569[(6)] = c__16227__auto__);

return statearr_16569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__16634 = arguments.length;
switch (G__16634) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__16637 = arguments.length;
switch (G__16637) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__16640 = arguments.length;
switch (G__16640) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__16227__auto___16690 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_16666){
var state_val_16667 = (state_16666[(1)]);
if((state_val_16667 === (7))){
var inst_16662 = (state_16666[(2)]);
var state_16666__$1 = state_16666;
var statearr_16668_16691 = state_16666__$1;
(statearr_16668_16691[(2)] = inst_16662);

(statearr_16668_16691[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16667 === (1))){
var state_16666__$1 = state_16666;
var statearr_16669_16692 = state_16666__$1;
(statearr_16669_16692[(2)] = null);

(statearr_16669_16692[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16667 === (4))){
var inst_16643 = (state_16666[(7)]);
var inst_16643__$1 = (state_16666[(2)]);
var inst_16644 = (inst_16643__$1 == null);
var state_16666__$1 = (function (){var statearr_16670 = state_16666;
(statearr_16670[(7)] = inst_16643__$1);

return statearr_16670;
})();
if(cljs.core.truth_(inst_16644)){
var statearr_16671_16693 = state_16666__$1;
(statearr_16671_16693[(1)] = (5));

} else {
var statearr_16672_16694 = state_16666__$1;
(statearr_16672_16694[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16667 === (13))){
var state_16666__$1 = state_16666;
var statearr_16673_16695 = state_16666__$1;
(statearr_16673_16695[(2)] = null);

(statearr_16673_16695[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16667 === (6))){
var inst_16643 = (state_16666[(7)]);
var inst_16649 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_16643) : p.call(null,inst_16643));
var state_16666__$1 = state_16666;
if(cljs.core.truth_(inst_16649)){
var statearr_16674_16696 = state_16666__$1;
(statearr_16674_16696[(1)] = (9));

} else {
var statearr_16675_16697 = state_16666__$1;
(statearr_16675_16697[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16667 === (3))){
var inst_16664 = (state_16666[(2)]);
var state_16666__$1 = state_16666;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16666__$1,inst_16664);
} else {
if((state_val_16667 === (12))){
var state_16666__$1 = state_16666;
var statearr_16676_16698 = state_16666__$1;
(statearr_16676_16698[(2)] = null);

(statearr_16676_16698[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16667 === (2))){
var state_16666__$1 = state_16666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16666__$1,(4),ch);
} else {
if((state_val_16667 === (11))){
var inst_16643 = (state_16666[(7)]);
var inst_16653 = (state_16666[(2)]);
var state_16666__$1 = state_16666;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16666__$1,(8),inst_16653,inst_16643);
} else {
if((state_val_16667 === (9))){
var state_16666__$1 = state_16666;
var statearr_16677_16699 = state_16666__$1;
(statearr_16677_16699[(2)] = tc);

(statearr_16677_16699[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16667 === (5))){
var inst_16646 = cljs.core.async.close_BANG_(tc);
var inst_16647 = cljs.core.async.close_BANG_(fc);
var state_16666__$1 = (function (){var statearr_16678 = state_16666;
(statearr_16678[(8)] = inst_16646);

return statearr_16678;
})();
var statearr_16679_16700 = state_16666__$1;
(statearr_16679_16700[(2)] = inst_16647);

(statearr_16679_16700[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16667 === (14))){
var inst_16660 = (state_16666[(2)]);
var state_16666__$1 = state_16666;
var statearr_16680_16701 = state_16666__$1;
(statearr_16680_16701[(2)] = inst_16660);

(statearr_16680_16701[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16667 === (10))){
var state_16666__$1 = state_16666;
var statearr_16681_16702 = state_16666__$1;
(statearr_16681_16702[(2)] = fc);

(statearr_16681_16702[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16667 === (8))){
var inst_16655 = (state_16666[(2)]);
var state_16666__$1 = state_16666;
if(cljs.core.truth_(inst_16655)){
var statearr_16682_16703 = state_16666__$1;
(statearr_16682_16703[(1)] = (12));

} else {
var statearr_16683_16704 = state_16666__$1;
(statearr_16683_16704[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16153__auto__ = null;
var cljs$core$async$state_machine__16153__auto____0 = (function (){
var statearr_16684 = [null,null,null,null,null,null,null,null,null];
(statearr_16684[(0)] = cljs$core$async$state_machine__16153__auto__);

(statearr_16684[(1)] = (1));

return statearr_16684;
});
var cljs$core$async$state_machine__16153__auto____1 = (function (state_16666){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_16666);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e16685){var ex__16156__auto__ = e16685;
var statearr_16686_16705 = state_16666;
(statearr_16686_16705[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_16666[(4)]))){
var statearr_16687_16706 = state_16666;
(statearr_16687_16706[(1)] = cljs.core.first((state_16666[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__16707 = state_16666;
state_16666 = G__16707;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$state_machine__16153__auto__ = function(state_16666){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16153__auto____1.call(this,state_16666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16153__auto____0;
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16153__auto____1;
return cljs$core$async$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_16688 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_16688[(6)] = c__16227__auto___16690);

return statearr_16688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_16729){
var state_val_16730 = (state_16729[(1)]);
if((state_val_16730 === (7))){
var inst_16725 = (state_16729[(2)]);
var state_16729__$1 = state_16729;
var statearr_16731_16750 = state_16729__$1;
(statearr_16731_16750[(2)] = inst_16725);

(statearr_16731_16750[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16730 === (1))){
var inst_16708 = init;
var inst_16709 = inst_16708;
var state_16729__$1 = (function (){var statearr_16732 = state_16729;
(statearr_16732[(7)] = inst_16709);

return statearr_16732;
})();
var statearr_16733_16751 = state_16729__$1;
(statearr_16733_16751[(2)] = null);

(statearr_16733_16751[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16730 === (4))){
var inst_16712 = (state_16729[(8)]);
var inst_16712__$1 = (state_16729[(2)]);
var inst_16713 = (inst_16712__$1 == null);
var state_16729__$1 = (function (){var statearr_16734 = state_16729;
(statearr_16734[(8)] = inst_16712__$1);

return statearr_16734;
})();
if(cljs.core.truth_(inst_16713)){
var statearr_16735_16752 = state_16729__$1;
(statearr_16735_16752[(1)] = (5));

} else {
var statearr_16736_16753 = state_16729__$1;
(statearr_16736_16753[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16730 === (6))){
var inst_16709 = (state_16729[(7)]);
var inst_16716 = (state_16729[(9)]);
var inst_16712 = (state_16729[(8)]);
var inst_16716__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_16709,inst_16712) : f.call(null,inst_16709,inst_16712));
var inst_16717 = cljs.core.reduced_QMARK_(inst_16716__$1);
var state_16729__$1 = (function (){var statearr_16737 = state_16729;
(statearr_16737[(9)] = inst_16716__$1);

return statearr_16737;
})();
if(inst_16717){
var statearr_16738_16754 = state_16729__$1;
(statearr_16738_16754[(1)] = (8));

} else {
var statearr_16739_16755 = state_16729__$1;
(statearr_16739_16755[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16730 === (3))){
var inst_16727 = (state_16729[(2)]);
var state_16729__$1 = state_16729;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16729__$1,inst_16727);
} else {
if((state_val_16730 === (2))){
var state_16729__$1 = state_16729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16729__$1,(4),ch);
} else {
if((state_val_16730 === (9))){
var inst_16716 = (state_16729[(9)]);
var inst_16709 = inst_16716;
var state_16729__$1 = (function (){var statearr_16740 = state_16729;
(statearr_16740[(7)] = inst_16709);

return statearr_16740;
})();
var statearr_16741_16756 = state_16729__$1;
(statearr_16741_16756[(2)] = null);

(statearr_16741_16756[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16730 === (5))){
var inst_16709 = (state_16729[(7)]);
var state_16729__$1 = state_16729;
var statearr_16742_16757 = state_16729__$1;
(statearr_16742_16757[(2)] = inst_16709);

(statearr_16742_16757[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16730 === (10))){
var inst_16723 = (state_16729[(2)]);
var state_16729__$1 = state_16729;
var statearr_16743_16758 = state_16729__$1;
(statearr_16743_16758[(2)] = inst_16723);

(statearr_16743_16758[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16730 === (8))){
var inst_16716 = (state_16729[(9)]);
var inst_16719 = cljs.core.deref(inst_16716);
var state_16729__$1 = state_16729;
var statearr_16744_16759 = state_16729__$1;
(statearr_16744_16759[(2)] = inst_16719);

(statearr_16744_16759[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__16153__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16153__auto____0 = (function (){
var statearr_16745 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16745[(0)] = cljs$core$async$reduce_$_state_machine__16153__auto__);

(statearr_16745[(1)] = (1));

return statearr_16745;
});
var cljs$core$async$reduce_$_state_machine__16153__auto____1 = (function (state_16729){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_16729);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e16746){var ex__16156__auto__ = e16746;
var statearr_16747_16760 = state_16729;
(statearr_16747_16760[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_16729[(4)]))){
var statearr_16748_16761 = state_16729;
(statearr_16748_16761[(1)] = cljs.core.first((state_16729[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__16762 = state_16729;
state_16729 = G__16762;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16153__auto__ = function(state_16729){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16153__auto____1.call(this,state_16729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16153__auto____0;
cljs$core$async$reduce_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16153__auto____1;
return cljs$core$async$reduce_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_16749 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_16749[(6)] = c__16227__auto__);

return statearr_16749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_16768){
var state_val_16769 = (state_16768[(1)]);
if((state_val_16769 === (1))){
var inst_16763 = cljs.core.async.reduce(f__$1,init,ch);
var state_16768__$1 = state_16768;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16768__$1,(2),inst_16763);
} else {
if((state_val_16769 === (2))){
var inst_16765 = (state_16768[(2)]);
var inst_16766 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_16765) : f__$1.call(null,inst_16765));
var state_16768__$1 = state_16768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16768__$1,inst_16766);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__16153__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16153__auto____0 = (function (){
var statearr_16770 = [null,null,null,null,null,null,null];
(statearr_16770[(0)] = cljs$core$async$transduce_$_state_machine__16153__auto__);

(statearr_16770[(1)] = (1));

return statearr_16770;
});
var cljs$core$async$transduce_$_state_machine__16153__auto____1 = (function (state_16768){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_16768);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e16771){var ex__16156__auto__ = e16771;
var statearr_16772_16775 = state_16768;
(statearr_16772_16775[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_16768[(4)]))){
var statearr_16773_16776 = state_16768;
(statearr_16773_16776[(1)] = cljs.core.first((state_16768[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__16777 = state_16768;
state_16768 = G__16777;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16153__auto__ = function(state_16768){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16153__auto____1.call(this,state_16768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16153__auto____0;
cljs$core$async$transduce_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16153__auto____1;
return cljs$core$async$transduce_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_16774 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_16774[(6)] = c__16227__auto__);

return statearr_16774;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__16779 = arguments.length;
switch (G__16779) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_16804){
var state_val_16805 = (state_16804[(1)]);
if((state_val_16805 === (7))){
var inst_16786 = (state_16804[(2)]);
var state_16804__$1 = state_16804;
var statearr_16806_16828 = state_16804__$1;
(statearr_16806_16828[(2)] = inst_16786);

(statearr_16806_16828[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16805 === (1))){
var inst_16780 = cljs.core.seq(coll);
var inst_16781 = inst_16780;
var state_16804__$1 = (function (){var statearr_16807 = state_16804;
(statearr_16807[(7)] = inst_16781);

return statearr_16807;
})();
var statearr_16808_16829 = state_16804__$1;
(statearr_16808_16829[(2)] = null);

(statearr_16808_16829[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16805 === (4))){
var inst_16781 = (state_16804[(7)]);
var inst_16784 = cljs.core.first(inst_16781);
var state_16804__$1 = state_16804;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16804__$1,(7),ch,inst_16784);
} else {
if((state_val_16805 === (13))){
var inst_16798 = (state_16804[(2)]);
var state_16804__$1 = state_16804;
var statearr_16809_16830 = state_16804__$1;
(statearr_16809_16830[(2)] = inst_16798);

(statearr_16809_16830[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16805 === (6))){
var inst_16789 = (state_16804[(2)]);
var state_16804__$1 = state_16804;
if(cljs.core.truth_(inst_16789)){
var statearr_16810_16831 = state_16804__$1;
(statearr_16810_16831[(1)] = (8));

} else {
var statearr_16811_16832 = state_16804__$1;
(statearr_16811_16832[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16805 === (3))){
var inst_16802 = (state_16804[(2)]);
var state_16804__$1 = state_16804;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16804__$1,inst_16802);
} else {
if((state_val_16805 === (12))){
var state_16804__$1 = state_16804;
var statearr_16812_16833 = state_16804__$1;
(statearr_16812_16833[(2)] = null);

(statearr_16812_16833[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16805 === (2))){
var inst_16781 = (state_16804[(7)]);
var state_16804__$1 = state_16804;
if(cljs.core.truth_(inst_16781)){
var statearr_16813_16834 = state_16804__$1;
(statearr_16813_16834[(1)] = (4));

} else {
var statearr_16814_16835 = state_16804__$1;
(statearr_16814_16835[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16805 === (11))){
var inst_16795 = cljs.core.async.close_BANG_(ch);
var state_16804__$1 = state_16804;
var statearr_16815_16836 = state_16804__$1;
(statearr_16815_16836[(2)] = inst_16795);

(statearr_16815_16836[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16805 === (9))){
var state_16804__$1 = state_16804;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16816_16837 = state_16804__$1;
(statearr_16816_16837[(1)] = (11));

} else {
var statearr_16817_16838 = state_16804__$1;
(statearr_16817_16838[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16805 === (5))){
var inst_16781 = (state_16804[(7)]);
var state_16804__$1 = state_16804;
var statearr_16818_16839 = state_16804__$1;
(statearr_16818_16839[(2)] = inst_16781);

(statearr_16818_16839[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16805 === (10))){
var inst_16800 = (state_16804[(2)]);
var state_16804__$1 = state_16804;
var statearr_16819_16840 = state_16804__$1;
(statearr_16819_16840[(2)] = inst_16800);

(statearr_16819_16840[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16805 === (8))){
var inst_16781 = (state_16804[(7)]);
var inst_16791 = cljs.core.next(inst_16781);
var inst_16781__$1 = inst_16791;
var state_16804__$1 = (function (){var statearr_16820 = state_16804;
(statearr_16820[(7)] = inst_16781__$1);

return statearr_16820;
})();
var statearr_16821_16841 = state_16804__$1;
(statearr_16821_16841[(2)] = null);

(statearr_16821_16841[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16153__auto__ = null;
var cljs$core$async$state_machine__16153__auto____0 = (function (){
var statearr_16822 = [null,null,null,null,null,null,null,null];
(statearr_16822[(0)] = cljs$core$async$state_machine__16153__auto__);

(statearr_16822[(1)] = (1));

return statearr_16822;
});
var cljs$core$async$state_machine__16153__auto____1 = (function (state_16804){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_16804);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e16823){var ex__16156__auto__ = e16823;
var statearr_16824_16842 = state_16804;
(statearr_16824_16842[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_16804[(4)]))){
var statearr_16825_16843 = state_16804;
(statearr_16825_16843[(1)] = cljs.core.first((state_16804[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__16844 = state_16804;
state_16804 = G__16844;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$state_machine__16153__auto__ = function(state_16804){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16153__auto____1.call(this,state_16804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16153__auto____0;
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16153__auto____1;
return cljs$core$async$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_16826 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_16826[(6)] = c__16227__auto__);

return statearr_16826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__16846 = arguments.length;
switch (G__16846) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_16848 = (function (_){
var x__4521__auto__ = (((_ == null))?null:_);
var m__4522__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4522__auto__.call(null,_));
} else {
var m__4519__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4519__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_16848(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_16849 = (function (m,ch,close_QMARK_){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4522__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4519__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4519__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_16849(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_16850 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_16850(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_16851 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4522__auto__.call(null,m));
} else {
var m__4519__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4519__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_16851(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16852 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16852 = (function (ch,cs,meta16853){
this.ch = ch;
this.cs = cs;
this.meta16853 = meta16853;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16852.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16854,meta16853__$1){
var self__ = this;
var _16854__$1 = this;
return (new cljs.core.async.t_cljs$core$async16852(self__.ch,self__.cs,meta16853__$1));
}));

(cljs.core.async.t_cljs$core$async16852.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16854){
var self__ = this;
var _16854__$1 = this;
return self__.meta16853;
}));

(cljs.core.async.t_cljs$core$async16852.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16852.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async16852.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16852.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async16852.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async16852.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async16852.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta16853], null);
}));

(cljs.core.async.t_cljs$core$async16852.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16852.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16852");

(cljs.core.async.t_cljs$core$async16852.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async16852");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16852.
 */
cljs.core.async.__GT_t_cljs$core$async16852 = (function cljs$core$async$mult_$___GT_t_cljs$core$async16852(ch__$1,cs__$1,meta16853){
return (new cljs.core.async.t_cljs$core$async16852(ch__$1,cs__$1,meta16853));
});

}

return (new cljs.core.async.t_cljs$core$async16852(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__16227__auto___17071 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_16987){
var state_val_16988 = (state_16987[(1)]);
if((state_val_16988 === (7))){
var inst_16983 = (state_16987[(2)]);
var state_16987__$1 = state_16987;
var statearr_16989_17072 = state_16987__$1;
(statearr_16989_17072[(2)] = inst_16983);

(statearr_16989_17072[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (20))){
var inst_16888 = (state_16987[(7)]);
var inst_16900 = cljs.core.first(inst_16888);
var inst_16901 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16900,(0),null);
var inst_16902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16900,(1),null);
var state_16987__$1 = (function (){var statearr_16990 = state_16987;
(statearr_16990[(8)] = inst_16901);

return statearr_16990;
})();
if(cljs.core.truth_(inst_16902)){
var statearr_16991_17073 = state_16987__$1;
(statearr_16991_17073[(1)] = (22));

} else {
var statearr_16992_17074 = state_16987__$1;
(statearr_16992_17074[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (27))){
var inst_16932 = (state_16987[(9)]);
var inst_16937 = (state_16987[(10)]);
var inst_16930 = (state_16987[(11)]);
var inst_16857 = (state_16987[(12)]);
var inst_16937__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16930,inst_16932);
var inst_16938 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_16937__$1,inst_16857,done);
var state_16987__$1 = (function (){var statearr_16993 = state_16987;
(statearr_16993[(10)] = inst_16937__$1);

return statearr_16993;
})();
if(cljs.core.truth_(inst_16938)){
var statearr_16994_17075 = state_16987__$1;
(statearr_16994_17075[(1)] = (30));

} else {
var statearr_16995_17076 = state_16987__$1;
(statearr_16995_17076[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (1))){
var state_16987__$1 = state_16987;
var statearr_16996_17077 = state_16987__$1;
(statearr_16996_17077[(2)] = null);

(statearr_16996_17077[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (24))){
var inst_16888 = (state_16987[(7)]);
var inst_16907 = (state_16987[(2)]);
var inst_16908 = cljs.core.next(inst_16888);
var inst_16866 = inst_16908;
var inst_16867 = null;
var inst_16868 = (0);
var inst_16869 = (0);
var state_16987__$1 = (function (){var statearr_16997 = state_16987;
(statearr_16997[(13)] = inst_16866);

(statearr_16997[(14)] = inst_16907);

(statearr_16997[(15)] = inst_16868);

(statearr_16997[(16)] = inst_16867);

(statearr_16997[(17)] = inst_16869);

return statearr_16997;
})();
var statearr_16998_17078 = state_16987__$1;
(statearr_16998_17078[(2)] = null);

(statearr_16998_17078[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (39))){
var state_16987__$1 = state_16987;
var statearr_17002_17079 = state_16987__$1;
(statearr_17002_17079[(2)] = null);

(statearr_17002_17079[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (4))){
var inst_16857 = (state_16987[(12)]);
var inst_16857__$1 = (state_16987[(2)]);
var inst_16858 = (inst_16857__$1 == null);
var state_16987__$1 = (function (){var statearr_17003 = state_16987;
(statearr_17003[(12)] = inst_16857__$1);

return statearr_17003;
})();
if(cljs.core.truth_(inst_16858)){
var statearr_17004_17080 = state_16987__$1;
(statearr_17004_17080[(1)] = (5));

} else {
var statearr_17005_17081 = state_16987__$1;
(statearr_17005_17081[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (15))){
var inst_16866 = (state_16987[(13)]);
var inst_16868 = (state_16987[(15)]);
var inst_16867 = (state_16987[(16)]);
var inst_16869 = (state_16987[(17)]);
var inst_16884 = (state_16987[(2)]);
var inst_16885 = (inst_16869 + (1));
var tmp16999 = inst_16866;
var tmp17000 = inst_16868;
var tmp17001 = inst_16867;
var inst_16866__$1 = tmp16999;
var inst_16867__$1 = tmp17001;
var inst_16868__$1 = tmp17000;
var inst_16869__$1 = inst_16885;
var state_16987__$1 = (function (){var statearr_17006 = state_16987;
(statearr_17006[(13)] = inst_16866__$1);

(statearr_17006[(18)] = inst_16884);

(statearr_17006[(15)] = inst_16868__$1);

(statearr_17006[(16)] = inst_16867__$1);

(statearr_17006[(17)] = inst_16869__$1);

return statearr_17006;
})();
var statearr_17007_17082 = state_16987__$1;
(statearr_17007_17082[(2)] = null);

(statearr_17007_17082[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (21))){
var inst_16911 = (state_16987[(2)]);
var state_16987__$1 = state_16987;
var statearr_17011_17083 = state_16987__$1;
(statearr_17011_17083[(2)] = inst_16911);

(statearr_17011_17083[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (31))){
var inst_16937 = (state_16987[(10)]);
var inst_16941 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_16937);
var state_16987__$1 = state_16987;
var statearr_17012_17084 = state_16987__$1;
(statearr_17012_17084[(2)] = inst_16941);

(statearr_17012_17084[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (32))){
var inst_16932 = (state_16987[(9)]);
var inst_16930 = (state_16987[(11)]);
var inst_16931 = (state_16987[(19)]);
var inst_16929 = (state_16987[(20)]);
var inst_16943 = (state_16987[(2)]);
var inst_16944 = (inst_16932 + (1));
var tmp17008 = inst_16930;
var tmp17009 = inst_16931;
var tmp17010 = inst_16929;
var inst_16929__$1 = tmp17010;
var inst_16930__$1 = tmp17008;
var inst_16931__$1 = tmp17009;
var inst_16932__$1 = inst_16944;
var state_16987__$1 = (function (){var statearr_17013 = state_16987;
(statearr_17013[(21)] = inst_16943);

(statearr_17013[(9)] = inst_16932__$1);

(statearr_17013[(11)] = inst_16930__$1);

(statearr_17013[(19)] = inst_16931__$1);

(statearr_17013[(20)] = inst_16929__$1);

return statearr_17013;
})();
var statearr_17014_17085 = state_16987__$1;
(statearr_17014_17085[(2)] = null);

(statearr_17014_17085[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (40))){
var inst_16956 = (state_16987[(22)]);
var inst_16960 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_16956);
var state_16987__$1 = state_16987;
var statearr_17015_17086 = state_16987__$1;
(statearr_17015_17086[(2)] = inst_16960);

(statearr_17015_17086[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (33))){
var inst_16947 = (state_16987[(23)]);
var inst_16949 = cljs.core.chunked_seq_QMARK_(inst_16947);
var state_16987__$1 = state_16987;
if(inst_16949){
var statearr_17016_17087 = state_16987__$1;
(statearr_17016_17087[(1)] = (36));

} else {
var statearr_17017_17088 = state_16987__$1;
(statearr_17017_17088[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (13))){
var inst_16878 = (state_16987[(24)]);
var inst_16881 = cljs.core.async.close_BANG_(inst_16878);
var state_16987__$1 = state_16987;
var statearr_17018_17089 = state_16987__$1;
(statearr_17018_17089[(2)] = inst_16881);

(statearr_17018_17089[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (22))){
var inst_16901 = (state_16987[(8)]);
var inst_16904 = cljs.core.async.close_BANG_(inst_16901);
var state_16987__$1 = state_16987;
var statearr_17019_17090 = state_16987__$1;
(statearr_17019_17090[(2)] = inst_16904);

(statearr_17019_17090[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (36))){
var inst_16947 = (state_16987[(23)]);
var inst_16951 = cljs.core.chunk_first(inst_16947);
var inst_16952 = cljs.core.chunk_rest(inst_16947);
var inst_16953 = cljs.core.count(inst_16951);
var inst_16929 = inst_16952;
var inst_16930 = inst_16951;
var inst_16931 = inst_16953;
var inst_16932 = (0);
var state_16987__$1 = (function (){var statearr_17020 = state_16987;
(statearr_17020[(9)] = inst_16932);

(statearr_17020[(11)] = inst_16930);

(statearr_17020[(19)] = inst_16931);

(statearr_17020[(20)] = inst_16929);

return statearr_17020;
})();
var statearr_17021_17091 = state_16987__$1;
(statearr_17021_17091[(2)] = null);

(statearr_17021_17091[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (41))){
var inst_16947 = (state_16987[(23)]);
var inst_16962 = (state_16987[(2)]);
var inst_16963 = cljs.core.next(inst_16947);
var inst_16929 = inst_16963;
var inst_16930 = null;
var inst_16931 = (0);
var inst_16932 = (0);
var state_16987__$1 = (function (){var statearr_17022 = state_16987;
(statearr_17022[(9)] = inst_16932);

(statearr_17022[(25)] = inst_16962);

(statearr_17022[(11)] = inst_16930);

(statearr_17022[(19)] = inst_16931);

(statearr_17022[(20)] = inst_16929);

return statearr_17022;
})();
var statearr_17023_17092 = state_16987__$1;
(statearr_17023_17092[(2)] = null);

(statearr_17023_17092[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (43))){
var state_16987__$1 = state_16987;
var statearr_17024_17093 = state_16987__$1;
(statearr_17024_17093[(2)] = null);

(statearr_17024_17093[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (29))){
var inst_16971 = (state_16987[(2)]);
var state_16987__$1 = state_16987;
var statearr_17025_17094 = state_16987__$1;
(statearr_17025_17094[(2)] = inst_16971);

(statearr_17025_17094[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (44))){
var inst_16980 = (state_16987[(2)]);
var state_16987__$1 = (function (){var statearr_17026 = state_16987;
(statearr_17026[(26)] = inst_16980);

return statearr_17026;
})();
var statearr_17027_17095 = state_16987__$1;
(statearr_17027_17095[(2)] = null);

(statearr_17027_17095[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (6))){
var inst_16921 = (state_16987[(27)]);
var inst_16920 = cljs.core.deref(cs);
var inst_16921__$1 = cljs.core.keys(inst_16920);
var inst_16922 = cljs.core.count(inst_16921__$1);
var inst_16923 = cljs.core.reset_BANG_(dctr,inst_16922);
var inst_16928 = cljs.core.seq(inst_16921__$1);
var inst_16929 = inst_16928;
var inst_16930 = null;
var inst_16931 = (0);
var inst_16932 = (0);
var state_16987__$1 = (function (){var statearr_17028 = state_16987;
(statearr_17028[(9)] = inst_16932);

(statearr_17028[(28)] = inst_16923);

(statearr_17028[(11)] = inst_16930);

(statearr_17028[(19)] = inst_16931);

(statearr_17028[(27)] = inst_16921__$1);

(statearr_17028[(20)] = inst_16929);

return statearr_17028;
})();
var statearr_17029_17096 = state_16987__$1;
(statearr_17029_17096[(2)] = null);

(statearr_17029_17096[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (28))){
var inst_16929 = (state_16987[(20)]);
var inst_16947 = (state_16987[(23)]);
var inst_16947__$1 = cljs.core.seq(inst_16929);
var state_16987__$1 = (function (){var statearr_17030 = state_16987;
(statearr_17030[(23)] = inst_16947__$1);

return statearr_17030;
})();
if(inst_16947__$1){
var statearr_17031_17097 = state_16987__$1;
(statearr_17031_17097[(1)] = (33));

} else {
var statearr_17032_17098 = state_16987__$1;
(statearr_17032_17098[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (25))){
var inst_16932 = (state_16987[(9)]);
var inst_16931 = (state_16987[(19)]);
var inst_16934 = (inst_16932 < inst_16931);
var inst_16935 = inst_16934;
var state_16987__$1 = state_16987;
if(cljs.core.truth_(inst_16935)){
var statearr_17033_17099 = state_16987__$1;
(statearr_17033_17099[(1)] = (27));

} else {
var statearr_17034_17100 = state_16987__$1;
(statearr_17034_17100[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (34))){
var state_16987__$1 = state_16987;
var statearr_17035_17101 = state_16987__$1;
(statearr_17035_17101[(2)] = null);

(statearr_17035_17101[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (17))){
var state_16987__$1 = state_16987;
var statearr_17036_17102 = state_16987__$1;
(statearr_17036_17102[(2)] = null);

(statearr_17036_17102[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (3))){
var inst_16985 = (state_16987[(2)]);
var state_16987__$1 = state_16987;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16987__$1,inst_16985);
} else {
if((state_val_16988 === (12))){
var inst_16916 = (state_16987[(2)]);
var state_16987__$1 = state_16987;
var statearr_17037_17103 = state_16987__$1;
(statearr_17037_17103[(2)] = inst_16916);

(statearr_17037_17103[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (2))){
var state_16987__$1 = state_16987;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16987__$1,(4),ch);
} else {
if((state_val_16988 === (23))){
var state_16987__$1 = state_16987;
var statearr_17038_17104 = state_16987__$1;
(statearr_17038_17104[(2)] = null);

(statearr_17038_17104[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (35))){
var inst_16969 = (state_16987[(2)]);
var state_16987__$1 = state_16987;
var statearr_17039_17105 = state_16987__$1;
(statearr_17039_17105[(2)] = inst_16969);

(statearr_17039_17105[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (19))){
var inst_16888 = (state_16987[(7)]);
var inst_16892 = cljs.core.chunk_first(inst_16888);
var inst_16893 = cljs.core.chunk_rest(inst_16888);
var inst_16894 = cljs.core.count(inst_16892);
var inst_16866 = inst_16893;
var inst_16867 = inst_16892;
var inst_16868 = inst_16894;
var inst_16869 = (0);
var state_16987__$1 = (function (){var statearr_17040 = state_16987;
(statearr_17040[(13)] = inst_16866);

(statearr_17040[(15)] = inst_16868);

(statearr_17040[(16)] = inst_16867);

(statearr_17040[(17)] = inst_16869);

return statearr_17040;
})();
var statearr_17041_17106 = state_16987__$1;
(statearr_17041_17106[(2)] = null);

(statearr_17041_17106[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (11))){
var inst_16866 = (state_16987[(13)]);
var inst_16888 = (state_16987[(7)]);
var inst_16888__$1 = cljs.core.seq(inst_16866);
var state_16987__$1 = (function (){var statearr_17042 = state_16987;
(statearr_17042[(7)] = inst_16888__$1);

return statearr_17042;
})();
if(inst_16888__$1){
var statearr_17043_17107 = state_16987__$1;
(statearr_17043_17107[(1)] = (16));

} else {
var statearr_17044_17108 = state_16987__$1;
(statearr_17044_17108[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (9))){
var inst_16918 = (state_16987[(2)]);
var state_16987__$1 = state_16987;
var statearr_17045_17109 = state_16987__$1;
(statearr_17045_17109[(2)] = inst_16918);

(statearr_17045_17109[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (5))){
var inst_16864 = cljs.core.deref(cs);
var inst_16865 = cljs.core.seq(inst_16864);
var inst_16866 = inst_16865;
var inst_16867 = null;
var inst_16868 = (0);
var inst_16869 = (0);
var state_16987__$1 = (function (){var statearr_17046 = state_16987;
(statearr_17046[(13)] = inst_16866);

(statearr_17046[(15)] = inst_16868);

(statearr_17046[(16)] = inst_16867);

(statearr_17046[(17)] = inst_16869);

return statearr_17046;
})();
var statearr_17047_17110 = state_16987__$1;
(statearr_17047_17110[(2)] = null);

(statearr_17047_17110[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (14))){
var state_16987__$1 = state_16987;
var statearr_17048_17111 = state_16987__$1;
(statearr_17048_17111[(2)] = null);

(statearr_17048_17111[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (45))){
var inst_16977 = (state_16987[(2)]);
var state_16987__$1 = state_16987;
var statearr_17049_17112 = state_16987__$1;
(statearr_17049_17112[(2)] = inst_16977);

(statearr_17049_17112[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (26))){
var inst_16921 = (state_16987[(27)]);
var inst_16973 = (state_16987[(2)]);
var inst_16974 = cljs.core.seq(inst_16921);
var state_16987__$1 = (function (){var statearr_17050 = state_16987;
(statearr_17050[(29)] = inst_16973);

return statearr_17050;
})();
if(inst_16974){
var statearr_17051_17113 = state_16987__$1;
(statearr_17051_17113[(1)] = (42));

} else {
var statearr_17052_17114 = state_16987__$1;
(statearr_17052_17114[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (16))){
var inst_16888 = (state_16987[(7)]);
var inst_16890 = cljs.core.chunked_seq_QMARK_(inst_16888);
var state_16987__$1 = state_16987;
if(inst_16890){
var statearr_17053_17115 = state_16987__$1;
(statearr_17053_17115[(1)] = (19));

} else {
var statearr_17054_17116 = state_16987__$1;
(statearr_17054_17116[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (38))){
var inst_16966 = (state_16987[(2)]);
var state_16987__$1 = state_16987;
var statearr_17055_17117 = state_16987__$1;
(statearr_17055_17117[(2)] = inst_16966);

(statearr_17055_17117[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (30))){
var state_16987__$1 = state_16987;
var statearr_17056_17118 = state_16987__$1;
(statearr_17056_17118[(2)] = null);

(statearr_17056_17118[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (10))){
var inst_16867 = (state_16987[(16)]);
var inst_16869 = (state_16987[(17)]);
var inst_16877 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16867,inst_16869);
var inst_16878 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16877,(0),null);
var inst_16879 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16877,(1),null);
var state_16987__$1 = (function (){var statearr_17057 = state_16987;
(statearr_17057[(24)] = inst_16878);

return statearr_17057;
})();
if(cljs.core.truth_(inst_16879)){
var statearr_17058_17119 = state_16987__$1;
(statearr_17058_17119[(1)] = (13));

} else {
var statearr_17059_17120 = state_16987__$1;
(statearr_17059_17120[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (18))){
var inst_16914 = (state_16987[(2)]);
var state_16987__$1 = state_16987;
var statearr_17060_17121 = state_16987__$1;
(statearr_17060_17121[(2)] = inst_16914);

(statearr_17060_17121[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (42))){
var state_16987__$1 = state_16987;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16987__$1,(45),dchan);
} else {
if((state_val_16988 === (37))){
var inst_16956 = (state_16987[(22)]);
var inst_16857 = (state_16987[(12)]);
var inst_16947 = (state_16987[(23)]);
var inst_16956__$1 = cljs.core.first(inst_16947);
var inst_16957 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_16956__$1,inst_16857,done);
var state_16987__$1 = (function (){var statearr_17061 = state_16987;
(statearr_17061[(22)] = inst_16956__$1);

return statearr_17061;
})();
if(cljs.core.truth_(inst_16957)){
var statearr_17062_17122 = state_16987__$1;
(statearr_17062_17122[(1)] = (39));

} else {
var statearr_17063_17123 = state_16987__$1;
(statearr_17063_17123[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16988 === (8))){
var inst_16868 = (state_16987[(15)]);
var inst_16869 = (state_16987[(17)]);
var inst_16871 = (inst_16869 < inst_16868);
var inst_16872 = inst_16871;
var state_16987__$1 = state_16987;
if(cljs.core.truth_(inst_16872)){
var statearr_17064_17124 = state_16987__$1;
(statearr_17064_17124[(1)] = (10));

} else {
var statearr_17065_17125 = state_16987__$1;
(statearr_17065_17125[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__16153__auto__ = null;
var cljs$core$async$mult_$_state_machine__16153__auto____0 = (function (){
var statearr_17066 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17066[(0)] = cljs$core$async$mult_$_state_machine__16153__auto__);

(statearr_17066[(1)] = (1));

return statearr_17066;
});
var cljs$core$async$mult_$_state_machine__16153__auto____1 = (function (state_16987){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_16987);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e17067){var ex__16156__auto__ = e17067;
var statearr_17068_17126 = state_16987;
(statearr_17068_17126[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_16987[(4)]))){
var statearr_17069_17127 = state_16987;
(statearr_17069_17127[(1)] = cljs.core.first((state_16987[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__17128 = state_16987;
state_16987 = G__17128;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16153__auto__ = function(state_16987){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16153__auto____1.call(this,state_16987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16153__auto____0;
cljs$core$async$mult_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16153__auto____1;
return cljs$core$async$mult_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_17070 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_17070[(6)] = c__16227__auto___17071);

return statearr_17070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__17130 = arguments.length;
switch (G__17130) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_17132 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_17132(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_17133 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_17133(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_17134 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4522__auto__.call(null,m));
} else {
var m__4519__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4519__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_17134(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_17135 = (function (m,state_map){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4522__auto__.call(null,m,state_map));
} else {
var m__4519__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4519__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_17135(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_17136 = (function (m,mode){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4522__auto__.call(null,m,mode));
} else {
var m__4519__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4519__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_17136(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___17146 = arguments.length;
var i__4830__auto___17147 = (0);
while(true){
if((i__4830__auto___17147 < len__4829__auto___17146)){
args__4835__auto__.push((arguments[i__4830__auto___17147]));

var G__17148 = (i__4830__auto___17147 + (1));
i__4830__auto___17147 = G__17148;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((3) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4836__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__17141){
var map__17142 = p__17141;
var map__17142__$1 = cljs.core.__destructure_map(map__17142);
var opts = map__17142__$1;
var statearr_17143_17149 = state;
(statearr_17143_17149[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_17144_17150 = state;
(statearr_17144_17150[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_17145_17151 = state;
(statearr_17145_17151[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq17137){
var G__17138 = cljs.core.first(seq17137);
var seq17137__$1 = cljs.core.next(seq17137);
var G__17139 = cljs.core.first(seq17137__$1);
var seq17137__$2 = cljs.core.next(seq17137__$1);
var G__17140 = cljs.core.first(seq17137__$2);
var seq17137__$3 = cljs.core.next(seq17137__$2);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17138,G__17139,G__17140,seq17137__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17152 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17152 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta17153){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta17153 = meta17153;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17152.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17154,meta17153__$1){
var self__ = this;
var _17154__$1 = this;
return (new cljs.core.async.t_cljs$core$async17152(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta17153__$1));
}));

(cljs.core.async.t_cljs$core$async17152.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17154){
var self__ = this;
var _17154__$1 = this;
return self__.meta17153;
}));

(cljs.core.async.t_cljs$core$async17152.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17152.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async17152.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17152.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17152.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17152.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17152.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17152.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17152.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta17153], null);
}));

(cljs.core.async.t_cljs$core$async17152.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17152.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17152");

(cljs.core.async.t_cljs$core$async17152.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async17152");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17152.
 */
cljs.core.async.__GT_t_cljs$core$async17152 = (function cljs$core$async$mix_$___GT_t_cljs$core$async17152(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta17153){
return (new cljs.core.async.t_cljs$core$async17152(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta17153));
});

}

return (new cljs.core.async.t_cljs$core$async17152(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16227__auto___17267 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_17222){
var state_val_17223 = (state_17222[(1)]);
if((state_val_17223 === (7))){
var inst_17182 = (state_17222[(2)]);
var state_17222__$1 = state_17222;
if(cljs.core.truth_(inst_17182)){
var statearr_17224_17268 = state_17222__$1;
(statearr_17224_17268[(1)] = (8));

} else {
var statearr_17225_17269 = state_17222__$1;
(statearr_17225_17269[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (20))){
var inst_17175 = (state_17222[(7)]);
var state_17222__$1 = state_17222;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17222__$1,(23),out,inst_17175);
} else {
if((state_val_17223 === (1))){
var inst_17158 = calc_state();
var inst_17159 = cljs.core.__destructure_map(inst_17158);
var inst_17160 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17159,cljs.core.cst$kw$solos);
var inst_17161 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17159,cljs.core.cst$kw$mutes);
var inst_17162 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17159,cljs.core.cst$kw$reads);
var inst_17163 = inst_17158;
var state_17222__$1 = (function (){var statearr_17226 = state_17222;
(statearr_17226[(8)] = inst_17162);

(statearr_17226[(9)] = inst_17163);

(statearr_17226[(10)] = inst_17160);

(statearr_17226[(11)] = inst_17161);

return statearr_17226;
})();
var statearr_17227_17270 = state_17222__$1;
(statearr_17227_17270[(2)] = null);

(statearr_17227_17270[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (24))){
var inst_17166 = (state_17222[(12)]);
var inst_17163 = inst_17166;
var state_17222__$1 = (function (){var statearr_17228 = state_17222;
(statearr_17228[(9)] = inst_17163);

return statearr_17228;
})();
var statearr_17229_17271 = state_17222__$1;
(statearr_17229_17271[(2)] = null);

(statearr_17229_17271[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (4))){
var inst_17175 = (state_17222[(7)]);
var inst_17177 = (state_17222[(13)]);
var inst_17174 = (state_17222[(2)]);
var inst_17175__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17174,(0),null);
var inst_17176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17174,(1),null);
var inst_17177__$1 = (inst_17175__$1 == null);
var state_17222__$1 = (function (){var statearr_17230 = state_17222;
(statearr_17230[(7)] = inst_17175__$1);

(statearr_17230[(14)] = inst_17176);

(statearr_17230[(13)] = inst_17177__$1);

return statearr_17230;
})();
if(cljs.core.truth_(inst_17177__$1)){
var statearr_17231_17272 = state_17222__$1;
(statearr_17231_17272[(1)] = (5));

} else {
var statearr_17232_17273 = state_17222__$1;
(statearr_17232_17273[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (15))){
var inst_17196 = (state_17222[(15)]);
var inst_17167 = (state_17222[(16)]);
var inst_17196__$1 = cljs.core.empty_QMARK_(inst_17167);
var state_17222__$1 = (function (){var statearr_17233 = state_17222;
(statearr_17233[(15)] = inst_17196__$1);

return statearr_17233;
})();
if(inst_17196__$1){
var statearr_17234_17274 = state_17222__$1;
(statearr_17234_17274[(1)] = (17));

} else {
var statearr_17235_17275 = state_17222__$1;
(statearr_17235_17275[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (21))){
var inst_17166 = (state_17222[(12)]);
var inst_17163 = inst_17166;
var state_17222__$1 = (function (){var statearr_17236 = state_17222;
(statearr_17236[(9)] = inst_17163);

return statearr_17236;
})();
var statearr_17237_17276 = state_17222__$1;
(statearr_17237_17276[(2)] = null);

(statearr_17237_17276[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (13))){
var inst_17189 = (state_17222[(2)]);
var inst_17190 = calc_state();
var inst_17163 = inst_17190;
var state_17222__$1 = (function (){var statearr_17238 = state_17222;
(statearr_17238[(9)] = inst_17163);

(statearr_17238[(17)] = inst_17189);

return statearr_17238;
})();
var statearr_17239_17277 = state_17222__$1;
(statearr_17239_17277[(2)] = null);

(statearr_17239_17277[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (22))){
var inst_17216 = (state_17222[(2)]);
var state_17222__$1 = state_17222;
var statearr_17240_17278 = state_17222__$1;
(statearr_17240_17278[(2)] = inst_17216);

(statearr_17240_17278[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (6))){
var inst_17176 = (state_17222[(14)]);
var inst_17180 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17176,change);
var state_17222__$1 = state_17222;
var statearr_17241_17279 = state_17222__$1;
(statearr_17241_17279[(2)] = inst_17180);

(statearr_17241_17279[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (25))){
var state_17222__$1 = state_17222;
var statearr_17242_17280 = state_17222__$1;
(statearr_17242_17280[(2)] = null);

(statearr_17242_17280[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (17))){
var inst_17176 = (state_17222[(14)]);
var inst_17168 = (state_17222[(18)]);
var inst_17198 = (inst_17168.cljs$core$IFn$_invoke$arity$1 ? inst_17168.cljs$core$IFn$_invoke$arity$1(inst_17176) : inst_17168.call(null,inst_17176));
var inst_17199 = cljs.core.not(inst_17198);
var state_17222__$1 = state_17222;
var statearr_17243_17281 = state_17222__$1;
(statearr_17243_17281[(2)] = inst_17199);

(statearr_17243_17281[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (3))){
var inst_17220 = (state_17222[(2)]);
var state_17222__$1 = state_17222;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17222__$1,inst_17220);
} else {
if((state_val_17223 === (12))){
var state_17222__$1 = state_17222;
var statearr_17244_17282 = state_17222__$1;
(statearr_17244_17282[(2)] = null);

(statearr_17244_17282[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (2))){
var inst_17163 = (state_17222[(9)]);
var inst_17166 = (state_17222[(12)]);
var inst_17166__$1 = cljs.core.__destructure_map(inst_17163);
var inst_17167 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17166__$1,cljs.core.cst$kw$solos);
var inst_17168 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17166__$1,cljs.core.cst$kw$mutes);
var inst_17169 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17166__$1,cljs.core.cst$kw$reads);
var state_17222__$1 = (function (){var statearr_17245 = state_17222;
(statearr_17245[(12)] = inst_17166__$1);

(statearr_17245[(16)] = inst_17167);

(statearr_17245[(18)] = inst_17168);

return statearr_17245;
})();
return cljs.core.async.ioc_alts_BANG_(state_17222__$1,(4),inst_17169);
} else {
if((state_val_17223 === (23))){
var inst_17207 = (state_17222[(2)]);
var state_17222__$1 = state_17222;
if(cljs.core.truth_(inst_17207)){
var statearr_17246_17283 = state_17222__$1;
(statearr_17246_17283[(1)] = (24));

} else {
var statearr_17247_17284 = state_17222__$1;
(statearr_17247_17284[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (19))){
var inst_17202 = (state_17222[(2)]);
var state_17222__$1 = state_17222;
var statearr_17248_17285 = state_17222__$1;
(statearr_17248_17285[(2)] = inst_17202);

(statearr_17248_17285[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (11))){
var inst_17176 = (state_17222[(14)]);
var inst_17186 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_17176);
var state_17222__$1 = state_17222;
var statearr_17249_17286 = state_17222__$1;
(statearr_17249_17286[(2)] = inst_17186);

(statearr_17249_17286[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (9))){
var inst_17176 = (state_17222[(14)]);
var inst_17193 = (state_17222[(19)]);
var inst_17167 = (state_17222[(16)]);
var inst_17193__$1 = (inst_17167.cljs$core$IFn$_invoke$arity$1 ? inst_17167.cljs$core$IFn$_invoke$arity$1(inst_17176) : inst_17167.call(null,inst_17176));
var state_17222__$1 = (function (){var statearr_17250 = state_17222;
(statearr_17250[(19)] = inst_17193__$1);

return statearr_17250;
})();
if(cljs.core.truth_(inst_17193__$1)){
var statearr_17251_17287 = state_17222__$1;
(statearr_17251_17287[(1)] = (14));

} else {
var statearr_17252_17288 = state_17222__$1;
(statearr_17252_17288[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (5))){
var inst_17177 = (state_17222[(13)]);
var state_17222__$1 = state_17222;
var statearr_17253_17289 = state_17222__$1;
(statearr_17253_17289[(2)] = inst_17177);

(statearr_17253_17289[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (14))){
var inst_17193 = (state_17222[(19)]);
var state_17222__$1 = state_17222;
var statearr_17254_17290 = state_17222__$1;
(statearr_17254_17290[(2)] = inst_17193);

(statearr_17254_17290[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (26))){
var inst_17212 = (state_17222[(2)]);
var state_17222__$1 = state_17222;
var statearr_17255_17291 = state_17222__$1;
(statearr_17255_17291[(2)] = inst_17212);

(statearr_17255_17291[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (16))){
var inst_17204 = (state_17222[(2)]);
var state_17222__$1 = state_17222;
if(cljs.core.truth_(inst_17204)){
var statearr_17256_17292 = state_17222__$1;
(statearr_17256_17292[(1)] = (20));

} else {
var statearr_17257_17293 = state_17222__$1;
(statearr_17257_17293[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (10))){
var inst_17218 = (state_17222[(2)]);
var state_17222__$1 = state_17222;
var statearr_17258_17294 = state_17222__$1;
(statearr_17258_17294[(2)] = inst_17218);

(statearr_17258_17294[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (18))){
var inst_17196 = (state_17222[(15)]);
var state_17222__$1 = state_17222;
var statearr_17259_17295 = state_17222__$1;
(statearr_17259_17295[(2)] = inst_17196);

(statearr_17259_17295[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17223 === (8))){
var inst_17175 = (state_17222[(7)]);
var inst_17184 = (inst_17175 == null);
var state_17222__$1 = state_17222;
if(cljs.core.truth_(inst_17184)){
var statearr_17260_17296 = state_17222__$1;
(statearr_17260_17296[(1)] = (11));

} else {
var statearr_17261_17297 = state_17222__$1;
(statearr_17261_17297[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__16153__auto__ = null;
var cljs$core$async$mix_$_state_machine__16153__auto____0 = (function (){
var statearr_17262 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17262[(0)] = cljs$core$async$mix_$_state_machine__16153__auto__);

(statearr_17262[(1)] = (1));

return statearr_17262;
});
var cljs$core$async$mix_$_state_machine__16153__auto____1 = (function (state_17222){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_17222);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e17263){var ex__16156__auto__ = e17263;
var statearr_17264_17298 = state_17222;
(statearr_17264_17298[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_17222[(4)]))){
var statearr_17265_17299 = state_17222;
(statearr_17265_17299[(1)] = cljs.core.first((state_17222[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__17300 = state_17222;
state_17222 = G__17300;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16153__auto__ = function(state_17222){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16153__auto____1.call(this,state_17222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16153__auto____0;
cljs$core$async$mix_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16153__auto____1;
return cljs$core$async$mix_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_17266 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_17266[(6)] = c__16227__auto___17267);

return statearr_17266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_17303 = (function (p,v,ch,close_QMARK_){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4522__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4519__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4519__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_17303(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_17304 = (function (p,v,ch){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4522__auto__.call(null,p,v,ch));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4519__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_17304(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_17305 = (function() {
var G__17306 = null;
var G__17306__1 = (function (p){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4522__auto__.call(null,p));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4519__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__17306__2 = (function (p,v){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4522__auto__.call(null,p,v));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4519__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__17306 = function(p,v){
switch(arguments.length){
case 1:
return G__17306__1.call(this,p);
case 2:
return G__17306__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17306.cljs$core$IFn$_invoke$arity$1 = G__17306__1;
G__17306.cljs$core$IFn$_invoke$arity$2 = G__17306__2;
return G__17306;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__17302 = arguments.length;
switch (G__17302) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_17305.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_17305.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__17310 = arguments.length;
switch (G__17310) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__17308_SHARP_){
if(cljs.core.truth_((p1__17308_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17308_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__17308_SHARP_.call(null,topic)))){
return p1__17308_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__17308_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17311 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17311 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta17312){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta17312 = meta17312;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17311.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17313,meta17312__$1){
var self__ = this;
var _17313__$1 = this;
return (new cljs.core.async.t_cljs$core$async17311(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta17312__$1));
}));

(cljs.core.async.t_cljs$core$async17311.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17313){
var self__ = this;
var _17313__$1 = this;
return self__.meta17312;
}));

(cljs.core.async.t_cljs$core$async17311.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17311.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async17311.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17311.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async17311.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async17311.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async17311.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async17311.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta17312], null);
}));

(cljs.core.async.t_cljs$core$async17311.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17311.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17311");

(cljs.core.async.t_cljs$core$async17311.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async17311");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17311.
 */
cljs.core.async.__GT_t_cljs$core$async17311 = (function cljs$core$async$__GT_t_cljs$core$async17311(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta17312){
return (new cljs.core.async.t_cljs$core$async17311(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta17312));
});

}

return (new cljs.core.async.t_cljs$core$async17311(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16227__auto___17432 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_17385){
var state_val_17386 = (state_17385[(1)]);
if((state_val_17386 === (7))){
var inst_17381 = (state_17385[(2)]);
var state_17385__$1 = state_17385;
var statearr_17387_17433 = state_17385__$1;
(statearr_17387_17433[(2)] = inst_17381);

(statearr_17387_17433[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (20))){
var state_17385__$1 = state_17385;
var statearr_17388_17434 = state_17385__$1;
(statearr_17388_17434[(2)] = null);

(statearr_17388_17434[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (1))){
var state_17385__$1 = state_17385;
var statearr_17389_17435 = state_17385__$1;
(statearr_17389_17435[(2)] = null);

(statearr_17389_17435[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (24))){
var inst_17364 = (state_17385[(7)]);
var inst_17373 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_17364);
var state_17385__$1 = state_17385;
var statearr_17390_17436 = state_17385__$1;
(statearr_17390_17436[(2)] = inst_17373);

(statearr_17390_17436[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (4))){
var inst_17316 = (state_17385[(8)]);
var inst_17316__$1 = (state_17385[(2)]);
var inst_17317 = (inst_17316__$1 == null);
var state_17385__$1 = (function (){var statearr_17391 = state_17385;
(statearr_17391[(8)] = inst_17316__$1);

return statearr_17391;
})();
if(cljs.core.truth_(inst_17317)){
var statearr_17392_17437 = state_17385__$1;
(statearr_17392_17437[(1)] = (5));

} else {
var statearr_17393_17438 = state_17385__$1;
(statearr_17393_17438[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (15))){
var inst_17358 = (state_17385[(2)]);
var state_17385__$1 = state_17385;
var statearr_17394_17439 = state_17385__$1;
(statearr_17394_17439[(2)] = inst_17358);

(statearr_17394_17439[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (21))){
var inst_17378 = (state_17385[(2)]);
var state_17385__$1 = (function (){var statearr_17395 = state_17385;
(statearr_17395[(9)] = inst_17378);

return statearr_17395;
})();
var statearr_17396_17440 = state_17385__$1;
(statearr_17396_17440[(2)] = null);

(statearr_17396_17440[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (13))){
var inst_17340 = (state_17385[(10)]);
var inst_17342 = cljs.core.chunked_seq_QMARK_(inst_17340);
var state_17385__$1 = state_17385;
if(inst_17342){
var statearr_17397_17441 = state_17385__$1;
(statearr_17397_17441[(1)] = (16));

} else {
var statearr_17398_17442 = state_17385__$1;
(statearr_17398_17442[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (22))){
var inst_17370 = (state_17385[(2)]);
var state_17385__$1 = state_17385;
if(cljs.core.truth_(inst_17370)){
var statearr_17399_17443 = state_17385__$1;
(statearr_17399_17443[(1)] = (23));

} else {
var statearr_17400_17444 = state_17385__$1;
(statearr_17400_17444[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (6))){
var inst_17366 = (state_17385[(11)]);
var inst_17364 = (state_17385[(7)]);
var inst_17316 = (state_17385[(8)]);
var inst_17364__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_17316) : topic_fn.call(null,inst_17316));
var inst_17365 = cljs.core.deref(mults);
var inst_17366__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17365,inst_17364__$1);
var state_17385__$1 = (function (){var statearr_17401 = state_17385;
(statearr_17401[(11)] = inst_17366__$1);

(statearr_17401[(7)] = inst_17364__$1);

return statearr_17401;
})();
if(cljs.core.truth_(inst_17366__$1)){
var statearr_17402_17445 = state_17385__$1;
(statearr_17402_17445[(1)] = (19));

} else {
var statearr_17403_17446 = state_17385__$1;
(statearr_17403_17446[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (25))){
var inst_17375 = (state_17385[(2)]);
var state_17385__$1 = state_17385;
var statearr_17404_17447 = state_17385__$1;
(statearr_17404_17447[(2)] = inst_17375);

(statearr_17404_17447[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (17))){
var inst_17340 = (state_17385[(10)]);
var inst_17349 = cljs.core.first(inst_17340);
var inst_17350 = cljs.core.async.muxch_STAR_(inst_17349);
var inst_17351 = cljs.core.async.close_BANG_(inst_17350);
var inst_17352 = cljs.core.next(inst_17340);
var inst_17326 = inst_17352;
var inst_17327 = null;
var inst_17328 = (0);
var inst_17329 = (0);
var state_17385__$1 = (function (){var statearr_17405 = state_17385;
(statearr_17405[(12)] = inst_17329);

(statearr_17405[(13)] = inst_17327);

(statearr_17405[(14)] = inst_17328);

(statearr_17405[(15)] = inst_17326);

(statearr_17405[(16)] = inst_17351);

return statearr_17405;
})();
var statearr_17406_17448 = state_17385__$1;
(statearr_17406_17448[(2)] = null);

(statearr_17406_17448[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (3))){
var inst_17383 = (state_17385[(2)]);
var state_17385__$1 = state_17385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17385__$1,inst_17383);
} else {
if((state_val_17386 === (12))){
var inst_17360 = (state_17385[(2)]);
var state_17385__$1 = state_17385;
var statearr_17407_17449 = state_17385__$1;
(statearr_17407_17449[(2)] = inst_17360);

(statearr_17407_17449[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (2))){
var state_17385__$1 = state_17385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17385__$1,(4),ch);
} else {
if((state_val_17386 === (23))){
var state_17385__$1 = state_17385;
var statearr_17408_17450 = state_17385__$1;
(statearr_17408_17450[(2)] = null);

(statearr_17408_17450[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (19))){
var inst_17366 = (state_17385[(11)]);
var inst_17316 = (state_17385[(8)]);
var inst_17368 = cljs.core.async.muxch_STAR_(inst_17366);
var state_17385__$1 = state_17385;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17385__$1,(22),inst_17368,inst_17316);
} else {
if((state_val_17386 === (11))){
var inst_17326 = (state_17385[(15)]);
var inst_17340 = (state_17385[(10)]);
var inst_17340__$1 = cljs.core.seq(inst_17326);
var state_17385__$1 = (function (){var statearr_17409 = state_17385;
(statearr_17409[(10)] = inst_17340__$1);

return statearr_17409;
})();
if(inst_17340__$1){
var statearr_17410_17451 = state_17385__$1;
(statearr_17410_17451[(1)] = (13));

} else {
var statearr_17411_17452 = state_17385__$1;
(statearr_17411_17452[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (9))){
var inst_17362 = (state_17385[(2)]);
var state_17385__$1 = state_17385;
var statearr_17412_17453 = state_17385__$1;
(statearr_17412_17453[(2)] = inst_17362);

(statearr_17412_17453[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (5))){
var inst_17323 = cljs.core.deref(mults);
var inst_17324 = cljs.core.vals(inst_17323);
var inst_17325 = cljs.core.seq(inst_17324);
var inst_17326 = inst_17325;
var inst_17327 = null;
var inst_17328 = (0);
var inst_17329 = (0);
var state_17385__$1 = (function (){var statearr_17413 = state_17385;
(statearr_17413[(12)] = inst_17329);

(statearr_17413[(13)] = inst_17327);

(statearr_17413[(14)] = inst_17328);

(statearr_17413[(15)] = inst_17326);

return statearr_17413;
})();
var statearr_17414_17454 = state_17385__$1;
(statearr_17414_17454[(2)] = null);

(statearr_17414_17454[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (14))){
var state_17385__$1 = state_17385;
var statearr_17418_17455 = state_17385__$1;
(statearr_17418_17455[(2)] = null);

(statearr_17418_17455[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (16))){
var inst_17340 = (state_17385[(10)]);
var inst_17344 = cljs.core.chunk_first(inst_17340);
var inst_17345 = cljs.core.chunk_rest(inst_17340);
var inst_17346 = cljs.core.count(inst_17344);
var inst_17326 = inst_17345;
var inst_17327 = inst_17344;
var inst_17328 = inst_17346;
var inst_17329 = (0);
var state_17385__$1 = (function (){var statearr_17419 = state_17385;
(statearr_17419[(12)] = inst_17329);

(statearr_17419[(13)] = inst_17327);

(statearr_17419[(14)] = inst_17328);

(statearr_17419[(15)] = inst_17326);

return statearr_17419;
})();
var statearr_17420_17456 = state_17385__$1;
(statearr_17420_17456[(2)] = null);

(statearr_17420_17456[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (10))){
var inst_17329 = (state_17385[(12)]);
var inst_17327 = (state_17385[(13)]);
var inst_17328 = (state_17385[(14)]);
var inst_17326 = (state_17385[(15)]);
var inst_17334 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17327,inst_17329);
var inst_17335 = cljs.core.async.muxch_STAR_(inst_17334);
var inst_17336 = cljs.core.async.close_BANG_(inst_17335);
var inst_17337 = (inst_17329 + (1));
var tmp17415 = inst_17327;
var tmp17416 = inst_17328;
var tmp17417 = inst_17326;
var inst_17326__$1 = tmp17417;
var inst_17327__$1 = tmp17415;
var inst_17328__$1 = tmp17416;
var inst_17329__$1 = inst_17337;
var state_17385__$1 = (function (){var statearr_17421 = state_17385;
(statearr_17421[(12)] = inst_17329__$1);

(statearr_17421[(17)] = inst_17336);

(statearr_17421[(13)] = inst_17327__$1);

(statearr_17421[(14)] = inst_17328__$1);

(statearr_17421[(15)] = inst_17326__$1);

return statearr_17421;
})();
var statearr_17422_17457 = state_17385__$1;
(statearr_17422_17457[(2)] = null);

(statearr_17422_17457[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (18))){
var inst_17355 = (state_17385[(2)]);
var state_17385__$1 = state_17385;
var statearr_17423_17458 = state_17385__$1;
(statearr_17423_17458[(2)] = inst_17355);

(statearr_17423_17458[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (8))){
var inst_17329 = (state_17385[(12)]);
var inst_17328 = (state_17385[(14)]);
var inst_17331 = (inst_17329 < inst_17328);
var inst_17332 = inst_17331;
var state_17385__$1 = state_17385;
if(cljs.core.truth_(inst_17332)){
var statearr_17424_17459 = state_17385__$1;
(statearr_17424_17459[(1)] = (10));

} else {
var statearr_17425_17460 = state_17385__$1;
(statearr_17425_17460[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16153__auto__ = null;
var cljs$core$async$state_machine__16153__auto____0 = (function (){
var statearr_17426 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17426[(0)] = cljs$core$async$state_machine__16153__auto__);

(statearr_17426[(1)] = (1));

return statearr_17426;
});
var cljs$core$async$state_machine__16153__auto____1 = (function (state_17385){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_17385);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e17427){var ex__16156__auto__ = e17427;
var statearr_17428_17461 = state_17385;
(statearr_17428_17461[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_17385[(4)]))){
var statearr_17429_17462 = state_17385;
(statearr_17429_17462[(1)] = cljs.core.first((state_17385[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__17463 = state_17385;
state_17385 = G__17463;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$state_machine__16153__auto__ = function(state_17385){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16153__auto____1.call(this,state_17385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16153__auto____0;
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16153__auto____1;
return cljs$core$async$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_17430 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_17430[(6)] = c__16227__auto___17432);

return statearr_17430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__17465 = arguments.length;
switch (G__17465) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__17468 = arguments.length;
switch (G__17468) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__17471 = arguments.length;
switch (G__17471) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__16227__auto___17549 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_17514){
var state_val_17515 = (state_17514[(1)]);
if((state_val_17515 === (7))){
var state_17514__$1 = state_17514;
var statearr_17516_17550 = state_17514__$1;
(statearr_17516_17550[(2)] = null);

(statearr_17516_17550[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17515 === (1))){
var state_17514__$1 = state_17514;
var statearr_17517_17551 = state_17514__$1;
(statearr_17517_17551[(2)] = null);

(statearr_17517_17551[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17515 === (4))){
var inst_17474 = (state_17514[(7)]);
var inst_17475 = (state_17514[(8)]);
var inst_17477 = (inst_17475 < inst_17474);
var state_17514__$1 = state_17514;
if(cljs.core.truth_(inst_17477)){
var statearr_17518_17552 = state_17514__$1;
(statearr_17518_17552[(1)] = (6));

} else {
var statearr_17519_17553 = state_17514__$1;
(statearr_17519_17553[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17515 === (15))){
var inst_17500 = (state_17514[(9)]);
var inst_17505 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_17500);
var state_17514__$1 = state_17514;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17514__$1,(17),out,inst_17505);
} else {
if((state_val_17515 === (13))){
var inst_17500 = (state_17514[(9)]);
var inst_17500__$1 = (state_17514[(2)]);
var inst_17501 = cljs.core.some(cljs.core.nil_QMARK_,inst_17500__$1);
var state_17514__$1 = (function (){var statearr_17520 = state_17514;
(statearr_17520[(9)] = inst_17500__$1);

return statearr_17520;
})();
if(cljs.core.truth_(inst_17501)){
var statearr_17521_17554 = state_17514__$1;
(statearr_17521_17554[(1)] = (14));

} else {
var statearr_17522_17555 = state_17514__$1;
(statearr_17522_17555[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17515 === (6))){
var state_17514__$1 = state_17514;
var statearr_17523_17556 = state_17514__$1;
(statearr_17523_17556[(2)] = null);

(statearr_17523_17556[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17515 === (17))){
var inst_17507 = (state_17514[(2)]);
var state_17514__$1 = (function (){var statearr_17525 = state_17514;
(statearr_17525[(10)] = inst_17507);

return statearr_17525;
})();
var statearr_17526_17557 = state_17514__$1;
(statearr_17526_17557[(2)] = null);

(statearr_17526_17557[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17515 === (3))){
var inst_17512 = (state_17514[(2)]);
var state_17514__$1 = state_17514;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17514__$1,inst_17512);
} else {
if((state_val_17515 === (12))){
var _ = (function (){var statearr_17527 = state_17514;
(statearr_17527[(4)] = cljs.core.rest((state_17514[(4)])));

return statearr_17527;
})();
var state_17514__$1 = state_17514;
var ex17524 = (state_17514__$1[(2)]);
var statearr_17528_17558 = state_17514__$1;
(statearr_17528_17558[(5)] = ex17524);


if((ex17524 instanceof Object)){
var statearr_17529_17559 = state_17514__$1;
(statearr_17529_17559[(1)] = (11));

(statearr_17529_17559[(5)] = null);

} else {
throw ex17524;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17515 === (2))){
var inst_17473 = cljs.core.reset_BANG_(dctr,cnt);
var inst_17474 = cnt;
var inst_17475 = (0);
var state_17514__$1 = (function (){var statearr_17530 = state_17514;
(statearr_17530[(11)] = inst_17473);

(statearr_17530[(7)] = inst_17474);

(statearr_17530[(8)] = inst_17475);

return statearr_17530;
})();
var statearr_17531_17560 = state_17514__$1;
(statearr_17531_17560[(2)] = null);

(statearr_17531_17560[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17515 === (11))){
var inst_17479 = (state_17514[(2)]);
var inst_17480 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_17514__$1 = (function (){var statearr_17532 = state_17514;
(statearr_17532[(12)] = inst_17479);

return statearr_17532;
})();
var statearr_17533_17561 = state_17514__$1;
(statearr_17533_17561[(2)] = inst_17480);

(statearr_17533_17561[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17515 === (9))){
var inst_17475 = (state_17514[(8)]);
var _ = (function (){var statearr_17534 = state_17514;
(statearr_17534[(4)] = cljs.core.cons((12),(state_17514[(4)])));

return statearr_17534;
})();
var inst_17486 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_17475) : chs__$1.call(null,inst_17475));
var inst_17487 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_17475) : done.call(null,inst_17475));
var inst_17488 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_17486,inst_17487);
var ___$1 = (function (){var statearr_17535 = state_17514;
(statearr_17535[(4)] = cljs.core.rest((state_17514[(4)])));

return statearr_17535;
})();
var state_17514__$1 = state_17514;
var statearr_17536_17562 = state_17514__$1;
(statearr_17536_17562[(2)] = inst_17488);

(statearr_17536_17562[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17515 === (5))){
var inst_17498 = (state_17514[(2)]);
var state_17514__$1 = (function (){var statearr_17537 = state_17514;
(statearr_17537[(13)] = inst_17498);

return statearr_17537;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17514__$1,(13),dchan);
} else {
if((state_val_17515 === (14))){
var inst_17503 = cljs.core.async.close_BANG_(out);
var state_17514__$1 = state_17514;
var statearr_17538_17563 = state_17514__$1;
(statearr_17538_17563[(2)] = inst_17503);

(statearr_17538_17563[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17515 === (16))){
var inst_17510 = (state_17514[(2)]);
var state_17514__$1 = state_17514;
var statearr_17539_17564 = state_17514__$1;
(statearr_17539_17564[(2)] = inst_17510);

(statearr_17539_17564[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17515 === (10))){
var inst_17475 = (state_17514[(8)]);
var inst_17491 = (state_17514[(2)]);
var inst_17492 = (inst_17475 + (1));
var inst_17475__$1 = inst_17492;
var state_17514__$1 = (function (){var statearr_17540 = state_17514;
(statearr_17540[(14)] = inst_17491);

(statearr_17540[(8)] = inst_17475__$1);

return statearr_17540;
})();
var statearr_17541_17565 = state_17514__$1;
(statearr_17541_17565[(2)] = null);

(statearr_17541_17565[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17515 === (8))){
var inst_17496 = (state_17514[(2)]);
var state_17514__$1 = state_17514;
var statearr_17542_17566 = state_17514__$1;
(statearr_17542_17566[(2)] = inst_17496);

(statearr_17542_17566[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16153__auto__ = null;
var cljs$core$async$state_machine__16153__auto____0 = (function (){
var statearr_17543 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17543[(0)] = cljs$core$async$state_machine__16153__auto__);

(statearr_17543[(1)] = (1));

return statearr_17543;
});
var cljs$core$async$state_machine__16153__auto____1 = (function (state_17514){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_17514);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e17544){var ex__16156__auto__ = e17544;
var statearr_17545_17567 = state_17514;
(statearr_17545_17567[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_17514[(4)]))){
var statearr_17546_17568 = state_17514;
(statearr_17546_17568[(1)] = cljs.core.first((state_17514[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__17569 = state_17514;
state_17514 = G__17569;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$state_machine__16153__auto__ = function(state_17514){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16153__auto____1.call(this,state_17514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16153__auto____0;
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16153__auto____1;
return cljs$core$async$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_17547 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_17547[(6)] = c__16227__auto___17549);

return statearr_17547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__17572 = arguments.length;
switch (G__17572) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16227__auto___17627 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_17604){
var state_val_17605 = (state_17604[(1)]);
if((state_val_17605 === (7))){
var inst_17584 = (state_17604[(7)]);
var inst_17583 = (state_17604[(8)]);
var inst_17583__$1 = (state_17604[(2)]);
var inst_17584__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17583__$1,(0),null);
var inst_17585 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17583__$1,(1),null);
var inst_17586 = (inst_17584__$1 == null);
var state_17604__$1 = (function (){var statearr_17606 = state_17604;
(statearr_17606[(7)] = inst_17584__$1);

(statearr_17606[(8)] = inst_17583__$1);

(statearr_17606[(9)] = inst_17585);

return statearr_17606;
})();
if(cljs.core.truth_(inst_17586)){
var statearr_17607_17628 = state_17604__$1;
(statearr_17607_17628[(1)] = (8));

} else {
var statearr_17608_17629 = state_17604__$1;
(statearr_17608_17629[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17605 === (1))){
var inst_17573 = cljs.core.vec(chs);
var inst_17574 = inst_17573;
var state_17604__$1 = (function (){var statearr_17609 = state_17604;
(statearr_17609[(10)] = inst_17574);

return statearr_17609;
})();
var statearr_17610_17630 = state_17604__$1;
(statearr_17610_17630[(2)] = null);

(statearr_17610_17630[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17605 === (4))){
var inst_17574 = (state_17604[(10)]);
var state_17604__$1 = state_17604;
return cljs.core.async.ioc_alts_BANG_(state_17604__$1,(7),inst_17574);
} else {
if((state_val_17605 === (6))){
var inst_17600 = (state_17604[(2)]);
var state_17604__$1 = state_17604;
var statearr_17611_17631 = state_17604__$1;
(statearr_17611_17631[(2)] = inst_17600);

(statearr_17611_17631[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17605 === (3))){
var inst_17602 = (state_17604[(2)]);
var state_17604__$1 = state_17604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17604__$1,inst_17602);
} else {
if((state_val_17605 === (2))){
var inst_17574 = (state_17604[(10)]);
var inst_17576 = cljs.core.count(inst_17574);
var inst_17577 = (inst_17576 > (0));
var state_17604__$1 = state_17604;
if(cljs.core.truth_(inst_17577)){
var statearr_17613_17632 = state_17604__$1;
(statearr_17613_17632[(1)] = (4));

} else {
var statearr_17614_17633 = state_17604__$1;
(statearr_17614_17633[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17605 === (11))){
var inst_17574 = (state_17604[(10)]);
var inst_17593 = (state_17604[(2)]);
var tmp17612 = inst_17574;
var inst_17574__$1 = tmp17612;
var state_17604__$1 = (function (){var statearr_17615 = state_17604;
(statearr_17615[(11)] = inst_17593);

(statearr_17615[(10)] = inst_17574__$1);

return statearr_17615;
})();
var statearr_17616_17634 = state_17604__$1;
(statearr_17616_17634[(2)] = null);

(statearr_17616_17634[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17605 === (9))){
var inst_17584 = (state_17604[(7)]);
var state_17604__$1 = state_17604;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17604__$1,(11),out,inst_17584);
} else {
if((state_val_17605 === (5))){
var inst_17598 = cljs.core.async.close_BANG_(out);
var state_17604__$1 = state_17604;
var statearr_17617_17635 = state_17604__$1;
(statearr_17617_17635[(2)] = inst_17598);

(statearr_17617_17635[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17605 === (10))){
var inst_17596 = (state_17604[(2)]);
var state_17604__$1 = state_17604;
var statearr_17618_17636 = state_17604__$1;
(statearr_17618_17636[(2)] = inst_17596);

(statearr_17618_17636[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17605 === (8))){
var inst_17584 = (state_17604[(7)]);
var inst_17583 = (state_17604[(8)]);
var inst_17585 = (state_17604[(9)]);
var inst_17574 = (state_17604[(10)]);
var inst_17588 = (function (){var cs = inst_17574;
var vec__17579 = inst_17583;
var v = inst_17584;
var c = inst_17585;
return (function (p1__17570_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__17570_SHARP_);
});
})();
var inst_17589 = cljs.core.filterv(inst_17588,inst_17574);
var inst_17574__$1 = inst_17589;
var state_17604__$1 = (function (){var statearr_17619 = state_17604;
(statearr_17619[(10)] = inst_17574__$1);

return statearr_17619;
})();
var statearr_17620_17637 = state_17604__$1;
(statearr_17620_17637[(2)] = null);

(statearr_17620_17637[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16153__auto__ = null;
var cljs$core$async$state_machine__16153__auto____0 = (function (){
var statearr_17621 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17621[(0)] = cljs$core$async$state_machine__16153__auto__);

(statearr_17621[(1)] = (1));

return statearr_17621;
});
var cljs$core$async$state_machine__16153__auto____1 = (function (state_17604){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_17604);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e17622){var ex__16156__auto__ = e17622;
var statearr_17623_17638 = state_17604;
(statearr_17623_17638[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_17604[(4)]))){
var statearr_17624_17639 = state_17604;
(statearr_17624_17639[(1)] = cljs.core.first((state_17604[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__17640 = state_17604;
state_17604 = G__17640;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$state_machine__16153__auto__ = function(state_17604){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16153__auto____1.call(this,state_17604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16153__auto____0;
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16153__auto____1;
return cljs$core$async$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_17625 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_17625[(6)] = c__16227__auto___17627);

return statearr_17625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__17642 = arguments.length;
switch (G__17642) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16227__auto___17688 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_17666){
var state_val_17667 = (state_17666[(1)]);
if((state_val_17667 === (7))){
var inst_17648 = (state_17666[(7)]);
var inst_17648__$1 = (state_17666[(2)]);
var inst_17649 = (inst_17648__$1 == null);
var inst_17650 = cljs.core.not(inst_17649);
var state_17666__$1 = (function (){var statearr_17668 = state_17666;
(statearr_17668[(7)] = inst_17648__$1);

return statearr_17668;
})();
if(inst_17650){
var statearr_17669_17689 = state_17666__$1;
(statearr_17669_17689[(1)] = (8));

} else {
var statearr_17670_17690 = state_17666__$1;
(statearr_17670_17690[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17667 === (1))){
var inst_17643 = (0);
var state_17666__$1 = (function (){var statearr_17671 = state_17666;
(statearr_17671[(8)] = inst_17643);

return statearr_17671;
})();
var statearr_17672_17691 = state_17666__$1;
(statearr_17672_17691[(2)] = null);

(statearr_17672_17691[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17667 === (4))){
var state_17666__$1 = state_17666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17666__$1,(7),ch);
} else {
if((state_val_17667 === (6))){
var inst_17661 = (state_17666[(2)]);
var state_17666__$1 = state_17666;
var statearr_17673_17692 = state_17666__$1;
(statearr_17673_17692[(2)] = inst_17661);

(statearr_17673_17692[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17667 === (3))){
var inst_17663 = (state_17666[(2)]);
var inst_17664 = cljs.core.async.close_BANG_(out);
var state_17666__$1 = (function (){var statearr_17674 = state_17666;
(statearr_17674[(9)] = inst_17663);

return statearr_17674;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17666__$1,inst_17664);
} else {
if((state_val_17667 === (2))){
var inst_17643 = (state_17666[(8)]);
var inst_17645 = (inst_17643 < n);
var state_17666__$1 = state_17666;
if(cljs.core.truth_(inst_17645)){
var statearr_17675_17693 = state_17666__$1;
(statearr_17675_17693[(1)] = (4));

} else {
var statearr_17676_17694 = state_17666__$1;
(statearr_17676_17694[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17667 === (11))){
var inst_17643 = (state_17666[(8)]);
var inst_17653 = (state_17666[(2)]);
var inst_17654 = (inst_17643 + (1));
var inst_17643__$1 = inst_17654;
var state_17666__$1 = (function (){var statearr_17677 = state_17666;
(statearr_17677[(10)] = inst_17653);

(statearr_17677[(8)] = inst_17643__$1);

return statearr_17677;
})();
var statearr_17678_17695 = state_17666__$1;
(statearr_17678_17695[(2)] = null);

(statearr_17678_17695[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17667 === (9))){
var state_17666__$1 = state_17666;
var statearr_17679_17696 = state_17666__$1;
(statearr_17679_17696[(2)] = null);

(statearr_17679_17696[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17667 === (5))){
var state_17666__$1 = state_17666;
var statearr_17680_17697 = state_17666__$1;
(statearr_17680_17697[(2)] = null);

(statearr_17680_17697[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17667 === (10))){
var inst_17658 = (state_17666[(2)]);
var state_17666__$1 = state_17666;
var statearr_17681_17698 = state_17666__$1;
(statearr_17681_17698[(2)] = inst_17658);

(statearr_17681_17698[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17667 === (8))){
var inst_17648 = (state_17666[(7)]);
var state_17666__$1 = state_17666;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17666__$1,(11),out,inst_17648);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16153__auto__ = null;
var cljs$core$async$state_machine__16153__auto____0 = (function (){
var statearr_17682 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17682[(0)] = cljs$core$async$state_machine__16153__auto__);

(statearr_17682[(1)] = (1));

return statearr_17682;
});
var cljs$core$async$state_machine__16153__auto____1 = (function (state_17666){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_17666);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e17683){var ex__16156__auto__ = e17683;
var statearr_17684_17699 = state_17666;
(statearr_17684_17699[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_17666[(4)]))){
var statearr_17685_17700 = state_17666;
(statearr_17685_17700[(1)] = cljs.core.first((state_17666[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__17701 = state_17666;
state_17666 = G__17701;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$state_machine__16153__auto__ = function(state_17666){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16153__auto____1.call(this,state_17666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16153__auto____0;
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16153__auto____1;
return cljs$core$async$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_17686 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_17686[(6)] = c__16227__auto___17688);

return statearr_17686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17703 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17703 = (function (f,ch,meta17704){
this.f = f;
this.ch = ch;
this.meta17704 = meta17704;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17703.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17705,meta17704__$1){
var self__ = this;
var _17705__$1 = this;
return (new cljs.core.async.t_cljs$core$async17703(self__.f,self__.ch,meta17704__$1));
}));

(cljs.core.async.t_cljs$core$async17703.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17705){
var self__ = this;
var _17705__$1 = this;
return self__.meta17704;
}));

(cljs.core.async.t_cljs$core$async17703.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17703.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17703.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17703.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17703.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17706 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17706 = (function (f,ch,meta17704,_,fn1,meta17707){
this.f = f;
this.ch = ch;
this.meta17704 = meta17704;
this._ = _;
this.fn1 = fn1;
this.meta17707 = meta17707;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17706.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17708,meta17707__$1){
var self__ = this;
var _17708__$1 = this;
return (new cljs.core.async.t_cljs$core$async17706(self__.f,self__.ch,self__.meta17704,self__._,self__.fn1,meta17707__$1));
}));

(cljs.core.async.t_cljs$core$async17706.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17708){
var self__ = this;
var _17708__$1 = this;
return self__.meta17707;
}));

(cljs.core.async.t_cljs$core$async17706.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17706.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async17706.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async17706.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__17702_SHARP_){
var G__17709 = (((p1__17702_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__17702_SHARP_) : self__.f.call(null,p1__17702_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__17709) : f1.call(null,G__17709));
});
}));

(cljs.core.async.t_cljs$core$async17706.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17704,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async17703], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta17707], null);
}));

(cljs.core.async.t_cljs$core$async17706.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17706.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17706");

(cljs.core.async.t_cljs$core$async17706.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async17706");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17706.
 */
cljs.core.async.__GT_t_cljs$core$async17706 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17706(f__$1,ch__$1,meta17704__$1,___$2,fn1__$1,meta17707){
return (new cljs.core.async.t_cljs$core$async17706(f__$1,ch__$1,meta17704__$1,___$2,fn1__$1,meta17707));
});

}

return (new cljs.core.async.t_cljs$core$async17706(self__.f,self__.ch,self__.meta17704,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4221__auto__ = ret;
if(cljs.core.truth_(and__4221__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4221__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__17710 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__17710) : self__.f.call(null,G__17710));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async17703.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17703.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async17703.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17704], null);
}));

(cljs.core.async.t_cljs$core$async17703.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17703.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17703");

(cljs.core.async.t_cljs$core$async17703.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async17703");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17703.
 */
cljs.core.async.__GT_t_cljs$core$async17703 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17703(f__$1,ch__$1,meta17704){
return (new cljs.core.async.t_cljs$core$async17703(f__$1,ch__$1,meta17704));
});

}

return (new cljs.core.async.t_cljs$core$async17703(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17711 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17711 = (function (f,ch,meta17712){
this.f = f;
this.ch = ch;
this.meta17712 = meta17712;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17711.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17713,meta17712__$1){
var self__ = this;
var _17713__$1 = this;
return (new cljs.core.async.t_cljs$core$async17711(self__.f,self__.ch,meta17712__$1));
}));

(cljs.core.async.t_cljs$core$async17711.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17713){
var self__ = this;
var _17713__$1 = this;
return self__.meta17712;
}));

(cljs.core.async.t_cljs$core$async17711.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17711.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17711.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17711.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async17711.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17711.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async17711.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17712], null);
}));

(cljs.core.async.t_cljs$core$async17711.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17711.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17711");

(cljs.core.async.t_cljs$core$async17711.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async17711");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17711.
 */
cljs.core.async.__GT_t_cljs$core$async17711 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async17711(f__$1,ch__$1,meta17712){
return (new cljs.core.async.t_cljs$core$async17711(f__$1,ch__$1,meta17712));
});

}

return (new cljs.core.async.t_cljs$core$async17711(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17714 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17714 = (function (p,ch,meta17715){
this.p = p;
this.ch = ch;
this.meta17715 = meta17715;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17714.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17716,meta17715__$1){
var self__ = this;
var _17716__$1 = this;
return (new cljs.core.async.t_cljs$core$async17714(self__.p,self__.ch,meta17715__$1));
}));

(cljs.core.async.t_cljs$core$async17714.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17716){
var self__ = this;
var _17716__$1 = this;
return self__.meta17715;
}));

(cljs.core.async.t_cljs$core$async17714.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17714.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17714.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17714.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17714.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async17714.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17714.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async17714.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17715], null);
}));

(cljs.core.async.t_cljs$core$async17714.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17714.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17714");

(cljs.core.async.t_cljs$core$async17714.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async17714");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17714.
 */
cljs.core.async.__GT_t_cljs$core$async17714 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async17714(p__$1,ch__$1,meta17715){
return (new cljs.core.async.t_cljs$core$async17714(p__$1,ch__$1,meta17715));
});

}

return (new cljs.core.async.t_cljs$core$async17714(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__17718 = arguments.length;
switch (G__17718) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16227__auto___17759 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_17739){
var state_val_17740 = (state_17739[(1)]);
if((state_val_17740 === (7))){
var inst_17735 = (state_17739[(2)]);
var state_17739__$1 = state_17739;
var statearr_17741_17760 = state_17739__$1;
(statearr_17741_17760[(2)] = inst_17735);

(statearr_17741_17760[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17740 === (1))){
var state_17739__$1 = state_17739;
var statearr_17742_17761 = state_17739__$1;
(statearr_17742_17761[(2)] = null);

(statearr_17742_17761[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17740 === (4))){
var inst_17721 = (state_17739[(7)]);
var inst_17721__$1 = (state_17739[(2)]);
var inst_17722 = (inst_17721__$1 == null);
var state_17739__$1 = (function (){var statearr_17743 = state_17739;
(statearr_17743[(7)] = inst_17721__$1);

return statearr_17743;
})();
if(cljs.core.truth_(inst_17722)){
var statearr_17744_17762 = state_17739__$1;
(statearr_17744_17762[(1)] = (5));

} else {
var statearr_17745_17763 = state_17739__$1;
(statearr_17745_17763[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17740 === (6))){
var inst_17721 = (state_17739[(7)]);
var inst_17726 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17721) : p.call(null,inst_17721));
var state_17739__$1 = state_17739;
if(cljs.core.truth_(inst_17726)){
var statearr_17746_17764 = state_17739__$1;
(statearr_17746_17764[(1)] = (8));

} else {
var statearr_17747_17765 = state_17739__$1;
(statearr_17747_17765[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17740 === (3))){
var inst_17737 = (state_17739[(2)]);
var state_17739__$1 = state_17739;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17739__$1,inst_17737);
} else {
if((state_val_17740 === (2))){
var state_17739__$1 = state_17739;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17739__$1,(4),ch);
} else {
if((state_val_17740 === (11))){
var inst_17729 = (state_17739[(2)]);
var state_17739__$1 = state_17739;
var statearr_17748_17766 = state_17739__$1;
(statearr_17748_17766[(2)] = inst_17729);

(statearr_17748_17766[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17740 === (9))){
var state_17739__$1 = state_17739;
var statearr_17749_17767 = state_17739__$1;
(statearr_17749_17767[(2)] = null);

(statearr_17749_17767[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17740 === (5))){
var inst_17724 = cljs.core.async.close_BANG_(out);
var state_17739__$1 = state_17739;
var statearr_17750_17768 = state_17739__$1;
(statearr_17750_17768[(2)] = inst_17724);

(statearr_17750_17768[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17740 === (10))){
var inst_17732 = (state_17739[(2)]);
var state_17739__$1 = (function (){var statearr_17751 = state_17739;
(statearr_17751[(8)] = inst_17732);

return statearr_17751;
})();
var statearr_17752_17769 = state_17739__$1;
(statearr_17752_17769[(2)] = null);

(statearr_17752_17769[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17740 === (8))){
var inst_17721 = (state_17739[(7)]);
var state_17739__$1 = state_17739;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17739__$1,(11),out,inst_17721);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16153__auto__ = null;
var cljs$core$async$state_machine__16153__auto____0 = (function (){
var statearr_17753 = [null,null,null,null,null,null,null,null,null];
(statearr_17753[(0)] = cljs$core$async$state_machine__16153__auto__);

(statearr_17753[(1)] = (1));

return statearr_17753;
});
var cljs$core$async$state_machine__16153__auto____1 = (function (state_17739){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_17739);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e17754){var ex__16156__auto__ = e17754;
var statearr_17755_17770 = state_17739;
(statearr_17755_17770[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_17739[(4)]))){
var statearr_17756_17771 = state_17739;
(statearr_17756_17771[(1)] = cljs.core.first((state_17739[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__17772 = state_17739;
state_17739 = G__17772;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$state_machine__16153__auto__ = function(state_17739){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16153__auto____1.call(this,state_17739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16153__auto____0;
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16153__auto____1;
return cljs$core$async$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_17757 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_17757[(6)] = c__16227__auto___17759);

return statearr_17757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__17774 = arguments.length;
switch (G__17774) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_17837){
var state_val_17838 = (state_17837[(1)]);
if((state_val_17838 === (7))){
var inst_17833 = (state_17837[(2)]);
var state_17837__$1 = state_17837;
var statearr_17839_17878 = state_17837__$1;
(statearr_17839_17878[(2)] = inst_17833);

(statearr_17839_17878[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (20))){
var inst_17803 = (state_17837[(7)]);
var inst_17814 = (state_17837[(2)]);
var inst_17815 = cljs.core.next(inst_17803);
var inst_17789 = inst_17815;
var inst_17790 = null;
var inst_17791 = (0);
var inst_17792 = (0);
var state_17837__$1 = (function (){var statearr_17840 = state_17837;
(statearr_17840[(8)] = inst_17792);

(statearr_17840[(9)] = inst_17790);

(statearr_17840[(10)] = inst_17789);

(statearr_17840[(11)] = inst_17791);

(statearr_17840[(12)] = inst_17814);

return statearr_17840;
})();
var statearr_17841_17879 = state_17837__$1;
(statearr_17841_17879[(2)] = null);

(statearr_17841_17879[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (1))){
var state_17837__$1 = state_17837;
var statearr_17842_17880 = state_17837__$1;
(statearr_17842_17880[(2)] = null);

(statearr_17842_17880[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (4))){
var inst_17778 = (state_17837[(13)]);
var inst_17778__$1 = (state_17837[(2)]);
var inst_17779 = (inst_17778__$1 == null);
var state_17837__$1 = (function (){var statearr_17843 = state_17837;
(statearr_17843[(13)] = inst_17778__$1);

return statearr_17843;
})();
if(cljs.core.truth_(inst_17779)){
var statearr_17844_17881 = state_17837__$1;
(statearr_17844_17881[(1)] = (5));

} else {
var statearr_17845_17882 = state_17837__$1;
(statearr_17845_17882[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (15))){
var state_17837__$1 = state_17837;
var statearr_17849_17883 = state_17837__$1;
(statearr_17849_17883[(2)] = null);

(statearr_17849_17883[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (21))){
var state_17837__$1 = state_17837;
var statearr_17850_17884 = state_17837__$1;
(statearr_17850_17884[(2)] = null);

(statearr_17850_17884[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (13))){
var inst_17792 = (state_17837[(8)]);
var inst_17790 = (state_17837[(9)]);
var inst_17789 = (state_17837[(10)]);
var inst_17791 = (state_17837[(11)]);
var inst_17799 = (state_17837[(2)]);
var inst_17800 = (inst_17792 + (1));
var tmp17846 = inst_17790;
var tmp17847 = inst_17789;
var tmp17848 = inst_17791;
var inst_17789__$1 = tmp17847;
var inst_17790__$1 = tmp17846;
var inst_17791__$1 = tmp17848;
var inst_17792__$1 = inst_17800;
var state_17837__$1 = (function (){var statearr_17851 = state_17837;
(statearr_17851[(14)] = inst_17799);

(statearr_17851[(8)] = inst_17792__$1);

(statearr_17851[(9)] = inst_17790__$1);

(statearr_17851[(10)] = inst_17789__$1);

(statearr_17851[(11)] = inst_17791__$1);

return statearr_17851;
})();
var statearr_17852_17885 = state_17837__$1;
(statearr_17852_17885[(2)] = null);

(statearr_17852_17885[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (22))){
var state_17837__$1 = state_17837;
var statearr_17853_17886 = state_17837__$1;
(statearr_17853_17886[(2)] = null);

(statearr_17853_17886[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (6))){
var inst_17778 = (state_17837[(13)]);
var inst_17787 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17778) : f.call(null,inst_17778));
var inst_17788 = cljs.core.seq(inst_17787);
var inst_17789 = inst_17788;
var inst_17790 = null;
var inst_17791 = (0);
var inst_17792 = (0);
var state_17837__$1 = (function (){var statearr_17854 = state_17837;
(statearr_17854[(8)] = inst_17792);

(statearr_17854[(9)] = inst_17790);

(statearr_17854[(10)] = inst_17789);

(statearr_17854[(11)] = inst_17791);

return statearr_17854;
})();
var statearr_17855_17887 = state_17837__$1;
(statearr_17855_17887[(2)] = null);

(statearr_17855_17887[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (17))){
var inst_17803 = (state_17837[(7)]);
var inst_17807 = cljs.core.chunk_first(inst_17803);
var inst_17808 = cljs.core.chunk_rest(inst_17803);
var inst_17809 = cljs.core.count(inst_17807);
var inst_17789 = inst_17808;
var inst_17790 = inst_17807;
var inst_17791 = inst_17809;
var inst_17792 = (0);
var state_17837__$1 = (function (){var statearr_17856 = state_17837;
(statearr_17856[(8)] = inst_17792);

(statearr_17856[(9)] = inst_17790);

(statearr_17856[(10)] = inst_17789);

(statearr_17856[(11)] = inst_17791);

return statearr_17856;
})();
var statearr_17857_17888 = state_17837__$1;
(statearr_17857_17888[(2)] = null);

(statearr_17857_17888[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (3))){
var inst_17835 = (state_17837[(2)]);
var state_17837__$1 = state_17837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17837__$1,inst_17835);
} else {
if((state_val_17838 === (12))){
var inst_17823 = (state_17837[(2)]);
var state_17837__$1 = state_17837;
var statearr_17858_17889 = state_17837__$1;
(statearr_17858_17889[(2)] = inst_17823);

(statearr_17858_17889[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (2))){
var state_17837__$1 = state_17837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17837__$1,(4),in$);
} else {
if((state_val_17838 === (23))){
var inst_17831 = (state_17837[(2)]);
var state_17837__$1 = state_17837;
var statearr_17859_17890 = state_17837__$1;
(statearr_17859_17890[(2)] = inst_17831);

(statearr_17859_17890[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (19))){
var inst_17818 = (state_17837[(2)]);
var state_17837__$1 = state_17837;
var statearr_17860_17891 = state_17837__$1;
(statearr_17860_17891[(2)] = inst_17818);

(statearr_17860_17891[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (11))){
var inst_17803 = (state_17837[(7)]);
var inst_17789 = (state_17837[(10)]);
var inst_17803__$1 = cljs.core.seq(inst_17789);
var state_17837__$1 = (function (){var statearr_17861 = state_17837;
(statearr_17861[(7)] = inst_17803__$1);

return statearr_17861;
})();
if(inst_17803__$1){
var statearr_17862_17892 = state_17837__$1;
(statearr_17862_17892[(1)] = (14));

} else {
var statearr_17863_17893 = state_17837__$1;
(statearr_17863_17893[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (9))){
var inst_17825 = (state_17837[(2)]);
var inst_17826 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_17837__$1 = (function (){var statearr_17864 = state_17837;
(statearr_17864[(15)] = inst_17825);

return statearr_17864;
})();
if(cljs.core.truth_(inst_17826)){
var statearr_17865_17894 = state_17837__$1;
(statearr_17865_17894[(1)] = (21));

} else {
var statearr_17866_17895 = state_17837__$1;
(statearr_17866_17895[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (5))){
var inst_17781 = cljs.core.async.close_BANG_(out);
var state_17837__$1 = state_17837;
var statearr_17867_17896 = state_17837__$1;
(statearr_17867_17896[(2)] = inst_17781);

(statearr_17867_17896[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (14))){
var inst_17803 = (state_17837[(7)]);
var inst_17805 = cljs.core.chunked_seq_QMARK_(inst_17803);
var state_17837__$1 = state_17837;
if(inst_17805){
var statearr_17868_17897 = state_17837__$1;
(statearr_17868_17897[(1)] = (17));

} else {
var statearr_17869_17898 = state_17837__$1;
(statearr_17869_17898[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (16))){
var inst_17821 = (state_17837[(2)]);
var state_17837__$1 = state_17837;
var statearr_17870_17899 = state_17837__$1;
(statearr_17870_17899[(2)] = inst_17821);

(statearr_17870_17899[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17838 === (10))){
var inst_17792 = (state_17837[(8)]);
var inst_17790 = (state_17837[(9)]);
var inst_17797 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17790,inst_17792);
var state_17837__$1 = state_17837;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17837__$1,(13),out,inst_17797);
} else {
if((state_val_17838 === (18))){
var inst_17803 = (state_17837[(7)]);
var inst_17812 = cljs.core.first(inst_17803);
var state_17837__$1 = state_17837;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17837__$1,(20),out,inst_17812);
} else {
if((state_val_17838 === (8))){
var inst_17792 = (state_17837[(8)]);
var inst_17791 = (state_17837[(11)]);
var inst_17794 = (inst_17792 < inst_17791);
var inst_17795 = inst_17794;
var state_17837__$1 = state_17837;
if(cljs.core.truth_(inst_17795)){
var statearr_17871_17900 = state_17837__$1;
(statearr_17871_17900[(1)] = (10));

} else {
var statearr_17872_17901 = state_17837__$1;
(statearr_17872_17901[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16153__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16153__auto____0 = (function (){
var statearr_17873 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17873[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16153__auto__);

(statearr_17873[(1)] = (1));

return statearr_17873;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16153__auto____1 = (function (state_17837){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_17837);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e17874){var ex__16156__auto__ = e17874;
var statearr_17875_17902 = state_17837;
(statearr_17875_17902[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_17837[(4)]))){
var statearr_17876_17903 = state_17837;
(statearr_17876_17903[(1)] = cljs.core.first((state_17837[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__17904 = state_17837;
state_17837 = G__17904;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16153__auto__ = function(state_17837){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16153__auto____1.call(this,state_17837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16153__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16153__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_17877 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_17877[(6)] = c__16227__auto__);

return statearr_17877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__17906 = arguments.length;
switch (G__17906) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__17909 = arguments.length;
switch (G__17909) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__17912 = arguments.length;
switch (G__17912) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16227__auto___17960 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_17936){
var state_val_17937 = (state_17936[(1)]);
if((state_val_17937 === (7))){
var inst_17931 = (state_17936[(2)]);
var state_17936__$1 = state_17936;
var statearr_17938_17961 = state_17936__$1;
(statearr_17938_17961[(2)] = inst_17931);

(statearr_17938_17961[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17937 === (1))){
var inst_17913 = null;
var state_17936__$1 = (function (){var statearr_17939 = state_17936;
(statearr_17939[(7)] = inst_17913);

return statearr_17939;
})();
var statearr_17940_17962 = state_17936__$1;
(statearr_17940_17962[(2)] = null);

(statearr_17940_17962[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17937 === (4))){
var inst_17916 = (state_17936[(8)]);
var inst_17916__$1 = (state_17936[(2)]);
var inst_17917 = (inst_17916__$1 == null);
var inst_17918 = cljs.core.not(inst_17917);
var state_17936__$1 = (function (){var statearr_17941 = state_17936;
(statearr_17941[(8)] = inst_17916__$1);

return statearr_17941;
})();
if(inst_17918){
var statearr_17942_17963 = state_17936__$1;
(statearr_17942_17963[(1)] = (5));

} else {
var statearr_17943_17964 = state_17936__$1;
(statearr_17943_17964[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17937 === (6))){
var state_17936__$1 = state_17936;
var statearr_17944_17965 = state_17936__$1;
(statearr_17944_17965[(2)] = null);

(statearr_17944_17965[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17937 === (3))){
var inst_17933 = (state_17936[(2)]);
var inst_17934 = cljs.core.async.close_BANG_(out);
var state_17936__$1 = (function (){var statearr_17945 = state_17936;
(statearr_17945[(9)] = inst_17933);

return statearr_17945;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17936__$1,inst_17934);
} else {
if((state_val_17937 === (2))){
var state_17936__$1 = state_17936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17936__$1,(4),ch);
} else {
if((state_val_17937 === (11))){
var inst_17916 = (state_17936[(8)]);
var inst_17925 = (state_17936[(2)]);
var inst_17913 = inst_17916;
var state_17936__$1 = (function (){var statearr_17946 = state_17936;
(statearr_17946[(10)] = inst_17925);

(statearr_17946[(7)] = inst_17913);

return statearr_17946;
})();
var statearr_17947_17966 = state_17936__$1;
(statearr_17947_17966[(2)] = null);

(statearr_17947_17966[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17937 === (9))){
var inst_17916 = (state_17936[(8)]);
var state_17936__$1 = state_17936;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17936__$1,(11),out,inst_17916);
} else {
if((state_val_17937 === (5))){
var inst_17916 = (state_17936[(8)]);
var inst_17913 = (state_17936[(7)]);
var inst_17920 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17916,inst_17913);
var state_17936__$1 = state_17936;
if(inst_17920){
var statearr_17949_17967 = state_17936__$1;
(statearr_17949_17967[(1)] = (8));

} else {
var statearr_17950_17968 = state_17936__$1;
(statearr_17950_17968[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17937 === (10))){
var inst_17928 = (state_17936[(2)]);
var state_17936__$1 = state_17936;
var statearr_17951_17969 = state_17936__$1;
(statearr_17951_17969[(2)] = inst_17928);

(statearr_17951_17969[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17937 === (8))){
var inst_17913 = (state_17936[(7)]);
var tmp17948 = inst_17913;
var inst_17913__$1 = tmp17948;
var state_17936__$1 = (function (){var statearr_17952 = state_17936;
(statearr_17952[(7)] = inst_17913__$1);

return statearr_17952;
})();
var statearr_17953_17970 = state_17936__$1;
(statearr_17953_17970[(2)] = null);

(statearr_17953_17970[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16153__auto__ = null;
var cljs$core$async$state_machine__16153__auto____0 = (function (){
var statearr_17954 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17954[(0)] = cljs$core$async$state_machine__16153__auto__);

(statearr_17954[(1)] = (1));

return statearr_17954;
});
var cljs$core$async$state_machine__16153__auto____1 = (function (state_17936){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_17936);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e17955){var ex__16156__auto__ = e17955;
var statearr_17956_17971 = state_17936;
(statearr_17956_17971[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_17936[(4)]))){
var statearr_17957_17972 = state_17936;
(statearr_17957_17972[(1)] = cljs.core.first((state_17936[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__17973 = state_17936;
state_17936 = G__17973;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$state_machine__16153__auto__ = function(state_17936){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16153__auto____1.call(this,state_17936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16153__auto____0;
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16153__auto____1;
return cljs$core$async$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_17958 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_17958[(6)] = c__16227__auto___17960);

return statearr_17958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__17975 = arguments.length;
switch (G__17975) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16227__auto___18042 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_18013){
var state_val_18014 = (state_18013[(1)]);
if((state_val_18014 === (7))){
var inst_18009 = (state_18013[(2)]);
var state_18013__$1 = state_18013;
var statearr_18015_18043 = state_18013__$1;
(statearr_18015_18043[(2)] = inst_18009);

(statearr_18015_18043[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18014 === (1))){
var inst_17976 = (new Array(n));
var inst_17977 = inst_17976;
var inst_17978 = (0);
var state_18013__$1 = (function (){var statearr_18016 = state_18013;
(statearr_18016[(7)] = inst_17978);

(statearr_18016[(8)] = inst_17977);

return statearr_18016;
})();
var statearr_18017_18044 = state_18013__$1;
(statearr_18017_18044[(2)] = null);

(statearr_18017_18044[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18014 === (4))){
var inst_17981 = (state_18013[(9)]);
var inst_17981__$1 = (state_18013[(2)]);
var inst_17982 = (inst_17981__$1 == null);
var inst_17983 = cljs.core.not(inst_17982);
var state_18013__$1 = (function (){var statearr_18018 = state_18013;
(statearr_18018[(9)] = inst_17981__$1);

return statearr_18018;
})();
if(inst_17983){
var statearr_18019_18045 = state_18013__$1;
(statearr_18019_18045[(1)] = (5));

} else {
var statearr_18020_18046 = state_18013__$1;
(statearr_18020_18046[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18014 === (15))){
var inst_18003 = (state_18013[(2)]);
var state_18013__$1 = state_18013;
var statearr_18021_18047 = state_18013__$1;
(statearr_18021_18047[(2)] = inst_18003);

(statearr_18021_18047[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18014 === (13))){
var state_18013__$1 = state_18013;
var statearr_18022_18048 = state_18013__$1;
(statearr_18022_18048[(2)] = null);

(statearr_18022_18048[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18014 === (6))){
var inst_17978 = (state_18013[(7)]);
var inst_17999 = (inst_17978 > (0));
var state_18013__$1 = state_18013;
if(cljs.core.truth_(inst_17999)){
var statearr_18023_18049 = state_18013__$1;
(statearr_18023_18049[(1)] = (12));

} else {
var statearr_18024_18050 = state_18013__$1;
(statearr_18024_18050[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18014 === (3))){
var inst_18011 = (state_18013[(2)]);
var state_18013__$1 = state_18013;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18013__$1,inst_18011);
} else {
if((state_val_18014 === (12))){
var inst_17977 = (state_18013[(8)]);
var inst_18001 = cljs.core.vec(inst_17977);
var state_18013__$1 = state_18013;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18013__$1,(15),out,inst_18001);
} else {
if((state_val_18014 === (2))){
var state_18013__$1 = state_18013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18013__$1,(4),ch);
} else {
if((state_val_18014 === (11))){
var inst_17993 = (state_18013[(2)]);
var inst_17994 = (new Array(n));
var inst_17977 = inst_17994;
var inst_17978 = (0);
var state_18013__$1 = (function (){var statearr_18025 = state_18013;
(statearr_18025[(7)] = inst_17978);

(statearr_18025[(8)] = inst_17977);

(statearr_18025[(10)] = inst_17993);

return statearr_18025;
})();
var statearr_18026_18051 = state_18013__$1;
(statearr_18026_18051[(2)] = null);

(statearr_18026_18051[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18014 === (9))){
var inst_17977 = (state_18013[(8)]);
var inst_17991 = cljs.core.vec(inst_17977);
var state_18013__$1 = state_18013;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18013__$1,(11),out,inst_17991);
} else {
if((state_val_18014 === (5))){
var inst_17978 = (state_18013[(7)]);
var inst_17986 = (state_18013[(11)]);
var inst_17977 = (state_18013[(8)]);
var inst_17981 = (state_18013[(9)]);
var inst_17985 = (inst_17977[inst_17978] = inst_17981);
var inst_17986__$1 = (inst_17978 + (1));
var inst_17987 = (inst_17986__$1 < n);
var state_18013__$1 = (function (){var statearr_18027 = state_18013;
(statearr_18027[(11)] = inst_17986__$1);

(statearr_18027[(12)] = inst_17985);

return statearr_18027;
})();
if(cljs.core.truth_(inst_17987)){
var statearr_18028_18052 = state_18013__$1;
(statearr_18028_18052[(1)] = (8));

} else {
var statearr_18029_18053 = state_18013__$1;
(statearr_18029_18053[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18014 === (14))){
var inst_18006 = (state_18013[(2)]);
var inst_18007 = cljs.core.async.close_BANG_(out);
var state_18013__$1 = (function (){var statearr_18031 = state_18013;
(statearr_18031[(13)] = inst_18006);

return statearr_18031;
})();
var statearr_18032_18054 = state_18013__$1;
(statearr_18032_18054[(2)] = inst_18007);

(statearr_18032_18054[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18014 === (10))){
var inst_17997 = (state_18013[(2)]);
var state_18013__$1 = state_18013;
var statearr_18033_18055 = state_18013__$1;
(statearr_18033_18055[(2)] = inst_17997);

(statearr_18033_18055[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18014 === (8))){
var inst_17986 = (state_18013[(11)]);
var inst_17977 = (state_18013[(8)]);
var tmp18030 = inst_17977;
var inst_17977__$1 = tmp18030;
var inst_17978 = inst_17986;
var state_18013__$1 = (function (){var statearr_18034 = state_18013;
(statearr_18034[(7)] = inst_17978);

(statearr_18034[(8)] = inst_17977__$1);

return statearr_18034;
})();
var statearr_18035_18056 = state_18013__$1;
(statearr_18035_18056[(2)] = null);

(statearr_18035_18056[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16153__auto__ = null;
var cljs$core$async$state_machine__16153__auto____0 = (function (){
var statearr_18036 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18036[(0)] = cljs$core$async$state_machine__16153__auto__);

(statearr_18036[(1)] = (1));

return statearr_18036;
});
var cljs$core$async$state_machine__16153__auto____1 = (function (state_18013){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_18013);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e18037){var ex__16156__auto__ = e18037;
var statearr_18038_18057 = state_18013;
(statearr_18038_18057[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_18013[(4)]))){
var statearr_18039_18058 = state_18013;
(statearr_18039_18058[(1)] = cljs.core.first((state_18013[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__18059 = state_18013;
state_18013 = G__18059;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$state_machine__16153__auto__ = function(state_18013){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16153__auto____1.call(this,state_18013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16153__auto____0;
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16153__auto____1;
return cljs$core$async$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_18040 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_18040[(6)] = c__16227__auto___18042);

return statearr_18040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__18061 = arguments.length;
switch (G__18061) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16227__auto___18139 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_18106){
var state_val_18107 = (state_18106[(1)]);
if((state_val_18107 === (7))){
var inst_18102 = (state_18106[(2)]);
var state_18106__$1 = state_18106;
var statearr_18108_18140 = state_18106__$1;
(statearr_18108_18140[(2)] = inst_18102);

(statearr_18108_18140[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18107 === (1))){
var inst_18062 = [];
var inst_18063 = inst_18062;
var inst_18064 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_18106__$1 = (function (){var statearr_18109 = state_18106;
(statearr_18109[(7)] = inst_18063);

(statearr_18109[(8)] = inst_18064);

return statearr_18109;
})();
var statearr_18110_18141 = state_18106__$1;
(statearr_18110_18141[(2)] = null);

(statearr_18110_18141[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18107 === (4))){
var inst_18067 = (state_18106[(9)]);
var inst_18067__$1 = (state_18106[(2)]);
var inst_18068 = (inst_18067__$1 == null);
var inst_18069 = cljs.core.not(inst_18068);
var state_18106__$1 = (function (){var statearr_18111 = state_18106;
(statearr_18111[(9)] = inst_18067__$1);

return statearr_18111;
})();
if(inst_18069){
var statearr_18112_18142 = state_18106__$1;
(statearr_18112_18142[(1)] = (5));

} else {
var statearr_18113_18143 = state_18106__$1;
(statearr_18113_18143[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18107 === (15))){
var inst_18063 = (state_18106[(7)]);
var inst_18094 = cljs.core.vec(inst_18063);
var state_18106__$1 = state_18106;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18106__$1,(18),out,inst_18094);
} else {
if((state_val_18107 === (13))){
var inst_18089 = (state_18106[(2)]);
var state_18106__$1 = state_18106;
var statearr_18114_18144 = state_18106__$1;
(statearr_18114_18144[(2)] = inst_18089);

(statearr_18114_18144[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18107 === (6))){
var inst_18063 = (state_18106[(7)]);
var inst_18091 = inst_18063.length;
var inst_18092 = (inst_18091 > (0));
var state_18106__$1 = state_18106;
if(cljs.core.truth_(inst_18092)){
var statearr_18115_18145 = state_18106__$1;
(statearr_18115_18145[(1)] = (15));

} else {
var statearr_18116_18146 = state_18106__$1;
(statearr_18116_18146[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18107 === (17))){
var inst_18099 = (state_18106[(2)]);
var inst_18100 = cljs.core.async.close_BANG_(out);
var state_18106__$1 = (function (){var statearr_18117 = state_18106;
(statearr_18117[(10)] = inst_18099);

return statearr_18117;
})();
var statearr_18118_18147 = state_18106__$1;
(statearr_18118_18147[(2)] = inst_18100);

(statearr_18118_18147[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18107 === (3))){
var inst_18104 = (state_18106[(2)]);
var state_18106__$1 = state_18106;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18106__$1,inst_18104);
} else {
if((state_val_18107 === (12))){
var inst_18063 = (state_18106[(7)]);
var inst_18082 = cljs.core.vec(inst_18063);
var state_18106__$1 = state_18106;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18106__$1,(14),out,inst_18082);
} else {
if((state_val_18107 === (2))){
var state_18106__$1 = state_18106;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18106__$1,(4),ch);
} else {
if((state_val_18107 === (11))){
var inst_18063 = (state_18106[(7)]);
var inst_18067 = (state_18106[(9)]);
var inst_18071 = (state_18106[(11)]);
var inst_18079 = inst_18063.push(inst_18067);
var tmp18119 = inst_18063;
var inst_18063__$1 = tmp18119;
var inst_18064 = inst_18071;
var state_18106__$1 = (function (){var statearr_18120 = state_18106;
(statearr_18120[(7)] = inst_18063__$1);

(statearr_18120[(12)] = inst_18079);

(statearr_18120[(8)] = inst_18064);

return statearr_18120;
})();
var statearr_18121_18148 = state_18106__$1;
(statearr_18121_18148[(2)] = null);

(statearr_18121_18148[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18107 === (9))){
var inst_18064 = (state_18106[(8)]);
var inst_18075 = cljs.core.keyword_identical_QMARK_(inst_18064,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var state_18106__$1 = state_18106;
var statearr_18122_18149 = state_18106__$1;
(statearr_18122_18149[(2)] = inst_18075);

(statearr_18122_18149[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18107 === (5))){
var inst_18072 = (state_18106[(13)]);
var inst_18067 = (state_18106[(9)]);
var inst_18071 = (state_18106[(11)]);
var inst_18064 = (state_18106[(8)]);
var inst_18071__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18067) : f.call(null,inst_18067));
var inst_18072__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18071__$1,inst_18064);
var state_18106__$1 = (function (){var statearr_18123 = state_18106;
(statearr_18123[(13)] = inst_18072__$1);

(statearr_18123[(11)] = inst_18071__$1);

return statearr_18123;
})();
if(inst_18072__$1){
var statearr_18124_18150 = state_18106__$1;
(statearr_18124_18150[(1)] = (8));

} else {
var statearr_18125_18151 = state_18106__$1;
(statearr_18125_18151[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18107 === (14))){
var inst_18067 = (state_18106[(9)]);
var inst_18071 = (state_18106[(11)]);
var inst_18084 = (state_18106[(2)]);
var inst_18085 = [];
var inst_18086 = inst_18085.push(inst_18067);
var inst_18063 = inst_18085;
var inst_18064 = inst_18071;
var state_18106__$1 = (function (){var statearr_18126 = state_18106;
(statearr_18126[(7)] = inst_18063);

(statearr_18126[(14)] = inst_18084);

(statearr_18126[(15)] = inst_18086);

(statearr_18126[(8)] = inst_18064);

return statearr_18126;
})();
var statearr_18127_18152 = state_18106__$1;
(statearr_18127_18152[(2)] = null);

(statearr_18127_18152[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18107 === (16))){
var state_18106__$1 = state_18106;
var statearr_18128_18153 = state_18106__$1;
(statearr_18128_18153[(2)] = null);

(statearr_18128_18153[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18107 === (10))){
var inst_18077 = (state_18106[(2)]);
var state_18106__$1 = state_18106;
if(cljs.core.truth_(inst_18077)){
var statearr_18129_18154 = state_18106__$1;
(statearr_18129_18154[(1)] = (11));

} else {
var statearr_18130_18155 = state_18106__$1;
(statearr_18130_18155[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18107 === (18))){
var inst_18096 = (state_18106[(2)]);
var state_18106__$1 = state_18106;
var statearr_18131_18156 = state_18106__$1;
(statearr_18131_18156[(2)] = inst_18096);

(statearr_18131_18156[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18107 === (8))){
var inst_18072 = (state_18106[(13)]);
var state_18106__$1 = state_18106;
var statearr_18132_18157 = state_18106__$1;
(statearr_18132_18157[(2)] = inst_18072);

(statearr_18132_18157[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16153__auto__ = null;
var cljs$core$async$state_machine__16153__auto____0 = (function (){
var statearr_18133 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18133[(0)] = cljs$core$async$state_machine__16153__auto__);

(statearr_18133[(1)] = (1));

return statearr_18133;
});
var cljs$core$async$state_machine__16153__auto____1 = (function (state_18106){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_18106);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e18134){var ex__16156__auto__ = e18134;
var statearr_18135_18158 = state_18106;
(statearr_18135_18158[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_18106[(4)]))){
var statearr_18136_18159 = state_18106;
(statearr_18136_18159[(1)] = cljs.core.first((state_18106[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__18160 = state_18106;
state_18106 = G__18160;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
cljs$core$async$state_machine__16153__auto__ = function(state_18106){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16153__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16153__auto____1.call(this,state_18106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16153__auto____0;
cljs$core$async$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16153__auto____1;
return cljs$core$async$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_18137 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_18137[(6)] = c__16227__auto___18139);

return statearr_18137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

