// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(500)], 0)));
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(500)], 0)));
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__4221__auto__ = typeof value === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__4221__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$cas,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$subs,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,300,null,300,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,714,null,714,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,230,null,230,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,157,null,157,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_cas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$cas,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,812,null,812,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$compare_DASH_val,cljs.core.cst$sym$new_DASH_val], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,521,null,521,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,427,null,427,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,145,null,145,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,388,null,388,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,256,null,256,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,86,null,86,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,726,null,726,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,533,null,533,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,607,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,620,null,620,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,750,null,750,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,98,null,98,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,169,null,169,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,778,null,778,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,696,null,696,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,414,null,414,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,466,null,466,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,788,null,788,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,73,null,73,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,188,null,188,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,568,null,568,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,659,null,659,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,453,null,453,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,109,null,109,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,594,null,594,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,1,506,null,506,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,332,332,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,558,null,558,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,545,null,545,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,800,null,800,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not_EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not_EQ_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,440,null,440,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,270,null,270,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,121,null,121,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,401,null,401,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,581,null,581,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,762,null,762,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,1,347,347,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,361,361,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,684,null,684,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,214,null,214,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,58,null,58,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_subs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$subs,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,133,null,133,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,633,null,633,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,201,null,201,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,646,null,646,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,479,null,479,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,1,288,null,288,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,738,null,738,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,243,null,243,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"/Users/lois/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,671,null,671,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__76135 = cljs.core.meta(f);
var map__76135__$1 = cljs.core.__destructure_map(map__76135);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76135__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76135__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4221__auto__ = (function (){var G__76137 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__76136 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__76136.cljs$core$IFn$_invoke$arity$1 ? fexpr__76136.cljs$core$IFn$_invoke$arity$1(G__76137) : fexpr__76136.call(null,G__76137));
})();
if(cljs.core.truth_(and__4221__auto__)){
var G__76139 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__76138 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__76138.cljs$core$IFn$_invoke$arity$1 ? fexpr__76138.cljs$core$IFn$_invoke$arity$1(G__76139) : fexpr__76138.call(null,G__76139));
} else {
return and__4221__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__76134_SHARP_){
return (cljs.core.count(p1__76134_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_fn,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_76233){
var state_val_76234 = (state_76233[(1)]);
if((state_val_76234 === (7))){
var state_76233__$1 = state_76233;
var statearr_76235_76277 = state_76233__$1;
(statearr_76235_76277[(2)] = null);

(statearr_76235_76277[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (20))){
var inst_76215 = (state_76233[(7)]);
var inst_76218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76219 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_76220 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_76221 = [inst_76219,inst_76220,fn_name];
var inst_76222 = (new cljs.core.PersistentVector(null,3,(5),inst_76218,inst_76221,null));
var inst_76223 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_76222,inst_76215);
var state_76233__$1 = state_76233;
var statearr_76236_76278 = state_76233__$1;
(statearr_76236_76278[(2)] = inst_76223);

(statearr_76236_76278[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (1))){
var state_76233__$1 = state_76233;
var statearr_76237_76279 = state_76233__$1;
(statearr_76237_76279[(2)] = null);

(statearr_76237_76279[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (4))){
var inst_76140 = (state_76233[(2)]);
var state_76233__$1 = state_76233;
var statearr_76238_76280 = state_76233__$1;
(statearr_76238_76280[(2)] = inst_76140);

(statearr_76238_76280[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (15))){
var inst_76179 = (state_76233[(8)]);
var inst_76178 = (state_76233[(2)]);
var inst_76179__$1 = fluree.db.util.async.throw_err(inst_76178);
var inst_76180 = cljs.core.empty_QMARK_(inst_76179__$1);
var state_76233__$1 = (function (){var statearr_76239 = state_76233;
(statearr_76239[(8)] = inst_76179__$1);

return statearr_76239;
})();
if(inst_76180){
var statearr_76240_76281 = state_76233__$1;
(statearr_76240_76281[(1)] = (16));

} else {
var statearr_76241_76282 = state_76233__$1;
(statearr_76241_76282[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (21))){
var state_76233__$1 = state_76233;
var statearr_76242_76283 = state_76233__$1;
(statearr_76242_76283[(2)] = null);

(statearr_76242_76283[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (13))){
var inst_76175 = (state_76233[(9)]);
var inst_76166 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_76167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76168 = ["_fn/params","_fn/code","_fn/spec"];
var inst_76169 = (new cljs.core.PersistentVector(null,3,(5),inst_76167,inst_76168,null));
var inst_76170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76171 = cljs.core.name(fn_name);
var inst_76172 = ["_fn/name",inst_76171];
var inst_76173 = (new cljs.core.PersistentVector(null,2,(5),inst_76170,inst_76172,null));
var inst_76174 = [inst_76169,inst_76173];
var inst_76175__$1 = cljs.core.PersistentHashMap.fromArrays(inst_76166,inst_76174);
var inst_76176 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_76175__$1);
var state_76233__$1 = (function (){var statearr_76243 = state_76233;
(statearr_76243[(9)] = inst_76175__$1);

return statearr_76243;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76233__$1,(15),inst_76176);
} else {
if((state_val_76234 === (22))){
var inst_76215 = (state_76233[(7)]);
var inst_76226 = (state_76233[(2)]);
var state_76233__$1 = (function (){var statearr_76244 = state_76233;
(statearr_76244[(10)] = inst_76226);

return statearr_76244;
})();
var statearr_76245_76284 = state_76233__$1;
(statearr_76245_76284[(2)] = inst_76215);

(statearr_76245_76284[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (6))){
var inst_76149 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_76150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76151 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_76152 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_76153 = [inst_76151,inst_76152,fn_name];
var inst_76154 = (new cljs.core.PersistentVector(null,3,(5),inst_76150,inst_76153,null));
var inst_76155 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76149,inst_76154);
var state_76233__$1 = state_76233;
var statearr_76246_76285 = state_76233__$1;
(statearr_76246_76285[(2)] = inst_76155);

(statearr_76246_76285[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (17))){
var state_76233__$1 = state_76233;
var statearr_76247_76286 = state_76233__$1;
(statearr_76247_76286[(2)] = null);

(statearr_76247_76286[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (3))){
var inst_76231 = (state_76233[(2)]);
var state_76233__$1 = state_76233;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76233__$1,inst_76231);
} else {
if((state_val_76234 === (12))){
var inst_76162 = (state_76233[(11)]);
var inst_76164 = fluree.db.dbfunctions.core.resolve_local_fn(inst_76162);
var state_76233__$1 = state_76233;
var statearr_76248_76287 = state_76233__$1;
(statearr_76248_76287[(2)] = inst_76164);

(statearr_76248_76287[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (2))){
var inst_76146 = (state_76233[(12)]);
var _ = (function (){var statearr_76249 = state_76233;
(statearr_76249[(4)] = cljs.core.cons((5),(state_76233[(4)])));

return statearr_76249;
})();
var inst_76146__$1 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_76147 = cljs.core.not(inst_76146__$1);
var state_76233__$1 = (function (){var statearr_76250 = state_76233;
(statearr_76250[(12)] = inst_76146__$1);

return statearr_76250;
})();
if(inst_76147){
var statearr_76251_76288 = state_76233__$1;
(statearr_76251_76288[(1)] = (6));

} else {
var statearr_76252_76289 = state_76233__$1;
(statearr_76252_76289[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (19))){
var inst_76175 = (state_76233[(9)]);
var inst_76193 = (state_76233[(13)]);
var inst_76179 = (state_76233[(8)]);
var inst_76162 = (state_76233[(11)]);
var inst_76146 = (state_76233[(12)]);
var inst_76158 = (state_76233[(14)]);
var inst_76191 = (state_76233[(15)]);
var inst_76198 = (state_76233[(2)]);
var inst_76199 = fluree.db.util.async.throw_err(inst_76198);
var inst_76200 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76179,"_fn/spec");
var inst_76201 = cljs.core.PersistentVector.EMPTY;
var inst_76202 = cljs.core.cst$sym$_QMARK_ctx;
var inst_76203 = (function (){var res = inst_76179;
var query = inst_76175;
var forward_time_travel_db_QMARK_ = inst_76146;
var _ = inst_76191;
var params = inst_76193;
var temp__5751__auto__ = inst_76162;
var or__4223__auto__ = inst_76158;
var spec = inst_76200;
var code = inst_76199;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_76204 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_76203,inst_76193);
var inst_76205 = cljs.core.cons(inst_76202,inst_76204);
var inst_76206 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_76201,inst_76205);
var inst_76207 = fluree.db.dbfunctions.core.build_fn(inst_76206,inst_76199);
var inst_76208 = [cljs.core.cst$kw$f,cljs.core.cst$kw$params,cljs.core.cst$kw$arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,cljs.core.cst$kw$code];
var inst_76209 = cljs.core.count(inst_76193);
var inst_76210 = [inst_76209];
var inst_76211 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_76210);
var inst_76212 = [inst_76207,inst_76193,inst_76211,false,inst_76200,null];
var inst_76213 = cljs.core.PersistentHashMap.fromArrays(inst_76208,inst_76212);
var state_76233__$1 = state_76233;
var statearr_76253_76290 = state_76233__$1;
(statearr_76253_76290[(2)] = inst_76213);

(statearr_76253_76290[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (11))){
var inst_76228 = (state_76233[(2)]);
var _ = (function (){var statearr_76255 = state_76233;
(statearr_76255[(4)] = cljs.core.rest((state_76233[(4)])));

return statearr_76255;
})();
var state_76233__$1 = state_76233;
var statearr_76256_76291 = state_76233__$1;
(statearr_76256_76291[(2)] = inst_76228);

(statearr_76256_76291[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (9))){
var inst_76158 = (state_76233[(14)]);
var state_76233__$1 = state_76233;
var statearr_76257_76292 = state_76233__$1;
(statearr_76257_76292[(2)] = inst_76158);

(statearr_76257_76292[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (5))){
var _ = (function (){var statearr_76258 = state_76233;
(statearr_76258[(4)] = cljs.core.rest((state_76233[(4)])));

return statearr_76258;
})();
var state_76233__$1 = state_76233;
var ex76254 = (state_76233__$1[(2)]);
var statearr_76259_76293 = state_76233__$1;
(statearr_76259_76293[(5)] = ex76254);


if((ex76254 instanceof Error)){
var statearr_76260_76294 = state_76233__$1;
(statearr_76260_76294[(1)] = (4));

(statearr_76260_76294[(5)] = null);

} else {
throw ex76254;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (14))){
var inst_76146 = (state_76233[(12)]);
var inst_76215 = (state_76233[(2)]);
var inst_76216 = cljs.core.not(inst_76146);
var state_76233__$1 = (function (){var statearr_76261 = state_76233;
(statearr_76261[(7)] = inst_76215);

return statearr_76261;
})();
if(inst_76216){
var statearr_76262_76295 = state_76233__$1;
(statearr_76262_76295[(1)] = (20));

} else {
var statearr_76263_76296 = state_76233__$1;
(statearr_76263_76296[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (16))){
var inst_76182 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_76183 = ["Unknown function: ",inst_76182].join('');
var inst_76184 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_76185 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_76186 = cljs.core.PersistentHashMap.fromArrays(inst_76184,inst_76185);
var inst_76187 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76183,inst_76186);
var inst_76188 = (function(){throw inst_76187})();
var state_76233__$1 = state_76233;
var statearr_76264_76297 = state_76233__$1;
(statearr_76264_76297[(2)] = inst_76188);

(statearr_76264_76297[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (10))){
var inst_76162 = (state_76233[(11)]);
var inst_76161 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name);
var inst_76162__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,inst_76161);
var state_76233__$1 = (function (){var statearr_76265 = state_76233;
(statearr_76265[(11)] = inst_76162__$1);

return statearr_76265;
})();
if(cljs.core.truth_(inst_76162__$1)){
var statearr_76266_76298 = state_76233__$1;
(statearr_76266_76298[(1)] = (12));

} else {
var statearr_76267_76299 = state_76233__$1;
(statearr_76267_76299[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76234 === (18))){
var inst_76193 = (state_76233[(13)]);
var inst_76179 = (state_76233[(8)]);
var inst_76191 = (state_76233[(2)]);
var inst_76192 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76179,"_fn/params");
var inst_76193__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_76192);
var inst_76194 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76179,"_fn/code");
var inst_76195 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_76194);
var inst_76196 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_76195,funType,inst_76193__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_76195,funType,inst_76193__$1));
var state_76233__$1 = (function (){var statearr_76268 = state_76233;
(statearr_76268[(13)] = inst_76193__$1);

(statearr_76268[(15)] = inst_76191);

return statearr_76268;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76233__$1,(19),inst_76196);
} else {
if((state_val_76234 === (8))){
var inst_76158 = (state_76233[(14)]);
var inst_76158__$1 = (state_76233[(2)]);
var state_76233__$1 = (function (){var statearr_76269 = state_76233;
(statearr_76269[(14)] = inst_76158__$1);

return statearr_76269;
})();
if(cljs.core.truth_(inst_76158__$1)){
var statearr_76270_76300 = state_76233__$1;
(statearr_76270_76300[(1)] = (9));

} else {
var statearr_76271_76301 = state_76233__$1;
(statearr_76271_76301[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16153__auto____0 = (function (){
var statearr_76272 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76272[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16153__auto__);

(statearr_76272[(1)] = (1));

return statearr_76272;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16153__auto____1 = (function (state_76233){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_76233);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e76273){var ex__16156__auto__ = e76273;
var statearr_76274_76302 = state_76233;
(statearr_76274_76302[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_76233[(4)]))){
var statearr_76275_76303 = state_76233;
(statearr_76275_76303[(1)] = cljs.core.first((state_76233[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__76304 = state_76233;
state_76233 = G__76304;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16153__auto__ = function(state_76233){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16153__auto____1.call(this,state_76233);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16153__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_76276 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_76276[(6)] = c__16227__auto__);

return statearr_76276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__76306 = arguments.length;
switch (G__76306) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__76310 = arguments.length;
switch (G__76310) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_76440){
var state_val_76441 = (state_76440[(1)]);
if((state_val_76441 === (7))){
var inst_76435 = (state_76440[(2)]);
var _ = (function (){var statearr_76442 = state_76440;
(statearr_76442[(4)] = cljs.core.rest((state_76440[(4)])));

return statearr_76442;
})();
var state_76440__$1 = state_76440;
var statearr_76443_76523 = state_76440__$1;
(statearr_76443_76523[(2)] = inst_76435);

(statearr_76443_76523[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (20))){
var inst_76349 = (state_76440[(7)]);
var state_76440__$1 = state_76440;
var statearr_76444_76524 = state_76440__$1;
(statearr_76444_76524[(2)] = inst_76349);

(statearr_76444_76524[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (27))){
var inst_76336 = (state_76440[(8)]);
var inst_76362 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_76363 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76336)," used in function.",inst_76362].join('');
var inst_76364 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_76365 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_76366 = cljs.core.PersistentHashMap.fromArrays(inst_76364,inst_76365);
var inst_76367 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76363,inst_76366);
var inst_76368 = (function(){throw inst_76367})();
var state_76440__$1 = state_76440;
var statearr_76445_76525 = state_76440__$1;
(statearr_76445_76525[(2)] = inst_76368);

(statearr_76445_76525[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (1))){
var state_76440__$1 = state_76440;
var statearr_76446_76526 = state_76440__$1;
(statearr_76446_76526[(2)] = null);

(statearr_76446_76526[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (24))){
var inst_76359 = (state_76440[(9)]);
var inst_76359__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_76440__$1 = (function (){var statearr_76447 = state_76440;
(statearr_76447[(9)] = inst_76359__$1);

return statearr_76447;
})();
if(inst_76359__$1){
var statearr_76448_76527 = state_76440__$1;
(statearr_76448_76527[(1)] = (26));

} else {
var statearr_76449_76528 = state_76440__$1;
(statearr_76449_76528[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (39))){
var inst_76336 = (state_76440[(8)]);
var inst_76396 = (inst_76336 == null);
var state_76440__$1 = state_76440;
if(cljs.core.truth_(inst_76396)){
var statearr_76450_76529 = state_76440__$1;
(statearr_76450_76529[(1)] = (42));

} else {
var statearr_76451_76530 = state_76440__$1;
(statearr_76451_76530[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (46))){
var state_76440__$1 = state_76440;
var statearr_76452_76531 = state_76440__$1;
(statearr_76452_76531[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (4))){
var inst_76311 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
var statearr_76454_76532 = state_76440__$1;
(statearr_76454_76532[(2)] = inst_76311);

(statearr_76454_76532[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (15))){
var inst_76336 = (state_76440[(8)]);
var inst_76347 = (inst_76336 instanceof cljs.core.Symbol);
var state_76440__$1 = state_76440;
if(cljs.core.truth_(inst_76347)){
var statearr_76455_76533 = state_76440__$1;
(statearr_76455_76533[(1)] = (17));

} else {
var statearr_76456_76534 = state_76440__$1;
(statearr_76456_76534[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (48))){
var inst_76403 = (state_76440[(2)]);
var inst_76404 = fluree.db.util.async.throw_err(inst_76403);
var state_76440__$1 = state_76440;
var statearr_76457_76535 = state_76440__$1;
(statearr_76457_76535[(2)] = inst_76404);

(statearr_76457_76535[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (50))){
var state_76440__$1 = state_76440;
var statearr_76458_76536 = state_76440__$1;
(statearr_76458_76536[(2)] = null);

(statearr_76458_76536[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (21))){
var inst_76349 = (state_76440[(7)]);
var inst_76337 = (state_76440[(10)]);
var inst_76324 = (state_76440[(11)]);
var inst_76326 = (state_76440[(12)]);
var inst_76329 = (state_76440[(13)]);
var inst_76336 = (state_76440[(8)]);
var inst_76327 = (state_76440[(14)]);
var inst_76356 = (state_76440[(15)]);
var inst_76330 = (state_76440[(16)]);
var inst_76352 = [inst_76336];
var inst_76353 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_76352);
var inst_76354 = (function (){var x = inst_76336;
var G__76320 = inst_76329;
var first__76323 = inst_76326;
var seq__76333 = inst_76337;
var seq__76322 = inst_76327;
var r = inst_76337;
var vec__76332 = inst_76329;
var acc = inst_76330;
var vec__76321 = inst_76324;
var or__4223__auto__ = inst_76349;
var first__76334 = inst_76336;
return (function (p1__76308_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__76308_SHARP_);
});
})();
var inst_76355 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_76354,params);
var inst_76356__$1 = cljs.core.some(inst_76353,inst_76355);
var state_76440__$1 = (function (){var statearr_76459 = state_76440;
(statearr_76459[(15)] = inst_76356__$1);

return statearr_76459;
})();
if(cljs.core.truth_(inst_76356__$1)){
var statearr_76460_76537 = state_76440__$1;
(statearr_76460_76537[(1)] = (23));

} else {
var statearr_76461_76538 = state_76440__$1;
(statearr_76461_76538[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (31))){
var inst_76386 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
if(cljs.core.truth_(inst_76386)){
var statearr_76462_76539 = state_76440__$1;
(statearr_76462_76539[(1)] = (35));

} else {
var statearr_76463_76540 = state_76440__$1;
(statearr_76463_76540[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (32))){
var inst_76379 = (state_76440[(17)]);
var state_76440__$1 = state_76440;
var statearr_76464_76541 = state_76440__$1;
(statearr_76464_76541[(2)] = inst_76379);

(statearr_76464_76541[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (40))){
var inst_76421 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
var statearr_76465_76542 = state_76440__$1;
(statearr_76465_76542[(2)] = inst_76421);

(statearr_76465_76542[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (33))){
var inst_76336 = (state_76440[(8)]);
var inst_76382 = (inst_76336 == null);
var state_76440__$1 = state_76440;
var statearr_76466_76543 = state_76440__$1;
(statearr_76466_76543[(2)] = inst_76382);

(statearr_76466_76543[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (13))){
var inst_76337 = (state_76440[(10)]);
var inst_76330 = (state_76440[(16)]);
var inst_76429 = (state_76440[(2)]);
var inst_76430 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_76330,inst_76429);
var inst_76329 = inst_76337;
var inst_76330__$1 = inst_76430;
var state_76440__$1 = (function (){var statearr_76467 = state_76440;
(statearr_76467[(13)] = inst_76329);

(statearr_76467[(16)] = inst_76330__$1);

return statearr_76467;
})();
var statearr_76468_76544 = state_76440__$1;
(statearr_76468_76544[(2)] = null);

(statearr_76468_76544[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (22))){
var inst_76374 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
var statearr_76469_76545 = state_76440__$1;
(statearr_76469_76545[(2)] = inst_76374);

(statearr_76469_76545[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (36))){
var inst_76336 = (state_76440[(8)]);
var inst_76389 = cljs.core.vector_QMARK_(inst_76336);
var state_76440__$1 = state_76440;
if(inst_76389){
var statearr_76470_76546 = state_76440__$1;
(statearr_76470_76546[(1)] = (38));

} else {
var statearr_76471_76547 = state_76440__$1;
(statearr_76471_76547[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (41))){
var inst_76393 = (state_76440[(2)]);
var inst_76394 = fluree.db.util.async.throw_err(inst_76393);
var state_76440__$1 = state_76440;
var statearr_76472_76548 = state_76440__$1;
(statearr_76472_76548[(2)] = inst_76394);

(statearr_76472_76548[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (43))){
var inst_76336 = (state_76440[(8)]);
var inst_76399 = cljs.core.list_QMARK_(inst_76336);
var state_76440__$1 = state_76440;
if(inst_76399){
var statearr_76473_76549 = state_76440__$1;
(statearr_76473_76549[(1)] = (45));

} else {
var statearr_76474_76550 = state_76440__$1;
(statearr_76474_76550[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (29))){
var inst_76376 = (state_76440[(18)]);
var state_76440__$1 = state_76440;
var statearr_76475_76551 = state_76440__$1;
(statearr_76475_76551[(2)] = inst_76376);

(statearr_76475_76551[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (44))){
var inst_76419 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
var statearr_76476_76552 = state_76440__$1;
(statearr_76476_76552[(2)] = inst_76419);

(statearr_76476_76552[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (6))){
var inst_76329 = (state_76440[(13)]);
var inst_76336 = (state_76440[(8)]);
var inst_76335 = cljs.core.seq(inst_76329);
var inst_76336__$1 = cljs.core.first(inst_76335);
var inst_76337 = cljs.core.next(inst_76335);
var inst_76338 = (inst_76336__$1 == null);
var state_76440__$1 = (function (){var statearr_76477 = state_76440;
(statearr_76477[(10)] = inst_76337);

(statearr_76477[(8)] = inst_76336__$1);

return statearr_76477;
})();
if(cljs.core.truth_(inst_76338)){
var statearr_76478_76553 = state_76440__$1;
(statearr_76478_76553[(1)] = (8));

} else {
var statearr_76479_76554 = state_76440__$1;
(statearr_76479_76554[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (28))){
var inst_76370 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
var statearr_76480_76555 = state_76440__$1;
(statearr_76480_76555[(2)] = inst_76370);

(statearr_76480_76555[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (51))){
var inst_76415 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
var statearr_76481_76556 = state_76440__$1;
(statearr_76481_76556[(2)] = inst_76415);

(statearr_76481_76556[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (25))){
var inst_76372 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
var statearr_76482_76557 = state_76440__$1;
(statearr_76482_76557[(2)] = inst_76372);

(statearr_76482_76557[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (34))){
var inst_76384 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
var statearr_76483_76558 = state_76440__$1;
(statearr_76483_76558[(2)] = inst_76384);

(statearr_76483_76558[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (17))){
var inst_76349 = (state_76440[(7)]);
var inst_76336 = (state_76440[(8)]);
var inst_76349__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_76336) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_76336));
var state_76440__$1 = (function (){var statearr_76484 = state_76440;
(statearr_76484[(7)] = inst_76349__$1);

return statearr_76484;
})();
if(cljs.core.truth_(inst_76349__$1)){
var statearr_76485_76559 = state_76440__$1;
(statearr_76485_76559[(1)] = (20));

} else {
var statearr_76486_76560 = state_76440__$1;
(statearr_76486_76560[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (3))){
var inst_76438 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76440__$1,inst_76438);
} else {
if((state_val_76441 === (12))){
var inst_76336 = (state_76440[(8)]);
var inst_76344 = typeof inst_76336 === 'number';
var state_76440__$1 = state_76440;
if(cljs.core.truth_(inst_76344)){
var statearr_76487_76561 = state_76440__$1;
(statearr_76487_76561[(1)] = (14));

} else {
var statearr_76488_76562 = state_76440__$1;
(statearr_76488_76562[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (2))){
var inst_76324 = (state_76440[(11)]);
var _ = (function (){var statearr_76489 = state_76440;
(statearr_76489[(4)] = cljs.core.cons((5),(state_76440[(4)])));

return statearr_76489;
})();
var inst_76324__$1 = vec;
var inst_76325 = cljs.core.seq(inst_76324__$1);
var inst_76326 = cljs.core.first(inst_76325);
var inst_76327 = cljs.core.next(inst_76325);
var inst_76328 = cljs.core.PersistentVector.EMPTY;
var inst_76329 = inst_76324__$1;
var inst_76330 = inst_76328;
var state_76440__$1 = (function (){var statearr_76490 = state_76440;
(statearr_76490[(11)] = inst_76324__$1);

(statearr_76490[(12)] = inst_76326);

(statearr_76490[(13)] = inst_76329);

(statearr_76490[(14)] = inst_76327);

(statearr_76490[(16)] = inst_76330);

return statearr_76490;
})();
var statearr_76491_76563 = state_76440__$1;
(statearr_76491_76563[(2)] = null);

(statearr_76491_76563[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (23))){
var inst_76356 = (state_76440[(15)]);
var state_76440__$1 = state_76440;
var statearr_76492_76564 = state_76440__$1;
(statearr_76492_76564[(2)] = inst_76356);

(statearr_76492_76564[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (47))){
var inst_76417 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
var statearr_76493_76565 = state_76440__$1;
(statearr_76493_76565[(2)] = inst_76417);

(statearr_76493_76565[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (35))){
var inst_76336 = (state_76440[(8)]);
var state_76440__$1 = state_76440;
var statearr_76494_76566 = state_76440__$1;
(statearr_76494_76566[(2)] = inst_76336);

(statearr_76494_76566[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (19))){
var inst_76425 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
var statearr_76495_76567 = state_76440__$1;
(statearr_76495_76567[(2)] = inst_76425);

(statearr_76495_76567[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (11))){
var inst_76336 = (state_76440[(8)]);
var state_76440__$1 = state_76440;
var statearr_76497_76568 = state_76440__$1;
(statearr_76497_76568[(2)] = inst_76336);

(statearr_76497_76568[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (9))){
var inst_76336 = (state_76440[(8)]);
var inst_76341 = typeof inst_76336 === 'string';
var state_76440__$1 = state_76440;
if(cljs.core.truth_(inst_76341)){
var statearr_76498_76569 = state_76440__$1;
(statearr_76498_76569[(1)] = (11));

} else {
var statearr_76499_76570 = state_76440__$1;
(statearr_76499_76570[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (5))){
var _ = (function (){var statearr_76500 = state_76440;
(statearr_76500[(4)] = cljs.core.rest((state_76440[(4)])));

return statearr_76500;
})();
var state_76440__$1 = state_76440;
var ex76496 = (state_76440__$1[(2)]);
var statearr_76501_76571 = state_76440__$1;
(statearr_76501_76571[(5)] = ex76496);


if((ex76496 instanceof Error)){
var statearr_76502_76572 = state_76440__$1;
(statearr_76502_76572[(1)] = (4));

(statearr_76502_76572[(5)] = null);

} else {
throw ex76496;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (14))){
var inst_76336 = (state_76440[(8)]);
var state_76440__$1 = state_76440;
var statearr_76503_76573 = state_76440__$1;
(statearr_76503_76573[(2)] = inst_76336);

(statearr_76503_76573[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (45))){
var inst_76336 = (state_76440[(8)]);
var inst_76401 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_76336,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_76336,funType,params));
var state_76440__$1 = state_76440;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76440__$1,(48),inst_76401);
} else {
if((state_val_76441 === (26))){
var inst_76359 = (state_76440[(9)]);
var state_76440__$1 = state_76440;
var statearr_76504_76574 = state_76440__$1;
(statearr_76504_76574[(2)] = inst_76359);

(statearr_76504_76574[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (16))){
var inst_76427 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
var statearr_76505_76575 = state_76440__$1;
(statearr_76505_76575[(2)] = inst_76427);

(statearr_76505_76575[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (38))){
var inst_76336 = (state_76440[(8)]);
var inst_76391 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_76336,funType,params);
var state_76440__$1 = state_76440;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76440__$1,(41),inst_76391);
} else {
if((state_val_76441 === (30))){
var inst_76336 = (state_76440[(8)]);
var inst_76379 = (state_76440[(17)]);
var inst_76379__$1 = inst_76336 === false;
var state_76440__$1 = (function (){var statearr_76506 = state_76440;
(statearr_76506[(17)] = inst_76379__$1);

return statearr_76506;
})();
if(cljs.core.truth_(inst_76379__$1)){
var statearr_76507_76576 = state_76440__$1;
(statearr_76507_76576[(1)] = (32));

} else {
var statearr_76508_76577 = state_76440__$1;
(statearr_76508_76577[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (10))){
var inst_76433 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
var statearr_76509_76578 = state_76440__$1;
(statearr_76509_76578[(2)] = inst_76433);

(statearr_76509_76578[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (18))){
var inst_76376 = (state_76440[(18)]);
var inst_76336 = (state_76440[(8)]);
var inst_76376__$1 = inst_76336 === true;
var state_76440__$1 = (function (){var statearr_76510 = state_76440;
(statearr_76510[(18)] = inst_76376__$1);

return statearr_76510;
})();
if(cljs.core.truth_(inst_76376__$1)){
var statearr_76511_76579 = state_76440__$1;
(statearr_76511_76579[(1)] = (29));

} else {
var statearr_76512_76580 = state_76440__$1;
(statearr_76512_76580[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (42))){
var inst_76336 = (state_76440[(8)]);
var state_76440__$1 = state_76440;
var statearr_76513_76581 = state_76440__$1;
(statearr_76513_76581[(2)] = inst_76336);

(statearr_76513_76581[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (37))){
var inst_76423 = (state_76440[(2)]);
var state_76440__$1 = state_76440;
var statearr_76514_76582 = state_76440__$1;
(statearr_76514_76582[(2)] = inst_76423);

(statearr_76514_76582[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (8))){
var inst_76330 = (state_76440[(16)]);
var state_76440__$1 = state_76440;
var statearr_76515_76583 = state_76440__$1;
(statearr_76515_76583[(2)] = inst_76330);

(statearr_76515_76583[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76441 === (49))){
var inst_76336 = (state_76440[(8)]);
var inst_76407 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76336], 0));
var inst_76408 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_76409 = ["Illegal element (",inst_76407,") in vector: ",inst_76408,"."].join('');
var inst_76410 = cljs.core.PersistentHashMap.EMPTY;
var inst_76411 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76409,inst_76410);
var inst_76412 = (function(){throw inst_76411})();
var state_76440__$1 = state_76440;
var statearr_76516_76584 = state_76440__$1;
(statearr_76516_76584[(2)] = inst_76412);

(statearr_76516_76584[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__16153__auto____0 = (function (){
var statearr_76517 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76517[(0)] = fluree$db$dbfunctions$core$state_machine__16153__auto__);

(statearr_76517[(1)] = (1));

return statearr_76517;
});
var fluree$db$dbfunctions$core$state_machine__16153__auto____1 = (function (state_76440){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_76440);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e76518){var ex__16156__auto__ = e76518;
var statearr_76519_76585 = state_76440;
(statearr_76519_76585[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_76440[(4)]))){
var statearr_76520_76586 = state_76440;
(statearr_76520_76586[(1)] = cljs.core.first((state_76440[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__76587 = state_76440;
state_76440 = G__76587;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__16153__auto__ = function(state_76440){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__16153__auto____1.call(this,state_76440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__16153__auto____0;
fluree$db$dbfunctions$core$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__16153__auto____1;
return fluree$db$dbfunctions$core$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_76521 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_76521[(6)] = c__16227__auto__);

return statearr_76521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__76590 = arguments.length;
switch (G__76590) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_76754){
var state_val_76755 = (state_76754[(1)]);
if((state_val_76755 === (7))){
var inst_76609 = (state_76754[(7)]);
var state_76754__$1 = state_76754;
var statearr_76756_76851 = state_76754__$1;
(statearr_76756_76851[(2)] = inst_76609);

(statearr_76756_76851[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (59))){
var inst_76642 = (state_76754[(8)]);
var inst_76716 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76642], 0));
var inst_76717 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_76642) : type.call(null,inst_76642));
var inst_76718 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_76719 = ["Illegal element (",inst_76716,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76717),") in function argument: ",inst_76718,"."].join('');
var inst_76720 = cljs.core.PersistentHashMap.EMPTY;
var inst_76721 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76719,inst_76720);
var inst_76722 = (function(){throw inst_76721})();
var state_76754__$1 = state_76754;
var statearr_76757_76852 = state_76754__$1;
(statearr_76757_76852[(2)] = inst_76722);

(statearr_76757_76852[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (20))){
var inst_76744 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
var statearr_76758_76853 = state_76754__$1;
(statearr_76758_76853[(2)] = inst_76744);

(statearr_76758_76853[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (58))){
var inst_76727 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
var statearr_76759_76854 = state_76754__$1;
(statearr_76759_76854[(2)] = inst_76727);

(statearr_76759_76854[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (60))){
var state_76754__$1 = state_76754;
var statearr_76760_76855 = state_76754__$1;
(statearr_76760_76855[(2)] = null);

(statearr_76760_76855[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (27))){
var inst_76737 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
var statearr_76761_76856 = state_76754__$1;
(statearr_76761_76856[(2)] = inst_76737);

(statearr_76761_76856[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (1))){
var state_76754__$1 = state_76754;
var statearr_76762_76857 = state_76754__$1;
(statearr_76762_76857[(2)] = null);

(statearr_76762_76857[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (24))){
var inst_76654 = (state_76754[(2)]);
var inst_76655 = fluree.db.util.async.throw_err(inst_76654);
var state_76754__$1 = state_76754;
var statearr_76763_76858 = state_76754__$1;
(statearr_76763_76858[(2)] = inst_76655);

(statearr_76763_76858[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (55))){
var inst_76709 = (state_76754[(2)]);
var inst_76710 = fluree.db.util.async.throw_err(inst_76709);
var state_76754__$1 = state_76754;
var statearr_76764_76859 = state_76754__$1;
(statearr_76764_76859[(2)] = inst_76710);

(statearr_76764_76859[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (39))){
var inst_76688 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
var statearr_76765_76860 = state_76754__$1;
(statearr_76765_76860[(2)] = inst_76688);

(statearr_76765_76860[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (46))){
var inst_76695 = (state_76754[(9)]);
var state_76754__$1 = state_76754;
var statearr_76766_76861 = state_76754__$1;
(statearr_76766_76861[(2)] = inst_76695);

(statearr_76766_76861[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (4))){
var inst_76591 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
var statearr_76767_76862 = state_76754__$1;
(statearr_76767_76862[(2)] = inst_76591);

(statearr_76767_76862[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (54))){
var inst_76729 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
var statearr_76768_76863 = state_76754__$1;
(statearr_76768_76863[(2)] = inst_76729);

(statearr_76768_76863[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (15))){
var inst_76642 = (state_76754[(8)]);
var state_76754__$1 = state_76754;
var statearr_76769_76864 = state_76754__$1;
(statearr_76769_76864[(2)] = inst_76642);

(statearr_76769_76864[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (48))){
var inst_76700 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
var statearr_76770_76865 = state_76754__$1;
(statearr_76770_76865[(2)] = inst_76700);

(statearr_76770_76865[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (50))){
var inst_76642 = (state_76754[(8)]);
var inst_76705 = cljs.core.vector_QMARK_(inst_76642);
var state_76754__$1 = state_76754;
if(inst_76705){
var statearr_76771_76866 = state_76754__$1;
(statearr_76771_76866[(1)] = (52));

} else {
var statearr_76772_76867 = state_76754__$1;
(statearr_76772_76867[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (21))){
var inst_76642 = (state_76754[(8)]);
var inst_76652 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_76642,type,params);
var state_76754__$1 = state_76754;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76754__$1,(24),inst_76652);
} else {
if((state_val_76755 === (31))){
var inst_76665 = (state_76754[(10)]);
var inst_76642 = (state_76754[(8)]);
var inst_76665__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_76642) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_76642));
var state_76754__$1 = (function (){var statearr_76773 = state_76754;
(statearr_76773[(10)] = inst_76665__$1);

return statearr_76773;
})();
if(cljs.core.truth_(inst_76665__$1)){
var statearr_76774_76868 = state_76754__$1;
(statearr_76774_76868[(1)] = (34));

} else {
var statearr_76775_76869 = state_76754__$1;
(statearr_76775_76869[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (32))){
var inst_76642 = (state_76754[(8)]);
var inst_76692 = (state_76754[(11)]);
var inst_76692__$1 = inst_76642 === true;
var state_76754__$1 = (function (){var statearr_76776 = state_76754;
(statearr_76776[(11)] = inst_76692__$1);

return statearr_76776;
})();
if(cljs.core.truth_(inst_76692__$1)){
var statearr_76777_76870 = state_76754__$1;
(statearr_76777_76870[(1)] = (43));

} else {
var statearr_76778_76871 = state_76754__$1;
(statearr_76778_76871[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (40))){
var inst_76675 = (state_76754[(12)]);
var state_76754__$1 = state_76754;
var statearr_76779_76872 = state_76754__$1;
(statearr_76779_76872[(2)] = inst_76675);

(statearr_76779_76872[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (56))){
var inst_76642 = (state_76754[(8)]);
var state_76754__$1 = state_76754;
var statearr_76780_76873 = state_76754__$1;
(statearr_76780_76873[(2)] = inst_76642);

(statearr_76780_76873[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (33))){
var inst_76733 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
var statearr_76781_76874 = state_76754__$1;
(statearr_76781_76874[(2)] = inst_76733);

(statearr_76781_76874[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (13))){
var inst_76642 = (state_76754[(8)]);
var inst_76635 = (state_76754[(13)]);
var inst_76641 = cljs.core.seq(inst_76635);
var inst_76642__$1 = cljs.core.first(inst_76641);
var inst_76643 = cljs.core.next(inst_76641);
var state_76754__$1 = (function (){var statearr_76782 = state_76754;
(statearr_76782[(8)] = inst_76642__$1);

(statearr_76782[(14)] = inst_76643);

return statearr_76782;
})();
if(cljs.core.truth_(inst_76642__$1)){
var statearr_76783_76875 = state_76754__$1;
(statearr_76783_76875[(1)] = (15));

} else {
var statearr_76784_76876 = state_76754__$1;
(statearr_76784_76876[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (22))){
var inst_76642 = (state_76754[(8)]);
var inst_76657 = typeof inst_76642 === 'string';
var state_76754__$1 = state_76754;
if(cljs.core.truth_(inst_76657)){
var statearr_76785_76877 = state_76754__$1;
(statearr_76785_76877[(1)] = (25));

} else {
var statearr_76786_76878 = state_76754__$1;
(statearr_76786_76878[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (36))){
var inst_76690 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
var statearr_76787_76879 = state_76754__$1;
(statearr_76787_76879[(2)] = inst_76690);

(statearr_76787_76879[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (41))){
var inst_76642 = (state_76754[(8)]);
var inst_76678 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_76679 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76642)," used in function argument: ",inst_76678].join('');
var inst_76680 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_76681 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_76682 = cljs.core.PersistentHashMap.fromArrays(inst_76680,inst_76681);
var inst_76683 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76679,inst_76682);
var inst_76684 = (function(){throw inst_76683})();
var state_76754__$1 = state_76754;
var statearr_76788_76880 = state_76754__$1;
(statearr_76788_76880[(2)] = inst_76684);

(statearr_76788_76880[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (43))){
var inst_76692 = (state_76754[(11)]);
var state_76754__$1 = state_76754;
var statearr_76789_76881 = state_76754__$1;
(statearr_76789_76881[(2)] = inst_76692);

(statearr_76789_76881[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (61))){
var inst_76725 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
var statearr_76790_76882 = state_76754__$1;
(statearr_76790_76882[(2)] = inst_76725);

(statearr_76790_76882[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (29))){
var inst_76642 = (state_76754[(8)]);
var inst_76663 = (inst_76642 instanceof cljs.core.Symbol);
var state_76754__$1 = state_76754;
if(cljs.core.truth_(inst_76663)){
var statearr_76791_76883 = state_76754__$1;
(statearr_76791_76883[(1)] = (31));

} else {
var statearr_76792_76884 = state_76754__$1;
(statearr_76792_76884[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (44))){
var inst_76642 = (state_76754[(8)]);
var inst_76695 = (state_76754[(9)]);
var inst_76695__$1 = inst_76642 === false;
var state_76754__$1 = (function (){var statearr_76793 = state_76754;
(statearr_76793[(9)] = inst_76695__$1);

return statearr_76793;
})();
if(cljs.core.truth_(inst_76695__$1)){
var statearr_76794_76885 = state_76754__$1;
(statearr_76794_76885[(1)] = (46));

} else {
var statearr_76795_76886 = state_76754__$1;
(statearr_76795_76886[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (6))){
var inst_76605 = (state_76754[(15)]);
var inst_76604 = (state_76754[(16)]);
var inst_76609 = (state_76754[(7)]);
var inst_76603 = (state_76754[(2)]);
var inst_76604__$1 = fluree.db.util.async.throw_err(inst_76603);
var inst_76605__$1 = cljs.core.__destructure_map(inst_76604__$1);
var inst_76606 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76605__$1,cljs.core.cst$kw$f);
var inst_76607 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76605__$1,cljs.core.cst$kw$arity);
var inst_76608 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76605__$1,cljs.core.cst$kw$arglist);
var inst_76609__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_76605__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_76754__$1 = (function (){var statearr_76796 = state_76754;
(statearr_76796[(15)] = inst_76605__$1);

(statearr_76796[(17)] = inst_76606);

(statearr_76796[(16)] = inst_76604__$1);

(statearr_76796[(18)] = inst_76607);

(statearr_76796[(7)] = inst_76609__$1);

(statearr_76796[(19)] = inst_76608);

return statearr_76796;
})();
if(cljs.core.truth_(inst_76609__$1)){
var statearr_76797_76887 = state_76754__$1;
(statearr_76797_76887[(1)] = (7));

} else {
var statearr_76798_76888 = state_76754__$1;
(statearr_76798_76888[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (28))){
var inst_76642 = (state_76754[(8)]);
var state_76754__$1 = state_76754;
var statearr_76799_76889 = state_76754__$1;
(statearr_76799_76889[(2)] = inst_76642);

(statearr_76799_76889[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (51))){
var inst_76731 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
var statearr_76800_76890 = state_76754__$1;
(statearr_76800_76890[(2)] = inst_76731);

(statearr_76800_76890[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (25))){
var inst_76642 = (state_76754[(8)]);
var state_76754__$1 = state_76754;
var statearr_76801_76891 = state_76754__$1;
(statearr_76801_76891[(2)] = inst_76642);

(statearr_76801_76891[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (34))){
var inst_76665 = (state_76754[(10)]);
var state_76754__$1 = state_76754;
var statearr_76802_76892 = state_76754__$1;
(statearr_76802_76892[(2)] = inst_76665);

(statearr_76802_76892[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (17))){
var inst_76648 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
if(cljs.core.truth_(inst_76648)){
var statearr_76803_76893 = state_76754__$1;
(statearr_76803_76893[(1)] = (18));

} else {
var statearr_76804_76894 = state_76754__$1;
(statearr_76804_76894[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (3))){
var inst_76752 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76754__$1,inst_76752);
} else {
if((state_val_76755 === (12))){
var inst_76599 = (state_76754[(20)]);
var inst_76623 = (state_76754[(2)]);
var inst_76631 = cljs.core.seq(inst_76599);
var inst_76632 = cljs.core.first(inst_76631);
var inst_76633 = cljs.core.next(inst_76631);
var inst_76634 = cljs.core.PersistentVector.EMPTY;
var inst_76635 = inst_76599;
var inst_76636 = inst_76634;
var state_76754__$1 = (function (){var statearr_76805 = state_76754;
(statearr_76805[(21)] = inst_76636);

(statearr_76805[(22)] = inst_76632);

(statearr_76805[(13)] = inst_76635);

(statearr_76805[(23)] = inst_76623);

(statearr_76805[(24)] = inst_76633);

return statearr_76805;
})();
var statearr_76806_76895 = state_76754__$1;
(statearr_76806_76895[(2)] = null);

(statearr_76806_76895[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (2))){
var inst_76598 = (state_76754[(25)]);
var inst_76599 = (state_76754[(20)]);
var _ = (function (){var statearr_76807 = state_76754;
(statearr_76807[(4)] = cljs.core.cons((5),(state_76754[(4)])));

return statearr_76807;
})();
var inst_76598__$1 = cljs.core.first(form);
var inst_76599__$1 = cljs.core.rest(form);
var inst_76600 = cljs.core.count(inst_76599__$1);
var inst_76601 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_76598__$1,type);
var state_76754__$1 = (function (){var statearr_76808 = state_76754;
(statearr_76808[(25)] = inst_76598__$1);

(statearr_76808[(26)] = inst_76600);

(statearr_76808[(20)] = inst_76599__$1);

return statearr_76808;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76754__$1,(6),inst_76601);
} else {
if((state_val_76755 === (23))){
var inst_76636 = (state_76754[(21)]);
var inst_76643 = (state_76754[(14)]);
var inst_76739 = (state_76754[(2)]);
var inst_76740 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_76636,inst_76739);
var inst_76635 = inst_76643;
var inst_76636__$1 = inst_76740;
var state_76754__$1 = (function (){var statearr_76809 = state_76754;
(statearr_76809[(21)] = inst_76636__$1);

(statearr_76809[(13)] = inst_76635);

return statearr_76809;
})();
var statearr_76810_76896 = state_76754__$1;
(statearr_76810_76896[(2)] = null);

(statearr_76810_76896[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (47))){
var inst_76642 = (state_76754[(8)]);
var inst_76698 = (inst_76642 == null);
var state_76754__$1 = state_76754;
var statearr_76811_76897 = state_76754__$1;
(statearr_76811_76897[(2)] = inst_76698);

(statearr_76811_76897[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (35))){
var inst_76672 = (state_76754[(27)]);
var inst_76598 = (state_76754[(25)]);
var inst_76636 = (state_76754[(21)]);
var inst_76605 = (state_76754[(15)]);
var inst_76606 = (state_76754[(17)]);
var inst_76665 = (state_76754[(10)]);
var inst_76642 = (state_76754[(8)]);
var inst_76643 = (state_76754[(14)]);
var inst_76632 = (state_76754[(22)]);
var inst_76604 = (state_76754[(16)]);
var inst_76607 = (state_76754[(18)]);
var inst_76635 = (state_76754[(13)]);
var inst_76609 = (state_76754[(7)]);
var inst_76623 = (state_76754[(23)]);
var inst_76608 = (state_76754[(19)]);
var inst_76600 = (state_76754[(26)]);
var inst_76633 = (state_76754[(24)]);
var inst_76599 = (state_76754[(20)]);
var inst_76668 = [inst_76642];
var inst_76669 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_76668);
var inst_76670 = (function (){var arity = inst_76607;
var vec__76638 = inst_76635;
var args_n = inst_76600;
var fn_map = inst_76604;
var args = inst_76599;
var r = inst_76643;
var seq__76639 = inst_76643;
var _ = inst_76623;
var acc = inst_76636;
var vec__76628 = inst_76599;
var arglist = inst_76608;
var fn_name = inst_76598;
var seq__76629 = inst_76633;
var _AMPERSAND_args_QMARK_ = inst_76609;
var or__4223__auto__ = inst_76665;
var first__76630 = inst_76632;
var arg = inst_76642;
var first__76640 = inst_76642;
var G__76627 = inst_76635;
var map__76597 = inst_76605;
var f = inst_76606;
return (function (p1__76588_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__76588_SHARP_);
});
})();
var inst_76671 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_76670,params);
var inst_76672__$1 = cljs.core.some(inst_76669,inst_76671);
var state_76754__$1 = (function (){var statearr_76812 = state_76754;
(statearr_76812[(27)] = inst_76672__$1);

return statearr_76812;
})();
if(cljs.core.truth_(inst_76672__$1)){
var statearr_76813_76898 = state_76754__$1;
(statearr_76813_76898[(1)] = (37));

} else {
var statearr_76814_76899 = state_76754__$1;
(statearr_76814_76899[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (19))){
var inst_76636 = (state_76754[(21)]);
var state_76754__$1 = state_76754;
var statearr_76815_76900 = state_76754__$1;
(statearr_76815_76900[(2)] = inst_76636);

(statearr_76815_76900[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (57))){
var state_76754__$1 = state_76754;
var statearr_76816_76901 = state_76754__$1;
(statearr_76816_76901[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (11))){
var state_76754__$1 = state_76754;
var statearr_76819_76902 = state_76754__$1;
(statearr_76819_76902[(2)] = null);

(statearr_76819_76902[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (9))){
var inst_76614 = (state_76754[(2)]);
var inst_76615 = cljs.core.not(inst_76614);
var state_76754__$1 = state_76754;
if(inst_76615){
var statearr_76820_76903 = state_76754__$1;
(statearr_76820_76903[(1)] = (10));

} else {
var statearr_76821_76904 = state_76754__$1;
(statearr_76821_76904[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (5))){
var _ = (function (){var statearr_76822 = state_76754;
(statearr_76822[(4)] = cljs.core.rest((state_76754[(4)])));

return statearr_76822;
})();
var state_76754__$1 = state_76754;
var ex76818 = (state_76754__$1[(2)]);
var statearr_76823_76905 = state_76754__$1;
(statearr_76823_76905[(5)] = ex76818);


if((ex76818 instanceof Error)){
var statearr_76824_76906 = state_76754__$1;
(statearr_76824_76906[(1)] = (4));

(statearr_76824_76906[(5)] = null);

} else {
throw ex76818;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (14))){
var inst_76606 = (state_76754[(17)]);
var inst_76746 = (state_76754[(2)]);
var inst_76747 = cljs.core.cst$sym$_QMARK_ctx;
var inst_76748 = cljs.core.cons(inst_76747,inst_76746);
var inst_76749 = cljs.core.cons(inst_76606,inst_76748);
var _ = (function (){var statearr_76825 = state_76754;
(statearr_76825[(4)] = cljs.core.rest((state_76754[(4)])));

return statearr_76825;
})();
var state_76754__$1 = state_76754;
var statearr_76826_76907 = state_76754__$1;
(statearr_76826_76907[(2)] = inst_76749);

(statearr_76826_76907[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (45))){
var inst_76702 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
if(cljs.core.truth_(inst_76702)){
var statearr_76827_76908 = state_76754__$1;
(statearr_76827_76908[(1)] = (49));

} else {
var statearr_76828_76909 = state_76754__$1;
(statearr_76828_76909[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (53))){
var inst_76642 = (state_76754[(8)]);
var inst_76712 = (inst_76642 == null);
var state_76754__$1 = state_76754;
if(cljs.core.truth_(inst_76712)){
var statearr_76829_76910 = state_76754__$1;
(statearr_76829_76910[(1)] = (56));

} else {
var statearr_76830_76911 = state_76754__$1;
(statearr_76830_76911[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (26))){
var inst_76642 = (state_76754[(8)]);
var inst_76660 = typeof inst_76642 === 'number';
var state_76754__$1 = state_76754;
if(cljs.core.truth_(inst_76660)){
var statearr_76831_76912 = state_76754__$1;
(statearr_76831_76912[(1)] = (28));

} else {
var statearr_76832_76913 = state_76754__$1;
(statearr_76832_76913[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (16))){
var inst_76642 = (state_76754[(8)]);
var inst_76646 = inst_76642 === false;
var state_76754__$1 = state_76754;
var statearr_76833_76914 = state_76754__$1;
(statearr_76833_76914[(2)] = inst_76646);

(statearr_76833_76914[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (38))){
var inst_76675 = (state_76754[(12)]);
var inst_76675__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_76754__$1 = (function (){var statearr_76834 = state_76754;
(statearr_76834[(12)] = inst_76675__$1);

return statearr_76834;
})();
if(inst_76675__$1){
var statearr_76835_76915 = state_76754__$1;
(statearr_76835_76915[(1)] = (40));

} else {
var statearr_76836_76916 = state_76754__$1;
(statearr_76836_76916[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (30))){
var inst_76735 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
var statearr_76837_76917 = state_76754__$1;
(statearr_76837_76917[(2)] = inst_76735);

(statearr_76837_76917[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (10))){
var inst_76598 = (state_76754[(25)]);
var inst_76607 = (state_76754[(18)]);
var inst_76600 = (state_76754[(26)]);
var inst_76617 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76598),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76607),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76600),"."].join('');
var inst_76618 = cljs.core.PersistentHashMap.EMPTY;
var inst_76619 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76617,inst_76618);
var inst_76620 = (function(){throw inst_76619})();
var state_76754__$1 = state_76754;
var statearr_76838_76918 = state_76754__$1;
(statearr_76838_76918[(2)] = inst_76620);

(statearr_76838_76918[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (18))){
var inst_76642 = (state_76754[(8)]);
var inst_76650 = cljs.core.list_QMARK_(inst_76642);
var state_76754__$1 = state_76754;
if(inst_76650){
var statearr_76839_76919 = state_76754__$1;
(statearr_76839_76919[(1)] = (21));

} else {
var statearr_76840_76920 = state_76754__$1;
(statearr_76840_76920[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (52))){
var inst_76642 = (state_76754[(8)]);
var inst_76707 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_76642,type,params);
var state_76754__$1 = state_76754;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76754__$1,(55),inst_76707);
} else {
if((state_val_76755 === (42))){
var inst_76686 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
var statearr_76841_76921 = state_76754__$1;
(statearr_76841_76921[(2)] = inst_76686);

(statearr_76841_76921[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (37))){
var inst_76672 = (state_76754[(27)]);
var state_76754__$1 = state_76754;
var statearr_76842_76922 = state_76754__$1;
(statearr_76842_76922[(2)] = inst_76672);

(statearr_76842_76922[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (8))){
var inst_76607 = (state_76754[(18)]);
var inst_76600 = (state_76754[(26)]);
var inst_76612 = (inst_76607.cljs$core$IFn$_invoke$arity$1 ? inst_76607.cljs$core$IFn$_invoke$arity$1(inst_76600) : inst_76607.call(null,inst_76600));
var state_76754__$1 = state_76754;
var statearr_76843_76923 = state_76754__$1;
(statearr_76843_76923[(2)] = inst_76612);

(statearr_76843_76923[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76755 === (49))){
var inst_76642 = (state_76754[(8)]);
var state_76754__$1 = state_76754;
var statearr_76844_76924 = state_76754__$1;
(statearr_76844_76924[(2)] = inst_76642);

(statearr_76844_76924[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__16153__auto____0 = (function (){
var statearr_76845 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76845[(0)] = fluree$db$dbfunctions$core$state_machine__16153__auto__);

(statearr_76845[(1)] = (1));

return statearr_76845;
});
var fluree$db$dbfunctions$core$state_machine__16153__auto____1 = (function (state_76754){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_76754);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e76846){var ex__16156__auto__ = e76846;
var statearr_76847_76925 = state_76754;
(statearr_76847_76925[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_76754[(4)]))){
var statearr_76848_76926 = state_76754;
(statearr_76848_76926[(1)] = cljs.core.first((state_76754[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__76927 = state_76754;
state_76754 = G__76927;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__16153__auto__ = function(state_76754){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__16153__auto____1.call(this,state_76754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__16153__auto____0;
fluree$db$dbfunctions$core$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__16153__auto____1;
return fluree$db$dbfunctions$core$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_76849 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_76849[(6)] = c__16227__auto__);

return statearr_76849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__76929 = arguments.length;
switch (G__76929) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_77011){
var state_val_77012 = (state_77011[(1)]);
if((state_val_77012 === (7))){
var inst_76939 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var state_77011__$1 = state_77011;
var statearr_77013_77061 = state_77011__$1;
(statearr_77013_77061[(2)] = inst_76939);

(statearr_77013_77061[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (20))){
var inst_76989 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_77011__$1 = state_77011;
var statearr_77014_77062 = state_77011__$1;
(statearr_77014_77062[(2)] = inst_76989);

(statearr_77014_77062[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (1))){
var state_77011__$1 = state_77011;
var statearr_77015_77063 = state_77011__$1;
(statearr_77015_77063[(2)] = null);

(statearr_77015_77063[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (24))){
var inst_76986 = (state_77011[(7)]);
var inst_76995 = cljs.core.eval(inst_76986);
var state_77011__$1 = state_77011;
var statearr_77017_77064 = state_77011__$1;
(statearr_77017_77064[(2)] = inst_76995);

(statearr_77017_77064[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (4))){
var inst_76930 = (state_77011[(2)]);
var state_77011__$1 = state_77011;
var statearr_77018_77065 = state_77011__$1;
(statearr_77018_77065[(2)] = inst_76930);

(statearr_77018_77065[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (15))){
var _ = (function (){var statearr_77019 = state_77011;
(statearr_77019[(4)] = cljs.core.rest((state_77011[(4)])));

return statearr_77019;
})();
var state_77011__$1 = state_77011;
var ex77016 = (state_77011__$1[(2)]);
var statearr_77020_77066 = state_77011__$1;
(statearr_77020_77066[(5)] = ex77016);


var statearr_77021_77067 = state_77011__$1;
(statearr_77021_77067[(1)] = (14));

(statearr_77021_77067[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (21))){
var inst_76987 = (state_77011[(8)]);
var state_77011__$1 = state_77011;
var statearr_77022_77068 = state_77011__$1;
(statearr_77022_77068[(2)] = inst_76987);

(statearr_77022_77068[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (13))){
var inst_77004 = (state_77011[(2)]);
var state_77011__$1 = state_77011;
var statearr_77023_77069 = state_77011__$1;
(statearr_77023_77069[(2)] = inst_77004);

(statearr_77023_77069[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (22))){
var inst_76992 = (state_77011[(2)]);
var state_77011__$1 = state_77011;
if(cljs.core.truth_(inst_76992)){
var statearr_77024_77070 = state_77011__$1;
(statearr_77024_77070[(1)] = (23));

} else {
var statearr_77025_77071 = state_77011__$1;
(statearr_77025_77071[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (6))){
var inst_76936 = (state_77011[(9)]);
var state_77011__$1 = state_77011;
var statearr_77026_77072 = state_77011__$1;
(statearr_77026_77072[(2)] = inst_76936);

(statearr_77026_77072[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (25))){
var inst_76997 = (state_77011[(2)]);
var inst_76998 = [cljs.core.cst$kw$fnstr];
var inst_76999 = [fn_str];
var inst_77000 = cljs.core.PersistentHashMap.fromArrays(inst_76998,inst_76999);
var inst_77001 = cljs.core.with_meta(inst_76997,inst_77000);
var _ = (function (){var statearr_77027 = state_77011;
(statearr_77027[(4)] = cljs.core.rest((state_77011[(4)])));

return statearr_77027;
})();
var state_77011__$1 = state_77011;
var statearr_77028_77073 = state_77011__$1;
(statearr_77028_77073[(2)] = inst_77001);

(statearr_77028_77073[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (17))){
var inst_76962 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_76963 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_76964 = cljs.core.PersistentHashMap.fromArrays(inst_76962,inst_76963);
var inst_76965 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_76964);
var inst_76966 = (function(){throw inst_76965})();
var state_77011__$1 = state_77011;
var statearr_77029_77074 = state_77011__$1;
(statearr_77029_77074[(2)] = inst_76966);

(statearr_77029_77074[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (3))){
var inst_77009 = (state_77011[(2)]);
var state_77011__$1 = state_77011;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77011__$1,inst_77009);
} else {
if((state_val_77012 === (12))){
var _ = (function (){var statearr_77030 = state_77011;
(statearr_77030[(4)] = cljs.core.cons((15),(state_77011[(4)])));

return statearr_77030;
})();
var inst_76959 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_77011__$1 = state_77011;
if(cljs.core.truth_(inst_76959)){
var statearr_77031_77075 = state_77011__$1;
(statearr_77031_77075[(1)] = (16));

} else {
var statearr_77032_77076 = state_77011__$1;
(statearr_77032_77076[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (2))){
var inst_76936 = (state_77011[(9)]);
var _ = (function (){var statearr_77033 = state_77011;
(statearr_77033[(4)] = cljs.core.cons((5),(state_77011[(4)])));

return statearr_77033;
})();
var inst_76936__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var state_77011__$1 = (function (){var statearr_77034 = state_77011;
(statearr_77034[(9)] = inst_76936__$1);

return statearr_77034;
})();
if(inst_76936__$1){
var statearr_77035_77077 = state_77011__$1;
(statearr_77035_77077[(1)] = (6));

} else {
var statearr_77036_77078 = state_77011__$1;
(statearr_77036_77078[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (23))){
var inst_76986 = (state_77011[(7)]);
var state_77011__$1 = state_77011;
var statearr_77037_77079 = state_77011__$1;
(statearr_77037_77079[(2)] = inst_76986);

(statearr_77037_77079[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (19))){
var inst_76987 = (state_77011[(8)]);
var inst_76972 = (state_77011[(2)]);
var inst_76973 = fluree.db.util.async.throw_err(inst_76972);
var inst_76974 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_76975 = (new cljs.core.List(null,inst_76974,null,(1),null));
var inst_76976 = cljs.core.cst$sym$_QMARK_ctx;
var inst_76977 = (new cljs.core.List(null,inst_76976,null,(1),null));
var inst_76978 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_76977);
var inst_76979 = cljs.core.seq(inst_76978);
var inst_76980 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_76979);
var inst_76981 = cljs.core.vec(inst_76980);
var inst_76982 = (new cljs.core.List(null,inst_76981,null,(1),null));
var inst_76983 = (new cljs.core.List(null,inst_76973,null,(1),null));
var inst_76984 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_76975,inst_76982,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76983], 0));
var inst_76985 = cljs.core.seq(inst_76984);
var inst_76986 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_76985);
var inst_76987__$1 = params;
var state_77011__$1 = (function (){var statearr_77038 = state_77011;
(statearr_77038[(7)] = inst_76986);

(statearr_77038[(8)] = inst_76987__$1);

return statearr_77038;
})();
if(cljs.core.truth_(inst_76987__$1)){
var statearr_77039_77080 = state_77011__$1;
(statearr_77039_77080[(1)] = (20));

} else {
var statearr_77040_77081 = state_77011__$1;
(statearr_77040_77081[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (11))){
var inst_77006 = (state_77011[(2)]);
var _ = (function (){var statearr_77042 = state_77011;
(statearr_77042[(4)] = cljs.core.rest((state_77011[(4)])));

return statearr_77042;
})();
var state_77011__$1 = state_77011;
var statearr_77043_77082 = state_77011__$1;
(statearr_77043_77082[(2)] = inst_77006);

(statearr_77043_77082[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (9))){
var inst_76943 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_76944 = fluree.db.dbfunctions.core.true_or_false = inst_76943;
var state_77011__$1 = state_77011;
var statearr_77044_77083 = state_77011__$1;
(statearr_77044_77083[(2)] = inst_76944);

(statearr_77044_77083[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (5))){
var _ = (function (){var statearr_77045 = state_77011;
(statearr_77045[(4)] = cljs.core.rest((state_77011[(4)])));

return statearr_77045;
})();
var state_77011__$1 = state_77011;
var ex77041 = (state_77011__$1[(2)]);
var statearr_77046_77084 = state_77011__$1;
(statearr_77046_77084[(5)] = ex77041);


if((ex77041 instanceof Error)){
var statearr_77047_77085 = state_77011__$1;
(statearr_77047_77085[(1)] = (4));

(statearr_77047_77085[(5)] = null);

} else {
throw ex77041;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (14))){
var inst_76946 = (state_77011[(2)]);
var inst_76947 = (function(){throw inst_76946})();
var inst_76948 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_76949 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_76950 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_76951 = cljs.core.PersistentHashMap.fromArrays(inst_76949,inst_76950);
var inst_76952 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76948,inst_76951);
var inst_76953 = (function(){throw inst_76952})();
var state_77011__$1 = (function (){var statearr_77048 = state_77011;
(statearr_77048[(10)] = inst_76947);

return statearr_77048;
})();
var statearr_77049_77086 = state_77011__$1;
(statearr_77049_77086[(2)] = inst_76953);

(statearr_77049_77086[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (16))){
var state_77011__$1 = state_77011;
var statearr_77050_77087 = state_77011__$1;
(statearr_77050_77087[(2)] = null);

(statearr_77050_77087[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (10))){
var state_77011__$1 = state_77011;
var statearr_77051_77088 = state_77011__$1;
(statearr_77051_77088[(2)] = null);

(statearr_77051_77088[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77012 === (18))){
var inst_76968 = (state_77011[(2)]);
var inst_76969 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_76970 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_76969,type,params);
var state_77011__$1 = (function (){var statearr_77052 = state_77011;
(statearr_77052[(11)] = inst_76968);

return statearr_77052;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77011__$1,(19),inst_76970);
} else {
if((state_val_77012 === (8))){
var inst_76941 = (state_77011[(2)]);
var state_77011__$1 = state_77011;
if(cljs.core.truth_(inst_76941)){
var statearr_77053_77089 = state_77011__$1;
(statearr_77053_77089[(1)] = (9));

} else {
var statearr_77054_77090 = state_77011__$1;
(statearr_77054_77090[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__16153__auto____0 = (function (){
var statearr_77055 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77055[(0)] = fluree$db$dbfunctions$core$state_machine__16153__auto__);

(statearr_77055[(1)] = (1));

return statearr_77055;
});
var fluree$db$dbfunctions$core$state_machine__16153__auto____1 = (function (state_77011){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_77011);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e77056){var ex__16156__auto__ = e77056;
var statearr_77057_77091 = state_77011;
(statearr_77057_77091[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_77011[(4)]))){
var statearr_77058_77092 = state_77011;
(statearr_77058_77092[(1)] = cljs.core.first((state_77011[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__77093 = state_77011;
state_77011 = G__77093;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__16153__auto__ = function(state_77011){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__16153__auto____1.call(this,state_77011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__16153__auto____0;
fluree$db$dbfunctions$core$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__16153__auto____1;
return fluree$db$dbfunctions$core$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_77059 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_77059[(6)] = c__16227__auto__);

return statearr_77059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_77121){
var state_val_77122 = (state_77121[(1)]);
if((state_val_77122 === (7))){
var inst_77108 = (state_77121[(7)]);
var state_77121__$1 = state_77121;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77121__$1,(10),inst_77108);
} else {
if((state_val_77122 === (1))){
var state_77121__$1 = state_77121;
var statearr_77123_77143 = state_77121__$1;
(statearr_77123_77143[(2)] = null);

(statearr_77123_77143[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77122 === (4))){
var inst_77094 = (state_77121[(2)]);
var state_77121__$1 = state_77121;
var statearr_77124_77144 = state_77121__$1;
(statearr_77124_77144[(2)] = inst_77094);

(statearr_77124_77144[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77122 === (6))){
var inst_77108 = (state_77121[(7)]);
var inst_77103 = (state_77121[(8)]);
var inst_77106 = (state_77121[(2)]);
var inst_77107 = fluree.db.util.async.throw_err(inst_77106);
var inst_77108__$1 = (inst_77107.cljs$core$IFn$_invoke$arity$1 ? inst_77107.cljs$core$IFn$_invoke$arity$1(inst_77103) : inst_77107.call(null,inst_77103));
var inst_77109 = fluree.db.util.async.channel_QMARK_(inst_77108__$1);
var state_77121__$1 = (function (){var statearr_77125 = state_77121;
(statearr_77125[(7)] = inst_77108__$1);

return statearr_77125;
})();
if(inst_77109){
var statearr_77126_77145 = state_77121__$1;
(statearr_77126_77145[(1)] = (7));

} else {
var statearr_77127_77146 = state_77121__$1;
(statearr_77127_77146[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77122 === (3))){
var inst_77119 = (state_77121[(2)]);
var state_77121__$1 = state_77121;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77121__$1,inst_77119);
} else {
if((state_val_77122 === (2))){
var _ = (function (){var statearr_77129 = state_77121;
(statearr_77129[(4)] = cljs.core.cons((5),(state_77121[(4)])));

return statearr_77129;
})();
var inst_77100 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_77101 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_77102 = [db,block_instant,s,p,auth_id,fuel];
var inst_77103 = cljs.core.PersistentHashMap.fromArrays(inst_77101,inst_77102);
var inst_77104 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_77100,"txn",null);
var state_77121__$1 = (function (){var statearr_77130 = state_77121;
(statearr_77130[(8)] = inst_77103);

return statearr_77130;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77121__$1,(6),inst_77104);
} else {
if((state_val_77122 === (9))){
var inst_77116 = (state_77121[(2)]);
var _ = (function (){var statearr_77131 = state_77121;
(statearr_77131[(4)] = cljs.core.rest((state_77121[(4)])));

return statearr_77131;
})();
var state_77121__$1 = state_77121;
var statearr_77132_77147 = state_77121__$1;
(statearr_77132_77147[(2)] = inst_77116);

(statearr_77132_77147[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77122 === (5))){
var _ = (function (){var statearr_77133 = state_77121;
(statearr_77133[(4)] = cljs.core.rest((state_77121[(4)])));

return statearr_77133;
})();
var state_77121__$1 = state_77121;
var ex77128 = (state_77121__$1[(2)]);
var statearr_77134_77148 = state_77121__$1;
(statearr_77134_77148[(5)] = ex77128);


if((ex77128 instanceof Error)){
var statearr_77135_77149 = state_77121__$1;
(statearr_77135_77149[(1)] = (4));

(statearr_77135_77149[(5)] = null);

} else {
throw ex77128;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77122 === (10))){
var inst_77112 = (state_77121[(2)]);
var inst_77113 = fluree.db.util.async.throw_err(inst_77112);
var state_77121__$1 = state_77121;
var statearr_77136_77150 = state_77121__$1;
(statearr_77136_77150[(2)] = inst_77113);

(statearr_77136_77150[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77122 === (8))){
var inst_77108 = (state_77121[(7)]);
var state_77121__$1 = state_77121;
var statearr_77137_77151 = state_77121__$1;
(statearr_77137_77151[(2)] = inst_77108);

(statearr_77137_77151[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16153__auto____0 = (function (){
var statearr_77138 = [null,null,null,null,null,null,null,null,null];
(statearr_77138[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16153__auto__);

(statearr_77138[(1)] = (1));

return statearr_77138;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16153__auto____1 = (function (state_77121){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_77121);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e77139){var ex__16156__auto__ = e77139;
var statearr_77140_77152 = state_77121;
(statearr_77140_77152[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_77121[(4)]))){
var statearr_77141_77153 = state_77121;
(statearr_77141_77153[(1)] = cljs.core.first((state_77121[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__77154 = state_77121;
state_77121 = G__77154;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16153__auto__ = function(state_77121){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16153__auto____1.call(this,state_77121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_77142 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_77142[(6)] = c__16227__auto__);

return statearr_77142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
