// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46611 = arguments.length;
var i__4830__auto___46612 = (0);
while(true){
if((i__4830__auto___46612 < len__4829__auto___46611)){
args__4835__auto__.push((arguments[i__4830__auto___46612]));

var G__46613 = (i__4830__auto___46612 + (1));
i__4830__auto___46612 = G__46613;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq46608){
var G__46609 = cljs.core.first(seq46608);
var seq46608__$1 = cljs.core.next(seq46608);
var G__46610 = cljs.core.first(seq46608__$1);
var seq46608__$2 = cljs.core.next(seq46608__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46609,G__46610,seq46608__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e46614){var e = e46614;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e46615){var e = e46615;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e46616){var e = e46616;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e46617){var e = e46617;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e46618){var e = e46618;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46621 = arguments.length;
var i__4830__auto___46622 = (0);
while(true){
if((i__4830__auto___46622 < len__4829__auto___46621)){
args__4835__auto__.push((arguments[i__4830__auto___46622]));

var G__46623 = (i__4830__auto___46622 + (1));
i__4830__auto___46622 = G__46623;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e46620){var e = e46620;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq46619){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46619));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46626 = arguments.length;
var i__4830__auto___46627 = (0);
while(true){
if((i__4830__auto___46627 < len__4829__auto___46626)){
args__4835__auto__.push((arguments[i__4830__auto___46627]));

var G__46628 = (i__4830__auto___46627 + (1));
i__4830__auto___46627 = G__46628;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e46625){var e = e46625;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq46624){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46624));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e46629){var e = e46629;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46632 = arguments.length;
var i__4830__auto___46633 = (0);
while(true){
if((i__4830__auto___46633 < len__4829__auto___46632)){
args__4835__auto__.push((arguments[i__4830__auto___46633]));

var G__46634 = (i__4830__auto___46633 + (1));
i__4830__auto___46633 = G__46634;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e46631){var e = e46631;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq46630){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46630));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46637 = arguments.length;
var i__4830__auto___46638 = (0);
while(true){
if((i__4830__auto___46638 < len__4829__auto___46637)){
args__4835__auto__.push((arguments[i__4830__auto___46638]));

var G__46639 = (i__4830__auto___46638 + (1));
i__4830__auto___46638 = G__46639;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e46636){var e = e46636;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq46635){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46635));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e46640){var e = e46640;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e46641){var e = e46641;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46644 = arguments.length;
var i__4830__auto___46645 = (0);
while(true){
if((i__4830__auto___46645 < len__4829__auto___46644)){
args__4835__auto__.push((arguments[i__4830__auto___46645]));

var G__46646 = (i__4830__auto___46645 + (1));
i__4830__auto___46645 = G__46646;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e46643){var e = e46643;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq46642){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46642));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46649 = arguments.length;
var i__4830__auto___46650 = (0);
while(true){
if((i__4830__auto___46650 < len__4829__auto___46649)){
args__4835__auto__.push((arguments[i__4830__auto___46650]));

var G__46651 = (i__4830__auto___46650 + (1));
i__4830__auto___46650 = G__46651;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e46648){var e = e46648;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq46647){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46647));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46654 = arguments.length;
var i__4830__auto___46655 = (0);
while(true){
if((i__4830__auto___46655 < len__4829__auto___46654)){
args__4835__auto__.push((arguments[i__4830__auto___46655]));

var G__46656 = (i__4830__auto___46655 + (1));
i__4830__auto___46655 = G__46656;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e46653){var e = e46653;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq46652){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46652));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46659 = arguments.length;
var i__4830__auto___46660 = (0);
while(true){
if((i__4830__auto___46660 < len__4829__auto___46659)){
args__4835__auto__.push((arguments[i__4830__auto___46660]));

var G__46661 = (i__4830__auto___46660 + (1));
i__4830__auto___46660 = G__46661;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e46658){var e = e46658;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq46657){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46657));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46664 = arguments.length;
var i__4830__auto___46665 = (0);
while(true){
if((i__4830__auto___46665 < len__4829__auto___46664)){
args__4835__auto__.push((arguments[i__4830__auto___46665]));

var G__46666 = (i__4830__auto___46665 + (1));
i__4830__auto___46665 = G__46666;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e46663){var e = e46663;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq46662){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46662));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46669 = arguments.length;
var i__4830__auto___46670 = (0);
while(true){
if((i__4830__auto___46670 < len__4829__auto___46669)){
args__4835__auto__.push((arguments[i__4830__auto___46670]));

var G__46671 = (i__4830__auto___46670 + (1));
i__4830__auto___46670 = G__46671;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e46668){var e = e46668;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq46667){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46667));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46674 = arguments.length;
var i__4830__auto___46675 = (0);
while(true){
if((i__4830__auto___46675 < len__4829__auto___46674)){
args__4835__auto__.push((arguments[i__4830__auto___46675]));

var G__46676 = (i__4830__auto___46675 + (1));
i__4830__auto___46675 = G__46676;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e46673){var e = e46673;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq46672){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46672));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__46678 = arguments.length;
switch (G__46678) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_46706){
var state_val_46707 = (state_46706[(1)]);
if((state_val_46707 === (7))){
var inst_46691 = (state_46706[(7)]);
var inst_46694 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_46691,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_46706__$1 = state_46706;
var statearr_46708_46794 = state_46706__$1;
(statearr_46708_46794[(2)] = inst_46694);

(statearr_46708_46794[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46707 === (1))){
var state_46706__$1 = state_46706;
var statearr_46709_46795 = state_46706__$1;
(statearr_46709_46795[(2)] = null);

(statearr_46709_46795[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46707 === (4))){
var inst_46679 = (state_46706[(2)]);
var state_46706__$1 = state_46706;
var statearr_46710_46796 = state_46706__$1;
(statearr_46710_46796[(2)] = inst_46679);

(statearr_46710_46796[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46707 === (6))){
var inst_46691 = (state_46706[(7)]);
var inst_46691__$1 = (state_46706[(2)]);
var inst_46692 = fluree.db.util.core.exception_QMARK_(inst_46691__$1);
var state_46706__$1 = (function (){var statearr_46711 = state_46706;
(statearr_46711[(7)] = inst_46691__$1);

return statearr_46711;
})();
if(inst_46692){
var statearr_46712_46797 = state_46706__$1;
(statearr_46712_46797[(1)] = (7));

} else {
var statearr_46713_46798 = state_46706__$1;
(statearr_46713_46798[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46707 === (3))){
var inst_46704 = (state_46706[(2)]);
var state_46706__$1 = state_46706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46706__$1,inst_46704);
} else {
if((state_val_46707 === (2))){
var inst_46685 = (state_46706[(8)]);
var _ = (function (){var statearr_46715 = state_46706;
(statearr_46715[(4)] = cljs.core.cons((5),(state_46706[(4)])));

return statearr_46715;
})();
var inst_46685__$1 = cljs.core.volatile_BANG_((0));
var inst_46686 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_46687 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_46686,cljs.core.cst$kw$fuel,inst_46685__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_46688 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_46687);
var inst_46689 = fluree.db.query.fql.query(db,inst_46688);
var state_46706__$1 = (function (){var statearr_46716 = state_46706;
(statearr_46716[(8)] = inst_46685__$1);

return statearr_46716;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46706__$1,(6),inst_46689);
} else {
if((state_val_46707 === (9))){
var inst_46701 = (state_46706[(2)]);
var _ = (function (){var statearr_46717 = state_46706;
(statearr_46717[(4)] = cljs.core.rest((state_46706[(4)])));

return statearr_46717;
})();
var state_46706__$1 = state_46706;
var statearr_46718_46799 = state_46706__$1;
(statearr_46718_46799[(2)] = inst_46701);

(statearr_46718_46799[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46707 === (5))){
var _ = (function (){var statearr_46719 = state_46706;
(statearr_46719[(4)] = cljs.core.rest((state_46706[(4)])));

return statearr_46719;
})();
var state_46706__$1 = state_46706;
var ex46714 = (state_46706__$1[(2)]);
var statearr_46720_46800 = state_46706__$1;
(statearr_46720_46800[(5)] = ex46714);


if((ex46714 instanceof Error)){
var statearr_46721_46801 = state_46706__$1;
(statearr_46721_46801[(1)] = (4));

(statearr_46721_46801[(5)] = null);

} else {
throw ex46714;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46707 === (8))){
var inst_46685 = (state_46706[(8)]);
var inst_46691 = (state_46706[(7)]);
var inst_46696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46697 = cljs.core.deref(inst_46685);
var inst_46698 = [inst_46691,inst_46697];
var inst_46699 = (new cljs.core.PersistentVector(null,2,(5),inst_46696,inst_46698,null));
var state_46706__$1 = state_46706;
var statearr_46722_46802 = state_46706__$1;
(statearr_46722_46802[(2)] = inst_46699);

(statearr_46722_46802[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16153__auto____0 = (function (){
var statearr_46723 = [null,null,null,null,null,null,null,null,null];
(statearr_46723[(0)] = fluree$db$dbfunctions$internal$state_machine__16153__auto__);

(statearr_46723[(1)] = (1));

return statearr_46723;
});
var fluree$db$dbfunctions$internal$state_machine__16153__auto____1 = (function (state_46706){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_46706);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e46724){var ex__16156__auto__ = e46724;
var statearr_46725_46803 = state_46706;
(statearr_46725_46803[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_46706[(4)]))){
var statearr_46726_46804 = state_46706;
(statearr_46726_46804[(1)] = cljs.core.first((state_46706[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__46805 = state_46706;
state_46706 = G__46805;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16153__auto__ = function(state_46706){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16153__auto____1.call(this,state_46706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16153__auto____0;
fluree$db$dbfunctions$internal$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16153__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_46727 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_46727[(6)] = c__16227__auto__);

return statearr_46727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_46772){
var state_val_46773 = (state_46772[(1)]);
if((state_val_46773 === (7))){
var inst_46758 = (state_46772[(2)]);
var inst_46759 = fluree.db.query.fql.query(db,inst_46758);
var state_46772__$1 = state_46772;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46772__$1,(8),inst_46759);
} else {
if((state_val_46773 === (1))){
var inst_46728 = typeof select === 'string';
var state_46772__$1 = state_46772;
if(cljs.core.truth_(inst_46728)){
var statearr_46774_46806 = state_46772__$1;
(statearr_46774_46806[(1)] = (2));

} else {
var statearr_46775_46807 = state_46772__$1;
(statearr_46775_46807[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46773 === (4))){
var inst_46741 = (state_46772[(7)]);
var inst_46734 = (state_46772[(8)]);
var inst_46733 = (state_46772[(2)]);
var inst_46734__$1 = cljs.core.volatile_BANG_((0));
var inst_46735 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_46736 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_46737 = [inst_46734__$1,(100000)];
var inst_46738 = cljs.core.PersistentHashMap.fromArrays(inst_46736,inst_46737);
var inst_46739 = [inst_46733,from,where,block,limit,inst_46738];
var inst_46740 = cljs.core.PersistentHashMap.fromArrays(inst_46735,inst_46739);
var inst_46741__$1 = fluree.db.util.core.without_nils(inst_46740);
var inst_46742 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_46741__$1);
var inst_46743 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_46741__$1);
var inst_46744 = cljs.core.first(inst_46743);
var inst_46745 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_46744], 0));
var inst_46746 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_46745);
var inst_46747 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_46741__$1);
var inst_46748 = cljs.core.last(inst_46747);
var inst_46749 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_46748], 0));
var inst_46750 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_46749);
var inst_46751 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_46742,inst_46746,inst_46750], 0));
var state_46772__$1 = (function (){var statearr_46776 = state_46772;
(statearr_46776[(7)] = inst_46741__$1);

(statearr_46776[(8)] = inst_46734__$1);

return statearr_46776;
})();
if(cljs.core.truth_(inst_46751)){
var statearr_46777_46808 = state_46772__$1;
(statearr_46777_46808[(1)] = (5));

} else {
var statearr_46778_46809 = state_46772__$1;
(statearr_46778_46809[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46773 === (6))){
var inst_46741 = (state_46772[(7)]);
var state_46772__$1 = state_46772;
var statearr_46779_46810 = state_46772__$1;
(statearr_46779_46810[(2)] = inst_46741);

(statearr_46779_46810[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46773 === (3))){
var state_46772__$1 = state_46772;
var statearr_46780_46811 = state_46772__$1;
(statearr_46780_46811[(2)] = select);

(statearr_46780_46811[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46773 === (2))){
var inst_46730 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_46772__$1 = state_46772;
var statearr_46781_46812 = state_46772__$1;
(statearr_46781_46812[(2)] = inst_46730);

(statearr_46781_46812[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46773 === (11))){
var inst_46770 = (state_46772[(2)]);
var state_46772__$1 = state_46772;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46772__$1,inst_46770);
} else {
if((state_val_46773 === (9))){
var inst_46761 = (state_46772[(9)]);
var state_46772__$1 = state_46772;
var statearr_46782_46813 = state_46772__$1;
(statearr_46782_46813[(2)] = inst_46761);

(statearr_46782_46813[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46773 === (5))){
var inst_46741 = (state_46772[(7)]);
var inst_46753 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_46741);
var inst_46754 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_46753);
var inst_46755 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_46741,cljs.core.cst$kw$where,inst_46754);
var state_46772__$1 = state_46772;
var statearr_46783_46814 = state_46772__$1;
(statearr_46783_46814[(2)] = inst_46755);

(statearr_46783_46814[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46773 === (10))){
var inst_46761 = (state_46772[(9)]);
var inst_46734 = (state_46772[(8)]);
var inst_46765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46766 = cljs.core.deref(inst_46734);
var inst_46767 = [inst_46761,inst_46766];
var inst_46768 = (new cljs.core.PersistentVector(null,2,(5),inst_46765,inst_46767,null));
var state_46772__$1 = state_46772;
var statearr_46784_46815 = state_46772__$1;
(statearr_46784_46815[(2)] = inst_46768);

(statearr_46784_46815[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46773 === (8))){
var inst_46761 = (state_46772[(9)]);
var inst_46761__$1 = (state_46772[(2)]);
var inst_46762 = fluree.db.util.core.exception_QMARK_(inst_46761__$1);
var state_46772__$1 = (function (){var statearr_46785 = state_46772;
(statearr_46785[(9)] = inst_46761__$1);

return statearr_46785;
})();
if(inst_46762){
var statearr_46786_46816 = state_46772__$1;
(statearr_46786_46816[(1)] = (9));

} else {
var statearr_46787_46817 = state_46772__$1;
(statearr_46787_46817[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16153__auto____0 = (function (){
var statearr_46788 = [null,null,null,null,null,null,null,null,null,null];
(statearr_46788[(0)] = fluree$db$dbfunctions$internal$state_machine__16153__auto__);

(statearr_46788[(1)] = (1));

return statearr_46788;
});
var fluree$db$dbfunctions$internal$state_machine__16153__auto____1 = (function (state_46772){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_46772);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e46789){var ex__16156__auto__ = e46789;
var statearr_46790_46818 = state_46772;
(statearr_46790_46818[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_46772[(4)]))){
var statearr_46791_46819 = state_46772;
(statearr_46791_46819[(1)] = cljs.core.first((state_46772[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__46820 = state_46772;
state_46772 = G__46820;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16153__auto__ = function(state_46772){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16153__auto____1.call(this,state_46772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16153__auto____0;
fluree$db$dbfunctions$internal$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16153__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_46792 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_46792[(6)] = c__16227__auto__);

return statearr_46792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__46824 = path;
var vec__46825 = G__46824;
var seq__46826 = cljs.core.seq(vec__46825);
var first__46827 = cljs.core.first(seq__46826);
var seq__46826__$1 = cljs.core.next(seq__46826);
var var$ = first__46827;
var r = seq__46826__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__46824__$1 = G__46824;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__46831 = G__46824__$1;
var seq__46832 = cljs.core.seq(vec__46831);
var first__46833 = cljs.core.first(seq__46832);
var seq__46832__$1 = cljs.core.next(seq__46832);
var var$__$1 = first__46833;
var r__$1 = seq__46832__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__46834 = r__$1;
var G__46835 = n__$2;
var G__46836 = next_clauses;
G__46824__$1 = G__46834;
n__$1 = G__46835;
where_clauses__$1 = G__46836;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__46837 = r__$1;
var G__46838 = next_n;
var G__46839 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__46824__$1 = G__46837;
n__$1 = G__46838;
where_clauses__$1 = G__46839;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_46876){
var state_val_46877 = (state_46876[(1)]);
if((state_val_46877 === (7))){
var inst_46849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46850 = [path];
var inst_46851 = (new cljs.core.PersistentVector(null,1,(5),inst_46849,inst_46850,null));
var state_46876__$1 = state_46876;
var statearr_46878_46906 = state_46876__$1;
(statearr_46878_46906[(2)] = inst_46851);

(statearr_46878_46906[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46877 === (1))){
var state_46876__$1 = state_46876;
var statearr_46879_46907 = state_46876__$1;
(statearr_46879_46907[(2)] = null);

(statearr_46879_46907[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46877 === (4))){
var inst_46840 = (state_46876[(2)]);
var state_46876__$1 = state_46876;
var statearr_46880_46908 = state_46876__$1;
(statearr_46880_46908[(2)] = inst_46840);

(statearr_46880_46908[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46877 === (13))){
var inst_46867 = (state_46876[(2)]);
var inst_46868 = fluree.db.util.async.throw_err(inst_46867);
var _ = (function (){var statearr_46881 = state_46876;
(statearr_46881[(4)] = cljs.core.rest((state_46876[(4)])));

return statearr_46881;
})();
var state_46876__$1 = state_46876;
var statearr_46882_46909 = state_46876__$1;
(statearr_46882_46909[(2)] = inst_46868);

(statearr_46882_46909[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46877 === (6))){
var state_46876__$1 = state_46876;
var statearr_46884_46910 = state_46876__$1;
(statearr_46884_46910[(2)] = path);

(statearr_46884_46910[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46877 === (3))){
var inst_46874 = (state_46876[(2)]);
var state_46876__$1 = state_46876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46876__$1,inst_46874);
} else {
if((state_val_46877 === (12))){
var _ = (function (){var statearr_46885 = state_46876;
(statearr_46885[(4)] = cljs.core.rest((state_46876[(4)])));

return statearr_46885;
})();
var state_46876__$1 = state_46876;
var ex46883 = (state_46876__$1[(2)]);
var statearr_46886_46911 = state_46876__$1;
(statearr_46886_46911[(5)] = ex46883);


var statearr_46887_46912 = state_46876__$1;
(statearr_46887_46912[(1)] = (11));

(statearr_46887_46912[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_46877 === (2))){
var _ = (function (){var statearr_46888 = state_46876;
(statearr_46888[(4)] = cljs.core.cons((5),(state_46876[(4)])));

return statearr_46888;
})();
var inst_46846 = cljs.core.vector_QMARK_(path);
var state_46876__$1 = state_46876;
if(inst_46846){
var statearr_46889_46913 = state_46876__$1;
(statearr_46889_46913[(1)] = (6));

} else {
var statearr_46890_46914 = state_46876__$1;
(statearr_46890_46914[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46877 === (11))){
var inst_46853 = (state_46876[(7)]);
var inst_46858 = (state_46876[(2)]);
var inst_46859 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_46858,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_46853,endSubject], 0));
var state_46876__$1 = state_46876;
var statearr_46892_46915 = state_46876__$1;
(statearr_46892_46915[(2)] = inst_46859);

(statearr_46892_46915[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46877 === (9))){
var inst_46857 = (state_46876[(8)]);
var _ = (function (){var statearr_46893 = state_46876;
(statearr_46893[(4)] = cljs.core.cons((12),(state_46876[(4)])));

return statearr_46893;
})();
var inst_46865 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_46857);
var state_46876__$1 = state_46876;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46876__$1,(13),inst_46865);
} else {
if((state_val_46877 === (5))){
var _ = (function (){var statearr_46894 = state_46876;
(statearr_46894[(4)] = cljs.core.rest((state_46876[(4)])));

return statearr_46894;
})();
var state_46876__$1 = state_46876;
var ex46891 = (state_46876__$1[(2)]);
var statearr_46895_46916 = state_46876__$1;
(statearr_46895_46916[(5)] = ex46891);


if((ex46891 instanceof Error)){
var statearr_46896_46917 = state_46876__$1;
(statearr_46896_46917[(1)] = (4));

(statearr_46896_46917[(5)] = null);

} else {
throw ex46891;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46877 === (10))){
var inst_46871 = (state_46876[(2)]);
var _ = (function (){var statearr_46897 = state_46876;
(statearr_46897[(4)] = cljs.core.rest((state_46876[(4)])));

return statearr_46897;
})();
var state_46876__$1 = state_46876;
var statearr_46898_46918 = state_46876__$1;
(statearr_46898_46918[(2)] = inst_46871);

(statearr_46898_46918[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46877 === (8))){
var inst_46853 = (state_46876[(7)]);
var inst_46853__$1 = (state_46876[(2)]);
var inst_46854 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_46853__$1,endSubject);
var inst_46855 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_46856 = ["?var1",inst_46854];
var inst_46857 = cljs.core.PersistentHashMap.fromArrays(inst_46855,inst_46856);
var state_46876__$1 = (function (){var statearr_46899 = state_46876;
(statearr_46899[(7)] = inst_46853__$1);

(statearr_46899[(8)] = inst_46857);

return statearr_46899;
})();
var statearr_46900_46919 = state_46876__$1;
(statearr_46900_46919[(2)] = null);

(statearr_46900_46919[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16153__auto____0 = (function (){
var statearr_46901 = [null,null,null,null,null,null,null,null,null];
(statearr_46901[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16153__auto__);

(statearr_46901[(1)] = (1));

return statearr_46901;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16153__auto____1 = (function (state_46876){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_46876);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e46902){var ex__16156__auto__ = e46902;
var statearr_46903_46920 = state_46876;
(statearr_46903_46920[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_46876[(4)]))){
var statearr_46904_46921 = state_46876;
(statearr_46904_46921[(1)] = cljs.core.first((state_46876[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__46922 = state_46876;
state_46876 = G__46922;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16153__auto__ = function(state_46876){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16153__auto____1.call(this,state_46876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16153__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_46905 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_46905[(6)] = c__16227__auto__);

return statearr_46905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e46923){var e = e46923;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e46924){var e = e46924;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e46925){var e = e46925;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e46926){var e = e46926;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46929 = arguments.length;
var i__4830__auto___46930 = (0);
while(true){
if((i__4830__auto___46930 < len__4829__auto___46929)){
args__4835__auto__.push((arguments[i__4830__auto___46930]));

var G__46931 = (i__4830__auto___46930 + (1));
i__4830__auto___46930 = G__46931;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e46928){var e = e46928;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq46927){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46927));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46934 = arguments.length;
var i__4830__auto___46935 = (0);
while(true){
if((i__4830__auto___46935 < len__4829__auto___46934)){
args__4835__auto__.push((arguments[i__4830__auto___46935]));

var G__46936 = (i__4830__auto___46935 + (1));
i__4830__auto___46935 = G__46936;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e46933){var e = e46933;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq46932){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46932));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46939 = arguments.length;
var i__4830__auto___46940 = (0);
while(true){
if((i__4830__auto___46940 < len__4829__auto___46939)){
args__4835__auto__.push((arguments[i__4830__auto___46940]));

var G__46941 = (i__4830__auto___46940 + (1));
i__4830__auto___46940 = G__46941;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4223__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e46938){var e = e46938;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq46937){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46937));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46944 = arguments.length;
var i__4830__auto___46945 = (0);
while(true){
if((i__4830__auto___46945 < len__4829__auto___46944)){
args__4835__auto__.push((arguments[i__4830__auto___46945]));

var G__46946 = (i__4830__auto___46945 + (1));
i__4830__auto___46945 = G__46946;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e46943){var e = e46943;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq46942){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46942));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e46947){var e = e46947;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e46948){var e = e46948;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e46949){var e = e46949;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e46950){var e = e46950;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e46951){var e = e46951;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__46957 = path;
var vec__46958 = G__46957;
var seq__46959 = cljs.core.seq(vec__46958);
var first__46960 = cljs.core.first(seq__46959);
var seq__46959__$1 = cljs.core.next(seq__46959);
var pred = first__46960;
var r = seq__46959__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__46957__$1 = G__46957;
var subjects__$1 = subjects;
while(true){
var vec__46964 = G__46957__$1;
var seq__46965 = cljs.core.seq(vec__46964);
var first__46966 = cljs.core.first(seq__46965);
var seq__46965__$1 = cljs.core.next(seq__46965);
var pred__$1 = first__46966;
var r__$1 = seq__46965__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__46957__$1,subjects__$1,vec__46964,seq__46965,first__46966,seq__46965__$1,pred__$1,r__$1,subjects__$2,G__46957,vec__46958,seq__46959,first__46960,seq__46959__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__46957__$1,subjects__$1,vec__46964,seq__46965,first__46966,seq__46965__$1,pred__$1,r__$1,subjects__$2,G__46957,vec__46958,seq__46959,first__46960,seq__46959__$1,pred,r,subjects){
return (function (p1__46952_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__46952_SHARP_,pred__$1);
});})(G__46957__$1,subjects__$1,vec__46964,seq__46965,first__46966,seq__46965__$1,pred__$1,r__$1,subjects__$2,G__46957,vec__46958,seq__46959,first__46960,seq__46959__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__46957__$1,subjects__$1,vec__46964,seq__46965,first__46966,seq__46965__$1,pred__$1,r__$1,subjects__$2,G__46957,vec__46958,seq__46959,first__46960,seq__46959__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4221__auto__ = r__$1;
if(and__4221__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4221__auto__;
}
})())){
var G__46967 = r__$1;
var G__46968 = next_subjects;
G__46957__$1 = G__46967;
subjects__$1 = G__46968;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e46953){var e = e46953;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e46969){var e = e46969;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e46970){var e = e46970;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46973 = arguments.length;
var i__4830__auto___46974 = (0);
while(true){
if((i__4830__auto___46974 < len__4829__auto___46973)){
args__4835__auto__.push((arguments[i__4830__auto___46974]));

var G__46975 = (i__4830__auto___46974 + (1));
i__4830__auto___46974 = G__46975;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e46972){var e = e46972;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq46971){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46971));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e46976){var e = e46976;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___46979 = arguments.length;
var i__4830__auto___46980 = (0);
while(true){
if((i__4830__auto___46980 < len__4829__auto___46979)){
args__4835__auto__.push((arguments[i__4830__auto___46980]));

var G__46981 = (i__4830__auto___46980 + (1));
i__4830__auto___46980 = G__46981;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e46978){var e = e46978;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq46977){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46977));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e46982){var e = e46982;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_47037){
var state_val_47038 = (state_47037[(1)]);
if((state_val_47038 === (7))){
var inst_46984 = (state_47037[(2)]);
var state_47037__$1 = state_47037;
var statearr_47039_47072 = state_47037__$1;
(statearr_47039_47072[(2)] = inst_46984);

(statearr_47039_47072[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47038 === (1))){
var state_47037__$1 = state_47037;
var statearr_47040_47073 = state_47037__$1;
(statearr_47040_47073[(2)] = null);

(statearr_47040_47073[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47038 === (4))){
var inst_46983 = (state_47037[(2)]);
var state_47037__$1 = (function (){var statearr_47041 = state_47037;
(statearr_47041[(7)] = inst_46983);

return statearr_47041;
})();
var statearr_47042_47074 = state_47037__$1;
(statearr_47042_47074[(2)] = null);

(statearr_47042_47074[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47038 === (15))){
var inst_47021 = (state_47037[(8)]);
var inst_47025 = inst_47021.o;
var state_47037__$1 = state_47037;
var statearr_47043_47075 = state_47037__$1;
(statearr_47043_47075[(2)] = inst_47025);

(statearr_47043_47075[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47038 === (13))){
var inst_47021 = (state_47037[(8)]);
var inst_47017 = (state_47037[(2)]);
var inst_47018 = fluree.db.util.async.throw_err(inst_47017);
var inst_47019 = fluree.db.dbfunctions.internal.count(inst_47018);
var inst_47021__$1 = cljs.core.first(inst_47018);
var inst_47022 = (inst_47021__$1 == null);
var state_47037__$1 = (function (){var statearr_47044 = state_47037;
(statearr_47044[(8)] = inst_47021__$1);

(statearr_47044[(9)] = inst_47019);

return statearr_47044;
})();
if(cljs.core.truth_(inst_47022)){
var statearr_47045_47076 = state_47037__$1;
(statearr_47045_47076[(1)] = (14));

} else {
var statearr_47046_47077 = state_47037__$1;
(statearr_47046_47077[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47038 === (6))){
var inst_46993 = (state_47037[(2)]);
var state_47037__$1 = state_47037;
var statearr_47047_47078 = state_47037__$1;
(statearr_47047_47078[(2)] = inst_46993);

(statearr_47047_47078[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47038 === (3))){
var inst_47035 = (state_47037[(2)]);
var state_47037__$1 = state_47037;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47037__$1,inst_47035);
} else {
if((state_val_47038 === (12))){
var inst_47032 = (state_47037[(2)]);
var _ = (function (){var statearr_47048 = state_47037;
(statearr_47048[(4)] = cljs.core.rest((state_47037[(4)])));

return statearr_47048;
})();
var state_47037__$1 = state_47037;
var statearr_47049_47079 = state_47037__$1;
(statearr_47049_47079[(2)] = inst_47032);

(statearr_47049_47079[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47038 === (2))){
var _ = (function (){var statearr_47051 = state_47037;
(statearr_47051[(4)] = cljs.core.cons((9),(state_47037[(4)])));

return statearr_47051;
})();
var inst_46999 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47000 = typeof inst_46999 === 'string';
var state_47037__$1 = state_47037;
if(cljs.core.truth_(inst_47000)){
var statearr_47052_47080 = state_47037__$1;
(statearr_47052_47080[(1)] = (10));

} else {
var statearr_47053_47081 = state_47037__$1;
(statearr_47053_47081[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47038 === (11))){
var inst_47006 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47007 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_47006);
var inst_47008 = fluree.db.dbfunctions.internal.inc(inst_47007);
var inst_47009 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_47006,cljs.core.cst$kw$t,inst_47008);
var inst_47010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47011 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47012 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47013 = [inst_47011,inst_47012];
var inst_47014 = (new cljs.core.PersistentVector(null,2,(5),inst_47010,inst_47013,null));
var inst_47015 = fluree.db.dbproto._search(inst_47009,inst_47014);
var state_47037__$1 = state_47037;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47037__$1,(13),inst_47015);
} else {
if((state_val_47038 === (9))){
var _ = (function (){var statearr_47054 = state_47037;
(statearr_47054[(4)] = cljs.core.rest((state_47037[(4)])));

return statearr_47054;
})();
var state_47037__$1 = state_47037;
var ex47050 = (state_47037__$1[(2)]);
var statearr_47055_47082 = state_47037__$1;
(statearr_47055_47082[(5)] = ex47050);


var statearr_47056_47083 = state_47037__$1;
(statearr_47056_47083[(1)] = (4));

(statearr_47056_47083[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_47038 === (5))){
var inst_46983 = (state_47037[(7)]);
var _ = (function (){var statearr_47057 = state_47037;
(statearr_47057[(4)] = cljs.core.cons((8),(state_47037[(4)])));

return statearr_47057;
})();
var inst_46990 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_46983,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_47058 = state_47037;
(statearr_47058[(4)] = cljs.core.rest((state_47037[(4)])));

return statearr_47058;
})();
var state_47037__$1 = state_47037;
var statearr_47059_47084 = state_47037__$1;
(statearr_47059_47084[(2)] = inst_46990);

(statearr_47059_47084[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47038 === (14))){
var state_47037__$1 = state_47037;
var statearr_47060_47085 = state_47037__$1;
(statearr_47060_47085[(2)] = null);

(statearr_47060_47085[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47038 === (16))){
var inst_47019 = (state_47037[(9)]);
var inst_47027 = (state_47037[(2)]);
var inst_47028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47029 = [inst_47027,inst_47019];
var inst_47030 = (new cljs.core.PersistentVector(null,2,(5),inst_47028,inst_47029,null));
var state_47037__$1 = state_47037;
var statearr_47062_47086 = state_47037__$1;
(statearr_47062_47086[(2)] = inst_47030);

(statearr_47062_47086[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47038 === (10))){
var inst_47002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47003 = [null,(0)];
var inst_47004 = (new cljs.core.PersistentVector(null,2,(5),inst_47002,inst_47003,null));
var state_47037__$1 = state_47037;
var statearr_47063_47087 = state_47037__$1;
(statearr_47063_47087[(2)] = inst_47004);

(statearr_47063_47087[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47038 === (8))){
var _ = (function (){var statearr_47064 = state_47037;
(statearr_47064[(4)] = cljs.core.rest((state_47037[(4)])));

return statearr_47064;
})();
var state_47037__$1 = state_47037;
var ex47061 = (state_47037__$1[(2)]);
var statearr_47065_47088 = state_47037__$1;
(statearr_47065_47088[(5)] = ex47061);


var statearr_47066_47089 = state_47037__$1;
(statearr_47066_47089[(1)] = (7));

(statearr_47066_47089[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16153__auto____0 = (function (){
var statearr_47067 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47067[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16153__auto__);

(statearr_47067[(1)] = (1));

return statearr_47067;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16153__auto____1 = (function (state_47037){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_47037);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e47068){var ex__16156__auto__ = e47068;
var statearr_47069_47090 = state_47037;
(statearr_47069_47090[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_47037[(4)]))){
var statearr_47070_47091 = state_47037;
(statearr_47070_47091[(1)] = cljs.core.first((state_47037[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__47092 = state_47037;
state_47037 = G__47092;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16153__auto__ = function(state_47037){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16153__auto____1.call(this,state_47037);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_47071 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_47071[(6)] = c__16227__auto__);

return statearr_47071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_47144){
var state_val_47145 = (state_47144[(1)]);
if((state_val_47145 === (7))){
var inst_47094 = (state_47144[(2)]);
var state_47144__$1 = state_47144;
var statearr_47146_47175 = state_47144__$1;
(statearr_47146_47175[(2)] = inst_47094);

(statearr_47146_47175[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47145 === (1))){
var state_47144__$1 = state_47144;
var statearr_47147_47176 = state_47144__$1;
(statearr_47147_47176[(2)] = null);

(statearr_47147_47176[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47145 === (4))){
var inst_47093 = (state_47144[(2)]);
var state_47144__$1 = (function (){var statearr_47148 = state_47144;
(statearr_47148[(7)] = inst_47093);

return statearr_47148;
})();
var statearr_47149_47177 = state_47144__$1;
(statearr_47149_47177[(2)] = null);

(statearr_47149_47177[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47145 === (13))){
var inst_47139 = (state_47144[(2)]);
var _ = (function (){var statearr_47150 = state_47144;
(statearr_47150[(4)] = cljs.core.rest((state_47144[(4)])));

return statearr_47150;
})();
var state_47144__$1 = state_47144;
var statearr_47151_47178 = state_47144__$1;
(statearr_47151_47178[(2)] = inst_47139);

(statearr_47151_47178[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47145 === (6))){
var inst_47103 = (state_47144[(2)]);
var state_47144__$1 = state_47144;
var statearr_47152_47179 = state_47144__$1;
(statearr_47152_47179[(2)] = inst_47103);

(statearr_47152_47179[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47145 === (3))){
var inst_47142 = (state_47144[(2)]);
var state_47144__$1 = state_47144;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47144__$1,inst_47142);
} else {
if((state_val_47145 === (12))){
var inst_47126 = (state_47144[(8)]);
var inst_47135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47136 = [null,inst_47126];
var inst_47137 = (new cljs.core.PersistentVector(null,2,(5),inst_47135,inst_47136,null));
var state_47144__$1 = state_47144;
var statearr_47153_47180 = state_47144__$1;
(statearr_47153_47180[(2)] = inst_47137);

(statearr_47153_47180[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47145 === (2))){
var _ = (function (){var statearr_47155 = state_47144;
(statearr_47155[(4)] = cljs.core.cons((9),(state_47144[(4)])));

return statearr_47155;
})();
var inst_47112 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_47113 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47115 = [null,pred_name,"?o"];
var inst_47116 = (new cljs.core.PersistentVector(null,3,(5),inst_47114,inst_47115,null));
var inst_47117 = [inst_47116];
var inst_47118 = (new cljs.core.PersistentVector(null,1,(5),inst_47113,inst_47117,null));
var inst_47119 = ["?o",inst_47118,opts];
var inst_47120 = cljs.core.PersistentHashMap.fromArrays(inst_47112,inst_47119);
var inst_47121 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_47120);
var state_47144__$1 = state_47144;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47144__$1,(10),inst_47121);
} else {
if((state_val_47145 === (11))){
var inst_47126 = (state_47144[(8)]);
var inst_47125 = (state_47144[(9)]);
var inst_47130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47131 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_47125);
var inst_47132 = [inst_47131,inst_47126];
var inst_47133 = (new cljs.core.PersistentVector(null,2,(5),inst_47130,inst_47132,null));
var state_47144__$1 = state_47144;
var statearr_47156_47181 = state_47144__$1;
(statearr_47156_47181[(2)] = inst_47133);

(statearr_47156_47181[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47145 === (9))){
var _ = (function (){var statearr_47157 = state_47144;
(statearr_47157[(4)] = cljs.core.rest((state_47144[(4)])));

return statearr_47157;
})();
var state_47144__$1 = state_47144;
var ex47154 = (state_47144__$1[(2)]);
var statearr_47158_47182 = state_47144__$1;
(statearr_47158_47182[(5)] = ex47154);


var statearr_47159_47183 = state_47144__$1;
(statearr_47159_47183[(1)] = (4));

(statearr_47159_47183[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_47145 === (5))){
var inst_47093 = (state_47144[(7)]);
var _ = (function (){var statearr_47161 = state_47144;
(statearr_47161[(4)] = cljs.core.cons((8),(state_47144[(4)])));

return statearr_47161;
})();
var inst_47100 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_47093,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_47162 = state_47144;
(statearr_47162[(4)] = cljs.core.rest((state_47144[(4)])));

return statearr_47162;
})();
var state_47144__$1 = state_47144;
var statearr_47163_47184 = state_47144__$1;
(statearr_47163_47184[(2)] = inst_47100);

(statearr_47163_47184[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47145 === (10))){
var inst_47125 = (state_47144[(9)]);
var inst_47123 = (state_47144[(2)]);
var inst_47124 = fluree.db.util.async.throw_err(inst_47123);
var inst_47125__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47124,(0),null);
var inst_47126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47124,(1),null);
var inst_47127 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_47125__$1);
var inst_47128 = cljs.core.not(inst_47127);
var state_47144__$1 = (function (){var statearr_47164 = state_47144;
(statearr_47164[(8)] = inst_47126);

(statearr_47164[(9)] = inst_47125__$1);

return statearr_47164;
})();
if(inst_47128){
var statearr_47165_47185 = state_47144__$1;
(statearr_47165_47185[(1)] = (11));

} else {
var statearr_47166_47186 = state_47144__$1;
(statearr_47166_47186[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47145 === (8))){
var _ = (function (){var statearr_47167 = state_47144;
(statearr_47167[(4)] = cljs.core.rest((state_47144[(4)])));

return statearr_47167;
})();
var state_47144__$1 = state_47144;
var ex47160 = (state_47144__$1[(2)]);
var statearr_47168_47187 = state_47144__$1;
(statearr_47168_47187[(5)] = ex47160);


var statearr_47169_47188 = state_47144__$1;
(statearr_47169_47188[(1)] = (7));

(statearr_47169_47188[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16153__auto____0 = (function (){
var statearr_47170 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47170[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16153__auto__);

(statearr_47170[(1)] = (1));

return statearr_47170;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16153__auto____1 = (function (state_47144){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_47144);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e47171){var ex__16156__auto__ = e47171;
var statearr_47172_47189 = state_47144;
(statearr_47172_47189[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_47144[(4)]))){
var statearr_47173_47190 = state_47144;
(statearr_47173_47190[(1)] = cljs.core.first((state_47144[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__47191 = state_47144;
state_47144 = G__47191;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16153__auto__ = function(state_47144){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16153__auto____1.call(this,state_47144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_47174 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_47174[(6)] = c__16227__auto__);

return statearr_47174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4221__auto__ = typeof email === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4221__auto__;
}
})());
}catch (e47192){var e = e47192;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__47194 = arguments.length;
switch (G__47194) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_47264){
var state_val_47265 = (state_47264[(1)]);
if((state_val_47265 === (7))){
var inst_47196 = (state_47264[(2)]);
var state_47264__$1 = state_47264;
var statearr_47266_47310 = state_47264__$1;
(statearr_47266_47310[(2)] = inst_47196);

(statearr_47266_47310[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (20))){
var inst_47240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47241 = ["*"];
var inst_47242 = (new cljs.core.PersistentVector(null,1,(5),inst_47240,inst_47241,null));
var state_47264__$1 = state_47264;
var statearr_47267_47311 = state_47264__$1;
(statearr_47267_47311[(2)] = inst_47242);

(statearr_47267_47311[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (1))){
var state_47264__$1 = state_47264;
var statearr_47268_47312 = state_47264__$1;
(statearr_47268_47312[(2)] = null);

(statearr_47268_47312[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (4))){
var inst_47195 = (state_47264[(2)]);
var state_47264__$1 = (function (){var statearr_47269 = state_47264;
(statearr_47269[(7)] = inst_47195);

return statearr_47269;
})();
var statearr_47270_47313 = state_47264__$1;
(statearr_47270_47313[(2)] = null);

(statearr_47270_47313[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (15))){
var inst_47259 = (state_47264[(2)]);
var _ = (function (){var statearr_47271 = state_47264;
(statearr_47271[(4)] = cljs.core.rest((state_47264[(4)])));

return statearr_47271;
})();
var state_47264__$1 = state_47264;
var statearr_47272_47314 = state_47264__$1;
(statearr_47272_47314[(2)] = inst_47259);

(statearr_47272_47314[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (21))){
var inst_47230 = (state_47264[(8)]);
var inst_47223 = (state_47264[(9)]);
var inst_47244 = (state_47264[(2)]);
var inst_47245 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_47246 = cljs.core.PersistentHashMap.EMPTY;
var inst_47247 = [inst_47244,inst_47230,inst_47246];
var inst_47248 = cljs.core.PersistentHashMap.fromArrays(inst_47245,inst_47247);
var inst_47249 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_47223,inst_47248);
var state_47264__$1 = state_47264;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47264__$1,(22),inst_47249);
} else {
if((state_val_47265 === (13))){
var inst_47218 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_47264__$1 = state_47264;
var statearr_47273_47315 = state_47264__$1;
(statearr_47273_47315[(2)] = inst_47218);

(statearr_47273_47315[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (22))){
var inst_47251 = (state_47264[(2)]);
var inst_47252 = fluree.db.util.async.throw_err(inst_47251);
var inst_47253 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47252,(0),null);
var inst_47254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47252,(1),null);
var inst_47255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47256 = [inst_47253,inst_47254];
var inst_47257 = (new cljs.core.PersistentVector(null,2,(5),inst_47255,inst_47256,null));
var state_47264__$1 = state_47264;
var statearr_47274_47316 = state_47264__$1;
(statearr_47274_47316[(2)] = inst_47257);

(statearr_47274_47316[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (6))){
var inst_47205 = (state_47264[(2)]);
var state_47264__$1 = state_47264;
var statearr_47275_47317 = state_47264__$1;
(statearr_47275_47317[(2)] = inst_47205);

(statearr_47275_47317[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (17))){
var inst_47227 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47228 = fluree.db.dbfunctions.internal.get(inst_47227,cljs.core.cst$kw$_id);
var state_47264__$1 = state_47264;
var statearr_47276_47318 = state_47264__$1;
(statearr_47276_47318[(2)] = inst_47228);

(statearr_47276_47318[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (3))){
var inst_47262 = (state_47264[(2)]);
var state_47264__$1 = state_47264;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47264__$1,inst_47262);
} else {
if((state_val_47265 === (12))){
var inst_47216 = (state_47264[(2)]);
var state_47264__$1 = state_47264;
if(cljs.core.truth_(inst_47216)){
var statearr_47277_47319 = state_47264__$1;
(statearr_47277_47319[(1)] = (13));

} else {
var statearr_47278_47320 = state_47264__$1;
(statearr_47278_47320[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (2))){
var inst_47211 = (state_47264[(10)]);
var _ = (function (){var statearr_47279 = state_47264;
(statearr_47279[(4)] = cljs.core.cons((9),(state_47264[(4)])));

return statearr_47279;
})();
var inst_47211__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_47264__$1 = (function (){var statearr_47280 = state_47264;
(statearr_47280[(10)] = inst_47211__$1);

return statearr_47280;
})();
if(cljs.core.truth_(inst_47211__$1)){
var statearr_47281_47321 = state_47264__$1;
(statearr_47281_47321[(1)] = (10));

} else {
var statearr_47282_47322 = state_47264__$1;
(statearr_47282_47322[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (19))){
var inst_47232 = cljs.core.PersistentVector.EMPTY;
var inst_47233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47234 = ["*"];
var inst_47235 = (new cljs.core.PersistentVector(null,1,(5),inst_47233,inst_47234,null));
var inst_47236 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_47237 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_47235,inst_47236);
var inst_47238 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_47232,inst_47237);
var state_47264__$1 = state_47264;
var statearr_47284_47323 = state_47264__$1;
(statearr_47284_47323[(2)] = inst_47238);

(statearr_47284_47323[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (11))){
var inst_47211 = (state_47264[(10)]);
var state_47264__$1 = state_47264;
var statearr_47285_47324 = state_47264__$1;
(statearr_47285_47324[(2)] = inst_47211);

(statearr_47285_47324[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (9))){
var _ = (function (){var statearr_47286 = state_47264;
(statearr_47286[(4)] = cljs.core.rest((state_47264[(4)])));

return statearr_47286;
})();
var state_47264__$1 = state_47264;
var ex47283 = (state_47264__$1[(2)]);
var statearr_47287_47325 = state_47264__$1;
(statearr_47287_47325[(5)] = ex47283);


var statearr_47288_47326 = state_47264__$1;
(statearr_47288_47326[(1)] = (4));

(statearr_47288_47326[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (5))){
var inst_47195 = (state_47264[(7)]);
var _ = (function (){var statearr_47289 = state_47264;
(statearr_47289[(4)] = cljs.core.cons((8),(state_47264[(4)])));

return statearr_47289;
})();
var inst_47202 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_47195,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_47290 = state_47264;
(statearr_47290[(4)] = cljs.core.rest((state_47264[(4)])));

return statearr_47290;
})();
var state_47264__$1 = state_47264;
var statearr_47291_47327 = state_47264__$1;
(statearr_47291_47327[(2)] = inst_47202);

(statearr_47291_47327[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (14))){
var inst_47224 = (state_47264[(11)]);
var inst_47223 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47224__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_47264__$1 = (function (){var statearr_47292 = state_47264;
(statearr_47292[(11)] = inst_47224__$1);

(statearr_47292[(9)] = inst_47223);

return statearr_47292;
})();
if(cljs.core.truth_(inst_47224__$1)){
var statearr_47293_47328 = state_47264__$1;
(statearr_47293_47328[(1)] = (16));

} else {
var statearr_47294_47329 = state_47264__$1;
(statearr_47294_47329[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (16))){
var inst_47224 = (state_47264[(11)]);
var state_47264__$1 = state_47264;
var statearr_47295_47330 = state_47264__$1;
(statearr_47295_47330[(2)] = inst_47224);

(statearr_47295_47330[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (10))){
var inst_47213 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_47264__$1 = state_47264;
var statearr_47297_47331 = state_47264__$1;
(statearr_47297_47331[(2)] = inst_47213);

(statearr_47297_47331[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (18))){
var inst_47230 = (state_47264[(2)]);
var state_47264__$1 = (function (){var statearr_47298 = state_47264;
(statearr_47298[(8)] = inst_47230);

return statearr_47298;
})();
if(cljs.core.truth_(additional_params)){
var statearr_47299_47332 = state_47264__$1;
(statearr_47299_47332[(1)] = (19));

} else {
var statearr_47300_47333 = state_47264__$1;
(statearr_47300_47333[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47265 === (8))){
var _ = (function (){var statearr_47301 = state_47264;
(statearr_47301[(4)] = cljs.core.rest((state_47264[(4)])));

return statearr_47301;
})();
var state_47264__$1 = state_47264;
var ex47296 = (state_47264__$1[(2)]);
var statearr_47302_47334 = state_47264__$1;
(statearr_47302_47334[(5)] = ex47296);


var statearr_47303_47335 = state_47264__$1;
(statearr_47303_47335[(1)] = (7));

(statearr_47303_47335[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16153__auto____0 = (function (){
var statearr_47304 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47304[(0)] = fluree$db$dbfunctions$internal$state_machine__16153__auto__);

(statearr_47304[(1)] = (1));

return statearr_47304;
});
var fluree$db$dbfunctions$internal$state_machine__16153__auto____1 = (function (state_47264){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_47264);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e47305){var ex__16156__auto__ = e47305;
var statearr_47306_47336 = state_47264;
(statearr_47306_47336[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_47264[(4)]))){
var statearr_47307_47337 = state_47264;
(statearr_47307_47337[(1)] = cljs.core.first((state_47264[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__47338 = state_47264;
state_47264 = G__47338;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16153__auto__ = function(state_47264){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16153__auto____1.call(this,state_47264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16153__auto____0;
fluree$db$dbfunctions$internal$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16153__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_47308 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_47308[(6)] = c__16227__auto__);

return statearr_47308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__47340 = arguments.length;
switch (G__47340) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_47384){
var state_val_47385 = (state_47384[(1)]);
if((state_val_47385 === (7))){
var inst_47362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47363 = ["*"];
var inst_47364 = (new cljs.core.PersistentVector(null,1,(5),inst_47362,inst_47363,null));
var state_47384__$1 = state_47384;
var statearr_47386_47406 = state_47384__$1;
(statearr_47386_47406[(2)] = inst_47364);

(statearr_47386_47406[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47385 === (1))){
var state_47384__$1 = state_47384;
var statearr_47387_47407 = state_47384__$1;
(statearr_47387_47407[(2)] = null);

(statearr_47387_47407[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47385 === (4))){
var inst_47341 = (state_47384[(2)]);
var inst_47342 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_47341,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_47384__$1 = state_47384;
var statearr_47388_47408 = state_47384__$1;
(statearr_47388_47408[(2)] = inst_47342);

(statearr_47388_47408[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47385 === (6))){
var inst_47354 = cljs.core.PersistentVector.EMPTY;
var inst_47355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47356 = ["*"];
var inst_47357 = (new cljs.core.PersistentVector(null,1,(5),inst_47355,inst_47356,null));
var inst_47358 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_47359 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_47357,inst_47358);
var inst_47360 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_47354,inst_47359);
var state_47384__$1 = state_47384;
var statearr_47389_47409 = state_47384__$1;
(statearr_47389_47409[(2)] = inst_47360);

(statearr_47389_47409[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47385 === (3))){
var inst_47382 = (state_47384[(2)]);
var state_47384__$1 = state_47384;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47384__$1,inst_47382);
} else {
if((state_val_47385 === (2))){
var _ = (function (){var statearr_47391 = state_47384;
(statearr_47391[(4)] = cljs.core.cons((5),(state_47384[(4)])));

return statearr_47391;
})();
var inst_47351 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47352 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_47384__$1 = (function (){var statearr_47392 = state_47384;
(statearr_47392[(7)] = inst_47351);

(statearr_47392[(8)] = inst_47352);

return statearr_47392;
})();
if(cljs.core.truth_(additional_params)){
var statearr_47393_47410 = state_47384__$1;
(statearr_47393_47410[(1)] = (6));

} else {
var statearr_47394_47411 = state_47384__$1;
(statearr_47394_47411[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47385 === (9))){
var inst_47373 = (state_47384[(2)]);
var inst_47374 = fluree.db.util.async.throw_err(inst_47373);
var inst_47375 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47374,(0),null);
var inst_47376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47374,(1),null);
var inst_47377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47378 = [inst_47375,inst_47376];
var inst_47379 = (new cljs.core.PersistentVector(null,2,(5),inst_47377,inst_47378,null));
var _ = (function (){var statearr_47395 = state_47384;
(statearr_47395[(4)] = cljs.core.rest((state_47384[(4)])));

return statearr_47395;
})();
var state_47384__$1 = state_47384;
var statearr_47396_47412 = state_47384__$1;
(statearr_47396_47412[(2)] = inst_47379);

(statearr_47396_47412[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47385 === (5))){
var _ = (function (){var statearr_47397 = state_47384;
(statearr_47397[(4)] = cljs.core.rest((state_47384[(4)])));

return statearr_47397;
})();
var state_47384__$1 = state_47384;
var ex47390 = (state_47384__$1[(2)]);
var statearr_47398_47413 = state_47384__$1;
(statearr_47398_47413[(5)] = ex47390);


var statearr_47399_47414 = state_47384__$1;
(statearr_47399_47414[(1)] = (4));

(statearr_47399_47414[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_47385 === (8))){
var inst_47351 = (state_47384[(7)]);
var inst_47352 = (state_47384[(8)]);
var inst_47366 = (state_47384[(2)]);
var inst_47367 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_47368 = cljs.core.PersistentHashMap.EMPTY;
var inst_47369 = [inst_47366,inst_47352,inst_47368];
var inst_47370 = cljs.core.PersistentHashMap.fromArrays(inst_47367,inst_47369);
var inst_47371 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_47351,inst_47370);
var state_47384__$1 = state_47384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47384__$1,(9),inst_47371);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16153__auto____0 = (function (){
var statearr_47400 = [null,null,null,null,null,null,null,null,null];
(statearr_47400[(0)] = fluree$db$dbfunctions$internal$state_machine__16153__auto__);

(statearr_47400[(1)] = (1));

return statearr_47400;
});
var fluree$db$dbfunctions$internal$state_machine__16153__auto____1 = (function (state_47384){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_47384);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e47401){var ex__16156__auto__ = e47401;
var statearr_47402_47415 = state_47384;
(statearr_47402_47415[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_47384[(4)]))){
var statearr_47403_47416 = state_47384;
(statearr_47403_47416[(1)] = cljs.core.first((state_47384[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__47417 = state_47384;
state_47384 = G__47417;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16153__auto__ = function(state_47384){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16153__auto____1.call(this,state_47384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16153__auto____0;
fluree$db$dbfunctions$internal$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16153__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_47404 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_47404[(6)] = c__16227__auto__);

return statearr_47404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_47461){
var state_val_47462 = (state_47461[(1)]);
if((state_val_47462 === (1))){
var state_47461__$1 = state_47461;
var statearr_47463_47477 = state_47461__$1;
(statearr_47463_47477[(2)] = null);

(statearr_47463_47477[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47462 === (2))){
var _ = (function (){var statearr_47464 = state_47461;
(statearr_47464[(4)] = cljs.core.cons((5),(state_47461[(4)])));

return statearr_47464;
})();
var inst_47428 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_47429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47430 = ["_user/_auth"];
var inst_47431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47432 = ["*"];
var inst_47433 = (new cljs.core.PersistentVector(null,1,(5),inst_47431,inst_47432,null));
var inst_47434 = [inst_47433];
var inst_47435 = cljs.core.PersistentHashMap.fromArrays(inst_47430,inst_47434);
var inst_47436 = [inst_47435];
var inst_47437 = (new cljs.core.PersistentVector(null,1,(5),inst_47429,inst_47436,null));
var inst_47438 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47439 = cljs.core.PersistentHashMap.EMPTY;
var inst_47440 = [inst_47437,inst_47438,inst_47439];
var inst_47441 = cljs.core.PersistentHashMap.fromArrays(inst_47428,inst_47440);
var inst_47442 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47443 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_47442,inst_47441);
var state_47461__$1 = state_47461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47461__$1,(6),inst_47443);
} else {
if((state_val_47462 === (3))){
var inst_47459 = (state_47461[(2)]);
var state_47461__$1 = state_47461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47461__$1,inst_47459);
} else {
if((state_val_47462 === (4))){
var inst_47418 = (state_47461[(2)]);
var inst_47419 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_47418,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_47461__$1 = state_47461;
var statearr_47466_47478 = state_47461__$1;
(statearr_47466_47478[(2)] = inst_47419);

(statearr_47466_47478[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47462 === (5))){
var _ = (function (){var statearr_47467 = state_47461;
(statearr_47467[(4)] = cljs.core.rest((state_47461[(4)])));

return statearr_47467;
})();
var state_47461__$1 = state_47461;
var ex47465 = (state_47461__$1[(2)]);
var statearr_47468_47479 = state_47461__$1;
(statearr_47468_47479[(5)] = ex47465);


var statearr_47469_47480 = state_47461__$1;
(statearr_47469_47480[(1)] = (4));

(statearr_47469_47480[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_47462 === (6))){
var inst_47445 = (state_47461[(2)]);
var inst_47446 = fluree.db.util.async.throw_err(inst_47445);
var inst_47447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47446,(0),null);
var inst_47448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47446,(1),null);
var inst_47449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47450 = ["_user/_auth","_id"];
var inst_47451 = (new cljs.core.PersistentVector(null,2,(5),inst_47449,inst_47450,null));
var inst_47452 = fluree.db.dbfunctions.internal.get_in(inst_47447,inst_47451);
var inst_47453 = cljs.core.first(inst_47452);
var inst_47454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47455 = [inst_47453,inst_47448];
var inst_47456 = (new cljs.core.PersistentVector(null,2,(5),inst_47454,inst_47455,null));
var _ = (function (){var statearr_47470 = state_47461;
(statearr_47470[(4)] = cljs.core.rest((state_47461[(4)])));

return statearr_47470;
})();
var state_47461__$1 = state_47461;
var statearr_47471_47481 = state_47461__$1;
(statearr_47471_47481[(2)] = inst_47456);

(statearr_47471_47481[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16153__auto____0 = (function (){
var statearr_47472 = [null,null,null,null,null,null,null];
(statearr_47472[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16153__auto__);

(statearr_47472[(1)] = (1));

return statearr_47472;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16153__auto____1 = (function (state_47461){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_47461);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e47473){var ex__16156__auto__ = e47473;
var statearr_47474_47482 = state_47461;
(statearr_47474_47482[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_47461[(4)]))){
var statearr_47475_47483 = state_47461;
(statearr_47475_47483[(1)] = cljs.core.first((state_47461[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__47484 = state_47461;
state_47461 = G__47484;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16153__auto__ = function(state_47461){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16153__auto____1.call(this,state_47461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_47476 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_47476[(6)] = c__16227__auto__);

return statearr_47476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_47501){
var state_val_47502 = (state_47501[(1)]);
if((state_val_47502 === (1))){
var state_47501__$1 = state_47501;
var statearr_47503_47517 = state_47501__$1;
(statearr_47503_47517[(2)] = null);

(statearr_47503_47517[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47502 === (2))){
var _ = (function (){var statearr_47504 = state_47501;
(statearr_47504[(4)] = cljs.core.cons((5),(state_47501[(4)])));

return statearr_47504;
})();
var inst_47491 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47492 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47493 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_47492,inst_47491);
var state_47501__$1 = state_47501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47501__$1,(6),inst_47493);
} else {
if((state_val_47502 === (3))){
var inst_47499 = (state_47501[(2)]);
var state_47501__$1 = state_47501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47501__$1,inst_47499);
} else {
if((state_val_47502 === (4))){
var inst_47485 = (state_47501[(2)]);
var state_47501__$1 = state_47501;
var statearr_47506_47518 = state_47501__$1;
(statearr_47506_47518[(2)] = inst_47485);

(statearr_47506_47518[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47502 === (5))){
var _ = (function (){var statearr_47507 = state_47501;
(statearr_47507[(4)] = cljs.core.rest((state_47501[(4)])));

return statearr_47507;
})();
var state_47501__$1 = state_47501;
var ex47505 = (state_47501__$1[(2)]);
var statearr_47508_47519 = state_47501__$1;
(statearr_47508_47519[(5)] = ex47505);


if((ex47505 instanceof Error)){
var statearr_47509_47520 = state_47501__$1;
(statearr_47509_47520[(1)] = (4));

(statearr_47509_47520[(5)] = null);

} else {
throw ex47505;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47502 === (6))){
var inst_47495 = (state_47501[(2)]);
var inst_47496 = fluree.db.util.async.throw_err(inst_47495);
var _ = (function (){var statearr_47510 = state_47501;
(statearr_47510[(4)] = cljs.core.rest((state_47501[(4)])));

return statearr_47510;
})();
var state_47501__$1 = state_47501;
var statearr_47511_47521 = state_47501__$1;
(statearr_47511_47521[(2)] = inst_47496);

(statearr_47511_47521[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16153__auto____0 = (function (){
var statearr_47512 = [null,null,null,null,null,null,null];
(statearr_47512[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16153__auto__);

(statearr_47512[(1)] = (1));

return statearr_47512;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16153__auto____1 = (function (state_47501){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_47501);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e47513){var ex__16156__auto__ = e47513;
var statearr_47514_47522 = state_47501;
(statearr_47514_47522[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_47501[(4)]))){
var statearr_47515_47523 = state_47501;
(statearr_47515_47523[(1)] = cljs.core.first((state_47501[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__47524 = state_47501;
state_47501 = G__47524;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16153__auto__ = function(state_47501){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16153__auto____1.call(this,state_47501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_47516 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_47516[(6)] = c__16227__auto__);

return statearr_47516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__47525_SHARP_){
return p1__47525_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__47526_SHARP_){
return p1__47526_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e47527){var e = e47527;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__47528_SHARP_){
return p1__47528_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__47529_SHARP_){
return p1__47529_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e47530){var e = e47530;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__47532 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__47532);
})() | (0));
return num;
}catch (e47531){var e = e47531;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_47612){
var state_val_47613 = (state_47612[(1)]);
if((state_val_47613 === (7))){
var inst_47551 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_47552 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47553 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_47554 = cljs.core.PersistentHashMap.fromArrays(inst_47552,inst_47553);
var inst_47555 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47551,inst_47554);
var inst_47556 = (function(){throw inst_47555})();
var state_47612__$1 = state_47612;
var statearr_47614_47649 = state_47612__$1;
(statearr_47614_47649[(2)] = inst_47556);

(statearr_47614_47649[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (1))){
var state_47612__$1 = state_47612;
var statearr_47615_47650 = state_47612__$1;
(statearr_47615_47650[(2)] = null);

(statearr_47615_47650[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (4))){
var inst_47533 = (state_47612[(2)]);
var state_47612__$1 = state_47612;
var statearr_47616_47651 = state_47612__$1;
(statearr_47616_47651[(2)] = inst_47533);

(statearr_47616_47651[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (15))){
var inst_47596 = (state_47612[(7)]);
var inst_47592 = (state_47612[(2)]);
var inst_47593 = fluree.db.util.async.throw_err(inst_47592);
var inst_47594 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47593,(0),null);
var inst_47595 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47593,(1),null);
var inst_47596__$1 = cljs.core.first(inst_47594);
var inst_47597 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47596__$1,compare_val);
var state_47612__$1 = (function (){var statearr_47617 = state_47612;
(statearr_47617[(8)] = inst_47595);

(statearr_47617[(7)] = inst_47596__$1);

return statearr_47617;
})();
if(inst_47597){
var statearr_47618_47652 = state_47612__$1;
(statearr_47618_47652[(1)] = (16));

} else {
var statearr_47619_47653 = state_47612__$1;
(statearr_47619_47653[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (13))){
var state_47612__$1 = state_47612;
var statearr_47620_47654 = state_47612__$1;
(statearr_47620_47654[(2)] = null);

(statearr_47620_47654[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (6))){
var state_47612__$1 = state_47612;
var statearr_47621_47655 = state_47612__$1;
(statearr_47621_47655[(2)] = null);

(statearr_47621_47655[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (17))){
var inst_47596 = (state_47612[(7)]);
var inst_47600 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47596)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_47601 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47602 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_47603 = cljs.core.PersistentHashMap.fromArrays(inst_47601,inst_47602);
var inst_47604 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47600,inst_47603);
var inst_47605 = (function(){throw inst_47604})();
var state_47612__$1 = state_47612;
var statearr_47622_47656 = state_47612__$1;
(statearr_47622_47656[(2)] = inst_47605);

(statearr_47622_47656[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (3))){
var inst_47610 = (state_47612[(2)]);
var state_47612__$1 = state_47612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47612__$1,inst_47610);
} else {
if((state_val_47613 === (12))){
var inst_47548 = (state_47612[(9)]);
var inst_47571 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_47548], 0));
var inst_47572 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47573 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_47574 = cljs.core.PersistentHashMap.fromArrays(inst_47572,inst_47573);
var inst_47575 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47571,inst_47574);
var inst_47576 = (function(){throw inst_47575})();
var state_47612__$1 = state_47612;
var statearr_47623_47657 = state_47612__$1;
(statearr_47623_47657[(2)] = inst_47576);

(statearr_47623_47657[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (2))){
var inst_47547 = (state_47612[(10)]);
var inst_47545 = (state_47612[(11)]);
var inst_47546 = (state_47612[(12)]);
var _ = (function (){var statearr_47624 = state_47612;
(statearr_47624[(4)] = cljs.core.cons((5),(state_47612[(4)])));

return statearr_47624;
})();
var inst_47543 = _QMARK_ctx;
var inst_47544 = cljs.core.__destructure_map(inst_47543);
var inst_47545__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47544,cljs.core.cst$kw$sid);
var inst_47546__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47544,cljs.core.cst$kw$pid);
var inst_47547__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47544,cljs.core.cst$kw$db);
var inst_47548 = fluree.db.dbproto._p_prop(inst_47547__$1,cljs.core.cst$kw$name,inst_47546__$1);
var state_47612__$1 = (function (){var statearr_47625 = state_47612;
(statearr_47625[(10)] = inst_47547__$1);

(statearr_47625[(9)] = inst_47548);

(statearr_47625[(11)] = inst_47545__$1);

(statearr_47625[(12)] = inst_47546__$1);

return statearr_47625;
})();
if(cljs.core.truth_(inst_47545__$1)){
var statearr_47626_47658 = state_47612__$1;
(statearr_47626_47658[(1)] = (6));

} else {
var statearr_47627_47659 = state_47612__$1;
(statearr_47627_47659[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (11))){
var inst_47547 = (state_47612[(10)]);
var inst_47546 = (state_47612[(12)]);
var inst_47568 = (state_47612[(2)]);
var inst_47569 = fluree.db.dbproto._p_prop(inst_47547,cljs.core.cst$kw$multi,inst_47546);
var state_47612__$1 = (function (){var statearr_47629 = state_47612;
(statearr_47629[(13)] = inst_47568);

return statearr_47629;
})();
if(cljs.core.truth_(inst_47569)){
var statearr_47630_47660 = state_47612__$1;
(statearr_47630_47660[(1)] = (12));

} else {
var statearr_47631_47661 = state_47612__$1;
(statearr_47631_47661[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (9))){
var state_47612__$1 = state_47612;
var statearr_47632_47662 = state_47612__$1;
(statearr_47632_47662[(2)] = null);

(statearr_47632_47662[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (5))){
var _ = (function (){var statearr_47633 = state_47612;
(statearr_47633[(4)] = cljs.core.rest((state_47612[(4)])));

return statearr_47633;
})();
var state_47612__$1 = state_47612;
var ex47628 = (state_47612__$1[(2)]);
var statearr_47634_47663 = state_47612__$1;
(statearr_47634_47663[(5)] = ex47628);


if((ex47628 instanceof Error)){
var statearr_47635_47664 = state_47612__$1;
(statearr_47635_47664[(1)] = (4));

(statearr_47635_47664[(5)] = null);

} else {
throw ex47628;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (14))){
var inst_47547 = (state_47612[(10)]);
var inst_47548 = (state_47612[(9)]);
var inst_47545 = (state_47612[(11)]);
var inst_47579 = (state_47612[(2)]);
var inst_47580 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_47581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47583 = [inst_47545,inst_47548,"?current-val"];
var inst_47584 = (new cljs.core.PersistentVector(null,3,(5),inst_47582,inst_47583,null));
var inst_47585 = [inst_47584];
var inst_47586 = (new cljs.core.PersistentVector(null,1,(5),inst_47581,inst_47585,null));
var inst_47587 = cljs.core.PersistentHashMap.EMPTY;
var inst_47588 = ["?current-val",inst_47586,inst_47587];
var inst_47589 = cljs.core.PersistentHashMap.fromArrays(inst_47580,inst_47588);
var inst_47590 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_47547,inst_47589);
var state_47612__$1 = (function (){var statearr_47636 = state_47612;
(statearr_47636[(14)] = inst_47579);

return statearr_47636;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47612__$1,(15),inst_47590);
} else {
if((state_val_47613 === (16))){
var state_47612__$1 = state_47612;
var statearr_47637_47665 = state_47612__$1;
(statearr_47637_47665[(2)] = new_val);

(statearr_47637_47665[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (10))){
var inst_47561 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_47562 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47563 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_47564 = cljs.core.PersistentHashMap.fromArrays(inst_47562,inst_47563);
var inst_47565 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47561,inst_47564);
var inst_47566 = (function(){throw inst_47565})();
var state_47612__$1 = state_47612;
var statearr_47638_47666 = state_47612__$1;
(statearr_47638_47666[(2)] = inst_47566);

(statearr_47638_47666[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (18))){
var inst_47607 = (state_47612[(2)]);
var _ = (function (){var statearr_47639 = state_47612;
(statearr_47639[(4)] = cljs.core.rest((state_47612[(4)])));

return statearr_47639;
})();
var state_47612__$1 = state_47612;
var statearr_47640_47667 = state_47612__$1;
(statearr_47640_47667[(2)] = inst_47607);

(statearr_47640_47667[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47613 === (8))){
var inst_47548 = (state_47612[(9)]);
var inst_47558 = (state_47612[(2)]);
var state_47612__$1 = (function (){var statearr_47641 = state_47612;
(statearr_47641[(15)] = inst_47558);

return statearr_47641;
})();
if(cljs.core.truth_(inst_47548)){
var statearr_47642_47668 = state_47612__$1;
(statearr_47642_47668[(1)] = (9));

} else {
var statearr_47643_47669 = state_47612__$1;
(statearr_47643_47669[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__16153__auto____0 = (function (){
var statearr_47644 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47644[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__16153__auto__);

(statearr_47644[(1)] = (1));

return statearr_47644;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__16153__auto____1 = (function (state_47612){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_47612);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e47645){var ex__16156__auto__ = e47645;
var statearr_47646_47670 = state_47612;
(statearr_47646_47670[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_47612[(4)]))){
var statearr_47647_47671 = state_47612;
(statearr_47647_47671[(1)] = cljs.core.first((state_47612[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__47672 = state_47612;
state_47612 = G__47672;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__16153__auto__ = function(state_47612){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16153__auto____1.call(this,state_47612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_47648 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_47648[(6)] = c__16227__auto__);

return statearr_47648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
