// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35634_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35634_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__35638 = coll;
var vec__35639 = G__35638;
var seq__35640 = cljs.core.seq(vec__35639);
var first__35641 = cljs.core.first(seq__35640);
var seq__35640__$1 = cljs.core.next(seq__35640);
var clause = first__35641;
var r = seq__35640__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__35638__$1 = G__35638;
var res__$1 = res;
while(true){
var vec__35645 = G__35638__$1;
var seq__35646 = cljs.core.seq(vec__35645);
var first__35647 = cljs.core.first(seq__35646);
var seq__35646__$1 = cljs.core.next(seq__35646);
var clause__$1 = first__35647;
var r__$1 = seq__35646__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__35648 = r__$1;
var G__35649 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__35638__$1 = G__35648;
res__$1 = G__35649;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__35650){
var map__35651 = p__35650;
var map__35651__$1 = cljs.core.__destructure_map(map__35651);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35651__$1,cljs.core.cst$kw$optional);
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__35655 = coll;
var vec__35656 = G__35655;
var seq__35657 = cljs.core.seq(vec__35656);
var first__35658 = cljs.core.first(seq__35657);
var seq__35657__$1 = cljs.core.next(seq__35657);
var clause = first__35658;
var r = seq__35657__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__35655__$1 = G__35655;
var res__$1 = res;
while(true){
var vec__35662 = G__35655__$1;
var seq__35663 = cljs.core.seq(vec__35662);
var first__35664 = cljs.core.first(seq__35663);
var seq__35663__$1 = cljs.core.next(seq__35663);
var clause__$1 = first__35664;
var r__$1 = seq__35663__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__35665 = r__$1;
var G__35666 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__35655__$1 = G__35665;
res__$1 = G__35666;
continue;
} else {
var G__35667 = r__$1;
var G__35668 = res__$2;
G__35655__$1 = G__35667;
res__$1 = G__35668;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__35672 = coll;
var vec__35673 = G__35672;
var seq__35674 = cljs.core.seq(vec__35673);
var first__35675 = cljs.core.first(seq__35674);
var seq__35674__$1 = cljs.core.next(seq__35674);
var clause = first__35675;
var r = seq__35674__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__35672__$1 = G__35672;
var res__$1 = res;
while(true){
var vec__35679 = G__35672__$1;
var seq__35680 = cljs.core.seq(vec__35679);
var first__35681 = cljs.core.first(seq__35680);
var seq__35680__$1 = cljs.core.next(seq__35680);
var clause__$1 = first__35681;
var r__$1 = seq__35680__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__35682 = r__$1;
var G__35683 = res__$2;
G__35672__$1 = G__35682;
res__$1 = G__35683;
continue;
} else {
var G__35684 = r__$1;
var G__35685 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__35672__$1 = G__35684;
res__$1 = G__35685;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_((function (){var and__4221__auto__ = typeof string === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string);
} else {
return and__4221__auto__;
}
})())){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__35686 = clause;
var G__35686__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__35686):G__35686);
var G__35686__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,G__35686__$1)
;
var G__35686__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__35686__$2)
;
var G__35686__$4 = goog.string.format("%s .",G__35686__$3)
;
if(cljs.core.truth_(optional_QMARK_)){
return goog.string.format("OPTIONAL {%s}",G__35686__$4);
} else {
return G__35686__$4;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__35690 = opts;
var map__35690__$1 = cljs.core.__destructure_map(map__35690);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35690__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35690__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35690__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35690__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35690__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35687_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35687_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__35688_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__35688_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__35689_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__35689_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4223__auto__ = language;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_35704){
var state_val_35705 = (state_35704[(1)]);
if((state_val_35705 === (1))){
var inst_35691 = fluree.db.util.core.url_encode(query);
var inst_35692 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35691)].join('');
var inst_35693 = ["User-Agent","Accept"];
var inst_35694 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_35695 = cljs.core.PersistentHashMap.fromArrays(inst_35693,inst_35694);
var inst_35696 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_35697 = [inst_35695,(30000),cljs.core.cst$kw$wikidata];
var inst_35698 = cljs.core.PersistentHashMap.fromArrays(inst_35696,inst_35697);
var inst_35699 = fluree.db.util.xhttp.get(inst_35692,inst_35698);
var state_35704__$1 = state_35704;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35704__$1,(2),inst_35699);
} else {
if((state_val_35705 === (2))){
var inst_35701 = (state_35704[(2)]);
var inst_35702 = fluree.db.util.async.throw_err(inst_35701);
var state_35704__$1 = state_35704;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35704__$1,inst_35702);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16153__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16153__auto____0 = (function (){
var statearr_35706 = [null,null,null,null,null,null,null];
(statearr_35706[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16153__auto__);

(statearr_35706[(1)] = (1));

return statearr_35706;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16153__auto____1 = (function (state_35704){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_35704);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e35707){var ex__16156__auto__ = e35707;
var statearr_35708_35711 = state_35704;
(statearr_35708_35711[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_35704[(4)]))){
var statearr_35709_35712 = state_35704;
(statearr_35709_35712[(1)] = cljs.core.first((state_35704[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__35713 = state_35704;
state_35704 = G__35713;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16153__auto__ = function(state_35704){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16153__auto____1.call(this,state_35704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16153__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16153__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_35710 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_35710[(6)] = c__16227__auto__);

return statearr_35710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_35731){
var state_val_35732 = (state_35731[(1)]);
if((state_val_35732 === (1))){
var inst_35714 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_35731__$1 = state_35731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35731__$1,(2),inst_35714);
} else {
if((state_val_35732 === (2))){
var inst_35717 = (state_35731[(7)]);
var inst_35716 = (state_35731[(2)]);
var inst_35717__$1 = fluree.db.util.async.throw_err(inst_35716);
var inst_35718 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_35717__$1);
var inst_35719 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_35718);
var state_35731__$1 = (function (){var statearr_35733 = state_35731;
(statearr_35733[(7)] = inst_35717__$1);

return statearr_35733;
})();
if(inst_35719){
var statearr_35734_35743 = state_35731__$1;
(statearr_35734_35743[(1)] = (3));

} else {
var statearr_35735_35744 = state_35731__$1;
(statearr_35735_35744[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35732 === (3))){
var inst_35717 = (state_35731[(7)]);
var state_35731__$1 = state_35731;
var statearr_35736_35745 = state_35731__$1;
(statearr_35736_35745[(2)] = inst_35717);

(statearr_35736_35745[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35732 === (4))){
var inst_35717 = (state_35731[(7)]);
var inst_35722 = (function (){var body = inst_35717;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_35723 = cljs.core.second(inst_35717);
var inst_35724 = cljs.core.second(inst_35723);
var inst_35725 = cljs.core.first(inst_35724);
var inst_35726 = cljs.core.second(inst_35725);
var inst_35727 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_35722,inst_35726);
var state_35731__$1 = state_35731;
var statearr_35737_35746 = state_35731__$1;
(statearr_35737_35746[(2)] = inst_35727);

(statearr_35737_35746[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35732 === (5))){
var inst_35729 = (state_35731[(2)]);
var state_35731__$1 = state_35731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35731__$1,inst_35729);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16153__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16153__auto____0 = (function (){
var statearr_35738 = [null,null,null,null,null,null,null,null];
(statearr_35738[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16153__auto__);

(statearr_35738[(1)] = (1));

return statearr_35738;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16153__auto____1 = (function (state_35731){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_35731);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e35739){var ex__16156__auto__ = e35739;
var statearr_35740_35747 = state_35731;
(statearr_35740_35747[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_35731[(4)]))){
var statearr_35741_35748 = state_35731;
(statearr_35741_35748[(1)] = cljs.core.first((state_35731[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__35749 = state_35731;
state_35731 = G__35749;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16153__auto__ = function(state_35731){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16153__auto____1.call(this,state_35731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16153__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16153__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_35742 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_35742[(6)] = c__16227__auto__);

return statearr_35742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35750_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35750_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35751_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35751_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35752_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__35752_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__35752_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__35752_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_35798){
var state_val_35799 = (state_35798[(1)]);
if((state_val_35799 === (7))){
var inst_35763 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_35798__$1 = state_35798;
var statearr_35800_35828 = state_35798__$1;
(statearr_35800_35828[(2)] = inst_35763);

(statearr_35800_35828[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35799 === (1))){
var state_35798__$1 = state_35798;
var statearr_35801_35829 = state_35798__$1;
(statearr_35801_35829[(2)] = null);

(statearr_35801_35829[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35799 === (4))){
var inst_35753 = (state_35798[(2)]);
var state_35798__$1 = state_35798;
var statearr_35802_35830 = state_35798__$1;
(statearr_35802_35830[(2)] = inst_35753);

(statearr_35802_35830[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35799 === (15))){
var inst_35771 = (state_35798[(7)]);
var inst_35772 = (state_35798[(8)]);
var inst_35777 = (state_35798[(9)]);
var inst_35782 = (state_35798[(2)]);
var inst_35783 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_35777,(0),inst_35782);
var inst_35784 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35785 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_35771);
var inst_35786 = [inst_35772,inst_35785];
var inst_35787 = cljs.core.PersistentHashMap.fromArrays(inst_35784,inst_35786);
var inst_35788 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35783,inst_35787);
var inst_35789 = (function(){throw inst_35788})();
var state_35798__$1 = state_35798;
var statearr_35803_35831 = state_35798__$1;
(statearr_35803_35831[(2)] = inst_35789);

(statearr_35803_35831[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35799 === (13))){
var inst_35776 = (state_35798[(10)]);
var state_35798__$1 = state_35798;
var statearr_35804_35832 = state_35798__$1;
(statearr_35804_35832[(2)] = inst_35776);

(statearr_35804_35832[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35799 === (6))){
var state_35798__$1 = state_35798;
var statearr_35805_35833 = state_35798__$1;
(statearr_35805_35833[(2)] = null);

(statearr_35805_35833[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35799 === (3))){
var inst_35796 = (state_35798[(2)]);
var state_35798__$1 = state_35798;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35798__$1,inst_35796);
} else {
if((state_val_35799 === (12))){
var inst_35793 = (state_35798[(2)]);
var _ = (function (){var statearr_35806 = state_35798;
(statearr_35806[(4)] = cljs.core.rest((state_35798[(4)])));

return statearr_35806;
})();
var state_35798__$1 = state_35798;
var statearr_35807_35834 = state_35798__$1;
(statearr_35807_35834[(2)] = inst_35793);

(statearr_35807_35834[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35799 === (2))){
var _ = (function (){var statearr_35808 = state_35798;
(statearr_35808[(4)] = cljs.core.cons((5),(state_35798[(4)])));

return statearr_35808;
})();
var inst_35760 = cljs.core.empty_QMARK_(matching_vars);
var state_35798__$1 = state_35798;
if(inst_35760){
var statearr_35809_35835 = state_35798__$1;
(statearr_35809_35835[(1)] = (6));

} else {
var statearr_35810_35836 = state_35798__$1;
(statearr_35810_35836[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35799 === (11))){
var inst_35771 = (state_35798[(7)]);
var inst_35791 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_35771,all_vars);
var state_35798__$1 = state_35798;
var statearr_35812_35837 = state_35798__$1;
(statearr_35812_35837[(2)] = inst_35791);

(statearr_35812_35837[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35799 === (9))){
var inst_35771 = (state_35798[(7)]);
var inst_35772 = (state_35798[(8)]);
var inst_35769 = (state_35798[(2)]);
var inst_35770 = fluree.db.util.async.throw_err(inst_35769);
var inst_35771__$1 = cljs.core.__destructure_map(inst_35770);
var inst_35772__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35771__$1,cljs.core.cst$kw$status);
var inst_35773 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35771__$1,cljs.core.cst$kw$message);
var inst_35774 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_35772__$1);
var state_35798__$1 = (function (){var statearr_35813 = state_35798;
(statearr_35813[(7)] = inst_35771__$1);

(statearr_35813[(11)] = inst_35773);

(statearr_35813[(8)] = inst_35772__$1);

return statearr_35813;
})();
if(inst_35774){
var statearr_35814_35838 = state_35798__$1;
(statearr_35814_35838[(1)] = (10));

} else {
var statearr_35815_35839 = state_35798__$1;
(statearr_35815_35839[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35799 === (5))){
var _ = (function (){var statearr_35816 = state_35798;
(statearr_35816[(4)] = cljs.core.rest((state_35798[(4)])));

return statearr_35816;
})();
var state_35798__$1 = state_35798;
var ex35811 = (state_35798__$1[(2)]);
var statearr_35817_35840 = state_35798__$1;
(statearr_35817_35840[(5)] = ex35811);


if((ex35811 instanceof Error)){
var statearr_35818_35841 = state_35798__$1;
(statearr_35818_35841[(1)] = (4));

(statearr_35818_35841[(5)] = null);

} else {
throw ex35811;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35799 === (14))){
var state_35798__$1 = state_35798;
var statearr_35819_35842 = state_35798__$1;
(statearr_35819_35842[(2)] = (1000));

(statearr_35819_35842[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35799 === (10))){
var inst_35771 = (state_35798[(7)]);
var inst_35773 = (state_35798[(11)]);
var inst_35776 = (state_35798[(10)]);
var inst_35776__$1 = cljs.core.count(inst_35773);
var inst_35777 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_35771);
var inst_35778 = (inst_35776__$1 < (1000));
var state_35798__$1 = (function (){var statearr_35820 = state_35798;
(statearr_35820[(10)] = inst_35776__$1);

(statearr_35820[(9)] = inst_35777);

return statearr_35820;
})();
if(cljs.core.truth_(inst_35778)){
var statearr_35821_35843 = state_35798__$1;
(statearr_35821_35843[(1)] = (13));

} else {
var statearr_35822_35844 = state_35798__$1;
(statearr_35822_35844[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35799 === (8))){
var inst_35765 = (state_35798[(2)]);
var inst_35766 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_35765,optional_clauses);
var inst_35767 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_35766);
var state_35798__$1 = state_35798;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35798__$1,(9),inst_35767);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16153__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16153__auto____0 = (function (){
var statearr_35823 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35823[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16153__auto__);

(statearr_35823[(1)] = (1));

return statearr_35823;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16153__auto____1 = (function (state_35798){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_35798);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e35824){var ex__16156__auto__ = e35824;
var statearr_35825_35845 = state_35798;
(statearr_35825_35845[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_35798[(4)]))){
var statearr_35826_35846 = state_35798;
(statearr_35826_35846[(1)] = cljs.core.first((state_35798[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__35847 = state_35798;
state_35798 = G__35847;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16153__auto__ = function(state_35798){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16153__auto____1.call(this,state_35798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16153__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16153__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_35827 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_35827[(6)] = c__16227__auto__);

return statearr_35827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
