// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__37839 = arguments.length;
switch (G__37839) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__37841 = null;
var G__37841__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__37841__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__37841__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + fuel_per));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__37841 = function(result,flake){
switch(arguments.length){
case 0:
return G__37841__0.call(this);
case 1:
return G__37841__1.call(this,result);
case 2:
return G__37841__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37841.cljs$core$IFn$_invoke$arity$0 = G__37841__0;
G__37841.cljs$core$IFn$_invoke$arity$1 = G__37841__1;
G__37841.cljs$core$IFn$_invoke$arity$2 = G__37841__2;
return G__37841;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__37842 = null;
var G__37842__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__37842__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__37842__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__37842 = function(result,flakes){
switch(arguments.length){
case 0:
return G__37842__0.call(this);
case 1:
return G__37842__1.call(this,result);
case 2:
return G__37842__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37842.cljs$core$IFn$_invoke$arity$0 = G__37842__0;
G__37842.cljs$core$IFn$_invoke$arity$1 = G__37842__1;
G__37842.cljs$core$IFn$_invoke$arity$2 = G__37842__2;
return G__37842;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__37844 = res;
var G__37844__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__37843_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__37843_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__37844):G__37844);
var G__37844__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__37844__$1):G__37844__$1);
var G__37844__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__37844__$2):G__37844__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__37844__$3);
} else {
return G__37844__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__37846 = arguments.length;
switch (G__37846) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_38145){
var state_val_38146 = (state_38145[(1)]);
if((state_val_38146 === (65))){
var inst_37886 = (state_38145[(7)]);
var inst_38003 = (state_38145[(8)]);
var inst_37996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37997 = cljs.core.deref(cache);
var inst_37998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37999 = flake.o;
var inst_38000 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37886);
var inst_38001 = [inst_37999,inst_38000];
var inst_38002 = (new cljs.core.PersistentVector(null,2,(5),inst_37998,inst_38001,null));
var inst_38003__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37997,inst_38002);
var state_38145__$1 = (function (){var statearr_38147 = state_38145;
(statearr_38147[(9)] = inst_37996);

(statearr_38147[(8)] = inst_38003__$1);

return statearr_38147;
})();
if(cljs.core.truth_(inst_38003__$1)){
var statearr_38148_38317 = state_38145__$1;
(statearr_38148_38317[(1)] = (68));

} else {
var statearr_38149_38318 = state_38145__$1;
(statearr_38149_38318[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (70))){
var inst_37996 = (state_38145[(9)]);
var inst_38021 = (state_38145[(2)]);
var inst_38022 = [inst_38021,offset_map];
var inst_38023 = (new cljs.core.PersistentVector(null,2,(5),inst_37996,inst_38022,null));
var state_38145__$1 = state_38145;
var statearr_38150_38319 = state_38145__$1;
(statearr_38150_38319[(2)] = inst_38023);

(statearr_38150_38319[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (62))){
var inst_37965 = (state_38145[(10)]);
var inst_37900 = (state_38145[(11)]);
var inst_37898 = (state_38145[(12)]);
var inst_37886 = (state_38145[(7)]);
var inst_37902 = (state_38145[(13)]);
var inst_37897 = (state_38145[(14)]);
var inst_37871 = (state_38145[(15)]);
var inst_37857 = (state_38145[(16)]);
var inst_37901 = (state_38145[(17)]);
var inst_37899 = (state_38145[(18)]);
var inst_37903 = (state_38145[(19)]);
var inst_37904 = (state_38145[(20)]);
var inst_37981 = (state_38145[(21)]);
var inst_37983 = (function (){var p = inst_37904;
var map__37853 = inst_37898;
var pred_spec__$1 = inst_37871;
var orderBy = inst_37902;
var nested_select_spec = inst_37965;
var multi_QMARK_ = inst_37899;
var limit = inst_37901;
var offset = inst_37903;
var k = inst_37897;
var compact_QMARK_ = inst_37857;
var G__37967 = inst_37981;
var pred_spec_SINGLEQUOTE_ = inst_37886;
var ref_QMARK_ = inst_37900;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_37984 = (inst_37983.cljs$core$IFn$_invoke$arity$1 ? inst_37983.cljs$core$IFn$_invoke$arity$1(inst_37981) : inst_37983.call(null,inst_37981));
var state_38145__$1 = state_38145;
var statearr_38151_38320 = state_38145__$1;
(statearr_38151_38320[(2)] = inst_37984);

(statearr_38151_38320[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (74))){
var inst_38030 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
if(cljs.core.truth_(inst_38030)){
var statearr_38152_38321 = state_38145__$1;
(statearr_38152_38321[(1)] = (75));

} else {
var statearr_38153_38322 = state_38145__$1;
(statearr_38153_38322[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (7))){
var inst_37858 = (state_38145[(22)]);
var state_38145__$1 = state_38145;
var statearr_38154_38323 = state_38145__$1;
(statearr_38154_38323[(2)] = inst_37858);

(statearr_38154_38323[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (59))){
var inst_37975 = (state_38145[(23)]);
var inst_37977 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_37978 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37977,inst_37975);
var state_38145__$1 = state_38145;
var statearr_38155_38324 = state_38145__$1;
(statearr_38155_38324[(2)] = inst_37978);

(statearr_38155_38324[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (86))){
var inst_37900 = (state_38145[(11)]);
var inst_37898 = (state_38145[(12)]);
var inst_37886 = (state_38145[(7)]);
var inst_37902 = (state_38145[(13)]);
var inst_37897 = (state_38145[(14)]);
var inst_37871 = (state_38145[(15)]);
var inst_37857 = (state_38145[(16)]);
var inst_37901 = (state_38145[(17)]);
var inst_37899 = (state_38145[(18)]);
var inst_37903 = (state_38145[(19)]);
var inst_37904 = (state_38145[(20)]);
var inst_38043 = (state_38145[(24)]);
var inst_38061 = (state_38145[(25)]);
var inst_38063 = (function (){var p = inst_37904;
var map__37853 = inst_37898;
var pred_spec__$1 = inst_37871;
var orderBy = inst_37902;
var children = inst_38043;
var multi_QMARK_ = inst_37899;
var limit = inst_37901;
var offset = inst_37903;
var G__38055 = inst_38061;
var k = inst_37897;
var compact_QMARK_ = inst_37857;
var pred_spec_SINGLEQUOTE_ = inst_37886;
var ref_QMARK_ = inst_37900;
return (function (n){
var G__38156 = db;
var G__38157 = cache;
var G__38158 = fuel;
var G__38159 = max_fuel;
var G__38160 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$wildcard_QMARK_,true,cljs.core.cst$kw$compact_QMARK_,compact_QMARK_], null);
var G__38161 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__38156,G__38157,G__38158,G__38159,G__38160,G__38161) : fluree.db.query.fql.flakes__GT_res.call(null,G__38156,G__38157,G__38158,G__38159,G__38160,G__38161));
});
})();
var inst_38064 = (inst_38063.cljs$core$IFn$_invoke$arity$1 ? inst_38063.cljs$core$IFn$_invoke$arity$1(inst_38061) : inst_38063.call(null,inst_38061));
var state_38145__$1 = state_38145;
var statearr_38162_38325 = state_38145__$1;
(statearr_38162_38325[(2)] = inst_38064);

(statearr_38162_38325[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (20))){
var inst_37898 = (state_38145[(12)]);
var inst_37886 = (state_38145[(7)]);
var inst_37899 = (state_38145[(18)]);
var inst_37897 = (state_38145[(2)]);
var inst_37898__$1 = cljs.core.__destructure_map(inst_37886);
var inst_37899__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37898__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_37900 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37898__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_37901 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37898__$1,cljs.core.cst$kw$limit);
var inst_37902 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37898__$1,cljs.core.cst$kw$orderBy);
var inst_37903 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37898__$1,cljs.core.cst$kw$offset);
var inst_37904 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37898__$1,cljs.core.cst$kw$p);
var state_38145__$1 = (function (){var statearr_38163 = state_38145;
(statearr_38163[(11)] = inst_37900);

(statearr_38163[(12)] = inst_37898__$1);

(statearr_38163[(13)] = inst_37902);

(statearr_38163[(14)] = inst_37897);

(statearr_38163[(17)] = inst_37901);

(statearr_38163[(18)] = inst_37899__$1);

(statearr_38163[(19)] = inst_37903);

(statearr_38163[(20)] = inst_37904);

return statearr_38163;
})();
if(cljs.core.truth_(inst_37899__$1)){
var statearr_38164_38326 = state_38145__$1;
(statearr_38164_38326[(1)] = (24));

} else {
var statearr_38165_38327 = state_38145__$1;
(statearr_38165_38327[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (72))){
var inst_37886 = (state_38145[(7)]);
var inst_38027 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37886);
var state_38145__$1 = state_38145;
var statearr_38166_38328 = state_38145__$1;
(statearr_38166_38328[(2)] = inst_38027);

(statearr_38166_38328[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (58))){
var inst_37974 = (state_38145[(2)]);
var inst_37975 = fluree.db.util.async.throw_err(inst_37974);
var state_38145__$1 = (function (){var statearr_38167 = state_38145;
(statearr_38167[(23)] = inst_37975);

return statearr_38167;
})();
if(cljs.core.truth_(fuel)){
var statearr_38168_38329 = state_38145__$1;
(statearr_38168_38329[(1)] = (59));

} else {
var statearr_38169_38330 = state_38145__$1;
(statearr_38169_38330[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (60))){
var inst_37975 = (state_38145[(23)]);
var state_38145__$1 = state_38145;
var statearr_38170_38331 = state_38145__$1;
(statearr_38170_38331[(2)] = inst_37975);

(statearr_38170_38331[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (27))){
var inst_37907 = (state_38145[(26)]);
var inst_37903 = (state_38145[(19)]);
var inst_37907__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37903);
var state_38145__$1 = (function (){var statearr_38171 = state_38145;
(statearr_38171[(26)] = inst_37907__$1);

return statearr_38171;
})();
if(inst_37907__$1){
var statearr_38172_38332 = state_38145__$1;
(statearr_38172_38332[(1)] = (30));

} else {
var statearr_38173_38333 = state_38145__$1;
(statearr_38173_38333[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (1))){
var state_38145__$1 = state_38145;
var statearr_38174_38334 = state_38145__$1;
(statearr_38174_38334[(2)] = null);

(statearr_38174_38334[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (69))){
var inst_37886 = (state_38145[(7)]);
var inst_38006 = flake.o;
var inst_38007 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37886);
var inst_38008 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_38006,inst_38007);
var state_38145__$1 = state_38145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38145__$1,(71),inst_38008);
} else {
if((state_val_38146 === (101))){
var inst_37897 = (state_38145[(14)]);
var inst_38106 = (state_38145[(27)]);
var inst_38105 = (state_38145[(28)]);
var inst_38125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38126 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37897,inst_38105);
var inst_38127 = [inst_38126,inst_38106];
var inst_38128 = (new cljs.core.PersistentVector(null,2,(5),inst_38125,inst_38127,null));
var state_38145__$1 = state_38145;
var statearr_38175_38335 = state_38145__$1;
(statearr_38175_38335[(2)] = inst_38128);

(statearr_38175_38335[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (24))){
var inst_37903 = (state_38145[(19)]);
var state_38145__$1 = state_38145;
if(cljs.core.truth_(inst_37903)){
var statearr_38176_38336 = state_38145__$1;
(statearr_38176_38336[(1)] = (27));

} else {
var statearr_38177_38337 = state_38145__$1;
(statearr_38177_38337[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (102))){
var state_38145__$1 = state_38145;
var statearr_38178_38338 = state_38145__$1;
(statearr_38178_38338[(1)] = (104));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (55))){
var inst_37886 = (state_38145[(7)]);
var inst_37994 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37886);
var state_38145__$1 = state_38145;
if(cljs.core.truth_(inst_37994)){
var statearr_38180_38339 = state_38145__$1;
(statearr_38180_38339[(1)] = (65));

} else {
var statearr_38181_38340 = state_38145__$1;
(statearr_38181_38340[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (85))){
var inst_38061 = (state_38145[(2)]);
var state_38145__$1 = (function (){var statearr_38182 = state_38145;
(statearr_38182[(25)] = inst_38061);

return statearr_38182;
})();
var statearr_38183_38341 = state_38145__$1;
(statearr_38183_38341[(1)] = (86));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (39))){
var inst_37902 = (state_38145[(13)]);
var inst_37934 = (state_38145[(29)]);
var inst_37934__$1 = cljs.core.not(inst_37902);
var state_38145__$1 = (function (){var statearr_38185 = state_38145;
(statearr_38185[(29)] = inst_37934__$1);

return statearr_38185;
})();
if(inst_37934__$1){
var statearr_38186_38342 = state_38145__$1;
(statearr_38186_38342[(1)] = (42));

} else {
var statearr_38187_38343 = state_38145__$1;
(statearr_38187_38343[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (88))){
var inst_38067 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38145__$1,(82),inst_38067);
} else {
if((state_val_38146 === (46))){
var inst_37950 = (state_38145[(30)]);
var inst_37950__$1 = cljs.core.not(recur_QMARK_);
var state_38145__$1 = (function (){var statearr_38188 = state_38145;
(statearr_38188[(30)] = inst_37950__$1);

return statearr_38188;
})();
if(inst_37950__$1){
var statearr_38189_38344 = state_38145__$1;
(statearr_38189_38344[(1)] = (48));

} else {
var statearr_38190_38345 = state_38145__$1;
(statearr_38190_38345[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (4))){
var inst_37847 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38191_38346 = state_38145__$1;
(statearr_38191_38346[(2)] = inst_37847);

(statearr_38191_38346[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (77))){
var inst_38096 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38192_38347 = state_38145__$1;
(statearr_38192_38347[(2)] = inst_38096);

(statearr_38192_38347[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (106))){
var inst_38136 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38193_38348 = state_38145__$1;
(statearr_38193_38348[(2)] = inst_38136);

(statearr_38193_38348[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (95))){
var inst_37899 = (state_38145[(18)]);
var state_38145__$1 = state_38145;
var statearr_38194_38349 = state_38145__$1;
(statearr_38194_38349[(2)] = inst_37899);

(statearr_38194_38349[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (54))){
var inst_37886 = (state_38145[(7)]);
var inst_37962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37963 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_37964 = (new cljs.core.PersistentVector(null,3,(5),inst_37962,inst_37963,null));
var inst_37965 = cljs.core.select_keys(inst_37886,inst_37964);
var inst_37966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37969 = flake.o;
var inst_37970 = [inst_37969];
var inst_37971 = (new cljs.core.PersistentVector(null,1,(5),inst_37968,inst_37970,null));
var inst_37972 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37971);
var state_38145__$1 = (function (){var statearr_38195 = state_38145;
(statearr_38195[(10)] = inst_37965);

(statearr_38195[(31)] = inst_37966);

return statearr_38195;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38145__$1,(58),inst_37972);
} else {
if((state_val_38146 === (92))){
var inst_38086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38087 = flake.o;
var inst_38088 = [inst_38087,offset_map];
var inst_38089 = (new cljs.core.PersistentVector(null,2,(5),inst_38086,inst_38088,null));
var state_38145__$1 = state_38145;
var statearr_38196_38350 = state_38145__$1;
(statearr_38196_38350[(2)] = inst_38089);

(statearr_38196_38350[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (104))){
var inst_38106 = (state_38145[(27)]);
var inst_38131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38132 = [acc,inst_38106];
var inst_38133 = (new cljs.core.PersistentVector(null,2,(5),inst_38131,inst_38132,null));
var state_38145__$1 = state_38145;
var statearr_38197_38351 = state_38145__$1;
(statearr_38197_38351[(2)] = inst_38133);

(statearr_38197_38351[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (15))){
var inst_37857 = (state_38145[(16)]);
var inst_37879 = (state_38145[(32)]);
var inst_37883 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37879,cljs.core.cst$kw$compact_QMARK_,inst_37857);
var state_38145__$1 = state_38145;
var statearr_38198_38352 = state_38145__$1;
(statearr_38198_38352[(2)] = inst_37883);

(statearr_38198_38352[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (48))){
var inst_37886 = (state_38145[(7)]);
var inst_37952 = (state_38145[(33)]);
var inst_37952__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_37886);
var state_38145__$1 = (function (){var statearr_38199 = state_38145;
(statearr_38199[(33)] = inst_37952__$1);

return statearr_38199;
})();
if(cljs.core.truth_(inst_37952__$1)){
var statearr_38200_38353 = state_38145__$1;
(statearr_38200_38353[(1)] = (51));

} else {
var statearr_38201_38354 = state_38145__$1;
(statearr_38201_38354[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (50))){
var inst_37960 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
if(cljs.core.truth_(inst_37960)){
var statearr_38202_38355 = state_38145__$1;
(statearr_38202_38355[(1)] = (54));

} else {
var statearr_38203_38356 = state_38145__$1;
(statearr_38203_38356[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (75))){
var inst_37886 = (state_38145[(7)]);
var inst_38032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38033 = flake.o;
var inst_38034 = [inst_38033];
var inst_38035 = (new cljs.core.PersistentVector(null,1,(5),inst_38032,inst_38034,null));
var inst_38036 = [cljs.core.cst$kw$limit];
var inst_38037 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_37886);
var inst_38038 = [inst_38037];
var inst_38039 = cljs.core.PersistentHashMap.fromArrays(inst_38036,inst_38038);
var inst_38040 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38035,inst_38039);
var state_38145__$1 = state_38145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38145__$1,(78),inst_38040);
} else {
if((state_val_38146 === (99))){
var inst_38105 = (state_38145[(28)]);
var inst_38122 = (inst_38105 == null);
var inst_38123 = cljs.core.not(inst_38122);
var state_38145__$1 = state_38145;
if(inst_38123){
var statearr_38204_38357 = state_38145__$1;
(statearr_38204_38357[(1)] = (101));

} else {
var statearr_38205_38358 = state_38145__$1;
(statearr_38205_38358[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (21))){
var inst_37890 = (state_38145[(34)]);
var state_38145__$1 = state_38145;
var statearr_38206_38359 = state_38145__$1;
(statearr_38206_38359[(2)] = inst_37890);

(statearr_38206_38359[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (31))){
var inst_37907 = (state_38145[(26)]);
var state_38145__$1 = state_38145;
var statearr_38207_38360 = state_38145__$1;
(statearr_38207_38360[(2)] = inst_37907);

(statearr_38207_38360[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (32))){
var inst_37913 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38208_38361 = state_38145__$1;
(statearr_38208_38361[(2)] = inst_37913);

(statearr_38208_38361[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (40))){
var inst_37899 = (state_38145[(18)]);
var state_38145__$1 = state_38145;
var statearr_38209_38362 = state_38145__$1;
(statearr_38209_38362[(2)] = inst_37899);

(statearr_38209_38362[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (91))){
var inst_38094 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38210_38363 = state_38145__$1;
(statearr_38210_38363[(2)] = inst_38094);

(statearr_38210_38363[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (56))){
var inst_38100 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38211_38364 = state_38145__$1;
(statearr_38211_38364[(2)] = inst_38100);

(statearr_38211_38364[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (33))){
var inst_37904 = (state_38145[(20)]);
var inst_37921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37922 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37904);
var state_38145__$1 = (function (){var statearr_38212 = state_38145;
(statearr_38212[(35)] = inst_37921);

return statearr_38212;
})();
if(cljs.core.truth_(inst_37922)){
var statearr_38213_38365 = state_38145__$1;
(statearr_38213_38365[(1)] = (36));

} else {
var statearr_38214_38366 = state_38145__$1;
(statearr_38214_38366[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (13))){
var inst_37871 = (state_38145[(15)]);
var state_38145__$1 = state_38145;
var statearr_38215_38367 = state_38145__$1;
(statearr_38215_38367[(2)] = inst_37871);

(statearr_38215_38367[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (22))){
var inst_37886 = (state_38145[(7)]);
var inst_37893 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_37886);
var state_38145__$1 = state_38145;
var statearr_38216_38368 = state_38145__$1;
(statearr_38216_38368[(2)] = inst_37893);

(statearr_38216_38368[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (90))){
var state_38145__$1 = state_38145;
var statearr_38217_38369 = state_38145__$1;
(statearr_38217_38369[(1)] = (92));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (36))){
var inst_37904 = (state_38145[(20)]);
var inst_37924 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37904,cljs.core.dec);
var state_38145__$1 = state_38145;
var statearr_38219_38370 = state_38145__$1;
(statearr_38219_38370[(2)] = inst_37924);

(statearr_38219_38370[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (41))){
var inst_37944 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
if(cljs.core.truth_(inst_37944)){
var statearr_38220_38371 = state_38145__$1;
(statearr_38220_38371[(1)] = (45));

} else {
var statearr_38221_38372 = state_38145__$1;
(statearr_38221_38372[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (89))){
var inst_38077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38078 = [cljs.core.cst$kw$_id];
var inst_38079 = flake.o;
var inst_38080 = [inst_38079];
var inst_38081 = cljs.core.PersistentHashMap.fromArrays(inst_38078,inst_38080);
var inst_38082 = [inst_38081,offset_map];
var inst_38083 = (new cljs.core.PersistentVector(null,2,(5),inst_38077,inst_38082,null));
var state_38145__$1 = state_38145;
var statearr_38222_38373 = state_38145__$1;
(statearr_38222_38373[(2)] = inst_38083);

(statearr_38222_38373[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (100))){
var inst_38140 = (state_38145[(2)]);
var _ = (function (){var statearr_38223 = state_38145;
(statearr_38223[(4)] = cljs.core.rest((state_38145[(4)])));

return statearr_38223;
})();
var state_38145__$1 = state_38145;
var statearr_38224_38374 = state_38145__$1;
(statearr_38224_38374[(2)] = inst_38140);

(statearr_38224_38374[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (43))){
var inst_37934 = (state_38145[(29)]);
var state_38145__$1 = state_38145;
var statearr_38225_38375 = state_38145__$1;
(statearr_38225_38375[(2)] = inst_37934);

(statearr_38225_38375[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (61))){
var inst_37981 = (state_38145[(2)]);
var state_38145__$1 = (function (){var statearr_38226 = state_38145;
(statearr_38226[(21)] = inst_37981);

return statearr_38226;
})();
var statearr_38227_38376 = state_38145__$1;
(statearr_38227_38376[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (29))){
var inst_37916 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38229_38377 = state_38145__$1;
(statearr_38229_38377[(2)] = inst_37916);

(statearr_38229_38377[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (44))){
var inst_37941 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38230_38378 = state_38145__$1;
(statearr_38230_38378[(2)] = inst_37941);

(statearr_38230_38378[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (93))){
var state_38145__$1 = state_38145;
var statearr_38231_38379 = state_38145__$1;
(statearr_38231_38379[(2)] = null);

(statearr_38231_38379[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (6))){
var inst_37860 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37861 = (inst_37860 == null);
var state_38145__$1 = state_38145;
var statearr_38232_38380 = state_38145__$1;
(statearr_38232_38380[(2)] = inst_37861);

(statearr_38232_38380[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (28))){
var inst_37903 = (state_38145[(19)]);
var state_38145__$1 = state_38145;
var statearr_38233_38381 = state_38145__$1;
(statearr_38233_38381[(2)] = inst_37903);

(statearr_38233_38381[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (64))){
var inst_37987 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38145__$1,(57),inst_37987);
} else {
if((state_val_38146 === (103))){
var inst_38138 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38234_38382 = state_38145__$1;
(statearr_38234_38382[(2)] = inst_38138);

(statearr_38234_38382[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (51))){
var inst_37952 = (state_38145[(33)]);
var state_38145__$1 = state_38145;
var statearr_38235_38383 = state_38145__$1;
(statearr_38235_38383[(2)] = inst_37952);

(statearr_38235_38383[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (25))){
var inst_37899 = (state_38145[(18)]);
var state_38145__$1 = state_38145;
var statearr_38236_38384 = state_38145__$1;
(statearr_38236_38384[(2)] = inst_37899);

(statearr_38236_38384[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (34))){
var inst_37899 = (state_38145[(18)]);
var state_38145__$1 = state_38145;
if(cljs.core.truth_(inst_37899)){
var statearr_38237_38385 = state_38145__$1;
(statearr_38237_38385[(1)] = (39));

} else {
var statearr_38238_38386 = state_38145__$1;
(statearr_38238_38386[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (17))){
var inst_37887 = (state_38145[(36)]);
var inst_37886 = (state_38145[(7)]);
var inst_37886__$1 = (state_38145[(2)]);
var inst_37887__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_37886__$1);
var state_38145__$1 = (function (){var statearr_38239 = state_38145;
(statearr_38239[(36)] = inst_37887__$1);

(statearr_38239[(7)] = inst_37886__$1);

return statearr_38239;
})();
if(cljs.core.truth_(inst_37887__$1)){
var statearr_38240_38387 = state_38145__$1;
(statearr_38240_38387[(1)] = (18));

} else {
var statearr_38241_38388 = state_38145__$1;
(statearr_38241_38388[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (3))){
var inst_38143 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38145__$1,inst_38143);
} else {
if((state_val_38146 === (12))){
var inst_37871 = (state_38145[(15)]);
var inst_37876 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37871,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_38145__$1 = state_38145;
var statearr_38242_38389 = state_38145__$1;
(statearr_38242_38389[(2)] = inst_37876);

(statearr_38242_38389[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (2))){
var inst_37858 = (state_38145[(22)]);
var _ = (function (){var statearr_38243 = state_38145;
(statearr_38243[(4)] = cljs.core.cons((5),(state_38145[(4)])));

return statearr_38243;
})();
var inst_37857 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37858__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_38145__$1 = (function (){var statearr_38244 = state_38145;
(statearr_38244[(22)] = inst_37858__$1);

(statearr_38244[(16)] = inst_37857);

return statearr_38244;
})();
if(cljs.core.truth_(inst_37858__$1)){
var statearr_38245_38390 = state_38145__$1;
(statearr_38245_38390[(1)] = (6));

} else {
var statearr_38246_38391 = state_38145__$1;
(statearr_38246_38391[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (66))){
var inst_38025 = (state_38145[(37)]);
var inst_38025__$1 = componentFollow_QMARK_;
var state_38145__$1 = (function (){var statearr_38247 = state_38145;
(statearr_38247[(37)] = inst_38025__$1);

return statearr_38247;
})();
if(cljs.core.truth_(inst_38025__$1)){
var statearr_38248_38392 = state_38145__$1;
(statearr_38248_38392[(1)] = (72));

} else {
var statearr_38249_38393 = state_38145__$1;
(statearr_38249_38393[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (23))){
var inst_37895 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38250_38394 = state_38145__$1;
(statearr_38250_38394[(2)] = inst_37895);

(statearr_38250_38394[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (47))){
var inst_38102 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38251_38395 = state_38145__$1;
(statearr_38251_38395[(2)] = inst_38102);

(statearr_38251_38395[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (35))){
var inst_38108 = (state_38145[(38)]);
var inst_38105 = (state_38145[(28)]);
var inst_38104 = (state_38145[(2)]);
var inst_38105__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38104,(0),null);
var inst_38106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38104,(1),null);
var inst_38107 = (inst_38105__$1 == null);
var inst_38108__$1 = cljs.core.not(inst_38107);
var state_38145__$1 = (function (){var statearr_38252 = state_38145;
(statearr_38252[(38)] = inst_38108__$1);

(statearr_38252[(27)] = inst_38106);

(statearr_38252[(28)] = inst_38105__$1);

return statearr_38252;
})();
if(inst_38108__$1){
var statearr_38253_38396 = state_38145__$1;
(statearr_38253_38396[(1)] = (95));

} else {
var statearr_38254_38397 = state_38145__$1;
(statearr_38254_38397[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (82))){
var inst_38054 = (state_38145[(39)]);
var inst_38069 = (state_38145[(2)]);
var inst_38070 = fluree.db.util.async.throw_err(inst_38069);
var inst_38071 = [inst_38070,offset_map];
var inst_38072 = (new cljs.core.PersistentVector(null,2,(5),inst_38054,inst_38071,null));
var state_38145__$1 = state_38145;
var statearr_38255_38398 = state_38145__$1;
(statearr_38255_38398[(2)] = inst_38072);

(statearr_38255_38398[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (76))){
var inst_37900 = (state_38145[(11)]);
var state_38145__$1 = state_38145;
if(cljs.core.truth_(inst_37900)){
var statearr_38256_38399 = state_38145__$1;
(statearr_38256_38399[(1)] = (89));

} else {
var statearr_38257_38400 = state_38145__$1;
(statearr_38257_38400[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (97))){
var inst_38112 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
if(cljs.core.truth_(inst_38112)){
var statearr_38258_38401 = state_38145__$1;
(statearr_38258_38401[(1)] = (98));

} else {
var statearr_38259_38402 = state_38145__$1;
(statearr_38259_38402[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (19))){
var inst_37886 = (state_38145[(7)]);
var inst_37890 = (state_38145[(34)]);
var inst_37890__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37886);
var state_38145__$1 = (function (){var statearr_38260 = state_38145;
(statearr_38260[(34)] = inst_37890__$1);

return statearr_38260;
})();
if(cljs.core.truth_(inst_37890__$1)){
var statearr_38261_38403 = state_38145__$1;
(statearr_38261_38403[(1)] = (21));

} else {
var statearr_38262_38404 = state_38145__$1;
(statearr_38262_38404[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (57))){
var inst_37966 = (state_38145[(31)]);
var inst_37989 = (state_38145[(2)]);
var inst_37990 = fluree.db.util.async.throw_err(inst_37989);
var inst_37991 = [inst_37990,offset_map];
var inst_37992 = (new cljs.core.PersistentVector(null,2,(5),inst_37966,inst_37991,null));
var state_38145__$1 = state_38145;
var statearr_38263_38405 = state_38145__$1;
(statearr_38263_38405[(2)] = inst_37992);

(statearr_38263_38405[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (68))){
var inst_38003 = (state_38145[(8)]);
var state_38145__$1 = state_38145;
var statearr_38264_38406 = state_38145__$1;
(statearr_38264_38406[(2)] = inst_38003);

(statearr_38264_38406[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (11))){
var inst_37871 = (state_38145[(15)]);
var inst_37871__$1 = (state_38145[(2)]);
var inst_37873 = cljs.core.contains_QMARK_(inst_37871__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var inst_37874 = (!(inst_37873));
var state_38145__$1 = (function (){var statearr_38266 = state_38145;
(statearr_38266[(15)] = inst_37871__$1);

return statearr_38266;
})();
if(inst_37874){
var statearr_38267_38407 = state_38145__$1;
(statearr_38267_38407[(1)] = (12));

} else {
var statearr_38268_38408 = state_38145__$1;
(statearr_38268_38408[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (9))){
var inst_37866 = flake.p;
var inst_37867 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37868 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_37866,inst_37867);
var state_38145__$1 = state_38145;
var statearr_38269_38409 = state_38145__$1;
(statearr_38269_38409[(2)] = inst_37868);

(statearr_38269_38409[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (5))){
var _ = (function (){var statearr_38270 = state_38145;
(statearr_38270[(4)] = cljs.core.rest((state_38145[(4)])));

return statearr_38270;
})();
var state_38145__$1 = state_38145;
var ex38265 = (state_38145__$1[(2)]);
var statearr_38271_38410 = state_38145__$1;
(statearr_38271_38410[(5)] = ex38265);


if((ex38265 instanceof Error)){
var statearr_38272_38411 = state_38145__$1;
(statearr_38272_38411[(1)] = (4));

(statearr_38272_38411[(5)] = null);

} else {
throw ex38265;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (83))){
var inst_38043 = (state_38145[(24)]);
var inst_38057 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_38058 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_38057,inst_38043);
var state_38145__$1 = state_38145;
var statearr_38273_38412 = state_38145__$1;
(statearr_38273_38412[(2)] = inst_38058);

(statearr_38273_38412[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (14))){
var inst_37871 = (state_38145[(15)]);
var inst_37879 = (state_38145[(2)]);
var inst_37880 = cljs.core.contains_QMARK_(inst_37871,cljs.core.cst$kw$compact_QMARK_);
var inst_37881 = (!(inst_37880));
var state_38145__$1 = (function (){var statearr_38274 = state_38145;
(statearr_38274[(32)] = inst_37879);

return statearr_38274;
})();
if(inst_37881){
var statearr_38275_38413 = state_38145__$1;
(statearr_38275_38413[(1)] = (15));

} else {
var statearr_38276_38414 = state_38145__$1;
(statearr_38276_38414[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (45))){
var inst_37946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37947 = [null,offset_map];
var inst_37948 = (new cljs.core.PersistentVector(null,2,(5),inst_37946,inst_37947,null));
var state_38145__$1 = state_38145;
var statearr_38277_38415 = state_38145__$1;
(statearr_38277_38415[(2)] = inst_37948);

(statearr_38277_38415[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (53))){
var inst_37957 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38278_38416 = state_38145__$1;
(statearr_38278_38416[(2)] = inst_37957);

(statearr_38278_38416[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (78))){
var inst_38043 = (state_38145[(24)]);
var inst_38042 = (state_38145[(2)]);
var inst_38043__$1 = fluree.db.util.async.throw_err(inst_38042);
var inst_38044 = cljs.core.empty_QMARK_(inst_38043__$1);
var state_38145__$1 = (function (){var statearr_38279 = state_38145;
(statearr_38279[(24)] = inst_38043__$1);

return statearr_38279;
})();
if(inst_38044){
var statearr_38280_38417 = state_38145__$1;
(statearr_38280_38417[(1)] = (79));

} else {
var statearr_38281_38418 = state_38145__$1;
(statearr_38281_38418[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (26))){
var inst_37919 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
if(cljs.core.truth_(inst_37919)){
var statearr_38282_38419 = state_38145__$1;
(statearr_38282_38419[(1)] = (33));

} else {
var statearr_38283_38420 = state_38145__$1;
(statearr_38283_38420[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (16))){
var inst_37879 = (state_38145[(32)]);
var state_38145__$1 = state_38145;
var statearr_38284_38421 = state_38145__$1;
(statearr_38284_38421[(2)] = inst_37879);

(statearr_38284_38421[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (81))){
var inst_38074 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38285_38422 = state_38145__$1;
(statearr_38285_38422[(2)] = inst_38074);

(statearr_38285_38422[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (79))){
var inst_38046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38047 = [cljs.core.cst$kw$_id];
var inst_38048 = flake.o;
var inst_38049 = [inst_38048];
var inst_38050 = cljs.core.PersistentHashMap.fromArrays(inst_38047,inst_38049);
var inst_38051 = [inst_38050,offset_map];
var inst_38052 = (new cljs.core.PersistentVector(null,2,(5),inst_38046,inst_38051,null));
var state_38145__$1 = state_38145;
var statearr_38286_38423 = state_38145__$1;
(statearr_38286_38423[(2)] = inst_38052);

(statearr_38286_38423[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (38))){
var inst_37921 = (state_38145[(35)]);
var inst_37929 = (state_38145[(2)]);
var inst_37930 = [null,inst_37929];
var inst_37931 = (new cljs.core.PersistentVector(null,2,(5),inst_37921,inst_37930,null));
var state_38145__$1 = state_38145;
var statearr_38287_38424 = state_38145__$1;
(statearr_38287_38424[(2)] = inst_37931);

(statearr_38287_38424[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (98))){
var inst_37897 = (state_38145[(14)]);
var inst_38106 = (state_38145[(27)]);
var inst_38105 = (state_38145[(28)]);
var inst_38114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38115 = cljs.core.PersistentVector.EMPTY;
var inst_38116 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_37897,inst_38115);
var inst_38117 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38116,inst_38105);
var inst_38118 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37897,inst_38117);
var inst_38119 = [inst_38118,inst_38106];
var inst_38120 = (new cljs.core.PersistentVector(null,2,(5),inst_38114,inst_38119,null));
var state_38145__$1 = state_38145;
var statearr_38288_38425 = state_38145__$1;
(statearr_38288_38425[(2)] = inst_38120);

(statearr_38288_38425[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (87))){
var inst_38061 = (state_38145[(25)]);
var state_38145__$1 = state_38145;
var statearr_38289_38426 = state_38145__$1;
(statearr_38289_38426[(2)] = inst_38061);

(statearr_38289_38426[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (30))){
var inst_37904 = (state_38145[(20)]);
var inst_37909 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37904);
var inst_37910 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37909);
var state_38145__$1 = state_38145;
var statearr_38290_38427 = state_38145__$1;
(statearr_38290_38427[(2)] = inst_37910);

(statearr_38290_38427[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (73))){
var inst_38025 = (state_38145[(37)]);
var state_38145__$1 = state_38145;
var statearr_38291_38428 = state_38145__$1;
(statearr_38291_38428[(2)] = inst_38025);

(statearr_38291_38428[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (96))){
var inst_38108 = (state_38145[(38)]);
var state_38145__$1 = state_38145;
var statearr_38292_38429 = state_38145__$1;
(statearr_38292_38429[(2)] = inst_38108);

(statearr_38292_38429[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (10))){
var state_38145__$1 = state_38145;
var statearr_38293_38430 = state_38145__$1;
(statearr_38293_38430[(2)] = pred_spec);

(statearr_38293_38430[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (18))){
var inst_37887 = (state_38145[(36)]);
var state_38145__$1 = state_38145;
var statearr_38294_38431 = state_38145__$1;
(statearr_38294_38431[(2)] = inst_37887);

(statearr_38294_38431[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (105))){
var state_38145__$1 = state_38145;
var statearr_38295_38432 = state_38145__$1;
(statearr_38295_38432[(2)] = null);

(statearr_38295_38432[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (52))){
var inst_37886 = (state_38145[(7)]);
var inst_37955 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37886);
var state_38145__$1 = state_38145;
var statearr_38296_38433 = state_38145__$1;
(statearr_38296_38433[(2)] = inst_37955);

(statearr_38296_38433[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (67))){
var inst_38098 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38297_38434 = state_38145__$1;
(statearr_38297_38434[(2)] = inst_38098);

(statearr_38297_38434[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (71))){
var inst_37886 = (state_38145[(7)]);
var inst_38010 = (state_38145[(2)]);
var inst_38011 = fluree.db.util.async.throw_err(inst_38010);
var inst_38012 = cljs.core._deref(cache);
var inst_38013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38014 = flake.o;
var inst_38015 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37886);
var inst_38016 = [inst_38014,inst_38015];
var inst_38017 = (new cljs.core.PersistentVector(null,2,(5),inst_38013,inst_38016,null));
var inst_38018 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38012,inst_38017,inst_38011);
var inst_38019 = cljs.core._vreset_BANG_(cache,inst_38018);
var state_38145__$1 = (function (){var statearr_38298 = state_38145;
(statearr_38298[(40)] = inst_38019);

return statearr_38298;
})();
var statearr_38299_38435 = state_38145__$1;
(statearr_38299_38435[(2)] = inst_38011);

(statearr_38299_38435[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (42))){
var inst_37897 = (state_38145[(14)]);
var inst_37901 = (state_38145[(17)]);
var inst_37936 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_37897);
var inst_37937 = cljs.core.count(inst_37936);
var inst_37938 = (inst_37937 >= inst_37901);
var state_38145__$1 = state_38145;
var statearr_38300_38436 = state_38145__$1;
(statearr_38300_38436[(2)] = inst_37938);

(statearr_38300_38436[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (80))){
var inst_38054 = cljs.core.PersistentVector.EMPTY_NODE;
var state_38145__$1 = (function (){var statearr_38301 = state_38145;
(statearr_38301[(39)] = inst_38054);

return statearr_38301;
})();
if(cljs.core.truth_(fuel)){
var statearr_38302_38437 = state_38145__$1;
(statearr_38302_38437[(1)] = (83));

} else {
var statearr_38303_38438 = state_38145__$1;
(statearr_38303_38438[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (37))){
var inst_37903 = (state_38145[(19)]);
var inst_37904 = (state_38145[(20)]);
var inst_37926 = (inst_37903 - (1));
var inst_37927 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37904,inst_37926);
var state_38145__$1 = state_38145;
var statearr_38304_38439 = state_38145__$1;
(statearr_38304_38439[(2)] = inst_37927);

(statearr_38304_38439[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (63))){
var inst_37981 = (state_38145[(21)]);
var state_38145__$1 = state_38145;
var statearr_38305_38440 = state_38145__$1;
(statearr_38305_38440[(2)] = inst_37981);

(statearr_38305_38440[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (94))){
var inst_38092 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
var statearr_38306_38441 = state_38145__$1;
(statearr_38306_38441[(2)] = inst_38092);

(statearr_38306_38441[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (8))){
var inst_37864 = (state_38145[(2)]);
var state_38145__$1 = state_38145;
if(cljs.core.truth_(inst_37864)){
var statearr_38307_38442 = state_38145__$1;
(statearr_38307_38442[(1)] = (9));

} else {
var statearr_38308_38443 = state_38145__$1;
(statearr_38308_38443[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (49))){
var inst_37950 = (state_38145[(30)]);
var state_38145__$1 = state_38145;
var statearr_38309_38444 = state_38145__$1;
(statearr_38309_38444[(2)] = inst_37950);

(statearr_38309_38444[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38146 === (84))){
var inst_38043 = (state_38145[(24)]);
var state_38145__$1 = state_38145;
var statearr_38310_38445 = state_38145__$1;
(statearr_38310_38445[(2)] = inst_38043);

(statearr_38310_38445[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16153__auto__ = null;
var fluree$db$query$fql$state_machine__16153__auto____0 = (function (){
var statearr_38311 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38311[(0)] = fluree$db$query$fql$state_machine__16153__auto__);

(statearr_38311[(1)] = (1));

return statearr_38311;
});
var fluree$db$query$fql$state_machine__16153__auto____1 = (function (state_38145){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_38145);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e38312){var ex__16156__auto__ = e38312;
var statearr_38313_38446 = state_38145;
(statearr_38313_38446[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_38145[(4)]))){
var statearr_38314_38447 = state_38145;
(statearr_38314_38447[(1)] = cljs.core.first((state_38145[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__38448 = state_38145;
state_38145 = G__38448;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16153__auto__ = function(state_38145){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16153__auto____1.call(this,state_38145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16153__auto____0;
fluree$db$query$fql$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16153__auto____1;
return fluree$db$query$fql$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_38315 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_38315[(6)] = c__16227__auto__);

return statearr_38315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_38608){
var state_val_38609 = (state_38608[(1)]);
if((state_val_38609 === (7))){
var inst_38603 = (state_38608[(2)]);
var _ = (function (){var statearr_38610 = state_38608;
(statearr_38610[(4)] = cljs.core.rest((state_38608[(4)])));

return statearr_38610;
})();
var state_38608__$1 = state_38608;
var statearr_38611_38693 = state_38608__$1;
(statearr_38611_38693[(2)] = inst_38603);

(statearr_38611_38693[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (20))){
var inst_38530 = (state_38608[(7)]);
var state_38608__$1 = state_38608;
var statearr_38612_38694 = state_38608__$1;
(statearr_38612_38694[(2)] = inst_38530);

(statearr_38612_38694[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (27))){
var inst_38485 = (state_38608[(8)]);
var state_38608__$1 = state_38608;
if(cljs.core.truth_(inst_38485)){
var statearr_38613_38695 = state_38608__$1;
(statearr_38613_38695[(1)] = (29));

} else {
var statearr_38614_38696 = state_38608__$1;
(statearr_38614_38696[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (1))){
var state_38608__$1 = state_38608;
var statearr_38615_38697 = state_38608__$1;
(statearr_38615_38697[(2)] = null);

(statearr_38615_38697[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (24))){
var inst_38486 = (state_38608[(9)]);
var state_38608__$1 = state_38608;
var statearr_38616_38698 = state_38608__$1;
(statearr_38616_38698[(2)] = inst_38486);

(statearr_38616_38698[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (39))){
var inst_38522 = (state_38608[(10)]);
var state_38608__$1 = state_38608;
var statearr_38617_38699 = state_38608__$1;
(statearr_38617_38699[(2)] = inst_38522);

(statearr_38617_38699[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (46))){
var inst_38487 = (state_38608[(11)]);
var state_38608__$1 = state_38608;
var statearr_38618_38700 = state_38608__$1;
(statearr_38618_38700[(2)] = inst_38487);

(statearr_38618_38700[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (4))){
var inst_38449 = (state_38608[(2)]);
var state_38608__$1 = state_38608;
var statearr_38619_38701 = state_38608__$1;
(statearr_38619_38701[(2)] = inst_38449);

(statearr_38619_38701[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (15))){
var inst_38498 = (state_38608[(12)]);
var inst_38504 = cljs.core.count(inst_38498);
var inst_38505 = fluree.db.query.fql.add_fuel(fuel,inst_38504,max_fuel);
var state_38608__$1 = state_38608;
var statearr_38620_38702 = state_38608__$1;
(statearr_38620_38702[(2)] = inst_38505);

(statearr_38620_38702[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (48))){
var inst_38474 = (state_38608[(13)]);
var inst_38467 = (state_38608[(14)]);
var inst_38589 = (state_38608[(15)]);
var inst_38597 = (state_38608[(2)]);
var inst_38598 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38467,inst_38597,inst_38589);
var inst_38466 = inst_38474;
var inst_38467__$1 = inst_38598;
var state_38608__$1 = (function (){var statearr_38621 = state_38608;
(statearr_38621[(16)] = inst_38466);

(statearr_38621[(14)] = inst_38467__$1);

return statearr_38621;
})();
var statearr_38622_38703 = state_38608__$1;
(statearr_38622_38703[(2)] = null);

(statearr_38622_38703[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (50))){
var inst_38489 = (state_38608[(17)]);
var state_38608__$1 = state_38608;
var statearr_38623_38704 = state_38608__$1;
(statearr_38623_38704[(2)] = inst_38489);

(statearr_38623_38704[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (21))){
var inst_38486 = (state_38608[(9)]);
var state_38608__$1 = state_38608;
if(cljs.core.truth_(inst_38486)){
var statearr_38625_38705 = state_38608__$1;
(statearr_38625_38705[(1)] = (23));

} else {
var statearr_38626_38706 = state_38608__$1;
(statearr_38626_38706[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (31))){
var inst_38546 = (state_38608[(2)]);
var state_38608__$1 = state_38608;
if(cljs.core.truth_(inst_38546)){
var statearr_38627_38707 = state_38608__$1;
(statearr_38627_38707[(1)] = (32));

} else {
var statearr_38628_38708 = state_38608__$1;
(statearr_38628_38708[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (32))){
var inst_38522 = (state_38608[(10)]);
var inst_38521 = (state_38608[(18)]);
var inst_38529 = (state_38608[(19)]);
var inst_38548 = (inst_38521 + (1));
var tmp38624 = inst_38522;
var inst_38520 = inst_38529;
var inst_38521__$1 = inst_38548;
var inst_38522__$1 = tmp38624;
var state_38608__$1 = (function (){var statearr_38629 = state_38608;
(statearr_38629[(20)] = inst_38520);

(statearr_38629[(10)] = inst_38522__$1);

(statearr_38629[(18)] = inst_38521__$1);

return statearr_38629;
})();
var statearr_38630_38709 = state_38608__$1;
(statearr_38630_38709[(2)] = null);

(statearr_38630_38709[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (40))){
var state_38608__$1 = state_38608;
if(cljs.core.truth_(fuel)){
var statearr_38631_38710 = state_38608__$1;
(statearr_38631_38710[(1)] = (42));

} else {
var statearr_38632_38711 = state_38608__$1;
(statearr_38632_38711[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (33))){
var state_38608__$1 = state_38608;
var statearr_38633_38712 = state_38608__$1;
(statearr_38633_38712[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (13))){
var inst_38498 = (state_38608[(12)]);
var state_38608__$1 = state_38608;
var statearr_38635_38713 = state_38608__$1;
(statearr_38635_38713[(2)] = inst_38498);

(statearr_38635_38713[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (22))){
var inst_38539 = (state_38608[(2)]);
var state_38608__$1 = state_38608;
if(cljs.core.truth_(inst_38539)){
var statearr_38636_38714 = state_38608__$1;
(statearr_38636_38714[(1)] = (26));

} else {
var statearr_38637_38715 = state_38608__$1;
(statearr_38637_38715[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (36))){
var state_38608__$1 = state_38608;
var statearr_38638_38716 = state_38608__$1;
(statearr_38638_38716[(2)] = null);

(statearr_38638_38716[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (41))){
var inst_38521 = (state_38608[(18)]);
var inst_38529 = (state_38608[(19)]);
var inst_38578 = (state_38608[(2)]);
var inst_38579 = (inst_38521 + (1));
var inst_38520 = inst_38529;
var inst_38521__$1 = inst_38579;
var inst_38522 = inst_38578;
var state_38608__$1 = (function (){var statearr_38639 = state_38608;
(statearr_38639[(20)] = inst_38520);

(statearr_38639[(10)] = inst_38522);

(statearr_38639[(18)] = inst_38521__$1);

return statearr_38639;
})();
var statearr_38640_38717 = state_38608__$1;
(statearr_38640_38717[(2)] = null);

(statearr_38640_38717[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (43))){
var state_38608__$1 = state_38608;
var statearr_38641_38718 = state_38608__$1;
(statearr_38641_38718[(2)] = null);

(statearr_38641_38718[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (29))){
var inst_38521 = (state_38608[(18)]);
var inst_38485 = (state_38608[(8)]);
var inst_38543 = (inst_38521 < inst_38485);
var state_38608__$1 = state_38608;
var statearr_38642_38719 = state_38608__$1;
(statearr_38642_38719[(2)] = inst_38543);

(statearr_38642_38719[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (44))){
var inst_38562 = (state_38608[(21)]);
var inst_38558 = (state_38608[(22)]);
var inst_38571 = (state_38608[(2)]);
var inst_38572 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38562,inst_38558) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38562,inst_38558));
var state_38608__$1 = (function (){var statearr_38643 = state_38608;
(statearr_38643[(23)] = inst_38571);

return statearr_38643;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38608__$1,(45),inst_38572);
} else {
if((state_val_38609 === (6))){
var inst_38466 = (state_38608[(16)]);
var inst_38473 = (state_38608[(24)]);
var inst_38472 = cljs.core.seq(inst_38466);
var inst_38473__$1 = cljs.core.first(inst_38472);
var inst_38474 = cljs.core.next(inst_38472);
var inst_38475 = cljs.core.not(inst_38473__$1);
var state_38608__$1 = (function (){var statearr_38644 = state_38608;
(statearr_38644[(13)] = inst_38474);

(statearr_38644[(24)] = inst_38473__$1);

return statearr_38644;
})();
if(inst_38475){
var statearr_38645_38720 = state_38608__$1;
(statearr_38645_38720[(1)] = (8));

} else {
var statearr_38646_38721 = state_38608__$1;
(statearr_38646_38721[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (28))){
var inst_38587 = (state_38608[(2)]);
var state_38608__$1 = state_38608;
var statearr_38647_38722 = state_38608__$1;
(statearr_38647_38722[(2)] = inst_38587);

(statearr_38647_38722[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (51))){
var inst_38595 = (state_38608[(2)]);
var state_38608__$1 = state_38608;
var statearr_38648_38723 = state_38608__$1;
(statearr_38648_38723[(2)] = inst_38595);

(statearr_38648_38723[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (25))){
var inst_38537 = (state_38608[(2)]);
var state_38608__$1 = state_38608;
var statearr_38649_38724 = state_38608__$1;
(statearr_38649_38724[(2)] = inst_38537);

(statearr_38649_38724[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (34))){
var inst_38585 = (state_38608[(2)]);
var state_38608__$1 = state_38608;
var statearr_38650_38725 = state_38608__$1;
(statearr_38650_38725[(2)] = inst_38585);

(statearr_38650_38725[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (17))){
var inst_38498 = (state_38608[(12)]);
var inst_38508 = (state_38608[(2)]);
var inst_38516 = cljs.core.seq(inst_38498);
var inst_38517 = cljs.core.first(inst_38516);
var inst_38518 = cljs.core.next(inst_38516);
var inst_38519 = cljs.core.PersistentVector.EMPTY;
var inst_38520 = inst_38498;
var inst_38521 = (0);
var inst_38522 = inst_38519;
var state_38608__$1 = (function (){var statearr_38651 = state_38608;
(statearr_38651[(25)] = inst_38518);

(statearr_38651[(20)] = inst_38520);

(statearr_38651[(10)] = inst_38522);

(statearr_38651[(26)] = inst_38517);

(statearr_38651[(18)] = inst_38521);

(statearr_38651[(27)] = inst_38508);

return statearr_38651;
})();
var statearr_38652_38726 = state_38608__$1;
(statearr_38652_38726[(2)] = null);

(statearr_38652_38726[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (3))){
var inst_38606 = (state_38608[(2)]);
var state_38608__$1 = state_38608;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38608__$1,inst_38606);
} else {
if((state_val_38609 === (12))){
var state_38608__$1 = state_38608;
var statearr_38653_38727 = state_38608__$1;
(statearr_38653_38727[(2)] = fuel);

(statearr_38653_38727[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (2))){
var _ = (function (){var statearr_38654 = state_38608;
(statearr_38654[(4)] = cljs.core.cons((5),(state_38608[(4)])));

return statearr_38654;
})();
var inst_38462 = reverse_refs_specs;
var inst_38463 = cljs.core.seq(inst_38462);
var inst_38464 = cljs.core.first(inst_38463);
var inst_38465 = cljs.core.next(inst_38463);
var inst_38466 = inst_38462;
var inst_38467 = null;
var state_38608__$1 = (function (){var statearr_38655 = state_38608;
(statearr_38655[(28)] = inst_38465);

(statearr_38655[(16)] = inst_38466);

(statearr_38655[(14)] = inst_38467);

(statearr_38655[(29)] = inst_38464);

return statearr_38655;
})();
var statearr_38656_38728 = state_38608__$1;
(statearr_38656_38728[(2)] = null);

(statearr_38656_38728[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (23))){
var inst_38486 = (state_38608[(9)]);
var inst_38521 = (state_38608[(18)]);
var inst_38534 = (inst_38521 >= inst_38486);
var state_38608__$1 = state_38608;
var statearr_38657_38729 = state_38608__$1;
(statearr_38657_38729[(2)] = inst_38534);

(statearr_38657_38729[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (47))){
var inst_38488 = (state_38608[(30)]);
var state_38608__$1 = state_38608;
if(cljs.core.truth_(inst_38488)){
var statearr_38658_38730 = state_38608__$1;
(statearr_38658_38730[(1)] = (49));

} else {
var statearr_38659_38731 = state_38608__$1;
(statearr_38659_38731[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (35))){
var inst_38528 = (state_38608[(31)]);
var inst_38552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38553 = [inst_38528];
var inst_38554 = (new cljs.core.PersistentVector(null,1,(5),inst_38552,inst_38553,null));
var inst_38555 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38554);
var state_38608__$1 = state_38608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38608__$1,(38),inst_38555);
} else {
if((state_val_38609 === (19))){
var inst_38487 = (state_38608[(11)]);
var inst_38589 = (state_38608[(2)]);
var state_38608__$1 = (function (){var statearr_38660 = state_38608;
(statearr_38660[(15)] = inst_38589);

return statearr_38660;
})();
if(cljs.core.truth_(inst_38487)){
var statearr_38661_38732 = state_38608__$1;
(statearr_38661_38732[(1)] = (46));

} else {
var statearr_38662_38733 = state_38608__$1;
(statearr_38662_38733[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (11))){
var inst_38498 = (state_38608[(12)]);
var inst_38495 = (state_38608[(2)]);
var inst_38496 = fluree.db.util.async.throw_err(inst_38495);
var inst_38497 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_38496);
var inst_38498__$1 = cljs.core.not_empty(inst_38497);
var state_38608__$1 = (function (){var statearr_38664 = state_38608;
(statearr_38664[(12)] = inst_38498__$1);

return statearr_38664;
})();
if(cljs.core.truth_(inst_38498__$1)){
var statearr_38665_38734 = state_38608__$1;
(statearr_38665_38734[(1)] = (12));

} else {
var statearr_38666_38735 = state_38608__$1;
(statearr_38666_38735[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (9))){
var inst_38483 = (state_38608[(32)]);
var inst_38473 = (state_38608[(24)]);
var inst_38482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38473,(0),null);
var inst_38483__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38473,(1),null);
var inst_38484 = cljs.core.__destructure_map(inst_38483__$1);
var inst_38485 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38484,cljs.core.cst$kw$offset);
var inst_38486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38484,cljs.core.cst$kw$limit);
var inst_38487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38484,cljs.core.cst$kw$as);
var inst_38488 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38484,cljs.core.cst$kw$name);
var inst_38489 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38484,cljs.core.cst$kw$p);
var inst_38490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38491 = [subject_id,inst_38482];
var inst_38492 = (new cljs.core.PersistentVector(null,2,(5),inst_38490,inst_38491,null));
var inst_38493 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_38492);
var state_38608__$1 = (function (){var statearr_38667 = state_38608;
(statearr_38667[(32)] = inst_38483__$1);

(statearr_38667[(11)] = inst_38487);

(statearr_38667[(30)] = inst_38488);

(statearr_38667[(9)] = inst_38486);

(statearr_38667[(17)] = inst_38489);

(statearr_38667[(8)] = inst_38485);

return statearr_38667;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38608__$1,(11),inst_38493);
} else {
if((state_val_38609 === (5))){
var _ = (function (){var statearr_38668 = state_38608;
(statearr_38668[(4)] = cljs.core.rest((state_38608[(4)])));

return statearr_38668;
})();
var state_38608__$1 = state_38608;
var ex38663 = (state_38608__$1[(2)]);
var statearr_38669_38736 = state_38608__$1;
(statearr_38669_38736[(5)] = ex38663);


if((ex38663 instanceof Error)){
var statearr_38670_38737 = state_38608__$1;
(statearr_38670_38737[(1)] = (4));

(statearr_38670_38737[(5)] = null);

} else {
throw ex38663;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (14))){
var inst_38502 = (state_38608[(2)]);
var state_38608__$1 = state_38608;
if(cljs.core.truth_(inst_38502)){
var statearr_38671_38738 = state_38608__$1;
(statearr_38671_38738[(1)] = (15));

} else {
var statearr_38672_38739 = state_38608__$1;
(statearr_38672_38739[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (45))){
var inst_38522 = (state_38608[(10)]);
var inst_38574 = (state_38608[(2)]);
var inst_38575 = fluree.db.util.async.throw_err(inst_38574);
var inst_38576 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38522,inst_38575);
var state_38608__$1 = state_38608;
var statearr_38673_38740 = state_38608__$1;
(statearr_38673_38740[(2)] = inst_38576);

(statearr_38673_38740[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (26))){
var inst_38522 = (state_38608[(10)]);
var state_38608__$1 = state_38608;
var statearr_38674_38741 = state_38608__$1;
(statearr_38674_38741[(2)] = inst_38522);

(statearr_38674_38741[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (16))){
var state_38608__$1 = state_38608;
var statearr_38675_38742 = state_38608__$1;
(statearr_38675_38742[(2)] = null);

(statearr_38675_38742[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (38))){
var inst_38483 = (state_38608[(32)]);
var inst_38558 = (state_38608[(22)]);
var inst_38557 = (state_38608[(2)]);
var inst_38558__$1 = fluree.db.util.async.throw_err(inst_38557);
var inst_38559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38560 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_38561 = (new cljs.core.PersistentVector(null,4,(5),inst_38559,inst_38560,null));
var inst_38562 = cljs.core.select_keys(inst_38483,inst_38561);
var inst_38563 = cljs.core.empty_QMARK_(inst_38558__$1);
var state_38608__$1 = (function (){var statearr_38676 = state_38608;
(statearr_38676[(21)] = inst_38562);

(statearr_38676[(22)] = inst_38558__$1);

return statearr_38676;
})();
if(inst_38563){
var statearr_38677_38743 = state_38608__$1;
(statearr_38677_38743[(1)] = (39));

} else {
var statearr_38678_38744 = state_38608__$1;
(statearr_38678_38744[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (30))){
var inst_38485 = (state_38608[(8)]);
var state_38608__$1 = state_38608;
var statearr_38679_38745 = state_38608__$1;
(statearr_38679_38745[(2)] = inst_38485);

(statearr_38679_38745[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (10))){
var inst_38601 = (state_38608[(2)]);
var state_38608__$1 = state_38608;
var statearr_38680_38746 = state_38608__$1;
(statearr_38680_38746[(2)] = inst_38601);

(statearr_38680_38746[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (18))){
var inst_38520 = (state_38608[(20)]);
var inst_38530 = (state_38608[(7)]);
var inst_38528 = (state_38608[(31)]);
var inst_38527 = cljs.core.seq(inst_38520);
var inst_38528__$1 = cljs.core.first(inst_38527);
var inst_38529 = cljs.core.next(inst_38527);
var inst_38530__$1 = cljs.core.not(inst_38528__$1);
var state_38608__$1 = (function (){var statearr_38681 = state_38608;
(statearr_38681[(7)] = inst_38530__$1);

(statearr_38681[(31)] = inst_38528__$1);

(statearr_38681[(19)] = inst_38529);

return statearr_38681;
})();
if(inst_38530__$1){
var statearr_38682_38747 = state_38608__$1;
(statearr_38682_38747[(1)] = (20));

} else {
var statearr_38683_38748 = state_38608__$1;
(statearr_38683_38748[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (42))){
var inst_38558 = (state_38608[(22)]);
var inst_38567 = cljs.core.count(inst_38558);
var inst_38568 = fluree.db.query.fql.add_fuel(fuel,inst_38567,max_fuel);
var state_38608__$1 = state_38608;
var statearr_38684_38749 = state_38608__$1;
(statearr_38684_38749[(2)] = inst_38568);

(statearr_38684_38749[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (37))){
var inst_38583 = (state_38608[(2)]);
var state_38608__$1 = state_38608;
var statearr_38685_38750 = state_38608__$1;
(statearr_38685_38750[(2)] = inst_38583);

(statearr_38685_38750[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (8))){
var inst_38467 = (state_38608[(14)]);
var state_38608__$1 = state_38608;
var statearr_38686_38751 = state_38608__$1;
(statearr_38686_38751[(2)] = inst_38467);

(statearr_38686_38751[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38609 === (49))){
var inst_38488 = (state_38608[(30)]);
var state_38608__$1 = state_38608;
var statearr_38687_38752 = state_38608__$1;
(statearr_38687_38752[(2)] = inst_38488);

(statearr_38687_38752[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16153__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16153__auto____0 = (function (){
var statearr_38688 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38688[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16153__auto__);

(statearr_38688[(1)] = (1));

return statearr_38688;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16153__auto____1 = (function (state_38608){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_38608);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e38689){var ex__16156__auto__ = e38689;
var statearr_38690_38753 = state_38608;
(statearr_38690_38753[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_38608[(4)]))){
var statearr_38691_38754 = state_38608;
(statearr_38691_38754[(1)] = cljs.core.first((state_38608[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__38755 = state_38608;
state_38608 = G__38755;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16153__auto__ = function(state_38608){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16153__auto____1.call(this,state_38608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16153__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16153__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_38692 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_38692[(6)] = c__16227__auto__);

return statearr_38692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__38756 = select_spec;
var map__38756__$1 = cljs.core.__destructure_map(map__38756);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38756__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38756__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_38818){
var state_val_38819 = (state_38818[(1)]);
if((state_val_38819 === (7))){
var inst_38782 = (state_38818[(7)]);
var inst_38784 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_38785 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_38784,inst_38782);
var state_38818__$1 = state_38818;
var statearr_38820_38859 = state_38818__$1;
(statearr_38820_38859[(2)] = inst_38785);

(statearr_38820_38859[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (20))){
var inst_38788 = (state_38818[(8)]);
var inst_38806 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_38807 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38806,inst_38788) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38806,inst_38788));
var state_38818__$1 = state_38818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38818__$1,(22),inst_38807);
} else {
if((state_val_38819 === (1))){
var state_38818__$1 = state_38818;
var statearr_38821_38860 = state_38818__$1;
(statearr_38821_38860[(2)] = null);

(statearr_38821_38860[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (4))){
var inst_38757 = (state_38818[(2)]);
var state_38818__$1 = state_38818;
var statearr_38822_38861 = state_38818__$1;
(statearr_38822_38861[(2)] = inst_38757);

(statearr_38822_38861[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (15))){
var inst_38795 = (state_38818[(2)]);
var state_38818__$1 = state_38818;
var statearr_38823_38862 = state_38818__$1;
(statearr_38823_38862[(2)] = inst_38795);

(statearr_38823_38862[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (21))){
var inst_38813 = (state_38818[(2)]);
var _ = (function (){var statearr_38824 = state_38818;
(statearr_38824[(4)] = cljs.core.rest((state_38818[(4)])));

return statearr_38824;
})();
var state_38818__$1 = state_38818;
var statearr_38825_38863 = state_38818__$1;
(statearr_38825_38863[(2)] = inst_38813);

(statearr_38825_38863[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (13))){
var inst_38774 = (state_38818[(9)]);
var state_38818__$1 = state_38818;
var statearr_38826_38864 = state_38818__$1;
(statearr_38826_38864[(2)] = inst_38774);

(statearr_38826_38864[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (22))){
var inst_38803 = (state_38818[(10)]);
var inst_38768 = (state_38818[(11)]);
var inst_38809 = (state_38818[(2)]);
var inst_38810 = fluree.db.util.async.throw_err(inst_38809);
var inst_38811 = (inst_38803.cljs$core$IFn$_invoke$arity$3 ? inst_38803.cljs$core$IFn$_invoke$arity$3(acc,inst_38768,inst_38810) : inst_38803.call(null,acc,inst_38768,inst_38810));
var state_38818__$1 = state_38818;
var statearr_38827_38865 = state_38818__$1;
(statearr_38827_38865[(2)] = inst_38811);

(statearr_38827_38865[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (6))){
var inst_38781 = (state_38818[(2)]);
var inst_38782 = fluree.db.util.async.throw_err(inst_38781);
var state_38818__$1 = (function (){var statearr_38828 = state_38818;
(statearr_38828[(7)] = inst_38782);

return statearr_38828;
})();
if(cljs.core.truth_(fuel)){
var statearr_38829_38866 = state_38818__$1;
(statearr_38829_38866[(1)] = (7));

} else {
var statearr_38830_38867 = state_38818__$1;
(statearr_38830_38867[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (17))){
var inst_38797 = (state_38818[(12)]);
var inst_38769 = (state_38818[(13)]);
var inst_38772 = (state_38818[(14)]);
var inst_38770 = (state_38818[(15)]);
var inst_38788 = (state_38818[(8)]);
var inst_38767 = (state_38818[(16)]);
var inst_38764 = (state_38818[(17)]);
var inst_38774 = (state_38818[(9)]);
var inst_38766 = (state_38818[(18)]);
var inst_38768 = (state_38818[(11)]);
var inst_38773 = (state_38818[(19)]);
var inst_38771 = (state_38818[(20)]);
var inst_38801 = (function (){var recur_seen = inst_38770;
var recur_subject = inst_38764;
var sub_flakes = inst_38788;
var map__38763 = inst_38766;
var seen_QMARK_ = inst_38773;
var multi_QMARK_ = inst_38767;
var limit = inst_38772;
var recur_depth = inst_38771;
var as = inst_38768;
var max_depth_QMARK_ = inst_38774;
var recur = inst_38769;
var stop_QMARK_ = inst_38797;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_38818__$1 = state_38818;
var statearr_38831_38868 = state_38818__$1;
(statearr_38831_38868[(2)] = inst_38801);

(statearr_38831_38868[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (3))){
var inst_38816 = (state_38818[(2)]);
var state_38818__$1 = state_38818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38818__$1,inst_38816);
} else {
if((state_val_38819 === (12))){
var inst_38767 = (state_38818[(16)]);
var inst_38797 = (state_38818[(2)]);
var state_38818__$1 = (function (){var statearr_38832 = state_38818;
(statearr_38832[(12)] = inst_38797);

return statearr_38832;
})();
if(cljs.core.truth_(inst_38767)){
var statearr_38833_38869 = state_38818__$1;
(statearr_38833_38869[(1)] = (16));

} else {
var statearr_38834_38870 = state_38818__$1;
(statearr_38834_38870[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (2))){
var inst_38769 = (state_38818[(13)]);
var inst_38770 = (state_38818[(15)]);
var inst_38764 = (state_38818[(17)]);
var inst_38766 = (state_38818[(18)]);
var inst_38771 = (state_38818[(20)]);
var _ = (function (){var statearr_38835 = state_38818;
(statearr_38835[(4)] = cljs.core.cons((5),(state_38818[(4)])));

return statearr_38835;
})();
var inst_38764__$1 = flake.o;
var inst_38765 = select_spec;
var inst_38766__$1 = cljs.core.__destructure_map(inst_38765);
var inst_38767 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38766__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_38768 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38766__$1,cljs.core.cst$kw$as);
var inst_38769__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38766__$1,cljs.core.cst$kw$recur);
var inst_38770__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38766__$1,cljs.core.cst$kw$recur_DASH_seen);
var inst_38771__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38766__$1,cljs.core.cst$kw$recur_DASH_depth);
var inst_38772 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38766__$1,cljs.core.cst$kw$limit);
var inst_38773 = cljs.core.contains_QMARK_(inst_38770__$1,inst_38764__$1);
var inst_38774 = (inst_38771__$1 > inst_38769__$1);
var inst_38776 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38777 = [inst_38764__$1];
var inst_38778 = (new cljs.core.PersistentVector(null,1,(5),inst_38776,inst_38777,null));
var inst_38779 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38778);
var state_38818__$1 = (function (){var statearr_38836 = state_38818;
(statearr_38836[(13)] = inst_38769__$1);

(statearr_38836[(14)] = inst_38772);

(statearr_38836[(15)] = inst_38770__$1);

(statearr_38836[(16)] = inst_38767);

(statearr_38836[(17)] = inst_38764__$1);

(statearr_38836[(9)] = inst_38774);

(statearr_38836[(18)] = inst_38766__$1);

(statearr_38836[(11)] = inst_38768);

(statearr_38836[(19)] = inst_38773);

(statearr_38836[(20)] = inst_38771__$1);

return statearr_38836;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38818__$1,(6),inst_38779);
} else {
if((state_val_38819 === (19))){
var state_38818__$1 = state_38818;
var statearr_38837_38871 = state_38818__$1;
(statearr_38837_38871[(2)] = acc);

(statearr_38837_38871[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (11))){
var inst_38774 = (state_38818[(9)]);
var state_38818__$1 = state_38818;
if(cljs.core.truth_(inst_38774)){
var statearr_38839_38872 = state_38818__$1;
(statearr_38839_38872[(1)] = (13));

} else {
var statearr_38840_38873 = state_38818__$1;
(statearr_38840_38873[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (9))){
var inst_38773 = (state_38818[(19)]);
var inst_38788 = (state_38818[(2)]);
var state_38818__$1 = (function (){var statearr_38841 = state_38818;
(statearr_38841[(8)] = inst_38788);

return statearr_38841;
})();
if(cljs.core.truth_(inst_38773)){
var statearr_38842_38874 = state_38818__$1;
(statearr_38842_38874[(1)] = (10));

} else {
var statearr_38843_38875 = state_38818__$1;
(statearr_38843_38875[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (5))){
var _ = (function (){var statearr_38844 = state_38818;
(statearr_38844[(4)] = cljs.core.rest((state_38818[(4)])));

return statearr_38844;
})();
var state_38818__$1 = state_38818;
var ex38838 = (state_38818__$1[(2)]);
var statearr_38845_38876 = state_38818__$1;
(statearr_38845_38876[(5)] = ex38838);


if((ex38838 instanceof Error)){
var statearr_38846_38877 = state_38818__$1;
(statearr_38846_38877[(1)] = (4));

(statearr_38846_38877[(5)] = null);

} else {
throw ex38838;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (14))){
var inst_38788 = (state_38818[(8)]);
var inst_38793 = cljs.core.empty_QMARK_(inst_38788);
var state_38818__$1 = state_38818;
var statearr_38847_38878 = state_38818__$1;
(statearr_38847_38878[(2)] = inst_38793);

(statearr_38847_38878[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (16))){
var inst_38797 = (state_38818[(12)]);
var inst_38769 = (state_38818[(13)]);
var inst_38772 = (state_38818[(14)]);
var inst_38770 = (state_38818[(15)]);
var inst_38788 = (state_38818[(8)]);
var inst_38767 = (state_38818[(16)]);
var inst_38764 = (state_38818[(17)]);
var inst_38774 = (state_38818[(9)]);
var inst_38766 = (state_38818[(18)]);
var inst_38768 = (state_38818[(11)]);
var inst_38773 = (state_38818[(19)]);
var inst_38771 = (state_38818[(20)]);
var inst_38799 = (function (){var recur_seen = inst_38770;
var recur_subject = inst_38764;
var sub_flakes = inst_38788;
var map__38763 = inst_38766;
var seen_QMARK_ = inst_38773;
var multi_QMARK_ = inst_38767;
var limit = inst_38772;
var recur_depth = inst_38771;
var as = inst_38768;
var max_depth_QMARK_ = inst_38774;
var recur = inst_38769;
var stop_QMARK_ = inst_38797;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_38818__$1 = state_38818;
var statearr_38848_38879 = state_38818__$1;
(statearr_38848_38879[(2)] = inst_38799);

(statearr_38848_38879[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (10))){
var inst_38773 = (state_38818[(19)]);
var state_38818__$1 = state_38818;
var statearr_38849_38880 = state_38818__$1;
(statearr_38849_38880[(2)] = inst_38773);

(statearr_38849_38880[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (18))){
var inst_38797 = (state_38818[(12)]);
var inst_38803 = (state_38818[(2)]);
var state_38818__$1 = (function (){var statearr_38850 = state_38818;
(statearr_38850[(10)] = inst_38803);

return statearr_38850;
})();
if(cljs.core.truth_(inst_38797)){
var statearr_38851_38881 = state_38818__$1;
(statearr_38851_38881[(1)] = (19));

} else {
var statearr_38852_38882 = state_38818__$1;
(statearr_38852_38882[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38819 === (8))){
var inst_38782 = (state_38818[(7)]);
var state_38818__$1 = state_38818;
var statearr_38853_38883 = state_38818__$1;
(statearr_38853_38883[(2)] = inst_38782);

(statearr_38853_38883[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16153__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16153__auto____0 = (function (){
var statearr_38854 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38854[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__16153__auto__);

(statearr_38854[(1)] = (1));

return statearr_38854;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16153__auto____1 = (function (state_38818){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_38818);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e38855){var ex__16156__auto__ = e38855;
var statearr_38856_38884 = state_38818;
(statearr_38856_38884[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_38818[(4)]))){
var statearr_38857_38885 = state_38818;
(statearr_38857_38885[(1)] = cljs.core.first((state_38818[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__38886 = state_38818;
state_38818 = G__38886;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__16153__auto__ = function(state_38818){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16153__auto____1.call(this,state_38818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16153__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16153__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_38858 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_38858[(6)] = c__16227__auto__);

return statearr_38858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_39064){
var state_val_39065 = (state_39064[(1)]);
if((state_val_39065 === (7))){
var state_39064__$1 = state_39064;
var statearr_39066_39152 = state_39064__$1;
(statearr_39066_39152[(2)] = null);

(statearr_39066_39152[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (20))){
var inst_38925 = cljs.core.PersistentHashMap.EMPTY;
var state_39064__$1 = state_39064;
var statearr_39067_39153 = state_39064__$1;
(statearr_39067_39153[(2)] = inst_38925);

(statearr_39067_39153[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (27))){
var inst_38913 = (state_39064[(7)]);
var inst_38927 = (state_39064[(8)]);
var inst_38943 = (state_39064[(9)]);
var inst_38907 = (state_39064[(10)]);
var inst_39043 = (state_39064[(2)]);
var inst_39044 = (function (){var top_level_subject = inst_38907;
var select_spec = inst_38913;
var base_acc = inst_38927;
var acc_PLUS_refs = inst_38943;
var result = inst_39043;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4223__auto__ = (function (){var and__4221__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_39045 = cljs.core.PersistentVector.EMPTY;
var inst_39046 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38913);
var inst_39047 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_39046);
var inst_39048 = cljs.core.vals(inst_39047);
var inst_39049 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38913);
var inst_39050 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_39049);
var inst_39051 = cljs.core.vals(inst_39050);
var inst_39052 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39048,inst_39051);
var inst_39053 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39044,inst_39045,inst_39052);
var inst_39055 = (function (){var top_level_subject = inst_38907;
var select_spec = inst_38913;
var base_acc = inst_38927;
var acc_PLUS_refs = inst_38943;
var result = inst_39043;
var sort_preds = inst_39053;
return (function (acc,p__39054){
var vec__39068 = p__39054;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39068,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39068,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39068,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39068,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_39056 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39055,inst_39043,inst_39053);
var state_39064__$1 = state_39064;
var statearr_39071_39154 = state_39064__$1;
(statearr_39071_39154[(2)] = inst_39056);

(statearr_39071_39154[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (1))){
var state_39064__$1 = state_39064;
var statearr_39072_39155 = state_39064__$1;
(statearr_39072_39155[(2)] = null);

(statearr_39072_39155[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (24))){
var inst_38943 = (state_39064[(9)]);
var inst_38943__$1 = (state_39064[(2)]);
var inst_38944 = flakes;
var inst_38945 = cljs.core.PersistentHashMap.EMPTY;
var inst_38946 = inst_38944;
var inst_38947 = inst_38943__$1;
var inst_38948 = inst_38945;
var state_39064__$1 = (function (){var statearr_39073 = state_39064;
(statearr_39073[(11)] = inst_38948);

(statearr_39073[(12)] = inst_38947);

(statearr_39073[(13)] = inst_38946);

(statearr_39073[(9)] = inst_38943__$1);

return statearr_39073;
})();
var statearr_39074_39156 = state_39064__$1;
(statearr_39074_39156[(2)] = null);

(statearr_39074_39156[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (39))){
var inst_38947 = (state_39064[(12)]);
var inst_38913 = (state_39064[(7)]);
var inst_38956 = (state_39064[(14)]);
var inst_38962 = (state_39064[(15)]);
var inst_38991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38992 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_38947,inst_38913,inst_38956,inst_38962,false);
var state_39064__$1 = (function (){var statearr_39075 = state_39064;
(statearr_39075[(16)] = inst_38991);

return statearr_39075;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39064__$1,(42),inst_38992);
} else {
if((state_val_39065 === (46))){
var inst_38948 = (state_39064[(11)]);
var inst_38956 = (state_39064[(14)]);
var inst_38946 = (state_39064[(13)]);
var inst_39009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39010 = [cljs.core.cst$kw$_id];
var inst_39011 = inst_38956.s;
var inst_39012 = [inst_39011];
var inst_39013 = cljs.core.PersistentHashMap.fromArrays(inst_39010,inst_39012);
var inst_39014 = cljs.core.rest(inst_38946);
var inst_39015 = [inst_39013,inst_39014,inst_38948];
var inst_39016 = (new cljs.core.PersistentVector(null,3,(5),inst_39009,inst_39015,null));
var state_39064__$1 = state_39064;
var statearr_39076_39157 = state_39064__$1;
(statearr_39076_39157[(2)] = inst_39016);

(statearr_39076_39157[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (4))){
var inst_38887 = (state_39064[(2)]);
var state_39064__$1 = state_39064;
var statearr_39077_39158 = state_39064__$1;
(statearr_39077_39158[(2)] = inst_38887);

(statearr_39077_39158[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (15))){
var inst_38913 = (state_39064[(7)]);
var inst_38914 = (state_39064[(17)]);
var inst_38913__$1 = (state_39064[(2)]);
var inst_38914__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38913__$1);
var state_39064__$1 = (function (){var statearr_39078 = state_39064;
(statearr_39078[(7)] = inst_38913__$1);

(statearr_39078[(17)] = inst_38914__$1);

return statearr_39078;
})();
if(cljs.core.truth_(inst_38914__$1)){
var statearr_39079_39159 = state_39064__$1;
(statearr_39079_39159[(1)] = (16));

} else {
var statearr_39080_39160 = state_39064__$1;
(statearr_39080_39160[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (48))){
var inst_39027 = (state_39064[(2)]);
var state_39064__$1 = state_39064;
var statearr_39081_39161 = state_39064__$1;
(statearr_39081_39161[(2)] = inst_39027);

(statearr_39081_39161[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (50))){
var state_39064__$1 = state_39064;
var statearr_39082_39162 = state_39064__$1;
(statearr_39082_39162[(2)] = null);

(statearr_39082_39162[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (21))){
var inst_38913 = (state_39064[(7)]);
var inst_38927 = (state_39064[(2)]);
var inst_38928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38929 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_38930 = (new cljs.core.PersistentVector(null,2,(5),inst_38928,inst_38929,null));
var inst_38931 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38913,inst_38930);
var state_39064__$1 = (function (){var statearr_39083 = state_39064;
(statearr_39083[(8)] = inst_38927);

return statearr_39083;
})();
if(cljs.core.truth_(inst_38931)){
var statearr_39084_39163 = state_39064__$1;
(statearr_39084_39163[(1)] = (22));

} else {
var statearr_39085_39164 = state_39064__$1;
(statearr_39085_39164[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (31))){
var inst_38947 = (state_39064[(12)]);
var inst_38956 = (state_39064[(14)]);
var inst_38961 = (state_39064[(18)]);
var inst_38965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38966 = fluree.db.query.fql.flake__GT_recur(db,inst_38956,inst_38961,inst_38947,fuel,max_fuel,cache);
var state_39064__$1 = (function (){var statearr_39086 = state_39064;
(statearr_39086[(19)] = inst_38965);

return statearr_39086;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39064__$1,(34),inst_38966);
} else {
if((state_val_39065 === (32))){
var inst_38961 = (state_39064[(18)]);
var state_39064__$1 = state_39064;
if(cljs.core.truth_(inst_38961)){
var statearr_39087_39165 = state_39064__$1;
(statearr_39087_39165[(1)] = (35));

} else {
var statearr_39088_39166 = state_39064__$1;
(statearr_39088_39166[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (40))){
var inst_38913 = (state_39064[(7)]);
var inst_39002 = (state_39064[(20)]);
var inst_39001 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38913);
var inst_39002__$1 = cljs.core.empty_QMARK_(inst_39001);
var state_39064__$1 = (function (){var statearr_39089 = state_39064;
(statearr_39089[(20)] = inst_39002__$1);

return statearr_39089;
})();
if(inst_39002__$1){
var statearr_39090_39167 = state_39064__$1;
(statearr_39090_39167[(1)] = (43));

} else {
var statearr_39091_39168 = state_39064__$1;
(statearr_39091_39168[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (33))){
var inst_38956 = (state_39064[(14)]);
var inst_39033 = (state_39064[(2)]);
var inst_39034 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39033,(0),null);
var inst_39035 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39033,(1),null);
var inst_39036 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39033,(2),null);
var inst_39037 = inst_38956.s;
var inst_39038 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39034,cljs.core.cst$kw$_id,inst_39037);
var inst_38946 = inst_39035;
var inst_38947 = inst_39038;
var inst_38948 = inst_39036;
var state_39064__$1 = (function (){var statearr_39092 = state_39064;
(statearr_39092[(11)] = inst_38948);

(statearr_39092[(12)] = inst_38947);

(statearr_39092[(13)] = inst_38946);

return statearr_39092;
})();
var statearr_39093_39169 = state_39064__$1;
(statearr_39093_39169[(2)] = null);

(statearr_39093_39169[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (13))){
var inst_38907 = (state_39064[(10)]);
var inst_38910 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_38907);
var state_39064__$1 = state_39064;
var statearr_39094_39170 = state_39064__$1;
(statearr_39094_39170[(2)] = inst_38910);

(statearr_39094_39170[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (22))){
var inst_38913 = (state_39064[(7)]);
var inst_38933 = cljs.core.first(flakes);
var inst_38934 = fluree.db.query.fql.s(inst_38933);
var inst_38935 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_38913);
var inst_38936 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_38934,inst_38935);
var state_39064__$1 = state_39064;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39064__$1,(25),inst_38936);
} else {
if((state_val_39065 === (36))){
var inst_38913 = (state_39064[(7)]);
var inst_38989 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38913);
var state_39064__$1 = state_39064;
if(cljs.core.truth_(inst_38989)){
var statearr_39095_39171 = state_39064__$1;
(statearr_39095_39171[(1)] = (39));

} else {
var statearr_39096_39172 = state_39064__$1;
(statearr_39096_39172[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (41))){
var inst_39029 = (state_39064[(2)]);
var state_39064__$1 = state_39064;
var statearr_39097_39173 = state_39064__$1;
(statearr_39097_39173[(2)] = inst_39029);

(statearr_39097_39173[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (43))){
var inst_38913 = (state_39064[(7)]);
var inst_39004 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38913);
var state_39064__$1 = state_39064;
var statearr_39098_39174 = state_39064__$1;
(statearr_39098_39174[(2)] = inst_39004);

(statearr_39098_39174[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (29))){
var inst_38913 = (state_39064[(7)]);
var inst_38956 = (state_39064[(14)]);
var inst_38946 = (state_39064[(13)]);
var inst_38961 = (state_39064[(18)]);
var inst_38956__$1 = cljs.core.first(inst_38946);
var inst_38957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38958 = inst_38956__$1.p;
var inst_38959 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_38958];
var inst_38960 = (new cljs.core.PersistentVector(null,3,(5),inst_38957,inst_38959,null));
var inst_38961__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38913,inst_38960);
var inst_38962 = fluree.db.query.fql.component_follow_QMARK_(inst_38961__$1,inst_38913);
var inst_38963 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_38961__$1);
var state_39064__$1 = (function (){var statearr_39099 = state_39064;
(statearr_39099[(14)] = inst_38956__$1);

(statearr_39099[(18)] = inst_38961__$1);

(statearr_39099[(15)] = inst_38962);

return statearr_39099;
})();
if(cljs.core.truth_(inst_38963)){
var statearr_39100_39175 = state_39064__$1;
(statearr_39100_39175[(1)] = (31));

} else {
var statearr_39101_39176 = state_39064__$1;
(statearr_39101_39176[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (44))){
var inst_39002 = (state_39064[(20)]);
var state_39064__$1 = state_39064;
var statearr_39102_39177 = state_39064__$1;
(statearr_39102_39177[(2)] = inst_39002);

(statearr_39102_39177[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (6))){
var state_39064__$1 = state_39064;
var statearr_39103_39178 = state_39064__$1;
(statearr_39103_39178[(2)] = null);

(statearr_39103_39178[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (28))){
var inst_38947 = (state_39064[(12)]);
var state_39064__$1 = state_39064;
var statearr_39104_39179 = state_39064__$1;
(statearr_39104_39179[(2)] = inst_38947);

(statearr_39104_39179[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (51))){
var inst_39025 = (state_39064[(2)]);
var state_39064__$1 = state_39064;
var statearr_39105_39180 = state_39064__$1;
(statearr_39105_39180[(2)] = inst_39025);

(statearr_39105_39180[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (25))){
var inst_38927 = (state_39064[(8)]);
var inst_38938 = (state_39064[(2)]);
var inst_38939 = fluree.db.util.async.throw_err(inst_38938);
var inst_38940 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38927,inst_38939], 0));
var state_39064__$1 = state_39064;
var statearr_39106_39181 = state_39064__$1;
(statearr_39106_39181[(2)] = inst_38940);

(statearr_39106_39181[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (34))){
var inst_38948 = (state_39064[(11)]);
var inst_38946 = (state_39064[(13)]);
var inst_38965 = (state_39064[(19)]);
var inst_38968 = (state_39064[(2)]);
var inst_38969 = fluree.db.util.async.throw_err(inst_38968);
var inst_38970 = cljs.core.rest(inst_38946);
var inst_38971 = [inst_38969,inst_38970,inst_38948];
var inst_38972 = (new cljs.core.PersistentVector(null,3,(5),inst_38965,inst_38971,null));
var state_39064__$1 = state_39064;
var statearr_39107_39182 = state_39064__$1;
(statearr_39107_39182[(2)] = inst_38972);

(statearr_39107_39182[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (17))){
var inst_38913 = (state_39064[(7)]);
var inst_38917 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38913);
var state_39064__$1 = state_39064;
var statearr_39109_39183 = state_39064__$1;
(statearr_39109_39183[(2)] = inst_38917);

(statearr_39109_39183[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (3))){
var inst_39062 = (state_39064[(2)]);
var state_39064__$1 = state_39064;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39064__$1,inst_39062);
} else {
if((state_val_39065 === (12))){
var _ = (function (){var statearr_39110 = state_39064;
(statearr_39110[(4)] = cljs.core.rest((state_39064[(4)])));

return statearr_39110;
})();
var state_39064__$1 = state_39064;
var ex39108 = (state_39064__$1[(2)]);
var statearr_39111_39184 = state_39064__$1;
(statearr_39111_39184[(5)] = ex39108);


var statearr_39112_39185 = state_39064__$1;
(statearr_39112_39185[(1)] = (11));

(statearr_39112_39185[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (2))){
var _ = (function (){var statearr_39113 = state_39064;
(statearr_39113[(4)] = cljs.core.cons((5),(state_39064[(4)])));

return statearr_39113;
})();
var inst_38893 = cljs.core.not_empty(flakes);
var state_39064__$1 = state_39064;
if(cljs.core.truth_(inst_38893)){
var statearr_39114_39186 = state_39064__$1;
(statearr_39114_39186[(1)] = (6));

} else {
var statearr_39115_39187 = state_39064__$1;
(statearr_39115_39187[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (23))){
var inst_38927 = (state_39064[(8)]);
var state_39064__$1 = state_39064;
var statearr_39116_39188 = state_39064__$1;
(statearr_39116_39188[(2)] = inst_38927);

(statearr_39116_39188[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (47))){
var state_39064__$1 = state_39064;
var statearr_39117_39189 = state_39064__$1;
(statearr_39117_39189[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (35))){
var inst_38948 = (state_39064[(11)]);
var inst_38947 = (state_39064[(12)]);
var inst_38956 = (state_39064[(14)]);
var inst_38961 = (state_39064[(18)]);
var inst_38962 = (state_39064[(15)]);
var inst_38978 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_38947,inst_38961,inst_38956,inst_38962,false,inst_38948);
var state_39064__$1 = state_39064;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39064__$1,(38),inst_38978);
} else {
if((state_val_39065 === (19))){
var inst_38907 = (state_39064[(10)]);
var inst_38921 = [cljs.core.cst$kw$_id];
var inst_38922 = [inst_38907];
var inst_38923 = cljs.core.PersistentHashMap.fromArrays(inst_38921,inst_38922);
var state_39064__$1 = state_39064;
var statearr_39119_39190 = state_39064__$1;
(statearr_39119_39190[(2)] = inst_38923);

(statearr_39119_39190[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (11))){
var inst_38895 = (state_39064[(2)]);
var inst_38896 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38895], 0));
var inst_38897 = (function(){throw inst_38895})();
var state_39064__$1 = (function (){var statearr_39121 = state_39064;
(statearr_39121[(21)] = inst_38896);

return statearr_39121;
})();
var statearr_39122_39191 = state_39064__$1;
(statearr_39122_39191[(2)] = inst_38897);

(statearr_39122_39191[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (9))){
var _ = (function (){var statearr_39123 = state_39064;
(statearr_39123[(4)] = cljs.core.cons((12),(state_39064[(4)])));

return statearr_39123;
})();
var inst_38903 = cljs.core.first(flakes);
var inst_38904 = fluree.db.query.fql.s(inst_38903);
var ___$1 = (function (){var statearr_39124 = state_39064;
(statearr_39124[(4)] = cljs.core.rest((state_39064[(4)])));

return statearr_39124;
})();
var state_39064__$1 = state_39064;
var statearr_39125_39192 = state_39064__$1;
(statearr_39125_39192[(2)] = inst_38904);

(statearr_39125_39192[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (5))){
var _ = (function (){var statearr_39126 = state_39064;
(statearr_39126[(4)] = cljs.core.rest((state_39064[(4)])));

return statearr_39126;
})();
var state_39064__$1 = state_39064;
var ex39120 = (state_39064__$1[(2)]);
var statearr_39127_39193 = state_39064__$1;
(statearr_39127_39193[(5)] = ex39120);


if((ex39120 instanceof Error)){
var statearr_39128_39194 = state_39064__$1;
(statearr_39128_39194[(1)] = (4));

(statearr_39128_39194[(5)] = null);

} else {
throw ex39120;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (14))){
var state_39064__$1 = state_39064;
var statearr_39129_39195 = state_39064__$1;
(statearr_39129_39195[(2)] = base_select_spec);

(statearr_39129_39195[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (45))){
var inst_39007 = (state_39064[(2)]);
var state_39064__$1 = state_39064;
if(cljs.core.truth_(inst_39007)){
var statearr_39130_39196 = state_39064__$1;
(statearr_39130_39196[(1)] = (46));

} else {
var statearr_39131_39197 = state_39064__$1;
(statearr_39131_39197[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (26))){
var inst_38946 = (state_39064[(13)]);
var inst_38950 = cljs.core.empty_QMARK_(inst_38946);
var state_39064__$1 = state_39064;
if(inst_38950){
var statearr_39132_39198 = state_39064__$1;
(statearr_39132_39198[(1)] = (28));

} else {
var statearr_39133_39199 = state_39064__$1;
(statearr_39133_39199[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (16))){
var inst_38914 = (state_39064[(17)]);
var state_39064__$1 = state_39064;
var statearr_39134_39200 = state_39064__$1;
(statearr_39134_39200[(2)] = inst_38914);

(statearr_39134_39200[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (38))){
var inst_38946 = (state_39064[(13)]);
var inst_38980 = (state_39064[(2)]);
var inst_38981 = fluree.db.util.async.throw_err(inst_38980);
var inst_38982 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38981,(0),null);
var inst_38983 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38981,(1),null);
var inst_38984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38985 = cljs.core.rest(inst_38946);
var inst_38986 = [inst_38982,inst_38985,inst_38983];
var inst_38987 = (new cljs.core.PersistentVector(null,3,(5),inst_38984,inst_38986,null));
var state_39064__$1 = state_39064;
var statearr_39135_39201 = state_39064__$1;
(statearr_39135_39201[(2)] = inst_38987);

(statearr_39135_39201[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (30))){
var inst_39041 = (state_39064[(2)]);
var state_39064__$1 = state_39064;
var statearr_39136_39202 = state_39064__$1;
(statearr_39136_39202[(2)] = inst_39041);

(statearr_39136_39202[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (10))){
var inst_38907 = (state_39064[(2)]);
var inst_38908 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_39064__$1 = (function (){var statearr_39137 = state_39064;
(statearr_39137[(10)] = inst_38907);

return statearr_39137;
})();
if(cljs.core.truth_(inst_38908)){
var statearr_39138_39203 = state_39064__$1;
(statearr_39138_39203[(1)] = (13));

} else {
var statearr_39139_39204 = state_39064__$1;
(statearr_39139_39204[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (18))){
var inst_38919 = (state_39064[(2)]);
var state_39064__$1 = state_39064;
if(cljs.core.truth_(inst_38919)){
var statearr_39140_39205 = state_39064__$1;
(statearr_39140_39205[(1)] = (19));

} else {
var statearr_39141_39206 = state_39064__$1;
(statearr_39141_39206[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (42))){
var inst_38948 = (state_39064[(11)]);
var inst_38946 = (state_39064[(13)]);
var inst_38991 = (state_39064[(16)]);
var inst_38994 = (state_39064[(2)]);
var inst_38995 = fluree.db.util.async.throw_err(inst_38994);
var inst_38996 = cljs.core.first(inst_38995);
var inst_38997 = cljs.core.rest(inst_38946);
var inst_38998 = [inst_38996,inst_38997,inst_38948];
var inst_38999 = (new cljs.core.PersistentVector(null,3,(5),inst_38991,inst_38998,null));
var state_39064__$1 = state_39064;
var statearr_39142_39207 = state_39064__$1;
(statearr_39142_39207[(2)] = inst_38999);

(statearr_39142_39207[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (37))){
var inst_39031 = (state_39064[(2)]);
var state_39064__$1 = state_39064;
var statearr_39143_39208 = state_39064__$1;
(statearr_39143_39208[(2)] = inst_39031);

(statearr_39143_39208[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (8))){
var inst_39059 = (state_39064[(2)]);
var _ = (function (){var statearr_39144 = state_39064;
(statearr_39144[(4)] = cljs.core.rest((state_39064[(4)])));

return statearr_39144;
})();
var state_39064__$1 = state_39064;
var statearr_39145_39209 = state_39064__$1;
(statearr_39145_39209[(2)] = inst_39059);

(statearr_39145_39209[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39065 === (49))){
var inst_38948 = (state_39064[(11)]);
var inst_38947 = (state_39064[(12)]);
var inst_38946 = (state_39064[(13)]);
var inst_39019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39020 = cljs.core.rest(inst_38946);
var inst_39021 = [inst_38947,inst_39020,inst_38948];
var inst_39022 = (new cljs.core.PersistentVector(null,3,(5),inst_39019,inst_39021,null));
var state_39064__$1 = state_39064;
var statearr_39146_39210 = state_39064__$1;
(statearr_39146_39210[(2)] = inst_39022);

(statearr_39146_39210[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16153__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16153__auto____0 = (function (){
var statearr_39147 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39147[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__16153__auto__);

(statearr_39147[(1)] = (1));

return statearr_39147;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16153__auto____1 = (function (state_39064){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_39064);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e39148){var ex__16156__auto__ = e39148;
var statearr_39149_39211 = state_39064;
(statearr_39149_39211[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_39064[(4)]))){
var statearr_39150_39212 = state_39064;
(statearr_39150_39212[(1)] = cljs.core.first((state_39064[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__39213 = state_39064;
state_39064 = G__39213;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__16153__auto__ = function(state_39064){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16153__auto____1.call(this,state_39064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16153__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16153__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_39151 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_39151[(6)] = c__16227__auto__);

return statearr_39151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__39216 = arguments.length;
switch (G__39216) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_39258){
var state_val_39259 = (state_39258[(1)]);
if((state_val_39259 === (7))){
var inst_39224 = (state_39258[(7)]);
var state_39258__$1 = state_39258;
var statearr_39260_39290 = state_39258__$1;
(statearr_39260_39290[(2)] = inst_39224);

(statearr_39260_39290[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39259 === (1))){
var state_39258__$1 = state_39258;
var statearr_39261_39291 = state_39258__$1;
(statearr_39261_39291[(2)] = null);

(statearr_39261_39291[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39259 === (4))){
var inst_39217 = (state_39258[(2)]);
var state_39258__$1 = state_39258;
var statearr_39262_39292 = state_39258__$1;
(statearr_39262_39292[(2)] = inst_39217);

(statearr_39262_39292[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39259 === (15))){
var inst_39252 = (state_39258[(2)]);
var inst_39253 = fluree.db.util.async.throw_err(inst_39252);
var _ = (function (){var statearr_39263 = state_39258;
(statearr_39263[(4)] = cljs.core.rest((state_39258[(4)])));

return statearr_39263;
})();
var state_39258__$1 = state_39258;
var statearr_39264_39293 = state_39258__$1;
(statearr_39264_39293[(2)] = inst_39253);

(statearr_39264_39293[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39259 === (13))){
var inst_39236 = (state_39258[(8)]);
var state_39258__$1 = state_39258;
var statearr_39265_39294 = state_39258__$1;
(statearr_39265_39294[(2)] = inst_39236);

(statearr_39265_39294[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39259 === (6))){
var inst_39224 = (state_39258[(7)]);
var inst_39226 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_39227 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39224,inst_39226);
var state_39258__$1 = state_39258;
var statearr_39266_39295 = state_39258__$1;
(statearr_39266_39295[(2)] = inst_39227);

(statearr_39266_39295[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39259 === (3))){
var inst_39256 = (state_39258[(2)]);
var state_39258__$1 = state_39258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39258__$1,inst_39256);
} else {
if((state_val_39259 === (12))){
var inst_39236 = (state_39258[(8)]);
var inst_39238 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_39239 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39236,inst_39238);
var state_39258__$1 = state_39258;
var statearr_39267_39296 = state_39258__$1;
(statearr_39267_39296[(2)] = inst_39239);

(statearr_39267_39296[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39259 === (2))){
var _ = (function (){var statearr_39268 = state_39258;
(statearr_39268[(4)] = cljs.core.cons((5),(state_39258[(4)])));

return statearr_39268;
})();
var inst_39224 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_39258__$1 = (function (){var statearr_39269 = state_39258;
(statearr_39269[(7)] = inst_39224);

return statearr_39269;
})();
if(cljs.core.truth_(fuel)){
var statearr_39270_39297 = state_39258__$1;
(statearr_39270_39297[(1)] = (6));

} else {
var statearr_39271_39298 = state_39258__$1;
(statearr_39271_39298[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39259 === (11))){
var inst_39236 = (state_39258[(2)]);
var state_39258__$1 = (function (){var statearr_39273 = state_39258;
(statearr_39273[(8)] = inst_39236);

return statearr_39273;
})();
if(cljs.core.truth_(limit)){
var statearr_39274_39299 = state_39258__$1;
(statearr_39274_39299[(1)] = (12));

} else {
var statearr_39275_39300 = state_39258__$1;
(statearr_39275_39300[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39259 === (9))){
var inst_39230 = (state_39258[(9)]);
var inst_39232 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_39233 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39230,inst_39232);
var state_39258__$1 = state_39258;
var statearr_39276_39301 = state_39258__$1;
(statearr_39276_39301[(2)] = inst_39233);

(statearr_39276_39301[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39259 === (5))){
var _ = (function (){var statearr_39277 = state_39258;
(statearr_39277[(4)] = cljs.core.rest((state_39258[(4)])));

return statearr_39277;
})();
var state_39258__$1 = state_39258;
var ex39272 = (state_39258__$1[(2)]);
var statearr_39278_39302 = state_39258__$1;
(statearr_39278_39302[(5)] = ex39272);


if((ex39272 instanceof Error)){
var statearr_39279_39303 = state_39258__$1;
(statearr_39279_39303[(1)] = (4));

(statearr_39279_39303[(5)] = null);

} else {
throw ex39272;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39259 === (14))){
var inst_39242 = (state_39258[(2)]);
var inst_39243 = (function (){return (function (x){
var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4221__auto__;
}
});
})();
var inst_39244 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_39243);
var inst_39245 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39242,inst_39244);
var inst_39246 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_39245,flakes);
var inst_39247 = cljs.core.PersistentVector.EMPTY;
var inst_39248 = (function (){var xf = inst_39245;
var flakes_by_sub = inst_39246;
return (function (p1__39214_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__39214_SHARP_);
});
})();
var inst_39249 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39248,inst_39246);
var inst_39250 = fluree.db.util.async.merge_into_QMARK_(inst_39247,inst_39249);
var state_39258__$1 = state_39258;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39258__$1,(15),inst_39250);
} else {
if((state_val_39259 === (10))){
var inst_39230 = (state_39258[(9)]);
var state_39258__$1 = state_39258;
var statearr_39280_39304 = state_39258__$1;
(statearr_39280_39304[(2)] = inst_39230);

(statearr_39280_39304[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39259 === (8))){
var inst_39230 = (state_39258[(2)]);
var state_39258__$1 = (function (){var statearr_39281 = state_39258;
(statearr_39281[(9)] = inst_39230);

return statearr_39281;
})();
if(cljs.core.truth_(offset)){
var statearr_39282_39305 = state_39258__$1;
(statearr_39282_39305[(1)] = (9));

} else {
var statearr_39283_39306 = state_39258__$1;
(statearr_39283_39306[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16153__auto__ = null;
var fluree$db$query$fql$state_machine__16153__auto____0 = (function (){
var statearr_39284 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39284[(0)] = fluree$db$query$fql$state_machine__16153__auto__);

(statearr_39284[(1)] = (1));

return statearr_39284;
});
var fluree$db$query$fql$state_machine__16153__auto____1 = (function (state_39258){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_39258);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e39285){var ex__16156__auto__ = e39285;
var statearr_39286_39307 = state_39258;
(statearr_39286_39307[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_39258[(4)]))){
var statearr_39287_39308 = state_39258;
(statearr_39287_39308[(1)] = cljs.core.first((state_39258[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__39309 = state_39258;
state_39258 = G__39309;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16153__auto__ = function(state_39258){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16153__auto____1.call(this,state_39258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16153__auto____0;
fluree$db$query$fql$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16153__auto____1;
return fluree$db$query$fql$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_39288 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_39288[(6)] = c__16227__auto__);

return statearr_39288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__39311 = arguments.length;
switch (G__39311) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_39392){
var state_val_39393 = (state_39392[(1)]);
if((state_val_39393 === (7))){
var inst_39387 = (state_39392[(2)]);
var _ = (function (){var statearr_39395 = state_39392;
(statearr_39395[(4)] = cljs.core.rest((state_39392[(4)])));

return statearr_39395;
})();
var state_39392__$1 = state_39392;
var statearr_39396_39443 = state_39392__$1;
(statearr_39396_39443[(2)] = inst_39387);

(statearr_39396_39443[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (20))){
var inst_39331 = (state_39392[(7)]);
var inst_39332 = (state_39392[(8)]);
var inst_39339 = (state_39392[(9)]);
var inst_39360 = (inst_39331 + (1));
var tmp39394 = inst_39332;
var inst_39330 = inst_39339;
var inst_39331__$1 = inst_39360;
var inst_39332__$1 = tmp39394;
var state_39392__$1 = (function (){var statearr_39397 = state_39392;
(statearr_39397[(7)] = inst_39331__$1);

(statearr_39397[(8)] = inst_39332__$1);

(statearr_39397[(10)] = inst_39330);

return statearr_39397;
})();
var statearr_39398_39444 = state_39392__$1;
(statearr_39398_39444[(2)] = null);

(statearr_39398_39444[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (27))){
var inst_39365 = (state_39392[(11)]);
var inst_39371 = (state_39392[(2)]);
var inst_39372 = fluree.db.util.async.throw_err(inst_39371);
var inst_39373 = (inst_39365.cljs$core$IFn$_invoke$arity$1 ? inst_39365.cljs$core$IFn$_invoke$arity$1(inst_39372) : inst_39365.call(null,inst_39372));
var state_39392__$1 = state_39392;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39392__$1,(26),inst_39373);
} else {
if((state_val_39393 === (1))){
var state_39392__$1 = state_39392;
var statearr_39399_39445 = state_39392__$1;
(statearr_39399_39445[(2)] = null);

(statearr_39399_39445[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (24))){
var state_39392__$1 = state_39392;
var statearr_39400_39446 = state_39392__$1;
(statearr_39400_39446[(2)] = null);

(statearr_39400_39446[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (4))){
var inst_39312 = (state_39392[(2)]);
var state_39392__$1 = state_39392;
var statearr_39401_39447 = state_39392__$1;
(statearr_39401_39447[(2)] = inst_39312);

(statearr_39401_39447[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (15))){
var inst_39353 = (state_39392[(12)]);
var inst_39353__$1 = offset;
var state_39392__$1 = (function (){var statearr_39402 = state_39392;
(statearr_39402[(12)] = inst_39353__$1);

return statearr_39402;
})();
if(cljs.core.truth_(inst_39353__$1)){
var statearr_39403_39448 = state_39392__$1;
(statearr_39403_39448[(1)] = (17));

} else {
var statearr_39404_39449 = state_39392__$1;
(statearr_39404_39449[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (21))){
var state_39392__$1 = state_39392;
var statearr_39405_39450 = state_39392__$1;
(statearr_39405_39450[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (13))){
var inst_39348 = (state_39392[(2)]);
var state_39392__$1 = state_39392;
var statearr_39407_39451 = state_39392__$1;
(statearr_39407_39451[(2)] = inst_39348);

(statearr_39407_39451[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (22))){
var inst_39383 = (state_39392[(2)]);
var state_39392__$1 = state_39392;
var statearr_39408_39452 = state_39392__$1;
(statearr_39408_39452[(2)] = inst_39383);

(statearr_39408_39452[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (6))){
var inst_39340 = (state_39392[(13)]);
var inst_39338 = (state_39392[(14)]);
var inst_39330 = (state_39392[(10)]);
var inst_39337 = cljs.core.seq(inst_39330);
var inst_39338__$1 = cljs.core.first(inst_39337);
var inst_39339 = cljs.core.next(inst_39337);
var inst_39340__$1 = (inst_39338__$1 == null);
var state_39392__$1 = (function (){var statearr_39409 = state_39392;
(statearr_39409[(13)] = inst_39340__$1);

(statearr_39409[(14)] = inst_39338__$1);

(statearr_39409[(9)] = inst_39339);

return statearr_39409;
})();
if(cljs.core.truth_(inst_39340__$1)){
var statearr_39410_39453 = state_39392__$1;
(statearr_39410_39453[(1)] = (8));

} else {
var statearr_39411_39454 = state_39392__$1;
(statearr_39411_39454[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (25))){
var inst_39381 = (state_39392[(2)]);
var state_39392__$1 = state_39392;
var statearr_39412_39455 = state_39392__$1;
(statearr_39412_39455[(2)] = inst_39381);

(statearr_39412_39455[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (17))){
var inst_39331 = (state_39392[(7)]);
var inst_39355 = (inst_39331 < offset);
var state_39392__$1 = state_39392;
var statearr_39413_39456 = state_39392__$1;
(statearr_39413_39456[(2)] = inst_39355);

(statearr_39413_39456[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (3))){
var inst_39390 = (state_39392[(2)]);
var state_39392__$1 = state_39392;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39392__$1,inst_39390);
} else {
if((state_val_39393 === (12))){
var inst_39343 = (state_39392[(15)]);
var state_39392__$1 = state_39392;
var statearr_39414_39457 = state_39392__$1;
(statearr_39414_39457[(2)] = inst_39343);

(statearr_39414_39457[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (2))){
var inst_39325 = (state_39392[(16)]);
var _ = (function (){var statearr_39415 = state_39392;
(statearr_39415[(4)] = cljs.core.cons((5),(state_39392[(4)])));

return statearr_39415;
})();
var inst_39325__$1 = subjects;
var inst_39326 = cljs.core.seq(inst_39325__$1);
var inst_39327 = cljs.core.first(inst_39326);
var inst_39328 = cljs.core.next(inst_39326);
var inst_39329 = cljs.core.PersistentVector.EMPTY;
var inst_39330 = inst_39325__$1;
var inst_39331 = (0);
var inst_39332 = inst_39329;
var state_39392__$1 = (function (){var statearr_39416 = state_39392;
(statearr_39416[(7)] = inst_39331);

(statearr_39416[(17)] = inst_39327);

(statearr_39416[(8)] = inst_39332);

(statearr_39416[(16)] = inst_39325__$1);

(statearr_39416[(10)] = inst_39330);

(statearr_39416[(18)] = inst_39328);

return statearr_39416;
})();
var statearr_39417_39458 = state_39392__$1;
(statearr_39417_39458[(2)] = null);

(statearr_39417_39458[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (23))){
var inst_39331 = (state_39392[(7)]);
var inst_39327 = (state_39392[(17)]);
var inst_39338 = (state_39392[(14)]);
var inst_39332 = (state_39392[(8)]);
var inst_39325 = (state_39392[(16)]);
var inst_39339 = (state_39392[(9)]);
var inst_39330 = (state_39392[(10)]);
var inst_39328 = (state_39392[(18)]);
var inst_39364 = (inst_39331 + (1));
var inst_39365 = (function (){var seq__39323 = inst_39328;
var vec__39334 = inst_39330;
var r = inst_39339;
var G__39321 = inst_39330;
var acc = inst_39332;
var n = inst_39331;
var seq__39335 = inst_39339;
var first__39324 = inst_39327;
var s = inst_39338;
var first__39336 = inst_39338;
var vec__39322 = inst_39325;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_39366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39367 = [inst_39338];
var inst_39368 = (new cljs.core.PersistentVector(null,1,(5),inst_39366,inst_39367,null));
var inst_39369 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_39368);
var state_39392__$1 = (function (){var statearr_39418 = state_39392;
(statearr_39418[(19)] = inst_39364);

(statearr_39418[(11)] = inst_39365);

return statearr_39418;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39392__$1,(27),inst_39369);
} else {
if((state_val_39393 === (19))){
var inst_39358 = (state_39392[(2)]);
var state_39392__$1 = state_39392;
if(cljs.core.truth_(inst_39358)){
var statearr_39419_39459 = state_39392__$1;
(statearr_39419_39459[(1)] = (20));

} else {
var statearr_39420_39460 = state_39392__$1;
(statearr_39420_39460[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (11))){
var inst_39331 = (state_39392[(7)]);
var inst_39345 = (inst_39331 > limit);
var state_39392__$1 = state_39392;
var statearr_39422_39461 = state_39392__$1;
(statearr_39422_39461[(2)] = inst_39345);

(statearr_39422_39461[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (9))){
var inst_39343 = (state_39392[(15)]);
var inst_39343__$1 = limit;
var state_39392__$1 = (function (){var statearr_39423 = state_39392;
(statearr_39423[(15)] = inst_39343__$1);

return statearr_39423;
})();
if(cljs.core.truth_(inst_39343__$1)){
var statearr_39424_39462 = state_39392__$1;
(statearr_39424_39462[(1)] = (11));

} else {
var statearr_39425_39463 = state_39392__$1;
(statearr_39425_39463[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (5))){
var _ = (function (){var statearr_39426 = state_39392;
(statearr_39426[(4)] = cljs.core.rest((state_39392[(4)])));

return statearr_39426;
})();
var state_39392__$1 = state_39392;
var ex39421 = (state_39392__$1[(2)]);
var statearr_39427_39464 = state_39392__$1;
(statearr_39427_39464[(5)] = ex39421);


if((ex39421 instanceof Error)){
var statearr_39428_39465 = state_39392__$1;
(statearr_39428_39465[(1)] = (4));

(statearr_39428_39465[(5)] = null);

} else {
throw ex39421;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (14))){
var inst_39332 = (state_39392[(8)]);
var state_39392__$1 = state_39392;
var statearr_39429_39466 = state_39392__$1;
(statearr_39429_39466[(2)] = inst_39332);

(statearr_39429_39466[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (26))){
var inst_39332 = (state_39392[(8)]);
var inst_39364 = (state_39392[(19)]);
var inst_39339 = (state_39392[(9)]);
var inst_39375 = (state_39392[(2)]);
var inst_39376 = fluree.db.util.async.throw_err(inst_39375);
var inst_39377 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39332,inst_39376);
var inst_39330 = inst_39339;
var inst_39331 = inst_39364;
var inst_39332__$1 = inst_39377;
var state_39392__$1 = (function (){var statearr_39430 = state_39392;
(statearr_39430[(7)] = inst_39331);

(statearr_39430[(8)] = inst_39332__$1);

(statearr_39430[(10)] = inst_39330);

return statearr_39430;
})();
var statearr_39431_39467 = state_39392__$1;
(statearr_39431_39467[(2)] = null);

(statearr_39431_39467[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (16))){
var inst_39385 = (state_39392[(2)]);
var state_39392__$1 = state_39392;
var statearr_39432_39468 = state_39392__$1;
(statearr_39432_39468[(2)] = inst_39385);

(statearr_39432_39468[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (10))){
var inst_39350 = (state_39392[(2)]);
var state_39392__$1 = state_39392;
if(cljs.core.truth_(inst_39350)){
var statearr_39433_39469 = state_39392__$1;
(statearr_39433_39469[(1)] = (14));

} else {
var statearr_39434_39470 = state_39392__$1;
(statearr_39434_39470[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (18))){
var inst_39353 = (state_39392[(12)]);
var state_39392__$1 = state_39392;
var statearr_39435_39471 = state_39392__$1;
(statearr_39435_39471[(2)] = inst_39353);

(statearr_39435_39471[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39393 === (8))){
var inst_39340 = (state_39392[(13)]);
var state_39392__$1 = state_39392;
var statearr_39436_39472 = state_39392__$1;
(statearr_39436_39472[(2)] = inst_39340);

(statearr_39436_39472[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16153__auto__ = null;
var fluree$db$query$fql$state_machine__16153__auto____0 = (function (){
var statearr_39437 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39437[(0)] = fluree$db$query$fql$state_machine__16153__auto__);

(statearr_39437[(1)] = (1));

return statearr_39437;
});
var fluree$db$query$fql$state_machine__16153__auto____1 = (function (state_39392){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_39392);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e39438){var ex__16156__auto__ = e39438;
var statearr_39439_39473 = state_39392;
(statearr_39439_39473[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_39392[(4)]))){
var statearr_39440_39474 = state_39392;
(statearr_39440_39474[(1)] = cljs.core.first((state_39392[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__39475 = state_39392;
state_39392 = G__39475;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16153__auto__ = function(state_39392){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16153__auto____1.call(this,state_39392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16153__auto____0;
fluree$db$query$fql$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16153__auto____1;
return fluree$db$query$fql$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_39441 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_39441[(6)] = c__16227__auto__);

return statearr_39441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4223__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__39477 = arguments.length;
switch (G__39477) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_39668){
var state_val_39669 = (state_39668[(1)]);
if((state_val_39669 === (7))){
var state_39668__$1 = state_39668;
var statearr_39670_39745 = state_39668__$1;
(statearr_39670_39745[(2)] = null);

(statearr_39670_39745[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (20))){
var inst_39520 = (state_39668[(7)]);
var inst_39518 = (state_39668[(8)]);
var inst_39548 = (state_39668[(2)]);
var inst_39549 = fluree.db.util.async.throw_err(inst_39548);
var inst_39550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39551 = [inst_39518];
var inst_39552 = (new cljs.core.PersistentVector(null,1,(5),inst_39550,inst_39551,null));
var inst_39553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39554 = [inst_39518,inst_39520];
var inst_39555 = (new cljs.core.PersistentVector(null,2,(5),inst_39553,inst_39554,null));
var inst_39556 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_39552,cljs.core._LT_,inst_39555);
var state_39668__$1 = (function (){var statearr_39671 = state_39668;
(statearr_39671[(9)] = inst_39549);

return statearr_39671;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39668__$1,(21),inst_39556);
} else {
if((state_val_39669 === (27))){
var inst_39537 = (state_39668[(10)]);
var inst_39519 = (state_39668[(11)]);
var inst_39585 = (inst_39537.cljs$core$IFn$_invoke$arity$2 ? inst_39537.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_39519) : inst_39537.call(null,cljs.core._GT__EQ_,inst_39519));
var state_39668__$1 = state_39668;
if(cljs.core.truth_(inst_39585)){
var statearr_39672_39746 = state_39668__$1;
(statearr_39672_39746[(1)] = (30));

} else {
var statearr_39673_39747 = state_39668__$1;
(statearr_39673_39747[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (1))){
var state_39668__$1 = state_39668;
var statearr_39674_39748 = state_39668__$1;
(statearr_39674_39748[(2)] = null);

(statearr_39674_39748[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (24))){
var inst_39634 = (state_39668[(2)]);
var state_39668__$1 = state_39668;
var statearr_39675_39749 = state_39668__$1;
(statearr_39675_39749[(2)] = inst_39634);

(statearr_39675_39749[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (39))){
var inst_39624 = null;
var state_39668__$1 = state_39668;
var statearr_39676_39750 = state_39668__$1;
(statearr_39676_39750[(2)] = inst_39624);

(statearr_39676_39750[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (46))){
var inst_39646 = (state_39668[(12)]);
var state_39668__$1 = state_39668;
var statearr_39677_39751 = state_39668__$1;
(statearr_39677_39751[(2)] = inst_39646);

(statearr_39677_39751[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (4))){
var inst_39478 = (state_39668[(2)]);
var state_39668__$1 = state_39668;
var statearr_39678_39752 = state_39668__$1;
(statearr_39678_39752[(2)] = inst_39478);

(statearr_39678_39752[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (15))){
var state_39668__$1 = state_39668;
var statearr_39679_39753 = state_39668__$1;
(statearr_39679_39753[(2)] = null);

(statearr_39679_39753[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (48))){
var inst_39645 = (state_39668[(13)]);
var state_39668__$1 = state_39668;
var statearr_39680_39754 = state_39668__$1;
(statearr_39680_39754[(2)] = inst_39645);

(statearr_39680_39754[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (50))){
var inst_39656 = (state_39668[(2)]);
var state_39668__$1 = state_39668;
var statearr_39681_39755 = state_39668__$1;
(statearr_39681_39755[(2)] = inst_39656);

(statearr_39681_39755[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (21))){
var inst_39549 = (state_39668[(9)]);
var inst_39558 = (state_39668[(2)]);
var inst_39559 = fluree.db.util.async.throw_err(inst_39558);
var inst_39560 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39549,inst_39559);
var state_39668__$1 = state_39668;
var statearr_39682_39756 = state_39668__$1;
(statearr_39682_39756[(2)] = inst_39560);

(statearr_39682_39756[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (31))){
var inst_39537 = (state_39668[(10)]);
var inst_39519 = (state_39668[(11)]);
var inst_39598 = (inst_39537.cljs$core$IFn$_invoke$arity$2 ? inst_39537.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_39519) : inst_39537.call(null,cljs.core._LT_,inst_39519));
var state_39668__$1 = state_39668;
if(cljs.core.truth_(inst_39598)){
var statearr_39683_39757 = state_39668__$1;
(statearr_39683_39757[(1)] = (34));

} else {
var statearr_39684_39758 = state_39668__$1;
(statearr_39684_39758[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (32))){
var inst_39630 = (state_39668[(2)]);
var state_39668__$1 = state_39668;
var statearr_39685_39759 = state_39668__$1;
(statearr_39685_39759[(2)] = inst_39630);

(statearr_39685_39759[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (40))){
var inst_39626 = (state_39668[(2)]);
var state_39668__$1 = state_39668;
var statearr_39686_39760 = state_39668__$1;
(statearr_39686_39760[(2)] = inst_39626);

(statearr_39686_39760[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (33))){
var inst_39595 = (state_39668[(2)]);
var inst_39596 = fluree.db.util.async.throw_err(inst_39595);
var state_39668__$1 = state_39668;
var statearr_39687_39761 = state_39668__$1;
(statearr_39687_39761[(2)] = inst_39596);

(statearr_39687_39761[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (13))){
var inst_39658 = (state_39668[(2)]);
var state_39668__$1 = state_39668;
var statearr_39688_39762 = state_39668__$1;
(statearr_39688_39762[(2)] = inst_39658);

(statearr_39688_39762[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (22))){
var inst_39520 = (state_39668[(7)]);
var inst_39518 = (state_39668[(8)]);
var inst_39564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39565 = [inst_39518,inst_39520];
var inst_39566 = (new cljs.core.PersistentVector(null,2,(5),inst_39564,inst_39565,null));
var inst_39567 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_39566);
var state_39668__$1 = state_39668;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39668__$1,(25),inst_39567);
} else {
if((state_val_39669 === (36))){
var inst_39628 = (state_39668[(2)]);
var state_39668__$1 = state_39668;
var statearr_39689_39763 = state_39668__$1;
(statearr_39689_39763[(2)] = inst_39628);

(statearr_39689_39763[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (41))){
var inst_39621 = (state_39668[(2)]);
var inst_39622 = fluree.db.util.async.throw_err(inst_39621);
var state_39668__$1 = state_39668;
var statearr_39690_39764 = state_39668__$1;
(statearr_39690_39764[(2)] = inst_39622);

(statearr_39690_39764[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (43))){
var inst_39637 = (state_39668[(14)]);
var inst_39504 = (state_39668[(15)]);
var inst_39638 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39504,inst_39637);
var state_39668__$1 = state_39668;
var statearr_39691_39765 = state_39668__$1;
(statearr_39691_39765[(2)] = inst_39638);

(statearr_39691_39765[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (29))){
var inst_39582 = (state_39668[(2)]);
var inst_39583 = fluree.db.util.async.throw_err(inst_39582);
var state_39668__$1 = state_39668;
var statearr_39692_39766 = state_39668__$1;
(statearr_39692_39766[(2)] = inst_39583);

(statearr_39692_39766[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (44))){
var inst_39637 = (state_39668[(14)]);
var inst_39504 = (state_39668[(15)]);
var inst_39640 = cljs.core.PersistentHashSet.EMPTY;
var inst_39641 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39640,inst_39637);
var inst_39642 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_39504,inst_39641);
var state_39668__$1 = state_39668;
var statearr_39693_39767 = state_39668__$1;
(statearr_39693_39767[(2)] = inst_39642);

(statearr_39693_39767[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (6))){
var inst_39489 = (state_39668[(16)]);
var inst_39499 = cljs.core.seq(inst_39489);
var inst_39500 = cljs.core.first(inst_39499);
var inst_39501 = cljs.core.next(inst_39499);
var inst_39502 = cljs.core.PersistentHashSet.EMPTY;
var inst_39503 = inst_39489;
var inst_39504 = inst_39502;
var state_39668__$1 = (function (){var statearr_39694 = state_39668;
(statearr_39694[(17)] = inst_39501);

(statearr_39694[(15)] = inst_39504);

(statearr_39694[(18)] = inst_39503);

(statearr_39694[(19)] = inst_39500);

return statearr_39694;
})();
var statearr_39695_39768 = state_39668__$1;
(statearr_39695_39768[(2)] = null);

(statearr_39695_39768[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (28))){
var inst_39632 = (state_39668[(2)]);
var state_39668__$1 = state_39668;
var statearr_39696_39769 = state_39668__$1;
(statearr_39696_39769[(2)] = inst_39632);

(statearr_39696_39769[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (25))){
var inst_39569 = (state_39668[(2)]);
var inst_39570 = fluree.db.util.async.throw_err(inst_39569);
var state_39668__$1 = state_39668;
var statearr_39697_39770 = state_39668__$1;
(statearr_39697_39770[(2)] = inst_39570);

(statearr_39697_39770[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (34))){
var inst_39520 = (state_39668[(7)]);
var inst_39518 = (state_39668[(8)]);
var inst_39600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39601 = [inst_39518];
var inst_39602 = (new cljs.core.PersistentVector(null,1,(5),inst_39600,inst_39601,null));
var inst_39603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39604 = [inst_39518,inst_39520];
var inst_39605 = (new cljs.core.PersistentVector(null,2,(5),inst_39603,inst_39604,null));
var inst_39606 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_39602,cljs.core._LT_,inst_39605);
var state_39668__$1 = state_39668;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39668__$1,(37),inst_39606);
} else {
if((state_val_39669 === (17))){
var inst_39520 = (state_39668[(7)]);
var inst_39518 = (state_39668[(8)]);
var inst_39540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39541 = [inst_39518,inst_39520];
var inst_39542 = (new cljs.core.PersistentVector(null,2,(5),inst_39540,inst_39541,null));
var inst_39543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39544 = [inst_39518];
var inst_39545 = (new cljs.core.PersistentVector(null,1,(5),inst_39543,inst_39544,null));
var inst_39546 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_39542,cljs.core._LT__EQ_,inst_39545);
var state_39668__$1 = state_39668;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39668__$1,(20),inst_39546);
} else {
if((state_val_39669 === (3))){
var inst_39666 = (state_39668[(2)]);
var state_39668__$1 = state_39668;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39668__$1,inst_39666);
} else {
if((state_val_39669 === (12))){
var inst_39510 = (state_39668[(20)]);
var inst_39518 = (state_39668[(8)]);
var inst_39518__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39510,(0),null);
var inst_39519 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39510,(1),null);
var inst_39520 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39510,(2),null);
var inst_39521 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_39518__$1);
var inst_39522 = cljs.core.not(inst_39521);
var state_39668__$1 = (function (){var statearr_39698 = state_39668;
(statearr_39698[(7)] = inst_39520);

(statearr_39698[(11)] = inst_39519);

(statearr_39698[(8)] = inst_39518__$1);

return statearr_39698;
})();
if(inst_39522){
var statearr_39699_39771 = state_39668__$1;
(statearr_39699_39771[(1)] = (14));

} else {
var statearr_39700_39772 = state_39668__$1;
(statearr_39700_39772[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (2))){
var inst_39489 = (state_39668[(16)]);
var _ = (function (){var statearr_39701 = state_39668;
(statearr_39701[(4)] = cljs.core.cons((5),(state_39668[(4)])));

return statearr_39701;
})();
var inst_39487 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_39488 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39487,(0),null);
var inst_39489__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39487,(1),null);
var inst_39490 = cljs.core.not_empty(inst_39489__$1);
var state_39668__$1 = (function (){var statearr_39702 = state_39668;
(statearr_39702[(21)] = inst_39488);

(statearr_39702[(16)] = inst_39489__$1);

return statearr_39702;
})();
if(cljs.core.truth_(inst_39490)){
var statearr_39703_39773 = state_39668__$1;
(statearr_39703_39773[(1)] = (6));

} else {
var statearr_39704_39774 = state_39668__$1;
(statearr_39704_39774[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (23))){
var inst_39537 = (state_39668[(10)]);
var inst_39519 = (state_39668[(11)]);
var inst_39572 = (inst_39537.cljs$core$IFn$_invoke$arity$2 ? inst_39537.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_39519) : inst_39537.call(null,cljs.core._GT_,inst_39519));
var state_39668__$1 = state_39668;
if(cljs.core.truth_(inst_39572)){
var statearr_39705_39775 = state_39668__$1;
(statearr_39705_39775[(1)] = (26));

} else {
var statearr_39706_39776 = state_39668__$1;
(statearr_39706_39776[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (47))){
var inst_39651 = (state_39668[(2)]);
var state_39668__$1 = state_39668;
if(cljs.core.truth_(inst_39651)){
var statearr_39707_39777 = state_39668__$1;
(statearr_39707_39777[(1)] = (48));

} else {
var statearr_39708_39778 = state_39668__$1;
(statearr_39708_39778[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (35))){
var inst_39537 = (state_39668[(10)]);
var inst_39519 = (state_39668[(11)]);
var inst_39611 = (inst_39537.cljs$core$IFn$_invoke$arity$2 ? inst_39537.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_39519) : inst_39537.call(null,cljs.core._LT__EQ_,inst_39519));
var state_39668__$1 = state_39668;
if(cljs.core.truth_(inst_39611)){
var statearr_39709_39779 = state_39668__$1;
(statearr_39709_39779[(1)] = (38));

} else {
var statearr_39710_39780 = state_39668__$1;
(statearr_39710_39780[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (19))){
var inst_39488 = (state_39668[(21)]);
var inst_39636 = (state_39668[(2)]);
var inst_39637 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_39636);
var state_39668__$1 = (function (){var statearr_39711 = state_39668;
(statearr_39711[(14)] = inst_39637);

return statearr_39711;
})();
var G__39712_39781 = inst_39488;
var G__39712_39782__$1 = (((G__39712_39781 instanceof cljs.core.Keyword))?G__39712_39781.fqn:null);
switch (G__39712_39782__$1) {
case "or":
var statearr_39713_39784 = state_39668__$1;
(statearr_39713_39784[(1)] = (43));


break;
case "and":
var statearr_39714_39785 = state_39668__$1;
(statearr_39714_39785[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39712_39782__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (11))){
var inst_39504 = (state_39668[(15)]);
var state_39668__$1 = state_39668;
var statearr_39716_39786 = state_39668__$1;
(statearr_39716_39786[(2)] = inst_39504);

(statearr_39716_39786[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (9))){
var inst_39510 = (state_39668[(20)]);
var inst_39503 = (state_39668[(18)]);
var inst_39509 = cljs.core.seq(inst_39503);
var inst_39510__$1 = cljs.core.first(inst_39509);
var inst_39511 = cljs.core.next(inst_39509);
var inst_39512 = cljs.core.not(inst_39510__$1);
var state_39668__$1 = (function (){var statearr_39717 = state_39668;
(statearr_39717[(20)] = inst_39510__$1);

(statearr_39717[(22)] = inst_39511);

return statearr_39717;
})();
if(inst_39512){
var statearr_39718_39787 = state_39668__$1;
(statearr_39718_39787[(1)] = (11));

} else {
var statearr_39719_39788 = state_39668__$1;
(statearr_39719_39788[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (5))){
var _ = (function (){var statearr_39720 = state_39668;
(statearr_39720[(4)] = cljs.core.rest((state_39668[(4)])));

return statearr_39720;
})();
var state_39668__$1 = state_39668;
var ex39715 = (state_39668__$1[(2)]);
var statearr_39721_39789 = state_39668__$1;
(statearr_39721_39789[(5)] = ex39715);


if((ex39715 instanceof Error)){
var statearr_39722_39790 = state_39668__$1;
(statearr_39722_39790[(1)] = (4));

(statearr_39722_39790[(5)] = null);

} else {
throw ex39715;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (14))){
var inst_39518 = (state_39668[(8)]);
var inst_39524 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_39518);
var inst_39525 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39524)].join('');
var inst_39526 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39527 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_39528 = cljs.core.PersistentHashMap.fromArrays(inst_39526,inst_39527);
var inst_39529 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39525,inst_39528);
var inst_39530 = (function(){throw inst_39529})();
var state_39668__$1 = state_39668;
var statearr_39723_39791 = state_39668__$1;
(statearr_39723_39791[(2)] = inst_39530);

(statearr_39723_39791[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (45))){
var inst_39645 = (state_39668[(13)]);
var inst_39648 = cljs.core.empty_QMARK_(inst_39645);
var state_39668__$1 = state_39668;
var statearr_39724_39792 = state_39668__$1;
(statearr_39724_39792[(2)] = inst_39648);

(statearr_39724_39792[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (26))){
var inst_39520 = (state_39668[(7)]);
var inst_39518 = (state_39668[(8)]);
var inst_39574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39575 = [inst_39518,inst_39520];
var inst_39576 = (new cljs.core.PersistentVector(null,2,(5),inst_39574,inst_39575,null));
var inst_39577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39578 = [inst_39518];
var inst_39579 = (new cljs.core.PersistentVector(null,1,(5),inst_39577,inst_39578,null));
var inst_39580 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_39576,cljs.core._LT__EQ_,inst_39579);
var state_39668__$1 = state_39668;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39668__$1,(29),inst_39580);
} else {
if((state_val_39669 === (16))){
var inst_39537 = (state_39668[(10)]);
var inst_39519 = (state_39668[(11)]);
var inst_39533 = (state_39668[(2)]);
var inst_39537__$1 = cljs.core.identical_QMARK_;
var inst_39538 = (inst_39537__$1.cljs$core$IFn$_invoke$arity$2 ? inst_39537__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_39519) : inst_39537__$1.call(null,cljs.core.not_EQ_,inst_39519));
var state_39668__$1 = (function (){var statearr_39725 = state_39668;
(statearr_39725[(23)] = inst_39533);

(statearr_39725[(10)] = inst_39537__$1);

return statearr_39725;
})();
if(cljs.core.truth_(inst_39538)){
var statearr_39726_39793 = state_39668__$1;
(statearr_39726_39793[(1)] = (17));

} else {
var statearr_39727_39794 = state_39668__$1;
(statearr_39727_39794[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (38))){
var inst_39520 = (state_39668[(7)]);
var inst_39518 = (state_39668[(8)]);
var inst_39613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39614 = [inst_39518];
var inst_39615 = (new cljs.core.PersistentVector(null,1,(5),inst_39613,inst_39614,null));
var inst_39616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39617 = [inst_39518,inst_39520];
var inst_39618 = (new cljs.core.PersistentVector(null,2,(5),inst_39616,inst_39617,null));
var inst_39619 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_39615,cljs.core._LT__EQ_,inst_39618);
var state_39668__$1 = state_39668;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39668__$1,(41),inst_39619);
} else {
if((state_val_39669 === (30))){
var inst_39520 = (state_39668[(7)]);
var inst_39518 = (state_39668[(8)]);
var inst_39587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39588 = [inst_39518,inst_39520];
var inst_39589 = (new cljs.core.PersistentVector(null,2,(5),inst_39587,inst_39588,null));
var inst_39590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39591 = [inst_39518];
var inst_39592 = (new cljs.core.PersistentVector(null,1,(5),inst_39590,inst_39591,null));
var inst_39593 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_39589,cljs.core._LT__EQ_,inst_39592);
var state_39668__$1 = state_39668;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39668__$1,(33),inst_39593);
} else {
if((state_val_39669 === (10))){
var inst_39660 = (state_39668[(2)]);
var state_39668__$1 = state_39668;
var statearr_39728_39795 = state_39668__$1;
(statearr_39728_39795[(2)] = inst_39660);

(statearr_39728_39795[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (18))){
var inst_39537 = (state_39668[(10)]);
var inst_39519 = (state_39668[(11)]);
var inst_39562 = (inst_39537.cljs$core$IFn$_invoke$arity$2 ? inst_39537.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_39519) : inst_39537.call(null,cljs.core._EQ_,inst_39519));
var state_39668__$1 = state_39668;
if(cljs.core.truth_(inst_39562)){
var statearr_39729_39796 = state_39668__$1;
(statearr_39729_39796[(1)] = (22));

} else {
var statearr_39730_39797 = state_39668__$1;
(statearr_39730_39797[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (42))){
var inst_39488 = (state_39668[(21)]);
var inst_39646 = (state_39668[(12)]);
var inst_39645 = (state_39668[(2)]);
var inst_39646__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_39488);
var state_39668__$1 = (function (){var statearr_39731 = state_39668;
(statearr_39731[(13)] = inst_39645);

(statearr_39731[(12)] = inst_39646__$1);

return statearr_39731;
})();
if(inst_39646__$1){
var statearr_39732_39798 = state_39668__$1;
(statearr_39732_39798[(1)] = (45));

} else {
var statearr_39733_39799 = state_39668__$1;
(statearr_39733_39799[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (37))){
var inst_39608 = (state_39668[(2)]);
var inst_39609 = fluree.db.util.async.throw_err(inst_39608);
var state_39668__$1 = state_39668;
var statearr_39734_39800 = state_39668__$1;
(statearr_39734_39800[(2)] = inst_39609);

(statearr_39734_39800[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (8))){
var inst_39663 = (state_39668[(2)]);
var _ = (function (){var statearr_39735 = state_39668;
(statearr_39735[(4)] = cljs.core.rest((state_39668[(4)])));

return statearr_39735;
})();
var state_39668__$1 = state_39668;
var statearr_39736_39801 = state_39668__$1;
(statearr_39736_39801[(2)] = inst_39663);

(statearr_39736_39801[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39669 === (49))){
var inst_39645 = (state_39668[(13)]);
var inst_39511 = (state_39668[(22)]);
var inst_39503 = inst_39511;
var inst_39504 = inst_39645;
var state_39668__$1 = (function (){var statearr_39737 = state_39668;
(statearr_39737[(15)] = inst_39504);

(statearr_39737[(18)] = inst_39503);

return statearr_39737;
})();
var statearr_39738_39802 = state_39668__$1;
(statearr_39738_39802[(2)] = null);

(statearr_39738_39802[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16153__auto__ = null;
var fluree$db$query$fql$state_machine__16153__auto____0 = (function (){
var statearr_39739 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39739[(0)] = fluree$db$query$fql$state_machine__16153__auto__);

(statearr_39739[(1)] = (1));

return statearr_39739;
});
var fluree$db$query$fql$state_machine__16153__auto____1 = (function (state_39668){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_39668);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e39740){var ex__16156__auto__ = e39740;
var statearr_39741_39803 = state_39668;
(statearr_39741_39803[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_39668[(4)]))){
var statearr_39742_39804 = state_39668;
(statearr_39742_39804[(1)] = cljs.core.first((state_39668[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__39805 = state_39668;
state_39668 = G__39805;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16153__auto__ = function(state_39668){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16153__auto____1.call(this,state_39668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16153__auto____0;
fluree$db$query$fql$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16153__auto____1;
return fluree$db$query$fql$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_39743 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_39743[(6)] = c__16227__auto__);

return statearr_39743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4223__auto__ = cljs.core.every_QMARK_((function (p1__39806_SHARP_){
return ((typeof p1__39806_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__39806_SHARP_)));
}),select_smt);
if(or__4223__auto__){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__39807_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__39807_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__39811 = vars;
var vec__39812 = G__39811;
var seq__39813 = cljs.core.seq(vec__39812);
var first__39814 = cljs.core.first(seq__39813);
var seq__39813__$1 = cljs.core.next(seq__39813);
var var$ = first__39814;
var r = seq__39813__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__39811__$1 = G__39811;
var all_vars__$1 = all_vars;
while(true){
var vec__39819 = G__39811__$1;
var seq__39820 = cljs.core.seq(vec__39819);
var first__39821 = cljs.core.first(seq__39820);
var seq__39820__$1 = cljs.core.next(seq__39820);
var var$__$1 = first__39821;
var r__$1 = seq__39820__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__39822 = cljs.core.set(all_vars__$2);
return (fexpr__39822.cljs$core$IFn$_invoke$arity$1 ? fexpr__39822.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__39822.call(null,var$__$1));
})())){
var G__39823 = r__$1;
var G__39824 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__39811__$1 = G__39823;
all_vars__$1 = G__39824;
continue;
} else {
var G__39825 = r__$1;
var G__39826 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__39811__$1 = G__39825;
all_vars__$1 = G__39826;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_39861){
var state_val_39862 = (state_39861[(1)]);
if((state_val_39862 === (1))){
var inst_39834 = functionArray;
var inst_39835 = cljs.core.seq(inst_39834);
var inst_39836 = cljs.core.first(inst_39835);
var inst_39837 = cljs.core.next(inst_39835);
var inst_39838 = cljs.core.PersistentVector.EMPTY;
var inst_39839 = inst_39834;
var inst_39840 = inst_39838;
var state_39861__$1 = (function (){var statearr_39863 = state_39861;
(statearr_39863[(7)] = inst_39840);

(statearr_39863[(8)] = inst_39836);

(statearr_39863[(9)] = inst_39839);

(statearr_39863[(10)] = inst_39837);

return statearr_39863;
})();
var statearr_39864_39877 = state_39861__$1;
(statearr_39864_39877[(2)] = null);

(statearr_39864_39877[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39862 === (2))){
var inst_39846 = (state_39861[(11)]);
var inst_39839 = (state_39861[(9)]);
var inst_39845 = cljs.core.seq(inst_39839);
var inst_39846__$1 = cljs.core.first(inst_39845);
var inst_39847 = cljs.core.next(inst_39845);
var state_39861__$1 = (function (){var statearr_39865 = state_39861;
(statearr_39865[(12)] = inst_39847);

(statearr_39865[(11)] = inst_39846__$1);

return statearr_39865;
})();
if(cljs.core.truth_(inst_39846__$1)){
var statearr_39866_39878 = state_39861__$1;
(statearr_39866_39878[(1)] = (4));

} else {
var statearr_39867_39879 = state_39861__$1;
(statearr_39867_39879[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39862 === (3))){
var inst_39859 = (state_39861[(2)]);
var state_39861__$1 = state_39861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39861__$1,inst_39859);
} else {
if((state_val_39862 === (4))){
var inst_39846 = (state_39861[(11)]);
var inst_39849 = (inst_39846.cljs$core$IFn$_invoke$arity$1 ? inst_39846.cljs$core$IFn$_invoke$arity$1(tuple) : inst_39846.call(null,tuple));
var state_39861__$1 = state_39861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39861__$1,(7),inst_39849);
} else {
if((state_val_39862 === (5))){
var inst_39840 = (state_39861[(7)]);
var state_39861__$1 = state_39861;
var statearr_39868_39880 = state_39861__$1;
(statearr_39868_39880[(2)] = inst_39840);

(statearr_39868_39880[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39862 === (6))){
var inst_39857 = (state_39861[(2)]);
var state_39861__$1 = state_39861;
var statearr_39869_39881 = state_39861__$1;
(statearr_39869_39881[(2)] = inst_39857);

(statearr_39869_39881[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39862 === (7))){
var inst_39847 = (state_39861[(12)]);
var inst_39840 = (state_39861[(7)]);
var inst_39851 = (state_39861[(2)]);
var inst_39852 = fluree.db.util.async.throw_err(inst_39851);
var inst_39853 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39840,inst_39852);
var inst_39839 = inst_39847;
var inst_39840__$1 = inst_39853;
var state_39861__$1 = (function (){var statearr_39870 = state_39861;
(statearr_39870[(7)] = inst_39840__$1);

(statearr_39870[(9)] = inst_39839);

return statearr_39870;
})();
var statearr_39871_39882 = state_39861__$1;
(statearr_39871_39882[(2)] = null);

(statearr_39871_39882[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__16153__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__16153__auto____0 = (function (){
var statearr_39872 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39872[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__16153__auto__);

(statearr_39872[(1)] = (1));

return statearr_39872;
});
var fluree$db$query$fql$format_tuple_$_state_machine__16153__auto____1 = (function (state_39861){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_39861);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e39873){var ex__16156__auto__ = e39873;
var statearr_39874_39883 = state_39861;
(statearr_39874_39883[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_39861[(4)]))){
var statearr_39875_39884 = state_39861;
(statearr_39875_39884[(1)] = cljs.core.first((state_39861[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__39885 = state_39861;
state_39861 = G__39885;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__16153__auto__ = function(state_39861){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__16153__auto____1.call(this,state_39861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__16153__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__16153__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_39876 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_39876[(6)] = c__16227__auto__);

return statearr_39876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__39886){
var vec__39887 = p__39886;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39887,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39887,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_39901){
var state_val_39902 = (state_39901[(1)]);
if((state_val_39902 === (1))){
var inst_39890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39891 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_39892 = [query_map,_id,query_opts];
var inst_39893 = cljs.core.PersistentHashMap.fromArrays(inst_39891,inst_39892);
var inst_39894 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_39893) : fluree.db.query.fql.query.call(null,db,inst_39893));
var state_39901__$1 = (function (){var statearr_39903 = state_39901;
(statearr_39903[(7)] = inst_39890);

return statearr_39903;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39901__$1,(2),inst_39894);
} else {
if((state_val_39902 === (2))){
var inst_39890 = (state_39901[(7)]);
var inst_39896 = (state_39901[(2)]);
var inst_39897 = fluree.db.util.async.throw_err(inst_39896);
var inst_39898 = [tuple_index,inst_39897];
var inst_39899 = (new cljs.core.PersistentVector(null,2,(5),inst_39890,inst_39898,null));
var state_39901__$1 = state_39901;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39901__$1,inst_39899);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__16153__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__16153__auto____0 = (function (){
var statearr_39904 = [null,null,null,null,null,null,null,null];
(statearr_39904[(0)] = fluree$db$query$fql$expand_map_$_state_machine__16153__auto__);

(statearr_39904[(1)] = (1));

return statearr_39904;
});
var fluree$db$query$fql$expand_map_$_state_machine__16153__auto____1 = (function (state_39901){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_39901);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e39905){var ex__16156__auto__ = e39905;
var statearr_39906_39909 = state_39901;
(statearr_39906_39909[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_39901[(4)]))){
var statearr_39907_39910 = state_39901;
(statearr_39907_39910[(1)] = cljs.core.first((state_39901[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__39911 = state_39901;
state_39901 = G__39911;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__16153__auto__ = function(state_39901){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__16153__auto____1.call(this,state_39901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__16153__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__16153__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_39908 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_39908[(6)] = c__16227__auto__);

return statearr_39908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__39912 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39912,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39912,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_39977){
var state_val_39978 = (state_39977[(1)]);
if((state_val_39978 === (7))){
var inst_39972 = (state_39977[(2)]);
var _ = (function (){var statearr_39979 = state_39977;
(statearr_39979[(4)] = cljs.core.rest((state_39977[(4)])));

return statearr_39979;
})();
var state_39977__$1 = state_39977;
var statearr_39980_40071 = state_39977__$1;
(statearr_39980_40071[(2)] = inst_39972);

(statearr_39980_40071[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (20))){
var inst_39963 = (state_39977[(2)]);
var state_39977__$1 = state_39977;
var statearr_39981_40072 = state_39977__$1;
(statearr_39981_40072[(2)] = inst_39963);

(statearr_39981_40072[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (1))){
var state_39977__$1 = state_39977;
var statearr_39982_40073 = state_39977__$1;
(statearr_39982_40073[(2)] = null);

(statearr_39982_40073[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (4))){
var inst_39917 = (state_39977[(2)]);
var state_39977__$1 = state_39977;
var statearr_39983_40074 = state_39977__$1;
(statearr_39983_40074[(2)] = inst_39917);

(statearr_39983_40074[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (15))){
var inst_39937 = (state_39977[(7)]);
var inst_39946 = cljs.core._deref(fuel);
var inst_39947 = cljs.core.second(inst_39937);
var inst_39948 = (inst_39946 + inst_39947);
var inst_39949 = cljs.core._vreset_BANG_(fuel,inst_39948);
var inst_39950 = (inst_39949 > max_fuel);
var state_39977__$1 = state_39977;
if(cljs.core.truth_(inst_39950)){
var statearr_39984_40075 = state_39977__$1;
(statearr_39984_40075[(1)] = (18));

} else {
var statearr_39985_40076 = state_39977__$1;
(statearr_39985_40076[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (13))){
var state_39977__$1 = state_39977;
var statearr_39986_40077 = state_39977__$1;
(statearr_39986_40077[(1)] = (15));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (6))){
var inst_39925 = (state_39977[(8)]);
var state_39977__$1 = state_39977;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39977__$1,(8),inst_39925);
} else {
if((state_val_39978 === (17))){
var inst_39966 = (state_39977[(2)]);
var state_39977__$1 = state_39977;
var statearr_39988_40078 = state_39977__$1;
(statearr_39988_40078[(2)] = inst_39966);

(statearr_39988_40078[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (3))){
var inst_39975 = (state_39977[(2)]);
var state_39977__$1 = state_39977;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39977__$1,inst_39975);
} else {
if((state_val_39978 === (12))){
var inst_39937 = (state_39977[(7)]);
var inst_39926 = (state_39977[(9)]);
var inst_39943 = (inst_39926.cljs$core$IFn$_invoke$arity$0 ? inst_39926.cljs$core$IFn$_invoke$arity$0() : inst_39926.call(null));
var state_39977__$1 = (function (){var statearr_39989 = state_39977;
(statearr_39989[(10)] = inst_39943);

return statearr_39989;
})();
var statearr_39990_40079 = state_39977__$1;
(statearr_39990_40079[(2)] = inst_39937);

(statearr_39990_40079[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (2))){
var inst_39925 = (state_39977[(8)]);
var inst_39926 = (state_39977[(9)]);
var _ = (function (){var statearr_39991 = state_39977;
(statearr_39991[(4)] = cljs.core.cons((5),(state_39977[(4)])));

return statearr_39991;
})();
var inst_39923 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_39924 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_39925__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_39926__$1 = (function (){var expandMaps = inst_39923;
var queue_ch = inst_39924;
var res_ch = inst_39925__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_39927 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_39928 = cljs.core.volatile_BANG_((0));
var inst_39929 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39927,cljs.core.cst$kw$fuel,inst_39928);
var inst_39930 = (function (){var expandMaps = inst_39923;
var queue_ch = inst_39924;
var res_ch = inst_39925__$1;
var stop_BANG_ = inst_39926__$1;
var opts_STAR_ = inst_39929;
return (function (tuple_res,port){
var c__16227__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_40024){
var state_val_40025 = (state_40024[(1)]);
if((state_val_40025 === (7))){
var state_40024__$1 = state_40024;
var statearr_40026_40080 = state_40024__$1;
(statearr_40026_40080[(2)] = tuple_res);

(statearr_40026_40080[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40025 === (1))){
var state_40024__$1 = state_40024;
var statearr_40027_40081 = state_40024__$1;
(statearr_40027_40081[(2)] = null);

(statearr_40027_40081[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40025 === (4))){
var inst_39992 = (state_40024[(2)]);
var inst_39993 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_39992);
var inst_39994 = cljs.core.async.close_BANG_(port);
var state_40024__$1 = (function (){var statearr_40028 = state_40024;
(statearr_40028[(7)] = inst_39993);

return statearr_40028;
})();
var statearr_40029_40082 = state_40024__$1;
(statearr_40029_40082[(2)] = inst_39994);

(statearr_40029_40082[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40025 === (6))){
var inst_40001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40002 = [tuple_res];
var inst_40003 = (new cljs.core.PersistentVector(null,1,(5),inst_40001,inst_40002,null));
var state_40024__$1 = state_40024;
var statearr_40030_40083 = state_40024__$1;
(statearr_40030_40083[(2)] = inst_40003);

(statearr_40030_40083[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40025 === (3))){
var inst_40022 = (state_40024[(2)]);
var state_40024__$1 = state_40024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40024__$1,inst_40022);
} else {
if((state_val_40025 === (2))){
var ___$1 = (function (){var statearr_40032 = state_40024;
(statearr_40032[(4)] = cljs.core.cons((5),(state_40024[(4)])));

return statearr_40032;
})();
var state_40024__$1 = state_40024;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_40033_40084 = state_40024__$1;
(statearr_40033_40084[(1)] = (6));

} else {
var statearr_40034_40085 = state_40024__$1;
(statearr_40034_40085[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40025 === (9))){
var inst_40006 = (state_40024[(8)]);
var inst_40008 = (state_40024[(9)]);
var inst_40015 = (state_40024[(2)]);
var inst_40016 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_40006,inst_40015);
var inst_40017 = (inst_40008.cljs$core$IFn$_invoke$arity$1 ? inst_40008.cljs$core$IFn$_invoke$arity$1(inst_40016) : inst_40008.call(null,inst_40016));
var inst_40018 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_40017);
var inst_40019 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_40035 = state_40024;
(statearr_40035[(4)] = cljs.core.rest((state_40024[(4)])));

return statearr_40035;
})();
var state_40024__$1 = (function (){var statearr_40036 = state_40024;
(statearr_40036[(10)] = inst_40018);

return statearr_40036;
})();
var statearr_40037_40086 = state_40024__$1;
(statearr_40037_40086[(2)] = inst_40019);

(statearr_40037_40086[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40025 === (5))){
var ___$1 = (function (){var statearr_40038 = state_40024;
(statearr_40038[(4)] = cljs.core.rest((state_40024[(4)])));

return statearr_40038;
})();
var state_40024__$1 = state_40024;
var ex40031 = (state_40024__$1[(2)]);
var statearr_40039_40087 = state_40024__$1;
(statearr_40039_40087[(5)] = ex40031);


var statearr_40040_40088 = state_40024__$1;
(statearr_40040_40088[(1)] = (4));

(statearr_40040_40088[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40025 === (8))){
var inst_40006 = (state_40024[(8)]);
var inst_40006__$1 = (state_40024[(2)]);
var inst_40007 = cljs.core.volatile_BANG_((0));
var inst_40008 = (function (){var tuple_res_SINGLEQUOTE_ = inst_40006__$1;
var query_fuel = inst_40007;
return (function (p1__39916_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__39916_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__39916_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_40009 = cljs.core.PersistentVector.EMPTY;
var inst_40010 = (function (){var tuple_res_SINGLEQUOTE_ = inst_40006__$1;
var query_fuel = inst_40007;
return (function (p1__39915_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,cljs.core.cst$kw$fuel,fuel),tuple_res_SINGLEQUOTE_,p1__39915_SHARP_);
});
})();
var inst_40011 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_40010,expandMaps);
var inst_40012 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_40011);
var inst_40013 = cljs.core.async.into(inst_40009,inst_40012);
var state_40024__$1 = (function (){var statearr_40041 = state_40024;
(statearr_40041[(8)] = inst_40006__$1);

(statearr_40041[(9)] = inst_40008);

return statearr_40041;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40024__$1,(9),inst_40013);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto____0 = (function (){
var statearr_40042 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40042[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto__);

(statearr_40042[(1)] = (1));

return statearr_40042;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto____1 = (function (state_40024){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_40024);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e40043){var ex__16156__auto__ = e40043;
var statearr_40044_40089 = state_40024;
(statearr_40044_40089[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_40024[(4)]))){
var statearr_40045_40090 = state_40024;
(statearr_40045_40090[(1)] = cljs.core.first((state_40024[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__40091 = state_40024;
state_40024 = G__40091;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto__ = function(state_40024){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto____1.call(this,state_40024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_40046 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_40046[(6)] = c__16227__auto____$1);

return statearr_40046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto____$1;
});
})();
var inst_39931 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_39924,tuples_res);
var inst_39932 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_39925__$1,inst_39930,inst_39924);
var inst_39933 = cljs.core.PersistentVector.EMPTY;
var inst_39934 = inst_39933;
var state_39977__$1 = (function (){var statearr_40047 = state_39977;
(statearr_40047[(11)] = inst_39934);

(statearr_40047[(12)] = inst_39931);

(statearr_40047[(8)] = inst_39925__$1);

(statearr_40047[(13)] = inst_39932);

(statearr_40047[(9)] = inst_39926__$1);

return statearr_40047;
})();
var statearr_40048_40092 = state_39977__$1;
(statearr_40048_40092[(2)] = null);

(statearr_40048_40092[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (19))){
var inst_39934 = (state_39977[(11)]);
var inst_39937 = (state_39977[(7)]);
var inst_39959 = cljs.core.first(inst_39937);
var inst_39960 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39934,inst_39959);
var inst_39934__$1 = inst_39960;
var state_39977__$1 = (function (){var statearr_40049 = state_39977;
(statearr_40049[(11)] = inst_39934__$1);

return statearr_40049;
})();
var statearr_40050_40093 = state_39977__$1;
(statearr_40050_40093[(2)] = null);

(statearr_40050_40093[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (11))){
var inst_39970 = (state_39977[(2)]);
var state_39977__$1 = state_39977;
var statearr_40052_40094 = state_39977__$1;
(statearr_40052_40094[(2)] = inst_39970);

(statearr_40052_40094[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (9))){
var inst_39934 = (state_39977[(11)]);
var state_39977__$1 = state_39977;
var statearr_40053_40095 = state_39977__$1;
(statearr_40053_40095[(2)] = inst_39934);

(statearr_40053_40095[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (5))){
var _ = (function (){var statearr_40054 = state_39977;
(statearr_40054[(4)] = cljs.core.rest((state_39977[(4)])));

return statearr_40054;
})();
var state_39977__$1 = state_39977;
var ex40051 = (state_39977__$1[(2)]);
var statearr_40055_40096 = state_39977__$1;
(statearr_40055_40096[(5)] = ex40051);


if((ex40051 instanceof Error)){
var statearr_40056_40097 = state_39977__$1;
(statearr_40056_40097[(1)] = (4));

(statearr_40056_40097[(5)] = null);

} else {
throw ex40051;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (14))){
var inst_39968 = (state_39977[(2)]);
var state_39977__$1 = state_39977;
var statearr_40057_40098 = state_39977__$1;
(statearr_40057_40098[(2)] = inst_39968);

(statearr_40057_40098[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (16))){
var state_39977__$1 = state_39977;
var statearr_40058_40099 = state_39977__$1;
(statearr_40058_40099[(2)] = null);

(statearr_40058_40099[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (10))){
var inst_39937 = (state_39977[(7)]);
var inst_39941 = fluree.db.util.core.exception_QMARK_(inst_39937);
var state_39977__$1 = state_39977;
if(inst_39941){
var statearr_40059_40100 = state_39977__$1;
(statearr_40059_40100[(1)] = (12));

} else {
var statearr_40060_40101 = state_39977__$1;
(statearr_40060_40101[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (18))){
var inst_39926 = (state_39977[(9)]);
var inst_39952 = (inst_39926.cljs$core$IFn$_invoke$arity$0 ? inst_39926.cljs$core$IFn$_invoke$arity$0() : inst_39926.call(null));
var inst_39953 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_39954 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_39955 = [cljs.core.cst$kw$db_SLASH_insufficient_DASH_fuel,(400)];
var inst_39956 = cljs.core.PersistentHashMap.fromArrays(inst_39954,inst_39955);
var inst_39957 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39953,inst_39956);
var state_39977__$1 = (function (){var statearr_40061 = state_39977;
(statearr_40061[(14)] = inst_39952);

return statearr_40061;
})();
var statearr_40062_40102 = state_39977__$1;
(statearr_40062_40102[(2)] = inst_39957);

(statearr_40062_40102[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39978 === (8))){
var inst_39937 = (state_39977[(7)]);
var inst_39937__$1 = (state_39977[(2)]);
var inst_39938 = (inst_39937__$1 == null);
var state_39977__$1 = (function (){var statearr_40063 = state_39977;
(statearr_40063[(7)] = inst_39937__$1);

return statearr_40063;
})();
if(cljs.core.truth_(inst_39938)){
var statearr_40064_40103 = state_39977__$1;
(statearr_40064_40103[(1)] = (9));

} else {
var statearr_40065_40104 = state_39977__$1;
(statearr_40065_40104[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto____0 = (function (){
var statearr_40066 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40066[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto__);

(statearr_40066[(1)] = (1));

return statearr_40066;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto____1 = (function (state_39977){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_39977);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e40067){var ex__16156__auto__ = e40067;
var statearr_40068_40105 = state_39977;
(statearr_40068_40105[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_39977[(4)]))){
var statearr_40069_40106 = state_39977;
(statearr_40069_40106[(1)] = cljs.core.first((state_39977[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__40107 = state_39977;
state_39977 = G__40107;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto__ = function(state_39977){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto____1.call(this,state_39977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_40070 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_40070[(6)] = c__16227__auto__);

return statearr_40070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__40108 = select;
var map__40108__$1 = cljs.core.__destructure_map(map__40108);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40108__$1,cljs.core.cst$kw$as);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40108__$1,cljs.core.cst$kw$variable);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40108__$1,cljs.core.cst$kw$value);
var select_val = (function (){var or__4223__auto__ = as;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__40111 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40111,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40111,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40111,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__40109_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__40109_SHARP_,compare_idx));
}):(function (p1__40110_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__40110_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples))));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__40116 = arguments.length;
switch (G__40116) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__40117,p__40118,group_limit,opts){
var map__40119 = p__40117;
var map__40119__$1 = cljs.core.__destructure_map(map__40119);
var res = map__40119__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40119__$1,cljs.core.cst$kw$vars);
var map__40120 = p__40118;
var map__40120__$1 = cljs.core.__destructure_map(map__40120);
var select_spec = map__40120__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40120__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40120__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40120__$1,cljs.core.cst$kw$orderBy);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40120__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40120__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40120__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40120__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40120__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40120__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40120__$1,cljs.core.cst$kw$groupBy);
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_40257){
var state_val_40258 = (state_40257[(1)]);
if((state_val_40258 === (7))){
var inst_40127 = (state_40257[(7)]);
var state_40257__$1 = state_40257;
var statearr_40259_40361 = state_40257__$1;
(statearr_40259_40361[(2)] = inst_40127);

(statearr_40259_40361[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (59))){
var inst_40250 = (state_40257[(2)]);
var state_40257__$1 = state_40257;
var statearr_40260_40362 = state_40257__$1;
(statearr_40260_40362[(2)] = inst_40250);

(statearr_40260_40362[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (20))){
var inst_40163 = (state_40257[(8)]);
var inst_40166 = (state_40257[(9)]);
var inst_40162 = (state_40257[(2)]);
var inst_40163__$1 = cljs.core.__destructure_map(inst_40162);
var inst_40164 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40163__$1,cljs.core.cst$kw$headers);
var inst_40165 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40163__$1,cljs.core.cst$kw$tuples);
var inst_40166__$1 = offset;
var state_40257__$1 = (function (){var statearr_40261 = state_40257;
(statearr_40261[(10)] = inst_40164);

(statearr_40261[(11)] = inst_40165);

(statearr_40261[(8)] = inst_40163__$1);

(statearr_40261[(9)] = inst_40166__$1);

return statearr_40261;
})();
if(cljs.core.truth_(inst_40166__$1)){
var statearr_40262_40363 = state_40257__$1;
(statearr_40262_40363[(1)] = (21));

} else {
var statearr_40263_40364 = state_40257__$1;
(statearr_40263_40364[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (58))){
var inst_40242 = (state_40257[(12)]);
var state_40257__$1 = state_40257;
var statearr_40264_40365 = state_40257__$1;
(statearr_40264_40365[(2)] = inst_40242);

(statearr_40264_40365[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (60))){
var inst_40246 = (state_40257[(2)]);
var inst_40247 = fluree.db.util.async.throw_err(inst_40246);
var state_40257__$1 = state_40257;
var statearr_40265_40366 = state_40257__$1;
(statearr_40265_40366[(2)] = inst_40247);

(statearr_40265_40366[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (27))){
var inst_40178 = cljs.core.not(inVector_QMARK_);
var state_40257__$1 = state_40257;
var statearr_40266_40367 = state_40257__$1;
(statearr_40266_40367[(2)] = inst_40178);

(statearr_40266_40367[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (1))){
var state_40257__$1 = state_40257;
var statearr_40267_40368 = state_40257__$1;
(statearr_40267_40368[(2)] = null);

(statearr_40267_40368[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (24))){
var state_40257__$1 = state_40257;
var statearr_40268_40369 = state_40257__$1;
(statearr_40268_40369[(2)] = offset);

(statearr_40268_40369[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (55))){
var inst_40236 = (state_40257[(13)]);
var state_40257__$1 = state_40257;
var statearr_40269_40370 = state_40257__$1;
(statearr_40269_40370[(2)] = inst_40236);

(statearr_40269_40370[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (39))){
var inst_40204 = (state_40257[(14)]);
var inst_40206 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_40207 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40204,inst_40206);
var state_40257__$1 = state_40257;
var statearr_40270_40371 = state_40257__$1;
(statearr_40270_40371[(2)] = inst_40207);

(statearr_40270_40371[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (46))){
var inst_40216 = (state_40257[(15)]);
var state_40257__$1 = state_40257;
var statearr_40271_40372 = state_40257__$1;
(statearr_40271_40372[(2)] = inst_40216);

(statearr_40271_40372[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (4))){
var inst_40121 = (state_40257[(2)]);
var state_40257__$1 = state_40257;
var statearr_40272_40373 = state_40257__$1;
(statearr_40272_40373[(2)] = inst_40121);

(statearr_40272_40373[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (54))){
var inst_40230 = (state_40257[(16)]);
var inst_40236 = (state_40257[(13)]);
var inst_40238 = cljs.core.PersistentVector.EMPTY;
var inst_40239 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_40238,inst_40230,inst_40236);
var state_40257__$1 = state_40257;
var statearr_40273_40374 = state_40257__$1;
(statearr_40273_40374[(2)] = inst_40239);

(statearr_40273_40374[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (15))){
var inst_40148 = (state_40257[(17)]);
var inst_40150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40151 = [inst_40148];
var inst_40152 = (new cljs.core.PersistentVector(null,1,(5),inst_40150,inst_40151,null));
var state_40257__$1 = state_40257;
var statearr_40274_40375 = state_40257__$1;
(statearr_40274_40375[(2)] = inst_40152);

(statearr_40274_40375[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (48))){
var inst_40181 = (state_40257[(18)]);
var inst_40175 = (state_40257[(19)]);
var inst_40164 = (state_40257[(10)]);
var inst_40186 = (state_40257[(20)]);
var inst_40222 = (state_40257[(21)]);
var inst_40165 = (state_40257[(11)]);
var inst_40163 = (state_40257[(8)]);
var inst_40224 = (function (){var map__40157 = inst_40163;
var headers = inst_40164;
var tuples = inst_40165;
var offset_SINGLEQUOTE_ = inst_40175;
var single_result_QMARK_ = inst_40181;
var pp_keys = inst_40186;
var G__40187 = inst_40222;
return (function (p1__40114_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__40114_SHARP_);
});
})();
var inst_40225 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_40224);
var inst_40226 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40222,inst_40225);
var state_40257__$1 = state_40257;
var statearr_40275_40376 = state_40257__$1;
(statearr_40275_40376[(2)] = inst_40226);

(statearr_40275_40376[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (50))){
var inst_40229 = (state_40257[(2)]);
var inst_40230 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_40229);
var state_40257__$1 = (function (){var statearr_40276 = state_40257;
(statearr_40276[(16)] = inst_40230);

return statearr_40276;
})();
if(cljs.core.truth_(orderBy)){
var statearr_40277_40377 = state_40257__$1;
(statearr_40277_40377[(1)] = (51));

} else {
var statearr_40278_40378 = state_40257__$1;
(statearr_40278_40378[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (21))){
var inst_40168 = cljs.core.not(groupBy);
var state_40257__$1 = state_40257;
var statearr_40279_40379 = state_40257__$1;
(statearr_40279_40379[(2)] = inst_40168);

(statearr_40279_40379[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (31))){
var state_40257__$1 = state_40257;
var statearr_40280_40380 = state_40257__$1;
(statearr_40280_40380[(2)] = null);

(statearr_40280_40380[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (32))){
var inst_40181 = (state_40257[(18)]);
var inst_40164 = (state_40257[(10)]);
var inst_40186 = (state_40257[(2)]);
var inst_40188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40189 = fluree.db.query.fql.select_tuples_fn(inst_40164,vars,select);
var inst_40190 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_40189);
var inst_40191 = [inst_40190];
var inst_40192 = (new cljs.core.PersistentVector(null,1,(5),inst_40188,inst_40191,null));
var state_40257__$1 = (function (){var statearr_40281 = state_40257;
(statearr_40281[(22)] = inst_40192);

(statearr_40281[(20)] = inst_40186);

return statearr_40281;
})();
if(cljs.core.truth_(inst_40181)){
var statearr_40282_40381 = state_40257__$1;
(statearr_40282_40381[(1)] = (33));

} else {
var statearr_40283_40382 = state_40257__$1;
(statearr_40283_40382[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (40))){
var inst_40204 = (state_40257[(14)]);
var state_40257__$1 = state_40257;
var statearr_40284_40383 = state_40257__$1;
(statearr_40284_40383[(2)] = inst_40204);

(statearr_40284_40383[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (56))){
var inst_40242 = (state_40257[(2)]);
var state_40257__$1 = (function (){var statearr_40285 = state_40257;
(statearr_40285[(12)] = inst_40242);

return statearr_40285;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_40286_40384 = state_40257__$1;
(statearr_40286_40384[(1)] = (57));

} else {
var statearr_40287_40385 = state_40257__$1;
(statearr_40287_40385[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (33))){
var inst_40192 = (state_40257[(22)]);
var inst_40194 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_40195 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40192,inst_40194);
var state_40257__$1 = state_40257;
var statearr_40288_40386 = state_40257__$1;
(statearr_40288_40386[(2)] = inst_40195);

(statearr_40288_40386[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (13))){
var inst_40137 = (state_40257[(23)]);
var state_40257__$1 = state_40257;
var statearr_40289_40387 = state_40257__$1;
(statearr_40289_40387[(2)] = inst_40137);

(statearr_40289_40387[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (22))){
var inst_40166 = (state_40257[(9)]);
var state_40257__$1 = state_40257;
var statearr_40290_40388 = state_40257__$1;
(statearr_40290_40388[(2)] = inst_40166);

(statearr_40290_40388[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (36))){
var inst_40198 = (state_40257[(24)]);
var inst_40200 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_40201 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40198,inst_40200);
var state_40257__$1 = state_40257;
var statearr_40291_40389 = state_40257__$1;
(statearr_40291_40389[(2)] = inst_40201);

(statearr_40291_40389[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (41))){
var inst_40175 = (state_40257[(19)]);
var inst_40210 = (state_40257[(2)]);
var state_40257__$1 = (function (){var statearr_40292 = state_40257;
(statearr_40292[(25)] = inst_40210);

return statearr_40292;
})();
if(cljs.core.truth_(inst_40175)){
var statearr_40293_40390 = state_40257__$1;
(statearr_40293_40390[(1)] = (42));

} else {
var statearr_40294_40391 = state_40257__$1;
(statearr_40294_40391[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (43))){
var inst_40210 = (state_40257[(25)]);
var state_40257__$1 = state_40257;
var statearr_40295_40392 = state_40257__$1;
(statearr_40295_40392[(2)] = inst_40210);

(statearr_40295_40392[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (29))){
var inst_40181 = (state_40257[(2)]);
var state_40257__$1 = (function (){var statearr_40296 = state_40257;
(statearr_40296[(18)] = inst_40181);

return statearr_40296;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_40297_40393 = state_40257__$1;
(statearr_40297_40393[(1)] = (30));

} else {
var statearr_40298_40394 = state_40257__$1;
(statearr_40298_40394[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (44))){
var inst_40216 = (state_40257[(2)]);
var state_40257__$1 = (function (){var statearr_40299 = state_40257;
(statearr_40299[(15)] = inst_40216);

return statearr_40299;
})();
if(cljs.core.truth_(group_limit)){
var statearr_40300_40395 = state_40257__$1;
(statearr_40300_40395[(1)] = (45));

} else {
var statearr_40301_40396 = state_40257__$1;
(statearr_40301_40396[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (6))){
var inst_40129 = cljs.core.count(select);
var inst_40130 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_40129);
var state_40257__$1 = state_40257;
var statearr_40302_40397 = state_40257__$1;
(statearr_40302_40397[(2)] = inst_40130);

(statearr_40302_40397[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (28))){
var inst_40176 = (state_40257[(26)]);
var state_40257__$1 = state_40257;
var statearr_40303_40398 = state_40257__$1;
(statearr_40303_40398[(2)] = inst_40176);

(statearr_40303_40398[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (51))){
var inst_40164 = (state_40257[(10)]);
var inst_40165 = (state_40257[(11)]);
var inst_40233 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_40164,orderBy,inst_40165);
var state_40257__$1 = state_40257;
var statearr_40304_40399 = state_40257__$1;
(statearr_40304_40399[(2)] = inst_40233);

(statearr_40304_40399[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (25))){
var state_40257__$1 = state_40257;
var statearr_40305_40400 = state_40257__$1;
(statearr_40305_40400[(2)] = null);

(statearr_40305_40400[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (34))){
var inst_40192 = (state_40257[(22)]);
var state_40257__$1 = state_40257;
var statearr_40306_40401 = state_40257__$1;
(statearr_40306_40401[(2)] = inst_40192);

(statearr_40306_40401[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (17))){
var inst_40155 = (state_40257[(2)]);
var state_40257__$1 = state_40257;
var statearr_40307_40402 = state_40257__$1;
(statearr_40307_40402[(2)] = inst_40155);

(statearr_40307_40402[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (3))){
var inst_40255 = (state_40257[(2)]);
var state_40257__$1 = state_40257;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40257__$1,inst_40255);
} else {
if((state_val_40258 === (12))){
var inst_40137 = (state_40257[(23)]);
var inst_40139 = cljs.core.first(select);
var inst_40140 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_40139);
var inst_40141 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40140);
var inst_40142 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_40141,(1));
var inst_40143 = [inst_40142];
var inst_40144 = [inst_40137];
var inst_40145 = cljs.core.PersistentHashMap.fromArrays(inst_40143,inst_40144);
var state_40257__$1 = state_40257;
var statearr_40308_40403 = state_40257__$1;
(statearr_40308_40403[(2)] = inst_40145);

(statearr_40308_40403[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (2))){
var inst_40127 = (state_40257[(7)]);
var _ = (function (){var statearr_40309 = state_40257;
(statearr_40309[(4)] = cljs.core.cons((5),(state_40257[(4)])));

return statearr_40309;
})();
var inst_40127__$1 = aggregates;
var state_40257__$1 = (function (){var statearr_40310 = state_40257;
(statearr_40310[(7)] = inst_40127__$1);

return statearr_40310;
})();
if(cljs.core.truth_(inst_40127__$1)){
var statearr_40311_40404 = state_40257__$1;
(statearr_40311_40404[(1)] = (6));

} else {
var statearr_40312_40405 = state_40257__$1;
(statearr_40312_40405[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (23))){
var inst_40171 = (state_40257[(2)]);
var state_40257__$1 = state_40257;
if(cljs.core.truth_(inst_40171)){
var statearr_40313_40406 = state_40257__$1;
(statearr_40313_40406[(1)] = (24));

} else {
var statearr_40314_40407 = state_40257__$1;
(statearr_40314_40407[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (47))){
var inst_40222 = (state_40257[(2)]);
var state_40257__$1 = (function (){var statearr_40315 = state_40257;
(statearr_40315[(21)] = inst_40222);

return statearr_40315;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_40316_40408 = state_40257__$1;
(statearr_40316_40408[(1)] = (48));

} else {
var statearr_40317_40409 = state_40257__$1;
(statearr_40317_40409[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (35))){
var inst_40198 = (state_40257[(2)]);
var state_40257__$1 = (function (){var statearr_40318 = state_40257;
(statearr_40318[(24)] = inst_40198);

return statearr_40318;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40319_40410 = state_40257__$1;
(statearr_40319_40410[(1)] = (36));

} else {
var statearr_40320_40411 = state_40257__$1;
(statearr_40320_40411[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (19))){
var state_40257__$1 = state_40257;
var statearr_40321_40412 = state_40257__$1;
(statearr_40321_40412[(2)] = res);

(statearr_40321_40412[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (57))){
var inst_40181 = (state_40257[(18)]);
var inst_40186 = (state_40257[(20)]);
var inst_40242 = (state_40257[(12)]);
var inst_40244 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_40186,inst_40181,db,fuel,max_fuel,opts,(8),inst_40242);
var state_40257__$1 = state_40257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40257__$1,(60),inst_40244);
} else {
if((state_val_40258 === (11))){
var inst_40252 = (state_40257[(2)]);
var _ = (function (){var statearr_40323 = state_40257;
(statearr_40323[(4)] = cljs.core.rest((state_40257[(4)])));

return statearr_40323;
})();
var state_40257__$1 = state_40257;
var statearr_40324_40413 = state_40257__$1;
(statearr_40324_40413[(2)] = inst_40252);

(statearr_40324_40413[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (9))){
var inst_40135 = cljs.core.first(aggregates);
var inst_40136 = fluree.db.query.analytical.calculate_aggregate(res,inst_40135);
var inst_40137 = cljs.core.second(inst_40136);
var state_40257__$1 = (function (){var statearr_40325 = state_40257;
(statearr_40325[(23)] = inst_40137);

return statearr_40325;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_40326_40414 = state_40257__$1;
(statearr_40326_40414[(1)] = (12));

} else {
var statearr_40327_40415 = state_40257__$1;
(statearr_40327_40415[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (5))){
var _ = (function (){var statearr_40328 = state_40257;
(statearr_40328[(4)] = cljs.core.rest((state_40257[(4)])));

return statearr_40328;
})();
var state_40257__$1 = state_40257;
var ex40322 = (state_40257__$1[(2)]);
var statearr_40329_40416 = state_40257__$1;
(statearr_40329_40416[(5)] = ex40322);


if((ex40322 instanceof Error)){
var statearr_40330_40417 = state_40257__$1;
(statearr_40330_40417[(1)] = (4));

(statearr_40330_40417[(5)] = null);

} else {
throw ex40322;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (14))){
var inst_40148 = (state_40257[(2)]);
var state_40257__$1 = (function (){var statearr_40331 = state_40257;
(statearr_40331[(17)] = inst_40148);

return statearr_40331;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_40332_40418 = state_40257__$1;
(statearr_40332_40418[(1)] = (15));

} else {
var statearr_40333_40419 = state_40257__$1;
(statearr_40333_40419[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (45))){
var inst_40216 = (state_40257[(15)]);
var inst_40218 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_40219 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40216,inst_40218);
var state_40257__$1 = state_40257;
var statearr_40334_40420 = state_40257__$1;
(statearr_40334_40420[(2)] = inst_40219);

(statearr_40334_40420[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (53))){
var inst_40236 = (state_40257[(2)]);
var state_40257__$1 = (function (){var statearr_40335 = state_40257;
(statearr_40335[(13)] = inst_40236);

return statearr_40335;
})();
var statearr_40336_40421 = state_40257__$1;
(statearr_40336_40421[(1)] = (54));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (26))){
var inst_40176 = (state_40257[(26)]);
var inst_40175 = (state_40257[(2)]);
var inst_40176__$1 = cljs.core.not(prettyPrint);
var state_40257__$1 = (function (){var statearr_40338 = state_40257;
(statearr_40338[(19)] = inst_40175);

(statearr_40338[(26)] = inst_40176__$1);

return statearr_40338;
})();
if(inst_40176__$1){
var statearr_40339_40422 = state_40257__$1;
(statearr_40339_40422[(1)] = (27));

} else {
var statearr_40340_40423 = state_40257__$1;
(statearr_40340_40423[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (16))){
var inst_40148 = (state_40257[(17)]);
var state_40257__$1 = state_40257;
var statearr_40341_40424 = state_40257__$1;
(statearr_40341_40424[(2)] = inst_40148);

(statearr_40341_40424[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (38))){
var inst_40204 = (state_40257[(2)]);
var state_40257__$1 = (function (){var statearr_40342 = state_40257;
(statearr_40342[(14)] = inst_40204);

return statearr_40342;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40343_40425 = state_40257__$1;
(statearr_40343_40425[(1)] = (39));

} else {
var statearr_40344_40426 = state_40257__$1;
(statearr_40344_40426[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (30))){
var inst_40183 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_40257__$1 = state_40257;
var statearr_40345_40427 = state_40257__$1;
(statearr_40345_40427[(2)] = inst_40183);

(statearr_40345_40427[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (10))){
var state_40257__$1 = state_40257;
if(cljs.core.truth_(aggregates)){
var statearr_40346_40428 = state_40257__$1;
(statearr_40346_40428[(1)] = (18));

} else {
var statearr_40347_40429 = state_40257__$1;
(statearr_40347_40429[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (18))){
var inst_40159 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_40257__$1 = state_40257;
var statearr_40348_40430 = state_40257__$1;
(statearr_40348_40430[(2)] = inst_40159);

(statearr_40348_40430[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (52))){
var inst_40165 = (state_40257[(11)]);
var state_40257__$1 = state_40257;
var statearr_40349_40431 = state_40257__$1;
(statearr_40349_40431[(2)] = inst_40165);

(statearr_40349_40431[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (42))){
var inst_40175 = (state_40257[(19)]);
var inst_40210 = (state_40257[(25)]);
var inst_40212 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_40175);
var inst_40213 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40210,inst_40212);
var state_40257__$1 = state_40257;
var statearr_40350_40432 = state_40257__$1;
(statearr_40350_40432[(2)] = inst_40213);

(statearr_40350_40432[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (37))){
var inst_40198 = (state_40257[(24)]);
var state_40257__$1 = state_40257;
var statearr_40351_40433 = state_40257__$1;
(statearr_40351_40433[(2)] = inst_40198);

(statearr_40351_40433[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (8))){
var inst_40133 = (state_40257[(2)]);
var state_40257__$1 = state_40257;
if(cljs.core.truth_(inst_40133)){
var statearr_40352_40434 = state_40257__$1;
(statearr_40352_40434[(1)] = (9));

} else {
var statearr_40353_40435 = state_40257__$1;
(statearr_40353_40435[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40258 === (49))){
var inst_40222 = (state_40257[(21)]);
var state_40257__$1 = state_40257;
var statearr_40354_40436 = state_40257__$1;
(statearr_40354_40436[(2)] = inst_40222);

(statearr_40354_40436[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16153__auto__ = null;
var fluree$db$query$fql$state_machine__16153__auto____0 = (function (){
var statearr_40355 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40355[(0)] = fluree$db$query$fql$state_machine__16153__auto__);

(statearr_40355[(1)] = (1));

return statearr_40355;
});
var fluree$db$query$fql$state_machine__16153__auto____1 = (function (state_40257){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_40257);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e40356){var ex__16156__auto__ = e40356;
var statearr_40357_40437 = state_40257;
(statearr_40357_40437[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_40257[(4)]))){
var statearr_40358_40438 = state_40257;
(statearr_40358_40438[(1)] = cljs.core.first((state_40257[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__40439 = state_40257;
state_40257 = G__40439;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16153__auto__ = function(state_40257){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16153__auto____1.call(this,state_40257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16153__auto____0;
fluree$db$query$fql$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16153__auto____1;
return fluree$db$query$fql$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_40359 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_40359[(6)] = c__16227__auto__);

return statearr_40359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__40442,groupBy){
var map__40443 = p__40442;
var map__40443__$1 = cljs.core.__destructure_map(map__40443);
var res = map__40443__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40443__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40443__$1,cljs.core.cst$kw$tuples);
var vec__40444 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40444,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40444,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40440_SHARP_){
return fluree.db.util.core.index_of(headers,p1__40440_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40441_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__40441_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__40447 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40447,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40447,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__40450,p__40451,opts){
var map__40452 = p__40450;
var map__40452__$1 = cljs.core.__destructure_map(map__40452);
var res = map__40452__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40452__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40452__$1,cljs.core.cst$kw$vars);
var map__40453 = p__40451;
var map__40453__$1 = cljs.core.__destructure_map(map__40453);
var select_spec = map__40453__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40453__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40453__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40453__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40453__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40453__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40453__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40453__$1,cljs.core.cst$kw$offset);
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_40671){
var state_val_40672 = (state_40671[(1)]);
if((state_val_40672 === (65))){
var inst_40584 = (state_40671[(7)]);
var inst_40612 = cljs.core.empty_QMARK_(inst_40584);
var state_40671__$1 = state_40671;
var statearr_40673_40806 = state_40671__$1;
(statearr_40673_40806[(2)] = inst_40612);

(statearr_40673_40806[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (70))){
var state_40671__$1 = state_40671;
var statearr_40674_40807 = state_40671__$1;
(statearr_40674_40807[(2)] = (1));

(statearr_40674_40807[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (62))){
var state_40671__$1 = state_40671;
var statearr_40675_40808 = state_40671__$1;
(statearr_40675_40808[(2)] = null);

(statearr_40675_40808[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (74))){
var state_40671__$1 = state_40671;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_40676_40809 = state_40671__$1;
(statearr_40676_40809[(1)] = (77));

} else {
var statearr_40677_40810 = state_40671__$1;
(statearr_40677_40810[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (7))){
var state_40671__$1 = state_40671;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_40678_40811 = state_40671__$1;
(statearr_40678_40811[(1)] = (70));

} else {
var statearr_40679_40812 = state_40671__$1;
(statearr_40679_40812[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (59))){
var state_40671__$1 = state_40671;
var statearr_40680_40813 = state_40671__$1;
(statearr_40680_40813[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (20))){
var state_40671__$1 = state_40671;
var statearr_40682_40814 = state_40671__$1;
(statearr_40682_40814[(2)] = (0));

(statearr_40682_40814[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (72))){
var inst_40638 = (state_40671[(2)]);
var inst_40639 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_40638,opts);
var state_40671__$1 = state_40671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40671__$1,(73),inst_40639);
} else {
if((state_val_40672 === (58))){
var inst_40522 = (state_40671[(8)]);
var inst_40596 = (inst_40522 - (1));
var state_40671__$1 = state_40671;
var statearr_40683_40815 = state_40671__$1;
(statearr_40683_40815[(2)] = inst_40596);

(statearr_40683_40815[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (60))){
var inst_40606 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
var statearr_40684_40816 = state_40671__$1;
(statearr_40684_40816[(2)] = inst_40606);

(statearr_40684_40816[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (27))){
var inst_40521 = (state_40671[(9)]);
var inst_40545 = (inst_40521 < (1));
var state_40671__$1 = state_40671;
var statearr_40685_40817 = state_40671__$1;
(statearr_40685_40817[(2)] = inst_40545);

(statearr_40685_40817[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (1))){
var state_40671__$1 = state_40671;
var statearr_40686_40818 = state_40671__$1;
(statearr_40686_40818[(2)] = null);

(statearr_40686_40818[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (69))){
var inst_40591 = (state_40671[(10)]);
var inst_40536 = (state_40671[(11)]);
var inst_40533 = (state_40671[(12)]);
var inst_40608 = (state_40671[(13)]);
var inst_40619 = (state_40671[(2)]);
var inst_40519 = inst_40533;
var inst_40520 = inst_40536;
var inst_40521 = inst_40591;
var inst_40522 = inst_40608;
var inst_40523 = inst_40619;
var state_40671__$1 = (function (){var statearr_40687 = state_40671;
(statearr_40687[(14)] = inst_40523);

(statearr_40687[(9)] = inst_40521);

(statearr_40687[(8)] = inst_40522);

(statearr_40687[(15)] = inst_40519);

(statearr_40687[(16)] = inst_40520);

return statearr_40687;
})();
var statearr_40688_40819 = state_40671__$1;
(statearr_40688_40819[(2)] = null);

(statearr_40688_40819[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (24))){
var inst_40523 = (state_40671[(14)]);
var state_40671__$1 = state_40671;
var statearr_40689_40820 = state_40671__$1;
(statearr_40689_40820[(2)] = inst_40523);

(statearr_40689_40820[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (55))){
var state_40671__$1 = state_40671;
var statearr_40690_40821 = state_40671__$1;
(statearr_40690_40821[(2)] = (0));

(statearr_40690_40821[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (85))){
var inst_40660 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
var statearr_40691_40822 = state_40671__$1;
(statearr_40691_40822[(2)] = inst_40660);

(statearr_40691_40822[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (39))){
var inst_40540 = (state_40671[(17)]);
var inst_40563 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,null], 0));
var inst_40564 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,null], 0));
var inst_40565 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_40540,inst_40563,inst_40564);
var state_40671__$1 = state_40671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40671__$1,(42),inst_40565);
} else {
if((state_val_40672 === (46))){
var inst_40521 = (state_40671[(9)]);
var inst_40576 = ((0) < inst_40521);
var state_40671__$1 = state_40671;
var statearr_40692_40823 = state_40671__$1;
(statearr_40692_40823[(2)] = inst_40576);

(statearr_40692_40823[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (4))){
var inst_40454 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
var statearr_40693_40824 = state_40671__$1;
(statearr_40693_40824[(2)] = inst_40454);

(statearr_40693_40824[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (77))){
var inst_40642 = (state_40671[(18)]);
var inst_40647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40648 = [inst_40642];
var inst_40649 = (new cljs.core.PersistentVector(null,1,(5),inst_40647,inst_40648,null));
var state_40671__$1 = state_40671;
var statearr_40694_40825 = state_40671__$1;
(statearr_40694_40825[(2)] = inst_40649);

(statearr_40694_40825[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (54))){
var inst_40522 = (state_40671[(8)]);
var inst_40591 = (state_40671[(2)]);
var inst_40592 = (inst_40522 <= (0));
var state_40671__$1 = (function (){var statearr_40695 = state_40671;
(statearr_40695[(10)] = inst_40591);

return statearr_40695;
})();
if(cljs.core.truth_(inst_40592)){
var statearr_40696_40826 = state_40671__$1;
(statearr_40696_40826[(1)] = (55));

} else {
var statearr_40697_40827 = state_40671__$1;
(statearr_40697_40827[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (15))){
var inst_40472 = (state_40671[(19)]);
var inst_40480 = (state_40671[(2)]);
var inst_40481 = fluree.db.util.async.throw_err(inst_40480);
var inst_40482 = [inst_40472];
var inst_40483 = [inst_40481];
var inst_40484 = cljs.core.PersistentHashMap.fromArrays(inst_40482,inst_40483);
var state_40671__$1 = state_40671;
var statearr_40698_40828 = state_40671__$1;
(statearr_40698_40828[(2)] = inst_40484);

(statearr_40698_40828[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (48))){
var inst_40579 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
if(cljs.core.truth_(inst_40579)){
var statearr_40699_40829 = state_40671__$1;
(statearr_40699_40829[(1)] = (49));

} else {
var statearr_40700_40830 = state_40671__$1;
(statearr_40700_40830[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (50))){
var inst_40574 = (state_40671[(20)]);
var state_40671__$1 = state_40671;
var statearr_40701_40831 = state_40671__$1;
(statearr_40701_40831[(2)] = inst_40574);

(statearr_40701_40831[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (75))){
var state_40671__$1 = state_40671;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_40702_40832 = state_40671__$1;
(statearr_40702_40832[(1)] = (80));

} else {
var statearr_40703_40833 = state_40671__$1;
(statearr_40703_40833[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (21))){
var inst_40504 = (state_40671[(21)]);
var inst_40500 = (state_40671[(22)]);
var inst_40512 = (state_40671[(23)]);
var inst_40517 = (state_40671[(2)]);
var inst_40518 = cljs.core.PersistentHashMap.EMPTY;
var inst_40519 = inst_40500;
var inst_40520 = inst_40504;
var inst_40521 = inst_40512;
var inst_40522 = inst_40517;
var inst_40523 = inst_40518;
var state_40671__$1 = (function (){var statearr_40704 = state_40671;
(statearr_40704[(14)] = inst_40523);

(statearr_40704[(9)] = inst_40521);

(statearr_40704[(8)] = inst_40522);

(statearr_40704[(15)] = inst_40519);

(statearr_40704[(16)] = inst_40520);

return statearr_40704;
})();
var statearr_40705_40834 = state_40671__$1;
(statearr_40705_40834[(2)] = null);

(statearr_40705_40834[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (31))){
var inst_40537 = (state_40671[(24)]);
var inst_40522 = (state_40671[(8)]);
var inst_40551 = (inst_40522 >= inst_40537);
var state_40671__$1 = state_40671;
if(cljs.core.truth_(inst_40551)){
var statearr_40706_40835 = state_40671__$1;
(statearr_40706_40835[(1)] = (33));

} else {
var statearr_40707_40836 = state_40671__$1;
(statearr_40707_40836[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (32))){
var inst_40627 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
var statearr_40708_40837 = state_40671__$1;
(statearr_40708_40837[(2)] = inst_40627);

(statearr_40708_40837[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (40))){
var state_40671__$1 = state_40671;
var statearr_40709_40838 = state_40671__$1;
(statearr_40709_40838[(2)] = null);

(statearr_40709_40838[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (56))){
var state_40671__$1 = state_40671;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40710_40839 = state_40671__$1;
(statearr_40710_40839[(1)] = (58));

} else {
var statearr_40711_40840 = state_40671__$1;
(statearr_40711_40840[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (33))){
var state_40671__$1 = state_40671;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40712_40841 = state_40671__$1;
(statearr_40712_40841[(1)] = (36));

} else {
var statearr_40713_40842 = state_40671__$1;
(statearr_40713_40842[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (13))){
var inst_40504 = (state_40671[(21)]);
var inst_40500 = (state_40671[(22)]);
var inst_40469 = (state_40671[(25)]);
var inst_40500__$1 = cljs.core.keys(inst_40469);
var inst_40501 = cljs.core.seq(inst_40500__$1);
var inst_40502 = cljs.core.first(inst_40501);
var inst_40503 = cljs.core.next(inst_40501);
var inst_40504__$1 = cljs.core.vals(inst_40469);
var inst_40505 = cljs.core.seq(inst_40504__$1);
var inst_40506 = cljs.core.first(inst_40505);
var inst_40507 = cljs.core.next(inst_40505);
var inst_40508 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_40671__$1 = (function (){var statearr_40714 = state_40671;
(statearr_40714[(26)] = inst_40507);

(statearr_40714[(21)] = inst_40504__$1);

(statearr_40714[(22)] = inst_40500__$1);

(statearr_40714[(27)] = inst_40502);

(statearr_40714[(28)] = inst_40506);

(statearr_40714[(29)] = inst_40503);

return statearr_40714;
})();
if(inst_40508){
var statearr_40715_40843 = state_40671__$1;
(statearr_40715_40843[(1)] = (16));

} else {
var statearr_40716_40844 = state_40671__$1;
(statearr_40716_40844[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (22))){
var inst_40519 = (state_40671[(15)]);
var inst_40520 = (state_40671[(16)]);
var inst_40531 = cljs.core.seq(inst_40519);
var inst_40532 = cljs.core.first(inst_40531);
var inst_40533 = cljs.core.next(inst_40531);
var inst_40534 = cljs.core.seq(inst_40520);
var inst_40535 = cljs.core.first(inst_40534);
var inst_40536 = cljs.core.next(inst_40534);
var inst_40537 = cljs.core.count(inst_40535);
var inst_40538 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_40539 = [headers,vars,inst_40535];
var inst_40540 = cljs.core.PersistentHashMap.fromArrays(inst_40538,inst_40539);
var inst_40541 = (inst_40535 == null);
var state_40671__$1 = (function (){var statearr_40717 = state_40671;
(statearr_40717[(24)] = inst_40537);

(statearr_40717[(11)] = inst_40536);

(statearr_40717[(12)] = inst_40533);

(statearr_40717[(30)] = inst_40532);

(statearr_40717[(17)] = inst_40540);

return statearr_40717;
})();
if(cljs.core.truth_(inst_40541)){
var statearr_40718_40845 = state_40671__$1;
(statearr_40718_40845[(1)] = (24));

} else {
var statearr_40719_40846 = state_40671__$1;
(statearr_40719_40846[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (36))){
var inst_40522 = (state_40671[(8)]);
var inst_40554 = (inst_40522 - (1));
var state_40671__$1 = state_40671;
var statearr_40720_40847 = state_40671__$1;
(statearr_40720_40847[(2)] = inst_40554);

(statearr_40720_40847[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (41))){
var inst_40623 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
var statearr_40721_40848 = state_40671__$1;
(statearr_40721_40848[(2)] = inst_40623);

(statearr_40721_40848[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (43))){
var inst_40522 = (state_40671[(8)]);
var inst_40568 = (state_40671[(31)]);
var inst_40571 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_40522,inst_40568);
var state_40671__$1 = state_40671;
var statearr_40722_40849 = state_40671__$1;
(statearr_40722_40849[(2)] = inst_40571);

(statearr_40722_40849[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (61))){
var inst_40537 = (state_40671[(24)]);
var inst_40584 = (state_40671[(7)]);
var inst_40522 = (state_40671[(8)]);
var inst_40599 = cljs.core.count(inst_40584);
var inst_40600 = (inst_40537 - inst_40599);
var inst_40601 = (inst_40522 - inst_40600);
var state_40671__$1 = state_40671;
var statearr_40723_40850 = state_40671__$1;
(statearr_40723_40850[(2)] = inst_40601);

(statearr_40723_40850[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (29))){
var inst_40548 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
if(cljs.core.truth_(inst_40548)){
var statearr_40724_40851 = state_40671__$1;
(statearr_40724_40851[(1)] = (30));

} else {
var statearr_40725_40852 = state_40671__$1;
(statearr_40725_40852[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (44))){
var inst_40568 = (state_40671[(31)]);
var state_40671__$1 = state_40671;
var statearr_40726_40853 = state_40671__$1;
(statearr_40726_40853[(2)] = inst_40568);

(statearr_40726_40853[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (6))){
var inst_40461 = (state_40671[(32)]);
var inst_40461__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_40463 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_40671__$1 = (function (){var statearr_40727 = state_40671;
(statearr_40727[(32)] = inst_40461__$1);

(statearr_40727[(33)] = inst_40463);

return statearr_40727;
})();
if(cljs.core.truth_(inst_40461__$1)){
var statearr_40728_40854 = state_40671__$1;
(statearr_40728_40854[(1)] = (9));

} else {
var statearr_40729_40855 = state_40671__$1;
(statearr_40729_40855[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (28))){
var inst_40521 = (state_40671[(9)]);
var state_40671__$1 = state_40671;
var statearr_40730_40856 = state_40671__$1;
(statearr_40730_40856[(2)] = inst_40521);

(statearr_40730_40856[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (64))){
var inst_40609 = (state_40671[(34)]);
var state_40671__$1 = state_40671;
var statearr_40731_40857 = state_40671__$1;
(statearr_40731_40857[(2)] = inst_40609);

(statearr_40731_40857[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (51))){
var inst_40521 = (state_40671[(9)]);
var inst_40584 = (state_40671[(2)]);
var inst_40585 = (inst_40521 == null);
var state_40671__$1 = (function (){var statearr_40732 = state_40671;
(statearr_40732[(7)] = inst_40584);

return statearr_40732;
})();
if(cljs.core.truth_(inst_40585)){
var statearr_40733_40858 = state_40671__$1;
(statearr_40733_40858[(1)] = (52));

} else {
var statearr_40734_40859 = state_40671__$1;
(statearr_40734_40859[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (25))){
var inst_40521 = (state_40671[(9)]);
var state_40671__$1 = state_40671;
if(cljs.core.truth_(inst_40521)){
var statearr_40735_40860 = state_40671__$1;
(statearr_40735_40860[(1)] = (27));

} else {
var statearr_40736_40861 = state_40671__$1;
(statearr_40736_40861[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (34))){
var state_40671__$1 = state_40671;
var statearr_40737_40862 = state_40671__$1;
(statearr_40737_40862[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (17))){
var state_40671__$1 = state_40671;
var statearr_40739_40863 = state_40671__$1;
(statearr_40739_40863[(2)] = limit);

(statearr_40739_40863[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (3))){
var inst_40669 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40671__$1,inst_40669);
} else {
if((state_val_40672 === (12))){
var inst_40469 = (state_40671[(25)]);
var inst_40471 = cljs.core.keys(inst_40469);
var inst_40472 = cljs.core.first(inst_40471);
var inst_40473 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_40474 = cljs.core.vals(inst_40469);
var inst_40475 = cljs.core.first(inst_40474);
var inst_40476 = [headers,vars,inst_40475];
var inst_40477 = cljs.core.PersistentHashMap.fromArrays(inst_40473,inst_40476);
var inst_40478 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_40477,select_spec,limit,opts);
var state_40671__$1 = (function (){var statearr_40740 = state_40671;
(statearr_40740[(19)] = inst_40472);

return statearr_40740;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40671__$1,(15),inst_40478);
} else {
if((state_val_40672 === (2))){
var _ = (function (){var statearr_40741 = state_40671;
(statearr_40741[(4)] = cljs.core.cons((5),(state_40671[(4)])));

return statearr_40741;
})();
var state_40671__$1 = state_40671;
if(cljs.core.truth_(groupBy)){
var statearr_40742_40864 = state_40671__$1;
(statearr_40742_40864[(1)] = (6));

} else {
var statearr_40743_40865 = state_40671__$1;
(statearr_40743_40865[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (66))){
var inst_40614 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
if(cljs.core.truth_(inst_40614)){
var statearr_40744_40866 = state_40671__$1;
(statearr_40744_40866[(1)] = (67));

} else {
var statearr_40745_40867 = state_40671__$1;
(statearr_40745_40867[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (23))){
var inst_40631 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
var statearr_40746_40868 = state_40671__$1;
(statearr_40746_40868[(2)] = inst_40631);

(statearr_40746_40868[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (47))){
var inst_40521 = (state_40671[(9)]);
var state_40671__$1 = state_40671;
var statearr_40747_40869 = state_40671__$1;
(statearr_40747_40869[(2)] = inst_40521);

(statearr_40747_40869[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (35))){
var inst_40625 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
var statearr_40748_40870 = state_40671__$1;
(statearr_40748_40870[(2)] = inst_40625);

(statearr_40748_40870[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (82))){
var inst_40662 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
var statearr_40749_40871 = state_40671__$1;
(statearr_40749_40871[(2)] = inst_40662);

(statearr_40749_40871[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (76))){
var inst_40664 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
var statearr_40750_40872 = state_40671__$1;
(statearr_40750_40872[(2)] = inst_40664);

(statearr_40750_40872[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (19))){
var inst_40513 = (state_40671[(35)]);
var state_40671__$1 = state_40671;
var statearr_40751_40873 = state_40671__$1;
(statearr_40751_40873[(2)] = inst_40513);

(statearr_40751_40873[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (57))){
var inst_40584 = (state_40671[(7)]);
var inst_40609 = (state_40671[(34)]);
var inst_40608 = (state_40671[(2)]);
var inst_40609__$1 = (inst_40584 == null);
var state_40671__$1 = (function (){var statearr_40752 = state_40671;
(statearr_40752[(13)] = inst_40608);

(statearr_40752[(34)] = inst_40609__$1);

return statearr_40752;
})();
if(cljs.core.truth_(inst_40609__$1)){
var statearr_40753_40874 = state_40671__$1;
(statearr_40753_40874[(1)] = (64));

} else {
var statearr_40754_40875 = state_40671__$1;
(statearr_40754_40875[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (68))){
var inst_40584 = (state_40671[(7)]);
var inst_40532 = (state_40671[(30)]);
var inst_40523 = (state_40671[(14)]);
var inst_40617 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40523,inst_40532,inst_40584);
var state_40671__$1 = state_40671;
var statearr_40755_40876 = state_40671__$1;
(statearr_40755_40876[(2)] = inst_40617);

(statearr_40755_40876[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (11))){
var inst_40469 = (state_40671[(2)]);
var state_40671__$1 = (function (){var statearr_40757 = state_40671;
(statearr_40757[(25)] = inst_40469);

return statearr_40757;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_40758_40877 = state_40671__$1;
(statearr_40758_40877[(1)] = (12));

} else {
var statearr_40759_40878 = state_40671__$1;
(statearr_40759_40878[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (9))){
var inst_40461 = (state_40671[(32)]);
var inst_40463 = (state_40671[(33)]);
var inst_40465 = cljs.core.sorted_map_by(inst_40461);
var inst_40466 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40465,inst_40463);
var state_40671__$1 = state_40671;
var statearr_40760_40879 = state_40671__$1;
(statearr_40760_40879[(2)] = inst_40466);

(statearr_40760_40879[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (5))){
var _ = (function (){var statearr_40761 = state_40671;
(statearr_40761[(4)] = cljs.core.rest((state_40671[(4)])));

return statearr_40761;
})();
var state_40671__$1 = state_40671;
var ex40756 = (state_40671__$1[(2)]);
var statearr_40762_40880 = state_40671__$1;
(statearr_40762_40880[(5)] = ex40756);


if((ex40756 instanceof Error)){
var statearr_40763_40881 = state_40671__$1;
(statearr_40763_40881[(1)] = (4));

(statearr_40763_40881[(5)] = null);

} else {
throw ex40756;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (83))){
var inst_40642 = (state_40671[(18)]);
var state_40671__$1 = state_40671;
var statearr_40764_40882 = state_40671__$1;
(statearr_40764_40882[(2)] = inst_40642);

(statearr_40764_40882[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (14))){
var inst_40633 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
var statearr_40765_40883 = state_40671__$1;
(statearr_40765_40883[(2)] = inst_40633);

(statearr_40765_40883[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (45))){
var inst_40521 = (state_40671[(9)]);
var inst_40574 = (state_40671[(2)]);
var state_40671__$1 = (function (){var statearr_40766 = state_40671;
(statearr_40766[(20)] = inst_40574);

return statearr_40766;
})();
if(cljs.core.truth_(inst_40521)){
var statearr_40767_40884 = state_40671__$1;
(statearr_40767_40884[(1)] = (46));

} else {
var statearr_40768_40885 = state_40671__$1;
(statearr_40768_40885[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (53))){
var inst_40584 = (state_40671[(7)]);
var inst_40521 = (state_40671[(9)]);
var inst_40588 = cljs.core.count(inst_40584);
var inst_40589 = (inst_40521 - inst_40588);
var state_40671__$1 = state_40671;
var statearr_40769_40886 = state_40671__$1;
(statearr_40769_40886[(2)] = inst_40589);

(statearr_40769_40886[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (78))){
var inst_40642 = (state_40671[(18)]);
var state_40671__$1 = state_40671;
var statearr_40770_40887 = state_40671__$1;
(statearr_40770_40887[(2)] = inst_40642);

(statearr_40770_40887[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (26))){
var inst_40629 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
var statearr_40771_40888 = state_40671__$1;
(statearr_40771_40888[(2)] = inst_40629);

(statearr_40771_40888[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (16))){
var state_40671__$1 = state_40671;
var statearr_40772_40889 = state_40671__$1;
(statearr_40772_40889[(2)] = null);

(statearr_40772_40889[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (81))){
var state_40671__$1 = state_40671;
var statearr_40775_40890 = state_40671__$1;
(statearr_40775_40890[(1)] = (83));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (79))){
var inst_40652 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
var statearr_40777_40891 = state_40671__$1;
(statearr_40777_40891[(2)] = inst_40652);

(statearr_40777_40891[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (38))){
var inst_40536 = (state_40671[(11)]);
var inst_40533 = (state_40671[(12)]);
var inst_40523 = (state_40671[(14)]);
var inst_40521 = (state_40671[(9)]);
var inst_40558 = (state_40671[(2)]);
var tmp40773 = inst_40523;
var tmp40774 = inst_40521;
var inst_40519 = inst_40533;
var inst_40520 = inst_40536;
var inst_40521__$1 = tmp40774;
var inst_40522 = inst_40558;
var inst_40523__$1 = tmp40773;
var state_40671__$1 = (function (){var statearr_40778 = state_40671;
(statearr_40778[(14)] = inst_40523__$1);

(statearr_40778[(9)] = inst_40521__$1);

(statearr_40778[(8)] = inst_40522);

(statearr_40778[(15)] = inst_40519);

(statearr_40778[(16)] = inst_40520);

return statearr_40778;
})();
var statearr_40779_40892 = state_40671__$1;
(statearr_40779_40892[(2)] = null);

(statearr_40779_40892[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (30))){
var inst_40523 = (state_40671[(14)]);
var state_40671__$1 = state_40671;
var statearr_40780_40893 = state_40671__$1;
(statearr_40780_40893[(2)] = inst_40523);

(statearr_40780_40893[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (73))){
var inst_40642 = (state_40671[(18)]);
var inst_40641 = (state_40671[(2)]);
var inst_40642__$1 = fluree.db.util.async.throw_err(inst_40641);
var inst_40643 = cljs.core.coll_QMARK_(inst_40642__$1);
var inst_40644 = (!(inst_40643));
var state_40671__$1 = (function (){var statearr_40781 = state_40671;
(statearr_40781[(18)] = inst_40642__$1);

return statearr_40781;
})();
if(inst_40644){
var statearr_40782_40894 = state_40671__$1;
(statearr_40782_40894[(1)] = (74));

} else {
var statearr_40783_40895 = state_40671__$1;
(statearr_40783_40895[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (10))){
var inst_40463 = (state_40671[(33)]);
var state_40671__$1 = state_40671;
var statearr_40784_40896 = state_40671__$1;
(statearr_40784_40896[(2)] = inst_40463);

(statearr_40784_40896[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (18))){
var inst_40513 = (state_40671[(35)]);
var inst_40512 = (state_40671[(2)]);
var inst_40513__$1 = offset;
var state_40671__$1 = (function (){var statearr_40785 = state_40671;
(statearr_40785[(35)] = inst_40513__$1);

(statearr_40785[(23)] = inst_40512);

return statearr_40785;
})();
if(cljs.core.truth_(inst_40513__$1)){
var statearr_40786_40897 = state_40671__$1;
(statearr_40786_40897[(1)] = (19));

} else {
var statearr_40787_40898 = state_40671__$1;
(statearr_40787_40898[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (52))){
var state_40671__$1 = state_40671;
var statearr_40788_40899 = state_40671__$1;
(statearr_40788_40899[(2)] = null);

(statearr_40788_40899[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (67))){
var inst_40523 = (state_40671[(14)]);
var state_40671__$1 = state_40671;
var statearr_40789_40900 = state_40671__$1;
(statearr_40789_40900[(2)] = inst_40523);

(statearr_40789_40900[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (71))){
var state_40671__$1 = state_40671;
var statearr_40790_40901 = state_40671__$1;
(statearr_40790_40901[(2)] = limit);

(statearr_40790_40901[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (42))){
var inst_40522 = (state_40671[(8)]);
var inst_40567 = (state_40671[(2)]);
var inst_40568 = fluree.db.util.async.throw_err(inst_40567);
var inst_40569 = ((0) < inst_40522);
var state_40671__$1 = (function (){var statearr_40791 = state_40671;
(statearr_40791[(31)] = inst_40568);

return statearr_40791;
})();
if(cljs.core.truth_(inst_40569)){
var statearr_40792_40902 = state_40671__$1;
(statearr_40792_40902[(1)] = (43));

} else {
var statearr_40793_40903 = state_40671__$1;
(statearr_40793_40903[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (80))){
var inst_40642 = (state_40671[(18)]);
var inst_40655 = cljs.core.first(inst_40642);
var state_40671__$1 = state_40671;
var statearr_40794_40904 = state_40671__$1;
(statearr_40794_40904[(2)] = inst_40655);

(statearr_40794_40904[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (37))){
var inst_40537 = (state_40671[(24)]);
var inst_40522 = (state_40671[(8)]);
var inst_40556 = (inst_40522 - inst_40537);
var state_40671__$1 = state_40671;
var statearr_40795_40905 = state_40671__$1;
(statearr_40795_40905[(2)] = inst_40556);

(statearr_40795_40905[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (63))){
var inst_40604 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
var statearr_40796_40906 = state_40671__$1;
(statearr_40796_40906[(2)] = inst_40604);

(statearr_40796_40906[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (8))){
var inst_40666 = (state_40671[(2)]);
var _ = (function (){var statearr_40797 = state_40671;
(statearr_40797[(4)] = cljs.core.rest((state_40671[(4)])));

return statearr_40797;
})();
var state_40671__$1 = state_40671;
var statearr_40798_40907 = state_40671__$1;
(statearr_40798_40907[(2)] = inst_40666);

(statearr_40798_40907[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (49))){
var inst_40521 = (state_40671[(9)]);
var inst_40574 = (state_40671[(20)]);
var inst_40581 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_40521,inst_40574);
var state_40671__$1 = state_40671;
var statearr_40799_40908 = state_40671__$1;
(statearr_40799_40908[(2)] = inst_40581);

(statearr_40799_40908[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40672 === (84))){
var state_40671__$1 = state_40671;
var statearr_40800_40909 = state_40671__$1;
(statearr_40800_40909[(2)] = null);

(statearr_40800_40909[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16153__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16153__auto____0 = (function (){
var statearr_40801 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40801[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16153__auto__);

(statearr_40801[(1)] = (1));

return statearr_40801;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16153__auto____1 = (function (state_40671){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_40671);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e40802){var ex__16156__auto__ = e40802;
var statearr_40803_40910 = state_40671;
(statearr_40803_40910[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_40671[(4)]))){
var statearr_40804_40911 = state_40671;
(statearr_40804_40911[(1)] = cljs.core.first((state_40671[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__40912 = state_40671;
state_40671 = G__40912;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16153__auto__ = function(state_40671){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16153__auto____1.call(this,state_40671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16153__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16153__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_40805 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_40805[(6)] = c__16227__auto__);

return statearr_40805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__40915,opts){
var map__40916 = p__40915;
var map__40916__$1 = cljs.core.__destructure_map(map__40916);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40916__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40916__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40916__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40916__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4223__auto__ = selectOne;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = select;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
var or__4223__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4223__auto____$2)){
return or__4223__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__40913_SHARP_){
return cljs.core.contains_QMARK_(p1__40913_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__40914_SHARP_){
return cljs.core.contains_QMARK_(p1__40914_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4223__auto__ = typeof orderBy === 'string';
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4221__auto__){
var G__40918 = cljs.core.first(orderBy);
var fexpr__40917 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__40917.cljs$core$IFn$_invoke$arity$1 ? fexpr__40917.cljs$core$IFn$_invoke$arity$1(G__40918) : fexpr__40917.call(null,G__40918));
} else {
return and__4221__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4223__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})(),(function (){var or__4223__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4223__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4223__auto__ = selectDistinct;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__40919,p__40920){
var map__40921 = p__40919;
var map__40921__$1 = cljs.core.__destructure_map(map__40921);
var query_map = map__40921__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40921__$1,cljs.core.cst$kw$construct);
var map__40922 = p__40920;
var map__40922__$1 = cljs.core.__destructure_map(map__40922);
var where_result = map__40922__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40922__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40922__$1,cljs.core.cst$kw$tuples);
var vec__40923 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40923,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40923,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40923,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_40956){
var state_val_40957 = (state_40956[(1)]);
if((state_val_40957 === (7))){
var inst_40935 = (state_40956[(7)]);
var state_40956__$1 = state_40956;
var statearr_40958_40981 = state_40956__$1;
(statearr_40958_40981[(2)] = inst_40935);

(statearr_40958_40981[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40957 === (1))){
var state_40956__$1 = state_40956;
var statearr_40959_40982 = state_40956__$1;
(statearr_40959_40982[(2)] = null);

(statearr_40959_40982[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40957 === (4))){
var inst_40926 = (state_40956[(2)]);
var state_40956__$1 = state_40956;
var statearr_40960_40983 = state_40956__$1;
(statearr_40960_40983[(2)] = inst_40926);

(statearr_40960_40983[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40957 === (13))){
var inst_40945 = (state_40956[(2)]);
var inst_40946 = fluree.db.util.async.throw_err(inst_40945);
var state_40956__$1 = state_40956;
var statearr_40961_40984 = state_40956__$1;
(statearr_40961_40984[(2)] = inst_40946);

(statearr_40961_40984[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40957 === (6))){
var inst_40935 = (state_40956[(7)]);
var inst_40934 = (state_40956[(2)]);
var inst_40935__$1 = fluree.db.util.async.throw_err(inst_40934);
var inst_40936 = fluree.db.util.core.exception_QMARK_(inst_40935__$1);
var state_40956__$1 = (function (){var statearr_40962 = state_40956;
(statearr_40962[(7)] = inst_40935__$1);

return statearr_40962;
})();
if(inst_40936){
var statearr_40963_40985 = state_40956__$1;
(statearr_40963_40985[(1)] = (7));

} else {
var statearr_40964_40986 = state_40956__$1;
(statearr_40964_40986[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40957 === (3))){
var inst_40954 = (state_40956[(2)]);
var state_40956__$1 = state_40956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40956__$1,inst_40954);
} else {
if((state_val_40957 === (12))){
var inst_40949 = (state_40956[(2)]);
var state_40956__$1 = state_40956;
var statearr_40965_40987 = state_40956__$1;
(statearr_40965_40987[(2)] = inst_40949);

(statearr_40965_40987[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40957 === (2))){
var _ = (function (){var statearr_40966 = state_40956;
(statearr_40966[(4)] = cljs.core.cons((5),(state_40956[(4)])));

return statearr_40966;
})();
var inst_40932 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_40956__$1 = state_40956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40956__$1,(6),inst_40932);
} else {
if((state_val_40957 === (11))){
var state_40956__$1 = state_40956;
var statearr_40968_40988 = state_40956__$1;
(statearr_40968_40988[(2)] = null);

(statearr_40968_40988[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40957 === (9))){
var inst_40951 = (state_40956[(2)]);
var _ = (function (){var statearr_40969 = state_40956;
(statearr_40969[(4)] = cljs.core.rest((state_40956[(4)])));

return statearr_40969;
})();
var state_40956__$1 = state_40956;
var statearr_40970_40989 = state_40956__$1;
(statearr_40970_40989[(2)] = inst_40951);

(statearr_40970_40989[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40957 === (5))){
var _ = (function (){var statearr_40971 = state_40956;
(statearr_40971[(4)] = cljs.core.rest((state_40956[(4)])));

return statearr_40971;
})();
var state_40956__$1 = state_40956;
var ex40967 = (state_40956__$1[(2)]);
var statearr_40972_40990 = state_40956__$1;
(statearr_40972_40990[(5)] = ex40967);


if((ex40967 instanceof Error)){
var statearr_40973_40991 = state_40956__$1;
(statearr_40973_40991[(1)] = (4));

(statearr_40973_40991[(5)] = null);

} else {
throw ex40967;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40957 === (10))){
var inst_40935 = (state_40956[(7)]);
var inst_40940 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_40935);
var inst_40941 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_40935);
var inst_40942 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_40940,inst_40941,query_map,opts);
var inst_40943 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_40935,inst_40942,opts);
var state_40956__$1 = state_40956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40956__$1,(13),inst_40943);
} else {
if((state_val_40957 === (8))){
var state_40956__$1 = state_40956;
var statearr_40974_40992 = state_40956__$1;
(statearr_40974_40992[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16153__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16153__auto____0 = (function (){
var statearr_40976 = [null,null,null,null,null,null,null,null];
(statearr_40976[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__16153__auto__);

(statearr_40976[(1)] = (1));

return statearr_40976;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16153__auto____1 = (function (state_40956){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_40956);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e40977){var ex__16156__auto__ = e40977;
var statearr_40978_40993 = state_40956;
(statearr_40978_40993[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_40956[(4)]))){
var statearr_40979_40994 = state_40956;
(statearr_40979_40994[(1)] = cljs.core.first((state_40956[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__40995 = state_40956;
state_40956 = G__40995;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__16153__auto__ = function(state_40956){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16153__auto____1.call(this,state_40956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16153__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16153__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_40980 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_40980[(6)] = c__16227__auto__);

return statearr_40980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__40996 = query_map;
var map__40996__$1 = cljs.core.__destructure_map(map__40996);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40996__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40996__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40996__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40996__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40996__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40996__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40996__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40996__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40996__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40996__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40996__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40996__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__40997 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4223__auto__ = offset;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__40997,cljs.core.cst$kw$limit,(1));
} else {
return G__40997;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4223__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.truth_((function (){var or__4223__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_41356){
var state_val_41357 = (state_41356[(1)]);
if((state_val_41357 === (121))){
var inst_41317 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41358_41553 = state_41356__$1;
(statearr_41358_41553[(2)] = inst_41317);

(statearr_41358_41553[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (65))){
var inst_41190 = typeof from === 'string';
var state_41356__$1 = state_41356;
if(cljs.core.truth_(inst_41190)){
var statearr_41359_41554 = state_41356__$1;
(statearr_41359_41554[(1)] = (72));

} else {
var statearr_41360_41555 = state_41356__$1;
(statearr_41360_41555[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (70))){
var inst_41061 = (state_41356[(7)]);
var inst_41059 = (state_41356[(8)]);
var inst_41183 = (state_41356[(2)]);
var inst_41184 = fluree.db.util.async.throw_err(inst_41183);
var inst_41185 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_41061,fuel,max_fuel,inst_41059,inst_41184);
var state_41356__$1 = state_41356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41356__$1,(71),inst_41185);
} else {
if((state_val_41357 === (62))){
var inst_41163 = (state_41356[(9)]);
var state_41356__$1 = state_41356;
var statearr_41361_41556 = state_41356__$1;
(statearr_41361_41556[(2)] = inst_41163);

(statearr_41361_41556[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (74))){
var inst_41323 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41362_41557 = state_41356__$1;
(statearr_41362_41557[(2)] = inst_41323);

(statearr_41362_41557[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (110))){
var inst_41256 = (state_41356[(10)]);
var state_41356__$1 = state_41356;
var statearr_41363_41558 = state_41356__$1;
(statearr_41363_41558[(2)] = inst_41256);

(statearr_41363_41558[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (130))){
var inst_41343 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41364_41559 = state_41356__$1;
(statearr_41364_41559[(2)] = inst_41343);

(statearr_41364_41559[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (128))){
var inst_41334 = (state_41356[(11)]);
var inst_41339 = fluree.db.util.core.exception_QMARK_(inst_41334);
var inst_41340 = (!(inst_41339));
var state_41356__$1 = state_41356;
var statearr_41365_41560 = state_41356__$1;
(statearr_41365_41560[(2)] = inst_41340);

(statearr_41365_41560[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (7))){
var inst_41029 = (state_41356[(12)]);
var inst_41029__$1 = selectOne;
var state_41356__$1 = (function (){var statearr_41366 = state_41356;
(statearr_41366[(12)] = inst_41029__$1);

return statearr_41366;
})();
if(cljs.core.truth_(inst_41029__$1)){
var statearr_41367_41561 = state_41356__$1;
(statearr_41367_41561[(1)] = (9));

} else {
var statearr_41368_41562 = state_41356__$1;
(statearr_41368_41562[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (59))){
var inst_41061 = (state_41356[(7)]);
var inst_41059 = (state_41356[(8)]);
var inst_41141 = (state_41356[(13)]);
var inst_41049 = (state_41356[(14)]);
var inst_41155 = (state_41356[(2)]);
var inst_41156 = fluree.db.util.async.throw_err(inst_41155);
var inst_41157 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_41141,inst_41156);
var inst_41158 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_41061,fuel,max_fuel,inst_41059,inst_41157,inst_41049);
var state_41356__$1 = state_41356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41356__$1,(60),inst_41158);
} else {
if((state_val_41357 === (86))){
var inst_41061 = (state_41356[(7)]);
var inst_41059 = (state_41356[(8)]);
var inst_41051 = (state_41356[(15)]);
var inst_41049 = (state_41356[(14)]);
var inst_41223 = (state_41356[(2)]);
var inst_41224 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_41061,fuel,max_fuel,inst_41059,inst_41223,inst_41049,inst_41051);
var state_41356__$1 = state_41356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41356__$1,(87),inst_41224);
} else {
if((state_val_41357 === (20))){
var inst_41093 = (state_41356[(2)]);
var inst_41094 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41093,(0),null);
var inst_41095 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41093,(1),null);
var inst_41096 = typeof where === 'string';
var state_41356__$1 = (function (){var statearr_41369 = state_41356;
(statearr_41369[(16)] = inst_41094);

(statearr_41369[(17)] = inst_41095);

return statearr_41369;
})();
if(cljs.core.truth_(inst_41096)){
var statearr_41370_41563 = state_41356__$1;
(statearr_41370_41563[(1)] = (30));

} else {
var statearr_41371_41564 = state_41356__$1;
(statearr_41371_41564[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (72))){
var inst_41048 = (state_41356[(18)]);
var state_41356__$1 = state_41356;
if(cljs.core.truth_(inst_41048)){
var statearr_41372_41565 = state_41356__$1;
(statearr_41372_41565[(1)] = (75));

} else {
var statearr_41373_41566 = state_41356__$1;
(statearr_41373_41566[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (58))){
var inst_41149 = (state_41356[(2)]);
var inst_41150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41151 = [from];
var inst_41152 = (new cljs.core.PersistentVector(null,1,(5),inst_41150,inst_41151,null));
var inst_41153 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_41152,inst_41149);
var state_41356__$1 = state_41356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41356__$1,(59),inst_41153);
} else {
if((state_val_41357 === (60))){
var inst_41160 = (state_41356[(2)]);
var inst_41161 = fluree.db.util.async.throw_err(inst_41160);
var state_41356__$1 = state_41356;
var statearr_41374_41567 = state_41356__$1;
(statearr_41374_41567[(2)] = inst_41161);

(statearr_41374_41567[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (27))){
var inst_41078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41079 = [null,null];
var inst_41080 = (new cljs.core.PersistentVector(null,2,(5),inst_41078,inst_41079,null));
var state_41356__$1 = state_41356;
var statearr_41375_41568 = state_41356__$1;
(statearr_41375_41568[(2)] = inst_41080);

(statearr_41375_41568[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (1))){
var state_41356__$1 = state_41356;
var statearr_41376_41569 = state_41356__$1;
(statearr_41376_41569[(2)] = null);

(statearr_41376_41569[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (69))){
var inst_41180 = (state_41356[(2)]);
var inst_41181 = fluree.db.query.range._block_or_tx_collection(db,inst_41180);
var state_41356__$1 = state_41356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41356__$1,(70),inst_41181);
} else {
if((state_val_41357 === (101))){
var inst_41290 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41377_41570 = state_41356__$1;
(statearr_41377_41570[(2)] = inst_41290);

(statearr_41377_41570[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (24))){
var inst_41048 = (state_41356[(18)]);
var inst_41073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41074 = [inst_41048,"ASC"];
var inst_41075 = (new cljs.core.PersistentVector(null,2,(5),inst_41073,inst_41074,null));
var state_41356__$1 = state_41356;
var statearr_41378_41571 = state_41356__$1;
(statearr_41378_41571[(2)] = inst_41075);

(statearr_41378_41571[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (102))){
var inst_41262 = (state_41356[(19)]);
var state_41356__$1 = state_41356;
var statearr_41379_41572 = state_41356__$1;
(statearr_41379_41572[(2)] = inst_41262);

(statearr_41379_41572[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (55))){
var inst_41048 = (state_41356[(18)]);
var inst_41141 = (state_41356[(2)]);
var state_41356__$1 = (function (){var statearr_41380 = state_41356;
(statearr_41380[(13)] = inst_41141);

return statearr_41380;
})();
if(cljs.core.truth_(inst_41048)){
var statearr_41381_41573 = state_41356__$1;
(statearr_41381_41573[(1)] = (56));

} else {
var statearr_41382_41574 = state_41356__$1;
(statearr_41382_41574[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (85))){
var inst_41215 = (state_41356[(20)]);
var inst_41219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41220 = [inst_41215];
var inst_41221 = (new cljs.core.PersistentVector(null,1,(5),inst_41219,inst_41220,null));
var state_41356__$1 = state_41356;
var statearr_41383_41575 = state_41356__$1;
(statearr_41383_41575[(2)] = inst_41221);

(statearr_41383_41575[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (39))){
var inst_41049 = (state_41356[(14)]);
var state_41356__$1 = state_41356;
var statearr_41384_41576 = state_41356__$1;
(statearr_41384_41576[(2)] = inst_41049);

(statearr_41384_41576[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (88))){
var inst_41229 = cljs.core._deref(fuel);
var inst_41230 = (inst_41229 + (1));
var inst_41231 = cljs.core._vreset_BANG_(fuel,inst_41230);
var state_41356__$1 = state_41356;
var statearr_41385_41577 = state_41356__$1;
(statearr_41385_41577[(2)] = inst_41231);

(statearr_41385_41577[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (46))){
var inst_41126 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
if(cljs.core.truth_(inst_41126)){
var statearr_41386_41578 = state_41356__$1;
(statearr_41386_41578[(1)] = (47));

} else {
var statearr_41387_41579 = state_41356__$1;
(statearr_41387_41579[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (4))){
var inst_41016 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41388_41580 = state_41356__$1;
(statearr_41388_41580[(2)] = inst_41016);

(statearr_41388_41580[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (77))){
var inst_41199 = (state_41356[(2)]);
var inst_41200 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_41199);
var state_41356__$1 = state_41356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41356__$1,(78),inst_41200);
} else {
if((state_val_41357 === (106))){
var state_41356__$1 = state_41356;
var statearr_41389_41581 = state_41356__$1;
(statearr_41389_41581[(2)] = null);

(statearr_41389_41581[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (119))){
var inst_41309 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_41310 = ["Invalid 'from' in query:",inst_41309].join('');
var inst_41311 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41312 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_41313 = cljs.core.PersistentHashMap.fromArrays(inst_41311,inst_41312);
var inst_41314 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41310,inst_41313);
var state_41356__$1 = state_41356;
var statearr_41390_41582 = state_41356__$1;
(statearr_41390_41582[(2)] = inst_41314);

(statearr_41390_41582[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (95))){
var state_41356__$1 = state_41356;
var statearr_41391_41583 = state_41356__$1;
(statearr_41391_41583[(1)] = (119));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (54))){
var inst_41135 = (state_41356[(21)]);
var state_41356__$1 = state_41356;
var statearr_41393_41584 = state_41356__$1;
(statearr_41393_41584[(2)] = inst_41135);

(statearr_41393_41584[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (92))){
var inst_41236 = (state_41356[(22)]);
var state_41356__$1 = state_41356;
var statearr_41394_41585 = state_41356__$1;
(statearr_41394_41585[(2)] = inst_41236);

(statearr_41394_41585[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (104))){
var inst_41282 = (state_41356[(23)]);
var inst_41282__$1 = (state_41356[(2)]);
var state_41356__$1 = (function (){var statearr_41395 = state_41356;
(statearr_41395[(23)] = inst_41282__$1);

return statearr_41395;
})();
if(cljs.core.truth_(inst_41282__$1)){
var statearr_41396_41586 = state_41356__$1;
(statearr_41396_41586[(1)] = (109));

} else {
var statearr_41397_41587 = state_41356__$1;
(statearr_41397_41587[(1)] = (110));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (15))){
var inst_41052 = (state_41356[(24)]);
var inst_41050 = (state_41356[(25)]);
var inst_41056 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41052,cljs.core.cst$kw$componentFollow_QMARK_,inst_41050);
var state_41356__$1 = state_41356;
var statearr_41398_41588 = state_41356__$1;
(statearr_41398_41588[(2)] = inst_41056);

(statearr_41398_41588[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (48))){
var inst_41163 = (state_41356[(9)]);
var inst_41163__$1 = typeof from === 'string';
var state_41356__$1 = (function (){var statearr_41399 = state_41356;
(statearr_41399[(9)] = inst_41163__$1);

return statearr_41399;
})();
if(cljs.core.truth_(inst_41163__$1)){
var statearr_41400_41589 = state_41356__$1;
(statearr_41400_41589[(1)] = (61));

} else {
var statearr_41401_41590 = state_41356__$1;
(statearr_41401_41590[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (50))){
var inst_41129 = (state_41356[(26)]);
var inst_41131 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_41132 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_41129,inst_41131);
var state_41356__$1 = state_41356;
var statearr_41402_41591 = state_41356__$1;
(statearr_41402_41591[(2)] = inst_41132);

(statearr_41402_41591[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (116))){
var state_41356__$1 = state_41356;
var statearr_41403_41592 = state_41356__$1;
(statearr_41403_41592[(2)] = null);

(statearr_41403_41592[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (75))){
var inst_41193 = cljs.core.PersistentHashMap.EMPTY;
var state_41356__$1 = state_41356;
var statearr_41404_41593 = state_41356__$1;
(statearr_41404_41593[(2)] = inst_41193);

(statearr_41404_41593[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (99))){
var inst_41256 = (state_41356[(10)]);
var state_41356__$1 = state_41356;
var statearr_41405_41594 = state_41356__$1;
(statearr_41405_41594[(2)] = inst_41256);

(statearr_41405_41594[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (21))){
var inst_41048 = (state_41356[(18)]);
var inst_41065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41066 = cljs.core.second(inst_41048);
var inst_41067 = cljs.core.first(inst_41048);
var inst_41068 = [inst_41066,inst_41067];
var inst_41069 = (new cljs.core.PersistentVector(null,2,(5),inst_41065,inst_41068,null));
var state_41356__$1 = state_41356;
var statearr_41406_41595 = state_41356__$1;
(statearr_41406_41595[(2)] = inst_41069);

(statearr_41406_41595[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (31))){
var inst_41120 = (state_41356[(27)]);
var inst_41120__$1 = typeof from === 'string';
var state_41356__$1 = (function (){var statearr_41407 = state_41356;
(statearr_41407[(27)] = inst_41120__$1);

return statearr_41407;
})();
if(cljs.core.truth_(inst_41120__$1)){
var statearr_41408_41596 = state_41356__$1;
(statearr_41408_41596[(1)] = (44));

} else {
var statearr_41409_41597 = state_41356__$1;
(statearr_41409_41597[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (113))){
var state_41356__$1 = state_41356;
var statearr_41410_41598 = state_41356__$1;
(statearr_41410_41598[(2)] = null);

(statearr_41410_41598[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (32))){
var inst_41094 = (state_41356[(16)]);
var inst_41329 = (state_41356[(2)]);
var state_41356__$1 = (function (){var statearr_41411 = state_41356;
(statearr_41411[(28)] = inst_41329);

return statearr_41411;
})();
if(cljs.core.truth_(inst_41094)){
var statearr_41412_41599 = state_41356__$1;
(statearr_41412_41599[(1)] = (122));

} else {
var statearr_41413_41600 = state_41356__$1;
(statearr_41413_41600[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (40))){
var inst_41048 = (state_41356[(18)]);
var inst_41110 = (state_41356[(2)]);
var state_41356__$1 = (function (){var statearr_41414 = state_41356;
(statearr_41414[(29)] = inst_41110);

return statearr_41414;
})();
if(cljs.core.truth_(inst_41048)){
var statearr_41415_41601 = state_41356__$1;
(statearr_41415_41601[(1)] = (41));

} else {
var statearr_41416_41602 = state_41356__$1;
(statearr_41416_41602[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (129))){
var inst_41337 = (state_41356[(30)]);
var state_41356__$1 = state_41356;
var statearr_41417_41603 = state_41356__$1;
(statearr_41417_41603[(2)] = inst_41337);

(statearr_41417_41603[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (91))){
var inst_41238 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_41356__$1 = state_41356;
var statearr_41418_41604 = state_41356__$1;
(statearr_41418_41604[(2)] = inst_41238);

(statearr_41418_41604[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (117))){
var inst_41051 = (state_41356[(15)]);
var state_41356__$1 = state_41356;
var statearr_41419_41605 = state_41356__$1;
(statearr_41419_41605[(2)] = inst_41051);

(statearr_41419_41605[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (108))){
var inst_41279 = (state_41356[(2)]);
var inst_41280 = fluree.db.util.async.throw_err(inst_41279);
var state_41356__$1 = state_41356;
var statearr_41420_41606 = state_41356__$1;
(statearr_41420_41606[(2)] = inst_41280);

(statearr_41420_41606[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (56))){
var inst_41143 = cljs.core.PersistentHashMap.EMPTY;
var state_41356__$1 = state_41356;
var statearr_41421_41607 = state_41356__$1;
(statearr_41421_41607[(2)] = inst_41143);

(statearr_41421_41607[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (33))){
var state_41356__$1 = state_41356;
var statearr_41422_41608 = state_41356__$1;
(statearr_41422_41608[(2)] = from);

(statearr_41422_41608[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (13))){
var inst_41035 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41036 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_41037 = cljs.core.PersistentHashMap.fromArrays(inst_41035,inst_41036);
var inst_41038 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_41037);
var inst_41039 = (function(){throw inst_41038})();
var state_41356__$1 = state_41356;
var statearr_41423_41609 = state_41356__$1;
(statearr_41423_41609[(2)] = inst_41039);

(statearr_41423_41609[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (22))){
var inst_41048 = (state_41356[(18)]);
var inst_41071 = typeof inst_41048 === 'string';
var state_41356__$1 = state_41356;
if(cljs.core.truth_(inst_41071)){
var statearr_41424_41610 = state_41356__$1;
(statearr_41424_41610[(1)] = (24));

} else {
var statearr_41425_41611 = state_41356__$1;
(statearr_41425_41611[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (90))){
var inst_41227 = (state_41356[(31)]);
var inst_41234 = (state_41356[(2)]);
var state_41356__$1 = (function (){var statearr_41426 = state_41356;
(statearr_41426[(32)] = inst_41234);

return statearr_41426;
})();
var statearr_41427_41612 = state_41356__$1;
(statearr_41427_41612[(2)] = inst_41227);

(statearr_41427_41612[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (109))){
var inst_41256 = (state_41356[(10)]);
var inst_41282 = (state_41356[(23)]);
var inst_41284 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41256,inst_41282);
var state_41356__$1 = state_41356;
var statearr_41428_41613 = state_41356__$1;
(statearr_41428_41613[(2)] = inst_41284);

(statearr_41428_41613[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (36))){
var inst_41048 = (state_41356[(18)]);
var inst_41105 = (state_41356[(2)]);
var inst_41106 = fluree.db.util.async.throw_err(inst_41105);
var state_41356__$1 = (function (){var statearr_41429 = state_41356;
(statearr_41429[(33)] = inst_41106);

return statearr_41429;
})();
if(cljs.core.truth_(inst_41048)){
var statearr_41430_41614 = state_41356__$1;
(statearr_41430_41614[(1)] = (38));

} else {
var statearr_41431_41615 = state_41356__$1;
(statearr_41431_41615[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (41))){
var state_41356__$1 = state_41356;
var statearr_41432_41616 = state_41356__$1;
(statearr_41432_41616[(2)] = null);

(statearr_41432_41616[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (118))){
var inst_41298 = (state_41356[(34)]);
var inst_41061 = (state_41356[(7)]);
var inst_41059 = (state_41356[(8)]);
var inst_41294 = (state_41356[(35)]);
var inst_41302 = (state_41356[(2)]);
var inst_41303 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_41061,fuel,max_fuel,inst_41059,inst_41294,inst_41298,inst_41302);
var state_41356__$1 = state_41356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41356__$1,(112),inst_41303);
} else {
if((state_val_41357 === (89))){
var state_41356__$1 = state_41356;
var statearr_41433_41617 = state_41356__$1;
(statearr_41433_41617[(2)] = null);

(statearr_41433_41617[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (100))){
var inst_41262 = (state_41356[(19)]);
var inst_41267 = cljs.core.int_QMARK_(inst_41262);
var state_41356__$1 = state_41356;
if(inst_41267){
var statearr_41434_41618 = state_41356__$1;
(statearr_41434_41618[(1)] = (102));

} else {
var statearr_41435_41619 = state_41356__$1;
(statearr_41435_41619[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (131))){
var inst_41334 = (state_41356[(11)]);
var inst_41348 = cljs.core.first(inst_41334);
var state_41356__$1 = state_41356;
var statearr_41436_41620 = state_41356__$1;
(statearr_41436_41620[(2)] = inst_41348);

(statearr_41436_41620[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (122))){
var inst_41094 = (state_41356[(16)]);
var inst_41095 = (state_41356[(17)]);
var inst_41051 = (state_41356[(15)]);
var inst_41329 = (state_41356[(28)]);
var inst_41049 = (state_41356[(14)]);
var inst_41331 = fluree.db.query.fql.sort_offset_and_limit_res(inst_41094,inst_41095,inst_41051,inst_41049,inst_41329);
var state_41356__$1 = state_41356;
var statearr_41437_41621 = state_41356__$1;
(statearr_41437_41621[(2)] = inst_41331);

(statearr_41437_41621[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (43))){
var inst_41106 = (state_41356[(33)]);
var inst_41110 = (state_41356[(29)]);
var inst_41061 = (state_41356[(7)]);
var inst_41059 = (state_41356[(8)]);
var inst_41114 = (state_41356[(2)]);
var inst_41115 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_41061,fuel,max_fuel,inst_41059,inst_41106,inst_41110,inst_41114);
var state_41356__$1 = state_41356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41356__$1,(37),inst_41115);
} else {
if((state_val_41357 === (61))){
var inst_41165 = ["_tx",null,"_block",null];
var inst_41166 = (new cljs.core.PersistentArrayMap(null,2,inst_41165,null));
var inst_41167 = (new cljs.core.PersistentHashSet(null,inst_41166,null));
var inst_41168 = (inst_41167.cljs$core$IFn$_invoke$arity$1 ? inst_41167.cljs$core$IFn$_invoke$arity$1(from) : inst_41167.call(null,from));
var state_41356__$1 = state_41356;
var statearr_41438_41622 = state_41356__$1;
(statearr_41438_41622[(2)] = inst_41168);

(statearr_41438_41622[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (29))){
var inst_41083 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41439_41623 = state_41356__$1;
(statearr_41439_41623[(2)] = inst_41083);

(statearr_41439_41623[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (44))){
var inst_41122 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_41123 = clojure.string.includes_QMARK_(inst_41122,"/");
var state_41356__$1 = state_41356;
var statearr_41440_41624 = state_41356__$1;
(statearr_41440_41624[(2)] = inst_41123);

(statearr_41440_41624[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (93))){
var inst_41241 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
if(cljs.core.truth_(inst_41241)){
var statearr_41441_41625 = state_41356__$1;
(statearr_41441_41625[(1)] = (94));

} else {
var statearr_41442_41626 = state_41356__$1;
(statearr_41442_41626[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (6))){
var inst_41026 = (state_41356[(36)]);
var state_41356__$1 = state_41356;
var statearr_41443_41627 = state_41356__$1;
(statearr_41443_41627[(2)] = inst_41026);

(statearr_41443_41627[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (111))){
var inst_41263 = (state_41356[(37)]);
var inst_41287 = (state_41356[(2)]);
var inst_41255 = inst_41263;
var inst_41256 = inst_41287;
var state_41356__$1 = (function (){var statearr_41444 = state_41356;
(statearr_41444[(10)] = inst_41256);

(statearr_41444[(38)] = inst_41255);

return statearr_41444;
})();
var statearr_41445_41628 = state_41356__$1;
(statearr_41445_41628[(2)] = null);

(statearr_41445_41628[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (28))){
var state_41356__$1 = state_41356;
var statearr_41446_41629 = state_41356__$1;
(statearr_41446_41629[(2)] = null);

(statearr_41446_41629[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (64))){
var inst_41048 = (state_41356[(18)]);
var state_41356__$1 = state_41356;
if(cljs.core.truth_(inst_41048)){
var statearr_41447_41630 = state_41356__$1;
(statearr_41447_41630[(1)] = (67));

} else {
var statearr_41448_41631 = state_41356__$1;
(statearr_41448_41631[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (103))){
var state_41356__$1 = state_41356;
if(cljs.core.truth_(fuel)){
var statearr_41449_41632 = state_41356__$1;
(statearr_41449_41632[(1)] = (105));

} else {
var statearr_41450_41633 = state_41356__$1;
(statearr_41450_41633[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (51))){
var inst_41129 = (state_41356[(26)]);
var state_41356__$1 = state_41356;
var statearr_41451_41634 = state_41356__$1;
(statearr_41451_41634[(2)] = inst_41129);

(statearr_41451_41634[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (25))){
var state_41356__$1 = state_41356;
var statearr_41452_41635 = state_41356__$1;
(statearr_41452_41635[(1)] = (27));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (34))){
var state_41356__$1 = state_41356;
var statearr_41454_41636 = state_41356__$1;
(statearr_41454_41636[(2)] = null);

(statearr_41454_41636[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (125))){
var inst_41337 = (state_41356[(30)]);
var inst_41334 = (state_41356[(11)]);
var inst_41337__$1 = cljs.core.coll_QMARK_(inst_41334);
var state_41356__$1 = (function (){var statearr_41455 = state_41356;
(statearr_41455[(30)] = inst_41337__$1);

return statearr_41455;
})();
if(inst_41337__$1){
var statearr_41456_41637 = state_41356__$1;
(statearr_41456_41637[(1)] = (128));

} else {
var statearr_41457_41638 = state_41356__$1;
(statearr_41457_41638[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (17))){
var inst_41048 = (state_41356[(18)]);
var inst_41059 = (state_41356[(2)]);
var inst_41060 = cljs.core.PersistentHashMap.EMPTY;
var inst_41061 = cljs.core.volatile_BANG_(inst_41060);
var state_41356__$1 = (function (){var statearr_41458 = state_41356;
(statearr_41458[(7)] = inst_41061);

(statearr_41458[(8)] = inst_41059);

return statearr_41458;
})();
if(cljs.core.truth_(inst_41048)){
var statearr_41459_41639 = state_41356__$1;
(statearr_41459_41639[(1)] = (18));

} else {
var statearr_41460_41640 = state_41356__$1;
(statearr_41460_41640[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (3))){
var inst_41354 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41356__$1,inst_41354);
} else {
if((state_val_41357 === (12))){
var inst_41032 = (state_41356[(39)]);
var state_41356__$1 = state_41356;
var statearr_41461_41641 = state_41356__$1;
(statearr_41461_41641[(2)] = inst_41032);

(statearr_41461_41641[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (2))){
var inst_41026 = (state_41356[(36)]);
var _ = (function (){var statearr_41462 = state_41356;
(statearr_41462[(4)] = cljs.core.cons((5),(state_41356[(4)])));

return statearr_41462;
})();
var inst_41026__$1 = select;
var state_41356__$1 = (function (){var statearr_41463 = state_41356;
(statearr_41463[(36)] = inst_41026__$1);

return statearr_41463;
})();
if(cljs.core.truth_(inst_41026__$1)){
var statearr_41464_41642 = state_41356__$1;
(statearr_41464_41642[(1)] = (6));

} else {
var statearr_41465_41643 = state_41356__$1;
(statearr_41465_41643[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (66))){
var inst_41325 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41466_41644 = state_41356__$1;
(statearr_41466_41644[(2)] = inst_41325);

(statearr_41466_41644[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (107))){
var inst_41262 = (state_41356[(19)]);
var inst_41276 = (state_41356[(2)]);
var inst_41277 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_41262,false);
var state_41356__$1 = (function (){var statearr_41467 = state_41356;
(statearr_41467[(40)] = inst_41276);

return statearr_41467;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41356__$1,(108),inst_41277);
} else {
if((state_val_41357 === (23))){
var inst_41087 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41468_41645 = state_41356__$1;
(statearr_41468_41645[(2)] = inst_41087);

(statearr_41468_41645[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (47))){
var inst_41129 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_41356__$1 = (function (){var statearr_41469 = state_41356;
(statearr_41469[(26)] = inst_41129);

return statearr_41469;
})();
if(cljs.core.truth_(fuel)){
var statearr_41470_41646 = state_41356__$1;
(statearr_41470_41646[(1)] = (50));

} else {
var statearr_41471_41647 = state_41356__$1;
(statearr_41471_41647[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (35))){
var inst_41102 = (state_41356[(2)]);
var inst_41103 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_41102);
var state_41356__$1 = state_41356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41356__$1,(36),inst_41103);
} else {
if((state_val_41357 === (127))){
var inst_41346 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
if(cljs.core.truth_(inst_41346)){
var statearr_41472_41648 = state_41356__$1;
(statearr_41472_41648[(1)] = (131));

} else {
var statearr_41473_41649 = state_41356__$1;
(statearr_41473_41649[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (82))){
var inst_41321 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41474_41650 = state_41356__$1;
(statearr_41474_41650[(2)] = inst_41321);

(statearr_41474_41650[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (76))){
var inst_41051 = (state_41356[(15)]);
var inst_41049 = (state_41356[(14)]);
var inst_41195 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_41196 = [inst_41049,inst_41051];
var inst_41197 = cljs.core.PersistentHashMap.fromArrays(inst_41195,inst_41196);
var state_41356__$1 = state_41356;
var statearr_41475_41651 = state_41356__$1;
(statearr_41475_41651[(2)] = inst_41197);

(statearr_41475_41651[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (97))){
var inst_41262 = (state_41356[(19)]);
var inst_41255 = (state_41356[(38)]);
var inst_41261 = cljs.core.seq(inst_41255);
var inst_41262__$1 = cljs.core.first(inst_41261);
var inst_41263 = cljs.core.next(inst_41261);
var inst_41264 = cljs.core.not(inst_41262__$1);
var state_41356__$1 = (function (){var statearr_41476 = state_41356;
(statearr_41476[(37)] = inst_41263);

(statearr_41476[(19)] = inst_41262__$1);

return statearr_41476;
})();
if(inst_41264){
var statearr_41477_41652 = state_41356__$1;
(statearr_41477_41652[(1)] = (99));

} else {
var statearr_41478_41653 = state_41356__$1;
(statearr_41478_41653[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (19))){
var inst_41089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41090 = [null,null];
var inst_41091 = (new cljs.core.PersistentVector(null,2,(5),inst_41089,inst_41090,null));
var state_41356__$1 = state_41356;
var statearr_41479_41654 = state_41356__$1;
(statearr_41479_41654[(2)] = inst_41091);

(statearr_41479_41654[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (57))){
var inst_41051 = (state_41356[(15)]);
var inst_41049 = (state_41356[(14)]);
var inst_41145 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_41146 = [inst_41049,inst_41051];
var inst_41147 = cljs.core.PersistentHashMap.fromArrays(inst_41145,inst_41146);
var state_41356__$1 = state_41356;
var statearr_41480_41655 = state_41356__$1;
(statearr_41480_41655[(2)] = inst_41147);

(statearr_41480_41655[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (68))){
var inst_41051 = (state_41356[(15)]);
var inst_41049 = (state_41356[(14)]);
var inst_41176 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_41177 = [inst_41049,inst_41051];
var inst_41178 = cljs.core.PersistentHashMap.fromArrays(inst_41176,inst_41177);
var state_41356__$1 = state_41356;
var statearr_41481_41656 = state_41356__$1;
(statearr_41481_41656[(2)] = inst_41178);

(statearr_41481_41656[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (11))){
var inst_41043 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41482_41657 = state_41356__$1;
(statearr_41482_41657[(2)] = inst_41043);

(statearr_41482_41657[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (115))){
var inst_41048 = (state_41356[(18)]);
var inst_41298 = (state_41356[(2)]);
var state_41356__$1 = (function (){var statearr_41484 = state_41356;
(statearr_41484[(34)] = inst_41298);

return statearr_41484;
})();
if(cljs.core.truth_(inst_41048)){
var statearr_41485_41658 = state_41356__$1;
(statearr_41485_41658[(1)] = (116));

} else {
var statearr_41486_41659 = state_41356__$1;
(statearr_41486_41659[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (9))){
var inst_41029 = (state_41356[(12)]);
var state_41356__$1 = state_41356;
var statearr_41487_41660 = state_41356__$1;
(statearr_41487_41660[(2)] = inst_41029);

(statearr_41487_41660[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (5))){
var _ = (function (){var statearr_41488 = state_41356;
(statearr_41488[(4)] = cljs.core.rest((state_41356[(4)])));

return statearr_41488;
})();
var state_41356__$1 = state_41356;
var ex41483 = (state_41356__$1[(2)]);
var statearr_41489_41661 = state_41356__$1;
(statearr_41489_41661[(5)] = ex41483);


if((ex41483 instanceof Error)){
var statearr_41490_41662 = state_41356__$1;
(statearr_41490_41662[(1)] = (4));

(statearr_41490_41662[(5)] = null);

} else {
throw ex41483;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (112))){
var inst_41305 = (state_41356[(2)]);
var inst_41306 = fluree.db.util.async.throw_err(inst_41305);
var state_41356__$1 = state_41356;
var statearr_41491_41663 = state_41356__$1;
(statearr_41491_41663[(2)] = inst_41306);

(statearr_41491_41663[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (83))){
var inst_41215 = (state_41356[(20)]);
var inst_41214 = (state_41356[(2)]);
var inst_41215__$1 = fluree.db.util.async.throw_err(inst_41214);
var inst_41216 = (inst_41215__$1 == null);
var state_41356__$1 = (function (){var statearr_41492 = state_41356;
(statearr_41492[(20)] = inst_41215__$1);

return statearr_41492;
})();
if(cljs.core.truth_(inst_41216)){
var statearr_41493_41664 = state_41356__$1;
(statearr_41493_41664[(1)] = (84));

} else {
var statearr_41494_41665 = state_41356__$1;
(statearr_41494_41665[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (14))){
var inst_41041 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41495_41666 = state_41356__$1;
(statearr_41495_41666[(2)] = inst_41041);

(statearr_41495_41666[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (45))){
var inst_41120 = (state_41356[(27)]);
var state_41356__$1 = state_41356;
var statearr_41496_41667 = state_41356__$1;
(statearr_41496_41667[(2)] = inst_41120);

(statearr_41496_41667[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (53))){
var inst_41135 = (state_41356[(21)]);
var inst_41137 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_41138 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_41135,inst_41137);
var state_41356__$1 = state_41356;
var statearr_41497_41668 = state_41356__$1;
(statearr_41497_41668[(2)] = inst_41138);

(statearr_41497_41668[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (78))){
var inst_41061 = (state_41356[(7)]);
var inst_41059 = (state_41356[(8)]);
var inst_41202 = (state_41356[(2)]);
var inst_41203 = fluree.db.util.async.throw_err(inst_41202);
var inst_41204 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_41061,fuel,max_fuel,inst_41059,inst_41203);
var state_41356__$1 = state_41356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41356__$1,(79),inst_41204);
} else {
if((state_val_41357 === (132))){
var inst_41334 = (state_41356[(11)]);
var state_41356__$1 = state_41356;
var statearr_41498_41669 = state_41356__$1;
(statearr_41498_41669[(2)] = inst_41334);

(statearr_41498_41669[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (26))){
var inst_41085 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41499_41670 = state_41356__$1;
(statearr_41499_41670[(2)] = inst_41085);

(statearr_41499_41670[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (123))){
var inst_41329 = (state_41356[(28)]);
var state_41356__$1 = state_41356;
var statearr_41500_41671 = state_41356__$1;
(statearr_41500_41671[(2)] = inst_41329);

(statearr_41500_41671[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (16))){
var inst_41052 = (state_41356[(24)]);
var state_41356__$1 = state_41356;
var statearr_41501_41672 = state_41356__$1;
(statearr_41501_41672[(2)] = inst_41052);

(statearr_41501_41672[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (133))){
var inst_41351 = (state_41356[(2)]);
var _ = (function (){var statearr_41502 = state_41356;
(statearr_41502[(4)] = cljs.core.rest((state_41356[(4)])));

return statearr_41502;
})();
var state_41356__$1 = state_41356;
var statearr_41503_41673 = state_41356__$1;
(statearr_41503_41673[(2)] = inst_41351);

(statearr_41503_41673[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (81))){
var inst_41236 = (state_41356[(22)]);
var inst_41236__$1 = cljs.core.sequential_QMARK_(from);
var state_41356__$1 = (function (){var statearr_41504 = state_41356;
(statearr_41504[(22)] = inst_41236__$1);

return statearr_41504;
})();
if(inst_41236__$1){
var statearr_41505_41674 = state_41356__$1;
(statearr_41505_41674[(1)] = (91));

} else {
var statearr_41506_41675 = state_41356__$1;
(statearr_41506_41675[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (120))){
var state_41356__$1 = state_41356;
var statearr_41507_41676 = state_41356__$1;
(statearr_41507_41676[(2)] = null);

(statearr_41507_41676[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (79))){
var inst_41206 = (state_41356[(2)]);
var inst_41207 = fluree.db.util.async.throw_err(inst_41206);
var state_41356__$1 = state_41356;
var statearr_41508_41677 = state_41356__$1;
(statearr_41508_41677[(2)] = inst_41207);

(statearr_41508_41677[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (38))){
var state_41356__$1 = state_41356;
var statearr_41509_41678 = state_41356__$1;
(statearr_41509_41678[(2)] = null);

(statearr_41509_41678[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (126))){
var inst_41335 = (state_41356[(41)]);
var state_41356__$1 = state_41356;
var statearr_41510_41679 = state_41356__$1;
(statearr_41510_41679[(2)] = inst_41335);

(statearr_41510_41679[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (98))){
var inst_41048 = (state_41356[(18)]);
var inst_41292 = (state_41356[(2)]);
var inst_41293 = cljs.core.PersistentVector.EMPTY;
var inst_41294 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41293,inst_41292);
var state_41356__$1 = (function (){var statearr_41511 = state_41356;
(statearr_41511[(35)] = inst_41294);

return statearr_41511;
})();
if(cljs.core.truth_(inst_41048)){
var statearr_41512_41680 = state_41356__$1;
(statearr_41512_41680[(1)] = (113));

} else {
var statearr_41513_41681 = state_41356__$1;
(statearr_41513_41681[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (124))){
var inst_41335 = (state_41356[(41)]);
var inst_41334 = (state_41356[(2)]);
var inst_41335__$1 = selectOne;
var state_41356__$1 = (function (){var statearr_41514 = state_41356;
(statearr_41514[(41)] = inst_41335__$1);

(statearr_41514[(11)] = inst_41334);

return statearr_41514;
})();
if(cljs.core.truth_(inst_41335__$1)){
var statearr_41515_41682 = state_41356__$1;
(statearr_41515_41682[(1)] = (125));

} else {
var statearr_41516_41683 = state_41356__$1;
(statearr_41516_41683[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (87))){
var inst_41226 = (state_41356[(2)]);
var inst_41227 = fluree.db.util.async.throw_err(inst_41226);
var state_41356__$1 = (function (){var statearr_41517 = state_41356;
(statearr_41517[(31)] = inst_41227);

return statearr_41517;
})();
if(cljs.core.truth_(fuel)){
var statearr_41518_41684 = state_41356__$1;
(statearr_41518_41684[(1)] = (88));

} else {
var statearr_41519_41685 = state_41356__$1;
(statearr_41519_41685[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (30))){
var inst_41098 = typeof from === 'string';
var state_41356__$1 = state_41356;
if(cljs.core.truth_(inst_41098)){
var statearr_41520_41686 = state_41356__$1;
(statearr_41520_41686[(1)] = (33));

} else {
var statearr_41521_41687 = state_41356__$1;
(statearr_41521_41687[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (73))){
var inst_41209 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_41356__$1 = state_41356;
if(inst_41209){
var statearr_41522_41688 = state_41356__$1;
(statearr_41522_41688[(1)] = (80));

} else {
var statearr_41523_41689 = state_41356__$1;
(statearr_41523_41689[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (96))){
var inst_41319 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41524_41690 = state_41356__$1;
(statearr_41524_41690[(2)] = inst_41319);

(statearr_41524_41690[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (10))){
var inst_41032 = (state_41356[(39)]);
var inst_41032__$1 = selectDistinct;
var state_41356__$1 = (function (){var statearr_41525 = state_41356;
(statearr_41525[(39)] = inst_41032__$1);

return statearr_41525;
})();
if(cljs.core.truth_(inst_41032__$1)){
var statearr_41526_41691 = state_41356__$1;
(statearr_41526_41691[(1)] = (12));

} else {
var statearr_41527_41692 = state_41356__$1;
(statearr_41527_41692[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (18))){
var inst_41048 = (state_41356[(18)]);
var inst_41063 = cljs.core.vector_QMARK_(inst_41048);
var state_41356__$1 = state_41356;
if(inst_41063){
var statearr_41528_41693 = state_41356__$1;
(statearr_41528_41693[(1)] = (21));

} else {
var statearr_41529_41694 = state_41356__$1;
(statearr_41529_41694[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (105))){
var inst_41271 = cljs.core._deref(fuel);
var inst_41272 = (inst_41271 + (1));
var inst_41273 = cljs.core._vreset_BANG_(fuel,inst_41272);
var state_41356__$1 = state_41356;
var statearr_41530_41695 = state_41356__$1;
(statearr_41530_41695[(2)] = inst_41273);

(statearr_41530_41695[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (52))){
var inst_41135 = (state_41356[(2)]);
var state_41356__$1 = (function (){var statearr_41531 = state_41356;
(statearr_41531[(21)] = inst_41135);

return statearr_41531;
})();
var statearr_41532_41696 = state_41356__$1;
(statearr_41532_41696[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (114))){
var inst_41049 = (state_41356[(14)]);
var state_41356__$1 = state_41356;
var statearr_41534_41697 = state_41356__$1;
(statearr_41534_41697[(2)] = inst_41049);

(statearr_41534_41697[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (67))){
var inst_41174 = cljs.core.PersistentHashMap.EMPTY;
var state_41356__$1 = state_41356;
var statearr_41535_41698 = state_41356__$1;
(statearr_41535_41698[(2)] = inst_41174);

(statearr_41535_41698[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (71))){
var inst_41187 = (state_41356[(2)]);
var inst_41188 = fluree.db.util.async.throw_err(inst_41187);
var state_41356__$1 = state_41356;
var statearr_41536_41699 = state_41356__$1;
(statearr_41536_41699[(2)] = inst_41188);

(statearr_41536_41699[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (42))){
var inst_41051 = (state_41356[(15)]);
var state_41356__$1 = state_41356;
var statearr_41537_41700 = state_41356__$1;
(statearr_41537_41700[(2)] = inst_41051);

(statearr_41537_41700[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (80))){
var inst_41212 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_41356__$1 = state_41356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41356__$1,(83),inst_41212);
} else {
if((state_val_41357 === (37))){
var inst_41117 = (state_41356[(2)]);
var inst_41118 = fluree.db.util.async.throw_err(inst_41117);
var state_41356__$1 = state_41356;
var statearr_41538_41701 = state_41356__$1;
(statearr_41538_41701[(2)] = inst_41118);

(statearr_41538_41701[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (63))){
var inst_41171 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
if(cljs.core.truth_(inst_41171)){
var statearr_41539_41702 = state_41356__$1;
(statearr_41539_41702[(1)] = (64));

} else {
var statearr_41540_41703 = state_41356__$1;
(statearr_41540_41703[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (94))){
var inst_41250 = from;
var inst_41251 = cljs.core.seq(inst_41250);
var inst_41252 = cljs.core.first(inst_41251);
var inst_41253 = cljs.core.next(inst_41251);
var inst_41254 = cljs.core.PersistentVector.EMPTY;
var inst_41255 = inst_41250;
var inst_41256 = inst_41254;
var state_41356__$1 = (function (){var statearr_41541 = state_41356;
(statearr_41541[(10)] = inst_41256);

(statearr_41541[(42)] = inst_41252);

(statearr_41541[(43)] = inst_41253);

(statearr_41541[(38)] = inst_41255);

return statearr_41541;
})();
var statearr_41542_41704 = state_41356__$1;
(statearr_41542_41704[(2)] = null);

(statearr_41542_41704[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (8))){
var inst_41050 = (state_41356[(25)]);
var inst_41045 = (state_41356[(2)]);
var inst_41046 = opts_SINGLEQUOTE_;
var inst_41047 = cljs.core.__destructure_map(inst_41046);
var inst_41048 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41047,cljs.core.cst$kw$orderBy);
var inst_41049 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41047,cljs.core.cst$kw$limit);
var inst_41050__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41047,cljs.core.cst$kw$component);
var inst_41051 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41047,cljs.core.cst$kw$offset);
var inst_41052 = fluree.db.query.fql_parser.parse_db(db,inst_41045,opts_SINGLEQUOTE_);
var inst_41053 = (inst_41050__$1 == null);
var inst_41054 = cljs.core.not(inst_41053);
var state_41356__$1 = (function (){var statearr_41543 = state_41356;
(statearr_41543[(18)] = inst_41048);

(statearr_41543[(24)] = inst_41052);

(statearr_41543[(25)] = inst_41050__$1);

(statearr_41543[(15)] = inst_41051);

(statearr_41543[(14)] = inst_41049);

return statearr_41543;
})();
if(inst_41054){
var statearr_41544_41705 = state_41356__$1;
(statearr_41544_41705[(1)] = (15));

} else {
var statearr_41545_41706 = state_41356__$1;
(statearr_41545_41706[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (49))){
var inst_41327 = (state_41356[(2)]);
var state_41356__$1 = state_41356;
var statearr_41546_41707 = state_41356__$1;
(statearr_41546_41707[(2)] = inst_41327);

(statearr_41546_41707[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41357 === (84))){
var state_41356__$1 = state_41356;
var statearr_41547_41708 = state_41356__$1;
(statearr_41547_41708[(2)] = null);

(statearr_41547_41708[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__16153__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__16153__auto____0 = (function (){
var statearr_41548 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41548[(0)] = fluree$db$query$fql$query_$_state_machine__16153__auto__);

(statearr_41548[(1)] = (1));

return statearr_41548;
});
var fluree$db$query$fql$query_$_state_machine__16153__auto____1 = (function (state_41356){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_41356);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e41549){var ex__16156__auto__ = e41549;
var statearr_41550_41709 = state_41356;
(statearr_41550_41709[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_41356[(4)]))){
var statearr_41551_41710 = state_41356;
(statearr_41551_41710[(1)] = cljs.core.first((state_41356[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__41711 = state_41356;
state_41356 = G__41711;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__16153__auto__ = function(state_41356){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__16153__auto____1.call(this,state_41356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__16153__auto____0;
fluree$db$query$fql$query_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__16153__auto____1;
return fluree$db$query$fql$query_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_41552 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_41552[(6)] = c__16227__auto__);

return statearr_41552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}

});
