// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4223__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__29447 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29447,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29447,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29447,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29447,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29447,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29447,(5),null);
var G__29450 = idx;
var G__29450__$1 = (((G__29450 instanceof cljs.core.Keyword))?G__29450.fqn:null);
switch (G__29450__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29450__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__29452 = idx;
var G__29452__$1 = (((G__29452 instanceof cljs.core.Keyword))?G__29452.fqn:null);
switch (G__29452__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29452__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__29454 = idx;
var G__29454__$1 = (((G__29454 instanceof cljs.core.Keyword))?G__29454.fqn:null);
switch (G__29454__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29454__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__29457 = arguments.length;
switch (G__29457) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__29458 = (function (){var pred__29461 = cljs.core.identical_QMARK_;
var expr__29462 = test;
if(cljs.core.truth_((pred__29461.cljs$core$IFn$_invoke$arity$2 ? pred__29461.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__29462) : pred__29461.call(null,cljs.core._EQ_,expr__29462)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__29461.cljs$core$IFn$_invoke$arity$2 ? pred__29461.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__29462) : pred__29461.call(null,cljs.core._LT_,expr__29462)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__29461.cljs$core$IFn$_invoke$arity$2 ? pred__29461.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__29462) : pred__29461.call(null,cljs.core._LT__EQ_,expr__29462)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__29461.cljs$core$IFn$_invoke$arity$2 ? pred__29461.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__29462) : pred__29461.call(null,cljs.core._GT_,expr__29462)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__29461.cljs$core$IFn$_invoke$arity$2 ? pred__29461.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__29462) : pred__29461.call(null,cljs.core._GT__EQ_,expr__29462)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__29462)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29458,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29458,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29458,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29458,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_29701){
var state_val_29702 = (state_29701[(1)]);
if((state_val_29702 === (65))){
var inst_29616 = (state_29701[(7)]);
var inst_29672 = (state_29701[(8)]);
var inst_29672__$1 = (state_29701[(2)]);
var inst_29673 = cljs.core.count(inst_29672__$1);
var state_29701__$1 = (function (){var statearr_29703 = state_29701;
(statearr_29703[(8)] = inst_29672__$1);

(statearr_29703[(9)] = inst_29673);

return statearr_29703;
})();
if(cljs.core.truth_(inst_29616)){
var statearr_29704_29841 = state_29701__$1;
(statearr_29704_29841[(1)] = (81));

} else {
var statearr_29705_29842 = state_29701__$1;
(statearr_29705_29842[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (70))){
var inst_29647 = (state_29701[(2)]);
var state_29701__$1 = state_29701;
if(cljs.core.truth_(inst_29647)){
var statearr_29706_29843 = state_29701__$1;
(statearr_29706_29843[(1)] = (71));

} else {
var statearr_29707_29844 = state_29701__$1;
(statearr_29707_29844[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (62))){
var inst_29586 = (state_29701[(10)]);
var inst_29600 = (state_29701[(11)]);
var inst_29615 = (state_29701[(2)]);
var inst_29616 = fluree.db.dbproto._rhs(inst_29600);
var state_29701__$1 = (function (){var statearr_29708 = state_29701;
(statearr_29708[(12)] = inst_29615);

(statearr_29708[(7)] = inst_29616);

return statearr_29708;
})();
if(cljs.core.truth_(inst_29586)){
var statearr_29709_29845 = state_29701__$1;
(statearr_29709_29845[(1)] = (63));

} else {
var statearr_29710_29846 = state_29701__$1;
(statearr_29710_29846[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (74))){
var inst_29640 = (state_29701[(13)]);
var inst_29654 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_29640);
var state_29701__$1 = state_29701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29701__$1,(77),inst_29654);
} else {
if((state_val_29702 === (7))){
var inst_29477 = (state_29701[(14)]);
var state_29701__$1 = state_29701;
var statearr_29711_29847 = state_29701__$1;
(statearr_29711_29847[(2)] = inst_29477);

(statearr_29711_29847[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (59))){
var inst_29562 = (state_29701[(15)]);
var inst_29563 = (state_29701[(16)]);
var inst_29607 = (state_29701[(17)]);
var inst_29606 = (state_29701[(2)]);
var inst_29607__$1 = fluree.db.util.async.throw_err(inst_29606);
var inst_29608 = fluree.db.flake.subrange(inst_29607__$1,start_test,inst_29562,end_test,inst_29563);
var inst_29609 = fluree.db.query.range.value_with_nil_pred(idx,inst_29562,inst_29563);
var state_29701__$1 = (function (){var statearr_29712 = state_29701;
(statearr_29712[(18)] = inst_29608);

(statearr_29712[(17)] = inst_29607__$1);

return statearr_29712;
})();
if(inst_29609){
var statearr_29713_29848 = state_29701__$1;
(statearr_29713_29848[(1)] = (60));

} else {
var statearr_29714_29849 = state_29701__$1;
(statearr_29714_29849[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (86))){
var inst_29681 = (state_29701[(2)]);
var state_29701__$1 = state_29701;
var statearr_29715_29850 = state_29701__$1;
(statearr_29715_29850[(2)] = inst_29681);

(statearr_29715_29850[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (20))){
var inst_29478 = (state_29701[(19)]);
var inst_29526 = (state_29701[(20)]);
var inst_29525 = (state_29701[(2)]);
var inst_29526__$1 = (inst_29478 == null);
var state_29701__$1 = (function (){var statearr_29716 = state_29701;
(statearr_29716[(21)] = inst_29525);

(statearr_29716[(20)] = inst_29526__$1);

return statearr_29716;
})();
if(cljs.core.truth_(inst_29526__$1)){
var statearr_29717_29851 = state_29701__$1;
(statearr_29717_29851[(1)] = (22));

} else {
var statearr_29718_29852 = state_29701__$1;
(statearr_29718_29852[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (72))){
var inst_29633 = (state_29701[(22)]);
var inst_29651 = (inst_29633 + (1));
var inst_29652 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_29701__$1 = (function (){var statearr_29719 = state_29701;
(statearr_29719[(23)] = inst_29651);

return statearr_29719;
})();
if(cljs.core.truth_(inst_29652)){
var statearr_29720_29853 = state_29701__$1;
(statearr_29720_29853[(1)] = (74));

} else {
var statearr_29721_29854 = state_29701__$1;
(statearr_29721_29854[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (58))){
var inst_29696 = (state_29701[(2)]);
var _ = (function (){var statearr_29722 = state_29701;
(statearr_29722[(4)] = cljs.core.rest((state_29701[(4)])));

return statearr_29722;
})();
var state_29701__$1 = state_29701;
var statearr_29723_29855 = state_29701__$1;
(statearr_29723_29855[(2)] = inst_29696);

(statearr_29723_29855[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (60))){
var inst_29507 = (state_29701[(24)]);
var inst_29487 = (state_29701[(25)]);
var inst_29590 = (state_29701[(26)]);
var inst_29552 = (state_29701[(27)]);
var inst_29488 = (state_29701[(28)]);
var inst_29525 = (state_29701[(21)]);
var inst_29586 = (state_29701[(10)]);
var inst_29568 = (state_29701[(29)]);
var inst_29562 = (state_29701[(15)]);
var inst_29608 = (state_29701[(18)]);
var inst_29476 = (state_29701[(30)]);
var inst_29543 = (state_29701[(31)]);
var inst_29563 = (state_29701[(16)]);
var inst_29573 = (state_29701[(32)]);
var inst_29480 = (state_29701[(33)]);
var inst_29580 = (state_29701[(34)]);
var inst_29600 = (state_29701[(11)]);
var inst_29498 = (state_29701[(35)]);
var inst_29534 = (state_29701[(36)]);
var inst_29561 = (state_29701[(37)]);
var inst_29569 = (state_29701[(38)]);
var inst_29579 = (state_29701[(39)]);
var inst_29607 = (state_29701[(17)]);
var inst_29595 = (state_29701[(40)]);
var inst_29483 = (state_29701[(41)]);
var inst_29481 = (state_29701[(42)]);
var inst_29602 = (state_29701[(43)]);
var inst_29601 = (state_29701[(44)]);
var inst_29516 = (state_29701[(45)]);
var inst_29611 = (function (){var no_filter_QMARK_ = inst_29586;
var next_node = inst_29600;
var flakes = inst_29607;
var s1 = inst_29498;
var o2 = inst_29525;
var t1 = inst_29480;
var i = inst_29601;
var m1 = inst_29552;
var root_node = inst_29595;
var to_t = inst_29580;
var s2 = inst_29507;
var p2 = inst_29543;
var permissions = inst_29569;
var limit = inst_29568;
var start_flake = inst_29562;
var acc = inst_29602;
var t2 = inst_29487;
var op1 = inst_29481;
var o1 = inst_29516;
var end_flake = inst_29563;
var base_result = inst_29608;
var p1 = inst_29534;
var vec__29470 = inst_29476;
var idx_compare = inst_29573;
var vec__29473 = inst_29483;
var op2 = inst_29488;
var from_t = inst_29579;
var m2 = inst_29561;
var novelty = inst_29590;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_29612 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_29611,inst_29608,inst_29608);
var state_29701__$1 = state_29701;
var statearr_29724_29856 = state_29701__$1;
(statearr_29724_29856[(2)] = inst_29612);

(statearr_29724_29856[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (27))){
var inst_29485 = (state_29701[(46)]);
var inst_29535 = (state_29701[(47)]);
var inst_29534 = (state_29701[(2)]);
var inst_29535__$1 = (inst_29485 == null);
var state_29701__$1 = (function (){var statearr_29725 = state_29701;
(statearr_29725[(36)] = inst_29534);

(statearr_29725[(47)] = inst_29535__$1);

return statearr_29725;
})();
if(cljs.core.truth_(inst_29535__$1)){
var statearr_29726_29857 = state_29701__$1;
(statearr_29726_29857[(1)] = (28));

} else {
var statearr_29727_29858 = state_29701__$1;
(statearr_29727_29858[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (1))){
var state_29701__$1 = state_29701;
var statearr_29728_29859 = state_29701__$1;
(statearr_29728_29859[(2)] = null);

(statearr_29728_29859[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (69))){
var inst_29568 = (state_29701[(29)]);
var inst_29633 = (state_29701[(22)]);
var inst_29645 = (inst_29633 > inst_29568);
var state_29701__$1 = state_29701;
var statearr_29729_29860 = state_29701__$1;
(statearr_29729_29860[(2)] = inst_29645);

(statearr_29729_29860[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (24))){
var inst_29530 = (state_29701[(2)]);
var state_29701__$1 = state_29701;
if(cljs.core.truth_(inst_29530)){
var statearr_29730_29861 = state_29701__$1;
(statearr_29730_29861[(1)] = (25));

} else {
var statearr_29731_29862 = state_29701__$1;
(statearr_29731_29862[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (55))){
var inst_29562 = (state_29701[(15)]);
var inst_29595 = (state_29701[(40)]);
var inst_29594 = (state_29701[(2)]);
var inst_29595__$1 = fluree.db.util.async.throw_err(inst_29594);
var inst_29596 = fluree.db.dbproto._lookup_leaf(inst_29595__$1,inst_29562);
var state_29701__$1 = (function (){var statearr_29732 = state_29701;
(statearr_29732[(40)] = inst_29595__$1);

return statearr_29732;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29701__$1,(56),inst_29596);
} else {
if((state_val_29702 === (85))){
var inst_29676 = (state_29701[(48)]);
var state_29701__$1 = state_29701;
var statearr_29733_29863 = state_29701__$1;
(statearr_29733_29863[(2)] = inst_29676);

(statearr_29733_29863[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (39))){
var inst_29550 = (state_29701[(2)]);
var state_29701__$1 = state_29701;
var statearr_29734_29864 = state_29701__$1;
(statearr_29734_29864[(2)] = inst_29550);

(statearr_29734_29864[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (88))){
var inst_29616 = (state_29701[(7)]);
var inst_29595 = (state_29701[(40)]);
var inst_29688 = fluree.db.dbproto._lookup_leaf(inst_29595,inst_29616);
var state_29701__$1 = state_29701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29701__$1,(90),inst_29688);
} else {
if((state_val_29702 === (46))){
var inst_29564 = (state_29701[(49)]);
var state_29701__$1 = state_29701;
var statearr_29735_29865 = state_29701__$1;
(statearr_29735_29865[(2)] = inst_29564);

(statearr_29735_29865[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (4))){
var inst_29464 = (state_29701[(2)]);
var state_29701__$1 = state_29701;
var statearr_29736_29866 = state_29701__$1;
(statearr_29736_29866[(2)] = inst_29464);

(statearr_29736_29866[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (77))){
var inst_29656 = (state_29701[(2)]);
var inst_29657 = fluree.db.util.async.throw_err(inst_29656);
var state_29701__$1 = state_29701;
if(cljs.core.truth_(inst_29657)){
var statearr_29737_29867 = state_29701__$1;
(statearr_29737_29867[(1)] = (78));

} else {
var statearr_29738_29868 = state_29701__$1;
(statearr_29738_29868[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (54))){
var inst_29586 = (state_29701[(2)]);
var inst_29587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29588 = [cljs.core.cst$kw$novelty,idx];
var inst_29589 = (new cljs.core.PersistentVector(null,2,(5),inst_29587,inst_29588,null));
var inst_29590 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_29589);
var inst_29591 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_29592 = fluree.db.dbproto._resolve(inst_29591);
var state_29701__$1 = (function (){var statearr_29739 = state_29701;
(statearr_29739[(26)] = inst_29590);

(statearr_29739[(10)] = inst_29586);

return statearr_29739;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29701__$1,(55),inst_29592);
} else {
if((state_val_29702 === (15))){
var inst_29479 = (state_29701[(50)]);
var state_29701__$1 = state_29701;
var statearr_29740_29869 = state_29701__$1;
(statearr_29740_29869[(2)] = inst_29479);

(statearr_29740_29869[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (48))){
var inst_29574 = (state_29701[(51)]);
var inst_29568 = (state_29701[(2)]);
var inst_29569 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_29570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29571 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_29572 = (new cljs.core.PersistentVector(null,3,(5),inst_29570,inst_29571,null));
var inst_29573 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_29572);
var inst_29574__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_29701__$1 = (function (){var statearr_29741 = state_29701;
(statearr_29741[(29)] = inst_29568);

(statearr_29741[(32)] = inst_29573);

(statearr_29741[(51)] = inst_29574__$1);

(statearr_29741[(38)] = inst_29569);

return statearr_29741;
})();
if(cljs.core.truth_(inst_29574__$1)){
var statearr_29742_29870 = state_29701__$1;
(statearr_29742_29870[(1)] = (49));

} else {
var statearr_29743_29871 = state_29701__$1;
(statearr_29743_29871[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (50))){
var inst_29577 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_29701__$1 = state_29701;
var statearr_29744_29872 = state_29701__$1;
(statearr_29744_29872[(2)] = inst_29577);

(statearr_29744_29872[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (75))){
var inst_29634 = (state_29701[(52)]);
var state_29701__$1 = state_29701;
var statearr_29745_29873 = state_29701__$1;
(statearr_29745_29873[(2)] = inst_29634);

(statearr_29745_29873[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (21))){
var inst_29521 = (state_29701[(2)]);
var inst_29522 = fluree.db.util.async.throw_err(inst_29521);
var state_29701__$1 = state_29701;
var statearr_29746_29874 = state_29701__$1;
(statearr_29746_29874[(2)] = inst_29522);

(statearr_29746_29874[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (31))){
var state_29701__$1 = state_29701;
var statearr_29747_29875 = state_29701__$1;
(statearr_29747_29875[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_29747_29875[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (32))){
var inst_29485 = (state_29701[(46)]);
var state_29701__$1 = state_29701;
var statearr_29748_29876 = state_29701__$1;
(statearr_29748_29876[(2)] = inst_29485);

(statearr_29748_29876[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (40))){
var inst_29489 = (state_29701[(53)]);
var state_29701__$1 = state_29701;
var statearr_29749_29877 = state_29701__$1;
(statearr_29749_29877[(2)] = inst_29489);

(statearr_29749_29877[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (56))){
var inst_29598 = (state_29701[(2)]);
var inst_29599 = fluree.db.util.async.throw_err(inst_29598);
var inst_29600 = inst_29599;
var inst_29601 = (0);
var inst_29602 = null;
var state_29701__$1 = (function (){var statearr_29750 = state_29701;
(statearr_29750[(11)] = inst_29600);

(statearr_29750[(43)] = inst_29602);

(statearr_29750[(44)] = inst_29601);

return statearr_29750;
})();
var statearr_29751_29878 = state_29701__$1;
(statearr_29751_29878[(2)] = null);

(statearr_29751_29878[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (33))){
var inst_29482 = (state_29701[(54)]);
var inst_29543 = (state_29701[(2)]);
var state_29701__$1 = (function (){var statearr_29752 = state_29701;
(statearr_29752[(31)] = inst_29543);

return statearr_29752;
})();
if(cljs.core.truth_(inst_29482)){
var statearr_29753_29879 = state_29701__$1;
(statearr_29753_29879[(1)] = (34));

} else {
var statearr_29754_29880 = state_29701__$1;
(statearr_29754_29880[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (13))){
var inst_29503 = (state_29701[(2)]);
var inst_29504 = fluree.db.util.async.throw_err(inst_29503);
var state_29701__$1 = state_29701;
var statearr_29755_29881 = state_29701__$1;
(statearr_29755_29881[(2)] = inst_29504);

(statearr_29755_29881[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (22))){
var inst_29516 = (state_29701[(45)]);
var state_29701__$1 = state_29701;
var statearr_29756_29882 = state_29701__$1;
(statearr_29756_29882[(2)] = inst_29516);

(statearr_29756_29882[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (90))){
var inst_29672 = (state_29701[(8)]);
var inst_29673 = (state_29701[(9)]);
var inst_29690 = (state_29701[(2)]);
var inst_29691 = fluree.db.util.async.throw_err(inst_29690);
var inst_29600 = inst_29691;
var inst_29601 = inst_29673;
var inst_29602 = inst_29672;
var state_29701__$1 = (function (){var statearr_29757 = state_29701;
(statearr_29757[(11)] = inst_29600);

(statearr_29757[(43)] = inst_29602);

(statearr_29757[(44)] = inst_29601);

return statearr_29757;
})();
var statearr_29758_29883 = state_29701__$1;
(statearr_29758_29883[(2)] = null);

(statearr_29758_29883[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (36))){
var inst_29489 = (state_29701[(53)]);
var inst_29552 = (state_29701[(2)]);
var state_29701__$1 = (function (){var statearr_29759 = state_29701;
(statearr_29759[(27)] = inst_29552);

return statearr_29759;
})();
if(cljs.core.truth_(inst_29489)){
var statearr_29760_29884 = state_29701__$1;
(statearr_29760_29884[(1)] = (40));

} else {
var statearr_29761_29885 = state_29701__$1;
(statearr_29761_29885[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (41))){
var inst_29555 = (cljs.core._LT__EQ_ === end_test);
var state_29701__$1 = state_29701;
if(cljs.core.truth_(inst_29555)){
var statearr_29762_29886 = state_29701__$1;
(statearr_29762_29886[(1)] = (43));

} else {
var statearr_29763_29887 = state_29701__$1;
(statearr_29763_29887[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (89))){
var inst_29694 = (state_29701[(2)]);
var state_29701__$1 = state_29701;
var statearr_29764_29888 = state_29701__$1;
(statearr_29764_29888[(2)] = inst_29694);

(statearr_29764_29888[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (43))){
var state_29701__$1 = state_29701;
var statearr_29765_29889 = state_29701__$1;
(statearr_29765_29889[(2)] = (2147483647));

(statearr_29765_29889[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (61))){
var inst_29608 = (state_29701[(18)]);
var state_29701__$1 = state_29701;
var statearr_29766_29890 = state_29701__$1;
(statearr_29766_29890[(2)] = inst_29608);

(statearr_29766_29890[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (29))){
var inst_29535 = (state_29701[(47)]);
var state_29701__$1 = state_29701;
var statearr_29767_29891 = state_29701__$1;
(statearr_29767_29891[(2)] = inst_29535);

(statearr_29767_29891[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (44))){
var state_29701__$1 = state_29701;
var statearr_29768_29892 = state_29701__$1;
(statearr_29768_29892[(2)] = fluree.db.util.core.min_integer);

(statearr_29768_29892[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (6))){
var inst_29477 = (state_29701[(14)]);
var inst_29492 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29477);
var state_29701__$1 = state_29701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29701__$1,(9),inst_29492);
} else {
if((state_val_29702 === (28))){
var inst_29525 = (state_29701[(21)]);
var state_29701__$1 = state_29701;
var statearr_29769_29893 = state_29701__$1;
(statearr_29769_29893[(2)] = inst_29525);

(statearr_29769_29893[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (64))){
var inst_29615 = (state_29701[(12)]);
var inst_29601 = (state_29701[(44)]);
var inst_29629 = cljs.core.seq(inst_29615);
var inst_29630 = cljs.core.first(inst_29629);
var inst_29631 = cljs.core.next(inst_29629);
var inst_29632 = inst_29615;
var inst_29633 = inst_29601;
var inst_29634 = inst_29615;
var state_29701__$1 = (function (){var statearr_29770 = state_29701;
(statearr_29770[(55)] = inst_29632);

(statearr_29770[(56)] = inst_29630);

(statearr_29770[(22)] = inst_29633);

(statearr_29770[(57)] = inst_29631);

(statearr_29770[(52)] = inst_29634);

return statearr_29770;
})();
var statearr_29771_29894 = state_29701__$1;
(statearr_29771_29894[(2)] = null);

(statearr_29771_29894[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (51))){
var inst_29579 = (state_29701[(2)]);
var inst_29580 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_29581 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_29701__$1 = (function (){var statearr_29772 = state_29701;
(statearr_29772[(34)] = inst_29580);

(statearr_29772[(39)] = inst_29579);

return statearr_29772;
})();
if(cljs.core.truth_(inst_29581)){
var statearr_29773_29895 = state_29701__$1;
(statearr_29773_29895[(1)] = (52));

} else {
var statearr_29774_29896 = state_29701__$1;
(statearr_29774_29896[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (25))){
var state_29701__$1 = state_29701;
var statearr_29775_29897 = state_29701__$1;
(statearr_29775_29897[(2)] = (-1));

(statearr_29775_29897[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (34))){
var inst_29482 = (state_29701[(54)]);
var state_29701__$1 = state_29701;
var statearr_29776_29898 = state_29701__$1;
(statearr_29776_29898[(2)] = inst_29482);

(statearr_29776_29898[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (17))){
var inst_29512 = (state_29701[(2)]);
var inst_29513 = fluree.db.util.async.throw_err(inst_29512);
var state_29701__$1 = state_29701;
var statearr_29777_29899 = state_29701__$1;
(statearr_29777_29899[(2)] = inst_29513);

(statearr_29777_29899[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (3))){
var inst_29699 = (state_29701[(2)]);
var state_29701__$1 = state_29701;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29701__$1,inst_29699);
} else {
if((state_val_29702 === (12))){
var inst_29479 = (state_29701[(50)]);
var inst_29507 = (state_29701[(2)]);
var inst_29508 = fluree.db.util.core.pred_ident_QMARK_(inst_29479);
var state_29701__$1 = (function (){var statearr_29778 = state_29701;
(statearr_29778[(24)] = inst_29507);

return statearr_29778;
})();
if(inst_29508){
var statearr_29779_29900 = state_29701__$1;
(statearr_29779_29900[(1)] = (14));

} else {
var statearr_29780_29901 = state_29701__$1;
(statearr_29780_29901[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (2))){
var inst_29477 = (state_29701[(14)]);
var inst_29476 = (state_29701[(30)]);
var inst_29483 = (state_29701[(41)]);
var _ = (function (){var statearr_29781 = state_29701;
(statearr_29781[(4)] = cljs.core.cons((5),(state_29701[(4)])));

return statearr_29781;
})();
var inst_29476__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_29477__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29476__$1,(0),null);
var inst_29478 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29476__$1,(1),null);
var inst_29479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29476__$1,(2),null);
var inst_29480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29476__$1,(3),null);
var inst_29481 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29476__$1,(4),null);
var inst_29482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29476__$1,(5),null);
var inst_29483__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_29484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29483__$1,(0),null);
var inst_29485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29483__$1,(1),null);
var inst_29486 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29483__$1,(2),null);
var inst_29487 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29483__$1,(3),null);
var inst_29488 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29483__$1,(4),null);
var inst_29489 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29483__$1,(5),null);
var inst_29490 = fluree.db.util.core.pred_ident_QMARK_(inst_29477__$1);
var state_29701__$1 = (function (){var statearr_29782 = state_29701;
(statearr_29782[(58)] = inst_29486);

(statearr_29782[(59)] = inst_29484);

(statearr_29782[(50)] = inst_29479);

(statearr_29782[(25)] = inst_29487);

(statearr_29782[(28)] = inst_29488);

(statearr_29782[(46)] = inst_29485);

(statearr_29782[(53)] = inst_29489);

(statearr_29782[(14)] = inst_29477__$1);

(statearr_29782[(30)] = inst_29476__$1);

(statearr_29782[(54)] = inst_29482);

(statearr_29782[(19)] = inst_29478);

(statearr_29782[(33)] = inst_29480);

(statearr_29782[(41)] = inst_29483__$1);

(statearr_29782[(42)] = inst_29481);

return statearr_29782;
})();
if(inst_29490){
var statearr_29783_29902 = state_29701__$1;
(statearr_29783_29902[(1)] = (6));

} else {
var statearr_29784_29903 = state_29701__$1;
(statearr_29784_29903[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (66))){
var inst_29632 = (state_29701[(55)]);
var inst_29642 = (state_29701[(60)]);
var inst_29640 = (state_29701[(13)]);
var inst_29639 = cljs.core.seq(inst_29632);
var inst_29640__$1 = cljs.core.first(inst_29639);
var inst_29641 = cljs.core.next(inst_29639);
var inst_29642__$1 = (inst_29640__$1 == null);
var state_29701__$1 = (function (){var statearr_29785 = state_29701;
(statearr_29785[(60)] = inst_29642__$1);

(statearr_29785[(61)] = inst_29641);

(statearr_29785[(13)] = inst_29640__$1);

return statearr_29785;
})();
if(cljs.core.truth_(inst_29642__$1)){
var statearr_29786_29904 = state_29701__$1;
(statearr_29786_29904[(1)] = (68));

} else {
var statearr_29787_29905 = state_29701__$1;
(statearr_29787_29905[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (23))){
var inst_29526 = (state_29701[(20)]);
var state_29701__$1 = state_29701;
var statearr_29788_29906 = state_29701__$1;
(statearr_29788_29906[(2)] = inst_29526);

(statearr_29788_29906[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (47))){
var state_29701__$1 = state_29701;
var statearr_29789_29907 = state_29701__$1;
(statearr_29789_29907[(2)] = fluree.db.util.core.max_long);

(statearr_29789_29907[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (35))){
var inst_29546 = (cljs.core._GT__EQ_ === start_test);
var state_29701__$1 = state_29701;
if(cljs.core.truth_(inst_29546)){
var statearr_29790_29908 = state_29701__$1;
(statearr_29790_29908[(1)] = (37));

} else {
var statearr_29791_29909 = state_29701__$1;
(statearr_29791_29909[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (82))){
var inst_29616 = (state_29701[(7)]);
var state_29701__$1 = state_29701;
var statearr_29792_29910 = state_29701__$1;
(statearr_29792_29910[(2)] = inst_29616);

(statearr_29792_29910[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (76))){
var inst_29641 = (state_29701[(61)]);
var inst_29651 = (state_29701[(23)]);
var inst_29665 = (state_29701[(2)]);
var inst_29632 = inst_29641;
var inst_29633 = inst_29651;
var inst_29634 = inst_29665;
var state_29701__$1 = (function (){var statearr_29793 = state_29701;
(statearr_29793[(55)] = inst_29632);

(statearr_29793[(22)] = inst_29633);

(statearr_29793[(52)] = inst_29634);

return statearr_29793;
})();
var statearr_29794_29911 = state_29701__$1;
(statearr_29794_29911[(2)] = null);

(statearr_29794_29911[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (19))){
var inst_29486 = (state_29701[(58)]);
var state_29701__$1 = state_29701;
var statearr_29795_29912 = state_29701__$1;
(statearr_29795_29912[(2)] = inst_29486);

(statearr_29795_29912[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (57))){
var inst_29590 = (state_29701[(26)]);
var inst_29580 = (state_29701[(34)]);
var inst_29600 = (state_29701[(11)]);
var inst_29579 = (state_29701[(39)]);
var inst_29604 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_29600,inst_29579,inst_29580,inst_29590);
var state_29701__$1 = state_29701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29701__$1,(59),inst_29604);
} else {
if((state_val_29702 === (68))){
var inst_29642 = (state_29701[(60)]);
var state_29701__$1 = state_29701;
var statearr_29796_29913 = state_29701__$1;
(statearr_29796_29913[(2)] = inst_29642);

(statearr_29796_29913[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (11))){
var inst_29484 = (state_29701[(59)]);
var state_29701__$1 = state_29701;
var statearr_29798_29914 = state_29701__$1;
(statearr_29798_29914[(2)] = inst_29484);

(statearr_29798_29914[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (9))){
var inst_29494 = (state_29701[(2)]);
var inst_29495 = fluree.db.util.async.throw_err(inst_29494);
var state_29701__$1 = state_29701;
var statearr_29799_29915 = state_29701__$1;
(statearr_29799_29915[(2)] = inst_29495);

(statearr_29799_29915[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (5))){
var _ = (function (){var statearr_29800 = state_29701;
(statearr_29800[(4)] = cljs.core.rest((state_29701[(4)])));

return statearr_29800;
})();
var state_29701__$1 = state_29701;
var ex29797 = (state_29701__$1[(2)]);
var statearr_29801_29916 = state_29701__$1;
(statearr_29801_29916[(5)] = ex29797);


if((ex29797 instanceof Error)){
var statearr_29802_29917 = state_29701__$1;
(statearr_29802_29917[(1)] = (4));

(statearr_29802_29917[(5)] = null);

} else {
throw ex29797;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (83))){
var inst_29684 = (state_29701[(2)]);
var inst_29685 = cljs.core.not(inst_29684);
var state_29701__$1 = state_29701;
if(inst_29685){
var statearr_29803_29918 = state_29701__$1;
(statearr_29803_29918[(1)] = (87));

} else {
var statearr_29804_29919 = state_29701__$1;
(statearr_29804_29919[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (14))){
var inst_29479 = (state_29701[(50)]);
var inst_29510 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29479);
var state_29701__$1 = state_29701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29701__$1,(17),inst_29510);
} else {
if((state_val_29702 === (45))){
var inst_29559 = (state_29701[(2)]);
var state_29701__$1 = state_29701;
var statearr_29805_29920 = state_29701__$1;
(statearr_29805_29920[(2)] = inst_29559);

(statearr_29805_29920[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (53))){
var state_29701__$1 = state_29701;
var statearr_29806_29921 = state_29701__$1;
(statearr_29806_29921[(2)] = true);

(statearr_29806_29921[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (78))){
var inst_29634 = (state_29701[(52)]);
var state_29701__$1 = state_29701;
var statearr_29807_29922 = state_29701__$1;
(statearr_29807_29922[(2)] = inst_29634);

(statearr_29807_29922[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (26))){
var inst_29478 = (state_29701[(19)]);
var state_29701__$1 = state_29701;
var statearr_29808_29923 = state_29701__$1;
(statearr_29808_29923[(2)] = inst_29478);

(statearr_29808_29923[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (16))){
var inst_29486 = (state_29701[(58)]);
var inst_29516 = (state_29701[(2)]);
var inst_29517 = fluree.db.util.core.pred_ident_QMARK_(inst_29486);
var state_29701__$1 = (function (){var statearr_29809 = state_29701;
(statearr_29809[(45)] = inst_29516);

return statearr_29809;
})();
if(inst_29517){
var statearr_29810_29924 = state_29701__$1;
(statearr_29810_29924[(1)] = (18));

} else {
var statearr_29811_29925 = state_29701__$1;
(statearr_29811_29925[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (81))){
var inst_29676 = (state_29701[(48)]);
var inst_29563 = (state_29701[(16)]);
var inst_29573 = (state_29701[(32)]);
var inst_29616 = (state_29701[(7)]);
var inst_29675 = (inst_29573.cljs$core$IFn$_invoke$arity$2 ? inst_29573.cljs$core$IFn$_invoke$arity$2(inst_29616,inst_29563) : inst_29573.call(null,inst_29616,inst_29563));
var inst_29676__$1 = (inst_29675 < (0));
var state_29701__$1 = (function (){var statearr_29812 = state_29701;
(statearr_29812[(48)] = inst_29676__$1);

return statearr_29812;
})();
if(cljs.core.truth_(inst_29676__$1)){
var statearr_29813_29926 = state_29701__$1;
(statearr_29813_29926[(1)] = (84));

} else {
var statearr_29814_29927 = state_29701__$1;
(statearr_29814_29927[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (79))){
var inst_29640 = (state_29701[(13)]);
var inst_29634 = (state_29701[(52)]);
var inst_29660 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_29634,inst_29640);
var state_29701__$1 = state_29701;
var statearr_29815_29928 = state_29701__$1;
(statearr_29815_29928[(2)] = inst_29660);

(statearr_29815_29928[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (38))){
var state_29701__$1 = state_29701;
var statearr_29816_29929 = state_29701__$1;
(statearr_29816_29929[(2)] = (2147483647));

(statearr_29816_29929[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (87))){
var inst_29672 = (state_29701[(8)]);
var state_29701__$1 = state_29701;
var statearr_29817_29930 = state_29701__$1;
(statearr_29817_29930[(2)] = inst_29672);

(statearr_29817_29930[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (30))){
var inst_29539 = (state_29701[(2)]);
var state_29701__$1 = state_29701;
if(cljs.core.truth_(inst_29539)){
var statearr_29818_29931 = state_29701__$1;
(statearr_29818_29931[(1)] = (31));

} else {
var statearr_29819_29932 = state_29701__$1;
(statearr_29819_29932[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (73))){
var inst_29668 = (state_29701[(2)]);
var state_29701__$1 = state_29701;
var statearr_29820_29933 = state_29701__$1;
(statearr_29820_29933[(2)] = inst_29668);

(statearr_29820_29933[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (10))){
var inst_29484 = (state_29701[(59)]);
var inst_29501 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29484);
var state_29701__$1 = state_29701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29701__$1,(13),inst_29501);
} else {
if((state_val_29702 === (18))){
var inst_29486 = (state_29701[(58)]);
var inst_29519 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29486);
var state_29701__$1 = state_29701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29701__$1,(21),inst_29519);
} else {
if((state_val_29702 === (52))){
var inst_29507 = (state_29701[(24)]);
var inst_29543 = (state_29701[(31)]);
var inst_29498 = (state_29701[(35)]);
var inst_29534 = (state_29701[(36)]);
var inst_29569 = (state_29701[(38)]);
var inst_29583 = fluree.db.permissions_validate.no_filter_QMARK_(inst_29569,inst_29498,inst_29507,inst_29534,inst_29543);
var state_29701__$1 = state_29701;
var statearr_29821_29934 = state_29701__$1;
(statearr_29821_29934[(2)] = inst_29583);

(statearr_29821_29934[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (67))){
var inst_29670 = (state_29701[(2)]);
var state_29701__$1 = state_29701;
var statearr_29822_29935 = state_29701__$1;
(statearr_29822_29935[(2)] = inst_29670);

(statearr_29822_29935[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (71))){
var inst_29602 = (state_29701[(43)]);
var inst_29634 = (state_29701[(52)]);
var inst_29649 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29634,inst_29602);
var state_29701__$1 = state_29701;
var statearr_29823_29936 = state_29701__$1;
(statearr_29823_29936[(2)] = inst_29649);

(statearr_29823_29936[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (42))){
var inst_29507 = (state_29701[(24)]);
var inst_29487 = (state_29701[(25)]);
var inst_29552 = (state_29701[(27)]);
var inst_29564 = (state_29701[(49)]);
var inst_29488 = (state_29701[(28)]);
var inst_29525 = (state_29701[(21)]);
var inst_29543 = (state_29701[(31)]);
var inst_29480 = (state_29701[(33)]);
var inst_29498 = (state_29701[(35)]);
var inst_29534 = (state_29701[(36)]);
var inst_29561 = (state_29701[(37)]);
var inst_29481 = (state_29701[(42)]);
var inst_29516 = (state_29701[(45)]);
var inst_29561__$1 = (state_29701[(2)]);
var inst_29562 = fluree.db.flake.__GT_Flake(inst_29498,inst_29534,inst_29516,inst_29480,inst_29481,inst_29552);
var inst_29563 = fluree.db.flake.__GT_Flake(inst_29507,inst_29543,inst_29525,inst_29487,inst_29488,inst_29561__$1);
var inst_29564__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_29701__$1 = (function (){var statearr_29824 = state_29701;
(statearr_29824[(49)] = inst_29564__$1);

(statearr_29824[(15)] = inst_29562);

(statearr_29824[(16)] = inst_29563);

(statearr_29824[(37)] = inst_29561__$1);

return statearr_29824;
})();
if(cljs.core.truth_(inst_29564__$1)){
var statearr_29825_29937 = state_29701__$1;
(statearr_29825_29937[(1)] = (46));

} else {
var statearr_29826_29938 = state_29701__$1;
(statearr_29826_29938[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (80))){
var inst_29662 = (state_29701[(2)]);
var state_29701__$1 = state_29701;
var statearr_29827_29939 = state_29701__$1;
(statearr_29827_29939[(2)] = inst_29662);

(statearr_29827_29939[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (37))){
var state_29701__$1 = state_29701;
var statearr_29828_29940 = state_29701__$1;
(statearr_29828_29940[(2)] = fluree.db.util.core.min_integer);

(statearr_29828_29940[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (63))){
var inst_29615 = (state_29701[(12)]);
var inst_29568 = (state_29701[(29)]);
var inst_29602 = (state_29701[(43)]);
var inst_29601 = (state_29701[(44)]);
var inst_29618 = (inst_29568 - inst_29601);
var inst_29619 = fluree.db.flake.take(inst_29618,inst_29615);
var inst_29620 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29619,inst_29602);
var state_29701__$1 = state_29701;
var statearr_29829_29941 = state_29701__$1;
(statearr_29829_29941[(2)] = inst_29620);

(statearr_29829_29941[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (8))){
var inst_29484 = (state_29701[(59)]);
var inst_29498 = (state_29701[(2)]);
var inst_29499 = fluree.db.util.core.pred_ident_QMARK_(inst_29484);
var state_29701__$1 = (function (){var statearr_29830 = state_29701;
(statearr_29830[(35)] = inst_29498);

return statearr_29830;
})();
if(inst_29499){
var statearr_29831_29942 = state_29701__$1;
(statearr_29831_29942[(1)] = (10));

} else {
var statearr_29832_29943 = state_29701__$1;
(statearr_29832_29943[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (49))){
var inst_29574 = (state_29701[(51)]);
var state_29701__$1 = state_29701;
var statearr_29833_29944 = state_29701__$1;
(statearr_29833_29944[(2)] = inst_29574);

(statearr_29833_29944[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29702 === (84))){
var inst_29568 = (state_29701[(29)]);
var inst_29673 = (state_29701[(9)]);
var inst_29678 = (inst_29673 < inst_29568);
var state_29701__$1 = state_29701;
var statearr_29834_29945 = state_29701__$1;
(statearr_29834_29945[(2)] = inst_29678);

(statearr_29834_29945[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16153__auto__ = null;
var fluree$db$query$range$state_machine__16153__auto____0 = (function (){
var statearr_29835 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29835[(0)] = fluree$db$query$range$state_machine__16153__auto__);

(statearr_29835[(1)] = (1));

return statearr_29835;
});
var fluree$db$query$range$state_machine__16153__auto____1 = (function (state_29701){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_29701);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e29836){var ex__16156__auto__ = e29836;
var statearr_29837_29946 = state_29701;
(statearr_29837_29946[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_29701[(4)]))){
var statearr_29838_29947 = state_29701;
(statearr_29838_29947[(1)] = cljs.core.first((state_29701[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__29948 = state_29701;
state_29701 = G__29948;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16153__auto__ = function(state_29701){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16153__auto____1.call(this,state_29701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16153__auto____0;
fluree$db$query$range$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16153__auto____1;
return fluree$db$query$range$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_29839 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_29839[(6)] = c__16227__auto__);

return statearr_29839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_30023){
var state_val_30024 = (state_30023[(1)]);
if((state_val_30024 === (7))){
var inst_30018 = (state_30023[(2)]);
var _ = (function (){var statearr_30025 = state_30023;
(statearr_30025[(4)] = cljs.core.rest((state_30023[(4)])));

return statearr_30025;
})();
var state_30023__$1 = state_30023;
var statearr_30026_30066 = state_30023__$1;
(statearr_30026_30066[(2)] = inst_30018);

(statearr_30026_30066[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (20))){
var inst_30000 = (state_30023[(2)]);
var inst_30001 = fluree.db.util.async.throw_err(inst_30000);
var state_30023__$1 = state_30023;
var statearr_30027_30067 = state_30023__$1;
(statearr_30027_30067[(2)] = inst_30001);

(statearr_30027_30067[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (1))){
var state_30023__$1 = state_30023;
var statearr_30028_30068 = state_30023__$1;
(statearr_30028_30068[(2)] = null);

(statearr_30028_30068[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (4))){
var inst_29949 = (state_30023[(2)]);
var state_30023__$1 = state_30023;
var statearr_30029_30069 = state_30023__$1;
(statearr_30029_30069[(2)] = inst_29949);

(statearr_30029_30069[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (15))){
var inst_29996 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_30023__$1 = state_30023;
if(cljs.core.truth_(inst_29996)){
var statearr_30030_30070 = state_30023__$1;
(statearr_30030_30070[(1)] = (17));

} else {
var statearr_30031_30071 = state_30023__$1;
(statearr_30031_30071[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (21))){
var state_30023__$1 = state_30023;
var statearr_30032_30072 = state_30023__$1;
(statearr_30032_30072[(2)] = (0));

(statearr_30032_30072[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (13))){
var inst_29988 = (state_30023[(2)]);
var state_30023__$1 = state_30023;
var statearr_30033_30073 = state_30023__$1;
(statearr_30033_30073[(2)] = inst_29988);

(statearr_30033_30073[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (22))){
var state_30023__$1 = state_30023;
var statearr_30034_30074 = state_30023__$1;
(statearr_30034_30074[(2)] = (1));

(statearr_30034_30074[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (6))){
var inst_29980 = (state_30023[(7)]);
var inst_29978 = (state_30023[(8)]);
var inst_29969 = (state_30023[(9)]);
var inst_29977 = cljs.core.seq(inst_29969);
var inst_29978__$1 = cljs.core.first(inst_29977);
var inst_29979 = cljs.core.next(inst_29977);
var inst_29980__$1 = (inst_29978__$1 == null);
var state_30023__$1 = (function (){var statearr_30035 = state_30023;
(statearr_30035[(7)] = inst_29980__$1);

(statearr_30035[(8)] = inst_29978__$1);

(statearr_30035[(10)] = inst_29979);

return statearr_30035;
})();
if(cljs.core.truth_(inst_29980__$1)){
var statearr_30036_30075 = state_30023__$1;
(statearr_30036_30075[(1)] = (8));

} else {
var statearr_30037_30076 = state_30023__$1;
(statearr_30037_30076[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (17))){
var inst_29978 = (state_30023[(8)]);
var inst_29998 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_29978);
var state_30023__$1 = state_30023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30023__$1,(20),inst_29998);
} else {
if((state_val_30024 === (3))){
var inst_30021 = (state_30023[(2)]);
var state_30023__$1 = state_30023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30023__$1,inst_30021);
} else {
if((state_val_30024 === (12))){
var inst_29971 = (state_30023[(11)]);
var inst_29986 = (inst_29971 >= subject_limit);
var state_30023__$1 = state_30023;
var statearr_30038_30077 = state_30023__$1;
(statearr_30038_30077[(2)] = inst_29986);

(statearr_30038_30077[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (2))){
var _ = (function (){var statearr_30039 = state_30023;
(statearr_30039[(4)] = cljs.core.cons((5),(state_30023[(4)])));

return statearr_30039;
})();
var inst_29962 = subject_groups;
var inst_29963 = cljs.core.seq(inst_29962);
var inst_29964 = cljs.core.first(inst_29963);
var inst_29965 = cljs.core.next(inst_29963);
var inst_29966 = flake_start;
var inst_29967 = subject_start;
var inst_29968 = cljs.core.PersistentVector.EMPTY;
var inst_29969 = inst_29962;
var inst_29970 = inst_29966;
var inst_29971 = inst_29967;
var inst_29972 = inst_29968;
var state_30023__$1 = (function (){var statearr_30040 = state_30023;
(statearr_30040[(12)] = inst_29970);

(statearr_30040[(11)] = inst_29971);

(statearr_30040[(13)] = inst_29964);

(statearr_30040[(9)] = inst_29969);

(statearr_30040[(14)] = inst_29965);

(statearr_30040[(15)] = inst_29972);

return statearr_30040;
})();
var statearr_30041_30078 = state_30023__$1;
(statearr_30041_30078[(2)] = null);

(statearr_30041_30078[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (23))){
var inst_29970 = (state_30023[(12)]);
var inst_30004 = (state_30023[(16)]);
var inst_29971 = (state_30023[(11)]);
var inst_29979 = (state_30023[(10)]);
var inst_30005 = (state_30023[(17)]);
var inst_29972 = (state_30023[(15)]);
var inst_30010 = (state_30023[(2)]);
var inst_30011 = (inst_29970 + inst_30005);
var inst_30012 = (inst_29971 + inst_30010);
var inst_30013 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29972,inst_30004);
var inst_29969 = inst_29979;
var inst_29970__$1 = inst_30011;
var inst_29971__$1 = inst_30012;
var inst_29972__$1 = inst_30013;
var state_30023__$1 = (function (){var statearr_30042 = state_30023;
(statearr_30042[(12)] = inst_29970__$1);

(statearr_30042[(11)] = inst_29971__$1);

(statearr_30042[(9)] = inst_29969);

(statearr_30042[(15)] = inst_29972__$1);

return statearr_30042;
})();
var statearr_30043_30079 = state_30023__$1;
(statearr_30043_30079[(2)] = null);

(statearr_30043_30079[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (19))){
var inst_30004 = (state_30023[(16)]);
var inst_30005 = (state_30023[(17)]);
var inst_30004__$1 = (state_30023[(2)]);
var inst_30005__$1 = cljs.core.count(inst_30004__$1);
var inst_30006 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_30005__$1);
var state_30023__$1 = (function (){var statearr_30044 = state_30023;
(statearr_30044[(16)] = inst_30004__$1);

(statearr_30044[(17)] = inst_30005__$1);

return statearr_30044;
})();
if(inst_30006){
var statearr_30045_30080 = state_30023__$1;
(statearr_30045_30080[(1)] = (21));

} else {
var statearr_30046_30081 = state_30023__$1;
(statearr_30046_30081[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (11))){
var inst_29983 = (state_30023[(18)]);
var state_30023__$1 = state_30023;
var statearr_30048_30082 = state_30023__$1;
(statearr_30048_30082[(2)] = inst_29983);

(statearr_30048_30082[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (9))){
var inst_29970 = (state_30023[(12)]);
var inst_29983 = (state_30023[(18)]);
var inst_29983__$1 = (inst_29970 >= flake_limit);
var state_30023__$1 = (function (){var statearr_30049 = state_30023;
(statearr_30049[(18)] = inst_29983__$1);

return statearr_30049;
})();
if(cljs.core.truth_(inst_29983__$1)){
var statearr_30050_30083 = state_30023__$1;
(statearr_30050_30083[(1)] = (11));

} else {
var statearr_30051_30084 = state_30023__$1;
(statearr_30051_30084[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (5))){
var _ = (function (){var statearr_30052 = state_30023;
(statearr_30052[(4)] = cljs.core.rest((state_30023[(4)])));

return statearr_30052;
})();
var state_30023__$1 = state_30023;
var ex30047 = (state_30023__$1[(2)]);
var statearr_30053_30085 = state_30023__$1;
(statearr_30053_30085[(5)] = ex30047);


if((ex30047 instanceof Error)){
var statearr_30054_30086 = state_30023__$1;
(statearr_30054_30086[(1)] = (4));

(statearr_30054_30086[(5)] = null);

} else {
throw ex30047;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (14))){
var inst_29970 = (state_30023[(12)]);
var inst_29971 = (state_30023[(11)]);
var inst_29972 = (state_30023[(15)]);
var inst_29992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29993 = [inst_29970,inst_29971,inst_29972];
var inst_29994 = (new cljs.core.PersistentVector(null,3,(5),inst_29992,inst_29993,null));
var state_30023__$1 = state_30023;
var statearr_30055_30087 = state_30023__$1;
(statearr_30055_30087[(2)] = inst_29994);

(statearr_30055_30087[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (16))){
var inst_30016 = (state_30023[(2)]);
var state_30023__$1 = state_30023;
var statearr_30056_30088 = state_30023__$1;
(statearr_30056_30088[(2)] = inst_30016);

(statearr_30056_30088[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (10))){
var inst_29990 = (state_30023[(2)]);
var state_30023__$1 = state_30023;
if(cljs.core.truth_(inst_29990)){
var statearr_30057_30089 = state_30023__$1;
(statearr_30057_30089[(1)] = (14));

} else {
var statearr_30058_30090 = state_30023__$1;
(statearr_30058_30090[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (18))){
var inst_29978 = (state_30023[(8)]);
var state_30023__$1 = state_30023;
var statearr_30059_30091 = state_30023__$1;
(statearr_30059_30091[(2)] = inst_29978);

(statearr_30059_30091[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30024 === (8))){
var inst_29980 = (state_30023[(7)]);
var state_30023__$1 = state_30023;
var statearr_30060_30092 = state_30023__$1;
(statearr_30060_30092[(2)] = inst_29980);

(statearr_30060_30092[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16153__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16153__auto____0 = (function (){
var statearr_30061 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30061[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16153__auto__);

(statearr_30061[(1)] = (1));

return statearr_30061;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16153__auto____1 = (function (state_30023){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_30023);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e30062){var ex__16156__auto__ = e30062;
var statearr_30063_30093 = state_30023;
(statearr_30063_30093[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_30023[(4)]))){
var statearr_30064_30094 = state_30023;
(statearr_30064_30094[(1)] = cljs.core.first((state_30023[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__30095 = state_30023;
state_30023 = G__30095;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16153__auto__ = function(state_30023){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16153__auto____1.call(this,state_30023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16153__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16153__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_30065 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_30065[(6)] = c__16227__auto__);

return statearr_30065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_30141){
var state_val_30142 = (state_30141[(1)]);
if((state_val_30142 === (7))){
var state_30141__$1 = state_30141;
var statearr_30143_30181 = state_30141__$1;
(statearr_30143_30181[(2)] = null);

(statearr_30143_30181[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (20))){
var inst_30127 = (state_30141[(2)]);
var inst_30128 = fluree.db.util.async.throw_err(inst_30127);
var inst_30106 = inst_30128;
var state_30141__$1 = (function (){var statearr_30144 = state_30141;
(statearr_30144[(7)] = inst_30106);

return statearr_30144;
})();
var statearr_30145_30182 = state_30141__$1;
(statearr_30145_30182[(2)] = null);

(statearr_30145_30182[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (1))){
var state_30141__$1 = state_30141;
var statearr_30146_30183 = state_30141__$1;
(statearr_30146_30183[(2)] = null);

(statearr_30146_30183[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (4))){
var inst_30096 = (state_30141[(2)]);
var state_30141__$1 = state_30141;
var statearr_30147_30184 = state_30141__$1;
(statearr_30147_30184[(2)] = inst_30096);

(statearr_30147_30184[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (15))){
var inst_30123 = (state_30141[(8)]);
var inst_30106 = (state_30141[(7)]);
var inst_30123__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_30106);
var state_30141__$1 = (function (){var statearr_30148 = state_30141;
(statearr_30148[(8)] = inst_30123__$1);

return statearr_30148;
})();
if(cljs.core.truth_(inst_30123__$1)){
var statearr_30149_30185 = state_30141__$1;
(statearr_30149_30185[(1)] = (17));

} else {
var statearr_30150_30186 = state_30141__$1;
(statearr_30150_30186[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (13))){
var inst_30116 = (state_30141[(2)]);
var inst_30117 = fluree.db.util.async.throw_err(inst_30116);
var _ = (function (){var statearr_30151 = state_30141;
(statearr_30151[(4)] = cljs.core.rest((state_30141[(4)])));

return statearr_30151;
})();
var state_30141__$1 = state_30141;
var statearr_30152_30187 = state_30141__$1;
(statearr_30152_30187[(2)] = inst_30117);

(statearr_30152_30187[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (6))){
var inst_30104 = (state_30141[(2)]);
var inst_30105 = fluree.db.util.async.throw_err(inst_30104);
var inst_30106 = inst_30105;
var state_30141__$1 = (function (){var statearr_30153 = state_30141;
(statearr_30153[(7)] = inst_30106);

return statearr_30153;
})();
var statearr_30154_30188 = state_30141__$1;
(statearr_30154_30188[(2)] = null);

(statearr_30154_30188[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (17))){
var inst_30123 = (state_30141[(8)]);
var inst_30125 = fluree.db.dbproto._lookup_leaf(root_node,inst_30123);
var state_30141__$1 = state_30141;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30141__$1,(20),inst_30125);
} else {
if((state_val_30142 === (3))){
var inst_30139 = (state_30141[(2)]);
var state_30141__$1 = state_30141;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30141__$1,inst_30139);
} else {
if((state_val_30142 === (12))){
var _ = (function (){var statearr_30156 = state_30141;
(statearr_30156[(4)] = cljs.core.rest((state_30141[(4)])));

return statearr_30156;
})();
var state_30141__$1 = state_30141;
var ex30155 = (state_30141__$1[(2)]);
var statearr_30157_30189 = state_30141__$1;
(statearr_30157_30189[(5)] = ex30155);


var statearr_30158_30190 = state_30141__$1;
(statearr_30158_30190[(1)] = (11));

(statearr_30158_30190[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (2))){
var _ = (function (){var statearr_30159 = state_30141;
(statearr_30159[(4)] = cljs.core.cons((5),(state_30141[(4)])));

return statearr_30159;
})();
var inst_30102 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_30141__$1 = state_30141;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30141__$1,(6),inst_30102);
} else {
if((state_val_30142 === (19))){
var inst_30132 = (state_30141[(2)]);
var state_30141__$1 = state_30141;
var statearr_30160_30191 = state_30141__$1;
(statearr_30160_30191[(2)] = inst_30132);

(statearr_30160_30191[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (11))){
var inst_30108 = (state_30141[(2)]);
var state_30141__$1 = (function (){var statearr_30162 = state_30141;
(statearr_30162[(9)] = inst_30108);

return statearr_30162;
})();
var statearr_30163_30192 = state_30141__$1;
(statearr_30163_30192[(2)] = null);

(statearr_30163_30192[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (9))){
var inst_30106 = (state_30141[(7)]);
var _ = (function (){var statearr_30164 = state_30141;
(statearr_30164[(4)] = cljs.core.cons((12),(state_30141[(4)])));

return statearr_30164;
})();
var inst_30114 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_30106,t,novelty,fast_forward_db_QMARK_);
var state_30141__$1 = state_30141;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30141__$1,(13),inst_30114);
} else {
if((state_val_30142 === (5))){
var _ = (function (){var statearr_30165 = state_30141;
(statearr_30165[(4)] = cljs.core.rest((state_30141[(4)])));

return statearr_30165;
})();
var state_30141__$1 = state_30141;
var ex30161 = (state_30141__$1[(2)]);
var statearr_30166_30193 = state_30141__$1;
(statearr_30166_30193[(5)] = ex30161);


if((ex30161 instanceof Error)){
var statearr_30167_30194 = state_30141__$1;
(statearr_30167_30194[(1)] = (4));

(statearr_30167_30194[(5)] = null);

} else {
throw ex30161;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (14))){
var inst_30120 = (state_30141[(10)]);
var state_30141__$1 = state_30141;
var statearr_30168_30195 = state_30141__$1;
(statearr_30168_30195[(2)] = inst_30120);

(statearr_30168_30195[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (16))){
var inst_30134 = (state_30141[(2)]);
var state_30141__$1 = state_30141;
var statearr_30169_30196 = state_30141__$1;
(statearr_30169_30196[(2)] = inst_30134);

(statearr_30169_30196[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (10))){
var inst_30120 = (state_30141[(10)]);
var inst_30120__$1 = (state_30141[(2)]);
var state_30141__$1 = (function (){var statearr_30170 = state_30141;
(statearr_30170[(10)] = inst_30120__$1);

return statearr_30170;
})();
if(cljs.core.truth_(inst_30120__$1)){
var statearr_30171_30197 = state_30141__$1;
(statearr_30171_30197[(1)] = (14));

} else {
var statearr_30172_30198 = state_30141__$1;
(statearr_30172_30198[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (18))){
var state_30141__$1 = state_30141;
var statearr_30173_30199 = state_30141__$1;
(statearr_30173_30199[(2)] = null);

(statearr_30173_30199[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30142 === (8))){
var inst_30136 = (state_30141[(2)]);
var _ = (function (){var statearr_30174 = state_30141;
(statearr_30174[(4)] = cljs.core.rest((state_30141[(4)])));

return statearr_30174;
})();
var state_30141__$1 = state_30141;
var statearr_30175_30200 = state_30141__$1;
(statearr_30175_30200[(2)] = inst_30136);

(statearr_30175_30200[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__16153__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__16153__auto____0 = (function (){
var statearr_30176 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30176[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__16153__auto__);

(statearr_30176[(1)] = (1));

return statearr_30176;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__16153__auto____1 = (function (state_30141){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_30141);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e30177){var ex__16156__auto__ = e30177;
var statearr_30178_30201 = state_30141;
(statearr_30178_30201[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_30141[(4)]))){
var statearr_30179_30202 = state_30141;
(statearr_30179_30202[(1)] = cljs.core.first((state_30141[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__30203 = state_30141;
state_30141 = G__30203;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__16153__auto__ = function(state_30141){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16153__auto____1.call(this,state_30141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__16153__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__16153__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_30180 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_30180[(6)] = c__16227__auto__);

return statearr_30180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__30210 = arguments.length;
switch (G__30210) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__30211 = (function (){var pred__30214 = cljs.core.identical_QMARK_;
var expr__30215 = test;
if(cljs.core.truth_((pred__30214.cljs$core$IFn$_invoke$arity$2 ? pred__30214.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__30215) : pred__30214.call(null,cljs.core._EQ_,expr__30215)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__30214.cljs$core$IFn$_invoke$arity$2 ? pred__30214.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__30215) : pred__30214.call(null,cljs.core._LT_,expr__30215)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__30214.cljs$core$IFn$_invoke$arity$2 ? pred__30214.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__30215) : pred__30214.call(null,cljs.core._LT__EQ_,expr__30215)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__30214.cljs$core$IFn$_invoke$arity$2 ? pred__30214.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__30215) : pred__30214.call(null,cljs.core._GT_,expr__30215)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__30214.cljs$core$IFn$_invoke$arity$2 ? pred__30214.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__30215) : pred__30214.call(null,cljs.core._GT__EQ_,expr__30215)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__30215)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30211,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30211,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30211,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30211,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_30587){
var state_val_30588 = (state_30587[(1)]);
if((state_val_30588 === (121))){
var inst_30543 = (state_30587[(7)]);
var state_30587__$1 = state_30587;
var statearr_30589_30785 = state_30587__$1;
(statearr_30589_30785[(2)] = inst_30543);

(statearr_30589_30785[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (65))){
var inst_30395 = (state_30587[(8)]);
var inst_30401 = (state_30587[(2)]);
var state_30587__$1 = (function (){var statearr_30590 = state_30587;
(statearr_30590[(9)] = inst_30401);

return statearr_30590;
})();
if(cljs.core.truth_(inst_30395)){
var statearr_30591_30786 = state_30587__$1;
(statearr_30591_30786[(1)] = (66));

} else {
var statearr_30592_30787 = state_30587__$1;
(statearr_30592_30787[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (70))){
var inst_30579 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
var statearr_30593_30788 = state_30587__$1;
(statearr_30593_30788[(2)] = inst_30579);

(statearr_30593_30788[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (62))){
var inst_30394 = (state_30587[(2)]);
var inst_30395 = fluree.db.util.async.throw_err(inst_30394);
var inst_30396 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_30587__$1 = (function (){var statearr_30594 = state_30587;
(statearr_30594[(8)] = inst_30395);

return statearr_30594;
})();
if(cljs.core.truth_(inst_30396)){
var statearr_30595_30789 = state_30587__$1;
(statearr_30595_30789[(1)] = (63));

} else {
var statearr_30596_30790 = state_30587__$1;
(statearr_30596_30790[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (74))){
var inst_30309 = (state_30587[(10)]);
var inst_30242 = (state_30587[(11)]);
var inst_30368 = (state_30587[(12)]);
var inst_30407 = (state_30587[(13)]);
var inst_30327 = (state_30587[(14)]);
var inst_30404 = (state_30587[(15)]);
var inst_30253 = (state_30587[(16)]);
var inst_30249 = (state_30587[(17)]);
var inst_30380 = (state_30587[(18)]);
var inst_30306 = (state_30587[(19)]);
var inst_30345 = (state_30587[(20)]);
var inst_30381 = (state_30587[(21)]);
var inst_30406 = (state_30587[(22)]);
var inst_30273 = (state_30587[(23)]);
var inst_30376 = (state_30587[(24)]);
var inst_30374 = (state_30587[(25)]);
var inst_30375 = (state_30587[(26)]);
var inst_30408 = (state_30587[(27)]);
var inst_30252 = (state_30587[(28)]);
var inst_30336 = (state_30587[(29)]);
var inst_30354 = (state_30587[(30)]);
var inst_30244 = (state_30587[(31)]);
var inst_30318 = (state_30587[(32)]);
var inst_30365 = (state_30587[(33)]);
var inst_30264 = (state_30587[(34)]);
var inst_30305 = (state_30587[(35)]);
var inst_30405 = (state_30587[(36)]);
var inst_30422 = (state_30587[(37)]);
var inst_30414 = (state_30587[(38)]);
var inst_30391 = (state_30587[(39)]);
var inst_30385 = (state_30587[(40)]);
var inst_30401 = (state_30587[(9)]);
var inst_30248 = (state_30587[(41)]);
var inst_30241 = (state_30587[(42)]);
var inst_30386 = (state_30587[(43)]);
var inst_30254 = (state_30587[(44)]);
var inst_30367 = (state_30587[(45)]);
var inst_30363 = (state_30587[(46)]);
var inst_30364 = (state_30587[(47)]);
var inst_30237 = (state_30587[(48)]);
var inst_30395 = (state_30587[(8)]);
var inst_30424 = (function (){var no_filter_QMARK_ = inst_30401;
var t = inst_30381;
var max_limit_QMARK_ = inst_30375;
var next_node = inst_30404;
var fast_forward_db_QMARK_ = inst_30386;
var s1 = inst_30264;
var o2 = inst_30327;
var t1 = inst_30241;
var predicate_fn = inst_30254;
var i = inst_30406;
var map__30229 = inst_30252;
var m1 = inst_30354;
var root_node = inst_30391;
var s2 = inst_30273;
var vec__30230 = inst_30305;
var p2 = inst_30345;
var vec__30233 = inst_30306;
var map__30236 = inst_30367;
var permissions = inst_30376;
var limit = inst_30374;
var start_flake = inst_30364;
var flake_limit = inst_30368;
var offset = inst_30405;
var acc = inst_30408;
var vec__30223 = inst_30237;
var vec__30226 = inst_30244;
var t2 = inst_30248;
var op1 = inst_30242;
var G__30415 = inst_30422;
var o1 = inst_30318;
var end_flake = inst_30365;
var base_result = inst_30414;
var s = inst_30407;
var node_start = inst_30395;
var p1 = inst_30336;
var subject_fn = inst_30253;
var object_fn = inst_30309;
var idx_compare = inst_30380;
var op2 = inst_30249;
var m2 = inst_30363;
var novelty = inst_30385;
return (function (p1__30205_SHARP_){
var G__30597 = p1__30205_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__30597) : subject_fn.call(null,G__30597));
});
})();
var inst_30425 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_30424,inst_30422);
var state_30587__$1 = state_30587;
var statearr_30598_30791 = state_30587__$1;
(statearr_30598_30791[(2)] = inst_30425);

(statearr_30598_30791[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (110))){
var inst_30556 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
var statearr_30599_30792 = state_30587__$1;
(statearr_30599_30792[(2)] = inst_30556);

(statearr_30599_30792[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (7))){
var inst_30238 = (state_30587[(49)]);
var state_30587__$1 = state_30587;
var statearr_30600_30793 = state_30587__$1;
(statearr_30600_30793[(2)] = inst_30238);

(statearr_30600_30793[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (59))){
var state_30587__$1 = state_30587;
var statearr_30601_30794 = state_30587__$1;
(statearr_30601_30794[(2)] = fluree.db.util.core.max_long);

(statearr_30601_30794[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (86))){
var inst_30401 = (state_30587[(9)]);
var state_30587__$1 = state_30587;
var statearr_30602_30795 = state_30587__$1;
(statearr_30602_30795[(2)] = inst_30401);

(statearr_30602_30795[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (20))){
var state_30587__$1 = state_30587;
var statearr_30603_30796 = state_30587__$1;
(statearr_30603_30796[(2)] = null);

(statearr_30603_30796[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (72))){
var inst_30414 = (state_30587[(38)]);
var state_30587__$1 = state_30587;
var statearr_30604_30797 = state_30587__$1;
(statearr_30604_30797[(2)] = inst_30414);

(statearr_30604_30797[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (58))){
var inst_30369 = (state_30587[(50)]);
var state_30587__$1 = state_30587;
var statearr_30605_30798 = state_30587__$1;
(statearr_30605_30798[(2)] = inst_30369);

(statearr_30605_30798[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (60))){
var inst_30374 = (state_30587[(25)]);
var inst_30374__$1 = (state_30587[(2)]);
var inst_30375 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30374__$1,fluree.db.util.core.max_long);
var inst_30376 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_30377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30378 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_30379 = (new cljs.core.PersistentVector(null,3,(5),inst_30377,inst_30378,null));
var inst_30380 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_30379);
var inst_30381 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_30382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30383 = [cljs.core.cst$kw$novelty,idx];
var inst_30384 = (new cljs.core.PersistentVector(null,2,(5),inst_30382,inst_30383,null));
var inst_30385 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_30384);
var inst_30386 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_30387 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_30388 = fluree.db.dbproto._resolve(inst_30387);
var state_30587__$1 = (function (){var statearr_30606 = state_30587;
(statearr_30606[(18)] = inst_30380);

(statearr_30606[(21)] = inst_30381);

(statearr_30606[(24)] = inst_30376);

(statearr_30606[(25)] = inst_30374__$1);

(statearr_30606[(26)] = inst_30375);

(statearr_30606[(40)] = inst_30385);

(statearr_30606[(43)] = inst_30386);

return statearr_30606;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30587__$1,(61),inst_30388);
} else {
if((state_val_30588 === (27))){
var inst_30307 = (state_30587[(51)]);
var state_30587__$1 = state_30587;
var statearr_30607_30799 = state_30587__$1;
(statearr_30607_30799[(2)] = inst_30307);

(statearr_30607_30799[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (1))){
var state_30587__$1 = state_30587;
var statearr_30608_30800 = state_30587__$1;
(statearr_30608_30800[(2)] = null);

(statearr_30608_30800[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (69))){
var inst_30404 = (state_30587[(15)]);
var inst_30365 = (state_30587[(33)]);
var inst_30364 = (state_30587[(47)]);
var inst_30413 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_30404);
var inst_30414 = fluree.db.flake.subrange(inst_30413,start_test,inst_30364,end_test,inst_30365);
var inst_30416 = fluree.db.query.range.value_with_nil_pred(idx,inst_30364,inst_30365);
var state_30587__$1 = (function (){var statearr_30609 = state_30587;
(statearr_30609[(38)] = inst_30414);

return statearr_30609;
})();
if(inst_30416){
var statearr_30610_30801 = state_30587__$1;
(statearr_30610_30801[(1)] = (71));

} else {
var statearr_30611_30802 = state_30587__$1;
(statearr_30611_30802[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (101))){
var inst_30368 = (state_30587[(12)]);
var inst_30500 = (state_30587[(52)]);
var inst_30502 = (state_30587[(53)]);
var inst_30501 = (state_30587[(54)]);
var inst_30505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30506 = (inst_30502 - inst_30368);
var inst_30507 = (inst_30501 - inst_30506);
var inst_30508 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_30507,inst_30500);
var inst_30509 = [inst_30368,inst_30508];
var inst_30510 = (new cljs.core.PersistentVector(null,2,(5),inst_30505,inst_30509,null));
var state_30587__$1 = state_30587;
var statearr_30612_30803 = state_30587__$1;
(statearr_30612_30803[(2)] = inst_30510);

(statearr_30612_30803[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (24))){
var inst_30242 = (state_30587[(11)]);
var inst_30243 = (state_30587[(55)]);
var inst_30287 = (state_30587[(56)]);
var inst_30240 = (state_30587[(57)]);
var inst_30250 = (state_30587[(58)]);
var inst_30253 = (state_30587[(16)]);
var inst_30249 = (state_30587[(17)]);
var inst_30255 = (state_30587[(59)]);
var inst_30273 = (state_30587[(23)]);
var inst_30247 = (state_30587[(60)]);
var inst_30239 = (state_30587[(61)]);
var inst_30252 = (state_30587[(28)]);
var inst_30244 = (state_30587[(31)]);
var inst_30264 = (state_30587[(34)]);
var inst_30248 = (state_30587[(41)]);
var inst_30241 = (state_30587[(42)]);
var inst_30254 = (state_30587[(44)]);
var inst_30246 = (state_30587[(62)]);
var inst_30237 = (state_30587[(48)]);
var inst_30297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30299 = [null,null];
var inst_30300 = (new cljs.core.PersistentVector(null,2,(5),inst_30298,inst_30299,null));
var inst_30301 = (function (){var bool = inst_30287;
var s1 = inst_30264;
var o2 = inst_30247;
var t1 = inst_30241;
var predicate_fn = inst_30254;
var map__30229 = inst_30252;
var m1 = inst_30243;
var s2 = inst_30273;
var p2 = inst_30246;
var vec__30223 = inst_30237;
var vec__30226 = inst_30244;
var t2 = inst_30248;
var op1 = inst_30242;
var o1 = inst_30240;
var p1 = inst_30239;
var subject_fn = inst_30253;
var object_fn = inst_30255;
var op2 = inst_30249;
var m2 = inst_30250;
var temp__5755__auto__ = inst_30287;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_30302 = [inst_30300,inst_30301];
var inst_30303 = (new cljs.core.PersistentVector(null,2,(5),inst_30297,inst_30302,null));
var state_30587__$1 = state_30587;
var statearr_30613_30804 = state_30587__$1;
(statearr_30613_30804[(2)] = inst_30303);

(statearr_30613_30804[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (102))){
var inst_30500 = (state_30587[(52)]);
var inst_30502 = (state_30587[(53)]);
var inst_30512 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30513 = [inst_30502,inst_30500];
var inst_30514 = (new cljs.core.PersistentVector(null,2,(5),inst_30512,inst_30513,null));
var state_30587__$1 = state_30587;
var statearr_30614_30805 = state_30587__$1;
(statearr_30614_30805[(2)] = inst_30514);

(statearr_30614_30805[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (55))){
var state_30587__$1 = state_30587;
var statearr_30615_30806 = state_30587__$1;
(statearr_30615_30806[(2)] = (2147483647));

(statearr_30615_30806[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (85))){
var inst_30450 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
if(cljs.core.truth_(inst_30450)){
var statearr_30616_30807 = state_30587__$1;
(statearr_30616_30807[(1)] = (89));

} else {
var statearr_30617_30808 = state_30587__$1;
(statearr_30617_30808[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (39))){
var inst_30337 = (state_30587[(63)]);
var inst_30246 = (state_30587[(62)]);
var inst_30336 = (state_30587[(2)]);
var inst_30337__$1 = (inst_30246 == null);
var state_30587__$1 = (function (){var statearr_30618 = state_30587;
(statearr_30618[(63)] = inst_30337__$1);

(statearr_30618[(29)] = inst_30336);

return statearr_30618;
})();
if(cljs.core.truth_(inst_30337__$1)){
var statearr_30619_30809 = state_30587__$1;
(statearr_30619_30809[(1)] = (40));

} else {
var statearr_30620_30810 = state_30587__$1;
(statearr_30620_30810[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (88))){
var inst_30447 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
var statearr_30621_30811 = state_30587__$1;
(statearr_30621_30811[(2)] = inst_30447);

(statearr_30621_30811[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (46))){
var inst_30243 = (state_30587[(55)]);
var state_30587__$1 = state_30587;
var statearr_30622_30812 = state_30587__$1;
(statearr_30622_30812[(2)] = inst_30243);

(statearr_30622_30812[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (4))){
var inst_30217 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
var statearr_30623_30813 = state_30587__$1;
(statearr_30623_30813[(2)] = inst_30217);

(statearr_30623_30813[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (77))){
var inst_30309 = (state_30587[(10)]);
var inst_30242 = (state_30587[(11)]);
var inst_30368 = (state_30587[(12)]);
var inst_30407 = (state_30587[(13)]);
var inst_30327 = (state_30587[(14)]);
var inst_30404 = (state_30587[(15)]);
var inst_30428 = (state_30587[(64)]);
var inst_30253 = (state_30587[(16)]);
var inst_30249 = (state_30587[(17)]);
var inst_30380 = (state_30587[(18)]);
var inst_30306 = (state_30587[(19)]);
var inst_30345 = (state_30587[(20)]);
var inst_30381 = (state_30587[(21)]);
var inst_30406 = (state_30587[(22)]);
var inst_30273 = (state_30587[(23)]);
var inst_30376 = (state_30587[(24)]);
var inst_30374 = (state_30587[(25)]);
var inst_30375 = (state_30587[(26)]);
var inst_30408 = (state_30587[(27)]);
var inst_30252 = (state_30587[(28)]);
var inst_30336 = (state_30587[(29)]);
var inst_30354 = (state_30587[(30)]);
var inst_30244 = (state_30587[(31)]);
var inst_30318 = (state_30587[(32)]);
var inst_30365 = (state_30587[(33)]);
var inst_30264 = (state_30587[(34)]);
var inst_30305 = (state_30587[(35)]);
var inst_30405 = (state_30587[(36)]);
var inst_30414 = (state_30587[(38)]);
var inst_30391 = (state_30587[(39)]);
var inst_30385 = (state_30587[(40)]);
var inst_30401 = (state_30587[(9)]);
var inst_30248 = (state_30587[(41)]);
var inst_30241 = (state_30587[(42)]);
var inst_30386 = (state_30587[(43)]);
var inst_30254 = (state_30587[(44)]);
var inst_30367 = (state_30587[(45)]);
var inst_30363 = (state_30587[(46)]);
var inst_30364 = (state_30587[(47)]);
var inst_30237 = (state_30587[(48)]);
var inst_30395 = (state_30587[(8)]);
var inst_30430 = (function (){var no_filter_QMARK_ = inst_30401;
var t = inst_30381;
var max_limit_QMARK_ = inst_30375;
var next_node = inst_30404;
var fast_forward_db_QMARK_ = inst_30386;
var s1 = inst_30264;
var o2 = inst_30327;
var t1 = inst_30241;
var predicate_fn = inst_30254;
var i = inst_30406;
var map__30229 = inst_30252;
var m1 = inst_30354;
var root_node = inst_30391;
var s2 = inst_30273;
var vec__30230 = inst_30305;
var p2 = inst_30345;
var vec__30233 = inst_30306;
var map__30236 = inst_30367;
var permissions = inst_30376;
var limit = inst_30374;
var start_flake = inst_30364;
var flake_limit = inst_30368;
var offset = inst_30405;
var acc = inst_30408;
var vec__30223 = inst_30237;
var vec__30226 = inst_30244;
var t2 = inst_30248;
var op1 = inst_30242;
var G__30415 = inst_30428;
var o1 = inst_30318;
var end_flake = inst_30365;
var base_result = inst_30414;
var s = inst_30407;
var node_start = inst_30395;
var p1 = inst_30336;
var subject_fn = inst_30253;
var object_fn = inst_30309;
var idx_compare = inst_30380;
var op2 = inst_30249;
var m2 = inst_30363;
var novelty = inst_30385;
return (function (p1__30206_SHARP_){
var G__30624 = p1__30206_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__30624) : predicate_fn.call(null,G__30624));
});
})();
var inst_30431 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_30430,inst_30428);
var state_30587__$1 = state_30587;
var statearr_30625_30814 = state_30587__$1;
(statearr_30625_30814[(2)] = inst_30431);

(statearr_30625_30814[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (106))){
var inst_30441 = (state_30587[(65)]);
var state_30587__$1 = state_30587;
var statearr_30626_30815 = state_30587__$1;
(statearr_30626_30815[(2)] = inst_30441);

(statearr_30626_30815[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (119))){
var inst_30559 = (state_30587[(66)]);
var state_30587__$1 = state_30587;
var statearr_30627_30816 = state_30587__$1;
(statearr_30627_30816[(2)] = inst_30559);

(statearr_30627_30816[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (95))){
var inst_30474 = (state_30587[(67)]);
var inst_30407 = (state_30587[(13)]);
var inst_30483 = (state_30587[(68)]);
var inst_30374 = (state_30587[(25)]);
var inst_30484 = (state_30587[(69)]);
var inst_30482 = (state_30587[(70)]);
var inst_30482__$1 = cljs.core.count(inst_30474);
var inst_30483__$1 = (inst_30407 + inst_30482__$1);
var inst_30484__$1 = (inst_30483__$1 - inst_30374);
var inst_30485 = cljs.core.pos_int_QMARK_(inst_30484__$1);
var state_30587__$1 = (function (){var statearr_30628 = state_30587;
(statearr_30628[(68)] = inst_30483__$1);

(statearr_30628[(69)] = inst_30484__$1);

(statearr_30628[(70)] = inst_30482__$1);

return statearr_30628;
})();
if(inst_30485){
var statearr_30629_30817 = state_30587__$1;
(statearr_30629_30817[(1)] = (98));

} else {
var statearr_30630_30818 = state_30587__$1;
(statearr_30630_30818[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (54))){
var inst_30242 = (state_30587[(11)]);
var inst_30327 = (state_30587[(14)]);
var inst_30249 = (state_30587[(17)]);
var inst_30345 = (state_30587[(20)]);
var inst_30273 = (state_30587[(23)]);
var inst_30336 = (state_30587[(29)]);
var inst_30354 = (state_30587[(30)]);
var inst_30369 = (state_30587[(50)]);
var inst_30318 = (state_30587[(32)]);
var inst_30264 = (state_30587[(34)]);
var inst_30248 = (state_30587[(41)]);
var inst_30241 = (state_30587[(42)]);
var inst_30367 = (state_30587[(45)]);
var inst_30363 = (state_30587[(46)]);
var inst_30363__$1 = (state_30587[(2)]);
var inst_30364 = fluree.db.flake.__GT_Flake(inst_30264,inst_30336,inst_30318,inst_30241,inst_30242,inst_30354);
var inst_30365 = fluree.db.flake.__GT_Flake(inst_30273,inst_30345,inst_30327,inst_30248,inst_30249,inst_30363__$1);
var inst_30366 = opts;
var inst_30367__$1 = cljs.core.__destructure_map(inst_30366);
var inst_30368 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_30367__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_30369__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30367__$1,cljs.core.cst$kw$limit);
var inst_30370 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_30367__$1,cljs.core.cst$kw$offset,(0));
var state_30587__$1 = (function (){var statearr_30631 = state_30587;
(statearr_30631[(12)] = inst_30368);

(statearr_30631[(71)] = inst_30370);

(statearr_30631[(50)] = inst_30369__$1);

(statearr_30631[(33)] = inst_30365);

(statearr_30631[(45)] = inst_30367__$1);

(statearr_30631[(46)] = inst_30363__$1);

(statearr_30631[(47)] = inst_30364);

return statearr_30631;
})();
if(cljs.core.truth_(inst_30369__$1)){
var statearr_30632_30819 = state_30587__$1;
(statearr_30632_30819[(1)] = (58));

} else {
var statearr_30633_30820 = state_30587__$1;
(statearr_30633_30820[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (92))){
var inst_30407 = (state_30587[(13)]);
var inst_30463 = (state_30587[(72)]);
var inst_30406 = (state_30587[(22)]);
var inst_30408 = (state_30587[(27)]);
var inst_30405 = (state_30587[(36)]);
var inst_30466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30467 = (inst_30405 - inst_30463);
var inst_30468 = [inst_30467,inst_30406,inst_30407,inst_30408];
var inst_30469 = (new cljs.core.PersistentVector(null,4,(5),inst_30466,inst_30468,null));
var state_30587__$1 = state_30587;
var statearr_30634_30821 = state_30587__$1;
(statearr_30634_30821[(2)] = inst_30469);

(statearr_30634_30821[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (104))){
var inst_30525 = (state_30587[(2)]);
var inst_30526 = fluree.db.util.async.throw_err(inst_30525);
var state_30587__$1 = state_30587;
var statearr_30635_30822 = state_30587__$1;
(statearr_30635_30822[(2)] = inst_30526);

(statearr_30635_30822[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (15))){
var inst_30247 = (state_30587[(60)]);
var inst_30277 = cljs.core.boolean_QMARK_(inst_30247);
var state_30587__$1 = state_30587;
if(inst_30277){
var statearr_30636_30823 = state_30587__$1;
(statearr_30636_30823[(1)] = (17));

} else {
var statearr_30637_30824 = state_30587__$1;
(statearr_30637_30824[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (48))){
var inst_30250 = (state_30587[(58)]);
var inst_30354 = (state_30587[(2)]);
var state_30587__$1 = (function (){var statearr_30638 = state_30587;
(statearr_30638[(30)] = inst_30354);

return statearr_30638;
})();
if(cljs.core.truth_(inst_30250)){
var statearr_30639_30825 = state_30587__$1;
(statearr_30639_30825[(1)] = (52));

} else {
var statearr_30640_30826 = state_30587__$1;
(statearr_30640_30826[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (50))){
var state_30587__$1 = state_30587;
var statearr_30641_30827 = state_30587__$1;
(statearr_30641_30827[(2)] = (2147483647));

(statearr_30641_30827[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (116))){
var inst_30559 = (state_30587[(66)]);
var inst_30567 = (state_30587[(2)]);
var state_30587__$1 = (function (){var statearr_30642 = state_30587;
(statearr_30642[(73)] = inst_30567);

return statearr_30642;
})();
if(cljs.core.truth_(inst_30559)){
var statearr_30643_30828 = state_30587__$1;
(statearr_30643_30828[(1)] = (118));

} else {
var statearr_30644_30829 = state_30587__$1;
(statearr_30644_30829[(1)] = (119));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (75))){
var inst_30422 = (state_30587[(37)]);
var state_30587__$1 = state_30587;
var statearr_30645_30830 = state_30587__$1;
(statearr_30645_30830[(2)] = inst_30422);

(statearr_30645_30830[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (99))){
var inst_30483 = (state_30587[(68)]);
var inst_30492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30493 = [inst_30483,inst_30483];
var inst_30494 = (new cljs.core.PersistentVector(null,2,(5),inst_30492,inst_30493,null));
var state_30587__$1 = state_30587;
var statearr_30646_30831 = state_30587__$1;
(statearr_30646_30831[(2)] = inst_30494);

(statearr_30646_30831[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (21))){
var state_30587__$1 = state_30587;
var statearr_30647_30832 = state_30587__$1;
(statearr_30647_30832[(2)] = null);

(statearr_30647_30832[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (31))){
var inst_30308 = (state_30587[(74)]);
var state_30587__$1 = state_30587;
var statearr_30648_30833 = state_30587__$1;
(statearr_30648_30833[(2)] = inst_30308);

(statearr_30648_30833[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (113))){
var inst_30553 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
var statearr_30649_30834 = state_30587__$1;
(statearr_30649_30834[(2)] = inst_30553);

(statearr_30649_30834[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (32))){
var inst_30328 = (state_30587[(75)]);
var inst_30239 = (state_30587[(61)]);
var inst_30327 = (state_30587[(2)]);
var inst_30328__$1 = (inst_30239 == null);
var state_30587__$1 = (function (){var statearr_30650 = state_30587;
(statearr_30650[(14)] = inst_30327);

(statearr_30650[(75)] = inst_30328__$1);

return statearr_30650;
})();
if(cljs.core.truth_(inst_30328__$1)){
var statearr_30651_30835 = state_30587__$1;
(statearr_30651_30835[(1)] = (34));

} else {
var statearr_30652_30836 = state_30587__$1;
(statearr_30652_30836[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (40))){
var inst_30327 = (state_30587[(14)]);
var state_30587__$1 = state_30587;
var statearr_30653_30837 = state_30587__$1;
(statearr_30653_30837[(2)] = inst_30327);

(statearr_30653_30837[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (91))){
var inst_30441 = (state_30587[(65)]);
var inst_30539 = (state_30587[(2)]);
var inst_30540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30539,(0),null);
var inst_30541 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30539,(1),null);
var inst_30542 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30539,(2),null);
var inst_30543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30539,(3),null);
var state_30587__$1 = (function (){var statearr_30654 = state_30587;
(statearr_30654[(76)] = inst_30542);

(statearr_30654[(77)] = inst_30540);

(statearr_30654[(7)] = inst_30543);

(statearr_30654[(78)] = inst_30541);

return statearr_30654;
})();
if(cljs.core.truth_(inst_30441)){
var statearr_30655_30838 = state_30587__$1;
(statearr_30655_30838[(1)] = (105));

} else {
var statearr_30656_30839 = state_30587__$1;
(statearr_30656_30839[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (117))){
var inst_30563 = (state_30587[(2)]);
var inst_30564 = fluree.db.util.async.throw_err(inst_30563);
var state_30587__$1 = state_30587;
var statearr_30657_30840 = state_30587__$1;
(statearr_30657_30840[(2)] = inst_30564);

(statearr_30657_30840[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (108))){
var inst_30368 = (state_30587[(12)]);
var inst_30548 = (state_30587[(79)]);
var inst_30541 = (state_30587[(78)]);
var inst_30548__$1 = (inst_30541 < inst_30368);
var state_30587__$1 = (function (){var statearr_30658 = state_30587;
(statearr_30658[(79)] = inst_30548__$1);

return statearr_30658;
})();
if(cljs.core.truth_(inst_30548__$1)){
var statearr_30659_30841 = state_30587__$1;
(statearr_30659_30841[(1)] = (111));

} else {
var statearr_30660_30842 = state_30587__$1;
(statearr_30660_30842[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (56))){
var state_30587__$1 = state_30587;
var statearr_30661_30843 = state_30587__$1;
(statearr_30661_30843[(2)] = fluree.db.util.core.min_integer);

(statearr_30661_30843[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (33))){
var inst_30323 = (state_30587[(2)]);
var inst_30324 = fluree.db.util.async.throw_err(inst_30323);
var state_30587__$1 = state_30587;
var statearr_30662_30844 = state_30587__$1;
(statearr_30662_30844[(2)] = inst_30324);

(statearr_30662_30844[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (13))){
var inst_30269 = (state_30587[(2)]);
var inst_30270 = fluree.db.util.async.throw_err(inst_30269);
var state_30587__$1 = state_30587;
var statearr_30663_30845 = state_30587__$1;
(statearr_30663_30845[(2)] = inst_30270);

(statearr_30663_30845[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (22))){
var inst_30283 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
var statearr_30664_30846 = state_30587__$1;
(statearr_30664_30846[(2)] = inst_30283);

(statearr_30664_30846[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (90))){
var inst_30309 = (state_30587[(10)]);
var inst_30242 = (state_30587[(11)]);
var inst_30368 = (state_30587[(12)]);
var inst_30407 = (state_30587[(13)]);
var inst_30327 = (state_30587[(14)]);
var inst_30404 = (state_30587[(15)]);
var inst_30463 = (state_30587[(72)]);
var inst_30462 = (state_30587[(80)]);
var inst_30253 = (state_30587[(16)]);
var inst_30249 = (state_30587[(17)]);
var inst_30380 = (state_30587[(18)]);
var inst_30306 = (state_30587[(19)]);
var inst_30345 = (state_30587[(20)]);
var inst_30441 = (state_30587[(65)]);
var inst_30381 = (state_30587[(21)]);
var inst_30406 = (state_30587[(22)]);
var inst_30273 = (state_30587[(23)]);
var inst_30376 = (state_30587[(24)]);
var inst_30374 = (state_30587[(25)]);
var inst_30375 = (state_30587[(26)]);
var inst_30408 = (state_30587[(27)]);
var inst_30252 = (state_30587[(28)]);
var inst_30336 = (state_30587[(29)]);
var inst_30354 = (state_30587[(30)]);
var inst_30244 = (state_30587[(31)]);
var inst_30318 = (state_30587[(32)]);
var inst_30365 = (state_30587[(33)]);
var inst_30264 = (state_30587[(34)]);
var inst_30440 = (state_30587[(81)]);
var inst_30305 = (state_30587[(35)]);
var inst_30405 = (state_30587[(36)]);
var inst_30414 = (state_30587[(38)]);
var inst_30391 = (state_30587[(39)]);
var inst_30385 = (state_30587[(40)]);
var inst_30401 = (state_30587[(9)]);
var inst_30248 = (state_30587[(41)]);
var inst_30241 = (state_30587[(42)]);
var inst_30386 = (state_30587[(43)]);
var inst_30254 = (state_30587[(44)]);
var inst_30367 = (state_30587[(45)]);
var inst_30363 = (state_30587[(46)]);
var inst_30364 = (state_30587[(47)]);
var inst_30237 = (state_30587[(48)]);
var inst_30395 = (state_30587[(8)]);
var inst_30461 = (function (){var no_filter_QMARK_ = inst_30401;
var base_result_SINGLEQUOTE_ = inst_30440;
var t = inst_30381;
var max_limit_QMARK_ = inst_30375;
var next_node = inst_30404;
var fast_forward_db_QMARK_ = inst_30386;
var s1 = inst_30264;
var o2 = inst_30327;
var t1 = inst_30241;
var predicate_fn = inst_30254;
var i = inst_30406;
var rhs = inst_30441;
var map__30229 = inst_30252;
var m1 = inst_30354;
var root_node = inst_30391;
var s2 = inst_30273;
var vec__30230 = inst_30305;
var p2 = inst_30345;
var vec__30233 = inst_30306;
var map__30236 = inst_30367;
var permissions = inst_30376;
var limit = inst_30374;
var start_flake = inst_30364;
var flake_limit = inst_30368;
var offset = inst_30405;
var acc = inst_30408;
var vec__30223 = inst_30237;
var vec__30226 = inst_30244;
var t2 = inst_30248;
var op1 = inst_30242;
var o1 = inst_30318;
var end_flake = inst_30365;
var base_result = inst_30414;
var s = inst_30407;
var node_start = inst_30395;
var p1 = inst_30336;
var subject_fn = inst_30253;
var object_fn = inst_30309;
var idx_compare = inst_30380;
var op2 = inst_30249;
var m2 = inst_30363;
var novelty = inst_30385;
return (function (p1__30208_SHARP_){
return p1__30208_SHARP_.s;
});
})();
var inst_30462__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_30461,inst_30440);
var inst_30463__$1 = cljs.core.count(inst_30462__$1);
var inst_30464 = (inst_30405 > inst_30463__$1);
var state_30587__$1 = (function (){var statearr_30665 = state_30587;
(statearr_30665[(72)] = inst_30463__$1);

(statearr_30665[(80)] = inst_30462__$1);

return statearr_30665;
})();
if(cljs.core.truth_(inst_30464)){
var statearr_30666_30847 = state_30587__$1;
(statearr_30666_30847[(1)] = (92));

} else {
var statearr_30667_30848 = state_30587__$1;
(statearr_30667_30848[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (109))){
var inst_30546 = (state_30587[(82)]);
var state_30587__$1 = state_30587;
var statearr_30668_30849 = state_30587__$1;
(statearr_30668_30849[(2)] = inst_30546);

(statearr_30668_30849[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (36))){
var inst_30332 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
if(cljs.core.truth_(inst_30332)){
var statearr_30669_30850 = state_30587__$1;
(statearr_30669_30850[(1)] = (37));

} else {
var statearr_30670_30851 = state_30587__$1;
(statearr_30670_30851[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (41))){
var inst_30337 = (state_30587[(63)]);
var state_30587__$1 = state_30587;
var statearr_30671_30852 = state_30587__$1;
(statearr_30671_30852[(2)] = inst_30337);

(statearr_30671_30852[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (118))){
var inst_30567 = (state_30587[(73)]);
var state_30587__$1 = state_30587;
var statearr_30672_30853 = state_30587__$1;
(statearr_30672_30853[(2)] = inst_30567);

(statearr_30672_30853[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (89))){
var inst_30368 = (state_30587[(12)]);
var inst_30407 = (state_30587[(13)]);
var inst_30406 = (state_30587[(22)]);
var inst_30408 = (state_30587[(27)]);
var inst_30440 = (state_30587[(81)]);
var inst_30452 = cljs.core.count(inst_30440);
var inst_30453 = (inst_30368 - inst_30406);
var inst_30454 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_30453,inst_30440);
var inst_30455 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30408,inst_30454);
var inst_30456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30457 = (inst_30406 + inst_30452);
var inst_30458 = [(0),inst_30457,inst_30407,inst_30455];
var inst_30459 = (new cljs.core.PersistentVector(null,4,(5),inst_30456,inst_30458,null));
var state_30587__$1 = state_30587;
var statearr_30673_30854 = state_30587__$1;
(statearr_30673_30854[(2)] = inst_30459);

(statearr_30673_30854[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (100))){
var inst_30368 = (state_30587[(12)]);
var inst_30474 = (state_30587[(67)]);
var inst_30406 = (state_30587[(22)]);
var inst_30500 = (state_30587[(52)]);
var inst_30502 = (state_30587[(53)]);
var inst_30501 = (state_30587[(54)]);
var inst_30496 = (state_30587[(2)]);
var inst_30497 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30496,(0),null);
var inst_30498 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30496,(1),null);
var inst_30499 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_30498,inst_30474);
var inst_30500__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_30499);
var inst_30501__$1 = cljs.core.count(inst_30500__$1);
var inst_30502__$1 = (inst_30406 + inst_30501__$1);
var inst_30503 = (inst_30502__$1 > inst_30368);
var state_30587__$1 = (function (){var statearr_30674 = state_30587;
(statearr_30674[(83)] = inst_30497);

(statearr_30674[(52)] = inst_30500__$1);

(statearr_30674[(53)] = inst_30502__$1);

(statearr_30674[(54)] = inst_30501__$1);

return statearr_30674;
})();
if(cljs.core.truth_(inst_30503)){
var statearr_30675_30855 = state_30587__$1;
(statearr_30675_30855[(1)] = (101));

} else {
var statearr_30676_30856 = state_30587__$1;
(statearr_30676_30856[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (122))){
var inst_30567 = (state_30587[(73)]);
var inst_30542 = (state_30587[(76)]);
var inst_30540 = (state_30587[(77)]);
var inst_30543 = (state_30587[(7)]);
var inst_30541 = (state_30587[(78)]);
var inst_30404 = inst_30567;
var inst_30405 = inst_30540;
var inst_30406 = inst_30541;
var inst_30407 = inst_30542;
var inst_30408 = inst_30543;
var state_30587__$1 = (function (){var statearr_30677 = state_30587;
(statearr_30677[(13)] = inst_30407);

(statearr_30677[(15)] = inst_30404);

(statearr_30677[(22)] = inst_30406);

(statearr_30677[(27)] = inst_30408);

(statearr_30677[(36)] = inst_30405);

return statearr_30677;
})();
var statearr_30678_30857 = state_30587__$1;
(statearr_30678_30857[(2)] = null);

(statearr_30678_30857[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (43))){
var state_30587__$1 = state_30587;
var statearr_30679_30858 = state_30587__$1;
(statearr_30679_30858[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_30679_30858[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (61))){
var inst_30381 = (state_30587[(21)]);
var inst_30391 = (state_30587[(39)]);
var inst_30385 = (state_30587[(40)]);
var inst_30386 = (state_30587[(43)]);
var inst_30364 = (state_30587[(47)]);
var inst_30390 = (state_30587[(2)]);
var inst_30391__$1 = fluree.db.util.async.throw_err(inst_30390);
var inst_30392 = fluree.db.query.range.find_next_valid_node(inst_30391__$1,inst_30364,inst_30381,inst_30385,inst_30386);
var state_30587__$1 = (function (){var statearr_30680 = state_30587;
(statearr_30680[(39)] = inst_30391__$1);

return statearr_30680;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30587__$1,(62),inst_30392);
} else {
if((state_val_30588 === (29))){
var inst_30314 = (state_30587[(2)]);
var inst_30315 = fluree.db.util.async.throw_err(inst_30314);
var state_30587__$1 = state_30587;
var statearr_30681_30859 = state_30587__$1;
(statearr_30681_30859[(2)] = inst_30315);

(statearr_30681_30859[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (44))){
var inst_30246 = (state_30587[(62)]);
var state_30587__$1 = state_30587;
var statearr_30682_30860 = state_30587__$1;
(statearr_30682_30860[(2)] = inst_30246);

(statearr_30682_30860[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (93))){
var inst_30462 = (state_30587[(80)]);
var inst_30405 = (state_30587[(36)]);
var inst_30401 = (state_30587[(9)]);
var inst_30474 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_30405,inst_30462);
var state_30587__$1 = (function (){var statearr_30683 = state_30587;
(statearr_30683[(67)] = inst_30474);

return statearr_30683;
})();
if(cljs.core.truth_(inst_30401)){
var statearr_30684_30861 = state_30587__$1;
(statearr_30684_30861[(1)] = (95));

} else {
var statearr_30685_30862 = state_30587__$1;
(statearr_30685_30862[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (6))){
var inst_30238 = (state_30587[(49)]);
var inst_30258 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30238);
var state_30587__$1 = state_30587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30587__$1,(9),inst_30258);
} else {
if((state_val_30588 === (111))){
var inst_30542 = (state_30587[(76)]);
var inst_30374 = (state_30587[(25)]);
var inst_30550 = (inst_30542 < inst_30374);
var state_30587__$1 = state_30587;
var statearr_30686_30863 = state_30587__$1;
(statearr_30686_30863[(2)] = inst_30550);

(statearr_30686_30863[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (28))){
var inst_30308 = (state_30587[(74)]);
var inst_30318 = (state_30587[(2)]);
var inst_30319 = fluree.db.util.core.pred_ident_QMARK_(inst_30308);
var state_30587__$1 = (function (){var statearr_30687 = state_30587;
(statearr_30687[(32)] = inst_30318);

return statearr_30687;
})();
if(inst_30319){
var statearr_30688_30864 = state_30587__$1;
(statearr_30688_30864[(1)] = (30));

} else {
var statearr_30689_30865 = state_30587__$1;
(statearr_30689_30865[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (64))){
var state_30587__$1 = state_30587;
var statearr_30690_30866 = state_30587__$1;
(statearr_30690_30866[(2)] = true);

(statearr_30690_30866[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (103))){
var inst_30497 = (state_30587[(83)]);
var inst_30516 = (state_30587[(2)]);
var inst_30517 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30516,(0),null);
var inst_30518 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30516,(1),null);
var inst_30519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30520 = [inst_30517,inst_30497,inst_30518];
var inst_30521 = (new cljs.core.PersistentVector(null,3,(5),inst_30519,inst_30520,null));
var state_30587__$1 = state_30587;
var statearr_30691_30867 = state_30587__$1;
(statearr_30691_30867[(2)] = inst_30521);

(statearr_30691_30867[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (51))){
var inst_30352 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
var statearr_30692_30868 = state_30587__$1;
(statearr_30692_30868[(2)] = inst_30352);

(statearr_30692_30868[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (25))){
var inst_30307 = (state_30587[(51)]);
var inst_30306 = (state_30587[(19)]);
var inst_30305 = (state_30587[(35)]);
var inst_30305__$1 = (state_30587[(2)]);
var inst_30306__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30305__$1,(0),null);
var inst_30307__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30306__$1,(0),null);
var inst_30308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30306__$1,(1),null);
var inst_30309 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30305__$1,(1),null);
var inst_30310 = fluree.db.util.core.pred_ident_QMARK_(inst_30307__$1);
var state_30587__$1 = (function (){var statearr_30693 = state_30587;
(statearr_30693[(10)] = inst_30309);

(statearr_30693[(51)] = inst_30307__$1);

(statearr_30693[(74)] = inst_30308);

(statearr_30693[(19)] = inst_30306__$1);

(statearr_30693[(35)] = inst_30305__$1);

return statearr_30693;
})();
if(inst_30310){
var statearr_30694_30869 = state_30587__$1;
(statearr_30694_30869[(1)] = (26));

} else {
var statearr_30695_30870 = state_30587__$1;
(statearr_30695_30870[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (34))){
var inst_30318 = (state_30587[(32)]);
var state_30587__$1 = state_30587;
var statearr_30696_30871 = state_30587__$1;
(statearr_30696_30871[(2)] = inst_30318);

(statearr_30696_30871[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (17))){
var inst_30247 = (state_30587[(60)]);
var state_30587__$1 = state_30587;
var statearr_30697_30872 = state_30587__$1;
(statearr_30697_30872[(2)] = inst_30247);

(statearr_30697_30872[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (3))){
var inst_30585 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30587__$1,inst_30585);
} else {
if((state_val_30588 === (12))){
var inst_30240 = (state_30587[(57)]);
var inst_30273 = (state_30587[(2)]);
var inst_30274 = cljs.core.boolean_QMARK_(inst_30240);
var state_30587__$1 = (function (){var statearr_30698 = state_30587;
(statearr_30698[(23)] = inst_30273);

return statearr_30698;
})();
if(inst_30274){
var statearr_30699_30873 = state_30587__$1;
(statearr_30699_30873[(1)] = (14));

} else {
var statearr_30700_30874 = state_30587__$1;
(statearr_30700_30874[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (2))){
var inst_30238 = (state_30587[(49)]);
var inst_30252 = (state_30587[(28)]);
var inst_30244 = (state_30587[(31)]);
var inst_30237 = (state_30587[(48)]);
var _ = (function (){var statearr_30701 = state_30587;
(statearr_30701[(4)] = cljs.core.cons((5),(state_30587[(4)])));

return statearr_30701;
})();
var inst_30237__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_30238__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30237__$1,(0),null);
var inst_30239 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30237__$1,(1),null);
var inst_30240 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30237__$1,(2),null);
var inst_30241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30237__$1,(3),null);
var inst_30242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30237__$1,(4),null);
var inst_30243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30237__$1,(5),null);
var inst_30244__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_30245 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30244__$1,(0),null);
var inst_30246 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30244__$1,(1),null);
var inst_30247 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30244__$1,(2),null);
var inst_30248 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30244__$1,(3),null);
var inst_30249 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30244__$1,(4),null);
var inst_30250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30244__$1,(5),null);
var inst_30251 = opts;
var inst_30252__$1 = cljs.core.__destructure_map(inst_30251);
var inst_30253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30252__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_30254 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30252__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_30255 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30252__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_30256 = fluree.db.util.core.pred_ident_QMARK_(inst_30238__$1);
var state_30587__$1 = (function (){var statearr_30702 = state_30587;
(statearr_30702[(84)] = inst_30245);

(statearr_30702[(11)] = inst_30242);

(statearr_30702[(55)] = inst_30243);

(statearr_30702[(49)] = inst_30238__$1);

(statearr_30702[(57)] = inst_30240);

(statearr_30702[(58)] = inst_30250);

(statearr_30702[(16)] = inst_30253);

(statearr_30702[(17)] = inst_30249);

(statearr_30702[(59)] = inst_30255);

(statearr_30702[(60)] = inst_30247);

(statearr_30702[(61)] = inst_30239);

(statearr_30702[(28)] = inst_30252__$1);

(statearr_30702[(31)] = inst_30244__$1);

(statearr_30702[(41)] = inst_30248);

(statearr_30702[(42)] = inst_30241);

(statearr_30702[(44)] = inst_30254);

(statearr_30702[(62)] = inst_30246);

(statearr_30702[(48)] = inst_30237__$1);

return statearr_30702;
})();
if(inst_30256){
var statearr_30703_30875 = state_30587__$1;
(statearr_30703_30875[(1)] = (6));

} else {
var statearr_30704_30876 = state_30587__$1;
(statearr_30704_30876[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (66))){
var inst_30370 = (state_30587[(71)]);
var inst_30395 = (state_30587[(8)]);
var inst_30403 = cljs.core.PersistentVector.EMPTY;
var inst_30404 = inst_30395;
var inst_30405 = inst_30370;
var inst_30406 = (0);
var inst_30407 = (0);
var inst_30408 = inst_30403;
var state_30587__$1 = (function (){var statearr_30705 = state_30587;
(statearr_30705[(13)] = inst_30407);

(statearr_30705[(15)] = inst_30404);

(statearr_30705[(22)] = inst_30406);

(statearr_30705[(27)] = inst_30408);

(statearr_30705[(36)] = inst_30405);

return statearr_30705;
})();
var statearr_30706_30877 = state_30587__$1;
(statearr_30706_30877[(2)] = null);

(statearr_30706_30877[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (107))){
var inst_30559 = (state_30587[(66)]);
var inst_30559__$1 = (state_30587[(2)]);
var state_30587__$1 = (function (){var statearr_30707 = state_30587;
(statearr_30707[(66)] = inst_30559__$1);

return statearr_30707;
})();
if(cljs.core.truth_(inst_30559__$1)){
var statearr_30708_30878 = state_30587__$1;
(statearr_30708_30878[(1)] = (114));

} else {
var statearr_30709_30879 = state_30587__$1;
(statearr_30709_30879[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (23))){
var inst_30240 = (state_30587[(57)]);
var inst_30255 = (state_30587[(59)]);
var inst_30247 = (state_30587[(60)]);
var inst_30290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30292 = [inst_30240,inst_30247];
var inst_30293 = (new cljs.core.PersistentVector(null,2,(5),inst_30291,inst_30292,null));
var inst_30294 = [inst_30293,inst_30255];
var inst_30295 = (new cljs.core.PersistentVector(null,2,(5),inst_30290,inst_30294,null));
var state_30587__$1 = state_30587;
var statearr_30710_30880 = state_30587__$1;
(statearr_30710_30880[(2)] = inst_30295);

(statearr_30710_30880[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (47))){
var inst_30348 = (cljs.core._GT__EQ_ === start_test);
var state_30587__$1 = state_30587;
if(cljs.core.truth_(inst_30348)){
var statearr_30711_30881 = state_30587__$1;
(statearr_30711_30881[(1)] = (49));

} else {
var statearr_30712_30882 = state_30587__$1;
(statearr_30712_30882[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (35))){
var inst_30328 = (state_30587[(75)]);
var state_30587__$1 = state_30587;
var statearr_30713_30883 = state_30587__$1;
(statearr_30713_30883[(2)] = inst_30328);

(statearr_30713_30883[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (82))){
var inst_30404 = (state_30587[(15)]);
var inst_30375 = (state_30587[(26)]);
var inst_30440 = (state_30587[(2)]);
var inst_30441 = fluree.db.dbproto._rhs(inst_30404);
var state_30587__$1 = (function (){var statearr_30714 = state_30587;
(statearr_30714[(65)] = inst_30441);

(statearr_30714[(81)] = inst_30440);

return statearr_30714;
})();
if(cljs.core.truth_(inst_30375)){
var statearr_30715_30884 = state_30587__$1;
(statearr_30715_30884[(1)] = (83));

} else {
var statearr_30716_30885 = state_30587__$1;
(statearr_30716_30885[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (76))){
var inst_30254 = (state_30587[(44)]);
var inst_30428 = (state_30587[(2)]);
var state_30587__$1 = (function (){var statearr_30717 = state_30587;
(statearr_30717[(64)] = inst_30428);

return statearr_30717;
})();
if(cljs.core.truth_(inst_30254)){
var statearr_30718_30886 = state_30587__$1;
(statearr_30718_30886[(1)] = (77));

} else {
var statearr_30719_30887 = state_30587__$1;
(statearr_30719_30887[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (97))){
var inst_30408 = (state_30587[(27)]);
var inst_30528 = (state_30587[(2)]);
var inst_30529 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30528,(0),null);
var inst_30530 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30528,(1),null);
var inst_30531 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30528,(2),null);
var inst_30532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30533 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30408,inst_30531);
var inst_30534 = [(0),inst_30529,inst_30530,inst_30533];
var inst_30535 = (new cljs.core.PersistentVector(null,4,(5),inst_30532,inst_30534,null));
var state_30587__$1 = state_30587;
var statearr_30720_30888 = state_30587__$1;
(statearr_30720_30888[(2)] = inst_30535);

(statearr_30720_30888[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (19))){
var inst_30285 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
var statearr_30721_30889 = state_30587__$1;
(statearr_30721_30889[(2)] = inst_30285);

(statearr_30721_30889[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (57))){
var inst_30361 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
var statearr_30722_30890 = state_30587__$1;
(statearr_30722_30890[(2)] = inst_30361);

(statearr_30722_30890[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (68))){
var inst_30582 = (state_30587[(2)]);
var _ = (function (){var statearr_30723 = state_30587;
(statearr_30723[(4)] = cljs.core.rest((state_30587[(4)])));

return statearr_30723;
})();
var state_30587__$1 = state_30587;
var statearr_30724_30891 = state_30587__$1;
(statearr_30724_30891[(2)] = inst_30582);

(statearr_30724_30891[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (11))){
var inst_30245 = (state_30587[(84)]);
var state_30587__$1 = state_30587;
var statearr_30725_30892 = state_30587__$1;
(statearr_30725_30892[(2)] = inst_30245);

(statearr_30725_30892[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (115))){
var state_30587__$1 = state_30587;
var statearr_30727_30893 = state_30587__$1;
(statearr_30727_30893[(2)] = null);

(statearr_30727_30893[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (9))){
var inst_30260 = (state_30587[(2)]);
var inst_30261 = fluree.db.util.async.throw_err(inst_30260);
var state_30587__$1 = state_30587;
var statearr_30728_30894 = state_30587__$1;
(statearr_30728_30894[(2)] = inst_30261);

(statearr_30728_30894[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (5))){
var _ = (function (){var statearr_30729 = state_30587;
(statearr_30729[(4)] = cljs.core.rest((state_30587[(4)])));

return statearr_30729;
})();
var state_30587__$1 = state_30587;
var ex30726 = (state_30587__$1[(2)]);
var statearr_30730_30895 = state_30587__$1;
(statearr_30730_30895[(5)] = ex30726);


if((ex30726 instanceof Error)){
var statearr_30731_30896 = state_30587__$1;
(statearr_30731_30896[(1)] = (4));

(statearr_30731_30896[(5)] = null);

} else {
throw ex30726;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (112))){
var inst_30548 = (state_30587[(79)]);
var state_30587__$1 = state_30587;
var statearr_30732_30897 = state_30587__$1;
(statearr_30732_30897[(2)] = inst_30548);

(statearr_30732_30897[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (83))){
var inst_30405 = (state_30587[(36)]);
var inst_30443 = (state_30587[(85)]);
var inst_30443__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_30405);
var state_30587__$1 = (function (){var statearr_30733 = state_30587;
(statearr_30733[(85)] = inst_30443__$1);

return statearr_30733;
})();
if(inst_30443__$1){
var statearr_30734_30898 = state_30587__$1;
(statearr_30734_30898[(1)] = (86));

} else {
var statearr_30735_30899 = state_30587__$1;
(statearr_30735_30899[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (14))){
var inst_30240 = (state_30587[(57)]);
var state_30587__$1 = state_30587;
var statearr_30736_30900 = state_30587__$1;
(statearr_30736_30900[(2)] = inst_30240);

(statearr_30736_30900[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (45))){
var inst_30243 = (state_30587[(55)]);
var inst_30345 = (state_30587[(2)]);
var state_30587__$1 = (function (){var statearr_30737 = state_30587;
(statearr_30737[(20)] = inst_30345);

return statearr_30737;
})();
if(cljs.core.truth_(inst_30243)){
var statearr_30738_30901 = state_30587__$1;
(statearr_30738_30901[(1)] = (46));

} else {
var statearr_30739_30902 = state_30587__$1;
(statearr_30739_30902[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (53))){
var inst_30357 = (cljs.core._LT__EQ_ === end_test);
var state_30587__$1 = state_30587;
if(cljs.core.truth_(inst_30357)){
var statearr_30740_30903 = state_30587__$1;
(statearr_30740_30903[(1)] = (55));

} else {
var statearr_30741_30904 = state_30587__$1;
(statearr_30741_30904[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (78))){
var inst_30428 = (state_30587[(64)]);
var state_30587__$1 = state_30587;
var statearr_30742_30905 = state_30587__$1;
(statearr_30742_30905[(2)] = inst_30428);

(statearr_30742_30905[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (26))){
var inst_30307 = (state_30587[(51)]);
var inst_30312 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30307);
var state_30587__$1 = state_30587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30587__$1,(29),inst_30312);
} else {
if((state_val_30588 === (123))){
var inst_30577 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
var statearr_30743_30906 = state_30587__$1;
(statearr_30743_30906[(2)] = inst_30577);

(statearr_30743_30906[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (16))){
var inst_30287 = (state_30587[(56)]);
var inst_30287__$1 = (state_30587[(2)]);
var inst_30288 = (inst_30287__$1 == null);
var state_30587__$1 = (function (){var statearr_30744 = state_30587;
(statearr_30744[(56)] = inst_30287__$1);

return statearr_30744;
})();
if(cljs.core.truth_(inst_30288)){
var statearr_30745_30907 = state_30587__$1;
(statearr_30745_30907[(1)] = (23));

} else {
var statearr_30746_30908 = state_30587__$1;
(statearr_30746_30908[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (81))){
var inst_30434 = (state_30587[(86)]);
var state_30587__$1 = state_30587;
var statearr_30747_30909 = state_30587__$1;
(statearr_30747_30909[(2)] = inst_30434);

(statearr_30747_30909[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (120))){
var inst_30571 = (state_30587[(2)]);
var inst_30572 = cljs.core.not(inst_30571);
var state_30587__$1 = state_30587;
if(inst_30572){
var statearr_30748_30910 = state_30587__$1;
(statearr_30748_30910[(1)] = (121));

} else {
var statearr_30749_30911 = state_30587__$1;
(statearr_30749_30911[(1)] = (122));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (79))){
var inst_30309 = (state_30587[(10)]);
var inst_30434 = (state_30587[(2)]);
var state_30587__$1 = (function (){var statearr_30750 = state_30587;
(statearr_30750[(86)] = inst_30434);

return statearr_30750;
})();
if(cljs.core.truth_(inst_30309)){
var statearr_30751_30912 = state_30587__$1;
(statearr_30751_30912[(1)] = (80));

} else {
var statearr_30752_30913 = state_30587__$1;
(statearr_30752_30913[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (38))){
var inst_30239 = (state_30587[(61)]);
var state_30587__$1 = state_30587;
var statearr_30753_30914 = state_30587__$1;
(statearr_30753_30914[(2)] = inst_30239);

(statearr_30753_30914[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (98))){
var inst_30374 = (state_30587[(25)]);
var inst_30484 = (state_30587[(69)]);
var inst_30482 = (state_30587[(70)]);
var inst_30487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30488 = (inst_30482 - inst_30484);
var inst_30489 = [inst_30374,inst_30488];
var inst_30490 = (new cljs.core.PersistentVector(null,2,(5),inst_30487,inst_30489,null));
var state_30587__$1 = state_30587;
var statearr_30754_30915 = state_30587__$1;
(statearr_30754_30915[(2)] = inst_30490);

(statearr_30754_30915[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (87))){
var inst_30443 = (state_30587[(85)]);
var state_30587__$1 = state_30587;
var statearr_30755_30916 = state_30587__$1;
(statearr_30755_30916[(2)] = inst_30443);

(statearr_30755_30916[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (30))){
var inst_30308 = (state_30587[(74)]);
var inst_30321 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30308);
var state_30587__$1 = state_30587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30587__$1,(33),inst_30321);
} else {
if((state_val_30588 === (73))){
var inst_30253 = (state_30587[(16)]);
var inst_30422 = (state_30587[(2)]);
var state_30587__$1 = (function (){var statearr_30756 = state_30587;
(statearr_30756[(37)] = inst_30422);

return statearr_30756;
})();
if(cljs.core.truth_(inst_30253)){
var statearr_30757_30917 = state_30587__$1;
(statearr_30757_30917[(1)] = (74));

} else {
var statearr_30758_30918 = state_30587__$1;
(statearr_30758_30918[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (96))){
var inst_30368 = (state_30587[(12)]);
var inst_30474 = (state_30587[(67)]);
var inst_30407 = (state_30587[(13)]);
var inst_30406 = (state_30587[(22)]);
var inst_30374 = (state_30587[(25)]);
var inst_30523 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_30474,inst_30406,inst_30407,inst_30368,inst_30374);
var state_30587__$1 = state_30587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30587__$1,(104),inst_30523);
} else {
if((state_val_30588 === (10))){
var inst_30245 = (state_30587[(84)]);
var inst_30267 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30245);
var state_30587__$1 = state_30587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30587__$1,(13),inst_30267);
} else {
if((state_val_30588 === (18))){
var state_30587__$1 = state_30587;
var statearr_30759_30919 = state_30587__$1;
(statearr_30759_30919[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (105))){
var inst_30380 = (state_30587[(18)]);
var inst_30546 = (state_30587[(82)]);
var inst_30441 = (state_30587[(65)]);
var inst_30365 = (state_30587[(33)]);
var inst_30545 = (inst_30380.cljs$core$IFn$_invoke$arity$2 ? inst_30380.cljs$core$IFn$_invoke$arity$2(inst_30441,inst_30365) : inst_30380.call(null,inst_30441,inst_30365));
var inst_30546__$1 = (inst_30545 < (0));
var state_30587__$1 = (function (){var statearr_30761 = state_30587;
(statearr_30761[(82)] = inst_30546__$1);

return statearr_30761;
})();
if(cljs.core.truth_(inst_30546__$1)){
var statearr_30762_30920 = state_30587__$1;
(statearr_30762_30920[(1)] = (108));

} else {
var statearr_30763_30921 = state_30587__$1;
(statearr_30763_30921[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (52))){
var inst_30250 = (state_30587[(58)]);
var state_30587__$1 = state_30587;
var statearr_30764_30922 = state_30587__$1;
(statearr_30764_30922[(2)] = inst_30250);

(statearr_30764_30922[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (114))){
var inst_30441 = (state_30587[(65)]);
var inst_30381 = (state_30587[(21)]);
var inst_30391 = (state_30587[(39)]);
var inst_30385 = (state_30587[(40)]);
var inst_30386 = (state_30587[(43)]);
var inst_30561 = fluree.db.query.range.find_next_valid_node(inst_30391,inst_30441,inst_30381,inst_30385,inst_30386);
var state_30587__$1 = state_30587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30587__$1,(117),inst_30561);
} else {
if((state_val_30588 === (67))){
var state_30587__$1 = state_30587;
var statearr_30765_30923 = state_30587__$1;
(statearr_30765_30923[(2)] = null);

(statearr_30765_30923[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (71))){
var inst_30309 = (state_30587[(10)]);
var inst_30242 = (state_30587[(11)]);
var inst_30368 = (state_30587[(12)]);
var inst_30407 = (state_30587[(13)]);
var inst_30327 = (state_30587[(14)]);
var inst_30404 = (state_30587[(15)]);
var inst_30253 = (state_30587[(16)]);
var inst_30249 = (state_30587[(17)]);
var inst_30380 = (state_30587[(18)]);
var inst_30306 = (state_30587[(19)]);
var inst_30345 = (state_30587[(20)]);
var inst_30381 = (state_30587[(21)]);
var inst_30406 = (state_30587[(22)]);
var inst_30273 = (state_30587[(23)]);
var inst_30376 = (state_30587[(24)]);
var inst_30374 = (state_30587[(25)]);
var inst_30375 = (state_30587[(26)]);
var inst_30408 = (state_30587[(27)]);
var inst_30252 = (state_30587[(28)]);
var inst_30336 = (state_30587[(29)]);
var inst_30354 = (state_30587[(30)]);
var inst_30244 = (state_30587[(31)]);
var inst_30318 = (state_30587[(32)]);
var inst_30365 = (state_30587[(33)]);
var inst_30264 = (state_30587[(34)]);
var inst_30305 = (state_30587[(35)]);
var inst_30405 = (state_30587[(36)]);
var inst_30414 = (state_30587[(38)]);
var inst_30391 = (state_30587[(39)]);
var inst_30385 = (state_30587[(40)]);
var inst_30401 = (state_30587[(9)]);
var inst_30248 = (state_30587[(41)]);
var inst_30241 = (state_30587[(42)]);
var inst_30386 = (state_30587[(43)]);
var inst_30254 = (state_30587[(44)]);
var inst_30367 = (state_30587[(45)]);
var inst_30363 = (state_30587[(46)]);
var inst_30364 = (state_30587[(47)]);
var inst_30237 = (state_30587[(48)]);
var inst_30395 = (state_30587[(8)]);
var inst_30418 = (function (){var no_filter_QMARK_ = inst_30401;
var t = inst_30381;
var max_limit_QMARK_ = inst_30375;
var next_node = inst_30404;
var fast_forward_db_QMARK_ = inst_30386;
var s1 = inst_30264;
var o2 = inst_30327;
var t1 = inst_30241;
var predicate_fn = inst_30254;
var i = inst_30406;
var map__30229 = inst_30252;
var m1 = inst_30354;
var root_node = inst_30391;
var s2 = inst_30273;
var vec__30230 = inst_30305;
var p2 = inst_30345;
var vec__30233 = inst_30306;
var map__30236 = inst_30367;
var permissions = inst_30376;
var limit = inst_30374;
var start_flake = inst_30364;
var flake_limit = inst_30368;
var offset = inst_30405;
var acc = inst_30408;
var vec__30223 = inst_30237;
var vec__30226 = inst_30244;
var t2 = inst_30248;
var op1 = inst_30242;
var G__30415 = inst_30414;
var o1 = inst_30318;
var end_flake = inst_30365;
var base_result = inst_30414;
var s = inst_30407;
var node_start = inst_30395;
var p1 = inst_30336;
var subject_fn = inst_30253;
var object_fn = inst_30309;
var idx_compare = inst_30380;
var op2 = inst_30249;
var m2 = inst_30363;
var novelty = inst_30385;
return (function (p1__30204_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__30204_SHARP_.o,start_flake.o);
});
})();
var inst_30419 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_30418,inst_30414);
var state_30587__$1 = state_30587;
var statearr_30766_30924 = state_30587__$1;
(statearr_30766_30924[(2)] = inst_30419);

(statearr_30766_30924[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (42))){
var inst_30341 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
if(cljs.core.truth_(inst_30341)){
var statearr_30767_30925 = state_30587__$1;
(statearr_30767_30925[(1)] = (43));

} else {
var statearr_30768_30926 = state_30587__$1;
(statearr_30768_30926[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (80))){
var inst_30309 = (state_30587[(10)]);
var inst_30242 = (state_30587[(11)]);
var inst_30368 = (state_30587[(12)]);
var inst_30407 = (state_30587[(13)]);
var inst_30327 = (state_30587[(14)]);
var inst_30404 = (state_30587[(15)]);
var inst_30253 = (state_30587[(16)]);
var inst_30249 = (state_30587[(17)]);
var inst_30380 = (state_30587[(18)]);
var inst_30306 = (state_30587[(19)]);
var inst_30345 = (state_30587[(20)]);
var inst_30381 = (state_30587[(21)]);
var inst_30406 = (state_30587[(22)]);
var inst_30273 = (state_30587[(23)]);
var inst_30376 = (state_30587[(24)]);
var inst_30374 = (state_30587[(25)]);
var inst_30375 = (state_30587[(26)]);
var inst_30408 = (state_30587[(27)]);
var inst_30252 = (state_30587[(28)]);
var inst_30336 = (state_30587[(29)]);
var inst_30434 = (state_30587[(86)]);
var inst_30354 = (state_30587[(30)]);
var inst_30244 = (state_30587[(31)]);
var inst_30318 = (state_30587[(32)]);
var inst_30365 = (state_30587[(33)]);
var inst_30264 = (state_30587[(34)]);
var inst_30305 = (state_30587[(35)]);
var inst_30405 = (state_30587[(36)]);
var inst_30414 = (state_30587[(38)]);
var inst_30391 = (state_30587[(39)]);
var inst_30385 = (state_30587[(40)]);
var inst_30401 = (state_30587[(9)]);
var inst_30248 = (state_30587[(41)]);
var inst_30241 = (state_30587[(42)]);
var inst_30386 = (state_30587[(43)]);
var inst_30254 = (state_30587[(44)]);
var inst_30367 = (state_30587[(45)]);
var inst_30363 = (state_30587[(46)]);
var inst_30364 = (state_30587[(47)]);
var inst_30237 = (state_30587[(48)]);
var inst_30395 = (state_30587[(8)]);
var inst_30436 = (function (){var no_filter_QMARK_ = inst_30401;
var t = inst_30381;
var max_limit_QMARK_ = inst_30375;
var next_node = inst_30404;
var fast_forward_db_QMARK_ = inst_30386;
var s1 = inst_30264;
var o2 = inst_30327;
var t1 = inst_30241;
var predicate_fn = inst_30254;
var i = inst_30406;
var map__30229 = inst_30252;
var m1 = inst_30354;
var root_node = inst_30391;
var s2 = inst_30273;
var vec__30230 = inst_30305;
var p2 = inst_30345;
var vec__30233 = inst_30306;
var map__30236 = inst_30367;
var permissions = inst_30376;
var limit = inst_30374;
var start_flake = inst_30364;
var flake_limit = inst_30368;
var offset = inst_30405;
var acc = inst_30408;
var vec__30223 = inst_30237;
var vec__30226 = inst_30244;
var t2 = inst_30248;
var op1 = inst_30242;
var G__30415 = inst_30434;
var o1 = inst_30318;
var end_flake = inst_30365;
var base_result = inst_30414;
var s = inst_30407;
var node_start = inst_30395;
var p1 = inst_30336;
var subject_fn = inst_30253;
var object_fn = inst_30309;
var idx_compare = inst_30380;
var op2 = inst_30249;
var m2 = inst_30363;
var novelty = inst_30385;
return (function (p1__30207_SHARP_){
var G__30769 = p1__30207_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__30769) : object_fn.call(null,G__30769));
});
})();
var inst_30437 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_30436,inst_30434);
var state_30587__$1 = state_30587;
var statearr_30770_30927 = state_30587__$1;
(statearr_30770_30927[(2)] = inst_30437);

(statearr_30770_30927[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (37))){
var state_30587__$1 = state_30587;
var statearr_30771_30928 = state_30587__$1;
(statearr_30771_30928[(2)] = (-1));

(statearr_30771_30928[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (63))){
var inst_30345 = (state_30587[(20)]);
var inst_30273 = (state_30587[(23)]);
var inst_30376 = (state_30587[(24)]);
var inst_30336 = (state_30587[(29)]);
var inst_30264 = (state_30587[(34)]);
var inst_30398 = fluree.db.permissions_validate.no_filter_QMARK_(inst_30376,inst_30264,inst_30273,inst_30336,inst_30345);
var state_30587__$1 = state_30587;
var statearr_30772_30929 = state_30587__$1;
(statearr_30772_30929[(2)] = inst_30398);

(statearr_30772_30929[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (94))){
var inst_30537 = (state_30587[(2)]);
var state_30587__$1 = state_30587;
var statearr_30773_30930 = state_30587__$1;
(statearr_30773_30930[(2)] = inst_30537);

(statearr_30773_30930[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (8))){
var inst_30245 = (state_30587[(84)]);
var inst_30264 = (state_30587[(2)]);
var inst_30265 = fluree.db.util.core.pred_ident_QMARK_(inst_30245);
var state_30587__$1 = (function (){var statearr_30774 = state_30587;
(statearr_30774[(34)] = inst_30264);

return statearr_30774;
})();
if(inst_30265){
var statearr_30775_30931 = state_30587__$1;
(statearr_30775_30931[(1)] = (10));

} else {
var statearr_30776_30932 = state_30587__$1;
(statearr_30776_30932[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (49))){
var state_30587__$1 = state_30587;
var statearr_30777_30933 = state_30587__$1;
(statearr_30777_30933[(2)] = fluree.db.util.core.min_integer);

(statearr_30777_30933[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30588 === (84))){
var inst_30375 = (state_30587[(26)]);
var state_30587__$1 = state_30587;
var statearr_30778_30934 = state_30587__$1;
(statearr_30778_30934[(2)] = inst_30375);

(statearr_30778_30934[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16153__auto__ = null;
var fluree$db$query$range$state_machine__16153__auto____0 = (function (){
var statearr_30779 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30779[(0)] = fluree$db$query$range$state_machine__16153__auto__);

(statearr_30779[(1)] = (1));

return statearr_30779;
});
var fluree$db$query$range$state_machine__16153__auto____1 = (function (state_30587){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_30587);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e30780){var ex__16156__auto__ = e30780;
var statearr_30781_30935 = state_30587;
(statearr_30781_30935[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_30587[(4)]))){
var statearr_30782_30936 = state_30587;
(statearr_30782_30936[(1)] = cljs.core.first((state_30587[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__30937 = state_30587;
state_30587 = G__30937;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16153__auto__ = function(state_30587){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16153__auto____1.call(this,state_30587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16153__auto____0;
fluree$db$query$range$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16153__auto____1;
return fluree$db$query$range$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_30783 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_30783[(6)] = c__16227__auto__);

return statearr_30783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_30993){
var state_val_30994 = (state_30993[(1)]);
if((state_val_30994 === (7))){
var inst_30957 = (state_30993[(7)]);
var inst_30967 = (state_30993[(8)]);
var inst_30965 = fluree.db.flake.Flake__GT_parts(inst_30957);
var inst_30966 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30965,(0),null);
var inst_30967__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30965,(1),null);
var inst_30968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30965,(2),null);
var inst_30969 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30965,(3),null);
var inst_30970 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30965,(4),null);
var inst_30971 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30965,(5),null);
var inst_30972 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_30968,inst_30967__$1);
var state_30993__$1 = (function (){var statearr_30995 = state_30993;
(statearr_30995[(9)] = inst_30966);

(statearr_30995[(8)] = inst_30967__$1);

(statearr_30995[(10)] = inst_30969);

(statearr_30995[(11)] = inst_30970);

(statearr_30995[(12)] = inst_30971);

return statearr_30995;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30993__$1,(10),inst_30972);
} else {
if((state_val_30994 === (1))){
var inst_30945 = flakes;
var inst_30946 = cljs.core.seq(inst_30945);
var inst_30947 = cljs.core.first(inst_30946);
var inst_30948 = cljs.core.next(inst_30946);
var inst_30949 = cljs.core.PersistentVector.EMPTY;
var inst_30950 = inst_30945;
var inst_30951 = inst_30949;
var state_30993__$1 = (function (){var statearr_30996 = state_30993;
(statearr_30996[(13)] = inst_30950);

(statearr_30996[(14)] = inst_30951);

(statearr_30996[(15)] = inst_30947);

(statearr_30996[(16)] = inst_30948);

return statearr_30996;
})();
var statearr_30997_31015 = state_30993__$1;
(statearr_30997_31015[(2)] = null);

(statearr_30997_31015[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30994 === (4))){
var inst_30957 = (state_30993[(7)]);
var inst_30960 = fluree.db.query.range.is_tag_flake_QMARK_(inst_30957);
var state_30993__$1 = state_30993;
if(inst_30960){
var statearr_30998_31016 = state_30993__$1;
(statearr_30998_31016[(1)] = (7));

} else {
var statearr_30999_31017 = state_30993__$1;
(statearr_30999_31017[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30994 === (6))){
var inst_30989 = (state_30993[(2)]);
var state_30993__$1 = state_30993;
var statearr_31000_31018 = state_30993__$1;
(statearr_31000_31018[(2)] = inst_30989);

(statearr_31000_31018[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30994 === (3))){
var inst_30991 = (state_30993[(2)]);
var state_30993__$1 = state_30993;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30993__$1,inst_30991);
} else {
if((state_val_30994 === (2))){
var inst_30950 = (state_30993[(13)]);
var inst_30957 = (state_30993[(7)]);
var inst_30956 = cljs.core.seq(inst_30950);
var inst_30957__$1 = cljs.core.first(inst_30956);
var inst_30958 = cljs.core.next(inst_30956);
var state_30993__$1 = (function (){var statearr_31001 = state_30993;
(statearr_31001[(7)] = inst_30957__$1);

(statearr_31001[(17)] = inst_30958);

return statearr_31001;
})();
if(cljs.core.truth_(inst_30957__$1)){
var statearr_31002_31019 = state_30993__$1;
(statearr_31002_31019[(1)] = (4));

} else {
var statearr_31003_31020 = state_30993__$1;
(statearr_31003_31020[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30994 === (9))){
var inst_30986 = (state_30993[(2)]);
var state_30993__$1 = state_30993;
var statearr_31004_31021 = state_30993__$1;
(statearr_31004_31021[(2)] = inst_30986);

(statearr_31004_31021[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30994 === (5))){
var inst_30951 = (state_30993[(14)]);
var state_30993__$1 = state_30993;
var statearr_31005_31022 = state_30993__$1;
(statearr_31005_31022[(2)] = inst_30951);

(statearr_31005_31022[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30994 === (10))){
var inst_30966 = (state_30993[(9)]);
var inst_30951 = (state_30993[(14)]);
var inst_30967 = (state_30993[(8)]);
var inst_30969 = (state_30993[(10)]);
var inst_30970 = (state_30993[(11)]);
var inst_30958 = (state_30993[(17)]);
var inst_30971 = (state_30993[(12)]);
var inst_30974 = (state_30993[(2)]);
var inst_30975 = fluree.db.util.async.throw_err(inst_30974);
var inst_30976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30977 = [inst_30966,inst_30967,inst_30975,inst_30969,inst_30970,inst_30971];
var inst_30978 = (new cljs.core.PersistentVector(null,6,(5),inst_30976,inst_30977,null));
var inst_30979 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_30978);
var inst_30980 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_30951,inst_30979);
var inst_30950 = inst_30958;
var inst_30951__$1 = inst_30980;
var state_30993__$1 = (function (){var statearr_31006 = state_30993;
(statearr_31006[(13)] = inst_30950);

(statearr_31006[(14)] = inst_30951__$1);

return statearr_31006;
})();
var statearr_31007_31023 = state_30993__$1;
(statearr_31007_31023[(2)] = null);

(statearr_31007_31023[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30994 === (8))){
var inst_30957 = (state_30993[(7)]);
var inst_30951 = (state_30993[(14)]);
var inst_30958 = (state_30993[(17)]);
var inst_30983 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_30951,inst_30957);
var inst_30950 = inst_30958;
var inst_30951__$1 = inst_30983;
var state_30993__$1 = (function (){var statearr_31008 = state_30993;
(statearr_31008[(13)] = inst_30950);

(statearr_31008[(14)] = inst_30951__$1);

return statearr_31008;
})();
var statearr_31009_31024 = state_30993__$1;
(statearr_31009_31024[(2)] = null);

(statearr_31009_31024[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16153__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16153__auto____0 = (function (){
var statearr_31010 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31010[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16153__auto__);

(statearr_31010[(1)] = (1));

return statearr_31010;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16153__auto____1 = (function (state_30993){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_30993);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e31011){var ex__16156__auto__ = e31011;
var statearr_31012_31025 = state_30993;
(statearr_31012_31025[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_30993[(4)]))){
var statearr_31013_31026 = state_30993;
(statearr_31013_31026[(1)] = cljs.core.first((state_30993[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__31027 = state_30993;
state_30993 = G__31027;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16153__auto__ = function(state_30993){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16153__auto____1.call(this,state_30993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16153__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16153__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_31014 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_31014[(6)] = c__16227__auto__);

return statearr_31014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__31029 = arguments.length;
switch (G__31029) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_31199){
var state_val_31200 = (state_31199[(1)]);
if((state_val_31200 === (65))){
var state_31199__$1 = state_31199;
var statearr_31201_31301 = state_31199__$1;
(statearr_31201_31301[(2)] = null);

(statearr_31201_31301[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (70))){
var inst_31194 = (state_31199[(2)]);
var _ = (function (){var statearr_31202 = state_31199;
(statearr_31202[(4)] = cljs.core.rest((state_31199[(4)])));

return statearr_31202;
})();
var state_31199__$1 = state_31199;
var statearr_31203_31302 = state_31199__$1;
(statearr_31203_31302[(2)] = inst_31194);

(statearr_31203_31302[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (62))){
var inst_31180 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
var statearr_31204_31303 = state_31199__$1;
(statearr_31204_31303[(2)] = inst_31180);

(statearr_31204_31303[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (7))){
var state_31199__$1 = state_31199;
var statearr_31205_31304 = state_31199__$1;
(statearr_31205_31304[(2)] = false);

(statearr_31205_31304[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (59))){
var inst_31154 = (state_31199[(2)]);
var inst_31155 = fluree.db.util.async.throw_err(inst_31154);
var state_31199__$1 = state_31199;
var statearr_31206_31305 = state_31199__$1;
(statearr_31206_31305[(2)] = inst_31155);

(statearr_31206_31305[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (20))){
var state_31199__$1 = state_31199;
var statearr_31207_31306 = state_31199__$1;
(statearr_31207_31306[(2)] = null);

(statearr_31207_31306[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (58))){
var inst_31144 = (state_31199[(2)]);
var inst_31145 = fluree.db.util.async.throw_err(inst_31144);
var inst_31146 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_31145);
var state_31199__$1 = state_31199;
var statearr_31208_31307 = state_31199__$1;
(statearr_31208_31307[(2)] = inst_31146);

(statearr_31208_31307[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (60))){
var inst_31043 = (state_31199[(7)]);
var inst_31040 = (state_31199[(8)]);
var inst_31041 = (state_31199[(9)]);
var inst_31080 = (state_31199[(10)]);
var inst_31160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31161 = [inst_31041,inst_31040,inst_31080,inst_31043];
var inst_31162 = (new cljs.core.PersistentVector(null,4,(5),inst_31160,inst_31161,null));
var inst_31163 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_31162,opts);
var state_31199__$1 = state_31199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31199__$1,(63),inst_31163);
} else {
if((state_val_31200 === (27))){
var inst_31091 = (state_31199[(11)]);
var inst_31080 = (state_31199[(10)]);
var inst_31091__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_31080);
var state_31199__$1 = (function (){var statearr_31209 = state_31199;
(statearr_31209[(11)] = inst_31091__$1);

return statearr_31209;
})();
if(inst_31091__$1){
var statearr_31210_31308 = state_31199__$1;
(statearr_31210_31308[(1)] = (30));

} else {
var statearr_31211_31309 = state_31199__$1;
(statearr_31211_31309[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (1))){
var state_31199__$1 = state_31199;
var statearr_31212_31310 = state_31199__$1;
(statearr_31212_31310[(2)] = null);

(statearr_31212_31310[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (69))){
var inst_31186 = (state_31199[(12)]);
var state_31199__$1 = state_31199;
var statearr_31213_31311 = state_31199__$1;
(statearr_31213_31311[(2)] = inst_31186);

(statearr_31213_31311[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (24))){
var inst_31041 = (state_31199[(9)]);
var state_31199__$1 = state_31199;
if(cljs.core.truth_(inst_31041)){
var statearr_31214_31312 = state_31199__$1;
(statearr_31214_31312[(1)] = (27));

} else {
var statearr_31215_31313 = state_31199__$1;
(statearr_31215_31313[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (55))){
var inst_31080 = (state_31199[(10)]);
var inst_31138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31139 = [inst_31080];
var inst_31140 = (new cljs.core.PersistentVector(null,1,(5),inst_31138,inst_31139,null));
var inst_31141 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$limit,(1));
var inst_31142 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_31140,inst_31141);
var state_31199__$1 = state_31199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31199__$1,(58),inst_31142);
} else {
if((state_val_31200 === (39))){
var inst_31111 = (state_31199[(2)]);
var inst_31112 = fluree.db.util.async.throw_err(inst_31111);
var state_31199__$1 = state_31199;
var statearr_31216_31314 = state_31199__$1;
(statearr_31216_31314[(2)] = inst_31112);

(statearr_31216_31314[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (46))){
var inst_31124 = (state_31199[(13)]);
var inst_31124__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_31199__$1 = (function (){var statearr_31217 = state_31199;
(statearr_31217[(13)] = inst_31124__$1);

return statearr_31217;
})();
if(cljs.core.truth_(inst_31124__$1)){
var statearr_31218_31315 = state_31199__$1;
(statearr_31218_31315[(1)] = (49));

} else {
var statearr_31219_31316 = state_31199__$1;
(statearr_31219_31316[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (4))){
var inst_31030 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
var statearr_31220_31317 = state_31199__$1;
(statearr_31220_31317[(2)] = inst_31030);

(statearr_31220_31317[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (54))){
var inst_31136 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
if(cljs.core.truth_(inst_31136)){
var statearr_31221_31318 = state_31199__$1;
(statearr_31221_31318[(1)] = (55));

} else {
var statearr_31222_31319 = state_31199__$1;
(statearr_31222_31319[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (15))){
var inst_31042 = (state_31199[(14)]);
var inst_31061 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_31042);
var state_31199__$1 = state_31199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31199__$1,(18),inst_31061);
} else {
if((state_val_31200 === (48))){
var inst_31182 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
var statearr_31223_31320 = state_31199__$1;
(statearr_31223_31320[(2)] = inst_31182);

(statearr_31223_31320[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (50))){
var inst_31124 = (state_31199[(13)]);
var inst_31044 = (state_31199[(15)]);
var inst_31043 = (state_31199[(7)]);
var inst_31050 = (state_31199[(16)]);
var inst_31039 = (state_31199[(17)]);
var inst_31040 = (state_31199[(8)]);
var inst_31041 = (state_31199[(9)]);
var inst_31055 = (state_31199[(18)]);
var inst_31080 = (state_31199[(10)]);
var inst_31128 = (function (){var t = inst_31043;
var p = inst_31041;
var idx_predicate_QMARK_ = inst_31044;
var o = inst_31080;
var tag_predicate_QMARK_ = inst_31050;
var vec__31036 = inst_31039;
var temp__5751__auto__ = inst_31124;
var s = inst_31040;
var o_coerce_QMARK_ = inst_31055;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_31199__$1 = state_31199;
var statearr_31224_31321 = state_31199__$1;
(statearr_31224_31321[(2)] = inst_31128);

(statearr_31224_31321[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (21))){
var inst_31076 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
var statearr_31225_31322 = state_31199__$1;
(statearr_31225_31322[(2)] = inst_31076);

(statearr_31225_31322[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (31))){
var inst_31091 = (state_31199[(11)]);
var state_31199__$1 = state_31199;
var statearr_31226_31323 = state_31199__$1;
(statearr_31226_31323[(2)] = inst_31091);

(statearr_31226_31323[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (32))){
var inst_31101 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
var statearr_31227_31324 = state_31199__$1;
(statearr_31227_31324[(2)] = inst_31101);

(statearr_31227_31324[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (40))){
var inst_31115 = (state_31199[(19)]);
var inst_31044 = (state_31199[(15)]);
var inst_31115__$1 = cljs.core.not(inst_31044);
var state_31199__$1 = (function (){var statearr_31228 = state_31199;
(statearr_31228[(19)] = inst_31115__$1);

return statearr_31228;
})();
if(inst_31115__$1){
var statearr_31229_31325 = state_31199__$1;
(statearr_31229_31325[(1)] = (43));

} else {
var statearr_31230_31326 = state_31199__$1;
(statearr_31230_31326[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (56))){
var inst_31043 = (state_31199[(7)]);
var inst_31130 = (state_31199[(20)]);
var inst_31040 = (state_31199[(8)]);
var inst_31041 = (state_31199[(9)]);
var inst_31148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31149 = [inst_31041,inst_31040,null,inst_31043];
var inst_31150 = (new cljs.core.PersistentVector(null,4,(5),inst_31148,inst_31149,null));
var inst_31151 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_31130);
var inst_31152 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_31150,inst_31151);
var state_31199__$1 = state_31199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31199__$1,(59),inst_31152);
} else {
if((state_val_31200 === (33))){
var inst_31080 = (state_31199[(10)]);
var inst_31094 = cljs.core.fn_QMARK_(inst_31080);
var inst_31095 = (!(inst_31094));
var state_31199__$1 = state_31199;
var statearr_31231_31327 = state_31199__$1;
(statearr_31231_31327[(2)] = inst_31095);

(statearr_31231_31327[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (13))){
var inst_31042 = (state_31199[(14)]);
var inst_31059 = fluree.db.query.range.tag_string_QMARK_(inst_31042);
var state_31199__$1 = state_31199;
if(cljs.core.truth_(inst_31059)){
var statearr_31232_31328 = state_31199__$1;
(statearr_31232_31328[(1)] = (15));

} else {
var statearr_31233_31329 = state_31199__$1;
(statearr_31233_31329[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (22))){
var inst_31072 = (state_31199[(2)]);
var inst_31073 = fluree.db.util.async.throw_err(inst_31072);
var state_31199__$1 = state_31199;
var statearr_31234_31330 = state_31199__$1;
(statearr_31234_31330[(2)] = inst_31073);

(statearr_31234_31330[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (36))){
var inst_31043 = (state_31199[(7)]);
var inst_31040 = (state_31199[(8)]);
var inst_31041 = (state_31199[(9)]);
var inst_31080 = (state_31199[(10)]);
var inst_31106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31107 = [inst_31041,inst_31080,inst_31040,inst_31043];
var inst_31108 = (new cljs.core.PersistentVector(null,4,(5),inst_31106,inst_31107,null));
var inst_31109 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_31108,opts);
var state_31199__$1 = state_31199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31199__$1,(39),inst_31109);
} else {
if((state_val_31200 === (41))){
var inst_31041 = (state_31199[(9)]);
var state_31199__$1 = state_31199;
var statearr_31235_31331 = state_31199__$1;
(statearr_31235_31331[(2)] = inst_31041);

(statearr_31235_31331[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (43))){
var inst_31080 = (state_31199[(10)]);
var state_31199__$1 = state_31199;
var statearr_31236_31332 = state_31199__$1;
(statearr_31236_31332[(2)] = inst_31080);

(statearr_31236_31332[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (61))){
var inst_31080 = (state_31199[(10)]);
var state_31199__$1 = state_31199;
if(cljs.core.truth_(inst_31080)){
var statearr_31237_31333 = state_31199__$1;
(statearr_31237_31333[(1)] = (64));

} else {
var statearr_31238_31334 = state_31199__$1;
(statearr_31238_31334[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (29))){
var inst_31104 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
if(cljs.core.truth_(inst_31104)){
var statearr_31239_31335 = state_31199__$1;
(statearr_31239_31335[(1)] = (36));

} else {
var statearr_31240_31336 = state_31199__$1;
(statearr_31240_31336[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (44))){
var inst_31115 = (state_31199[(19)]);
var state_31199__$1 = state_31199;
var statearr_31241_31337 = state_31199__$1;
(statearr_31241_31337[(2)] = inst_31115);

(statearr_31241_31337[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (6))){
var inst_31041 = (state_31199[(9)]);
var inst_31046 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_31041);
var inst_31047 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_31046);
var state_31199__$1 = state_31199;
var statearr_31242_31338 = state_31199__$1;
(statearr_31242_31338[(2)] = inst_31047);

(statearr_31242_31338[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (28))){
var inst_31041 = (state_31199[(9)]);
var state_31199__$1 = state_31199;
var statearr_31243_31339 = state_31199__$1;
(statearr_31243_31339[(2)] = inst_31041);

(statearr_31243_31339[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (64))){
var inst_31043 = (state_31199[(7)]);
var inst_31040 = (state_31199[(8)]);
var inst_31041 = (state_31199[(9)]);
var inst_31080 = (state_31199[(10)]);
var inst_31169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31170 = [inst_31080,inst_31041,inst_31040,inst_31043];
var inst_31171 = (new cljs.core.PersistentVector(null,4,(5),inst_31169,inst_31170,null));
var inst_31172 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_31171,opts);
var state_31199__$1 = state_31199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31199__$1,(67),inst_31172);
} else {
if((state_val_31200 === (51))){
var inst_31131 = (state_31199[(21)]);
var inst_31041 = (state_31199[(9)]);
var inst_31130 = (state_31199[(2)]);
var inst_31131__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_31041);
var state_31199__$1 = (function (){var statearr_31244 = state_31199;
(statearr_31244[(20)] = inst_31130);

(statearr_31244[(21)] = inst_31131__$1);

return statearr_31244;
})();
if(inst_31131__$1){
var statearr_31245_31340 = state_31199__$1;
(statearr_31245_31340[(1)] = (52));

} else {
var statearr_31246_31341 = state_31199__$1;
(statearr_31246_31341[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (25))){
var inst_31050 = (state_31199[(16)]);
var inst_31186 = (state_31199[(2)]);
var state_31199__$1 = (function (){var statearr_31247 = state_31199;
(statearr_31247[(12)] = inst_31186);

return statearr_31247;
})();
if(cljs.core.truth_(inst_31050)){
var statearr_31248_31342 = state_31199__$1;
(statearr_31248_31342[(1)] = (68));

} else {
var statearr_31249_31343 = state_31199__$1;
(statearr_31249_31343[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (34))){
var inst_31044 = (state_31199[(15)]);
var state_31199__$1 = state_31199;
var statearr_31250_31344 = state_31199__$1;
(statearr_31250_31344[(2)] = inst_31044);

(statearr_31250_31344[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (17))){
var inst_31078 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
var statearr_31251_31345 = state_31199__$1;
(statearr_31251_31345[(2)] = inst_31078);

(statearr_31251_31345[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (3))){
var inst_31197 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31199__$1,inst_31197);
} else {
if((state_val_31200 === (12))){
var inst_31042 = (state_31199[(14)]);
var state_31199__$1 = state_31199;
var statearr_31252_31346 = state_31199__$1;
(statearr_31252_31346[(2)] = inst_31042);

(statearr_31252_31346[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (2))){
var inst_31039 = (state_31199[(17)]);
var inst_31041 = (state_31199[(9)]);
var _ = (function (){var statearr_31253 = state_31199;
(statearr_31253[(4)] = cljs.core.cons((5),(state_31199[(4)])));

return statearr_31253;
})();
var inst_31039__$1 = fparts;
var inst_31040 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31039__$1,(0),null);
var inst_31041__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31039__$1,(1),null);
var inst_31042 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31039__$1,(2),null);
var inst_31043 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31039__$1,(3),null);
var inst_31044 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_31041__$1);
var state_31199__$1 = (function (){var statearr_31254 = state_31199;
(statearr_31254[(15)] = inst_31044);

(statearr_31254[(7)] = inst_31043);

(statearr_31254[(17)] = inst_31039__$1);

(statearr_31254[(8)] = inst_31040);

(statearr_31254[(9)] = inst_31041__$1);

(statearr_31254[(14)] = inst_31042);

return statearr_31254;
})();
if(cljs.core.truth_(inst_31041__$1)){
var statearr_31255_31347 = state_31199__$1;
(statearr_31255_31347[(1)] = (6));

} else {
var statearr_31256_31348 = state_31199__$1;
(statearr_31256_31348[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (66))){
var inst_31178 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
var statearr_31257_31349 = state_31199__$1;
(statearr_31257_31349[(2)] = inst_31178);

(statearr_31257_31349[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (23))){
var inst_31043 = (state_31199[(7)]);
var inst_31040 = (state_31199[(8)]);
var inst_31041 = (state_31199[(9)]);
var inst_31080 = (state_31199[(10)]);
var inst_31082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31083 = [inst_31040,inst_31041,inst_31080,inst_31043];
var inst_31084 = (new cljs.core.PersistentVector(null,4,(5),inst_31082,inst_31083,null));
var inst_31085 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_31084,opts);
var state_31199__$1 = state_31199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31199__$1,(26),inst_31085);
} else {
if((state_val_31200 === (47))){
var inst_31041 = (state_31199[(9)]);
var state_31199__$1 = state_31199;
if(cljs.core.truth_(inst_31041)){
var statearr_31258_31350 = state_31199__$1;
(statearr_31258_31350[(1)] = (60));

} else {
var statearr_31259_31351 = state_31199__$1;
(statearr_31259_31351[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (35))){
var inst_31098 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
var statearr_31260_31352 = state_31199__$1;
(statearr_31260_31352[(2)] = inst_31098);

(statearr_31260_31352[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (19))){
var inst_31041 = (state_31199[(9)]);
var inst_31042 = (state_31199[(14)]);
var inst_31068 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_31041);
var inst_31069 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31068),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31042)].join('');
var inst_31070 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_31069);
var state_31199__$1 = state_31199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31199__$1,(22),inst_31070);
} else {
if((state_val_31200 === (57))){
var inst_31157 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
var statearr_31261_31353 = state_31199__$1;
(statearr_31261_31353[(2)] = inst_31157);

(statearr_31261_31353[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (68))){
var inst_31186 = (state_31199[(12)]);
var inst_31188 = fluree.db.query.range.coerce_tag_flakes(db,inst_31186);
var state_31199__$1 = state_31199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31199__$1,(71),inst_31188);
} else {
if((state_val_31200 === (11))){
var inst_31055 = (state_31199[(18)]);
var inst_31055__$1 = (state_31199[(2)]);
var inst_31056 = cljs.core.not(inst_31055__$1);
var state_31199__$1 = (function (){var statearr_31263 = state_31199;
(statearr_31263[(18)] = inst_31055__$1);

return statearr_31263;
})();
if(inst_31056){
var statearr_31264_31354 = state_31199__$1;
(statearr_31264_31354[(1)] = (12));

} else {
var statearr_31265_31355 = state_31199__$1;
(statearr_31265_31355[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (9))){
var inst_31042 = (state_31199[(14)]);
var inst_31052 = typeof inst_31042 === 'string';
var state_31199__$1 = state_31199;
var statearr_31266_31356 = state_31199__$1;
(statearr_31266_31356[(2)] = inst_31052);

(statearr_31266_31356[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (5))){
var _ = (function (){var statearr_31267 = state_31199;
(statearr_31267[(4)] = cljs.core.rest((state_31199[(4)])));

return statearr_31267;
})();
var state_31199__$1 = state_31199;
var ex31262 = (state_31199__$1[(2)]);
var statearr_31268_31357 = state_31199__$1;
(statearr_31268_31357[(5)] = ex31262);


if((ex31262 instanceof Error)){
var statearr_31269_31358 = state_31199__$1;
(statearr_31269_31358[(1)] = (4));

(statearr_31269_31358[(5)] = null);

} else {
throw ex31262;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (14))){
var inst_31040 = (state_31199[(8)]);
var inst_31080 = (state_31199[(2)]);
var state_31199__$1 = (function (){var statearr_31270 = state_31199;
(statearr_31270[(10)] = inst_31080);

return statearr_31270;
})();
if(cljs.core.truth_(inst_31040)){
var statearr_31271_31359 = state_31199__$1;
(statearr_31271_31359[(1)] = (23));

} else {
var statearr_31272_31360 = state_31199__$1;
(statearr_31272_31360[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (45))){
var inst_31119 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
var statearr_31273_31361 = state_31199__$1;
(statearr_31273_31361[(2)] = inst_31119);

(statearr_31273_31361[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (53))){
var inst_31131 = (state_31199[(21)]);
var state_31199__$1 = state_31199;
var statearr_31274_31362 = state_31199__$1;
(statearr_31274_31362[(2)] = inst_31131);

(statearr_31274_31362[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (26))){
var inst_31087 = (state_31199[(2)]);
var inst_31088 = fluree.db.util.async.throw_err(inst_31087);
var state_31199__$1 = state_31199;
var statearr_31275_31363 = state_31199__$1;
(statearr_31275_31363[(2)] = inst_31088);

(statearr_31275_31363[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (16))){
var inst_31042 = (state_31199[(14)]);
var inst_31066 = typeof inst_31042 === 'string';
var state_31199__$1 = state_31199;
if(cljs.core.truth_(inst_31066)){
var statearr_31276_31364 = state_31199__$1;
(statearr_31276_31364[(1)] = (19));

} else {
var statearr_31277_31365 = state_31199__$1;
(statearr_31277_31365[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (38))){
var inst_31184 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
var statearr_31278_31366 = state_31199__$1;
(statearr_31278_31366[(2)] = inst_31184);

(statearr_31278_31366[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (30))){
var inst_31044 = (state_31199[(15)]);
var state_31199__$1 = state_31199;
if(cljs.core.truth_(inst_31044)){
var statearr_31279_31367 = state_31199__$1;
(statearr_31279_31367[(1)] = (33));

} else {
var statearr_31280_31368 = state_31199__$1;
(statearr_31280_31368[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (10))){
var inst_31050 = (state_31199[(16)]);
var state_31199__$1 = state_31199;
var statearr_31281_31369 = state_31199__$1;
(statearr_31281_31369[(2)] = inst_31050);

(statearr_31281_31369[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (18))){
var inst_31063 = (state_31199[(2)]);
var inst_31064 = fluree.db.util.async.throw_err(inst_31063);
var state_31199__$1 = state_31199;
var statearr_31282_31370 = state_31199__$1;
(statearr_31282_31370[(2)] = inst_31064);

(statearr_31282_31370[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (52))){
var inst_31080 = (state_31199[(10)]);
var inst_31133 = cljs.core.int_QMARK_(inst_31080);
var state_31199__$1 = state_31199;
var statearr_31283_31371 = state_31199__$1;
(statearr_31283_31371[(2)] = inst_31133);

(statearr_31283_31371[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (67))){
var inst_31174 = (state_31199[(2)]);
var inst_31175 = fluree.db.util.async.throw_err(inst_31174);
var state_31199__$1 = state_31199;
var statearr_31284_31372 = state_31199__$1;
(statearr_31284_31372[(2)] = inst_31175);

(statearr_31284_31372[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (71))){
var inst_31190 = (state_31199[(2)]);
var inst_31191 = fluree.db.util.async.throw_err(inst_31190);
var state_31199__$1 = state_31199;
var statearr_31285_31373 = state_31199__$1;
(statearr_31285_31373[(2)] = inst_31191);

(statearr_31285_31373[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (42))){
var inst_31122 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
if(cljs.core.truth_(inst_31122)){
var statearr_31286_31374 = state_31199__$1;
(statearr_31286_31374[(1)] = (46));

} else {
var statearr_31287_31375 = state_31199__$1;
(statearr_31287_31375[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (37))){
var inst_31041 = (state_31199[(9)]);
var state_31199__$1 = state_31199;
if(cljs.core.truth_(inst_31041)){
var statearr_31288_31376 = state_31199__$1;
(statearr_31288_31376[(1)] = (40));

} else {
var statearr_31289_31377 = state_31199__$1;
(statearr_31289_31377[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (63))){
var inst_31165 = (state_31199[(2)]);
var inst_31166 = fluree.db.util.async.throw_err(inst_31165);
var state_31199__$1 = state_31199;
var statearr_31290_31378 = state_31199__$1;
(statearr_31290_31378[(2)] = inst_31166);

(statearr_31290_31378[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (8))){
var inst_31050 = (state_31199[(16)]);
var inst_31050__$1 = (state_31199[(2)]);
var state_31199__$1 = (function (){var statearr_31291 = state_31199;
(statearr_31291[(16)] = inst_31050__$1);

return statearr_31291;
})();
if(cljs.core.truth_(inst_31050__$1)){
var statearr_31292_31379 = state_31199__$1;
(statearr_31292_31379[(1)] = (9));

} else {
var statearr_31293_31380 = state_31199__$1;
(statearr_31293_31380[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31200 === (49))){
var inst_31124 = (state_31199[(13)]);
var inst_31044 = (state_31199[(15)]);
var inst_31043 = (state_31199[(7)]);
var inst_31050 = (state_31199[(16)]);
var inst_31039 = (state_31199[(17)]);
var inst_31040 = (state_31199[(8)]);
var inst_31041 = (state_31199[(9)]);
var inst_31055 = (state_31199[(18)]);
var inst_31080 = (state_31199[(10)]);
var inst_31126 = (function (){var obj_fn = inst_31124;
var t = inst_31043;
var p = inst_31041;
var idx_predicate_QMARK_ = inst_31044;
var o = inst_31080;
var tag_predicate_QMARK_ = inst_31050;
var vec__31036 = inst_31039;
var temp__5751__auto__ = inst_31124;
var s = inst_31040;
var o_coerce_QMARK_ = inst_31055;
return (function (x){
var and__4221__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4221__auto__;
}
});
})();
var state_31199__$1 = state_31199;
var statearr_31294_31381 = state_31199__$1;
(statearr_31294_31381[(2)] = inst_31126);

(statearr_31294_31381[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16153__auto__ = null;
var fluree$db$query$range$state_machine__16153__auto____0 = (function (){
var statearr_31295 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31295[(0)] = fluree$db$query$range$state_machine__16153__auto__);

(statearr_31295[(1)] = (1));

return statearr_31295;
});
var fluree$db$query$range$state_machine__16153__auto____1 = (function (state_31199){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_31199);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e31296){var ex__16156__auto__ = e31296;
var statearr_31297_31382 = state_31199;
(statearr_31297_31382[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_31199[(4)]))){
var statearr_31298_31383 = state_31199;
(statearr_31298_31383[(1)] = cljs.core.first((state_31199[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__31384 = state_31199;
state_31199 = G__31384;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16153__auto__ = function(state_31199){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16153__auto____1.call(this,state_31199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16153__auto____0;
fluree$db$query$range$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16153__auto____1;
return fluree$db$query$range$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_31299 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_31299[(6)] = c__16227__auto__);

return statearr_31299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__31386 = arguments.length;
switch (G__31386) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_31421){
var state_val_31422 = (state_31421[(1)]);
if((state_val_31422 === (7))){
var inst_31408 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_31409 = ["Invalid collection name: ",inst_31408].join('');
var inst_31410 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31411 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_31412 = cljs.core.PersistentHashMap.fromArrays(inst_31410,inst_31411);
var inst_31413 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31409,inst_31412);
var inst_31414 = (function(){throw inst_31413})();
var state_31421__$1 = state_31421;
var statearr_31423_31443 = state_31421__$1;
(statearr_31423_31443[(2)] = inst_31414);

(statearr_31423_31443[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31422 === (1))){
var state_31421__$1 = state_31421;
var statearr_31424_31444 = state_31421__$1;
(statearr_31424_31444[(2)] = null);

(statearr_31424_31444[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31422 === (4))){
var inst_31387 = (state_31421[(2)]);
var state_31421__$1 = state_31421;
var statearr_31425_31445 = state_31421__$1;
(statearr_31425_31445[(2)] = inst_31387);

(statearr_31425_31445[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31422 === (6))){
var inst_31393 = (state_31421[(7)]);
var inst_31395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31396 = fluree.db.flake.max_subject_id(inst_31393);
var inst_31397 = [inst_31396];
var inst_31398 = (new cljs.core.PersistentVector(null,1,(5),inst_31395,inst_31397,null));
var inst_31399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31400 = fluree.db.flake.min_subject_id(inst_31393);
var inst_31401 = [inst_31400];
var inst_31402 = (new cljs.core.PersistentVector(null,1,(5),inst_31399,inst_31401,null));
var inst_31403 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_31398,cljs.core._LT__EQ_,inst_31402,opts);
var state_31421__$1 = state_31421;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31421__$1,(9),inst_31403);
} else {
if((state_val_31422 === (3))){
var inst_31419 = (state_31421[(2)]);
var state_31421__$1 = state_31421;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31421__$1,inst_31419);
} else {
if((state_val_31422 === (2))){
var inst_31393 = (state_31421[(7)]);
var _ = (function (){var statearr_31427 = state_31421;
(statearr_31427[(4)] = cljs.core.cons((5),(state_31421[(4)])));

return statearr_31427;
})();
var inst_31393__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,name);
var state_31421__$1 = (function (){var statearr_31428 = state_31421;
(statearr_31428[(7)] = inst_31393__$1);

return statearr_31428;
})();
if(cljs.core.truth_(inst_31393__$1)){
var statearr_31429_31446 = state_31421__$1;
(statearr_31429_31446[(1)] = (6));

} else {
var statearr_31430_31447 = state_31421__$1;
(statearr_31430_31447[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31422 === (9))){
var inst_31405 = (state_31421[(2)]);
var inst_31406 = fluree.db.util.async.throw_err(inst_31405);
var state_31421__$1 = state_31421;
var statearr_31431_31448 = state_31421__$1;
(statearr_31431_31448[(2)] = inst_31406);

(statearr_31431_31448[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31422 === (5))){
var _ = (function (){var statearr_31432 = state_31421;
(statearr_31432[(4)] = cljs.core.rest((state_31421[(4)])));

return statearr_31432;
})();
var state_31421__$1 = state_31421;
var ex31426 = (state_31421__$1[(2)]);
var statearr_31433_31449 = state_31421__$1;
(statearr_31433_31449[(5)] = ex31426);


var statearr_31434_31450 = state_31421__$1;
(statearr_31434_31450[(1)] = (4));

(statearr_31434_31450[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31422 === (8))){
var inst_31416 = (state_31421[(2)]);
var _ = (function (){var statearr_31435 = state_31421;
(statearr_31435[(4)] = cljs.core.rest((state_31421[(4)])));

return statearr_31435;
})();
var state_31421__$1 = state_31421;
var statearr_31436_31451 = state_31421__$1;
(statearr_31436_31451[(2)] = inst_31416);

(statearr_31436_31451[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16153__auto__ = null;
var fluree$db$query$range$state_machine__16153__auto____0 = (function (){
var statearr_31437 = [null,null,null,null,null,null,null,null];
(statearr_31437[(0)] = fluree$db$query$range$state_machine__16153__auto__);

(statearr_31437[(1)] = (1));

return statearr_31437;
});
var fluree$db$query$range$state_machine__16153__auto____1 = (function (state_31421){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_31421);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e31438){var ex__16156__auto__ = e31438;
var statearr_31439_31452 = state_31421;
(statearr_31439_31452[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_31421[(4)]))){
var statearr_31440_31453 = state_31421;
(statearr_31440_31453[(1)] = cljs.core.first((state_31421[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__31454 = state_31421;
state_31421 = G__31454;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16153__auto__ = function(state_31421){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16153__auto____1.call(this,state_31421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16153__auto____0;
fluree$db$query$range$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16153__auto____1;
return fluree$db$query$range$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_31441 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_31441[(6)] = c__16227__auto__);

return statearr_31441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__31458 = flakes;
var vec__31459 = G__31458;
var seq__31460 = cljs.core.seq(vec__31459);
var first__31461 = cljs.core.first(seq__31460);
var seq__31460__$1 = cljs.core.next(seq__31460);
var flake_SINGLEQUOTE_ = first__31461;
var r = seq__31460__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__31458__$1 = G__31458;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__31467 = G__31458__$1;
var seq__31468 = cljs.core.seq(vec__31467);
var first__31469 = cljs.core.first(seq__31468);
var seq__31468__$1 = cljs.core.next(seq__31468);
var flake_SINGLEQUOTE___$1 = first__31469;
var r__$1 = seq__31468__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e31471){var e = e31471;
return null;
}})();
var map__31470 = cmd_map;
var map__31470__$1 = cljs.core.__destructure_map(map__31470);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31470__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31470__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31470__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31470__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31470__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31470__$1,cljs.core.cst$kw$expire);
var G__31472 = r__$1;
var G__31473 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__31458__$1 = G__31472;
result_STAR___$1 = G__31473;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__31482 = blocks;
var vec__31483 = G__31482;
var seq__31484 = cljs.core.seq(vec__31483);
var first__31485 = cljs.core.first(seq__31484);
var seq__31484__$1 = cljs.core.next(seq__31484);
var block_SINGLEQUOTE_ = first__31485;
var r = seq__31484__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__31482__$1 = G__31482;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__31490 = G__31482__$1;
var seq__31491 = cljs.core.seq(vec__31490);
var first__31492 = cljs.core.first(seq__31491);
var seq__31491__$1 = cljs.core.next(seq__31491);
var block_SINGLEQUOTE___$1 = first__31492;
var r__$1 = seq__31491__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__31493 = block_SINGLEQUOTE___$1;
var map__31493__$1 = cljs.core.__destructure_map(map__31493);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31493__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31493__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31493__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__31482__$1,result_STAR___$1,map__31493,map__31493__$1,block,t,flakes,vec__31490,seq__31491,first__31492,seq__31491__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31482,vec__31483,seq__31484,first__31485,seq__31484__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31474_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31474_SHARP_.p,(2))){
return p1__31474_SHARP_.o;
} else {
return null;
}
});})(G__31482__$1,result_STAR___$1,map__31493,map__31493__$1,block,t,flakes,vec__31490,seq__31491,first__31492,seq__31491__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31482,vec__31483,seq__31484,first__31485,seq__31484__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__31482__$1,result_STAR___$1,map__31493,map__31493__$1,block,t,flakes,prev_hash,vec__31490,seq__31491,first__31492,seq__31491__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31482,vec__31483,seq__31484,first__31485,seq__31484__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31475_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31475_SHARP_.p,(1))){
return p1__31475_SHARP_.o;
} else {
return null;
}
});})(G__31482__$1,result_STAR___$1,map__31493,map__31493__$1,block,t,flakes,prev_hash,vec__31490,seq__31491,first__31492,seq__31491__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31482,vec__31483,seq__31484,first__31485,seq__31484__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__31482__$1,result_STAR___$1,map__31493,map__31493__$1,block,t,flakes,prev_hash,hash,vec__31490,seq__31491,first__31492,seq__31491__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31482,vec__31483,seq__31484,first__31485,seq__31484__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31476_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31476_SHARP_.p,(5))){
return p1__31476_SHARP_.o;
} else {
return null;
}
});})(G__31482__$1,result_STAR___$1,map__31493,map__31493__$1,block,t,flakes,prev_hash,hash,vec__31490,seq__31491,first__31492,seq__31491__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31482,vec__31483,seq__31484,first__31485,seq__31484__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__31482__$1,result_STAR___$1,map__31493,map__31493__$1,block,t,flakes,prev_hash,hash,instant,vec__31490,seq__31491,first__31492,seq__31491__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31482,vec__31483,seq__31484,first__31485,seq__31484__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31477_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31477_SHARP_.p,(7))){
return p1__31477_SHARP_.o;
} else {
return null;
}
});})(G__31482__$1,result_STAR___$1,map__31493,map__31493__$1,block,t,flakes,prev_hash,hash,instant,vec__31490,seq__31491,first__31492,seq__31491__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31482,vec__31483,seq__31484,first__31485,seq__31484__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__31482__$1,result_STAR___$1,map__31493,map__31493__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__31490,seq__31491,first__31492,seq__31491__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31482,vec__31483,seq__31484,first__31485,seq__31484__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31478_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31478_SHARP_.p,(106));
});})(G__31482__$1,result_STAR___$1,map__31493,map__31493__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__31490,seq__31491,first__31492,seq__31491__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31482,vec__31483,seq__31484,first__31485,seq__31484__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__31494 = r__$1;
var G__31495 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__31482__$1 = G__31494;
result_STAR___$1 = G__31495;
continue;
}
break;
}
});
