// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k43283,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__43287 = k43283;
var G__43287__$1 = (((G__43287 instanceof cljs.core.Keyword))?G__43287.fqn:null);
switch (G__43287__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k43283,else__4475__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__43288){
var vec__43289 = p__43288;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43289,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43289,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__43282){
var self__ = this;
var G__43282__$1 = this;
return (new cljs.core.RecordIter((0),G__43282__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__43292 = (function (coll__4469__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__43292(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this43284,other43285){
var self__ = this;
var this43284__$1 = this;
return (((!((other43285 == null)))) && ((((this43284__$1.constructor === other43285.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43284__$1.conn,other43285.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43284__$1.network,other43285.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43284__$1.dbid,other43285.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43284__$1.db_name,other43285.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43284__$1.update_chan,other43285.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43284__$1.transact_chan,other43285.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43284__$1.state,other43285.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43284__$1.schema_cache,other43285.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43284__$1.blank_db,other43285.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43284__$1.close,other43285.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43284__$1.id,other43285.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43284__$1.__extmap,other43285.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k43283){
var self__ = this;
var this__4479__auto____$1 = this;
var G__43293 = k43283;
var G__43293__$1 = (((G__43293 instanceof cljs.core.Keyword))?G__43293.fqn:null);
switch (G__43293__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k43283);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__43282){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__43294 = cljs.core.keyword_identical_QMARK_;
var expr__43295 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__43297 = cljs.core.cst$kw$conn;
var G__43298 = expr__43295;
return (pred__43294.cljs$core$IFn$_invoke$arity$2 ? pred__43294.cljs$core$IFn$_invoke$arity$2(G__43297,G__43298) : pred__43294.call(null,G__43297,G__43298));
})())){
return (new fluree.db.session.DbSession(G__43282,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43299 = cljs.core.cst$kw$network;
var G__43300 = expr__43295;
return (pred__43294.cljs$core$IFn$_invoke$arity$2 ? pred__43294.cljs$core$IFn$_invoke$arity$2(G__43299,G__43300) : pred__43294.call(null,G__43299,G__43300));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__43282,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43301 = cljs.core.cst$kw$dbid;
var G__43302 = expr__43295;
return (pred__43294.cljs$core$IFn$_invoke$arity$2 ? pred__43294.cljs$core$IFn$_invoke$arity$2(G__43301,G__43302) : pred__43294.call(null,G__43301,G__43302));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__43282,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43303 = cljs.core.cst$kw$db_DASH_name;
var G__43304 = expr__43295;
return (pred__43294.cljs$core$IFn$_invoke$arity$2 ? pred__43294.cljs$core$IFn$_invoke$arity$2(G__43303,G__43304) : pred__43294.call(null,G__43303,G__43304));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__43282,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43305 = cljs.core.cst$kw$update_DASH_chan;
var G__43306 = expr__43295;
return (pred__43294.cljs$core$IFn$_invoke$arity$2 ? pred__43294.cljs$core$IFn$_invoke$arity$2(G__43305,G__43306) : pred__43294.call(null,G__43305,G__43306));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__43282,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43307 = cljs.core.cst$kw$transact_DASH_chan;
var G__43308 = expr__43295;
return (pred__43294.cljs$core$IFn$_invoke$arity$2 ? pred__43294.cljs$core$IFn$_invoke$arity$2(G__43307,G__43308) : pred__43294.call(null,G__43307,G__43308));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__43282,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43309 = cljs.core.cst$kw$state;
var G__43310 = expr__43295;
return (pred__43294.cljs$core$IFn$_invoke$arity$2 ? pred__43294.cljs$core$IFn$_invoke$arity$2(G__43309,G__43310) : pred__43294.call(null,G__43309,G__43310));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__43282,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43311 = cljs.core.cst$kw$schema_DASH_cache;
var G__43312 = expr__43295;
return (pred__43294.cljs$core$IFn$_invoke$arity$2 ? pred__43294.cljs$core$IFn$_invoke$arity$2(G__43311,G__43312) : pred__43294.call(null,G__43311,G__43312));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__43282,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43313 = cljs.core.cst$kw$blank_DASH_db;
var G__43314 = expr__43295;
return (pred__43294.cljs$core$IFn$_invoke$arity$2 ? pred__43294.cljs$core$IFn$_invoke$arity$2(G__43313,G__43314) : pred__43294.call(null,G__43313,G__43314));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__43282,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43315 = cljs.core.cst$kw$close;
var G__43316 = expr__43295;
return (pred__43294.cljs$core$IFn$_invoke$arity$2 ? pred__43294.cljs$core$IFn$_invoke$arity$2(G__43315,G__43316) : pred__43294.call(null,G__43315,G__43316));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__43282,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43317 = cljs.core.cst$kw$id;
var G__43318 = expr__43295;
return (pred__43294.cljs$core$IFn$_invoke$arity$2 ? pred__43294.cljs$core$IFn$_invoke$arity$2(G__43317,G__43318) : pred__43294.call(null,G__43317,G__43318));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__43282,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__43282),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__43282){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__43282,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__43286){
var extmap__4512__auto__ = (function (){var G__43319 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__43286,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__43286)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__43319);
} else {
return G__43319;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__43286),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__43286),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__43286),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__43286),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__43286),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__43286),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__43286),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__43286),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__43286),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__43286),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__43286),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__43322 = session;
var map__43322__$1 = cljs.core.__destructure_map(map__43322);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43322__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43322__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16227__auto___43474 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_43426){
var state_val_43427 = (state_43426[(1)]);
if((state_val_43427 === (7))){
var inst_43343 = (state_43426[(7)]);
var inst_43348 = cljs.core.empty_QMARK_(inst_43343);
var state_43426__$1 = state_43426;
if(inst_43348){
var statearr_43428_43475 = state_43426__$1;
(statearr_43428_43475[(1)] = (10));

} else {
var statearr_43429_43476 = state_43426__$1;
(statearr_43429_43476[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (20))){
var inst_43335 = (state_43426[(8)]);
var inst_43334 = (state_43426[(9)]);
var inst_43336 = (state_43426[(10)]);
var inst_43374 = (state_43426[(11)]);
var inst_43379 = fluree.db.storage.core.read_block(inst_43334,inst_43335,inst_43336,inst_43374);
var state_43426__$1 = state_43426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43426__$1,(22),inst_43379);
} else {
if((state_val_43427 === (27))){
var inst_43410 = (state_43426[(12)]);
var inst_43415 = (state_43426[(13)]);
var inst_43413 = (state_43426[(2)]);
var inst_43414 = fluree.db.util.async.throw_err(inst_43413);
var inst_43415__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43410,cljs.core.cst$kw$schema,inst_43414);
var inst_43416 = fluree.db.query.schema.setting_map(inst_43415__$1);
var state_43426__$1 = (function (){var statearr_43430 = state_43426;
(statearr_43430[(13)] = inst_43415__$1);

return statearr_43430;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43426__$1,(28),inst_43416);
} else {
if((state_val_43427 === (1))){
var state_43426__$1 = state_43426;
var statearr_43431_43477 = state_43426__$1;
(statearr_43431_43477[(2)] = null);

(statearr_43431_43477[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (24))){
var inst_43335 = (state_43426[(8)]);
var inst_43336 = (state_43426[(10)]);
var inst_43374 = (state_43426[(11)]);
var inst_43396 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43374)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43335),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43336),"."].join('');
var inst_43397 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_43398 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_43399 = cljs.core.PersistentHashMap.fromArrays(inst_43397,inst_43398);
var inst_43400 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43396,inst_43399);
var inst_43401 = (function(){throw inst_43400})();
var state_43426__$1 = state_43426;
var statearr_43432_43478 = state_43426__$1;
(statearr_43432_43478[(2)] = inst_43401);

(statearr_43432_43478[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (4))){
var inst_43323 = (state_43426[(2)]);
var inst_43324 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_43323);
var state_43426__$1 = state_43426;
var statearr_43433_43479 = state_43426__$1;
(statearr_43433_43479[(2)] = inst_43324);

(statearr_43433_43479[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (15))){
var state_43426__$1 = state_43426;
var statearr_43434_43480 = state_43426__$1;
(statearr_43434_43480[(2)] = null);

(statearr_43434_43480[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (21))){
var inst_43405 = (state_43426[(2)]);
var state_43426__$1 = state_43426;
var statearr_43435_43481 = state_43426__$1;
(statearr_43435_43481[(2)] = inst_43405);

(statearr_43435_43481[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (13))){
var inst_43343 = (state_43426[(7)]);
var inst_43368 = (state_43426[(14)]);
var inst_43367 = (state_43426[(2)]);
var inst_43368__$1 = fluree.db.util.async.throw_err(inst_43367);
var inst_43369 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_43343);
var state_43426__$1 = (function (){var statearr_43436 = state_43426;
(statearr_43436[(14)] = inst_43368__$1);

(statearr_43436[(15)] = inst_43369);

return statearr_43436;
})();
if(cljs.core.truth_(inst_43368__$1)){
var statearr_43437_43482 = state_43426__$1;
(statearr_43437_43482[(1)] = (14));

} else {
var statearr_43438_43483 = state_43426__$1;
(statearr_43438_43483[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (22))){
var inst_43382 = (state_43426[(16)]);
var inst_43381 = (state_43426[(2)]);
var inst_43382__$1 = fluree.db.util.async.throw_err(inst_43381);
var state_43426__$1 = (function (){var statearr_43439 = state_43426;
(statearr_43439[(16)] = inst_43382__$1);

return statearr_43439;
})();
if(cljs.core.truth_(inst_43382__$1)){
var statearr_43440_43484 = state_43426__$1;
(statearr_43440_43484[(1)] = (23));

} else {
var statearr_43441_43485 = state_43426__$1;
(statearr_43441_43485[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (6))){
var inst_43343 = (state_43426[(7)]);
var inst_43342 = (state_43426[(2)]);
var inst_43343__$1 = fluree.db.util.async.throw_err(inst_43342);
var inst_43344 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_43343__$1);
var inst_43345 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_43344);
var inst_43346 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_43345);
var state_43426__$1 = (function (){var statearr_43442 = state_43426;
(statearr_43442[(7)] = inst_43343__$1);

return statearr_43442;
})();
if(inst_43346){
var statearr_43443_43486 = state_43426__$1;
(statearr_43443_43486[(1)] = (7));

} else {
var statearr_43444_43487 = state_43426__$1;
(statearr_43444_43487[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (28))){
var inst_43415 = (state_43426[(13)]);
var inst_43418 = (state_43426[(2)]);
var inst_43419 = fluree.db.util.async.throw_err(inst_43418);
var inst_43420 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43415,cljs.core.cst$kw$settings,inst_43419);
var inst_43421 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_43420);
var _ = (function (){var statearr_43445 = state_43426;
(statearr_43445[(4)] = cljs.core.rest((state_43426[(4)])));

return statearr_43445;
})();
var state_43426__$1 = state_43426;
var statearr_43446_43488 = state_43426__$1;
(statearr_43446_43488[(2)] = inst_43421);

(statearr_43446_43488[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (25))){
var inst_43403 = (state_43426[(2)]);
var state_43426__$1 = state_43426;
var statearr_43447_43489 = state_43426__$1;
(statearr_43447_43489[(2)] = inst_43403);

(statearr_43447_43489[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (17))){
var inst_43374 = (state_43426[(11)]);
var inst_43369 = (state_43426[(15)]);
var inst_43376 = (inst_43374 > inst_43369);
var state_43426__$1 = state_43426;
if(cljs.core.truth_(inst_43376)){
var statearr_43448_43490 = state_43426__$1;
(statearr_43448_43490[(1)] = (19));

} else {
var statearr_43449_43491 = state_43426__$1;
(statearr_43449_43491[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (3))){
var inst_43424 = (state_43426[(2)]);
var state_43426__$1 = state_43426;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43426__$1,inst_43424);
} else {
if((state_val_43427 === (12))){
var inst_43355 = (state_43426[(2)]);
var inst_43356 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_43357 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_43358 = cljs.core.PersistentHashMap.fromArrays(inst_43356,inst_43357);
var inst_43359 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43355,inst_43358);
var inst_43360 = (function(){throw inst_43359})();
var state_43426__$1 = state_43426;
var statearr_43450_43492 = state_43426__$1;
(statearr_43450_43492[(2)] = inst_43360);

(statearr_43450_43492[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (2))){
var inst_43335 = (state_43426[(8)]);
var inst_43334 = (state_43426[(9)]);
var inst_43336 = (state_43426[(10)]);
var _ = (function (){var statearr_43451 = state_43426;
(statearr_43451[(4)] = cljs.core.cons((5),(state_43426[(4)])));

return statearr_43451;
})();
var inst_43331 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_43332 = session;
var inst_43333 = cljs.core.__destructure_map(inst_43332);
var inst_43334__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43333,cljs.core.cst$kw$conn);
var inst_43335__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43333,cljs.core.cst$kw$network);
var inst_43336__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43333,cljs.core.cst$kw$dbid);
var inst_43337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43338 = [inst_43335__$1,inst_43336__$1];
var inst_43339 = (new cljs.core.PersistentVector(null,2,(5),inst_43337,inst_43338,null));
var inst_43340 = fluree.db.operations.ledger_info_async(inst_43334__$1,inst_43339);
var state_43426__$1 = (function (){var statearr_43452 = state_43426;
(statearr_43452[(8)] = inst_43335__$1);

(statearr_43452[(9)] = inst_43334__$1);

(statearr_43452[(10)] = inst_43336__$1);

(statearr_43452[(17)] = inst_43331);

return statearr_43452;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43426__$1,(6),inst_43340);
} else {
if((state_val_43427 === (23))){
var inst_43382 = (state_43426[(16)]);
var inst_43373 = (state_43426[(18)]);
var inst_43385 = cljs.core.__destructure_map(inst_43382);
var inst_43386 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43385,cljs.core.cst$kw$flakes);
var inst_43387 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43385,cljs.core.cst$kw$block);
var inst_43388 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43385,cljs.core.cst$kw$t);
var inst_43389 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_43373,inst_43387,inst_43386);
var state_43426__$1 = (function (){var statearr_43453 = state_43426;
(statearr_43453[(19)] = inst_43388);

return statearr_43453;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43426__$1,(26),inst_43389);
} else {
if((state_val_43427 === (19))){
var inst_43373 = (state_43426[(18)]);
var state_43426__$1 = state_43426;
var statearr_43454_43493 = state_43426__$1;
(statearr_43454_43493[(2)] = inst_43373);

(statearr_43454_43493[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (11))){
var inst_43335 = (state_43426[(8)]);
var inst_43343 = (state_43426[(7)]);
var inst_43336 = (state_43426[(10)]);
var inst_43352 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_43343);
var inst_43353 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43335),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43336)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43352),"."].join('');
var state_43426__$1 = state_43426;
var statearr_43456_43494 = state_43426__$1;
(statearr_43456_43494[(2)] = inst_43353);

(statearr_43456_43494[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (9))){
var inst_43335 = (state_43426[(8)]);
var inst_43334 = (state_43426[(9)]);
var inst_43343 = (state_43426[(7)]);
var inst_43336 = (state_43426[(10)]);
var inst_43331 = (state_43426[(17)]);
var inst_43363 = (state_43426[(2)]);
var inst_43364 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_43343);
var inst_43365 = fluree.db.storage.core.reify_db(inst_43334,inst_43335,inst_43336,inst_43331,inst_43364);
var state_43426__$1 = (function (){var statearr_43457 = state_43426;
(statearr_43457[(20)] = inst_43363);

return statearr_43457;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43426__$1,(13),inst_43365);
} else {
if((state_val_43427 === (5))){
var _ = (function (){var statearr_43458 = state_43426;
(statearr_43458[(4)] = cljs.core.rest((state_43426[(4)])));

return statearr_43458;
})();
var state_43426__$1 = state_43426;
var ex43455 = (state_43426__$1[(2)]);
var statearr_43459_43495 = state_43426__$1;
(statearr_43459_43495[(5)] = ex43455);


var statearr_43460_43496 = state_43426__$1;
(statearr_43460_43496[(1)] = (4));

(statearr_43460_43496[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (14))){
var inst_43368 = (state_43426[(14)]);
var inst_43371 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_43368);
var inst_43372 = (inst_43371 + (1));
var inst_43373 = inst_43368;
var inst_43374 = inst_43372;
var state_43426__$1 = (function (){var statearr_43461 = state_43426;
(statearr_43461[(11)] = inst_43374);

(statearr_43461[(18)] = inst_43373);

return statearr_43461;
})();
var statearr_43462_43497 = state_43426__$1;
(statearr_43462_43497[(2)] = null);

(statearr_43462_43497[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (26))){
var inst_43374 = (state_43426[(11)]);
var inst_43391 = (state_43426[(2)]);
var inst_43392 = fluree.db.util.async.throw_err(inst_43391);
var inst_43393 = (inst_43374 + (1));
var inst_43373 = inst_43392;
var inst_43374__$1 = inst_43393;
var state_43426__$1 = (function (){var statearr_43463 = state_43426;
(statearr_43463[(11)] = inst_43374__$1);

(statearr_43463[(18)] = inst_43373);

return statearr_43463;
})();
var statearr_43464_43498 = state_43426__$1;
(statearr_43464_43498[(2)] = null);

(statearr_43464_43498[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (16))){
var inst_43410 = (state_43426[(12)]);
var inst_43410__$1 = (state_43426[(2)]);
var inst_43411 = fluree.db.query.schema.schema_map(inst_43410__$1);
var state_43426__$1 = (function (){var statearr_43465 = state_43426;
(statearr_43465[(12)] = inst_43410__$1);

return statearr_43465;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43426__$1,(27),inst_43411);
} else {
if((state_val_43427 === (10))){
var inst_43335 = (state_43426[(8)]);
var inst_43336 = (state_43426[(10)]);
var inst_43350 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43335),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43336)," is not found on this ledger group."].join('');
var state_43426__$1 = state_43426;
var statearr_43466_43499 = state_43426__$1;
(statearr_43466_43499[(2)] = inst_43350);

(statearr_43466_43499[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (18))){
var inst_43407 = (state_43426[(2)]);
var state_43426__$1 = state_43426;
var statearr_43467_43500 = state_43426__$1;
(statearr_43467_43500[(2)] = inst_43407);

(statearr_43467_43500[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43427 === (8))){
var state_43426__$1 = state_43426;
var statearr_43468_43501 = state_43426__$1;
(statearr_43468_43501[(2)] = null);

(statearr_43468_43501[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__16153__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__16153__auto____0 = (function (){
var statearr_43469 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43469[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__16153__auto__);

(statearr_43469[(1)] = (1));

return statearr_43469;
});
var fluree$db$session$full_load_existing_db_$_state_machine__16153__auto____1 = (function (state_43426){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_43426);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e43470){var ex__16156__auto__ = e43470;
var statearr_43471_43502 = state_43426;
(statearr_43471_43502[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_43426[(4)]))){
var statearr_43472_43503 = state_43426;
(statearr_43472_43503[(1)] = cljs.core.first((state_43426[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__43504 = state_43426;
state_43426 = G__43504;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__16153__auto__ = function(state_43426){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__16153__auto____1.call(this,state_43426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__16153__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__16153__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_43473 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_43473[(6)] = c__16227__auto___43474);

return statearr_43473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__43505 = s;
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__43505,cljs.core.cst$kw$db_SLASH_indexing,block);
} else {
return G__43505;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__43506 = cljs.core.get_global_hierarchy;
return (fexpr__43506.cljs$core$IFn$_invoke$arity$0 ? fexpr__43506.cljs$core$IFn$_invoke$arity$0() : fexpr__43506.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local_DASH_ledger_DASH_update,(function (_,___$1,___$2){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_43508){
var state_val_43509 = (state_43508[(1)]);
if((state_val_43509 === (1))){
var state_43508__$1 = state_43508;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43508__$1,cljs.core.cst$kw$fluree$db$session_SLASH_no_DASH_op);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__16153__auto__ = null;
var fluree$db$session$state_machine__16153__auto____0 = (function (){
var statearr_43510 = [null,null,null,null,null,null,null];
(statearr_43510[(0)] = fluree$db$session$state_machine__16153__auto__);

(statearr_43510[(1)] = (1));

return statearr_43510;
});
var fluree$db$session$state_machine__16153__auto____1 = (function (state_43508){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_43508);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e43511){var ex__16156__auto__ = e43511;
var statearr_43512_43515 = state_43508;
(statearr_43512_43515[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_43508[(4)]))){
var statearr_43513_43516 = state_43508;
(statearr_43513_43516[(1)] = cljs.core.first((state_43508[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__43517 = state_43508;
state_43508 = G__43517;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$session$state_machine__16153__auto__ = function(state_43508){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16153__auto____1.call(this,state_43508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16153__auto____0;
fluree$db$session$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16153__auto____1;
return fluree$db$session$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_43514 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_43514[(6)] = c__16227__auto__);

return statearr_43514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__43519){
var map__43520 = p__43519;
var map__43520__$1 = cljs.core.__destructure_map(map__43520);
var data = map__43520__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43520__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43520__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43520__$1,cljs.core.cst$kw$flakes);
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_43579){
var state_val_43580 = (state_43579[(1)]);
if((state_val_43580 === (7))){
var inst_43534 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43535 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43536 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43534),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43535),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_43537 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43536], 0));
var state_43579__$1 = state_43579;
var statearr_43581_43619 = state_43579__$1;
(statearr_43581_43619[(2)] = inst_43537);

(statearr_43581_43619[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (1))){
var state_43579__$1 = state_43579;
var statearr_43582_43620 = state_43579__$1;
(statearr_43582_43620[(2)] = null);

(statearr_43582_43620[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (4))){
var inst_43521 = (state_43579[(2)]);
var state_43579__$1 = state_43579;
var statearr_43583_43621 = state_43579__$1;
(statearr_43583_43621[(2)] = inst_43521);

(statearr_43583_43621[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (15))){
var inst_43560 = (state_43579[(2)]);
var state_43579__$1 = state_43579;
var statearr_43584_43622 = state_43579__$1;
(statearr_43584_43622[(2)] = inst_43560);

(statearr_43584_43622[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (13))){
var inst_43551 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var inst_43552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43553 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43554 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43555 = [inst_43553,inst_43554];
var inst_43556 = (new cljs.core.PersistentVector(null,2,(5),inst_43552,inst_43555,null));
var inst_43557 = (function (){var G__43585 = inst_43551;
var G__43586 = cljs.core.cst$kw$local_DASH_ledger_DASH_update;
var G__43587 = inst_43556;
var G__43588 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__43585,G__43586,G__43587,G__43588) : fluree.db.conn_events.process_event.call(null,G__43585,G__43586,G__43587,G__43588));
})();
var state_43579__$1 = state_43579;
var statearr_43589_43623 = state_43579__$1;
(statearr_43589_43623[(2)] = inst_43557);

(statearr_43589_43623[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (6))){
var inst_43530 = (state_43579[(7)]);
var inst_43531 = (state_43579[(8)]);
var inst_43529 = (state_43579[(2)]);
var inst_43530__$1 = fluree.db.util.async.throw_err(inst_43529);
var inst_43531__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_43530__$1);
var inst_43532 = (block <= inst_43531__$1);
var state_43579__$1 = (function (){var statearr_43590 = state_43579;
(statearr_43590[(7)] = inst_43530__$1);

(statearr_43590[(8)] = inst_43531__$1);

return statearr_43590;
})();
if(cljs.core.truth_(inst_43532)){
var statearr_43591_43624 = state_43579__$1;
(statearr_43591_43624[(1)] = (7));

} else {
var statearr_43592_43625 = state_43579__$1;
(statearr_43592_43625[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (17))){
var state_43579__$1 = state_43579;
var statearr_43593_43626 = state_43579__$1;
(statearr_43593_43626[(2)] = null);

(statearr_43593_43626[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (3))){
var inst_43577 = (state_43579[(2)]);
var state_43579__$1 = state_43579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43579__$1,inst_43577);
} else {
if((state_val_43580 === (12))){
var inst_43572 = (state_43579[(2)]);
var state_43579__$1 = state_43579;
var statearr_43594_43627 = state_43579__$1;
(statearr_43594_43627[(2)] = inst_43572);

(statearr_43594_43627[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (2))){
var inst_43527 = (state_43579[(9)]);
var _ = (function (){var statearr_43595 = state_43579;
(statearr_43595[(4)] = cljs.core.cons((5),(state_43579[(4)])));

return statearr_43595;
})();
var inst_43527__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_43579__$1 = (function (){var statearr_43596 = state_43579;
(statearr_43596[(9)] = inst_43527__$1);

return statearr_43596;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43579__$1,(6),inst_43527__$1);
} else {
if((state_val_43580 === (11))){
var state_43579__$1 = state_43579;
var statearr_43598_43628 = state_43579__$1;
(statearr_43598_43628[(1)] = (16));



return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (9))){
var inst_43574 = (state_43579[(2)]);
var _ = (function (){var statearr_43600 = state_43579;
(statearr_43600[(4)] = cljs.core.rest((state_43579[(4)])));

return statearr_43600;
})();
var state_43579__$1 = state_43579;
var statearr_43601_43629 = state_43579__$1;
(statearr_43601_43629[(2)] = inst_43574);

(statearr_43601_43629[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (5))){
var _ = (function (){var statearr_43602 = state_43579;
(statearr_43602[(4)] = cljs.core.rest((state_43579[(4)])));

return statearr_43602;
})();
var state_43579__$1 = state_43579;
var ex43597 = (state_43579__$1[(2)]);
var statearr_43603_43630 = state_43579__$1;
(statearr_43603_43630[(5)] = ex43597);


if((ex43597 instanceof Error)){
var statearr_43604_43631 = state_43579__$1;
(statearr_43604_43631[(1)] = (4));

(statearr_43604_43631[(5)] = null);

} else {
throw ex43597;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (14))){
var state_43579__$1 = state_43579;
var statearr_43605_43632 = state_43579__$1;
(statearr_43605_43632[(2)] = null);

(statearr_43605_43632[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (16))){
var inst_43531 = (state_43579[(8)]);
var inst_43563 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43564 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43565 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43563),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43564),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43531),". Forcing a db reload."].join('');
var inst_43566 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43565], 0));
var inst_43567 = fluree.db.session.reload_db_BANG_(session);
var state_43579__$1 = (function (){var statearr_43606 = state_43579;
(statearr_43606[(10)] = inst_43566);

return statearr_43606;
})();
var statearr_43607_43633 = state_43579__$1;
(statearr_43607_43633[(2)] = inst_43567);

(statearr_43607_43633[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (10))){
var inst_43527 = (state_43579[(9)]);
var inst_43530 = (state_43579[(7)]);
var inst_43531 = (state_43579[(8)]);
var inst_43542 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43543 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43544 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43542),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43543),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_43545 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43544], 0));
var inst_43546 = (function (){var current_db_ch = inst_43527;
var current_db = inst_43530;
var current_block = inst_43531;
return (function (p1__43518_SHARP_){
if((p1__43518_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__43518_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__43518_SHARP_);
}
});
})();
var inst_43547 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_43546,flakes);
var inst_43548 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_43530,block,inst_43547);
var inst_43549 = fluree.db.session.cas_db_BANG_(session,inst_43527,inst_43548);
var state_43579__$1 = (function (){var statearr_43608 = state_43579;
(statearr_43608[(11)] = inst_43545);

return statearr_43608;
})();
if(inst_43549){
var statearr_43609_43634 = state_43579__$1;
(statearr_43609_43634[(1)] = (13));

} else {
var statearr_43610_43635 = state_43579__$1;
(statearr_43610_43635[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (18))){
var inst_43570 = (state_43579[(2)]);
var state_43579__$1 = state_43579;
var statearr_43611_43636 = state_43579__$1;
(statearr_43611_43636[(2)] = inst_43570);

(statearr_43611_43636[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43580 === (8))){
var inst_43531 = (state_43579[(8)]);
var inst_43539 = ((1) + inst_43531);
var inst_43540 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_43539);
var state_43579__$1 = state_43579;
if(inst_43540){
var statearr_43612_43637 = state_43579__$1;
(statearr_43612_43637[(1)] = (10));

} else {
var statearr_43613_43638 = state_43579__$1;
(statearr_43613_43638[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__16153__auto__ = null;
var fluree$db$session$state_machine__16153__auto____0 = (function (){
var statearr_43614 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43614[(0)] = fluree$db$session$state_machine__16153__auto__);

(statearr_43614[(1)] = (1));

return statearr_43614;
});
var fluree$db$session$state_machine__16153__auto____1 = (function (state_43579){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_43579);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e43615){var ex__16156__auto__ = e43615;
var statearr_43616_43639 = state_43579;
(statearr_43616_43639[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_43579[(4)]))){
var statearr_43617_43640 = state_43579;
(statearr_43617_43640[(1)] = cljs.core.first((state_43579[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__43641 = state_43579;
state_43579 = G__43641;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$session$state_machine__16153__auto__ = function(state_43579){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16153__auto____1.call(this,state_43579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16153__auto____0;
fluree$db$session$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16153__auto____1;
return fluree$db$session$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_43618 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_43618[(6)] = c__16227__auto__);

return statearr_43618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_43648){
var state_val_43649 = (state_43648[(1)]);
if((state_val_43649 === (1))){
var inst_43642 = fluree.db.session.clear_db_BANG_(session);
var inst_43643 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43644 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43645 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43643),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43644)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_43646 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43645], 0));
var state_43648__$1 = (function (){var statearr_43650 = state_43648;
(statearr_43650[(7)] = inst_43642);

(statearr_43650[(8)] = inst_43646);

return statearr_43650;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_43648__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__16153__auto__ = null;
var fluree$db$session$state_machine__16153__auto____0 = (function (){
var statearr_43651 = [null,null,null,null,null,null,null,null,null];
(statearr_43651[(0)] = fluree$db$session$state_machine__16153__auto__);

(statearr_43651[(1)] = (1));

return statearr_43651;
});
var fluree$db$session$state_machine__16153__auto____1 = (function (state_43648){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_43648);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e43652){var ex__16156__auto__ = e43652;
var statearr_43653_43656 = state_43648;
(statearr_43653_43656[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_43648[(4)]))){
var statearr_43654_43657 = state_43648;
(statearr_43654_43657[(1)] = cljs.core.first((state_43648[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__43658 = state_43648;
state_43648 = G__43658;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$session$state_machine__16153__auto__ = function(state_43648){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16153__auto____1.call(this,state_43648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16153__auto____0;
fluree$db$session$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16153__auto____1;
return fluree$db$session$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_43655 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_43655[(6)] = c__16227__auto__);

return statearr_43655;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__43660 = arguments.length;
switch (G__43660) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__43661 = session;
var map__43661__$1 = cljs.core.__destructure_map(map__43661);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43661__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43661__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43661__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43661__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43661__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43661__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43661__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__43662_43665 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__43662_43665.cljs$core$IFn$_invoke$arity$3 ? fexpr__43662_43665.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__43662_43665.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__43663_43666 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__43663_43666.cljs$core$IFn$_invoke$arity$0 ? fexpr__43663_43666.cljs$core$IFn$_invoke$arity$0() : fexpr__43663_43666.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_43719){
var state_val_43720 = (state_43719[(1)]);
if((state_val_43720 === (7))){
var inst_43715 = (state_43719[(2)]);
var state_43719__$1 = state_43719;
var statearr_43721_43752 = state_43719__$1;
(statearr_43721_43752[(2)] = inst_43715);

(statearr_43721_43752[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (1))){
var state_43719__$1 = state_43719;
var statearr_43722_43753 = state_43719__$1;
(statearr_43722_43753[(2)] = null);

(statearr_43722_43753[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (4))){
var inst_43670 = (state_43719[(7)]);
var inst_43669 = (state_43719[(2)]);
var inst_43670__$1 = fluree.db.util.async.throw_err(inst_43669);
var inst_43671 = fluree.db.session.from_cache(network,ledger_id);
var inst_43672 = (inst_43670__$1 == null);
var state_43719__$1 = (function (){var statearr_43723 = state_43719;
(statearr_43723[(7)] = inst_43670__$1);

(statearr_43723[(8)] = inst_43671);

return statearr_43723;
})();
if(cljs.core.truth_(inst_43672)){
var statearr_43724_43754 = state_43719__$1;
(statearr_43724_43754[(1)] = (5));

} else {
var statearr_43725_43755 = state_43719__$1;
(statearr_43725_43755[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (15))){
var inst_43707 = (state_43719[(2)]);
var state_43719__$1 = (function (){var statearr_43726 = state_43719;
(statearr_43726[(9)] = inst_43707);

return statearr_43726;
})();
var statearr_43727_43756 = state_43719__$1;
(statearr_43727_43756[(2)] = null);

(statearr_43727_43756[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (13))){
var inst_43711 = (state_43719[(2)]);
var state_43719__$1 = state_43719;
var statearr_43729_43757 = state_43719__$1;
(statearr_43729_43757[(2)] = inst_43711);

(statearr_43729_43757[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (6))){
var inst_43671 = (state_43719[(8)]);
var inst_43677 = (inst_43671 == null);
var state_43719__$1 = state_43719;
if(cljs.core.truth_(inst_43677)){
var statearr_43730_43758 = state_43719__$1;
(statearr_43730_43758[(1)] = (8));

} else {
var statearr_43731_43759 = state_43719__$1;
(statearr_43731_43759[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (17))){
var _ = (function (){var statearr_43732 = state_43719;
(statearr_43732[(4)] = cljs.core.rest((state_43719[(4)])));

return statearr_43732;
})();
var state_43719__$1 = state_43719;
var ex43728 = (state_43719__$1[(2)]);
var statearr_43733_43760 = state_43719__$1;
(statearr_43733_43760[(5)] = ex43728);


var statearr_43734_43761 = state_43719__$1;
(statearr_43734_43761[(1)] = (16));

(statearr_43734_43761[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (3))){
var inst_43717 = (state_43719[(2)]);
var state_43719__$1 = state_43719;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43719__$1,inst_43717);
} else {
if((state_val_43720 === (12))){
var state_43719__$1 = state_43719;
var statearr_43735_43762 = state_43719__$1;
(statearr_43735_43762[(2)] = null);

(statearr_43735_43762[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (2))){
var state_43719__$1 = state_43719;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43719__$1,(4),update_chan);
} else {
if((state_val_43720 === (11))){
var state_43719__$1 = state_43719;
var statearr_43736_43763 = state_43719__$1;
(statearr_43736_43763[(2)] = null);

(statearr_43736_43763[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (9))){
var state_43719__$1 = state_43719;
var statearr_43737_43764 = state_43719__$1;
(statearr_43737_43764[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (5))){
var inst_43674 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_43675 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43674], 0));
var state_43719__$1 = state_43719;
var statearr_43739_43765 = state_43719__$1;
(statearr_43739_43765[(2)] = inst_43675);

(statearr_43739_43765[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (14))){
var inst_43670 = (state_43719[(7)]);
var inst_43671 = (state_43719[(8)]);
var _ = (function (){var statearr_43740 = state_43719;
(statearr_43740[(4)] = cljs.core.cons((17),(state_43719[(4)])));

return statearr_43740;
})();
var inst_43695 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43670,(0),null);
var inst_43696 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43670,(1),null);
var inst_43697 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_43698 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43670], 0));
var inst_43699 = fluree.db.util.core.trunc(inst_43698,(200));
var inst_43700 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43697,inst_43699], 0));
var inst_43701 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_43671,inst_43695,inst_43696) : fluree.db.session.process_ledger_update.call(null,inst_43671,inst_43695,inst_43696));
var state_43719__$1 = (function (){var statearr_43741 = state_43719;
(statearr_43741[(10)] = inst_43700);

return statearr_43741;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43719__$1,(18),inst_43701);
} else {
if((state_val_43720 === (16))){
var inst_43670 = (state_43719[(7)]);
var inst_43685 = (state_43719[(2)]);
var inst_43686 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43685,"Exception processing ledger updates for message: ",inst_43670], 0));
var state_43719__$1 = state_43719;
var statearr_43742_43766 = state_43719__$1;
(statearr_43742_43766[(2)] = inst_43686);

(statearr_43742_43766[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (10))){
var inst_43713 = (state_43719[(2)]);
var state_43719__$1 = state_43719;
var statearr_43743_43767 = state_43719__$1;
(statearr_43743_43767[(2)] = inst_43713);

(statearr_43743_43767[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (18))){
var inst_43703 = (state_43719[(2)]);
var inst_43704 = fluree.db.util.async.throw_err(inst_43703);
var _ = (function (){var statearr_43744 = state_43719;
(statearr_43744[(4)] = cljs.core.rest((state_43719[(4)])));

return statearr_43744;
})();
var state_43719__$1 = state_43719;
var statearr_43745_43768 = state_43719__$1;
(statearr_43745_43768[(2)] = inst_43704);

(statearr_43745_43768[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43720 === (8))){
var inst_43670 = (state_43719[(7)]);
var inst_43679 = cljs.core.first(inst_43670);
var inst_43680 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43679], 0));
var inst_43681 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_43680].join('');
var inst_43682 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43681], 0));
var state_43719__$1 = state_43719;
var statearr_43746_43769 = state_43719__$1;
(statearr_43746_43769[(2)] = inst_43682);

(statearr_43746_43769[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__16153__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__16153__auto____0 = (function (){
var statearr_43747 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43747[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__16153__auto__);

(statearr_43747[(1)] = (1));

return statearr_43747;
});
var fluree$db$session$process_ledger_updates_$_state_machine__16153__auto____1 = (function (state_43719){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_43719);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e43748){var ex__16156__auto__ = e43748;
var statearr_43749_43770 = state_43719;
(statearr_43749_43770[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_43719[(4)]))){
var statearr_43750_43771 = state_43719;
(statearr_43750_43771[(1)] = cljs.core.first((state_43719[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__43772 = state_43719;
state_43719 = G__43772;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__16153__auto__ = function(state_43719){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__16153__auto____1.call(this,state_43719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__16153__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__16153__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_43751 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_43751[(6)] = c__16227__auto__);

return statearr_43751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__43773){
var map__43774 = p__43773;
var map__43774__$1 = cljs.core.__destructure_map(map__43774);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43774__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43774__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43774__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43774__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43774__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43774__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43774__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43774__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43774__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__43778 = block_result;
var map__43778__$1 = cljs.core.__destructure_map(map__43778);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43778__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43778__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43778__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43778__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43778__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__43779 = tx_result;
var map__43779__$1 = cljs.core.__destructure_map(map__43779);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43779__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43779__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__43775_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__43775_SHARP_.t);
}):(function (p1__43776_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__43776_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__43777_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__43777_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__43777_SHARP_,(2));
} else {
return null;
}
}),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__43780 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43780,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43780,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43780,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43780,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = message;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__43784 = arguments.length;
switch (G__43784) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__43785){
var map__43786 = p__43785;
var map__43786__$1 = cljs.core.__destructure_map(map__43786);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43786__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43786__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43786__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43786__$1,cljs.core.cst$kw$jwt);
var vec__43787 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43787,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43787,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43787,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4223__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4223__auto____$1 = state;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__43791_43911 = network;
var G__43792_43912 = ledger_id;
var G__43793_43913 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__43794_43914 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__43795 = cljs.core.seq(tids);
var chunk__43796 = null;
var count__43797 = (0);
var i__43798 = (0);
while(true){
if((i__43798 < count__43797)){
var tid = chunk__43796.cljs$core$IIndexed$_nth$arity$2(null,i__43798);
var temp__5753__auto___43916__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___43916__$1)){
var keyed_callbacks_43917 = temp__5753__auto___43916__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_43918 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__43839_43919 = cljs.core.seq(keyed_callbacks_43917);
var chunk__43840_43920 = null;
var count__43841_43921 = (0);
var i__43842_43922 = (0);
while(true){
if((i__43842_43922 < count__43841_43921)){
var vec__43851_43923 = chunk__43840_43920.cljs$core$IIndexed$_nth$arity$2(null,i__43842_43922);
var k_43924 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43851_43923,(0),null);
var f_43925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43851_43923,(1),null);
try{(f_43925.cljs$core$IFn$_invoke$arity$1 ? f_43925.cljs$core$IFn$_invoke$arity$1(tx_response_43918) : f_43925.call(null,tx_response_43918));
}catch (e43854){var e_43926 = e43854;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_43926,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__43927 = seq__43839_43919;
var G__43928 = chunk__43840_43920;
var G__43929 = count__43841_43921;
var G__43930 = (i__43842_43922 + (1));
seq__43839_43919 = G__43927;
chunk__43840_43920 = G__43928;
count__43841_43921 = G__43929;
i__43842_43922 = G__43930;
continue;
} else {
var temp__5753__auto___43931__$2 = cljs.core.seq(seq__43839_43919);
if(temp__5753__auto___43931__$2){
var seq__43839_43932__$1 = temp__5753__auto___43931__$2;
if(cljs.core.chunked_seq_QMARK_(seq__43839_43932__$1)){
var c__4649__auto___43933 = cljs.core.chunk_first(seq__43839_43932__$1);
var G__43934 = cljs.core.chunk_rest(seq__43839_43932__$1);
var G__43935 = c__4649__auto___43933;
var G__43936 = cljs.core.count(c__4649__auto___43933);
var G__43937 = (0);
seq__43839_43919 = G__43934;
chunk__43840_43920 = G__43935;
count__43841_43921 = G__43936;
i__43842_43922 = G__43937;
continue;
} else {
var vec__43855_43938 = cljs.core.first(seq__43839_43932__$1);
var k_43939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43855_43938,(0),null);
var f_43940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43855_43938,(1),null);
try{(f_43940.cljs$core$IFn$_invoke$arity$1 ? f_43940.cljs$core$IFn$_invoke$arity$1(tx_response_43918) : f_43940.call(null,tx_response_43918));
}catch (e43858){var e_43941 = e43858;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_43941,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__43942 = cljs.core.next(seq__43839_43932__$1);
var G__43943 = null;
var G__43944 = (0);
var G__43945 = (0);
seq__43839_43919 = G__43942;
chunk__43840_43920 = G__43943;
count__43841_43921 = G__43944;
i__43842_43922 = G__43945;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__43946 = seq__43795;
var G__43947 = chunk__43796;
var G__43948 = count__43797;
var G__43949 = (i__43798 + (1));
seq__43795 = G__43946;
chunk__43796 = G__43947;
count__43797 = G__43948;
i__43798 = G__43949;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__43795);
if(temp__5753__auto____$1){
var seq__43795__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__43795__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__43795__$1);
var G__43950 = cljs.core.chunk_rest(seq__43795__$1);
var G__43951 = c__4649__auto__;
var G__43952 = cljs.core.count(c__4649__auto__);
var G__43953 = (0);
seq__43795 = G__43950;
chunk__43796 = G__43951;
count__43797 = G__43952;
i__43798 = G__43953;
continue;
} else {
var tid = cljs.core.first(seq__43795__$1);
var temp__5753__auto___43954__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___43954__$2)){
var keyed_callbacks_43955 = temp__5753__auto___43954__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_43956 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__43859_43957 = cljs.core.seq(keyed_callbacks_43955);
var chunk__43860_43958 = null;
var count__43861_43959 = (0);
var i__43862_43960 = (0);
while(true){
if((i__43862_43960 < count__43861_43959)){
var vec__43871_43961 = chunk__43860_43958.cljs$core$IIndexed$_nth$arity$2(null,i__43862_43960);
var k_43962 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43871_43961,(0),null);
var f_43963 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43871_43961,(1),null);
try{(f_43963.cljs$core$IFn$_invoke$arity$1 ? f_43963.cljs$core$IFn$_invoke$arity$1(tx_response_43956) : f_43963.call(null,tx_response_43956));
}catch (e43874){var e_43964 = e43874;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_43964,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__43965 = seq__43859_43957;
var G__43966 = chunk__43860_43958;
var G__43967 = count__43861_43959;
var G__43968 = (i__43862_43960 + (1));
seq__43859_43957 = G__43965;
chunk__43860_43958 = G__43966;
count__43861_43959 = G__43967;
i__43862_43960 = G__43968;
continue;
} else {
var temp__5753__auto___43969__$3 = cljs.core.seq(seq__43859_43957);
if(temp__5753__auto___43969__$3){
var seq__43859_43970__$1 = temp__5753__auto___43969__$3;
if(cljs.core.chunked_seq_QMARK_(seq__43859_43970__$1)){
var c__4649__auto___43971 = cljs.core.chunk_first(seq__43859_43970__$1);
var G__43972 = cljs.core.chunk_rest(seq__43859_43970__$1);
var G__43973 = c__4649__auto___43971;
var G__43974 = cljs.core.count(c__4649__auto___43971);
var G__43975 = (0);
seq__43859_43957 = G__43972;
chunk__43860_43958 = G__43973;
count__43861_43959 = G__43974;
i__43862_43960 = G__43975;
continue;
} else {
var vec__43875_43976 = cljs.core.first(seq__43859_43970__$1);
var k_43977 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43875_43976,(0),null);
var f_43978 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43875_43976,(1),null);
try{(f_43978.cljs$core$IFn$_invoke$arity$1 ? f_43978.cljs$core$IFn$_invoke$arity$1(tx_response_43956) : f_43978.call(null,tx_response_43956));
}catch (e43878){var e_43979 = e43878;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_43979,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__43980 = cljs.core.next(seq__43859_43970__$1);
var G__43981 = null;
var G__43982 = (0);
var G__43983 = (0);
seq__43859_43957 = G__43980;
chunk__43860_43958 = G__43981;
count__43861_43959 = G__43982;
i__43862_43960 = G__43983;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__43984 = cljs.core.next(seq__43795__$1);
var G__43985 = null;
var G__43986 = (0);
var G__43987 = (0);
seq__43795 = G__43984;
chunk__43796 = G__43985;
count__43797 = G__43986;
i__43798 = G__43987;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__43790_43915 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__43790_43915.cljs$core$IFn$_invoke$arity$4 ? fexpr__43790_43915.cljs$core$IFn$_invoke$arity$4(G__43791_43911,G__43792_43912,G__43793_43913,G__43794_43914) : fexpr__43790_43915.call(null,G__43791_43911,G__43792_43912,G__43793_43913,G__43794_43914));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_43988 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__16227__auto___43989 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_43895){
var state_val_43896 = (state_43895[(1)]);
if((state_val_43896 === (1))){
var state_43895__$1 = state_43895;
var statearr_43897_43990 = state_43895__$1;
(statearr_43897_43990[(2)] = null);

(statearr_43897_43990[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43896 === (2))){
var inst_43880 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_43895__$1 = state_43895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43895__$1,(4),inst_43880);
} else {
if((state_val_43896 === (3))){
var inst_43893 = (state_43895[(2)]);
var state_43895__$1 = state_43895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43895__$1,inst_43893);
} else {
if((state_val_43896 === (4))){
var inst_43882 = (state_43895[(7)]);
var inst_43882__$1 = (state_43895[(2)]);
var inst_43883 = (inst_43882__$1 == null);
var state_43895__$1 = (function (){var statearr_43898 = state_43895;
(statearr_43898[(7)] = inst_43882__$1);

return statearr_43898;
})();
if(cljs.core.truth_(inst_43883)){
var statearr_43899_43991 = state_43895__$1;
(statearr_43899_43991[(1)] = (5));

} else {
var statearr_43900_43992 = state_43895__$1;
(statearr_43900_43992[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43896 === (5))){
var inst_43885 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_43886 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43885], 0));
var state_43895__$1 = state_43895;
var statearr_43901_43993 = state_43895__$1;
(statearr_43901_43993[(2)] = inst_43886);

(statearr_43901_43993[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43896 === (6))){
var inst_43882 = (state_43895[(7)]);
var inst_43888 = (transact_handler_43988.cljs$core$IFn$_invoke$arity$2 ? transact_handler_43988.cljs$core$IFn$_invoke$arity$2(conn,inst_43882) : transact_handler_43988.call(null,conn,inst_43882));
var state_43895__$1 = (function (){var statearr_43902 = state_43895;
(statearr_43902[(8)] = inst_43888);

return statearr_43902;
})();
var statearr_43903_43994 = state_43895__$1;
(statearr_43903_43994[(2)] = null);

(statearr_43903_43994[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43896 === (7))){
var inst_43891 = (state_43895[(2)]);
var state_43895__$1 = state_43895;
var statearr_43904_43995 = state_43895__$1;
(statearr_43904_43995[(2)] = inst_43891);

(statearr_43904_43995[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__16153__auto__ = null;
var fluree$db$session$state_machine__16153__auto____0 = (function (){
var statearr_43905 = [null,null,null,null,null,null,null,null,null];
(statearr_43905[(0)] = fluree$db$session$state_machine__16153__auto__);

(statearr_43905[(1)] = (1));

return statearr_43905;
});
var fluree$db$session$state_machine__16153__auto____1 = (function (state_43895){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_43895);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e43906){var ex__16156__auto__ = e43906;
var statearr_43907_43996 = state_43895;
(statearr_43907_43996[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_43895[(4)]))){
var statearr_43908_43997 = state_43895;
(statearr_43908_43997[(1)] = cljs.core.first((state_43895[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__43998 = state_43895;
state_43895 = G__43998;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$session$state_machine__16153__auto__ = function(state_43895){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16153__auto____1.call(this,state_43895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16153__auto____0;
fluree$db$session$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16153__auto____1;
return fluree$db$session$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_43909 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_43909[(6)] = c__16227__auto___43989);

return statearr_43909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__43999_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__43999_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__43999_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__44000_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__44000_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
}));

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__44003 = arguments.length;
switch (G__44003) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__44004 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__44001_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__44001_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
}),G__44004);
} else {
return G__44004;
}
})();
var seq__44005 = cljs.core.seq(sessions);
var chunk__44006 = null;
var count__44007 = (0);
var i__44008 = (0);
while(true){
if((i__44008 < count__44007)){
var session = chunk__44006.cljs$core$IIndexed$_nth$arity$2(null,i__44008);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__44010 = seq__44005;
var G__44011 = chunk__44006;
var G__44012 = count__44007;
var G__44013 = (i__44008 + (1));
seq__44005 = G__44010;
chunk__44006 = G__44011;
count__44007 = G__44012;
i__44008 = G__44013;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__44005);
if(temp__5753__auto__){
var seq__44005__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44005__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__44005__$1);
var G__44014 = cljs.core.chunk_rest(seq__44005__$1);
var G__44015 = c__4649__auto__;
var G__44016 = cljs.core.count(c__4649__auto__);
var G__44017 = (0);
seq__44005 = G__44014;
chunk__44006 = G__44015;
count__44007 = G__44016;
i__44008 = G__44017;
continue;
} else {
var session = cljs.core.first(seq__44005__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__44018 = cljs.core.next(seq__44005__$1);
var G__44019 = null;
var G__44020 = (0);
var G__44021 = (0);
seq__44005 = G__44018;
chunk__44006 = G__44019;
count__44007 = G__44020;
i__44008 = G__44021;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
