// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_32948){
var state_val_32949 = (state_32948[(1)]);
if((state_val_32949 === (7))){
var inst_32937 = (state_32948[(7)]);
var inst_32939 = fluree.db.storage.core.serde(conn);
var inst_32940 = fluree.db.serde.protocol._deserialize_block(inst_32939,inst_32937);
var state_32948__$1 = state_32948;
var statearr_32950_32969 = state_32948__$1;
(statearr_32950_32969[(2)] = inst_32940);

(statearr_32950_32969[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32949 === (1))){
var state_32948__$1 = state_32948;
var statearr_32951_32970 = state_32948__$1;
(statearr_32951_32970[(2)] = null);

(statearr_32951_32970[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32949 === (4))){
var inst_32927 = (state_32948[(2)]);
var state_32948__$1 = state_32948;
var statearr_32952_32971 = state_32948__$1;
(statearr_32952_32971[(2)] = inst_32927);

(statearr_32952_32971[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32949 === (6))){
var inst_32937 = (state_32948[(7)]);
var inst_32936 = (state_32948[(2)]);
var inst_32937__$1 = fluree.db.util.async.throw_err(inst_32936);
var state_32948__$1 = (function (){var statearr_32953 = state_32948;
(statearr_32953[(7)] = inst_32937__$1);

return statearr_32953;
})();
if(cljs.core.truth_(inst_32937__$1)){
var statearr_32954_32972 = state_32948__$1;
(statearr_32954_32972[(1)] = (7));

} else {
var statearr_32955_32973 = state_32948__$1;
(statearr_32955_32973[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32949 === (3))){
var inst_32946 = (state_32948[(2)]);
var state_32948__$1 = state_32948;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32948__$1,inst_32946);
} else {
if((state_val_32949 === (2))){
var _ = (function (){var statearr_32957 = state_32948;
(statearr_32957[(4)] = cljs.core.cons((5),(state_32948[(4)])));

return statearr_32957;
})();
var inst_32933 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_32934 = fluree.db.storage.core.storage_read(conn,inst_32933);
var state_32948__$1 = state_32948;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32948__$1,(6),inst_32934);
} else {
if((state_val_32949 === (9))){
var inst_32943 = (state_32948[(2)]);
var _ = (function (){var statearr_32958 = state_32948;
(statearr_32958[(4)] = cljs.core.rest((state_32948[(4)])));

return statearr_32958;
})();
var state_32948__$1 = state_32948;
var statearr_32959_32974 = state_32948__$1;
(statearr_32959_32974[(2)] = inst_32943);

(statearr_32959_32974[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32949 === (5))){
var _ = (function (){var statearr_32960 = state_32948;
(statearr_32960[(4)] = cljs.core.rest((state_32948[(4)])));

return statearr_32960;
})();
var state_32948__$1 = state_32948;
var ex32956 = (state_32948__$1[(2)]);
var statearr_32961_32975 = state_32948__$1;
(statearr_32961_32975[(5)] = ex32956);


if((ex32956 instanceof Error)){
var statearr_32962_32976 = state_32948__$1;
(statearr_32962_32976[(1)] = (4));

(statearr_32962_32976[(5)] = null);

} else {
throw ex32956;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32949 === (8))){
var state_32948__$1 = state_32948;
var statearr_32963_32977 = state_32948__$1;
(statearr_32963_32977[(2)] = null);

(statearr_32963_32977[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__16153__auto____0 = (function (){
var statearr_32964 = [null,null,null,null,null,null,null,null];
(statearr_32964[(0)] = fluree$db$storage$core$read_block_$_state_machine__16153__auto__);

(statearr_32964[(1)] = (1));

return statearr_32964;
});
var fluree$db$storage$core$read_block_$_state_machine__16153__auto____1 = (function (state_32948){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_32948);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e32965){var ex__16156__auto__ = e32965;
var statearr_32966_32978 = state_32948;
(statearr_32966_32978[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_32948[(4)]))){
var statearr_32967_32979 = state_32948;
(statearr_32967_32979[(1)] = cljs.core.first((state_32948[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__32980 = state_32948;
state_32948 = G__32980;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__16153__auto__ = function(state_32948){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__16153__auto____1.call(this,state_32948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__16153__auto____0;
fluree$db$storage$core$read_block_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__16153__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_32968 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_32968[(6)] = c__16227__auto__);

return statearr_32968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33003){
var state_val_33004 = (state_33003[(1)]);
if((state_val_33004 === (7))){
var inst_32992 = (state_33003[(7)]);
var inst_32994 = fluree.db.storage.core.serde(conn);
var inst_32995 = fluree.db.serde.protocol._deserialize_block(inst_32994,inst_32992);
var state_33003__$1 = state_33003;
var statearr_33005_33024 = state_33003__$1;
(statearr_33005_33024[(2)] = inst_32995);

(statearr_33005_33024[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33004 === (1))){
var state_33003__$1 = state_33003;
var statearr_33006_33025 = state_33003__$1;
(statearr_33006_33025[(2)] = null);

(statearr_33006_33025[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33004 === (4))){
var inst_32981 = (state_33003[(2)]);
var state_33003__$1 = state_33003;
var statearr_33007_33026 = state_33003__$1;
(statearr_33007_33026[(2)] = inst_32981);

(statearr_33007_33026[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33004 === (6))){
var inst_32992 = (state_33003[(7)]);
var inst_32991 = (state_33003[(2)]);
var inst_32992__$1 = fluree.db.util.async.throw_err(inst_32991);
var state_33003__$1 = (function (){var statearr_33008 = state_33003;
(statearr_33008[(7)] = inst_32992__$1);

return statearr_33008;
})();
if(cljs.core.truth_(inst_32992__$1)){
var statearr_33009_33027 = state_33003__$1;
(statearr_33009_33027[(1)] = (7));

} else {
var statearr_33010_33028 = state_33003__$1;
(statearr_33010_33028[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33004 === (3))){
var inst_33001 = (state_33003[(2)]);
var state_33003__$1 = state_33003;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33003__$1,inst_33001);
} else {
if((state_val_33004 === (2))){
var _ = (function (){var statearr_33012 = state_33003;
(statearr_33012[(4)] = cljs.core.cons((5),(state_33003[(4)])));

return statearr_33012;
})();
var inst_32987 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_32988 = [inst_32987,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_32989 = fluree.db.storage.core.storage_read(conn,inst_32988);
var state_33003__$1 = state_33003;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33003__$1,(6),inst_32989);
} else {
if((state_val_33004 === (9))){
var inst_32998 = (state_33003[(2)]);
var _ = (function (){var statearr_33013 = state_33003;
(statearr_33013[(4)] = cljs.core.rest((state_33003[(4)])));

return statearr_33013;
})();
var state_33003__$1 = state_33003;
var statearr_33014_33029 = state_33003__$1;
(statearr_33014_33029[(2)] = inst_32998);

(statearr_33014_33029[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33004 === (5))){
var _ = (function (){var statearr_33015 = state_33003;
(statearr_33015[(4)] = cljs.core.rest((state_33003[(4)])));

return statearr_33015;
})();
var state_33003__$1 = state_33003;
var ex33011 = (state_33003__$1[(2)]);
var statearr_33016_33030 = state_33003__$1;
(statearr_33016_33030[(5)] = ex33011);


if((ex33011 instanceof Error)){
var statearr_33017_33031 = state_33003__$1;
(statearr_33017_33031[(1)] = (4));

(statearr_33017_33031[(5)] = null);

} else {
throw ex33011;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33004 === (8))){
var state_33003__$1 = state_33003;
var statearr_33018_33032 = state_33003__$1;
(statearr_33018_33032[(2)] = null);

(statearr_33018_33032[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__16153__auto____0 = (function (){
var statearr_33019 = [null,null,null,null,null,null,null,null];
(statearr_33019[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__16153__auto__);

(statearr_33019[(1)] = (1));

return statearr_33019;
});
var fluree$db$storage$core$read_block_version_$_state_machine__16153__auto____1 = (function (state_33003){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33003);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33020){var ex__16156__auto__ = e33020;
var statearr_33021_33033 = state_33003;
(statearr_33021_33033[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33003[(4)]))){
var statearr_33022_33034 = state_33003;
(statearr_33022_33034[(1)] = cljs.core.first((state_33003[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33035 = state_33003;
state_33003 = G__33035;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__16153__auto__ = function(state_33003){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__16153__auto____1.call(this,state_33003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__16153__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__16153__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33023 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33023[(6)] = c__16227__auto__);

return statearr_33023;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33059){
var state_val_33060 = (state_33059[(1)]);
if((state_val_33060 === (1))){
var state_33059__$1 = state_33059;
var statearr_33061_33075 = state_33059__$1;
(statearr_33061_33075[(2)] = null);

(statearr_33061_33075[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33060 === (2))){
var _ = (function (){var statearr_33062 = state_33059;
(statearr_33062[(4)] = cljs.core.cons((5),(state_33059[(4)])));

return statearr_33062;
})();
var inst_33042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33043 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_33044 = (new cljs.core.PersistentVector(null,3,(5),inst_33042,inst_33043,null));
var inst_33045 = cljs.core.select_keys(block_data,inst_33044);
var inst_33046 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_33045);
var inst_33047 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_33046);
var inst_33048 = [inst_33047,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_33049 = fluree.db.storage.core.serde(conn);
var inst_33050 = fluree.db.serde.protocol._serialize_block(inst_33049,inst_33045);
var inst_33051 = fluree.db.storage.core.storage_write(conn,inst_33048,inst_33050);
var state_33059__$1 = state_33059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33059__$1,(6),inst_33051);
} else {
if((state_val_33060 === (3))){
var inst_33057 = (state_33059[(2)]);
var state_33059__$1 = state_33059;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33059__$1,inst_33057);
} else {
if((state_val_33060 === (4))){
var inst_33036 = (state_33059[(2)]);
var state_33059__$1 = state_33059;
var statearr_33064_33076 = state_33059__$1;
(statearr_33064_33076[(2)] = inst_33036);

(statearr_33064_33076[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33060 === (5))){
var _ = (function (){var statearr_33065 = state_33059;
(statearr_33065[(4)] = cljs.core.rest((state_33059[(4)])));

return statearr_33065;
})();
var state_33059__$1 = state_33059;
var ex33063 = (state_33059__$1[(2)]);
var statearr_33066_33077 = state_33059__$1;
(statearr_33066_33077[(5)] = ex33063);


if((ex33063 instanceof Error)){
var statearr_33067_33078 = state_33059__$1;
(statearr_33067_33078[(1)] = (4));

(statearr_33067_33078[(5)] = null);

} else {
throw ex33063;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33060 === (6))){
var inst_33053 = (state_33059[(2)]);
var inst_33054 = fluree.db.util.async.throw_err(inst_33053);
var _ = (function (){var statearr_33068 = state_33059;
(statearr_33068[(4)] = cljs.core.rest((state_33059[(4)])));

return statearr_33068;
})();
var state_33059__$1 = state_33059;
var statearr_33069_33079 = state_33059__$1;
(statearr_33069_33079[(2)] = inst_33054);

(statearr_33069_33079[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__16153__auto____0 = (function (){
var statearr_33070 = [null,null,null,null,null,null,null];
(statearr_33070[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__16153__auto__);

(statearr_33070[(1)] = (1));

return statearr_33070;
});
var fluree$db$storage$core$write_block_version_$_state_machine__16153__auto____1 = (function (state_33059){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33059);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33071){var ex__16156__auto__ = e33071;
var statearr_33072_33080 = state_33059;
(statearr_33072_33080[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33059[(4)]))){
var statearr_33073_33081 = state_33059;
(statearr_33073_33081[(1)] = cljs.core.first((state_33059[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33082 = state_33059;
state_33059 = G__33082;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__16153__auto__ = function(state_33059){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__16153__auto____1.call(this,state_33059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__16153__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__16153__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33074 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33074[(6)] = c__16227__auto__);

return statearr_33074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33105){
var state_val_33106 = (state_33105[(1)]);
if((state_val_33106 === (1))){
var state_33105__$1 = state_33105;
var statearr_33107_33121 = state_33105__$1;
(statearr_33107_33121[(2)] = null);

(statearr_33107_33121[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33106 === (2))){
var _ = (function (){var statearr_33108 = state_33105;
(statearr_33108[(4)] = cljs.core.cons((5),(state_33105[(4)])));

return statearr_33108;
})();
var inst_33089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33090 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_33091 = (new cljs.core.PersistentVector(null,3,(5),inst_33089,inst_33090,null));
var inst_33092 = cljs.core.select_keys(block_data,inst_33091);
var inst_33093 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_33092);
var inst_33094 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_33093);
var inst_33095 = fluree.db.storage.core.serde(conn);
var inst_33096 = fluree.db.serde.protocol._serialize_block(inst_33095,inst_33092);
var inst_33097 = fluree.db.storage.core.storage_write(conn,inst_33094,inst_33096);
var state_33105__$1 = state_33105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33105__$1,(6),inst_33097);
} else {
if((state_val_33106 === (3))){
var inst_33103 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33105__$1,inst_33103);
} else {
if((state_val_33106 === (4))){
var inst_33083 = (state_33105[(2)]);
var state_33105__$1 = state_33105;
var statearr_33110_33122 = state_33105__$1;
(statearr_33110_33122[(2)] = inst_33083);

(statearr_33110_33122[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33106 === (5))){
var _ = (function (){var statearr_33111 = state_33105;
(statearr_33111[(4)] = cljs.core.rest((state_33105[(4)])));

return statearr_33111;
})();
var state_33105__$1 = state_33105;
var ex33109 = (state_33105__$1[(2)]);
var statearr_33112_33123 = state_33105__$1;
(statearr_33112_33123[(5)] = ex33109);


if((ex33109 instanceof Error)){
var statearr_33113_33124 = state_33105__$1;
(statearr_33113_33124[(1)] = (4));

(statearr_33113_33124[(5)] = null);

} else {
throw ex33109;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33106 === (6))){
var inst_33099 = (state_33105[(2)]);
var inst_33100 = fluree.db.util.async.throw_err(inst_33099);
var _ = (function (){var statearr_33114 = state_33105;
(statearr_33114[(4)] = cljs.core.rest((state_33105[(4)])));

return statearr_33114;
})();
var state_33105__$1 = state_33105;
var statearr_33115_33125 = state_33105__$1;
(statearr_33115_33125[(2)] = inst_33100);

(statearr_33115_33125[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__16153__auto____0 = (function (){
var statearr_33116 = [null,null,null,null,null,null,null];
(statearr_33116[(0)] = fluree$db$storage$core$write_block_$_state_machine__16153__auto__);

(statearr_33116[(1)] = (1));

return statearr_33116;
});
var fluree$db$storage$core$write_block_$_state_machine__16153__auto____1 = (function (state_33105){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33105);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33117){var ex__16156__auto__ = e33117;
var statearr_33118_33126 = state_33105;
(statearr_33118_33126[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33105[(4)]))){
var statearr_33119_33127 = state_33105;
(statearr_33119_33127[(1)] = cljs.core.first((state_33105[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33128 = state_33105;
state_33105 = G__33128;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__16153__auto__ = function(state_33105){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__16153__auto____1.call(this,state_33105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__16153__auto____0;
fluree$db$storage$core$write_block_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__16153__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33120 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33120[(6)] = c__16227__auto__);

return statearr_33120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33148){
var state_val_33149 = (state_33148[(1)]);
if((state_val_33149 === (1))){
var state_33148__$1 = state_33148;
var statearr_33150_33164 = state_33148__$1;
(statearr_33150_33164[(2)] = null);

(statearr_33150_33164[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33149 === (2))){
var _ = (function (){var statearr_33151 = state_33148;
(statearr_33151[(4)] = cljs.core.cons((5),(state_33148[(4)])));

return statearr_33151;
})();
var inst_33135 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_33136 = [history,next_his_key];
var inst_33137 = cljs.core.PersistentHashMap.fromArrays(inst_33135,inst_33136);
var inst_33138 = fluree.db.storage.core.serde(conn);
var inst_33139 = fluree.db.serde.protocol._serialize_leaf(inst_33138,inst_33137);
var inst_33140 = fluree.db.storage.core.storage_write(conn,his_key,inst_33139);
var state_33148__$1 = state_33148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33148__$1,(6),inst_33140);
} else {
if((state_val_33149 === (3))){
var inst_33146 = (state_33148[(2)]);
var state_33148__$1 = state_33148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33148__$1,inst_33146);
} else {
if((state_val_33149 === (4))){
var inst_33129 = (state_33148[(2)]);
var state_33148__$1 = state_33148;
var statearr_33153_33165 = state_33148__$1;
(statearr_33153_33165[(2)] = inst_33129);

(statearr_33153_33165[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33149 === (5))){
var _ = (function (){var statearr_33154 = state_33148;
(statearr_33154[(4)] = cljs.core.rest((state_33148[(4)])));

return statearr_33154;
})();
var state_33148__$1 = state_33148;
var ex33152 = (state_33148__$1[(2)]);
var statearr_33155_33166 = state_33148__$1;
(statearr_33155_33166[(5)] = ex33152);


if((ex33152 instanceof Error)){
var statearr_33156_33167 = state_33148__$1;
(statearr_33156_33167[(1)] = (4));

(statearr_33156_33167[(5)] = null);

} else {
throw ex33152;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33149 === (6))){
var inst_33142 = (state_33148[(2)]);
var inst_33143 = fluree.db.util.async.throw_err(inst_33142);
var _ = (function (){var statearr_33157 = state_33148;
(statearr_33157[(4)] = cljs.core.rest((state_33148[(4)])));

return statearr_33157;
})();
var state_33148__$1 = state_33148;
var statearr_33158_33168 = state_33148__$1;
(statearr_33158_33168[(2)] = inst_33143);

(statearr_33158_33168[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__16153__auto____0 = (function (){
var statearr_33159 = [null,null,null,null,null,null,null];
(statearr_33159[(0)] = fluree$db$storage$core$write_history_$_state_machine__16153__auto__);

(statearr_33159[(1)] = (1));

return statearr_33159;
});
var fluree$db$storage$core$write_history_$_state_machine__16153__auto____1 = (function (state_33148){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33148);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33160){var ex__16156__auto__ = e33160;
var statearr_33161_33169 = state_33148;
(statearr_33161_33169[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33148[(4)]))){
var statearr_33162_33170 = state_33148;
(statearr_33162_33170[(1)] = cljs.core.first((state_33148[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33171 = state_33148;
state_33148 = G__33171;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__16153__auto__ = function(state_33148){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__16153__auto____1.call(this,state_33148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__16153__auto____0;
fluree$db$storage$core$write_history_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__16153__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33163 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33163[(6)] = c__16227__auto__);

return statearr_33163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33197){
var state_val_33198 = (state_33197[(1)]);
if((state_val_33198 === (1))){
var state_33197__$1 = state_33197;
var statearr_33199_33216 = state_33197__$1;
(statearr_33199_33216[(2)] = null);

(statearr_33199_33216[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33198 === (2))){
var inst_33178 = (state_33197[(7)]);
var _ = (function (){var statearr_33200 = state_33197;
(statearr_33200[(4)] = cljs.core.cons((5),(state_33197[(4)])));

return statearr_33200;
})();
var inst_33178__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_33179 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33178__$1),"-his"].join('');
var inst_33180 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_33181 = [flakes,inst_33179];
var inst_33182 = cljs.core.PersistentHashMap.fromArrays(inst_33180,inst_33181);
var inst_33183 = fluree.db.storage.core.serde(conn);
var inst_33184 = fluree.db.serde.protocol._serialize_leaf(inst_33183,inst_33182);
var inst_33185 = fluree.db.storage.core.write_history(conn,history,inst_33179,null);
var inst_33186 = fluree.db.storage.core.storage_write(conn,inst_33178__$1,inst_33184);
var state_33197__$1 = (function (){var statearr_33201 = state_33197;
(statearr_33201[(7)] = inst_33178__$1);

(statearr_33201[(8)] = inst_33186);

return statearr_33201;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33197__$1,(6),inst_33185);
} else {
if((state_val_33198 === (3))){
var inst_33195 = (state_33197[(2)]);
var state_33197__$1 = state_33197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33197__$1,inst_33195);
} else {
if((state_val_33198 === (4))){
var inst_33172 = (state_33197[(2)]);
var state_33197__$1 = state_33197;
var statearr_33203_33217 = state_33197__$1;
(statearr_33203_33217[(2)] = inst_33172);

(statearr_33203_33217[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33198 === (5))){
var _ = (function (){var statearr_33204 = state_33197;
(statearr_33204[(4)] = cljs.core.rest((state_33197[(4)])));

return statearr_33204;
})();
var state_33197__$1 = state_33197;
var ex33202 = (state_33197__$1[(2)]);
var statearr_33205_33218 = state_33197__$1;
(statearr_33205_33218[(5)] = ex33202);


if((ex33202 instanceof Error)){
var statearr_33206_33219 = state_33197__$1;
(statearr_33206_33219[(1)] = (4));

(statearr_33206_33219[(5)] = null);

} else {
throw ex33202;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33198 === (6))){
var inst_33186 = (state_33197[(8)]);
var inst_33188 = (state_33197[(2)]);
var inst_33189 = fluree.db.util.async.throw_err(inst_33188);
var state_33197__$1 = (function (){var statearr_33207 = state_33197;
(statearr_33207[(9)] = inst_33189);

return statearr_33207;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33197__$1,(7),inst_33186);
} else {
if((state_val_33198 === (7))){
var inst_33178 = (state_33197[(7)]);
var inst_33191 = (state_33197[(2)]);
var inst_33192 = fluree.db.util.async.throw_err(inst_33191);
var _ = (function (){var statearr_33208 = state_33197;
(statearr_33208[(4)] = cljs.core.rest((state_33197[(4)])));

return statearr_33208;
})();
var state_33197__$1 = (function (){var statearr_33209 = state_33197;
(statearr_33209[(10)] = inst_33192);

return statearr_33209;
})();
var statearr_33210_33220 = state_33197__$1;
(statearr_33210_33220[(2)] = inst_33178);

(statearr_33210_33220[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__16153__auto____0 = (function (){
var statearr_33211 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33211[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__16153__auto__);

(statearr_33211[(1)] = (1));

return statearr_33211;
});
var fluree$db$storage$core$write_leaf_$_state_machine__16153__auto____1 = (function (state_33197){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33197);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33212){var ex__16156__auto__ = e33212;
var statearr_33213_33221 = state_33197;
(statearr_33213_33221[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33197[(4)]))){
var statearr_33214_33222 = state_33197;
(statearr_33214_33222[(1)] = cljs.core.first((state_33197[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33223 = state_33197;
state_33197 = G__33223;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__16153__auto__ = function(state_33197){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__16153__auto____1.call(this,state_33197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__16153__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__16153__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33215 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33215[(6)] = c__16227__auto__);

return statearr_33215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33240){
var state_val_33241 = (state_33240[(1)]);
if((state_val_33241 === (1))){
var state_33240__$1 = state_33240;
var statearr_33242_33257 = state_33240__$1;
(statearr_33242_33257[(2)] = null);

(statearr_33242_33257[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33241 === (2))){
var _ = (function (){var statearr_33243 = state_33240;
(statearr_33243[(4)] = cljs.core.cons((5),(state_33240[(4)])));

return statearr_33243;
})();
var inst_33230 = fluree.db.storage.core.serde(conn);
var inst_33231 = fluree.db.serde.protocol._serialize_branch(inst_33230,data);
var inst_33232 = fluree.db.storage.core.storage_write(conn,key,inst_33231);
var state_33240__$1 = state_33240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33240__$1,(6),inst_33232);
} else {
if((state_val_33241 === (3))){
var inst_33238 = (state_33240[(2)]);
var state_33240__$1 = state_33240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33240__$1,inst_33238);
} else {
if((state_val_33241 === (4))){
var inst_33224 = (state_33240[(2)]);
var state_33240__$1 = state_33240;
var statearr_33245_33258 = state_33240__$1;
(statearr_33245_33258[(2)] = inst_33224);

(statearr_33245_33258[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33241 === (5))){
var _ = (function (){var statearr_33246 = state_33240;
(statearr_33246[(4)] = cljs.core.rest((state_33240[(4)])));

return statearr_33246;
})();
var state_33240__$1 = state_33240;
var ex33244 = (state_33240__$1[(2)]);
var statearr_33247_33259 = state_33240__$1;
(statearr_33247_33259[(5)] = ex33244);


if((ex33244 instanceof Error)){
var statearr_33248_33260 = state_33240__$1;
(statearr_33248_33260[(1)] = (4));

(statearr_33248_33260[(5)] = null);

} else {
throw ex33244;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33241 === (6))){
var inst_33234 = (state_33240[(2)]);
var inst_33235 = fluree.db.util.async.throw_err(inst_33234);
var _ = (function (){var statearr_33249 = state_33240;
(statearr_33249[(4)] = cljs.core.rest((state_33240[(4)])));

return statearr_33249;
})();
var state_33240__$1 = (function (){var statearr_33250 = state_33240;
(statearr_33250[(7)] = inst_33235);

return statearr_33250;
})();
var statearr_33251_33261 = state_33240__$1;
(statearr_33251_33261[(2)] = key);

(statearr_33251_33261[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__16153__auto____0 = (function (){
var statearr_33252 = [null,null,null,null,null,null,null,null];
(statearr_33252[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__16153__auto__);

(statearr_33252[(1)] = (1));

return statearr_33252;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__16153__auto____1 = (function (state_33240){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33240);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33253){var ex__16156__auto__ = e33253;
var statearr_33254_33262 = state_33240;
(statearr_33254_33262[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33240[(4)]))){
var statearr_33255_33263 = state_33240;
(statearr_33255_33263[(1)] = cljs.core.first((state_33240[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33264 = state_33240;
state_33240 = G__33264;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__16153__auto__ = function(state_33240){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__16153__auto____1.call(this,state_33240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__16153__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__16153__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33256 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33256[(6)] = c__16227__auto__);

return statearr_33256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__33265_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__33265_SHARP_));
}),children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__33266){
var map__33267 = p__33266;
var map__33267__$1 = cljs.core.__destructure_map(map__33267);
var progress = map__33267__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33267__$1,cljs.core.cst$kw$garbage);
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33295){
var state_val_33296 = (state_33295[(1)]);
if((state_val_33296 === (1))){
var state_33295__$1 = state_33295;
var statearr_33297_33313 = state_33295__$1;
(statearr_33297_33313[(2)] = null);

(statearr_33297_33313[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33296 === (2))){
var inst_33281 = (state_33295[(7)]);
var _ = (function (){var statearr_33298 = state_33295;
(statearr_33298[(4)] = cljs.core.cons((5),(state_33295[(4)])));

return statearr_33298;
})();
var inst_33275 = db;
var inst_33276 = cljs.core.__destructure_map(inst_33275);
var inst_33277 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33276,cljs.core.cst$kw$conn);
var inst_33278 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33276,cljs.core.cst$kw$network);
var inst_33279 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33276,cljs.core.cst$kw$dbid);
var inst_33280 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33276,cljs.core.cst$kw$block);
var inst_33281__$1 = fluree.db.storage.core.ledger_garbage_key(inst_33278,inst_33279,inst_33280);
var inst_33282 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_33283 = [inst_33279,inst_33280,garbage];
var inst_33284 = cljs.core.PersistentHashMap.fromArrays(inst_33282,inst_33283);
var inst_33285 = fluree.db.storage.core.serde(inst_33277);
var inst_33286 = fluree.db.serde.protocol._serialize_garbage(inst_33285,inst_33284);
var inst_33287 = fluree.db.storage.core.storage_write(inst_33277,inst_33281__$1,inst_33286);
var state_33295__$1 = (function (){var statearr_33299 = state_33295;
(statearr_33299[(7)] = inst_33281__$1);

return statearr_33299;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33295__$1,(6),inst_33287);
} else {
if((state_val_33296 === (3))){
var inst_33293 = (state_33295[(2)]);
var state_33295__$1 = state_33295;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33295__$1,inst_33293);
} else {
if((state_val_33296 === (4))){
var inst_33268 = (state_33295[(2)]);
var state_33295__$1 = state_33295;
var statearr_33301_33314 = state_33295__$1;
(statearr_33301_33314[(2)] = inst_33268);

(statearr_33301_33314[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33296 === (5))){
var _ = (function (){var statearr_33302 = state_33295;
(statearr_33302[(4)] = cljs.core.rest((state_33295[(4)])));

return statearr_33302;
})();
var state_33295__$1 = state_33295;
var ex33300 = (state_33295__$1[(2)]);
var statearr_33303_33315 = state_33295__$1;
(statearr_33303_33315[(5)] = ex33300);


if((ex33300 instanceof Error)){
var statearr_33304_33316 = state_33295__$1;
(statearr_33304_33316[(1)] = (4));

(statearr_33304_33316[(5)] = null);

} else {
throw ex33300;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33296 === (6))){
var inst_33281 = (state_33295[(7)]);
var inst_33289 = (state_33295[(2)]);
var inst_33290 = fluree.db.util.async.throw_err(inst_33289);
var _ = (function (){var statearr_33305 = state_33295;
(statearr_33305[(4)] = cljs.core.rest((state_33295[(4)])));

return statearr_33305;
})();
var state_33295__$1 = (function (){var statearr_33306 = state_33295;
(statearr_33306[(8)] = inst_33290);

return statearr_33306;
})();
var statearr_33307_33317 = state_33295__$1;
(statearr_33307_33317[(2)] = inst_33281);

(statearr_33307_33317[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__16153__auto____0 = (function (){
var statearr_33308 = [null,null,null,null,null,null,null,null,null];
(statearr_33308[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__16153__auto__);

(statearr_33308[(1)] = (1));

return statearr_33308;
});
var fluree$db$storage$core$write_garbage_$_state_machine__16153__auto____1 = (function (state_33295){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33295);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33309){var ex__16156__auto__ = e33309;
var statearr_33310_33318 = state_33295;
(statearr_33310_33318[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33295[(4)]))){
var statearr_33311_33319 = state_33295;
(statearr_33311_33319[(1)] = cljs.core.first((state_33295[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33320 = state_33295;
state_33295 = G__33320;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__16153__auto__ = function(state_33295){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__16153__auto____1.call(this,state_33295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__16153__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__16153__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33312 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33312[(6)] = c__16227__auto__);

return statearr_33312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__33322 = arguments.length;
switch (G__33322) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33378){
var state_val_33379 = (state_33378[(1)]);
if((state_val_33379 === (7))){
var state_33378__$1 = state_33378;
var statearr_33380_33406 = state_33378__$1;
(statearr_33380_33406[(2)] = (0));

(statearr_33380_33406[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33379 === (1))){
var state_33378__$1 = state_33378;
var statearr_33381_33407 = state_33378__$1;
(statearr_33381_33407[(2)] = null);

(statearr_33381_33407[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33379 === (4))){
var inst_33323 = (state_33378[(2)]);
var state_33378__$1 = state_33378;
var statearr_33382_33408 = state_33378__$1;
(statearr_33382_33408[(2)] = inst_33323);

(statearr_33382_33408[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33379 === (6))){
var inst_33348 = (state_33378[(7)]);
var state_33378__$1 = state_33378;
var statearr_33383_33409 = state_33378__$1;
(statearr_33383_33409[(2)] = inst_33348);

(statearr_33383_33409[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33379 === (3))){
var inst_33376 = (state_33378[(2)]);
var state_33378__$1 = state_33378;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33378__$1,inst_33376);
} else {
if((state_val_33379 === (12))){
var inst_33345 = (state_33378[(8)]);
var inst_33372 = (state_33378[(2)]);
var inst_33373 = fluree.db.util.async.throw_err(inst_33372);
var _ = (function (){var statearr_33384 = state_33378;
(statearr_33384[(4)] = cljs.core.rest((state_33378[(4)])));

return statearr_33384;
})();
var state_33378__$1 = (function (){var statearr_33385 = state_33378;
(statearr_33385[(9)] = inst_33373);

return statearr_33385;
})();
var statearr_33386_33410 = state_33378__$1;
(statearr_33386_33410[(2)] = inst_33345);

(statearr_33386_33410[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33379 === (2))){
var inst_33336 = (state_33378[(10)]);
var inst_33338 = (state_33378[(11)]);
var inst_33340 = (state_33378[(12)]);
var inst_33348 = (state_33378[(7)]);
var _ = (function (){var statearr_33387 = state_33378;
(statearr_33387[(4)] = cljs.core.cons((5),(state_33378[(4)])));

return statearr_33387;
})();
var inst_33330 = db;
var inst_33331 = cljs.core.__destructure_map(inst_33330);
var inst_33332 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33331,cljs.core.cst$kw$network);
var inst_33333 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33331,cljs.core.cst$kw$t);
var inst_33334 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33331,cljs.core.cst$kw$fork);
var inst_33335 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33331,cljs.core.cst$kw$spot);
var inst_33336__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33331,cljs.core.cst$kw$stats);
var inst_33337 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33331,cljs.core.cst$kw$conn);
var inst_33338__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33331,cljs.core.cst$kw$block);
var inst_33339 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33331,cljs.core.cst$kw$psot);
var inst_33340__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33331,cljs.core.cst$kw$dbid);
var inst_33341 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33331,cljs.core.cst$kw$ecount);
var inst_33342 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33331,cljs.core.cst$kw$opst);
var inst_33343 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33331,cljs.core.cst$kw$fork_DASH_block);
var inst_33344 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33331,cljs.core.cst$kw$post);
var inst_33345 = fluree.db.storage.core.ledger_root_key(inst_33332,inst_33340__$1,inst_33338__$1);
var inst_33346 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_33347 = fluree.db.storage.core.child_data(inst_33339);
var inst_33348__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_33336__$1);
var state_33378__$1 = (function (){var statearr_33388 = state_33378;
(statearr_33388[(13)] = inst_33337);

(statearr_33388[(14)] = inst_33342);

(statearr_33388[(15)] = inst_33334);

(statearr_33388[(16)] = inst_33335);

(statearr_33388[(17)] = inst_33347);

(statearr_33388[(18)] = inst_33346);

(statearr_33388[(10)] = inst_33336__$1);

(statearr_33388[(19)] = inst_33341);

(statearr_33388[(20)] = inst_33344);

(statearr_33388[(11)] = inst_33338__$1);

(statearr_33388[(12)] = inst_33340__$1);

(statearr_33388[(8)] = inst_33345);

(statearr_33388[(7)] = inst_33348__$1);

(statearr_33388[(21)] = inst_33343);

(statearr_33388[(22)] = inst_33333);

return statearr_33388;
})();
if(cljs.core.truth_(inst_33348__$1)){
var statearr_33389_33411 = state_33378__$1;
(statearr_33389_33411[(1)] = (6));

} else {
var statearr_33390_33412 = state_33378__$1;
(statearr_33390_33412[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33379 === (11))){
var inst_33337 = (state_33378[(13)]);
var inst_33342 = (state_33378[(14)]);
var inst_33334 = (state_33378[(15)]);
var inst_33335 = (state_33378[(16)]);
var inst_33347 = (state_33378[(17)]);
var inst_33346 = (state_33378[(18)]);
var inst_33336 = (state_33378[(10)]);
var inst_33352 = (state_33378[(23)]);
var inst_33344 = (state_33378[(20)]);
var inst_33338 = (state_33378[(11)]);
var inst_33340 = (state_33378[(12)]);
var inst_33345 = (state_33378[(8)]);
var inst_33343 = (state_33378[(21)]);
var inst_33333 = (state_33378[(22)]);
var inst_33357 = (state_33378[(2)]);
var inst_33358 = fluree.db.storage.core.child_data(inst_33342);
var inst_33359 = fluree.db.storage.core.child_data(inst_33344);
var inst_33360 = fluree.db.util.core.current_time_millis();
var inst_33361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33362 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_33363 = (new cljs.core.PersistentVector(null,2,(5),inst_33361,inst_33362,null));
var inst_33364 = cljs.core.select_keys(inst_33336,inst_33363);
var inst_33365 = fluree.db.storage.core.child_data(inst_33335);
var inst_33366 = [inst_33338,inst_33347,inst_33340,inst_33352,inst_33357,inst_33358,inst_33359,inst_33333,inst_33360,inst_33334,inst_33343,inst_33364,inst_33365];
var inst_33367 = cljs.core.PersistentHashMap.fromArrays(inst_33346,inst_33366);
var inst_33368 = fluree.db.storage.core.serde(inst_33337);
var inst_33369 = fluree.db.serde.protocol._serialize_db_root(inst_33368,inst_33367);
var inst_33370 = fluree.db.storage.core.storage_write(inst_33337,inst_33345,inst_33369);
var state_33378__$1 = state_33378;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33378__$1,(12),inst_33370);
} else {
if((state_val_33379 === (9))){
var inst_33353 = (state_33378[(24)]);
var state_33378__$1 = state_33378;
var statearr_33392_33413 = state_33378__$1;
(statearr_33392_33413[(2)] = inst_33353);

(statearr_33392_33413[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33379 === (5))){
var _ = (function (){var statearr_33393 = state_33378;
(statearr_33393[(4)] = cljs.core.rest((state_33378[(4)])));

return statearr_33393;
})();
var state_33378__$1 = state_33378;
var ex33391 = (state_33378__$1[(2)]);
var statearr_33394_33414 = state_33378__$1;
(statearr_33394_33414[(5)] = ex33391);


if((ex33391 instanceof Error)){
var statearr_33395_33415 = state_33378__$1;
(statearr_33395_33415[(1)] = (4));

(statearr_33395_33415[(5)] = null);

} else {
throw ex33391;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33379 === (10))){
var inst_33341 = (state_33378[(19)]);
var state_33378__$1 = state_33378;
var statearr_33396_33416 = state_33378__$1;
(statearr_33396_33416[(2)] = inst_33341);

(statearr_33396_33416[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33379 === (8))){
var inst_33353 = (state_33378[(24)]);
var inst_33352 = (state_33378[(2)]);
var inst_33353__$1 = custom_ecount;
var state_33378__$1 = (function (){var statearr_33397 = state_33378;
(statearr_33397[(24)] = inst_33353__$1);

(statearr_33397[(23)] = inst_33352);

return statearr_33397;
})();
if(cljs.core.truth_(inst_33353__$1)){
var statearr_33398_33417 = state_33378__$1;
(statearr_33398_33417[(1)] = (9));

} else {
var statearr_33399_33418 = state_33378__$1;
(statearr_33399_33418[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__16153__auto__ = null;
var fluree$db$storage$core$state_machine__16153__auto____0 = (function (){
var statearr_33400 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33400[(0)] = fluree$db$storage$core$state_machine__16153__auto__);

(statearr_33400[(1)] = (1));

return statearr_33400;
});
var fluree$db$storage$core$state_machine__16153__auto____1 = (function (state_33378){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33378);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33401){var ex__16156__auto__ = e33401;
var statearr_33402_33419 = state_33378;
(statearr_33402_33419[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33378[(4)]))){
var statearr_33403_33420 = state_33378;
(statearr_33403_33420[(1)] = cljs.core.first((state_33378[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33421 = state_33378;
state_33378 = G__33421;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__16153__auto__ = function(state_33378){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__16153__auto____1.call(this,state_33378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__16153__auto____0;
fluree$db$storage$core$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__16153__auto____1;
return fluree$db$storage$core$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33404 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33404[(6)] = c__16227__auto__);

return statearr_33404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16227__auto___33480 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33454){
var state_val_33455 = (state_33454[(1)]);
if((state_val_33455 === (7))){
var inst_33434 = (state_33454[(7)]);
var state_33454__$1 = state_33454;
var statearr_33456_33481 = state_33454__$1;
(statearr_33456_33481[(2)] = inst_33434);

(statearr_33456_33481[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33455 === (1))){
var state_33454__$1 = state_33454;
var statearr_33457_33482 = state_33454__$1;
(statearr_33457_33482[(2)] = null);

(statearr_33457_33482[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33455 === (4))){
var inst_33422 = (state_33454[(2)]);
var inst_33423 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_33424 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33422);
var inst_33425 = cljs.core.async.close_BANG_(return_ch);
var state_33454__$1 = (function (){var statearr_33458 = state_33454;
(statearr_33458[(8)] = inst_33424);

(statearr_33458[(9)] = inst_33423);

return statearr_33458;
})();
var statearr_33459_33483 = state_33454__$1;
(statearr_33459_33483[(2)] = inst_33425);

(statearr_33459_33483[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33455 === (6))){
var inst_33433 = (state_33454[(10)]);
var inst_33434 = (state_33454[(7)]);
var inst_33433__$1 = (state_33454[(2)]);
var inst_33434__$1 = (inst_33433__$1 == null);
var state_33454__$1 = (function (){var statearr_33460 = state_33454;
(statearr_33460[(10)] = inst_33433__$1);

(statearr_33460[(7)] = inst_33434__$1);

return statearr_33460;
})();
if(cljs.core.truth_(inst_33434__$1)){
var statearr_33461_33484 = state_33454__$1;
(statearr_33461_33484[(1)] = (7));

} else {
var statearr_33462_33485 = state_33454__$1;
(statearr_33462_33485[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33455 === (3))){
var inst_33452 = (state_33454[(2)]);
var state_33454__$1 = state_33454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33454__$1,inst_33452);
} else {
if((state_val_33455 === (12))){
var inst_33449 = (state_33454[(2)]);
var _ = (function (){var statearr_33463 = state_33454;
(statearr_33463[(4)] = cljs.core.rest((state_33454[(4)])));

return statearr_33463;
})();
var state_33454__$1 = state_33454;
var statearr_33464_33486 = state_33454__$1;
(statearr_33464_33486[(2)] = inst_33449);

(statearr_33464_33486[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33455 === (2))){
var _ = (function (){var statearr_33465 = state_33454;
(statearr_33465[(4)] = cljs.core.cons((5),(state_33454[(4)])));

return statearr_33465;
})();
var inst_33431 = fluree.db.storage.core.storage_read(conn,key);
var state_33454__$1 = state_33454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33454__$1,(6),inst_33431);
} else {
if((state_val_33455 === (11))){
var inst_33433 = (state_33454[(10)]);
var inst_33443 = fluree.db.storage.core.serde(conn);
var inst_33444 = fluree.db.serde.protocol._deserialize_leaf(inst_33443,inst_33433);
var inst_33445 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_33444);
var inst_33446 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_33445);
var inst_33447 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33446);
var state_33454__$1 = state_33454;
var statearr_33467_33487 = state_33454__$1;
(statearr_33467_33487[(2)] = inst_33447);

(statearr_33467_33487[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33455 === (9))){
var inst_33439 = (state_33454[(2)]);
var state_33454__$1 = state_33454;
if(cljs.core.truth_(inst_33439)){
var statearr_33468_33488 = state_33454__$1;
(statearr_33468_33488[(1)] = (10));

} else {
var statearr_33469_33489 = state_33454__$1;
(statearr_33469_33489[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33455 === (5))){
var _ = (function (){var statearr_33470 = state_33454;
(statearr_33470[(4)] = cljs.core.rest((state_33454[(4)])));

return statearr_33470;
})();
var state_33454__$1 = state_33454;
var ex33466 = (state_33454__$1[(2)]);
var statearr_33471_33490 = state_33454__$1;
(statearr_33471_33490[(5)] = ex33466);


var statearr_33472_33491 = state_33454__$1;
(statearr_33472_33491[(1)] = (4));

(statearr_33472_33491[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33455 === (10))){
var inst_33441 = cljs.core.async.close_BANG_(return_ch);
var state_33454__$1 = state_33454;
var statearr_33473_33492 = state_33454__$1;
(statearr_33473_33492[(2)] = inst_33441);

(statearr_33473_33492[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33455 === (8))){
var inst_33433 = (state_33454[(10)]);
var inst_33437 = (inst_33433 instanceof Error);
var state_33454__$1 = state_33454;
var statearr_33474_33493 = state_33454__$1;
(statearr_33474_33493[(2)] = inst_33437);

(statearr_33474_33493[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__16153__auto____0 = (function (){
var statearr_33475 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33475[(0)] = fluree$db$storage$core$reify_history_$_state_machine__16153__auto__);

(statearr_33475[(1)] = (1));

return statearr_33475;
});
var fluree$db$storage$core$reify_history_$_state_machine__16153__auto____1 = (function (state_33454){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33454);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33476){var ex__16156__auto__ = e33476;
var statearr_33477_33494 = state_33454;
(statearr_33477_33494[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33454[(4)]))){
var statearr_33478_33495 = state_33454;
(statearr_33478_33495[(1)] = cljs.core.first((state_33454[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33496 = state_33454;
state_33454 = G__33496;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__16153__auto__ = function(state_33454){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__16153__auto____1.call(this,state_33454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__16153__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__16153__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33479 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33479[(6)] = c__16227__auto___33480);

return statearr_33479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__33498 = arguments.length;
switch (G__33498) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4221__auto__ = (rhs == null);
if(and__4221__auto__){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16227__auto___33610 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33561){
var state_val_33562 = (state_33561[(1)]);
if((state_val_33562 === (7))){
var state_33561__$1 = state_33561;
var statearr_33563_33611 = state_33561__$1;
(statearr_33563_33611[(2)] = cljs.core.cst$kw$novelty);

(statearr_33563_33611[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (20))){
var inst_33540 = cljs.core.PersistentVector.EMPTY;
var state_33561__$1 = state_33561;
var statearr_33564_33612 = state_33561__$1;
(statearr_33564_33612[(2)] = inst_33540);

(statearr_33564_33612[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (1))){
var state_33561__$1 = state_33561;
var statearr_33565_33613 = state_33561__$1;
(statearr_33565_33613[(2)] = null);

(statearr_33565_33613[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (24))){
var state_33561__$1 = state_33561;
var statearr_33566_33614 = state_33561__$1;
(statearr_33566_33614[(2)] = null);

(statearr_33566_33614[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (4))){
var inst_33501 = (state_33561[(2)]);
var inst_33502 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_33503 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_33501);
var inst_33504 = cljs.core.async.close_BANG_(result_ch);
var state_33561__$1 = (function (){var statearr_33567 = state_33561;
(statearr_33567[(7)] = inst_33502);

(statearr_33567[(8)] = inst_33503);

return statearr_33567;
})();
var statearr_33568_33615 = state_33561__$1;
(statearr_33568_33615[(2)] = inst_33504);

(statearr_33568_33615[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (15))){
var inst_33526 = (state_33561[(2)]);
var state_33561__$1 = state_33561;
var statearr_33569_33616 = state_33561__$1;
(statearr_33569_33616[(2)] = inst_33526);

(statearr_33569_33616[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (21))){
var inst_33514 = (state_33561[(9)]);
var inst_33543 = (state_33561[(10)]);
var inst_33513 = (state_33561[(11)]);
var inst_33515 = (state_33561[(12)]);
var inst_33530 = (state_33561[(13)]);
var inst_33550 = (state_33561[(2)]);
var inst_33551 = (function (){var base_node = inst_33513;
var first_flake = inst_33514;
var node_t = inst_33515;
var source = inst_33530;
var coll = inst_33543;
var conj_QMARK_ = inst_33550;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__33571 = f.p;
var fexpr__33570 = (function (){var or__4223__auto__ = remove_preds;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__33570.cljs$core$IFn$_invoke$arity$1 ? fexpr__33570.cljs$core$IFn$_invoke$arity$1(G__33571) : fexpr__33570.call(null,G__33571));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_33552 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_33513);
var inst_33553 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_33551,inst_33552,inst_33543);
var inst_33554 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_33553);
var inst_33555 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33513,cljs.core.cst$kw$flakes,inst_33554);
var inst_33556 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_33555);
var _ = (function (){var statearr_33572 = state_33561;
(statearr_33572[(4)] = cljs.core.rest((state_33561[(4)])));

return statearr_33572;
})();
var state_33561__$1 = state_33561;
var statearr_33573_33617 = state_33561__$1;
(statearr_33573_33617[(2)] = inst_33556);

(statearr_33573_33617[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (13))){
var state_33561__$1 = state_33561;
var statearr_33574_33618 = state_33561__$1;
(statearr_33574_33618[(2)] = cljs.core.cst$kw$none);

(statearr_33574_33618[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (22))){
var inst_33514 = (state_33561[(9)]);
var inst_33543 = (state_33561[(10)]);
var inst_33513 = (state_33561[(11)]);
var inst_33515 = (state_33561[(12)]);
var inst_33530 = (state_33561[(13)]);
var inst_33544 = (function (){var base_node = inst_33513;
var first_flake = inst_33514;
var node_t = inst_33515;
var source = inst_33530;
var coll = inst_33543;
return (function (f){
return f.op === true;
});
})();
var state_33561__$1 = state_33561;
var statearr_33575_33619 = state_33561__$1;
(statearr_33575_33619[(2)] = inst_33544);

(statearr_33575_33619[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (6))){
var inst_33513 = (state_33561[(11)]);
var inst_33515 = (state_33561[(12)]);
var inst_33512 = (state_33561[(2)]);
var inst_33513__$1 = fluree.db.util.async.throw_err(inst_33512);
var inst_33514 = fluree.db.dbproto._first_flake(inst_33513__$1);
var inst_33515__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_33513__$1);
var inst_33516 = (inst_33515__$1 > t);
var state_33561__$1 = (function (){var statearr_33576 = state_33561;
(statearr_33576[(9)] = inst_33514);

(statearr_33576[(11)] = inst_33513__$1);

(statearr_33576[(12)] = inst_33515__$1);

return statearr_33576;
})();
if(cljs.core.truth_(inst_33516)){
var statearr_33577_33620 = state_33561__$1;
(statearr_33577_33620[(1)] = (7));

} else {
var statearr_33578_33621 = state_33561__$1;
(statearr_33578_33621[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (17))){
var inst_33514 = (state_33561[(9)]);
var inst_33531 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_33514,rhs,leftmost_QMARK_,t);
var state_33561__$1 = state_33561;
var statearr_33579_33622 = state_33561__$1;
(statearr_33579_33622[(2)] = inst_33531);

(statearr_33579_33622[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (3))){
var inst_33559 = (state_33561[(2)]);
var state_33561__$1 = state_33561;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33561__$1,inst_33559);
} else {
if((state_val_33562 === (12))){
var inst_33528 = (state_33561[(2)]);
var state_33561__$1 = state_33561;
var statearr_33580_33623 = state_33561__$1;
(statearr_33580_33623[(2)] = inst_33528);

(statearr_33580_33623[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (2))){
var _ = (function (){var statearr_33581 = state_33561;
(statearr_33581[(4)] = cljs.core.cons((5),(state_33561[(4)])));

return statearr_33581;
})();
var inst_33510 = fluree.db.dbproto._resolve(node);
var state_33561__$1 = state_33561;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33561__$1,(6),inst_33510);
} else {
if((state_val_33562 === (23))){
var inst_33514 = (state_33561[(9)]);
var inst_33543 = (state_33561[(10)]);
var inst_33513 = (state_33561[(11)]);
var inst_33515 = (state_33561[(12)]);
var inst_33530 = (state_33561[(13)]);
var inst_33546 = (function (){var base_node = inst_33513;
var first_flake = inst_33514;
var node_t = inst_33515;
var source = inst_33530;
var coll = inst_33543;
return (function (f){
return f.op === false;
});
})();
var state_33561__$1 = state_33561;
var statearr_33582_33624 = state_33561__$1;
(statearr_33582_33624[(2)] = inst_33546);

(statearr_33582_33624[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (19))){
var inst_33533 = (state_33561[(14)]);
var inst_33536 = (state_33561[(2)]);
var inst_33537 = fluree.db.util.async.throw_err(inst_33536);
var inst_33538 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_33533,inst_33537);
var state_33561__$1 = state_33561;
var statearr_33583_33625 = state_33561__$1;
(statearr_33583_33625[(2)] = inst_33538);

(statearr_33583_33625[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (11))){
var inst_33515 = (state_33561[(12)]);
var inst_33522 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33515,t);
var state_33561__$1 = state_33561;
if(inst_33522){
var statearr_33585_33626 = state_33561__$1;
(statearr_33585_33626[(1)] = (13));

} else {
var statearr_33586_33627 = state_33561__$1;
(statearr_33586_33627[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (9))){
var inst_33530 = (state_33561[(13)]);
var inst_33530__$1 = (state_33561[(2)]);
var state_33561__$1 = (function (){var statearr_33587 = state_33561;
(statearr_33587[(13)] = inst_33530__$1);

return statearr_33587;
})();
var G__33588_33628 = inst_33530__$1;
var G__33588_33629__$1 = (((G__33588_33628 instanceof cljs.core.Keyword))?G__33588_33628.fqn:null);
switch (G__33588_33629__$1) {
case "novelty":
var statearr_33589_33631 = state_33561__$1;
(statearr_33589_33631[(1)] = (17));


break;
case "history":
var statearr_33590_33632 = state_33561__$1;
(statearr_33590_33632[(1)] = (18));


break;
case "none":
var statearr_33591_33633 = state_33561__$1;
(statearr_33591_33633[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33588_33629__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (5))){
var _ = (function (){var statearr_33592 = state_33561;
(statearr_33592[(4)] = cljs.core.rest((state_33561[(4)])));

return statearr_33592;
})();
var state_33561__$1 = state_33561;
var ex33584 = (state_33561__$1[(2)]);
var statearr_33593_33634 = state_33561__$1;
(statearr_33593_33634[(5)] = ex33584);


var statearr_33594_33635 = state_33561__$1;
(statearr_33594_33635[(1)] = (4));

(statearr_33594_33635[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (14))){
var state_33561__$1 = state_33561;
var statearr_33595_33636 = state_33561__$1;
(statearr_33595_33636[(2)] = null);

(statearr_33595_33636[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (16))){
var inst_33530 = (state_33561[(13)]);
var inst_33543 = (state_33561[(2)]);
var state_33561__$1 = (function (){var statearr_33596 = state_33561;
(statearr_33596[(10)] = inst_33543);

return statearr_33596;
})();
var G__33597_33637 = inst_33530;
var G__33597_33638__$1 = (((G__33597_33637 instanceof cljs.core.Keyword))?G__33597_33637.fqn:null);
switch (G__33597_33638__$1) {
case "novelty":
var statearr_33598_33640 = state_33561__$1;
(statearr_33598_33640[(1)] = (22));


break;
case "history":
var statearr_33599_33641 = state_33561__$1;
(statearr_33599_33641[(1)] = (23));


break;
case "none":
var statearr_33600_33642 = state_33561__$1;
(statearr_33600_33642[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33597_33638__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (10))){
var state_33561__$1 = state_33561;
var statearr_33601_33643 = state_33561__$1;
(statearr_33601_33643[(2)] = cljs.core.cst$kw$history);

(statearr_33601_33643[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33562 === (18))){
var inst_33514 = (state_33561[(9)]);
var inst_33513 = (state_33561[(11)]);
var inst_33515 = (state_33561[(12)]);
var inst_33530 = (state_33561[(13)]);
var inst_33533 = (function (){var base_node = inst_33513;
var first_flake = inst_33514;
var node_t = inst_33515;
var source = inst_33530;
return (function (p1__33500_SHARP_){
return (p1__33500_SHARP_.t <= t);
});
})();
var inst_33534 = fluree.db.dbproto._resolve_history(node);
var state_33561__$1 = (function (){var statearr_33602 = state_33561;
(statearr_33602[(14)] = inst_33533);

return statearr_33602;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33561__$1,(19),inst_33534);
} else {
if((state_val_33562 === (8))){
var inst_33515 = (state_33561[(12)]);
var inst_33519 = (inst_33515 < t);
var state_33561__$1 = state_33561;
if(cljs.core.truth_(inst_33519)){
var statearr_33603_33644 = state_33561__$1;
(statearr_33603_33644[(1)] = (10));

} else {
var statearr_33604_33645 = state_33561__$1;
(statearr_33604_33645[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__16153__auto____0 = (function (){
var statearr_33605 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33605[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__16153__auto__);

(statearr_33605[(1)] = (1));

return statearr_33605;
});
var fluree$db$storage$core$resolve_t_$_state_machine__16153__auto____1 = (function (state_33561){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33561);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33606){var ex__16156__auto__ = e33606;
var statearr_33607_33646 = state_33561;
(statearr_33607_33646[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33561[(4)]))){
var statearr_33608_33647 = state_33561;
(statearr_33608_33647[(1)] = cljs.core.first((state_33561[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33648 = state_33561;
state_33561 = G__33648;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__16153__auto__ = function(state_33561){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__16153__auto____1.call(this,state_33561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__16153__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__16153__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33609 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33609[(6)] = c__16227__auto___33610);

return statearr_33609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33708){
var state_val_33709 = (state_33708[(1)]);
if((state_val_33709 === (7))){
var inst_33659 = (state_33708[(7)]);
var inst_33663 = (inst_33659 <= from_t);
var state_33708__$1 = state_33708;
var statearr_33710_33750 = state_33708__$1;
(statearr_33710_33750[(2)] = inst_33663);

(statearr_33710_33750[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (20))){
var inst_33693 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_33694 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33693)].join('');
var inst_33695 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33696 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_33697 = cljs.core.PersistentHashMap.fromArrays(inst_33695,inst_33696);
var inst_33698 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33694,inst_33697);
var inst_33699 = (function(){throw inst_33698})();
var state_33708__$1 = state_33708;
var statearr_33711_33751 = state_33708__$1;
(statearr_33711_33751[(2)] = inst_33699);

(statearr_33711_33751[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (1))){
var state_33708__$1 = state_33708;
var statearr_33712_33752 = state_33708__$1;
(statearr_33712_33752[(2)] = null);

(statearr_33712_33752[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (4))){
var inst_33651 = (state_33708[(2)]);
var inst_33652 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_33651], 0));
var inst_33653 = (function(){throw inst_33651})();
var state_33708__$1 = (function (){var statearr_33713 = state_33708;
(statearr_33713[(8)] = inst_33652);

return statearr_33713;
})();
var statearr_33714_33753 = state_33708__$1;
(statearr_33714_33753[(2)] = inst_33653);

(statearr_33714_33753[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (15))){
var inst_33678 = (state_33708[(2)]);
var state_33708__$1 = (function (){var statearr_33715 = state_33708;
(statearr_33715[(9)] = inst_33678);

return statearr_33715;
})();
if(cljs.core.truth_(from_t)){
var statearr_33716_33754 = state_33708__$1;
(statearr_33716_33754[(1)] = (16));

} else {
var statearr_33717_33755 = state_33708__$1;
(statearr_33717_33755[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (21))){
var inst_33687 = (state_33708[(10)]);
var inst_33688 = (state_33708[(11)]);
var inst_33689 = (state_33708[(12)]);
var inst_33701 = (state_33708[(2)]);
var inst_33702 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_33688,inst_33689,leftmost_QMARK_,to_t);
var inst_33703 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33702,inst_33687);
var _ = (function (){var statearr_33718 = state_33708;
(statearr_33718[(4)] = cljs.core.rest((state_33708[(4)])));

return statearr_33718;
})();
var state_33708__$1 = (function (){var statearr_33719 = state_33708;
(statearr_33719[(13)] = inst_33701);

return statearr_33719;
})();
var statearr_33720_33756 = state_33708__$1;
(statearr_33720_33756[(2)] = inst_33703);

(statearr_33720_33756[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (13))){
var inst_33671 = (state_33708[(14)]);
var inst_33659 = (state_33708[(7)]);
var inst_33674 = (function (){var node_t = inst_33659;
var G__33667 = inst_33671;
return (function (p1__33649_SHARP_){
return (p1__33649_SHARP_.t < to_t);
});
})();
var inst_33675 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_33674,inst_33671);
var state_33708__$1 = state_33708;
var statearr_33721_33757 = state_33708__$1;
(statearr_33721_33757[(2)] = inst_33675);

(statearr_33721_33757[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (6))){
var inst_33660 = (state_33708[(15)]);
var state_33708__$1 = state_33708;
var statearr_33722_33758 = state_33708__$1;
(statearr_33722_33758[(2)] = inst_33660);

(statearr_33722_33758[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (17))){
var inst_33678 = (state_33708[(9)]);
var state_33708__$1 = state_33708;
var statearr_33723_33759 = state_33708__$1;
(statearr_33723_33759[(2)] = inst_33678);

(statearr_33723_33759[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (3))){
var inst_33706 = (state_33708[(2)]);
var state_33708__$1 = state_33708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33708__$1,inst_33706);
} else {
if((state_val_33709 === (12))){
var inst_33659 = (state_33708[(7)]);
var inst_33670 = (state_33708[(2)]);
var inst_33671 = fluree.db.util.async.throw_err(inst_33670);
var inst_33672 = (to_t > inst_33659);
var state_33708__$1 = (function (){var statearr_33724 = state_33708;
(statearr_33724[(14)] = inst_33671);

return statearr_33724;
})();
if(cljs.core.truth_(inst_33672)){
var statearr_33725_33760 = state_33708__$1;
(statearr_33725_33760[(1)] = (13));

} else {
var statearr_33726_33761 = state_33708__$1;
(statearr_33726_33761[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (2))){
var inst_33660 = (state_33708[(15)]);
var _ = (function (){var statearr_33727 = state_33708;
(statearr_33727[(4)] = cljs.core.cons((5),(state_33708[(4)])));

return statearr_33727;
})();
var inst_33659 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_33660__$1 = (from_t == null);
var state_33708__$1 = (function (){var statearr_33728 = state_33708;
(statearr_33728[(15)] = inst_33660__$1);

(statearr_33728[(7)] = inst_33659);

return statearr_33728;
})();
if(cljs.core.truth_(inst_33660__$1)){
var statearr_33729_33762 = state_33708__$1;
(statearr_33729_33762[(1)] = (6));

} else {
var statearr_33730_33763 = state_33708__$1;
(statearr_33730_33763[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (19))){
var state_33708__$1 = state_33708;
var statearr_33731_33764 = state_33708__$1;
(statearr_33731_33764[(2)] = null);

(statearr_33731_33764[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (11))){
var inst_33687 = (state_33708[(2)]);
var inst_33688 = fluree.db.dbproto._first_flake(node);
var inst_33689 = fluree.db.dbproto._rhs(node);
var inst_33690 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_33708__$1 = (function (){var statearr_33733 = state_33708;
(statearr_33733[(10)] = inst_33687);

(statearr_33733[(11)] = inst_33688);

(statearr_33733[(12)] = inst_33689);

return statearr_33733;
})();
if(cljs.core.truth_(inst_33690)){
var statearr_33734_33765 = state_33708__$1;
(statearr_33734_33765[(1)] = (19));

} else {
var statearr_33735_33766 = state_33708__$1;
(statearr_33735_33766[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (9))){
var inst_33668 = fluree.db.dbproto._resolve_history(node);
var state_33708__$1 = state_33708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33708__$1,(12),inst_33668);
} else {
if((state_val_33709 === (5))){
var _ = (function (){var statearr_33736 = state_33708;
(statearr_33736[(4)] = cljs.core.rest((state_33708[(4)])));

return statearr_33736;
})();
var state_33708__$1 = state_33708;
var ex33732 = (state_33708__$1[(2)]);
var statearr_33737_33767 = state_33708__$1;
(statearr_33737_33767[(5)] = ex33732);


var statearr_33738_33768 = state_33708__$1;
(statearr_33738_33768[(1)] = (4));

(statearr_33738_33768[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (14))){
var inst_33671 = (state_33708[(14)]);
var state_33708__$1 = state_33708;
var statearr_33739_33769 = state_33708__$1;
(statearr_33739_33769[(2)] = inst_33671);

(statearr_33739_33769[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (16))){
var inst_33659 = (state_33708[(7)]);
var inst_33678 = (state_33708[(9)]);
var inst_33680 = (function (){var node_t = inst_33659;
var G__33667 = inst_33678;
return (function (p1__33650_SHARP_){
return (p1__33650_SHARP_.t <= from_t);
});
})();
var inst_33681 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_33680,inst_33678);
var state_33708__$1 = state_33708;
var statearr_33740_33770 = state_33708__$1;
(statearr_33740_33770[(2)] = inst_33681);

(statearr_33740_33770[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (10))){
var state_33708__$1 = state_33708;
var statearr_33741_33771 = state_33708__$1;
(statearr_33741_33771[(2)] = null);

(statearr_33741_33771[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (18))){
var inst_33684 = (state_33708[(2)]);
var state_33708__$1 = state_33708;
var statearr_33742_33772 = state_33708__$1;
(statearr_33742_33772[(2)] = inst_33684);

(statearr_33742_33772[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33709 === (8))){
var inst_33665 = (state_33708[(2)]);
var state_33708__$1 = state_33708;
if(cljs.core.truth_(inst_33665)){
var statearr_33743_33773 = state_33708__$1;
(statearr_33743_33773[(1)] = (9));

} else {
var statearr_33744_33774 = state_33708__$1;
(statearr_33744_33774[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__16153__auto____0 = (function (){
var statearr_33745 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33745[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__16153__auto__);

(statearr_33745[(1)] = (1));

return statearr_33745;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__16153__auto____1 = (function (state_33708){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33708);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33746){var ex__16156__auto__ = e33746;
var statearr_33747_33775 = state_33708;
(statearr_33747_33775[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33708[(4)]))){
var statearr_33748_33776 = state_33708;
(statearr_33748_33776[(1)] = cljs.core.first((state_33708[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33777 = state_33708;
state_33708 = G__33777;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__16153__auto__ = function(state_33708){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__16153__auto____1.call(this,state_33708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__16153__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__16153__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33749 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33749[(6)] = c__16227__auto__);

return statearr_33749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4223__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__33778_33788 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33779_33789 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33778_33788,G__33779_33789) : object_cache.call(null,G__33778_33788,G__33779_33789));

var G__33780 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33781 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__33782 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33783 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33782,G__33783) : object_cache.call(null,G__33782,G__33783));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33780,G__33781) : object_cache.call(null,G__33780,G__33781));
} else {
var G__33784 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33785 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__33786 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33787 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33786,G__33787) : object_cache.call(null,G__33786,G__33787));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33784,G__33785) : object_cache.call(null,G__33784,G__33785));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33810){
var state_val_33811 = (state_33810[(1)]);
if((state_val_33811 === (7))){
var state_33810__$1 = state_33810;
var statearr_33812_33832 = state_33810__$1;
(statearr_33812_33832[(2)] = null);

(statearr_33812_33832[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33811 === (1))){
var state_33810__$1 = state_33810;
var statearr_33813_33833 = state_33810__$1;
(statearr_33813_33833[(2)] = null);

(statearr_33813_33833[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33811 === (4))){
var inst_33790 = (state_33810[(2)]);
var state_33810__$1 = state_33810;
var statearr_33814_33834 = state_33810__$1;
(statearr_33814_33834[(2)] = inst_33790);

(statearr_33814_33834[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33811 === (6))){
var inst_33796 = (state_33810[(7)]);
var inst_33798 = fluree.db.storage.core.serde(conn);
var state_33810__$1 = (function (){var statearr_33815 = state_33810;
(statearr_33815[(8)] = inst_33798);

return statearr_33815;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33810__$1,(9),inst_33796);
} else {
if((state_val_33811 === (3))){
var inst_33808 = (state_33810[(2)]);
var state_33810__$1 = state_33810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33810__$1,inst_33808);
} else {
if((state_val_33811 === (2))){
var inst_33796 = (state_33810[(7)]);
var _ = (function (){var statearr_33817 = state_33810;
(statearr_33817[(4)] = cljs.core.cons((5),(state_33810[(4)])));

return statearr_33817;
})();
var inst_33796__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_33810__$1 = (function (){var statearr_33818 = state_33810;
(statearr_33818[(7)] = inst_33796__$1);

return statearr_33818;
})();
if(cljs.core.truth_(inst_33796__$1)){
var statearr_33819_33835 = state_33810__$1;
(statearr_33819_33835[(1)] = (6));

} else {
var statearr_33820_33836 = state_33810__$1;
(statearr_33820_33836[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33811 === (9))){
var inst_33798 = (state_33810[(8)]);
var inst_33800 = (state_33810[(2)]);
var inst_33801 = fluree.db.util.async.throw_err(inst_33800);
var inst_33802 = fluree.db.serde.protocol._deserialize_branch(inst_33798,inst_33801);
var state_33810__$1 = state_33810;
var statearr_33821_33837 = state_33810__$1;
(statearr_33821_33837[(2)] = inst_33802);

(statearr_33821_33837[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33811 === (5))){
var _ = (function (){var statearr_33822 = state_33810;
(statearr_33822[(4)] = cljs.core.rest((state_33810[(4)])));

return statearr_33822;
})();
var state_33810__$1 = state_33810;
var ex33816 = (state_33810__$1[(2)]);
var statearr_33823_33838 = state_33810__$1;
(statearr_33823_33838[(5)] = ex33816);


if((ex33816 instanceof Error)){
var statearr_33824_33839 = state_33810__$1;
(statearr_33824_33839[(1)] = (4));

(statearr_33824_33839[(5)] = null);

} else {
throw ex33816;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33811 === (8))){
var inst_33805 = (state_33810[(2)]);
var _ = (function (){var statearr_33825 = state_33810;
(statearr_33825[(4)] = cljs.core.rest((state_33810[(4)])));

return statearr_33825;
})();
var state_33810__$1 = state_33810;
var statearr_33826_33840 = state_33810__$1;
(statearr_33826_33840[(2)] = inst_33805);

(statearr_33826_33840[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__16153__auto____0 = (function (){
var statearr_33827 = [null,null,null,null,null,null,null,null,null];
(statearr_33827[(0)] = fluree$db$storage$core$read_branch_$_state_machine__16153__auto__);

(statearr_33827[(1)] = (1));

return statearr_33827;
});
var fluree$db$storage$core$read_branch_$_state_machine__16153__auto____1 = (function (state_33810){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33810);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33828){var ex__16156__auto__ = e33828;
var statearr_33829_33841 = state_33810;
(statearr_33829_33841[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33810[(4)]))){
var statearr_33830_33842 = state_33810;
(statearr_33830_33842[(1)] = cljs.core.first((state_33810[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33843 = state_33810;
state_33810 = G__33843;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__16153__auto__ = function(state_33810){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__16153__auto____1.call(this,state_33810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__16153__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__16153__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33831 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33831[(6)] = c__16227__auto__);

return statearr_33831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16227__auto___33922 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33894){
var state_val_33895 = (state_33894[(1)]);
if((state_val_33895 === (7))){
var inst_33861 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_33862 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33863 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_33864 = cljs.core.PersistentHashMap.fromArrays(inst_33862,inst_33863);
var inst_33865 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33861,inst_33864);
var inst_33866 = (function(){throw inst_33865})();
var state_33894__$1 = state_33894;
var statearr_33896_33923 = state_33894__$1;
(statearr_33896_33923[(2)] = inst_33866);

(statearr_33896_33923[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33895 === (1))){
var state_33894__$1 = state_33894;
var statearr_33897_33924 = state_33894__$1;
(statearr_33897_33924[(2)] = null);

(statearr_33897_33924[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33895 === (4))){
var inst_33844 = (state_33894[(2)]);
var inst_33845 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_33846 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33844);
var inst_33847 = cljs.core.async.close_BANG_(return_ch);
var state_33894__$1 = (function (){var statearr_33898 = state_33894;
(statearr_33898[(7)] = inst_33846);

(statearr_33898[(8)] = inst_33845);

return statearr_33898;
})();
var statearr_33899_33925 = state_33894__$1;
(statearr_33899_33925[(2)] = inst_33847);

(statearr_33899_33925[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33895 === (6))){
var inst_33858 = (state_33894[(9)]);
var inst_33857 = (state_33894[(2)]);
var inst_33858__$1 = fluree.db.util.async.throw_err(inst_33857);
var inst_33859 = (inst_33858__$1 == null);
var state_33894__$1 = (function (){var statearr_33900 = state_33894;
(statearr_33900[(9)] = inst_33858__$1);

return statearr_33900;
})();
if(cljs.core.truth_(inst_33859)){
var statearr_33901_33926 = state_33894__$1;
(statearr_33901_33926[(1)] = (7));

} else {
var statearr_33902_33927 = state_33894__$1;
(statearr_33902_33927[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33895 === (3))){
var inst_33892 = (state_33894[(2)]);
var state_33894__$1 = state_33894;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33894__$1,inst_33892);
} else {
if((state_val_33895 === (12))){
var inst_33858 = (state_33894[(9)]);
var inst_33875 = (state_33894[(2)]);
var inst_33876 = cljs.core.__destructure_map(inst_33858);
var inst_33877 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33876,cljs.core.cst$kw$children);
var inst_33878 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33876,cljs.core.cst$kw$rhs);
var inst_33879 = config;
var inst_33880 = cljs.core.__destructure_map(inst_33879);
var inst_33881 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33880,cljs.core.cst$kw$comparator);
var inst_33883 = (function (){var data = inst_33858;
var _ = inst_33875;
var map__33853 = inst_33876;
var children = inst_33877;
var rhs = inst_33878;
var map__33854 = inst_33880;
var comparator = inst_33881;
return (function (idx,p__33882){
var map__33903 = p__33882;
var map__33903__$1 = cljs.core.__destructure_map(map__33903);
var child = map__33903__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33903__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33903__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33903__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33903__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33903__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__4221__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return (idx === (0));
} else {
return and__4221__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_33884 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_33883,inst_33877);
var inst_33885 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_33884);
var inst_33886 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_33885,inst_33884);
var inst_33887 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_33881,inst_33886);
var inst_33888 = fluree.db.index.__GT_IndexNode(block,t,inst_33878,inst_33887,config,leftmost_QMARK_);
var inst_33889 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33888);
var _ = (function (){var statearr_33904 = state_33894;
(statearr_33904[(4)] = cljs.core.rest((state_33894[(4)])));

return statearr_33904;
})();
var state_33894__$1 = state_33894;
var statearr_33905_33928 = state_33894__$1;
(statearr_33905_33928[(2)] = inst_33889);

(statearr_33905_33928[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33895 === (2))){
var _ = (function (){var statearr_33906 = state_33894;
(statearr_33906[(4)] = cljs.core.cons((5),(state_33894[(4)])));

return statearr_33906;
})();
var inst_33855 = fluree.db.storage.core.read_branch(conn,key);
var state_33894__$1 = state_33894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33894__$1,(6),inst_33855);
} else {
if((state_val_33895 === (11))){
var state_33894__$1 = state_33894;
var statearr_33908_33929 = state_33894__$1;
(statearr_33908_33929[(2)] = null);

(statearr_33908_33929[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33895 === (9))){
var inst_33858 = (state_33894[(9)]);
var inst_33869 = (state_33894[(2)]);
var inst_33870 = fluree.db.util.core.exception_QMARK_(inst_33858);
var state_33894__$1 = (function (){var statearr_33909 = state_33894;
(statearr_33909[(10)] = inst_33869);

return statearr_33909;
})();
if(inst_33870){
var statearr_33910_33930 = state_33894__$1;
(statearr_33910_33930[(1)] = (10));

} else {
var statearr_33911_33931 = state_33894__$1;
(statearr_33911_33931[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33895 === (5))){
var _ = (function (){var statearr_33912 = state_33894;
(statearr_33912[(4)] = cljs.core.rest((state_33894[(4)])));

return statearr_33912;
})();
var state_33894__$1 = state_33894;
var ex33907 = (state_33894__$1[(2)]);
var statearr_33913_33932 = state_33894__$1;
(statearr_33913_33932[(5)] = ex33907);


var statearr_33914_33933 = state_33894__$1;
(statearr_33914_33933[(1)] = (4));

(statearr_33914_33933[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33895 === (10))){
var inst_33858 = (state_33894[(9)]);
var inst_33872 = (function(){throw inst_33858})();
var state_33894__$1 = state_33894;
var statearr_33915_33934 = state_33894__$1;
(statearr_33915_33934[(2)] = inst_33872);

(statearr_33915_33934[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33895 === (8))){
var state_33894__$1 = state_33894;
var statearr_33916_33935 = state_33894__$1;
(statearr_33916_33935[(2)] = null);

(statearr_33916_33935[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__16153__auto____0 = (function (){
var statearr_33917 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33917[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__16153__auto__);

(statearr_33917[(1)] = (1));

return statearr_33917;
});
var fluree$db$storage$core$reify_branch_$_state_machine__16153__auto____1 = (function (state_33894){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33894);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33918){var ex__16156__auto__ = e33918;
var statearr_33919_33936 = state_33894;
(statearr_33919_33936[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33894[(4)]))){
var statearr_33920_33937 = state_33894;
(statearr_33920_33937[(1)] = cljs.core.first((state_33894[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33938 = state_33894;
state_33894 = G__33938;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__16153__auto__ = function(state_33894){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__16153__auto____1.call(this,state_33894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__16153__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__16153__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33921 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33921[(6)] = c__16227__auto___33922);

return statearr_33921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_33959){
var state_val_33960 = (state_33959[(1)]);
if((state_val_33960 === (7))){
var state_33959__$1 = state_33959;
var statearr_33961_33981 = state_33959__$1;
(statearr_33961_33981[(2)] = null);

(statearr_33961_33981[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33960 === (1))){
var state_33959__$1 = state_33959;
var statearr_33962_33982 = state_33959__$1;
(statearr_33962_33982[(2)] = null);

(statearr_33962_33982[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33960 === (4))){
var inst_33939 = (state_33959[(2)]);
var state_33959__$1 = state_33959;
var statearr_33963_33983 = state_33959__$1;
(statearr_33963_33983[(2)] = inst_33939);

(statearr_33963_33983[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33960 === (6))){
var inst_33945 = (state_33959[(7)]);
var inst_33947 = fluree.db.storage.core.serde(conn);
var state_33959__$1 = (function (){var statearr_33964 = state_33959;
(statearr_33964[(8)] = inst_33947);

return statearr_33964;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33959__$1,(9),inst_33945);
} else {
if((state_val_33960 === (3))){
var inst_33957 = (state_33959[(2)]);
var state_33959__$1 = state_33959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33959__$1,inst_33957);
} else {
if((state_val_33960 === (2))){
var inst_33945 = (state_33959[(7)]);
var _ = (function (){var statearr_33966 = state_33959;
(statearr_33966[(4)] = cljs.core.cons((5),(state_33959[(4)])));

return statearr_33966;
})();
var inst_33945__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_33959__$1 = (function (){var statearr_33967 = state_33959;
(statearr_33967[(7)] = inst_33945__$1);

return statearr_33967;
})();
if(cljs.core.truth_(inst_33945__$1)){
var statearr_33968_33984 = state_33959__$1;
(statearr_33968_33984[(1)] = (6));

} else {
var statearr_33969_33985 = state_33959__$1;
(statearr_33969_33985[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33960 === (9))){
var inst_33947 = (state_33959[(8)]);
var inst_33949 = (state_33959[(2)]);
var inst_33950 = fluree.db.util.async.throw_err(inst_33949);
var inst_33951 = fluree.db.serde.protocol._deserialize_leaf(inst_33947,inst_33950);
var state_33959__$1 = state_33959;
var statearr_33970_33986 = state_33959__$1;
(statearr_33970_33986[(2)] = inst_33951);

(statearr_33970_33986[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33960 === (5))){
var _ = (function (){var statearr_33971 = state_33959;
(statearr_33971[(4)] = cljs.core.rest((state_33959[(4)])));

return statearr_33971;
})();
var state_33959__$1 = state_33959;
var ex33965 = (state_33959__$1[(2)]);
var statearr_33972_33987 = state_33959__$1;
(statearr_33972_33987[(5)] = ex33965);


if((ex33965 instanceof Error)){
var statearr_33973_33988 = state_33959__$1;
(statearr_33973_33988[(1)] = (4));

(statearr_33973_33988[(5)] = null);

} else {
throw ex33965;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33960 === (8))){
var inst_33954 = (state_33959[(2)]);
var _ = (function (){var statearr_33974 = state_33959;
(statearr_33974[(4)] = cljs.core.rest((state_33959[(4)])));

return statearr_33974;
})();
var state_33959__$1 = state_33959;
var statearr_33975_33989 = state_33959__$1;
(statearr_33975_33989[(2)] = inst_33954);

(statearr_33975_33989[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__16153__auto____0 = (function (){
var statearr_33976 = [null,null,null,null,null,null,null,null,null];
(statearr_33976[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__16153__auto__);

(statearr_33976[(1)] = (1));

return statearr_33976;
});
var fluree$db$storage$core$read_leaf_$_state_machine__16153__auto____1 = (function (state_33959){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_33959);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e33977){var ex__16156__auto__ = e33977;
var statearr_33978_33990 = state_33959;
(statearr_33978_33990[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_33959[(4)]))){
var statearr_33979_33991 = state_33959;
(statearr_33979_33991[(1)] = cljs.core.first((state_33959[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__33992 = state_33959;
state_33959 = G__33992;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__16153__auto__ = function(state_33959){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__16153__auto____1.call(this,state_33959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__16153__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__16153__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_33980 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_33980[(6)] = c__16227__auto__);

return statearr_33980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16227__auto___34065 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_34037){
var state_val_34038 = (state_34037[(1)]);
if((state_val_34038 === (7))){
var inst_34009 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_34010 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34011 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_34012 = cljs.core.PersistentHashMap.fromArrays(inst_34010,inst_34011);
var inst_34013 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34009,inst_34012);
var inst_34014 = (function(){throw inst_34013})();
var state_34037__$1 = state_34037;
var statearr_34039_34066 = state_34037__$1;
(statearr_34039_34066[(2)] = inst_34014);

(statearr_34039_34066[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34038 === (1))){
var state_34037__$1 = state_34037;
var statearr_34040_34067 = state_34037__$1;
(statearr_34040_34067[(2)] = null);

(statearr_34040_34067[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34038 === (4))){
var inst_33993 = (state_34037[(2)]);
var inst_33994 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_33995 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33993);
var inst_33996 = cljs.core.async.close_BANG_(return_ch);
var state_34037__$1 = (function (){var statearr_34041 = state_34037;
(statearr_34041[(7)] = inst_33995);

(statearr_34041[(8)] = inst_33994);

return statearr_34041;
})();
var statearr_34042_34068 = state_34037__$1;
(statearr_34042_34068[(2)] = inst_33996);

(statearr_34042_34068[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34038 === (6))){
var inst_34006 = (state_34037[(9)]);
var inst_34006__$1 = (state_34037[(2)]);
var inst_34007 = (inst_34006__$1 == null);
var state_34037__$1 = (function (){var statearr_34043 = state_34037;
(statearr_34043[(9)] = inst_34006__$1);

return statearr_34043;
})();
if(cljs.core.truth_(inst_34007)){
var statearr_34044_34069 = state_34037__$1;
(statearr_34044_34069[(1)] = (7));

} else {
var statearr_34045_34070 = state_34037__$1;
(statearr_34045_34070[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34038 === (3))){
var inst_34035 = (state_34037[(2)]);
var state_34037__$1 = state_34037;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34037__$1,inst_34035);
} else {
if((state_val_34038 === (12))){
var inst_34006 = (state_34037[(9)]);
var inst_34023 = (state_34037[(2)]);
var inst_34024 = cljs.core.__destructure_map(inst_34006);
var inst_34025 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34024,cljs.core.cst$kw$flakes);
var inst_34026 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34024,cljs.core.cst$kw$his);
var inst_34027 = config;
var inst_34028 = cljs.core.__destructure_map(inst_34027);
var inst_34029 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34028,cljs.core.cst$kw$comparator);
var inst_34030 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_34029,inst_34025);
var inst_34031 = fluree.db.index.data_node(block,t,inst_34030,rhs,config);
var inst_34032 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_34031);
var _ = (function (){var statearr_34046 = state_34037;
(statearr_34046[(4)] = cljs.core.rest((state_34037[(4)])));

return statearr_34046;
})();
var state_34037__$1 = (function (){var statearr_34047 = state_34037;
(statearr_34047[(10)] = inst_34023);

(statearr_34047[(11)] = inst_34026);

return statearr_34047;
})();
var statearr_34048_34071 = state_34037__$1;
(statearr_34048_34071[(2)] = inst_34032);

(statearr_34048_34071[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34038 === (2))){
var _ = (function (){var statearr_34049 = state_34037;
(statearr_34049[(4)] = cljs.core.cons((5),(state_34037[(4)])));

return statearr_34049;
})();
var inst_34004 = fluree.db.storage.core.read_leaf(conn,key);
var state_34037__$1 = state_34037;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34037__$1,(6),inst_34004);
} else {
if((state_val_34038 === (11))){
var state_34037__$1 = state_34037;
var statearr_34051_34072 = state_34037__$1;
(statearr_34051_34072[(2)] = null);

(statearr_34051_34072[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34038 === (9))){
var inst_34006 = (state_34037[(9)]);
var inst_34017 = (state_34037[(2)]);
var inst_34018 = fluree.db.util.core.exception_QMARK_(inst_34006);
var state_34037__$1 = (function (){var statearr_34052 = state_34037;
(statearr_34052[(12)] = inst_34017);

return statearr_34052;
})();
if(inst_34018){
var statearr_34053_34073 = state_34037__$1;
(statearr_34053_34073[(1)] = (10));

} else {
var statearr_34054_34074 = state_34037__$1;
(statearr_34054_34074[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34038 === (5))){
var _ = (function (){var statearr_34055 = state_34037;
(statearr_34055[(4)] = cljs.core.rest((state_34037[(4)])));

return statearr_34055;
})();
var state_34037__$1 = state_34037;
var ex34050 = (state_34037__$1[(2)]);
var statearr_34056_34075 = state_34037__$1;
(statearr_34056_34075[(5)] = ex34050);


var statearr_34057_34076 = state_34037__$1;
(statearr_34057_34076[(1)] = (4));

(statearr_34057_34076[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_34038 === (10))){
var inst_34006 = (state_34037[(9)]);
var inst_34020 = (function(){throw inst_34006})();
var state_34037__$1 = state_34037;
var statearr_34058_34077 = state_34037__$1;
(statearr_34058_34077[(2)] = inst_34020);

(statearr_34058_34077[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34038 === (8))){
var state_34037__$1 = state_34037;
var statearr_34059_34078 = state_34037__$1;
(statearr_34059_34078[(2)] = null);

(statearr_34059_34078[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__16153__auto____0 = (function (){
var statearr_34060 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34060[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__16153__auto__);

(statearr_34060[(1)] = (1));

return statearr_34060;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__16153__auto____1 = (function (state_34037){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_34037);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e34061){var ex__16156__auto__ = e34061;
var statearr_34062_34079 = state_34037;
(statearr_34062_34079[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_34037[(4)]))){
var statearr_34063_34080 = state_34037;
(statearr_34063_34080[(1)] = cljs.core.first((state_34037[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__34081 = state_34037;
state_34037 = G__34081;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__16153__auto__ = function(state_34037){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__16153__auto____1.call(this,state_34037);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__16153__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__16153__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_34064 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_34064[(6)] = c__16227__auto___34065);

return statearr_34064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k34083,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__34087 = k34083;
var G__34087__$1 = (((G__34087 instanceof cljs.core.Keyword))?G__34087.fqn:null);
switch (G__34087__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34083,else__4475__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__34088){
var vec__34089 = p__34088;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34089,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34089,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34082){
var self__ = this;
var G__34082__$1 = this;
return (new cljs.core.RecordIter((0),G__34082__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__34092 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__34093 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__34094 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__34095 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__34094,G__34095) : object_cache.call(null,G__34094,G__34095));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__34096 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__34097 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__34096,G__34097) : object_cache.call(null,G__34096,G__34097));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__34092,G__34093) : object_cache.call(null,G__34092,G__34093));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__34098 = history_id;
var G__34099 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__34098,G__34099) : object_cache.call(null,G__34098,G__34099));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__34100 = (function (coll__4469__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__34100(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34084,other34085){
var self__ = this;
var this34084__$1 = this;
return (((!((other34085 == null)))) && ((((this34084__$1.constructor === other34085.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.conn,other34085.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.config,other34085.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.network,other34085.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.dbid,other34085.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.id,other34085.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.leaf,other34085.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.first,other34085.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.rhs,other34085.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.size,other34085.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.block,other34085.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.t,other34085.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.tt_id,other34085.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.leftmost_QMARK_,other34085.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.tempid,other34085.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34084__$1.__extmap,other34085.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k34083){
var self__ = this;
var this__4479__auto____$1 = this;
var G__34101 = k34083;
var G__34101__$1 = (((G__34101 instanceof cljs.core.Keyword))?G__34101.fqn:null);
switch (G__34101__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34083);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__34082){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__34102 = cljs.core.keyword_identical_QMARK_;
var expr__34103 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__34105 = cljs.core.cst$kw$conn;
var G__34106 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34105,G__34106) : pred__34102.call(null,G__34105,G__34106));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__34082,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34107 = cljs.core.cst$kw$config;
var G__34108 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34107,G__34108) : pred__34102.call(null,G__34107,G__34108));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__34082,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34109 = cljs.core.cst$kw$network;
var G__34110 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34109,G__34110) : pred__34102.call(null,G__34109,G__34110));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__34082,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34111 = cljs.core.cst$kw$dbid;
var G__34112 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34111,G__34112) : pred__34102.call(null,G__34111,G__34112));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__34082,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34113 = cljs.core.cst$kw$id;
var G__34114 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34113,G__34114) : pred__34102.call(null,G__34113,G__34114));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__34082,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34115 = cljs.core.cst$kw$leaf;
var G__34116 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34115,G__34116) : pred__34102.call(null,G__34115,G__34116));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__34082,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34117 = cljs.core.cst$kw$first;
var G__34118 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34117,G__34118) : pred__34102.call(null,G__34117,G__34118));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__34082,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34119 = cljs.core.cst$kw$rhs;
var G__34120 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34119,G__34120) : pred__34102.call(null,G__34119,G__34120));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__34082,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34121 = cljs.core.cst$kw$size;
var G__34122 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34121,G__34122) : pred__34102.call(null,G__34121,G__34122));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__34082,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34123 = cljs.core.cst$kw$block;
var G__34124 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34123,G__34124) : pred__34102.call(null,G__34123,G__34124));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__34082,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34125 = cljs.core.cst$kw$t;
var G__34126 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34125,G__34126) : pred__34102.call(null,G__34125,G__34126));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__34082,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34127 = cljs.core.cst$kw$tt_DASH_id;
var G__34128 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34127,G__34128) : pred__34102.call(null,G__34127,G__34128));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__34082,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34129 = cljs.core.cst$kw$leftmost_QMARK_;
var G__34130 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34129,G__34130) : pred__34102.call(null,G__34129,G__34130));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__34082,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34131 = cljs.core.cst$kw$tempid;
var G__34132 = expr__34103;
return (pred__34102.cljs$core$IFn$_invoke$arity$2 ? pred__34102.cljs$core$IFn$_invoke$arity$2(G__34131,G__34132) : pred__34102.call(null,G__34131,G__34132));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__34082,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__34082),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__34082){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__34082,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__34086){
var extmap__4512__auto__ = (function (){var G__34133 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34086,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__34086)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34133);
} else {
return G__34133;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__34086),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__34086),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__34086),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__34086),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__34086),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__34086),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__34086),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__34086),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__34086),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__34086),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__34086),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__34086),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__34086),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__34086),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__34136 = blank_db;
var map__34136__$1 = cljs.core.__destructure_map(map__34136);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34136__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34136__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34136__$1,cljs.core.cst$kw$index_DASH_configs);
var map__34137 = root_data;
var map__34137__$1 = cljs.core.__destructure_map(map__34137);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34137__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34137__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34137__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34137__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_34159){
var state_val_34160 = (state_34159[(1)]);
if((state_val_34160 === (7))){
var state_34159__$1 = state_34159;
var statearr_34161_34181 = state_34159__$1;
(statearr_34161_34181[(2)] = null);

(statearr_34161_34181[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34160 === (1))){
var state_34159__$1 = state_34159;
var statearr_34162_34182 = state_34159__$1;
(statearr_34162_34182[(2)] = null);

(statearr_34162_34182[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34160 === (4))){
var inst_34138 = (state_34159[(2)]);
var state_34159__$1 = state_34159;
var statearr_34163_34183 = state_34159__$1;
(statearr_34163_34183[(2)] = inst_34138);

(statearr_34163_34183[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34160 === (6))){
var inst_34145 = (state_34159[(7)]);
var inst_34147 = fluree.db.storage.core.serde(conn);
var state_34159__$1 = (function (){var statearr_34164 = state_34159;
(statearr_34164[(8)] = inst_34147);

return statearr_34164;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34159__$1,(9),inst_34145);
} else {
if((state_val_34160 === (3))){
var inst_34157 = (state_34159[(2)]);
var state_34159__$1 = state_34159;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34159__$1,inst_34157);
} else {
if((state_val_34160 === (2))){
var inst_34145 = (state_34159[(7)]);
var _ = (function (){var statearr_34166 = state_34159;
(statearr_34166[(4)] = cljs.core.cons((5),(state_34159[(4)])));

return statearr_34166;
})();
var inst_34144 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_34145__$1 = fluree.db.storage.core.storage_read(conn,inst_34144);
var state_34159__$1 = (function (){var statearr_34167 = state_34159;
(statearr_34167[(7)] = inst_34145__$1);

return statearr_34167;
})();
if(cljs.core.truth_(inst_34145__$1)){
var statearr_34168_34184 = state_34159__$1;
(statearr_34168_34184[(1)] = (6));

} else {
var statearr_34169_34185 = state_34159__$1;
(statearr_34169_34185[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34160 === (9))){
var inst_34147 = (state_34159[(8)]);
var inst_34149 = (state_34159[(2)]);
var inst_34150 = fluree.db.util.async.throw_err(inst_34149);
var inst_34151 = fluree.db.serde.protocol._deserialize_garbage(inst_34147,inst_34150);
var state_34159__$1 = state_34159;
var statearr_34170_34186 = state_34159__$1;
(statearr_34170_34186[(2)] = inst_34151);

(statearr_34170_34186[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34160 === (5))){
var _ = (function (){var statearr_34171 = state_34159;
(statearr_34171[(4)] = cljs.core.rest((state_34159[(4)])));

return statearr_34171;
})();
var state_34159__$1 = state_34159;
var ex34165 = (state_34159__$1[(2)]);
var statearr_34172_34187 = state_34159__$1;
(statearr_34172_34187[(5)] = ex34165);


if((ex34165 instanceof Error)){
var statearr_34173_34188 = state_34159__$1;
(statearr_34173_34188[(1)] = (4));

(statearr_34173_34188[(5)] = null);

} else {
throw ex34165;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34160 === (8))){
var inst_34154 = (state_34159[(2)]);
var _ = (function (){var statearr_34174 = state_34159;
(statearr_34174[(4)] = cljs.core.rest((state_34159[(4)])));

return statearr_34174;
})();
var state_34159__$1 = state_34159;
var statearr_34175_34189 = state_34159__$1;
(statearr_34175_34189[(2)] = inst_34154);

(statearr_34175_34189[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__16153__auto____0 = (function (){
var statearr_34176 = [null,null,null,null,null,null,null,null,null];
(statearr_34176[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__16153__auto__);

(statearr_34176[(1)] = (1));

return statearr_34176;
});
var fluree$db$storage$core$read_garbage_$_state_machine__16153__auto____1 = (function (state_34159){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_34159);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e34177){var ex__16156__auto__ = e34177;
var statearr_34178_34190 = state_34159;
(statearr_34178_34190[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_34159[(4)]))){
var statearr_34179_34191 = state_34159;
(statearr_34179_34191[(1)] = cljs.core.first((state_34159[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__34192 = state_34159;
state_34159 = G__34192;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__16153__auto__ = function(state_34159){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__16153__auto____1.call(this,state_34159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__16153__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__16153__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_34180 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_34180[(6)] = c__16227__auto__);

return statearr_34180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_34214){
var state_val_34215 = (state_34214[(1)]);
if((state_val_34215 === (7))){
var state_34214__$1 = state_34214;
var statearr_34216_34236 = state_34214__$1;
(statearr_34216_34236[(2)] = null);

(statearr_34216_34236[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34215 === (1))){
var state_34214__$1 = state_34214;
var statearr_34217_34237 = state_34214__$1;
(statearr_34217_34237[(2)] = null);

(statearr_34217_34237[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34215 === (4))){
var inst_34193 = (state_34214[(2)]);
var state_34214__$1 = state_34214;
var statearr_34218_34238 = state_34214__$1;
(statearr_34218_34238[(2)] = inst_34193);

(statearr_34218_34238[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34215 === (6))){
var inst_34200 = (state_34214[(7)]);
var inst_34202 = fluree.db.storage.core.serde(conn);
var state_34214__$1 = (function (){var statearr_34219 = state_34214;
(statearr_34219[(8)] = inst_34202);

return statearr_34219;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34214__$1,(9),inst_34200);
} else {
if((state_val_34215 === (3))){
var inst_34212 = (state_34214[(2)]);
var state_34214__$1 = state_34214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34214__$1,inst_34212);
} else {
if((state_val_34215 === (2))){
var inst_34200 = (state_34214[(7)]);
var _ = (function (){var statearr_34221 = state_34214;
(statearr_34221[(4)] = cljs.core.cons((5),(state_34214[(4)])));

return statearr_34221;
})();
var inst_34199 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_34200__$1 = fluree.db.storage.core.storage_read(conn,inst_34199);
var state_34214__$1 = (function (){var statearr_34222 = state_34214;
(statearr_34222[(7)] = inst_34200__$1);

return statearr_34222;
})();
if(cljs.core.truth_(inst_34200__$1)){
var statearr_34223_34239 = state_34214__$1;
(statearr_34223_34239[(1)] = (6));

} else {
var statearr_34224_34240 = state_34214__$1;
(statearr_34224_34240[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34215 === (9))){
var inst_34202 = (state_34214[(8)]);
var inst_34204 = (state_34214[(2)]);
var inst_34205 = fluree.db.util.async.throw_err(inst_34204);
var inst_34206 = fluree.db.serde.protocol._deserialize_db_root(inst_34202,inst_34205);
var state_34214__$1 = state_34214;
var statearr_34225_34241 = state_34214__$1;
(statearr_34225_34241[(2)] = inst_34206);

(statearr_34225_34241[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34215 === (5))){
var _ = (function (){var statearr_34226 = state_34214;
(statearr_34226[(4)] = cljs.core.rest((state_34214[(4)])));

return statearr_34226;
})();
var state_34214__$1 = state_34214;
var ex34220 = (state_34214__$1[(2)]);
var statearr_34227_34242 = state_34214__$1;
(statearr_34227_34242[(5)] = ex34220);


if((ex34220 instanceof Error)){
var statearr_34228_34243 = state_34214__$1;
(statearr_34228_34243[(1)] = (4));

(statearr_34228_34243[(5)] = null);

} else {
throw ex34220;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34215 === (8))){
var inst_34209 = (state_34214[(2)]);
var _ = (function (){var statearr_34229 = state_34214;
(statearr_34229[(4)] = cljs.core.rest((state_34214[(4)])));

return statearr_34229;
})();
var state_34214__$1 = state_34214;
var statearr_34230_34244 = state_34214__$1;
(statearr_34230_34244[(2)] = inst_34209);

(statearr_34230_34244[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__16153__auto____0 = (function (){
var statearr_34231 = [null,null,null,null,null,null,null,null,null];
(statearr_34231[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__16153__auto__);

(statearr_34231[(1)] = (1));

return statearr_34231;
});
var fluree$db$storage$core$read_db_root_$_state_machine__16153__auto____1 = (function (state_34214){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_34214);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e34232){var ex__16156__auto__ = e34232;
var statearr_34233_34245 = state_34214;
(statearr_34233_34245[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_34214[(4)]))){
var statearr_34234_34246 = state_34214;
(statearr_34234_34246[(1)] = cljs.core.first((state_34214[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__34247 = state_34214;
state_34214 = G__34247;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__16153__auto__ = function(state_34214){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__16153__auto____1.call(this,state_34214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__16153__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__16153__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_34235 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_34235[(6)] = c__16227__auto__);

return statearr_34235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_34283){
var state_val_34284 = (state_34283[(1)]);
if((state_val_34284 === (7))){
var inst_34257 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_34258 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34259 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_34260 = cljs.core.PersistentHashMap.fromArrays(inst_34258,inst_34259);
var inst_34261 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34257,inst_34260);
var inst_34262 = (function(){throw inst_34261})();
var state_34283__$1 = state_34283;
var statearr_34285_34307 = state_34283__$1;
(statearr_34285_34307[(2)] = inst_34262);

(statearr_34285_34307[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34284 === (1))){
var state_34283__$1 = state_34283;
var statearr_34286_34308 = state_34283__$1;
(statearr_34286_34308[(2)] = null);

(statearr_34286_34308[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34284 === (4))){
var inst_34248 = (state_34283[(2)]);
var state_34283__$1 = state_34283;
var statearr_34287_34309 = state_34283__$1;
(statearr_34287_34309[(2)] = inst_34248);

(statearr_34287_34309[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34284 === (6))){
var state_34283__$1 = state_34283;
var statearr_34288_34310 = state_34283__$1;
(statearr_34288_34310[(2)] = null);

(statearr_34288_34310[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34284 === (3))){
var inst_34281 = (state_34283[(2)]);
var state_34283__$1 = state_34283;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34283__$1,inst_34281);
} else {
if((state_val_34284 === (2))){
var inst_34254 = (state_34283[(7)]);
var _ = (function (){var statearr_34289 = state_34283;
(statearr_34289[(4)] = cljs.core.cons((5),(state_34283[(4)])));

return statearr_34289;
})();
var inst_34254__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_34283__$1 = (function (){var statearr_34290 = state_34283;
(statearr_34290[(7)] = inst_34254__$1);

return statearr_34290;
})();
if(cljs.core.truth_(inst_34254__$1)){
var statearr_34291_34311 = state_34283__$1;
(statearr_34291_34311[(1)] = (6));

} else {
var statearr_34292_34312 = state_34283__$1;
(statearr_34292_34312[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34284 === (11))){
var inst_34273 = (state_34283[(8)]);
var inst_34276 = (state_34283[(2)]);
var inst_34277 = fluree.db.util.async.throw_err(inst_34276);
var inst_34278 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34273,cljs.core.cst$kw$settings,inst_34277);
var _ = (function (){var statearr_34294 = state_34283;
(statearr_34294[(4)] = cljs.core.rest((state_34283[(4)])));

return statearr_34294;
})();
var state_34283__$1 = state_34283;
var statearr_34295_34313 = state_34283__$1;
(statearr_34295_34313[(2)] = inst_34278);

(statearr_34295_34313[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34284 === (9))){
var inst_34268 = (state_34283[(9)]);
var inst_34266 = (state_34283[(2)]);
var inst_34267 = fluree.db.util.async.throw_err(inst_34266);
var inst_34268__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_34267);
var inst_34269 = fluree.db.query.schema.schema_map(inst_34268__$1);
var state_34283__$1 = (function (){var statearr_34296 = state_34283;
(statearr_34296[(9)] = inst_34268__$1);

return statearr_34296;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34283__$1,(10),inst_34269);
} else {
if((state_val_34284 === (5))){
var _ = (function (){var statearr_34297 = state_34283;
(statearr_34297[(4)] = cljs.core.rest((state_34283[(4)])));

return statearr_34297;
})();
var state_34283__$1 = state_34283;
var ex34293 = (state_34283__$1[(2)]);
var statearr_34298_34314 = state_34283__$1;
(statearr_34298_34314[(5)] = ex34293);


if((ex34293 instanceof Error)){
var statearr_34299_34315 = state_34283__$1;
(statearr_34299_34315[(1)] = (4));

(statearr_34299_34315[(5)] = null);

} else {
throw ex34293;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34284 === (10))){
var inst_34268 = (state_34283[(9)]);
var inst_34273 = (state_34283[(8)]);
var inst_34271 = (state_34283[(2)]);
var inst_34272 = fluree.db.util.async.throw_err(inst_34271);
var inst_34273__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34268,cljs.core.cst$kw$schema,inst_34272);
var inst_34274 = fluree.db.query.schema.setting_map(inst_34273__$1);
var state_34283__$1 = (function (){var statearr_34300 = state_34283;
(statearr_34300[(8)] = inst_34273__$1);

return statearr_34300;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34283__$1,(11),inst_34274);
} else {
if((state_val_34284 === (8))){
var inst_34254 = (state_34283[(7)]);
var inst_34264 = (state_34283[(2)]);
var state_34283__$1 = (function (){var statearr_34301 = state_34283;
(statearr_34301[(10)] = inst_34264);

return statearr_34301;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34283__$1,(9),inst_34254);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__16153__auto____0 = (function (){
var statearr_34302 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34302[(0)] = fluree$db$storage$core$reify_db_$_state_machine__16153__auto__);

(statearr_34302[(1)] = (1));

return statearr_34302;
});
var fluree$db$storage$core$reify_db_$_state_machine__16153__auto____1 = (function (state_34283){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_34283);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e34303){var ex__16156__auto__ = e34303;
var statearr_34304_34316 = state_34283;
(statearr_34304_34316[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_34283[(4)]))){
var statearr_34305_34317 = state_34283;
(statearr_34305_34317[(1)] = cljs.core.first((state_34283[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__34318 = state_34283;
state_34283 = G__34318;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__16153__auto__ = function(state_34283){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__16153__auto____1.call(this,state_34283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__16153__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__16153__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_34306 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_34306[(6)] = c__16227__auto__);

return statearr_34306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__34320 = arguments.length;
switch (G__34320) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_34373){
var state_val_34374 = (state_34373[(1)]);
if((state_val_34374 === (7))){
var inst_34330 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_34331 = (new Error(inst_34330));
var inst_34332 = (function(){throw inst_34331})();
var state_34373__$1 = state_34373;
var statearr_34375_34415 = state_34373__$1;
(statearr_34375_34415[(2)] = inst_34332);

(statearr_34375_34415[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (20))){
var inst_34364 = (state_34373[(2)]);
var state_34373__$1 = state_34373;
var statearr_34376_34416 = state_34373__$1;
(statearr_34376_34416[(2)] = inst_34364);

(statearr_34376_34416[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (1))){
var state_34373__$1 = state_34373;
var statearr_34377_34417 = state_34373__$1;
(statearr_34377_34417[(2)] = null);

(statearr_34377_34417[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (4))){
var inst_34321 = (state_34373[(2)]);
var state_34373__$1 = state_34373;
var statearr_34378_34418 = state_34373__$1;
(statearr_34378_34418[(2)] = inst_34321);

(statearr_34378_34418[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (15))){
var inst_34339 = (state_34373[(7)]);
var state_34373__$1 = state_34373;
var statearr_34379_34419 = state_34373__$1;
(statearr_34379_34419[(2)] = inst_34339);

(statearr_34379_34419[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (21))){
var inst_34338 = (state_34373[(8)]);
var inst_34339 = (state_34373[(7)]);
var inst_34343 = (state_34373[(9)]);
var inst_34357 = (inst_34338 + (1));
var inst_34358 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34339,inst_34343);
var inst_34338__$1 = inst_34357;
var inst_34339__$1 = inst_34358;
var state_34373__$1 = (function (){var statearr_34380 = state_34373;
(statearr_34380[(8)] = inst_34338__$1);

(statearr_34380[(7)] = inst_34339__$1);

return statearr_34380;
})();
var statearr_34381_34420 = state_34373__$1;
(statearr_34381_34420[(2)] = null);

(statearr_34381_34420[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (13))){
var inst_34343 = (state_34373[(9)]);
var inst_34347 = (inst_34343 instanceof Error);
var state_34373__$1 = state_34373;
var statearr_34382_34421 = state_34373__$1;
(statearr_34382_34421[(2)] = inst_34347);

(statearr_34382_34421[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (22))){
var state_34373__$1 = state_34373;
var statearr_34383_34422 = state_34373__$1;
(statearr_34383_34422[(2)] = null);

(statearr_34383_34422[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (6))){
var state_34373__$1 = state_34373;
var statearr_34384_34423 = state_34373__$1;
(statearr_34384_34423[(2)] = null);

(statearr_34384_34423[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (17))){
var inst_34366 = (state_34373[(2)]);
var state_34373__$1 = state_34373;
var statearr_34385_34424 = state_34373__$1;
(statearr_34385_34424[(2)] = inst_34366);

(statearr_34385_34424[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (3))){
var inst_34371 = (state_34373[(2)]);
var state_34373__$1 = state_34373;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34373__$1,inst_34371);
} else {
if((state_val_34374 === (12))){
var inst_34344 = (state_34373[(10)]);
var state_34373__$1 = state_34373;
var statearr_34386_34425 = state_34373__$1;
(statearr_34386_34425[(2)] = inst_34344);

(statearr_34386_34425[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (2))){
var _ = (function (){var statearr_34387 = state_34373;
(statearr_34387[(4)] = cljs.core.cons((5),(state_34373[(4)])));

return statearr_34387;
})();
var inst_34327 = (end >= start);
var state_34373__$1 = state_34373;
if(cljs.core.truth_(inst_34327)){
var statearr_34388_34426 = state_34373__$1;
(statearr_34388_34426[(1)] = (6));

} else {
var statearr_34389_34427 = state_34373__$1;
(statearr_34389_34427[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (23))){
var inst_34362 = (state_34373[(2)]);
var state_34373__$1 = state_34373;
var statearr_34390_34428 = state_34373__$1;
(statearr_34390_34428[(2)] = inst_34362);

(statearr_34390_34428[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (19))){
var state_34373__$1 = state_34373;
var statearr_34391_34429 = state_34373__$1;
(statearr_34391_34429[(1)] = (21));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (11))){
var inst_34344 = (state_34373[(10)]);
var inst_34343 = (state_34373[(9)]);
var inst_34343__$1 = (state_34373[(2)]);
var inst_34344__$1 = (inst_34343__$1 == null);
var state_34373__$1 = (function (){var statearr_34394 = state_34373;
(statearr_34394[(10)] = inst_34344__$1);

(statearr_34394[(9)] = inst_34343__$1);

return statearr_34394;
})();
if(cljs.core.truth_(inst_34344__$1)){
var statearr_34395_34430 = state_34373__$1;
(statearr_34395_34430[(1)] = (12));

} else {
var statearr_34396_34431 = state_34373__$1;
(statearr_34396_34431[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (9))){
var inst_34338 = (state_34373[(8)]);
var inst_34341 = fluree.db.storage.core.read_block(conn,network,dbid,inst_34338);
var state_34373__$1 = state_34373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34373__$1,(11),inst_34341);
} else {
if((state_val_34374 === (5))){
var _ = (function (){var statearr_34397 = state_34373;
(statearr_34397[(4)] = cljs.core.rest((state_34373[(4)])));

return statearr_34397;
})();
var state_34373__$1 = state_34373;
var ex34393 = (state_34373__$1[(2)]);
var statearr_34398_34432 = state_34373__$1;
(statearr_34398_34432[(5)] = ex34393);


if((ex34393 instanceof Error)){
var statearr_34399_34433 = state_34373__$1;
(statearr_34399_34433[(1)] = (4));

(statearr_34399_34433[(5)] = null);

} else {
throw ex34393;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (14))){
var inst_34349 = (state_34373[(2)]);
var state_34373__$1 = state_34373;
if(cljs.core.truth_(inst_34349)){
var statearr_34400_34434 = state_34373__$1;
(statearr_34400_34434[(1)] = (15));

} else {
var statearr_34401_34435 = state_34373__$1;
(statearr_34401_34435[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (16))){
var inst_34338 = (state_34373[(8)]);
var inst_34352 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34338,end);
var state_34373__$1 = state_34373;
if(inst_34352){
var statearr_34402_34436 = state_34373__$1;
(statearr_34402_34436[(1)] = (18));

} else {
var statearr_34403_34437 = state_34373__$1;
(statearr_34403_34437[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (10))){
var inst_34368 = (state_34373[(2)]);
var _ = (function (){var statearr_34404 = state_34373;
(statearr_34404[(4)] = cljs.core.rest((state_34373[(4)])));

return statearr_34404;
})();
var state_34373__$1 = state_34373;
var statearr_34405_34438 = state_34373__$1;
(statearr_34405_34438[(2)] = inst_34368);

(statearr_34405_34438[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (18))){
var inst_34339 = (state_34373[(7)]);
var inst_34343 = (state_34373[(9)]);
var inst_34354 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34339,inst_34343);
var state_34373__$1 = state_34373;
var statearr_34406_34439 = state_34373__$1;
(statearr_34406_34439[(2)] = inst_34354);

(statearr_34406_34439[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34374 === (8))){
var inst_34334 = (state_34373[(2)]);
var inst_34335 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_34336 = start;
var inst_34337 = cljs.core.PersistentVector.EMPTY;
var inst_34338 = inst_34336;
var inst_34339 = inst_34337;
var state_34373__$1 = (function (){var statearr_34407 = state_34373;
(statearr_34407[(8)] = inst_34338);

(statearr_34407[(7)] = inst_34339);

(statearr_34407[(11)] = inst_34335);

(statearr_34407[(12)] = inst_34334);

return statearr_34407;
})();
var statearr_34408_34440 = state_34373__$1;
(statearr_34408_34440[(2)] = null);

(statearr_34408_34440[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__16153__auto__ = null;
var fluree$db$storage$core$state_machine__16153__auto____0 = (function (){
var statearr_34409 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34409[(0)] = fluree$db$storage$core$state_machine__16153__auto__);

(statearr_34409[(1)] = (1));

return statearr_34409;
});
var fluree$db$storage$core$state_machine__16153__auto____1 = (function (state_34373){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_34373);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e34410){var ex__16156__auto__ = e34410;
var statearr_34411_34441 = state_34373;
(statearr_34411_34441[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_34373[(4)]))){
var statearr_34412_34442 = state_34373;
(statearr_34412_34442[(1)] = cljs.core.first((state_34373[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__34443 = state_34373;
state_34373 = G__34443;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__16153__auto__ = function(state_34373){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__16153__auto____1.call(this,state_34373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__16153__auto____0;
fluree$db$storage$core$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__16153__auto____1;
return fluree$db$storage$core$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_34413 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_34413[(6)] = c__16227__auto__);

return statearr_34413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_34459){
var state_val_34460 = (state_34459[(1)]);
if((state_val_34460 === (1))){
var state_34459__$1 = state_34459;
var statearr_34461_34475 = state_34459__$1;
(statearr_34461_34475[(2)] = null);

(statearr_34461_34475[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34460 === (2))){
var _ = (function (){var statearr_34462 = state_34459;
(statearr_34462[(4)] = cljs.core.cons((5),(state_34459[(4)])));

return statearr_34462;
})();
var inst_34450 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_34459__$1 = state_34459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34459__$1,(6),inst_34450);
} else {
if((state_val_34460 === (3))){
var inst_34457 = (state_34459[(2)]);
var state_34459__$1 = state_34459;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34459__$1,inst_34457);
} else {
if((state_val_34460 === (4))){
var inst_34444 = (state_34459[(2)]);
var state_34459__$1 = state_34459;
var statearr_34464_34476 = state_34459__$1;
(statearr_34464_34476[(2)] = inst_34444);

(statearr_34464_34476[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34460 === (5))){
var _ = (function (){var statearr_34465 = state_34459;
(statearr_34465[(4)] = cljs.core.rest((state_34459[(4)])));

return statearr_34465;
})();
var state_34459__$1 = state_34459;
var ex34463 = (state_34459__$1[(2)]);
var statearr_34466_34477 = state_34459__$1;
(statearr_34466_34477[(5)] = ex34463);


if((ex34463 instanceof Error)){
var statearr_34467_34478 = state_34459__$1;
(statearr_34467_34478[(1)] = (4));

(statearr_34467_34478[(5)] = null);

} else {
throw ex34463;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34460 === (6))){
var inst_34452 = (state_34459[(2)]);
var inst_34453 = fluree.db.util.async.throw_err(inst_34452);
var inst_34454 = cljs.core.first(inst_34453);
var _ = (function (){var statearr_34468 = state_34459;
(statearr_34468[(4)] = cljs.core.rest((state_34459[(4)])));

return statearr_34468;
})();
var state_34459__$1 = state_34459;
var statearr_34469_34479 = state_34459__$1;
(statearr_34469_34479[(2)] = inst_34454);

(statearr_34469_34479[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__16153__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__16153__auto____0 = (function (){
var statearr_34470 = [null,null,null,null,null,null,null];
(statearr_34470[(0)] = fluree$db$storage$core$block_$_state_machine__16153__auto__);

(statearr_34470[(1)] = (1));

return statearr_34470;
});
var fluree$db$storage$core$block_$_state_machine__16153__auto____1 = (function (state_34459){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_34459);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e34471){var ex__16156__auto__ = e34471;
var statearr_34472_34480 = state_34459;
(statearr_34472_34480[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_34459[(4)]))){
var statearr_34473_34481 = state_34459;
(statearr_34473_34481[(1)] = cljs.core.first((state_34459[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__34482 = state_34459;
state_34459 = G__34482;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__16153__auto__ = function(state_34459){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__16153__auto____1.call(this,state_34459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__16153__auto____0;
fluree$db$storage$core$block_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__16153__auto____1;
return fluree$db$storage$core$block_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_34474 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_34474[(6)] = c__16227__auto__);

return statearr_34474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
