// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4223__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_26683){
var state_val_26684 = (state_26683[(1)]);
if((state_val_26684 === (7))){
var inst_26678 = (state_26683[(2)]);
var _ = (function (){var statearr_26685 = state_26683;
(statearr_26685[(4)] = cljs.core.rest((state_26683[(4)])));

return statearr_26685;
})();
var state_26683__$1 = state_26683;
var statearr_26686_26708 = state_26683__$1;
(statearr_26686_26708[(2)] = inst_26678);

(statearr_26686_26708[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26684 === (1))){
var state_26683__$1 = state_26683;
var statearr_26687_26709 = state_26683__$1;
(statearr_26687_26709[(2)] = null);

(statearr_26687_26709[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26684 === (4))){
var inst_26640 = (state_26683[(2)]);
var state_26683__$1 = state_26683;
var statearr_26688_26710 = state_26683__$1;
(statearr_26688_26710[(2)] = inst_26640);

(statearr_26688_26710[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26684 === (6))){
var inst_26665 = (state_26683[(7)]);
var inst_26658 = (state_26683[(8)]);
var inst_26664 = cljs.core.seq(inst_26658);
var inst_26665__$1 = cljs.core.first(inst_26664);
var inst_26666 = cljs.core.next(inst_26664);
var inst_26667 = cljs.core.not(inst_26665__$1);
var state_26683__$1 = (function (){var statearr_26689 = state_26683;
(statearr_26689[(7)] = inst_26665__$1);

(statearr_26689[(9)] = inst_26666);

return statearr_26689;
})();
if(inst_26667){
var statearr_26690_26711 = state_26683__$1;
(statearr_26690_26711[(1)] = (8));

} else {
var statearr_26691_26712 = state_26683__$1;
(statearr_26691_26712[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26684 === (3))){
var inst_26681 = (state_26683[(2)]);
var state_26683__$1 = state_26683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26683__$1,inst_26681);
} else {
if((state_val_26684 === (2))){
var _ = (function (){var statearr_26692 = state_26683;
(statearr_26692[(4)] = cljs.core.cons((5),(state_26683[(4)])));

return statearr_26692;
})();
var inst_26653 = chs;
var inst_26654 = cljs.core.seq(inst_26653);
var inst_26655 = cljs.core.first(inst_26654);
var inst_26656 = cljs.core.next(inst_26654);
var inst_26657 = coll;
var inst_26658 = inst_26653;
var inst_26659 = inst_26657;
var state_26683__$1 = (function (){var statearr_26693 = state_26683;
(statearr_26693[(10)] = inst_26659);

(statearr_26693[(11)] = inst_26655);

(statearr_26693[(12)] = inst_26656);

(statearr_26693[(8)] = inst_26658);

return statearr_26693;
})();
var statearr_26694_26713 = state_26683__$1;
(statearr_26694_26713[(2)] = null);

(statearr_26694_26713[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26684 === (11))){
var inst_26659 = (state_26683[(10)]);
var inst_26666 = (state_26683[(9)]);
var inst_26671 = (state_26683[(2)]);
var inst_26672 = fluree.db.util.async.throw_err(inst_26671);
var inst_26673 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26659,inst_26672);
var inst_26658 = inst_26666;
var inst_26659__$1 = inst_26673;
var state_26683__$1 = (function (){var statearr_26696 = state_26683;
(statearr_26696[(10)] = inst_26659__$1);

(statearr_26696[(8)] = inst_26658);

return statearr_26696;
})();
var statearr_26697_26714 = state_26683__$1;
(statearr_26697_26714[(2)] = null);

(statearr_26697_26714[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26684 === (9))){
var inst_26665 = (state_26683[(7)]);
var state_26683__$1 = state_26683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26683__$1,(11),inst_26665);
} else {
if((state_val_26684 === (5))){
var _ = (function (){var statearr_26698 = state_26683;
(statearr_26698[(4)] = cljs.core.rest((state_26683[(4)])));

return statearr_26698;
})();
var state_26683__$1 = state_26683;
var ex26695 = (state_26683__$1[(2)]);
var statearr_26699_26715 = state_26683__$1;
(statearr_26699_26715[(5)] = ex26695);


var statearr_26700_26716 = state_26683__$1;
(statearr_26700_26716[(1)] = (4));

(statearr_26700_26716[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_26684 === (10))){
var inst_26676 = (state_26683[(2)]);
var state_26683__$1 = state_26683;
var statearr_26701_26717 = state_26683__$1;
(statearr_26701_26717[(2)] = inst_26676);

(statearr_26701_26717[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26684 === (8))){
var inst_26659 = (state_26683[(10)]);
var state_26683__$1 = state_26683;
var statearr_26702_26718 = state_26683__$1;
(statearr_26702_26718[(2)] = inst_26659);

(statearr_26702_26718[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16153__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16153__auto____0 = (function (){
var statearr_26703 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26703[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__16153__auto__);

(statearr_26703[(1)] = (1));

return statearr_26703;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16153__auto____1 = (function (state_26683){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_26683);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e26704){var ex__16156__auto__ = e26704;
var statearr_26705_26719 = state_26683;
(statearr_26705_26719[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_26683[(4)]))){
var statearr_26706_26720 = state_26683;
(statearr_26706_26720[(1)] = cljs.core.first((state_26683[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__26721 = state_26683;
state_26683 = G__26721;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__16153__auto__ = function(state_26683){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16153__auto____1.call(this,state_26683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__16153__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__16153__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_26707 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_26707[(6)] = c__16227__auto__);

return statearr_26707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_26747){
var state_val_26748 = (state_26747[(1)]);
if((state_val_26748 === (7))){
var inst_26742 = (state_26747[(2)]);
var _ = (function (){var statearr_26749 = state_26747;
(statearr_26749[(4)] = cljs.core.rest((state_26747[(4)])));

return statearr_26749;
})();
var state_26747__$1 = state_26747;
var statearr_26750_26772 = state_26747__$1;
(statearr_26750_26772[(2)] = inst_26742);

(statearr_26750_26772[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26748 === (1))){
var state_26747__$1 = state_26747;
var statearr_26751_26773 = state_26747__$1;
(statearr_26751_26773[(2)] = null);

(statearr_26751_26773[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26748 === (4))){
var inst_26722 = (state_26747[(2)]);
var state_26747__$1 = state_26747;
var statearr_26752_26774 = state_26747__$1;
(statearr_26752_26774[(2)] = inst_26722);

(statearr_26752_26774[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26748 === (6))){
var state_26747__$1 = state_26747;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26747__$1,(8),chan);
} else {
if((state_val_26748 === (3))){
var inst_26745 = (state_26747[(2)]);
var state_26747__$1 = state_26747;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26747__$1,inst_26745);
} else {
if((state_val_26748 === (2))){
var _ = (function (){var statearr_26753 = state_26747;
(statearr_26753[(4)] = cljs.core.cons((5),(state_26747[(4)])));

return statearr_26753;
})();
var inst_26728 = coll;
var inst_26729 = inst_26728;
var state_26747__$1 = (function (){var statearr_26754 = state_26747;
(statearr_26754[(7)] = inst_26729);

return statearr_26754;
})();
var statearr_26755_26775 = state_26747__$1;
(statearr_26755_26775[(2)] = null);

(statearr_26755_26775[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26748 === (11))){
var inst_26740 = (state_26747[(2)]);
var state_26747__$1 = state_26747;
var statearr_26757_26776 = state_26747__$1;
(statearr_26757_26776[(2)] = inst_26740);

(statearr_26757_26776[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26748 === (9))){
var inst_26729 = (state_26747[(7)]);
var state_26747__$1 = state_26747;
var statearr_26758_26777 = state_26747__$1;
(statearr_26758_26777[(2)] = inst_26729);

(statearr_26758_26777[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26748 === (5))){
var _ = (function (){var statearr_26759 = state_26747;
(statearr_26759[(4)] = cljs.core.rest((state_26747[(4)])));

return statearr_26759;
})();
var state_26747__$1 = state_26747;
var ex26756 = (state_26747__$1[(2)]);
var statearr_26760_26778 = state_26747__$1;
(statearr_26760_26778[(5)] = ex26756);


var statearr_26761_26779 = state_26747__$1;
(statearr_26761_26779[(1)] = (4));

(statearr_26761_26779[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_26748 === (10))){
var inst_26729 = (state_26747[(7)]);
var inst_26733 = (state_26747[(8)]);
var inst_26737 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26729,inst_26733);
var inst_26729__$1 = inst_26737;
var state_26747__$1 = (function (){var statearr_26762 = state_26747;
(statearr_26762[(7)] = inst_26729__$1);

return statearr_26762;
})();
var statearr_26763_26780 = state_26747__$1;
(statearr_26763_26780[(2)] = null);

(statearr_26763_26780[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26748 === (8))){
var inst_26733 = (state_26747[(8)]);
var inst_26732 = (state_26747[(2)]);
var inst_26733__$1 = fluree.db.util.async.throw_err(inst_26732);
var inst_26734 = (inst_26733__$1 == null);
var state_26747__$1 = (function (){var statearr_26764 = state_26747;
(statearr_26764[(8)] = inst_26733__$1);

return statearr_26764;
})();
if(cljs.core.truth_(inst_26734)){
var statearr_26765_26781 = state_26747__$1;
(statearr_26765_26781[(1)] = (9));

} else {
var statearr_26766_26782 = state_26747__$1;
(statearr_26766_26782[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__16153__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__16153__auto____0 = (function (){
var statearr_26767 = [null,null,null,null,null,null,null,null,null];
(statearr_26767[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__16153__auto__);

(statearr_26767[(1)] = (1));

return statearr_26767;
});
var fluree$db$util$async$into_QMARK__$_state_machine__16153__auto____1 = (function (state_26747){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_26747);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e26768){var ex__16156__auto__ = e26768;
var statearr_26769_26783 = state_26747;
(statearr_26769_26783[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_26747[(4)]))){
var statearr_26770_26784 = state_26747;
(statearr_26770_26784[(1)] = cljs.core.first((state_26747[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__26785 = state_26747;
state_26747 = G__26785;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__16153__auto__ = function(state_26747){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__16153__auto____1.call(this,state_26747);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__16153__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__16153__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_26771 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_26771[(6)] = c__16227__auto__);

return statearr_26771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
