// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__43089(s__43090){
return (new cljs.core.LazySeq(null,(function (){
var s__43090__$1 = s__43090;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43090__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43095 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43095,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43095,(1),null);
var iterys__4618__auto__ = ((function (s__43090__$1,vec__43095,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__43089_$_iter__43091(s__43092){
return (new cljs.core.LazySeq(null,((function (s__43090__$1,vec__43095,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__43092__$1 = s__43092;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43092__$1);
if(temp__5753__auto____$1){
var s__43092__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43092__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__43092__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__43094 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__43093 = (0);
while(true){
if((i__43093 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__43093);
cljs.core.chunk_append(b__43094,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__43147 = (i__43093 + (1));
i__43093 = G__43147;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43094),tailrecursion$priority_map$iter__43089_$_iter__43091(cljs.core.chunk_rest(s__43092__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43094),null);
}
} else {
var item = cljs.core.first(s__43092__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__43089_$_iter__43091(cljs.core.rest(s__43092__$2)));
}
} else {
return null;
}
break;
}
});})(s__43090__$1,vec__43095,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__43090__$1,vec__43095,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__43089(cljs.core.rest(s__43090__$1)));
} else {
var G__43148 = cljs.core.rest(s__43090__$1);
s__43090__$1 = G__43148;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__43098(s__43099){
return (new cljs.core.LazySeq(null,(function (){
var s__43099__$1 = s__43099;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43099__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43104 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43104,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43104,(1),null);
var iterys__4618__auto__ = ((function (s__43099__$1,vec__43104,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__43098_$_iter__43100(s__43101){
return (new cljs.core.LazySeq(null,((function (s__43099__$1,vec__43104,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__43101__$1 = s__43101;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43101__$1);
if(temp__5753__auto____$1){
var s__43101__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43101__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__43101__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__43103 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__43102 = (0);
while(true){
if((i__43102 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__43102);
cljs.core.chunk_append(b__43103,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__43149 = (i__43102 + (1));
i__43102 = G__43149;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43103),tailrecursion$priority_map$iter__43098_$_iter__43100(cljs.core.chunk_rest(s__43101__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43103),null);
}
} else {
var item = cljs.core.first(s__43101__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__43098_$_iter__43100(cljs.core.rest(s__43101__$2)));
}
} else {
return null;
}
break;
}
});})(s__43099__$1,vec__43104,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__43099__$1,vec__43104,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__43098(cljs.core.rest(s__43099__$1)));
} else {
var G__43150 = cljs.core.rest(s__43099__$1);
s__43099__$1 = G__43150;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__43107 = item;
var G__43108 = cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found;
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__43107,G__43108) : self__.item__GT_priority.call(null,G__43107,G__43108));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__43109(s__43110){
return (new cljs.core.LazySeq(null,(function (){
var s__43110__$1 = s__43110;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43110__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43115 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43115,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43115,(1),null);
var iterys__4618__auto__ = ((function (s__43110__$1,vec__43115,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__43109_$_iter__43111(s__43112){
return (new cljs.core.LazySeq(null,((function (s__43110__$1,vec__43115,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__43112__$1 = s__43112;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43112__$1);
if(temp__5753__auto____$1){
var s__43112__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43112__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__43112__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__43114 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__43113 = (0);
while(true){
if((i__43113 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__43113);
cljs.core.chunk_append(b__43114,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__43151 = (i__43113 + (1));
i__43113 = G__43151;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43114),tailrecursion$priority_map$iter__43109_$_iter__43111(cljs.core.chunk_rest(s__43112__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43114),null);
}
} else {
var item = cljs.core.first(s__43112__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__43109_$_iter__43111(cljs.core.rest(s__43112__$2)));
}
} else {
return null;
}
break;
}
});})(s__43110__$1,vec__43115,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__43110__$1,vec__43115,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__43109(cljs.core.rest(s__43110__$1)));
} else {
var G__43152 = cljs.core.rest(s__43110__$1);
s__43110__$1 = G__43152;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__43118(s__43119){
return (new cljs.core.LazySeq(null,(function (){
var s__43119__$1 = s__43119;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43119__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43124 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43124,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43124,(1),null);
var iterys__4618__auto__ = ((function (s__43119__$1,vec__43124,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__43118_$_iter__43120(s__43121){
return (new cljs.core.LazySeq(null,((function (s__43119__$1,vec__43124,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__43121__$1 = s__43121;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43121__$1);
if(temp__5753__auto____$1){
var s__43121__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43121__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__43121__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__43123 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__43122 = (0);
while(true){
if((i__43122 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__43122);
cljs.core.chunk_append(b__43123,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__43153 = (i__43122 + (1));
i__43122 = G__43153;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43123),tailrecursion$priority_map$iter__43118_$_iter__43120(cljs.core.chunk_rest(s__43121__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43123),null);
}
} else {
var item = cljs.core.first(s__43121__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__43118_$_iter__43120(cljs.core.rest(s__43121__$2)));
}
} else {
return null;
}
break;
}
});})(s__43119__$1,vec__43124,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__43119__$1,vec__43124,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__43118(cljs.core.rest(s__43119__$1)));
} else {
var G__43154 = cljs.core.rest(s__43119__$1);
s__43119__$1 = G__43154;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__43155 = null;
var G__43155__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__43155__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__43155 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__43155__2.call(this,self__,item);
case 3:
return G__43155__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__43155.cljs$core$IFn$_invoke$arity$2 = G__43155__2;
G__43155.cljs$core$IFn$_invoke$arity$3 = G__43155__3;
return G__43155;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args43088){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args43088)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__43127 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__43127.cljs$core$IFn$_invoke$arity$1 ? fexpr__43127.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__43127.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__43128(s__43129){
return (new cljs.core.LazySeq(null,(function (){
var s__43129__$1 = s__43129;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43129__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43134 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43134,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43134,(1),null);
var iterys__4618__auto__ = ((function (s__43129__$1,vec__43134,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__43128_$_iter__43130(s__43131){
return (new cljs.core.LazySeq(null,((function (s__43129__$1,vec__43134,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__43131__$1 = s__43131;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43131__$1);
if(temp__5753__auto____$1){
var s__43131__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43131__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__43131__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__43133 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__43132 = (0);
while(true){
if((i__43132 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__43132);
cljs.core.chunk_append(b__43133,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__43156 = (i__43132 + (1));
i__43132 = G__43156;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43133),tailrecursion$priority_map$iter__43128_$_iter__43130(cljs.core.chunk_rest(s__43131__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43133),null);
}
} else {
var item = cljs.core.first(s__43131__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__43128_$_iter__43130(cljs.core.rest(s__43131__$2)));
}
} else {
return null;
}
break;
}
});})(s__43129__$1,vec__43134,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__43129__$1,vec__43134,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__43128(cljs.core.rest(s__43129__$1)));
} else {
var G__43157 = cljs.core.rest(s__43129__$1);
s__43129__$1 = G__43157;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__43137(s__43138){
return (new cljs.core.LazySeq(null,(function (){
var s__43138__$1 = s__43138;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43138__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43143 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43143,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43143,(1),null);
var iterys__4618__auto__ = ((function (s__43138__$1,vec__43143,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__43137_$_iter__43139(s__43140){
return (new cljs.core.LazySeq(null,((function (s__43138__$1,vec__43143,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__43140__$1 = s__43140;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43140__$1);
if(temp__5753__auto____$1){
var s__43140__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43140__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__43140__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__43142 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__43141 = (0);
while(true){
if((i__43141 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__43141);
cljs.core.chunk_append(b__43142,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__43158 = (i__43141 + (1));
i__43141 = G__43158;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43142),tailrecursion$priority_map$iter__43137_$_iter__43139(cljs.core.chunk_rest(s__43140__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43142),null);
}
} else {
var item = cljs.core.first(s__43140__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__43137_$_iter__43139(cljs.core.rest(s__43140__$2)));
}
} else {
return null;
}
break;
}
});})(s__43138__$1,vec__43143,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__43138__$1,vec__43143,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__43137(cljs.core.rest(s__43138__$1)));
} else {
var G__43159 = cljs.core.rest(s__43138__$1);
s__43138__$1 = G__43159;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__43146 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__43146) : self__.keyfn.call(null,G__43146));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$priority_DASH__GT_set_DASH_of_DASH_items,cljs.core.cst$sym$item_DASH__GT_priority,cljs.core.cst$sym$meta,cljs.core.cst$sym$keyfn,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__43161 = arguments.length;
switch (G__43161) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4835__auto__ = [];
var len__4829__auto___43164 = arguments.length;
var i__4830__auto___43165 = (0);
while(true){
if((i__4830__auto___43165 < len__4829__auto___43164)){
args__4835__auto__.push((arguments[i__4830__auto___43165]));

var G__43166 = (i__4830__auto___43165 + (1));
i__4830__auto___43165 = G__43166;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__43167 = cljs.core.nnext(in$);
var G__43168 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43167;
out = G__43168;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq43163){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43163));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4835__auto__ = [];
var len__4829__auto___43171 = arguments.length;
var i__4830__auto___43172 = (0);
while(true){
if((i__4830__auto___43172 < len__4829__auto___43171)){
args__4835__auto__.push((arguments[i__4830__auto___43172]));

var G__43173 = (i__4830__auto___43172 + (1));
i__4830__auto___43172 = G__43173;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__43174 = cljs.core.nnext(in$);
var G__43175 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43174;
out = G__43175;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq43169){
var G__43170 = cljs.core.first(seq43169);
var seq43169__$1 = cljs.core.next(seq43169);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43170,seq43169__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4835__auto__ = [];
var len__4829__auto___43178 = arguments.length;
var i__4830__auto___43179 = (0);
while(true){
if((i__4830__auto___43179 < len__4829__auto___43178)){
args__4835__auto__.push((arguments[i__4830__auto___43179]));

var G__43180 = (i__4830__auto___43179 + (1));
i__4830__auto___43179 = G__43180;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__43181 = cljs.core.nnext(in$);
var G__43182 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43181;
out = G__43182;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq43176){
var G__43177 = cljs.core.first(seq43176);
var seq43176__$1 = cljs.core.next(seq43176);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43177,seq43176__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4835__auto__ = [];
var len__4829__auto___43186 = arguments.length;
var i__4830__auto___43187 = (0);
while(true){
if((i__4830__auto___43187 < len__4829__auto___43186)){
args__4835__auto__.push((arguments[i__4830__auto___43187]));

var G__43188 = (i__4830__auto___43187 + (1));
i__4830__auto___43187 = G__43188;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__43189 = cljs.core.nnext(in$);
var G__43190 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43189;
out = G__43190;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq43183){
var G__43184 = cljs.core.first(seq43183);
var seq43183__$1 = cljs.core.next(seq43183);
var G__43185 = cljs.core.first(seq43183__$1);
var seq43183__$2 = cljs.core.next(seq43183__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43184,G__43185,seq43183__$2);
}));

