// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__65884 = arguments.length;
switch (G__65884) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___65923 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65905){
var state_val_65906 = (state_65905[(1)]);
if((state_val_65906 === (1))){
var state_65905__$1 = state_65905;
var statearr_65907_65924 = state_65905__$1;
(statearr_65907_65924[(2)] = null);

(statearr_65907_65924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65906 === (2))){
var _ = (function (){var statearr_65908 = state_65905;
(statearr_65908[(4)] = cljs.core.cons((5),(state_65905[(4)])));

return statearr_65908;
})();
var inst_65891 = fluree.db.session.db(conn,ledger,null);
var state_65905__$1 = state_65905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65905__$1,(7),inst_65891);
} else {
if((state_val_65906 === (3))){
var inst_65901 = (state_65905[(2)]);
var inst_65902 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65901);
var inst_65903 = cljs.core.async.close_BANG_(pc);
var state_65905__$1 = (function (){var statearr_65910 = state_65905;
(statearr_65910[(7)] = inst_65902);

return statearr_65910;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_65905__$1,inst_65903);
} else {
if((state_val_65906 === (4))){
var inst_65885 = (state_65905[(2)]);
var state_65905__$1 = state_65905;
var statearr_65911_65925 = state_65905__$1;
(statearr_65911_65925[(2)] = inst_65885);

(statearr_65911_65925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65906 === (5))){
var _ = (function (){var statearr_65912 = state_65905;
(statearr_65912[(4)] = cljs.core.rest((state_65905[(4)])));

return statearr_65912;
})();
var state_65905__$1 = state_65905;
var ex65909 = (state_65905__$1[(2)]);
var statearr_65913_65926 = state_65905__$1;
(statearr_65913_65926[(5)] = ex65909);


var statearr_65914_65927 = state_65905__$1;
(statearr_65914_65927[(1)] = (4));

(statearr_65914_65927[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65906 === (6))){
var inst_65897 = (state_65905[(2)]);
var inst_65898 = fluree.db.util.async.throw_err(inst_65897);
var _ = (function (){var statearr_65915 = state_65905;
(statearr_65915[(4)] = cljs.core.rest((state_65905[(4)])));

return statearr_65915;
})();
var state_65905__$1 = state_65905;
var statearr_65916_65928 = state_65905__$1;
(statearr_65916_65928[(2)] = inst_65898);

(statearr_65916_65928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65906 === (7))){
var inst_65893 = (state_65905[(2)]);
var inst_65894 = fluree.db.util.async.throw_err(inst_65893);
var inst_65895 = fluree.db.time_travel.as_of_block(inst_65894,block);
var state_65905__$1 = state_65905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65905__$1,(6),inst_65895);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2733__auto__ = null;
var fluree$db$api$ledger$state_machine__2733__auto____0 = (function (){
var statearr_65917 = [null,null,null,null,null,null,null,null];
(statearr_65917[(0)] = fluree$db$api$ledger$state_machine__2733__auto__);

(statearr_65917[(1)] = (1));

return statearr_65917;
});
var fluree$db$api$ledger$state_machine__2733__auto____1 = (function (state_65905){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65905);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65918){var ex__2736__auto__ = e65918;
var statearr_65919_65929 = state_65905;
(statearr_65919_65929[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65905[(4)]))){
var statearr_65920_65930 = state_65905;
(statearr_65920_65930[(1)] = cljs.core.first((state_65905[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65931 = state_65905;
state_65905 = G__65931;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2733__auto__ = function(state_65905){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2733__auto____1.call(this,state_65905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2733__auto____0;
fluree$db$api$ledger$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2733__auto____1;
return fluree$db$api$ledger$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65921 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65921[(6)] = c__2755__auto___65923);

return statearr_65921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65972){
var state_val_65973 = (state_65972[(1)]);
if((state_val_65973 === (7))){
var inst_65941 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_65972__$1 = state_65972;
if(inst_65941){
var statearr_65974_66005 = state_65972__$1;
(statearr_65974_66005[(1)] = (9));

} else {
var statearr_65975_66006 = state_65972__$1;
(statearr_65975_66006[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (1))){
var state_65972__$1 = state_65972;
var statearr_65976_66007 = state_65972__$1;
(statearr_65976_66007[(2)] = null);

(statearr_65976_66007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (4))){
var inst_65932 = (state_65972[(2)]);
var state_65972__$1 = state_65972;
var statearr_65977_66008 = state_65972__$1;
(statearr_65977_66008[(2)] = inst_65932);

(statearr_65977_66008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (15))){
var inst_65949 = (state_65972[(7)]);
var inst_65948 = (state_65972[(2)]);
var inst_65949__$1 = fluree.db.util.async.throw_err(inst_65948);
var state_65972__$1 = (function (){var statearr_65978 = state_65972;
(statearr_65978[(7)] = inst_65949__$1);

return statearr_65978;
})();
if(cljs.core.truth_(inst_65949__$1)){
var statearr_65979_66009 = state_65972__$1;
(statearr_65979_66009[(1)] = (16));

} else {
var statearr_65980_66010 = state_65972__$1;
(statearr_65980_66010[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (13))){
var state_65972__$1 = state_65972;
var statearr_65981_66011 = state_65972__$1;
(statearr_65981_66011[(2)] = null);

(statearr_65981_66011[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (6))){
var state_65972__$1 = state_65972;
var statearr_65982_66012 = state_65972__$1;
(statearr_65982_66012[(2)] = db);

(statearr_65982_66012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (17))){
var inst_65953 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_65954 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65955 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_65956 = cljs.core.PersistentHashMap.fromArrays(inst_65954,inst_65955);
var inst_65957 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65953,inst_65956);
var inst_65958 = (function(){throw inst_65957})();
var state_65972__$1 = state_65972;
var statearr_65983_66013 = state_65972__$1;
(statearr_65983_66013[(2)] = inst_65958);

(statearr_65983_66013[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (3))){
var inst_65970 = (state_65972[(2)]);
var state_65972__$1 = state_65972;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65972__$1,inst_65970);
} else {
if((state_val_65973 === (12))){
var inst_65946 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_65972__$1 = state_65972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65972__$1,(15),inst_65946);
} else {
if((state_val_65973 === (2))){
var _ = (function (){var statearr_65984 = state_65972;
(statearr_65984[(4)] = cljs.core.cons((5),(state_65972[(4)])));

return statearr_65984;
})();
var inst_65938 = cljs.core.not(auth);
var state_65972__$1 = state_65972;
if(inst_65938){
var statearr_65985_66014 = state_65972__$1;
(statearr_65985_66014[(1)] = (6));

} else {
var statearr_65986_66015 = state_65972__$1;
(statearr_65986_66015[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (11))){
var inst_65965 = (state_65972[(2)]);
var state_65972__$1 = state_65972;
var statearr_65988_66016 = state_65972__$1;
(statearr_65988_66016[(2)] = inst_65965);

(statearr_65988_66016[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (9))){
var inst_65943 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_65972__$1 = state_65972;
var statearr_65989_66017 = state_65972__$1;
(statearr_65989_66017[(2)] = inst_65943);

(statearr_65989_66017[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (5))){
var _ = (function (){var statearr_65990 = state_65972;
(statearr_65990[(4)] = cljs.core.rest((state_65972[(4)])));

return statearr_65990;
})();
var state_65972__$1 = state_65972;
var ex65987 = (state_65972__$1[(2)]);
var statearr_65991_66018 = state_65972__$1;
(statearr_65991_66018[(5)] = ex65987);


if((ex65987 instanceof Error)){
var statearr_65992_66019 = state_65972__$1;
(statearr_65992_66019[(1)] = (4));

(statearr_65992_66019[(5)] = null);

} else {
throw ex65987;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (14))){
var inst_65963 = (state_65972[(2)]);
var state_65972__$1 = state_65972;
var statearr_65993_66020 = state_65972__$1;
(statearr_65993_66020[(2)] = inst_65963);

(statearr_65993_66020[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (16))){
var inst_65949 = (state_65972[(7)]);
var inst_65951 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_65949);
var state_65972__$1 = state_65972;
var statearr_65994_66021 = state_65972__$1;
(statearr_65994_66021[(2)] = inst_65951);

(statearr_65994_66021[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (10))){
var state_65972__$1 = state_65972;
var statearr_65995_66022 = state_65972__$1;
(statearr_65995_66022[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (18))){
var inst_65960 = (state_65972[(2)]);
var state_65972__$1 = state_65972;
var statearr_65997_66023 = state_65972__$1;
(statearr_65997_66023[(2)] = inst_65960);

(statearr_65997_66023[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (8))){
var inst_65967 = (state_65972[(2)]);
var _ = (function (){var statearr_65998 = state_65972;
(statearr_65998[(4)] = cljs.core.rest((state_65972[(4)])));

return statearr_65998;
})();
var state_65972__$1 = state_65972;
var statearr_65999_66024 = state_65972__$1;
(statearr_65999_66024[(2)] = inst_65967);

(statearr_65999_66024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____0 = (function (){
var statearr_66000 = [null,null,null,null,null,null,null,null];
(statearr_66000[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__);

(statearr_66000[(1)] = (1));

return statearr_66000;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____1 = (function (state_65972){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65972);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66001){var ex__2736__auto__ = e66001;
var statearr_66002_66025 = state_65972;
(statearr_66002_66025[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65972[(4)]))){
var statearr_66003_66026 = state_65972;
(statearr_66003_66026[(1)] = cljs.core.first((state_65972[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66027 = state_65972;
state_65972 = G__66027;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__ = function(state_65972){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____1.call(this,state_65972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66004 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66004[(6)] = c__2755__auto__);

return statearr_66004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66091){
var state_val_66092 = (state_66091[(1)]);
if((state_val_66092 === (7))){
var inst_66037 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_66091__$1 = state_66091;
if(inst_66037){
var statearr_66093_66142 = state_66091__$1;
(statearr_66093_66142[(1)] = (9));

} else {
var statearr_66094_66143 = state_66091__$1;
(statearr_66094_66143[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (20))){
var inst_66061 = (state_66091[(7)]);
var state_66091__$1 = state_66091;
if(cljs.core.truth_(inst_66061)){
var statearr_66095_66144 = state_66091__$1;
(statearr_66095_66144[(1)] = (22));

} else {
var statearr_66096_66145 = state_66091__$1;
(statearr_66096_66145[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (27))){
var state_66091__$1 = state_66091;
var statearr_66097_66146 = state_66091__$1;
(statearr_66097_66146[(2)] = null);

(statearr_66097_66146[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (1))){
var state_66091__$1 = state_66091;
var statearr_66098_66147 = state_66091__$1;
(statearr_66098_66147[(2)] = null);

(statearr_66098_66147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (24))){
var inst_66075 = (state_66091[(2)]);
var state_66091__$1 = state_66091;
var statearr_66099_66148 = state_66091__$1;
(statearr_66099_66148[(2)] = inst_66075);

(statearr_66099_66148[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (4))){
var inst_66028 = (state_66091[(2)]);
var state_66091__$1 = state_66091;
var statearr_66100_66149 = state_66091__$1;
(statearr_66100_66149[(2)] = inst_66028);

(statearr_66100_66149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (15))){
var inst_66044 = (state_66091[(8)]);
var inst_66043 = (state_66091[(2)]);
var inst_66044__$1 = fluree.db.util.async.throw_err(inst_66043);
var state_66091__$1 = (function (){var statearr_66101 = state_66091;
(statearr_66101[(8)] = inst_66044__$1);

return statearr_66101;
})();
if(cljs.core.truth_(inst_66044__$1)){
var statearr_66102_66150 = state_66091__$1;
(statearr_66102_66150[(1)] = (16));

} else {
var statearr_66103_66151 = state_66091__$1;
(statearr_66103_66151[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (21))){
var inst_66077 = (state_66091[(9)]);
var inst_66077__$1 = (state_66091[(2)]);
var state_66091__$1 = (function (){var statearr_66104 = state_66091;
(statearr_66104[(9)] = inst_66077__$1);

return statearr_66104;
})();
if(cljs.core.truth_(inst_66077__$1)){
var statearr_66105_66152 = state_66091__$1;
(statearr_66105_66152[(1)] = (29));

} else {
var statearr_66106_66153 = state_66091__$1;
(statearr_66106_66153[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (31))){
var inst_66061 = (state_66091[(7)]);
var inst_66077 = (state_66091[(9)]);
var inst_66085 = (state_66091[(2)]);
var inst_66086 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_66061,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_66077,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_66085], 0));
var _ = (function (){var statearr_66107 = state_66091;
(statearr_66107[(4)] = cljs.core.rest((state_66091[(4)])));

return statearr_66107;
})();
var state_66091__$1 = state_66091;
var statearr_66108_66154 = state_66091__$1;
(statearr_66108_66154[(2)] = inst_66086);

(statearr_66108_66154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (32))){
var inst_66081 = (state_66091[(2)]);
var inst_66082 = fluree.db.util.async.throw_err(inst_66081);
var state_66091__$1 = state_66091;
var statearr_66109_66155 = state_66091__$1;
(statearr_66109_66155[(2)] = inst_66082);

(statearr_66109_66155[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (13))){
var state_66091__$1 = state_66091;
var statearr_66110_66156 = state_66091__$1;
(statearr_66110_66156[(2)] = null);

(statearr_66110_66156[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (22))){
var inst_66061 = (state_66091[(7)]);
var inst_66065 = fluree.db.auth.roles(db,inst_66061);
var state_66091__$1 = state_66091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66091__$1,(25),inst_66065);
} else {
if((state_val_66092 === (29))){
var inst_66077 = (state_66091[(9)]);
var inst_66079 = fluree.db.permissions.permission_map(db,inst_66077,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_66091__$1 = state_66091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66091__$1,(32),inst_66079);
} else {
if((state_val_66092 === (6))){
var state_66091__$1 = state_66091;
var statearr_66111_66157 = state_66091__$1;
(statearr_66111_66157[(2)] = null);

(statearr_66111_66157[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (28))){
var inst_66073 = (state_66091[(2)]);
var state_66091__$1 = state_66091;
var statearr_66112_66158 = state_66091__$1;
(statearr_66112_66158[(2)] = inst_66073);

(statearr_66112_66158[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (25))){
var inst_66067 = (state_66091[(2)]);
var inst_66068 = fluree.db.util.async.throw_err(inst_66067);
var state_66091__$1 = state_66091;
var statearr_66113_66159 = state_66091__$1;
(statearr_66113_66159[(2)] = inst_66068);

(statearr_66113_66159[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (17))){
var inst_66047 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_66048 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66049 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_66050 = cljs.core.PersistentHashMap.fromArrays(inst_66048,inst_66049);
var inst_66051 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66047,inst_66050);
var inst_66052 = (function(){throw inst_66051})();
var state_66091__$1 = state_66091;
var statearr_66114_66160 = state_66091__$1;
(statearr_66114_66160[(2)] = inst_66052);

(statearr_66114_66160[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (3))){
var inst_66089 = (state_66091[(2)]);
var state_66091__$1 = state_66091;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66091__$1,inst_66089);
} else {
if((state_val_66092 === (12))){
var inst_66041 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_66091__$1 = state_66091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66091__$1,(15),inst_66041);
} else {
if((state_val_66092 === (2))){
var _ = (function (){var statearr_66115 = state_66091;
(statearr_66115[(4)] = cljs.core.cons((5),(state_66091[(4)])));

return statearr_66115;
})();
var inst_66034 = (auth == null);
var state_66091__$1 = state_66091;
if(cljs.core.truth_(inst_66034)){
var statearr_66116_66161 = state_66091__$1;
(statearr_66116_66161[(1)] = (6));

} else {
var statearr_66117_66162 = state_66091__$1;
(statearr_66117_66162[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (23))){
var state_66091__$1 = state_66091;
var statearr_66118_66163 = state_66091__$1;
(statearr_66118_66163[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (19))){
var state_66091__$1 = state_66091;
var statearr_66120_66164 = state_66091__$1;
(statearr_66120_66164[(2)] = roles);

(statearr_66120_66164[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (11))){
var inst_66059 = (state_66091[(2)]);
var state_66091__$1 = state_66091;
var statearr_66122_66165 = state_66091__$1;
(statearr_66122_66165[(2)] = inst_66059);

(statearr_66122_66165[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (9))){
var state_66091__$1 = state_66091;
var statearr_66123_66166 = state_66091__$1;
(statearr_66123_66166[(2)] = (0));

(statearr_66123_66166[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (5))){
var _ = (function (){var statearr_66124 = state_66091;
(statearr_66124[(4)] = cljs.core.rest((state_66091[(4)])));

return statearr_66124;
})();
var state_66091__$1 = state_66091;
var ex66121 = (state_66091__$1[(2)]);
var statearr_66125_66167 = state_66091__$1;
(statearr_66125_66167[(5)] = ex66121);


if((ex66121 instanceof Error)){
var statearr_66126_66168 = state_66091__$1;
(statearr_66126_66168[(1)] = (4));

(statearr_66126_66168[(5)] = null);

} else {
throw ex66121;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (14))){
var inst_66057 = (state_66091[(2)]);
var state_66091__$1 = state_66091;
var statearr_66127_66169 = state_66091__$1;
(statearr_66127_66169[(2)] = inst_66057);

(statearr_66127_66169[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (26))){
var state_66091__$1 = state_66091;
var statearr_66128_66170 = state_66091__$1;
(statearr_66128_66170[(2)] = null);

(statearr_66128_66170[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (16))){
var inst_66044 = (state_66091[(8)]);
var state_66091__$1 = state_66091;
var statearr_66129_66171 = state_66091__$1;
(statearr_66129_66171[(2)] = inst_66044);

(statearr_66129_66171[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (30))){
var state_66091__$1 = state_66091;
var statearr_66130_66172 = state_66091__$1;
(statearr_66130_66172[(2)] = null);

(statearr_66130_66172[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (10))){
var state_66091__$1 = state_66091;
if(cljs.core.truth_(auth)){
var statearr_66131_66173 = state_66091__$1;
(statearr_66131_66173[(1)] = (12));

} else {
var statearr_66132_66174 = state_66091__$1;
(statearr_66132_66174[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (18))){
var inst_66054 = (state_66091[(2)]);
var state_66091__$1 = state_66091;
var statearr_66133_66175 = state_66091__$1;
(statearr_66133_66175[(2)] = inst_66054);

(statearr_66133_66175[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (8))){
var inst_66061 = (state_66091[(2)]);
var state_66091__$1 = (function (){var statearr_66134 = state_66091;
(statearr_66134[(7)] = inst_66061);

return statearr_66134;
})();
if(cljs.core.truth_(roles)){
var statearr_66135_66176 = state_66091__$1;
(statearr_66135_66176[(1)] = (19));

} else {
var statearr_66136_66177 = state_66091__$1;
(statearr_66136_66177[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____0 = (function (){
var statearr_66137 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66137[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__);

(statearr_66137[(1)] = (1));

return statearr_66137;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____1 = (function (state_66091){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66091);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66138){var ex__2736__auto__ = e66138;
var statearr_66139_66178 = state_66091;
(statearr_66139_66178[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66091[(4)]))){
var statearr_66140_66179 = state_66091;
(statearr_66140_66179[(1)] = cljs.core.first((state_66091[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66180 = state_66091;
state_66091 = G__66180;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__ = function(state_66091){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____1.call(this,state_66091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66141 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66141[(6)] = c__2755__auto__);

return statearr_66141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__66181 = db;
var map__66181__$1 = cljs.core.__destructure_map(map__66181);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66181__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66181__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66181__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66188){
var state_val_66189 = (state_66188[(1)]);
if((state_val_66189 === (1))){
var inst_66182 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_66183 = fluree.db.session.db(conn,inst_66182,null);
var state_66188__$1 = state_66188;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66188__$1,(2),inst_66183);
} else {
if((state_val_66189 === (2))){
var inst_66185 = (state_66188[(2)]);
var inst_66186 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_66185);
var state_66188__$1 = state_66188;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66188__$1,inst_66186);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0 = (function (){
var statearr_66190 = [null,null,null,null,null,null,null];
(statearr_66190[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__);

(statearr_66190[(1)] = (1));

return statearr_66190;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1 = (function (state_66188){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66188);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66191){var ex__2736__auto__ = e66191;
var statearr_66192_66219 = state_66188;
(statearr_66192_66219[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66188[(4)]))){
var statearr_66193_66220 = state_66188;
(statearr_66193_66220[(1)] = cljs.core.first((state_66188[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66221 = state_66188;
state_66188 = G__66221;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__ = function(state_66188){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1.call(this,state_66188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66194 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66194[(6)] = c__2755__auto__);

return statearr_66194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66207){
var state_val_66208 = (state_66207[(1)]);
if((state_val_66208 === (1))){
var inst_66195 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_66196 = fluree.db.session.db(conn,inst_66195,null);
var state_66207__$1 = state_66207;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66207__$1,(2),inst_66196);
} else {
if((state_val_66208 === (2))){
var inst_66198 = (state_66207[(7)]);
var inst_66198__$1 = (state_66207[(2)]);
var inst_66199 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_66198__$1);
var inst_66200 = newer_block_QMARK_(inst_66199);
var state_66207__$1 = (function (){var statearr_66209 = state_66207;
(statearr_66209[(7)] = inst_66198__$1);

return statearr_66209;
})();
if(inst_66200){
var statearr_66210_66222 = state_66207__$1;
(statearr_66210_66222[(1)] = (3));

} else {
var statearr_66211_66223 = state_66207__$1;
(statearr_66211_66223[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66208 === (3))){
var inst_66198 = (state_66207[(7)]);
var inst_66202 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_66198);
var state_66207__$1 = state_66207;
var statearr_66212_66224 = state_66207__$1;
(statearr_66212_66224[(2)] = inst_66202);

(statearr_66212_66224[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66208 === (4))){
var state_66207__$1 = state_66207;
var statearr_66213_66225 = state_66207__$1;
(statearr_66213_66225[(2)] = null);

(statearr_66213_66225[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66208 === (5))){
var inst_66205 = (state_66207[(2)]);
var state_66207__$1 = state_66207;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66207__$1,inst_66205);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0 = (function (){
var statearr_66214 = [null,null,null,null,null,null,null,null];
(statearr_66214[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__);

(statearr_66214[(1)] = (1));

return statearr_66214;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1 = (function (state_66207){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66207);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66215){var ex__2736__auto__ = e66215;
var statearr_66216_66226 = state_66207;
(statearr_66216_66226[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66207[(4)]))){
var statearr_66217_66227 = state_66207;
(statearr_66217_66227[(1)] = cljs.core.first((state_66207[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66228 = state_66207;
state_66207 = G__66228;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__ = function(state_66207){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1.call(this,state_66207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66218 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66218[(6)] = c__2755__auto__);

return statearr_66218;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__66229 = db;
var map__66229__$1 = cljs.core.__destructure_map(map__66229);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66229__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66229__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66229__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4309__auto__ = syncTimeout;
var y__4310__auto__ = (120000);
return ((x__4309__auto__ < y__4310__auto__) ? x__4309__auto__ : y__4310__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2755__auto___66305 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66279){
var state_val_66280 = (state_66279[(1)]);
if((state_val_66280 === (7))){
var inst_66245 = (state_66279[(7)]);
var inst_66256 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66245,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_66279__$1 = state_66279;
if(inst_66256){
var statearr_66281_66306 = state_66279__$1;
(statearr_66281_66306[(1)] = (9));

} else {
var statearr_66282_66307 = state_66279__$1;
(statearr_66282_66307[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66280 === (1))){
var inst_66238 = (state_66279[(8)]);
var inst_66230 = (state_66279[(9)]);
var inst_66230__$1 = cljs.core.async.timeout(timeout);
var inst_66238__$1 = res_port;
var inst_66239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66240 = [inst_66230__$1,inst_66238__$1];
var inst_66241 = (new cljs.core.PersistentVector(null,2,(5),inst_66239,inst_66240,null));
var state_66279__$1 = (function (){var statearr_66283 = state_66279;
(statearr_66283[(8)] = inst_66238__$1);

(statearr_66283[(9)] = inst_66230__$1);

return statearr_66283;
})();
return cljs.core.async.ioc_alts_BANG_(state_66279__$1,(2),inst_66241);
} else {
if((state_val_66280 === (4))){
var inst_66238 = (state_66279[(8)]);
var inst_66245 = (state_66279[(7)]);
var inst_66249 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66245,inst_66238);
var state_66279__$1 = state_66279;
if(inst_66249){
var statearr_66284_66308 = state_66279__$1;
(statearr_66284_66308[(1)] = (6));

} else {
var statearr_66285_66309 = state_66279__$1;
(statearr_66285_66309[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66280 === (13))){
var inst_66264 = (state_66279[(10)]);
var inst_66275 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66264);
var state_66279__$1 = state_66279;
var statearr_66286_66310 = state_66279__$1;
(statearr_66286_66310[(2)] = inst_66275);

(statearr_66286_66310[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66280 === (6))){
var inst_66243 = (state_66279[(11)]);
var inst_66254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66243,(0),null);
var state_66279__$1 = state_66279;
var statearr_66287_66311 = state_66279__$1;
(statearr_66287_66311[(2)] = inst_66254);

(statearr_66287_66311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66280 === (3))){
var state_66279__$1 = state_66279;
var statearr_66288_66312 = state_66279__$1;
(statearr_66288_66312[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_66288_66312[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66280 === (12))){
var inst_66268 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_66269 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66270 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_66271 = cljs.core.PersistentHashMap.fromArrays(inst_66269,inst_66270);
var inst_66272 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66268,inst_66271);
var inst_66273 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66272);
var state_66279__$1 = state_66279;
var statearr_66289_66313 = state_66279__$1;
(statearr_66289_66313[(2)] = inst_66273);

(statearr_66289_66313[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66280 === (2))){
var inst_66230 = (state_66279[(9)]);
var inst_66245 = (state_66279[(7)]);
var inst_66243 = (state_66279[(11)]);
var inst_66243__$1 = (state_66279[(2)]);
var inst_66244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66243__$1,(0),null);
var inst_66245__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66243__$1,(1),null);
var inst_66246 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66245__$1,inst_66230);
var state_66279__$1 = (function (){var statearr_66290 = state_66279;
(statearr_66290[(7)] = inst_66245__$1);

(statearr_66290[(12)] = inst_66244);

(statearr_66290[(11)] = inst_66243__$1);

return statearr_66290;
})();
if(inst_66246){
var statearr_66291_66314 = state_66279__$1;
(statearr_66291_66314[(1)] = (3));

} else {
var statearr_66292_66315 = state_66279__$1;
(statearr_66292_66315[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66280 === (11))){
var inst_66260 = (state_66279[(2)]);
var state_66279__$1 = state_66279;
var statearr_66293_66316 = state_66279__$1;
(statearr_66293_66316[(2)] = inst_66260);

(statearr_66293_66316[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66280 === (9))){
var inst_66244 = (state_66279[(12)]);
var state_66279__$1 = state_66279;
var statearr_66294_66317 = state_66279__$1;
(statearr_66294_66317[(2)] = inst_66244);

(statearr_66294_66317[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66280 === (5))){
var inst_66264 = (state_66279[(10)]);
var inst_66264__$1 = (state_66279[(2)]);
var inst_66265 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_66266 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_66264__$1);
var state_66279__$1 = (function (){var statearr_66295 = state_66279;
(statearr_66295[(10)] = inst_66264__$1);

(statearr_66295[(13)] = inst_66265);

return statearr_66295;
})();
if(inst_66266){
var statearr_66296_66318 = state_66279__$1;
(statearr_66296_66318[(1)] = (12));

} else {
var statearr_66297_66319 = state_66279__$1;
(statearr_66297_66319[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66280 === (14))){
var inst_66277 = (state_66279[(2)]);
var state_66279__$1 = state_66279;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66279__$1,inst_66277);
} else {
if((state_val_66280 === (10))){
var state_66279__$1 = state_66279;
var statearr_66298_66320 = state_66279__$1;
(statearr_66298_66320[(2)] = null);

(statearr_66298_66320[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66280 === (8))){
var inst_66262 = (state_66279[(2)]);
var state_66279__$1 = state_66279;
var statearr_66299_66321 = state_66279__$1;
(statearr_66299_66321[(2)] = inst_66262);

(statearr_66299_66321[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____0 = (function (){
var statearr_66300 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66300[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__);

(statearr_66300[(1)] = (1));

return statearr_66300;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____1 = (function (state_66279){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66279);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66301){var ex__2736__auto__ = e66301;
var statearr_66302_66322 = state_66279;
(statearr_66302_66322[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66279[(4)]))){
var statearr_66303_66323 = state_66279;
(statearr_66303_66323[(1)] = cljs.core.first((state_66279[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66324 = state_66279;
state_66279 = G__66324;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__ = function(state_66279){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____1.call(this,state_66279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66304 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66304[(6)] = c__2755__auto___66305);

return statearr_66304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__66326 = arguments.length;
switch (G__66326) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__66327){
var map__66328 = p__66327;
var map__66328__$1 = cljs.core.__destructure_map(map__66328);
var opts = map__66328__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66328__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66328__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66328__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66328__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66328__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2755__auto___66417 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66379){
var state_val_66380 = (state_66379[(1)]);
if((state_val_66380 === (7))){
var inst_66341 = (state_66379[(7)]);
var inst_66343 = fluree.db.api.ledger.syncTo_db(inst_66341,syncTo,syncTimeout);
var state_66379__$1 = state_66379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66379__$1,(10),inst_66343);
} else {
if((state_val_66380 === (20))){
var inst_66365 = (state_66379[(8)]);
var state_66379__$1 = state_66379;
var statearr_66381_66418 = state_66379__$1;
(statearr_66381_66418[(2)] = inst_66365);

(statearr_66381_66418[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (1))){
var state_66379__$1 = state_66379;
var statearr_66382_66419 = state_66379__$1;
(statearr_66382_66419[(2)] = null);

(statearr_66382_66419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (4))){
var inst_66329 = (state_66379[(2)]);
var inst_66330 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66329);
var inst_66331 = cljs.core.async.close_BANG_(pc);
var state_66379__$1 = (function (){var statearr_66383 = state_66379;
(statearr_66383[(9)] = inst_66330);

return statearr_66383;
})();
var statearr_66384_66420 = state_66379__$1;
(statearr_66384_66420[(2)] = inst_66331);

(statearr_66384_66420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (15))){
var inst_66357 = (state_66379[(10)]);
var inst_66359 = fluree.db.api.ledger.add_db_permissions(inst_66357,auth,roles);
var state_66379__$1 = state_66379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66379__$1,(18),inst_66359);
} else {
if((state_val_66380 === (21))){
var inst_66373 = (state_66379[(2)]);
var inst_66374 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66373);
var _ = (function (){var statearr_66385 = state_66379;
(statearr_66385[(4)] = cljs.core.rest((state_66379[(4)])));

return statearr_66385;
})();
var state_66379__$1 = state_66379;
var statearr_66386_66421 = state_66379__$1;
(statearr_66386_66421[(2)] = inst_66374);

(statearr_66386_66421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (13))){
var inst_66357 = (state_66379[(2)]);
var state_66379__$1 = (function (){var statearr_66387 = state_66379;
(statearr_66387[(10)] = inst_66357);

return statearr_66387;
})();
if(cljs.core.truth_(roles)){
var statearr_66388_66422 = state_66379__$1;
(statearr_66388_66422[(1)] = (15));

} else {
var statearr_66389_66423 = state_66379__$1;
(statearr_66389_66423[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (22))){
var inst_66369 = (state_66379[(2)]);
var inst_66370 = fluree.db.util.async.throw_err(inst_66369);
var state_66379__$1 = state_66379;
var statearr_66390_66424 = state_66379__$1;
(statearr_66390_66424[(2)] = inst_66370);

(statearr_66390_66424[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (6))){
var inst_66340 = (state_66379[(2)]);
var inst_66341 = fluree.db.util.async.throw_err(inst_66340);
var state_66379__$1 = (function (){var statearr_66391 = state_66379;
(statearr_66391[(7)] = inst_66341);

return statearr_66391;
})();
if(cljs.core.truth_(syncTo)){
var statearr_66392_66425 = state_66379__$1;
(statearr_66392_66425[(1)] = (7));

} else {
var statearr_66393_66426 = state_66379__$1;
(statearr_66393_66426[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (17))){
var inst_66365 = (state_66379[(2)]);
var state_66379__$1 = (function (){var statearr_66394 = state_66379;
(statearr_66394[(8)] = inst_66365);

return statearr_66394;
})();
if(cljs.core.truth_(auth)){
var statearr_66395_66427 = state_66379__$1;
(statearr_66395_66427[(1)] = (19));

} else {
var statearr_66396_66428 = state_66379__$1;
(statearr_66396_66428[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (3))){
var inst_66377 = (state_66379[(2)]);
var state_66379__$1 = state_66379;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66379__$1,inst_66377);
} else {
if((state_val_66380 === (12))){
var inst_66349 = (state_66379[(11)]);
var state_66379__$1 = state_66379;
var statearr_66397_66429 = state_66379__$1;
(statearr_66397_66429[(2)] = inst_66349);

(statearr_66397_66429[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (2))){
var _ = (function (){var statearr_66398 = state_66379;
(statearr_66398[(4)] = cljs.core.cons((5),(state_66379[(4)])));

return statearr_66398;
})();
var inst_66338 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_66379__$1 = state_66379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66379__$1,(6),inst_66338);
} else {
if((state_val_66380 === (19))){
var inst_66365 = (state_66379[(8)]);
var inst_66367 = fluree.db.api.ledger.add_db_permissions(inst_66365,auth,roles);
var state_66379__$1 = state_66379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66379__$1,(22),inst_66367);
} else {
if((state_val_66380 === (11))){
var inst_66349 = (state_66379[(11)]);
var inst_66351 = fluree.db.time_travel.as_of_block(inst_66349,block);
var state_66379__$1 = state_66379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66379__$1,(14),inst_66351);
} else {
if((state_val_66380 === (9))){
var inst_66349 = (state_66379[(2)]);
var state_66379__$1 = (function (){var statearr_66400 = state_66379;
(statearr_66400[(11)] = inst_66349);

return statearr_66400;
})();
if(cljs.core.truth_(block)){
var statearr_66401_66430 = state_66379__$1;
(statearr_66401_66430[(1)] = (11));

} else {
var statearr_66402_66431 = state_66379__$1;
(statearr_66402_66431[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (5))){
var _ = (function (){var statearr_66403 = state_66379;
(statearr_66403[(4)] = cljs.core.rest((state_66379[(4)])));

return statearr_66403;
})();
var state_66379__$1 = state_66379;
var ex66399 = (state_66379__$1[(2)]);
var statearr_66404_66432 = state_66379__$1;
(statearr_66404_66432[(5)] = ex66399);


var statearr_66405_66433 = state_66379__$1;
(statearr_66405_66433[(1)] = (4));

(statearr_66405_66433[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (14))){
var inst_66353 = (state_66379[(2)]);
var inst_66354 = fluree.db.util.async.throw_err(inst_66353);
var state_66379__$1 = state_66379;
var statearr_66406_66434 = state_66379__$1;
(statearr_66406_66434[(2)] = inst_66354);

(statearr_66406_66434[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (16))){
var inst_66357 = (state_66379[(10)]);
var state_66379__$1 = state_66379;
var statearr_66407_66435 = state_66379__$1;
(statearr_66407_66435[(2)] = inst_66357);

(statearr_66407_66435[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (10))){
var inst_66345 = (state_66379[(2)]);
var inst_66346 = fluree.db.util.async.throw_err(inst_66345);
var state_66379__$1 = state_66379;
var statearr_66408_66436 = state_66379__$1;
(statearr_66408_66436[(2)] = inst_66346);

(statearr_66408_66436[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (18))){
var inst_66361 = (state_66379[(2)]);
var inst_66362 = fluree.db.util.async.throw_err(inst_66361);
var state_66379__$1 = state_66379;
var statearr_66409_66437 = state_66379__$1;
(statearr_66409_66437[(2)] = inst_66362);

(statearr_66409_66437[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66380 === (8))){
var inst_66341 = (state_66379[(7)]);
var state_66379__$1 = state_66379;
var statearr_66410_66438 = state_66379__$1;
(statearr_66410_66438[(2)] = inst_66341);

(statearr_66410_66438[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2733__auto__ = null;
var fluree$db$api$ledger$state_machine__2733__auto____0 = (function (){
var statearr_66411 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66411[(0)] = fluree$db$api$ledger$state_machine__2733__auto__);

(statearr_66411[(1)] = (1));

return statearr_66411;
});
var fluree$db$api$ledger$state_machine__2733__auto____1 = (function (state_66379){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66379);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66412){var ex__2736__auto__ = e66412;
var statearr_66413_66439 = state_66379;
(statearr_66413_66439[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66379[(4)]))){
var statearr_66414_66440 = state_66379;
(statearr_66414_66440[(1)] = cljs.core.first((state_66379[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66441 = state_66379;
state_66379 = G__66441;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2733__auto__ = function(state_66379){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2733__auto____1.call(this,state_66379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2733__auto____0;
fluree$db$api$ledger$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2733__auto____1;
return fluree$db$api$ledger$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66415 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66415[(6)] = c__2755__auto___66417);

return statearr_66415;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

