// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('goog.string.format');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4835__auto__ = [];
var len__4829__auto___63985 = arguments.length;
var i__4830__auto___63986 = (0);
while(true){
if((i__4830__auto___63986 < len__4829__auto___63985)){
args__4835__auto__.push((arguments[i__4830__auto___63986]));

var G__63987 = (i__4830__auto___63986 + (1));
i__4830__auto___63986 = G__63987;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__63917){
var vec__63918 = p__63917;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63918,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___63988 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63962){
var state_val_63963 = (state_63962[(1)]);
if((state_val_63963 === (7))){
var inst_63948 = (state_63962[(7)]);
var inst_63939 = (state_63962[(8)]);
var inst_63950 = fluree.db.time_travel.as_of_block(inst_63948,inst_63939);
var state_63962__$1 = state_63962;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63962__$1,(10),inst_63950);
} else {
if((state_val_63963 === (1))){
var state_63962__$1 = state_63962;
var statearr_63964_63989 = state_63962__$1;
(statearr_63964_63989[(2)] = null);

(statearr_63964_63989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63963 === (4))){
var inst_63921 = (state_63962[(2)]);
var inst_63922 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63921], 0));
var inst_63923 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63921);
var inst_63924 = cljs.core.async.close_BANG_(pc);
var state_63962__$1 = (function (){var statearr_63965 = state_63962;
(statearr_63965[(9)] = inst_63922);

(statearr_63965[(10)] = inst_63923);

return statearr_63965;
})();
var statearr_63966_63990 = state_63962__$1;
(statearr_63966_63990[(2)] = inst_63924);

(statearr_63966_63990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63963 === (6))){
var inst_63939 = (state_63962[(8)]);
var inst_63943 = (state_63962[(11)]);
var inst_63942 = (state_63962[(12)]);
var inst_63946 = (state_63962[(2)]);
var inst_63947 = fluree.db.util.async.throw_err(inst_63946);
var inst_63948 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_63947,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_63942,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_63943], 0));
var state_63962__$1 = (function (){var statearr_63967 = state_63962;
(statearr_63967[(7)] = inst_63948);

return statearr_63967;
})();
if(cljs.core.truth_(inst_63939)){
var statearr_63968_63991 = state_63962__$1;
(statearr_63968_63991[(1)] = (7));

} else {
var statearr_63969_63992 = state_63962__$1;
(statearr_63969_63992[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63963 === (3))){
var inst_63960 = (state_63962[(2)]);
var state_63962__$1 = state_63962;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63962__$1,inst_63960);
} else {
if((state_val_63963 === (2))){
var _ = (function (){var statearr_63971 = state_63962;
(statearr_63971[(4)] = cljs.core.cons((5),(state_63962[(4)])));

return statearr_63971;
})();
var inst_63934 = opts;
var inst_63935 = cljs.core.__destructure_map(inst_63934);
var inst_63936 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63935,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_63937 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63935,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_63938 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63935,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_63939 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63935,new cljs.core.Keyword(null,"block","block",664686210));
var inst_63940 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_63941 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_63942 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63941,(0),null);
var inst_63943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63941,(1),null);
var inst_63944 = fluree.db.session.db(conn,ledger,opts);
var state_63962__$1 = (function (){var statearr_63972 = state_63962;
(statearr_63972[(13)] = inst_63938);

(statearr_63972[(14)] = inst_63940);

(statearr_63972[(15)] = inst_63937);

(statearr_63972[(8)] = inst_63939);

(statearr_63972[(11)] = inst_63943);

(statearr_63972[(16)] = inst_63936);

(statearr_63972[(12)] = inst_63942);

return statearr_63972;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63962__$1,(6),inst_63944);
} else {
if((state_val_63963 === (9))){
var inst_63956 = (state_63962[(2)]);
var inst_63957 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63956);
var _ = (function (){var statearr_63973 = state_63962;
(statearr_63973[(4)] = cljs.core.rest((state_63962[(4)])));

return statearr_63973;
})();
var state_63962__$1 = state_63962;
var statearr_63974_63993 = state_63962__$1;
(statearr_63974_63993[(2)] = inst_63957);

(statearr_63974_63993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63963 === (5))){
var _ = (function (){var statearr_63975 = state_63962;
(statearr_63975[(4)] = cljs.core.rest((state_63962[(4)])));

return statearr_63975;
})();
var state_63962__$1 = state_63962;
var ex63970 = (state_63962__$1[(2)]);
var statearr_63976_63994 = state_63962__$1;
(statearr_63976_63994[(5)] = ex63970);


var statearr_63977_63995 = state_63962__$1;
(statearr_63977_63995[(1)] = (4));

(statearr_63977_63995[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63963 === (10))){
var inst_63952 = (state_63962[(2)]);
var inst_63953 = fluree.db.util.async.throw_err(inst_63952);
var state_63962__$1 = state_63962;
var statearr_63978_63996 = state_63962__$1;
(statearr_63978_63996[(2)] = inst_63953);

(statearr_63978_63996[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63963 === (8))){
var inst_63948 = (state_63962[(7)]);
var state_63962__$1 = state_63962;
var statearr_63979_63997 = state_63962__$1;
(statearr_63979_63997[(2)] = inst_63948);

(statearr_63979_63997[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_63980 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63980[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_63980[(1)] = (1));

return statearr_63980;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_63962){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63962);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63981){var ex__2736__auto__ = e63981;
var statearr_63982_63998 = state_63962;
(statearr_63982_63998[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63962[(4)]))){
var statearr_63983_63999 = state_63962;
(statearr_63983_63999[(1)] = cljs.core.first((state_63962[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64000 = state_63962;
state_63962 = G__64000;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_63962){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_63962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63984 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63984[(6)] = c__2755__auto___63988);

return statearr_63984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq63914){
var G__63915 = cljs.core.first(seq63914);
var seq63914__$1 = cljs.core.next(seq63914);
var G__63916 = cljs.core.first(seq63914__$1);
var seq63914__$2 = cljs.core.next(seq63914__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63915,G__63916,seq63914__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4221__auto__){
var and__4221__auto____$1 = open_api;
if(cljs.core.truth_(and__4221__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4221__auto__){
return open_api;
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4221__auto__){
return auth;
} else {
return and__4221__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__64003 = arguments.length;
switch (G__64003) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64133){
var state_val_64134 = (state_64133[(1)]);
if((state_val_64134 === (7))){
var inst_64019 = (state_64133[(7)]);
var inst_64029 = (state_64133[(8)]);
var inst_64031 = fluree.db.time_travel.as_of_block(inst_64029,inst_64019);
var state_64133__$1 = state_64133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64133__$1,(10),inst_64031);
} else {
if((state_val_64134 === (20))){
var inst_64023 = (state_64133[(9)]);
var state_64133__$1 = state_64133;
var statearr_64135_64218 = state_64133__$1;
(statearr_64135_64218[(2)] = inst_64023);

(statearr_64135_64218[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (27))){
var inst_64017 = (state_64133[(10)]);
var state_64133__$1 = state_64133;
var statearr_64136_64219 = state_64133__$1;
(statearr_64136_64219[(2)] = inst_64017);

(statearr_64136_64219[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (1))){
var state_64133__$1 = state_64133;
var statearr_64137_64220 = state_64133__$1;
(statearr_64137_64220[(2)] = null);

(statearr_64137_64220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (24))){
var inst_64026 = (state_64133[(11)]);
var state_64133__$1 = state_64133;
if(cljs.core.truth_(inst_64026)){
var statearr_64138_64221 = state_64133__$1;
(statearr_64138_64221[(1)] = (26));

} else {
var statearr_64139_64222 = state_64133__$1;
(statearr_64139_64222[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (39))){
var inst_64091 = (state_64133[(12)]);
var inst_64094 = cljs.core.ex_data(inst_64091);
var inst_64095 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64096 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_64094);
var inst_64097 = cljs.core.ex_message(inst_64091);
var inst_64098 = [inst_64096,inst_64097,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64099 = cljs.core.PersistentHashMap.fromArrays(inst_64095,inst_64098);
var state_64133__$1 = state_64133;
var statearr_64140_64223 = state_64133__$1;
(statearr_64140_64223[(2)] = inst_64099);

(statearr_64140_64223[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (46))){
var inst_64091 = (state_64133[(12)]);
var state_64133__$1 = state_64133;
var statearr_64141_64224 = state_64133__$1;
(statearr_64141_64224[(2)] = inst_64091);

(statearr_64141_64224[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (4))){
var inst_64004 = (state_64133[(2)]);
var inst_64005 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64004], 0));
var inst_64006 = cljs.core.ex_data(inst_64004);
var inst_64007 = cljs.core.ex_message(inst_64004);
var inst_64008 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64006,new cljs.core.Keyword(null,"message","message",-406056002),inst_64007);
var state_64133__$1 = (function (){var statearr_64142 = state_64133;
(statearr_64142[(13)] = inst_64005);

return statearr_64142;
})();
var statearr_64143_64225 = state_64133__$1;
(statearr_64143_64225[(2)] = inst_64008);

(statearr_64143_64225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (15))){
var state_64133__$1 = state_64133;
var statearr_64144_64226 = state_64133__$1;
(statearr_64144_64226[(2)] = (1000000));

(statearr_64144_64226[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (48))){
var inst_64091 = (state_64133[(12)]);
var state_64133__$1 = state_64133;
var statearr_64145_64227 = state_64133__$1;
(statearr_64145_64227[(2)] = inst_64091);

(statearr_64145_64227[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (50))){
var inst_64122 = (state_64133[(2)]);
var state_64133__$1 = state_64133;
var statearr_64146_64228 = state_64133__$1;
(statearr_64146_64228[(2)] = inst_64122);

(statearr_64146_64228[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (21))){
var inst_64022 = (state_64133[(14)]);
var state_64133__$1 = state_64133;
if(cljs.core.truth_(inst_64022)){
var statearr_64147_64229 = state_64133__$1;
(statearr_64147_64229[(1)] = (23));

} else {
var statearr_64148_64230 = state_64133__$1;
(statearr_64148_64230[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (31))){
var inst_64080 = (state_64133[(15)]);
var inst_64080__$1 = (state_64133[(2)]);
var inst_64081 = cljs.core.not(inst_64080__$1);
var state_64133__$1 = (function (){var statearr_64149 = state_64133;
(statearr_64149[(15)] = inst_64080__$1);

return statearr_64149;
})();
if(inst_64081){
var statearr_64150_64231 = state_64133__$1;
(statearr_64150_64231[(1)] = (35));

} else {
var statearr_64151_64232 = state_64133__$1;
(statearr_64151_64232[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (32))){
var inst_64024 = (state_64133[(16)]);
var state_64133__$1 = state_64133;
var statearr_64152_64233 = state_64133__$1;
(statearr_64152_64233[(2)] = inst_64024);

(statearr_64152_64233[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (40))){
var inst_64054 = (state_64133[(17)]);
var state_64133__$1 = state_64133;
if(cljs.core.truth_(inst_64054)){
var statearr_64153_64234 = state_64133__$1;
(statearr_64153_64234[(1)] = (42));

} else {
var statearr_64154_64235 = state_64133__$1;
(statearr_64154_64235[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (33))){
var inst_64020 = (state_64133[(18)]);
var state_64133__$1 = state_64133;
var statearr_64155_64236 = state_64133__$1;
(statearr_64155_64236[(2)] = inst_64020);

(statearr_64155_64236[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (13))){
var inst_64049 = (state_64133[(19)]);
var inst_64025 = (state_64133[(20)]);
var inst_64047 = (state_64133[(2)]);
var inst_64048 = cljs.core.volatile_BANG_((0));
var inst_64049__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_64025);
var state_64133__$1 = (function (){var statearr_64156 = state_64133;
(statearr_64156[(21)] = inst_64048);

(statearr_64156[(22)] = inst_64047);

(statearr_64156[(19)] = inst_64049__$1);

return statearr_64156;
})();
if(cljs.core.truth_(inst_64049__$1)){
var statearr_64157_64237 = state_64133__$1;
(statearr_64157_64237[(1)] = (14));

} else {
var statearr_64158_64238 = state_64133__$1;
(statearr_64158_64238[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (22))){
var inst_64070 = (state_64133[(2)]);
var state_64133__$1 = state_64133;
var statearr_64159_64239 = state_64133__$1;
(statearr_64159_64239[(2)] = inst_64070);

(statearr_64159_64239[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (36))){
var inst_64037 = (state_64133[(23)]);
var inst_64056 = (state_64133[(24)]);
var inst_64087 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_64056);
var inst_64088 = fluree.db.query.fql.query(inst_64037,inst_64087);
var state_64133__$1 = state_64133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64133__$1,(38),inst_64088);
} else {
if((state_val_64134 === (41))){
var inst_64126 = (state_64133[(2)]);
var state_64133__$1 = state_64133;
var statearr_64160_64240 = state_64133__$1;
(statearr_64160_64240[(2)] = inst_64126);

(statearr_64160_64240[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (43))){
var state_64133__$1 = state_64133;
var statearr_64161_64241 = state_64133__$1;
(statearr_64161_64241[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (29))){
var inst_64024 = (state_64133[(16)]);
var state_64133__$1 = state_64133;
if(cljs.core.truth_(inst_64024)){
var statearr_64163_64242 = state_64133__$1;
(statearr_64163_64242[(1)] = (32));

} else {
var statearr_64164_64243 = state_64133__$1;
(statearr_64164_64243[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (44))){
var inst_64124 = (state_64133[(2)]);
var state_64133__$1 = state_64133;
var statearr_64165_64244 = state_64133__$1;
(statearr_64165_64244[(2)] = inst_64124);

(statearr_64165_64244[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (6))){
var inst_64019 = (state_64133[(7)]);
var inst_64028 = (state_64133[(2)]);
var inst_64029 = fluree.db.util.async.throw_err(inst_64028);
var state_64133__$1 = (function (){var statearr_64166 = state_64133;
(statearr_64166[(8)] = inst_64029);

return statearr_64166;
})();
if(cljs.core.truth_(inst_64019)){
var statearr_64167_64245 = state_64133__$1;
(statearr_64167_64245[(1)] = (7));

} else {
var statearr_64168_64246 = state_64133__$1;
(statearr_64168_64246[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (28))){
var inst_64066 = (state_64133[(2)]);
var state_64133__$1 = state_64133;
var statearr_64169_64247 = state_64133__$1;
(statearr_64169_64247[(2)] = inst_64066);

(statearr_64169_64247[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (25))){
var inst_64068 = (state_64133[(2)]);
var state_64133__$1 = state_64133;
var statearr_64170_64248 = state_64133__$1;
(statearr_64170_64248[(2)] = inst_64068);

(statearr_64170_64248[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (34))){
var inst_64077 = (state_64133[(2)]);
var state_64133__$1 = state_64133;
var statearr_64171_64249 = state_64133__$1;
(statearr_64171_64249[(2)] = inst_64077);

(statearr_64171_64249[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (17))){
var inst_64018 = (state_64133[(25)]);
var state_64133__$1 = state_64133;
var statearr_64172_64250 = state_64133__$1;
(statearr_64172_64250[(2)] = inst_64018);

(statearr_64172_64250[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (3))){
var inst_64131 = (state_64133[(2)]);
var state_64133__$1 = state_64133;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64133__$1,inst_64131);
} else {
if((state_val_64134 === (12))){
var inst_64045 = cljs.core.PersistentHashMap.EMPTY;
var state_64133__$1 = state_64133;
var statearr_64173_64251 = state_64133__$1;
(statearr_64173_64251[(2)] = inst_64045);

(statearr_64173_64251[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (2))){
var inst_64016 = (state_64133[(26)]);
var _ = (function (){var statearr_64174 = state_64133;
(statearr_64174[(4)] = cljs.core.cons((5),(state_64133[(4)])));

return statearr_64174;
})();
var inst_64015 = query_map;
var inst_64016__$1 = cljs.core.__destructure_map(inst_64015);
var inst_64017 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64016__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_64018 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64016__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_64019 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64016__$1,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64020 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64016__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_64021 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64016__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_64022 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64016__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_64023 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64016__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_64024 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64016__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_64025 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64016__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_64026 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64016__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_64133__$1 = (function (){var statearr_64175 = state_64133;
(statearr_64175[(25)] = inst_64018);

(statearr_64175[(16)] = inst_64024);

(statearr_64175[(18)] = inst_64020);

(statearr_64175[(7)] = inst_64019);

(statearr_64175[(11)] = inst_64026);

(statearr_64175[(10)] = inst_64017);

(statearr_64175[(26)] = inst_64016__$1);

(statearr_64175[(27)] = inst_64021);

(statearr_64175[(9)] = inst_64023);

(statearr_64175[(20)] = inst_64025);

(statearr_64175[(14)] = inst_64022);

return statearr_64175;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64133__$1,(6),sources);
} else {
if((state_val_64134 === (23))){
var inst_64022 = (state_64133[(14)]);
var state_64133__$1 = state_64133;
var statearr_64176_64252 = state_64133__$1;
(statearr_64176_64252[(2)] = inst_64022);

(statearr_64176_64252[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (47))){
var inst_64092 = (state_64133[(28)]);
var inst_64018 = (state_64133[(25)]);
var inst_64024 = (state_64133[(16)]);
var inst_64048 = (state_64133[(21)]);
var inst_64037 = (state_64133[(23)]);
var inst_64020 = (state_64133[(18)]);
var inst_64019 = (state_64133[(7)]);
var inst_64026 = (state_64133[(11)]);
var inst_64017 = (state_64133[(10)]);
var inst_64102 = (state_64133[(29)]);
var inst_64016 = (state_64133[(26)]);
var inst_64053 = (state_64133[(30)]);
var inst_64080 = (state_64133[(15)]);
var inst_64029 = (state_64133[(8)]);
var inst_64038 = (state_64133[(31)]);
var inst_64021 = (state_64133[(27)]);
var inst_64047 = (state_64133[(22)]);
var inst_64055 = (state_64133[(32)]);
var inst_64023 = (state_64133[(9)]);
var inst_64091 = (state_64133[(12)]);
var inst_64054 = (state_64133[(17)]);
var inst_64056 = (state_64133[(24)]);
var inst_64022 = (state_64133[(14)]);
var inst_64108 = (state_64133[(2)]);
var inst_64109 = cljs.core.deref(inst_64048);
var inst_64110 = (function (){var error_QMARK_ = inst_64092;
var map__64014 = inst_64016;
var construct = inst_64017;
var valid_query_QMARK_ = inst_64080;
var conn = inst_64038;
var select = inst_64018;
var block = inst_64019;
var where = inst_64020;
var prefixes = inst_64021;
var db = inst_64029;
var meta_QMARK_ = inst_64054;
var source_opts = inst_64047;
var fuel = inst_64048;
var db_STAR_ = inst_64037;
var selectDistinct = inst_64022;
var result = inst_64091;
var start_ms = inst_64055;
var selectOne = inst_64023;
var from = inst_64024;
var max_fuel = inst_64053;
var opts = inst_64056;
var selectReduced = inst_64026;
return (function (p1__64001_SHARP_){
var G__64177 = "%.2fms";
var G__64178 = p1__64001_SHARP_;
return goog.string.format(G__64177,G__64178);
});
})();
var inst_64111 = fluree.db.util.core.current_time_millis();
var inst_64112 = (inst_64111 - inst_64055);
var inst_64113 = (inst_64112 / (1000000));
var inst_64114 = (inst_64110.cljs$core$IFn$_invoke$arity$1 ? inst_64110.cljs$core$IFn$_invoke$arity$1(inst_64113) : inst_64110.call(null,inst_64113));
var inst_64115 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64037);
var inst_64116 = [(200),inst_64108,inst_64109,inst_64114,inst_64115];
var inst_64117 = cljs.core.PersistentHashMap.fromArrays(inst_64102,inst_64116);
var state_64133__$1 = state_64133;
var statearr_64179_64253 = state_64133__$1;
(statearr_64179_64253[(2)] = inst_64117);

(statearr_64179_64253[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (35))){
var inst_64083 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64084 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64085 = cljs.core.PersistentHashMap.fromArrays(inst_64083,inst_64084);
var state_64133__$1 = state_64133;
var statearr_64180_64254 = state_64133__$1;
(statearr_64180_64254[(2)] = inst_64085);

(statearr_64180_64254[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (19))){
var inst_64072 = (state_64133[(33)]);
var inst_64072__$1 = (state_64133[(2)]);
var state_64133__$1 = (function (){var statearr_64181 = state_64133;
(statearr_64181[(33)] = inst_64072__$1);

return statearr_64181;
})();
if(cljs.core.truth_(inst_64072__$1)){
var statearr_64182_64255 = state_64133__$1;
(statearr_64182_64255[(1)] = (29));

} else {
var statearr_64183_64256 = state_64133__$1;
(statearr_64183_64256[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (11))){
var inst_64037 = (state_64133[(23)]);
var inst_64038 = (state_64133[(31)]);
var inst_64021 = (state_64133[(27)]);
var inst_64040 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_64037);
var inst_64041 = fluree.db.connection_js.open_api_QMARK_(inst_64038);
var inst_64042 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_64037);
var inst_64043 = fluree.db.api_js.get_sources(inst_64038,inst_64040,inst_64041,inst_64042,inst_64021,db_fn);
var state_64133__$1 = state_64133;
var statearr_64185_64257 = state_64133__$1;
(statearr_64185_64257[(2)] = inst_64043);

(statearr_64185_64257[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (9))){
var inst_64037 = (state_64133[(23)]);
var inst_64021 = (state_64133[(27)]);
var inst_64037__$1 = (state_64133[(2)]);
var inst_64038 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_64037__$1);
var state_64133__$1 = (function (){var statearr_64186 = state_64133;
(statearr_64186[(23)] = inst_64037__$1);

(statearr_64186[(31)] = inst_64038);

return statearr_64186;
})();
if(cljs.core.truth_(inst_64021)){
var statearr_64187_64258 = state_64133__$1;
(statearr_64187_64258[(1)] = (11));

} else {
var statearr_64188_64259 = state_64133__$1;
(statearr_64188_64259[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (5))){
var _ = (function (){var statearr_64189 = state_64133;
(statearr_64189[(4)] = cljs.core.rest((state_64133[(4)])));

return statearr_64189;
})();
var state_64133__$1 = state_64133;
var ex64184 = (state_64133__$1[(2)]);
var statearr_64190_64260 = state_64133__$1;
(statearr_64190_64260[(5)] = ex64184);


var statearr_64191_64261 = state_64133__$1;
(statearr_64191_64261[(1)] = (4));

(statearr_64191_64261[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (14))){
var inst_64049 = (state_64133[(19)]);
var state_64133__$1 = state_64133;
var statearr_64192_64262 = state_64133__$1;
(statearr_64192_64262[(2)] = inst_64049);

(statearr_64192_64262[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (45))){
var inst_64091 = (state_64133[(12)]);
var inst_64105 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_64091);
var state_64133__$1 = state_64133;
var statearr_64193_64263 = state_64133__$1;
(statearr_64193_64263[(2)] = inst_64105);

(statearr_64193_64263[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (26))){
var inst_64026 = (state_64133[(11)]);
var state_64133__$1 = state_64133;
var statearr_64194_64264 = state_64133__$1;
(statearr_64194_64264[(2)] = inst_64026);

(statearr_64194_64264[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (16))){
var inst_64018 = (state_64133[(25)]);
var inst_64048 = (state_64133[(21)]);
var inst_64053 = (state_64133[(30)]);
var inst_64047 = (state_64133[(22)]);
var inst_64025 = (state_64133[(20)]);
var inst_64053__$1 = (state_64133[(2)]);
var inst_64054 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_64025);
var inst_64055 = fluree.db.util.core.current_time_millis();
var inst_64056 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64025,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_64047,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_64053__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64048], 0));
var state_64133__$1 = (function (){var statearr_64195 = state_64133;
(statearr_64195[(30)] = inst_64053__$1);

(statearr_64195[(32)] = inst_64055);

(statearr_64195[(17)] = inst_64054);

(statearr_64195[(24)] = inst_64056);

return statearr_64195;
})();
if(cljs.core.truth_(inst_64018)){
var statearr_64196_64265 = state_64133__$1;
(statearr_64196_64265[(1)] = (17));

} else {
var statearr_64197_64266 = state_64133__$1;
(statearr_64197_64266[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (38))){
var inst_64092 = (state_64133[(28)]);
var inst_64091 = (state_64133[(12)]);
var inst_64090 = (state_64133[(2)]);
var inst_64091__$1 = fluree.db.util.async.throw_err(inst_64090);
var inst_64092__$1 = (inst_64091__$1 instanceof cljs.core.ExceptionInfo);
var state_64133__$1 = (function (){var statearr_64198 = state_64133;
(statearr_64198[(28)] = inst_64092__$1);

(statearr_64198[(12)] = inst_64091__$1);

return statearr_64198;
})();
if(cljs.core.truth_(inst_64092__$1)){
var statearr_64199_64267 = state_64133__$1;
(statearr_64199_64267[(1)] = (39));

} else {
var statearr_64200_64268 = state_64133__$1;
(statearr_64200_64268[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (30))){
var inst_64072 = (state_64133[(33)]);
var state_64133__$1 = state_64133;
var statearr_64201_64269 = state_64133__$1;
(statearr_64201_64269[(2)] = inst_64072);

(statearr_64201_64269[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (10))){
var inst_64033 = (state_64133[(2)]);
var inst_64034 = fluree.db.util.async.throw_err(inst_64033);
var state_64133__$1 = state_64133;
var statearr_64202_64270 = state_64133__$1;
(statearr_64202_64270[(2)] = inst_64034);

(statearr_64202_64270[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (18))){
var inst_64023 = (state_64133[(9)]);
var state_64133__$1 = state_64133;
if(cljs.core.truth_(inst_64023)){
var statearr_64203_64271 = state_64133__$1;
(statearr_64203_64271[(1)] = (20));

} else {
var statearr_64204_64272 = state_64133__$1;
(statearr_64204_64272[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (42))){
var inst_64091 = (state_64133[(12)]);
var inst_64102 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_64103 = cljs.core.sequential_QMARK_(inst_64091);
var state_64133__$1 = (function (){var statearr_64205 = state_64133;
(statearr_64205[(29)] = inst_64102);

return statearr_64205;
})();
if(inst_64103){
var statearr_64206_64273 = state_64133__$1;
(statearr_64206_64273[(1)] = (45));

} else {
var statearr_64207_64274 = state_64133__$1;
(statearr_64207_64274[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (37))){
var inst_64128 = (state_64133[(2)]);
var _ = (function (){var statearr_64208 = state_64133;
(statearr_64208[(4)] = cljs.core.rest((state_64133[(4)])));

return statearr_64208;
})();
var state_64133__$1 = state_64133;
var statearr_64209_64275 = state_64133__$1;
(statearr_64209_64275[(2)] = inst_64128);

(statearr_64209_64275[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (8))){
var inst_64029 = (state_64133[(8)]);
var state_64133__$1 = state_64133;
var statearr_64210_64276 = state_64133__$1;
(statearr_64210_64276[(2)] = inst_64029);

(statearr_64210_64276[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (49))){
var state_64133__$1 = state_64133;
var statearr_64211_64277 = state_64133__$1;
(statearr_64211_64277[(2)] = null);

(statearr_64211_64277[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_64212 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64212[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_64212[(1)] = (1));

return statearr_64212;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_64133){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64133);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64213){var ex__2736__auto__ = e64213;
var statearr_64214_64278 = state_64133;
(statearr_64214_64278[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64133[(4)]))){
var statearr_64215_64279 = state_64133;
(statearr_64215_64279[(1)] = cljs.core.first((state_64133[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64280 = state_64133;
state_64133 = G__64280;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_64133){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_64133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64216 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64216[(6)] = c__2755__auto__);

return statearr_64216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__64281_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__64281_SHARP_);
}));

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64303){
var state_val_64304 = (state_64303[(1)]);
if((state_val_64304 === (1))){
var inst_64285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64286 = [resp_chan,timeout_chan];
var inst_64287 = (new cljs.core.PersistentVector(null,2,(5),inst_64285,inst_64286,null));
var state_64303__$1 = state_64303;
return cljs.core.async.ioc_alts_BANG_(state_64303__$1,(2),inst_64287);
} else {
if((state_val_64304 === (2))){
var inst_64289 = (state_64303[(2)]);
var inst_64290 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64289,(0),null);
var inst_64291 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64289,(1),null);
var inst_64292 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_64291);
var state_64303__$1 = (function (){var statearr_64305 = state_64303;
(statearr_64305[(7)] = inst_64290);

return statearr_64305;
})();
if(inst_64292){
var statearr_64306_64316 = state_64303__$1;
(statearr_64306_64316[(1)] = (3));

} else {
var statearr_64307_64317 = state_64303__$1;
(statearr_64307_64317[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64304 === (3))){
var inst_64294 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_64295 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64296 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_64297 = [tid,(408),inst_64296];
var inst_64298 = cljs.core.PersistentHashMap.fromArrays(inst_64295,inst_64297);
var state_64303__$1 = (function (){var statearr_64308 = state_64303;
(statearr_64308[(8)] = inst_64294);

return statearr_64308;
})();
var statearr_64309_64318 = state_64303__$1;
(statearr_64309_64318[(2)] = inst_64298);

(statearr_64309_64318[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64304 === (4))){
var inst_64290 = (state_64303[(7)]);
var state_64303__$1 = state_64303;
var statearr_64310_64319 = state_64303__$1;
(statearr_64310_64319[(2)] = inst_64290);

(statearr_64310_64319[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64304 === (5))){
var inst_64301 = (state_64303[(2)]);
var state_64303__$1 = state_64303;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64303__$1,inst_64301);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2733__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2733__auto____0 = (function (){
var statearr_64311 = [null,null,null,null,null,null,null,null,null];
(statearr_64311[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2733__auto__);

(statearr_64311[(1)] = (1));

return statearr_64311;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2733__auto____1 = (function (state_64303){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64303);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64312){var ex__2736__auto__ = e64312;
var statearr_64313_64320 = state_64303;
(statearr_64313_64320[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64303[(4)]))){
var statearr_64314_64321 = state_64303;
(statearr_64314_64321[(1)] = cljs.core.first((state_64303[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64322 = state_64303;
state_64303 = G__64322;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2733__auto__ = function(state_64303){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2733__auto____1.call(this,state_64303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2733__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2733__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64315 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64315[(6)] = c__2755__auto__);

return statearr_64315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__64324 = arguments.length;
switch (G__64324) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__64325 = opts;
var map__64325__$1 = cljs.core.__destructure_map(map__64325);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64325__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64325__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64325__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64325__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__64326 = (cljs.core.truth_((function (){var and__4221__auto__ = auth;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4221__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64326,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64326,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4223__auto__ = nonce;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4223__auto__ = expire;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e64329){var e = e64329;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__64332 = arguments.length;
switch (G__64332) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64398){
var state_val_64399 = (state_64398[(1)]);
if((state_val_64399 === (7))){
var inst_64354 = (state_64398[(7)]);
var inst_64351 = (state_64398[(8)]);
var inst_64353 = (state_64398[(9)]);
var inst_64352 = (state_64398[(10)]);
var inst_64349 = (state_64398[(11)]);
var inst_64367 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_64368 = [ledger,txn,inst_64349,inst_64351,inst_64352,inst_64353,inst_64354];
var inst_64369 = cljs.core.PersistentHashMap.fromArrays(inst_64367,inst_64368);
var inst_64370 = fluree.db.util.core.without_nils(inst_64369);
var inst_64371 = fluree.db.operations.transact_async(conn,inst_64370);
var state_64398__$1 = state_64398;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64398__$1,(13),inst_64371);
} else {
if((state_val_64399 === (20))){
var inst_64389 = (state_64398[(2)]);
var state_64398__$1 = state_64398;
var statearr_64400_64436 = state_64398__$1;
(statearr_64400_64436[(2)] = inst_64389);

(statearr_64400_64436[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (1))){
var state_64398__$1 = state_64398;
var statearr_64401_64437 = state_64398__$1;
(statearr_64401_64437[(2)] = null);

(statearr_64401_64437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (4))){
var inst_64333 = (state_64398[(2)]);
var inst_64334 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64333], 0));
var inst_64335 = cljs.core.ex_data(inst_64333);
var inst_64336 = cljs.core.ex_message(inst_64333);
var inst_64337 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64335,new cljs.core.Keyword(null,"message","message",-406056002),inst_64336);
var state_64398__$1 = (function (){var statearr_64402 = state_64398;
(statearr_64402[(12)] = inst_64334);

return statearr_64402;
})();
var statearr_64403_64438 = state_64398__$1;
(statearr_64403_64438[(2)] = inst_64337);

(statearr_64403_64438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (15))){
var inst_64348 = (state_64398[(13)]);
var inst_64373 = (state_64398[(14)]);
var inst_64376 = fluree.db.api_js.monitor_tx(conn,ledger,inst_64373,inst_64348);
var state_64398__$1 = state_64398;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64398__$1,(17),inst_64376);
} else {
if((state_val_64399 === (13))){
var inst_64347 = (state_64398[(15)]);
var inst_64373 = (state_64398[(2)]);
var state_64398__$1 = (function (){var statearr_64404 = state_64398;
(statearr_64404[(14)] = inst_64373);

return statearr_64404;
})();
if(cljs.core.truth_(inst_64347)){
var statearr_64405_64439 = state_64398__$1;
(statearr_64405_64439[(1)] = (14));

} else {
var statearr_64406_64440 = state_64398__$1;
(statearr_64406_64440[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (6))){
var inst_64347 = (state_64398[(15)]);
var inst_64346 = (state_64398[(16)]);
var inst_64356 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_64346,opts);
var inst_64357 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_64356);
var inst_64358 = fluree.db.operations.command_async(conn,inst_64356);
var state_64398__$1 = (function (){var statearr_64407 = state_64398;
(statearr_64407[(17)] = inst_64358);

(statearr_64407[(18)] = inst_64357);

return statearr_64407;
})();
if(cljs.core.truth_(inst_64347)){
var statearr_64408_64441 = state_64398__$1;
(statearr_64408_64441[(1)] = (9));

} else {
var statearr_64409_64442 = state_64398__$1;
(statearr_64409_64442[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (17))){
var inst_64378 = (state_64398[(19)]);
var inst_64378__$1 = (state_64398[(2)]);
var inst_64379 = (inst_64378__$1 instanceof cljs.core.ExceptionInfo);
var state_64398__$1 = (function (){var statearr_64410 = state_64398;
(statearr_64410[(19)] = inst_64378__$1);

return statearr_64410;
})();
if(cljs.core.truth_(inst_64379)){
var statearr_64411_64443 = state_64398__$1;
(statearr_64411_64443[(1)] = (18));

} else {
var statearr_64412_64444 = state_64398__$1;
(statearr_64412_64444[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (3))){
var inst_64396 = (state_64398[(2)]);
var state_64398__$1 = state_64398;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64398__$1,inst_64396);
} else {
if((state_val_64399 === (12))){
var inst_64363 = (state_64398[(2)]);
var state_64398__$1 = state_64398;
var statearr_64413_64445 = state_64398__$1;
(statearr_64413_64445[(2)] = inst_64363);

(statearr_64413_64445[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (2))){
var inst_64346 = (state_64398[(16)]);
var _ = (function (){var statearr_64414 = state_64398;
(statearr_64414[(4)] = cljs.core.cons((5),(state_64398[(4)])));

return statearr_64414;
})();
var inst_64344 = opts;
var inst_64345 = cljs.core.__destructure_map(inst_64344);
var inst_64346__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64345,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_64347 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64345,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_64348 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_64345,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_64349 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64345,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_64350 = fluree.db.util.core.current_time_millis();
var inst_64351 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_64345,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_64350);
var inst_64352 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64345,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_64353 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64345,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_64354 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64345,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_64398__$1 = (function (){var statearr_64415 = state_64398;
(statearr_64415[(7)] = inst_64354);

(statearr_64415[(15)] = inst_64347);

(statearr_64415[(13)] = inst_64348);

(statearr_64415[(8)] = inst_64351);

(statearr_64415[(9)] = inst_64353);

(statearr_64415[(10)] = inst_64352);

(statearr_64415[(16)] = inst_64346__$1);

(statearr_64415[(11)] = inst_64349);

return statearr_64415;
})();
if(cljs.core.truth_(inst_64346__$1)){
var statearr_64416_64446 = state_64398__$1;
(statearr_64416_64446[(1)] = (6));

} else {
var statearr_64417_64447 = state_64398__$1;
(statearr_64417_64447[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (19))){
var inst_64378 = (state_64398[(19)]);
var state_64398__$1 = state_64398;
var statearr_64418_64448 = state_64398__$1;
(statearr_64418_64448[(2)] = inst_64378);

(statearr_64418_64448[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (11))){
var inst_64365 = (state_64398[(2)]);
var state_64398__$1 = state_64398;
var statearr_64420_64449 = state_64398__$1;
(statearr_64420_64449[(2)] = inst_64365);

(statearr_64420_64449[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (9))){
var inst_64358 = (state_64398[(17)]);
var state_64398__$1 = state_64398;
var statearr_64421_64450 = state_64398__$1;
(statearr_64421_64450[(2)] = inst_64358);

(statearr_64421_64450[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (5))){
var _ = (function (){var statearr_64422 = state_64398;
(statearr_64422[(4)] = cljs.core.rest((state_64398[(4)])));

return statearr_64422;
})();
var state_64398__$1 = state_64398;
var ex64419 = (state_64398__$1[(2)]);
var statearr_64423_64451 = state_64398__$1;
(statearr_64423_64451[(5)] = ex64419);


var statearr_64424_64452 = state_64398__$1;
(statearr_64424_64452[(1)] = (4));

(statearr_64424_64452[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (14))){
var inst_64373 = (state_64398[(14)]);
var state_64398__$1 = state_64398;
var statearr_64425_64453 = state_64398__$1;
(statearr_64425_64453[(2)] = inst_64373);

(statearr_64425_64453[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (16))){
var inst_64391 = (state_64398[(2)]);
var state_64398__$1 = state_64398;
var statearr_64426_64454 = state_64398__$1;
(statearr_64426_64454[(2)] = inst_64391);

(statearr_64426_64454[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (10))){
var inst_64348 = (state_64398[(13)]);
var inst_64357 = (state_64398[(18)]);
var inst_64361 = fluree.db.api_js.monitor_tx(conn,ledger,inst_64357,inst_64348);
var state_64398__$1 = state_64398;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64398__$1,(12),inst_64361);
} else {
if((state_val_64399 === (18))){
var inst_64378 = (state_64398[(19)]);
var inst_64381 = cljs.core.ex_data(inst_64378);
var inst_64382 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64383 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_64381);
var inst_64384 = cljs.core.ex_message(inst_64378);
var inst_64385 = [inst_64383,inst_64384,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_64386 = cljs.core.PersistentHashMap.fromArrays(inst_64382,inst_64385);
var state_64398__$1 = state_64398;
var statearr_64427_64455 = state_64398__$1;
(statearr_64427_64455[(2)] = inst_64386);

(statearr_64427_64455[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64399 === (8))){
var inst_64393 = (state_64398[(2)]);
var _ = (function (){var statearr_64428 = state_64398;
(statearr_64428[(4)] = cljs.core.rest((state_64398[(4)])));

return statearr_64428;
})();
var state_64398__$1 = state_64398;
var statearr_64429_64456 = state_64398__$1;
(statearr_64429_64456[(2)] = inst_64393);

(statearr_64429_64456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_64430 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64430[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_64430[(1)] = (1));

return statearr_64430;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_64398){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64398);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64431){var ex__2736__auto__ = e64431;
var statearr_64432_64457 = state_64398;
(statearr_64432_64457[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64398[(4)]))){
var statearr_64433_64458 = state_64398;
(statearr_64433_64458[(1)] = cljs.core.first((state_64398[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64459 = state_64398;
state_64398 = G__64459;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_64398){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_64398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64434 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64434[(6)] = c__2755__auto__);

return statearr_64434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4835__auto__ = [];
var len__4829__auto___64461 = arguments.length;
var i__4830__auto___64462 = (0);
while(true){
if((i__4830__auto___64462 < len__4829__auto___64461)){
args__4835__auto__.push((arguments[i__4830__auto___64462]));

var G__64463 = (i__4830__auto___64462 + (1));
i__4830__auto___64462 = G__64463;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq64460){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq64460));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64494){
var state_val_64495 = (state_64494[(1)]);
if((state_val_64495 === (1))){
var inst_64464 = cljs.core.first(flakes);
var inst_64465 = cljs.core.rest(flakes);
var inst_64466 = cljs.core.PersistentVector.EMPTY;
var inst_64467 = inst_64464;
var inst_64468 = inst_64465;
var inst_64469 = inst_64466;
var state_64494__$1 = (function (){var statearr_64496 = state_64494;
(statearr_64496[(7)] = inst_64468);

(statearr_64496[(8)] = inst_64469);

(statearr_64496[(9)] = inst_64467);

return statearr_64496;
})();
var statearr_64497_64510 = state_64494__$1;
(statearr_64497_64510[(2)] = null);

(statearr_64497_64510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (2))){
var inst_64467 = (state_64494[(9)]);
var inst_64471 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_64472 = cljs.core.PersistentHashMap.EMPTY;
var inst_64473 = [true,inst_64472];
var inst_64474 = cljs.core.PersistentHashMap.fromArrays(inst_64471,inst_64473);
var inst_64475 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_64474,inst_64467);
var state_64494__$1 = state_64494;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64494__$1,(4),inst_64475);
} else {
if((state_val_64495 === (3))){
var inst_64492 = (state_64494[(2)]);
var state_64494__$1 = state_64494;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64494__$1,inst_64492);
} else {
if((state_val_64495 === (4))){
var inst_64468 = (state_64494[(7)]);
var inst_64469 = (state_64494[(8)]);
var inst_64477 = (state_64494[(2)]);
var inst_64478 = fluree.db.util.async.throw_err(inst_64477);
var inst_64479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64480 = [inst_64478];
var inst_64481 = (new cljs.core.PersistentVector(null,1,(5),inst_64479,inst_64480,null));
var inst_64482 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_64469,inst_64481);
var inst_64483 = cljs.core.first(inst_64468);
var state_64494__$1 = (function (){var statearr_64498 = state_64494;
(statearr_64498[(10)] = inst_64482);

return statearr_64498;
})();
if(cljs.core.truth_(inst_64483)){
var statearr_64499_64511 = state_64494__$1;
(statearr_64499_64511[(1)] = (5));

} else {
var statearr_64500_64512 = state_64494__$1;
(statearr_64500_64512[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (5))){
var inst_64468 = (state_64494[(7)]);
var inst_64482 = (state_64494[(10)]);
var inst_64485 = cljs.core.first(inst_64468);
var inst_64486 = cljs.core.rest(inst_64468);
var inst_64467 = inst_64485;
var inst_64468__$1 = inst_64486;
var inst_64469 = inst_64482;
var state_64494__$1 = (function (){var statearr_64501 = state_64494;
(statearr_64501[(7)] = inst_64468__$1);

(statearr_64501[(8)] = inst_64469);

(statearr_64501[(9)] = inst_64467);

return statearr_64501;
})();
var statearr_64502_64513 = state_64494__$1;
(statearr_64502_64513[(2)] = null);

(statearr_64502_64513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (6))){
var inst_64482 = (state_64494[(10)]);
var state_64494__$1 = state_64494;
var statearr_64503_64514 = state_64494__$1;
(statearr_64503_64514[(2)] = inst_64482);

(statearr_64503_64514[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64495 === (7))){
var inst_64490 = (state_64494[(2)]);
var state_64494__$1 = state_64494;
var statearr_64504_64515 = state_64494__$1;
(statearr_64504_64515[(2)] = inst_64490);

(statearr_64504_64515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto____0 = (function (){
var statearr_64505 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64505[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto__);

(statearr_64505[(1)] = (1));

return statearr_64505;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto____1 = (function (state_64494){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64494);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64506){var ex__2736__auto__ = e64506;
var statearr_64507_64516 = state_64494;
(statearr_64507_64516[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64494[(4)]))){
var statearr_64508_64517 = state_64494;
(statearr_64508_64517[(1)] = cljs.core.first((state_64494[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64518 = state_64494;
state_64494 = G__64518;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto__ = function(state_64494){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto____1.call(this,state_64494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64509 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64509[(6)] = c__2755__auto__);

return statearr_64509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64586){
var state_val_64587 = (state_64586[(1)]);
if((state_val_64587 === (7))){
var inst_64546 = (state_64586[(2)]);
var inst_64547 = fluree.db.util.async.throw_err(inst_64546);
var state_64586__$1 = state_64586;
var statearr_64588_64614 = state_64586__$1;
(statearr_64588_64614[(2)] = inst_64547);

(statearr_64588_64614[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64587 === (1))){
var inst_64523 = cljs.core.volatile_BANG_((0));
var inst_64524 = cljs.core.PersistentHashMap.EMPTY;
var inst_64525 = cljs.core.volatile_BANG_(inst_64524);
var inst_64526 = cljs.core.first(resp);
var inst_64527 = cljs.core.rest(resp);
var inst_64528 = cljs.core.PersistentVector.EMPTY;
var inst_64529 = inst_64523;
var inst_64530 = inst_64525;
var inst_64531 = inst_64526;
var inst_64532 = inst_64527;
var inst_64533 = inst_64528;
var state_64586__$1 = (function (){var statearr_64589 = state_64586;
(statearr_64589[(7)] = inst_64529);

(statearr_64589[(8)] = inst_64531);

(statearr_64589[(9)] = inst_64532);

(statearr_64589[(10)] = inst_64533);

(statearr_64589[(11)] = inst_64530);

return statearr_64589;
})();
var statearr_64590_64615 = state_64586__$1;
(statearr_64590_64615[(2)] = null);

(statearr_64590_64615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64587 === (4))){
var inst_64529 = (state_64586[(7)]);
var inst_64531 = (state_64586[(8)]);
var inst_64532 = (state_64586[(9)]);
var inst_64535 = (state_64586[(12)]);
var inst_64537 = (state_64586[(13)]);
var inst_64533 = (state_64586[(10)]);
var inst_64530 = (state_64586[(11)]);
var inst_64541 = (function (){var fuel = inst_64529;
var cache = inst_64530;
var curr_block = inst_64531;
var rest_blocks = inst_64532;
var acc = inst_64533;
var flakes = inst_64535;
var asserted = inst_64537;
return (function (p1__64520_SHARP_){
return p1__64520_SHARP_.s;
});
})();
var inst_64542 = cljs.core.group_by(inst_64541,inst_64537);
var inst_64543 = cljs.core.vals(inst_64542);
var inst_64544 = fluree.db.api_js.format_flake_groups_pretty(db,inst_64530,inst_64529,inst_64543);
var state_64586__$1 = state_64586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64586__$1,(7),inst_64544);
} else {
if((state_val_64587 === (13))){
var inst_64574 = (state_64586[(14)]);
var state_64586__$1 = state_64586;
var statearr_64591_64616 = state_64586__$1;
(statearr_64591_64616[(2)] = inst_64574);

(statearr_64591_64616[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64587 === (6))){
var inst_64529 = (state_64586[(7)]);
var inst_64531 = (state_64586[(8)]);
var inst_64532 = (state_64586[(9)]);
var inst_64535 = (state_64586[(12)]);
var inst_64550 = (state_64586[(15)]);
var inst_64552 = (state_64586[(16)]);
var inst_64537 = (state_64586[(13)]);
var inst_64533 = (state_64586[(10)]);
var inst_64530 = (state_64586[(11)]);
var inst_64550__$1 = (state_64586[(2)]);
var inst_64551 = (function (){var fuel = inst_64529;
var cache = inst_64530;
var curr_block = inst_64531;
var rest_blocks = inst_64532;
var acc = inst_64533;
var flakes = inst_64535;
var asserted = inst_64537;
var asserted_SINGLEQUOTE_ = inst_64550__$1;
return (function (p1__64521_SHARP_){
return p1__64521_SHARP_.op === false;
});
})();
var inst_64552__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_64551,inst_64535);
var inst_64553 = cljs.core.empty_QMARK_(inst_64552__$1);
var inst_64554 = (!(inst_64553));
var state_64586__$1 = (function (){var statearr_64594 = state_64586;
(statearr_64594[(15)] = inst_64550__$1);

(statearr_64594[(16)] = inst_64552__$1);

return statearr_64594;
})();
if(inst_64554){
var statearr_64595_64617 = state_64586__$1;
(statearr_64595_64617[(1)] = (8));

} else {
var statearr_64596_64618 = state_64586__$1;
(statearr_64596_64618[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64587 === (3))){
var inst_64584 = (state_64586[(2)]);
var state_64586__$1 = state_64586;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64586__$1,inst_64584);
} else {
if((state_val_64587 === (12))){
var inst_64574 = (state_64586[(14)]);
var inst_64529 = (state_64586[(7)]);
var inst_64532 = (state_64586[(9)]);
var inst_64530 = (state_64586[(11)]);
var inst_64577 = cljs.core.first(inst_64532);
var inst_64578 = cljs.core.rest(inst_64532);
var tmp64592 = inst_64529;
var tmp64593 = inst_64530;
var inst_64529__$1 = tmp64592;
var inst_64530__$1 = tmp64593;
var inst_64531 = inst_64577;
var inst_64532__$1 = inst_64578;
var inst_64533 = inst_64574;
var state_64586__$1 = (function (){var statearr_64597 = state_64586;
(statearr_64597[(7)] = inst_64529__$1);

(statearr_64597[(8)] = inst_64531);

(statearr_64597[(9)] = inst_64532__$1);

(statearr_64597[(10)] = inst_64533);

(statearr_64597[(11)] = inst_64530__$1);

return statearr_64597;
})();
var statearr_64598_64619 = state_64586__$1;
(statearr_64598_64619[(2)] = null);

(statearr_64598_64619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64587 === (2))){
var inst_64529 = (state_64586[(7)]);
var inst_64531 = (state_64586[(8)]);
var inst_64532 = (state_64586[(9)]);
var inst_64535 = (state_64586[(12)]);
var inst_64537 = (state_64586[(13)]);
var inst_64533 = (state_64586[(10)]);
var inst_64530 = (state_64586[(11)]);
var inst_64535__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_64531);
var inst_64536 = (function (){var fuel = inst_64529;
var cache = inst_64530;
var curr_block = inst_64531;
var rest_blocks = inst_64532;
var acc = inst_64533;
var flakes = inst_64535__$1;
return (function (p1__64519_SHARP_){
return p1__64519_SHARP_.op;
});
})();
var inst_64537__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_64536,inst_64535__$1);
var inst_64538 = cljs.core.empty_QMARK_(inst_64537__$1);
var inst_64539 = (!(inst_64538));
var state_64586__$1 = (function (){var statearr_64599 = state_64586;
(statearr_64599[(12)] = inst_64535__$1);

(statearr_64599[(13)] = inst_64537__$1);

return statearr_64599;
})();
if(inst_64539){
var statearr_64600_64620 = state_64586__$1;
(statearr_64600_64620[(1)] = (4));

} else {
var statearr_64601_64621 = state_64586__$1;
(statearr_64601_64621[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64587 === (11))){
var inst_64562 = (state_64586[(2)]);
var inst_64563 = fluree.db.util.async.throw_err(inst_64562);
var state_64586__$1 = state_64586;
var statearr_64602_64622 = state_64586__$1;
(statearr_64602_64622[(2)] = inst_64563);

(statearr_64602_64622[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64587 === (9))){
var state_64586__$1 = state_64586;
var statearr_64603_64623 = state_64586__$1;
(statearr_64603_64623[(2)] = null);

(statearr_64603_64623[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64587 === (5))){
var state_64586__$1 = state_64586;
var statearr_64604_64624 = state_64586__$1;
(statearr_64604_64624[(2)] = null);

(statearr_64604_64624[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64587 === (14))){
var inst_64582 = (state_64586[(2)]);
var state_64586__$1 = state_64586;
var statearr_64605_64625 = state_64586__$1;
(statearr_64605_64625[(2)] = inst_64582);

(statearr_64605_64625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64587 === (10))){
var inst_64531 = (state_64586[(8)]);
var inst_64532 = (state_64586[(9)]);
var inst_64550 = (state_64586[(15)]);
var inst_64533 = (state_64586[(10)]);
var inst_64566 = (state_64586[(2)]);
var inst_64567 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_64568 = [inst_64550,inst_64566];
var inst_64569 = cljs.core.PersistentHashMap.fromArrays(inst_64567,inst_64568);
var inst_64570 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64531,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_64569);
var inst_64571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64572 = [inst_64570];
var inst_64573 = (new cljs.core.PersistentVector(null,1,(5),inst_64571,inst_64572,null));
var inst_64574 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_64533,inst_64573);
var inst_64575 = cljs.core.first(inst_64532);
var state_64586__$1 = (function (){var statearr_64606 = state_64586;
(statearr_64606[(14)] = inst_64574);

return statearr_64606;
})();
if(cljs.core.truth_(inst_64575)){
var statearr_64607_64626 = state_64586__$1;
(statearr_64607_64626[(1)] = (12));

} else {
var statearr_64608_64627 = state_64586__$1;
(statearr_64608_64627[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64587 === (8))){
var inst_64529 = (state_64586[(7)]);
var inst_64531 = (state_64586[(8)]);
var inst_64532 = (state_64586[(9)]);
var inst_64535 = (state_64586[(12)]);
var inst_64550 = (state_64586[(15)]);
var inst_64552 = (state_64586[(16)]);
var inst_64537 = (state_64586[(13)]);
var inst_64533 = (state_64586[(10)]);
var inst_64530 = (state_64586[(11)]);
var inst_64556 = (function (){var flakes = inst_64535;
var rest_blocks = inst_64532;
var curr_block = inst_64531;
var asserted_SINGLEQUOTE_ = inst_64550;
var acc = inst_64533;
var fuel = inst_64529;
var cache = inst_64530;
var retracted = inst_64552;
var asserted = inst_64537;
return (function (p1__64522_SHARP_){
return p1__64522_SHARP_.s;
});
})();
var inst_64557 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_64552);
var inst_64558 = cljs.core.group_by(inst_64556,inst_64557);
var inst_64559 = cljs.core.vals(inst_64558);
var inst_64560 = fluree.db.api_js.format_flake_groups_pretty(db,inst_64530,inst_64529,inst_64559);
var state_64586__$1 = state_64586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64586__$1,(11),inst_64560);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto____0 = (function (){
var statearr_64609 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64609[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto__);

(statearr_64609[(1)] = (1));

return statearr_64609;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto____1 = (function (state_64586){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64586);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64610){var ex__2736__auto__ = e64610;
var statearr_64611_64628 = state_64586;
(statearr_64611_64628[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64586[(4)]))){
var statearr_64612_64629 = state_64586;
(statearr_64612_64629[(1)] = cljs.core.first((state_64586[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64630 = state_64586;
state_64586 = G__64630;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto__ = function(state_64586){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto____1.call(this,state_64586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64613 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64613[(6)] = c__2755__auto__);

return statearr_64613;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64730){
var state_val_64731 = (state_64730[(1)]);
if((state_val_64731 === (7))){
var inst_64702 = (state_64730[(7)]);
var inst_64695 = (state_64730[(8)]);
var inst_64701 = cljs.core.seq(inst_64695);
var inst_64702__$1 = cljs.core.first(inst_64701);
var inst_64703 = cljs.core.next(inst_64701);
var state_64730__$1 = (function (){var statearr_64732 = state_64730;
(statearr_64732[(7)] = inst_64702__$1);

(statearr_64732[(9)] = inst_64703);

return statearr_64732;
})();
if(cljs.core.truth_(inst_64702__$1)){
var statearr_64733_64770 = state_64730__$1;
(statearr_64733_64770[(1)] = (9));

} else {
var statearr_64734_64771 = state_64730__$1;
(statearr_64734_64771[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64731 === (1))){
var state_64730__$1 = state_64730;
var statearr_64735_64772 = state_64730__$1;
(statearr_64735_64772[(2)] = null);

(statearr_64735_64772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64731 === (4))){
var inst_64632 = (state_64730[(2)]);
var state_64730__$1 = state_64730;
var statearr_64736_64773 = state_64730__$1;
(statearr_64736_64773[(2)] = inst_64632);

(statearr_64736_64773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64731 === (6))){
var inst_64681 = (state_64730[(2)]);
var inst_64682 = fluree.db.util.async.throw_err(inst_64681);
var inst_64690 = resp;
var inst_64691 = cljs.core.seq(inst_64690);
var inst_64692 = cljs.core.first(inst_64691);
var inst_64693 = cljs.core.next(inst_64691);
var inst_64694 = cljs.core.PersistentHashMap.EMPTY;
var inst_64695 = inst_64690;
var inst_64696 = inst_64694;
var state_64730__$1 = (function (){var statearr_64737 = state_64730;
(statearr_64737[(8)] = inst_64695);

(statearr_64737[(10)] = inst_64693);

(statearr_64737[(11)] = inst_64696);

(statearr_64737[(12)] = inst_64692);

(statearr_64737[(13)] = inst_64682);

return statearr_64737;
})();
var statearr_64738_64774 = state_64730__$1;
(statearr_64738_64774[(2)] = null);

(statearr_64738_64774[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64731 === (3))){
var inst_64728 = (state_64730[(2)]);
var state_64730__$1 = state_64730;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64730__$1,inst_64728);
} else {
if((state_val_64731 === (2))){
var _ = (function (){var statearr_64739 = state_64730;
(statearr_64739[(4)] = cljs.core.cons((5),(state_64730[(4)])));

return statearr_64739;
})();
var inst_64638 = (function (){return (function (p1__64631_SHARP_){
return p1__64631_SHARP_.t;
});
})();
var inst_64639 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_64638,resp);
var inst_64640 = cljs.core.set(inst_64639);
var inst_64677 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_64678 = (function (){var ts = inst_64640;
var c__2755__auto____$1 = inst_64677;
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64675){
var state_val_64676 = (state_64675[(1)]);
if((state_val_64676 === (1))){
var inst_64648 = ts;
var inst_64649 = cljs.core.seq(inst_64648);
var inst_64650 = cljs.core.first(inst_64649);
var inst_64651 = cljs.core.next(inst_64649);
var inst_64652 = cljs.core.PersistentHashMap.EMPTY;
var inst_64653 = inst_64648;
var inst_64654 = inst_64652;
var state_64675__$1 = (function (){var statearr_64740 = state_64675;
(statearr_64740[(7)] = inst_64654);

(statearr_64740[(8)] = inst_64650);

(statearr_64740[(9)] = inst_64653);

(statearr_64740[(10)] = inst_64651);

return statearr_64740;
})();
var statearr_64741_64775 = state_64675__$1;
(statearr_64741_64775[(2)] = null);

(statearr_64741_64775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64676 === (2))){
var inst_64660 = (state_64675[(11)]);
var inst_64653 = (state_64675[(9)]);
var inst_64659 = cljs.core.seq(inst_64653);
var inst_64660__$1 = cljs.core.first(inst_64659);
var inst_64661 = cljs.core.next(inst_64659);
var state_64675__$1 = (function (){var statearr_64742 = state_64675;
(statearr_64742[(12)] = inst_64661);

(statearr_64742[(11)] = inst_64660__$1);

return statearr_64742;
})();
if(cljs.core.truth_(inst_64660__$1)){
var statearr_64743_64776 = state_64675__$1;
(statearr_64743_64776[(1)] = (4));

} else {
var statearr_64744_64777 = state_64675__$1;
(statearr_64744_64777[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64676 === (3))){
var inst_64673 = (state_64675[(2)]);
var state_64675__$1 = state_64675;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64675__$1,inst_64673);
} else {
if((state_val_64676 === (4))){
var inst_64660 = (state_64675[(11)]);
var inst_64663 = fluree.db.time_travel.non_border_t_to_block(db,inst_64660);
var state_64675__$1 = state_64675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64675__$1,(7),inst_64663);
} else {
if((state_val_64676 === (5))){
var inst_64654 = (state_64675[(7)]);
var state_64675__$1 = state_64675;
var statearr_64745_64778 = state_64675__$1;
(statearr_64745_64778[(2)] = inst_64654);

(statearr_64745_64778[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64676 === (6))){
var inst_64671 = (state_64675[(2)]);
var state_64675__$1 = state_64675;
var statearr_64746_64779 = state_64675__$1;
(statearr_64746_64779[(2)] = inst_64671);

(statearr_64746_64779[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64676 === (7))){
var inst_64654 = (state_64675[(7)]);
var inst_64661 = (state_64675[(12)]);
var inst_64660 = (state_64675[(11)]);
var inst_64665 = (state_64675[(2)]);
var inst_64666 = fluree.db.util.async.throw_err(inst_64665);
var inst_64667 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64654,inst_64660,inst_64666);
var inst_64653 = inst_64661;
var inst_64654__$1 = inst_64667;
var state_64675__$1 = (function (){var statearr_64747 = state_64675;
(statearr_64747[(7)] = inst_64654__$1);

(statearr_64747[(9)] = inst_64653);

return statearr_64747;
})();
var statearr_64748_64780 = state_64675__$1;
(statearr_64748_64780[(2)] = null);

(statearr_64748_64780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____0 = (function (){
var statearr_64749 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64749[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__);

(statearr_64749[(1)] = (1));

return statearr_64749;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____1 = (function (state_64675){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64675);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64750){var ex__2736__auto__ = e64750;
var statearr_64751_64781 = state_64675;
(statearr_64751_64781[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64675[(4)]))){
var statearr_64752_64782 = state_64675;
(statearr_64752_64782[(1)] = cljs.core.first((state_64675[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64783 = state_64675;
state_64675 = G__64783;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__ = function(state_64675){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____1.call(this,state_64675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64753 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64753[(6)] = c__2755__auto____$1);

return statearr_64753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});
})();
var inst_64679 = cljs.core.async.impl.dispatch.run(inst_64678);
var state_64730__$1 = (function (){var statearr_64754 = state_64730;
(statearr_64754[(14)] = inst_64679);

return statearr_64754;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64730__$1,(6),inst_64677);
} else {
if((state_val_64731 === (11))){
var inst_64722 = (state_64730[(2)]);
var state_64730__$1 = state_64730;
var statearr_64756_64784 = state_64730__$1;
(statearr_64756_64784[(2)] = inst_64722);

(statearr_64756_64784[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64731 === (9))){
var inst_64702 = (state_64730[(7)]);
var inst_64696 = (state_64730[(11)]);
var inst_64703 = (state_64730[(9)]);
var inst_64682 = (state_64730[(13)]);
var inst_64705 = inst_64702.t;
var inst_64706 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64682,inst_64705);
var inst_64707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64708 = [inst_64706,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_64709 = (new cljs.core.PersistentVector(null,2,(5),inst_64707,inst_64708,null));
var inst_64710 = cljs.core.assoc_in(inst_64696,inst_64709,inst_64706);
var inst_64711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64712 = [inst_64706,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_64713 = (new cljs.core.PersistentVector(null,2,(5),inst_64711,inst_64712,null));
var inst_64714 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_64710,inst_64713,cljs.core.conj,inst_64702);
var inst_64715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64716 = [inst_64706,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_64717 = (new cljs.core.PersistentVector(null,2,(5),inst_64715,inst_64716,null));
var inst_64718 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_64714,inst_64717,fluree.db.api_js.min_safe,inst_64705);
var inst_64695 = inst_64703;
var inst_64696__$1 = inst_64718;
var state_64730__$1 = (function (){var statearr_64757 = state_64730;
(statearr_64757[(8)] = inst_64695);

(statearr_64757[(11)] = inst_64696__$1);

return statearr_64757;
})();
var statearr_64758_64785 = state_64730__$1;
(statearr_64758_64785[(2)] = null);

(statearr_64758_64785[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64731 === (5))){
var _ = (function (){var statearr_64759 = state_64730;
(statearr_64759[(4)] = cljs.core.rest((state_64730[(4)])));

return statearr_64759;
})();
var state_64730__$1 = state_64730;
var ex64755 = (state_64730__$1[(2)]);
var statearr_64760_64786 = state_64730__$1;
(statearr_64760_64786[(5)] = ex64755);


if((ex64755 instanceof Error)){
var statearr_64761_64787 = state_64730__$1;
(statearr_64761_64787[(1)] = (4));

(statearr_64761_64787[(5)] = null);

} else {
throw ex64755;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64731 === (10))){
var inst_64696 = (state_64730[(11)]);
var state_64730__$1 = state_64730;
var statearr_64762_64788 = state_64730__$1;
(statearr_64762_64788[(2)] = inst_64696);

(statearr_64762_64788[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64731 === (8))){
var inst_64724 = (state_64730[(2)]);
var inst_64725 = cljs.core.vals(inst_64724);
var _ = (function (){var statearr_64763 = state_64730;
(statearr_64763[(4)] = cljs.core.rest((state_64730[(4)])));

return statearr_64763;
})();
var state_64730__$1 = state_64730;
var statearr_64764_64789 = state_64730__$1;
(statearr_64764_64789[(2)] = inst_64725);

(statearr_64764_64789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____0 = (function (){
var statearr_64765 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64765[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__);

(statearr_64765[(1)] = (1));

return statearr_64765;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____1 = (function (state_64730){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64730);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64766){var ex__2736__auto__ = e64766;
var statearr_64767_64790 = state_64730;
(statearr_64767_64790[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64730[(4)]))){
var statearr_64768_64791 = state_64730;
(statearr_64768_64791[(1)] = cljs.core.first((state_64730[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64792 = state_64730;
state_64730 = G__64792;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__ = function(state_64730){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____1.call(this,state_64730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2733__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64769 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64769[(6)] = c__2755__auto__);

return statearr_64769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64937){
var state_val_64938 = (state_64937[(1)]);
if((state_val_64938 === (7))){
var inst_64817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64818 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64819 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64820 = [inst_64818,inst_64819];
var inst_64821 = (new cljs.core.PersistentVector(null,2,(5),inst_64817,inst_64820,null));
var state_64937__$1 = state_64937;
var statearr_64939_65010 = state_64937__$1;
(statearr_64939_65010[(2)] = inst_64821);

(statearr_64939_65010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (20))){
var inst_64847 = (state_64937[(7)]);
var state_64937__$1 = state_64937;
var statearr_64940_65011 = state_64937__$1;
(statearr_64940_65011[(2)] = inst_64847);

(statearr_64940_65011[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (27))){
var state_64937__$1 = state_64937;
var statearr_64941_65012 = state_64937__$1;
(statearr_64941_65012[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (1))){
var state_64937__$1 = state_64937;
var statearr_64943_65013 = state_64937__$1;
(statearr_64943_65013[(2)] = null);

(statearr_64943_65013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (24))){
var inst_64846 = (state_64937[(8)]);
var state_64937__$1 = state_64937;
if(cljs.core.truth_(inst_64846)){
var statearr_64944_65014 = state_64937__$1;
(statearr_64944_65014[(1)] = (26));

} else {
var statearr_64945_65015 = state_64937__$1;
(statearr_64945_65015[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (39))){
var inst_64893 = (state_64937[(9)]);
var inst_64892 = (state_64937[(10)]);
var inst_64918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64919 = [inst_64892,inst_64893];
var inst_64920 = (new cljs.core.PersistentVector(null,2,(5),inst_64918,inst_64919,null));
var state_64937__$1 = state_64937;
var statearr_64946_65016 = state_64937__$1;
(statearr_64946_65016[(2)] = inst_64920);

(statearr_64946_65016[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (4))){
var inst_64793 = (state_64937[(2)]);
var inst_64794 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64793], 0));
var inst_64795 = cljs.core.ex_data(inst_64793);
var inst_64796 = cljs.core.ex_message(inst_64793);
var inst_64797 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64795,new cljs.core.Keyword(null,"message","message",-406056002),inst_64796);
var state_64937__$1 = (function (){var statearr_64947 = state_64937;
(statearr_64947[(11)] = inst_64794);

return statearr_64947;
})();
var statearr_64948_65017 = state_64937__$1;
(statearr_64948_65017[(2)] = inst_64797);

(statearr_64948_65017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (15))){
var inst_64826 = (state_64937[(12)]);
var inst_64831 = (state_64937[(13)]);
var inst_64840 = (state_64937[(2)]);
var inst_64841 = [inst_64831,inst_64840];
var inst_64842 = (new cljs.core.PersistentVector(null,2,(5),inst_64826,inst_64841,null));
var state_64937__$1 = state_64937;
var statearr_64949_65018 = state_64937__$1;
(statearr_64949_65018[(2)] = inst_64842);

(statearr_64949_65018[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (21))){
var inst_64846 = (state_64937[(8)]);
var state_64937__$1 = state_64937;
var statearr_64950_65019 = state_64937__$1;
(statearr_64950_65019[(2)] = inst_64846);

(statearr_64950_65019[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (31))){
var inst_64887 = (state_64937[(2)]);
var state_64937__$1 = state_64937;
var statearr_64951_65020 = state_64937__$1;
(statearr_64951_65020[(2)] = inst_64887);

(statearr_64951_65020[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (32))){
var inst_64893 = (state_64937[(9)]);
var inst_64896 = cljs.core.pos_int_QMARK_(inst_64893);
var state_64937__$1 = state_64937;
var statearr_64952_65021 = state_64937__$1;
(statearr_64952_65021[(2)] = inst_64896);

(statearr_64952_65021[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (40))){
var inst_64924 = (state_64937[(14)]);
var inst_64848 = (state_64937[(15)]);
var inst_64922 = (state_64937[(2)]);
var inst_64923 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64922,(0),null);
var inst_64924__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64922,(1),null);
var inst_64925 = (inst_64924__$1 > inst_64848);
var state_64937__$1 = (function (){var statearr_64953 = state_64937;
(statearr_64953[(14)] = inst_64924__$1);

(statearr_64953[(16)] = inst_64923);

return statearr_64953;
})();
if(cljs.core.truth_(inst_64925)){
var statearr_64954_65022 = state_64937__$1;
(statearr_64954_65022[(1)] = (41));

} else {
var statearr_64955_65023 = state_64937__$1;
(statearr_64955_65023[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (33))){
var inst_64894 = (state_64937[(17)]);
var state_64937__$1 = state_64937;
var statearr_64956_65024 = state_64937__$1;
(statearr_64956_65024[(2)] = inst_64894);

(statearr_64956_65024[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (13))){
var inst_64832 = (state_64937[(18)]);
var inst_64834 = fluree.db.time_travel.block_to_int_format(db,inst_64832);
var state_64937__$1 = state_64937;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64937__$1,(16),inst_64834);
} else {
if((state_val_64938 === (22))){
var inst_64865 = (state_64937[(2)]);
var state_64937__$1 = state_64937;
if(cljs.core.truth_(inst_64865)){
var statearr_64957_65025 = state_64937__$1;
(statearr_64957_65025[(1)] = (23));

} else {
var statearr_64958_65026 = state_64937__$1;
(statearr_64958_65026[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (36))){
var state_64937__$1 = state_64937;
var statearr_64959_65027 = state_64937__$1;
(statearr_64959_65027[(2)] = null);

(statearr_64959_65027[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (41))){
var inst_64848 = (state_64937[(15)]);
var state_64937__$1 = state_64937;
var statearr_64960_65028 = state_64937__$1;
(statearr_64960_65028[(2)] = inst_64848);

(statearr_64960_65028[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (43))){
var inst_64923 = (state_64937[(16)]);
var inst_64929 = (state_64937[(2)]);
var inst_64930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64931 = [inst_64923,inst_64929];
var inst_64932 = (new cljs.core.PersistentVector(null,2,(5),inst_64930,inst_64931,null));
var _ = (function (){var statearr_64961 = state_64937;
(statearr_64961[(4)] = cljs.core.rest((state_64937[(4)])));

return statearr_64961;
})();
var state_64937__$1 = state_64937;
var statearr_64962_65029 = state_64937__$1;
(statearr_64962_65029[(2)] = inst_64932);

(statearr_64962_65029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (29))){
var inst_64823 = (state_64937[(19)]);
var inst_64878 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64823], 0));
var inst_64879 = ["Invalid block range provided: ",inst_64878].join('');
var inst_64880 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64881 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64882 = cljs.core.PersistentHashMap.fromArrays(inst_64880,inst_64881);
var inst_64883 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64879,inst_64882);
var inst_64884 = (function(){throw inst_64883})();
var state_64937__$1 = state_64937;
var statearr_64963_65030 = state_64937__$1;
(statearr_64963_65030[(2)] = inst_64884);

(statearr_64963_65030[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (6))){
var inst_64815 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_64937__$1 = state_64937;
var statearr_64964_65031 = state_64937__$1;
(statearr_64964_65031[(2)] = inst_64815);

(statearr_64964_65031[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (28))){
var inst_64889 = (state_64937[(2)]);
var state_64937__$1 = state_64937;
var statearr_64965_65032 = state_64937__$1;
(statearr_64965_65032[(2)] = inst_64889);

(statearr_64965_65032[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (25))){
var inst_64894 = (state_64937[(17)]);
var inst_64892 = (state_64937[(10)]);
var inst_64891 = (state_64937[(2)]);
var inst_64892__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64891,(0),null);
var inst_64893 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64891,(1),null);
var inst_64894__$1 = cljs.core.pos_int_QMARK_(inst_64892__$1);
var state_64937__$1 = (function (){var statearr_64966 = state_64937;
(statearr_64966[(17)] = inst_64894__$1);

(statearr_64966[(9)] = inst_64893);

(statearr_64966[(10)] = inst_64892__$1);

return statearr_64966;
})();
if(inst_64894__$1){
var statearr_64967_65033 = state_64937__$1;
(statearr_64967_65033[(1)] = (32));

} else {
var statearr_64968_65034 = state_64937__$1;
(statearr_64968_65034[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (34))){
var inst_64899 = (state_64937[(2)]);
var inst_64900 = cljs.core.not(inst_64899);
var state_64937__$1 = state_64937;
if(inst_64900){
var statearr_64969_65035 = state_64937__$1;
(statearr_64969_65035[(1)] = (35));

} else {
var statearr_64970_65036 = state_64937__$1;
(statearr_64970_65036[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (17))){
var inst_64846 = (state_64937[(8)]);
var inst_64848 = (state_64937[(15)]);
var inst_64851 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64846], 0));
var inst_64852 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64848], 0));
var inst_64853 = ["Start block is out of range for this ledger. Start block provided: ",inst_64851,". Database block: ",inst_64852].join('');
var inst_64854 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64855 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64856 = cljs.core.PersistentHashMap.fromArrays(inst_64854,inst_64855);
var inst_64857 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64853,inst_64856);
var inst_64858 = (function(){throw inst_64857})();
var state_64937__$1 = state_64937;
var statearr_64971_65037 = state_64937__$1;
(statearr_64971_65037[(2)] = inst_64858);

(statearr_64971_65037[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (3))){
var inst_64935 = (state_64937[(2)]);
var state_64937__$1 = state_64937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64937__$1,inst_64935);
} else {
if((state_val_64938 === (12))){
var inst_64832 = (state_64937[(18)]);
var inst_64823 = (state_64937[(19)]);
var inst_64830 = (state_64937[(2)]);
var inst_64831 = fluree.db.util.async.throw_err(inst_64830);
var inst_64832__$1 = cljs.core.second(inst_64823);
var state_64937__$1 = (function (){var statearr_64972 = state_64937;
(statearr_64972[(18)] = inst_64832__$1);

(statearr_64972[(13)] = inst_64831);

return statearr_64972;
})();
if(cljs.core.truth_(inst_64832__$1)){
var statearr_64973_65038 = state_64937__$1;
(statearr_64973_65038[(1)] = (13));

} else {
var statearr_64974_65039 = state_64937__$1;
(statearr_64974_65039[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (2))){
var _ = (function (){var statearr_64975 = state_64937;
(statearr_64975[(4)] = cljs.core.cons((5),(state_64937[(4)])));

return statearr_64975;
})();
var inst_64812 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64813 = cljs.core.sequential_QMARK_(inst_64812);
var state_64937__$1 = state_64937;
if(inst_64813){
var statearr_64976_65040 = state_64937__$1;
(statearr_64976_65040[(1)] = (6));

} else {
var statearr_64977_65041 = state_64937__$1;
(statearr_64977_65041[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (23))){
var inst_64846 = (state_64937[(8)]);
var inst_64847 = (state_64937[(7)]);
var inst_64867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64868 = [inst_64846,inst_64847];
var inst_64869 = (new cljs.core.PersistentVector(null,2,(5),inst_64867,inst_64868,null));
var state_64937__$1 = state_64937;
var statearr_64978_65042 = state_64937__$1;
(statearr_64978_65042[(2)] = inst_64869);

(statearr_64978_65042[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (35))){
var inst_64823 = (state_64937[(19)]);
var inst_64902 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64823], 0));
var inst_64903 = ["Invalid block range provided: ",inst_64902].join('');
var inst_64904 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64905 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64906 = cljs.core.PersistentHashMap.fromArrays(inst_64904,inst_64905);
var inst_64907 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64903,inst_64906);
var inst_64908 = (function(){throw inst_64907})();
var state_64937__$1 = state_64937;
var statearr_64979_65043 = state_64937__$1;
(statearr_64979_65043[(2)] = inst_64908);

(statearr_64979_65043[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (19))){
var inst_64846 = (state_64937[(8)]);
var inst_64861 = (state_64937[(2)]);
var state_64937__$1 = (function (){var statearr_64980 = state_64937;
(statearr_64980[(20)] = inst_64861);

return statearr_64980;
})();
if(cljs.core.truth_(inst_64846)){
var statearr_64981_65044 = state_64937__$1;
(statearr_64981_65044[(1)] = (20));

} else {
var statearr_64982_65045 = state_64937__$1;
(statearr_64982_65045[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (11))){
var inst_64846 = (state_64937[(8)]);
var inst_64848 = (state_64937[(15)]);
var inst_64845 = (state_64937[(2)]);
var inst_64846__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64845,(0),null);
var inst_64847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64845,(1),null);
var inst_64848__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64849 = (inst_64846__$1 > inst_64848__$1);
var state_64937__$1 = (function (){var statearr_64984 = state_64937;
(statearr_64984[(8)] = inst_64846__$1);

(statearr_64984[(7)] = inst_64847);

(statearr_64984[(15)] = inst_64848__$1);

return statearr_64984;
})();
if(cljs.core.truth_(inst_64849)){
var statearr_64985_65046 = state_64937__$1;
(statearr_64985_65046[(1)] = (17));

} else {
var statearr_64986_65047 = state_64937__$1;
(statearr_64986_65047[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (9))){
var inst_64823 = (state_64937[(19)]);
var inst_64826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64827 = cljs.core.first(inst_64823);
var inst_64828 = fluree.db.time_travel.block_to_int_format(db,inst_64827);
var state_64937__$1 = (function (){var statearr_64987 = state_64937;
(statearr_64987[(12)] = inst_64826);

return statearr_64987;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64937__$1,(12),inst_64828);
} else {
if((state_val_64938 === (5))){
var _ = (function (){var statearr_64988 = state_64937;
(statearr_64988[(4)] = cljs.core.rest((state_64937[(4)])));

return statearr_64988;
})();
var state_64937__$1 = state_64937;
var ex64983 = (state_64937__$1[(2)]);
var statearr_64989_65048 = state_64937__$1;
(statearr_64989_65048[(5)] = ex64983);


var statearr_64990_65049 = state_64937__$1;
(statearr_64990_65049[(1)] = (4));

(statearr_64990_65049[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (14))){
var state_64937__$1 = state_64937;
var statearr_64991_65050 = state_64937__$1;
(statearr_64991_65050[(2)] = null);

(statearr_64991_65050[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (26))){
var inst_64846 = (state_64937[(8)]);
var inst_64872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64873 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64874 = [inst_64846,inst_64873];
var inst_64875 = (new cljs.core.PersistentVector(null,2,(5),inst_64872,inst_64874,null));
var state_64937__$1 = state_64937;
var statearr_64992_65051 = state_64937__$1;
(statearr_64992_65051[(2)] = inst_64875);

(statearr_64992_65051[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (16))){
var inst_64836 = (state_64937[(2)]);
var inst_64837 = fluree.db.util.async.throw_err(inst_64836);
var state_64937__$1 = state_64937;
var statearr_64993_65052 = state_64937__$1;
(statearr_64993_65052[(2)] = inst_64837);

(statearr_64993_65052[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (38))){
var inst_64893 = (state_64937[(9)]);
var inst_64892 = (state_64937[(10)]);
var inst_64914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64915 = [inst_64893,inst_64892];
var inst_64916 = (new cljs.core.PersistentVector(null,2,(5),inst_64914,inst_64915,null));
var state_64937__$1 = state_64937;
var statearr_64994_65053 = state_64937__$1;
(statearr_64994_65053[(2)] = inst_64916);

(statearr_64994_65053[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (30))){
var state_64937__$1 = state_64937;
var statearr_64995_65054 = state_64937__$1;
(statearr_64995_65054[(2)] = null);

(statearr_64995_65054[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (10))){
var inst_64823 = (state_64937[(19)]);
var state_64937__$1 = state_64937;
var statearr_64996_65055 = state_64937__$1;
(statearr_64996_65055[(2)] = inst_64823);

(statearr_64996_65055[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (18))){
var state_64937__$1 = state_64937;
var statearr_64997_65056 = state_64937__$1;
(statearr_64997_65056[(2)] = null);

(statearr_64997_65056[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (42))){
var inst_64924 = (state_64937[(14)]);
var state_64937__$1 = state_64937;
var statearr_64998_65057 = state_64937__$1;
(statearr_64998_65057[(2)] = inst_64924);

(statearr_64998_65057[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (37))){
var inst_64893 = (state_64937[(9)]);
var inst_64892 = (state_64937[(10)]);
var inst_64911 = (state_64937[(2)]);
var inst_64912 = (inst_64893 < inst_64892);
var state_64937__$1 = (function (){var statearr_64999 = state_64937;
(statearr_64999[(21)] = inst_64911);

return statearr_64999;
})();
if(cljs.core.truth_(inst_64912)){
var statearr_65000_65058 = state_64937__$1;
(statearr_65000_65058[(1)] = (38));

} else {
var statearr_65001_65059 = state_64937__$1;
(statearr_65001_65059[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64938 === (8))){
var inst_64823 = (state_64937[(19)]);
var inst_64823__$1 = (state_64937[(2)]);
var inst_64824 = cljs.core.some(cljs.core.string_QMARK_,inst_64823__$1);
var state_64937__$1 = (function (){var statearr_65002 = state_64937;
(statearr_65002[(19)] = inst_64823__$1);

return statearr_65002;
})();
if(cljs.core.truth_(inst_64824)){
var statearr_65003_65060 = state_64937__$1;
(statearr_65003_65060[(1)] = (9));

} else {
var statearr_65004_65061 = state_64937__$1;
(statearr_65004_65061[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto____0 = (function (){
var statearr_65005 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65005[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto__);

(statearr_65005[(1)] = (1));

return statearr_65005;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto____1 = (function (state_64937){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64937);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65006){var ex__2736__auto__ = e65006;
var statearr_65007_65062 = state_64937;
(statearr_65007_65062[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64937[(4)]))){
var statearr_65008_65063 = state_64937;
(statearr_65008_65063[(1)] = cljs.core.first((state_64937[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65064 = state_64937;
state_64937 = G__65064;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto__ = function(state_64937){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto____1.call(this,state_64937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65009 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65009[(6)] = c__2755__auto__);

return statearr_65009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__65067 = arguments.length;
switch (G__65067) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65162){
var state_val_65163 = (state_65162[(1)]);
if((state_val_65163 === (7))){
var inst_65090 = (state_65162[(7)]);
var inst_65093 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_65090);
var state_65162__$1 = state_65162;
var statearr_65164_65217 = state_65162__$1;
(statearr_65164_65217[(2)] = inst_65093);

(statearr_65164_65217[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (20))){
var inst_65129 = (state_65162[(8)]);
var inst_65132 = fluree.db.api_js.format_block_resp_pretty(db,inst_65129);
var state_65162__$1 = state_65162;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65162__$1,(23),inst_65132);
} else {
if((state_val_65163 === (27))){
var inst_65138 = (state_65162[(9)]);
var inst_65144 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_65138);
var state_65162__$1 = state_65162;
var statearr_65165_65218 = state_65162__$1;
(statearr_65165_65218[(2)] = inst_65144);

(statearr_65165_65218[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (1))){
var state_65162__$1 = state_65162;
var statearr_65166_65219 = state_65162__$1;
(statearr_65166_65219[(2)] = null);

(statearr_65166_65219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (24))){
var inst_65138 = (state_65162[(9)]);
var inst_65141 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_65142 = cljs.core.sequential_QMARK_(inst_65138);
var state_65162__$1 = (function (){var statearr_65167 = state_65162;
(statearr_65167[(10)] = inst_65141);

return statearr_65167;
})();
if(inst_65142){
var statearr_65168_65220 = state_65162__$1;
(statearr_65168_65220[(1)] = (27));

} else {
var statearr_65169_65221 = state_65162__$1;
(statearr_65169_65221[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (4))){
var inst_65068 = (state_65162[(2)]);
var inst_65069 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65068], 0));
var inst_65070 = cljs.core.ex_data(inst_65068);
var inst_65071 = cljs.core.ex_message(inst_65068);
var inst_65072 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65070,new cljs.core.Keyword(null,"message","message",-406056002),inst_65071);
var state_65162__$1 = (function (){var statearr_65170 = state_65162;
(statearr_65170[(11)] = inst_65069);

return statearr_65170;
})();
var statearr_65171_65222 = state_65162__$1;
(statearr_65171_65222[(2)] = inst_65072);

(statearr_65171_65222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (15))){
var inst_65090 = (state_65162[(7)]);
var inst_65103 = (state_65162[(2)]);
var inst_65104 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65103,inst_65090);
var inst_65105 = (function(){throw inst_65104})();
var state_65162__$1 = state_65162;
var statearr_65172_65223 = state_65162__$1;
(statearr_65172_65223[(2)] = inst_65105);

(statearr_65172_65223[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (21))){
var inst_65129 = (state_65162[(8)]);
var state_65162__$1 = state_65162;
var statearr_65173_65224 = state_65162__$1;
(statearr_65173_65224[(2)] = inst_65129);

(statearr_65173_65224[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (13))){
var inst_65098 = (state_65162[(12)]);
var state_65162__$1 = state_65162;
var statearr_65174_65225 = state_65162__$1;
(statearr_65174_65225[(2)] = inst_65098);

(statearr_65174_65225[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (22))){
var inst_65138 = (state_65162[(2)]);
var inst_65139 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_65162__$1 = (function (){var statearr_65175 = state_65162;
(statearr_65175[(9)] = inst_65138);

return statearr_65175;
})();
if(cljs.core.truth_(inst_65139)){
var statearr_65176_65226 = state_65162__$1;
(statearr_65176_65226[(1)] = (24));

} else {
var statearr_65177_65227 = state_65162__$1;
(statearr_65177_65227[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (29))){
var inst_65109 = (state_65162[(13)]);
var inst_65110 = (state_65162[(14)]);
var inst_65141 = (state_65162[(10)]);
var inst_65090 = (state_65162[(7)]);
var inst_65086 = (state_65162[(15)]);
var inst_65085 = (state_65162[(16)]);
var inst_65129 = (state_65162[(8)]);
var inst_65138 = (state_65162[(9)]);
var inst_65084 = (state_65162[(17)]);
var inst_65108 = (state_65162[(18)]);
var inst_65082 = (state_65162[(19)]);
var inst_65147 = (state_65162[(2)]);
var inst_65148 = (function (){var network = inst_65085;
var block_start = inst_65109;
var block_end = inst_65110;
var map__65078 = inst_65084;
var range = inst_65090;
var db_id = inst_65086;
var _ = inst_65108;
var vec__65079 = inst_65090;
var start = inst_65082;
var result_SINGLEQUOTE_ = inst_65138;
var result = inst_65129;
return (function (p1__65065_SHARP_){
var G__65178 = "%.2fms";
var G__65179 = p1__65065_SHARP_;
return goog.string.format(G__65178,G__65179);
});
})();
var inst_65149 = fluree.db.util.core.current_time_millis();
var inst_65150 = (inst_65149 - inst_65082);
var inst_65151 = (inst_65150 / (1000000));
var inst_65152 = (inst_65148.cljs$core$IFn$_invoke$arity$1 ? inst_65148.cljs$core$IFn$_invoke$arity$1(inst_65151) : inst_65148.call(null,inst_65151));
var inst_65153 = [(200),inst_65147,(100),inst_65152];
var inst_65154 = cljs.core.PersistentHashMap.fromArrays(inst_65141,inst_65153);
var state_65162__$1 = state_65162;
var statearr_65180_65228 = state_65162__$1;
(statearr_65180_65228[(2)] = inst_65154);

(statearr_65180_65228[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (6))){
var inst_65090 = (state_65162[(7)]);
var inst_65091 = (state_65162[(20)]);
var inst_65089 = (state_65162[(2)]);
var inst_65090__$1 = fluree.db.util.async.throw_err(inst_65089);
var inst_65091__$1 = cljs.core.map_QMARK_(inst_65090__$1);
var state_65162__$1 = (function (){var statearr_65181 = state_65162;
(statearr_65181[(7)] = inst_65090__$1);

(statearr_65181[(20)] = inst_65091__$1);

return statearr_65181;
})();
if(inst_65091__$1){
var statearr_65182_65229 = state_65162__$1;
(statearr_65182_65229[(1)] = (7));

} else {
var statearr_65183_65230 = state_65162__$1;
(statearr_65183_65230[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (28))){
var inst_65138 = (state_65162[(9)]);
var state_65162__$1 = state_65162;
var statearr_65184_65231 = state_65162__$1;
(statearr_65184_65231[(2)] = inst_65138);

(statearr_65184_65231[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (25))){
var inst_65138 = (state_65162[(9)]);
var state_65162__$1 = state_65162;
var statearr_65185_65232 = state_65162__$1;
(statearr_65185_65232[(2)] = inst_65138);

(statearr_65185_65232[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (17))){
var inst_65121 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_65122 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_65121].join('');
var inst_65123 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65124 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65125 = cljs.core.PersistentHashMap.fromArrays(inst_65123,inst_65124);
var inst_65126 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65122,inst_65125);
var inst_65127 = (function(){throw inst_65126})();
var state_65162__$1 = state_65162;
var statearr_65186_65233 = state_65162__$1;
(statearr_65186_65233[(2)] = inst_65127);

(statearr_65186_65233[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (3))){
var inst_65160 = (state_65162[(2)]);
var state_65162__$1 = state_65162;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65162__$1,inst_65160);
} else {
if((state_val_65163 === (12))){
var inst_65090 = (state_65162[(7)]);
var inst_65108 = (state_65162[(2)]);
var inst_65109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65090,(0),null);
var inst_65110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65090,(1),null);
var inst_65111 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_65112 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_65113 = cljs.core.keys(inst_65112);
var inst_65114 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65111,inst_65113);
var state_65162__$1 = (function (){var statearr_65187 = state_65162;
(statearr_65187[(13)] = inst_65109);

(statearr_65187[(14)] = inst_65110);

(statearr_65187[(18)] = inst_65108);

return statearr_65187;
})();
if(inst_65114){
var statearr_65188_65234 = state_65162__$1;
(statearr_65188_65234[(1)] = (16));

} else {
var statearr_65189_65235 = state_65162__$1;
(statearr_65189_65235[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (2))){
var inst_65084 = (state_65162[(17)]);
var _ = (function (){var statearr_65190 = state_65162;
(statearr_65190[(4)] = cljs.core.cons((5),(state_65162[(4)])));

return statearr_65190;
})();
var inst_65082 = fluree.db.util.core.current_time_millis();
var inst_65083 = db;
var inst_65084__$1 = cljs.core.__destructure_map(inst_65083);
var inst_65085 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65084__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_65086 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65084__$1,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_65087 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_65162__$1 = (function (){var statearr_65191 = state_65162;
(statearr_65191[(15)] = inst_65086);

(statearr_65191[(16)] = inst_65085);

(statearr_65191[(17)] = inst_65084__$1);

(statearr_65191[(19)] = inst_65082);

return statearr_65191;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65162__$1,(6),inst_65087);
} else {
if((state_val_65163 === (23))){
var inst_65134 = (state_65162[(2)]);
var inst_65135 = fluree.db.util.async.throw_err(inst_65134);
var state_65162__$1 = state_65162;
var statearr_65192_65236 = state_65162__$1;
(statearr_65192_65236[(2)] = inst_65135);

(statearr_65192_65236[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (19))){
var inst_65118 = (state_65162[(2)]);
var inst_65119 = fluree.db.util.async.throw_err(inst_65118);
var state_65162__$1 = state_65162;
var statearr_65193_65237 = state_65162__$1;
(statearr_65193_65237[(2)] = inst_65119);

(statearr_65193_65237[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (11))){
var state_65162__$1 = state_65162;
var statearr_65195_65238 = state_65162__$1;
(statearr_65195_65238[(2)] = null);

(statearr_65195_65238[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (9))){
var inst_65096 = (state_65162[(2)]);
var state_65162__$1 = state_65162;
if(cljs.core.truth_(inst_65096)){
var statearr_65196_65239 = state_65162__$1;
(statearr_65196_65239[(1)] = (10));

} else {
var statearr_65197_65240 = state_65162__$1;
(statearr_65197_65240[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (5))){
var _ = (function (){var statearr_65198 = state_65162;
(statearr_65198[(4)] = cljs.core.rest((state_65162[(4)])));

return statearr_65198;
})();
var state_65162__$1 = state_65162;
var ex65194 = (state_65162__$1[(2)]);
var statearr_65199_65241 = state_65162__$1;
(statearr_65199_65241[(5)] = ex65194);


var statearr_65200_65242 = state_65162__$1;
(statearr_65200_65242[(1)] = (4));

(statearr_65200_65242[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (14))){
var inst_65086 = (state_65162[(15)]);
var inst_65085 = (state_65162[(16)]);
var inst_65101 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65085),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65086)].join('');
var state_65162__$1 = state_65162;
var statearr_65201_65243 = state_65162__$1;
(statearr_65201_65243[(2)] = inst_65101);

(statearr_65201_65243[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (26))){
var inst_65157 = (state_65162[(2)]);
var _ = (function (){var statearr_65202 = state_65162;
(statearr_65202[(4)] = cljs.core.rest((state_65162[(4)])));

return statearr_65202;
})();
var state_65162__$1 = state_65162;
var statearr_65203_65244 = state_65162__$1;
(statearr_65203_65244[(2)] = inst_65157);

(statearr_65203_65244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (16))){
var inst_65109 = (state_65162[(13)]);
var inst_65110 = (state_65162[(14)]);
var inst_65116 = fluree.db.query.block.block_range(db,inst_65109,inst_65110,opts);
var state_65162__$1 = state_65162;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65162__$1,(19),inst_65116);
} else {
if((state_val_65163 === (10))){
var inst_65090 = (state_65162[(7)]);
var inst_65098 = (state_65162[(12)]);
var inst_65098__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_65090);
var state_65162__$1 = (function (){var statearr_65204 = state_65162;
(statearr_65204[(12)] = inst_65098__$1);

return statearr_65204;
})();
if(cljs.core.truth_(inst_65098__$1)){
var statearr_65205_65245 = state_65162__$1;
(statearr_65205_65245[(1)] = (13));

} else {
var statearr_65206_65246 = state_65162__$1;
(statearr_65206_65246[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (18))){
var inst_65129 = (state_65162[(2)]);
var inst_65130 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_65162__$1 = (function (){var statearr_65207 = state_65162;
(statearr_65207[(8)] = inst_65129);

return statearr_65207;
})();
if(cljs.core.truth_(inst_65130)){
var statearr_65208_65247 = state_65162__$1;
(statearr_65208_65247[(1)] = (20));

} else {
var statearr_65209_65248 = state_65162__$1;
(statearr_65209_65248[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65163 === (8))){
var inst_65091 = (state_65162[(20)]);
var state_65162__$1 = state_65162;
var statearr_65210_65249 = state_65162__$1;
(statearr_65210_65249[(2)] = inst_65091);

(statearr_65210_65249[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_65211 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65211[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_65211[(1)] = (1));

return statearr_65211;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_65162){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65162);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65212){var ex__2736__auto__ = e65212;
var statearr_65213_65250 = state_65162;
(statearr_65213_65250[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65162[(4)]))){
var statearr_65214_65251 = state_65162;
(statearr_65214_65251[(1)] = cljs.core.first((state_65162[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65252 = state_65162;
state_65162 = G__65252;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_65162){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_65162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65215 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65215[(6)] = c__2755__auto__);

return statearr_65215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__65254 = arguments.length;
switch (G__65254) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65449){
var state_val_65450 = (state_65449[(1)]);
if((state_val_65450 === (62))){
var inst_65447 = (state_65449[(2)]);
var state_65449__$1 = state_65449;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65449__$1,inst_65447);
} else {
if((state_val_65450 === (7))){
var inst_65275 = (state_65449[(7)]);
var inst_65285 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_65275);
var state_65449__$1 = state_65449;
var statearr_65451_65542 = state_65449__$1;
(statearr_65451_65542[(2)] = inst_65285);

(statearr_65451_65542[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (59))){
var inst_65435 = (state_65449[(2)]);
var inst_65436 = fluree.db.util.async.throw_err(inst_65435);
var state_65449__$1 = state_65449;
var statearr_65452_65543 = state_65449__$1;
(statearr_65452_65543[(2)] = inst_65436);

(statearr_65452_65543[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (20))){
var inst_65351 = (state_65449[(8)]);
var inst_65343 = (state_65449[(9)]);
var inst_65343__$1 = (state_65449[(2)]);
var inst_65344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65345 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65343__$1,(0));
var inst_65346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65343__$1,(1));
var inst_65347 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65343__$1,(2));
var inst_65348 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65343__$1,(3));
var inst_65349 = [inst_65345,inst_65346,inst_65347,inst_65348];
var inst_65350 = (new cljs.core.PersistentVector(null,4,(5),inst_65344,inst_65349,null));
var inst_65351__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65350,(0),null);
var inst_65352 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65350,(1),null);
var inst_65353 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65350,(2),null);
var inst_65354 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65350,(3),null);
var inst_65355 = (inst_65351__$1 == null);
var inst_65356 = cljs.core.not(inst_65355);
var state_65449__$1 = (function (){var statearr_65453 = state_65449;
(statearr_65453[(8)] = inst_65351__$1);

(statearr_65453[(10)] = inst_65354);

(statearr_65453[(11)] = inst_65353);

(statearr_65453[(12)] = inst_65352);

(statearr_65453[(9)] = inst_65343__$1);

return statearr_65453;
})();
if(inst_65356){
var statearr_65454_65544 = state_65449__$1;
(statearr_65454_65544[(1)] = (30));

} else {
var statearr_65455_65545 = state_65449__$1;
(statearr_65455_65545[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (58))){
var inst_65283 = (state_65449[(13)]);
var inst_65439 = (state_65449[(2)]);
var state_65449__$1 = (function (){var statearr_65456 = state_65449;
(statearr_65456[(14)] = inst_65439);

return statearr_65456;
})();
if(cljs.core.truth_(inst_65283)){
var statearr_65457_65546 = state_65449__$1;
(statearr_65457_65546[(1)] = (60));

} else {
var statearr_65458_65547 = state_65449__$1;
(statearr_65458_65547[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (60))){
var inst_65427 = (state_65449[(15)]);
var inst_65439 = (state_65449[(14)]);
var inst_65441 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_65442 = cljs.core.count(inst_65427);
var inst_65443 = [inst_65439,inst_65442,(200)];
var inst_65444 = cljs.core.PersistentHashMap.fromArrays(inst_65441,inst_65443);
var state_65449__$1 = state_65449;
var statearr_65459_65548 = state_65449__$1;
(statearr_65459_65548[(2)] = inst_65444);

(statearr_65459_65548[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (27))){
var inst_65262 = (state_65449[(16)]);
var inst_65331 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65262)].join('');
var inst_65332 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65333 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65334 = cljs.core.PersistentHashMap.fromArrays(inst_65332,inst_65333);
var inst_65335 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65331,inst_65334);
var inst_65336 = (function(){throw inst_65335})();
var state_65449__$1 = state_65449;
var statearr_65460_65549 = state_65449__$1;
(statearr_65460_65549[(2)] = inst_65336);

(statearr_65460_65549[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (1))){
var inst_65259 = query_map;
var inst_65260 = cljs.core.__destructure_map(inst_65259);
var inst_65261 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65260,new cljs.core.Keyword(null,"block","block",664686210));
var inst_65262 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65260,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_65263 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65260,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_65449__$1 = (function (){var statearr_65461 = state_65449;
(statearr_65461[(16)] = inst_65262);

(statearr_65461[(17)] = inst_65263);

(statearr_65461[(18)] = inst_65261);

return statearr_65461;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65449__$1,(2),sources);
} else {
if((state_val_65450 === (24))){
var inst_65262 = (state_65449[(16)]);
var inst_65320 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65262)].join('');
var inst_65321 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65322 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65323 = cljs.core.PersistentHashMap.fromArrays(inst_65321,inst_65322);
var inst_65324 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65320,inst_65323);
var inst_65325 = (function(){throw inst_65324})();
var state_65449__$1 = state_65449;
var statearr_65462_65550 = state_65449__$1;
(statearr_65462_65550[(2)] = inst_65325);

(statearr_65462_65550[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (55))){
var inst_65263 = (state_65449[(17)]);
var inst_65430 = (state_65449[(2)]);
var inst_65431 = fluree.db.util.async.throw_err(inst_65430);
var state_65449__$1 = (function (){var statearr_65463 = state_65449;
(statearr_65463[(19)] = inst_65431);

return statearr_65463;
})();
if(cljs.core.truth_(inst_65263)){
var statearr_65464_65551 = state_65449__$1;
(statearr_65464_65551[(1)] = (56));

} else {
var statearr_65465_65552 = state_65449__$1;
(statearr_65465_65552[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (39))){
var inst_65351 = (state_65449[(8)]);
var inst_65354 = (state_65449[(10)]);
var inst_65353 = (state_65449[(11)]);
var inst_65352 = (state_65449[(12)]);
var inst_65375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65377 = [inst_65352,inst_65351,inst_65353,inst_65354];
var inst_65378 = (new cljs.core.PersistentVector(null,4,(5),inst_65376,inst_65377,null));
var inst_65379 = [inst_65378,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_65380 = (new cljs.core.PersistentVector(null,2,(5),inst_65375,inst_65379,null));
var state_65449__$1 = state_65449;
var statearr_65466_65553 = state_65449__$1;
(statearr_65466_65553[(2)] = inst_65380);

(statearr_65466_65553[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (46))){
var inst_65385 = (state_65449[(20)]);
var state_65449__$1 = state_65449;
var statearr_65467_65554 = state_65449__$1;
(statearr_65467_65554[(2)] = inst_65385);

(statearr_65467_65554[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (4))){
var state_65449__$1 = state_65449;
var statearr_65468_65555 = state_65449__$1;
(statearr_65468_65555[(2)] = null);

(statearr_65468_65555[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (54))){
var inst_65266 = (state_65449[(21)]);
var inst_65427 = (state_65449[(15)]);
var inst_65426 = (state_65449[(2)]);
var inst_65427__$1 = fluree.db.util.async.throw_err(inst_65426);
var inst_65428 = fluree.db.api_js.format_history_resp(inst_65266,inst_65427__$1);
var state_65449__$1 = (function (){var statearr_65469 = state_65449;
(statearr_65469[(15)] = inst_65427__$1);

return statearr_65469;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65449__$1,(55),inst_65428);
} else {
if((state_val_65450 === (15))){
var inst_65266 = (state_65449[(21)]);
var inst_65307 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65266);
var state_65449__$1 = state_65449;
var statearr_65470_65556 = state_65449__$1;
(statearr_65470_65556[(2)] = inst_65307);

(statearr_65470_65556[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (48))){
var inst_65351 = (state_65449[(8)]);
var inst_65354 = (state_65449[(10)]);
var inst_65353 = (state_65449[(11)]);
var inst_65352 = (state_65449[(12)]);
var inst_65396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65398 = [inst_65352,inst_65353,inst_65351,inst_65354];
var inst_65399 = (new cljs.core.PersistentVector(null,4,(5),inst_65397,inst_65398,null));
var inst_65400 = [inst_65399,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_65401 = (new cljs.core.PersistentVector(null,2,(5),inst_65396,inst_65400,null));
var state_65449__$1 = state_65449;
var statearr_65471_65557 = state_65449__$1;
(statearr_65471_65557[(2)] = inst_65401);

(statearr_65471_65557[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (50))){
var inst_65414 = (state_65449[(2)]);
var state_65449__$1 = state_65449;
var statearr_65472_65558 = state_65449__$1;
(statearr_65472_65558[(2)] = inst_65414);

(statearr_65472_65558[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (21))){
var inst_65262 = (state_65449[(16)]);
var inst_65318 = cljs.core.empty_QMARK_(inst_65262);
var state_65449__$1 = state_65449;
if(inst_65318){
var statearr_65473_65559 = state_65449__$1;
(statearr_65473_65559[(1)] = (24));

} else {
var statearr_65474_65560 = state_65449__$1;
(statearr_65474_65560[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (31))){
var inst_65351 = (state_65449[(8)]);
var inst_65362 = (state_65449[(22)]);
var inst_65362__$1 = (inst_65351 == null);
var state_65449__$1 = (function (){var statearr_65475 = state_65449;
(statearr_65475[(22)] = inst_65362__$1);

return statearr_65475;
})();
if(cljs.core.truth_(inst_65362__$1)){
var statearr_65476_65561 = state_65449__$1;
(statearr_65476_65561[(1)] = (33));

} else {
var statearr_65477_65562 = state_65449__$1;
(statearr_65477_65562[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (32))){
var inst_65266 = (state_65449[(21)]);
var inst_65309 = (state_65449[(23)]);
var inst_65299 = (state_65449[(24)]);
var inst_65418 = (state_65449[(2)]);
var inst_65419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65418,(0),null);
var inst_65420 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65418,(1),null);
var inst_65421 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_65422 = [inst_65299,inst_65309];
var inst_65423 = cljs.core.PersistentHashMap.fromArrays(inst_65421,inst_65422);
var inst_65424 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_65266,inst_65420,cljs.core._EQ_,inst_65419,inst_65423);
var state_65449__$1 = state_65449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65449__$1,(54),inst_65424);
} else {
if((state_val_65450 === (40))){
var inst_65351 = (state_65449[(8)]);
var inst_65382 = (state_65449[(25)]);
var inst_65382__$1 = (inst_65351 == null);
var state_65449__$1 = (function (){var statearr_65478 = state_65449;
(statearr_65478[(25)] = inst_65382__$1);

return statearr_65478;
})();
if(cljs.core.truth_(inst_65382__$1)){
var statearr_65479_65563 = state_65449__$1;
(statearr_65479_65563[(1)] = (42));

} else {
var statearr_65480_65564 = state_65449__$1;
(statearr_65480_65564[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (56))){
var inst_65266 = (state_65449[(21)]);
var inst_65431 = (state_65449[(19)]);
var inst_65433 = fluree.db.api_js.format_block_resp_pretty(inst_65266,inst_65431);
var state_65449__$1 = state_65449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65449__$1,(59),inst_65433);
} else {
if((state_val_65450 === (33))){
var inst_65365 = (state_65449[(26)]);
var inst_65352 = (state_65449[(12)]);
var inst_65364 = (inst_65352 == null);
var inst_65365__$1 = cljs.core.not(inst_65364);
var state_65449__$1 = (function (){var statearr_65481 = state_65449;
(statearr_65481[(26)] = inst_65365__$1);

return statearr_65481;
})();
if(inst_65365__$1){
var statearr_65482_65565 = state_65449__$1;
(statearr_65482_65565[(1)] = (36));

} else {
var statearr_65483_65566 = state_65449__$1;
(statearr_65483_65566[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (13))){
var inst_65293 = (state_65449[(2)]);
var inst_65294 = fluree.db.util.async.throw_err(inst_65293);
var inst_65295 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65294);
var inst_65296 = (inst_65295 - (1));
var state_65449__$1 = state_65449;
var statearr_65484_65567 = state_65449__$1;
(statearr_65484_65567[(2)] = inst_65296);

(statearr_65484_65567[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (22))){
var state_65449__$1 = state_65449;
var statearr_65485_65568 = state_65449__$1;
(statearr_65485_65568[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (36))){
var inst_65353 = (state_65449[(11)]);
var inst_65367 = (inst_65353 == null);
var state_65449__$1 = state_65449;
var statearr_65487_65569 = state_65449__$1;
(statearr_65487_65569[(2)] = inst_65367);

(statearr_65487_65569[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (41))){
var inst_65416 = (state_65449[(2)]);
var state_65449__$1 = state_65449;
var statearr_65488_65570 = state_65449__$1;
(statearr_65488_65570[(2)] = inst_65416);

(statearr_65488_65570[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (43))){
var inst_65382 = (state_65449[(25)]);
var state_65449__$1 = state_65449;
var statearr_65489_65571 = state_65449__$1;
(statearr_65489_65571[(2)] = inst_65382);

(statearr_65489_65571[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (61))){
var inst_65439 = (state_65449[(14)]);
var state_65449__$1 = state_65449;
var statearr_65490_65572 = state_65449__$1;
(statearr_65490_65572[(2)] = inst_65439);

(statearr_65490_65572[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (29))){
var inst_65339 = (state_65449[(2)]);
var state_65449__$1 = state_65449;
var statearr_65491_65573 = state_65449__$1;
(statearr_65491_65573[(2)] = inst_65339);

(statearr_65491_65573[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (44))){
var inst_65394 = (state_65449[(2)]);
var state_65449__$1 = state_65449;
if(cljs.core.truth_(inst_65394)){
var statearr_65492_65574 = state_65449__$1;
(statearr_65492_65574[(1)] = (48));

} else {
var statearr_65493_65575 = state_65449__$1;
(statearr_65493_65575[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (6))){
var inst_65270 = (state_65449[(2)]);
var inst_65271 = fluree.db.util.async.throw_err(inst_65270);
var state_65449__$1 = state_65449;
var statearr_65494_65576 = state_65449__$1;
(statearr_65494_65576[(2)] = inst_65271);

(statearr_65494_65576[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (28))){
var state_65449__$1 = state_65449;
var statearr_65495_65577 = state_65449__$1;
(statearr_65495_65577[(2)] = null);

(statearr_65495_65577[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (51))){
var inst_65262 = (state_65449[(16)]);
var inst_65404 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65262)].join('');
var inst_65405 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65406 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65407 = cljs.core.PersistentHashMap.fromArrays(inst_65405,inst_65406);
var inst_65408 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65404,inst_65407);
var inst_65409 = (function(){throw inst_65408})();
var state_65449__$1 = state_65449;
var statearr_65496_65578 = state_65449__$1;
(statearr_65496_65578[(2)] = inst_65409);

(statearr_65496_65578[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (25))){
var inst_65262 = (state_65449[(16)]);
var state_65449__$1 = state_65449;
var statearr_65497_65579 = state_65449__$1;
(statearr_65497_65579[(2)] = inst_65262);

(statearr_65497_65579[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (34))){
var inst_65362 = (state_65449[(22)]);
var state_65449__$1 = state_65449;
var statearr_65498_65580 = state_65449__$1;
(statearr_65498_65580[(2)] = inst_65362);

(statearr_65498_65580[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (17))){
var inst_65303 = (state_65449[(2)]);
var inst_65304 = fluree.db.util.async.throw_err(inst_65303);
var inst_65305 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65304);
var state_65449__$1 = state_65449;
var statearr_65499_65581 = state_65449__$1;
(statearr_65499_65581[(2)] = inst_65305);

(statearr_65499_65581[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (3))){
var inst_65266 = (state_65449[(21)]);
var inst_65268 = fluree.db.api_js.resolve_block_range(inst_65266,query_map);
var state_65449__$1 = state_65449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65449__$1,(6),inst_65268);
} else {
if((state_val_65450 === (12))){
var inst_65276 = (state_65449[(27)]);
var inst_65299 = (state_65449[(2)]);
var state_65449__$1 = (function (){var statearr_65500 = state_65449;
(statearr_65500[(24)] = inst_65299);

return statearr_65500;
})();
if(cljs.core.truth_(inst_65276)){
var statearr_65501_65582 = state_65449__$1;
(statearr_65501_65582[(1)] = (14));

} else {
var statearr_65502_65583 = state_65449__$1;
(statearr_65502_65583[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (2))){
var inst_65261 = (state_65449[(18)]);
var inst_65265 = (state_65449[(2)]);
var inst_65266 = fluree.db.util.async.throw_err(inst_65265);
var state_65449__$1 = (function (){var statearr_65503 = state_65449;
(statearr_65503[(21)] = inst_65266);

return statearr_65503;
})();
if(cljs.core.truth_(inst_65261)){
var statearr_65504_65584 = state_65449__$1;
(statearr_65504_65584[(1)] = (3));

} else {
var statearr_65505_65585 = state_65449__$1;
(statearr_65505_65585[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (23))){
var inst_65341 = (state_65449[(2)]);
var state_65449__$1 = state_65449;
var statearr_65506_65586 = state_65449__$1;
(statearr_65506_65586[(2)] = inst_65341);

(statearr_65506_65586[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (47))){
var inst_65391 = (state_65449[(2)]);
var state_65449__$1 = state_65449;
var statearr_65507_65587 = state_65449__$1;
(statearr_65507_65587[(2)] = inst_65391);

(statearr_65507_65587[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (35))){
var inst_65373 = (state_65449[(2)]);
var state_65449__$1 = state_65449;
if(cljs.core.truth_(inst_65373)){
var statearr_65508_65588 = state_65449__$1;
(statearr_65508_65588[(1)] = (39));

} else {
var statearr_65509_65589 = state_65449__$1;
(statearr_65509_65589[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (19))){
var inst_65262 = (state_65449[(16)]);
var inst_65316 = cljs.core.sequential_QMARK_(inst_65262);
var state_65449__$1 = state_65449;
if(inst_65316){
var statearr_65510_65590 = state_65449__$1;
(statearr_65510_65590[(1)] = (21));

} else {
var statearr_65511_65591 = state_65449__$1;
(statearr_65511_65591[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (57))){
var inst_65431 = (state_65449[(19)]);
var state_65449__$1 = state_65449;
var statearr_65512_65592 = state_65449__$1;
(statearr_65512_65592[(2)] = inst_65431);

(statearr_65512_65592[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (11))){
var state_65449__$1 = state_65449;
var statearr_65513_65593 = state_65449__$1;
(statearr_65513_65593[(2)] = (-1));

(statearr_65513_65593[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (9))){
var inst_65288 = (state_65449[(2)]);
var state_65449__$1 = state_65449;
if(cljs.core.truth_(inst_65288)){
var statearr_65514_65594 = state_65449__$1;
(statearr_65514_65594[(1)] = (10));

} else {
var statearr_65515_65595 = state_65449__$1;
(statearr_65515_65595[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (5))){
var inst_65275 = (state_65449[(7)]);
var inst_65274 = (state_65449[(2)]);
var inst_65275__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65274,(0),null);
var inst_65276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65274,(1),null);
var inst_65283 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_65449__$1 = (function (){var statearr_65516 = state_65449;
(statearr_65516[(7)] = inst_65275__$1);

(statearr_65516[(27)] = inst_65276);

(statearr_65516[(13)] = inst_65283);

return statearr_65516;
})();
if(cljs.core.truth_(inst_65275__$1)){
var statearr_65517_65596 = state_65449__$1;
(statearr_65517_65596[(1)] = (7));

} else {
var statearr_65518_65597 = state_65449__$1;
(statearr_65518_65597[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (14))){
var inst_65266 = (state_65449[(21)]);
var inst_65276 = (state_65449[(27)]);
var inst_65301 = fluree.db.time_travel.as_of_block(inst_65266,inst_65276);
var state_65449__$1 = state_65449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65449__$1,(17),inst_65301);
} else {
if((state_val_65450 === (45))){
var inst_65353 = (state_65449[(11)]);
var inst_65387 = (inst_65353 == null);
var inst_65388 = cljs.core.not(inst_65387);
var state_65449__$1 = state_65449;
var statearr_65519_65598 = state_65449__$1;
(statearr_65519_65598[(2)] = inst_65388);

(statearr_65519_65598[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (53))){
var inst_65412 = (state_65449[(2)]);
var state_65449__$1 = state_65449;
var statearr_65520_65599 = state_65449__$1;
(statearr_65520_65599[(2)] = inst_65412);

(statearr_65520_65599[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (26))){
var inst_65328 = (state_65449[(2)]);
var state_65449__$1 = state_65449;
var statearr_65521_65600 = state_65449__$1;
(statearr_65521_65600[(2)] = inst_65328);

(statearr_65521_65600[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (16))){
var inst_65262 = (state_65449[(16)]);
var inst_65309 = (state_65449[(2)]);
var inst_65310 = fluree.db.util.core.subj_ident_QMARK_(inst_65262);
var state_65449__$1 = (function (){var statearr_65522 = state_65449;
(statearr_65522[(23)] = inst_65309);

return statearr_65522;
})();
if(inst_65310){
var statearr_65523_65601 = state_65449__$1;
(statearr_65523_65601[(1)] = (18));

} else {
var statearr_65524_65602 = state_65449__$1;
(statearr_65524_65602[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (38))){
var inst_65370 = (state_65449[(2)]);
var state_65449__$1 = state_65449;
var statearr_65525_65603 = state_65449__$1;
(statearr_65525_65603[(2)] = inst_65370);

(statearr_65525_65603[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (30))){
var inst_65343 = (state_65449[(9)]);
var inst_65358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65359 = [inst_65343,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_65360 = (new cljs.core.PersistentVector(null,2,(5),inst_65358,inst_65359,null));
var state_65449__$1 = state_65449;
var statearr_65526_65604 = state_65449__$1;
(statearr_65526_65604[(2)] = inst_65360);

(statearr_65526_65604[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (10))){
var inst_65266 = (state_65449[(21)]);
var inst_65275 = (state_65449[(7)]);
var inst_65290 = (inst_65275 - (1));
var inst_65291 = fluree.db.time_travel.as_of_block(inst_65266,inst_65290);
var state_65449__$1 = state_65449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65449__$1,(13),inst_65291);
} else {
if((state_val_65450 === (18))){
var inst_65262 = (state_65449[(16)]);
var inst_65312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65313 = [inst_65262];
var inst_65314 = (new cljs.core.PersistentVector(null,1,(5),inst_65312,inst_65313,null));
var state_65449__$1 = state_65449;
var statearr_65527_65605 = state_65449__$1;
(statearr_65527_65605[(2)] = inst_65314);

(statearr_65527_65605[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (52))){
var state_65449__$1 = state_65449;
var statearr_65528_65606 = state_65449__$1;
(statearr_65528_65606[(2)] = null);

(statearr_65528_65606[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (42))){
var inst_65352 = (state_65449[(12)]);
var inst_65385 = (state_65449[(20)]);
var inst_65384 = (inst_65352 == null);
var inst_65385__$1 = cljs.core.not(inst_65384);
var state_65449__$1 = (function (){var statearr_65529 = state_65449;
(statearr_65529[(20)] = inst_65385__$1);

return statearr_65529;
})();
if(inst_65385__$1){
var statearr_65530_65607 = state_65449__$1;
(statearr_65530_65607[(1)] = (45));

} else {
var statearr_65531_65608 = state_65449__$1;
(statearr_65531_65608[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (37))){
var inst_65365 = (state_65449[(26)]);
var state_65449__$1 = state_65449;
var statearr_65532_65609 = state_65449__$1;
(statearr_65532_65609[(2)] = inst_65365);

(statearr_65532_65609[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (8))){
var inst_65275 = (state_65449[(7)]);
var state_65449__$1 = state_65449;
var statearr_65533_65610 = state_65449__$1;
(statearr_65533_65610[(2)] = inst_65275);

(statearr_65533_65610[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65450 === (49))){
var state_65449__$1 = state_65449;
var statearr_65534_65611 = state_65449__$1;
(statearr_65534_65611[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_65536 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65536[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_65536[(1)] = (1));

return statearr_65536;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_65449){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65449);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65537){var ex__2736__auto__ = e65537;
var statearr_65538_65612 = state_65449;
(statearr_65538_65612[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65449[(4)]))){
var statearr_65539_65613 = state_65449;
(statearr_65539_65613[(1)] = cljs.core.first((state_65449[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65614 = state_65449;
state_65449 = G__65614;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_65449){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_65449);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65540 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65540[(6)] = c__2755__auto__);

return statearr_65540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__65622 = arguments.length;
switch (G__65622) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5753__auto__)){
var block = temp__5753__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4221__auto__ = block;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4221__auto__ = block;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__65615_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__65615_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65711){
var state_val_65712 = (state_65711[(1)]);
if((state_val_65712 === (7))){
var inst_65662 = (state_65711[(7)]);
var inst_65665 = (state_65711[(8)]);
var inst_65672 = (state_65711[(9)]);
var inst_65668 = (state_65711[(10)]);
var inst_65678 = (function (){var responses = inst_65662;
var responses_STAR_ = inst_65665;
var statuses = inst_65668;
var fuel = inst_65672;
return (function (p1__65618_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__65618_SHARP_);
});
})();
var inst_65679 = cljs.core.some(inst_65678,inst_65668);
var state_65711__$1 = state_65711;
if(cljs.core.truth_(inst_65679)){
var statearr_65713_65761 = state_65711__$1;
(statearr_65713_65761[(1)] = (9));

} else {
var statearr_65714_65762 = state_65711__$1;
(statearr_65714_65762[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (20))){
var inst_65706 = (state_65711[(2)]);
var state_65711__$1 = state_65711;
var statearr_65715_65763 = state_65711__$1;
(statearr_65715_65763[(2)] = inst_65706);

(statearr_65715_65763[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (1))){
var inst_65657 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_65658 = (function (){var c__2755__auto____$1 = inst_65657;
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65655){
var state_val_65656 = (state_65655[(1)]);
if((state_val_65656 === (1))){
var inst_65623 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_65624 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_65625 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65624,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_65626 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_65627 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_65628 = cljs.core.PersistentHashMap.EMPTY;
var inst_65629 = inst_65623;
var inst_65630 = inst_65625;
var inst_65631 = inst_65626;
var inst_65632 = inst_65627;
var inst_65633 = inst_65628;
var state_65655__$1 = (function (){var statearr_65716 = state_65655;
(statearr_65716[(7)] = inst_65632);

(statearr_65716[(8)] = inst_65630);

(statearr_65716[(9)] = inst_65629);

(statearr_65716[(10)] = inst_65633);

(statearr_65716[(11)] = inst_65631);

return statearr_65716;
})();
var statearr_65717_65764 = state_65655__$1;
(statearr_65717_65764[(2)] = null);

(statearr_65717_65764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65656 === (2))){
var inst_65630 = (state_65655[(8)]);
var inst_65635 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_65630);
var inst_65636 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_65635], 0));
var inst_65637 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65630,new cljs.core.Keyword(null,"opts","opts",155075701),inst_65636);
var inst_65638 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_65637,db_fn);
var state_65655__$1 = state_65655;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65655__$1,(4),inst_65638);
} else {
if((state_val_65656 === (3))){
var inst_65653 = (state_65655[(2)]);
var state_65655__$1 = state_65655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65655__$1,inst_65653);
} else {
if((state_val_65656 === (4))){
var inst_65629 = (state_65655[(9)]);
var inst_65633 = (state_65655[(10)]);
var inst_65631 = (state_65655[(11)]);
var inst_65640 = (state_65655[(2)]);
var inst_65641 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65633,inst_65629,inst_65640);
var inst_65642 = cljs.core.first(inst_65631);
var state_65655__$1 = (function (){var statearr_65718 = state_65655;
(statearr_65718[(12)] = inst_65641);

return statearr_65718;
})();
if(cljs.core.truth_(inst_65642)){
var statearr_65719_65765 = state_65655__$1;
(statearr_65719_65765[(1)] = (5));

} else {
var statearr_65720_65766 = state_65655__$1;
(statearr_65720_65766[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65656 === (5))){
var inst_65632 = (state_65655[(7)]);
var inst_65641 = (state_65655[(12)]);
var inst_65631 = (state_65655[(11)]);
var inst_65644 = cljs.core.first(inst_65631);
var inst_65645 = cljs.core.first(inst_65632);
var inst_65646 = cljs.core.rest(inst_65631);
var inst_65647 = cljs.core.rest(inst_65632);
var inst_65629 = inst_65644;
var inst_65630 = inst_65645;
var inst_65631__$1 = inst_65646;
var inst_65632__$1 = inst_65647;
var inst_65633 = inst_65641;
var state_65655__$1 = (function (){var statearr_65721 = state_65655;
(statearr_65721[(7)] = inst_65632__$1);

(statearr_65721[(8)] = inst_65630);

(statearr_65721[(9)] = inst_65629);

(statearr_65721[(10)] = inst_65633);

(statearr_65721[(11)] = inst_65631__$1);

return statearr_65721;
})();
var statearr_65722_65767 = state_65655__$1;
(statearr_65722_65767[(2)] = null);

(statearr_65722_65767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65656 === (6))){
var inst_65641 = (state_65655[(12)]);
var state_65655__$1 = state_65655;
var statearr_65723_65768 = state_65655__$1;
(statearr_65723_65768[(2)] = inst_65641);

(statearr_65723_65768[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65656 === (7))){
var inst_65651 = (state_65655[(2)]);
var state_65655__$1 = state_65655;
var statearr_65724_65769 = state_65655__$1;
(statearr_65724_65769[(2)] = inst_65651);

(statearr_65724_65769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_65725 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65725[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_65725[(1)] = (1));

return statearr_65725;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_65655){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65655);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65726){var ex__2736__auto__ = e65726;
var statearr_65727_65770 = state_65655;
(statearr_65727_65770[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65655[(4)]))){
var statearr_65728_65771 = state_65655;
(statearr_65728_65771[(1)] = cljs.core.first((state_65655[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65772 = state_65655;
state_65655 = G__65772;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_65655){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_65655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65729 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65729[(6)] = c__2755__auto____$1);

return statearr_65729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});
})();
var inst_65659 = cljs.core.async.impl.dispatch.run(inst_65658);
var state_65711__$1 = (function (){var statearr_65730 = state_65711;
(statearr_65730[(11)] = inst_65659);

return statearr_65730;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65711__$1,(2),inst_65657);
} else {
if((state_val_65712 === (4))){
var inst_65662 = (state_65711[(7)]);
var state_65711__$1 = state_65711;
var statearr_65731_65773 = state_65711__$1;
(statearr_65731_65773[(2)] = inst_65662);

(statearr_65731_65773[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (15))){
var state_65711__$1 = state_65711;
var statearr_65732_65774 = state_65711__$1;
(statearr_65732_65774[(2)] = (400));

(statearr_65732_65774[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (13))){
var state_65711__$1 = state_65711;
var statearr_65733_65775 = state_65711__$1;
(statearr_65733_65775[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (6))){
var inst_65668 = (state_65711[(10)]);
var inst_65676 = cljs.core.first(inst_65668);
var state_65711__$1 = state_65711;
var statearr_65735_65776 = state_65711__$1;
(statearr_65735_65776[(2)] = inst_65676);

(statearr_65735_65776[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (17))){
var inst_65689 = (state_65711[(2)]);
var state_65711__$1 = state_65711;
var statearr_65736_65777 = state_65711__$1;
(statearr_65736_65777[(2)] = inst_65689);

(statearr_65736_65777[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (3))){
var inst_65662 = (state_65711[(7)]);
var inst_65665 = (state_65711[(8)]);
var inst_65672 = (state_65711[(9)]);
var inst_65668 = (state_65711[(10)]);
var inst_65667 = cljs.core.vals(inst_65662);
var inst_65668__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_65667);
var inst_65669 = (function (){var responses = inst_65662;
var responses_STAR_ = inst_65665;
var statuses = inst_65668__$1;
return (function (p1__65616_SHARP_){
var or__4223__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__65616_SHARP_);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
});
})();
var inst_65670 = cljs.core.vals(inst_65662);
var inst_65671 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_65669,inst_65670);
var inst_65672__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_65671);
var inst_65673 = (function (){var responses = inst_65662;
var responses_STAR_ = inst_65665;
var statuses = inst_65668__$1;
var fuel = inst_65672__$1;
return (function (p1__65617_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__65617_SHARP_);
});
})();
var inst_65674 = cljs.core.every_QMARK_(inst_65673,inst_65668__$1);
var state_65711__$1 = (function (){var statearr_65737 = state_65711;
(statearr_65737[(9)] = inst_65672__$1);

(statearr_65737[(10)] = inst_65668__$1);

return statearr_65737;
})();
if(inst_65674){
var statearr_65738_65778 = state_65711__$1;
(statearr_65738_65778[(1)] = (6));

} else {
var statearr_65739_65779 = state_65711__$1;
(statearr_65739_65779[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (12))){
var state_65711__$1 = state_65711;
var statearr_65740_65780 = state_65711__$1;
(statearr_65740_65780[(2)] = (500));

(statearr_65740_65780[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (2))){
var inst_65662 = (state_65711[(7)]);
var inst_65661 = (state_65711[(2)]);
var inst_65662__$1 = fluree.db.util.async.throw_err(inst_65661);
var inst_65663 = (function (){var responses = inst_65662__$1;
return (function (acc,index,response){
var resp = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_65664 = cljs.core.PersistentHashMap.EMPTY;
var inst_65665 = cljs.core.reduce_kv(inst_65663,inst_65664,inst_65662__$1);
var state_65711__$1 = (function (){var statearr_65741 = state_65711;
(statearr_65741[(7)] = inst_65662__$1);

(statearr_65741[(8)] = inst_65665);

return statearr_65741;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_65742_65781 = state_65711__$1;
(statearr_65742_65781[(1)] = (3));

} else {
var statearr_65743_65782 = state_65711__$1;
(statearr_65743_65782[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (19))){
var inst_65695 = (state_65711[(12)]);
var inst_65665 = (state_65711[(8)]);
var inst_65672 = (state_65711[(9)]);
var inst_65704 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_65665,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65695,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_65672], 0));
var state_65711__$1 = state_65711;
var statearr_65744_65783 = state_65711__$1;
(statearr_65744_65783[(2)] = inst_65704);

(statearr_65744_65783[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (11))){
var inst_65693 = (state_65711[(2)]);
var state_65711__$1 = state_65711;
var statearr_65745_65784 = state_65711__$1;
(statearr_65745_65784[(2)] = inst_65693);

(statearr_65745_65784[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (9))){
var state_65711__$1 = state_65711;
var statearr_65746_65785 = state_65711__$1;
(statearr_65746_65785[(2)] = (207));

(statearr_65746_65785[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (5))){
var inst_65709 = (state_65711[(2)]);
var state_65711__$1 = state_65711;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65711__$1,inst_65709);
} else {
if((state_val_65712 === (14))){
var inst_65691 = (state_65711[(2)]);
var state_65711__$1 = state_65711;
var statearr_65747_65786 = state_65711__$1;
(statearr_65747_65786[(2)] = inst_65691);

(statearr_65747_65786[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (16))){
var state_65711__$1 = state_65711;
var statearr_65748_65787 = state_65711__$1;
(statearr_65748_65787[(2)] = null);

(statearr_65748_65787[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (10))){
var inst_65662 = (state_65711[(7)]);
var inst_65665 = (state_65711[(8)]);
var inst_65672 = (state_65711[(9)]);
var inst_65668 = (state_65711[(10)]);
var inst_65682 = (function (){var responses = inst_65662;
var responses_STAR_ = inst_65665;
var statuses = inst_65668;
var fuel = inst_65672;
return (function (p1__65619_SHARP_){
return ((499) < p1__65619_SHARP_);
});
})();
var inst_65683 = cljs.core.some(inst_65682,inst_65668);
var state_65711__$1 = state_65711;
if(cljs.core.truth_(inst_65683)){
var statearr_65749_65788 = state_65711__$1;
(statearr_65749_65788[(1)] = (12));

} else {
var statearr_65750_65789 = state_65711__$1;
(statearr_65750_65789[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (18))){
var inst_65695 = (state_65711[(12)]);
var inst_65665 = (state_65711[(8)]);
var inst_65700 = (state_65711[(13)]);
var inst_65672 = (state_65711[(9)]);
var inst_65702 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_65665,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65695,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_65672,new cljs.core.Keyword(null,"block","block",664686210),inst_65700], 0));
var state_65711__$1 = state_65711;
var statearr_65751_65790 = state_65711__$1;
(statearr_65751_65790[(2)] = inst_65702);

(statearr_65751_65790[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65712 === (8))){
var inst_65662 = (state_65711[(7)]);
var inst_65695 = (state_65711[(12)]);
var inst_65665 = (state_65711[(8)]);
var inst_65700 = (state_65711[(13)]);
var inst_65672 = (state_65711[(9)]);
var inst_65668 = (state_65711[(10)]);
var inst_65695__$1 = (state_65711[(2)]);
var inst_65696 = (function (){var responses = inst_65662;
var responses_STAR_ = inst_65665;
var statuses = inst_65668;
var fuel = inst_65672;
var status = inst_65695__$1;
return (function (p1__65620_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__65620_SHARP_));
});
})();
var inst_65697 = cljs.core.vals(inst_65662);
var inst_65698 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_65696,inst_65697);
var inst_65699 = cljs.core.first(inst_65698);
var inst_65700__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_65699);
var state_65711__$1 = (function (){var statearr_65752 = state_65711;
(statearr_65752[(12)] = inst_65695__$1);

(statearr_65752[(13)] = inst_65700__$1);

return statearr_65752;
})();
if(cljs.core.truth_(inst_65700__$1)){
var statearr_65753_65791 = state_65711__$1;
(statearr_65753_65791[(1)] = (18));

} else {
var statearr_65754_65792 = state_65711__$1;
(statearr_65754_65792[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_65755 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65755[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_65755[(1)] = (1));

return statearr_65755;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_65711){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65711);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65756){var ex__2736__auto__ = e65756;
var statearr_65757_65793 = state_65711;
(statearr_65757_65793[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65711[(4)]))){
var statearr_65758_65794 = state_65711;
(statearr_65758_65794[(1)] = cljs.core.first((state_65711[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65795 = state_65711;
state_65711 = G__65795;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_65711){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_65711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65759 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65759[(6)] = c__2755__auto__);

return statearr_65759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__65797 = arguments.length;
switch (G__65797) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__65798 = opts;
var map__65798__$1 = cljs.core.__destructure_map(map__65798);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65798__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65798__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65798__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65798__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__65799 = (cljs.core.truth_((function (){var and__4221__auto__ = auth;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4221__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65799,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65799,(1),null);
var action__$1 = (function (){var or__4223__auto__ = action;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4223__auto__ = nonce;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4223__auto__ = expire;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e65802){var e = e65802;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__65805 = arguments.length;
switch (G__65805) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65836){
var state_val_65837 = (state_65836[(1)]);
if((state_val_65837 === (7))){
var state_65836__$1 = state_65836;
var statearr_65838_65859 = state_65836__$1;
(statearr_65838_65859[(2)] = opts);

(statearr_65838_65859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65837 === (1))){
var state_65836__$1 = state_65836;
var statearr_65839_65860 = state_65836__$1;
(statearr_65839_65860[(2)] = null);

(statearr_65839_65860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65837 === (4))){
var inst_65806 = (state_65836[(2)]);
var inst_65807 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65806], 0));
var inst_65808 = cljs.core.ex_data(inst_65806);
var inst_65809 = cljs.core.ex_message(inst_65806);
var inst_65810 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65808,new cljs.core.Keyword(null,"message","message",-406056002),inst_65809);
var state_65836__$1 = (function (){var statearr_65840 = state_65836;
(statearr_65840[(7)] = inst_65807);

return statearr_65840;
})();
var statearr_65841_65861 = state_65836__$1;
(statearr_65841_65861[(2)] = inst_65810);

(statearr_65841_65861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65837 === (6))){
var inst_65820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65821 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_65822 = (new cljs.core.PersistentVector(null,1,(5),inst_65820,inst_65821,null));
var inst_65823 = cljs.core.assoc_in(opts,inst_65822,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65836__$1 = state_65836;
var statearr_65842_65862 = state_65836__$1;
(statearr_65842_65862[(2)] = inst_65823);

(statearr_65842_65862[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65837 === (3))){
var inst_65834 = (state_65836[(2)]);
var state_65836__$1 = state_65836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65836__$1,inst_65834);
} else {
if((state_val_65837 === (2))){
var _ = (function (){var statearr_65844 = state_65836;
(statearr_65844[(4)] = cljs.core.cons((5),(state_65836[(4)])));

return statearr_65844;
})();
var inst_65816 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65817 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65818 = (inst_65817 == null);
var state_65836__$1 = (function (){var statearr_65845 = state_65836;
(statearr_65845[(8)] = inst_65816);

return statearr_65845;
})();
if(cljs.core.truth_(inst_65818)){
var statearr_65846_65863 = state_65836__$1;
(statearr_65846_65863[(1)] = (6));

} else {
var statearr_65847_65864 = state_65836__$1;
(statearr_65847_65864[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65837 === (9))){
var inst_65830 = (state_65836[(2)]);
var inst_65831 = fluree.db.util.async.throw_err(inst_65830);
var _ = (function (){var statearr_65848 = state_65836;
(statearr_65848[(4)] = cljs.core.rest((state_65836[(4)])));

return statearr_65848;
})();
var state_65836__$1 = state_65836;
var statearr_65849_65865 = state_65836__$1;
(statearr_65849_65865[(2)] = inst_65831);

(statearr_65849_65865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65837 === (5))){
var _ = (function (){var statearr_65850 = state_65836;
(statearr_65850[(4)] = cljs.core.rest((state_65836[(4)])));

return statearr_65850;
})();
var state_65836__$1 = state_65836;
var ex65843 = (state_65836__$1[(2)]);
var statearr_65851_65866 = state_65836__$1;
(statearr_65851_65866[(5)] = ex65843);


var statearr_65852_65867 = state_65836__$1;
(statearr_65852_65867[(1)] = (4));

(statearr_65852_65867[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65837 === (8))){
var inst_65816 = (state_65836[(8)]);
var inst_65826 = (state_65836[(2)]);
var inst_65827 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_65816,inst_65826);
var inst_65828 = fluree.db.operations.command_async(conn,inst_65827);
var state_65836__$1 = state_65836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65836__$1,(9),inst_65828);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2733__auto__ = null;
var fluree$db$api_js$state_machine__2733__auto____0 = (function (){
var statearr_65853 = [null,null,null,null,null,null,null,null,null];
(statearr_65853[(0)] = fluree$db$api_js$state_machine__2733__auto__);

(statearr_65853[(1)] = (1));

return statearr_65853;
});
var fluree$db$api_js$state_machine__2733__auto____1 = (function (state_65836){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65836);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65854){var ex__2736__auto__ = e65854;
var statearr_65855_65868 = state_65836;
(statearr_65855_65868[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65836[(4)]))){
var statearr_65856_65869 = state_65836;
(statearr_65856_65869[(1)] = cljs.core.first((state_65836[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65870 = state_65836;
state_65836 = G__65870;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2733__auto__ = function(state_65836){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2733__auto____1.call(this,state_65836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2733__auto____0;
fluree$db$api_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2733__auto____1;
return fluree$db$api_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65857 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65857[(6)] = c__2755__auto__);

return statearr_65857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

