// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__62310_62479 = cljs.core.seq(servers);
var chunk__62311_62480 = null;
var count__62312_62481 = (0);
var i__62313_62482 = (0);
while(true){
if((i__62313_62482 < count__62312_62481)){
var server_62483 = chunk__62311_62480.cljs$core$IIndexed$_nth$arity$2(null,i__62313_62482);
var healthcheck_uri_62484 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62483),"/fdb/health"].join('');
var resp_chan_62485 = fluree.db.util.xhttp.post_json(healthcheck_uri_62484,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2755__auto___62486 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__62310_62479,chunk__62311_62480,count__62312_62481,i__62313_62482,c__2755__auto___62486,healthcheck_uri_62484,resp_chan_62485,server_62483){
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = ((function (seq__62310_62479,chunk__62311_62480,count__62312_62481,i__62313_62482,c__2755__auto___62486,healthcheck_uri_62484,resp_chan_62485,server_62483){
return (function (state_62374){
var state_val_62375 = (state_62374[(1)]);
if((state_val_62375 === (1))){
var state_62374__$1 = state_62374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62374__$1,(2),resp_chan_62485);
} else {
if((state_val_62375 === (2))){
var inst_62363 = (state_62374[(7)]);
var inst_62363__$1 = (state_62374[(2)]);
var inst_62364 = fluree.db.util.core.exception_QMARK_(inst_62363__$1);
var state_62374__$1 = (function (){var statearr_62376 = state_62374;
(statearr_62376[(7)] = inst_62363__$1);

return statearr_62376;
})();
if(inst_62364){
var statearr_62377_62487 = state_62374__$1;
(statearr_62377_62487[(1)] = (3));

} else {
var statearr_62378_62488 = state_62374__$1;
(statearr_62378_62488[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (3))){
var inst_62363 = (state_62374[(7)]);
var inst_62366 = cljs.core.ex_message(inst_62363);
var inst_62367 = cljs.core.ex_data(inst_62363);
var inst_62368 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_62366,inst_62367], 0));
var state_62374__$1 = state_62374;
var statearr_62379_62489 = state_62374__$1;
(statearr_62379_62489[(2)] = inst_62368);

(statearr_62379_62489[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (4))){
var inst_62370 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_62483);
var state_62374__$1 = state_62374;
var statearr_62380_62490 = state_62374__$1;
(statearr_62380_62490[(2)] = inst_62370);

(statearr_62380_62490[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (5))){
var inst_62372 = (state_62374[(2)]);
var state_62374__$1 = state_62374;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62374__$1,inst_62372);
} else {
return null;
}
}
}
}
}
});})(seq__62310_62479,chunk__62311_62480,count__62312_62481,i__62313_62482,c__2755__auto___62486,healthcheck_uri_62484,resp_chan_62485,server_62483))
;
return ((function (seq__62310_62479,chunk__62311_62480,count__62312_62481,i__62313_62482,switch__2732__auto__,c__2755__auto___62486,healthcheck_uri_62484,resp_chan_62485,server_62483){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0 = (function (){
var statearr_62381 = [null,null,null,null,null,null,null,null];
(statearr_62381[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__);

(statearr_62381[(1)] = (1));

return statearr_62381;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1 = (function (state_62374){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62374);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62382){var ex__2736__auto__ = e62382;
var statearr_62383_62491 = state_62374;
(statearr_62383_62491[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62374[(4)]))){
var statearr_62384_62492 = state_62374;
(statearr_62384_62492[(1)] = cljs.core.first((state_62374[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62493 = state_62374;
state_62374 = G__62493;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__ = function(state_62374){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1.call(this,state_62374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__;
})()
;})(seq__62310_62479,chunk__62311_62480,count__62312_62481,i__62313_62482,switch__2732__auto__,c__2755__auto___62486,healthcheck_uri_62484,resp_chan_62485,server_62483))
})();
var state__2757__auto__ = (function (){var statearr_62385 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62385[(6)] = c__2755__auto___62486);

return statearr_62385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});})(seq__62310_62479,chunk__62311_62480,count__62312_62481,i__62313_62482,c__2755__auto___62486,healthcheck_uri_62484,resp_chan_62485,server_62483))
);



var G__62494 = seq__62310_62479;
var G__62495 = chunk__62311_62480;
var G__62496 = count__62312_62481;
var G__62497 = (i__62313_62482 + (1));
seq__62310_62479 = G__62494;
chunk__62311_62480 = G__62495;
count__62312_62481 = G__62496;
i__62313_62482 = G__62497;
continue;
} else {
var temp__5753__auto___62498 = cljs.core.seq(seq__62310_62479);
if(temp__5753__auto___62498){
var seq__62310_62499__$1 = temp__5753__auto___62498;
if(cljs.core.chunked_seq_QMARK_(seq__62310_62499__$1)){
var c__4649__auto___62500 = cljs.core.chunk_first(seq__62310_62499__$1);
var G__62501 = cljs.core.chunk_rest(seq__62310_62499__$1);
var G__62502 = c__4649__auto___62500;
var G__62503 = cljs.core.count(c__4649__auto___62500);
var G__62504 = (0);
seq__62310_62479 = G__62501;
chunk__62311_62480 = G__62502;
count__62312_62481 = G__62503;
i__62313_62482 = G__62504;
continue;
} else {
var server_62505 = cljs.core.first(seq__62310_62499__$1);
var healthcheck_uri_62506 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62505),"/fdb/health"].join('');
var resp_chan_62507 = fluree.db.util.xhttp.post_json(healthcheck_uri_62506,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2755__auto___62508 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__62310_62479,chunk__62311_62480,count__62312_62481,i__62313_62482,c__2755__auto___62508,healthcheck_uri_62506,resp_chan_62507,server_62505,seq__62310_62499__$1,temp__5753__auto___62498){
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = ((function (seq__62310_62479,chunk__62311_62480,count__62312_62481,i__62313_62482,c__2755__auto___62508,healthcheck_uri_62506,resp_chan_62507,server_62505,seq__62310_62499__$1,temp__5753__auto___62498){
return (function (state_62398){
var state_val_62399 = (state_62398[(1)]);
if((state_val_62399 === (1))){
var state_62398__$1 = state_62398;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62398__$1,(2),resp_chan_62507);
} else {
if((state_val_62399 === (2))){
var inst_62387 = (state_62398[(7)]);
var inst_62387__$1 = (state_62398[(2)]);
var inst_62388 = fluree.db.util.core.exception_QMARK_(inst_62387__$1);
var state_62398__$1 = (function (){var statearr_62400 = state_62398;
(statearr_62400[(7)] = inst_62387__$1);

return statearr_62400;
})();
if(inst_62388){
var statearr_62401_62509 = state_62398__$1;
(statearr_62401_62509[(1)] = (3));

} else {
var statearr_62402_62510 = state_62398__$1;
(statearr_62402_62510[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62399 === (3))){
var inst_62387 = (state_62398[(7)]);
var inst_62390 = cljs.core.ex_message(inst_62387);
var inst_62391 = cljs.core.ex_data(inst_62387);
var inst_62392 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_62390,inst_62391], 0));
var state_62398__$1 = state_62398;
var statearr_62403_62511 = state_62398__$1;
(statearr_62403_62511[(2)] = inst_62392);

(statearr_62403_62511[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62399 === (4))){
var inst_62394 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_62505);
var state_62398__$1 = state_62398;
var statearr_62404_62512 = state_62398__$1;
(statearr_62404_62512[(2)] = inst_62394);

(statearr_62404_62512[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62399 === (5))){
var inst_62396 = (state_62398[(2)]);
var state_62398__$1 = state_62398;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62398__$1,inst_62396);
} else {
return null;
}
}
}
}
}
});})(seq__62310_62479,chunk__62311_62480,count__62312_62481,i__62313_62482,c__2755__auto___62508,healthcheck_uri_62506,resp_chan_62507,server_62505,seq__62310_62499__$1,temp__5753__auto___62498))
;
return ((function (seq__62310_62479,chunk__62311_62480,count__62312_62481,i__62313_62482,switch__2732__auto__,c__2755__auto___62508,healthcheck_uri_62506,resp_chan_62507,server_62505,seq__62310_62499__$1,temp__5753__auto___62498){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0 = (function (){
var statearr_62405 = [null,null,null,null,null,null,null,null];
(statearr_62405[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__);

(statearr_62405[(1)] = (1));

return statearr_62405;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1 = (function (state_62398){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62398);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62406){var ex__2736__auto__ = e62406;
var statearr_62407_62513 = state_62398;
(statearr_62407_62513[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62398[(4)]))){
var statearr_62408_62514 = state_62398;
(statearr_62408_62514[(1)] = cljs.core.first((state_62398[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62515 = state_62398;
state_62398 = G__62515;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__ = function(state_62398){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1.call(this,state_62398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__;
})()
;})(seq__62310_62479,chunk__62311_62480,count__62312_62481,i__62313_62482,switch__2732__auto__,c__2755__auto___62508,healthcheck_uri_62506,resp_chan_62507,server_62505,seq__62310_62499__$1,temp__5753__auto___62498))
})();
var state__2757__auto__ = (function (){var statearr_62409 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62409[(6)] = c__2755__auto___62508);

return statearr_62409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});})(seq__62310_62479,chunk__62311_62480,count__62312_62481,i__62313_62482,c__2755__auto___62508,healthcheck_uri_62506,resp_chan_62507,server_62505,seq__62310_62499__$1,temp__5753__auto___62498))
);



var G__62516 = cljs.core.next(seq__62310_62499__$1);
var G__62517 = null;
var G__62518 = (0);
var G__62519 = (0);
seq__62310_62479 = G__62516;
chunk__62311_62480 = G__62517;
count__62312_62481 = G__62518;
i__62313_62482 = G__62519;
continue;
}
} else {
}
}
break;
}

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62453){
var state_val_62454 = (state_62453[(1)]);
if((state_val_62454 === (7))){
var inst_62425 = (state_62453[(7)]);
var inst_62432 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62425,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_62453__$1 = state_62453;
if(inst_62432){
var statearr_62455_62520 = state_62453__$1;
(statearr_62455_62520[(1)] = (9));

} else {
var statearr_62456_62521 = state_62453__$1;
(statearr_62456_62521[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62454 === (1))){
var inst_62418 = (state_62453[(8)]);
var inst_62417 = (state_62453[(9)]);
var inst_62417__$1 = promise_chan;
var inst_62418__$1 = cljs.core.async.timeout((60000));
var inst_62419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62420 = [inst_62417__$1,inst_62418__$1];
var inst_62421 = (new cljs.core.PersistentVector(null,2,(5),inst_62419,inst_62420,null));
var state_62453__$1 = (function (){var statearr_62457 = state_62453;
(statearr_62457[(8)] = inst_62418__$1);

(statearr_62457[(9)] = inst_62417__$1);

return statearr_62457;
})();
return cljs.core.async.ioc_alts_BANG_(state_62453__$1,(2),inst_62421);
} else {
if((state_val_62454 === (4))){
var inst_62418 = (state_62453[(8)]);
var inst_62425 = (state_62453[(7)]);
var inst_62429 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62425,inst_62418);
var state_62453__$1 = state_62453;
if(inst_62429){
var statearr_62458_62522 = state_62453__$1;
(statearr_62458_62522[(1)] = (6));

} else {
var statearr_62459_62523 = state_62453__$1;
(statearr_62459_62523[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62454 === (13))){
var state_62453__$1 = state_62453;
var statearr_62460_62524 = state_62453__$1;
(statearr_62460_62524[(2)] = null);

(statearr_62460_62524[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62454 === (6))){
var state_62453__$1 = state_62453;
var statearr_62461_62525 = state_62453__$1;
(statearr_62461_62525[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_62461_62525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62454 === (3))){
var state_62453__$1 = state_62453;
var statearr_62462_62526 = state_62453__$1;
(statearr_62462_62526[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_62462_62526[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62454 === (12))){
var inst_62443 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_62444 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62445 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_62446 = cljs.core.PersistentHashMap.fromArrays(inst_62444,inst_62445);
var inst_62447 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_62446);
var inst_62448 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_62447);
var state_62453__$1 = (function (){var statearr_62463 = state_62453;
(statearr_62463[(10)] = inst_62443);

return statearr_62463;
})();
var statearr_62464_62527 = state_62453__$1;
(statearr_62464_62527[(2)] = inst_62448);

(statearr_62464_62527[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62454 === (2))){
var inst_62425 = (state_62453[(7)]);
var inst_62417 = (state_62453[(9)]);
var inst_62423 = (state_62453[(2)]);
var inst_62424 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62423,(0),null);
var inst_62425__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62423,(1),null);
var inst_62426 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62425__$1,inst_62417);
var state_62453__$1 = (function (){var statearr_62465 = state_62453;
(statearr_62465[(11)] = inst_62424);

(statearr_62465[(7)] = inst_62425__$1);

return statearr_62465;
})();
if(inst_62426){
var statearr_62466_62528 = state_62453__$1;
(statearr_62466_62528[(1)] = (3));

} else {
var statearr_62467_62529 = state_62453__$1;
(statearr_62467_62529[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62454 === (11))){
var inst_62436 = (state_62453[(2)]);
var state_62453__$1 = state_62453;
var statearr_62468_62530 = state_62453__$1;
(statearr_62468_62530[(2)] = inst_62436);

(statearr_62468_62530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62454 === (9))){
var inst_62424 = (state_62453[(11)]);
var state_62453__$1 = state_62453;
var statearr_62469_62531 = state_62453__$1;
(statearr_62469_62531[(2)] = inst_62424);

(statearr_62469_62531[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62454 === (5))){
var inst_62440 = (state_62453[(2)]);
var inst_62441 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_62440);
var state_62453__$1 = state_62453;
if(inst_62441){
var statearr_62470_62532 = state_62453__$1;
(statearr_62470_62532[(1)] = (12));

} else {
var statearr_62471_62533 = state_62453__$1;
(statearr_62471_62533[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62454 === (14))){
var inst_62451 = (state_62453[(2)]);
var state_62453__$1 = state_62453;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62453__$1,inst_62451);
} else {
if((state_val_62454 === (10))){
var state_62453__$1 = state_62453;
var statearr_62472_62534 = state_62453__$1;
(statearr_62472_62534[(2)] = null);

(statearr_62472_62534[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62454 === (8))){
var inst_62438 = (state_62453[(2)]);
var state_62453__$1 = state_62453;
var statearr_62473_62535 = state_62453__$1;
(statearr_62473_62535[(2)] = inst_62438);

(statearr_62473_62535[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0 = (function (){
var statearr_62474 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62474[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__);

(statearr_62474[(1)] = (1));

return statearr_62474;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1 = (function (state_62453){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62453);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62475){var ex__2736__auto__ = e62475;
var statearr_62476_62536 = state_62453;
(statearr_62476_62536[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62453[(4)]))){
var statearr_62477_62537 = state_62453;
(statearr_62477_62537[(1)] = cljs.core.first((state_62453[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62538 = state_62453;
state_62453 = G__62538;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__ = function(state_62453){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1.call(this,state_62453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62478 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62478[(6)] = c__2755__auto__);

return statearr_62478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62582){
var state_val_62583 = (state_62582[(1)]);
if((state_val_62583 === (7))){
var state_62582__$1 = state_62582;
var statearr_62584_62610 = state_62582__$1;
(statearr_62584_62610[(2)] = null);

(statearr_62584_62610[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62583 === (1))){
var state_62582__$1 = state_62582;
var statearr_62585_62611 = state_62582__$1;
(statearr_62585_62611[(2)] = null);

(statearr_62585_62611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62583 === (4))){
var inst_62539 = (state_62582[(2)]);
var state_62582__$1 = state_62582;
var statearr_62586_62612 = state_62582__$1;
(statearr_62586_62612[(2)] = inst_62539);

(statearr_62586_62612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62583 === (6))){
var inst_62561 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_62582__$1 = state_62582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62582__$1,(9),inst_62561);
} else {
if((state_val_62583 === (3))){
var inst_62580 = (state_62582[(2)]);
var state_62582__$1 = state_62582;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62582__$1,inst_62580);
} else {
if((state_val_62583 === (12))){
var inst_62574 = (state_62582[(2)]);
var state_62582__$1 = state_62582;
var statearr_62587_62613 = state_62582__$1;
(statearr_62587_62613[(2)] = inst_62574);

(statearr_62587_62613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62583 === (2))){
var inst_62545 = (state_62582[(7)]);
var inst_62555 = (state_62582[(8)]);
var inst_62550 = (state_62582[(9)]);
var _ = (function (){var statearr_62588 = state_62582;
(statearr_62588[(4)] = cljs.core.cons((5),(state_62582[(4)])));

return statearr_62588;
})();
var inst_62545__$1 = fluree.db.util.core.random_uuid();
var inst_62546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62547 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_62548 = (new cljs.core.PersistentVector(null,2,(5),inst_62546,inst_62547,null));
var inst_62549 = (function (){var lock_id = inst_62545__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_62550__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_62548,inst_62549);
var inst_62551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62552 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_62553 = (new cljs.core.PersistentVector(null,3,(5),inst_62551,inst_62552,null));
var inst_62554 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62550__$1,inst_62553);
var inst_62555__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62545__$1,inst_62554);
var inst_62556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62557 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62558 = (new cljs.core.PersistentVector(null,3,(5),inst_62556,inst_62557,null));
var inst_62559 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62550__$1,inst_62558);
var state_62582__$1 = (function (){var statearr_62589 = state_62582;
(statearr_62589[(7)] = inst_62545__$1);

(statearr_62589[(10)] = inst_62559);

(statearr_62589[(8)] = inst_62555__$1);

(statearr_62589[(9)] = inst_62550__$1);

return statearr_62589;
})();
if(inst_62555__$1){
var statearr_62590_62614 = state_62582__$1;
(statearr_62590_62614[(1)] = (6));

} else {
var statearr_62591_62615 = state_62582__$1;
(statearr_62591_62615[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62583 === (11))){
var inst_62566 = (state_62582[(11)]);
var inst_62565 = (state_62582[(12)]);
var inst_62559 = (state_62582[(10)]);
var inst_62572 = fluree.db.util.xhttp.try_socket(inst_62565,sub_chan,pub_chan,inst_62559,(60000),inst_62566);
var state_62582__$1 = state_62582;
var statearr_62593_62616 = state_62582__$1;
(statearr_62593_62616[(2)] = inst_62572);

(statearr_62593_62616[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62583 === (9))){
var inst_62545 = (state_62582[(7)]);
var inst_62565 = (state_62582[(12)]);
var inst_62563 = (state_62582[(13)]);
var inst_62559 = (state_62582[(10)]);
var inst_62555 = (state_62582[(8)]);
var inst_62550 = (state_62582[(9)]);
var inst_62563__$1 = (state_62582[(2)]);
var inst_62564 = clojure.string.replace(inst_62563__$1,"http","ws");
var inst_62565__$1 = [inst_62564,"/fdb/ws"].join('');
var inst_62566 = (function (){var lock_id = inst_62545;
var state = inst_62550;
var have_lock_QMARK_ = inst_62555;
var resp_chan = inst_62559;
var healthy_server = inst_62563__$1;
var ws_url = inst_62565__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_62567 = fluree.db.util.core.exception_QMARK_(inst_62563__$1);
var state_62582__$1 = (function (){var statearr_62594 = state_62582;
(statearr_62594[(11)] = inst_62566);

(statearr_62594[(12)] = inst_62565__$1);

(statearr_62594[(13)] = inst_62563__$1);

return statearr_62594;
})();
if(inst_62567){
var statearr_62595_62617 = state_62582__$1;
(statearr_62595_62617[(1)] = (10));

} else {
var statearr_62596_62618 = state_62582__$1;
(statearr_62596_62618[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62583 === (5))){
var _ = (function (){var statearr_62597 = state_62582;
(statearr_62597[(4)] = cljs.core.rest((state_62582[(4)])));

return statearr_62597;
})();
var state_62582__$1 = state_62582;
var ex62592 = (state_62582__$1[(2)]);
var statearr_62598_62619 = state_62582__$1;
(statearr_62598_62619[(5)] = ex62592);


if((ex62592 instanceof Error)){
var statearr_62599_62620 = state_62582__$1;
(statearr_62599_62620[(1)] = (4));

(statearr_62599_62620[(5)] = null);

} else {
throw ex62592;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62583 === (10))){
var inst_62563 = (state_62582[(13)]);
var inst_62559 = (state_62582[(10)]);
var inst_62569 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_62570 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62559,inst_62563);
var state_62582__$1 = (function (){var statearr_62600 = state_62582;
(statearr_62600[(14)] = inst_62569);

return statearr_62600;
})();
var statearr_62601_62621 = state_62582__$1;
(statearr_62601_62621[(2)] = inst_62570);

(statearr_62601_62621[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62583 === (8))){
var inst_62559 = (state_62582[(10)]);
var inst_62577 = (state_62582[(2)]);
var _ = (function (){var statearr_62602 = state_62582;
(statearr_62602[(4)] = cljs.core.rest((state_62582[(4)])));

return statearr_62602;
})();
var state_62582__$1 = (function (){var statearr_62603 = state_62582;
(statearr_62603[(15)] = inst_62577);

return statearr_62603;
})();
var statearr_62604_62622 = state_62582__$1;
(statearr_62604_62622[(2)] = inst_62559);

(statearr_62604_62622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2733__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2733__auto____0 = (function (){
var statearr_62605 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62605[(0)] = fluree$db$connection$establish_socket_$_state_machine__2733__auto__);

(statearr_62605[(1)] = (1));

return statearr_62605;
});
var fluree$db$connection$establish_socket_$_state_machine__2733__auto____1 = (function (state_62582){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62582);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62606){var ex__2736__auto__ = e62606;
var statearr_62607_62623 = state_62582;
(statearr_62607_62623[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62582[(4)]))){
var statearr_62608_62624 = state_62582;
(statearr_62608_62624[(1)] = cljs.core.first((state_62582[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62625 = state_62582;
state_62582 = G__62625;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2733__auto__ = function(state_62582){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2733__auto____1.call(this,state_62582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2733__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2733__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62609 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62609[(6)] = c__2755__auto__);

return statearr_62609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k62627,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__62631 = k62627;
var G__62631__$1 = (((G__62631 instanceof cljs.core.Keyword))?G__62631.fqn:null);
switch (G__62631__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k62627,else__4475__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__62632){
var vec__62633 = p__62632;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62633,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62633,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__62626){
var self__ = this;
var G__62626__$1 = this;
return (new cljs.core.RecordIter((0),G__62626__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__62636 = (function (coll__4469__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__62636(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this62628,other62629){
var self__ = this;
var this62628__$1 = this;
return (((!((other62629 == null)))) && ((((this62628__$1.constructor === other62629.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.id,other62629.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.servers,other62629.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.state,other62629.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.req_chan,other62629.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.sub_chan,other62629.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.pub_chan,other62629.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.storage_read,other62629.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.storage_write,other62629.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.object_cache,other62629.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.parallelism,other62629.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.serializer,other62629.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.default_network,other62629.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.transactor_QMARK_,other62629.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.publish,other62629.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.transact_handler,other62629.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.tx_private_key,other62629.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.tx_key_id,other62629.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.meta,other62629.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.add_listener,other62629.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.remove_listener,other62629.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.close,other62629.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62628__$1.__extmap,other62629.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k62627){
var self__ = this;
var this__4479__auto____$1 = this;
var G__62637 = k62627;
var G__62637__$1 = (((G__62637 instanceof cljs.core.Keyword))?G__62637.fqn:null);
switch (G__62637__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k62627);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__62626){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__62638 = cljs.core.keyword_identical_QMARK_;
var expr__62639 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__62641 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__62642 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62641,G__62642) : pred__62638.call(null,G__62641,G__62642));
})())){
return (new fluree.db.connection.Connection(G__62626,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62643 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__62644 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62643,G__62644) : pred__62638.call(null,G__62643,G__62644));
})())){
return (new fluree.db.connection.Connection(self__.id,G__62626,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62645 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__62646 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62645,G__62646) : pred__62638.call(null,G__62645,G__62646));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__62626,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62647 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__62648 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62647,G__62648) : pred__62638.call(null,G__62647,G__62648));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__62626,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62649 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__62650 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62649,G__62650) : pred__62638.call(null,G__62649,G__62650));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__62626,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62651 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__62652 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62651,G__62652) : pred__62638.call(null,G__62651,G__62652));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__62626,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62653 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__62654 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62653,G__62654) : pred__62638.call(null,G__62653,G__62654));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__62626,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62655 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__62656 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62655,G__62656) : pred__62638.call(null,G__62655,G__62656));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__62626,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62657 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__62658 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62657,G__62658) : pred__62638.call(null,G__62657,G__62658));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__62626,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62659 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__62660 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62659,G__62660) : pred__62638.call(null,G__62659,G__62660));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__62626,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62661 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__62662 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62661,G__62662) : pred__62638.call(null,G__62661,G__62662));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__62626,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62663 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__62664 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62663,G__62664) : pred__62638.call(null,G__62663,G__62664));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__62626,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62665 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__62666 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62665,G__62666) : pred__62638.call(null,G__62665,G__62666));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__62626,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62667 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__62668 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62667,G__62668) : pred__62638.call(null,G__62667,G__62668));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__62626,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62669 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__62670 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62669,G__62670) : pred__62638.call(null,G__62669,G__62670));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__62626,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62671 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__62672 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62671,G__62672) : pred__62638.call(null,G__62671,G__62672));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__62626,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62673 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__62674 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62673,G__62674) : pred__62638.call(null,G__62673,G__62674));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__62626,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62675 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__62676 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62675,G__62676) : pred__62638.call(null,G__62675,G__62676));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__62626,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62677 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__62678 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62677,G__62678) : pred__62638.call(null,G__62677,G__62678));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__62626,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62679 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__62680 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62679,G__62680) : pred__62638.call(null,G__62679,G__62680));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__62626,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62681 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__62682 = expr__62639;
return (pred__62638.cljs$core$IFn$_invoke$arity$2 ? pred__62638.cljs$core$IFn$_invoke$arity$2(G__62681,G__62682) : pred__62638.call(null,G__62681,G__62682));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__62626,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__62626),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__62626){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__62626,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__62630){
var extmap__4512__auto__ = (function (){var G__62683 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__62630,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__62630)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__62683);
} else {
return G__62683;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__62630),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__62630),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__62689 = servers_STAR_;
var vec__62690 = G__62689;
var seq__62691 = cljs.core.seq(vec__62690);
var first__62692 = cljs.core.first(seq__62691);
var seq__62691__$1 = cljs.core.next(seq__62691);
var server = first__62692;
var r = seq__62691__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__62689__$1 = G__62689;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__62696 = G__62689__$1;
var seq__62697 = cljs.core.seq(vec__62696);
var first__62698 = cljs.core.first(seq__62697);
var seq__62697__$1 = cljs.core.next(seq__62697);
var server__$1 = first__62698;
var r__$1 = seq__62697__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4221__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__62699 = r__$1;
var G__62700 = is_https_QMARK_;
var G__62701 = result_STAR_;
G__62689__$1 = G__62699;
https_QMARK___$1 = G__62700;
result__$1 = G__62701;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__62702 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__62702 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__62702);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62731){
var state_val_62732 = (state_62731[(1)]);
if((state_val_62732 === (7))){
var inst_62717 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62718 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62719 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62720 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62721 = fluree.db.connection.establish_socket(inst_62717,inst_62718,inst_62719,inst_62720);
var state_62731__$1 = state_62731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62731__$1,(9),inst_62721);
} else {
if((state_val_62732 === (1))){
var state_62731__$1 = state_62731;
var statearr_62733_62752 = state_62731__$1;
(statearr_62733_62752[(2)] = null);

(statearr_62733_62752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62732 === (4))){
var inst_62703 = (state_62731[(2)]);
var state_62731__$1 = state_62731;
var statearr_62734_62753 = state_62731__$1;
(statearr_62734_62753[(2)] = inst_62703);

(statearr_62734_62753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62732 === (6))){
var inst_62714 = (state_62731[(7)]);
var state_62731__$1 = state_62731;
var statearr_62735_62754 = state_62731__$1;
(statearr_62735_62754[(2)] = inst_62714);

(statearr_62735_62754[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62732 === (3))){
var inst_62729 = (state_62731[(2)]);
var state_62731__$1 = state_62731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62731__$1,inst_62729);
} else {
if((state_val_62732 === (2))){
var inst_62714 = (state_62731[(7)]);
var _ = (function (){var statearr_62737 = state_62731;
(statearr_62737[(4)] = cljs.core.cons((5),(state_62731[(4)])));

return statearr_62737;
})();
var inst_62709 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_62710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62711 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62712 = [inst_62711,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62713 = (new cljs.core.PersistentVector(null,3,(5),inst_62710,inst_62712,null));
var inst_62714__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62709,inst_62713);
var state_62731__$1 = (function (){var statearr_62738 = state_62731;
(statearr_62738[(7)] = inst_62714__$1);

return statearr_62738;
})();
if(cljs.core.truth_(inst_62714__$1)){
var statearr_62739_62755 = state_62731__$1;
(statearr_62739_62755[(1)] = (6));

} else {
var statearr_62740_62756 = state_62731__$1;
(statearr_62740_62756[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62732 === (9))){
var inst_62723 = (state_62731[(2)]);
var inst_62724 = fluree.db.util.async.throw_err(inst_62723);
var state_62731__$1 = state_62731;
var statearr_62741_62757 = state_62731__$1;
(statearr_62741_62757[(2)] = inst_62724);

(statearr_62741_62757[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62732 === (5))){
var _ = (function (){var statearr_62742 = state_62731;
(statearr_62742[(4)] = cljs.core.rest((state_62731[(4)])));

return statearr_62742;
})();
var state_62731__$1 = state_62731;
var ex62736 = (state_62731__$1[(2)]);
var statearr_62743_62758 = state_62731__$1;
(statearr_62743_62758[(5)] = ex62736);


if((ex62736 instanceof Error)){
var statearr_62744_62759 = state_62731__$1;
(statearr_62744_62759[(1)] = (4));

(statearr_62744_62759[(5)] = null);

} else {
throw ex62736;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62732 === (8))){
var inst_62726 = (state_62731[(2)]);
var _ = (function (){var statearr_62745 = state_62731;
(statearr_62745[(4)] = cljs.core.rest((state_62731[(4)])));

return statearr_62745;
})();
var state_62731__$1 = state_62731;
var statearr_62746_62760 = state_62731__$1;
(statearr_62746_62760[(2)] = inst_62726);

(statearr_62746_62760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2733__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2733__auto____0 = (function (){
var statearr_62747 = [null,null,null,null,null,null,null,null];
(statearr_62747[(0)] = fluree$db$connection$get_socket_$_state_machine__2733__auto__);

(statearr_62747[(1)] = (1));

return statearr_62747;
});
var fluree$db$connection$get_socket_$_state_machine__2733__auto____1 = (function (state_62731){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62731);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62748){var ex__2736__auto__ = e62748;
var statearr_62749_62761 = state_62731;
(statearr_62749_62761[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62731[(4)]))){
var statearr_62750_62762 = state_62731;
(statearr_62750_62762[(1)] = cljs.core.first((state_62731[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62763 = state_62731;
state_62731 = G__62763;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2733__auto__ = function(state_62731){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2733__auto____1.call(this,state_62731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2733__auto____0;
fluree$db$connection$get_socket_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2733__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62751 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62751[(6)] = c__2755__auto__);

return statearr_62751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e62764){var e = e62764;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62891){
var state_val_62892 = (state_62891[(1)]);
if((state_val_62892 === (7))){
var inst_62887 = (state_62891[(2)]);
var state_62891__$1 = state_62891;
var statearr_62894_62964 = state_62891__$1;
(statearr_62894_62964[(2)] = inst_62887);

(statearr_62894_62964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (20))){
var _ = (function (){var statearr_62895 = state_62891;
(statearr_62895[(4)] = cljs.core.rest((state_62891[(4)])));

return statearr_62895;
})();
var state_62891__$1 = state_62891;
var ex62893 = (state_62891__$1[(2)]);
var statearr_62896_62965 = state_62891__$1;
(statearr_62896_62965[(5)] = ex62893);


var statearr_62897_62966 = state_62891__$1;
(statearr_62897_62966[(1)] = (10));

(statearr_62897_62966[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (27))){
var inst_62879 = (state_62891[(2)]);
var _ = (function (){var statearr_62898 = state_62891;
(statearr_62898[(4)] = cljs.core.rest((state_62891[(4)])));

return statearr_62898;
})();
var state_62891__$1 = state_62891;
var statearr_62899_62967 = state_62891__$1;
(statearr_62899_62967[(2)] = inst_62879);

(statearr_62899_62967[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (1))){
var inst_62766 = (0);
var state_62891__$1 = (function (){var statearr_62900 = state_62891;
(statearr_62900[(7)] = inst_62766);

return statearr_62900;
})();
var statearr_62901_62968 = state_62891__$1;
(statearr_62901_62968[(2)] = null);

(statearr_62901_62968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (24))){
var inst_62857 = (state_62891[(8)]);
var inst_62857__$1 = (state_62891[(2)]);
var inst_62858 = inst_62857__$1 === true;
var state_62891__$1 = (function (){var statearr_62902 = state_62891;
(statearr_62902[(8)] = inst_62857__$1);

return statearr_62902;
})();
if(cljs.core.truth_(inst_62858)){
var statearr_62903_62969 = state_62891__$1;
(statearr_62903_62969[(1)] = (25));

} else {
var statearr_62904_62970 = state_62891__$1;
(statearr_62904_62970[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (4))){
var inst_62769 = (state_62891[(9)]);
var inst_62769__$1 = (state_62891[(2)]);
var state_62891__$1 = (function (){var statearr_62905 = state_62891;
(statearr_62905[(9)] = inst_62769__$1);

return statearr_62905;
})();
if(cljs.core.truth_(inst_62769__$1)){
var statearr_62906_62971 = state_62891__$1;
(statearr_62906_62971[(1)] = (5));

} else {
var statearr_62907_62972 = state_62891__$1;
(statearr_62907_62972[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (15))){
var inst_62782 = (state_62891[(10)]);
var state_62891__$1 = state_62891;
var statearr_62908_62973 = state_62891__$1;
(statearr_62908_62973[(2)] = inst_62782);

(statearr_62908_62973[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (21))){
var inst_62810 = (state_62891[(11)]);
var inst_62809 = (state_62891[(12)]);
var inst_62769 = (state_62891[(9)]);
var inst_62805 = (state_62891[(13)]);
var inst_62806 = (state_62891[(14)]);
var inst_62813 = (state_62891[(15)]);
var inst_62766 = (state_62891[(7)]);
var inst_62808 = (state_62891[(16)]);
var inst_62814 = (state_62891[(17)]);
var inst_62807 = (state_62891[(18)]);
var inst_62816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62817 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62813];
var inst_62818 = (new cljs.core.PersistentVector(null,2,(5),inst_62816,inst_62817,null));
var inst_62819 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_62818,inst_62808);
var inst_62846 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_62847 = (function (){var resp_chan = inst_62808;
var timeout = inst_62814;
var i = inst_62766;
var data = inst_62807;
var _ = inst_62805;
var c__2755__auto____$1 = inst_62846;
var req_id = inst_62813;
var operation = inst_62806;
var msg = inst_62769;
var opts = inst_62809;
var map__62804 = inst_62810;
var vec__62801 = inst_62769;
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62844){
var state_val_62845 = (state_62844[(1)]);
if((state_val_62845 === (1))){
var inst_62823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62824 = cljs.core.async.timeout(timeout);
var inst_62825 = [resp_chan,inst_62824];
var inst_62826 = (new cljs.core.PersistentVector(null,2,(5),inst_62823,inst_62825,null));
var state_62844__$1 = state_62844;
return cljs.core.async.ioc_alts_BANG_(state_62844__$1,(2),inst_62826);
} else {
if((state_val_62845 === (2))){
var inst_62829 = (state_62844[(7)]);
var inst_62828 = (state_62844[(2)]);
var inst_62829__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62828,(0),null);
var inst_62830 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62828,(1),null);
var inst_62831 = (function (){var vec__62820 = inst_62828;
var resp = inst_62829__$1;
var c = inst_62830;
return (function (p1__62765_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__62765_SHARP_,req_id);
});
})();
var inst_62832 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62831);
var inst_62833 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62830,resp_chan);
var state_62844__$1 = (function (){var statearr_62909 = state_62844;
(statearr_62909[(8)] = inst_62832);

(statearr_62909[(7)] = inst_62829__$1);

return statearr_62909;
})();
if(inst_62833){
var statearr_62910_62974 = state_62844__$1;
(statearr_62910_62974[(1)] = (3));

} else {
var statearr_62911_62975 = state_62844__$1;
(statearr_62911_62975[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62845 === (3))){
var inst_62829 = (state_62844[(7)]);
var state_62844__$1 = state_62844;
var statearr_62912_62976 = state_62844__$1;
(statearr_62912_62976[(2)] = inst_62829);

(statearr_62912_62976[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62845 === (4))){
var inst_62836 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_62837 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62838 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_62839 = cljs.core.PersistentHashMap.fromArrays(inst_62837,inst_62838);
var inst_62840 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_62836,inst_62839);
var state_62844__$1 = state_62844;
var statearr_62913_62977 = state_62844__$1;
(statearr_62913_62977[(2)] = inst_62840);

(statearr_62913_62977[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62845 === (5))){
var inst_62842 = (state_62844[(2)]);
var state_62844__$1 = state_62844;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62844__$1,inst_62842);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2733__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2733__auto____0 = (function (){
var statearr_62914 = [null,null,null,null,null,null,null,null,null];
(statearr_62914[(0)] = fluree$db$connection$msg_producer_$_state_machine__2733__auto__);

(statearr_62914[(1)] = (1));

return statearr_62914;
});
var fluree$db$connection$msg_producer_$_state_machine__2733__auto____1 = (function (state_62844){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62844);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62915){var ex__2736__auto__ = e62915;
var statearr_62916_62978 = state_62844;
(statearr_62916_62978[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62844[(4)]))){
var statearr_62917_62979 = state_62844;
(statearr_62917_62979[(1)] = cljs.core.first((state_62844[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62980 = state_62844;
state_62844 = G__62980;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2733__auto__ = function(state_62844){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2733__auto____1.call(this,state_62844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2733__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2733__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62918 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62918[(6)] = c__2755__auto____$1);

return statearr_62918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});
})();
var inst_62848 = cljs.core.async.impl.dispatch.run(inst_62847);
var state_62891__$1 = (function (){var statearr_62919 = state_62891;
(statearr_62919[(19)] = inst_62819);

(statearr_62919[(20)] = inst_62848);

return statearr_62919;
})();
var statearr_62920_62981 = state_62891__$1;
(statearr_62920_62981[(2)] = inst_62846);

(statearr_62920_62981[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (31))){
var inst_62867 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_62891__$1 = state_62891;
var statearr_62921_62982 = state_62891__$1;
(statearr_62921_62982[(2)] = inst_62867);

(statearr_62921_62982[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (32))){
var state_62891__$1 = state_62891;
var statearr_62922_62983 = state_62891__$1;
(statearr_62922_62983[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (33))){
var inst_62875 = (state_62891[(2)]);
var state_62891__$1 = state_62891;
var statearr_62924_62984 = state_62891__$1;
(statearr_62924_62984[(2)] = inst_62875);

(statearr_62924_62984[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (13))){
var inst_62782 = (state_62891[(10)]);
var inst_62779 = (state_62891[(2)]);
var inst_62780 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62779,(0),null);
var inst_62781 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62779,(1),null);
var inst_62782__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62779,(2),null);
var state_62891__$1 = (function (){var statearr_62925 = state_62891;
(statearr_62925[(10)] = inst_62782__$1);

(statearr_62925[(21)] = inst_62781);

(statearr_62925[(22)] = inst_62780);

return statearr_62925;
})();
if(cljs.core.truth_(inst_62782__$1)){
var statearr_62926_62985 = state_62891__$1;
(statearr_62926_62985[(1)] = (14));

} else {
var statearr_62927_62986 = state_62891__$1;
(statearr_62927_62986[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (22))){
var state_62891__$1 = state_62891;
var statearr_62928_62987 = state_62891__$1;
(statearr_62928_62987[(2)] = null);

(statearr_62928_62987[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (36))){
var inst_62873 = (state_62891[(2)]);
var state_62891__$1 = state_62891;
var statearr_62929_62988 = state_62891__$1;
(statearr_62929_62988[(2)] = inst_62873);

(statearr_62929_62988[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (29))){
var inst_62857 = (state_62891[(8)]);
var inst_62865 = (inst_62857 == null);
var state_62891__$1 = state_62891;
if(cljs.core.truth_(inst_62865)){
var statearr_62930_62989 = state_62891__$1;
(statearr_62930_62989[(1)] = (31));

} else {
var statearr_62931_62990 = state_62891__$1;
(statearr_62931_62990[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (6))){
var state_62891__$1 = state_62891;
var statearr_62932_62991 = state_62891__$1;
(statearr_62932_62991[(2)] = null);

(statearr_62932_62991[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (28))){
var inst_62857 = (state_62891[(8)]);
var inst_62863 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62857,"Error processing message in producer."], 0));
var state_62891__$1 = state_62891;
var statearr_62933_62992 = state_62891__$1;
(statearr_62933_62992[(2)] = inst_62863);

(statearr_62933_62992[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (25))){
var state_62891__$1 = state_62891;
var statearr_62934_62993 = state_62891__$1;
(statearr_62934_62993[(2)] = null);

(statearr_62934_62993[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (34))){
var inst_62857 = (state_62891[(8)]);
var inst_62870 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_62857], 0));
var state_62891__$1 = state_62891;
var statearr_62935_62994 = state_62891__$1;
(statearr_62935_62994[(2)] = inst_62870);

(statearr_62935_62994[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (17))){
var inst_62771 = (state_62891[(23)]);
var inst_62782 = (state_62891[(10)]);
var inst_62789 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62782,inst_62771);
var state_62891__$1 = state_62891;
var statearr_62936_62995 = state_62891__$1;
(statearr_62936_62995[(2)] = inst_62789);

(statearr_62936_62995[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (3))){
var inst_62889 = (state_62891[(2)]);
var state_62891__$1 = state_62891;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62891__$1,inst_62889);
} else {
if((state_val_62892 === (12))){
var state_62891__$1 = state_62891;
var statearr_62937_62996 = state_62891__$1;
(statearr_62937_62996[(2)] = null);

(statearr_62937_62996[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (2))){
var state_62891__$1 = state_62891;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62891__$1,(4),req_chan);
} else {
if((state_val_62892 === (23))){
var inst_62806 = (state_62891[(14)]);
var inst_62813 = (state_62891[(15)]);
var inst_62807 = (state_62891[(18)]);
var inst_62851 = (state_62891[(2)]);
var inst_62852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62853 = [inst_62806,inst_62813,inst_62807];
var inst_62854 = (new cljs.core.PersistentVector(null,3,(5),inst_62852,inst_62853,null));
var inst_62855 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_62854) : publish_fn.call(null,conn,inst_62854));
var state_62891__$1 = (function (){var statearr_62938 = state_62891;
(statearr_62938[(24)] = inst_62851);

return statearr_62938;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62891__$1,(24),inst_62855);
} else {
if((state_val_62892 === (35))){
var state_62891__$1 = state_62891;
var statearr_62939_62997 = state_62891__$1;
(statearr_62939_62997[(2)] = null);

(statearr_62939_62997[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (19))){
var inst_62795 = (state_62891[(2)]);
var state_62891__$1 = state_62891;
var statearr_62940_62998 = state_62891__$1;
(statearr_62940_62998[(2)] = inst_62795);

(statearr_62940_62998[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (11))){
var inst_62769 = (state_62891[(9)]);
var state_62891__$1 = state_62891;
var statearr_62941_62999 = state_62891__$1;
(statearr_62941_62999[(2)] = inst_62769);

(statearr_62941_62999[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (9))){
var inst_62766 = (state_62891[(7)]);
var inst_62882 = (state_62891[(2)]);
var inst_62883 = (inst_62766 + (1));
var inst_62766__$1 = inst_62883;
var state_62891__$1 = (function (){var statearr_62942 = state_62891;
(statearr_62942[(25)] = inst_62882);

(statearr_62942[(7)] = inst_62766__$1);

return statearr_62942;
})();
var statearr_62943_63000 = state_62891__$1;
(statearr_62943_63000[(2)] = null);

(statearr_62943_63000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (5))){
var state_62891__$1 = state_62891;
var statearr_62944_63001 = state_62891__$1;
(statearr_62944_63001[(2)] = null);

(statearr_62944_63001[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (14))){
var inst_62782 = (state_62891[(10)]);
var inst_62784 = fluree.db.util.async.channel_QMARK_(inst_62782);
var state_62891__$1 = state_62891;
var statearr_62945_63002 = state_62891__$1;
(statearr_62945_63002[(2)] = inst_62784);

(statearr_62945_63002[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (26))){
var inst_62857 = (state_62891[(8)]);
var inst_62861 = fluree.db.util.core.exception_QMARK_(inst_62857);
var state_62891__$1 = state_62891;
if(inst_62861){
var statearr_62946_63003 = state_62891__$1;
(statearr_62946_63003[(1)] = (28));

} else {
var statearr_62947_63004 = state_62891__$1;
(statearr_62947_63004[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (16))){
var inst_62787 = (state_62891[(2)]);
var state_62891__$1 = state_62891;
if(cljs.core.truth_(inst_62787)){
var statearr_62948_63005 = state_62891__$1;
(statearr_62948_63005[(1)] = (17));

} else {
var statearr_62949_63006 = state_62891__$1;
(statearr_62949_63006[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (30))){
var inst_62877 = (state_62891[(2)]);
var state_62891__$1 = state_62891;
var statearr_62950_63007 = state_62891__$1;
(statearr_62950_63007[(2)] = inst_62877);

(statearr_62950_63007[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (10))){
var inst_62769 = (state_62891[(9)]);
var inst_62771 = (state_62891[(2)]);
var inst_62775 = cljs.core.sequential_QMARK_(inst_62769);
var state_62891__$1 = (function (){var statearr_62951 = state_62891;
(statearr_62951[(23)] = inst_62771);

return statearr_62951;
})();
if(inst_62775){
var statearr_62952_63008 = state_62891__$1;
(statearr_62952_63008[(1)] = (11));

} else {
var statearr_62953_63009 = state_62891__$1;
(statearr_62953_63009[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (18))){
var inst_62769 = (state_62891[(9)]);
var inst_62771 = (state_62891[(23)]);
var inst_62791 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62769], 0));
var inst_62792 = ["Error processing ledger request, no valid return channel: ",inst_62791].join('');
var inst_62793 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62771,inst_62792], 0));
var state_62891__$1 = state_62891;
var statearr_62954_63010 = state_62891__$1;
(statearr_62954_63010[(2)] = inst_62793);

(statearr_62954_63010[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62892 === (8))){
var inst_62810 = (state_62891[(11)]);
var inst_62809 = (state_62891[(12)]);
var inst_62769 = (state_62891[(9)]);
var inst_62808 = (state_62891[(16)]);
var _ = (function (){var statearr_62955 = state_62891;
(statearr_62955[(4)] = cljs.core.cons((20),(state_62891[(4)])));

return statearr_62955;
})();
var inst_62805 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_62769], 0));
var inst_62806 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62769,(0),null);
var inst_62807 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62769,(1),null);
var inst_62808__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62769,(2),null);
var inst_62809__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62769,(3),null);
var inst_62810__$1 = cljs.core.__destructure_map(inst_62809__$1);
var inst_62811 = fluree.db.util.core.random_uuid();
var inst_62812 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62811);
var inst_62813 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62810__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_62812);
var inst_62814 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62810__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_62891__$1 = (function (){var statearr_62956 = state_62891;
(statearr_62956[(11)] = inst_62810__$1);

(statearr_62956[(12)] = inst_62809__$1);

(statearr_62956[(13)] = inst_62805);

(statearr_62956[(14)] = inst_62806);

(statearr_62956[(15)] = inst_62813);

(statearr_62956[(16)] = inst_62808__$1);

(statearr_62956[(17)] = inst_62814);

(statearr_62956[(18)] = inst_62807);

return statearr_62956;
})();
if(cljs.core.truth_(inst_62808__$1)){
var statearr_62957_63011 = state_62891__$1;
(statearr_62957_63011[(1)] = (21));

} else {
var statearr_62958_63012 = state_62891__$1;
(statearr_62958_63012[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2733__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2733__auto____0 = (function (){
var statearr_62959 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62959[(0)] = fluree$db$connection$msg_producer_$_state_machine__2733__auto__);

(statearr_62959[(1)] = (1));

return statearr_62959;
});
var fluree$db$connection$msg_producer_$_state_machine__2733__auto____1 = (function (state_62891){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62891);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62960){var ex__2736__auto__ = e62960;
var statearr_62961_63013 = state_62891;
(statearr_62961_63013[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62891[(4)]))){
var statearr_62962_63014 = state_62891;
(statearr_62962_63014[(1)] = cljs.core.first((state_62891[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63015 = state_62891;
state_62891 = G__63015;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2733__auto__ = function(state_62891){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2733__auto____1.call(this,state_62891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2733__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2733__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62963 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62963[(6)] = c__2755__auto__);

return statearr_62963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__63016 = conn;
var map__63016__$1 = cljs.core.__destructure_map(map__63016);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63016__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63098){
var state_val_63099 = (state_63098[(1)]);
if((state_val_63099 === (7))){
var inst_63094 = (state_63098[(2)]);
var state_63098__$1 = state_63098;
var statearr_63100_63151 = state_63098__$1;
(statearr_63100_63151[(2)] = inst_63094);

(statearr_63100_63151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (20))){
var inst_63035 = (state_63098[(7)]);
var inst_63049 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_63050 = [inst_63035];
var inst_63051 = cljs.core.PersistentHashMap.fromArrays(inst_63049,inst_63050);
var inst_63052 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_63051], 0));
var state_63098__$1 = state_63098;
var statearr_63101_63152 = state_63098__$1;
(statearr_63101_63152[(2)] = inst_63052);

(statearr_63101_63152[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (27))){
var state_63098__$1 = state_63098;
var statearr_63102_63153 = state_63098__$1;
(statearr_63102_63153[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (1))){
var inst_63017 = (0);
var state_63098__$1 = (function (){var statearr_63104 = state_63098;
(statearr_63104[(8)] = inst_63017);

return statearr_63104;
})();
var statearr_63105_63154 = state_63098__$1;
(statearr_63105_63154[(2)] = null);

(statearr_63105_63154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (24))){
var inst_63028 = (state_63098[(9)]);
var inst_63077 = fluree.db.util.core.exception_QMARK_(inst_63028);
var state_63098__$1 = state_63098;
if(inst_63077){
var statearr_63106_63155 = state_63098__$1;
(statearr_63106_63155[(1)] = (26));

} else {
var statearr_63107_63156 = state_63098__$1;
(statearr_63107_63156[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (4))){
var inst_63022 = (state_63098[(10)]);
var inst_63027 = (state_63098[(2)]);
var inst_63028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63027,(0),null);
var inst_63029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63027,(1),null);
var inst_63030 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63029,inst_63022);
var state_63098__$1 = (function (){var statearr_63108 = state_63098;
(statearr_63108[(9)] = inst_63028);

return statearr_63108;
})();
if(inst_63030){
var statearr_63109_63157 = state_63098__$1;
(statearr_63109_63157[(1)] = (5));

} else {
var statearr_63110_63158 = state_63098__$1;
(statearr_63110_63158[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (15))){
var inst_63035 = (state_63098[(7)]);
var inst_63044 = typeof inst_63035 === 'string';
var state_63098__$1 = state_63098;
if(cljs.core.truth_(inst_63044)){
var statearr_63111_63159 = state_63098__$1;
(statearr_63111_63159[(1)] = (17));

} else {
var statearr_63112_63160 = state_63098__$1;
(statearr_63112_63160[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (21))){
var state_63098__$1 = state_63098;
var statearr_63113_63161 = state_63098__$1;
(statearr_63113_63161[(2)] = null);

(statearr_63113_63161[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (31))){
var inst_63088 = (state_63098[(2)]);
var state_63098__$1 = state_63098;
var statearr_63114_63162 = state_63098__$1;
(statearr_63114_63162[(2)] = inst_63088);

(statearr_63114_63162[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (13))){
var inst_63061 = (state_63098[(2)]);
var inst_63062 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63063 = fluree.db.connection.close_websocket(inst_63062);
var inst_63064 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63065 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_63064);
var state_63098__$1 = (function (){var statearr_63115 = state_63098;
(statearr_63115[(11)] = inst_63061);

(statearr_63115[(12)] = inst_63063);

return statearr_63115;
})();
var statearr_63116_63163 = state_63098__$1;
(statearr_63116_63163[(2)] = inst_63065);

(statearr_63116_63163[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (22))){
var inst_63055 = (state_63098[(2)]);
var state_63098__$1 = state_63098;
var statearr_63117_63164 = state_63098__$1;
(statearr_63117_63164[(2)] = inst_63055);

(statearr_63117_63164[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (29))){
var inst_63028 = (state_63098[(9)]);
var inst_63083 = fluree.db.util.json.parse(inst_63028);
var inst_63084 = fluree.db.conn_events.process_events(conn,inst_63083);
var inst_63017 = (0);
var state_63098__$1 = (function (){var statearr_63118 = state_63098;
(statearr_63118[(13)] = inst_63084);

(statearr_63118[(8)] = inst_63017);

return statearr_63118;
})();
var statearr_63119_63165 = state_63098__$1;
(statearr_63119_63165[(2)] = null);

(statearr_63119_63165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (6))){
var inst_63028 = (state_63098[(9)]);
var inst_63073 = (inst_63028 == null);
var state_63098__$1 = state_63098;
if(cljs.core.truth_(inst_63073)){
var statearr_63120_63166 = state_63098__$1;
(statearr_63120_63166[(1)] = (23));

} else {
var statearr_63121_63167 = state_63098__$1;
(statearr_63121_63167[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (28))){
var inst_63090 = (state_63098[(2)]);
var state_63098__$1 = state_63098;
var statearr_63122_63168 = state_63098__$1;
(statearr_63122_63168[(2)] = inst_63090);

(statearr_63122_63168[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (25))){
var inst_63092 = (state_63098[(2)]);
var state_63098__$1 = state_63098;
var statearr_63123_63169 = state_63098__$1;
(statearr_63123_63169[(2)] = inst_63092);

(statearr_63123_63169[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (17))){
var inst_63035 = (state_63098[(7)]);
var inst_63046 = cljs.core.eval(inst_63035);
var state_63098__$1 = state_63098;
var statearr_63124_63170 = state_63098__$1;
(statearr_63124_63170[(2)] = inst_63046);

(statearr_63124_63170[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (3))){
var inst_63096 = (state_63098[(2)]);
var state_63098__$1 = state_63098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63098__$1,inst_63096);
} else {
if((state_val_63099 === (12))){
var inst_63035 = (state_63098[(7)]);
var inst_63040 = cljs.core.fn_QMARK_(inst_63035);
var state_63098__$1 = state_63098;
if(inst_63040){
var statearr_63125_63171 = state_63098__$1;
(statearr_63125_63171[(1)] = (14));

} else {
var statearr_63126_63172 = state_63098__$1;
(statearr_63126_63172[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (2))){
var inst_63022 = (state_63098[(10)]);
var inst_63022__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_63023 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63024 = [sub_chan,inst_63022__$1];
var inst_63025 = (new cljs.core.PersistentVector(null,2,(5),inst_63023,inst_63024,null));
var state_63098__$1 = (function (){var statearr_63127 = state_63098;
(statearr_63127[(10)] = inst_63022__$1);

return statearr_63127;
})();
return cljs.core.async.ioc_alts_BANG_(state_63098__$1,(4),inst_63025);
} else {
if((state_val_63099 === (23))){
var inst_63075 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_63098__$1 = state_63098;
var statearr_63128_63173 = state_63098__$1;
(statearr_63128_63173[(2)] = inst_63075);

(statearr_63128_63173[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (19))){
var inst_63057 = (state_63098[(2)]);
var state_63098__$1 = state_63098;
var statearr_63129_63174 = state_63098__$1;
(statearr_63129_63174[(2)] = inst_63057);

(statearr_63129_63174[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (11))){
var inst_63038 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_63098__$1 = state_63098;
var statearr_63130_63175 = state_63098__$1;
(statearr_63130_63175[(2)] = inst_63038);

(statearr_63130_63175[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (9))){
var inst_63017 = (state_63098[(8)]);
var inst_63067 = fluree.db.connection.ping_transactor(conn);
var inst_63068 = (inst_63017 + (1));
var inst_63017__$1 = inst_63068;
var state_63098__$1 = (function (){var statearr_63131 = state_63098;
(statearr_63131[(14)] = inst_63067);

(statearr_63131[(8)] = inst_63017__$1);

return statearr_63131;
})();
var statearr_63132_63176 = state_63098__$1;
(statearr_63132_63176[(2)] = null);

(statearr_63132_63176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (5))){
var inst_63017 = (state_63098[(8)]);
var inst_63032 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_63017);
var state_63098__$1 = state_63098;
if(inst_63032){
var statearr_63133_63177 = state_63098__$1;
(statearr_63133_63177[(1)] = (8));

} else {
var statearr_63134_63178 = state_63098__$1;
(statearr_63134_63178[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (14))){
var inst_63035 = (state_63098[(7)]);
var inst_63042 = (inst_63035.cljs$core$IFn$_invoke$arity$0 ? inst_63035.cljs$core$IFn$_invoke$arity$0() : inst_63035.call(null));
var state_63098__$1 = state_63098;
var statearr_63135_63179 = state_63098__$1;
(statearr_63135_63179[(2)] = inst_63042);

(statearr_63135_63179[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (26))){
var inst_63028 = (state_63098[(9)]);
var inst_63079 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63028], 0));
var inst_63017 = (0);
var state_63098__$1 = (function (){var statearr_63136 = state_63098;
(statearr_63136[(15)] = inst_63079);

(statearr_63136[(8)] = inst_63017);

return statearr_63136;
})();
var statearr_63137_63180 = state_63098__$1;
(statearr_63137_63180[(2)] = null);

(statearr_63137_63180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (16))){
var inst_63059 = (state_63098[(2)]);
var state_63098__$1 = state_63098;
var statearr_63138_63181 = state_63098__$1;
(statearr_63138_63181[(2)] = inst_63059);

(statearr_63138_63181[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (30))){
var state_63098__$1 = state_63098;
var statearr_63139_63182 = state_63098__$1;
(statearr_63139_63182[(2)] = null);

(statearr_63139_63182[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (10))){
var inst_63071 = (state_63098[(2)]);
var state_63098__$1 = state_63098;
var statearr_63140_63183 = state_63098__$1;
(statearr_63140_63183[(2)] = inst_63071);

(statearr_63140_63183[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (18))){
var state_63098__$1 = state_63098;
var statearr_63141_63184 = state_63098__$1;
(statearr_63141_63184[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63099 === (8))){
var inst_63035 = (state_63098[(7)]);
var inst_63034 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_63035__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63036 = (inst_63035__$1 == null);
var state_63098__$1 = (function (){var statearr_63143 = state_63098;
(statearr_63143[(16)] = inst_63034);

(statearr_63143[(7)] = inst_63035__$1);

return statearr_63143;
})();
if(cljs.core.truth_(inst_63036)){
var statearr_63144_63185 = state_63098__$1;
(statearr_63144_63185[(1)] = (11));

} else {
var statearr_63145_63186 = state_63098__$1;
(statearr_63145_63186[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2733__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2733__auto____0 = (function (){
var statearr_63146 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63146[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2733__auto__);

(statearr_63146[(1)] = (1));

return statearr_63146;
});
var fluree$db$connection$msg_consumer_$_state_machine__2733__auto____1 = (function (state_63098){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63098);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63147){var ex__2736__auto__ = e63147;
var statearr_63148_63187 = state_63098;
(statearr_63148_63187[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63098[(4)]))){
var statearr_63149_63188 = state_63098;
(statearr_63149_63188[(1)] = cljs.core.first((state_63098[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63189 = state_63098;
state_63098 = G__63189;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2733__auto__ = function(state_63098){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2733__auto____1.call(this,state_63098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2733__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2733__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63150 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63150[(6)] = c__2755__auto__);

return statearr_63150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__63191 = arguments.length;
switch (G__63191) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__63192 = opts;
var map__63192__$1 = cljs.core.__destructure_map(map__63192);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63192__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63192__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63244){
var state_val_63245 = (state_63244[(1)]);
if((state_val_63245 === (7))){
var inst_63202 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_63203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63204 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63205 = (new cljs.core.PersistentVector(null,2,(5),inst_63203,inst_63204,null));
var inst_63206 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_63202,inst_63205);
var state_63244__$1 = state_63244;
var statearr_63246_63277 = state_63244__$1;
(statearr_63246_63277[(2)] = inst_63206);

(statearr_63246_63277[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63245 === (1))){
var state_63244__$1 = state_63244;
var statearr_63247_63278 = state_63244__$1;
(statearr_63247_63278[(2)] = null);

(statearr_63247_63278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63245 === (4))){
var inst_63193 = (state_63244[(2)]);
var state_63244__$1 = state_63244;
var statearr_63248_63279 = state_63244__$1;
(statearr_63248_63279[(2)] = inst_63193);

(statearr_63248_63279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63245 === (15))){
var inst_63213 = (state_63244[(7)]);
var inst_63232 = (state_63244[(2)]);
var inst_63233 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_63234 = [(5000),inst_63232,new cljs.core.Keyword(null,"text","text",-1790561697)];
var inst_63235 = cljs.core.PersistentHashMap.fromArrays(inst_63233,inst_63234);
var inst_63236 = fluree.db.util.xhttp.get(inst_63213,inst_63235);
var state_63244__$1 = state_63244;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63244__$1,(16),inst_63236);
} else {
if((state_val_63245 === (13))){
var inst_63213 = (state_63244[(7)]);
var inst_63223 = (state_63244[(8)]);
var inst_63225 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_63226 = [inst_63223];
var inst_63227 = cljs.core.PersistentHashMap.fromArrays(inst_63225,inst_63226);
var inst_63228 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_63213,inst_63227,private$);
var inst_63229 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_63228);
var state_63244__$1 = state_63244;
var statearr_63249_63280 = state_63244__$1;
(statearr_63249_63280[(2)] = inst_63229);

(statearr_63249_63280[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63245 === (6))){
var inst_63199 = (state_63244[(9)]);
var state_63244__$1 = state_63244;
var statearr_63250_63281 = state_63244__$1;
(statearr_63250_63281[(2)] = inst_63199);

(statearr_63250_63281[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63245 === (3))){
var inst_63242 = (state_63244[(2)]);
var state_63244__$1 = state_63244;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63244__$1,inst_63242);
} else {
if((state_val_63245 === (12))){
var inst_63223 = (state_63244[(2)]);
var state_63244__$1 = (function (){var statearr_63251 = state_63244;
(statearr_63251[(8)] = inst_63223);

return statearr_63251;
})();
if(cljs.core.truth_(private$)){
var statearr_63252_63282 = state_63244__$1;
(statearr_63252_63282[(1)] = (13));

} else {
var statearr_63253_63283 = state_63244__$1;
(statearr_63253_63283[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63245 === (2))){
var inst_63199 = (state_63244[(9)]);
var _ = (function (){var statearr_63254 = state_63244;
(statearr_63254[(4)] = cljs.core.cons((5),(state_63244[(4)])));

return statearr_63254;
})();
var inst_63199__$1 = jwt;
var state_63244__$1 = (function (){var statearr_63255 = state_63244;
(statearr_63255[(9)] = inst_63199__$1);

return statearr_63255;
})();
if(cljs.core.truth_(inst_63199__$1)){
var statearr_63256_63284 = state_63244__$1;
(statearr_63256_63284[(1)] = (6));

} else {
var statearr_63257_63285 = state_63244__$1;
(statearr_63257_63285[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63245 === (11))){
var inst_63217 = (state_63244[(10)]);
var state_63244__$1 = state_63244;
var statearr_63259_63286 = state_63244__$1;
(statearr_63259_63286[(2)] = inst_63217);

(statearr_63259_63286[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63245 === (9))){
var inst_63208 = (state_63244[(11)]);
var inst_63209 = (state_63244[(12)]);
var inst_63212 = (state_63244[(2)]);
var inst_63213 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63212),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63209)].join('');
var inst_63215 = ["Accept"];
var inst_63216 = ["application/json"];
var inst_63217 = cljs.core.PersistentHashMap.fromArrays(inst_63215,inst_63216);
var state_63244__$1 = (function (){var statearr_63260 = state_63244;
(statearr_63260[(7)] = inst_63213);

(statearr_63260[(10)] = inst_63217);

return statearr_63260;
})();
if(cljs.core.truth_(inst_63208)){
var statearr_63261_63287 = state_63244__$1;
(statearr_63261_63287[(1)] = (10));

} else {
var statearr_63262_63288 = state_63244__$1;
(statearr_63262_63288[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63245 === (5))){
var _ = (function (){var statearr_63263 = state_63244;
(statearr_63263[(4)] = cljs.core.rest((state_63244[(4)])));

return statearr_63263;
})();
var state_63244__$1 = state_63244;
var ex63258 = (state_63244__$1[(2)]);
var statearr_63264_63289 = state_63244__$1;
(statearr_63264_63289[(5)] = ex63258);


if((ex63258 instanceof Error)){
var statearr_63265_63290 = state_63244__$1;
(statearr_63265_63290[(1)] = (4));

(statearr_63265_63290[(5)] = null);

} else {
throw ex63258;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63245 === (14))){
var inst_63223 = (state_63244[(8)]);
var state_63244__$1 = state_63244;
var statearr_63266_63291 = state_63244__$1;
(statearr_63266_63291[(2)] = inst_63223);

(statearr_63266_63291[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63245 === (16))){
var inst_63238 = (state_63244[(2)]);
var inst_63239 = fluree.db.util.async.throw_err(inst_63238);
var _ = (function (){var statearr_63267 = state_63244;
(statearr_63267[(4)] = cljs.core.rest((state_63244[(4)])));

return statearr_63267;
})();
var state_63244__$1 = state_63244;
var statearr_63268_63292 = state_63244__$1;
(statearr_63268_63292[(2)] = inst_63239);

(statearr_63268_63292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63245 === (10))){
var inst_63208 = (state_63244[(11)]);
var inst_63217 = (state_63244[(10)]);
var inst_63219 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63208)].join('');
var inst_63220 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63217,"Authorization",inst_63219);
var state_63244__$1 = state_63244;
var statearr_63269_63293 = state_63244__$1;
(statearr_63269_63293[(2)] = inst_63220);

(statearr_63269_63293[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63245 === (8))){
var inst_63208 = (state_63244[(2)]);
var inst_63209 = clojure.string.replace(k,"_","/");
var inst_63210 = fluree.db.connection.get_server(conn_id,servers);
var state_63244__$1 = (function (){var statearr_63270 = state_63244;
(statearr_63270[(11)] = inst_63208);

(statearr_63270[(12)] = inst_63209);

return statearr_63270;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63244__$1,(9),inst_63210);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2733__auto__ = null;
var fluree$db$connection$state_machine__2733__auto____0 = (function (){
var statearr_63271 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63271[(0)] = fluree$db$connection$state_machine__2733__auto__);

(statearr_63271[(1)] = (1));

return statearr_63271;
});
var fluree$db$connection$state_machine__2733__auto____1 = (function (state_63244){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63244);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63272){var ex__2736__auto__ = e63272;
var statearr_63273_63294 = state_63244;
(statearr_63273_63294[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63244[(4)]))){
var statearr_63274_63295 = state_63244;
(statearr_63274_63295[(1)] = cljs.core.first((state_63244[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63296 = state_63244;
state_63244 = G__63296;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2733__auto__ = function(state_63244){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2733__auto____1.call(this,state_63244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2733__auto____0;
fluree$db$connection$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2733__auto____1;
return fluree$db$connection$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63275 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63275[(6)] = c__2755__auto__);

return statearr_63275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__63297_SHARP_){
if(cljs.core.truth_(p1__63297_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__63298_SHARP_){
var or__4223__auto__ = p1__63298_SHARP_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return token;
}
}));

return true;
}catch (e63299){var e = e63299;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__63300 = opts;
var map__63300__$1 = cljs.core.__destructure_map(map__63300);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63300__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63300__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63300__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63300__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63300__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63300__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63300__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63300__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63300__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63300__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63300__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63300__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63300__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63300__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63300__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63300__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63300__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63300__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63300__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63300__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63300__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63300__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63300__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4223__auto__ = object_cache;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4223__auto__ = storage_read;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4223__auto__ = storage_exists;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = storage_read;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4221__auto__ = storage_write;
if(cljs.core.truth_(and__4221__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__63301_63302 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__63301_63302.cljs$core$IFn$_invoke$arity$0 ? fexpr__63301_63302.cljs$core$IFn$_invoke$arity$0() : fexpr__63301_63302.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4835__auto__ = [];
var len__4829__auto___63343 = arguments.length;
var i__4830__auto___63344 = (0);
while(true){
if((i__4830__auto___63344 < len__4829__auto___63343)){
args__4835__auto__.push((arguments[i__4830__auto___63344]));

var G__63345 = (i__4830__auto___63344 + (1));
i__4830__auto___63344 = G__63345;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__63305){
var vec__63306 = p__63305;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63306,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = new cljs.core.Keyword(null,"dev?","dev?",-613971064).cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2755__auto___63346 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63326){
var state_val_63327 = (state_63326[(1)]);
if((state_val_63327 === (1))){
var inst_63309 = fluree.db.connection.get_socket(conn);
var state_63326__$1 = state_63326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63326__$1,(2),inst_63309);
} else {
if((state_val_63327 === (2))){
var inst_63312 = (state_63326[(7)]);
var inst_63311 = (state_63326[(8)]);
var inst_63311__$1 = (state_63326[(2)]);
var inst_63312__$1 = (inst_63311__$1 == null);
var state_63326__$1 = (function (){var statearr_63328 = state_63326;
(statearr_63328[(7)] = inst_63312__$1);

(statearr_63328[(8)] = inst_63311__$1);

return statearr_63328;
})();
if(cljs.core.truth_(inst_63312__$1)){
var statearr_63329_63347 = state_63326__$1;
(statearr_63329_63347[(1)] = (3));

} else {
var statearr_63330_63348 = state_63326__$1;
(statearr_63330_63348[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (3))){
var inst_63312 = (state_63326[(7)]);
var state_63326__$1 = state_63326;
var statearr_63331_63349 = state_63326__$1;
(statearr_63331_63349[(2)] = inst_63312);

(statearr_63331_63349[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (4))){
var inst_63311 = (state_63326[(8)]);
var inst_63315 = fluree.db.util.core.exception_QMARK_(inst_63311);
var state_63326__$1 = state_63326;
var statearr_63332_63350 = state_63326__$1;
(statearr_63332_63350[(2)] = inst_63315);

(statearr_63332_63350[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (5))){
var inst_63317 = (state_63326[(2)]);
var state_63326__$1 = state_63326;
if(cljs.core.truth_(inst_63317)){
var statearr_63333_63351 = state_63326__$1;
(statearr_63333_63351[(1)] = (6));

} else {
var statearr_63334_63352 = state_63326__$1;
(statearr_63334_63352[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (6))){
var inst_63319 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_63320 = cljs.core.async.close_BANG_(conn);
var state_63326__$1 = (function (){var statearr_63335 = state_63326;
(statearr_63335[(9)] = inst_63319);

return statearr_63335;
})();
var statearr_63336_63353 = state_63326__$1;
(statearr_63336_63353[(2)] = inst_63320);

(statearr_63336_63353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (7))){
var inst_63322 = fluree.db.connection.msg_consumer(conn);
var state_63326__$1 = state_63326;
var statearr_63337_63354 = state_63326__$1;
(statearr_63337_63354[(2)] = inst_63322);

(statearr_63337_63354[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63327 === (8))){
var inst_63324 = (state_63326[(2)]);
var state_63326__$1 = state_63326;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63326__$1,inst_63324);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2733__auto__ = null;
var fluree$db$connection$state_machine__2733__auto____0 = (function (){
var statearr_63338 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63338[(0)] = fluree$db$connection$state_machine__2733__auto__);

(statearr_63338[(1)] = (1));

return statearr_63338;
});
var fluree$db$connection$state_machine__2733__auto____1 = (function (state_63326){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63326);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63339){var ex__2736__auto__ = e63339;
var statearr_63340_63355 = state_63326;
(statearr_63340_63355[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63326[(4)]))){
var statearr_63341_63356 = state_63326;
(statearr_63341_63356[(1)] = cljs.core.first((state_63326[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63357 = state_63326;
state_63326 = G__63357;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2733__auto__ = function(state_63326){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2733__auto____1.call(this,state_63326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2733__auto____0;
fluree$db$connection$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2733__auto____1;
return fluree$db$connection$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63342 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63342[(6)] = c__2755__auto___63346);

return statearr_63342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq63303){
var G__63304 = cljs.core.first(seq63303);
var seq63303__$1 = cljs.core.next(seq63303);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63304,seq63303__$1);
}));

