// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__63368 = arguments.length;
switch (G__63368) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63410){
var state_val_63411 = (state_63410[(1)]);
if((state_val_63411 === (7))){
var inst_63380 = typeof user === 'string';
var state_63410__$1 = state_63410;
if(cljs.core.truth_(inst_63380)){
var statearr_63412_63441 = state_63410__$1;
(statearr_63412_63441[(1)] = (9));

} else {
var statearr_63413_63442 = state_63410__$1;
(statearr_63413_63442[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (1))){
var state_63410__$1 = state_63410;
var statearr_63414_63443 = state_63410__$1;
(statearr_63414_63443[(2)] = null);

(statearr_63414_63443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (4))){
var inst_63369 = (state_63410[(2)]);
var inst_63370 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63369], 0));
var inst_63371 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63369) : reject.call(null,inst_63369));
var state_63410__$1 = (function (){var statearr_63415 = state_63410;
(statearr_63415[(7)] = inst_63370);

return statearr_63415;
})();
var statearr_63416_63444 = state_63410__$1;
(statearr_63416_63444[(2)] = inst_63371);

(statearr_63416_63444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (15))){
var inst_63399 = (state_63410[(2)]);
var inst_63400 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_63399);
var inst_63401 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63402 = cljs.core.constantly(inst_63400);
var inst_63403 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63401,inst_63402);
var inst_63404 = fluree.db.connection.add_token(conn,inst_63400);
var inst_63405 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_63399) : resolve.call(null,inst_63399));
var _ = (function (){var statearr_63417 = state_63410;
(statearr_63417[(4)] = cljs.core.rest((state_63410[(4)])));

return statearr_63417;
})();
var state_63410__$1 = (function (){var statearr_63418 = state_63410;
(statearr_63418[(8)] = inst_63403);

(statearr_63418[(9)] = inst_63404);

return statearr_63418;
})();
var statearr_63419_63445 = state_63410__$1;
(statearr_63419_63445[(2)] = inst_63405);

(statearr_63419_63445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (13))){
var state_63410__$1 = state_63410;
var statearr_63420_63446 = state_63410__$1;
(statearr_63420_63446[(2)] = null);

(statearr_63420_63446[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (6))){
var state_63410__$1 = state_63410;
var statearr_63421_63447 = state_63410__$1;
(statearr_63421_63447[(2)] = user);

(statearr_63421_63447[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (3))){
var inst_63408 = (state_63410[(2)]);
var state_63410__$1 = state_63410;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63410__$1,inst_63408);
} else {
if((state_val_63411 === (12))){
var state_63410__$1 = state_63410;
var statearr_63422_63448 = state_63410__$1;
(statearr_63422_63448[(2)] = user);

(statearr_63422_63448[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (2))){
var _ = (function (){var statearr_63423 = state_63410;
(statearr_63423[(4)] = cljs.core.cons((5),(state_63410[(4)])));

return statearr_63423;
})();
var inst_63377 = typeof user === 'number';
var state_63410__$1 = state_63410;
if(cljs.core.truth_(inst_63377)){
var statearr_63424_63449 = state_63410__$1;
(statearr_63424_63449[(1)] = (6));

} else {
var statearr_63425_63450 = state_63410__$1;
(statearr_63425_63450[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (11))){
var inst_63391 = (state_63410[(2)]);
var state_63410__$1 = state_63410;
var statearr_63427_63451 = state_63410__$1;
(statearr_63427_63451[(2)] = inst_63391);

(statearr_63427_63451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (9))){
var inst_63382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63383 = ["_user/username",user];
var inst_63384 = (new cljs.core.PersistentVector(null,2,(5),inst_63382,inst_63383,null));
var state_63410__$1 = state_63410;
var statearr_63428_63452 = state_63410__$1;
(statearr_63428_63452[(2)] = inst_63384);

(statearr_63428_63452[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (5))){
var _ = (function (){var statearr_63429 = state_63410;
(statearr_63429[(4)] = cljs.core.rest((state_63410[(4)])));

return statearr_63429;
})();
var state_63410__$1 = state_63410;
var ex63426 = (state_63410__$1[(2)]);
var statearr_63430_63453 = state_63410__$1;
(statearr_63430_63453[(5)] = ex63426);


var statearr_63431_63454 = state_63410__$1;
(statearr_63431_63454[(1)] = (4));

(statearr_63431_63454[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (14))){
var inst_63389 = (state_63410[(2)]);
var state_63410__$1 = state_63410;
var statearr_63432_63455 = state_63410__$1;
(statearr_63432_63455[(2)] = inst_63389);

(statearr_63432_63455[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (10))){
var state_63410__$1 = state_63410;
var statearr_63433_63456 = state_63410__$1;
(statearr_63433_63456[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (8))){
var inst_63393 = (state_63410[(2)]);
var inst_63394 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_63395 = [account,inst_63393,password,expireSeconds,syncTo];
var inst_63396 = cljs.core.PersistentHashMap.fromArrays(inst_63394,inst_63395);
var inst_63397 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_63396);
var state_63410__$1 = state_63410;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63410__$1,(15),inst_63397);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_63435 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63435[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_63435[(1)] = (1));

return statearr_63435;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_63410){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63410);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63436){var ex__2736__auto__ = e63436;
var statearr_63437_63457 = state_63410;
(statearr_63437_63457[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63410[(4)]))){
var statearr_63438_63458 = state_63410;
(statearr_63438_63458[(1)] = cljs.core.first((state_63410[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63459 = state_63410;
state_63410 = G__63459;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_63410){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_63410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63439 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63439[(6)] = c__2755__auto__);

return statearr_63439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__63461 = arguments.length;
switch (G__63461) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63470){
var state_val_63471 = (state_63470[(1)]);
if((state_val_63471 === (1))){
var inst_63462 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63464 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_63465 = (new cljs.core.PersistentVector(null,4,(5),inst_63463,inst_63464,null));
var inst_63466 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63462,inst_63465);
var inst_63467 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__63472 = cljs.core.seq(cljs.core.keys(x));
var chunk__63473 = null;
var count__63474 = (0);
var i__63475 = (0);
while(true){
if((i__63475 < count__63474)){
var k = chunk__63473.cljs$core$IIndexed$_nth$arity$2(null,i__63475);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__63483 = seq__63472;
var G__63484 = chunk__63473;
var G__63485 = count__63474;
var G__63486 = (i__63475 + (1));
seq__63472 = G__63483;
chunk__63473 = G__63484;
count__63474 = G__63485;
i__63475 = G__63486;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__63472);
if(temp__5753__auto__){
var seq__63472__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63472__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__63472__$1);
var G__63487 = cljs.core.chunk_rest(seq__63472__$1);
var G__63488 = c__4649__auto__;
var G__63489 = cljs.core.count(c__4649__auto__);
var G__63490 = (0);
seq__63472 = G__63487;
chunk__63473 = G__63488;
count__63474 = G__63489;
i__63475 = G__63490;
continue;
} else {
var k = cljs.core.first(seq__63472__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__63491 = cljs.core.next(seq__63472__$1);
var G__63492 = null;
var G__63493 = (0);
var G__63494 = (0);
seq__63472 = G__63491;
chunk__63473 = G__63492;
count__63474 = G__63493;
i__63475 = G__63494;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_63468 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63467);
var state_63470__$1 = (function (){var statearr_63476 = state_63470;
(statearr_63476[(7)] = inst_63466);

return statearr_63476;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63470__$1,inst_63468);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_63477 = [null,null,null,null,null,null,null,null];
(statearr_63477[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_63477[(1)] = (1));

return statearr_63477;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_63470){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63470);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63478){var ex__2736__auto__ = e63478;
var statearr_63479_63495 = state_63470;
(statearr_63479_63495[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63470[(4)]))){
var statearr_63480_63496 = state_63470;
(statearr_63480_63496[(1)] = cljs.core.first((state_63470[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63497 = state_63470;
state_63470 = G__63497;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_63470){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_63470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63481 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63481[(6)] = c__2755__auto__);

return statearr_63481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__63499 = arguments.length;
switch (G__63499) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63533){
var state_val_63534 = (state_63533[(1)]);
if((state_val_63534 === (1))){
var state_63533__$1 = state_63533;
var statearr_63535_63556 = state_63533__$1;
(statearr_63535_63556[(2)] = null);

(statearr_63535_63556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63534 === (2))){
var _ = (function (){var statearr_63536 = state_63533;
(statearr_63536[(4)] = cljs.core.cons((5),(state_63533[(4)])));

return statearr_63536;
})();
var inst_63508 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_63509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63510 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_63511 = (new cljs.core.PersistentVector(null,1,(5),inst_63509,inst_63510,null));
var inst_63512 = cljs.core.PersistentHashMap.EMPTY;
var inst_63513 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_63512);
var inst_63514 = cljs.core.assoc_in(inst_63508,inst_63511,inst_63513);
var inst_63515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63516 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63517 = (new cljs.core.PersistentVector(null,1,(5),inst_63515,inst_63516,null));
var inst_63518 = cljs.core.PersistentHashMap.EMPTY;
var inst_63519 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_63518);
var inst_63520 = cljs.core.assoc_in(inst_63514,inst_63517,inst_63519);
var inst_63521 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63522 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_63520);
var inst_63523 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63524 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_63521,null];
var inst_63525 = (new cljs.core.PersistentVector(null,4,(5),inst_63523,inst_63524,null));
var inst_63526 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63522,inst_63525);
var inst_63527 = (function (){var conn = inst_63520;
var pc = inst_63521;
return (function (x){
if((x == null)){
} else {
var seq__63537_63557 = cljs.core.seq(cljs.core.keys(x));
var chunk__63538_63558 = null;
var count__63539_63559 = (0);
var i__63540_63560 = (0);
while(true){
if((i__63540_63560 < count__63539_63559)){
var k_63561 = chunk__63538_63558.cljs$core$IIndexed$_nth$arity$2(null,i__63540_63560);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63561], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_63561,null));


var G__63562 = seq__63537_63557;
var G__63563 = chunk__63538_63558;
var G__63564 = count__63539_63559;
var G__63565 = (i__63540_63560 + (1));
seq__63537_63557 = G__63562;
chunk__63538_63558 = G__63563;
count__63539_63559 = G__63564;
i__63540_63560 = G__63565;
continue;
} else {
var temp__5753__auto___63566 = cljs.core.seq(seq__63537_63557);
if(temp__5753__auto___63566){
var seq__63537_63567__$1 = temp__5753__auto___63566;
if(cljs.core.chunked_seq_QMARK_(seq__63537_63567__$1)){
var c__4649__auto___63568 = cljs.core.chunk_first(seq__63537_63567__$1);
var G__63569 = cljs.core.chunk_rest(seq__63537_63567__$1);
var G__63570 = c__4649__auto___63568;
var G__63571 = cljs.core.count(c__4649__auto___63568);
var G__63572 = (0);
seq__63537_63557 = G__63569;
chunk__63538_63558 = G__63570;
count__63539_63559 = G__63571;
i__63540_63560 = G__63572;
continue;
} else {
var k_63573 = cljs.core.first(seq__63537_63567__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63573], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_63573,null));


var G__63574 = cljs.core.next(seq__63537_63567__$1);
var G__63575 = null;
var G__63576 = (0);
var G__63577 = (0);
seq__63537_63557 = G__63574;
chunk__63538_63558 = G__63575;
count__63539_63559 = G__63576;
i__63540_63560 = G__63577;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_63528 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63521,inst_63527);
var ___$1 = (function (){var statearr_63541 = state_63533;
(statearr_63541[(4)] = cljs.core.rest((state_63533[(4)])));

return statearr_63541;
})();
var state_63533__$1 = (function (){var statearr_63542 = state_63533;
(statearr_63542[(7)] = inst_63526);

return statearr_63542;
})();
var statearr_63543_63578 = state_63533__$1;
(statearr_63543_63578[(2)] = inst_63528);

(statearr_63543_63578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63534 === (3))){
var inst_63531 = (state_63533[(2)]);
var state_63533__$1 = state_63533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63533__$1,inst_63531);
} else {
if((state_val_63534 === (4))){
var inst_63500 = (state_63533[(2)]);
var inst_63501 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63500], 0));
var inst_63502 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63500) : reject.call(null,inst_63500));
var state_63533__$1 = (function (){var statearr_63545 = state_63533;
(statearr_63545[(8)] = inst_63501);

return statearr_63545;
})();
var statearr_63546_63579 = state_63533__$1;
(statearr_63546_63579[(2)] = inst_63502);

(statearr_63546_63579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63534 === (5))){
var _ = (function (){var statearr_63547 = state_63533;
(statearr_63547[(4)] = cljs.core.rest((state_63533[(4)])));

return statearr_63547;
})();
var state_63533__$1 = state_63533;
var ex63544 = (state_63533__$1[(2)]);
var statearr_63548_63580 = state_63533__$1;
(statearr_63548_63580[(5)] = ex63544);


var statearr_63549_63581 = state_63533__$1;
(statearr_63549_63581[(1)] = (4));

(statearr_63549_63581[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_63550 = [null,null,null,null,null,null,null,null,null];
(statearr_63550[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_63550[(1)] = (1));

return statearr_63550;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_63533){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63533);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63551){var ex__2736__auto__ = e63551;
var statearr_63552_63582 = state_63533;
(statearr_63552_63582[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63533[(4)]))){
var statearr_63553_63583 = state_63533;
(statearr_63553_63583[(1)] = cljs.core.first((state_63533[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63584 = state_63533;
state_63533 = G__63584;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_63533){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_63533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63554 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63554[(6)] = c__2755__auto__);

return statearr_63554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__63586 = arguments.length;
switch (G__63586) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__63588 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63588,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63588,(1),null);
var cb_STAR_ = (function (header,data){
var G__63591 = cljs.core.clj__GT_js(header);
var G__63592 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__63591,G__63592) : callback.call(null,G__63591,G__63592));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__63593 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63593,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63593,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63646){
var state_val_63647 = (state_63646[(1)]);
if((state_val_63647 === (7))){
var inst_63607 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63608 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63609 = cljs.core.PersistentHashMap.fromArrays(inst_63607,inst_63608);
var inst_63610 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63609);
var inst_63611 = (function(){throw inst_63610})();
var state_63646__$1 = state_63646;
var statearr_63648_63680 = state_63646__$1;
(statearr_63648_63680[(2)] = inst_63611);

(statearr_63648_63680[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63647 === (1))){
var state_63646__$1 = state_63646;
var statearr_63649_63681 = state_63646__$1;
(statearr_63649_63681[(2)] = null);

(statearr_63649_63681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63647 === (4))){
var inst_63596 = (state_63646[(2)]);
var inst_63597 = cljs.core.clj__GT_js(inst_63596);
var inst_63598 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63597) : reject.call(null,inst_63597));
var state_63646__$1 = state_63646;
var statearr_63650_63682 = state_63646__$1;
(statearr_63650_63682[(2)] = inst_63598);

(statearr_63650_63682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63647 === (13))){
var inst_63625 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63626 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63627 = cljs.core.PersistentHashMap.fromArrays(inst_63625,inst_63626);
var inst_63628 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_63627);
var inst_63629 = (function(){throw inst_63628})();
var state_63646__$1 = state_63646;
var statearr_63651_63683 = state_63646__$1;
(statearr_63651_63683[(2)] = inst_63629);

(statearr_63651_63683[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63647 === (6))){
var state_63646__$1 = state_63646;
var statearr_63652_63684 = state_63646__$1;
(statearr_63652_63684[(2)] = null);

(statearr_63652_63684[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63647 === (3))){
var inst_63644 = (state_63646[(2)]);
var state_63646__$1 = state_63646;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63646__$1,inst_63644);
} else {
if((state_val_63647 === (12))){
var state_63646__$1 = state_63646;
var statearr_63653_63685 = state_63646__$1;
(statearr_63653_63685[(2)] = null);

(statearr_63653_63685[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63647 === (2))){
var _ = (function (){var statearr_63654 = state_63646;
(statearr_63654[(4)] = cljs.core.cons((5),(state_63646[(4)])));

return statearr_63654;
})();
var inst_63604 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63646__$1 = state_63646;
if(cljs.core.truth_(inst_63604)){
var statearr_63655_63686 = state_63646__$1;
(statearr_63655_63686[(1)] = (6));

} else {
var statearr_63656_63687 = state_63646__$1;
(statearr_63656_63687[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63647 === (11))){
var inst_63622 = (state_63646[(2)]);
var state_63646__$1 = (function (){var statearr_63658 = state_63646;
(statearr_63658[(7)] = inst_63622);

return statearr_63658;
})();
if(cljs.core.truth_(password)){
var statearr_63659_63688 = state_63646__$1;
(statearr_63659_63688[(1)] = (12));

} else {
var statearr_63660_63689 = state_63646__$1;
(statearr_63660_63689[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63647 === (9))){
var state_63646__$1 = state_63646;
var statearr_63661_63690 = state_63646__$1;
(statearr_63661_63690[(2)] = null);

(statearr_63661_63690[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63647 === (5))){
var _ = (function (){var statearr_63662 = state_63646;
(statearr_63662[(4)] = cljs.core.rest((state_63646[(4)])));

return statearr_63662;
})();
var state_63646__$1 = state_63646;
var ex63657 = (state_63646__$1[(2)]);
var statearr_63663_63691 = state_63646__$1;
(statearr_63663_63691[(5)] = ex63657);


var statearr_63664_63692 = state_63646__$1;
(statearr_63664_63692[(1)] = (4));

(statearr_63664_63692[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63647 === (14))){
var inst_63631 = (state_63646[(2)]);
var inst_63632 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_63633 = fluree.db.util.core.without_nils(inst_63632);
var inst_63634 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63635 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63637 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_63633,inst_63634,null];
var inst_63638 = (new cljs.core.PersistentVector(null,4,(5),inst_63636,inst_63637,null));
var inst_63639 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63635,inst_63638);
var inst_63640 = (function (){var _ = inst_63631;
var data = inst_63633;
var pc = inst_63634;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63665 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63665) : reject.call(null,G__63665));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__63666 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63666) : reject.call(null,G__63666));
} else {
var G__63667 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63667) : resolve.call(null,G__63667));

}
}
});
})();
var inst_63641 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63634,inst_63640);
var _ = (function (){var statearr_63668 = state_63646;
(statearr_63668[(4)] = cljs.core.rest((state_63646[(4)])));

return statearr_63668;
})();
var state_63646__$1 = (function (){var statearr_63669 = state_63646;
(statearr_63669[(8)] = inst_63639);

return statearr_63669;
})();
var statearr_63670_63693 = state_63646__$1;
(statearr_63670_63693[(2)] = inst_63641);

(statearr_63670_63693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63647 === (10))){
var inst_63616 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63617 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63618 = cljs.core.PersistentHashMap.fromArrays(inst_63616,inst_63617);
var inst_63619 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_63618);
var inst_63620 = (function(){throw inst_63619})();
var state_63646__$1 = state_63646;
var statearr_63671_63694 = state_63646__$1;
(statearr_63671_63694[(2)] = inst_63620);

(statearr_63671_63694[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63647 === (8))){
var inst_63613 = (state_63646[(2)]);
var state_63646__$1 = (function (){var statearr_63672 = state_63646;
(statearr_63672[(9)] = inst_63613);

return statearr_63672;
})();
if(cljs.core.truth_(ledger)){
var statearr_63673_63695 = state_63646__$1;
(statearr_63673_63695[(1)] = (9));

} else {
var statearr_63674_63696 = state_63646__$1;
(statearr_63674_63696[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2733__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2733__auto____0 = (function (){
var statearr_63675 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63675[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2733__auto__);

(statearr_63675[(1)] = (1));

return statearr_63675;
});
var fluree$db$connection_js$password_generate_$_state_machine__2733__auto____1 = (function (state_63646){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63646);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63676){var ex__2736__auto__ = e63676;
var statearr_63677_63697 = state_63646;
(statearr_63677_63697[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63646[(4)]))){
var statearr_63678_63698 = state_63646;
(statearr_63678_63698[(1)] = cljs.core.first((state_63646[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63699 = state_63646;
state_63646 = G__63699;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2733__auto__ = function(state_63646){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2733__auto____1.call(this,state_63646);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2733__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2733__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63679 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63679[(6)] = c__2755__auto__);

return statearr_63679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__63701 = arguments.length;
switch (G__63701) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63768){
var state_val_63769 = (state_63768[(1)]);
if((state_val_63769 === (7))){
var inst_63713 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63714 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63715 = cljs.core.PersistentHashMap.fromArrays(inst_63713,inst_63714);
var inst_63716 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63715);
var inst_63717 = (function(){throw inst_63716})();
var state_63768__$1 = state_63768;
var statearr_63770_63812 = state_63768__$1;
(statearr_63770_63812[(2)] = inst_63717);

(statearr_63770_63812[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (20))){
var inst_63751 = (state_63768[(2)]);
var inst_63752 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63753 = [ledger,password,user,auth,expire];
var inst_63754 = cljs.core.PersistentHashMap.fromArrays(inst_63752,inst_63753);
var inst_63755 = fluree.db.util.core.without_nils(inst_63754);
var inst_63756 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63757 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63759 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_63755,inst_63756,null];
var inst_63760 = (new cljs.core.PersistentVector(null,4,(5),inst_63758,inst_63759,null));
var inst_63761 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63757,inst_63760);
var inst_63762 = (function (){var _ = inst_63751;
var data = inst_63755;
var pc = inst_63756;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63771 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63771) : reject.call(null,G__63771));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__63772 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63772) : reject.call(null,G__63772));
} else {
fluree.db.connection.add_token(conn,result);

var G__63773 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63773) : resolve.call(null,G__63773));

}
}
});
})();
var inst_63763 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63756,inst_63762);
var _ = (function (){var statearr_63774 = state_63768;
(statearr_63774[(4)] = cljs.core.rest((state_63768[(4)])));

return statearr_63774;
})();
var state_63768__$1 = (function (){var statearr_63775 = state_63768;
(statearr_63775[(7)] = inst_63761);

return statearr_63775;
})();
var statearr_63776_63813 = state_63768__$1;
(statearr_63776_63813[(2)] = inst_63763);

(statearr_63776_63813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (1))){
var state_63768__$1 = state_63768;
var statearr_63777_63814 = state_63768__$1;
(statearr_63777_63814[(2)] = null);

(statearr_63777_63814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (4))){
var inst_63702 = (state_63768[(2)]);
var inst_63703 = cljs.core.clj__GT_js(inst_63702);
var inst_63704 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63703) : reject.call(null,inst_63703));
var state_63768__$1 = state_63768;
var statearr_63778_63815 = state_63768__$1;
(statearr_63778_63815[(2)] = inst_63704);

(statearr_63778_63815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (15))){
var inst_63738 = (state_63768[(8)]);
var state_63768__$1 = state_63768;
var statearr_63779_63816 = state_63768__$1;
(statearr_63779_63816[(2)] = inst_63738);

(statearr_63779_63816[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (13))){
var inst_63731 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63732 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63733 = cljs.core.PersistentHashMap.fromArrays(inst_63731,inst_63732);
var inst_63734 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_63733);
var inst_63735 = (function(){throw inst_63734})();
var state_63768__$1 = state_63768;
var statearr_63780_63817 = state_63768__$1;
(statearr_63780_63817[(2)] = inst_63735);

(statearr_63780_63817[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (6))){
var state_63768__$1 = state_63768;
var statearr_63781_63818 = state_63768__$1;
(statearr_63781_63818[(2)] = null);

(statearr_63781_63818[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (17))){
var inst_63742 = (state_63768[(2)]);
var state_63768__$1 = state_63768;
if(cljs.core.truth_(inst_63742)){
var statearr_63782_63819 = state_63768__$1;
(statearr_63782_63819[(1)] = (18));

} else {
var statearr_63783_63820 = state_63768__$1;
(statearr_63783_63820[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (3))){
var inst_63766 = (state_63768[(2)]);
var state_63768__$1 = state_63768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63768__$1,inst_63766);
} else {
if((state_val_63769 === (12))){
var state_63768__$1 = state_63768;
var statearr_63784_63821 = state_63768__$1;
(statearr_63784_63821[(2)] = null);

(statearr_63784_63821[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (2))){
var _ = (function (){var statearr_63785 = state_63768;
(statearr_63785[(4)] = cljs.core.cons((5),(state_63768[(4)])));

return statearr_63785;
})();
var inst_63710 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63768__$1 = state_63768;
if(cljs.core.truth_(inst_63710)){
var statearr_63786_63822 = state_63768__$1;
(statearr_63786_63822[(1)] = (6));

} else {
var statearr_63787_63823 = state_63768__$1;
(statearr_63787_63823[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (19))){
var inst_63745 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63746 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63747 = cljs.core.PersistentHashMap.fromArrays(inst_63745,inst_63746);
var inst_63748 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_63747);
var inst_63749 = (function(){throw inst_63748})();
var state_63768__$1 = state_63768;
var statearr_63788_63824 = state_63768__$1;
(statearr_63788_63824[(2)] = inst_63749);

(statearr_63788_63824[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (11))){
var inst_63728 = (state_63768[(2)]);
var state_63768__$1 = (function (){var statearr_63790 = state_63768;
(statearr_63790[(9)] = inst_63728);

return statearr_63790;
})();
if(cljs.core.truth_(password)){
var statearr_63791_63825 = state_63768__$1;
(statearr_63791_63825[(1)] = (12));

} else {
var statearr_63792_63826 = state_63768__$1;
(statearr_63792_63826[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (9))){
var state_63768__$1 = state_63768;
var statearr_63793_63827 = state_63768__$1;
(statearr_63793_63827[(2)] = null);

(statearr_63793_63827[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (5))){
var _ = (function (){var statearr_63794 = state_63768;
(statearr_63794[(4)] = cljs.core.rest((state_63768[(4)])));

return statearr_63794;
})();
var state_63768__$1 = state_63768;
var ex63789 = (state_63768__$1[(2)]);
var statearr_63795_63828 = state_63768__$1;
(statearr_63795_63828[(5)] = ex63789);


var statearr_63796_63829 = state_63768__$1;
(statearr_63796_63829[(1)] = (4));

(statearr_63796_63829[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (14))){
var inst_63738 = (state_63768[(8)]);
var inst_63737 = (state_63768[(2)]);
var inst_63738__$1 = user;
var state_63768__$1 = (function (){var statearr_63797 = state_63768;
(statearr_63797[(10)] = inst_63737);

(statearr_63797[(8)] = inst_63738__$1);

return statearr_63797;
})();
if(cljs.core.truth_(inst_63738__$1)){
var statearr_63798_63830 = state_63768__$1;
(statearr_63798_63830[(1)] = (15));

} else {
var statearr_63799_63831 = state_63768__$1;
(statearr_63799_63831[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (16))){
var state_63768__$1 = state_63768;
var statearr_63800_63832 = state_63768__$1;
(statearr_63800_63832[(2)] = auth);

(statearr_63800_63832[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (10))){
var inst_63722 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63723 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63724 = cljs.core.PersistentHashMap.fromArrays(inst_63722,inst_63723);
var inst_63725 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_63724);
var inst_63726 = (function(){throw inst_63725})();
var state_63768__$1 = state_63768;
var statearr_63801_63833 = state_63768__$1;
(statearr_63801_63833[(2)] = inst_63726);

(statearr_63801_63833[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (18))){
var state_63768__$1 = state_63768;
var statearr_63802_63834 = state_63768__$1;
(statearr_63802_63834[(2)] = null);

(statearr_63802_63834[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63769 === (8))){
var inst_63719 = (state_63768[(2)]);
var state_63768__$1 = (function (){var statearr_63803 = state_63768;
(statearr_63803[(11)] = inst_63719);

return statearr_63803;
})();
if(cljs.core.truth_(ledger)){
var statearr_63804_63835 = state_63768__$1;
(statearr_63804_63835[(1)] = (9));

} else {
var statearr_63805_63836 = state_63768__$1;
(statearr_63805_63836[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_63806 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63806[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_63806[(1)] = (1));

return statearr_63806;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_63768){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63768);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63807){var ex__2736__auto__ = e63807;
var statearr_63808_63837 = state_63768;
(statearr_63808_63837[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63768[(4)]))){
var statearr_63809_63838 = state_63768;
(statearr_63809_63838[(1)] = cljs.core.first((state_63768[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63839 = state_63768;
state_63768 = G__63839;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_63768){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_63768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63810 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63810[(6)] = c__2755__auto__);

return statearr_63810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__63841 = arguments.length;
switch (G__63841) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63876){
var state_val_63877 = (state_63876[(1)]);
if((state_val_63877 === (1))){
var state_63876__$1 = state_63876;
var statearr_63878_63900 = state_63876__$1;
(statearr_63878_63900[(2)] = null);

(statearr_63878_63900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63877 === (2))){
var _ = (function (){var statearr_63879 = state_63876;
(statearr_63879[(4)] = cljs.core.cons((5),(state_63876[(4)])));

return statearr_63879;
})();
var inst_63850 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63876__$1 = state_63876;
if(cljs.core.truth_(inst_63850)){
var statearr_63880_63901 = state_63876__$1;
(statearr_63880_63901[(1)] = (6));

} else {
var statearr_63881_63902 = state_63876__$1;
(statearr_63881_63902[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63877 === (3))){
var inst_63874 = (state_63876[(2)]);
var state_63876__$1 = state_63876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63876__$1,inst_63874);
} else {
if((state_val_63877 === (4))){
var inst_63842 = (state_63876[(2)]);
var inst_63843 = cljs.core.clj__GT_js(inst_63842);
var inst_63844 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63843) : reject.call(null,inst_63843));
var state_63876__$1 = state_63876;
var statearr_63883_63903 = state_63876__$1;
(statearr_63883_63903[(2)] = inst_63844);

(statearr_63883_63903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63877 === (5))){
var _ = (function (){var statearr_63884 = state_63876;
(statearr_63884[(4)] = cljs.core.rest((state_63876[(4)])));

return statearr_63884;
})();
var state_63876__$1 = state_63876;
var ex63882 = (state_63876__$1[(2)]);
var statearr_63885_63904 = state_63876__$1;
(statearr_63885_63904[(5)] = ex63882);


var statearr_63886_63905 = state_63876__$1;
(statearr_63886_63905[(1)] = (4));

(statearr_63886_63905[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63877 === (6))){
var state_63876__$1 = state_63876;
var statearr_63887_63906 = state_63876__$1;
(statearr_63887_63906[(2)] = null);

(statearr_63887_63906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63877 === (7))){
var inst_63853 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63854 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63855 = cljs.core.PersistentHashMap.fromArrays(inst_63853,inst_63854);
var inst_63856 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63855);
var inst_63857 = (function(){throw inst_63856})();
var state_63876__$1 = state_63876;
var statearr_63888_63907 = state_63876__$1;
(statearr_63888_63907[(2)] = inst_63857);

(statearr_63888_63907[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63877 === (8))){
var inst_63859 = (state_63876[(2)]);
var inst_63860 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63861 = [jwt,expire];
var inst_63862 = cljs.core.PersistentHashMap.fromArrays(inst_63860,inst_63861);
var inst_63863 = fluree.db.util.core.without_nils(inst_63862);
var inst_63864 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63865 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63867 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_63863,inst_63864,null];
var inst_63868 = (new cljs.core.PersistentVector(null,4,(5),inst_63866,inst_63867,null));
var inst_63869 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63865,inst_63868);
var inst_63870 = (function (){var _ = inst_63859;
var data = inst_63863;
var pc = inst_63864;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63889 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63889) : reject.call(null,G__63889));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__63890 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63890) : resolve.call(null,G__63890));

}
});
})();
var inst_63871 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63864,inst_63870);
var _ = (function (){var statearr_63891 = state_63876;
(statearr_63891[(4)] = cljs.core.rest((state_63876[(4)])));

return statearr_63891;
})();
var state_63876__$1 = (function (){var statearr_63892 = state_63876;
(statearr_63892[(7)] = inst_63869);

return statearr_63892;
})();
var statearr_63893_63908 = state_63876__$1;
(statearr_63893_63908[(2)] = inst_63871);

(statearr_63893_63908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_63894 = [null,null,null,null,null,null,null,null];
(statearr_63894[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_63894[(1)] = (1));

return statearr_63894;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_63876){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63876);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63895){var ex__2736__auto__ = e63895;
var statearr_63896_63909 = state_63876;
(statearr_63896_63909[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63876[(4)]))){
var statearr_63897_63910 = state_63876;
(statearr_63897_63910[(1)] = cljs.core.first((state_63876[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63911 = state_63876;
state_63876 = G__63911;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_63876){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_63876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63898 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63898[(6)] = c__2755__auto__);

return statearr_63898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

