// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4878__auto___54010 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54061){
var state_val_54062 = (state_54061[(1)]);
if((state_val_54062 === (7))){
var inst_54056 = (state_54061[(2)]);
var _ = (function (){var statearr_54063 = state_54061;
(statearr_54063[(4)] = cljs.core.rest((state_54061[(4)])));

return statearr_54063;
})();
var state_54061__$1 = state_54061;
var statearr_54064_54091 = state_54061__$1;
(statearr_54064_54091[(2)] = inst_54056);

(statearr_54064_54091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (1))){
var state_54061__$1 = state_54061;
var statearr_54065_54092 = state_54061__$1;
(statearr_54065_54092[(2)] = null);

(statearr_54065_54092[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (4))){
var inst_54011 = (state_54061[(2)]);
var state_54061__$1 = state_54061;
var statearr_54066_54093 = state_54061__$1;
(statearr_54066_54093[(2)] = inst_54011);

(statearr_54066_54093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (13))){
var inst_54052 = (state_54061[(2)]);
var state_54061__$1 = state_54061;
var statearr_54067_54094 = state_54061__$1;
(statearr_54067_54094[(2)] = inst_54052);

(statearr_54067_54094[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (6))){
var inst_54029 = (state_54061[(7)]);
var inst_54036 = (state_54061[(8)]);
var inst_54035 = cljs.core.seq(inst_54029);
var inst_54036__$1 = cljs.core.first(inst_54035);
var inst_54037 = cljs.core.next(inst_54035);
var inst_54038 = cljs.core.not(inst_54036__$1);
var state_54061__$1 = (function (){var statearr_54068 = state_54061;
(statearr_54068[(8)] = inst_54036__$1);

(statearr_54068[(9)] = inst_54037);

return statearr_54068;
})();
if(inst_54038){
var statearr_54069_54095 = state_54061__$1;
(statearr_54069_54095[(1)] = (8));

} else {
var statearr_54070_54096 = state_54061__$1;
(statearr_54070_54096[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (3))){
var inst_54059 = (state_54061[(2)]);
var state_54061__$1 = state_54061;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54061__$1,inst_54059);
} else {
if((state_val_54062 === (12))){
var inst_54030 = (state_54061[(10)]);
var inst_54036 = (state_54061[(8)]);
var inst_54037 = (state_54061[(9)]);
var inst_54049 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54030,inst_54036);
var inst_54029 = inst_54037;
var inst_54030__$1 = inst_54049;
var state_54061__$1 = (function (){var statearr_54071 = state_54061;
(statearr_54071[(10)] = inst_54030__$1);

(statearr_54071[(7)] = inst_54029);

return statearr_54071;
})();
var statearr_54072_54097 = state_54061__$1;
(statearr_54072_54097[(2)] = null);

(statearr_54072_54097[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (2))){
var _ = (function (){var statearr_54073 = state_54061;
(statearr_54073[(4)] = cljs.core.cons((5),(state_54061[(4)])));

return statearr_54073;
})();
var inst_54024 = args;
var inst_54025 = cljs.core.seq(inst_54024);
var inst_54026 = cljs.core.first(inst_54025);
var inst_54027 = cljs.core.next(inst_54025);
var inst_54028 = cljs.core.PersistentVector.EMPTY;
var inst_54029 = inst_54024;
var inst_54030 = inst_54028;
var state_54061__$1 = (function (){var statearr_54074 = state_54061;
(statearr_54074[(10)] = inst_54030);

(statearr_54074[(11)] = inst_54026);

(statearr_54074[(7)] = inst_54029);

(statearr_54074[(12)] = inst_54027);

return statearr_54074;
})();
var statearr_54075_54098 = state_54061__$1;
(statearr_54075_54098[(2)] = null);

(statearr_54075_54098[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (11))){
var inst_54036 = (state_54061[(8)]);
var state_54061__$1 = state_54061;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54061__$1,(14),inst_54036);
} else {
if((state_val_54062 === (9))){
var inst_54036 = (state_54061[(8)]);
var inst_54041 = fluree.db.util.async.channel_QMARK_(inst_54036);
var state_54061__$1 = state_54061;
if(inst_54041){
var statearr_54077_54099 = state_54061__$1;
(statearr_54077_54099[(1)] = (11));

} else {
var statearr_54078_54100 = state_54061__$1;
(statearr_54078_54100[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (5))){
var _ = (function (){var statearr_54079 = state_54061;
(statearr_54079[(4)] = cljs.core.rest((state_54061[(4)])));

return statearr_54079;
})();
var state_54061__$1 = state_54061;
var ex54076 = (state_54061__$1[(2)]);
var statearr_54080_54101 = state_54061__$1;
(statearr_54080_54101[(5)] = ex54076);


if((ex54076 instanceof Error)){
var statearr_54081_54102 = state_54061__$1;
(statearr_54081_54102[(1)] = (4));

(statearr_54081_54102[(5)] = null);

} else {
throw ex54076;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (14))){
var inst_54030 = (state_54061[(10)]);
var inst_54037 = (state_54061[(9)]);
var inst_54044 = (state_54061[(2)]);
var inst_54045 = fluree.db.util.async.throw_err(inst_54044);
var inst_54046 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54030,inst_54045);
var inst_54029 = inst_54037;
var inst_54030__$1 = inst_54046;
var state_54061__$1 = (function (){var statearr_54082 = state_54061;
(statearr_54082[(10)] = inst_54030__$1);

(statearr_54082[(7)] = inst_54029);

return statearr_54082;
})();
var statearr_54083_54103 = state_54061__$1;
(statearr_54083_54103[(2)] = null);

(statearr_54083_54103[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (10))){
var inst_54054 = (state_54061[(2)]);
var state_54061__$1 = state_54061;
var statearr_54084_54104 = state_54061__$1;
(statearr_54084_54104[(2)] = inst_54054);

(statearr_54084_54104[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (8))){
var inst_54030 = (state_54061[(10)]);
var state_54061__$1 = state_54061;
var statearr_54085_54105 = state_54061__$1;
(statearr_54085_54105[(2)] = inst_54030);

(statearr_54085_54105[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto____0 = (function (){
var statearr_54086 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54086[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto__);

(statearr_54086[(1)] = (1));

return statearr_54086;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto____1 = (function (state_54061){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54061);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54087){var ex__2736__auto__ = e54087;
var statearr_54088_54106 = state_54061;
(statearr_54088_54106[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54061[(4)]))){
var statearr_54089_54107 = state_54061;
(statearr_54089_54107[(1)] = cljs.core.first((state_54061[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54108 = state_54061;
state_54061 = G__54108;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto__ = function(state_54061){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto____1.call(this,state_54061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54090 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54090[(6)] = c__2755__auto__);

return statearr_54090;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__54109 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54109,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54109,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54157){
var state_val_54158 = (state_54157[(1)]);
if((state_val_54158 === (7))){
var state_54157__$1 = state_54157;
var statearr_54159_54188 = state_54157__$1;
(statearr_54159_54188[(2)] = coll);

(statearr_54159_54188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54158 === (1))){
var state_54157__$1 = state_54157;
var statearr_54160_54189 = state_54157__$1;
(statearr_54160_54189[(2)] = null);

(statearr_54160_54189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54158 === (4))){
var inst_54112 = (state_54157[(2)]);
var state_54157__$1 = state_54157;
var statearr_54161_54190 = state_54157__$1;
(statearr_54161_54190[(2)] = inst_54112);

(statearr_54161_54190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54158 === (15))){
var inst_54131 = (state_54157[(7)]);
var inst_54139 = (state_54157[(2)]);
var inst_54140 = fluree.db.dbfunctions.internal.nth(inst_54131,inst_54139);
var inst_54141 = cljs.core.count(inst_54131);
var inst_54142 = ((9) + inst_54141);
var inst_54143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54144 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54146 = [inst_54131,inst_54139];
var inst_54147 = (new cljs.core.PersistentVector(null,2,(5),inst_54145,inst_54146,null));
var inst_54148 = ["nth",inst_54147,inst_54140];
var inst_54149 = cljs.core.PersistentHashMap.fromArrays(inst_54144,inst_54148);
var inst_54150 = [inst_54149,inst_54142];
var inst_54151 = (new cljs.core.PersistentVector(null,2,(5),inst_54143,inst_54150,null));
var inst_54152 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54151);
var _ = (function (){var statearr_54162 = state_54157;
(statearr_54162[(4)] = cljs.core.rest((state_54157[(4)])));

return statearr_54162;
})();
var state_54157__$1 = (function (){var statearr_54163 = state_54157;
(statearr_54163[(8)] = inst_54152);

return statearr_54163;
})();
var statearr_54164_54191 = state_54157__$1;
(statearr_54164_54191[(2)] = inst_54140);

(statearr_54164_54191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54158 === (13))){
var state_54157__$1 = state_54157;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54157__$1,(16),key);
} else {
if((state_val_54158 === (6))){
var state_54157__$1 = state_54157;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54157__$1,(9),coll);
} else {
if((state_val_54158 === (3))){
var inst_54155 = (state_54157[(2)]);
var state_54157__$1 = state_54157;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54157__$1,inst_54155);
} else {
if((state_val_54158 === (12))){
var inst_54131 = (state_54157[(2)]);
var inst_54132 = fluree.db.util.async.channel_QMARK_(key);
var state_54157__$1 = (function (){var statearr_54165 = state_54157;
(statearr_54165[(7)] = inst_54131);

return statearr_54165;
})();
if(inst_54132){
var statearr_54166_54192 = state_54157__$1;
(statearr_54166_54192[(1)] = (13));

} else {
var statearr_54167_54193 = state_54157__$1;
(statearr_54167_54193[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54158 === (2))){
var _ = (function (){var statearr_54168 = state_54157;
(statearr_54168[(4)] = cljs.core.cons((5),(state_54157[(4)])));

return statearr_54168;
})();
var inst_54118 = fluree.db.util.async.channel_QMARK_(coll);
var state_54157__$1 = state_54157;
if(inst_54118){
var statearr_54169_54194 = state_54157__$1;
(statearr_54169_54194[(1)] = (6));

} else {
var statearr_54170_54195 = state_54157__$1;
(statearr_54170_54195[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54158 === (11))){
var inst_54125 = (state_54157[(9)]);
var state_54157__$1 = state_54157;
var statearr_54172_54196 = state_54157__$1;
(statearr_54172_54196[(2)] = inst_54125);

(statearr_54172_54196[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54158 === (9))){
var inst_54121 = (state_54157[(2)]);
var inst_54122 = fluree.db.util.async.throw_err(inst_54121);
var state_54157__$1 = state_54157;
var statearr_54173_54197 = state_54157__$1;
(statearr_54173_54197[(2)] = inst_54122);

(statearr_54173_54197[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54158 === (5))){
var _ = (function (){var statearr_54174 = state_54157;
(statearr_54174[(4)] = cljs.core.rest((state_54157[(4)])));

return statearr_54174;
})();
var state_54157__$1 = state_54157;
var ex54171 = (state_54157__$1[(2)]);
var statearr_54175_54198 = state_54157__$1;
(statearr_54175_54198[(5)] = ex54171);


if((ex54171 instanceof Error)){
var statearr_54176_54199 = state_54157__$1;
(statearr_54176_54199[(1)] = (4));

(statearr_54176_54199[(5)] = null);

} else {
throw ex54171;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54158 === (14))){
var state_54157__$1 = state_54157;
var statearr_54177_54200 = state_54157__$1;
(statearr_54177_54200[(2)] = key);

(statearr_54177_54200[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54158 === (16))){
var inst_54135 = (state_54157[(2)]);
var inst_54136 = fluree.db.util.async.throw_err(inst_54135);
var state_54157__$1 = state_54157;
var statearr_54178_54201 = state_54157__$1;
(statearr_54178_54201[(2)] = inst_54136);

(statearr_54178_54201[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54158 === (10))){
var inst_54125 = (state_54157[(9)]);
var inst_54128 = cljs.core.vec(inst_54125);
var state_54157__$1 = state_54157;
var statearr_54179_54202 = state_54157__$1;
(statearr_54179_54202[(2)] = inst_54128);

(statearr_54179_54202[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54158 === (8))){
var inst_54125 = (state_54157[(9)]);
var inst_54125__$1 = (state_54157[(2)]);
var inst_54126 = cljs.core.set_QMARK_(inst_54125__$1);
var state_54157__$1 = (function (){var statearr_54180 = state_54157;
(statearr_54180[(9)] = inst_54125__$1);

return statearr_54180;
})();
if(inst_54126){
var statearr_54181_54203 = state_54157__$1;
(statearr_54181_54203[(1)] = (10));

} else {
var statearr_54182_54204 = state_54157__$1;
(statearr_54182_54204[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto____0 = (function (){
var statearr_54183 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54183[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto__);

(statearr_54183[(1)] = (1));

return statearr_54183;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto____1 = (function (state_54157){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54157);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54184){var ex__2736__auto__ = e54184;
var statearr_54185_54205 = state_54157;
(statearr_54185_54205[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54157[(4)]))){
var statearr_54186_54206 = state_54157;
(statearr_54186_54206[(1)] = cljs.core.first((state_54157[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54207 = state_54157;
state_54157 = G__54207;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto__ = function(state_54157){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto____1.call(this,state_54157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54187 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54187[(6)] = c__2755__auto__);

return statearr_54187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54268){
var state_val_54269 = (state_54268[(1)]);
if((state_val_54269 === (7))){
var state_54268__$1 = state_54268;
var statearr_54270_54304 = state_54268__$1;
(statearr_54270_54304[(2)] = test);

(statearr_54270_54304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (20))){
var inst_54242 = (state_54268[(2)]);
var inst_54243 = fluree.db.util.async.throw_err(inst_54242);
var state_54268__$1 = state_54268;
var statearr_54271_54305 = state_54268__$1;
(statearr_54271_54305[(2)] = inst_54243);

(statearr_54271_54305[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (1))){
var state_54268__$1 = state_54268;
var statearr_54272_54306 = state_54268__$1;
(statearr_54272_54306[(2)] = null);

(statearr_54272_54306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (4))){
var inst_54208 = (state_54268[(2)]);
var state_54268__$1 = state_54268;
var statearr_54273_54307 = state_54268__$1;
(statearr_54273_54307[(2)] = inst_54208);

(statearr_54273_54307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (15))){
var inst_54226 = (state_54268[(7)]);
var inst_54234 = (state_54268[(2)]);
var inst_54235 = [inst_54234,f];
var inst_54236 = (new cljs.core.PersistentVector(null,2,(5),inst_54226,inst_54235,null));
var state_54268__$1 = state_54268;
var statearr_54274_54308 = state_54268__$1;
(statearr_54274_54308[(2)] = inst_54236);

(statearr_54274_54308[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (13))){
var state_54268__$1 = state_54268;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54268__$1,(16),t);
} else {
if((state_val_54269 === (6))){
var state_54268__$1 = state_54268;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54268__$1,(9),test);
} else {
if((state_val_54269 === (17))){
var state_54268__$1 = state_54268;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54268__$1,(20),f);
} else {
if((state_val_54269 === (3))){
var inst_54266 = (state_54268[(2)]);
var state_54268__$1 = state_54268;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54268__$1,inst_54266);
} else {
if((state_val_54269 === (12))){
var inst_54224 = (state_54268[(8)]);
var inst_54250 = (state_54268[(2)]);
var inst_54251 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54250,(0),null);
var inst_54252 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54250,(1),null);
var inst_54253 = fluree.db.dbfunctions.internal.if_else(inst_54224,inst_54251,inst_54252);
var inst_54254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54255 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54257 = [inst_54224,inst_54251,inst_54252];
var inst_54258 = (new cljs.core.PersistentVector(null,3,(5),inst_54256,inst_54257,null));
var inst_54259 = ["if-else",inst_54258,inst_54253];
var inst_54260 = cljs.core.PersistentHashMap.fromArrays(inst_54255,inst_54259);
var inst_54261 = [inst_54260,(10)];
var inst_54262 = (new cljs.core.PersistentVector(null,2,(5),inst_54254,inst_54261,null));
var inst_54263 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54262);
var _ = (function (){var statearr_54275 = state_54268;
(statearr_54275[(4)] = cljs.core.rest((state_54268[(4)])));

return statearr_54275;
})();
var state_54268__$1 = (function (){var statearr_54276 = state_54268;
(statearr_54276[(9)] = inst_54263);

return statearr_54276;
})();
var statearr_54277_54309 = state_54268__$1;
(statearr_54277_54309[(2)] = inst_54253);

(statearr_54277_54309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (2))){
var _ = (function (){var statearr_54278 = state_54268;
(statearr_54278[(4)] = cljs.core.cons((5),(state_54268[(4)])));

return statearr_54278;
})();
var inst_54217 = fluree.db.util.async.channel_QMARK_(test);
var state_54268__$1 = state_54268;
if(inst_54217){
var statearr_54279_54310 = state_54268__$1;
(statearr_54279_54310[(1)] = (6));

} else {
var statearr_54280_54311 = state_54268__$1;
(statearr_54280_54311[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (19))){
var inst_54238 = (state_54268[(10)]);
var inst_54246 = (state_54268[(2)]);
var inst_54247 = [f,inst_54246];
var inst_54248 = (new cljs.core.PersistentVector(null,2,(5),inst_54238,inst_54247,null));
var state_54268__$1 = state_54268;
var statearr_54281_54312 = state_54268__$1;
(statearr_54281_54312[(2)] = inst_54248);

(statearr_54281_54312[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (11))){
var inst_54238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54239 = fluree.db.util.async.channel_QMARK_(f);
var state_54268__$1 = (function (){var statearr_54283 = state_54268;
(statearr_54283[(10)] = inst_54238);

return statearr_54283;
})();
if(inst_54239){
var statearr_54284_54313 = state_54268__$1;
(statearr_54284_54313[(1)] = (17));

} else {
var statearr_54285_54314 = state_54268__$1;
(statearr_54285_54314[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (9))){
var inst_54220 = (state_54268[(2)]);
var inst_54221 = fluree.db.util.async.throw_err(inst_54220);
var state_54268__$1 = state_54268;
var statearr_54286_54315 = state_54268__$1;
(statearr_54286_54315[(2)] = inst_54221);

(statearr_54286_54315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (5))){
var _ = (function (){var statearr_54287 = state_54268;
(statearr_54287[(4)] = cljs.core.rest((state_54268[(4)])));

return statearr_54287;
})();
var state_54268__$1 = state_54268;
var ex54282 = (state_54268__$1[(2)]);
var statearr_54288_54316 = state_54268__$1;
(statearr_54288_54316[(5)] = ex54282);


if((ex54282 instanceof Error)){
var statearr_54289_54317 = state_54268__$1;
(statearr_54289_54317[(1)] = (4));

(statearr_54289_54317[(5)] = null);

} else {
throw ex54282;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (14))){
var state_54268__$1 = state_54268;
var statearr_54290_54318 = state_54268__$1;
(statearr_54290_54318[(2)] = t);

(statearr_54290_54318[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (16))){
var inst_54230 = (state_54268[(2)]);
var inst_54231 = fluree.db.util.async.throw_err(inst_54230);
var state_54268__$1 = state_54268;
var statearr_54291_54319 = state_54268__$1;
(statearr_54291_54319[(2)] = inst_54231);

(statearr_54291_54319[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (10))){
var inst_54226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54227 = fluree.db.util.async.channel_QMARK_(t);
var state_54268__$1 = (function (){var statearr_54292 = state_54268;
(statearr_54292[(7)] = inst_54226);

return statearr_54292;
})();
if(inst_54227){
var statearr_54293_54320 = state_54268__$1;
(statearr_54293_54320[(1)] = (13));

} else {
var statearr_54294_54321 = state_54268__$1;
(statearr_54294_54321[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (18))){
var state_54268__$1 = state_54268;
var statearr_54295_54322 = state_54268__$1;
(statearr_54295_54322[(2)] = f);

(statearr_54295_54322[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54269 === (8))){
var inst_54224 = (state_54268[(8)]);
var inst_54224__$1 = (state_54268[(2)]);
var state_54268__$1 = (function (){var statearr_54296 = state_54268;
(statearr_54296[(8)] = inst_54224__$1);

return statearr_54296;
})();
if(cljs.core.truth_(inst_54224__$1)){
var statearr_54297_54323 = state_54268__$1;
(statearr_54297_54323[(1)] = (10));

} else {
var statearr_54298_54324 = state_54268__$1;
(statearr_54298_54324[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto____0 = (function (){
var statearr_54299 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54299[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto__);

(statearr_54299[(1)] = (1));

return statearr_54299;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto____1 = (function (state_54268){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54268);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54300){var ex__2736__auto__ = e54300;
var statearr_54301_54325 = state_54268;
(statearr_54301_54325[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54268[(4)]))){
var statearr_54302_54326 = state_54268;
(statearr_54302_54326[(1)] = cljs.core.first((state_54268[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54327 = state_54268;
state_54268 = G__54327;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto__ = function(state_54268){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto____1.call(this,state_54268);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54303 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54303[(6)] = c__2755__auto__);

return statearr_54303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54357){
var state_val_54358 = (state_54357[(1)]);
if((state_val_54358 === (7))){
var state_54357__$1 = state_54357;
var statearr_54359_54378 = state_54357__$1;
(statearr_54359_54378[(2)] = arg);

(statearr_54359_54378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54358 === (1))){
var state_54357__$1 = state_54357;
var statearr_54360_54379 = state_54357__$1;
(statearr_54360_54379[(2)] = null);

(statearr_54360_54379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54358 === (4))){
var inst_54328 = (state_54357[(2)]);
var state_54357__$1 = state_54357;
var statearr_54361_54380 = state_54357__$1;
(statearr_54361_54380[(2)] = inst_54328);

(statearr_54361_54380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54358 === (6))){
var state_54357__$1 = state_54357;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54357__$1,(9),arg);
} else {
if((state_val_54358 === (3))){
var inst_54355 = (state_54357[(2)]);
var state_54357__$1 = state_54357;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54357__$1,inst_54355);
} else {
if((state_val_54358 === (2))){
var _ = (function (){var statearr_54363 = state_54357;
(statearr_54363[(4)] = cljs.core.cons((5),(state_54357[(4)])));

return statearr_54363;
})();
var inst_54334 = fluree.db.util.async.channel_QMARK_(arg);
var state_54357__$1 = state_54357;
if(inst_54334){
var statearr_54364_54381 = state_54357__$1;
(statearr_54364_54381[(1)] = (6));

} else {
var statearr_54365_54382 = state_54357__$1;
(statearr_54365_54382[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54358 === (9))){
var inst_54337 = (state_54357[(2)]);
var inst_54338 = fluree.db.util.async.throw_err(inst_54337);
var state_54357__$1 = state_54357;
var statearr_54366_54383 = state_54357__$1;
(statearr_54366_54383[(2)] = inst_54338);

(statearr_54366_54383[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54358 === (5))){
var _ = (function (){var statearr_54367 = state_54357;
(statearr_54367[(4)] = cljs.core.rest((state_54357[(4)])));

return statearr_54367;
})();
var state_54357__$1 = state_54357;
var ex54362 = (state_54357__$1[(2)]);
var statearr_54368_54384 = state_54357__$1;
(statearr_54368_54384[(5)] = ex54362);


if((ex54362 instanceof Error)){
var statearr_54369_54385 = state_54357__$1;
(statearr_54369_54385[(1)] = (4));

(statearr_54369_54385[(5)] = null);

} else {
throw ex54362;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54358 === (8))){
var inst_54341 = (state_54357[(2)]);
var inst_54342 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_54341);
var inst_54343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54344 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54346 = [inst_54341];
var inst_54347 = (new cljs.core.PersistentVector(null,1,(5),inst_54345,inst_54346,null));
var inst_54348 = ["nil?",inst_54347,inst_54342];
var inst_54349 = cljs.core.PersistentHashMap.fromArrays(inst_54344,inst_54348);
var inst_54350 = [inst_54349,(10)];
var inst_54351 = (new cljs.core.PersistentVector(null,2,(5),inst_54343,inst_54350,null));
var inst_54352 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54351);
var _ = (function (){var statearr_54370 = state_54357;
(statearr_54370[(4)] = cljs.core.rest((state_54357[(4)])));

return statearr_54370;
})();
var state_54357__$1 = (function (){var statearr_54371 = state_54357;
(statearr_54371[(7)] = inst_54352);

return statearr_54371;
})();
var statearr_54372_54386 = state_54357__$1;
(statearr_54372_54386[(2)] = inst_54342);

(statearr_54372_54386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_54373 = [null,null,null,null,null,null,null,null];
(statearr_54373[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto__);

(statearr_54373[(1)] = (1));

return statearr_54373;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto____1 = (function (state_54357){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54357);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54374){var ex__2736__auto__ = e54374;
var statearr_54375_54387 = state_54357;
(statearr_54375_54387[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54357[(4)]))){
var statearr_54376_54388 = state_54357;
(statearr_54376_54388[(1)] = cljs.core.first((state_54357[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54389 = state_54357;
state_54357 = G__54389;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto__ = function(state_54357){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto____1.call(this,state_54357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54377 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54377[(6)] = c__2755__auto__);

return statearr_54377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54419){
var state_val_54420 = (state_54419[(1)]);
if((state_val_54420 === (7))){
var state_54419__$1 = state_54419;
var statearr_54421_54440 = state_54419__$1;
(statearr_54421_54440[(2)] = arg);

(statearr_54421_54440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54420 === (1))){
var state_54419__$1 = state_54419;
var statearr_54422_54441 = state_54419__$1;
(statearr_54422_54441[(2)] = null);

(statearr_54422_54441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54420 === (4))){
var inst_54390 = (state_54419[(2)]);
var state_54419__$1 = state_54419;
var statearr_54423_54442 = state_54419__$1;
(statearr_54423_54442[(2)] = inst_54390);

(statearr_54423_54442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54420 === (6))){
var state_54419__$1 = state_54419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54419__$1,(9),arg);
} else {
if((state_val_54420 === (3))){
var inst_54417 = (state_54419[(2)]);
var state_54419__$1 = state_54419;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54419__$1,inst_54417);
} else {
if((state_val_54420 === (2))){
var _ = (function (){var statearr_54425 = state_54419;
(statearr_54425[(4)] = cljs.core.cons((5),(state_54419[(4)])));

return statearr_54425;
})();
var inst_54396 = fluree.db.util.async.channel_QMARK_(arg);
var state_54419__$1 = state_54419;
if(inst_54396){
var statearr_54426_54443 = state_54419__$1;
(statearr_54426_54443[(1)] = (6));

} else {
var statearr_54427_54444 = state_54419__$1;
(statearr_54427_54444[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54420 === (9))){
var inst_54399 = (state_54419[(2)]);
var inst_54400 = fluree.db.util.async.throw_err(inst_54399);
var state_54419__$1 = state_54419;
var statearr_54428_54445 = state_54419__$1;
(statearr_54428_54445[(2)] = inst_54400);

(statearr_54428_54445[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54420 === (5))){
var _ = (function (){var statearr_54429 = state_54419;
(statearr_54429[(4)] = cljs.core.rest((state_54419[(4)])));

return statearr_54429;
})();
var state_54419__$1 = state_54419;
var ex54424 = (state_54419__$1[(2)]);
var statearr_54430_54446 = state_54419__$1;
(statearr_54430_54446[(5)] = ex54424);


if((ex54424 instanceof Error)){
var statearr_54431_54447 = state_54419__$1;
(statearr_54431_54447[(1)] = (4));

(statearr_54431_54447[(5)] = null);

} else {
throw ex54424;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54420 === (8))){
var inst_54403 = (state_54419[(2)]);
var inst_54404 = fluree.db.dbfunctions.internal.not(inst_54403);
var inst_54405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54406 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54408 = [inst_54403];
var inst_54409 = (new cljs.core.PersistentVector(null,1,(5),inst_54407,inst_54408,null));
var inst_54410 = ["not?",inst_54409,inst_54404];
var inst_54411 = cljs.core.PersistentHashMap.fromArrays(inst_54406,inst_54410);
var inst_54412 = [inst_54411,(10)];
var inst_54413 = (new cljs.core.PersistentVector(null,2,(5),inst_54405,inst_54412,null));
var inst_54414 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54413);
var _ = (function (){var statearr_54432 = state_54419;
(statearr_54432[(4)] = cljs.core.rest((state_54419[(4)])));

return statearr_54432;
})();
var state_54419__$1 = (function (){var statearr_54433 = state_54419;
(statearr_54433[(7)] = inst_54414);

return statearr_54433;
})();
var statearr_54434_54448 = state_54419__$1;
(statearr_54434_54448[(2)] = inst_54404);

(statearr_54434_54448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto____0 = (function (){
var statearr_54435 = [null,null,null,null,null,null,null,null];
(statearr_54435[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto__);

(statearr_54435[(1)] = (1));

return statearr_54435;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto____1 = (function (state_54419){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54419);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54436){var ex__2736__auto__ = e54436;
var statearr_54437_54449 = state_54419;
(statearr_54437_54449[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54419[(4)]))){
var statearr_54438_54450 = state_54419;
(statearr_54438_54450[(1)] = cljs.core.first((state_54419[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54451 = state_54419;
state_54419 = G__54451;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto__ = function(state_54419){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto____1.call(this,state_54419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54439 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54439[(6)] = c__2755__auto__);

return statearr_54439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54481){
var state_val_54482 = (state_54481[(1)]);
if((state_val_54482 === (7))){
var state_54481__$1 = state_54481;
var statearr_54483_54502 = state_54481__$1;
(statearr_54483_54502[(2)] = arg);

(statearr_54483_54502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54482 === (1))){
var state_54481__$1 = state_54481;
var statearr_54484_54503 = state_54481__$1;
(statearr_54484_54503[(2)] = null);

(statearr_54484_54503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54482 === (4))){
var inst_54452 = (state_54481[(2)]);
var state_54481__$1 = state_54481;
var statearr_54485_54504 = state_54481__$1;
(statearr_54485_54504[(2)] = inst_54452);

(statearr_54485_54504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54482 === (6))){
var state_54481__$1 = state_54481;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54481__$1,(9),arg);
} else {
if((state_val_54482 === (3))){
var inst_54479 = (state_54481[(2)]);
var state_54481__$1 = state_54481;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54481__$1,inst_54479);
} else {
if((state_val_54482 === (2))){
var _ = (function (){var statearr_54487 = state_54481;
(statearr_54487[(4)] = cljs.core.cons((5),(state_54481[(4)])));

return statearr_54487;
})();
var inst_54458 = fluree.db.util.async.channel_QMARK_(arg);
var state_54481__$1 = state_54481;
if(inst_54458){
var statearr_54488_54505 = state_54481__$1;
(statearr_54488_54505[(1)] = (6));

} else {
var statearr_54489_54506 = state_54481__$1;
(statearr_54489_54506[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54482 === (9))){
var inst_54461 = (state_54481[(2)]);
var inst_54462 = fluree.db.util.async.throw_err(inst_54461);
var state_54481__$1 = state_54481;
var statearr_54490_54507 = state_54481__$1;
(statearr_54490_54507[(2)] = inst_54462);

(statearr_54490_54507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54482 === (5))){
var _ = (function (){var statearr_54491 = state_54481;
(statearr_54491[(4)] = cljs.core.rest((state_54481[(4)])));

return statearr_54491;
})();
var state_54481__$1 = state_54481;
var ex54486 = (state_54481__$1[(2)]);
var statearr_54492_54508 = state_54481__$1;
(statearr_54492_54508[(5)] = ex54486);


if((ex54486 instanceof Error)){
var statearr_54493_54509 = state_54481__$1;
(statearr_54493_54509[(1)] = (4));

(statearr_54493_54509[(5)] = null);

} else {
throw ex54486;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54482 === (8))){
var inst_54465 = (state_54481[(2)]);
var inst_54466 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_54465);
var inst_54467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54468 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54470 = [inst_54465];
var inst_54471 = (new cljs.core.PersistentVector(null,1,(5),inst_54469,inst_54470,null));
var inst_54472 = ["empty?",inst_54471,inst_54466];
var inst_54473 = cljs.core.PersistentHashMap.fromArrays(inst_54468,inst_54472);
var inst_54474 = [inst_54473,(10)];
var inst_54475 = (new cljs.core.PersistentVector(null,2,(5),inst_54467,inst_54474,null));
var inst_54476 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54475);
var _ = (function (){var statearr_54494 = state_54481;
(statearr_54494[(4)] = cljs.core.rest((state_54481[(4)])));

return statearr_54494;
})();
var state_54481__$1 = (function (){var statearr_54495 = state_54481;
(statearr_54495[(7)] = inst_54476);

return statearr_54495;
})();
var statearr_54496_54510 = state_54481__$1;
(statearr_54496_54510[(2)] = inst_54466);

(statearr_54496_54510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_54497 = [null,null,null,null,null,null,null,null];
(statearr_54497[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto__);

(statearr_54497[(1)] = (1));

return statearr_54497;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto____1 = (function (state_54481){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54481);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54498){var ex__2736__auto__ = e54498;
var statearr_54499_54511 = state_54481;
(statearr_54499_54511[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54481[(4)]))){
var statearr_54500_54512 = state_54481;
(statearr_54500_54512[(1)] = cljs.core.first((state_54481[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54513 = state_54481;
state_54481 = G__54513;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto__ = function(state_54481){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto____1.call(this,state_54481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54501 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54501[(6)] = c__2755__auto__);

return statearr_54501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54558 = arguments.length;
var i__4830__auto___54559 = (0);
while(true){
if((i__4830__auto___54559 < len__4829__auto___54558)){
args__4835__auto__.push((arguments[i__4830__auto___54559]));

var G__54560 = (i__4830__auto___54559 + (1));
i__4830__auto___54559 = G__54560;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54541){
var state_val_54542 = (state_54541[(1)]);
if((state_val_54542 === (1))){
var state_54541__$1 = state_54541;
var statearr_54543_54561 = state_54541__$1;
(statearr_54543_54561[(2)] = null);

(statearr_54543_54561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54542 === (2))){
var _ = (function (){var statearr_54544 = state_54541;
(statearr_54544[(4)] = cljs.core.cons((5),(state_54541[(4)])));

return statearr_54544;
})();
var inst_54522 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54541__$1 = state_54541;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54541__$1,(6),inst_54522);
} else {
if((state_val_54542 === (3))){
var inst_54539 = (state_54541[(2)]);
var state_54541__$1 = state_54541;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54541__$1,inst_54539);
} else {
if((state_val_54542 === (4))){
var inst_54516 = (state_54541[(2)]);
var state_54541__$1 = state_54541;
var statearr_54546_54562 = state_54541__$1;
(statearr_54546_54562[(2)] = inst_54516);

(statearr_54546_54562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54542 === (5))){
var _ = (function (){var statearr_54547 = state_54541;
(statearr_54547[(4)] = cljs.core.rest((state_54541[(4)])));

return statearr_54547;
})();
var state_54541__$1 = state_54541;
var ex54545 = (state_54541__$1[(2)]);
var statearr_54548_54563 = state_54541__$1;
(statearr_54548_54563[(5)] = ex54545);


if((ex54545 instanceof Error)){
var statearr_54549_54564 = state_54541__$1;
(statearr_54549_54564[(1)] = (4));

(statearr_54549_54564[(5)] = null);

} else {
throw ex54545;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54542 === (6))){
var inst_54524 = (state_54541[(2)]);
var inst_54525 = fluree.db.util.async.throw_err(inst_54524);
var inst_54526 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_54525);
var inst_54527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54528 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54530 = [inst_54525];
var inst_54531 = (new cljs.core.PersistentVector(null,1,(5),inst_54529,inst_54530,null));
var inst_54532 = ["str",inst_54531,inst_54526];
var inst_54533 = cljs.core.PersistentHashMap.fromArrays(inst_54528,inst_54532);
var inst_54534 = [inst_54533,(10)];
var inst_54535 = (new cljs.core.PersistentVector(null,2,(5),inst_54527,inst_54534,null));
var inst_54536 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54535);
var _ = (function (){var statearr_54550 = state_54541;
(statearr_54550[(4)] = cljs.core.rest((state_54541[(4)])));

return statearr_54550;
})();
var state_54541__$1 = (function (){var statearr_54551 = state_54541;
(statearr_54551[(7)] = inst_54536);

return statearr_54551;
})();
var statearr_54552_54565 = state_54541__$1;
(statearr_54552_54565[(2)] = inst_54526);

(statearr_54552_54565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54553 = [null,null,null,null,null,null,null,null];
(statearr_54553[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54553[(1)] = (1));

return statearr_54553;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54541){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54541);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54554){var ex__2736__auto__ = e54554;
var statearr_54555_54566 = state_54541;
(statearr_54555_54566[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54541[(4)]))){
var statearr_54556_54567 = state_54541;
(statearr_54556_54567[(1)] = cljs.core.first((state_54541[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54568 = state_54541;
state_54541 = G__54568;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54541){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54541);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54557 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54557[(6)] = c__2755__auto__);

return statearr_54557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54514){
var G__54515 = cljs.core.first(seq54514);
var seq54514__$1 = cljs.core.next(seq54514);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54515,seq54514__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54594){
var state_val_54595 = (state_54594[(1)]);
if((state_val_54595 === (1))){
var state_54594__$1 = state_54594;
var statearr_54596_54611 = state_54594__$1;
(statearr_54596_54611[(2)] = null);

(statearr_54596_54611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54595 === (2))){
var _ = (function (){var statearr_54597 = state_54594;
(statearr_54597[(4)] = cljs.core.cons((5),(state_54594[(4)])));

return statearr_54597;
})();
var inst_54575 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54594__$1 = state_54594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54594__$1,(6),inst_54575);
} else {
if((state_val_54595 === (3))){
var inst_54592 = (state_54594[(2)]);
var state_54594__$1 = state_54594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54594__$1,inst_54592);
} else {
if((state_val_54595 === (4))){
var inst_54569 = (state_54594[(2)]);
var state_54594__$1 = state_54594;
var statearr_54599_54612 = state_54594__$1;
(statearr_54599_54612[(2)] = inst_54569);

(statearr_54599_54612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54595 === (5))){
var _ = (function (){var statearr_54600 = state_54594;
(statearr_54600[(4)] = cljs.core.rest((state_54594[(4)])));

return statearr_54600;
})();
var state_54594__$1 = state_54594;
var ex54598 = (state_54594__$1[(2)]);
var statearr_54601_54613 = state_54594__$1;
(statearr_54601_54613[(5)] = ex54598);


if((ex54598 instanceof Error)){
var statearr_54602_54614 = state_54594__$1;
(statearr_54602_54614[(1)] = (4));

(statearr_54602_54614[(5)] = null);

} else {
throw ex54598;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54595 === (6))){
var inst_54577 = (state_54594[(2)]);
var inst_54578 = fluree.db.util.async.throw_err(inst_54577);
var inst_54579 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_54578);
var inst_54580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54581 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54583 = [inst_54578];
var inst_54584 = (new cljs.core.PersistentVector(null,1,(5),inst_54582,inst_54583,null));
var inst_54585 = ["subs",inst_54584,inst_54579];
var inst_54586 = cljs.core.PersistentHashMap.fromArrays(inst_54581,inst_54585);
var inst_54587 = [inst_54586,(30)];
var inst_54588 = (new cljs.core.PersistentVector(null,2,(5),inst_54580,inst_54587,null));
var inst_54589 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54588);
var _ = (function (){var statearr_54603 = state_54594;
(statearr_54603[(4)] = cljs.core.rest((state_54594[(4)])));

return statearr_54603;
})();
var state_54594__$1 = (function (){var statearr_54604 = state_54594;
(statearr_54604[(7)] = inst_54589);

return statearr_54604;
})();
var statearr_54605_54615 = state_54594__$1;
(statearr_54605_54615[(2)] = inst_54579);

(statearr_54605_54615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto____0 = (function (){
var statearr_54606 = [null,null,null,null,null,null,null,null];
(statearr_54606[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto__);

(statearr_54606[(1)] = (1));

return statearr_54606;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto____1 = (function (state_54594){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54594);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54607){var ex__2736__auto__ = e54607;
var statearr_54608_54616 = state_54594;
(statearr_54608_54616[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54594[(4)]))){
var statearr_54609_54617 = state_54594;
(statearr_54609_54617[(1)] = cljs.core.first((state_54594[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54618 = state_54594;
state_54594 = G__54618;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto__ = function(state_54594){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto____1.call(this,state_54594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54610 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54610[(6)] = c__2755__auto__);

return statearr_54610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54648){
var state_val_54649 = (state_54648[(1)]);
if((state_val_54649 === (7))){
var state_54648__$1 = state_54648;
var statearr_54650_54669 = state_54648__$1;
(statearr_54650_54669[(2)] = str);

(statearr_54650_54669[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54649 === (1))){
var state_54648__$1 = state_54648;
var statearr_54651_54670 = state_54648__$1;
(statearr_54651_54670[(2)] = null);

(statearr_54651_54670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54649 === (4))){
var inst_54619 = (state_54648[(2)]);
var state_54648__$1 = state_54648;
var statearr_54652_54671 = state_54648__$1;
(statearr_54652_54671[(2)] = inst_54619);

(statearr_54652_54671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54649 === (6))){
var state_54648__$1 = state_54648;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54648__$1,(9),str);
} else {
if((state_val_54649 === (3))){
var inst_54646 = (state_54648[(2)]);
var state_54648__$1 = state_54648;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54648__$1,inst_54646);
} else {
if((state_val_54649 === (2))){
var _ = (function (){var statearr_54654 = state_54648;
(statearr_54654[(4)] = cljs.core.cons((5),(state_54648[(4)])));

return statearr_54654;
})();
var inst_54625 = fluree.db.util.async.channel_QMARK_(str);
var state_54648__$1 = state_54648;
if(inst_54625){
var statearr_54655_54672 = state_54648__$1;
(statearr_54655_54672[(1)] = (6));

} else {
var statearr_54656_54673 = state_54648__$1;
(statearr_54656_54673[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54649 === (9))){
var inst_54628 = (state_54648[(2)]);
var inst_54629 = fluree.db.util.async.throw_err(inst_54628);
var state_54648__$1 = state_54648;
var statearr_54657_54674 = state_54648__$1;
(statearr_54657_54674[(2)] = inst_54629);

(statearr_54657_54674[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54649 === (5))){
var _ = (function (){var statearr_54658 = state_54648;
(statearr_54658[(4)] = cljs.core.rest((state_54648[(4)])));

return statearr_54658;
})();
var state_54648__$1 = state_54648;
var ex54653 = (state_54648__$1[(2)]);
var statearr_54659_54675 = state_54648__$1;
(statearr_54659_54675[(5)] = ex54653);


if((ex54653 instanceof Error)){
var statearr_54660_54676 = state_54648__$1;
(statearr_54660_54676[(1)] = (4));

(statearr_54660_54676[(5)] = null);

} else {
throw ex54653;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54649 === (8))){
var inst_54632 = (state_54648[(2)]);
var inst_54633 = fluree.db.dbfunctions.internal.lower_case(inst_54632);
var inst_54634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54635 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54637 = [inst_54632];
var inst_54638 = (new cljs.core.PersistentVector(null,1,(5),inst_54636,inst_54637,null));
var inst_54639 = ["lower-case",inst_54638,inst_54633];
var inst_54640 = cljs.core.PersistentHashMap.fromArrays(inst_54635,inst_54639);
var inst_54641 = [inst_54640,(10)];
var inst_54642 = (new cljs.core.PersistentVector(null,2,(5),inst_54634,inst_54641,null));
var inst_54643 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54642);
var _ = (function (){var statearr_54661 = state_54648;
(statearr_54661[(4)] = cljs.core.rest((state_54648[(4)])));

return statearr_54661;
})();
var state_54648__$1 = (function (){var statearr_54662 = state_54648;
(statearr_54662[(7)] = inst_54643);

return statearr_54662;
})();
var statearr_54663_54677 = state_54648__$1;
(statearr_54663_54677[(2)] = inst_54633);

(statearr_54663_54677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto____0 = (function (){
var statearr_54664 = [null,null,null,null,null,null,null,null];
(statearr_54664[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto__);

(statearr_54664[(1)] = (1));

return statearr_54664;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto____1 = (function (state_54648){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54648);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54665){var ex__2736__auto__ = e54665;
var statearr_54666_54678 = state_54648;
(statearr_54666_54678[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54648[(4)]))){
var statearr_54667_54679 = state_54648;
(statearr_54667_54679[(1)] = cljs.core.first((state_54648[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54680 = state_54648;
state_54648 = G__54680;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto__ = function(state_54648){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto____1.call(this,state_54648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54668 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54668[(6)] = c__2755__auto__);

return statearr_54668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54710){
var state_val_54711 = (state_54710[(1)]);
if((state_val_54711 === (7))){
var state_54710__$1 = state_54710;
var statearr_54712_54731 = state_54710__$1;
(statearr_54712_54731[(2)] = str);

(statearr_54712_54731[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54711 === (1))){
var state_54710__$1 = state_54710;
var statearr_54713_54732 = state_54710__$1;
(statearr_54713_54732[(2)] = null);

(statearr_54713_54732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54711 === (4))){
var inst_54681 = (state_54710[(2)]);
var state_54710__$1 = state_54710;
var statearr_54714_54733 = state_54710__$1;
(statearr_54714_54733[(2)] = inst_54681);

(statearr_54714_54733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54711 === (6))){
var state_54710__$1 = state_54710;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54710__$1,(9),str);
} else {
if((state_val_54711 === (3))){
var inst_54708 = (state_54710[(2)]);
var state_54710__$1 = state_54710;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54710__$1,inst_54708);
} else {
if((state_val_54711 === (2))){
var _ = (function (){var statearr_54716 = state_54710;
(statearr_54716[(4)] = cljs.core.cons((5),(state_54710[(4)])));

return statearr_54716;
})();
var inst_54687 = fluree.db.util.async.channel_QMARK_(str);
var state_54710__$1 = state_54710;
if(inst_54687){
var statearr_54717_54734 = state_54710__$1;
(statearr_54717_54734[(1)] = (6));

} else {
var statearr_54718_54735 = state_54710__$1;
(statearr_54718_54735[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54711 === (9))){
var inst_54690 = (state_54710[(2)]);
var inst_54691 = fluree.db.util.async.throw_err(inst_54690);
var state_54710__$1 = state_54710;
var statearr_54719_54736 = state_54710__$1;
(statearr_54719_54736[(2)] = inst_54691);

(statearr_54719_54736[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54711 === (5))){
var _ = (function (){var statearr_54720 = state_54710;
(statearr_54720[(4)] = cljs.core.rest((state_54710[(4)])));

return statearr_54720;
})();
var state_54710__$1 = state_54710;
var ex54715 = (state_54710__$1[(2)]);
var statearr_54721_54737 = state_54710__$1;
(statearr_54721_54737[(5)] = ex54715);


if((ex54715 instanceof Error)){
var statearr_54722_54738 = state_54710__$1;
(statearr_54722_54738[(1)] = (4));

(statearr_54722_54738[(5)] = null);

} else {
throw ex54715;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54711 === (8))){
var inst_54694 = (state_54710[(2)]);
var inst_54695 = fluree.db.dbfunctions.internal.upper_case(inst_54694);
var inst_54696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54697 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54699 = [inst_54694];
var inst_54700 = (new cljs.core.PersistentVector(null,1,(5),inst_54698,inst_54699,null));
var inst_54701 = ["upper-case",inst_54700,inst_54695];
var inst_54702 = cljs.core.PersistentHashMap.fromArrays(inst_54697,inst_54701);
var inst_54703 = [inst_54702,(10)];
var inst_54704 = (new cljs.core.PersistentVector(null,2,(5),inst_54696,inst_54703,null));
var inst_54705 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54704);
var _ = (function (){var statearr_54723 = state_54710;
(statearr_54723[(4)] = cljs.core.rest((state_54710[(4)])));

return statearr_54723;
})();
var state_54710__$1 = (function (){var statearr_54724 = state_54710;
(statearr_54724[(7)] = inst_54705);

return statearr_54724;
})();
var statearr_54725_54739 = state_54710__$1;
(statearr_54725_54739[(2)] = inst_54695);

(statearr_54725_54739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto____0 = (function (){
var statearr_54726 = [null,null,null,null,null,null,null,null];
(statearr_54726[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto__);

(statearr_54726[(1)] = (1));

return statearr_54726;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto____1 = (function (state_54710){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54710);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54727){var ex__2736__auto__ = e54727;
var statearr_54728_54740 = state_54710;
(statearr_54728_54740[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54710[(4)]))){
var statearr_54729_54741 = state_54710;
(statearr_54729_54741[(1)] = cljs.core.first((state_54710[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54742 = state_54710;
state_54710 = G__54742;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto__ = function(state_54710){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto____1.call(this,state_54710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54730 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54730[(6)] = c__2755__auto__);

return statearr_54730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4221__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4221__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__54744 = arguments.length;
switch (G__54744) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54772){
var state_val_54773 = (state_54772[(1)]);
if((state_val_54773 === (1))){
var state_54772__$1 = state_54772;
var statearr_54774_54790 = state_54772__$1;
(statearr_54774_54790[(2)] = null);

(statearr_54774_54790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54773 === (2))){
var _ = (function (){var statearr_54775 = state_54772;
(statearr_54775[(4)] = cljs.core.cons((5),(state_54772[(4)])));

return statearr_54775;
})();
var inst_54754 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_54772__$1 = state_54772;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54772__$1,(6),inst_54754);
} else {
if((state_val_54773 === (3))){
var inst_54770 = (state_54772[(2)]);
var state_54772__$1 = state_54772;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54772__$1,inst_54770);
} else {
if((state_val_54773 === (4))){
var inst_54745 = (state_54772[(2)]);
var state_54772__$1 = state_54772;
var statearr_54777_54791 = state_54772__$1;
(statearr_54777_54791[(2)] = inst_54745);

(statearr_54777_54791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54773 === (5))){
var _ = (function (){var statearr_54778 = state_54772;
(statearr_54778[(4)] = cljs.core.rest((state_54772[(4)])));

return statearr_54778;
})();
var state_54772__$1 = state_54772;
var ex54776 = (state_54772__$1[(2)]);
var statearr_54779_54792 = state_54772__$1;
(statearr_54779_54792[(5)] = ex54776);


if((ex54776 instanceof Error)){
var statearr_54780_54793 = state_54772__$1;
(statearr_54780_54793[(1)] = (4));

(statearr_54780_54793[(5)] = null);

} else {
throw ex54776;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54773 === (6))){
var inst_54756 = (state_54772[(2)]);
var inst_54757 = fluree.db.util.async.throw_err(inst_54756);
var inst_54758 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54757,(0),null);
var inst_54759 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54757,(1),null);
var inst_54760 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54761 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54762 = ["?s","?ctx",inst_54758];
var inst_54763 = cljs.core.PersistentHashMap.fromArrays(inst_54761,inst_54762);
var inst_54764 = ((10) + inst_54759);
var inst_54765 = [inst_54763,inst_54764];
var inst_54766 = (new cljs.core.PersistentVector(null,2,(5),inst_54760,inst_54765,null));
var inst_54767 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54766);
var _ = (function (){var statearr_54781 = state_54772;
(statearr_54781[(4)] = cljs.core.rest((state_54772[(4)])));

return statearr_54781;
})();
var state_54772__$1 = (function (){var statearr_54782 = state_54772;
(statearr_54782[(7)] = inst_54767);

return statearr_54782;
})();
var statearr_54783_54794 = state_54772__$1;
(statearr_54783_54794[(2)] = inst_54758);

(statearr_54783_54794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54784 = [null,null,null,null,null,null,null,null];
(statearr_54784[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54784[(1)] = (1));

return statearr_54784;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54772){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54772);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54785){var ex__2736__auto__ = e54785;
var statearr_54786_54795 = state_54772;
(statearr_54786_54795[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54772[(4)]))){
var statearr_54787_54796 = state_54772;
(statearr_54787_54796[(1)] = cljs.core.first((state_54772[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54797 = state_54772;
state_54772 = G__54797;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54772){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54788 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54788[(6)] = c__2755__auto__);

return statearr_54788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__54799 = arguments.length;
switch (G__54799) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54837){
var state_val_54838 = (state_54837[(1)]);
if((state_val_54838 === (7))){
var inst_54830 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54837__$1 = state_54837;
var statearr_54839_54859 = state_54837__$1;
(statearr_54839_54859[(2)] = inst_54830);

(statearr_54839_54859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (1))){
var state_54837__$1 = state_54837;
var statearr_54840_54860 = state_54837__$1;
(statearr_54840_54860[(2)] = null);

(statearr_54840_54860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (4))){
var inst_54800 = (state_54837[(2)]);
var state_54837__$1 = state_54837;
var statearr_54841_54861 = state_54837__$1;
(statearr_54841_54861[(2)] = inst_54800);

(statearr_54841_54861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (6))){
var inst_54811 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_54837__$1 = state_54837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54837__$1,(10),inst_54811);
} else {
if((state_val_54838 === (3))){
var inst_54835 = (state_54837[(2)]);
var state_54837__$1 = state_54837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54837__$1,inst_54835);
} else {
if((state_val_54838 === (2))){
var _ = (function (){var statearr_54843 = state_54837;
(statearr_54843[(4)] = cljs.core.cons((5),(state_54837[(4)])));

return statearr_54843;
})();
var inst_54806 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54837__$1 = state_54837;
if(cljs.core.truth_(inst_54806)){
var statearr_54844_54862 = state_54837__$1;
(statearr_54844_54862[(1)] = (6));

} else {
var statearr_54845_54863 = state_54837__$1;
(statearr_54845_54863[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (9))){
var inst_54817 = (state_54837[(2)]);
var inst_54818 = fluree.db.util.async.throw_err(inst_54817);
var inst_54819 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54818,(0),null);
var inst_54820 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54818,(1),null);
var inst_54821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54822 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54823 = ["?p","?ctx",inst_54819];
var inst_54824 = cljs.core.PersistentHashMap.fromArrays(inst_54822,inst_54823);
var inst_54825 = ((10) + inst_54820);
var inst_54826 = [inst_54824,inst_54825];
var inst_54827 = (new cljs.core.PersistentVector(null,2,(5),inst_54821,inst_54826,null));
var inst_54828 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54827);
var state_54837__$1 = (function (){var statearr_54846 = state_54837;
(statearr_54846[(7)] = inst_54828);

return statearr_54846;
})();
var statearr_54847_54864 = state_54837__$1;
(statearr_54847_54864[(2)] = inst_54819);

(statearr_54847_54864[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (5))){
var _ = (function (){var statearr_54848 = state_54837;
(statearr_54848[(4)] = cljs.core.rest((state_54837[(4)])));

return statearr_54848;
})();
var state_54837__$1 = state_54837;
var ex54842 = (state_54837__$1[(2)]);
var statearr_54849_54865 = state_54837__$1;
(statearr_54849_54865[(5)] = ex54842);


if((ex54842 instanceof Error)){
var statearr_54850_54866 = state_54837__$1;
(statearr_54850_54866[(1)] = (4));

(statearr_54850_54866[(5)] = null);

} else {
throw ex54842;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (10))){
var inst_54813 = (state_54837[(2)]);
var inst_54814 = fluree.db.util.async.throw_err(inst_54813);
var inst_54815 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_54814);
var state_54837__$1 = state_54837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54837__$1,(9),inst_54815);
} else {
if((state_val_54838 === (8))){
var inst_54832 = (state_54837[(2)]);
var _ = (function (){var statearr_54851 = state_54837;
(statearr_54851[(4)] = cljs.core.rest((state_54837[(4)])));

return statearr_54851;
})();
var state_54837__$1 = state_54837;
var statearr_54852_54867 = state_54837__$1;
(statearr_54852_54867[(2)] = inst_54832);

(statearr_54852_54867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54853 = [null,null,null,null,null,null,null,null];
(statearr_54853[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54853[(1)] = (1));

return statearr_54853;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54837){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54837);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54854){var ex__2736__auto__ = e54854;
var statearr_54855_54868 = state_54837;
(statearr_54855_54868[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54837[(4)]))){
var statearr_54856_54869 = state_54837;
(statearr_54856_54869[(1)] = cljs.core.first((state_54837[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54870 = state_54837;
state_54837 = G__54870;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54837){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54857 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54857[(6)] = c__2755__auto__);

return statearr_54857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54919 = arguments.length;
var i__4830__auto___54920 = (0);
while(true){
if((i__4830__auto___54920 < len__4829__auto___54919)){
args__4835__auto__.push((arguments[i__4830__auto___54920]));

var G__54921 = (i__4830__auto___54920 + (1));
i__4830__auto___54920 = G__54921;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54902){
var state_val_54903 = (state_54902[(1)]);
if((state_val_54903 === (1))){
var state_54902__$1 = state_54902;
var statearr_54904_54922 = state_54902__$1;
(statearr_54904_54922[(2)] = null);

(statearr_54904_54922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54903 === (2))){
var _ = (function (){var statearr_54905 = state_54902;
(statearr_54905[(4)] = cljs.core.cons((5),(state_54902[(4)])));

return statearr_54905;
})();
var inst_54879 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54902__$1 = state_54902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54902__$1,(6),inst_54879);
} else {
if((state_val_54903 === (3))){
var inst_54900 = (state_54902[(2)]);
var state_54902__$1 = state_54902;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54902__$1,inst_54900);
} else {
if((state_val_54903 === (4))){
var inst_54873 = (state_54902[(2)]);
var state_54902__$1 = state_54902;
var statearr_54907_54923 = state_54902__$1;
(statearr_54907_54923[(2)] = inst_54873);

(statearr_54907_54923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54903 === (5))){
var _ = (function (){var statearr_54908 = state_54902;
(statearr_54908[(4)] = cljs.core.rest((state_54902[(4)])));

return statearr_54908;
})();
var state_54902__$1 = state_54902;
var ex54906 = (state_54902__$1[(2)]);
var statearr_54909_54924 = state_54902__$1;
(statearr_54909_54924[(5)] = ex54906);


if((ex54906 instanceof Error)){
var statearr_54910_54925 = state_54902__$1;
(statearr_54910_54925[(1)] = (4));

(statearr_54910_54925[(5)] = null);

} else {
throw ex54906;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54903 === (6))){
var inst_54881 = (state_54902[(2)]);
var inst_54882 = fluree.db.util.async.throw_err(inst_54881);
var inst_54883 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_54882);
var inst_54884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54885 = [inst_54882];
var inst_54886 = (new cljs.core.PersistentVector(null,1,(5),inst_54884,inst_54885,null));
var inst_54887 = cljs.core.count(inst_54886);
var inst_54888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54889 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54891 = [inst_54882];
var inst_54892 = (new cljs.core.PersistentVector(null,1,(5),inst_54890,inst_54891,null));
var inst_54893 = ["and",inst_54892,inst_54883];
var inst_54894 = cljs.core.PersistentHashMap.fromArrays(inst_54889,inst_54893);
var inst_54895 = [inst_54894,inst_54887];
var inst_54896 = (new cljs.core.PersistentVector(null,2,(5),inst_54888,inst_54895,null));
var inst_54897 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54896);
var _ = (function (){var statearr_54911 = state_54902;
(statearr_54911[(4)] = cljs.core.rest((state_54902[(4)])));

return statearr_54911;
})();
var state_54902__$1 = (function (){var statearr_54912 = state_54902;
(statearr_54912[(7)] = inst_54897);

return statearr_54912;
})();
var statearr_54913_54926 = state_54902__$1;
(statearr_54913_54926[(2)] = inst_54883);

(statearr_54913_54926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54914 = [null,null,null,null,null,null,null,null];
(statearr_54914[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54914[(1)] = (1));

return statearr_54914;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54902){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54902);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54915){var ex__2736__auto__ = e54915;
var statearr_54916_54927 = state_54902;
(statearr_54916_54927[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54902[(4)]))){
var statearr_54917_54928 = state_54902;
(statearr_54917_54928[(1)] = cljs.core.first((state_54902[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54929 = state_54902;
state_54902 = G__54929;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54902){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54918 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54918[(6)] = c__2755__auto__);

return statearr_54918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54871){
var G__54872 = cljs.core.first(seq54871);
var seq54871__$1 = cljs.core.next(seq54871);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54872,seq54871__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54978 = arguments.length;
var i__4830__auto___54979 = (0);
while(true){
if((i__4830__auto___54979 < len__4829__auto___54978)){
args__4835__auto__.push((arguments[i__4830__auto___54979]));

var G__54980 = (i__4830__auto___54979 + (1));
i__4830__auto___54979 = G__54980;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54961){
var state_val_54962 = (state_54961[(1)]);
if((state_val_54962 === (1))){
var state_54961__$1 = state_54961;
var statearr_54963_54981 = state_54961__$1;
(statearr_54963_54981[(2)] = null);

(statearr_54963_54981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54962 === (2))){
var _ = (function (){var statearr_54964 = state_54961;
(statearr_54964[(4)] = cljs.core.cons((5),(state_54961[(4)])));

return statearr_54964;
})();
var inst_54938 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54961__$1 = state_54961;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54961__$1,(6),inst_54938);
} else {
if((state_val_54962 === (3))){
var inst_54959 = (state_54961[(2)]);
var state_54961__$1 = state_54961;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54961__$1,inst_54959);
} else {
if((state_val_54962 === (4))){
var inst_54932 = (state_54961[(2)]);
var state_54961__$1 = state_54961;
var statearr_54966_54982 = state_54961__$1;
(statearr_54966_54982[(2)] = inst_54932);

(statearr_54966_54982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54962 === (5))){
var _ = (function (){var statearr_54967 = state_54961;
(statearr_54967[(4)] = cljs.core.rest((state_54961[(4)])));

return statearr_54967;
})();
var state_54961__$1 = state_54961;
var ex54965 = (state_54961__$1[(2)]);
var statearr_54968_54983 = state_54961__$1;
(statearr_54968_54983[(5)] = ex54965);


if((ex54965 instanceof Error)){
var statearr_54969_54984 = state_54961__$1;
(statearr_54969_54984[(1)] = (4));

(statearr_54969_54984[(5)] = null);

} else {
throw ex54965;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54962 === (6))){
var inst_54940 = (state_54961[(2)]);
var inst_54941 = fluree.db.util.async.throw_err(inst_54940);
var inst_54942 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_54941);
var inst_54943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54944 = [inst_54941];
var inst_54945 = (new cljs.core.PersistentVector(null,1,(5),inst_54943,inst_54944,null));
var inst_54946 = cljs.core.count(inst_54945);
var inst_54947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54948 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54950 = [inst_54941];
var inst_54951 = (new cljs.core.PersistentVector(null,1,(5),inst_54949,inst_54950,null));
var inst_54952 = ["or",inst_54951,inst_54942];
var inst_54953 = cljs.core.PersistentHashMap.fromArrays(inst_54948,inst_54952);
var inst_54954 = [inst_54953,inst_54946];
var inst_54955 = (new cljs.core.PersistentVector(null,2,(5),inst_54947,inst_54954,null));
var inst_54956 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54955);
var _ = (function (){var statearr_54970 = state_54961;
(statearr_54970[(4)] = cljs.core.rest((state_54961[(4)])));

return statearr_54970;
})();
var state_54961__$1 = (function (){var statearr_54971 = state_54961;
(statearr_54971[(7)] = inst_54956);

return statearr_54971;
})();
var statearr_54972_54985 = state_54961__$1;
(statearr_54972_54985[(2)] = inst_54942);

(statearr_54972_54985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54973 = [null,null,null,null,null,null,null,null];
(statearr_54973[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54973[(1)] = (1));

return statearr_54973;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54961){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54961);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54974){var ex__2736__auto__ = e54974;
var statearr_54975_54986 = state_54961;
(statearr_54975_54986[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54961[(4)]))){
var statearr_54976_54987 = state_54961;
(statearr_54976_54987[(1)] = cljs.core.first((state_54961[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54988 = state_54961;
state_54961 = G__54988;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54961){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54977 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54977[(6)] = c__2755__auto__);

return statearr_54977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq54930){
var G__54931 = cljs.core.first(seq54930);
var seq54930__$1 = cljs.core.next(seq54930);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54931,seq54930__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55026){
var state_val_55027 = (state_55026[(1)]);
if((state_val_55027 === (7))){
var inst_55002 = fluree.db.util.async.channel_QMARK_(coll);
var state_55026__$1 = state_55026;
if(inst_55002){
var statearr_55028_55051 = state_55026__$1;
(statearr_55028_55051[(1)] = (10));

} else {
var statearr_55029_55052 = state_55026__$1;
(statearr_55029_55052[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55027 === (1))){
var state_55026__$1 = state_55026;
var statearr_55030_55053 = state_55026__$1;
(statearr_55030_55053[(2)] = null);

(statearr_55030_55053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55027 === (4))){
var inst_54989 = (state_55026[(2)]);
var state_55026__$1 = state_55026;
var statearr_55031_55054 = state_55026__$1;
(statearr_55031_55054[(2)] = inst_54989);

(statearr_55031_55054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55027 === (13))){
var inst_55005 = (state_55026[(2)]);
var inst_55006 = fluree.db.util.async.throw_err(inst_55005);
var state_55026__$1 = state_55026;
var statearr_55032_55055 = state_55026__$1;
(statearr_55032_55055[(2)] = inst_55006);

(statearr_55032_55055[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55027 === (6))){
var inst_54997 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_55026__$1 = state_55026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55026__$1,(9),inst_54997);
} else {
if((state_val_55027 === (3))){
var inst_55024 = (state_55026[(2)]);
var state_55026__$1 = state_55026;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55026__$1,inst_55024);
} else {
if((state_val_55027 === (12))){
var inst_55009 = (state_55026[(2)]);
var state_55026__$1 = state_55026;
var statearr_55033_55056 = state_55026__$1;
(statearr_55033_55056[(2)] = inst_55009);

(statearr_55033_55056[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55027 === (2))){
var _ = (function (){var statearr_55034 = state_55026;
(statearr_55034[(4)] = cljs.core.cons((5),(state_55026[(4)])));

return statearr_55034;
})();
var inst_54995 = cljs.core.vector_QMARK_(coll);
var state_55026__$1 = state_55026;
if(inst_54995){
var statearr_55035_55057 = state_55026__$1;
(statearr_55035_55057[(1)] = (6));

} else {
var statearr_55036_55058 = state_55026__$1;
(statearr_55036_55058[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55027 === (11))){
var state_55026__$1 = state_55026;
var statearr_55038_55059 = state_55026__$1;
(statearr_55038_55059[(2)] = coll);

(statearr_55038_55059[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55027 === (9))){
var inst_54999 = (state_55026[(2)]);
var inst_55000 = fluree.db.util.async.throw_err(inst_54999);
var state_55026__$1 = state_55026;
var statearr_55039_55060 = state_55026__$1;
(statearr_55039_55060[(2)] = inst_55000);

(statearr_55039_55060[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55027 === (5))){
var _ = (function (){var statearr_55040 = state_55026;
(statearr_55040[(4)] = cljs.core.rest((state_55026[(4)])));

return statearr_55040;
})();
var state_55026__$1 = state_55026;
var ex55037 = (state_55026__$1[(2)]);
var statearr_55041_55061 = state_55026__$1;
(statearr_55041_55061[(5)] = ex55037);


if((ex55037 instanceof Error)){
var statearr_55042_55062 = state_55026__$1;
(statearr_55042_55062[(1)] = (4));

(statearr_55042_55062[(5)] = null);

} else {
throw ex55037;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55027 === (10))){
var state_55026__$1 = state_55026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55026__$1,(13),coll);
} else {
if((state_val_55027 === (8))){
var inst_55011 = (state_55026[(2)]);
var inst_55012 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_55011);
var inst_55013 = cljs.core.count(inst_55012);
var inst_55014 = ((9) + inst_55013);
var inst_55015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55016 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55017 = ["count",inst_55011,inst_55013];
var inst_55018 = cljs.core.PersistentHashMap.fromArrays(inst_55016,inst_55017);
var inst_55019 = [inst_55018,inst_55014];
var inst_55020 = (new cljs.core.PersistentVector(null,2,(5),inst_55015,inst_55019,null));
var inst_55021 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55020);
var _ = (function (){var statearr_55043 = state_55026;
(statearr_55043[(4)] = cljs.core.rest((state_55026[(4)])));

return statearr_55043;
})();
var state_55026__$1 = (function (){var statearr_55044 = state_55026;
(statearr_55044[(7)] = inst_55021);

return statearr_55044;
})();
var statearr_55045_55063 = state_55026__$1;
(statearr_55045_55063[(2)] = inst_55013);

(statearr_55045_55063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto____0 = (function (){
var statearr_55046 = [null,null,null,null,null,null,null,null];
(statearr_55046[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto__);

(statearr_55046[(1)] = (1));

return statearr_55046;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto____1 = (function (state_55026){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55026);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55047){var ex__2736__auto__ = e55047;
var statearr_55048_55064 = state_55026;
(statearr_55048_55064[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55026[(4)]))){
var statearr_55049_55065 = state_55026;
(statearr_55049_55065[(1)] = cljs.core.first((state_55026[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55066 = state_55026;
state_55026 = G__55066;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto__ = function(state_55026){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto____1.call(this,state_55026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55050 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55050[(6)] = c__2755__auto__);

return statearr_55050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55116){
var state_val_55117 = (state_55116[(1)]);
if((state_val_55117 === (7))){
var state_55116__$1 = state_55116;
var statearr_55118_55151 = state_55116__$1;
(statearr_55118_55151[(2)] = subject);

(statearr_55118_55151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (1))){
var state_55116__$1 = state_55116;
var statearr_55119_55152 = state_55116__$1;
(statearr_55119_55152[(2)] = null);

(statearr_55119_55152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (4))){
var inst_55067 = (state_55116[(2)]);
var state_55116__$1 = state_55116;
var statearr_55120_55153 = state_55116__$1;
(statearr_55120_55153[(2)] = inst_55067);

(statearr_55120_55153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (15))){
var inst_55080 = (state_55116[(7)]);
var state_55116__$1 = state_55116;
var statearr_55121_55154 = state_55116__$1;
(statearr_55121_55154[(2)] = inst_55080);

(statearr_55121_55154[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (13))){
var inst_55084 = (state_55116[(2)]);
var inst_55085 = fluree.db.util.async.throw_err(inst_55084);
var state_55116__$1 = state_55116;
var statearr_55122_55155 = state_55116__$1;
(statearr_55122_55155[(2)] = inst_55085);

(statearr_55122_55155[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (6))){
var state_55116__$1 = state_55116;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55116__$1,(9),subject);
} else {
if((state_val_55117 === (17))){
var inst_55080 = (state_55116[(7)]);
var inst_55094 = cljs.core.first(inst_55080);
var state_55116__$1 = state_55116;
var statearr_55123_55156 = state_55116__$1;
(statearr_55123_55156[(2)] = inst_55094);

(statearr_55123_55156[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (3))){
var inst_55114 = (state_55116[(2)]);
var state_55116__$1 = state_55116;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55116__$1,inst_55114);
} else {
if((state_val_55117 === (12))){
var inst_55080 = (state_55116[(7)]);
var inst_55088 = (state_55116[(2)]);
var inst_55089 = cljs.core.vector_QMARK_(inst_55080);
var state_55116__$1 = (function (){var statearr_55124 = state_55116;
(statearr_55124[(8)] = inst_55088);

return statearr_55124;
})();
if(inst_55089){
var statearr_55125_55157 = state_55116__$1;
(statearr_55125_55157[(1)] = (14));

} else {
var statearr_55126_55158 = state_55116__$1;
(statearr_55126_55158[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (2))){
var _ = (function (){var statearr_55127 = state_55116;
(statearr_55127[(4)] = cljs.core.cons((5),(state_55116[(4)])));

return statearr_55127;
})();
var inst_55073 = fluree.db.util.async.channel_QMARK_(subject);
var state_55116__$1 = state_55116;
if(inst_55073){
var statearr_55128_55159 = state_55116__$1;
(statearr_55128_55159[(1)] = (6));

} else {
var statearr_55129_55160 = state_55116__$1;
(statearr_55129_55160[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (19))){
var inst_55097 = (state_55116[(2)]);
var state_55116__$1 = state_55116;
var statearr_55130_55161 = state_55116__$1;
(statearr_55130_55161[(2)] = inst_55097);

(statearr_55130_55161[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (11))){
var state_55116__$1 = state_55116;
var statearr_55132_55162 = state_55116__$1;
(statearr_55132_55162[(2)] = pred);

(statearr_55132_55162[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (9))){
var inst_55076 = (state_55116[(2)]);
var inst_55077 = fluree.db.util.async.throw_err(inst_55076);
var state_55116__$1 = state_55116;
var statearr_55133_55163 = state_55116__$1;
(statearr_55133_55163[(2)] = inst_55077);

(statearr_55133_55163[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (5))){
var _ = (function (){var statearr_55134 = state_55116;
(statearr_55134[(4)] = cljs.core.rest((state_55116[(4)])));

return statearr_55134;
})();
var state_55116__$1 = state_55116;
var ex55131 = (state_55116__$1[(2)]);
var statearr_55135_55164 = state_55116__$1;
(statearr_55135_55164[(5)] = ex55131);


if((ex55131 instanceof Error)){
var statearr_55136_55165 = state_55116__$1;
(statearr_55136_55165[(1)] = (4));

(statearr_55136_55165[(5)] = null);

} else {
throw ex55131;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (14))){
var inst_55080 = (state_55116[(7)]);
var inst_55091 = cljs.core.count(inst_55080);
var inst_55092 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55091);
var state_55116__$1 = state_55116;
if(inst_55092){
var statearr_55137_55166 = state_55116__$1;
(statearr_55137_55166[(1)] = (17));

} else {
var statearr_55138_55167 = state_55116__$1;
(statearr_55138_55167[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (16))){
var inst_55080 = (state_55116[(7)]);
var inst_55088 = (state_55116[(8)]);
var inst_55100 = (state_55116[(2)]);
var inst_55101 = fluree.db.dbfunctions.internal.get(inst_55100,inst_55088);
var inst_55102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55103 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55105 = [inst_55080,inst_55088];
var inst_55106 = (new cljs.core.PersistentVector(null,2,(5),inst_55104,inst_55105,null));
var inst_55107 = ["get",inst_55106,inst_55101];
var inst_55108 = cljs.core.PersistentHashMap.fromArrays(inst_55103,inst_55107);
var inst_55109 = [inst_55108,(10)];
var inst_55110 = (new cljs.core.PersistentVector(null,2,(5),inst_55102,inst_55109,null));
var inst_55111 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55110);
var _ = (function (){var statearr_55139 = state_55116;
(statearr_55139[(4)] = cljs.core.rest((state_55116[(4)])));

return statearr_55139;
})();
var state_55116__$1 = (function (){var statearr_55140 = state_55116;
(statearr_55140[(9)] = inst_55111);

return statearr_55140;
})();
var statearr_55141_55168 = state_55116__$1;
(statearr_55141_55168[(2)] = inst_55101);

(statearr_55141_55168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (10))){
var state_55116__$1 = state_55116;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55116__$1,(13),pred);
} else {
if((state_val_55117 === (18))){
var inst_55080 = (state_55116[(7)]);
var state_55116__$1 = state_55116;
var statearr_55142_55169 = state_55116__$1;
(statearr_55142_55169[(2)] = inst_55080);

(statearr_55142_55169[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55117 === (8))){
var inst_55080 = (state_55116[(2)]);
var inst_55081 = fluree.db.util.async.channel_QMARK_(pred);
var state_55116__$1 = (function (){var statearr_55143 = state_55116;
(statearr_55143[(7)] = inst_55080);

return statearr_55143;
})();
if(inst_55081){
var statearr_55144_55170 = state_55116__$1;
(statearr_55144_55170[(1)] = (10));

} else {
var statearr_55145_55171 = state_55116__$1;
(statearr_55145_55171[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto____0 = (function (){
var statearr_55146 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55146[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto__);

(statearr_55146[(1)] = (1));

return statearr_55146;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto____1 = (function (state_55116){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55116);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55147){var ex__2736__auto__ = e55147;
var statearr_55148_55172 = state_55116;
(statearr_55148_55172[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55116[(4)]))){
var statearr_55149_55173 = state_55116;
(statearr_55149_55173[(1)] = cljs.core.first((state_55116[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55174 = state_55116;
state_55116 = G__55174;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto__ = function(state_55116){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto____1.call(this,state_55116);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55150 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55150[(6)] = c__2755__auto__);

return statearr_55150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55213){
var state_val_55214 = (state_55213[(1)]);
if((state_val_55214 === (7))){
var inst_55181 = (state_55213[(7)]);
var state_55213__$1 = state_55213;
var statearr_55215_55239 = state_55213__$1;
(statearr_55215_55239[(2)] = inst_55181);

(statearr_55215_55239[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55214 === (1))){
var state_55213__$1 = state_55213;
var statearr_55216_55240 = state_55213__$1;
(statearr_55216_55240[(2)] = null);

(statearr_55216_55240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55214 === (4))){
var inst_55175 = (state_55213[(2)]);
var state_55213__$1 = state_55213;
var statearr_55217_55241 = state_55213__$1;
(statearr_55217_55241[(2)] = inst_55175);

(statearr_55217_55241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55214 === (6))){
var inst_55183 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55213__$1 = state_55213;
var statearr_55218_55242 = state_55213__$1;
(statearr_55218_55242[(2)] = inst_55183);

(statearr_55218_55242[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55214 === (3))){
var inst_55211 = (state_55213[(2)]);
var state_55213__$1 = state_55213;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55213__$1,inst_55211);
} else {
if((state_val_55214 === (12))){
var inst_55193 = (state_55213[(2)]);
var inst_55194 = fluree.db.util.async.throw_err(inst_55193);
var inst_55195 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55194,(0),null);
var inst_55196 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55194,(1),null);
var inst_55197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55198 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55199 = ["?pO","?ctx",inst_55195];
var inst_55200 = cljs.core.PersistentHashMap.fromArrays(inst_55198,inst_55199);
var inst_55201 = ((10) + inst_55196);
var inst_55202 = [inst_55200,inst_55201];
var inst_55203 = (new cljs.core.PersistentVector(null,2,(5),inst_55197,inst_55202,null));
var inst_55204 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55203);
var state_55213__$1 = (function (){var statearr_55219 = state_55213;
(statearr_55219[(8)] = inst_55204);

return statearr_55219;
})();
var statearr_55220_55243 = state_55213__$1;
(statearr_55220_55243[(2)] = inst_55195);

(statearr_55220_55243[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55214 === (2))){
var inst_55181 = (state_55213[(7)]);
var _ = (function (){var statearr_55221 = state_55213;
(statearr_55221[(4)] = cljs.core.cons((5),(state_55213[(4)])));

return statearr_55221;
})();
var inst_55181__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55213__$1 = (function (){var statearr_55222 = state_55213;
(statearr_55222[(7)] = inst_55181__$1);

return statearr_55222;
})();
if(cljs.core.truth_(inst_55181__$1)){
var statearr_55223_55244 = state_55213__$1;
(statearr_55223_55244[(1)] = (6));

} else {
var statearr_55224_55245 = state_55213__$1;
(statearr_55224_55245[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55214 === (11))){
var inst_55208 = (state_55213[(2)]);
var _ = (function (){var statearr_55226 = state_55213;
(statearr_55226[(4)] = cljs.core.rest((state_55213[(4)])));

return statearr_55226;
})();
var state_55213__$1 = state_55213;
var statearr_55227_55246 = state_55213__$1;
(statearr_55227_55246[(2)] = inst_55208);

(statearr_55227_55246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55214 === (9))){
var inst_55191 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_55213__$1 = state_55213;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55213__$1,(12),inst_55191);
} else {
if((state_val_55214 === (5))){
var _ = (function (){var statearr_55228 = state_55213;
(statearr_55228[(4)] = cljs.core.rest((state_55213[(4)])));

return statearr_55228;
})();
var state_55213__$1 = state_55213;
var ex55225 = (state_55213__$1[(2)]);
var statearr_55229_55247 = state_55213__$1;
(statearr_55229_55247[(5)] = ex55225);


if((ex55225 instanceof Error)){
var statearr_55230_55248 = state_55213__$1;
(statearr_55230_55248[(1)] = (4));

(statearr_55230_55248[(5)] = null);

} else {
throw ex55225;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55214 === (10))){
var inst_55206 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_55213__$1 = state_55213;
var statearr_55231_55249 = state_55213__$1;
(statearr_55231_55249[(2)] = inst_55206);

(statearr_55231_55249[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55214 === (8))){
var inst_55186 = (state_55213[(2)]);
var state_55213__$1 = state_55213;
if(cljs.core.truth_(inst_55186)){
var statearr_55232_55250 = state_55213__$1;
(statearr_55232_55250[(1)] = (9));

} else {
var statearr_55233_55251 = state_55213__$1;
(statearr_55233_55251[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto____0 = (function (){
var statearr_55234 = [null,null,null,null,null,null,null,null,null];
(statearr_55234[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto__);

(statearr_55234[(1)] = (1));

return statearr_55234;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto____1 = (function (state_55213){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55213);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55235){var ex__2736__auto__ = e55235;
var statearr_55236_55252 = state_55213;
(statearr_55236_55252[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55213[(4)]))){
var statearr_55237_55253 = state_55213;
(statearr_55237_55253[(1)] = cljs.core.first((state_55213[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55254 = state_55213;
state_55213 = G__55254;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto__ = function(state_55213){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto____1.call(this,state_55213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55238 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55238[(6)] = c__2755__auto__);

return statearr_55238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55306){
var state_val_55307 = (state_55306[(1)]);
if((state_val_55307 === (7))){
var state_55306__$1 = state_55306;
var statearr_55308_55341 = state_55306__$1;
(statearr_55308_55341[(2)] = subject);

(statearr_55308_55341[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (1))){
var state_55306__$1 = state_55306;
var statearr_55309_55342 = state_55306__$1;
(statearr_55309_55342[(2)] = null);

(statearr_55309_55342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (4))){
var inst_55255 = (state_55306[(2)]);
var state_55306__$1 = state_55306;
var statearr_55310_55343 = state_55306__$1;
(statearr_55310_55343[(2)] = inst_55255);

(statearr_55310_55343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (15))){
var inst_55268 = (state_55306[(7)]);
var state_55306__$1 = state_55306;
var statearr_55311_55344 = state_55306__$1;
(statearr_55311_55344[(2)] = inst_55268);

(statearr_55311_55344[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (13))){
var inst_55272 = (state_55306[(2)]);
var inst_55273 = fluree.db.util.async.throw_err(inst_55272);
var state_55306__$1 = state_55306;
var statearr_55312_55345 = state_55306__$1;
(statearr_55312_55345[(2)] = inst_55273);

(statearr_55312_55345[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (6))){
var state_55306__$1 = state_55306;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55306__$1,(9),subject);
} else {
if((state_val_55307 === (17))){
var inst_55268 = (state_55306[(7)]);
var inst_55282 = cljs.core.first(inst_55268);
var state_55306__$1 = state_55306;
var statearr_55313_55346 = state_55306__$1;
(statearr_55313_55346[(2)] = inst_55282);

(statearr_55313_55346[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (3))){
var inst_55304 = (state_55306[(2)]);
var state_55306__$1 = state_55306;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55306__$1,inst_55304);
} else {
if((state_val_55307 === (12))){
var inst_55268 = (state_55306[(7)]);
var inst_55276 = (state_55306[(2)]);
var inst_55277 = cljs.core.vector_QMARK_(inst_55268);
var state_55306__$1 = (function (){var statearr_55314 = state_55306;
(statearr_55314[(8)] = inst_55276);

return statearr_55314;
})();
if(inst_55277){
var statearr_55315_55347 = state_55306__$1;
(statearr_55315_55347[(1)] = (14));

} else {
var statearr_55316_55348 = state_55306__$1;
(statearr_55316_55348[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (2))){
var _ = (function (){var statearr_55317 = state_55306;
(statearr_55317[(4)] = cljs.core.cons((5),(state_55306[(4)])));

return statearr_55317;
})();
var inst_55261 = fluree.db.util.async.channel_QMARK_(subject);
var state_55306__$1 = state_55306;
if(inst_55261){
var statearr_55318_55349 = state_55306__$1;
(statearr_55318_55349[(1)] = (6));

} else {
var statearr_55319_55350 = state_55306__$1;
(statearr_55319_55350[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (19))){
var inst_55285 = (state_55306[(2)]);
var state_55306__$1 = state_55306;
var statearr_55320_55351 = state_55306__$1;
(statearr_55320_55351[(2)] = inst_55285);

(statearr_55320_55351[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (11))){
var state_55306__$1 = state_55306;
var statearr_55322_55352 = state_55306__$1;
(statearr_55322_55352[(2)] = path);

(statearr_55322_55352[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (9))){
var inst_55264 = (state_55306[(2)]);
var inst_55265 = fluree.db.util.async.throw_err(inst_55264);
var state_55306__$1 = state_55306;
var statearr_55323_55353 = state_55306__$1;
(statearr_55323_55353[(2)] = inst_55265);

(statearr_55323_55353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (5))){
var _ = (function (){var statearr_55324 = state_55306;
(statearr_55324[(4)] = cljs.core.rest((state_55306[(4)])));

return statearr_55324;
})();
var state_55306__$1 = state_55306;
var ex55321 = (state_55306__$1[(2)]);
var statearr_55325_55354 = state_55306__$1;
(statearr_55325_55354[(5)] = ex55321);


if((ex55321 instanceof Error)){
var statearr_55326_55355 = state_55306__$1;
(statearr_55326_55355[(1)] = (4));

(statearr_55326_55355[(5)] = null);

} else {
throw ex55321;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (14))){
var inst_55268 = (state_55306[(7)]);
var inst_55279 = cljs.core.count(inst_55268);
var inst_55280 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55279);
var state_55306__$1 = state_55306;
if(inst_55280){
var statearr_55327_55356 = state_55306__$1;
(statearr_55327_55356[(1)] = (17));

} else {
var statearr_55328_55357 = state_55306__$1;
(statearr_55328_55357[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (16))){
var inst_55268 = (state_55306[(7)]);
var inst_55276 = (state_55306[(8)]);
var inst_55288 = (state_55306[(2)]);
var inst_55289 = fluree.db.dbfunctions.internal.get_all(inst_55288,inst_55276);
var inst_55290 = cljs.core.count(inst_55276);
var inst_55291 = ((9) + inst_55290);
var inst_55292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55293 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55295 = [inst_55268,inst_55276];
var inst_55296 = (new cljs.core.PersistentVector(null,2,(5),inst_55294,inst_55295,null));
var inst_55297 = ["get-all",inst_55296,inst_55289];
var inst_55298 = cljs.core.PersistentHashMap.fromArrays(inst_55293,inst_55297);
var inst_55299 = [inst_55298,inst_55291];
var inst_55300 = (new cljs.core.PersistentVector(null,2,(5),inst_55292,inst_55299,null));
var inst_55301 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55300);
var _ = (function (){var statearr_55329 = state_55306;
(statearr_55329[(4)] = cljs.core.rest((state_55306[(4)])));

return statearr_55329;
})();
var state_55306__$1 = (function (){var statearr_55330 = state_55306;
(statearr_55330[(9)] = inst_55301);

return statearr_55330;
})();
var statearr_55331_55358 = state_55306__$1;
(statearr_55331_55358[(2)] = inst_55289);

(statearr_55331_55358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (10))){
var state_55306__$1 = state_55306;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55306__$1,(13),path);
} else {
if((state_val_55307 === (18))){
var inst_55268 = (state_55306[(7)]);
var state_55306__$1 = state_55306;
var statearr_55332_55359 = state_55306__$1;
(statearr_55332_55359[(2)] = inst_55268);

(statearr_55332_55359[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (8))){
var inst_55268 = (state_55306[(2)]);
var inst_55269 = fluree.db.util.async.channel_QMARK_(path);
var state_55306__$1 = (function (){var statearr_55333 = state_55306;
(statearr_55333[(7)] = inst_55268);

return statearr_55333;
})();
if(inst_55269){
var statearr_55334_55360 = state_55306__$1;
(statearr_55334_55360[(1)] = (10));

} else {
var statearr_55335_55361 = state_55306__$1;
(statearr_55335_55361[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto____0 = (function (){
var statearr_55336 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55336[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto__);

(statearr_55336[(1)] = (1));

return statearr_55336;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto____1 = (function (state_55306){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55306);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55337){var ex__2736__auto__ = e55337;
var statearr_55338_55362 = state_55306;
(statearr_55338_55362[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55306[(4)]))){
var statearr_55339_55363 = state_55306;
(statearr_55339_55363[(1)] = cljs.core.first((state_55306[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55364 = state_55306;
state_55306 = G__55364;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto__ = function(state_55306){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto____1.call(this,state_55306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55340 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55340[(6)] = c__2755__auto__);

return statearr_55340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55403){
var state_val_55404 = (state_55403[(1)]);
if((state_val_55404 === (7))){
var state_55403__$1 = state_55403;
var statearr_55405_55429 = state_55403__$1;
(statearr_55405_55429[(2)] = subject);

(statearr_55405_55429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (1))){
var state_55403__$1 = state_55403;
var statearr_55406_55430 = state_55403__$1;
(statearr_55406_55430[(2)] = null);

(statearr_55406_55430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (4))){
var inst_55365 = (state_55403[(2)]);
var state_55403__$1 = state_55403;
var statearr_55407_55431 = state_55403__$1;
(statearr_55407_55431[(2)] = inst_55365);

(statearr_55407_55431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (13))){
var inst_55382 = (state_55403[(2)]);
var inst_55383 = fluree.db.util.async.throw_err(inst_55382);
var state_55403__$1 = state_55403;
var statearr_55408_55432 = state_55403__$1;
(statearr_55408_55432[(2)] = inst_55383);

(statearr_55408_55432[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (6))){
var state_55403__$1 = state_55403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55403__$1,(9),subject);
} else {
if((state_val_55404 === (3))){
var inst_55401 = (state_55403[(2)]);
var state_55403__$1 = state_55403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55403__$1,inst_55401);
} else {
if((state_val_55404 === (12))){
var inst_55378 = (state_55403[(7)]);
var inst_55386 = (state_55403[(2)]);
var inst_55387 = fluree.db.dbfunctions.internal.get_in(inst_55378,inst_55386);
var inst_55388 = cljs.core.count(inst_55386);
var inst_55389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55390 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55392 = [inst_55378,inst_55386];
var inst_55393 = (new cljs.core.PersistentVector(null,2,(5),inst_55391,inst_55392,null));
var inst_55394 = ["get-in",inst_55393,inst_55387];
var inst_55395 = cljs.core.PersistentHashMap.fromArrays(inst_55390,inst_55394);
var inst_55396 = [inst_55395,inst_55388];
var inst_55397 = (new cljs.core.PersistentVector(null,2,(5),inst_55389,inst_55396,null));
var inst_55398 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55397);
var _ = (function (){var statearr_55409 = state_55403;
(statearr_55409[(4)] = cljs.core.rest((state_55403[(4)])));

return statearr_55409;
})();
var state_55403__$1 = (function (){var statearr_55410 = state_55403;
(statearr_55410[(8)] = inst_55398);

return statearr_55410;
})();
var statearr_55411_55433 = state_55403__$1;
(statearr_55411_55433[(2)] = inst_55387);

(statearr_55411_55433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (2))){
var _ = (function (){var statearr_55412 = state_55403;
(statearr_55412[(4)] = cljs.core.cons((5),(state_55403[(4)])));

return statearr_55412;
})();
var inst_55371 = fluree.db.util.async.channel_QMARK_(subject);
var state_55403__$1 = state_55403;
if(inst_55371){
var statearr_55413_55434 = state_55403__$1;
(statearr_55413_55434[(1)] = (6));

} else {
var statearr_55414_55435 = state_55403__$1;
(statearr_55414_55435[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (11))){
var state_55403__$1 = state_55403;
var statearr_55416_55436 = state_55403__$1;
(statearr_55416_55436[(2)] = path);

(statearr_55416_55436[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (9))){
var inst_55374 = (state_55403[(2)]);
var inst_55375 = fluree.db.util.async.throw_err(inst_55374);
var state_55403__$1 = state_55403;
var statearr_55417_55437 = state_55403__$1;
(statearr_55417_55437[(2)] = inst_55375);

(statearr_55417_55437[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (5))){
var _ = (function (){var statearr_55418 = state_55403;
(statearr_55418[(4)] = cljs.core.rest((state_55403[(4)])));

return statearr_55418;
})();
var state_55403__$1 = state_55403;
var ex55415 = (state_55403__$1[(2)]);
var statearr_55419_55438 = state_55403__$1;
(statearr_55419_55438[(5)] = ex55415);


if((ex55415 instanceof Error)){
var statearr_55420_55439 = state_55403__$1;
(statearr_55420_55439[(1)] = (4));

(statearr_55420_55439[(5)] = null);

} else {
throw ex55415;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55404 === (10))){
var state_55403__$1 = state_55403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55403__$1,(13),path);
} else {
if((state_val_55404 === (8))){
var inst_55378 = (state_55403[(2)]);
var inst_55379 = fluree.db.util.async.channel_QMARK_(path);
var state_55403__$1 = (function (){var statearr_55421 = state_55403;
(statearr_55421[(7)] = inst_55378);

return statearr_55421;
})();
if(inst_55379){
var statearr_55422_55440 = state_55403__$1;
(statearr_55422_55440[(1)] = (10));

} else {
var statearr_55423_55441 = state_55403__$1;
(statearr_55423_55441[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto____0 = (function (){
var statearr_55424 = [null,null,null,null,null,null,null,null,null];
(statearr_55424[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto__);

(statearr_55424[(1)] = (1));

return statearr_55424;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto____1 = (function (state_55403){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55403);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55425){var ex__2736__auto__ = e55425;
var statearr_55426_55442 = state_55403;
(statearr_55426_55442[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55403[(4)]))){
var statearr_55427_55443 = state_55403;
(statearr_55427_55443[(1)] = cljs.core.first((state_55403[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55444 = state_55403;
state_55403 = G__55444;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto__ = function(state_55403){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto____1.call(this,state_55403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55428 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55428[(6)] = c__2755__auto__);

return statearr_55428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55489){
var state_val_55490 = (state_55489[(1)]);
if((state_val_55490 === (7))){
var state_55489__$1 = state_55489;
var statearr_55491_55520 = state_55489__$1;
(statearr_55491_55520[(2)] = coll);

(statearr_55491_55520[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55490 === (1))){
var state_55489__$1 = state_55489;
var statearr_55492_55521 = state_55489__$1;
(statearr_55492_55521[(2)] = null);

(statearr_55492_55521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55490 === (4))){
var inst_55445 = (state_55489[(2)]);
var state_55489__$1 = state_55489;
var statearr_55493_55522 = state_55489__$1;
(statearr_55493_55522[(2)] = inst_55445);

(statearr_55493_55522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55490 === (15))){
var inst_55465 = (state_55489[(7)]);
var inst_55473 = (state_55489[(2)]);
var inst_55474 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_55465,inst_55473);
var inst_55475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55476 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55478 = [inst_55465,inst_55473];
var inst_55479 = (new cljs.core.PersistentVector(null,2,(5),inst_55477,inst_55478,null));
var inst_55480 = ["contains?",inst_55479,inst_55474];
var inst_55481 = cljs.core.PersistentHashMap.fromArrays(inst_55476,inst_55480);
var inst_55482 = [inst_55481,(10)];
var inst_55483 = (new cljs.core.PersistentVector(null,2,(5),inst_55475,inst_55482,null));
var inst_55484 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55483);
var _ = (function (){var statearr_55494 = state_55489;
(statearr_55494[(4)] = cljs.core.rest((state_55489[(4)])));

return statearr_55494;
})();
var state_55489__$1 = (function (){var statearr_55495 = state_55489;
(statearr_55495[(8)] = inst_55484);

return statearr_55495;
})();
var statearr_55496_55523 = state_55489__$1;
(statearr_55496_55523[(2)] = inst_55474);

(statearr_55496_55523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55490 === (13))){
var state_55489__$1 = state_55489;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55489__$1,(16),key);
} else {
if((state_val_55490 === (6))){
var state_55489__$1 = state_55489;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55489__$1,(9),coll);
} else {
if((state_val_55490 === (3))){
var inst_55487 = (state_55489[(2)]);
var state_55489__$1 = state_55489;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55489__$1,inst_55487);
} else {
if((state_val_55490 === (12))){
var inst_55465 = (state_55489[(2)]);
var inst_55466 = fluree.db.util.async.channel_QMARK_(key);
var state_55489__$1 = (function (){var statearr_55497 = state_55489;
(statearr_55497[(7)] = inst_55465);

return statearr_55497;
})();
if(inst_55466){
var statearr_55498_55524 = state_55489__$1;
(statearr_55498_55524[(1)] = (13));

} else {
var statearr_55499_55525 = state_55489__$1;
(statearr_55499_55525[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55490 === (2))){
var _ = (function (){var statearr_55500 = state_55489;
(statearr_55500[(4)] = cljs.core.cons((5),(state_55489[(4)])));

return statearr_55500;
})();
var inst_55451 = fluree.db.util.async.channel_QMARK_(coll);
var state_55489__$1 = state_55489;
if(inst_55451){
var statearr_55501_55526 = state_55489__$1;
(statearr_55501_55526[(1)] = (6));

} else {
var statearr_55502_55527 = state_55489__$1;
(statearr_55502_55527[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55490 === (11))){
var inst_55458 = (state_55489[(9)]);
var inst_55462 = cljs.core.flatten(inst_55458);
var inst_55463 = cljs.core.set(inst_55462);
var state_55489__$1 = state_55489;
var statearr_55504_55528 = state_55489__$1;
(statearr_55504_55528[(2)] = inst_55463);

(statearr_55504_55528[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55490 === (9))){
var inst_55454 = (state_55489[(2)]);
var inst_55455 = fluree.db.util.async.throw_err(inst_55454);
var state_55489__$1 = state_55489;
var statearr_55505_55529 = state_55489__$1;
(statearr_55505_55529[(2)] = inst_55455);

(statearr_55505_55529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55490 === (5))){
var _ = (function (){var statearr_55506 = state_55489;
(statearr_55506[(4)] = cljs.core.rest((state_55489[(4)])));

return statearr_55506;
})();
var state_55489__$1 = state_55489;
var ex55503 = (state_55489__$1[(2)]);
var statearr_55507_55530 = state_55489__$1;
(statearr_55507_55530[(5)] = ex55503);


if((ex55503 instanceof Error)){
var statearr_55508_55531 = state_55489__$1;
(statearr_55508_55531[(1)] = (4));

(statearr_55508_55531[(5)] = null);

} else {
throw ex55503;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55490 === (14))){
var state_55489__$1 = state_55489;
var statearr_55509_55532 = state_55489__$1;
(statearr_55509_55532[(2)] = key);

(statearr_55509_55532[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55490 === (16))){
var inst_55469 = (state_55489[(2)]);
var inst_55470 = fluree.db.util.async.throw_err(inst_55469);
var state_55489__$1 = state_55489;
var statearr_55510_55533 = state_55489__$1;
(statearr_55510_55533[(2)] = inst_55470);

(statearr_55510_55533[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55490 === (10))){
var inst_55458 = (state_55489[(9)]);
var state_55489__$1 = state_55489;
var statearr_55511_55534 = state_55489__$1;
(statearr_55511_55534[(2)] = inst_55458);

(statearr_55511_55534[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55490 === (8))){
var inst_55458 = (state_55489[(9)]);
var inst_55458__$1 = (state_55489[(2)]);
var inst_55459 = cljs.core.set_QMARK_(inst_55458__$1);
var state_55489__$1 = (function (){var statearr_55512 = state_55489;
(statearr_55512[(9)] = inst_55458__$1);

return statearr_55512;
})();
if(inst_55459){
var statearr_55513_55535 = state_55489__$1;
(statearr_55513_55535[(1)] = (10));

} else {
var statearr_55514_55536 = state_55489__$1;
(statearr_55514_55536[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_55515 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55515[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto__);

(statearr_55515[(1)] = (1));

return statearr_55515;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto____1 = (function (state_55489){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55489);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55516){var ex__2736__auto__ = e55516;
var statearr_55517_55537 = state_55489;
(statearr_55517_55537[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55489[(4)]))){
var statearr_55518_55538 = state_55489;
(statearr_55518_55538[(1)] = cljs.core.first((state_55489[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55539 = state_55489;
state_55489 = G__55539;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto__ = function(state_55489){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto____1.call(this,state_55489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55519 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55519[(6)] = c__2755__auto__);

return statearr_55519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55611 = arguments.length;
var i__4830__auto___55612 = (0);
while(true){
if((i__4830__auto___55612 < len__4829__auto___55611)){
args__4835__auto__.push((arguments[i__4830__auto___55612]));

var G__55613 = (i__4830__auto___55612 + (1));
i__4830__auto___55612 = G__55613;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55585){
var state_val_55586 = (state_55585[(1)]);
if((state_val_55586 === (7))){
var inst_55551 = (state_55585[(7)]);
var inst_55555 = cljs.core.first(inst_55551);
var inst_55556 = cljs.core.coll_QMARK_(inst_55555);
var state_55585__$1 = state_55585;
var statearr_55587_55614 = state_55585__$1;
(statearr_55587_55614[(2)] = inst_55556);

(statearr_55587_55614[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55586 === (1))){
var state_55585__$1 = state_55585;
var statearr_55588_55615 = state_55585__$1;
(statearr_55588_55615[(2)] = null);

(statearr_55588_55615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55586 === (4))){
var inst_55542 = (state_55585[(2)]);
var state_55585__$1 = state_55585;
var statearr_55589_55616 = state_55585__$1;
(statearr_55589_55616[(2)] = inst_55542);

(statearr_55589_55616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55586 === (6))){
var inst_55553 = (state_55585[(8)]);
var inst_55551 = (state_55585[(7)]);
var inst_55550 = (state_55585[(2)]);
var inst_55551__$1 = fluree.db.util.async.throw_err(inst_55550);
var inst_55552 = cljs.core.count(inst_55551__$1);
var inst_55553__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55552);
var state_55585__$1 = (function (){var statearr_55590 = state_55585;
(statearr_55590[(8)] = inst_55553__$1);

(statearr_55590[(7)] = inst_55551__$1);

return statearr_55590;
})();
if(inst_55553__$1){
var statearr_55591_55617 = state_55585__$1;
(statearr_55591_55617[(1)] = (7));

} else {
var statearr_55592_55618 = state_55585__$1;
(statearr_55592_55618[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55586 === (3))){
var inst_55583 = (state_55585[(2)]);
var state_55585__$1 = state_55585;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55585__$1,inst_55583);
} else {
if((state_val_55586 === (12))){
var inst_55564 = (state_55585[(2)]);
var inst_55565 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_55564);
var inst_55566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55567 = [inst_55564];
var inst_55568 = (new cljs.core.PersistentVector(null,1,(5),inst_55566,inst_55567,null));
var inst_55569 = cljs.core.count(inst_55568);
var inst_55570 = ((9) + inst_55569);
var inst_55571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55572 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55574 = [inst_55564];
var inst_55575 = (new cljs.core.PersistentVector(null,1,(5),inst_55573,inst_55574,null));
var inst_55576 = ["hash-set",inst_55575,inst_55565];
var inst_55577 = cljs.core.PersistentHashMap.fromArrays(inst_55572,inst_55576);
var inst_55578 = [inst_55577,inst_55570];
var inst_55579 = (new cljs.core.PersistentVector(null,2,(5),inst_55571,inst_55578,null));
var inst_55580 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55579);
var _ = (function (){var statearr_55593 = state_55585;
(statearr_55593[(4)] = cljs.core.rest((state_55585[(4)])));

return statearr_55593;
})();
var state_55585__$1 = (function (){var statearr_55594 = state_55585;
(statearr_55594[(9)] = inst_55580);

return statearr_55594;
})();
var statearr_55595_55619 = state_55585__$1;
(statearr_55595_55619[(2)] = inst_55565);

(statearr_55595_55619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55586 === (2))){
var _ = (function (){var statearr_55596 = state_55585;
(statearr_55596[(4)] = cljs.core.cons((5),(state_55585[(4)])));

return statearr_55596;
})();
var inst_55548 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55585__$1 = state_55585;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55585__$1,(6),inst_55548);
} else {
if((state_val_55586 === (11))){
var inst_55551 = (state_55585[(7)]);
var state_55585__$1 = state_55585;
var statearr_55598_55620 = state_55585__$1;
(statearr_55598_55620[(2)] = inst_55551);

(statearr_55598_55620[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55586 === (9))){
var inst_55559 = (state_55585[(2)]);
var state_55585__$1 = state_55585;
if(cljs.core.truth_(inst_55559)){
var statearr_55599_55621 = state_55585__$1;
(statearr_55599_55621[(1)] = (10));

} else {
var statearr_55600_55622 = state_55585__$1;
(statearr_55600_55622[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55586 === (5))){
var _ = (function (){var statearr_55601 = state_55585;
(statearr_55601[(4)] = cljs.core.rest((state_55585[(4)])));

return statearr_55601;
})();
var state_55585__$1 = state_55585;
var ex55597 = (state_55585__$1[(2)]);
var statearr_55602_55623 = state_55585__$1;
(statearr_55602_55623[(5)] = ex55597);


if((ex55597 instanceof Error)){
var statearr_55603_55624 = state_55585__$1;
(statearr_55603_55624[(1)] = (4));

(statearr_55603_55624[(5)] = null);

} else {
throw ex55597;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55586 === (10))){
var inst_55551 = (state_55585[(7)]);
var inst_55561 = cljs.core.first(inst_55551);
var state_55585__$1 = state_55585;
var statearr_55604_55625 = state_55585__$1;
(statearr_55604_55625[(2)] = inst_55561);

(statearr_55604_55625[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55586 === (8))){
var inst_55553 = (state_55585[(8)]);
var state_55585__$1 = state_55585;
var statearr_55605_55626 = state_55585__$1;
(statearr_55605_55626[(2)] = inst_55553);

(statearr_55605_55626[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_55606 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55606[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_55606[(1)] = (1));

return statearr_55606;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_55585){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55585);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55607){var ex__2736__auto__ = e55607;
var statearr_55608_55627 = state_55585;
(statearr_55608_55627[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55585[(4)]))){
var statearr_55609_55628 = state_55585;
(statearr_55609_55628[(1)] = cljs.core.first((state_55585[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55629 = state_55585;
state_55585 = G__55629;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_55585){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_55585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55610 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55610[(6)] = c__2755__auto__);

return statearr_55610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq55540){
var G__55541 = cljs.core.first(seq55540);
var seq55540__$1 = cljs.core.next(seq55540);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55541,seq55540__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55679 = arguments.length;
var i__4830__auto___55680 = (0);
while(true){
if((i__4830__auto___55680 < len__4829__auto___55679)){
args__4835__auto__.push((arguments[i__4830__auto___55680]));

var G__55681 = (i__4830__auto___55680 + (1));
i__4830__auto___55680 = G__55681;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55662){
var state_val_55663 = (state_55662[(1)]);
if((state_val_55663 === (1))){
var state_55662__$1 = state_55662;
var statearr_55664_55682 = state_55662__$1;
(statearr_55664_55682[(2)] = null);

(statearr_55664_55682[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55663 === (2))){
var _ = (function (){var statearr_55665 = state_55662;
(statearr_55665[(4)] = cljs.core.cons((5),(state_55662[(4)])));

return statearr_55665;
})();
var inst_55638 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55662__$1 = state_55662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55662__$1,(6),inst_55638);
} else {
if((state_val_55663 === (3))){
var inst_55660 = (state_55662[(2)]);
var state_55662__$1 = state_55662;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55662__$1,inst_55660);
} else {
if((state_val_55663 === (4))){
var inst_55632 = (state_55662[(2)]);
var state_55662__$1 = state_55662;
var statearr_55667_55683 = state_55662__$1;
(statearr_55667_55683[(2)] = inst_55632);

(statearr_55667_55683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55663 === (5))){
var _ = (function (){var statearr_55668 = state_55662;
(statearr_55668[(4)] = cljs.core.rest((state_55662[(4)])));

return statearr_55668;
})();
var state_55662__$1 = state_55662;
var ex55666 = (state_55662__$1[(2)]);
var statearr_55669_55684 = state_55662__$1;
(statearr_55669_55684[(5)] = ex55666);


if((ex55666 instanceof Error)){
var statearr_55670_55685 = state_55662__$1;
(statearr_55670_55685[(1)] = (4));

(statearr_55670_55685[(5)] = null);

} else {
throw ex55666;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55663 === (6))){
var inst_55640 = (state_55662[(2)]);
var inst_55641 = fluree.db.util.async.throw_err(inst_55640);
var inst_55642 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_55641);
var inst_55643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55644 = [inst_55641];
var inst_55645 = (new cljs.core.PersistentVector(null,1,(5),inst_55643,inst_55644,null));
var inst_55646 = cljs.core.count(inst_55645);
var inst_55647 = ((9) + inst_55646);
var inst_55648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55649 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55651 = [inst_55641];
var inst_55652 = (new cljs.core.PersistentVector(null,1,(5),inst_55650,inst_55651,null));
var inst_55653 = ["==",inst_55652,inst_55642];
var inst_55654 = cljs.core.PersistentHashMap.fromArrays(inst_55649,inst_55653);
var inst_55655 = [inst_55654,inst_55647];
var inst_55656 = (new cljs.core.PersistentVector(null,2,(5),inst_55648,inst_55655,null));
var inst_55657 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55656);
var _ = (function (){var statearr_55671 = state_55662;
(statearr_55671[(4)] = cljs.core.rest((state_55662[(4)])));

return statearr_55671;
})();
var state_55662__$1 = (function (){var statearr_55672 = state_55662;
(statearr_55672[(7)] = inst_55657);

return statearr_55672;
})();
var statearr_55673_55686 = state_55662__$1;
(statearr_55673_55686[(2)] = inst_55642);

(statearr_55673_55686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_55674 = [null,null,null,null,null,null,null,null];
(statearr_55674[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_55674[(1)] = (1));

return statearr_55674;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_55662){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55662);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55675){var ex__2736__auto__ = e55675;
var statearr_55676_55687 = state_55662;
(statearr_55676_55687[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55662[(4)]))){
var statearr_55677_55688 = state_55662;
(statearr_55677_55688[(1)] = cljs.core.first((state_55662[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55689 = state_55662;
state_55662 = G__55689;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_55662){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_55662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55678 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55678[(6)] = c__2755__auto__);

return statearr_55678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55630){
var G__55631 = cljs.core.first(seq55630);
var seq55630__$1 = cljs.core.next(seq55630);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55631,seq55630__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55739 = arguments.length;
var i__4830__auto___55740 = (0);
while(true){
if((i__4830__auto___55740 < len__4829__auto___55739)){
args__4835__auto__.push((arguments[i__4830__auto___55740]));

var G__55741 = (i__4830__auto___55740 + (1));
i__4830__auto___55740 = G__55741;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55722){
var state_val_55723 = (state_55722[(1)]);
if((state_val_55723 === (1))){
var state_55722__$1 = state_55722;
var statearr_55724_55742 = state_55722__$1;
(statearr_55724_55742[(2)] = null);

(statearr_55724_55742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55723 === (2))){
var _ = (function (){var statearr_55725 = state_55722;
(statearr_55725[(4)] = cljs.core.cons((5),(state_55722[(4)])));

return statearr_55725;
})();
var inst_55698 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55722__$1 = state_55722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55722__$1,(6),inst_55698);
} else {
if((state_val_55723 === (3))){
var inst_55720 = (state_55722[(2)]);
var state_55722__$1 = state_55722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55722__$1,inst_55720);
} else {
if((state_val_55723 === (4))){
var inst_55692 = (state_55722[(2)]);
var state_55722__$1 = state_55722;
var statearr_55727_55743 = state_55722__$1;
(statearr_55727_55743[(2)] = inst_55692);

(statearr_55727_55743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55723 === (5))){
var _ = (function (){var statearr_55728 = state_55722;
(statearr_55728[(4)] = cljs.core.rest((state_55722[(4)])));

return statearr_55728;
})();
var state_55722__$1 = state_55722;
var ex55726 = (state_55722__$1[(2)]);
var statearr_55729_55744 = state_55722__$1;
(statearr_55729_55744[(5)] = ex55726);


if((ex55726 instanceof Error)){
var statearr_55730_55745 = state_55722__$1;
(statearr_55730_55745[(1)] = (4));

(statearr_55730_55745[(5)] = null);

} else {
throw ex55726;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55723 === (6))){
var inst_55700 = (state_55722[(2)]);
var inst_55701 = fluree.db.util.async.throw_err(inst_55700);
var inst_55702 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_55701);
var inst_55703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55704 = [inst_55701];
var inst_55705 = (new cljs.core.PersistentVector(null,1,(5),inst_55703,inst_55704,null));
var inst_55706 = cljs.core.count(inst_55705);
var inst_55707 = ((9) + inst_55706);
var inst_55708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55709 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55711 = [inst_55701];
var inst_55712 = (new cljs.core.PersistentVector(null,1,(5),inst_55710,inst_55711,null));
var inst_55713 = [">",inst_55712,inst_55702];
var inst_55714 = cljs.core.PersistentHashMap.fromArrays(inst_55709,inst_55713);
var inst_55715 = [inst_55714,inst_55707];
var inst_55716 = (new cljs.core.PersistentVector(null,2,(5),inst_55708,inst_55715,null));
var inst_55717 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55716);
var _ = (function (){var statearr_55731 = state_55722;
(statearr_55731[(4)] = cljs.core.rest((state_55722[(4)])));

return statearr_55731;
})();
var state_55722__$1 = (function (){var statearr_55732 = state_55722;
(statearr_55732[(7)] = inst_55717);

return statearr_55732;
})();
var statearr_55733_55746 = state_55722__$1;
(statearr_55733_55746[(2)] = inst_55702);

(statearr_55733_55746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_55734 = [null,null,null,null,null,null,null,null];
(statearr_55734[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_55734[(1)] = (1));

return statearr_55734;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_55722){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55722);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55735){var ex__2736__auto__ = e55735;
var statearr_55736_55747 = state_55722;
(statearr_55736_55747[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55722[(4)]))){
var statearr_55737_55748 = state_55722;
(statearr_55737_55748[(1)] = cljs.core.first((state_55722[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55749 = state_55722;
state_55722 = G__55749;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_55722){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_55722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55738 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55738[(6)] = c__2755__auto__);

return statearr_55738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55690){
var G__55691 = cljs.core.first(seq55690);
var seq55690__$1 = cljs.core.next(seq55690);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55691,seq55690__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55799 = arguments.length;
var i__4830__auto___55800 = (0);
while(true){
if((i__4830__auto___55800 < len__4829__auto___55799)){
args__4835__auto__.push((arguments[i__4830__auto___55800]));

var G__55801 = (i__4830__auto___55800 + (1));
i__4830__auto___55800 = G__55801;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55782){
var state_val_55783 = (state_55782[(1)]);
if((state_val_55783 === (1))){
var state_55782__$1 = state_55782;
var statearr_55784_55802 = state_55782__$1;
(statearr_55784_55802[(2)] = null);

(statearr_55784_55802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55783 === (2))){
var _ = (function (){var statearr_55785 = state_55782;
(statearr_55785[(4)] = cljs.core.cons((5),(state_55782[(4)])));

return statearr_55785;
})();
var inst_55758 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55782__$1 = state_55782;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55782__$1,(6),inst_55758);
} else {
if((state_val_55783 === (3))){
var inst_55780 = (state_55782[(2)]);
var state_55782__$1 = state_55782;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55782__$1,inst_55780);
} else {
if((state_val_55783 === (4))){
var inst_55752 = (state_55782[(2)]);
var state_55782__$1 = state_55782;
var statearr_55787_55803 = state_55782__$1;
(statearr_55787_55803[(2)] = inst_55752);

(statearr_55787_55803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55783 === (5))){
var _ = (function (){var statearr_55788 = state_55782;
(statearr_55788[(4)] = cljs.core.rest((state_55782[(4)])));

return statearr_55788;
})();
var state_55782__$1 = state_55782;
var ex55786 = (state_55782__$1[(2)]);
var statearr_55789_55804 = state_55782__$1;
(statearr_55789_55804[(5)] = ex55786);


if((ex55786 instanceof Error)){
var statearr_55790_55805 = state_55782__$1;
(statearr_55790_55805[(1)] = (4));

(statearr_55790_55805[(5)] = null);

} else {
throw ex55786;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55783 === (6))){
var inst_55760 = (state_55782[(2)]);
var inst_55761 = fluree.db.util.async.throw_err(inst_55760);
var inst_55762 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_55761);
var inst_55763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55764 = [inst_55761];
var inst_55765 = (new cljs.core.PersistentVector(null,1,(5),inst_55763,inst_55764,null));
var inst_55766 = cljs.core.count(inst_55765);
var inst_55767 = ((9) + inst_55766);
var inst_55768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55769 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55771 = [inst_55761];
var inst_55772 = (new cljs.core.PersistentVector(null,1,(5),inst_55770,inst_55771,null));
var inst_55773 = ["<",inst_55772,inst_55762];
var inst_55774 = cljs.core.PersistentHashMap.fromArrays(inst_55769,inst_55773);
var inst_55775 = [inst_55774,inst_55767];
var inst_55776 = (new cljs.core.PersistentVector(null,2,(5),inst_55768,inst_55775,null));
var inst_55777 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55776);
var _ = (function (){var statearr_55791 = state_55782;
(statearr_55791[(4)] = cljs.core.rest((state_55782[(4)])));

return statearr_55791;
})();
var state_55782__$1 = (function (){var statearr_55792 = state_55782;
(statearr_55792[(7)] = inst_55777);

return statearr_55792;
})();
var statearr_55793_55806 = state_55782__$1;
(statearr_55793_55806[(2)] = inst_55762);

(statearr_55793_55806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_55794 = [null,null,null,null,null,null,null,null];
(statearr_55794[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_55794[(1)] = (1));

return statearr_55794;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_55782){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55782);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55795){var ex__2736__auto__ = e55795;
var statearr_55796_55807 = state_55782;
(statearr_55796_55807[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55782[(4)]))){
var statearr_55797_55808 = state_55782;
(statearr_55797_55808[(1)] = cljs.core.first((state_55782[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55809 = state_55782;
state_55782 = G__55809;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_55782){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_55782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55798 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55798[(6)] = c__2755__auto__);

return statearr_55798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq55750){
var G__55751 = cljs.core.first(seq55750);
var seq55750__$1 = cljs.core.next(seq55750);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55751,seq55750__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55859 = arguments.length;
var i__4830__auto___55860 = (0);
while(true){
if((i__4830__auto___55860 < len__4829__auto___55859)){
args__4835__auto__.push((arguments[i__4830__auto___55860]));

var G__55861 = (i__4830__auto___55860 + (1));
i__4830__auto___55860 = G__55861;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55842){
var state_val_55843 = (state_55842[(1)]);
if((state_val_55843 === (1))){
var state_55842__$1 = state_55842;
var statearr_55844_55862 = state_55842__$1;
(statearr_55844_55862[(2)] = null);

(statearr_55844_55862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55843 === (2))){
var _ = (function (){var statearr_55845 = state_55842;
(statearr_55845[(4)] = cljs.core.cons((5),(state_55842[(4)])));

return statearr_55845;
})();
var inst_55818 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55842__$1 = state_55842;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55842__$1,(6),inst_55818);
} else {
if((state_val_55843 === (3))){
var inst_55840 = (state_55842[(2)]);
var state_55842__$1 = state_55842;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55842__$1,inst_55840);
} else {
if((state_val_55843 === (4))){
var inst_55812 = (state_55842[(2)]);
var state_55842__$1 = state_55842;
var statearr_55847_55863 = state_55842__$1;
(statearr_55847_55863[(2)] = inst_55812);

(statearr_55847_55863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55843 === (5))){
var _ = (function (){var statearr_55848 = state_55842;
(statearr_55848[(4)] = cljs.core.rest((state_55842[(4)])));

return statearr_55848;
})();
var state_55842__$1 = state_55842;
var ex55846 = (state_55842__$1[(2)]);
var statearr_55849_55864 = state_55842__$1;
(statearr_55849_55864[(5)] = ex55846);


if((ex55846 instanceof Error)){
var statearr_55850_55865 = state_55842__$1;
(statearr_55850_55865[(1)] = (4));

(statearr_55850_55865[(5)] = null);

} else {
throw ex55846;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55843 === (6))){
var inst_55820 = (state_55842[(2)]);
var inst_55821 = fluree.db.util.async.throw_err(inst_55820);
var inst_55822 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_55821);
var inst_55823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55824 = [inst_55821];
var inst_55825 = (new cljs.core.PersistentVector(null,1,(5),inst_55823,inst_55824,null));
var inst_55826 = cljs.core.count(inst_55825);
var inst_55827 = ((9) + inst_55826);
var inst_55828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55829 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55831 = [inst_55821];
var inst_55832 = (new cljs.core.PersistentVector(null,1,(5),inst_55830,inst_55831,null));
var inst_55833 = ["<=",inst_55832,inst_55822];
var inst_55834 = cljs.core.PersistentHashMap.fromArrays(inst_55829,inst_55833);
var inst_55835 = [inst_55834,inst_55827];
var inst_55836 = (new cljs.core.PersistentVector(null,2,(5),inst_55828,inst_55835,null));
var inst_55837 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55836);
var _ = (function (){var statearr_55851 = state_55842;
(statearr_55851[(4)] = cljs.core.rest((state_55842[(4)])));

return statearr_55851;
})();
var state_55842__$1 = (function (){var statearr_55852 = state_55842;
(statearr_55852[(7)] = inst_55837);

return statearr_55852;
})();
var statearr_55853_55866 = state_55842__$1;
(statearr_55853_55866[(2)] = inst_55822);

(statearr_55853_55866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_55854 = [null,null,null,null,null,null,null,null];
(statearr_55854[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_55854[(1)] = (1));

return statearr_55854;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_55842){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55842);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55855){var ex__2736__auto__ = e55855;
var statearr_55856_55867 = state_55842;
(statearr_55856_55867[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55842[(4)]))){
var statearr_55857_55868 = state_55842;
(statearr_55857_55868[(1)] = cljs.core.first((state_55842[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55869 = state_55842;
state_55842 = G__55869;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_55842){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_55842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55858 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55858[(6)] = c__2755__auto__);

return statearr_55858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq55810){
var G__55811 = cljs.core.first(seq55810);
var seq55810__$1 = cljs.core.next(seq55810);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55811,seq55810__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55919 = arguments.length;
var i__4830__auto___55920 = (0);
while(true){
if((i__4830__auto___55920 < len__4829__auto___55919)){
args__4835__auto__.push((arguments[i__4830__auto___55920]));

var G__55921 = (i__4830__auto___55920 + (1));
i__4830__auto___55920 = G__55921;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55902){
var state_val_55903 = (state_55902[(1)]);
if((state_val_55903 === (1))){
var state_55902__$1 = state_55902;
var statearr_55904_55922 = state_55902__$1;
(statearr_55904_55922[(2)] = null);

(statearr_55904_55922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55903 === (2))){
var _ = (function (){var statearr_55905 = state_55902;
(statearr_55905[(4)] = cljs.core.cons((5),(state_55902[(4)])));

return statearr_55905;
})();
var inst_55878 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55902__$1 = state_55902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55902__$1,(6),inst_55878);
} else {
if((state_val_55903 === (3))){
var inst_55900 = (state_55902[(2)]);
var state_55902__$1 = state_55902;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55902__$1,inst_55900);
} else {
if((state_val_55903 === (4))){
var inst_55872 = (state_55902[(2)]);
var state_55902__$1 = state_55902;
var statearr_55907_55923 = state_55902__$1;
(statearr_55907_55923[(2)] = inst_55872);

(statearr_55907_55923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55903 === (5))){
var _ = (function (){var statearr_55908 = state_55902;
(statearr_55908[(4)] = cljs.core.rest((state_55902[(4)])));

return statearr_55908;
})();
var state_55902__$1 = state_55902;
var ex55906 = (state_55902__$1[(2)]);
var statearr_55909_55924 = state_55902__$1;
(statearr_55909_55924[(5)] = ex55906);


if((ex55906 instanceof Error)){
var statearr_55910_55925 = state_55902__$1;
(statearr_55910_55925[(1)] = (4));

(statearr_55910_55925[(5)] = null);

} else {
throw ex55906;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55903 === (6))){
var inst_55880 = (state_55902[(2)]);
var inst_55881 = fluree.db.util.async.throw_err(inst_55880);
var inst_55882 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_55881);
var inst_55883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55884 = [inst_55881];
var inst_55885 = (new cljs.core.PersistentVector(null,1,(5),inst_55883,inst_55884,null));
var inst_55886 = cljs.core.count(inst_55885);
var inst_55887 = ((9) + inst_55886);
var inst_55888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55889 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55891 = [inst_55881];
var inst_55892 = (new cljs.core.PersistentVector(null,1,(5),inst_55890,inst_55891,null));
var inst_55893 = [">=",inst_55892,inst_55882];
var inst_55894 = cljs.core.PersistentHashMap.fromArrays(inst_55889,inst_55893);
var inst_55895 = [inst_55894,inst_55887];
var inst_55896 = (new cljs.core.PersistentVector(null,2,(5),inst_55888,inst_55895,null));
var inst_55897 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55896);
var _ = (function (){var statearr_55911 = state_55902;
(statearr_55911[(4)] = cljs.core.rest((state_55902[(4)])));

return statearr_55911;
})();
var state_55902__$1 = (function (){var statearr_55912 = state_55902;
(statearr_55912[(7)] = inst_55897);

return statearr_55912;
})();
var statearr_55913_55926 = state_55902__$1;
(statearr_55913_55926[(2)] = inst_55882);

(statearr_55913_55926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_55914 = [null,null,null,null,null,null,null,null];
(statearr_55914[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_55914[(1)] = (1));

return statearr_55914;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_55902){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55902);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55915){var ex__2736__auto__ = e55915;
var statearr_55916_55927 = state_55902;
(statearr_55916_55927[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55902[(4)]))){
var statearr_55917_55928 = state_55902;
(statearr_55917_55928[(1)] = cljs.core.first((state_55902[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55929 = state_55902;
state_55902 = G__55929;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_55902){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_55902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55918 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55918[(6)] = c__2755__auto__);

return statearr_55918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq55870){
var G__55871 = cljs.core.first(seq55870);
var seq55870__$1 = cljs.core.next(seq55870);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55871,seq55870__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55979 = arguments.length;
var i__4830__auto___55980 = (0);
while(true){
if((i__4830__auto___55980 < len__4829__auto___55979)){
args__4835__auto__.push((arguments[i__4830__auto___55980]));

var G__55981 = (i__4830__auto___55980 + (1));
i__4830__auto___55980 = G__55981;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55962){
var state_val_55963 = (state_55962[(1)]);
if((state_val_55963 === (1))){
var state_55962__$1 = state_55962;
var statearr_55964_55982 = state_55962__$1;
(statearr_55964_55982[(2)] = null);

(statearr_55964_55982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (2))){
var _ = (function (){var statearr_55965 = state_55962;
(statearr_55965[(4)] = cljs.core.cons((5),(state_55962[(4)])));

return statearr_55965;
})();
var inst_55938 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55962__$1 = state_55962;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55962__$1,(6),inst_55938);
} else {
if((state_val_55963 === (3))){
var inst_55960 = (state_55962[(2)]);
var state_55962__$1 = state_55962;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55962__$1,inst_55960);
} else {
if((state_val_55963 === (4))){
var inst_55932 = (state_55962[(2)]);
var state_55962__$1 = state_55962;
var statearr_55967_55983 = state_55962__$1;
(statearr_55967_55983[(2)] = inst_55932);

(statearr_55967_55983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (5))){
var _ = (function (){var statearr_55968 = state_55962;
(statearr_55968[(4)] = cljs.core.rest((state_55962[(4)])));

return statearr_55968;
})();
var state_55962__$1 = state_55962;
var ex55966 = (state_55962__$1[(2)]);
var statearr_55969_55984 = state_55962__$1;
(statearr_55969_55984[(5)] = ex55966);


if((ex55966 instanceof Error)){
var statearr_55970_55985 = state_55962__$1;
(statearr_55970_55985[(1)] = (4));

(statearr_55970_55985[(5)] = null);

} else {
throw ex55966;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (6))){
var inst_55940 = (state_55962[(2)]);
var inst_55941 = fluree.db.util.async.throw_err(inst_55940);
var inst_55942 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_55941);
var inst_55943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55944 = [inst_55941];
var inst_55945 = (new cljs.core.PersistentVector(null,1,(5),inst_55943,inst_55944,null));
var inst_55946 = cljs.core.count(inst_55945);
var inst_55947 = ((9) + inst_55946);
var inst_55948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55949 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55951 = [inst_55941];
var inst_55952 = (new cljs.core.PersistentVector(null,1,(5),inst_55950,inst_55951,null));
var inst_55953 = ["not=",inst_55952,inst_55942];
var inst_55954 = cljs.core.PersistentHashMap.fromArrays(inst_55949,inst_55953);
var inst_55955 = [inst_55954,inst_55947];
var inst_55956 = (new cljs.core.PersistentVector(null,2,(5),inst_55948,inst_55955,null));
var inst_55957 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55956);
var _ = (function (){var statearr_55971 = state_55962;
(statearr_55971[(4)] = cljs.core.rest((state_55962[(4)])));

return statearr_55971;
})();
var state_55962__$1 = (function (){var statearr_55972 = state_55962;
(statearr_55972[(7)] = inst_55957);

return statearr_55972;
})();
var statearr_55973_55986 = state_55962__$1;
(statearr_55973_55986[(2)] = inst_55942);

(statearr_55973_55986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_55974 = [null,null,null,null,null,null,null,null];
(statearr_55974[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_55974[(1)] = (1));

return statearr_55974;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_55962){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55962);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55975){var ex__2736__auto__ = e55975;
var statearr_55976_55987 = state_55962;
(statearr_55976_55987[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55962[(4)]))){
var statearr_55977_55988 = state_55962;
(statearr_55977_55988[(1)] = cljs.core.first((state_55962[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55989 = state_55962;
state_55962 = G__55989;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_55962){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_55962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55978 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55978[(6)] = c__2755__auto__);

return statearr_55978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq55930){
var G__55931 = cljs.core.first(seq55930);
var seq55930__$1 = cljs.core.next(seq55930);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55931,seq55930__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56039 = arguments.length;
var i__4830__auto___56040 = (0);
while(true){
if((i__4830__auto___56040 < len__4829__auto___56039)){
args__4835__auto__.push((arguments[i__4830__auto___56040]));

var G__56041 = (i__4830__auto___56040 + (1));
i__4830__auto___56040 = G__56041;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56022){
var state_val_56023 = (state_56022[(1)]);
if((state_val_56023 === (1))){
var state_56022__$1 = state_56022;
var statearr_56024_56042 = state_56022__$1;
(statearr_56024_56042[(2)] = null);

(statearr_56024_56042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56023 === (2))){
var _ = (function (){var statearr_56025 = state_56022;
(statearr_56025[(4)] = cljs.core.cons((5),(state_56022[(4)])));

return statearr_56025;
})();
var inst_55998 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56022__$1 = state_56022;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56022__$1,(6),inst_55998);
} else {
if((state_val_56023 === (3))){
var inst_56020 = (state_56022[(2)]);
var state_56022__$1 = state_56022;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56022__$1,inst_56020);
} else {
if((state_val_56023 === (4))){
var inst_55992 = (state_56022[(2)]);
var state_56022__$1 = state_56022;
var statearr_56027_56043 = state_56022__$1;
(statearr_56027_56043[(2)] = inst_55992);

(statearr_56027_56043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56023 === (5))){
var _ = (function (){var statearr_56028 = state_56022;
(statearr_56028[(4)] = cljs.core.rest((state_56022[(4)])));

return statearr_56028;
})();
var state_56022__$1 = state_56022;
var ex56026 = (state_56022__$1[(2)]);
var statearr_56029_56044 = state_56022__$1;
(statearr_56029_56044[(5)] = ex56026);


if((ex56026 instanceof Error)){
var statearr_56030_56045 = state_56022__$1;
(statearr_56030_56045[(1)] = (4));

(statearr_56030_56045[(5)] = null);

} else {
throw ex56026;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56023 === (6))){
var inst_56000 = (state_56022[(2)]);
var inst_56001 = fluree.db.util.async.throw_err(inst_56000);
var inst_56002 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_56001);
var inst_56003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56004 = [inst_56001];
var inst_56005 = (new cljs.core.PersistentVector(null,1,(5),inst_56003,inst_56004,null));
var inst_56006 = cljs.core.count(inst_56005);
var inst_56007 = ((9) + inst_56006);
var inst_56008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56009 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56011 = [inst_56001];
var inst_56012 = (new cljs.core.PersistentVector(null,1,(5),inst_56010,inst_56011,null));
var inst_56013 = ["max",inst_56012,inst_56002];
var inst_56014 = cljs.core.PersistentHashMap.fromArrays(inst_56009,inst_56013);
var inst_56015 = [inst_56014,inst_56007];
var inst_56016 = (new cljs.core.PersistentVector(null,2,(5),inst_56008,inst_56015,null));
var inst_56017 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56016);
var _ = (function (){var statearr_56031 = state_56022;
(statearr_56031[(4)] = cljs.core.rest((state_56022[(4)])));

return statearr_56031;
})();
var state_56022__$1 = (function (){var statearr_56032 = state_56022;
(statearr_56032[(7)] = inst_56017);

return statearr_56032;
})();
var statearr_56033_56046 = state_56022__$1;
(statearr_56033_56046[(2)] = inst_56002);

(statearr_56033_56046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_56034 = [null,null,null,null,null,null,null,null];
(statearr_56034[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_56034[(1)] = (1));

return statearr_56034;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_56022){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56022);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56035){var ex__2736__auto__ = e56035;
var statearr_56036_56047 = state_56022;
(statearr_56036_56047[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56022[(4)]))){
var statearr_56037_56048 = state_56022;
(statearr_56037_56048[(1)] = cljs.core.first((state_56022[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56049 = state_56022;
state_56022 = G__56049;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_56022){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_56022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56038 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56038[(6)] = c__2755__auto__);

return statearr_56038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq55990){
var G__55991 = cljs.core.first(seq55990);
var seq55990__$1 = cljs.core.next(seq55990);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55991,seq55990__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56099 = arguments.length;
var i__4830__auto___56100 = (0);
while(true){
if((i__4830__auto___56100 < len__4829__auto___56099)){
args__4835__auto__.push((arguments[i__4830__auto___56100]));

var G__56101 = (i__4830__auto___56100 + (1));
i__4830__auto___56100 = G__56101;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56082){
var state_val_56083 = (state_56082[(1)]);
if((state_val_56083 === (1))){
var state_56082__$1 = state_56082;
var statearr_56084_56102 = state_56082__$1;
(statearr_56084_56102[(2)] = null);

(statearr_56084_56102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56083 === (2))){
var _ = (function (){var statearr_56085 = state_56082;
(statearr_56085[(4)] = cljs.core.cons((5),(state_56082[(4)])));

return statearr_56085;
})();
var inst_56058 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56082__$1 = state_56082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56082__$1,(6),inst_56058);
} else {
if((state_val_56083 === (3))){
var inst_56080 = (state_56082[(2)]);
var state_56082__$1 = state_56082;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56082__$1,inst_56080);
} else {
if((state_val_56083 === (4))){
var inst_56052 = (state_56082[(2)]);
var state_56082__$1 = state_56082;
var statearr_56087_56103 = state_56082__$1;
(statearr_56087_56103[(2)] = inst_56052);

(statearr_56087_56103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56083 === (5))){
var _ = (function (){var statearr_56088 = state_56082;
(statearr_56088[(4)] = cljs.core.rest((state_56082[(4)])));

return statearr_56088;
})();
var state_56082__$1 = state_56082;
var ex56086 = (state_56082__$1[(2)]);
var statearr_56089_56104 = state_56082__$1;
(statearr_56089_56104[(5)] = ex56086);


if((ex56086 instanceof Error)){
var statearr_56090_56105 = state_56082__$1;
(statearr_56090_56105[(1)] = (4));

(statearr_56090_56105[(5)] = null);

} else {
throw ex56086;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56083 === (6))){
var inst_56060 = (state_56082[(2)]);
var inst_56061 = fluree.db.util.async.throw_err(inst_56060);
var inst_56062 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_56061);
var inst_56063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56064 = [inst_56061];
var inst_56065 = (new cljs.core.PersistentVector(null,1,(5),inst_56063,inst_56064,null));
var inst_56066 = cljs.core.count(inst_56065);
var inst_56067 = ((9) + inst_56066);
var inst_56068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56069 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56071 = [inst_56061];
var inst_56072 = (new cljs.core.PersistentVector(null,1,(5),inst_56070,inst_56071,null));
var inst_56073 = ["min",inst_56072,inst_56062];
var inst_56074 = cljs.core.PersistentHashMap.fromArrays(inst_56069,inst_56073);
var inst_56075 = [inst_56074,inst_56067];
var inst_56076 = (new cljs.core.PersistentVector(null,2,(5),inst_56068,inst_56075,null));
var inst_56077 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56076);
var _ = (function (){var statearr_56091 = state_56082;
(statearr_56091[(4)] = cljs.core.rest((state_56082[(4)])));

return statearr_56091;
})();
var state_56082__$1 = (function (){var statearr_56092 = state_56082;
(statearr_56092[(7)] = inst_56077);

return statearr_56092;
})();
var statearr_56093_56106 = state_56082__$1;
(statearr_56093_56106[(2)] = inst_56062);

(statearr_56093_56106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_56094 = [null,null,null,null,null,null,null,null];
(statearr_56094[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_56094[(1)] = (1));

return statearr_56094;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_56082){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56082);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56095){var ex__2736__auto__ = e56095;
var statearr_56096_56107 = state_56082;
(statearr_56096_56107[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56082[(4)]))){
var statearr_56097_56108 = state_56082;
(statearr_56097_56108[(1)] = cljs.core.first((state_56082[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56109 = state_56082;
state_56082 = G__56109;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_56082){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_56082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56098 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56098[(6)] = c__2755__auto__);

return statearr_56098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq56050){
var G__56051 = cljs.core.first(seq56050);
var seq56050__$1 = cljs.core.next(seq56050);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56051,seq56050__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__56111 = arguments.length;
switch (G__56111) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56156){
var state_val_56157 = (state_56156[(1)]);
if((state_val_56157 === (7))){
var state_56156__$1 = state_56156;
var statearr_56158_56295 = state_56156__$1;
(statearr_56158_56295[(2)] = query_map);

(statearr_56158_56295[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56157 === (1))){
var state_56156__$1 = state_56156;
var statearr_56159_56296 = state_56156__$1;
(statearr_56159_56296[(2)] = null);

(statearr_56159_56296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56157 === (4))){
var inst_56112 = (state_56156[(2)]);
var state_56156__$1 = state_56156;
var statearr_56160_56297 = state_56156__$1;
(statearr_56160_56297[(2)] = inst_56112);

(statearr_56160_56297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56157 === (13))){
var inst_56134 = (state_56156[(7)]);
var inst_56138 = (state_56156[(2)]);
var inst_56139 = fluree.db.util.async.throw_err(inst_56138);
var inst_56140 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56139,(0),null);
var inst_56141 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56139,(1),null);
var inst_56142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56143 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56145 = [inst_56134];
var inst_56146 = (new cljs.core.PersistentVector(null,1,(5),inst_56144,inst_56145,null));
var inst_56147 = ["query",inst_56146,inst_56140];
var inst_56148 = cljs.core.PersistentHashMap.fromArrays(inst_56143,inst_56147);
var inst_56149 = [inst_56148,inst_56141];
var inst_56150 = (new cljs.core.PersistentVector(null,2,(5),inst_56142,inst_56149,null));
var inst_56151 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56150);
var _ = (function (){var statearr_56161 = state_56156;
(statearr_56161[(4)] = cljs.core.rest((state_56156[(4)])));

return statearr_56161;
})();
var state_56156__$1 = (function (){var statearr_56162 = state_56156;
(statearr_56162[(8)] = inst_56151);

return statearr_56162;
})();
var statearr_56163_56298 = state_56156__$1;
(statearr_56163_56298[(2)] = inst_56140);

(statearr_56163_56298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56157 === (6))){
var state_56156__$1 = state_56156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56156__$1,(9),query_map);
} else {
if((state_val_56157 === (3))){
var inst_56154 = (state_56156[(2)]);
var state_56156__$1 = state_56156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56156__$1,inst_56154);
} else {
if((state_val_56157 === (12))){
var inst_56134 = (state_56156[(7)]);
var inst_56134__$1 = (state_56156[(2)]);
var inst_56135 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56136 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56135,inst_56134__$1);
var state_56156__$1 = (function (){var statearr_56164 = state_56156;
(statearr_56164[(7)] = inst_56134__$1);

return statearr_56164;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56156__$1,(13),inst_56136);
} else {
if((state_val_56157 === (2))){
var _ = (function (){var statearr_56165 = state_56156;
(statearr_56165[(4)] = cljs.core.cons((5),(state_56156[(4)])));

return statearr_56165;
})();
var inst_56121 = fluree.db.util.async.channel_QMARK_(query_map);
var state_56156__$1 = state_56156;
if(inst_56121){
var statearr_56166_56299 = state_56156__$1;
(statearr_56166_56299[(1)] = (6));

} else {
var statearr_56167_56300 = state_56156__$1;
(statearr_56167_56300[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56157 === (11))){
var inst_56128 = (state_56156[(9)]);
var state_56156__$1 = state_56156;
var statearr_56169_56301 = state_56156__$1;
(statearr_56169_56301[(2)] = inst_56128);

(statearr_56169_56301[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56157 === (9))){
var inst_56124 = (state_56156[(2)]);
var inst_56125 = fluree.db.util.async.throw_err(inst_56124);
var state_56156__$1 = state_56156;
var statearr_56170_56302 = state_56156__$1;
(statearr_56170_56302[(2)] = inst_56125);

(statearr_56170_56302[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56157 === (5))){
var _ = (function (){var statearr_56171 = state_56156;
(statearr_56171[(4)] = cljs.core.rest((state_56156[(4)])));

return statearr_56171;
})();
var state_56156__$1 = state_56156;
var ex56168 = (state_56156__$1[(2)]);
var statearr_56172_56303 = state_56156__$1;
(statearr_56172_56303[(5)] = ex56168);


if((ex56168 instanceof Error)){
var statearr_56173_56304 = state_56156__$1;
(statearr_56173_56304[(1)] = (4));

(statearr_56173_56304[(5)] = null);

} else {
throw ex56168;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56157 === (10))){
var inst_56128 = (state_56156[(9)]);
var inst_56131 = fluree.db.util.json.parse(inst_56128);
var state_56156__$1 = state_56156;
var statearr_56174_56305 = state_56156__$1;
(statearr_56174_56305[(2)] = inst_56131);

(statearr_56174_56305[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56157 === (8))){
var inst_56128 = (state_56156[(9)]);
var inst_56128__$1 = (state_56156[(2)]);
var inst_56129 = typeof inst_56128__$1 === 'string';
var state_56156__$1 = (function (){var statearr_56175 = state_56156;
(statearr_56175[(9)] = inst_56128__$1);

return statearr_56175;
})();
if(cljs.core.truth_(inst_56129)){
var statearr_56176_56306 = state_56156__$1;
(statearr_56176_56306[(1)] = (10));

} else {
var statearr_56177_56307 = state_56156__$1;
(statearr_56177_56307[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_56178 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56178[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_56178[(1)] = (1));

return statearr_56178;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_56156){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56156);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56179){var ex__2736__auto__ = e56179;
var statearr_56180_56308 = state_56156;
(statearr_56180_56308[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56156[(4)]))){
var statearr_56181_56309 = state_56156;
(statearr_56181_56309[(1)] = cljs.core.first((state_56156[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56310 = state_56156;
state_56156 = G__56310;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_56156){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_56156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56182 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56182[(6)] = c__2755__auto__);

return statearr_56182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56253){
var state_val_56254 = (state_56253[(1)]);
if((state_val_56254 === (7))){
var state_56253__$1 = state_56253;
var statearr_56255_56311 = state_56253__$1;
(statearr_56255_56311[(2)] = select);

(statearr_56255_56311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (20))){
var inst_56223 = (state_56253[(2)]);
var inst_56224 = fluree.db.util.async.channel_QMARK_(limit);
var state_56253__$1 = (function (){var statearr_56256 = state_56253;
(statearr_56256[(7)] = inst_56223);

return statearr_56256;
})();
if(inst_56224){
var statearr_56257_56312 = state_56253__$1;
(statearr_56257_56312[(1)] = (22));

} else {
var statearr_56258_56313 = state_56253__$1;
(statearr_56258_56313[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (1))){
var state_56253__$1 = state_56253;
var statearr_56259_56314 = state_56253__$1;
(statearr_56259_56314[(2)] = null);

(statearr_56259_56314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (24))){
var inst_56223 = (state_56253[(7)]);
var inst_56199 = (state_56253[(8)]);
var inst_56215 = (state_56253[(9)]);
var inst_56207 = (state_56253[(10)]);
var inst_56231 = (state_56253[(2)]);
var inst_56232 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56233 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_56232,inst_56199,inst_56207,inst_56215,inst_56223,inst_56231);
var state_56253__$1 = state_56253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56253__$1,(26),inst_56233);
} else {
if((state_val_56254 === (4))){
var inst_56183 = (state_56253[(2)]);
var state_56253__$1 = state_56253;
var statearr_56260_56315 = state_56253__$1;
(statearr_56260_56315[(2)] = inst_56183);

(statearr_56260_56315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (15))){
var state_56253__$1 = state_56253;
var statearr_56261_56316 = state_56253__$1;
(statearr_56261_56316[(2)] = where);

(statearr_56261_56316[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (21))){
var inst_56219 = (state_56253[(2)]);
var inst_56220 = fluree.db.util.async.throw_err(inst_56219);
var state_56253__$1 = state_56253;
var statearr_56262_56317 = state_56253__$1;
(statearr_56262_56317[(2)] = inst_56220);

(statearr_56262_56317[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (13))){
var inst_56203 = (state_56253[(2)]);
var inst_56204 = fluree.db.util.async.throw_err(inst_56203);
var state_56253__$1 = state_56253;
var statearr_56263_56318 = state_56253__$1;
(statearr_56263_56318[(2)] = inst_56204);

(statearr_56263_56318[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (22))){
var state_56253__$1 = state_56253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56253__$1,(25),limit);
} else {
if((state_val_56254 === (6))){
var state_56253__$1 = state_56253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56253__$1,(9),select);
} else {
if((state_val_56254 === (25))){
var inst_56227 = (state_56253[(2)]);
var inst_56228 = fluree.db.util.async.throw_err(inst_56227);
var state_56253__$1 = state_56253;
var statearr_56264_56319 = state_56253__$1;
(statearr_56264_56319[(2)] = inst_56228);

(statearr_56264_56319[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (17))){
var inst_56211 = (state_56253[(2)]);
var inst_56212 = fluree.db.util.async.throw_err(inst_56211);
var state_56253__$1 = state_56253;
var statearr_56265_56320 = state_56253__$1;
(statearr_56265_56320[(2)] = inst_56212);

(statearr_56265_56320[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (3))){
var inst_56251 = (state_56253[(2)]);
var state_56253__$1 = state_56253;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56253__$1,inst_56251);
} else {
if((state_val_56254 === (12))){
var inst_56207 = (state_56253[(2)]);
var inst_56208 = fluree.db.util.async.channel_QMARK_(where);
var state_56253__$1 = (function (){var statearr_56266 = state_56253;
(statearr_56266[(10)] = inst_56207);

return statearr_56266;
})();
if(inst_56208){
var statearr_56267_56321 = state_56253__$1;
(statearr_56267_56321[(1)] = (14));

} else {
var statearr_56268_56322 = state_56253__$1;
(statearr_56268_56322[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (2))){
var _ = (function (){var statearr_56269 = state_56253;
(statearr_56269[(4)] = cljs.core.cons((5),(state_56253[(4)])));

return statearr_56269;
})();
var inst_56192 = fluree.db.util.async.channel_QMARK_(select);
var state_56253__$1 = state_56253;
if(inst_56192){
var statearr_56270_56323 = state_56253__$1;
(statearr_56270_56323[(1)] = (6));

} else {
var statearr_56271_56324 = state_56253__$1;
(statearr_56271_56324[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (23))){
var state_56253__$1 = state_56253;
var statearr_56272_56325 = state_56253__$1;
(statearr_56272_56325[(2)] = limit);

(statearr_56272_56325[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (19))){
var state_56253__$1 = state_56253;
var statearr_56273_56326 = state_56253__$1;
(statearr_56273_56326[(2)] = block);

(statearr_56273_56326[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (11))){
var state_56253__$1 = state_56253;
var statearr_56275_56327 = state_56253__$1;
(statearr_56275_56327[(2)] = from);

(statearr_56275_56327[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (9))){
var inst_56195 = (state_56253[(2)]);
var inst_56196 = fluree.db.util.async.throw_err(inst_56195);
var state_56253__$1 = state_56253;
var statearr_56276_56328 = state_56253__$1;
(statearr_56276_56328[(2)] = inst_56196);

(statearr_56276_56328[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (5))){
var _ = (function (){var statearr_56277 = state_56253;
(statearr_56277[(4)] = cljs.core.rest((state_56253[(4)])));

return statearr_56277;
})();
var state_56253__$1 = state_56253;
var ex56274 = (state_56253__$1[(2)]);
var statearr_56278_56329 = state_56253__$1;
(statearr_56278_56329[(5)] = ex56274);


if((ex56274 instanceof Error)){
var statearr_56279_56330 = state_56253__$1;
(statearr_56279_56330[(1)] = (4));

(statearr_56279_56330[(5)] = null);

} else {
throw ex56274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (14))){
var state_56253__$1 = state_56253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56253__$1,(17),where);
} else {
if((state_val_56254 === (26))){
var inst_56223 = (state_56253[(7)]);
var inst_56199 = (state_56253[(8)]);
var inst_56215 = (state_56253[(9)]);
var inst_56207 = (state_56253[(10)]);
var inst_56235 = (state_56253[(2)]);
var inst_56236 = fluree.db.util.async.throw_err(inst_56235);
var inst_56237 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56236,(0),null);
var inst_56238 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56236,(1),null);
var inst_56239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56240 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56242 = [inst_56199,inst_56207,inst_56215,inst_56223];
var inst_56243 = (new cljs.core.PersistentVector(null,4,(5),inst_56241,inst_56242,null));
var inst_56244 = ["query",inst_56243,inst_56237];
var inst_56245 = cljs.core.PersistentHashMap.fromArrays(inst_56240,inst_56244);
var inst_56246 = [inst_56245,inst_56238];
var inst_56247 = (new cljs.core.PersistentVector(null,2,(5),inst_56239,inst_56246,null));
var inst_56248 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56247);
var _ = (function (){var statearr_56280 = state_56253;
(statearr_56280[(4)] = cljs.core.rest((state_56253[(4)])));

return statearr_56280;
})();
var state_56253__$1 = (function (){var statearr_56281 = state_56253;
(statearr_56281[(11)] = inst_56248);

return statearr_56281;
})();
var statearr_56282_56331 = state_56253__$1;
(statearr_56282_56331[(2)] = inst_56237);

(statearr_56282_56331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (16))){
var inst_56215 = (state_56253[(2)]);
var inst_56216 = fluree.db.util.async.channel_QMARK_(block);
var state_56253__$1 = (function (){var statearr_56283 = state_56253;
(statearr_56283[(9)] = inst_56215);

return statearr_56283;
})();
if(inst_56216){
var statearr_56284_56332 = state_56253__$1;
(statearr_56284_56332[(1)] = (18));

} else {
var statearr_56285_56333 = state_56253__$1;
(statearr_56285_56333[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (10))){
var state_56253__$1 = state_56253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56253__$1,(13),from);
} else {
if((state_val_56254 === (18))){
var state_56253__$1 = state_56253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56253__$1,(21),block);
} else {
if((state_val_56254 === (8))){
var inst_56199 = (state_56253[(2)]);
var inst_56200 = fluree.db.util.async.channel_QMARK_(from);
var state_56253__$1 = (function (){var statearr_56286 = state_56253;
(statearr_56286[(8)] = inst_56199);

return statearr_56286;
})();
if(inst_56200){
var statearr_56287_56334 = state_56253__$1;
(statearr_56287_56334[(1)] = (10));

} else {
var statearr_56288_56335 = state_56253__$1;
(statearr_56288_56335[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_56289 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56289[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_56289[(1)] = (1));

return statearr_56289;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_56253){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56253);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56290){var ex__2736__auto__ = e56290;
var statearr_56291_56336 = state_56253;
(statearr_56291_56336[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56253[(4)]))){
var statearr_56292_56337 = state_56253;
(statearr_56292_56337[(1)] = cljs.core.first((state_56253[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56338 = state_56253;
state_56253 = G__56338;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_56253){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_56253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56293 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56293[(6)] = c__2755__auto__);

return statearr_56293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56394){
var state_val_56395 = (state_56394[(1)]);
if((state_val_56395 === (7))){
var state_56394__$1 = state_56394;
var statearr_56396_56427 = state_56394__$1;
(statearr_56396_56427[(2)] = startSubject);

(statearr_56396_56427[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56395 === (1))){
var state_56394__$1 = state_56394;
var statearr_56397_56428 = state_56394__$1;
(statearr_56397_56428[(2)] = null);

(statearr_56397_56428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56395 === (4))){
var inst_56339 = (state_56394[(2)]);
var state_56394__$1 = state_56394;
var statearr_56398_56429 = state_56394__$1;
(statearr_56398_56429[(2)] = inst_56339);

(statearr_56398_56429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56395 === (15))){
var inst_56371 = (state_56394[(2)]);
var inst_56372 = fluree.db.util.async.throw_err(inst_56371);
var inst_56373 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56372,(0),null);
var inst_56374 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56372,(1),null);
var inst_56375 = cljs.core.empty_QMARK_(inst_56373);
var state_56394__$1 = (function (){var statearr_56399 = state_56394;
(statearr_56399[(7)] = inst_56374);

return statearr_56399;
})();
if(inst_56375){
var statearr_56400_56430 = state_56394__$1;
(statearr_56400_56430[(1)] = (16));

} else {
var statearr_56401_56431 = state_56394__$1;
(statearr_56401_56431[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56395 === (13))){
var inst_56367 = (state_56394[(8)]);
var inst_56359 = (state_56394[(9)]);
var inst_56355 = (state_56394[(10)]);
var inst_56367__$1 = (state_56394[(2)]);
var inst_56368 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56369 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_56368,inst_56355,inst_56359,inst_56367__$1);
var state_56394__$1 = (function (){var statearr_56402 = state_56394;
(statearr_56402[(8)] = inst_56367__$1);

return statearr_56402;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56394__$1,(15),inst_56369);
} else {
if((state_val_56395 === (6))){
var state_56394__$1 = state_56394;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56394__$1,(9),startSubject);
} else {
if((state_val_56395 === (17))){
var state_56394__$1 = state_56394;
var statearr_56403_56432 = state_56394__$1;
(statearr_56403_56432[(2)] = true);

(statearr_56403_56432[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56395 === (3))){
var inst_56392 = (state_56394[(2)]);
var state_56394__$1 = state_56394;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56394__$1,inst_56392);
} else {
if((state_val_56395 === (12))){
var state_56394__$1 = state_56394;
var statearr_56404_56433 = state_56394__$1;
(statearr_56404_56433[(2)] = endSubject);

(statearr_56404_56433[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56395 === (2))){
var _ = (function (){var statearr_56405 = state_56394;
(statearr_56405[(4)] = cljs.core.cons((5),(state_56394[(4)])));

return statearr_56405;
})();
var inst_56348 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_56394__$1 = state_56394;
if(inst_56348){
var statearr_56406_56434 = state_56394__$1;
(statearr_56406_56434[(1)] = (6));

} else {
var statearr_56407_56435 = state_56394__$1;
(statearr_56407_56435[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56395 === (11))){
var state_56394__$1 = state_56394;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56394__$1,(14),endSubject);
} else {
if((state_val_56395 === (9))){
var inst_56351 = (state_56394[(2)]);
var inst_56352 = fluree.db.util.async.throw_err(inst_56351);
var state_56394__$1 = state_56394;
var statearr_56409_56436 = state_56394__$1;
(statearr_56409_56436[(2)] = inst_56352);

(statearr_56409_56436[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56395 === (5))){
var _ = (function (){var statearr_56410 = state_56394;
(statearr_56410[(4)] = cljs.core.rest((state_56394[(4)])));

return statearr_56410;
})();
var state_56394__$1 = state_56394;
var ex56408 = (state_56394__$1[(2)]);
var statearr_56411_56437 = state_56394__$1;
(statearr_56411_56437[(5)] = ex56408);


if((ex56408 instanceof Error)){
var statearr_56412_56438 = state_56394__$1;
(statearr_56412_56438[(1)] = (4));

(statearr_56412_56438[(5)] = null);

} else {
throw ex56408;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56395 === (14))){
var inst_56363 = (state_56394[(2)]);
var inst_56364 = fluree.db.util.async.throw_err(inst_56363);
var state_56394__$1 = state_56394;
var statearr_56413_56439 = state_56394__$1;
(statearr_56413_56439[(2)] = inst_56364);

(statearr_56413_56439[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56395 === (16))){
var state_56394__$1 = state_56394;
var statearr_56414_56440 = state_56394__$1;
(statearr_56414_56440[(2)] = false);

(statearr_56414_56440[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56395 === (10))){
var inst_56358 = (state_56394[(2)]);
var inst_56359 = fluree.db.util.async.throw_err(inst_56358);
var inst_56360 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_56394__$1 = (function (){var statearr_56415 = state_56394;
(statearr_56415[(9)] = inst_56359);

return statearr_56415;
})();
if(inst_56360){
var statearr_56416_56441 = state_56394__$1;
(statearr_56416_56441[(1)] = (11));

} else {
var statearr_56417_56442 = state_56394__$1;
(statearr_56417_56442[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56395 === (18))){
var inst_56367 = (state_56394[(8)]);
var inst_56359 = (state_56394[(9)]);
var inst_56374 = (state_56394[(7)]);
var inst_56355 = (state_56394[(10)]);
var inst_56379 = (state_56394[(2)]);
var inst_56380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56381 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56383 = [inst_56355,inst_56359,inst_56367];
var inst_56384 = (new cljs.core.PersistentVector(null,3,(5),inst_56382,inst_56383,null));
var inst_56385 = ["relationship?",inst_56384,inst_56379];
var inst_56386 = cljs.core.PersistentHashMap.fromArrays(inst_56381,inst_56385);
var inst_56387 = [inst_56386,inst_56374];
var inst_56388 = (new cljs.core.PersistentVector(null,2,(5),inst_56380,inst_56387,null));
var inst_56389 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56388);
var _ = (function (){var statearr_56418 = state_56394;
(statearr_56418[(4)] = cljs.core.rest((state_56394[(4)])));

return statearr_56418;
})();
var state_56394__$1 = (function (){var statearr_56419 = state_56394;
(statearr_56419[(11)] = inst_56389);

return statearr_56419;
})();
var statearr_56420_56443 = state_56394__$1;
(statearr_56420_56443[(2)] = inst_56379);

(statearr_56420_56443[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56395 === (8))){
var inst_56355 = (state_56394[(2)]);
var inst_56356 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_56394__$1 = (function (){var statearr_56421 = state_56394;
(statearr_56421[(10)] = inst_56355);

return statearr_56421;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56394__$1,(10),inst_56356);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_56422 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56422[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto__);

(statearr_56422[(1)] = (1));

return statearr_56422;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto____1 = (function (state_56394){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56394);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56423){var ex__2736__auto__ = e56423;
var statearr_56424_56444 = state_56394;
(statearr_56424_56444[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56394[(4)]))){
var statearr_56425_56445 = state_56394;
(statearr_56425_56445[(1)] = cljs.core.first((state_56394[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56446 = state_56394;
state_56394 = G__56446;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto__ = function(state_56394){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto____1.call(this,state_56394);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56426 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56426[(6)] = c__2755__auto__);

return statearr_56426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56483){
var state_val_56484 = (state_56483[(1)]);
if((state_val_56484 === (7))){
var state_56483__$1 = state_56483;
var statearr_56485_56505 = state_56483__$1;
(statearr_56485_56505[(2)] = pred_name);

(statearr_56485_56505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56484 === (1))){
var state_56483__$1 = state_56483;
var statearr_56486_56506 = state_56483__$1;
(statearr_56486_56506[(2)] = null);

(statearr_56486_56506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56484 === (4))){
var inst_56447 = (state_56483[(2)]);
var state_56483__$1 = state_56483;
var statearr_56487_56507 = state_56483__$1;
(statearr_56487_56507[(2)] = inst_56447);

(statearr_56487_56507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56484 === (6))){
var state_56483__$1 = state_56483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56483__$1,(9),pred_name);
} else {
if((state_val_56484 === (3))){
var inst_56481 = (state_56483[(2)]);
var state_56483__$1 = state_56483;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56483__$1,inst_56481);
} else {
if((state_val_56484 === (2))){
var _ = (function (){var statearr_56489 = state_56483;
(statearr_56489[(4)] = cljs.core.cons((5),(state_56483[(4)])));

return statearr_56489;
})();
var inst_56456 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_56483__$1 = state_56483;
if(inst_56456){
var statearr_56490_56508 = state_56483__$1;
(statearr_56490_56508[(1)] = (6));

} else {
var statearr_56491_56509 = state_56483__$1;
(statearr_56491_56509[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56484 === (9))){
var inst_56459 = (state_56483[(2)]);
var inst_56460 = fluree.db.util.async.throw_err(inst_56459);
var state_56483__$1 = state_56483;
var statearr_56492_56510 = state_56483__$1;
(statearr_56492_56510[(2)] = inst_56460);

(statearr_56492_56510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56484 === (5))){
var _ = (function (){var statearr_56493 = state_56483;
(statearr_56493[(4)] = cljs.core.rest((state_56483[(4)])));

return statearr_56493;
})();
var state_56483__$1 = state_56483;
var ex56488 = (state_56483__$1[(2)]);
var statearr_56494_56511 = state_56483__$1;
(statearr_56494_56511[(5)] = ex56488);


if((ex56488 instanceof Error)){
var statearr_56495_56512 = state_56483__$1;
(statearr_56495_56512[(1)] = (4));

(statearr_56495_56512[(5)] = null);

} else {
throw ex56488;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56484 === (10))){
var inst_56463 = (state_56483[(7)]);
var inst_56467 = (state_56483[(2)]);
var inst_56468 = fluree.db.util.async.throw_err(inst_56467);
var inst_56469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56468,(0),null);
var inst_56470 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56468,(1),null);
var inst_56471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56472 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56473 = ["max-pred-val",inst_56463,inst_56469];
var inst_56474 = cljs.core.PersistentHashMap.fromArrays(inst_56472,inst_56473);
var inst_56475 = (inst_56470 + (10));
var inst_56476 = [inst_56474,inst_56475];
var inst_56477 = (new cljs.core.PersistentVector(null,2,(5),inst_56471,inst_56476,null));
var inst_56478 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56477);
var _ = (function (){var statearr_56496 = state_56483;
(statearr_56496[(4)] = cljs.core.rest((state_56483[(4)])));

return statearr_56496;
})();
var state_56483__$1 = (function (){var statearr_56497 = state_56483;
(statearr_56497[(8)] = inst_56478);

return statearr_56497;
})();
var statearr_56498_56513 = state_56483__$1;
(statearr_56498_56513[(2)] = inst_56469);

(statearr_56498_56513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56484 === (8))){
var inst_56463 = (state_56483[(7)]);
var inst_56463__$1 = (state_56483[(2)]);
var inst_56464 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56465 = fluree.db.dbfunctions.internal.max_pred_val(inst_56464,inst_56463__$1,null);
var state_56483__$1 = (function (){var statearr_56499 = state_56483;
(statearr_56499[(7)] = inst_56463__$1);

return statearr_56499;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56483__$1,(10),inst_56465);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto____0 = (function (){
var statearr_56500 = [null,null,null,null,null,null,null,null,null];
(statearr_56500[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto__);

(statearr_56500[(1)] = (1));

return statearr_56500;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto____1 = (function (state_56483){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56483);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56501){var ex__2736__auto__ = e56501;
var statearr_56502_56514 = state_56483;
(statearr_56502_56514[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56483[(4)]))){
var statearr_56503_56515 = state_56483;
(statearr_56503_56515[(1)] = cljs.core.first((state_56483[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56516 = state_56483;
state_56483 = G__56516;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto__ = function(state_56483){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto____1.call(this,state_56483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56504 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56504[(6)] = c__2755__auto__);

return statearr_56504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56543){
var state_val_56544 = (state_56543[(1)]);
if((state_val_56544 === (7))){
var state_56543__$1 = state_56543;
var statearr_56545_56564 = state_56543__$1;
(statearr_56545_56564[(2)] = n);

(statearr_56545_56564[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56544 === (1))){
var state_56543__$1 = state_56543;
var statearr_56546_56565 = state_56543__$1;
(statearr_56546_56565[(2)] = null);

(statearr_56546_56565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56544 === (4))){
var inst_56517 = (state_56543[(2)]);
var state_56543__$1 = state_56543;
var statearr_56547_56566 = state_56543__$1;
(statearr_56547_56566[(2)] = inst_56517);

(statearr_56547_56566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56544 === (6))){
var state_56543__$1 = state_56543;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56543__$1,(9),n);
} else {
if((state_val_56544 === (3))){
var inst_56541 = (state_56543[(2)]);
var state_56543__$1 = state_56543;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56543__$1,inst_56541);
} else {
if((state_val_56544 === (2))){
var _ = (function (){var statearr_56549 = state_56543;
(statearr_56549[(4)] = cljs.core.cons((5),(state_56543[(4)])));

return statearr_56549;
})();
var inst_56523 = fluree.db.util.async.channel_QMARK_(n);
var state_56543__$1 = state_56543;
if(inst_56523){
var statearr_56550_56567 = state_56543__$1;
(statearr_56550_56567[(1)] = (6));

} else {
var statearr_56551_56568 = state_56543__$1;
(statearr_56551_56568[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56544 === (9))){
var inst_56526 = (state_56543[(2)]);
var inst_56527 = fluree.db.util.async.throw_err(inst_56526);
var state_56543__$1 = state_56543;
var statearr_56552_56569 = state_56543__$1;
(statearr_56552_56569[(2)] = inst_56527);

(statearr_56552_56569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56544 === (5))){
var _ = (function (){var statearr_56553 = state_56543;
(statearr_56553[(4)] = cljs.core.rest((state_56543[(4)])));

return statearr_56553;
})();
var state_56543__$1 = state_56543;
var ex56548 = (state_56543__$1[(2)]);
var statearr_56554_56570 = state_56543__$1;
(statearr_56554_56570[(5)] = ex56548);


if((ex56548 instanceof Error)){
var statearr_56555_56571 = state_56543__$1;
(statearr_56555_56571[(1)] = (4));

(statearr_56555_56571[(5)] = null);

} else {
throw ex56548;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56544 === (8))){
var inst_56530 = (state_56543[(2)]);
var inst_56531 = fluree.db.dbfunctions.internal.inc(inst_56530);
var inst_56532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56533 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56534 = ["inc",inst_56530,inst_56531];
var inst_56535 = cljs.core.PersistentHashMap.fromArrays(inst_56533,inst_56534);
var inst_56536 = [inst_56535,(10)];
var inst_56537 = (new cljs.core.PersistentVector(null,2,(5),inst_56532,inst_56536,null));
var inst_56538 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56537);
var _ = (function (){var statearr_56556 = state_56543;
(statearr_56556[(4)] = cljs.core.rest((state_56543[(4)])));

return statearr_56556;
})();
var state_56543__$1 = (function (){var statearr_56557 = state_56543;
(statearr_56557[(7)] = inst_56538);

return statearr_56557;
})();
var statearr_56558_56572 = state_56543__$1;
(statearr_56558_56572[(2)] = inst_56531);

(statearr_56558_56572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto____0 = (function (){
var statearr_56559 = [null,null,null,null,null,null,null,null];
(statearr_56559[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto__);

(statearr_56559[(1)] = (1));

return statearr_56559;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto____1 = (function (state_56543){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56543);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56560){var ex__2736__auto__ = e56560;
var statearr_56561_56573 = state_56543;
(statearr_56561_56573[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56543[(4)]))){
var statearr_56562_56574 = state_56543;
(statearr_56562_56574[(1)] = cljs.core.first((state_56543[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56575 = state_56543;
state_56543 = G__56575;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto__ = function(state_56543){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto____1.call(this,state_56543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56563 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56563[(6)] = c__2755__auto__);

return statearr_56563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56602){
var state_val_56603 = (state_56602[(1)]);
if((state_val_56603 === (7))){
var state_56602__$1 = state_56602;
var statearr_56604_56623 = state_56602__$1;
(statearr_56604_56623[(2)] = n);

(statearr_56604_56623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56603 === (1))){
var state_56602__$1 = state_56602;
var statearr_56605_56624 = state_56602__$1;
(statearr_56605_56624[(2)] = null);

(statearr_56605_56624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56603 === (4))){
var inst_56576 = (state_56602[(2)]);
var state_56602__$1 = state_56602;
var statearr_56606_56625 = state_56602__$1;
(statearr_56606_56625[(2)] = inst_56576);

(statearr_56606_56625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56603 === (6))){
var state_56602__$1 = state_56602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56602__$1,(9),n);
} else {
if((state_val_56603 === (3))){
var inst_56600 = (state_56602[(2)]);
var state_56602__$1 = state_56602;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56602__$1,inst_56600);
} else {
if((state_val_56603 === (2))){
var _ = (function (){var statearr_56608 = state_56602;
(statearr_56608[(4)] = cljs.core.cons((5),(state_56602[(4)])));

return statearr_56608;
})();
var inst_56582 = fluree.db.util.async.channel_QMARK_(n);
var state_56602__$1 = state_56602;
if(inst_56582){
var statearr_56609_56626 = state_56602__$1;
(statearr_56609_56626[(1)] = (6));

} else {
var statearr_56610_56627 = state_56602__$1;
(statearr_56610_56627[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56603 === (9))){
var inst_56585 = (state_56602[(2)]);
var inst_56586 = fluree.db.util.async.throw_err(inst_56585);
var state_56602__$1 = state_56602;
var statearr_56611_56628 = state_56602__$1;
(statearr_56611_56628[(2)] = inst_56586);

(statearr_56611_56628[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56603 === (5))){
var _ = (function (){var statearr_56612 = state_56602;
(statearr_56612[(4)] = cljs.core.rest((state_56602[(4)])));

return statearr_56612;
})();
var state_56602__$1 = state_56602;
var ex56607 = (state_56602__$1[(2)]);
var statearr_56613_56629 = state_56602__$1;
(statearr_56613_56629[(5)] = ex56607);


if((ex56607 instanceof Error)){
var statearr_56614_56630 = state_56602__$1;
(statearr_56614_56630[(1)] = (4));

(statearr_56614_56630[(5)] = null);

} else {
throw ex56607;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56603 === (8))){
var inst_56589 = (state_56602[(2)]);
var inst_56590 = fluree.db.dbfunctions.internal.dec(inst_56589);
var inst_56591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56592 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56593 = ["dec",inst_56589,inst_56590];
var inst_56594 = cljs.core.PersistentHashMap.fromArrays(inst_56592,inst_56593);
var inst_56595 = [inst_56594,(10)];
var inst_56596 = (new cljs.core.PersistentVector(null,2,(5),inst_56591,inst_56595,null));
var inst_56597 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56596);
var _ = (function (){var statearr_56615 = state_56602;
(statearr_56615[(4)] = cljs.core.rest((state_56602[(4)])));

return statearr_56615;
})();
var state_56602__$1 = (function (){var statearr_56616 = state_56602;
(statearr_56616[(7)] = inst_56597);

return statearr_56616;
})();
var statearr_56617_56631 = state_56602__$1;
(statearr_56617_56631[(2)] = inst_56590);

(statearr_56617_56631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto____0 = (function (){
var statearr_56618 = [null,null,null,null,null,null,null,null];
(statearr_56618[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto__);

(statearr_56618[(1)] = (1));

return statearr_56618;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto____1 = (function (state_56602){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56602);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56619){var ex__2736__auto__ = e56619;
var statearr_56620_56632 = state_56602;
(statearr_56620_56632[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56602[(4)]))){
var statearr_56621_56633 = state_56602;
(statearr_56621_56633[(1)] = cljs.core.first((state_56602[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56634 = state_56602;
state_56602 = G__56634;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto__ = function(state_56602){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto____1.call(this,state_56602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56622 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56622[(6)] = c__2755__auto__);

return statearr_56622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56684 = arguments.length;
var i__4830__auto___56685 = (0);
while(true){
if((i__4830__auto___56685 < len__4829__auto___56684)){
args__4835__auto__.push((arguments[i__4830__auto___56685]));

var G__56686 = (i__4830__auto___56685 + (1));
i__4830__auto___56685 = G__56686;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56667){
var state_val_56668 = (state_56667[(1)]);
if((state_val_56668 === (1))){
var state_56667__$1 = state_56667;
var statearr_56669_56687 = state_56667__$1;
(statearr_56669_56687[(2)] = null);

(statearr_56669_56687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56668 === (2))){
var _ = (function (){var statearr_56670 = state_56667;
(statearr_56670[(4)] = cljs.core.cons((5),(state_56667[(4)])));

return statearr_56670;
})();
var inst_56643 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56667__$1 = state_56667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56667__$1,(6),inst_56643);
} else {
if((state_val_56668 === (3))){
var inst_56665 = (state_56667[(2)]);
var state_56667__$1 = state_56667;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56667__$1,inst_56665);
} else {
if((state_val_56668 === (4))){
var inst_56637 = (state_56667[(2)]);
var state_56667__$1 = state_56667;
var statearr_56672_56688 = state_56667__$1;
(statearr_56672_56688[(2)] = inst_56637);

(statearr_56672_56688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56668 === (5))){
var _ = (function (){var statearr_56673 = state_56667;
(statearr_56673[(4)] = cljs.core.rest((state_56667[(4)])));

return statearr_56673;
})();
var state_56667__$1 = state_56667;
var ex56671 = (state_56667__$1[(2)]);
var statearr_56674_56689 = state_56667__$1;
(statearr_56674_56689[(5)] = ex56671);


if((ex56671 instanceof Error)){
var statearr_56675_56690 = state_56667__$1;
(statearr_56675_56690[(1)] = (4));

(statearr_56675_56690[(5)] = null);

} else {
throw ex56671;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56668 === (6))){
var inst_56645 = (state_56667[(2)]);
var inst_56646 = fluree.db.util.async.throw_err(inst_56645);
var inst_56647 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_56646);
var inst_56648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56649 = [inst_56646];
var inst_56650 = (new cljs.core.PersistentVector(null,1,(5),inst_56648,inst_56649,null));
var inst_56651 = cljs.core.count(inst_56650);
var inst_56652 = ((9) + inst_56651);
var inst_56653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56654 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56656 = [inst_56646];
var inst_56657 = (new cljs.core.PersistentVector(null,1,(5),inst_56655,inst_56656,null));
var inst_56658 = ["+",inst_56657,inst_56647];
var inst_56659 = cljs.core.PersistentHashMap.fromArrays(inst_56654,inst_56658);
var inst_56660 = [inst_56659,inst_56652];
var inst_56661 = (new cljs.core.PersistentVector(null,2,(5),inst_56653,inst_56660,null));
var inst_56662 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56661);
var _ = (function (){var statearr_56676 = state_56667;
(statearr_56676[(4)] = cljs.core.rest((state_56667[(4)])));

return statearr_56676;
})();
var state_56667__$1 = (function (){var statearr_56677 = state_56667;
(statearr_56677[(7)] = inst_56662);

return statearr_56677;
})();
var statearr_56678_56691 = state_56667__$1;
(statearr_56678_56691[(2)] = inst_56647);

(statearr_56678_56691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_56679 = [null,null,null,null,null,null,null,null];
(statearr_56679[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_56679[(1)] = (1));

return statearr_56679;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_56667){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56667);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56680){var ex__2736__auto__ = e56680;
var statearr_56681_56692 = state_56667;
(statearr_56681_56692[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56667[(4)]))){
var statearr_56682_56693 = state_56667;
(statearr_56682_56693[(1)] = cljs.core.first((state_56667[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56694 = state_56667;
state_56667 = G__56694;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_56667){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_56667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56683 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56683[(6)] = c__2755__auto__);

return statearr_56683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56635){
var G__56636 = cljs.core.first(seq56635);
var seq56635__$1 = cljs.core.next(seq56635);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56636,seq56635__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56744 = arguments.length;
var i__4830__auto___56745 = (0);
while(true){
if((i__4830__auto___56745 < len__4829__auto___56744)){
args__4835__auto__.push((arguments[i__4830__auto___56745]));

var G__56746 = (i__4830__auto___56745 + (1));
i__4830__auto___56745 = G__56746;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56727){
var state_val_56728 = (state_56727[(1)]);
if((state_val_56728 === (1))){
var state_56727__$1 = state_56727;
var statearr_56729_56747 = state_56727__$1;
(statearr_56729_56747[(2)] = null);

(statearr_56729_56747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56728 === (2))){
var _ = (function (){var statearr_56730 = state_56727;
(statearr_56730[(4)] = cljs.core.cons((5),(state_56727[(4)])));

return statearr_56730;
})();
var inst_56703 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56727__$1 = state_56727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56727__$1,(6),inst_56703);
} else {
if((state_val_56728 === (3))){
var inst_56725 = (state_56727[(2)]);
var state_56727__$1 = state_56727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56727__$1,inst_56725);
} else {
if((state_val_56728 === (4))){
var inst_56697 = (state_56727[(2)]);
var state_56727__$1 = state_56727;
var statearr_56732_56748 = state_56727__$1;
(statearr_56732_56748[(2)] = inst_56697);

(statearr_56732_56748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56728 === (5))){
var _ = (function (){var statearr_56733 = state_56727;
(statearr_56733[(4)] = cljs.core.rest((state_56727[(4)])));

return statearr_56733;
})();
var state_56727__$1 = state_56727;
var ex56731 = (state_56727__$1[(2)]);
var statearr_56734_56749 = state_56727__$1;
(statearr_56734_56749[(5)] = ex56731);


if((ex56731 instanceof Error)){
var statearr_56735_56750 = state_56727__$1;
(statearr_56735_56750[(1)] = (4));

(statearr_56735_56750[(5)] = null);

} else {
throw ex56731;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56728 === (6))){
var inst_56705 = (state_56727[(2)]);
var inst_56706 = fluree.db.util.async.throw_err(inst_56705);
var inst_56707 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_56706);
var inst_56708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56709 = [inst_56706];
var inst_56710 = (new cljs.core.PersistentVector(null,1,(5),inst_56708,inst_56709,null));
var inst_56711 = cljs.core.count(inst_56710);
var inst_56712 = ((9) + inst_56711);
var inst_56713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56714 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56716 = [inst_56706];
var inst_56717 = (new cljs.core.PersistentVector(null,1,(5),inst_56715,inst_56716,null));
var inst_56718 = ["-",inst_56717,inst_56707];
var inst_56719 = cljs.core.PersistentHashMap.fromArrays(inst_56714,inst_56718);
var inst_56720 = [inst_56719,inst_56712];
var inst_56721 = (new cljs.core.PersistentVector(null,2,(5),inst_56713,inst_56720,null));
var inst_56722 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56721);
var _ = (function (){var statearr_56736 = state_56727;
(statearr_56736[(4)] = cljs.core.rest((state_56727[(4)])));

return statearr_56736;
})();
var state_56727__$1 = (function (){var statearr_56737 = state_56727;
(statearr_56737[(7)] = inst_56722);

return statearr_56737;
})();
var statearr_56738_56751 = state_56727__$1;
(statearr_56738_56751[(2)] = inst_56707);

(statearr_56738_56751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_56739 = [null,null,null,null,null,null,null,null];
(statearr_56739[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_56739[(1)] = (1));

return statearr_56739;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_56727){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56727);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56740){var ex__2736__auto__ = e56740;
var statearr_56741_56752 = state_56727;
(statearr_56741_56752[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56727[(4)]))){
var statearr_56742_56753 = state_56727;
(statearr_56742_56753[(1)] = cljs.core.first((state_56727[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56754 = state_56727;
state_56727 = G__56754;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_56727){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_56727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56743 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56743[(6)] = c__2755__auto__);

return statearr_56743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq56695){
var G__56696 = cljs.core.first(seq56695);
var seq56695__$1 = cljs.core.next(seq56695);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56696,seq56695__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56804 = arguments.length;
var i__4830__auto___56805 = (0);
while(true){
if((i__4830__auto___56805 < len__4829__auto___56804)){
args__4835__auto__.push((arguments[i__4830__auto___56805]));

var G__56806 = (i__4830__auto___56805 + (1));
i__4830__auto___56805 = G__56806;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56787){
var state_val_56788 = (state_56787[(1)]);
if((state_val_56788 === (1))){
var state_56787__$1 = state_56787;
var statearr_56789_56807 = state_56787__$1;
(statearr_56789_56807[(2)] = null);

(statearr_56789_56807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56788 === (2))){
var _ = (function (){var statearr_56790 = state_56787;
(statearr_56790[(4)] = cljs.core.cons((5),(state_56787[(4)])));

return statearr_56790;
})();
var inst_56763 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56787__$1 = state_56787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56787__$1,(6),inst_56763);
} else {
if((state_val_56788 === (3))){
var inst_56785 = (state_56787[(2)]);
var state_56787__$1 = state_56787;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56787__$1,inst_56785);
} else {
if((state_val_56788 === (4))){
var inst_56757 = (state_56787[(2)]);
var state_56787__$1 = state_56787;
var statearr_56792_56808 = state_56787__$1;
(statearr_56792_56808[(2)] = inst_56757);

(statearr_56792_56808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56788 === (5))){
var _ = (function (){var statearr_56793 = state_56787;
(statearr_56793[(4)] = cljs.core.rest((state_56787[(4)])));

return statearr_56793;
})();
var state_56787__$1 = state_56787;
var ex56791 = (state_56787__$1[(2)]);
var statearr_56794_56809 = state_56787__$1;
(statearr_56794_56809[(5)] = ex56791);


if((ex56791 instanceof Error)){
var statearr_56795_56810 = state_56787__$1;
(statearr_56795_56810[(1)] = (4));

(statearr_56795_56810[(5)] = null);

} else {
throw ex56791;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56788 === (6))){
var inst_56765 = (state_56787[(2)]);
var inst_56766 = fluree.db.util.async.throw_err(inst_56765);
var inst_56767 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_56766);
var inst_56768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56769 = [inst_56766];
var inst_56770 = (new cljs.core.PersistentVector(null,1,(5),inst_56768,inst_56769,null));
var inst_56771 = cljs.core.count(inst_56770);
var inst_56772 = ((9) + inst_56771);
var inst_56773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56774 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56776 = [inst_56766];
var inst_56777 = (new cljs.core.PersistentVector(null,1,(5),inst_56775,inst_56776,null));
var inst_56778 = ["*",inst_56777,inst_56767];
var inst_56779 = cljs.core.PersistentHashMap.fromArrays(inst_56774,inst_56778);
var inst_56780 = [inst_56779,inst_56772];
var inst_56781 = (new cljs.core.PersistentVector(null,2,(5),inst_56773,inst_56780,null));
var inst_56782 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56781);
var _ = (function (){var statearr_56796 = state_56787;
(statearr_56796[(4)] = cljs.core.rest((state_56787[(4)])));

return statearr_56796;
})();
var state_56787__$1 = (function (){var statearr_56797 = state_56787;
(statearr_56797[(7)] = inst_56782);

return statearr_56797;
})();
var statearr_56798_56811 = state_56787__$1;
(statearr_56798_56811[(2)] = inst_56767);

(statearr_56798_56811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_56799 = [null,null,null,null,null,null,null,null];
(statearr_56799[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_56799[(1)] = (1));

return statearr_56799;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_56787){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56787);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56800){var ex__2736__auto__ = e56800;
var statearr_56801_56812 = state_56787;
(statearr_56801_56812[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56787[(4)]))){
var statearr_56802_56813 = state_56787;
(statearr_56802_56813[(1)] = cljs.core.first((state_56787[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56814 = state_56787;
state_56787 = G__56814;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_56787){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_56787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56803 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56803[(6)] = c__2755__auto__);

return statearr_56803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq56755){
var G__56756 = cljs.core.first(seq56755);
var seq56755__$1 = cljs.core.next(seq56755);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56756,seq56755__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56864 = arguments.length;
var i__4830__auto___56865 = (0);
while(true){
if((i__4830__auto___56865 < len__4829__auto___56864)){
args__4835__auto__.push((arguments[i__4830__auto___56865]));

var G__56866 = (i__4830__auto___56865 + (1));
i__4830__auto___56865 = G__56866;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56847){
var state_val_56848 = (state_56847[(1)]);
if((state_val_56848 === (1))){
var state_56847__$1 = state_56847;
var statearr_56849_56867 = state_56847__$1;
(statearr_56849_56867[(2)] = null);

(statearr_56849_56867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56848 === (2))){
var _ = (function (){var statearr_56850 = state_56847;
(statearr_56850[(4)] = cljs.core.cons((5),(state_56847[(4)])));

return statearr_56850;
})();
var inst_56823 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56847__$1 = state_56847;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56847__$1,(6),inst_56823);
} else {
if((state_val_56848 === (3))){
var inst_56845 = (state_56847[(2)]);
var state_56847__$1 = state_56847;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56847__$1,inst_56845);
} else {
if((state_val_56848 === (4))){
var inst_56817 = (state_56847[(2)]);
var state_56847__$1 = state_56847;
var statearr_56852_56868 = state_56847__$1;
(statearr_56852_56868[(2)] = inst_56817);

(statearr_56852_56868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56848 === (5))){
var _ = (function (){var statearr_56853 = state_56847;
(statearr_56853[(4)] = cljs.core.rest((state_56847[(4)])));

return statearr_56853;
})();
var state_56847__$1 = state_56847;
var ex56851 = (state_56847__$1[(2)]);
var statearr_56854_56869 = state_56847__$1;
(statearr_56854_56869[(5)] = ex56851);


if((ex56851 instanceof Error)){
var statearr_56855_56870 = state_56847__$1;
(statearr_56855_56870[(1)] = (4));

(statearr_56855_56870[(5)] = null);

} else {
throw ex56851;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56848 === (6))){
var inst_56825 = (state_56847[(2)]);
var inst_56826 = fluree.db.util.async.throw_err(inst_56825);
var inst_56827 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_56826);
var inst_56828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56829 = [inst_56826];
var inst_56830 = (new cljs.core.PersistentVector(null,1,(5),inst_56828,inst_56829,null));
var inst_56831 = cljs.core.count(inst_56830);
var inst_56832 = ((9) + inst_56831);
var inst_56833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56834 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56836 = [inst_56826];
var inst_56837 = (new cljs.core.PersistentVector(null,1,(5),inst_56835,inst_56836,null));
var inst_56838 = ["/",inst_56837,inst_56827];
var inst_56839 = cljs.core.PersistentHashMap.fromArrays(inst_56834,inst_56838);
var inst_56840 = [inst_56839,inst_56832];
var inst_56841 = (new cljs.core.PersistentVector(null,2,(5),inst_56833,inst_56840,null));
var inst_56842 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56841);
var _ = (function (){var statearr_56856 = state_56847;
(statearr_56856[(4)] = cljs.core.rest((state_56847[(4)])));

return statearr_56856;
})();
var state_56847__$1 = (function (){var statearr_56857 = state_56847;
(statearr_56857[(7)] = inst_56842);

return statearr_56857;
})();
var statearr_56858_56871 = state_56847__$1;
(statearr_56858_56871[(2)] = inst_56827);

(statearr_56858_56871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_56859 = [null,null,null,null,null,null,null,null];
(statearr_56859[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_56859[(1)] = (1));

return statearr_56859;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_56847){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56847);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56860){var ex__2736__auto__ = e56860;
var statearr_56861_56872 = state_56847;
(statearr_56861_56872[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56847[(4)]))){
var statearr_56862_56873 = state_56847;
(statearr_56862_56873[(1)] = cljs.core.first((state_56847[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56874 = state_56847;
state_56847 = G__56874;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_56847){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_56847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56863 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56863[(6)] = c__2755__auto__);

return statearr_56863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq56815){
var G__56816 = cljs.core.first(seq56815);
var seq56815__$1 = cljs.core.next(seq56815);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56816,seq56815__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56912){
var state_val_56913 = (state_56912[(1)]);
if((state_val_56913 === (7))){
var state_56912__$1 = state_56912;
var statearr_56914_56938 = state_56912__$1;
(statearr_56914_56938[(2)] = n);

(statearr_56914_56938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56913 === (1))){
var state_56912__$1 = state_56912;
var statearr_56915_56939 = state_56912__$1;
(statearr_56915_56939[(2)] = null);

(statearr_56915_56939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56913 === (4))){
var inst_56875 = (state_56912[(2)]);
var state_56912__$1 = state_56912;
var statearr_56916_56940 = state_56912__$1;
(statearr_56916_56940[(2)] = inst_56875);

(statearr_56916_56940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56913 === (13))){
var inst_56892 = (state_56912[(2)]);
var inst_56893 = fluree.db.util.async.throw_err(inst_56892);
var state_56912__$1 = state_56912;
var statearr_56917_56941 = state_56912__$1;
(statearr_56917_56941[(2)] = inst_56893);

(statearr_56917_56941[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56913 === (6))){
var state_56912__$1 = state_56912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56912__$1,(9),n);
} else {
if((state_val_56913 === (3))){
var inst_56910 = (state_56912[(2)]);
var state_56912__$1 = state_56912;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56912__$1,inst_56910);
} else {
if((state_val_56913 === (12))){
var inst_56888 = (state_56912[(7)]);
var inst_56896 = (state_56912[(2)]);
var inst_56897 = fluree.db.dbfunctions.internal.quot(inst_56888,inst_56896);
var inst_56898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56899 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56901 = [inst_56888,inst_56896];
var inst_56902 = (new cljs.core.PersistentVector(null,2,(5),inst_56900,inst_56901,null));
var inst_56903 = ["quot",inst_56902,inst_56897];
var inst_56904 = cljs.core.PersistentHashMap.fromArrays(inst_56899,inst_56903);
var inst_56905 = [inst_56904,(2)];
var inst_56906 = (new cljs.core.PersistentVector(null,2,(5),inst_56898,inst_56905,null));
var inst_56907 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56906);
var _ = (function (){var statearr_56918 = state_56912;
(statearr_56918[(4)] = cljs.core.rest((state_56912[(4)])));

return statearr_56918;
})();
var state_56912__$1 = (function (){var statearr_56919 = state_56912;
(statearr_56919[(8)] = inst_56907);

return statearr_56919;
})();
var statearr_56920_56942 = state_56912__$1;
(statearr_56920_56942[(2)] = inst_56897);

(statearr_56920_56942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56913 === (2))){
var _ = (function (){var statearr_56921 = state_56912;
(statearr_56921[(4)] = cljs.core.cons((5),(state_56912[(4)])));

return statearr_56921;
})();
var inst_56881 = fluree.db.util.async.channel_QMARK_(n);
var state_56912__$1 = state_56912;
if(inst_56881){
var statearr_56922_56943 = state_56912__$1;
(statearr_56922_56943[(1)] = (6));

} else {
var statearr_56923_56944 = state_56912__$1;
(statearr_56923_56944[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56913 === (11))){
var state_56912__$1 = state_56912;
var statearr_56925_56945 = state_56912__$1;
(statearr_56925_56945[(2)] = d);

(statearr_56925_56945[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56913 === (9))){
var inst_56884 = (state_56912[(2)]);
var inst_56885 = fluree.db.util.async.throw_err(inst_56884);
var state_56912__$1 = state_56912;
var statearr_56926_56946 = state_56912__$1;
(statearr_56926_56946[(2)] = inst_56885);

(statearr_56926_56946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56913 === (5))){
var _ = (function (){var statearr_56927 = state_56912;
(statearr_56927[(4)] = cljs.core.rest((state_56912[(4)])));

return statearr_56927;
})();
var state_56912__$1 = state_56912;
var ex56924 = (state_56912__$1[(2)]);
var statearr_56928_56947 = state_56912__$1;
(statearr_56928_56947[(5)] = ex56924);


if((ex56924 instanceof Error)){
var statearr_56929_56948 = state_56912__$1;
(statearr_56929_56948[(1)] = (4));

(statearr_56929_56948[(5)] = null);

} else {
throw ex56924;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56913 === (10))){
var state_56912__$1 = state_56912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56912__$1,(13),d);
} else {
if((state_val_56913 === (8))){
var inst_56888 = (state_56912[(2)]);
var inst_56889 = fluree.db.util.async.channel_QMARK_(d);
var state_56912__$1 = (function (){var statearr_56930 = state_56912;
(statearr_56930[(7)] = inst_56888);

return statearr_56930;
})();
if(inst_56889){
var statearr_56931_56949 = state_56912__$1;
(statearr_56931_56949[(1)] = (10));

} else {
var statearr_56932_56950 = state_56912__$1;
(statearr_56932_56950[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto____0 = (function (){
var statearr_56933 = [null,null,null,null,null,null,null,null,null];
(statearr_56933[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto__);

(statearr_56933[(1)] = (1));

return statearr_56933;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto____1 = (function (state_56912){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56912);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56934){var ex__2736__auto__ = e56934;
var statearr_56935_56951 = state_56912;
(statearr_56935_56951[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56912[(4)]))){
var statearr_56936_56952 = state_56912;
(statearr_56936_56952[(1)] = cljs.core.first((state_56912[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56953 = state_56912;
state_56912 = G__56953;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto__ = function(state_56912){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto____1.call(this,state_56912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56937 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56937[(6)] = c__2755__auto__);

return statearr_56937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56991){
var state_val_56992 = (state_56991[(1)]);
if((state_val_56992 === (7))){
var state_56991__$1 = state_56991;
var statearr_56993_57017 = state_56991__$1;
(statearr_56993_57017[(2)] = n);

(statearr_56993_57017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56992 === (1))){
var state_56991__$1 = state_56991;
var statearr_56994_57018 = state_56991__$1;
(statearr_56994_57018[(2)] = null);

(statearr_56994_57018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56992 === (4))){
var inst_56954 = (state_56991[(2)]);
var state_56991__$1 = state_56991;
var statearr_56995_57019 = state_56991__$1;
(statearr_56995_57019[(2)] = inst_56954);

(statearr_56995_57019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56992 === (13))){
var inst_56971 = (state_56991[(2)]);
var inst_56972 = fluree.db.util.async.throw_err(inst_56971);
var state_56991__$1 = state_56991;
var statearr_56996_57020 = state_56991__$1;
(statearr_56996_57020[(2)] = inst_56972);

(statearr_56996_57020[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56992 === (6))){
var state_56991__$1 = state_56991;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56991__$1,(9),n);
} else {
if((state_val_56992 === (3))){
var inst_56989 = (state_56991[(2)]);
var state_56991__$1 = state_56991;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56991__$1,inst_56989);
} else {
if((state_val_56992 === (12))){
var inst_56967 = (state_56991[(7)]);
var inst_56975 = (state_56991[(2)]);
var inst_56976 = fluree.db.dbfunctions.internal.mod(inst_56967,inst_56975);
var inst_56977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56978 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56980 = [inst_56967,inst_56975];
var inst_56981 = (new cljs.core.PersistentVector(null,2,(5),inst_56979,inst_56980,null));
var inst_56982 = ["mod",inst_56981,inst_56976];
var inst_56983 = cljs.core.PersistentHashMap.fromArrays(inst_56978,inst_56982);
var inst_56984 = [inst_56983,(2)];
var inst_56985 = (new cljs.core.PersistentVector(null,2,(5),inst_56977,inst_56984,null));
var inst_56986 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56985);
var _ = (function (){var statearr_56997 = state_56991;
(statearr_56997[(4)] = cljs.core.rest((state_56991[(4)])));

return statearr_56997;
})();
var state_56991__$1 = (function (){var statearr_56998 = state_56991;
(statearr_56998[(8)] = inst_56986);

return statearr_56998;
})();
var statearr_56999_57021 = state_56991__$1;
(statearr_56999_57021[(2)] = inst_56976);

(statearr_56999_57021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56992 === (2))){
var _ = (function (){var statearr_57000 = state_56991;
(statearr_57000[(4)] = cljs.core.cons((5),(state_56991[(4)])));

return statearr_57000;
})();
var inst_56960 = fluree.db.util.async.channel_QMARK_(n);
var state_56991__$1 = state_56991;
if(inst_56960){
var statearr_57001_57022 = state_56991__$1;
(statearr_57001_57022[(1)] = (6));

} else {
var statearr_57002_57023 = state_56991__$1;
(statearr_57002_57023[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56992 === (11))){
var state_56991__$1 = state_56991;
var statearr_57004_57024 = state_56991__$1;
(statearr_57004_57024[(2)] = d);

(statearr_57004_57024[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56992 === (9))){
var inst_56963 = (state_56991[(2)]);
var inst_56964 = fluree.db.util.async.throw_err(inst_56963);
var state_56991__$1 = state_56991;
var statearr_57005_57025 = state_56991__$1;
(statearr_57005_57025[(2)] = inst_56964);

(statearr_57005_57025[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56992 === (5))){
var _ = (function (){var statearr_57006 = state_56991;
(statearr_57006[(4)] = cljs.core.rest((state_56991[(4)])));

return statearr_57006;
})();
var state_56991__$1 = state_56991;
var ex57003 = (state_56991__$1[(2)]);
var statearr_57007_57026 = state_56991__$1;
(statearr_57007_57026[(5)] = ex57003);


if((ex57003 instanceof Error)){
var statearr_57008_57027 = state_56991__$1;
(statearr_57008_57027[(1)] = (4));

(statearr_57008_57027[(5)] = null);

} else {
throw ex57003;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56992 === (10))){
var state_56991__$1 = state_56991;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56991__$1,(13),d);
} else {
if((state_val_56992 === (8))){
var inst_56967 = (state_56991[(2)]);
var inst_56968 = fluree.db.util.async.channel_QMARK_(d);
var state_56991__$1 = (function (){var statearr_57009 = state_56991;
(statearr_57009[(7)] = inst_56967);

return statearr_57009;
})();
if(inst_56968){
var statearr_57010_57028 = state_56991__$1;
(statearr_57010_57028[(1)] = (10));

} else {
var statearr_57011_57029 = state_56991__$1;
(statearr_57011_57029[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto____0 = (function (){
var statearr_57012 = [null,null,null,null,null,null,null,null,null];
(statearr_57012[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto__);

(statearr_57012[(1)] = (1));

return statearr_57012;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto____1 = (function (state_56991){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56991);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e57013){var ex__2736__auto__ = e57013;
var statearr_57014_57030 = state_56991;
(statearr_57014_57030[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56991[(4)]))){
var statearr_57015_57031 = state_56991;
(statearr_57015_57031[(1)] = cljs.core.first((state_56991[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57032 = state_56991;
state_56991 = G__57032;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto__ = function(state_56991){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto____1.call(this,state_56991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_57016 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_57016[(6)] = c__2755__auto__);

return statearr_57016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_57070){
var state_val_57071 = (state_57070[(1)]);
if((state_val_57071 === (7))){
var state_57070__$1 = state_57070;
var statearr_57072_57096 = state_57070__$1;
(statearr_57072_57096[(2)] = n);

(statearr_57072_57096[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57071 === (1))){
var state_57070__$1 = state_57070;
var statearr_57073_57097 = state_57070__$1;
(statearr_57073_57097[(2)] = null);

(statearr_57073_57097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57071 === (4))){
var inst_57033 = (state_57070[(2)]);
var state_57070__$1 = state_57070;
var statearr_57074_57098 = state_57070__$1;
(statearr_57074_57098[(2)] = inst_57033);

(statearr_57074_57098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57071 === (13))){
var inst_57050 = (state_57070[(2)]);
var inst_57051 = fluree.db.util.async.throw_err(inst_57050);
var state_57070__$1 = state_57070;
var statearr_57075_57099 = state_57070__$1;
(statearr_57075_57099[(2)] = inst_57051);

(statearr_57075_57099[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57071 === (6))){
var state_57070__$1 = state_57070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57070__$1,(9),n);
} else {
if((state_val_57071 === (3))){
var inst_57068 = (state_57070[(2)]);
var state_57070__$1 = state_57070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57070__$1,inst_57068);
} else {
if((state_val_57071 === (12))){
var inst_57046 = (state_57070[(7)]);
var inst_57054 = (state_57070[(2)]);
var inst_57055 = fluree.db.dbfunctions.internal.rem(inst_57046,inst_57054);
var inst_57056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57057 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57059 = [inst_57046,inst_57054];
var inst_57060 = (new cljs.core.PersistentVector(null,2,(5),inst_57058,inst_57059,null));
var inst_57061 = ["rem",inst_57060,inst_57055];
var inst_57062 = cljs.core.PersistentHashMap.fromArrays(inst_57057,inst_57061);
var inst_57063 = [inst_57062,(2)];
var inst_57064 = (new cljs.core.PersistentVector(null,2,(5),inst_57056,inst_57063,null));
var inst_57065 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57064);
var _ = (function (){var statearr_57076 = state_57070;
(statearr_57076[(4)] = cljs.core.rest((state_57070[(4)])));

return statearr_57076;
})();
var state_57070__$1 = (function (){var statearr_57077 = state_57070;
(statearr_57077[(8)] = inst_57065);

return statearr_57077;
})();
var statearr_57078_57100 = state_57070__$1;
(statearr_57078_57100[(2)] = inst_57055);

(statearr_57078_57100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57071 === (2))){
var _ = (function (){var statearr_57079 = state_57070;
(statearr_57079[(4)] = cljs.core.cons((5),(state_57070[(4)])));

return statearr_57079;
})();
var inst_57039 = fluree.db.util.async.channel_QMARK_(n);
var state_57070__$1 = state_57070;
if(inst_57039){
var statearr_57080_57101 = state_57070__$1;
(statearr_57080_57101[(1)] = (6));

} else {
var statearr_57081_57102 = state_57070__$1;
(statearr_57081_57102[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57071 === (11))){
var state_57070__$1 = state_57070;
var statearr_57083_57103 = state_57070__$1;
(statearr_57083_57103[(2)] = d);

(statearr_57083_57103[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57071 === (9))){
var inst_57042 = (state_57070[(2)]);
var inst_57043 = fluree.db.util.async.throw_err(inst_57042);
var state_57070__$1 = state_57070;
var statearr_57084_57104 = state_57070__$1;
(statearr_57084_57104[(2)] = inst_57043);

(statearr_57084_57104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57071 === (5))){
var _ = (function (){var statearr_57085 = state_57070;
(statearr_57085[(4)] = cljs.core.rest((state_57070[(4)])));

return statearr_57085;
})();
var state_57070__$1 = state_57070;
var ex57082 = (state_57070__$1[(2)]);
var statearr_57086_57105 = state_57070__$1;
(statearr_57086_57105[(5)] = ex57082);


if((ex57082 instanceof Error)){
var statearr_57087_57106 = state_57070__$1;
(statearr_57087_57106[(1)] = (4));

(statearr_57087_57106[(5)] = null);

} else {
throw ex57082;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57071 === (10))){
var state_57070__$1 = state_57070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57070__$1,(13),d);
} else {
if((state_val_57071 === (8))){
var inst_57046 = (state_57070[(2)]);
var inst_57047 = fluree.db.util.async.channel_QMARK_(d);
var state_57070__$1 = (function (){var statearr_57088 = state_57070;
(statearr_57088[(7)] = inst_57046);

return statearr_57088;
})();
if(inst_57047){
var statearr_57089_57107 = state_57070__$1;
(statearr_57089_57107[(1)] = (10));

} else {
var statearr_57090_57108 = state_57070__$1;
(statearr_57090_57108[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto____0 = (function (){
var statearr_57091 = [null,null,null,null,null,null,null,null,null];
(statearr_57091[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto__);

(statearr_57091[(1)] = (1));

return statearr_57091;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto____1 = (function (state_57070){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_57070);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e57092){var ex__2736__auto__ = e57092;
var statearr_57093_57109 = state_57070;
(statearr_57093_57109[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_57070[(4)]))){
var statearr_57094_57110 = state_57070;
(statearr_57094_57110[(1)] = cljs.core.first((state_57070[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57111 = state_57070;
state_57070 = G__57111;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto__ = function(state_57070){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto____1.call(this,state_57070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_57095 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_57095[(6)] = c__2755__auto__);

return statearr_57095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_57138){
var state_val_57139 = (state_57138[(1)]);
if((state_val_57139 === (7))){
var state_57138__$1 = state_57138;
var statearr_57140_57159 = state_57138__$1;
(statearr_57140_57159[(2)] = x);

(statearr_57140_57159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57139 === (1))){
var state_57138__$1 = state_57138;
var statearr_57141_57160 = state_57138__$1;
(statearr_57141_57160[(2)] = null);

(statearr_57141_57160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57139 === (4))){
var inst_57112 = (state_57138[(2)]);
var state_57138__$1 = state_57138;
var statearr_57142_57161 = state_57138__$1;
(statearr_57142_57161[(2)] = inst_57112);

(statearr_57142_57161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57139 === (6))){
var state_57138__$1 = state_57138;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57138__$1,(9),x);
} else {
if((state_val_57139 === (3))){
var inst_57136 = (state_57138[(2)]);
var state_57138__$1 = state_57138;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57138__$1,inst_57136);
} else {
if((state_val_57139 === (2))){
var _ = (function (){var statearr_57144 = state_57138;
(statearr_57144[(4)] = cljs.core.cons((5),(state_57138[(4)])));

return statearr_57144;
})();
var inst_57118 = fluree.db.util.async.channel_QMARK_(x);
var state_57138__$1 = state_57138;
if(inst_57118){
var statearr_57145_57162 = state_57138__$1;
(statearr_57145_57162[(1)] = (6));

} else {
var statearr_57146_57163 = state_57138__$1;
(statearr_57146_57163[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57139 === (9))){
var inst_57121 = (state_57138[(2)]);
var inst_57122 = fluree.db.util.async.throw_err(inst_57121);
var state_57138__$1 = state_57138;
var statearr_57147_57164 = state_57138__$1;
(statearr_57147_57164[(2)] = inst_57122);

(statearr_57147_57164[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57139 === (5))){
var _ = (function (){var statearr_57148 = state_57138;
(statearr_57148[(4)] = cljs.core.rest((state_57138[(4)])));

return statearr_57148;
})();
var state_57138__$1 = state_57138;
var ex57143 = (state_57138__$1[(2)]);
var statearr_57149_57165 = state_57138__$1;
(statearr_57149_57165[(5)] = ex57143);


if((ex57143 instanceof Error)){
var statearr_57150_57166 = state_57138__$1;
(statearr_57150_57166[(1)] = (4));

(statearr_57150_57166[(5)] = null);

} else {
throw ex57143;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57139 === (8))){
var inst_57125 = (state_57138[(2)]);
var inst_57126 = fluree.db.dbfunctions.internal.boolean$(inst_57125);
var inst_57127 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57128 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57129 = ["boolean",inst_57125,inst_57126];
var inst_57130 = cljs.core.PersistentHashMap.fromArrays(inst_57128,inst_57129);
var inst_57131 = [inst_57130,(10)];
var inst_57132 = (new cljs.core.PersistentVector(null,2,(5),inst_57127,inst_57131,null));
var inst_57133 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57132);
var _ = (function (){var statearr_57151 = state_57138;
(statearr_57151[(4)] = cljs.core.rest((state_57138[(4)])));

return statearr_57151;
})();
var state_57138__$1 = (function (){var statearr_57152 = state_57138;
(statearr_57152[(7)] = inst_57133);

return statearr_57152;
})();
var statearr_57153_57167 = state_57138__$1;
(statearr_57153_57167[(2)] = inst_57126);

(statearr_57153_57167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto____0 = (function (){
var statearr_57154 = [null,null,null,null,null,null,null,null];
(statearr_57154[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto__);

(statearr_57154[(1)] = (1));

return statearr_57154;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto____1 = (function (state_57138){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_57138);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e57155){var ex__2736__auto__ = e57155;
var statearr_57156_57168 = state_57138;
(statearr_57156_57168[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_57138[(4)]))){
var statearr_57157_57169 = state_57138;
(statearr_57157_57169[(1)] = cljs.core.first((state_57138[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57170 = state_57138;
state_57138 = G__57170;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto__ = function(state_57138){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto____1.call(this,state_57138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_57158 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_57158[(6)] = c__2755__auto__);

return statearr_57158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_57208){
var state_val_57209 = (state_57208[(1)]);
if((state_val_57209 === (7))){
var state_57208__$1 = state_57208;
var statearr_57210_57234 = state_57208__$1;
(statearr_57210_57234[(2)] = pattern);

(statearr_57210_57234[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57209 === (1))){
var state_57208__$1 = state_57208;
var statearr_57211_57235 = state_57208__$1;
(statearr_57211_57235[(2)] = null);

(statearr_57211_57235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57209 === (4))){
var inst_57171 = (state_57208[(2)]);
var state_57208__$1 = state_57208;
var statearr_57212_57236 = state_57208__$1;
(statearr_57212_57236[(2)] = inst_57171);

(statearr_57212_57236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57209 === (13))){
var inst_57188 = (state_57208[(2)]);
var inst_57189 = fluree.db.util.async.throw_err(inst_57188);
var state_57208__$1 = state_57208;
var statearr_57213_57237 = state_57208__$1;
(statearr_57213_57237[(2)] = inst_57189);

(statearr_57213_57237[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57209 === (6))){
var state_57208__$1 = state_57208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57208__$1,(9),pattern);
} else {
if((state_val_57209 === (3))){
var inst_57206 = (state_57208[(2)]);
var state_57208__$1 = state_57208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57208__$1,inst_57206);
} else {
if((state_val_57209 === (12))){
var inst_57184 = (state_57208[(7)]);
var inst_57192 = (state_57208[(2)]);
var inst_57193 = fluree.db.dbfunctions.internal.re_find(inst_57184,inst_57192);
var inst_57194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57195 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57197 = [inst_57184,inst_57192];
var inst_57198 = (new cljs.core.PersistentVector(null,2,(5),inst_57196,inst_57197,null));
var inst_57199 = ["re-find",inst_57198,inst_57193];
var inst_57200 = cljs.core.PersistentHashMap.fromArrays(inst_57195,inst_57199);
var inst_57201 = [inst_57200,(10)];
var inst_57202 = (new cljs.core.PersistentVector(null,2,(5),inst_57194,inst_57201,null));
var inst_57203 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57202);
var _ = (function (){var statearr_57214 = state_57208;
(statearr_57214[(4)] = cljs.core.rest((state_57208[(4)])));

return statearr_57214;
})();
var state_57208__$1 = (function (){var statearr_57215 = state_57208;
(statearr_57215[(8)] = inst_57203);

return statearr_57215;
})();
var statearr_57216_57238 = state_57208__$1;
(statearr_57216_57238[(2)] = inst_57193);

(statearr_57216_57238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57209 === (2))){
var _ = (function (){var statearr_57217 = state_57208;
(statearr_57217[(4)] = cljs.core.cons((5),(state_57208[(4)])));

return statearr_57217;
})();
var inst_57177 = fluree.db.util.async.channel_QMARK_(pattern);
var state_57208__$1 = state_57208;
if(inst_57177){
var statearr_57218_57239 = state_57208__$1;
(statearr_57218_57239[(1)] = (6));

} else {
var statearr_57219_57240 = state_57208__$1;
(statearr_57219_57240[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57209 === (11))){
var state_57208__$1 = state_57208;
var statearr_57221_57241 = state_57208__$1;
(statearr_57221_57241[(2)] = string);

(statearr_57221_57241[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57209 === (9))){
var inst_57180 = (state_57208[(2)]);
var inst_57181 = fluree.db.util.async.throw_err(inst_57180);
var state_57208__$1 = state_57208;
var statearr_57222_57242 = state_57208__$1;
(statearr_57222_57242[(2)] = inst_57181);

(statearr_57222_57242[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57209 === (5))){
var _ = (function (){var statearr_57223 = state_57208;
(statearr_57223[(4)] = cljs.core.rest((state_57208[(4)])));

return statearr_57223;
})();
var state_57208__$1 = state_57208;
var ex57220 = (state_57208__$1[(2)]);
var statearr_57224_57243 = state_57208__$1;
(statearr_57224_57243[(5)] = ex57220);


if((ex57220 instanceof Error)){
var statearr_57225_57244 = state_57208__$1;
(statearr_57225_57244[(1)] = (4));

(statearr_57225_57244[(5)] = null);

} else {
throw ex57220;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57209 === (10))){
var state_57208__$1 = state_57208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57208__$1,(13),string);
} else {
if((state_val_57209 === (8))){
var inst_57184 = (state_57208[(2)]);
var inst_57185 = fluree.db.util.async.channel_QMARK_(string);
var state_57208__$1 = (function (){var statearr_57226 = state_57208;
(statearr_57226[(7)] = inst_57184);

return statearr_57226;
})();
if(inst_57185){
var statearr_57227_57245 = state_57208__$1;
(statearr_57227_57245[(1)] = (10));

} else {
var statearr_57228_57246 = state_57208__$1;
(statearr_57228_57246[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto____0 = (function (){
var statearr_57229 = [null,null,null,null,null,null,null,null,null];
(statearr_57229[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto__);

(statearr_57229[(1)] = (1));

return statearr_57229;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto____1 = (function (state_57208){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_57208);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e57230){var ex__2736__auto__ = e57230;
var statearr_57231_57247 = state_57208;
(statearr_57231_57247[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_57208[(4)]))){
var statearr_57232_57248 = state_57208;
(statearr_57232_57248[(1)] = cljs.core.first((state_57208[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57249 = state_57208;
state_57208 = G__57249;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto__ = function(state_57208){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto____1.call(this,state_57208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_57233 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_57233[(6)] = c__2755__auto__);

return statearr_57233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_57276){
var state_val_57277 = (state_57276[(1)]);
if((state_val_57277 === (7))){
var state_57276__$1 = state_57276;
var statearr_57278_57297 = state_57276__$1;
(statearr_57278_57297[(2)] = email);

(statearr_57278_57297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57277 === (1))){
var state_57276__$1 = state_57276;
var statearr_57279_57298 = state_57276__$1;
(statearr_57279_57298[(2)] = null);

(statearr_57279_57298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57277 === (4))){
var inst_57250 = (state_57276[(2)]);
var state_57276__$1 = state_57276;
var statearr_57280_57299 = state_57276__$1;
(statearr_57280_57299[(2)] = inst_57250);

(statearr_57280_57299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57277 === (6))){
var state_57276__$1 = state_57276;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57276__$1,(9),email);
} else {
if((state_val_57277 === (3))){
var inst_57274 = (state_57276[(2)]);
var state_57276__$1 = state_57276;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57276__$1,inst_57274);
} else {
if((state_val_57277 === (2))){
var _ = (function (){var statearr_57282 = state_57276;
(statearr_57282[(4)] = cljs.core.cons((5),(state_57276[(4)])));

return statearr_57282;
})();
var inst_57256 = fluree.db.util.async.channel_QMARK_(email);
var state_57276__$1 = state_57276;
if(inst_57256){
var statearr_57283_57300 = state_57276__$1;
(statearr_57283_57300[(1)] = (6));

} else {
var statearr_57284_57301 = state_57276__$1;
(statearr_57284_57301[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57277 === (9))){
var inst_57259 = (state_57276[(2)]);
var inst_57260 = fluree.db.util.async.throw_err(inst_57259);
var state_57276__$1 = state_57276;
var statearr_57285_57302 = state_57276__$1;
(statearr_57285_57302[(2)] = inst_57260);

(statearr_57285_57302[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57277 === (5))){
var _ = (function (){var statearr_57286 = state_57276;
(statearr_57286[(4)] = cljs.core.rest((state_57276[(4)])));

return statearr_57286;
})();
var state_57276__$1 = state_57276;
var ex57281 = (state_57276__$1[(2)]);
var statearr_57287_57303 = state_57276__$1;
(statearr_57287_57303[(5)] = ex57281);


if((ex57281 instanceof Error)){
var statearr_57288_57304 = state_57276__$1;
(statearr_57288_57304[(1)] = (4));

(statearr_57288_57304[(5)] = null);

} else {
throw ex57281;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57277 === (8))){
var inst_57263 = (state_57276[(2)]);
var inst_57264 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_57263);
var inst_57265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57266 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57267 = ["re-find",inst_57263,inst_57264];
var inst_57268 = cljs.core.PersistentHashMap.fromArrays(inst_57266,inst_57267);
var inst_57269 = [inst_57268,(10)];
var inst_57270 = (new cljs.core.PersistentVector(null,2,(5),inst_57265,inst_57269,null));
var inst_57271 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57270);
var _ = (function (){var statearr_57289 = state_57276;
(statearr_57289[(4)] = cljs.core.rest((state_57276[(4)])));

return statearr_57289;
})();
var state_57276__$1 = (function (){var statearr_57290 = state_57276;
(statearr_57290[(7)] = inst_57271);

return statearr_57290;
})();
var statearr_57291_57305 = state_57276__$1;
(statearr_57291_57305[(2)] = inst_57264);

(statearr_57291_57305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_57292 = [null,null,null,null,null,null,null,null];
(statearr_57292[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto__);

(statearr_57292[(1)] = (1));

return statearr_57292;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto____1 = (function (state_57276){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_57276);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e57293){var ex__2736__auto__ = e57293;
var statearr_57294_57306 = state_57276;
(statearr_57294_57306[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_57276[(4)]))){
var statearr_57295_57307 = state_57276;
(statearr_57295_57307[(1)] = cljs.core.first((state_57276[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57308 = state_57276;
state_57276 = G__57308;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto__ = function(state_57276){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto____1.call(this,state_57276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_57296 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_57296[(6)] = c__2755__auto__);

return statearr_57296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_57355){
var state_val_57356 = (state_57355[(1)]);
if((state_val_57356 === (7))){
var inst_57325 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57355__$1 = state_57355;
if(cljs.core.truth_(inst_57325)){
var statearr_57357_57384 = state_57355__$1;
(statearr_57357_57384[(1)] = (9));

} else {
var statearr_57358_57385 = state_57355__$1;
(statearr_57358_57385[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57356 === (1))){
var state_57355__$1 = state_57355;
var statearr_57359_57386 = state_57355__$1;
(statearr_57359_57386[(2)] = null);

(statearr_57359_57386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57356 === (4))){
var inst_57309 = (state_57355[(2)]);
var state_57355__$1 = state_57355;
var statearr_57360_57387 = state_57355__$1;
(statearr_57360_57387[(2)] = inst_57309);

(statearr_57360_57387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57356 === (15))){
var inst_57336 = (state_57355[(2)]);
var state_57355__$1 = state_57355;
var statearr_57361_57388 = state_57355__$1;
(statearr_57361_57388[(2)] = inst_57336);

(statearr_57361_57388[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57356 === (13))){
var inst_57333 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57355__$1 = state_57355;
var statearr_57362_57389 = state_57355__$1;
(statearr_57362_57389[(2)] = inst_57333);

(statearr_57362_57389[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57356 === (6))){
var inst_57320 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57321 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57322 = [inst_57321,(0)];
var inst_57323 = (new cljs.core.PersistentVector(null,2,(5),inst_57320,inst_57322,null));
var state_57355__$1 = state_57355;
var statearr_57363_57390 = state_57355__$1;
(statearr_57363_57390[(2)] = inst_57323);

(statearr_57363_57390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57356 === (3))){
var inst_57353 = (state_57355[(2)]);
var state_57355__$1 = state_57355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57355__$1,inst_57353);
} else {
if((state_val_57356 === (12))){
var inst_57329 = (state_57355[(2)]);
var inst_57330 = fluree.db.util.async.throw_err(inst_57329);
var state_57355__$1 = state_57355;
var statearr_57364_57391 = state_57355__$1;
(statearr_57364_57391[(2)] = inst_57330);

(statearr_57364_57391[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57356 === (2))){
var _ = (function (){var statearr_57365 = state_57355;
(statearr_57365[(4)] = cljs.core.cons((5),(state_57355[(4)])));

return statearr_57365;
})();
var inst_57318 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57355__$1 = state_57355;
if(cljs.core.truth_(inst_57318)){
var statearr_57366_57392 = state_57355__$1;
(statearr_57366_57392[(1)] = (6));

} else {
var statearr_57367_57393 = state_57355__$1;
(statearr_57367_57393[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57356 === (11))){
var inst_57338 = (state_57355[(2)]);
var state_57355__$1 = state_57355;
var statearr_57369_57394 = state_57355__$1;
(statearr_57369_57394[(2)] = inst_57338);

(statearr_57369_57394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57356 === (9))){
var inst_57327 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_57355__$1 = state_57355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57355__$1,(12),inst_57327);
} else {
if((state_val_57356 === (5))){
var _ = (function (){var statearr_57370 = state_57355;
(statearr_57370[(4)] = cljs.core.rest((state_57355[(4)])));

return statearr_57370;
})();
var state_57355__$1 = state_57355;
var ex57368 = (state_57355__$1[(2)]);
var statearr_57371_57395 = state_57355__$1;
(statearr_57371_57395[(5)] = ex57368);


if((ex57368 instanceof Error)){
var statearr_57372_57396 = state_57355__$1;
(statearr_57372_57396[(1)] = (4));

(statearr_57372_57396[(5)] = null);

} else {
throw ex57368;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57356 === (14))){
var state_57355__$1 = state_57355;
var statearr_57373_57397 = state_57355__$1;
(statearr_57373_57397[(2)] = null);

(statearr_57373_57397[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57356 === (10))){
var state_57355__$1 = state_57355;
var statearr_57374_57398 = state_57355__$1;
(statearr_57374_57398[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57356 === (8))){
var inst_57340 = (state_57355[(2)]);
var inst_57341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57340,(0),null);
var inst_57342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57340,(1),null);
var inst_57343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57344 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57345 = ["?user_id","?ctx",inst_57341];
var inst_57346 = cljs.core.PersistentHashMap.fromArrays(inst_57344,inst_57345);
var inst_57347 = ((10) + inst_57342);
var inst_57348 = [inst_57346,inst_57347];
var inst_57349 = (new cljs.core.PersistentVector(null,2,(5),inst_57343,inst_57348,null));
var inst_57350 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57349);
var _ = (function (){var statearr_57376 = state_57355;
(statearr_57376[(4)] = cljs.core.rest((state_57355[(4)])));

return statearr_57376;
})();
var state_57355__$1 = (function (){var statearr_57377 = state_57355;
(statearr_57377[(7)] = inst_57350);

return statearr_57377;
})();
var statearr_57378_57399 = state_57355__$1;
(statearr_57378_57399[(2)] = inst_57341);

(statearr_57378_57399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto____0 = (function (){
var statearr_57379 = [null,null,null,null,null,null,null,null];
(statearr_57379[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto__);

(statearr_57379[(1)] = (1));

return statearr_57379;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto____1 = (function (state_57355){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_57355);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e57380){var ex__2736__auto__ = e57380;
var statearr_57381_57400 = state_57355;
(statearr_57381_57400[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_57355[(4)]))){
var statearr_57382_57401 = state_57355;
(statearr_57382_57401[(1)] = cljs.core.first((state_57355[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57402 = state_57355;
state_57355 = G__57402;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto__ = function(state_57355){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto____1.call(this,state_57355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_57383 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_57383[(6)] = c__2755__auto__);

return statearr_57383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_57430){
var state_val_57431 = (state_57430[(1)]);
if((state_val_57431 === (7))){
var inst_57423 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57430__$1 = state_57430;
var statearr_57432_57451 = state_57430__$1;
(statearr_57432_57451[(2)] = inst_57423);

(statearr_57432_57451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57431 === (1))){
var state_57430__$1 = state_57430;
var statearr_57433_57452 = state_57430__$1;
(statearr_57433_57452[(2)] = null);

(statearr_57433_57452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57431 === (4))){
var inst_57403 = (state_57430[(2)]);
var state_57430__$1 = state_57430;
var statearr_57434_57453 = state_57430__$1;
(statearr_57434_57453[(2)] = inst_57403);

(statearr_57434_57453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57431 === (6))){
var inst_57411 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_57430__$1 = state_57430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57430__$1,(9),inst_57411);
} else {
if((state_val_57431 === (3))){
var inst_57428 = (state_57430[(2)]);
var state_57430__$1 = state_57430;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57430__$1,inst_57428);
} else {
if((state_val_57431 === (2))){
var _ = (function (){var statearr_57436 = state_57430;
(statearr_57436[(4)] = cljs.core.cons((5),(state_57430[(4)])));

return statearr_57436;
})();
var inst_57409 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57430__$1 = state_57430;
if(cljs.core.truth_(inst_57409)){
var statearr_57437_57454 = state_57430__$1;
(statearr_57437_57454[(1)] = (6));

} else {
var statearr_57438_57455 = state_57430__$1;
(statearr_57438_57455[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57431 === (9))){
var inst_57413 = (state_57430[(2)]);
var inst_57414 = fluree.db.util.async.throw_err(inst_57413);
var inst_57415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57416 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57417 = ["?auth_id","?ctx",inst_57414];
var inst_57418 = cljs.core.PersistentHashMap.fromArrays(inst_57416,inst_57417);
var inst_57419 = [inst_57418,(10)];
var inst_57420 = (new cljs.core.PersistentVector(null,2,(5),inst_57415,inst_57419,null));
var inst_57421 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57420);
var state_57430__$1 = (function (){var statearr_57439 = state_57430;
(statearr_57439[(7)] = inst_57421);

return statearr_57439;
})();
var statearr_57440_57456 = state_57430__$1;
(statearr_57440_57456[(2)] = inst_57414);

(statearr_57440_57456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57431 === (5))){
var _ = (function (){var statearr_57441 = state_57430;
(statearr_57441[(4)] = cljs.core.rest((state_57430[(4)])));

return statearr_57441;
})();
var state_57430__$1 = state_57430;
var ex57435 = (state_57430__$1[(2)]);
var statearr_57442_57457 = state_57430__$1;
(statearr_57442_57457[(5)] = ex57435);


if((ex57435 instanceof Error)){
var statearr_57443_57458 = state_57430__$1;
(statearr_57443_57458[(1)] = (4));

(statearr_57443_57458[(5)] = null);

} else {
throw ex57435;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57431 === (8))){
var inst_57425 = (state_57430[(2)]);
var _ = (function (){var statearr_57444 = state_57430;
(statearr_57444[(4)] = cljs.core.rest((state_57430[(4)])));

return statearr_57444;
})();
var state_57430__$1 = state_57430;
var statearr_57445_57459 = state_57430__$1;
(statearr_57445_57459[(2)] = inst_57425);

(statearr_57445_57459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto____0 = (function (){
var statearr_57446 = [null,null,null,null,null,null,null,null];
(statearr_57446[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto__);

(statearr_57446[(1)] = (1));

return statearr_57446;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto____1 = (function (state_57430){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_57430);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e57447){var ex__2736__auto__ = e57447;
var statearr_57448_57460 = state_57430;
(statearr_57448_57460[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_57430[(4)]))){
var statearr_57449_57461 = state_57430;
(statearr_57449_57461[(1)] = cljs.core.first((state_57430[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57462 = state_57430;
state_57430 = G__57462;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto__ = function(state_57430){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto____1.call(this,state_57430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_57450 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_57450[(6)] = c__2755__auto__);

return statearr_57450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57464 = arguments.length;
switch (G__57464) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_57506){
var state_val_57507 = (state_57506[(1)]);
if((state_val_57507 === (7))){
var state_57506__$1 = state_57506;
var statearr_57508_57538 = state_57506__$1;
(statearr_57508_57538[(2)] = seed);

(statearr_57508_57538[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57507 === (1))){
var state_57506__$1 = state_57506;
var statearr_57509_57539 = state_57506__$1;
(statearr_57509_57539[(2)] = null);

(statearr_57509_57539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57507 === (4))){
var inst_57465 = (state_57506[(2)]);
var state_57506__$1 = state_57506;
var statearr_57510_57540 = state_57506__$1;
(statearr_57510_57540[(2)] = inst_57465);

(statearr_57510_57540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57507 === (15))){
var state_57506__$1 = state_57506;
var statearr_57511_57541 = state_57506__$1;
(statearr_57511_57541[(2)] = (10));

(statearr_57511_57541[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57507 === (13))){
var inst_57482 = (state_57506[(2)]);
var inst_57483 = fluree.db.util.async.throw_err(inst_57482);
var state_57506__$1 = state_57506;
var statearr_57512_57542 = state_57506__$1;
(statearr_57512_57542[(2)] = inst_57483);

(statearr_57512_57542[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57507 === (6))){
var state_57506__$1 = state_57506;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57506__$1,(9),seed);
} else {
if((state_val_57507 === (3))){
var inst_57504 = (state_57506[(2)]);
var state_57506__$1 = state_57506;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57506__$1,inst_57504);
} else {
if((state_val_57507 === (12))){
var inst_57486 = (state_57506[(7)]);
var inst_57486__$1 = (state_57506[(2)]);
var state_57506__$1 = (function (){var statearr_57513 = state_57506;
(statearr_57513[(7)] = inst_57486__$1);

return statearr_57513;
})();
if(cljs.core.truth_(inst_57486__$1)){
var statearr_57514_57543 = state_57506__$1;
(statearr_57514_57543[(1)] = (14));

} else {
var statearr_57515_57544 = state_57506__$1;
(statearr_57515_57544[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57507 === (2))){
var _ = (function (){var statearr_57516 = state_57506;
(statearr_57516[(4)] = cljs.core.cons((5),(state_57506[(4)])));

return statearr_57516;
})();
var inst_57471 = fluree.db.util.async.channel_QMARK_(seed);
var state_57506__$1 = state_57506;
if(inst_57471){
var statearr_57517_57545 = state_57506__$1;
(statearr_57517_57545[(1)] = (6));

} else {
var statearr_57518_57546 = state_57506__$1;
(statearr_57518_57546[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57507 === (11))){
var state_57506__$1 = state_57506;
var statearr_57520_57547 = state_57506__$1;
(statearr_57520_57547[(2)] = max);

(statearr_57520_57547[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57507 === (9))){
var inst_57474 = (state_57506[(2)]);
var inst_57475 = fluree.db.util.async.throw_err(inst_57474);
var state_57506__$1 = state_57506;
var statearr_57521_57548 = state_57506__$1;
(statearr_57521_57548[(2)] = inst_57475);

(statearr_57521_57548[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57507 === (5))){
var _ = (function (){var statearr_57522 = state_57506;
(statearr_57522[(4)] = cljs.core.rest((state_57506[(4)])));

return statearr_57522;
})();
var state_57506__$1 = state_57506;
var ex57519 = (state_57506__$1[(2)]);
var statearr_57523_57549 = state_57506__$1;
(statearr_57523_57549[(5)] = ex57519);


if((ex57519 instanceof Error)){
var statearr_57524_57550 = state_57506__$1;
(statearr_57524_57550[(1)] = (4));

(statearr_57524_57550[(5)] = null);

} else {
throw ex57519;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57507 === (14))){
var inst_57486 = (state_57506[(7)]);
var state_57506__$1 = state_57506;
var statearr_57525_57551 = state_57506__$1;
(statearr_57525_57551[(2)] = inst_57486);

(statearr_57525_57551[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57507 === (16))){
var inst_57478 = (state_57506[(8)]);
var inst_57490 = (state_57506[(2)]);
var inst_57491 = fluree.db.dbfunctions.internal.rand(inst_57478,inst_57490);
var inst_57492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57493 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57494 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57495 = [max,seed];
var inst_57496 = (new cljs.core.PersistentVector(null,2,(5),inst_57494,inst_57495,null));
var inst_57497 = ["rand",inst_57496,inst_57491];
var inst_57498 = cljs.core.PersistentHashMap.fromArrays(inst_57493,inst_57497);
var inst_57499 = [inst_57498,(10)];
var inst_57500 = (new cljs.core.PersistentVector(null,2,(5),inst_57492,inst_57499,null));
var inst_57501 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57500);
var _ = (function (){var statearr_57526 = state_57506;
(statearr_57526[(4)] = cljs.core.rest((state_57506[(4)])));

return statearr_57526;
})();
var state_57506__$1 = (function (){var statearr_57527 = state_57506;
(statearr_57527[(9)] = inst_57501);

return statearr_57527;
})();
var statearr_57528_57552 = state_57506__$1;
(statearr_57528_57552[(2)] = inst_57491);

(statearr_57528_57552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57507 === (10))){
var state_57506__$1 = state_57506;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57506__$1,(13),max);
} else {
if((state_val_57507 === (8))){
var inst_57478 = (state_57506[(2)]);
var inst_57479 = fluree.db.util.async.channel_QMARK_(max);
var state_57506__$1 = (function (){var statearr_57529 = state_57506;
(statearr_57529[(8)] = inst_57478);

return statearr_57529;
})();
if(inst_57479){
var statearr_57530_57553 = state_57506__$1;
(statearr_57530_57553[(1)] = (10));

} else {
var statearr_57531_57554 = state_57506__$1;
(statearr_57531_57554[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_57532 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57532[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_57532[(1)] = (1));

return statearr_57532;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_57506){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_57506);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e57533){var ex__2736__auto__ = e57533;
var statearr_57534_57555 = state_57506;
(statearr_57534_57555[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_57506[(4)]))){
var statearr_57535_57556 = state_57506;
(statearr_57535_57556[(1)] = cljs.core.first((state_57506[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57557 = state_57506;
state_57506 = G__57557;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_57506){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_57506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_57536 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_57536[(6)] = c__2755__auto__);

return statearr_57536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_57578){
var state_val_57579 = (state_57578[(1)]);
if((state_val_57579 === (1))){
var state_57578__$1 = state_57578;
var statearr_57580_57595 = state_57578__$1;
(statearr_57580_57595[(2)] = null);

(statearr_57580_57595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57579 === (2))){
var _ = (function (){var statearr_57581 = state_57578;
(statearr_57581[(4)] = cljs.core.cons((5),(state_57578[(4)])));

return statearr_57581;
})();
var inst_57564 = fluree.db.util.core.random_uuid();
var inst_57565 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57564);
var inst_57566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57567 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57568 = cljs.core.PersistentVector.EMPTY;
var inst_57569 = ["uuid",inst_57568,inst_57565];
var inst_57570 = cljs.core.PersistentHashMap.fromArrays(inst_57567,inst_57569);
var inst_57571 = [inst_57570,(10)];
var inst_57572 = (new cljs.core.PersistentVector(null,2,(5),inst_57566,inst_57571,null));
var inst_57573 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57572);
var ___$1 = (function (){var statearr_57582 = state_57578;
(statearr_57582[(4)] = cljs.core.rest((state_57578[(4)])));

return statearr_57582;
})();
var state_57578__$1 = (function (){var statearr_57583 = state_57578;
(statearr_57583[(7)] = inst_57573);

return statearr_57583;
})();
var statearr_57584_57596 = state_57578__$1;
(statearr_57584_57596[(2)] = inst_57565);

(statearr_57584_57596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57579 === (3))){
var inst_57576 = (state_57578[(2)]);
var state_57578__$1 = state_57578;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57578__$1,inst_57576);
} else {
if((state_val_57579 === (4))){
var inst_57558 = (state_57578[(2)]);
var state_57578__$1 = state_57578;
var statearr_57586_57597 = state_57578__$1;
(statearr_57586_57597[(2)] = inst_57558);

(statearr_57586_57597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57579 === (5))){
var _ = (function (){var statearr_57587 = state_57578;
(statearr_57587[(4)] = cljs.core.rest((state_57578[(4)])));

return statearr_57587;
})();
var state_57578__$1 = state_57578;
var ex57585 = (state_57578__$1[(2)]);
var statearr_57588_57598 = state_57578__$1;
(statearr_57588_57598[(5)] = ex57585);


if((ex57585 instanceof Error)){
var statearr_57589_57599 = state_57578__$1;
(statearr_57589_57599[(1)] = (4));

(statearr_57589_57599[(5)] = null);

} else {
throw ex57585;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto____0 = (function (){
var statearr_57590 = [null,null,null,null,null,null,null,null];
(statearr_57590[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto__);

(statearr_57590[(1)] = (1));

return statearr_57590;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto____1 = (function (state_57578){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_57578);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e57591){var ex__2736__auto__ = e57591;
var statearr_57592_57600 = state_57578;
(statearr_57592_57600[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_57578[(4)]))){
var statearr_57593_57601 = state_57578;
(statearr_57593_57601[(1)] = cljs.core.first((state_57578[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57602 = state_57578;
state_57578 = G__57602;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto__ = function(state_57578){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto____1.call(this,state_57578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_57594 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_57594[(6)] = c__2755__auto__);

return statearr_57594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_57632){
var state_val_57633 = (state_57632[(1)]);
if((state_val_57633 === (7))){
var state_57632__$1 = state_57632;
var statearr_57634_57653 = state_57632__$1;
(statearr_57634_57653[(2)] = num);

(statearr_57634_57653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57633 === (1))){
var state_57632__$1 = state_57632;
var statearr_57635_57654 = state_57632__$1;
(statearr_57635_57654[(2)] = null);

(statearr_57635_57654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57633 === (4))){
var inst_57603 = (state_57632[(2)]);
var state_57632__$1 = state_57632;
var statearr_57636_57655 = state_57632__$1;
(statearr_57636_57655[(2)] = inst_57603);

(statearr_57636_57655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57633 === (6))){
var state_57632__$1 = state_57632;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57632__$1,(9),num);
} else {
if((state_val_57633 === (3))){
var inst_57630 = (state_57632[(2)]);
var state_57632__$1 = state_57632;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57632__$1,inst_57630);
} else {
if((state_val_57633 === (2))){
var _ = (function (){var statearr_57638 = state_57632;
(statearr_57638[(4)] = cljs.core.cons((5),(state_57632[(4)])));

return statearr_57638;
})();
var inst_57609 = fluree.db.util.async.channel_QMARK_(num);
var state_57632__$1 = state_57632;
if(inst_57609){
var statearr_57639_57656 = state_57632__$1;
(statearr_57639_57656[(1)] = (6));

} else {
var statearr_57640_57657 = state_57632__$1;
(statearr_57640_57657[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57633 === (9))){
var inst_57612 = (state_57632[(2)]);
var inst_57613 = fluree.db.util.async.throw_err(inst_57612);
var state_57632__$1 = state_57632;
var statearr_57641_57658 = state_57632__$1;
(statearr_57641_57658[(2)] = inst_57613);

(statearr_57641_57658[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57633 === (5))){
var _ = (function (){var statearr_57642 = state_57632;
(statearr_57642[(4)] = cljs.core.rest((state_57632[(4)])));

return statearr_57642;
})();
var state_57632__$1 = state_57632;
var ex57637 = (state_57632__$1[(2)]);
var statearr_57643_57659 = state_57632__$1;
(statearr_57643_57659[(5)] = ex57637);


if((ex57637 instanceof Error)){
var statearr_57644_57660 = state_57632__$1;
(statearr_57644_57660[(1)] = (4));

(statearr_57644_57660[(5)] = null);

} else {
throw ex57637;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57633 === (8))){
var inst_57616 = (state_57632[(2)]);
var inst_57617 = fluree.db.dbfunctions.internal.ceil(inst_57616);
var inst_57618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57619 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57621 = [fluree.db.dbfunctions.fns.ceil];
var inst_57622 = (new cljs.core.PersistentVector(null,1,(5),inst_57620,inst_57621,null));
var inst_57623 = ["",inst_57622,inst_57617];
var inst_57624 = cljs.core.PersistentHashMap.fromArrays(inst_57619,inst_57623);
var inst_57625 = [inst_57624,(10)];
var inst_57626 = (new cljs.core.PersistentVector(null,2,(5),inst_57618,inst_57625,null));
var inst_57627 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57626);
var _ = (function (){var statearr_57645 = state_57632;
(statearr_57645[(4)] = cljs.core.rest((state_57632[(4)])));

return statearr_57645;
})();
var state_57632__$1 = (function (){var statearr_57646 = state_57632;
(statearr_57646[(7)] = inst_57627);

return statearr_57646;
})();
var statearr_57647_57661 = state_57632__$1;
(statearr_57647_57661[(2)] = inst_57617);

(statearr_57647_57661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto____0 = (function (){
var statearr_57648 = [null,null,null,null,null,null,null,null];
(statearr_57648[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto__);

(statearr_57648[(1)] = (1));

return statearr_57648;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto____1 = (function (state_57632){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_57632);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e57649){var ex__2736__auto__ = e57649;
var statearr_57650_57662 = state_57632;
(statearr_57650_57662[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_57632[(4)]))){
var statearr_57651_57663 = state_57632;
(statearr_57651_57663[(1)] = cljs.core.first((state_57632[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57664 = state_57632;
state_57632 = G__57664;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto__ = function(state_57632){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto____1.call(this,state_57632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_57652 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_57652[(6)] = c__2755__auto__);

return statearr_57652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_57694){
var state_val_57695 = (state_57694[(1)]);
if((state_val_57695 === (7))){
var state_57694__$1 = state_57694;
var statearr_57696_57715 = state_57694__$1;
(statearr_57696_57715[(2)] = num);

(statearr_57696_57715[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57695 === (1))){
var state_57694__$1 = state_57694;
var statearr_57697_57716 = state_57694__$1;
(statearr_57697_57716[(2)] = null);

(statearr_57697_57716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57695 === (4))){
var inst_57665 = (state_57694[(2)]);
var state_57694__$1 = state_57694;
var statearr_57698_57717 = state_57694__$1;
(statearr_57698_57717[(2)] = inst_57665);

(statearr_57698_57717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57695 === (6))){
var state_57694__$1 = state_57694;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57694__$1,(9),num);
} else {
if((state_val_57695 === (3))){
var inst_57692 = (state_57694[(2)]);
var state_57694__$1 = state_57694;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57694__$1,inst_57692);
} else {
if((state_val_57695 === (2))){
var _ = (function (){var statearr_57700 = state_57694;
(statearr_57700[(4)] = cljs.core.cons((5),(state_57694[(4)])));

return statearr_57700;
})();
var inst_57671 = fluree.db.util.async.channel_QMARK_(num);
var state_57694__$1 = state_57694;
if(inst_57671){
var statearr_57701_57718 = state_57694__$1;
(statearr_57701_57718[(1)] = (6));

} else {
var statearr_57702_57719 = state_57694__$1;
(statearr_57702_57719[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57695 === (9))){
var inst_57674 = (state_57694[(2)]);
var inst_57675 = fluree.db.util.async.throw_err(inst_57674);
var state_57694__$1 = state_57694;
var statearr_57703_57720 = state_57694__$1;
(statearr_57703_57720[(2)] = inst_57675);

(statearr_57703_57720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57695 === (5))){
var _ = (function (){var statearr_57704 = state_57694;
(statearr_57704[(4)] = cljs.core.rest((state_57694[(4)])));

return statearr_57704;
})();
var state_57694__$1 = state_57694;
var ex57699 = (state_57694__$1[(2)]);
var statearr_57705_57721 = state_57694__$1;
(statearr_57705_57721[(5)] = ex57699);


if((ex57699 instanceof Error)){
var statearr_57706_57722 = state_57694__$1;
(statearr_57706_57722[(1)] = (4));

(statearr_57706_57722[(5)] = null);

} else {
throw ex57699;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57695 === (8))){
var inst_57678 = (state_57694[(2)]);
var inst_57679 = fluree.db.dbfunctions.internal.floor(inst_57678);
var inst_57680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57681 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57683 = [fluree.db.dbfunctions.fns.floor];
var inst_57684 = (new cljs.core.PersistentVector(null,1,(5),inst_57682,inst_57683,null));
var inst_57685 = ["",inst_57684,inst_57679];
var inst_57686 = cljs.core.PersistentHashMap.fromArrays(inst_57681,inst_57685);
var inst_57687 = [inst_57686,(10)];
var inst_57688 = (new cljs.core.PersistentVector(null,2,(5),inst_57680,inst_57687,null));
var inst_57689 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57688);
var _ = (function (){var statearr_57707 = state_57694;
(statearr_57707[(4)] = cljs.core.rest((state_57694[(4)])));

return statearr_57707;
})();
var state_57694__$1 = (function (){var statearr_57708 = state_57694;
(statearr_57708[(7)] = inst_57689);

return statearr_57708;
})();
var statearr_57709_57723 = state_57694__$1;
(statearr_57709_57723[(2)] = inst_57679);

(statearr_57709_57723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto____0 = (function (){
var statearr_57710 = [null,null,null,null,null,null,null,null];
(statearr_57710[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto__);

(statearr_57710[(1)] = (1));

return statearr_57710;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto____1 = (function (state_57694){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_57694);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e57711){var ex__2736__auto__ = e57711;
var statearr_57712_57724 = state_57694;
(statearr_57712_57724[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_57694[(4)]))){
var statearr_57713_57725 = state_57694;
(statearr_57713_57725[(1)] = cljs.core.first((state_57694[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57726 = state_57694;
state_57694 = G__57726;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto__ = function(state_57694){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto____1.call(this,state_57694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_57714 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_57714[(6)] = c__2755__auto__);

return statearr_57714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_57751){
var state_val_57752 = (state_57751[(1)]);
if((state_val_57752 === (1))){
var state_57751__$1 = state_57751;
var statearr_57753_57768 = state_57751__$1;
(statearr_57753_57768[(2)] = null);

(statearr_57753_57768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57752 === (2))){
var _ = (function (){var statearr_57754 = state_57751;
(statearr_57754[(4)] = cljs.core.cons((5),(state_57751[(4)])));

return statearr_57754;
})();
var inst_57733 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_57751__$1 = state_57751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57751__$1,(6),inst_57733);
} else {
if((state_val_57752 === (3))){
var inst_57749 = (state_57751[(2)]);
var state_57751__$1 = state_57751;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57751__$1,inst_57749);
} else {
if((state_val_57752 === (4))){
var inst_57727 = (state_57751[(2)]);
var state_57751__$1 = state_57751;
var statearr_57756_57769 = state_57751__$1;
(statearr_57756_57769[(2)] = inst_57727);

(statearr_57756_57769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57752 === (5))){
var _ = (function (){var statearr_57757 = state_57751;
(statearr_57757[(4)] = cljs.core.rest((state_57751[(4)])));

return statearr_57757;
})();
var state_57751__$1 = state_57751;
var ex57755 = (state_57751__$1[(2)]);
var statearr_57758_57770 = state_57751__$1;
(statearr_57758_57770[(5)] = ex57755);


if((ex57755 instanceof Error)){
var statearr_57759_57771 = state_57751__$1;
(statearr_57759_57771[(1)] = (4));

(statearr_57759_57771[(5)] = null);

} else {
throw ex57755;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57752 === (6))){
var inst_57735 = (state_57751[(2)]);
var inst_57736 = fluree.db.util.async.throw_err(inst_57735);
var inst_57737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57738 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57740 = [compare_val,new_val];
var inst_57741 = (new cljs.core.PersistentVector(null,2,(5),inst_57739,inst_57740,null));
var inst_57742 = ["",inst_57741,inst_57736];
var inst_57743 = cljs.core.PersistentHashMap.fromArrays(inst_57738,inst_57742);
var inst_57744 = [inst_57743,(10)];
var inst_57745 = (new cljs.core.PersistentVector(null,2,(5),inst_57737,inst_57744,null));
var inst_57746 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57745);
var _ = (function (){var statearr_57760 = state_57751;
(statearr_57760[(4)] = cljs.core.rest((state_57751[(4)])));

return statearr_57760;
})();
var state_57751__$1 = (function (){var statearr_57761 = state_57751;
(statearr_57761[(7)] = inst_57746);

return statearr_57761;
})();
var statearr_57762_57772 = state_57751__$1;
(statearr_57762_57772[(2)] = inst_57736);

(statearr_57762_57772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto____0 = (function (){
var statearr_57763 = [null,null,null,null,null,null,null,null];
(statearr_57763[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto__);

(statearr_57763[(1)] = (1));

return statearr_57763;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto____1 = (function (state_57751){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_57751);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e57764){var ex__2736__auto__ = e57764;
var statearr_57765_57773 = state_57751;
(statearr_57765_57773[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_57751[(4)]))){
var statearr_57766_57774 = state_57751;
(statearr_57766_57774[(1)] = cljs.core.first((state_57751[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57775 = state_57751;
state_57751 = G__57775;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto__ = function(state_57751){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto____1.call(this,state_57751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_57767 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_57767[(6)] = c__2755__auto__);

return statearr_57767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
