// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28364 = arguments.length;
var i__4830__auto___28365 = (0);
while(true){
if((i__4830__auto___28365 < len__4829__auto___28364)){
args__4835__auto__.push((arguments[i__4830__auto___28365]));

var G__28366 = (i__4830__auto___28365 + (1));
i__4830__auto___28365 = G__28366;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28361){
var G__28362 = cljs.core.first(seq28361);
var seq28361__$1 = cljs.core.next(seq28361);
var G__28363 = cljs.core.first(seq28361__$1);
var seq28361__$2 = cljs.core.next(seq28361__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28362,G__28363,seq28361__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e28367){var e = e28367;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28368){var e = e28368;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e28369){var e = e28369;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28370){var e = e28370;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28371){var e = e28371;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28374 = arguments.length;
var i__4830__auto___28375 = (0);
while(true){
if((i__4830__auto___28375 < len__4829__auto___28374)){
args__4835__auto__.push((arguments[i__4830__auto___28375]));

var G__28376 = (i__4830__auto___28375 + (1));
i__4830__auto___28375 = G__28376;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28373){var e = e28373;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28372){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28372));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28379 = arguments.length;
var i__4830__auto___28380 = (0);
while(true){
if((i__4830__auto___28380 < len__4829__auto___28379)){
args__4835__auto__.push((arguments[i__4830__auto___28380]));

var G__28381 = (i__4830__auto___28380 + (1));
i__4830__auto___28380 = G__28381;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28378){var e = e28378;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28377){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28377));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e28382){var e = e28382;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28385 = arguments.length;
var i__4830__auto___28386 = (0);
while(true){
if((i__4830__auto___28386 < len__4829__auto___28385)){
args__4835__auto__.push((arguments[i__4830__auto___28386]));

var G__28387 = (i__4830__auto___28386 + (1));
i__4830__auto___28386 = G__28387;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e28384){var e = e28384;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28383){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28383));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28390 = arguments.length;
var i__4830__auto___28391 = (0);
while(true){
if((i__4830__auto___28391 < len__4829__auto___28390)){
args__4835__auto__.push((arguments[i__4830__auto___28391]));

var G__28392 = (i__4830__auto___28391 + (1));
i__4830__auto___28391 = G__28392;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e28389){var e = e28389;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28388){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28388));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e28393){var e = e28393;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e28394){var e = e28394;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28397 = arguments.length;
var i__4830__auto___28398 = (0);
while(true){
if((i__4830__auto___28398 < len__4829__auto___28397)){
args__4835__auto__.push((arguments[i__4830__auto___28398]));

var G__28399 = (i__4830__auto___28398 + (1));
i__4830__auto___28398 = G__28399;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28396){var e = e28396;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28395){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28395));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28402 = arguments.length;
var i__4830__auto___28403 = (0);
while(true){
if((i__4830__auto___28403 < len__4829__auto___28402)){
args__4835__auto__.push((arguments[i__4830__auto___28403]));

var G__28404 = (i__4830__auto___28403 + (1));
i__4830__auto___28403 = G__28404;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28401){var e = e28401;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28400){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28400));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28407 = arguments.length;
var i__4830__auto___28408 = (0);
while(true){
if((i__4830__auto___28408 < len__4829__auto___28407)){
args__4835__auto__.push((arguments[i__4830__auto___28408]));

var G__28409 = (i__4830__auto___28408 + (1));
i__4830__auto___28408 = G__28409;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e28406){var e = e28406;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28405){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28405));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28412 = arguments.length;
var i__4830__auto___28413 = (0);
while(true){
if((i__4830__auto___28413 < len__4829__auto___28412)){
args__4835__auto__.push((arguments[i__4830__auto___28413]));

var G__28414 = (i__4830__auto___28413 + (1));
i__4830__auto___28413 = G__28414;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e28411){var e = e28411;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28410){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28410));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28417 = arguments.length;
var i__4830__auto___28418 = (0);
while(true){
if((i__4830__auto___28418 < len__4829__auto___28417)){
args__4835__auto__.push((arguments[i__4830__auto___28418]));

var G__28419 = (i__4830__auto___28418 + (1));
i__4830__auto___28418 = G__28419;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e28416){var e = e28416;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28415){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28415));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28422 = arguments.length;
var i__4830__auto___28423 = (0);
while(true){
if((i__4830__auto___28423 < len__4829__auto___28422)){
args__4835__auto__.push((arguments[i__4830__auto___28423]));

var G__28424 = (i__4830__auto___28423 + (1));
i__4830__auto___28423 = G__28424;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e28421){var e = e28421;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28420){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28420));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28427 = arguments.length;
var i__4830__auto___28428 = (0);
while(true){
if((i__4830__auto___28428 < len__4829__auto___28427)){
args__4835__auto__.push((arguments[i__4830__auto___28428]));

var G__28429 = (i__4830__auto___28428 + (1));
i__4830__auto___28428 = G__28429;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e28426){var e = e28426;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28425){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28425));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28431 = arguments.length;
switch (G__28431) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28459){
var state_val_28460 = (state_28459[(1)]);
if((state_val_28460 === (7))){
var inst_28444 = (state_28459[(7)]);
var inst_28447 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28444,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_28459__$1 = state_28459;
var statearr_28461_28547 = state_28459__$1;
(statearr_28461_28547[(2)] = inst_28447);

(statearr_28461_28547[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (1))){
var state_28459__$1 = state_28459;
var statearr_28462_28548 = state_28459__$1;
(statearr_28462_28548[(2)] = null);

(statearr_28462_28548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (4))){
var inst_28432 = (state_28459[(2)]);
var state_28459__$1 = state_28459;
var statearr_28463_28549 = state_28459__$1;
(statearr_28463_28549[(2)] = inst_28432);

(statearr_28463_28549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (6))){
var inst_28444 = (state_28459[(7)]);
var inst_28444__$1 = (state_28459[(2)]);
var inst_28445 = fluree.db.util.core.exception_QMARK_(inst_28444__$1);
var state_28459__$1 = (function (){var statearr_28464 = state_28459;
(statearr_28464[(7)] = inst_28444__$1);

return statearr_28464;
})();
if(inst_28445){
var statearr_28465_28550 = state_28459__$1;
(statearr_28465_28550[(1)] = (7));

} else {
var statearr_28466_28551 = state_28459__$1;
(statearr_28466_28551[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (3))){
var inst_28457 = (state_28459[(2)]);
var state_28459__$1 = state_28459;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28459__$1,inst_28457);
} else {
if((state_val_28460 === (2))){
var inst_28438 = (state_28459[(8)]);
var _ = (function (){var statearr_28468 = state_28459;
(statearr_28468[(4)] = cljs.core.cons((5),(state_28459[(4)])));

return statearr_28468;
})();
var inst_28438__$1 = cljs.core.volatile_BANG_((0));
var inst_28439 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28440 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28439,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28438__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_28441 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28440);
var inst_28442 = fluree.db.query.fql.query(db,inst_28441);
var state_28459__$1 = (function (){var statearr_28469 = state_28459;
(statearr_28469[(8)] = inst_28438__$1);

return statearr_28469;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28459__$1,(6),inst_28442);
} else {
if((state_val_28460 === (9))){
var inst_28454 = (state_28459[(2)]);
var _ = (function (){var statearr_28470 = state_28459;
(statearr_28470[(4)] = cljs.core.rest((state_28459[(4)])));

return statearr_28470;
})();
var state_28459__$1 = state_28459;
var statearr_28471_28552 = state_28459__$1;
(statearr_28471_28552[(2)] = inst_28454);

(statearr_28471_28552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (5))){
var _ = (function (){var statearr_28472 = state_28459;
(statearr_28472[(4)] = cljs.core.rest((state_28459[(4)])));

return statearr_28472;
})();
var state_28459__$1 = state_28459;
var ex28467 = (state_28459__$1[(2)]);
var statearr_28473_28553 = state_28459__$1;
(statearr_28473_28553[(5)] = ex28467);


if((ex28467 instanceof Error)){
var statearr_28474_28554 = state_28459__$1;
(statearr_28474_28554[(1)] = (4));

(statearr_28474_28554[(5)] = null);

} else {
throw ex28467;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28460 === (8))){
var inst_28438 = (state_28459[(8)]);
var inst_28444 = (state_28459[(7)]);
var inst_28449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28450 = cljs.core.deref(inst_28438);
var inst_28451 = [inst_28444,inst_28450];
var inst_28452 = (new cljs.core.PersistentVector(null,2,(5),inst_28449,inst_28451,null));
var state_28459__$1 = state_28459;
var statearr_28475_28555 = state_28459__$1;
(statearr_28475_28555[(2)] = inst_28452);

(statearr_28475_28555[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2733__auto____0 = (function (){
var statearr_28476 = [null,null,null,null,null,null,null,null,null];
(statearr_28476[(0)] = fluree$db$dbfunctions$internal$state_machine__2733__auto__);

(statearr_28476[(1)] = (1));

return statearr_28476;
});
var fluree$db$dbfunctions$internal$state_machine__2733__auto____1 = (function (state_28459){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28459);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28477){var ex__2736__auto__ = e28477;
var statearr_28478_28556 = state_28459;
(statearr_28478_28556[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28459[(4)]))){
var statearr_28479_28557 = state_28459;
(statearr_28479_28557[(1)] = cljs.core.first((state_28459[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28558 = state_28459;
state_28459 = G__28558;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2733__auto__ = function(state_28459){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____1.call(this,state_28459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28480 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28480[(6)] = c__2755__auto__);

return statearr_28480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28525){
var state_val_28526 = (state_28525[(1)]);
if((state_val_28526 === (7))){
var inst_28511 = (state_28525[(2)]);
var inst_28512 = fluree.db.query.fql.query(db,inst_28511);
var state_28525__$1 = state_28525;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28525__$1,(8),inst_28512);
} else {
if((state_val_28526 === (1))){
var inst_28481 = typeof select === 'string';
var state_28525__$1 = state_28525;
if(cljs.core.truth_(inst_28481)){
var statearr_28527_28559 = state_28525__$1;
(statearr_28527_28559[(1)] = (2));

} else {
var statearr_28528_28560 = state_28525__$1;
(statearr_28528_28560[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28526 === (4))){
var inst_28494 = (state_28525[(7)]);
var inst_28487 = (state_28525[(8)]);
var inst_28486 = (state_28525[(2)]);
var inst_28487__$1 = cljs.core.volatile_BANG_((0));
var inst_28488 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28489 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28490 = [inst_28487__$1,(100000)];
var inst_28491 = cljs.core.PersistentHashMap.fromArrays(inst_28489,inst_28490);
var inst_28492 = [inst_28486,from,where,block,limit,inst_28491];
var inst_28493 = cljs.core.PersistentHashMap.fromArrays(inst_28488,inst_28492);
var inst_28494__$1 = fluree.db.util.core.without_nils(inst_28493);
var inst_28495 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28494__$1);
var inst_28496 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28494__$1);
var inst_28497 = cljs.core.first(inst_28496);
var inst_28498 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28497], 0));
var inst_28499 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_28498);
var inst_28500 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28494__$1);
var inst_28501 = cljs.core.last(inst_28500);
var inst_28502 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28501], 0));
var inst_28503 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_28502);
var inst_28504 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28495,inst_28499,inst_28503], 0));
var state_28525__$1 = (function (){var statearr_28529 = state_28525;
(statearr_28529[(7)] = inst_28494__$1);

(statearr_28529[(8)] = inst_28487__$1);

return statearr_28529;
})();
if(cljs.core.truth_(inst_28504)){
var statearr_28530_28561 = state_28525__$1;
(statearr_28530_28561[(1)] = (5));

} else {
var statearr_28531_28562 = state_28525__$1;
(statearr_28531_28562[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28526 === (6))){
var inst_28494 = (state_28525[(7)]);
var state_28525__$1 = state_28525;
var statearr_28532_28563 = state_28525__$1;
(statearr_28532_28563[(2)] = inst_28494);

(statearr_28532_28563[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28526 === (3))){
var state_28525__$1 = state_28525;
var statearr_28533_28564 = state_28525__$1;
(statearr_28533_28564[(2)] = select);

(statearr_28533_28564[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28526 === (2))){
var inst_28483 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_28525__$1 = state_28525;
var statearr_28534_28565 = state_28525__$1;
(statearr_28534_28565[(2)] = inst_28483);

(statearr_28534_28565[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28526 === (11))){
var inst_28523 = (state_28525[(2)]);
var state_28525__$1 = state_28525;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28525__$1,inst_28523);
} else {
if((state_val_28526 === (9))){
var inst_28514 = (state_28525[(9)]);
var state_28525__$1 = state_28525;
var statearr_28535_28566 = state_28525__$1;
(statearr_28535_28566[(2)] = inst_28514);

(statearr_28535_28566[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28526 === (5))){
var inst_28494 = (state_28525[(7)]);
var inst_28506 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28494);
var inst_28507 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_28506);
var inst_28508 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28494,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28507);
var state_28525__$1 = state_28525;
var statearr_28536_28567 = state_28525__$1;
(statearr_28536_28567[(2)] = inst_28508);

(statearr_28536_28567[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28526 === (10))){
var inst_28514 = (state_28525[(9)]);
var inst_28487 = (state_28525[(8)]);
var inst_28518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28519 = cljs.core.deref(inst_28487);
var inst_28520 = [inst_28514,inst_28519];
var inst_28521 = (new cljs.core.PersistentVector(null,2,(5),inst_28518,inst_28520,null));
var state_28525__$1 = state_28525;
var statearr_28537_28568 = state_28525__$1;
(statearr_28537_28568[(2)] = inst_28521);

(statearr_28537_28568[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28526 === (8))){
var inst_28514 = (state_28525[(9)]);
var inst_28514__$1 = (state_28525[(2)]);
var inst_28515 = fluree.db.util.core.exception_QMARK_(inst_28514__$1);
var state_28525__$1 = (function (){var statearr_28538 = state_28525;
(statearr_28538[(9)] = inst_28514__$1);

return statearr_28538;
})();
if(inst_28515){
var statearr_28539_28569 = state_28525__$1;
(statearr_28539_28569[(1)] = (9));

} else {
var statearr_28540_28570 = state_28525__$1;
(statearr_28540_28570[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2733__auto____0 = (function (){
var statearr_28541 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28541[(0)] = fluree$db$dbfunctions$internal$state_machine__2733__auto__);

(statearr_28541[(1)] = (1));

return statearr_28541;
});
var fluree$db$dbfunctions$internal$state_machine__2733__auto____1 = (function (state_28525){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28525);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28542){var ex__2736__auto__ = e28542;
var statearr_28543_28571 = state_28525;
(statearr_28543_28571[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28525[(4)]))){
var statearr_28544_28572 = state_28525;
(statearr_28544_28572[(1)] = cljs.core.first((state_28525[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28573 = state_28525;
state_28525 = G__28573;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2733__auto__ = function(state_28525){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____1.call(this,state_28525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28545 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28545[(6)] = c__2755__auto__);

return statearr_28545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28577 = path;
var vec__28578 = G__28577;
var seq__28579 = cljs.core.seq(vec__28578);
var first__28580 = cljs.core.first(seq__28579);
var seq__28579__$1 = cljs.core.next(seq__28579);
var var$ = first__28580;
var r = seq__28579__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28577__$1 = G__28577;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28584 = G__28577__$1;
var seq__28585 = cljs.core.seq(vec__28584);
var first__28586 = cljs.core.first(seq__28585);
var seq__28585__$1 = cljs.core.next(seq__28585);
var var$__$1 = first__28586;
var r__$1 = seq__28585__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__28587 = r__$1;
var G__28588 = n__$2;
var G__28589 = next_clauses;
G__28577__$1 = G__28587;
n__$1 = G__28588;
where_clauses__$1 = G__28589;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__28590 = r__$1;
var G__28591 = next_n;
var G__28592 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__28577__$1 = G__28590;
n__$1 = G__28591;
where_clauses__$1 = G__28592;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28629){
var state_val_28630 = (state_28629[(1)]);
if((state_val_28630 === (7))){
var inst_28602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28603 = [path];
var inst_28604 = (new cljs.core.PersistentVector(null,1,(5),inst_28602,inst_28603,null));
var state_28629__$1 = state_28629;
var statearr_28631_28659 = state_28629__$1;
(statearr_28631_28659[(2)] = inst_28604);

(statearr_28631_28659[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (1))){
var state_28629__$1 = state_28629;
var statearr_28632_28660 = state_28629__$1;
(statearr_28632_28660[(2)] = null);

(statearr_28632_28660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (4))){
var inst_28593 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
var statearr_28633_28661 = state_28629__$1;
(statearr_28633_28661[(2)] = inst_28593);

(statearr_28633_28661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (13))){
var inst_28620 = (state_28629[(2)]);
var inst_28621 = fluree.db.util.async.throw_err(inst_28620);
var _ = (function (){var statearr_28634 = state_28629;
(statearr_28634[(4)] = cljs.core.rest((state_28629[(4)])));

return statearr_28634;
})();
var state_28629__$1 = state_28629;
var statearr_28635_28662 = state_28629__$1;
(statearr_28635_28662[(2)] = inst_28621);

(statearr_28635_28662[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (6))){
var state_28629__$1 = state_28629;
var statearr_28637_28663 = state_28629__$1;
(statearr_28637_28663[(2)] = path);

(statearr_28637_28663[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (3))){
var inst_28627 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28629__$1,inst_28627);
} else {
if((state_val_28630 === (12))){
var _ = (function (){var statearr_28638 = state_28629;
(statearr_28638[(4)] = cljs.core.rest((state_28629[(4)])));

return statearr_28638;
})();
var state_28629__$1 = state_28629;
var ex28636 = (state_28629__$1[(2)]);
var statearr_28639_28664 = state_28629__$1;
(statearr_28639_28664[(5)] = ex28636);


var statearr_28640_28665 = state_28629__$1;
(statearr_28640_28665[(1)] = (11));

(statearr_28640_28665[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (2))){
var _ = (function (){var statearr_28641 = state_28629;
(statearr_28641[(4)] = cljs.core.cons((5),(state_28629[(4)])));

return statearr_28641;
})();
var inst_28599 = cljs.core.vector_QMARK_(path);
var state_28629__$1 = state_28629;
if(inst_28599){
var statearr_28642_28666 = state_28629__$1;
(statearr_28642_28666[(1)] = (6));

} else {
var statearr_28643_28667 = state_28629__$1;
(statearr_28643_28667[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (11))){
var inst_28606 = (state_28629[(7)]);
var inst_28611 = (state_28629[(2)]);
var inst_28612 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28611,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_28606,endSubject], 0));
var state_28629__$1 = state_28629;
var statearr_28645_28668 = state_28629__$1;
(statearr_28645_28668[(2)] = inst_28612);

(statearr_28645_28668[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (9))){
var inst_28610 = (state_28629[(8)]);
var _ = (function (){var statearr_28646 = state_28629;
(statearr_28646[(4)] = cljs.core.cons((12),(state_28629[(4)])));

return statearr_28646;
})();
var inst_28618 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28610);
var state_28629__$1 = state_28629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28629__$1,(13),inst_28618);
} else {
if((state_val_28630 === (5))){
var _ = (function (){var statearr_28647 = state_28629;
(statearr_28647[(4)] = cljs.core.rest((state_28629[(4)])));

return statearr_28647;
})();
var state_28629__$1 = state_28629;
var ex28644 = (state_28629__$1[(2)]);
var statearr_28648_28669 = state_28629__$1;
(statearr_28648_28669[(5)] = ex28644);


if((ex28644 instanceof Error)){
var statearr_28649_28670 = state_28629__$1;
(statearr_28649_28670[(1)] = (4));

(statearr_28649_28670[(5)] = null);

} else {
throw ex28644;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (10))){
var inst_28624 = (state_28629[(2)]);
var _ = (function (){var statearr_28650 = state_28629;
(statearr_28650[(4)] = cljs.core.rest((state_28629[(4)])));

return statearr_28650;
})();
var state_28629__$1 = state_28629;
var statearr_28651_28671 = state_28629__$1;
(statearr_28651_28671[(2)] = inst_28624);

(statearr_28651_28671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28630 === (8))){
var inst_28606 = (state_28629[(7)]);
var inst_28606__$1 = (state_28629[(2)]);
var inst_28607 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_28606__$1,endSubject);
var inst_28608 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28609 = ["?var1",inst_28607];
var inst_28610 = cljs.core.PersistentHashMap.fromArrays(inst_28608,inst_28609);
var state_28629__$1 = (function (){var statearr_28652 = state_28629;
(statearr_28652[(8)] = inst_28610);

(statearr_28652[(7)] = inst_28606__$1);

return statearr_28652;
})();
var statearr_28653_28672 = state_28629__$1;
(statearr_28653_28672[(2)] = null);

(statearr_28653_28672[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_28654 = [null,null,null,null,null,null,null,null,null];
(statearr_28654[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto__);

(statearr_28654[(1)] = (1));

return statearr_28654;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto____1 = (function (state_28629){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28629);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28655){var ex__2736__auto__ = e28655;
var statearr_28656_28673 = state_28629;
(statearr_28656_28673[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28629[(4)]))){
var statearr_28657_28674 = state_28629;
(statearr_28657_28674[(1)] = cljs.core.first((state_28629[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28675 = state_28629;
state_28629 = G__28675;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto__ = function(state_28629){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto____1.call(this,state_28629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28658 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28658[(6)] = c__2755__auto__);

return statearr_28658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e28676){var e = e28676;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28677){var e = e28677;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e28678){var e = e28678;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e28679){var e = e28679;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28682 = arguments.length;
var i__4830__auto___28683 = (0);
while(true){
if((i__4830__auto___28683 < len__4829__auto___28682)){
args__4835__auto__.push((arguments[i__4830__auto___28683]));

var G__28684 = (i__4830__auto___28683 + (1));
i__4830__auto___28683 = G__28684;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e28681){var e = e28681;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28680){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28680));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28687 = arguments.length;
var i__4830__auto___28688 = (0);
while(true){
if((i__4830__auto___28688 < len__4829__auto___28687)){
args__4835__auto__.push((arguments[i__4830__auto___28688]));

var G__28689 = (i__4830__auto___28688 + (1));
i__4830__auto___28688 = G__28689;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e28686){var e = e28686;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28685){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28685));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28692 = arguments.length;
var i__4830__auto___28693 = (0);
while(true){
if((i__4830__auto___28693 < len__4829__auto___28692)){
args__4835__auto__.push((arguments[i__4830__auto___28693]));

var G__28694 = (i__4830__auto___28693 + (1));
i__4830__auto___28693 = G__28694;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4223__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e28691){var e = e28691;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28690){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28690));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28697 = arguments.length;
var i__4830__auto___28698 = (0);
while(true){
if((i__4830__auto___28698 < len__4829__auto___28697)){
args__4835__auto__.push((arguments[i__4830__auto___28698]));

var G__28699 = (i__4830__auto___28698 + (1));
i__4830__auto___28698 = G__28699;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e28696){var e = e28696;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28695){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28695));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e28700){var e = e28700;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e28701){var e = e28701;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e28702){var e = e28702;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28703){var e = e28703;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28704){var e = e28704;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28710 = path;
var vec__28711 = G__28710;
var seq__28712 = cljs.core.seq(vec__28711);
var first__28713 = cljs.core.first(seq__28712);
var seq__28712__$1 = cljs.core.next(seq__28712);
var pred = first__28713;
var r = seq__28712__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28710__$1 = G__28710;
var subjects__$1 = subjects;
while(true){
var vec__28717 = G__28710__$1;
var seq__28718 = cljs.core.seq(vec__28717);
var first__28719 = cljs.core.first(seq__28718);
var seq__28718__$1 = cljs.core.next(seq__28718);
var pred__$1 = first__28719;
var r__$1 = seq__28718__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__28710__$1,subjects__$1,vec__28717,seq__28718,first__28719,seq__28718__$1,pred__$1,r__$1,subjects__$2,G__28710,vec__28711,seq__28712,first__28713,seq__28712__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__28710__$1,subjects__$1,vec__28717,seq__28718,first__28719,seq__28718__$1,pred__$1,r__$1,subjects__$2,G__28710,vec__28711,seq__28712,first__28713,seq__28712__$1,pred,r,subjects){
return (function (p1__28705_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__28705_SHARP_,pred__$1);
});})(G__28710__$1,subjects__$1,vec__28717,seq__28718,first__28719,seq__28718__$1,pred__$1,r__$1,subjects__$2,G__28710,vec__28711,seq__28712,first__28713,seq__28712__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__28710__$1,subjects__$1,vec__28717,seq__28718,first__28719,seq__28718__$1,pred__$1,r__$1,subjects__$2,G__28710,vec__28711,seq__28712,first__28713,seq__28712__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4221__auto__ = r__$1;
if(and__4221__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4221__auto__;
}
})())){
var G__28720 = r__$1;
var G__28721 = next_subjects;
G__28710__$1 = G__28720;
subjects__$1 = G__28721;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28706){var e = e28706;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e28722){var e = e28722;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e28723){var e = e28723;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28726 = arguments.length;
var i__4830__auto___28727 = (0);
while(true){
if((i__4830__auto___28727 < len__4829__auto___28726)){
args__4835__auto__.push((arguments[i__4830__auto___28727]));

var G__28728 = (i__4830__auto___28727 + (1));
i__4830__auto___28727 = G__28728;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e28725){var e = e28725;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28724){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28724));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e28729){var e = e28729;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28732 = arguments.length;
var i__4830__auto___28733 = (0);
while(true){
if((i__4830__auto___28733 < len__4829__auto___28732)){
args__4835__auto__.push((arguments[i__4830__auto___28733]));

var G__28734 = (i__4830__auto___28733 + (1));
i__4830__auto___28733 = G__28734;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e28731){var e = e28731;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28730){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28730));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e28735){var e = e28735;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28790){
var state_val_28791 = (state_28790[(1)]);
if((state_val_28791 === (7))){
var inst_28737 = (state_28790[(2)]);
var state_28790__$1 = state_28790;
var statearr_28792_28825 = state_28790__$1;
(statearr_28792_28825[(2)] = inst_28737);

(statearr_28792_28825[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28791 === (1))){
var state_28790__$1 = state_28790;
var statearr_28793_28826 = state_28790__$1;
(statearr_28793_28826[(2)] = null);

(statearr_28793_28826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28791 === (4))){
var inst_28736 = (state_28790[(2)]);
var state_28790__$1 = (function (){var statearr_28794 = state_28790;
(statearr_28794[(7)] = inst_28736);

return statearr_28794;
})();
var statearr_28795_28827 = state_28790__$1;
(statearr_28795_28827[(2)] = null);

(statearr_28795_28827[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28791 === (15))){
var inst_28774 = (state_28790[(8)]);
var inst_28778 = inst_28774.o;
var state_28790__$1 = state_28790;
var statearr_28796_28828 = state_28790__$1;
(statearr_28796_28828[(2)] = inst_28778);

(statearr_28796_28828[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28791 === (13))){
var inst_28774 = (state_28790[(8)]);
var inst_28770 = (state_28790[(2)]);
var inst_28771 = fluree.db.util.async.throw_err(inst_28770);
var inst_28772 = fluree.db.dbfunctions.internal.count(inst_28771);
var inst_28774__$1 = cljs.core.first(inst_28771);
var inst_28775 = (inst_28774__$1 == null);
var state_28790__$1 = (function (){var statearr_28797 = state_28790;
(statearr_28797[(8)] = inst_28774__$1);

(statearr_28797[(9)] = inst_28772);

return statearr_28797;
})();
if(cljs.core.truth_(inst_28775)){
var statearr_28798_28829 = state_28790__$1;
(statearr_28798_28829[(1)] = (14));

} else {
var statearr_28799_28830 = state_28790__$1;
(statearr_28799_28830[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28791 === (6))){
var inst_28746 = (state_28790[(2)]);
var state_28790__$1 = state_28790;
var statearr_28800_28831 = state_28790__$1;
(statearr_28800_28831[(2)] = inst_28746);

(statearr_28800_28831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28791 === (3))){
var inst_28788 = (state_28790[(2)]);
var state_28790__$1 = state_28790;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28790__$1,inst_28788);
} else {
if((state_val_28791 === (12))){
var inst_28785 = (state_28790[(2)]);
var _ = (function (){var statearr_28801 = state_28790;
(statearr_28801[(4)] = cljs.core.rest((state_28790[(4)])));

return statearr_28801;
})();
var state_28790__$1 = state_28790;
var statearr_28802_28832 = state_28790__$1;
(statearr_28802_28832[(2)] = inst_28785);

(statearr_28802_28832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28791 === (2))){
var _ = (function (){var statearr_28804 = state_28790;
(statearr_28804[(4)] = cljs.core.cons((9),(state_28790[(4)])));

return statearr_28804;
})();
var inst_28752 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28753 = typeof inst_28752 === 'string';
var state_28790__$1 = state_28790;
if(cljs.core.truth_(inst_28753)){
var statearr_28805_28833 = state_28790__$1;
(statearr_28805_28833[(1)] = (10));

} else {
var statearr_28806_28834 = state_28790__$1;
(statearr_28806_28834[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28791 === (11))){
var inst_28759 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28760 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28759);
var inst_28761 = fluree.db.dbfunctions.internal.inc(inst_28760);
var inst_28762 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28759,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28761);
var inst_28763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28764 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28765 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28766 = [inst_28764,inst_28765];
var inst_28767 = (new cljs.core.PersistentVector(null,2,(5),inst_28763,inst_28766,null));
var inst_28768 = fluree.db.dbproto._search(inst_28762,inst_28767);
var state_28790__$1 = state_28790;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28790__$1,(13),inst_28768);
} else {
if((state_val_28791 === (9))){
var _ = (function (){var statearr_28807 = state_28790;
(statearr_28807[(4)] = cljs.core.rest((state_28790[(4)])));

return statearr_28807;
})();
var state_28790__$1 = state_28790;
var ex28803 = (state_28790__$1[(2)]);
var statearr_28808_28835 = state_28790__$1;
(statearr_28808_28835[(5)] = ex28803);


var statearr_28809_28836 = state_28790__$1;
(statearr_28809_28836[(1)] = (4));

(statearr_28809_28836[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28791 === (5))){
var inst_28736 = (state_28790[(7)]);
var _ = (function (){var statearr_28810 = state_28790;
(statearr_28810[(4)] = cljs.core.cons((8),(state_28790[(4)])));

return statearr_28810;
})();
var inst_28743 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28736,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_28811 = state_28790;
(statearr_28811[(4)] = cljs.core.rest((state_28790[(4)])));

return statearr_28811;
})();
var state_28790__$1 = state_28790;
var statearr_28812_28837 = state_28790__$1;
(statearr_28812_28837[(2)] = inst_28743);

(statearr_28812_28837[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28791 === (14))){
var state_28790__$1 = state_28790;
var statearr_28813_28838 = state_28790__$1;
(statearr_28813_28838[(2)] = null);

(statearr_28813_28838[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28791 === (16))){
var inst_28772 = (state_28790[(9)]);
var inst_28780 = (state_28790[(2)]);
var inst_28781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28782 = [inst_28780,inst_28772];
var inst_28783 = (new cljs.core.PersistentVector(null,2,(5),inst_28781,inst_28782,null));
var state_28790__$1 = state_28790;
var statearr_28815_28839 = state_28790__$1;
(statearr_28815_28839[(2)] = inst_28783);

(statearr_28815_28839[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28791 === (10))){
var inst_28755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28756 = [null,(0)];
var inst_28757 = (new cljs.core.PersistentVector(null,2,(5),inst_28755,inst_28756,null));
var state_28790__$1 = state_28790;
var statearr_28816_28840 = state_28790__$1;
(statearr_28816_28840[(2)] = inst_28757);

(statearr_28816_28840[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28791 === (8))){
var _ = (function (){var statearr_28817 = state_28790;
(statearr_28817[(4)] = cljs.core.rest((state_28790[(4)])));

return statearr_28817;
})();
var state_28790__$1 = state_28790;
var ex28814 = (state_28790__$1[(2)]);
var statearr_28818_28841 = state_28790__$1;
(statearr_28818_28841[(5)] = ex28814);


var statearr_28819_28842 = state_28790__$1;
(statearr_28819_28842[(1)] = (7));

(statearr_28819_28842[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto____0 = (function (){
var statearr_28820 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28820[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto__);

(statearr_28820[(1)] = (1));

return statearr_28820;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto____1 = (function (state_28790){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28790);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28821){var ex__2736__auto__ = e28821;
var statearr_28822_28843 = state_28790;
(statearr_28822_28843[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28790[(4)]))){
var statearr_28823_28844 = state_28790;
(statearr_28823_28844[(1)] = cljs.core.first((state_28790[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28845 = state_28790;
state_28790 = G__28845;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto__ = function(state_28790){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto____1.call(this,state_28790);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28824 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28824[(6)] = c__2755__auto__);

return statearr_28824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28897){
var state_val_28898 = (state_28897[(1)]);
if((state_val_28898 === (7))){
var inst_28847 = (state_28897[(2)]);
var state_28897__$1 = state_28897;
var statearr_28899_28928 = state_28897__$1;
(statearr_28899_28928[(2)] = inst_28847);

(statearr_28899_28928[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28898 === (1))){
var state_28897__$1 = state_28897;
var statearr_28900_28929 = state_28897__$1;
(statearr_28900_28929[(2)] = null);

(statearr_28900_28929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28898 === (4))){
var inst_28846 = (state_28897[(2)]);
var state_28897__$1 = (function (){var statearr_28901 = state_28897;
(statearr_28901[(7)] = inst_28846);

return statearr_28901;
})();
var statearr_28902_28930 = state_28897__$1;
(statearr_28902_28930[(2)] = null);

(statearr_28902_28930[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28898 === (13))){
var inst_28892 = (state_28897[(2)]);
var _ = (function (){var statearr_28903 = state_28897;
(statearr_28903[(4)] = cljs.core.rest((state_28897[(4)])));

return statearr_28903;
})();
var state_28897__$1 = state_28897;
var statearr_28904_28931 = state_28897__$1;
(statearr_28904_28931[(2)] = inst_28892);

(statearr_28904_28931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28898 === (6))){
var inst_28856 = (state_28897[(2)]);
var state_28897__$1 = state_28897;
var statearr_28905_28932 = state_28897__$1;
(statearr_28905_28932[(2)] = inst_28856);

(statearr_28905_28932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28898 === (3))){
var inst_28895 = (state_28897[(2)]);
var state_28897__$1 = state_28897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28897__$1,inst_28895);
} else {
if((state_val_28898 === (12))){
var inst_28879 = (state_28897[(8)]);
var inst_28888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28889 = [null,inst_28879];
var inst_28890 = (new cljs.core.PersistentVector(null,2,(5),inst_28888,inst_28889,null));
var state_28897__$1 = state_28897;
var statearr_28906_28933 = state_28897__$1;
(statearr_28906_28933[(2)] = inst_28890);

(statearr_28906_28933[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28898 === (2))){
var _ = (function (){var statearr_28908 = state_28897;
(statearr_28908[(4)] = cljs.core.cons((9),(state_28897[(4)])));

return statearr_28908;
})();
var inst_28865 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28868 = [null,pred_name,"?o"];
var inst_28869 = (new cljs.core.PersistentVector(null,3,(5),inst_28867,inst_28868,null));
var inst_28870 = [inst_28869];
var inst_28871 = (new cljs.core.PersistentVector(null,1,(5),inst_28866,inst_28870,null));
var inst_28872 = ["?o",inst_28871,opts];
var inst_28873 = cljs.core.PersistentHashMap.fromArrays(inst_28865,inst_28872);
var inst_28874 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28873);
var state_28897__$1 = state_28897;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28897__$1,(10),inst_28874);
} else {
if((state_val_28898 === (11))){
var inst_28879 = (state_28897[(8)]);
var inst_28878 = (state_28897[(9)]);
var inst_28883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28884 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_28878);
var inst_28885 = [inst_28884,inst_28879];
var inst_28886 = (new cljs.core.PersistentVector(null,2,(5),inst_28883,inst_28885,null));
var state_28897__$1 = state_28897;
var statearr_28909_28934 = state_28897__$1;
(statearr_28909_28934[(2)] = inst_28886);

(statearr_28909_28934[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28898 === (9))){
var _ = (function (){var statearr_28910 = state_28897;
(statearr_28910[(4)] = cljs.core.rest((state_28897[(4)])));

return statearr_28910;
})();
var state_28897__$1 = state_28897;
var ex28907 = (state_28897__$1[(2)]);
var statearr_28911_28935 = state_28897__$1;
(statearr_28911_28935[(5)] = ex28907);


var statearr_28912_28936 = state_28897__$1;
(statearr_28912_28936[(1)] = (4));

(statearr_28912_28936[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28898 === (5))){
var inst_28846 = (state_28897[(7)]);
var _ = (function (){var statearr_28914 = state_28897;
(statearr_28914[(4)] = cljs.core.cons((8),(state_28897[(4)])));

return statearr_28914;
})();
var inst_28853 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28846,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_28915 = state_28897;
(statearr_28915[(4)] = cljs.core.rest((state_28897[(4)])));

return statearr_28915;
})();
var state_28897__$1 = state_28897;
var statearr_28916_28937 = state_28897__$1;
(statearr_28916_28937[(2)] = inst_28853);

(statearr_28916_28937[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28898 === (10))){
var inst_28878 = (state_28897[(9)]);
var inst_28876 = (state_28897[(2)]);
var inst_28877 = fluree.db.util.async.throw_err(inst_28876);
var inst_28878__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28877,(0),null);
var inst_28879 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28877,(1),null);
var inst_28880 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_28878__$1);
var inst_28881 = cljs.core.not(inst_28880);
var state_28897__$1 = (function (){var statearr_28917 = state_28897;
(statearr_28917[(8)] = inst_28879);

(statearr_28917[(9)] = inst_28878__$1);

return statearr_28917;
})();
if(inst_28881){
var statearr_28918_28938 = state_28897__$1;
(statearr_28918_28938[(1)] = (11));

} else {
var statearr_28919_28939 = state_28897__$1;
(statearr_28919_28939[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28898 === (8))){
var _ = (function (){var statearr_28920 = state_28897;
(statearr_28920[(4)] = cljs.core.rest((state_28897[(4)])));

return statearr_28920;
})();
var state_28897__$1 = state_28897;
var ex28913 = (state_28897__$1[(2)]);
var statearr_28921_28940 = state_28897__$1;
(statearr_28921_28940[(5)] = ex28913);


var statearr_28922_28941 = state_28897__$1;
(statearr_28922_28941[(1)] = (7));

(statearr_28922_28941[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto____0 = (function (){
var statearr_28923 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28923[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto__);

(statearr_28923[(1)] = (1));

return statearr_28923;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto____1 = (function (state_28897){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28897);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28924){var ex__2736__auto__ = e28924;
var statearr_28925_28942 = state_28897;
(statearr_28925_28942[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28897[(4)]))){
var statearr_28926_28943 = state_28897;
(statearr_28926_28943[(1)] = cljs.core.first((state_28897[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28944 = state_28897;
state_28897 = G__28944;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto__ = function(state_28897){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto____1.call(this,state_28897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28927 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28927[(6)] = c__2755__auto__);

return statearr_28927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4221__auto__ = typeof email === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4221__auto__;
}
})());
}catch (e28945){var e = e28945;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__28947 = arguments.length;
switch (G__28947) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_29017){
var state_val_29018 = (state_29017[(1)]);
if((state_val_29018 === (7))){
var inst_28949 = (state_29017[(2)]);
var state_29017__$1 = state_29017;
var statearr_29019_29063 = state_29017__$1;
(statearr_29019_29063[(2)] = inst_28949);

(statearr_29019_29063[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (20))){
var inst_28993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28994 = ["*"];
var inst_28995 = (new cljs.core.PersistentVector(null,1,(5),inst_28993,inst_28994,null));
var state_29017__$1 = state_29017;
var statearr_29020_29064 = state_29017__$1;
(statearr_29020_29064[(2)] = inst_28995);

(statearr_29020_29064[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (1))){
var state_29017__$1 = state_29017;
var statearr_29021_29065 = state_29017__$1;
(statearr_29021_29065[(2)] = null);

(statearr_29021_29065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (4))){
var inst_28948 = (state_29017[(2)]);
var state_29017__$1 = (function (){var statearr_29022 = state_29017;
(statearr_29022[(7)] = inst_28948);

return statearr_29022;
})();
var statearr_29023_29066 = state_29017__$1;
(statearr_29023_29066[(2)] = null);

(statearr_29023_29066[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (15))){
var inst_29012 = (state_29017[(2)]);
var _ = (function (){var statearr_29024 = state_29017;
(statearr_29024[(4)] = cljs.core.rest((state_29017[(4)])));

return statearr_29024;
})();
var state_29017__$1 = state_29017;
var statearr_29025_29067 = state_29017__$1;
(statearr_29025_29067[(2)] = inst_29012);

(statearr_29025_29067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (21))){
var inst_28983 = (state_29017[(8)]);
var inst_28976 = (state_29017[(9)]);
var inst_28997 = (state_29017[(2)]);
var inst_28998 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28999 = cljs.core.PersistentHashMap.EMPTY;
var inst_29000 = [inst_28997,inst_28983,inst_28999];
var inst_29001 = cljs.core.PersistentHashMap.fromArrays(inst_28998,inst_29000);
var inst_29002 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28976,inst_29001);
var state_29017__$1 = state_29017;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29017__$1,(22),inst_29002);
} else {
if((state_val_29018 === (13))){
var inst_28971 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29017__$1 = state_29017;
var statearr_29026_29068 = state_29017__$1;
(statearr_29026_29068[(2)] = inst_28971);

(statearr_29026_29068[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (22))){
var inst_29004 = (state_29017[(2)]);
var inst_29005 = fluree.db.util.async.throw_err(inst_29004);
var inst_29006 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29005,(0),null);
var inst_29007 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29005,(1),null);
var inst_29008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29009 = [inst_29006,inst_29007];
var inst_29010 = (new cljs.core.PersistentVector(null,2,(5),inst_29008,inst_29009,null));
var state_29017__$1 = state_29017;
var statearr_29027_29069 = state_29017__$1;
(statearr_29027_29069[(2)] = inst_29010);

(statearr_29027_29069[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (6))){
var inst_28958 = (state_29017[(2)]);
var state_29017__$1 = state_29017;
var statearr_29028_29070 = state_29017__$1;
(statearr_29028_29070[(2)] = inst_28958);

(statearr_29028_29070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (17))){
var inst_28980 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28981 = fluree.db.dbfunctions.internal.get(inst_28980,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_29017__$1 = state_29017;
var statearr_29029_29071 = state_29017__$1;
(statearr_29029_29071[(2)] = inst_28981);

(statearr_29029_29071[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (3))){
var inst_29015 = (state_29017[(2)]);
var state_29017__$1 = state_29017;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29017__$1,inst_29015);
} else {
if((state_val_29018 === (12))){
var inst_28969 = (state_29017[(2)]);
var state_29017__$1 = state_29017;
if(cljs.core.truth_(inst_28969)){
var statearr_29030_29072 = state_29017__$1;
(statearr_29030_29072[(1)] = (13));

} else {
var statearr_29031_29073 = state_29017__$1;
(statearr_29031_29073[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (2))){
var inst_28964 = (state_29017[(10)]);
var _ = (function (){var statearr_29032 = state_29017;
(statearr_29032[(4)] = cljs.core.cons((9),(state_29017[(4)])));

return statearr_29032;
})();
var inst_28964__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29017__$1 = (function (){var statearr_29033 = state_29017;
(statearr_29033[(10)] = inst_28964__$1);

return statearr_29033;
})();
if(cljs.core.truth_(inst_28964__$1)){
var statearr_29034_29074 = state_29017__$1;
(statearr_29034_29074[(1)] = (10));

} else {
var statearr_29035_29075 = state_29017__$1;
(statearr_29035_29075[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (19))){
var inst_28985 = cljs.core.PersistentVector.EMPTY;
var inst_28986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28987 = ["*"];
var inst_28988 = (new cljs.core.PersistentVector(null,1,(5),inst_28986,inst_28987,null));
var inst_28989 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_28990 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_28988,inst_28989);
var inst_28991 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28985,inst_28990);
var state_29017__$1 = state_29017;
var statearr_29037_29076 = state_29017__$1;
(statearr_29037_29076[(2)] = inst_28991);

(statearr_29037_29076[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (11))){
var inst_28964 = (state_29017[(10)]);
var state_29017__$1 = state_29017;
var statearr_29038_29077 = state_29017__$1;
(statearr_29038_29077[(2)] = inst_28964);

(statearr_29038_29077[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (9))){
var _ = (function (){var statearr_29039 = state_29017;
(statearr_29039[(4)] = cljs.core.rest((state_29017[(4)])));

return statearr_29039;
})();
var state_29017__$1 = state_29017;
var ex29036 = (state_29017__$1[(2)]);
var statearr_29040_29078 = state_29017__$1;
(statearr_29040_29078[(5)] = ex29036);


var statearr_29041_29079 = state_29017__$1;
(statearr_29041_29079[(1)] = (4));

(statearr_29041_29079[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (5))){
var inst_28948 = (state_29017[(7)]);
var _ = (function (){var statearr_29042 = state_29017;
(statearr_29042[(4)] = cljs.core.cons((8),(state_29017[(4)])));

return statearr_29042;
})();
var inst_28955 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28948,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_29043 = state_29017;
(statearr_29043[(4)] = cljs.core.rest((state_29017[(4)])));

return statearr_29043;
})();
var state_29017__$1 = state_29017;
var statearr_29044_29080 = state_29017__$1;
(statearr_29044_29080[(2)] = inst_28955);

(statearr_29044_29080[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (14))){
var inst_28977 = (state_29017[(11)]);
var inst_28976 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28977__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29017__$1 = (function (){var statearr_29045 = state_29017;
(statearr_29045[(11)] = inst_28977__$1);

(statearr_29045[(9)] = inst_28976);

return statearr_29045;
})();
if(cljs.core.truth_(inst_28977__$1)){
var statearr_29046_29081 = state_29017__$1;
(statearr_29046_29081[(1)] = (16));

} else {
var statearr_29047_29082 = state_29017__$1;
(statearr_29047_29082[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (16))){
var inst_28977 = (state_29017[(11)]);
var state_29017__$1 = state_29017;
var statearr_29048_29083 = state_29017__$1;
(statearr_29048_29083[(2)] = inst_28977);

(statearr_29048_29083[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (10))){
var inst_28966 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_29017__$1 = state_29017;
var statearr_29050_29084 = state_29017__$1;
(statearr_29050_29084[(2)] = inst_28966);

(statearr_29050_29084[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (18))){
var inst_28983 = (state_29017[(2)]);
var state_29017__$1 = (function (){var statearr_29051 = state_29017;
(statearr_29051[(8)] = inst_28983);

return statearr_29051;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29052_29085 = state_29017__$1;
(statearr_29052_29085[(1)] = (19));

} else {
var statearr_29053_29086 = state_29017__$1;
(statearr_29053_29086[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (8))){
var _ = (function (){var statearr_29054 = state_29017;
(statearr_29054[(4)] = cljs.core.rest((state_29017[(4)])));

return statearr_29054;
})();
var state_29017__$1 = state_29017;
var ex29049 = (state_29017__$1[(2)]);
var statearr_29055_29087 = state_29017__$1;
(statearr_29055_29087[(5)] = ex29049);


var statearr_29056_29088 = state_29017__$1;
(statearr_29056_29088[(1)] = (7));

(statearr_29056_29088[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2733__auto____0 = (function (){
var statearr_29057 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29057[(0)] = fluree$db$dbfunctions$internal$state_machine__2733__auto__);

(statearr_29057[(1)] = (1));

return statearr_29057;
});
var fluree$db$dbfunctions$internal$state_machine__2733__auto____1 = (function (state_29017){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_29017);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e29058){var ex__2736__auto__ = e29058;
var statearr_29059_29089 = state_29017;
(statearr_29059_29089[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_29017[(4)]))){
var statearr_29060_29090 = state_29017;
(statearr_29060_29090[(1)] = cljs.core.first((state_29017[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29091 = state_29017;
state_29017 = G__29091;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2733__auto__ = function(state_29017){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____1.call(this,state_29017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_29061 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_29061[(6)] = c__2755__auto__);

return statearr_29061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__29093 = arguments.length;
switch (G__29093) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_29137){
var state_val_29138 = (state_29137[(1)]);
if((state_val_29138 === (7))){
var inst_29115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29116 = ["*"];
var inst_29117 = (new cljs.core.PersistentVector(null,1,(5),inst_29115,inst_29116,null));
var state_29137__$1 = state_29137;
var statearr_29139_29159 = state_29137__$1;
(statearr_29139_29159[(2)] = inst_29117);

(statearr_29139_29159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (1))){
var state_29137__$1 = state_29137;
var statearr_29140_29160 = state_29137__$1;
(statearr_29140_29160[(2)] = null);

(statearr_29140_29160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (4))){
var inst_29094 = (state_29137[(2)]);
var inst_29095 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29094,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_29137__$1 = state_29137;
var statearr_29141_29161 = state_29137__$1;
(statearr_29141_29161[(2)] = inst_29095);

(statearr_29141_29161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (6))){
var inst_29107 = cljs.core.PersistentVector.EMPTY;
var inst_29108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29109 = ["*"];
var inst_29110 = (new cljs.core.PersistentVector(null,1,(5),inst_29108,inst_29109,null));
var inst_29111 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29112 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29110,inst_29111);
var inst_29113 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29107,inst_29112);
var state_29137__$1 = state_29137;
var statearr_29142_29162 = state_29137__$1;
(statearr_29142_29162[(2)] = inst_29113);

(statearr_29142_29162[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (3))){
var inst_29135 = (state_29137[(2)]);
var state_29137__$1 = state_29137;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29137__$1,inst_29135);
} else {
if((state_val_29138 === (2))){
var _ = (function (){var statearr_29144 = state_29137;
(statearr_29144[(4)] = cljs.core.cons((5),(state_29137[(4)])));

return statearr_29144;
})();
var inst_29104 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29105 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29137__$1 = (function (){var statearr_29145 = state_29137;
(statearr_29145[(7)] = inst_29105);

(statearr_29145[(8)] = inst_29104);

return statearr_29145;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29146_29163 = state_29137__$1;
(statearr_29146_29163[(1)] = (6));

} else {
var statearr_29147_29164 = state_29137__$1;
(statearr_29147_29164[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (9))){
var inst_29126 = (state_29137[(2)]);
var inst_29127 = fluree.db.util.async.throw_err(inst_29126);
var inst_29128 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29127,(0),null);
var inst_29129 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29127,(1),null);
var inst_29130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29131 = [inst_29128,inst_29129];
var inst_29132 = (new cljs.core.PersistentVector(null,2,(5),inst_29130,inst_29131,null));
var _ = (function (){var statearr_29148 = state_29137;
(statearr_29148[(4)] = cljs.core.rest((state_29137[(4)])));

return statearr_29148;
})();
var state_29137__$1 = state_29137;
var statearr_29149_29165 = state_29137__$1;
(statearr_29149_29165[(2)] = inst_29132);

(statearr_29149_29165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (5))){
var _ = (function (){var statearr_29150 = state_29137;
(statearr_29150[(4)] = cljs.core.rest((state_29137[(4)])));

return statearr_29150;
})();
var state_29137__$1 = state_29137;
var ex29143 = (state_29137__$1[(2)]);
var statearr_29151_29166 = state_29137__$1;
(statearr_29151_29166[(5)] = ex29143);


var statearr_29152_29167 = state_29137__$1;
(statearr_29152_29167[(1)] = (4));

(statearr_29152_29167[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (8))){
var inst_29105 = (state_29137[(7)]);
var inst_29104 = (state_29137[(8)]);
var inst_29119 = (state_29137[(2)]);
var inst_29120 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29121 = cljs.core.PersistentHashMap.EMPTY;
var inst_29122 = [inst_29119,inst_29105,inst_29121];
var inst_29123 = cljs.core.PersistentHashMap.fromArrays(inst_29120,inst_29122);
var inst_29124 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29104,inst_29123);
var state_29137__$1 = state_29137;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29137__$1,(9),inst_29124);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2733__auto____0 = (function (){
var statearr_29153 = [null,null,null,null,null,null,null,null,null];
(statearr_29153[(0)] = fluree$db$dbfunctions$internal$state_machine__2733__auto__);

(statearr_29153[(1)] = (1));

return statearr_29153;
});
var fluree$db$dbfunctions$internal$state_machine__2733__auto____1 = (function (state_29137){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_29137);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e29154){var ex__2736__auto__ = e29154;
var statearr_29155_29168 = state_29137;
(statearr_29155_29168[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_29137[(4)]))){
var statearr_29156_29169 = state_29137;
(statearr_29156_29169[(1)] = cljs.core.first((state_29137[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29170 = state_29137;
state_29137 = G__29170;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2733__auto__ = function(state_29137){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____1.call(this,state_29137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_29157 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_29157[(6)] = c__2755__auto__);

return statearr_29157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_29214){
var state_val_29215 = (state_29214[(1)]);
if((state_val_29215 === (1))){
var state_29214__$1 = state_29214;
var statearr_29216_29230 = state_29214__$1;
(statearr_29216_29230[(2)] = null);

(statearr_29216_29230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29215 === (2))){
var _ = (function (){var statearr_29217 = state_29214;
(statearr_29217[(4)] = cljs.core.cons((5),(state_29214[(4)])));

return statearr_29217;
})();
var inst_29181 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29183 = ["_user/_auth"];
var inst_29184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29185 = ["*"];
var inst_29186 = (new cljs.core.PersistentVector(null,1,(5),inst_29184,inst_29185,null));
var inst_29187 = [inst_29186];
var inst_29188 = cljs.core.PersistentHashMap.fromArrays(inst_29183,inst_29187);
var inst_29189 = [inst_29188];
var inst_29190 = (new cljs.core.PersistentVector(null,1,(5),inst_29182,inst_29189,null));
var inst_29191 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29192 = cljs.core.PersistentHashMap.EMPTY;
var inst_29193 = [inst_29190,inst_29191,inst_29192];
var inst_29194 = cljs.core.PersistentHashMap.fromArrays(inst_29181,inst_29193);
var inst_29195 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29196 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29195,inst_29194);
var state_29214__$1 = state_29214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29214__$1,(6),inst_29196);
} else {
if((state_val_29215 === (3))){
var inst_29212 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29214__$1,inst_29212);
} else {
if((state_val_29215 === (4))){
var inst_29171 = (state_29214[(2)]);
var inst_29172 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29171,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_29214__$1 = state_29214;
var statearr_29219_29231 = state_29214__$1;
(statearr_29219_29231[(2)] = inst_29172);

(statearr_29219_29231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29215 === (5))){
var _ = (function (){var statearr_29220 = state_29214;
(statearr_29220[(4)] = cljs.core.rest((state_29214[(4)])));

return statearr_29220;
})();
var state_29214__$1 = state_29214;
var ex29218 = (state_29214__$1[(2)]);
var statearr_29221_29232 = state_29214__$1;
(statearr_29221_29232[(5)] = ex29218);


var statearr_29222_29233 = state_29214__$1;
(statearr_29222_29233[(1)] = (4));

(statearr_29222_29233[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29215 === (6))){
var inst_29198 = (state_29214[(2)]);
var inst_29199 = fluree.db.util.async.throw_err(inst_29198);
var inst_29200 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29199,(0),null);
var inst_29201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29199,(1),null);
var inst_29202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29203 = ["_user/_auth","_id"];
var inst_29204 = (new cljs.core.PersistentVector(null,2,(5),inst_29202,inst_29203,null));
var inst_29205 = fluree.db.dbfunctions.internal.get_in(inst_29200,inst_29204);
var inst_29206 = cljs.core.first(inst_29205);
var inst_29207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29208 = [inst_29206,inst_29201];
var inst_29209 = (new cljs.core.PersistentVector(null,2,(5),inst_29207,inst_29208,null));
var _ = (function (){var statearr_29223 = state_29214;
(statearr_29223[(4)] = cljs.core.rest((state_29214[(4)])));

return statearr_29223;
})();
var state_29214__$1 = state_29214;
var statearr_29224_29234 = state_29214__$1;
(statearr_29224_29234[(2)] = inst_29209);

(statearr_29224_29234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto____0 = (function (){
var statearr_29225 = [null,null,null,null,null,null,null];
(statearr_29225[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto__);

(statearr_29225[(1)] = (1));

return statearr_29225;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto____1 = (function (state_29214){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_29214);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e29226){var ex__2736__auto__ = e29226;
var statearr_29227_29235 = state_29214;
(statearr_29227_29235[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_29214[(4)]))){
var statearr_29228_29236 = state_29214;
(statearr_29228_29236[(1)] = cljs.core.first((state_29214[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29237 = state_29214;
state_29214 = G__29237;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto__ = function(state_29214){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto____1.call(this,state_29214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_29229 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_29229[(6)] = c__2755__auto__);

return statearr_29229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_29254){
var state_val_29255 = (state_29254[(1)]);
if((state_val_29255 === (1))){
var state_29254__$1 = state_29254;
var statearr_29256_29270 = state_29254__$1;
(statearr_29256_29270[(2)] = null);

(statearr_29256_29270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29255 === (2))){
var _ = (function (){var statearr_29257 = state_29254;
(statearr_29257[(4)] = cljs.core.cons((5),(state_29254[(4)])));

return statearr_29257;
})();
var inst_29244 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29245 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29246 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_29245,inst_29244);
var state_29254__$1 = state_29254;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29254__$1,(6),inst_29246);
} else {
if((state_val_29255 === (3))){
var inst_29252 = (state_29254[(2)]);
var state_29254__$1 = state_29254;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29254__$1,inst_29252);
} else {
if((state_val_29255 === (4))){
var inst_29238 = (state_29254[(2)]);
var state_29254__$1 = state_29254;
var statearr_29259_29271 = state_29254__$1;
(statearr_29259_29271[(2)] = inst_29238);

(statearr_29259_29271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29255 === (5))){
var _ = (function (){var statearr_29260 = state_29254;
(statearr_29260[(4)] = cljs.core.rest((state_29254[(4)])));

return statearr_29260;
})();
var state_29254__$1 = state_29254;
var ex29258 = (state_29254__$1[(2)]);
var statearr_29261_29272 = state_29254__$1;
(statearr_29261_29272[(5)] = ex29258);


if((ex29258 instanceof Error)){
var statearr_29262_29273 = state_29254__$1;
(statearr_29262_29273[(1)] = (4));

(statearr_29262_29273[(5)] = null);

} else {
throw ex29258;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29255 === (6))){
var inst_29248 = (state_29254[(2)]);
var inst_29249 = fluree.db.util.async.throw_err(inst_29248);
var _ = (function (){var statearr_29263 = state_29254;
(statearr_29263[(4)] = cljs.core.rest((state_29254[(4)])));

return statearr_29263;
})();
var state_29254__$1 = state_29254;
var statearr_29264_29274 = state_29254__$1;
(statearr_29264_29274[(2)] = inst_29249);

(statearr_29264_29274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto____0 = (function (){
var statearr_29265 = [null,null,null,null,null,null,null];
(statearr_29265[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto__);

(statearr_29265[(1)] = (1));

return statearr_29265;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto____1 = (function (state_29254){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_29254);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e29266){var ex__2736__auto__ = e29266;
var statearr_29267_29275 = state_29254;
(statearr_29267_29275[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_29254[(4)]))){
var statearr_29268_29276 = state_29254;
(statearr_29268_29276[(1)] = cljs.core.first((state_29254[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29277 = state_29254;
state_29254 = G__29277;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto__ = function(state_29254){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto____1.call(this,state_29254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_29269 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_29269[(6)] = c__2755__auto__);

return statearr_29269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__29278_SHARP_){
return p1__29278_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29279_SHARP_){
return p1__29279_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29280){var e = e29280;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__29281_SHARP_){
return p1__29281_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29282_SHARP_){
return p1__29282_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29283){var e = e29283;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__29285 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__29285);
})() | (0));
return num;
}catch (e29284){var e = e29284;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_29365){
var state_val_29366 = (state_29365[(1)]);
if((state_val_29366 === (7))){
var inst_29304 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29305 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29306 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29307 = cljs.core.PersistentHashMap.fromArrays(inst_29305,inst_29306);
var inst_29308 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29304,inst_29307);
var inst_29309 = (function(){throw inst_29308})();
var state_29365__$1 = state_29365;
var statearr_29367_29402 = state_29365__$1;
(statearr_29367_29402[(2)] = inst_29309);

(statearr_29367_29402[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (1))){
var state_29365__$1 = state_29365;
var statearr_29368_29403 = state_29365__$1;
(statearr_29368_29403[(2)] = null);

(statearr_29368_29403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (4))){
var inst_29286 = (state_29365[(2)]);
var state_29365__$1 = state_29365;
var statearr_29369_29404 = state_29365__$1;
(statearr_29369_29404[(2)] = inst_29286);

(statearr_29369_29404[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (15))){
var inst_29349 = (state_29365[(7)]);
var inst_29345 = (state_29365[(2)]);
var inst_29346 = fluree.db.util.async.throw_err(inst_29345);
var inst_29347 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29346,(0),null);
var inst_29348 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29346,(1),null);
var inst_29349__$1 = cljs.core.first(inst_29347);
var inst_29350 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29349__$1,compare_val);
var state_29365__$1 = (function (){var statearr_29370 = state_29365;
(statearr_29370[(8)] = inst_29348);

(statearr_29370[(7)] = inst_29349__$1);

return statearr_29370;
})();
if(inst_29350){
var statearr_29371_29405 = state_29365__$1;
(statearr_29371_29405[(1)] = (16));

} else {
var statearr_29372_29406 = state_29365__$1;
(statearr_29372_29406[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (13))){
var state_29365__$1 = state_29365;
var statearr_29373_29407 = state_29365__$1;
(statearr_29373_29407[(2)] = null);

(statearr_29373_29407[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (6))){
var state_29365__$1 = state_29365;
var statearr_29374_29408 = state_29365__$1;
(statearr_29374_29408[(2)] = null);

(statearr_29374_29408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (17))){
var inst_29349 = (state_29365[(7)]);
var inst_29353 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29349)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29354 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29355 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29356 = cljs.core.PersistentHashMap.fromArrays(inst_29354,inst_29355);
var inst_29357 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29353,inst_29356);
var inst_29358 = (function(){throw inst_29357})();
var state_29365__$1 = state_29365;
var statearr_29375_29409 = state_29365__$1;
(statearr_29375_29409[(2)] = inst_29358);

(statearr_29375_29409[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (3))){
var inst_29363 = (state_29365[(2)]);
var state_29365__$1 = state_29365;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29365__$1,inst_29363);
} else {
if((state_val_29366 === (12))){
var inst_29301 = (state_29365[(9)]);
var inst_29324 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_29301], 0));
var inst_29325 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29326 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29327 = cljs.core.PersistentHashMap.fromArrays(inst_29325,inst_29326);
var inst_29328 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29324,inst_29327);
var inst_29329 = (function(){throw inst_29328})();
var state_29365__$1 = state_29365;
var statearr_29376_29410 = state_29365__$1;
(statearr_29376_29410[(2)] = inst_29329);

(statearr_29376_29410[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (2))){
var inst_29299 = (state_29365[(10)]);
var inst_29298 = (state_29365[(11)]);
var inst_29300 = (state_29365[(12)]);
var _ = (function (){var statearr_29377 = state_29365;
(statearr_29377[(4)] = cljs.core.cons((5),(state_29365[(4)])));

return statearr_29377;
})();
var inst_29296 = _QMARK_ctx;
var inst_29297 = cljs.core.__destructure_map(inst_29296);
var inst_29298__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29297,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29299__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29297,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29300__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29297,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29301 = fluree.db.dbproto._p_prop(inst_29300__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29299__$1);
var state_29365__$1 = (function (){var statearr_29378 = state_29365;
(statearr_29378[(9)] = inst_29301);

(statearr_29378[(10)] = inst_29299__$1);

(statearr_29378[(11)] = inst_29298__$1);

(statearr_29378[(12)] = inst_29300__$1);

return statearr_29378;
})();
if(cljs.core.truth_(inst_29298__$1)){
var statearr_29379_29411 = state_29365__$1;
(statearr_29379_29411[(1)] = (6));

} else {
var statearr_29380_29412 = state_29365__$1;
(statearr_29380_29412[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (11))){
var inst_29299 = (state_29365[(10)]);
var inst_29300 = (state_29365[(12)]);
var inst_29321 = (state_29365[(2)]);
var inst_29322 = fluree.db.dbproto._p_prop(inst_29300,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29299);
var state_29365__$1 = (function (){var statearr_29382 = state_29365;
(statearr_29382[(13)] = inst_29321);

return statearr_29382;
})();
if(cljs.core.truth_(inst_29322)){
var statearr_29383_29413 = state_29365__$1;
(statearr_29383_29413[(1)] = (12));

} else {
var statearr_29384_29414 = state_29365__$1;
(statearr_29384_29414[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (9))){
var state_29365__$1 = state_29365;
var statearr_29385_29415 = state_29365__$1;
(statearr_29385_29415[(2)] = null);

(statearr_29385_29415[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (5))){
var _ = (function (){var statearr_29386 = state_29365;
(statearr_29386[(4)] = cljs.core.rest((state_29365[(4)])));

return statearr_29386;
})();
var state_29365__$1 = state_29365;
var ex29381 = (state_29365__$1[(2)]);
var statearr_29387_29416 = state_29365__$1;
(statearr_29387_29416[(5)] = ex29381);


if((ex29381 instanceof Error)){
var statearr_29388_29417 = state_29365__$1;
(statearr_29388_29417[(1)] = (4));

(statearr_29388_29417[(5)] = null);

} else {
throw ex29381;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (14))){
var inst_29301 = (state_29365[(9)]);
var inst_29298 = (state_29365[(11)]);
var inst_29300 = (state_29365[(12)]);
var inst_29332 = (state_29365[(2)]);
var inst_29333 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29334 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29336 = [inst_29298,inst_29301,"?current-val"];
var inst_29337 = (new cljs.core.PersistentVector(null,3,(5),inst_29335,inst_29336,null));
var inst_29338 = [inst_29337];
var inst_29339 = (new cljs.core.PersistentVector(null,1,(5),inst_29334,inst_29338,null));
var inst_29340 = cljs.core.PersistentHashMap.EMPTY;
var inst_29341 = ["?current-val",inst_29339,inst_29340];
var inst_29342 = cljs.core.PersistentHashMap.fromArrays(inst_29333,inst_29341);
var inst_29343 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29300,inst_29342);
var state_29365__$1 = (function (){var statearr_29389 = state_29365;
(statearr_29389[(14)] = inst_29332);

return statearr_29389;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29365__$1,(15),inst_29343);
} else {
if((state_val_29366 === (16))){
var state_29365__$1 = state_29365;
var statearr_29390_29418 = state_29365__$1;
(statearr_29390_29418[(2)] = new_val);

(statearr_29390_29418[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (10))){
var inst_29314 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29315 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29316 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29317 = cljs.core.PersistentHashMap.fromArrays(inst_29315,inst_29316);
var inst_29318 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29314,inst_29317);
var inst_29319 = (function(){throw inst_29318})();
var state_29365__$1 = state_29365;
var statearr_29391_29419 = state_29365__$1;
(statearr_29391_29419[(2)] = inst_29319);

(statearr_29391_29419[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (18))){
var inst_29360 = (state_29365[(2)]);
var _ = (function (){var statearr_29392 = state_29365;
(statearr_29392[(4)] = cljs.core.rest((state_29365[(4)])));

return statearr_29392;
})();
var state_29365__$1 = state_29365;
var statearr_29393_29420 = state_29365__$1;
(statearr_29393_29420[(2)] = inst_29360);

(statearr_29393_29420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29366 === (8))){
var inst_29301 = (state_29365[(9)]);
var inst_29311 = (state_29365[(2)]);
var state_29365__$1 = (function (){var statearr_29394 = state_29365;
(statearr_29394[(15)] = inst_29311);

return statearr_29394;
})();
if(cljs.core.truth_(inst_29301)){
var statearr_29395_29421 = state_29365__$1;
(statearr_29395_29421[(1)] = (9));

} else {
var statearr_29396_29422 = state_29365__$1;
(statearr_29396_29422[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto____0 = (function (){
var statearr_29397 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29397[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto__);

(statearr_29397[(1)] = (1));

return statearr_29397;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto____1 = (function (state_29365){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_29365);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e29398){var ex__2736__auto__ = e29398;
var statearr_29399_29423 = state_29365;
(statearr_29399_29423[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_29365[(4)]))){
var statearr_29400_29424 = state_29365;
(statearr_29400_29424[(1)] = cljs.core.first((state_29365[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29425 = state_29365;
state_29365 = G__29425;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto__ = function(state_29365){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto____1.call(this,state_29365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_29401 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_29401[(6)] = c__2755__auto__);

return statearr_29401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
