// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17059_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17059_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__17063 = coll;
var vec__17064 = G__17063;
var seq__17065 = cljs.core.seq(vec__17064);
var first__17066 = cljs.core.first(seq__17065);
var seq__17065__$1 = cljs.core.next(seq__17065);
var clause = first__17066;
var r = seq__17065__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__17063__$1 = G__17063;
var res__$1 = res;
while(true){
var vec__17070 = G__17063__$1;
var seq__17071 = cljs.core.seq(vec__17070);
var first__17072 = cljs.core.first(seq__17071);
var seq__17071__$1 = cljs.core.next(seq__17071);
var clause__$1 = first__17072;
var r__$1 = seq__17071__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__17073 = r__$1;
var G__17074 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__17063__$1 = G__17073;
res__$1 = G__17074;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__17075){
var map__17076 = p__17075;
var map__17076__$1 = cljs.core.__destructure_map(map__17076);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17076__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__17080 = coll;
var vec__17081 = G__17080;
var seq__17082 = cljs.core.seq(vec__17081);
var first__17083 = cljs.core.first(seq__17082);
var seq__17082__$1 = cljs.core.next(seq__17082);
var clause = first__17083;
var r = seq__17082__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__17080__$1 = G__17080;
var res__$1 = res;
while(true){
var vec__17087 = G__17080__$1;
var seq__17088 = cljs.core.seq(vec__17087);
var first__17089 = cljs.core.first(seq__17088);
var seq__17088__$1 = cljs.core.next(seq__17088);
var clause__$1 = first__17089;
var r__$1 = seq__17088__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__17090 = r__$1;
var G__17091 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__17080__$1 = G__17090;
res__$1 = G__17091;
continue;
} else {
var G__17092 = r__$1;
var G__17093 = res__$2;
G__17080__$1 = G__17092;
res__$1 = G__17093;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__17097 = coll;
var vec__17098 = G__17097;
var seq__17099 = cljs.core.seq(vec__17098);
var first__17100 = cljs.core.first(seq__17099);
var seq__17099__$1 = cljs.core.next(seq__17099);
var clause = first__17100;
var r = seq__17099__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__17097__$1 = G__17097;
var res__$1 = res;
while(true){
var vec__17104 = G__17097__$1;
var seq__17105 = cljs.core.seq(vec__17104);
var first__17106 = cljs.core.first(seq__17105);
var seq__17105__$1 = cljs.core.next(seq__17105);
var clause__$1 = first__17106;
var r__$1 = seq__17105__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__17107 = r__$1;
var G__17108 = res__$2;
G__17097__$1 = G__17107;
res__$1 = G__17108;
continue;
} else {
var G__17109 = r__$1;
var G__17110 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__17097__$1 = G__17109;
res__$1 = G__17110;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_((function (){var and__4221__auto__ = typeof string === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string);
} else {
return and__4221__auto__;
}
})())){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__17111 = clause;
var G__17111__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__17111):G__17111);
var G__17111__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,G__17111__$1)
;
var G__17111__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__17111__$2)
;
var G__17111__$4 = goog.string.format("%s .",G__17111__$3)
;
if(cljs.core.truth_(optional_QMARK_)){
return goog.string.format("OPTIONAL {%s}",G__17111__$4);
} else {
return G__17111__$4;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__17115 = opts;
var map__17115__$1 = cljs.core.__destructure_map(map__17115);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17115__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17115__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17115__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17115__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17115__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17112_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17112_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__17113_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__17113_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__17114_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__17114_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4223__auto__ = language;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17129){
var state_val_17130 = (state_17129[(1)]);
if((state_val_17130 === (1))){
var inst_17116 = fluree.db.util.core.url_encode(query);
var inst_17117 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17116)].join('');
var inst_17118 = ["User-Agent","Accept"];
var inst_17119 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_17120 = cljs.core.PersistentHashMap.fromArrays(inst_17118,inst_17119);
var inst_17121 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_17122 = [inst_17120,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_17123 = cljs.core.PersistentHashMap.fromArrays(inst_17121,inst_17122);
var inst_17124 = fluree.db.util.xhttp.get(inst_17117,inst_17123);
var state_17129__$1 = state_17129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17129__$1,(2),inst_17124);
} else {
if((state_val_17130 === (2))){
var inst_17126 = (state_17129[(2)]);
var inst_17127 = fluree.db.util.async.throw_err(inst_17126);
var state_17129__$1 = state_17129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17129__$1,inst_17127);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto____0 = (function (){
var statearr_17131 = [null,null,null,null,null,null,null];
(statearr_17131[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto__);

(statearr_17131[(1)] = (1));

return statearr_17131;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto____1 = (function (state_17129){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17129);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17132){var ex__2736__auto__ = e17132;
var statearr_17133_17136 = state_17129;
(statearr_17133_17136[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17129[(4)]))){
var statearr_17134_17137 = state_17129;
(statearr_17134_17137[(1)] = cljs.core.first((state_17129[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17138 = state_17129;
state_17129 = G__17138;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto__ = function(state_17129){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto____1.call(this,state_17129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17135 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17135[(6)] = c__2755__auto__);

return statearr_17135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17156){
var state_val_17157 = (state_17156[(1)]);
if((state_val_17157 === (1))){
var inst_17139 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_17156__$1 = state_17156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17156__$1,(2),inst_17139);
} else {
if((state_val_17157 === (2))){
var inst_17142 = (state_17156[(7)]);
var inst_17141 = (state_17156[(2)]);
var inst_17142__$1 = fluree.db.util.async.throw_err(inst_17141);
var inst_17143 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_17142__$1);
var inst_17144 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_17143);
var state_17156__$1 = (function (){var statearr_17158 = state_17156;
(statearr_17158[(7)] = inst_17142__$1);

return statearr_17158;
})();
if(inst_17144){
var statearr_17159_17168 = state_17156__$1;
(statearr_17159_17168[(1)] = (3));

} else {
var statearr_17160_17169 = state_17156__$1;
(statearr_17160_17169[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17157 === (3))){
var inst_17142 = (state_17156[(7)]);
var state_17156__$1 = state_17156;
var statearr_17161_17170 = state_17156__$1;
(statearr_17161_17170[(2)] = inst_17142);

(statearr_17161_17170[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17157 === (4))){
var inst_17142 = (state_17156[(7)]);
var inst_17147 = (function (){var body = inst_17142;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_17148 = cljs.core.second(inst_17142);
var inst_17149 = cljs.core.second(inst_17148);
var inst_17150 = cljs.core.first(inst_17149);
var inst_17151 = cljs.core.second(inst_17150);
var inst_17152 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_17147,inst_17151);
var state_17156__$1 = state_17156;
var statearr_17162_17171 = state_17156__$1;
(statearr_17162_17171[(2)] = inst_17152);

(statearr_17162_17171[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17157 === (5))){
var inst_17154 = (state_17156[(2)]);
var state_17156__$1 = state_17156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17156__$1,inst_17154);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto____0 = (function (){
var statearr_17163 = [null,null,null,null,null,null,null,null];
(statearr_17163[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto__);

(statearr_17163[(1)] = (1));

return statearr_17163;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto____1 = (function (state_17156){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17156);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17164){var ex__2736__auto__ = e17164;
var statearr_17165_17172 = state_17156;
(statearr_17165_17172[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17156[(4)]))){
var statearr_17166_17173 = state_17156;
(statearr_17166_17173[(1)] = cljs.core.first((state_17156[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17174 = state_17156;
state_17156 = G__17174;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto__ = function(state_17156){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto____1.call(this,state_17156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17167 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17167[(6)] = c__2755__auto__);

return statearr_17167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17175_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17175_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17176_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17176_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17177_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__17177_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17177_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__17177_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17223){
var state_val_17224 = (state_17223[(1)]);
if((state_val_17224 === (7))){
var inst_17188 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_17223__$1 = state_17223;
var statearr_17225_17253 = state_17223__$1;
(statearr_17225_17253[(2)] = inst_17188);

(statearr_17225_17253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (1))){
var state_17223__$1 = state_17223;
var statearr_17226_17254 = state_17223__$1;
(statearr_17226_17254[(2)] = null);

(statearr_17226_17254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (4))){
var inst_17178 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
var statearr_17227_17255 = state_17223__$1;
(statearr_17227_17255[(2)] = inst_17178);

(statearr_17227_17255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (15))){
var inst_17197 = (state_17223[(7)]);
var inst_17196 = (state_17223[(8)]);
var inst_17202 = (state_17223[(9)]);
var inst_17207 = (state_17223[(2)]);
var inst_17208 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_17202,(0),inst_17207);
var inst_17209 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17210 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_17196);
var inst_17211 = [inst_17197,inst_17210];
var inst_17212 = cljs.core.PersistentHashMap.fromArrays(inst_17209,inst_17211);
var inst_17213 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17208,inst_17212);
var inst_17214 = (function(){throw inst_17213})();
var state_17223__$1 = state_17223;
var statearr_17228_17256 = state_17223__$1;
(statearr_17228_17256[(2)] = inst_17214);

(statearr_17228_17256[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (13))){
var inst_17201 = (state_17223[(10)]);
var state_17223__$1 = state_17223;
var statearr_17229_17257 = state_17223__$1;
(statearr_17229_17257[(2)] = inst_17201);

(statearr_17229_17257[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (6))){
var state_17223__$1 = state_17223;
var statearr_17230_17258 = state_17223__$1;
(statearr_17230_17258[(2)] = null);

(statearr_17230_17258[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (3))){
var inst_17221 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17223__$1,inst_17221);
} else {
if((state_val_17224 === (12))){
var inst_17218 = (state_17223[(2)]);
var _ = (function (){var statearr_17231 = state_17223;
(statearr_17231[(4)] = cljs.core.rest((state_17223[(4)])));

return statearr_17231;
})();
var state_17223__$1 = state_17223;
var statearr_17232_17259 = state_17223__$1;
(statearr_17232_17259[(2)] = inst_17218);

(statearr_17232_17259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (2))){
var _ = (function (){var statearr_17233 = state_17223;
(statearr_17233[(4)] = cljs.core.cons((5),(state_17223[(4)])));

return statearr_17233;
})();
var inst_17185 = cljs.core.empty_QMARK_(matching_vars);
var state_17223__$1 = state_17223;
if(inst_17185){
var statearr_17234_17260 = state_17223__$1;
(statearr_17234_17260[(1)] = (6));

} else {
var statearr_17235_17261 = state_17223__$1;
(statearr_17235_17261[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (11))){
var inst_17196 = (state_17223[(8)]);
var inst_17216 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_17196,all_vars);
var state_17223__$1 = state_17223;
var statearr_17237_17262 = state_17223__$1;
(statearr_17237_17262[(2)] = inst_17216);

(statearr_17237_17262[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (9))){
var inst_17197 = (state_17223[(7)]);
var inst_17196 = (state_17223[(8)]);
var inst_17194 = (state_17223[(2)]);
var inst_17195 = fluree.db.util.async.throw_err(inst_17194);
var inst_17196__$1 = cljs.core.__destructure_map(inst_17195);
var inst_17197__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17196__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_17198 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17196__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_17199 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_17197__$1);
var state_17223__$1 = (function (){var statearr_17238 = state_17223;
(statearr_17238[(7)] = inst_17197__$1);

(statearr_17238[(8)] = inst_17196__$1);

(statearr_17238[(11)] = inst_17198);

return statearr_17238;
})();
if(inst_17199){
var statearr_17239_17263 = state_17223__$1;
(statearr_17239_17263[(1)] = (10));

} else {
var statearr_17240_17264 = state_17223__$1;
(statearr_17240_17264[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (5))){
var _ = (function (){var statearr_17241 = state_17223;
(statearr_17241[(4)] = cljs.core.rest((state_17223[(4)])));

return statearr_17241;
})();
var state_17223__$1 = state_17223;
var ex17236 = (state_17223__$1[(2)]);
var statearr_17242_17265 = state_17223__$1;
(statearr_17242_17265[(5)] = ex17236);


if((ex17236 instanceof Error)){
var statearr_17243_17266 = state_17223__$1;
(statearr_17243_17266[(1)] = (4));

(statearr_17243_17266[(5)] = null);

} else {
throw ex17236;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (14))){
var state_17223__$1 = state_17223;
var statearr_17244_17267 = state_17223__$1;
(statearr_17244_17267[(2)] = (1000));

(statearr_17244_17267[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (10))){
var inst_17196 = (state_17223[(8)]);
var inst_17198 = (state_17223[(11)]);
var inst_17201 = (state_17223[(10)]);
var inst_17201__$1 = cljs.core.count(inst_17198);
var inst_17202 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_17196);
var inst_17203 = (inst_17201__$1 < (1000));
var state_17223__$1 = (function (){var statearr_17245 = state_17223;
(statearr_17245[(10)] = inst_17201__$1);

(statearr_17245[(9)] = inst_17202);

return statearr_17245;
})();
if(cljs.core.truth_(inst_17203)){
var statearr_17246_17268 = state_17223__$1;
(statearr_17246_17268[(1)] = (13));

} else {
var statearr_17247_17269 = state_17223__$1;
(statearr_17247_17269[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (8))){
var inst_17190 = (state_17223[(2)]);
var inst_17191 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_17190,optional_clauses);
var inst_17192 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_17191);
var state_17223__$1 = state_17223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17223__$1,(9),inst_17192);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto____0 = (function (){
var statearr_17248 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17248[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto__);

(statearr_17248[(1)] = (1));

return statearr_17248;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto____1 = (function (state_17223){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17223);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17249){var ex__2736__auto__ = e17249;
var statearr_17250_17270 = state_17223;
(statearr_17250_17270[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17223[(4)]))){
var statearr_17251_17271 = state_17223;
(statearr_17251_17271[(1)] = cljs.core.first((state_17223[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17272 = state_17223;
state_17223 = G__17272;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto__ = function(state_17223){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto____1.call(this,state_17223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17252 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17252[(6)] = c__2755__auto__);

return statearr_17252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
