// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_19073){
var state_val_19074 = (state_19073[(1)]);
if((state_val_19074 === (1))){
var state_19073__$1 = state_19073;
var statearr_19075_19089 = state_19073__$1;
(statearr_19075_19089[(2)] = null);

(statearr_19075_19089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19074 === (2))){
var _ = (function (){var statearr_19076 = state_19073;
(statearr_19076[(4)] = cljs.core.cons((5),(state_19073[(4)])));

return statearr_19076;
})();
var inst_19064 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_19073__$1 = state_19073;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19073__$1,(6),inst_19064);
} else {
if((state_val_19074 === (3))){
var inst_19071 = (state_19073[(2)]);
var state_19073__$1 = state_19073;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19073__$1,inst_19071);
} else {
if((state_val_19074 === (4))){
var inst_19058 = (state_19073[(2)]);
var state_19073__$1 = state_19073;
var statearr_19078_19090 = state_19073__$1;
(statearr_19078_19090[(2)] = inst_19058);

(statearr_19078_19090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19074 === (5))){
var _ = (function (){var statearr_19079 = state_19073;
(statearr_19079[(4)] = cljs.core.rest((state_19073[(4)])));

return statearr_19079;
})();
var state_19073__$1 = state_19073;
var ex19077 = (state_19073__$1[(2)]);
var statearr_19080_19091 = state_19073__$1;
(statearr_19080_19091[(5)] = ex19077);


if((ex19077 instanceof Error)){
var statearr_19081_19092 = state_19073__$1;
(statearr_19081_19092[(1)] = (4));

(statearr_19081_19092[(5)] = null);

} else {
throw ex19077;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19074 === (6))){
var inst_19066 = (state_19073[(2)]);
var inst_19067 = fluree.db.util.async.throw_err(inst_19066);
var inst_19068 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_19067);
var _ = (function (){var statearr_19082 = state_19073;
(statearr_19082[(4)] = cljs.core.rest((state_19073[(4)])));

return statearr_19082;
})();
var state_19073__$1 = state_19073;
var statearr_19083_19093 = state_19073__$1;
(statearr_19083_19093[(2)] = inst_19068);

(statearr_19083_19093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto____0 = (function (){
var statearr_19084 = [null,null,null,null,null,null,null];
(statearr_19084[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto__);

(statearr_19084[(1)] = (1));

return statearr_19084;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto____1 = (function (state_19073){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_19073);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e19085){var ex__2736__auto__ = e19085;
var statearr_19086_19094 = state_19073;
(statearr_19086_19094[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_19073[(4)]))){
var statearr_19087_19095 = state_19073;
(statearr_19087_19095[(1)] = cljs.core.first((state_19073[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19096 = state_19073;
state_19073 = G__19096;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto__ = function(state_19073){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto____1.call(this,state_19073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_19088 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_19088[(6)] = c__2755__auto__);

return statearr_19088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_19128){
var state_val_19129 = (state_19128[(1)]);
if((state_val_19129 === (7))){
var inst_19112 = (state_19128[(7)]);
var inst_19114 = cljs.core.empty_QMARK_(inst_19112);
var inst_19115 = (!(inst_19114));
var state_19128__$1 = state_19128;
var statearr_19130_19154 = state_19128__$1;
(statearr_19130_19154[(2)] = inst_19115);

(statearr_19130_19154[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19129 === (1))){
var state_19128__$1 = state_19128;
var statearr_19131_19155 = state_19128__$1;
(statearr_19131_19155[(2)] = null);

(statearr_19131_19155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19129 === (4))){
var inst_19098 = (state_19128[(2)]);
var state_19128__$1 = state_19128;
var statearr_19132_19156 = state_19128__$1;
(statearr_19132_19156[(2)] = inst_19098);

(statearr_19132_19156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19129 === (6))){
var inst_19112 = (state_19128[(7)]);
var inst_19104 = (state_19128[(8)]);
var inst_19110 = (state_19128[(2)]);
var inst_19111 = fluree.db.util.async.throw_err(inst_19110);
var inst_19112__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_19104,inst_19111);
var state_19128__$1 = (function (){var statearr_19133 = state_19128;
(statearr_19133[(7)] = inst_19112__$1);

return statearr_19133;
})();
if(cljs.core.truth_(inst_19112__$1)){
var statearr_19134_19157 = state_19128__$1;
(statearr_19134_19157[(1)] = (7));

} else {
var statearr_19135_19158 = state_19128__$1;
(statearr_19135_19158[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19129 === (3))){
var inst_19126 = (state_19128[(2)]);
var state_19128__$1 = state_19128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19128__$1,inst_19126);
} else {
if((state_val_19129 === (12))){
var inst_19123 = (state_19128[(2)]);
var _ = (function (){var statearr_19136 = state_19128;
(statearr_19136[(4)] = cljs.core.rest((state_19128[(4)])));

return statearr_19136;
})();
var state_19128__$1 = state_19128;
var statearr_19137_19159 = state_19128__$1;
(statearr_19137_19159[(2)] = inst_19123);

(statearr_19137_19159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19129 === (2))){
var _ = (function (){var statearr_19138 = state_19128;
(statearr_19138[(4)] = cljs.core.cons((5),(state_19128[(4)])));

return statearr_19138;
})();
var inst_19104 = (function (){return (function (p1__19097_SHARP_){
return p1__19097_SHARP_.o;
});
})();
var inst_19105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19106 = [pred_id];
var inst_19107 = (new cljs.core.PersistentVector(null,1,(5),inst_19105,inst_19106,null));
var inst_19108 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_19107);
var state_19128__$1 = (function (){var statearr_19139 = state_19128;
(statearr_19139[(8)] = inst_19104);

return statearr_19139;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19128__$1,(6),inst_19108);
} else {
if((state_val_19129 === (11))){
var state_19128__$1 = state_19128;
var statearr_19141_19160 = state_19128__$1;
(statearr_19141_19160[(2)] = true);

(statearr_19141_19160[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19129 === (9))){
var inst_19118 = (state_19128[(2)]);
var state_19128__$1 = state_19128;
if(cljs.core.truth_(inst_19118)){
var statearr_19142_19161 = state_19128__$1;
(statearr_19142_19161[(1)] = (10));

} else {
var statearr_19143_19162 = state_19128__$1;
(statearr_19143_19162[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19129 === (5))){
var _ = (function (){var statearr_19144 = state_19128;
(statearr_19144[(4)] = cljs.core.rest((state_19128[(4)])));

return statearr_19144;
})();
var state_19128__$1 = state_19128;
var ex19140 = (state_19128__$1[(2)]);
var statearr_19145_19163 = state_19128__$1;
(statearr_19145_19163[(5)] = ex19140);


if((ex19140 instanceof Error)){
var statearr_19146_19164 = state_19128__$1;
(statearr_19146_19164[(1)] = (4));

(statearr_19146_19164[(5)] = null);

} else {
throw ex19140;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19129 === (10))){
var inst_19112 = (state_19128[(7)]);
var inst_19120 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_19112);
var state_19128__$1 = state_19128;
var statearr_19147_19165 = state_19128__$1;
(statearr_19147_19165[(2)] = inst_19120);

(statearr_19147_19165[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19129 === (8))){
var inst_19112 = (state_19128[(7)]);
var state_19128__$1 = state_19128;
var statearr_19148_19166 = state_19128__$1;
(statearr_19148_19166[(2)] = inst_19112);

(statearr_19148_19166[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_19149 = [null,null,null,null,null,null,null,null,null];
(statearr_19149[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto__);

(statearr_19149[(1)] = (1));

return statearr_19149;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto____1 = (function (state_19128){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_19128);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e19150){var ex__2736__auto__ = e19150;
var statearr_19151_19167 = state_19128;
(statearr_19151_19167[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_19128[(4)]))){
var statearr_19152_19168 = state_19128;
(statearr_19152_19168[(1)] = cljs.core.first((state_19128[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19169 = state_19128;
state_19128 = G__19169;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto__ = function(state_19128){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto____1.call(this,state_19128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_19153 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_19153[(6)] = c__2755__auto__);

return statearr_19153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_19250){
var state_val_19251 = (state_19250[(1)]);
if((state_val_19251 === (7))){
var state_19250__$1 = state_19250;
var statearr_19252_19290 = state_19250__$1;
(statearr_19252_19290[(2)] = flakes);

(statearr_19252_19290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (20))){
var inst_19207 = (state_19250[(7)]);
var inst_19240 = (state_19250[(2)]);
var inst_19199 = inst_19207;
var inst_19200 = inst_19240;
var state_19250__$1 = (function (){var statearr_19253 = state_19250;
(statearr_19253[(8)] = inst_19199);

(statearr_19253[(9)] = inst_19200);

return statearr_19253;
})();
var statearr_19254_19291 = state_19250__$1;
(statearr_19254_19291[(2)] = null);

(statearr_19254_19291[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (1))){
var state_19250__$1 = state_19250;
var statearr_19255_19292 = state_19250__$1;
(statearr_19255_19292[(2)] = null);

(statearr_19255_19292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (4))){
var inst_19172 = (state_19250[(2)]);
var state_19250__$1 = state_19250;
var statearr_19256_19293 = state_19250__$1;
(statearr_19256_19293[(2)] = inst_19172);

(statearr_19256_19293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (15))){
var inst_19206 = (state_19250[(10)]);
var inst_19224 = inst_19206.o;
var state_19250__$1 = state_19250;
var statearr_19257_19294 = state_19250__$1;
(statearr_19257_19294[(2)] = inst_19224);

(statearr_19257_19294[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (13))){
var inst_19243 = (state_19250[(2)]);
var state_19250__$1 = state_19250;
var statearr_19258_19295 = state_19250__$1;
(statearr_19258_19295[(2)] = inst_19243);

(statearr_19258_19295[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (6))){
var inst_19179 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_19250__$1 = state_19250;
var statearr_19259_19296 = state_19250__$1;
(statearr_19259_19296[(2)] = inst_19179);

(statearr_19259_19296[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (17))){
var inst_19221 = (state_19250[(2)]);
var inst_19222 = fluree.db.util.async.throw_err(inst_19221);
var state_19250__$1 = state_19250;
var statearr_19260_19297 = state_19250__$1;
(statearr_19260_19297[(2)] = inst_19222);

(statearr_19260_19297[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (3))){
var inst_19248 = (state_19250[(2)]);
var state_19250__$1 = state_19250;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19250__$1,inst_19248);
} else {
if((state_val_19251 === (12))){
var inst_19213 = (state_19250[(11)]);
var inst_19206 = (state_19250[(10)]);
var inst_19211 = inst_19206.p;
var inst_19212 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_19211);
var inst_19213__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_19212);
var inst_19214 = inst_19206.op;
var inst_19215 = inst_19214 === false;
var inst_19216 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_19213__$1);
var state_19250__$1 = (function (){var statearr_19261 = state_19250;
(statearr_19261[(11)] = inst_19213__$1);

(statearr_19261[(12)] = inst_19215);

return statearr_19261;
})();
if(inst_19216){
var statearr_19262_19298 = state_19250__$1;
(statearr_19262_19298[(1)] = (14));

} else {
var statearr_19263_19299 = state_19250__$1;
(statearr_19263_19299[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (2))){
var _ = (function (){var statearr_19264 = state_19250;
(statearr_19264[(4)] = cljs.core.cons((5),(state_19250[(4)])));

return statearr_19264;
})();
var state_19250__$1 = state_19250;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_19265_19300 = state_19250__$1;
(statearr_19265_19300[(1)] = (6));

} else {
var statearr_19266_19301 = state_19250__$1;
(statearr_19266_19301[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (19))){
var inst_19226 = (state_19250[(13)]);
var inst_19213 = (state_19250[(11)]);
var inst_19206 = (state_19250[(10)]);
var inst_19200 = (state_19250[(9)]);
var inst_19234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19235 = inst_19206.s;
var inst_19236 = [inst_19235,inst_19213,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_19237 = (new cljs.core.PersistentVector(null,3,(5),inst_19234,inst_19236,null));
var inst_19238 = cljs.core.assoc_in(inst_19200,inst_19237,inst_19226);
var state_19250__$1 = state_19250;
var statearr_19267_19302 = state_19250__$1;
(statearr_19267_19302[(2)] = inst_19238);

(statearr_19267_19302[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (11))){
var inst_19200 = (state_19250[(9)]);
var state_19250__$1 = state_19250;
var statearr_19269_19303 = state_19250__$1;
(statearr_19269_19303[(2)] = inst_19200);

(statearr_19269_19303[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (9))){
var inst_19199 = (state_19250[(8)]);
var inst_19206 = (state_19250[(10)]);
var inst_19205 = cljs.core.seq(inst_19199);
var inst_19206__$1 = cljs.core.first(inst_19205);
var inst_19207 = cljs.core.next(inst_19205);
var inst_19208 = cljs.core.not(inst_19206__$1);
var state_19250__$1 = (function (){var statearr_19270 = state_19250;
(statearr_19270[(7)] = inst_19207);

(statearr_19270[(10)] = inst_19206__$1);

return statearr_19270;
})();
if(inst_19208){
var statearr_19271_19304 = state_19250__$1;
(statearr_19271_19304[(1)] = (11));

} else {
var statearr_19272_19305 = state_19250__$1;
(statearr_19272_19305[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (5))){
var _ = (function (){var statearr_19273 = state_19250;
(statearr_19273[(4)] = cljs.core.rest((state_19250[(4)])));

return statearr_19273;
})();
var state_19250__$1 = state_19250;
var ex19268 = (state_19250__$1[(2)]);
var statearr_19274_19306 = state_19250__$1;
(statearr_19274_19306[(5)] = ex19268);


if((ex19268 instanceof Error)){
var statearr_19275_19307 = state_19250__$1;
(statearr_19275_19307[(1)] = (4));

(statearr_19275_19307[(5)] = null);

} else {
throw ex19268;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (14))){
var inst_19206 = (state_19250[(10)]);
var inst_19218 = inst_19206.o;
var inst_19219 = fluree.db.query.schema.convert_type_to_kw(inst_19218,db);
var state_19250__$1 = state_19250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19250__$1,(17),inst_19219);
} else {
if((state_val_19251 === (16))){
var inst_19215 = (state_19250[(12)]);
var inst_19226 = (state_19250[(2)]);
var state_19250__$1 = (function (){var statearr_19276 = state_19250;
(statearr_19276[(13)] = inst_19226);

return statearr_19276;
})();
if(cljs.core.truth_(inst_19215)){
var statearr_19277_19308 = state_19250__$1;
(statearr_19277_19308[(1)] = (18));

} else {
var statearr_19278_19309 = state_19250__$1;
(statearr_19278_19309[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (10))){
var inst_19245 = (state_19250[(2)]);
var _ = (function (){var statearr_19279 = state_19250;
(statearr_19279[(4)] = cljs.core.rest((state_19250[(4)])));

return statearr_19279;
})();
var state_19250__$1 = state_19250;
var statearr_19280_19310 = state_19250__$1;
(statearr_19280_19310[(2)] = inst_19245);

(statearr_19280_19310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (18))){
var inst_19226 = (state_19250[(13)]);
var inst_19213 = (state_19250[(11)]);
var inst_19206 = (state_19250[(10)]);
var inst_19200 = (state_19250[(9)]);
var inst_19228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19229 = inst_19206.s;
var inst_19230 = [inst_19229,inst_19213,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_19231 = (new cljs.core.PersistentVector(null,3,(5),inst_19228,inst_19230,null));
var inst_19232 = cljs.core.assoc_in(inst_19200,inst_19231,inst_19226);
var state_19250__$1 = state_19250;
var statearr_19281_19311 = state_19250__$1;
(statearr_19281_19311[(2)] = inst_19232);

(statearr_19281_19311[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19251 === (8))){
var inst_19182 = (state_19250[(2)]);
var inst_19183 = cljs.core.PersistentHashSet.EMPTY;
var inst_19184 = cljs.core.vals(tempids);
var inst_19185 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_19183,inst_19184);
var inst_19186 = (function (){var pred_flakes = inst_19182;
var is_new_QMARK_ = inst_19185;
return (function (p1__19170_SHARP_,p2__19171_SHARP_){
return cljs.core.assoc_in(p1__19170_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__19171_SHARP_.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__19282 = p2__19171_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__19282) : is_new_QMARK_.call(null,G__19282));
})()));
});
})();
var inst_19187 = cljs.core.PersistentHashMap.EMPTY;
var inst_19188 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_19186,inst_19187,inst_19182);
var inst_19196 = cljs.core.seq(inst_19182);
var inst_19197 = cljs.core.first(inst_19196);
var inst_19198 = cljs.core.next(inst_19196);
var inst_19199 = inst_19182;
var inst_19200 = inst_19188;
var state_19250__$1 = (function (){var statearr_19283 = state_19250;
(statearr_19283[(14)] = inst_19197);

(statearr_19283[(15)] = inst_19198);

(statearr_19283[(8)] = inst_19199);

(statearr_19283[(9)] = inst_19200);

return statearr_19283;
})();
var statearr_19284_19312 = state_19250__$1;
(statearr_19284_19312[(2)] = null);

(statearr_19284_19312[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto____0 = (function (){
var statearr_19285 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19285[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto__);

(statearr_19285[(1)] = (1));

return statearr_19285;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto____1 = (function (state_19250){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_19250);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e19286){var ex__2736__auto__ = e19286;
var statearr_19287_19313 = state_19250;
(statearr_19287_19313[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_19250[(4)]))){
var statearr_19288_19314 = state_19250;
(statearr_19288_19314[(1)] = cljs.core.first((state_19250[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19315 = state_19250;
state_19250 = G__19315;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto__ = function(state_19250){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto____1.call(this,state_19250);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_19289 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_19289[(6)] = c__2755__auto__);

return statearr_19289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__19317 = arguments.length;
switch (G__19317) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__19320 = arguments.length;
switch (G__19320) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_19632){
var state_val_19633 = (state_19632[(1)]);
if((state_val_19633 === (121))){
var inst_19587 = (state_19632[(7)]);
var state_19632__$1 = state_19632;
var statearr_19634_19827 = state_19632__$1;
(statearr_19634_19827[(2)] = inst_19587);

(statearr_19634_19827[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (65))){
var inst_19486 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19486)){
var statearr_19635_19828 = state_19632__$1;
(statearr_19635_19828[(1)] = (66));

} else {
var statearr_19636_19829 = state_19632__$1;
(statearr_19636_19829[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (70))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19496 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_19497 = (inst_19492.cljs$core$IFn$_invoke$arity$5 ? inst_19492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_19496,null) : inst_19492.call(null,cljs.core.PersistentArrayMap,null,3,inst_19496,null));
var inst_19498 = (inst_19492.cljs$core$IFn$_invoke$arity$4 ? inst_19492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19497,null) : inst_19492.call(null,cljs.core.PersistentHashSet,null,inst_19497,null));
var inst_19499 = (inst_19498.cljs$core$IFn$_invoke$arity$1 ? inst_19498.cljs$core$IFn$_invoke$arity$1(inst_19491) : inst_19498.call(null,inst_19491));
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19499)){
var statearr_19637_19830 = state_19632__$1;
(statearr_19637_19830[(1)] = (72));

} else {
var statearr_19638_19831 = state_19632__$1;
(statearr_19638_19831[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (62))){
var inst_19476 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19639_19832 = state_19632__$1;
(statearr_19639_19832[(2)] = inst_19476);

(statearr_19639_19832[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (74))){
var inst_19582 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19640_19833 = state_19632__$1;
(statearr_19640_19833[(2)] = inst_19582);

(statearr_19640_19833[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (110))){
var inst_19609 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19609)){
var statearr_19641_19834 = state_19632__$1;
(statearr_19641_19834[(1)] = (117));

} else {
var statearr_19642_19835 = state_19632__$1;
(statearr_19642_19835[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (7))){
var inst_19627 = (state_19632[(2)]);
var _ = (function (){var statearr_19643 = state_19632;
(statearr_19643[(4)] = cljs.core.rest((state_19632[(4)])));

return statearr_19643;
})();
var state_19632__$1 = state_19632;
var statearr_19644_19836 = state_19632__$1;
(statearr_19644_19836[(2)] = inst_19627);

(statearr_19644_19836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (59))){
var inst_19480 = (state_19632[(10)]);
var inst_19360 = (state_19632[(11)]);
var inst_19479 = (state_19632[(2)]);
var inst_19480__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19360);
var state_19632__$1 = (function (){var statearr_19645 = state_19632;
(statearr_19645[(10)] = inst_19480__$1);

(statearr_19645[(12)] = inst_19479);

return statearr_19645;
})();
if(cljs.core.truth_(inst_19480__$1)){
var statearr_19646_19837 = state_19632__$1;
(statearr_19646_19837[(1)] = (63));

} else {
var statearr_19647_19838 = state_19632__$1;
(statearr_19647_19838[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (86))){
var inst_19522 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19648_19839 = state_19632__$1;
(statearr_19648_19839[(2)] = inst_19522);

(statearr_19648_19839[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (20))){
var inst_19386 = (state_19632[(13)]);
var inst_19360 = (state_19632[(11)]);
var inst_19386__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19360);
var state_19632__$1 = (function (){var statearr_19649 = state_19632;
(statearr_19649[(13)] = inst_19386__$1);

return statearr_19649;
})();
if(cljs.core.truth_(inst_19386__$1)){
var statearr_19650_19840 = state_19632__$1;
(statearr_19650_19840[(1)] = (23));

} else {
var statearr_19651_19841 = state_19632__$1;
(statearr_19651_19841[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (72))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19501 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19491,inst_19492,throw_QMARK_);
var state_19632__$1 = state_19632;
var statearr_19652_19842 = state_19632__$1;
(statearr_19652_19842[(2)] = inst_19501);

(statearr_19652_19842[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (58))){
var inst_19441 = (state_19632[(14)]);
var state_19632__$1 = state_19632;
var statearr_19653_19843 = state_19632__$1;
(statearr_19653_19843[(2)] = inst_19441);

(statearr_19653_19843[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (60))){
var inst_19348 = (state_19632[(15)]);
var inst_19359 = (state_19632[(16)]);
var inst_19467 = fluree.db.dbproto._p_prop(inst_19348,new cljs.core.Keyword(null,"name","name",1843675177),inst_19359);
var inst_19468 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19467)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_19469 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19470 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_19471 = cljs.core.PersistentHashMap.fromArrays(inst_19469,inst_19470);
var inst_19472 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19468,inst_19471);
var inst_19473 = (function(){throw inst_19472})();
var state_19632__$1 = state_19632;
var statearr_19654_19844 = state_19632__$1;
(statearr_19654_19844[(2)] = inst_19473);

(statearr_19654_19844[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (27))){
var inst_19389 = (state_19632[(17)]);
var state_19632__$1 = state_19632;
var statearr_19655_19845 = state_19632__$1;
(statearr_19655_19845[(2)] = inst_19389);

(statearr_19655_19845[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (1))){
var state_19632__$1 = state_19632;
var statearr_19656_19846 = state_19632__$1;
(statearr_19656_19846[(2)] = null);

(statearr_19656_19846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (69))){
var inst_19479 = (state_19632[(12)]);
var state_19632__$1 = state_19632;
var statearr_19657_19847 = state_19632__$1;
(statearr_19657_19847[(2)] = inst_19479);

(statearr_19657_19847[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (101))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19560 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19491,inst_19492,throw_QMARK_);
var state_19632__$1 = state_19632;
var statearr_19658_19848 = state_19632__$1;
(statearr_19658_19848[(2)] = inst_19560);

(statearr_19658_19848[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (24))){
var inst_19386 = (state_19632[(13)]);
var state_19632__$1 = state_19632;
var statearr_19659_19849 = state_19632__$1;
(statearr_19659_19849[(2)] = inst_19386);

(statearr_19659_19849[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (102))){
var inst_19562 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19660_19850 = state_19632__$1;
(statearr_19660_19850[(2)] = inst_19562);

(statearr_19660_19850[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (55))){
var inst_19458 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19661_19851 = state_19632__$1;
(statearr_19661_19851[(2)] = inst_19458);

(statearr_19661_19851[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (85))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19520 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19491,inst_19492,throw_QMARK_);
var state_19632__$1 = state_19632;
var statearr_19662_19852 = state_19632__$1;
(statearr_19662_19852[(2)] = inst_19520);

(statearr_19662_19852[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (39))){
var inst_19423 = (state_19632[(18)]);
var state_19632__$1 = state_19632;
var statearr_19663_19853 = state_19632__$1;
(statearr_19663_19853[(2)] = inst_19423);

(statearr_19663_19853[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (88))){
var inst_19479 = (state_19632[(12)]);
var state_19632__$1 = state_19632;
var statearr_19664_19854 = state_19632__$1;
(statearr_19664_19854[(2)] = inst_19479);

(statearr_19664_19854[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (46))){
var inst_19442 = (state_19632[(19)]);
var inst_19360 = (state_19632[(11)]);
var inst_19441 = (state_19632[(2)]);
var inst_19442__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_19360);
var state_19632__$1 = (function (){var statearr_19665 = state_19632;
(statearr_19665[(19)] = inst_19442__$1);

(statearr_19665[(14)] = inst_19441);

return statearr_19665;
})();
if(cljs.core.truth_(inst_19442__$1)){
var statearr_19666_19855 = state_19632__$1;
(statearr_19666_19855[(1)] = (47));

} else {
var statearr_19667_19856 = state_19632__$1;
(statearr_19667_19856[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (4))){
var inst_19321 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19668_19857 = state_19632__$1;
(statearr_19668_19857[(2)] = inst_19321);

(statearr_19668_19857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (77))){
var inst_19580 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19669_19858 = state_19632__$1;
(statearr_19669_19858[(2)] = inst_19580);

(statearr_19669_19858[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (106))){
var inst_19572 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19670_19859 = state_19632__$1;
(statearr_19670_19859[(2)] = inst_19572);

(statearr_19670_19859[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (119))){
var inst_19358 = (state_19632[(20)]);
var inst_19622 = (state_19632[(2)]);
var inst_19347 = inst_19358;
var inst_19348 = inst_19622;
var state_19632__$1 = (function (){var statearr_19671 = state_19632;
(statearr_19671[(15)] = inst_19348);

(statearr_19671[(21)] = inst_19347);

return statearr_19671;
})();
var statearr_19672_19860 = state_19632__$1;
(statearr_19672_19860[(2)] = null);

(statearr_19672_19860[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (95))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19544 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_19545 = (inst_19492.cljs$core$IFn$_invoke$arity$5 ? inst_19492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_19544,null) : inst_19492.call(null,cljs.core.PersistentArrayMap,null,5,inst_19544,null));
var inst_19546 = (inst_19492.cljs$core$IFn$_invoke$arity$4 ? inst_19492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19545,null) : inst_19492.call(null,cljs.core.PersistentHashSet,null,inst_19545,null));
var inst_19547 = (inst_19546.cljs$core$IFn$_invoke$arity$1 ? inst_19546.cljs$core$IFn$_invoke$arity$1(inst_19491) : inst_19546.call(null,inst_19491));
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19547)){
var statearr_19673_19861 = state_19632__$1;
(statearr_19673_19861[(1)] = (96));

} else {
var statearr_19674_19862 = state_19632__$1;
(statearr_19674_19862[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (54))){
var inst_19449 = (state_19632[(22)]);
var state_19632__$1 = state_19632;
var statearr_19675_19863 = state_19632__$1;
(statearr_19675_19863[(2)] = inst_19449);

(statearr_19675_19863[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (92))){
var inst_19479 = (state_19632[(12)]);
var state_19632__$1 = state_19632;
var statearr_19676_19864 = state_19632__$1;
(statearr_19676_19864[(2)] = inst_19479);

(statearr_19676_19864[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (104))){
var inst_19479 = (state_19632[(12)]);
var state_19632__$1 = state_19632;
var statearr_19677_19865 = state_19632__$1;
(statearr_19677_19865[(2)] = inst_19479);

(statearr_19677_19865[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (15))){
var inst_19368 = (state_19632[(23)]);
var state_19632__$1 = state_19632;
var statearr_19678_19866 = state_19632__$1;
(statearr_19678_19866[(2)] = inst_19368);

(statearr_19678_19866[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (48))){
var inst_19442 = (state_19632[(19)]);
var state_19632__$1 = state_19632;
var statearr_19679_19867 = state_19632__$1;
(statearr_19679_19867[(2)] = inst_19442);

(statearr_19679_19867[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (50))){
var inst_19449 = (state_19632[(22)]);
var inst_19360 = (state_19632[(11)]);
var inst_19447 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19448 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19447);
var inst_19449__$1 = inst_19448 === true;
var state_19632__$1 = (function (){var statearr_19680 = state_19632;
(statearr_19680[(22)] = inst_19449__$1);

return statearr_19680;
})();
if(cljs.core.truth_(inst_19449__$1)){
var statearr_19681_19868 = state_19632__$1;
(statearr_19681_19868[(1)] = (53));

} else {
var statearr_19682_19869 = state_19632__$1;
(statearr_19682_19869[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (116))){
var inst_19603 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19683_19870 = state_19632__$1;
(statearr_19683_19870[(2)] = inst_19603);

(statearr_19683_19870[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (75))){
var inst_19492 = (state_19632[(8)]);
var state_19632__$1 = state_19632;
var G__19684_19871 = inst_19492;
var G__19684_19872__$1 = (((G__19684_19871 instanceof cljs.core.Keyword))?G__19684_19871.fqn:null);
switch (G__19684_19872__$1) {
case "long":
var statearr_19685_19874 = state_19632__$1;
(statearr_19685_19874[(1)] = (79));


break;
case "bigint":
var statearr_19686_19875 = state_19632__$1;
(statearr_19686_19875[(1)] = (83));


break;
case "double":
var statearr_19687_19876 = state_19632__$1;
(statearr_19687_19876[(1)] = (87));


break;
case "float":
var statearr_19688_19877 = state_19632__$1;
(statearr_19688_19877[(1)] = (91));


break;
case "bigdec":
var statearr_19689_19878 = state_19632__$1;
(statearr_19689_19878[(1)] = (95));


break;
case "string":
var statearr_19690_19879 = state_19632__$1;
(statearr_19690_19879[(1)] = (99));


break;
case "instant":
var statearr_19691_19880 = state_19632__$1;
(statearr_19691_19880[(1)] = (103));


break;
default:
var statearr_19692_19881 = state_19632__$1;
(statearr_19692_19881[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (99))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19554 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_19555 = (inst_19492.cljs$core$IFn$_invoke$arity$5 ? inst_19492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_19554,null) : inst_19492.call(null,cljs.core.PersistentArrayMap,null,5,inst_19554,null));
var inst_19556 = (inst_19492.cljs$core$IFn$_invoke$arity$4 ? inst_19492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19555,null) : inst_19492.call(null,cljs.core.PersistentHashSet,null,inst_19555,null));
var inst_19557 = (inst_19556.cljs$core$IFn$_invoke$arity$1 ? inst_19556.cljs$core$IFn$_invoke$arity$1(inst_19491) : inst_19556.call(null,inst_19491));
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19557)){
var statearr_19693_19882 = state_19632__$1;
(statearr_19693_19882[(1)] = (100));

} else {
var statearr_19694_19883 = state_19632__$1;
(statearr_19694_19883[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (21))){
var inst_19384 = (state_19632[(24)]);
var state_19632__$1 = state_19632;
var statearr_19695_19884 = state_19632__$1;
(statearr_19695_19884[(2)] = inst_19384);

(statearr_19695_19884[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (31))){
var inst_19400 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19696_19885 = state_19632__$1;
(statearr_19696_19885[(2)] = inst_19400);

(statearr_19696_19885[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (113))){
var inst_19606 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19697_19886 = state_19632__$1;
(statearr_19697_19886[(2)] = inst_19606);

(statearr_19697_19886[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (32))){
var state_19632__$1 = state_19632;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_19698_19887 = state_19632__$1;
(statearr_19698_19887[(1)] = (35));

} else {
var statearr_19699_19888 = state_19632__$1;
(statearr_19699_19888[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (40))){
var inst_19436 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19436)){
var statearr_19700_19889 = state_19632__$1;
(statearr_19700_19889[(1)] = (44));

} else {
var statearr_19701_19890 = state_19632__$1;
(statearr_19701_19890[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (91))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19534 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_19535 = (inst_19492.cljs$core$IFn$_invoke$arity$5 ? inst_19492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_19534,null) : inst_19492.call(null,cljs.core.PersistentArrayMap,null,3,inst_19534,null));
var inst_19536 = (inst_19492.cljs$core$IFn$_invoke$arity$4 ? inst_19492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19535,null) : inst_19492.call(null,cljs.core.PersistentHashSet,null,inst_19535,null));
var inst_19537 = (inst_19536.cljs$core$IFn$_invoke$arity$1 ? inst_19536.cljs$core$IFn$_invoke$arity$1(inst_19491) : inst_19536.call(null,inst_19491));
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19537)){
var statearr_19702_19891 = state_19632__$1;
(statearr_19702_19891[(1)] = (92));

} else {
var statearr_19703_19892 = state_19632__$1;
(statearr_19703_19892[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (117))){
var state_19632__$1 = state_19632;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_19704_19893 = state_19632__$1;
(statearr_19704_19893[(1)] = (120));

} else {
var statearr_19705_19894 = state_19632__$1;
(statearr_19705_19894[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (108))){
var inst_19591 = (state_19632[(25)]);
var inst_19360 = (state_19632[(11)]);
var inst_19591__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_19360);
var state_19632__$1 = (function (){var statearr_19706 = state_19632;
(statearr_19706[(25)] = inst_19591__$1);

return statearr_19706;
})();
if(cljs.core.truth_(inst_19591__$1)){
var statearr_19707_19895 = state_19632__$1;
(statearr_19707_19895[(1)] = (111));

} else {
var statearr_19708_19896 = state_19632__$1;
(statearr_19708_19896[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (56))){
var inst_19453 = (state_19632[(2)]);
var inst_19454 = fluree.db.util.async.throw_err(inst_19453);
var inst_19455 = cljs.core.not(inst_19454);
var state_19632__$1 = state_19632;
var statearr_19709_19897 = state_19632__$1;
(statearr_19709_19897[(2)] = inst_19455);

(statearr_19709_19897[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (33))){
var inst_19383 = (state_19632[(26)]);
var state_19632__$1 = state_19632;
var statearr_19710_19898 = state_19632__$1;
(statearr_19710_19898[(2)] = inst_19383);

(statearr_19710_19898[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (13))){
var inst_19378 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19378)){
var statearr_19711_19899 = state_19632__$1;
(statearr_19711_19899[(1)] = (17));

} else {
var statearr_19712_19900 = state_19632__$1;
(statearr_19712_19900[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (22))){
var inst_19409 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19409)){
var statearr_19713_19901 = state_19632__$1;
(statearr_19713_19901[(1)] = (32));

} else {
var statearr_19714_19902 = state_19632__$1;
(statearr_19714_19902[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (90))){
var inst_19532 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19715_19903 = state_19632__$1;
(statearr_19715_19903[(2)] = inst_19532);

(statearr_19715_19903[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (109))){
var inst_19589 = (state_19632[(27)]);
var state_19632__$1 = state_19632;
var statearr_19716_19904 = state_19632__$1;
(statearr_19716_19904[(2)] = inst_19589);

(statearr_19716_19904[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (36))){
var inst_19383 = (state_19632[(26)]);
var state_19632__$1 = state_19632;
var statearr_19717_19905 = state_19632__$1;
(statearr_19717_19905[(2)] = inst_19383);

(statearr_19717_19905[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (41))){
var inst_19360 = (state_19632[(11)]);
var inst_19428 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19429 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19428);
var inst_19430 = inst_19429 === true;
var state_19632__$1 = state_19632;
var statearr_19718_19906 = state_19632__$1;
(statearr_19718_19906[(2)] = inst_19430);

(statearr_19718_19906[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (118))){
var inst_19587 = (state_19632[(7)]);
var state_19632__$1 = state_19632;
var statearr_19719_19907 = state_19632__$1;
(statearr_19719_19907[(2)] = inst_19587);

(statearr_19719_19907[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (89))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19530 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19491,inst_19492,throw_QMARK_);
var state_19632__$1 = state_19632;
var statearr_19720_19908 = state_19632__$1;
(statearr_19720_19908[(2)] = inst_19530);

(statearr_19720_19908[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (100))){
var inst_19479 = (state_19632[(12)]);
var state_19632__$1 = state_19632;
var statearr_19721_19909 = state_19632__$1;
(statearr_19721_19909[(2)] = inst_19479);

(statearr_19721_19909[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (122))){
var inst_19619 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19722_19910 = state_19632__$1;
(statearr_19722_19910[(2)] = inst_19619);

(statearr_19722_19910[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (43))){
var inst_19433 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19723_19911 = state_19632__$1;
(statearr_19723_19911[(2)] = inst_19433);

(statearr_19723_19911[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (61))){
var inst_19441 = (state_19632[(14)]);
var state_19632__$1 = state_19632;
var statearr_19724_19912 = state_19632__$1;
(statearr_19724_19912[(2)] = inst_19441);

(statearr_19724_19912[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (29))){
var inst_19360 = (state_19632[(11)]);
var inst_19395 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19396 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19395);
var inst_19397 = inst_19396 === true;
var state_19632__$1 = state_19632;
var statearr_19725_19913 = state_19632__$1;
(statearr_19725_19913[(2)] = inst_19397);

(statearr_19725_19913[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (44))){
var inst_19422 = (state_19632[(28)]);
var inst_19438 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_19422,"a component","a non-component",throw_QMARK_);
var state_19632__$1 = state_19632;
var statearr_19726_19914 = state_19632__$1;
(statearr_19726_19914[(2)] = inst_19438);

(statearr_19726_19914[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (93))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19540 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19491,inst_19492,throw_QMARK_);
var state_19632__$1 = state_19632;
var statearr_19727_19915 = state_19632__$1;
(statearr_19727_19915[(2)] = inst_19540);

(statearr_19727_19915[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (6))){
var inst_19359 = (state_19632[(16)]);
var inst_19347 = (state_19632[(21)]);
var inst_19356 = cljs.core.seq(inst_19347);
var inst_19357 = cljs.core.first(inst_19356);
var inst_19358 = cljs.core.next(inst_19356);
var inst_19359__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19357,(0),null);
var inst_19360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19357,(1),null);
var inst_19361 = cljs.core.not(inst_19359__$1);
var state_19632__$1 = (function (){var statearr_19728 = state_19632;
(statearr_19728[(16)] = inst_19359__$1);

(statearr_19728[(11)] = inst_19360);

(statearr_19728[(20)] = inst_19358);

return statearr_19728;
})();
if(inst_19361){
var statearr_19729_19916 = state_19632__$1;
(statearr_19729_19916[(1)] = (8));

} else {
var statearr_19730_19917 = state_19632__$1;
(statearr_19730_19917[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (111))){
var inst_19360 = (state_19632[(11)]);
var inst_19595 = (state_19632[(29)]);
var inst_19593 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19594 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19593);
var inst_19595__$1 = inst_19594 === true;
var state_19632__$1 = (function (){var statearr_19731 = state_19632;
(statearr_19731[(29)] = inst_19595__$1);

return statearr_19731;
})();
if(cljs.core.truth_(inst_19595__$1)){
var statearr_19732_19918 = state_19632__$1;
(statearr_19732_19918[(1)] = (114));

} else {
var statearr_19733_19919 = state_19632__$1;
(statearr_19733_19919[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (28))){
var inst_19403 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19734_19920 = state_19632__$1;
(statearr_19734_19920[(2)] = inst_19403);

(statearr_19734_19920[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (64))){
var inst_19480 = (state_19632[(10)]);
var state_19632__$1 = state_19632;
var statearr_19735_19921 = state_19632__$1;
(statearr_19735_19921[(2)] = inst_19480);

(statearr_19735_19921[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (103))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19564 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_19565 = (inst_19492.cljs$core$IFn$_invoke$arity$5 ? inst_19492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_19564,null) : inst_19492.call(null,cljs.core.PersistentArrayMap,null,2,inst_19564,null));
var inst_19566 = (inst_19492.cljs$core$IFn$_invoke$arity$4 ? inst_19492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19565,null) : inst_19492.call(null,cljs.core.PersistentHashSet,null,inst_19565,null));
var inst_19567 = (inst_19566.cljs$core$IFn$_invoke$arity$1 ? inst_19566.cljs$core$IFn$_invoke$arity$1(inst_19491) : inst_19566.call(null,inst_19491));
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19567)){
var statearr_19736_19922 = state_19632__$1;
(statearr_19736_19922[(1)] = (104));

} else {
var statearr_19737_19923 = state_19632__$1;
(statearr_19737_19923[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (51))){
var inst_19445 = (state_19632[(30)]);
var state_19632__$1 = state_19632;
var statearr_19738_19924 = state_19632__$1;
(statearr_19738_19924[(2)] = inst_19445);

(statearr_19738_19924[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (25))){
var inst_19406 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19739_19925 = state_19632__$1;
(statearr_19739_19925[(2)] = inst_19406);

(statearr_19739_19925[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (34))){
var inst_19423 = (state_19632[(18)]);
var inst_19360 = (state_19632[(11)]);
var inst_19422 = (state_19632[(2)]);
var inst_19423__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_19360);
var state_19632__$1 = (function (){var statearr_19740 = state_19632;
(statearr_19740[(28)] = inst_19422);

(statearr_19740[(18)] = inst_19423__$1);

return statearr_19740;
})();
if(cljs.core.truth_(inst_19423__$1)){
var statearr_19741_19926 = state_19632__$1;
(statearr_19741_19926[(1)] = (38));

} else {
var statearr_19742_19927 = state_19632__$1;
(statearr_19742_19927[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (17))){
var inst_19348 = (state_19632[(15)]);
var inst_19380 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_19348,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_19632__$1 = state_19632;
var statearr_19743_19928 = state_19632__$1;
(statearr_19743_19928[(2)] = inst_19380);

(statearr_19743_19928[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (3))){
var inst_19630 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19632__$1,inst_19630);
} else {
if((state_val_19633 === (12))){
var inst_19364 = (state_19632[(31)]);
var state_19632__$1 = state_19632;
var statearr_19744_19929 = state_19632__$1;
(statearr_19744_19929[(2)] = inst_19364);

(statearr_19744_19929[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (2))){
var _ = (function (){var statearr_19745 = state_19632;
(statearr_19745[(4)] = cljs.core.cons((5),(state_19632[(4)])));

return statearr_19745;
})();
var inst_19340 = pred_changes;
var inst_19341 = cljs.core.seq(inst_19340);
var inst_19342 = cljs.core.first(inst_19341);
var inst_19343 = cljs.core.next(inst_19341);
var inst_19344 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19342,(0),null);
var inst_19345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19342,(1),null);
var inst_19346 = db;
var inst_19347 = inst_19340;
var inst_19348 = inst_19346;
var state_19632__$1 = (function (){var statearr_19746 = state_19632;
(statearr_19746[(15)] = inst_19348);

(statearr_19746[(32)] = inst_19345);

(statearr_19746[(21)] = inst_19347);

(statearr_19746[(33)] = inst_19344);

(statearr_19746[(34)] = inst_19343);

return statearr_19746;
})();
var statearr_19747_19930 = state_19632__$1;
(statearr_19747_19930[(2)] = null);

(statearr_19747_19930[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (66))){
var inst_19492 = (state_19632[(8)]);
var inst_19360 = (state_19632[(11)]);
var inst_19491 = (state_19632[(9)]);
var inst_19489 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19490 = cljs.core.__destructure_map(inst_19489);
var inst_19491__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19490,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_19492__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19490,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_19493 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19492__$1,inst_19491__$1);
var state_19632__$1 = (function (){var statearr_19748 = state_19632;
(statearr_19748[(8)] = inst_19492__$1);

(statearr_19748[(9)] = inst_19491__$1);

return statearr_19748;
})();
if(inst_19493){
var statearr_19749_19931 = state_19632__$1;
(statearr_19749_19931[(1)] = (69));

} else {
var statearr_19750_19932 = state_19632__$1;
(statearr_19750_19932[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (107))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19574 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19491,inst_19492,throw_QMARK_);
var state_19632__$1 = state_19632;
var statearr_19751_19933 = state_19632__$1;
(statearr_19751_19933[(2)] = inst_19574);

(statearr_19751_19933[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (23))){
var inst_19389 = (state_19632[(17)]);
var inst_19360 = (state_19632[(11)]);
var inst_19388 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19389__$1 = inst_19388 === true;
var state_19632__$1 = (function (){var statearr_19752 = state_19632;
(statearr_19752[(17)] = inst_19389__$1);

return statearr_19752;
})();
if(cljs.core.truth_(inst_19389__$1)){
var statearr_19753_19934 = state_19632__$1;
(statearr_19753_19934[(1)] = (26));

} else {
var statearr_19754_19935 = state_19632__$1;
(statearr_19754_19935[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (47))){
var inst_19445 = (state_19632[(30)]);
var inst_19360 = (state_19632[(11)]);
var inst_19444 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19445__$1 = cljs.core.not(inst_19444);
var state_19632__$1 = (function (){var statearr_19755 = state_19632;
(statearr_19755[(30)] = inst_19445__$1);

return statearr_19755;
})();
if(inst_19445__$1){
var statearr_19756_19936 = state_19632__$1;
(statearr_19756_19936[(1)] = (50));

} else {
var statearr_19757_19937 = state_19632__$1;
(statearr_19757_19937[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (35))){
var inst_19412 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19413 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_19414 = cljs.core.PersistentHashMap.fromArrays(inst_19412,inst_19413);
var inst_19415 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_19414);
var inst_19416 = (function(){throw inst_19415})();
var state_19632__$1 = state_19632;
var statearr_19758_19938 = state_19632__$1;
(statearr_19758_19938[(2)] = inst_19416);

(statearr_19758_19938[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (82))){
var inst_19512 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19759_19939 = state_19632__$1;
(statearr_19759_19939[(2)] = inst_19512);

(statearr_19759_19939[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (76))){
var state_19632__$1 = state_19632;
var statearr_19760_19940 = state_19632__$1;
(statearr_19760_19940[(2)] = null);

(statearr_19760_19940[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (97))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19550 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19491,inst_19492,throw_QMARK_);
var state_19632__$1 = state_19632;
var statearr_19761_19941 = state_19632__$1;
(statearr_19761_19941[(2)] = inst_19550);

(statearr_19761_19941[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (19))){
var inst_19384 = (state_19632[(24)]);
var inst_19360 = (state_19632[(11)]);
var inst_19383 = (state_19632[(2)]);
var inst_19384__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_19360);
var state_19632__$1 = (function (){var statearr_19762 = state_19632;
(statearr_19762[(26)] = inst_19383);

(statearr_19762[(24)] = inst_19384__$1);

return statearr_19762;
})();
if(cljs.core.truth_(inst_19384__$1)){
var statearr_19763_19942 = state_19632__$1;
(statearr_19763_19942[(1)] = (20));

} else {
var statearr_19764_19943 = state_19632__$1;
(statearr_19764_19943[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (57))){
var state_19632__$1 = state_19632;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_19765_19944 = state_19632__$1;
(statearr_19765_19944[(1)] = (60));

} else {
var statearr_19766_19945 = state_19632__$1;
(statearr_19766_19945[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (68))){
var inst_19589 = (state_19632[(27)]);
var inst_19360 = (state_19632[(11)]);
var inst_19587 = (state_19632[(2)]);
var inst_19588 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19589__$1 = inst_19588 === true;
var state_19632__$1 = (function (){var statearr_19767 = state_19632;
(statearr_19767[(27)] = inst_19589__$1);

(statearr_19767[(7)] = inst_19587);

return statearr_19767;
})();
if(cljs.core.truth_(inst_19589__$1)){
var statearr_19768_19946 = state_19632__$1;
(statearr_19768_19946[(1)] = (108));

} else {
var statearr_19769_19947 = state_19632__$1;
(statearr_19769_19947[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (11))){
var inst_19368 = (state_19632[(23)]);
var inst_19360 = (state_19632[(11)]);
var inst_19366 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19367 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19366);
var inst_19368__$1 = inst_19367 === false;
var state_19632__$1 = (function (){var statearr_19770 = state_19632;
(statearr_19770[(23)] = inst_19368__$1);

return statearr_19770;
})();
if(cljs.core.truth_(inst_19368__$1)){
var statearr_19771_19948 = state_19632__$1;
(statearr_19771_19948[(1)] = (14));

} else {
var statearr_19772_19949 = state_19632__$1;
(statearr_19772_19949[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (115))){
var inst_19595 = (state_19632[(29)]);
var state_19632__$1 = state_19632;
var statearr_19774_19950 = state_19632__$1;
(statearr_19774_19950[(2)] = inst_19595);

(statearr_19774_19950[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (9))){
var inst_19364 = (state_19632[(31)]);
var inst_19360 = (state_19632[(11)]);
var inst_19364__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_19360);
var state_19632__$1 = (function (){var statearr_19775 = state_19632;
(statearr_19775[(31)] = inst_19364__$1);

return statearr_19775;
})();
if(cljs.core.truth_(inst_19364__$1)){
var statearr_19776_19951 = state_19632__$1;
(statearr_19776_19951[(1)] = (11));

} else {
var statearr_19777_19952 = state_19632__$1;
(statearr_19777_19952[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (5))){
var _ = (function (){var statearr_19778 = state_19632;
(statearr_19778[(4)] = cljs.core.rest((state_19632[(4)])));

return statearr_19778;
})();
var state_19632__$1 = state_19632;
var ex19773 = (state_19632__$1[(2)]);
var statearr_19779_19953 = state_19632__$1;
(statearr_19779_19953[(5)] = ex19773);


if((ex19773 instanceof Error)){
var statearr_19780_19954 = state_19632__$1;
(statearr_19780_19954[(1)] = (4));

(statearr_19780_19954[(5)] = null);

} else {
throw ex19773;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (112))){
var inst_19591 = (state_19632[(25)]);
var state_19632__$1 = state_19632;
var statearr_19781_19955 = state_19632__$1;
(statearr_19781_19955[(2)] = inst_19591);

(statearr_19781_19955[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (83))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19514 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_19515 = (inst_19492.cljs$core$IFn$_invoke$arity$5 ? inst_19492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_19514,null) : inst_19492.call(null,cljs.core.PersistentArrayMap,null,3,inst_19514,null));
var inst_19516 = (inst_19492.cljs$core$IFn$_invoke$arity$4 ? inst_19492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19515,null) : inst_19492.call(null,cljs.core.PersistentHashSet,null,inst_19515,null));
var inst_19517 = (inst_19516.cljs$core$IFn$_invoke$arity$1 ? inst_19516.cljs$core$IFn$_invoke$arity$1(inst_19491) : inst_19516.call(null,inst_19491));
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19517)){
var statearr_19782_19956 = state_19632__$1;
(statearr_19782_19956[(1)] = (84));

} else {
var statearr_19783_19957 = state_19632__$1;
(statearr_19783_19957[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (14))){
var inst_19360 = (state_19632[(11)]);
var inst_19370 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19371 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_19370);
var inst_19372 = inst_19371 === true;
var state_19632__$1 = state_19632;
var statearr_19784_19958 = state_19632__$1;
(statearr_19784_19958[(2)] = inst_19372);

(statearr_19784_19958[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (45))){
var inst_19422 = (state_19632[(28)]);
var state_19632__$1 = state_19632;
var statearr_19785_19959 = state_19632__$1;
(statearr_19785_19959[(2)] = inst_19422);

(statearr_19785_19959[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (53))){
var inst_19348 = (state_19632[(15)]);
var inst_19359 = (state_19632[(16)]);
var inst_19451 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_19348,inst_19359);
var state_19632__$1 = state_19632;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19632__$1,(56),inst_19451);
} else {
if((state_val_19633 === (78))){
var inst_19577 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19786_19960 = state_19632__$1;
(statearr_19786_19960[(2)] = inst_19577);

(statearr_19786_19960[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (26))){
var inst_19360 = (state_19632[(11)]);
var inst_19393 = (state_19632[(35)]);
var inst_19391 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19392 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19391);
var inst_19393__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_19392);
var state_19632__$1 = (function (){var statearr_19787 = state_19632;
(statearr_19787[(35)] = inst_19393__$1);

return statearr_19787;
})();
if(inst_19393__$1){
var statearr_19788_19961 = state_19632__$1;
(statearr_19788_19961[(1)] = (29));

} else {
var statearr_19789_19962 = state_19632__$1;
(statearr_19789_19962[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (16))){
var inst_19375 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19790_19963 = state_19632__$1;
(statearr_19790_19963[(2)] = inst_19375);

(statearr_19790_19963[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (81))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19510 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19491,inst_19492,throw_QMARK_);
var state_19632__$1 = state_19632;
var statearr_19791_19964 = state_19632__$1;
(statearr_19791_19964[(2)] = inst_19510);

(statearr_19791_19964[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (120))){
var inst_19612 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19613 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_19614 = cljs.core.PersistentHashMap.fromArrays(inst_19612,inst_19613);
var inst_19615 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_19614);
var inst_19616 = (function(){throw inst_19615})();
var state_19632__$1 = state_19632;
var statearr_19792_19965 = state_19632__$1;
(statearr_19792_19965[(2)] = inst_19616);

(statearr_19792_19965[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (79))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19504 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_19505 = (inst_19492.cljs$core$IFn$_invoke$arity$5 ? inst_19492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_19504,null) : inst_19492.call(null,cljs.core.PersistentArrayMap,null,2,inst_19504,null));
var inst_19506 = (inst_19492.cljs$core$IFn$_invoke$arity$4 ? inst_19492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19505,null) : inst_19492.call(null,cljs.core.PersistentHashSet,null,inst_19505,null));
var inst_19507 = (inst_19506.cljs$core$IFn$_invoke$arity$1 ? inst_19506.cljs$core$IFn$_invoke$arity$1(inst_19491) : inst_19506.call(null,inst_19491));
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19507)){
var statearr_19793_19966 = state_19632__$1;
(statearr_19793_19966[(1)] = (80));

} else {
var statearr_19794_19967 = state_19632__$1;
(statearr_19794_19967[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (38))){
var inst_19426 = (state_19632[(36)]);
var inst_19360 = (state_19632[(11)]);
var inst_19425 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19426__$1 = cljs.core.not(inst_19425);
var state_19632__$1 = (function (){var statearr_19795 = state_19632;
(statearr_19795[(36)] = inst_19426__$1);

return statearr_19795;
})();
if(inst_19426__$1){
var statearr_19796_19968 = state_19632__$1;
(statearr_19796_19968[(1)] = (41));

} else {
var statearr_19797_19969 = state_19632__$1;
(statearr_19797_19969[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (98))){
var inst_19552 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19798_19970 = state_19632__$1;
(statearr_19798_19970[(2)] = inst_19552);

(statearr_19798_19970[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (87))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19524 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_19525 = (inst_19492.cljs$core$IFn$_invoke$arity$5 ? inst_19492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_19524,null) : inst_19492.call(null,cljs.core.PersistentArrayMap,null,3,inst_19524,null));
var inst_19526 = (inst_19492.cljs$core$IFn$_invoke$arity$4 ? inst_19492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_19525,null) : inst_19492.call(null,cljs.core.PersistentHashSet,null,inst_19525,null));
var inst_19527 = (inst_19526.cljs$core$IFn$_invoke$arity$1 ? inst_19526.cljs$core$IFn$_invoke$arity$1(inst_19491) : inst_19526.call(null,inst_19491));
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19527)){
var statearr_19799_19971 = state_19632__$1;
(statearr_19799_19971[(1)] = (88));

} else {
var statearr_19800_19972 = state_19632__$1;
(statearr_19800_19972[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (30))){
var inst_19393 = (state_19632[(35)]);
var state_19632__$1 = state_19632;
var statearr_19801_19973 = state_19632__$1;
(statearr_19801_19973[(2)] = inst_19393);

(statearr_19801_19973[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (73))){
var state_19632__$1 = state_19632;
var statearr_19802_19974 = state_19632__$1;
(statearr_19802_19974[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (96))){
var inst_19479 = (state_19632[(12)]);
var state_19632__$1 = state_19632;
var statearr_19804_19975 = state_19632__$1;
(statearr_19804_19975[(2)] = inst_19479);

(statearr_19804_19975[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (10))){
var inst_19625 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19805_19976 = state_19632__$1;
(statearr_19805_19976[(2)] = inst_19625);

(statearr_19805_19976[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (18))){
var inst_19348 = (state_19632[(15)]);
var state_19632__$1 = state_19632;
var statearr_19806_19977 = state_19632__$1;
(statearr_19806_19977[(2)] = inst_19348);

(statearr_19806_19977[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (105))){
var inst_19492 = (state_19632[(8)]);
var inst_19491 = (state_19632[(9)]);
var inst_19570 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_19491,inst_19492,throw_QMARK_);
var state_19632__$1 = state_19632;
var statearr_19807_19978 = state_19632__$1;
(statearr_19807_19978[(2)] = inst_19570);

(statearr_19807_19978[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (52))){
var inst_19461 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19808_19979 = state_19632__$1;
(statearr_19808_19979[(2)] = inst_19461);

(statearr_19808_19979[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (114))){
var inst_19360 = (state_19632[(11)]);
var inst_19597 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19598 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19597);
var inst_19599 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_19598);
var inst_19600 = (!(inst_19599));
var state_19632__$1 = state_19632;
var statearr_19809_19980 = state_19632__$1;
(statearr_19809_19980[(2)] = inst_19600);

(statearr_19809_19980[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (67))){
var inst_19479 = (state_19632[(12)]);
var state_19632__$1 = state_19632;
var statearr_19810_19981 = state_19632__$1;
(statearr_19810_19981[(2)] = inst_19479);

(statearr_19810_19981[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (71))){
var inst_19584 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19811_19982 = state_19632__$1;
(statearr_19811_19982[(2)] = inst_19584);

(statearr_19811_19982[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (42))){
var inst_19426 = (state_19632[(36)]);
var state_19632__$1 = state_19632;
var statearr_19812_19983 = state_19632__$1;
(statearr_19812_19983[(2)] = inst_19426);

(statearr_19812_19983[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (80))){
var inst_19479 = (state_19632[(12)]);
var state_19632__$1 = state_19632;
var statearr_19813_19984 = state_19632__$1;
(statearr_19813_19984[(2)] = inst_19479);

(statearr_19813_19984[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (37))){
var inst_19419 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19814_19985 = state_19632__$1;
(statearr_19814_19985[(2)] = inst_19419);

(statearr_19814_19985[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (63))){
var inst_19360 = (state_19632[(11)]);
var inst_19482 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19360);
var inst_19483 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_19482);
var state_19632__$1 = state_19632;
var statearr_19815_19986 = state_19632__$1;
(statearr_19815_19986[(2)] = inst_19483);

(statearr_19815_19986[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (94))){
var inst_19542 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
var statearr_19816_19987 = state_19632__$1;
(statearr_19816_19987[(2)] = inst_19542);

(statearr_19816_19987[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (8))){
var inst_19348 = (state_19632[(15)]);
var state_19632__$1 = state_19632;
var statearr_19817_19988 = state_19632__$1;
(statearr_19817_19988[(2)] = inst_19348);

(statearr_19817_19988[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (49))){
var inst_19464 = (state_19632[(2)]);
var state_19632__$1 = state_19632;
if(cljs.core.truth_(inst_19464)){
var statearr_19818_19989 = state_19632__$1;
(statearr_19818_19989[(1)] = (57));

} else {
var statearr_19819_19990 = state_19632__$1;
(statearr_19819_19990[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19633 === (84))){
var inst_19479 = (state_19632[(12)]);
var state_19632__$1 = state_19632;
var statearr_19820_19991 = state_19632__$1;
(statearr_19820_19991[(2)] = inst_19479);

(statearr_19820_19991[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2733__auto__ = null;
var fluree$db$query$schema$state_machine__2733__auto____0 = (function (){
var statearr_19821 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19821[(0)] = fluree$db$query$schema$state_machine__2733__auto__);

(statearr_19821[(1)] = (1));

return statearr_19821;
});
var fluree$db$query$schema$state_machine__2733__auto____1 = (function (state_19632){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_19632);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e19822){var ex__2736__auto__ = e19822;
var statearr_19823_19992 = state_19632;
(statearr_19823_19992[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_19632[(4)]))){
var statearr_19824_19993 = state_19632;
(statearr_19824_19993[(1)] = cljs.core.first((state_19632[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19994 = state_19632;
state_19632 = G__19994;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2733__auto__ = function(state_19632){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2733__auto____1.call(this,state_19632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2733__auto____0;
fluree$db$query$schema$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2733__auto____1;
return fluree$db$query$schema$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_19825 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_19825[(6)] = c__2755__auto__);

return statearr_19825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__19996 = arguments.length;
switch (G__19996) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20020){
var state_val_20021 = (state_20020[(1)]);
if((state_val_20021 === (7))){
var state_20020__$1 = state_20020;
var statearr_20022_20042 = state_20020__$1;
(statearr_20022_20042[(2)] = db);

(statearr_20022_20042[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (1))){
var state_20020__$1 = state_20020;
var statearr_20023_20043 = state_20020__$1;
(statearr_20023_20043[(2)] = null);

(statearr_20023_20043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (4))){
var inst_19997 = (state_20020[(2)]);
var state_20020__$1 = state_20020;
var statearr_20024_20044 = state_20020__$1;
(statearr_20024_20044[(2)] = inst_19997);

(statearr_20024_20044[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (6))){
var inst_20006 = (state_20020[(7)]);
var inst_20005 = (state_20020[(2)]);
var inst_20006__$1 = fluree.db.util.async.throw_err(inst_20005);
var inst_20007 = cljs.core.empty_QMARK_(inst_20006__$1);
var state_20020__$1 = (function (){var statearr_20025 = state_20020;
(statearr_20025[(7)] = inst_20006__$1);

return statearr_20025;
})();
if(inst_20007){
var statearr_20026_20045 = state_20020__$1;
(statearr_20026_20045[(1)] = (7));

} else {
var statearr_20027_20046 = state_20020__$1;
(statearr_20027_20046[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (3))){
var inst_20018 = (state_20020[(2)]);
var state_20020__$1 = state_20020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20020__$1,inst_20018);
} else {
if((state_val_20021 === (2))){
var _ = (function (){var statearr_20029 = state_20020;
(statearr_20029[(4)] = cljs.core.cons((5),(state_20020[(4)])));

return statearr_20029;
})();
var inst_20003 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_20020__$1 = state_20020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20020__$1,(6),inst_20003);
} else {
if((state_val_20021 === (9))){
var inst_20015 = (state_20020[(2)]);
var _ = (function (){var statearr_20030 = state_20020;
(statearr_20030[(4)] = cljs.core.rest((state_20020[(4)])));

return statearr_20030;
})();
var state_20020__$1 = state_20020;
var statearr_20031_20047 = state_20020__$1;
(statearr_20031_20047[(2)] = inst_20015);

(statearr_20031_20047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (5))){
var _ = (function (){var statearr_20032 = state_20020;
(statearr_20032[(4)] = cljs.core.rest((state_20020[(4)])));

return statearr_20032;
})();
var state_20020__$1 = state_20020;
var ex20028 = (state_20020__$1[(2)]);
var statearr_20033_20048 = state_20020__$1;
(statearr_20033_20048[(5)] = ex20028);


if((ex20028 instanceof Error)){
var statearr_20034_20049 = state_20020__$1;
(statearr_20034_20049[(1)] = (4));

(statearr_20034_20049[(5)] = null);

} else {
throw ex20028;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (10))){
var inst_20012 = (state_20020[(2)]);
var inst_20013 = fluree.db.util.async.throw_err(inst_20012);
var state_20020__$1 = state_20020;
var statearr_20035_20050 = state_20020__$1;
(statearr_20035_20050[(2)] = inst_20013);

(statearr_20035_20050[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (8))){
var inst_20006 = (state_20020[(7)]);
var inst_20010 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_20006,db,true);
var state_20020__$1 = state_20020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20020__$1,(10),inst_20010);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2733__auto__ = null;
var fluree$db$query$schema$state_machine__2733__auto____0 = (function (){
var statearr_20036 = [null,null,null,null,null,null,null,null];
(statearr_20036[(0)] = fluree$db$query$schema$state_machine__2733__auto__);

(statearr_20036[(1)] = (1));

return statearr_20036;
});
var fluree$db$query$schema$state_machine__2733__auto____1 = (function (state_20020){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20020);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20037){var ex__2736__auto__ = e20037;
var statearr_20038_20051 = state_20020;
(statearr_20038_20051[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20020[(4)]))){
var statearr_20039_20052 = state_20020;
(statearr_20039_20052[(1)] = cljs.core.first((state_20020[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20053 = state_20020;
state_20020 = G__20053;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2733__auto__ = function(state_20020){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2733__auto____1.call(this,state_20020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2733__auto____0;
fluree$db$query$schema$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2733__auto____1;
return fluree$db$query$schema$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20040 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20040[(6)] = c__2755__auto__);

return statearr_20040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__20055 = arguments.length;
switch (G__20055) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__20057 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20057,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20057,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20057,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4221__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4221__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__20060_SHARP_,p2__20061_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20060_SHARP_,p2__20061_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__20062_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,p1__20062_SHARP_.p)){
return p1__20062_SHARP_.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20128){
var state_val_20129 = (state_20128[(1)]);
if((state_val_20129 === (1))){
var state_20128__$1 = state_20128;
var statearr_20130_20148 = state_20128__$1;
(statearr_20130_20148[(2)] = null);

(statearr_20130_20148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20129 === (2))){
var _ = (function (){var statearr_20131 = state_20128;
(statearr_20131[(4)] = cljs.core.cons((5),(state_20128[(4)])));

return statearr_20131;
})();
var inst_20080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20081 = fluree.db.flake.max_subject_id((1));
var inst_20082 = [inst_20081];
var inst_20083 = (new cljs.core.PersistentVector(null,1,(5),inst_20080,inst_20082,null));
var inst_20084 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20085 = [(0)];
var inst_20086 = (new cljs.core.PersistentVector(null,1,(5),inst_20084,inst_20085,null));
var inst_20087 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20083,cljs.core._LT__EQ_,inst_20086);
var state_20128__$1 = state_20128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20128__$1,(6),inst_20087);
} else {
if((state_val_20129 === (3))){
var inst_20126 = (state_20128[(2)]);
var state_20128__$1 = state_20128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20128__$1,inst_20126);
} else {
if((state_val_20129 === (4))){
var inst_20068 = (state_20128[(2)]);
var state_20128__$1 = state_20128;
var statearr_20133_20149 = state_20128__$1;
(statearr_20133_20149[(2)] = inst_20068);

(statearr_20133_20149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20129 === (5))){
var _ = (function (){var statearr_20134 = state_20128;
(statearr_20134[(4)] = cljs.core.rest((state_20128[(4)])));

return statearr_20134;
})();
var state_20128__$1 = state_20128;
var ex20132 = (state_20128__$1[(2)]);
var statearr_20135_20150 = state_20128__$1;
(statearr_20135_20150[(5)] = ex20132);


if((ex20132 instanceof Error)){
var statearr_20136_20151 = state_20128__$1;
(statearr_20136_20151[(1)] = (4));

(statearr_20136_20151[(5)] = null);

} else {
throw ex20132;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20129 === (6))){
var inst_20089 = (state_20128[(2)]);
var inst_20090 = fluree.db.util.async.throw_err(inst_20089);
var inst_20091 = (function (){var schema_flakes = inst_20090;
return (function (p1__20063_SHARP_){
return (p1__20063_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_20092 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_20091,inst_20090);
var inst_20093 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20092,(0),null);
var inst_20094 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20092,(1),null);
var inst_20095 = (function (){var schema_flakes = inst_20090;
var vec__20074 = inst_20092;
var collection_flakes = inst_20093;
var predicate_flakes = inst_20094;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__20065_SHARP_,p2__20066_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__20065_SHARP_,p2__20066_SHARP_.p,p2__20066_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_20096 = [(-1),"_tx"];
var inst_20097 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_20098 = ["_tx",(-1),(-1)];
var inst_20099 = cljs.core.PersistentHashMap.fromArrays(inst_20097,inst_20098);
var inst_20100 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_20101 = ["_tx",(-1),(-1)];
var inst_20102 = cljs.core.PersistentHashMap.fromArrays(inst_20100,inst_20101);
var inst_20103 = [inst_20099,inst_20102];
var inst_20104 = cljs.core.PersistentHashMap.fromArrays(inst_20096,inst_20103);
var inst_20105 = (function (){var schema_flakes = inst_20090;
var vec__20074 = inst_20092;
var collection_flakes = inst_20093;
var predicate_flakes = inst_20094;
return (function (p1__20064_SHARP_){
return p1__20064_SHARP_.s;
});
})();
var inst_20106 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_20105,inst_20093);
var inst_20107 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20095,inst_20104,inst_20106);
var inst_20109 = (function (){var schema_flakes = inst_20090;
var vec__20074 = inst_20092;
var collection_flakes = inst_20093;
var predicate_flakes = inst_20094;
var coll = inst_20107;
return (function (p__20108,pred_flakes){
var vec__20137 = p__20108;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20137,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20137,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__20140 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__20140.cljs$core$IFn$_invoke$arity$1 ? fexpr__20140.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__20140.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4223__auto__ = ref_QMARK_;
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_20110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20111 = cljs.core.PersistentHashMap.EMPTY;
var inst_20112 = cljs.core.PersistentHashSet.EMPTY;
var inst_20113 = [inst_20111,inst_20112];
var inst_20114 = (new cljs.core.PersistentVector(null,2,(5),inst_20110,inst_20113,null));
var inst_20115 = (function (){var schema_flakes = inst_20090;
var vec__20074 = inst_20092;
var collection_flakes = inst_20093;
var predicate_flakes = inst_20094;
var coll = inst_20107;
return (function (p1__20067_SHARP_){
return p1__20067_SHARP_.s;
});
})();
var inst_20116 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_20115,inst_20094);
var inst_20117 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20109,inst_20114,inst_20116);
var inst_20118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20117,(0),null);
var inst_20119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20117,(1),null);
var inst_20120 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_20121 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20122 = [inst_20121,inst_20107,inst_20118,inst_20119];
var inst_20123 = cljs.core.PersistentHashMap.fromArrays(inst_20120,inst_20122);
var _ = (function (){var statearr_20141 = state_20128;
(statearr_20141[(4)] = cljs.core.rest((state_20128[(4)])));

return statearr_20141;
})();
var state_20128__$1 = state_20128;
var statearr_20142_20152 = state_20128__$1;
(statearr_20142_20152[(2)] = inst_20123);

(statearr_20142_20152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2733__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2733__auto____0 = (function (){
var statearr_20143 = [null,null,null,null,null,null,null];
(statearr_20143[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2733__auto__);

(statearr_20143[(1)] = (1));

return statearr_20143;
});
var fluree$db$query$schema$schema_map_$_state_machine__2733__auto____1 = (function (state_20128){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20128);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20144){var ex__2736__auto__ = e20144;
var statearr_20145_20153 = state_20128;
(statearr_20145_20153[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20128[(4)]))){
var statearr_20146_20154 = state_20128;
(statearr_20146_20154[(1)] = cljs.core.first((state_20128[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20155 = state_20128;
state_20128 = G__20155;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2733__auto__ = function(state_20128){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2733__auto____1.call(this,state_20128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2733__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2733__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20147 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20147[(6)] = c__2755__auto__);

return statearr_20147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20197){
var state_val_20198 = (state_20197[(1)]);
if((state_val_20198 === (7))){
var inst_20180 = (state_20197[(2)]);
var inst_20181 = fluree.db.query.schema.flake__GT_pred_map(inst_20180);
var inst_20182 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_20183 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20181,(114));
var inst_20184 = cljs.core.boolean$(inst_20183);
var inst_20185 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20181,(110));
var inst_20186 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20181,(117));
var inst_20187 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_20186);
var inst_20188 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20181,(111));
var inst_20189 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20181,(115));
var inst_20190 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20181,(112));
var inst_20191 = [inst_20184,inst_20185,inst_20187,inst_20188,inst_20189,inst_20190];
var inst_20192 = cljs.core.PersistentHashMap.fromArrays(inst_20182,inst_20191);
var _ = (function (){var statearr_20199 = state_20197;
(statearr_20199[(4)] = cljs.core.rest((state_20197[(4)])));

return statearr_20199;
})();
var state_20197__$1 = state_20197;
var statearr_20200_20223 = state_20197__$1;
(statearr_20200_20223[(2)] = inst_20192);

(statearr_20200_20223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20198 === (1))){
var state_20197__$1 = state_20197;
var statearr_20201_20224 = state_20197__$1;
(statearr_20201_20224[(2)] = null);

(statearr_20201_20224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20198 === (4))){
var inst_20156 = (state_20197[(2)]);
var state_20197__$1 = state_20197;
var statearr_20202_20225 = state_20197__$1;
(statearr_20202_20225[(2)] = inst_20156);

(statearr_20202_20225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20198 === (6))){
var _ = (function (){var statearr_20203 = state_20197;
(statearr_20203[(4)] = cljs.core.cons((9),(state_20197[(4)])));

return statearr_20203;
})();
var inst_20168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20170 = ["_setting/id","root"];
var inst_20171 = (new cljs.core.PersistentVector(null,2,(5),inst_20169,inst_20170,null));
var inst_20172 = [inst_20171];
var inst_20173 = (new cljs.core.PersistentVector(null,1,(5),inst_20168,inst_20172,null));
var inst_20174 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20173);
var state_20197__$1 = state_20197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20197__$1,(10),inst_20174);
} else {
if((state_val_20198 === (3))){
var inst_20195 = (state_20197[(2)]);
var state_20197__$1 = state_20197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20197__$1,inst_20195);
} else {
if((state_val_20198 === (2))){
var _ = (function (){var statearr_20206 = state_20197;
(statearr_20206[(4)] = cljs.core.cons((5),(state_20197[(4)])));

return statearr_20206;
})();
var state_20197__$1 = state_20197;
var statearr_20207_20226 = state_20197__$1;
(statearr_20207_20226[(2)] = null);

(statearr_20207_20226[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20198 === (9))){
var _ = (function (){var statearr_20208 = state_20197;
(statearr_20208[(4)] = cljs.core.rest((state_20197[(4)])));

return statearr_20208;
})();
var state_20197__$1 = state_20197;
var ex20204 = (state_20197__$1[(2)]);
var statearr_20209_20227 = state_20197__$1;
(statearr_20209_20227[(5)] = ex20204);


var statearr_20210_20228 = state_20197__$1;
(statearr_20210_20228[(1)] = (8));

(statearr_20210_20228[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20198 === (5))){
var _ = (function (){var statearr_20211 = state_20197;
(statearr_20211[(4)] = cljs.core.rest((state_20197[(4)])));

return statearr_20211;
})();
var state_20197__$1 = state_20197;
var ex20205 = (state_20197__$1[(2)]);
var statearr_20212_20229 = state_20197__$1;
(statearr_20212_20229[(5)] = ex20205);


if((ex20205 instanceof Error)){
var statearr_20213_20230 = state_20197__$1;
(statearr_20213_20230[(1)] = (4));

(statearr_20213_20230[(5)] = null);

} else {
throw ex20205;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20198 === (10))){
var inst_20176 = (state_20197[(2)]);
var inst_20177 = fluree.db.util.async.throw_err(inst_20176);
var _ = (function (){var statearr_20214 = state_20197;
(statearr_20214[(4)] = cljs.core.rest((state_20197[(4)])));

return statearr_20214;
})();
var state_20197__$1 = state_20197;
var statearr_20215_20231 = state_20197__$1;
(statearr_20215_20231[(2)] = inst_20177);

(statearr_20215_20231[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20198 === (8))){
var inst_20162 = (state_20197[(2)]);
var state_20197__$1 = (function (){var statearr_20216 = state_20197;
(statearr_20216[(7)] = inst_20162);

return statearr_20216;
})();
var statearr_20217_20232 = state_20197__$1;
(statearr_20217_20232[(2)] = null);

(statearr_20217_20232[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2733__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2733__auto____0 = (function (){
var statearr_20218 = [null,null,null,null,null,null,null,null];
(statearr_20218[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2733__auto__);

(statearr_20218[(1)] = (1));

return statearr_20218;
});
var fluree$db$query$schema$setting_map_$_state_machine__2733__auto____1 = (function (state_20197){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20197);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20219){var ex__2736__auto__ = e20219;
var statearr_20220_20233 = state_20197;
(statearr_20220_20233[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20197[(4)]))){
var statearr_20221_20234 = state_20197;
(statearr_20221_20234[(1)] = cljs.core.first((state_20197[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20235 = state_20197;
state_20197 = G__20235;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2733__auto__ = function(state_20197){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2733__auto____1.call(this,state_20197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2733__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2733__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20222 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20222[(6)] = c__2755__auto__);

return statearr_20222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
