// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20508){
var state_val_20509 = (state_20508[(1)]);
if((state_val_20509 === (7))){
var inst_20497 = (state_20508[(7)]);
var inst_20499 = fluree.db.storage.core.serde(conn);
var inst_20500 = fluree.db.serde.protocol._deserialize_block(inst_20499,inst_20497);
var state_20508__$1 = state_20508;
var statearr_20510_20529 = state_20508__$1;
(statearr_20510_20529[(2)] = inst_20500);

(statearr_20510_20529[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20509 === (1))){
var state_20508__$1 = state_20508;
var statearr_20511_20530 = state_20508__$1;
(statearr_20511_20530[(2)] = null);

(statearr_20511_20530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20509 === (4))){
var inst_20487 = (state_20508[(2)]);
var state_20508__$1 = state_20508;
var statearr_20512_20531 = state_20508__$1;
(statearr_20512_20531[(2)] = inst_20487);

(statearr_20512_20531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20509 === (6))){
var inst_20497 = (state_20508[(7)]);
var inst_20496 = (state_20508[(2)]);
var inst_20497__$1 = fluree.db.util.async.throw_err(inst_20496);
var state_20508__$1 = (function (){var statearr_20513 = state_20508;
(statearr_20513[(7)] = inst_20497__$1);

return statearr_20513;
})();
if(cljs.core.truth_(inst_20497__$1)){
var statearr_20514_20532 = state_20508__$1;
(statearr_20514_20532[(1)] = (7));

} else {
var statearr_20515_20533 = state_20508__$1;
(statearr_20515_20533[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20509 === (3))){
var inst_20506 = (state_20508[(2)]);
var state_20508__$1 = state_20508;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20508__$1,inst_20506);
} else {
if((state_val_20509 === (2))){
var _ = (function (){var statearr_20517 = state_20508;
(statearr_20517[(4)] = cljs.core.cons((5),(state_20508[(4)])));

return statearr_20517;
})();
var inst_20493 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_20494 = fluree.db.storage.core.storage_read(conn,inst_20493);
var state_20508__$1 = state_20508;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20508__$1,(6),inst_20494);
} else {
if((state_val_20509 === (9))){
var inst_20503 = (state_20508[(2)]);
var _ = (function (){var statearr_20518 = state_20508;
(statearr_20518[(4)] = cljs.core.rest((state_20508[(4)])));

return statearr_20518;
})();
var state_20508__$1 = state_20508;
var statearr_20519_20534 = state_20508__$1;
(statearr_20519_20534[(2)] = inst_20503);

(statearr_20519_20534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20509 === (5))){
var _ = (function (){var statearr_20520 = state_20508;
(statearr_20520[(4)] = cljs.core.rest((state_20508[(4)])));

return statearr_20520;
})();
var state_20508__$1 = state_20508;
var ex20516 = (state_20508__$1[(2)]);
var statearr_20521_20535 = state_20508__$1;
(statearr_20521_20535[(5)] = ex20516);


if((ex20516 instanceof Error)){
var statearr_20522_20536 = state_20508__$1;
(statearr_20522_20536[(1)] = (4));

(statearr_20522_20536[(5)] = null);

} else {
throw ex20516;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20509 === (8))){
var state_20508__$1 = state_20508;
var statearr_20523_20537 = state_20508__$1;
(statearr_20523_20537[(2)] = null);

(statearr_20523_20537[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2733__auto____0 = (function (){
var statearr_20524 = [null,null,null,null,null,null,null,null];
(statearr_20524[(0)] = fluree$db$storage$core$read_block_$_state_machine__2733__auto__);

(statearr_20524[(1)] = (1));

return statearr_20524;
});
var fluree$db$storage$core$read_block_$_state_machine__2733__auto____1 = (function (state_20508){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20508);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20525){var ex__2736__auto__ = e20525;
var statearr_20526_20538 = state_20508;
(statearr_20526_20538[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20508[(4)]))){
var statearr_20527_20539 = state_20508;
(statearr_20527_20539[(1)] = cljs.core.first((state_20508[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20540 = state_20508;
state_20508 = G__20540;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2733__auto__ = function(state_20508){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2733__auto____1.call(this,state_20508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2733__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2733__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20528 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20528[(6)] = c__2755__auto__);

return statearr_20528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20563){
var state_val_20564 = (state_20563[(1)]);
if((state_val_20564 === (7))){
var inst_20552 = (state_20563[(7)]);
var inst_20554 = fluree.db.storage.core.serde(conn);
var inst_20555 = fluree.db.serde.protocol._deserialize_block(inst_20554,inst_20552);
var state_20563__$1 = state_20563;
var statearr_20565_20584 = state_20563__$1;
(statearr_20565_20584[(2)] = inst_20555);

(statearr_20565_20584[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20564 === (1))){
var state_20563__$1 = state_20563;
var statearr_20566_20585 = state_20563__$1;
(statearr_20566_20585[(2)] = null);

(statearr_20566_20585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20564 === (4))){
var inst_20541 = (state_20563[(2)]);
var state_20563__$1 = state_20563;
var statearr_20567_20586 = state_20563__$1;
(statearr_20567_20586[(2)] = inst_20541);

(statearr_20567_20586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20564 === (6))){
var inst_20552 = (state_20563[(7)]);
var inst_20551 = (state_20563[(2)]);
var inst_20552__$1 = fluree.db.util.async.throw_err(inst_20551);
var state_20563__$1 = (function (){var statearr_20568 = state_20563;
(statearr_20568[(7)] = inst_20552__$1);

return statearr_20568;
})();
if(cljs.core.truth_(inst_20552__$1)){
var statearr_20569_20587 = state_20563__$1;
(statearr_20569_20587[(1)] = (7));

} else {
var statearr_20570_20588 = state_20563__$1;
(statearr_20570_20588[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20564 === (3))){
var inst_20561 = (state_20563[(2)]);
var state_20563__$1 = state_20563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20563__$1,inst_20561);
} else {
if((state_val_20564 === (2))){
var _ = (function (){var statearr_20572 = state_20563;
(statearr_20572[(4)] = cljs.core.cons((5),(state_20563[(4)])));

return statearr_20572;
})();
var inst_20547 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_20548 = [inst_20547,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_20549 = fluree.db.storage.core.storage_read(conn,inst_20548);
var state_20563__$1 = state_20563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20563__$1,(6),inst_20549);
} else {
if((state_val_20564 === (9))){
var inst_20558 = (state_20563[(2)]);
var _ = (function (){var statearr_20573 = state_20563;
(statearr_20573[(4)] = cljs.core.rest((state_20563[(4)])));

return statearr_20573;
})();
var state_20563__$1 = state_20563;
var statearr_20574_20589 = state_20563__$1;
(statearr_20574_20589[(2)] = inst_20558);

(statearr_20574_20589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20564 === (5))){
var _ = (function (){var statearr_20575 = state_20563;
(statearr_20575[(4)] = cljs.core.rest((state_20563[(4)])));

return statearr_20575;
})();
var state_20563__$1 = state_20563;
var ex20571 = (state_20563__$1[(2)]);
var statearr_20576_20590 = state_20563__$1;
(statearr_20576_20590[(5)] = ex20571);


if((ex20571 instanceof Error)){
var statearr_20577_20591 = state_20563__$1;
(statearr_20577_20591[(1)] = (4));

(statearr_20577_20591[(5)] = null);

} else {
throw ex20571;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20564 === (8))){
var state_20563__$1 = state_20563;
var statearr_20578_20592 = state_20563__$1;
(statearr_20578_20592[(2)] = null);

(statearr_20578_20592[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2733__auto____0 = (function (){
var statearr_20579 = [null,null,null,null,null,null,null,null];
(statearr_20579[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2733__auto__);

(statearr_20579[(1)] = (1));

return statearr_20579;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2733__auto____1 = (function (state_20563){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20563);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20580){var ex__2736__auto__ = e20580;
var statearr_20581_20593 = state_20563;
(statearr_20581_20593[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20563[(4)]))){
var statearr_20582_20594 = state_20563;
(statearr_20582_20594[(1)] = cljs.core.first((state_20563[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20595 = state_20563;
state_20563 = G__20595;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2733__auto__ = function(state_20563){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2733__auto____1.call(this,state_20563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2733__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2733__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20583 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20583[(6)] = c__2755__auto__);

return statearr_20583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20619){
var state_val_20620 = (state_20619[(1)]);
if((state_val_20620 === (1))){
var state_20619__$1 = state_20619;
var statearr_20621_20635 = state_20619__$1;
(statearr_20621_20635[(2)] = null);

(statearr_20621_20635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20620 === (2))){
var _ = (function (){var statearr_20622 = state_20619;
(statearr_20622[(4)] = cljs.core.cons((5),(state_20619[(4)])));

return statearr_20622;
})();
var inst_20602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20603 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_20604 = (new cljs.core.PersistentVector(null,3,(5),inst_20602,inst_20603,null));
var inst_20605 = cljs.core.select_keys(block_data,inst_20604);
var inst_20606 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_20605);
var inst_20607 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_20606);
var inst_20608 = [inst_20607,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_20609 = fluree.db.storage.core.serde(conn);
var inst_20610 = fluree.db.serde.protocol._serialize_block(inst_20609,inst_20605);
var inst_20611 = fluree.db.storage.core.storage_write(conn,inst_20608,inst_20610);
var state_20619__$1 = state_20619;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20619__$1,(6),inst_20611);
} else {
if((state_val_20620 === (3))){
var inst_20617 = (state_20619[(2)]);
var state_20619__$1 = state_20619;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20619__$1,inst_20617);
} else {
if((state_val_20620 === (4))){
var inst_20596 = (state_20619[(2)]);
var state_20619__$1 = state_20619;
var statearr_20624_20636 = state_20619__$1;
(statearr_20624_20636[(2)] = inst_20596);

(statearr_20624_20636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20620 === (5))){
var _ = (function (){var statearr_20625 = state_20619;
(statearr_20625[(4)] = cljs.core.rest((state_20619[(4)])));

return statearr_20625;
})();
var state_20619__$1 = state_20619;
var ex20623 = (state_20619__$1[(2)]);
var statearr_20626_20637 = state_20619__$1;
(statearr_20626_20637[(5)] = ex20623);


if((ex20623 instanceof Error)){
var statearr_20627_20638 = state_20619__$1;
(statearr_20627_20638[(1)] = (4));

(statearr_20627_20638[(5)] = null);

} else {
throw ex20623;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20620 === (6))){
var inst_20613 = (state_20619[(2)]);
var inst_20614 = fluree.db.util.async.throw_err(inst_20613);
var _ = (function (){var statearr_20628 = state_20619;
(statearr_20628[(4)] = cljs.core.rest((state_20619[(4)])));

return statearr_20628;
})();
var state_20619__$1 = state_20619;
var statearr_20629_20639 = state_20619__$1;
(statearr_20629_20639[(2)] = inst_20614);

(statearr_20629_20639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2733__auto____0 = (function (){
var statearr_20630 = [null,null,null,null,null,null,null];
(statearr_20630[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2733__auto__);

(statearr_20630[(1)] = (1));

return statearr_20630;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2733__auto____1 = (function (state_20619){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20619);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20631){var ex__2736__auto__ = e20631;
var statearr_20632_20640 = state_20619;
(statearr_20632_20640[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20619[(4)]))){
var statearr_20633_20641 = state_20619;
(statearr_20633_20641[(1)] = cljs.core.first((state_20619[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20642 = state_20619;
state_20619 = G__20642;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2733__auto__ = function(state_20619){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2733__auto____1.call(this,state_20619);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2733__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2733__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20634 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20634[(6)] = c__2755__auto__);

return statearr_20634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20665){
var state_val_20666 = (state_20665[(1)]);
if((state_val_20666 === (1))){
var state_20665__$1 = state_20665;
var statearr_20667_20681 = state_20665__$1;
(statearr_20667_20681[(2)] = null);

(statearr_20667_20681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20666 === (2))){
var _ = (function (){var statearr_20668 = state_20665;
(statearr_20668[(4)] = cljs.core.cons((5),(state_20665[(4)])));

return statearr_20668;
})();
var inst_20649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20650 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_20651 = (new cljs.core.PersistentVector(null,3,(5),inst_20649,inst_20650,null));
var inst_20652 = cljs.core.select_keys(block_data,inst_20651);
var inst_20653 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_20652);
var inst_20654 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_20653);
var inst_20655 = fluree.db.storage.core.serde(conn);
var inst_20656 = fluree.db.serde.protocol._serialize_block(inst_20655,inst_20652);
var inst_20657 = fluree.db.storage.core.storage_write(conn,inst_20654,inst_20656);
var state_20665__$1 = state_20665;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20665__$1,(6),inst_20657);
} else {
if((state_val_20666 === (3))){
var inst_20663 = (state_20665[(2)]);
var state_20665__$1 = state_20665;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20665__$1,inst_20663);
} else {
if((state_val_20666 === (4))){
var inst_20643 = (state_20665[(2)]);
var state_20665__$1 = state_20665;
var statearr_20670_20682 = state_20665__$1;
(statearr_20670_20682[(2)] = inst_20643);

(statearr_20670_20682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20666 === (5))){
var _ = (function (){var statearr_20671 = state_20665;
(statearr_20671[(4)] = cljs.core.rest((state_20665[(4)])));

return statearr_20671;
})();
var state_20665__$1 = state_20665;
var ex20669 = (state_20665__$1[(2)]);
var statearr_20672_20683 = state_20665__$1;
(statearr_20672_20683[(5)] = ex20669);


if((ex20669 instanceof Error)){
var statearr_20673_20684 = state_20665__$1;
(statearr_20673_20684[(1)] = (4));

(statearr_20673_20684[(5)] = null);

} else {
throw ex20669;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20666 === (6))){
var inst_20659 = (state_20665[(2)]);
var inst_20660 = fluree.db.util.async.throw_err(inst_20659);
var _ = (function (){var statearr_20674 = state_20665;
(statearr_20674[(4)] = cljs.core.rest((state_20665[(4)])));

return statearr_20674;
})();
var state_20665__$1 = state_20665;
var statearr_20675_20685 = state_20665__$1;
(statearr_20675_20685[(2)] = inst_20660);

(statearr_20675_20685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2733__auto____0 = (function (){
var statearr_20676 = [null,null,null,null,null,null,null];
(statearr_20676[(0)] = fluree$db$storage$core$write_block_$_state_machine__2733__auto__);

(statearr_20676[(1)] = (1));

return statearr_20676;
});
var fluree$db$storage$core$write_block_$_state_machine__2733__auto____1 = (function (state_20665){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20665);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20677){var ex__2736__auto__ = e20677;
var statearr_20678_20686 = state_20665;
(statearr_20678_20686[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20665[(4)]))){
var statearr_20679_20687 = state_20665;
(statearr_20679_20687[(1)] = cljs.core.first((state_20665[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20688 = state_20665;
state_20665 = G__20688;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2733__auto__ = function(state_20665){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2733__auto____1.call(this,state_20665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2733__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2733__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20680 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20680[(6)] = c__2755__auto__);

return statearr_20680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20708){
var state_val_20709 = (state_20708[(1)]);
if((state_val_20709 === (1))){
var state_20708__$1 = state_20708;
var statearr_20710_20724 = state_20708__$1;
(statearr_20710_20724[(2)] = null);

(statearr_20710_20724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20709 === (2))){
var _ = (function (){var statearr_20711 = state_20708;
(statearr_20711[(4)] = cljs.core.cons((5),(state_20708[(4)])));

return statearr_20711;
})();
var inst_20695 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_20696 = [history,next_his_key];
var inst_20697 = cljs.core.PersistentHashMap.fromArrays(inst_20695,inst_20696);
var inst_20698 = fluree.db.storage.core.serde(conn);
var inst_20699 = fluree.db.serde.protocol._serialize_leaf(inst_20698,inst_20697);
var inst_20700 = fluree.db.storage.core.storage_write(conn,his_key,inst_20699);
var state_20708__$1 = state_20708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20708__$1,(6),inst_20700);
} else {
if((state_val_20709 === (3))){
var inst_20706 = (state_20708[(2)]);
var state_20708__$1 = state_20708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20708__$1,inst_20706);
} else {
if((state_val_20709 === (4))){
var inst_20689 = (state_20708[(2)]);
var state_20708__$1 = state_20708;
var statearr_20713_20725 = state_20708__$1;
(statearr_20713_20725[(2)] = inst_20689);

(statearr_20713_20725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20709 === (5))){
var _ = (function (){var statearr_20714 = state_20708;
(statearr_20714[(4)] = cljs.core.rest((state_20708[(4)])));

return statearr_20714;
})();
var state_20708__$1 = state_20708;
var ex20712 = (state_20708__$1[(2)]);
var statearr_20715_20726 = state_20708__$1;
(statearr_20715_20726[(5)] = ex20712);


if((ex20712 instanceof Error)){
var statearr_20716_20727 = state_20708__$1;
(statearr_20716_20727[(1)] = (4));

(statearr_20716_20727[(5)] = null);

} else {
throw ex20712;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20709 === (6))){
var inst_20702 = (state_20708[(2)]);
var inst_20703 = fluree.db.util.async.throw_err(inst_20702);
var _ = (function (){var statearr_20717 = state_20708;
(statearr_20717[(4)] = cljs.core.rest((state_20708[(4)])));

return statearr_20717;
})();
var state_20708__$1 = state_20708;
var statearr_20718_20728 = state_20708__$1;
(statearr_20718_20728[(2)] = inst_20703);

(statearr_20718_20728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2733__auto____0 = (function (){
var statearr_20719 = [null,null,null,null,null,null,null];
(statearr_20719[(0)] = fluree$db$storage$core$write_history_$_state_machine__2733__auto__);

(statearr_20719[(1)] = (1));

return statearr_20719;
});
var fluree$db$storage$core$write_history_$_state_machine__2733__auto____1 = (function (state_20708){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20708);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20720){var ex__2736__auto__ = e20720;
var statearr_20721_20729 = state_20708;
(statearr_20721_20729[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20708[(4)]))){
var statearr_20722_20730 = state_20708;
(statearr_20722_20730[(1)] = cljs.core.first((state_20708[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20731 = state_20708;
state_20708 = G__20731;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2733__auto__ = function(state_20708){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2733__auto____1.call(this,state_20708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2733__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2733__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20723 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20723[(6)] = c__2755__auto__);

return statearr_20723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20757){
var state_val_20758 = (state_20757[(1)]);
if((state_val_20758 === (1))){
var state_20757__$1 = state_20757;
var statearr_20759_20776 = state_20757__$1;
(statearr_20759_20776[(2)] = null);

(statearr_20759_20776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (2))){
var inst_20738 = (state_20757[(7)]);
var _ = (function (){var statearr_20760 = state_20757;
(statearr_20760[(4)] = cljs.core.cons((5),(state_20757[(4)])));

return statearr_20760;
})();
var inst_20738__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_20739 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20738__$1),"-his"].join('');
var inst_20740 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_20741 = [flakes,inst_20739];
var inst_20742 = cljs.core.PersistentHashMap.fromArrays(inst_20740,inst_20741);
var inst_20743 = fluree.db.storage.core.serde(conn);
var inst_20744 = fluree.db.serde.protocol._serialize_leaf(inst_20743,inst_20742);
var inst_20745 = fluree.db.storage.core.write_history(conn,history,inst_20739,null);
var inst_20746 = fluree.db.storage.core.storage_write(conn,inst_20738__$1,inst_20744);
var state_20757__$1 = (function (){var statearr_20761 = state_20757;
(statearr_20761[(8)] = inst_20746);

(statearr_20761[(7)] = inst_20738__$1);

return statearr_20761;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20757__$1,(6),inst_20745);
} else {
if((state_val_20758 === (3))){
var inst_20755 = (state_20757[(2)]);
var state_20757__$1 = state_20757;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20757__$1,inst_20755);
} else {
if((state_val_20758 === (4))){
var inst_20732 = (state_20757[(2)]);
var state_20757__$1 = state_20757;
var statearr_20763_20777 = state_20757__$1;
(statearr_20763_20777[(2)] = inst_20732);

(statearr_20763_20777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (5))){
var _ = (function (){var statearr_20764 = state_20757;
(statearr_20764[(4)] = cljs.core.rest((state_20757[(4)])));

return statearr_20764;
})();
var state_20757__$1 = state_20757;
var ex20762 = (state_20757__$1[(2)]);
var statearr_20765_20778 = state_20757__$1;
(statearr_20765_20778[(5)] = ex20762);


if((ex20762 instanceof Error)){
var statearr_20766_20779 = state_20757__$1;
(statearr_20766_20779[(1)] = (4));

(statearr_20766_20779[(5)] = null);

} else {
throw ex20762;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20758 === (6))){
var inst_20746 = (state_20757[(8)]);
var inst_20748 = (state_20757[(2)]);
var inst_20749 = fluree.db.util.async.throw_err(inst_20748);
var state_20757__$1 = (function (){var statearr_20767 = state_20757;
(statearr_20767[(9)] = inst_20749);

return statearr_20767;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20757__$1,(7),inst_20746);
} else {
if((state_val_20758 === (7))){
var inst_20738 = (state_20757[(7)]);
var inst_20751 = (state_20757[(2)]);
var inst_20752 = fluree.db.util.async.throw_err(inst_20751);
var _ = (function (){var statearr_20768 = state_20757;
(statearr_20768[(4)] = cljs.core.rest((state_20757[(4)])));

return statearr_20768;
})();
var state_20757__$1 = (function (){var statearr_20769 = state_20757;
(statearr_20769[(10)] = inst_20752);

return statearr_20769;
})();
var statearr_20770_20780 = state_20757__$1;
(statearr_20770_20780[(2)] = inst_20738);

(statearr_20770_20780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2733__auto____0 = (function (){
var statearr_20771 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20771[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2733__auto__);

(statearr_20771[(1)] = (1));

return statearr_20771;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2733__auto____1 = (function (state_20757){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20757);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20772){var ex__2736__auto__ = e20772;
var statearr_20773_20781 = state_20757;
(statearr_20773_20781[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20757[(4)]))){
var statearr_20774_20782 = state_20757;
(statearr_20774_20782[(1)] = cljs.core.first((state_20757[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20783 = state_20757;
state_20757 = G__20783;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2733__auto__ = function(state_20757){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2733__auto____1.call(this,state_20757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2733__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2733__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20775 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20775[(6)] = c__2755__auto__);

return statearr_20775;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20800){
var state_val_20801 = (state_20800[(1)]);
if((state_val_20801 === (1))){
var state_20800__$1 = state_20800;
var statearr_20802_20817 = state_20800__$1;
(statearr_20802_20817[(2)] = null);

(statearr_20802_20817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20801 === (2))){
var _ = (function (){var statearr_20803 = state_20800;
(statearr_20803[(4)] = cljs.core.cons((5),(state_20800[(4)])));

return statearr_20803;
})();
var inst_20790 = fluree.db.storage.core.serde(conn);
var inst_20791 = fluree.db.serde.protocol._serialize_branch(inst_20790,data);
var inst_20792 = fluree.db.storage.core.storage_write(conn,key,inst_20791);
var state_20800__$1 = state_20800;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20800__$1,(6),inst_20792);
} else {
if((state_val_20801 === (3))){
var inst_20798 = (state_20800[(2)]);
var state_20800__$1 = state_20800;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20800__$1,inst_20798);
} else {
if((state_val_20801 === (4))){
var inst_20784 = (state_20800[(2)]);
var state_20800__$1 = state_20800;
var statearr_20805_20818 = state_20800__$1;
(statearr_20805_20818[(2)] = inst_20784);

(statearr_20805_20818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20801 === (5))){
var _ = (function (){var statearr_20806 = state_20800;
(statearr_20806[(4)] = cljs.core.rest((state_20800[(4)])));

return statearr_20806;
})();
var state_20800__$1 = state_20800;
var ex20804 = (state_20800__$1[(2)]);
var statearr_20807_20819 = state_20800__$1;
(statearr_20807_20819[(5)] = ex20804);


if((ex20804 instanceof Error)){
var statearr_20808_20820 = state_20800__$1;
(statearr_20808_20820[(1)] = (4));

(statearr_20808_20820[(5)] = null);

} else {
throw ex20804;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20801 === (6))){
var inst_20794 = (state_20800[(2)]);
var inst_20795 = fluree.db.util.async.throw_err(inst_20794);
var _ = (function (){var statearr_20809 = state_20800;
(statearr_20809[(4)] = cljs.core.rest((state_20800[(4)])));

return statearr_20809;
})();
var state_20800__$1 = (function (){var statearr_20810 = state_20800;
(statearr_20810[(7)] = inst_20795);

return statearr_20810;
})();
var statearr_20811_20821 = state_20800__$1;
(statearr_20811_20821[(2)] = key);

(statearr_20811_20821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto____0 = (function (){
var statearr_20812 = [null,null,null,null,null,null,null,null];
(statearr_20812[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto__);

(statearr_20812[(1)] = (1));

return statearr_20812;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto____1 = (function (state_20800){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20800);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20813){var ex__2736__auto__ = e20813;
var statearr_20814_20822 = state_20800;
(statearr_20814_20822[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20800[(4)]))){
var statearr_20815_20823 = state_20800;
(statearr_20815_20823[(1)] = cljs.core.first((state_20800[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20824 = state_20800;
state_20800 = G__20824;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto__ = function(state_20800){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto____1.call(this,state_20800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20816 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20816[(6)] = c__2755__auto__);

return statearr_20816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__20825_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__20825_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__20826){
var map__20827 = p__20826;
var map__20827__$1 = cljs.core.__destructure_map(map__20827);
var progress = map__20827__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20827__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20855){
var state_val_20856 = (state_20855[(1)]);
if((state_val_20856 === (1))){
var state_20855__$1 = state_20855;
var statearr_20857_20873 = state_20855__$1;
(statearr_20857_20873[(2)] = null);

(statearr_20857_20873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20856 === (2))){
var inst_20841 = (state_20855[(7)]);
var _ = (function (){var statearr_20858 = state_20855;
(statearr_20858[(4)] = cljs.core.cons((5),(state_20855[(4)])));

return statearr_20858;
})();
var inst_20835 = db;
var inst_20836 = cljs.core.__destructure_map(inst_20835);
var inst_20837 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20836,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_20838 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20836,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_20839 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20836,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_20840 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20836,new cljs.core.Keyword(null,"block","block",664686210));
var inst_20841__$1 = fluree.db.storage.core.ledger_garbage_key(inst_20838,inst_20839,inst_20840);
var inst_20842 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_20843 = [inst_20839,inst_20840,garbage];
var inst_20844 = cljs.core.PersistentHashMap.fromArrays(inst_20842,inst_20843);
var inst_20845 = fluree.db.storage.core.serde(inst_20837);
var inst_20846 = fluree.db.serde.protocol._serialize_garbage(inst_20845,inst_20844);
var inst_20847 = fluree.db.storage.core.storage_write(inst_20837,inst_20841__$1,inst_20846);
var state_20855__$1 = (function (){var statearr_20859 = state_20855;
(statearr_20859[(7)] = inst_20841__$1);

return statearr_20859;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20855__$1,(6),inst_20847);
} else {
if((state_val_20856 === (3))){
var inst_20853 = (state_20855[(2)]);
var state_20855__$1 = state_20855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20855__$1,inst_20853);
} else {
if((state_val_20856 === (4))){
var inst_20828 = (state_20855[(2)]);
var state_20855__$1 = state_20855;
var statearr_20861_20874 = state_20855__$1;
(statearr_20861_20874[(2)] = inst_20828);

(statearr_20861_20874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20856 === (5))){
var _ = (function (){var statearr_20862 = state_20855;
(statearr_20862[(4)] = cljs.core.rest((state_20855[(4)])));

return statearr_20862;
})();
var state_20855__$1 = state_20855;
var ex20860 = (state_20855__$1[(2)]);
var statearr_20863_20875 = state_20855__$1;
(statearr_20863_20875[(5)] = ex20860);


if((ex20860 instanceof Error)){
var statearr_20864_20876 = state_20855__$1;
(statearr_20864_20876[(1)] = (4));

(statearr_20864_20876[(5)] = null);

} else {
throw ex20860;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20856 === (6))){
var inst_20841 = (state_20855[(7)]);
var inst_20849 = (state_20855[(2)]);
var inst_20850 = fluree.db.util.async.throw_err(inst_20849);
var _ = (function (){var statearr_20865 = state_20855;
(statearr_20865[(4)] = cljs.core.rest((state_20855[(4)])));

return statearr_20865;
})();
var state_20855__$1 = (function (){var statearr_20866 = state_20855;
(statearr_20866[(8)] = inst_20850);

return statearr_20866;
})();
var statearr_20867_20877 = state_20855__$1;
(statearr_20867_20877[(2)] = inst_20841);

(statearr_20867_20877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2733__auto____0 = (function (){
var statearr_20868 = [null,null,null,null,null,null,null,null,null];
(statearr_20868[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2733__auto__);

(statearr_20868[(1)] = (1));

return statearr_20868;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2733__auto____1 = (function (state_20855){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20855);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20869){var ex__2736__auto__ = e20869;
var statearr_20870_20878 = state_20855;
(statearr_20870_20878[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20855[(4)]))){
var statearr_20871_20879 = state_20855;
(statearr_20871_20879[(1)] = cljs.core.first((state_20855[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20880 = state_20855;
state_20855 = G__20880;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2733__auto__ = function(state_20855){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2733__auto____1.call(this,state_20855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2733__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2733__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20872 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20872[(6)] = c__2755__auto__);

return statearr_20872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__20882 = arguments.length;
switch (G__20882) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_20938){
var state_val_20939 = (state_20938[(1)]);
if((state_val_20939 === (7))){
var state_20938__$1 = state_20938;
var statearr_20940_20966 = state_20938__$1;
(statearr_20940_20966[(2)] = (0));

(statearr_20940_20966[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20939 === (1))){
var state_20938__$1 = state_20938;
var statearr_20941_20967 = state_20938__$1;
(statearr_20941_20967[(2)] = null);

(statearr_20941_20967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20939 === (4))){
var inst_20883 = (state_20938[(2)]);
var state_20938__$1 = state_20938;
var statearr_20942_20968 = state_20938__$1;
(statearr_20942_20968[(2)] = inst_20883);

(statearr_20942_20968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20939 === (6))){
var inst_20908 = (state_20938[(7)]);
var state_20938__$1 = state_20938;
var statearr_20943_20969 = state_20938__$1;
(statearr_20943_20969[(2)] = inst_20908);

(statearr_20943_20969[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20939 === (3))){
var inst_20936 = (state_20938[(2)]);
var state_20938__$1 = state_20938;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20938__$1,inst_20936);
} else {
if((state_val_20939 === (12))){
var inst_20905 = (state_20938[(8)]);
var inst_20932 = (state_20938[(2)]);
var inst_20933 = fluree.db.util.async.throw_err(inst_20932);
var _ = (function (){var statearr_20944 = state_20938;
(statearr_20944[(4)] = cljs.core.rest((state_20938[(4)])));

return statearr_20944;
})();
var state_20938__$1 = (function (){var statearr_20945 = state_20938;
(statearr_20945[(9)] = inst_20933);

return statearr_20945;
})();
var statearr_20946_20970 = state_20938__$1;
(statearr_20946_20970[(2)] = inst_20905);

(statearr_20946_20970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20939 === (2))){
var inst_20896 = (state_20938[(10)]);
var inst_20900 = (state_20938[(11)]);
var inst_20908 = (state_20938[(7)]);
var inst_20898 = (state_20938[(12)]);
var _ = (function (){var statearr_20947 = state_20938;
(statearr_20947[(4)] = cljs.core.cons((5),(state_20938[(4)])));

return statearr_20947;
})();
var inst_20890 = db;
var inst_20891 = cljs.core.__destructure_map(inst_20890);
var inst_20892 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20891,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_20893 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20891,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_20894 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20891,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_20895 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20891,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_20896__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20891,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_20897 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20891,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_20898__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20891,new cljs.core.Keyword(null,"block","block",664686210));
var inst_20899 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20891,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_20900__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20891,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_20901 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20891,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_20902 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20891,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_20903 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20891,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_20904 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20891,new cljs.core.Keyword(null,"post","post",269697687));
var inst_20905 = fluree.db.storage.core.ledger_root_key(inst_20892,inst_20900__$1,inst_20898__$1);
var inst_20906 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_20907 = fluree.db.storage.core.child_data(inst_20899);
var inst_20908__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_20896__$1);
var state_20938__$1 = (function (){var statearr_20948 = state_20938;
(statearr_20948[(13)] = inst_20897);

(statearr_20948[(14)] = inst_20903);

(statearr_20948[(8)] = inst_20905);

(statearr_20948[(10)] = inst_20896__$1);

(statearr_20948[(11)] = inst_20900__$1);

(statearr_20948[(15)] = inst_20904);

(statearr_20948[(16)] = inst_20895);

(statearr_20948[(17)] = inst_20893);

(statearr_20948[(18)] = inst_20902);

(statearr_20948[(19)] = inst_20906);

(statearr_20948[(20)] = inst_20894);

(statearr_20948[(21)] = inst_20901);

(statearr_20948[(22)] = inst_20907);

(statearr_20948[(7)] = inst_20908__$1);

(statearr_20948[(12)] = inst_20898__$1);

return statearr_20948;
})();
if(cljs.core.truth_(inst_20908__$1)){
var statearr_20949_20971 = state_20938__$1;
(statearr_20949_20971[(1)] = (6));

} else {
var statearr_20950_20972 = state_20938__$1;
(statearr_20950_20972[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20939 === (11))){
var inst_20897 = (state_20938[(13)]);
var inst_20903 = (state_20938[(14)]);
var inst_20905 = (state_20938[(8)]);
var inst_20896 = (state_20938[(10)]);
var inst_20900 = (state_20938[(11)]);
var inst_20904 = (state_20938[(15)]);
var inst_20895 = (state_20938[(16)]);
var inst_20893 = (state_20938[(17)]);
var inst_20912 = (state_20938[(23)]);
var inst_20902 = (state_20938[(18)]);
var inst_20906 = (state_20938[(19)]);
var inst_20894 = (state_20938[(20)]);
var inst_20907 = (state_20938[(22)]);
var inst_20898 = (state_20938[(12)]);
var inst_20917 = (state_20938[(2)]);
var inst_20918 = fluree.db.storage.core.child_data(inst_20902);
var inst_20919 = fluree.db.storage.core.child_data(inst_20904);
var inst_20920 = fluree.db.util.core.current_time_millis();
var inst_20921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20922 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_20923 = (new cljs.core.PersistentVector(null,2,(5),inst_20921,inst_20922,null));
var inst_20924 = cljs.core.select_keys(inst_20896,inst_20923);
var inst_20925 = fluree.db.storage.core.child_data(inst_20895);
var inst_20926 = [inst_20898,inst_20907,inst_20900,inst_20912,inst_20917,inst_20918,inst_20919,inst_20893,inst_20920,inst_20894,inst_20903,inst_20924,inst_20925];
var inst_20927 = cljs.core.PersistentHashMap.fromArrays(inst_20906,inst_20926);
var inst_20928 = fluree.db.storage.core.serde(inst_20897);
var inst_20929 = fluree.db.serde.protocol._serialize_db_root(inst_20928,inst_20927);
var inst_20930 = fluree.db.storage.core.storage_write(inst_20897,inst_20905,inst_20929);
var state_20938__$1 = state_20938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20938__$1,(12),inst_20930);
} else {
if((state_val_20939 === (9))){
var inst_20913 = (state_20938[(24)]);
var state_20938__$1 = state_20938;
var statearr_20952_20973 = state_20938__$1;
(statearr_20952_20973[(2)] = inst_20913);

(statearr_20952_20973[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20939 === (5))){
var _ = (function (){var statearr_20953 = state_20938;
(statearr_20953[(4)] = cljs.core.rest((state_20938[(4)])));

return statearr_20953;
})();
var state_20938__$1 = state_20938;
var ex20951 = (state_20938__$1[(2)]);
var statearr_20954_20974 = state_20938__$1;
(statearr_20954_20974[(5)] = ex20951);


if((ex20951 instanceof Error)){
var statearr_20955_20975 = state_20938__$1;
(statearr_20955_20975[(1)] = (4));

(statearr_20955_20975[(5)] = null);

} else {
throw ex20951;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20939 === (10))){
var inst_20901 = (state_20938[(21)]);
var state_20938__$1 = state_20938;
var statearr_20956_20976 = state_20938__$1;
(statearr_20956_20976[(2)] = inst_20901);

(statearr_20956_20976[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20939 === (8))){
var inst_20913 = (state_20938[(24)]);
var inst_20912 = (state_20938[(2)]);
var inst_20913__$1 = custom_ecount;
var state_20938__$1 = (function (){var statearr_20957 = state_20938;
(statearr_20957[(24)] = inst_20913__$1);

(statearr_20957[(23)] = inst_20912);

return statearr_20957;
})();
if(cljs.core.truth_(inst_20913__$1)){
var statearr_20958_20977 = state_20938__$1;
(statearr_20958_20977[(1)] = (9));

} else {
var statearr_20959_20978 = state_20938__$1;
(statearr_20959_20978[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2733__auto__ = null;
var fluree$db$storage$core$state_machine__2733__auto____0 = (function (){
var statearr_20960 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20960[(0)] = fluree$db$storage$core$state_machine__2733__auto__);

(statearr_20960[(1)] = (1));

return statearr_20960;
});
var fluree$db$storage$core$state_machine__2733__auto____1 = (function (state_20938){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_20938);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e20961){var ex__2736__auto__ = e20961;
var statearr_20962_20979 = state_20938;
(statearr_20962_20979[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_20938[(4)]))){
var statearr_20963_20980 = state_20938;
(statearr_20963_20980[(1)] = cljs.core.first((state_20938[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20981 = state_20938;
state_20938 = G__20981;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2733__auto__ = function(state_20938){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2733__auto____1.call(this,state_20938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2733__auto____0;
fluree$db$storage$core$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2733__auto____1;
return fluree$db$storage$core$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_20964 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_20964[(6)] = c__2755__auto__);

return statearr_20964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___21040 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21014){
var state_val_21015 = (state_21014[(1)]);
if((state_val_21015 === (7))){
var inst_20994 = (state_21014[(7)]);
var state_21014__$1 = state_21014;
var statearr_21016_21041 = state_21014__$1;
(statearr_21016_21041[(2)] = inst_20994);

(statearr_21016_21041[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21015 === (1))){
var state_21014__$1 = state_21014;
var statearr_21017_21042 = state_21014__$1;
(statearr_21017_21042[(2)] = null);

(statearr_21017_21042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21015 === (4))){
var inst_20982 = (state_21014[(2)]);
var inst_20983 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_20984 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_20982);
var inst_20985 = cljs.core.async.close_BANG_(return_ch);
var state_21014__$1 = (function (){var statearr_21018 = state_21014;
(statearr_21018[(8)] = inst_20984);

(statearr_21018[(9)] = inst_20983);

return statearr_21018;
})();
var statearr_21019_21043 = state_21014__$1;
(statearr_21019_21043[(2)] = inst_20985);

(statearr_21019_21043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21015 === (6))){
var inst_20994 = (state_21014[(7)]);
var inst_20993 = (state_21014[(10)]);
var inst_20993__$1 = (state_21014[(2)]);
var inst_20994__$1 = (inst_20993__$1 == null);
var state_21014__$1 = (function (){var statearr_21020 = state_21014;
(statearr_21020[(7)] = inst_20994__$1);

(statearr_21020[(10)] = inst_20993__$1);

return statearr_21020;
})();
if(cljs.core.truth_(inst_20994__$1)){
var statearr_21021_21044 = state_21014__$1;
(statearr_21021_21044[(1)] = (7));

} else {
var statearr_21022_21045 = state_21014__$1;
(statearr_21022_21045[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21015 === (3))){
var inst_21012 = (state_21014[(2)]);
var state_21014__$1 = state_21014;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21014__$1,inst_21012);
} else {
if((state_val_21015 === (12))){
var inst_21009 = (state_21014[(2)]);
var _ = (function (){var statearr_21023 = state_21014;
(statearr_21023[(4)] = cljs.core.rest((state_21014[(4)])));

return statearr_21023;
})();
var state_21014__$1 = state_21014;
var statearr_21024_21046 = state_21014__$1;
(statearr_21024_21046[(2)] = inst_21009);

(statearr_21024_21046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21015 === (2))){
var _ = (function (){var statearr_21025 = state_21014;
(statearr_21025[(4)] = cljs.core.cons((5),(state_21014[(4)])));

return statearr_21025;
})();
var inst_20991 = fluree.db.storage.core.storage_read(conn,key);
var state_21014__$1 = state_21014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21014__$1,(6),inst_20991);
} else {
if((state_val_21015 === (11))){
var inst_20993 = (state_21014[(10)]);
var inst_21003 = fluree.db.storage.core.serde(conn);
var inst_21004 = fluree.db.serde.protocol._deserialize_leaf(inst_21003,inst_20993);
var inst_21005 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_21004);
var inst_21006 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_21005);
var inst_21007 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_21006);
var state_21014__$1 = state_21014;
var statearr_21027_21047 = state_21014__$1;
(statearr_21027_21047[(2)] = inst_21007);

(statearr_21027_21047[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21015 === (9))){
var inst_20999 = (state_21014[(2)]);
var state_21014__$1 = state_21014;
if(cljs.core.truth_(inst_20999)){
var statearr_21028_21048 = state_21014__$1;
(statearr_21028_21048[(1)] = (10));

} else {
var statearr_21029_21049 = state_21014__$1;
(statearr_21029_21049[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21015 === (5))){
var _ = (function (){var statearr_21030 = state_21014;
(statearr_21030[(4)] = cljs.core.rest((state_21014[(4)])));

return statearr_21030;
})();
var state_21014__$1 = state_21014;
var ex21026 = (state_21014__$1[(2)]);
var statearr_21031_21050 = state_21014__$1;
(statearr_21031_21050[(5)] = ex21026);


var statearr_21032_21051 = state_21014__$1;
(statearr_21032_21051[(1)] = (4));

(statearr_21032_21051[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21015 === (10))){
var inst_21001 = cljs.core.async.close_BANG_(return_ch);
var state_21014__$1 = state_21014;
var statearr_21033_21052 = state_21014__$1;
(statearr_21033_21052[(2)] = inst_21001);

(statearr_21033_21052[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21015 === (8))){
var inst_20993 = (state_21014[(10)]);
var inst_20997 = (inst_20993 instanceof Error);
var state_21014__$1 = state_21014;
var statearr_21034_21053 = state_21014__$1;
(statearr_21034_21053[(2)] = inst_20997);

(statearr_21034_21053[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2733__auto____0 = (function (){
var statearr_21035 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21035[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2733__auto__);

(statearr_21035[(1)] = (1));

return statearr_21035;
});
var fluree$db$storage$core$reify_history_$_state_machine__2733__auto____1 = (function (state_21014){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21014);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21036){var ex__2736__auto__ = e21036;
var statearr_21037_21054 = state_21014;
(statearr_21037_21054[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21014[(4)]))){
var statearr_21038_21055 = state_21014;
(statearr_21038_21055[(1)] = cljs.core.first((state_21014[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21056 = state_21014;
state_21014 = G__21056;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2733__auto__ = function(state_21014){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2733__auto____1.call(this,state_21014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2733__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2733__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21039 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21039[(6)] = c__2755__auto___21040);

return statearr_21039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__21058 = arguments.length;
switch (G__21058) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4221__auto__ = (rhs == null);
if(and__4221__auto__){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___21170 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21121){
var state_val_21122 = (state_21121[(1)]);
if((state_val_21122 === (7))){
var state_21121__$1 = state_21121;
var statearr_21123_21171 = state_21121__$1;
(statearr_21123_21171[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_21123_21171[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (20))){
var inst_21100 = cljs.core.PersistentVector.EMPTY;
var state_21121__$1 = state_21121;
var statearr_21124_21172 = state_21121__$1;
(statearr_21124_21172[(2)] = inst_21100);

(statearr_21124_21172[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (1))){
var state_21121__$1 = state_21121;
var statearr_21125_21173 = state_21121__$1;
(statearr_21125_21173[(2)] = null);

(statearr_21125_21173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (24))){
var state_21121__$1 = state_21121;
var statearr_21126_21174 = state_21121__$1;
(statearr_21126_21174[(2)] = null);

(statearr_21126_21174[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (4))){
var inst_21061 = (state_21121[(2)]);
var inst_21062 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_21063 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_21061);
var inst_21064 = cljs.core.async.close_BANG_(result_ch);
var state_21121__$1 = (function (){var statearr_21127 = state_21121;
(statearr_21127[(7)] = inst_21063);

(statearr_21127[(8)] = inst_21062);

return statearr_21127;
})();
var statearr_21128_21175 = state_21121__$1;
(statearr_21128_21175[(2)] = inst_21064);

(statearr_21128_21175[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (15))){
var inst_21086 = (state_21121[(2)]);
var state_21121__$1 = state_21121;
var statearr_21129_21176 = state_21121__$1;
(statearr_21129_21176[(2)] = inst_21086);

(statearr_21129_21176[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (21))){
var inst_21073 = (state_21121[(9)]);
var inst_21103 = (state_21121[(10)]);
var inst_21090 = (state_21121[(11)]);
var inst_21074 = (state_21121[(12)]);
var inst_21075 = (state_21121[(13)]);
var inst_21110 = (state_21121[(2)]);
var inst_21111 = (function (){var base_node = inst_21073;
var first_flake = inst_21074;
var node_t = inst_21075;
var source = inst_21090;
var coll = inst_21103;
var conj_QMARK_ = inst_21110;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__21131 = f.p;
var fexpr__21130 = (function (){var or__4223__auto__ = remove_preds;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__21130.cljs$core$IFn$_invoke$arity$1 ? fexpr__21130.cljs$core$IFn$_invoke$arity$1(G__21131) : fexpr__21130.call(null,G__21131));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_21112 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_21073);
var inst_21113 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_21111,inst_21112,inst_21103);
var inst_21114 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_21113);
var inst_21115 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21073,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_21114);
var inst_21116 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_21115);
var _ = (function (){var statearr_21132 = state_21121;
(statearr_21132[(4)] = cljs.core.rest((state_21121[(4)])));

return statearr_21132;
})();
var state_21121__$1 = state_21121;
var statearr_21133_21177 = state_21121__$1;
(statearr_21133_21177[(2)] = inst_21116);

(statearr_21133_21177[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (13))){
var state_21121__$1 = state_21121;
var statearr_21134_21178 = state_21121__$1;
(statearr_21134_21178[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_21134_21178[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (22))){
var inst_21073 = (state_21121[(9)]);
var inst_21103 = (state_21121[(10)]);
var inst_21090 = (state_21121[(11)]);
var inst_21074 = (state_21121[(12)]);
var inst_21075 = (state_21121[(13)]);
var inst_21104 = (function (){var base_node = inst_21073;
var first_flake = inst_21074;
var node_t = inst_21075;
var source = inst_21090;
var coll = inst_21103;
return (function (f){
return f.op === true;
});
})();
var state_21121__$1 = state_21121;
var statearr_21135_21179 = state_21121__$1;
(statearr_21135_21179[(2)] = inst_21104);

(statearr_21135_21179[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (6))){
var inst_21073 = (state_21121[(9)]);
var inst_21075 = (state_21121[(13)]);
var inst_21072 = (state_21121[(2)]);
var inst_21073__$1 = fluree.db.util.async.throw_err(inst_21072);
var inst_21074 = fluree.db.dbproto._first_flake(inst_21073__$1);
var inst_21075__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_21073__$1);
var inst_21076 = (inst_21075__$1 > t);
var state_21121__$1 = (function (){var statearr_21136 = state_21121;
(statearr_21136[(9)] = inst_21073__$1);

(statearr_21136[(12)] = inst_21074);

(statearr_21136[(13)] = inst_21075__$1);

return statearr_21136;
})();
if(cljs.core.truth_(inst_21076)){
var statearr_21137_21180 = state_21121__$1;
(statearr_21137_21180[(1)] = (7));

} else {
var statearr_21138_21181 = state_21121__$1;
(statearr_21138_21181[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (17))){
var inst_21074 = (state_21121[(12)]);
var inst_21091 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_21074,rhs,leftmost_QMARK_,t);
var state_21121__$1 = state_21121;
var statearr_21139_21182 = state_21121__$1;
(statearr_21139_21182[(2)] = inst_21091);

(statearr_21139_21182[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (3))){
var inst_21119 = (state_21121[(2)]);
var state_21121__$1 = state_21121;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21121__$1,inst_21119);
} else {
if((state_val_21122 === (12))){
var inst_21088 = (state_21121[(2)]);
var state_21121__$1 = state_21121;
var statearr_21140_21183 = state_21121__$1;
(statearr_21140_21183[(2)] = inst_21088);

(statearr_21140_21183[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (2))){
var _ = (function (){var statearr_21141 = state_21121;
(statearr_21141[(4)] = cljs.core.cons((5),(state_21121[(4)])));

return statearr_21141;
})();
var inst_21070 = fluree.db.dbproto._resolve(node);
var state_21121__$1 = state_21121;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21121__$1,(6),inst_21070);
} else {
if((state_val_21122 === (23))){
var inst_21073 = (state_21121[(9)]);
var inst_21103 = (state_21121[(10)]);
var inst_21090 = (state_21121[(11)]);
var inst_21074 = (state_21121[(12)]);
var inst_21075 = (state_21121[(13)]);
var inst_21106 = (function (){var base_node = inst_21073;
var first_flake = inst_21074;
var node_t = inst_21075;
var source = inst_21090;
var coll = inst_21103;
return (function (f){
return f.op === false;
});
})();
var state_21121__$1 = state_21121;
var statearr_21142_21184 = state_21121__$1;
(statearr_21142_21184[(2)] = inst_21106);

(statearr_21142_21184[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (19))){
var inst_21093 = (state_21121[(14)]);
var inst_21096 = (state_21121[(2)]);
var inst_21097 = fluree.db.util.async.throw_err(inst_21096);
var inst_21098 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_21093,inst_21097);
var state_21121__$1 = state_21121;
var statearr_21143_21185 = state_21121__$1;
(statearr_21143_21185[(2)] = inst_21098);

(statearr_21143_21185[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (11))){
var inst_21075 = (state_21121[(13)]);
var inst_21082 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21075,t);
var state_21121__$1 = state_21121;
if(inst_21082){
var statearr_21145_21186 = state_21121__$1;
(statearr_21145_21186[(1)] = (13));

} else {
var statearr_21146_21187 = state_21121__$1;
(statearr_21146_21187[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (9))){
var inst_21090 = (state_21121[(11)]);
var inst_21090__$1 = (state_21121[(2)]);
var state_21121__$1 = (function (){var statearr_21147 = state_21121;
(statearr_21147[(11)] = inst_21090__$1);

return statearr_21147;
})();
var G__21148_21188 = inst_21090__$1;
var G__21148_21189__$1 = (((G__21148_21188 instanceof cljs.core.Keyword))?G__21148_21188.fqn:null);
switch (G__21148_21189__$1) {
case "novelty":
var statearr_21149_21191 = state_21121__$1;
(statearr_21149_21191[(1)] = (17));


break;
case "history":
var statearr_21150_21192 = state_21121__$1;
(statearr_21150_21192[(1)] = (18));


break;
case "none":
var statearr_21151_21193 = state_21121__$1;
(statearr_21151_21193[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__21148_21189__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (5))){
var _ = (function (){var statearr_21152 = state_21121;
(statearr_21152[(4)] = cljs.core.rest((state_21121[(4)])));

return statearr_21152;
})();
var state_21121__$1 = state_21121;
var ex21144 = (state_21121__$1[(2)]);
var statearr_21153_21194 = state_21121__$1;
(statearr_21153_21194[(5)] = ex21144);


var statearr_21154_21195 = state_21121__$1;
(statearr_21154_21195[(1)] = (4));

(statearr_21154_21195[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (14))){
var state_21121__$1 = state_21121;
var statearr_21155_21196 = state_21121__$1;
(statearr_21155_21196[(2)] = null);

(statearr_21155_21196[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (16))){
var inst_21090 = (state_21121[(11)]);
var inst_21103 = (state_21121[(2)]);
var state_21121__$1 = (function (){var statearr_21156 = state_21121;
(statearr_21156[(10)] = inst_21103);

return statearr_21156;
})();
var G__21157_21197 = inst_21090;
var G__21157_21198__$1 = (((G__21157_21197 instanceof cljs.core.Keyword))?G__21157_21197.fqn:null);
switch (G__21157_21198__$1) {
case "novelty":
var statearr_21158_21200 = state_21121__$1;
(statearr_21158_21200[(1)] = (22));


break;
case "history":
var statearr_21159_21201 = state_21121__$1;
(statearr_21159_21201[(1)] = (23));


break;
case "none":
var statearr_21160_21202 = state_21121__$1;
(statearr_21160_21202[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__21157_21198__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (10))){
var state_21121__$1 = state_21121;
var statearr_21161_21203 = state_21121__$1;
(statearr_21161_21203[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_21161_21203[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (18))){
var inst_21073 = (state_21121[(9)]);
var inst_21090 = (state_21121[(11)]);
var inst_21074 = (state_21121[(12)]);
var inst_21075 = (state_21121[(13)]);
var inst_21093 = (function (){var base_node = inst_21073;
var first_flake = inst_21074;
var node_t = inst_21075;
var source = inst_21090;
return (function (p1__21060_SHARP_){
return (p1__21060_SHARP_.t <= t);
});
})();
var inst_21094 = fluree.db.dbproto._resolve_history(node);
var state_21121__$1 = (function (){var statearr_21162 = state_21121;
(statearr_21162[(14)] = inst_21093);

return statearr_21162;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21121__$1,(19),inst_21094);
} else {
if((state_val_21122 === (8))){
var inst_21075 = (state_21121[(13)]);
var inst_21079 = (inst_21075 < t);
var state_21121__$1 = state_21121;
if(cljs.core.truth_(inst_21079)){
var statearr_21163_21204 = state_21121__$1;
(statearr_21163_21204[(1)] = (10));

} else {
var statearr_21164_21205 = state_21121__$1;
(statearr_21164_21205[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2733__auto____0 = (function (){
var statearr_21165 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21165[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2733__auto__);

(statearr_21165[(1)] = (1));

return statearr_21165;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2733__auto____1 = (function (state_21121){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21121);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21166){var ex__2736__auto__ = e21166;
var statearr_21167_21206 = state_21121;
(statearr_21167_21206[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21121[(4)]))){
var statearr_21168_21207 = state_21121;
(statearr_21168_21207[(1)] = cljs.core.first((state_21121[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21208 = state_21121;
state_21121 = G__21208;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2733__auto__ = function(state_21121){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2733__auto____1.call(this,state_21121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2733__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2733__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21169 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21169[(6)] = c__2755__auto___21170);

return statearr_21169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21268){
var state_val_21269 = (state_21268[(1)]);
if((state_val_21269 === (7))){
var inst_21219 = (state_21268[(7)]);
var inst_21223 = (inst_21219 <= from_t);
var state_21268__$1 = state_21268;
var statearr_21270_21310 = state_21268__$1;
(statearr_21270_21310[(2)] = inst_21223);

(statearr_21270_21310[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (20))){
var inst_21253 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_21254 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21253)].join('');
var inst_21255 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21256 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_21257 = cljs.core.PersistentHashMap.fromArrays(inst_21255,inst_21256);
var inst_21258 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21254,inst_21257);
var inst_21259 = (function(){throw inst_21258})();
var state_21268__$1 = state_21268;
var statearr_21271_21311 = state_21268__$1;
(statearr_21271_21311[(2)] = inst_21259);

(statearr_21271_21311[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (1))){
var state_21268__$1 = state_21268;
var statearr_21272_21312 = state_21268__$1;
(statearr_21272_21312[(2)] = null);

(statearr_21272_21312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (4))){
var inst_21211 = (state_21268[(2)]);
var inst_21212 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_21211], 0));
var inst_21213 = (function(){throw inst_21211})();
var state_21268__$1 = (function (){var statearr_21273 = state_21268;
(statearr_21273[(8)] = inst_21212);

return statearr_21273;
})();
var statearr_21274_21313 = state_21268__$1;
(statearr_21274_21313[(2)] = inst_21213);

(statearr_21274_21313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (15))){
var inst_21238 = (state_21268[(2)]);
var state_21268__$1 = (function (){var statearr_21275 = state_21268;
(statearr_21275[(9)] = inst_21238);

return statearr_21275;
})();
if(cljs.core.truth_(from_t)){
var statearr_21276_21314 = state_21268__$1;
(statearr_21276_21314[(1)] = (16));

} else {
var statearr_21277_21315 = state_21268__$1;
(statearr_21277_21315[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (21))){
var inst_21248 = (state_21268[(10)]);
var inst_21247 = (state_21268[(11)]);
var inst_21249 = (state_21268[(12)]);
var inst_21261 = (state_21268[(2)]);
var inst_21262 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_21248,inst_21249,leftmost_QMARK_,to_t);
var inst_21263 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21262,inst_21247);
var _ = (function (){var statearr_21278 = state_21268;
(statearr_21278[(4)] = cljs.core.rest((state_21268[(4)])));

return statearr_21278;
})();
var state_21268__$1 = (function (){var statearr_21279 = state_21268;
(statearr_21279[(13)] = inst_21261);

return statearr_21279;
})();
var statearr_21280_21316 = state_21268__$1;
(statearr_21280_21316[(2)] = inst_21263);

(statearr_21280_21316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (13))){
var inst_21231 = (state_21268[(14)]);
var inst_21219 = (state_21268[(7)]);
var inst_21234 = (function (){var node_t = inst_21219;
var G__21227 = inst_21231;
return (function (p1__21209_SHARP_){
return (p1__21209_SHARP_.t < to_t);
});
})();
var inst_21235 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_21234,inst_21231);
var state_21268__$1 = state_21268;
var statearr_21281_21317 = state_21268__$1;
(statearr_21281_21317[(2)] = inst_21235);

(statearr_21281_21317[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (6))){
var inst_21220 = (state_21268[(15)]);
var state_21268__$1 = state_21268;
var statearr_21282_21318 = state_21268__$1;
(statearr_21282_21318[(2)] = inst_21220);

(statearr_21282_21318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (17))){
var inst_21238 = (state_21268[(9)]);
var state_21268__$1 = state_21268;
var statearr_21283_21319 = state_21268__$1;
(statearr_21283_21319[(2)] = inst_21238);

(statearr_21283_21319[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (3))){
var inst_21266 = (state_21268[(2)]);
var state_21268__$1 = state_21268;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21268__$1,inst_21266);
} else {
if((state_val_21269 === (12))){
var inst_21219 = (state_21268[(7)]);
var inst_21230 = (state_21268[(2)]);
var inst_21231 = fluree.db.util.async.throw_err(inst_21230);
var inst_21232 = (to_t > inst_21219);
var state_21268__$1 = (function (){var statearr_21284 = state_21268;
(statearr_21284[(14)] = inst_21231);

return statearr_21284;
})();
if(cljs.core.truth_(inst_21232)){
var statearr_21285_21320 = state_21268__$1;
(statearr_21285_21320[(1)] = (13));

} else {
var statearr_21286_21321 = state_21268__$1;
(statearr_21286_21321[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (2))){
var inst_21220 = (state_21268[(15)]);
var _ = (function (){var statearr_21287 = state_21268;
(statearr_21287[(4)] = cljs.core.cons((5),(state_21268[(4)])));

return statearr_21287;
})();
var inst_21219 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_21220__$1 = (from_t == null);
var state_21268__$1 = (function (){var statearr_21288 = state_21268;
(statearr_21288[(15)] = inst_21220__$1);

(statearr_21288[(7)] = inst_21219);

return statearr_21288;
})();
if(cljs.core.truth_(inst_21220__$1)){
var statearr_21289_21322 = state_21268__$1;
(statearr_21289_21322[(1)] = (6));

} else {
var statearr_21290_21323 = state_21268__$1;
(statearr_21290_21323[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (19))){
var state_21268__$1 = state_21268;
var statearr_21291_21324 = state_21268__$1;
(statearr_21291_21324[(2)] = null);

(statearr_21291_21324[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (11))){
var inst_21247 = (state_21268[(2)]);
var inst_21248 = fluree.db.dbproto._first_flake(node);
var inst_21249 = fluree.db.dbproto._rhs(node);
var inst_21250 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_21268__$1 = (function (){var statearr_21293 = state_21268;
(statearr_21293[(10)] = inst_21248);

(statearr_21293[(11)] = inst_21247);

(statearr_21293[(12)] = inst_21249);

return statearr_21293;
})();
if(cljs.core.truth_(inst_21250)){
var statearr_21294_21325 = state_21268__$1;
(statearr_21294_21325[(1)] = (19));

} else {
var statearr_21295_21326 = state_21268__$1;
(statearr_21295_21326[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (9))){
var inst_21228 = fluree.db.dbproto._resolve_history(node);
var state_21268__$1 = state_21268;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21268__$1,(12),inst_21228);
} else {
if((state_val_21269 === (5))){
var _ = (function (){var statearr_21296 = state_21268;
(statearr_21296[(4)] = cljs.core.rest((state_21268[(4)])));

return statearr_21296;
})();
var state_21268__$1 = state_21268;
var ex21292 = (state_21268__$1[(2)]);
var statearr_21297_21327 = state_21268__$1;
(statearr_21297_21327[(5)] = ex21292);


var statearr_21298_21328 = state_21268__$1;
(statearr_21298_21328[(1)] = (4));

(statearr_21298_21328[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (14))){
var inst_21231 = (state_21268[(14)]);
var state_21268__$1 = state_21268;
var statearr_21299_21329 = state_21268__$1;
(statearr_21299_21329[(2)] = inst_21231);

(statearr_21299_21329[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (16))){
var inst_21238 = (state_21268[(9)]);
var inst_21219 = (state_21268[(7)]);
var inst_21240 = (function (){var node_t = inst_21219;
var G__21227 = inst_21238;
return (function (p1__21210_SHARP_){
return (p1__21210_SHARP_.t <= from_t);
});
})();
var inst_21241 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_21240,inst_21238);
var state_21268__$1 = state_21268;
var statearr_21300_21330 = state_21268__$1;
(statearr_21300_21330[(2)] = inst_21241);

(statearr_21300_21330[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (10))){
var state_21268__$1 = state_21268;
var statearr_21301_21331 = state_21268__$1;
(statearr_21301_21331[(2)] = null);

(statearr_21301_21331[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (18))){
var inst_21244 = (state_21268[(2)]);
var state_21268__$1 = state_21268;
var statearr_21302_21332 = state_21268__$1;
(statearr_21302_21332[(2)] = inst_21244);

(statearr_21302_21332[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21269 === (8))){
var inst_21225 = (state_21268[(2)]);
var state_21268__$1 = state_21268;
if(cljs.core.truth_(inst_21225)){
var statearr_21303_21333 = state_21268__$1;
(statearr_21303_21333[(1)] = (9));

} else {
var statearr_21304_21334 = state_21268__$1;
(statearr_21304_21334[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto____0 = (function (){
var statearr_21305 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21305[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto__);

(statearr_21305[(1)] = (1));

return statearr_21305;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto____1 = (function (state_21268){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21268);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21306){var ex__2736__auto__ = e21306;
var statearr_21307_21335 = state_21268;
(statearr_21307_21335[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21268[(4)]))){
var statearr_21308_21336 = state_21268;
(statearr_21308_21336[(1)] = cljs.core.first((state_21268[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21337 = state_21268;
state_21268 = G__21337;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto__ = function(state_21268){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto____1.call(this,state_21268);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21309 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21309[(6)] = c__2755__auto__);

return statearr_21309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4223__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__21338_21348 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__21339_21349 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__21338_21348,G__21339_21349) : object_cache.call(null,G__21338_21348,G__21339_21349));

var G__21340 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__21341 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__21342 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__21343 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__21342,G__21343) : object_cache.call(null,G__21342,G__21343));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__21340,G__21341) : object_cache.call(null,G__21340,G__21341));
} else {
var G__21344 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__21345 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__21346 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__21347 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__21346,G__21347) : object_cache.call(null,G__21346,G__21347));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__21344,G__21345) : object_cache.call(null,G__21344,G__21345));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21370){
var state_val_21371 = (state_21370[(1)]);
if((state_val_21371 === (7))){
var state_21370__$1 = state_21370;
var statearr_21372_21392 = state_21370__$1;
(statearr_21372_21392[(2)] = null);

(statearr_21372_21392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (1))){
var state_21370__$1 = state_21370;
var statearr_21373_21393 = state_21370__$1;
(statearr_21373_21393[(2)] = null);

(statearr_21373_21393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (4))){
var inst_21350 = (state_21370[(2)]);
var state_21370__$1 = state_21370;
var statearr_21374_21394 = state_21370__$1;
(statearr_21374_21394[(2)] = inst_21350);

(statearr_21374_21394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (6))){
var inst_21356 = (state_21370[(7)]);
var inst_21358 = fluree.db.storage.core.serde(conn);
var state_21370__$1 = (function (){var statearr_21375 = state_21370;
(statearr_21375[(8)] = inst_21358);

return statearr_21375;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21370__$1,(9),inst_21356);
} else {
if((state_val_21371 === (3))){
var inst_21368 = (state_21370[(2)]);
var state_21370__$1 = state_21370;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21370__$1,inst_21368);
} else {
if((state_val_21371 === (2))){
var inst_21356 = (state_21370[(7)]);
var _ = (function (){var statearr_21377 = state_21370;
(statearr_21377[(4)] = cljs.core.cons((5),(state_21370[(4)])));

return statearr_21377;
})();
var inst_21356__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_21370__$1 = (function (){var statearr_21378 = state_21370;
(statearr_21378[(7)] = inst_21356__$1);

return statearr_21378;
})();
if(cljs.core.truth_(inst_21356__$1)){
var statearr_21379_21395 = state_21370__$1;
(statearr_21379_21395[(1)] = (6));

} else {
var statearr_21380_21396 = state_21370__$1;
(statearr_21380_21396[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (9))){
var inst_21358 = (state_21370[(8)]);
var inst_21360 = (state_21370[(2)]);
var inst_21361 = fluree.db.util.async.throw_err(inst_21360);
var inst_21362 = fluree.db.serde.protocol._deserialize_branch(inst_21358,inst_21361);
var state_21370__$1 = state_21370;
var statearr_21381_21397 = state_21370__$1;
(statearr_21381_21397[(2)] = inst_21362);

(statearr_21381_21397[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (5))){
var _ = (function (){var statearr_21382 = state_21370;
(statearr_21382[(4)] = cljs.core.rest((state_21370[(4)])));

return statearr_21382;
})();
var state_21370__$1 = state_21370;
var ex21376 = (state_21370__$1[(2)]);
var statearr_21383_21398 = state_21370__$1;
(statearr_21383_21398[(5)] = ex21376);


if((ex21376 instanceof Error)){
var statearr_21384_21399 = state_21370__$1;
(statearr_21384_21399[(1)] = (4));

(statearr_21384_21399[(5)] = null);

} else {
throw ex21376;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (8))){
var inst_21365 = (state_21370[(2)]);
var _ = (function (){var statearr_21385 = state_21370;
(statearr_21385[(4)] = cljs.core.rest((state_21370[(4)])));

return statearr_21385;
})();
var state_21370__$1 = state_21370;
var statearr_21386_21400 = state_21370__$1;
(statearr_21386_21400[(2)] = inst_21365);

(statearr_21386_21400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2733__auto____0 = (function (){
var statearr_21387 = [null,null,null,null,null,null,null,null,null];
(statearr_21387[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2733__auto__);

(statearr_21387[(1)] = (1));

return statearr_21387;
});
var fluree$db$storage$core$read_branch_$_state_machine__2733__auto____1 = (function (state_21370){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21370);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21388){var ex__2736__auto__ = e21388;
var statearr_21389_21401 = state_21370;
(statearr_21389_21401[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21370[(4)]))){
var statearr_21390_21402 = state_21370;
(statearr_21390_21402[(1)] = cljs.core.first((state_21370[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21403 = state_21370;
state_21370 = G__21403;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2733__auto__ = function(state_21370){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2733__auto____1.call(this,state_21370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2733__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2733__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21391 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21391[(6)] = c__2755__auto__);

return statearr_21391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___21482 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21454){
var state_val_21455 = (state_21454[(1)]);
if((state_val_21455 === (7))){
var inst_21421 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_21422 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21423 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_21424 = cljs.core.PersistentHashMap.fromArrays(inst_21422,inst_21423);
var inst_21425 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21421,inst_21424);
var inst_21426 = (function(){throw inst_21425})();
var state_21454__$1 = state_21454;
var statearr_21456_21483 = state_21454__$1;
(statearr_21456_21483[(2)] = inst_21426);

(statearr_21456_21483[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21455 === (1))){
var state_21454__$1 = state_21454;
var statearr_21457_21484 = state_21454__$1;
(statearr_21457_21484[(2)] = null);

(statearr_21457_21484[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21455 === (4))){
var inst_21404 = (state_21454[(2)]);
var inst_21405 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_21406 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_21404);
var inst_21407 = cljs.core.async.close_BANG_(return_ch);
var state_21454__$1 = (function (){var statearr_21458 = state_21454;
(statearr_21458[(7)] = inst_21406);

(statearr_21458[(8)] = inst_21405);

return statearr_21458;
})();
var statearr_21459_21485 = state_21454__$1;
(statearr_21459_21485[(2)] = inst_21407);

(statearr_21459_21485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21455 === (6))){
var inst_21418 = (state_21454[(9)]);
var inst_21417 = (state_21454[(2)]);
var inst_21418__$1 = fluree.db.util.async.throw_err(inst_21417);
var inst_21419 = (inst_21418__$1 == null);
var state_21454__$1 = (function (){var statearr_21460 = state_21454;
(statearr_21460[(9)] = inst_21418__$1);

return statearr_21460;
})();
if(cljs.core.truth_(inst_21419)){
var statearr_21461_21486 = state_21454__$1;
(statearr_21461_21486[(1)] = (7));

} else {
var statearr_21462_21487 = state_21454__$1;
(statearr_21462_21487[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21455 === (3))){
var inst_21452 = (state_21454[(2)]);
var state_21454__$1 = state_21454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21454__$1,inst_21452);
} else {
if((state_val_21455 === (12))){
var inst_21418 = (state_21454[(9)]);
var inst_21435 = (state_21454[(2)]);
var inst_21436 = cljs.core.__destructure_map(inst_21418);
var inst_21437 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21436,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_21438 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21436,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_21439 = config;
var inst_21440 = cljs.core.__destructure_map(inst_21439);
var inst_21441 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21440,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_21443 = (function (){var data = inst_21418;
var _ = inst_21435;
var map__21413 = inst_21436;
var children = inst_21437;
var rhs = inst_21438;
var map__21414 = inst_21440;
var comparator = inst_21441;
return (function (idx,p__21442){
var map__21463 = p__21442;
var map__21463__$1 = cljs.core.__destructure_map(map__21463);
var child = map__21463__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21463__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21463__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21463__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21463__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21463__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4221__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return (idx === (0));
} else {
return and__4221__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_21444 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_21443,inst_21437);
var inst_21445 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),inst_21444);
var inst_21446 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_21445,inst_21444);
var inst_21447 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_21441,inst_21446);
var inst_21448 = fluree.db.index.__GT_IndexNode(block,t,inst_21438,inst_21447,config,leftmost_QMARK_);
var inst_21449 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_21448);
var _ = (function (){var statearr_21464 = state_21454;
(statearr_21464[(4)] = cljs.core.rest((state_21454[(4)])));

return statearr_21464;
})();
var state_21454__$1 = state_21454;
var statearr_21465_21488 = state_21454__$1;
(statearr_21465_21488[(2)] = inst_21449);

(statearr_21465_21488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21455 === (2))){
var _ = (function (){var statearr_21466 = state_21454;
(statearr_21466[(4)] = cljs.core.cons((5),(state_21454[(4)])));

return statearr_21466;
})();
var inst_21415 = fluree.db.storage.core.read_branch(conn,key);
var state_21454__$1 = state_21454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21454__$1,(6),inst_21415);
} else {
if((state_val_21455 === (11))){
var state_21454__$1 = state_21454;
var statearr_21468_21489 = state_21454__$1;
(statearr_21468_21489[(2)] = null);

(statearr_21468_21489[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21455 === (9))){
var inst_21418 = (state_21454[(9)]);
var inst_21429 = (state_21454[(2)]);
var inst_21430 = fluree.db.util.core.exception_QMARK_(inst_21418);
var state_21454__$1 = (function (){var statearr_21469 = state_21454;
(statearr_21469[(10)] = inst_21429);

return statearr_21469;
})();
if(inst_21430){
var statearr_21470_21490 = state_21454__$1;
(statearr_21470_21490[(1)] = (10));

} else {
var statearr_21471_21491 = state_21454__$1;
(statearr_21471_21491[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21455 === (5))){
var _ = (function (){var statearr_21472 = state_21454;
(statearr_21472[(4)] = cljs.core.rest((state_21454[(4)])));

return statearr_21472;
})();
var state_21454__$1 = state_21454;
var ex21467 = (state_21454__$1[(2)]);
var statearr_21473_21492 = state_21454__$1;
(statearr_21473_21492[(5)] = ex21467);


var statearr_21474_21493 = state_21454__$1;
(statearr_21474_21493[(1)] = (4));

(statearr_21474_21493[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21455 === (10))){
var inst_21418 = (state_21454[(9)]);
var inst_21432 = (function(){throw inst_21418})();
var state_21454__$1 = state_21454;
var statearr_21475_21494 = state_21454__$1;
(statearr_21475_21494[(2)] = inst_21432);

(statearr_21475_21494[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21455 === (8))){
var state_21454__$1 = state_21454;
var statearr_21476_21495 = state_21454__$1;
(statearr_21476_21495[(2)] = null);

(statearr_21476_21495[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2733__auto____0 = (function (){
var statearr_21477 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21477[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2733__auto__);

(statearr_21477[(1)] = (1));

return statearr_21477;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2733__auto____1 = (function (state_21454){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21454);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21478){var ex__2736__auto__ = e21478;
var statearr_21479_21496 = state_21454;
(statearr_21479_21496[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21454[(4)]))){
var statearr_21480_21497 = state_21454;
(statearr_21480_21497[(1)] = cljs.core.first((state_21454[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21498 = state_21454;
state_21454 = G__21498;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2733__auto__ = function(state_21454){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2733__auto____1.call(this,state_21454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2733__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2733__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21481 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21481[(6)] = c__2755__auto___21482);

return statearr_21481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21519){
var state_val_21520 = (state_21519[(1)]);
if((state_val_21520 === (7))){
var state_21519__$1 = state_21519;
var statearr_21521_21541 = state_21519__$1;
(statearr_21521_21541[(2)] = null);

(statearr_21521_21541[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21520 === (1))){
var state_21519__$1 = state_21519;
var statearr_21522_21542 = state_21519__$1;
(statearr_21522_21542[(2)] = null);

(statearr_21522_21542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21520 === (4))){
var inst_21499 = (state_21519[(2)]);
var state_21519__$1 = state_21519;
var statearr_21523_21543 = state_21519__$1;
(statearr_21523_21543[(2)] = inst_21499);

(statearr_21523_21543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21520 === (6))){
var inst_21505 = (state_21519[(7)]);
var inst_21507 = fluree.db.storage.core.serde(conn);
var state_21519__$1 = (function (){var statearr_21524 = state_21519;
(statearr_21524[(8)] = inst_21507);

return statearr_21524;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21519__$1,(9),inst_21505);
} else {
if((state_val_21520 === (3))){
var inst_21517 = (state_21519[(2)]);
var state_21519__$1 = state_21519;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21519__$1,inst_21517);
} else {
if((state_val_21520 === (2))){
var inst_21505 = (state_21519[(7)]);
var _ = (function (){var statearr_21526 = state_21519;
(statearr_21526[(4)] = cljs.core.cons((5),(state_21519[(4)])));

return statearr_21526;
})();
var inst_21505__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_21519__$1 = (function (){var statearr_21527 = state_21519;
(statearr_21527[(7)] = inst_21505__$1);

return statearr_21527;
})();
if(cljs.core.truth_(inst_21505__$1)){
var statearr_21528_21544 = state_21519__$1;
(statearr_21528_21544[(1)] = (6));

} else {
var statearr_21529_21545 = state_21519__$1;
(statearr_21529_21545[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21520 === (9))){
var inst_21507 = (state_21519[(8)]);
var inst_21509 = (state_21519[(2)]);
var inst_21510 = fluree.db.util.async.throw_err(inst_21509);
var inst_21511 = fluree.db.serde.protocol._deserialize_leaf(inst_21507,inst_21510);
var state_21519__$1 = state_21519;
var statearr_21530_21546 = state_21519__$1;
(statearr_21530_21546[(2)] = inst_21511);

(statearr_21530_21546[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21520 === (5))){
var _ = (function (){var statearr_21531 = state_21519;
(statearr_21531[(4)] = cljs.core.rest((state_21519[(4)])));

return statearr_21531;
})();
var state_21519__$1 = state_21519;
var ex21525 = (state_21519__$1[(2)]);
var statearr_21532_21547 = state_21519__$1;
(statearr_21532_21547[(5)] = ex21525);


if((ex21525 instanceof Error)){
var statearr_21533_21548 = state_21519__$1;
(statearr_21533_21548[(1)] = (4));

(statearr_21533_21548[(5)] = null);

} else {
throw ex21525;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21520 === (8))){
var inst_21514 = (state_21519[(2)]);
var _ = (function (){var statearr_21534 = state_21519;
(statearr_21534[(4)] = cljs.core.rest((state_21519[(4)])));

return statearr_21534;
})();
var state_21519__$1 = state_21519;
var statearr_21535_21549 = state_21519__$1;
(statearr_21535_21549[(2)] = inst_21514);

(statearr_21535_21549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2733__auto____0 = (function (){
var statearr_21536 = [null,null,null,null,null,null,null,null,null];
(statearr_21536[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2733__auto__);

(statearr_21536[(1)] = (1));

return statearr_21536;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2733__auto____1 = (function (state_21519){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21519);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21537){var ex__2736__auto__ = e21537;
var statearr_21538_21550 = state_21519;
(statearr_21538_21550[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21519[(4)]))){
var statearr_21539_21551 = state_21519;
(statearr_21539_21551[(1)] = cljs.core.first((state_21519[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21552 = state_21519;
state_21519 = G__21552;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2733__auto__ = function(state_21519){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2733__auto____1.call(this,state_21519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2733__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2733__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21540 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21540[(6)] = c__2755__auto__);

return statearr_21540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___21625 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21597){
var state_val_21598 = (state_21597[(1)]);
if((state_val_21598 === (7))){
var inst_21569 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_21570 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21571 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_21572 = cljs.core.PersistentHashMap.fromArrays(inst_21570,inst_21571);
var inst_21573 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21569,inst_21572);
var inst_21574 = (function(){throw inst_21573})();
var state_21597__$1 = state_21597;
var statearr_21599_21626 = state_21597__$1;
(statearr_21599_21626[(2)] = inst_21574);

(statearr_21599_21626[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (1))){
var state_21597__$1 = state_21597;
var statearr_21600_21627 = state_21597__$1;
(statearr_21600_21627[(2)] = null);

(statearr_21600_21627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (4))){
var inst_21553 = (state_21597[(2)]);
var inst_21554 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_21555 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_21553);
var inst_21556 = cljs.core.async.close_BANG_(return_ch);
var state_21597__$1 = (function (){var statearr_21601 = state_21597;
(statearr_21601[(7)] = inst_21555);

(statearr_21601[(8)] = inst_21554);

return statearr_21601;
})();
var statearr_21602_21628 = state_21597__$1;
(statearr_21602_21628[(2)] = inst_21556);

(statearr_21602_21628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (6))){
var inst_21566 = (state_21597[(9)]);
var inst_21566__$1 = (state_21597[(2)]);
var inst_21567 = (inst_21566__$1 == null);
var state_21597__$1 = (function (){var statearr_21603 = state_21597;
(statearr_21603[(9)] = inst_21566__$1);

return statearr_21603;
})();
if(cljs.core.truth_(inst_21567)){
var statearr_21604_21629 = state_21597__$1;
(statearr_21604_21629[(1)] = (7));

} else {
var statearr_21605_21630 = state_21597__$1;
(statearr_21605_21630[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (3))){
var inst_21595 = (state_21597[(2)]);
var state_21597__$1 = state_21597;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21597__$1,inst_21595);
} else {
if((state_val_21598 === (12))){
var inst_21566 = (state_21597[(9)]);
var inst_21583 = (state_21597[(2)]);
var inst_21584 = cljs.core.__destructure_map(inst_21566);
var inst_21585 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21584,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_21586 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21584,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_21587 = config;
var inst_21588 = cljs.core.__destructure_map(inst_21587);
var inst_21589 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21588,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_21590 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_21589,inst_21585);
var inst_21591 = fluree.db.index.data_node(block,t,inst_21590,rhs,config);
var inst_21592 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_21591);
var _ = (function (){var statearr_21606 = state_21597;
(statearr_21606[(4)] = cljs.core.rest((state_21597[(4)])));

return statearr_21606;
})();
var state_21597__$1 = (function (){var statearr_21607 = state_21597;
(statearr_21607[(10)] = inst_21583);

(statearr_21607[(11)] = inst_21586);

return statearr_21607;
})();
var statearr_21608_21631 = state_21597__$1;
(statearr_21608_21631[(2)] = inst_21592);

(statearr_21608_21631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (2))){
var _ = (function (){var statearr_21609 = state_21597;
(statearr_21609[(4)] = cljs.core.cons((5),(state_21597[(4)])));

return statearr_21609;
})();
var inst_21564 = fluree.db.storage.core.read_leaf(conn,key);
var state_21597__$1 = state_21597;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21597__$1,(6),inst_21564);
} else {
if((state_val_21598 === (11))){
var state_21597__$1 = state_21597;
var statearr_21611_21632 = state_21597__$1;
(statearr_21611_21632[(2)] = null);

(statearr_21611_21632[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (9))){
var inst_21566 = (state_21597[(9)]);
var inst_21577 = (state_21597[(2)]);
var inst_21578 = fluree.db.util.core.exception_QMARK_(inst_21566);
var state_21597__$1 = (function (){var statearr_21612 = state_21597;
(statearr_21612[(12)] = inst_21577);

return statearr_21612;
})();
if(inst_21578){
var statearr_21613_21633 = state_21597__$1;
(statearr_21613_21633[(1)] = (10));

} else {
var statearr_21614_21634 = state_21597__$1;
(statearr_21614_21634[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (5))){
var _ = (function (){var statearr_21615 = state_21597;
(statearr_21615[(4)] = cljs.core.rest((state_21597[(4)])));

return statearr_21615;
})();
var state_21597__$1 = state_21597;
var ex21610 = (state_21597__$1[(2)]);
var statearr_21616_21635 = state_21597__$1;
(statearr_21616_21635[(5)] = ex21610);


var statearr_21617_21636 = state_21597__$1;
(statearr_21617_21636[(1)] = (4));

(statearr_21617_21636[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (10))){
var inst_21566 = (state_21597[(9)]);
var inst_21580 = (function(){throw inst_21566})();
var state_21597__$1 = state_21597;
var statearr_21618_21637 = state_21597__$1;
(statearr_21618_21637[(2)] = inst_21580);

(statearr_21618_21637[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (8))){
var state_21597__$1 = state_21597;
var statearr_21619_21638 = state_21597__$1;
(statearr_21619_21638[(2)] = null);

(statearr_21619_21638[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto____0 = (function (){
var statearr_21620 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21620[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto__);

(statearr_21620[(1)] = (1));

return statearr_21620;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto____1 = (function (state_21597){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21597);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21621){var ex__2736__auto__ = e21621;
var statearr_21622_21639 = state_21597;
(statearr_21622_21639[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21597[(4)]))){
var statearr_21623_21640 = state_21597;
(statearr_21623_21640[(1)] = cljs.core.first((state_21597[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21641 = state_21597;
state_21597 = G__21641;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto__ = function(state_21597){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto____1.call(this,state_21597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21624 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21624[(6)] = c__2755__auto___21625);

return statearr_21624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k21643,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__21647 = k21643;
var G__21647__$1 = (((G__21647 instanceof cljs.core.Keyword))?G__21647.fqn:null);
switch (G__21647__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k21643,else__4475__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__21648){
var vec__21649 = p__21648;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21649,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21649,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__21642){
var self__ = this;
var G__21642__$1 = this;
return (new cljs.core.RecordIter((0),G__21642__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__21652 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__21653 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__21654 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__21655 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__21654,G__21655) : object_cache.call(null,G__21654,G__21655));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__21656 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__21657 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__21656,G__21657) : object_cache.call(null,G__21656,G__21657));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__21652,G__21653) : object_cache.call(null,G__21652,G__21653));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__21658 = history_id;
var G__21659 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__21658,G__21659) : object_cache.call(null,G__21658,G__21659));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__21660 = (function (coll__4469__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__21660(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this21644,other21645){
var self__ = this;
var this21644__$1 = this;
return (((!((other21645 == null)))) && ((((this21644__$1.constructor === other21645.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.conn,other21645.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.config,other21645.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.network,other21645.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.dbid,other21645.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.id,other21645.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.leaf,other21645.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.first,other21645.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.rhs,other21645.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.size,other21645.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.block,other21645.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.t,other21645.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.tt_id,other21645.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.leftmost_QMARK_,other21645.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.tempid,other21645.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this21644__$1.__extmap,other21645.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k21643){
var self__ = this;
var this__4479__auto____$1 = this;
var G__21661 = k21643;
var G__21661__$1 = (((G__21661 instanceof cljs.core.Keyword))?G__21661.fqn:null);
switch (G__21661__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k21643);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__21642){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__21662 = cljs.core.keyword_identical_QMARK_;
var expr__21663 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__21665 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__21666 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21665,G__21666) : pred__21662.call(null,G__21665,G__21666));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__21642,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21667 = new cljs.core.Keyword(null,"config","config",994861415);
var G__21668 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21667,G__21668) : pred__21662.call(null,G__21667,G__21668));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__21642,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21669 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__21670 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21669,G__21670) : pred__21662.call(null,G__21669,G__21670));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__21642,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21671 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__21672 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21671,G__21672) : pred__21662.call(null,G__21671,G__21672));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__21642,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21673 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__21674 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21673,G__21674) : pred__21662.call(null,G__21673,G__21674));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__21642,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21675 = new cljs.core.Keyword(null,"leaf","leaf",1306118732);
var G__21676 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21675,G__21676) : pred__21662.call(null,G__21675,G__21676));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__21642,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21677 = new cljs.core.Keyword(null,"first","first",-644103046);
var G__21678 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21677,G__21678) : pred__21662.call(null,G__21677,G__21678));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__21642,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21679 = new cljs.core.Keyword(null,"rhs","rhs",-229356739);
var G__21680 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21679,G__21680) : pred__21662.call(null,G__21679,G__21680));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__21642,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21681 = new cljs.core.Keyword(null,"size","size",1098693007);
var G__21682 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21681,G__21682) : pred__21662.call(null,G__21681,G__21682));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__21642,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21683 = new cljs.core.Keyword(null,"block","block",664686210);
var G__21684 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21683,G__21684) : pred__21662.call(null,G__21683,G__21684));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__21642,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21685 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__21686 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21685,G__21686) : pred__21662.call(null,G__21685,G__21686));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__21642,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21687 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__21688 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21687,G__21688) : pred__21662.call(null,G__21687,G__21688));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__21642,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21689 = new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559);
var G__21690 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21689,G__21690) : pred__21662.call(null,G__21689,G__21690));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__21642,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__21691 = new cljs.core.Keyword(null,"tempid","tempid",1427663222);
var G__21692 = expr__21663;
return (pred__21662.cljs$core$IFn$_invoke$arity$2 ? pred__21662.cljs$core$IFn$_invoke$arity$2(G__21691,G__21692) : pred__21662.call(null,G__21691,G__21692));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__21642,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__21642),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__21642){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__21642,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__21646){
var extmap__4512__auto__ = (function (){var G__21693 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__21646,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], 0));
if(cljs.core.record_QMARK_(G__21646)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__21693);
} else {
return G__21693;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__21646),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__21646),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__21646),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__21646),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__21646),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__21646),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__21646),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__21646),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__21646),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__21646),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__21646),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__21646),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__21646),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__21646),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__21696 = blank_db;
var map__21696__$1 = cljs.core.__destructure_map(map__21696);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21696__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21696__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21696__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__21697 = root_data;
var map__21697__$1 = cljs.core.__destructure_map(map__21697);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21697__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21697__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21697__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21697__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21719){
var state_val_21720 = (state_21719[(1)]);
if((state_val_21720 === (7))){
var state_21719__$1 = state_21719;
var statearr_21721_21741 = state_21719__$1;
(statearr_21721_21741[(2)] = null);

(statearr_21721_21741[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21720 === (1))){
var state_21719__$1 = state_21719;
var statearr_21722_21742 = state_21719__$1;
(statearr_21722_21742[(2)] = null);

(statearr_21722_21742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21720 === (4))){
var inst_21698 = (state_21719[(2)]);
var state_21719__$1 = state_21719;
var statearr_21723_21743 = state_21719__$1;
(statearr_21723_21743[(2)] = inst_21698);

(statearr_21723_21743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21720 === (6))){
var inst_21705 = (state_21719[(7)]);
var inst_21707 = fluree.db.storage.core.serde(conn);
var state_21719__$1 = (function (){var statearr_21724 = state_21719;
(statearr_21724[(8)] = inst_21707);

return statearr_21724;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21719__$1,(9),inst_21705);
} else {
if((state_val_21720 === (3))){
var inst_21717 = (state_21719[(2)]);
var state_21719__$1 = state_21719;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21719__$1,inst_21717);
} else {
if((state_val_21720 === (2))){
var inst_21705 = (state_21719[(7)]);
var _ = (function (){var statearr_21726 = state_21719;
(statearr_21726[(4)] = cljs.core.cons((5),(state_21719[(4)])));

return statearr_21726;
})();
var inst_21704 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_21705__$1 = fluree.db.storage.core.storage_read(conn,inst_21704);
var state_21719__$1 = (function (){var statearr_21727 = state_21719;
(statearr_21727[(7)] = inst_21705__$1);

return statearr_21727;
})();
if(cljs.core.truth_(inst_21705__$1)){
var statearr_21728_21744 = state_21719__$1;
(statearr_21728_21744[(1)] = (6));

} else {
var statearr_21729_21745 = state_21719__$1;
(statearr_21729_21745[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21720 === (9))){
var inst_21707 = (state_21719[(8)]);
var inst_21709 = (state_21719[(2)]);
var inst_21710 = fluree.db.util.async.throw_err(inst_21709);
var inst_21711 = fluree.db.serde.protocol._deserialize_garbage(inst_21707,inst_21710);
var state_21719__$1 = state_21719;
var statearr_21730_21746 = state_21719__$1;
(statearr_21730_21746[(2)] = inst_21711);

(statearr_21730_21746[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21720 === (5))){
var _ = (function (){var statearr_21731 = state_21719;
(statearr_21731[(4)] = cljs.core.rest((state_21719[(4)])));

return statearr_21731;
})();
var state_21719__$1 = state_21719;
var ex21725 = (state_21719__$1[(2)]);
var statearr_21732_21747 = state_21719__$1;
(statearr_21732_21747[(5)] = ex21725);


if((ex21725 instanceof Error)){
var statearr_21733_21748 = state_21719__$1;
(statearr_21733_21748[(1)] = (4));

(statearr_21733_21748[(5)] = null);

} else {
throw ex21725;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21720 === (8))){
var inst_21714 = (state_21719[(2)]);
var _ = (function (){var statearr_21734 = state_21719;
(statearr_21734[(4)] = cljs.core.rest((state_21719[(4)])));

return statearr_21734;
})();
var state_21719__$1 = state_21719;
var statearr_21735_21749 = state_21719__$1;
(statearr_21735_21749[(2)] = inst_21714);

(statearr_21735_21749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2733__auto____0 = (function (){
var statearr_21736 = [null,null,null,null,null,null,null,null,null];
(statearr_21736[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2733__auto__);

(statearr_21736[(1)] = (1));

return statearr_21736;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2733__auto____1 = (function (state_21719){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21719);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21737){var ex__2736__auto__ = e21737;
var statearr_21738_21750 = state_21719;
(statearr_21738_21750[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21719[(4)]))){
var statearr_21739_21751 = state_21719;
(statearr_21739_21751[(1)] = cljs.core.first((state_21719[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21752 = state_21719;
state_21719 = G__21752;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2733__auto__ = function(state_21719){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2733__auto____1.call(this,state_21719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2733__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2733__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21740 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21740[(6)] = c__2755__auto__);

return statearr_21740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21774){
var state_val_21775 = (state_21774[(1)]);
if((state_val_21775 === (7))){
var state_21774__$1 = state_21774;
var statearr_21776_21796 = state_21774__$1;
(statearr_21776_21796[(2)] = null);

(statearr_21776_21796[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21775 === (1))){
var state_21774__$1 = state_21774;
var statearr_21777_21797 = state_21774__$1;
(statearr_21777_21797[(2)] = null);

(statearr_21777_21797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21775 === (4))){
var inst_21753 = (state_21774[(2)]);
var state_21774__$1 = state_21774;
var statearr_21778_21798 = state_21774__$1;
(statearr_21778_21798[(2)] = inst_21753);

(statearr_21778_21798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21775 === (6))){
var inst_21760 = (state_21774[(7)]);
var inst_21762 = fluree.db.storage.core.serde(conn);
var state_21774__$1 = (function (){var statearr_21779 = state_21774;
(statearr_21779[(8)] = inst_21762);

return statearr_21779;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21774__$1,(9),inst_21760);
} else {
if((state_val_21775 === (3))){
var inst_21772 = (state_21774[(2)]);
var state_21774__$1 = state_21774;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21774__$1,inst_21772);
} else {
if((state_val_21775 === (2))){
var inst_21760 = (state_21774[(7)]);
var _ = (function (){var statearr_21781 = state_21774;
(statearr_21781[(4)] = cljs.core.cons((5),(state_21774[(4)])));

return statearr_21781;
})();
var inst_21759 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_21760__$1 = fluree.db.storage.core.storage_read(conn,inst_21759);
var state_21774__$1 = (function (){var statearr_21782 = state_21774;
(statearr_21782[(7)] = inst_21760__$1);

return statearr_21782;
})();
if(cljs.core.truth_(inst_21760__$1)){
var statearr_21783_21799 = state_21774__$1;
(statearr_21783_21799[(1)] = (6));

} else {
var statearr_21784_21800 = state_21774__$1;
(statearr_21784_21800[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21775 === (9))){
var inst_21762 = (state_21774[(8)]);
var inst_21764 = (state_21774[(2)]);
var inst_21765 = fluree.db.util.async.throw_err(inst_21764);
var inst_21766 = fluree.db.serde.protocol._deserialize_db_root(inst_21762,inst_21765);
var state_21774__$1 = state_21774;
var statearr_21785_21801 = state_21774__$1;
(statearr_21785_21801[(2)] = inst_21766);

(statearr_21785_21801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21775 === (5))){
var _ = (function (){var statearr_21786 = state_21774;
(statearr_21786[(4)] = cljs.core.rest((state_21774[(4)])));

return statearr_21786;
})();
var state_21774__$1 = state_21774;
var ex21780 = (state_21774__$1[(2)]);
var statearr_21787_21802 = state_21774__$1;
(statearr_21787_21802[(5)] = ex21780);


if((ex21780 instanceof Error)){
var statearr_21788_21803 = state_21774__$1;
(statearr_21788_21803[(1)] = (4));

(statearr_21788_21803[(5)] = null);

} else {
throw ex21780;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21775 === (8))){
var inst_21769 = (state_21774[(2)]);
var _ = (function (){var statearr_21789 = state_21774;
(statearr_21789[(4)] = cljs.core.rest((state_21774[(4)])));

return statearr_21789;
})();
var state_21774__$1 = state_21774;
var statearr_21790_21804 = state_21774__$1;
(statearr_21790_21804[(2)] = inst_21769);

(statearr_21790_21804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2733__auto____0 = (function (){
var statearr_21791 = [null,null,null,null,null,null,null,null,null];
(statearr_21791[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2733__auto__);

(statearr_21791[(1)] = (1));

return statearr_21791;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2733__auto____1 = (function (state_21774){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21774);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21792){var ex__2736__auto__ = e21792;
var statearr_21793_21805 = state_21774;
(statearr_21793_21805[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21774[(4)]))){
var statearr_21794_21806 = state_21774;
(statearr_21794_21806[(1)] = cljs.core.first((state_21774[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21807 = state_21774;
state_21774 = G__21807;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2733__auto__ = function(state_21774){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2733__auto____1.call(this,state_21774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2733__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2733__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21795 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21795[(6)] = c__2755__auto__);

return statearr_21795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21843){
var state_val_21844 = (state_21843[(1)]);
if((state_val_21844 === (7))){
var inst_21817 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_21818 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21819 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_21820 = cljs.core.PersistentHashMap.fromArrays(inst_21818,inst_21819);
var inst_21821 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21817,inst_21820);
var inst_21822 = (function(){throw inst_21821})();
var state_21843__$1 = state_21843;
var statearr_21845_21867 = state_21843__$1;
(statearr_21845_21867[(2)] = inst_21822);

(statearr_21845_21867[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21844 === (1))){
var state_21843__$1 = state_21843;
var statearr_21846_21868 = state_21843__$1;
(statearr_21846_21868[(2)] = null);

(statearr_21846_21868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21844 === (4))){
var inst_21808 = (state_21843[(2)]);
var state_21843__$1 = state_21843;
var statearr_21847_21869 = state_21843__$1;
(statearr_21847_21869[(2)] = inst_21808);

(statearr_21847_21869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21844 === (6))){
var state_21843__$1 = state_21843;
var statearr_21848_21870 = state_21843__$1;
(statearr_21848_21870[(2)] = null);

(statearr_21848_21870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21844 === (3))){
var inst_21841 = (state_21843[(2)]);
var state_21843__$1 = state_21843;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21843__$1,inst_21841);
} else {
if((state_val_21844 === (2))){
var inst_21814 = (state_21843[(7)]);
var _ = (function (){var statearr_21849 = state_21843;
(statearr_21849[(4)] = cljs.core.cons((5),(state_21843[(4)])));

return statearr_21849;
})();
var inst_21814__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_21843__$1 = (function (){var statearr_21850 = state_21843;
(statearr_21850[(7)] = inst_21814__$1);

return statearr_21850;
})();
if(cljs.core.truth_(inst_21814__$1)){
var statearr_21851_21871 = state_21843__$1;
(statearr_21851_21871[(1)] = (6));

} else {
var statearr_21852_21872 = state_21843__$1;
(statearr_21852_21872[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21844 === (11))){
var inst_21833 = (state_21843[(8)]);
var inst_21836 = (state_21843[(2)]);
var inst_21837 = fluree.db.util.async.throw_err(inst_21836);
var inst_21838 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21833,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_21837);
var _ = (function (){var statearr_21854 = state_21843;
(statearr_21854[(4)] = cljs.core.rest((state_21843[(4)])));

return statearr_21854;
})();
var state_21843__$1 = state_21843;
var statearr_21855_21873 = state_21843__$1;
(statearr_21855_21873[(2)] = inst_21838);

(statearr_21855_21873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21844 === (9))){
var inst_21828 = (state_21843[(9)]);
var inst_21826 = (state_21843[(2)]);
var inst_21827 = fluree.db.util.async.throw_err(inst_21826);
var inst_21828__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_21827);
var inst_21829 = fluree.db.query.schema.schema_map(inst_21828__$1);
var state_21843__$1 = (function (){var statearr_21856 = state_21843;
(statearr_21856[(9)] = inst_21828__$1);

return statearr_21856;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21843__$1,(10),inst_21829);
} else {
if((state_val_21844 === (5))){
var _ = (function (){var statearr_21857 = state_21843;
(statearr_21857[(4)] = cljs.core.rest((state_21843[(4)])));

return statearr_21857;
})();
var state_21843__$1 = state_21843;
var ex21853 = (state_21843__$1[(2)]);
var statearr_21858_21874 = state_21843__$1;
(statearr_21858_21874[(5)] = ex21853);


if((ex21853 instanceof Error)){
var statearr_21859_21875 = state_21843__$1;
(statearr_21859_21875[(1)] = (4));

(statearr_21859_21875[(5)] = null);

} else {
throw ex21853;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21844 === (10))){
var inst_21828 = (state_21843[(9)]);
var inst_21833 = (state_21843[(8)]);
var inst_21831 = (state_21843[(2)]);
var inst_21832 = fluree.db.util.async.throw_err(inst_21831);
var inst_21833__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21828,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_21832);
var inst_21834 = fluree.db.query.schema.setting_map(inst_21833__$1);
var state_21843__$1 = (function (){var statearr_21860 = state_21843;
(statearr_21860[(8)] = inst_21833__$1);

return statearr_21860;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21843__$1,(11),inst_21834);
} else {
if((state_val_21844 === (8))){
var inst_21814 = (state_21843[(7)]);
var inst_21824 = (state_21843[(2)]);
var state_21843__$1 = (function (){var statearr_21861 = state_21843;
(statearr_21861[(10)] = inst_21824);

return statearr_21861;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21843__$1,(9),inst_21814);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2733__auto____0 = (function (){
var statearr_21862 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21862[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2733__auto__);

(statearr_21862[(1)] = (1));

return statearr_21862;
});
var fluree$db$storage$core$reify_db_$_state_machine__2733__auto____1 = (function (state_21843){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21843);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21863){var ex__2736__auto__ = e21863;
var statearr_21864_21876 = state_21843;
(statearr_21864_21876[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21843[(4)]))){
var statearr_21865_21877 = state_21843;
(statearr_21865_21877[(1)] = cljs.core.first((state_21843[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21878 = state_21843;
state_21843 = G__21878;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2733__auto__ = function(state_21843){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2733__auto____1.call(this,state_21843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2733__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2733__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21866 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21866[(6)] = c__2755__auto__);

return statearr_21866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__21880 = arguments.length;
switch (G__21880) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_21933){
var state_val_21934 = (state_21933[(1)]);
if((state_val_21934 === (7))){
var inst_21890 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_21891 = (new Error(inst_21890));
var inst_21892 = (function(){throw inst_21891})();
var state_21933__$1 = state_21933;
var statearr_21935_21975 = state_21933__$1;
(statearr_21935_21975[(2)] = inst_21892);

(statearr_21935_21975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (20))){
var inst_21924 = (state_21933[(2)]);
var state_21933__$1 = state_21933;
var statearr_21936_21976 = state_21933__$1;
(statearr_21936_21976[(2)] = inst_21924);

(statearr_21936_21976[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (1))){
var state_21933__$1 = state_21933;
var statearr_21937_21977 = state_21933__$1;
(statearr_21937_21977[(2)] = null);

(statearr_21937_21977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (4))){
var inst_21881 = (state_21933[(2)]);
var state_21933__$1 = state_21933;
var statearr_21938_21978 = state_21933__$1;
(statearr_21938_21978[(2)] = inst_21881);

(statearr_21938_21978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (15))){
var inst_21899 = (state_21933[(7)]);
var state_21933__$1 = state_21933;
var statearr_21939_21979 = state_21933__$1;
(statearr_21939_21979[(2)] = inst_21899);

(statearr_21939_21979[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (21))){
var inst_21903 = (state_21933[(8)]);
var inst_21898 = (state_21933[(9)]);
var inst_21899 = (state_21933[(7)]);
var inst_21917 = (inst_21898 + (1));
var inst_21918 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21899,inst_21903);
var inst_21898__$1 = inst_21917;
var inst_21899__$1 = inst_21918;
var state_21933__$1 = (function (){var statearr_21940 = state_21933;
(statearr_21940[(9)] = inst_21898__$1);

(statearr_21940[(7)] = inst_21899__$1);

return statearr_21940;
})();
var statearr_21941_21980 = state_21933__$1;
(statearr_21941_21980[(2)] = null);

(statearr_21941_21980[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (13))){
var inst_21903 = (state_21933[(8)]);
var inst_21907 = (inst_21903 instanceof Error);
var state_21933__$1 = state_21933;
var statearr_21942_21981 = state_21933__$1;
(statearr_21942_21981[(2)] = inst_21907);

(statearr_21942_21981[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (22))){
var state_21933__$1 = state_21933;
var statearr_21943_21982 = state_21933__$1;
(statearr_21943_21982[(2)] = null);

(statearr_21943_21982[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (6))){
var state_21933__$1 = state_21933;
var statearr_21944_21983 = state_21933__$1;
(statearr_21944_21983[(2)] = null);

(statearr_21944_21983[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (17))){
var inst_21926 = (state_21933[(2)]);
var state_21933__$1 = state_21933;
var statearr_21945_21984 = state_21933__$1;
(statearr_21945_21984[(2)] = inst_21926);

(statearr_21945_21984[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (3))){
var inst_21931 = (state_21933[(2)]);
var state_21933__$1 = state_21933;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21933__$1,inst_21931);
} else {
if((state_val_21934 === (12))){
var inst_21904 = (state_21933[(10)]);
var state_21933__$1 = state_21933;
var statearr_21946_21985 = state_21933__$1;
(statearr_21946_21985[(2)] = inst_21904);

(statearr_21946_21985[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (2))){
var _ = (function (){var statearr_21947 = state_21933;
(statearr_21947[(4)] = cljs.core.cons((5),(state_21933[(4)])));

return statearr_21947;
})();
var inst_21887 = (end >= start);
var state_21933__$1 = state_21933;
if(cljs.core.truth_(inst_21887)){
var statearr_21948_21986 = state_21933__$1;
(statearr_21948_21986[(1)] = (6));

} else {
var statearr_21949_21987 = state_21933__$1;
(statearr_21949_21987[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (23))){
var inst_21922 = (state_21933[(2)]);
var state_21933__$1 = state_21933;
var statearr_21950_21988 = state_21933__$1;
(statearr_21950_21988[(2)] = inst_21922);

(statearr_21950_21988[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (19))){
var state_21933__$1 = state_21933;
var statearr_21951_21989 = state_21933__$1;
(statearr_21951_21989[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (11))){
var inst_21904 = (state_21933[(10)]);
var inst_21903 = (state_21933[(8)]);
var inst_21903__$1 = (state_21933[(2)]);
var inst_21904__$1 = (inst_21903__$1 == null);
var state_21933__$1 = (function (){var statearr_21954 = state_21933;
(statearr_21954[(10)] = inst_21904__$1);

(statearr_21954[(8)] = inst_21903__$1);

return statearr_21954;
})();
if(cljs.core.truth_(inst_21904__$1)){
var statearr_21955_21990 = state_21933__$1;
(statearr_21955_21990[(1)] = (12));

} else {
var statearr_21956_21991 = state_21933__$1;
(statearr_21956_21991[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (9))){
var inst_21898 = (state_21933[(9)]);
var inst_21901 = fluree.db.storage.core.read_block(conn,network,dbid,inst_21898);
var state_21933__$1 = state_21933;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21933__$1,(11),inst_21901);
} else {
if((state_val_21934 === (5))){
var _ = (function (){var statearr_21957 = state_21933;
(statearr_21957[(4)] = cljs.core.rest((state_21933[(4)])));

return statearr_21957;
})();
var state_21933__$1 = state_21933;
var ex21953 = (state_21933__$1[(2)]);
var statearr_21958_21992 = state_21933__$1;
(statearr_21958_21992[(5)] = ex21953);


if((ex21953 instanceof Error)){
var statearr_21959_21993 = state_21933__$1;
(statearr_21959_21993[(1)] = (4));

(statearr_21959_21993[(5)] = null);

} else {
throw ex21953;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (14))){
var inst_21909 = (state_21933[(2)]);
var state_21933__$1 = state_21933;
if(cljs.core.truth_(inst_21909)){
var statearr_21960_21994 = state_21933__$1;
(statearr_21960_21994[(1)] = (15));

} else {
var statearr_21961_21995 = state_21933__$1;
(statearr_21961_21995[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (16))){
var inst_21898 = (state_21933[(9)]);
var inst_21912 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21898,end);
var state_21933__$1 = state_21933;
if(inst_21912){
var statearr_21962_21996 = state_21933__$1;
(statearr_21962_21996[(1)] = (18));

} else {
var statearr_21963_21997 = state_21933__$1;
(statearr_21963_21997[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (10))){
var inst_21928 = (state_21933[(2)]);
var _ = (function (){var statearr_21964 = state_21933;
(statearr_21964[(4)] = cljs.core.rest((state_21933[(4)])));

return statearr_21964;
})();
var state_21933__$1 = state_21933;
var statearr_21965_21998 = state_21933__$1;
(statearr_21965_21998[(2)] = inst_21928);

(statearr_21965_21998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (18))){
var inst_21903 = (state_21933[(8)]);
var inst_21899 = (state_21933[(7)]);
var inst_21914 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21899,inst_21903);
var state_21933__$1 = state_21933;
var statearr_21966_21999 = state_21933__$1;
(statearr_21966_21999[(2)] = inst_21914);

(statearr_21966_21999[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21934 === (8))){
var inst_21894 = (state_21933[(2)]);
var inst_21895 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_21896 = start;
var inst_21897 = cljs.core.PersistentVector.EMPTY;
var inst_21898 = inst_21896;
var inst_21899 = inst_21897;
var state_21933__$1 = (function (){var statearr_21967 = state_21933;
(statearr_21967[(11)] = inst_21894);

(statearr_21967[(9)] = inst_21898);

(statearr_21967[(7)] = inst_21899);

(statearr_21967[(12)] = inst_21895);

return statearr_21967;
})();
var statearr_21968_22000 = state_21933__$1;
(statearr_21968_22000[(2)] = null);

(statearr_21968_22000[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2733__auto__ = null;
var fluree$db$storage$core$state_machine__2733__auto____0 = (function (){
var statearr_21969 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21969[(0)] = fluree$db$storage$core$state_machine__2733__auto__);

(statearr_21969[(1)] = (1));

return statearr_21969;
});
var fluree$db$storage$core$state_machine__2733__auto____1 = (function (state_21933){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_21933);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e21970){var ex__2736__auto__ = e21970;
var statearr_21971_22001 = state_21933;
(statearr_21971_22001[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_21933[(4)]))){
var statearr_21972_22002 = state_21933;
(statearr_21972_22002[(1)] = cljs.core.first((state_21933[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22003 = state_21933;
state_21933 = G__22003;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2733__auto__ = function(state_21933){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2733__auto____1.call(this,state_21933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2733__auto____0;
fluree$db$storage$core$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2733__auto____1;
return fluree$db$storage$core$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_21973 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_21973[(6)] = c__2755__auto__);

return statearr_21973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_22019){
var state_val_22020 = (state_22019[(1)]);
if((state_val_22020 === (1))){
var state_22019__$1 = state_22019;
var statearr_22021_22035 = state_22019__$1;
(statearr_22021_22035[(2)] = null);

(statearr_22021_22035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22020 === (2))){
var _ = (function (){var statearr_22022 = state_22019;
(statearr_22022[(4)] = cljs.core.cons((5),(state_22019[(4)])));

return statearr_22022;
})();
var inst_22010 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_22019__$1 = state_22019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22019__$1,(6),inst_22010);
} else {
if((state_val_22020 === (3))){
var inst_22017 = (state_22019[(2)]);
var state_22019__$1 = state_22019;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22019__$1,inst_22017);
} else {
if((state_val_22020 === (4))){
var inst_22004 = (state_22019[(2)]);
var state_22019__$1 = state_22019;
var statearr_22024_22036 = state_22019__$1;
(statearr_22024_22036[(2)] = inst_22004);

(statearr_22024_22036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22020 === (5))){
var _ = (function (){var statearr_22025 = state_22019;
(statearr_22025[(4)] = cljs.core.rest((state_22019[(4)])));

return statearr_22025;
})();
var state_22019__$1 = state_22019;
var ex22023 = (state_22019__$1[(2)]);
var statearr_22026_22037 = state_22019__$1;
(statearr_22026_22037[(5)] = ex22023);


if((ex22023 instanceof Error)){
var statearr_22027_22038 = state_22019__$1;
(statearr_22027_22038[(1)] = (4));

(statearr_22027_22038[(5)] = null);

} else {
throw ex22023;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22020 === (6))){
var inst_22012 = (state_22019[(2)]);
var inst_22013 = fluree.db.util.async.throw_err(inst_22012);
var inst_22014 = cljs.core.first(inst_22013);
var _ = (function (){var statearr_22028 = state_22019;
(statearr_22028[(4)] = cljs.core.rest((state_22019[(4)])));

return statearr_22028;
})();
var state_22019__$1 = state_22019;
var statearr_22029_22039 = state_22019__$1;
(statearr_22029_22039[(2)] = inst_22014);

(statearr_22029_22039[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2733__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2733__auto____0 = (function (){
var statearr_22030 = [null,null,null,null,null,null,null];
(statearr_22030[(0)] = fluree$db$storage$core$block_$_state_machine__2733__auto__);

(statearr_22030[(1)] = (1));

return statearr_22030;
});
var fluree$db$storage$core$block_$_state_machine__2733__auto____1 = (function (state_22019){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_22019);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e22031){var ex__2736__auto__ = e22031;
var statearr_22032_22040 = state_22019;
(statearr_22032_22040[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_22019[(4)]))){
var statearr_22033_22041 = state_22019;
(statearr_22033_22041[(1)] = cljs.core.first((state_22019[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22042 = state_22019;
state_22019 = G__22042;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2733__auto__ = function(state_22019){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2733__auto____1.call(this,state_22019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2733__auto____0;
fluree$db$storage$core$block_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2733__auto____1;
return fluree$db$storage$core$block_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_22034 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_22034[(6)] = c__2755__auto__);

return statearr_22034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
