// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4223__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_11481){
var state_val_11482 = (state_11481[(1)]);
if((state_val_11482 === (7))){
var inst_11476 = (state_11481[(2)]);
var _ = (function (){var statearr_11483 = state_11481;
(statearr_11483[(4)] = cljs.core.rest((state_11481[(4)])));

return statearr_11483;
})();
var state_11481__$1 = state_11481;
var statearr_11484_11506 = state_11481__$1;
(statearr_11484_11506[(2)] = inst_11476);

(statearr_11484_11506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (1))){
var state_11481__$1 = state_11481;
var statearr_11485_11507 = state_11481__$1;
(statearr_11485_11507[(2)] = null);

(statearr_11485_11507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (4))){
var inst_11438 = (state_11481[(2)]);
var state_11481__$1 = state_11481;
var statearr_11486_11508 = state_11481__$1;
(statearr_11486_11508[(2)] = inst_11438);

(statearr_11486_11508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (6))){
var inst_11456 = (state_11481[(7)]);
var inst_11463 = (state_11481[(8)]);
var inst_11462 = cljs.core.seq(inst_11456);
var inst_11463__$1 = cljs.core.first(inst_11462);
var inst_11464 = cljs.core.next(inst_11462);
var inst_11465 = cljs.core.not(inst_11463__$1);
var state_11481__$1 = (function (){var statearr_11487 = state_11481;
(statearr_11487[(9)] = inst_11464);

(statearr_11487[(8)] = inst_11463__$1);

return statearr_11487;
})();
if(inst_11465){
var statearr_11488_11509 = state_11481__$1;
(statearr_11488_11509[(1)] = (8));

} else {
var statearr_11489_11510 = state_11481__$1;
(statearr_11489_11510[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (3))){
var inst_11479 = (state_11481[(2)]);
var state_11481__$1 = state_11481;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11481__$1,inst_11479);
} else {
if((state_val_11482 === (2))){
var _ = (function (){var statearr_11490 = state_11481;
(statearr_11490[(4)] = cljs.core.cons((5),(state_11481[(4)])));

return statearr_11490;
})();
var inst_11451 = chs;
var inst_11452 = cljs.core.seq(inst_11451);
var inst_11453 = cljs.core.first(inst_11452);
var inst_11454 = cljs.core.next(inst_11452);
var inst_11455 = coll;
var inst_11456 = inst_11451;
var inst_11457 = inst_11455;
var state_11481__$1 = (function (){var statearr_11491 = state_11481;
(statearr_11491[(10)] = inst_11453);

(statearr_11491[(11)] = inst_11454);

(statearr_11491[(7)] = inst_11456);

(statearr_11491[(12)] = inst_11457);

return statearr_11491;
})();
var statearr_11492_11511 = state_11481__$1;
(statearr_11492_11511[(2)] = null);

(statearr_11492_11511[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (11))){
var inst_11464 = (state_11481[(9)]);
var inst_11457 = (state_11481[(12)]);
var inst_11469 = (state_11481[(2)]);
var inst_11470 = fluree.db.util.async.throw_err(inst_11469);
var inst_11471 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_11457,inst_11470);
var inst_11456 = inst_11464;
var inst_11457__$1 = inst_11471;
var state_11481__$1 = (function (){var statearr_11494 = state_11481;
(statearr_11494[(7)] = inst_11456);

(statearr_11494[(12)] = inst_11457__$1);

return statearr_11494;
})();
var statearr_11495_11512 = state_11481__$1;
(statearr_11495_11512[(2)] = null);

(statearr_11495_11512[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (9))){
var inst_11463 = (state_11481[(8)]);
var state_11481__$1 = state_11481;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11481__$1,(11),inst_11463);
} else {
if((state_val_11482 === (5))){
var _ = (function (){var statearr_11496 = state_11481;
(statearr_11496[(4)] = cljs.core.rest((state_11481[(4)])));

return statearr_11496;
})();
var state_11481__$1 = state_11481;
var ex11493 = (state_11481__$1[(2)]);
var statearr_11497_11513 = state_11481__$1;
(statearr_11497_11513[(5)] = ex11493);


var statearr_11498_11514 = state_11481__$1;
(statearr_11498_11514[(1)] = (4));

(statearr_11498_11514[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (10))){
var inst_11474 = (state_11481[(2)]);
var state_11481__$1 = state_11481;
var statearr_11499_11515 = state_11481__$1;
(statearr_11499_11515[(2)] = inst_11474);

(statearr_11499_11515[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11482 === (8))){
var inst_11457 = (state_11481[(12)]);
var state_11481__$1 = state_11481;
var statearr_11500_11516 = state_11481__$1;
(statearr_11500_11516[(2)] = inst_11457);

(statearr_11500_11516[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_11501 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11501[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto__);

(statearr_11501[(1)] = (1));

return statearr_11501;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto____1 = (function (state_11481){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_11481);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e11502){var ex__2736__auto__ = e11502;
var statearr_11503_11517 = state_11481;
(statearr_11503_11517[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_11481[(4)]))){
var statearr_11504_11518 = state_11481;
(statearr_11504_11518[(1)] = cljs.core.first((state_11481[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11519 = state_11481;
state_11481 = G__11519;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto__ = function(state_11481){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto____1.call(this,state_11481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_11505 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_11505[(6)] = c__2755__auto__);

return statearr_11505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_11545){
var state_val_11546 = (state_11545[(1)]);
if((state_val_11546 === (7))){
var inst_11540 = (state_11545[(2)]);
var _ = (function (){var statearr_11547 = state_11545;
(statearr_11547[(4)] = cljs.core.rest((state_11545[(4)])));

return statearr_11547;
})();
var state_11545__$1 = state_11545;
var statearr_11548_11570 = state_11545__$1;
(statearr_11548_11570[(2)] = inst_11540);

(statearr_11548_11570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11546 === (1))){
var state_11545__$1 = state_11545;
var statearr_11549_11571 = state_11545__$1;
(statearr_11549_11571[(2)] = null);

(statearr_11549_11571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11546 === (4))){
var inst_11520 = (state_11545[(2)]);
var state_11545__$1 = state_11545;
var statearr_11550_11572 = state_11545__$1;
(statearr_11550_11572[(2)] = inst_11520);

(statearr_11550_11572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11546 === (6))){
var state_11545__$1 = state_11545;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11545__$1,(8),chan);
} else {
if((state_val_11546 === (3))){
var inst_11543 = (state_11545[(2)]);
var state_11545__$1 = state_11545;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11545__$1,inst_11543);
} else {
if((state_val_11546 === (2))){
var _ = (function (){var statearr_11551 = state_11545;
(statearr_11551[(4)] = cljs.core.cons((5),(state_11545[(4)])));

return statearr_11551;
})();
var inst_11526 = coll;
var inst_11527 = inst_11526;
var state_11545__$1 = (function (){var statearr_11552 = state_11545;
(statearr_11552[(7)] = inst_11527);

return statearr_11552;
})();
var statearr_11553_11573 = state_11545__$1;
(statearr_11553_11573[(2)] = null);

(statearr_11553_11573[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11546 === (11))){
var inst_11538 = (state_11545[(2)]);
var state_11545__$1 = state_11545;
var statearr_11555_11574 = state_11545__$1;
(statearr_11555_11574[(2)] = inst_11538);

(statearr_11555_11574[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11546 === (9))){
var inst_11527 = (state_11545[(7)]);
var state_11545__$1 = state_11545;
var statearr_11556_11575 = state_11545__$1;
(statearr_11556_11575[(2)] = inst_11527);

(statearr_11556_11575[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11546 === (5))){
var _ = (function (){var statearr_11557 = state_11545;
(statearr_11557[(4)] = cljs.core.rest((state_11545[(4)])));

return statearr_11557;
})();
var state_11545__$1 = state_11545;
var ex11554 = (state_11545__$1[(2)]);
var statearr_11558_11576 = state_11545__$1;
(statearr_11558_11576[(5)] = ex11554);


var statearr_11559_11577 = state_11545__$1;
(statearr_11559_11577[(1)] = (4));

(statearr_11559_11577[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11546 === (10))){
var inst_11527 = (state_11545[(7)]);
var inst_11531 = (state_11545[(8)]);
var inst_11535 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_11527,inst_11531);
var inst_11527__$1 = inst_11535;
var state_11545__$1 = (function (){var statearr_11560 = state_11545;
(statearr_11560[(7)] = inst_11527__$1);

return statearr_11560;
})();
var statearr_11561_11578 = state_11545__$1;
(statearr_11561_11578[(2)] = null);

(statearr_11561_11578[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11546 === (8))){
var inst_11531 = (state_11545[(8)]);
var inst_11530 = (state_11545[(2)]);
var inst_11531__$1 = fluree.db.util.async.throw_err(inst_11530);
var inst_11532 = (inst_11531__$1 == null);
var state_11545__$1 = (function (){var statearr_11562 = state_11545;
(statearr_11562[(8)] = inst_11531__$1);

return statearr_11562;
})();
if(cljs.core.truth_(inst_11532)){
var statearr_11563_11579 = state_11545__$1;
(statearr_11563_11579[(1)] = (9));

} else {
var statearr_11564_11580 = state_11545__$1;
(statearr_11564_11580[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_11565 = [null,null,null,null,null,null,null,null,null];
(statearr_11565[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2733__auto__);

(statearr_11565[(1)] = (1));

return statearr_11565;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2733__auto____1 = (function (state_11545){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_11545);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e11566){var ex__2736__auto__ = e11566;
var statearr_11567_11581 = state_11545;
(statearr_11567_11581[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_11545[(4)]))){
var statearr_11568_11582 = state_11545;
(statearr_11568_11582[(1)] = cljs.core.first((state_11545[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11583 = state_11545;
state_11545 = G__11583;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2733__auto__ = function(state_11545){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2733__auto____1.call(this,state_11545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2733__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2733__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_11569 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_11569[(6)] = c__2755__auto__);

return statearr_11569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
