// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__13918 = arguments.length;
switch (G__13918) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675),fluree.db.util.core.keyword__GT_str], null));
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__13919 = options;
var map__13919__$1 = cljs.core.__destructure_map(map__13919);
var keyword_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13919__$1,new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675));
var keyfn = (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.cljs$core$IFn$_invoke$arity$2(k,thisfn);
});
var thisfn = (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js(x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return (keyword_fn.cljs$core$IFn$_invoke$arity$1 ? keyword_fn.cljs$core$IFn$_invoke$arity$1(x__$1) : keyword_fn.call(null,x__$1));
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_(x__$1)){
var m = ({});
var seq__13946_13967 = cljs.core.seq(x__$1);
var chunk__13947_13968 = null;
var count__13948_13969 = (0);
var i__13949_13970 = (0);
while(true){
if((i__13949_13970 < count__13948_13969)){
var vec__13956_13971 = chunk__13947_13968.cljs$core$IIndexed$_nth$arity$2(null,i__13949_13970);
var k_13972 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13956_13971,(0),null);
var v_13973 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13956_13971,(1),null);
goog.object.set(m,keyfn(k_13972),fluree$db$util$json$thisfn(v_13973));


var G__13974 = seq__13946_13967;
var G__13975 = chunk__13947_13968;
var G__13976 = count__13948_13969;
var G__13977 = (i__13949_13970 + (1));
seq__13946_13967 = G__13974;
chunk__13947_13968 = G__13975;
count__13948_13969 = G__13976;
i__13949_13970 = G__13977;
continue;
} else {
var temp__5753__auto___13978 = cljs.core.seq(seq__13946_13967);
if(temp__5753__auto___13978){
var seq__13946_13979__$1 = temp__5753__auto___13978;
if(cljs.core.chunked_seq_QMARK_(seq__13946_13979__$1)){
var c__4649__auto___13980 = cljs.core.chunk_first(seq__13946_13979__$1);
var G__13981 = cljs.core.chunk_rest(seq__13946_13979__$1);
var G__13982 = c__4649__auto___13980;
var G__13983 = cljs.core.count(c__4649__auto___13980);
var G__13984 = (0);
seq__13946_13967 = G__13981;
chunk__13947_13968 = G__13982;
count__13948_13969 = G__13983;
i__13949_13970 = G__13984;
continue;
} else {
var vec__13959_13985 = cljs.core.first(seq__13946_13979__$1);
var k_13986 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13959_13985,(0),null);
var v_13987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13959_13985,(1),null);
goog.object.set(m,keyfn(k_13986),fluree$db$util$json$thisfn(v_13987));


var G__13988 = cljs.core.next(seq__13946_13979__$1);
var G__13989 = null;
var G__13990 = (0);
var G__13991 = (0);
seq__13946_13967 = G__13988;
chunk__13947_13968 = G__13989;
count__13948_13969 = G__13990;
i__13949_13970 = G__13991;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x__$1)){
var arr = [];
var seq__13962_13992 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree$db$util$json$thisfn,x__$1));
var chunk__13963_13993 = null;
var count__13964_13994 = (0);
var i__13965_13995 = (0);
while(true){
if((i__13965_13995 < count__13964_13994)){
var x_13996__$2 = chunk__13963_13993.cljs$core$IIndexed$_nth$arity$2(null,i__13965_13995);
arr.push(x_13996__$2);


var G__13997 = seq__13962_13992;
var G__13998 = chunk__13963_13993;
var G__13999 = count__13964_13994;
var G__14000 = (i__13965_13995 + (1));
seq__13962_13992 = G__13997;
chunk__13963_13993 = G__13998;
count__13964_13994 = G__13999;
i__13965_13995 = G__14000;
continue;
} else {
var temp__5753__auto___14001 = cljs.core.seq(seq__13962_13992);
if(temp__5753__auto___14001){
var seq__13962_14002__$1 = temp__5753__auto___14001;
if(cljs.core.chunked_seq_QMARK_(seq__13962_14002__$1)){
var c__4649__auto___14003 = cljs.core.chunk_first(seq__13962_14002__$1);
var G__14004 = cljs.core.chunk_rest(seq__13962_14002__$1);
var G__14005 = c__4649__auto___14003;
var G__14006 = cljs.core.count(c__4649__auto___14003);
var G__14007 = (0);
seq__13962_13992 = G__14004;
chunk__13963_13993 = G__14005;
count__13964_13994 = G__14006;
i__13965_13995 = G__14007;
continue;
} else {
var x_14008__$2 = cljs.core.first(seq__13962_14002__$1);
arr.push(x_14008__$2);


var G__14009 = cljs.core.next(seq__13962_14002__$1);
var G__14010 = null;
var G__14011 = (0);
var G__14012 = (0);
seq__13962_13992 = G__14009;
chunk__13963_13993 = G__14010;
count__13964_13994 = G__14011;
i__13965_13995 = G__14012;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});
return thisfn(x);
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2);

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string(x))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1(x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js(x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8(fluree.db.util.json.stringify(x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),depth)){
return ((cljs.core.every_QMARK_(cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count(coordinates))));
} else {
return (((!((coordinates == null)))) && (((cljs.core.every_QMARK_(cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__14013_SHARP_){
var G__14014 = (depth - (1));
var G__14015 = p1__14013_SHARP_;
return (fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2(G__14014,G__14015) : fluree.db.util.json.valid_coordinates_QMARK_.call(null,G__14014,G__14015));
}),coordinates))))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_(coordinates)) && (((((4) <= cljs.core.count(coordinates))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(coordinates),cljs.core.last(coordinates))))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__14016 = cljs.core.get_global_hierarchy;
return (fexpr__14016.cljs$core$IFn$_invoke$arity$0 ? fexpr__14016.cljs$core$IFn$_invoke$arity$0() : fexpr__14016.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.util.json","valid-geojson?"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Feature",(function (geometry){
var and__4221__auto__ = (function (){var or__4223__auto__ = (function (){var G__14017 = new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry);
return (fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1(G__14017) : fluree.db.util.json.valid_geojson_QMARK_.call(null,G__14017));
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__4221__auto__)){
return ((cljs.core.map_QMARK_(new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry))) || ((new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__4221__auto__;
}
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((1),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((4),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_((function (p1__14018_SHARP_){
return cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,p1__14018_SHARP_);
}),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (geometry){
return false;
}));
