// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5753__auto__)){
var st = temp__5753__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__16899 = cljs.core._EQ_;
var expr__16900 = e.getLastErrorCode();
if(cljs.core.truth_((pred__16899.cljs$core$IFn$_invoke$arity$2 ? pred__16899.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__16900) : pred__16899.call(null,goog.net.ErrorCode.NO_ERROR,expr__16900)))){
return new cljs.core.Keyword("xhttp","no-error","xhttp/no-error",1902047248);
} else {
if(cljs.core.truth_((pred__16899.cljs$core$IFn$_invoke$arity$2 ? pred__16899.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__16900) : pred__16899.call(null,goog.net.ErrorCode.EXCEPTION,expr__16900)))){
return new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040);
} else {
if(cljs.core.truth_((pred__16899.cljs$core$IFn$_invoke$arity$2 ? pred__16899.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__16900) : pred__16899.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__16900)))){
return new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305);
} else {
if(cljs.core.truth_((pred__16899.cljs$core$IFn$_invoke$arity$2 ? pred__16899.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__16900) : pred__16899.call(null,goog.net.ErrorCode.ABORT,expr__16900)))){
return new cljs.core.Keyword("xhttp","abort","xhttp/abort",666776046);
} else {
if(cljs.core.truth_((pred__16899.cljs$core$IFn$_invoke$arity$2 ? pred__16899.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__16900) : pred__16899.call(null,goog.net.ErrorCode.TIMEOUT,expr__16900)))){
return new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562);
} else {
return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4221__auto__ = status;
if(cljs.core.truth_(and__4221__auto__)){
return (status > (0));
} else {
return and__4221__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__16902 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__16902,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__16902;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__16903 = opts;
var map__16903__$1 = cljs.core.__destructure_map(map__16903);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16903__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16903__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16903__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__16904 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__16904__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__16904,headers], 0)):G__16904);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__16904__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__16904__$1;
}
})();
try{var G__16906_16912 = url;
var G__16907_16913 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__16908_16914 = "POST";
var G__16909_16915 = fluree.db.util.json.stringify(message);
var G__16910_16916 = cljs.core.clj__GT_js(headers__$1);
var G__16911_16917 = request_timeout;
goog.net.XhrIo.send(G__16906_16912,G__16907_16913,G__16908_16914,G__16909_16915,G__16910_16916,G__16911_16917);
}catch (e16905){var e_16918 = e16905;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_16918);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__16919 = opts;
var map__16919__$1 = cljs.core.__destructure_map(map__16919);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16919__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16919__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16919__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16919__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16919__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__16920 = cljs.core.PersistentArrayMap.EMPTY;
var G__16920__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__16920,headers], 0)):G__16920);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__16920__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__16920__$1;
}
})();
try{var G__16922_16929 = url;
var G__16923_16930 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__16928 = output_format;
var G__16928__$1 = (((G__16928 instanceof cljs.core.Keyword))?G__16928.fqn:null);
switch (G__16928__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__16924_16931 = "GET";
var G__16925_16932 = body;
var G__16926_16933 = cljs.core.clj__GT_js(headers__$1);
var G__16927_16934 = request_timeout;
goog.net.XhrIo.send(G__16922_16929,G__16923_16930,G__16924_16931,G__16925_16932,G__16926_16933,G__16927_16934);
}catch (e16921){var e_16936 = e16921;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_16936);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__16937 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__16937,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__16937;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_16970){
var state_val_16971 = (state_16970[(1)]);
if((state_val_16971 === (7))){
var inst_16966 = (state_16970[(2)]);
var state_16970__$1 = state_16970;
var statearr_16972_16997 = state_16970__$1;
(statearr_16972_16997[(2)] = inst_16966);

(statearr_16972_16997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16971 === (1))){
var state_16970__$1 = state_16970;
var statearr_16973_16998 = state_16970__$1;
(statearr_16973_16998[(2)] = null);

(statearr_16973_16998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16971 === (4))){
var inst_16941 = (state_16970[(7)]);
var inst_16941__$1 = (state_16970[(2)]);
var inst_16942 = (inst_16941__$1 == null);
var state_16970__$1 = (function (){var statearr_16974 = state_16970;
(statearr_16974[(7)] = inst_16941__$1);

return statearr_16974;
})();
if(cljs.core.truth_(inst_16942)){
var statearr_16975_16999 = state_16970__$1;
(statearr_16975_16999[(1)] = (5));

} else {
var statearr_16976_17000 = state_16970__$1;
(statearr_16976_17000[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16971 === (6))){
var inst_16941 = (state_16970[(7)]);
var inst_16949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16941,(0),null);
var inst_16950 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16941,(1),null);
var state_16970__$1 = (function (){var statearr_16977 = state_16970;
(statearr_16977[(8)] = inst_16950);

(statearr_16977[(9)] = inst_16949);

return statearr_16977;
})();
var statearr_16978_17001 = state_16970__$1;
(statearr_16978_17001[(2)] = null);

(statearr_16978_17001[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16971 === (3))){
var inst_16968 = (state_16970[(2)]);
var state_16970__$1 = state_16970;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16970__$1,inst_16968);
} else {
if((state_val_16971 === (2))){
var state_16970__$1 = state_16970;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16970__$1,(4),pub_chan);
} else {
if((state_val_16971 === (11))){
var _ = (function (){var statearr_16980 = state_16970;
(statearr_16980[(4)] = cljs.core.rest((state_16970[(4)])));

return statearr_16980;
})();
var state_16970__$1 = state_16970;
var ex16979 = (state_16970__$1[(2)]);
var statearr_16981_17002 = state_16970__$1;
(statearr_16981_17002[(5)] = ex16979);


if((ex16979 instanceof Error)){
var statearr_16982_17003 = state_16970__$1;
(statearr_16982_17003[(1)] = (10));

(statearr_16982_17003[(5)] = null);

} else {
throw ex16979;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16971 === (9))){
var inst_16963 = (state_16970[(2)]);
var state_16970__$1 = (function (){var statearr_16983 = state_16970;
(statearr_16983[(10)] = inst_16963);

return statearr_16983;
})();
var statearr_16984_17004 = state_16970__$1;
(statearr_16984_17004[(2)] = null);

(statearr_16984_17004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16971 === (5))){
var inst_16944 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_16970__$1 = state_16970;
var statearr_16985_17005 = state_16970__$1;
(statearr_16985_17005[(2)] = inst_16944);

(statearr_16985_17005[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16971 === (10))){
var inst_16950 = (state_16970[(8)]);
var inst_16951 = (state_16970[(2)]);
var inst_16952 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_16951,"Websocket send message error:",inst_16951], 0));
var inst_16953 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_16950,false);
var state_16970__$1 = (function (){var statearr_16986 = state_16970;
(statearr_16986[(11)] = inst_16952);

return statearr_16986;
})();
var statearr_16987_17006 = state_16970__$1;
(statearr_16987_17006[(2)] = inst_16953);

(statearr_16987_17006[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16971 === (8))){
var inst_16950 = (state_16970[(8)]);
var inst_16949 = (state_16970[(9)]);
var _ = (function (){var statearr_16988 = state_16970;
(statearr_16988[(4)] = cljs.core.cons((11),(state_16970[(4)])));

return statearr_16988;
})();
var inst_16959 = ws.send(inst_16949);
var inst_16960 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_16950,true);
var ___$1 = (function (){var statearr_16989 = state_16970;
(statearr_16989[(4)] = cljs.core.rest((state_16970[(4)])));

return statearr_16989;
})();
var state_16970__$1 = (function (){var statearr_16990 = state_16970;
(statearr_16990[(12)] = inst_16959);

return statearr_16990;
})();
var statearr_16991_17007 = state_16970__$1;
(statearr_16991_17007[(2)] = inst_16960);

(statearr_16991_17007[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto____0 = (function (){
var statearr_16992 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16992[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto__);

(statearr_16992[(1)] = (1));

return statearr_16992;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto____1 = (function (state_16970){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_16970);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e16993){var ex__2736__auto__ = e16993;
var statearr_16994_17008 = state_16970;
(statearr_16994_17008[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_16970[(4)]))){
var statearr_16995_17009 = state_16970;
(statearr_16995_17009[(1)] = cljs.core.first((state_16970[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17010 = state_16970;
state_16970 = G__17010;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto__ = function(state_16970){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto____1.call(this,state_16970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_16996 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_16996[(6)] = c__2755__auto__);

return statearr_16996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2755__auto___17049 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17036){
var state_val_17037 = (state_17036[(1)]);
if((state_val_17037 === (1))){
var inst_17015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17016 = [open_QMARK_,timeout_chan];
var inst_17017 = (new cljs.core.PersistentVector(null,2,(5),inst_17015,inst_17016,null));
var state_17036__$1 = state_17036;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_17036__$1,(2),inst_17017,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_17037 === (2))){
var inst_17019 = (state_17036[(2)]);
var inst_17020 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17019,(0),null);
var inst_17021 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17019,(1),null);
var inst_17022 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17021,timeout_chan);
var state_17036__$1 = (function (){var statearr_17038 = state_17036;
(statearr_17038[(7)] = inst_17020);

return statearr_17038;
})();
if(inst_17022){
var statearr_17039_17050 = state_17036__$1;
(statearr_17039_17050[(1)] = (3));

} else {
var statearr_17040_17051 = state_17036__$1;
(statearr_17040_17051[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17037 === (3))){
var inst_17024 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_17025 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17026 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_17027 = cljs.core.PersistentHashMap.fromArrays(inst_17025,inst_17026);
var inst_17028 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17024,inst_17027);
var inst_17029 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_17028);
var inst_17030 = fluree.db.util.xhttp.close_websocket(ws);
var state_17036__$1 = (function (){var statearr_17041 = state_17036;
(statearr_17041[(8)] = inst_17029);

return statearr_17041;
})();
var statearr_17042_17052 = state_17036__$1;
(statearr_17042_17052[(2)] = inst_17030);

(statearr_17042_17052[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17037 === (4))){
var inst_17032 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_17036__$1 = state_17036;
var statearr_17043_17053 = state_17036__$1;
(statearr_17043_17053[(2)] = inst_17032);

(statearr_17043_17053[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17037 === (5))){
var inst_17034 = (state_17036[(2)]);
var state_17036__$1 = state_17036;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17036__$1,inst_17034);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto____0 = (function (){
var statearr_17044 = [null,null,null,null,null,null,null,null,null];
(statearr_17044[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto__);

(statearr_17044[(1)] = (1));

return statearr_17044;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto____1 = (function (state_17036){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17036);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17045){var ex__2736__auto__ = e17045;
var statearr_17046_17054 = state_17036;
(statearr_17046_17054[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17036[(4)]))){
var statearr_17047_17055 = state_17036;
(statearr_17047_17055[(1)] = cljs.core.first((state_17036[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17056 = state_17036;
state_17036 = G__17056;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto__ = function(state_17036){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto____1.call(this,state_17036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17048 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17048[(6)] = c__2755__auto___17049);

return statearr_17048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
