// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('goog.string.format');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__66444 = opts_SINGLEQUOTE_;
var map__66444__$1 = cljs.core.__destructure_map(map__66444);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66444__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__66446 = arguments.length;
switch (G__66446) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__66449 = arguments.length;
switch (G__66449) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__66452 = arguments.length;
switch (G__66452) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__66455 = arguments.length;
switch (G__66455) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__66458 = arguments.length;
switch (G__66458) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__66461 = arguments.length;
switch (G__66461) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__4835__auto__ = [];
var len__4829__auto___66470 = arguments.length;
var i__4830__auto___66471 = (0);
while(true){
if((i__4830__auto___66471 < len__4829__auto___66470)){
args__4835__auto__.push((arguments[i__4830__auto___66471]));

var G__66472 = (i__4830__auto___66471 + (1));
i__4830__auto___66471 = G__66472;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__66466){
var vec__66467 = p__66466;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66467,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq66463){
var G__66464 = cljs.core.first(seq66463);
var seq66463__$1 = cljs.core.next(seq66463);
var G__66465 = cljs.core.first(seq66463__$1);
var seq66463__$2 = cljs.core.next(seq66463__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66464,G__66465,seq66463__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66491){
var state_val_66492 = (state_66491[(1)]);
if((state_val_66492 === (1))){
var state_66491__$1 = state_66491;
var statearr_66493_66508 = state_66491__$1;
(statearr_66493_66508[(2)] = null);

(statearr_66493_66508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66492 === (2))){
var _ = (function (){var statearr_66494 = state_66491;
(statearr_66494[(4)] = cljs.core.cons((5),(state_66491[(4)])));

return statearr_66494;
})();
var state_66491__$1 = state_66491;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66491__$1,(6),db);
} else {
if((state_val_66492 === (3))){
var inst_66489 = (state_66491[(2)]);
var state_66491__$1 = state_66491;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66491__$1,inst_66489);
} else {
if((state_val_66492 === (4))){
var inst_66473 = (state_66491[(2)]);
var inst_66474 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66473], 0));
var inst_66475 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66473) : reject.call(null,inst_66473));
var state_66491__$1 = (function (){var statearr_66496 = state_66491;
(statearr_66496[(7)] = inst_66474);

return statearr_66496;
})();
var statearr_66497_66509 = state_66491__$1;
(statearr_66497_66509[(2)] = inst_66475);

(statearr_66497_66509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66492 === (5))){
var _ = (function (){var statearr_66498 = state_66491;
(statearr_66498[(4)] = cljs.core.rest((state_66491[(4)])));

return statearr_66498;
})();
var state_66491__$1 = state_66491;
var ex66495 = (state_66491__$1[(2)]);
var statearr_66499_66510 = state_66491__$1;
(statearr_66499_66510[(5)] = ex66495);


var statearr_66500_66511 = state_66491__$1;
(statearr_66500_66511[(1)] = (4));

(statearr_66500_66511[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66492 === (6))){
var inst_66482 = (state_66491[(2)]);
var inst_66483 = fluree.db.util.async.throw_err(inst_66482);
var inst_66484 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_66483);
var inst_66485 = cljs.core.clj__GT_js(inst_66484);
var inst_66486 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66485) : resolve.call(null,inst_66485));
var _ = (function (){var statearr_66501 = state_66491;
(statearr_66501[(4)] = cljs.core.rest((state_66491[(4)])));

return statearr_66501;
})();
var state_66491__$1 = state_66491;
var statearr_66502_66512 = state_66491__$1;
(statearr_66502_66512[(2)] = inst_66486);

(statearr_66502_66512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2733__auto__ = null;
var flureedb$db_schema_$_state_machine__2733__auto____0 = (function (){
var statearr_66503 = [null,null,null,null,null,null,null,null];
(statearr_66503[(0)] = flureedb$db_schema_$_state_machine__2733__auto__);

(statearr_66503[(1)] = (1));

return statearr_66503;
});
var flureedb$db_schema_$_state_machine__2733__auto____1 = (function (state_66491){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66491);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66504){var ex__2736__auto__ = e66504;
var statearr_66505_66513 = state_66491;
(statearr_66505_66513[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66491[(4)]))){
var statearr_66506_66514 = state_66491;
(statearr_66506_66514[(1)] = cljs.core.first((state_66491[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66515 = state_66491;
state_66491 = G__66515;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2733__auto__ = function(state_66491){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2733__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2733__auto____1.call(this,state_66491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2733__auto____0;
flureedb$db_schema_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2733__auto____1;
return flureedb$db_schema_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66507 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66507[(6)] = c__2755__auto__);

return statearr_66507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__66517 = arguments.length;
switch (G__66517) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66587){
var state_val_66588 = (state_66587[(1)]);
if((state_val_66588 === (7))){
var inst_66530 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66587__$1 = state_66587;
var statearr_66589_66634 = state_66587__$1;
(statearr_66589_66634[(2)] = inst_66530);

(statearr_66589_66634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (20))){
var inst_66538 = (state_66587[(7)]);
var inst_66562 = (state_66587[(2)]);
var state_66587__$1 = (function (){var statearr_66590 = state_66587;
(statearr_66590[(8)] = inst_66562);

return statearr_66590;
})();
if(cljs.core.truth_(inst_66538)){
var statearr_66591_66635 = state_66587__$1;
(statearr_66591_66635[(1)] = (21));

} else {
var statearr_66592_66636 = state_66587__$1;
(statearr_66592_66636[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (1))){
var state_66587__$1 = state_66587;
var statearr_66593_66637 = state_66587__$1;
(statearr_66593_66637[(2)] = null);

(statearr_66593_66637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (24))){
var inst_66569 = (state_66587[(2)]);
var inst_66570 = fluree.db.util.async.throw_err(inst_66569);
var state_66587__$1 = state_66587;
var statearr_66594_66638 = state_66587__$1;
(statearr_66594_66638[(2)] = inst_66570);

(statearr_66594_66638[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (4))){
var inst_66518 = (state_66587[(2)]);
var inst_66519 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66518], 0));
var inst_66520 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66518) : reject.call(null,inst_66518));
var state_66587__$1 = (function (){var statearr_66595 = state_66587;
(statearr_66595[(9)] = inst_66519);

return statearr_66595;
})();
var statearr_66596_66639 = state_66587__$1;
(statearr_66596_66639[(2)] = inst_66520);

(statearr_66596_66639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (15))){
var inst_66551 = (state_66587[(10)]);
var inst_66553 = fluree.db.util.core.without_nils(inst_66551);
var inst_66554 = fluree.db.util.json.stringify(inst_66553);
var state_66587__$1 = state_66587;
var statearr_66597_66640 = state_66587__$1;
(statearr_66597_66640[(2)] = inst_66554);

(statearr_66597_66640[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (21))){
var inst_66562 = (state_66587[(8)]);
var inst_66557 = (state_66587[(11)]);
var inst_66564 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_66565 = [inst_66557,inst_66562];
var inst_66566 = cljs.core.PersistentHashMap.fromArrays(inst_66564,inst_66565);
var inst_66567 = fluree.db.operations.command_async(conn,inst_66566);
var state_66587__$1 = state_66587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66587__$1,(24),inst_66567);
} else {
if((state_val_66588 === (13))){
var inst_66539 = (state_66587[(12)]);
var inst_66546 = (inst_66539 + (30000));
var state_66587__$1 = state_66587;
var statearr_66598_66641 = state_66587__$1;
(statearr_66598_66641[(2)] = inst_66546);

(statearr_66598_66641[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (22))){
var inst_66551 = (state_66587[(10)]);
var inst_66572 = fluree.db.operations.unsigned_command_async(conn,inst_66551);
var state_66587__$1 = state_66587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66587__$1,(25),inst_66572);
} else {
if((state_val_66588 === (6))){
var state_66587__$1 = state_66587;
var statearr_66599_66642 = state_66587__$1;
(statearr_66599_66642[(2)] = null);

(statearr_66599_66642[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (25))){
var inst_66574 = (state_66587[(2)]);
var inst_66575 = fluree.db.util.async.throw_err(inst_66574);
var state_66587__$1 = state_66587;
var statearr_66600_66643 = state_66587__$1;
(statearr_66600_66643[(2)] = inst_66575);

(statearr_66600_66643[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (17))){
var inst_66538 = (state_66587[(7)]);
var inst_66557 = (state_66587[(2)]);
var state_66587__$1 = (function (){var statearr_66601 = state_66587;
(statearr_66601[(11)] = inst_66557);

return statearr_66601;
})();
if(cljs.core.truth_(inst_66538)){
var statearr_66602_66644 = state_66587__$1;
(statearr_66602_66644[(1)] = (18));

} else {
var statearr_66603_66645 = state_66587__$1;
(statearr_66603_66645[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (3))){
var inst_66585 = (state_66587[(2)]);
var state_66587__$1 = state_66587;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66587__$1,inst_66585);
} else {
if((state_val_66588 === (12))){
var inst_66536 = (state_66587[(13)]);
var state_66587__$1 = state_66587;
var statearr_66604_66646 = state_66587__$1;
(statearr_66604_66646[(2)] = inst_66536);

(statearr_66604_66646[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (2))){
var _ = (function (){var statearr_66605 = state_66587;
(statearr_66605[(4)] = cljs.core.cons((5),(state_66587[(4)])));

return statearr_66605;
})();
var inst_66527 = (opts == null);
var state_66587__$1 = state_66587;
if(cljs.core.truth_(inst_66527)){
var statearr_66606_66647 = state_66587__$1;
(statearr_66606_66647[(1)] = (6));

} else {
var statearr_66607_66648 = state_66587__$1;
(statearr_66607_66648[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (23))){
var inst_66577 = (state_66587[(2)]);
var inst_66578 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66579 = [(200),inst_66577];
var inst_66580 = cljs.core.PersistentHashMap.fromArrays(inst_66578,inst_66579);
var inst_66581 = cljs.core.clj__GT_js(inst_66580);
var inst_66582 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66581) : resolve.call(null,inst_66581));
var _ = (function (){var statearr_66608 = state_66587;
(statearr_66608[(4)] = cljs.core.rest((state_66587[(4)])));

return statearr_66608;
})();
var state_66587__$1 = state_66587;
var statearr_66609_66649 = state_66587__$1;
(statearr_66609_66649[(2)] = inst_66582);

(statearr_66609_66649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (19))){
var state_66587__$1 = state_66587;
var statearr_66610_66650 = state_66587__$1;
(statearr_66610_66650[(2)] = null);

(statearr_66610_66650[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (11))){
var inst_66536 = (state_66587[(13)]);
var inst_66543 = (state_66587[(2)]);
var state_66587__$1 = (function (){var statearr_66612 = state_66587;
(statearr_66612[(14)] = inst_66543);

return statearr_66612;
})();
if(cljs.core.truth_(inst_66536)){
var statearr_66613_66651 = state_66587__$1;
(statearr_66613_66651[(1)] = (12));

} else {
var statearr_66614_66652 = state_66587__$1;
(statearr_66614_66652[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (9))){
var inst_66535 = (state_66587[(15)]);
var state_66587__$1 = state_66587;
var statearr_66615_66653 = state_66587__$1;
(statearr_66615_66653[(2)] = inst_66535);

(statearr_66615_66653[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (5))){
var _ = (function (){var statearr_66616 = state_66587;
(statearr_66616[(4)] = cljs.core.rest((state_66587[(4)])));

return statearr_66616;
})();
var state_66587__$1 = state_66587;
var ex66611 = (state_66587__$1[(2)]);
var statearr_66617_66654 = state_66587__$1;
(statearr_66617_66654[(5)] = ex66611);


var statearr_66618_66655 = state_66587__$1;
(statearr_66618_66655[(1)] = (4));

(statearr_66618_66655[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (14))){
var inst_66543 = (state_66587[(14)]);
var inst_66538 = (state_66587[(7)]);
var inst_66548 = (state_66587[(2)]);
var inst_66549 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_66550 = [new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),ledger,inst_66543,inst_66548];
var inst_66551 = cljs.core.PersistentHashMap.fromArrays(inst_66549,inst_66550);
var state_66587__$1 = (function (){var statearr_66619 = state_66587;
(statearr_66619[(10)] = inst_66551);

return statearr_66619;
})();
if(cljs.core.truth_(inst_66538)){
var statearr_66620_66656 = state_66587__$1;
(statearr_66620_66656[(1)] = (15));

} else {
var statearr_66621_66657 = state_66587__$1;
(statearr_66621_66657[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (16))){
var state_66587__$1 = state_66587;
var statearr_66622_66658 = state_66587__$1;
(statearr_66622_66658[(2)] = null);

(statearr_66622_66658[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (10))){
var inst_66539 = (state_66587[(12)]);
var state_66587__$1 = state_66587;
var statearr_66623_66659 = state_66587__$1;
(statearr_66623_66659[(2)] = inst_66539);

(statearr_66623_66659[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (18))){
var inst_66538 = (state_66587[(7)]);
var inst_66557 = (state_66587[(11)]);
var inst_66559 = fluree.crypto.sign_message(inst_66557,inst_66538);
var state_66587__$1 = state_66587;
var statearr_66624_66660 = state_66587__$1;
(statearr_66624_66660[(2)] = inst_66559);

(statearr_66624_66660[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66588 === (8))){
var inst_66535 = (state_66587[(15)]);
var inst_66532 = (state_66587[(2)]);
var inst_66533 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_66532);
var inst_66534 = cljs.core.__destructure_map(inst_66532);
var inst_66535__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66534,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_66536 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66534,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_66537 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_66534,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_66538 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66534,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_66539 = fluree.db.util.core.current_time_millis();
var state_66587__$1 = (function (){var statearr_66625 = state_66587;
(statearr_66625[(16)] = inst_66533);

(statearr_66625[(12)] = inst_66539);

(statearr_66625[(15)] = inst_66535__$1);

(statearr_66625[(17)] = inst_66537);

(statearr_66625[(13)] = inst_66536);

(statearr_66625[(7)] = inst_66538);

return statearr_66625;
})();
if(cljs.core.truth_(inst_66535__$1)){
var statearr_66626_66661 = state_66587__$1;
(statearr_66626_66661[(1)] = (9));

} else {
var statearr_66627_66662 = state_66587__$1;
(statearr_66627_66662[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_66628 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66628[(0)] = flureedb$state_machine__2733__auto__);

(statearr_66628[(1)] = (1));

return statearr_66628;
});
var flureedb$state_machine__2733__auto____1 = (function (state_66587){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66587);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66629){var ex__2736__auto__ = e66629;
var statearr_66630_66663 = state_66587;
(statearr_66630_66663[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66587[(4)]))){
var statearr_66631_66664 = state_66587;
(statearr_66631_66664[(1)] = cljs.core.first((state_66587[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66665 = state_66587;
state_66587 = G__66665;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_66587){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_66587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66632 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66632[(6)] = c__2755__auto__);

return statearr_66632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66684){
var state_val_66685 = (state_66684[(1)]);
if((state_val_66685 === (1))){
var state_66684__$1 = state_66684;
var statearr_66686_66701 = state_66684__$1;
(statearr_66686_66701[(2)] = null);

(statearr_66686_66701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66685 === (2))){
var _ = (function (){var statearr_66687 = state_66684;
(statearr_66687[(4)] = cljs.core.cons((5),(state_66684[(4)])));

return statearr_66687;
})();
var inst_66674 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_66684__$1 = state_66684;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66684__$1,(6),inst_66674);
} else {
if((state_val_66685 === (3))){
var inst_66682 = (state_66684[(2)]);
var state_66684__$1 = state_66684;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66684__$1,inst_66682);
} else {
if((state_val_66685 === (4))){
var inst_66666 = (state_66684[(2)]);
var inst_66667 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66666], 0));
var inst_66668 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66666) : reject.call(null,inst_66666));
var state_66684__$1 = (function (){var statearr_66689 = state_66684;
(statearr_66689[(7)] = inst_66667);

return statearr_66689;
})();
var statearr_66690_66702 = state_66684__$1;
(statearr_66690_66702[(2)] = inst_66668);

(statearr_66690_66702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66685 === (5))){
var _ = (function (){var statearr_66691 = state_66684;
(statearr_66691[(4)] = cljs.core.rest((state_66684[(4)])));

return statearr_66691;
})();
var state_66684__$1 = state_66684;
var ex66688 = (state_66684__$1[(2)]);
var statearr_66692_66703 = state_66684__$1;
(statearr_66692_66703[(5)] = ex66688);


var statearr_66693_66704 = state_66684__$1;
(statearr_66693_66704[(1)] = (4));

(statearr_66693_66704[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66685 === (6))){
var inst_66676 = (state_66684[(2)]);
var inst_66677 = fluree.db.util.async.throw_err(inst_66676);
var inst_66678 = cljs.core.clj__GT_js(inst_66677);
var inst_66679 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66678) : resolve.call(null,inst_66678));
var _ = (function (){var statearr_66694 = state_66684;
(statearr_66694[(4)] = cljs.core.rest((state_66684[(4)])));

return statearr_66694;
})();
var state_66684__$1 = state_66684;
var statearr_66695_66705 = state_66684__$1;
(statearr_66695_66705[(2)] = inst_66679);

(statearr_66695_66705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2733__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2733__auto____0 = (function (){
var statearr_66696 = [null,null,null,null,null,null,null,null];
(statearr_66696[(0)] = flureedb$ledger_stats_$_state_machine__2733__auto__);

(statearr_66696[(1)] = (1));

return statearr_66696;
});
var flureedb$ledger_stats_$_state_machine__2733__auto____1 = (function (state_66684){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66684);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66697){var ex__2736__auto__ = e66697;
var statearr_66698_66706 = state_66684;
(statearr_66698_66706[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66684[(4)]))){
var statearr_66699_66707 = state_66684;
(statearr_66699_66707[(1)] = cljs.core.first((state_66684[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66708 = state_66684;
state_66684 = G__66708;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2733__auto__ = function(state_66684){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2733__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2733__auto____1.call(this,state_66684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2733__auto____0;
flureedb$ledger_stats_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2733__auto____1;
return flureedb$ledger_stats_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66700 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66700[(6)] = c__2755__auto__);

return statearr_66700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than db-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 * - :jwt         - token for Fluree On-Demand access
 * 
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__66710 = arguments.length;
switch (G__66710) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66834){
var state_val_66835 = (state_66834[(1)]);
if((state_val_66835 === (7))){
var inst_66733 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66834__$1 = state_66834;
var statearr_66836_66906 = state_66834__$1;
(statearr_66836_66906[(2)] = inst_66733);

(statearr_66836_66906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (20))){
var inst_66740 = (state_66834[(7)]);
var inst_66779 = (state_66834[(2)]);
var inst_66780 = fluree.db.util.core.current_time_millis();
var state_66834__$1 = (function (){var statearr_66837 = state_66834;
(statearr_66837[(8)] = inst_66779);

(statearr_66837[(9)] = inst_66780);

return statearr_66837;
})();
if(cljs.core.truth_(inst_66740)){
var statearr_66838_66907 = state_66834__$1;
(statearr_66838_66907[(1)] = (21));

} else {
var statearr_66839_66908 = state_66834__$1;
(statearr_66839_66908[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (27))){
var inst_66748 = (state_66834[(10)]);
var inst_66793 = (state_66834[(11)]);
var inst_66795 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66793,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_66748);
var state_66834__$1 = state_66834;
var statearr_66840_66909 = state_66834__$1;
(statearr_66840_66909[(2)] = inst_66795);

(statearr_66840_66909[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (1))){
var state_66834__$1 = state_66834;
var statearr_66841_66910 = state_66834__$1;
(statearr_66841_66910[(2)] = null);

(statearr_66841_66910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (24))){
var inst_66746 = (state_66834[(12)]);
var state_66834__$1 = state_66834;
var statearr_66842_66911 = state_66834__$1;
(statearr_66842_66911[(2)] = inst_66746);

(statearr_66842_66911[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (39))){
var inst_66816 = (state_66834[(2)]);
var inst_66817 = fluree.db.util.async.throw_err(inst_66816);
var state_66834__$1 = state_66834;
var statearr_66843_66912 = state_66834__$1;
(statearr_66843_66912[(2)] = inst_66817);

(statearr_66843_66912[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (4))){
var inst_66711 = (state_66834[(2)]);
var inst_66712 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66711], 0));
var inst_66713 = cljs.core.ex_data(inst_66711);
var inst_66714 = cljs.core.ex_message(inst_66711);
var inst_66715 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66713,new cljs.core.Keyword(null,"message","message",-406056002),inst_66714);
var inst_66716 = cljs.core.clj__GT_js(inst_66715);
var inst_66717 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66716) : reject.call(null,inst_66716));
var state_66834__$1 = (function (){var statearr_66844 = state_66834;
(statearr_66844[(13)] = inst_66712);

return statearr_66844;
})();
var statearr_66845_66913 = state_66834__$1;
(statearr_66845_66913[(2)] = inst_66717);

(statearr_66845_66913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (15))){
var inst_66769 = (state_66834[(14)]);
var inst_66771 = fluree.db.graphdb.validate_ledger_name(inst_66769,"alias");
var state_66834__$1 = state_66834;
var statearr_66846_66914 = state_66834__$1;
(statearr_66846_66914[(2)] = inst_66771);

(statearr_66846_66914[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (21))){
var inst_66740 = (state_66834[(7)]);
var state_66834__$1 = state_66834;
var statearr_66847_66915 = state_66834__$1;
(statearr_66847_66915[(2)] = inst_66740);

(statearr_66847_66915[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (31))){
var state_66834__$1 = state_66834;
var statearr_66848_66916 = state_66834__$1;
(statearr_66848_66916[(2)] = null);

(statearr_66848_66916[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (32))){
var inst_66742 = (state_66834[(15)]);
var inst_66804 = (state_66834[(2)]);
var state_66834__$1 = (function (){var statearr_66849 = state_66834;
(statearr_66849[(16)] = inst_66804);

return statearr_66849;
})();
if(cljs.core.truth_(inst_66742)){
var statearr_66850_66917 = state_66834__$1;
(statearr_66850_66917[(1)] = (33));

} else {
var statearr_66851_66918 = state_66834__$1;
(statearr_66851_66918[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (40))){
var inst_66821 = (state_66834[(2)]);
var inst_66822 = fluree.db.util.async.throw_err(inst_66821);
var state_66834__$1 = state_66834;
var statearr_66852_66919 = state_66834__$1;
(statearr_66852_66919[(2)] = inst_66822);

(statearr_66852_66919[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (33))){
var inst_66742 = (state_66834[(15)]);
var inst_66804 = (state_66834[(16)]);
var inst_66806 = fluree.crypto.sign_message(inst_66804,inst_66742);
var state_66834__$1 = state_66834;
var statearr_66853_66920 = state_66834__$1;
(statearr_66853_66920[(2)] = inst_66806);

(statearr_66853_66920[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (13))){
var state_66834__$1 = state_66834;
var statearr_66854_66921 = state_66834__$1;
(statearr_66854_66921[(2)] = null);

(statearr_66854_66921[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (22))){
var inst_66780 = (state_66834[(9)]);
var state_66834__$1 = state_66834;
var statearr_66855_66922 = state_66834__$1;
(statearr_66855_66922[(2)] = inst_66780);

(statearr_66855_66922[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (36))){
var inst_66804 = (state_66834[(16)]);
var inst_66809 = (state_66834[(17)]);
var inst_66811 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_66812 = [inst_66804,inst_66809];
var inst_66813 = cljs.core.PersistentHashMap.fromArrays(inst_66811,inst_66812);
var inst_66814 = fluree.db.operations.command_async(conn,inst_66813);
var state_66834__$1 = state_66834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66834__$1,(39),inst_66814);
} else {
if((state_val_66835 === (29))){
var inst_66742 = (state_66834[(15)]);
var inst_66798 = (state_66834[(2)]);
var state_66834__$1 = (function (){var statearr_66856 = state_66834;
(statearr_66856[(18)] = inst_66798);

return statearr_66856;
})();
if(cljs.core.truth_(inst_66742)){
var statearr_66857_66923 = state_66834__$1;
(statearr_66857_66923[(1)] = (30));

} else {
var statearr_66858_66924 = state_66834__$1;
(statearr_66858_66924[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (6))){
var state_66834__$1 = state_66834;
var statearr_66859_66925 = state_66834__$1;
(statearr_66859_66925[(2)] = null);

(statearr_66859_66925[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (28))){
var inst_66793 = (state_66834[(11)]);
var state_66834__$1 = state_66834;
var statearr_66860_66926 = state_66834__$1;
(statearr_66860_66926[(2)] = inst_66793);

(statearr_66860_66926[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (25))){
var inst_66780 = (state_66834[(9)]);
var inst_66787 = (inst_66780 + (30000));
var state_66834__$1 = state_66834;
var statearr_66861_66927 = state_66834__$1;
(statearr_66861_66927[(2)] = inst_66787);

(statearr_66861_66927[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (34))){
var state_66834__$1 = state_66834;
var statearr_66862_66928 = state_66834__$1;
(statearr_66862_66928[(2)] = null);

(statearr_66862_66928[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (17))){
var inst_66750 = (state_66834[(19)]);
var inst_66774 = (state_66834[(2)]);
var state_66834__$1 = (function (){var statearr_66863 = state_66834;
(statearr_66863[(20)] = inst_66774);

return statearr_66863;
})();
if(cljs.core.truth_(inst_66750)){
var statearr_66864_66929 = state_66834__$1;
(statearr_66864_66929[(1)] = (18));

} else {
var statearr_66865_66930 = state_66834__$1;
(statearr_66865_66930[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (3))){
var inst_66832 = (state_66834[(2)]);
var state_66834__$1 = state_66834;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66834__$1,inst_66832);
} else {
if((state_val_66835 === (12))){
var inst_66764 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_66834__$1 = state_66834;
var statearr_66866_66931 = state_66834__$1;
(statearr_66866_66931[(2)] = inst_66764);

(statearr_66866_66931[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (2))){
var _ = (function (){var statearr_66867 = state_66834;
(statearr_66867[(4)] = cljs.core.cons((5),(state_66834[(4)])));

return statearr_66867;
})();
var inst_66730 = (opts == null);
var state_66834__$1 = state_66834;
if(cljs.core.truth_(inst_66730)){
var statearr_66868_66932 = state_66834__$1;
(statearr_66868_66932[(1)] = (6));

} else {
var statearr_66869_66933 = state_66834__$1;
(statearr_66869_66933[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (23))){
var inst_66746 = (state_66834[(12)]);
var inst_66784 = (state_66834[(2)]);
var state_66834__$1 = (function (){var statearr_66870 = state_66834;
(statearr_66870[(21)] = inst_66784);

return statearr_66870;
})();
if(cljs.core.truth_(inst_66746)){
var statearr_66871_66934 = state_66834__$1;
(statearr_66871_66934[(1)] = (24));

} else {
var statearr_66872_66935 = state_66834__$1;
(statearr_66872_66935[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (35))){
var inst_66742 = (state_66834[(15)]);
var inst_66809 = (state_66834[(2)]);
var state_66834__$1 = (function (){var statearr_66873 = state_66834;
(statearr_66873[(17)] = inst_66809);

return statearr_66873;
})();
if(cljs.core.truth_(inst_66742)){
var statearr_66874_66936 = state_66834__$1;
(statearr_66874_66936[(1)] = (36));

} else {
var statearr_66875_66937 = state_66834__$1;
(statearr_66875_66937[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (19))){
var state_66834__$1 = state_66834;
var statearr_66876_66938 = state_66834__$1;
(statearr_66876_66938[(2)] = null);

(statearr_66876_66938[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (11))){
var inst_66760 = (state_66834[(22)]);
var inst_66753 = (state_66834[(23)]);
var inst_66750 = (state_66834[(19)]);
var inst_66760__$1 = (state_66834[(2)]);
var inst_66761 = fluree.db.graphdb.validate_ledger_name(inst_66760__$1,"ledger");
var inst_66762 = fluree.db.graphdb.validate_ledger_name(inst_66753,"network");
var state_66834__$1 = (function (){var statearr_66878 = state_66834;
(statearr_66878[(24)] = inst_66761);

(statearr_66878[(22)] = inst_66760__$1);

(statearr_66878[(25)] = inst_66762);

return statearr_66878;
})();
if(cljs.core.truth_(inst_66750)){
var statearr_66879_66939 = state_66834__$1;
(statearr_66879_66939[(1)] = (12));

} else {
var statearr_66880_66940 = state_66834__$1;
(statearr_66880_66940[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (9))){
var inst_66754 = (state_66834[(26)]);
var inst_66757 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_66754,(1));
var state_66834__$1 = state_66834;
var statearr_66881_66941 = state_66834__$1;
(statearr_66881_66941[(2)] = inst_66757);

(statearr_66881_66941[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (5))){
var _ = (function (){var statearr_66882 = state_66834;
(statearr_66882[(4)] = cljs.core.rest((state_66834[(4)])));

return statearr_66882;
})();
var state_66834__$1 = state_66834;
var ex66877 = (state_66834__$1[(2)]);
var statearr_66883_66942 = state_66834__$1;
(statearr_66883_66942[(5)] = ex66877);


var statearr_66884_66943 = state_66834__$1;
(statearr_66884_66943[(1)] = (4));

(statearr_66884_66943[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (14))){
var inst_66750 = (state_66834[(19)]);
var inst_66767 = (state_66834[(2)]);
var inst_66768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66767,(0),null);
var inst_66769 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66767,(1),null);
var state_66834__$1 = (function (){var statearr_66885 = state_66834;
(statearr_66885[(14)] = inst_66769);

(statearr_66885[(27)] = inst_66768);

return statearr_66885;
})();
if(cljs.core.truth_(inst_66750)){
var statearr_66886_66944 = state_66834__$1;
(statearr_66886_66944[(1)] = (15));

} else {
var statearr_66887_66945 = state_66834__$1;
(statearr_66887_66945[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (26))){
var inst_66747 = (state_66834[(28)]);
var inst_66751 = (state_66834[(29)]);
var inst_66741 = (state_66834[(30)]);
var inst_66748 = (state_66834[(10)]);
var inst_66760 = (state_66834[(22)]);
var inst_66779 = (state_66834[(8)]);
var inst_66784 = (state_66834[(21)]);
var inst_66745 = (state_66834[(31)]);
var inst_66753 = (state_66834[(23)]);
var inst_66749 = (state_66834[(32)]);
var inst_66744 = (state_66834[(33)]);
var inst_66739 = (state_66834[(34)]);
var inst_66743 = (state_66834[(35)]);
var inst_66789 = (state_66834[(2)]);
var inst_66790 = [new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_66791 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66753),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66760)].join('');
var inst_66792 = [inst_66744,inst_66745,inst_66791,new cljs.core.Keyword(null,"new-db","new-db",1305352401),inst_66789,inst_66747,inst_66779,inst_66751,inst_66749,inst_66739,inst_66784,inst_66741,inst_66743];
var inst_66793 = cljs.core.PersistentHashMap.fromArrays(inst_66790,inst_66792);
var state_66834__$1 = (function (){var statearr_66888 = state_66834;
(statearr_66888[(11)] = inst_66793);

return statearr_66888;
})();
if(cljs.core.truth_(inst_66748)){
var statearr_66889_66946 = state_66834__$1;
(statearr_66889_66946[(1)] = (27));

} else {
var statearr_66890_66947 = state_66834__$1;
(statearr_66890_66947[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (16))){
var state_66834__$1 = state_66834;
var statearr_66891_66948 = state_66834__$1;
(statearr_66891_66948[(2)] = null);

(statearr_66891_66948[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (38))){
var inst_66824 = (state_66834[(2)]);
var inst_66825 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66826 = [(200),inst_66824];
var inst_66827 = cljs.core.PersistentHashMap.fromArrays(inst_66825,inst_66826);
var inst_66828 = cljs.core.clj__GT_js(inst_66827);
var inst_66829 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66828) : resolve.call(null,inst_66828));
var _ = (function (){var statearr_66892 = state_66834;
(statearr_66892[(4)] = cljs.core.rest((state_66834[(4)])));

return statearr_66892;
})();
var state_66834__$1 = state_66834;
var statearr_66893_66949 = state_66834__$1;
(statearr_66893_66949[(2)] = inst_66829);

(statearr_66893_66949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (30))){
var inst_66798 = (state_66834[(18)]);
var inst_66800 = fluree.db.util.core.without_nils(inst_66798);
var inst_66801 = fluree.db.util.json.stringify(inst_66800);
var state_66834__$1 = state_66834;
var statearr_66894_66950 = state_66834__$1;
(statearr_66894_66950[(2)] = inst_66801);

(statearr_66894_66950[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (10))){
var inst_66754 = (state_66834[(26)]);
var state_66834__$1 = state_66834;
var statearr_66895_66951 = state_66834__$1;
(statearr_66895_66951[(2)] = inst_66754);

(statearr_66895_66951[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (18))){
var inst_66769 = (state_66834[(14)]);
var inst_66768 = (state_66834[(27)]);
var inst_66776 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66768),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66769)].join('');
var state_66834__$1 = state_66834;
var statearr_66896_66952 = state_66834__$1;
(statearr_66896_66952[(2)] = inst_66776);

(statearr_66896_66952[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66835 === (37))){
var inst_66798 = (state_66834[(18)]);
var inst_66819 = fluree.db.operations.unsigned_command_async(conn,inst_66798);
var state_66834__$1 = state_66834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66834__$1,(40),inst_66819);
} else {
if((state_val_66835 === (8))){
var inst_66754 = (state_66834[(26)]);
var inst_66735 = (state_66834[(2)]);
var inst_66736 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_66735);
var inst_66737 = cljs.core.__destructure_map(inst_66735);
var inst_66738 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_66737,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_66739 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66737,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_66740 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66737,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_66741 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66737,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_66742 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66737,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_66743 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66737,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_66744 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66737,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_66745 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66737,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_66746 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66737,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_66747 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66737,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_66748 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66737,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_66749 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66737,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_66750 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66737,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_66751 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66737,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_66752 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_66753 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66752,(0),null);
var inst_66754__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66752,(1),null);
var inst_66755 = clojure.string.starts_with_QMARK_(inst_66754__$1,"$");
var state_66834__$1 = (function (){var statearr_66897 = state_66834;
(statearr_66897[(28)] = inst_66747);

(statearr_66897[(29)] = inst_66751);

(statearr_66897[(30)] = inst_66741);

(statearr_66897[(15)] = inst_66742);

(statearr_66897[(36)] = inst_66736);

(statearr_66897[(10)] = inst_66748);

(statearr_66897[(7)] = inst_66740);

(statearr_66897[(31)] = inst_66745);

(statearr_66897[(12)] = inst_66746);

(statearr_66897[(23)] = inst_66753);

(statearr_66897[(32)] = inst_66749);

(statearr_66897[(26)] = inst_66754__$1);

(statearr_66897[(33)] = inst_66744);

(statearr_66897[(34)] = inst_66739);

(statearr_66897[(35)] = inst_66743);

(statearr_66897[(37)] = inst_66738);

(statearr_66897[(19)] = inst_66750);

return statearr_66897;
})();
if(inst_66755){
var statearr_66898_66953 = state_66834__$1;
(statearr_66898_66953[(1)] = (9));

} else {
var statearr_66899_66954 = state_66834__$1;
(statearr_66899_66954[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_66900 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66900[(0)] = flureedb$state_machine__2733__auto__);

(statearr_66900[(1)] = (1));

return statearr_66900;
});
var flureedb$state_machine__2733__auto____1 = (function (state_66834){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66834);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66901){var ex__2736__auto__ = e66901;
var statearr_66902_66955 = state_66834;
(statearr_66902_66955[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66834[(4)]))){
var statearr_66903_66956 = state_66834;
(statearr_66903_66956[(1)] = cljs.core.first((state_66834[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66957 = state_66834;
state_66834 = G__66957;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_66834){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_66834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66904 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66904[(6)] = c__2755__auto__);

return statearr_66904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_66977){
var state_val_66978 = (state_66977[(1)]);
if((state_val_66978 === (1))){
var state_66977__$1 = state_66977;
var statearr_66979_66995 = state_66977__$1;
(statearr_66979_66995[(2)] = null);

(statearr_66979_66995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66978 === (2))){
var _ = (function (){var statearr_66980 = state_66977;
(statearr_66980[(4)] = cljs.core.cons((5),(state_66977[(4)])));

return statearr_66980;
})();
var inst_66967 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_66968 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_66977__$1 = (function (){var statearr_66981 = state_66977;
(statearr_66981[(7)] = inst_66967);

return statearr_66981;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66977__$1,(6),inst_66968);
} else {
if((state_val_66978 === (3))){
var inst_66975 = (state_66977[(2)]);
var state_66977__$1 = state_66977;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66977__$1,inst_66975);
} else {
if((state_val_66978 === (4))){
var inst_66958 = (state_66977[(2)]);
var inst_66959 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66958], 0));
var inst_66960 = cljs.core.clj__GT_js(inst_66958);
var inst_66961 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66960) : reject.call(null,inst_66960));
var state_66977__$1 = (function (){var statearr_66983 = state_66977;
(statearr_66983[(8)] = inst_66959);

return statearr_66983;
})();
var statearr_66984_66996 = state_66977__$1;
(statearr_66984_66996[(2)] = inst_66961);

(statearr_66984_66996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66978 === (5))){
var _ = (function (){var statearr_66985 = state_66977;
(statearr_66985[(4)] = cljs.core.rest((state_66977[(4)])));

return statearr_66985;
})();
var state_66977__$1 = state_66977;
var ex66982 = (state_66977__$1[(2)]);
var statearr_66986_66997 = state_66977__$1;
(statearr_66986_66997[(5)] = ex66982);


var statearr_66987_66998 = state_66977__$1;
(statearr_66987_66998[(1)] = (4));

(statearr_66987_66998[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66978 === (6))){
var inst_66970 = (state_66977[(2)]);
var inst_66971 = cljs.core.clj__GT_js(inst_66970);
var inst_66972 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66971) : resolve.call(null,inst_66971));
var _ = (function (){var statearr_66988 = state_66977;
(statearr_66988[(4)] = cljs.core.rest((state_66977[(4)])));

return statearr_66988;
})();
var state_66977__$1 = state_66977;
var statearr_66989_66999 = state_66977__$1;
(statearr_66989_66999[(2)] = inst_66972);

(statearr_66989_66999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2733__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2733__auto____0 = (function (){
var statearr_66990 = [null,null,null,null,null,null,null,null,null];
(statearr_66990[(0)] = flureedb$monitor_tx_$_state_machine__2733__auto__);

(statearr_66990[(1)] = (1));

return statearr_66990;
});
var flureedb$monitor_tx_$_state_machine__2733__auto____1 = (function (state_66977){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_66977);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e66991){var ex__2736__auto__ = e66991;
var statearr_66992_67000 = state_66977;
(statearr_66992_67000[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_66977[(4)]))){
var statearr_66993_67001 = state_66977;
(statearr_66993_67001[(1)] = cljs.core.first((state_66977[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67002 = state_66977;
state_66977 = G__67002;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2733__auto__ = function(state_66977){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2733__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2733__auto____1.call(this,state_66977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2733__auto____0;
flureedb$monitor_tx_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2733__auto____1;
return flureedb$monitor_tx_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_66994 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_66994[(6)] = c__2755__auto__);

return statearr_66994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 * - jwt         - token to access Fluree On-Demand
 * 
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__67004 = arguments.length;
switch (G__67004) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_67030){
var state_val_67031 = (state_67030[(1)]);
if((state_val_67031 === (7))){
var inst_67016 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67030__$1 = state_67030;
var statearr_67032_67053 = state_67030__$1;
(statearr_67032_67053[(2)] = inst_67016);

(statearr_67032_67053[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67031 === (1))){
var state_67030__$1 = state_67030;
var statearr_67033_67054 = state_67030__$1;
(statearr_67033_67054[(2)] = null);

(statearr_67033_67054[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67031 === (4))){
var inst_67005 = (state_67030[(2)]);
var inst_67006 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67005], 0));
var inst_67007 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67005) : reject.call(null,inst_67005));
var state_67030__$1 = (function (){var statearr_67034 = state_67030;
(statearr_67034[(7)] = inst_67006);

return statearr_67034;
})();
var statearr_67035_67055 = state_67030__$1;
(statearr_67035_67055[(2)] = inst_67007);

(statearr_67035_67055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67031 === (6))){
var state_67030__$1 = state_67030;
var statearr_67036_67056 = state_67030__$1;
(statearr_67036_67056[(2)] = null);

(statearr_67036_67056[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67031 === (3))){
var inst_67028 = (state_67030[(2)]);
var state_67030__$1 = state_67030;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67030__$1,inst_67028);
} else {
if((state_val_67031 === (2))){
var _ = (function (){var statearr_67038 = state_67030;
(statearr_67038[(4)] = cljs.core.cons((5),(state_67030[(4)])));

return statearr_67038;
})();
var inst_67013 = (opts == null);
var state_67030__$1 = state_67030;
if(cljs.core.truth_(inst_67013)){
var statearr_67039_67057 = state_67030__$1;
(statearr_67039_67057[(1)] = (6));

} else {
var statearr_67040_67058 = state_67030__$1;
(statearr_67040_67058[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67031 === (9))){
var inst_67023 = (state_67030[(2)]);
var inst_67024 = cljs.core.clj__GT_js(inst_67023);
var inst_67025 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67024) : resolve.call(null,inst_67024));
var _ = (function (){var statearr_67041 = state_67030;
(statearr_67041[(4)] = cljs.core.rest((state_67030[(4)])));

return statearr_67041;
})();
var state_67030__$1 = state_67030;
var statearr_67042_67059 = state_67030__$1;
(statearr_67042_67059[(2)] = inst_67025);

(statearr_67042_67059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67031 === (5))){
var _ = (function (){var statearr_67043 = state_67030;
(statearr_67043[(4)] = cljs.core.rest((state_67030[(4)])));

return statearr_67043;
})();
var state_67030__$1 = state_67030;
var ex67037 = (state_67030__$1[(2)]);
var statearr_67044_67060 = state_67030__$1;
(statearr_67044_67060[(5)] = ex67037);


var statearr_67045_67061 = state_67030__$1;
(statearr_67045_67061[(1)] = (4));

(statearr_67045_67061[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67031 === (8))){
var inst_67018 = (state_67030[(2)]);
var inst_67019 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_67018);
var inst_67020 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67021 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_67020,inst_67018);
var state_67030__$1 = (function (){var statearr_67046 = state_67030;
(statearr_67046[(8)] = inst_67019);

return statearr_67046;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67030__$1,(9),inst_67021);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_67047 = [null,null,null,null,null,null,null,null,null];
(statearr_67047[(0)] = flureedb$state_machine__2733__auto__);

(statearr_67047[(1)] = (1));

return statearr_67047;
});
var flureedb$state_machine__2733__auto____1 = (function (state_67030){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_67030);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e67048){var ex__2736__auto__ = e67048;
var statearr_67049_67062 = state_67030;
(statearr_67049_67062[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_67030[(4)]))){
var statearr_67050_67063 = state_67030;
(statearr_67050_67063[(1)] = cljs.core.first((state_67030[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67064 = state_67030;
state_67030 = G__67064;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_67030){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_67030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_67051 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_67051[(6)] = c__2755__auto__);

return statearr_67051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *   to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *   :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__67066 = arguments.length;
switch (G__67066) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_67095){
var state_val_67096 = (state_67095[(1)]);
if((state_val_67096 === (7))){
var inst_67078 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67095__$1 = state_67095;
var statearr_67097_67118 = state_67095__$1;
(statearr_67097_67118[(2)] = inst_67078);

(statearr_67097_67118[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67096 === (1))){
var state_67095__$1 = state_67095;
var statearr_67098_67119 = state_67095__$1;
(statearr_67098_67119[(2)] = null);

(statearr_67098_67119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67096 === (4))){
var inst_67067 = (state_67095[(2)]);
var inst_67068 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67067], 0));
var inst_67069 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67067) : reject.call(null,inst_67067));
var state_67095__$1 = (function (){var statearr_67099 = state_67095;
(statearr_67099[(7)] = inst_67068);

return statearr_67099;
})();
var statearr_67100_67120 = state_67095__$1;
(statearr_67100_67120[(2)] = inst_67069);

(statearr_67100_67120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67096 === (6))){
var state_67095__$1 = state_67095;
var statearr_67101_67121 = state_67095__$1;
(statearr_67101_67121[(2)] = null);

(statearr_67101_67121[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67096 === (3))){
var inst_67093 = (state_67095[(2)]);
var state_67095__$1 = state_67095;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67095__$1,inst_67093);
} else {
if((state_val_67096 === (2))){
var _ = (function (){var statearr_67103 = state_67095;
(statearr_67103[(4)] = cljs.core.cons((5),(state_67095[(4)])));

return statearr_67103;
})();
var inst_67075 = (opts == null);
var state_67095__$1 = state_67095;
if(cljs.core.truth_(inst_67075)){
var statearr_67104_67122 = state_67095__$1;
(statearr_67104_67122[(1)] = (6));

} else {
var statearr_67105_67123 = state_67095__$1;
(statearr_67105_67123[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67096 === (9))){
var inst_67080 = (state_67095[(8)]);
var inst_67083 = (state_67095[(2)]);
var inst_67084 = fluree.db.util.async.throw_err(inst_67083);
var inst_67085 = fluree.db.query.block.block_range(inst_67084,start,end,inst_67080);
var state_67095__$1 = state_67095;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67095__$1,(10),inst_67085);
} else {
if((state_val_67096 === (5))){
var _ = (function (){var statearr_67106 = state_67095;
(statearr_67106[(4)] = cljs.core.rest((state_67095[(4)])));

return statearr_67106;
})();
var state_67095__$1 = state_67095;
var ex67102 = (state_67095__$1[(2)]);
var statearr_67107_67124 = state_67095__$1;
(statearr_67107_67124[(5)] = ex67102);


var statearr_67108_67125 = state_67095__$1;
(statearr_67108_67125[(1)] = (4));

(statearr_67108_67125[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67096 === (10))){
var inst_67087 = (state_67095[(2)]);
var inst_67088 = fluree.db.util.async.throw_err(inst_67087);
var inst_67089 = cljs.core.clj__GT_js(inst_67088);
var inst_67090 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67089) : resolve.call(null,inst_67089));
var _ = (function (){var statearr_67109 = state_67095;
(statearr_67109[(4)] = cljs.core.rest((state_67095[(4)])));

return statearr_67109;
})();
var state_67095__$1 = state_67095;
var statearr_67110_67126 = state_67095__$1;
(statearr_67110_67126[(2)] = inst_67090);

(statearr_67110_67126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67096 === (8))){
var inst_67080 = (state_67095[(8)]);
var inst_67080__$1 = (state_67095[(2)]);
var inst_67081 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67080__$1], 0));
var state_67095__$1 = (function (){var statearr_67111 = state_67095;
(statearr_67111[(8)] = inst_67080__$1);

return statearr_67111;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67095__$1,(9),inst_67081);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_67112 = [null,null,null,null,null,null,null,null,null];
(statearr_67112[(0)] = flureedb$state_machine__2733__auto__);

(statearr_67112[(1)] = (1));

return statearr_67112;
});
var flureedb$state_machine__2733__auto____1 = (function (state_67095){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_67095);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e67113){var ex__2736__auto__ = e67113;
var statearr_67114_67127 = state_67095;
(statearr_67114_67127[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_67095[(4)]))){
var statearr_67115_67128 = state_67095;
(statearr_67115_67128[(1)] = cljs.core.first((state_67095[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67129 = state_67095;
state_67095 = G__67129;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_67095){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_67095);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_67116 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_67116[(6)] = c__2755__auto__);

return statearr_67116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__67131 = arguments.length;
switch (G__67131) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_67166){
var state_val_67167 = (state_67166[(1)]);
if((state_val_67167 === (7))){
var inst_67144 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67166__$1 = state_67166;
var statearr_67168_67189 = state_67166__$1;
(statearr_67168_67189[(2)] = inst_67144);

(statearr_67168_67189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67167 === (1))){
var state_67166__$1 = state_67166;
var statearr_67169_67190 = state_67166__$1;
(statearr_67169_67190[(2)] = null);

(statearr_67169_67190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67167 === (4))){
var inst_67132 = (state_67166[(2)]);
var inst_67133 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67132], 0));
var inst_67134 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67132) : reject.call(null,inst_67132));
var state_67166__$1 = (function (){var statearr_67170 = state_67166;
(statearr_67170[(7)] = inst_67133);

return statearr_67170;
})();
var statearr_67171_67191 = state_67166__$1;
(statearr_67171_67191[(2)] = inst_67134);

(statearr_67171_67191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67167 === (6))){
var state_67166__$1 = state_67166;
var statearr_67172_67192 = state_67166__$1;
(statearr_67172_67192[(2)] = null);

(statearr_67172_67192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67167 === (3))){
var inst_67164 = (state_67166[(2)]);
var state_67166__$1 = state_67166;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67166__$1,inst_67164);
} else {
if((state_val_67167 === (2))){
var _ = (function (){var statearr_67174 = state_67166;
(statearr_67174[(4)] = cljs.core.cons((5),(state_67166[(4)])));

return statearr_67174;
})();
var inst_67141 = (opts == null);
var state_67166__$1 = state_67166;
if(cljs.core.truth_(inst_67141)){
var statearr_67175_67193 = state_67166__$1;
(statearr_67175_67193[(1)] = (6));

} else {
var statearr_67176_67194 = state_67166__$1;
(statearr_67176_67194[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67167 === (9))){
var inst_67150 = (state_67166[(8)]);
var inst_67146 = (state_67166[(9)]);
var inst_67149 = (state_67166[(10)]);
var inst_67153 = (state_67166[(2)]);
var inst_67154 = fluree.db.util.async.throw_err(inst_67153);
var inst_67155 = fluree.db.query.block.block_range(inst_67154,inst_67149,inst_67150,inst_67146);
var state_67166__$1 = state_67166;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67166__$1,(10),inst_67155);
} else {
if((state_val_67167 === (5))){
var _ = (function (){var statearr_67177 = state_67166;
(statearr_67177[(4)] = cljs.core.rest((state_67166[(4)])));

return statearr_67177;
})();
var state_67166__$1 = state_67166;
var ex67173 = (state_67166__$1[(2)]);
var statearr_67178_67195 = state_67166__$1;
(statearr_67178_67195[(5)] = ex67173);


var statearr_67179_67196 = state_67166__$1;
(statearr_67179_67196[(1)] = (4));

(statearr_67179_67196[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67167 === (10))){
var inst_67157 = (state_67166[(2)]);
var inst_67158 = fluree.db.util.async.throw_err(inst_67157);
var inst_67159 = fluree.db.query.range.block_with_tx_data(inst_67158);
var inst_67160 = cljs.core.clj__GT_js(inst_67159);
var inst_67161 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67160) : resolve.call(null,inst_67160));
var _ = (function (){var statearr_67180 = state_67166;
(statearr_67180[(4)] = cljs.core.rest((state_67166[(4)])));

return statearr_67180;
})();
var state_67166__$1 = state_67166;
var statearr_67181_67197 = state_67166__$1;
(statearr_67181_67197[(2)] = inst_67161);

(statearr_67181_67197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67167 === (8))){
var inst_67146 = (state_67166[(9)]);
var inst_67146__$1 = (state_67166[(2)]);
var inst_67147 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67148 = cljs.core.__destructure_map(inst_67147);
var inst_67149 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67148,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_67150 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67148,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_67151 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67146__$1], 0));
var state_67166__$1 = (function (){var statearr_67182 = state_67166;
(statearr_67182[(8)] = inst_67150);

(statearr_67182[(9)] = inst_67146__$1);

(statearr_67182[(10)] = inst_67149);

return statearr_67182;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67166__$1,(9),inst_67151);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_67183 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_67183[(0)] = flureedb$state_machine__2733__auto__);

(statearr_67183[(1)] = (1));

return statearr_67183;
});
var flureedb$state_machine__2733__auto____1 = (function (state_67166){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_67166);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e67184){var ex__2736__auto__ = e67184;
var statearr_67185_67198 = state_67166;
(statearr_67185_67198[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_67166[(4)]))){
var statearr_67186_67199 = state_67166;
(statearr_67186_67199[(1)] = cljs.core.first((state_67166[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67200 = state_67166;
state_67166 = G__67200;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_67166){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_67166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_67187 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_67187[(6)] = c__2755__auto__);

return statearr_67187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__67202 = arguments.length;
switch (G__67202) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_67269){
var state_val_67270 = (state_67269[(1)]);
if((state_val_67270 === (7))){
var inst_67215 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67269__$1 = state_67269;
var statearr_67271_67312 = state_67269__$1;
(statearr_67271_67312[(2)] = inst_67215);

(statearr_67271_67312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (20))){
var inst_67217 = (state_67269[(7)]);
var inst_67211 = (state_67269[(8)]);
var inst_67253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67254 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_67255 = (new cljs.core.PersistentVector(null,1,(5),inst_67253,inst_67254,null));
var inst_67256 = cljs.core.assoc_in(inst_67217,inst_67255,new cljs.core.Keyword(null,"block","block",664686210));
var inst_67257 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_67211,inst_67256);
var state_67269__$1 = state_67269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67269__$1,(23),inst_67257);
} else {
if((state_val_67270 === (1))){
var state_67269__$1 = state_67269;
var statearr_67272_67313 = state_67269__$1;
(statearr_67272_67313[(2)] = null);

(statearr_67272_67313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (4))){
var inst_67203 = (state_67269[(2)]);
var inst_67204 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67203], 0));
var inst_67205 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67203) : reject.call(null,inst_67203));
var state_67269__$1 = (function (){var statearr_67273 = state_67269;
(statearr_67273[(9)] = inst_67204);

return statearr_67273;
})();
var statearr_67274_67314 = state_67269__$1;
(statearr_67274_67314[(2)] = inst_67205);

(statearr_67274_67314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (15))){
var inst_67241 = (state_67269[(2)]);
var inst_67242 = fluree.db.util.async.throw_err(inst_67241);
var state_67269__$1 = state_67269;
var statearr_67275_67315 = state_67269__$1;
(statearr_67275_67315[(2)] = inst_67242);

(statearr_67275_67315[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (21))){
var inst_67262 = (state_67269[(2)]);
var inst_67263 = cljs.core.clj__GT_js(inst_67262);
var inst_67264 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67263) : resolve.call(null,inst_67263));
var _ = (function (){var statearr_67276 = state_67269;
(statearr_67276[(4)] = cljs.core.rest((state_67269[(4)])));

return statearr_67276;
})();
var state_67269__$1 = state_67269;
var statearr_67277_67316 = state_67269__$1;
(statearr_67277_67316[(2)] = inst_67264);

(statearr_67277_67316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (13))){
var state_67269__$1 = state_67269;
var statearr_67278_67317 = state_67269__$1;
(statearr_67278_67317[(2)] = null);

(statearr_67278_67317[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (22))){
var inst_67250 = (state_67269[(2)]);
var inst_67251 = fluree.db.util.async.throw_err(inst_67250);
var state_67269__$1 = state_67269;
var statearr_67279_67318 = state_67269__$1;
(statearr_67279_67318[(2)] = inst_67251);

(statearr_67279_67318[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (6))){
var state_67269__$1 = state_67269;
var statearr_67280_67319 = state_67269__$1;
(statearr_67280_67319[(2)] = null);

(statearr_67280_67319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (17))){
var state_67269__$1 = state_67269;
var statearr_67281_67320 = state_67269__$1;
(statearr_67281_67320[(2)] = null);

(statearr_67281_67320[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (3))){
var inst_67267 = (state_67269[(2)]);
var state_67269__$1 = state_67269;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67269__$1,inst_67267);
} else {
if((state_val_67270 === (12))){
var inst_67225 = (state_67269[(10)]);
var inst_67229 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_67269__$1 = (function (){var statearr_67282 = state_67269;
(statearr_67282[(11)] = inst_67229);

return statearr_67282;
})();
if(cljs.core.truth_(inst_67225)){
var statearr_67283_67321 = state_67269__$1;
(statearr_67283_67321[(1)] = (16));

} else {
var statearr_67284_67322 = state_67269__$1;
(statearr_67284_67322[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (2))){
var _ = (function (){var statearr_67285 = state_67269;
(statearr_67285[(4)] = cljs.core.cons((5),(state_67269[(4)])));

return statearr_67285;
})();
var inst_67211 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67212 = (opts == null);
var state_67269__$1 = (function (){var statearr_67286 = state_67269;
(statearr_67286[(8)] = inst_67211);

return statearr_67286;
})();
if(cljs.core.truth_(inst_67212)){
var statearr_67287_67323 = state_67269__$1;
(statearr_67287_67323[(1)] = (6));

} else {
var statearr_67288_67324 = state_67269__$1;
(statearr_67288_67324[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (23))){
var inst_67259 = (state_67269[(2)]);
var inst_67260 = fluree.db.util.async.throw_err(inst_67259);
var state_67269__$1 = state_67269;
var statearr_67289_67325 = state_67269__$1;
(statearr_67289_67325[(2)] = inst_67260);

(statearr_67289_67325[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (19))){
var inst_67217 = (state_67269[(7)]);
var inst_67245 = (state_67269[(12)]);
var inst_67211 = (state_67269[(8)]);
var inst_67248 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_67245,inst_67211,inst_67217);
var state_67269__$1 = state_67269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67269__$1,(22),inst_67248);
} else {
if((state_val_67270 === (11))){
var inst_67219 = (state_67269[(13)]);
var inst_67217 = (state_67269[(7)]);
var inst_67225 = (state_67269[(2)]);
var inst_67226 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_67217);
var inst_67227 = (inst_67219 == null);
var state_67269__$1 = (function (){var statearr_67291 = state_67269;
(statearr_67291[(14)] = inst_67226);

(statearr_67291[(10)] = inst_67225);

return statearr_67291;
})();
if(cljs.core.truth_(inst_67227)){
var statearr_67292_67326 = state_67269__$1;
(statearr_67292_67326[(1)] = (12));

} else {
var statearr_67293_67327 = state_67269__$1;
(statearr_67293_67327[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (9))){
var inst_67220 = (state_67269[(15)]);
var state_67269__$1 = state_67269;
var statearr_67294_67328 = state_67269__$1;
(statearr_67294_67328[(2)] = inst_67220);

(statearr_67294_67328[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (5))){
var _ = (function (){var statearr_67295 = state_67269;
(statearr_67295[(4)] = cljs.core.rest((state_67269[(4)])));

return statearr_67295;
})();
var state_67269__$1 = state_67269;
var ex67290 = (state_67269__$1[(2)]);
var statearr_67296_67329 = state_67269__$1;
(statearr_67296_67329[(5)] = ex67290);


var statearr_67297_67330 = state_67269__$1;
(statearr_67297_67330[(1)] = (4));

(statearr_67297_67330[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (14))){
var inst_67219 = (state_67269[(13)]);
var inst_67245 = (state_67269[(2)]);
var inst_67246 = (inst_67219 == null);
var state_67269__$1 = (function (){var statearr_67298 = state_67269;
(statearr_67298[(12)] = inst_67245);

return statearr_67298;
})();
if(cljs.core.truth_(inst_67246)){
var statearr_67299_67331 = state_67269__$1;
(statearr_67299_67331[(1)] = (19));

} else {
var statearr_67300_67332 = state_67269__$1;
(statearr_67300_67332[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (16))){
var inst_67225 = (state_67269[(10)]);
var inst_67231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67232 = ["_auth/id",inst_67225];
var inst_67233 = (new cljs.core.PersistentVector(null,2,(5),inst_67231,inst_67232,null));
var state_67269__$1 = state_67269;
var statearr_67301_67333 = state_67269__$1;
(statearr_67301_67333[(2)] = inst_67233);

(statearr_67301_67333[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (10))){
var inst_67217 = (state_67269[(7)]);
var inst_67223 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_67217);
var state_67269__$1 = state_67269;
var statearr_67302_67334 = state_67269__$1;
(statearr_67302_67334[(2)] = inst_67223);

(statearr_67302_67334[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67270 === (18))){
var inst_67229 = (state_67269[(11)]);
var inst_67226 = (state_67269[(14)]);
var inst_67236 = (state_67269[(2)]);
var inst_67237 = [inst_67236,inst_67226];
var inst_67238 = cljs.core.PersistentHashMap.fromArrays(inst_67229,inst_67237);
var inst_67239 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67238], 0));
var state_67269__$1 = state_67269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67269__$1,(15),inst_67239);
} else {
if((state_val_67270 === (8))){
var inst_67220 = (state_67269[(15)]);
var inst_67217 = (state_67269[(7)]);
var inst_67217__$1 = (state_67269[(2)]);
var inst_67218 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_67217__$1);
var inst_67219 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_67217__$1);
var inst_67220__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_67217__$1);
var state_67269__$1 = (function (){var statearr_67303 = state_67269;
(statearr_67303[(15)] = inst_67220__$1);

(statearr_67303[(13)] = inst_67219);

(statearr_67303[(7)] = inst_67217__$1);

(statearr_67303[(16)] = inst_67218);

return statearr_67303;
})();
if(cljs.core.truth_(inst_67220__$1)){
var statearr_67304_67335 = state_67269__$1;
(statearr_67304_67335[(1)] = (9));

} else {
var statearr_67305_67336 = state_67269__$1;
(statearr_67305_67336[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_67306 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67306[(0)] = flureedb$state_machine__2733__auto__);

(statearr_67306[(1)] = (1));

return statearr_67306;
});
var flureedb$state_machine__2733__auto____1 = (function (state_67269){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_67269);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e67307){var ex__2736__auto__ = e67307;
var statearr_67308_67337 = state_67269;
(statearr_67308_67337[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_67269[(4)]))){
var statearr_67309_67338 = state_67269;
(statearr_67309_67338[(1)] = cljs.core.first((state_67269[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67339 = state_67269;
state_67269 = G__67339;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_67269){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_67269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_67310 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_67310[(6)] = c__2755__auto__);

return statearr_67310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_67359){
var state_val_67360 = (state_67359[(1)]);
if((state_val_67360 === (1))){
var state_67359__$1 = state_67359;
var statearr_67361_67376 = state_67359__$1;
(statearr_67361_67376[(2)] = null);

(statearr_67361_67376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67360 === (2))){
var _ = (function (){var statearr_67362 = state_67359;
(statearr_67362[(4)] = cljs.core.cons((5),(state_67359[(4)])));

return statearr_67362;
})();
var inst_67348 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67349 = fluree.db.api.query.history_query_async(sources,inst_67348);
var state_67359__$1 = state_67359;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67359__$1,(6),inst_67349);
} else {
if((state_val_67360 === (3))){
var inst_67357 = (state_67359[(2)]);
var state_67359__$1 = state_67359;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67359__$1,inst_67357);
} else {
if((state_val_67360 === (4))){
var inst_67340 = (state_67359[(2)]);
var inst_67341 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67340], 0));
var inst_67342 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67340) : reject.call(null,inst_67340));
var state_67359__$1 = (function (){var statearr_67364 = state_67359;
(statearr_67364[(7)] = inst_67341);

return statearr_67364;
})();
var statearr_67365_67377 = state_67359__$1;
(statearr_67365_67377[(2)] = inst_67342);

(statearr_67365_67377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67360 === (5))){
var _ = (function (){var statearr_67366 = state_67359;
(statearr_67366[(4)] = cljs.core.rest((state_67359[(4)])));

return statearr_67366;
})();
var state_67359__$1 = state_67359;
var ex67363 = (state_67359__$1[(2)]);
var statearr_67367_67378 = state_67359__$1;
(statearr_67367_67378[(5)] = ex67363);


var statearr_67368_67379 = state_67359__$1;
(statearr_67368_67379[(1)] = (4));

(statearr_67368_67379[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67360 === (6))){
var inst_67351 = (state_67359[(2)]);
var inst_67352 = fluree.db.util.async.throw_err(inst_67351);
var inst_67353 = cljs.core.clj__GT_js(inst_67352);
var inst_67354 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67353) : resolve.call(null,inst_67353));
var _ = (function (){var statearr_67369 = state_67359;
(statearr_67369[(4)] = cljs.core.rest((state_67359[(4)])));

return statearr_67369;
})();
var state_67359__$1 = state_67359;
var statearr_67370_67380 = state_67359__$1;
(statearr_67370_67380[(2)] = inst_67354);

(statearr_67370_67380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2733__auto__ = null;
var flureedb$history_query_$_state_machine__2733__auto____0 = (function (){
var statearr_67371 = [null,null,null,null,null,null,null,null];
(statearr_67371[(0)] = flureedb$history_query_$_state_machine__2733__auto__);

(statearr_67371[(1)] = (1));

return statearr_67371;
});
var flureedb$history_query_$_state_machine__2733__auto____1 = (function (state_67359){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_67359);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e67372){var ex__2736__auto__ = e67372;
var statearr_67373_67381 = state_67359;
(statearr_67373_67381[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_67359[(4)]))){
var statearr_67374_67382 = state_67359;
(statearr_67374_67382[(1)] = cljs.core.first((state_67359[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67383 = state_67359;
state_67359 = G__67383;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2733__auto__ = function(state_67359){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2733__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2733__auto____1.call(this,state_67359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2733__auto____0;
flureedb$history_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2733__auto____1;
return flureedb$history_query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_67375 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_67375[(6)] = c__2755__auto__);

return statearr_67375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_67403){
var state_val_67404 = (state_67403[(1)]);
if((state_val_67404 === (1))){
var state_67403__$1 = state_67403;
var statearr_67405_67420 = state_67403__$1;
(statearr_67405_67420[(2)] = null);

(statearr_67405_67420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67404 === (2))){
var _ = (function (){var statearr_67406 = state_67403;
(statearr_67406[(4)] = cljs.core.cons((5),(state_67403[(4)])));

return statearr_67406;
})();
var inst_67392 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67393 = fluree.db.api.query.multi_query_async(sources,inst_67392);
var state_67403__$1 = state_67403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67403__$1,(6),inst_67393);
} else {
if((state_val_67404 === (3))){
var inst_67401 = (state_67403[(2)]);
var state_67403__$1 = state_67403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67403__$1,inst_67401);
} else {
if((state_val_67404 === (4))){
var inst_67384 = (state_67403[(2)]);
var inst_67385 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67384], 0));
var inst_67386 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67384) : reject.call(null,inst_67384));
var state_67403__$1 = (function (){var statearr_67408 = state_67403;
(statearr_67408[(7)] = inst_67385);

return statearr_67408;
})();
var statearr_67409_67421 = state_67403__$1;
(statearr_67409_67421[(2)] = inst_67386);

(statearr_67409_67421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67404 === (5))){
var _ = (function (){var statearr_67410 = state_67403;
(statearr_67410[(4)] = cljs.core.rest((state_67403[(4)])));

return statearr_67410;
})();
var state_67403__$1 = state_67403;
var ex67407 = (state_67403__$1[(2)]);
var statearr_67411_67422 = state_67403__$1;
(statearr_67411_67422[(5)] = ex67407);


var statearr_67412_67423 = state_67403__$1;
(statearr_67412_67423[(1)] = (4));

(statearr_67412_67423[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67404 === (6))){
var inst_67395 = (state_67403[(2)]);
var inst_67396 = fluree.db.util.async.throw_err(inst_67395);
var inst_67397 = cljs.core.clj__GT_js(inst_67396);
var inst_67398 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67397) : resolve.call(null,inst_67397));
var _ = (function (){var statearr_67413 = state_67403;
(statearr_67413[(4)] = cljs.core.rest((state_67403[(4)])));

return statearr_67413;
})();
var state_67403__$1 = state_67403;
var statearr_67414_67424 = state_67403__$1;
(statearr_67414_67424[(2)] = inst_67398);

(statearr_67414_67424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2733__auto__ = null;
var flureedb$multi_query_$_state_machine__2733__auto____0 = (function (){
var statearr_67415 = [null,null,null,null,null,null,null,null];
(statearr_67415[(0)] = flureedb$multi_query_$_state_machine__2733__auto__);

(statearr_67415[(1)] = (1));

return statearr_67415;
});
var flureedb$multi_query_$_state_machine__2733__auto____1 = (function (state_67403){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_67403);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e67416){var ex__2736__auto__ = e67416;
var statearr_67417_67425 = state_67403;
(statearr_67417_67425[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_67403[(4)]))){
var statearr_67418_67426 = state_67403;
(statearr_67418_67426[(1)] = cljs.core.first((state_67403[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67427 = state_67403;
state_67403 = G__67427;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2733__auto__ = function(state_67403){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2733__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2733__auto____1.call(this,state_67403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2733__auto____0;
flureedb$multi_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2733__auto____1;
return flureedb$multi_query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_67419 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_67419[(6)] = c__2755__auto__);

return statearr_67419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_67447){
var state_val_67448 = (state_67447[(1)]);
if((state_val_67448 === (1))){
var state_67447__$1 = state_67447;
var statearr_67449_67464 = state_67447__$1;
(statearr_67449_67464[(2)] = null);

(statearr_67449_67464[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67448 === (2))){
var _ = (function (){var statearr_67450 = state_67447;
(statearr_67450[(4)] = cljs.core.cons((5),(state_67447[(4)])));

return statearr_67450;
})();
var inst_67437 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67438 = fluree.db.api.query.query_async(sources,inst_67437);
var state_67447__$1 = state_67447;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67447__$1,(6),inst_67438);
} else {
if((state_val_67448 === (3))){
var inst_67445 = (state_67447[(2)]);
var state_67447__$1 = state_67447;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67447__$1,inst_67445);
} else {
if((state_val_67448 === (4))){
var inst_67428 = (state_67447[(2)]);
var inst_67429 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67428], 0));
var inst_67430 = cljs.core.clj__GT_js(inst_67428);
var inst_67431 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67430) : reject.call(null,inst_67430));
var state_67447__$1 = (function (){var statearr_67452 = state_67447;
(statearr_67452[(7)] = inst_67429);

return statearr_67452;
})();
var statearr_67453_67465 = state_67447__$1;
(statearr_67453_67465[(2)] = inst_67431);

(statearr_67453_67465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67448 === (5))){
var _ = (function (){var statearr_67454 = state_67447;
(statearr_67454[(4)] = cljs.core.rest((state_67447[(4)])));

return statearr_67454;
})();
var state_67447__$1 = state_67447;
var ex67451 = (state_67447__$1[(2)]);
var statearr_67455_67466 = state_67447__$1;
(statearr_67455_67466[(5)] = ex67451);


var statearr_67456_67467 = state_67447__$1;
(statearr_67456_67467[(1)] = (4));

(statearr_67456_67467[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67448 === (6))){
var inst_67440 = (state_67447[(2)]);
var inst_67441 = cljs.core.clj__GT_js(inst_67440);
var inst_67442 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67441) : resolve.call(null,inst_67441));
var _ = (function (){var statearr_67457 = state_67447;
(statearr_67457[(4)] = cljs.core.rest((state_67447[(4)])));

return statearr_67457;
})();
var state_67447__$1 = state_67447;
var statearr_67458_67468 = state_67447__$1;
(statearr_67458_67468[(2)] = inst_67442);

(statearr_67458_67468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2733__auto__ = null;
var flureedb$query_$_state_machine__2733__auto____0 = (function (){
var statearr_67459 = [null,null,null,null,null,null,null,null];
(statearr_67459[(0)] = flureedb$query_$_state_machine__2733__auto__);

(statearr_67459[(1)] = (1));

return statearr_67459;
});
var flureedb$query_$_state_machine__2733__auto____1 = (function (state_67447){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_67447);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e67460){var ex__2736__auto__ = e67460;
var statearr_67461_67469 = state_67447;
(statearr_67461_67469[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_67447[(4)]))){
var statearr_67462_67470 = state_67447;
(statearr_67462_67470[(1)] = cljs.core.first((state_67447[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67471 = state_67447;
state_67447 = G__67471;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2733__auto__ = function(state_67447){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2733__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2733__auto____1.call(this,state_67447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2733__auto____0;
flureedb$query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2733__auto____1;
return flureedb$query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_67463 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_67463[(6)] = c__2755__auto__);

return statearr_67463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__67473 = arguments.length;
switch (G__67473) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_67500){
var state_val_67501 = (state_67500[(1)]);
if((state_val_67501 === (7))){
var inst_67487 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67500__$1 = state_67500;
var statearr_67502_67523 = state_67500__$1;
(statearr_67502_67523[(2)] = inst_67487);

(statearr_67502_67523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67501 === (1))){
var state_67500__$1 = state_67500;
var statearr_67503_67524 = state_67500__$1;
(statearr_67503_67524[(2)] = null);

(statearr_67503_67524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67501 === (4))){
var inst_67474 = (state_67500[(2)]);
var inst_67475 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67474], 0));
var inst_67476 = cljs.core.clj__GT_js(inst_67474);
var inst_67477 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67476) : reject.call(null,inst_67476));
var state_67500__$1 = (function (){var statearr_67504 = state_67500;
(statearr_67504[(7)] = inst_67475);

return statearr_67504;
})();
var statearr_67505_67525 = state_67500__$1;
(statearr_67505_67525[(2)] = inst_67477);

(statearr_67505_67525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67501 === (6))){
var state_67500__$1 = state_67500;
var statearr_67506_67526 = state_67500__$1;
(statearr_67506_67526[(2)] = null);

(statearr_67506_67526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67501 === (3))){
var inst_67498 = (state_67500[(2)]);
var state_67500__$1 = state_67500;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67500__$1,inst_67498);
} else {
if((state_val_67501 === (2))){
var _ = (function (){var statearr_67508 = state_67500;
(statearr_67508[(4)] = cljs.core.cons((5),(state_67500[(4)])));

return statearr_67508;
})();
var inst_67483 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67484 = (opts == null);
var state_67500__$1 = (function (){var statearr_67509 = state_67500;
(statearr_67509[(8)] = inst_67483);

return statearr_67509;
})();
if(cljs.core.truth_(inst_67484)){
var statearr_67510_67527 = state_67500__$1;
(statearr_67510_67527[(1)] = (6));

} else {
var statearr_67511_67528 = state_67500__$1;
(statearr_67511_67528[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67501 === (9))){
var inst_67492 = (state_67500[(2)]);
var inst_67493 = fluree.db.util.async.throw_err(inst_67492);
var inst_67494 = cljs.core.clj__GT_js(inst_67493);
var inst_67495 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67494) : resolve.call(null,inst_67494));
var _ = (function (){var statearr_67512 = state_67500;
(statearr_67512[(4)] = cljs.core.rest((state_67500[(4)])));

return statearr_67512;
})();
var state_67500__$1 = state_67500;
var statearr_67513_67529 = state_67500__$1;
(statearr_67513_67529[(2)] = inst_67495);

(statearr_67513_67529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67501 === (5))){
var _ = (function (){var statearr_67514 = state_67500;
(statearr_67514[(4)] = cljs.core.rest((state_67500[(4)])));

return statearr_67514;
})();
var state_67500__$1 = state_67500;
var ex67507 = (state_67500__$1[(2)]);
var statearr_67515_67530 = state_67500__$1;
(statearr_67515_67530[(5)] = ex67507);


var statearr_67516_67531 = state_67500__$1;
(statearr_67516_67531[(1)] = (4));

(statearr_67516_67531[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67501 === (8))){
var inst_67483 = (state_67500[(8)]);
var inst_67489 = (state_67500[(2)]);
var inst_67490 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_67483,inst_67489);
var state_67500__$1 = state_67500;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67500__$1,(9),inst_67490);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2733__auto__ = null;
var flureedb$state_machine__2733__auto____0 = (function (){
var statearr_67517 = [null,null,null,null,null,null,null,null,null];
(statearr_67517[(0)] = flureedb$state_machine__2733__auto__);

(statearr_67517[(1)] = (1));

return statearr_67517;
});
var flureedb$state_machine__2733__auto____1 = (function (state_67500){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_67500);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e67518){var ex__2736__auto__ = e67518;
var statearr_67519_67532 = state_67500;
(statearr_67519_67532[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_67500[(4)]))){
var statearr_67520_67533 = state_67500;
(statearr_67520_67533[(1)] = cljs.core.first((state_67500[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67534 = state_67500;
state_67500 = G__67534;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureedb$state_machine__2733__auto__ = function(state_67500){
switch(arguments.length){
case 0:
return flureedb$state_machine__2733__auto____0.call(this);
case 1:
return flureedb$state_machine__2733__auto____1.call(this,state_67500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2733__auto____0;
flureedb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2733__auto____1;
return flureedb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_67521 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_67521[(6)] = c__2755__auto__);

return statearr_67521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
