// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.cache');
goog.require('cljs.core');
goog.require('tailrecursion.priority_map');

/**
 * This is the protocol describing the basic cache capability.
 * @interface
 */
cljs.cache.CacheProtocol = function(){};

var cljs$cache$CacheProtocol$lookup$dyn_37546 = (function() {
var G__37547 = null;
var G__37547__2 = (function (cache,e){
var x__4521__auto__ = (((cache == null))?null:cache);
var m__4522__auto__ = (cljs.cache.lookup[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,cache,e);
} else {
var m__4519__auto__ = (cljs.cache.lookup["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,cache,e);
} else {
throw cljs.core.missing_protocol.call(null,"CacheProtocol.lookup",cache);
}
}
});
var G__37547__3 = (function (cache,e,not_found){
var x__4521__auto__ = (((cache == null))?null:cache);
var m__4522__auto__ = (cljs.cache.lookup[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,cache,e,not_found);
} else {
var m__4519__auto__ = (cljs.cache.lookup["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,cache,e,not_found);
} else {
throw cljs.core.missing_protocol.call(null,"CacheProtocol.lookup",cache);
}
}
});
G__37547 = function(cache,e,not_found){
switch(arguments.length){
case 2:
return G__37547__2.call(this,cache,e);
case 3:
return G__37547__3.call(this,cache,e,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37547.cljs$core$IFn$_invoke$arity$2 = G__37547__2;
G__37547.cljs$core$IFn$_invoke$arity$3 = G__37547__3;
return G__37547;
})()
;
/**
 * Retrieve the value associated with `e` if it exists, else `nil` in
 *   the 2-arg case. Retrieve the value associated with `e` if it exists,
 *   else `not-found` in the 3-arg case.
 */
cljs.cache.lookup = (function cljs$cache$lookup(var_args){
var G__37545 = arguments.length;
switch (G__37545) {
case 2:
return cljs.cache.lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.cache.lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.cache.lookup.cljs$core$IFn$_invoke$arity$2 = (function (cache,e){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$lookup$arity$2 == null)))))){
return cache.cljs$cache$CacheProtocol$lookup$arity$2(cache,e);
} else {
return cljs$cache$CacheProtocol$lookup$dyn_37546.call(null,cache,e);
}
}));

(cljs.cache.lookup.cljs$core$IFn$_invoke$arity$3 = (function (cache,e,not_found){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$lookup$arity$3 == null)))))){
return cache.cljs$cache$CacheProtocol$lookup$arity$3(cache,e,not_found);
} else {
return cljs$cache$CacheProtocol$lookup$dyn_37546.call(null,cache,e,not_found);
}
}));

(cljs.cache.lookup.cljs$lang$maxFixedArity = 3);


var cljs$cache$CacheProtocol$has_QMARK_$dyn_37549 = (function (cache,e){
var x__4521__auto__ = (((cache == null))?null:cache);
var m__4522__auto__ = (cljs.cache.has_QMARK_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,cache,e);
} else {
var m__4519__auto__ = (cljs.cache.has_QMARK_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,cache,e);
} else {
throw cljs.core.missing_protocol.call(null,"CacheProtocol.has?",cache);
}
}
});
/**
 * Checks if the cache contains a value associated with `e`
 */
cljs.cache.has_QMARK_ = (function cljs$cache$has_QMARK_(cache,e){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$has_QMARK_$arity$2 == null)))))){
return cache.cljs$cache$CacheProtocol$has_QMARK_$arity$2(cache,e);
} else {
return cljs$cache$CacheProtocol$has_QMARK_$dyn_37549.call(null,cache,e);
}
});

var cljs$cache$CacheProtocol$hit$dyn_37550 = (function (cache,e){
var x__4521__auto__ = (((cache == null))?null:cache);
var m__4522__auto__ = (cljs.cache.hit[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,cache,e);
} else {
var m__4519__auto__ = (cljs.cache.hit["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,cache,e);
} else {
throw cljs.core.missing_protocol.call(null,"CacheProtocol.hit",cache);
}
}
});
/**
 * Is meant to be called if the cache is determined to contain a value
 *   associated with `e`
 */
cljs.cache.hit = (function cljs$cache$hit(cache,e){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$hit$arity$2 == null)))))){
return cache.cljs$cache$CacheProtocol$hit$arity$2(cache,e);
} else {
return cljs$cache$CacheProtocol$hit$dyn_37550.call(null,cache,e);
}
});

var cljs$cache$CacheProtocol$miss$dyn_37551 = (function (cache,e,ret){
var x__4521__auto__ = (((cache == null))?null:cache);
var m__4522__auto__ = (cljs.cache.miss[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,cache,e,ret);
} else {
var m__4519__auto__ = (cljs.cache.miss["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,cache,e,ret);
} else {
throw cljs.core.missing_protocol.call(null,"CacheProtocol.miss",cache);
}
}
});
/**
 * Is meant to be called if the cache is determined to **not** contain a
 *   value associated with `e`
 */
cljs.cache.miss = (function cljs$cache$miss(cache,e,ret){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$miss$arity$3 == null)))))){
return cache.cljs$cache$CacheProtocol$miss$arity$3(cache,e,ret);
} else {
return cljs$cache$CacheProtocol$miss$dyn_37551.call(null,cache,e,ret);
}
});

var cljs$cache$CacheProtocol$evict$dyn_37552 = (function (cache,e){
var x__4521__auto__ = (((cache == null))?null:cache);
var m__4522__auto__ = (cljs.cache.evict[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,cache,e);
} else {
var m__4519__auto__ = (cljs.cache.evict["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,cache,e);
} else {
throw cljs.core.missing_protocol.call(null,"CacheProtocol.evict",cache);
}
}
});
/**
 * Removes an entry from the cache
 */
cljs.cache.evict = (function cljs$cache$evict(cache,e){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$evict$arity$2 == null)))))){
return cache.cljs$cache$CacheProtocol$evict$arity$2(cache,e);
} else {
return cljs$cache$CacheProtocol$evict$dyn_37552.call(null,cache,e);
}
});

var cljs$cache$CacheProtocol$seed$dyn_37553 = (function (cache,base){
var x__4521__auto__ = (((cache == null))?null:cache);
var m__4522__auto__ = (cljs.cache.seed[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,cache,base);
} else {
var m__4519__auto__ = (cljs.cache.seed["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,cache,base);
} else {
throw cljs.core.missing_protocol.call(null,"CacheProtocol.seed",cache);
}
}
});
/**
 * Is used to signal that the cache should be created with a seed.
 *   The contract is that said cache should return an instance of its
 *   own type.
 */
cljs.cache.seed = (function cljs$cache$seed(cache,base){
if((((!((cache == null)))) && ((!((cache.cljs$cache$CacheProtocol$seed$arity$2 == null)))))){
return cache.cljs$cache$CacheProtocol$seed$arity$2(cache,base);
} else {
return cljs$cache$CacheProtocol$seed$dyn_37553.call(null,cache,base);
}
});

cljs.cache.default_wrapper_fn = (function cljs$cache$default_wrapper_fn(p1__37554_SHARP_,p2__37555_SHARP_){
return p1__37554_SHARP_.call(null,p2__37555_SHARP_);
});
/**
 * The basic hit/miss logic for the cache system. Expects a wrap function and
 *   value function.  The wrap function takes the value function and the item in
 *   question and is expected to run the value function with the item whenever a
 *   cache miss occurs.  The intent is to hide any cache-specific cells from
 *   leaking into the cache logic itelf.
 */
cljs.cache.through = (function cljs$cache$through(var_args){
var G__37558 = arguments.length;
switch (G__37558) {
case 2:
return cljs.cache.through.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.cache.through.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.cache.through.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.cache.through.cljs$core$IFn$_invoke$arity$2 = (function (cache,item){
return cljs.cache.through.call(null,cljs.cache.default_wrapper_fn,cljs.core.identity,cache,item);
}));

(cljs.cache.through.cljs$core$IFn$_invoke$arity$3 = (function (value_fn,cache,item){
return cljs.cache.through.call(null,cljs.cache.default_wrapper_fn,value_fn,cache,item);
}));

(cljs.cache.through.cljs$core$IFn$_invoke$arity$4 = (function (wrap_fn,value_fn,cache,item){
if(cljs.core.truth_(cljs.cache.has_QMARK_.call(null,cache,item))){
return cljs.cache.hit.call(null,cache,item);
} else {
return cljs.cache.miss.call(null,cache,item,wrap_fn.call(null,(function (p1__37556_SHARP_){
return value_fn.call(null,p1__37556_SHARP_);
}),item));
}
}));

(cljs.cache.through.cljs$lang$maxFixedArity = 4);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.cache.CacheProtocol}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.cache.Object}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.cache.BasicCache = (function (cache){
this.cache = cache;
this.cljs$lang$protocol_mask$partition0$ = 10487566;
this.cljs$lang$protocol_mask$partition1$ = 131072;
});
(cljs.cache.BasicCache.prototype.toString = (function (){
var self__ = this;
var _ = this;
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cache);
}));

(cljs.cache.BasicCache.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__37526__auto__,other__37533__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.core._EQ_.call(null,other__37533__auto__,self__.cache);
}));

(cljs.cache.BasicCache.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__37526__auto__,elem__37532__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.seed.call(null,this__37526__auto____$1,new cljs.core.Symbol("cljs.cache","-conj","cljs.cache/-conj",837886777,null).call(null,self__.cache,elem__37532__auto__));
}));

(cljs.cache.BasicCache.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this__37526__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.seed.call(null,this__37526__auto____$1,new cljs.core.Symbol("cljs.cache","-empty","cljs.cache/-empty",-190310872,null).call(null,self__.cache));
}));

(cljs.cache.BasicCache.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__37526__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.core._count.call(null,self__.cache);
}));

(cljs.cache.BasicCache.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (___37529__auto__){
var self__ = this;
var ___37529__auto____$1 = this;
return cljs.core._seq.call(null,self__.cache);
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$lookup$arity$2 = (function (_,item){
var self__ = this;
var ___$1 = this;
return cljs.core.get.call(null,self__.cache,item);
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$lookup$arity$3 = (function (_,item,not_found){
var self__ = this;
var ___$1 = this;
return cljs.core.get.call(null,self__.cache,item,not_found);
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$has_QMARK_$arity$2 = (function (_,item){
var self__ = this;
var ___$1 = this;
return cljs.core.contains_QMARK_.call(null,self__.cache,item);
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$hit$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$miss$arity$3 = (function (_,item,result){
var self__ = this;
var ___$1 = this;
return (new cljs.cache.BasicCache(cljs.core.assoc.call(null,self__.cache,item,result)));
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$evict$arity$2 = (function (_,key){
var self__ = this;
var ___$1 = this;
return (new cljs.cache.BasicCache(cljs.core.dissoc.call(null,self__.cache,key)));
}));

(cljs.cache.BasicCache.prototype.cljs$cache$CacheProtocol$seed$arity$2 = (function (_,base){
var self__ = this;
var ___$1 = this;
return (new cljs.cache.BasicCache(base));
}));

(cljs.cache.BasicCache.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (___37529__auto__){
var self__ = this;
var ___37529__auto____$1 = this;
return self__.cache.iterator();
}));

(cljs.cache.BasicCache.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__37526__auto__,k__37530__auto__,v__37531__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.miss.call(null,this__37526__auto____$1,k__37530__auto__,v__37531__auto__);
}));

(cljs.cache.BasicCache.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__37526__auto__,k__37530__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.has_QMARK_.call(null,this__37526__auto____$1,k__37530__auto__);
}));

(cljs.cache.BasicCache.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__37526__auto__,k__37530__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.evict.call(null,this__37526__auto____$1,k__37530__auto__);
}));

(cljs.cache.BasicCache.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__37526__auto__,key__37527__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.core._lookup.call(null,this__37526__auto____$1,key__37527__auto__,null);
}));

(cljs.cache.BasicCache.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__37526__auto__,key__37527__auto__,not_found__37528__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
if(cljs.core.truth_(cljs.cache.has_QMARK_.call(null,this__37526__auto____$1,key__37527__auto__))){
return cljs.cache.lookup.call(null,this__37526__auto____$1,key__37527__auto__);
} else {
return not_found__37528__auto__;
}
}));

(cljs.cache.BasicCache.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null)], null);
}));

(cljs.cache.BasicCache.cljs$lang$type = true);

(cljs.cache.BasicCache.cljs$lang$ctorStr = "cljs.cache/BasicCache");

(cljs.cache.BasicCache.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.cache/BasicCache");
}));

/**
 * Positional factory function for cljs.cache/BasicCache.
 */
cljs.cache.__GT_BasicCache = (function cljs$cache$__GT_BasicCache(cache){
return (new cljs.cache.BasicCache(cache));
});

cljs.cache.get_time = (function cljs$cache$get_time(){
return (new Date()).getTime();
});
/**
 * returns a fn that dissocs expired keys from a map
 */
cljs.cache.key_killer_fn = (function cljs$cache$key_killer_fn(ttl,expiry,now){
var ks = cljs.core.map.call(null,cljs.core.key,cljs.core.filter.call(null,(function (p1__37560_SHARP_){
return ((now - cljs.core.val.call(null,p1__37560_SHARP_)) > expiry);
}),ttl));
return (function (p1__37561_SHARP_){
return cljs.core.apply.call(null,cljs.core.dissoc,p1__37561_SHARP_,ks);
});
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.cache.CacheProtocol}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.cache.Object}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.cache.TTLCache = (function (cache,ttl,ttl_ms){
this.cache = cache;
this.ttl = ttl;
this.ttl_ms = ttl_ms;
this.cljs$lang$protocol_mask$partition0$ = 10487566;
this.cljs$lang$protocol_mask$partition1$ = 131072;
});
(cljs.cache.TTLCache.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cache),","," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.ttl),","," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.ttl_ms)].join('');
}));

(cljs.cache.TTLCache.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__37526__auto__,other__37533__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.core._EQ_.call(null,other__37533__auto__,self__.cache);
}));

(cljs.cache.TTLCache.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__37526__auto__,elem__37532__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.seed.call(null,this__37526__auto____$1,new cljs.core.Symbol("cljs.cache","-conj","cljs.cache/-conj",837886777,null).call(null,self__.cache,elem__37532__auto__));
}));

(cljs.cache.TTLCache.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this__37526__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.seed.call(null,this__37526__auto____$1,new cljs.core.Symbol("cljs.cache","-empty","cljs.cache/-empty",-190310872,null).call(null,self__.cache));
}));

(cljs.cache.TTLCache.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__37526__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.core._count.call(null,self__.cache);
}));

(cljs.cache.TTLCache.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (___37529__auto__){
var self__ = this;
var ___37529__auto____$1 = this;
return cljs.core._seq.call(null,self__.cache);
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var ret = cljs.cache.lookup.call(null,this$__$1,item,new cljs.core.Keyword("cljs.cache","nope","cljs.cache/nope",968062453));
if(cljs.core._EQ_.call(null,ret,new cljs.core.Keyword("cljs.cache","nope","cljs.cache/nope",968062453))){
return null;
} else {
return ret;
}
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$lookup$arity$3 = (function (this$,item,not_found){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(cljs.cache.has_QMARK_.call(null,this$__$1,item))){
return cljs.core.get.call(null,self__.cache,item);
} else {
return not_found;
}
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$has_QMARK_$arity$2 = (function (_,item){
var self__ = this;
var ___$1 = this;
var t = cljs.core.get.call(null,self__.ttl,item,(- self__.ttl_ms));
return ((cljs.cache.get_time.call(null) - t) < self__.ttl_ms);
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$hit$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$miss$arity$3 = (function (this$,item,result){
var self__ = this;
var this$__$1 = this;
var now = cljs.cache.get_time.call(null);
var kill_old = cljs.cache.key_killer_fn.call(null,self__.ttl,self__.ttl_ms,now);
return (new cljs.cache.TTLCache(cljs.core.assoc.call(null,kill_old.call(null,self__.cache),item,result),cljs.core.assoc.call(null,kill_old.call(null,self__.ttl),item,now),self__.ttl_ms));
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$seed$arity$2 = (function (_,base){
var self__ = this;
var ___$1 = this;
var now = cljs.cache.get_time.call(null);
return (new cljs.cache.TTLCache(base,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4622__auto__ = (function cljs$cache$iter__37562(s__37563){
return (new cljs.core.LazySeq(null,(function (){
var s__37563__$1 = s__37563;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__37563__$1);
if(temp__5753__auto__){
var s__37563__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37563__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__37563__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__37565 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__37564 = (0);
while(true){
if((i__37564 < size__4621__auto__)){
var x = cljs.core._nth.call(null,c__4620__auto__,i__37564);
cljs.core.chunk_append.call(null,b__37565,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.key.call(null,x),now], null));

var G__37566 = (i__37564 + (1));
i__37564 = G__37566;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37565),cljs$cache$iter__37562.call(null,cljs.core.chunk_rest.call(null,s__37563__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37565),null);
}
} else {
var x = cljs.core.first.call(null,s__37563__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.key.call(null,x),now], null),cljs$cache$iter__37562.call(null,cljs.core.rest.call(null,s__37563__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,base);
})()),self__.ttl_ms));
}));

(cljs.cache.TTLCache.prototype.cljs$cache$CacheProtocol$evict$arity$2 = (function (_,key){
var self__ = this;
var ___$1 = this;
return (new cljs.cache.TTLCache(cljs.core.dissoc.call(null,self__.cache,key),cljs.core.dissoc.call(null,self__.ttl,key),self__.ttl_ms));
}));

(cljs.cache.TTLCache.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (___37529__auto__){
var self__ = this;
var ___37529__auto____$1 = this;
return self__.cache.iterator();
}));

(cljs.cache.TTLCache.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__37526__auto__,k__37530__auto__,v__37531__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.miss.call(null,this__37526__auto____$1,k__37530__auto__,v__37531__auto__);
}));

(cljs.cache.TTLCache.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__37526__auto__,k__37530__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.has_QMARK_.call(null,this__37526__auto____$1,k__37530__auto__);
}));

(cljs.cache.TTLCache.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__37526__auto__,k__37530__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.evict.call(null,this__37526__auto____$1,k__37530__auto__);
}));

(cljs.cache.TTLCache.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__37526__auto__,key__37527__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.core._lookup.call(null,this__37526__auto____$1,key__37527__auto__,null);
}));

(cljs.cache.TTLCache.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__37526__auto__,key__37527__auto__,not_found__37528__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
if(cljs.core.truth_(cljs.cache.has_QMARK_.call(null,this__37526__auto____$1,key__37527__auto__))){
return cljs.cache.lookup.call(null,this__37526__auto____$1,key__37527__auto__);
} else {
return not_found__37528__auto__;
}
}));

(cljs.cache.TTLCache.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"ttl","ttl",525256409,null),new cljs.core.Symbol(null,"ttl-ms","ttl-ms",-1349172894,null)], null);
}));

(cljs.cache.TTLCache.cljs$lang$type = true);

(cljs.cache.TTLCache.cljs$lang$ctorStr = "cljs.cache/TTLCache");

(cljs.cache.TTLCache.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.cache/TTLCache");
}));

/**
 * Positional factory function for cljs.cache/TTLCache.
 */
cljs.cache.__GT_TTLCache = (function cljs$cache$__GT_TTLCache(cache,ttl,ttl_ms){
return (new cljs.cache.TTLCache(cache,ttl,ttl_ms));
});

cljs.cache.build_leastness_queue = (function cljs$cache$build_leastness_queue(base,limit,start_at){
return cljs.core.into.call(null,tailrecursion.priority_map.priority_map.call(null),cljs.core.concat.call(null,cljs.core.take.call(null,(limit - cljs.core.count.call(null,base)),(function (){var iter__4622__auto__ = (function cljs$cache$build_leastness_queue_$_iter__37567(s__37568){
return (new cljs.core.LazySeq(null,(function (){
var s__37568__$1 = s__37568;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__37568__$1);
if(temp__5753__auto__){
var s__37568__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37568__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__37568__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__37570 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__37569 = (0);
while(true){
if((i__37569 < size__4621__auto__)){
var k = cljs.core._nth.call(null,c__4620__auto__,i__37569);
cljs.core.chunk_append.call(null,b__37570,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,k], null));

var G__37581 = (i__37569 + (1));
i__37569 = G__37581;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37570),cljs$cache$build_leastness_queue_$_iter__37567.call(null,cljs.core.chunk_rest.call(null,s__37568__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37570),null);
}
} else {
var k = cljs.core.first.call(null,s__37568__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,k], null),cljs$cache$build_leastness_queue_$_iter__37567.call(null,cljs.core.rest.call(null,s__37568__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,cljs.core.range.call(null,(- limit),(0)));
})()),(function (){var iter__4622__auto__ = (function cljs$cache$build_leastness_queue_$_iter__37571(s__37572){
return (new cljs.core.LazySeq(null,(function (){
var s__37572__$1 = s__37572;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__37572__$1);
if(temp__5753__auto__){
var s__37572__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37572__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__37572__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__37574 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__37573 = (0);
while(true){
if((i__37573 < size__4621__auto__)){
var vec__37575 = cljs.core._nth.call(null,c__4620__auto__,i__37573);
var k = cljs.core.nth.call(null,vec__37575,(0),null);
var _ = cljs.core.nth.call(null,vec__37575,(1),null);
cljs.core.chunk_append.call(null,b__37574,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,start_at], null));

var G__37582 = (i__37573 + (1));
i__37573 = G__37582;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37574),cljs$cache$build_leastness_queue_$_iter__37571.call(null,cljs.core.chunk_rest.call(null,s__37572__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37574),null);
}
} else {
var vec__37578 = cljs.core.first.call(null,s__37572__$2);
var k = cljs.core.nth.call(null,vec__37578,(0),null);
var _ = cljs.core.nth.call(null,vec__37578,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,start_at], null),cljs$cache$build_leastness_queue_$_iter__37571.call(null,cljs.core.rest.call(null,s__37572__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,base);
})()));
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.cache.CacheProtocol}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.cache.Object}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.cache.LRUCache = (function (cache,lru,tick,limit){
this.cache = cache;
this.lru = lru;
this.tick = tick;
this.limit = limit;
this.cljs$lang$protocol_mask$partition0$ = 10487566;
this.cljs$lang$protocol_mask$partition1$ = 131072;
});
(cljs.cache.LRUCache.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cache),","," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.lru),","," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.tick),","," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.limit)].join('');
}));

(cljs.cache.LRUCache.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__37526__auto__,other__37533__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.core._EQ_.call(null,other__37533__auto__,self__.cache);
}));

(cljs.cache.LRUCache.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__37526__auto__,elem__37532__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.seed.call(null,this__37526__auto____$1,new cljs.core.Symbol("cljs.cache","-conj","cljs.cache/-conj",837886777,null).call(null,self__.cache,elem__37532__auto__));
}));

(cljs.cache.LRUCache.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this__37526__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.seed.call(null,this__37526__auto____$1,new cljs.core.Symbol("cljs.cache","-empty","cljs.cache/-empty",-190310872,null).call(null,self__.cache));
}));

(cljs.cache.LRUCache.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__37526__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.core._count.call(null,self__.cache);
}));

(cljs.cache.LRUCache.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (___37529__auto__){
var self__ = this;
var ___37529__auto____$1 = this;
return cljs.core._seq.call(null,self__.cache);
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$lookup$arity$2 = (function (_,item){
var self__ = this;
var ___$1 = this;
return cljs.core.get.call(null,self__.cache,item);
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$lookup$arity$3 = (function (_,item,not_found){
var self__ = this;
var ___$1 = this;
return cljs.core.get.call(null,self__.cache,item,not_found);
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$has_QMARK_$arity$2 = (function (_,item){
var self__ = this;
var ___$1 = this;
return cljs.core.contains_QMARK_.call(null,self__.cache,item);
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$hit$arity$2 = (function (_,item){
var self__ = this;
var ___$1 = this;
var tick_PLUS_ = (self__.tick + (1));
return (new cljs.cache.LRUCache(self__.cache,((cljs.core.contains_QMARK_.call(null,self__.cache,item))?cljs.core.assoc.call(null,self__.lru,item,tick_PLUS_):self__.lru),tick_PLUS_,self__.limit));
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$miss$arity$3 = (function (_,item,result){
var self__ = this;
var ___$1 = this;
var tick_PLUS_ = (self__.tick + (1));
if((cljs.core.count.call(null,self__.lru) >= self__.limit)){
var k = ((cljs.core.contains_QMARK_.call(null,self__.lru,item))?item:cljs.core.first.call(null,cljs.core.peek.call(null,self__.lru)));
var c = cljs.core.assoc.call(null,cljs.core.dissoc.call(null,self__.cache,k),item,result);
var l = cljs.core.assoc.call(null,cljs.core.dissoc.call(null,self__.lru,k),item,tick_PLUS_);
return (new cljs.cache.LRUCache(c,l,tick_PLUS_,self__.limit));
} else {
return (new cljs.cache.LRUCache(cljs.core.assoc.call(null,self__.cache,item,result),cljs.core.assoc.call(null,self__.lru,item,tick_PLUS_),tick_PLUS_,self__.limit));
}
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$evict$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,self__.cache,key)){
return (new cljs.cache.LRUCache(cljs.core.dissoc.call(null,self__.cache,key),cljs.core.dissoc.call(null,self__.lru,key),(self__.tick + (1)),self__.limit));
} else {
return this$__$1;
}
}));

(cljs.cache.LRUCache.prototype.cljs$cache$CacheProtocol$seed$arity$2 = (function (_,base){
var self__ = this;
var ___$1 = this;
return (new cljs.cache.LRUCache(base,cljs.cache.build_leastness_queue.call(null,base,self__.limit,(0)),(0),self__.limit));
}));

(cljs.cache.LRUCache.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (___37529__auto__){
var self__ = this;
var ___37529__auto____$1 = this;
return self__.cache.iterator();
}));

(cljs.cache.LRUCache.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__37526__auto__,k__37530__auto__,v__37531__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.miss.call(null,this__37526__auto____$1,k__37530__auto__,v__37531__auto__);
}));

(cljs.cache.LRUCache.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__37526__auto__,k__37530__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.has_QMARK_.call(null,this__37526__auto____$1,k__37530__auto__);
}));

(cljs.cache.LRUCache.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__37526__auto__,k__37530__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.cache.evict.call(null,this__37526__auto____$1,k__37530__auto__);
}));

(cljs.cache.LRUCache.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__37526__auto__,key__37527__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
return cljs.core._lookup.call(null,this__37526__auto____$1,key__37527__auto__,null);
}));

(cljs.cache.LRUCache.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__37526__auto__,key__37527__auto__,not_found__37528__auto__){
var self__ = this;
var this__37526__auto____$1 = this;
if(cljs.core.truth_(cljs.cache.has_QMARK_.call(null,this__37526__auto____$1,key__37527__auto__))){
return cljs.cache.lookup.call(null,this__37526__auto____$1,key__37527__auto__);
} else {
return not_found__37528__auto__;
}
}));

(cljs.cache.LRUCache.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"lru","lru",-315566379,null),new cljs.core.Symbol(null,"tick","tick",804644551,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null);
}));

(cljs.cache.LRUCache.cljs$lang$type = true);

(cljs.cache.LRUCache.cljs$lang$ctorStr = "cljs.cache/LRUCache");

(cljs.cache.LRUCache.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.cache/LRUCache");
}));

/**
 * Positional factory function for cljs.cache/LRUCache.
 */
cljs.cache.__GT_LRUCache = (function cljs$cache$__GT_LRUCache(cache,lru,tick,limit){
return (new cljs.cache.LRUCache(cache,lru,tick,limit));
});

/**
 * Returns a pluggable basic cache initialied to `base`
 */
cljs.cache.basic_cache_factory = (function cljs$cache$basic_cache_factory(base){
if(cljs.core.map_QMARK_.call(null,base)){
} else {
throw (new Error("Assert failed: (map? base)"));
}

return (new cljs.cache.BasicCache(base));
});
/**
 * Returns a TTL cache with the cache and expiration-table initialied to `base` --
 * each with the same time-to-live.
 * 
 * This function also allows an optional `:ttl` argument that defines the default
 * time in milliseconds that entries are allowed to reside in the cache.
 */
cljs.cache.ttl_cache_factory = (function cljs$cache$ttl_cache_factory(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37587 = arguments.length;
var i__4830__auto___37588 = (0);
while(true){
if((i__4830__auto___37588 < len__4829__auto___37587)){
args__4835__auto__.push((arguments[i__4830__auto___37588]));

var G__37589 = (i__4830__auto___37588 + (1));
i__4830__auto___37588 = G__37589;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic = (function (base,p__37585){
var map__37586 = p__37585;
var map__37586__$1 = cljs.core.__destructure_map.call(null,map__37586);
var ttl = cljs.core.get.call(null,map__37586__$1,new cljs.core.Keyword(null,"ttl","ttl",-1115275118),(2000));
if(typeof ttl === 'number'){
} else {
throw (new Error("Assert failed: (number? ttl)"));
}

if(((0) <= ttl)){
} else {
throw (new Error("Assert failed: (<= 0 ttl)"));
}

if(cljs.core.map_QMARK_.call(null,base)){
} else {
throw (new Error("Assert failed: (map? base)"));
}

return cljs.cache.seed.call(null,(new cljs.cache.TTLCache(cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,ttl)),base);
}));

(cljs.cache.ttl_cache_factory.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.cache.ttl_cache_factory.cljs$lang$applyTo = (function (seq37583){
var G__37584 = cljs.core.first.call(null,seq37583);
var seq37583__$1 = cljs.core.next.call(null,seq37583);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37584,seq37583__$1);
}));

/**
 * Returns an LRU cache with the cache and usage-table initialied to `base` --
 * each entry is initialized with the same usage value.
 * This function takes an optional `:threshold` argument that defines the maximum number
 * of elements in the cache before the LRU semantics apply (default is 32).
 */
cljs.cache.lru_cache_factory = (function cljs$cache$lru_cache_factory(var_args){
var args__4835__auto__ = [];
var len__4829__auto___37594 = arguments.length;
var i__4830__auto___37595 = (0);
while(true){
if((i__4830__auto___37595 < len__4829__auto___37594)){
args__4835__auto__.push((arguments[i__4830__auto___37595]));

var G__37596 = (i__4830__auto___37595 + (1));
i__4830__auto___37595 = G__37596;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic = (function (base,p__37592){
var map__37593 = p__37592;
var map__37593__$1 = cljs.core.__destructure_map.call(null,map__37593);
var threshold = cljs.core.get.call(null,map__37593__$1,new cljs.core.Keyword(null,"threshold","threshold",204221583),(32));
if(typeof threshold === 'number'){
} else {
throw (new Error("Assert failed: (number? threshold)"));
}

if(((0) < threshold)){
} else {
throw (new Error("Assert failed: (< 0 threshold)"));
}

if(cljs.core.map_QMARK_.call(null,base)){
} else {
throw (new Error("Assert failed: (map? base)"));
}

return cljs.cache.seed.call(null,(new cljs.cache.LRUCache(cljs.core.PersistentArrayMap.EMPTY,tailrecursion.priority_map.priority_map.call(null),(0),threshold)),base);
}));

(cljs.cache.lru_cache_factory.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.cache.lru_cache_factory.cljs$lang$applyTo = (function (seq37590){
var G__37591 = cljs.core.first.call(null,seq37590);
var seq37590__$1 = cljs.core.next.call(null,seq37590);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37591,seq37590__$1);
}));

