// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__6448 = s;
var map__6448__$1 = cljs.core.__destructure_map.call(null,map__6448);
var name = cljs.core.get.call(null,map__6448__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__6448__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__6450 = info;
var map__6451 = G__6450;
var map__6451__$1 = cljs.core.__destructure_map.call(null,map__6451);
var shadow = cljs.core.get.call(null,map__6451__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__6450__$1 = G__6450;
while(true){
var d__$2 = d__$1;
var map__6453 = G__6450__$1;
var map__6453__$1 = cljs.core.__destructure_map.call(null,map__6453);
var shadow__$1 = cljs.core.get.call(null,map__6453__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__6454 = (d__$2 + (1));
var G__6455 = shadow__$1;
d__$1 = G__6454;
G__6450__$1 = G__6455;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__6456){
var map__6457 = p__6456;
var map__6457__$1 = cljs.core.__destructure_map.call(null,map__6457);
var name_var = map__6457__$1;
var name = cljs.core.get.call(null,map__6457__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__6457__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__6458 = info;
var map__6458__$1 = cljs.core.__destructure_map.call(null,map__6458);
var ns = cljs.core.get.call(null,map__6458__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__6458__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.call(null,reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__6460 = arguments.length;
switch (G__6460) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11639,11639,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)])).call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__6462 = cp;
switch (G__6462) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__6464_6468 = cljs.core.seq.call(null,s);
var chunk__6465_6469 = null;
var count__6466_6470 = (0);
var i__6467_6471 = (0);
while(true){
if((i__6467_6471 < count__6466_6470)){
var c_6472 = cljs.core._nth.call(null,chunk__6465_6469,i__6467_6471);
sb.append(cljs.compiler.escape_char.call(null,c_6472));


var G__6473 = seq__6464_6468;
var G__6474 = chunk__6465_6469;
var G__6475 = count__6466_6470;
var G__6476 = (i__6467_6471 + (1));
seq__6464_6468 = G__6473;
chunk__6465_6469 = G__6474;
count__6466_6470 = G__6475;
i__6467_6471 = G__6476;
continue;
} else {
var temp__5753__auto___6477 = cljs.core.seq.call(null,seq__6464_6468);
if(temp__5753__auto___6477){
var seq__6464_6478__$1 = temp__5753__auto___6477;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6464_6478__$1)){
var c__4649__auto___6479 = cljs.core.chunk_first.call(null,seq__6464_6478__$1);
var G__6480 = cljs.core.chunk_rest.call(null,seq__6464_6478__$1);
var G__6481 = c__4649__auto___6479;
var G__6482 = cljs.core.count.call(null,c__4649__auto___6479);
var G__6483 = (0);
seq__6464_6468 = G__6480;
chunk__6465_6469 = G__6481;
count__6466_6470 = G__6482;
i__6467_6471 = G__6483;
continue;
} else {
var c_6484 = cljs.core.first.call(null,seq__6464_6478__$1);
sb.append(cljs.compiler.escape_char.call(null,c_6484));


var G__6485 = cljs.core.next.call(null,seq__6464_6478__$1);
var G__6486 = null;
var G__6487 = (0);
var G__6488 = (0);
seq__6464_6468 = G__6485;
chunk__6465_6469 = G__6486;
count__6466_6470 = G__6487;
i__6467_6471 = G__6488;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4712__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__6489_6492 = ast;
var map__6489_6493__$1 = cljs.core.__destructure_map.call(null,map__6489_6492);
var env_6494 = cljs.core.get.call(null,map__6489_6493__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_6494))){
var map__6490_6495 = env_6494;
var map__6490_6496__$1 = cljs.core.__destructure_map.call(null,map__6490_6495);
var line_6497 = cljs.core.get.call(null,map__6490_6496__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_6498 = cljs.core.get.call(null,map__6490_6496__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__6491 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast)))){
return cljs.core.assoc.call(null,G__6491,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__6491;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_6497 - (1))], null),cljs.core.fnil.call(null,(function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_6498)?(column_6498 - (1)):(0))], null),cljs.core.fnil.call(null,(function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__6507 = arguments.length;
switch (G__6507) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4850__auto__ = [];
var len__4829__auto___6514 = arguments.length;
var i__4830__auto___6515 = (0);
while(true){
if((i__4830__auto___6515 < len__4829__auto___6514)){
args_arr__4850__auto__.push((arguments[i__4830__auto___6515]));

var G__6516 = (i__4830__auto___6515 + (1));
i__4830__auto___6515 = G__6516;
continue;
} else {
}
break;
}

var argseq__4851__auto__ = (new cljs.core.IndexedSeq(args_arr__4850__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4851__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,a)){
cljs.compiler.emit.call(null,a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_.call(null,a)){
cljs.core.apply.call(null,cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
a.call(null);
} else {
var s_6517 = (function (){var G__6508 = a;
if((!(typeof a === 'string'))){
return G__6508.toString();
} else {
return G__6508;
}
})();
var temp__5757__auto___6518 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___6518 == null)){
} else {
var sm_data_6519 = temp__5757__auto___6518;
cljs.core.swap_BANG_.call(null,sm_data_6519,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__6499_SHARP_){
return (p1__6499_SHARP_ + s_6517.length);
}));
}

cljs.core.print.call(null,s_6517);

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

return cljs.compiler.emits.call(null,b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler.emits.call(null,c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler.emits.call(null,d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler.emits.call(null,e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__6509 = cljs.core.seq.call(null,xs);
var chunk__6510 = null;
var count__6511 = (0);
var i__6512 = (0);
while(true){
if((i__6512 < count__6511)){
var x = cljs.core._nth.call(null,chunk__6510,i__6512);
cljs.compiler.emits.call(null,x);


var G__6520 = seq__6509;
var G__6521 = chunk__6510;
var G__6522 = count__6511;
var G__6523 = (i__6512 + (1));
seq__6509 = G__6520;
chunk__6510 = G__6521;
count__6511 = G__6522;
i__6512 = G__6523;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__6509);
if(temp__5753__auto__){
var seq__6509__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6509__$1)){
var c__4649__auto__ = cljs.core.chunk_first.call(null,seq__6509__$1);
var G__6524 = cljs.core.chunk_rest.call(null,seq__6509__$1);
var G__6525 = c__4649__auto__;
var G__6526 = cljs.core.count.call(null,c__4649__auto__);
var G__6527 = (0);
seq__6509 = G__6524;
chunk__6510 = G__6525;
count__6511 = G__6526;
i__6512 = G__6527;
continue;
} else {
var x = cljs.core.first.call(null,seq__6509__$1);
cljs.compiler.emits.call(null,x);


var G__6528 = cljs.core.next.call(null,seq__6509__$1);
var G__6529 = null;
var G__6530 = (0);
var G__6531 = (0);
seq__6509 = G__6528;
chunk__6510 = G__6529;
count__6511 = G__6530;
i__6512 = G__6531;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq6501){
var G__6502 = cljs.core.first.call(null,seq6501);
var seq6501__$1 = cljs.core.next.call(null,seq6501);
var G__6503 = cljs.core.first.call(null,seq6501__$1);
var seq6501__$2 = cljs.core.next.call(null,seq6501__$1);
var G__6504 = cljs.core.first.call(null,seq6501__$2);
var seq6501__$3 = cljs.core.next.call(null,seq6501__$2);
var G__6505 = cljs.core.first.call(null,seq6501__$3);
var seq6501__$4 = cljs.core.next.call(null,seq6501__$3);
var G__6506 = cljs.core.first.call(null,seq6501__$4);
var seq6501__$5 = cljs.core.next.call(null,seq6501__$4);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6502,G__6503,G__6504,G__6505,G__6506,seq6501__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.call(null);

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__6532){
var map__6533 = p__6532;
var map__6533__$1 = cljs.core.__destructure_map.call(null,map__6533);
var m = map__6533__$1;
var gen_line = cljs.core.get.call(null,map__6533__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__6541 = arguments.length;
switch (G__6541) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4850__auto__ = [];
var len__4829__auto___6547 = arguments.length;
var i__4830__auto___6548 = (0);
while(true){
if((i__4830__auto___6548 < len__4829__auto___6547)){
args_arr__4850__auto__.push((arguments[i__4830__auto___6548]));

var G__6549 = (i__4830__auto___6548 + (1));
i__4830__auto___6548 = G__6549;
continue;
} else {
}
break;
}

var argseq__4851__auto__ = (new cljs.core.IndexedSeq(args_arr__4850__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4851__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.call(null,a);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__6542_6550 = cljs.core.seq.call(null,xs);
var chunk__6543_6551 = null;
var count__6544_6552 = (0);
var i__6545_6553 = (0);
while(true){
if((i__6545_6553 < count__6544_6552)){
var x_6554 = cljs.core._nth.call(null,chunk__6543_6551,i__6545_6553);
cljs.compiler.emits.call(null,x_6554);


var G__6555 = seq__6542_6550;
var G__6556 = chunk__6543_6551;
var G__6557 = count__6544_6552;
var G__6558 = (i__6545_6553 + (1));
seq__6542_6550 = G__6555;
chunk__6543_6551 = G__6556;
count__6544_6552 = G__6557;
i__6545_6553 = G__6558;
continue;
} else {
var temp__5753__auto___6559 = cljs.core.seq.call(null,seq__6542_6550);
if(temp__5753__auto___6559){
var seq__6542_6560__$1 = temp__5753__auto___6559;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6542_6560__$1)){
var c__4649__auto___6561 = cljs.core.chunk_first.call(null,seq__6542_6560__$1);
var G__6562 = cljs.core.chunk_rest.call(null,seq__6542_6560__$1);
var G__6563 = c__4649__auto___6561;
var G__6564 = cljs.core.count.call(null,c__4649__auto___6561);
var G__6565 = (0);
seq__6542_6550 = G__6562;
chunk__6543_6551 = G__6563;
count__6544_6552 = G__6564;
i__6545_6553 = G__6565;
continue;
} else {
var x_6566 = cljs.core.first.call(null,seq__6542_6560__$1);
cljs.compiler.emits.call(null,x_6566);


var G__6567 = cljs.core.next.call(null,seq__6542_6560__$1);
var G__6568 = null;
var G__6569 = (0);
var G__6570 = (0);
seq__6542_6550 = G__6567;
chunk__6543_6551 = G__6568;
count__6544_6552 = G__6569;
i__6545_6553 = G__6570;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln.call(null);
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq6535){
var G__6536 = cljs.core.first.call(null,seq6535);
var seq6535__$1 = cljs.core.next.call(null,seq6535);
var G__6537 = cljs.core.first.call(null,seq6535__$1);
var seq6535__$2 = cljs.core.next.call(null,seq6535__$1);
var G__6538 = cljs.core.first.call(null,seq6535__$2);
var seq6535__$3 = cljs.core.next.call(null,seq6535__$2);
var G__6539 = cljs.core.first.call(null,seq6535__$3);
var seq6535__$4 = cljs.core.next.call(null,seq6535__$3);
var G__6540 = cljs.core.first.call(null,seq6535__$4);
var seq6535__$5 = cljs.core.next.call(null,seq6535__$4);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6536,G__6537,G__6538,G__6539,G__6540,seq6535__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4760__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__6571_6575 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__6572_6576 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__6573_6577 = true;
var _STAR_print_fn_STAR__temp_val__6574_6578 = (function (x__4761__auto__){
return sb__4760__auto__.append(x__4761__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__6573_6577);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__6574_6578);

try{cljs.compiler.emit.call(null,expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__6572_6576);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__6571_6575);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4760__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4712__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.call(null,cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_.call(null,x)){
return cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.core.record_QMARK_.call(null,x)){
var vec__6579 = cljs.analyzer.record_ns_PLUS_name.call(null,x);
var ns = cljs.core.nth.call(null,vec__6579,(0),null);
var name = cljs.core.nth.call(null,vec__6579,(1),null);
return cljs.compiler.emit_record_value.call(null,ns,name,(function (){
return cljs.compiler.emit_constant.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,x));
}));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,x)){
return cljs.compiler.emit_map.call(null,cljs.core.keys.call(null,x),cljs.core.vals.call(null,x),cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_.call(null,x)){
return cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_.call(null,x)){
return cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
return cljs.compiler.emit_constant_STAR_.call(null,x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta.call(null,cljs.core.meta.call(null,v));
if((!((cljs.core.seq.call(null,m) == null)))){
return cljs.compiler.emit_with_meta.call(null,(function (){
return cljs.compiler.emit_constant_no_meta.call(null,v);
}),(function (){
return cljs.compiler.emit_constant_no_meta.call(null,m);
}));
} else {
return cljs.compiler.emit_constant_no_meta.call(null,v);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.call(null,cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.call(null,"NaN");
} else {
if(cljs.core.not.call(null,isFinite(x))){
return cljs.compiler.emits.call(null,(((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.call(null,"(",x,")");

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__6582 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.call(null,vec__6582,(0),null);
var flags = cljs.core.nth.call(null,vec__6582,(1),null);
var pattern = cljs.core.nth.call(null,vec__6582,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4221__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4221__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4221__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4221__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.call(null,cljs.core.map_indexed.call(null,(function (i,m){
if(cljs.core.even_QMARK_.call(null,i)){
return cljs.compiler.emit_constant.call(null,m);
} else {
return cljs.compiler.emits.call(null,m);
}
}),cljs.compiler.comma_sep.call(null,cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.call(null,"new Date(",inst_ms,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Date,(function (date){
return cljs.compiler.emit_inst.call(null,date.getTime());
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_.call(null,items)){
return cljs.compiler.emit_js_object.call(null,items,(function (p1__6585_SHARP_){
return (function (){
return cljs.compiler.emit_constant.call(null,p1__6585_SHARP_);
});
}));
} else {
return cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__6587){
var map__6588 = p__6587;
var map__6588__$1 = cljs.core.__destructure_map.call(null,map__6588);
var ast = map__6588__$1;
var info = cljs.core.get.call(null,map__6588__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__6588__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__6588__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5751__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__6589 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__6589__$1 = cljs.core.__destructure_map.call(null,map__6589);
var cenv = map__6589__$1;
var options = cljs.core.get.call(null,map__6589__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4223__auto__ = js_module_name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__6590 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__4221__auto__)){
return (!((cljs.core.namespace.call(null,var_name) == null)));
} else {
return and__4221__auto__;
}
})())){
return clojure.set.difference.call(null,G__6590,cljs.analyzer.es5_allowed);
} else {
return G__6590;
}
})();
var js_module = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4223__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})()], null));
var info__$2 = (function (){var G__6591 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__6591,reserved);
} else {
return G__6591;
}
})();
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var G__6592_6593 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__6592_6594__$1 = (((G__6592_6593 instanceof cljs.core.Keyword))?G__6592_6593.fqn:null);
switch (G__6592_6594__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace.call(null,var_name))){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"].",cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved));
} else {
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.call(null,"default",cljs.core.name.call(null,var_name));
} else {
return and__4221__auto__;
}
})())){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.call(null,info__$2);
}

break;
default:
cljs.compiler.emits.call(null,info__$2);

}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__6596){
var map__6597 = p__6596;
var map__6597__$1 = cljs.core.__destructure_map.call(null,map__6597);
var arg = map__6597__$1;
var env = cljs.core.get.call(null,map__6597__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__6597__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__6597__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__6597__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__6598 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__6598__$1 = cljs.core.__destructure_map.call(null,map__6598);
var name = cljs.core.get.call(null,map__6598__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__6599){
var map__6600 = p__6599;
var map__6600__$1 = cljs.core.__destructure_map.call(null,map__6600);
var expr = cljs.core.get.call(null,map__6600__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__6600__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__6600__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_with_meta.call(null,expr,meta);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_.call(null,(function (p1__6601_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6601_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count.call(null,keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count.call(null,keys) === (0))){
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(distinct_keys_QMARK_.call(null,keys))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",comma_sep.call(null,keys),"],[",comma_sep.call(null,vals),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__6602){
var map__6603 = p__6602;
var map__6603__$1 = cljs.core.__destructure_map.call(null,map__6603);
var env = cljs.core.get.call(null,map__6603__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__6603__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__6603__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_map.call(null,keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.call(null,"cljs.core.list(",comma_sep.call(null,items),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count.call(null,items);
if((cnt < (32))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",comma_sep.call(null,items),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",comma_sep.call(null,items),"], true)");
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__6604){
var map__6605 = p__6604;
var map__6605__$1 = cljs.core.__destructure_map.call(null,map__6605);
var items = cljs.core.get.call(null,map__6605__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6605__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_vector.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_.call(null,(function (p1__6606_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6606_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count.call(null,items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(distinct_constants_QMARK_.call(null,items))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",comma_sep.call(null,items),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__6607){
var map__6608 = p__6607;
var map__6608__$1 = cljs.core.__destructure_map.call(null,map__6608);
var items = cljs.core.get.call(null,map__6608__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6608__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_set.call(null,items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.call(null,"({");

var temp__5753__auto___6631 = cljs.core.seq.call(null,items);
if(temp__5753__auto___6631){
var items_6632__$1 = temp__5753__auto___6631;
var vec__6609_6633 = items_6632__$1;
var seq__6610_6634 = cljs.core.seq.call(null,vec__6609_6633);
var first__6611_6635 = cljs.core.first.call(null,seq__6610_6634);
var seq__6610_6636__$1 = cljs.core.next.call(null,seq__6610_6634);
var vec__6612_6637 = first__6611_6635;
var k_6638 = cljs.core.nth.call(null,vec__6612_6637,(0),null);
var v_6639 = cljs.core.nth.call(null,vec__6612_6637,(1),null);
var r_6640 = seq__6610_6636__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_6638),"\": ",emit_js_object_val.call(null,v_6639));

var seq__6615_6641 = cljs.core.seq.call(null,r_6640);
var chunk__6616_6642 = null;
var count__6617_6643 = (0);
var i__6618_6644 = (0);
while(true){
if((i__6618_6644 < count__6617_6643)){
var vec__6625_6645 = cljs.core._nth.call(null,chunk__6616_6642,i__6618_6644);
var k_6646__$1 = cljs.core.nth.call(null,vec__6625_6645,(0),null);
var v_6647__$1 = cljs.core.nth.call(null,vec__6625_6645,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_6646__$1),"\": ",emit_js_object_val.call(null,v_6647__$1));


var G__6648 = seq__6615_6641;
var G__6649 = chunk__6616_6642;
var G__6650 = count__6617_6643;
var G__6651 = (i__6618_6644 + (1));
seq__6615_6641 = G__6648;
chunk__6616_6642 = G__6649;
count__6617_6643 = G__6650;
i__6618_6644 = G__6651;
continue;
} else {
var temp__5753__auto___6652__$1 = cljs.core.seq.call(null,seq__6615_6641);
if(temp__5753__auto___6652__$1){
var seq__6615_6653__$1 = temp__5753__auto___6652__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6615_6653__$1)){
var c__4649__auto___6654 = cljs.core.chunk_first.call(null,seq__6615_6653__$1);
var G__6655 = cljs.core.chunk_rest.call(null,seq__6615_6653__$1);
var G__6656 = c__4649__auto___6654;
var G__6657 = cljs.core.count.call(null,c__4649__auto___6654);
var G__6658 = (0);
seq__6615_6641 = G__6655;
chunk__6616_6642 = G__6656;
count__6617_6643 = G__6657;
i__6618_6644 = G__6658;
continue;
} else {
var vec__6628_6659 = cljs.core.first.call(null,seq__6615_6653__$1);
var k_6660__$1 = cljs.core.nth.call(null,vec__6628_6659,(0),null);
var v_6661__$1 = cljs.core.nth.call(null,vec__6628_6659,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_6660__$1),"\": ",emit_js_object_val.call(null,v_6661__$1));


var G__6662 = cljs.core.next.call(null,seq__6615_6653__$1);
var G__6663 = null;
var G__6664 = (0);
var G__6665 = (0);
seq__6615_6641 = G__6662;
chunk__6616_6642 = G__6663;
count__6617_6643 = G__6664;
i__6618_6644 = G__6665;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.call(null,"[",comma_sep.call(null,items),"]");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__6666){
var map__6667 = p__6666;
var map__6667__$1 = cljs.core.__destructure_map.call(null,map__6667);
var keys = cljs.core.get.call(null,map__6667__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__6667__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.call(null,map__6667__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_object.call(null,cljs.core.map.call(null,cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__6668){
var map__6669 = p__6668;
var map__6669__$1 = cljs.core.__destructure_map.call(null,map__6669);
var items = cljs.core.get.call(null,map__6669__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6669__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_array.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__6670){
var map__6671 = p__6670;
var map__6671__$1 = cljs.core.__destructure_map.call(null,map__6671);
var expr = cljs.core.get.call(null,map__6671__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__6672){
var map__6673 = p__6672;
var map__6673__$1 = cljs.core.__destructure_map.call(null,map__6673);
var form = cljs.core.get.call(null,map__6673__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__6673__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__6674 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__6674__$1 = cljs.core.__destructure_map.call(null,map__6674);
var op = cljs.core.get.call(null,map__6674__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__6674__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__6674__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4223__auto__ = (function (){var and__4221__auto__ = cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__4221__auto__){
var and__4221__auto____$1 = form;
if(cljs.core.truth_(and__4221__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.call(null,form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = (!((const_expr == null)));
if(and__4221__auto__){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return and__4221__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__6675 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__6675__$1 = cljs.core.__destructure_map.call(null,map__6675);
var op = cljs.core.get.call(null,map__6675__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__6675__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__6675__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4223__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = (!((const_expr == null)));
if(and__4221__auto__){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return and__4221__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__4223__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__6676){
var map__6677 = p__6676;
var map__6677__$1 = cljs.core.__destructure_map.call(null,map__6677);
var test = cljs.core.get.call(null,map__6677__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__6677__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__6677__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__6677__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__6677__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__4223__auto__ = unchecked;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__6678){
var map__6679 = p__6678;
var map__6679__$1 = cljs.core.__destructure_map.call(null,map__6679);
var v = cljs.core.get.call(null,map__6679__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.call(null,map__6679__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.call(null,map__6679__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__6679__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__6680_6708 = cljs.core.seq.call(null,nodes);
var chunk__6681_6709 = null;
var count__6682_6710 = (0);
var i__6683_6711 = (0);
while(true){
if((i__6683_6711 < count__6682_6710)){
var map__6696_6712 = cljs.core._nth.call(null,chunk__6681_6709,i__6683_6711);
var map__6696_6713__$1 = cljs.core.__destructure_map.call(null,map__6696_6712);
var ts_6714 = cljs.core.get.call(null,map__6696_6713__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6697_6715 = cljs.core.get.call(null,map__6696_6713__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6697_6716__$1 = cljs.core.__destructure_map.call(null,map__6697_6715);
var then_6717 = cljs.core.get.call(null,map__6697_6716__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6698_6718 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_6714));
var chunk__6699_6719 = null;
var count__6700_6720 = (0);
var i__6701_6721 = (0);
while(true){
if((i__6701_6721 < count__6700_6720)){
var test_6722 = cljs.core._nth.call(null,chunk__6699_6719,i__6701_6721);
cljs.compiler.emitln.call(null,"case ",test_6722,":");


var G__6723 = seq__6698_6718;
var G__6724 = chunk__6699_6719;
var G__6725 = count__6700_6720;
var G__6726 = (i__6701_6721 + (1));
seq__6698_6718 = G__6723;
chunk__6699_6719 = G__6724;
count__6700_6720 = G__6725;
i__6701_6721 = G__6726;
continue;
} else {
var temp__5753__auto___6727 = cljs.core.seq.call(null,seq__6698_6718);
if(temp__5753__auto___6727){
var seq__6698_6728__$1 = temp__5753__auto___6727;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6698_6728__$1)){
var c__4649__auto___6729 = cljs.core.chunk_first.call(null,seq__6698_6728__$1);
var G__6730 = cljs.core.chunk_rest.call(null,seq__6698_6728__$1);
var G__6731 = c__4649__auto___6729;
var G__6732 = cljs.core.count.call(null,c__4649__auto___6729);
var G__6733 = (0);
seq__6698_6718 = G__6730;
chunk__6699_6719 = G__6731;
count__6700_6720 = G__6732;
i__6701_6721 = G__6733;
continue;
} else {
var test_6734 = cljs.core.first.call(null,seq__6698_6728__$1);
cljs.compiler.emitln.call(null,"case ",test_6734,":");


var G__6735 = cljs.core.next.call(null,seq__6698_6728__$1);
var G__6736 = null;
var G__6737 = (0);
var G__6738 = (0);
seq__6698_6718 = G__6735;
chunk__6699_6719 = G__6736;
count__6700_6720 = G__6737;
i__6701_6721 = G__6738;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_6717);
} else {
cljs.compiler.emitln.call(null,then_6717);
}

cljs.compiler.emitln.call(null,"break;");


var G__6739 = seq__6680_6708;
var G__6740 = chunk__6681_6709;
var G__6741 = count__6682_6710;
var G__6742 = (i__6683_6711 + (1));
seq__6680_6708 = G__6739;
chunk__6681_6709 = G__6740;
count__6682_6710 = G__6741;
i__6683_6711 = G__6742;
continue;
} else {
var temp__5753__auto___6743 = cljs.core.seq.call(null,seq__6680_6708);
if(temp__5753__auto___6743){
var seq__6680_6744__$1 = temp__5753__auto___6743;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6680_6744__$1)){
var c__4649__auto___6745 = cljs.core.chunk_first.call(null,seq__6680_6744__$1);
var G__6746 = cljs.core.chunk_rest.call(null,seq__6680_6744__$1);
var G__6747 = c__4649__auto___6745;
var G__6748 = cljs.core.count.call(null,c__4649__auto___6745);
var G__6749 = (0);
seq__6680_6708 = G__6746;
chunk__6681_6709 = G__6747;
count__6682_6710 = G__6748;
i__6683_6711 = G__6749;
continue;
} else {
var map__6702_6750 = cljs.core.first.call(null,seq__6680_6744__$1);
var map__6702_6751__$1 = cljs.core.__destructure_map.call(null,map__6702_6750);
var ts_6752 = cljs.core.get.call(null,map__6702_6751__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6703_6753 = cljs.core.get.call(null,map__6702_6751__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6703_6754__$1 = cljs.core.__destructure_map.call(null,map__6703_6753);
var then_6755 = cljs.core.get.call(null,map__6703_6754__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6704_6756 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_6752));
var chunk__6705_6757 = null;
var count__6706_6758 = (0);
var i__6707_6759 = (0);
while(true){
if((i__6707_6759 < count__6706_6758)){
var test_6760 = cljs.core._nth.call(null,chunk__6705_6757,i__6707_6759);
cljs.compiler.emitln.call(null,"case ",test_6760,":");


var G__6761 = seq__6704_6756;
var G__6762 = chunk__6705_6757;
var G__6763 = count__6706_6758;
var G__6764 = (i__6707_6759 + (1));
seq__6704_6756 = G__6761;
chunk__6705_6757 = G__6762;
count__6706_6758 = G__6763;
i__6707_6759 = G__6764;
continue;
} else {
var temp__5753__auto___6765__$1 = cljs.core.seq.call(null,seq__6704_6756);
if(temp__5753__auto___6765__$1){
var seq__6704_6766__$1 = temp__5753__auto___6765__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6704_6766__$1)){
var c__4649__auto___6767 = cljs.core.chunk_first.call(null,seq__6704_6766__$1);
var G__6768 = cljs.core.chunk_rest.call(null,seq__6704_6766__$1);
var G__6769 = c__4649__auto___6767;
var G__6770 = cljs.core.count.call(null,c__4649__auto___6767);
var G__6771 = (0);
seq__6704_6756 = G__6768;
chunk__6705_6757 = G__6769;
count__6706_6758 = G__6770;
i__6707_6759 = G__6771;
continue;
} else {
var test_6772 = cljs.core.first.call(null,seq__6704_6766__$1);
cljs.compiler.emitln.call(null,"case ",test_6772,":");


var G__6773 = cljs.core.next.call(null,seq__6704_6766__$1);
var G__6774 = null;
var G__6775 = (0);
var G__6776 = (0);
seq__6704_6756 = G__6773;
chunk__6705_6757 = G__6774;
count__6706_6758 = G__6775;
i__6707_6759 = G__6776;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_6755);
} else {
cljs.compiler.emitln.call(null,then_6755);
}

cljs.compiler.emitln.call(null,"break;");


var G__6777 = cljs.core.next.call(null,seq__6680_6744__$1);
var G__6778 = null;
var G__6779 = (0);
var G__6780 = (0);
seq__6680_6708 = G__6777;
chunk__6681_6709 = G__6778;
count__6682_6710 = G__6779;
i__6683_6711 = G__6780;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__6781){
var map__6782 = p__6781;
var map__6782__$1 = cljs.core.__destructure_map.call(null,map__6782);
var throw$ = cljs.core.get.call(null,map__6782__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.call(null,map__6782__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__6784 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__6784,(0),null);
var rstr = cljs.core.nth.call(null,vec__6784,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,(function (p1__6783_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__6783_SHARP_);
}),clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__6787 = ["function(",clojure.string.join.call(null,",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__6787,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__6787;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return ["{",clojure.string.join.call(null,"|",cljs.core.map.call(null,(function (p1__6788_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__6788_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__6789 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__6790 = cljs.core.seq.call(null,vec__6789);
var first__6791 = cljs.core.first.call(null,seq__6790);
var seq__6790__$1 = cljs.core.next.call(null,seq__6790);
var p = first__6791;
var first__6791__$1 = cljs.core.first.call(null,seq__6790__$1);
var seq__6790__$2 = cljs.core.next.call(null,seq__6790__$1);
var ts = first__6791__$1;
var first__6791__$2 = cljs.core.first.call(null,seq__6790__$2);
var seq__6790__$3 = cljs.core.next.call(null,seq__6790__$2);
var n = first__6791__$2;
var xs = seq__6790__$3;
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.call(null,"@param",p);
if(and__4221__auto__){
var and__4221__auto____$1 = ts;
if(cljs.core.truth_(and__4221__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__6792 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__6793 = cljs.core.seq.call(null,vec__6792);
var first__6794 = cljs.core.first.call(null,seq__6793);
var seq__6793__$1 = cljs.core.next.call(null,seq__6793);
var p = first__6794;
var first__6794__$1 = cljs.core.first.call(null,seq__6793__$1);
var seq__6793__$2 = cljs.core.next.call(null,seq__6793__$1);
var ts = first__6794__$1;
var xs = seq__6793__$2;
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.call(null,"@return",p);
if(and__4221__auto__){
var and__4221__auto____$1 = ts;
if(cljs.core.truth_(and__4221__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__6797 = arguments.length;
switch (G__6797) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__6805 = cljs.core.map.call(null,(function (p1__6795_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__6795_SHARP_);
} else {
return p1__6795_SHARP_;
}
}),clojure.string.split_lines.call(null,e));
var seq__6806 = cljs.core.seq.call(null,vec__6805);
var first__6807 = cljs.core.first.call(null,seq__6806);
var seq__6806__$1 = cljs.core.next.call(null,seq__6806);
var x = first__6807;
var ys = seq__6806__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__6808 = cljs.core.seq.call(null,ys);
var chunk__6809 = null;
var count__6810 = (0);
var i__6811 = (0);
while(true){
if((i__6811 < count__6810)){
var next_line = cljs.core._nth.call(null,chunk__6809,i__6811);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__6817 = seq__6808;
var G__6818 = chunk__6809;
var G__6819 = count__6810;
var G__6820 = (i__6811 + (1));
seq__6808 = G__6817;
chunk__6809 = G__6818;
count__6810 = G__6819;
i__6811 = G__6820;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__6808);
if(temp__5753__auto__){
var seq__6808__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6808__$1)){
var c__4649__auto__ = cljs.core.chunk_first.call(null,seq__6808__$1);
var G__6821 = cljs.core.chunk_rest.call(null,seq__6808__$1);
var G__6822 = c__4649__auto__;
var G__6823 = cljs.core.count.call(null,c__4649__auto__);
var G__6824 = (0);
seq__6808 = G__6821;
chunk__6809 = G__6822;
count__6810 = G__6823;
i__6811 = G__6824;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__6808__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__6825 = cljs.core.next.call(null,seq__6808__$1);
var G__6826 = null;
var G__6827 = (0);
var G__6828 = (0);
seq__6808 = G__6825;
chunk__6809 = G__6826;
count__6810 = G__6827;
i__6811 = G__6828;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__6812_6829 = cljs.core.seq.call(null,docs__$2);
var chunk__6813_6830 = null;
var count__6814_6831 = (0);
var i__6815_6832 = (0);
while(true){
if((i__6815_6832 < count__6814_6831)){
var e_6833 = cljs.core._nth.call(null,chunk__6813_6830,i__6815_6832);
if(cljs.core.truth_(e_6833)){
print_comment_lines.call(null,e_6833);
} else {
}


var G__6834 = seq__6812_6829;
var G__6835 = chunk__6813_6830;
var G__6836 = count__6814_6831;
var G__6837 = (i__6815_6832 + (1));
seq__6812_6829 = G__6834;
chunk__6813_6830 = G__6835;
count__6814_6831 = G__6836;
i__6815_6832 = G__6837;
continue;
} else {
var temp__5753__auto___6838 = cljs.core.seq.call(null,seq__6812_6829);
if(temp__5753__auto___6838){
var seq__6812_6839__$1 = temp__5753__auto___6838;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6812_6839__$1)){
var c__4649__auto___6840 = cljs.core.chunk_first.call(null,seq__6812_6839__$1);
var G__6841 = cljs.core.chunk_rest.call(null,seq__6812_6839__$1);
var G__6842 = c__4649__auto___6840;
var G__6843 = cljs.core.count.call(null,c__4649__auto___6840);
var G__6844 = (0);
seq__6812_6829 = G__6841;
chunk__6813_6830 = G__6842;
count__6814_6831 = G__6843;
i__6815_6832 = G__6844;
continue;
} else {
var e_6845 = cljs.core.first.call(null,seq__6812_6839__$1);
if(cljs.core.truth_(e_6845)){
print_comment_lines.call(null,e_6845);
} else {
}


var G__6846 = cljs.core.next.call(null,seq__6812_6839__$1);
var G__6847 = null;
var G__6848 = (0);
var G__6849 = (0);
seq__6812_6829 = G__6846;
chunk__6813_6830 = G__6847;
count__6814_6831 = G__6848;
i__6815_6832 = G__6849;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4221__auto__ = cljs.core.some.call(null,(function (p1__6851_SHARP_){
return goog.string.startsWith(p1__6851_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = opts;
if(cljs.core.truth_(and__4221__auto____$1)){
var and__4221__auto____$2 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__4221__auto____$2){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_.call(null,define)){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return and__4221__auto____$2;
}
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__6852){
var map__6853 = p__6852;
var map__6853__$1 = cljs.core.__destructure_map.call(null,map__6853);
var doc = cljs.core.get.call(null,map__6853__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__6853__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.call(null,map__6853__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.call(null,map__6853__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.call(null,map__6853__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.call(null,map__6853__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__6853__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.call(null,map__6853__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.call(null,map__6853__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.call(null,map__6853__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4223__auto__ = init;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,(cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
return test;
} else {
return and__4221__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__6854){
var map__6855 = p__6854;
var map__6855__$1 = cljs.core.__destructure_map.call(null,map__6855);
var name = cljs.core.get.call(null,map__6855__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__6855__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__6855__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__6856_6880 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__6857_6881 = null;
var count__6858_6882 = (0);
var i__6859_6883 = (0);
while(true){
if((i__6859_6883 < count__6858_6882)){
var vec__6866_6884 = cljs.core._nth.call(null,chunk__6857_6881,i__6859_6883);
var i_6885 = cljs.core.nth.call(null,vec__6866_6884,(0),null);
var param_6886 = cljs.core.nth.call(null,vec__6866_6884,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_6886);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__6887 = seq__6856_6880;
var G__6888 = chunk__6857_6881;
var G__6889 = count__6858_6882;
var G__6890 = (i__6859_6883 + (1));
seq__6856_6880 = G__6887;
chunk__6857_6881 = G__6888;
count__6858_6882 = G__6889;
i__6859_6883 = G__6890;
continue;
} else {
var temp__5753__auto___6891 = cljs.core.seq.call(null,seq__6856_6880);
if(temp__5753__auto___6891){
var seq__6856_6892__$1 = temp__5753__auto___6891;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6856_6892__$1)){
var c__4649__auto___6893 = cljs.core.chunk_first.call(null,seq__6856_6892__$1);
var G__6894 = cljs.core.chunk_rest.call(null,seq__6856_6892__$1);
var G__6895 = c__4649__auto___6893;
var G__6896 = cljs.core.count.call(null,c__4649__auto___6893);
var G__6897 = (0);
seq__6856_6880 = G__6894;
chunk__6857_6881 = G__6895;
count__6858_6882 = G__6896;
i__6859_6883 = G__6897;
continue;
} else {
var vec__6869_6898 = cljs.core.first.call(null,seq__6856_6892__$1);
var i_6899 = cljs.core.nth.call(null,vec__6869_6898,(0),null);
var param_6900 = cljs.core.nth.call(null,vec__6869_6898,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_6900);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__6901 = cljs.core.next.call(null,seq__6856_6892__$1);
var G__6902 = null;
var G__6903 = (0);
var G__6904 = (0);
seq__6856_6880 = G__6901;
chunk__6857_6881 = G__6902;
count__6858_6882 = G__6903;
i__6859_6883 = G__6904;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__6872_6905 = cljs.core.seq.call(null,params);
var chunk__6873_6906 = null;
var count__6874_6907 = (0);
var i__6875_6908 = (0);
while(true){
if((i__6875_6908 < count__6874_6907)){
var param_6909 = cljs.core._nth.call(null,chunk__6873_6906,i__6875_6908);
cljs.compiler.emit.call(null,param_6909);

if(cljs.core._EQ_.call(null,param_6909,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6910 = seq__6872_6905;
var G__6911 = chunk__6873_6906;
var G__6912 = count__6874_6907;
var G__6913 = (i__6875_6908 + (1));
seq__6872_6905 = G__6910;
chunk__6873_6906 = G__6911;
count__6874_6907 = G__6912;
i__6875_6908 = G__6913;
continue;
} else {
var temp__5753__auto___6914 = cljs.core.seq.call(null,seq__6872_6905);
if(temp__5753__auto___6914){
var seq__6872_6915__$1 = temp__5753__auto___6914;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6872_6915__$1)){
var c__4649__auto___6916 = cljs.core.chunk_first.call(null,seq__6872_6915__$1);
var G__6917 = cljs.core.chunk_rest.call(null,seq__6872_6915__$1);
var G__6918 = c__4649__auto___6916;
var G__6919 = cljs.core.count.call(null,c__4649__auto___6916);
var G__6920 = (0);
seq__6872_6905 = G__6917;
chunk__6873_6906 = G__6918;
count__6874_6907 = G__6919;
i__6875_6908 = G__6920;
continue;
} else {
var param_6921 = cljs.core.first.call(null,seq__6872_6915__$1);
cljs.compiler.emit.call(null,param_6921);

if(cljs.core._EQ_.call(null,param_6921,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6922 = cljs.core.next.call(null,seq__6872_6915__$1);
var G__6923 = null;
var G__6924 = (0);
var G__6925 = (0);
seq__6872_6905 = G__6922;
chunk__6873_6906 = G__6923;
count__6874_6907 = G__6924;
i__6875_6908 = G__6925;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__6876_6926 = cljs.core.seq.call(null,params);
var chunk__6877_6927 = null;
var count__6878_6928 = (0);
var i__6879_6929 = (0);
while(true){
if((i__6879_6929 < count__6878_6928)){
var param_6930 = cljs.core._nth.call(null,chunk__6877_6927,i__6879_6929);
cljs.compiler.emit.call(null,param_6930);

if(cljs.core._EQ_.call(null,param_6930,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6931 = seq__6876_6926;
var G__6932 = chunk__6877_6927;
var G__6933 = count__6878_6928;
var G__6934 = (i__6879_6929 + (1));
seq__6876_6926 = G__6931;
chunk__6877_6927 = G__6932;
count__6878_6928 = G__6933;
i__6879_6929 = G__6934;
continue;
} else {
var temp__5753__auto___6935 = cljs.core.seq.call(null,seq__6876_6926);
if(temp__5753__auto___6935){
var seq__6876_6936__$1 = temp__5753__auto___6935;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6876_6936__$1)){
var c__4649__auto___6937 = cljs.core.chunk_first.call(null,seq__6876_6936__$1);
var G__6938 = cljs.core.chunk_rest.call(null,seq__6876_6936__$1);
var G__6939 = c__4649__auto___6937;
var G__6940 = cljs.core.count.call(null,c__4649__auto___6937);
var G__6941 = (0);
seq__6876_6926 = G__6938;
chunk__6877_6927 = G__6939;
count__6878_6928 = G__6940;
i__6879_6929 = G__6941;
continue;
} else {
var param_6942 = cljs.core.first.call(null,seq__6876_6936__$1);
cljs.compiler.emit.call(null,param_6942);

if(cljs.core._EQ_.call(null,param_6942,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6943 = cljs.core.next.call(null,seq__6876_6936__$1);
var G__6944 = null;
var G__6945 = (0);
var G__6946 = (0);
seq__6876_6926 = G__6943;
chunk__6877_6927 = G__6944;
count__6878_6928 = G__6945;
i__6879_6929 = G__6946;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__6947 = cljs.core.seq.call(null,params);
var chunk__6948 = null;
var count__6949 = (0);
var i__6950 = (0);
while(true){
if((i__6950 < count__6949)){
var param = cljs.core._nth.call(null,chunk__6948,i__6950);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6951 = seq__6947;
var G__6952 = chunk__6948;
var G__6953 = count__6949;
var G__6954 = (i__6950 + (1));
seq__6947 = G__6951;
chunk__6948 = G__6952;
count__6949 = G__6953;
i__6950 = G__6954;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__6947);
if(temp__5753__auto__){
var seq__6947__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6947__$1)){
var c__4649__auto__ = cljs.core.chunk_first.call(null,seq__6947__$1);
var G__6955 = cljs.core.chunk_rest.call(null,seq__6947__$1);
var G__6956 = c__4649__auto__;
var G__6957 = cljs.core.count.call(null,c__4649__auto__);
var G__6958 = (0);
seq__6947 = G__6955;
chunk__6948 = G__6956;
count__6949 = G__6957;
i__6950 = G__6958;
continue;
} else {
var param = cljs.core.first.call(null,seq__6947__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6959 = cljs.core.next.call(null,seq__6947__$1);
var G__6960 = null;
var G__6961 = (0);
var G__6962 = (0);
seq__6947 = G__6959;
chunk__6948 = G__6960;
count__6949 = G__6961;
i__6950 = G__6962;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__6963){
var map__6964 = p__6963;
var map__6964__$1 = cljs.core.__destructure_map.call(null,map__6964);
var expr = cljs.core.get.call(null,map__6964__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.call(null,map__6964__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__6964__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__6964__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__6964__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__6964__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__6965){
var map__6966 = p__6965;
var map__6966__$1 = cljs.core.__destructure_map.call(null,map__6966);
var f = map__6966__$1;
var expr = cljs.core.get.call(null,map__6966__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.call(null,map__6966__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.call(null,map__6966__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.call(null,map__6966__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__6966__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__6966__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__6966__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__6966__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_6975__$1 = (function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_6976 = cljs.compiler.munge.call(null,name_6975__$1);
var delegate_name_6977 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_6976),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_6977," = function (");

var seq__6967_6978 = cljs.core.seq.call(null,params);
var chunk__6968_6979 = null;
var count__6969_6980 = (0);
var i__6970_6981 = (0);
while(true){
if((i__6970_6981 < count__6969_6980)){
var param_6982 = cljs.core._nth.call(null,chunk__6968_6979,i__6970_6981);
cljs.compiler.emit.call(null,param_6982);

if(cljs.core._EQ_.call(null,param_6982,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6983 = seq__6967_6978;
var G__6984 = chunk__6968_6979;
var G__6985 = count__6969_6980;
var G__6986 = (i__6970_6981 + (1));
seq__6967_6978 = G__6983;
chunk__6968_6979 = G__6984;
count__6969_6980 = G__6985;
i__6970_6981 = G__6986;
continue;
} else {
var temp__5753__auto___6987 = cljs.core.seq.call(null,seq__6967_6978);
if(temp__5753__auto___6987){
var seq__6967_6988__$1 = temp__5753__auto___6987;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6967_6988__$1)){
var c__4649__auto___6989 = cljs.core.chunk_first.call(null,seq__6967_6988__$1);
var G__6990 = cljs.core.chunk_rest.call(null,seq__6967_6988__$1);
var G__6991 = c__4649__auto___6989;
var G__6992 = cljs.core.count.call(null,c__4649__auto___6989);
var G__6993 = (0);
seq__6967_6978 = G__6990;
chunk__6968_6979 = G__6991;
count__6969_6980 = G__6992;
i__6970_6981 = G__6993;
continue;
} else {
var param_6994 = cljs.core.first.call(null,seq__6967_6988__$1);
cljs.compiler.emit.call(null,param_6994);

if(cljs.core._EQ_.call(null,param_6994,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6995 = cljs.core.next.call(null,seq__6967_6988__$1);
var G__6996 = null;
var G__6997 = (0);
var G__6998 = (0);
seq__6967_6978 = G__6995;
chunk__6968_6979 = G__6996;
count__6969_6980 = G__6997;
i__6970_6981 = G__6998;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_6976," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_6999 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_6999,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_6977,".call(this,");

var seq__6971_7000 = cljs.core.seq.call(null,params);
var chunk__6972_7001 = null;
var count__6973_7002 = (0);
var i__6974_7003 = (0);
while(true){
if((i__6974_7003 < count__6973_7002)){
var param_7004 = cljs.core._nth.call(null,chunk__6972_7001,i__6974_7003);
cljs.compiler.emit.call(null,param_7004);

if(cljs.core._EQ_.call(null,param_7004,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7005 = seq__6971_7000;
var G__7006 = chunk__6972_7001;
var G__7007 = count__6973_7002;
var G__7008 = (i__6974_7003 + (1));
seq__6971_7000 = G__7005;
chunk__6972_7001 = G__7006;
count__6973_7002 = G__7007;
i__6974_7003 = G__7008;
continue;
} else {
var temp__5753__auto___7009 = cljs.core.seq.call(null,seq__6971_7000);
if(temp__5753__auto___7009){
var seq__6971_7010__$1 = temp__5753__auto___7009;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6971_7010__$1)){
var c__4649__auto___7011 = cljs.core.chunk_first.call(null,seq__6971_7010__$1);
var G__7012 = cljs.core.chunk_rest.call(null,seq__6971_7010__$1);
var G__7013 = c__4649__auto___7011;
var G__7014 = cljs.core.count.call(null,c__4649__auto___7011);
var G__7015 = (0);
seq__6971_7000 = G__7012;
chunk__6972_7001 = G__7013;
count__6973_7002 = G__7014;
i__6974_7003 = G__7015;
continue;
} else {
var param_7016 = cljs.core.first.call(null,seq__6971_7010__$1);
cljs.compiler.emit.call(null,param_7016);

if(cljs.core._EQ_.call(null,param_7016,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7017 = cljs.core.next.call(null,seq__6971_7010__$1);
var G__7018 = null;
var G__7019 = (0);
var G__7020 = (0);
seq__6971_7000 = G__7017;
chunk__6972_7001 = G__7018;
count__6973_7002 = G__7019;
i__6974_7003 = G__7020;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_6976,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_6976,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_6975__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_6976,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_6977,";");

cljs.compiler.emitln.call(null,"return ",mname_6976,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__7024){
var map__7025 = p__7024;
var map__7025__$1 = cljs.core.__destructure_map.call(null,map__7025);
var variadic = cljs.core.get.call(null,map__7025__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.call(null,map__7025__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__7025__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__7025__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__7025__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.call(null,map__7025__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.call(null,map__7025__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.call(null,map__7025__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,(function (p1__7021_SHARP_){
var and__4221__auto__ = p1__7021_SHARP_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__7021_SHARP_));
} else {
return and__4221__auto__;
}
}),recur_frames));
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,recur_params,(cljs.core.truth_((function (){var or__4223__auto__ = in_loop;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.seq.call(null,recur_params);
}
})())?cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets):null))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_7077__$1 = (function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_7078 = cljs.compiler.munge.call(null,name_7077__$1);
var maxparams_7079 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_7080 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7078),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_7081 = cljs.core.sort_by.call(null,(function (p1__7022_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__7022_SHARP_)));
}),cljs.core.seq.call(null,mmap_7080));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_7078," = null;");

var seq__7026_7082 = cljs.core.seq.call(null,ms_7081);
var chunk__7027_7083 = null;
var count__7028_7084 = (0);
var i__7029_7085 = (0);
while(true){
if((i__7029_7085 < count__7028_7084)){
var vec__7036_7086 = cljs.core._nth.call(null,chunk__7027_7083,i__7029_7085);
var n_7087 = cljs.core.nth.call(null,vec__7036_7086,(0),null);
var meth_7088 = cljs.core.nth.call(null,vec__7036_7086,(1),null);
cljs.compiler.emits.call(null,"var ",n_7087," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7088))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_7088);
} else {
cljs.compiler.emit_fn_method.call(null,meth_7088);
}

cljs.compiler.emitln.call(null,";");


var G__7089 = seq__7026_7082;
var G__7090 = chunk__7027_7083;
var G__7091 = count__7028_7084;
var G__7092 = (i__7029_7085 + (1));
seq__7026_7082 = G__7089;
chunk__7027_7083 = G__7090;
count__7028_7084 = G__7091;
i__7029_7085 = G__7092;
continue;
} else {
var temp__5753__auto___7093 = cljs.core.seq.call(null,seq__7026_7082);
if(temp__5753__auto___7093){
var seq__7026_7094__$1 = temp__5753__auto___7093;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7026_7094__$1)){
var c__4649__auto___7095 = cljs.core.chunk_first.call(null,seq__7026_7094__$1);
var G__7096 = cljs.core.chunk_rest.call(null,seq__7026_7094__$1);
var G__7097 = c__4649__auto___7095;
var G__7098 = cljs.core.count.call(null,c__4649__auto___7095);
var G__7099 = (0);
seq__7026_7082 = G__7096;
chunk__7027_7083 = G__7097;
count__7028_7084 = G__7098;
i__7029_7085 = G__7099;
continue;
} else {
var vec__7039_7100 = cljs.core.first.call(null,seq__7026_7094__$1);
var n_7101 = cljs.core.nth.call(null,vec__7039_7100,(0),null);
var meth_7102 = cljs.core.nth.call(null,vec__7039_7100,(1),null);
cljs.compiler.emits.call(null,"var ",n_7101," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7102))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_7102);
} else {
cljs.compiler.emit_fn_method.call(null,meth_7102);
}

cljs.compiler.emitln.call(null,";");


var G__7103 = cljs.core.next.call(null,seq__7026_7094__$1);
var G__7104 = null;
var G__7105 = (0);
var G__7106 = (0);
seq__7026_7082 = G__7103;
chunk__7027_7083 = G__7104;
count__7028_7084 = G__7105;
i__7029_7085 = G__7106;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_7078," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_7079),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_7079)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_7079));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__7042_7107 = cljs.core.seq.call(null,ms_7081);
var chunk__7043_7108 = null;
var count__7044_7109 = (0);
var i__7045_7110 = (0);
while(true){
if((i__7045_7110 < count__7044_7109)){
var vec__7052_7111 = cljs.core._nth.call(null,chunk__7043_7108,i__7045_7110);
var n_7112 = cljs.core.nth.call(null,vec__7052_7111,(0),null);
var meth_7113 = cljs.core.nth.call(null,vec__7052_7111,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7113))){
cljs.compiler.emitln.call(null,"default:");

var restarg_7114 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_7114," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_7115 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_7114," = new cljs.core.IndexedSeq(",a_7115,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_7112,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_7079)),(((cljs.core.count.call(null,maxparams_7079) > (1)))?", ":null),restarg_7114,");");
} else {
var pcnt_7116 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7113));
cljs.compiler.emitln.call(null,"case ",pcnt_7116,":");

cljs.compiler.emitln.call(null,"return ",n_7112,".call(this",(((pcnt_7116 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_7116,maxparams_7079)),null,(1),null)),(2),null))),");");
}


var G__7117 = seq__7042_7107;
var G__7118 = chunk__7043_7108;
var G__7119 = count__7044_7109;
var G__7120 = (i__7045_7110 + (1));
seq__7042_7107 = G__7117;
chunk__7043_7108 = G__7118;
count__7044_7109 = G__7119;
i__7045_7110 = G__7120;
continue;
} else {
var temp__5753__auto___7121 = cljs.core.seq.call(null,seq__7042_7107);
if(temp__5753__auto___7121){
var seq__7042_7122__$1 = temp__5753__auto___7121;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7042_7122__$1)){
var c__4649__auto___7123 = cljs.core.chunk_first.call(null,seq__7042_7122__$1);
var G__7124 = cljs.core.chunk_rest.call(null,seq__7042_7122__$1);
var G__7125 = c__4649__auto___7123;
var G__7126 = cljs.core.count.call(null,c__4649__auto___7123);
var G__7127 = (0);
seq__7042_7107 = G__7124;
chunk__7043_7108 = G__7125;
count__7044_7109 = G__7126;
i__7045_7110 = G__7127;
continue;
} else {
var vec__7055_7128 = cljs.core.first.call(null,seq__7042_7122__$1);
var n_7129 = cljs.core.nth.call(null,vec__7055_7128,(0),null);
var meth_7130 = cljs.core.nth.call(null,vec__7055_7128,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7130))){
cljs.compiler.emitln.call(null,"default:");

var restarg_7131 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_7131," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_7132 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_7131," = new cljs.core.IndexedSeq(",a_7132,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_7129,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_7079)),(((cljs.core.count.call(null,maxparams_7079) > (1)))?", ":null),restarg_7131,");");
} else {
var pcnt_7133 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7130));
cljs.compiler.emitln.call(null,"case ",pcnt_7133,":");

cljs.compiler.emitln.call(null,"return ",n_7129,".call(this",(((pcnt_7133 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_7133,maxparams_7079)),null,(1),null)),(2),null))),");");
}


var G__7134 = cljs.core.next.call(null,seq__7042_7122__$1);
var G__7135 = null;
var G__7136 = (0);
var G__7137 = (0);
seq__7042_7107 = G__7134;
chunk__7043_7108 = G__7135;
count__7044_7109 = G__7136;
i__7045_7110 = G__7137;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

var arg_count_js_7138 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,cljs.core.first.call(null,ms_7081)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + ",arg_count_js_7138,"));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_7078,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_7078,".cljs$lang$applyTo = ",cljs.core.some.call(null,(function (p1__7023_SHARP_){
var vec__7058 = p1__7023_SHARP_;
var n = cljs.core.nth.call(null,vec__7058,(0),null);
var m = cljs.core.nth.call(null,vec__7058,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_7081),".cljs$lang$applyTo;");
} else {
}

var seq__7061_7139 = cljs.core.seq.call(null,ms_7081);
var chunk__7062_7140 = null;
var count__7063_7141 = (0);
var i__7064_7142 = (0);
while(true){
if((i__7064_7142 < count__7063_7141)){
var vec__7071_7143 = cljs.core._nth.call(null,chunk__7062_7140,i__7064_7142);
var n_7144 = cljs.core.nth.call(null,vec__7071_7143,(0),null);
var meth_7145 = cljs.core.nth.call(null,vec__7071_7143,(1),null);
var c_7146 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7145));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7145))){
cljs.compiler.emitln.call(null,mname_7078,".cljs$core$IFn$_invoke$arity$variadic = ",n_7144,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_7078,".cljs$core$IFn$_invoke$arity$",c_7146," = ",n_7144,";");
}


var G__7147 = seq__7061_7139;
var G__7148 = chunk__7062_7140;
var G__7149 = count__7063_7141;
var G__7150 = (i__7064_7142 + (1));
seq__7061_7139 = G__7147;
chunk__7062_7140 = G__7148;
count__7063_7141 = G__7149;
i__7064_7142 = G__7150;
continue;
} else {
var temp__5753__auto___7151 = cljs.core.seq.call(null,seq__7061_7139);
if(temp__5753__auto___7151){
var seq__7061_7152__$1 = temp__5753__auto___7151;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7061_7152__$1)){
var c__4649__auto___7153 = cljs.core.chunk_first.call(null,seq__7061_7152__$1);
var G__7154 = cljs.core.chunk_rest.call(null,seq__7061_7152__$1);
var G__7155 = c__4649__auto___7153;
var G__7156 = cljs.core.count.call(null,c__4649__auto___7153);
var G__7157 = (0);
seq__7061_7139 = G__7154;
chunk__7062_7140 = G__7155;
count__7063_7141 = G__7156;
i__7064_7142 = G__7157;
continue;
} else {
var vec__7074_7158 = cljs.core.first.call(null,seq__7061_7152__$1);
var n_7159 = cljs.core.nth.call(null,vec__7074_7158,(0),null);
var meth_7160 = cljs.core.nth.call(null,vec__7074_7158,(1),null);
var c_7161 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7160));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7160))){
cljs.compiler.emitln.call(null,mname_7078,".cljs$core$IFn$_invoke$arity$variadic = ",n_7159,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_7078,".cljs$core$IFn$_invoke$arity$",c_7161," = ",n_7159,";");
}


var G__7162 = cljs.core.next.call(null,seq__7061_7152__$1);
var G__7163 = null;
var G__7164 = (0);
var G__7165 = (0);
seq__7061_7139 = G__7162;
chunk__7062_7140 = G__7163;
count__7063_7141 = G__7164;
i__7064_7142 = G__7165;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_7078,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__7166){
var map__7167 = p__7166;
var map__7167__$1 = cljs.core.__destructure_map.call(null,map__7167);
var statements = cljs.core.get.call(null,map__7167__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__7167__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__7167__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__7168_7172 = cljs.core.seq.call(null,statements);
var chunk__7169_7173 = null;
var count__7170_7174 = (0);
var i__7171_7175 = (0);
while(true){
if((i__7171_7175 < count__7170_7174)){
var s_7176 = cljs.core._nth.call(null,chunk__7169_7173,i__7171_7175);
cljs.compiler.emitln.call(null,s_7176);


var G__7177 = seq__7168_7172;
var G__7178 = chunk__7169_7173;
var G__7179 = count__7170_7174;
var G__7180 = (i__7171_7175 + (1));
seq__7168_7172 = G__7177;
chunk__7169_7173 = G__7178;
count__7170_7174 = G__7179;
i__7171_7175 = G__7180;
continue;
} else {
var temp__5753__auto___7181 = cljs.core.seq.call(null,seq__7168_7172);
if(temp__5753__auto___7181){
var seq__7168_7182__$1 = temp__5753__auto___7181;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7168_7182__$1)){
var c__4649__auto___7183 = cljs.core.chunk_first.call(null,seq__7168_7182__$1);
var G__7184 = cljs.core.chunk_rest.call(null,seq__7168_7182__$1);
var G__7185 = c__4649__auto___7183;
var G__7186 = cljs.core.count.call(null,c__4649__auto___7183);
var G__7187 = (0);
seq__7168_7172 = G__7184;
chunk__7169_7173 = G__7185;
count__7170_7174 = G__7186;
i__7171_7175 = G__7187;
continue;
} else {
var s_7188 = cljs.core.first.call(null,seq__7168_7182__$1);
cljs.compiler.emitln.call(null,s_7188);


var G__7189 = cljs.core.next.call(null,seq__7168_7182__$1);
var G__7190 = null;
var G__7191 = (0);
var G__7192 = (0);
seq__7168_7172 = G__7189;
chunk__7169_7173 = G__7190;
count__7170_7174 = G__7191;
i__7171_7175 = G__7192;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__7193){
var map__7194 = p__7193;
var map__7194__$1 = cljs.core.__destructure_map.call(null,map__7194);
var try$ = cljs.core.get.call(null,map__7194__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.call(null,map__7194__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.call(null,map__7194__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__7194__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__7194__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote.call(null,finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__7195,is_loop){
var map__7196 = p__7195;
var map__7196__$1 = cljs.core.__destructure_map.call(null,map__7196);
var expr = cljs.core.get.call(null,map__7196__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__7196__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__7196__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__7197_7207 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__7198_7208 = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,(function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__7198_7208);

try{var seq__7199_7209 = cljs.core.seq.call(null,bindings);
var chunk__7200_7210 = null;
var count__7201_7211 = (0);
var i__7202_7212 = (0);
while(true){
if((i__7202_7212 < count__7201_7211)){
var map__7205_7213 = cljs.core._nth.call(null,chunk__7200_7210,i__7202_7212);
var map__7205_7214__$1 = cljs.core.__destructure_map.call(null,map__7205_7213);
var binding_7215 = map__7205_7214__$1;
var init_7216 = cljs.core.get.call(null,map__7205_7214__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_7215);

cljs.compiler.emitln.call(null," = ",init_7216,";");


var G__7217 = seq__7199_7209;
var G__7218 = chunk__7200_7210;
var G__7219 = count__7201_7211;
var G__7220 = (i__7202_7212 + (1));
seq__7199_7209 = G__7217;
chunk__7200_7210 = G__7218;
count__7201_7211 = G__7219;
i__7202_7212 = G__7220;
continue;
} else {
var temp__5753__auto___7221 = cljs.core.seq.call(null,seq__7199_7209);
if(temp__5753__auto___7221){
var seq__7199_7222__$1 = temp__5753__auto___7221;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7199_7222__$1)){
var c__4649__auto___7223 = cljs.core.chunk_first.call(null,seq__7199_7222__$1);
var G__7224 = cljs.core.chunk_rest.call(null,seq__7199_7222__$1);
var G__7225 = c__4649__auto___7223;
var G__7226 = cljs.core.count.call(null,c__4649__auto___7223);
var G__7227 = (0);
seq__7199_7209 = G__7224;
chunk__7200_7210 = G__7225;
count__7201_7211 = G__7226;
i__7202_7212 = G__7227;
continue;
} else {
var map__7206_7228 = cljs.core.first.call(null,seq__7199_7222__$1);
var map__7206_7229__$1 = cljs.core.__destructure_map.call(null,map__7206_7228);
var binding_7230 = map__7206_7229__$1;
var init_7231 = cljs.core.get.call(null,map__7206_7229__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_7230);

cljs.compiler.emitln.call(null," = ",init_7231,";");


var G__7232 = cljs.core.next.call(null,seq__7199_7222__$1);
var G__7233 = null;
var G__7234 = (0);
var G__7235 = (0);
seq__7199_7209 = G__7232;
chunk__7200_7210 = G__7233;
count__7201_7211 = G__7234;
i__7202_7212 = G__7235;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__7197_7207);
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__7236){
var map__7237 = p__7236;
var map__7237__$1 = cljs.core.__destructure_map.call(null,map__7237);
var frame = cljs.core.get.call(null,map__7237__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__7237__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__7237__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4706__auto___7238 = cljs.core.count.call(null,exprs);
var i_7239 = (0);
while(true){
if((i_7239 < n__4706__auto___7238)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_7239)," = ",exprs.call(null,i_7239),";");

var G__7240 = (i_7239 + (1));
i_7239 = G__7240;
continue;
} else {
}
break;
}

var n__4706__auto___7241 = cljs.core.count.call(null,exprs);
var i_7242 = (0);
while(true){
if((i_7242 < n__4706__auto___7241)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_7242))," = ",temps.call(null,i_7242),";");

var G__7243 = (i_7242 + (1));
i_7242 = G__7243;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__7244){
var map__7245 = p__7244;
var map__7245__$1 = cljs.core.__destructure_map.call(null,map__7245);
var expr = cljs.core.get.call(null,map__7245__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__7245__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__7245__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__7246_7254 = cljs.core.seq.call(null,bindings);
var chunk__7247_7255 = null;
var count__7248_7256 = (0);
var i__7249_7257 = (0);
while(true){
if((i__7249_7257 < count__7248_7256)){
var map__7252_7258 = cljs.core._nth.call(null,chunk__7247_7255,i__7249_7257);
var map__7252_7259__$1 = cljs.core.__destructure_map.call(null,map__7252_7258);
var binding_7260 = map__7252_7259__$1;
var init_7261 = cljs.core.get.call(null,map__7252_7259__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_7260)," = ",init_7261,";");


var G__7262 = seq__7246_7254;
var G__7263 = chunk__7247_7255;
var G__7264 = count__7248_7256;
var G__7265 = (i__7249_7257 + (1));
seq__7246_7254 = G__7262;
chunk__7247_7255 = G__7263;
count__7248_7256 = G__7264;
i__7249_7257 = G__7265;
continue;
} else {
var temp__5753__auto___7266 = cljs.core.seq.call(null,seq__7246_7254);
if(temp__5753__auto___7266){
var seq__7246_7267__$1 = temp__5753__auto___7266;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7246_7267__$1)){
var c__4649__auto___7268 = cljs.core.chunk_first.call(null,seq__7246_7267__$1);
var G__7269 = cljs.core.chunk_rest.call(null,seq__7246_7267__$1);
var G__7270 = c__4649__auto___7268;
var G__7271 = cljs.core.count.call(null,c__4649__auto___7268);
var G__7272 = (0);
seq__7246_7254 = G__7269;
chunk__7247_7255 = G__7270;
count__7248_7256 = G__7271;
i__7249_7257 = G__7272;
continue;
} else {
var map__7253_7273 = cljs.core.first.call(null,seq__7246_7267__$1);
var map__7253_7274__$1 = cljs.core.__destructure_map.call(null,map__7253_7273);
var binding_7275 = map__7253_7274__$1;
var init_7276 = cljs.core.get.call(null,map__7253_7274__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_7275)," = ",init_7276,";");


var G__7277 = cljs.core.next.call(null,seq__7246_7267__$1);
var G__7278 = null;
var G__7279 = (0);
var G__7280 = (0);
seq__7246_7254 = G__7277;
chunk__7247_7255 = G__7278;
count__7248_7256 = G__7279;
i__7249_7257 = G__7280;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__7283){
var map__7284 = p__7283;
var map__7284__$1 = cljs.core.__destructure_map.call(null,map__7284);
var expr = map__7284__$1;
var f = cljs.core.get.call(null,map__7284__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.call(null,map__7284__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7284__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4221__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__4221__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4221__auto__ = protocol;
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = tag;
if(cljs.core.truth_(and__4221__auto____$1)){
var or__4223__auto__ = (function (){var and__4221__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto____$2)){
var and__4221__auto____$3 = protocol;
if(cljs.core.truth_(and__4221__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4221__auto____$3;
}
} else {
return and__4221__auto____$2;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto____$2 = (function (){var or__4223__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4221__auto____$2)){
var or__4223__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__4223__auto____$1){
return or__4223__auto____$1;
} else {
var and__4221__auto____$3 = (!(cljs.core.set_QMARK_.call(null,tag)));
if(and__4221__auto____$3){
var and__4221__auto____$4 = cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null).call(null,tag));
if(and__4221__auto____$4){
var temp__5753__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,cljs.core.vary_meta.call(null,tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return and__4221__auto____$4;
}
} else {
return and__4221__auto____$3;
}
}
} else {
return and__4221__auto____$2;
}
}
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null).call(null,first_arg_tag))));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag.call(null,env,f);
var js_QMARK_ = (function (){var or__4223__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4223__auto____$1){
return or__4223__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4223__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4223__auto__ = cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote.call(null,f);
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__7285 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return (arity > mfa);
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7281_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__7281_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7282_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__7282_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__7285,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__7285,(1),null);
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"(!(",cljs.core.first.call(null,args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.call(null,"((",cljs.core.first.call(null,args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_7288 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_7288,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_7289 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_7289,args)),(((mfa_7289 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_7289,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1));
} else {
return and__4221__auto__;
}
})())){
var fprop_7290 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.call(null,"(",f__$1,fprop_7290," ? ",f__$1,fprop_7290,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_7290," ? ",f__$1,fprop_7290,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__7291){
var map__7292 = p__7291;
var map__7292__$1 = cljs.core.__destructure_map.call(null,map__7292);
var ctor = cljs.core.get.call(null,map__7292__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.call(null,map__7292__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7292__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__7293){
var map__7294 = p__7293;
var map__7294__$1 = cljs.core.__destructure_map.call(null,map__7294);
var target = cljs.core.get.call(null,map__7294__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__7294__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__7294__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(",target," = ",val,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.call(null,sublib,/\./);
return cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (p1__7295_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__7295_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__7296 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__7296,(0),null);
var sublib = cljs.core.nth.call(null,vec__7296,(1),null);
return cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib)," = goog.global",cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.call(null,cljs.core.name.call(null,(function (){var or__4223__auto__ = cljs.core.get.call(null,global_exports,cljs.core.symbol.call(null,lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.call(null,global_exports,cljs.core.name.call(null,lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.compiler.sublib_select.call(null,sublib),";");
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__7299 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__7299__$1 = cljs.core.__destructure_map.call(null,map__7299);
var options = cljs.core.get.call(null,map__7299__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__7299__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__7300 = options;
var map__7300__$1 = cljs.core.__destructure_map.call(null,map__7300);
var target = cljs.core.get.call(null,map__7300__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.call(null,map__7300__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.call(null,map__7300__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__7301 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__7304 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__7304__$1 = cljs.core.__destructure_map.call(null,map__7304);
var node_libs = cljs.core.get.call(null,map__7304__$1,true);
var libs_to_load = cljs.core.get.call(null,map__7304__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__7301,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__7301,(1),null);
var global_exports_libs = cljs.core.filter.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__7305_7333 = cljs.core.seq.call(null,libs_to_load);
var chunk__7306_7334 = null;
var count__7307_7335 = (0);
var i__7308_7336 = (0);
while(true){
if((i__7308_7336 < count__7307_7335)){
var lib_7337 = cljs.core._nth.call(null,chunk__7306_7334,i__7308_7336);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_7337)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7337),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7337),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7337),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7337),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_7337,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7337),"');");
}

}
}
}


var G__7338 = seq__7305_7333;
var G__7339 = chunk__7306_7334;
var G__7340 = count__7307_7335;
var G__7341 = (i__7308_7336 + (1));
seq__7305_7333 = G__7338;
chunk__7306_7334 = G__7339;
count__7307_7335 = G__7340;
i__7308_7336 = G__7341;
continue;
} else {
var temp__5753__auto___7342 = cljs.core.seq.call(null,seq__7305_7333);
if(temp__5753__auto___7342){
var seq__7305_7343__$1 = temp__5753__auto___7342;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7305_7343__$1)){
var c__4649__auto___7344 = cljs.core.chunk_first.call(null,seq__7305_7343__$1);
var G__7345 = cljs.core.chunk_rest.call(null,seq__7305_7343__$1);
var G__7346 = c__4649__auto___7344;
var G__7347 = cljs.core.count.call(null,c__4649__auto___7344);
var G__7348 = (0);
seq__7305_7333 = G__7345;
chunk__7306_7334 = G__7346;
count__7307_7335 = G__7347;
i__7308_7336 = G__7348;
continue;
} else {
var lib_7349 = cljs.core.first.call(null,seq__7305_7343__$1);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_7349)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7349),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7349),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7349),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7349),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_7349,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7349),"');");
}

}
}
}


var G__7350 = cljs.core.next.call(null,seq__7305_7343__$1);
var G__7351 = null;
var G__7352 = (0);
var G__7353 = (0);
seq__7305_7333 = G__7350;
chunk__7306_7334 = G__7351;
count__7307_7335 = G__7352;
i__7308_7336 = G__7353;
continue;
}
} else {
}
}
break;
}

var seq__7309_7354 = cljs.core.seq.call(null,node_libs);
var chunk__7310_7355 = null;
var count__7311_7356 = (0);
var i__7312_7357 = (0);
while(true){
if((i__7312_7357 < count__7311_7356)){
var lib_7358 = cljs.core._nth.call(null,chunk__7310_7355,i__7312_7357);
var vec__7319_7359 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7358);
var lib_SINGLEQUOTE__7360 = cljs.core.nth.call(null,vec__7319_7359,(0),null);
var sublib_7361 = cljs.core.nth.call(null,vec__7319_7359,(1),null);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_7358)," = require('",lib_SINGLEQUOTE__7360,"')",cljs.compiler.sublib_select.call(null,sublib_7361),";");


var G__7362 = seq__7309_7354;
var G__7363 = chunk__7310_7355;
var G__7364 = count__7311_7356;
var G__7365 = (i__7312_7357 + (1));
seq__7309_7354 = G__7362;
chunk__7310_7355 = G__7363;
count__7311_7356 = G__7364;
i__7312_7357 = G__7365;
continue;
} else {
var temp__5753__auto___7366 = cljs.core.seq.call(null,seq__7309_7354);
if(temp__5753__auto___7366){
var seq__7309_7367__$1 = temp__5753__auto___7366;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7309_7367__$1)){
var c__4649__auto___7368 = cljs.core.chunk_first.call(null,seq__7309_7367__$1);
var G__7369 = cljs.core.chunk_rest.call(null,seq__7309_7367__$1);
var G__7370 = c__4649__auto___7368;
var G__7371 = cljs.core.count.call(null,c__4649__auto___7368);
var G__7372 = (0);
seq__7309_7354 = G__7369;
chunk__7310_7355 = G__7370;
count__7311_7356 = G__7371;
i__7312_7357 = G__7372;
continue;
} else {
var lib_7373 = cljs.core.first.call(null,seq__7309_7367__$1);
var vec__7322_7374 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7373);
var lib_SINGLEQUOTE__7375 = cljs.core.nth.call(null,vec__7322_7374,(0),null);
var sublib_7376 = cljs.core.nth.call(null,vec__7322_7374,(1),null);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_7373)," = require('",lib_SINGLEQUOTE__7375,"')",cljs.compiler.sublib_select.call(null,sublib_7376),";");


var G__7377 = cljs.core.next.call(null,seq__7309_7367__$1);
var G__7378 = null;
var G__7379 = (0);
var G__7380 = (0);
seq__7309_7354 = G__7377;
chunk__7310_7355 = G__7378;
count__7311_7356 = G__7379;
i__7312_7357 = G__7380;
continue;
}
} else {
}
}
break;
}

var seq__7325_7381 = cljs.core.seq.call(null,global_exports_libs);
var chunk__7326_7382 = null;
var count__7327_7383 = (0);
var i__7328_7384 = (0);
while(true){
if((i__7328_7384 < count__7327_7383)){
var lib_7385 = cljs.core._nth.call(null,chunk__7326_7382,i__7328_7384);
var map__7331_7386 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,cljs.core.first.call(null,cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7385))));
var map__7331_7387__$1 = cljs.core.__destructure_map.call(null,map__7331_7386);
var global_exports_7388 = cljs.core.get.call(null,map__7331_7387__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_7388,lib_7385);


var G__7389 = seq__7325_7381;
var G__7390 = chunk__7326_7382;
var G__7391 = count__7327_7383;
var G__7392 = (i__7328_7384 + (1));
seq__7325_7381 = G__7389;
chunk__7326_7382 = G__7390;
count__7327_7383 = G__7391;
i__7328_7384 = G__7392;
continue;
} else {
var temp__5753__auto___7393 = cljs.core.seq.call(null,seq__7325_7381);
if(temp__5753__auto___7393){
var seq__7325_7394__$1 = temp__5753__auto___7393;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7325_7394__$1)){
var c__4649__auto___7395 = cljs.core.chunk_first.call(null,seq__7325_7394__$1);
var G__7396 = cljs.core.chunk_rest.call(null,seq__7325_7394__$1);
var G__7397 = c__4649__auto___7395;
var G__7398 = cljs.core.count.call(null,c__4649__auto___7395);
var G__7399 = (0);
seq__7325_7381 = G__7396;
chunk__7326_7382 = G__7397;
count__7327_7383 = G__7398;
i__7328_7384 = G__7399;
continue;
} else {
var lib_7400 = cljs.core.first.call(null,seq__7325_7394__$1);
var map__7332_7401 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,cljs.core.first.call(null,cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7400))));
var map__7332_7402__$1 = cljs.core.__destructure_map.call(null,map__7332_7401);
var global_exports_7403 = cljs.core.get.call(null,map__7332_7402__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_7403,lib_7400);


var G__7404 = cljs.core.next.call(null,seq__7325_7394__$1);
var G__7405 = null;
var G__7406 = (0);
var G__7407 = (0);
seq__7325_7381 = G__7404;
chunk__7326_7382 = G__7405;
count__7327_7383 = G__7406;
i__7328_7384 = G__7407;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__7408){
var map__7409 = p__7408;
var map__7409__$1 = cljs.core.__destructure_map.call(null,map__7409);
var name = cljs.core.get.call(null,map__7409__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__7409__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__7409__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__7409__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__7409__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__7409__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__7409__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"'nil';");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__7410){
var map__7411 = p__7410;
var map__7411__$1 = cljs.core.__destructure_map.call(null,map__7411);
var name = cljs.core.get.call(null,map__7411__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__7411__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__7411__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__7411__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__7411__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__7411__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__7411__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__7412){
var map__7413 = p__7412;
var map__7413__$1 = cljs.core.__destructure_map.call(null,map__7413);
var t = cljs.core.get.call(null,map__7413__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__7413__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__7413__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__7413__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__7413__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__7414_7438 = cljs.core.seq.call(null,protocols);
var chunk__7415_7439 = null;
var count__7416_7440 = (0);
var i__7417_7441 = (0);
while(true){
if((i__7417_7441 < count__7416_7440)){
var protocol_7442 = cljs.core._nth.call(null,chunk__7415_7439,i__7417_7441);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7442)),"}");


var G__7443 = seq__7414_7438;
var G__7444 = chunk__7415_7439;
var G__7445 = count__7416_7440;
var G__7446 = (i__7417_7441 + (1));
seq__7414_7438 = G__7443;
chunk__7415_7439 = G__7444;
count__7416_7440 = G__7445;
i__7417_7441 = G__7446;
continue;
} else {
var temp__5753__auto___7447 = cljs.core.seq.call(null,seq__7414_7438);
if(temp__5753__auto___7447){
var seq__7414_7448__$1 = temp__5753__auto___7447;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7414_7448__$1)){
var c__4649__auto___7449 = cljs.core.chunk_first.call(null,seq__7414_7448__$1);
var G__7450 = cljs.core.chunk_rest.call(null,seq__7414_7448__$1);
var G__7451 = c__4649__auto___7449;
var G__7452 = cljs.core.count.call(null,c__4649__auto___7449);
var G__7453 = (0);
seq__7414_7438 = G__7450;
chunk__7415_7439 = G__7451;
count__7416_7440 = G__7452;
i__7417_7441 = G__7453;
continue;
} else {
var protocol_7454 = cljs.core.first.call(null,seq__7414_7448__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7454)),"}");


var G__7455 = cljs.core.next.call(null,seq__7414_7448__$1);
var G__7456 = null;
var G__7457 = (0);
var G__7458 = (0);
seq__7414_7438 = G__7455;
chunk__7415_7439 = G__7456;
count__7416_7440 = G__7457;
i__7417_7441 = G__7458;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__7418_7459 = cljs.core.seq.call(null,fields__$1);
var chunk__7419_7460 = null;
var count__7420_7461 = (0);
var i__7421_7462 = (0);
while(true){
if((i__7421_7462 < count__7420_7461)){
var fld_7463 = cljs.core._nth.call(null,chunk__7419_7460,i__7421_7462);
cljs.compiler.emitln.call(null,"this.",fld_7463," = ",fld_7463,";");


var G__7464 = seq__7418_7459;
var G__7465 = chunk__7419_7460;
var G__7466 = count__7420_7461;
var G__7467 = (i__7421_7462 + (1));
seq__7418_7459 = G__7464;
chunk__7419_7460 = G__7465;
count__7420_7461 = G__7466;
i__7421_7462 = G__7467;
continue;
} else {
var temp__5753__auto___7468 = cljs.core.seq.call(null,seq__7418_7459);
if(temp__5753__auto___7468){
var seq__7418_7469__$1 = temp__5753__auto___7468;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7418_7469__$1)){
var c__4649__auto___7470 = cljs.core.chunk_first.call(null,seq__7418_7469__$1);
var G__7471 = cljs.core.chunk_rest.call(null,seq__7418_7469__$1);
var G__7472 = c__4649__auto___7470;
var G__7473 = cljs.core.count.call(null,c__4649__auto___7470);
var G__7474 = (0);
seq__7418_7459 = G__7471;
chunk__7419_7460 = G__7472;
count__7420_7461 = G__7473;
i__7421_7462 = G__7474;
continue;
} else {
var fld_7475 = cljs.core.first.call(null,seq__7418_7469__$1);
cljs.compiler.emitln.call(null,"this.",fld_7475," = ",fld_7475,";");


var G__7476 = cljs.core.next.call(null,seq__7418_7469__$1);
var G__7477 = null;
var G__7478 = (0);
var G__7479 = (0);
seq__7418_7459 = G__7476;
chunk__7419_7460 = G__7477;
count__7420_7461 = G__7478;
i__7421_7462 = G__7479;
continue;
}
} else {
}
}
break;
}

var seq__7422_7480 = cljs.core.seq.call(null,pmasks);
var chunk__7423_7481 = null;
var count__7424_7482 = (0);
var i__7425_7483 = (0);
while(true){
if((i__7425_7483 < count__7424_7482)){
var vec__7432_7484 = cljs.core._nth.call(null,chunk__7423_7481,i__7425_7483);
var pno_7485 = cljs.core.nth.call(null,vec__7432_7484,(0),null);
var pmask_7486 = cljs.core.nth.call(null,vec__7432_7484,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7485,"$ = ",pmask_7486,";");


var G__7487 = seq__7422_7480;
var G__7488 = chunk__7423_7481;
var G__7489 = count__7424_7482;
var G__7490 = (i__7425_7483 + (1));
seq__7422_7480 = G__7487;
chunk__7423_7481 = G__7488;
count__7424_7482 = G__7489;
i__7425_7483 = G__7490;
continue;
} else {
var temp__5753__auto___7491 = cljs.core.seq.call(null,seq__7422_7480);
if(temp__5753__auto___7491){
var seq__7422_7492__$1 = temp__5753__auto___7491;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7422_7492__$1)){
var c__4649__auto___7493 = cljs.core.chunk_first.call(null,seq__7422_7492__$1);
var G__7494 = cljs.core.chunk_rest.call(null,seq__7422_7492__$1);
var G__7495 = c__4649__auto___7493;
var G__7496 = cljs.core.count.call(null,c__4649__auto___7493);
var G__7497 = (0);
seq__7422_7480 = G__7494;
chunk__7423_7481 = G__7495;
count__7424_7482 = G__7496;
i__7425_7483 = G__7497;
continue;
} else {
var vec__7435_7498 = cljs.core.first.call(null,seq__7422_7492__$1);
var pno_7499 = cljs.core.nth.call(null,vec__7435_7498,(0),null);
var pmask_7500 = cljs.core.nth.call(null,vec__7435_7498,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7499,"$ = ",pmask_7500,";");


var G__7501 = cljs.core.next.call(null,seq__7422_7492__$1);
var G__7502 = null;
var G__7503 = (0);
var G__7504 = (0);
seq__7422_7480 = G__7501;
chunk__7423_7481 = G__7502;
count__7424_7482 = G__7503;
i__7425_7483 = G__7504;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__7505){
var map__7506 = p__7505;
var map__7506__$1 = cljs.core.__destructure_map.call(null,map__7506);
var t = cljs.core.get.call(null,map__7506__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__7506__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__7506__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__7506__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__7506__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__7507_7531 = cljs.core.seq.call(null,protocols);
var chunk__7508_7532 = null;
var count__7509_7533 = (0);
var i__7510_7534 = (0);
while(true){
if((i__7510_7534 < count__7509_7533)){
var protocol_7535 = cljs.core._nth.call(null,chunk__7508_7532,i__7510_7534);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7535)),"}");


var G__7536 = seq__7507_7531;
var G__7537 = chunk__7508_7532;
var G__7538 = count__7509_7533;
var G__7539 = (i__7510_7534 + (1));
seq__7507_7531 = G__7536;
chunk__7508_7532 = G__7537;
count__7509_7533 = G__7538;
i__7510_7534 = G__7539;
continue;
} else {
var temp__5753__auto___7540 = cljs.core.seq.call(null,seq__7507_7531);
if(temp__5753__auto___7540){
var seq__7507_7541__$1 = temp__5753__auto___7540;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7507_7541__$1)){
var c__4649__auto___7542 = cljs.core.chunk_first.call(null,seq__7507_7541__$1);
var G__7543 = cljs.core.chunk_rest.call(null,seq__7507_7541__$1);
var G__7544 = c__4649__auto___7542;
var G__7545 = cljs.core.count.call(null,c__4649__auto___7542);
var G__7546 = (0);
seq__7507_7531 = G__7543;
chunk__7508_7532 = G__7544;
count__7509_7533 = G__7545;
i__7510_7534 = G__7546;
continue;
} else {
var protocol_7547 = cljs.core.first.call(null,seq__7507_7541__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7547)),"}");


var G__7548 = cljs.core.next.call(null,seq__7507_7541__$1);
var G__7549 = null;
var G__7550 = (0);
var G__7551 = (0);
seq__7507_7531 = G__7548;
chunk__7508_7532 = G__7549;
count__7509_7533 = G__7550;
i__7510_7534 = G__7551;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__7511_7552 = cljs.core.seq.call(null,fields__$1);
var chunk__7512_7553 = null;
var count__7513_7554 = (0);
var i__7514_7555 = (0);
while(true){
if((i__7514_7555 < count__7513_7554)){
var fld_7556 = cljs.core._nth.call(null,chunk__7512_7553,i__7514_7555);
cljs.compiler.emitln.call(null,"this.",fld_7556," = ",fld_7556,";");


var G__7557 = seq__7511_7552;
var G__7558 = chunk__7512_7553;
var G__7559 = count__7513_7554;
var G__7560 = (i__7514_7555 + (1));
seq__7511_7552 = G__7557;
chunk__7512_7553 = G__7558;
count__7513_7554 = G__7559;
i__7514_7555 = G__7560;
continue;
} else {
var temp__5753__auto___7561 = cljs.core.seq.call(null,seq__7511_7552);
if(temp__5753__auto___7561){
var seq__7511_7562__$1 = temp__5753__auto___7561;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7511_7562__$1)){
var c__4649__auto___7563 = cljs.core.chunk_first.call(null,seq__7511_7562__$1);
var G__7564 = cljs.core.chunk_rest.call(null,seq__7511_7562__$1);
var G__7565 = c__4649__auto___7563;
var G__7566 = cljs.core.count.call(null,c__4649__auto___7563);
var G__7567 = (0);
seq__7511_7552 = G__7564;
chunk__7512_7553 = G__7565;
count__7513_7554 = G__7566;
i__7514_7555 = G__7567;
continue;
} else {
var fld_7568 = cljs.core.first.call(null,seq__7511_7562__$1);
cljs.compiler.emitln.call(null,"this.",fld_7568," = ",fld_7568,";");


var G__7569 = cljs.core.next.call(null,seq__7511_7562__$1);
var G__7570 = null;
var G__7571 = (0);
var G__7572 = (0);
seq__7511_7552 = G__7569;
chunk__7512_7553 = G__7570;
count__7513_7554 = G__7571;
i__7514_7555 = G__7572;
continue;
}
} else {
}
}
break;
}

var seq__7515_7573 = cljs.core.seq.call(null,pmasks);
var chunk__7516_7574 = null;
var count__7517_7575 = (0);
var i__7518_7576 = (0);
while(true){
if((i__7518_7576 < count__7517_7575)){
var vec__7525_7577 = cljs.core._nth.call(null,chunk__7516_7574,i__7518_7576);
var pno_7578 = cljs.core.nth.call(null,vec__7525_7577,(0),null);
var pmask_7579 = cljs.core.nth.call(null,vec__7525_7577,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7578,"$ = ",pmask_7579,";");


var G__7580 = seq__7515_7573;
var G__7581 = chunk__7516_7574;
var G__7582 = count__7517_7575;
var G__7583 = (i__7518_7576 + (1));
seq__7515_7573 = G__7580;
chunk__7516_7574 = G__7581;
count__7517_7575 = G__7582;
i__7518_7576 = G__7583;
continue;
} else {
var temp__5753__auto___7584 = cljs.core.seq.call(null,seq__7515_7573);
if(temp__5753__auto___7584){
var seq__7515_7585__$1 = temp__5753__auto___7584;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7515_7585__$1)){
var c__4649__auto___7586 = cljs.core.chunk_first.call(null,seq__7515_7585__$1);
var G__7587 = cljs.core.chunk_rest.call(null,seq__7515_7585__$1);
var G__7588 = c__4649__auto___7586;
var G__7589 = cljs.core.count.call(null,c__4649__auto___7586);
var G__7590 = (0);
seq__7515_7573 = G__7587;
chunk__7516_7574 = G__7588;
count__7517_7575 = G__7589;
i__7518_7576 = G__7590;
continue;
} else {
var vec__7528_7591 = cljs.core.first.call(null,seq__7515_7585__$1);
var pno_7592 = cljs.core.nth.call(null,vec__7528_7591,(0),null);
var pmask_7593 = cljs.core.nth.call(null,vec__7528_7591,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7592,"$ = ",pmask_7593,";");


var G__7594 = cljs.core.next.call(null,seq__7515_7585__$1);
var G__7595 = null;
var G__7596 = (0);
var G__7597 = (0);
seq__7515_7573 = G__7594;
chunk__7516_7574 = G__7595;
count__7517_7575 = G__7596;
i__7518_7576 = G__7597;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__7598){
var map__7599 = p__7598;
var map__7599__$1 = cljs.core.__destructure_map.call(null,map__7599);
var target = cljs.core.get.call(null,map__7599__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__7599__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__7599__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__7599__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7599__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__7600){
var map__7601 = p__7600;
var map__7601__$1 = cljs.core.__destructure_map.call(null,map__7601);
var op = cljs.core.get.call(null,map__7601__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__7601__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__7601__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__7601__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__7601__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4221__auto__ = code;
if(cljs.core.truth_(and__4221__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__4221__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__6440__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6440__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__7606 = cljs.core.seq.call(null,table);
var chunk__7607 = null;
var count__7608 = (0);
var i__7609 = (0);
while(true){
if((i__7609 < count__7608)){
var vec__7616 = cljs.core._nth.call(null,chunk__7607,i__7609);
var sym = cljs.core.nth.call(null,vec__7616,(0),null);
var value = cljs.core.nth.call(null,vec__7616,(1),null);
var ns_7622 = cljs.core.namespace.call(null,sym);
var name_7623 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__7624 = seq__7606;
var G__7625 = chunk__7607;
var G__7626 = count__7608;
var G__7627 = (i__7609 + (1));
seq__7606 = G__7624;
chunk__7607 = G__7625;
count__7608 = G__7626;
i__7609 = G__7627;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__7606);
if(temp__5753__auto__){
var seq__7606__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7606__$1)){
var c__4649__auto__ = cljs.core.chunk_first.call(null,seq__7606__$1);
var G__7628 = cljs.core.chunk_rest.call(null,seq__7606__$1);
var G__7629 = c__4649__auto__;
var G__7630 = cljs.core.count.call(null,c__4649__auto__);
var G__7631 = (0);
seq__7606 = G__7628;
chunk__7607 = G__7629;
count__7608 = G__7630;
i__7609 = G__7631;
continue;
} else {
var vec__7619 = cljs.core.first.call(null,seq__7606__$1);
var sym = cljs.core.nth.call(null,vec__7619,(0),null);
var value = cljs.core.nth.call(null,vec__7619,(1),null);
var ns_7632 = cljs.core.namespace.call(null,sym);
var name_7633 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__7634 = cljs.core.next.call(null,seq__7606__$1);
var G__7635 = null;
var G__7636 = (0);
var G__7637 = (0);
seq__7606 = G__7634;
chunk__7607 = G__7635;
count__7608 = G__7636;
i__7609 = G__7637;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__7639 = arguments.length;
switch (G__7639) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs.call(null):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_7644 = cljs.core.first.call(null,ks);
var vec__7640_7645 = cljs.core.conj.call(null,prefix,k_7644);
var top_7646 = cljs.core.nth.call(null,vec__7640_7645,(0),null);
var prefix_SINGLEQUOTE__7647 = vec__7640_7645;
if(((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_7644)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__7647) == null)))){
if((!(((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_7646)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_7646)))))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__7647)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_7646);
} else {
cljs.compiler.emitln.call(null,clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__7647)),";");
}
} else {
}

var m_7648 = cljs.core.get.call(null,externs,k_7644);
if(cljs.core.empty_QMARK_.call(null,m_7648)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__7647,m_7648,top_level,known_externs);
}

var G__7649 = cljs.core.next.call(null,ks);
ks = G__7649;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

