// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__10919 = arguments.length;
switch (G__10919) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async10920 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10920 = (function (f,blockable,meta10921){
this.f = f;
this.blockable = blockable;
this.meta10921 = meta10921;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async10920.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10922,meta10921__$1){
var self__ = this;
var _10922__$1 = this;
return (new cljs.core.async.t_cljs$core$async10920(self__.f,self__.blockable,meta10921__$1));
}));

(cljs.core.async.t_cljs$core$async10920.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10922){
var self__ = this;
var _10922__$1 = this;
return self__.meta10921;
}));

(cljs.core.async.t_cljs$core$async10920.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async10920.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async10920.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async10920.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async10920.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta10921","meta10921",782243447,null)], null);
}));

(cljs.core.async.t_cljs$core$async10920.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async10920.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10920");

(cljs.core.async.t_cljs$core$async10920.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async10920");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10920.
 */
cljs.core.async.__GT_t_cljs$core$async10920 = (function cljs$core$async$__GT_t_cljs$core$async10920(f__$1,blockable__$1,meta10921){
return (new cljs.core.async.t_cljs$core$async10920(f__$1,blockable__$1,meta10921));
});

}

return (new cljs.core.async.t_cljs$core$async10920(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__10926 = arguments.length;
switch (G__10926) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__10929 = arguments.length;
switch (G__10929) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__10932 = arguments.length;
switch (G__10932) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_10934 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_10934);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_10934);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__10936 = arguments.length;
switch (G__10936) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4706__auto___10938 = n;
var x_10939 = (0);
while(true){
if((x_10939 < n__4706__auto___10938)){
(a[x_10939] = x_10939);

var G__10940 = (x_10939 + (1));
x_10939 = G__10940;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async10941 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10941 = (function (flag,meta10942){
this.flag = flag;
this.meta10942 = meta10942;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async10941.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10943,meta10942__$1){
var self__ = this;
var _10943__$1 = this;
return (new cljs.core.async.t_cljs$core$async10941(self__.flag,meta10942__$1));
}));

(cljs.core.async.t_cljs$core$async10941.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10943){
var self__ = this;
var _10943__$1 = this;
return self__.meta10942;
}));

(cljs.core.async.t_cljs$core$async10941.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async10941.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async10941.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async10941.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async10941.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta10942","meta10942",1241822741,null)], null);
}));

(cljs.core.async.t_cljs$core$async10941.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async10941.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10941");

(cljs.core.async.t_cljs$core$async10941.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async10941");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10941.
 */
cljs.core.async.__GT_t_cljs$core$async10941 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async10941(flag__$1,meta10942){
return (new cljs.core.async.t_cljs$core$async10941(flag__$1,meta10942));
});

}

return (new cljs.core.async.t_cljs$core$async10941(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async10944 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10944 = (function (flag,cb,meta10945){
this.flag = flag;
this.cb = cb;
this.meta10945 = meta10945;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async10944.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10946,meta10945__$1){
var self__ = this;
var _10946__$1 = this;
return (new cljs.core.async.t_cljs$core$async10944(self__.flag,self__.cb,meta10945__$1));
}));

(cljs.core.async.t_cljs$core$async10944.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10946){
var self__ = this;
var _10946__$1 = this;
return self__.meta10945;
}));

(cljs.core.async.t_cljs$core$async10944.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async10944.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async10944.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async10944.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async10944.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta10945","meta10945",775539217,null)], null);
}));

(cljs.core.async.t_cljs$core$async10944.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async10944.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10944");

(cljs.core.async.t_cljs$core$async10944.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async10944");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10944.
 */
cljs.core.async.__GT_t_cljs$core$async10944 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async10944(flag__$1,cb__$1,meta10945){
return (new cljs.core.async.t_cljs$core$async10944(flag__$1,cb__$1,meta10945));
});

}

return (new cljs.core.async.t_cljs$core$async10944(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__10947_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10947_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__10948_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10948_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4223__auto__ = wport;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return port;
}
})()], null));
} else {
var G__10949 = (i + (1));
i = G__10949;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4223__auto__ = ret;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4221__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___10954 = arguments.length;
var i__4830__auto___10955 = (0);
while(true){
if((i__4830__auto___10955 < len__4829__auto___10954)){
args__4835__auto__.push((arguments[i__4830__auto___10955]));

var G__10956 = (i__4830__auto___10955 + (1));
i__4830__auto___10955 = G__10956;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__10952){
var map__10953 = p__10952;
var map__10953__$1 = cljs.core.__destructure_map.call(null,map__10953);
var opts = map__10953__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq10950){
var G__10951 = cljs.core.first.call(null,seq10950);
var seq10950__$1 = cljs.core.next.call(null,seq10950);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__10951,seq10950__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__10958 = arguments.length;
switch (G__10958) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__10859__auto___11005 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_10982){
var state_val_10983 = (state_10982[(1)]);
if((state_val_10983 === (7))){
var inst_10978 = (state_10982[(2)]);
var state_10982__$1 = state_10982;
var statearr_10984_11006 = state_10982__$1;
(statearr_10984_11006[(2)] = inst_10978);

(statearr_10984_11006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10983 === (1))){
var state_10982__$1 = state_10982;
var statearr_10985_11007 = state_10982__$1;
(statearr_10985_11007[(2)] = null);

(statearr_10985_11007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10983 === (4))){
var inst_10961 = (state_10982[(7)]);
var inst_10961__$1 = (state_10982[(2)]);
var inst_10962 = (inst_10961__$1 == null);
var state_10982__$1 = (function (){var statearr_10986 = state_10982;
(statearr_10986[(7)] = inst_10961__$1);

return statearr_10986;
})();
if(cljs.core.truth_(inst_10962)){
var statearr_10987_11008 = state_10982__$1;
(statearr_10987_11008[(1)] = (5));

} else {
var statearr_10988_11009 = state_10982__$1;
(statearr_10988_11009[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10983 === (13))){
var state_10982__$1 = state_10982;
var statearr_10989_11010 = state_10982__$1;
(statearr_10989_11010[(2)] = null);

(statearr_10989_11010[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10983 === (6))){
var inst_10961 = (state_10982[(7)]);
var state_10982__$1 = state_10982;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10982__$1,(11),to,inst_10961);
} else {
if((state_val_10983 === (3))){
var inst_10980 = (state_10982[(2)]);
var state_10982__$1 = state_10982;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10982__$1,inst_10980);
} else {
if((state_val_10983 === (12))){
var state_10982__$1 = state_10982;
var statearr_10990_11011 = state_10982__$1;
(statearr_10990_11011[(2)] = null);

(statearr_10990_11011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10983 === (2))){
var state_10982__$1 = state_10982;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10982__$1,(4),from);
} else {
if((state_val_10983 === (11))){
var inst_10971 = (state_10982[(2)]);
var state_10982__$1 = state_10982;
if(cljs.core.truth_(inst_10971)){
var statearr_10991_11012 = state_10982__$1;
(statearr_10991_11012[(1)] = (12));

} else {
var statearr_10992_11013 = state_10982__$1;
(statearr_10992_11013[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10983 === (9))){
var state_10982__$1 = state_10982;
var statearr_10993_11014 = state_10982__$1;
(statearr_10993_11014[(2)] = null);

(statearr_10993_11014[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10983 === (5))){
var state_10982__$1 = state_10982;
if(cljs.core.truth_(close_QMARK_)){
var statearr_10994_11015 = state_10982__$1;
(statearr_10994_11015[(1)] = (8));

} else {
var statearr_10995_11016 = state_10982__$1;
(statearr_10995_11016[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10983 === (14))){
var inst_10976 = (state_10982[(2)]);
var state_10982__$1 = state_10982;
var statearr_10996_11017 = state_10982__$1;
(statearr_10996_11017[(2)] = inst_10976);

(statearr_10996_11017[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10983 === (10))){
var inst_10968 = (state_10982[(2)]);
var state_10982__$1 = state_10982;
var statearr_10997_11018 = state_10982__$1;
(statearr_10997_11018[(2)] = inst_10968);

(statearr_10997_11018[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10983 === (8))){
var inst_10965 = cljs.core.async.close_BANG_.call(null,to);
var state_10982__$1 = state_10982;
var statearr_10998_11019 = state_10982__$1;
(statearr_10998_11019[(2)] = inst_10965);

(statearr_10998_11019[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10786__auto__ = null;
var cljs$core$async$state_machine__10786__auto____0 = (function (){
var statearr_10999 = [null,null,null,null,null,null,null,null];
(statearr_10999[(0)] = cljs$core$async$state_machine__10786__auto__);

(statearr_10999[(1)] = (1));

return statearr_10999;
});
var cljs$core$async$state_machine__10786__auto____1 = (function (state_10982){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_10982);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e11000){var ex__10789__auto__ = e11000;
var statearr_11001_11020 = state_10982;
(statearr_11001_11020[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_10982[(4)]))){
var statearr_11002_11021 = state_10982;
(statearr_11002_11021[(1)] = cljs.core.first.call(null,(state_10982[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11022 = state_10982;
state_10982 = G__11022;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$state_machine__10786__auto__ = function(state_10982){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10786__auto____1.call(this,state_10982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10786__auto____0;
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10786__auto____1;
return cljs$core$async$state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_11003 = f__10860__auto__.call(null);
(statearr_11003[(6)] = c__10859__auto___11005);

return statearr_11003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__11023){
var vec__11024 = p__11023;
var v = cljs.core.nth.call(null,vec__11024,(0),null);
var p = cljs.core.nth.call(null,vec__11024,(1),null);
var job = vec__11024;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__10859__auto___11200 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_11031){
var state_val_11032 = (state_11031[(1)]);
if((state_val_11032 === (1))){
var state_11031__$1 = state_11031;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11031__$1,(2),res,v);
} else {
if((state_val_11032 === (2))){
var inst_11028 = (state_11031[(2)]);
var inst_11029 = cljs.core.async.close_BANG_.call(null,res);
var state_11031__$1 = (function (){var statearr_11033 = state_11031;
(statearr_11033[(7)] = inst_11028);

return statearr_11033;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11031__$1,inst_11029);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0 = (function (){
var statearr_11034 = [null,null,null,null,null,null,null,null];
(statearr_11034[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__);

(statearr_11034[(1)] = (1));

return statearr_11034;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1 = (function (state_11031){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_11031);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e11035){var ex__10789__auto__ = e11035;
var statearr_11036_11201 = state_11031;
(statearr_11036_11201[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_11031[(4)]))){
var statearr_11037_11202 = state_11031;
(statearr_11037_11202[(1)] = cljs.core.first.call(null,(state_11031[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11203 = state_11031;
state_11031 = G__11203;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__ = function(state_11031){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1.call(this,state_11031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_11038 = f__10860__auto__.call(null);
(statearr_11038[(6)] = c__10859__auto___11200);

return statearr_11038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__11039){
var vec__11040 = p__11039;
var v = cljs.core.nth.call(null,vec__11040,(0),null);
var p = cljs.core.nth.call(null,vec__11040,(1),null);
var job = vec__11040;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4706__auto___11204 = n;
var __11205 = (0);
while(true){
if((__11205 < n__4706__auto___11204)){
var G__11043_11206 = type;
var G__11043_11207__$1 = (((G__11043_11206 instanceof cljs.core.Keyword))?G__11043_11206.fqn:null);
switch (G__11043_11207__$1) {
case "compute":
var c__10859__auto___11209 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11205,c__10859__auto___11209,G__11043_11206,G__11043_11207__$1,n__4706__auto___11204,jobs,results,process,async){
return (function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = ((function (__11205,c__10859__auto___11209,G__11043_11206,G__11043_11207__$1,n__4706__auto___11204,jobs,results,process,async){
return (function (state_11056){
var state_val_11057 = (state_11056[(1)]);
if((state_val_11057 === (1))){
var state_11056__$1 = state_11056;
var statearr_11058_11210 = state_11056__$1;
(statearr_11058_11210[(2)] = null);

(statearr_11058_11210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11057 === (2))){
var state_11056__$1 = state_11056;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11056__$1,(4),jobs);
} else {
if((state_val_11057 === (3))){
var inst_11054 = (state_11056[(2)]);
var state_11056__$1 = state_11056;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11056__$1,inst_11054);
} else {
if((state_val_11057 === (4))){
var inst_11046 = (state_11056[(2)]);
var inst_11047 = process.call(null,inst_11046);
var state_11056__$1 = state_11056;
if(cljs.core.truth_(inst_11047)){
var statearr_11059_11211 = state_11056__$1;
(statearr_11059_11211[(1)] = (5));

} else {
var statearr_11060_11212 = state_11056__$1;
(statearr_11060_11212[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11057 === (5))){
var state_11056__$1 = state_11056;
var statearr_11061_11213 = state_11056__$1;
(statearr_11061_11213[(2)] = null);

(statearr_11061_11213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11057 === (6))){
var state_11056__$1 = state_11056;
var statearr_11062_11214 = state_11056__$1;
(statearr_11062_11214[(2)] = null);

(statearr_11062_11214[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11057 === (7))){
var inst_11052 = (state_11056[(2)]);
var state_11056__$1 = state_11056;
var statearr_11063_11215 = state_11056__$1;
(statearr_11063_11215[(2)] = inst_11052);

(statearr_11063_11215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11205,c__10859__auto___11209,G__11043_11206,G__11043_11207__$1,n__4706__auto___11204,jobs,results,process,async))
;
return ((function (__11205,switch__10785__auto__,c__10859__auto___11209,G__11043_11206,G__11043_11207__$1,n__4706__auto___11204,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0 = (function (){
var statearr_11064 = [null,null,null,null,null,null,null];
(statearr_11064[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__);

(statearr_11064[(1)] = (1));

return statearr_11064;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1 = (function (state_11056){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_11056);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e11065){var ex__10789__auto__ = e11065;
var statearr_11066_11216 = state_11056;
(statearr_11066_11216[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_11056[(4)]))){
var statearr_11067_11217 = state_11056;
(statearr_11067_11217[(1)] = cljs.core.first.call(null,(state_11056[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11218 = state_11056;
state_11056 = G__11218;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__ = function(state_11056){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1.call(this,state_11056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__;
})()
;})(__11205,switch__10785__auto__,c__10859__auto___11209,G__11043_11206,G__11043_11207__$1,n__4706__auto___11204,jobs,results,process,async))
})();
var state__10861__auto__ = (function (){var statearr_11068 = f__10860__auto__.call(null);
(statearr_11068[(6)] = c__10859__auto___11209);

return statearr_11068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
});})(__11205,c__10859__auto___11209,G__11043_11206,G__11043_11207__$1,n__4706__auto___11204,jobs,results,process,async))
);


break;
case "async":
var c__10859__auto___11219 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11205,c__10859__auto___11219,G__11043_11206,G__11043_11207__$1,n__4706__auto___11204,jobs,results,process,async){
return (function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = ((function (__11205,c__10859__auto___11219,G__11043_11206,G__11043_11207__$1,n__4706__auto___11204,jobs,results,process,async){
return (function (state_11081){
var state_val_11082 = (state_11081[(1)]);
if((state_val_11082 === (1))){
var state_11081__$1 = state_11081;
var statearr_11083_11220 = state_11081__$1;
(statearr_11083_11220[(2)] = null);

(statearr_11083_11220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11082 === (2))){
var state_11081__$1 = state_11081;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11081__$1,(4),jobs);
} else {
if((state_val_11082 === (3))){
var inst_11079 = (state_11081[(2)]);
var state_11081__$1 = state_11081;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11081__$1,inst_11079);
} else {
if((state_val_11082 === (4))){
var inst_11071 = (state_11081[(2)]);
var inst_11072 = async.call(null,inst_11071);
var state_11081__$1 = state_11081;
if(cljs.core.truth_(inst_11072)){
var statearr_11084_11221 = state_11081__$1;
(statearr_11084_11221[(1)] = (5));

} else {
var statearr_11085_11222 = state_11081__$1;
(statearr_11085_11222[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11082 === (5))){
var state_11081__$1 = state_11081;
var statearr_11086_11223 = state_11081__$1;
(statearr_11086_11223[(2)] = null);

(statearr_11086_11223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11082 === (6))){
var state_11081__$1 = state_11081;
var statearr_11087_11224 = state_11081__$1;
(statearr_11087_11224[(2)] = null);

(statearr_11087_11224[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11082 === (7))){
var inst_11077 = (state_11081[(2)]);
var state_11081__$1 = state_11081;
var statearr_11088_11225 = state_11081__$1;
(statearr_11088_11225[(2)] = inst_11077);

(statearr_11088_11225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11205,c__10859__auto___11219,G__11043_11206,G__11043_11207__$1,n__4706__auto___11204,jobs,results,process,async))
;
return ((function (__11205,switch__10785__auto__,c__10859__auto___11219,G__11043_11206,G__11043_11207__$1,n__4706__auto___11204,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0 = (function (){
var statearr_11089 = [null,null,null,null,null,null,null];
(statearr_11089[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__);

(statearr_11089[(1)] = (1));

return statearr_11089;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1 = (function (state_11081){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_11081);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e11090){var ex__10789__auto__ = e11090;
var statearr_11091_11226 = state_11081;
(statearr_11091_11226[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_11081[(4)]))){
var statearr_11092_11227 = state_11081;
(statearr_11092_11227[(1)] = cljs.core.first.call(null,(state_11081[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11228 = state_11081;
state_11081 = G__11228;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__ = function(state_11081){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1.call(this,state_11081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__;
})()
;})(__11205,switch__10785__auto__,c__10859__auto___11219,G__11043_11206,G__11043_11207__$1,n__4706__auto___11204,jobs,results,process,async))
})();
var state__10861__auto__ = (function (){var statearr_11093 = f__10860__auto__.call(null);
(statearr_11093[(6)] = c__10859__auto___11219);

return statearr_11093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
});})(__11205,c__10859__auto___11219,G__11043_11206,G__11043_11207__$1,n__4706__auto___11204,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11043_11207__$1)].join('')));

}

var G__11229 = (__11205 + (1));
__11205 = G__11229;
continue;
} else {
}
break;
}

var c__10859__auto___11230 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_11115){
var state_val_11116 = (state_11115[(1)]);
if((state_val_11116 === (7))){
var inst_11111 = (state_11115[(2)]);
var state_11115__$1 = state_11115;
var statearr_11117_11231 = state_11115__$1;
(statearr_11117_11231[(2)] = inst_11111);

(statearr_11117_11231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11116 === (1))){
var state_11115__$1 = state_11115;
var statearr_11118_11232 = state_11115__$1;
(statearr_11118_11232[(2)] = null);

(statearr_11118_11232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11116 === (4))){
var inst_11096 = (state_11115[(7)]);
var inst_11096__$1 = (state_11115[(2)]);
var inst_11097 = (inst_11096__$1 == null);
var state_11115__$1 = (function (){var statearr_11119 = state_11115;
(statearr_11119[(7)] = inst_11096__$1);

return statearr_11119;
})();
if(cljs.core.truth_(inst_11097)){
var statearr_11120_11233 = state_11115__$1;
(statearr_11120_11233[(1)] = (5));

} else {
var statearr_11121_11234 = state_11115__$1;
(statearr_11121_11234[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11116 === (6))){
var inst_11096 = (state_11115[(7)]);
var inst_11101 = (state_11115[(8)]);
var inst_11101__$1 = cljs.core.async.chan.call(null,(1));
var inst_11102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11103 = [inst_11096,inst_11101__$1];
var inst_11104 = (new cljs.core.PersistentVector(null,2,(5),inst_11102,inst_11103,null));
var state_11115__$1 = (function (){var statearr_11122 = state_11115;
(statearr_11122[(8)] = inst_11101__$1);

return statearr_11122;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11115__$1,(8),jobs,inst_11104);
} else {
if((state_val_11116 === (3))){
var inst_11113 = (state_11115[(2)]);
var state_11115__$1 = state_11115;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11115__$1,inst_11113);
} else {
if((state_val_11116 === (2))){
var state_11115__$1 = state_11115;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11115__$1,(4),from);
} else {
if((state_val_11116 === (9))){
var inst_11108 = (state_11115[(2)]);
var state_11115__$1 = (function (){var statearr_11123 = state_11115;
(statearr_11123[(9)] = inst_11108);

return statearr_11123;
})();
var statearr_11124_11235 = state_11115__$1;
(statearr_11124_11235[(2)] = null);

(statearr_11124_11235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11116 === (5))){
var inst_11099 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11115__$1 = state_11115;
var statearr_11125_11236 = state_11115__$1;
(statearr_11125_11236[(2)] = inst_11099);

(statearr_11125_11236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11116 === (8))){
var inst_11101 = (state_11115[(8)]);
var inst_11106 = (state_11115[(2)]);
var state_11115__$1 = (function (){var statearr_11126 = state_11115;
(statearr_11126[(10)] = inst_11106);

return statearr_11126;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11115__$1,(9),results,inst_11101);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0 = (function (){
var statearr_11127 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11127[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__);

(statearr_11127[(1)] = (1));

return statearr_11127;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1 = (function (state_11115){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_11115);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e11128){var ex__10789__auto__ = e11128;
var statearr_11129_11237 = state_11115;
(statearr_11129_11237[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_11115[(4)]))){
var statearr_11130_11238 = state_11115;
(statearr_11130_11238[(1)] = cljs.core.first.call(null,(state_11115[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11239 = state_11115;
state_11115 = G__11239;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__ = function(state_11115){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1.call(this,state_11115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_11131 = f__10860__auto__.call(null);
(statearr_11131[(6)] = c__10859__auto___11230);

return statearr_11131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


var c__10859__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_11169){
var state_val_11170 = (state_11169[(1)]);
if((state_val_11170 === (7))){
var inst_11165 = (state_11169[(2)]);
var state_11169__$1 = state_11169;
var statearr_11171_11240 = state_11169__$1;
(statearr_11171_11240[(2)] = inst_11165);

(statearr_11171_11240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (20))){
var state_11169__$1 = state_11169;
var statearr_11172_11241 = state_11169__$1;
(statearr_11172_11241[(2)] = null);

(statearr_11172_11241[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (1))){
var state_11169__$1 = state_11169;
var statearr_11173_11242 = state_11169__$1;
(statearr_11173_11242[(2)] = null);

(statearr_11173_11242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (4))){
var inst_11134 = (state_11169[(7)]);
var inst_11134__$1 = (state_11169[(2)]);
var inst_11135 = (inst_11134__$1 == null);
var state_11169__$1 = (function (){var statearr_11174 = state_11169;
(statearr_11174[(7)] = inst_11134__$1);

return statearr_11174;
})();
if(cljs.core.truth_(inst_11135)){
var statearr_11175_11243 = state_11169__$1;
(statearr_11175_11243[(1)] = (5));

} else {
var statearr_11176_11244 = state_11169__$1;
(statearr_11176_11244[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (15))){
var inst_11147 = (state_11169[(8)]);
var state_11169__$1 = state_11169;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11169__$1,(18),to,inst_11147);
} else {
if((state_val_11170 === (21))){
var inst_11160 = (state_11169[(2)]);
var state_11169__$1 = state_11169;
var statearr_11177_11245 = state_11169__$1;
(statearr_11177_11245[(2)] = inst_11160);

(statearr_11177_11245[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (13))){
var inst_11162 = (state_11169[(2)]);
var state_11169__$1 = (function (){var statearr_11178 = state_11169;
(statearr_11178[(9)] = inst_11162);

return statearr_11178;
})();
var statearr_11179_11246 = state_11169__$1;
(statearr_11179_11246[(2)] = null);

(statearr_11179_11246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (6))){
var inst_11134 = (state_11169[(7)]);
var state_11169__$1 = state_11169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11169__$1,(11),inst_11134);
} else {
if((state_val_11170 === (17))){
var inst_11155 = (state_11169[(2)]);
var state_11169__$1 = state_11169;
if(cljs.core.truth_(inst_11155)){
var statearr_11180_11247 = state_11169__$1;
(statearr_11180_11247[(1)] = (19));

} else {
var statearr_11181_11248 = state_11169__$1;
(statearr_11181_11248[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (3))){
var inst_11167 = (state_11169[(2)]);
var state_11169__$1 = state_11169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11169__$1,inst_11167);
} else {
if((state_val_11170 === (12))){
var inst_11144 = (state_11169[(10)]);
var state_11169__$1 = state_11169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11169__$1,(14),inst_11144);
} else {
if((state_val_11170 === (2))){
var state_11169__$1 = state_11169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11169__$1,(4),results);
} else {
if((state_val_11170 === (19))){
var state_11169__$1 = state_11169;
var statearr_11182_11249 = state_11169__$1;
(statearr_11182_11249[(2)] = null);

(statearr_11182_11249[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (11))){
var inst_11144 = (state_11169[(2)]);
var state_11169__$1 = (function (){var statearr_11183 = state_11169;
(statearr_11183[(10)] = inst_11144);

return statearr_11183;
})();
var statearr_11184_11250 = state_11169__$1;
(statearr_11184_11250[(2)] = null);

(statearr_11184_11250[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (9))){
var state_11169__$1 = state_11169;
var statearr_11185_11251 = state_11169__$1;
(statearr_11185_11251[(2)] = null);

(statearr_11185_11251[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (5))){
var state_11169__$1 = state_11169;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11186_11252 = state_11169__$1;
(statearr_11186_11252[(1)] = (8));

} else {
var statearr_11187_11253 = state_11169__$1;
(statearr_11187_11253[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (14))){
var inst_11147 = (state_11169[(8)]);
var inst_11149 = (state_11169[(11)]);
var inst_11147__$1 = (state_11169[(2)]);
var inst_11148 = (inst_11147__$1 == null);
var inst_11149__$1 = cljs.core.not.call(null,inst_11148);
var state_11169__$1 = (function (){var statearr_11188 = state_11169;
(statearr_11188[(8)] = inst_11147__$1);

(statearr_11188[(11)] = inst_11149__$1);

return statearr_11188;
})();
if(inst_11149__$1){
var statearr_11189_11254 = state_11169__$1;
(statearr_11189_11254[(1)] = (15));

} else {
var statearr_11190_11255 = state_11169__$1;
(statearr_11190_11255[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (16))){
var inst_11149 = (state_11169[(11)]);
var state_11169__$1 = state_11169;
var statearr_11191_11256 = state_11169__$1;
(statearr_11191_11256[(2)] = inst_11149);

(statearr_11191_11256[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (10))){
var inst_11141 = (state_11169[(2)]);
var state_11169__$1 = state_11169;
var statearr_11192_11257 = state_11169__$1;
(statearr_11192_11257[(2)] = inst_11141);

(statearr_11192_11257[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (18))){
var inst_11152 = (state_11169[(2)]);
var state_11169__$1 = state_11169;
var statearr_11193_11258 = state_11169__$1;
(statearr_11193_11258[(2)] = inst_11152);

(statearr_11193_11258[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11170 === (8))){
var inst_11138 = cljs.core.async.close_BANG_.call(null,to);
var state_11169__$1 = state_11169;
var statearr_11194_11259 = state_11169__$1;
(statearr_11194_11259[(2)] = inst_11138);

(statearr_11194_11259[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0 = (function (){
var statearr_11195 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11195[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__);

(statearr_11195[(1)] = (1));

return statearr_11195;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1 = (function (state_11169){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_11169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e11196){var ex__10789__auto__ = e11196;
var statearr_11197_11260 = state_11169;
(statearr_11197_11260[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_11169[(4)]))){
var statearr_11198_11261 = state_11169;
(statearr_11198_11261[(1)] = cljs.core.first.call(null,(state_11169[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11262 = state_11169;
state_11169 = G__11262;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__ = function(state_11169){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1.call(this,state_11169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10786__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_11199 = f__10860__auto__.call(null);
(statearr_11199[(6)] = c__10859__auto__);

return statearr_11199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));

return c__10859__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__11264 = arguments.length;
switch (G__11264) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__11267 = arguments.length;
switch (G__11267) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__11270 = arguments.length;
switch (G__11270) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__10859__auto___11320 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_11296){
var state_val_11297 = (state_11296[(1)]);
if((state_val_11297 === (7))){
var inst_11292 = (state_11296[(2)]);
var state_11296__$1 = state_11296;
var statearr_11298_11321 = state_11296__$1;
(statearr_11298_11321[(2)] = inst_11292);

(statearr_11298_11321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11297 === (1))){
var state_11296__$1 = state_11296;
var statearr_11299_11322 = state_11296__$1;
(statearr_11299_11322[(2)] = null);

(statearr_11299_11322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11297 === (4))){
var inst_11273 = (state_11296[(7)]);
var inst_11273__$1 = (state_11296[(2)]);
var inst_11274 = (inst_11273__$1 == null);
var state_11296__$1 = (function (){var statearr_11300 = state_11296;
(statearr_11300[(7)] = inst_11273__$1);

return statearr_11300;
})();
if(cljs.core.truth_(inst_11274)){
var statearr_11301_11323 = state_11296__$1;
(statearr_11301_11323[(1)] = (5));

} else {
var statearr_11302_11324 = state_11296__$1;
(statearr_11302_11324[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11297 === (13))){
var state_11296__$1 = state_11296;
var statearr_11303_11325 = state_11296__$1;
(statearr_11303_11325[(2)] = null);

(statearr_11303_11325[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11297 === (6))){
var inst_11273 = (state_11296[(7)]);
var inst_11279 = p.call(null,inst_11273);
var state_11296__$1 = state_11296;
if(cljs.core.truth_(inst_11279)){
var statearr_11304_11326 = state_11296__$1;
(statearr_11304_11326[(1)] = (9));

} else {
var statearr_11305_11327 = state_11296__$1;
(statearr_11305_11327[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11297 === (3))){
var inst_11294 = (state_11296[(2)]);
var state_11296__$1 = state_11296;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11296__$1,inst_11294);
} else {
if((state_val_11297 === (12))){
var state_11296__$1 = state_11296;
var statearr_11306_11328 = state_11296__$1;
(statearr_11306_11328[(2)] = null);

(statearr_11306_11328[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11297 === (2))){
var state_11296__$1 = state_11296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11296__$1,(4),ch);
} else {
if((state_val_11297 === (11))){
var inst_11273 = (state_11296[(7)]);
var inst_11283 = (state_11296[(2)]);
var state_11296__$1 = state_11296;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11296__$1,(8),inst_11283,inst_11273);
} else {
if((state_val_11297 === (9))){
var state_11296__$1 = state_11296;
var statearr_11307_11329 = state_11296__$1;
(statearr_11307_11329[(2)] = tc);

(statearr_11307_11329[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11297 === (5))){
var inst_11276 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11277 = cljs.core.async.close_BANG_.call(null,fc);
var state_11296__$1 = (function (){var statearr_11308 = state_11296;
(statearr_11308[(8)] = inst_11276);

return statearr_11308;
})();
var statearr_11309_11330 = state_11296__$1;
(statearr_11309_11330[(2)] = inst_11277);

(statearr_11309_11330[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11297 === (14))){
var inst_11290 = (state_11296[(2)]);
var state_11296__$1 = state_11296;
var statearr_11310_11331 = state_11296__$1;
(statearr_11310_11331[(2)] = inst_11290);

(statearr_11310_11331[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11297 === (10))){
var state_11296__$1 = state_11296;
var statearr_11311_11332 = state_11296__$1;
(statearr_11311_11332[(2)] = fc);

(statearr_11311_11332[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11297 === (8))){
var inst_11285 = (state_11296[(2)]);
var state_11296__$1 = state_11296;
if(cljs.core.truth_(inst_11285)){
var statearr_11312_11333 = state_11296__$1;
(statearr_11312_11333[(1)] = (12));

} else {
var statearr_11313_11334 = state_11296__$1;
(statearr_11313_11334[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10786__auto__ = null;
var cljs$core$async$state_machine__10786__auto____0 = (function (){
var statearr_11314 = [null,null,null,null,null,null,null,null,null];
(statearr_11314[(0)] = cljs$core$async$state_machine__10786__auto__);

(statearr_11314[(1)] = (1));

return statearr_11314;
});
var cljs$core$async$state_machine__10786__auto____1 = (function (state_11296){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_11296);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e11315){var ex__10789__auto__ = e11315;
var statearr_11316_11335 = state_11296;
(statearr_11316_11335[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_11296[(4)]))){
var statearr_11317_11336 = state_11296;
(statearr_11317_11336[(1)] = cljs.core.first.call(null,(state_11296[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11337 = state_11296;
state_11296 = G__11337;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$state_machine__10786__auto__ = function(state_11296){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10786__auto____1.call(this,state_11296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10786__auto____0;
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10786__auto____1;
return cljs$core$async$state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_11318 = f__10860__auto__.call(null);
(statearr_11318[(6)] = c__10859__auto___11320);

return statearr_11318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__10859__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_11359){
var state_val_11360 = (state_11359[(1)]);
if((state_val_11360 === (7))){
var inst_11355 = (state_11359[(2)]);
var state_11359__$1 = state_11359;
var statearr_11361_11380 = state_11359__$1;
(statearr_11361_11380[(2)] = inst_11355);

(statearr_11361_11380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11360 === (1))){
var inst_11338 = init;
var inst_11339 = inst_11338;
var state_11359__$1 = (function (){var statearr_11362 = state_11359;
(statearr_11362[(7)] = inst_11339);

return statearr_11362;
})();
var statearr_11363_11381 = state_11359__$1;
(statearr_11363_11381[(2)] = null);

(statearr_11363_11381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11360 === (4))){
var inst_11342 = (state_11359[(8)]);
var inst_11342__$1 = (state_11359[(2)]);
var inst_11343 = (inst_11342__$1 == null);
var state_11359__$1 = (function (){var statearr_11364 = state_11359;
(statearr_11364[(8)] = inst_11342__$1);

return statearr_11364;
})();
if(cljs.core.truth_(inst_11343)){
var statearr_11365_11382 = state_11359__$1;
(statearr_11365_11382[(1)] = (5));

} else {
var statearr_11366_11383 = state_11359__$1;
(statearr_11366_11383[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11360 === (6))){
var inst_11342 = (state_11359[(8)]);
var inst_11339 = (state_11359[(7)]);
var inst_11346 = (state_11359[(9)]);
var inst_11346__$1 = f.call(null,inst_11339,inst_11342);
var inst_11347 = cljs.core.reduced_QMARK_.call(null,inst_11346__$1);
var state_11359__$1 = (function (){var statearr_11367 = state_11359;
(statearr_11367[(9)] = inst_11346__$1);

return statearr_11367;
})();
if(inst_11347){
var statearr_11368_11384 = state_11359__$1;
(statearr_11368_11384[(1)] = (8));

} else {
var statearr_11369_11385 = state_11359__$1;
(statearr_11369_11385[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11360 === (3))){
var inst_11357 = (state_11359[(2)]);
var state_11359__$1 = state_11359;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11359__$1,inst_11357);
} else {
if((state_val_11360 === (2))){
var state_11359__$1 = state_11359;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11359__$1,(4),ch);
} else {
if((state_val_11360 === (9))){
var inst_11346 = (state_11359[(9)]);
var inst_11339 = inst_11346;
var state_11359__$1 = (function (){var statearr_11370 = state_11359;
(statearr_11370[(7)] = inst_11339);

return statearr_11370;
})();
var statearr_11371_11386 = state_11359__$1;
(statearr_11371_11386[(2)] = null);

(statearr_11371_11386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11360 === (5))){
var inst_11339 = (state_11359[(7)]);
var state_11359__$1 = state_11359;
var statearr_11372_11387 = state_11359__$1;
(statearr_11372_11387[(2)] = inst_11339);

(statearr_11372_11387[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11360 === (10))){
var inst_11353 = (state_11359[(2)]);
var state_11359__$1 = state_11359;
var statearr_11373_11388 = state_11359__$1;
(statearr_11373_11388[(2)] = inst_11353);

(statearr_11373_11388[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11360 === (8))){
var inst_11346 = (state_11359[(9)]);
var inst_11349 = cljs.core.deref.call(null,inst_11346);
var state_11359__$1 = state_11359;
var statearr_11374_11389 = state_11359__$1;
(statearr_11374_11389[(2)] = inst_11349);

(statearr_11374_11389[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__10786__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10786__auto____0 = (function (){
var statearr_11375 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11375[(0)] = cljs$core$async$reduce_$_state_machine__10786__auto__);

(statearr_11375[(1)] = (1));

return statearr_11375;
});
var cljs$core$async$reduce_$_state_machine__10786__auto____1 = (function (state_11359){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_11359);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e11376){var ex__10789__auto__ = e11376;
var statearr_11377_11390 = state_11359;
(statearr_11377_11390[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_11359[(4)]))){
var statearr_11378_11391 = state_11359;
(statearr_11378_11391[(1)] = cljs.core.first.call(null,(state_11359[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11392 = state_11359;
state_11359 = G__11392;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10786__auto__ = function(state_11359){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10786__auto____1.call(this,state_11359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10786__auto____0;
cljs$core$async$reduce_$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10786__auto____1;
return cljs$core$async$reduce_$_state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_11379 = f__10860__auto__.call(null);
(statearr_11379[(6)] = c__10859__auto__);

return statearr_11379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));

return c__10859__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__10859__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_11398){
var state_val_11399 = (state_11398[(1)]);
if((state_val_11399 === (1))){
var inst_11393 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_11398__$1 = state_11398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11398__$1,(2),inst_11393);
} else {
if((state_val_11399 === (2))){
var inst_11395 = (state_11398[(2)]);
var inst_11396 = f__$1.call(null,inst_11395);
var state_11398__$1 = state_11398;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11398__$1,inst_11396);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__10786__auto__ = null;
var cljs$core$async$transduce_$_state_machine__10786__auto____0 = (function (){
var statearr_11400 = [null,null,null,null,null,null,null];
(statearr_11400[(0)] = cljs$core$async$transduce_$_state_machine__10786__auto__);

(statearr_11400[(1)] = (1));

return statearr_11400;
});
var cljs$core$async$transduce_$_state_machine__10786__auto____1 = (function (state_11398){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_11398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e11401){var ex__10789__auto__ = e11401;
var statearr_11402_11405 = state_11398;
(statearr_11402_11405[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_11398[(4)]))){
var statearr_11403_11406 = state_11398;
(statearr_11403_11406[(1)] = cljs.core.first.call(null,(state_11398[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11407 = state_11398;
state_11398 = G__11407;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__10786__auto__ = function(state_11398){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__10786__auto____1.call(this,state_11398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__10786__auto____0;
cljs$core$async$transduce_$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__10786__auto____1;
return cljs$core$async$transduce_$_state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_11404 = f__10860__auto__.call(null);
(statearr_11404[(6)] = c__10859__auto__);

return statearr_11404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));

return c__10859__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__11409 = arguments.length;
switch (G__11409) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__10859__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_11434){
var state_val_11435 = (state_11434[(1)]);
if((state_val_11435 === (7))){
var inst_11416 = (state_11434[(2)]);
var state_11434__$1 = state_11434;
var statearr_11436_11458 = state_11434__$1;
(statearr_11436_11458[(2)] = inst_11416);

(statearr_11436_11458[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11435 === (1))){
var inst_11410 = cljs.core.seq.call(null,coll);
var inst_11411 = inst_11410;
var state_11434__$1 = (function (){var statearr_11437 = state_11434;
(statearr_11437[(7)] = inst_11411);

return statearr_11437;
})();
var statearr_11438_11459 = state_11434__$1;
(statearr_11438_11459[(2)] = null);

(statearr_11438_11459[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11435 === (4))){
var inst_11411 = (state_11434[(7)]);
var inst_11414 = cljs.core.first.call(null,inst_11411);
var state_11434__$1 = state_11434;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11434__$1,(7),ch,inst_11414);
} else {
if((state_val_11435 === (13))){
var inst_11428 = (state_11434[(2)]);
var state_11434__$1 = state_11434;
var statearr_11439_11460 = state_11434__$1;
(statearr_11439_11460[(2)] = inst_11428);

(statearr_11439_11460[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11435 === (6))){
var inst_11419 = (state_11434[(2)]);
var state_11434__$1 = state_11434;
if(cljs.core.truth_(inst_11419)){
var statearr_11440_11461 = state_11434__$1;
(statearr_11440_11461[(1)] = (8));

} else {
var statearr_11441_11462 = state_11434__$1;
(statearr_11441_11462[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11435 === (3))){
var inst_11432 = (state_11434[(2)]);
var state_11434__$1 = state_11434;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11434__$1,inst_11432);
} else {
if((state_val_11435 === (12))){
var state_11434__$1 = state_11434;
var statearr_11442_11463 = state_11434__$1;
(statearr_11442_11463[(2)] = null);

(statearr_11442_11463[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11435 === (2))){
var inst_11411 = (state_11434[(7)]);
var state_11434__$1 = state_11434;
if(cljs.core.truth_(inst_11411)){
var statearr_11443_11464 = state_11434__$1;
(statearr_11443_11464[(1)] = (4));

} else {
var statearr_11444_11465 = state_11434__$1;
(statearr_11444_11465[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11435 === (11))){
var inst_11425 = cljs.core.async.close_BANG_.call(null,ch);
var state_11434__$1 = state_11434;
var statearr_11445_11466 = state_11434__$1;
(statearr_11445_11466[(2)] = inst_11425);

(statearr_11445_11466[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11435 === (9))){
var state_11434__$1 = state_11434;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11446_11467 = state_11434__$1;
(statearr_11446_11467[(1)] = (11));

} else {
var statearr_11447_11468 = state_11434__$1;
(statearr_11447_11468[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11435 === (5))){
var inst_11411 = (state_11434[(7)]);
var state_11434__$1 = state_11434;
var statearr_11448_11469 = state_11434__$1;
(statearr_11448_11469[(2)] = inst_11411);

(statearr_11448_11469[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11435 === (10))){
var inst_11430 = (state_11434[(2)]);
var state_11434__$1 = state_11434;
var statearr_11449_11470 = state_11434__$1;
(statearr_11449_11470[(2)] = inst_11430);

(statearr_11449_11470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11435 === (8))){
var inst_11411 = (state_11434[(7)]);
var inst_11421 = cljs.core.next.call(null,inst_11411);
var inst_11411__$1 = inst_11421;
var state_11434__$1 = (function (){var statearr_11450 = state_11434;
(statearr_11450[(7)] = inst_11411__$1);

return statearr_11450;
})();
var statearr_11451_11471 = state_11434__$1;
(statearr_11451_11471[(2)] = null);

(statearr_11451_11471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10786__auto__ = null;
var cljs$core$async$state_machine__10786__auto____0 = (function (){
var statearr_11452 = [null,null,null,null,null,null,null,null];
(statearr_11452[(0)] = cljs$core$async$state_machine__10786__auto__);

(statearr_11452[(1)] = (1));

return statearr_11452;
});
var cljs$core$async$state_machine__10786__auto____1 = (function (state_11434){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_11434);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e11453){var ex__10789__auto__ = e11453;
var statearr_11454_11472 = state_11434;
(statearr_11454_11472[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_11434[(4)]))){
var statearr_11455_11473 = state_11434;
(statearr_11455_11473[(1)] = cljs.core.first.call(null,(state_11434[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11474 = state_11434;
state_11434 = G__11474;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$state_machine__10786__auto__ = function(state_11434){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10786__auto____1.call(this,state_11434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10786__auto____0;
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10786__auto____1;
return cljs$core$async$state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_11456 = f__10860__auto__.call(null);
(statearr_11456[(6)] = c__10859__auto__);

return statearr_11456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));

return c__10859__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan_BANG_.call(null,ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__11476 = arguments.length;
switch (G__11476) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_.call(null,coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_11478 = (function (_){
var x__4521__auto__ = (((_ == null))?null:_);
var m__4522__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,_);
} else {
var m__4519__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_11478.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_11479 = (function (m,ch,close_QMARK_){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4519__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_11479.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_11480 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m,ch);
} else {
var m__4519__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_11480.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_11481 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m);
} else {
var m__4519__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_11481.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11482 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11482 = (function (ch,cs,meta11483){
this.ch = ch;
this.cs = cs;
this.meta11483 = meta11483;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11482.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11484,meta11483__$1){
var self__ = this;
var _11484__$1 = this;
return (new cljs.core.async.t_cljs$core$async11482(self__.ch,self__.cs,meta11483__$1));
}));

(cljs.core.async.t_cljs$core$async11482.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11484){
var self__ = this;
var _11484__$1 = this;
return self__.meta11483;
}));

(cljs.core.async.t_cljs$core$async11482.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11482.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async11482.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11482.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async11482.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async11482.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async11482.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta11483","meta11483",569441644,null)], null);
}));

(cljs.core.async.t_cljs$core$async11482.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11482.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11482");

(cljs.core.async.t_cljs$core$async11482.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async11482");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11482.
 */
cljs.core.async.__GT_t_cljs$core$async11482 = (function cljs$core$async$mult_$___GT_t_cljs$core$async11482(ch__$1,cs__$1,meta11483){
return (new cljs.core.async.t_cljs$core$async11482(ch__$1,cs__$1,meta11483));
});

}

return (new cljs.core.async.t_cljs$core$async11482(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__10859__auto___11701 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_11617){
var state_val_11618 = (state_11617[(1)]);
if((state_val_11618 === (7))){
var inst_11613 = (state_11617[(2)]);
var state_11617__$1 = state_11617;
var statearr_11619_11702 = state_11617__$1;
(statearr_11619_11702[(2)] = inst_11613);

(statearr_11619_11702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (20))){
var inst_11518 = (state_11617[(7)]);
var inst_11530 = cljs.core.first.call(null,inst_11518);
var inst_11531 = cljs.core.nth.call(null,inst_11530,(0),null);
var inst_11532 = cljs.core.nth.call(null,inst_11530,(1),null);
var state_11617__$1 = (function (){var statearr_11620 = state_11617;
(statearr_11620[(8)] = inst_11531);

return statearr_11620;
})();
if(cljs.core.truth_(inst_11532)){
var statearr_11621_11703 = state_11617__$1;
(statearr_11621_11703[(1)] = (22));

} else {
var statearr_11622_11704 = state_11617__$1;
(statearr_11622_11704[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (27))){
var inst_11487 = (state_11617[(9)]);
var inst_11560 = (state_11617[(10)]);
var inst_11562 = (state_11617[(11)]);
var inst_11567 = (state_11617[(12)]);
var inst_11567__$1 = cljs.core._nth.call(null,inst_11560,inst_11562);
var inst_11568 = cljs.core.async.put_BANG_.call(null,inst_11567__$1,inst_11487,done);
var state_11617__$1 = (function (){var statearr_11623 = state_11617;
(statearr_11623[(12)] = inst_11567__$1);

return statearr_11623;
})();
if(cljs.core.truth_(inst_11568)){
var statearr_11624_11705 = state_11617__$1;
(statearr_11624_11705[(1)] = (30));

} else {
var statearr_11625_11706 = state_11617__$1;
(statearr_11625_11706[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (1))){
var state_11617__$1 = state_11617;
var statearr_11626_11707 = state_11617__$1;
(statearr_11626_11707[(2)] = null);

(statearr_11626_11707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (24))){
var inst_11518 = (state_11617[(7)]);
var inst_11537 = (state_11617[(2)]);
var inst_11538 = cljs.core.next.call(null,inst_11518);
var inst_11496 = inst_11538;
var inst_11497 = null;
var inst_11498 = (0);
var inst_11499 = (0);
var state_11617__$1 = (function (){var statearr_11627 = state_11617;
(statearr_11627[(13)] = inst_11496);

(statearr_11627[(14)] = inst_11497);

(statearr_11627[(15)] = inst_11499);

(statearr_11627[(16)] = inst_11498);

(statearr_11627[(17)] = inst_11537);

return statearr_11627;
})();
var statearr_11628_11708 = state_11617__$1;
(statearr_11628_11708[(2)] = null);

(statearr_11628_11708[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (39))){
var state_11617__$1 = state_11617;
var statearr_11632_11709 = state_11617__$1;
(statearr_11632_11709[(2)] = null);

(statearr_11632_11709[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (4))){
var inst_11487 = (state_11617[(9)]);
var inst_11487__$1 = (state_11617[(2)]);
var inst_11488 = (inst_11487__$1 == null);
var state_11617__$1 = (function (){var statearr_11633 = state_11617;
(statearr_11633[(9)] = inst_11487__$1);

return statearr_11633;
})();
if(cljs.core.truth_(inst_11488)){
var statearr_11634_11710 = state_11617__$1;
(statearr_11634_11710[(1)] = (5));

} else {
var statearr_11635_11711 = state_11617__$1;
(statearr_11635_11711[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (15))){
var inst_11496 = (state_11617[(13)]);
var inst_11497 = (state_11617[(14)]);
var inst_11499 = (state_11617[(15)]);
var inst_11498 = (state_11617[(16)]);
var inst_11514 = (state_11617[(2)]);
var inst_11515 = (inst_11499 + (1));
var tmp11629 = inst_11496;
var tmp11630 = inst_11497;
var tmp11631 = inst_11498;
var inst_11496__$1 = tmp11629;
var inst_11497__$1 = tmp11630;
var inst_11498__$1 = tmp11631;
var inst_11499__$1 = inst_11515;
var state_11617__$1 = (function (){var statearr_11636 = state_11617;
(statearr_11636[(13)] = inst_11496__$1);

(statearr_11636[(14)] = inst_11497__$1);

(statearr_11636[(15)] = inst_11499__$1);

(statearr_11636[(16)] = inst_11498__$1);

(statearr_11636[(18)] = inst_11514);

return statearr_11636;
})();
var statearr_11637_11712 = state_11617__$1;
(statearr_11637_11712[(2)] = null);

(statearr_11637_11712[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (21))){
var inst_11541 = (state_11617[(2)]);
var state_11617__$1 = state_11617;
var statearr_11641_11713 = state_11617__$1;
(statearr_11641_11713[(2)] = inst_11541);

(statearr_11641_11713[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (31))){
var inst_11567 = (state_11617[(12)]);
var inst_11571 = cljs.core.async.untap_STAR_.call(null,m,inst_11567);
var state_11617__$1 = state_11617;
var statearr_11642_11714 = state_11617__$1;
(statearr_11642_11714[(2)] = inst_11571);

(statearr_11642_11714[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (32))){
var inst_11561 = (state_11617[(19)]);
var inst_11560 = (state_11617[(10)]);
var inst_11562 = (state_11617[(11)]);
var inst_11559 = (state_11617[(20)]);
var inst_11573 = (state_11617[(2)]);
var inst_11574 = (inst_11562 + (1));
var tmp11638 = inst_11561;
var tmp11639 = inst_11560;
var tmp11640 = inst_11559;
var inst_11559__$1 = tmp11640;
var inst_11560__$1 = tmp11639;
var inst_11561__$1 = tmp11638;
var inst_11562__$1 = inst_11574;
var state_11617__$1 = (function (){var statearr_11643 = state_11617;
(statearr_11643[(19)] = inst_11561__$1);

(statearr_11643[(10)] = inst_11560__$1);

(statearr_11643[(11)] = inst_11562__$1);

(statearr_11643[(20)] = inst_11559__$1);

(statearr_11643[(21)] = inst_11573);

return statearr_11643;
})();
var statearr_11644_11715 = state_11617__$1;
(statearr_11644_11715[(2)] = null);

(statearr_11644_11715[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (40))){
var inst_11586 = (state_11617[(22)]);
var inst_11590 = cljs.core.async.untap_STAR_.call(null,m,inst_11586);
var state_11617__$1 = state_11617;
var statearr_11645_11716 = state_11617__$1;
(statearr_11645_11716[(2)] = inst_11590);

(statearr_11645_11716[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (33))){
var inst_11577 = (state_11617[(23)]);
var inst_11579 = cljs.core.chunked_seq_QMARK_.call(null,inst_11577);
var state_11617__$1 = state_11617;
if(inst_11579){
var statearr_11646_11717 = state_11617__$1;
(statearr_11646_11717[(1)] = (36));

} else {
var statearr_11647_11718 = state_11617__$1;
(statearr_11647_11718[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (13))){
var inst_11508 = (state_11617[(24)]);
var inst_11511 = cljs.core.async.close_BANG_.call(null,inst_11508);
var state_11617__$1 = state_11617;
var statearr_11648_11719 = state_11617__$1;
(statearr_11648_11719[(2)] = inst_11511);

(statearr_11648_11719[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (22))){
var inst_11531 = (state_11617[(8)]);
var inst_11534 = cljs.core.async.close_BANG_.call(null,inst_11531);
var state_11617__$1 = state_11617;
var statearr_11649_11720 = state_11617__$1;
(statearr_11649_11720[(2)] = inst_11534);

(statearr_11649_11720[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (36))){
var inst_11577 = (state_11617[(23)]);
var inst_11581 = cljs.core.chunk_first.call(null,inst_11577);
var inst_11582 = cljs.core.chunk_rest.call(null,inst_11577);
var inst_11583 = cljs.core.count.call(null,inst_11581);
var inst_11559 = inst_11582;
var inst_11560 = inst_11581;
var inst_11561 = inst_11583;
var inst_11562 = (0);
var state_11617__$1 = (function (){var statearr_11650 = state_11617;
(statearr_11650[(19)] = inst_11561);

(statearr_11650[(10)] = inst_11560);

(statearr_11650[(11)] = inst_11562);

(statearr_11650[(20)] = inst_11559);

return statearr_11650;
})();
var statearr_11651_11721 = state_11617__$1;
(statearr_11651_11721[(2)] = null);

(statearr_11651_11721[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (41))){
var inst_11577 = (state_11617[(23)]);
var inst_11592 = (state_11617[(2)]);
var inst_11593 = cljs.core.next.call(null,inst_11577);
var inst_11559 = inst_11593;
var inst_11560 = null;
var inst_11561 = (0);
var inst_11562 = (0);
var state_11617__$1 = (function (){var statearr_11652 = state_11617;
(statearr_11652[(19)] = inst_11561);

(statearr_11652[(10)] = inst_11560);

(statearr_11652[(25)] = inst_11592);

(statearr_11652[(11)] = inst_11562);

(statearr_11652[(20)] = inst_11559);

return statearr_11652;
})();
var statearr_11653_11722 = state_11617__$1;
(statearr_11653_11722[(2)] = null);

(statearr_11653_11722[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (43))){
var state_11617__$1 = state_11617;
var statearr_11654_11723 = state_11617__$1;
(statearr_11654_11723[(2)] = null);

(statearr_11654_11723[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (29))){
var inst_11601 = (state_11617[(2)]);
var state_11617__$1 = state_11617;
var statearr_11655_11724 = state_11617__$1;
(statearr_11655_11724[(2)] = inst_11601);

(statearr_11655_11724[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (44))){
var inst_11610 = (state_11617[(2)]);
var state_11617__$1 = (function (){var statearr_11656 = state_11617;
(statearr_11656[(26)] = inst_11610);

return statearr_11656;
})();
var statearr_11657_11725 = state_11617__$1;
(statearr_11657_11725[(2)] = null);

(statearr_11657_11725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (6))){
var inst_11551 = (state_11617[(27)]);
var inst_11550 = cljs.core.deref.call(null,cs);
var inst_11551__$1 = cljs.core.keys.call(null,inst_11550);
var inst_11552 = cljs.core.count.call(null,inst_11551__$1);
var inst_11553 = cljs.core.reset_BANG_.call(null,dctr,inst_11552);
var inst_11558 = cljs.core.seq.call(null,inst_11551__$1);
var inst_11559 = inst_11558;
var inst_11560 = null;
var inst_11561 = (0);
var inst_11562 = (0);
var state_11617__$1 = (function (){var statearr_11658 = state_11617;
(statearr_11658[(27)] = inst_11551__$1);

(statearr_11658[(19)] = inst_11561);

(statearr_11658[(10)] = inst_11560);

(statearr_11658[(11)] = inst_11562);

(statearr_11658[(20)] = inst_11559);

(statearr_11658[(28)] = inst_11553);

return statearr_11658;
})();
var statearr_11659_11726 = state_11617__$1;
(statearr_11659_11726[(2)] = null);

(statearr_11659_11726[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (28))){
var inst_11577 = (state_11617[(23)]);
var inst_11559 = (state_11617[(20)]);
var inst_11577__$1 = cljs.core.seq.call(null,inst_11559);
var state_11617__$1 = (function (){var statearr_11660 = state_11617;
(statearr_11660[(23)] = inst_11577__$1);

return statearr_11660;
})();
if(inst_11577__$1){
var statearr_11661_11727 = state_11617__$1;
(statearr_11661_11727[(1)] = (33));

} else {
var statearr_11662_11728 = state_11617__$1;
(statearr_11662_11728[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (25))){
var inst_11561 = (state_11617[(19)]);
var inst_11562 = (state_11617[(11)]);
var inst_11564 = (inst_11562 < inst_11561);
var inst_11565 = inst_11564;
var state_11617__$1 = state_11617;
if(cljs.core.truth_(inst_11565)){
var statearr_11663_11729 = state_11617__$1;
(statearr_11663_11729[(1)] = (27));

} else {
var statearr_11664_11730 = state_11617__$1;
(statearr_11664_11730[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (34))){
var state_11617__$1 = state_11617;
var statearr_11665_11731 = state_11617__$1;
(statearr_11665_11731[(2)] = null);

(statearr_11665_11731[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (17))){
var state_11617__$1 = state_11617;
var statearr_11666_11732 = state_11617__$1;
(statearr_11666_11732[(2)] = null);

(statearr_11666_11732[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (3))){
var inst_11615 = (state_11617[(2)]);
var state_11617__$1 = state_11617;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11617__$1,inst_11615);
} else {
if((state_val_11618 === (12))){
var inst_11546 = (state_11617[(2)]);
var state_11617__$1 = state_11617;
var statearr_11667_11733 = state_11617__$1;
(statearr_11667_11733[(2)] = inst_11546);

(statearr_11667_11733[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (2))){
var state_11617__$1 = state_11617;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11617__$1,(4),ch);
} else {
if((state_val_11618 === (23))){
var state_11617__$1 = state_11617;
var statearr_11668_11734 = state_11617__$1;
(statearr_11668_11734[(2)] = null);

(statearr_11668_11734[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (35))){
var inst_11599 = (state_11617[(2)]);
var state_11617__$1 = state_11617;
var statearr_11669_11735 = state_11617__$1;
(statearr_11669_11735[(2)] = inst_11599);

(statearr_11669_11735[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (19))){
var inst_11518 = (state_11617[(7)]);
var inst_11522 = cljs.core.chunk_first.call(null,inst_11518);
var inst_11523 = cljs.core.chunk_rest.call(null,inst_11518);
var inst_11524 = cljs.core.count.call(null,inst_11522);
var inst_11496 = inst_11523;
var inst_11497 = inst_11522;
var inst_11498 = inst_11524;
var inst_11499 = (0);
var state_11617__$1 = (function (){var statearr_11670 = state_11617;
(statearr_11670[(13)] = inst_11496);

(statearr_11670[(14)] = inst_11497);

(statearr_11670[(15)] = inst_11499);

(statearr_11670[(16)] = inst_11498);

return statearr_11670;
})();
var statearr_11671_11736 = state_11617__$1;
(statearr_11671_11736[(2)] = null);

(statearr_11671_11736[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (11))){
var inst_11496 = (state_11617[(13)]);
var inst_11518 = (state_11617[(7)]);
var inst_11518__$1 = cljs.core.seq.call(null,inst_11496);
var state_11617__$1 = (function (){var statearr_11672 = state_11617;
(statearr_11672[(7)] = inst_11518__$1);

return statearr_11672;
})();
if(inst_11518__$1){
var statearr_11673_11737 = state_11617__$1;
(statearr_11673_11737[(1)] = (16));

} else {
var statearr_11674_11738 = state_11617__$1;
(statearr_11674_11738[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (9))){
var inst_11548 = (state_11617[(2)]);
var state_11617__$1 = state_11617;
var statearr_11675_11739 = state_11617__$1;
(statearr_11675_11739[(2)] = inst_11548);

(statearr_11675_11739[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (5))){
var inst_11494 = cljs.core.deref.call(null,cs);
var inst_11495 = cljs.core.seq.call(null,inst_11494);
var inst_11496 = inst_11495;
var inst_11497 = null;
var inst_11498 = (0);
var inst_11499 = (0);
var state_11617__$1 = (function (){var statearr_11676 = state_11617;
(statearr_11676[(13)] = inst_11496);

(statearr_11676[(14)] = inst_11497);

(statearr_11676[(15)] = inst_11499);

(statearr_11676[(16)] = inst_11498);

return statearr_11676;
})();
var statearr_11677_11740 = state_11617__$1;
(statearr_11677_11740[(2)] = null);

(statearr_11677_11740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (14))){
var state_11617__$1 = state_11617;
var statearr_11678_11741 = state_11617__$1;
(statearr_11678_11741[(2)] = null);

(statearr_11678_11741[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (45))){
var inst_11607 = (state_11617[(2)]);
var state_11617__$1 = state_11617;
var statearr_11679_11742 = state_11617__$1;
(statearr_11679_11742[(2)] = inst_11607);

(statearr_11679_11742[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (26))){
var inst_11551 = (state_11617[(27)]);
var inst_11603 = (state_11617[(2)]);
var inst_11604 = cljs.core.seq.call(null,inst_11551);
var state_11617__$1 = (function (){var statearr_11680 = state_11617;
(statearr_11680[(29)] = inst_11603);

return statearr_11680;
})();
if(inst_11604){
var statearr_11681_11743 = state_11617__$1;
(statearr_11681_11743[(1)] = (42));

} else {
var statearr_11682_11744 = state_11617__$1;
(statearr_11682_11744[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (16))){
var inst_11518 = (state_11617[(7)]);
var inst_11520 = cljs.core.chunked_seq_QMARK_.call(null,inst_11518);
var state_11617__$1 = state_11617;
if(inst_11520){
var statearr_11683_11745 = state_11617__$1;
(statearr_11683_11745[(1)] = (19));

} else {
var statearr_11684_11746 = state_11617__$1;
(statearr_11684_11746[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (38))){
var inst_11596 = (state_11617[(2)]);
var state_11617__$1 = state_11617;
var statearr_11685_11747 = state_11617__$1;
(statearr_11685_11747[(2)] = inst_11596);

(statearr_11685_11747[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (30))){
var state_11617__$1 = state_11617;
var statearr_11686_11748 = state_11617__$1;
(statearr_11686_11748[(2)] = null);

(statearr_11686_11748[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (10))){
var inst_11497 = (state_11617[(14)]);
var inst_11499 = (state_11617[(15)]);
var inst_11507 = cljs.core._nth.call(null,inst_11497,inst_11499);
var inst_11508 = cljs.core.nth.call(null,inst_11507,(0),null);
var inst_11509 = cljs.core.nth.call(null,inst_11507,(1),null);
var state_11617__$1 = (function (){var statearr_11687 = state_11617;
(statearr_11687[(24)] = inst_11508);

return statearr_11687;
})();
if(cljs.core.truth_(inst_11509)){
var statearr_11688_11749 = state_11617__$1;
(statearr_11688_11749[(1)] = (13));

} else {
var statearr_11689_11750 = state_11617__$1;
(statearr_11689_11750[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (18))){
var inst_11544 = (state_11617[(2)]);
var state_11617__$1 = state_11617;
var statearr_11690_11751 = state_11617__$1;
(statearr_11690_11751[(2)] = inst_11544);

(statearr_11690_11751[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (42))){
var state_11617__$1 = state_11617;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11617__$1,(45),dchan);
} else {
if((state_val_11618 === (37))){
var inst_11586 = (state_11617[(22)]);
var inst_11577 = (state_11617[(23)]);
var inst_11487 = (state_11617[(9)]);
var inst_11586__$1 = cljs.core.first.call(null,inst_11577);
var inst_11587 = cljs.core.async.put_BANG_.call(null,inst_11586__$1,inst_11487,done);
var state_11617__$1 = (function (){var statearr_11691 = state_11617;
(statearr_11691[(22)] = inst_11586__$1);

return statearr_11691;
})();
if(cljs.core.truth_(inst_11587)){
var statearr_11692_11752 = state_11617__$1;
(statearr_11692_11752[(1)] = (39));

} else {
var statearr_11693_11753 = state_11617__$1;
(statearr_11693_11753[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11618 === (8))){
var inst_11499 = (state_11617[(15)]);
var inst_11498 = (state_11617[(16)]);
var inst_11501 = (inst_11499 < inst_11498);
var inst_11502 = inst_11501;
var state_11617__$1 = state_11617;
if(cljs.core.truth_(inst_11502)){
var statearr_11694_11754 = state_11617__$1;
(statearr_11694_11754[(1)] = (10));

} else {
var statearr_11695_11755 = state_11617__$1;
(statearr_11695_11755[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__10786__auto__ = null;
var cljs$core$async$mult_$_state_machine__10786__auto____0 = (function (){
var statearr_11696 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11696[(0)] = cljs$core$async$mult_$_state_machine__10786__auto__);

(statearr_11696[(1)] = (1));

return statearr_11696;
});
var cljs$core$async$mult_$_state_machine__10786__auto____1 = (function (state_11617){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_11617);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e11697){var ex__10789__auto__ = e11697;
var statearr_11698_11756 = state_11617;
(statearr_11698_11756[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_11617[(4)]))){
var statearr_11699_11757 = state_11617;
(statearr_11699_11757[(1)] = cljs.core.first.call(null,(state_11617[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11758 = state_11617;
state_11617 = G__11758;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10786__auto__ = function(state_11617){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10786__auto____1.call(this,state_11617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10786__auto____0;
cljs$core$async$mult_$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10786__auto____1;
return cljs$core$async$mult_$_state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_11700 = f__10860__auto__.call(null);
(statearr_11700[(6)] = c__10859__auto___11701);

return statearr_11700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__11760 = arguments.length;
switch (G__11760) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_11762 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m,ch);
} else {
var m__4519__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_11762.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_11763 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m,ch);
} else {
var m__4519__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_11763.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_11764 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m);
} else {
var m__4519__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_11764.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_11765 = (function (m,state_map){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m,state_map);
} else {
var m__4519__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_11765.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_11766 = (function (m,mode){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,m,mode);
} else {
var m__4519__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_11766.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___11776 = arguments.length;
var i__4830__auto___11777 = (0);
while(true){
if((i__4830__auto___11777 < len__4829__auto___11776)){
args__4835__auto__.push((arguments[i__4830__auto___11777]));

var G__11778 = (i__4830__auto___11777 + (1));
i__4830__auto___11777 = G__11778;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((3) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4836__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__11771){
var map__11772 = p__11771;
var map__11772__$1 = cljs.core.__destructure_map.call(null,map__11772);
var opts = map__11772__$1;
var statearr_11773_11779 = state;
(statearr_11773_11779[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_11774_11780 = state;
(statearr_11774_11780[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_11775_11781 = state;
(statearr_11775_11781[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq11767){
var G__11768 = cljs.core.first.call(null,seq11767);
var seq11767__$1 = cljs.core.next.call(null,seq11767);
var G__11769 = cljs.core.first.call(null,seq11767__$1);
var seq11767__$2 = cljs.core.next.call(null,seq11767__$1);
var G__11770 = cljs.core.first.call(null,seq11767__$2);
var seq11767__$3 = cljs.core.next.call(null,seq11767__$2);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11768,G__11769,G__11770,seq11767__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11782 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11782 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta11783){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta11783 = meta11783;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11782.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11784,meta11783__$1){
var self__ = this;
var _11784__$1 = this;
return (new cljs.core.async.t_cljs$core$async11782(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta11783__$1));
}));

(cljs.core.async.t_cljs$core$async11782.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11784){
var self__ = this;
var _11784__$1 = this;
return self__.meta11783;
}));

(cljs.core.async.t_cljs$core$async11782.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11782.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async11782.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11782.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11782.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11782.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11782.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11782.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11782.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta11783","meta11783",-84704816,null)], null);
}));

(cljs.core.async.t_cljs$core$async11782.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11782.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11782");

(cljs.core.async.t_cljs$core$async11782.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async11782");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11782.
 */
cljs.core.async.__GT_t_cljs$core$async11782 = (function cljs$core$async$mix_$___GT_t_cljs$core$async11782(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta11783){
return (new cljs.core.async.t_cljs$core$async11782(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta11783));
});

}

return (new cljs.core.async.t_cljs$core$async11782(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10859__auto___11897 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_11852){
var state_val_11853 = (state_11852[(1)]);
if((state_val_11853 === (7))){
var inst_11812 = (state_11852[(2)]);
var state_11852__$1 = state_11852;
if(cljs.core.truth_(inst_11812)){
var statearr_11854_11898 = state_11852__$1;
(statearr_11854_11898[(1)] = (8));

} else {
var statearr_11855_11899 = state_11852__$1;
(statearr_11855_11899[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (20))){
var inst_11805 = (state_11852[(7)]);
var state_11852__$1 = state_11852;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11852__$1,(23),out,inst_11805);
} else {
if((state_val_11853 === (1))){
var inst_11788 = calc_state.call(null);
var inst_11789 = cljs.core.__destructure_map.call(null,inst_11788);
var inst_11790 = cljs.core.get.call(null,inst_11789,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_11791 = cljs.core.get.call(null,inst_11789,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_11792 = cljs.core.get.call(null,inst_11789,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_11793 = inst_11788;
var state_11852__$1 = (function (){var statearr_11856 = state_11852;
(statearr_11856[(8)] = inst_11791);

(statearr_11856[(9)] = inst_11792);

(statearr_11856[(10)] = inst_11793);

(statearr_11856[(11)] = inst_11790);

return statearr_11856;
})();
var statearr_11857_11900 = state_11852__$1;
(statearr_11857_11900[(2)] = null);

(statearr_11857_11900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (24))){
var inst_11796 = (state_11852[(12)]);
var inst_11793 = inst_11796;
var state_11852__$1 = (function (){var statearr_11858 = state_11852;
(statearr_11858[(10)] = inst_11793);

return statearr_11858;
})();
var statearr_11859_11901 = state_11852__$1;
(statearr_11859_11901[(2)] = null);

(statearr_11859_11901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (4))){
var inst_11805 = (state_11852[(7)]);
var inst_11807 = (state_11852[(13)]);
var inst_11804 = (state_11852[(2)]);
var inst_11805__$1 = cljs.core.nth.call(null,inst_11804,(0),null);
var inst_11806 = cljs.core.nth.call(null,inst_11804,(1),null);
var inst_11807__$1 = (inst_11805__$1 == null);
var state_11852__$1 = (function (){var statearr_11860 = state_11852;
(statearr_11860[(14)] = inst_11806);

(statearr_11860[(7)] = inst_11805__$1);

(statearr_11860[(13)] = inst_11807__$1);

return statearr_11860;
})();
if(cljs.core.truth_(inst_11807__$1)){
var statearr_11861_11902 = state_11852__$1;
(statearr_11861_11902[(1)] = (5));

} else {
var statearr_11862_11903 = state_11852__$1;
(statearr_11862_11903[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (15))){
var inst_11797 = (state_11852[(15)]);
var inst_11826 = (state_11852[(16)]);
var inst_11826__$1 = cljs.core.empty_QMARK_.call(null,inst_11797);
var state_11852__$1 = (function (){var statearr_11863 = state_11852;
(statearr_11863[(16)] = inst_11826__$1);

return statearr_11863;
})();
if(inst_11826__$1){
var statearr_11864_11904 = state_11852__$1;
(statearr_11864_11904[(1)] = (17));

} else {
var statearr_11865_11905 = state_11852__$1;
(statearr_11865_11905[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (21))){
var inst_11796 = (state_11852[(12)]);
var inst_11793 = inst_11796;
var state_11852__$1 = (function (){var statearr_11866 = state_11852;
(statearr_11866[(10)] = inst_11793);

return statearr_11866;
})();
var statearr_11867_11906 = state_11852__$1;
(statearr_11867_11906[(2)] = null);

(statearr_11867_11906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (13))){
var inst_11819 = (state_11852[(2)]);
var inst_11820 = calc_state.call(null);
var inst_11793 = inst_11820;
var state_11852__$1 = (function (){var statearr_11868 = state_11852;
(statearr_11868[(17)] = inst_11819);

(statearr_11868[(10)] = inst_11793);

return statearr_11868;
})();
var statearr_11869_11907 = state_11852__$1;
(statearr_11869_11907[(2)] = null);

(statearr_11869_11907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (22))){
var inst_11846 = (state_11852[(2)]);
var state_11852__$1 = state_11852;
var statearr_11870_11908 = state_11852__$1;
(statearr_11870_11908[(2)] = inst_11846);

(statearr_11870_11908[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (6))){
var inst_11806 = (state_11852[(14)]);
var inst_11810 = cljs.core._EQ_.call(null,inst_11806,change);
var state_11852__$1 = state_11852;
var statearr_11871_11909 = state_11852__$1;
(statearr_11871_11909[(2)] = inst_11810);

(statearr_11871_11909[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (25))){
var state_11852__$1 = state_11852;
var statearr_11872_11910 = state_11852__$1;
(statearr_11872_11910[(2)] = null);

(statearr_11872_11910[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (17))){
var inst_11806 = (state_11852[(14)]);
var inst_11798 = (state_11852[(18)]);
var inst_11828 = inst_11798.call(null,inst_11806);
var inst_11829 = cljs.core.not.call(null,inst_11828);
var state_11852__$1 = state_11852;
var statearr_11873_11911 = state_11852__$1;
(statearr_11873_11911[(2)] = inst_11829);

(statearr_11873_11911[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (3))){
var inst_11850 = (state_11852[(2)]);
var state_11852__$1 = state_11852;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11852__$1,inst_11850);
} else {
if((state_val_11853 === (12))){
var state_11852__$1 = state_11852;
var statearr_11874_11912 = state_11852__$1;
(statearr_11874_11912[(2)] = null);

(statearr_11874_11912[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (2))){
var inst_11796 = (state_11852[(12)]);
var inst_11793 = (state_11852[(10)]);
var inst_11796__$1 = cljs.core.__destructure_map.call(null,inst_11793);
var inst_11797 = cljs.core.get.call(null,inst_11796__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_11798 = cljs.core.get.call(null,inst_11796__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_11799 = cljs.core.get.call(null,inst_11796__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_11852__$1 = (function (){var statearr_11875 = state_11852;
(statearr_11875[(15)] = inst_11797);

(statearr_11875[(12)] = inst_11796__$1);

(statearr_11875[(18)] = inst_11798);

return statearr_11875;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_11852__$1,(4),inst_11799);
} else {
if((state_val_11853 === (23))){
var inst_11837 = (state_11852[(2)]);
var state_11852__$1 = state_11852;
if(cljs.core.truth_(inst_11837)){
var statearr_11876_11913 = state_11852__$1;
(statearr_11876_11913[(1)] = (24));

} else {
var statearr_11877_11914 = state_11852__$1;
(statearr_11877_11914[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (19))){
var inst_11832 = (state_11852[(2)]);
var state_11852__$1 = state_11852;
var statearr_11878_11915 = state_11852__$1;
(statearr_11878_11915[(2)] = inst_11832);

(statearr_11878_11915[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (11))){
var inst_11806 = (state_11852[(14)]);
var inst_11816 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_11806);
var state_11852__$1 = state_11852;
var statearr_11879_11916 = state_11852__$1;
(statearr_11879_11916[(2)] = inst_11816);

(statearr_11879_11916[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (9))){
var inst_11806 = (state_11852[(14)]);
var inst_11797 = (state_11852[(15)]);
var inst_11823 = (state_11852[(19)]);
var inst_11823__$1 = inst_11797.call(null,inst_11806);
var state_11852__$1 = (function (){var statearr_11880 = state_11852;
(statearr_11880[(19)] = inst_11823__$1);

return statearr_11880;
})();
if(cljs.core.truth_(inst_11823__$1)){
var statearr_11881_11917 = state_11852__$1;
(statearr_11881_11917[(1)] = (14));

} else {
var statearr_11882_11918 = state_11852__$1;
(statearr_11882_11918[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (5))){
var inst_11807 = (state_11852[(13)]);
var state_11852__$1 = state_11852;
var statearr_11883_11919 = state_11852__$1;
(statearr_11883_11919[(2)] = inst_11807);

(statearr_11883_11919[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (14))){
var inst_11823 = (state_11852[(19)]);
var state_11852__$1 = state_11852;
var statearr_11884_11920 = state_11852__$1;
(statearr_11884_11920[(2)] = inst_11823);

(statearr_11884_11920[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (26))){
var inst_11842 = (state_11852[(2)]);
var state_11852__$1 = state_11852;
var statearr_11885_11921 = state_11852__$1;
(statearr_11885_11921[(2)] = inst_11842);

(statearr_11885_11921[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (16))){
var inst_11834 = (state_11852[(2)]);
var state_11852__$1 = state_11852;
if(cljs.core.truth_(inst_11834)){
var statearr_11886_11922 = state_11852__$1;
(statearr_11886_11922[(1)] = (20));

} else {
var statearr_11887_11923 = state_11852__$1;
(statearr_11887_11923[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (10))){
var inst_11848 = (state_11852[(2)]);
var state_11852__$1 = state_11852;
var statearr_11888_11924 = state_11852__$1;
(statearr_11888_11924[(2)] = inst_11848);

(statearr_11888_11924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (18))){
var inst_11826 = (state_11852[(16)]);
var state_11852__$1 = state_11852;
var statearr_11889_11925 = state_11852__$1;
(statearr_11889_11925[(2)] = inst_11826);

(statearr_11889_11925[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11853 === (8))){
var inst_11805 = (state_11852[(7)]);
var inst_11814 = (inst_11805 == null);
var state_11852__$1 = state_11852;
if(cljs.core.truth_(inst_11814)){
var statearr_11890_11926 = state_11852__$1;
(statearr_11890_11926[(1)] = (11));

} else {
var statearr_11891_11927 = state_11852__$1;
(statearr_11891_11927[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__10786__auto__ = null;
var cljs$core$async$mix_$_state_machine__10786__auto____0 = (function (){
var statearr_11892 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11892[(0)] = cljs$core$async$mix_$_state_machine__10786__auto__);

(statearr_11892[(1)] = (1));

return statearr_11892;
});
var cljs$core$async$mix_$_state_machine__10786__auto____1 = (function (state_11852){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_11852);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e11893){var ex__10789__auto__ = e11893;
var statearr_11894_11928 = state_11852;
(statearr_11894_11928[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_11852[(4)]))){
var statearr_11895_11929 = state_11852;
(statearr_11895_11929[(1)] = cljs.core.first.call(null,(state_11852[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11930 = state_11852;
state_11852 = G__11930;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10786__auto__ = function(state_11852){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10786__auto____1.call(this,state_11852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10786__auto____0;
cljs$core$async$mix_$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10786__auto____1;
return cljs$core$async$mix_$_state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_11896 = f__10860__auto__.call(null);
(statearr_11896[(6)] = c__10859__auto___11897);

return statearr_11896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_11933 = (function (p,v,ch,close_QMARK_){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4519__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_11933.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_11934 = (function (p,v,ch){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,p,v,ch);
} else {
var m__4519__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_11934.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_11935 = (function() {
var G__11936 = null;
var G__11936__1 = (function (p){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,p);
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__11936__2 = (function (p,v){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return m__4522__auto__.call(null,p,v);
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return m__4519__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__11936 = function(p,v){
switch(arguments.length){
case 1:
return G__11936__1.call(this,p);
case 2:
return G__11936__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11936.cljs$core$IFn$_invoke$arity$1 = G__11936__1;
G__11936.cljs$core$IFn$_invoke$arity$2 = G__11936__2;
return G__11936;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__11932 = arguments.length;
switch (G__11932) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_11935.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_11935.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__11940 = arguments.length;
switch (G__11940) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4223__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__11938_SHARP_){
if(cljs.core.truth_(p1__11938_SHARP_.call(null,topic))){
return p1__11938_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__11938_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11941 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11941 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta11942){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta11942 = meta11942;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11943,meta11942__$1){
var self__ = this;
var _11943__$1 = this;
return (new cljs.core.async.t_cljs$core$async11941(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta11942__$1));
}));

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11943){
var self__ = this;
var _11943__$1 = this;
return self__.meta11942;
}));

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async11941.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async11941.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta11942","meta11942",1620681456,null)], null);
}));

(cljs.core.async.t_cljs$core$async11941.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11941.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11941");

(cljs.core.async.t_cljs$core$async11941.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async11941");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11941.
 */
cljs.core.async.__GT_t_cljs$core$async11941 = (function cljs$core$async$__GT_t_cljs$core$async11941(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta11942){
return (new cljs.core.async.t_cljs$core$async11941(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta11942));
});

}

return (new cljs.core.async.t_cljs$core$async11941(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10859__auto___12062 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_12015){
var state_val_12016 = (state_12015[(1)]);
if((state_val_12016 === (7))){
var inst_12011 = (state_12015[(2)]);
var state_12015__$1 = state_12015;
var statearr_12017_12063 = state_12015__$1;
(statearr_12017_12063[(2)] = inst_12011);

(statearr_12017_12063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (20))){
var state_12015__$1 = state_12015;
var statearr_12018_12064 = state_12015__$1;
(statearr_12018_12064[(2)] = null);

(statearr_12018_12064[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (1))){
var state_12015__$1 = state_12015;
var statearr_12019_12065 = state_12015__$1;
(statearr_12019_12065[(2)] = null);

(statearr_12019_12065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (24))){
var inst_11994 = (state_12015[(7)]);
var inst_12003 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_11994);
var state_12015__$1 = state_12015;
var statearr_12020_12066 = state_12015__$1;
(statearr_12020_12066[(2)] = inst_12003);

(statearr_12020_12066[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (4))){
var inst_11946 = (state_12015[(8)]);
var inst_11946__$1 = (state_12015[(2)]);
var inst_11947 = (inst_11946__$1 == null);
var state_12015__$1 = (function (){var statearr_12021 = state_12015;
(statearr_12021[(8)] = inst_11946__$1);

return statearr_12021;
})();
if(cljs.core.truth_(inst_11947)){
var statearr_12022_12067 = state_12015__$1;
(statearr_12022_12067[(1)] = (5));

} else {
var statearr_12023_12068 = state_12015__$1;
(statearr_12023_12068[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (15))){
var inst_11988 = (state_12015[(2)]);
var state_12015__$1 = state_12015;
var statearr_12024_12069 = state_12015__$1;
(statearr_12024_12069[(2)] = inst_11988);

(statearr_12024_12069[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (21))){
var inst_12008 = (state_12015[(2)]);
var state_12015__$1 = (function (){var statearr_12025 = state_12015;
(statearr_12025[(9)] = inst_12008);

return statearr_12025;
})();
var statearr_12026_12070 = state_12015__$1;
(statearr_12026_12070[(2)] = null);

(statearr_12026_12070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (13))){
var inst_11970 = (state_12015[(10)]);
var inst_11972 = cljs.core.chunked_seq_QMARK_.call(null,inst_11970);
var state_12015__$1 = state_12015;
if(inst_11972){
var statearr_12027_12071 = state_12015__$1;
(statearr_12027_12071[(1)] = (16));

} else {
var statearr_12028_12072 = state_12015__$1;
(statearr_12028_12072[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (22))){
var inst_12000 = (state_12015[(2)]);
var state_12015__$1 = state_12015;
if(cljs.core.truth_(inst_12000)){
var statearr_12029_12073 = state_12015__$1;
(statearr_12029_12073[(1)] = (23));

} else {
var statearr_12030_12074 = state_12015__$1;
(statearr_12030_12074[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (6))){
var inst_11946 = (state_12015[(8)]);
var inst_11996 = (state_12015[(11)]);
var inst_11994 = (state_12015[(7)]);
var inst_11994__$1 = topic_fn.call(null,inst_11946);
var inst_11995 = cljs.core.deref.call(null,mults);
var inst_11996__$1 = cljs.core.get.call(null,inst_11995,inst_11994__$1);
var state_12015__$1 = (function (){var statearr_12031 = state_12015;
(statearr_12031[(11)] = inst_11996__$1);

(statearr_12031[(7)] = inst_11994__$1);

return statearr_12031;
})();
if(cljs.core.truth_(inst_11996__$1)){
var statearr_12032_12075 = state_12015__$1;
(statearr_12032_12075[(1)] = (19));

} else {
var statearr_12033_12076 = state_12015__$1;
(statearr_12033_12076[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (25))){
var inst_12005 = (state_12015[(2)]);
var state_12015__$1 = state_12015;
var statearr_12034_12077 = state_12015__$1;
(statearr_12034_12077[(2)] = inst_12005);

(statearr_12034_12077[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (17))){
var inst_11970 = (state_12015[(10)]);
var inst_11979 = cljs.core.first.call(null,inst_11970);
var inst_11980 = cljs.core.async.muxch_STAR_.call(null,inst_11979);
var inst_11981 = cljs.core.async.close_BANG_.call(null,inst_11980);
var inst_11982 = cljs.core.next.call(null,inst_11970);
var inst_11956 = inst_11982;
var inst_11957 = null;
var inst_11958 = (0);
var inst_11959 = (0);
var state_12015__$1 = (function (){var statearr_12035 = state_12015;
(statearr_12035[(12)] = inst_11957);

(statearr_12035[(13)] = inst_11981);

(statearr_12035[(14)] = inst_11959);

(statearr_12035[(15)] = inst_11956);

(statearr_12035[(16)] = inst_11958);

return statearr_12035;
})();
var statearr_12036_12078 = state_12015__$1;
(statearr_12036_12078[(2)] = null);

(statearr_12036_12078[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (3))){
var inst_12013 = (state_12015[(2)]);
var state_12015__$1 = state_12015;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12015__$1,inst_12013);
} else {
if((state_val_12016 === (12))){
var inst_11990 = (state_12015[(2)]);
var state_12015__$1 = state_12015;
var statearr_12037_12079 = state_12015__$1;
(statearr_12037_12079[(2)] = inst_11990);

(statearr_12037_12079[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (2))){
var state_12015__$1 = state_12015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12015__$1,(4),ch);
} else {
if((state_val_12016 === (23))){
var state_12015__$1 = state_12015;
var statearr_12038_12080 = state_12015__$1;
(statearr_12038_12080[(2)] = null);

(statearr_12038_12080[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (19))){
var inst_11946 = (state_12015[(8)]);
var inst_11996 = (state_12015[(11)]);
var inst_11998 = cljs.core.async.muxch_STAR_.call(null,inst_11996);
var state_12015__$1 = state_12015;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12015__$1,(22),inst_11998,inst_11946);
} else {
if((state_val_12016 === (11))){
var inst_11970 = (state_12015[(10)]);
var inst_11956 = (state_12015[(15)]);
var inst_11970__$1 = cljs.core.seq.call(null,inst_11956);
var state_12015__$1 = (function (){var statearr_12039 = state_12015;
(statearr_12039[(10)] = inst_11970__$1);

return statearr_12039;
})();
if(inst_11970__$1){
var statearr_12040_12081 = state_12015__$1;
(statearr_12040_12081[(1)] = (13));

} else {
var statearr_12041_12082 = state_12015__$1;
(statearr_12041_12082[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (9))){
var inst_11992 = (state_12015[(2)]);
var state_12015__$1 = state_12015;
var statearr_12042_12083 = state_12015__$1;
(statearr_12042_12083[(2)] = inst_11992);

(statearr_12042_12083[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (5))){
var inst_11953 = cljs.core.deref.call(null,mults);
var inst_11954 = cljs.core.vals.call(null,inst_11953);
var inst_11955 = cljs.core.seq.call(null,inst_11954);
var inst_11956 = inst_11955;
var inst_11957 = null;
var inst_11958 = (0);
var inst_11959 = (0);
var state_12015__$1 = (function (){var statearr_12043 = state_12015;
(statearr_12043[(12)] = inst_11957);

(statearr_12043[(14)] = inst_11959);

(statearr_12043[(15)] = inst_11956);

(statearr_12043[(16)] = inst_11958);

return statearr_12043;
})();
var statearr_12044_12084 = state_12015__$1;
(statearr_12044_12084[(2)] = null);

(statearr_12044_12084[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (14))){
var state_12015__$1 = state_12015;
var statearr_12048_12085 = state_12015__$1;
(statearr_12048_12085[(2)] = null);

(statearr_12048_12085[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (16))){
var inst_11970 = (state_12015[(10)]);
var inst_11974 = cljs.core.chunk_first.call(null,inst_11970);
var inst_11975 = cljs.core.chunk_rest.call(null,inst_11970);
var inst_11976 = cljs.core.count.call(null,inst_11974);
var inst_11956 = inst_11975;
var inst_11957 = inst_11974;
var inst_11958 = inst_11976;
var inst_11959 = (0);
var state_12015__$1 = (function (){var statearr_12049 = state_12015;
(statearr_12049[(12)] = inst_11957);

(statearr_12049[(14)] = inst_11959);

(statearr_12049[(15)] = inst_11956);

(statearr_12049[(16)] = inst_11958);

return statearr_12049;
})();
var statearr_12050_12086 = state_12015__$1;
(statearr_12050_12086[(2)] = null);

(statearr_12050_12086[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (10))){
var inst_11957 = (state_12015[(12)]);
var inst_11959 = (state_12015[(14)]);
var inst_11956 = (state_12015[(15)]);
var inst_11958 = (state_12015[(16)]);
var inst_11964 = cljs.core._nth.call(null,inst_11957,inst_11959);
var inst_11965 = cljs.core.async.muxch_STAR_.call(null,inst_11964);
var inst_11966 = cljs.core.async.close_BANG_.call(null,inst_11965);
var inst_11967 = (inst_11959 + (1));
var tmp12045 = inst_11957;
var tmp12046 = inst_11956;
var tmp12047 = inst_11958;
var inst_11956__$1 = tmp12046;
var inst_11957__$1 = tmp12045;
var inst_11958__$1 = tmp12047;
var inst_11959__$1 = inst_11967;
var state_12015__$1 = (function (){var statearr_12051 = state_12015;
(statearr_12051[(12)] = inst_11957__$1);

(statearr_12051[(17)] = inst_11966);

(statearr_12051[(14)] = inst_11959__$1);

(statearr_12051[(15)] = inst_11956__$1);

(statearr_12051[(16)] = inst_11958__$1);

return statearr_12051;
})();
var statearr_12052_12087 = state_12015__$1;
(statearr_12052_12087[(2)] = null);

(statearr_12052_12087[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (18))){
var inst_11985 = (state_12015[(2)]);
var state_12015__$1 = state_12015;
var statearr_12053_12088 = state_12015__$1;
(statearr_12053_12088[(2)] = inst_11985);

(statearr_12053_12088[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12016 === (8))){
var inst_11959 = (state_12015[(14)]);
var inst_11958 = (state_12015[(16)]);
var inst_11961 = (inst_11959 < inst_11958);
var inst_11962 = inst_11961;
var state_12015__$1 = state_12015;
if(cljs.core.truth_(inst_11962)){
var statearr_12054_12089 = state_12015__$1;
(statearr_12054_12089[(1)] = (10));

} else {
var statearr_12055_12090 = state_12015__$1;
(statearr_12055_12090[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10786__auto__ = null;
var cljs$core$async$state_machine__10786__auto____0 = (function (){
var statearr_12056 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12056[(0)] = cljs$core$async$state_machine__10786__auto__);

(statearr_12056[(1)] = (1));

return statearr_12056;
});
var cljs$core$async$state_machine__10786__auto____1 = (function (state_12015){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_12015);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e12057){var ex__10789__auto__ = e12057;
var statearr_12058_12091 = state_12015;
(statearr_12058_12091[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_12015[(4)]))){
var statearr_12059_12092 = state_12015;
(statearr_12059_12092[(1)] = cljs.core.first.call(null,(state_12015[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12093 = state_12015;
state_12015 = G__12093;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$state_machine__10786__auto__ = function(state_12015){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10786__auto____1.call(this,state_12015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10786__auto____0;
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10786__auto____1;
return cljs$core$async$state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_12060 = f__10860__auto__.call(null);
(statearr_12060[(6)] = c__10859__auto___12062);

return statearr_12060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__12095 = arguments.length;
switch (G__12095) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__12098 = arguments.length;
switch (G__12098) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__12101 = arguments.length;
switch (G__12101) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__10859__auto___12179 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_12144){
var state_val_12145 = (state_12144[(1)]);
if((state_val_12145 === (7))){
var state_12144__$1 = state_12144;
var statearr_12146_12180 = state_12144__$1;
(statearr_12146_12180[(2)] = null);

(statearr_12146_12180[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (1))){
var state_12144__$1 = state_12144;
var statearr_12147_12181 = state_12144__$1;
(statearr_12147_12181[(2)] = null);

(statearr_12147_12181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (4))){
var inst_12105 = (state_12144[(7)]);
var inst_12104 = (state_12144[(8)]);
var inst_12107 = (inst_12105 < inst_12104);
var state_12144__$1 = state_12144;
if(cljs.core.truth_(inst_12107)){
var statearr_12148_12182 = state_12144__$1;
(statearr_12148_12182[(1)] = (6));

} else {
var statearr_12149_12183 = state_12144__$1;
(statearr_12149_12183[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (15))){
var inst_12130 = (state_12144[(9)]);
var inst_12135 = cljs.core.apply.call(null,f,inst_12130);
var state_12144__$1 = state_12144;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12144__$1,(17),out,inst_12135);
} else {
if((state_val_12145 === (13))){
var inst_12130 = (state_12144[(9)]);
var inst_12130__$1 = (state_12144[(2)]);
var inst_12131 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12130__$1);
var state_12144__$1 = (function (){var statearr_12150 = state_12144;
(statearr_12150[(9)] = inst_12130__$1);

return statearr_12150;
})();
if(cljs.core.truth_(inst_12131)){
var statearr_12151_12184 = state_12144__$1;
(statearr_12151_12184[(1)] = (14));

} else {
var statearr_12152_12185 = state_12144__$1;
(statearr_12152_12185[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (6))){
var state_12144__$1 = state_12144;
var statearr_12153_12186 = state_12144__$1;
(statearr_12153_12186[(2)] = null);

(statearr_12153_12186[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (17))){
var inst_12137 = (state_12144[(2)]);
var state_12144__$1 = (function (){var statearr_12155 = state_12144;
(statearr_12155[(10)] = inst_12137);

return statearr_12155;
})();
var statearr_12156_12187 = state_12144__$1;
(statearr_12156_12187[(2)] = null);

(statearr_12156_12187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (3))){
var inst_12142 = (state_12144[(2)]);
var state_12144__$1 = state_12144;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12144__$1,inst_12142);
} else {
if((state_val_12145 === (12))){
var _ = (function (){var statearr_12157 = state_12144;
(statearr_12157[(4)] = cljs.core.rest.call(null,(state_12144[(4)])));

return statearr_12157;
})();
var state_12144__$1 = state_12144;
var ex12154 = (state_12144__$1[(2)]);
var statearr_12158_12188 = state_12144__$1;
(statearr_12158_12188[(5)] = ex12154);


if((ex12154 instanceof Object)){
var statearr_12159_12189 = state_12144__$1;
(statearr_12159_12189[(1)] = (11));

(statearr_12159_12189[(5)] = null);

} else {
throw ex12154;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (2))){
var inst_12103 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_12104 = cnt;
var inst_12105 = (0);
var state_12144__$1 = (function (){var statearr_12160 = state_12144;
(statearr_12160[(11)] = inst_12103);

(statearr_12160[(7)] = inst_12105);

(statearr_12160[(8)] = inst_12104);

return statearr_12160;
})();
var statearr_12161_12190 = state_12144__$1;
(statearr_12161_12190[(2)] = null);

(statearr_12161_12190[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (11))){
var inst_12109 = (state_12144[(2)]);
var inst_12110 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_12144__$1 = (function (){var statearr_12162 = state_12144;
(statearr_12162[(12)] = inst_12109);

return statearr_12162;
})();
var statearr_12163_12191 = state_12144__$1;
(statearr_12163_12191[(2)] = inst_12110);

(statearr_12163_12191[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (9))){
var inst_12105 = (state_12144[(7)]);
var _ = (function (){var statearr_12164 = state_12144;
(statearr_12164[(4)] = cljs.core.cons.call(null,(12),(state_12144[(4)])));

return statearr_12164;
})();
var inst_12116 = chs__$1.call(null,inst_12105);
var inst_12117 = done.call(null,inst_12105);
var inst_12118 = cljs.core.async.take_BANG_.call(null,inst_12116,inst_12117);
var ___$1 = (function (){var statearr_12165 = state_12144;
(statearr_12165[(4)] = cljs.core.rest.call(null,(state_12144[(4)])));

return statearr_12165;
})();
var state_12144__$1 = state_12144;
var statearr_12166_12192 = state_12144__$1;
(statearr_12166_12192[(2)] = inst_12118);

(statearr_12166_12192[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (5))){
var inst_12128 = (state_12144[(2)]);
var state_12144__$1 = (function (){var statearr_12167 = state_12144;
(statearr_12167[(13)] = inst_12128);

return statearr_12167;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12144__$1,(13),dchan);
} else {
if((state_val_12145 === (14))){
var inst_12133 = cljs.core.async.close_BANG_.call(null,out);
var state_12144__$1 = state_12144;
var statearr_12168_12193 = state_12144__$1;
(statearr_12168_12193[(2)] = inst_12133);

(statearr_12168_12193[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (16))){
var inst_12140 = (state_12144[(2)]);
var state_12144__$1 = state_12144;
var statearr_12169_12194 = state_12144__$1;
(statearr_12169_12194[(2)] = inst_12140);

(statearr_12169_12194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (10))){
var inst_12105 = (state_12144[(7)]);
var inst_12121 = (state_12144[(2)]);
var inst_12122 = (inst_12105 + (1));
var inst_12105__$1 = inst_12122;
var state_12144__$1 = (function (){var statearr_12170 = state_12144;
(statearr_12170[(14)] = inst_12121);

(statearr_12170[(7)] = inst_12105__$1);

return statearr_12170;
})();
var statearr_12171_12195 = state_12144__$1;
(statearr_12171_12195[(2)] = null);

(statearr_12171_12195[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (8))){
var inst_12126 = (state_12144[(2)]);
var state_12144__$1 = state_12144;
var statearr_12172_12196 = state_12144__$1;
(statearr_12172_12196[(2)] = inst_12126);

(statearr_12172_12196[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10786__auto__ = null;
var cljs$core$async$state_machine__10786__auto____0 = (function (){
var statearr_12173 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12173[(0)] = cljs$core$async$state_machine__10786__auto__);

(statearr_12173[(1)] = (1));

return statearr_12173;
});
var cljs$core$async$state_machine__10786__auto____1 = (function (state_12144){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_12144);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e12174){var ex__10789__auto__ = e12174;
var statearr_12175_12197 = state_12144;
(statearr_12175_12197[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_12144[(4)]))){
var statearr_12176_12198 = state_12144;
(statearr_12176_12198[(1)] = cljs.core.first.call(null,(state_12144[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12199 = state_12144;
state_12144 = G__12199;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$state_machine__10786__auto__ = function(state_12144){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10786__auto____1.call(this,state_12144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10786__auto____0;
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10786__auto____1;
return cljs$core$async$state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_12177 = f__10860__auto__.call(null);
(statearr_12177[(6)] = c__10859__auto___12179);

return statearr_12177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__12202 = arguments.length;
switch (G__12202) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10859__auto___12257 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_12234){
var state_val_12235 = (state_12234[(1)]);
if((state_val_12235 === (7))){
var inst_12214 = (state_12234[(7)]);
var inst_12213 = (state_12234[(8)]);
var inst_12213__$1 = (state_12234[(2)]);
var inst_12214__$1 = cljs.core.nth.call(null,inst_12213__$1,(0),null);
var inst_12215 = cljs.core.nth.call(null,inst_12213__$1,(1),null);
var inst_12216 = (inst_12214__$1 == null);
var state_12234__$1 = (function (){var statearr_12236 = state_12234;
(statearr_12236[(7)] = inst_12214__$1);

(statearr_12236[(9)] = inst_12215);

(statearr_12236[(8)] = inst_12213__$1);

return statearr_12236;
})();
if(cljs.core.truth_(inst_12216)){
var statearr_12237_12258 = state_12234__$1;
(statearr_12237_12258[(1)] = (8));

} else {
var statearr_12238_12259 = state_12234__$1;
(statearr_12238_12259[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12235 === (1))){
var inst_12203 = cljs.core.vec.call(null,chs);
var inst_12204 = inst_12203;
var state_12234__$1 = (function (){var statearr_12239 = state_12234;
(statearr_12239[(10)] = inst_12204);

return statearr_12239;
})();
var statearr_12240_12260 = state_12234__$1;
(statearr_12240_12260[(2)] = null);

(statearr_12240_12260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12235 === (4))){
var inst_12204 = (state_12234[(10)]);
var state_12234__$1 = state_12234;
return cljs.core.async.ioc_alts_BANG_.call(null,state_12234__$1,(7),inst_12204);
} else {
if((state_val_12235 === (6))){
var inst_12230 = (state_12234[(2)]);
var state_12234__$1 = state_12234;
var statearr_12241_12261 = state_12234__$1;
(statearr_12241_12261[(2)] = inst_12230);

(statearr_12241_12261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12235 === (3))){
var inst_12232 = (state_12234[(2)]);
var state_12234__$1 = state_12234;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12234__$1,inst_12232);
} else {
if((state_val_12235 === (2))){
var inst_12204 = (state_12234[(10)]);
var inst_12206 = cljs.core.count.call(null,inst_12204);
var inst_12207 = (inst_12206 > (0));
var state_12234__$1 = state_12234;
if(cljs.core.truth_(inst_12207)){
var statearr_12243_12262 = state_12234__$1;
(statearr_12243_12262[(1)] = (4));

} else {
var statearr_12244_12263 = state_12234__$1;
(statearr_12244_12263[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12235 === (11))){
var inst_12204 = (state_12234[(10)]);
var inst_12223 = (state_12234[(2)]);
var tmp12242 = inst_12204;
var inst_12204__$1 = tmp12242;
var state_12234__$1 = (function (){var statearr_12245 = state_12234;
(statearr_12245[(10)] = inst_12204__$1);

(statearr_12245[(11)] = inst_12223);

return statearr_12245;
})();
var statearr_12246_12264 = state_12234__$1;
(statearr_12246_12264[(2)] = null);

(statearr_12246_12264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12235 === (9))){
var inst_12214 = (state_12234[(7)]);
var state_12234__$1 = state_12234;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12234__$1,(11),out,inst_12214);
} else {
if((state_val_12235 === (5))){
var inst_12228 = cljs.core.async.close_BANG_.call(null,out);
var state_12234__$1 = state_12234;
var statearr_12247_12265 = state_12234__$1;
(statearr_12247_12265[(2)] = inst_12228);

(statearr_12247_12265[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12235 === (10))){
var inst_12226 = (state_12234[(2)]);
var state_12234__$1 = state_12234;
var statearr_12248_12266 = state_12234__$1;
(statearr_12248_12266[(2)] = inst_12226);

(statearr_12248_12266[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12235 === (8))){
var inst_12204 = (state_12234[(10)]);
var inst_12214 = (state_12234[(7)]);
var inst_12215 = (state_12234[(9)]);
var inst_12213 = (state_12234[(8)]);
var inst_12218 = (function (){var cs = inst_12204;
var vec__12209 = inst_12213;
var v = inst_12214;
var c = inst_12215;
return (function (p1__12200_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__12200_SHARP_);
});
})();
var inst_12219 = cljs.core.filterv.call(null,inst_12218,inst_12204);
var inst_12204__$1 = inst_12219;
var state_12234__$1 = (function (){var statearr_12249 = state_12234;
(statearr_12249[(10)] = inst_12204__$1);

return statearr_12249;
})();
var statearr_12250_12267 = state_12234__$1;
(statearr_12250_12267[(2)] = null);

(statearr_12250_12267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10786__auto__ = null;
var cljs$core$async$state_machine__10786__auto____0 = (function (){
var statearr_12251 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12251[(0)] = cljs$core$async$state_machine__10786__auto__);

(statearr_12251[(1)] = (1));

return statearr_12251;
});
var cljs$core$async$state_machine__10786__auto____1 = (function (state_12234){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_12234);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e12252){var ex__10789__auto__ = e12252;
var statearr_12253_12268 = state_12234;
(statearr_12253_12268[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_12234[(4)]))){
var statearr_12254_12269 = state_12234;
(statearr_12254_12269[(1)] = cljs.core.first.call(null,(state_12234[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12270 = state_12234;
state_12234 = G__12270;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$state_machine__10786__auto__ = function(state_12234){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10786__auto____1.call(this,state_12234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10786__auto____0;
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10786__auto____1;
return cljs$core$async$state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_12255 = f__10860__auto__.call(null);
(statearr_12255[(6)] = c__10859__auto___12257);

return statearr_12255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__12272 = arguments.length;
switch (G__12272) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10859__auto___12318 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_12296){
var state_val_12297 = (state_12296[(1)]);
if((state_val_12297 === (7))){
var inst_12278 = (state_12296[(7)]);
var inst_12278__$1 = (state_12296[(2)]);
var inst_12279 = (inst_12278__$1 == null);
var inst_12280 = cljs.core.not.call(null,inst_12279);
var state_12296__$1 = (function (){var statearr_12298 = state_12296;
(statearr_12298[(7)] = inst_12278__$1);

return statearr_12298;
})();
if(inst_12280){
var statearr_12299_12319 = state_12296__$1;
(statearr_12299_12319[(1)] = (8));

} else {
var statearr_12300_12320 = state_12296__$1;
(statearr_12300_12320[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (1))){
var inst_12273 = (0);
var state_12296__$1 = (function (){var statearr_12301 = state_12296;
(statearr_12301[(8)] = inst_12273);

return statearr_12301;
})();
var statearr_12302_12321 = state_12296__$1;
(statearr_12302_12321[(2)] = null);

(statearr_12302_12321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (4))){
var state_12296__$1 = state_12296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12296__$1,(7),ch);
} else {
if((state_val_12297 === (6))){
var inst_12291 = (state_12296[(2)]);
var state_12296__$1 = state_12296;
var statearr_12303_12322 = state_12296__$1;
(statearr_12303_12322[(2)] = inst_12291);

(statearr_12303_12322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (3))){
var inst_12293 = (state_12296[(2)]);
var inst_12294 = cljs.core.async.close_BANG_.call(null,out);
var state_12296__$1 = (function (){var statearr_12304 = state_12296;
(statearr_12304[(9)] = inst_12293);

return statearr_12304;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12296__$1,inst_12294);
} else {
if((state_val_12297 === (2))){
var inst_12273 = (state_12296[(8)]);
var inst_12275 = (inst_12273 < n);
var state_12296__$1 = state_12296;
if(cljs.core.truth_(inst_12275)){
var statearr_12305_12323 = state_12296__$1;
(statearr_12305_12323[(1)] = (4));

} else {
var statearr_12306_12324 = state_12296__$1;
(statearr_12306_12324[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (11))){
var inst_12273 = (state_12296[(8)]);
var inst_12283 = (state_12296[(2)]);
var inst_12284 = (inst_12273 + (1));
var inst_12273__$1 = inst_12284;
var state_12296__$1 = (function (){var statearr_12307 = state_12296;
(statearr_12307[(8)] = inst_12273__$1);

(statearr_12307[(10)] = inst_12283);

return statearr_12307;
})();
var statearr_12308_12325 = state_12296__$1;
(statearr_12308_12325[(2)] = null);

(statearr_12308_12325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (9))){
var state_12296__$1 = state_12296;
var statearr_12309_12326 = state_12296__$1;
(statearr_12309_12326[(2)] = null);

(statearr_12309_12326[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (5))){
var state_12296__$1 = state_12296;
var statearr_12310_12327 = state_12296__$1;
(statearr_12310_12327[(2)] = null);

(statearr_12310_12327[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (10))){
var inst_12288 = (state_12296[(2)]);
var state_12296__$1 = state_12296;
var statearr_12311_12328 = state_12296__$1;
(statearr_12311_12328[(2)] = inst_12288);

(statearr_12311_12328[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12297 === (8))){
var inst_12278 = (state_12296[(7)]);
var state_12296__$1 = state_12296;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12296__$1,(11),out,inst_12278);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10786__auto__ = null;
var cljs$core$async$state_machine__10786__auto____0 = (function (){
var statearr_12312 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12312[(0)] = cljs$core$async$state_machine__10786__auto__);

(statearr_12312[(1)] = (1));

return statearr_12312;
});
var cljs$core$async$state_machine__10786__auto____1 = (function (state_12296){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_12296);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e12313){var ex__10789__auto__ = e12313;
var statearr_12314_12329 = state_12296;
(statearr_12314_12329[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_12296[(4)]))){
var statearr_12315_12330 = state_12296;
(statearr_12315_12330[(1)] = cljs.core.first.call(null,(state_12296[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12331 = state_12296;
state_12296 = G__12331;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$state_machine__10786__auto__ = function(state_12296){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10786__auto____1.call(this,state_12296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10786__auto____0;
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10786__auto____1;
return cljs$core$async$state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_12316 = f__10860__auto__.call(null);
(statearr_12316[(6)] = c__10859__auto___12318);

return statearr_12316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12333 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12333 = (function (f,ch,meta12334){
this.f = f;
this.ch = ch;
this.meta12334 = meta12334;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12333.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12335,meta12334__$1){
var self__ = this;
var _12335__$1 = this;
return (new cljs.core.async.t_cljs$core$async12333(self__.f,self__.ch,meta12334__$1));
}));

(cljs.core.async.t_cljs$core$async12333.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12335){
var self__ = this;
var _12335__$1 = this;
return self__.meta12334;
}));

(cljs.core.async.t_cljs$core$async12333.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12333.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12333.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12333.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12333.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12336 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12336 = (function (f,ch,meta12334,_,fn1,meta12337){
this.f = f;
this.ch = ch;
this.meta12334 = meta12334;
this._ = _;
this.fn1 = fn1;
this.meta12337 = meta12337;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12336.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12338,meta12337__$1){
var self__ = this;
var _12338__$1 = this;
return (new cljs.core.async.t_cljs$core$async12336(self__.f,self__.ch,self__.meta12334,self__._,self__.fn1,meta12337__$1));
}));

(cljs.core.async.t_cljs$core$async12336.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12338){
var self__ = this;
var _12338__$1 = this;
return self__.meta12337;
}));

(cljs.core.async.t_cljs$core$async12336.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12336.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async12336.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12336.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__12332_SHARP_){
return f1.call(null,(((p1__12332_SHARP_ == null))?null:self__.f.call(null,p1__12332_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async12336.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12334","meta12334",565532786,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async12333","cljs.core.async/t_cljs$core$async12333",-767988889,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta12337","meta12337",-1150409756,null)], null);
}));

(cljs.core.async.t_cljs$core$async12336.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12336.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12336");

(cljs.core.async.t_cljs$core$async12336.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async12336");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12336.
 */
cljs.core.async.__GT_t_cljs$core$async12336 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12336(f__$1,ch__$1,meta12334__$1,___$2,fn1__$1,meta12337){
return (new cljs.core.async.t_cljs$core$async12336(f__$1,ch__$1,meta12334__$1,___$2,fn1__$1,meta12337));
});

}

return (new cljs.core.async.t_cljs$core$async12336(self__.f,self__.ch,self__.meta12334,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4221__auto__ = ret;
if(cljs.core.truth_(and__4221__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4221__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async12333.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12333.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async12333.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12334","meta12334",565532786,null)], null);
}));

(cljs.core.async.t_cljs$core$async12333.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12333.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12333");

(cljs.core.async.t_cljs$core$async12333.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async12333");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12333.
 */
cljs.core.async.__GT_t_cljs$core$async12333 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12333(f__$1,ch__$1,meta12334){
return (new cljs.core.async.t_cljs$core$async12333(f__$1,ch__$1,meta12334));
});

}

return (new cljs.core.async.t_cljs$core$async12333(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12339 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12339 = (function (f,ch,meta12340){
this.f = f;
this.ch = ch;
this.meta12340 = meta12340;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12339.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12341,meta12340__$1){
var self__ = this;
var _12341__$1 = this;
return (new cljs.core.async.t_cljs$core$async12339(self__.f,self__.ch,meta12340__$1));
}));

(cljs.core.async.t_cljs$core$async12339.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12341){
var self__ = this;
var _12341__$1 = this;
return self__.meta12340;
}));

(cljs.core.async.t_cljs$core$async12339.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12339.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12339.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12339.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12339.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12339.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async12339.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12340","meta12340",-1003879082,null)], null);
}));

(cljs.core.async.t_cljs$core$async12339.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12339.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12339");

(cljs.core.async.t_cljs$core$async12339.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async12339");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12339.
 */
cljs.core.async.__GT_t_cljs$core$async12339 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async12339(f__$1,ch__$1,meta12340){
return (new cljs.core.async.t_cljs$core$async12339(f__$1,ch__$1,meta12340));
});

}

return (new cljs.core.async.t_cljs$core$async12339(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12342 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12342 = (function (p,ch,meta12343){
this.p = p;
this.ch = ch;
this.meta12343 = meta12343;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12342.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12344,meta12343__$1){
var self__ = this;
var _12344__$1 = this;
return (new cljs.core.async.t_cljs$core$async12342(self__.p,self__.ch,meta12343__$1));
}));

(cljs.core.async.t_cljs$core$async12342.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12344){
var self__ = this;
var _12344__$1 = this;
return self__.meta12343;
}));

(cljs.core.async.t_cljs$core$async12342.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12342.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12342.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12342.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12342.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12342.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12342.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async12342.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12343","meta12343",1758048643,null)], null);
}));

(cljs.core.async.t_cljs$core$async12342.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12342.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12342");

(cljs.core.async.t_cljs$core$async12342.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write.call(null,writer__4462__auto__,"cljs.core.async/t_cljs$core$async12342");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12342.
 */
cljs.core.async.__GT_t_cljs$core$async12342 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async12342(p__$1,ch__$1,meta12343){
return (new cljs.core.async.t_cljs$core$async12342(p__$1,ch__$1,meta12343));
});

}

return (new cljs.core.async.t_cljs$core$async12342(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__12346 = arguments.length;
switch (G__12346) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10859__auto___12387 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_12367){
var state_val_12368 = (state_12367[(1)]);
if((state_val_12368 === (7))){
var inst_12363 = (state_12367[(2)]);
var state_12367__$1 = state_12367;
var statearr_12369_12388 = state_12367__$1;
(statearr_12369_12388[(2)] = inst_12363);

(statearr_12369_12388[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12368 === (1))){
var state_12367__$1 = state_12367;
var statearr_12370_12389 = state_12367__$1;
(statearr_12370_12389[(2)] = null);

(statearr_12370_12389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12368 === (4))){
var inst_12349 = (state_12367[(7)]);
var inst_12349__$1 = (state_12367[(2)]);
var inst_12350 = (inst_12349__$1 == null);
var state_12367__$1 = (function (){var statearr_12371 = state_12367;
(statearr_12371[(7)] = inst_12349__$1);

return statearr_12371;
})();
if(cljs.core.truth_(inst_12350)){
var statearr_12372_12390 = state_12367__$1;
(statearr_12372_12390[(1)] = (5));

} else {
var statearr_12373_12391 = state_12367__$1;
(statearr_12373_12391[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12368 === (6))){
var inst_12349 = (state_12367[(7)]);
var inst_12354 = p.call(null,inst_12349);
var state_12367__$1 = state_12367;
if(cljs.core.truth_(inst_12354)){
var statearr_12374_12392 = state_12367__$1;
(statearr_12374_12392[(1)] = (8));

} else {
var statearr_12375_12393 = state_12367__$1;
(statearr_12375_12393[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12368 === (3))){
var inst_12365 = (state_12367[(2)]);
var state_12367__$1 = state_12367;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12367__$1,inst_12365);
} else {
if((state_val_12368 === (2))){
var state_12367__$1 = state_12367;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12367__$1,(4),ch);
} else {
if((state_val_12368 === (11))){
var inst_12357 = (state_12367[(2)]);
var state_12367__$1 = state_12367;
var statearr_12376_12394 = state_12367__$1;
(statearr_12376_12394[(2)] = inst_12357);

(statearr_12376_12394[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12368 === (9))){
var state_12367__$1 = state_12367;
var statearr_12377_12395 = state_12367__$1;
(statearr_12377_12395[(2)] = null);

(statearr_12377_12395[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12368 === (5))){
var inst_12352 = cljs.core.async.close_BANG_.call(null,out);
var state_12367__$1 = state_12367;
var statearr_12378_12396 = state_12367__$1;
(statearr_12378_12396[(2)] = inst_12352);

(statearr_12378_12396[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12368 === (10))){
var inst_12360 = (state_12367[(2)]);
var state_12367__$1 = (function (){var statearr_12379 = state_12367;
(statearr_12379[(8)] = inst_12360);

return statearr_12379;
})();
var statearr_12380_12397 = state_12367__$1;
(statearr_12380_12397[(2)] = null);

(statearr_12380_12397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12368 === (8))){
var inst_12349 = (state_12367[(7)]);
var state_12367__$1 = state_12367;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12367__$1,(11),out,inst_12349);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10786__auto__ = null;
var cljs$core$async$state_machine__10786__auto____0 = (function (){
var statearr_12381 = [null,null,null,null,null,null,null,null,null];
(statearr_12381[(0)] = cljs$core$async$state_machine__10786__auto__);

(statearr_12381[(1)] = (1));

return statearr_12381;
});
var cljs$core$async$state_machine__10786__auto____1 = (function (state_12367){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_12367);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e12382){var ex__10789__auto__ = e12382;
var statearr_12383_12398 = state_12367;
(statearr_12383_12398[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_12367[(4)]))){
var statearr_12384_12399 = state_12367;
(statearr_12384_12399[(1)] = cljs.core.first.call(null,(state_12367[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12400 = state_12367;
state_12367 = G__12400;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$state_machine__10786__auto__ = function(state_12367){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10786__auto____1.call(this,state_12367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10786__auto____0;
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10786__auto____1;
return cljs$core$async$state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_12385 = f__10860__auto__.call(null);
(statearr_12385[(6)] = c__10859__auto___12387);

return statearr_12385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__12402 = arguments.length;
switch (G__12402) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__10859__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_12465){
var state_val_12466 = (state_12465[(1)]);
if((state_val_12466 === (7))){
var inst_12461 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
var statearr_12467_12506 = state_12465__$1;
(statearr_12467_12506[(2)] = inst_12461);

(statearr_12467_12506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (20))){
var inst_12431 = (state_12465[(7)]);
var inst_12442 = (state_12465[(2)]);
var inst_12443 = cljs.core.next.call(null,inst_12431);
var inst_12417 = inst_12443;
var inst_12418 = null;
var inst_12419 = (0);
var inst_12420 = (0);
var state_12465__$1 = (function (){var statearr_12468 = state_12465;
(statearr_12468[(8)] = inst_12419);

(statearr_12468[(9)] = inst_12417);

(statearr_12468[(10)] = inst_12442);

(statearr_12468[(11)] = inst_12418);

(statearr_12468[(12)] = inst_12420);

return statearr_12468;
})();
var statearr_12469_12507 = state_12465__$1;
(statearr_12469_12507[(2)] = null);

(statearr_12469_12507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (1))){
var state_12465__$1 = state_12465;
var statearr_12470_12508 = state_12465__$1;
(statearr_12470_12508[(2)] = null);

(statearr_12470_12508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (4))){
var inst_12406 = (state_12465[(13)]);
var inst_12406__$1 = (state_12465[(2)]);
var inst_12407 = (inst_12406__$1 == null);
var state_12465__$1 = (function (){var statearr_12471 = state_12465;
(statearr_12471[(13)] = inst_12406__$1);

return statearr_12471;
})();
if(cljs.core.truth_(inst_12407)){
var statearr_12472_12509 = state_12465__$1;
(statearr_12472_12509[(1)] = (5));

} else {
var statearr_12473_12510 = state_12465__$1;
(statearr_12473_12510[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (15))){
var state_12465__$1 = state_12465;
var statearr_12477_12511 = state_12465__$1;
(statearr_12477_12511[(2)] = null);

(statearr_12477_12511[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (21))){
var state_12465__$1 = state_12465;
var statearr_12478_12512 = state_12465__$1;
(statearr_12478_12512[(2)] = null);

(statearr_12478_12512[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (13))){
var inst_12419 = (state_12465[(8)]);
var inst_12417 = (state_12465[(9)]);
var inst_12418 = (state_12465[(11)]);
var inst_12420 = (state_12465[(12)]);
var inst_12427 = (state_12465[(2)]);
var inst_12428 = (inst_12420 + (1));
var tmp12474 = inst_12419;
var tmp12475 = inst_12417;
var tmp12476 = inst_12418;
var inst_12417__$1 = tmp12475;
var inst_12418__$1 = tmp12476;
var inst_12419__$1 = tmp12474;
var inst_12420__$1 = inst_12428;
var state_12465__$1 = (function (){var statearr_12479 = state_12465;
(statearr_12479[(14)] = inst_12427);

(statearr_12479[(8)] = inst_12419__$1);

(statearr_12479[(9)] = inst_12417__$1);

(statearr_12479[(11)] = inst_12418__$1);

(statearr_12479[(12)] = inst_12420__$1);

return statearr_12479;
})();
var statearr_12480_12513 = state_12465__$1;
(statearr_12480_12513[(2)] = null);

(statearr_12480_12513[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (22))){
var state_12465__$1 = state_12465;
var statearr_12481_12514 = state_12465__$1;
(statearr_12481_12514[(2)] = null);

(statearr_12481_12514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (6))){
var inst_12406 = (state_12465[(13)]);
var inst_12415 = f.call(null,inst_12406);
var inst_12416 = cljs.core.seq.call(null,inst_12415);
var inst_12417 = inst_12416;
var inst_12418 = null;
var inst_12419 = (0);
var inst_12420 = (0);
var state_12465__$1 = (function (){var statearr_12482 = state_12465;
(statearr_12482[(8)] = inst_12419);

(statearr_12482[(9)] = inst_12417);

(statearr_12482[(11)] = inst_12418);

(statearr_12482[(12)] = inst_12420);

return statearr_12482;
})();
var statearr_12483_12515 = state_12465__$1;
(statearr_12483_12515[(2)] = null);

(statearr_12483_12515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (17))){
var inst_12431 = (state_12465[(7)]);
var inst_12435 = cljs.core.chunk_first.call(null,inst_12431);
var inst_12436 = cljs.core.chunk_rest.call(null,inst_12431);
var inst_12437 = cljs.core.count.call(null,inst_12435);
var inst_12417 = inst_12436;
var inst_12418 = inst_12435;
var inst_12419 = inst_12437;
var inst_12420 = (0);
var state_12465__$1 = (function (){var statearr_12484 = state_12465;
(statearr_12484[(8)] = inst_12419);

(statearr_12484[(9)] = inst_12417);

(statearr_12484[(11)] = inst_12418);

(statearr_12484[(12)] = inst_12420);

return statearr_12484;
})();
var statearr_12485_12516 = state_12465__$1;
(statearr_12485_12516[(2)] = null);

(statearr_12485_12516[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (3))){
var inst_12463 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12465__$1,inst_12463);
} else {
if((state_val_12466 === (12))){
var inst_12451 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
var statearr_12486_12517 = state_12465__$1;
(statearr_12486_12517[(2)] = inst_12451);

(statearr_12486_12517[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (2))){
var state_12465__$1 = state_12465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12465__$1,(4),in$);
} else {
if((state_val_12466 === (23))){
var inst_12459 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
var statearr_12487_12518 = state_12465__$1;
(statearr_12487_12518[(2)] = inst_12459);

(statearr_12487_12518[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (19))){
var inst_12446 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
var statearr_12488_12519 = state_12465__$1;
(statearr_12488_12519[(2)] = inst_12446);

(statearr_12488_12519[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (11))){
var inst_12417 = (state_12465[(9)]);
var inst_12431 = (state_12465[(7)]);
var inst_12431__$1 = cljs.core.seq.call(null,inst_12417);
var state_12465__$1 = (function (){var statearr_12489 = state_12465;
(statearr_12489[(7)] = inst_12431__$1);

return statearr_12489;
})();
if(inst_12431__$1){
var statearr_12490_12520 = state_12465__$1;
(statearr_12490_12520[(1)] = (14));

} else {
var statearr_12491_12521 = state_12465__$1;
(statearr_12491_12521[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (9))){
var inst_12453 = (state_12465[(2)]);
var inst_12454 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_12465__$1 = (function (){var statearr_12492 = state_12465;
(statearr_12492[(15)] = inst_12453);

return statearr_12492;
})();
if(cljs.core.truth_(inst_12454)){
var statearr_12493_12522 = state_12465__$1;
(statearr_12493_12522[(1)] = (21));

} else {
var statearr_12494_12523 = state_12465__$1;
(statearr_12494_12523[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (5))){
var inst_12409 = cljs.core.async.close_BANG_.call(null,out);
var state_12465__$1 = state_12465;
var statearr_12495_12524 = state_12465__$1;
(statearr_12495_12524[(2)] = inst_12409);

(statearr_12495_12524[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (14))){
var inst_12431 = (state_12465[(7)]);
var inst_12433 = cljs.core.chunked_seq_QMARK_.call(null,inst_12431);
var state_12465__$1 = state_12465;
if(inst_12433){
var statearr_12496_12525 = state_12465__$1;
(statearr_12496_12525[(1)] = (17));

} else {
var statearr_12497_12526 = state_12465__$1;
(statearr_12497_12526[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (16))){
var inst_12449 = (state_12465[(2)]);
var state_12465__$1 = state_12465;
var statearr_12498_12527 = state_12465__$1;
(statearr_12498_12527[(2)] = inst_12449);

(statearr_12498_12527[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12466 === (10))){
var inst_12418 = (state_12465[(11)]);
var inst_12420 = (state_12465[(12)]);
var inst_12425 = cljs.core._nth.call(null,inst_12418,inst_12420);
var state_12465__$1 = state_12465;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12465__$1,(13),out,inst_12425);
} else {
if((state_val_12466 === (18))){
var inst_12431 = (state_12465[(7)]);
var inst_12440 = cljs.core.first.call(null,inst_12431);
var state_12465__$1 = state_12465;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12465__$1,(20),out,inst_12440);
} else {
if((state_val_12466 === (8))){
var inst_12419 = (state_12465[(8)]);
var inst_12420 = (state_12465[(12)]);
var inst_12422 = (inst_12420 < inst_12419);
var inst_12423 = inst_12422;
var state_12465__$1 = state_12465;
if(cljs.core.truth_(inst_12423)){
var statearr_12499_12528 = state_12465__$1;
(statearr_12499_12528[(1)] = (10));

} else {
var statearr_12500_12529 = state_12465__$1;
(statearr_12500_12529[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10786__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10786__auto____0 = (function (){
var statearr_12501 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12501[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10786__auto__);

(statearr_12501[(1)] = (1));

return statearr_12501;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10786__auto____1 = (function (state_12465){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_12465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e12502){var ex__10789__auto__ = e12502;
var statearr_12503_12530 = state_12465;
(statearr_12503_12530[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_12465[(4)]))){
var statearr_12504_12531 = state_12465;
(statearr_12504_12531[(1)] = cljs.core.first.call(null,(state_12465[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12532 = state_12465;
state_12465 = G__12532;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10786__auto__ = function(state_12465){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10786__auto____1.call(this,state_12465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10786__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10786__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_12505 = f__10860__auto__.call(null);
(statearr_12505[(6)] = c__10859__auto__);

return statearr_12505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));

return c__10859__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__12534 = arguments.length;
switch (G__12534) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__12537 = arguments.length;
switch (G__12537) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__12540 = arguments.length;
switch (G__12540) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10859__auto___12588 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_12564){
var state_val_12565 = (state_12564[(1)]);
if((state_val_12565 === (7))){
var inst_12559 = (state_12564[(2)]);
var state_12564__$1 = state_12564;
var statearr_12566_12589 = state_12564__$1;
(statearr_12566_12589[(2)] = inst_12559);

(statearr_12566_12589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12565 === (1))){
var inst_12541 = null;
var state_12564__$1 = (function (){var statearr_12567 = state_12564;
(statearr_12567[(7)] = inst_12541);

return statearr_12567;
})();
var statearr_12568_12590 = state_12564__$1;
(statearr_12568_12590[(2)] = null);

(statearr_12568_12590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12565 === (4))){
var inst_12544 = (state_12564[(8)]);
var inst_12544__$1 = (state_12564[(2)]);
var inst_12545 = (inst_12544__$1 == null);
var inst_12546 = cljs.core.not.call(null,inst_12545);
var state_12564__$1 = (function (){var statearr_12569 = state_12564;
(statearr_12569[(8)] = inst_12544__$1);

return statearr_12569;
})();
if(inst_12546){
var statearr_12570_12591 = state_12564__$1;
(statearr_12570_12591[(1)] = (5));

} else {
var statearr_12571_12592 = state_12564__$1;
(statearr_12571_12592[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12565 === (6))){
var state_12564__$1 = state_12564;
var statearr_12572_12593 = state_12564__$1;
(statearr_12572_12593[(2)] = null);

(statearr_12572_12593[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12565 === (3))){
var inst_12561 = (state_12564[(2)]);
var inst_12562 = cljs.core.async.close_BANG_.call(null,out);
var state_12564__$1 = (function (){var statearr_12573 = state_12564;
(statearr_12573[(9)] = inst_12561);

return statearr_12573;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12564__$1,inst_12562);
} else {
if((state_val_12565 === (2))){
var state_12564__$1 = state_12564;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12564__$1,(4),ch);
} else {
if((state_val_12565 === (11))){
var inst_12544 = (state_12564[(8)]);
var inst_12553 = (state_12564[(2)]);
var inst_12541 = inst_12544;
var state_12564__$1 = (function (){var statearr_12574 = state_12564;
(statearr_12574[(7)] = inst_12541);

(statearr_12574[(10)] = inst_12553);

return statearr_12574;
})();
var statearr_12575_12594 = state_12564__$1;
(statearr_12575_12594[(2)] = null);

(statearr_12575_12594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12565 === (9))){
var inst_12544 = (state_12564[(8)]);
var state_12564__$1 = state_12564;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12564__$1,(11),out,inst_12544);
} else {
if((state_val_12565 === (5))){
var inst_12541 = (state_12564[(7)]);
var inst_12544 = (state_12564[(8)]);
var inst_12548 = cljs.core._EQ_.call(null,inst_12544,inst_12541);
var state_12564__$1 = state_12564;
if(inst_12548){
var statearr_12577_12595 = state_12564__$1;
(statearr_12577_12595[(1)] = (8));

} else {
var statearr_12578_12596 = state_12564__$1;
(statearr_12578_12596[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12565 === (10))){
var inst_12556 = (state_12564[(2)]);
var state_12564__$1 = state_12564;
var statearr_12579_12597 = state_12564__$1;
(statearr_12579_12597[(2)] = inst_12556);

(statearr_12579_12597[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12565 === (8))){
var inst_12541 = (state_12564[(7)]);
var tmp12576 = inst_12541;
var inst_12541__$1 = tmp12576;
var state_12564__$1 = (function (){var statearr_12580 = state_12564;
(statearr_12580[(7)] = inst_12541__$1);

return statearr_12580;
})();
var statearr_12581_12598 = state_12564__$1;
(statearr_12581_12598[(2)] = null);

(statearr_12581_12598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10786__auto__ = null;
var cljs$core$async$state_machine__10786__auto____0 = (function (){
var statearr_12582 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12582[(0)] = cljs$core$async$state_machine__10786__auto__);

(statearr_12582[(1)] = (1));

return statearr_12582;
});
var cljs$core$async$state_machine__10786__auto____1 = (function (state_12564){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_12564);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e12583){var ex__10789__auto__ = e12583;
var statearr_12584_12599 = state_12564;
(statearr_12584_12599[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_12564[(4)]))){
var statearr_12585_12600 = state_12564;
(statearr_12585_12600[(1)] = cljs.core.first.call(null,(state_12564[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12601 = state_12564;
state_12564 = G__12601;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$state_machine__10786__auto__ = function(state_12564){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10786__auto____1.call(this,state_12564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10786__auto____0;
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10786__auto____1;
return cljs$core$async$state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_12586 = f__10860__auto__.call(null);
(statearr_12586[(6)] = c__10859__auto___12588);

return statearr_12586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__12603 = arguments.length;
switch (G__12603) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10859__auto___12670 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_12641){
var state_val_12642 = (state_12641[(1)]);
if((state_val_12642 === (7))){
var inst_12637 = (state_12641[(2)]);
var state_12641__$1 = state_12641;
var statearr_12643_12671 = state_12641__$1;
(statearr_12643_12671[(2)] = inst_12637);

(statearr_12643_12671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12642 === (1))){
var inst_12604 = (new Array(n));
var inst_12605 = inst_12604;
var inst_12606 = (0);
var state_12641__$1 = (function (){var statearr_12644 = state_12641;
(statearr_12644[(7)] = inst_12605);

(statearr_12644[(8)] = inst_12606);

return statearr_12644;
})();
var statearr_12645_12672 = state_12641__$1;
(statearr_12645_12672[(2)] = null);

(statearr_12645_12672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12642 === (4))){
var inst_12609 = (state_12641[(9)]);
var inst_12609__$1 = (state_12641[(2)]);
var inst_12610 = (inst_12609__$1 == null);
var inst_12611 = cljs.core.not.call(null,inst_12610);
var state_12641__$1 = (function (){var statearr_12646 = state_12641;
(statearr_12646[(9)] = inst_12609__$1);

return statearr_12646;
})();
if(inst_12611){
var statearr_12647_12673 = state_12641__$1;
(statearr_12647_12673[(1)] = (5));

} else {
var statearr_12648_12674 = state_12641__$1;
(statearr_12648_12674[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12642 === (15))){
var inst_12631 = (state_12641[(2)]);
var state_12641__$1 = state_12641;
var statearr_12649_12675 = state_12641__$1;
(statearr_12649_12675[(2)] = inst_12631);

(statearr_12649_12675[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12642 === (13))){
var state_12641__$1 = state_12641;
var statearr_12650_12676 = state_12641__$1;
(statearr_12650_12676[(2)] = null);

(statearr_12650_12676[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12642 === (6))){
var inst_12606 = (state_12641[(8)]);
var inst_12627 = (inst_12606 > (0));
var state_12641__$1 = state_12641;
if(cljs.core.truth_(inst_12627)){
var statearr_12651_12677 = state_12641__$1;
(statearr_12651_12677[(1)] = (12));

} else {
var statearr_12652_12678 = state_12641__$1;
(statearr_12652_12678[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12642 === (3))){
var inst_12639 = (state_12641[(2)]);
var state_12641__$1 = state_12641;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12641__$1,inst_12639);
} else {
if((state_val_12642 === (12))){
var inst_12605 = (state_12641[(7)]);
var inst_12629 = cljs.core.vec.call(null,inst_12605);
var state_12641__$1 = state_12641;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12641__$1,(15),out,inst_12629);
} else {
if((state_val_12642 === (2))){
var state_12641__$1 = state_12641;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12641__$1,(4),ch);
} else {
if((state_val_12642 === (11))){
var inst_12621 = (state_12641[(2)]);
var inst_12622 = (new Array(n));
var inst_12605 = inst_12622;
var inst_12606 = (0);
var state_12641__$1 = (function (){var statearr_12653 = state_12641;
(statearr_12653[(10)] = inst_12621);

(statearr_12653[(7)] = inst_12605);

(statearr_12653[(8)] = inst_12606);

return statearr_12653;
})();
var statearr_12654_12679 = state_12641__$1;
(statearr_12654_12679[(2)] = null);

(statearr_12654_12679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12642 === (9))){
var inst_12605 = (state_12641[(7)]);
var inst_12619 = cljs.core.vec.call(null,inst_12605);
var state_12641__$1 = state_12641;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12641__$1,(11),out,inst_12619);
} else {
if((state_val_12642 === (5))){
var inst_12614 = (state_12641[(11)]);
var inst_12609 = (state_12641[(9)]);
var inst_12605 = (state_12641[(7)]);
var inst_12606 = (state_12641[(8)]);
var inst_12613 = (inst_12605[inst_12606] = inst_12609);
var inst_12614__$1 = (inst_12606 + (1));
var inst_12615 = (inst_12614__$1 < n);
var state_12641__$1 = (function (){var statearr_12655 = state_12641;
(statearr_12655[(12)] = inst_12613);

(statearr_12655[(11)] = inst_12614__$1);

return statearr_12655;
})();
if(cljs.core.truth_(inst_12615)){
var statearr_12656_12680 = state_12641__$1;
(statearr_12656_12680[(1)] = (8));

} else {
var statearr_12657_12681 = state_12641__$1;
(statearr_12657_12681[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12642 === (14))){
var inst_12634 = (state_12641[(2)]);
var inst_12635 = cljs.core.async.close_BANG_.call(null,out);
var state_12641__$1 = (function (){var statearr_12659 = state_12641;
(statearr_12659[(13)] = inst_12634);

return statearr_12659;
})();
var statearr_12660_12682 = state_12641__$1;
(statearr_12660_12682[(2)] = inst_12635);

(statearr_12660_12682[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12642 === (10))){
var inst_12625 = (state_12641[(2)]);
var state_12641__$1 = state_12641;
var statearr_12661_12683 = state_12641__$1;
(statearr_12661_12683[(2)] = inst_12625);

(statearr_12661_12683[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12642 === (8))){
var inst_12614 = (state_12641[(11)]);
var inst_12605 = (state_12641[(7)]);
var tmp12658 = inst_12605;
var inst_12605__$1 = tmp12658;
var inst_12606 = inst_12614;
var state_12641__$1 = (function (){var statearr_12662 = state_12641;
(statearr_12662[(7)] = inst_12605__$1);

(statearr_12662[(8)] = inst_12606);

return statearr_12662;
})();
var statearr_12663_12684 = state_12641__$1;
(statearr_12663_12684[(2)] = null);

(statearr_12663_12684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10786__auto__ = null;
var cljs$core$async$state_machine__10786__auto____0 = (function (){
var statearr_12664 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12664[(0)] = cljs$core$async$state_machine__10786__auto__);

(statearr_12664[(1)] = (1));

return statearr_12664;
});
var cljs$core$async$state_machine__10786__auto____1 = (function (state_12641){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_12641);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e12665){var ex__10789__auto__ = e12665;
var statearr_12666_12685 = state_12641;
(statearr_12666_12685[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_12641[(4)]))){
var statearr_12667_12686 = state_12641;
(statearr_12667_12686[(1)] = cljs.core.first.call(null,(state_12641[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12687 = state_12641;
state_12641 = G__12687;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$state_machine__10786__auto__ = function(state_12641){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10786__auto____1.call(this,state_12641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10786__auto____0;
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10786__auto____1;
return cljs$core$async$state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_12668 = f__10860__auto__.call(null);
(statearr_12668[(6)] = c__10859__auto___12670);

return statearr_12668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__12689 = arguments.length;
switch (G__12689) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10859__auto___12767 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10860__auto__ = (function (){var switch__10785__auto__ = (function (state_12734){
var state_val_12735 = (state_12734[(1)]);
if((state_val_12735 === (7))){
var inst_12730 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
var statearr_12736_12768 = state_12734__$1;
(statearr_12736_12768[(2)] = inst_12730);

(statearr_12736_12768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (1))){
var inst_12690 = [];
var inst_12691 = inst_12690;
var inst_12692 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_12734__$1 = (function (){var statearr_12737 = state_12734;
(statearr_12737[(7)] = inst_12691);

(statearr_12737[(8)] = inst_12692);

return statearr_12737;
})();
var statearr_12738_12769 = state_12734__$1;
(statearr_12738_12769[(2)] = null);

(statearr_12738_12769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (4))){
var inst_12695 = (state_12734[(9)]);
var inst_12695__$1 = (state_12734[(2)]);
var inst_12696 = (inst_12695__$1 == null);
var inst_12697 = cljs.core.not.call(null,inst_12696);
var state_12734__$1 = (function (){var statearr_12739 = state_12734;
(statearr_12739[(9)] = inst_12695__$1);

return statearr_12739;
})();
if(inst_12697){
var statearr_12740_12770 = state_12734__$1;
(statearr_12740_12770[(1)] = (5));

} else {
var statearr_12741_12771 = state_12734__$1;
(statearr_12741_12771[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (15))){
var inst_12691 = (state_12734[(7)]);
var inst_12722 = cljs.core.vec.call(null,inst_12691);
var state_12734__$1 = state_12734;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12734__$1,(18),out,inst_12722);
} else {
if((state_val_12735 === (13))){
var inst_12717 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
var statearr_12742_12772 = state_12734__$1;
(statearr_12742_12772[(2)] = inst_12717);

(statearr_12742_12772[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (6))){
var inst_12691 = (state_12734[(7)]);
var inst_12719 = inst_12691.length;
var inst_12720 = (inst_12719 > (0));
var state_12734__$1 = state_12734;
if(cljs.core.truth_(inst_12720)){
var statearr_12743_12773 = state_12734__$1;
(statearr_12743_12773[(1)] = (15));

} else {
var statearr_12744_12774 = state_12734__$1;
(statearr_12744_12774[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (17))){
var inst_12727 = (state_12734[(2)]);
var inst_12728 = cljs.core.async.close_BANG_.call(null,out);
var state_12734__$1 = (function (){var statearr_12745 = state_12734;
(statearr_12745[(10)] = inst_12727);

return statearr_12745;
})();
var statearr_12746_12775 = state_12734__$1;
(statearr_12746_12775[(2)] = inst_12728);

(statearr_12746_12775[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (3))){
var inst_12732 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12734__$1,inst_12732);
} else {
if((state_val_12735 === (12))){
var inst_12691 = (state_12734[(7)]);
var inst_12710 = cljs.core.vec.call(null,inst_12691);
var state_12734__$1 = state_12734;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12734__$1,(14),out,inst_12710);
} else {
if((state_val_12735 === (2))){
var state_12734__$1 = state_12734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12734__$1,(4),ch);
} else {
if((state_val_12735 === (11))){
var inst_12695 = (state_12734[(9)]);
var inst_12699 = (state_12734[(11)]);
var inst_12691 = (state_12734[(7)]);
var inst_12707 = inst_12691.push(inst_12695);
var tmp12747 = inst_12691;
var inst_12691__$1 = tmp12747;
var inst_12692 = inst_12699;
var state_12734__$1 = (function (){var statearr_12748 = state_12734;
(statearr_12748[(12)] = inst_12707);

(statearr_12748[(7)] = inst_12691__$1);

(statearr_12748[(8)] = inst_12692);

return statearr_12748;
})();
var statearr_12749_12776 = state_12734__$1;
(statearr_12749_12776[(2)] = null);

(statearr_12749_12776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (9))){
var inst_12692 = (state_12734[(8)]);
var inst_12703 = cljs.core.keyword_identical_QMARK_.call(null,inst_12692,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_12734__$1 = state_12734;
var statearr_12750_12777 = state_12734__$1;
(statearr_12750_12777[(2)] = inst_12703);

(statearr_12750_12777[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (5))){
var inst_12695 = (state_12734[(9)]);
var inst_12700 = (state_12734[(13)]);
var inst_12699 = (state_12734[(11)]);
var inst_12692 = (state_12734[(8)]);
var inst_12699__$1 = f.call(null,inst_12695);
var inst_12700__$1 = cljs.core._EQ_.call(null,inst_12699__$1,inst_12692);
var state_12734__$1 = (function (){var statearr_12751 = state_12734;
(statearr_12751[(13)] = inst_12700__$1);

(statearr_12751[(11)] = inst_12699__$1);

return statearr_12751;
})();
if(inst_12700__$1){
var statearr_12752_12778 = state_12734__$1;
(statearr_12752_12778[(1)] = (8));

} else {
var statearr_12753_12779 = state_12734__$1;
(statearr_12753_12779[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (14))){
var inst_12695 = (state_12734[(9)]);
var inst_12699 = (state_12734[(11)]);
var inst_12712 = (state_12734[(2)]);
var inst_12713 = [];
var inst_12714 = inst_12713.push(inst_12695);
var inst_12691 = inst_12713;
var inst_12692 = inst_12699;
var state_12734__$1 = (function (){var statearr_12754 = state_12734;
(statearr_12754[(14)] = inst_12712);

(statearr_12754[(7)] = inst_12691);

(statearr_12754[(15)] = inst_12714);

(statearr_12754[(8)] = inst_12692);

return statearr_12754;
})();
var statearr_12755_12780 = state_12734__$1;
(statearr_12755_12780[(2)] = null);

(statearr_12755_12780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (16))){
var state_12734__$1 = state_12734;
var statearr_12756_12781 = state_12734__$1;
(statearr_12756_12781[(2)] = null);

(statearr_12756_12781[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (10))){
var inst_12705 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
if(cljs.core.truth_(inst_12705)){
var statearr_12757_12782 = state_12734__$1;
(statearr_12757_12782[(1)] = (11));

} else {
var statearr_12758_12783 = state_12734__$1;
(statearr_12758_12783[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (18))){
var inst_12724 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
var statearr_12759_12784 = state_12734__$1;
(statearr_12759_12784[(2)] = inst_12724);

(statearr_12759_12784[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (8))){
var inst_12700 = (state_12734[(13)]);
var state_12734__$1 = state_12734;
var statearr_12760_12785 = state_12734__$1;
(statearr_12760_12785[(2)] = inst_12700);

(statearr_12760_12785[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10786__auto__ = null;
var cljs$core$async$state_machine__10786__auto____0 = (function (){
var statearr_12761 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12761[(0)] = cljs$core$async$state_machine__10786__auto__);

(statearr_12761[(1)] = (1));

return statearr_12761;
});
var cljs$core$async$state_machine__10786__auto____1 = (function (state_12734){
while(true){
var ret_value__10787__auto__ = (function (){try{while(true){
var result__10788__auto__ = switch__10785__auto__.call(null,state_12734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10788__auto__;
}
break;
}
}catch (e12762){var ex__10789__auto__ = e12762;
var statearr_12763_12786 = state_12734;
(statearr_12763_12786[(2)] = ex__10789__auto__);


if(cljs.core.seq.call(null,(state_12734[(4)]))){
var statearr_12764_12787 = state_12734;
(statearr_12764_12787[(1)] = cljs.core.first.call(null,(state_12734[(4)])));

} else {
throw ex__10789__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10787__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12788 = state_12734;
state_12734 = G__12788;
continue;
} else {
return ret_value__10787__auto__;
}
break;
}
});
cljs$core$async$state_machine__10786__auto__ = function(state_12734){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10786__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10786__auto____1.call(this,state_12734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10786__auto____0;
cljs$core$async$state_machine__10786__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10786__auto____1;
return cljs$core$async$state_machine__10786__auto__;
})()
})();
var state__10861__auto__ = (function (){var statearr_12765 = f__10860__auto__.call(null);
(statearr_12765[(6)] = c__10859__auto___12767);

return statearr_12765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10861__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

