// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__5405){
var vec__5406 = p__5405;
var i = cljs.core.nth.call(null,vec__5406,(0),null);
var v = cljs.core.nth.call(null,vec__5406,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__5409 = seg;
var gcol = cljs.core.nth.call(null,vec__5409,(0),null);
var source = cljs.core.nth.call(null,vec__5409,(1),null);
var line = cljs.core.nth.call(null,vec__5409,(2),null);
var col = cljs.core.nth.call(null,vec__5409,(3),null);
var name = cljs.core.nth.call(null,vec__5409,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__5412 = seg;
var gcol = cljs.core.nth.call(null,vec__5412,(0),null);
var source = cljs.core.nth.call(null,vec__5412,(1),null);
var line = cljs.core.nth.call(null,vec__5412,(2),null);
var col = cljs.core.nth.call(null,vec__5412,(3),null);
var name = cljs.core.nth.call(null,vec__5412,(4),null);
var vec__5415 = relseg;
var rgcol = cljs.core.nth.call(null,vec__5415,(0),null);
var rsource = cljs.core.nth.call(null,vec__5415,(1),null);
var rline = cljs.core.nth.call(null,vec__5415,(2),null);
var rcol = cljs.core.nth.call(null,vec__5415,(3),null);
var rname = cljs.core.nth.call(null,vec__5415,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4223__auto__ = source;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4223__auto__ = line;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4223__auto__ = col;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__5418 = segmap;
var map__5418__$1 = cljs.core.__destructure_map.call(null,map__5418);
var gcol = cljs.core.get.call(null,map__5418__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__5418__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__5418__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__5418__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__5418__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,(function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,(function (v){
return cljs.core.conj.call(null,v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__5420 = arguments.length;
switch (G__5420) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__5424 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__5428 = cljs.core.next.call(null,segs__$1);
var G__5429 = nrelseg;
var G__5430 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__5428;
relseg__$1 = G__5429;
result__$1 = G__5430;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__5424,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__5424,(1),null);
var G__5431 = (gline + (1));
var G__5432 = cljs.core.next.call(null,lines__$1);
var G__5433 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__5434 = result__$1;
gline = G__5431;
lines__$1 = G__5432;
relseg = G__5433;
result = G__5434;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__5436 = segmap;
var map__5436__$1 = cljs.core.__destructure_map.call(null,map__5436);
var gcol = cljs.core.get.call(null,map__5436__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__5436__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__5436__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__5436__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__5436__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,(function (p1__5435_SHARP_){
return cljs.core.conj.call(null,p1__5435_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__5438 = arguments.length;
switch (G__5438) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__5442 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__5446 = cljs.core.next.call(null,segs__$1);
var G__5447 = nrelseg;
var G__5448 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__5446;
relseg__$1 = G__5447;
result__$1 = G__5448;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__5442,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__5442,(1),null);
var G__5449 = (gline + (1));
var G__5450 = cljs.core.next.call(null,lines__$1);
var G__5451 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__5452 = result__$1;
gline = G__5449;
lines__$1 = G__5450;
relseg = G__5451;
result = G__5452;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,(function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,(function (p__5453){
var vec__5454 = p__5453;
var _ = cljs.core.nth.call(null,vec__5454,(0),null);
var source = cljs.core.nth.call(null,vec__5454,(1),null);
var line = cljs.core.nth.call(null,vec__5454,(2),null);
var col = cljs.core.nth.call(null,vec__5454,(3),null);
var name = cljs.core.nth.call(null,vec__5454,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,(function (cols__$1,p__5457){
var vec__5458 = p__5457;
var gcol = cljs.core.nth.call(null,vec__5458,(0),null);
var sidx = cljs.core.nth.call(null,vec__5458,(1),null);
var line = cljs.core.nth.call(null,vec__5458,(2),null);
var col = cljs.core.nth.call(null,vec__5458,(3),null);
var name = cljs.core.nth.call(null,vec__5458,(4),null);
var seg = vec__5458;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,(function (p__5461){
var vec__5462 = p__5461;
var _ = cljs.core.nth.call(null,vec__5462,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__5462,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__5462,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__5462,(3),null);
var lname = cljs.core.nth.call(null,vec__5462,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__5468 = cljs.core.seq.call(null,infos);
var chunk__5469 = null;
var count__5470 = (0);
var i__5471 = (0);
while(true){
if((i__5471 < count__5470)){
var info = cljs.core._nth.call(null,chunk__5469,i__5471);
var segv_5822 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_5823 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_5824 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_5823 > (lc_5824 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__5468,chunk__5469,count__5470,i__5471,segv_5822,gline_5823,lc_5824,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_5823 - (lc_5824 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_5822], null));
});})(seq__5468,chunk__5469,count__5470,i__5471,segv_5822,gline_5823,lc_5824,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__5468,chunk__5469,count__5470,i__5471,segv_5822,gline_5823,lc_5824,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5823], null),cljs.core.conj,segv_5822);
});})(seq__5468,chunk__5469,count__5470,i__5471,segv_5822,gline_5823,lc_5824,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__5825 = seq__5468;
var G__5826 = chunk__5469;
var G__5827 = count__5470;
var G__5828 = (i__5471 + (1));
seq__5468 = G__5825;
chunk__5469 = G__5826;
count__5470 = G__5827;
i__5471 = G__5828;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__5468);
if(temp__5753__auto__){
var seq__5468__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5468__$1)){
var c__4649__auto__ = cljs.core.chunk_first.call(null,seq__5468__$1);
var G__5829 = cljs.core.chunk_rest.call(null,seq__5468__$1);
var G__5830 = c__4649__auto__;
var G__5831 = cljs.core.count.call(null,c__4649__auto__);
var G__5832 = (0);
seq__5468 = G__5829;
chunk__5469 = G__5830;
count__5470 = G__5831;
i__5471 = G__5832;
continue;
} else {
var info = cljs.core.first.call(null,seq__5468__$1);
var segv_5833 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_5834 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_5835 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_5834 > (lc_5835 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__5468,chunk__5469,count__5470,i__5471,segv_5833,gline_5834,lc_5835,info,seq__5468__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_5834 - (lc_5835 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_5833], null));
});})(seq__5468,chunk__5469,count__5470,i__5471,segv_5833,gline_5834,lc_5835,info,seq__5468__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__5468,chunk__5469,count__5470,i__5471,segv_5833,gline_5834,lc_5835,info,seq__5468__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5834], null),cljs.core.conj,segv_5833);
});})(seq__5468,chunk__5469,count__5470,i__5471,segv_5833,gline_5834,lc_5835,info,seq__5468__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__5836 = cljs.core.next.call(null,seq__5468__$1);
var G__5837 = null;
var G__5838 = (0);
var G__5839 = (0);
seq__5468 = G__5836;
chunk__5469 = G__5837;
count__5470 = G__5838;
i__5471 = G__5839;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__5472_5840 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__5473_5841 = null;
var count__5474_5842 = (0);
var i__5475_5843 = (0);
while(true){
if((i__5475_5843 < count__5474_5842)){
var vec__5648_5844 = cljs.core._nth.call(null,chunk__5473_5841,i__5475_5843);
var source_idx_5845 = cljs.core.nth.call(null,vec__5648_5844,(0),null);
var vec__5651_5846 = cljs.core.nth.call(null,vec__5648_5844,(1),null);
var __5847 = cljs.core.nth.call(null,vec__5651_5846,(0),null);
var lines_5848__$1 = cljs.core.nth.call(null,vec__5651_5846,(1),null);
var seq__5654_5849 = cljs.core.seq.call(null,lines_5848__$1);
var chunk__5655_5850 = null;
var count__5656_5851 = (0);
var i__5657_5852 = (0);
while(true){
if((i__5657_5852 < count__5656_5851)){
var vec__5696_5853 = cljs.core._nth.call(null,chunk__5655_5850,i__5657_5852);
var line_5854 = cljs.core.nth.call(null,vec__5696_5853,(0),null);
var cols_5855 = cljs.core.nth.call(null,vec__5696_5853,(1),null);
var seq__5699_5856 = cljs.core.seq.call(null,cols_5855);
var chunk__5700_5857 = null;
var count__5701_5858 = (0);
var i__5702_5859 = (0);
while(true){
if((i__5702_5859 < count__5701_5858)){
var vec__5709_5860 = cljs.core._nth.call(null,chunk__5700_5857,i__5702_5859);
var col_5861 = cljs.core.nth.call(null,vec__5709_5860,(0),null);
var infos_5862 = cljs.core.nth.call(null,vec__5709_5860,(1),null);
encode_cols.call(null,infos_5862,source_idx_5845,line_5854,col_5861);


var G__5863 = seq__5699_5856;
var G__5864 = chunk__5700_5857;
var G__5865 = count__5701_5858;
var G__5866 = (i__5702_5859 + (1));
seq__5699_5856 = G__5863;
chunk__5700_5857 = G__5864;
count__5701_5858 = G__5865;
i__5702_5859 = G__5866;
continue;
} else {
var temp__5753__auto___5867 = cljs.core.seq.call(null,seq__5699_5856);
if(temp__5753__auto___5867){
var seq__5699_5868__$1 = temp__5753__auto___5867;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5699_5868__$1)){
var c__4649__auto___5869 = cljs.core.chunk_first.call(null,seq__5699_5868__$1);
var G__5870 = cljs.core.chunk_rest.call(null,seq__5699_5868__$1);
var G__5871 = c__4649__auto___5869;
var G__5872 = cljs.core.count.call(null,c__4649__auto___5869);
var G__5873 = (0);
seq__5699_5856 = G__5870;
chunk__5700_5857 = G__5871;
count__5701_5858 = G__5872;
i__5702_5859 = G__5873;
continue;
} else {
var vec__5712_5874 = cljs.core.first.call(null,seq__5699_5868__$1);
var col_5875 = cljs.core.nth.call(null,vec__5712_5874,(0),null);
var infos_5876 = cljs.core.nth.call(null,vec__5712_5874,(1),null);
encode_cols.call(null,infos_5876,source_idx_5845,line_5854,col_5875);


var G__5877 = cljs.core.next.call(null,seq__5699_5868__$1);
var G__5878 = null;
var G__5879 = (0);
var G__5880 = (0);
seq__5699_5856 = G__5877;
chunk__5700_5857 = G__5878;
count__5701_5858 = G__5879;
i__5702_5859 = G__5880;
continue;
}
} else {
}
}
break;
}


var G__5881 = seq__5654_5849;
var G__5882 = chunk__5655_5850;
var G__5883 = count__5656_5851;
var G__5884 = (i__5657_5852 + (1));
seq__5654_5849 = G__5881;
chunk__5655_5850 = G__5882;
count__5656_5851 = G__5883;
i__5657_5852 = G__5884;
continue;
} else {
var temp__5753__auto___5885 = cljs.core.seq.call(null,seq__5654_5849);
if(temp__5753__auto___5885){
var seq__5654_5886__$1 = temp__5753__auto___5885;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5654_5886__$1)){
var c__4649__auto___5887 = cljs.core.chunk_first.call(null,seq__5654_5886__$1);
var G__5888 = cljs.core.chunk_rest.call(null,seq__5654_5886__$1);
var G__5889 = c__4649__auto___5887;
var G__5890 = cljs.core.count.call(null,c__4649__auto___5887);
var G__5891 = (0);
seq__5654_5849 = G__5888;
chunk__5655_5850 = G__5889;
count__5656_5851 = G__5890;
i__5657_5852 = G__5891;
continue;
} else {
var vec__5715_5892 = cljs.core.first.call(null,seq__5654_5886__$1);
var line_5893 = cljs.core.nth.call(null,vec__5715_5892,(0),null);
var cols_5894 = cljs.core.nth.call(null,vec__5715_5892,(1),null);
var seq__5718_5895 = cljs.core.seq.call(null,cols_5894);
var chunk__5719_5896 = null;
var count__5720_5897 = (0);
var i__5721_5898 = (0);
while(true){
if((i__5721_5898 < count__5720_5897)){
var vec__5728_5899 = cljs.core._nth.call(null,chunk__5719_5896,i__5721_5898);
var col_5900 = cljs.core.nth.call(null,vec__5728_5899,(0),null);
var infos_5901 = cljs.core.nth.call(null,vec__5728_5899,(1),null);
encode_cols.call(null,infos_5901,source_idx_5845,line_5893,col_5900);


var G__5902 = seq__5718_5895;
var G__5903 = chunk__5719_5896;
var G__5904 = count__5720_5897;
var G__5905 = (i__5721_5898 + (1));
seq__5718_5895 = G__5902;
chunk__5719_5896 = G__5903;
count__5720_5897 = G__5904;
i__5721_5898 = G__5905;
continue;
} else {
var temp__5753__auto___5906__$1 = cljs.core.seq.call(null,seq__5718_5895);
if(temp__5753__auto___5906__$1){
var seq__5718_5907__$1 = temp__5753__auto___5906__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5718_5907__$1)){
var c__4649__auto___5908 = cljs.core.chunk_first.call(null,seq__5718_5907__$1);
var G__5909 = cljs.core.chunk_rest.call(null,seq__5718_5907__$1);
var G__5910 = c__4649__auto___5908;
var G__5911 = cljs.core.count.call(null,c__4649__auto___5908);
var G__5912 = (0);
seq__5718_5895 = G__5909;
chunk__5719_5896 = G__5910;
count__5720_5897 = G__5911;
i__5721_5898 = G__5912;
continue;
} else {
var vec__5731_5913 = cljs.core.first.call(null,seq__5718_5907__$1);
var col_5914 = cljs.core.nth.call(null,vec__5731_5913,(0),null);
var infos_5915 = cljs.core.nth.call(null,vec__5731_5913,(1),null);
encode_cols.call(null,infos_5915,source_idx_5845,line_5893,col_5914);


var G__5916 = cljs.core.next.call(null,seq__5718_5907__$1);
var G__5917 = null;
var G__5918 = (0);
var G__5919 = (0);
seq__5718_5895 = G__5916;
chunk__5719_5896 = G__5917;
count__5720_5897 = G__5918;
i__5721_5898 = G__5919;
continue;
}
} else {
}
}
break;
}


var G__5920 = cljs.core.next.call(null,seq__5654_5886__$1);
var G__5921 = null;
var G__5922 = (0);
var G__5923 = (0);
seq__5654_5849 = G__5920;
chunk__5655_5850 = G__5921;
count__5656_5851 = G__5922;
i__5657_5852 = G__5923;
continue;
}
} else {
}
}
break;
}


var G__5924 = seq__5472_5840;
var G__5925 = chunk__5473_5841;
var G__5926 = count__5474_5842;
var G__5927 = (i__5475_5843 + (1));
seq__5472_5840 = G__5924;
chunk__5473_5841 = G__5925;
count__5474_5842 = G__5926;
i__5475_5843 = G__5927;
continue;
} else {
var temp__5753__auto___5928 = cljs.core.seq.call(null,seq__5472_5840);
if(temp__5753__auto___5928){
var seq__5472_5929__$1 = temp__5753__auto___5928;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5472_5929__$1)){
var c__4649__auto___5930 = cljs.core.chunk_first.call(null,seq__5472_5929__$1);
var G__5931 = cljs.core.chunk_rest.call(null,seq__5472_5929__$1);
var G__5932 = c__4649__auto___5930;
var G__5933 = cljs.core.count.call(null,c__4649__auto___5930);
var G__5934 = (0);
seq__5472_5840 = G__5931;
chunk__5473_5841 = G__5932;
count__5474_5842 = G__5933;
i__5475_5843 = G__5934;
continue;
} else {
var vec__5734_5935 = cljs.core.first.call(null,seq__5472_5929__$1);
var source_idx_5936 = cljs.core.nth.call(null,vec__5734_5935,(0),null);
var vec__5737_5937 = cljs.core.nth.call(null,vec__5734_5935,(1),null);
var __5938 = cljs.core.nth.call(null,vec__5737_5937,(0),null);
var lines_5939__$1 = cljs.core.nth.call(null,vec__5737_5937,(1),null);
var seq__5740_5940 = cljs.core.seq.call(null,lines_5939__$1);
var chunk__5741_5941 = null;
var count__5742_5942 = (0);
var i__5743_5943 = (0);
while(true){
if((i__5743_5943 < count__5742_5942)){
var vec__5782_5944 = cljs.core._nth.call(null,chunk__5741_5941,i__5743_5943);
var line_5945 = cljs.core.nth.call(null,vec__5782_5944,(0),null);
var cols_5946 = cljs.core.nth.call(null,vec__5782_5944,(1),null);
var seq__5785_5947 = cljs.core.seq.call(null,cols_5946);
var chunk__5786_5948 = null;
var count__5787_5949 = (0);
var i__5788_5950 = (0);
while(true){
if((i__5788_5950 < count__5787_5949)){
var vec__5795_5951 = cljs.core._nth.call(null,chunk__5786_5948,i__5788_5950);
var col_5952 = cljs.core.nth.call(null,vec__5795_5951,(0),null);
var infos_5953 = cljs.core.nth.call(null,vec__5795_5951,(1),null);
encode_cols.call(null,infos_5953,source_idx_5936,line_5945,col_5952);


var G__5954 = seq__5785_5947;
var G__5955 = chunk__5786_5948;
var G__5956 = count__5787_5949;
var G__5957 = (i__5788_5950 + (1));
seq__5785_5947 = G__5954;
chunk__5786_5948 = G__5955;
count__5787_5949 = G__5956;
i__5788_5950 = G__5957;
continue;
} else {
var temp__5753__auto___5958__$1 = cljs.core.seq.call(null,seq__5785_5947);
if(temp__5753__auto___5958__$1){
var seq__5785_5959__$1 = temp__5753__auto___5958__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5785_5959__$1)){
var c__4649__auto___5960 = cljs.core.chunk_first.call(null,seq__5785_5959__$1);
var G__5961 = cljs.core.chunk_rest.call(null,seq__5785_5959__$1);
var G__5962 = c__4649__auto___5960;
var G__5963 = cljs.core.count.call(null,c__4649__auto___5960);
var G__5964 = (0);
seq__5785_5947 = G__5961;
chunk__5786_5948 = G__5962;
count__5787_5949 = G__5963;
i__5788_5950 = G__5964;
continue;
} else {
var vec__5798_5965 = cljs.core.first.call(null,seq__5785_5959__$1);
var col_5966 = cljs.core.nth.call(null,vec__5798_5965,(0),null);
var infos_5967 = cljs.core.nth.call(null,vec__5798_5965,(1),null);
encode_cols.call(null,infos_5967,source_idx_5936,line_5945,col_5966);


var G__5968 = cljs.core.next.call(null,seq__5785_5959__$1);
var G__5969 = null;
var G__5970 = (0);
var G__5971 = (0);
seq__5785_5947 = G__5968;
chunk__5786_5948 = G__5969;
count__5787_5949 = G__5970;
i__5788_5950 = G__5971;
continue;
}
} else {
}
}
break;
}


var G__5972 = seq__5740_5940;
var G__5973 = chunk__5741_5941;
var G__5974 = count__5742_5942;
var G__5975 = (i__5743_5943 + (1));
seq__5740_5940 = G__5972;
chunk__5741_5941 = G__5973;
count__5742_5942 = G__5974;
i__5743_5943 = G__5975;
continue;
} else {
var temp__5753__auto___5976__$1 = cljs.core.seq.call(null,seq__5740_5940);
if(temp__5753__auto___5976__$1){
var seq__5740_5977__$1 = temp__5753__auto___5976__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5740_5977__$1)){
var c__4649__auto___5978 = cljs.core.chunk_first.call(null,seq__5740_5977__$1);
var G__5979 = cljs.core.chunk_rest.call(null,seq__5740_5977__$1);
var G__5980 = c__4649__auto___5978;
var G__5981 = cljs.core.count.call(null,c__4649__auto___5978);
var G__5982 = (0);
seq__5740_5940 = G__5979;
chunk__5741_5941 = G__5980;
count__5742_5942 = G__5981;
i__5743_5943 = G__5982;
continue;
} else {
var vec__5801_5983 = cljs.core.first.call(null,seq__5740_5977__$1);
var line_5984 = cljs.core.nth.call(null,vec__5801_5983,(0),null);
var cols_5985 = cljs.core.nth.call(null,vec__5801_5983,(1),null);
var seq__5804_5986 = cljs.core.seq.call(null,cols_5985);
var chunk__5805_5987 = null;
var count__5806_5988 = (0);
var i__5807_5989 = (0);
while(true){
if((i__5807_5989 < count__5806_5988)){
var vec__5814_5990 = cljs.core._nth.call(null,chunk__5805_5987,i__5807_5989);
var col_5991 = cljs.core.nth.call(null,vec__5814_5990,(0),null);
var infos_5992 = cljs.core.nth.call(null,vec__5814_5990,(1),null);
encode_cols.call(null,infos_5992,source_idx_5936,line_5984,col_5991);


var G__5993 = seq__5804_5986;
var G__5994 = chunk__5805_5987;
var G__5995 = count__5806_5988;
var G__5996 = (i__5807_5989 + (1));
seq__5804_5986 = G__5993;
chunk__5805_5987 = G__5994;
count__5806_5988 = G__5995;
i__5807_5989 = G__5996;
continue;
} else {
var temp__5753__auto___5997__$2 = cljs.core.seq.call(null,seq__5804_5986);
if(temp__5753__auto___5997__$2){
var seq__5804_5998__$1 = temp__5753__auto___5997__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5804_5998__$1)){
var c__4649__auto___5999 = cljs.core.chunk_first.call(null,seq__5804_5998__$1);
var G__6000 = cljs.core.chunk_rest.call(null,seq__5804_5998__$1);
var G__6001 = c__4649__auto___5999;
var G__6002 = cljs.core.count.call(null,c__4649__auto___5999);
var G__6003 = (0);
seq__5804_5986 = G__6000;
chunk__5805_5987 = G__6001;
count__5806_5988 = G__6002;
i__5807_5989 = G__6003;
continue;
} else {
var vec__5817_6004 = cljs.core.first.call(null,seq__5804_5998__$1);
var col_6005 = cljs.core.nth.call(null,vec__5817_6004,(0),null);
var infos_6006 = cljs.core.nth.call(null,vec__5817_6004,(1),null);
encode_cols.call(null,infos_6006,source_idx_5936,line_5984,col_6005);


var G__6007 = cljs.core.next.call(null,seq__5804_5998__$1);
var G__6008 = null;
var G__6009 = (0);
var G__6010 = (0);
seq__5804_5986 = G__6007;
chunk__5805_5987 = G__6008;
count__5806_5988 = G__6009;
i__5807_5989 = G__6010;
continue;
}
} else {
}
}
break;
}


var G__6011 = cljs.core.next.call(null,seq__5740_5977__$1);
var G__6012 = null;
var G__6013 = (0);
var G__6014 = (0);
seq__5740_5940 = G__6011;
chunk__5741_5941 = G__6012;
count__5742_5942 = G__6013;
i__5743_5943 = G__6014;
continue;
}
} else {
}
}
break;
}


var G__6015 = cljs.core.next.call(null,seq__5472_5929__$1);
var G__6016 = null;
var G__6017 = (0);
var G__6018 = (0);
seq__5472_5840 = G__6015;
chunk__5473_5841 = G__6016;
count__5474_5842 = G__6017;
i__5475_5843 = G__6018;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__5820 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__5465_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__5465_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__5466_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__5466_SHARP_,/\//));
}));
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,(function (p1__5467_SHARP_){
return clojure.string.join.call(null,",",p1__5467_SHARP_);
}),cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__5821 = G__5820;
goog.object.set(G__5821,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__5821;
} else {
return G__5820;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__6019 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__6019,(0),null);
var col_map = cljs.core.nth.call(null,vec__6019,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__6022 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__6022,(0),null);
var infos = cljs.core.nth.call(null,vec__6022,(1),null);
var G__6027 = cljs.core.next.call(null,col_map_seq);
var G__6028 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__6022,col,infos,vec__6019,line,col_map){
return (function (v,p__6025){
var map__6026 = p__6025;
var map__6026__$1 = cljs.core.__destructure_map.call(null,map__6026);
var gline = cljs.core.get.call(null,map__6026__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__6026__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__6022,col,infos,vec__6019,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__6027;
new_cols = G__6028;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__6029 = cljs.core.next.call(null,line_map_seq);
var G__6030 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__6029;
new_lines = G__6030;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__6031_6239 = cljs.core.seq.call(null,reverse_map);
var chunk__6032_6240 = null;
var count__6033_6241 = (0);
var i__6034_6242 = (0);
while(true){
if((i__6034_6242 < count__6033_6241)){
var vec__6137_6243 = cljs.core._nth.call(null,chunk__6032_6240,i__6034_6242);
var line_6244 = cljs.core.nth.call(null,vec__6137_6243,(0),null);
var columns_6245 = cljs.core.nth.call(null,vec__6137_6243,(1),null);
var seq__6140_6246 = cljs.core.seq.call(null,columns_6245);
var chunk__6141_6247 = null;
var count__6142_6248 = (0);
var i__6143_6249 = (0);
while(true){
if((i__6143_6249 < count__6142_6248)){
var vec__6166_6250 = cljs.core._nth.call(null,chunk__6141_6247,i__6143_6249);
var column_6251 = cljs.core.nth.call(null,vec__6166_6250,(0),null);
var column_info_6252 = cljs.core.nth.call(null,vec__6166_6250,(1),null);
var seq__6169_6253 = cljs.core.seq.call(null,column_info_6252);
var chunk__6170_6254 = null;
var count__6171_6255 = (0);
var i__6172_6256 = (0);
while(true){
if((i__6172_6256 < count__6171_6255)){
var map__6175_6257 = cljs.core._nth.call(null,chunk__6170_6254,i__6172_6256);
var map__6175_6258__$1 = cljs.core.__destructure_map.call(null,map__6175_6257);
var gline_6259 = cljs.core.get.call(null,map__6175_6258__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6260 = cljs.core.get.call(null,map__6175_6258__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6261 = cljs.core.get.call(null,map__6175_6258__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6259], null),cljs.core.fnil.call(null,((function (seq__6169_6253,chunk__6170_6254,count__6171_6255,i__6172_6256,seq__6140_6246,chunk__6141_6247,count__6142_6248,i__6143_6249,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6175_6257,map__6175_6258__$1,gline_6259,gcol_6260,name_6261,vec__6166_6250,column_6251,column_info_6252,vec__6137_6243,line_6244,columns_6245,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6260], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6244,new cljs.core.Keyword(null,"col","col",-1959363084),column_6251,new cljs.core.Keyword(null,"name","name",1843675177),name_6261], null));
});})(seq__6169_6253,chunk__6170_6254,count__6171_6255,i__6172_6256,seq__6140_6246,chunk__6141_6247,count__6142_6248,i__6143_6249,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6175_6257,map__6175_6258__$1,gline_6259,gcol_6260,name_6261,vec__6166_6250,column_6251,column_info_6252,vec__6137_6243,line_6244,columns_6245,inverted))
,cljs.core.sorted_map.call(null)));


var G__6262 = seq__6169_6253;
var G__6263 = chunk__6170_6254;
var G__6264 = count__6171_6255;
var G__6265 = (i__6172_6256 + (1));
seq__6169_6253 = G__6262;
chunk__6170_6254 = G__6263;
count__6171_6255 = G__6264;
i__6172_6256 = G__6265;
continue;
} else {
var temp__5753__auto___6266 = cljs.core.seq.call(null,seq__6169_6253);
if(temp__5753__auto___6266){
var seq__6169_6267__$1 = temp__5753__auto___6266;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6169_6267__$1)){
var c__4649__auto___6268 = cljs.core.chunk_first.call(null,seq__6169_6267__$1);
var G__6269 = cljs.core.chunk_rest.call(null,seq__6169_6267__$1);
var G__6270 = c__4649__auto___6268;
var G__6271 = cljs.core.count.call(null,c__4649__auto___6268);
var G__6272 = (0);
seq__6169_6253 = G__6269;
chunk__6170_6254 = G__6270;
count__6171_6255 = G__6271;
i__6172_6256 = G__6272;
continue;
} else {
var map__6176_6273 = cljs.core.first.call(null,seq__6169_6267__$1);
var map__6176_6274__$1 = cljs.core.__destructure_map.call(null,map__6176_6273);
var gline_6275 = cljs.core.get.call(null,map__6176_6274__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6276 = cljs.core.get.call(null,map__6176_6274__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6277 = cljs.core.get.call(null,map__6176_6274__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6275], null),cljs.core.fnil.call(null,((function (seq__6169_6253,chunk__6170_6254,count__6171_6255,i__6172_6256,seq__6140_6246,chunk__6141_6247,count__6142_6248,i__6143_6249,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6176_6273,map__6176_6274__$1,gline_6275,gcol_6276,name_6277,seq__6169_6267__$1,temp__5753__auto___6266,vec__6166_6250,column_6251,column_info_6252,vec__6137_6243,line_6244,columns_6245,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6276], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6244,new cljs.core.Keyword(null,"col","col",-1959363084),column_6251,new cljs.core.Keyword(null,"name","name",1843675177),name_6277], null));
});})(seq__6169_6253,chunk__6170_6254,count__6171_6255,i__6172_6256,seq__6140_6246,chunk__6141_6247,count__6142_6248,i__6143_6249,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6176_6273,map__6176_6274__$1,gline_6275,gcol_6276,name_6277,seq__6169_6267__$1,temp__5753__auto___6266,vec__6166_6250,column_6251,column_info_6252,vec__6137_6243,line_6244,columns_6245,inverted))
,cljs.core.sorted_map.call(null)));


var G__6278 = cljs.core.next.call(null,seq__6169_6267__$1);
var G__6279 = null;
var G__6280 = (0);
var G__6281 = (0);
seq__6169_6253 = G__6278;
chunk__6170_6254 = G__6279;
count__6171_6255 = G__6280;
i__6172_6256 = G__6281;
continue;
}
} else {
}
}
break;
}


var G__6282 = seq__6140_6246;
var G__6283 = chunk__6141_6247;
var G__6284 = count__6142_6248;
var G__6285 = (i__6143_6249 + (1));
seq__6140_6246 = G__6282;
chunk__6141_6247 = G__6283;
count__6142_6248 = G__6284;
i__6143_6249 = G__6285;
continue;
} else {
var temp__5753__auto___6286 = cljs.core.seq.call(null,seq__6140_6246);
if(temp__5753__auto___6286){
var seq__6140_6287__$1 = temp__5753__auto___6286;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6140_6287__$1)){
var c__4649__auto___6288 = cljs.core.chunk_first.call(null,seq__6140_6287__$1);
var G__6289 = cljs.core.chunk_rest.call(null,seq__6140_6287__$1);
var G__6290 = c__4649__auto___6288;
var G__6291 = cljs.core.count.call(null,c__4649__auto___6288);
var G__6292 = (0);
seq__6140_6246 = G__6289;
chunk__6141_6247 = G__6290;
count__6142_6248 = G__6291;
i__6143_6249 = G__6292;
continue;
} else {
var vec__6177_6293 = cljs.core.first.call(null,seq__6140_6287__$1);
var column_6294 = cljs.core.nth.call(null,vec__6177_6293,(0),null);
var column_info_6295 = cljs.core.nth.call(null,vec__6177_6293,(1),null);
var seq__6180_6296 = cljs.core.seq.call(null,column_info_6295);
var chunk__6181_6297 = null;
var count__6182_6298 = (0);
var i__6183_6299 = (0);
while(true){
if((i__6183_6299 < count__6182_6298)){
var map__6186_6300 = cljs.core._nth.call(null,chunk__6181_6297,i__6183_6299);
var map__6186_6301__$1 = cljs.core.__destructure_map.call(null,map__6186_6300);
var gline_6302 = cljs.core.get.call(null,map__6186_6301__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6303 = cljs.core.get.call(null,map__6186_6301__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6304 = cljs.core.get.call(null,map__6186_6301__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6302], null),cljs.core.fnil.call(null,((function (seq__6180_6296,chunk__6181_6297,count__6182_6298,i__6183_6299,seq__6140_6246,chunk__6141_6247,count__6142_6248,i__6143_6249,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6186_6300,map__6186_6301__$1,gline_6302,gcol_6303,name_6304,vec__6177_6293,column_6294,column_info_6295,seq__6140_6287__$1,temp__5753__auto___6286,vec__6137_6243,line_6244,columns_6245,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6303], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6244,new cljs.core.Keyword(null,"col","col",-1959363084),column_6294,new cljs.core.Keyword(null,"name","name",1843675177),name_6304], null));
});})(seq__6180_6296,chunk__6181_6297,count__6182_6298,i__6183_6299,seq__6140_6246,chunk__6141_6247,count__6142_6248,i__6143_6249,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6186_6300,map__6186_6301__$1,gline_6302,gcol_6303,name_6304,vec__6177_6293,column_6294,column_info_6295,seq__6140_6287__$1,temp__5753__auto___6286,vec__6137_6243,line_6244,columns_6245,inverted))
,cljs.core.sorted_map.call(null)));


var G__6305 = seq__6180_6296;
var G__6306 = chunk__6181_6297;
var G__6307 = count__6182_6298;
var G__6308 = (i__6183_6299 + (1));
seq__6180_6296 = G__6305;
chunk__6181_6297 = G__6306;
count__6182_6298 = G__6307;
i__6183_6299 = G__6308;
continue;
} else {
var temp__5753__auto___6309__$1 = cljs.core.seq.call(null,seq__6180_6296);
if(temp__5753__auto___6309__$1){
var seq__6180_6310__$1 = temp__5753__auto___6309__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6180_6310__$1)){
var c__4649__auto___6311 = cljs.core.chunk_first.call(null,seq__6180_6310__$1);
var G__6312 = cljs.core.chunk_rest.call(null,seq__6180_6310__$1);
var G__6313 = c__4649__auto___6311;
var G__6314 = cljs.core.count.call(null,c__4649__auto___6311);
var G__6315 = (0);
seq__6180_6296 = G__6312;
chunk__6181_6297 = G__6313;
count__6182_6298 = G__6314;
i__6183_6299 = G__6315;
continue;
} else {
var map__6187_6316 = cljs.core.first.call(null,seq__6180_6310__$1);
var map__6187_6317__$1 = cljs.core.__destructure_map.call(null,map__6187_6316);
var gline_6318 = cljs.core.get.call(null,map__6187_6317__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6319 = cljs.core.get.call(null,map__6187_6317__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6320 = cljs.core.get.call(null,map__6187_6317__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6318], null),cljs.core.fnil.call(null,((function (seq__6180_6296,chunk__6181_6297,count__6182_6298,i__6183_6299,seq__6140_6246,chunk__6141_6247,count__6142_6248,i__6143_6249,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6187_6316,map__6187_6317__$1,gline_6318,gcol_6319,name_6320,seq__6180_6310__$1,temp__5753__auto___6309__$1,vec__6177_6293,column_6294,column_info_6295,seq__6140_6287__$1,temp__5753__auto___6286,vec__6137_6243,line_6244,columns_6245,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6319], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6244,new cljs.core.Keyword(null,"col","col",-1959363084),column_6294,new cljs.core.Keyword(null,"name","name",1843675177),name_6320], null));
});})(seq__6180_6296,chunk__6181_6297,count__6182_6298,i__6183_6299,seq__6140_6246,chunk__6141_6247,count__6142_6248,i__6143_6249,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6187_6316,map__6187_6317__$1,gline_6318,gcol_6319,name_6320,seq__6180_6310__$1,temp__5753__auto___6309__$1,vec__6177_6293,column_6294,column_info_6295,seq__6140_6287__$1,temp__5753__auto___6286,vec__6137_6243,line_6244,columns_6245,inverted))
,cljs.core.sorted_map.call(null)));


var G__6321 = cljs.core.next.call(null,seq__6180_6310__$1);
var G__6322 = null;
var G__6323 = (0);
var G__6324 = (0);
seq__6180_6296 = G__6321;
chunk__6181_6297 = G__6322;
count__6182_6298 = G__6323;
i__6183_6299 = G__6324;
continue;
}
} else {
}
}
break;
}


var G__6325 = cljs.core.next.call(null,seq__6140_6287__$1);
var G__6326 = null;
var G__6327 = (0);
var G__6328 = (0);
seq__6140_6246 = G__6325;
chunk__6141_6247 = G__6326;
count__6142_6248 = G__6327;
i__6143_6249 = G__6328;
continue;
}
} else {
}
}
break;
}


var G__6329 = seq__6031_6239;
var G__6330 = chunk__6032_6240;
var G__6331 = count__6033_6241;
var G__6332 = (i__6034_6242 + (1));
seq__6031_6239 = G__6329;
chunk__6032_6240 = G__6330;
count__6033_6241 = G__6331;
i__6034_6242 = G__6332;
continue;
} else {
var temp__5753__auto___6333 = cljs.core.seq.call(null,seq__6031_6239);
if(temp__5753__auto___6333){
var seq__6031_6334__$1 = temp__5753__auto___6333;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6031_6334__$1)){
var c__4649__auto___6335 = cljs.core.chunk_first.call(null,seq__6031_6334__$1);
var G__6336 = cljs.core.chunk_rest.call(null,seq__6031_6334__$1);
var G__6337 = c__4649__auto___6335;
var G__6338 = cljs.core.count.call(null,c__4649__auto___6335);
var G__6339 = (0);
seq__6031_6239 = G__6336;
chunk__6032_6240 = G__6337;
count__6033_6241 = G__6338;
i__6034_6242 = G__6339;
continue;
} else {
var vec__6188_6340 = cljs.core.first.call(null,seq__6031_6334__$1);
var line_6341 = cljs.core.nth.call(null,vec__6188_6340,(0),null);
var columns_6342 = cljs.core.nth.call(null,vec__6188_6340,(1),null);
var seq__6191_6343 = cljs.core.seq.call(null,columns_6342);
var chunk__6192_6344 = null;
var count__6193_6345 = (0);
var i__6194_6346 = (0);
while(true){
if((i__6194_6346 < count__6193_6345)){
var vec__6217_6347 = cljs.core._nth.call(null,chunk__6192_6344,i__6194_6346);
var column_6348 = cljs.core.nth.call(null,vec__6217_6347,(0),null);
var column_info_6349 = cljs.core.nth.call(null,vec__6217_6347,(1),null);
var seq__6220_6350 = cljs.core.seq.call(null,column_info_6349);
var chunk__6221_6351 = null;
var count__6222_6352 = (0);
var i__6223_6353 = (0);
while(true){
if((i__6223_6353 < count__6222_6352)){
var map__6226_6354 = cljs.core._nth.call(null,chunk__6221_6351,i__6223_6353);
var map__6226_6355__$1 = cljs.core.__destructure_map.call(null,map__6226_6354);
var gline_6356 = cljs.core.get.call(null,map__6226_6355__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6357 = cljs.core.get.call(null,map__6226_6355__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6358 = cljs.core.get.call(null,map__6226_6355__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6356], null),cljs.core.fnil.call(null,((function (seq__6220_6350,chunk__6221_6351,count__6222_6352,i__6223_6353,seq__6191_6343,chunk__6192_6344,count__6193_6345,i__6194_6346,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6226_6354,map__6226_6355__$1,gline_6356,gcol_6357,name_6358,vec__6217_6347,column_6348,column_info_6349,vec__6188_6340,line_6341,columns_6342,seq__6031_6334__$1,temp__5753__auto___6333,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6357], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6341,new cljs.core.Keyword(null,"col","col",-1959363084),column_6348,new cljs.core.Keyword(null,"name","name",1843675177),name_6358], null));
});})(seq__6220_6350,chunk__6221_6351,count__6222_6352,i__6223_6353,seq__6191_6343,chunk__6192_6344,count__6193_6345,i__6194_6346,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6226_6354,map__6226_6355__$1,gline_6356,gcol_6357,name_6358,vec__6217_6347,column_6348,column_info_6349,vec__6188_6340,line_6341,columns_6342,seq__6031_6334__$1,temp__5753__auto___6333,inverted))
,cljs.core.sorted_map.call(null)));


var G__6359 = seq__6220_6350;
var G__6360 = chunk__6221_6351;
var G__6361 = count__6222_6352;
var G__6362 = (i__6223_6353 + (1));
seq__6220_6350 = G__6359;
chunk__6221_6351 = G__6360;
count__6222_6352 = G__6361;
i__6223_6353 = G__6362;
continue;
} else {
var temp__5753__auto___6363__$1 = cljs.core.seq.call(null,seq__6220_6350);
if(temp__5753__auto___6363__$1){
var seq__6220_6364__$1 = temp__5753__auto___6363__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6220_6364__$1)){
var c__4649__auto___6365 = cljs.core.chunk_first.call(null,seq__6220_6364__$1);
var G__6366 = cljs.core.chunk_rest.call(null,seq__6220_6364__$1);
var G__6367 = c__4649__auto___6365;
var G__6368 = cljs.core.count.call(null,c__4649__auto___6365);
var G__6369 = (0);
seq__6220_6350 = G__6366;
chunk__6221_6351 = G__6367;
count__6222_6352 = G__6368;
i__6223_6353 = G__6369;
continue;
} else {
var map__6227_6370 = cljs.core.first.call(null,seq__6220_6364__$1);
var map__6227_6371__$1 = cljs.core.__destructure_map.call(null,map__6227_6370);
var gline_6372 = cljs.core.get.call(null,map__6227_6371__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6373 = cljs.core.get.call(null,map__6227_6371__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6374 = cljs.core.get.call(null,map__6227_6371__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6372], null),cljs.core.fnil.call(null,((function (seq__6220_6350,chunk__6221_6351,count__6222_6352,i__6223_6353,seq__6191_6343,chunk__6192_6344,count__6193_6345,i__6194_6346,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6227_6370,map__6227_6371__$1,gline_6372,gcol_6373,name_6374,seq__6220_6364__$1,temp__5753__auto___6363__$1,vec__6217_6347,column_6348,column_info_6349,vec__6188_6340,line_6341,columns_6342,seq__6031_6334__$1,temp__5753__auto___6333,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6373], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6341,new cljs.core.Keyword(null,"col","col",-1959363084),column_6348,new cljs.core.Keyword(null,"name","name",1843675177),name_6374], null));
});})(seq__6220_6350,chunk__6221_6351,count__6222_6352,i__6223_6353,seq__6191_6343,chunk__6192_6344,count__6193_6345,i__6194_6346,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6227_6370,map__6227_6371__$1,gline_6372,gcol_6373,name_6374,seq__6220_6364__$1,temp__5753__auto___6363__$1,vec__6217_6347,column_6348,column_info_6349,vec__6188_6340,line_6341,columns_6342,seq__6031_6334__$1,temp__5753__auto___6333,inverted))
,cljs.core.sorted_map.call(null)));


var G__6375 = cljs.core.next.call(null,seq__6220_6364__$1);
var G__6376 = null;
var G__6377 = (0);
var G__6378 = (0);
seq__6220_6350 = G__6375;
chunk__6221_6351 = G__6376;
count__6222_6352 = G__6377;
i__6223_6353 = G__6378;
continue;
}
} else {
}
}
break;
}


var G__6379 = seq__6191_6343;
var G__6380 = chunk__6192_6344;
var G__6381 = count__6193_6345;
var G__6382 = (i__6194_6346 + (1));
seq__6191_6343 = G__6379;
chunk__6192_6344 = G__6380;
count__6193_6345 = G__6381;
i__6194_6346 = G__6382;
continue;
} else {
var temp__5753__auto___6383__$1 = cljs.core.seq.call(null,seq__6191_6343);
if(temp__5753__auto___6383__$1){
var seq__6191_6384__$1 = temp__5753__auto___6383__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6191_6384__$1)){
var c__4649__auto___6385 = cljs.core.chunk_first.call(null,seq__6191_6384__$1);
var G__6386 = cljs.core.chunk_rest.call(null,seq__6191_6384__$1);
var G__6387 = c__4649__auto___6385;
var G__6388 = cljs.core.count.call(null,c__4649__auto___6385);
var G__6389 = (0);
seq__6191_6343 = G__6386;
chunk__6192_6344 = G__6387;
count__6193_6345 = G__6388;
i__6194_6346 = G__6389;
continue;
} else {
var vec__6228_6390 = cljs.core.first.call(null,seq__6191_6384__$1);
var column_6391 = cljs.core.nth.call(null,vec__6228_6390,(0),null);
var column_info_6392 = cljs.core.nth.call(null,vec__6228_6390,(1),null);
var seq__6231_6393 = cljs.core.seq.call(null,column_info_6392);
var chunk__6232_6394 = null;
var count__6233_6395 = (0);
var i__6234_6396 = (0);
while(true){
if((i__6234_6396 < count__6233_6395)){
var map__6237_6397 = cljs.core._nth.call(null,chunk__6232_6394,i__6234_6396);
var map__6237_6398__$1 = cljs.core.__destructure_map.call(null,map__6237_6397);
var gline_6399 = cljs.core.get.call(null,map__6237_6398__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6400 = cljs.core.get.call(null,map__6237_6398__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6401 = cljs.core.get.call(null,map__6237_6398__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6399], null),cljs.core.fnil.call(null,((function (seq__6231_6393,chunk__6232_6394,count__6233_6395,i__6234_6396,seq__6191_6343,chunk__6192_6344,count__6193_6345,i__6194_6346,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6237_6397,map__6237_6398__$1,gline_6399,gcol_6400,name_6401,vec__6228_6390,column_6391,column_info_6392,seq__6191_6384__$1,temp__5753__auto___6383__$1,vec__6188_6340,line_6341,columns_6342,seq__6031_6334__$1,temp__5753__auto___6333,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6400], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6341,new cljs.core.Keyword(null,"col","col",-1959363084),column_6391,new cljs.core.Keyword(null,"name","name",1843675177),name_6401], null));
});})(seq__6231_6393,chunk__6232_6394,count__6233_6395,i__6234_6396,seq__6191_6343,chunk__6192_6344,count__6193_6345,i__6194_6346,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6237_6397,map__6237_6398__$1,gline_6399,gcol_6400,name_6401,vec__6228_6390,column_6391,column_info_6392,seq__6191_6384__$1,temp__5753__auto___6383__$1,vec__6188_6340,line_6341,columns_6342,seq__6031_6334__$1,temp__5753__auto___6333,inverted))
,cljs.core.sorted_map.call(null)));


var G__6402 = seq__6231_6393;
var G__6403 = chunk__6232_6394;
var G__6404 = count__6233_6395;
var G__6405 = (i__6234_6396 + (1));
seq__6231_6393 = G__6402;
chunk__6232_6394 = G__6403;
count__6233_6395 = G__6404;
i__6234_6396 = G__6405;
continue;
} else {
var temp__5753__auto___6406__$2 = cljs.core.seq.call(null,seq__6231_6393);
if(temp__5753__auto___6406__$2){
var seq__6231_6407__$1 = temp__5753__auto___6406__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6231_6407__$1)){
var c__4649__auto___6408 = cljs.core.chunk_first.call(null,seq__6231_6407__$1);
var G__6409 = cljs.core.chunk_rest.call(null,seq__6231_6407__$1);
var G__6410 = c__4649__auto___6408;
var G__6411 = cljs.core.count.call(null,c__4649__auto___6408);
var G__6412 = (0);
seq__6231_6393 = G__6409;
chunk__6232_6394 = G__6410;
count__6233_6395 = G__6411;
i__6234_6396 = G__6412;
continue;
} else {
var map__6238_6413 = cljs.core.first.call(null,seq__6231_6407__$1);
var map__6238_6414__$1 = cljs.core.__destructure_map.call(null,map__6238_6413);
var gline_6415 = cljs.core.get.call(null,map__6238_6414__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6416 = cljs.core.get.call(null,map__6238_6414__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6417 = cljs.core.get.call(null,map__6238_6414__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6415], null),cljs.core.fnil.call(null,((function (seq__6231_6393,chunk__6232_6394,count__6233_6395,i__6234_6396,seq__6191_6343,chunk__6192_6344,count__6193_6345,i__6194_6346,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6238_6413,map__6238_6414__$1,gline_6415,gcol_6416,name_6417,seq__6231_6407__$1,temp__5753__auto___6406__$2,vec__6228_6390,column_6391,column_info_6392,seq__6191_6384__$1,temp__5753__auto___6383__$1,vec__6188_6340,line_6341,columns_6342,seq__6031_6334__$1,temp__5753__auto___6333,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6416], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6341,new cljs.core.Keyword(null,"col","col",-1959363084),column_6391,new cljs.core.Keyword(null,"name","name",1843675177),name_6417], null));
});})(seq__6231_6393,chunk__6232_6394,count__6233_6395,i__6234_6396,seq__6191_6343,chunk__6192_6344,count__6193_6345,i__6194_6346,seq__6031_6239,chunk__6032_6240,count__6033_6241,i__6034_6242,map__6238_6413,map__6238_6414__$1,gline_6415,gcol_6416,name_6417,seq__6231_6407__$1,temp__5753__auto___6406__$2,vec__6228_6390,column_6391,column_info_6392,seq__6191_6384__$1,temp__5753__auto___6383__$1,vec__6188_6340,line_6341,columns_6342,seq__6031_6334__$1,temp__5753__auto___6333,inverted))
,cljs.core.sorted_map.call(null)));


var G__6418 = cljs.core.next.call(null,seq__6231_6407__$1);
var G__6419 = null;
var G__6420 = (0);
var G__6421 = (0);
seq__6231_6393 = G__6418;
chunk__6232_6394 = G__6419;
count__6233_6395 = G__6420;
i__6234_6396 = G__6421;
continue;
}
} else {
}
}
break;
}


var G__6422 = cljs.core.next.call(null,seq__6191_6384__$1);
var G__6423 = null;
var G__6424 = (0);
var G__6425 = (0);
seq__6191_6343 = G__6422;
chunk__6192_6344 = G__6423;
count__6193_6345 = G__6424;
i__6194_6346 = G__6425;
continue;
}
} else {
}
}
break;
}


var G__6426 = cljs.core.next.call(null,seq__6031_6334__$1);
var G__6427 = null;
var G__6428 = (0);
var G__6429 = (0);
seq__6031_6239 = G__6426;
chunk__6032_6240 = G__6427;
count__6033_6241 = G__6428;
i__6034_6242 = G__6429;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});
