// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.crypto.pkcs7');
goog.require('cljs.core');
goog.require('goog.array');
fluree.crypto.pkcs7.byte_QMARK_ = (function fluree$crypto$pkcs7$byte_QMARK_(b){
return ((typeof b === 'number') && ((((b >= (0))) && ((((b <= (255))) && (((b - Math.floor(b)) === (0))))))));
});
fluree.crypto.pkcs7.bytes_QMARK_ = (function fluree$crypto$pkcs7$bytes_QMARK_(bytes){
return cljs.core.every_QMARK_.call(null,fluree.crypto.pkcs7.byte_QMARK_,bytes);
});
fluree.crypto.pkcs7.compare_bytes = (function fluree$crypto$pkcs7$compare_bytes(ba1,ba2){
if(cljs.core.not_EQ_.call(null,ba1.length,ba2.length)){
return false;
} else {
if((((!(fluree.crypto.pkcs7.bytes_QMARK_.call(null,ba1)))) || ((!(fluree.crypto.pkcs7.bytes_QMARK_.call(null,ba2)))))){
return false;
} else {
return cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core._EQ_,ba1,ba2));
}
}
});
fluree.crypto.pkcs7.encode = (function fluree$crypto$pkcs7$encode(k,m){
var n = (k - cljs.core.mod.call(null,m.length,k));
return m.concat(goog.array.repeat(n,n));
});
fluree.crypto.pkcs7.decode = (function fluree$crypto$pkcs7$decode(k,m){
var len = m.length;
var last_byte = (m[(len - (1))]);
var error = (((last_byte > len)) || ((((last_byte > k)) || ((((last_byte === (0))) || ((!((cljs.core.mod.call(null,len,k) === (0))))))))));
if(error){
throw (new Error(["invalid pkcs7 encoding: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(m)].join('')));
} else {
}

var computed = goog.array.repeat(last_byte,last_byte);
var provided = goog.array.slice(m,(len - last_byte));
if(fluree.crypto.pkcs7.compare_bytes.call(null,computed,provided)){
} else {
throw (new Error("paddings don't match"));
}

return goog.array.slice(m,(0),(len - last_byte));
});
