// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('goog.string.format');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4835__auto__ = [];
var len__4829__auto___63722 = arguments.length;
var i__4830__auto___63723 = (0);
while(true){
if((i__4830__auto___63723 < len__4829__auto___63722)){
args__4835__auto__.push((arguments[i__4830__auto___63723]));

var G__63724 = (i__4830__auto___63723 + (1));
i__4830__auto___63723 = G__63724;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__63654){
var vec__63655 = p__63654;
var opts = cljs.core.nth.call(null,vec__63655,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2748__auto___63725 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_63699){
var state_val_63700 = (state_63699[(1)]);
if((state_val_63700 === (7))){
var inst_63685 = (state_63699[(7)]);
var inst_63676 = (state_63699[(8)]);
var inst_63687 = fluree.db.time_travel.as_of_block.call(null,inst_63685,inst_63676);
var state_63699__$1 = state_63699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63699__$1,(10),inst_63687);
} else {
if((state_val_63700 === (1))){
var state_63699__$1 = state_63699;
var statearr_63701_63726 = state_63699__$1;
(statearr_63701_63726[(2)] = null);

(statearr_63701_63726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63700 === (4))){
var inst_63658 = (state_63699[(2)]);
var inst_63659 = fluree.db.util.log.error.call(null,inst_63658);
var inst_63660 = cljs.core.async.put_BANG_.call(null,pc,inst_63658);
var inst_63661 = cljs.core.async.close_BANG_.call(null,pc);
var state_63699__$1 = (function (){var statearr_63702 = state_63699;
(statearr_63702[(9)] = inst_63659);

(statearr_63702[(10)] = inst_63660);

return statearr_63702;
})();
var statearr_63703_63727 = state_63699__$1;
(statearr_63703_63727[(2)] = inst_63661);

(statearr_63703_63727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63700 === (6))){
var inst_63679 = (state_63699[(11)]);
var inst_63676 = (state_63699[(8)]);
var inst_63680 = (state_63699[(12)]);
var inst_63683 = (state_63699[(2)]);
var inst_63684 = fluree.db.util.async.throw_err.call(null,inst_63683);
var inst_63685 = cljs.core.assoc.call(null,inst_63684,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_63679,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_63680);
var state_63699__$1 = (function (){var statearr_63704 = state_63699;
(statearr_63704[(7)] = inst_63685);

return statearr_63704;
})();
if(cljs.core.truth_(inst_63676)){
var statearr_63705_63728 = state_63699__$1;
(statearr_63705_63728[(1)] = (7));

} else {
var statearr_63706_63729 = state_63699__$1;
(statearr_63706_63729[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63700 === (3))){
var inst_63697 = (state_63699[(2)]);
var state_63699__$1 = state_63699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63699__$1,inst_63697);
} else {
if((state_val_63700 === (2))){
var _ = (function (){var statearr_63708 = state_63699;
(statearr_63708[(4)] = cljs.core.cons.call(null,(5),(state_63699[(4)])));

return statearr_63708;
})();
var inst_63671 = opts;
var inst_63672 = cljs.core.__destructure_map.call(null,inst_63671);
var inst_63673 = cljs.core.get.call(null,inst_63672,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_63674 = cljs.core.get.call(null,inst_63672,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_63675 = cljs.core.get.call(null,inst_63672,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_63676 = cljs.core.get.call(null,inst_63672,new cljs.core.Keyword(null,"block","block",664686210));
var inst_63677 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_63678 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_63679 = cljs.core.nth.call(null,inst_63678,(0),null);
var inst_63680 = cljs.core.nth.call(null,inst_63678,(1),null);
var inst_63681 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_63699__$1 = (function (){var statearr_63709 = state_63699;
(statearr_63709[(13)] = inst_63677);

(statearr_63709[(14)] = inst_63674);

(statearr_63709[(15)] = inst_63673);

(statearr_63709[(11)] = inst_63679);

(statearr_63709[(16)] = inst_63675);

(statearr_63709[(8)] = inst_63676);

(statearr_63709[(12)] = inst_63680);

return statearr_63709;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63699__$1,(6),inst_63681);
} else {
if((state_val_63700 === (9))){
var inst_63693 = (state_63699[(2)]);
var inst_63694 = cljs.core.async.put_BANG_.call(null,pc,inst_63693);
var _ = (function (){var statearr_63710 = state_63699;
(statearr_63710[(4)] = cljs.core.rest.call(null,(state_63699[(4)])));

return statearr_63710;
})();
var state_63699__$1 = state_63699;
var statearr_63711_63730 = state_63699__$1;
(statearr_63711_63730[(2)] = inst_63694);

(statearr_63711_63730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63700 === (5))){
var _ = (function (){var statearr_63712 = state_63699;
(statearr_63712[(4)] = cljs.core.rest.call(null,(state_63699[(4)])));

return statearr_63712;
})();
var state_63699__$1 = state_63699;
var ex63707 = (state_63699__$1[(2)]);
var statearr_63713_63731 = state_63699__$1;
(statearr_63713_63731[(5)] = ex63707);


var statearr_63714_63732 = state_63699__$1;
(statearr_63714_63732[(1)] = (4));

(statearr_63714_63732[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63700 === (10))){
var inst_63689 = (state_63699[(2)]);
var inst_63690 = fluree.db.util.async.throw_err.call(null,inst_63689);
var state_63699__$1 = state_63699;
var statearr_63715_63733 = state_63699__$1;
(statearr_63715_63733[(2)] = inst_63690);

(statearr_63715_63733[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63700 === (8))){
var inst_63685 = (state_63699[(7)]);
var state_63699__$1 = state_63699;
var statearr_63716_63734 = state_63699__$1;
(statearr_63716_63734[(2)] = inst_63685);

(statearr_63716_63734[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2726__auto__ = null;
var fluree$db$api_js$state_machine__2726__auto____0 = (function (){
var statearr_63717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63717[(0)] = fluree$db$api_js$state_machine__2726__auto__);

(statearr_63717[(1)] = (1));

return statearr_63717;
});
var fluree$db$api_js$state_machine__2726__auto____1 = (function (state_63699){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_63699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e63718){var ex__2729__auto__ = e63718;
var statearr_63719_63735 = state_63699;
(statearr_63719_63735[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_63699[(4)]))){
var statearr_63720_63736 = state_63699;
(statearr_63720_63736[(1)] = cljs.core.first.call(null,(state_63699[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63737 = state_63699;
state_63699 = G__63737;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2726__auto__ = function(state_63699){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2726__auto____1.call(this,state_63699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2726__auto____0;
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2726__auto____1;
return fluree$db$api_js$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_63721 = f__2749__auto__.call(null);
(statearr_63721[(6)] = c__2748__auto___63725);

return statearr_63721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq63651){
var G__63652 = cljs.core.first.call(null,seq63651);
var seq63651__$1 = cljs.core.next.call(null,seq63651);
var G__63653 = cljs.core.first.call(null,seq63651__$1);
var seq63651__$2 = cljs.core.next.call(null,seq63651__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63652,G__63653,seq63651__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4221__auto__){
var and__4221__auto____$1 = open_api;
if(cljs.core.truth_(and__4221__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4221__auto__){
return open_api;
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4221__auto__){
return auth;
} else {
return and__4221__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__63740 = arguments.length;
switch (G__63740) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_63870){
var state_val_63871 = (state_63870[(1)]);
if((state_val_63871 === (7))){
var inst_63756 = (state_63870[(7)]);
var inst_63766 = (state_63870[(8)]);
var inst_63768 = fluree.db.time_travel.as_of_block.call(null,inst_63766,inst_63756);
var state_63870__$1 = state_63870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63870__$1,(10),inst_63768);
} else {
if((state_val_63871 === (20))){
var inst_63760 = (state_63870[(9)]);
var state_63870__$1 = state_63870;
var statearr_63872_63953 = state_63870__$1;
(statearr_63872_63953[(2)] = inst_63760);

(statearr_63872_63953[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (27))){
var inst_63754 = (state_63870[(10)]);
var state_63870__$1 = state_63870;
var statearr_63873_63954 = state_63870__$1;
(statearr_63873_63954[(2)] = inst_63754);

(statearr_63873_63954[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (1))){
var state_63870__$1 = state_63870;
var statearr_63874_63955 = state_63870__$1;
(statearr_63874_63955[(2)] = null);

(statearr_63874_63955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (24))){
var inst_63763 = (state_63870[(11)]);
var state_63870__$1 = state_63870;
if(cljs.core.truth_(inst_63763)){
var statearr_63875_63956 = state_63870__$1;
(statearr_63875_63956[(1)] = (26));

} else {
var statearr_63876_63957 = state_63870__$1;
(statearr_63876_63957[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (39))){
var inst_63828 = (state_63870[(12)]);
var inst_63831 = cljs.core.ex_data.call(null,inst_63828);
var inst_63832 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63833 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_63831);
var inst_63834 = cljs.core.ex_message.call(null,inst_63828);
var inst_63835 = [inst_63833,inst_63834,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63836 = cljs.core.PersistentHashMap.fromArrays(inst_63832,inst_63835);
var state_63870__$1 = state_63870;
var statearr_63877_63958 = state_63870__$1;
(statearr_63877_63958[(2)] = inst_63836);

(statearr_63877_63958[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (46))){
var inst_63828 = (state_63870[(12)]);
var state_63870__$1 = state_63870;
var statearr_63878_63959 = state_63870__$1;
(statearr_63878_63959[(2)] = inst_63828);

(statearr_63878_63959[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (4))){
var inst_63741 = (state_63870[(2)]);
var inst_63742 = fluree.db.util.log.error.call(null,inst_63741);
var inst_63743 = cljs.core.ex_data.call(null,inst_63741);
var inst_63744 = cljs.core.ex_message.call(null,inst_63741);
var inst_63745 = cljs.core.assoc.call(null,inst_63743,new cljs.core.Keyword(null,"message","message",-406056002),inst_63744);
var state_63870__$1 = (function (){var statearr_63879 = state_63870;
(statearr_63879[(13)] = inst_63742);

return statearr_63879;
})();
var statearr_63880_63960 = state_63870__$1;
(statearr_63880_63960[(2)] = inst_63745);

(statearr_63880_63960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (15))){
var state_63870__$1 = state_63870;
var statearr_63881_63961 = state_63870__$1;
(statearr_63881_63961[(2)] = (1000000));

(statearr_63881_63961[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (48))){
var inst_63828 = (state_63870[(12)]);
var state_63870__$1 = state_63870;
var statearr_63882_63962 = state_63870__$1;
(statearr_63882_63962[(2)] = inst_63828);

(statearr_63882_63962[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (50))){
var inst_63859 = (state_63870[(2)]);
var state_63870__$1 = state_63870;
var statearr_63883_63963 = state_63870__$1;
(statearr_63883_63963[(2)] = inst_63859);

(statearr_63883_63963[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (21))){
var inst_63759 = (state_63870[(14)]);
var state_63870__$1 = state_63870;
if(cljs.core.truth_(inst_63759)){
var statearr_63884_63964 = state_63870__$1;
(statearr_63884_63964[(1)] = (23));

} else {
var statearr_63885_63965 = state_63870__$1;
(statearr_63885_63965[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (31))){
var inst_63817 = (state_63870[(15)]);
var inst_63817__$1 = (state_63870[(2)]);
var inst_63818 = cljs.core.not.call(null,inst_63817__$1);
var state_63870__$1 = (function (){var statearr_63886 = state_63870;
(statearr_63886[(15)] = inst_63817__$1);

return statearr_63886;
})();
if(inst_63818){
var statearr_63887_63966 = state_63870__$1;
(statearr_63887_63966[(1)] = (35));

} else {
var statearr_63888_63967 = state_63870__$1;
(statearr_63888_63967[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (32))){
var inst_63761 = (state_63870[(16)]);
var state_63870__$1 = state_63870;
var statearr_63889_63968 = state_63870__$1;
(statearr_63889_63968[(2)] = inst_63761);

(statearr_63889_63968[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (40))){
var inst_63791 = (state_63870[(17)]);
var state_63870__$1 = state_63870;
if(cljs.core.truth_(inst_63791)){
var statearr_63890_63969 = state_63870__$1;
(statearr_63890_63969[(1)] = (42));

} else {
var statearr_63891_63970 = state_63870__$1;
(statearr_63891_63970[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (33))){
var inst_63757 = (state_63870[(18)]);
var state_63870__$1 = state_63870;
var statearr_63892_63971 = state_63870__$1;
(statearr_63892_63971[(2)] = inst_63757);

(statearr_63892_63971[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (13))){
var inst_63762 = (state_63870[(19)]);
var inst_63786 = (state_63870[(20)]);
var inst_63784 = (state_63870[(2)]);
var inst_63785 = cljs.core.volatile_BANG_.call(null,(0));
var inst_63786__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_63762);
var state_63870__$1 = (function (){var statearr_63893 = state_63870;
(statearr_63893[(21)] = inst_63785);

(statearr_63893[(22)] = inst_63784);

(statearr_63893[(20)] = inst_63786__$1);

return statearr_63893;
})();
if(cljs.core.truth_(inst_63786__$1)){
var statearr_63894_63972 = state_63870__$1;
(statearr_63894_63972[(1)] = (14));

} else {
var statearr_63895_63973 = state_63870__$1;
(statearr_63895_63973[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (22))){
var inst_63807 = (state_63870[(2)]);
var state_63870__$1 = state_63870;
var statearr_63896_63974 = state_63870__$1;
(statearr_63896_63974[(2)] = inst_63807);

(statearr_63896_63974[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (36))){
var inst_63793 = (state_63870[(23)]);
var inst_63774 = (state_63870[(24)]);
var inst_63824 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_63793);
var inst_63825 = fluree.db.query.fql.query.call(null,inst_63774,inst_63824);
var state_63870__$1 = state_63870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63870__$1,(38),inst_63825);
} else {
if((state_val_63871 === (41))){
var inst_63863 = (state_63870[(2)]);
var state_63870__$1 = state_63870;
var statearr_63897_63975 = state_63870__$1;
(statearr_63897_63975[(2)] = inst_63863);

(statearr_63897_63975[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (43))){
var state_63870__$1 = state_63870;
var statearr_63898_63976 = state_63870__$1;
(statearr_63898_63976[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (29))){
var inst_63761 = (state_63870[(16)]);
var state_63870__$1 = state_63870;
if(cljs.core.truth_(inst_63761)){
var statearr_63900_63977 = state_63870__$1;
(statearr_63900_63977[(1)] = (32));

} else {
var statearr_63901_63978 = state_63870__$1;
(statearr_63901_63978[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (44))){
var inst_63861 = (state_63870[(2)]);
var state_63870__$1 = state_63870;
var statearr_63902_63979 = state_63870__$1;
(statearr_63902_63979[(2)] = inst_63861);

(statearr_63902_63979[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (6))){
var inst_63756 = (state_63870[(7)]);
var inst_63765 = (state_63870[(2)]);
var inst_63766 = fluree.db.util.async.throw_err.call(null,inst_63765);
var state_63870__$1 = (function (){var statearr_63903 = state_63870;
(statearr_63903[(8)] = inst_63766);

return statearr_63903;
})();
if(cljs.core.truth_(inst_63756)){
var statearr_63904_63980 = state_63870__$1;
(statearr_63904_63980[(1)] = (7));

} else {
var statearr_63905_63981 = state_63870__$1;
(statearr_63905_63981[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (28))){
var inst_63803 = (state_63870[(2)]);
var state_63870__$1 = state_63870;
var statearr_63906_63982 = state_63870__$1;
(statearr_63906_63982[(2)] = inst_63803);

(statearr_63906_63982[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (25))){
var inst_63805 = (state_63870[(2)]);
var state_63870__$1 = state_63870;
var statearr_63907_63983 = state_63870__$1;
(statearr_63907_63983[(2)] = inst_63805);

(statearr_63907_63983[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (34))){
var inst_63814 = (state_63870[(2)]);
var state_63870__$1 = state_63870;
var statearr_63908_63984 = state_63870__$1;
(statearr_63908_63984[(2)] = inst_63814);

(statearr_63908_63984[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (17))){
var inst_63755 = (state_63870[(25)]);
var state_63870__$1 = state_63870;
var statearr_63909_63985 = state_63870__$1;
(statearr_63909_63985[(2)] = inst_63755);

(statearr_63909_63985[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (3))){
var inst_63868 = (state_63870[(2)]);
var state_63870__$1 = state_63870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63870__$1,inst_63868);
} else {
if((state_val_63871 === (12))){
var inst_63782 = cljs.core.PersistentHashMap.EMPTY;
var state_63870__$1 = state_63870;
var statearr_63910_63986 = state_63870__$1;
(statearr_63910_63986[(2)] = inst_63782);

(statearr_63910_63986[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (2))){
var inst_63753 = (state_63870[(26)]);
var _ = (function (){var statearr_63911 = state_63870;
(statearr_63911[(4)] = cljs.core.cons.call(null,(5),(state_63870[(4)])));

return statearr_63911;
})();
var inst_63752 = query_map;
var inst_63753__$1 = cljs.core.__destructure_map.call(null,inst_63752);
var inst_63754 = cljs.core.get.call(null,inst_63753__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_63755 = cljs.core.get.call(null,inst_63753__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_63756 = cljs.core.get.call(null,inst_63753__$1,new cljs.core.Keyword(null,"block","block",664686210));
var inst_63757 = cljs.core.get.call(null,inst_63753__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_63758 = cljs.core.get.call(null,inst_63753__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_63759 = cljs.core.get.call(null,inst_63753__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_63760 = cljs.core.get.call(null,inst_63753__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_63761 = cljs.core.get.call(null,inst_63753__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_63762 = cljs.core.get.call(null,inst_63753__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_63763 = cljs.core.get.call(null,inst_63753__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_63870__$1 = (function (){var statearr_63912 = state_63870;
(statearr_63912[(11)] = inst_63763);

(statearr_63912[(7)] = inst_63756);

(statearr_63912[(19)] = inst_63762);

(statearr_63912[(27)] = inst_63758);

(statearr_63912[(18)] = inst_63757);

(statearr_63912[(10)] = inst_63754);

(statearr_63912[(14)] = inst_63759);

(statearr_63912[(25)] = inst_63755);

(statearr_63912[(9)] = inst_63760);

(statearr_63912[(26)] = inst_63753__$1);

(statearr_63912[(16)] = inst_63761);

return statearr_63912;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63870__$1,(6),sources);
} else {
if((state_val_63871 === (23))){
var inst_63759 = (state_63870[(14)]);
var state_63870__$1 = state_63870;
var statearr_63913_63987 = state_63870__$1;
(statearr_63913_63987[(2)] = inst_63759);

(statearr_63913_63987[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (47))){
var inst_63763 = (state_63870[(11)]);
var inst_63785 = (state_63870[(21)]);
var inst_63756 = (state_63870[(7)]);
var inst_63829 = (state_63870[(28)]);
var inst_63792 = (state_63870[(29)]);
var inst_63793 = (state_63870[(23)]);
var inst_63828 = (state_63870[(12)]);
var inst_63758 = (state_63870[(27)]);
var inst_63757 = (state_63870[(18)]);
var inst_63817 = (state_63870[(15)]);
var inst_63754 = (state_63870[(10)]);
var inst_63784 = (state_63870[(22)]);
var inst_63791 = (state_63870[(17)]);
var inst_63790 = (state_63870[(30)]);
var inst_63839 = (state_63870[(31)]);
var inst_63759 = (state_63870[(14)]);
var inst_63755 = (state_63870[(25)]);
var inst_63774 = (state_63870[(24)]);
var inst_63775 = (state_63870[(32)]);
var inst_63766 = (state_63870[(8)]);
var inst_63760 = (state_63870[(9)]);
var inst_63753 = (state_63870[(26)]);
var inst_63761 = (state_63870[(16)]);
var inst_63845 = (state_63870[(2)]);
var inst_63846 = cljs.core.deref.call(null,inst_63785);
var inst_63847 = (function (){var error_QMARK_ = inst_63829;
var construct = inst_63754;
var valid_query_QMARK_ = inst_63817;
var conn = inst_63775;
var select = inst_63755;
var block = inst_63756;
var where = inst_63757;
var prefixes = inst_63758;
var db = inst_63766;
var meta_QMARK_ = inst_63791;
var source_opts = inst_63784;
var fuel = inst_63785;
var db_STAR_ = inst_63774;
var selectDistinct = inst_63759;
var result = inst_63828;
var start_ms = inst_63792;
var selectOne = inst_63760;
var from = inst_63761;
var max_fuel = inst_63790;
var opts = inst_63793;
var selectReduced = inst_63763;
var map__63751 = inst_63753;
return (function (p1__63738_SHARP_){
return goog.string.format("%.2fms",p1__63738_SHARP_);
});
})();
var inst_63848 = fluree.db.util.core.current_time_millis.call(null);
var inst_63849 = (inst_63848 - inst_63792);
var inst_63850 = (inst_63849 / (1000000));
var inst_63851 = inst_63847.call(null,inst_63850);
var inst_63852 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_63774);
var inst_63853 = [(200),inst_63845,inst_63846,inst_63851,inst_63852];
var inst_63854 = cljs.core.PersistentHashMap.fromArrays(inst_63839,inst_63853);
var state_63870__$1 = state_63870;
var statearr_63914_63988 = state_63870__$1;
(statearr_63914_63988[(2)] = inst_63854);

(statearr_63914_63988[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (35))){
var inst_63820 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63821 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63822 = cljs.core.PersistentHashMap.fromArrays(inst_63820,inst_63821);
var state_63870__$1 = state_63870;
var statearr_63915_63989 = state_63870__$1;
(statearr_63915_63989[(2)] = inst_63822);

(statearr_63915_63989[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (19))){
var inst_63809 = (state_63870[(33)]);
var inst_63809__$1 = (state_63870[(2)]);
var state_63870__$1 = (function (){var statearr_63916 = state_63870;
(statearr_63916[(33)] = inst_63809__$1);

return statearr_63916;
})();
if(cljs.core.truth_(inst_63809__$1)){
var statearr_63917_63990 = state_63870__$1;
(statearr_63917_63990[(1)] = (29));

} else {
var statearr_63918_63991 = state_63870__$1;
(statearr_63918_63991[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (11))){
var inst_63758 = (state_63870[(27)]);
var inst_63774 = (state_63870[(24)]);
var inst_63775 = (state_63870[(32)]);
var inst_63777 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_63774);
var inst_63778 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_63775);
var inst_63779 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_63774);
var inst_63780 = fluree.db.api_js.get_sources.call(null,inst_63775,inst_63777,inst_63778,inst_63779,inst_63758,db_fn);
var state_63870__$1 = state_63870;
var statearr_63920_63992 = state_63870__$1;
(statearr_63920_63992[(2)] = inst_63780);

(statearr_63920_63992[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (9))){
var inst_63758 = (state_63870[(27)]);
var inst_63774 = (state_63870[(24)]);
var inst_63774__$1 = (state_63870[(2)]);
var inst_63775 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_63774__$1);
var state_63870__$1 = (function (){var statearr_63921 = state_63870;
(statearr_63921[(24)] = inst_63774__$1);

(statearr_63921[(32)] = inst_63775);

return statearr_63921;
})();
if(cljs.core.truth_(inst_63758)){
var statearr_63922_63993 = state_63870__$1;
(statearr_63922_63993[(1)] = (11));

} else {
var statearr_63923_63994 = state_63870__$1;
(statearr_63923_63994[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (5))){
var _ = (function (){var statearr_63924 = state_63870;
(statearr_63924[(4)] = cljs.core.rest.call(null,(state_63870[(4)])));

return statearr_63924;
})();
var state_63870__$1 = state_63870;
var ex63919 = (state_63870__$1[(2)]);
var statearr_63925_63995 = state_63870__$1;
(statearr_63925_63995[(5)] = ex63919);


var statearr_63926_63996 = state_63870__$1;
(statearr_63926_63996[(1)] = (4));

(statearr_63926_63996[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (14))){
var inst_63786 = (state_63870[(20)]);
var state_63870__$1 = state_63870;
var statearr_63927_63997 = state_63870__$1;
(statearr_63927_63997[(2)] = inst_63786);

(statearr_63927_63997[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (45))){
var inst_63828 = (state_63870[(12)]);
var inst_63842 = cljs.core.doall.call(null,inst_63828);
var state_63870__$1 = state_63870;
var statearr_63928_63998 = state_63870__$1;
(statearr_63928_63998[(2)] = inst_63842);

(statearr_63928_63998[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (26))){
var inst_63763 = (state_63870[(11)]);
var state_63870__$1 = state_63870;
var statearr_63929_63999 = state_63870__$1;
(statearr_63929_63999[(2)] = inst_63763);

(statearr_63929_63999[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (16))){
var inst_63785 = (state_63870[(21)]);
var inst_63762 = (state_63870[(19)]);
var inst_63784 = (state_63870[(22)]);
var inst_63790 = (state_63870[(30)]);
var inst_63755 = (state_63870[(25)]);
var inst_63790__$1 = (state_63870[(2)]);
var inst_63791 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_63762);
var inst_63792 = fluree.db.util.core.current_time_millis.call(null);
var inst_63793 = cljs.core.assoc.call(null,inst_63762,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_63784,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_63790__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_63785);
var state_63870__$1 = (function (){var statearr_63930 = state_63870;
(statearr_63930[(29)] = inst_63792);

(statearr_63930[(23)] = inst_63793);

(statearr_63930[(17)] = inst_63791);

(statearr_63930[(30)] = inst_63790__$1);

return statearr_63930;
})();
if(cljs.core.truth_(inst_63755)){
var statearr_63931_64000 = state_63870__$1;
(statearr_63931_64000[(1)] = (17));

} else {
var statearr_63932_64001 = state_63870__$1;
(statearr_63932_64001[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (38))){
var inst_63829 = (state_63870[(28)]);
var inst_63828 = (state_63870[(12)]);
var inst_63827 = (state_63870[(2)]);
var inst_63828__$1 = fluree.db.util.async.throw_err.call(null,inst_63827);
var inst_63829__$1 = (inst_63828__$1 instanceof cljs.core.ExceptionInfo);
var state_63870__$1 = (function (){var statearr_63933 = state_63870;
(statearr_63933[(28)] = inst_63829__$1);

(statearr_63933[(12)] = inst_63828__$1);

return statearr_63933;
})();
if(cljs.core.truth_(inst_63829__$1)){
var statearr_63934_64002 = state_63870__$1;
(statearr_63934_64002[(1)] = (39));

} else {
var statearr_63935_64003 = state_63870__$1;
(statearr_63935_64003[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (30))){
var inst_63809 = (state_63870[(33)]);
var state_63870__$1 = state_63870;
var statearr_63936_64004 = state_63870__$1;
(statearr_63936_64004[(2)] = inst_63809);

(statearr_63936_64004[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (10))){
var inst_63770 = (state_63870[(2)]);
var inst_63771 = fluree.db.util.async.throw_err.call(null,inst_63770);
var state_63870__$1 = state_63870;
var statearr_63937_64005 = state_63870__$1;
(statearr_63937_64005[(2)] = inst_63771);

(statearr_63937_64005[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (18))){
var inst_63760 = (state_63870[(9)]);
var state_63870__$1 = state_63870;
if(cljs.core.truth_(inst_63760)){
var statearr_63938_64006 = state_63870__$1;
(statearr_63938_64006[(1)] = (20));

} else {
var statearr_63939_64007 = state_63870__$1;
(statearr_63939_64007[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (42))){
var inst_63828 = (state_63870[(12)]);
var inst_63839 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_63840 = cljs.core.sequential_QMARK_.call(null,inst_63828);
var state_63870__$1 = (function (){var statearr_63940 = state_63870;
(statearr_63940[(31)] = inst_63839);

return statearr_63940;
})();
if(inst_63840){
var statearr_63941_64008 = state_63870__$1;
(statearr_63941_64008[(1)] = (45));

} else {
var statearr_63942_64009 = state_63870__$1;
(statearr_63942_64009[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (37))){
var inst_63865 = (state_63870[(2)]);
var _ = (function (){var statearr_63943 = state_63870;
(statearr_63943[(4)] = cljs.core.rest.call(null,(state_63870[(4)])));

return statearr_63943;
})();
var state_63870__$1 = state_63870;
var statearr_63944_64010 = state_63870__$1;
(statearr_63944_64010[(2)] = inst_63865);

(statearr_63944_64010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (8))){
var inst_63766 = (state_63870[(8)]);
var state_63870__$1 = state_63870;
var statearr_63945_64011 = state_63870__$1;
(statearr_63945_64011[(2)] = inst_63766);

(statearr_63945_64011[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (49))){
var state_63870__$1 = state_63870;
var statearr_63946_64012 = state_63870__$1;
(statearr_63946_64012[(2)] = null);

(statearr_63946_64012[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2726__auto__ = null;
var fluree$db$api_js$state_machine__2726__auto____0 = (function (){
var statearr_63947 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63947[(0)] = fluree$db$api_js$state_machine__2726__auto__);

(statearr_63947[(1)] = (1));

return statearr_63947;
});
var fluree$db$api_js$state_machine__2726__auto____1 = (function (state_63870){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_63870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e63948){var ex__2729__auto__ = e63948;
var statearr_63949_64013 = state_63870;
(statearr_63949_64013[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_63870[(4)]))){
var statearr_63950_64014 = state_63870;
(statearr_63950_64014[(1)] = cljs.core.first.call(null,(state_63870[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64015 = state_63870;
state_63870 = G__64015;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2726__auto__ = function(state_63870){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2726__auto____1.call(this,state_63870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2726__auto____0;
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2726__auto____1;
return fluree$db$api_js$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_63951 = f__2749__auto__.call(null);
(statearr_63951[(6)] = c__2748__auto__);

return statearr_63951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__64016_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__64016_SHARP_);
}));

var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_64038){
var state_val_64039 = (state_64038[(1)]);
if((state_val_64039 === (1))){
var inst_64020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64021 = [resp_chan,timeout_chan];
var inst_64022 = (new cljs.core.PersistentVector(null,2,(5),inst_64020,inst_64021,null));
var state_64038__$1 = state_64038;
return cljs.core.async.ioc_alts_BANG_.call(null,state_64038__$1,(2),inst_64022);
} else {
if((state_val_64039 === (2))){
var inst_64024 = (state_64038[(2)]);
var inst_64025 = cljs.core.nth.call(null,inst_64024,(0),null);
var inst_64026 = cljs.core.nth.call(null,inst_64024,(1),null);
var inst_64027 = cljs.core._EQ_.call(null,timeout_chan,inst_64026);
var state_64038__$1 = (function (){var statearr_64040 = state_64038;
(statearr_64040[(7)] = inst_64025);

return statearr_64040;
})();
if(inst_64027){
var statearr_64041_64051 = state_64038__$1;
(statearr_64041_64051[(1)] = (3));

} else {
var statearr_64042_64052 = state_64038__$1;
(statearr_64042_64052[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64039 === (3))){
var inst_64029 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_64030 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64031 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_64032 = [tid,(408),inst_64031];
var inst_64033 = cljs.core.PersistentHashMap.fromArrays(inst_64030,inst_64032);
var state_64038__$1 = (function (){var statearr_64043 = state_64038;
(statearr_64043[(8)] = inst_64029);

return statearr_64043;
})();
var statearr_64044_64053 = state_64038__$1;
(statearr_64044_64053[(2)] = inst_64033);

(statearr_64044_64053[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64039 === (4))){
var inst_64025 = (state_64038[(7)]);
var state_64038__$1 = state_64038;
var statearr_64045_64054 = state_64038__$1;
(statearr_64045_64054[(2)] = inst_64025);

(statearr_64045_64054[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64039 === (5))){
var inst_64036 = (state_64038[(2)]);
var state_64038__$1 = state_64038;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64038__$1,inst_64036);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2726__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2726__auto____0 = (function (){
var statearr_64046 = [null,null,null,null,null,null,null,null,null];
(statearr_64046[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2726__auto__);

(statearr_64046[(1)] = (1));

return statearr_64046;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2726__auto____1 = (function (state_64038){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_64038);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e64047){var ex__2729__auto__ = e64047;
var statearr_64048_64055 = state_64038;
(statearr_64048_64055[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_64038[(4)]))){
var statearr_64049_64056 = state_64038;
(statearr_64049_64056[(1)] = cljs.core.first.call(null,(state_64038[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64057 = state_64038;
state_64038 = G__64057;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2726__auto__ = function(state_64038){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2726__auto____1.call(this,state_64038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2726__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2726__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_64050 = f__2749__auto__.call(null);
(statearr_64050[(6)] = c__2748__auto__);

return statearr_64050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__64059 = arguments.length;
switch (G__64059) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__64060 = opts;
var map__64060__$1 = cljs.core.__destructure_map.call(null,map__64060);
var auth = cljs.core.get.call(null,map__64060__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__64060__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__64060__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__64060__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__64061 = (cljs.core.truth_((function (){var and__4221__auto__ = auth;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4221__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__64061,(0),null);
var authority = cljs.core.nth.call(null,vec__64061,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4223__auto__ = nonce;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4223__auto__ = expire;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e64064){var e = e64064;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__64067 = arguments.length;
switch (G__64067) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_64133){
var state_val_64134 = (state_64133[(1)]);
if((state_val_64134 === (7))){
var inst_64084 = (state_64133[(7)]);
var inst_64087 = (state_64133[(8)]);
var inst_64088 = (state_64133[(9)]);
var inst_64086 = (state_64133[(10)]);
var inst_64089 = (state_64133[(11)]);
var inst_64102 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_64103 = [ledger,txn,inst_64084,inst_64086,inst_64087,inst_64088,inst_64089];
var inst_64104 = cljs.core.PersistentHashMap.fromArrays(inst_64102,inst_64103);
var inst_64105 = fluree.db.util.core.without_nils.call(null,inst_64104);
var inst_64106 = fluree.db.operations.transact_async.call(null,conn,inst_64105);
var state_64133__$1 = state_64133;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64133__$1,(13),inst_64106);
} else {
if((state_val_64134 === (20))){
var inst_64124 = (state_64133[(2)]);
var state_64133__$1 = state_64133;
var statearr_64135_64171 = state_64133__$1;
(statearr_64135_64171[(2)] = inst_64124);

(statearr_64135_64171[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (1))){
var state_64133__$1 = state_64133;
var statearr_64136_64172 = state_64133__$1;
(statearr_64136_64172[(2)] = null);

(statearr_64136_64172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (4))){
var inst_64068 = (state_64133[(2)]);
var inst_64069 = fluree.db.util.log.error.call(null,inst_64068);
var inst_64070 = cljs.core.ex_data.call(null,inst_64068);
var inst_64071 = cljs.core.ex_message.call(null,inst_64068);
var inst_64072 = cljs.core.assoc.call(null,inst_64070,new cljs.core.Keyword(null,"message","message",-406056002),inst_64071);
var state_64133__$1 = (function (){var statearr_64137 = state_64133;
(statearr_64137[(12)] = inst_64069);

return statearr_64137;
})();
var statearr_64138_64173 = state_64133__$1;
(statearr_64138_64173[(2)] = inst_64072);

(statearr_64138_64173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (15))){
var inst_64083 = (state_64133[(13)]);
var inst_64108 = (state_64133[(14)]);
var inst_64111 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_64108,inst_64083);
var state_64133__$1 = state_64133;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64133__$1,(17),inst_64111);
} else {
if((state_val_64134 === (13))){
var inst_64082 = (state_64133[(15)]);
var inst_64108 = (state_64133[(2)]);
var state_64133__$1 = (function (){var statearr_64139 = state_64133;
(statearr_64139[(14)] = inst_64108);

return statearr_64139;
})();
if(cljs.core.truth_(inst_64082)){
var statearr_64140_64174 = state_64133__$1;
(statearr_64140_64174[(1)] = (14));

} else {
var statearr_64141_64175 = state_64133__$1;
(statearr_64141_64175[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (6))){
var inst_64081 = (state_64133[(16)]);
var inst_64082 = (state_64133[(15)]);
var inst_64091 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_64081,opts);
var inst_64092 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_64091);
var inst_64093 = fluree.db.operations.command_async.call(null,conn,inst_64091);
var state_64133__$1 = (function (){var statearr_64142 = state_64133;
(statearr_64142[(17)] = inst_64092);

(statearr_64142[(18)] = inst_64093);

return statearr_64142;
})();
if(cljs.core.truth_(inst_64082)){
var statearr_64143_64176 = state_64133__$1;
(statearr_64143_64176[(1)] = (9));

} else {
var statearr_64144_64177 = state_64133__$1;
(statearr_64144_64177[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (17))){
var inst_64113 = (state_64133[(19)]);
var inst_64113__$1 = (state_64133[(2)]);
var inst_64114 = (inst_64113__$1 instanceof cljs.core.ExceptionInfo);
var state_64133__$1 = (function (){var statearr_64145 = state_64133;
(statearr_64145[(19)] = inst_64113__$1);

return statearr_64145;
})();
if(cljs.core.truth_(inst_64114)){
var statearr_64146_64178 = state_64133__$1;
(statearr_64146_64178[(1)] = (18));

} else {
var statearr_64147_64179 = state_64133__$1;
(statearr_64147_64179[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (3))){
var inst_64131 = (state_64133[(2)]);
var state_64133__$1 = state_64133;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64133__$1,inst_64131);
} else {
if((state_val_64134 === (12))){
var inst_64098 = (state_64133[(2)]);
var state_64133__$1 = state_64133;
var statearr_64148_64180 = state_64133__$1;
(statearr_64148_64180[(2)] = inst_64098);

(statearr_64148_64180[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (2))){
var inst_64081 = (state_64133[(16)]);
var _ = (function (){var statearr_64149 = state_64133;
(statearr_64149[(4)] = cljs.core.cons.call(null,(5),(state_64133[(4)])));

return statearr_64149;
})();
var inst_64079 = opts;
var inst_64080 = cljs.core.__destructure_map.call(null,inst_64079);
var inst_64081__$1 = cljs.core.get.call(null,inst_64080,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_64082 = cljs.core.get.call(null,inst_64080,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_64083 = cljs.core.get.call(null,inst_64080,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_64084 = cljs.core.get.call(null,inst_64080,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_64085 = fluree.db.util.core.current_time_millis.call(null);
var inst_64086 = cljs.core.get.call(null,inst_64080,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_64085);
var inst_64087 = cljs.core.get.call(null,inst_64080,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_64088 = cljs.core.get.call(null,inst_64080,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_64089 = cljs.core.get.call(null,inst_64080,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_64133__$1 = (function (){var statearr_64150 = state_64133;
(statearr_64150[(16)] = inst_64081__$1);

(statearr_64150[(7)] = inst_64084);

(statearr_64150[(8)] = inst_64087);

(statearr_64150[(13)] = inst_64083);

(statearr_64150[(9)] = inst_64088);

(statearr_64150[(10)] = inst_64086);

(statearr_64150[(15)] = inst_64082);

(statearr_64150[(11)] = inst_64089);

return statearr_64150;
})();
if(cljs.core.truth_(inst_64081__$1)){
var statearr_64151_64181 = state_64133__$1;
(statearr_64151_64181[(1)] = (6));

} else {
var statearr_64152_64182 = state_64133__$1;
(statearr_64152_64182[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (19))){
var inst_64113 = (state_64133[(19)]);
var state_64133__$1 = state_64133;
var statearr_64153_64183 = state_64133__$1;
(statearr_64153_64183[(2)] = inst_64113);

(statearr_64153_64183[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (11))){
var inst_64100 = (state_64133[(2)]);
var state_64133__$1 = state_64133;
var statearr_64155_64184 = state_64133__$1;
(statearr_64155_64184[(2)] = inst_64100);

(statearr_64155_64184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (9))){
var inst_64093 = (state_64133[(18)]);
var state_64133__$1 = state_64133;
var statearr_64156_64185 = state_64133__$1;
(statearr_64156_64185[(2)] = inst_64093);

(statearr_64156_64185[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (5))){
var _ = (function (){var statearr_64157 = state_64133;
(statearr_64157[(4)] = cljs.core.rest.call(null,(state_64133[(4)])));

return statearr_64157;
})();
var state_64133__$1 = state_64133;
var ex64154 = (state_64133__$1[(2)]);
var statearr_64158_64186 = state_64133__$1;
(statearr_64158_64186[(5)] = ex64154);


var statearr_64159_64187 = state_64133__$1;
(statearr_64159_64187[(1)] = (4));

(statearr_64159_64187[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (14))){
var inst_64108 = (state_64133[(14)]);
var state_64133__$1 = state_64133;
var statearr_64160_64188 = state_64133__$1;
(statearr_64160_64188[(2)] = inst_64108);

(statearr_64160_64188[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (16))){
var inst_64126 = (state_64133[(2)]);
var state_64133__$1 = state_64133;
var statearr_64161_64189 = state_64133__$1;
(statearr_64161_64189[(2)] = inst_64126);

(statearr_64161_64189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (10))){
var inst_64092 = (state_64133[(17)]);
var inst_64083 = (state_64133[(13)]);
var inst_64096 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_64092,inst_64083);
var state_64133__$1 = state_64133;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64133__$1,(12),inst_64096);
} else {
if((state_val_64134 === (18))){
var inst_64113 = (state_64133[(19)]);
var inst_64116 = cljs.core.ex_data.call(null,inst_64113);
var inst_64117 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64118 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_64116);
var inst_64119 = cljs.core.ex_message.call(null,inst_64113);
var inst_64120 = [inst_64118,inst_64119,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_64121 = cljs.core.PersistentHashMap.fromArrays(inst_64117,inst_64120);
var state_64133__$1 = state_64133;
var statearr_64162_64190 = state_64133__$1;
(statearr_64162_64190[(2)] = inst_64121);

(statearr_64162_64190[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64134 === (8))){
var inst_64128 = (state_64133[(2)]);
var _ = (function (){var statearr_64163 = state_64133;
(statearr_64163[(4)] = cljs.core.rest.call(null,(state_64133[(4)])));

return statearr_64163;
})();
var state_64133__$1 = state_64133;
var statearr_64164_64191 = state_64133__$1;
(statearr_64164_64191[(2)] = inst_64128);

(statearr_64164_64191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2726__auto__ = null;
var fluree$db$api_js$state_machine__2726__auto____0 = (function (){
var statearr_64165 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64165[(0)] = fluree$db$api_js$state_machine__2726__auto__);

(statearr_64165[(1)] = (1));

return statearr_64165;
});
var fluree$db$api_js$state_machine__2726__auto____1 = (function (state_64133){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_64133);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e64166){var ex__2729__auto__ = e64166;
var statearr_64167_64192 = state_64133;
(statearr_64167_64192[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_64133[(4)]))){
var statearr_64168_64193 = state_64133;
(statearr_64168_64193[(1)] = cljs.core.first.call(null,(state_64133[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64194 = state_64133;
state_64133 = G__64194;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2726__auto__ = function(state_64133){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2726__auto____1.call(this,state_64133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2726__auto____0;
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2726__auto____1;
return fluree$db$api_js$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_64169 = f__2749__auto__.call(null);
(statearr_64169[(6)] = c__2748__auto__);

return statearr_64169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4835__auto__ = [];
var len__4829__auto___64196 = arguments.length;
var i__4830__auto___64197 = (0);
while(true){
if((i__4830__auto___64197 < len__4829__auto___64196)){
args__4835__auto__.push((arguments[i__4830__auto___64197]));

var G__64198 = (i__4830__auto___64197 + (1));
i__4830__auto___64197 = G__64198;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq64195){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq64195));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_64229){
var state_val_64230 = (state_64229[(1)]);
if((state_val_64230 === (1))){
var inst_64199 = cljs.core.first.call(null,flakes);
var inst_64200 = cljs.core.rest.call(null,flakes);
var inst_64201 = cljs.core.PersistentVector.EMPTY;
var inst_64202 = inst_64199;
var inst_64203 = inst_64200;
var inst_64204 = inst_64201;
var state_64229__$1 = (function (){var statearr_64231 = state_64229;
(statearr_64231[(7)] = inst_64204);

(statearr_64231[(8)] = inst_64203);

(statearr_64231[(9)] = inst_64202);

return statearr_64231;
})();
var statearr_64232_64245 = state_64229__$1;
(statearr_64232_64245[(2)] = null);

(statearr_64232_64245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64230 === (2))){
var inst_64202 = (state_64229[(9)]);
var inst_64206 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_64207 = cljs.core.PersistentHashMap.EMPTY;
var inst_64208 = [true,inst_64207];
var inst_64209 = cljs.core.PersistentHashMap.fromArrays(inst_64206,inst_64208);
var inst_64210 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_64209,inst_64202);
var state_64229__$1 = state_64229;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64229__$1,(4),inst_64210);
} else {
if((state_val_64230 === (3))){
var inst_64227 = (state_64229[(2)]);
var state_64229__$1 = state_64229;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64229__$1,inst_64227);
} else {
if((state_val_64230 === (4))){
var inst_64204 = (state_64229[(7)]);
var inst_64203 = (state_64229[(8)]);
var inst_64212 = (state_64229[(2)]);
var inst_64213 = fluree.db.util.async.throw_err.call(null,inst_64212);
var inst_64214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64215 = [inst_64213];
var inst_64216 = (new cljs.core.PersistentVector(null,1,(5),inst_64214,inst_64215,null));
var inst_64217 = cljs.core.concat.call(null,inst_64204,inst_64216);
var inst_64218 = cljs.core.first.call(null,inst_64203);
var state_64229__$1 = (function (){var statearr_64233 = state_64229;
(statearr_64233[(10)] = inst_64217);

return statearr_64233;
})();
if(cljs.core.truth_(inst_64218)){
var statearr_64234_64246 = state_64229__$1;
(statearr_64234_64246[(1)] = (5));

} else {
var statearr_64235_64247 = state_64229__$1;
(statearr_64235_64247[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64230 === (5))){
var inst_64203 = (state_64229[(8)]);
var inst_64217 = (state_64229[(10)]);
var inst_64220 = cljs.core.first.call(null,inst_64203);
var inst_64221 = cljs.core.rest.call(null,inst_64203);
var inst_64202 = inst_64220;
var inst_64203__$1 = inst_64221;
var inst_64204 = inst_64217;
var state_64229__$1 = (function (){var statearr_64236 = state_64229;
(statearr_64236[(7)] = inst_64204);

(statearr_64236[(8)] = inst_64203__$1);

(statearr_64236[(9)] = inst_64202);

return statearr_64236;
})();
var statearr_64237_64248 = state_64229__$1;
(statearr_64237_64248[(2)] = null);

(statearr_64237_64248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64230 === (6))){
var inst_64217 = (state_64229[(10)]);
var state_64229__$1 = state_64229;
var statearr_64238_64249 = state_64229__$1;
(statearr_64238_64249[(2)] = inst_64217);

(statearr_64238_64249[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64230 === (7))){
var inst_64225 = (state_64229[(2)]);
var state_64229__$1 = state_64229;
var statearr_64239_64250 = state_64229__$1;
(statearr_64239_64250[(2)] = inst_64225);

(statearr_64239_64250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2726__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2726__auto____0 = (function (){
var statearr_64240 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64240[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2726__auto__);

(statearr_64240[(1)] = (1));

return statearr_64240;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2726__auto____1 = (function (state_64229){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_64229);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e64241){var ex__2729__auto__ = e64241;
var statearr_64242_64251 = state_64229;
(statearr_64242_64251[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_64229[(4)]))){
var statearr_64243_64252 = state_64229;
(statearr_64243_64252[(1)] = cljs.core.first.call(null,(state_64229[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64253 = state_64229;
state_64229 = G__64253;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2726__auto__ = function(state_64229){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2726__auto____1.call(this,state_64229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2726__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2726__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_64244 = f__2749__auto__.call(null);
(statearr_64244[(6)] = c__2748__auto__);

return statearr_64244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_64321){
var state_val_64322 = (state_64321[(1)]);
if((state_val_64322 === (7))){
var inst_64281 = (state_64321[(2)]);
var inst_64282 = fluree.db.util.async.throw_err.call(null,inst_64281);
var state_64321__$1 = state_64321;
var statearr_64323_64349 = state_64321__$1;
(statearr_64323_64349[(2)] = inst_64282);

(statearr_64323_64349[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64322 === (1))){
var inst_64258 = cljs.core.volatile_BANG_.call(null,(0));
var inst_64259 = cljs.core.PersistentHashMap.EMPTY;
var inst_64260 = cljs.core.volatile_BANG_.call(null,inst_64259);
var inst_64261 = cljs.core.first.call(null,resp);
var inst_64262 = cljs.core.rest.call(null,resp);
var inst_64263 = cljs.core.PersistentVector.EMPTY;
var inst_64264 = inst_64258;
var inst_64265 = inst_64260;
var inst_64266 = inst_64261;
var inst_64267 = inst_64262;
var inst_64268 = inst_64263;
var state_64321__$1 = (function (){var statearr_64324 = state_64321;
(statearr_64324[(7)] = inst_64264);

(statearr_64324[(8)] = inst_64265);

(statearr_64324[(9)] = inst_64266);

(statearr_64324[(10)] = inst_64268);

(statearr_64324[(11)] = inst_64267);

return statearr_64324;
})();
var statearr_64325_64350 = state_64321__$1;
(statearr_64325_64350[(2)] = null);

(statearr_64325_64350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64322 === (4))){
var inst_64272 = (state_64321[(12)]);
var inst_64270 = (state_64321[(13)]);
var inst_64264 = (state_64321[(7)]);
var inst_64265 = (state_64321[(8)]);
var inst_64266 = (state_64321[(9)]);
var inst_64268 = (state_64321[(10)]);
var inst_64267 = (state_64321[(11)]);
var inst_64276 = (function (){var fuel = inst_64264;
var cache = inst_64265;
var curr_block = inst_64266;
var rest_blocks = inst_64267;
var acc = inst_64268;
var flakes = inst_64270;
var asserted = inst_64272;
return (function (p1__64255_SHARP_){
return p1__64255_SHARP_.s;
});
})();
var inst_64277 = cljs.core.group_by.call(null,inst_64276,inst_64272);
var inst_64278 = cljs.core.vals.call(null,inst_64277);
var inst_64279 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_64265,inst_64264,inst_64278);
var state_64321__$1 = state_64321;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64321__$1,(7),inst_64279);
} else {
if((state_val_64322 === (13))){
var inst_64309 = (state_64321[(14)]);
var state_64321__$1 = state_64321;
var statearr_64326_64351 = state_64321__$1;
(statearr_64326_64351[(2)] = inst_64309);

(statearr_64326_64351[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64322 === (6))){
var inst_64272 = (state_64321[(12)]);
var inst_64270 = (state_64321[(13)]);
var inst_64264 = (state_64321[(7)]);
var inst_64265 = (state_64321[(8)]);
var inst_64266 = (state_64321[(9)]);
var inst_64268 = (state_64321[(10)]);
var inst_64285 = (state_64321[(15)]);
var inst_64267 = (state_64321[(11)]);
var inst_64287 = (state_64321[(16)]);
var inst_64285__$1 = (state_64321[(2)]);
var inst_64286 = (function (){var fuel = inst_64264;
var cache = inst_64265;
var curr_block = inst_64266;
var rest_blocks = inst_64267;
var acc = inst_64268;
var flakes = inst_64270;
var asserted = inst_64272;
var asserted_SINGLEQUOTE_ = inst_64285__$1;
return (function (p1__64256_SHARP_){
return p1__64256_SHARP_.op === false;
});
})();
var inst_64287__$1 = cljs.core.filter.call(null,inst_64286,inst_64270);
var inst_64288 = cljs.core.empty_QMARK_.call(null,inst_64287__$1);
var inst_64289 = (!(inst_64288));
var state_64321__$1 = (function (){var statearr_64329 = state_64321;
(statearr_64329[(15)] = inst_64285__$1);

(statearr_64329[(16)] = inst_64287__$1);

return statearr_64329;
})();
if(inst_64289){
var statearr_64330_64352 = state_64321__$1;
(statearr_64330_64352[(1)] = (8));

} else {
var statearr_64331_64353 = state_64321__$1;
(statearr_64331_64353[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64322 === (3))){
var inst_64319 = (state_64321[(2)]);
var state_64321__$1 = state_64321;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64321__$1,inst_64319);
} else {
if((state_val_64322 === (12))){
var inst_64264 = (state_64321[(7)]);
var inst_64265 = (state_64321[(8)]);
var inst_64309 = (state_64321[(14)]);
var inst_64267 = (state_64321[(11)]);
var inst_64312 = cljs.core.first.call(null,inst_64267);
var inst_64313 = cljs.core.rest.call(null,inst_64267);
var tmp64327 = inst_64264;
var tmp64328 = inst_64265;
var inst_64264__$1 = tmp64327;
var inst_64265__$1 = tmp64328;
var inst_64266 = inst_64312;
var inst_64267__$1 = inst_64313;
var inst_64268 = inst_64309;
var state_64321__$1 = (function (){var statearr_64332 = state_64321;
(statearr_64332[(7)] = inst_64264__$1);

(statearr_64332[(8)] = inst_64265__$1);

(statearr_64332[(9)] = inst_64266);

(statearr_64332[(10)] = inst_64268);

(statearr_64332[(11)] = inst_64267__$1);

return statearr_64332;
})();
var statearr_64333_64354 = state_64321__$1;
(statearr_64333_64354[(2)] = null);

(statearr_64333_64354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64322 === (2))){
var inst_64272 = (state_64321[(12)]);
var inst_64270 = (state_64321[(13)]);
var inst_64264 = (state_64321[(7)]);
var inst_64265 = (state_64321[(8)]);
var inst_64266 = (state_64321[(9)]);
var inst_64268 = (state_64321[(10)]);
var inst_64267 = (state_64321[(11)]);
var inst_64270__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_64266);
var inst_64271 = (function (){var fuel = inst_64264;
var cache = inst_64265;
var curr_block = inst_64266;
var rest_blocks = inst_64267;
var acc = inst_64268;
var flakes = inst_64270__$1;
return (function (p1__64254_SHARP_){
return p1__64254_SHARP_.op;
});
})();
var inst_64272__$1 = cljs.core.filter.call(null,inst_64271,inst_64270__$1);
var inst_64273 = cljs.core.empty_QMARK_.call(null,inst_64272__$1);
var inst_64274 = (!(inst_64273));
var state_64321__$1 = (function (){var statearr_64334 = state_64321;
(statearr_64334[(12)] = inst_64272__$1);

(statearr_64334[(13)] = inst_64270__$1);

return statearr_64334;
})();
if(inst_64274){
var statearr_64335_64355 = state_64321__$1;
(statearr_64335_64355[(1)] = (4));

} else {
var statearr_64336_64356 = state_64321__$1;
(statearr_64336_64356[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64322 === (11))){
var inst_64297 = (state_64321[(2)]);
var inst_64298 = fluree.db.util.async.throw_err.call(null,inst_64297);
var state_64321__$1 = state_64321;
var statearr_64337_64357 = state_64321__$1;
(statearr_64337_64357[(2)] = inst_64298);

(statearr_64337_64357[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64322 === (9))){
var state_64321__$1 = state_64321;
var statearr_64338_64358 = state_64321__$1;
(statearr_64338_64358[(2)] = null);

(statearr_64338_64358[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64322 === (5))){
var state_64321__$1 = state_64321;
var statearr_64339_64359 = state_64321__$1;
(statearr_64339_64359[(2)] = null);

(statearr_64339_64359[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64322 === (14))){
var inst_64317 = (state_64321[(2)]);
var state_64321__$1 = state_64321;
var statearr_64340_64360 = state_64321__$1;
(statearr_64340_64360[(2)] = inst_64317);

(statearr_64340_64360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64322 === (10))){
var inst_64266 = (state_64321[(9)]);
var inst_64268 = (state_64321[(10)]);
var inst_64285 = (state_64321[(15)]);
var inst_64267 = (state_64321[(11)]);
var inst_64301 = (state_64321[(2)]);
var inst_64302 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_64303 = [inst_64285,inst_64301];
var inst_64304 = cljs.core.PersistentHashMap.fromArrays(inst_64302,inst_64303);
var inst_64305 = cljs.core.assoc.call(null,inst_64266,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_64304);
var inst_64306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64307 = [inst_64305];
var inst_64308 = (new cljs.core.PersistentVector(null,1,(5),inst_64306,inst_64307,null));
var inst_64309 = cljs.core.concat.call(null,inst_64268,inst_64308);
var inst_64310 = cljs.core.first.call(null,inst_64267);
var state_64321__$1 = (function (){var statearr_64341 = state_64321;
(statearr_64341[(14)] = inst_64309);

return statearr_64341;
})();
if(cljs.core.truth_(inst_64310)){
var statearr_64342_64361 = state_64321__$1;
(statearr_64342_64361[(1)] = (12));

} else {
var statearr_64343_64362 = state_64321__$1;
(statearr_64343_64362[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64322 === (8))){
var inst_64272 = (state_64321[(12)]);
var inst_64270 = (state_64321[(13)]);
var inst_64264 = (state_64321[(7)]);
var inst_64265 = (state_64321[(8)]);
var inst_64266 = (state_64321[(9)]);
var inst_64268 = (state_64321[(10)]);
var inst_64285 = (state_64321[(15)]);
var inst_64267 = (state_64321[(11)]);
var inst_64287 = (state_64321[(16)]);
var inst_64291 = (function (){var flakes = inst_64270;
var rest_blocks = inst_64267;
var curr_block = inst_64266;
var asserted_SINGLEQUOTE_ = inst_64285;
var acc = inst_64268;
var fuel = inst_64264;
var cache = inst_64265;
var retracted = inst_64287;
var asserted = inst_64272;
return (function (p1__64257_SHARP_){
return p1__64257_SHARP_.s;
});
})();
var inst_64292 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_64287);
var inst_64293 = cljs.core.group_by.call(null,inst_64291,inst_64292);
var inst_64294 = cljs.core.vals.call(null,inst_64293);
var inst_64295 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_64265,inst_64264,inst_64294);
var state_64321__$1 = state_64321;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64321__$1,(11),inst_64295);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2726__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2726__auto____0 = (function (){
var statearr_64344 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64344[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2726__auto__);

(statearr_64344[(1)] = (1));

return statearr_64344;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2726__auto____1 = (function (state_64321){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_64321);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e64345){var ex__2729__auto__ = e64345;
var statearr_64346_64363 = state_64321;
(statearr_64346_64363[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_64321[(4)]))){
var statearr_64347_64364 = state_64321;
(statearr_64347_64364[(1)] = cljs.core.first.call(null,(state_64321[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64365 = state_64321;
state_64321 = G__64365;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2726__auto__ = function(state_64321){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2726__auto____1.call(this,state_64321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2726__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2726__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_64348 = f__2749__auto__.call(null);
(statearr_64348[(6)] = c__2748__auto__);

return statearr_64348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_64465){
var state_val_64466 = (state_64465[(1)]);
if((state_val_64466 === (7))){
var inst_64437 = (state_64465[(7)]);
var inst_64430 = (state_64465[(8)]);
var inst_64436 = cljs.core.seq.call(null,inst_64430);
var inst_64437__$1 = cljs.core.first.call(null,inst_64436);
var inst_64438 = cljs.core.next.call(null,inst_64436);
var state_64465__$1 = (function (){var statearr_64467 = state_64465;
(statearr_64467[(9)] = inst_64438);

(statearr_64467[(7)] = inst_64437__$1);

return statearr_64467;
})();
if(cljs.core.truth_(inst_64437__$1)){
var statearr_64468_64505 = state_64465__$1;
(statearr_64468_64505[(1)] = (9));

} else {
var statearr_64469_64506 = state_64465__$1;
(statearr_64469_64506[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64466 === (1))){
var state_64465__$1 = state_64465;
var statearr_64470_64507 = state_64465__$1;
(statearr_64470_64507[(2)] = null);

(statearr_64470_64507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64466 === (4))){
var inst_64367 = (state_64465[(2)]);
var state_64465__$1 = state_64465;
var statearr_64471_64508 = state_64465__$1;
(statearr_64471_64508[(2)] = inst_64367);

(statearr_64471_64508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64466 === (6))){
var inst_64416 = (state_64465[(2)]);
var inst_64417 = fluree.db.util.async.throw_err.call(null,inst_64416);
var inst_64425 = resp;
var inst_64426 = cljs.core.seq.call(null,inst_64425);
var inst_64427 = cljs.core.first.call(null,inst_64426);
var inst_64428 = cljs.core.next.call(null,inst_64426);
var inst_64429 = cljs.core.PersistentHashMap.EMPTY;
var inst_64430 = inst_64425;
var inst_64431 = inst_64429;
var state_64465__$1 = (function (){var statearr_64472 = state_64465;
(statearr_64472[(10)] = inst_64431);

(statearr_64472[(11)] = inst_64427);

(statearr_64472[(12)] = inst_64417);

(statearr_64472[(13)] = inst_64428);

(statearr_64472[(8)] = inst_64430);

return statearr_64472;
})();
var statearr_64473_64509 = state_64465__$1;
(statearr_64473_64509[(2)] = null);

(statearr_64473_64509[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64466 === (3))){
var inst_64463 = (state_64465[(2)]);
var state_64465__$1 = state_64465;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64465__$1,inst_64463);
} else {
if((state_val_64466 === (2))){
var _ = (function (){var statearr_64474 = state_64465;
(statearr_64474[(4)] = cljs.core.cons.call(null,(5),(state_64465[(4)])));

return statearr_64474;
})();
var inst_64373 = (function (){return (function (p1__64366_SHARP_){
return p1__64366_SHARP_.t;
});
})();
var inst_64374 = cljs.core.map.call(null,inst_64373,resp);
var inst_64375 = cljs.core.set.call(null,inst_64374);
var inst_64412 = cljs.core.async.chan.call(null,(1));
var inst_64413 = (function (){var ts = inst_64375;
var c__2748__auto____$1 = inst_64412;
return (function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_64410){
var state_val_64411 = (state_64410[(1)]);
if((state_val_64411 === (1))){
var inst_64383 = ts;
var inst_64384 = cljs.core.seq.call(null,inst_64383);
var inst_64385 = cljs.core.first.call(null,inst_64384);
var inst_64386 = cljs.core.next.call(null,inst_64384);
var inst_64387 = cljs.core.PersistentHashMap.EMPTY;
var inst_64388 = inst_64383;
var inst_64389 = inst_64387;
var state_64410__$1 = (function (){var statearr_64475 = state_64410;
(statearr_64475[(7)] = inst_64386);

(statearr_64475[(8)] = inst_64385);

(statearr_64475[(9)] = inst_64389);

(statearr_64475[(10)] = inst_64388);

return statearr_64475;
})();
var statearr_64476_64510 = state_64410__$1;
(statearr_64476_64510[(2)] = null);

(statearr_64476_64510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64411 === (2))){
var inst_64395 = (state_64410[(11)]);
var inst_64388 = (state_64410[(10)]);
var inst_64394 = cljs.core.seq.call(null,inst_64388);
var inst_64395__$1 = cljs.core.first.call(null,inst_64394);
var inst_64396 = cljs.core.next.call(null,inst_64394);
var state_64410__$1 = (function (){var statearr_64477 = state_64410;
(statearr_64477[(12)] = inst_64396);

(statearr_64477[(11)] = inst_64395__$1);

return statearr_64477;
})();
if(cljs.core.truth_(inst_64395__$1)){
var statearr_64478_64511 = state_64410__$1;
(statearr_64478_64511[(1)] = (4));

} else {
var statearr_64479_64512 = state_64410__$1;
(statearr_64479_64512[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64411 === (3))){
var inst_64408 = (state_64410[(2)]);
var state_64410__$1 = state_64410;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64410__$1,inst_64408);
} else {
if((state_val_64411 === (4))){
var inst_64395 = (state_64410[(11)]);
var inst_64398 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_64395);
var state_64410__$1 = state_64410;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64410__$1,(7),inst_64398);
} else {
if((state_val_64411 === (5))){
var inst_64389 = (state_64410[(9)]);
var state_64410__$1 = state_64410;
var statearr_64480_64513 = state_64410__$1;
(statearr_64480_64513[(2)] = inst_64389);

(statearr_64480_64513[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64411 === (6))){
var inst_64406 = (state_64410[(2)]);
var state_64410__$1 = state_64410;
var statearr_64481_64514 = state_64410__$1;
(statearr_64481_64514[(2)] = inst_64406);

(statearr_64481_64514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64411 === (7))){
var inst_64396 = (state_64410[(12)]);
var inst_64389 = (state_64410[(9)]);
var inst_64395 = (state_64410[(11)]);
var inst_64400 = (state_64410[(2)]);
var inst_64401 = fluree.db.util.async.throw_err.call(null,inst_64400);
var inst_64402 = cljs.core.assoc.call(null,inst_64389,inst_64395,inst_64401);
var inst_64388 = inst_64396;
var inst_64389__$1 = inst_64402;
var state_64410__$1 = (function (){var statearr_64482 = state_64410;
(statearr_64482[(9)] = inst_64389__$1);

(statearr_64482[(10)] = inst_64388);

return statearr_64482;
})();
var statearr_64483_64515 = state_64410__$1;
(statearr_64483_64515[(2)] = null);

(statearr_64483_64515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2726__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2726__auto____0 = (function (){
var statearr_64484 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64484[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2726__auto__);

(statearr_64484[(1)] = (1));

return statearr_64484;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2726__auto____1 = (function (state_64410){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_64410);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e64485){var ex__2729__auto__ = e64485;
var statearr_64486_64516 = state_64410;
(statearr_64486_64516[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_64410[(4)]))){
var statearr_64487_64517 = state_64410;
(statearr_64487_64517[(1)] = cljs.core.first.call(null,(state_64410[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64518 = state_64410;
state_64410 = G__64518;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2726__auto__ = function(state_64410){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2726__auto____1.call(this,state_64410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2726__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2726__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_64488 = f__2749__auto__.call(null);
(statearr_64488[(6)] = c__2748__auto____$1);

return statearr_64488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
});
})();
var inst_64414 = cljs.core.async.impl.dispatch.run.call(null,inst_64413);
var state_64465__$1 = (function (){var statearr_64489 = state_64465;
(statearr_64489[(14)] = inst_64414);

return statearr_64489;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64465__$1,(6),inst_64412);
} else {
if((state_val_64466 === (11))){
var inst_64457 = (state_64465[(2)]);
var state_64465__$1 = state_64465;
var statearr_64491_64519 = state_64465__$1;
(statearr_64491_64519[(2)] = inst_64457);

(statearr_64491_64519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64466 === (9))){
var inst_64431 = (state_64465[(10)]);
var inst_64438 = (state_64465[(9)]);
var inst_64417 = (state_64465[(12)]);
var inst_64437 = (state_64465[(7)]);
var inst_64440 = inst_64437.t;
var inst_64441 = cljs.core.get.call(null,inst_64417,inst_64440);
var inst_64442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64443 = [inst_64441,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_64444 = (new cljs.core.PersistentVector(null,2,(5),inst_64442,inst_64443,null));
var inst_64445 = cljs.core.assoc_in.call(null,inst_64431,inst_64444,inst_64441);
var inst_64446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64447 = [inst_64441,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_64448 = (new cljs.core.PersistentVector(null,2,(5),inst_64446,inst_64447,null));
var inst_64449 = cljs.core.update_in.call(null,inst_64445,inst_64448,cljs.core.conj,inst_64437);
var inst_64450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64451 = [inst_64441,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_64452 = (new cljs.core.PersistentVector(null,2,(5),inst_64450,inst_64451,null));
var inst_64453 = cljs.core.update_in.call(null,inst_64449,inst_64452,fluree.db.api_js.min_safe,inst_64440);
var inst_64430 = inst_64438;
var inst_64431__$1 = inst_64453;
var state_64465__$1 = (function (){var statearr_64492 = state_64465;
(statearr_64492[(10)] = inst_64431__$1);

(statearr_64492[(8)] = inst_64430);

return statearr_64492;
})();
var statearr_64493_64520 = state_64465__$1;
(statearr_64493_64520[(2)] = null);

(statearr_64493_64520[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64466 === (5))){
var _ = (function (){var statearr_64494 = state_64465;
(statearr_64494[(4)] = cljs.core.rest.call(null,(state_64465[(4)])));

return statearr_64494;
})();
var state_64465__$1 = state_64465;
var ex64490 = (state_64465__$1[(2)]);
var statearr_64495_64521 = state_64465__$1;
(statearr_64495_64521[(5)] = ex64490);


if((ex64490 instanceof Error)){
var statearr_64496_64522 = state_64465__$1;
(statearr_64496_64522[(1)] = (4));

(statearr_64496_64522[(5)] = null);

} else {
throw ex64490;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64466 === (10))){
var inst_64431 = (state_64465[(10)]);
var state_64465__$1 = state_64465;
var statearr_64497_64523 = state_64465__$1;
(statearr_64497_64523[(2)] = inst_64431);

(statearr_64497_64523[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64466 === (8))){
var inst_64459 = (state_64465[(2)]);
var inst_64460 = cljs.core.vals.call(null,inst_64459);
var _ = (function (){var statearr_64498 = state_64465;
(statearr_64498[(4)] = cljs.core.rest.call(null,(state_64465[(4)])));

return statearr_64498;
})();
var state_64465__$1 = state_64465;
var statearr_64499_64524 = state_64465__$1;
(statearr_64499_64524[(2)] = inst_64460);

(statearr_64499_64524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2726__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2726__auto____0 = (function (){
var statearr_64500 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64500[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2726__auto__);

(statearr_64500[(1)] = (1));

return statearr_64500;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2726__auto____1 = (function (state_64465){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_64465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e64501){var ex__2729__auto__ = e64501;
var statearr_64502_64525 = state_64465;
(statearr_64502_64525[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_64465[(4)]))){
var statearr_64503_64526 = state_64465;
(statearr_64503_64526[(1)] = cljs.core.first.call(null,(state_64465[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64527 = state_64465;
state_64465 = G__64527;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2726__auto__ = function(state_64465){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2726__auto____1.call(this,state_64465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2726__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2726__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_64504 = f__2749__auto__.call(null);
(statearr_64504[(6)] = c__2748__auto__);

return statearr_64504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_64672){
var state_val_64673 = (state_64672[(1)]);
if((state_val_64673 === (7))){
var inst_64552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64553 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64554 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64555 = [inst_64553,inst_64554];
var inst_64556 = (new cljs.core.PersistentVector(null,2,(5),inst_64552,inst_64555,null));
var state_64672__$1 = state_64672;
var statearr_64674_64745 = state_64672__$1;
(statearr_64674_64745[(2)] = inst_64556);

(statearr_64674_64745[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (20))){
var inst_64582 = (state_64672[(7)]);
var state_64672__$1 = state_64672;
var statearr_64675_64746 = state_64672__$1;
(statearr_64675_64746[(2)] = inst_64582);

(statearr_64675_64746[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (27))){
var state_64672__$1 = state_64672;
var statearr_64676_64747 = state_64672__$1;
(statearr_64676_64747[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (1))){
var state_64672__$1 = state_64672;
var statearr_64678_64748 = state_64672__$1;
(statearr_64678_64748[(2)] = null);

(statearr_64678_64748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (24))){
var inst_64581 = (state_64672[(8)]);
var state_64672__$1 = state_64672;
if(cljs.core.truth_(inst_64581)){
var statearr_64679_64749 = state_64672__$1;
(statearr_64679_64749[(1)] = (26));

} else {
var statearr_64680_64750 = state_64672__$1;
(statearr_64680_64750[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (39))){
var inst_64628 = (state_64672[(9)]);
var inst_64627 = (state_64672[(10)]);
var inst_64653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64654 = [inst_64627,inst_64628];
var inst_64655 = (new cljs.core.PersistentVector(null,2,(5),inst_64653,inst_64654,null));
var state_64672__$1 = state_64672;
var statearr_64681_64751 = state_64672__$1;
(statearr_64681_64751[(2)] = inst_64655);

(statearr_64681_64751[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (4))){
var inst_64528 = (state_64672[(2)]);
var inst_64529 = fluree.db.util.log.error.call(null,inst_64528);
var inst_64530 = cljs.core.ex_data.call(null,inst_64528);
var inst_64531 = cljs.core.ex_message.call(null,inst_64528);
var inst_64532 = cljs.core.assoc.call(null,inst_64530,new cljs.core.Keyword(null,"message","message",-406056002),inst_64531);
var state_64672__$1 = (function (){var statearr_64682 = state_64672;
(statearr_64682[(11)] = inst_64529);

return statearr_64682;
})();
var statearr_64683_64752 = state_64672__$1;
(statearr_64683_64752[(2)] = inst_64532);

(statearr_64683_64752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (15))){
var inst_64561 = (state_64672[(12)]);
var inst_64566 = (state_64672[(13)]);
var inst_64575 = (state_64672[(2)]);
var inst_64576 = [inst_64566,inst_64575];
var inst_64577 = (new cljs.core.PersistentVector(null,2,(5),inst_64561,inst_64576,null));
var state_64672__$1 = state_64672;
var statearr_64684_64753 = state_64672__$1;
(statearr_64684_64753[(2)] = inst_64577);

(statearr_64684_64753[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (21))){
var inst_64581 = (state_64672[(8)]);
var state_64672__$1 = state_64672;
var statearr_64685_64754 = state_64672__$1;
(statearr_64685_64754[(2)] = inst_64581);

(statearr_64685_64754[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (31))){
var inst_64622 = (state_64672[(2)]);
var state_64672__$1 = state_64672;
var statearr_64686_64755 = state_64672__$1;
(statearr_64686_64755[(2)] = inst_64622);

(statearr_64686_64755[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (32))){
var inst_64628 = (state_64672[(9)]);
var inst_64631 = cljs.core.pos_int_QMARK_.call(null,inst_64628);
var state_64672__$1 = state_64672;
var statearr_64687_64756 = state_64672__$1;
(statearr_64687_64756[(2)] = inst_64631);

(statearr_64687_64756[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (40))){
var inst_64583 = (state_64672[(14)]);
var inst_64659 = (state_64672[(15)]);
var inst_64657 = (state_64672[(2)]);
var inst_64658 = cljs.core.nth.call(null,inst_64657,(0),null);
var inst_64659__$1 = cljs.core.nth.call(null,inst_64657,(1),null);
var inst_64660 = (inst_64659__$1 > inst_64583);
var state_64672__$1 = (function (){var statearr_64688 = state_64672;
(statearr_64688[(16)] = inst_64658);

(statearr_64688[(15)] = inst_64659__$1);

return statearr_64688;
})();
if(cljs.core.truth_(inst_64660)){
var statearr_64689_64757 = state_64672__$1;
(statearr_64689_64757[(1)] = (41));

} else {
var statearr_64690_64758 = state_64672__$1;
(statearr_64690_64758[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (33))){
var inst_64629 = (state_64672[(17)]);
var state_64672__$1 = state_64672;
var statearr_64691_64759 = state_64672__$1;
(statearr_64691_64759[(2)] = inst_64629);

(statearr_64691_64759[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (13))){
var inst_64567 = (state_64672[(18)]);
var inst_64569 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_64567);
var state_64672__$1 = state_64672;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64672__$1,(16),inst_64569);
} else {
if((state_val_64673 === (22))){
var inst_64600 = (state_64672[(2)]);
var state_64672__$1 = state_64672;
if(cljs.core.truth_(inst_64600)){
var statearr_64692_64760 = state_64672__$1;
(statearr_64692_64760[(1)] = (23));

} else {
var statearr_64693_64761 = state_64672__$1;
(statearr_64693_64761[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (36))){
var state_64672__$1 = state_64672;
var statearr_64694_64762 = state_64672__$1;
(statearr_64694_64762[(2)] = null);

(statearr_64694_64762[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (41))){
var inst_64583 = (state_64672[(14)]);
var state_64672__$1 = state_64672;
var statearr_64695_64763 = state_64672__$1;
(statearr_64695_64763[(2)] = inst_64583);

(statearr_64695_64763[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (43))){
var inst_64658 = (state_64672[(16)]);
var inst_64664 = (state_64672[(2)]);
var inst_64665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64666 = [inst_64658,inst_64664];
var inst_64667 = (new cljs.core.PersistentVector(null,2,(5),inst_64665,inst_64666,null));
var _ = (function (){var statearr_64696 = state_64672;
(statearr_64696[(4)] = cljs.core.rest.call(null,(state_64672[(4)])));

return statearr_64696;
})();
var state_64672__$1 = state_64672;
var statearr_64697_64764 = state_64672__$1;
(statearr_64697_64764[(2)] = inst_64667);

(statearr_64697_64764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (29))){
var inst_64558 = (state_64672[(19)]);
var inst_64613 = cljs.core.pr_str.call(null,inst_64558);
var inst_64614 = ["Invalid block range provided: ",inst_64613].join('');
var inst_64615 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64616 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64617 = cljs.core.PersistentHashMap.fromArrays(inst_64615,inst_64616);
var inst_64618 = cljs.core.ex_info.call(null,inst_64614,inst_64617);
var inst_64619 = (function(){throw inst_64618})();
var state_64672__$1 = state_64672;
var statearr_64698_64765 = state_64672__$1;
(statearr_64698_64765[(2)] = inst_64619);

(statearr_64698_64765[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (6))){
var inst_64550 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_64672__$1 = state_64672;
var statearr_64699_64766 = state_64672__$1;
(statearr_64699_64766[(2)] = inst_64550);

(statearr_64699_64766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (28))){
var inst_64624 = (state_64672[(2)]);
var state_64672__$1 = state_64672;
var statearr_64700_64767 = state_64672__$1;
(statearr_64700_64767[(2)] = inst_64624);

(statearr_64700_64767[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (25))){
var inst_64629 = (state_64672[(17)]);
var inst_64627 = (state_64672[(10)]);
var inst_64626 = (state_64672[(2)]);
var inst_64627__$1 = cljs.core.nth.call(null,inst_64626,(0),null);
var inst_64628 = cljs.core.nth.call(null,inst_64626,(1),null);
var inst_64629__$1 = cljs.core.pos_int_QMARK_.call(null,inst_64627__$1);
var state_64672__$1 = (function (){var statearr_64701 = state_64672;
(statearr_64701[(17)] = inst_64629__$1);

(statearr_64701[(9)] = inst_64628);

(statearr_64701[(10)] = inst_64627__$1);

return statearr_64701;
})();
if(inst_64629__$1){
var statearr_64702_64768 = state_64672__$1;
(statearr_64702_64768[(1)] = (32));

} else {
var statearr_64703_64769 = state_64672__$1;
(statearr_64703_64769[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (34))){
var inst_64634 = (state_64672[(2)]);
var inst_64635 = cljs.core.not.call(null,inst_64634);
var state_64672__$1 = state_64672;
if(inst_64635){
var statearr_64704_64770 = state_64672__$1;
(statearr_64704_64770[(1)] = (35));

} else {
var statearr_64705_64771 = state_64672__$1;
(statearr_64705_64771[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (17))){
var inst_64583 = (state_64672[(14)]);
var inst_64581 = (state_64672[(8)]);
var inst_64586 = cljs.core.pr_str.call(null,inst_64581);
var inst_64587 = cljs.core.pr_str.call(null,inst_64583);
var inst_64588 = ["Start block is out of range for this ledger. Start block provided: ",inst_64586,". Database block: ",inst_64587].join('');
var inst_64589 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64590 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64591 = cljs.core.PersistentHashMap.fromArrays(inst_64589,inst_64590);
var inst_64592 = cljs.core.ex_info.call(null,inst_64588,inst_64591);
var inst_64593 = (function(){throw inst_64592})();
var state_64672__$1 = state_64672;
var statearr_64706_64772 = state_64672__$1;
(statearr_64706_64772[(2)] = inst_64593);

(statearr_64706_64772[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (3))){
var inst_64670 = (state_64672[(2)]);
var state_64672__$1 = state_64672;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64672__$1,inst_64670);
} else {
if((state_val_64673 === (12))){
var inst_64558 = (state_64672[(19)]);
var inst_64567 = (state_64672[(18)]);
var inst_64565 = (state_64672[(2)]);
var inst_64566 = fluree.db.util.async.throw_err.call(null,inst_64565);
var inst_64567__$1 = cljs.core.second.call(null,inst_64558);
var state_64672__$1 = (function (){var statearr_64707 = state_64672;
(statearr_64707[(18)] = inst_64567__$1);

(statearr_64707[(13)] = inst_64566);

return statearr_64707;
})();
if(cljs.core.truth_(inst_64567__$1)){
var statearr_64708_64773 = state_64672__$1;
(statearr_64708_64773[(1)] = (13));

} else {
var statearr_64709_64774 = state_64672__$1;
(statearr_64709_64774[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (2))){
var _ = (function (){var statearr_64710 = state_64672;
(statearr_64710[(4)] = cljs.core.cons.call(null,(5),(state_64672[(4)])));

return statearr_64710;
})();
var inst_64547 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64548 = cljs.core.sequential_QMARK_.call(null,inst_64547);
var state_64672__$1 = state_64672;
if(inst_64548){
var statearr_64711_64775 = state_64672__$1;
(statearr_64711_64775[(1)] = (6));

} else {
var statearr_64712_64776 = state_64672__$1;
(statearr_64712_64776[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (23))){
var inst_64582 = (state_64672[(7)]);
var inst_64581 = (state_64672[(8)]);
var inst_64602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64603 = [inst_64581,inst_64582];
var inst_64604 = (new cljs.core.PersistentVector(null,2,(5),inst_64602,inst_64603,null));
var state_64672__$1 = state_64672;
var statearr_64713_64777 = state_64672__$1;
(statearr_64713_64777[(2)] = inst_64604);

(statearr_64713_64777[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (35))){
var inst_64558 = (state_64672[(19)]);
var inst_64637 = cljs.core.pr_str.call(null,inst_64558);
var inst_64638 = ["Invalid block range provided: ",inst_64637].join('');
var inst_64639 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64640 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64641 = cljs.core.PersistentHashMap.fromArrays(inst_64639,inst_64640);
var inst_64642 = cljs.core.ex_info.call(null,inst_64638,inst_64641);
var inst_64643 = (function(){throw inst_64642})();
var state_64672__$1 = state_64672;
var statearr_64714_64778 = state_64672__$1;
(statearr_64714_64778[(2)] = inst_64643);

(statearr_64714_64778[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (19))){
var inst_64581 = (state_64672[(8)]);
var inst_64596 = (state_64672[(2)]);
var state_64672__$1 = (function (){var statearr_64715 = state_64672;
(statearr_64715[(20)] = inst_64596);

return statearr_64715;
})();
if(cljs.core.truth_(inst_64581)){
var statearr_64716_64779 = state_64672__$1;
(statearr_64716_64779[(1)] = (20));

} else {
var statearr_64717_64780 = state_64672__$1;
(statearr_64717_64780[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (11))){
var inst_64583 = (state_64672[(14)]);
var inst_64581 = (state_64672[(8)]);
var inst_64580 = (state_64672[(2)]);
var inst_64581__$1 = cljs.core.nth.call(null,inst_64580,(0),null);
var inst_64582 = cljs.core.nth.call(null,inst_64580,(1),null);
var inst_64583__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64584 = (inst_64581__$1 > inst_64583__$1);
var state_64672__$1 = (function (){var statearr_64719 = state_64672;
(statearr_64719[(7)] = inst_64582);

(statearr_64719[(14)] = inst_64583__$1);

(statearr_64719[(8)] = inst_64581__$1);

return statearr_64719;
})();
if(cljs.core.truth_(inst_64584)){
var statearr_64720_64781 = state_64672__$1;
(statearr_64720_64781[(1)] = (17));

} else {
var statearr_64721_64782 = state_64672__$1;
(statearr_64721_64782[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (9))){
var inst_64558 = (state_64672[(19)]);
var inst_64561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64562 = cljs.core.first.call(null,inst_64558);
var inst_64563 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_64562);
var state_64672__$1 = (function (){var statearr_64722 = state_64672;
(statearr_64722[(12)] = inst_64561);

return statearr_64722;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64672__$1,(12),inst_64563);
} else {
if((state_val_64673 === (5))){
var _ = (function (){var statearr_64723 = state_64672;
(statearr_64723[(4)] = cljs.core.rest.call(null,(state_64672[(4)])));

return statearr_64723;
})();
var state_64672__$1 = state_64672;
var ex64718 = (state_64672__$1[(2)]);
var statearr_64724_64783 = state_64672__$1;
(statearr_64724_64783[(5)] = ex64718);


var statearr_64725_64784 = state_64672__$1;
(statearr_64725_64784[(1)] = (4));

(statearr_64725_64784[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (14))){
var state_64672__$1 = state_64672;
var statearr_64726_64785 = state_64672__$1;
(statearr_64726_64785[(2)] = null);

(statearr_64726_64785[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (26))){
var inst_64581 = (state_64672[(8)]);
var inst_64607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64608 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64609 = [inst_64581,inst_64608];
var inst_64610 = (new cljs.core.PersistentVector(null,2,(5),inst_64607,inst_64609,null));
var state_64672__$1 = state_64672;
var statearr_64727_64786 = state_64672__$1;
(statearr_64727_64786[(2)] = inst_64610);

(statearr_64727_64786[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (16))){
var inst_64571 = (state_64672[(2)]);
var inst_64572 = fluree.db.util.async.throw_err.call(null,inst_64571);
var state_64672__$1 = state_64672;
var statearr_64728_64787 = state_64672__$1;
(statearr_64728_64787[(2)] = inst_64572);

(statearr_64728_64787[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (38))){
var inst_64628 = (state_64672[(9)]);
var inst_64627 = (state_64672[(10)]);
var inst_64649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64650 = [inst_64628,inst_64627];
var inst_64651 = (new cljs.core.PersistentVector(null,2,(5),inst_64649,inst_64650,null));
var state_64672__$1 = state_64672;
var statearr_64729_64788 = state_64672__$1;
(statearr_64729_64788[(2)] = inst_64651);

(statearr_64729_64788[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (30))){
var state_64672__$1 = state_64672;
var statearr_64730_64789 = state_64672__$1;
(statearr_64730_64789[(2)] = null);

(statearr_64730_64789[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (10))){
var inst_64558 = (state_64672[(19)]);
var state_64672__$1 = state_64672;
var statearr_64731_64790 = state_64672__$1;
(statearr_64731_64790[(2)] = inst_64558);

(statearr_64731_64790[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (18))){
var state_64672__$1 = state_64672;
var statearr_64732_64791 = state_64672__$1;
(statearr_64732_64791[(2)] = null);

(statearr_64732_64791[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (42))){
var inst_64659 = (state_64672[(15)]);
var state_64672__$1 = state_64672;
var statearr_64733_64792 = state_64672__$1;
(statearr_64733_64792[(2)] = inst_64659);

(statearr_64733_64792[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (37))){
var inst_64628 = (state_64672[(9)]);
var inst_64627 = (state_64672[(10)]);
var inst_64646 = (state_64672[(2)]);
var inst_64647 = (inst_64628 < inst_64627);
var state_64672__$1 = (function (){var statearr_64734 = state_64672;
(statearr_64734[(21)] = inst_64646);

return statearr_64734;
})();
if(cljs.core.truth_(inst_64647)){
var statearr_64735_64793 = state_64672__$1;
(statearr_64735_64793[(1)] = (38));

} else {
var statearr_64736_64794 = state_64672__$1;
(statearr_64736_64794[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64673 === (8))){
var inst_64558 = (state_64672[(19)]);
var inst_64558__$1 = (state_64672[(2)]);
var inst_64559 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_64558__$1);
var state_64672__$1 = (function (){var statearr_64737 = state_64672;
(statearr_64737[(19)] = inst_64558__$1);

return statearr_64737;
})();
if(cljs.core.truth_(inst_64559)){
var statearr_64738_64795 = state_64672__$1;
(statearr_64738_64795[(1)] = (9));

} else {
var statearr_64739_64796 = state_64672__$1;
(statearr_64739_64796[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2726__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2726__auto____0 = (function (){
var statearr_64740 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64740[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2726__auto__);

(statearr_64740[(1)] = (1));

return statearr_64740;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2726__auto____1 = (function (state_64672){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_64672);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e64741){var ex__2729__auto__ = e64741;
var statearr_64742_64797 = state_64672;
(statearr_64742_64797[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_64672[(4)]))){
var statearr_64743_64798 = state_64672;
(statearr_64743_64798[(1)] = cljs.core.first.call(null,(state_64672[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64799 = state_64672;
state_64672 = G__64799;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2726__auto__ = function(state_64672){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2726__auto____1.call(this,state_64672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2726__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2726__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_64744 = f__2749__auto__.call(null);
(statearr_64744[(6)] = c__2748__auto__);

return statearr_64744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__64802 = arguments.length;
switch (G__64802) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_64897){
var state_val_64898 = (state_64897[(1)]);
if((state_val_64898 === (7))){
var inst_64825 = (state_64897[(7)]);
var inst_64828 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_64825);
var state_64897__$1 = state_64897;
var statearr_64899_64950 = state_64897__$1;
(statearr_64899_64950[(2)] = inst_64828);

(statearr_64899_64950[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (20))){
var inst_64864 = (state_64897[(8)]);
var inst_64867 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_64864);
var state_64897__$1 = state_64897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64897__$1,(23),inst_64867);
} else {
if((state_val_64898 === (27))){
var inst_64873 = (state_64897[(9)]);
var inst_64879 = cljs.core.doall.call(null,inst_64873);
var state_64897__$1 = state_64897;
var statearr_64900_64951 = state_64897__$1;
(statearr_64900_64951[(2)] = inst_64879);

(statearr_64900_64951[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (1))){
var state_64897__$1 = state_64897;
var statearr_64901_64952 = state_64897__$1;
(statearr_64901_64952[(2)] = null);

(statearr_64901_64952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (24))){
var inst_64873 = (state_64897[(9)]);
var inst_64876 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_64877 = cljs.core.sequential_QMARK_.call(null,inst_64873);
var state_64897__$1 = (function (){var statearr_64902 = state_64897;
(statearr_64902[(10)] = inst_64876);

return statearr_64902;
})();
if(inst_64877){
var statearr_64903_64953 = state_64897__$1;
(statearr_64903_64953[(1)] = (27));

} else {
var statearr_64904_64954 = state_64897__$1;
(statearr_64904_64954[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (4))){
var inst_64803 = (state_64897[(2)]);
var inst_64804 = fluree.db.util.log.error.call(null,inst_64803);
var inst_64805 = cljs.core.ex_data.call(null,inst_64803);
var inst_64806 = cljs.core.ex_message.call(null,inst_64803);
var inst_64807 = cljs.core.assoc.call(null,inst_64805,new cljs.core.Keyword(null,"message","message",-406056002),inst_64806);
var state_64897__$1 = (function (){var statearr_64905 = state_64897;
(statearr_64905[(11)] = inst_64804);

return statearr_64905;
})();
var statearr_64906_64955 = state_64897__$1;
(statearr_64906_64955[(2)] = inst_64807);

(statearr_64906_64955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (15))){
var inst_64825 = (state_64897[(7)]);
var inst_64838 = (state_64897[(2)]);
var inst_64839 = cljs.core.ex_info.call(null,inst_64838,inst_64825);
var inst_64840 = (function(){throw inst_64839})();
var state_64897__$1 = state_64897;
var statearr_64907_64956 = state_64897__$1;
(statearr_64907_64956[(2)] = inst_64840);

(statearr_64907_64956[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (21))){
var inst_64864 = (state_64897[(8)]);
var state_64897__$1 = state_64897;
var statearr_64908_64957 = state_64897__$1;
(statearr_64908_64957[(2)] = inst_64864);

(statearr_64908_64957[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (13))){
var inst_64833 = (state_64897[(12)]);
var state_64897__$1 = state_64897;
var statearr_64909_64958 = state_64897__$1;
(statearr_64909_64958[(2)] = inst_64833);

(statearr_64909_64958[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (22))){
var inst_64873 = (state_64897[(2)]);
var inst_64874 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_64897__$1 = (function (){var statearr_64910 = state_64897;
(statearr_64910[(9)] = inst_64873);

return statearr_64910;
})();
if(cljs.core.truth_(inst_64874)){
var statearr_64911_64959 = state_64897__$1;
(statearr_64911_64959[(1)] = (24));

} else {
var statearr_64912_64960 = state_64897__$1;
(statearr_64912_64960[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (29))){
var inst_64825 = (state_64897[(7)]);
var inst_64845 = (state_64897[(13)]);
var inst_64873 = (state_64897[(9)]);
var inst_64843 = (state_64897[(14)]);
var inst_64820 = (state_64897[(15)]);
var inst_64876 = (state_64897[(10)]);
var inst_64821 = (state_64897[(16)]);
var inst_64819 = (state_64897[(17)]);
var inst_64844 = (state_64897[(18)]);
var inst_64817 = (state_64897[(19)]);
var inst_64864 = (state_64897[(8)]);
var inst_64882 = (state_64897[(2)]);
var inst_64883 = (function (){var vec__64814 = inst_64825;
var network = inst_64820;
var block_start = inst_64844;
var block_end = inst_64845;
var range = inst_64825;
var db_id = inst_64821;
var _ = inst_64843;
var start = inst_64817;
var result_SINGLEQUOTE_ = inst_64873;
var result = inst_64864;
var map__64813 = inst_64819;
return (function (p1__64800_SHARP_){
return goog.string.format("%.2fms",p1__64800_SHARP_);
});
})();
var inst_64884 = fluree.db.util.core.current_time_millis.call(null);
var inst_64885 = (inst_64884 - inst_64817);
var inst_64886 = (inst_64885 / (1000000));
var inst_64887 = inst_64883.call(null,inst_64886);
var inst_64888 = [(200),inst_64882,(100),inst_64887];
var inst_64889 = cljs.core.PersistentHashMap.fromArrays(inst_64876,inst_64888);
var state_64897__$1 = state_64897;
var statearr_64913_64961 = state_64897__$1;
(statearr_64913_64961[(2)] = inst_64889);

(statearr_64913_64961[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (6))){
var inst_64825 = (state_64897[(7)]);
var inst_64826 = (state_64897[(20)]);
var inst_64824 = (state_64897[(2)]);
var inst_64825__$1 = fluree.db.util.async.throw_err.call(null,inst_64824);
var inst_64826__$1 = cljs.core.map_QMARK_.call(null,inst_64825__$1);
var state_64897__$1 = (function (){var statearr_64914 = state_64897;
(statearr_64914[(7)] = inst_64825__$1);

(statearr_64914[(20)] = inst_64826__$1);

return statearr_64914;
})();
if(inst_64826__$1){
var statearr_64915_64962 = state_64897__$1;
(statearr_64915_64962[(1)] = (7));

} else {
var statearr_64916_64963 = state_64897__$1;
(statearr_64916_64963[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (28))){
var inst_64873 = (state_64897[(9)]);
var state_64897__$1 = state_64897;
var statearr_64917_64964 = state_64897__$1;
(statearr_64917_64964[(2)] = inst_64873);

(statearr_64917_64964[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (25))){
var inst_64873 = (state_64897[(9)]);
var state_64897__$1 = state_64897;
var statearr_64918_64965 = state_64897__$1;
(statearr_64918_64965[(2)] = inst_64873);

(statearr_64918_64965[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (17))){
var inst_64856 = cljs.core.pr_str.call(null,query_map);
var inst_64857 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_64856].join('');
var inst_64858 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64859 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64860 = cljs.core.PersistentHashMap.fromArrays(inst_64858,inst_64859);
var inst_64861 = cljs.core.ex_info.call(null,inst_64857,inst_64860);
var inst_64862 = (function(){throw inst_64861})();
var state_64897__$1 = state_64897;
var statearr_64919_64966 = state_64897__$1;
(statearr_64919_64966[(2)] = inst_64862);

(statearr_64919_64966[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (3))){
var inst_64895 = (state_64897[(2)]);
var state_64897__$1 = state_64897;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64897__$1,inst_64895);
} else {
if((state_val_64898 === (12))){
var inst_64825 = (state_64897[(7)]);
var inst_64843 = (state_64897[(2)]);
var inst_64844 = cljs.core.nth.call(null,inst_64825,(0),null);
var inst_64845 = cljs.core.nth.call(null,inst_64825,(1),null);
var inst_64846 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_64847 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_64848 = cljs.core.keys.call(null,inst_64847);
var inst_64849 = cljs.core._EQ_.call(null,inst_64846,inst_64848);
var state_64897__$1 = (function (){var statearr_64920 = state_64897;
(statearr_64920[(13)] = inst_64845);

(statearr_64920[(14)] = inst_64843);

(statearr_64920[(18)] = inst_64844);

return statearr_64920;
})();
if(inst_64849){
var statearr_64921_64967 = state_64897__$1;
(statearr_64921_64967[(1)] = (16));

} else {
var statearr_64922_64968 = state_64897__$1;
(statearr_64922_64968[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (2))){
var inst_64819 = (state_64897[(17)]);
var _ = (function (){var statearr_64923 = state_64897;
(statearr_64923[(4)] = cljs.core.cons.call(null,(5),(state_64897[(4)])));

return statearr_64923;
})();
var inst_64817 = fluree.db.util.core.current_time_millis.call(null);
var inst_64818 = db;
var inst_64819__$1 = cljs.core.__destructure_map.call(null,inst_64818);
var inst_64820 = cljs.core.get.call(null,inst_64819__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_64821 = cljs.core.get.call(null,inst_64819__$1,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_64822 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_64897__$1 = (function (){var statearr_64924 = state_64897;
(statearr_64924[(15)] = inst_64820);

(statearr_64924[(16)] = inst_64821);

(statearr_64924[(17)] = inst_64819__$1);

(statearr_64924[(19)] = inst_64817);

return statearr_64924;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64897__$1,(6),inst_64822);
} else {
if((state_val_64898 === (23))){
var inst_64869 = (state_64897[(2)]);
var inst_64870 = fluree.db.util.async.throw_err.call(null,inst_64869);
var state_64897__$1 = state_64897;
var statearr_64925_64969 = state_64897__$1;
(statearr_64925_64969[(2)] = inst_64870);

(statearr_64925_64969[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (19))){
var inst_64853 = (state_64897[(2)]);
var inst_64854 = fluree.db.util.async.throw_err.call(null,inst_64853);
var state_64897__$1 = state_64897;
var statearr_64926_64970 = state_64897__$1;
(statearr_64926_64970[(2)] = inst_64854);

(statearr_64926_64970[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (11))){
var state_64897__$1 = state_64897;
var statearr_64928_64971 = state_64897__$1;
(statearr_64928_64971[(2)] = null);

(statearr_64928_64971[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (9))){
var inst_64831 = (state_64897[(2)]);
var state_64897__$1 = state_64897;
if(cljs.core.truth_(inst_64831)){
var statearr_64929_64972 = state_64897__$1;
(statearr_64929_64972[(1)] = (10));

} else {
var statearr_64930_64973 = state_64897__$1;
(statearr_64930_64973[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (5))){
var _ = (function (){var statearr_64931 = state_64897;
(statearr_64931[(4)] = cljs.core.rest.call(null,(state_64897[(4)])));

return statearr_64931;
})();
var state_64897__$1 = state_64897;
var ex64927 = (state_64897__$1[(2)]);
var statearr_64932_64974 = state_64897__$1;
(statearr_64932_64974[(5)] = ex64927);


var statearr_64933_64975 = state_64897__$1;
(statearr_64933_64975[(1)] = (4));

(statearr_64933_64975[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (14))){
var inst_64820 = (state_64897[(15)]);
var inst_64821 = (state_64897[(16)]);
var inst_64836 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64820),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64821)].join('');
var state_64897__$1 = state_64897;
var statearr_64934_64976 = state_64897__$1;
(statearr_64934_64976[(2)] = inst_64836);

(statearr_64934_64976[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (26))){
var inst_64892 = (state_64897[(2)]);
var _ = (function (){var statearr_64935 = state_64897;
(statearr_64935[(4)] = cljs.core.rest.call(null,(state_64897[(4)])));

return statearr_64935;
})();
var state_64897__$1 = state_64897;
var statearr_64936_64977 = state_64897__$1;
(statearr_64936_64977[(2)] = inst_64892);

(statearr_64936_64977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (16))){
var inst_64845 = (state_64897[(13)]);
var inst_64844 = (state_64897[(18)]);
var inst_64851 = fluree.db.query.block.block_range.call(null,db,inst_64844,inst_64845,opts);
var state_64897__$1 = state_64897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64897__$1,(19),inst_64851);
} else {
if((state_val_64898 === (10))){
var inst_64825 = (state_64897[(7)]);
var inst_64833 = (state_64897[(12)]);
var inst_64833__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_64825);
var state_64897__$1 = (function (){var statearr_64937 = state_64897;
(statearr_64937[(12)] = inst_64833__$1);

return statearr_64937;
})();
if(cljs.core.truth_(inst_64833__$1)){
var statearr_64938_64978 = state_64897__$1;
(statearr_64938_64978[(1)] = (13));

} else {
var statearr_64939_64979 = state_64897__$1;
(statearr_64939_64979[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (18))){
var inst_64864 = (state_64897[(2)]);
var inst_64865 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_64897__$1 = (function (){var statearr_64940 = state_64897;
(statearr_64940[(8)] = inst_64864);

return statearr_64940;
})();
if(cljs.core.truth_(inst_64865)){
var statearr_64941_64980 = state_64897__$1;
(statearr_64941_64980[(1)] = (20));

} else {
var statearr_64942_64981 = state_64897__$1;
(statearr_64942_64981[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64898 === (8))){
var inst_64826 = (state_64897[(20)]);
var state_64897__$1 = state_64897;
var statearr_64943_64982 = state_64897__$1;
(statearr_64943_64982[(2)] = inst_64826);

(statearr_64943_64982[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2726__auto__ = null;
var fluree$db$api_js$state_machine__2726__auto____0 = (function (){
var statearr_64944 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64944[(0)] = fluree$db$api_js$state_machine__2726__auto__);

(statearr_64944[(1)] = (1));

return statearr_64944;
});
var fluree$db$api_js$state_machine__2726__auto____1 = (function (state_64897){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_64897);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e64945){var ex__2729__auto__ = e64945;
var statearr_64946_64983 = state_64897;
(statearr_64946_64983[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_64897[(4)]))){
var statearr_64947_64984 = state_64897;
(statearr_64947_64984[(1)] = cljs.core.first.call(null,(state_64897[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64985 = state_64897;
state_64897 = G__64985;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2726__auto__ = function(state_64897){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2726__auto____1.call(this,state_64897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2726__auto____0;
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2726__auto____1;
return fluree$db$api_js$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_64948 = f__2749__auto__.call(null);
(statearr_64948[(6)] = c__2748__auto__);

return statearr_64948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__64987 = arguments.length;
switch (G__64987) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_65182){
var state_val_65183 = (state_65182[(1)]);
if((state_val_65183 === (62))){
var inst_65180 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65182__$1,inst_65180);
} else {
if((state_val_65183 === (7))){
var inst_65008 = (state_65182[(7)]);
var inst_65018 = cljs.core.not_EQ_.call(null,(1),inst_65008);
var state_65182__$1 = state_65182;
var statearr_65184_65275 = state_65182__$1;
(statearr_65184_65275[(2)] = inst_65018);

(statearr_65184_65275[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (59))){
var inst_65168 = (state_65182[(2)]);
var inst_65169 = fluree.db.util.async.throw_err.call(null,inst_65168);
var state_65182__$1 = state_65182;
var statearr_65185_65276 = state_65182__$1;
(statearr_65185_65276[(2)] = inst_65169);

(statearr_65185_65276[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (20))){
var inst_65084 = (state_65182[(8)]);
var inst_65076 = (state_65182[(9)]);
var inst_65076__$1 = (state_65182[(2)]);
var inst_65077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65078 = cljs.core.get.call(null,inst_65076__$1,(0));
var inst_65079 = cljs.core.get.call(null,inst_65076__$1,(1));
var inst_65080 = cljs.core.get.call(null,inst_65076__$1,(2));
var inst_65081 = cljs.core.get.call(null,inst_65076__$1,(3));
var inst_65082 = [inst_65078,inst_65079,inst_65080,inst_65081];
var inst_65083 = (new cljs.core.PersistentVector(null,4,(5),inst_65077,inst_65082,null));
var inst_65084__$1 = cljs.core.nth.call(null,inst_65083,(0),null);
var inst_65085 = cljs.core.nth.call(null,inst_65083,(1),null);
var inst_65086 = cljs.core.nth.call(null,inst_65083,(2),null);
var inst_65087 = cljs.core.nth.call(null,inst_65083,(3),null);
var inst_65088 = (inst_65084__$1 == null);
var inst_65089 = cljs.core.not.call(null,inst_65088);
var state_65182__$1 = (function (){var statearr_65186 = state_65182;
(statearr_65186[(10)] = inst_65087);

(statearr_65186[(11)] = inst_65086);

(statearr_65186[(12)] = inst_65085);

(statearr_65186[(8)] = inst_65084__$1);

(statearr_65186[(9)] = inst_65076__$1);

return statearr_65186;
})();
if(inst_65089){
var statearr_65187_65277 = state_65182__$1;
(statearr_65187_65277[(1)] = (30));

} else {
var statearr_65188_65278 = state_65182__$1;
(statearr_65188_65278[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (58))){
var inst_65016 = (state_65182[(13)]);
var inst_65172 = (state_65182[(2)]);
var state_65182__$1 = (function (){var statearr_65189 = state_65182;
(statearr_65189[(14)] = inst_65172);

return statearr_65189;
})();
if(cljs.core.truth_(inst_65016)){
var statearr_65190_65279 = state_65182__$1;
(statearr_65190_65279[(1)] = (60));

} else {
var statearr_65191_65280 = state_65182__$1;
(statearr_65191_65280[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (60))){
var inst_65172 = (state_65182[(14)]);
var inst_65160 = (state_65182[(15)]);
var inst_65174 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_65175 = cljs.core.count.call(null,inst_65160);
var inst_65176 = [inst_65172,inst_65175,(200)];
var inst_65177 = cljs.core.PersistentHashMap.fromArrays(inst_65174,inst_65176);
var state_65182__$1 = state_65182;
var statearr_65192_65281 = state_65182__$1;
(statearr_65192_65281[(2)] = inst_65177);

(statearr_65192_65281[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (27))){
var inst_64995 = (state_65182[(16)]);
var inst_65064 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64995)].join('');
var inst_65065 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65066 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65067 = cljs.core.PersistentHashMap.fromArrays(inst_65065,inst_65066);
var inst_65068 = cljs.core.ex_info.call(null,inst_65064,inst_65067);
var inst_65069 = (function(){throw inst_65068})();
var state_65182__$1 = state_65182;
var statearr_65193_65282 = state_65182__$1;
(statearr_65193_65282[(2)] = inst_65069);

(statearr_65193_65282[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (1))){
var inst_64992 = query_map;
var inst_64993 = cljs.core.__destructure_map.call(null,inst_64992);
var inst_64994 = cljs.core.get.call(null,inst_64993,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64995 = cljs.core.get.call(null,inst_64993,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_64996 = cljs.core.get.call(null,inst_64993,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_65182__$1 = (function (){var statearr_65194 = state_65182;
(statearr_65194[(16)] = inst_64995);

(statearr_65194[(17)] = inst_64996);

(statearr_65194[(18)] = inst_64994);

return statearr_65194;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65182__$1,(2),sources);
} else {
if((state_val_65183 === (24))){
var inst_64995 = (state_65182[(16)]);
var inst_65053 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64995)].join('');
var inst_65054 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65055 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65056 = cljs.core.PersistentHashMap.fromArrays(inst_65054,inst_65055);
var inst_65057 = cljs.core.ex_info.call(null,inst_65053,inst_65056);
var inst_65058 = (function(){throw inst_65057})();
var state_65182__$1 = state_65182;
var statearr_65195_65283 = state_65182__$1;
(statearr_65195_65283[(2)] = inst_65058);

(statearr_65195_65283[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (55))){
var inst_64996 = (state_65182[(17)]);
var inst_65163 = (state_65182[(2)]);
var inst_65164 = fluree.db.util.async.throw_err.call(null,inst_65163);
var state_65182__$1 = (function (){var statearr_65196 = state_65182;
(statearr_65196[(19)] = inst_65164);

return statearr_65196;
})();
if(cljs.core.truth_(inst_64996)){
var statearr_65197_65284 = state_65182__$1;
(statearr_65197_65284[(1)] = (56));

} else {
var statearr_65198_65285 = state_65182__$1;
(statearr_65198_65285[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (39))){
var inst_65087 = (state_65182[(10)]);
var inst_65086 = (state_65182[(11)]);
var inst_65085 = (state_65182[(12)]);
var inst_65084 = (state_65182[(8)]);
var inst_65108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65110 = [inst_65085,inst_65084,inst_65086,inst_65087];
var inst_65111 = (new cljs.core.PersistentVector(null,4,(5),inst_65109,inst_65110,null));
var inst_65112 = [inst_65111,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_65113 = (new cljs.core.PersistentVector(null,2,(5),inst_65108,inst_65112,null));
var state_65182__$1 = state_65182;
var statearr_65199_65286 = state_65182__$1;
(statearr_65199_65286[(2)] = inst_65113);

(statearr_65199_65286[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (46))){
var inst_65118 = (state_65182[(20)]);
var state_65182__$1 = state_65182;
var statearr_65200_65287 = state_65182__$1;
(statearr_65200_65287[(2)] = inst_65118);

(statearr_65200_65287[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (4))){
var state_65182__$1 = state_65182;
var statearr_65201_65288 = state_65182__$1;
(statearr_65201_65288[(2)] = null);

(statearr_65201_65288[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (54))){
var inst_64999 = (state_65182[(21)]);
var inst_65160 = (state_65182[(15)]);
var inst_65159 = (state_65182[(2)]);
var inst_65160__$1 = fluree.db.util.async.throw_err.call(null,inst_65159);
var inst_65161 = fluree.db.api_js.format_history_resp.call(null,inst_64999,inst_65160__$1);
var state_65182__$1 = (function (){var statearr_65202 = state_65182;
(statearr_65202[(15)] = inst_65160__$1);

return statearr_65202;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65182__$1,(55),inst_65161);
} else {
if((state_val_65183 === (15))){
var inst_64999 = (state_65182[(21)]);
var inst_65040 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64999);
var state_65182__$1 = state_65182;
var statearr_65203_65289 = state_65182__$1;
(statearr_65203_65289[(2)] = inst_65040);

(statearr_65203_65289[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (48))){
var inst_65087 = (state_65182[(10)]);
var inst_65086 = (state_65182[(11)]);
var inst_65085 = (state_65182[(12)]);
var inst_65084 = (state_65182[(8)]);
var inst_65129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65131 = [inst_65085,inst_65086,inst_65084,inst_65087];
var inst_65132 = (new cljs.core.PersistentVector(null,4,(5),inst_65130,inst_65131,null));
var inst_65133 = [inst_65132,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_65134 = (new cljs.core.PersistentVector(null,2,(5),inst_65129,inst_65133,null));
var state_65182__$1 = state_65182;
var statearr_65204_65290 = state_65182__$1;
(statearr_65204_65290[(2)] = inst_65134);

(statearr_65204_65290[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (50))){
var inst_65147 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
var statearr_65205_65291 = state_65182__$1;
(statearr_65205_65291[(2)] = inst_65147);

(statearr_65205_65291[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (21))){
var inst_64995 = (state_65182[(16)]);
var inst_65051 = cljs.core.empty_QMARK_.call(null,inst_64995);
var state_65182__$1 = state_65182;
if(inst_65051){
var statearr_65206_65292 = state_65182__$1;
(statearr_65206_65292[(1)] = (24));

} else {
var statearr_65207_65293 = state_65182__$1;
(statearr_65207_65293[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (31))){
var inst_65095 = (state_65182[(22)]);
var inst_65084 = (state_65182[(8)]);
var inst_65095__$1 = (inst_65084 == null);
var state_65182__$1 = (function (){var statearr_65208 = state_65182;
(statearr_65208[(22)] = inst_65095__$1);

return statearr_65208;
})();
if(cljs.core.truth_(inst_65095__$1)){
var statearr_65209_65294 = state_65182__$1;
(statearr_65209_65294[(1)] = (33));

} else {
var statearr_65210_65295 = state_65182__$1;
(statearr_65210_65295[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (32))){
var inst_64999 = (state_65182[(21)]);
var inst_65032 = (state_65182[(23)]);
var inst_65042 = (state_65182[(24)]);
var inst_65151 = (state_65182[(2)]);
var inst_65152 = cljs.core.nth.call(null,inst_65151,(0),null);
var inst_65153 = cljs.core.nth.call(null,inst_65151,(1),null);
var inst_65154 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_65155 = [inst_65032,inst_65042];
var inst_65156 = cljs.core.PersistentHashMap.fromArrays(inst_65154,inst_65155);
var inst_65157 = fluree.db.query.range.time_range.call(null,inst_64999,inst_65153,cljs.core._EQ_,inst_65152,inst_65156);
var state_65182__$1 = state_65182;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65182__$1,(54),inst_65157);
} else {
if((state_val_65183 === (40))){
var inst_65084 = (state_65182[(8)]);
var inst_65115 = (state_65182[(25)]);
var inst_65115__$1 = (inst_65084 == null);
var state_65182__$1 = (function (){var statearr_65211 = state_65182;
(statearr_65211[(25)] = inst_65115__$1);

return statearr_65211;
})();
if(cljs.core.truth_(inst_65115__$1)){
var statearr_65212_65296 = state_65182__$1;
(statearr_65212_65296[(1)] = (42));

} else {
var statearr_65213_65297 = state_65182__$1;
(statearr_65213_65297[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (56))){
var inst_64999 = (state_65182[(21)]);
var inst_65164 = (state_65182[(19)]);
var inst_65166 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_64999,inst_65164);
var state_65182__$1 = state_65182;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65182__$1,(59),inst_65166);
} else {
if((state_val_65183 === (33))){
var inst_65085 = (state_65182[(12)]);
var inst_65098 = (state_65182[(26)]);
var inst_65097 = (inst_65085 == null);
var inst_65098__$1 = cljs.core.not.call(null,inst_65097);
var state_65182__$1 = (function (){var statearr_65214 = state_65182;
(statearr_65214[(26)] = inst_65098__$1);

return statearr_65214;
})();
if(inst_65098__$1){
var statearr_65215_65298 = state_65182__$1;
(statearr_65215_65298[(1)] = (36));

} else {
var statearr_65216_65299 = state_65182__$1;
(statearr_65216_65299[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (13))){
var inst_65026 = (state_65182[(2)]);
var inst_65027 = fluree.db.util.async.throw_err.call(null,inst_65026);
var inst_65028 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65027);
var inst_65029 = (inst_65028 - (1));
var state_65182__$1 = state_65182;
var statearr_65217_65300 = state_65182__$1;
(statearr_65217_65300[(2)] = inst_65029);

(statearr_65217_65300[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (22))){
var state_65182__$1 = state_65182;
var statearr_65218_65301 = state_65182__$1;
(statearr_65218_65301[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (36))){
var inst_65086 = (state_65182[(11)]);
var inst_65100 = (inst_65086 == null);
var state_65182__$1 = state_65182;
var statearr_65220_65302 = state_65182__$1;
(statearr_65220_65302[(2)] = inst_65100);

(statearr_65220_65302[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (41))){
var inst_65149 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
var statearr_65221_65303 = state_65182__$1;
(statearr_65221_65303[(2)] = inst_65149);

(statearr_65221_65303[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (43))){
var inst_65115 = (state_65182[(25)]);
var state_65182__$1 = state_65182;
var statearr_65222_65304 = state_65182__$1;
(statearr_65222_65304[(2)] = inst_65115);

(statearr_65222_65304[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (61))){
var inst_65172 = (state_65182[(14)]);
var state_65182__$1 = state_65182;
var statearr_65223_65305 = state_65182__$1;
(statearr_65223_65305[(2)] = inst_65172);

(statearr_65223_65305[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (29))){
var inst_65072 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
var statearr_65224_65306 = state_65182__$1;
(statearr_65224_65306[(2)] = inst_65072);

(statearr_65224_65306[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (44))){
var inst_65127 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
if(cljs.core.truth_(inst_65127)){
var statearr_65225_65307 = state_65182__$1;
(statearr_65225_65307[(1)] = (48));

} else {
var statearr_65226_65308 = state_65182__$1;
(statearr_65226_65308[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (6))){
var inst_65003 = (state_65182[(2)]);
var inst_65004 = fluree.db.util.async.throw_err.call(null,inst_65003);
var state_65182__$1 = state_65182;
var statearr_65227_65309 = state_65182__$1;
(statearr_65227_65309[(2)] = inst_65004);

(statearr_65227_65309[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (28))){
var state_65182__$1 = state_65182;
var statearr_65228_65310 = state_65182__$1;
(statearr_65228_65310[(2)] = null);

(statearr_65228_65310[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (51))){
var inst_64995 = (state_65182[(16)]);
var inst_65137 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64995)].join('');
var inst_65138 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65139 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65140 = cljs.core.PersistentHashMap.fromArrays(inst_65138,inst_65139);
var inst_65141 = cljs.core.ex_info.call(null,inst_65137,inst_65140);
var inst_65142 = (function(){throw inst_65141})();
var state_65182__$1 = state_65182;
var statearr_65229_65311 = state_65182__$1;
(statearr_65229_65311[(2)] = inst_65142);

(statearr_65229_65311[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (25))){
var inst_64995 = (state_65182[(16)]);
var state_65182__$1 = state_65182;
var statearr_65230_65312 = state_65182__$1;
(statearr_65230_65312[(2)] = inst_64995);

(statearr_65230_65312[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (34))){
var inst_65095 = (state_65182[(22)]);
var state_65182__$1 = state_65182;
var statearr_65231_65313 = state_65182__$1;
(statearr_65231_65313[(2)] = inst_65095);

(statearr_65231_65313[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (17))){
var inst_65036 = (state_65182[(2)]);
var inst_65037 = fluree.db.util.async.throw_err.call(null,inst_65036);
var inst_65038 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65037);
var state_65182__$1 = state_65182;
var statearr_65232_65314 = state_65182__$1;
(statearr_65232_65314[(2)] = inst_65038);

(statearr_65232_65314[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (3))){
var inst_64999 = (state_65182[(21)]);
var inst_65001 = fluree.db.api_js.resolve_block_range.call(null,inst_64999,query_map);
var state_65182__$1 = state_65182;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65182__$1,(6),inst_65001);
} else {
if((state_val_65183 === (12))){
var inst_65009 = (state_65182[(27)]);
var inst_65032 = (state_65182[(2)]);
var state_65182__$1 = (function (){var statearr_65233 = state_65182;
(statearr_65233[(23)] = inst_65032);

return statearr_65233;
})();
if(cljs.core.truth_(inst_65009)){
var statearr_65234_65315 = state_65182__$1;
(statearr_65234_65315[(1)] = (14));

} else {
var statearr_65235_65316 = state_65182__$1;
(statearr_65235_65316[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (2))){
var inst_64994 = (state_65182[(18)]);
var inst_64998 = (state_65182[(2)]);
var inst_64999 = fluree.db.util.async.throw_err.call(null,inst_64998);
var state_65182__$1 = (function (){var statearr_65236 = state_65182;
(statearr_65236[(21)] = inst_64999);

return statearr_65236;
})();
if(cljs.core.truth_(inst_64994)){
var statearr_65237_65317 = state_65182__$1;
(statearr_65237_65317[(1)] = (3));

} else {
var statearr_65238_65318 = state_65182__$1;
(statearr_65238_65318[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (23))){
var inst_65074 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
var statearr_65239_65319 = state_65182__$1;
(statearr_65239_65319[(2)] = inst_65074);

(statearr_65239_65319[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (47))){
var inst_65124 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
var statearr_65240_65320 = state_65182__$1;
(statearr_65240_65320[(2)] = inst_65124);

(statearr_65240_65320[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (35))){
var inst_65106 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
if(cljs.core.truth_(inst_65106)){
var statearr_65241_65321 = state_65182__$1;
(statearr_65241_65321[(1)] = (39));

} else {
var statearr_65242_65322 = state_65182__$1;
(statearr_65242_65322[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (19))){
var inst_64995 = (state_65182[(16)]);
var inst_65049 = cljs.core.sequential_QMARK_.call(null,inst_64995);
var state_65182__$1 = state_65182;
if(inst_65049){
var statearr_65243_65323 = state_65182__$1;
(statearr_65243_65323[(1)] = (21));

} else {
var statearr_65244_65324 = state_65182__$1;
(statearr_65244_65324[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (57))){
var inst_65164 = (state_65182[(19)]);
var state_65182__$1 = state_65182;
var statearr_65245_65325 = state_65182__$1;
(statearr_65245_65325[(2)] = inst_65164);

(statearr_65245_65325[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (11))){
var state_65182__$1 = state_65182;
var statearr_65246_65326 = state_65182__$1;
(statearr_65246_65326[(2)] = (-1));

(statearr_65246_65326[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (9))){
var inst_65021 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
if(cljs.core.truth_(inst_65021)){
var statearr_65247_65327 = state_65182__$1;
(statearr_65247_65327[(1)] = (10));

} else {
var statearr_65248_65328 = state_65182__$1;
(statearr_65248_65328[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (5))){
var inst_65008 = (state_65182[(7)]);
var inst_65007 = (state_65182[(2)]);
var inst_65008__$1 = cljs.core.nth.call(null,inst_65007,(0),null);
var inst_65009 = cljs.core.nth.call(null,inst_65007,(1),null);
var inst_65016 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_65182__$1 = (function (){var statearr_65249 = state_65182;
(statearr_65249[(7)] = inst_65008__$1);

(statearr_65249[(13)] = inst_65016);

(statearr_65249[(27)] = inst_65009);

return statearr_65249;
})();
if(cljs.core.truth_(inst_65008__$1)){
var statearr_65250_65329 = state_65182__$1;
(statearr_65250_65329[(1)] = (7));

} else {
var statearr_65251_65330 = state_65182__$1;
(statearr_65251_65330[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (14))){
var inst_64999 = (state_65182[(21)]);
var inst_65009 = (state_65182[(27)]);
var inst_65034 = fluree.db.time_travel.as_of_block.call(null,inst_64999,inst_65009);
var state_65182__$1 = state_65182;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65182__$1,(17),inst_65034);
} else {
if((state_val_65183 === (45))){
var inst_65086 = (state_65182[(11)]);
var inst_65120 = (inst_65086 == null);
var inst_65121 = cljs.core.not.call(null,inst_65120);
var state_65182__$1 = state_65182;
var statearr_65252_65331 = state_65182__$1;
(statearr_65252_65331[(2)] = inst_65121);

(statearr_65252_65331[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (53))){
var inst_65145 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
var statearr_65253_65332 = state_65182__$1;
(statearr_65253_65332[(2)] = inst_65145);

(statearr_65253_65332[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (26))){
var inst_65061 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
var statearr_65254_65333 = state_65182__$1;
(statearr_65254_65333[(2)] = inst_65061);

(statearr_65254_65333[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (16))){
var inst_64995 = (state_65182[(16)]);
var inst_65042 = (state_65182[(2)]);
var inst_65043 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_64995);
var state_65182__$1 = (function (){var statearr_65255 = state_65182;
(statearr_65255[(24)] = inst_65042);

return statearr_65255;
})();
if(inst_65043){
var statearr_65256_65334 = state_65182__$1;
(statearr_65256_65334[(1)] = (18));

} else {
var statearr_65257_65335 = state_65182__$1;
(statearr_65257_65335[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (38))){
var inst_65103 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
var statearr_65258_65336 = state_65182__$1;
(statearr_65258_65336[(2)] = inst_65103);

(statearr_65258_65336[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (30))){
var inst_65076 = (state_65182[(9)]);
var inst_65091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65092 = [inst_65076,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_65093 = (new cljs.core.PersistentVector(null,2,(5),inst_65091,inst_65092,null));
var state_65182__$1 = state_65182;
var statearr_65259_65337 = state_65182__$1;
(statearr_65259_65337[(2)] = inst_65093);

(statearr_65259_65337[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (10))){
var inst_64999 = (state_65182[(21)]);
var inst_65008 = (state_65182[(7)]);
var inst_65023 = (inst_65008 - (1));
var inst_65024 = fluree.db.time_travel.as_of_block.call(null,inst_64999,inst_65023);
var state_65182__$1 = state_65182;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65182__$1,(13),inst_65024);
} else {
if((state_val_65183 === (18))){
var inst_64995 = (state_65182[(16)]);
var inst_65045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65046 = [inst_64995];
var inst_65047 = (new cljs.core.PersistentVector(null,1,(5),inst_65045,inst_65046,null));
var state_65182__$1 = state_65182;
var statearr_65260_65338 = state_65182__$1;
(statearr_65260_65338[(2)] = inst_65047);

(statearr_65260_65338[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (52))){
var state_65182__$1 = state_65182;
var statearr_65261_65339 = state_65182__$1;
(statearr_65261_65339[(2)] = null);

(statearr_65261_65339[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (42))){
var inst_65085 = (state_65182[(12)]);
var inst_65118 = (state_65182[(20)]);
var inst_65117 = (inst_65085 == null);
var inst_65118__$1 = cljs.core.not.call(null,inst_65117);
var state_65182__$1 = (function (){var statearr_65262 = state_65182;
(statearr_65262[(20)] = inst_65118__$1);

return statearr_65262;
})();
if(inst_65118__$1){
var statearr_65263_65340 = state_65182__$1;
(statearr_65263_65340[(1)] = (45));

} else {
var statearr_65264_65341 = state_65182__$1;
(statearr_65264_65341[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (37))){
var inst_65098 = (state_65182[(26)]);
var state_65182__$1 = state_65182;
var statearr_65265_65342 = state_65182__$1;
(statearr_65265_65342[(2)] = inst_65098);

(statearr_65265_65342[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (8))){
var inst_65008 = (state_65182[(7)]);
var state_65182__$1 = state_65182;
var statearr_65266_65343 = state_65182__$1;
(statearr_65266_65343[(2)] = inst_65008);

(statearr_65266_65343[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (49))){
var state_65182__$1 = state_65182;
var statearr_65267_65344 = state_65182__$1;
(statearr_65267_65344[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2726__auto__ = null;
var fluree$db$api_js$state_machine__2726__auto____0 = (function (){
var statearr_65269 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65269[(0)] = fluree$db$api_js$state_machine__2726__auto__);

(statearr_65269[(1)] = (1));

return statearr_65269;
});
var fluree$db$api_js$state_machine__2726__auto____1 = (function (state_65182){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_65182);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e65270){var ex__2729__auto__ = e65270;
var statearr_65271_65345 = state_65182;
(statearr_65271_65345[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_65182[(4)]))){
var statearr_65272_65346 = state_65182;
(statearr_65272_65346[(1)] = cljs.core.first.call(null,(state_65182[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65347 = state_65182;
state_65182 = G__65347;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2726__auto__ = function(state_65182){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2726__auto____1.call(this,state_65182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2726__auto____0;
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2726__auto____1;
return fluree$db$api_js$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_65273 = f__2749__auto__.call(null);
(statearr_65273[(6)] = c__2748__auto__);

return statearr_65273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__65355 = arguments.length;
switch (G__65355) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5753__auto__)){
var block = temp__5753__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4221__auto__ = block;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4221__auto__ = block;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__65348_SHARP_){
return cljs.core.dissoc.call(null,p1__65348_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_65444){
var state_val_65445 = (state_65444[(1)]);
if((state_val_65445 === (7))){
var inst_65395 = (state_65444[(7)]);
var inst_65401 = (state_65444[(8)]);
var inst_65405 = (state_65444[(9)]);
var inst_65398 = (state_65444[(10)]);
var inst_65411 = (function (){var responses = inst_65395;
var responses_STAR_ = inst_65398;
var statuses = inst_65401;
var fuel = inst_65405;
return (function (p1__65351_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__65351_SHARP_);
});
})();
var inst_65412 = cljs.core.some.call(null,inst_65411,inst_65401);
var state_65444__$1 = state_65444;
if(cljs.core.truth_(inst_65412)){
var statearr_65446_65494 = state_65444__$1;
(statearr_65446_65494[(1)] = (9));

} else {
var statearr_65447_65495 = state_65444__$1;
(statearr_65447_65495[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (20))){
var inst_65439 = (state_65444[(2)]);
var state_65444__$1 = state_65444;
var statearr_65448_65496 = state_65444__$1;
(statearr_65448_65496[(2)] = inst_65439);

(statearr_65448_65496[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (1))){
var inst_65390 = cljs.core.async.chan.call(null,(1));
var inst_65391 = (function (){var c__2748__auto____$1 = inst_65390;
return (function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_65388){
var state_val_65389 = (state_65388[(1)]);
if((state_val_65389 === (1))){
var inst_65356 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_65357 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_65358 = cljs.core.assoc.call(null,inst_65357,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_65359 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_65360 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_65361 = cljs.core.PersistentHashMap.EMPTY;
var inst_65362 = inst_65356;
var inst_65363 = inst_65358;
var inst_65364 = inst_65359;
var inst_65365 = inst_65360;
var inst_65366 = inst_65361;
var state_65388__$1 = (function (){var statearr_65449 = state_65388;
(statearr_65449[(7)] = inst_65363);

(statearr_65449[(8)] = inst_65366);

(statearr_65449[(9)] = inst_65365);

(statearr_65449[(10)] = inst_65364);

(statearr_65449[(11)] = inst_65362);

return statearr_65449;
})();
var statearr_65450_65497 = state_65388__$1;
(statearr_65450_65497[(2)] = null);

(statearr_65450_65497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65389 === (2))){
var inst_65363 = (state_65388[(7)]);
var inst_65368 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_65363);
var inst_65369 = cljs.core.merge.call(null,opts,inst_65368);
var inst_65370 = cljs.core.assoc.call(null,inst_65363,new cljs.core.Keyword(null,"opts","opts",155075701),inst_65369);
var inst_65371 = fluree.db.api_js.query_async.call(null,db,inst_65370,db_fn);
var state_65388__$1 = state_65388;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65388__$1,(4),inst_65371);
} else {
if((state_val_65389 === (3))){
var inst_65386 = (state_65388[(2)]);
var state_65388__$1 = state_65388;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65388__$1,inst_65386);
} else {
if((state_val_65389 === (4))){
var inst_65366 = (state_65388[(8)]);
var inst_65364 = (state_65388[(10)]);
var inst_65362 = (state_65388[(11)]);
var inst_65373 = (state_65388[(2)]);
var inst_65374 = cljs.core.assoc.call(null,inst_65366,inst_65362,inst_65373);
var inst_65375 = cljs.core.first.call(null,inst_65364);
var state_65388__$1 = (function (){var statearr_65451 = state_65388;
(statearr_65451[(12)] = inst_65374);

return statearr_65451;
})();
if(cljs.core.truth_(inst_65375)){
var statearr_65452_65498 = state_65388__$1;
(statearr_65452_65498[(1)] = (5));

} else {
var statearr_65453_65499 = state_65388__$1;
(statearr_65453_65499[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65389 === (5))){
var inst_65365 = (state_65388[(9)]);
var inst_65364 = (state_65388[(10)]);
var inst_65374 = (state_65388[(12)]);
var inst_65377 = cljs.core.first.call(null,inst_65364);
var inst_65378 = cljs.core.first.call(null,inst_65365);
var inst_65379 = cljs.core.rest.call(null,inst_65364);
var inst_65380 = cljs.core.rest.call(null,inst_65365);
var inst_65362 = inst_65377;
var inst_65363 = inst_65378;
var inst_65364__$1 = inst_65379;
var inst_65365__$1 = inst_65380;
var inst_65366 = inst_65374;
var state_65388__$1 = (function (){var statearr_65454 = state_65388;
(statearr_65454[(7)] = inst_65363);

(statearr_65454[(8)] = inst_65366);

(statearr_65454[(9)] = inst_65365__$1);

(statearr_65454[(10)] = inst_65364__$1);

(statearr_65454[(11)] = inst_65362);

return statearr_65454;
})();
var statearr_65455_65500 = state_65388__$1;
(statearr_65455_65500[(2)] = null);

(statearr_65455_65500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65389 === (6))){
var inst_65374 = (state_65388[(12)]);
var state_65388__$1 = state_65388;
var statearr_65456_65501 = state_65388__$1;
(statearr_65456_65501[(2)] = inst_65374);

(statearr_65456_65501[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65389 === (7))){
var inst_65384 = (state_65388[(2)]);
var state_65388__$1 = state_65388;
var statearr_65457_65502 = state_65388__$1;
(statearr_65457_65502[(2)] = inst_65384);

(statearr_65457_65502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2726__auto__ = null;
var fluree$db$api_js$state_machine__2726__auto____0 = (function (){
var statearr_65458 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65458[(0)] = fluree$db$api_js$state_machine__2726__auto__);

(statearr_65458[(1)] = (1));

return statearr_65458;
});
var fluree$db$api_js$state_machine__2726__auto____1 = (function (state_65388){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_65388);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e65459){var ex__2729__auto__ = e65459;
var statearr_65460_65503 = state_65388;
(statearr_65460_65503[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_65388[(4)]))){
var statearr_65461_65504 = state_65388;
(statearr_65461_65504[(1)] = cljs.core.first.call(null,(state_65388[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65505 = state_65388;
state_65388 = G__65505;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2726__auto__ = function(state_65388){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2726__auto____1.call(this,state_65388);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2726__auto____0;
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2726__auto____1;
return fluree$db$api_js$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_65462 = f__2749__auto__.call(null);
(statearr_65462[(6)] = c__2748__auto____$1);

return statearr_65462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
});
})();
var inst_65392 = cljs.core.async.impl.dispatch.run.call(null,inst_65391);
var state_65444__$1 = (function (){var statearr_65463 = state_65444;
(statearr_65463[(11)] = inst_65392);

return statearr_65463;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65444__$1,(2),inst_65390);
} else {
if((state_val_65445 === (4))){
var inst_65395 = (state_65444[(7)]);
var state_65444__$1 = state_65444;
var statearr_65464_65506 = state_65444__$1;
(statearr_65464_65506[(2)] = inst_65395);

(statearr_65464_65506[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (15))){
var state_65444__$1 = state_65444;
var statearr_65465_65507 = state_65444__$1;
(statearr_65465_65507[(2)] = (400));

(statearr_65465_65507[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (13))){
var state_65444__$1 = state_65444;
var statearr_65466_65508 = state_65444__$1;
(statearr_65466_65508[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (6))){
var inst_65401 = (state_65444[(8)]);
var inst_65409 = cljs.core.first.call(null,inst_65401);
var state_65444__$1 = state_65444;
var statearr_65468_65509 = state_65444__$1;
(statearr_65468_65509[(2)] = inst_65409);

(statearr_65468_65509[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (17))){
var inst_65422 = (state_65444[(2)]);
var state_65444__$1 = state_65444;
var statearr_65469_65510 = state_65444__$1;
(statearr_65469_65510[(2)] = inst_65422);

(statearr_65469_65510[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (3))){
var inst_65395 = (state_65444[(7)]);
var inst_65401 = (state_65444[(8)]);
var inst_65405 = (state_65444[(9)]);
var inst_65398 = (state_65444[(10)]);
var inst_65400 = cljs.core.vals.call(null,inst_65395);
var inst_65401__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65400);
var inst_65402 = (function (){var responses = inst_65395;
var responses_STAR_ = inst_65398;
var statuses = inst_65401__$1;
return (function (p1__65349_SHARP_){
var or__4223__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__65349_SHARP_);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
});
})();
var inst_65403 = cljs.core.vals.call(null,inst_65395);
var inst_65404 = cljs.core.map.call(null,inst_65402,inst_65403);
var inst_65405__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_65404);
var inst_65406 = (function (){var responses = inst_65395;
var responses_STAR_ = inst_65398;
var statuses = inst_65401__$1;
var fuel = inst_65405__$1;
return (function (p1__65350_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__65350_SHARP_);
});
})();
var inst_65407 = cljs.core.every_QMARK_.call(null,inst_65406,inst_65401__$1);
var state_65444__$1 = (function (){var statearr_65470 = state_65444;
(statearr_65470[(8)] = inst_65401__$1);

(statearr_65470[(9)] = inst_65405__$1);

return statearr_65470;
})();
if(inst_65407){
var statearr_65471_65511 = state_65444__$1;
(statearr_65471_65511[(1)] = (6));

} else {
var statearr_65472_65512 = state_65444__$1;
(statearr_65472_65512[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (12))){
var state_65444__$1 = state_65444;
var statearr_65473_65513 = state_65444__$1;
(statearr_65473_65513[(2)] = (500));

(statearr_65473_65513[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (2))){
var inst_65395 = (state_65444[(7)]);
var inst_65394 = (state_65444[(2)]);
var inst_65395__$1 = fluree.db.util.async.throw_err.call(null,inst_65394);
var inst_65396 = (function (){var responses = inst_65395__$1;
return (function (acc,index,response){
var resp = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_65397 = cljs.core.PersistentHashMap.EMPTY;
var inst_65398 = cljs.core.reduce_kv.call(null,inst_65396,inst_65397,inst_65395__$1);
var state_65444__$1 = (function (){var statearr_65474 = state_65444;
(statearr_65474[(7)] = inst_65395__$1);

(statearr_65474[(10)] = inst_65398);

return statearr_65474;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_65475_65514 = state_65444__$1;
(statearr_65475_65514[(1)] = (3));

} else {
var statearr_65476_65515 = state_65444__$1;
(statearr_65476_65515[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (19))){
var inst_65405 = (state_65444[(9)]);
var inst_65398 = (state_65444[(10)]);
var inst_65428 = (state_65444[(12)]);
var inst_65437 = cljs.core.assoc.call(null,inst_65398,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65428,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_65405);
var state_65444__$1 = state_65444;
var statearr_65477_65516 = state_65444__$1;
(statearr_65477_65516[(2)] = inst_65437);

(statearr_65477_65516[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (11))){
var inst_65426 = (state_65444[(2)]);
var state_65444__$1 = state_65444;
var statearr_65478_65517 = state_65444__$1;
(statearr_65478_65517[(2)] = inst_65426);

(statearr_65478_65517[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (9))){
var state_65444__$1 = state_65444;
var statearr_65479_65518 = state_65444__$1;
(statearr_65479_65518[(2)] = (207));

(statearr_65479_65518[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (5))){
var inst_65442 = (state_65444[(2)]);
var state_65444__$1 = state_65444;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65444__$1,inst_65442);
} else {
if((state_val_65445 === (14))){
var inst_65424 = (state_65444[(2)]);
var state_65444__$1 = state_65444;
var statearr_65480_65519 = state_65444__$1;
(statearr_65480_65519[(2)] = inst_65424);

(statearr_65480_65519[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (16))){
var state_65444__$1 = state_65444;
var statearr_65481_65520 = state_65444__$1;
(statearr_65481_65520[(2)] = null);

(statearr_65481_65520[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (10))){
var inst_65395 = (state_65444[(7)]);
var inst_65401 = (state_65444[(8)]);
var inst_65405 = (state_65444[(9)]);
var inst_65398 = (state_65444[(10)]);
var inst_65415 = (function (){var responses = inst_65395;
var responses_STAR_ = inst_65398;
var statuses = inst_65401;
var fuel = inst_65405;
return (function (p1__65352_SHARP_){
return ((499) < p1__65352_SHARP_);
});
})();
var inst_65416 = cljs.core.some.call(null,inst_65415,inst_65401);
var state_65444__$1 = state_65444;
if(cljs.core.truth_(inst_65416)){
var statearr_65482_65521 = state_65444__$1;
(statearr_65482_65521[(1)] = (12));

} else {
var statearr_65483_65522 = state_65444__$1;
(statearr_65483_65522[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (18))){
var inst_65433 = (state_65444[(13)]);
var inst_65405 = (state_65444[(9)]);
var inst_65398 = (state_65444[(10)]);
var inst_65428 = (state_65444[(12)]);
var inst_65435 = cljs.core.assoc.call(null,inst_65398,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65428,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_65405,new cljs.core.Keyword(null,"block","block",664686210),inst_65433);
var state_65444__$1 = state_65444;
var statearr_65484_65523 = state_65444__$1;
(statearr_65484_65523[(2)] = inst_65435);

(statearr_65484_65523[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65445 === (8))){
var inst_65433 = (state_65444[(13)]);
var inst_65395 = (state_65444[(7)]);
var inst_65401 = (state_65444[(8)]);
var inst_65405 = (state_65444[(9)]);
var inst_65398 = (state_65444[(10)]);
var inst_65428 = (state_65444[(12)]);
var inst_65428__$1 = (state_65444[(2)]);
var inst_65429 = (function (){var responses = inst_65395;
var responses_STAR_ = inst_65398;
var statuses = inst_65401;
var fuel = inst_65405;
var status = inst_65428__$1;
return (function (p1__65353_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__65353_SHARP_));
});
})();
var inst_65430 = cljs.core.vals.call(null,inst_65395);
var inst_65431 = cljs.core.filter.call(null,inst_65429,inst_65430);
var inst_65432 = cljs.core.first.call(null,inst_65431);
var inst_65433__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_65432);
var state_65444__$1 = (function (){var statearr_65485 = state_65444;
(statearr_65485[(13)] = inst_65433__$1);

(statearr_65485[(12)] = inst_65428__$1);

return statearr_65485;
})();
if(cljs.core.truth_(inst_65433__$1)){
var statearr_65486_65524 = state_65444__$1;
(statearr_65486_65524[(1)] = (18));

} else {
var statearr_65487_65525 = state_65444__$1;
(statearr_65487_65525[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2726__auto__ = null;
var fluree$db$api_js$state_machine__2726__auto____0 = (function (){
var statearr_65488 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65488[(0)] = fluree$db$api_js$state_machine__2726__auto__);

(statearr_65488[(1)] = (1));

return statearr_65488;
});
var fluree$db$api_js$state_machine__2726__auto____1 = (function (state_65444){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_65444);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e65489){var ex__2729__auto__ = e65489;
var statearr_65490_65526 = state_65444;
(statearr_65490_65526[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_65444[(4)]))){
var statearr_65491_65527 = state_65444;
(statearr_65491_65527[(1)] = cljs.core.first.call(null,(state_65444[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65528 = state_65444;
state_65444 = G__65528;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2726__auto__ = function(state_65444){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2726__auto____1.call(this,state_65444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2726__auto____0;
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2726__auto____1;
return fluree$db$api_js$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_65492 = f__2749__auto__.call(null);
(statearr_65492[(6)] = c__2748__auto__);

return statearr_65492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__65530 = arguments.length;
switch (G__65530) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__65531 = opts;
var map__65531__$1 = cljs.core.__destructure_map.call(null,map__65531);
var auth = cljs.core.get.call(null,map__65531__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__65531__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__65531__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__65531__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__65532 = (cljs.core.truth_((function (){var and__4221__auto__ = auth;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4221__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__65532,(0),null);
var authority = cljs.core.nth.call(null,vec__65532,(1),null);
var action__$1 = (function (){var or__4223__auto__ = action;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4223__auto__ = nonce;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4223__auto__ = expire;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e65535){var e = e65535;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__65538 = arguments.length;
switch (G__65538) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_65569){
var state_val_65570 = (state_65569[(1)]);
if((state_val_65570 === (7))){
var state_65569__$1 = state_65569;
var statearr_65571_65592 = state_65569__$1;
(statearr_65571_65592[(2)] = opts);

(statearr_65571_65592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65570 === (1))){
var state_65569__$1 = state_65569;
var statearr_65572_65593 = state_65569__$1;
(statearr_65572_65593[(2)] = null);

(statearr_65572_65593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65570 === (4))){
var inst_65539 = (state_65569[(2)]);
var inst_65540 = fluree.db.util.log.error.call(null,inst_65539);
var inst_65541 = cljs.core.ex_data.call(null,inst_65539);
var inst_65542 = cljs.core.ex_message.call(null,inst_65539);
var inst_65543 = cljs.core.assoc.call(null,inst_65541,new cljs.core.Keyword(null,"message","message",-406056002),inst_65542);
var state_65569__$1 = (function (){var statearr_65573 = state_65569;
(statearr_65573[(7)] = inst_65540);

return statearr_65573;
})();
var statearr_65574_65594 = state_65569__$1;
(statearr_65574_65594[(2)] = inst_65543);

(statearr_65574_65594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65570 === (6))){
var inst_65553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65554 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_65555 = (new cljs.core.PersistentVector(null,1,(5),inst_65553,inst_65554,null));
var inst_65556 = cljs.core.assoc_in.call(null,opts,inst_65555,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65569__$1 = state_65569;
var statearr_65575_65595 = state_65569__$1;
(statearr_65575_65595[(2)] = inst_65556);

(statearr_65575_65595[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65570 === (3))){
var inst_65567 = (state_65569[(2)]);
var state_65569__$1 = state_65569;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65569__$1,inst_65567);
} else {
if((state_val_65570 === (2))){
var _ = (function (){var statearr_65577 = state_65569;
(statearr_65577[(4)] = cljs.core.cons.call(null,(5),(state_65569[(4)])));

return statearr_65577;
})();
var inst_65549 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65550 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65551 = (inst_65550 == null);
var state_65569__$1 = (function (){var statearr_65578 = state_65569;
(statearr_65578[(8)] = inst_65549);

return statearr_65578;
})();
if(cljs.core.truth_(inst_65551)){
var statearr_65579_65596 = state_65569__$1;
(statearr_65579_65596[(1)] = (6));

} else {
var statearr_65580_65597 = state_65569__$1;
(statearr_65580_65597[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65570 === (9))){
var inst_65563 = (state_65569[(2)]);
var inst_65564 = fluree.db.util.async.throw_err.call(null,inst_65563);
var _ = (function (){var statearr_65581 = state_65569;
(statearr_65581[(4)] = cljs.core.rest.call(null,(state_65569[(4)])));

return statearr_65581;
})();
var state_65569__$1 = state_65569;
var statearr_65582_65598 = state_65569__$1;
(statearr_65582_65598[(2)] = inst_65564);

(statearr_65582_65598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65570 === (5))){
var _ = (function (){var statearr_65583 = state_65569;
(statearr_65583[(4)] = cljs.core.rest.call(null,(state_65569[(4)])));

return statearr_65583;
})();
var state_65569__$1 = state_65569;
var ex65576 = (state_65569__$1[(2)]);
var statearr_65584_65599 = state_65569__$1;
(statearr_65584_65599[(5)] = ex65576);


var statearr_65585_65600 = state_65569__$1;
(statearr_65585_65600[(1)] = (4));

(statearr_65585_65600[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65570 === (8))){
var inst_65549 = (state_65569[(8)]);
var inst_65559 = (state_65569[(2)]);
var inst_65560 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_65549,inst_65559);
var inst_65561 = fluree.db.operations.command_async.call(null,conn,inst_65560);
var state_65569__$1 = state_65569;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65569__$1,(9),inst_65561);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2726__auto__ = null;
var fluree$db$api_js$state_machine__2726__auto____0 = (function (){
var statearr_65586 = [null,null,null,null,null,null,null,null,null];
(statearr_65586[(0)] = fluree$db$api_js$state_machine__2726__auto__);

(statearr_65586[(1)] = (1));

return statearr_65586;
});
var fluree$db$api_js$state_machine__2726__auto____1 = (function (state_65569){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_65569);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e65587){var ex__2729__auto__ = e65587;
var statearr_65588_65601 = state_65569;
(statearr_65588_65601[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_65569[(4)]))){
var statearr_65589_65602 = state_65569;
(statearr_65589_65602[(1)] = cljs.core.first.call(null,(state_65569[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65603 = state_65569;
state_65569 = G__65603;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2726__auto__ = function(state_65569){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2726__auto____1.call(this,state_65569);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2726__auto____0;
fluree$db$api_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2726__auto____1;
return fluree$db$api_js$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_65590 = f__2749__auto__.call(null);
(statearr_65590[(6)] = c__2748__auto__);

return statearr_65590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

